&lt;flag-icon&gt;
===========

A collection of SVG flags, conveniently usable as a Polymer Web Component.

If you don't care about extra features, a simple CSS implementation of country flags can be found at https://github.com/lipis/flag-icon-css


Typical file sizes:

> **SVG** files: **2kb** to **75kb**

> **PNG** files: 16x11 < **1kb**, 36x27 < **2kb**, 75x56 < **5kb**, 225x168 < **20kb**

### [Countries](http://files.stevenskelton.ca/flag-icon/flag-icon/examples/countries.html)

_Tiny 16 x 11 PNG icons_

![Canada](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/ca.png "Canada")
![Korea](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/kr.png "Korea")
![Germany](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/de.png "Germany")
![Australia](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/au.png "Australia")
![France](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/fr.png "France")
![European Union](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/europeanunion.png "European Union")
![Angola](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/ao.png "Angola")
![Belgium](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/be.png "Belgium")
![Austria](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/at.png "Austria")
![Mozambique](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/mz.png "Mozambique")
![Norway](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/no.png "Norway")
![Philippines](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/ph.png "Philippines")
![Spain](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/es.png "Spain")
![United Kingdom](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/gb.png "United Kingdom")
![India](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/in.png "India")
![Costa Rica](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/cr.png "Costa Rica")
![South Africa](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/za.png "South Africa")
![Thailand](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/th.png "Thailand")
![Sri Lanka](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/lk.png "Sri Lanka")
![Sweden](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/se.png "Sweden")
![Slovenia](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/si.png "Slovenia")
![Papua New Guinea](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/pg.png "Papua New Guinea")
![Maldives](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/mv.png "Maldives")
![United States](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/us.png "United States")
![Japan](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/jp.png "Japan")
![Ireland](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/ie.png "Ireland")
![Bermuda](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/bm.png "Bermuda")
![Isle of Man](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/im.png "Isle of Man")
![Montenegro](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/me.png "Montenegro")
![Norfolk Island](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/nf.png "Norfolk Island")
![Italy](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/it.png "Italy")
![Brazil](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/br.png "Brazil")
![Iceland](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/is.png "Iceland")
![Puerto Rico](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/pr.png "Puerto Rico")
![Venezuela](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/ve.png "Venezuela")
![Saint Lucia](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/lc.png "Saint Lucia")
![Russian Federation](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/ru.png "Russian Federation")
![Poland](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/pl.png "Poland")
![Netherlands](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/nl.png "Netherlands")
![China](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/cn.png "China")
![Vietnam](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/vn.png "Vietnam")
![Mexico](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/mx.png "Mexico")
![Fiji](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/fj.png "Fiji")
![Gabon](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/ga.png "Gabon")
![Greece](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/gr.png "Greece")
![Grenada](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/gd.png "Grenada")
![Iraq](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/iq.png "Iraq")
![Israel](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/il.png "Israel")
![Kenya](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/ke.png "Kenya")
![Kiribati](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/ki.png "Kiribati")
![Latvia](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/lv.png "Latvia")
![Liechtenstein](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/li.png "Liechtenstein")
![Luxembourg](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/lu.png "Luxembourg")
![Macedonia](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/mk.png "Macedonia")
![Malta](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/mt.png "Malta")
![Micronesia](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/fm.png "Miconesia")
![Martinique](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/mq.png "Martinique")
![Mayotte](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/yt.png "Mayotte")
![Nigeria](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/ng.png "Nigeria")
![New Caledonia](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/nc.png "New Caledonia")
![Oman](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/om.png "Oman")
![Panama](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/pa.png "Panama")
![Peru](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/pe.png "Peru")
![Qatar](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/qa.png "Qatar")
![Samoa](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/ws.png "Samoa")
![Cabo Verde](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/cv.png "Cabo Verde")
![Syria](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/sy.png "Syria")
![Thailand](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/th.png "Thailand")
![Ukraine](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/ua.png "Ukraine")
![Bulgaria](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/bg.png "Bulgaria")
![Burkina Faso](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/bf.png "Burkina Faso")
![United Nations](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/unitednations.png "United Nations")

_4:3 ratio SVG_

![Canada](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/country-4x3/ca.png "Canada")
![Korea](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/country-4x3/kr.png "Korea")
![Germany](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/country-4x3/de.png "Germany")
![Australia](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/country-4x3/au.png "Australia")
![France](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/country-4x3/fr.png "France")
![United States](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/country-4x3/us.png "United States")
![Norway](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/country-4x3/no.png "Norway")
![Philippines](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/country-4x3/ph.png "Philippines")
![Spain](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/country-4x3/es.png "Spain")

_Square ratio SVG_

![Canada](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/country-squared/ca.png "Canada")
![Korea](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/country-squared/kr.png "Korea")
![Germany](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/country-squared/de.png "Germany")
![Australia](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/country-squared/au.png "Australia")
![France](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/country-squared/fr.png "France")
![United States](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/country-squared/us.png "United States")
![Norway](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/country-squared/no.png "Norway")
![Philippines](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/country-squared/ph.png "Philippines")
![Spain](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/country-squared/es.png "Spain")

### States and Provinces

#### [United States](http://files.stevenskelton.ca/flag-icon/flag-icon/examples/us-states.html)
![California](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/us/california.png "California")
![Delaware](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/us/delaware.png "Delaware")
![Florida](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/us/florida.png "Florida")
![Illinois](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/us/illinois.png "Illinois")
![Maine](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/us/maine.png "Maine")
![Michigan](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/us/michigan.png "Michigan")
![Nevada](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/us/nevada.png "Nevada")
![North Carolina](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/us/north_carolina.png "North Carolina")
![Texas](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/us/texas.png "Texas")

#### [Australia](http://files.stevenskelton.ca/flag-icon/flag-icon/examples/canada-australia.html)
![Australian Capital Territory](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/au/australian_capital_territory.png "Australian Capital Territory")
![New South Wales](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/au/new_south_wales.png "New South Wales")
![Northern Territory](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/au/northern_territory.png "Northern Territory")
![Queensland](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/au/queensland.png "Queensland")
![South Australia](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/au/south_australia.png "South Australia")
![Tasmania](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/au/tasmania.png "Tasmania")
![Victoria](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/au/victoria.png "Victoria")
![Western Australia](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/au/western_australia.png "Western Australia")

#### [Brazil](http://files.stevenskelton.ca/flag-icon/flag-icon/examples/brazil.html)
![Rio de Janeiro](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/br/rio_de_janeiro.png "Rio de Janeiro")
![Rio Grande do Norte](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/br/rio_grande_do_norte.png "Rio Grande do Norte")
![Rio Grande do Sul](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/br/rio_grande_do_sul.png "Rio Grande do Sul")
![Rondônia](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/br/rondônia.png "Rondônia")
![Roraima](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/br/roraima.png "Roraima")
![Santa Catarina](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/br/santa_catarina.png "Santa Catarina")
![São Paulo](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/br/são_paulo.png "São Paulo")
![Sergipe](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/br/sergipe.png "Sergipe")
![tocantins](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/br/tocantins.png "Tocantins")

#### [Canada](http://files.stevenskelton.ca/flag-icon/flag-icon/examples/canada-australia.html)
![Alberta](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/ca/alberta.png "Alberta")
![British Columbia](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/ca/british_columbia.png "British Columbia")
![Manitoba](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/ca/manitoba.png "Manitoba")
![New Brunswick](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/ca/new_brunswick.png "New Brunswick")
![Newfoundland and Labrador](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/ca/newfoundland_and_labrador.png "Newfoundland and Labrador")
![Northwest Territories](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/ca/northwest_territories.png "Northwest Territories")
![Nova Scotia](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/ca/nova_scotia.png "Nova Scotia")
![Nunavut](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/ca/nunavut.png "Nunavut")
![Québec'](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/ca/québec.png "Québec")

#### [Germany](http://files.stevenskelton.ca/flag-icon/flag-icon/examples/germany.html)
![Brandenburg](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/de/brandenburg.png "Brandenburg")
![Berlin](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/de/berlin.png "Berlin")
![Rhineland-Palatinate](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/de/rhineland-palatinate.png "Rhineland-Palatinate")
![Saarland](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/de/saarland.png "Saarland")
![Hamburg](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/de/hamburg.png "Hamburg")
![Lower Saxony](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/de/lower_saxony.png "Lower Saxony")
![Saxony](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/de/saxony.png "Saxony")
![Schleswig-Holstein](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/de/schleswig-holstein.png "Schleswig-Holstein")
![Thuringia](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/de/thuringia.png "Thuringia")

#### [Spain](http://files.stevenskelton.ca/flag-icon/flag-icon/examples/spain.html)
![Andalucía](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/es/andalucía.png "Andalucía")
![Aragón](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/es/aragón.png "Aragón")
![Asturias](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/es/asturias.png "Asturias")
![Balearic Islands](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/es/balearic_islands.png "Balearic Islands")
![Basque Country](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/es/basque_country.png "Basque Country")
![Canary Islands](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/es/canary_islands.png "Canary Islands")
![Cantabria](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/es/cantabria.png "Cantabria")
![Castile and León](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/es/castile_and_león.png "Castile and León")
![La Rioja](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/es/la_rioja.png "La Rioja")

#### [Russia](http://files.stevenskelton.ca/flag-icon/flag-icon/examples/russia.html)
![Adygea](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/ru/adygea.png "Adygea")
![Buryatia](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/ru/buryatia.png "Buryatia")
![Chuvashia](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/ru/chuvashia.png "Chuvashia")
![Ingushetia](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/ru/ingushetia.png "Ingushetia")
![Tuva](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/ru/tuva.png "Tuva")
![Kamchatka](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/ru/kamchatka.png "Kamchatka")
![Stavropol](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/ru/stavropol.png "Stavropol")
![Belgorod](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/ru/belgorod.png "Belgorod")
![Novgorod](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/ru/novgorod.png "Novgorod")

### [NASCAR, IndyCar](http://files.stevenskelton.ca/flag-icon/flag-icon/examples/racing.html)
![Green](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/racing/green.png "Green")
![Yellow](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/racing/yellow.png "Yellow")
![Black](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/racing/black.png "Black")
![Yellow Saltire](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/racing/yellowsaltire.png "Yellow Saltire")
![Yellow Slash](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/racing/yellowslash.png "Yellow Slash")
![Black White Per Bend](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/racing/blackwhiteperbend.png "Black White Per Bend")
![Vertical Stripes](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/racing/verticalstripes.png "Vertical Stripes")
![Orange Circle](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/racing/orangecircle.png "Orange Circle")
![Checkered](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/racing/checkered.png "Checkered")

### [Maritime and International Code of Signals](http://files.stevenskelton.ca/flag-icon/flag-icon/examples/maritime.html)
![Charlie](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/maritime/c.png "Charlie")
![Alpha](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/maritime/a.png "Alpha")
![Romeo](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/maritime/r.png "Romeo")
![November](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/maritime/n.png "November")
![Oscar](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/maritime/o.png "Oscar")
![Victor](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/maritime/v.png "Victor")
![Lima](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/maritime/l.png "Lima")
![1](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/maritime/1.png "1")
![3](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/75/maritime/3.png "3")


* Images come from [famfamfam](http://www.famfamfam.com/lab/icons/flags/) icon library, or generated from SVG.
* SVGs come from [Wikimedia Commons](http://commons.wikimedia.org/wiki/Category:SVG_sovereign_state_flags).
* PNGs are compacted using [pngcrush](http://en.wikipedia.org/wiki/Pngcrush).
* [ISO 3166-1 Country Code](http://en.wikipedia.org/wiki/ISO_3166-1) list is available on Wikipedia.

## Demos

> [Live Demo - General Use](http://files.stevenskelton.ca/flag-icon/flag-icon/examples/index.html)

> [Live Demo - Themes and Popover](http://files.stevenskelton.ca/flag-icon/flag-icon/examples/themes.html)

## Usage

1. Add the library using the Javascript package manager [Bower](http://bower.io/):

	```bower install --save flag-icon```

2. Import Web Components' polyfill:

	```html
	<script src="bower_components/webcomponentsjs/webcomponents.min.js"></script>
	```

3. Import Custom Element:

	```html
	<link rel="import" href="bower_components/flag-icon/flag-icon.html">
	```

4. Start using it!

	```html
	<flag-icon key="ca"></flag-icon>
	<flag-icon key="canada"></flag-icon>
	<flag-icon key="124"></flag-icon>
	<!-- specify to use PNGs -->
	<flag-icon key="ca" img></flag-icon>
	<!-- specify a specific size -->
	<flag-icon key="ca" width="100"></flag-icon>

	<!-- Specify alt & title text,
	     otherwise it defaults to the official country name -->
	<flag-icon key="can">Flag of Canada</flag-icon>
	```

5. Or use it unrendered in scripts:

	```javascript
	var f = new FlagIcon();

	//get country info
	f.findCountry('canada')
	//> { name: 'Canada', alpha2: 'CA', alpha3: 'CAN', numeric: 124 }

	//convert between 2 -> 3 letter character codes
	f.findCountry('ca').alpha3
	//> 'CAN'

	//get full names of states or provinces
	f.findUSState('ca')
	//> { name: 'California', iso: 'US-CA', alpha2: 'CA', numeric: 6, gpo: 'Calif.' }

	f.findCanadianProvince('ON')
	//> { name: 'Ontario', alpha2: 'ON' }
	```

## Options

Attribute	| Type			| Default	| Description
---			| ---			| ---		| ---
`key`		| *string*		| `null`	| Proper, common, ISO 3166-1 alpha-2, alpha-3, or country code
`img`		| *attribute*	| `false`	| Use PNGs instead of larger filesize SVG
`width`		| *integer*		| `16`		| Width of icon (aspect ratio maintained if `height` omitted).
`height`	| *integer*		| _auto_	| Height of icon (aspect ratio maintained if `width` omitted).
`au`		| *boolean*		| `false`	| ![Australia](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/au.png "Australia") Australian State flags
`br`		| *boolean*		| `false`	| ![Brazil](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/br.png "Brazil") Brazilian State flags
`ca`		| *boolean*		| `false`	| ![Canada](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/ca.png "Canada") Canadian Province and Territory flags
`de`		| *boolean*		| `false`	| ![Germany](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/de.png "Germany") German State flags
`es`		| *boolean*		| `false`	| ![Spain](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/es.png "Spain") Spain Autonomous Community flags
`ru`		| *boolean*		| `false`	| ![Russia](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/ru.png "Russia") Russian Republics, Krais, and Oblast flags
`us`		| *boolean*		| `false`	| ![United States](https://raw.githubusercontent.com/stevenrskelton/flag-icon/master/png/16/country-4x3/us.png "United States") US State flags
`maritime`	| *boolean*		| `false`	| Maritime and ICS flags
`racing`	| *boolean*		| `false`	| NASCAR and IndyCar racing flags
`square`	| *boolean*		| `false`	| Use square version instead of 4:3 aspect (only valid for country flags)
`aspect`	| *float*		| 			| Override aspect ratio used to render the flag

## Aspect Ratios for Flags

Flags come in all different shapes and sizes, attempts were made to standardize to the following aspect ratios (width:height)

Attribute		| Aspect
---				| ---
Country			| 4:3
Austrialia		| 2:1
Brazil			| 3:2
Canada			| 2:1
Germany			| 5:3
Spain			| 3:2
US				| 3:2
Russia			| 3:2
NASCAR, IndyCar	| 4:3
Maritime		| 1:1

## Todo

- Loading notification, or default image.
- Compact/minify SVG files

## History

For detailed changelog, check [Releases](https://github.com/stevenrskelton/flag-icon/releases).

## License

[MIT License](http://opensource.org/licenses/MIT) © Steven Skelton
