
# Contributing

When contributing to this repository, please first discuss the change you wish to make on gitter, or with an issue to increase your chances of getting your pull request merged into the main code base.


## Pull Request Process

When you want to make contributions to the project, the process is pretty simple:

1. Discuss in an issue or on gitter what you'd like to change
2. Fork the repository to make your own local copy
3. Make a branch in the format of <issue-number>-<friendly-name>. So for example if I made an issue to change the default color, and it was issue 385 (random) on the repo, the branch would be called `385-change-default-color`
4. Make the changes to the src and perhaps make a playground by duplicating the playgrounds we already have.
    - Build the code during the development process with `npm run build:dev` so that we don't throw a huge number of pointless errors
    - When you're done making changes, run `npm run build` to build the code and run the linter
5. If applicable - please write new tests, we like to keep our code well tested 🎉. Run the tests by either opening the SpecRunner.html file or just run `npm test`, either is fine.
6. Push the code and make a pull request on the main svg.js repo
7. Enjoy our endless love and gratitude ❤️

Seriously, we love pull requests! So go wild!


## Code of Conduct

We only have a few simple rules, because we know you wouldn't want to read a whole code of conduct guide now would you? 🤡

- don't say anything you wouldn't want said to you
- If you think you can help, then we'd love it if you did! 😃
- Respect everybody
- NEVER be rude

If the contributors feel like you're doing anything rude, we have the right to delete/report your posts. So please just treat everybody nicely, and we can all be great friends!
