# @turf/boolean-point-on-line

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## booleanPointOnLine

Returns true if a point is on a line. Accepts a optional parameter to ignore the start and end vertices of the linestring.

**Parameters**

-   `pt` **[Coord](https://tools.ietf.org/html/rfc7946#section-3.1.1)** GeoJSON Point
-   `line` **[Feature](https://tools.ietf.org/html/rfc7946#section-3.2)&lt;[LineString](https://tools.ietf.org/html/rfc7946#section-3.1.4)>** GeoJSON LineString
-   `options` **[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** Optional parameters (optional, default `{}`)
    -   `options.ignoreEndVertices` **[boolean](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Boolean)** whether to ignore the start and end vertices. (optional, default `false`)

**Examples**

```javascript
var pt = turf.point([0, 0]);
var line = turf.lineString([[-1, -1],[1, 1],[1.5, 2.2]]);
var isPointOnLine = turf.booleanPointOnLine(pt, line);
//=true
```

Returns **[boolean](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Boolean)** true/false

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/boolean-point-on-line
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
