# @turf/center-mean

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## centerMean

Takes a [Feature](https://tools.ietf.org/html/rfc7946#section-3.2) or [FeatureCollection](https://tools.ietf.org/html/rfc7946#section-3.3) and returns the mean center. Can be weighted.

**Parameters**

-   `geojson` **[GeoJSON](https://tools.ietf.org/html/rfc7946#section-3)** GeoJSON to be centered
-   `options` **[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** Optional parameters (optional, default `{}`)
    -   `options.properties` **[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** an Object that is used as the [Feature](https://tools.ietf.org/html/rfc7946#section-3.2)'s properties (optional, default `{}`)
    -   `options.weight` **[number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)?** the property name used to weight the center

**Examples**

```javascript
var features = turf.featureCollection([
  turf.point([-97.522259, 35.4691], {weight: 10}),
  turf.point([-97.502754, 35.463455], {weight: 3}),
  turf.point([-97.508269, 35.463245], {weight: 5})
]);

var options = {weight: "weight"}
var mean = turf.centerMean(features, options);

//addToMap
var addToMap = [features, mean]
mean.properties['marker-size'] = 'large';
mean.properties['marker-color'] = '#000';
```

Returns **[Feature](https://tools.ietf.org/html/rfc7946#section-3.2)&lt;[Point](https://tools.ietf.org/html/rfc7946#section-3.1.2)>** a Point feature at the mean center point of all input features

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/center-mean
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
