# @turf/convex

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## convex

Takes a [Feature](https://tools.ietf.org/html/rfc7946#section-3.2) or a [FeatureCollection](https://tools.ietf.org/html/rfc7946#section-3.3) and returns a convex hull [Polygon](https://tools.ietf.org/html/rfc7946#section-3.1.6).

Internally this uses
the [convex-hull](https://github.com/mikolalysenko/convex-hull) module that
implements a [monotone chain hull](http://en.wikibooks.org/wiki/Algorithm_Implementation/Geometry/Convex_hull/Monotone_chain).

**Parameters**

-   `geojson` **[GeoJSON](https://tools.ietf.org/html/rfc7946#section-3)** input Feature or FeatureCollection
-   `options` **[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** Optional parameters (optional, default `{}`)
    -   `options.concavity` **[number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)** 1 - thin shape. Infinity - convex hull. (optional, default `Infinity`)

**Examples**

```javascript
var points = turf.featureCollection([
  turf.point([10.195312, 43.755225]),
  turf.point([10.404052, 43.8424511]),
  turf.point([10.579833, 43.659924]),
  turf.point([10.360107, 43.516688]),
  turf.point([10.14038, 43.588348]),
  turf.point([10.195312, 43.755225])
]);

var hull = turf.convex(points);

//addToMap
var addToMap = [points, hull]
```

Returns **[Feature](https://tools.ietf.org/html/rfc7946#section-3.2)&lt;[Polygon](https://tools.ietf.org/html/rfc7946#section-3.1.6)>** a convex hull

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/convex
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
