# @turf/line-segment

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## lineSegment

Creates a [FeatureCollection](https://tools.ietf.org/html/rfc7946#section-3.3) of 2-vertex [LineString](https://tools.ietf.org/html/rfc7946#section-3.1.4) segments from a [(Multi)LineString](https://tools.ietf.org/html/rfc7946#section-3.1.4) or [(Multi)Polygon](https://tools.ietf.org/html/rfc7946#section-3.1.6).

**Parameters**

-   `geojson` **([Geometry](https://tools.ietf.org/html/rfc7946#section-3.1) \| [FeatureCollection](https://tools.ietf.org/html/rfc7946#section-3.3) \| [Feature](https://tools.ietf.org/html/rfc7946#section-3.2)&lt;([LineString](https://tools.ietf.org/html/rfc7946#section-3.1.4) \| [MultiLineString](https://tools.ietf.org/html/rfc7946#section-3.1.5) \| [MultiPolygon](https://tools.ietf.org/html/rfc7946#section-3.1.7) \| [Polygon](https://tools.ietf.org/html/rfc7946#section-3.1.6))>)** GeoJSON Polygon or LineString

**Examples**

```javascript
var polygon = turf.polygon([[[-50, 5], [-40, -10], [-50, -10], [-40, 5], [-50, 5]]]);
var segments = turf.lineSegment(polygon);

//addToMap
var addToMap = [polygon, segments]
```

Returns **[FeatureCollection](https://tools.ietf.org/html/rfc7946#section-3.3)&lt;[LineString](https://tools.ietf.org/html/rfc7946#section-3.1.4)>** 2-vertex line segments

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/line-segment
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
