# @turf/line-to-polygon

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## lineToPolygon

Converts (Multi)LineString(s) to Polygon(s).

**Parameters**

-   `lines` **([FeatureCollection](https://tools.ietf.org/html/rfc7946#section-3.3) \| [Feature](https://tools.ietf.org/html/rfc7946#section-3.2)&lt;([LineString](https://tools.ietf.org/html/rfc7946#section-3.1.4) \| [MultiLineString](https://tools.ietf.org/html/rfc7946#section-3.1.5))>)** Features to convert
-   `options` **[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** Optional parameters (optional, default `{}`)
    -   `options.properties` **[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** translates GeoJSON properties to Feature (optional, default `{}`)
    -   `options.autoComplete` **[boolean](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Boolean)** auto complete linestrings (matches first & last coordinates) (optional, default `true`)
    -   `options.orderCoords` **[boolean](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Boolean)** sorts linestrings to place outer ring at the first position of the coordinates (optional, default `true`)

**Examples**

```javascript
var line = turf.lineString([[125, -30], [145, -30], [145, -20], [125, -20], [125, -30]]);

var polygon = turf.lineToPolygon(line);

//addToMap
var addToMap = [polygon];
```

Returns **[Feature](https://tools.ietf.org/html/rfc7946#section-3.2)&lt;([Polygon](https://tools.ietf.org/html/rfc7946#section-3.1.6) \| [MultiPolygon](https://tools.ietf.org/html/rfc7946#section-3.1.7))>** converted to Polygons

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/line-to-polygon
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
