# @turf/point-to-line-distance

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## pointToLineDistance

Returns the minimum distance between a [Point](https://tools.ietf.org/html/rfc7946#section-3.1.2) and a [LineString](https://tools.ietf.org/html/rfc7946#section-3.1.4), being the distance from a line the
minimum distance between the point and any segment of the `LineString`.

**Parameters**

-   `pt` **[Coord](https://tools.ietf.org/html/rfc7946#section-3.1.1)** Feature or Geometry
-   `line` **[Feature](https://tools.ietf.org/html/rfc7946#section-3.2)&lt;[LineString](https://tools.ietf.org/html/rfc7946#section-3.1.4)>** GeoJSON Feature or Geometry
-   `options` **[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** Optional parameters (optional, default `{}`)
    -   `options.units` **[string](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String)** can be degrees, radians, miles, or kilometers (optional, default `'kilometers'`)
    -   `options.mercator` **[boolean](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Boolean)** if distance should be on Mercator or WGS84 projection (optional, default `false`)

**Examples**

```javascript
var pt = turf.point([0, 0]);
var line = turf.lineString([[1, 1],[-1, 1]]);

var distance = turf.pointToLineDistance(pt, line, {units: 'miles'});
//=69.11854715938406
```

Returns **[number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)** distance between point and line

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/point-to-line-distance
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
