# @turf/random

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## randomPosition

Returns a random position within a [box](bounding).

**Parameters**

-   `bbox` **[Array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array)&lt;[number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)>** a bounding box inside of which positions are placed. (optional, default `[-180,-90,180,90]`)

**Examples**

```javascript
var position = turf.randomPosition([-180, -90, 180, 90])
//=position
```

Returns **[Array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array)&lt;[number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)>** Position [longitude, latitude]

## randomPoint

Returns a random [point](point).

**Parameters**

-   `count` **[number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)** how many geometries will be generated (optional, default `1`)
-   `options` **[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** Optional parameters (optional, default `{}`)
    -   `options.bbox` **[Array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array)&lt;[number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)>** a bounding box inside of which geometries are placed. (optional, default `[-180,-90,180,90]`)

**Examples**

```javascript
var points = turf.randomPoint(25, {bbox: [-180, -90, 180, 90]})
//=points
```

Returns **[FeatureCollection](https://tools.ietf.org/html/rfc7946#section-3.3)&lt;[Point](https://tools.ietf.org/html/rfc7946#section-3.1.2)>** GeoJSON FeatureCollection of points

## randomPolygon

Returns a random [polygon](polygon).

**Parameters**

-   `count` **[number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)** how many geometries will be generated (optional, default `1`)
-   `options` **[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** Optional parameters (optional, default `{}`)
    -   `options.bbox` **[Array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array)&lt;[number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)>** a bounding box inside of which geometries are placed. (optional, default `[-180,-90,180,90]`)
    -   `options.num_vertices` **[number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)** is how many coordinates each LineString will contain. (optional, default `10`)
    -   `options.max_radial_length` **[number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)** is the maximum number of decimal degrees latitude or longitude that a vertex can reach out of the center of the Polygon. (optional, default `10`)

**Examples**

```javascript
var polygons = turf.randomPolygon(25, {bbox: [-180, -90, 180, 90]})
//=polygons
```

Returns **[FeatureCollection](https://tools.ietf.org/html/rfc7946#section-3.3)&lt;[Point](https://tools.ietf.org/html/rfc7946#section-3.1.2)>** GeoJSON FeatureCollection of points

## randomLineString

Returns a random [linestring](linestring).

**Parameters**

-   `count` **[number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)** how many geometries will be generated (optional, default `1`)
-   `options` **[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** Optional parameters (optional, default `{}`)
    -   `options.bbox` **[Array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array)&lt;[number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)>** a bounding box inside of which geometries are placed. (optional, default `[-180,-90,180,90]`)
    -   `options.num_vertices` **[number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)** is how many coordinates each LineString will contain. (optional, default `10`)
    -   `options.max_length` **[number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)** is the maximum number of decimal degrees that a vertex can be from its predecessor (optional, default `0.0001`)
    -   `options.max_rotation` **[number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)** is the maximum number of radians that a line segment can turn from the previous segment. (optional, default `Math.PI/8`)

**Examples**

```javascript
var lineStrings = turf.randomLineString(25, {bbox: [-180, -90, 180, 90]})
//=lineStrings
```

Returns **[FeatureCollection](https://tools.ietf.org/html/rfc7946#section-3.3)&lt;[Point](https://tools.ietf.org/html/rfc7946#section-3.1.2)>** GeoJSON FeatureCollection of points

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/random
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
