# @turf/rewind

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## rewind

Rewind [(Multi)LineString](https://tools.ietf.org/html/rfc7946#section-3.1.4) or [(Multi)Polygon](https://tools.ietf.org/html/rfc7946#section-3.1.6) outer ring counterclockwise and inner rings clockwise (Uses [Shoelace Formula](http://en.wikipedia.org/wiki/Shoelace_formula)).

**Parameters**

-   `geojson` **[GeoJSON](https://tools.ietf.org/html/rfc7946#section-3)** input GeoJSON Polygon
-   `options` **[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** Optional parameters (optional, default `{}`)
    -   `options.reverse` **[boolean](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Boolean)** enable reverse winding (optional, default `false`)
    -   `options.mutate` **[boolean](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Boolean)** allows GeoJSON input to be mutated (significant performance increase if true) (optional, default `false`)

**Examples**

```javascript
var polygon = turf.polygon([[[121, -29], [138, -29], [138, -18], [121, -18], [121, -29]]]);

var rewind = turf.rewind(polygon);

//addToMap
var addToMap = [rewind];
```

Returns **[GeoJSON](https://tools.ietf.org/html/rfc7946#section-3)** rewind Polygon

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/rewind
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
