# @turf/rhumb-destination

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## rhumbDestination

Returns the destination [Point](https://tools.ietf.org/html/rfc7946#section-3.1.2) having travelled the given distance along a Rhumb line from the
origin Point with the (varant) given bearing.

**Parameters**

-   `origin` **[Coord](https://tools.ietf.org/html/rfc7946#section-3.1.1)** starting point
-   `distance` **[number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)** distance from the starting point
-   `bearing` **[number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)** varant bearing angle ranging from -180 to 180 degrees from north
-   `options` **[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** Optional parameters (optional, default `{}`)
    -   `options.units` **[string](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String)** can be degrees, radians, miles, or kilometers (optional, default `'kilometers'`)
    -   `options.properties` **[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** translate properties to destination point (optional, default `{}`)

**Examples**

```javascript
var pt = turf.point([-75.343, 39.984], {"marker-color": "F00"});
var distance = 50;
var bearing = 90;
var options = {units: 'miles'};

var destination = turf.rhumbDestination(pt, distance, bearing, options);

//addToMap
var addToMap = [pt, destination]
destination.properties['marker-color'] = '#00F';
```

Returns **[Feature](https://tools.ietf.org/html/rfc7946#section-3.2)&lt;[Point](https://tools.ietf.org/html/rfc7946#section-3.1.2)>** Destination point.

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/rhumb-destination
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
