# @turf/tesselate

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## tesselate

Tesselates a [Feature&lt;Polygon>](Feature<Polygon>) into a [FeatureCollection&lt;Polygon>](FeatureCollection<Polygon>) of triangles
using [earcut](https://github.com/mapbox/earcut).

**Parameters**

-   `poly` **[Feature](https://tools.ietf.org/html/rfc7946#section-3.2)&lt;[Polygon](https://tools.ietf.org/html/rfc7946#section-3.1.6)>** the polygon to tesselate

**Examples**

```javascript
var poly = turf.polygon([[[11, 0], [22, 4], [31, 0], [31, 11], [21, 15], [11, 11], [11, 0]]]);
var triangles = turf.tesselate(poly);

//addToMap
var addToMap = [poly, triangles]
```

Returns **[FeatureCollection](https://tools.ietf.org/html/rfc7946#section-3.3)&lt;[Polygon](https://tools.ietf.org/html/rfc7946#section-3.1.6)>** a geometrycollection feature

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/tesselate
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
