# New major release! Turf 5.0.0 🎉

TurfJS releases are being tracked using [Milestones](https://github.com/Turfjs/turf/milestone/4?closed=1).

## Contributors

- @DenisCarriere
- @rowanwins
- @stebogit
- @stevage
- And MORE...

## ⭐️ Major Updates

- TurfJS now supports ES Modules ([Related PR's](https://github.com/Turfjs/turf/pulls?q=is%3Apr+modules+is%3Aclosed+label%3Aes-module))
- Optional parameters are now defined as an `Object`.

## 🚀 New Modules

### [`@turf/voronoi`][voronoi]
Takes a FeatureCollection of points, and a bounding box, and returns a FeatureCollection of Voronoi polygons.
(PR https://github.com/Turfjs/turf/pull/1043 - Author @stevage)

### [`@turf/shortest-path`][shortest-path]
Returns the shortest path from start to end without colliding with any feature in obstacles
(PR https://github.com/Turfjs/turf/pull/956 - Author @stebogit)

### [`@turf/boolean-parallel`][boolean-parallel]
Boolean-Parallel returns True if each segment of `line1` is parallel to the correspondent segment of `line2`
(PR https://github.com/Turfjs/turf/pull/941 - Author @stebogit)

### [`@turf/nearest-point-on-line`][nearest-point-on-line]
Takes a {@link Point} and a {@link LineString} and calculates the closest Point on the (Multi)LineString.
(PR https://github.com/Turfjs/turf/pull/939 - Author @stebogit)



## 🏅 New Features/Enhancements
- Updates [`@turf/unkink-polygon`][unkink-polygon] testing & added `flattenEach` instead of using `flatten`.
(PR https://github.com/Turfjs/turf/pull/889)

- Add multi-geomtry support to [`@turf/line-split`](line-split)
(PR https://github.com/Turfjs/turf/pull/1078)

- Improve [`@turf/meta`](meta) `lineEach` method to provide properties, id and bbox 
(PR https://github.com/Turfjs/turf/pull/1010)



## 🐛 Bug Fixes
- Fixes [`@turf/helpers`](helpers) earth radius variable 
(PR https://github.com/Turfjs/turf/pull/1012)

- Fixes [`@turf/polygon-tangents`](polygon-tangents) bug 
(PR https://github.com/Turfjs/turf/pull/1058)

- Fixes [`@turf/line-chunk`](line-chunk) bug when the number of segments is integer
(PR https://github.com/Turfjs/turf/pull/1046)

- Fixes `segmentEach` and `segmentReduce` methods in [`@turf/meta`](meta) to ensure something is returned 
(PR https://github.com/Turfjs/turf/pull/968)


## ⚠️ Breaking Change

- Optional parameters are now defined as an `Object`:

**Before**
```js
var from = [-75.343, 39.984];
var to = [-75.534, 39.123];
var units = 'miles';
var distance = turf.distance(from, to, units);
```

**After**
```js
var from = [-75.343, 39.984];
var to = [-75.534, 39.123];
var options = {units: 'miles'};
var distance = turf.distance(from, to, options);
```

- Reworked `@turf/random` PR https://github.com/Turfjs/turf/issues/994
- Deprecate `@turf/idw` Issue https://github.com/Turfjs/turf/issues/887
- Reworked Grid modules `@turf/point-grid/hex/square/triangle` PR https://github.com/Turfjs/turf/pull/1029
- Renamed Modules/Methods
  - [x] `@turf/inside` => `@turf/boolean-point-in-polygon` https://github.com/Turfjs/turf/issues/860#issuecomment-317216235
  - [x] `@turf/within` => `@turf/points-within-polygon` https://github.com/Turfjs/turf/issues/860#issuecomment-317216235
  - [x] [`@turf/bezier`](https://github.com/Turfjs/turf/blob/master/packages/turf-bezier/index.js) => `@turf/bezier-spline` Issue https://github.com/Turfjs/turf/issues/661
  - [x] [`@turf/nearest`](https://github.com/Turfjs/turf/blob/master/packages/turf-nearest/index.js) => `@turf/nearest-point` https://github.com/Turfjs/turf/pull/858#issuecomment-317197295
  - [x] [`@turf/point-on-line`](https://github.com/Turfjs/turf/blob/master/packages/turf-point-on-line/index.js) => `@turf/nearest-point-on-line` https://github.com/Turfjs/turf/pull/858#issuecomment-317197295
  - [x] [`@turf/lineDistance`](https://github.com/Turfjs/turf/blob/master/packages/turf-line-distance/index.js) => `@turf/length` https://github.com/Turfjs/turf/issues/860#issuecomment-317229869
  - [x] [`@turf/helpers`](https://github.com/Turfjs/turf/blob/master/packages/turf-helpers/index.js)
    - [x] `radians2degrees` => `radiansToDegrees`
    - [x] `degrees2radians` => `degreesToRadians`
    - [x] `distanceToDegrees` => `lengthToDegrees`
    - [x] `distanceToRadians` => `lengthToRadians`
    - [x] `radiansToDistance` => `radiansToLength`
    - [x] `bearingToAngle` => `bearingToAzimuth`
    - [x] `convertDistance` => `convertLength`

Twitter: <Tweet>
CC: @Turfjs/ownership


[along]: https://github.com/Turfjs/turf/tree/master/packages/turf-along
[area]: https://github.com/Turfjs/turf/tree/master/packages/turf-area
[bbox]: https://github.com/Turfjs/turf/tree/master/packages/turf-bbox
[bbox-clip]: https://github.com/Turfjs/turf/tree/master/packages/turf-bbox-clip
[bbox-polygon]: https://github.com/Turfjs/turf/tree/master/packages/turf-bbox-polygon
[bearing]: https://github.com/Turfjs/turf/tree/master/packages/turf-bearing
[bezier-spline]: https://github.com/Turfjs/turf/tree/master/packages/turf-bezier-spline
[boolean-clockwise]: https://github.com/Turfjs/turf/tree/master/packages/turf-boolean-clockwise
[boolean-contains]: https://github.com/Turfjs/turf/tree/master/packages/turf-boolean-contains
[boolean-crosses]: https://github.com/Turfjs/turf/tree/master/packages/turf-boolean-crosses
[boolean-disjoint]: https://github.com/Turfjs/turf/tree/master/packages/turf-boolean-disjoint
[boolean-equal]: https://github.com/Turfjs/turf/tree/master/packages/turf-boolean-equal
[boolean-overlap]: https://github.com/Turfjs/turf/tree/master/packages/turf-boolean-overlap
[boolean-parallel]: https://github.com/Turfjs/turf/tree/master/packages/turf-boolean-parallel
[boolean-point-in-polygon]: https://github.com/Turfjs/turf/tree/master/packages/turf-boolean-point-in-polygon
[boolean-point-on-line]: https://github.com/Turfjs/turf/tree/master/packages/turf-boolean-point-on-line
[boolean-within]: https://github.com/Turfjs/turf/tree/master/packages/turf-boolean-within
[buffer]: https://github.com/Turfjs/turf/tree/master/packages/turf-buffer
[center]: https://github.com/Turfjs/turf/tree/master/packages/turf-center
[center-of-mass]: https://github.com/Turfjs/turf/tree/master/packages/turf-center-of-mass
[centroid]: https://github.com/Turfjs/turf/tree/master/packages/turf-centroid
[circle]: https://github.com/Turfjs/turf/tree/master/packages/turf-circle
[clean-coords]: https://github.com/Turfjs/turf/tree/master/packages/turf-clean-coords
[clone]: https://github.com/Turfjs/turf/tree/master/packages/turf-clone
[clusters]: https://github.com/Turfjs/turf/tree/master/packages/turf-clusters
[clusters-dbscan]: https://github.com/Turfjs/turf/tree/master/packages/turf-clusters-dbscan
[clusters-kmeans]: https://github.com/Turfjs/turf/tree/master/packages/turf-clusters-kmeans
[collect]: https://github.com/Turfjs/turf/tree/master/packages/turf-collect
[combine]: https://github.com/Turfjs/turf/tree/master/packages/turf-combine
[concave]: https://github.com/Turfjs/turf/tree/master/packages/turf-concave
[convex]: https://github.com/Turfjs/turf/tree/master/packages/turf-convex
[destination]: https://github.com/Turfjs/turf/tree/master/packages/turf-destination
[difference]: https://github.com/Turfjs/turf/tree/master/packages/turf-difference
[dissolve]: https://github.com/Turfjs/turf/tree/master/packages/turf-dissolve
[distance]: https://github.com/Turfjs/turf/tree/master/packages/turf-distance
[envelope]: https://github.com/Turfjs/turf/tree/master/packages/turf-envelope
[explode]: https://github.com/Turfjs/turf/tree/master/packages/turf-explode
[flatten]: https://github.com/Turfjs/turf/tree/master/packages/turf-flatten
[flip]: https://github.com/Turfjs/turf/tree/master/packages/turf-flip
[great-circle]: https://github.com/Turfjs/turf/tree/master/packages/turf-great-circle
[helpers]: https://github.com/Turfjs/turf/tree/master/packages/turf-helpers
[hex-grid]: https://github.com/Turfjs/turf/tree/master/packages/turf-hex-grid
[interpolate]: https://github.com/Turfjs/turf/tree/master/packages/turf-interpolate
[intersect]: https://github.com/Turfjs/turf/tree/master/packages/turf-intersect
[invariant]: https://github.com/Turfjs/turf/tree/master/packages/turf-invariant
[isobands]: https://github.com/Turfjs/turf/tree/master/packages/turf-isobands
[isolines]: https://github.com/Turfjs/turf/tree/master/packages/turf-isolines
[kinks]: https://github.com/Turfjs/turf/tree/master/packages/turf-kinks
[length]: https://github.com/Turfjs/turf/tree/master/packages/turf-length
[line-arc]: https://github.com/Turfjs/turf/tree/master/packages/turf-line-arc
[line-chunk]: https://github.com/Turfjs/turf/tree/master/packages/turf-line-chunk
[line-intersect]: https://github.com/Turfjs/turf/tree/master/packages/turf-line-intersect
[line-offset]: https://github.com/Turfjs/turf/tree/master/packages/turf-line-offset
[line-overlap]: https://github.com/Turfjs/turf/tree/master/packages/turf-line-overlap
[line-segment]: https://github.com/Turfjs/turf/tree/master/packages/turf-line-segment
[line-slice]: https://github.com/Turfjs/turf/tree/master/packages/turf-line-slice
[line-slice-along]: https://github.com/Turfjs/turf/tree/master/packages/turf-line-slice-along
[line-split]: https://github.com/Turfjs/turf/tree/master/packages/turf-line-split
[line-to-polygon]: https://github.com/Turfjs/turf/tree/master/packages/turf-line-to-polygon
[mask]: https://github.com/Turfjs/turf/tree/master/packages/turf-mask
[meta]: https://github.com/Turfjs/turf/tree/master/packages/turf-meta
[midpoint]: https://github.com/Turfjs/turf/tree/master/packages/turf-midpoint
[nearest-point]: https://github.com/Turfjs/turf/tree/master/packages/turf-nearest-point
[nearest-point-on-line]: https://github.com/Turfjs/turf/tree/master/packages/turf-nearest-point-on-line
[nearest-point-to-line]: https://github.com/Turfjs/turf/tree/master/packages/turf-nearest-point-to-line
[planepoint]: https://github.com/Turfjs/turf/tree/master/packages/turf-planepoint
[point-grid]: https://github.com/Turfjs/turf/tree/master/packages/turf-point-grid
[point-on-feature]: https://github.com/Turfjs/turf/tree/master/packages/turf-point-on-feature
[point-to-line-distance]: https://github.com/Turfjs/turf/tree/master/packages/turf-point-to-line-distance
[points-within-polygon]: https://github.com/Turfjs/turf/tree/master/packages/turf-points-within-polygon
[polygon-tangents]: https://github.com/Turfjs/turf/tree/master/packages/turf-polygon-tangents
[polygon-to-line]: https://github.com/Turfjs/turf/tree/master/packages/turf-polygon-to-line
[polygonize]: https://github.com/Turfjs/turf/tree/master/packages/turf-polygonize
[projection]: https://github.com/Turfjs/turf/tree/master/packages/turf-projection
[random]: https://github.com/Turfjs/turf/tree/master/packages/turf-random
[rewind]: https://github.com/Turfjs/turf/tree/master/packages/turf-rewind
[rhumb-bearing]: https://github.com/Turfjs/turf/tree/master/packages/turf-rhumb-bearing
[rhumb-destination]: https://github.com/Turfjs/turf/tree/master/packages/turf-rhumb-destination
[rhumb-distance]: https://github.com/Turfjs/turf/tree/master/packages/turf-rhumb-distance
[sample]: https://github.com/Turfjs/turf/tree/master/packages/turf-sample
[sector]: https://github.com/Turfjs/turf/tree/master/packages/turf-sector
[shortest-path]: https://github.com/Turfjs/turf/tree/master/packages/turf-shortest-path
[simplify]: https://github.com/Turfjs/turf/tree/master/packages/turf-simplify
[square]: https://github.com/Turfjs/turf/tree/master/packages/turf-square
[square-grid]: https://github.com/Turfjs/turf/tree/master/packages/turf-square-grid
[tag]: https://github.com/Turfjs/turf/tree/master/packages/turf-tag
[tesselate]: https://github.com/Turfjs/turf/tree/master/packages/turf-tesselate
[tin]: https://github.com/Turfjs/turf/tree/master/packages/turf-tin
[transform-rotate]: https://github.com/Turfjs/turf/tree/master/packages/turf-transform-rotate
[transform-scale]: https://github.com/Turfjs/turf/tree/master/packages/turf-transform-scale
[transform-translate]: https://github.com/Turfjs/turf/tree/master/packages/turf-transform-translate
[triangle-grid]: https://github.com/Turfjs/turf/tree/master/packages/turf-triangle-grid
[truncate]: https://github.com/Turfjs/turf/tree/master/packages/turf-truncate
[union]: https://github.com/Turfjs/turf/tree/master/packages/turf-union
[unkink-polygon]: https://github.com/Turfjs/turf/tree/master/packages/turf-unkink-polygon
[voronoi]: https://github.com/Turfjs/turf/tree/master/packages/turf-voronoi
