# New minor release! Turf 5.1.0 🎉

TurfJS releases are being tracked using [Milestones](https://github.com/Turfjs/turf/milestone/13?closed=1).

## Contributors

- @muziejus 🥇
- @rowanwins 🥇
- @DenisCarriere
- @tmcw
- @stebogit
- @woutervh-
- @dwaggenspack

### Crowdsourced Funding

#### Why we're looking for support

TurfJS is a community-driven project maintained by a small group of core contributors who work on the project in their spare time. Time is spent supporting users, improving documentation, fixing bugs as well as creating new modules. Your funding will directly go to development costs, marketing campaigns, promotional events & any other financial costs to operate & maintain TurfJS.

In particular, we're looking for corporate sponsors who use TurfJS in revenue-generating ways, either by creating applications for clients, or through use in an app used by customers. Of course individuals are welcome to support us as well if TurfJS has helped you :)

### https://opencollective.com/turf

### Help TurfJS by becoming a **Backer** for only 2$/mo.

## 🚀 New Modules

### [`@turf/center-median`][center-median]

Takes a FeatureCollection of points and calculates the median center, algorithimically. The median center is understood as the point that is requires the least total travel from all other points.

(PR https://github.com/Turfjs/turf/pull/1122 - Author @muziejus)


### [`@turf/center-mean`][center-mean]

Takes a Feature or FeatureCollection and returns the mean center. Can be weighted.

(PR https://github.com/Turfjs/turf/pull/1089 - Author @muziejus)

![artboard 1](https://user-images.githubusercontent.com/827683/33585310-9596d15e-d931-11e7-901e-18f40a2b8cd7.png)


### [`@turf/standard-deviational-ellipse`][standard-deviational-ellipse]

Takes a FeatureCollection and returns a standard deviational ellipse, also known as a “directional distribution.” The standard deviational ellipse aims to show the direction and the distribution of a dataset by drawing an ellipse that contains about one standard deviation’s worth (~ 70%) of the data.

This module mirrors the functionality of Directional Distribution in ArcGIS and the QGIS Standard Deviational Ellipse Plugin

(PR https://github.com/Turfjs/turf/pull/1120 - Author @muziejus)

<img width="348" alt="screen shot 2017-11-24 at 23 41 13" src="https://user-images.githubusercontent.com/827683/33227583-c21d068c-d173-11e7-8a62-698930fe42c1.png">

### [`@turf/ellipse`][ellipse]

Takes a Point and calculates the ellipse polygon given two semi-axes expressed in variable units and steps for precision.

(PR https://github.com/Turfjs/turf/pull/1087 - Author @muziejus)

![ellipse](https://user-images.githubusercontent.com/12717225/32702074-d8ea0708-c795-11e7-9d0a-5d8fa3e03987.png)

## 📖 Documentation

- TurfJS's website has a fresh new look! 🚀 http://turfjs.org (Author @rowanwins PR https://github.com/Turfjs/turf-www/pull/127)
  - This uses nuxt to generate the pages as static html which should be better for search engines
  - The docs are now all on a single page
  - Built sizes are much better than the current
  - The map moves to a module when its description comes into view, I think this functions reasonably nicely.

## 🏅 New Features/Enhancements

- Add points/lineStrings/polygons to [@turf/helpers][helpers] (https://github.com/Turfjs/turf/pull/1108)
- Internalize `@types/geojson` (https://github.com/Turfjs/turf/pull/1138)
- Add extra geometry support to [@turf/points-within-polygon][points-within-polygon] (https://github.com/Turfjs/turf/pull/1117)
- ES Modules now work in the latest version of Chrome!

```html
<script type='module'>
  import {point} from "https://unpkg.com/@turf/helpers?module"

  console.log(point([100, 0]));
</script>
```

## 🐛 Bug Fixes

- Prevent Window Freeze when using [@turf/simplify][simplify] (https://github.com/Turfjs/turf/pull/1145)
- Take care of zero handling for weight in [@turf/center-mean][center-mean] (https://github.com/Turfjs/turf/pull/1127)
- Add input validation to [@turf/bbox-polygon][bbox-polygon] (https://github.com/Turfjs/turf/pull/1121)
- Use rhumb lines to calculate [@turf/ellipse][ellipse] axes, except when units are "degrees" (https://github.com/Turfjs/turf/pull/1115)
- [coordEach][meta] indexing bug (https://github.com/Turfjs/turf/issues/1092)
- Add null handling for property cloning on @turf/clone. Fixes issue #1095 (https://github.com/Turfjs/turf/pull/1096)

Twitter: https://twitter.com/DenisCarriere/status/938895355541778432
CC: @Turfjs/ownership

[along]: https://github.com/Turfjs/turf/tree/master/packages/turf-along
[area]: https://github.com/Turfjs/turf/tree/master/packages/turf-area
[bbox]: https://github.com/Turfjs/turf/tree/master/packages/turf-bbox
[bbox-clip]: https://github.com/Turfjs/turf/tree/master/packages/turf-bbox-clip
[bbox-polygon]: https://github.com/Turfjs/turf/tree/master/packages/turf-bbox-polygon
[bearing]: https://github.com/Turfjs/turf/tree/master/packages/turf-bearing
[bezier-spline]: https://github.com/Turfjs/turf/tree/master/packages/turf-bezier-spline
[boolean-clockwise]: https://github.com/Turfjs/turf/tree/master/packages/turf-boolean-clockwise
[boolean-contains]: https://github.com/Turfjs/turf/tree/master/packages/turf-boolean-contains
[boolean-crosses]: https://github.com/Turfjs/turf/tree/master/packages/turf-boolean-crosses
[boolean-disjoint]: https://github.com/Turfjs/turf/tree/master/packages/turf-boolean-disjoint
[boolean-equal]: https://github.com/Turfjs/turf/tree/master/packages/turf-boolean-equal
[boolean-overlap]: https://github.com/Turfjs/turf/tree/master/packages/turf-boolean-overlap
[boolean-parallel]: https://github.com/Turfjs/turf/tree/master/packages/turf-boolean-parallel
[boolean-point-in-polygon]: https://github.com/Turfjs/turf/tree/master/packages/turf-boolean-point-in-polygon
[boolean-point-on-line]: https://github.com/Turfjs/turf/tree/master/packages/turf-boolean-point-on-line
[boolean-within]: https://github.com/Turfjs/turf/tree/master/packages/turf-boolean-within
[buffer]: https://github.com/Turfjs/turf/tree/master/packages/turf-buffer
[center]: https://github.com/Turfjs/turf/tree/master/packages/turf-center
[center-mean]: https://github.com/Turfjs/turf/tree/master/packages/turf-center-mean
[center-median]: https://github.com/Turfjs/turf/tree/master/packages/turf-center-median
[center-of-mass]: https://github.com/Turfjs/turf/tree/master/packages/turf-center-of-mass
[centroid]: https://github.com/Turfjs/turf/tree/master/packages/turf-centroid
[circle]: https://github.com/Turfjs/turf/tree/master/packages/turf-circle
[clean-coords]: https://github.com/Turfjs/turf/tree/master/packages/turf-clean-coords
[clone]: https://github.com/Turfjs/turf/tree/master/packages/turf-clone
[clusters]: https://github.com/Turfjs/turf/tree/master/packages/turf-clusters
[clusters-dbscan]: https://github.com/Turfjs/turf/tree/master/packages/turf-clusters-dbscan
[clusters-kmeans]: https://github.com/Turfjs/turf/tree/master/packages/turf-clusters-kmeans
[collect]: https://github.com/Turfjs/turf/tree/master/packages/turf-collect
[combine]: https://github.com/Turfjs/turf/tree/master/packages/turf-combine
[concave]: https://github.com/Turfjs/turf/tree/master/packages/turf-concave
[convex]: https://github.com/Turfjs/turf/tree/master/packages/turf-convex
[destination]: https://github.com/Turfjs/turf/tree/master/packages/turf-destination
[difference]: https://github.com/Turfjs/turf/tree/master/packages/turf-difference
[dissolve]: https://github.com/Turfjs/turf/tree/master/packages/turf-dissolve
[distance]: https://github.com/Turfjs/turf/tree/master/packages/turf-distance
[ellipse]: https://github.com/Turfjs/turf/tree/master/packages/turf-ellipse
[envelope]: https://github.com/Turfjs/turf/tree/master/packages/turf-envelope
[explode]: https://github.com/Turfjs/turf/tree/master/packages/turf-explode
[flatten]: https://github.com/Turfjs/turf/tree/master/packages/turf-flatten
[flip]: https://github.com/Turfjs/turf/tree/master/packages/turf-flip
[great-circle]: https://github.com/Turfjs/turf/tree/master/packages/turf-great-circle
[helpers]: https://github.com/Turfjs/turf/tree/master/packages/turf-helpers
[hex-grid]: https://github.com/Turfjs/turf/tree/master/packages/turf-hex-grid
[interpolate]: https://github.com/Turfjs/turf/tree/master/packages/turf-interpolate
[intersect]: https://github.com/Turfjs/turf/tree/master/packages/turf-intersect
[invariant]: https://github.com/Turfjs/turf/tree/master/packages/turf-invariant
[isobands]: https://github.com/Turfjs/turf/tree/master/packages/turf-isobands
[isolines]: https://github.com/Turfjs/turf/tree/master/packages/turf-isolines
[kinks]: https://github.com/Turfjs/turf/tree/master/packages/turf-kinks
[length]: https://github.com/Turfjs/turf/tree/master/packages/turf-length
[line-arc]: https://github.com/Turfjs/turf/tree/master/packages/turf-line-arc
[line-chunk]: https://github.com/Turfjs/turf/tree/master/packages/turf-line-chunk
[line-intersect]: https://github.com/Turfjs/turf/tree/master/packages/turf-line-intersect
[line-offset]: https://github.com/Turfjs/turf/tree/master/packages/turf-line-offset
[line-overlap]: https://github.com/Turfjs/turf/tree/master/packages/turf-line-overlap
[line-segment]: https://github.com/Turfjs/turf/tree/master/packages/turf-line-segment
[line-slice]: https://github.com/Turfjs/turf/tree/master/packages/turf-line-slice
[line-slice-along]: https://github.com/Turfjs/turf/tree/master/packages/turf-line-slice-along
[line-split]: https://github.com/Turfjs/turf/tree/master/packages/turf-line-split
[line-to-polygon]: https://github.com/Turfjs/turf/tree/master/packages/turf-line-to-polygon
[mask]: https://github.com/Turfjs/turf/tree/master/packages/turf-mask
[meta]: https://github.com/Turfjs/turf/tree/master/packages/turf-meta
[midpoint]: https://github.com/Turfjs/turf/tree/master/packages/turf-midpoint
[nearest-point]: https://github.com/Turfjs/turf/tree/master/packages/turf-nearest-point
[nearest-point-on-line]: https://github.com/Turfjs/turf/tree/master/packages/turf-nearest-point-on-line
[nearest-point-to-line]: https://github.com/Turfjs/turf/tree/master/packages/turf-nearest-point-to-line
[planepoint]: https://github.com/Turfjs/turf/tree/master/packages/turf-planepoint
[point-grid]: https://github.com/Turfjs/turf/tree/master/packages/turf-point-grid
[point-on-feature]: https://github.com/Turfjs/turf/tree/master/packages/turf-point-on-feature
[point-to-line-distance]: https://github.com/Turfjs/turf/tree/master/packages/turf-point-to-line-distance
[points-within-polygon]: https://github.com/Turfjs/turf/tree/master/packages/turf-points-within-polygon
[polygon-tangents]: https://github.com/Turfjs/turf/tree/master/packages/turf-polygon-tangents
[polygon-to-line]: https://github.com/Turfjs/turf/tree/master/packages/turf-polygon-to-line
[polygonize]: https://github.com/Turfjs/turf/tree/master/packages/turf-polygonize
[projection]: https://github.com/Turfjs/turf/tree/master/packages/turf-projection
[random]: https://github.com/Turfjs/turf/tree/master/packages/turf-random
[rewind]: https://github.com/Turfjs/turf/tree/master/packages/turf-rewind
[rhumb-bearing]: https://github.com/Turfjs/turf/tree/master/packages/turf-rhumb-bearing
[rhumb-destination]: https://github.com/Turfjs/turf/tree/master/packages/turf-rhumb-destination
[rhumb-distance]: https://github.com/Turfjs/turf/tree/master/packages/turf-rhumb-distance
[sample]: https://github.com/Turfjs/turf/tree/master/packages/turf-sample
[sector]: https://github.com/Turfjs/turf/tree/master/packages/turf-sector
[shortest-path]: https://github.com/Turfjs/turf/tree/master/packages/turf-shortest-path
[simplify]: https://github.com/Turfjs/turf/tree/master/packages/turf-simplify
[square]: https://github.com/Turfjs/turf/tree/master/packages/turf-square
[square-grid]: https://github.com/Turfjs/turf/tree/master/packages/turf-square-grid
[standard-deviational-ellipse]: https://github.com/Turfjs/turf/tree/master/packages/turf-standard-deviational-ellipse
[tag]: https://github.com/Turfjs/turf/tree/master/packages/turf-tag
[tesselate]: https://github.com/Turfjs/turf/tree/master/packages/turf-tesselate
[tin]: https://github.com/Turfjs/turf/tree/master/packages/turf-tin
[transform-rotate]: https://github.com/Turfjs/turf/tree/master/packages/turf-transform-rotate
[transform-scale]: https://github.com/Turfjs/turf/tree/master/packages/turf-transform-scale
[transform-translate]: https://github.com/Turfjs/turf/tree/master/packages/turf-transform-translate
[triangle-grid]: https://github.com/Turfjs/turf/tree/master/packages/turf-triangle-grid
[truncate]: https://github.com/Turfjs/turf/tree/master/packages/turf-truncate
[union]: https://github.com/Turfjs/turf/tree/master/packages/turf-union
[unkink-polygon]: https://github.com/Turfjs/turf/tree/master/packages/turf-unkink-polygon
[voronoi]: https://github.com/Turfjs/turf/tree/master/packages/turf-voronoi
