(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define([], factory);
    } else if (typeof exports !== "undefined") {
        factory();
    } else {
        var mod = {
            exports: {}
        };
        factory();
        global.bootstrapTableFilter = mod.exports;
    }
})(this, function () {
    'use strict';

    /**
     * @author zhixin wen <wenzhixin2010@gmail.com>
     * extensions: https://github.com/lukaskral/bootstrap-table-filter
     */

    !function ($) {

        'use strict';

        $.extend($.fn.bootstrapTable.defaults, {
            showFilter: false
        });

        var BootstrapTable = $.fn.bootstrapTable.Constructor,
            _init = BootstrapTable.prototype.init,
            _initSearch = BootstrapTable.prototype.initSearch;

        BootstrapTable.prototype.init = function () {
            _init.apply(this, Array.prototype.slice.apply(arguments));

            var that = this;
            this.$el.on('load-success.bs.table', function () {
                if (that.options.showFilter) {
                    $(that.options.toolbar).bootstrapTableFilter({
                        connectTo: that.$el
                    });
                }
            });
        };

        BootstrapTable.prototype.initSearch = function () {
            _initSearch.apply(this, Array.prototype.slice.apply(arguments));

            if (this.options.sidePagination !== 'server') {
                if (typeof this.searchCallback === 'function') {
                    this.data = $.grep(this.options.data, this.searchCallback);
                }
            }
        };

        BootstrapTable.prototype.getData = function () {
            return this.searchText || this.searchCallback ? this.data : this.options.data;
        };

        BootstrapTable.prototype.getColumns = function () {
            return this.columns;
        };

        BootstrapTable.prototype.registerSearchCallback = function (callback) {
            this.searchCallback = callback;
        };

        BootstrapTable.prototype.updateSearch = function () {
            this.options.pageNumber = 1;
            this.initSearch();
            this.updatePagination();
        };

        BootstrapTable.prototype.getServerUrl = function () {
            return this.options.sidePagination === 'server' ? this.options.url : false;
        };

        $.fn.bootstrapTable.methods.push('getColumns', 'registerSearchCallback', 'updateSearch', 'getServerUrl');
    }(jQuery);
});