---
name: Bug report
about: Create a report to help us improve

---

Your issue may already be reported!
Please search on the [issue track](../) before creating one.

- [ ] Is this something you can **debug and fix**? Send a pull request! Bug fixes and documentation fixes are welcome.
- [ ] Are you running the latest version?
- [ ] Are you reporting to the correct repository?

## Bug Report

**Environment**
- Extension version(s): [e.g. v1.0.0, ...]
- Bulma version: [e.g. v7.1 / v7.2]
- OS: [e.g. OSX 10.13.4, Windows 10]
- Browser: [all | Chrome XX | Firefox XX | IE XX | Safari XX | Mobile Chrome XX | Android X.X Web Browser | iOS XX Safari | iOS XX UIWebView | iOS XX WKWebView ]
- How you are customizing the extension: [e.g. yes/no]

**Current Behavior**
A clear and concise description of the behavior.

**Input Code**
- Initialization code:

```js
var bulmaCalendar = BulmaCalendar.attach();
```

**Possible Solution**
[Only if you have suggestions on a fix for the bug]

**Additional context/Screenshots**
Add any other context about the problem here.

**If the current behavior is a bug, please provide the steps to reproduce and if possible a minimal demo of the problem** via [codepen](https://codepen.io) or similar.
