/**
 * Angular directive/filter/service for formatting date so that it displays how long ago the given time was compared to now.
 * @version v0.4.6 - 2017-08-16
 * @link https://github.com/yaru22/angular-timeago
 * @author Brian Park <yaru22@gmail.com>
 * @license MIT License, http://www.opensource.org/licenses/MIT
 */
"use strict";angular.module("yaru22.angular-timeago",[]),angular.module("yaru22.angular-timeago").factory("nowTime",["$interval","timeAgo","timeAgoSettings",function(a,b,c){function d(){e=Date.now()}var e;return d(),a(d,c.refreshMillis),function(){return e}}]),angular.module("yaru22.angular-timeago").constant("timeAgoSettings",{refreshMillis:1e3,allowFuture:!1,overrideLang:null,fullDateAfterSeconds:null,strings:{},breakpoints:{secondsToMinute:45,secondsToMinutes:90,minutesToHour:45,minutesToHours:90,hoursToDay:24,hoursToDays:42,daysToMonth:30,daysToMonths:45,daysToYear:365,yearToYears:1.5}}),angular.module("yaru22.angular-timeago").directive("timeAgo",["timeAgo","nowTime",function(a,b){return{scope:{fromTime:"@",format:"@"},restrict:"EA",link:function(c,d){var e;c.$watch("fromTime",function(){e=a.parse(c.fromTime)}),c.$watch(function(){return b()-e},function(b){angular.element(d).text(a.inWords(b,e,c.format))})}}}]),angular.module("yaru22.angular-timeago").factory("timeAgo",["$filter","timeAgoSettings",function(a,b){var c={};return c.inWords=function(c,d,e,f){function g(a,b){b=Math.round(b);var d=angular.isFunction(a)?a(b,c):a,e=k.numbers&&k.numbers[b]||b;return d.replace(/%d/i,e)}var h=parseInt(b.fullDateAfterSeconds,10);if(!isNaN(h)){var i=1e3*h;if(c>=0&&i<=c||c<0&&i>=c)return e?a("date")(d,e,f):d}var j,k,l=b.overrideLang,m=document.documentElement.lang,n=b.strings;"undefined"!=typeof n[l]?(j=l,k=n[l]):"undefined"!=typeof n[m]?(j=m,k=n[m]):(j="en_US",k=n[j]);var o=k.prefixAgo,p=k.suffixAgo;b.allowFuture&&c<0&&(o=k.prefixFromNow,p=k.suffixFromNow);var q=Math.abs(c)/1e3,r=q/60,s=r/60,t=s/24,u=t/365,v=b.breakpoints,w=q<v.secondsToMinute&&g(k.seconds,q)||q<v.secondsToMinutes&&g(k.minute,1)||r<v.minutesToHour&&g(k.minutes,r)||r<v.minutesToHours&&g(k.hour,1)||s<v.hoursToDay&&g(k.hours,s)||s<v.hoursToDays&&g(k.day,1)||t<v.daysToMonth&&g(k.days,t)||t<v.daysToMonths&&g(k.month,1)||t<v.daysToYear&&g(k.months,t/30)||u<v.yearToYears&&g(k.year,1)||g(k.years,u),x=void 0===k.wordSeparator?" ":k.wordSeparator;return"he_IL"===j?[o,p,w].join(x).trim():[o,w,p].join(x).trim()},c.parse=function(a){if(a instanceof Date)return a;if("undefined"!=typeof moment&&moment.isMoment(a))return a.toDate();if(angular.isNumber(a))return new Date(a);if(/^\d+$/.test(a))return new Date(parseInt(a,10));var b=(a||"").trim();return b=b.replace(/\.\d+/,""),b=b.replace(/-/,"/").replace(/-/,"/"),b=b.replace(/T/," ").replace(/Z/," UTC"),b=b.replace(/([\+\-]\d\d)\:?(\d\d)/," $1$2"),new Date(b)},c}]),angular.module("yaru22.angular-timeago").filter("timeAgo",["nowTime","timeAgo",function(a,b){function c(c,d,e){var f=b.parse(c),g=a()-f;return b.inWords(g,f,d,e)}return c.$stateful=!0,c}]);