/**
 * Angular directive/filter/service for formatting date so that it displays how long ago the given time was compared to now.
 * @version v0.4.6 - 2017-08-16
 * @link https://github.com/yaru22/angular-timeago
 * @author Brian Park <yaru22@gmail.com>
 * @license MIT License, http://www.opensource.org/licenses/MIT
 */
"use strict";angular.module("yaru22.angular-timeago",[]),angular.module("yaru22.angular-timeago").config(["timeAgoSettings",function(a){a.strings.ca_ES={prefixAgo:"fa",prefixFromNow:"d'aquí",suffixAgo:null,suffixFromNow:null,seconds:"menys d'un minut",minute:"prop d'un minut",minutes:"%d minuts",hour:"prop d'una hora",hours:"prop de %d hores",day:"un dia",days:"%d dies",month:"prop d'un mes",months:"%d mesos",year:"prop d'un any",years:"%d anys",numbers:[]}}]),angular.module("yaru22.angular-timeago").config(["timeAgoSettings",function(a){function b(a,b,c){return function(d,e){var f=e<0;return f?d<=4?b:c:a}}a.strings.cs_CZ={prefixAgo:"prěd",prefixFromNow:"za",suffixAgo:null,suffixFromNow:null,seconds:b("méně než minutou","méne než minutu","méne než minutu"),minute:b("minutou","minutu","minutu"),minutes:b("%d minutami","%d minuty","%d minút"),hour:b("hodinou","hodinu","hodinu"),hours:b("%d hodinama","%d hodiny","%d hodin"),day:b("dnem","den","den"),days:b("%d dny","%d dny","%d dnů"),month:b("měsícem","měsíc","měsíc"),months:b("%d měsíci","%d měsíce","%d měsíců"),year:b("rokem","rok","rok"),years:b("%d lety","%d roky","%d let"),numbers:[]}}]),angular.module("yaru22.angular-timeago").config(["timeAgoSettings",function(a){a.strings.da_DK={prefixAgo:null,prefixFromNow:null,suffixAgo:"siden",suffixFromNow:null,seconds:"mindre end et minut",minute:"omkring et minut",minutes:"%d minuter",hour:"omkring en time",hours:"omkring %d timer",day:"en dag",days:"%d dage",month:"omkring en måned",months:"%d måneder",year:"omkring et år",years:"%d år",numbers:[]}}]),angular.module("yaru22.angular-timeago").config(["timeAgoSettings",function(a){a.strings.de_DE={prefixAgo:"vor",prefixFromNow:"in",suffixAgo:null,suffixFromNow:null,seconds:"weniger als einer Minute",minute:"ca. einer Minute",minutes:"%d Minuten",hour:"ca. einer Stunde",hours:"ca. %d Stunden",day:"einem Tag",days:"%d Tagen",month:"ca. einem Monat",months:"%d Monaten",year:"ca. einem Jahr",years:"%d Jahren",numbers:[]}}]),angular.module("yaru22.angular-timeago").config(["timeAgoSettings",function(a){a.strings.en_US={prefixAgo:null,prefixFromNow:null,suffixAgo:"ago",suffixFromNow:"from now",seconds:"less than a minute",minute:"about a minute",minutes:"%d minutes",hour:"about an hour",hours:"about %d hours",day:"a day",days:"%d days",month:"about a month",months:"%d months",year:"about a year",years:"%d years",numbers:[]}}]),angular.module("yaru22.angular-timeago").config(["timeAgoSettings",function(a){a.strings.es_ES={prefixAgo:"hace",prefixFromNow:"dentro de",suffixAgo:null,suffixFromNow:null,seconds:"menos de un minuto",minute:"un minuto",minutes:"%d minutos",hour:"una hora",hours:"%d horas",day:"un día",days:"%d días",month:"un mes",months:"%d meses",year:"un año",years:"%d años",numbers:[]}}]),angular.module("yaru22.angular-timeago").config(["timeAgoSettings",function(a){a.strings.es_LA={prefixAgo:"hace",prefixFromNow:"en",suffixAgo:null,suffixFromNow:null,seconds:"menos de un minuto",minute:"un minuto",minutes:"%d minutos",hour:"una hora",hours:"%d horas",day:"un día",days:"%d días",month:"un mes",months:"%d meses",year:"un año",years:"%d años",numbers:[]}}]),angular.module("yaru22.angular-timeago").config(["timeAgoSettings",function(a){a.strings.fr_FR={prefixAgo:"il y a",prefixFromNow:"dans",suffixAgo:null,suffixFromNow:null,seconds:"moins d'une minute",minute:"environ une minute",minutes:"%d minutes",hour:"environ une heure",hours:"environ %d heures",day:"un jour",days:"%d jours",month:"environ un mois",months:"%d mois",year:"environ un an",years:"%d ans",numbers:[]}}]),angular.module("yaru22.angular-timeago").config(["timeAgoSettings",function(a){a.strings.he_IL={prefixAgo:null,prefixFromNow:null,suffixAgo:"לפני",suffixFromNow:"מעכשיו",seconds:"פחות מדקה",minute:"כדקה",minutes:"%d דקות",hour:"כשעה",hours:"כ %d שעות",day:"יום",days:"%d ימים",month:"כחודש",months:"%d חודשים",year:"כשנה",years:"%d שנים",numbers:[]}}]),angular.module("yaru22.angular-timeago").config(["timeAgoSettings",function(a){a.strings.hu_HU={prefixAgo:null,prefixFromNow:null,suffixAgo:null,suffixFromNow:null,seconds:"kevesebb mint egy perce",minute:"körülbelül egy perce",minutes:"%d perce",hour:"körülbelül egy órája",hours:"körülbelül %d órája",day:"egy napja",days:"%d napja",month:"körülbelül egy hónapja",months:"%d hónapja",year:"körülbelül egy éve",years:"%d éve",numbers:[]}}]),angular.module("yaru22.angular-timeago").config(["timeAgoSettings",function(a){a.strings.it_IT={prefixAgo:null,prefixFromNow:null,suffixAgo:"fa",suffixFromNow:"da ora",seconds:"meno di un minuto",minute:"circa un minuto",minutes:"%d minuti",hour:"circa un'ora",hours:"circa %d ore",day:"un giorno",days:"%d giorni",month:"circa un mese",months:"%d mesi",year:"circa un anno",years:"%d anni",numbers:[]}}]),angular.module("yaru22.angular-timeago").config(["timeAgoSettings",function(a){a.strings.nl_NL={prefixAgo:null,prefixFromNow:"over",suffixAgo:"geleden",suffixFromNow:"vanaf nu",seconds:"een paar seconden",minute:"ongeveer een minuut",minutes:"%d minuten",hour:"een uur",hours:"%d uur",day:"een dag",days:"%d dagen",month:"een maand",months:"%d maanden",year:"een jaar",years:"%d jaar",numbers:[]}}]),angular.module("yaru22.angular-timeago").config(["timeAgoSettings",function(a){a.strings.pl_PL={prefixAgo:null,prefixFromNow:null,suffixAgo:"temu",suffixFromNow:"od teraz",seconds:"mniej niż minuta",minute:"około minuty",minutes:"%d minut",hour:"około godziny",hours:"około %d godzin",day:"dzień",days:"%d dni",month:"około miesiąca",months:"%d miesięcy",year:"około roku",years:"%d lat",numbers:[]}}]),angular.module("yaru22.angular-timeago").config(["timeAgoSettings",function(a){a.strings.pt_BR={prefixAgo:null,prefixFromNow:"daqui a",suffixAgo:"atrás",suffixFromNow:null,seconds:"menos de um minuto",minute:"cerca de um minuto",minutes:"%d minutos",hour:"cerca de uma hora",hours:"cerca de %d horas",day:"um dia",days:"%d dias",month:"cerca de um mês",months:"%d meses",year:"cerca de um ano",years:"%d anos",numbers:[]}}]),angular.module("yaru22.angular-timeago").config(["timeAgoSettings",function(a){a.strings.ru_RU={prefixAgo:null,prefixFromNow:null,suffixAgo:"назад",suffixFromNow:"с текущего момента",seconds:"менее минуты",minute:"около минуты",minutes:"%d мин.",hour:"около часа",hours:"около %d ч.",day:"день",days:"%d дн.",month:"около месяца",months:"%d мес.",year:"около года",years:"%d года",numbers:[]}}]),angular.module("yaru22.angular-timeago").config(["timeAgoSettings",function(a){a.strings.ru_RU={prefixAgo:null,prefixFromNow:null,suffixAgo:"назад",suffixFromNow:null,seconds:"меньше минуты",minute:"около минуты",minutes:"%d мин.",hour:"около часа",hours:"около %d час.",day:"день",days:"%d дн.",month:"около месяца",months:"%d мес.",year:"около года",years:"%d г.",numbers:[]}}]),angular.module("yaru22.angular-timeago").config(["timeAgoSettings",function(a){function b(a,b,c){return function(d,e){var f=e<0;return f?d<=4?b:c:a}}a.strings.sk_SK={prefixAgo:"pred",prefixFromNow:"za",suffixAgo:null,suffixFromNow:null,seconds:b("menej ako minútou","menej ako minútu","menej ako minútu"),minute:b("minútou","minútu","minútu"),minutes:b("%d minútami","%d minúty","%d minút"),hour:b("hodinou","hodinu","hodinu"),hours:b("%d hodinami","%d hodiny","%d hodín"),day:b("dňom","deň","deň"),days:b("%d dňami","%d dni","%d dní"),month:b("mesiacom","mesiac","mesiac"),months:b("%d mesiacmi","%d mesiace","%d mesiacov"),year:b("rokom","rok","rok"),years:b("%d rokmi","%d roky","%d rokov"),numbers:[]}}]),angular.module("yaru22.angular-timeago").config(["timeAgoSettings",function(a){a.strings.sv_SE={prefixAgo:null,prefixFromNow:"om",suffixAgo:"sen",suffixFromNow:null,seconds:"mindre än en minut",minute:"cirka en minut",minutes:"%d minuter",hour:"cirka en timme",hours:"cirka %d timmar",day:"en dag",days:"%d dagar",month:"cirka en månad",months:"%d månader",year:"cirka ett år",years:"%d år",numbers:[]}}]),angular.module("yaru22.angular-timeago").config(["timeAgoSettings",function(a){a.strings.tr_TR={prefixAgo:null,prefixFromNow:null,suffixAgo:"önce",suffixFromNow:"şu andan itibaren",seconds:"bir dakikadan daha az",minute:"bir dakika gibi",minutes:"%d dakika",hour:"bir saat gibi",hours:"%d saat gibi",day:"bir gün",days:"%d gün",month:"bir ay gibi",months:"%d ay",year:"bir yıl gibi",years:"%d yıl",numbers:[]}}]),angular.module("yaru22.angular-timeago").config(["timeAgoSettings",function(a){a.strings.zh_CN={wordSeparator:"",prefixAgo:null,prefixFromNow:null,suffixAgo:"前",suffixFromNow:"后",seconds:"1分钟",minute:"1分钟",minutes:"%d分钟",hour:"1小时",hours:"%d小时",day:"1天",days:"%d天",month:"1个月",months:"%d个月",year:"1年",years:"%d年",numbers:[]}}]),angular.module("yaru22.angular-timeago").config(["timeAgoSettings",function(a){a.strings.zh_TW={wordSeparator:"",prefixAgo:null,prefixFromNow:null,suffixAgo:"前",suffixFromNow:"後",seconds:"少於一分鐘",minute:"一分鐘",minutes:"%d分鐘",hour:"一小時",hours:"%d小時",day:"一日",days:"%d日",month:"一個月",months:"%d個月",year:"一年",years:"%d年",numbers:["零","一","二","三","四","五","六","七","八","九","十","十一","十二","十三","十四","十五","十六","十七","十八","十九","二十","廿一","廿二","廿三","廿四","廿五","廿六","廿七","廿八","廿九","三十","卅一","卅二","卅三","卅四","卅五","卅六","卅七","卅八","卅九","四十","卌一","卌二","卌三","卌四","卌五","卌六","卌七","卌八","卌九","五十","五十一","五十二","五十三","五十四","五十五","五十六","五十七","五十八","五十九","六十","六十一","六十二","六十三","六十四","六十五","六十六","六十七","六十八","六十九","七十","七十一","七十二","七十三","七十四","七十五","七十六","七十七","七十八","七十九","八十","八十一","八十二","八十三","八十四","八十五","八十六","八十七","八十八","八十九","九十","九十一","九十二","九十三","九十四","九十五","九十六","九十七","九十八","九十九","一百"]}}]),angular.module("yaru22.angular-timeago").factory("nowTime",["$interval","timeAgo","timeAgoSettings",function(a,b,c){function d(){e=Date.now()}var e;return d(),a(d,c.refreshMillis),function(){return e}}]),angular.module("yaru22.angular-timeago").constant("timeAgoSettings",{refreshMillis:1e3,allowFuture:!1,overrideLang:null,fullDateAfterSeconds:null,strings:{},breakpoints:{secondsToMinute:45,secondsToMinutes:90,minutesToHour:45,minutesToHours:90,hoursToDay:24,hoursToDays:42,daysToMonth:30,daysToMonths:45,daysToYear:365,yearToYears:1.5}}),angular.module("yaru22.angular-timeago").directive("timeAgo",["timeAgo","nowTime",function(a,b){return{scope:{fromTime:"@",format:"@"},restrict:"EA",link:function(c,d){var e;c.$watch("fromTime",function(){e=a.parse(c.fromTime)}),c.$watch(function(){return b()-e},function(b){angular.element(d).text(a.inWords(b,e,c.format))})}}}]),angular.module("yaru22.angular-timeago").factory("timeAgo",["$filter","timeAgoSettings",function(a,b){var c={};return c.inWords=function(c,d,e,f){function g(a,b){b=Math.round(b);var d=angular.isFunction(a)?a(b,c):a,e=k.numbers&&k.numbers[b]||b;return d.replace(/%d/i,e)}var h=parseInt(b.fullDateAfterSeconds,10);if(!isNaN(h)){var i=1e3*h;if(c>=0&&i<=c||c<0&&i>=c)return e?a("date")(d,e,f):d}var j,k,l=b.overrideLang,m=document.documentElement.lang,n=b.strings;"undefined"!=typeof n[l]?(j=l,k=n[l]):"undefined"!=typeof n[m]?(j=m,k=n[m]):(j="en_US",k=n[j]);var o=k.prefixAgo,p=k.suffixAgo;b.allowFuture&&c<0&&(o=k.prefixFromNow,p=k.suffixFromNow);var q=Math.abs(c)/1e3,r=q/60,s=r/60,t=s/24,u=t/365,v=b.breakpoints,w=q<v.secondsToMinute&&g(k.seconds,q)||q<v.secondsToMinutes&&g(k.minute,1)||r<v.minutesToHour&&g(k.minutes,r)||r<v.minutesToHours&&g(k.hour,1)||s<v.hoursToDay&&g(k.hours,s)||s<v.hoursToDays&&g(k.day,1)||t<v.daysToMonth&&g(k.days,t)||t<v.daysToMonths&&g(k.month,1)||t<v.daysToYear&&g(k.months,t/30)||u<v.yearToYears&&g(k.year,1)||g(k.years,u),x=void 0===k.wordSeparator?" ":k.wordSeparator;return"he_IL"===j?[o,p,w].join(x).trim():[o,w,p].join(x).trim()},c.parse=function(a){if(a instanceof Date)return a;if("undefined"!=typeof moment&&moment.isMoment(a))return a.toDate();if(angular.isNumber(a))return new Date(a);if(/^\d+$/.test(a))return new Date(parseInt(a,10));var b=(a||"").trim();return b=b.replace(/\.\d+/,""),b=b.replace(/-/,"/").replace(/-/,"/"),b=b.replace(/T/," ").replace(/Z/," UTC"),b=b.replace(/([\+\-]\d\d)\:?(\d\d)/," $1$2"),new Date(b)},c}]),angular.module("yaru22.angular-timeago").filter("timeAgo",["nowTime","timeAgo",function(a,b){function c(c,d,e){var f=b.parse(c),g=a()-f;return b.inWords(g,f,d,e)}return c.$stateful=!0,c}]);