// Generated by CoffeeScript 1.8.0
var $, HTML_ELEMENTS, SPACES_ONLY, Serialiser, TEXT_LEADING_WHITESPACE, TEXT_TRAILING_WHITESPACE, WHITESPACE_ONLY, containsNewlines, entityDecode, exports, find, firstNonWhitespaceChild, genericBranchSerialiser, genericLeafSerialiser, last, nodeSerialisers, serialise, stringEscape, _ref;

_ref = require('./helpers'), last = _ref.last, find = _ref.find;

$ = require('./symbols');

HTML_ELEMENTS = require('./htmlelements');

stringEscape = require('./stringescape');

entityDecode = require('./entitydecode');

module.exports = exports = serialise = function(parseTree) {
  return new Serialiser().serialise(parseTree);
};

Serialiser = (function() {
  function Serialiser() {}

  Serialiser.prototype.serialise = function(parseTree) {
    if (parseTree.children && parseTree.children.length && parseTree.children[0].type === $.CJSX_PRAGMA) {
      this.domObject = parseTree.children[0].value;
    } else {
      this.domObject = 'React.DOM';
    }
    return this.serialiseNode(parseTree);
  };

  Serialiser.prototype.serialiseNode = function(node) {
    var serialised;
    if (nodeSerialisers[node.type] == null) {
      throw new Error("unknown parseTree node type " + node.type);
    }
    serialised = nodeSerialisers[node.type].call(this, node);
    if (!(typeof serialised === 'string' || serialised === null)) {
      throw new Error("serialiser " + node.type + " didn\'t return a string");
    }
    return serialised;
  };

  Serialiser.prototype.serialiseSpreadAndPairAttributes = function(children) {
    var assigns, child, childIndex, flushPairs, pairAttrsBuffer, _i, _len, _ref1;
    assigns = [];
    pairAttrsBuffer = [];
    flushPairs = (function(_this) {
      return function() {
        var serialisedChild;
        if (pairAttrsBuffer.length) {
          serialisedChild = _this.serialiseAttributePairs(pairAttrsBuffer);
          if (serialisedChild) {
            assigns.push(serialisedChild);
          }
          return pairAttrsBuffer = [];
        }
      };
    })(this);
    if (((_ref1 = firstNonWhitespaceChild(children)) != null ? _ref1.type : void 0) === $.CJSX_ATTR_SPREAD) {
      assigns.push('{}');
    }
    for (childIndex = _i = 0, _len = children.length; _i < _len; childIndex = ++_i) {
      child = children[childIndex];
      if (child.type === $.CJSX_ATTR_SPREAD) {
        flushPairs();
        assigns.push(child.value);
      } else {
        pairAttrsBuffer.push(child);
      }
      flushPairs();
    }
    return "Object.assign(" + (assigns.join(', ')) + ")";
  };

  Serialiser.prototype.serialiseAttributePairs = function(children) {
    var child, childIndex, indexOfLastSemanticChild, isBeforeLastSemanticChild, semanticChildren, serialisedChild, serialisedChildren, whitespaceChildren, _ref1;
    _ref1 = children.reduce(function(partitionedChildren, child) {
      if (child.type === $.CJSX_WHITESPACE) {
        partitionedChildren[0].push(child);
      } else {
        partitionedChildren[1].push(child);
      }
      return partitionedChildren;
    }, [[], []]), whitespaceChildren = _ref1[0], semanticChildren = _ref1[1];
    indexOfLastSemanticChild = children.lastIndexOf(last(semanticChildren));
    isBeforeLastSemanticChild = function(childIndex) {
      return childIndex < indexOfLastSemanticChild;
    };
    if (semanticChildren.length) {
      serialisedChildren = (function() {
        var _i, _len, _results;
        _results = [];
        for (childIndex = _i = 0, _len = children.length; _i < _len; childIndex = ++_i) {
          child = children[childIndex];
          serialisedChild = this.serialiseNode(child);
          if (child.type === $.CJSX_WHITESPACE) {
            if (containsNewlines(serialisedChild)) {
              if (isBeforeLastSemanticChild(childIndex)) {
                _results.push(serialisedChild.replace('\n', ' \\\n'));
              } else {
                _results.push(serialisedChild);
              }
            } else {
              _results.push(null);
            }
          } else if (isBeforeLastSemanticChild(childIndex)) {
            _results.push(serialisedChild + ', ');
          } else {
            _results.push(serialisedChild);
          }
        }
        return _results;
      }).call(this);
      return '{' + serialisedChildren.join('') + '}';
    } else {
      return null;
    }
  };

  return Serialiser;

})();

genericBranchSerialiser = function(node) {
  return node.children.map((function(_this) {
    return function(child) {
      return _this.serialiseNode(child);
    };
  })(this)).join('');
};

genericLeafSerialiser = function(node) {
  return node.value;
};

nodeSerialisers = {
  ROOT: genericBranchSerialiser,
  CJSX_PRAGMA: function() {
    return null;
  },
  CJSX_EL: function(node) {
    var accumulatedWhitespace, child, prefix, serialisedChild, serialisedChildren, _i, _len, _ref1;
    serialisedChildren = [];
    accumulatedWhitespace = '';
    _ref1 = node.children;
    for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
      child = _ref1[_i];
      serialisedChild = this.serialiseNode(child);
      if (child != null) {
        if (WHITESPACE_ONLY.test(serialisedChild)) {
          accumulatedWhitespace += serialisedChild;
        } else {
          serialisedChildren.push(accumulatedWhitespace + serialisedChild);
          accumulatedWhitespace = '';
        }
      }
    }
    if (serialisedChildren.length) {
      serialisedChildren[serialisedChildren.length - 1] += accumulatedWhitespace;
      accumulatedWhitespace = '';
    }
    prefix = HTML_ELEMENTS[node.value] != null ? this.domObject + '.' : '';
    return prefix + node.value + '(' + serialisedChildren.join(', ') + ')';
  },
  CJSX_ESC: function(node) {
    var childrenSerialised;
    childrenSerialised = node.children.map((function(_this) {
      return function(child) {
        return _this.serialiseNode(child);
      };
    })(this)).join('');
    return '(' + childrenSerialised + ')';
  },
  CJSX_ATTRIBUTES: function(node) {
    if (node.children.some(function(child) {
      return child.type === $.CJSX_ATTR_SPREAD;
    })) {
      return this.serialiseSpreadAndPairAttributes(node.children);
    } else {
      return this.serialiseAttributePairs(node.children) || 'null';
    }
  },
  CJSX_ATTR_PAIR: function(node) {
    return node.children.map((function(_this) {
      return function(child) {
        return _this.serialiseNode(child);
      };
    })(this)).join(': ');
  },
  CJSX_ATTR_SPREAD: function(node) {
    return node.value;
  },
  CS: genericLeafSerialiser,
  CS_COMMENT: genericLeafSerialiser,
  CS_HEREDOC: genericLeafSerialiser,
  CS_STRING: genericLeafSerialiser,
  CS_REGEX: genericLeafSerialiser,
  CS_HEREGEX: genericLeafSerialiser,
  JS_ESC: genericLeafSerialiser,
  CJSX_WHITESPACE: genericLeafSerialiser,
  CJSX_TEXT: function(node) {
    var escapedText, leftSpace, leftTrim, rightSpace, rightTrim, text, trimmedText;
    text = node.value;
    if (containsNewlines(text)) {
      if (WHITESPACE_ONLY.test(text)) {
        return text;
      } else {
        leftSpace = text.match(TEXT_LEADING_WHITESPACE);
        rightSpace = text.match(TEXT_TRAILING_WHITESPACE);
        if (leftSpace) {
          leftTrim = text.indexOf('\n');
        } else {
          leftTrim = 0;
        }
        if (rightSpace) {
          rightTrim = text.lastIndexOf('\n') + 1;
        } else {
          rightTrim = text.length;
        }
        trimmedText = text.substring(leftTrim, rightTrim);
        escapedText = stringEscape(entityDecode(trimmedText), {
          preserveNewlines: true
        });
        return '"""' + escapedText + '"""';
      }
    } else {
      if (text === '') {
        return null;
      } else {
        return '"' + stringEscape(entityDecode(text)) + '"';
      }
    }
  },
  CJSX_ATTR_KEY: genericLeafSerialiser,
  CJSX_ATTR_VAL: genericLeafSerialiser
};

firstNonWhitespaceChild = function(children) {
  return find.call(children, function(child) {
    return child.type !== $.CJSX_WHITESPACE;
  });
};

containsNewlines = function(text) {
  return text.indexOf('\n') > -1;
};

SPACES_ONLY = /^\s+$/;

WHITESPACE_ONLY = /^[\n\s]+$/;

TEXT_LEADING_WHITESPACE = /^\s*?\n\s*/;

TEXT_TRAILING_WHITESPACE = /\s*?\n\s*?$/;

exports.Serialiser = Serialiser;

exports.nodeSerialisers = nodeSerialisers;
