/*!
   Copyright 2015 SpryMedia Ltd.

 License      MIT - http://datatables.net/license/mit

 This feature plug-in for DataTables will automatically change the DataTables
 page length in order to fit inside its container. This can be particularly
 useful for control panels and other interfaces which resize dynamically with
 the user's browser window instead of scrolling.

 Page resizing in DataTables can be enabled by using any one of the following
 options:

 * Adding the class `pageResize` to the HTML table
 * Setting the `pageResize` parameter in the DataTables initialisation to
   be true - i.e. `pageResize: true`
 * Setting the `pageResize` parameter to be true in the DataTables
   defaults (thus causing all tables to have this feature) - i.e.
   `$.fn.dataTable.defaults.pageResize = true`.
 * Creating a new instance: `new $.fn.dataTable.PageResize( table );` where
   `table` is a DataTable's API instance.

 For more detailed information please see:
     http://datatables.net/blog/2015-04-10
 PageResize for DataTables v1.0.0
 2015 SpryMedia Ltd - datatables.net/license
*/
(function(b){"function"===typeof define&&define.amd?define(["jquery","datatables.net"],function(d){return b(d,window,document)}):"object"===typeof exports?module.exports=function(d,c){d||(d=window);c&&c.fn.dataTable||(c=require("datatables.net")(d,c).$);return b(c,d,d.document)}:b(jQuery,window,document)})(function(b,d,c,l){var f=function(a,h){var e=a.table();this.s={dt:a,host:b(e.container()).parent(),header:b(e.header()),footer:b(e.footer()),body:b(e.body()),container:b(e.container()),table:b(e.node()),
delta:h};a=this.s.host;"static"===a.css("position")&&a.css("position","relative");this._attach();this._size()};f.prototype={_size:function(){var a=this.s,h=a.dt,e=h.table(),d=b(a.table).offset().top,c=b("tr",a.body);c=c.eq(1<c.length?1:0).height();var g=a.host.height(),f=e.header().parentNode!==e.body().parentNode,k=a.delta;f||(e.header()&&(g-=a.header.height()),e.footer()&&(g-=a.footer.height()));g=g-d-(a.container.height()-(d+a.table.height()));!isNaN(parseFloat(k))&&isFinite(k)&&(g-=k);a=Math.floor(g/
c);Infinity!==a&&-Infinity!==a&&!isNaN(a)&&0<a&&a!==h.page.len()&&h.page.len(a).draw()},_attach:function(){var a=this,c=b("<object/>").css({position:"absolute",top:0,left:0,height:"100%",width:"100%",zIndex:-1}).attr("type","text/html");c[0].onload=function(){var b=this.contentDocument.body,c=b.offsetHeight;this.contentDocument.defaultView.onresize=function(){var d=b.clientHeight||b.offsetHeight;d!==c&&(c=d,a._size())}};c.appendTo(this.s.host).attr("data","about:blank")}};b.fn.dataTable.PageResize=
f;b.fn.DataTable.PageResize=f;b(c).on("init.dt",function(a,c){"dt"===a.namespace&&(a=new b.fn.dataTable.Api(c),(b(a.table().node()).hasClass("pageResize")||c.oInit.pageResize||b.fn.dataTable.defaults.pageResize)&&new f(a,c.oInit.pageResizeManualDelta))})});
