/**
 * Get a TD node from a row, taking into account column visibility. While 
 * getting a TD node is easy when it is visible on the page by using normal 
 * DOM methods, jQuery or whatever, it becomes a lot more complicated when 
 * taking into account hidden rows and columns. This function can be used to
 * overcome these difficulties.
 *  @name fnColumnIndexToVisible
 *  @anchor fnColumnIndexToVisible
 *  @author <a href="http://sprymedia.co.uk">Allan Jardine</a>
 *
 *  @example
 *    $(document).ready(function() {
 *        var oTable = $('#example').dataTable();
 *         
 *        // Sort in the order that was origially in the HTML
 *        var nTd = oTable.fnGetTd( $('#example tbody tr:eq(1)')[0], 1 );
 *        console.log( nTd );
 *    } );
 */

$.fn.dataTableExt.oApi.fnGetTd  = function ( oSettings, mTr, iTd, bVisOnly )
{
	/* Take either a TR node or aoData index as the mTr property */
	var iRow = (typeof mTr == 'object') ? 
		oSettings.oApi._fnNodeToDataIndex(oSettings, mTr) : mTr;
	 
	if ( typeof bVisOnly == 'undefined' && !bVisOnly )
	{
		/* Looking at both visible and hidden TD elements - convert to visible index, if not present
		 * then it must be hidden. Return as appropriate
		 */
		var iCalcVis = oSettings.oApi._fnColumnIndexToVisible( oSettings, iTd );
		if ( iCalcVis !== null )
		{
			return oSettings.aoData[ iRow ].nTr.getElementsByTagName('td')[ iCalcVis ];
		}
		else
		{
			return oSettings.aoData[ iRow ]._anHidden[ iTd ];
		}
	}
	else
	{
		/* Only looking at visible TD elements, so just use getElements... */
		return oSettings.aoData[ iRow ].nTr.getElementsByTagName('td')[ iTd ];
	}
};
