!function(window){var ClassVariable;return ClassVariable=function(){function Diff2Html(){}function escape(str){return str.slice(0).replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/\t/g,"    ")}function startsWith(str,start){return 0===str.indexOf(start)}function valueOrEmpty(value){return value?value:""}var LINE_TYPE={INSERTS:"d2h-ins",ALL_NEW:"d2h-all-ins",DELETES:"d2h-del",ALL_DELETED:"d2h-all-del",INSERTS_AND_DELETES:"d2h-ins-and-del",CONTEXT:"d2h-cntx",INFO:"d2h-info"};Diff2Html.prototype.getPrettyHtmlFromDiff=function(diffInput){var diffJson=generateDiffJson(diffInput);return generateJsonHtml(diffJson)},Diff2Html.prototype.getJsonFromDiff=function(diffInput){return generateDiffJson(diffInput)},Diff2Html.prototype.getPrettyHtmlFromJson=function(diffJson){return generateJsonHtml(diffJson)},Diff2Html.prototype.getPrettySideBySideHtmlFromDiff=function(diffInput){var diffJson=generateDiffJson(diffInput);return generateSideBySideJsonHtml(diffJson)},Diff2Html.prototype.getPrettySideBySideHtmlFromJson=function(diffJson){return generateSideBySideJsonHtml(diffJson)};var instance,generateDiffJson=function(diffInput){var files=[],currentFile=null,currentBlock=null,oldLine=null,newLine=null,saveBlock=function(){currentBlock&&(currentFile.blocks.push(currentBlock),currentBlock=null)},saveFile=function(){currentFile&&(files.push(currentFile),currentFile=null)},startFile=function(line){saveBlock(),saveFile(),currentFile={},currentFile.blocks=[],currentFile.deletedLines=0,currentFile.addedLines=0;var values=/^diff --git a\/(\S+) b\/(\S+).*$/.exec(line);currentFile.oldName=values[1],currentFile.newName=values[2]},startBlock=function(line){saveBlock();var values;(values=/^(@@ -(\d+),(\d+) \+(\d+),(\d+) @@).*/.exec(line))?(oldLine=values[2],newLine=values[4]):(oldLine=0,newLine=0),currentBlock={},currentBlock.lines=[],currentBlock.oldStartLine=oldLine,currentBlock.newStartLine=newLine,currentBlock.header=line},createLine=function(line){var isLineWithInserts=/{\+.*?\+}/.exec(line),isNewLine=/^{\+.*?\+}$/.exec(line),isLineWithDeletes=/\[-.*?-\]/.exec(line),isRemovedLine=/^\[-.*?-\]$/.exec(line),isLineWithBoth=isLineWithInserts&&isLineWithDeletes,isContextLine=!isLineWithInserts&&!isLineWithDeletes,currentLine={};currentLine.content=line,isLineWithBoth?(currentFile.deletedLines++,currentFile.addedLines++,currentLine.type=LINE_TYPE.INSERTS_AND_DELETES,currentLine.oldNumber=oldLine++,currentLine.newNumber=newLine++,currentBlock.lines.push(currentLine)):isContextLine?(currentLine.type=LINE_TYPE.CONTEXT,currentLine.oldNumber=oldLine++,currentLine.newNumber=newLine++,currentBlock.lines.push(currentLine)):isNewLine?(currentFile.addedLines++,currentLine.type=LINE_TYPE.ALL_NEW,currentLine.oldNumber=null,currentLine.newNumber=newLine++,currentBlock.lines.push(currentLine)):isRemovedLine?(currentFile.deletedLines++,currentLine.type=LINE_TYPE.ALL_DELETED,currentLine.oldNumber=oldLine++,currentLine.newNumber=null,currentBlock.lines.push(currentLine)):isLineWithInserts?(currentFile.addedLines++,currentLine.type=LINE_TYPE.INSERTS,currentLine.oldNumber=oldLine++,currentLine.newNumber=newLine++,currentBlock.lines.push(currentLine)):isLineWithDeletes&&(currentFile.deletedLines++,currentLine.type=LINE_TYPE.DELETES,currentLine.oldNumber=oldLine++,currentLine.newNumber=newLine++,currentBlock.lines.push(currentLine))},diffLines=diffInput.split("\n");return diffLines.forEach(function(line){!line||startsWith(line,"*")||startsWith(line,"new")||startsWith(line,"index")||startsWith(line,"---")||startsWith(line,"+++")||(startsWith(line,"diff")?startFile(line):currentFile&&startsWith(line,"@@")?startBlock(line):currentBlock&&createLine(line))}),saveBlock(),saveFile(),files},generateJsonHtml=function(diffFiles){return'<div class="d2h-wrapper">\n'+diffFiles.map(function(file){return'<div class="d2h-file-wrapper">\n     <div class="d2h-file-header">\n       <div class="d2h-file-stats">\n         <span class="d2h-lines-added">+'+file.addedLines+'</span>\n         <span class="d2h-lines-deleted">-'+file.deletedLines+'</span>\n       </div>\n       <div class="d2h-file-name">'+getDiffName(file.oldName,file.newName)+'</div>\n     </div>\n     <div class="d2h-file-diff">\n       <div class="d2h-code-wrapper">\n         <table class="d2h-diff-table">\n           <tbody class="d2h-diff-tbody">\n         '+generateFileHtml(file)+"           </tbody>\n         </table>\n       </div>\n     </div>\n   </div>\n"}).join("\n")+"</div>\n"},generateFileHtml=function(file){return file.blocks.map(function(block){return'<tr>\n  <td class="d2h-code-linenumber '+LINE_TYPE.INFO+'" colspan="2"></td>\n  <td class="'+LINE_TYPE.INFO+'">    <div class="d2h-code-line '+LINE_TYPE.INFO+'">'+escape(block.header)+"</div>  </td>\n</tr>\n"+block.lines.map(function(line){var newLine=function(){var lineData={};return lineData.oldLine=valueOrEmpty(line.oldNumber),lineData.newLine=valueOrEmpty(line.newNumber),lineData},escapedLine=escape(line.content),lines=[],lineData={};switch(line.type){case LINE_TYPE.INSERTS:case LINE_TYPE.ALL_NEW:lineData=newLine(),lineData.content=generateLineInsertions(escapedLine),lineData.type=LINE_TYPE.INSERTS,lines.push(lineData);break;case LINE_TYPE.DELETES:case LINE_TYPE.ALL_DELETED:lineData=newLine(),lineData.content=generateLineDeletions(escapedLine),lineData.type=LINE_TYPE.DELETES,lines.push(lineData);break;case LINE_TYPE.INSERTS_AND_DELETES:lineData=newLine(),lineData.content=generateLineDeletions(escapedLine),lineData.type=LINE_TYPE.DELETES,lines.push(lineData),lineData=newLine(),lineData.content=generateLineInsertions(escapedLine),lineData.type=LINE_TYPE.INSERTS,lines.push(lineData);break;default:lineData=newLine(),lineData.content=escapedLine,lineData.type=LINE_TYPE.CONTEXT,lines.push(lineData)}return lines.map(generateLineHtml).join("\n")}).join("\n")}).join("\n")},generateLineHtml=function(line){return'<tr>\n  <td class="d2h-code-linenumber '+line.type+'">    <div class="line-num1">'+line.oldLine+'</div>    <div class="line-num2">'+line.newLine+'</div>  </td>\n  <td class="'+line.type+'">    <div class="d2h-code-line '+line.type+'">'+line.content+"</div>  </td>\n</tr>\n"},generateSideBySideJsonHtml=function(diffFiles){return'<div class="d2h-wrapper">\n'+diffFiles.map(function(file){return'<div class="d2h-file-wrapper">\n     <div class="d2h-file-header">\n       <div class="d2h-file-stats">\n         <span class="d2h-lines-added">+'+file.addedLines+'</span>\n         <span class="d2h-lines-deleted">-'+file.deletedLines+'</span>\n       </div>\n       <div class="d2h-file-name">'+getDiffName(file.oldName,file.newName)+'</div>\n     </div>\n     <div class="d2h-files-diff">\n       <div class="d2h-file-side-diff">\n         <div class="d2h-code-wrapper">\n           <table class="d2h-diff-table">\n             <tbody class="d2h-diff-tbody">\n           '+generateLeftSideFileHtml(file)+'             </tbody>\n           </table>\n         </div>\n       </div>\n       <div class="d2h-file-side-diff">\n         <div class="d2h-code-wrapper">\n           <table class="d2h-diff-table">\n             <tbody class="d2h-diff-tbody">\n           '+generateRightSideFileHtml(file)+"             </tbody>\n           </table>\n         </div>\n       </div>\n     </div>\n   </div>\n"}).join("\n")+"</div>\n"},generateLeftSideFileHtml=function(file){return file.blocks.map(function(block){return'<tr>\n  <td class="d2h-code-side-linenumber '+LINE_TYPE.INFO+'"></td>\n  <td class="'+LINE_TYPE.INFO+'" colspan="3">    <div class="d2h-code-side-line '+LINE_TYPE.INFO+'">'+escape(block.header)+"</div>  </td>\n</tr>\n"+block.lines.map(function(line){var emptyLine=function(){var lineData={};return lineData.number="",lineData.content="",lineData.type=LINE_TYPE.CONTEXT,lineData},escapedLine=escape(line.content),lines=[],lineData={};switch(line.type){case LINE_TYPE.INSERTS:lineData={},lineData.number=valueOrEmpty(line.oldNumber),lineData.content=removeInserts(escapedLine),lineData.type=LINE_TYPE.CONTEXT,lines.push(lineData);break;case LINE_TYPE.ALL_NEW:lines.push(new emptyLine);break;case LINE_TYPE.DELETES:lineData={},lineData.number=valueOrEmpty(line.oldNumber),lineData.content=generateLineDeletions(escapedLine),lineData.type=LINE_TYPE.DELETES,lines.push(lineData);break;case LINE_TYPE.ALL_DELETED:lineData={},lineData.number=valueOrEmpty(line.oldNumber),lineData.content=generateLineDeletions(escapedLine),lineData.type=LINE_TYPE.DELETES,lines.push(lineData);break;case LINE_TYPE.INSERTS_AND_DELETES:lineData={},lineData.number=valueOrEmpty(line.oldNumber),lineData.content=generateLineDeletions(escapedLine),lineData.type=LINE_TYPE.DELETES,lines.push(lineData);break;default:lineData={},lineData.number=valueOrEmpty(line.oldNumber),lineData.content=escapedLine,lineData.type=LINE_TYPE.CONTEXT,lines.push(lineData)}return"<tr>\n"+lines.map(generateSingleLineHtml).join("\n")+"</tr>\n"}).join("\n")}).join("\n")},generateRightSideFileHtml=function(file){return file.blocks.map(function(block){return'<tr>\n  <td class="d2h-code-side-linenumber '+LINE_TYPE.INFO+'"></td>\n  <td class="'+LINE_TYPE.INFO+'" colspan="3">    <div class="d2h-code-side-line '+LINE_TYPE.INFO+'"></div>  </td>\n</tr>\n'+block.lines.map(function(line){var emptyLine=function(){var lineData={};return lineData.number="",lineData.content="",lineData.type=LINE_TYPE.CONTEXT,lineData},escapedLine=escape(line.content),lines=[],lineData={};switch(line.type){case LINE_TYPE.INSERTS:lineData={},lineData.number=valueOrEmpty(line.newNumber),lineData.content=generateLineInsertions(escapedLine),lineData.type=LINE_TYPE.INSERTS,lines.push(lineData);break;case LINE_TYPE.ALL_NEW:lineData={},lineData.number=valueOrEmpty(line.newNumber),lineData.content=generateLineInsertions(escapedLine),lineData.type=LINE_TYPE.INSERTS,lines.push(lineData);break;case LINE_TYPE.DELETES:lineData={},lineData.number=valueOrEmpty(line.newNumber),lineData.content=removeDeletes(escapedLine),lineData.type=LINE_TYPE.CONTEXT,lines.push(lineData);break;case LINE_TYPE.ALL_DELETED:lines.push(new emptyLine);break;case LINE_TYPE.INSERTS_AND_DELETES:lineData={},lineData.number=valueOrEmpty(line.newNumber),lineData.content=generateLineInsertions(escapedLine),lineData.type=LINE_TYPE.INSERTS,lines.push(lineData);break;default:lineData={},lineData.number=valueOrEmpty(line.newNumber),lineData.content=escapedLine,lineData.type=LINE_TYPE.CONTEXT,lines.push(lineData)}return"<tr>\n"+lines.map(generateSingleLineHtml).join("\n")+"</tr>\n"}).join("\n")}).join("\n")},generateSingleLineHtml=function(line){return'<td class="d2h-code-side-linenumber '+line.type+'">'+line.number+'</td>\n   <td class="'+line.type+'">     <div class="d2h-code-side-line '+line.type+'">'+line.content+"</div>   </td>\n"},getDiffName=function(oldFilename,newFilename){return oldFilename===newFilename?newFilename:oldFilename+" -> "+newFilename},generateLineInsertions=function(line){return line.slice(0).replace(/(\[-.*?-\])/g,"").replace(/({\+(.*?)\+})/g,"<ins>$2</ins>")},generateLineDeletions=function(line){return line.slice(0).replace(/({\+.*?\+})/g,"").replace(/(\[-(.*?)-\])/g,"<del>$2</del>")},removeDeletes=function(line){return line.slice(0).replace(/({\+.*?\+})/g,"").replace(/(\[-.*?-\])/g,"")},removeInserts=function(line){return line.slice(0).replace(/({\+.*?\+})/g,"").replace(/(\[-.*?-\])/g,"")};return{getInstance:function(){return void 0===instance&&(instance=new Diff2Html,instance.constructor=null),instance}}}(),window.Diff2Html=ClassVariable.getInstance(),window.Diff2Html}(window);