dojo.provide("dojox.date.tests.islamic.Date");
dojo.require("dojox.date.islamic.Date");
dojo.require("dojox.date.islamic.locale");
dojo.require("dojox.date.islamic");
dojo.require("dojo.date");
dojo.require("dojo.date.locale");

dojo.requireLocalization("dojo.cldr", "gregorian");
dojo.requireLocalization("dojo.cldr", "islamic");

tests.register("dojox.date.tests.islamic.Date",
	[
		{
			// Test formatting and parsing of dates in various locales pre-built in dojo.cldr
			// NOTE: we can't set djConfig.extraLocale before bootstrapping unit tests, so directly
			// load resources here for specific locales:

			name: "setup",
			setUp: function() {
				var partLocaleList = ["ar","en"];

				dojo.forEach(partLocaleList, function(locale) {
					dojo.requireLocalization("dojo.cldr", "islamic", locale);
				});
			},
			runTest: function(t) {
			},
			tearDown: function() {
				//Clean up bundles that should not exist if
				//the test is re-run.
			//				delete dojo.cldr.nls.islamic;
			}
		},
		{
			name: "toGregorian",
			runTest: function(t) {
					
			var dateTable = [[1420,0,1,1999,3,17], [1420,0,12,1999,3,28],
			                 [1420,0,23,1999,4,9],
			                 [1420,1,4,1999,4,20],
			                 [1420,1,15,1999,4,31],
			                 [1420,1,26,1999,5,11],
			                 [1420,2,8,1999,5,22],
			                 [1420,2,19,1999,6,3],
			                 [1420,2,30,1999,6,14],
			                 [1420,3,11,1999,6,25],
			                 [1420,3,22,1999,7,5],
			                 [1420,4,4,1999,7,16],
			                 [1420,4,15,1999,7,27],
			                 [1420,4,26,1999,8,7],
			                 [1420,5,7,1999,8,18],
			                 [1420,5,18,1999,8,29],
			                 [1420,5,29,1999,9,10],
			                 [1420,6,11,1999,9,21],
			                 [1420,6,22,1999,10,1],
			                 [1420,7,3,1999,10,12],
			                 [1420,7,14,1999,10,23],
			                 [1420,8,29,2000,0,6],
			                 [1420,9,10,2000,0,17],
			                 [1420,9,21,2000,0,28],
			                 [1420,10,3,2000,1,8],
			                 [1420,10,14,2000,1,19],
			                 [1420,10,25,2000,2,1],
			                 [1420,11,6,2000,2,12],
			                 [1420,11,17,2000,2,23],
			                 [1420,11,28,2000,3,3],
			                 [1421,0,9,2000,3,14],
			                 [1421,0,20,2000,3,25],
			                 [1421,1,1,2000,4,6],
			                 [1421,1,12,2000,4,17],
			                 [1421,1,23,2000,4,28],
			                 [1421,2,5,2000,5,8],
			                 [1421,2,16,2000,5,19],
			                 [1421,2,27,2000,5,30],
			                 [1421,3,8,2000,6,11],
			                 [1421,3,19,2000,6,22],
			                 [1421,4,1,2000,7,2],
			                 [1421,4,12,2000,7,13],
			                 [1421,4,23,2000,7,24],
			                 [1421,5,4,2000,8,4],
			                 [1421,5,15,2000,8,15],
			                 [1421,5,26,2000,8,26],
			                 [1421,6,8,2000,9,7],
			                 [1421,6,19,2000,9,18],
			                 [1421,6,30,2000,9,29],
			                 [1421,7,11,2000,10,9],
			                 [1421,7,22,2000,10,20],
			                 [1421,9,7,2001,0,3],
			                 [1421,9,18,2001,0,14],
			                 [1421,9,7,2001,0,3],
			                 [1421,9,18,2001,0,14],
			                 [1421,9,29,2001,0,25],
			                 [1421,10,11,2001,1,5],
			                 [1421,10,22,2001,1,16],
			                 [1421,11,3,2001,1,27],
			                 [1421,11,14,2001,2,10],
			                 [1421,11,25,2001,2,21],
			                 [1422,0,7,2001,3,1],
			                 [1422,0,18,2001,3,12],
			                 [1422,0,29,2001,3,23],
			                 [1422,1,10,2001,4,4],
			                 [1422,1,21,2001,4,15],
			                 [1422,2,3,2001,4,26],
			                 [1422,2,14,2001,5,6],
			                 [1422,2,25,2001,5,17],
			                 [1422,3,6,2001,5,28],
			                 [1422,3,17,2001,6,9],
			                 [1422,3,28,2001,6,20],
			                 [1422,4,10,2001,6,31],
			                 [1422,4,21,2001,7,11],
			                 [1422,5,2,2001,7,22],
			                 [1422,5,13,2001,8,2],
			                 [1422,5,24,2001,8,13],
			                 [1422,6,6,2001,8,24],
			                 [1422,6,17,2001,9,5],
			                 [1422,6,28,2001,9,16],
			                 [1422,7,9,2001,9,27],
			                 [1422,7,20,2001,10,7],
			                 [1422,8,2,2001,10,18],
			                 [1422,8,13,2001,10,29],
			                 [1422,8,24,2001,11,10],
			                 [1422,9,5,2001,11,21],
			                 [1422,9,16,2002,0,1],
			                 [1422,9,27,2002,0,12],
			                 [1422,10,9,2002,0,23],
			                 [1422,10,20,2002,1,3],
			                 [1422,11,1,2002,1,14],
			                 [1422,11,12,2002,1,25],
			                 [1422,11,23,2002,2,8],
			                 [1423,0,5,2002,2,19],
			                 [1423,0,16,2002,2,30],
			                 [1423,0,27,2002,3,10],
			                 [1423,1,8,2002,3,21],
			                 [1423,1,19,2002,4,2],
			                 [1423,2,1,2002,4,13],
			                 [1423,2,12,2002,4,24],
			                 [1423,2,23,2002,5,4],
			                 [1423,3,4,2002,5,15],
			                 [1423,3,15,2002,5,26],
			                 [1423,3,26,2002,6,7],
			                 [1423,4,8,2002,6,18],
			                 [1423,4,19,2002,6,29],
			                 [1423,4,30,2002,7,9],
			                 [1423,5,11,2002,7,20],
			                 [1423,5,22,2002,7,31],
			                 [1423,6,4,2002,8,11],
			                 [1423,6,15,2002,8,22],
			                 [1423,6,26,2002,9,3],
			                 [1423,7,7,2002,9,14],
			                 [1423,7,18,2002,9,25],
			                 [1423,7,29,2002,10,5],
			                 [1423,8,11,2002,10,16],
			                 [1423,8,22,2002,10,27],
			                 [1423,9,3,2002,11,8],
			                 [1423,9,14,2002,11,19],
			                 [1423,9,25,2002,11,30],
			                 [1423,10,7,2003,0,10],
			                 [1423,10,18,2003,0,21],
			                 [1423,10,29,2003,1,1],
			                 [1423,11,10,2003,1,12],
			                 [1423,11,21,2003,1,23],
			                 [1424,0,2,2003,2,6],
			                 [1424,0,13,2003,2,17],
			                 [1424,0,24,2003,2,28],
			                 [1424,1,5,2003,3,8],
			                 [1424,1,16,2003,3,19],
			                 [1424,1,27,2003,3,30],
			                 [1424,2,9,2003,4,11],
			                 [1424,2,20,2003,4,22],
			                 [1424,3,1,2003,5,2],
			                 [1424,3,12,2003,5,13],
			                 [1424,3,23,2003,5,24],
			                 [1424,4,5,2003,6,5],
			                 [1424,4,16,2003,6,16],
			                 [1424,4,27,2003,6,27],
			                 [1424,5,8,2003,7,7],
			                 [1424,5,19,2003,7,18],
			                 [1424,6,1,2003,7,29],
			                 [1424,6,12,2003,8,9],
			                 [1424,6,23,2003,8,20],
			                 [1424,7,4,2003,9,1],
			                 [1424,7,15,2003,9,12],
			                 [1424,7,26,2003,9,23],
			                 [1424,8,8,2003,10,3],
			                 [1424,8,19,2003,10,14],
			                 [1424,8,30,2003,10,25],
			                 [1424,10,15,2004,0,8],
			                 [1424,10,26,2004,0,19],
			                 [1424,11,7,2004,0,30],
			                 [1424,11,18,2004,1,10],
			                 [1424,11,29,2004,1,21],
			                 [1425,0,11,2004,2,3],
			                 [1425,0,22,2004,2,14],
			                 [1425,1,3,2004,2,25],
			                 [1425,1,14,2004,3,5],
			                 [1425,1,25,2004,3,16],
			                 [1425,2,7,2004,3,27],
			                 [1425,2,18,2004,4,8],
			                 [1425,2,29,2004,4,19],
			                 [1425,3,10,2004,4,30],
			                 [1425,3,21,2004,5,10],
			                 [1425,4,3,2004,5,21],
			                 [1425,4,14,2004,6,2],
			                 [1425,4,25,2004,6,13],
			                 [1425,5,6,2004,6,24],
			                 [1425,5,17,2004,7,4],
			                 [1425,5,28,2004,7,15],
			                 [1425,6,10,2004,7,26],
			                 [1425,6,21,2004,8,6],
			                 [1425,7,2,2004,8,17],
			                 [1425,7,13,2004,8,28],
			                 [1425,7,24,2004,9,9],
			                 [1425,8,6,2004,9,20],
			                 [1425,8,17,2004,9,31],
			                 [1425,8,28,2004,10,11],
			                 [1425,9,9,2004,10,22],
			                 [1425,10,24,2005,0,5],
			                 [1425,11,5,2005,0,16],
			                 [1425,11,16,2005,0,27],
			                 [1425,11,27,2005,1,7],
			                 [1426,0,9,2005,1,18],
			                 [1426,0,20,2005,2,1],
			                 [1426,1,1,2005,2,12],
			                 [1426,1,12,2005,2,23],
			                 [1426,1,23,2005,3,3],
			                 [1426,2,5,2005,3,14],
			                 [1426,2,16,2005,3,25],
			                 [1426,2,27,2005,4,6],
			                 [1426,3,8,2005,4,17],
			                 [1426,3,19,2005,4,28],
			                 [1426,4,1,2005,5,8],
			                 [1426,4,12,2005,5,19],
			                 [1426,4,23,2005,5,30],
			                 [1426,5,4,2005,6,11],
			                 [1426,5,15,2005,6,22],
			                 [1426,5,26,2005,7,2],
			                 [1426,6,8,2005,7,13],
			                 [1426,6,19,2005,7,24],
			                 [1426,6,30,2005,8,4],
			                 [1426,7,11,2005,8,15],
			                 [1426,7,22,2005,8,26],
			                 [1426,8,4,2005,9,7],
			                 [1426,8,15,2005,9,18],
			                 [1426,8,26,2005,9,29],
			                 [1426,9,7,2005,10,9],
			                 [1426,9,18,2005,10,20],
			                 [1426,9,29,2005,11,1],
			                 [1426,10,11,2005,11,12],
			                 [1426,10,22,2005,11,23],
			                 [1426,11,3,2006,0,3],
			                 [1426,11,14,2006,0,14],
			                 [1426,11,25,2006,0,25],
			                 [1427,0,6,2006,1,5],
			                 [1427,0,17,2006,1,16],
			                 [1427,0,28,2006,1,27],
			                 [1427,1,9,2006,2,10],
			                 [1427,1,20,2006,2,21],
			                 [1427,2,2,2006,3,1],
			                 [1427,2,13,2006,3,12],
			                 [1427,2,24,2006,3,23],
			                 [1427,3,5,2006,4,4],
			                 [1427,3,16,2006,4,15],
			                 [1427,3,27,2006,4,26],
			                 [1427,4,9,2006,5,6],
			                 [1427,4,20,2006,5,17],
			                 [1427,5,1,2006,5,28],
			                 [1427,5,12,2006,6,9],
			                 [1427,5,23,2006,6,20],
			                 [1427,6,5,2006,6,31],
			                 [1427,6,16,2006,7,11],
			                 [1427,6,27,2006,7,22],
			                 [1427,7,8,2006,8,2],
			                 [1427,7,19,2006,8,13],
			                 [1427,8,1,2006,8,24],
			                 [1427,8,12,2006,9,5],
			                 [1427,8,23,2006,9,16],
			                 [1427,9,4,2006,9,27],
			                 [1427,9,15,2006,10,7],
			                 [1427,9,26,2006,10,18],
			                 [1427,10,8,2006,10,29],
			                 [1427,10,19,2006,11,10],
			                 [1427,10,30,2006,11,21],
			                 [1427,11,11,2007,0,1],
			                 [1427,11,22,2007,0,12],
			                 [1428,0,4,2007,0,23],
			                 [1428,0,15,2007,1,3],
			                 [1428,0,26,2007,1,14],
			                 [1428,1,7,2007,1,25],
			                 [1428,1,18,2007,2,8],
			                 [1428,1,29,2007,2,19],
			                 [1428,2,11,2007,2,30],
			                 [1428,2,22,2007,3,10],
			                 [1428,3,3,2007,3,21],
			                 [1428,3,14,2007,4,2],
			                 [1428,3,25,2007,4,13],
			                 [1428,4,7,2007,4,24],
			                 [1428,4,18,2007,5,4],
			                 [1428,4,29,2007,5,15],
			                 [1428,5,10,2007,5,26],
			                 [1428,5,21,2007,6,7],
			                 [1428,6,3,2007,6,18],
			                 [1428,6,14,2007,6,29],
			                 [1428,6,25,2007,7,9],
			                 [1428,7,6,2007,7,20],
			                 [1428,7,17,2007,7,31],
			                 [1428,7,28,2007,8,11],
			                 [1428,8,10,2007,8,22],
			                 [1428,8,21,2007,9,3],
			                 [1428,9,2,2007,9,14],
			                 [1428,9,13,2007,9,25],
			                 [1428,9,24,2007,10,5],
			                 [1428,10,6,2007,10,16],
			                 [1428,10,17,2007,10,27],
			                 [1429,0,1,2008,0,10],
			                 [1429,0,12,2008,0,21],
			                 [1429,0,23,2008,1,1],
			                 [1429,1,4,2008,1,12],
			                 [1429,1,15,2008,1,23],
			                 [1429,1,26,2008,2,5],
			                 [1429,2,8,2008,2,16],
			                 [1429,2,19,2008,2,27],
			                 [1429,2,30,2008,3,7],
			                 [1429,3,11,2008,3,18],
			                 [1429,3,22,2008,3,29],
			                 [1429,4,4,2008,4,10],
			                 [1429,4,15,2008,4,21],
			                 [1429,4,26,2008,5,1],
			                 [1429,5,7,2008,5,12],
			                 [1429,5,18,2008,5,23],
			                 [1429,5,29,2008,6,4],
			                 [1429,6,11,2008,6,15],
			                 [1429,6,22,2008,6,26],
			                 [1429,7,3,2008,7,6],
			                 [1429,7,14,2008,7,17],
			                 [1429,7,25,2008,7,28],
			                 [1429,8,7,2008,8,8],
			                 [1429,8,18,2008,8,19],
			                 [1429,8,29,2008,8,30],
			                 [1429,9,10,2008,9,11],
			                 [1429,9,21,2008,9,22],
			                 [1429,10,3,2008,10,2],
			                 [1429,10,14,2008,10,13],
			                 [1429,10,25,2008,10,24],
			                 [1430,0,10,2009,0,7],
			                 [1430,0,21,2009,0,18],
			                 [1430,1,2,2009,0,29],
			                 [1430,1,13,2009,1,9],
			                 [1430,1,24,2009,1,20],
			                 [1430,2,6,2009,2,3],
			                 [1430,2,17,2009,2,14],
			                 [1430,2,28,2009,2,25],
			                 [1430,3,9,2009,3,5],
			                 [1430,3,20,2009,3,16],
			                 [1430,4,2,2009,3,27],
			                 [1430,4,13,2009,4,8],
			                 [1430,4,24,2009,4,19],
			                 [1430,5,5,2009,4,30],
			                 [1430,5,16,2009,5,10],
			                 [1430,5,27,2009,5,21],
			                 [1430,6,9,2009,6,2],
			                 [1430,6,20,2009,6,13],
			                 [1430,7,1,2009,6,24],
			                 [1430,7,12,2009,7,4],
			                 [1430,7,23,2009,7,15],
			                 [1430,8,5,2009,7,26],
			                 [1430,8,16,2009,8,6],
			                 [1430,8,27,2009,8,17],
			                 [1430,9,8,2009,8,28],
			                 [1430,9,19,2009,9,9],
			                 [1430,10,1,2009,9,20],
			                 [1430,10,12,2009,9,31],
			                 [1430,10,23,2009,10,11],
			                 [1430,11,4,2009,10,22],
			                 [1430,11,15,2009,11,3],
			                 [1430,11,26,2009,11,14],
			                 [1431,0,8,2009,11,25],
			                 [1431,0,19,2010,0,5],
			                 [1431,0,30,2010,0,16],
			                 [1431,1,11,2010,0,27],
			                 [1431,1,22,2010,1,7],
			                 [1431,2,4,2010,1,18],
			                 [1431,2,15,2010,2,1],
			                 [1431,2,26,2010,2,12],
			                 [1431,3,7,2010,2,23],
			                 [1431,3,18,2010,3,3],
			                 [1431,3,29,2010,3,14],
			                 [1431,4,11,2010,3,25],
			                 [1431,4,22,2010,4,6],
			                 [1431,5,3,2010,4,17],
			                 [1431,5,14,2010,4,28],
			                 [1431,5,25,2010,5,8],
			                 [1431,6,7,2010,5,19],
			                 [1431,6,18,2010,5,30],
			                 [1431,6,29,2010,6,11],
			                 [1431,7,10,2010,6,22],
			                 [1431,7,21,2010,7,2],
			                 [1431,8,3,2010,7,13],
			                 [1431,8,14,2010,7,24],
			                 [1431,8,25,2010,8,4],
			                 [1431,9,6,2010,8,15],
			                 [1431,9,17,2010,8,26],
			                 [1431,9,28,2010,9,7],
			                 [1431,10,10,2010,9,18],
			                 [1431,10,21,2010,9,29],
			                 [1431,11,2,2010,10,9],
			                 [1431,11,13,2010,10,20],
			                 [1431,11,24,2010,11,1],
			                 [1432,0,5,2010,11,12],
			                 [1432,0,16,2010,11,23],
			                 [1432,0,27,2011,0,3],
			                 [1432,1,8,2011,0,14],
			                 [1432,1,19,2011,0,25],
			                 [1432,2,1,2011,1,5],
			                 [1432,2,12,2011,1,16],
			                 [1432,2,23,2011,1,27],
			                 [1432,3,4,2011,2,10],
			                 [1432,3,15,2011,2,21],
			                 [1432,3,26,2011,3,1],
			                 [1432,4,8,2011,3,12],
			                 [1432,4,19,2011,3,23],
			                 [1432,4,30,2011,4,4],
			                 [1432,5,11,2011,4,15],
			                 [1432,5,22,2011,4,26],
			                 [1432,6,4,2011,5,6],
			                 [1432,6,15,2011,5,17],
			                 [1432,6,26,2011,5,28],
			                 [1432,7,7,2011,6,9],
			                 [1432,7,18,2011,6,20],
			                 [1432,7,29,2011,6,31],
			                 [1432,8,11,2011,7,11],
			                 [1432,8,22,2011,7,22],
			                 [1432,9,3,2011,8,2],
			                 [1432,9,14,2011,8,13],
			                 [1432,9,25,2011,8,24],
			                 [1432,10,7,2011,9,5],
			                 [1432,10,18,2011,9,16],
			                 [1432,10,29,2011,9,27],
			                 [1432,11,10,2011,10,7],
			                 [1432,11,21,2011,10,18],
			                 [1433,0,3,2011,10,29],
			                 [1433,1,6,2012,0,1],
			                 [1433,1,17,2012,0,12],
			                 [1433,1,28,2012,0,23],
			                 [1433,2,10,2012,1,3],
			                 [1433,2,21,2012,1,14],
			                 [1433,3,2,2012,1,25],
			                 [1433,3,13,2012,2,7],
			                 [1433,3,24,2012,2,18],
			                 [1433,4,6,2012,2,29],
			                 [1433,4,17,2012,3,9],
			                 [1433,4,28,2012,3,20],
			                 [1433,5,9,2012,4,1],
			                 [1433,5,20,2012,4,12],
			                 [1433,6,2,2012,4,23],
			                 [1433,6,13,2012,5,3],
			                 [1433,6,24,2012,5,14],
			                 [1433,7,5,2012,5,25],
			                 [1433,7,16,2012,6,6],
			                 [1433,7,27,2012,6,17],
			                 [1433,8,9,2012,6,28],
			                 [1433,8,20,2012,7,8],
			                 [1433,9,1,2012,7,19],
			                 [1433,9,12,2012,7,30],
			                 [1433,9,23,2012,8,10],
			                 [1433,10,5,2012,8,21],
			                 [1433,10,16,2012,9,2],
			                 [1433,10,27,2012,9,13],
			                 [1433,11,8,2012,9,24],
			                 [1433,11,19,2012,10,4],
			                 [1434,0,1,2012,10,15],
			                 [1434,0,12,2012,10,26],
			                 [1434,1,26,2013,0,9],
			                 [1434,2,8,2013,0,20],
			                 [1434,2,19,2013,0,31],
			                 [1434,2,30,2013,1,11],
			                 [1434,3,11,2013,1,22],
			                 [1434,3,22,2013,2,5],
			                 [1434,4,4,2013,2,16],
			                 [1434,4,15,2013,2,27],
			                 [1434,4,26,2013,3,7],
			                 [1434,5,7,2013,3,18],
			                 [1434,5,18,2013,3,29],
			                 [1434,5,29,2013,4,10],
			                 [1434,6,11,2013,4,21],
			                 [1434,6,22,2013,5,1],
			                 [1434,7,3,2013,5,12],
			                 [1434,7,14,2013,5,23],
			                 [1434,7,25,2013,6,4],
			                 [1434,8,7,2013,6,15],
			                 [1434,8,18,2013,6,26],
			                 [1434,8,29,2013,7,6],
			                 [1434,9,10,2013,7,17],
			                 [1434,9,21,2013,7,28],
			                 [1434,10,3,2013,8,8],
			                 [1434,10,14,2013,8,19],
			                 [1434,10,25,2013,8,30],
			                 [1434,11,6,2013,9,11],
			                 [1434,11,17,2013,9,22],
			                 [1434,11,28,2013,10,2],
			                 [1435,0,9,2013,10,13],
			                 [1435,0,20,2013,10,24],
			                 [1435,1,1,2013,11,5],
			                 [1435,1,12,2013,11,16],
			                 [1435,1,23,2013,11,27],
			                 [1435,2,5,2014,0,7],
			                 [1435,2,16,2014,0,18],
			                 [1435,2,27,2014,0,29],
			                 [1435,3,8,2014,1,9],
			                 [1435,3,19,2014,1,20],
			                 [1435,4,1,2014,2,3],
			                 [1435,4,12,2014,2,14],
			                 [1435,4,23,2014,2,25],
			                 [1435,5,4,2014,3,5],
			                 [1435,5,15,2014,3,16],
			                 [1435,5,26,2014,3,27],
			                 [1435,6,8,2014,4,8],
			                 [1435,6,19,2014,4,19],
			                 [1435,6,30,2014,4,30],
			                 [1435,7,11,2014,5,10],
			                 [1435,7,22,2014,5,21],
			                 [1435,8,4,2014,6,2],
			                 [1435,8,15,2014,6,13],
			                 [1435,8,26,2014,6,24],
			                 [1435,9,7,2014,7,4],
			                 [1435,9,18,2014,7,15],
			                 [1435,9,29,2014,7,26],
			                 [1435,10,11,2014,8,6],
			                 [1435,10,22,2014,8,17],
			                 [1435,11,3,2014,8,28],
			                 [1435,11,14,2014,9,9],
			                 [1435,11,25,2014,9,20],
			                 [1436,0,7,2014,9,31],
			                 [1436,0,18,2014,10,11],
			                 [1436,0,29,2014,10,22],
			                 [1436,1,10,2014,11,3],
			                 [1436,1,21,2014,11,14],
			                 [1436,2,3,2014,11,25],
			                 [1436,2,14,2015,0,5],
			                 [1436,2,25,2015,0,16],
			                 [1436,3,6,2015,0,27],
			                 [1436,3,17,2015,1,7],
			                 [1436,3,28,2015,1,18],
			                 [1436,4,10,2015,2,1],
			                 [1436,4,21,2015,2,12],
			                 [1436,5,2,2015,2,23],
			                 [1436,5,13,2015,3,3],
			                 [1436,5,24,2015,3,14],
			                 [1436,6,6,2015,3,25],
			                 [1436,6,17,2015,4,6],
			                 [1436,6,28,2015,4,17],
			                 [1436,7,9,2015,4,28],
			                 [1436,7,20,2015,5,8],
			                 [1436,8,2,2015,5,19],
			                 [1436,8,13,2015,5,30],
			                 [1436,8,24,2015,6,11],
			                 [1436,9,5,2015,6,22],
			                 [1436,9,16,2015,7,2],
			                 [1436,9,27,2015,7,13],
			                 [1436,10,9,2015,7,24],
			                 [1436,10,20,2015,8,4],
			                 [1436,11,1,2015,8,15],
			                 [1436,11,12,2015,8,26],
			                 [1436,11,23,2015,9,7],
			                 [1437,0,4,2015,9,18],
			                 [1437,0,15,2015,9,29],
			                 [1437,0,26,2015,10,9],
			                 [1437,1,7,2015,10,20],
			                 [1437,2,22,2016,0,3],
			                 [1437,3,3,2016,0,14],
			                 [1437,3,14,2016,0,25],
			                 [1437,3,25,2016,1,5],
			                 [1437,4,7,2016,1,16],
			                 [1437,4,18,2016,1,27],
			                 [1437,4,29,2016,2,9],
			                 [1437,5,10,2016,2,20],
			                 [1437,5,21,2016,2,31],
			                 [1437,6,3,2016,3,11],
			                 [1437,6,14,2016,3,22],
			                 [1437,6,25,2016,4,3],
			                 [1437,7,6,2016,4,14],
			                 [1437,7,17,2016,4,25],
			                 [1437,7,28,2016,5,5],
			                 [1437,8,10,2016,5,16],
			                 [1437,8,21,2016,5,27],
			                 [1437,9,2,2016,6,8],
			                 [1437,9,13,2016,6,19],
			                 [1437,9,24,2016,6,30],
			                 [1437,10,6,2016,7,10],
			                 [1437,10,17,2016,7,21],
			                 [1437,10,28,2016,8,1],
			                 [1437,11,9,2016,8,12],
			                 [1437,11,20,2016,8,23],
			                 [1438,0,2,2016,9,4],
			                 [1438,0,13,2016,9,15],
			                 [1438,0,24,2016,9,26],
			                 [1438,1,5,2016,10,6],
			                 [1438,1,16,2016,10,17],
			                 [1438,1,27,2016,10,28],
			                 [1438,3,12,2017,0,11],
			                 [1438,3,23,2017,0,22],
			                 [1438,4,5,2017,1,2],
			                 [1438,4,16,2017,1,13],
			                 [1438,4,27,2017,1,24],
			                 [1438,5,8,2017,2,7],
			                 [1438,5,19,2017,2,18],
			                 [1438,6,1,2017,2,29],
			                 [1438,6,12,2017,3,9],
			                 [1438,6,23,2017,3,20],
			                 [1438,7,4,2017,4,1],
			                 [1438,7,15,2017,4,12],
			                 [1438,7,26,2017,4,23],
			                 [1438,8,8,2017,5,3],
			                 [1438,8,19,2017,5,14],
			                 [1438,8,30,2017,5,25],
			                 [1438,9,11,2017,6,6],
			                 [1438,9,22,2017,6,17],
			                 [1438,10,4,2017,6,28],
			                 [1438,10,15,2017,7,8],
			                 [1438,10,26,2017,7,19],
			                 [1438,11,7,2017,7,30],
			                 [1438,11,18,2017,8,10],
			                 [1438,11,29,2017,8,21],
			                 [1439,0,11,2017,9,2],
			                 [1439,0,22,2017,9,13],
			                 [1439,1,3,2017,9,24],
			                 [1439,1,14,2017,10,4],
			                 [1439,1,25,2017,10,15],
			                 [1439,2,7,2017,10,26],
			                 [1439,2,18,2017,11,7],
			                 [1439,2,29,2017,11,18],
			                 [1439,3,10,2017,11,29],
			                 [1439,3,21,2018,0,9],
			                 [1439,4,3,2018,0,20],
			                 [1439,4,14,2018,0,31],
			                 [1439,4,25,2018,1,11],
			                 [1439,5,6,2018,1,22],
			                 [1439,5,17,2018,2,5],
			                 [1439,5,28,2018,2,16],
			                 [1439,6,10,2018,2,27],
			                 [1439,6,21,2018,3,7],
			                 [1439,7,2,2018,3,18],
			                 [1439,7,13,2018,3,29],
			                 [1439,7,24,2018,4,10],
			                 [1439,8,6,2018,4,21],
			                 [1439,8,17,2018,5,1],
			                 [1439,8,28,2018,5,12],
			                 [1439,9,9,2018,5,23],
			                 [1439,9,20,2018,6,4],
			                 [1439,10,2,2018,6,15],
			                 [1439,10,13,2018,6,26],
			                 [1439,10,24,2018,7,6],
			                 [1439,11,5,2018,7,17],
			                 [1439,11,16,2018,7,28],
			                 [1439,11,27,2018,8,8],
			                 [1440,0,8,2018,8,19],
			                 [1440,0,19,2018,8,30],
			                 [1440,0,30,2018,9,11],
			                 [1440,1,11,2018,9,22],
			                 [1440,1,22,2018,10,2],
			                 [1440,2,4,2018,10,13],
			                 [1440,2,15,2018,10,24],
			                 [1440,2,26,2018,11,5],
			                 [1440,3,7,2018,11,16],
			                 [1440,3,18,2018,11,27],
			                 [1440,3,29,2019,0,7],
			                 [1440,4,11,2019,0,18],
			                 [1440,4,22,2019,0,29],
			                 [1440,5,3,2019,1,9],
			                 [1440,5,14,2019,1,20],
			                 [1440,5,25,2019,2,3],
			                 [1440,6,7,2019,2,14],
			                 [1440,6,18,2019,2,25],
			                 [1440,6,29,2019,3,5],
			                 [1440,7,10,2019,3,16],
			                 [1440,7,21,2019,3,27],
			                 [1440,8,3,2019,4,8],
			                 [1440,8,14,2019,4,19],
			                 [1440,8,25,2019,4,30],
			                 [1440,9,6,2019,5,10],
			                 [1440,9,17,2019,5,21],
			                 [1440,9,28,2019,6,2],
			                 [1440,10,10,2019,6,13],
			                 [1440,10,21,2019,6,24],
			                 [1440,11,2,2019,7,4],
			                 [1440,11,13,2019,7,15],
			                 [1440,11,24,2019,7,26],
			                 [1441,0,6,2019,8,6],
			                 [1441,0,17,2019,8,17],
			                 [1441,0,28,2019,8,28],
			                 [1441,1,9,2019,9,9],
			                 [1441,1,20,2019,9,20],
			                 [1441,2,2,2019,9,31],
			                 [1441,2,13,2019,10,11],
			                 [1441,2,24,2019,10,22],
			                 [1441,4,9,2020,0,5],
			                 [1441,4,20,2020,0,16],
			                 [1441,5,1,2020,0,27],
			                 [1441,5,12,2020,1,7],
			                 [1441,5,23,2020,1,18],
			                 [1441,6,5,2020,1,29],
			                 [1441,6,16,2020,2,11],
			                 [1441,6,27,2020,2,22],
			                 [1441,7,8,2020,3,2],
			                 [1441,7,19,2020,3,13],
			                 [1441,8,1,2020,3,24],
			                 [1441,8,12,2020,4,5],
			                 [1441,8,23,2020,4,16],
			                 [1441,9,4,2020,4,27],
			                 [1441,9,15,2020,5,7],
			                 [1441,9,26,2020,5,18],
			                 [1441,10,8,2020,5,29],
			                 [1441,10,19,2020,6,10],
			                 [1441,10,30,2020,6,21],
			                 [1441,11,11,2020,7,1],
			                 [1441,11,22,2020,7,12],
			                 [1442,0,4,2020,7,23],
			                 [1442,0,15,2020,8,3],
			                 [1442,0,26,2020,8,14],
			                 [1442,1,7,2020,8,25],
			                 [1442,1,18,2020,9,6],
			                 [1442,1,29,2020,9,17],
			                 [1442,2,11,2020,9,28],
			                 [1442,2,22,2020,10,8],
			                 [1442,3,3,2020,10,19],
			                 [1442,3,14,2020,10,30],
			                 [1442,4,18,2021,0,2],
			                 [1442,4,29,2021,0,13],
			                 [1442,5,10,2021,0,24],
			                 [1442,5,21,2021,1,4],
			                 [1442,6,3,2021,1,15],
			                 [1442,6,14,2021,1,26],
			                 [1442,6,25,2021,2,9],
			                 [1442,7,6,2021,2,20],
			                 [1442,7,17,2021,2,31],
			                 [1442,7,28,2021,3,11],
			                 [1442,8,10,2021,3,22],
			                 [1442,8,21,2021,4,3],
			                 [1442,9,2,2021,4,14],
			                 [1442,9,13,2021,4,25],
			                 [1442,9,24,2021,5,5],
			                 [1442,10,6,2021,5,16],
			                 [1442,10,17,2021,5,27],
			                 [1442,10,28,2021,6,8],
			                 [1442,11,9,2021,6,19],
			                 [1442,11,20,2021,6,30],
			                 [1443,0,1,2021,7,10],
			                 [1443,0,12,2021,7,21],
			                 [1443,0,23,2021,8,1],
			                 [1443,1,4,2021,8,12],
			                 [1443,1,15,2021,8,23],
			                 [1443,1,26,2021,9,4],
			                 [1443,2,8,2021,9,15],
			                 [1443,2,19,2021,9,26],
			                 [1443,2,30,2021,10,6],
			                 [1443,3,11,2021,10,17],
			                 [1443,3,22,2021,10,28],
			                 [1443,5,7,2022,0,11],
			                 [1443,5,18,2022,0,22],
			                 [1443,5,29,2022,1,2],
			                 [1443,6,11,2022,1,13],
			                 [1443,6,22,2022,1,24],
			                 [1443,7,3,2022,2,7],
			                 [1443,7,14,2022,2,18],
			                 [1443,7,25,2022,2,29],
			                 [1443,8,7,2022,3,9],
			                 [1443,8,18,2022,3,20],
			                 [1443,8,29,2022,4,1],
			                 [1443,9,10,2022,4,12],
			                 [1443,9,21,2022,4,23],
			                 [1443,10,3,2022,5,3],
			                 [1443,10,14,2022,5,14],
			                 [1443,10,25,2022,5,25],
			                 [1443,11,6,2022,6,6],
			                 [1443,11,17,2022,6,17],
			                 [1443,11,28,2022,6,28],
			                 [1444,0,10,2022,7,8],
			                 [1444,0,21,2022,7,19],
			                 [1444,1,2,2022,7,30],
			                 [1444,1,13,2022,8,10],
			                 [1444,1,24,2022,8,21],
			                 [1444,2,6,2022,9,2],
			                 [1444,2,17,2022,9,13],
			                 [1444,2,28,2022,9,24],
			                 [1444,3,9,2022,10,4],
			                 [1444,3,20,2022,10,15],
			                 [1444,4,2,2022,10,26],
			                 [1444,5,16,2023,0,9],
			                 [1444,5,27,2023,0,20],
			                 [1444,6,9,2023,0,31],
			                 [1444,6,20,2023,1,11],
			                 [1444,7,1,2023,1,22],
			                 [1444,7,12,2023,2,5],
			                 [1444,7,23,2023,2,16],
			                 [1444,8,5,2023,2,27],
			                 [1444,8,16,2023,3,7],
			                 [1444,8,27,2023,3,18],
			                 [1444,9,8,2023,3,29],
			                 [1444,9,19,2023,4,10],
			                 [1444,10,1,2023,4,21],
			                 [1444,10,12,2023,5,1],
			                 [1444,10,23,2023,5,12],
			                 [1444,11,4,2023,5,23],
			                 [1444,11,15,2023,6,4],
			                 [1444,11,26,2023,6,15],
			                 [1445,0,8,2023,6,26],
			                 [1445,0,19,2023,7,6],
			                 [1445,0,30,2023,7,17],
			                 [1445,1,11,2023,7,28],
			                 [1445,1,22,2023,8,8],
			                 [1445,2,4,2023,8,19],
			                 [1445,2,15,2023,8,30],
			                 [1445,2,26,2023,9,11],
			                 [1445,3,7,2023,9,22],
			                 [1445,3,18,2023,10,2],
			                 [1445,3,29,2023,10,13],
			                 [1445,4,11,2023,10,24],
			                 [1445,5,25,2024,0,7],
			                 [1445,6,7,2024,0,18],
			                 [1445,6,18,2024,0,29],
			                 [1445,6,29,2024,1,9],
			                 [1445,7,10,2024,1,20],
			                 [1445,7,21,2024,2,2],
			                 [1445,8,3,2024,2,13],
			                 [1445,8,14,2024,2,24],
			                 [1445,8,25,2024,3,4],
			                 [1445,9,6,2024,3,15],
			                 [1445,9,17,2024,3,26],
			                 [1445,9,28,2024,4,7],
			                 [1445,10,10,2024,4,18],
			                 [1445,10,21,2024,4,29],
			                 [1445,11,2,2024,5,9],
			                 [1445,11,13,2024,5,20],
			                 [1445,11,24,2024,6,1],
			                 [1446,0,5,2024,6,12],
			                 [1446,0,16,2024,6,23],
			                 [1446,0,27,2024,7,3],
			                 [1446,1,8,2024,7,14],
			                 [1446,1,19,2024,7,25],
			                 [1446,2,1,2024,8,5],
			                 [1446,2,12,2024,8,16],
			                 [1446,2,23,2024,8,27],
			                 [1446,3,4,2024,9,8],
			                 [1446,3,15,2024,9,19],
			                 [1446,3,26,2024,9,30],
			                 [1446,4,8,2024,10,10],
			                 [1446,4,19,2024,10,21],
			                 [1446,6,4,2025,0,4],
			                 [1446,6,15,2025,0,15],
			                 [1446,6,26,2025,0,26],
			                 [1446,7,7,2025,1,6],
			                 [1446,7,18,2025,1,17],
			                 [1446,7,29,2025,1,28],
			                 [1446,8,11,2025,2,11],
			                 [1446,8,22,2025,2,22],
			                 [1446,9,3,2025,3,2],
			                 [1446,9,14,2025,3,13],
			                 [1446,9,25,2025,3,24],
			                 [1446,10,7,2025,4,5],
			                 [1446,10,18,2025,4,16],
			                 [1446,10,29,2025,4,27],
			                 [1446,11,10,2025,5,7],
			                 [1446,11,21,2025,5,18],
			                 [1447,0,3,2025,5,29],
			                 [1447,0,14,2025,6,10],
			                 [1447,0,25,2025,6,21],
			                 [1447,1,6,2025,7,1],
			                 [1447,1,17,2025,7,12],
			                 [1447,1,28,2025,7,23],
			                 [1447,2,10,2025,8,3],
			                 [1447,2,21,2025,8,14],
			                 [1447,3,2,2025,8,25],
			                 [1447,3,13,2025,9,6],
			                 [1447,3,24,2025,9,17],
			                 [1447,4,6,2025,9,28],
			                 [1447,4,17,2025,10,8],
			                 [1447,4,28,2025,10,19],
			                 [1447,5,9,2025,10,30],
			                 [1447,6,13,2026,0,2],
			                 [1447,6,24,2026,0,13],
			                 [1447,7,5,2026,0,24],
			                 [1447,7,16,2026,1,4],
			                 [1447,7,27,2026,1,15],
			                 [1447,8,9,2026,1,26],
			                 [1447,8,20,2026,2,9],
			                 [1447,9,1,2026,2,20],
			                 [1447,9,12,2026,2,31],
			                 [1447,9,23,2026,3,11],
			                 [1447,10,5,2026,3,22],
			                 [1447,10,16,2026,4,3],
			                 [1447,10,27,2026,4,14],
			                 [1447,11,8,2026,4,25],
			                 [1447,11,19,2026,5,5],
			                 [1447,11,30,2026,5,16],
			                 [1448,0,11,2026,5,27],
			                 [1448,0,22,2026,6,8],
			                 [1448,1,3,2026,6,19],
			                 [1448,1,14,2026,6,30],
			                 [1448,1,25,2026,7,10],
			                 [1448,2,7,2026,7,21],
			                 [1448,2,18,2026,8,1]
			
			];
			
			var idate,gdate;
			
			dojo.forEach(dateTable, function(d, i) {
				
					console.debug(d, "at index", i);
				
					idate = new dojox.date.islamic.Date(d[0],d[1],d[2], 15, 15, 10);
					gdate = idate.toGregorian();
					
					t.is(0, dojo.date.compare(new Date(d[3], d[4], d[5], 15, 15, 10), gdate, "date"));
				});

			}
		
		},
		{
			name: "fromGregorian",
			runTest: function(t) {
				
				var dateTable = [
				                 
				                 [1997,1,1,1417,8,23],
				                 [1997,1,12,1417,9,4],
				                 [1997,1,23,1417,9,15] ,
				                 [1997,2,6,1417,9,26],
				                 [1997,2,17,1417,10,8],
				                 [1997,2,28,1417,10,19],
				                 [1997,3,8,1417,10,30],
				                 [1997,3,19,1417,11,11],
				                 [1997,3,30,1417,11,22],
				                 [1997,4,11,1418,0,3],
				                 [1997,4,22,1418,0,14],
				                 [1997,5,2,1418,0,25],
				                 [1997,5,13,1418,1,6],
				                 [1997,5,24,1418,1,17],
				                 [1997,6,5,1418,1,28],
				                 [1997,6,16,1418,2,10],
				                 [1997,6,27,1418,2,21],
				                 [1997,7,7,1418,3,2],
				                 [1997,7,18,1418,3,13],
				                 [1997,7,29,1418,3,24],
				                 [1997,8,9,1418,4,6],
				                 [1997,8,20,1418,4,17],
				                 [1997,9,1,1418,4,28],
				                 [1997,9,12,1418,5,9],
				                 [1997,9,23,1418,5,20],
				                 [1997,10,3,1418,6,2],
				                 [1997,10,14,1418,6,13],
				                 [1997,10,25,1418,6,24],
				                 [1997,11,6,1418,7,5],
				                 [1997,11,17,1418,7,16],
				                 [1997,11,28,1418,7,27],
				                 [1998,0,8,1418,8,9],
				                 [1998,0,19,1418,8,20],
				                 [1998,0,30,1418,9,1],
				                 [1998,1,10,1418,9,12],
				                 [1998,1,21,1418,9,23],
				                 [1998,2,4,1418,10,5],
				                 [1998,2,15,1418,10,16],
				                 [1998,2,26,1418,10,27],
				                 [1998,3,6,1418,11,8],
				                 [1998,3,17,1418,11,19],
				                 [1998,3,28,1419,0,1],
				                 [1998,4,9,1419,0,12],
				                 [1998,4,20,1419,0,23],
				                 [1998,4,31,1419,1,4],
				                 [1998,5,11,1419,1,15],
				                 [1998,5,22,1419,1,26],
				                 [1998,6,3,1419,2,8],
				                 [1998,6,14,1419,2,19],
				                 [1998,6,25,1419,2,30],
				                 [1998,7,5,1419,3,11],
				                 [1998,7,16,1419,3,22],
				                 [1998,7,27,1419,4,4],
				                 [1998,8,7,1419,4,15],
				                 [1998,8,18,1419,4,26],
				                 [1998,8,29,1419,5,7],
				                 [1998,9,10,1419,5,18],
				                 [1998,9,21,1419,5,29],
				                 [1998,10,1,1419,6,11],
				                 [1998,10,12,1419,6,22],
				                 [1998,10,23,1419,7,3],
				                 [1998,11,4,1419,7,14],
				                 [1998,11,15,1419,7,25],
				                 [1998,11,26,1419,8,7],
				                 [1999,0,6,1419,8,18],
				                 [1999,0,17,1419,8,29],
				                 [1999,0,28,1419,9,10],
				                 [1999,1,8,1419,9,21],
				                 [1999,1,19,1419,10,3],
				                 [1999,2,2,1419,10,14],
				                 [1999,2,13,1419,10,25],
				                 [1999,2,24,1419,11,6],
				                 [1999,3,4,1419,11,17],
				                 [1999,3,15,1419,11,28],
				                 [1999,3,26,1420,0,10],
				                 [1999,4,7,1420,0,21],
				                 [1999,4,18,1420,1,2],
				                 [1999,4,29,1420,1,13],
				                 [1999,5,9,1420,1,24],
				                 [1999,5,20,1420,2,6],
				                 [1999,6,1,1420,2,17],
				                 [1999,6,12,1420,2,28],
				                 [1999,6,23,1420,3,9],
				                 [1999,7,3,1420,3,20],
				                 [1999,7,14,1420,4,2],
				                 [1999,7,25,1420,4,13],
				                 [1999,8,5,1420,4,24],
				                 [1999,8,16,1420,5,5],
				                 [1999,8,27,1420,5,16],
				                 [1999,9,8,1420,5,27],
				                 [1999,9,19,1420,6,9],
				                 [1999,9,30,1420,6,20],
				                 [1999,10,10,1420,7,1],
				                 [1999,10,21,1420,7,12],
				                 [1999,11,2,1420,7,23],
				                 [1999,11,13,1420,8,5],
				                 [1999,11,24,1420,8,16],
				                 [2000,0,4,1420,8,27],
				                 [2000,0,15,1420,9,8],
				                 [2000,0,26,1420,9,19],
				                 [2000,1,6,1420,10,1],
				                 [2000,1,17,1420,10,12],
				                 [2000,1,28,1420,10,23],
				                 [2000,2,10,1420,11,4],
				                 [2000,2,21,1420,11,15],
				                 [2000,3,1,1420,11,26],
				                 [2000,3,12,1421,0,7],
				                 [2000,3,23,1421,0,18],
				                 [2000,4,4,1421,0,29],
				                 [2000,4,15,1421,1,10],
				                 [2000,4,26,1421,1,21],
				                 [2000,5,6,1421,2,3],
				                 [2000,5,17,1421,2,14],
				                 [2000,5,28,1421,2,25],
				                 [2000,6,9,1421,3,6],
				                 [2000,6,20,1421,3,17],
				                 [2000,6,31,1421,3,28],
				                 [2000,7,11,1421,4,10],
				                 [2000,7,22,1421,4,21],
				                 [2000,8,2,1421,5,2],
				                 [2000,8,13,1421,5,13],
				                 [2000,8,24,1421,5,24],
				                 [2000,9,5,1421,6,6],
				                 [2000,9,16,1421,6,17],
				                 [2000,9,27,1421,6,28],
				                 [2000,10,7,1421,7,9],
				                 [2000,10,18,1421,7,20],
				                 [2000,10,29,1421,8,2],
				                 [2000,11,10,1421,8,13],
				                 [2000,11,21,1421,8,24],
				                 [2001,0,1,1421,9,5],
				                 [2001,0,12,1421,9,16],
				                 [2001,0,23,1421,9,27],
				                 [2001,1,3,1421,10,9],
				                 [2001,1,14,1421,10,20],
				                 [2001,1,25,1421,11,1],
				                 [2001,2,8,1421,11,12],
				                 [2001,2,19,1421,11,23],
				                 [2001,2,30,1422,0,5],
				                 [2001,3,10,1422,0,16],
				                 [2001,3,21,1422,0,27],
				                 [2001,4,2,1422,1,8],
				                 [2001,4,13,1422,1,19],
				                 [2001,4,24,1422,2,1],
				                 [2001,5,4,1422,2,12],
				                 [2001,5,15,1422,2,23],
				                 [2001,5,26,1422,3,4],
				                 [2001,6,7,1422,3,15],
				                 [2001,6,18,1422,3,26],
				                 [2001,6,29,1422,4,8],
				                 [2001,7,9,1422,4,19],
				                 [2001,7,20,1422,4,30],
				                 [2001,7,31,1422,5,11],
				                 [2001,8,11,1422,5,22],
				                 [2001,8,22,1422,6,4],
				                 [2001,9,3,1422,6,15],
				                 [2001,9,14,1422,6,26],
				                 [2001,9,25,1422,7,7],
				                 [2001,10,5,1422,7,18],
				                 [2001,10,16,1422,7,29],
				                 [2001,10,27,1422,8,11],
				                 [2001,11,8,1422,8,22],
				                 [2001,11,19,1422,9,3],
				                 [2001,11,30,1422,9,14],
				                 [2002,0,10,1422,9,25],
				                 [2002,0,21,1422,10,7],
				                 [2002,1,1,1422,10,18],
				                 [2002,1,12,1422,10,29],
				                 [2002,1,23,1422,11,10],
				                 [2002,2,6,1422,11,21],
				                 [2002,2,17,1423,0,3],
				                 [2002,2,28,1423,0,14],
				                 [2002,3,8,1423,0,25],
				                 [2002,3,19,1423,1,6],
				                 [2002,3,30,1423,1,17],
				                 [2002,4,11,1423,1,28],
				                 [2002,4,22,1423,2,10],
				                 [2002,5,2,1423,2,21],
				                 [2002,5,13,1423,3,2],
				                 [2002,5,24,1423,3,13],
				                 [2002,6,5,1423,3,24],
				                 [2002,6,16,1423,4,6],
				                 [2002,6,27,1423,4,17],
				                 [2002,7,7,1423,4,28],
				                 [2002,7,18,1423,5,9],
				                 [2002,7,29,1423,5,20],
				                 [2002,8,9,1423,6,2],
				                 [2002,8,20,1423,6,13],
				                 [2002,9,1,1423,6,24],
				                 [2002,9,12,1423,7,5],
				                 [2002,9,23,1423,7,16],
				                 [2002,10,3,1423,7,27],
				                 [2002,10,14,1423,8,9],
				                 [2002,10,25,1423,8,20],
				                 [2002,11,6,1423,9,1],
				                 [2002,11,17,1423,9,12],
				                 [2002,11,28,1423,9,23],
				                 [2003,0,8,1423,10,5],
				                 [2003,0,19,1423,10,16],
				                 [2003,0,30,1423,10,27],
				                 [2003,1,10,1423,11,8],
				                 [2003,1,21,1423,11,19],
				                 [2003,2,4,1423,11,30],
				                 [2003,2,15,1424,0,11],
				                 [2003,2,26,1424,0,22],
				                 [2003,3,6,1424,1,3],
				                 [2003,3,17,1424,1,14],
				                 [2003,3,28,1424,1,25],
				                 [2003,4,9,1424,2,7],
				                 [2003,4,20,1424,2,18],
				                 [2003,4,31,1424,2,29],
				                 [2003,5,11,1424,3,10],
				                 [2003,5,22,1424,3,21],
				                 [2003,6,3,1424,4,3],
				                 [2003,6,14,1424,4,14],
				                 [2003,6,25,1424,4,25],
				                 [2003,7,5,1424,5,6],
				                 [2003,7,16,1424,5,17],
				                 [2003,7,27,1424,5,28],
				                 [2003,8,7,1424,6,10],
				                 [2003,8,18,1424,6,21],
				                 [2003,8,29,1424,7,2],
				                 [2003,9,10,1424,7,13],
				                 [2003,9,21,1424,7,24],
				                 [2003,10,1,1424,8,6],
				                 [2003,10,12,1424,8,17],
				                 [2003,10,23,1424,8,28],
				                 [2003,11,4,1424,9,9],
				                 [2003,11,15,1424,9,20],
				                 [2003,11,26,1424,10,2],
				                 [2004,0,6,1424,10,13],
				                 [2004,0,17,1424,10,24],
				                 [2004,0,28,1424,11,5],
				                 [2004,1,8,1424,11,16],
				                 [2004,1,19,1424,11,27],
				                 [2004,2,1,1425,0,9],
				                 [2004,2,12,1425,0,20],
				                 [2004,2,23,1425,1,1],
				                 [2004,3,3,1425,1,12],
				                 [2004,3,14,1425,1,23],
				                 [2004,3,25,1425,2,5],
				                 [2004,4,6,1425,2,16],
				                 [2004,4,17,1425,2,27],
				                 [2004,4,28,1425,3,8],
				                 [2004,5,8,1425,3,19],
				                 [2004,5,19,1425,4,1],
				                 [2004,5,30,1425,4,12],
				                 [2004,6,11,1425,4,23],
				                 [2004,6,22,1425,5,4],
				                 [2004,7,2,1425,5,15],
				                 [2004,7,13,1425,5,26],
				                 [2004,7,24,1425,6,8],
				                 [2004,8,4,1425,6,19],
				                 [2004,8,15,1425,6,30],
				                 [2004,8,26,1425,7,11],
				                 [2004,9,7,1425,7,22],
				                 [2004,9,18,1425,8,4],
				                 [2004,9,29,1425,8,15],
				                 [2004,10,9,1425,8,26],
				                 [2004,10,20,1425,9,7],
				                 [2004,11,1,1425,9,18],
				                 [2004,11,12,1425,9,29],
				                 [2004,11,23,1425,10,11],
				                 [2005,0,3,1425,10,22],
				                 [2005,0,14,1425,11,3],
				                 [2005,0,25,1425,11,14],
				                 [2005,1,5,1425,11,25],
				                 [2005,1,16,1426,0,7],
				                 [2005,1,27,1426,0,18],
				                 [2005,2,10,1426,0,29],
				                 [2005,2,21,1426,1,10],
				                 [2005,3,1,1426,1,21],
				                 [2005,3,12,1426,2,3],
				                 [2005,3,23,1426,2,14],
				                 [2005,4,4,1426,2,25],
				                 [2005,4,15,1426,3,6],
				                 [2005,4,26,1426,3,17],
				                 [2005,5,6,1426,3,28],
				                 [2005,5,17,1426,4,10],
				                 [2005,5,28,1426,4,21],
				                 [2005,6,9,1426,5,2],
				                 [2005,6,20,1426,5,13],
				                 [2005,6,31,1426,5,24],
				                 [2005,7,11,1426,6,6],
				                 [2005,7,22,1426,6,17],
				                 [2005,8,2,1426,6,28],
				                 [2005,8,13,1426,7,9],
				                 [2005,8,24,1426,7,20],
				                 [2005,9,5,1426,8,2],
				                 [2005,9,16,1426,8,13],
				                 [2005,9,27,1426,8,24],
				                 [2005,10,7,1426,9,5],
				                 [2005,10,18,1426,9,16],
				                 [2005,10,29,1426,9,27],
				                 [2005,11,10,1426,10,9],
				                 [2005,11,21,1426,10,20],
				                 [2006,0,1,1426,11,1],
				                 [2006,0,12,1426,11,12],
				                 [2006,0,23,1426,11,23],
				                 [2006,1,3,1427,0,4],
				                 [2006,1,14,1427,0,15],
				                 [2006,1,25,1427,0,26],
				                 [2006,2,8,1427,1,7],
				                 [2006,2,19,1427,1,18],
				                 [2006,2,30,1427,1,29],
				                 [2006,3,10,1427,2,11],
				                 [2006,3,21,1427,2,22],
				                 [2006,4,2,1427,3,3],
				                 [2006,4,13,1427,3,14],
				                 [2006,4,24,1427,3,25],
				                 [2006,5,4,1427,4,7],
				                 [2006,5,15,1427,4,18],
				                 [2006,5,26,1427,4,29],
				                 [2006,6,7,1427,5,10],
				                 [2006,6,18,1427,5,21],
				                 [2006,6,29,1427,6,3],
				                 [2006,7,9,1427,6,14],
				                 [2006,7,20,1427,6,25],
				                 [2006,7,31,1427,7,6],
				                 [2006,8,11,1427,7,17],
				                 [2006,8,22,1427,7,28],
				                 [2006,9,3,1427,8,10],
				                 [2006,9,14,1427,8,21],
				                 [2006,9,25,1427,9,2],
				                 [2006,10,5,1427,9,13],
				                 [2006,10,16,1427,9,24],
				                 [2006,10,27,1427,10,6],
				                 [2006,11,8,1427,10,17],
				                 [2006,11,19,1427,10,28],
				                 [2006,11,30,1427,11,9],
				                 [2007,0,10,1427,11,20],
				                 [2007,0,21,1428,0,2],
				                 [2007,1,1,1428,0,13],
				                 [2007,1,12,1428,0,24],
				                 [2007,1,23,1428,1,5],
				                 [2007,2,6,1428,1,16],
				                 [2007,2,17,1428,1,27],
				                 [2007,2,28,1428,2,9],
				                 [2007,3,8,1428,2,20],
				                 [2007,3,19,1428,3,1],
				                 [2007,3,30,1428,3,12],
				                 [2007,4,11,1428,3,23],
				                 [2007,4,22,1428,4,5],
				                 [2007,5,2,1428,4,16],
				                 [2007,5,13,1428,4,27],
				                 [2007,5,24,1428,5,8],
				                 [2007,6,5,1428,5,19],
				                 [2007,6,16,1428,6,1],
				                 [2007,6,27,1428,6,12],
				                 [2007,7,7,1428,6,23],
				                 [2007,7,18,1428,7,4],
				                 [2007,7,29,1428,7,15],
				                 [2007,8,9,1428,7,26],
				                 [2007,8,20,1428,8,8],
				                 [2007,9,1,1428,8,19],
				                 [2007,9,12,1428,8,30],
				                 [2007,9,23,1428,9,11],
				                 [2007,10,3,1428,9,22],
				                 [2007,10,14,1428,10,4],
				                 [2007,10,25,1428,10,15],
				                 [2007,11,6,1428,10,26],
				                 [2007,11,17,1428,11,7],
				                 [2007,11,28,1428,11,18],
				                 [2008,0,8,1428,11,29],
				                 [2008,0,19,1429,0,10],
				                 [2008,0,30,1429,0,21],
				                 [2008,1,10,1429,1,2],
				                 [2008,1,21,1429,1,13],
				                 [2008,2,3,1429,1,24],
				                 [2008,2,14,1429,2,6],
				                 [2008,2,25,1429,2,17],
				                 [2008,3,5,1429,2,28],
				                 [2008,3,16,1429,3,9],
				                 [2008,3,27,1429,3,20],
				                 [2008,4,8,1429,4,2],
				                 [2008,4,19,1429,4,13],
				                 [2008,4,30,1429,4,24],
				                 [2008,5,10,1429,5,5],
				                 [2008,5,21,1429,5,16],
				                 [2008,6,2,1429,5,27],
				                 [2008,6,13,1429,6,9],
				                 [2008,6,24,1429,6,20],
				                 [2008,7,4,1429,7,1],
				                 [2008,7,15,1429,7,12],
				                 [2008,7,26,1429,7,23],
				                 [2008,8,6,1429,8,5],
				                 [2008,8,17,1429,8,16],
				                 [2008,8,28,1429,8,27],
				                 [2008,9,9,1429,9,8],
				                 [2008,9,20,1429,9,19],
				                 [2008,9,31,1429,10,1],
				                 [2008,10,11,1429,10,12],
				                 [2008,10,22,1429,10,23],
				                 [2008,11,3,1429,11,4],
				                 [2008,11,14,1429,11,15],
				                 [2008,11,25,1429,11,26],
				                 [2009,0,5,1430,0,8],
				                 [2009,0,16,1430,0,19],
				                 [2009,0,27,1430,0,30],
				                 [2009,1,7,1430,1,11],
				                 [2009,1,18,1430,1,22],
				                 [2009,2,1,1430,2,4],
				                 [2009,2,12,1430,2,15],
				                 [2009,2,23,1430,2,26],
				                 [2009,3,3,1430,3,7],
				                 [2009,3,14,1430,3,18],
				                 [2009,3,25,1430,3,29],
				                 [2009,4,6,1430,4,11],
				                 [2009,4,17,1430,4,22],
				                 [2009,4,28,1430,5,3],
				                 [2009,5,8,1430,5,14],
				                 [2009,5,19,1430,5,25],
				                 [2009,5,30,1430,6,7],
				                 [2009,6,11,1430,6,18],
				                 [2009,6,22,1430,6,29],
				                 [2009,7,2,1430,7,10],
				                 [2009,7,13,1430,7,21],
				                 [2009,7,24,1430,8,3],
				                 [2009,8,4,1430,8,14],
				                 [2009,8,15,1430,8,25],
				                 [2009,8,26,1430,9,6],
				                 [2009,9,7,1430,9,17],
				                 [2009,9,18,1430,9,28],
				                 [2009,9,29,1430,10,10],
				                 [2009,10,9,1430,10,21],
				                 [2009,10,20,1430,11,2],
				                 [2009,11,1,1430,11,13],
				                 [2009,11,12,1430,11,24],
				                 [2009,11,23,1431,0,6],
				                 [2010,0,3,1431,0,17],
				                 [2010,0,14,1431,0,28],
				                 [2010,0,25,1431,1,9],
				                 [2010,1,5,1431,1,20],
				                 [2010,1,16,1431,2,2],
				                 [2010,1,27,1431,2,13],
				                 [2010,2,10,1431,2,24],
				                 [2010,2,21,1431,3,5],
				                 [2010,3,1,1431,3,16],
				                 [2010,3,12,1431,3,27],
				                 [2010,3,23,1431,4,9],
				                 [2010,4,4,1431,4,20],
				                 [2010,4,15,1431,5,1],
				                 [2010,4,26,1431,5,12],
				                 [2010,5,6,1431,5,23],
				                 [2010,5,17,1431,6,5],
				                 [2010,5,28,1431,6,16],
				                 [2010,6,9,1431,6,27],
				                 [2010,6,20,1431,7,8],
				                 [2010,6,31,1431,7,19],
				                 [2010,7,11,1431,8,1],
				                 [2010,7,22,1431,8,12],
				                 [2010,8,2,1431,8,23],
				                 [2010,8,13,1431,9,4],
				                 [2010,8,24,1431,9,15],
				                 [2010,9,5,1431,9,26],
				                 [2010,9,16,1431,10,8],
				                 [2010,9,27,1431,10,19],
				                 [2010,10,7,1431,10,30],
				                 [2010,10,18,1431,11,11],
				                 [2010,10,29,1431,11,22],
				                 [2010,11,10,1432,0,3],
				                 [2010,11,21,1432,0,14],
				                 [2011,0,1,1432,0,25],
				                 [2011,0,12,1432,1,6],
				                 [2011,0,23,1432,1,17],
				                 [2011,1,3,1432,1,28],
				                 [2011,1,14,1432,2,10],
				                 [2011,1,25,1432,2,21],
				                 [2011,2,8,1432,3,2],
				                 [2011,2,19,1432,3,13],
				                 [2011,2,30,1432,3,24],
				                 [2011,3,10,1432,4,6],
				                 [2011,3,21,1432,4,17],
				                 [2011,4,2,1432,4,28],
				                 [2011,4,13,1432,5,9],
				                 [2011,4,24,1432,5,20],
				                 [2011,5,4,1432,6,2],
				                 [2011,5,15,1432,6,13],
				                 [2011,5,26,1432,6,24],
				                 [2011,6,7,1432,7,5],
				                 [2011,6,18,1432,7,16],
				                 [2011,6,29,1432,7,27],
				                 [2011,7,9,1432,8,9],
				                 [2011,7,20,1432,8,20],
				                 [2011,7,31,1432,9,1],
				                 [2011,8,11,1432,9,12],
				                 [2011,8,22,1432,9,23],
				                 [2011,9,3,1432,10,5],
				                 [2011,9,14,1432,10,16],
				                 [2011,9,25,1432,10,27],
				                 [2011,10,5,1432,11,8],
				                 [2011,10,16,1432,11,19],
				                 [2011,10,27,1433,0,1],
				                 [2011,11,8,1433,0,12],
				                 [2011,11,19,1433,0,23],
				                 [2011,11,30,1433,1,4],
				                 [2012,0,10,1433,1,15],
				                 [2012,0,21,1433,1,26],
				                 [2012,1,1,1433,2,8],
				                 [2012,1,12,1433,2,19],
				                 [2012,1,23,1433,2,30],
				                 [2012,2,5,1433,3,11],
				                 [2012,2,16,1433,3,22],
				                 [2012,2,27,1433,4,4],
				                 [2012,3,7,1433,4,15],
				                 [2012,3,18,1433,4,26],
				                 [2012,3,29,1433,5,7],
				                 [2012,4,10,1433,5,18],
				                 [2012,4,21,1433,5,29],
				                 [2012,5,1,1433,6,11],
				                 [2012,5,12,1433,6,22],
				                 [2012,5,23,1433,7,3],
				                 [2012,6,4,1433,7,14],
				                 [2012,6,15,1433,7,25],
				                 [2012,6,26,1433,8,7],
				                 [2012,7,6,1433,8,18],
				                 [2012,7,17,1433,8,29],
				                 [2012,7,28,1433,9,10],
				                 [2012,8,8,1433,9,21],
				                 [2012,8,19,1433,10,3],
				                 [2012,8,30,1433,10,14],
				                 [2012,9,11,1433,10,25],
				                 [2012,9,22,1433,11,6],
				                 [2012,10,2,1433,11,17],
				                 [2012,10,13,1433,11,28],
				                 [2012,10,24,1434,0,10],
				                 [2012,11,5,1434,0,21],
				                 [2012,11,16,1434,1,2],
				                 [2012,11,27,1434,1,13],
				                 [2013,0,7,1434,1,24],
				                 [2013,0,18,1434,2,6],
				                 [2013,0,29,1434,2,17],
				                 [2013,1,9,1434,2,28],
				                 [2013,1,20,1434,3,9],
				                 [2013,2,3,1434,3,20],
				                 [2013,2,14,1434,4,2],
				                 [2013,2,25,1434,4,13],
				                 [2013,3,5,1434,4,24],
				                 [2013,3,16,1434,5,5],
				                 [2013,3,27,1434,5,16],
				                 [2013,4,8,1434,5,27],
				                 [2013,4,19,1434,6,9],
				                 [2013,4,30,1434,6,20],
				                 [2013,5,10,1434,7,1],
				                 [2013,5,21,1434,7,12],
				                 [2013,6,2,1434,7,23],
				                 [2013,6,13,1434,8,5],
				                 [2013,6,24,1434,8,16],
				                 [2013,7,4,1434,8,27],
				                 [2013,7,15,1434,9,8],
				                 [2013,7,26,1434,9,19],
				                 [2013,8,6,1434,10,1],
				                 [2013,8,17,1434,10,12],
				                 [2013,8,28,1434,10,23],
				                 [2013,9,9,1434,11,4],
				                 [2013,9,20,1434,11,15],
				                 [2013,9,31,1434,11,26],
				                 [2013,10,11,1435,0,7],
				                 [2013,10,22,1435,0,18],
				                 [2013,11,3,1435,0,29],
				                 [2013,11,14,1435,1,10],
				                 [2013,11,25,1435,1,21],
				                 [2014,0,5,1435,2,3],
				                 [2014,0,16,1435,2,14],
				                 [2014,0,27,1435,2,25],
				                 [2014,1,7,1435,3,6],
				                 [2014,1,18,1435,3,17],
				                 [2014,2,1,1435,3,28],
				                 [2014,2,12,1435,4,10],
				                 [2014,2,23,1435,4,21],
				                 [2014,3,3,1435,5,2],
				                 [2014,3,14,1435,5,13],
				                 [2014,3,25,1435,5,24],
				                 [2014,4,6,1435,6,6],
				                 [2014,4,17,1435,6,17],
				                 [2014,4,28,1435,6,28],
				                 [2014,5,8,1435,7,9],
				                 [2014,5,19,1435,7,20],
				                 [2014,5,30,1435,8,2],
				                 [2014,6,11,1435,8,13],
				                 [2014,6,22,1435,8,24],
				                 [2014,7,2,1435,9,5],
				                 [2014,7,13,1435,9,16],
				                 [2014,7,24,1435,9,27],
				                 [2014,8,4,1435,10,9],
				                 [2014,8,15,1435,10,20],
				                 [2014,8,26,1435,11,1],
				                 [2014,9,7,1435,11,12],
				                 [2014,9,18,1435,11,23],
				                 [2014,9,29,1436,0,5],
				                 [2014,10,9,1436,0,16],
				                 [2014,10,20,1436,0,27],
				                 [2014,11,1,1436,1,8],
				                 [2014,11,12,1436,1,19],
				                 [2014,11,23,1436,2,1],
				                 [2015,0,3,1436,2,12],
				                 [2015,0,14,1436,2,23],
				                 [2015,0,25,1436,3,4],
				                 [2015,1,5,1436,3,15],
				                 [2015,1,16,1436,3,26],
				                 [2015,1,27,1436,4,8],
				                 [2015,2,10,1436,4,19],
				                 [2015,2,21,1436,4,30],
				                 [2015,3,1,1436,5,11],
				                 [2015,3,12,1436,5,22],
				                 [2015,3,23,1436,6,4],
				                 [2015,4,4,1436,6,15],
				                 [2015,4,15,1436,6,26],
				                 [2015,4,26,1436,7,7],
				                 [2015,5,6,1436,7,18],
				                 [2015,5,17,1436,7,29],
				                 [2015,5,28,1436,8,11],
				                 [2015,6,9,1436,8,22],
				                 [2015,6,20,1436,9,3],
				                 [2015,6,31,1436,9,14],
				                 [2015,7,11,1436,9,25],
				                 [2015,7,22,1436,10,7],
				                 [2015,8,2,1436,10,18],
				                 [2015,8,13,1436,10,29],
				                 [2015,8,24,1436,11,10],
				                 [2015,9,5,1436,11,21],
				                 [2015,9,16,1437,0,2],
				                 [2015,9,27,1437,0,13],
				                 [2015,10,7,1437,0,24],
				                 [2015,10,18,1437,1,5],
				                 [2015,10,29,1437,1,16],
				                 [2015,11,10,1437,1,27],
				                 [2015,11,21,1437,2,9],
				                 [2016,0,1,1437,2,20],
				                 [2016,0,12,1437,3,1],
				                 [2016,0,23,1437,3,12],
				                 [2016,1,3,1437,3,23],
				                 [2016,1,14,1437,4,5],
				                 [2016,1,25,1437,4,16],
				                 [2016,2,7,1437,4,27],
				                 [2016,2,18,1437,5,8],
				                 [2016,2,29,1437,5,19],
				                 [2016,3,9,1437,6,1],
				                 [2016,3,20,1437,6,12],
				                 [2016,4,1,1437,6,23],
				                 [2016,4,12,1437,7,4],
				                 [2016,4,23,1437,7,15],
				                 [2016,5,3,1437,7,26],
				                 [2016,5,14,1437,8,8],
				                 [2016,5,25,1437,8,19],
				                 [2016,6,6,1437,8,30],
				                 [2016,6,17,1437,9,11],
				                 [2016,6,28,1437,9,22],
				                 [2016,7,8,1437,10,4],
				                 [2016,7,19,1437,10,15],
				                 [2016,7,30,1437,10,26],
				                 [2016,8,10,1437,11,7],
				                 [2016,8,21,1437,11,18],
				                 [2016,9,2,1437,11,29],
				                 [2016,9,13,1438,0,11],
				                 [2016,9,24,1438,0,22],
				                 [2016,10,4,1438,1,3],
				                 [2016,10,15,1438,1,14],
				                 [2016,10,26,1438,1,25],
				                 [2016,11,7,1438,2,7],
				                 [2016,11,18,1438,2,18],
				                 [2016,11,29,1438,2,29],
				                 [2017,0,9,1438,3,10],
				                 [2017,0,20,1438,3,21],
				                 [2017,0,31,1438,4,3],
				                 [2017,1,11,1438,4,14],
				                 [2017,1,22,1438,4,25],
				                 [2017,2,5,1438,5,6],
				                 [2017,2,16,1438,5,17],
				                 [2017,2,27,1438,5,28],
				                 [2017,3,7,1438,6,10],
				                 [2017,3,18,1438,6,21],
				                 [2017,3,29,1438,7,2],
				                 [2017,4,10,1438,7,13],
				                 [2017,4,21,1438,7,24],
				                 [2017,5,1,1438,8,6],
				                 [2017,5,12,1438,8,17],
				                 [2017,5,23,1438,8,28],
				                 [2017,6,4,1438,9,9],
				                 [2017,6,15,1438,9,20],
				                 [2017,6,26,1438,10,2],
				                 [2017,7,6,1438,10,13],
				                 [2017,7,17,1438,10,24],
				                 [2017,7,28,1438,11,5],
				                 [2017,8,8,1438,11,16],
				                 [2017,8,19,1438,11,27],
				                 [2017,8,30,1439,0,9],
				                 [2017,9,11,1439,0,20],
				                 [2017,9,22,1439,1,1],
				                 [2017,10,2,1439,1,12],
				                 [2017,10,13,1439,1,23],
				                 [2017,10,24,1439,2,5],
				                 [2017,11,5,1439,2,16],
				                 [2017,11,16,1439,2,27],
				                 [2017,11,27,1439,3,8],
				                 [2018,0,7,1439,3,19],
				                 [2018,0,18,1439,4,1],
				                 [2018,0,29,1439,4,12],
				                 [2018,1,9,1439,4,23],
				                 [2018,1,20,1439,5,4],
				                 [2018,2,3,1439,5,15],
				                 [2018,2,14,1439,5,26],
				                 [2018,2,25,1439,6,8],
				                 [2018,3,5,1439,6,19],
				                 [2018,3,16,1439,6,30],
				                 [2018,3,27,1439,7,11],
				                 [2018,4,8,1439,7,22],
				                 [2018,4,19,1439,8,4],
				                 [2018,4,30,1439,8,15],
				                 [2018,5,10,1439,8,26],
				                 [2018,5,21,1439,9,7],
				                 [2018,6,2,1439,9,18],
				                 [2018,6,13,1439,9,29],
				                 [2018,6,24,1439,10,11],
				                 [2018,7,4,1439,10,22],
				                 [2018,7,15,1439,11,3],
				                 [2018,7,26,1439,11,14],
				                 [2018,8,6,1439,11,25],
				                 [2018,8,17,1440,0,6],
				                 [2018,8,28,1440,0,17],
				                 [2018,9,9,1440,0,28],
				                 [2018,9,20,1440,1,9],
				                 [2018,9,31,1440,1,20],
				                 [2018,10,11,1440,2,2],
				                 [2018,10,22,1440,2,13],
				                 [2018,11,3,1440,2,24],
				                 [2018,11,14,1440,3,5],
				                 [2018,11,25,1440,3,16],
				                 [2019,0,5,1440,3,27],
				                 [2019,0,16,1440,4,9],
				                 [2019,0,27,1440,4,20],
				                 [2019,1,7,1440,5,1],
				                 [2019,1,18,1440,5,12],
				                 [2019,2,1,1440,5,23],
				                 [2019,2,12,1440,6,5],
				                 [2019,2,23,1440,6,16],
				                 [2019,3,3,1440,6,27],
				                 [2019,3,14,1440,7,8],
				                 [2019,3,25,1440,7,19],
				                 [2019,4,6,1440,8,1],
				                 [2019,4,17,1440,8,12],
				                 [2019,4,28,1440,8,23],
				                 [2019,5,8,1440,9,4],
				                 [2019,5,19,1440,9,15],
				                 [2019,5,30,1440,9,26],
				                 [2019,6,11,1440,10,8],
				                 [2019,6,22,1440,10,19],
				                 [2019,7,2,1440,10,30],
				                 [2019,7,13,1440,11,11],
				                 [2019,7,24,1440,11,22],
				                 [2019,8,4,1441,0,4],
				                 [2019,8,15,1441,0,15],
				                 [2019,8,26,1441,0,26],
				                 [2019,9,7,1441,1,7],
				                 [2019,9,18,1441,1,18],
				                 [2019,9,29,1441,1,29],
				                 [2019,10,9,1441,2,11],
				                 [2019,10,20,1441,2,22],
				                 [2019,11,1,1441,3,3],
				                 [2019,11,12,1441,3,14],
				                 [2019,11,23,1441,3,25],
				                 [2020,0,3,1441,4,7],
				                 [2020,0,14,1441,4,18],
				                 [2020,0,25,1441,4,29],
				                 [2020,1,5,1441,5,10],
				                 [2020,1,16,1441,5,21],
				                 [2020,1,27,1441,6,3],
				                 [2020,2,9,1441,6,14],
				                 [2020,2,20,1441,6,25],
				                 [2020,2,31,1441,7,6],
				                 [2020,3,11,1441,7,17],
				                 [2020,3,22,1441,7,28],
				                 [2020,4,3,1441,8,10],
				                 [2020,4,14,1441,8,21],
				                 [2020,4,25,1441,9,2],
				                 [2020,5,5,1441,9,13],
				                 [2020,5,16,1441,9,24],
				                 [2020,5,27,1441,10,6],
				                 [2020,6,8,1441,10,17],
				                 [2020,6,19,1441,10,28],
				                 [2020,6,30,1441,11,9],
				                 [2020,7,10,1441,11,20],
				                 [2020,7,21,1442,0,2],
				                 [2020,8,1,1442,0,13],
				                 [2020,8,12,1442,0,24],
				                 [2020,8,23,1442,1,5],
				                 [2020,9,4,1442,1,16],
				                 [2020,9,15,1442,1,27],
				                 [2020,9,26,1442,2,9],
				                 [2020,10,6,1442,2,20],
				                 [2020,10,17,1442,3,1],
				                 [2020,10,28,1442,3,12],
				                 [2020,11,9,1442,3,23],
				                 [2020,11,20,1442,4,5],
				                 [2020,11,31,1442,4,16], 
				                 [2021,0,11,1442,4,27],
				                 [2021,0,22,1442,5,8],
				                 [2021,1,2,1442,5,19],
				                 [2021,1,13,1442,6,1],
				                 [2021,1,24,1442,6,12],
				                 [2021,2,7,1442,6,23],
				                 [2021,2,18,1442,7,4],
				                 [2021,2,29,1442,7,15],
				                 [2021,3,9,1442,7,26],
				                 [2021,3,20,1442,8,8],
				                 [2021,4,1,1442,8,19],
				                 [2021,4,12,1442,8,30],
				                 [2021,4,23,1442,9,11],
				                 [2021,5,3,1442,9,22],
				                 [2021,5,14,1442,10,4],
				                 [2021,5,25,1442,10,15],
				                 [2021,6,6,1442,10,26],
				                 [2021,6,17,1442,11,7],
				                 [2021,6,28,1442,11,18],
				                [2021,7,8,1442,11,29],
				                 [2021,7,19,1443,0,10],
				                 [2021,7,30,1443,0,21],
				                 [2021,8,10,1443,1,2],
				                 [2021,8,21,1443,1,13],
				                 [2021,9,2,1443,1,24],
				                 [2021,9,13,1443,2,6],
				                 [2021,9,24,1443,2,17],
				                 [2021,10,4,1443,2,28],
				                 [2021,10,15,1443,3,9],
				                 [2021,10,26,1443,3,20],
				                 [2021,11,7,1443,4,2],
				                 [2021,11,18,1443,4,13],
				                 [2021,11,29,1443,4,24],
				                 [2022,0,9,1443,5,5],
				                 [2022,0,20,1443,5,16],
				                 [2022,0,31,1443,5,27],
				                 [2022,1,11,1443,6,9],
				                 [2022,1,22,1443,6,20],
				                 [2022,2,5,1443,7,1],
				                 [2022,2,16,1443,7,12],
				                 [2022,2,27,1443,7,23],
				                 [2022,3,7,1443,8,5],
				                 [2022,3,18,1443,8,16],
				                 [2022,3,29,1443,8,27],
				                 [2022,4,10,1443,9,8],
				                 [2022,4,21,1443,9,19],
				                 [2022,5,1,1443,10,1],
				                 [2022,5,12,1443,10,12],
				                 [2022,5,23,1443,10,23],
				                 [2022,6,4,1443,11,4],
				                 [2022,6,15,1443,11,15],
				                 [2022,6,26,1443,11,26],
				                 [2022,7,6,1444,0,8],
				                 [2022,7,17,1444,0,19],
				                 [2022,7,28,1444,0,30],
				                 [2022,8,8,1444,1,11],
				                 [2022,8,19,1444,1,22],
				                 [2022,8,30,1444,2,4],
				                 [2022,9,11,1444,2,15],
				                 [2022,9,22,1444,2,26],
				                 [2022,10,2,1444,3,7],
				                 [2022,10,13,1444,3,18],
				                 [2022,10,24,1444,3,29],
				                 [2022,11,5,1444,4,11],
				                 [2022,11,16,1444,4,22],
				                 [2022,11,27,1444,5,3],
				                 [2023,0,7,1444,5,14],
				                 [2023,0,18,1444,5,25],
				                 [2023,0,29,1444,6,7],
				                 [2023,1,9,1444,6,18],
				                 [2023,1,20,1444,6,29],
				                 [2023,2,3,1444,7,10],
				                 [2023,2,14,1444,7,21],
				                 [2023,2,25,1444,8,3],
				                 [2023,3,5,1444,8,14],
				                 [2023,3,16,1444,8,25],
				                 [2023,3,27,1444,9,6],
				                 [2023,4,8,1444,9,17],
				                 [2023,4,19,1444,9,28],
				                 [2023,4,30,1444,10,10],
				                 [2023,5,10,1444,10,21],
				                 [2023,5,21,1444,11,2],
				                 [2023,6,2,1444,11,13],
				                 [2023,6,13,1444,11,24],
				                 [2023,6,24,1445,0,6],
				                 [2023,7,4,1445,0,17],
				                 [2023,7,15,1445,0,28],
				                 [2023,7,26,1445,1,9],
				                 [2023,8,6,1445,1,20],
				                 [2023,8,17,1445,2,2],
				                 [2023,8,28,1445,2,13],
				                 [2023,9,9,1445,2,24],
				                 [2023,9,20,1445,3,5],
				                 [2023,9,31,1445,3,16],
				                 [2023,10,11,1445,3,27],
				                 [2023,10,22,1445,4,9],
				                 [2023,11,3,1445,4,20],
				                 [2023,11,14,1445,5,1], 
				                 [2023,11,25,1445,5,12],
				                 [2024,0,5,1445,5,23],
				                 [2024,0,16,1445,6,5],
				                 [2024,0,27,1445,6,16],
				                 [2024,1,7,1445,6,27],
				                 [2024,1,18,1445,7,8],
				                 [2024,1,29,1445,7,19],
				                 [2024,2,11,1445,8,1],
				                 [2024,2,22,1445,8,12],
				                 [2024,3,2,1445,8,23],
				                 [2024,3,13,1445,9,4],
				                 [2024,3,24,1445,9,15],
				                 [2024,4,5,1445,9,26],
				                 [2024,4,16,1445,10,8],
				                 [2024,4,27,1445,10,19], 
				                 [2024,5,7,1445,10,30], 
								 [2024,5,18,1445,11,11],
				                 [2010,2,22,1431,3,6]
				                 ];
				
				var idate, gdate;
				
				dojo.forEach(dateTable, function(d, i) {
					
					//console.debug(d, "at index", i);
				
					gdate = new Date(d[0],d[1],d[2],15,15,10);
					
					idate = new dojox.date.islamic.Date();
					idate.fromGregorian(gdate);
					
					
					t.is(0, dojox.date.islamic.compare(new dojox.date.islamic.Date(d[3], d[4], d[5], 15, 15, 10), idate, "date"));
				});
			}
		},
		{
			name: "getDay",
			runTest: function(t) {
				var dateTable = [
					[1431, 0, 11, 1],
					[1431, 1, 3, 2],
					[1431, 2, 10, 3],
					[1431, 3, 23, 4],
					[1431, 6, 21, 6],
					[1431, 6, 22, 0],
					[1431, 7, 15, 2],
					[1202,1,1,1],
			        [1202,1,8,1],
			        [1202,1,15,1],
			        [1202,1,18,4],
			        [1202,1,19,5],
			        [1202,1,20,5]
								
				];
				dojo.forEach(dateTable, function(d, i) {
					var date = new dojox.date.islamic.Date(d[0], d[1], d[2]);
					t.is(d[3], date.getDay());
				});

			}
		},
		{
			name: "getDaysInIslamicMonth",
			runTest: function(t) {

				var dateTable = [
					[1430, 1, 29],
					[1420, 1, 29],
					[1422, 5, 29],
					[1431, 5, 29],
					[1430, 2, 30],
					[1431, 2, 30]
				];

				dojo.forEach(dateTable, function(d, i) {
					var date = new dojox.date.islamic.Date(d[0], d[1], 1);
					t.is(d[2], dojox.date.islamic.getDaysInMonth(date));
				});
			}
		},
		{
			name: "add_difference",
			runTest: function(t) {
				var start = [
						[1420, 1, 1422, 1],
						[1430, 2, 1435, 2],
						[1433, 0, 1434, 0],
						[1422, 2, 1420, 2],
						[1429, 3, 1427, 3],
						[1431, 4, 1431, 6],
						[1429, 7, 1429, 5],
						[1431, 3, 1431, 5],
						[1431, 3, 1431, 0],
						[1431, 1, 1431, 2],
						[1431, 9, 1431, 8],
						[1432, 7, 1432, 11],
						[1433, 8, 1434, 0],
						[1433, 0, 1432, 6],
						[1434, 0, 1433, 11],
						[1433, 0, 1432, 11],
						[1432, 0, 1431, 11],
						[1431, 0, 1430, 10]
					];
				var add = [24, 60, 12, -24, -24, 2, -2, 2, -3, 1, -1, 4, 4, -6, -1, -1, -1, -2];

				var dateHijriStart, dateHijriEnd, res, dateHijriRes;
				dojo.forEach(start, function(s, i) {
					dateHijriStart = new dojox.date.islamic.Date(s[0], s[1], 1);
					dateHijriRes = dojox.date.islamic.add(dateHijriStart, "month", add[i]);

					t.is(0, dateHijriRes.getMonth() - s[3]);
					t.is(0, dateHijriRes.getFullYear() - s[2]);
				});

				//month difference
				dojo.forEach(start, function(s, i) {
					dateHijriRes = new dojox.date.islamic.Date(s[2], s[3], 1);
					dateHijriStart = new dojox.date.islamic.Date(s[0], s[1], 1);
					t.is(add[i], dojox.date.islamic.difference(dateHijriStart, dateHijriRes, "month"));
				});
			}
		},
		{
			name: "consistency_of_add_and_difference",
			runTest: function(t) {
				var dateIslamic = new dojox.date.islamic.Date(1431, 4, 6);


				var amouts = [2, 5, 6, 7, 8, 12, 18, 20, 24, 50, -3, -4, -5, -6, -7, -8, -9, -10, -50, 200, -200, 29, -29, 1, -1,
				              23, 25];
				var dateIslamicAdd;

				dojo.forEach(amouts, function(amount, i) {
					dateIslamicAdd = dojox.date.islamic.add(dateIslamic, "month", amount);
					t.is(dojox.date.islamic.difference(dateIslamic, dateIslamicAdd, "month"), amount);

					dateIslamicAdd = dojox.date.islamic.add(dateIslamic, "year", amount);
					t.is(amount, dojox.date.islamic.difference(dateIslamic, dateIslamicAdd, "year"));

					dateIslamicAdd = dojox.date.islamic.add(dateIslamic, "week", amount);
					t.is(amount, dojox.date.islamic.difference(dateIslamic, dateIslamicAdd, "week"));

					dateIslamicAdd = dojox.date.islamic.add(dateIslamic, "weekday", amount);
					t.is(amount, dojox.date.islamic.difference(dateIslamic, dateIslamicAdd, "weekday"));

					dateIslamicAdd = dojox.date.islamic.add(dateIslamic, "day", amount)
					t.is(amount, dojox.date.islamic.difference(dateIslamic, dateIslamicAdd, "day")); 
			 
					dateIslamicAdd = dojox.date.islamic.add(dateIslamic, "hour", amount);
					t.is(amount, dojox.date.islamic.difference(dateIslamic, dateIslamicAdd, "hour")); 

					dateIslamicAdd = dojox.date.islamic.add(dateIslamic, "minute", amount);
					t.is(amount, dojox.date.islamic.difference(dateIslamic, dateIslamicAdd, "minute")); 

					dateIslamicAdd = dojox.date.islamic.add(dateIslamic, "second", amount);
					t.is(amount, dojox.date.islamic.difference(dateIslamic, dateIslamicAdd, "second")); 

					dateIslamicAdd = dojox.date.islamic.add(dateIslamic, "millisecond", amount);
					t.is(amount, dojox.date.islamic.difference(dateIslamic, dateIslamicAdd, "millisecond")); 
				});

				var dateIslamicDiff = new dojox.date.islamic.Date(1431, 4, 7);
				t.is(1, dojox.date.islamic.difference(dateIslamic, dateIslamicDiff));
			}
		},
		{
			name: "getMonth_setMonth",
			runTest: function(t) {
				var dateIslamic = new dojox.date.islamic.Date(1420, 1, 1);
				for (var year = 1420; year < 1430; year++) {
					dateIslamic.setFullYear(year);
					t.is(year, dateIslamic.getFullYear());
					dateIslamic.setMonth(11);
					t.is(11, dateIslamic.getMonth());
					dateIslamic.setMonth(6);
					t.is(6, dateIslamic.getMonth());

				}
			}
		},
		{
			name: "parse_and_format",
			runTest: function(t) {

				//test Islamic and English locale

				var dates = [
							[1430, 5, 1],
							[1428, 1, 28],
							[1431, 5, 16],
							[1431, 11, 2],
							[1433, 0, 2]
						];

				var dateIslamic, dateIslamic1;
				dojo.forEach(dates, function(date, i) {
					dateIslamic = new dojox.date.islamic.Date(date[0], date[1], date[2]);

					var options = [{ formatLength: 'full', locale: 'ar' }, { formatLength: 'long', locale: 'ar' }, { formatLength: 'medium', locale: 'ar' }, { formatLength: 'short', locale: 'ar' },
						{ formatLength: 'full', locale: 'en' }, { formatLength: 'long', locale: 'en' }, { formatLength: 'medium', locale: 'en' }, { formatLength: 'short', locale: 'en'}];
					dojo.forEach(options, function(opt, i) {
						str = dojox.date.islamic.locale.format(dateIslamic, opt);
						var option = "{" + opt + ", locale:'ar'}";
						dateIslamic1 = dojox.date.islamic.locale.parse(str, opt);
						t.is(0, dojo.date.compare(dateIslamic.toGregorian(), dateIslamic1.toGregorian(), 'date'));
					});

					var pattern = ['d M yy', 'dd/MM/yy h:m:s', 'dd#MM#yy HH$mm$ss', 'dd MMMM yyyy'];
					dojo.forEach(pattern, function(pat, i) {
						options = { datePattern: pat, selector: 'date', locale: 'ar' };
						str = dojox.date.islamic.locale.format(dateIslamic, options);
						dateIslamic1 = dojox.date.islamic.locale.parse(str, options);
						t.is(0, dojo.date.compare(dateIslamic.toGregorian(), dateIslamic1.toGregorian(), 'date'));
					});
				});

				dateIslamic = new dojox.date.islamic.Date(1431, 6, 3, 15, 3, 59);
				pattern = 'HH$mm$ss';
				options = { timePattern: pattern, selector: 'time' };
				str = dojox.date.islamic.locale.format(dateIslamic, options);
				dateIslamic1 = dojox.date.islamic.locale.parse(str, options);
				var gregDate = dojo.date.locale.parse(str, options);
				t.is(0, dojo.date.compare(gregDate, dateIslamic1.toGregorian(), 'time'));

				pattern = "h:m:s";
				options = { timePattern: pattern, selector: 'time' };
				str = dojox.date.islamic.locale.format(dateIslamic, options);
				t.is(str, "3:3:59");
			}
		},
		{
			name: "addMilliseconds",
			runTest: function(t){												
				var islamicDates = [
							[5771, 8, 21, 10, 30],
							[5771, 8, 21, 2, 2],
							[5771, 8, 21, 8, 10], // "absolute" index of month, non-leap year
							[5771, 8, 21, 12, 59],
							[5771, 8, 21, 3, 33]
						];
						
				var dates = [
							[1432, 8, 21, 10, 30],
							[1432, 8, 21, 2, 2],
							[1432, 8, 21, 8, 10], // "absolute" index of month, non-leap year
							[1432, 8, 21, 12, 59],
							[1432, 8, 21, 3, 33]
						];
						
				var traceAttributes = function(date){
					console.log("getHours():" + date.getHours()+" getMinutes():"+date.getMinutes()+" getSeconds():"+date.getSeconds()+" getMilliseconds():"+date.getMilliseconds());
				};
						
				var dateIslamic, date2;
				dojo.forEach(islamicDates, function(date, i){
					dateIslamic = new dojox.date.islamic.Date(date[0], date[1], date[2], date[3], date[4]);
					date2 = new Date(dates[i][0], dates[i][1], dates[i][2], dates[i][3], dates[i][4]);			
		
					var newIslamicDate = dojox.date.islamic.add(dateIslamic, "millisecond",  1200);
					var newDate = dojo.date.add(date2, "millisecond",  1200);
					t.is(newIslamicDate.getHours(), newDate.getHours(), "Hours are different");
					t.is(newIslamicDate.getMinutes(), newDate.getMinutes(), "Minutes are different");
					t.is(newIslamicDate.getSeconds(), newDate.getSeconds(), "Seconds are different");
					t.is(newIslamicDate.getMilliseconds(), newDate.getMilliseconds(), "Milliseconds are different");
					//traceAttributes(newIslamicDate);

					newIslamicDate = dojox.date.islamic.add(dateIslamic, "millisecond",  12022);
					newDate = dojo.date.add(date2, "millisecond",  12022);
					t.is(newIslamicDate.getHours(), newDate.getHours(), "Hours are different");
					t.is(newIslamicDate.getMinutes(), newDate.getMinutes(), "Minutes are different");
					t.is(newIslamicDate.getSeconds(), newDate.getSeconds(), "Seconds are different");
					t.is(newIslamicDate.getMilliseconds(), newDate.getMilliseconds(), "Milliseconds are different");
					//traceAttributes(newIslamicDate);

					newIslamicDate = dojox.date.islamic.add(dateIslamic, "millisecond",  120422);
					newDate = dojo.date.add(date2, "millisecond",  120422);
					t.is(newIslamicDate.getHours(), newDate.getHours(), "Hours are different");
					t.is(newIslamicDate.getMinutes(), newDate.getMinutes(), "Minutes are different");
					t.is(newIslamicDate.getSeconds(), newDate.getSeconds(), "Seconds are different");
					t.is(newIslamicDate.getMilliseconds(), newDate.getMilliseconds(), "Milliseconds are different");
					//traceAttributes(newIslamicDate);

					newIslamicDate = dojox.date.islamic.add(dateIslamic, "millisecond",  1204422);
					newDate = dojo.date.add(date2, "millisecond",  1204422);
					t.is(newIslamicDate.getHours(), newDate.getHours(), "Hours are different");
					t.is(newIslamicDate.getMinutes(), newDate.getMinutes(), "Minutes are different");
					t.is(newIslamicDate.getSeconds(), newDate.getSeconds(), "Seconds are different");
					t.is(newIslamicDate.getMilliseconds(), newDate.getMilliseconds(), "Milliseconds are different");
					//traceAttributes(newIslamicDate);
				});
			}
		}
	]
);
