/*
	Copyright (c) 2004-2011, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is an optimized version of Dojo, built for deployment and not for
	development. To get sources and documentation, please visit:

		http://dojotoolkit.org
*/

//>>built
require({cache:{"dojox/charting/plot2d/_PlotEvents":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/_base/connect"],function(_1,_2,_3,_4){return _3("dojox.charting.plot2d._PlotEvents",null,{constructor:function(){this._shapeEvents=[];this._eventSeries={};},destroy:function(){this.resetEvents();this.inherited(arguments);},plotEvent:function(o){},raiseEvent:function(o){this.plotEvent(o);var t=_1.delegate(o);t.originalEvent=o.type;t.originalPlot=o.plot;t.type="onindirect";_2.forEach(this.chart.stack,function(_5){if(_5!==this&&_5.plotEvent){t.plot=_5;_5.plotEvent(t);}},this);},connect:function(_6,_7){this.dirty=true;return _4.connect(this,"plotEvent",_6,_7);},events:function(){return !!this.plotEvent.after;},resetEvents:function(){if(this._shapeEvents.length){_2.forEach(this._shapeEvents,function(_8){_8.shape.disconnect(_8.handle);});this._shapeEvents=[];}this.raiseEvent({type:"onplotreset",plot:this});},_connectSingleEvent:function(o,_9){this._shapeEvents.push({shape:o.eventMask,handle:o.eventMask.connect(_9,this,function(e){o.type=_9;o.event=e;this.raiseEvent(o);o.event=null;})});},_connectEvents:function(o){if(o){o.chart=this.chart;o.plot=this;o.hAxis=this.hAxis||null;o.vAxis=this.vAxis||null;o.eventMask=o.eventMask||o.shape;this._connectSingleEvent(o,"onmouseover");this._connectSingleEvent(o,"onmouseout");this._connectSingleEvent(o,"onclick");}},_reconnectEvents:function(_a){var a=this._eventSeries[_a];if(a){_2.forEach(a,this._connectEvents,this);}},fireEvent:function(_b,_c,_d,_e){var s=this._eventSeries[_b];if(s&&s.length&&_d<s.length){var o=s[_d];o.type=_c;o.event=_e||null;this.raiseEvent(o);o.event=null;}}});});},"dojo/uacss":function(){define(["./dom-geometry","./_base/lang","./domReady","./sniff","./_base/window"],function(_f,_10,_11,has,_12){var _13=_12.doc.documentElement,ie=has("ie"),_14=has("opera"),maj=Math.floor,ff=has("ff"),_15=_f.boxModel.replace(/-/,""),_16={"dj_quirks":has("quirks"),"dj_opera":_14,"dj_khtml":has("khtml"),"dj_webkit":has("webkit"),"dj_safari":has("safari"),"dj_chrome":has("chrome"),"dj_gecko":has("mozilla"),"dj_ios":has("ios"),"dj_android":has("android")};if(ie){_16["dj_ie"]=true;_16["dj_ie"+maj(ie)]=true;_16["dj_iequirks"]=has("quirks");}if(ff){_16["dj_ff"+maj(ff)]=true;}_16["dj_"+_15]=true;var _17="";for(var clz in _16){if(_16[clz]){_17+=clz+" ";}}_13.className=_10.trim(_13.className+" "+_17);_11(function(){if(!_f.isBodyLtr()){var _18="dj_rtl dijitRtl "+_17.replace(/ /g,"-rtl ");_13.className=_10.trim(_13.className+" "+_18+"dj_rtl dijitRtl "+_17.replace(/ /g,"-rtl "));}});return has;});},"dojox/charting/axis2d/Invisible":function(){define(["dojo/_base/lang","dojo/_base/declare","./Base","../scaler/linear","dojox/lang/utils"],function(_19,_1a,_1b,lin,du){return _1a("dojox.charting.axis2d.Invisible",_1b,{defaultParams:{vertical:false,fixUpper:"none",fixLower:"none",natural:false,leftBottom:true,includeZero:false,fixed:true},optionalParams:{min:0,max:1,from:0,to:1,majorTickStep:4,minorTickStep:2,microTickStep:1},constructor:function(_1c,_1d){this.opt=_19.clone(this.defaultParams);du.updateWithObject(this.opt,_1d);du.updateWithPattern(this.opt,_1d,this.optionalParams);},dependOnData:function(){return !("min" in this.opt)||!("max" in this.opt);},clear:function(){delete this.scaler;delete this.ticks;this.dirty=true;return this;},initialized:function(){return "scaler" in this&&!(this.dirty&&this.dependOnData());},setWindow:function(_1e,_1f){this.scale=_1e;this.offset=_1f;return this.clear();},getWindowScale:function(){return "scale" in this?this.scale:1;},getWindowOffset:function(){return "offset" in this?this.offset:0;},calculate:function(min,max,_20){if(this.initialized()){return this;}var o=this.opt;this.labels=o.labels;this.scaler=lin.buildScaler(min,max,_20,o);var tsb=this.scaler.bounds;if("scale" in this){o.from=tsb.lower+this.offset;o.to=(tsb.upper-tsb.lower)/this.scale+o.from;if(!isFinite(o.from)||isNaN(o.from)||!isFinite(o.to)||isNaN(o.to)||o.to-o.from>=tsb.upper-tsb.lower){delete o.from;delete o.to;delete this.scale;delete this.offset;}else{if(o.from<tsb.lower){o.to+=tsb.lower-o.from;o.from=tsb.lower;}else{if(o.to>tsb.upper){o.from+=tsb.upper-o.to;o.to=tsb.upper;}}this.offset=o.from-tsb.lower;}this.scaler=lin.buildScaler(min,max,_20,o);tsb=this.scaler.bounds;if(this.scale==1&&this.offset==0){delete this.scale;delete this.offset;}}return this;},getScaler:function(){return this.scaler;},getTicks:function(){return this.ticks;}});});},"dojox/lang/utils":function(){define(["..","dojo/_base/lang"],function(_21,_22){var du=_22.getObject("lang.utils",true,_21);var _23={},_24=Object.prototype.toString;var _25=function(o){if(o){switch(_24.call(o)){case "[object Array]":return o.slice(0);case "[object Object]":return _22.delegate(o);}}return o;};_22.mixin(du,{coerceType:function(_26,_27){switch(typeof _26){case "number":return Number(eval("("+_27+")"));case "string":return String(_27);case "boolean":return Boolean(eval("("+_27+")"));}return eval("("+_27+")");},updateWithObject:function(_28,_29,_2a){if(!_29){return _28;}for(var x in _28){if(x in _29&&!(x in _23)){var t=_28[x];if(t&&typeof t=="object"){du.updateWithObject(t,_29[x],_2a);}else{_28[x]=_2a?du.coerceType(t,_29[x]):_25(_29[x]);}}}return _28;},updateWithPattern:function(_2b,_2c,_2d,_2e){if(!_2c||!_2d){return _2b;}for(var x in _2d){if(x in _2c&&!(x in _23)){_2b[x]=_2e?du.coerceType(_2d[x],_2c[x]):_25(_2c[x]);}}return _2b;},merge:function(_2f,_30){if(_30){var _31=_24.call(_2f),_32=_24.call(_30),t,i,l,m;switch(_32){case "[object Array]":if(_32==_31){t=new Array(Math.max(_2f.length,_30.length));for(i=0,l=t.length;i<l;++i){t[i]=du.merge(_2f[i],_30[i]);}return t;}return _30.slice(0);case "[object Object]":if(_32==_31&&_2f){t=_22.delegate(_2f);for(i in _30){if(i in _2f){l=_2f[i];m=_30[i];if(m!==l){t[i]=du.merge(l,m);}}else{t[i]=_22.clone(_30[i]);}}return t;}return _22.clone(_30);}}return _30;}});return du;});},"dojox/charting/plot2d/Pie":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","./Base","./_PlotEvents","./common","dojox/gfx","dojox/gfx/matrix","dojox/lang/functional","dojox/lang/utils","dojo/has"],function(_33,arr,_34,_35,_36,dc,g,m,df,du,has){var _37=0.2;return _34("dojox.charting.plot2d.Pie",[_35,_36],{defaultParams:{labels:true,ticks:false,fixed:true,precision:1,labelOffset:20,labelStyle:"default",htmlLabels:true,radGrad:"native",fanSize:5,startAngle:0},optionalParams:{radius:0,omitLabels:false,stroke:{},outline:{},shadow:{},fill:{},filter:{},styleFunc:null,font:"",fontColor:"",labelWiring:{}},constructor:function(_38,_39){this.opt=_33.clone(this.defaultParams);du.updateWithObject(this.opt,_39);du.updateWithPattern(this.opt,_39,this.optionalParams);this.axes=[];this.run=null;this.dyn=[];this.runFilter=[];},clear:function(){this.inherited(arguments);this.dyn=[];this.run=null;return this;},setAxis:function(_3a){return this;},addSeries:function(run){this.run=run;return this;},getSeriesStats:function(){return _33.delegate(dc.defaultStats);},getRequiredColors:function(){return this.run?this.run.data.length:0;},render:function(dim,_3b){if(!this.dirty){return this;}this.resetEvents();this.dirty=false;this._eventSeries={};this.cleanGroup();var s=this.group,t=this.chart.theme;if(!this.run||!this.run.data.length){return this;}var rx=(dim.width-_3b.l-_3b.r)/2,ry=(dim.height-_3b.t-_3b.b)/2,r=Math.min(rx,ry),_3c="font" in this.opt?this.opt.font:t.series.font,_3d,_3e=m._degToRad(this.opt.startAngle),_3f=_3e,_40,_41,_42,_43,_44,_45=this.events();var run=arr.map(this.run.data,function(_46,i){if(typeof _46!="number"&&_46.hidden){this.runFilter.push(i);_46.hidden=false;}if(arr.some(this.runFilter,function(_47){return _47==i;})){if(typeof _46=="number"){return 0;}else{return {y:0,text:_46.text};}}else{return _46;}},this);this.dyn=[];if("radius" in this.opt){r=this.opt.radius;_44=r-this.opt.labelOffset;}var _48={cx:_3b.l+rx,cy:_3b.t+ry,r:r};if(this.opt.shadow||t.shadow){var _49=this.opt.shadow||t.shadow;var _4a=_33.clone(_48);_4a.cx+=_49.dx;_4a.cy+=_49.dy;s.createCircle(_4a).setFill(_49.color).setStroke(_49);}if(s.setFilter&&(this.opt.filter||t.filter)){s.createCircle(_48).setFill(t.series.stroke).setFilter(this.opt.filter||t.filter);}if(typeof run[0]=="number"){_40=df.map(run,"x ? Math.max(x, 0) : 0");if(df.every(_40,"<= 0")){s.createCircle(_48).setStroke(t.series.stroke);this.dyn=arr.map(_40,function(){return {};});return this;}else{_41=df.map(_40,"/this",df.foldl(_40,"+",0));if(this.opt.labels){_42=arr.map(_41,function(x){return x>0?this._getLabel(x*100)+"%":"";},this);}}}else{_40=df.map(run,"x ? Math.max(x.y, 0) : 0");if(df.every(_40,"<= 0")){s.createCircle(_48).setStroke(t.series.stroke);this.dyn=arr.map(_40,function(){return {};});return this;}else{_41=df.map(_40,"/this",df.foldl(_40,"+",0));if(this.opt.labels){_42=arr.map(_41,function(x,i){if(x<0){return "";}var v=run[i];return "text" in v?v.text:this._getLabel(x*100)+"%";},this);}}}var _4b=df.map(run,function(v,i){var _4c=[this.opt,this.run];if(v!==null&&typeof v!="number"){_4c.push(v);}if(this.opt.styleFunc){_4c.push(this.opt.styleFunc(v));}return t.next("slice",_4c,true);},this);if(this.opt.labels){_3d=_3c?g.normalizedLength(g.splitFontString(_3c).size):0;_43=df.foldl1(df.map(_42,function(_4d,i){var _4e=_4b[i].series.font;return g._base._getTextBox(_4d,{font:_4e}).w;},this),"Math.max(a, b)")/2;if(this.opt.labelOffset<0){r=Math.min(rx-2*_43,ry-_3d)+this.opt.labelOffset;}_44=r-this.opt.labelOffset;}var _4f=new Array(_41.length);arr.some(_41,function(_50,i){if(_50<0){return false;}var v=run[i],_51=_4b[i],_52,o;if(_50==0){this.dyn.push({fill:_51.series.fill,stroke:_51.series.stroke});return false;}if(_50>=1){_52=this._plotFill(_51.series.fill,dim,_3b);_52=this._shapeFill(_52,{x:_48.cx-_48.r,y:_48.cy-_48.r,width:2*_48.r,height:2*_48.r});_52=this._pseudoRadialFill(_52,{x:_48.cx,y:_48.cy},_48.r);var _53=s.createCircle(_48).setFill(_52).setStroke(_51.series.stroke);this.dyn.push({fill:_52,stroke:_51.series.stroke});if(_45){o={element:"slice",index:i,run:this.run,shape:_53,x:i,y:typeof v=="number"?v:v.y,cx:_48.cx,cy:_48.cy,cr:r};this._connectEvents(o);_4f[i]=o;}return false;}var end=_3f+_50*2*Math.PI;if(i+1==_41.length){end=_3e+2*Math.PI;}var _54=end-_3f,x1=_48.cx+r*Math.cos(_3f),y1=_48.cy+r*Math.sin(_3f),x2=_48.cx+r*Math.cos(end),y2=_48.cy+r*Math.sin(end);var _55=m._degToRad(this.opt.fanSize);if(_51.series.fill&&_51.series.fill.type==="radial"&&this.opt.radGrad==="fan"&&_54>_55){var _56=s.createGroup(),_57=Math.ceil(_54/_55),_58=_54/_57;_52=this._shapeFill(_51.series.fill,{x:_48.cx-_48.r,y:_48.cy-_48.r,width:2*_48.r,height:2*_48.r});for(var j=0;j<_57;++j){var _59=j==0?x1:_48.cx+r*Math.cos(_3f+(j-_37)*_58),_5a=j==0?y1:_48.cy+r*Math.sin(_3f+(j-_37)*_58),_5b=j==_57-1?x2:_48.cx+r*Math.cos(_3f+(j+1+_37)*_58),_5c=j==_57-1?y2:_48.cy+r*Math.sin(_3f+(j+1+_37)*_58);_56.createPath().moveTo(_48.cx,_48.cy).lineTo(_59,_5a).arcTo(r,r,0,_58>Math.PI,true,_5b,_5c).lineTo(_48.cx,_48.cy).closePath().setFill(this._pseudoRadialFill(_52,{x:_48.cx,y:_48.cy},r,_3f+(j+0.5)*_58,_3f+(j+0.5)*_58));}_56.createPath().moveTo(_48.cx,_48.cy).lineTo(x1,y1).arcTo(r,r,0,_54>Math.PI,true,x2,y2).lineTo(_48.cx,_48.cy).closePath().setStroke(_51.series.stroke);_53=_56;}else{_53=s.createPath().moveTo(_48.cx,_48.cy).lineTo(x1,y1).arcTo(r,r,0,_54>Math.PI,true,x2,y2).lineTo(_48.cx,_48.cy).closePath().setStroke(_51.series.stroke);_52=_51.series.fill;if(_52&&_52.type==="radial"){_52=this._shapeFill(_52,{x:_48.cx-_48.r,y:_48.cy-_48.r,width:2*_48.r,height:2*_48.r});if(this.opt.radGrad==="linear"){_52=this._pseudoRadialFill(_52,{x:_48.cx,y:_48.cy},r,_3f,end);}}else{if(_52&&_52.type==="linear"){_52=this._plotFill(_52,dim,_3b);_52=this._shapeFill(_52,_53.getBoundingBox());}}_53.setFill(_52);}this.dyn.push({fill:_52,stroke:_51.series.stroke});if(_45){o={element:"slice",index:i,run:this.run,shape:_53,x:i,y:typeof v=="number"?v:v.y,cx:_48.cx,cy:_48.cy,cr:r};this._connectEvents(o);_4f[i]=o;}_3f=end;return false;},this);if(this.opt.labels){var _5d=has("dojo-bidi")&&this.chart.isRightToLeft();if(this.opt.labelStyle=="default"){_3f=_3e;arr.some(_41,function(_5e,i){if(_5e<=0){return false;}var _5f=_4b[i];if(_5e>=1){this.renderLabel(s,_48.cx,_48.cy+_3d/2,_42[i],_5f,this.opt.labelOffset>0);return true;}var end=_3f+_5e*2*Math.PI;if(i+1==_41.length){end=_3e+2*Math.PI;}if(this.opt.omitLabels&&end-_3f<0.001){return false;}var _60=(_3f+end)/2,x=_48.cx+_44*Math.cos(_60),y=_48.cy+_44*Math.sin(_60)+_3d/2;this.renderLabel(s,_5d?dim.width-x:x,y,_42[i],_5f,this.opt.labelOffset>0);_3f=end;return false;},this);}else{if(this.opt.labelStyle=="columns"){_3f=_3e;var _61=this.opt.omitLabels;var _62=[];arr.forEach(_41,function(_63,i){var end=_3f+_63*2*Math.PI;if(i+1==_41.length){end=_3e+2*Math.PI;}var _64=(_3f+end)/2;_62.push({angle:_64,left:Math.cos(_64)<0,theme:_4b[i],index:i,omit:_61?end-_3f<0.001:false});_3f=end;});var _65=g._base._getTextBox("a",{font:_3c}).h;this._getProperLabelRadius(_62,_65,_48.r*1.1);arr.forEach(_62,function(_66,i){if(!_66.omit){var _67=_48.cx-_48.r*2,_68=_48.cx+_48.r*2,_69=g._base._getTextBox(_42[i],{font:_66.theme.series.font}).w,x=_48.cx+_66.labelR*Math.cos(_66.angle),y=_48.cy+_66.labelR*Math.sin(_66.angle),_6a=(_66.left)?(_67+_69):(_68-_69),_6b=(_66.left)?_67:_6a;var _6c=s.createPath().moveTo(_48.cx+_48.r*Math.cos(_66.angle),_48.cy+_48.r*Math.sin(_66.angle));if(Math.abs(_66.labelR*Math.cos(_66.angle))<_48.r*2-_69){_6c.lineTo(x,y);}_6c.lineTo(_6a,y).setStroke(_66.theme.series.labelWiring);this.renderLabel(s,_5d?dim.width-_69-_6b:_6b,y,_42[i],_66.theme,false,"left");}},this);}}}var esi=0;this._eventSeries[this.run.name]=df.map(run,function(v){return v<=0?null:_4f[esi++];});if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_3b);}return this;},_getProperLabelRadius:function(_6d,_6e,_6f){var _70,_71,_72=1,_73=1;if(_6d.length==1){_6d[0].labelR=_6f;return;}for(var i=0;i<_6d.length;i++){var _74=Math.abs(Math.sin(_6d[i].angle));if(_6d[i].left){if(_72>=_74){_72=_74;_70=_6d[i];}}else{if(_73>=_74){_73=_74;_71=_6d[i];}}}_70.labelR=_71.labelR=_6f;this._calculateLabelR(_70,_6d,_6e);this._calculateLabelR(_71,_6d,_6e);},_calculateLabelR:function(_75,_76,_77){var i=_75.index,_78=_76.length,_79=_75.labelR,_7a;while(!(_76[i%_78].left^_76[(i+1)%_78].left)){if(!_76[(i+1)%_78].omit){_7a=(Math.sin(_76[i%_78].angle)*_79+((_76[i%_78].left)?(-_77):_77))/Math.sin(_76[(i+1)%_78].angle);_79=(_7a<_75.labelR)?_75.labelR:_7a;_76[(i+1)%_78].labelR=_79;}i++;}i=_75.index;var j=(i==0)?_78-1:i-1;while(!(_76[i].left^_76[j].left)){if(!_76[j].omit){_7a=(Math.sin(_76[i].angle)*_79+((_76[i].left)?_77:(-_77)))/Math.sin(_76[j].angle);_79=(_7a<_75.labelR)?_75.labelR:_7a;_76[j].labelR=_79;}i--;j--;i=(i<0)?i+_76.length:i;j=(j<0)?j+_76.length:j;}}});});},"dijit/hccss":function(){define(["dojo/dom-class","dojo/hccss","dojo/domReady","dojo/_base/window"],function(_7b,has,_7c,win){_7c(function(){if(has("highcontrast")){_7b.add(win.body(),"dijit_a11y");}});return has;});},"dojox/charting/action2d/Shake":function(){define(["dojo/_base/connect","dojo/_base/declare","./PlotAction","dojo/fx","dojo/fx/easing","dojox/gfx/matrix","dojox/gfx/fx"],function(hub,_7d,_7e,df,dfe,m,gf){var _7f=3;return _7d("dojox.charting.action2d.Shake",_7e,{defaultParams:{duration:400,easing:dfe.backOut,shiftX:_7f,shiftY:_7f},optionalParams:{},constructor:function(_80,_81,_82){if(!_82){_82={};}this.shiftX=typeof _82.shiftX=="number"?_82.shiftX:_7f;this.shiftY=typeof _82.shiftY=="number"?_82.shiftY:_7f;this.connect();},process:function(o){if(!o.shape||!(o.type in this.overOutEvents)){return;}var _83=o.run.name,_84=o.index,_85=[],_86;if(_83 in this.anim){_86=this.anim[_83][_84];}else{this.anim[_83]={};}if(_86){_86.action.stop(true);}else{this.anim[_83][_84]=_86={};}var _87={shape:o.shape,duration:this.duration,easing:this.easing,transform:[{name:"translate",start:[this.shiftX,this.shiftY],end:[0,0]},m.identity]};if(o.shape){_85.push(gf.animateTransform(_87));}if(o.oultine){_87.shape=o.outline;_85.push(gf.animateTransform(_87));}if(o.shadow){_87.shape=o.shadow;_85.push(gf.animateTransform(_87));}if(!_85.length){delete this.anim[_83][_84];return;}_86.action=df.combine(_85);if(o.type=="onmouseout"){hub.connect(_86.action,"onEnd",this,function(){if(this.anim[_83]){delete this.anim[_83][_84];}});}_86.action.play();}});});},"dojox/lang/functional/lambda":function(){define(["../..","dojo/_base/lang","dojo/_base/array"],function(_88,_89,arr){var df=_89.getObject("lang.functional",true,_88);var _8a={};var _8b="ab".split(/a*/).length>1?String.prototype.split:function(sep){var r=this.split.call(this,sep),m=sep.exec(this);if(m&&m.index==0){r.unshift("");}return r;};var _8c=function(s){var _8d=[],_8e=_8b.call(s,/\s*->\s*/m);if(_8e.length>1){while(_8e.length){s=_8e.pop();_8d=_8e.pop().split(/\s*,\s*|\s+/m);if(_8e.length){_8e.push("(function("+_8d.join(", ")+"){ return ("+s+"); })");}}}else{if(s.match(/\b_\b/)){_8d=["_"];}else{var l=s.match(/^\s*(?:[+*\/%&|\^\.=<>]|!=)/m),r=s.match(/[+\-*\/%&|\^\.=<>!]\s*$/m);if(l||r){if(l){_8d.push("$1");s="$1"+s;}if(r){_8d.push("$2");s=s+"$2";}}else{var _8f=s.replace(/(?:\b[A-Z]|\.[a-zA-Z_$])[a-zA-Z_$\d]*|[a-zA-Z_$][a-zA-Z_$\d]*:|this|true|false|null|undefined|typeof|instanceof|in|delete|new|void|arguments|decodeURI|decodeURIComponent|encodeURI|encodeURIComponent|escape|eval|isFinite|isNaN|parseFloat|parseInt|unescape|dojo|dijit|dojox|window|document|'(?:[^'\\]|\\.)*'|"(?:[^"\\]|\\.)*"/g,"").match(/([a-z_$][a-z_$\d]*)/gi)||[],t={};arr.forEach(_8f,function(v){if(!t.hasOwnProperty(v)){_8d.push(v);t[v]=1;}});}}}return {args:_8d,body:s};};var _90=function(a){return a.length?function(){var i=a.length-1,x=df.lambda(a[i]).apply(this,arguments);for(--i;i>=0;--i){x=df.lambda(a[i]).call(this,x);}return x;}:function(x){return x;};};_89.mixin(df,{rawLambda:function(s){return _8c(s);},buildLambda:function(s){var l=_8c(s);return "function("+l.args.join(",")+"){return ("+l.body+");}";},lambda:function(s){if(typeof s=="function"){return s;}if(s instanceof Array){return _90(s);}if(_8a.hasOwnProperty(s)){return _8a[s];}var l=_8c(s);return _8a[s]=new Function(l.args,"return ("+l.body+");");},clearLambdaCache:function(){_8a={};}});return df;});},"dojox/charting/plot2d/Candlesticks":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/_base/array","dojo/has","./CartesianBase","./_PlotEvents","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx"],function(_91,_92,arr,has,_93,_94,dc,df,dfr,du,fx){var _95=dfr.lambda("item.purgeGroup()");return _92("dojox.charting.plot2d.Candlesticks",[_93,_94],{defaultParams:{gap:2,animate:null},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:""},constructor:function(_96,_97){this.opt=_91.clone(this.defaultParams);du.updateWithObject(this.opt,_97);du.updateWithPattern(this.opt,_97,this.optionalParams);this.animate=this.opt.animate;},collectStats:function(_98){var _99=_91.delegate(dc.defaultStats);for(var i=0;i<_98.length;i++){var run=_98[i];if(!run.data.length){continue;}var _9a=_99.vmin,_9b=_99.vmax;if(!("ymin" in run)||!("ymax" in run)){arr.forEach(run.data,function(val,idx){if(val!==null){var x=val.x||idx+1;_99.hmin=Math.min(_99.hmin,x);_99.hmax=Math.max(_99.hmax,x);_99.vmin=Math.min(_99.vmin,val.open,val.close,val.high,val.low);_99.vmax=Math.max(_99.vmax,val.open,val.close,val.high,val.low);}});}if("ymin" in run){_99.vmin=Math.min(_9a,run.ymin);}if("ymax" in run){_99.vmax=Math.max(_9b,run.ymax);}}return _99;},getSeriesStats:function(){var _9c=this.collectStats(this.series);_9c.hmin-=0.5;_9c.hmax+=0.5;return _9c;},render:function(dim,_9d){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_9d);}this.resetEvents();this.dirty=this.isDirty();var s;if(this.dirty){arr.forEach(this.series,_95);this._eventSeries={};this.cleanGroup();s=this.getGroup();df.forEachRev(this.series,function(_9e){_9e.cleanGroup(s);});}var t=this.chart.theme,f,gap,_9f,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_a0=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);gap=f.gap;_9f=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();var _a1=t.next("candlestick",[this.opt,run]),_a2=new Array(run.data.length);if(run.hidden){run.dyn.fill=_a1.series.fill;run.dyn.stroke=_a1.series.stroke;continue;}s=run.group;for(var j=0;j<run.data.length;++j){var v=run.data[j];if(v!==null){var _a3=t.addMixin(_a1,"candlestick",v,true);var x=ht(v.x||(j+0.5))+_9d.l+gap,y=dim.height-_9d.b,_a4=vt(v.open),_a5=vt(v.close),_a6=vt(v.high),low=vt(v.low);if("mid" in v){var mid=vt(v.mid);}if(low>_a6){var tmp=_a6;_a6=low;low=tmp;}if(_9f>=1){var _a7=_a4>_a5;var _a8={x1:_9f/2,x2:_9f/2,y1:y-_a6,y2:y-low},_a9={x:0,y:y-Math.max(_a4,_a5),width:_9f,height:Math.max(_a7?_a4-_a5:_a5-_a4,1)};var _aa=s.createGroup();_aa.setTransform({dx:x,dy:0});var _ab=_aa.createGroup();_ab.createLine(_a8).setStroke(_a3.series.stroke);_ab.createRect(_a9).setStroke(_a3.series.stroke).setFill(_a7?_a3.series.fill:"white");if("mid" in v){_ab.createLine({x1:(_a3.series.stroke.width||1),x2:_9f-(_a3.series.stroke.width||1),y1:y-mid,y2:y-mid}).setStroke(_a7?"white":_a3.series.stroke);}run.dyn.fill=_a3.series.fill;run.dyn.stroke=_a3.series.stroke;if(_a0){var o={element:"candlestick",index:j,run:run,shape:_ab,x:x,y:y-Math.max(_a4,_a5),cx:_9f/2,cy:(y-Math.max(_a4,_a5))+(Math.max(_a7?_a4-_a5:_a5-_a4,1)/2),width:_9f,height:Math.max(_a7?_a4-_a5:_a5-_a4,1),data:v};this._connectEvents(o);_a2[j]=o;}}if(this.animate){this._animateCandlesticks(_aa,y-low,_a6-low);}}}this._eventSeries[run.name]=_a2;run.dirty=false;}this.dirty=false;if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_9d);}return this;},tooltipFunc:function(o){return "<table cellpadding=\"1\" cellspacing=\"0\" border=\"0\" style=\"font-size:0.9em;\">"+"<tr><td>Open:</td><td align=\"right\"><strong>"+o.data.open+"</strong></td></tr>"+"<tr><td>High:</td><td align=\"right\"><strong>"+o.data.high+"</strong></td></tr>"+"<tr><td>Low:</td><td align=\"right\"><strong>"+o.data.low+"</strong></td></tr>"+"<tr><td>Close:</td><td align=\"right\"><strong>"+o.data.close+"</strong></td></tr>"+(o.data.mid!==undefined?"<tr><td>Mid:</td><td align=\"right\"><strong>"+o.data.mid+"</strong></td></tr>":"")+"</table>";},_animateCandlesticks:function(_ac,_ad,_ae){fx.animateTransform(_91.delegate({shape:_ac,duration:1200,transform:[{name:"translate",start:[0,_ad-(_ad/_ae)],end:[0,0]},{name:"scale",start:[1,1/_ae],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojox/lang/functional/reversed":function(){define(["dojo/_base/lang","dojo/_base/kernel","./lambda"],function(_af,_b0,df){_af.mixin(df,{filterRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_b0.global;f=df.lambda(f);var t=[],v,i=a.length-1;for(;i>=0;--i){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}return t;},forEachRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_b0.global;f=df.lambda(f);for(var i=a.length-1;i>=0;f.call(o,a[i],i,a),--i){}},mapRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_b0.global;f=df.lambda(f);var n=a.length,t=new Array(n),i=n-1,j=0;for(;i>=0;t[j++]=f.call(o,a[i],i,a),--i){}return t;},everyRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_b0.global;f=df.lambda(f);for(var i=a.length-1;i>=0;--i){if(!f.call(o,a[i],i,a)){return false;}}return true;},someRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_b0.global;f=df.lambda(f);for(var i=a.length-1;i>=0;--i){if(f.call(o,a[i],i,a)){return true;}}return false;}});return df;});},"dojox/charting/scaler/primitive":function(){define(["dojo/_base/lang"],function(_b1){var _b2=_b1.getObject("dojox.charting.scaler.primitive",true);return _b1.mixin(_b2,{buildScaler:function(min,max,_b3,_b4){if(min==max){min-=0.5;max+=0.5;}return {bounds:{lower:min,upper:max,from:min,to:max,scale:_b3/(max-min),span:_b3},scaler:_b2};},buildTicks:function(_b5,_b6){return {major:[],minor:[],micro:[]};},getTransformerFromModel:function(_b7){var _b8=_b7.bounds.from,_b9=_b7.bounds.scale;return function(x){return (x-_b8)*_b9;};},getTransformerFromPlot:function(_ba){var _bb=_ba.bounds.from,_bc=_ba.bounds.scale;return function(x){return x/_bc+_bb;};}});});},"dojox/charting/widget/Sparkline":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/query","./Chart","../themes/GreySkies","../plot2d/Lines","dojo/dom-prop"],function(_bd,_be,_bf,_c0,_c1,_c2,_c3){_be("dojox.charting.widget.Sparkline",_c0,{theme:_c1,margins:{l:0,r:0,t:0,b:0},type:"Lines",valueFn:"Number(x)",store:"",field:"",query:"",queryOptions:"",start:"0",count:"Infinity",sort:"",data:"",name:"default",buildRendering:function(){var n=this.srcNodeRef;if(!n.childNodes.length||!_bf("> .axis, > .plot, > .action, > .series",n).length){var _c4=document.createElement("div");_c3.set(_c4,{"class":"plot","name":"default","type":this.type});n.appendChild(_c4);var _c5=document.createElement("div");_c3.set(_c5,{"class":"series",plot:"default",name:this.name,start:this.start,count:this.count,valueFn:this.valueFn});_bd.forEach(["store","field","query","queryOptions","sort","data"],function(i){if(this[i].length){_c3.set(_c5,i,this[i]);}},this);n.appendChild(_c5);}this.inherited(arguments);}});});},"dojox/gfx/matrix":function(){define(["./_base","dojo/_base/lang"],function(g,_c6){var m=g.matrix={};var _c7={};m._degToRad=function(_c8){return _c7[_c8]||(_c7[_c8]=(Math.PI*_c8/180));};m._radToDeg=function(_c9){return _c9/Math.PI*180;};m.Matrix2D=function(arg){if(arg){if(typeof arg=="number"){this.xx=this.yy=arg;}else{if(arg instanceof Array){if(arg.length>0){var _ca=m.normalize(arg[0]);for(var i=1;i<arg.length;++i){var l=_ca,r=m.normalize(arg[i]);_ca=new m.Matrix2D();_ca.xx=l.xx*r.xx+l.xy*r.yx;_ca.xy=l.xx*r.xy+l.xy*r.yy;_ca.yx=l.yx*r.xx+l.yy*r.yx;_ca.yy=l.yx*r.xy+l.yy*r.yy;_ca.dx=l.xx*r.dx+l.xy*r.dy+l.dx;_ca.dy=l.yx*r.dx+l.yy*r.dy+l.dy;}_c6.mixin(this,_ca);}}else{_c6.mixin(this,arg);}}}};_c6.extend(m.Matrix2D,{xx:1,xy:0,yx:0,yy:1,dx:0,dy:0});_c6.mixin(m,{identity:new m.Matrix2D(),flipX:new m.Matrix2D({xx:-1}),flipY:new m.Matrix2D({yy:-1}),flipXY:new m.Matrix2D({xx:-1,yy:-1}),translate:function(a,b){if(arguments.length>1){return new m.Matrix2D({dx:a,dy:b});}return new m.Matrix2D({dx:a.x,dy:a.y});},scale:function(a,b){if(arguments.length>1){return new m.Matrix2D({xx:a,yy:b});}if(typeof a=="number"){return new m.Matrix2D({xx:a,yy:a});}return new m.Matrix2D({xx:a.x,yy:a.y});},rotate:function(_cb){var c=Math.cos(_cb);var s=Math.sin(_cb);return new m.Matrix2D({xx:c,xy:-s,yx:s,yy:c});},rotateg:function(_cc){return m.rotate(m._degToRad(_cc));},skewX:function(_cd){return new m.Matrix2D({xy:Math.tan(_cd)});},skewXg:function(_ce){return m.skewX(m._degToRad(_ce));},skewY:function(_cf){return new m.Matrix2D({yx:Math.tan(_cf)});},skewYg:function(_d0){return m.skewY(m._degToRad(_d0));},reflect:function(a,b){if(arguments.length==1){b=a.y;a=a.x;}var a2=a*a,b2=b*b,n2=a2+b2,xy=2*a*b/n2;return new m.Matrix2D({xx:2*a2/n2-1,xy:xy,yx:xy,yy:2*b2/n2-1});},project:function(a,b){if(arguments.length==1){b=a.y;a=a.x;}var a2=a*a,b2=b*b,n2=a2+b2,xy=a*b/n2;return new m.Matrix2D({xx:a2/n2,xy:xy,yx:xy,yy:b2/n2});},normalize:function(_d1){return (_d1 instanceof m.Matrix2D)?_d1:new m.Matrix2D(_d1);},isIdentity:function(_d2){return _d2.xx==1&&_d2.xy==0&&_d2.yx==0&&_d2.yy==1&&_d2.dx==0&&_d2.dy==0;},clone:function(_d3){var obj=new m.Matrix2D();for(var i in _d3){if(typeof (_d3[i])=="number"&&typeof (obj[i])=="number"&&obj[i]!=_d3[i]){obj[i]=_d3[i];}}return obj;},invert:function(_d4){var M=m.normalize(_d4),D=M.xx*M.yy-M.xy*M.yx;M=new m.Matrix2D({xx:M.yy/D,xy:-M.xy/D,yx:-M.yx/D,yy:M.xx/D,dx:(M.xy*M.dy-M.yy*M.dx)/D,dy:(M.yx*M.dx-M.xx*M.dy)/D});return M;},_multiplyPoint:function(_d5,x,y){return {x:_d5.xx*x+_d5.xy*y+_d5.dx,y:_d5.yx*x+_d5.yy*y+_d5.dy};},multiplyPoint:function(_d6,a,b){var M=m.normalize(_d6);if(typeof a=="number"&&typeof b=="number"){return m._multiplyPoint(M,a,b);}return m._multiplyPoint(M,a.x,a.y);},multiplyRectangle:function(_d7,_d8){var M=m.normalize(_d7);_d8=_d8||{x:0,y:0,width:0,height:0};if(m.isIdentity(M)){return {x:_d8.x,y:_d8.y,width:_d8.width,height:_d8.height};}var p0=m.multiplyPoint(M,_d8.x,_d8.y),p1=m.multiplyPoint(M,_d8.x,_d8.y+_d8.height),p2=m.multiplyPoint(M,_d8.x+_d8.width,_d8.y),p3=m.multiplyPoint(M,_d8.x+_d8.width,_d8.y+_d8.height),_d9=Math.min(p0.x,p1.x,p2.x,p3.x),_da=Math.min(p0.y,p1.y,p2.y,p3.y),_db=Math.max(p0.x,p1.x,p2.x,p3.x),_dc=Math.max(p0.y,p1.y,p2.y,p3.y);return {x:_d9,y:_da,width:_db-_d9,height:_dc-_da};},multiply:function(_dd){var M=m.normalize(_dd);for(var i=1;i<arguments.length;++i){var l=M,r=m.normalize(arguments[i]);M=new m.Matrix2D();M.xx=l.xx*r.xx+l.xy*r.yx;M.xy=l.xx*r.xy+l.xy*r.yy;M.yx=l.yx*r.xx+l.yy*r.yx;M.yy=l.yx*r.xy+l.yy*r.yy;M.dx=l.xx*r.dx+l.xy*r.dy+l.dx;M.dy=l.yx*r.dx+l.yy*r.dy+l.dy;}return M;},_sandwich:function(_de,x,y){return m.multiply(m.translate(x,y),_de,m.translate(-x,-y));},scaleAt:function(a,b,c,d){switch(arguments.length){case 4:return m._sandwich(m.scale(a,b),c,d);case 3:if(typeof c=="number"){return m._sandwich(m.scale(a),b,c);}return m._sandwich(m.scale(a,b),c.x,c.y);}return m._sandwich(m.scale(a),b.x,b.y);},rotateAt:function(_df,a,b){if(arguments.length>2){return m._sandwich(m.rotate(_df),a,b);}return m._sandwich(m.rotate(_df),a.x,a.y);},rotategAt:function(_e0,a,b){if(arguments.length>2){return m._sandwich(m.rotateg(_e0),a,b);}return m._sandwich(m.rotateg(_e0),a.x,a.y);},skewXAt:function(_e1,a,b){if(arguments.length>2){return m._sandwich(m.skewX(_e1),a,b);}return m._sandwich(m.skewX(_e1),a.x,a.y);},skewXgAt:function(_e2,a,b){if(arguments.length>2){return m._sandwich(m.skewXg(_e2),a,b);}return m._sandwich(m.skewXg(_e2),a.x,a.y);},skewYAt:function(_e3,a,b){if(arguments.length>2){return m._sandwich(m.skewY(_e3),a,b);}return m._sandwich(m.skewY(_e3),a.x,a.y);},skewYgAt:function(_e4,a,b){if(arguments.length>2){return m._sandwich(m.skewYg(_e4),a,b);}return m._sandwich(m.skewYg(_e4),a.x,a.y);}});g.Matrix2D=m.Matrix2D;return m;});},"dojox/charting/plot2d/Scatter":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/has","./CartesianBase","./_PlotEvents","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx","dojox/gfx/gradutils"],function(_e5,arr,_e6,has,_e7,_e8,dc,df,dfr,du,fx,_e9){var _ea=dfr.lambda("item.purgeGroup()");return _e6("dojox.charting.plot2d.Scatter",[_e7,_e8],{defaultParams:{shadows:null,animate:null},optionalParams:{markerStroke:{},markerOutline:{},markerShadow:{},markerFill:{},markerFont:"",markerFontColor:"",styleFunc:null},constructor:function(_eb,_ec){this.opt=_e5.clone(_e5.mixin(this.opt,this.defaultParams));du.updateWithObject(this.opt,_ec);du.updateWithPattern(this.opt,_ec,this.optionalParams);this.animate=this.opt.animate;},render:function(dim,_ed){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_ed);}this.resetEvents();this.dirty=this.isDirty();var s;if(this.dirty){arr.forEach(this.series,_ea);this._eventSeries={};this.cleanGroup();s=this.getGroup();df.forEachRev(this.series,function(_ee){_ee.cleanGroup(s);});}var t=this.chart.theme,_ef=this.events();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(!run.data.length){run.dirty=false;t.skip();continue;}var _f0=t.next("marker",[this.opt,run]),_f1,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler);if(run.hidden){run.dyn.marker=_f0.symbol;run.dyn.markerFill=_f0.marker.fill;run.dyn.markerStroke=_f0.marker.stroke;continue;}s=run.group;if(typeof run.data[0]=="number"){_f1=arr.map(run.data,function(v,i){return {x:ht(i+1)+_ed.l,y:dim.height-_ed.b-vt(v)};},this);}else{_f1=arr.map(run.data,function(v,i){return {x:ht(v.x)+_ed.l,y:dim.height-_ed.b-vt(v.y)};},this);}var _f2=new Array(_f1.length),_f3=new Array(_f1.length),_f4=new Array(_f1.length);arr.forEach(_f1,function(c,i){var _f5=run.data[i],_f6;if(this.opt.styleFunc||typeof _f5!="number"){var _f7=typeof _f5!="number"?[_f5]:[];if(this.opt.styleFunc){_f7.push(this.opt.styleFunc(_f5));}_f6=t.addMixin(_f0,"marker",_f7,true);}else{_f6=t.post(_f0,"marker");}var _f8="M"+c.x+" "+c.y+" "+_f6.symbol;if(_f6.marker.shadow){_f2[i]=s.createPath("M"+(c.x+_f6.marker.shadow.dx)+" "+(c.y+_f6.marker.shadow.dy)+" "+_f6.symbol).setStroke(_f6.marker.shadow).setFill(_f6.marker.shadow.color);if(this.animate){this._animateScatter(_f2[i],dim.height-_ed.b);}}if(_f6.marker.outline){var _f9=dc.makeStroke(_f6.marker.outline);_f9.width=2*_f9.width+_f6.marker.stroke.width;_f4[i]=s.createPath(_f8).setStroke(_f9);if(this.animate){this._animateScatter(_f4[i],dim.height-_ed.b);}}var _fa=dc.makeStroke(_f6.marker.stroke),_fb=this._plotFill(_f6.marker.fill,dim,_ed);if(_fb&&(_fb.type==="linear"||_fb.type=="radial")){var _fc=_e9.getColor(_fb,{x:c.x,y:c.y});if(_fa){_fa.color=_fc;}_f3[i]=s.createPath(_f8).setStroke(_fa).setFill(_fc);}else{_f3[i]=s.createPath(_f8).setStroke(_fa).setFill(_fb);}if(this.opt.labels){var _fd=_f3[i].getBoundingBox();this.createLabel(s,_f5,_fd,_f6);}if(this.animate){this._animateScatter(_f3[i],dim.height-_ed.b);}},this);if(_f3.length){run.dyn.marker=_f0.symbol;run.dyn.markerStroke=_f3[_f3.length-1].getStroke();run.dyn.markerFill=_f3[_f3.length-1].getFill();}if(_ef){var _fe=new Array(_f3.length);arr.forEach(_f3,function(s,i){var o={element:"marker",index:i,run:run,shape:s,outline:_f4&&_f4[i]||null,shadow:_f2&&_f2[i]||null,cx:_f1[i].x,cy:_f1[i].y};if(typeof run.data[0]=="number"){o.x=i+1;o.y=run.data[i];}else{o.x=run.data[i].x;o.y=run.data[i].y;}this._connectEvents(o);_fe[i]=o;},this);this._eventSeries[run.name]=_fe;}else{delete this._eventSeries[run.name];}run.dirty=false;}this.dirty=false;if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_ed);}return this;},_animateScatter:function(_ff,_100){fx.animateTransform(_e5.delegate({shape:_ff,duration:1200,transform:[{name:"translate",start:[0,_100],end:[0,0]},{name:"scale",start:[0,0],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojox/lang/functional/scan":function(){define(["dojo/_base/kernel","dojo/_base/lang","./lambda"],function(_101,lang,df){var _102={};lang.mixin(df,{scanl:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||_101.global;f=df.lambda(f);var t,n,i;if(lang.isArray(a)){t=new Array((n=a.length)+1);t[0]=z;for(i=0;i<n;z=f.call(o,z,a[i],i,a),t[++i]=z){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){t=[z];for(i=0;a.hasNext();t.push(z=f.call(o,z,a.next(),i++,a))){}}else{t=[z];for(i in a){if(!(i in _102)){t.push(z=f.call(o,z,a[i],i,a));}}}}return t;},scanl1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_101.global;f=df.lambda(f);var t,n,z,_103=true;if(lang.isArray(a)){t=new Array(n=a.length);t[0]=z=a[0];for(var i=1;i<n;t[i]=z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){if(a.hasNext()){t=[z=a.next()];for(i=1;a.hasNext();t.push(z=f.call(o,z,a.next(),i++,a))){}}}else{for(i in a){if(!(i in _102)){if(_103){t=[z=a[i]];_103=false;}else{t.push(z=f.call(o,z,a[i],i,a));}}}}}return t;},scanr:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||_101.global;f=df.lambda(f);var n=a.length,t=new Array(n+1),i=n;t[n]=z;for(;i>0;--i,z=f.call(o,z,a[i],i,a),t[i]=z){}return t;},scanr1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_101.global;f=df.lambda(f);var n=a.length,t=new Array(n),z=a[n-1],i=n-1;t[i]=z;for(;i>0;--i,z=f.call(o,z,a[i],i,a),t[i]=z){}return t;}});});},"dijit/Viewport":function(){define(["dojo/Evented","dojo/on","dojo/domReady","dojo/sniff","dojo/window"],function(_104,on,_105,has,_106){var _107=new _104();var _108;_105(function(){var _109=_106.getBox();_107._rlh=on(window,"resize",function(){var _10a=_106.getBox();if(_109.h==_10a.h&&_109.w==_10a.w){return;}_109=_10a;_107.emit("resize");});if(has("ie")==8){var _10b=screen.deviceXDPI;setInterval(function(){if(screen.deviceXDPI!=_10b){_10b=screen.deviceXDPI;_107.emit("resize");}},500);}if(has("ios")){on(document,"focusin",function(evt){_108=evt.target;});on(document,"focusout",function(evt){_108=null;});}});_107.getEffectiveBox=function(doc){var box=_106.getBox(doc);var tag=_108&&_108.tagName&&_108.tagName.toLowerCase();if(has("ios")&&_108&&!_108.readOnly&&(tag=="textarea"||(tag=="input"&&/^(color|email|number|password|search|tel|text|url)$/.test(_108.type)))){box.h*=(orientation==0||orientation==180?0.66:0.4);var rect=_108.getBoundingClientRect();box.h=Math.max(box.h,rect.top+rect.height);}return box;};return _107;});},"dojox/color/_base":function(){define(["../main","dojo/_base/lang","dojo/_base/Color","dojo/colors"],function(_10c,lang,_10d,_10e){var cx=lang.getObject("color",true,_10c);cx.Color=_10d;cx.blend=_10d.blendColors;cx.fromRgb=_10d.fromRgb;cx.fromHex=_10d.fromHex;cx.fromArray=_10d.fromArray;cx.fromString=_10d.fromString;cx.greyscale=_10e.makeGrey;lang.mixin(cx,{fromCmy:function(cyan,_10f,_110){if(lang.isArray(cyan)){_10f=cyan[1],_110=cyan[2],cyan=cyan[0];}else{if(lang.isObject(cyan)){_10f=cyan.m,_110=cyan.y,cyan=cyan.c;}}cyan/=100,_10f/=100,_110/=100;var r=1-cyan,g=1-_10f,b=1-_110;return new _10d({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});},fromCmyk:function(cyan,_111,_112,_113){if(lang.isArray(cyan)){_111=cyan[1],_112=cyan[2],_113=cyan[3],cyan=cyan[0];}else{if(lang.isObject(cyan)){_111=cyan.m,_112=cyan.y,_113=cyan.b,cyan=cyan.c;}}cyan/=100,_111/=100,_112/=100,_113/=100;var r,g,b;r=1-Math.min(1,cyan*(1-_113)+_113);g=1-Math.min(1,_111*(1-_113)+_113);b=1-Math.min(1,_112*(1-_113)+_113);return new _10d({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});},fromHsl:function(hue,_114,_115){if(lang.isArray(hue)){_114=hue[1],_115=hue[2],hue=hue[0];}else{if(lang.isObject(hue)){_114=hue.s,_115=hue.l,hue=hue.h;}}_114/=100;_115/=100;while(hue<0){hue+=360;}while(hue>=360){hue-=360;}var r,g,b;if(hue<120){r=(120-hue)/60,g=hue/60,b=0;}else{if(hue<240){r=0,g=(240-hue)/60,b=(hue-120)/60;}else{r=(hue-240)/60,g=0,b=(360-hue)/60;}}r=2*_114*Math.min(r,1)+(1-_114);g=2*_114*Math.min(g,1)+(1-_114);b=2*_114*Math.min(b,1)+(1-_114);if(_115<0.5){r*=_115,g*=_115,b*=_115;}else{r=(1-_115)*r+2*_115-1;g=(1-_115)*g+2*_115-1;b=(1-_115)*b+2*_115-1;}return new _10d({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});}});cx.fromHsv=function(hue,_116,_117){if(lang.isArray(hue)){_116=hue[1],_117=hue[2],hue=hue[0];}else{if(lang.isObject(hue)){_116=hue.s,_117=hue.v,hue=hue.h;}}if(hue==360){hue=0;}_116/=100;_117/=100;var r,g,b;if(_116==0){r=_117,b=_117,g=_117;}else{var _118=hue/60,i=Math.floor(_118),f=_118-i;var p=_117*(1-_116);var q=_117*(1-(_116*f));var t=_117*(1-(_116*(1-f)));switch(i){case 0:r=_117,g=t,b=p;break;case 1:r=q,g=_117,b=p;break;case 2:r=p,g=_117,b=t;break;case 3:r=p,g=q,b=_117;break;case 4:r=t,g=p,b=_117;break;case 5:r=_117,g=p,b=q;break;}}return new _10d({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});};lang.extend(_10d,{toCmy:function(){var cyan=1-(this.r/255),_119=1-(this.g/255),_11a=1-(this.b/255);return {c:Math.round(cyan*100),m:Math.round(_119*100),y:Math.round(_11a*100)};},toCmyk:function(){var cyan,_11b,_11c,_11d;var r=this.r/255,g=this.g/255,b=this.b/255;_11d=Math.min(1-r,1-g,1-b);cyan=(1-r-_11d)/(1-_11d);_11b=(1-g-_11d)/(1-_11d);_11c=(1-b-_11d)/(1-_11d);return {c:Math.round(cyan*100),m:Math.round(_11b*100),y:Math.round(_11c*100),b:Math.round(_11d*100)};},toHsl:function(){var r=this.r/255,g=this.g/255,b=this.b/255;var min=Math.min(r,b,g),max=Math.max(r,g,b);var _11e=max-min;var h=0,s=0,l=(min+max)/2;if(l>0&&l<1){s=_11e/((l<0.5)?(2*l):(2-2*l));}if(_11e>0){if(max==r&&max!=g){h+=(g-b)/_11e;}if(max==g&&max!=b){h+=(2+(b-r)/_11e);}if(max==b&&max!=r){h+=(4+(r-g)/_11e);}h*=60;}return {h:h,s:Math.round(s*100),l:Math.round(l*100)};},toHsv:function(){var r=this.r/255,g=this.g/255,b=this.b/255;var min=Math.min(r,b,g),max=Math.max(r,g,b);var _11f=max-min;var h=null,s=(max==0)?0:(_11f/max);if(s==0){h=0;}else{if(r==max){h=60*(g-b)/_11f;}else{if(g==max){h=120+60*(b-r)/_11f;}else{h=240+60*(r-g)/_11f;}}if(h<0){h+=360;}}return {h:h,s:Math.round(s*100),v:Math.round(max*100)};}});return cx;});},"dojox/charting/plot2d/OHLC":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/has","./CartesianBase","./_PlotEvents","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx"],function(lang,arr,_120,has,_121,_122,dc,df,dfr,du,fx){var _123=dfr.lambda("item.purgeGroup()");return _120("dojox.charting.plot2d.OHLC",[_121,_122],{defaultParams:{gap:2,animate:null},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:""},constructor:function(_124,_125){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_125);du.updateWithPattern(this.opt,_125,this.optionalParams);this.animate=this.opt.animate;},collectStats:function(_126){var _127=lang.delegate(dc.defaultStats);for(var i=0;i<_126.length;i++){var run=_126[i];if(!run.data.length){continue;}var _128=_127.vmin,_129=_127.vmax;if(!("ymin" in run)||!("ymax" in run)){arr.forEach(run.data,function(val,idx){if(val!==null){var x=val.x||idx+1;_127.hmin=Math.min(_127.hmin,x);_127.hmax=Math.max(_127.hmax,x);_127.vmin=Math.min(_127.vmin,val.open,val.close,val.high,val.low);_127.vmax=Math.max(_127.vmax,val.open,val.close,val.high,val.low);}});}if("ymin" in run){_127.vmin=Math.min(_128,run.ymin);}if("ymax" in run){_127.vmax=Math.max(_129,run.ymax);}}return _127;},getSeriesStats:function(){var _12a=this.collectStats(this.series);_12a.hmin-=0.5;_12a.hmax+=0.5;return _12a;},render:function(dim,_12b){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_12b);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_123);this._eventSeries={};this.cleanGroup();var s=this.getGroup();df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,f,gap,_12c,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_12d=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);gap=f.gap;_12c=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();var _12e=t.next("candlestick",[this.opt,run]),s=run.group,_12f=new Array(run.data.length);for(var j=0;j<run.data.length;++j){var v=run.data[j];if(v!==null){var _130=t.addMixin(_12e,"candlestick",v,true);var x=ht(v.x||(j+0.5))+_12b.l+gap,y=dim.height-_12b.b,open=vt(v.open),_131=vt(v.close),high=vt(v.high),low=vt(v.low);if(low>high){var tmp=high;high=low;low=tmp;}if(_12c>=1){var hl={x1:_12c/2,x2:_12c/2,y1:y-high,y2:y-low},op={x1:0,x2:((_12c/2)+((_130.series.stroke.width||1)/2)),y1:y-open,y2:y-open},cl={x1:((_12c/2)-((_130.series.stroke.width||1)/2)),x2:_12c,y1:y-_131,y2:y-_131};var _132=s.createGroup();_132.setTransform({dx:x,dy:0});var _133=_132.createGroup();_133.createLine(hl).setStroke(_130.series.stroke);_133.createLine(op).setStroke(_130.series.stroke);_133.createLine(cl).setStroke(_130.series.stroke);run.dyn.stroke=_130.series.stroke;if(_12d){var o={element:"candlestick",index:j,run:run,shape:_133,x:x,y:y-Math.max(open,_131),cx:_12c/2,cy:(y-Math.max(open,_131))+(Math.max(open>_131?open-_131:_131-open,1)/2),width:_12c,height:Math.max(open>_131?open-_131:_131-open,1),data:v};this._connectEvents(o);_12f[j]=o;}}if(this.animate){this._animateOHLC(_132,y-low,high-low);}}}this._eventSeries[run.name]=_12f;run.dirty=false;}this.dirty=false;if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_12b);}return this;},_animateOHLC:function(_134,_135,_136){fx.animateTransform(lang.delegate({shape:_134,duration:1200,transform:[{name:"translate",start:[0,_135-(_135/_136)],end:[0,0]},{name:"scale",start:[1,1/_136],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dijit/a11yclick":function(){define(["dojo/keys","dojo/mouse","dojo/on","dojo/touch"],function(keys,_137,on,_138){function _139(e){if((e.keyCode===keys.ENTER||e.keyCode===keys.SPACE)&&!/input|button|textarea/i.test(e.target.nodeName)){for(var node=e.target;node;node=node.parentNode){if(node.dojoClick){return true;}}}};var _13a;on(document,"keydown",function(e){if(_139(e)){_13a=e.target;e.preventDefault();}else{_13a=null;}});on(document,"keyup",function(e){if(_139(e)&&e.target==_13a){_13a=null;on.emit(e.target,"click",{cancelable:true,bubbles:true,ctrlKey:e.ctrlKey,shiftKey:e.shiftKey,metaKey:e.metaKey,altKey:e.altKey,_origType:e.type});}});var _13b=function(node,_13c){node.dojoClick=true;return on(node,"click",_13c);};_13b.click=_13b;_13b.press=function(node,_13d){var _13e=on(node,_138.press,function(evt){if(evt.type=="mousedown"&&!_137.isLeft(evt)){return;}_13d(evt);}),_13f=on(node,"keydown",function(evt){if(evt.keyCode===keys.ENTER||evt.keyCode===keys.SPACE){_13d(evt);}});return {remove:function(){_13e.remove();_13f.remove();}};};_13b.release=function(node,_140){var _141=on(node,_138.release,function(evt){if(evt.type=="mouseup"&&!_137.isLeft(evt)){return;}_140(evt);}),_142=on(node,"keyup",function(evt){if(evt.keyCode===keys.ENTER||evt.keyCode===keys.SPACE){_140(evt);}});return {remove:function(){_141.remove();_142.remove();}};};_13b.move=_138.move;return _13b;});},"dojox/charting/plot2d/ClusteredColumns":function(){define(["dojo/_base/declare","dojo/_base/array","./Columns","./common"],function(_143,_144,_145,dc){return _143("dojox.charting.plot2d.ClusteredColumns",_145,{getBarProperties:function(){var _146=this.series.length;_144.forEach(this.series,function(_147){if(_147.hidden){_146--;}});var f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt,_146);return {gap:f.gap,width:f.size,thickness:f.size,clusterSize:_146};}});});},"dojox/charting/Chart":function(){define(["../main","dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/dom-style","dojo/dom","dojo/dom-geometry","dojo/dom-construct","dojo/_base/Color","dojo/sniff","./Element","./SimpleTheme","./Series","./axis2d/common","dojox/gfx/shape","dojox/gfx","dojo/has!dojo-bidi?./bidi/Chart","dojox/lang/functional","dojox/lang/functional/fold","dojox/lang/functional/reversed"],function(_148,lang,arr,_149,_14a,dom,_14b,_14c,_14d,has,_14e,_14f,_150,_151,_152,g,_153,func){var dc=lang.getObject("charting",true,_148),_154=func.lambda("item.clear()"),_155=func.lambda("item.purgeGroup()"),_156=func.lambda("item.destroy()"),_157=func.lambda("item.dirty = false"),_158=func.lambda("item.dirty = true"),_159=func.lambda("item.name");var _15a=_149(has("dojo-bidi")?"dojox.charting.NonBidiChart":"dojox.charting.Chart",null,{constructor:function(node,_15b){if(!_15b){_15b={};}this.margins=_15b.margins?_15b.margins:{l:10,t:10,r:10,b:10};this.stroke=_15b.stroke;this.fill=_15b.fill;this.delayInMs=_15b.delayInMs||200;this.title=_15b.title;this.titleGap=_15b.titleGap;this.titlePos=_15b.titlePos;this.titleFont=_15b.titleFont;this.titleFontColor=_15b.titleFontColor;this.chartTitle=null;this.htmlLabels=true;if("htmlLabels" in _15b){this.htmlLabels=_15b.htmlLabels;}this.theme=null;this.axes={};this.stack=[];this.plots={};this.series=[];this.runs={};this.dirty=true;this.node=dom.byId(node);var box=_14b.getMarginBox(node);this.surface=g.createSurface(this.node,box.w||400,box.h||300);if(this.surface.declaredClass.indexOf("vml")==-1){this._nativeClip=true;}},destroy:function(){arr.forEach(this.series,_156);arr.forEach(this.stack,_156);func.forIn(this.axes,_156);this.surface.destroy();if(this.chartTitle&&this.chartTitle.tagName){_14c.destroy(this.chartTitle);}},getCoords:function(){var node=this.node;var s=_14a.getComputedStyle(node),_15c=_14b.getMarginBox(node,s);var abs=_14b.position(node,true);_15c.x=abs.x;_15c.y=abs.y;return _15c;},setTheme:function(_15d){this.theme=_15d.clone();this.dirty=true;return this;},addAxis:function(name,_15e){var axis,_15f=_15e&&_15e.type||"Default";if(typeof _15f=="string"){if(!dc.axis2d||!dc.axis2d[_15f]){throw Error("Can't find axis: "+_15f+" - Check "+"require() dependencies.");}axis=new dc.axis2d[_15f](this,_15e);}else{axis=new _15f(this,_15e);}axis.name=name;axis.dirty=true;if(name in this.axes){this.axes[name].destroy();}this.axes[name]=axis;this.dirty=true;return this;},getAxis:function(name){return this.axes[name];},removeAxis:function(name){if(name in this.axes){this.axes[name].destroy();delete this.axes[name];this.dirty=true;}return this;},addPlot:function(name,_160){var plot,_161=_160&&_160.type||"Default";if(typeof _161=="string"){if(!dc.plot2d||!dc.plot2d[_161]){throw Error("Can't find plot: "+_161+" - didn't you forget to dojo"+".require() it?");}plot=new dc.plot2d[_161](this,_160);}else{plot=new _161(this,_160);}plot.name=name;plot.dirty=true;if(name in this.plots){this.stack[this.plots[name]].destroy();this.stack[this.plots[name]]=plot;}else{this.plots[name]=this.stack.length;this.stack.push(plot);}this.dirty=true;return this;},getPlot:function(name){return this.stack[this.plots[name]];},removePlot:function(name){if(name in this.plots){var _162=this.plots[name];delete this.plots[name];this.stack[_162].destroy();this.stack.splice(_162,1);func.forIn(this.plots,function(idx,name,_163){if(idx>_162){_163[name]=idx-1;}});var ns=arr.filter(this.series,function(run){return run.plot!=name;});if(ns.length<this.series.length){arr.forEach(this.series,function(run){if(run.plot==name){run.destroy();}});this.runs={};arr.forEach(ns,function(run,_164){this.runs[run.plot]=_164;},this);this.series=ns;}this.dirty=true;}return this;},getPlotOrder:function(){return func.map(this.stack,_159);},setPlotOrder:function(_165){var _166={},_167=func.filter(_165,function(name){if(!(name in this.plots)||(name in _166)){return false;}_166[name]=1;return true;},this);if(_167.length<this.stack.length){func.forEach(this.stack,function(plot){var name=plot.name;if(!(name in _166)){_167.push(name);}});}var _168=func.map(_167,function(name){return this.stack[this.plots[name]];},this);func.forEach(_168,function(plot,i){this.plots[plot.name]=i;},this);this.stack=_168;this.dirty=true;return this;},movePlotToFront:function(name){if(name in this.plots){var _169=this.plots[name];if(_169){var _16a=this.getPlotOrder();_16a.splice(_169,1);_16a.unshift(name);return this.setPlotOrder(_16a);}}return this;},movePlotToBack:function(name){if(name in this.plots){var _16b=this.plots[name];if(_16b<this.stack.length-1){var _16c=this.getPlotOrder();_16c.splice(_16b,1);_16c.push(name);return this.setPlotOrder(_16c);}}return this;},addSeries:function(name,data,_16d){var run=new _150(this,data,_16d);run.name=name;if(name in this.runs){this.series[this.runs[name]].destroy();this.series[this.runs[name]]=run;}else{this.runs[name]=this.series.length;this.series.push(run);}this.dirty=true;if(!("ymin" in run)&&"min" in run){run.ymin=run.min;}if(!("ymax" in run)&&"max" in run){run.ymax=run.max;}return this;},getSeries:function(name){return this.series[this.runs[name]];},removeSeries:function(name){if(name in this.runs){var _16e=this.runs[name];delete this.runs[name];this.series[_16e].destroy();this.series.splice(_16e,1);func.forIn(this.runs,function(idx,name,runs){if(idx>_16e){runs[name]=idx-1;}});this.dirty=true;}return this;},updateSeries:function(name,data,_16f){if(name in this.runs){var run=this.series[this.runs[name]];run.update(data);if(_16f){this.dirty=true;}else{this._invalidateDependentPlots(run.plot,false);this._invalidateDependentPlots(run.plot,true);}}return this;},getSeriesOrder:function(_170){return func.map(func.filter(this.series,function(run){return run.plot==_170;}),_159);},setSeriesOrder:function(_171){var _172,_173={},_174=func.filter(_171,function(name){if(!(name in this.runs)||(name in _173)){return false;}var run=this.series[this.runs[name]];if(_172){if(run.plot!=_172){return false;}}else{_172=run.plot;}_173[name]=1;return true;},this);func.forEach(this.series,function(run){var name=run.name;if(!(name in _173)&&run.plot==_172){_174.push(name);}});var _175=func.map(_174,function(name){return this.series[this.runs[name]];},this);this.series=_175.concat(func.filter(this.series,function(run){return run.plot!=_172;}));func.forEach(this.series,function(run,i){this.runs[run.name]=i;},this);this.dirty=true;return this;},moveSeriesToFront:function(name){if(name in this.runs){var _176=this.runs[name],_177=this.getSeriesOrder(this.series[_176].plot);if(name!=_177[0]){_177.splice(_176,1);_177.unshift(name);return this.setSeriesOrder(_177);}}return this;},moveSeriesToBack:function(name){if(name in this.runs){var _178=this.runs[name],_179=this.getSeriesOrder(this.series[_178].plot);if(name!=_179[_179.length-1]){_179.splice(_178,1);_179.push(name);return this.setSeriesOrder(_179);}}return this;},resize:function(_17a,_17b){switch(arguments.length){case 1:_14b.setMarginBox(this.node,_17a);break;case 2:_14b.setMarginBox(this.node,{w:_17a,h:_17b});break;}var box=_14b.getMarginBox(this.node);var d=this.surface.getDimensions();if(d.width!=box.w||d.height!=box.h){this.surface.setDimensions(box.w,box.h);this.dirty=true;return this.render();}else{return this;}},getGeometry:function(){var ret={};func.forIn(this.axes,function(axis){if(axis.initialized()){ret[axis.name]={name:axis.name,vertical:axis.vertical,scaler:axis.scaler,ticks:axis.ticks};}});return ret;},setAxisWindow:function(name,_17c,_17d,zoom){var axis=this.axes[name];if(axis){axis.setWindow(_17c,_17d);arr.forEach(this.stack,function(plot){if(plot.hAxis==name||plot.vAxis==name){plot.zoom=zoom;}});}return this;},setWindow:function(sx,sy,dx,dy,zoom){if(!("plotArea" in this)){this.calculateGeometry();}func.forIn(this.axes,function(axis){var _17e,_17f,_180=axis.getScaler().bounds,s=_180.span/(_180.upper-_180.lower);if(axis.vertical){_17e=sy;_17f=dy/s/_17e;}else{_17e=sx;_17f=dx/s/_17e;}axis.setWindow(_17e,_17f);});arr.forEach(this.stack,function(plot){plot.zoom=zoom;});return this;},zoomIn:function(name,_181,_182){var axis=this.axes[name];if(axis){var _183,_184,_185=axis.getScaler().bounds;var _186=Math.min(_181[0],_181[1]);var _187=Math.max(_181[0],_181[1]);_186=_181[0]<_185.lower?_185.lower:_186;_187=_181[1]>_185.upper?_185.upper:_187;_183=(_185.upper-_185.lower)/(_187-_186);_184=_186-_185.lower;this.setAxisWindow(name,_183,_184);if(_182){this.delayedRender();}else{this.render();}}},calculateGeometry:function(){if(this.dirty){return this.fullGeometry();}var _188=arr.filter(this.stack,function(plot){return plot.dirty||(plot.hAxis&&this.axes[plot.hAxis].dirty)||(plot.vAxis&&this.axes[plot.vAxis].dirty);},this);_189(_188,this.plotArea);return this;},fullGeometry:function(){this._makeDirty();arr.forEach(this.stack,_154);if(!this.theme){this.setTheme(new _14f());}arr.forEach(this.series,function(run){if(!(run.plot in this.plots)){if(!dc.plot2d||!dc.plot2d.Default){throw Error("Can't find plot: Default - didn't you forget to dojo"+".require() it?");}var plot=new dc.plot2d.Default(this,{});plot.name=run.plot;this.plots[run.plot]=this.stack.length;this.stack.push(plot);}this.stack[this.plots[run.plot]].addSeries(run);},this);arr.forEach(this.stack,function(plot){if(plot.assignAxes){plot.assignAxes(this.axes);}},this);var dim=this.dim=this.surface.getDimensions();dim.width=g.normalizedLength(dim.width);dim.height=g.normalizedLength(dim.height);func.forIn(this.axes,_154);_189(this.stack,dim);var _18a=this.offsets={l:0,r:0,t:0,b:0};var self=this;func.forIn(this.axes,function(axis){if(has("dojo-bidi")){self._resetLeftBottom(axis);}func.forIn(axis.getOffsets(),function(o,i){_18a[i]=Math.max(o,_18a[i]);});});if(this.title){this.titleGap=(this.titleGap==0)?0:this.titleGap||this.theme.chart.titleGap||20;this.titlePos=this.titlePos||this.theme.chart.titlePos||"top";this.titleFont=this.titleFont||this.theme.chart.titleFont;this.titleFontColor=this.titleFontColor||this.theme.chart.titleFontColor||"black";var _18b=g.normalizedLength(g.splitFontString(this.titleFont).size);_18a[this.titlePos=="top"?"t":"b"]+=(_18b+this.titleGap);}func.forIn(this.margins,function(o,i){_18a[i]+=o;});this.plotArea={width:dim.width-_18a.l-_18a.r,height:dim.height-_18a.t-_18a.b};func.forIn(this.axes,_154);_189(this.stack,this.plotArea);return this;},render:function(){if(this._delayedRenderHandle){clearTimeout(this._delayedRenderHandle);this._delayedRenderHandle=null;}if(this.theme){this.theme.clear();}if(this.dirty){return this.fullRender();}this.calculateGeometry();func.forEachRev(this.stack,function(plot){plot.render(this.dim,this.offsets);},this);func.forIn(this.axes,function(axis){axis.render(this.dim,this.offsets);},this);this._makeClean();return this;},fullRender:function(){this.fullGeometry();var _18c=this.offsets,dim=this.dim;var w=Math.max(0,dim.width-_18c.l-_18c.r),h=Math.max(0,dim.height-_18c.t-_18c.b);arr.forEach(this.series,_155);func.forIn(this.axes,_155);arr.forEach(this.stack,_155);var _18d=this.surface.children;if(_152.dispose){for(var i=0;i<_18d.length;++i){_152.dispose(_18d[i]);}}if(this.chartTitle&&this.chartTitle.tagName){_14c.destroy(this.chartTitle);}this.surface.clear();this.chartTitle=null;this._renderChartBackground(dim,_18c);if(this._nativeClip){this._renderPlotBackground(dim,_18c,w,h);}else{this._renderPlotBackground(dim,_18c,w,h);}func.foldr(this.stack,function(z,plot){return plot.render(dim,_18c),0;},0);if(!this._nativeClip){this._renderChartBackground(dim,_18c);}if(this.title){var _18e=(g.renderer=="canvas")&&this.htmlLabels,_18f=_18e||!has("ie")&&!has("opera")&&this.htmlLabels?"html":"gfx",_190=g.normalizedLength(g.splitFontString(this.titleFont).size);this.chartTitle=_151.createText[_18f](this,this.surface,dim.width/2,this.titlePos=="top"?_190+this.margins.t:dim.height-this.margins.b,"middle",this.title,this.titleFont,this.titleFontColor);}func.forIn(this.axes,function(axis){axis.render(dim,_18c);});this._makeClean();return this;},_renderChartBackground:function(dim,_191){var t=this.theme,rect;var fill=this.fill!==undefined?this.fill:(t.chart&&t.chart.fill);var _192=this.stroke!==undefined?this.stroke:(t.chart&&t.chart.stroke);if(fill=="inherit"){var node=this.node;fill=new _14d(_14a.get(node,"backgroundColor"));while(fill.a==0&&node!=document.documentElement){fill=new _14d(_14a.get(node,"backgroundColor"));node=node.parentNode;}}if(fill){if(this._nativeClip){fill=_14e.prototype._shapeFill(_14e.prototype._plotFill(fill,dim),{x:0,y:0,width:dim.width+1,height:dim.height+1});this.surface.createRect({width:dim.width+1,height:dim.height+1}).setFill(fill);}else{fill=_14e.prototype._plotFill(fill,dim,_191);if(_191.l){rect={x:0,y:0,width:_191.l,height:dim.height+1};this.surface.createRect(rect).setFill(_14e.prototype._shapeFill(fill,rect));}if(_191.r){rect={x:dim.width-_191.r,y:0,width:_191.r+1,height:dim.height+2};this.surface.createRect(rect).setFill(_14e.prototype._shapeFill(fill,rect));}if(_191.t){rect={x:0,y:0,width:dim.width+1,height:_191.t};this.surface.createRect(rect).setFill(_14e.prototype._shapeFill(fill,rect));}if(_191.b){rect={x:0,y:dim.height-_191.b,width:dim.width+1,height:_191.b+2};this.surface.createRect(rect).setFill(_14e.prototype._shapeFill(fill,rect));}}}if(_192){this.surface.createRect({width:dim.width-1,height:dim.height-1}).setStroke(_192);}},_renderPlotBackground:function(dim,_193,w,h){var t=this.theme;var fill=t.plotarea&&t.plotarea.fill;var _194=t.plotarea&&t.plotarea.stroke;var rect={x:_193.l-1,y:_193.t-1,width:w+2,height:h+2};if(fill){fill=_14e.prototype._shapeFill(_14e.prototype._plotFill(fill,dim,_193),rect);this.surface.createRect(rect).setFill(fill);}if(_194){this.surface.createRect({x:_193.l,y:_193.t,width:w+1,height:h+1}).setStroke(_194);}},delayedRender:function(){if(!this._delayedRenderHandle){this._delayedRenderHandle=setTimeout(lang.hitch(this,function(){this.render();}),this.delayInMs);}return this;},connectToPlot:function(name,_195,_196){return name in this.plots?this.stack[this.plots[name]].connect(_195,_196):null;},fireEvent:function(_197,_198,_199){if(_197 in this.runs){var _19a=this.series[this.runs[_197]].plot;if(_19a in this.plots){var plot=this.stack[this.plots[_19a]];if(plot){plot.fireEvent(_197,_198,_199);}}}return this;},_makeClean:function(){arr.forEach(this.axes,_157);arr.forEach(this.stack,_157);arr.forEach(this.series,_157);this.dirty=false;},_makeDirty:function(){arr.forEach(this.axes,_158);arr.forEach(this.stack,_158);arr.forEach(this.series,_158);this.dirty=true;},_invalidateDependentPlots:function(_19b,_19c){if(_19b in this.plots){var plot=this.stack[this.plots[_19b]],axis,_19d=_19c?"vAxis":"hAxis";if(plot[_19d]){axis=this.axes[plot[_19d]];if(axis&&axis.dependOnData()){axis.dirty=true;arr.forEach(this.stack,function(p){if(p[_19d]&&p[_19d]==plot[_19d]){p.dirty=true;}});}}else{plot.dirty=true;}}},setDir:function(dir){return this;},_resetLeftBottom:function(axis){},formatTruncatedLabel:function(_19e,_19f,_1a0){}});function _1a1(_1a2){return {min:_1a2.hmin,max:_1a2.hmax};};function _1a3(_1a4){return {min:_1a4.vmin,max:_1a4.vmax};};function _1a5(_1a6,h){_1a6.hmin=h.min;_1a6.hmax=h.max;};function _1a7(_1a8,v){_1a8.vmin=v.min;_1a8.vmax=v.max;};function _1a9(_1aa,_1ab){if(_1aa&&_1ab){_1aa.min=Math.min(_1aa.min,_1ab.min);_1aa.max=Math.max(_1aa.max,_1ab.max);}return _1aa||_1ab;};function _189(_1ac,_1ad){var _1ae={},axes={};arr.forEach(_1ac,function(plot){var _1af=_1ae[plot.name]=plot.getSeriesStats();if(plot.hAxis){axes[plot.hAxis]=_1a9(axes[plot.hAxis],_1a1(_1af));}if(plot.vAxis){axes[plot.vAxis]=_1a9(axes[plot.vAxis],_1a3(_1af));}});arr.forEach(_1ac,function(plot){var _1b0=_1ae[plot.name];if(plot.hAxis){_1a5(_1b0,axes[plot.hAxis]);}if(plot.vAxis){_1a7(_1b0,axes[plot.vAxis]);}plot.initializeScalers(_1ad,_1b0);});};return has("dojo-bidi")?_149("dojox.charting.Chart",[_15a,_153]):_15a;});},"dojox/charting/plot2d/MarkersOnly":function(){define(["dojo/_base/declare","./Default"],function(_1b1,_1b2){return _1b1("dojox.charting.plot2d.MarkersOnly",_1b2,{constructor:function(){this.opt.lines=false;this.opt.markers=true;}});});},"dojox/charting/plot2d/Areas":function(){define(["dojo/_base/declare","./Default"],function(_1b3,_1b4){return _1b3("dojox.charting.plot2d.Areas",_1b4,{constructor:function(){this.opt.lines=true;this.opt.areas=true;}});});},"dojox/charting/action2d/Base":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/Evented"],function(lang,_1b5,_1b6){return _1b5("dojox.charting.action2d.Base",_1b6,{constructor:function(_1b7,plot){this.chart=_1b7;this.plot=plot?(lang.isString(plot)?this.chart.getPlot(plot):plot):this.chart.getPlot("default");},connect:function(){},disconnect:function(){},destroy:function(){this.disconnect();}});});},"dojo/fx":function(){define(["./_base/lang","./Evented","./_base/kernel","./_base/array","./aspect","./_base/fx","./dom","./dom-style","./dom-geometry","./ready","require"],function(lang,_1b8,dojo,_1b9,_1ba,_1bb,dom,_1bc,geom,_1bd,_1be){if(!dojo.isAsync){_1bd(0,function(){var _1bf=["./fx/Toggler"];_1be(_1bf);});}var _1c0=dojo.fx={};var _1c1={_fire:function(evt,args){if(this[evt]){this[evt].apply(this,args||[]);}return this;}};var _1c2=function(_1c3){this._index=-1;this._animations=_1c3||[];this._current=this._onAnimateCtx=this._onEndCtx=null;this.duration=0;_1b9.forEach(this._animations,function(a){this.duration+=a.duration;if(a.delay){this.duration+=a.delay;}},this);};_1c2.prototype=new _1b8();lang.extend(_1c2,{_onAnimate:function(){this._fire("onAnimate",arguments);},_onEnd:function(){this._onAnimateCtx.remove();this._onEndCtx.remove();this._onAnimateCtx=this._onEndCtx=null;if(this._index+1==this._animations.length){this._fire("onEnd");}else{this._current=this._animations[++this._index];this._onAnimateCtx=_1ba.after(this._current,"onAnimate",lang.hitch(this,"_onAnimate"),true);this._onEndCtx=_1ba.after(this._current,"onEnd",lang.hitch(this,"_onEnd"),true);this._current.play(0,true);}},play:function(_1c4,_1c5){if(!this._current){this._current=this._animations[this._index=0];}if(!_1c5&&this._current.status()=="playing"){return this;}var _1c6=_1ba.after(this._current,"beforeBegin",lang.hitch(this,function(){this._fire("beforeBegin");}),true),_1c7=_1ba.after(this._current,"onBegin",lang.hitch(this,function(arg){this._fire("onBegin",arguments);}),true),_1c8=_1ba.after(this._current,"onPlay",lang.hitch(this,function(arg){this._fire("onPlay",arguments);_1c6.remove();_1c7.remove();_1c8.remove();}));if(this._onAnimateCtx){this._onAnimateCtx.remove();}this._onAnimateCtx=_1ba.after(this._current,"onAnimate",lang.hitch(this,"_onAnimate"),true);if(this._onEndCtx){this._onEndCtx.remove();}this._onEndCtx=_1ba.after(this._current,"onEnd",lang.hitch(this,"_onEnd"),true);this._current.play.apply(this._current,arguments);return this;},pause:function(){if(this._current){var e=_1ba.after(this._current,"onPause",lang.hitch(this,function(arg){this._fire("onPause",arguments);e.remove();}),true);this._current.pause();}return this;},gotoPercent:function(_1c9,_1ca){this.pause();var _1cb=this.duration*_1c9;this._current=null;_1b9.some(this._animations,function(a,_1cc){if(_1cb<=a.duration){this._current=a;this._index=_1cc;return true;}_1cb-=a.duration;return false;},this);if(this._current){this._current.gotoPercent(_1cb/this._current.duration);}if(_1ca){this.play();}return this;},stop:function(_1cd){if(this._current){if(_1cd){for(;this._index+1<this._animations.length;++this._index){this._animations[this._index].stop(true);}this._current=this._animations[this._index];}var e=_1ba.after(this._current,"onStop",lang.hitch(this,function(arg){this._fire("onStop",arguments);e.remove();}),true);this._current.stop();}return this;},status:function(){return this._current?this._current.status():"stopped";},destroy:function(){this.stop();if(this._onAnimateCtx){this._onAnimateCtx.remove();}if(this._onEndCtx){this._onEndCtx.remove();}}});lang.extend(_1c2,_1c1);_1c0.chain=function(_1ce){return new _1c2(_1ce);};var _1cf=function(_1d0){this._animations=_1d0||[];this._connects=[];this._finished=0;this.duration=0;_1b9.forEach(_1d0,function(a){var _1d1=a.duration;if(a.delay){_1d1+=a.delay;}if(this.duration<_1d1){this.duration=_1d1;}this._connects.push(_1ba.after(a,"onEnd",lang.hitch(this,"_onEnd"),true));},this);this._pseudoAnimation=new _1bb.Animation({curve:[0,1],duration:this.duration});var self=this;_1b9.forEach(["beforeBegin","onBegin","onPlay","onAnimate","onPause","onStop","onEnd"],function(evt){self._connects.push(_1ba.after(self._pseudoAnimation,evt,function(){self._fire(evt,arguments);},true));});};lang.extend(_1cf,{_doAction:function(_1d2,args){_1b9.forEach(this._animations,function(a){a[_1d2].apply(a,args);});return this;},_onEnd:function(){if(++this._finished>this._animations.length){this._fire("onEnd");}},_call:function(_1d3,args){var t=this._pseudoAnimation;t[_1d3].apply(t,args);},play:function(_1d4,_1d5){this._finished=0;this._doAction("play",arguments);this._call("play",arguments);return this;},pause:function(){this._doAction("pause",arguments);this._call("pause",arguments);return this;},gotoPercent:function(_1d6,_1d7){var ms=this.duration*_1d6;_1b9.forEach(this._animations,function(a){a.gotoPercent(a.duration<ms?1:(ms/a.duration),_1d7);});this._call("gotoPercent",arguments);return this;},stop:function(_1d8){this._doAction("stop",arguments);this._call("stop",arguments);return this;},status:function(){return this._pseudoAnimation.status();},destroy:function(){this.stop();_1b9.forEach(this._connects,function(_1d9){_1d9.remove();});}});lang.extend(_1cf,_1c1);_1c0.combine=function(_1da){return new _1cf(_1da);};_1c0.wipeIn=function(args){var node=args.node=dom.byId(args.node),s=node.style,o;var anim=_1bb.animateProperty(lang.mixin({properties:{height:{start:function(){o=s.overflow;s.overflow="hidden";if(s.visibility=="hidden"||s.display=="none"){s.height="1px";s.display="";s.visibility="";return 1;}else{var _1db=_1bc.get(node,"height");return Math.max(_1db,1);}},end:function(){return node.scrollHeight;}}}},args));var fini=function(){s.height="auto";s.overflow=o;};_1ba.after(anim,"onStop",fini,true);_1ba.after(anim,"onEnd",fini,true);return anim;};_1c0.wipeOut=function(args){var node=args.node=dom.byId(args.node),s=node.style,o;var anim=_1bb.animateProperty(lang.mixin({properties:{height:{end:1}}},args));_1ba.after(anim,"beforeBegin",function(){o=s.overflow;s.overflow="hidden";s.display="";},true);var fini=function(){s.overflow=o;s.height="auto";s.display="none";};_1ba.after(anim,"onStop",fini,true);_1ba.after(anim,"onEnd",fini,true);return anim;};_1c0.slideTo=function(args){var node=args.node=dom.byId(args.node),top=null,left=null;var init=(function(n){return function(){var cs=_1bc.getComputedStyle(n);var pos=cs.position;top=(pos=="absolute"?n.offsetTop:parseInt(cs.top)||0);left=(pos=="absolute"?n.offsetLeft:parseInt(cs.left)||0);if(pos!="absolute"&&pos!="relative"){var ret=geom.position(n,true);top=ret.y;left=ret.x;n.style.position="absolute";n.style.top=top+"px";n.style.left=left+"px";}};})(node);init();var anim=_1bb.animateProperty(lang.mixin({properties:{top:args.top||0,left:args.left||0}},args));_1ba.after(anim,"beforeBegin",init,true);return anim;};return _1c0;});},"dojox/charting/action2d/PlotAction":function(){define(["dojo/_base/connect","dojo/_base/declare","./Base","dojo/fx/easing","dojox/lang/functional"],function(hub,_1dc,Base,dfe,df){var _1dd=400,_1de=dfe.backOut;return _1dc("dojox.charting.action2d.PlotAction",Base,{overOutEvents:{onmouseover:1,onmouseout:1},constructor:function(_1df,plot,_1e0){this.anim={};if(!_1e0){_1e0={};}this.duration=_1e0.duration?_1e0.duration:_1dd;this.easing=_1e0.easing?_1e0.easing:_1de;},connect:function(){this.handle=this.chart.connectToPlot(this.plot.name,this,"process");},disconnect:function(){if(this.handle){hub.disconnect(this.handle);this.handle=null;}},reset:function(){},destroy:function(){this.inherited(arguments);df.forIn(this.anim,function(o){df.forIn(o,function(anim){anim.action.stop(true);});});this.anim={};}});});},"dojox/charting/plot2d/commonStacked":function(){define(["dojo/_base/lang","./common"],function(lang,_1e1){var _1e2=lang.getObject("dojox.charting.plot2d.commonStacked",true);return lang.mixin(_1e2,{collectStats:function(_1e3){var _1e4=lang.delegate(_1e1.defaultStats);for(var i=0;i<_1e3.length;++i){var run=_1e3[i];for(var j=0;j<run.data.length;j++){var x,y;if(run.data[j]!==null){if(typeof run.data[j]=="number"||!run.data[j].hasOwnProperty("x")){y=_1e2.getIndexValue(_1e3,i,j)[0];x=j+1;}else{x=run.data[j].x;if(x!==null){y=_1e2.getValue(_1e3,i,x)[0];y=y!=null&&y.y?y.y:null;}}_1e4.hmin=Math.min(_1e4.hmin,x);_1e4.hmax=Math.max(_1e4.hmax,x);_1e4.vmin=Math.min(_1e4.vmin,y);_1e4.vmax=Math.max(_1e4.vmax,y);}}}return _1e4;},getIndexValue:function(_1e5,i,_1e6){var _1e7=0,v,j,_1e8;for(j=0;j<=i;++j){if(_1e5[j].hidden){continue;}_1e8=_1e7;v=_1e5[j].data[_1e6];if(v!=null){if(isNaN(v)){v=v.y||0;}_1e7+=v;}}return [_1e7,_1e8];},getValue:function(_1e9,i,x){var _1ea=null,j,z,v,_1eb;for(j=0;j<=i;++j){if(_1e9[j].hidden){continue;}for(z=0;z<_1e9[j].data.length;z++){_1eb=_1ea;v=_1e9[j].data[z];if(v!==null){if(v.x==x){if(!_1ea){_1ea={x:x};}if(v.y!=null){if(_1ea.y==null){_1ea.y=0;}_1ea.y+=v.y;}break;}else{if(v.x>x){break;}}}}}return [_1ea,_1eb];}});});},"dojox/gfx/fx":function(){define(["dojo/_base/lang","./_base","./matrix","dojo/_base/Color","dojo/_base/array","dojo/_base/fx","dojo/_base/connect","dojo/sniff"],function(lang,g,m,_1ec,arr,fx,Hub,has){var fxg=g.fx={};function _1ed(_1ee,end){this.start=_1ee,this.end=end;};_1ed.prototype.getValue=function(r){return (this.end-this.start)*r+this.start;};function _1ef(_1f0,end,_1f1){this.start=_1f0,this.end=end;this.units=_1f1;};_1ef.prototype.getValue=function(r){return (this.end-this.start)*r+this.start+this.units;};function _1f2(_1f3,end){this.start=_1f3,this.end=end;this.temp=new _1ec();};_1f2.prototype.getValue=function(r){return _1ec.blendColors(this.start,this.end,r,this.temp);};function _1f4(_1f5){this.values=_1f5;this.length=_1f5.length;};_1f4.prototype.getValue=function(r){return this.values[Math.min(Math.floor(r*this.length),this.length-1)];};function _1f6(_1f7,def){this.values=_1f7;this.def=def?def:{};};_1f6.prototype.getValue=function(r){var ret=lang.clone(this.def);for(var i in this.values){ret[i]=this.values[i].getValue(r);}return ret;};function _1f8(_1f9,_1fa){this.stack=_1f9;this.original=_1fa;};_1f8.prototype.getValue=function(r){var ret=[];arr.forEach(this.stack,function(t){if(t instanceof m.Matrix2D){ret.push(t);return;}if(t.name=="original"&&this.original){ret.push(this.original);return;}if(t.name=="matrix"){if((t.start instanceof m.Matrix2D)&&(t.end instanceof m.Matrix2D)){var _1fb=new m.Matrix2D();for(var p in t.start){_1fb[p]=(t.end[p]-t.start[p])*r+t.start[p];}ret.push(_1fb);}return;}if(!(t.name in m)){return;}var f=m[t.name];if(typeof f!="function"){ret.push(f);return;}var val=arr.map(t.start,function(v,i){return (t.end[i]-v)*r+v;}),_1fc=f.apply(m,val);if(_1fc instanceof m.Matrix2D){ret.push(_1fc);}},this);return ret;};var _1fd=new _1ec(0,0,0,0);function _1fe(prop,obj,name,def){if(prop.values){return new _1f4(prop.values);}var _1ff,_200,end;if(prop.start){_200=g.normalizeColor(prop.start);}else{_200=_1ff=obj?(name?obj[name]:obj):def;}if(prop.end){end=g.normalizeColor(prop.end);}else{if(!_1ff){_1ff=obj?(name?obj[name]:obj):def;}end=_1ff;}return new _1f2(_200,end);};function _201(prop,obj,name,def){if(prop.values){return new _1f4(prop.values);}var _202,_203,end;if(prop.start){_203=prop.start;}else{_203=_202=obj?obj[name]:def;}if(prop.end){end=prop.end;}else{if(typeof _202!="number"){_202=obj?obj[name]:def;}end=_202;}return new _1ed(_203,end);};fxg.animateStroke=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),_204=args.shape,_205;Hub.connect(anim,"beforeBegin",anim,function(){_205=_204.getStroke();var prop=args.color,_206={},_207,_208,end;if(prop){_206.color=_1fe(prop,_205,"color",_1fd);}prop=args.style;if(prop&&prop.values){_206.style=new _1f4(prop.values);}prop=args.width;if(prop){_206.width=_201(prop,_205,"width",1);}prop=args.cap;if(prop&&prop.values){_206.cap=new _1f4(prop.values);}prop=args.join;if(prop){if(prop.values){_206.join=new _1f4(prop.values);}else{_208=prop.start?prop.start:(_205&&_205.join||0);end=prop.end?prop.end:(_205&&_205.join||0);if(typeof _208=="number"&&typeof end=="number"){_206.join=new _1ed(_208,end);}}}this.curve=new _1f6(_206,_205);});Hub.connect(anim,"onAnimate",_204,"setStroke");return anim;};fxg.animateFill=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),_209=args.shape,fill;Hub.connect(anim,"beforeBegin",anim,function(){fill=_209.getFill();var prop=args.color,_20a={};if(prop){this.curve=_1fe(prop,fill,"",_1fd);}});Hub.connect(anim,"onAnimate",_209,"setFill");return anim;};fxg.animateFont=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),_20b=args.shape,font;Hub.connect(anim,"beforeBegin",anim,function(){font=_20b.getFont();var prop=args.style,_20c={},_20d,_20e,end;if(prop&&prop.values){_20c.style=new _1f4(prop.values);}prop=args.variant;if(prop&&prop.values){_20c.variant=new _1f4(prop.values);}prop=args.weight;if(prop&&prop.values){_20c.weight=new _1f4(prop.values);}prop=args.family;if(prop&&prop.values){_20c.family=new _1f4(prop.values);}prop=args.size;if(prop&&prop.units){_20e=parseFloat(prop.start?prop.start:(_20b.font&&_20b.font.size||"0"));end=parseFloat(prop.end?prop.end:(_20b.font&&_20b.font.size||"0"));_20c.size=new _1ef(_20e,end,prop.units);}this.curve=new _1f6(_20c,font);});Hub.connect(anim,"onAnimate",_20b,"setFont");return anim;};fxg.animateTransform=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),_20f=args.shape,_210;Hub.connect(anim,"beforeBegin",anim,function(){_210=_20f.getTransform();this.curve=new _1f8(args.transform,_210);});Hub.connect(anim,"onAnimate",_20f,"setTransform");if(g.renderer==="svg"&&has("ie")>=10){var _211=[Hub.connect(anim,"onBegin",anim,function(){var _212=_20f.getParent();while(_212&&_212.getParent){_212=_212.getParent();}if(_212){_20f.__svgContainer=_212.rawNode.parentNode;}}),Hub.connect(anim,"onAnimate",anim,function(){try{if(_20f.__svgContainer){var ov=_20f.__svgContainer.style.visibility;_20f.__svgContainer.style.visibility="visible";var _213=_20f.__svgContainer.offsetHeight;_20f.__svgContainer.style.visibility=ov;}}catch(e){}}),Hub.connect(anim,"onEnd",anim,function(){arr.forEach(_211,Hub.disconnect);if(_20f.__svgContainer){var ov=_20f.__svgContainer.style.visibility;var sn=_20f.__svgContainer;_20f.__svgContainer.style.visibility="visible";setTimeout(function(){try{sn.style.visibility=ov;sn=null;}catch(e){}},100);}delete _20f.__svgContainer;})];}return anim;};return fxg;});},"dijit/BackgroundIframe":function(){define(["require","./main","dojo/_base/config","dojo/dom-construct","dojo/dom-style","dojo/_base/lang","dojo/on","dojo/sniff"],function(_214,_215,_216,_217,_218,lang,on,has){has.add("config-bgIframe",(has("ie")&&!/IEMobile\/10\.0/.test(navigator.userAgent))||(has("trident")&&/Windows NT 6.[01]/.test(navigator.userAgent)));var _219=new function(){var _21a=[];this.pop=function(){var _21b;if(_21a.length){_21b=_21a.pop();_21b.style.display="";}else{if(has("ie")<9){var burl=_216["dojoBlankHtmlUrl"]||_214.toUrl("dojo/resources/blank.html")||"javascript:\"\"";var html="<iframe src='"+burl+"' role='presentation'"+" style='position: absolute; left: 0px; top: 0px;"+"z-index: -1; filter:Alpha(Opacity=\"0\");'>";_21b=document.createElement(html);}else{_21b=_217.create("iframe");_21b.src="javascript:\"\"";_21b.className="dijitBackgroundIframe";_21b.setAttribute("role","presentation");_218.set(_21b,"opacity",0.1);}_21b.tabIndex=-1;}return _21b;};this.push=function(_21c){_21c.style.display="none";_21a.push(_21c);};}();_215.BackgroundIframe=function(node){if(!node.id){throw new Error("no id");}if(has("config-bgIframe")){var _21d=(this.iframe=_219.pop());node.appendChild(_21d);if(has("ie")<7||has("quirks")){this.resize(node);this._conn=on(node,"resize",lang.hitch(this,"resize",node));}else{_218.set(_21d,{width:"100%",height:"100%"});}}};lang.extend(_215.BackgroundIframe,{resize:function(node){if(this.iframe){_218.set(this.iframe,{width:node.offsetWidth+"px",height:node.offsetHeight+"px"});}},destroy:function(){if(this._conn){this._conn.remove();this._conn=null;}if(this.iframe){this.iframe.parentNode.removeChild(this.iframe);_219.push(this.iframe);delete this.iframe;}}});return _215.BackgroundIframe;});},"dojox/main":function(){define(["dojo/_base/kernel"],function(dojo){return dojo.dojox;});},"dojox/charting/action2d/Magnify":function(){define(["dojo/_base/connect","dojo/_base/declare","./PlotAction","dojox/gfx/matrix","dojox/gfx/fx","dojo/fx","dojo/fx/easing"],function(Hub,_21e,_21f,m,gf,df,dfe){var _220=2;return _21e("dojox.charting.action2d.Magnify",_21f,{defaultParams:{duration:400,easing:dfe.backOut,scale:_220},optionalParams:{},constructor:function(_221,plot,_222){this.scale=_222&&typeof _222.scale=="number"?_222.scale:_220;this.connect();},process:function(o){if(!o.shape||!(o.type in this.overOutEvents)||!("cx" in o)||!("cy" in o)){return;}if(o.element=="spider_plot"||o.element=="spider_poly"){return;}var _223=o.run.name,_224=o.index,_225=[],anim,init,_226;if(_223 in this.anim){anim=this.anim[_223][_224];}else{this.anim[_223]={};}if(anim){anim.action.stop(true);}else{this.anim[_223][_224]=anim={};}if(o.type=="onmouseover"){init=m.identity;_226=this.scale;}else{init=m.scaleAt(this.scale,o.cx,o.cy);_226=1/this.scale;}var _227={shape:o.shape,duration:this.duration,easing:this.easing,transform:[{name:"scaleAt",start:[1,o.cx,o.cy],end:[_226,o.cx,o.cy]},init]};if(o.shape){_225.push(gf.animateTransform(_227));}if(o.outline){_227.shape=o.outline;_225.push(gf.animateTransform(_227));}if(o.shadow){_227.shape=o.shadow;_225.push(gf.animateTransform(_227));}if(!_225.length){delete this.anim[_223][_224];return;}anim.action=df.combine(_225);if(o.type=="onmouseout"){Hub.connect(anim.action,"onEnd",this,function(){if(this.anim[_223]){delete this.anim[_223][_224];}});}anim.action.play();}});});},"dojo/Stateful":function(){define(["./_base/declare","./_base/lang","./_base/array","./when"],function(_228,lang,_229,when){return _228("dojo.Stateful",null,{_attrPairNames:{},_getAttrNames:function(name){var apn=this._attrPairNames;if(apn[name]){return apn[name];}return (apn[name]={s:"_"+name+"Setter",g:"_"+name+"Getter"});},postscript:function(_22a){if(_22a){this.set(_22a);}},_get:function(name,_22b){return typeof this[_22b.g]==="function"?this[_22b.g]():this[name];},get:function(name){return this._get(name,this._getAttrNames(name));},set:function(name,_22c){if(typeof name==="object"){for(var x in name){if(name.hasOwnProperty(x)&&x!="_watchCallbacks"){this.set(x,name[x]);}}return this;}var _22d=this._getAttrNames(name),_22e=this._get(name,_22d),_22f=this[_22d.s],_230;if(typeof _22f==="function"){_230=_22f.apply(this,Array.prototype.slice.call(arguments,1));}else{this[name]=_22c;}if(this._watchCallbacks){var self=this;when(_230,function(){self._watchCallbacks(name,_22e,_22c);});}return this;},_changeAttrValue:function(name,_231){var _232=this.get(name);this[name]=_231;if(this._watchCallbacks){this._watchCallbacks(name,_232,_231);}return this;},watch:function(name,_233){var _234=this._watchCallbacks;if(!_234){var self=this;_234=this._watchCallbacks=function(name,_235,_236,_237){var _238=function(_239){if(_239){_239=_239.slice();for(var i=0,l=_239.length;i<l;i++){_239[i].call(self,name,_235,_236);}}};_238(_234["_"+name]);if(!_237){_238(_234["*"]);}};}if(!_233&&typeof name==="function"){_233=name;name="*";}else{name="_"+name;}var _23a=_234[name];if(typeof _23a!=="object"){_23a=_234[name]=[];}_23a.push(_233);var _23b={};_23b.unwatch=_23b.remove=function(){var _23c=_229.indexOf(_23a,_233);if(_23c>-1){_23a.splice(_23c,1);}};return _23b;}});});},"dojox/charting/plot2d/Markers":function(){define(["dojo/_base/declare","./Default"],function(_23d,_23e){return _23d("dojox.charting.plot2d.Markers",_23e,{constructor:function(){this.opt.markers=true;}});});},"dojox/charting/plot2d/Bubble":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/_base/array","dojo/has","./CartesianBase","./_PlotEvents","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx"],function(lang,_23f,arr,has,_240,_241,dc,df,dfr,du,fx){var _242=dfr.lambda("item.purgeGroup()");return _23f("dojox.charting.plot2d.Bubble",[_240,_241],{defaultParams:{animate:null},optionalParams:{stroke:{},outline:{},shadow:{},fill:{},filter:{},styleFunc:null,font:"",fontColor:"",labelFunc:null},constructor:function(_243,_244){this.opt=lang.clone(lang.mixin(this.opt,this.defaultParams));du.updateWithObject(this.opt,_244);du.updateWithPattern(this.opt,_244,this.optionalParams);if(!this.opt.labelFunc){this.opt.labelFunc=function(_245,_246,_247){return this._getLabel(_245.size,_246,_247);};}this.animate=this.opt.animate;},render:function(dim,_248){var s;if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_248);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_242);this._eventSeries={};this.cleanGroup();s=this.getGroup();df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_249=this.events();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(!run.data.length){run.dirty=false;t.skip();continue;}if(typeof run.data[0]=="number"){console.warn("dojox.charting.plot2d.Bubble: the data in the following series cannot be rendered as a bubble chart; ",run);continue;}var _24a=t.next("circle",[this.opt,run]),_24b=arr.map(run.data,function(v){return v?{x:ht(v.x)+_248.l,y:dim.height-_248.b-vt(v.y),radius:this._vScaler.bounds.scale*(v.size/2)}:null;},this);if(run.hidden){run.dyn.fill=_24a.series.fill;run.dyn.stroke=_24a.series.stroke;continue;}s=run.group;var _24c=null,_24d=null,_24e=null,_24f=this.opt.styleFunc;var _250=function(item){if(_24f){return t.addMixin(_24a,"circle",[item,_24f(item)],true);}return t.addMixin(_24a,"circle",item,true);};if(_24a.series.shadow){_24e=arr.map(_24b,function(item,i){if(item!==null){var _251=_250(run.data[i]),_252=_251.series.shadow;var _253=s.createCircle({cx:item.x+_252.dx,cy:item.y+_252.dy,r:item.radius}).setStroke(_252).setFill(_252.color);if(this.animate){this._animateBubble(_253,dim.height-_248.b,item.radius);}return _253;}return null;},this);if(_24e.length){run.dyn.shadow=_24e[_24e.length-1].getStroke();}}if(_24a.series.outline){_24d=arr.map(_24b,function(item,i){if(item!==null){var _254=_250(run.data[i]),_255=dc.makeStroke(_254.series.outline);_255.width=2*_255.width+_24a.series.stroke.width;var _256=s.createCircle({cx:item.x,cy:item.y,r:item.radius}).setStroke(_255);if(this.animate){this._animateBubble(_256,dim.height-_248.b,item.radius);}return _256;}return null;},this);if(_24d.length){run.dyn.outline=_24d[_24d.length-1].getStroke();}}_24c=arr.map(_24b,function(item,i){if(item!==null){var _257=_250(run.data[i]),rect={x:item.x-item.radius,y:item.y-item.radius,width:2*item.radius,height:2*item.radius};var _258=this._plotFill(_257.series.fill,dim,_248);_258=this._shapeFill(_258,rect);var _259=s.createCircle({cx:item.x,cy:item.y,r:item.radius}).setFill(_258).setStroke(_257.series.stroke);if(_259.setFilter&&_257.series.filter){_259.setFilter(_257.series.filter);}if(this.animate){this._animateBubble(_259,dim.height-_248.b,item.radius);}this.createLabel(s,run.data[i],rect,_257);return _259;}return null;},this);if(_24c.length){run.dyn.fill=_24c[_24c.length-1].getFill();run.dyn.stroke=_24c[_24c.length-1].getStroke();}if(_249){var _25a=new Array(_24c.length);arr.forEach(_24c,function(s,i){if(s!==null){var o={element:"circle",index:i,run:run,shape:s,outline:_24d&&_24d[i]||null,shadow:_24e&&_24e[i]||null,x:run.data[i].x,y:run.data[i].y,r:run.data[i].size/2,cx:_24b[i].x,cy:_24b[i].y,cr:_24b[i].radius};this._connectEvents(o);_25a[i]=o;}},this);this._eventSeries[run.name]=_25a;}else{delete this._eventSeries[run.name];}run.dirty=false;}this.dirty=false;if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_248);}return this;},_animateBubble:function(_25b,_25c,size){fx.animateTransform(lang.delegate({shape:_25b,duration:1200,transform:[{name:"translate",start:[0,_25c],end:[0,0]},{name:"scale",start:[0,1/size],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojo/touch":function(){define(["./_base/kernel","./aspect","./dom","./dom-class","./_base/lang","./on","./has","./mouse","./domReady","./_base/window"],function(dojo,_25d,dom,_25e,lang,on,has,_25f,_260,win){var ios4=has("ios")<5;var _261=has("pointer-events")||has("MSPointer"),_262=(function(){var _263={};for(var type in {down:1,move:1,up:1,cancel:1,over:1,out:1}){_263[type]=has("MSPointer")?"MSPointer"+type.charAt(0).toUpperCase()+type.slice(1):"pointer"+type;}return _263;})();var _264=has("touch-events");var _265,_266,_267=false,_268,_269,_26a,_26b,_26c,_26d;var _26e;function _26f(_270,_271,_272){if(_261&&_272){return function(node,_273){return on(node,_272,_273);};}else{if(_264){return function(node,_274){var _275=on(node,_271,function(evt){_274.call(this,evt);_26e=(new Date()).getTime();}),_276=on(node,_270,function(evt){if(!_26e||(new Date()).getTime()>_26e+1000){_274.call(this,evt);}});return {remove:function(){_275.remove();_276.remove();}};};}else{return function(node,_277){return on(node,_270,_277);};}}};function _278(node){do{if(node.dojoClick!==undefined){return node;}}while(node=node.parentNode);};function _279(e,_27a,_27b){var _27c=_278(e.target);_266=!e.target.disabled&&_27c&&_27c.dojoClick;if(_266){_267=(_266=="useTarget");_268=(_267?_27c:e.target);if(_267){e.preventDefault();}_269=e.changedTouches?e.changedTouches[0].pageX-win.global.pageXOffset:e.clientX;_26a=e.changedTouches?e.changedTouches[0].pageY-win.global.pageYOffset:e.clientY;_26b=(typeof _266=="object"?_266.x:(typeof _266=="number"?_266:0))||4;_26c=(typeof _266=="object"?_266.y:(typeof _266=="number"?_266:0))||4;if(!_265){_265=true;function _27d(e){if(_267){_266=dom.isDescendant(win.doc.elementFromPoint((e.changedTouches?e.changedTouches[0].pageX-win.global.pageXOffset:e.clientX),(e.changedTouches?e.changedTouches[0].pageY-win.global.pageYOffset:e.clientY)),_268);}else{_266=_266&&(e.changedTouches?e.changedTouches[0].target:e.target)==_268&&Math.abs((e.changedTouches?e.changedTouches[0].pageX-win.global.pageXOffset:e.clientX)-_269)<=_26b&&Math.abs((e.changedTouches?e.changedTouches[0].pageY-win.global.pageYOffset:e.clientY)-_26a)<=_26c;}};win.doc.addEventListener(_27a,function(e){_27d(e);if(_267){e.preventDefault();}},true);win.doc.addEventListener(_27b,function(e){_27d(e);if(_266){_26d=(new Date()).getTime();var _27e=(_267?_268:e.target);if(_27e.tagName==="LABEL"){_27e=dom.byId(_27e.getAttribute("for"))||_27e;}var src=(e.changedTouches)?e.changedTouches[0]:e;var _27f=document.createEvent("MouseEvents");_27f._dojo_click=true;_27f.initMouseEvent("click",true,true,e.view,e.detail,src.screenX,src.screenY,src.clientX,src.clientY,e.ctrlKey,e.altKey,e.shiftKey,e.metaKey,0,null);setTimeout(function(){on.emit(_27e,"click",_27f);_26d=(new Date()).getTime();},0);}},true);function _280(type){win.doc.addEventListener(type,function(e){if(!e._dojo_click&&(new Date()).getTime()<=_26d+1000&&!(e.target.tagName=="INPUT"&&_25e.contains(e.target,"dijitOffScreen"))){e.stopPropagation();e.stopImmediatePropagation&&e.stopImmediatePropagation();if(type=="click"&&(e.target.tagName!="INPUT"||e.target.type=="radio"||e.target.type=="checkbox")&&e.target.tagName!="TEXTAREA"&&e.target.tagName!="AUDIO"&&e.target.tagName!="VIDEO"){e.preventDefault();}}},true);};_280("click");_280("mousedown");_280("mouseup");}}};var _281;if(_261){_260(function(){win.doc.addEventListener(_262.down,function(evt){_279(evt,_262.move,_262.up);},true);});}else{if(_264){_260(function(){_281=win.body();win.doc.addEventListener("touchstart",function(evt){_26e=(new Date()).getTime();var _282=_281;_281=evt.target;on.emit(_282,"dojotouchout",{relatedTarget:_281,bubbles:true});on.emit(_281,"dojotouchover",{relatedTarget:_282,bubbles:true});_279(evt,"touchmove","touchend");},true);function _283(evt){var _284=lang.delegate(evt,{bubbles:true});if(has("ios")>=6){_284.touches=evt.touches;_284.altKey=evt.altKey;_284.changedTouches=evt.changedTouches;_284.ctrlKey=evt.ctrlKey;_284.metaKey=evt.metaKey;_284.shiftKey=evt.shiftKey;_284.targetTouches=evt.targetTouches;}return _284;};on(win.doc,"touchmove",function(evt){_26e=(new Date()).getTime();var _285=win.doc.elementFromPoint(evt.pageX-(ios4?0:win.global.pageXOffset),evt.pageY-(ios4?0:win.global.pageYOffset));if(_285){if(_281!==_285){on.emit(_281,"dojotouchout",{relatedTarget:_285,bubbles:true});on.emit(_285,"dojotouchover",{relatedTarget:_281,bubbles:true});_281=_285;}if(!on.emit(_285,"dojotouchmove",_283(evt))){evt.preventDefault();}}});on(win.doc,"touchend",function(evt){_26e=(new Date()).getTime();var node=win.doc.elementFromPoint(evt.pageX-(ios4?0:win.global.pageXOffset),evt.pageY-(ios4?0:win.global.pageYOffset))||win.body();on.emit(node,"dojotouchend",_283(evt));});});}}var _286={press:_26f("mousedown","touchstart",_262.down),move:_26f("mousemove","dojotouchmove",_262.move),release:_26f("mouseup","dojotouchend",_262.up),cancel:_26f(_25f.leave,"touchcancel",_261?_262.cancel:null),over:_26f("mouseover","dojotouchover",_262.over),out:_26f("mouseout","dojotouchout",_262.out),enter:_25f._eventHandler(_26f("mouseover","dojotouchover",_262.over)),leave:_25f._eventHandler(_26f("mouseout","dojotouchout",_262.out))};1&&(dojo.touch=_286);return _286;});},"dojox/gfx/gradutils":function(){define(["./_base","dojo/_base/lang","./matrix","dojo/_base/Color"],function(g,lang,m,_287){var _288=g.gradutils={};function _289(o,c){if(o<=0){return c[0].color;}var len=c.length;if(o>=1){return c[len-1].color;}for(var i=0;i<len;++i){var stop=c[i];if(stop.offset>=o){if(i){var prev=c[i-1];return _287.blendColors(new _287(prev.color),new _287(stop.color),(o-prev.offset)/(stop.offset-prev.offset));}return stop.color;}}return c[len-1].color;};_288.getColor=function(fill,pt){var o;if(fill){switch(fill.type){case "linear":var _28a=Math.atan2(fill.y2-fill.y1,fill.x2-fill.x1),_28b=m.rotate(-_28a),_28c=m.project(fill.x2-fill.x1,fill.y2-fill.y1),p=m.multiplyPoint(_28c,pt),pf1=m.multiplyPoint(_28c,fill.x1,fill.y1),pf2=m.multiplyPoint(_28c,fill.x2,fill.y2),_28d=m.multiplyPoint(_28b,pf2.x-pf1.x,pf2.y-pf1.y).x;o=m.multiplyPoint(_28b,p.x-pf1.x,p.y-pf1.y).x/_28d;break;case "radial":var dx=pt.x-fill.cx,dy=pt.y-fill.cy;o=Math.sqrt(dx*dx+dy*dy)/fill.r;break;}return _289(o,fill.colors);}return new _287(fill||[0,0,0,0]);};_288.reverse=function(fill){if(fill){switch(fill.type){case "linear":case "radial":fill=lang.delegate(fill);if(fill.colors){var c=fill.colors,l=c.length,i=0,stop,n=fill.colors=new Array(c.length);for(;i<l;++i){stop=c[i];n[i]={offset:1-stop.offset,color:stop.color};}n.sort(function(a,b){return a.offset-b.offset;});}break;}}return fill;};return _288;});},"dojo/hccss":function(){define(["require","./_base/config","./dom-class","./dom-style","./has","./domReady","./_base/window"],function(_28e,_28f,_290,_291,has,_292,win){has.add("highcontrast",function(){var div=win.doc.createElement("div");div.style.cssText="border: 1px solid; border-color:red green; position: absolute; height: 5px; top: -999px;"+"background-image: url(\""+(_28f.blankGif||_28e.toUrl("./resources/blank.gif"))+"\");";win.body().appendChild(div);var cs=_291.getComputedStyle(div),_293=cs.backgroundImage,hc=(cs.borderTopColor==cs.borderRightColor)||(_293&&(_293=="none"||_293=="url(invalid-url:)"));if(has("ie")<=8){div.outerHTML="";}else{win.body().removeChild(div);}return hc;});_292(function(){if(has("highcontrast")){_290.add(win.body(),"dj_a11y");}});return has;});},"dojo/string":function(){define(["./_base/kernel","./_base/lang"],function(_294,lang){var _295=/[&<>'"\/]/g;var _296={"&":"&amp;","<":"&lt;",">":"&gt;","\"":"&quot;","'":"&#x27;","/":"&#x2F;"};var _297={};lang.setObject("dojo.string",_297);_297.escape=function(str){if(!str){return "";}return str.replace(_295,function(c){return _296[c];});};_297.rep=function(str,num){if(num<=0||!str){return "";}var buf=[];for(;;){if(num&1){buf.push(str);}if(!(num>>=1)){break;}str+=str;}return buf.join("");};_297.pad=function(text,size,ch,end){if(!ch){ch="0";}var out=String(text),pad=_297.rep(ch,Math.ceil((size-out.length)/ch.length));return end?out+pad:pad+out;};_297.substitute=function(_298,map,_299,_29a){_29a=_29a||_294.global;_299=_299?lang.hitch(_29a,_299):function(v){return v;};return _298.replace(/\$\{([^\s\:\}]+)(?:\:([^\s\:\}]+))?\}/g,function(_29b,key,_29c){var _29d=lang.getObject(key,false,map);if(_29c){_29d=lang.getObject(_29c,false,_29a).call(_29a,_29d,key);}return _299(_29d,key).toString();});};_297.trim=String.prototype.trim?lang.trim:function(str){str=str.replace(/^\s+/,"");for(var i=str.length-1;i>=0;i--){if(/\S/.test(str.charAt(i))){str=str.substring(0,i+1);break;}}return str;};return _297;});},"dijit/_AttachMixin":function(){define(["require","dojo/_base/array","dojo/_base/connect","dojo/_base/declare","dojo/_base/lang","dojo/mouse","dojo/on","dojo/touch","./_WidgetBase"],function(_29e,_29f,_2a0,_2a1,lang,_2a2,on,_2a3,_2a4){var _2a5=lang.delegate(_2a3,{"mouseenter":_2a2.enter,"mouseleave":_2a2.leave,"keypress":_2a0._keypress});var _2a6;var _2a7=_2a1("dijit._AttachMixin",null,{constructor:function(){this._attachPoints=[];this._attachEvents=[];},buildRendering:function(){this.inherited(arguments);this._attachTemplateNodes(this.domNode);this._beforeFillContent();},_beforeFillContent:function(){},_attachTemplateNodes:function(_2a8){var node=_2a8;while(true){if(node.nodeType==1&&(this._processTemplateNode(node,function(n,p){return n.getAttribute(p);},this._attach)||this.searchContainerNode)&&node.firstChild){node=node.firstChild;}else{if(node==_2a8){return;}while(!node.nextSibling){node=node.parentNode;if(node==_2a8){return;}}node=node.nextSibling;}}},_processTemplateNode:function(_2a9,_2aa,_2ab){var ret=true;var _2ac=this.attachScope||this,_2ad=_2aa(_2a9,"dojoAttachPoint")||_2aa(_2a9,"data-dojo-attach-point");if(_2ad){var _2ae,_2af=_2ad.split(/\s*,\s*/);while((_2ae=_2af.shift())){if(lang.isArray(_2ac[_2ae])){_2ac[_2ae].push(_2a9);}else{_2ac[_2ae]=_2a9;}ret=(_2ae!="containerNode");this._attachPoints.push(_2ae);}}var _2b0=_2aa(_2a9,"dojoAttachEvent")||_2aa(_2a9,"data-dojo-attach-event");if(_2b0){var _2b1,_2b2=_2b0.split(/\s*,\s*/);var trim=lang.trim;while((_2b1=_2b2.shift())){if(_2b1){var _2b3=null;if(_2b1.indexOf(":")!=-1){var _2b4=_2b1.split(":");_2b1=trim(_2b4[0]);_2b3=trim(_2b4[1]);}else{_2b1=trim(_2b1);}if(!_2b3){_2b3=_2b1;}this._attachEvents.push(_2ab(_2a9,_2b1,lang.hitch(_2ac,_2b3)));}}}return ret;},_attach:function(node,type,func){type=type.replace(/^on/,"").toLowerCase();if(type=="dijitclick"){type=_2a6||(_2a6=_29e("./a11yclick"));}else{type=_2a5[type]||type;}return on(node,type,func);},_detachTemplateNodes:function(){var _2b5=this.attachScope||this;_29f.forEach(this._attachPoints,function(_2b6){delete _2b5[_2b6];});this._attachPoints=[];_29f.forEach(this._attachEvents,function(_2b7){_2b7.remove();});this._attachEvents=[];},destroyRendering:function(){this._detachTemplateNodes();this.inherited(arguments);}});lang.extend(_2a4,{dojoAttachEvent:"",dojoAttachPoint:""});return _2a7;});},"dojox/charting/plot2d/Lines":function(){define(["dojo/_base/declare","./Default"],function(_2b8,_2b9){return _2b8("dojox.charting.plot2d.Lines",_2b9,{constructor:function(){this.opt.lines=true;}});});},"dijit/registry":function(){define(["dojo/_base/array","dojo/_base/window","./main"],function(_2ba,win,_2bb){var _2bc={},hash={};var _2bd={length:0,add:function(_2be){if(hash[_2be.id]){throw new Error("Tried to register widget with id=="+_2be.id+" but that id is already registered");}hash[_2be.id]=_2be;this.length++;},remove:function(id){if(hash[id]){delete hash[id];this.length--;}},byId:function(id){return typeof id=="string"?hash[id]:id;},byNode:function(node){return hash[node.getAttribute("widgetId")];},toArray:function(){var ar=[];for(var id in hash){ar.push(hash[id]);}return ar;},getUniqueId:function(_2bf){var id;do{id=_2bf+"_"+(_2bf in _2bc?++_2bc[_2bf]:_2bc[_2bf]=0);}while(hash[id]);return _2bb._scopeName=="dijit"?id:_2bb._scopeName+"_"+id;},findWidgets:function(root,_2c0){var _2c1=[];function _2c2(root){for(var node=root.firstChild;node;node=node.nextSibling){if(node.nodeType==1){var _2c3=node.getAttribute("widgetId");if(_2c3){var _2c4=hash[_2c3];if(_2c4){_2c1.push(_2c4);}}else{if(node!==_2c0){_2c2(node);}}}}};_2c2(root);return _2c1;},_destroyAll:function(){_2bb._curFocus=null;_2bb._prevFocus=null;_2bb._activeStack=[];_2ba.forEach(_2bd.findWidgets(win.body()),function(_2c5){if(!_2c5._destroyed){if(_2c5.destroyRecursive){_2c5.destroyRecursive();}else{if(_2c5.destroy){_2c5.destroy();}}}});},getEnclosingWidget:function(node){while(node){var id=node.nodeType==1&&node.getAttribute("widgetId");if(id){return hash[id];}node=node.parentNode;}return null;},_hash:hash};_2bb.registry=_2bd;return _2bd;});},"dijit/Destroyable":function(){define(["dojo/_base/array","dojo/aspect","dojo/_base/declare"],function(_2c6,_2c7,_2c8){return _2c8("dijit.Destroyable",null,{destroy:function(_2c9){this._destroyed=true;},own:function(){var _2ca=["destroyRecursive","destroy","remove"];_2c6.forEach(arguments,function(_2cb){var _2cc;var odh=_2c7.before(this,"destroy",function(_2cd){_2cb[_2cc](_2cd);});var hdhs=[];function _2ce(){odh.remove();_2c6.forEach(hdhs,function(hdh){hdh.remove();});};if(_2cb.then){_2cc="cancel";_2cb.then(_2ce,_2ce);}else{_2c6.forEach(_2ca,function(_2cf){if(typeof _2cb[_2cf]==="function"){if(!_2cc){_2cc=_2cf;}hdhs.push(_2c7.after(_2cb,_2cf,_2ce,true));}});}},this);return arguments;}});});},"dojox/charting/plot2d/StackedAreas":function(){define(["dojo/_base/declare","./Stacked"],function(_2d0,_2d1){return _2d0("dojox.charting.plot2d.StackedAreas",_2d1,{constructor:function(){this.opt.lines=true;this.opt.areas=true;}});});},"dijit/_base/manager":function(){define(["dojo/_base/array","dojo/_base/config","dojo/_base/lang","../registry","../main"],function(_2d2,_2d3,lang,_2d4,_2d5){var _2d6={};_2d2.forEach(["byId","getUniqueId","findWidgets","_destroyAll","byNode","getEnclosingWidget"],function(name){_2d6[name]=_2d4[name];});lang.mixin(_2d6,{defaultDuration:_2d3["defaultDuration"]||200});lang.mixin(_2d5,_2d6);return _2d5;});},"dojox/charting/plot2d/Stacked":function(){define(["dojo/_base/declare","./Default","./commonStacked"],function(_2d7,_2d8,_2d9){return _2d7("dojox.charting.plot2d.Stacked",_2d8,{getSeriesStats:function(){var _2da=_2d9.collectStats(this.series);return _2da;},buildSegments:function(i,_2db){var run=this.series[i],min=_2db?Math.max(0,Math.floor(this._hScaler.bounds.from-1)):0,max=_2db?Math.min(run.data.length-1,Math.ceil(this._hScaler.bounds.to)):run.data.length-1,rseg=null,_2dc=[];for(var j=min;j<=max;j++){var _2dd=_2db?_2d9.getIndexValue(this.series,i,j):_2d9.getValue(this.series,i,run.data[j]?run.data[j].x:null);if(_2dd[0]!=null&&(_2db||_2dd[0].y!=null)){if(!rseg){rseg=[];_2dc.push({index:j,rseg:rseg});}rseg.push(_2dd[0]);}else{if(!this.opt.interpolate||_2db){rseg=null;}}}return _2dc;}});});},"dojo/fx/easing":function(){define(["../_base/lang"],function(lang){var _2de={linear:function(n){return n;},quadIn:function(n){return Math.pow(n,2);},quadOut:function(n){return n*(n-2)*-1;},quadInOut:function(n){n=n*2;if(n<1){return Math.pow(n,2)/2;}return -1*((--n)*(n-2)-1)/2;},cubicIn:function(n){return Math.pow(n,3);},cubicOut:function(n){return Math.pow(n-1,3)+1;},cubicInOut:function(n){n=n*2;if(n<1){return Math.pow(n,3)/2;}n-=2;return (Math.pow(n,3)+2)/2;},quartIn:function(n){return Math.pow(n,4);},quartOut:function(n){return -1*(Math.pow(n-1,4)-1);},quartInOut:function(n){n=n*2;if(n<1){return Math.pow(n,4)/2;}n-=2;return -1/2*(Math.pow(n,4)-2);},quintIn:function(n){return Math.pow(n,5);},quintOut:function(n){return Math.pow(n-1,5)+1;},quintInOut:function(n){n=n*2;if(n<1){return Math.pow(n,5)/2;}n-=2;return (Math.pow(n,5)+2)/2;},sineIn:function(n){return -1*Math.cos(n*(Math.PI/2))+1;},sineOut:function(n){return Math.sin(n*(Math.PI/2));},sineInOut:function(n){return -1*(Math.cos(Math.PI*n)-1)/2;},expoIn:function(n){return (n==0)?0:Math.pow(2,10*(n-1));},expoOut:function(n){return (n==1)?1:(-1*Math.pow(2,-10*n)+1);},expoInOut:function(n){if(n==0){return 0;}if(n==1){return 1;}n=n*2;if(n<1){return Math.pow(2,10*(n-1))/2;}--n;return (-1*Math.pow(2,-10*n)+2)/2;},circIn:function(n){return -1*(Math.sqrt(1-Math.pow(n,2))-1);},circOut:function(n){n=n-1;return Math.sqrt(1-Math.pow(n,2));},circInOut:function(n){n=n*2;if(n<1){return -1/2*(Math.sqrt(1-Math.pow(n,2))-1);}n-=2;return 1/2*(Math.sqrt(1-Math.pow(n,2))+1);},backIn:function(n){var s=1.70158;return Math.pow(n,2)*((s+1)*n-s);},backOut:function(n){n=n-1;var s=1.70158;return Math.pow(n,2)*((s+1)*n+s)+1;},backInOut:function(n){var s=1.70158*1.525;n=n*2;if(n<1){return (Math.pow(n,2)*((s+1)*n-s))/2;}n-=2;return (Math.pow(n,2)*((s+1)*n+s)+2)/2;},elasticIn:function(n){if(n==0||n==1){return n;}var p=0.3;var s=p/4;n=n-1;return -1*Math.pow(2,10*n)*Math.sin((n-s)*(2*Math.PI)/p);},elasticOut:function(n){if(n==0||n==1){return n;}var p=0.3;var s=p/4;return Math.pow(2,-10*n)*Math.sin((n-s)*(2*Math.PI)/p)+1;},elasticInOut:function(n){if(n==0){return 0;}n=n*2;if(n==2){return 1;}var p=0.3*1.5;var s=p/4;if(n<1){n-=1;return -0.5*(Math.pow(2,10*n)*Math.sin((n-s)*(2*Math.PI)/p));}n-=1;return 0.5*(Math.pow(2,-10*n)*Math.sin((n-s)*(2*Math.PI)/p))+1;},bounceIn:function(n){return (1-_2de.bounceOut(1-n));},bounceOut:function(n){var s=7.5625;var p=2.75;var l;if(n<(1/p)){l=s*Math.pow(n,2);}else{if(n<(2/p)){n-=(1.5/p);l=s*Math.pow(n,2)+0.75;}else{if(n<(2.5/p)){n-=(2.25/p);l=s*Math.pow(n,2)+0.9375;}else{n-=(2.625/p);l=s*Math.pow(n,2)+0.984375;}}}return l;},bounceInOut:function(n){if(n<0.5){return _2de.bounceIn(n*2)/2;}return (_2de.bounceOut(n*2-1)/2)+0.5;}};lang.setObject("dojo.fx.easing",_2de);return _2de;});},"dojox/charting/action2d/Highlight":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/_base/Color","dojo/_base/connect","dojox/color/_base","./PlotAction","dojo/fx/easing","dojox/gfx/fx"],function(lang,_2df,_2e0,hub,c,_2e1,dfe,dgf){var _2e2=100,_2e3=75,_2e4=50,cc=function(_2e5){return function(){return _2e5;};},hl=function(_2e6){var a=new c.Color(_2e6),x=a.toHsl();if(x.s==0){x.l=x.l<50?100:0;}else{x.s=_2e2;if(x.l<_2e4){x.l=_2e3;}else{if(x.l>_2e3){x.l=_2e4;}else{x.l=x.l-_2e4>_2e3-x.l?_2e4:_2e3;}}}var _2e7=c.fromHsl(x);_2e7.a=a.a;return _2e7;},_2e8=function(_2e9){var r=hl(_2e9);r.a=0.7;return r;};return _2df("dojox.charting.action2d.Highlight",_2e1,{defaultParams:{duration:400,easing:dfe.backOut},optionalParams:{highlight:"red"},constructor:function(_2ea,plot,_2eb){var a=_2eb&&_2eb.highlight;this.colorFunc=a?(lang.isFunction(a)?a:cc(a)):hl;this.connect();},process:function(o){if(!o.shape||!(o.type in this.overOutEvents)){return;}if(o.element=="spider_circle"||o.element=="spider_plot"){return;}else{if(o.element=="spider_poly"&&this.colorFunc==hl){this.colorFunc=_2e8;}}var _2ec=o.run.name,_2ed=o.index,anim;if(_2ec in this.anim){anim=this.anim[_2ec][_2ed];}else{this.anim[_2ec]={};}if(anim){anim.action.stop(true);}else{var _2ee=o.shape.getFill();if(!_2ee||!(_2ee instanceof _2e0)){return;}this.anim[_2ec][_2ed]=anim={start:_2ee,end:this.colorFunc(_2ee)};}var _2ef=anim.start,end=anim.end;if(o.type=="onmouseout"){var t=_2ef;_2ef=end;end=t;}anim.action=dgf.animateFill({shape:o.shape,duration:this.duration,easing:this.easing,color:{start:_2ef,end:end}});if(o.type=="onmouseout"){hub.connect(anim.action,"onEnd",this,function(){if(this.anim[_2ec]){delete this.anim[_2ec][_2ed];}});}anim.action.play();}});});},"dojox/charting/axis2d/Base":function(){define(["dojo/_base/declare","../Element"],function(_2f0,_2f1){return _2f0("dojox.charting.axis2d.Base",_2f1,{constructor:function(_2f2,_2f3){this.vertical=_2f3&&_2f3.vertical;this.opt={};this.opt.min=_2f3&&_2f3.min;this.opt.max=_2f3&&_2f3.max;},clear:function(){return this;},initialized:function(){return false;},calculate:function(min,max,span){return this;},getScaler:function(){return null;},getTicks:function(){return null;},getOffsets:function(){return {l:0,r:0,t:0,b:0};},render:function(dim,_2f4){this.dirty=false;return this;}});});},"dojox/charting/plot2d/Grid":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/_base/array","dojo/sniff","./CartesianBase","./common","dojox/lang/utils","dojox/gfx/fx"],function(lang,_2f5,arr,has,_2f6,dc,du,fx){var _2f7=function(a,b){return a.value-b.value;};return _2f5("dojox.charting.plot2d.Grid",_2f6,{defaultParams:{hMajorLines:true,hMinorLines:false,vMajorLines:true,vMinorLines:false,hStripes:false,vStripes:false,animate:null,enableCache:false,renderOnAxis:true},optionalParams:{majorHLine:{},minorHLine:{},majorVLine:{},minorVLine:{},hFill:{},vFill:{},hAlternateFill:{},vAlternateFill:{}},constructor:function(_2f8,_2f9){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_2f9);du.updateWithPattern(this.opt,_2f9,this.optionalParams);this.animate=this.opt.animate;if(this.opt.enableCache){this._lineFreePool=[];this._lineUsePool=[];this._rectFreePool=[];this._rectUsePool=[];}},addSeries:function(run){return this;},getSeriesStats:function(){return lang.delegate(dc.defaultStats);},cleanGroup:function(){this.inherited(arguments);if(this.opt.enableCache){this._lineFreePool=this._lineFreePool.concat(this._lineUsePool);this._lineUsePool=[];this._rectFreePool=this._rectFreePool.concat(this._rectUsePool);this._rectUsePool=[];}},createLine:function(_2fa,_2fb){var line;if(this.opt.enableCache&&this._lineFreePool.length>0){line=this._lineFreePool.pop();line.setShape(_2fb);_2fa.add(line);}else{line=_2fa.createLine(_2fb);}if(this.opt.enableCache){this._lineUsePool.push(line);}return line;},createRect:function(_2fc,_2fd){var rect;if(this.opt.enableCache&&this._rectFreePool.length>0){rect=this._rectFreePool.pop();rect.setShape(_2fd);_2fc.add(rect);}else{rect=_2fc.createRect(_2fd);}if(this.opt.enableCache){this._rectUsePool.push(rect);}return rect;},render:function(dim,_2fe){if(this.zoom){return this.performZoom(dim,_2fe);}this.dirty=this.isDirty();if(!this.dirty){return this;}this.cleanGroup();var s=this.getGroup(),ta=this.chart.theme,_2ff,_300;if((has("ios")&&has("ios")<6)||has("android")||(has("safari")&&!has("ios"))){var w=Math.max(0,dim.width-_2fe.l-_2fe.r),h=Math.max(0,dim.height-_2fe.t-_2fe.b);s.createRect({x:_2fe.l,y:_2fe.t,width:w,height:h});}if(this._vAxis){_300=this._vAxis.getTicks();var _301=this._vAxis.getScaler();if(_300!=null&&_301!=null){var vt=_301.scaler.getTransformerFromModel(_301);if(this.opt.hStripes){this._renderHRect(_300,ta.grid,dim,_2fe,_301,vt);}if(this.opt.hMinorLines){_2ff=this.opt.minorHLine||(ta.grid&&ta.grid.minorLine)||ta.axis.minorTick;this._renderHLines(_300.minor,_2ff,dim,_2fe,_301,vt);}if(this.opt.hMajorLines){_2ff=this.opt.majorHLine||(ta.grid&&ta.grid.majorLine)||ta.axis.majorTick;this._renderHLines(_300.major,_2ff,dim,_2fe,_301,vt);}}}if(this._hAxis){_300=this._hAxis.getTicks();var _302=this._hAxis.getScaler();if(_300!=null&&_302!=null){var ht=_302.scaler.getTransformerFromModel(_302);if(this.opt.vStripes){this._renderVRect(_300,ta.grid,dim,_2fe,_302,ht);}if(_300&&this.opt.vMinorLines){_2ff=this.opt.minorVLine||(ta.grid&&ta.grid.minorLine)||ta.axis.minorTick;this._renderVLines(_300.minor,_2ff,dim,_2fe,_302,ht);}if(_300&&this.opt.vMajorLines){_2ff=this.opt.majorVLine||(ta.grid&&ta.grid.majorLine)||ta.axis.majorTick;this._renderVLines(_300.major,_2ff,dim,_2fe,_302,ht);}}}this.dirty=false;return this;},_renderHLines:function(_303,_304,dim,_305,_306,vt){var s=this.getGroup();arr.forEach(_303,function(tick){if(!this.opt.renderOnAxis&&tick.value==(this._vAxis.opt.leftBottom?_306.bounds.from:_306.bounds.to)){return;}var y=dim.height-_305.b-vt(tick.value);var _307=this.createLine(s,{x1:_305.l,y1:y,x2:dim.width-_305.r,y2:y}).setStroke(_304);if(this.animate){this._animateGrid(_307,"h",_305.l,_305.r+_305.l-dim.width);}},this);},_renderVLines:function(_308,_309,dim,_30a,_30b,ht){var s=this.getGroup();arr.forEach(_308,function(tick){if(!this.opt.renderOnAxis&&tick.value==(this._hAxis.opt.leftBottom?_30b.bounds.from:_30b.bounds.to)){return;}var x=_30a.l+ht(tick.value);var _30c=this.createLine(s,{x1:x,y1:_30a.t,x2:x,y2:dim.height-_30a.b}).setStroke(_309);if(this.animate){this._animateGrid(_30c,"v",dim.height-_30a.b,dim.height-_30a.b-_30a.t);}},this);},_renderHRect:function(_30d,_30e,dim,_30f,_310,vt){var fill,tick,y,y2,_311;var _312=_30d.major.concat(_30d.minor);_312.sort(_2f7);if(_312[0].value>_310.bounds.from){_312.splice(0,0,{value:_310.bounds.from});}if(_312[_312.length-1].value<_310.bounds.to){_312.push({value:_310.bounds.to});}var s=this.getGroup();for(var j=0;j<_312.length-1;j++){tick=_312[j];y=dim.height-_30f.b-vt(tick.value);y2=dim.height-_30f.b-vt(_312[j+1].value);fill=(j%2==0)?(this.opt.hAlternateFill||(_30e&&_30e.alternateFill)):(this.opt.hFill||(_30e&&_30e.fill));if(fill){_311=this.createRect(s,{x:_30f.l,y:y,width:dim.width-_30f.r,height:y-y2}).setFill(fill);if(this.animate){this._animateGrid(_311,"h",_30f.l,_30f.r+_30f.l-dim.width);}}}},_renderVRect:function(_313,_314,dim,_315,_316,ht){var fill,tick,x,x2,_317;var _318=_313.major.concat(_313.minor);_318.sort(_2f7);if(_318[0].value>_316.bounds.from){_318.splice(0,0,{value:_316.bounds.from});}if(_318[_318.length-1].value<_316.bounds.to){_318.push({value:_316.bounds.to});}var s=this.getGroup();for(var j=0;j<_318.length-1;j++){tick=_318[j];x=_315.l+ht(tick.value);x2=_315.l+ht(_318[j+1].value);fill=(j%2==0)?(this.opt.vAlternateFill||(_314&&_314.alternateFill)):(this.opt.vFill||(_314&&_314.fill));if(fill){_317=this.createRect(s,{x:x,y:_315.t,width:x2-x,height:dim.width-_315.r}).setFill(fill);if(this.animate){this._animateGrid(_317,"v",dim.height-_315.b,dim.height-_315.b-_315.t);}}}},_animateGrid:function(_319,type,_31a,size){var _31b=type=="h"?[_31a,0]:[0,_31a];var _31c=type=="h"?[1/size,1]:[1,1/size];fx.animateTransform(lang.delegate({shape:_319,duration:1200,transform:[{name:"translate",start:_31b,end:[0,0]},{name:"scale",start:_31c,end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dijit/a11y":function(){define(["dojo/_base/array","dojo/dom","dojo/dom-attr","dojo/dom-style","dojo/_base/lang","dojo/sniff","./main"],function(_31d,dom,_31e,_31f,lang,has,_320){var _321;var a11y={_isElementShown:function(elem){var s=_31f.get(elem);return (s.visibility!="hidden")&&(s.visibility!="collapsed")&&(s.display!="none")&&(_31e.get(elem,"type")!="hidden");},hasDefaultTabStop:function(elem){switch(elem.nodeName.toLowerCase()){case "a":return _31e.has(elem,"href");case "area":case "button":case "input":case "object":case "select":case "textarea":return true;case "iframe":var body;try{var _322=elem.contentDocument;if("designMode" in _322&&_322.designMode=="on"){return true;}body=_322.body;}catch(e1){try{body=elem.contentWindow.document.body;}catch(e2){return false;}}return body&&(body.contentEditable=="true"||(body.firstChild&&body.firstChild.contentEditable=="true"));default:return elem.contentEditable=="true";}},effectiveTabIndex:function(elem){if(_31e.get(elem,"disabled")){return _321;}else{if(_31e.has(elem,"tabIndex")){return +_31e.get(elem,"tabIndex");}else{return a11y.hasDefaultTabStop(elem)?0:_321;}}},isTabNavigable:function(elem){return a11y.effectiveTabIndex(elem)>=0;},isFocusable:function(elem){return a11y.effectiveTabIndex(elem)>=-1;},_getTabNavigable:function(root){var _323,last,_324,_325,_326,_327,_328={};function _329(node){return node&&node.tagName.toLowerCase()=="input"&&node.type&&node.type.toLowerCase()=="radio"&&node.name&&node.name.toLowerCase();};var _32a=a11y._isElementShown,_32b=a11y.effectiveTabIndex;var _32c=function(_32d){for(var _32e=_32d.firstChild;_32e;_32e=_32e.nextSibling){if(_32e.nodeType!=1||(has("ie")<=9&&_32e.scopeName!=="HTML")||!_32a(_32e)){continue;}var _32f=_32b(_32e);if(_32f>=0){if(_32f==0){if(!_323){_323=_32e;}last=_32e;}else{if(_32f>0){if(!_324||_32f<_325){_325=_32f;_324=_32e;}if(!_326||_32f>=_327){_327=_32f;_326=_32e;}}}var rn=_329(_32e);if(_31e.get(_32e,"checked")&&rn){_328[rn]=_32e;}}if(_32e.nodeName.toUpperCase()!="SELECT"){_32c(_32e);}}};if(_32a(root)){_32c(root);}function rs(node){return _328[_329(node)]||node;};return {first:rs(_323),last:rs(last),lowest:rs(_324),highest:rs(_326)};},getFirstInTabbingOrder:function(root,doc){var _330=a11y._getTabNavigable(dom.byId(root,doc));return _330.lowest?_330.lowest:_330.first;},getLastInTabbingOrder:function(root,doc){var _331=a11y._getTabNavigable(dom.byId(root,doc));return _331.last?_331.last:_331.highest;}};1&&lang.mixin(_320,a11y);return a11y;});},"dojox/lang/functional/fold":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/kernel","./lambda"],function(lang,arr,_332,df){var _333={};lang.mixin(df,{foldl:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||_332.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();z=f.call(o,z,a.next(),i++,a)){}}else{for(i in a){if(!(i in _333)){z=f.call(o,z,a[i],i,a);}}}}return z;},foldl1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_332.global;f=df.lambda(f);var z,i,n;if(lang.isArray(a)){z=a[0];for(i=1,n=a.length;i<n;z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){if(a.hasNext()){z=a.next();for(i=1;a.hasNext();z=f.call(o,z,a.next(),i++,a)){}}}else{var _334=true;for(i in a){if(!(i in _333)){if(_334){z=a[i];_334=false;}else{z=f.call(o,z,a[i],i,a);}}}}}return z;},foldr:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||_332.global;f=df.lambda(f);for(var i=a.length;i>0;--i,z=f.call(o,z,a[i],i,a)){}return z;},foldr1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_332.global;f=df.lambda(f);var n=a.length,z=a[n-1],i=n-1;for(;i>0;--i,z=f.call(o,z,a[i],i,a)){}return z;},reduce:function(a,f,z){return arguments.length<3?df.foldl1(a,f):df.foldl(a,f,z);},reduceRight:function(a,f,z){return arguments.length<3?df.foldr1(a,f):df.foldr(a,f,z);},unfold:function(pr,f,g,z,o){o=o||_332.global;f=df.lambda(f);g=df.lambda(g);pr=df.lambda(pr);var t=[];for(;!pr.call(o,z);t.push(f.call(o,z)),z=g.call(o,z)){}return t;}});});},"dojox/charting/plot2d/Spider":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/_base/connect","dojo/_base/array","dojo/dom-geometry","dojo/_base/fx","dojo/fx","dojo/sniff","./Base","./_PlotEvents","./common","../axis2d/common","dojox/gfx","dojox/gfx/matrix","dojox/gfx/fx","dojox/lang/functional","dojox/lang/utils","dojo/fx/easing"],function(lang,_335,hub,arr,_336,_337,_338,has,Base,_339,dc,da,g,m,_33a,df,du,_33b){var _33c=0.2;var _33d=_335("dojox.charting.plot2d.Spider",[Base,_339],{defaultParams:{labels:true,ticks:false,fixed:true,precision:1,labelOffset:-10,labelStyle:"default",htmlLabels:true,startAngle:-90,divisions:3,axisColor:"",axisWidth:0,spiderColor:"",spiderWidth:0,seriesWidth:0,seriesFillAlpha:0.2,spiderOrigin:0.16,markerSize:3,spiderType:"polygon",animationType:_33b.backOut,animate:null,axisTickFont:"",axisTickFontColor:"",axisFont:"",axisFontColor:""},optionalParams:{radius:0,font:"",fontColor:""},constructor:function(_33e,_33f){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_33f);du.updateWithPattern(this.opt,_33f,this.optionalParams);this.dyn=[];this.datas={};this.labelKey=[];this.oldSeriePoints={};this.animate=this.opt.animate===null?{}:this.opt.animate;this.animations={};},clear:function(){this.inherited(arguments);this.dyn=[];this.axes=[];this.datas={};this.labelKey=[];this.oldSeriePoints={};this.animations={};return this;},setAxis:function(axis){if(axis){if(axis.opt.min!=undefined){this.datas[axis.name].min=axis.opt.min;}if(axis.opt.max!=undefined){this.datas[axis.name].max=axis.opt.max;}}return this;},addSeries:function(run){this.series.push(run);var key;for(key in run.data){var val=run.data[key],data=this.datas[key];if(data){data.vlist.push(val);data.min=Math.min(data.min,val);data.max=Math.max(data.max,val);}else{var _340="__"+key;this.axes.push(_340);this[_340]=key;this.datas[key]={min:val,max:val,vlist:[val]};}}if(this.labelKey.length<=0){for(key in run.data){this.labelKey.push(key);}}return this;},getSeriesStats:function(){return dc.collectSimpleStats(this.series);},render:function(dim,_341){if(!this.dirty){return this;}this.dirty=false;this.cleanGroup();var s=this.group,t=this.chart.theme;this.resetEvents();if(!this.series||!this.series.length){return this;}var o=this.opt,ta=t.axis,rx=(dim.width-_341.l-_341.r)/2,ry=(dim.height-_341.t-_341.b)/2,r=Math.min(rx,ry),_342=o.font||(ta.majorTick&&ta.majorTick.font)||(ta.tick&&ta.tick.font)||"normal normal normal 7pt Tahoma",_343=o.axisFont||(ta.tick&&ta.tick.titleFont)||"normal normal normal 11pt Tahoma",_344=o.axisTickFontColor||(ta.majorTick&&ta.majorTick.fontColor)||(ta.tick&&ta.tick.fontColor)||"silver",_345=o.axisFontColor||(ta.tick&&ta.tick.titleFontColor)||"black",_346=o.axisColor||(ta.tick&&ta.tick.axisColor)||"silver",_347=o.spiderColor||(ta.tick&&ta.tick.spiderColor)||"silver",_348=o.axisWidth||(ta.stroke&&ta.stroke.width)||2,_349=o.spiderWidth||(ta.stroke&&ta.stroke.width)||2,_34a=o.seriesWidth||(ta.stroke&&ta.stroke.width)||2,_34b=g.normalizedLength(g.splitFontString(_343).size),_34c=m._degToRad(o.startAngle),_34d=_34c,_34e,_34f,_350,_351,_352,_353,_354,_355,ro=o.spiderOrigin,dv=o.divisions>=3?o.divisions:3,ms=o.markerSize,spt=o.spiderType,at=o.animationType,_356=o.labelOffset<-10?o.labelOffset:-10,_357=0.2,i,j,_358,len,_359,_35a,_35b,run,data,min,max,_35c;if(o.labels){_34e=arr.map(this.series,function(s){return s.name;},this);_34f=df.foldl1(df.map(_34e,function(_35d){var font=t.series.font;return g._base._getTextBox(_35d,{font:font}).w;},this),"Math.max(a, b)")/2;r=Math.min(rx-2*_34f,ry-_34b)+_356;_350=r-_356;}if("radius" in o){r=o.radius;_350=r-_356;}r/=(1+_357);var _35e={cx:_341.l+rx,cy:_341.t+ry,r:r};for(i=this.series.length-1;i>=0;i--){_35b=this.series[i];if(!this.dirty&&!_35b.dirty){t.skip();continue;}_35b.cleanGroup();run=_35b.data;if(run!==null){len=this._getObjectLength(run);if(!_351||_351.length<=0){_351=[],_352=[],_355=[];this._buildPoints(_351,len,_35e,r,_34d,true,dim);this._buildPoints(_352,len,_35e,r*ro,_34d,true,dim);this._buildPoints(_355,len,_35e,_350,_34d,false,dim);if(dv>2){_353=[],_354=[];for(j=0;j<dv-2;j++){_353[j]=[];this._buildPoints(_353[j],len,_35e,r*(ro+(1-ro)*(j+1)/(dv-1)),_34d,true,dim);_354[j]=r*(ro+(1-ro)*(j+1)/(dv-1));}}}}}var _35f=s.createGroup(),_360={color:_346,width:_348},_361={color:_347,width:_349};for(j=_351.length-1;j>=0;--j){_358=_351[j];var st={x:_358.x+(_358.x-_35e.cx)*_357,y:_358.y+(_358.y-_35e.cy)*_357},nd={x:_358.x+(_358.x-_35e.cx)*_357/2,y:_358.y+(_358.y-_35e.cy)*_357/2};_35f.createLine({x1:_35e.cx,y1:_35e.cy,x2:st.x,y2:st.y}).setStroke(_360);this._drawArrow(_35f,st,nd,_360);}var _362=s.createGroup();for(j=_355.length-1;j>=0;--j){_358=_355[j];_359=g._base._getTextBox(this.labelKey[j],{font:_343}).w||0;_35a=this.opt.htmlLabels&&g.renderer!="vml"?"html":"gfx";var elem=da.createText[_35a](this.chart,_362,(!_336.isBodyLtr()&&_35a=="html")?(_358.x+_359-dim.width):_358.x,_358.y,"middle",this.labelKey[j],_343,_345);if(this.opt.htmlLabels){this.htmlElements.push(elem);}}var _363=s.createGroup();if(spt=="polygon"){_363.createPolyline(_351).setStroke(_361);_363.createPolyline(_352).setStroke(_361);if(_353.length>0){for(j=_353.length-1;j>=0;--j){_363.createPolyline(_353[j]).setStroke(_361);}}}else{_363.createCircle({cx:_35e.cx,cy:_35e.cy,r:r}).setStroke(_361);_363.createCircle({cx:_35e.cx,cy:_35e.cy,r:r*ro}).setStroke(_361);if(_354.length>0){for(j=_354.length-1;j>=0;--j){_363.createCircle({cx:_35e.cx,cy:_35e.cy,r:_354[j]}).setStroke(_361);}}}len=this._getObjectLength(this.datas);var _364=s.createGroup(),k=0;for(var key in this.datas){data=this.datas[key];min=data.min;max=data.max;_35c=max-min;end=_34d+2*Math.PI*k/len;for(i=0;i<dv;i++){var text=min+_35c*i/(dv-1);_358=this._getCoordinate(_35e,r*(ro+(1-ro)*i/(dv-1)),end,dim);text=this._getLabel(text);_359=g._base._getTextBox(text,{font:_342}).w||0;_35a=this.opt.htmlLabels&&g.renderer!="vml"?"html":"gfx";if(this.opt.htmlLabels){this.htmlElements.push(da.createText[_35a](this.chart,_364,(!_336.isBodyLtr()&&_35a=="html")?(_358.x+_359-dim.width):_358.x,_358.y,"start",text,_342,_344));}}k++;}this.chart.seriesShapes={};for(i=this.series.length-1;i>=0;i--){_35b=this.series[i];run=_35b.data;if(run!==null){var _365=t.next("spider",[o,_35b]),f=g.normalizeColor(_365.series.fill),sk={color:_365.series.fill,width:_34a};f.a=o.seriesFillAlpha;_35b.dyn={fill:f,stroke:sk};if(_35b.hidden){continue;}var _366=[],_367=[];k=0;for(key in run){data=this.datas[key];min=data.min;max=data.max;_35c=max-min;var _368=run[key],end=_34d+2*Math.PI*k/len;_358=this._getCoordinate(_35e,r*(ro+(1-ro)*(_368-min)/_35c),end,dim);_366.push(_358);_367.push({sname:_35b.name,key:key,data:_368});k++;}_366[_366.length]=_366[0];_367[_367.length]=_367[0];var _369=this._getBoundary(_366),ts=_35b.group;var osps=this.oldSeriePoints[_35b.name];var cs=this._createSeriesEntry(ts,(osps||_352),_366,f,sk,r,ro,ms,at);this.chart.seriesShapes[_35b.name]=cs;this.oldSeriePoints[_35b.name]=_366;var po={element:"spider_poly",index:i,id:"spider_poly_"+_35b.name,run:_35b,plot:this,shape:cs.poly,parent:ts,brect:_369,cx:_35e.cx,cy:_35e.cy,cr:r,f:f,s:s};this._connectEvents(po);var so={element:"spider_plot",index:i,id:"spider_plot_"+_35b.name,run:_35b,plot:this,shape:_35b.group};this._connectEvents(so);arr.forEach(cs.circles,function(c,i){var co={element:"spider_circle",index:i,id:"spider_circle_"+_35b.name+i,run:_35b,plot:this,shape:c,parent:ts,tdata:_367[i],cx:_366[i].x,cy:_366[i].y,f:f,s:s};this._connectEvents(co);},this);}}return this;},_createSeriesEntry:function(ts,osps,sps,f,sk,r,ro,ms,at){var _36a=this.animate?osps:sps;var _36b=ts.createPolyline(_36a).setFill(f).setStroke(sk),_36c=[];for(var j=0;j<_36a.length;j++){var _36d=_36a[j],cr=ms;var _36e=ts.createCircle({cx:_36d.x,cy:_36d.y,r:cr}).setFill(f).setStroke(sk);_36c.push(_36e);}if(this.animate){var _36f=arr.map(sps,function(np,j){var sp=osps[j],anim=new _337.Animation(lang.delegate({duration:1000,easing:at,curve:[sp.y,np.y]},this.animate));var spl=_36b,sc=_36c[j];hub.connect(anim,"onAnimate",function(y){var _370=spl.getShape();_370.points[j].y=y;spl.setShape(_370);var _371=sc.getShape();_371.cy=y;sc.setShape(_371);});return anim;},this);var _372=arr.map(sps,function(np,j){var sp=osps[j],anim=new _337.Animation(lang.delegate({duration:1000,easing:at,curve:[sp.x,np.x]},this.animate));var spl=_36b,sc=_36c[j];hub.connect(anim,"onAnimate",function(x){var _373=spl.getShape();_373.points[j].x=x;spl.setShape(_373);var _374=sc.getShape();_374.cx=x;sc.setShape(_374);});return anim;},this);var _375=_338.combine(_36f.concat(_372));_375.play();}return {group:ts,poly:_36b,circles:_36c};},plotEvent:function(o){if(o.element=="spider_plot"){if(o.type=="onmouseover"&&!has("ie")){o.shape.moveToFront();}}},tooltipFunc:function(o){if(o.element=="spider_circle"){return o.tdata.sname+"<br/>"+o.tdata.key+"<br/>"+o.tdata.data;}else{return null;}},_getBoundary:function(_376){var xmax=_376[0].x,xmin=_376[0].x,ymax=_376[0].y,ymin=_376[0].y;for(var i=0;i<_376.length;i++){var _377=_376[i];xmax=Math.max(_377.x,xmax);ymax=Math.max(_377.y,ymax);xmin=Math.min(_377.x,xmin);ymin=Math.min(_377.y,ymin);}return {x:xmin,y:ymin,width:xmax-xmin,height:ymax-ymin};},_drawArrow:function(s,_378,end,_379){var len=Math.sqrt(Math.pow(end.x-_378.x,2)+Math.pow(end.y-_378.y,2)),sin=(end.y-_378.y)/len,cos=(end.x-_378.x)/len,_37a={x:end.x+(len/3)*(-sin),y:end.y+(len/3)*cos},_37b={x:end.x+(len/3)*sin,y:end.y+(len/3)*(-cos)};s.createPolyline([_378,_37a,_37b]).setFill(_379.color).setStroke(_379);},_buildPoints:function(_37c,_37d,_37e,_37f,_380,_381,dim){for(var i=0;i<_37d;i++){var end=_380+2*Math.PI*i/_37d;_37c.push(this._getCoordinate(_37e,_37f,end,dim));}if(_381){_37c.push(this._getCoordinate(_37e,_37f,_380+2*Math.PI,dim));}},_getCoordinate:function(_382,_383,_384,dim){var x=_382.cx+_383*Math.cos(_384);if(has("dojo-bidi")&&this.chart.isRightToLeft()&&dim){x=dim.width-x;}return {x:x,y:_382.cy+_383*Math.sin(_384)};},_getObjectLength:function(obj){var _385=0;if(lang.isObject(obj)){for(var key in obj){_385++;}}return _385;},_getLabel:function(_386){return dc.getLabel(_386,this.opt.fixed,this.opt.precision);}});return _33d;});},"dojox/charting/plot2d/StackedBars":function(){define(["dojo/_base/declare","./Bars","./commonStacked"],function(_387,Bars,_388){return _387("dojox.charting.plot2d.StackedBars",Bars,{getSeriesStats:function(){var _389=_388.collectStats(this.series),t;_389.hmin-=0.5;_389.hmax+=0.5;t=_389.hmin,_389.hmin=_389.vmin,_389.vmin=t;t=_389.hmax,_389.hmax=_389.vmax,_389.vmax=t;return _389;},getValue:function(_38a,_38b,_38c,_38d){var y,x;if(_38d){x=_38b;y=_388.getIndexValue(this.series,_38c,x);}else{x=_38a.x-1;y=_388.getValue(this.series,_38c,_38a.x);y=[y[0]?y[0].y:null,y[1]?y[1]:null];}return {x:x,y:y[0],py:y[1]};}});});},"dojox/charting/themes/GreySkies":function(){define(["../SimpleTheme","./common"],function(_38e,_38f){_38f.GreySkies=new _38e();return _38f.GreySkies;});},"dijit/place":function(){define(["dojo/_base/array","dojo/dom-geometry","dojo/dom-style","dojo/_base/kernel","dojo/_base/window","./Viewport","./main"],function(_390,_391,_392,_393,win,_394,_395){function _396(node,_397,_398,_399){var view=_394.getEffectiveBox(node.ownerDocument);if(!node.parentNode||String(node.parentNode.tagName).toLowerCase()!="body"){win.body(node.ownerDocument).appendChild(node);}var best=null;_390.some(_397,function(_39a){var _39b=_39a.corner;var pos=_39a.pos;var _39c=0;var _39d={w:{"L":view.l+view.w-pos.x,"R":pos.x-view.l,"M":view.w}[_39b.charAt(1)],h:{"T":view.t+view.h-pos.y,"B":pos.y-view.t,"M":view.h}[_39b.charAt(0)]};var s=node.style;s.left=s.right="auto";if(_398){var res=_398(node,_39a.aroundCorner,_39b,_39d,_399);_39c=typeof res=="undefined"?0:res;}var _39e=node.style;var _39f=_39e.display;var _3a0=_39e.visibility;if(_39e.display=="none"){_39e.visibility="hidden";_39e.display="";}var bb=_391.position(node);_39e.display=_39f;_39e.visibility=_3a0;var _3a1={"L":pos.x,"R":pos.x-bb.w,"M":Math.max(view.l,Math.min(view.l+view.w,pos.x+(bb.w>>1))-bb.w)}[_39b.charAt(1)],_3a2={"T":pos.y,"B":pos.y-bb.h,"M":Math.max(view.t,Math.min(view.t+view.h,pos.y+(bb.h>>1))-bb.h)}[_39b.charAt(0)],_3a3=Math.max(view.l,_3a1),_3a4=Math.max(view.t,_3a2),endX=Math.min(view.l+view.w,_3a1+bb.w),endY=Math.min(view.t+view.h,_3a2+bb.h),_3a5=endX-_3a3,_3a6=endY-_3a4;_39c+=(bb.w-_3a5)+(bb.h-_3a6);if(best==null||_39c<best.overflow){best={corner:_39b,aroundCorner:_39a.aroundCorner,x:_3a3,y:_3a4,w:_3a5,h:_3a6,overflow:_39c,spaceAvailable:_39d};}return !_39c;});if(best.overflow&&_398){_398(node,best.aroundCorner,best.corner,best.spaceAvailable,_399);}var top=best.y,side=best.x,body=win.body(node.ownerDocument);if(/relative|absolute/.test(_392.get(body,"position"))){top-=_392.get(body,"marginTop");side-=_392.get(body,"marginLeft");}var s=node.style;s.top=top+"px";s.left=side+"px";s.right="auto";return best;};var _3a7={"TL":"BR","TR":"BL","BL":"TR","BR":"TL"};var _3a8={at:function(node,pos,_3a9,_3aa,_3ab){var _3ac=_390.map(_3a9,function(_3ad){var c={corner:_3ad,aroundCorner:_3a7[_3ad],pos:{x:pos.x,y:pos.y}};if(_3aa){c.pos.x+=_3ad.charAt(1)=="L"?_3aa.x:-_3aa.x;c.pos.y+=_3ad.charAt(0)=="T"?_3aa.y:-_3aa.y;}return c;});return _396(node,_3ac,_3ab);},around:function(node,_3ae,_3af,_3b0,_3b1){var _3b2;if(typeof _3ae=="string"||"offsetWidth" in _3ae||"ownerSVGElement" in _3ae){_3b2=_391.position(_3ae,true);if(/^(above|below)/.test(_3af[0])){var _3b3=_391.getBorderExtents(_3ae),_3b4=_3ae.firstChild?_391.getBorderExtents(_3ae.firstChild):{t:0,l:0,b:0,r:0},_3b5=_391.getBorderExtents(node),_3b6=node.firstChild?_391.getBorderExtents(node.firstChild):{t:0,l:0,b:0,r:0};_3b2.y+=Math.min(_3b3.t+_3b4.t,_3b5.t+_3b6.t);_3b2.h-=Math.min(_3b3.t+_3b4.t,_3b5.t+_3b6.t)+Math.min(_3b3.b+_3b4.b,_3b5.b+_3b6.b);}}else{_3b2=_3ae;}if(_3ae.parentNode){var _3b7=_392.getComputedStyle(_3ae).position=="absolute";var _3b8=_3ae.parentNode;while(_3b8&&_3b8.nodeType==1&&_3b8.nodeName!="BODY"){var _3b9=_391.position(_3b8,true),pcs=_392.getComputedStyle(_3b8);if(/relative|absolute/.test(pcs.position)){_3b7=false;}if(!_3b7&&/hidden|auto|scroll/.test(pcs.overflow)){var _3ba=Math.min(_3b2.y+_3b2.h,_3b9.y+_3b9.h);var _3bb=Math.min(_3b2.x+_3b2.w,_3b9.x+_3b9.w);_3b2.x=Math.max(_3b2.x,_3b9.x);_3b2.y=Math.max(_3b2.y,_3b9.y);_3b2.h=_3ba-_3b2.y;_3b2.w=_3bb-_3b2.x;}if(pcs.position=="absolute"){_3b7=true;}_3b8=_3b8.parentNode;}}var x=_3b2.x,y=_3b2.y,_3bc="w" in _3b2?_3b2.w:(_3b2.w=_3b2.width),_3bd="h" in _3b2?_3b2.h:(_393.deprecated("place.around: dijit/place.__Rectangle: { x:"+x+", y:"+y+", height:"+_3b2.height+", width:"+_3bc+" } has been deprecated.  Please use { x:"+x+", y:"+y+", h:"+_3b2.height+", w:"+_3bc+" }","","2.0"),_3b2.h=_3b2.height);var _3be=[];function push(_3bf,_3c0){_3be.push({aroundCorner:_3bf,corner:_3c0,pos:{x:{"L":x,"R":x+_3bc,"M":x+(_3bc>>1)}[_3bf.charAt(1)],y:{"T":y,"B":y+_3bd,"M":y+(_3bd>>1)}[_3bf.charAt(0)]}});};_390.forEach(_3af,function(pos){var ltr=_3b0;switch(pos){case "above-centered":push("TM","BM");break;case "below-centered":push("BM","TM");break;case "after-centered":ltr=!ltr;case "before-centered":push(ltr?"ML":"MR",ltr?"MR":"ML");break;case "after":ltr=!ltr;case "before":push(ltr?"TL":"TR",ltr?"TR":"TL");push(ltr?"BL":"BR",ltr?"BR":"BL");break;case "below-alt":ltr=!ltr;case "below":push(ltr?"BL":"BR",ltr?"TL":"TR");push(ltr?"BR":"BL",ltr?"TR":"TL");break;case "above-alt":ltr=!ltr;case "above":push(ltr?"TL":"TR",ltr?"BL":"BR");push(ltr?"TR":"TL",ltr?"BR":"BL");break;default:push(pos.aroundCorner,pos.corner);}});var _3c1=_396(node,_3be,_3b1,{w:_3bc,h:_3bd});_3c1.aroundNodePos=_3b2;return _3c1;}};return _395.place=_3a8;});},"dojox/charting/plot2d/Columns":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/has","./CartesianBase","./_PlotEvents","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx"],function(lang,arr,_3c2,has,_3c3,_3c4,dc,df,dfr,du,fx){var _3c5=dfr.lambda("item.purgeGroup()");return _3c2("dojox.charting.plot2d.Columns",[_3c3,_3c4],{defaultParams:{gap:0,animate:null,enableCache:false},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},filter:{},styleFunc:null,font:"",fontColor:""},constructor:function(_3c6,_3c7){this.opt=lang.clone(lang.mixin(this.opt,this.defaultParams));du.updateWithObject(this.opt,_3c7);du.updateWithPattern(this.opt,_3c7,this.optionalParams);this.animate=this.opt.animate;this.renderingOptions={"shape-rendering":"crispEdges"};},getSeriesStats:function(){var _3c8=dc.collectSimpleStats(this.series);_3c8.hmin-=0.5;_3c8.hmax+=0.5;return _3c8;},createRect:function(run,_3c9,_3ca){var rect;if(this.opt.enableCache&&run._rectFreePool.length>0){rect=run._rectFreePool.pop();rect.setShape(_3ca);_3c9.add(rect);}else{rect=_3c9.createRect(_3ca);}if(this.opt.enableCache){run._rectUsePool.push(rect);}return rect;},render:function(dim,_3cb){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_3cb);}this.resetEvents();this.dirty=this.isDirty();var s;if(this.dirty){arr.forEach(this.series,_3c5);this._eventSeries={};this.cleanGroup();s=this.getGroup();df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_3cc=Math.max(0,this._vScaler.bounds.lower),_3cd=vt(_3cc),_3ce=this.events(),bar=this.getBarProperties();var z=this.series.length;arr.forEach(this.series,function(_3cf){if(_3cf.hidden){z--;}});for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(this.opt.enableCache){run._rectFreePool=(run._rectFreePool?run._rectFreePool:[]).concat(run._rectUsePool?run._rectUsePool:[]);run._rectUsePool=[];}var _3d0=t.next("column",[this.opt,run]),_3d1=new Array(run.data.length);if(run.hidden){run.dyn.fill=_3d0.series.fill;continue;}z--;s=run.group;var _3d2=arr.some(run.data,function(item){return typeof item=="number"||(item&&!item.hasOwnProperty("x"));});var min=_3d2?Math.max(0,Math.floor(this._hScaler.bounds.from-1)):0;var max=_3d2?Math.min(run.data.length,Math.ceil(this._hScaler.bounds.to)):run.data.length;for(var j=min;j<max;++j){var _3d3=run.data[j];if(_3d3!=null){var val=this.getValue(_3d3,j,i,_3d2),vv=vt(val.y),h=Math.abs(vv-_3cd),_3d4,_3d5;if(this.opt.styleFunc||typeof _3d3!="number"){var _3d6=typeof _3d3!="number"?[_3d3]:[];if(this.opt.styleFunc){_3d6.push(this.opt.styleFunc(_3d3));}_3d4=t.addMixin(_3d0,"column",_3d6,true);}else{_3d4=t.post(_3d0,"column");}if(bar.width>=1&&h>=0){var rect={x:_3cb.l+ht(val.x+0.5)+bar.gap+bar.thickness*z,y:dim.height-_3cb.b-(val.y>_3cc?vv:_3cd),width:bar.width,height:h};if(_3d4.series.shadow){var _3d7=lang.clone(rect);_3d7.x+=_3d4.series.shadow.dx;_3d7.y+=_3d4.series.shadow.dy;_3d5=this.createRect(run,s,_3d7).setFill(_3d4.series.shadow.color).setStroke(_3d4.series.shadow);if(this.animate){this._animateColumn(_3d5,dim.height-_3cb.b+_3cd,h);}}var _3d8=this._plotFill(_3d4.series.fill,dim,_3cb);_3d8=this._shapeFill(_3d8,rect);var _3d9=this.createRect(run,s,rect).setFill(_3d8).setStroke(_3d4.series.stroke);if(_3d9.setFilter&&_3d4.series.filter){_3d9.setFilter(_3d4.series.filter);}run.dyn.fill=_3d9.getFill();run.dyn.stroke=_3d9.getStroke();if(_3ce){var o={element:"column",index:j,run:run,shape:_3d9,shadow:_3d5,cx:val.x+0.5,cy:val.y,x:_3d2?j:run.data[j].x,y:_3d2?run.data[j]:run.data[j].y};this._connectEvents(o);_3d1[j]=o;}if(!isNaN(val.py)&&val.py>_3cc){rect.height=vv-vt(val.py);}this.createLabel(s,_3d3,rect,_3d4);if(this.animate){this._animateColumn(_3d9,dim.height-_3cb.b-_3cd,h);}}}}this._eventSeries[run.name]=_3d1;run.dirty=false;}this.dirty=false;if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_3cb);}return this;},getValue:function(_3da,j,_3db,_3dc){var y,x;if(_3dc){if(typeof _3da=="number"){y=_3da;}else{y=_3da.y;}x=j;}else{y=_3da.y;x=_3da.x-1;}return {x:x,y:y};},getBarProperties:function(){var f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);return {gap:f.gap,width:f.size,thickness:0};},_animateColumn:function(_3dd,_3de,_3df){if(_3df==0){_3df=1;}fx.animateTransform(lang.delegate({shape:_3dd,duration:1200,transform:[{name:"translate",start:[0,_3de-(_3de/_3df)],end:[0,0]},{name:"scale",start:[1,1/_3df],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojox/lang/functional/array":function(){define(["dojo/_base/kernel","dojo/_base/lang","dojo/_base/array","./lambda"],function(_3e0,lang,arr,df){var _3e1={};lang.mixin(df,{filter:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_3e0.global;f=df.lambda(f);var t=[],v,i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;++i){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){v=a.next();if(f.call(o,v,i++,a)){t.push(v);}}}else{for(i in a){if(!(i in _3e1)){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}}}}return t;},forEach:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_3e0.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;f.call(o,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();f.call(o,a.next(),i++,a)){}}else{for(i in a){if(!(i in _3e1)){f.call(o,a[i],i,a);}}}}return o;},map:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_3e0.global;f=df.lambda(f);var t,n,i;if(lang.isArray(a)){t=new Array(n=a.length);for(i=0;i<n;t[i]=f.call(o,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){t=[];for(i=0;a.hasNext();t.push(f.call(o,a.next(),i++,a))){}}else{t=[];for(i in a){if(!(i in _3e1)){t.push(f.call(o,a[i],i,a));}}}}return t;},every:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_3e0.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;++i){if(!f.call(o,a[i],i,a)){return false;}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){if(!f.call(o,a.next(),i++,a)){return false;}}}else{for(i in a){if(!(i in _3e1)){if(!f.call(o,a[i],i,a)){return false;}}}}}return true;},some:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_3e0.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;++i){if(f.call(o,a[i],i,a)){return true;}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){if(f.call(o,a.next(),i++,a)){return true;}}}else{for(i in a){if(!(i in _3e1)){if(f.call(o,a[i],i,a)){return true;}}}}}return false;}});return df;});},"dojox/charting/themes/common":function(){define(["dojo/_base/lang"],function(lang){return lang.getObject("dojox.charting.themes",true);});},"dojox/charting/plot2d/common":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/Color","dojox/gfx","dojox/lang/functional","../scaler/common"],function(lang,arr,_3e2,g,df,sc){var _3e3=lang.getObject("dojox.charting.plot2d.common",true);return lang.mixin(_3e3,{doIfLoaded:sc.doIfLoaded,makeStroke:function(_3e4){if(!_3e4){return _3e4;}if(typeof _3e4=="string"||_3e4 instanceof _3e2){_3e4={color:_3e4};}return g.makeParameters(g.defaultStroke,_3e4);},augmentColor:function(_3e5,_3e6){var t=new _3e2(_3e5),c=new _3e2(_3e6);c.a=t.a;return c;},augmentStroke:function(_3e7,_3e8){var s=_3e3.makeStroke(_3e7);if(s){s.color=_3e3.augmentColor(s.color,_3e8);}return s;},augmentFill:function(fill,_3e9){var fc,c=new _3e2(_3e9);if(typeof fill=="string"||fill instanceof _3e2){return _3e3.augmentColor(fill,_3e9);}return fill;},defaultStats:{vmin:Number.POSITIVE_INFINITY,vmax:Number.NEGATIVE_INFINITY,hmin:Number.POSITIVE_INFINITY,hmax:Number.NEGATIVE_INFINITY},collectSimpleStats:function(_3ea){var _3eb=lang.delegate(_3e3.defaultStats);for(var i=0;i<_3ea.length;++i){var run=_3ea[i];for(var j=0;j<run.data.length;j++){if(run.data[j]!==null){if(typeof run.data[j]=="number"){var _3ec=_3eb.vmin,_3ed=_3eb.vmax;arr.forEach(run.data,function(val,i){if(val!==null){var x=i+1,y=val;if(isNaN(y)){y=0;}_3eb.hmin=Math.min(_3eb.hmin,x);_3eb.hmax=Math.max(_3eb.hmax,x);_3eb.vmin=Math.min(_3eb.vmin,y);_3eb.vmax=Math.max(_3eb.vmax,y);}});if("ymin" in run){_3eb.vmin=Math.min(_3ec,run.ymin);}if("ymax" in run){_3eb.vmax=Math.max(_3ed,run.ymax);}}else{var _3ee=_3eb.hmin,_3ef=_3eb.hmax,_3ec=_3eb.vmin,_3ed=_3eb.vmax;if(!("xmin" in run)||!("xmax" in run)||!("ymin" in run)||!("ymax" in run)){arr.forEach(run.data,function(val,i){if(val!==null){var x="x" in val?val.x:i+1,y=val.y;if(isNaN(x)){x=0;}if(isNaN(y)){y=0;}_3eb.hmin=Math.min(_3eb.hmin,x);_3eb.hmax=Math.max(_3eb.hmax,x);_3eb.vmin=Math.min(_3eb.vmin,y);_3eb.vmax=Math.max(_3eb.vmax,y);}});}if("xmin" in run){_3eb.hmin=Math.min(_3ee,run.xmin);}if("xmax" in run){_3eb.hmax=Math.max(_3ef,run.xmax);}if("ymin" in run){_3eb.vmin=Math.min(_3ec,run.ymin);}if("ymax" in run){_3eb.vmax=Math.max(_3ed,run.ymax);}}break;}}}return _3eb;},calculateBarSize:function(_3f0,opt,_3f1){if(!_3f1){_3f1=1;}var gap=opt.gap,size=(_3f0-2*gap)/_3f1;if("minBarSize" in opt){size=Math.max(size,opt.minBarSize);}if("maxBarSize" in opt){size=Math.min(size,opt.maxBarSize);}size=Math.max(size,1);gap=(_3f0-size*_3f1)/2;return {size:size,gap:gap};},collectStackedStats:function(_3f2){var _3f3=lang.clone(_3e3.defaultStats);if(_3f2.length){_3f3.hmin=Math.min(_3f3.hmin,1);_3f3.hmax=df.foldl(_3f2,"seed, run -> Math.max(seed, run.data.length)",_3f3.hmax);for(var i=0;i<_3f3.hmax;++i){var v=_3f2[0].data[i];v=v&&(typeof v=="number"?v:v.y);if(isNaN(v)){v=0;}_3f3.vmin=Math.min(_3f3.vmin,v);for(var j=1;j<_3f2.length;++j){var t=_3f2[j].data[i];t=t&&(typeof t=="number"?t:t.y);if(isNaN(t)){t=0;}v+=t;}_3f3.vmax=Math.max(_3f3.vmax,v);}}return _3f3;},curve:function(a,_3f4){var _3f5=a.slice(0);if(_3f4=="x"){_3f5[_3f5.length]=_3f5[0];}var p=arr.map(_3f5,function(item,i){if(i==0){return "M"+item.x+","+item.y;}if(!isNaN(_3f4)){var dx=item.x-_3f5[i-1].x,dy=_3f5[i-1].y;return "C"+(item.x-(_3f4-1)*(dx/_3f4))+","+dy+" "+(item.x-(dx/_3f4))+","+item.y+" "+item.x+","+item.y;}else{if(_3f4=="X"||_3f4=="x"||_3f4=="S"){var p0,p1=_3f5[i-1],p2=_3f5[i],p3;var bz1x,bz1y,bz2x,bz2y;var f=1/6;if(i==1){if(_3f4=="x"){p0=_3f5[_3f5.length-2];}else{p0=p1;}f=1/3;}else{p0=_3f5[i-2];}if(i==(_3f5.length-1)){if(_3f4=="x"){p3=_3f5[1];}else{p3=p2;}f=1/3;}else{p3=_3f5[i+1];}var p1p2=Math.sqrt((p2.x-p1.x)*(p2.x-p1.x)+(p2.y-p1.y)*(p2.y-p1.y));var p0p2=Math.sqrt((p2.x-p0.x)*(p2.x-p0.x)+(p2.y-p0.y)*(p2.y-p0.y));var p1p3=Math.sqrt((p3.x-p1.x)*(p3.x-p1.x)+(p3.y-p1.y)*(p3.y-p1.y));var _3f6=p0p2*f;var _3f7=p1p3*f;if(_3f6>p1p2/2&&_3f7>p1p2/2){_3f6=p1p2/2;_3f7=p1p2/2;}else{if(_3f6>p1p2/2){_3f6=p1p2/2;_3f7=p1p2/2*p1p3/p0p2;}else{if(_3f7>p1p2/2){_3f7=p1p2/2;_3f6=p1p2/2*p0p2/p1p3;}}}if(_3f4=="S"){if(p0==p1){_3f6=0;}if(p2==p3){_3f7=0;}}bz1x=p1.x+_3f6*(p2.x-p0.x)/p0p2;bz1y=p1.y+_3f6*(p2.y-p0.y)/p0p2;bz2x=p2.x-_3f7*(p3.x-p1.x)/p1p3;bz2y=p2.y-_3f7*(p3.y-p1.y)/p1p3;}}return "C"+(bz1x+","+bz1y+" "+bz2x+","+bz2y+" "+p2.x+","+p2.y);});return p.join(" ");},getLabel:function(_3f8,_3f9,_3fa){return sc.doIfLoaded("dojo/number",function(_3fb){return (_3f9?_3fb.format(_3f8,{places:_3fa}):_3fb.format(_3f8))||"";},function(){return _3f9?_3f8.toFixed(_3fa):_3f8.toString();});}});});},"dijit/_Widget":function(){define(["dojo/aspect","dojo/_base/config","dojo/_base/connect","dojo/_base/declare","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/query","dojo/ready","./registry","./_WidgetBase","./_OnDijitClickMixin","./_FocusMixin","dojo/uacss","./hccss"],function(_3fc,_3fd,_3fe,_3ff,has,_400,lang,_401,_402,_403,_404,_405,_406){function _407(){};function _408(_409){return function(obj,_40a,_40b,_40c){if(obj&&typeof _40a=="string"&&obj[_40a]==_407){return obj.on(_40a.substring(2).toLowerCase(),lang.hitch(_40b,_40c));}return _409.apply(_3fe,arguments);};};_3fc.around(_3fe,"connect",_408);if(_400.connect){_3fc.around(_400,"connect",_408);}var _40d=_3ff("dijit._Widget",[_404,_405,_406],{onClick:_407,onDblClick:_407,onKeyDown:_407,onKeyPress:_407,onKeyUp:_407,onMouseDown:_407,onMouseMove:_407,onMouseOut:_407,onMouseOver:_407,onMouseLeave:_407,onMouseEnter:_407,onMouseUp:_407,constructor:function(_40e){this._toConnect={};for(var name in _40e){if(this[name]===_407){this._toConnect[name.replace(/^on/,"").toLowerCase()]=_40e[name];delete _40e[name];}}},postCreate:function(){this.inherited(arguments);for(var name in this._toConnect){this.on(name,this._toConnect[name]);}delete this._toConnect;},on:function(type,func){if(this[this._onMap(type)]===_407){return _3fe.connect(this.domNode,type.toLowerCase(),this,func);}return this.inherited(arguments);},_setFocusedAttr:function(val){this._focused=val;this._set("focused",val);},setAttribute:function(attr,_40f){_400.deprecated(this.declaredClass+"::setAttribute(attr, value) is deprecated. Use set() instead.","","2.0");this.set(attr,_40f);},attr:function(name,_410){var args=arguments.length;if(args>=2||typeof name==="object"){return this.set.apply(this,arguments);}else{return this.get(name);}},getDescendants:function(){_400.deprecated(this.declaredClass+"::getDescendants() is deprecated. Use getChildren() instead.","","2.0");return this.containerNode?_401("[widgetId]",this.containerNode).map(_403.byNode):[];},_onShow:function(){this.onShow();},onShow:function(){},onHide:function(){},onClose:function(){return true;}});if(has("dijit-legacy-requires")){_402(0,function(){var _411=["dijit/_base"];require(_411);});}return _40d;});},"dojo/cache":function(){define(["./_base/kernel","./text"],function(dojo){return dojo.cache;});},"dijit/_FocusMixin":function(){define(["./focus","./_WidgetBase","dojo/_base/declare","dojo/_base/lang"],function(_412,_413,_414,lang){lang.extend(_413,{focused:false,onFocus:function(){},onBlur:function(){},_onFocus:function(){this.onFocus();},_onBlur:function(){this.onBlur();}});return _414("dijit._FocusMixin",null,{_focusManager:_412});});},"dijit/_OnDijitClickMixin":function(){define(["dojo/on","dojo/_base/array","dojo/keys","dojo/_base/declare","dojo/has","./a11yclick"],function(on,_415,keys,_416,has,_417){var ret=_416("dijit._OnDijitClickMixin",null,{connect:function(obj,_418,_419){return this.inherited(arguments,[obj,_418=="ondijitclick"?_417:_418,_419]);}});ret.a11yclick=_417;return ret;});},"dojox/charting/plot2d/Bars":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/has","./CartesianBase","./_PlotEvents","./common","dojox/gfx/fx","dojox/lang/utils","dojox/lang/functional","dojox/lang/functional/reversed"],function(lang,arr,_41a,has,_41b,_41c,dc,fx,du,df,dfr){var _41d=dfr.lambda("item.purgeGroup()");return _41a("dojox.charting.plot2d.Bars",[_41b,_41c],{defaultParams:{gap:0,animate:null,enableCache:false},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},filter:{},styleFunc:null,font:"",fontColor:""},constructor:function(_41e,_41f){this.opt=lang.clone(lang.mixin(this.opt,this.defaultParams));du.updateWithObject(this.opt,_41f);du.updateWithPattern(this.opt,_41f,this.optionalParams);this.animate=this.opt.animate;this.renderingOptions={"shape-rendering":"crispEdges"};},getSeriesStats:function(){var _420=dc.collectSimpleStats(this.series),t;_420.hmin-=0.5;_420.hmax+=0.5;t=_420.hmin,_420.hmin=_420.vmin,_420.vmin=t;t=_420.hmax,_420.hmax=_420.vmax,_420.vmax=t;return _420;},createRect:function(run,_421,_422){var rect;if(this.opt.enableCache&&run._rectFreePool.length>0){rect=run._rectFreePool.pop();rect.setShape(_422);_421.add(rect);}else{rect=_421.createRect(_422);}if(this.opt.enableCache){run._rectUsePool.push(rect);}return rect;},createLabel:function(_423,_424,bbox,_425){if(this.opt.labels&&this.opt.labelStyle=="outside"){var y=bbox.y+bbox.height/2;var x=bbox.x+bbox.width+this.opt.labelOffset;this.renderLabel(_423,x,y,this._getLabel(isNaN(_424.y)?_424:_424.y),_425,"start");}else{this.inherited(arguments);}},render:function(dim,_426){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_426);}this.dirty=this.isDirty();this.resetEvents();var s;if(this.dirty){arr.forEach(this.series,_41d);this._eventSeries={};this.cleanGroup();s=this.getGroup();df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_427=Math.max(0,this._hScaler.bounds.lower),_428=ht(_427),_429=this.events();var bar=this.getBarProperties();var _42a=this.series.length;arr.forEach(this.series,function(_42b){if(_42b.hidden){_42a--;}});var z=_42a;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(this.opt.enableCache){run._rectFreePool=(run._rectFreePool?run._rectFreePool:[]).concat(run._rectUsePool?run._rectUsePool:[]);run._rectUsePool=[];}var _42c=t.next("bar",[this.opt,run]);if(run.hidden){run.dyn.fill=_42c.series.fill;run.dyn.stroke=_42c.series.stroke;continue;}z--;var _42d=new Array(run.data.length);s=run.group;var _42e=arr.some(run.data,function(item){return typeof item=="number"||(item&&!item.hasOwnProperty("x"));});var min=_42e?Math.max(0,Math.floor(this._vScaler.bounds.from-1)):0;var max=_42e?Math.min(run.data.length,Math.ceil(this._vScaler.bounds.to)):run.data.length;for(var j=min;j<max;++j){var _42f=run.data[j];if(_42f!=null){var val=this.getValue(_42f,j,i,_42e),hv=ht(val.y),w=Math.abs(hv-_428),_430,_431;if(this.opt.styleFunc||typeof _42f!="number"){var _432=typeof _42f!="number"?[_42f]:[];if(this.opt.styleFunc){_432.push(this.opt.styleFunc(_42f));}_430=t.addMixin(_42c,"bar",_432,true);}else{_430=t.post(_42c,"bar");}if(w>=0&&bar.height>=1){var rect={x:_426.l+(val.y<_427?hv:_428),y:dim.height-_426.b-vt(val.x+1.5)+bar.gap+bar.thickness*(_42a-z-1),width:w,height:bar.height};if(_430.series.shadow){var _433=lang.clone(rect);_433.x+=_430.series.shadow.dx;_433.y+=_430.series.shadow.dy;_431=this.createRect(run,s,_433).setFill(_430.series.shadow.color).setStroke(_430.series.shadow);if(this.animate){this._animateBar(_431,_426.l+_428,-w);}}var _434=this._plotFill(_430.series.fill,dim,_426);_434=this._shapeFill(_434,rect);var _435=this.createRect(run,s,rect).setFill(_434).setStroke(_430.series.stroke);if(_435.setFilter&&_430.series.filter){_435.setFilter(_430.series.filter);}run.dyn.fill=_435.getFill();run.dyn.stroke=_435.getStroke();if(_429){var o={element:"bar",index:j,run:run,shape:_435,shadow:_431,cx:val.y,cy:val.x+1.5,x:_42e?j:run.data[j].x,y:_42e?run.data[j]:run.data[j].y};this._connectEvents(o);_42d[j]=o;}if(!isNaN(val.py)&&val.py>_427){rect.x+=ht(val.py);rect.width-=ht(val.py);}this.createLabel(s,_42f,rect,_430);if(this.animate){this._animateBar(_435,_426.l+_428,-w);}}}}this._eventSeries[run.name]=_42d;run.dirty=false;}this.dirty=false;if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_426);}return this;},getValue:function(_436,j,_437,_438){var y,x;if(_438){if(typeof _436=="number"){y=_436;}else{y=_436.y;}x=j;}else{y=_436.y;x=_436.x-1;}return {y:y,x:x};},getBarProperties:function(){var f=dc.calculateBarSize(this._vScaler.bounds.scale,this.opt);return {gap:f.gap,height:f.size,thickness:0};},_animateBar:function(_439,_43a,_43b){if(_43b==0){_43b=1;}fx.animateTransform(lang.delegate({shape:_439,duration:1200,transform:[{name:"translate",start:[_43a-(_43a/_43b),0],end:[0,0]},{name:"scale",start:[1/_43b,1],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojox/gfx/_base":function(){define(["dojo/_base/kernel","dojo/_base/lang","dojo/_base/Color","dojo/_base/sniff","dojo/_base/window","dojo/_base/array","dojo/dom","dojo/dom-construct","dojo/dom-geometry"],function(_43c,lang,_43d,has,win,arr,dom,_43e,_43f){var g=lang.getObject("dojox.gfx",true),b=g._base={};g._hasClass=function(node,_440){var cls=node.getAttribute("className");return cls&&(" "+cls+" ").indexOf(" "+_440+" ")>=0;};g._addClass=function(node,_441){var cls=node.getAttribute("className")||"";if(!cls||(" "+cls+" ").indexOf(" "+_441+" ")<0){node.setAttribute("className",cls+(cls?" ":"")+_441);}};g._removeClass=function(node,_442){var cls=node.getAttribute("className");if(cls){node.setAttribute("className",cls.replace(new RegExp("(^|\\s+)"+_442+"(\\s+|$)"),"$1$2"));}};b._getFontMeasurements=function(){var _443={"1em":0,"1ex":0,"100%":0,"12pt":0,"16px":0,"xx-small":0,"x-small":0,"small":0,"medium":0,"large":0,"x-large":0,"xx-large":0};var p,_444;if(has("ie")){_444=win.doc.documentElement.style.fontSize||"";if(!_444){win.doc.documentElement.style.fontSize="100%";}}var div=_43e.create("div",{style:{position:"absolute",left:"0",top:"-100px",width:"30px",height:"1000em",borderWidth:"0",margin:"0",padding:"0",outline:"none",lineHeight:"1",overflow:"hidden"}},win.body());for(p in _443){div.style.fontSize=p;_443[p]=Math.round(div.offsetHeight*12/16)*16/12/1000;}if(has("ie")){win.doc.documentElement.style.fontSize=_444;}win.body().removeChild(div);return _443;};var _445=null;b._getCachedFontMeasurements=function(_446){if(_446||!_445){_445=b._getFontMeasurements();}return _445;};var _447=null,_448={};b._getTextBox=function(text,_449,_44a){var m,s,al=arguments.length;var i,box;if(!_447){_447=_43e.create("div",{style:{position:"absolute",top:"-10000px",left:"0",visibility:"hidden"}},win.body());}m=_447;m.className="";s=m.style;s.borderWidth="0";s.margin="0";s.padding="0";s.outline="0";if(al>1&&_449){for(i in _449){if(i in _448){continue;}s[i]=_449[i];}}if(al>2&&_44a){m.className=_44a;}m.innerHTML=text;if(m.getBoundingClientRect){var bcr=m.getBoundingClientRect();box={l:bcr.left,t:bcr.top,w:bcr.width||(bcr.right-bcr.left),h:bcr.height||(bcr.bottom-bcr.top)};}else{box=_43f.getMarginBox(m);}m.innerHTML="";return box;};b._computeTextLocation=function(_44b,_44c,_44d,_44e){var loc={},_44f=_44b.align;switch(_44f){case "end":loc.x=_44b.x-_44c;break;case "middle":loc.x=_44b.x-_44c/2;break;default:loc.x=_44b.x;break;}var c=_44e?0.75:1;loc.y=_44b.y-_44d*c;return loc;};b._computeTextBoundingBox=function(s){if(!g._base._isRendered(s)){return {x:0,y:0,width:0,height:0};}var loc,_450=s.getShape(),font=s.getFont()||g.defaultFont,w=s.getTextWidth(),h=g.normalizedLength(font.size);loc=b._computeTextLocation(_450,w,h,true);return {x:loc.x,y:loc.y,width:w,height:h};};b._isRendered=function(s){var p=s.parent;while(p&&p.getParent){p=p.parent;}return p!==null;};var _451=0;b._getUniqueId=function(){var id;do{id=_43c._scopeName+"xUnique"+(++_451);}while(dom.byId(id));return id;};b._fixMsTouchAction=function(_452){var r=_452.rawNode;if(typeof r.style.msTouchAction!="undefined"){r.style.msTouchAction="none";}};lang.mixin(g,{defaultPath:{type:"path",path:""},defaultPolyline:{type:"polyline",points:[]},defaultRect:{type:"rect",x:0,y:0,width:100,height:100,r:0},defaultEllipse:{type:"ellipse",cx:0,cy:0,rx:200,ry:100},defaultCircle:{type:"circle",cx:0,cy:0,r:100},defaultLine:{type:"line",x1:0,y1:0,x2:100,y2:100},defaultImage:{type:"image",x:0,y:0,width:0,height:0,src:""},defaultText:{type:"text",x:0,y:0,text:"",align:"start",decoration:"none",rotated:false,kerning:true},defaultTextPath:{type:"textpath",text:"",align:"start",decoration:"none",rotated:false,kerning:true},defaultStroke:{type:"stroke",color:"black",style:"solid",width:1,cap:"butt",join:4},defaultLinearGradient:{type:"linear",x1:0,y1:0,x2:100,y2:100,colors:[{offset:0,color:"black"},{offset:1,color:"white"}]},defaultRadialGradient:{type:"radial",cx:0,cy:0,r:100,colors:[{offset:0,color:"black"},{offset:1,color:"white"}]},defaultPattern:{type:"pattern",x:0,y:0,width:0,height:0,src:""},defaultFont:{type:"font",style:"normal",variant:"normal",weight:"normal",size:"10pt",family:"serif"},getDefault:(function(){var _453={};return function(type){var t=_453[type];if(t){return new t();}t=_453[type]=new Function();t.prototype=g["default"+type];return new t();};})(),normalizeColor:function(_454){return (_454 instanceof _43d)?_454:new _43d(_454);},normalizeParameters:function(_455,_456){var x;if(_456){var _457={};for(x in _455){if(x in _456&&!(x in _457)){_455[x]=_456[x];}}}return _455;},makeParameters:function(_458,_459){var i=null;if(!_459){return lang.delegate(_458);}var _45a={};for(i in _458){if(!(i in _45a)){_45a[i]=lang.clone((i in _459)?_459[i]:_458[i]);}}return _45a;},formatNumber:function(x,_45b){var val=x.toString();if(val.indexOf("e")>=0){val=x.toFixed(4);}else{var _45c=val.indexOf(".");if(_45c>=0&&val.length-_45c>5){val=x.toFixed(4);}}if(x<0){return val;}return _45b?" "+val:val;},makeFontString:function(font){return font.style+" "+font.variant+" "+font.weight+" "+font.size+" "+font.family;},splitFontString:function(str){var font=g.getDefault("Font");var t=str.split(/\s+/);do{if(t.length<5){break;}font.style=t[0];font.variant=t[1];font.weight=t[2];var i=t[3].indexOf("/");font.size=i<0?t[3]:t[3].substring(0,i);var j=4;if(i<0){if(t[4]=="/"){j=6;}else{if(t[4].charAt(0)=="/"){j=5;}}}if(j<t.length){font.family=t.slice(j).join(" ");}}while(false);return font;},cm_in_pt:72/2.54,mm_in_pt:7.2/2.54,px_in_pt:function(){return g._base._getCachedFontMeasurements()["12pt"]/12;},pt2px:function(len){return len*g.px_in_pt();},px2pt:function(len){return len/g.px_in_pt();},normalizedLength:function(len){if(len.length===0){return 0;}if(len.length>2){var _45d=g.px_in_pt();var val=parseFloat(len);switch(len.slice(-2)){case "px":return val;case "pt":return val*_45d;case "in":return val*72*_45d;case "pc":return val*12*_45d;case "mm":return val*g.mm_in_pt*_45d;case "cm":return val*g.cm_in_pt*_45d;}}return parseFloat(len);},pathVmlRegExp:/([A-Za-z]+)|(\d+(\.\d+)?)|(\.\d+)|(-\d+(\.\d+)?)|(-\.\d+)/g,pathSvgRegExp:/([A-DF-Za-df-z])|([-+]?\d*[.]?\d+(?:[eE][-+]?\d+)?)/g,equalSources:function(a,b){return a&&b&&a===b;},switchTo:function(_45e){var ns=typeof _45e=="string"?g[_45e]:_45e;if(ns){arr.forEach(["Group","Rect","Ellipse","Circle","Line","Polyline","Image","Text","Path","TextPath","Surface","createSurface","fixTarget"],function(name){g[name]=ns[name];});if(typeof _45e=="string"){g.renderer=_45e;}else{arr.some(["svg","vml","canvas","canvasWithEvents","silverlight"],function(r){return (g.renderer=g[r]&&g[r].Surface===g.Surface?r:null);});}}}});return g;});},"dojox/charting/plot2d/CartesianBase":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/_base/connect","dojo/has","./Base","../scaler/primitive","dojox/gfx","dojox/gfx/fx","dojox/lang/utils"],function(lang,_45f,hub,has,Base,_460,gfx,fx,du){return _45f("dojox.charting.plot2d.CartesianBase",Base,{baseParams:{hAxis:"x",vAxis:"y",labels:false,labelOffset:10,fixed:true,precision:1,labelStyle:"inside",htmlLabels:true,omitLabels:true,labelFunc:null},constructor:function(_461,_462){this.axes=["hAxis","vAxis"];this.zoom=null;this.zoomQueue=[];this.lastWindow={vscale:1,hscale:1,xoffset:0,yoffset:0};this.hAxis=(_462&&_462.hAxis)||"x";this.vAxis=(_462&&_462.vAxis)||"y";this.series=[];this.opt=lang.clone(this.baseParams);du.updateWithObject(this.opt,_462);},clear:function(){this.inherited(arguments);this._hAxis=null;this._vAxis=null;return this;},cleanGroup:function(_463,_464){this.inherited(arguments);if(!_464&&this.chart._nativeClip){var _465=this.chart.offsets,dim=this.chart.dim;var w=Math.max(0,dim.width-_465.l-_465.r),h=Math.max(0,dim.height-_465.t-_465.b);this.group.setClip({x:_465.l,y:_465.t,width:w,height:h});if(!this._clippedGroup){this._clippedGroup=this.group.createGroup();}}},purgeGroup:function(){this.inherited(arguments);this._clippedGroup=null;},getGroup:function(){return this._clippedGroup||this.group;},setAxis:function(axis){if(axis){this[axis.vertical?"_vAxis":"_hAxis"]=axis;}return this;},toPage:function(_466){var ah=this._hAxis,av=this._vAxis,sh=ah.getScaler(),sv=av.getScaler(),th=sh.scaler.getTransformerFromModel(sh),tv=sv.scaler.getTransformerFromModel(sv),c=this.chart.getCoords(),o=this.chart.offsets,dim=this.chart.dim;var t=function(_467){var r={};r.x=th(_467[ah.name])+c.x+o.l;r.y=c.y+dim.height-o.b-tv(_467[av.name]);return r;};return _466?t(_466):t;},toData:function(_468){var ah=this._hAxis,av=this._vAxis,sh=ah.getScaler(),sv=av.getScaler(),th=sh.scaler.getTransformerFromPlot(sh),tv=sv.scaler.getTransformerFromPlot(sv),c=this.chart.getCoords(),o=this.chart.offsets,dim=this.chart.dim;var t=function(_469){var r={};r[ah.name]=th(_469.x-c.x-o.l);r[av.name]=tv(c.y+dim.height-_469.y-o.b);return r;};return _468?t(_468):t;},isDirty:function(){return this.dirty||this._hAxis&&this._hAxis.dirty||this._vAxis&&this._vAxis.dirty;},createLabel:function(_46a,_46b,bbox,_46c){if(this.opt.labels){var x,y,_46d=this.opt.labelFunc?this.opt.labelFunc.apply(this,[_46b,this.opt.fixed,this.opt.precision]):this._getLabel(isNaN(_46b.y)?_46b:_46b.y);if(this.opt.labelStyle=="inside"){var lbox=gfx._base._getTextBox(_46d,{font:_46c.series.font});x=bbox.x+bbox.width/2;y=bbox.y+bbox.height/2+lbox.h/4;if(lbox.w>bbox.width||lbox.h>bbox.height){return;}}else{x=bbox.x+bbox.width/2;y=bbox.y-this.opt.labelOffset;}this.renderLabel(_46a,x,y,_46d,_46c,this.opt.labelStyle=="inside");}},performZoom:function(dim,_46e){var vs=this._vAxis.scale||1,hs=this._hAxis.scale||1,_46f=dim.height-_46e.b,_470=this._hScaler.bounds,_471=(_470.from-_470.lower)*_470.scale,_472=this._vScaler.bounds,_473=(_472.from-_472.lower)*_472.scale,_474=vs/this.lastWindow.vscale,_475=hs/this.lastWindow.hscale,_476=(this.lastWindow.xoffset-_471)/((this.lastWindow.hscale==1)?hs:this.lastWindow.hscale),_477=(_473-this.lastWindow.yoffset)/((this.lastWindow.vscale==1)?vs:this.lastWindow.vscale),_478=this.getGroup(),anim=fx.animateTransform(lang.delegate({shape:_478,duration:1200,transform:[{name:"translate",start:[0,0],end:[_46e.l*(1-_475),_46f*(1-_474)]},{name:"scale",start:[1,1],end:[_475,_474]},{name:"original"},{name:"translate",start:[0,0],end:[_476,_477]}]},this.zoom));lang.mixin(this.lastWindow,{vscale:vs,hscale:hs,xoffset:_471,yoffset:_473});this.zoomQueue.push(anim);hub.connect(anim,"onEnd",this,function(){this.zoom=null;this.zoomQueue.shift();if(this.zoomQueue.length>0){this.zoomQueue[0].play();}});if(this.zoomQueue.length==1){this.zoomQueue[0].play();}return this;},initializeScalers:function(dim,_479){if(this._hAxis){if(!this._hAxis.initialized()){this._hAxis.calculate(_479.hmin,_479.hmax,dim.width);}this._hScaler=this._hAxis.getScaler();}else{this._hScaler=_460.buildScaler(_479.hmin,_479.hmax,dim.width);}if(this._vAxis){if(!this._vAxis.initialized()){this._vAxis.calculate(_479.vmin,_479.vmax,dim.height);}this._vScaler=this._vAxis.getScaler();}else{this._vScaler=_460.buildScaler(_479.vmin,_479.vmax,dim.height);}return this;}});});},"dijit/focus":function(){define(["dojo/aspect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/Evented","dojo/_base/lang","dojo/on","dojo/domReady","dojo/sniff","dojo/Stateful","dojo/_base/window","dojo/window","./a11y","./registry","./main"],function(_47a,_47b,dom,_47c,_47d,_47e,_47f,lang,on,_480,has,_481,win,_482,a11y,_483,_484){var _485;var _486;var _487=_47b([_481,_47f],{curNode:null,activeStack:[],constructor:function(){var _488=lang.hitch(this,function(node){if(dom.isDescendant(this.curNode,node)){this.set("curNode",null);}if(dom.isDescendant(this.prevNode,node)){this.set("prevNode",null);}});_47a.before(_47e,"empty",_488);_47a.before(_47e,"destroy",_488);},registerIframe:function(_489){return this.registerWin(_489.contentWindow,_489);},registerWin:function(_48a,_48b){var _48c=this,body=_48a.document&&_48a.document.body;if(body){var _48d=has("pointer-events")?"pointerdown":has("MSPointer")?"MSPointerDown":has("touch-events")?"mousedown, touchstart":"mousedown";var mdh=on(_48a.document,_48d,function(evt){if(evt&&evt.target&&evt.target.parentNode==null){return;}_48c._onTouchNode(_48b||evt.target,"mouse");});var fih=on(body,"focusin",function(evt){if(!evt.target.tagName){return;}var tag=evt.target.tagName.toLowerCase();if(tag=="#document"||tag=="body"){return;}if(a11y.isFocusable(evt.target)){_48c._onFocusNode(_48b||evt.target);}else{_48c._onTouchNode(_48b||evt.target);}});var foh=on(body,"focusout",function(evt){_48c._onBlurNode(_48b||evt.target);});return {remove:function(){mdh.remove();fih.remove();foh.remove();mdh=fih=foh=null;body=null;}};}},_onBlurNode:function(node){var now=(new Date()).getTime();if(now<_485+100){return;}if(this._clearFocusTimer){clearTimeout(this._clearFocusTimer);}this._clearFocusTimer=setTimeout(lang.hitch(this,function(){this.set("prevNode",this.curNode);this.set("curNode",null);}),0);if(this._clearActiveWidgetsTimer){clearTimeout(this._clearActiveWidgetsTimer);}if(now<_486+100){return;}this._clearActiveWidgetsTimer=setTimeout(lang.hitch(this,function(){delete this._clearActiveWidgetsTimer;this._setStack([]);}),0);},_onTouchNode:function(node,by){_486=(new Date()).getTime();if(this._clearActiveWidgetsTimer){clearTimeout(this._clearActiveWidgetsTimer);delete this._clearActiveWidgetsTimer;}if(_47d.contains(node,"dijitPopup")){node=node.firstChild;}var _48e=[];try{while(node){var _48f=_47c.get(node,"dijitPopupParent");if(_48f){node=_483.byId(_48f).domNode;}else{if(node.tagName&&node.tagName.toLowerCase()=="body"){if(node===win.body()){break;}node=_482.get(node.ownerDocument).frameElement;}else{var id=node.getAttribute&&node.getAttribute("widgetId"),_490=id&&_483.byId(id);if(_490&&!(by=="mouse"&&_490.get("disabled"))){_48e.unshift(id);}node=node.parentNode;}}}}catch(e){}this._setStack(_48e,by);},_onFocusNode:function(node){if(!node){return;}if(node.nodeType==9){return;}_485=(new Date()).getTime();if(this._clearFocusTimer){clearTimeout(this._clearFocusTimer);delete this._clearFocusTimer;}this._onTouchNode(node);if(node==this.curNode){return;}this.set("prevNode",this.curNode);this.set("curNode",node);},_setStack:function(_491,by){var _492=this.activeStack,_493=_492.length-1,_494=_491.length-1;if(_491[_494]==_492[_493]){return;}this.set("activeStack",_491);var _495,i;for(i=_493;i>=0&&_492[i]!=_491[i];i--){_495=_483.byId(_492[i]);if(_495){_495._hasBeenBlurred=true;_495.set("focused",false);if(_495._focusManager==this){_495._onBlur(by);}this.emit("widget-blur",_495,by);}}for(i++;i<=_494;i++){_495=_483.byId(_491[i]);if(_495){_495.set("focused",true);if(_495._focusManager==this){_495._onFocus(by);}this.emit("widget-focus",_495,by);}}},focus:function(node){if(node){try{node.focus();}catch(e){}}}});var _496=new _487();_480(function(){var _497=_496.registerWin(_482.get(document));if(has("ie")){on(window,"unload",function(){if(_497){_497.remove();_497=null;}});}});_484.focus=function(node){_496.focus(node);};for(var attr in _496){if(!/^_/.test(attr)){_484.focus[attr]=typeof _496[attr]=="function"?lang.hitch(_496,attr):_496[attr];}}_496.watch(function(attr,_498,_499){_484.focus[attr]=_499;});return _496;});},"dojox/charting/widget/Legend":function(){define(["dojo/_base/declare","dijit/_WidgetBase","dojox/gfx","dojo/_base/array","dojo/has","dojo/has!dojo-bidi?../bidi/widget/Legend","dojox/lang/functional","dojo/dom","dojo/dom-construct","dojo/dom-class","dijit/registry"],function(_49a,_49b,gfx,arr,has,_49c,df,dom,_49d,_49e,_49f){var _4a0=_49a(has("dojo-bidi")?"dojox.charting.widget.NonBidiLegend":"dojox.charting.widget.Legend",_49b,{chartRef:"",horizontal:true,swatchSize:18,legendBody:null,postCreate:function(){if(!this.chart&&this.chartRef){this.chart=_49f.byId(this.chartRef)||_49f.byNode(dom.byId(this.chartRef));if(!this.chart){}}this.chart=this.chart.chart||this.chart;this.refresh();},buildRendering:function(){this.domNode=_49d.create("table",{role:"group","aria-label":"chart legend","class":"dojoxLegendNode"});this.legendBody=_49d.create("tbody",null,this.domNode);this.inherited(arguments);},destroy:function(){if(this._surfaces){arr.forEach(this._surfaces,function(_4a1){_4a1.destroy();});}this.inherited(arguments);},refresh:function(){if(this._surfaces){arr.forEach(this._surfaces,function(_4a2){_4a2.destroy();});}this._surfaces=[];while(this.legendBody.lastChild){_49d.destroy(this.legendBody.lastChild);}if(this.horizontal){_49e.add(this.domNode,"dojoxLegendHorizontal");this._tr=_49d.create("tr",null,this.legendBody);this._inrow=0;}var s=this.series||this.chart.series;if(s.length==0){return;}if(s[0].chart.stack[0].declaredClass=="dojox.charting.plot2d.Pie"){var t=s[0].chart.stack[0];if(typeof t.run.data[0]=="number"){var _4a3=df.map(t.run.data,"Math.max(x, 0)");var _4a4=df.map(_4a3,"/this",df.foldl(_4a3,"+",0));arr.forEach(_4a4,function(x,i){this._addLabel(t.dyn[i],t._getLabel(x*100)+"%");},this);}else{arr.forEach(t.run.data,function(x,i){this._addLabel(t.dyn[i],x.legend||x.text||x.y);},this);}}else{arr.forEach(s,function(x){this._addLabel(x.dyn,x.legend||x.name);},this);}},_addLabel:function(dyn,_4a5){var _4a6=_49d.create("td"),icon=_49d.create("div",null,_4a6),text=_49d.create("label",null,_4a6),div=_49d.create("div",{style:{"width":this.swatchSize+"px","height":this.swatchSize+"px","float":"left"}},icon);_49e.add(icon,"dojoxLegendIcon dijitInline");_49e.add(text,"dojoxLegendText");if(this._tr){this._tr.appendChild(_4a6);if(++this._inrow===this.horizontal){this._tr=_49d.create("tr",null,this.legendBody);this._inrow=0;}}else{var tr=_49d.create("tr",null,this.legendBody);tr.appendChild(_4a6);}this._makeIcon(div,dyn);text.innerHTML=String(_4a5);if(has("dojo-bidi")){text.dir=this.getTextDir(_4a5,text.dir);}},_makeIcon:function(div,dyn){var mb={h:this.swatchSize,w:this.swatchSize};var _4a7=gfx.createSurface(div,mb.w,mb.h);this._surfaces.push(_4a7);if(dyn.fill){_4a7.createRect({x:2,y:2,width:mb.w-4,height:mb.h-4}).setFill(dyn.fill).setStroke(dyn.stroke);}else{if(dyn.stroke||dyn.marker){var line={x1:0,y1:mb.h/2,x2:mb.w,y2:mb.h/2};if(dyn.stroke){_4a7.createLine(line).setStroke(dyn.stroke);}if(dyn.marker){var c={x:mb.w/2,y:mb.h/2};_4a7.createPath({path:"M"+c.x+" "+c.y+" "+dyn.marker}).setFill(dyn.markerFill).setStroke(dyn.markerStroke);}}else{_4a7.createRect({x:2,y:2,width:mb.w-4,height:mb.h-4}).setStroke("black");_4a7.createLine({x1:2,y1:2,x2:mb.w-2,y2:mb.h-2}).setStroke("black");_4a7.createLine({x1:2,y1:mb.h-2,x2:mb.w-2,y2:2}).setStroke("black");}}}});return has("dojo-bidi")?_49a("dojox.charting.widget.Legend",[_4a0,_49c]):_4a0;});},"dojox/charting/plot2d/StackedLines":function(){define(["dojo/_base/declare","./Stacked"],function(_4a8,_4a9){return _4a8("dojox.charting.plot2d.StackedLines",_4a9,{constructor:function(){this.opt.lines=true;}});});},"dojox/charting/plot2d/StackedColumns":function(){define(["dojo/_base/declare","./Columns","./commonStacked"],function(_4aa,_4ab,_4ac){return _4aa("dojox.charting.plot2d.StackedColumns",_4ab,{getSeriesStats:function(){var _4ad=_4ac.collectStats(this.series);_4ad.hmin-=0.5;_4ad.hmax+=0.5;return _4ad;},getValue:function(_4ae,_4af,_4b0,_4b1){var x,y;if(_4b1){x=_4af;y=_4ac.getIndexValue(this.series,_4b0,x);}else{x=_4ae.x-1;y=_4ac.getValue(this.series,_4b0,_4ae.x);y=[y[0]?y[0].y:null,y[1]?y[1]:null];}return {x:x,y:y[0],py:y[1]};}});});},"dojox/charting/Series":function(){define(["dojo/_base/lang","dojo/_base/declare","./Element"],function(lang,_4b2,_4b3){return _4b2("dojox.charting.Series",_4b3,{constructor:function(_4b4,data,_4b5){lang.mixin(this,_4b5);if(typeof this.plot!="string"){this.plot="default";}this.update(data);},clear:function(){this.dyn={};},update:function(data){if(lang.isArray(data)){this.data=data;}else{this.source=data;this.data=this.source.data;if(this.source.setSeriesObject){this.source.setSeriesObject(this);}}this.dirty=true;this.clear();}});});},"dojox/charting/plot2d/Default":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/_base/array","dojo/has","./CartesianBase","./_PlotEvents","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx"],function(lang,_4b6,arr,has,_4b7,_4b8,dc,df,dfr,du,fx){var _4b9=dfr.lambda("item.purgeGroup()");var _4ba=1200;return _4b6("dojox.charting.plot2d.Default",[_4b7,_4b8],{defaultParams:{lines:true,areas:false,markers:false,tension:"",animate:false,enableCache:false,interpolate:false},optionalParams:{stroke:{},outline:{},shadow:{},fill:{},filter:{},styleFunc:null,font:"",fontColor:"",marker:"",markerStroke:{},markerOutline:{},markerShadow:{},markerFill:{},markerFont:"",markerFontColor:""},constructor:function(_4bb,_4bc){this.opt=lang.clone(lang.mixin(this.opt,this.defaultParams));du.updateWithObject(this.opt,_4bc);du.updateWithPattern(this.opt,_4bc,this.optionalParams);this.animate=this.opt.animate;},createPath:function(run,_4bd,_4be){var path;if(this.opt.enableCache&&run._pathFreePool.length>0){path=run._pathFreePool.pop();path.setShape(_4be);_4bd.add(path);}else{path=_4bd.createPath(_4be);}if(this.opt.enableCache){run._pathUsePool.push(path);}return path;},buildSegments:function(i,_4bf){var run=this.series[i],min=_4bf?Math.max(0,Math.floor(this._hScaler.bounds.from-1)):0,max=_4bf?Math.min(run.data.length,Math.ceil(this._hScaler.bounds.to)):run.data.length,rseg=null,_4c0=[];for(var j=min;j<max;j++){if(run.data[j]!=null&&(_4bf||run.data[j].y!=null)){if(!rseg){rseg=[];_4c0.push({index:j,rseg:rseg});}rseg.push((_4bf&&run.data[j].hasOwnProperty("y"))?run.data[j].y:run.data[j]);}else{if(!this.opt.interpolate||_4bf){rseg=null;}}}return _4c0;},render:function(dim,_4c1){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_4c1);}this.resetEvents();this.dirty=this.isDirty();var s;if(this.dirty){arr.forEach(this.series,_4b9);this._eventSeries={};this.cleanGroup();this.getGroup().setTransform(null);s=this.getGroup();df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_4c2,_4c3,_4c4=this.events();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(this.opt.enableCache){run._pathFreePool=(run._pathFreePool?run._pathFreePool:[]).concat(run._pathUsePool?run._pathUsePool:[]);run._pathUsePool=[];}if(!run.data.length){run.dirty=false;t.skip();continue;}var _4c5=t.next(this.opt.areas?"area":"line",[this.opt,run],true),_4c6,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_4c7=this._eventSeries[run.name]=new Array(run.data.length);s=run.group;if(run.hidden){if(this.opt.lines){run.dyn.stroke=_4c5.series.stroke;}if(this.opt.markers){run.dyn.markerFill=_4c5.marker.fill;run.dyn.markerStroke=_4c5.marker.stroke;run.dyn.marker=_4c5.symbol;}if(this.opt.areas){run.dyn.fill=_4c5.series.fill;}continue;}var _4c8=arr.some(run.data,function(item){return typeof item=="number"||(item&&!item.hasOwnProperty("x"));});var _4c9=this.buildSegments(i,_4c8);for(var seg=0;seg<_4c9.length;seg++){var _4ca=_4c9[seg];if(_4c8){_4c6=arr.map(_4ca.rseg,function(v,i){return {x:ht(i+_4ca.index+1)+_4c1.l,y:dim.height-_4c1.b-vt(v),data:v};},this);}else{_4c6=arr.map(_4ca.rseg,function(v){return {x:ht(v.x)+_4c1.l,y:dim.height-_4c1.b-vt(v.y),data:v};},this);}if(_4c8&&this.opt.interpolate){while(seg<_4c9.length){seg++;_4ca=_4c9[seg];if(_4ca){_4c6=_4c6.concat(arr.map(_4ca.rseg,function(v,i){return {x:ht(i+_4ca.index+1)+_4c1.l,y:dim.height-_4c1.b-vt(v),data:v};},this));}}}var _4cb=this.opt.tension?dc.curve(_4c6,this.opt.tension):"";if(this.opt.areas&&_4c6.length>1){var fill=this._plotFill(_4c5.series.fill,dim,_4c1),_4cc=lang.clone(_4c6);if(this.opt.tension){var _4cd="L"+_4cc[_4cc.length-1].x+","+(dim.height-_4c1.b)+" L"+_4cc[0].x+","+(dim.height-_4c1.b)+" L"+_4cc[0].x+","+_4cc[0].y;run.dyn.fill=s.createPath(_4cb+" "+_4cd).setFill(fill).getFill();}else{_4cc.push({x:_4c6[_4c6.length-1].x,y:dim.height-_4c1.b});_4cc.push({x:_4c6[0].x,y:dim.height-_4c1.b});_4cc.push(_4c6[0]);run.dyn.fill=s.createPolyline(_4cc).setFill(fill).getFill();}}if(this.opt.lines||this.opt.markers){_4c2=_4c5.series.stroke;if(_4c5.series.outline){_4c3=run.dyn.outline=dc.makeStroke(_4c5.series.outline);_4c3.width=2*_4c3.width+_4c2.width;}}if(this.opt.markers){run.dyn.marker=_4c5.symbol;}var _4ce=null,_4cf=null,_4d0=null;if(_4c2&&_4c5.series.shadow&&_4c6.length>1){var _4d1=_4c5.series.shadow,_4d2=arr.map(_4c6,function(c){return {x:c.x+_4d1.dx,y:c.y+_4d1.dy};});if(this.opt.lines){if(this.opt.tension){run.dyn.shadow=s.createPath(dc.curve(_4d2,this.opt.tension)).setStroke(_4d1).getStroke();}else{run.dyn.shadow=s.createPolyline(_4d2).setStroke(_4d1).getStroke();}}if(this.opt.markers&&_4c5.marker.shadow){_4d1=_4c5.marker.shadow;_4d0=arr.map(_4d2,function(c){return this.createPath(run,s,"M"+c.x+" "+c.y+" "+_4c5.symbol).setStroke(_4d1).setFill(_4d1.color);},this);}}if(this.opt.lines&&_4c6.length>1){var _4d3;if(_4c3){if(this.opt.tension){run.dyn.outline=s.createPath(_4cb).setStroke(_4c3).getStroke();}else{run.dyn.outline=s.createPolyline(_4c6).setStroke(_4c3).getStroke();}}if(this.opt.tension){run.dyn.stroke=(_4d3=s.createPath(_4cb)).setStroke(_4c2).getStroke();}else{run.dyn.stroke=(_4d3=s.createPolyline(_4c6)).setStroke(_4c2).getStroke();}if(_4d3.setFilter&&_4c5.series.filter){_4d3.setFilter(_4c5.series.filter);}}var _4d4=null;if(this.opt.markers){var _4d5=_4c5;_4ce=new Array(_4c6.length);_4cf=new Array(_4c6.length);_4c3=null;if(_4d5.marker.outline){_4c3=dc.makeStroke(_4d5.marker.outline);_4c3.width=2*_4c3.width+(_4d5.marker.stroke?_4d5.marker.stroke.width:0);}arr.forEach(_4c6,function(c,i){if(this.opt.styleFunc||typeof c.data!="number"){var _4d6=typeof c.data!="number"?[c.data]:[];if(this.opt.styleFunc){_4d6.push(this.opt.styleFunc(c.data));}_4d5=t.addMixin(_4c5,"marker",_4d6,true);}else{_4d5=t.post(_4c5,"marker");}var path="M"+c.x+" "+c.y+" "+_4d5.symbol;if(_4c3){_4cf[i]=this.createPath(run,s,path).setStroke(_4c3);}_4ce[i]=this.createPath(run,s,path).setStroke(_4d5.marker.stroke).setFill(_4d5.marker.fill);},this);run.dyn.markerFill=_4d5.marker.fill;run.dyn.markerStroke=_4d5.marker.stroke;if(!_4d4&&this.opt.labels){_4d4=_4ce[0].getBoundingBox();}if(_4c4){arr.forEach(_4ce,function(s,i){var o={element:"marker",index:i+_4ca.index,run:run,shape:s,outline:_4cf[i]||null,shadow:_4d0&&_4d0[i]||null,cx:_4c6[i].x,cy:_4c6[i].y};if(_4c8){o.x=i+_4ca.index+1;o.y=run.data[i+_4ca.index];}else{o.x=_4ca.rseg[i].x;o.y=run.data[i+_4ca.index].y;}this._connectEvents(o);_4c7[i+_4ca.index]=o;},this);}else{delete this._eventSeries[run.name];}}if(this.opt.labels){var _4d7=_4d4?_4d4.width:2;var _4d8=_4d4?_4d4.height:2;arr.forEach(_4c6,function(c,i){if(this.opt.styleFunc||typeof c.data!="number"){var _4d9=typeof c.data!="number"?[c.data]:[];if(this.opt.styleFunc){_4d9.push(this.opt.styleFunc(c.data));}_4d5=t.addMixin(_4c5,"marker",_4d9,true);}else{_4d5=t.post(_4c5,"marker");}this.createLabel(s,_4ca.rseg[i],{x:c.x-_4d7/2,y:c.y-_4d8/2,width:_4d7,height:_4d8},_4d5);},this);}}run.dirty=false;}if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_4c1);}if(this.animate){var _4da=this.getGroup();fx.animateTransform(lang.delegate({shape:_4da,duration:_4ba,transform:[{name:"translate",start:[0,dim.height-_4c1.b],end:[0,0]},{name:"scale",start:[1,0],end:[1,1]},{name:"original"}]},this.animate)).play();}this.dirty=false;return this;}});});},"dijit/main":function(){define(["dojo/_base/kernel"],function(dojo){return dojo.dijit;});},"dojox/charting/plot2d/Base":function(){define(["dojo/_base/declare","dojo/_base/array","dojox/gfx","../Element","./common","../axis2d/common","dojo/has"],function(_4db,arr,gfx,_4dc,_4dd,ac,has){var Base=_4db("dojox.charting.plot2d.Base",_4dc,{constructor:function(_4de,_4df){if(_4df&&_4df.tooltipFunc){this.tooltipFunc=_4df.tooltipFunc;}},clear:function(){this.series=[];this.dirty=true;return this;},setAxis:function(axis){return this;},assignAxes:function(axes){arr.forEach(this.axes,function(axis){if(this[axis]){this.setAxis(axes[this[axis]]);}},this);},addSeries:function(run){this.series.push(run);return this;},getSeriesStats:function(){return _4dd.collectSimpleStats(this.series);},calculateAxes:function(dim){this.initializeScalers(dim,this.getSeriesStats());return this;},initializeScalers:function(){return this;},isDataDirty:function(){return arr.some(this.series,function(item){return item.dirty;});},render:function(dim,_4e0){return this;},renderLabel:function(_4e1,x,y,_4e2,_4e3,_4e4,_4e5){var elem=ac.createText[this.opt.htmlLabels&&gfx.renderer!="vml"?"html":"gfx"](this.chart,_4e1,x,y,_4e5?_4e5:"middle",_4e2,_4e3.series.font,_4e3.series.fontColor);if(_4e4){if(this.opt.htmlLabels&&gfx.renderer!="vml"){elem.style.pointerEvents="none";}else{if(elem.rawNode){elem.rawNode.style.pointerEvents="none";}}}if(this.opt.htmlLabels&&gfx.renderer!="vml"){this.htmlElements.push(elem);}return elem;},getRequiredColors:function(){return this.series.length;},_getLabel:function(_4e6){return _4dd.getLabel(_4e6,this.opt.fixed,this.opt.precision);}});if(has("dojo-bidi")){Base.extend({_checkOrientation:function(_4e7,dim,_4e8){this.chart.applyMirroring(this.group,dim,_4e8);}});}return Base;});},"dojox/charting/action2d/Tooltip":function(){define(["dijit/Tooltip","dojo/_base/lang","dojo/_base/declare","dojo/_base/window","dojo/_base/connect","dojo/dom-style","./PlotAction","dojox/gfx/matrix","dojo/has","dojo/has!dojo-bidi?../bidi/action2d/Tooltip","dojox/lang/functional","dojox/lang/functional/scan","dojox/lang/functional/fold"],function(_4e9,lang,_4ea,win,hub,_4eb,_4ec,m,has,_4ed,df){var _4ee=function(o,plot){var t=o.run&&o.run.data&&o.run.data[o.index];if(t&&typeof t!="number"&&(t.tooltip||t.text)){return t.tooltip||t.text;}if(plot.tooltipFunc){return plot.tooltipFunc(o);}else{return o.y;}};var pi4=Math.PI/4,pi2=Math.PI/2;var _4ef=_4ea(has("dojo-bidi")?"dojox.charting.action2d.NonBidiTooltip":"dojox.charting.action2d.Tooltip",_4ec,{defaultParams:{text:_4ee,mouseOver:true},optionalParams:{},constructor:function(_4f0,plot,_4f1){this.text=_4f1&&_4f1.text?_4f1.text:_4ee;this.mouseOver=_4f1&&_4f1.mouseOver!=undefined?_4f1.mouseOver:true;this.connect();},process:function(o){if(o.type==="onplotreset"||o.type==="onmouseout"){_4e9.hide(this.aroundRect);this.aroundRect=null;if(o.type==="onplotreset"){delete this.angles;}return;}if(!o.shape||(this.mouseOver&&o.type!=="onmouseover")||(!this.mouseOver&&o.type!=="onclick")){return;}var _4f2={type:"rect"},_4f3=["after-centered","before-centered"];switch(o.element){case "marker":_4f2.x=o.cx;_4f2.y=o.cy;_4f2.w=_4f2.h=1;break;case "circle":_4f2.x=o.cx-o.cr;_4f2.y=o.cy-o.cr;_4f2.w=_4f2.h=2*o.cr;break;case "spider_circle":_4f2.x=o.cx;_4f2.y=o.cy;_4f2.w=_4f2.h=1;break;case "spider_plot":return;case "column":_4f3=["above-centered","below-centered"];case "bar":_4f2=lang.clone(o.shape.getShape());_4f2.w=_4f2.width;_4f2.h=_4f2.height;break;case "candlestick":_4f2.x=o.x;_4f2.y=o.y;_4f2.w=o.width;_4f2.h=o.height;break;default:if(!this.angles){var _4f4=typeof o.run.data[0]=="number"?df.map(o.run.data,"x ? Math.max(x, 0) : 0"):df.map(o.run.data,"x ? Math.max(x.y, 0) : 0");this.angles=df.map(df.scanl(_4f4,"+",0),"* 2 * Math.PI / this",df.foldl(_4f4,"+",0));}var _4f5=m._degToRad(o.plot.opt.startAngle),_4f6=(this.angles[o.index]+this.angles[o.index+1])/2+_4f5;_4f2.x=o.cx+o.cr*Math.cos(_4f6);_4f2.y=o.cy+o.cr*Math.sin(_4f6);_4f2.w=_4f2.h=1;if(_4f5&&(_4f6<0||_4f6>2*Math.PI)){_4f6=Math.abs(2*Math.PI-Math.abs(_4f6));}if(_4f6<pi4){}else{if(_4f6<pi2+pi4){_4f3=["below-centered","above-centered"];}else{if(_4f6<Math.PI+pi4){_4f3=["before-centered","after-centered"];}else{if(_4f6<2*Math.PI-pi4){_4f3=["above-centered","below-centered"];}}}}break;}if(has("dojo-bidi")){this._recheckPosition(o,_4f2,_4f3);}var lt=this.chart.getCoords();_4f2.x+=lt.x;_4f2.y+=lt.y;_4f2.x=Math.round(_4f2.x);_4f2.y=Math.round(_4f2.y);_4f2.w=Math.ceil(_4f2.w);_4f2.h=Math.ceil(_4f2.h);this.aroundRect=_4f2;var _4f7=this.text(o,this.plot);if(_4f7){_4e9.show(this._format(_4f7),this.aroundRect,_4f3);}if(!this.mouseOver){this._handle=hub.connect(win.doc,"onclick",this,"onClick");}},onClick:function(){this.process({type:"onmouseout"});},_recheckPosition:function(obj,rect,_4f8){},_format:function(_4f9){return _4f9;}});return has("dojo-bidi")?_4ea("dojox.charting.action2d.Tooltip",[_4ef,_4ed]):_4ef;});},"dojox/gfx":function(){define(["dojo/_base/lang","./gfx/_base","./gfx/renderer!"],function(lang,_4fa,_4fb){_4fa.switchTo(_4fb);return _4fa;});},"dojox/gfx/shape":function(){define(["./_base","dojo/_base/lang","dojo/_base/declare","dojo/_base/kernel","dojo/_base/sniff","dojo/on","dojo/_base/array","dojo/dom-construct","dojo/_base/Color","./matrix"],function(g,lang,_4fc,_4fd,has,on,arr,_4fe,_4ff,_500){var _501=g.shape={};_501.Shape=_4fc("dojox.gfx.shape.Shape",null,{constructor:function(){this.rawNode=null;this.shape=null;this.matrix=null;this.fillStyle=null;this.strokeStyle=null;this.bbox=null;this.parent=null;this.parentMatrix=null;if(has("gfxRegistry")){var uid=_501.register(this);this.getUID=function(){return uid;};}},destroy:function(){if(has("gfxRegistry")){_501.dispose(this);}if(this.rawNode&&"__gfxObject__" in this.rawNode){this.rawNode.__gfxObject__=null;}this.rawNode=null;},getNode:function(){return this.rawNode;},getShape:function(){return this.shape;},getTransform:function(){return this.matrix;},getFill:function(){return this.fillStyle;},getStroke:function(){return this.strokeStyle;},getParent:function(){return this.parent;},getBoundingBox:function(){return this.bbox;},getTransformedBoundingBox:function(){var b=this.getBoundingBox();if(!b){return null;}var m=this._getRealMatrix(),gm=_500;return [gm.multiplyPoint(m,b.x,b.y),gm.multiplyPoint(m,b.x+b.width,b.y),gm.multiplyPoint(m,b.x+b.width,b.y+b.height),gm.multiplyPoint(m,b.x,b.y+b.height)];},getEventSource:function(){return this.rawNode;},setClip:function(clip){this.clip=clip;},getClip:function(){return this.clip;},setShape:function(_502){this.shape=g.makeParameters(this.shape,_502);this.bbox=null;return this;},setFill:function(fill){if(!fill){this.fillStyle=null;return this;}var f=null;if(typeof (fill)=="object"&&"type" in fill){switch(fill.type){case "linear":f=g.makeParameters(g.defaultLinearGradient,fill);break;case "radial":f=g.makeParameters(g.defaultRadialGradient,fill);break;case "pattern":f=g.makeParameters(g.defaultPattern,fill);break;}}else{f=g.normalizeColor(fill);}this.fillStyle=f;return this;},setStroke:function(_503){if(!_503){this.strokeStyle=null;return this;}if(typeof _503=="string"||lang.isArray(_503)||_503 instanceof _4ff){_503={color:_503};}var s=this.strokeStyle=g.makeParameters(g.defaultStroke,_503);s.color=g.normalizeColor(s.color);return this;},setTransform:function(_504){this.matrix=_500.clone(_504?_500.normalize(_504):_500.identity);return this._applyTransform();},_applyTransform:function(){return this;},moveToFront:function(){var p=this.getParent();if(p){p._moveChildToFront(this);this._moveToFront();}return this;},moveToBack:function(){var p=this.getParent();if(p){p._moveChildToBack(this);this._moveToBack();}return this;},_moveToFront:function(){},_moveToBack:function(){},applyRightTransform:function(_505){return _505?this.setTransform([this.matrix,_505]):this;},applyLeftTransform:function(_506){return _506?this.setTransform([_506,this.matrix]):this;},applyTransform:function(_507){return _507?this.setTransform([this.matrix,_507]):this;},removeShape:function(_508){if(this.parent){this.parent.remove(this,_508);}return this;},_setParent:function(_509,_50a){this.parent=_509;return this._updateParentMatrix(_50a);},_updateParentMatrix:function(_50b){this.parentMatrix=_50b?_500.clone(_50b):null;return this._applyTransform();},_getRealMatrix:function(){var m=this.matrix;var p=this.parent;while(p){if(p.matrix){m=_500.multiply(p.matrix,m);}p=p.parent;}return m;}});_501._eventsProcessing={on:function(type,_50c){return on(this.getEventSource(),type,_501.fixCallback(this,g.fixTarget,_50c));},connect:function(name,_50d,_50e){if(name.substring(0,2)=="on"){name=name.substring(2);}return this.on(name,_50e?lang.hitch(_50d,_50e):_50d);},disconnect:function(_50f){return _50f.remove();}};_501.fixCallback=function(_510,_511,_512,_513){if(!_513){_513=_512;_512=null;}if(lang.isString(_513)){_512=_512||_4fd.global;if(!_512[_513]){throw (["dojox.gfx.shape.fixCallback: scope[\"",_513,"\"] is null (scope=\"",_512,"\")"].join(""));}return function(e){return _511(e,_510)?_512[_513].apply(_512,arguments||[]):undefined;};}return !_512?function(e){return _511(e,_510)?_513.apply(_512,arguments):undefined;}:function(e){return _511(e,_510)?_513.apply(_512,arguments||[]):undefined;};};lang.extend(_501.Shape,_501._eventsProcessing);_501.Container={_init:function(){this.children=[];this._batch=0;},openBatch:function(){return this;},closeBatch:function(){return this;},add:function(_514){var _515=_514.getParent();if(_515){_515.remove(_514,true);}this.children.push(_514);return _514._setParent(this,this._getRealMatrix());},remove:function(_516,_517){for(var i=0;i<this.children.length;++i){if(this.children[i]==_516){if(_517){}else{_516.parent=null;_516.parentMatrix=null;}this.children.splice(i,1);break;}}return this;},clear:function(_518){var _519;for(var i=0;i<this.children.length;++i){_519=this.children[i];_519.parent=null;_519.parentMatrix=null;if(_518){_519.destroy();}}this.children=[];return this;},getBoundingBox:function(){if(this.children){var _51a=null;arr.forEach(this.children,function(_51b){var bb=_51b.getBoundingBox();if(bb){var ct=_51b.getTransform();if(ct){bb=_500.multiplyRectangle(ct,bb);}if(_51a){_51a.x=Math.min(_51a.x,bb.x);_51a.y=Math.min(_51a.y,bb.y);_51a.endX=Math.max(_51a.endX,bb.x+bb.width);_51a.endY=Math.max(_51a.endY,bb.y+bb.height);}else{_51a={x:bb.x,y:bb.y,endX:bb.x+bb.width,endY:bb.y+bb.height};}}});if(_51a){_51a.width=_51a.endX-_51a.x;_51a.height=_51a.endY-_51a.y;}return _51a;}return null;},_moveChildToFront:function(_51c){for(var i=0;i<this.children.length;++i){if(this.children[i]==_51c){this.children.splice(i,1);this.children.push(_51c);break;}}return this;},_moveChildToBack:function(_51d){for(var i=0;i<this.children.length;++i){if(this.children[i]==_51d){this.children.splice(i,1);this.children.unshift(_51d);break;}}return this;}};_501.Surface=_4fc("dojox.gfx.shape.Surface",null,{constructor:function(){this.rawNode=null;this._parent=null;this._nodes=[];this._events=[];},destroy:function(){arr.forEach(this._nodes,_4fe.destroy);this._nodes=[];arr.forEach(this._events,function(h){if(h){h.remove();}});this._events=[];this.rawNode=null;if(has("ie")){while(this._parent.lastChild){_4fe.destroy(this._parent.lastChild);}}else{this._parent.innerHTML="";}this._parent=null;},getEventSource:function(){return this.rawNode;},_getRealMatrix:function(){return null;},isLoaded:true,onLoad:function(_51e){},whenLoaded:function(_51f,_520){var f=lang.hitch(_51f,_520);if(this.isLoaded){f(this);}else{on.once(this,"load",function(_521){f(_521);});}}});lang.extend(_501.Surface,_501._eventsProcessing);_501.Rect=_4fc("dojox.gfx.shape.Rect",_501.Shape,{constructor:function(_522){this.shape=g.getDefault("Rect");this.rawNode=_522;},getBoundingBox:function(){return this.shape;}});_501.Ellipse=_4fc("dojox.gfx.shape.Ellipse",_501.Shape,{constructor:function(_523){this.shape=g.getDefault("Ellipse");this.rawNode=_523;},getBoundingBox:function(){if(!this.bbox){var _524=this.shape;this.bbox={x:_524.cx-_524.rx,y:_524.cy-_524.ry,width:2*_524.rx,height:2*_524.ry};}return this.bbox;}});_501.Circle=_4fc("dojox.gfx.shape.Circle",_501.Shape,{constructor:function(_525){this.shape=g.getDefault("Circle");this.rawNode=_525;},getBoundingBox:function(){if(!this.bbox){var _526=this.shape;this.bbox={x:_526.cx-_526.r,y:_526.cy-_526.r,width:2*_526.r,height:2*_526.r};}return this.bbox;}});_501.Line=_4fc("dojox.gfx.shape.Line",_501.Shape,{constructor:function(_527){this.shape=g.getDefault("Line");this.rawNode=_527;},getBoundingBox:function(){if(!this.bbox){var _528=this.shape;this.bbox={x:Math.min(_528.x1,_528.x2),y:Math.min(_528.y1,_528.y2),width:Math.abs(_528.x2-_528.x1),height:Math.abs(_528.y2-_528.y1)};}return this.bbox;}});_501.Polyline=_4fc("dojox.gfx.shape.Polyline",_501.Shape,{constructor:function(_529){this.shape=g.getDefault("Polyline");this.rawNode=_529;},setShape:function(_52a,_52b){if(_52a&&_52a instanceof Array){this.inherited(arguments,[{points:_52a}]);if(_52b&&this.shape.points.length){this.shape.points.push(this.shape.points[0]);}}else{this.inherited(arguments,[_52a]);}return this;},_normalizePoints:function(){var p=this.shape.points,l=p&&p.length;if(l&&typeof p[0]=="number"){var _52c=[];for(var i=0;i<l;i+=2){_52c.push({x:p[i],y:p[i+1]});}this.shape.points=_52c;}},getBoundingBox:function(){if(!this.bbox&&this.shape.points.length){var p=this.shape.points;var l=p.length;var t=p[0];var bbox={l:t.x,t:t.y,r:t.x,b:t.y};for(var i=1;i<l;++i){t=p[i];if(bbox.l>t.x){bbox.l=t.x;}if(bbox.r<t.x){bbox.r=t.x;}if(bbox.t>t.y){bbox.t=t.y;}if(bbox.b<t.y){bbox.b=t.y;}}this.bbox={x:bbox.l,y:bbox.t,width:bbox.r-bbox.l,height:bbox.b-bbox.t};}return this.bbox;}});_501.Image=_4fc("dojox.gfx.shape.Image",_501.Shape,{constructor:function(_52d){this.shape=g.getDefault("Image");this.rawNode=_52d;},getBoundingBox:function(){return this.shape;},setStroke:function(){return this;},setFill:function(){return this;}});_501.Text=_4fc(_501.Shape,{constructor:function(_52e){this.fontStyle=null;this.shape=g.getDefault("Text");this.rawNode=_52e;},getFont:function(){return this.fontStyle;},setFont:function(_52f){this.fontStyle=typeof _52f=="string"?g.splitFontString(_52f):g.makeParameters(g.defaultFont,_52f);this._setFont();return this;},getBoundingBox:function(){var bbox=null,s=this.getShape();if(s.text){bbox=g._base._computeTextBoundingBox(this);}return bbox;}});_501.Creator={createShape:function(_530){switch(_530.type){case g.defaultPath.type:return this.createPath(_530);case g.defaultRect.type:return this.createRect(_530);case g.defaultCircle.type:return this.createCircle(_530);case g.defaultEllipse.type:return this.createEllipse(_530);case g.defaultLine.type:return this.createLine(_530);case g.defaultPolyline.type:return this.createPolyline(_530);case g.defaultImage.type:return this.createImage(_530);case g.defaultText.type:return this.createText(_530);case g.defaultTextPath.type:return this.createTextPath(_530);}return null;},createGroup:function(){return this.createObject(g.Group);},createRect:function(rect){return this.createObject(g.Rect,rect);},createEllipse:function(_531){return this.createObject(g.Ellipse,_531);},createCircle:function(_532){return this.createObject(g.Circle,_532);},createLine:function(line){return this.createObject(g.Line,line);},createPolyline:function(_533){return this.createObject(g.Polyline,_533);},createImage:function(_534){return this.createObject(g.Image,_534);},createText:function(text){return this.createObject(g.Text,text);},createPath:function(path){return this.createObject(g.Path,path);},createTextPath:function(text){return this.createObject(g.TextPath,{}).setText(text);},createObject:function(_535,_536){return null;}};return _501;});},"dojox/charting/Chart2D":function(){define(["dojo/_base/kernel","dojo/_base/lang","..","./Chart","./axis2d/Default","./axis2d/Invisible","./plot2d/Default","./plot2d/Lines","./plot2d/Areas","./plot2d/Markers","./plot2d/MarkersOnly","./plot2d/Scatter","./plot2d/Stacked","./plot2d/StackedLines","./plot2d/StackedAreas","./plot2d/Columns","./plot2d/StackedColumns","./plot2d/ClusteredColumns","./plot2d/Bars","./plot2d/StackedBars","./plot2d/ClusteredBars","./plot2d/Grid","./plot2d/Pie","./plot2d/Bubble","./plot2d/Candlesticks","./plot2d/OHLC","./plot2d/Spider"],function(_537,lang,_538,_539){_537.deprecated("dojox.charting.Chart2D","Use dojox.charting.Chart instead and require all other components explicitly","2.0");return lang.setObject("dojox.charting.Chart2D",_539);});},"dojox/charting/scaler/linear":function(){define(["dojo/_base/lang","./common"],function(lang,_53a){var _53b=lang.getObject("dojox.charting.scaler.linear",true);var _53c=3,_53d=_53a.getNumericLabel;function _53e(val,text){val=val.toLowerCase();for(var i=text.length-1;i>=0;--i){if(val===text[i]){return true;}}return false;};var _53f=function(min,max,_540,_541,_542,_543,span){_540=lang.delegate(_540);if(!_541){if(_540.fixUpper=="major"){_540.fixUpper="minor";}if(_540.fixLower=="major"){_540.fixLower="minor";}}if(!_542){if(_540.fixUpper=="minor"){_540.fixUpper="micro";}if(_540.fixLower=="minor"){_540.fixLower="micro";}}if(!_543){if(_540.fixUpper=="micro"){_540.fixUpper="none";}if(_540.fixLower=="micro"){_540.fixLower="none";}}var _544=_53e(_540.fixLower,["major"])?Math.floor(_540.min/_541)*_541:_53e(_540.fixLower,["minor"])?Math.floor(_540.min/_542)*_542:_53e(_540.fixLower,["micro"])?Math.floor(_540.min/_543)*_543:_540.min,_545=_53e(_540.fixUpper,["major"])?Math.ceil(_540.max/_541)*_541:_53e(_540.fixUpper,["minor"])?Math.ceil(_540.max/_542)*_542:_53e(_540.fixUpper,["micro"])?Math.ceil(_540.max/_543)*_543:_540.max;if(_540.useMin){min=_544;}if(_540.useMax){max=_545;}var _546=(!_541||_540.useMin&&_53e(_540.fixLower,["major"]))?min:Math.ceil(min/_541)*_541,_547=(!_542||_540.useMin&&_53e(_540.fixLower,["major","minor"]))?min:Math.ceil(min/_542)*_542,_548=(!_543||_540.useMin&&_53e(_540.fixLower,["major","minor","micro"]))?min:Math.ceil(min/_543)*_543,_549=!_541?0:(_540.useMax&&_53e(_540.fixUpper,["major"])?Math.round((max-_546)/_541):Math.floor((max-_546)/_541))+1,_54a=!_542?0:(_540.useMax&&_53e(_540.fixUpper,["major","minor"])?Math.round((max-_547)/_542):Math.floor((max-_547)/_542))+1,_54b=!_543?0:(_540.useMax&&_53e(_540.fixUpper,["major","minor","micro"])?Math.round((max-_548)/_543):Math.floor((max-_548)/_543))+1,_54c=_542?Math.round(_541/_542):0,_54d=_543?Math.round(_542/_543):0,_54e=_541?Math.floor(Math.log(_541)/Math.LN10):0,_54f=_542?Math.floor(Math.log(_542)/Math.LN10):0,_550=span/(max-min);if(!isFinite(_550)){_550=1;}return {bounds:{lower:_544,upper:_545,from:min,to:max,scale:_550,span:span},major:{tick:_541,start:_546,count:_549,prec:_54e},minor:{tick:_542,start:_547,count:_54a,prec:_54f},micro:{tick:_543,start:_548,count:_54b,prec:0},minorPerMajor:_54c,microPerMinor:_54d,scaler:_53b};};return lang.mixin(_53b,{buildScaler:function(min,max,span,_551,_552,_553){var h={fixUpper:"none",fixLower:"none",natural:false};if(_551){if("fixUpper" in _551){h.fixUpper=String(_551.fixUpper);}if("fixLower" in _551){h.fixLower=String(_551.fixLower);}if("natural" in _551){h.natural=Boolean(_551.natural);}}_553=!_553||_553<_53c?_53c:_553;if("min" in _551){min=_551.min;}if("max" in _551){max=_551.max;}if(_551.includeZero){if(min>0){min=0;}if(max<0){max=0;}}h.min=min;h.useMin=true;h.max=max;h.useMax=true;if("from" in _551){min=_551.from;h.useMin=false;}if("to" in _551){max=_551.to;h.useMax=false;}if(max<=min){return _53f(min,max,h,0,0,0,span);}if(!_552){_552=max-min;}var mag=Math.floor(Math.log(_552)/Math.LN10),_554=_551&&("majorTickStep" in _551)?_551.majorTickStep:Math.pow(10,mag),_555=0,_556=0,_557;if(_551&&("minorTickStep" in _551)){_555=_551.minorTickStep;}else{do{_555=_554/10;if(!h.natural||_555>0.9){_557=_53f(min,max,h,_554,_555,0,span);if(_557.bounds.scale*_557.minor.tick>_553){break;}}_555=_554/5;if(!h.natural||_555>0.9){_557=_53f(min,max,h,_554,_555,0,span);if(_557.bounds.scale*_557.minor.tick>_553){break;}}_555=_554/2;if(!h.natural||_555>0.9){_557=_53f(min,max,h,_554,_555,0,span);if(_557.bounds.scale*_557.minor.tick>_553){break;}}return _53f(min,max,h,_554,0,0,span);}while(false);}if(_551&&("microTickStep" in _551)){_556=_551.microTickStep;_557=_53f(min,max,h,_554,_555,_556,span);}else{do{_556=_555/10;if(!h.natural||_556>0.9){_557=_53f(min,max,h,_554,_555,_556,span);if(_557.bounds.scale*_557.micro.tick>_53c){break;}}_556=_555/5;if(!h.natural||_556>0.9){_557=_53f(min,max,h,_554,_555,_556,span);if(_557.bounds.scale*_557.micro.tick>_53c){break;}}_556=_555/2;if(!h.natural||_556>0.9){_557=_53f(min,max,h,_554,_555,_556,span);if(_557.bounds.scale*_557.micro.tick>_53c){break;}}_556=0;}while(false);}return _556?_557:_53f(min,max,h,_554,_555,0,span);},buildTicks:function(_558,_559){var step,next,tick,_55a=_558.major.start,_55b=_558.minor.start,_55c=_558.micro.start;if(_559.microTicks&&_558.micro.tick){step=_558.micro.tick,next=_55c;}else{if(_559.minorTicks&&_558.minor.tick){step=_558.minor.tick,next=_55b;}else{if(_558.major.tick){step=_558.major.tick,next=_55a;}else{return null;}}}var _55d=1/_558.bounds.scale;if(_558.bounds.to<=_558.bounds.from||isNaN(_55d)||!isFinite(_55d)||step<=0||isNaN(step)||!isFinite(step)){return null;}var _55e=[],_55f=[],_560=[];while(next<=_558.bounds.to+_55d){if(Math.abs(_55a-next)<step/2){tick={value:_55a};if(_559.majorLabels){tick.label=_53d(_55a,_558.major.prec,_559);}_55e.push(tick);_55a+=_558.major.tick;_55b+=_558.minor.tick;_55c+=_558.micro.tick;}else{if(Math.abs(_55b-next)<step/2){if(_559.minorTicks){tick={value:_55b};if(_559.minorLabels&&(_558.minMinorStep<=_558.minor.tick*_558.bounds.scale)){tick.label=_53d(_55b,_558.minor.prec,_559);}_55f.push(tick);}_55b+=_558.minor.tick;_55c+=_558.micro.tick;}else{if(_559.microTicks){_560.push({value:_55c});}_55c+=_558.micro.tick;}}next+=step;}return {major:_55e,minor:_55f,micro:_560};},getTransformerFromModel:function(_561){var _562=_561.bounds.from,_563=_561.bounds.scale;return function(x){return (x-_562)*_563;};},getTransformerFromPlot:function(_564){var _565=_564.bounds.from,_566=_564.bounds.scale;return function(x){return x/_566+_565;};}});});},"dojox/gfx/renderer":function(){define(["./_base","dojo/_base/lang","dojo/_base/sniff","dojo/_base/window","dojo/_base/config"],function(g,lang,has,win,_567){var _568=null;has.add("vml",function(_569,_56a,_56b){_56b.innerHTML="<v:shape adj=\"1\"/>";var _56c=("adj" in _56b.firstChild);_56b.innerHTML="";return _56c;});return {load:function(id,_56d,load){if(_568&&id!="force"){load(_568);return;}var _56e=_567.forceGfxRenderer,_56f=!_56e&&(lang.isString(_567.gfxRenderer)?_567.gfxRenderer:"svg,vml,canvas,silverlight").split(","),_570,_571;while(!_56e&&_56f.length){switch(_56f.shift()){case "svg":if("SVGAngle" in win.global){_56e="svg";}break;case "vml":if(has("vml")){_56e="vml";}break;case "silverlight":try{if(has("ie")){_570=new ActiveXObject("AgControl.AgControl");if(_570&&_570.IsVersionSupported("1.0")){_571=true;}}else{if(navigator.plugins["Silverlight Plug-In"]){_571=true;}}}catch(e){_571=false;}finally{_570=null;}if(_571){_56e="silverlight";}break;case "canvas":if(win.global.CanvasRenderingContext2D){_56e="canvas";}break;}}if(_56e==="canvas"&&_567.canvasEvents!==false){_56e="canvasWithEvents";}if(_567.isDebug){}function _572(){_56d(["dojox/gfx/"+_56e],function(_573){g.renderer=_56e;_568=_573;load(_573);});};if(_56e=="svg"&&typeof window.svgweb!="undefined"){window.svgweb.addOnLoad(_572);}else{_572();}}};});},"dojox/charting/widget/Chart":function(){define(["dojo/_base/kernel","dojo/_base/lang","dojo/_base/array","dojo/dom-attr","dojo/_base/declare","dojo/query","dijit/_WidgetBase","../Chart","dojo/has","dojo/has!dojo-bidi?../bidi/widget/Chart","dojox/lang/utils","dojox/lang/functional","dojox/lang/functional/lambda"],function(_574,lang,arr,_575,_576,_577,_578,_579,has,_57a,du,df,dfl){var _57b,_57c,_57d,_57e,_57f,_580=function(o){return o;},dc=lang.getObject("dojox.charting");_57b=function(node,type,kw){var dp=eval("("+type+".prototype.defaultParams)");var x,attr;for(x in dp){if(x in kw){continue;}attr=node.getAttribute(x);kw[x]=du.coerceType(dp[x],attr==null||typeof attr=="undefined"?dp[x]:attr);}var op=eval("("+type+".prototype.optionalParams)");for(x in op){if(x in kw){continue;}attr=node.getAttribute(x);if(attr!=null){kw[x]=du.coerceType(op[x],attr);}}};_57c=function(node){var name=node.getAttribute("name"),type=node.getAttribute("type");if(!name){return null;}var o={name:name,kwArgs:{}},kw=o.kwArgs;if(type){if(dc.axis2d[type]){type=_574._scopeName+"x.charting.axis2d."+type;}var axis=eval("("+type+")");if(axis){kw.type=axis;}}else{type=_574._scopeName+"x.charting.axis2d.Default";}_57b(node,type,kw);if(kw.font||kw.fontColor){if(!kw.tick){kw.tick={};}if(kw.font){kw.tick.font=kw.font;}if(kw.fontColor){kw.tick.fontColor=kw.fontColor;}}return o;};_57d=function(node){var name=node.getAttribute("name"),type=node.getAttribute("type");if(!name){return null;}var o={name:name,kwArgs:{}},kw=o.kwArgs;if(type){if(dc.plot2d&&dc.plot2d[type]){type=_574._scopeName+"x.charting.plot2d."+type;}var plot=eval("("+type+")");if(plot){kw.type=plot;}}else{type=_574._scopeName+"x.charting.plot2d.Default";}_57b(node,type,kw);var dp=eval("("+type+".prototype.baseParams)");var x,attr;for(x in dp){if(x in kw){continue;}attr=node.getAttribute(x);kw[x]=du.coerceType(dp[x],attr==null||typeof attr=="undefined"?dp[x]:attr);}return o;};_57e=function(node){var plot=node.getAttribute("plot"),type=node.getAttribute("type");if(!plot){plot="default";}var o={plot:plot,kwArgs:{}},kw=o.kwArgs;if(type){if(dc.action2d[type]){type=_574._scopeName+"x.charting.action2d."+type;}var _581=eval("("+type+")");if(!_581){return null;}o.action=_581;}else{return null;}_57b(node,type,kw);return o;};_57f=function(node){var ga=lang.partial(_575.get,node);var name=ga("name");if(!name){return null;}var o={name:name,kwArgs:{}},kw=o.kwArgs,t;t=ga("plot");if(t!=null){kw.plot=t;}t=ga("marker");if(t!=null){kw.marker=t;}t=ga("stroke");if(t!=null){kw.stroke=eval("("+t+")");}t=ga("outline");if(t!=null){kw.outline=eval("("+t+")");}t=ga("shadow");if(t!=null){kw.shadow=eval("("+t+")");}t=ga("fill");if(t!=null){kw.fill=eval("("+t+")");}t=ga("font");if(t!=null){kw.font=t;}t=ga("fontColor");if(t!=null){kw.fontColor=eval("("+t+")");}t=ga("legend");if(t!=null){kw.legend=t;}t=ga("data");if(t!=null){o.type="data";o.data=t?arr.map(String(t).split(","),Number):[];return o;}t=ga("array");if(t!=null){o.type="data";o.data=eval("("+t+")");return o;}t=ga("store");if(t!=null){o.type="store";o.data=eval("("+t+")");t=ga("field");o.field=t!=null?t:"value";t=ga("query");if(!!t){kw.query=t;}t=ga("queryOptions");if(!!t){kw.queryOptions=eval("("+t+")");}t=ga("start");if(!!t){kw.start=Number(t);}t=ga("count");if(!!t){kw.count=Number(t);}t=ga("sort");if(!!t){kw.sort=eval("("+t+")");}t=ga("valueFn");if(!!t){kw.valueFn=dfl.lambda(t);}return o;}return null;};var _582=_576(has("dojo-bidi")?"dojox.charting.widget.NonBidiChart":"dojox.charting.widget.Chart",_578,{theme:null,margins:null,stroke:undefined,fill:undefined,buildRendering:function(){this.inherited(arguments);var n=this.domNode;var axes=_577("> .axis",n).map(_57c).filter(_580),_583=_577("> .plot",n).map(_57d).filter(_580),_584=_577("> .action",n).map(_57e).filter(_580),_585=_577("> .series",n).map(_57f).filter(_580);n.innerHTML="";var c=this.chart=new _579(n,{margins:this.margins,stroke:this.stroke,fill:this.fill,textDir:this.textDir});if(this.theme){c.setTheme(this.theme);}axes.forEach(function(axis){c.addAxis(axis.name,axis.kwArgs);});_583.forEach(function(plot){c.addPlot(plot.name,plot.kwArgs);});this.actions=_584.map(function(_586){return new _586.action(c,_586.plot,_586.kwArgs);});var _587=df.foldl(_585,function(_588,_589){if(_589.type=="data"){c.addSeries(_589.name,_589.data,_589.kwArgs);_588=true;}else{c.addSeries(_589.name,[0],_589.kwArgs);var kw={};du.updateWithPattern(kw,_589.kwArgs,{"query":"","queryOptions":null,"start":0,"count":1},true);if(_589.kwArgs.sort){kw.sort=lang.clone(_589.kwArgs.sort);}lang.mixin(kw,{onComplete:function(data){var _58a;if("valueFn" in _589.kwArgs){var fn=_589.kwArgs.valueFn;_58a=arr.map(data,function(x){return fn(_589.data.getValue(x,_589.field,0));});}else{_58a=arr.map(data,function(x){return _589.data.getValue(x,_589.field,0);});}c.addSeries(_589.name,_58a,_589.kwArgs).render();}});_589.data.fetch(kw);}return _588;},false);if(_587){c.render();}},destroy:function(){this.chart.destroy();this.inherited(arguments);},resize:function(box){this.chart.resize.apply(this.chart,arguments);}});return has("dojo-bidi")?_576("dojox.charting.widget.Chart",[_582,_57a]):_582;});},"dojox/lang/functional":function(){define(["./functional/lambda","./functional/array","./functional/object"],function(df){return df;});},"dojox/charting/scaler/common":function(){define(["dojo/_base/lang"],function(lang){var eq=function(a,b){return Math.abs(a-b)<=0.000001*(Math.abs(a)+Math.abs(b));};var _58b=lang.getObject("dojox.charting.scaler.common",true);var _58c={};return lang.mixin(_58b,{doIfLoaded:function(_58d,_58e,_58f){if(_58c[_58d]==undefined){try{_58c[_58d]=require(_58d);}catch(e){_58c[_58d]=null;}}if(_58c[_58d]){return _58e(_58c[_58d]);}else{return _58f();}},getNumericLabel:function(_590,_591,_592){var def="";_58b.doIfLoaded("dojo/number",function(_593){def=(_592.fixed?_593.format(_590,{places:_591<0?-_591:0}):_593.format(_590))||"";},function(){def=_592.fixed?_590.toFixed(_591<0?-_591:0):_590.toString();});if(_592.labelFunc){var r=_592.labelFunc(def,_590,_591);if(r){return r;}}if(_592.labels){var l=_592.labels,lo=0,hi=l.length;while(lo<hi){var mid=Math.floor((lo+hi)/2),val=l[mid].value;if(val<_590){lo=mid+1;}else{hi=mid;}}if(lo<l.length&&eq(l[lo].value,_590)){return l[lo].text;}--lo;if(lo>=0&&lo<l.length&&eq(l[lo].value,_590)){return l[lo].text;}lo+=2;if(lo<l.length&&eq(l[lo].value,_590)){return l[lo].text;}}return def;}});});},"dojox/charting/axis2d/common":function(){define(["dojo/_base/lang","dojo/_base/window","dojo/dom-geometry","dojox/gfx","dojo/has"],function(lang,win,_594,g,has){var _595=lang.getObject("dojox.charting.axis2d.common",true);var _596=function(s){s.marginLeft="0px";s.marginTop="0px";s.marginRight="0px";s.marginBottom="0px";s.paddingLeft="0px";s.paddingTop="0px";s.paddingRight="0px";s.paddingBottom="0px";s.borderLeftWidth="0px";s.borderTopWidth="0px";s.borderRightWidth="0px";s.borderBottomWidth="0px";};var _597=function(n){if(n["getBoundingClientRect"]){var bcr=n.getBoundingClientRect();return bcr.width||(bcr.right-bcr.left);}else{return _594.getMarginBox(n).w;}};return lang.mixin(_595,{createText:{gfx:function(_598,_599,x,y,_59a,text,font,_59b){return _599.createText({x:x,y:y,text:text,align:_59a}).setFont(font).setFill(_59b);},html:function(_59c,_59d,x,y,_59e,text,font,_59f,_5a0){var p=win.doc.createElement("div"),s=p.style,_5a1;if(_59c.getTextDir){p.dir=_59c.getTextDir(text);}_596(s);s.font=font;p.innerHTML=String(text).replace(/\s/g,"&nbsp;");s.color=_59f;s.position="absolute";s.left="-10000px";win.body().appendChild(p);var size=g.normalizedLength(g.splitFontString(font).size);if(!_5a0){_5a1=_597(p);}if(p.dir=="rtl"){x+=_5a0?_5a0:_5a1;}win.body().removeChild(p);s.position="relative";if(_5a0){s.width=_5a0+"px";switch(_59e){case "middle":s.textAlign="center";s.left=(x-_5a0/2)+"px";break;case "end":s.textAlign="right";s.left=(x-_5a0)+"px";break;default:s.left=x+"px";s.textAlign="left";break;}}else{switch(_59e){case "middle":s.left=Math.floor(x-_5a1/2)+"px";break;case "end":s.left=Math.floor(x-_5a1)+"px";break;default:s.left=Math.floor(x)+"px";break;}}s.top=Math.floor(y-size)+"px";s.whiteSpace="nowrap";var wrap=win.doc.createElement("div"),w=wrap.style;_596(w);w.width="0px";w.height="0px";wrap.appendChild(p);_59c.node.insertBefore(wrap,_59c.node.firstChild);if(has("dojo-bidi")){_59c.htmlElementsRegistry.push([wrap,x,y,_59e,text,font,_59f]);}return wrap;}}});});},"dijit/_TemplatedMixin":function(){define(["dojo/cache","dojo/_base/declare","dojo/dom-construct","dojo/_base/lang","dojo/on","dojo/sniff","dojo/string","./_AttachMixin"],function(_5a2,_5a3,_5a4,lang,on,has,_5a5,_5a6){var _5a7=_5a3("dijit._TemplatedMixin",_5a6,{templateString:null,templatePath:null,_skipNodeCache:false,searchContainerNode:true,_stringRepl:function(tmpl){var _5a8=this.declaredClass,_5a9=this;return _5a5.substitute(tmpl,this,function(_5aa,key){if(key.charAt(0)=="!"){_5aa=lang.getObject(key.substr(1),false,_5a9);}if(typeof _5aa=="undefined"){throw new Error(_5a8+" template:"+key);}if(_5aa==null){return "";}return key.charAt(0)=="!"?_5aa:this._escapeValue(""+_5aa);},this);},_escapeValue:function(val){return val.replace(/["'<>&]/g,function(val){return {"&":"&amp;","<":"&lt;",">":"&gt;","\"":"&quot;","'":"&#x27;"}[val];});},buildRendering:function(){if(!this._rendered){if(!this.templateString){this.templateString=_5a2(this.templatePath,{sanitize:true});}var _5ab=_5a7.getCachedTemplate(this.templateString,this._skipNodeCache,this.ownerDocument);var node;if(lang.isString(_5ab)){node=_5a4.toDom(this._stringRepl(_5ab),this.ownerDocument);if(node.nodeType!=1){throw new Error("Invalid template: "+_5ab);}}else{node=_5ab.cloneNode(true);}this.domNode=node;}this.inherited(arguments);if(!this._rendered){this._fillContent(this.srcNodeRef);}this._rendered=true;},_fillContent:function(_5ac){var dest=this.containerNode;if(_5ac&&dest){while(_5ac.hasChildNodes()){dest.appendChild(_5ac.firstChild);}}}});_5a7._templateCache={};_5a7.getCachedTemplate=function(_5ad,_5ae,doc){var _5af=_5a7._templateCache;var key=_5ad;var _5b0=_5af[key];if(_5b0){try{if(!_5b0.ownerDocument||_5b0.ownerDocument==(doc||document)){return _5b0;}}catch(e){}_5a4.destroy(_5b0);}_5ad=_5a5.trim(_5ad);if(_5ae||_5ad.match(/\$\{([^\}]+)\}/g)){return (_5af[key]=_5ad);}else{var node=_5a4.toDom(_5ad,doc);if(node.nodeType!=1){throw new Error("Invalid template: "+_5ad);}return (_5af[key]=node);}};if(has("ie")){on(window,"unload",function(){var _5b1=_5a7._templateCache;for(var key in _5b1){var _5b2=_5b1[key];if(typeof _5b2=="object"){_5a4.destroy(_5b2);}delete _5b1[key];}});}return _5a7;});},"dojox/lang/functional/object":function(){define(["dojo/_base/kernel","dojo/_base/lang","./lambda"],function(_5b3,lang,df){var _5b4={};lang.mixin(df,{keys:function(obj){var t=[];for(var i in obj){if(!(i in _5b4)){t.push(i);}}return t;},values:function(obj){var t=[];for(var i in obj){if(!(i in _5b4)){t.push(obj[i]);}}return t;},filterIn:function(obj,f,o){o=o||_5b3.global;f=df.lambda(f);var t={},v,i;for(i in obj){if(!(i in _5b4)){v=obj[i];if(f.call(o,v,i,obj)){t[i]=v;}}}return t;},forIn:function(obj,f,o){o=o||_5b3.global;f=df.lambda(f);for(var i in obj){if(!(i in _5b4)){f.call(o,obj[i],i,obj);}}return o;},mapIn:function(obj,f,o){o=o||_5b3.global;f=df.lambda(f);var t={},i;for(i in obj){if(!(i in _5b4)){t[i]=f.call(o,obj[i],i,obj);}}return t;}});return df;});},"dojo/window":function(){define(["./_base/lang","./sniff","./_base/window","./dom","./dom-geometry","./dom-style","./dom-construct"],function(lang,has,_5b5,dom,geom,_5b6,_5b7){has.add("rtl-adjust-position-for-verticalScrollBar",function(win,doc){var body=_5b5.body(doc),_5b8=_5b7.create("div",{style:{overflow:"scroll",overflowX:"visible",direction:"rtl",visibility:"hidden",position:"absolute",left:"0",top:"0",width:"64px",height:"64px"}},body,"last"),div=_5b7.create("div",{style:{overflow:"hidden",direction:"ltr"}},_5b8,"last"),ret=geom.position(div).x!=0;_5b8.removeChild(div);body.removeChild(_5b8);return ret;});has.add("position-fixed-support",function(win,doc){var body=_5b5.body(doc),_5b9=_5b7.create("span",{style:{visibility:"hidden",position:"fixed",left:"1px",top:"1px"}},body,"last"),_5ba=_5b7.create("span",{style:{position:"fixed",left:"0",top:"0"}},_5b9,"last"),ret=geom.position(_5ba).x!=geom.position(_5b9).x;_5b9.removeChild(_5ba);body.removeChild(_5b9);return ret;});var _5bb={getBox:function(doc){doc=doc||_5b5.doc;var _5bc=(doc.compatMode=="BackCompat")?_5b5.body(doc):doc.documentElement,_5bd=geom.docScroll(doc),w,h;if(has("touch")){var _5be=_5bb.get(doc);w=_5be.innerWidth||_5bc.clientWidth;h=_5be.innerHeight||_5bc.clientHeight;}else{w=_5bc.clientWidth;h=_5bc.clientHeight;}return {l:_5bd.x,t:_5bd.y,w:w,h:h};},get:function(doc){if(has("ie")&&_5bb!==document.parentWindow){doc.parentWindow.execScript("document._parentWindow = window;","Javascript");var win=doc._parentWindow;doc._parentWindow=null;return win;}return doc.parentWindow||doc.defaultView;},scrollIntoView:function(node,pos){try{node=dom.byId(node);var doc=node.ownerDocument||_5b5.doc,body=_5b5.body(doc),html=doc.documentElement||body.parentNode,isIE=has("ie"),isWK=has("webkit");if(node==body||node==html){return;}if(!(has("mozilla")||isIE||isWK||has("opera")||has("trident"))&&("scrollIntoView" in node)){node.scrollIntoView(false);return;}var _5bf=doc.compatMode=="BackCompat",_5c0=Math.min(body.clientWidth||html.clientWidth,html.clientWidth||body.clientWidth),_5c1=Math.min(body.clientHeight||html.clientHeight,html.clientHeight||body.clientHeight),_5c2=(isWK||_5bf)?body:html,_5c3=pos||geom.position(node),el=node.parentNode,_5c4=function(el){return (isIE<=6||(isIE==7&&_5bf))?false:(has("position-fixed-support")&&(_5b6.get(el,"position").toLowerCase()=="fixed"));},self=this,_5c5=function(el,x,y){if(el.tagName=="BODY"||el.tagName=="HTML"){self.get(el.ownerDocument).scrollBy(x,y);}else{x&&(el.scrollLeft+=x);y&&(el.scrollTop+=y);}};if(_5c4(node)){return;}while(el){if(el==body){el=_5c2;}var _5c6=geom.position(el),_5c7=_5c4(el),rtl=_5b6.getComputedStyle(el).direction.toLowerCase()=="rtl";if(el==_5c2){_5c6.w=_5c0;_5c6.h=_5c1;if(_5c2==html&&(isIE||has("trident"))&&rtl){_5c6.x+=_5c2.offsetWidth-_5c6.w;}if(_5c6.x<0||!isIE||isIE>=9||has("trident")){_5c6.x=0;}if(_5c6.y<0||!isIE||isIE>=9||has("trident")){_5c6.y=0;}}else{var pb=geom.getPadBorderExtents(el);_5c6.w-=pb.w;_5c6.h-=pb.h;_5c6.x+=pb.l;_5c6.y+=pb.t;var _5c8=el.clientWidth,_5c9=_5c6.w-_5c8;if(_5c8>0&&_5c9>0){if(rtl&&has("rtl-adjust-position-for-verticalScrollBar")){_5c6.x+=_5c9;}_5c6.w=_5c8;}_5c8=el.clientHeight;_5c9=_5c6.h-_5c8;if(_5c8>0&&_5c9>0){_5c6.h=_5c8;}}if(_5c7){if(_5c6.y<0){_5c6.h+=_5c6.y;_5c6.y=0;}if(_5c6.x<0){_5c6.w+=_5c6.x;_5c6.x=0;}if(_5c6.y+_5c6.h>_5c1){_5c6.h=_5c1-_5c6.y;}if(_5c6.x+_5c6.w>_5c0){_5c6.w=_5c0-_5c6.x;}}var l=_5c3.x-_5c6.x,t=_5c3.y-_5c6.y,r=l+_5c3.w-_5c6.w,bot=t+_5c3.h-_5c6.h;var s,old;if(r*l>0&&(!!el.scrollLeft||el==_5c2||el.scrollWidth>el.offsetHeight)){s=Math[l<0?"max":"min"](l,r);if(rtl&&((isIE==8&&!_5bf)||isIE>=9||has("trident"))){s=-s;}old=el.scrollLeft;_5c5(el,s,0);s=el.scrollLeft-old;_5c3.x-=s;}if(bot*t>0&&(!!el.scrollTop||el==_5c2||el.scrollHeight>el.offsetHeight)){s=Math.ceil(Math[t<0?"max":"min"](t,bot));old=el.scrollTop;_5c5(el,0,s);s=el.scrollTop-old;_5c3.y-=s;}el=(el!=_5c2)&&!_5c7&&el.parentNode;}}catch(error){console.error("scrollIntoView: "+error);node.scrollIntoView(false);}}};1&&lang.setObject("dojo.window",_5bb);return _5bb;});},"dojox/charting/axis2d/Default":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/sniff","dojo/_base/declare","dojo/_base/connect","dojo/dom-geometry","./Invisible","../scaler/linear","./common","dojox/gfx","dojox/lang/utils","dojox/lang/functional","dojo/has!dojo-bidi?../bidi/axis2d/Default"],function(lang,arr,has,_5ca,_5cb,_5cc,_5cd,lin,_5ce,g,du,df,_5cf){var _5d0=45;var _5d1=_5ca(has("dojo-bidi")?"dojox.charting.axis2d.NonBidiDefault":"dojox.charting.axis2d.Default",_5cd,{defaultParams:{vertical:false,fixUpper:"none",fixLower:"none",natural:false,leftBottom:true,includeZero:false,fixed:true,majorLabels:true,minorTicks:true,minorLabels:true,microTicks:false,rotation:0,htmlLabels:true,enableCache:false,dropLabels:true,labelSizeChange:false,position:"leftOrBottom"},optionalParams:{min:0,max:1,from:0,to:1,majorTickStep:4,minorTickStep:2,microTickStep:1,labels:[],labelFunc:null,maxLabelSize:0,maxLabelCharCount:0,trailingSymbol:null,stroke:{},majorTick:{},minorTick:{},microTick:{},tick:{},font:"",fontColor:"",title:"",titleGap:0,titleFont:"",titleFontColor:"",titleOrientation:""},constructor:function(_5d2,_5d3){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_5d3);du.updateWithPattern(this.opt,_5d3,this.optionalParams);if(this.opt.enableCache){this._textFreePool=[];this._lineFreePool=[];this._textUsePool=[];this._lineUsePool=[];}this._invalidMaxLabelSize=true;if(!(_5d3&&("position" in _5d3))){this.opt.position=this.opt.leftBottom?"leftOrBottom":"rightOrTop";}this.renderingOptions={"shape-rendering":"crispEdges"};},setWindow:function(_5d4,_5d5){if(_5d4!=this.scale){this._invalidMaxLabelSize=true;}return this.inherited(arguments);},_groupLabelWidth:function(_5d6,font,_5d7){if(!_5d6.length){return 0;}if(_5d6.length>50){_5d6.length=50;}if(lang.isObject(_5d6[0])){_5d6=df.map(_5d6,function(_5d8){return _5d8.text;});}if(_5d7){_5d6=df.map(_5d6,function(_5d9){return lang.trim(_5d9).length==0?"":_5d9.substring(0,_5d7)+this.trailingSymbol;},this);}var s=_5d6.join("<br>");return g._base._getTextBox(s,{font:font}).w||0;},_getMaxLabelSize:function(min,max,span,_5da,font,size){if(this._maxLabelSize==null&&arguments.length==6){var o=this.opt;this.scaler.minMinorStep=this._prevMinMinorStep=0;var ob=lang.clone(o);delete ob.to;delete ob.from;var sb=lin.buildScaler(min,max,span,ob,o.to-o.from);sb.minMinorStep=0;this._majorStart=sb.major.start;var tb=lin.buildTicks(sb,o);if(size&&tb){var _5db=0,_5dc=0;var _5dd=function(tick){if(tick.label){this.push(tick.label);}};var _5de=[];if(this.opt.majorLabels){arr.forEach(tb.major,_5dd,_5de);_5db=this._groupLabelWidth(_5de,font,ob.maxLabelCharCount);if(ob.maxLabelSize){_5db=Math.min(ob.maxLabelSize,_5db);}}_5de=[];if(this.opt.dropLabels&&this.opt.minorLabels){arr.forEach(tb.minor,_5dd,_5de);_5dc=this._groupLabelWidth(_5de,font,ob.maxLabelCharCount);if(ob.maxLabelSize){_5dc=Math.min(ob.maxLabelSize,_5dc);}}this._maxLabelSize={majLabelW:_5db,minLabelW:_5dc,majLabelH:size,minLabelH:size};}else{this._maxLabelSize=null;}}return this._maxLabelSize;},calculate:function(min,max,span){this.inherited(arguments);this.scaler.minMinorStep=this._prevMinMinorStep;if((this._invalidMaxLabelSize||span!=this._oldSpan)&&(min!=Infinity&&max!=-Infinity)){this._invalidMaxLabelSize=false;if(this.opt.labelSizeChange){this._maxLabelSize=null;}this._oldSpan=span;var o=this.opt;var ta=this.chart.theme.axis,_5df=o.rotation%360,_5e0=this.chart.theme.axis.tick.labelGap,font=o.font||(ta.majorTick&&ta.majorTick.font)||(ta.tick&&ta.tick.font),size=font?g.normalizedLength(g.splitFontString(font).size):0,_5e1=this._getMaxLabelSize(min,max,span,_5df,font,size);if(typeof _5e0!="number"){_5e0=4;}if(_5e1&&o.dropLabels){var cosr=Math.abs(Math.cos(_5df*Math.PI/180)),sinr=Math.abs(Math.sin(_5df*Math.PI/180));var _5e2,_5e3;if(_5df<0){_5df+=360;}switch(_5df){case 0:case 180:if(this.vertical){_5e2=_5e3=size;}else{_5e2=_5e1.majLabelW;_5e3=_5e1.minLabelW;}break;case 90:case 270:if(this.vertical){_5e2=_5e1.majLabelW;_5e3=_5e1.minLabelW;}else{_5e2=_5e3=size;}break;default:_5e2=this.vertical?Math.min(_5e1.majLabelW,size/cosr):Math.min(_5e1.majLabelW,size/sinr);var gap1=Math.sqrt(_5e1.minLabelW*_5e1.minLabelW+size*size),gap2=this.vertical?size*cosr+_5e1.minLabelW*sinr:_5e1.minLabelW*cosr+size*sinr;_5e3=Math.min(gap1,gap2);break;}this.scaler.minMinorStep=this._prevMinMinorStep=Math.max(_5e2,_5e3)+_5e0;var _5e4=this.scaler.minMinorStep<=this.scaler.minor.tick*this.scaler.bounds.scale;if(!_5e4){this._skipInterval=Math.floor((_5e2+_5e0)/(this.scaler.major.tick*this.scaler.bounds.scale));}else{this._skipInterval=0;}}else{this._skipInterval=0;}}this.ticks=lin.buildTicks(this.scaler,this.opt);return this;},getOffsets:function(){var s=this.scaler,_5e5={l:0,r:0,t:0,b:0};if(!s){return _5e5;}var o=this.opt,ta=this.chart.theme.axis,_5e6=this.chart.theme.axis.tick.labelGap,_5e7=o.titleFont||(ta.title&&ta.title.font),_5e8=(o.titleGap==0)?0:o.titleGap||(ta.title&&ta.title.gap),_5e9=this.chart.theme.getTick("major",o),_5ea=this.chart.theme.getTick("minor",o),_5eb=_5e7?g.normalizedLength(g.splitFontString(_5e7).size):0,_5ec=o.rotation%360,_5ed=o.position,_5ee=_5ed!=="rightOrTop",cosr=Math.abs(Math.cos(_5ec*Math.PI/180)),sinr=Math.abs(Math.sin(_5ec*Math.PI/180));this.trailingSymbol=(o.trailingSymbol===undefined||o.trailingSymbol===null)?this.trailingSymbol:o.trailingSymbol;if(typeof _5e6!="number"){_5e6=4;}if(_5ec<0){_5ec+=360;}var _5ef=this._getMaxLabelSize();if(_5ef){var side;var _5f0=Math.ceil(Math.max(_5ef.majLabelW,_5ef.minLabelW))+1,size=Math.ceil(Math.max(_5ef.majLabelH,_5ef.minLabelH))+1;if(this.vertical){side=_5ee?"l":"r";switch(_5ec){case 0:case 180:_5e5[side]=_5ed==="center"?0:_5f0;_5e5.t=_5e5.b=size/2;break;case 90:case 270:_5e5[side]=size;_5e5.t=_5e5.b=_5f0/2;break;default:if(_5ec<=_5d0||(180<_5ec&&_5ec<=(180+_5d0))){_5e5[side]=size*sinr/2+_5f0*cosr;_5e5[_5ee?"t":"b"]=size*cosr/2+_5f0*sinr;_5e5[_5ee?"b":"t"]=size*cosr/2;}else{if(_5ec>(360-_5d0)||(180>_5ec&&_5ec>(180-_5d0))){_5e5[side]=size*sinr/2+_5f0*cosr;_5e5[_5ee?"b":"t"]=size*cosr/2+_5f0*sinr;_5e5[_5ee?"t":"b"]=size*cosr/2;}else{if(_5ec<90||(180<_5ec&&_5ec<270)){_5e5[side]=size*sinr+_5f0*cosr;_5e5[_5ee?"t":"b"]=size*cosr+_5f0*sinr;}else{_5e5[side]=size*sinr+_5f0*cosr;_5e5[_5ee?"b":"t"]=size*cosr+_5f0*sinr;}}}break;}if(_5ed==="center"){_5e5[side]=0;}else{_5e5[side]+=_5e6+Math.max(_5e9.length>0?_5e9.length:0,_5ea.length>0?_5ea.length:0)+(o.title?(_5eb+_5e8):0);}}else{side=_5ee?"b":"t";switch(_5ec){case 0:case 180:_5e5[side]=_5ed==="center"?0:size;_5e5.l=_5e5.r=_5f0/2;break;case 90:case 270:_5e5[side]=_5f0;_5e5.l=_5e5.r=size/2;break;default:if((90-_5d0)<=_5ec&&_5ec<=90||(270-_5d0)<=_5ec&&_5ec<=270){_5e5[side]=size*cosr/2+_5f0*sinr;_5e5[_5ee?"r":"l"]=size*sinr/2+_5f0*cosr;_5e5[_5ee?"l":"r"]=size*sinr/2;}else{if(90<=_5ec&&_5ec<=(90+_5d0)||270<=_5ec&&_5ec<=(270+_5d0)){_5e5[side]=size*cosr/2+_5f0*sinr;_5e5[_5ee?"l":"r"]=size*sinr/2+_5f0*cosr;_5e5[_5ee?"r":"l"]=size*sinr/2;}else{if(_5ec<_5d0||(180<_5ec&&_5ec<(180+_5d0))){_5e5[side]=size*cosr+_5f0*sinr;_5e5[_5ee?"r":"l"]=size*sinr+_5f0*cosr;}else{_5e5[side]=size*cosr+_5f0*sinr;_5e5[_5ee?"l":"r"]=size*sinr+_5f0*cosr;}}}break;}if(_5ed==="center"){_5e5[side]=0;}else{_5e5[side]+=_5e6+Math.max(_5e9.length>0?_5e9.length:0,_5ea.length>0?_5ea.length:0)+(o.title?(_5eb+_5e8):0);}}}return _5e5;},cleanGroup:function(_5f1){if(this.opt.enableCache&&this.group){this._lineFreePool=this._lineFreePool.concat(this._lineUsePool);this._lineUsePool=[];this._textFreePool=this._textFreePool.concat(this._textUsePool);this._textUsePool=[];}this.inherited(arguments);},createText:function(_5f2,_5f3,x,y,_5f4,_5f5,font,_5f6,_5f7){if(!this.opt.enableCache||_5f2=="html"){return _5ce.createText[_5f2](this.chart,_5f3,x,y,_5f4,_5f5,font,_5f6,_5f7);}var text;if(this._textFreePool.length>0){text=this._textFreePool.pop();text.setShape({x:x,y:y,text:_5f5,align:_5f4});_5f3.add(text);}else{text=_5ce.createText[_5f2](this.chart,_5f3,x,y,_5f4,_5f5,font,_5f6);}this._textUsePool.push(text);return text;},createLine:function(_5f8,_5f9){var line;if(this.opt.enableCache&&this._lineFreePool.length>0){line=this._lineFreePool.pop();line.setShape(_5f9);_5f8.add(line);}else{line=_5f8.createLine(_5f9);}if(this.opt.enableCache){this._lineUsePool.push(line);}return line;},render:function(dim,_5fa){var _5fb=this._isRtl();if(!this.dirty||!this.scaler){return this;}var o=this.opt,ta=this.chart.theme.axis,_5fc=o.position,_5fd=_5fc!=="rightOrTop",_5fe=o.rotation%360,_5ff,stop,_600,_601=0,_602,_603,_604,_605,_606,_607,_608=this.chart.theme.axis.tick.labelGap,_609=o.font||(ta.majorTick&&ta.majorTick.font)||(ta.tick&&ta.tick.font),_60a=o.titleFont||(ta.title&&ta.title.font),_60b=o.fontColor||(ta.majorTick&&ta.majorTick.fontColor)||(ta.tick&&ta.tick.fontColor)||"black",_60c=o.titleFontColor||(ta.title&&ta.title.fontColor)||"black",_60d=(o.titleGap==0)?0:o.titleGap||(ta.title&&ta.title.gap)||15,_60e=o.titleOrientation||(ta.title&&ta.title.orientation)||"axis",_60f=this.chart.theme.getTick("major",o),_610=this.chart.theme.getTick("minor",o),_611=this.chart.theme.getTick("micro",o),_612="stroke" in o?o.stroke:ta.stroke,size=_609?g.normalizedLength(g.splitFontString(_609).size):0,cosr=Math.abs(Math.cos(_5fe*Math.PI/180)),sinr=Math.abs(Math.sin(_5fe*Math.PI/180)),_613=_60a?g.normalizedLength(g.splitFontString(_60a).size):0;if(typeof _608!="number"){_608=4;}if(_5fe<0){_5fe+=360;}var _614=this._getMaxLabelSize();_614=_614&&_614.majLabelW;if(this.vertical){_5ff={y:dim.height-_5fa.b};stop={y:_5fa.t};_600={y:(dim.height-_5fa.b+_5fa.t)/2};_602=size*sinr+(_614||0)*cosr+_608+Math.max(_60f.length>0?_60f.length:0,_610.length>0?_610.length:0)+_613+_60d;_603={x:0,y:-1};_606={x:0,y:0};_604={x:1,y:0};_605={x:_608,y:0};switch(_5fe){case 0:_607="end";_606.y=size*0.4;break;case 90:_607="middle";_606.x=-size;break;case 180:_607="start";_606.y=-size*0.4;break;case 270:_607="middle";break;default:if(_5fe<_5d0){_607="end";_606.y=size*0.4;}else{if(_5fe<90){_607="end";_606.y=size*0.4;}else{if(_5fe<(180-_5d0)){_607="start";}else{if(_5fe<(180+_5d0)){_607="start";_606.y=-size*0.4;}else{if(_5fe<270){_607="start";_606.x=_5fd?0:size*0.4;}else{if(_5fe<(360-_5d0)){_607="end";_606.x=_5fd?0:size*0.4;}else{_607="end";_606.y=size*0.4;}}}}}}}if(_5fd){_5ff.x=stop.x=_5fc==="center"?dim.width/2:_5fa.l;_601=(_60e&&_60e=="away")?90:270;_600.x=_5fa.l-_602+(_601==270?_613:0);_604.x=-1;_605.x=-_605.x;}else{_5ff.x=stop.x=dim.width-_5fa.r;_601=(_60e&&_60e=="axis")?90:270;_600.x=dim.width-_5fa.r+_602-(_601==270?0:_613);switch(_607){case "start":_607="end";break;case "end":_607="start";break;case "middle":_606.x+=size;break;}}}else{_5ff={x:_5fa.l};stop={x:dim.width-_5fa.r};_600={x:(dim.width-_5fa.r+_5fa.l)/2};_602=size*cosr+(_614||0)*sinr+_608+Math.max(_60f.length>0?_60f.length:0,_610.length>0?_610.length:0)+_613+_60d;_603={x:_5fb?-1:1,y:0};_606={x:0,y:0};_604={x:0,y:1};_605={x:0,y:_608};switch(_5fe){case 0:_607="middle";_606.y=size;break;case 90:_607="start";_606.x=-size*0.4;break;case 180:_607="middle";break;case 270:_607="end";_606.x=size*0.4;break;default:if(_5fe<(90-_5d0)){_607="start";_606.y=_5fd?size:0;}else{if(_5fe<(90+_5d0)){_607="start";_606.x=-size*0.4;}else{if(_5fe<180){_607="start";_606.y=_5fd?0:-size;}else{if(_5fe<(270-_5d0)){_607="end";_606.y=_5fd?0:-size;}else{if(_5fe<(270+_5d0)){_607="end";_606.y=_5fd?size*0.4:0;}else{_607="end";_606.y=_5fd?size:0;}}}}}}if(_5fd){_5ff.y=stop.y=_5fc==="center"?dim.height/2:dim.height-_5fa.b;_601=(_60e&&_60e=="axis")?180:0;_600.y=dim.height-_5fa.b+_602-(_601?_613:0);}else{_5ff.y=stop.y=_5fa.t;_601=(_60e&&_60e=="away")?180:0;_600.y=_5fa.t-_602+(_601?0:_613);_604.y=-1;_605.y=-_605.y;switch(_607){case "start":_607="end";break;case "end":_607="start";break;case "middle":_606.y-=size;break;}}}this.cleanGroup();var s=this.group,c=this.scaler,t=this.ticks,f=lin.getTransformerFromModel(this.scaler),_615=(!o.title||!_601)&&!_5fe&&this.opt.htmlLabels&&!has("ie")&&!has("opera")?"html":"gfx",dx=_604.x*_60f.length,dy=_604.y*_60f.length,skip=this._skipInterval;s.createLine({x1:_5ff.x,y1:_5ff.y,x2:stop.x,y2:stop.y}).setStroke(_612);if(o.title){var _616=_5ce.createText[_615](this.chart,s,_600.x,_600.y,"middle",o.title,_60a,_60c);if(_615=="html"){this.htmlElements.push(_616);}else{_616.setTransform(g.matrix.rotategAt(_601,_600.x,_600.y));}}if(t==null){this.dirty=false;return this;}var rel=(t.major.length>0)?(t.major[0].value-this._majorStart)/c.major.tick:0;var _617=this.opt.majorLabels;arr.forEach(t.major,function(tick,i){var _618=f(tick.value),elem,x=(_5fb?stop.x:_5ff.x)+_603.x*_618,y=_5ff.y+_603.y*_618;i+=rel;this.createLine(s,{x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(_60f);if(tick.label&&(!skip||(i-(1+skip))%(1+skip)==0)){var _619=o.maxLabelCharCount?this.getTextWithLimitCharCount(tick.label,_609,o.maxLabelCharCount):{text:tick.label,truncated:false};_619=o.maxLabelSize?this.getTextWithLimitLength(_619.text,_609,o.maxLabelSize,_619.truncated):_619;elem=this.createText(_615,s,x+(_60f.length>0?dx:0)+_605.x+(_5fe?0:_606.x),y+(_60f.length>0?dy:0)+_605.y+(_5fe?0:_606.y),_607,_619.text,_609,_60b);if(_619.truncated){this.chart.formatTruncatedLabel(elem,tick.label,_615);}_619.truncated&&this.labelTooltip(elem,this.chart,tick.label,_619.text,_609,_615);if(_615=="html"){this.htmlElements.push(elem);}else{if(_5fe){elem.setTransform([{dx:_606.x,dy:_606.y},g.matrix.rotategAt(_5fe,x+(_60f.length>0?dx:0)+_605.x,y+(_60f.length>0?dy:0)+_605.y)]);}}}},this);dx=_604.x*_610.length;dy=_604.y*_610.length;_617=this.opt.minorLabels&&c.minMinorStep<=c.minor.tick*c.bounds.scale;arr.forEach(t.minor,function(tick){var _61a=f(tick.value),elem,x=(_5fb?stop.x:_5ff.x)+_603.x*_61a,y=_5ff.y+_603.y*_61a;this.createLine(s,{x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(_610);if(_617&&tick.label){var _61b=o.maxLabelCharCount?this.getTextWithLimitCharCount(tick.label,_609,o.maxLabelCharCount):{text:tick.label,truncated:false};_61b=o.maxLabelSize?this.getTextWithLimitLength(_61b.text,_609,o.maxLabelSize,_61b.truncated):_61b;elem=this.createText(_615,s,x+(_610.length>0?dx:0)+_605.x+(_5fe?0:_606.x),y+(_610.length>0?dy:0)+_605.y+(_5fe?0:_606.y),_607,_61b.text,_609,_60b);if(_61b.truncated){this.chart.formatTruncatedLabel(elem,tick.label,_615);}_61b.truncated&&this.labelTooltip(elem,this.chart,tick.label,_61b.text,_609,_615);if(_615=="html"){this.htmlElements.push(elem);}else{if(_5fe){elem.setTransform([{dx:_606.x,dy:_606.y},g.matrix.rotategAt(_5fe,x+(_610.length>0?dx:0)+_605.x,y+(_610.length>0?dy:0)+_605.y)]);}}}},this);dx=_604.x*_611.length;dy=_604.y*_611.length;arr.forEach(t.micro,function(tick){var _61c=f(tick.value),x=_5ff.x+_603.x*_61c,y=_5ff.y+_603.y*_61c;this.createLine(s,{x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(_611);},this);this.dirty=false;return this;},labelTooltip:function(elem,_61d,_61e,_61f,font,_620){var _621=["dijit/Tooltip"];var _622={type:"rect"},_623=["above","below"],_624=g._base._getTextBox(_61f,{font:font}).w||0,_625=font?g.normalizedLength(g.splitFontString(font).size):0;if(_620=="html"){lang.mixin(_622,_5cc.position(elem.firstChild,true));_622.width=Math.ceil(_624);_622.height=Math.ceil(_625);this._events.push({shape:dojo,handle:_5cb.connect(elem.firstChild,"onmouseover",this,function(e){require(_621,function(_626){_626.show(_61e,_622,_623);});})});this._events.push({shape:dojo,handle:_5cb.connect(elem.firstChild,"onmouseout",this,function(e){require(_621,function(_627){_627.hide(_622);});})});}else{var shp=elem.getShape(),lt=_61d.getCoords();_622=lang.mixin(_622,{x:shp.x-_624/2,y:shp.y});_622.x+=lt.x;_622.y+=lt.y;_622.x=Math.round(_622.x);_622.y=Math.round(_622.y);_622.width=Math.ceil(_624);_622.height=Math.ceil(_625);this._events.push({shape:elem,handle:elem.connect("onmouseenter",this,function(e){require(_621,function(_628){_628.show(_61e,_622,_623);});})});this._events.push({shape:elem,handle:elem.connect("onmouseleave",this,function(e){require(_621,function(_629){_629.hide(_622);});})});}},_isRtl:function(){return false;}});return has("dojo-bidi")?_5ca("dojox.charting.axis2d.Default",[_5d1,_5cf]):_5d1;});},"dojox/charting/plot2d/ClusteredBars":function(){define(["dojo/_base/declare","dojo/_base/array","./Bars","./common"],function(_62a,_62b,Bars,dc){return _62a("dojox.charting.plot2d.ClusteredBars",Bars,{getBarProperties:function(){var _62c=this.series.length;_62b.forEach(this.series,function(_62d){if(_62d.hidden){_62c--;}});var f=dc.calculateBarSize(this._vScaler.bounds.scale,this.opt,_62c);return {gap:f.gap,height:f.size,thickness:f.size};}});});},"dojox/charting/action2d/MoveSlice":function(){define(["dojo/_base/connect","dojo/_base/declare","dojo/_base/array","./PlotAction","dojo/fx/easing","dojox/gfx/matrix","dojox/gfx/fx","dojox/lang/functional","dojox/lang/functional/scan","dojox/lang/functional/fold"],function(hub,_62e,_62f,_630,dfe,m,gf,df){var _631=1.05,_632=7;return _62e("dojox.charting.action2d.MoveSlice",_630,{defaultParams:{duration:400,easing:dfe.backOut,scale:_631,shift:_632},optionalParams:{},constructor:function(_633,plot,_634){if(!_634){_634={};}this.scale=typeof _634.scale=="number"?_634.scale:_631;this.shift=typeof _634.shift=="number"?_634.shift:_632;this.connect();},process:function(o){if(!o.shape||o.element!="slice"||!(o.type in this.overOutEvents)){return;}if(!this.angles){var _635=m._degToRad(o.plot.opt.startAngle);if(typeof o.run.data[0]=="number"){this.angles=df.map(df.scanl(o.run.data,"+",0),"* 2 * Math.PI / this",df.foldl(o.run.data,"+",0));}else{this.angles=df.map(df.scanl(o.run.data,"a + b.y",0),"* 2 * Math.PI / this",df.foldl(o.run.data,"a + b.y",0));}this.angles=_62f.map(this.angles,function(item){return item+_635;});}var _636=o.index,anim,_637,_638,_639,_63a,_63b=(this.angles[_636]+this.angles[_636+1])/2,_63c=m.rotateAt(-_63b,o.cx,o.cy),_63d=m.rotateAt(_63b,o.cx,o.cy);anim=this.anim[_636];if(anim){anim.action.stop(true);}else{this.anim[_636]=anim={};}if(o.type=="onmouseover"){_639=0;_63a=this.shift;_637=1;_638=this.scale;}else{_639=this.shift;_63a=0;_637=this.scale;_638=1;}anim.action=gf.animateTransform({shape:o.shape,duration:this.duration,easing:this.easing,transform:[_63d,{name:"translate",start:[_639,0],end:[_63a,0]},{name:"scaleAt",start:[_637,o.cx,o.cy],end:[_638,o.cx,o.cy]},_63c]});if(o.type=="onmouseout"){hub.connect(anim.action,"onEnd",this,function(){delete this.anim[_636];});}anim.action.play();},reset:function(){delete this.angles;}});});},"dojo/colors":function(){define(["./_base/kernel","./_base/lang","./_base/Color","./_base/array"],function(dojo,lang,_63e,_63f){var _640={};lang.setObject("dojo.colors",_640);var _641=function(m1,m2,h){if(h<0){++h;}if(h>1){--h;}var h6=6*h;if(h6<1){return m1+(m2-m1)*h6;}if(2*h<1){return m2;}if(3*h<2){return m1+(m2-m1)*(2/3-h)*6;}return m1;};dojo.colorFromRgb=_63e.fromRgb=function(_642,obj){var m=_642.toLowerCase().match(/^(rgba?|hsla?)\(([\s\.\-,%0-9]+)\)/);if(m){var c=m[2].split(/\s*,\s*/),l=c.length,t=m[1],a;if((t=="rgb"&&l==3)||(t=="rgba"&&l==4)){var r=c[0];if(r.charAt(r.length-1)=="%"){a=_63f.map(c,function(x){return parseFloat(x)*2.56;});if(l==4){a[3]=c[3];}return _63e.fromArray(a,obj);}return _63e.fromArray(c,obj);}if((t=="hsl"&&l==3)||(t=="hsla"&&l==4)){var H=((parseFloat(c[0])%360)+360)%360/360,S=parseFloat(c[1])/100,L=parseFloat(c[2])/100,m2=L<=0.5?L*(S+1):L+S-L*S,m1=2*L-m2;a=[_641(m1,m2,H+1/3)*256,_641(m1,m2,H)*256,_641(m1,m2,H-1/3)*256,1];if(l==4){a[3]=c[3];}return _63e.fromArray(a,obj);}}return null;};var _643=function(c,low,high){c=Number(c);return isNaN(c)?high:c<low?low:c>high?high:c;};_63e.prototype.sanitize=function(){var t=this;t.r=Math.round(_643(t.r,0,255));t.g=Math.round(_643(t.g,0,255));t.b=Math.round(_643(t.b,0,255));t.a=_643(t.a,0,1);return this;};_640.makeGrey=_63e.makeGrey=function(g,a){return _63e.fromArray([g,g,g,a]);};lang.mixin(_63e.named,{"aliceblue":[240,248,255],"antiquewhite":[250,235,215],"aquamarine":[127,255,212],"azure":[240,255,255],"beige":[245,245,220],"bisque":[255,228,196],"blanchedalmond":[255,235,205],"blueviolet":[138,43,226],"brown":[165,42,42],"burlywood":[222,184,135],"cadetblue":[95,158,160],"chartreuse":[127,255,0],"chocolate":[210,105,30],"coral":[255,127,80],"cornflowerblue":[100,149,237],"cornsilk":[255,248,220],"crimson":[220,20,60],"cyan":[0,255,255],"darkblue":[0,0,139],"darkcyan":[0,139,139],"darkgoldenrod":[184,134,11],"darkgray":[169,169,169],"darkgreen":[0,100,0],"darkgrey":[169,169,169],"darkkhaki":[189,183,107],"darkmagenta":[139,0,139],"darkolivegreen":[85,107,47],"darkorange":[255,140,0],"darkorchid":[153,50,204],"darkred":[139,0,0],"darksalmon":[233,150,122],"darkseagreen":[143,188,143],"darkslateblue":[72,61,139],"darkslategray":[47,79,79],"darkslategrey":[47,79,79],"darkturquoise":[0,206,209],"darkviolet":[148,0,211],"deeppink":[255,20,147],"deepskyblue":[0,191,255],"dimgray":[105,105,105],"dimgrey":[105,105,105],"dodgerblue":[30,144,255],"firebrick":[178,34,34],"floralwhite":[255,250,240],"forestgreen":[34,139,34],"gainsboro":[220,220,220],"ghostwhite":[248,248,255],"gold":[255,215,0],"goldenrod":[218,165,32],"greenyellow":[173,255,47],"grey":[128,128,128],"honeydew":[240,255,240],"hotpink":[255,105,180],"indianred":[205,92,92],"indigo":[75,0,130],"ivory":[255,255,240],"khaki":[240,230,140],"lavender":[230,230,250],"lavenderblush":[255,240,245],"lawngreen":[124,252,0],"lemonchiffon":[255,250,205],"lightblue":[173,216,230],"lightcoral":[240,128,128],"lightcyan":[224,255,255],"lightgoldenrodyellow":[250,250,210],"lightgray":[211,211,211],"lightgreen":[144,238,144],"lightgrey":[211,211,211],"lightpink":[255,182,193],"lightsalmon":[255,160,122],"lightseagreen":[32,178,170],"lightskyblue":[135,206,250],"lightslategray":[119,136,153],"lightslategrey":[119,136,153],"lightsteelblue":[176,196,222],"lightyellow":[255,255,224],"limegreen":[50,205,50],"linen":[250,240,230],"magenta":[255,0,255],"mediumaquamarine":[102,205,170],"mediumblue":[0,0,205],"mediumorchid":[186,85,211],"mediumpurple":[147,112,219],"mediumseagreen":[60,179,113],"mediumslateblue":[123,104,238],"mediumspringgreen":[0,250,154],"mediumturquoise":[72,209,204],"mediumvioletred":[199,21,133],"midnightblue":[25,25,112],"mintcream":[245,255,250],"mistyrose":[255,228,225],"moccasin":[255,228,181],"navajowhite":[255,222,173],"oldlace":[253,245,230],"olivedrab":[107,142,35],"orange":[255,165,0],"orangered":[255,69,0],"orchid":[218,112,214],"palegoldenrod":[238,232,170],"palegreen":[152,251,152],"paleturquoise":[175,238,238],"palevioletred":[219,112,147],"papayawhip":[255,239,213],"peachpuff":[255,218,185],"peru":[205,133,63],"pink":[255,192,203],"plum":[221,160,221],"powderblue":[176,224,230],"rosybrown":[188,143,143],"royalblue":[65,105,225],"saddlebrown":[139,69,19],"salmon":[250,128,114],"sandybrown":[244,164,96],"seagreen":[46,139,87],"seashell":[255,245,238],"sienna":[160,82,45],"skyblue":[135,206,235],"slateblue":[106,90,205],"slategray":[112,128,144],"slategrey":[112,128,144],"snow":[255,250,250],"springgreen":[0,255,127],"steelblue":[70,130,180],"tan":[210,180,140],"thistle":[216,191,216],"tomato":[255,99,71],"turquoise":[64,224,208],"violet":[238,130,238],"wheat":[245,222,179],"whitesmoke":[245,245,245],"yellowgreen":[154,205,50]});return _63e;});},"dojox/charting/SimpleTheme":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/_base/Color","dojox/lang/utils","dojox/gfx/gradutils"],function(lang,arr,_644,_645,dlu,dgg){var _646=_644("dojox.charting.SimpleTheme",null,{shapeSpaces:{shape:1,shapeX:1,shapeY:1},constructor:function(_647){_647=_647||{};var def=_646.defaultTheme;arr.forEach(["chart","plotarea","axis","grid","series","marker","indicator"],function(name){this[name]=lang.delegate(def[name],_647[name]);},this);if(_647.seriesThemes&&_647.seriesThemes.length){this.colors=null;this.seriesThemes=_647.seriesThemes.slice(0);}else{this.seriesThemes=null;this.colors=(_647.colors||_646.defaultColors).slice(0);}this.markerThemes=null;if(_647.markerThemes&&_647.markerThemes.length){this.markerThemes=_647.markerThemes.slice(0);}this.markers=_647.markers?lang.clone(_647.markers):lang.delegate(_646.defaultMarkers);this.noGradConv=_647.noGradConv;this.noRadialConv=_647.noRadialConv;if(_647.reverseFills){this.reverseFills();}this._current=0;this._buildMarkerArray();},clone:function(){var _648=new this.constructor({chart:this.chart,plotarea:this.plotarea,axis:this.axis,grid:this.grid,series:this.series,marker:this.marker,colors:this.colors,markers:this.markers,indicator:this.indicator,seriesThemes:this.seriesThemes,markerThemes:this.markerThemes,noGradConv:this.noGradConv,noRadialConv:this.noRadialConv});arr.forEach(["clone","clear","next","skip","addMixin","post","getTick"],function(name){if(this.hasOwnProperty(name)){_648[name]=this[name];}},this);return _648;},clear:function(){this._current=0;},next:function(_649,_64a,_64b){var _64c=dlu.merge,_64d,_64e;if(this.colors){_64d=lang.delegate(this.series);_64e=lang.delegate(this.marker);var _64f=new _645(this.colors[this._current%this.colors.length]),old;if(_64d.stroke&&_64d.stroke.color){_64d.stroke=lang.delegate(_64d.stroke);old=new _645(_64d.stroke.color);_64d.stroke.color=new _645(_64f);_64d.stroke.color.a=old.a;}else{_64d.stroke={color:_64f};}if(_64e.stroke&&_64e.stroke.color){_64e.stroke=lang.delegate(_64e.stroke);old=new _645(_64e.stroke.color);_64e.stroke.color=new _645(_64f);_64e.stroke.color.a=old.a;}else{_64e.stroke={color:_64f};}if(!_64d.fill||_64d.fill.type){_64d.fill=_64f;}else{old=new _645(_64d.fill);_64d.fill=new _645(_64f);_64d.fill.a=old.a;}if(!_64e.fill||_64e.fill.type){_64e.fill=_64f;}else{old=new _645(_64e.fill);_64e.fill=new _645(_64f);_64e.fill.a=old.a;}}else{_64d=this.seriesThemes?_64c(this.series,this.seriesThemes[this._current%this.seriesThemes.length]):this.series;_64e=this.markerThemes?_64c(this.marker,this.markerThemes[this._current%this.markerThemes.length]):_64d;}var _650=_64e&&_64e.symbol||this._markers[this._current%this._markers.length];var _651={series:_64d,marker:_64e,symbol:_650};++this._current;if(_64a){_651=this.addMixin(_651,_649,_64a);}if(_64b){_651=this.post(_651,_649);}return _651;},skip:function(){++this._current;},addMixin:function(_652,_653,_654,_655){if(lang.isArray(_654)){arr.forEach(_654,function(m){_652=this.addMixin(_652,_653,m);},this);}else{var t={};if("color" in _654){if(_653=="line"||_653=="area"){lang.setObject("series.stroke.color",_654.color,t);lang.setObject("marker.stroke.color",_654.color,t);}else{lang.setObject("series.fill",_654.color,t);}}arr.forEach(["stroke","outline","shadow","fill","filter","font","fontColor","labelWiring"],function(name){var _656="marker"+name.charAt(0).toUpperCase()+name.substr(1),b=_656 in _654;if(name in _654){lang.setObject("series."+name,_654[name],t);if(!b){lang.setObject("marker."+name,_654[name],t);}}if(b){lang.setObject("marker."+name,_654[_656],t);}});if("marker" in _654){t.symbol=_654.marker;t.symbol=_654.marker;}_652=dlu.merge(_652,t);}if(_655){_652=this.post(_652,_653);}return _652;},post:function(_657,_658){var fill=_657.series.fill,t;if(!this.noGradConv&&this.shapeSpaces[fill.space]&&fill.type=="linear"){if(_658=="bar"){t={x1:fill.y1,y1:fill.x1,x2:fill.y2,y2:fill.x2};}else{if(!this.noRadialConv&&fill.space=="shape"&&(_658=="slice"||_658=="circle")){t={type:"radial",cx:0,cy:0,r:100};}}if(t){return dlu.merge(_657,{series:{fill:t}});}}return _657;},getTick:function(name,_659){var tick=this.axis.tick,_65a=name+"Tick",_65b=dlu.merge;if(tick){if(this.axis[_65a]){tick=_65b(tick,this.axis[_65a]);}}else{tick=this.axis[_65a];}if(_659){if(tick){if(_659[_65a]){tick=_65b(tick,_659[_65a]);}}else{tick=_659[_65a];}}return tick;},inspectObjects:function(f){arr.forEach(["chart","plotarea","axis","grid","series","marker","indicator"],function(name){f(this[name]);},this);if(this.seriesThemes){arr.forEach(this.seriesThemes,f);}if(this.markerThemes){arr.forEach(this.markerThemes,f);}},reverseFills:function(){this.inspectObjects(function(o){if(o&&o.fill){o.fill=dgg.reverse(o.fill);}});},addMarker:function(name,_65c){this.markers[name]=_65c;this._buildMarkerArray();},setMarkers:function(obj){this.markers=obj;this._buildMarkerArray();},_buildMarkerArray:function(){this._markers=[];for(var p in this.markers){this._markers.push(this.markers[p]);}}});lang.mixin(_646,{defaultMarkers:{CIRCLE:"m-3,0 c0,-4 6,-4 6,0 m-6,0 c0,4 6,4 6,0",SQUARE:"m-3,-3 l0,6 6,0 0,-6 z",DIAMOND:"m0,-3 l3,3 -3,3 -3,-3 z",CROSS:"m0,-3 l0,6 m-3,-3 l6,0",X:"m-3,-3 l6,6 m0,-6 l-6,6",TRIANGLE:"m-3,3 l3,-6 3,6 z",TRIANGLE_INVERTED:"m-3,-3 l3,6 3,-6 z"},defaultColors:["#54544c","#858e94","#6e767a","#948585","#474747"],defaultTheme:{chart:{stroke:null,fill:"white",pageStyle:null,titleGap:20,titlePos:"top",titleFont:"normal normal bold 14pt Tahoma",titleFontColor:"#333"},plotarea:{stroke:null,fill:"white"},axis:{stroke:{color:"#333",width:1},tick:{color:"#666",position:"center",font:"normal normal normal 7pt Tahoma",fontColor:"#333",labelGap:4},majorTick:{width:1,length:6},minorTick:{width:0.8,length:3},microTick:{width:0.5,length:1},title:{gap:15,font:"normal normal normal 11pt Tahoma",fontColor:"#333",orientation:"axis"}},series:{stroke:{width:1.5,color:"#333"},outline:{width:0.1,color:"#ccc"},shadow:null,fill:"#ccc",font:"normal normal normal 8pt Tahoma",fontColor:"#000",labelWiring:{width:1,color:"#ccc"}},marker:{stroke:{width:1.5,color:"#333"},outline:{width:0.1,color:"#ccc"},shadow:null,fill:"#ccc",font:"normal normal normal 8pt Tahoma",fontColor:"#000"},indicator:{lineStroke:{width:1.5,color:"#333"},lineOutline:{width:0.1,color:"#ccc"},lineShadow:null,lineFill:null,stroke:{width:1.5,color:"#333"},outline:{width:0.1,color:"#ccc"},shadow:null,fill:"#ccc",radius:3,font:"normal normal normal 10pt Tahoma",fontColor:"#000",markerFill:"#ccc",markerSymbol:"m-3,0 c0,-4 6,-4 6,0 m-6,0 c0,4 6,4 6,0",markerStroke:{width:1.5,color:"#333"},markerOutline:{width:0.1,color:"#ccc"},markerShadow:null}}});return _646;});},"dijit/Tooltip":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/_base/fx","dojo/dom","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/lang","dojo/mouse","dojo/on","dojo/sniff","./_base/manager","./place","./_Widget","./_TemplatedMixin","./BackgroundIframe","dojo/text!./templates/Tooltip.html","./main"],function(_65d,_65e,fx,dom,_65f,_660,_661,lang,_662,on,has,_663,_664,_665,_666,_667,_668,_669){var _66a=_65e("dijit._MasterTooltip",[_665,_666],{duration:_663.defaultDuration,templateString:_668,postCreate:function(){this.ownerDocumentBody.appendChild(this.domNode);this.bgIframe=new _667(this.domNode);this.fadeIn=fx.fadeIn({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,"_onShow")});this.fadeOut=fx.fadeOut({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,"_onHide")});},show:function(_66b,_66c,_66d,rtl,_66e,_66f,_670){if(this.aroundNode&&this.aroundNode===_66c&&this.containerNode.innerHTML==_66b){return;}if(this.fadeOut.status()=="playing"){this._onDeck=arguments;return;}this.containerNode.innerHTML=_66b;if(_66e){this.set("textDir",_66e);}this.containerNode.align=rtl?"right":"left";var pos=_664.around(this.domNode,_66c,_66d&&_66d.length?_66d:_671.defaultPosition,!rtl,lang.hitch(this,"orient"));var _672=pos.aroundNodePos;if(pos.corner.charAt(0)=="M"&&pos.aroundCorner.charAt(0)=="M"){this.connectorNode.style.top=_672.y+((_672.h-this.connectorNode.offsetHeight)>>1)-pos.y+"px";this.connectorNode.style.left="";}else{if(pos.corner.charAt(1)=="M"&&pos.aroundCorner.charAt(1)=="M"){this.connectorNode.style.left=_672.x+((_672.w-this.connectorNode.offsetWidth)>>1)-pos.x+"px";}else{this.connectorNode.style.left="";this.connectorNode.style.top="";}}_661.set(this.domNode,"opacity",0);this.fadeIn.play();this.isShowingNow=true;this.aroundNode=_66c;this.onMouseEnter=_66f||noop;this.onMouseLeave=_670||noop;},orient:function(node,_673,_674,_675,_676){this.connectorNode.style.top="";var _677=_675.h,_678=_675.w;node.className="dijitTooltip "+{"MR-ML":"dijitTooltipRight","ML-MR":"dijitTooltipLeft","TM-BM":"dijitTooltipAbove","BM-TM":"dijitTooltipBelow","BL-TL":"dijitTooltipBelow dijitTooltipABLeft","TL-BL":"dijitTooltipAbove dijitTooltipABLeft","BR-TR":"dijitTooltipBelow dijitTooltipABRight","TR-BR":"dijitTooltipAbove dijitTooltipABRight","BR-BL":"dijitTooltipRight","BL-BR":"dijitTooltipLeft"}[_673+"-"+_674];this.domNode.style.width="auto";var size=_660.position(this.domNode);if(has("ie")||has("trident")){size.w+=2;}var _679=Math.min((Math.max(_678,1)),size.w);_660.setMarginBox(this.domNode,{w:_679});if(_674.charAt(0)=="B"&&_673.charAt(0)=="B"){var bb=_660.position(node);var _67a=this.connectorNode.offsetHeight;if(bb.h>_677){var _67b=_677-((_676.h+_67a)>>1);this.connectorNode.style.top=_67b+"px";this.connectorNode.style.bottom="";}else{this.connectorNode.style.bottom=Math.min(Math.max(_676.h/2-_67a/2,0),bb.h-_67a)+"px";this.connectorNode.style.top="";}}else{this.connectorNode.style.top="";this.connectorNode.style.bottom="";}return Math.max(0,size.w-_678);},_onShow:function(){if(has("ie")){this.domNode.style.filter="";}},hide:function(_67c){if(this._onDeck&&this._onDeck[1]==_67c){this._onDeck=null;}else{if(this.aroundNode===_67c){this.fadeIn.stop();this.isShowingNow=false;this.aroundNode=null;this.fadeOut.play();}else{}}this.onMouseEnter=this.onMouseLeave=noop;},_onHide:function(){this.domNode.style.cssText="";this.containerNode.innerHTML="";if(this._onDeck){this.show.apply(this,this._onDeck);this._onDeck=null;}}});if(has("dojo-bidi")){_66a.extend({_setAutoTextDir:function(node){this.applyTextDir(node);_65d.forEach(node.children,function(_67d){this._setAutoTextDir(_67d);},this);},_setTextDirAttr:function(_67e){this._set("textDir",_67e);if(_67e=="auto"){this._setAutoTextDir(this.containerNode);}else{this.containerNode.dir=this.textDir;}}});}_669.showTooltip=function(_67f,_680,_681,rtl,_682,_683,_684){if(_681){_681=_65d.map(_681,function(val){return {after:"after-centered",before:"before-centered"}[val]||val;});}if(!_671._masterTT){_669._masterTT=_671._masterTT=new _66a();}return _671._masterTT.show(_67f,_680,_681,rtl,_682,_683,_684);};_669.hideTooltip=function(_685){return _671._masterTT&&_671._masterTT.hide(_685);};var _686="DORMANT",_687="SHOW TIMER",_688="SHOWING",_689="HIDE TIMER";function noop(){};var _671=_65e("dijit.Tooltip",_665,{label:"",showDelay:400,hideDelay:400,connectId:[],position:[],selector:"",_setConnectIdAttr:function(_68a){_65d.forEach(this._connections||[],function(_68b){_65d.forEach(_68b,function(_68c){_68c.remove();});},this);this._connectIds=_65d.filter(lang.isArrayLike(_68a)?_68a:(_68a?[_68a]:[]),function(id){return dom.byId(id,this.ownerDocument);},this);this._connections=_65d.map(this._connectIds,function(id){var node=dom.byId(id,this.ownerDocument),_68d=this.selector,_68e=_68d?function(_68f){return on.selector(_68d,_68f);}:function(_690){return _690;},self=this;return [on(node,_68e(_662.enter),function(){self._onHover(this);}),on(node,_68e("focusin"),function(){self._onHover(this);}),on(node,_68e(_662.leave),lang.hitch(self,"_onUnHover")),on(node,_68e("focusout"),lang.hitch(self,"set","state",_686))];},this);this._set("connectId",_68a);},addTarget:function(node){var id=node.id||node;if(_65d.indexOf(this._connectIds,id)==-1){this.set("connectId",this._connectIds.concat(id));}},removeTarget:function(node){var id=node.id||node,idx=_65d.indexOf(this._connectIds,id);if(idx>=0){this._connectIds.splice(idx,1);this.set("connectId",this._connectIds);}},buildRendering:function(){this.inherited(arguments);_65f.add(this.domNode,"dijitTooltipData");},startup:function(){this.inherited(arguments);var ids=this.connectId;_65d.forEach(lang.isArrayLike(ids)?ids:[ids],this.addTarget,this);},getContent:function(node){return this.label||this.domNode.innerHTML;},state:_686,_setStateAttr:function(val){if(this.state==val||(val==_687&&this.state==_688)||(val==_689&&this.state==_686)){return;}if(this._hideTimer){this._hideTimer.remove();delete this._hideTimer;}if(this._showTimer){this._showTimer.remove();delete this._showTimer;}switch(val){case _686:if(this._connectNode){_671.hide(this._connectNode);delete this._connectNode;this.onHide();}break;case _687:if(this.state!=_688){this._showTimer=this.defer(function(){this.set("state",_688);},this.showDelay);}break;case _688:var _691=this.getContent(this._connectNode);if(!_691){this.set("state",_686);return;}_671.show(_691,this._connectNode,this.position,!this.isLeftToRight(),this.textDir,lang.hitch(this,"set","state",_688),lang.hitch(this,"set","state",_689));this.onShow(this._connectNode,this.position);break;case _689:this._hideTimer=this.defer(function(){this.set("state",_686);},this.hideDelay);break;}this._set("state",val);},_onHover:function(_692){if(this._connectNode&&_692!=this._connectNode){this.set("state",_686);}this._connectNode=_692;this.set("state",_687);},_onUnHover:function(_693){this.set("state",_689);},open:function(_694){this.set("state",_686);this._connectNode=_694;this.set("state",_688);},close:function(){this.set("state",_686);},onShow:function(){},onHide:function(){},destroy:function(){this.set("state",_686);_65d.forEach(this._connections||[],function(_695){_65d.forEach(_695,function(_696){_696.remove();});},this);this.inherited(arguments);}});_671._MasterTooltip=_66a;_671.show=_669.showTooltip;_671.hide=_669.hideTooltip;_671.defaultPosition=["after-centered","before-centered"];return _671;});},"dojox/charting/Element":function(){define(["dojo/_base/array","dojo/dom-construct","dojo/_base/declare","dojox/gfx","dojox/gfx/shape"],function(arr,_697,_698,gfx,_699){return _698("dojox.charting.Element",null,{chart:null,group:null,htmlElements:null,dirty:true,renderingOptions:null,constructor:function(_69a,_69b){this.chart=_69a;this.group=null;this.htmlElements=[];this.dirty=true;this.trailingSymbol="...";this._events=[];if(_69b&&_69b.renderingOptions){this.renderingOptions=_69b.renderingOptions;}},purgeGroup:function(){this.destroyHtmlElements();if(this.group){this.getGroup().removeShape();var _69c=this.getGroup().children;if(_699.dispose){for(var i=0;i<_69c.length;++i){_699.dispose(_69c[i],true);}}if(this.getGroup().rawNode){_697.empty(this.getGroup().rawNode);}this.getGroup().clear();if(_699.dispose){_699.dispose(this.getGroup(),true);}if(this.getGroup()!=this.group){if(this.group.rawNode){_697.empty(this.group.rawNode);}this.group.clear();if(_699.dispose){_699.dispose(this.group,true);}}this.group=null;}this.dirty=true;if(this._events.length){arr.forEach(this._events,function(item){item.shape.disconnect(item.handle);});this._events=[];}return this;},cleanGroup:function(_69d){this.destroyHtmlElements();if(!_69d){_69d=this.chart.surface;}if(this.group){var _69e;var _69f=this.getGroup().children;if(_699.dispose){for(var i=0;i<_69f.length;++i){_699.dispose(_69f[i],true);}}if(this.getGroup().rawNode){_69e=this.getGroup().bgNode;_697.empty(this.getGroup().rawNode);}this.getGroup().clear();if(_69e){this.getGroup().rawNode.appendChild(_69e);}}else{this.group=_69d.createGroup();if(this.renderingOptions&&this.group.rawNode&&this.group.rawNode.namespaceURI=="http://www.w3.org/2000/svg"){for(var key in this.renderingOptions){this.group.rawNode.setAttribute(key,this.renderingOptions[key]);}}}this.dirty=true;return this;},getGroup:function(){return this.group;},destroyHtmlElements:function(){if(this.htmlElements.length){arr.forEach(this.htmlElements,_697.destroy);this.htmlElements=[];}},destroy:function(){this.purgeGroup();},getTextWidth:function(s,font){return gfx._base._getTextBox(s,{font:font}).w||0;},getTextWithLimitLength:function(s,font,_6a0,_6a1){if(!s||s.length<=0){return {text:"",truncated:_6a1||false};}if(!_6a0||_6a0<=0){return {text:s,truncated:_6a1||false};}var _6a2=2,_6a3=0.618,_6a4=s.substring(0,1)+this.trailingSymbol,_6a5=this.getTextWidth(_6a4,font);if(_6a0<=_6a5){return {text:_6a4,truncated:true};}var _6a6=this.getTextWidth(s,font);if(_6a6<=_6a0){return {text:s,truncated:_6a1||false};}else{var _6a7=0,end=s.length;while(_6a7<end){if(end-_6a7<=_6a2){while(this.getTextWidth(s.substring(0,_6a7)+this.trailingSymbol,font)>_6a0){_6a7-=1;}return {text:(s.substring(0,_6a7)+this.trailingSymbol),truncated:true};}var _6a8=_6a7+Math.round((end-_6a7)*_6a3),_6a9=this.getTextWidth(s.substring(0,_6a8),font);if(_6a9<_6a0){_6a7=_6a8;end=end;}else{_6a7=_6a7;end=_6a8;}}}},getTextWithLimitCharCount:function(s,font,_6aa,_6ab){if(!s||s.length<=0){return {text:"",truncated:_6ab||false};}if(!_6aa||_6aa<=0||s.length<=_6aa){return {text:s,truncated:_6ab||false};}return {text:s.substring(0,_6aa)+this.trailingSymbol,truncated:true};},_plotFill:function(fill,dim,_6ac){if(!fill||!fill.type||!fill.space){return fill;}var _6ad=fill.space,span;switch(fill.type){case "linear":if(_6ad==="plot"||_6ad==="shapeX"||_6ad==="shapeY"){fill=gfx.makeParameters(gfx.defaultLinearGradient,fill);fill.space=_6ad;if(_6ad==="plot"||_6ad==="shapeX"){span=dim.height-_6ac.t-_6ac.b;fill.y1=_6ac.t+span*fill.y1/100;fill.y2=_6ac.t+span*fill.y2/100;}if(_6ad==="plot"||_6ad==="shapeY"){span=dim.width-_6ac.l-_6ac.r;fill.x1=_6ac.l+span*fill.x1/100;fill.x2=_6ac.l+span*fill.x2/100;}}break;case "radial":if(_6ad==="plot"){fill=gfx.makeParameters(gfx.defaultRadialGradient,fill);fill.space=_6ad;var _6ae=dim.width-_6ac.l-_6ac.r,_6af=dim.height-_6ac.t-_6ac.b;fill.cx=_6ac.l+_6ae*fill.cx/100;fill.cy=_6ac.t+_6af*fill.cy/100;fill.r=fill.r*Math.sqrt(_6ae*_6ae+_6af*_6af)/200;}break;case "pattern":if(_6ad==="plot"||_6ad==="shapeX"||_6ad==="shapeY"){fill=gfx.makeParameters(gfx.defaultPattern,fill);fill.space=_6ad;if(_6ad==="plot"||_6ad==="shapeX"){span=dim.height-_6ac.t-_6ac.b;fill.y=_6ac.t+span*fill.y/100;fill.height=span*fill.height/100;}if(_6ad==="plot"||_6ad==="shapeY"){span=dim.width-_6ac.l-_6ac.r;fill.x=_6ac.l+span*fill.x/100;fill.width=span*fill.width/100;}}break;}return fill;},_shapeFill:function(fill,bbox){if(!fill||!fill.space){return fill;}var _6b0=fill.space,span;switch(fill.type){case "linear":if(_6b0==="shape"||_6b0==="shapeX"||_6b0==="shapeY"){fill=gfx.makeParameters(gfx.defaultLinearGradient,fill);fill.space=_6b0;if(_6b0==="shape"||_6b0==="shapeX"){span=bbox.width;fill.x1=bbox.x+span*fill.x1/100;fill.x2=bbox.x+span*fill.x2/100;}if(_6b0==="shape"||_6b0==="shapeY"){span=bbox.height;fill.y1=bbox.y+span*fill.y1/100;fill.y2=bbox.y+span*fill.y2/100;}}break;case "radial":if(_6b0==="shape"){fill=gfx.makeParameters(gfx.defaultRadialGradient,fill);fill.space=_6b0;fill.cx=bbox.x+bbox.width/2;fill.cy=bbox.y+bbox.height/2;fill.r=fill.r*bbox.width/200;}break;case "pattern":if(_6b0==="shape"||_6b0==="shapeX"||_6b0==="shapeY"){fill=gfx.makeParameters(gfx.defaultPattern,fill);fill.space=_6b0;if(_6b0==="shape"||_6b0==="shapeX"){span=bbox.width;fill.x=bbox.x+span*fill.x/100;fill.width=span*fill.width/100;}if(_6b0==="shape"||_6b0==="shapeY"){span=bbox.height;fill.y=bbox.y+span*fill.y/100;fill.height=span*fill.height/100;}}break;}return fill;},_pseudoRadialFill:function(fill,_6b1,_6b2,_6b3,end){if(!fill||fill.type!=="radial"||fill.space!=="shape"){return fill;}var _6b4=fill.space;fill=gfx.makeParameters(gfx.defaultRadialGradient,fill);fill.space=_6b4;if(arguments.length<4){fill.cx=_6b1.x;fill.cy=_6b1.y;fill.r=fill.r*_6b2/100;return fill;}var _6b5=arguments.length<5?_6b3:(end+_6b3)/2;return {type:"linear",x1:_6b1.x,y1:_6b1.y,x2:_6b1.x+fill.r*_6b2*Math.cos(_6b5)/100,y2:_6b1.y+fill.r*_6b2*Math.sin(_6b5)/100,colors:fill.colors};}});});},"dijit/_WidgetBase":function(){define(["require","dojo/_base/array","dojo/aspect","dojo/_base/config","dojo/_base/connect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/ready","dojo/Stateful","dojo/topic","dojo/_base/window","./Destroyable","dojo/has!dojo-bidi?./_BidiMixin","./registry"],function(_6b6,_6b7,_6b8,_6b9,_6ba,_6bb,dom,_6bc,_6bd,_6be,_6bf,_6c0,has,_6c1,lang,on,_6c2,_6c3,_6c4,win,_6c5,_6c6,_6c7){has.add("dijit-legacy-requires",!_6c1.isAsync);has.add("dojo-bidi",false);if(has("dijit-legacy-requires")){_6c2(0,function(){var _6c8=["dijit/_base/manager"];_6b6(_6c8);});}var _6c9={};function _6ca(obj){var ret={};for(var attr in obj){ret[attr.toLowerCase()]=true;}return ret;};function _6cb(attr){return function(val){_6bc[val?"set":"remove"](this.domNode,attr,val);this._set(attr,val);};};function _6cc(a,b){return a===b||(a!==a&&b!==b);};var _6cd=_6bb("dijit._WidgetBase",[_6c3,_6c5],{id:"",_setIdAttr:"domNode",lang:"",_setLangAttr:_6cb("lang"),dir:"",_setDirAttr:_6cb("dir"),"class":"",_setClassAttr:{node:"domNode",type:"class"},_setTypeAttr:null,style:"",title:"",tooltip:"",baseClass:"",srcNodeRef:null,domNode:null,containerNode:null,ownerDocument:null,_setOwnerDocumentAttr:function(val){this._set("ownerDocument",val);},attributeMap:{},_blankGif:_6b9.blankGif||_6b6.toUrl("dojo/resources/blank.gif"),_introspect:function(){var ctor=this.constructor;if(!ctor._setterAttrs){var _6ce=ctor.prototype,_6cf=ctor._setterAttrs=[],_6d0=(ctor._onMap={});for(var name in _6ce.attributeMap){_6cf.push(name);}for(name in _6ce){if(/^on/.test(name)){_6d0[name.substring(2).toLowerCase()]=name;}if(/^_set[A-Z](.*)Attr$/.test(name)){name=name.charAt(4).toLowerCase()+name.substr(5,name.length-9);if(!_6ce.attributeMap||!(name in _6ce.attributeMap)){_6cf.push(name);}}}}},postscript:function(_6d1,_6d2){this.create(_6d1,_6d2);},create:function(_6d3,_6d4){this._introspect();this.srcNodeRef=dom.byId(_6d4);this._connects=[];this._supportingWidgets=[];if(this.srcNodeRef&&(typeof this.srcNodeRef.id=="string")){this.id=this.srcNodeRef.id;}if(_6d3){this.params=_6d3;lang.mixin(this,_6d3);}this.postMixInProperties();if(!this.id){this.id=_6c7.getUniqueId(this.declaredClass.replace(/\./g,"_"));if(this.params){delete this.params.id;}}this.ownerDocument=this.ownerDocument||(this.srcNodeRef?this.srcNodeRef.ownerDocument:document);this.ownerDocumentBody=win.body(this.ownerDocument);_6c7.add(this);this.buildRendering();var _6d5;if(this.domNode){this._applyAttributes();var _6d6=this.srcNodeRef;if(_6d6&&_6d6.parentNode&&this.domNode!==_6d6){_6d6.parentNode.replaceChild(this.domNode,_6d6);_6d5=true;}this.domNode.setAttribute("widgetId",this.id);}this.postCreate();if(_6d5){delete this.srcNodeRef;}this._created=true;},_applyAttributes:function(){var _6d7={};for(var key in this.params||{}){_6d7[key]=this._get(key);}_6b7.forEach(this.constructor._setterAttrs,function(key){if(!(key in _6d7)){var val=this._get(key);if(val){this.set(key,val);}}},this);for(key in _6d7){this.set(key,_6d7[key]);}},postMixInProperties:function(){},buildRendering:function(){if(!this.domNode){this.domNode=this.srcNodeRef||this.ownerDocument.createElement("div");}if(this.baseClass){var _6d8=this.baseClass.split(" ");if(!this.isLeftToRight()){_6d8=_6d8.concat(_6b7.map(_6d8,function(name){return name+"Rtl";}));}_6bd.add(this.domNode,_6d8);}},postCreate:function(){},startup:function(){if(this._started){return;}this._started=true;_6b7.forEach(this.getChildren(),function(obj){if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){obj.startup();obj._started=true;}});},destroyRecursive:function(_6d9){this._beingDestroyed=true;this.destroyDescendants(_6d9);this.destroy(_6d9);},destroy:function(_6da){this._beingDestroyed=true;this.uninitialize();function _6db(w){if(w.destroyRecursive){w.destroyRecursive(_6da);}else{if(w.destroy){w.destroy(_6da);}}};_6b7.forEach(this._connects,lang.hitch(this,"disconnect"));_6b7.forEach(this._supportingWidgets,_6db);if(this.domNode){_6b7.forEach(_6c7.findWidgets(this.domNode,this.containerNode),_6db);}this.destroyRendering(_6da);_6c7.remove(this.id);this._destroyed=true;},destroyRendering:function(_6dc){if(this.bgIframe){this.bgIframe.destroy(_6dc);delete this.bgIframe;}if(this.domNode){if(_6dc){_6bc.remove(this.domNode,"widgetId");}else{_6be.destroy(this.domNode);}delete this.domNode;}if(this.srcNodeRef){if(!_6dc){_6be.destroy(this.srcNodeRef);}delete this.srcNodeRef;}},destroyDescendants:function(_6dd){_6b7.forEach(this.getChildren(),function(_6de){if(_6de.destroyRecursive){_6de.destroyRecursive(_6dd);}});},uninitialize:function(){return false;},_setStyleAttr:function(_6df){var _6e0=this.domNode;if(lang.isObject(_6df)){_6c0.set(_6e0,_6df);}else{if(_6e0.style.cssText){_6e0.style.cssText+="; "+_6df;}else{_6e0.style.cssText=_6df;}}this._set("style",_6df);},_attrToDom:function(attr,_6e1,_6e2){_6e2=arguments.length>=3?_6e2:this.attributeMap[attr];_6b7.forEach(lang.isArray(_6e2)?_6e2:[_6e2],function(_6e3){var _6e4=this[_6e3.node||_6e3||"domNode"];var type=_6e3.type||"attribute";switch(type){case "attribute":if(lang.isFunction(_6e1)){_6e1=lang.hitch(this,_6e1);}var _6e5=_6e3.attribute?_6e3.attribute:(/^on[A-Z][a-zA-Z]*$/.test(attr)?attr.toLowerCase():attr);if(_6e4.tagName){_6bc.set(_6e4,_6e5,_6e1);}else{_6e4.set(_6e5,_6e1);}break;case "innerText":_6e4.innerHTML="";_6e4.appendChild(this.ownerDocument.createTextNode(_6e1));break;case "innerHTML":_6e4.innerHTML=_6e1;break;case "class":_6bd.replace(_6e4,_6e1,this[attr]);break;}},this);},get:function(name){var _6e6=this._getAttrNames(name);return this[_6e6.g]?this[_6e6.g]():this._get(name);},set:function(name,_6e7){if(typeof name==="object"){for(var x in name){this.set(x,name[x]);}return this;}var _6e8=this._getAttrNames(name),_6e9=this[_6e8.s];if(lang.isFunction(_6e9)){var _6ea=_6e9.apply(this,Array.prototype.slice.call(arguments,1));}else{var _6eb=this.focusNode&&!lang.isFunction(this.focusNode)?"focusNode":"domNode",tag=this[_6eb]&&this[_6eb].tagName,_6ec=tag&&(_6c9[tag]||(_6c9[tag]=_6ca(this[_6eb]))),map=name in this.attributeMap?this.attributeMap[name]:_6e8.s in this?this[_6e8.s]:((_6ec&&_6e8.l in _6ec&&typeof _6e7!="function")||/^aria-|^data-|^role$/.test(name))?_6eb:null;if(map!=null){this._attrToDom(name,_6e7,map);}this._set(name,_6e7);}return _6ea||this;},_attrPairNames:{},_getAttrNames:function(name){var apn=this._attrPairNames;if(apn[name]){return apn[name];}var uc=name.replace(/^[a-z]|-[a-zA-Z]/g,function(c){return c.charAt(c.length-1).toUpperCase();});return (apn[name]={n:name+"Node",s:"_set"+uc+"Attr",g:"_get"+uc+"Attr",l:uc.toLowerCase()});},_set:function(name,_6ed){var _6ee=this[name];this[name]=_6ed;if(this._created&&!_6cc(_6ee,_6ed)){if(this._watchCallbacks){this._watchCallbacks(name,_6ee,_6ed);}this.emit("attrmodified-"+name,{detail:{prevValue:_6ee,newValue:_6ed}});}},_get:function(name){return this[name];},emit:function(type,_6ef,_6f0){_6ef=_6ef||{};if(_6ef.bubbles===undefined){_6ef.bubbles=true;}if(_6ef.cancelable===undefined){_6ef.cancelable=true;}if(!_6ef.detail){_6ef.detail={};}_6ef.detail.widget=this;var ret,_6f1=this["on"+type];if(_6f1){ret=_6f1.apply(this,_6f0?_6f0:[_6ef]);}if(this._started&&!this._beingDestroyed){on.emit(this.domNode,type.toLowerCase(),_6ef);}return ret;},on:function(type,func){var _6f2=this._onMap(type);if(_6f2){return _6b8.after(this,_6f2,func,true);}return this.own(on(this.domNode,type,func))[0];},_onMap:function(type){var ctor=this.constructor,map=ctor._onMap;if(!map){map=(ctor._onMap={});for(var attr in ctor.prototype){if(/^on/.test(attr)){map[attr.replace(/^on/,"").toLowerCase()]=attr;}}}return map[typeof type=="string"&&type.toLowerCase()];},toString:function(){return "[Widget "+this.declaredClass+", "+(this.id||"NO ID")+"]";},getChildren:function(){return this.containerNode?_6c7.findWidgets(this.containerNode):[];},getParent:function(){return _6c7.getEnclosingWidget(this.domNode.parentNode);},connect:function(obj,_6f3,_6f4){return this.own(_6ba.connect(obj,_6f3,this,_6f4))[0];},disconnect:function(_6f5){_6f5.remove();},subscribe:function(t,_6f6){return this.own(_6c4.subscribe(t,lang.hitch(this,_6f6)))[0];},unsubscribe:function(_6f7){_6f7.remove();},isLeftToRight:function(){return this.dir?(this.dir=="ltr"):_6bf.isBodyLtr(this.ownerDocument);},isFocusable:function(){return this.focus&&(_6c0.get(this.domNode,"display")!="none");},placeAt:function(_6f8,_6f9){var _6fa=!_6f8.tagName&&_6c7.byId(_6f8);if(_6fa&&_6fa.addChild&&(!_6f9||typeof _6f9==="number")){_6fa.addChild(this,_6f9);}else{var ref=_6fa&&("domNode" in _6fa)?(_6fa.containerNode&&!/after|before|replace/.test(_6f9||"")?_6fa.containerNode:_6fa.domNode):dom.byId(_6f8,this.ownerDocument);_6be.place(this.domNode,ref,_6f9);if(!this._started&&(this.getParent()||{})._started){this.startup();}}return this;},defer:function(fcn,_6fb){var _6fc=setTimeout(lang.hitch(this,function(){if(!_6fc){return;}_6fc=null;if(!this._destroyed){lang.hitch(this,fcn)();}}),_6fb||0);return {remove:function(){if(_6fc){clearTimeout(_6fc);_6fc=null;}return null;}};}});if(has("dojo-bidi")){_6cd.extend(_6c6);}return _6cd;});},"url:dijit/templates/Tooltip.html":"<div class=\"dijitTooltip dijitTooltipLeft\" id=\"dojoTooltip\" data-dojo-attach-event=\"mouseenter:onMouseEnter,mouseleave:onMouseLeave\"\n\t><div class=\"dijitTooltipConnector\" data-dojo-attach-point=\"connectorNode\"></div\n\t><div class=\"dijitTooltipContainer dijitTooltipContents\" data-dojo-attach-point=\"containerNode\" role='alert'></div\n></div>\n"}});define("dojox/charting/widget/Chart2D",["dojo/_base/kernel","dojo/_base/lang","./Chart","../Chart2D","../action2d/Highlight","../action2d/Magnify","../action2d/MoveSlice","../action2d/Shake","../action2d/Tooltip"],function(_6fd,lang,_6fe){_6fd.deprecated("dojox.charting.widget.Chart2D","Use dojo.charting.widget.Chart instead and require all other components explicitly","2.0");return lang.setObject("dojox.charting.widget.Chart2D",_6fe);});