// wrapped by build app
define("dojox/mobile/app/AlertDialog", ["dijit","dojo","dojox","dojo/require!dijit/_WidgetBase"], function(dijit,dojo,dojox){
dojo.provide("dojox.mobile.app.AlertDialog");
dojo.experimental("dojox.mobile.app.AlertDialog");
dojo.require("dijit._WidgetBase");

dojo.declare("dojox.mobile.app.AlertDialog", dijit._WidgetBase, {

	// title: String
	//		The title of the AlertDialog
	title: "",

	// text: String
	//		The text message displayed in the AlertDialog
	text: "",

	// controller: Object
	//		The SceneController for the currently active scene
	controller: null,

	// buttons: Array
	buttons: null,

	defaultButtonLabel: "OK",

	// onChoose: Function
	//		The callback function that is invoked when a button is tapped.
	//		If the dialog is cancelled, no parameter is passed to this function.
	onChoose: null,

	constructor: function(){
		this.onClick = dojo.hitch(this, this.onClick);
		this._handleSelect = dojo.hitch(this, this._handleSelect);
	},

	buildRendering: function(){
		this.domNode = dojo.create("div",{
			"class": "alertDialog"
		});

		// Create the outer dialog body
		var dlgBody = dojo.create("div", {"class": "alertDialogBody"}, this.domNode);

		// Create the title
		dojo.create("div", {"class": "alertTitle", innerHTML: this.title || ""}, dlgBody);

		// Create the text
		dojo.create("div", {"class": "alertText", innerHTML: this.text || ""}, dlgBody);

		// Create the node that encapsulates all the buttons
		var btnContainer = dojo.create("div", {"class": "alertBtns"}, dlgBody);

		// If no buttons have been defined, default to a single button saying OK
		if(!this.buttons || this.buttons.length == 0){
			this.buttons = [{
				label: this.defaultButtonLabel,
				value: "ok",
				"class": "affirmative"
			}];
		}

		var _this = this;

		// Create each of the buttons
		dojo.forEach(this.buttons, function(btnInfo){
			var btn = new dojox.mobile.Button({
				btnClass: btnInfo["class"] || "",
				label: btnInfo.label
			});
			btn._dialogValue = btnInfo.value;
			dojo.place(btn.domNode, btnContainer);
			_this.connect(btn, "onClick", _this._handleSelect);
		});

		var viewportSize = this.controller.getWindowSize();

		// Create the mask that blocks out the rest of the screen
		this.mask = dojo.create("div", {"class": "dialogUnderlayWrapper",
			innerHTML: "<div class=\"dialogUnderlay\"></div>",
			style: {
				width: viewportSize.w + "px",
				height: viewportSize.h + "px"
			}
		}, this.controller.assistant.domNode);

		this.connect(this.mask, "onclick", function(){
			_this.onChoose && _this.onChoose();
			_this.hide();
		});
	},

	postCreate: function(){
		this.subscribe("/dojox/mobile/app/goback", this._handleSelect);
	},

	_handleSelect: function(event){
		// summary:
		//		Handle the selection of a value
		var node;
		console.log("handleSelect");
		if(event && event.target){
			node = event.target;

			// Find the widget that was tapped.
			while(!dijit.byNode(node)){
				node - node.parentNode;
			}
		}

		// If an onChoose function was provided, tell it what button
		// value was chosen
		if(this.onChoose){
			this.onChoose(node ? dijit.byNode(node)._dialogValue: undefined);
		}
		// Hide the dialog
		this.hide();
	},

	show: function(){
		// summary:
		//		Show the dialog
		this._doTransition(1);
	},

	hide: function(){
		// summary:
		//		Hide the dialog
		this._doTransition(-1);
	},

	_doTransition: function(dir){
		// summary:
		//		Either shows or hides the dialog.
		// dir:
		//		An integer.  If positive, the dialog is shown. If negative,
		//		the dialog is hidden.

		// TODO: replace this with CSS transitions

		var anim;
		var h = dojo.marginBox(this.domNode.firstChild).h;


		var bodyHeight = this.controller.getWindowSize().h;
		console.log("dialog height = " + h, " body height = " + bodyHeight);

		var high = bodyHeight - h;
		var low = bodyHeight;

		var anim1 = dojo.fx.slideTo({
			node: this.domNode,
			duration: 400,
			top: {start: dir < 0 ? high : low, end: dir < 0 ? low: high}
		});

		var anim2 = dojo[dir < 0 ? "fadeOut" : "fadeIn"]({
			node: this.mask,
			duration: 400
		});

		var anim = dojo.fx.combine([anim1, anim2]);

		var _this = this;

		dojo.connect(anim, "onEnd", this, function(){
			if(dir < 0){
				_this.domNode.style.display = "none";
				dojo.destroy(_this.domNode);
				dojo.destroy(_this.mask);
			}
		});
		anim.play();
	},

	destroy: function(){
		this.inherited(arguments);
		dojo.destroy(this.mask);
	},


	onClick: function(){

	}
});
});
