/*
	Copyright (c) 2004-2012, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is an optimized version of Dojo, built for deployment and not for
	development. To get sources and documentation, please visit:

		http://dojotoolkit.org
*/

//>>built
require({cache:{"dojox/dtl/_base":function(){define(["dojo/_base/kernel","dojo/_base/lang","dojox/string/tokenize","dojo/_base/json","dojo/dom","dojo/_base/xhr","dojox/string/Builder","dojo/_base/Deferred"],function(_1,_2,_3,_4,_5,_6,_7,_8){_1.experimental("dojox.dtl");var dd=_2.getObject("dojox.dtl",true);dd._base={};dd.TOKEN_BLOCK=-1;dd.TOKEN_VAR=-2;dd.TOKEN_COMMENT=-3;dd.TOKEN_TEXT=3;dd._Context=_2.extend(function(_9){if(_9){_2._mixin(this,_9);if(_9.get){this._getter=_9.get;delete this.get;}}},{push:function(){var _a=this;var _b=_2.delegate(this);_b.pop=function(){return _a;};return _b;},pop:function(){throw new Error("pop() called on empty Context");},get:function(_c,_d){var n=this._normalize;if(this._getter){var _e=this._getter(_c);if(_e!==undefined){return n(_e);}}if(this[_c]!==undefined){return n(this[_c]);}return _d;},_normalize:function(_f){if(_f instanceof Date){_f.year=_f.getFullYear();_f.month=_f.getMonth()+1;_f.day=_f.getDate();_f.date=_f.year+"-"+("0"+_f.month).slice(-2)+"-"+("0"+_f.day).slice(-2);_f.hour=_f.getHours();_f.minute=_f.getMinutes();_f.second=_f.getSeconds();_f.microsecond=_f.getMilliseconds();}return _f;},update:function(_10){var _11=this.push();if(_10){_2._mixin(this,_10);}return _11;}});var _12=/("(?:[^"\\]*(?:\\.[^"\\]*)*)"|'(?:[^'\\]*(?:\\.[^'\\]*)*)'|[^\s]+)/g;var _13=/\s+/g;var _14=function(_15,_16){_15=_15||_13;if(!(_15 instanceof RegExp)){_15=new RegExp(_15,"g");}if(!_15.global){throw new Error("You must use a globally flagged RegExp with split "+_15);}_15.exec("");var _17,_18=[],_19=0,i=0;while((_17=_15.exec(this))){_18.push(this.slice(_19,_15.lastIndex-_17[0].length));_19=_15.lastIndex;if(_16&&(++i>_16-1)){break;}}_18.push(this.slice(_19));return _18;};dd.Token=function(_1a,_1b){this.token_type=_1a;this.contents=new String(_2.trim(_1b));this.contents.split=_14;this.split=function(){return String.prototype.split.apply(this.contents,arguments);};};dd.Token.prototype.split_contents=function(_1c){var bit,_1d=[],i=0;_1c=_1c||999;while(i++<_1c&&(bit=_12.exec(this.contents))){bit=bit[0];if(bit.charAt(0)=="\""&&bit.slice(-1)=="\""){_1d.push("\""+bit.slice(1,-1).replace("\\\"","\"").replace("\\\\","\\")+"\"");}else{if(bit.charAt(0)=="'"&&bit.slice(-1)=="'"){_1d.push("'"+bit.slice(1,-1).replace("\\'","'").replace("\\\\","\\")+"'");}else{_1d.push(bit);}}}return _1d;};var ddt=dd.text={_get:function(_1e,_1f,_20){var _21=dd.register.get(_1e,_1f.toLowerCase(),_20);if(!_21){if(!_20){throw new Error("No tag found for "+_1f);}return null;}var fn=_21[1];var _22=_21[2];var _23;if(fn.indexOf(":")!=-1){_23=fn.split(":");fn=_23.pop();}var mod=_22;if(/\./.test(_22)){_22=_22.replace(/\./g,"/");}require([_22],function(){});var _24=_2.getObject(mod);return _24[fn||_1f]||_24[_1f+"_"]||_24[fn+"_"];},getTag:function(_25,_26){return ddt._get("tag",_25,_26);},getFilter:function(_27,_28){return ddt._get("filter",_27,_28);},getTemplate:function(_29){return new dd.Template(ddt.getTemplateString(_29));},getTemplateString:function(_2a){return _6._getText(_2a.toString())||"";},_resolveLazy:function(_2b,_2c,_2d){if(_2c){if(_2d){return _2d.fromJson(_6._getText(_2b))||{};}else{return dd.text.getTemplateString(_2b);}}else{return _6.get({handleAs:_2d?"json":"text",url:_2b});}},_resolveTemplateArg:function(arg,_2e){if(ddt._isTemplate(arg)){if(!_2e){var d=new _8();d.callback(arg);return d;}return arg;}return ddt._resolveLazy(arg,_2e);},_isTemplate:function(arg){return (arg===undefined)||(typeof arg=="string"&&(arg.match(/^\s*[<{]/)||arg.indexOf(" ")!=-1));},_resolveContextArg:function(arg,_2f){if(arg.constructor==Object){if(!_2f){var d=new _8;d.callback(arg);return d;}return arg;}return ddt._resolveLazy(arg,_2f,true);},_re:/(?:\{\{\s*(.+?)\s*\}\}|\{%\s*(load\s*)?(.+?)\s*%\})/g,tokenize:function(str){return _3(str,ddt._re,ddt._parseDelims);},_parseDelims:function(_30,_31,tag){if(_30){return [dd.TOKEN_VAR,_30];}else{if(_31){var _32=_2.trim(tag).split(/\s+/g);for(var i=0,_33;_33=_32[i];i++){if(/\./.test(_33)){_33=_33.replace(/\./g,"/");}require([_33]);}}else{return [dd.TOKEN_BLOCK,tag];}}}};dd.Template=_2.extend(function(_34,_35){var str=_35?_34:ddt._resolveTemplateArg(_34,true)||"";var _36=ddt.tokenize(str);var _37=new dd._Parser(_36);this.nodelist=_37.parse();},{update:function(_38,_39){return ddt._resolveContextArg(_39).addCallback(this,function(_3a){var _3b=this.render(new dd._Context(_3a));if(_38.forEach){_38.forEach(function(_3c){_3c.innerHTML=_3b;});}else{_5.byId(_38).innerHTML=_3b;}return this;});},render:function(_3d,_3e){_3e=_3e||this.getBuffer();_3d=_3d||new dd._Context({});return this.nodelist.render(_3d,_3e)+"";},getBuffer:function(){return new _7();}});var _3f=/\{\{\s*(.+?)\s*\}\}/g;dd.quickFilter=function(str){if(!str){return new dd._NodeList();}if(str.indexOf("{%")==-1){return new dd._QuickNodeList(_3(str,_3f,function(_40){return new dd._Filter(_40);}));}};dd._QuickNodeList=_2.extend(function(_41){this.contents=_41;},{render:function(_42,_43){for(var i=0,l=this.contents.length;i<l;i++){if(this.contents[i].resolve){_43=_43.concat(this.contents[i].resolve(_42));}else{_43=_43.concat(this.contents[i]);}}return _43;},dummyRender:function(_44){return this.render(_44,dd.Template.prototype.getBuffer()).toString();},clone:function(_45){return this;}});dd._Filter=_2.extend(function(_46){if(!_46){throw new Error("Filter must be called with variable name");}this.contents=_46;var _47=this._cache[_46];if(_47){this.key=_47[0];this.filters=_47[1];}else{this.filters=[];_3(_46,this._re,this._tokenize,this);this._cache[_46]=[this.key,this.filters];}},{_cache:{},_re:/(?:^_\("([^\\"]*(?:\\.[^\\"])*)"\)|^"([^\\"]*(?:\\.[^\\"]*)*)"|^([a-zA-Z0-9_.]+)|\|(\w+)(?::(?:_\("([^\\"]*(?:\\.[^\\"])*)"\)|"([^\\"]*(?:\\.[^\\"]*)*)"|([a-zA-Z0-9_.]+)|'([^\\']*(?:\\.[^\\']*)*)'))?|^'([^\\']*(?:\\.[^\\']*)*)')/g,_values:{0:"\"",1:"\"",2:"",8:"\""},_args:{4:"\"",5:"\"",6:"",7:"'"},_tokenize:function(){var pos,arg;for(var i=0,has=[];i<arguments.length;i++){has[i]=(arguments[i]!==undefined&&typeof arguments[i]=="string"&&arguments[i]);}if(!this.key){for(pos in this._values){if(has[pos]){this.key=this._values[pos]+arguments[pos]+this._values[pos];break;}}}else{for(pos in this._args){if(has[pos]){var _48=arguments[pos];if(this._args[pos]=="'"){_48=_48.replace(/\\'/g,"'");}else{if(this._args[pos]=="\""){_48=_48.replace(/\\"/g,"\"");}}arg=[!this._args[pos],_48];break;}}var fn=ddt.getFilter(arguments[3]);if(!_2.isFunction(fn)){throw new Error(arguments[3]+" is not registered as a filter");}this.filters.push([fn,arg]);}},getExpression:function(){return this.contents;},resolve:function(_49){if(this.key===undefined){return "";}var str=this.resolvePath(this.key,_49);for(var i=0,_4a;_4a=this.filters[i];i++){if(_4a[1]){if(_4a[1][0]){str=_4a[0](str,this.resolvePath(_4a[1][1],_49));}else{str=_4a[0](str,_4a[1][1]);}}else{str=_4a[0](str);}}return str;},resolvePath:function(_4b,_4c){var _4d,_4e;var _4f=_4b.charAt(0);var _50=_4b.slice(-1);if(!isNaN(parseInt(_4f))){_4d=(_4b.indexOf(".")==-1)?parseInt(_4b):parseFloat(_4b);}else{if(_4f=="\""&&_4f==_50){_4d=_4b.slice(1,-1);}else{if(_4b=="true"){return true;}if(_4b=="false"){return false;}if(_4b=="null"||_4b=="None"){return null;}_4e=_4b.split(".");_4d=_4c.get(_4e[0]);if(_2.isFunction(_4d)){var _51=_4c.getThis&&_4c.getThis();if(_4d.alters_data){_4d="";}else{if(_51){_4d=_4d.call(_51);}else{_4d="";}}}for(var i=1;i<_4e.length;i++){var _52=_4e[i];if(_4d){var _53=_4d;if(_2.isObject(_4d)&&_52=="items"&&_4d[_52]===undefined){var _54=[];for(var key in _4d){_54.push([key,_4d[key]]);}_4d=_54;continue;}if(_4d.get&&_2.isFunction(_4d.get)&&_4d.get.safe){_4d=_4d.get(_52);}else{if(_4d[_52]===undefined){_4d=_4d[_52];break;}else{_4d=_4d[_52];}}if(_2.isFunction(_4d)){if(_4d.alters_data){_4d="";}else{_4d=_4d.call(_53);}}else{if(_4d instanceof Date){_4d=dd._Context.prototype._normalize(_4d);}}}else{return "";}}}}return _4d;}});dd._TextNode=dd._Node=_2.extend(function(obj){this.contents=obj;},{set:function(_55){this.contents=_55;return this;},render:function(_56,_57){return _57.concat(this.contents);},isEmpty:function(){return !_2.trim(this.contents);},clone:function(){return this;}});dd._NodeList=_2.extend(function(_58){this.contents=_58||[];this.last="";},{push:function(_59){this.contents.push(_59);return this;},concat:function(_5a){this.contents=this.contents.concat(_5a);return this;},render:function(_5b,_5c){for(var i=0;i<this.contents.length;i++){_5c=this.contents[i].render(_5b,_5c);if(!_5c){throw new Error("Template must return buffer");}}return _5c;},dummyRender:function(_5d){return this.render(_5d,dd.Template.prototype.getBuffer()).toString();},unrender:function(){return arguments[1];},clone:function(){return this;},rtrim:function(){while(1){i=this.contents.length-1;if(this.contents[i] instanceof dd._TextNode&&this.contents[i].isEmpty()){this.contents.pop();}else{break;}}return this;}});dd._VarNode=_2.extend(function(str){this.contents=new dd._Filter(str);},{render:function(_5e,_5f){var str=this.contents.resolve(_5e);if(!str.safe){str=dd._base.escape(""+str);}return _5f.concat(str);}});dd._noOpNode=new function(){this.render=this.unrender=function(){return arguments[1];};this.clone=function(){return this;};};dd._Parser=_2.extend(function(_60){this.contents=_60;},{i:0,parse:function(_61){var _62={},_63;_61=_61||[];for(var i=0;i<_61.length;i++){_62[_61[i]]=true;}var _64=new dd._NodeList();while(this.i<this.contents.length){_63=this.contents[this.i++];if(typeof _63=="string"){_64.push(new dd._TextNode(_63));}else{var _65=_63[0];var _66=_63[1];if(_65==dd.TOKEN_VAR){_64.push(new dd._VarNode(_66));}else{if(_65==dd.TOKEN_BLOCK){if(_62[_66]){--this.i;return _64;}var cmd=_66.split(/\s+/g);if(cmd.length){cmd=cmd[0];var fn=ddt.getTag(cmd);if(fn){_64.push(fn(this,new dd.Token(_65,_66)));}}}}}}if(_61.length){throw new Error("Could not find closing tag(s): "+_61.toString());}this.contents.length=0;return _64;},next_token:function(){var _67=this.contents[this.i++];return new dd.Token(_67[0],_67[1]);},delete_first_token:function(){this.i++;},skip_past:function(_68){while(this.i<this.contents.length){var _69=this.contents[this.i++];if(_69[0]==dd.TOKEN_BLOCK&&_69[1]==_68){return;}}throw new Error("Unclosed tag found when looking for "+_68);},create_variable_node:function(_6a){return new dd._VarNode(_6a);},create_text_node:function(_6b){return new dd._TextNode(_6b||"");},getTemplate:function(_6c){return new dd.Template(_6c);}});dd.register={_registry:{attributes:[],tags:[],filters:[]},get:function(_6d,_6e){var _6f=dd.register._registry[_6d+"s"];for(var i=0,_70;_70=_6f[i];i++){if(typeof _70[0]=="string"){if(_70[0]==_6e){return _70;}}else{if(_6e.match(_70[0])){return _70;}}}},getAttributeTags:function(){var _71=[];var _72=dd.register._registry.attributes;for(var i=0,_73;_73=_72[i];i++){if(_73.length==3){_71.push(_73);}else{var fn=_2.getObject(_73[1]);if(fn&&_2.isFunction(fn)){_73.push(fn);_71.push(_73);}}}return _71;},_any:function(_74,_75,_76){for(var _77 in _76){for(var i=0,fn;fn=_76[_77][i];i++){var key=fn;if(_2.isArray(fn)){key=fn[0];fn=fn[1];}if(typeof key=="string"){if(key.substr(0,5)=="attr:"){var _78=fn;if(_78.substr(0,5)=="attr:"){_78=_78.slice(5);}dd.register._registry.attributes.push([_78.toLowerCase(),_75+"."+_77+"."+_78]);}key=key.toLowerCase();}dd.register._registry[_74].push([key,fn,_75+"."+_77]);}}},tags:function(_79,_7a){dd.register._any("tags",_79,_7a);},filters:function(_7b,_7c){dd.register._any("filters",_7b,_7c);}};var _7d=/&/g;var _7e=/</g;var _7f=/>/g;var _80=/'/g;var _81=/"/g;dd._base.escape=function(_82){return dd.mark_safe(_82.replace(_7d,"&amp;").replace(_7e,"&lt;").replace(_7f,"&gt;").replace(_81,"&quot;").replace(_80,"&#39;"));};dd._base.safe=function(_83){if(typeof _83=="string"){_83=new String(_83);}if(typeof _83=="object"){_83.safe=true;}return _83;};dd.mark_safe=dd._base.safe;dd.register.tags("dojox.dtl.tag",{"date":["now"],"logic":["if","for","ifequal","ifnotequal"],"loader":["extends","block","include","load","ssi"],"misc":["comment","debug","filter","firstof","spaceless","templatetag","widthratio","with"],"loop":["cycle","ifchanged","regroup"]});dd.register.filters("dojox.dtl.filter",{"dates":["date","time","timesince","timeuntil"],"htmlstrings":["linebreaks","linebreaksbr","removetags","striptags"],"integers":["add","get_digit"],"lists":["dictsort","dictsortreversed","first","join","length","length_is","random","slice","unordered_list"],"logic":["default","default_if_none","divisibleby","yesno"],"misc":["filesizeformat","pluralize","phone2numeric","pprint"],"strings":["addslashes","capfirst","center","cut","fix_ampersands","floatformat","iriencode","linenumbers","ljust","lower","make_list","rjust","slugify","stringformat","title","truncatewords","truncatewords_html","upper","urlencode","urlize","urlizetrunc","wordcount","wordwrap"]});dd.register.filters("dojox.dtl",{"_base":["escape","safe"]});return dd;});},"dojox/dtl/utils/date":function(){define(["dojo/_base/lang","dojox/date/php","../_base"],function(_84,ddp,dd){_84.getObject("dojox.dtl.utils.date",true);dd.utils.date.DateFormat=ddp.DateFormat;_84.extend(dd.utils.date.DateFormat,ddp.DateFormat.prototype,{f:function(){return (!this.date.getMinutes())?this.g():this.g()+":"+this.i();},N:function(){return dojox.dtl.utils.date._months_ap[this.date.getMonth()];},P:function(){if(!this.date.getMinutes()&&!this.date.getHours()){return "midnight";}if(!this.date.getMinutes()&&this.date.getHours()==12){return "noon";}return this.f()+" "+this.a();}});_84.mixin(dojox.dtl.utils.date,{format:function(_85,_86){var df=new dojox.dtl.utils.date.DateFormat(_86);return df.format(_85);},timesince:function(d,now){if(!(d instanceof Date)){d=new Date(d.year,d.month,d.day);}if(!now){now=new Date();}var _87=Math.abs(now.getTime()-d.getTime());for(var i=0,_88;_88=dojox.dtl.utils.date._chunks[i];i++){var _89=Math.floor(_87/_88[0]);if(_89){break;}}return _89+" "+_88[1](_89);},_chunks:[[60*60*24*365*1000,function(n){return (n==1)?"year":"years";}],[60*60*24*30*1000,function(n){return (n==1)?"month":"months";}],[60*60*24*7*1000,function(n){return (n==1)?"week":"weeks";}],[60*60*24*1000,function(n){return (n==1)?"day":"days";}],[60*60*1000,function(n){return (n==1)?"hour":"hours";}],[60*1000,function(n){return (n==1)?"minute":"minutes";}]],_months_ap:["Jan.","Feb.","March","April","May","June","July","Aug.","Sept.","Oct.","Nov.","Dec."]});return dojox.dtl.utils.date;});},"dojox/dtl/tag/date":function(){define(["dojo/_base/lang","../_base","../utils/date"],function(_8a,dd,_8b){_8a.getObject("dojox.dtl.tag.date",true);dojox.dtl.tag.date.NowNode=function(_8c,_8d){this._format=_8c;this.format=new _8b.DateFormat(_8c);this.contents=_8d;};_8a.extend(dd.tag.date.NowNode,{render:function(_8e,_8f){this.contents.set(this.format.format(new Date()));return this.contents.render(_8e,_8f);},unrender:function(_90,_91){return this.contents.unrender(_90,_91);},clone:function(_92){return new this.constructor(this._format,this.contents.clone(_92));}});dojox.dtl.tag.date.now=function(_93,_94){var _95=_94.split_contents();if(_95.length!=2){throw new Error("'now' statement takes one argument");}return new dojox.dtl.tag.date.NowNode(_95[1].slice(1,-1),_93.create_text_node());};return dojox.dtl.tag.date;});},"dojox/dtl/tag/loader":function(){define(["dojo/_base/lang","../_base","dojo/_base/array","dojo/_base/connect"],function(_96,dd,_97,_98){_96.getObject("dojox.dtl.tag.loader",true);var _99=dd.tag.loader;_99.BlockNode=_96.extend(function(_9a,_9b){this.name=_9a;this.nodelist=_9b;},{"super":function(){if(this.parent){var _9c=this.parent.nodelist.dummyRender(this.context,null,true);if(typeof _9c=="string"){_9c=new String(_9c);}_9c.safe=true;return _9c;}return "";},render:function(_9d,_9e){var _9f=this.name;var _a0=this.nodelist;var _a1;if(_9e.blocks){var _a2=_9e.blocks[_9f];if(_a2){_a1=_a2.parent;_a0=_a2.nodelist;_a2.used=true;}}this.rendered=_a0;_9d=_9d.push();this.context=_9d;this.parent=null;if(_a0!=this.nodelist){this.parent=this;}_9d.block=this;if(_9e.getParent){var _a3=_9e.getParent();var _a4=_98.connect(_9e,"onSetParent",function(_a5,up,_a6){if(up&&_a6){_9e.setParent(_a3);}});}_9e=_a0.render(_9d,_9e,this);_a4&&_98.disconnect(_a4);_9d=_9d.pop();return _9e;},unrender:function(_a7,_a8){return this.rendered.unrender(_a7,_a8);},clone:function(_a9){return new this.constructor(this.name,this.nodelist.clone(_a9));},toString:function(){return "dojox.dtl.tag.loader.BlockNode";}});_99.ExtendsNode=_96.extend(function(_aa,_ab,_ac,_ad,key){this.getTemplate=_aa;this.nodelist=_ab;this.shared=_ac;this.parent=_ad;this.key=key;},{parents:{},getParent:function(_ae){var _af=this.parent;if(!_af){var _b0;_af=this.parent=_ae.get(this.key,false);if(!_af){throw new Error("extends tag used a variable that did not resolve");}if(typeof _af=="object"){var url=_af.url||_af.templatePath;if(_af.shared){this.shared=true;}if(url){_af=this.parent=url.toString();}else{if(_af.templateString){_b0=_af.templateString;_af=this.parent=" ";}else{_af=this.parent=this.parent.toString();}}}if(_af&&_af.indexOf("shared:")===0){this.shared=true;_af=this.parent=_af.substring(7,_af.length);}}if(!_af){throw new Error("Invalid template name in 'extends' tag.");}if(_af.render){return _af;}if(this.parents[_af]){return this.parents[_af];}this.parent=this.getTemplate(_b0||dojox.dtl.text.getTemplateString(_af));if(this.shared){this.parents[_af]=this.parent;}return this.parent;},render:function(_b1,_b2){var _b3=this.getParent(_b1);_b3.blocks=_b3.blocks||{};_b2.blocks=_b2.blocks||{};for(var i=0,_b4;_b4=this.nodelist.contents[i];i++){if(_b4 instanceof dojox.dtl.tag.loader.BlockNode){var old=_b3.blocks[_b4.name];if(old&&old.nodelist!=_b4.nodelist){_b2=old.nodelist.unrender(_b1,_b2);}_b3.blocks[_b4.name]=_b2.blocks[_b4.name]={shared:this.shared,nodelist:_b4.nodelist,used:false};}}this.rendered=_b3;return _b3.nodelist.render(_b1,_b2,this);},unrender:function(_b5,_b6){return this.rendered.unrender(_b5,_b6,this);},toString:function(){return "dojox.dtl.block.ExtendsNode";}});_99.IncludeNode=_96.extend(function(_b7,_b8,_b9,_ba,_bb){this._path=_b7;this.constant=_b8;this.path=(_b8)?_b7:new dd._Filter(_b7);this.getTemplate=_b9;this.text=_ba;this.parsed=(arguments.length==5)?_bb:true;},{_cache:[{},{}],render:function(_bc,_bd){var _be=((this.constant)?this.path:this.path.resolve(_bc)).toString();var _bf=Number(this.parsed);var _c0=false;if(_be!=this.last){_c0=true;if(this.last){_bd=this.unrender(_bc,_bd);}this.last=_be;}var _c1=this._cache[_bf];if(_bf){if(!_c1[_be]){_c1[_be]=dd.text._resolveTemplateArg(_be,true);}if(_c0){var _c2=this.getTemplate(_c1[_be]);this.rendered=_c2.nodelist;}return this.rendered.render(_bc,_bd,this);}else{if(this.text instanceof dd._TextNode){if(_c0){this.rendered=this.text;this.rendered.set(dd.text._resolveTemplateArg(_be,true));}return this.rendered.render(_bc,_bd);}else{if(!_c1[_be]){var _c3=[];var div=document.createElement("div");div.innerHTML=dd.text._resolveTemplateArg(_be,true);var _c4=div.childNodes;while(_c4.length){var _c5=div.removeChild(_c4[0]);_c3.push(_c5);}_c1[_be]=_c3;}if(_c0){this.nodelist=[];var _c6=true;for(var i=0,_c7;_c7=_c1[_be][i];i++){this.nodelist.push(_c7.cloneNode(true));}}for(var i=0,_c8;_c8=this.nodelist[i];i++){_bd=_bd.concat(_c8);}}}return _bd;},unrender:function(_c9,_ca){if(this.rendered){_ca=this.rendered.unrender(_c9,_ca);}if(this.nodelist){for(var i=0,_cb;_cb=this.nodelist[i];i++){_ca=_ca.remove(_cb);}}return _ca;},clone:function(_cc){return new this.constructor(this._path,this.constant,this.getTemplate,this.text.clone(_cc),this.parsed);}});_96.mixin(_99,{block:function(_cd,_ce){var _cf=_ce.contents.split();var _d0=_cf[1];_cd._blocks=_cd._blocks||{};_cd._blocks[_d0]=_cd._blocks[_d0]||[];_cd._blocks[_d0].push(_d0);var _d1=_cd.parse(["endblock","endblock "+_d0]).rtrim();_cd.next_token();return new dojox.dtl.tag.loader.BlockNode(_d0,_d1);},extends_:function(_d2,_d3){var _d4=_d3.contents.split();var _d5=false;var _d6=null;var key=null;if(_d4[1].charAt(0)=="\""||_d4[1].charAt(0)=="'"){_d6=_d4[1].substring(1,_d4[1].length-1);}else{key=_d4[1];}if(_d6&&_d6.indexOf("shared:")==0){_d5=true;_d6=_d6.substring(7,_d6.length);}var _d7=_d2.parse();return new dojox.dtl.tag.loader.ExtendsNode(_d2.getTemplate,_d7,_d5,_d6,key);},include:function(_d8,_d9){var _da=_d9.contents.split();if(_da.length!=2){throw new Error(_da[0]+" tag takes one argument: the name of the template to be included");}var _db=_da[1];var _dc=false;if((_db.charAt(0)=="\""||_db.slice(-1)=="'")&&_db.charAt(0)==_db.slice(-1)){_db=_db.slice(1,-1);_dc=true;}return new _99.IncludeNode(_db,_dc,_d8.getTemplate,_d8.create_text_node());},ssi:function(_dd,_de){var _df=_de.contents.split();var _e0=false;if(_df.length==3){_e0=(_df.pop()=="parsed");if(!_e0){throw new Error("Second (optional) argument to ssi tag must be 'parsed'");}}var _e1=_99.include(_dd,new dd.Token(_de.token_type,_df.join(" ")));_e1.parsed=_e0;return _e1;}});return dojox.dtl.tag.loader;});},"dojox/dtl/Context":function(){define(["dojo/_base/lang","./_base"],function(_e2,dd){dd.Context=_e2.extend(function(_e3){this._this={};dd._Context.call(this,_e3);},dd._Context.prototype,{getKeys:function(){var _e4=[];for(var key in this){if(this.hasOwnProperty(key)&&key!="_this"){_e4.push(key);}}return _e4;},extend:function(obj){return _e2.delegate(this,obj);},filter:function(_e5){var _e6=new dd.Context();var _e7=[];var i,arg;if(_e5 instanceof dd.Context){_e7=_e5.getKeys();}else{if(typeof _e5=="object"){for(var key in _e5){_e7.push(key);}}else{for(i=0;arg=arguments[i];i++){if(typeof arg=="string"){_e7.push(arg);}}}}for(i=0,key;key=_e7[i];i++){_e6[key]=this[key];}return _e6;},setThis:function(_e8){this._this=_e8;},getThis:function(){return this._this;},hasKey:function(key){if(this._getter){var got=this._getter(key);if(typeof got!="undefined"){return true;}}if(typeof this[key]!="undefined"){return true;}return false;}});return dd.Context;});},"dojox/string/tokenize":function(){define(["dojo/_base/lang","dojo/_base/sniff"],function(_e9,has){var _ea=_e9.getObject("dojox.string",true).tokenize;_ea=function(str,re,_eb,_ec){var _ed=[];var _ee,_ef,_f0=0;while(_ee=re.exec(str)){_ef=str.slice(_f0,re.lastIndex-_ee[0].length);if(_ef.length){_ed.push(_ef);}if(_eb){if(has("opera")){var _f1=_ee.slice(0);while(_f1.length<_ee.length){_f1.push(null);}_ee=_f1;}var _f2=_eb.apply(_ec,_ee.slice(1).concat(_ed.length));if(typeof _f2!="undefined"){_ed.push(_f2);}}_f0=re.lastIndex;}_ef=str.slice(_f0);if(_ef.length){_ed.push(_ef);}return _ed;};return _ea;});},"dojox/dtl/tag/misc":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/connect","../_base"],function(_f3,_f4,_f5,dd){_f3.getObject("dojox.dtl.tag.misc",true);var _f6=dd.tag.misc;_f6.DebugNode=_f3.extend(function(_f7){this.text=_f7;},{render:function(_f8,_f9){var _fa=_f8.getKeys();var _fb=[];var _fc={};for(var i=0,key;key=_fa[i];i++){_fc[key]=_f8[key];_fb+="["+key+": "+typeof _f8[key]+"]\n";}return this.text.set(_fb).render(_f8,_f9,this);},unrender:function(_fd,_fe){return _fe;},clone:function(_ff){return new this.constructor(this.text.clone(_ff));},toString:function(){return "ddtm.DebugNode";}});_f6.FilterNode=_f3.extend(function(_100,_101){this._varnode=_100;this._nodelist=_101;},{render:function(_102,_103){var _104=this._nodelist.render(_102,new dojox.string.Builder());_102=_102.update({"var":_104.toString()});var _105=this._varnode.render(_102,_103);_102=_102.pop();return _103;},unrender:function(_106,_107){return _107;},clone:function(_108){return new this.constructor(this._expression,this._nodelist.clone(_108));}});_f6.FirstOfNode=_f3.extend(function(vars,text){this._vars=vars;this.vars=_f4.map(vars,function(item){return new dojox.dtl._Filter(item);});this.contents=text;},{render:function(_109,_10a){for(var i=0,item;item=this.vars[i];i++){var _10b=item.resolve(_109);if(typeof _10b!="undefined"){if(_10b===null){_10b="null";}this.contents.set(_10b);return this.contents.render(_109,_10a);}}return this.contents.unrender(_109,_10a);},unrender:function(_10c,_10d){return this.contents.unrender(_10c,_10d);},clone:function(_10e){return new this.constructor(this._vars,this.contents.clone(_10e));}});_f6.SpacelessNode=_f3.extend(function(_10f,text){this.nodelist=_10f;this.contents=text;},{render:function(_110,_111){if(_111.getParent){var _112=[_f5.connect(_111,"onAddNodeComplete",this,"_watch"),_f5.connect(_111,"onSetParent",this,"_watchParent")];_111=this.nodelist.render(_110,_111);_f5.disconnect(_112[0]);_f5.disconnect(_112[1]);}else{var _113=this.nodelist.dummyRender(_110);this.contents.set(_113.replace(/>\s+</g,"><"));_111=this.contents.render(_110,_111);}return _111;},unrender:function(_114,_115){return this.nodelist.unrender(_114,_115);},clone:function(_116){return new this.constructor(this.nodelist.clone(_116),this.contents.clone(_116));},_isEmpty:function(node){return (node.nodeType==3&&!node.data.match(/[^\s\n]/));},_watch:function(node){if(this._isEmpty(node)){var _117=false;if(node.parentNode.firstChild==node){node.parentNode.removeChild(node);}}else{var _118=node.parentNode.childNodes;if(node.nodeType==1&&_118.length>2){for(var i=2,_119;_119=_118[i];i++){if(_118[i-2].nodeType==1&&this._isEmpty(_118[i-1])){node.parentNode.removeChild(_118[i-1]);return;}}}}},_watchParent:function(node){var _11a=node.childNodes;if(_11a.length){while(node.childNodes.length){var last=node.childNodes[node.childNodes.length-1];if(!this._isEmpty(last)){return;}node.removeChild(last);}}}});_f6.TemplateTagNode=_f3.extend(function(tag,text){this.tag=tag;this.contents=text;},{mapping:{openblock:"{%",closeblock:"%}",openvariable:"{{",closevariable:"}}",openbrace:"{",closebrace:"}",opencomment:"{#",closecomment:"#}"},render:function(_11b,_11c){this.contents.set(this.mapping[this.tag]);return this.contents.render(_11b,_11c);},unrender:function(_11d,_11e){return this.contents.unrender(_11d,_11e);},clone:function(_11f){return new this.constructor(this.tag,this.contents.clone(_11f));}});_f6.WidthRatioNode=_f3.extend(function(_120,max,_121,text){this.current=new dd._Filter(_120);this.max=new dd._Filter(max);this.width=_121;this.contents=text;},{render:function(_122,_123){var _124=+this.current.resolve(_122);var max=+this.max.resolve(_122);if(typeof _124!="number"||typeof max!="number"||!max){this.contents.set("");}else{this.contents.set(""+Math.round((_124/max)*this.width));}return this.contents.render(_122,_123);},unrender:function(_125,_126){return this.contents.unrender(_125,_126);},clone:function(_127){return new this.constructor(this.current.getExpression(),this.max.getExpression(),this.width,this.contents.clone(_127));}});_f6.WithNode=_f3.extend(function(_128,_129,_12a){this.target=new dd._Filter(_128);this.alias=_129;this.nodelist=_12a;},{render:function(_12b,_12c){var _12d=this.target.resolve(_12b);_12b=_12b.push();_12b[this.alias]=_12d;_12c=this.nodelist.render(_12b,_12c);_12b=_12b.pop();return _12c;},unrender:function(_12e,_12f){return _12f;},clone:function(_130){return new this.constructor(this.target.getExpression(),this.alias,this.nodelist.clone(_130));}});_f3.mixin(_f6,{comment:function(_131,_132){_131.skip_past("endcomment");return dd._noOpNode;},debug:function(_133,_134){return new _f6.DebugNode(_133.create_text_node());},filter:function(_135,_136){var rest=_136.contents.split(null,1)[1];var _137=_135.create_variable_node("var|"+rest);var _138=_135.parse(["endfilter"]);_135.next_token();return new _f6.FilterNode(_137,_138);},firstof:function(_139,_13a){var _13b=_13a.split_contents().slice(1);if(!_13b.length){throw new Error("'firstof' statement requires at least one argument");}return new _f6.FirstOfNode(_13b,_139.create_text_node());},spaceless:function(_13c,_13d){var _13e=_13c.parse(["endspaceless"]);_13c.delete_first_token();return new _f6.SpacelessNode(_13e,_13c.create_text_node());},templatetag:function(_13f,_140){var _141=_140.contents.split();if(_141.length!=2){throw new Error("'templatetag' statement takes one argument");}var tag=_141[1];var _142=_f6.TemplateTagNode.prototype.mapping;if(!_142[tag]){var keys=[];for(var key in _142){keys.push(key);}throw new Error("Invalid templatetag argument: '"+tag+"'. Must be one of: "+keys.join(", "));}return new _f6.TemplateTagNode(tag,_13f.create_text_node());},widthratio:function(_143,_144){var _145=_144.contents.split();if(_145.length!=4){throw new Error("widthratio takes three arguments");}var _146=+_145[3];if(typeof _146!="number"){throw new Error("widthratio final argument must be an integer");}return new _f6.WidthRatioNode(_145[1],_145[2],_146,_143.create_text_node());},with_:function(_147,_148){var _149=_148.split_contents();if(_149.length!=4||_149[2]!="as"){throw new Error("do_width expected format as 'with value as name'");}var _14a=_147.parse(["endwith"]);_147.next_token();return new _f6.WithNode(_149[1],_149[3],_14a);}});return dojox.dtl.tag.misc;});},"dojox/string/Builder":function(){define(["dojo/_base/lang"],function(lang){lang.getObject("string",true,dojox).Builder=function(str){var b="";this.length=0;this.append=function(s){if(arguments.length>1){var tmp="",l=arguments.length;switch(l){case 9:tmp=""+arguments[8]+tmp;case 8:tmp=""+arguments[7]+tmp;case 7:tmp=""+arguments[6]+tmp;case 6:tmp=""+arguments[5]+tmp;case 5:tmp=""+arguments[4]+tmp;case 4:tmp=""+arguments[3]+tmp;case 3:tmp=""+arguments[2]+tmp;case 2:b+=""+arguments[0]+arguments[1]+tmp;break;default:var i=0;while(i<arguments.length){tmp+=arguments[i++];}b+=tmp;}}else{b+=s;}this.length=b.length;return this;};this.concat=function(s){return this.append.apply(this,arguments);};this.appendArray=function(_14b){return this.append.apply(this,_14b);};this.clear=function(){b="";this.length=0;return this;};this.replace=function(_14c,_14d){b=b.replace(_14c,_14d);this.length=b.length;return this;};this.remove=function(_14e,len){if(len===undefined){len=b.length;}if(len==0){return this;}b=b.substr(0,_14e)+b.substr(_14e+len);this.length=b.length;return this;};this.insert=function(_14f,str){if(_14f==0){b=str+b;}else{b=b.slice(0,_14f)+str+b.slice(_14f);}this.length=b.length;return this;};this.toString=function(){return b;};if(str){this.append(str);}};return dojox.string.Builder;});},"dojox/dtl/ext-dojo/NodeList":function(){define(["dojo/_base/lang","dojo/query","../_base"],function(lang,_150,dd){var nl=lang.getObject("dojox.dtl.ext-dojo.NodeList",true);var _151=_150.NodeList;lang.extend(_151,{dtl:function(_152,_153){var d=dd,self=this;var _154=function(_155,_156){var _157=_155.render(new d._Context(_156));self.forEach(function(node){node.innerHTML=_157;});};d.text._resolveTemplateArg(_152).addCallback(function(_158){_152=new d.Template(_158);d.text._resolveContextArg(_153).addCallback(function(_159){_154(_152,_159);});});return this;}});return _151;});},"dojox/dtl/tag/logic":function(){define(["dojo/_base/lang","../_base"],function(lang,dd){lang.getObject("dojox.dtl.tag.logic",true);var ddt=dd.text;var ddtl=dd.tag.logic;ddtl.IfNode=lang.extend(function(_15a,_15b,_15c,type){this.bools=_15a;this.trues=_15b;this.falses=_15c;this.type=type;},{render:function(_15d,_15e){var i,bool,_15f,_160,_161;if(this.type=="or"){for(i=0;bool=this.bools[i];i++){_15f=bool[0];_160=bool[1];_161=_160.resolve(_15d);if((_161&&!_15f)||(_15f&&!_161)){if(this.falses){_15e=this.falses.unrender(_15d,_15e);}return (this.trues)?this.trues.render(_15d,_15e,this):_15e;}}if(this.trues){_15e=this.trues.unrender(_15d,_15e);}return (this.falses)?this.falses.render(_15d,_15e,this):_15e;}else{for(i=0;bool=this.bools[i];i++){_15f=bool[0];_160=bool[1];_161=_160.resolve(_15d);if(_161==_15f){if(this.trues){_15e=this.trues.unrender(_15d,_15e);}return (this.falses)?this.falses.render(_15d,_15e,this):_15e;}}if(this.falses){_15e=this.falses.unrender(_15d,_15e);}return (this.trues)?this.trues.render(_15d,_15e,this):_15e;}return _15e;},unrender:function(_162,_163){_163=(this.trues)?this.trues.unrender(_162,_163):_163;_163=(this.falses)?this.falses.unrender(_162,_163):_163;return _163;},clone:function(_164){var _165=(this.trues)?this.trues.clone(_164):null;var _166=(this.falses)?this.falses.clone(_164):null;return new this.constructor(this.bools,_165,_166,this.type);}});ddtl.IfEqualNode=lang.extend(function(var1,var2,_167,_168,_169){this.var1=new dd._Filter(var1);this.var2=new dd._Filter(var2);this.trues=_167;this.falses=_168;this.negate=_169;},{render:function(_16a,_16b){var var1=this.var1.resolve(_16a);var var2=this.var2.resolve(_16a);var1=(typeof var1!="undefined")?var1:"";var2=(typeof var1!="undefined")?var2:"";if((this.negate&&var1!=var2)||(!this.negate&&var1==var2)){if(this.falses){_16b=this.falses.unrender(_16a,_16b,this);}return (this.trues)?this.trues.render(_16a,_16b,this):_16b;}if(this.trues){_16b=this.trues.unrender(_16a,_16b,this);}return (this.falses)?this.falses.render(_16a,_16b,this):_16b;},unrender:function(_16c,_16d){return ddtl.IfNode.prototype.unrender.call(this,_16c,_16d);},clone:function(_16e){var _16f=this.trues?this.trues.clone(_16e):null;var _170=this.falses?this.falses.clone(_16e):null;return new this.constructor(this.var1.getExpression(),this.var2.getExpression(),_16f,_170,this.negate);}});ddtl.ForNode=lang.extend(function(_171,loop,_172,_173){this.assign=_171;this.loop=new dd._Filter(loop);this.reversed=_172;this.nodelist=_173;this.pool=[];},{render:function(_174,_175){var i,j,k;var _176=false;var _177=this.assign;for(k=0;k<_177.length;k++){if(typeof _174[_177[k]]!="undefined"){_176=true;_174=_174.push();break;}}if(!_176&&_174.forloop){_176=true;_174=_174.push();}var _178=this.loop.resolve(_174)||[];for(i=_178.length;i<this.pool.length;i++){this.pool[i].unrender(_174,_175,this);}if(this.reversed){_178=_178.slice(0).reverse();}var _179=lang.isObject(_178)&&!lang.isArrayLike(_178);var _17a=[];if(_179){for(var key in _178){_17a.push(_178[key]);}}else{_17a=_178;}var _17b=_174.forloop={parentloop:_174.get("forloop",{})};var j=0;for(i=0;i<_17a.length;i++){var item=_17a[i];_17b.counter0=j;_17b.counter=j+1;_17b.revcounter0=_17a.length-j-1;_17b.revcounter=_17a.length-j;_17b.first=!j;_17b.last=(j==_17a.length-1);if(_177.length>1&&lang.isArrayLike(item)){if(!_176){_176=true;_174=_174.push();}var _17c={};for(k=0;k<item.length&&k<_177.length;k++){_17c[_177[k]]=item[k];}lang.mixin(_174,_17c);}else{_174[_177[0]]=item;}if(j+1>this.pool.length){this.pool.push(this.nodelist.clone(_175));}_175=this.pool[j++].render(_174,_175,this);}delete _174.forloop;if(_176){_174=_174.pop();}else{for(k=0;k<_177.length;k++){delete _174[_177[k]];}}return _175;},unrender:function(_17d,_17e){for(var i=0,pool;pool=this.pool[i];i++){_17e=pool.unrender(_17d,_17e);}return _17e;},clone:function(_17f){return new this.constructor(this.assign,this.loop.getExpression(),this.reversed,this.nodelist.clone(_17f));}});lang.mixin(ddtl,{if_:function(_180,_181){var i,part,type,_182=[],_183=_181.contents.split();_183.shift();_181=_183.join(" ");_183=_181.split(" and ");if(_183.length==1){type="or";_183=_181.split(" or ");}else{type="and";for(i=0;i<_183.length;i++){if(_183[i].indexOf(" or ")!=-1){throw new Error("'if' tags can't mix 'and' and 'or'");}}}for(i=0;part=_183[i];i++){var not=false;if(part.indexOf("not ")==0){part=part.slice(4);not=true;}_182.push([not,new dd._Filter(part)]);}var _184=_180.parse(["else","endif"]);var _185=false;var _181=_180.next_token();if(_181.contents=="else"){_185=_180.parse(["endif"]);_180.next_token();}return new ddtl.IfNode(_182,_184,_185,type);},_ifequal:function(_186,_187,_188){var _189=_187.split_contents();if(_189.length!=3){throw new Error(_189[0]+" takes two arguments");}var end="end"+_189[0];var _18a=_186.parse(["else",end]);var _18b=false;var _187=_186.next_token();if(_187.contents=="else"){_18b=_186.parse([end]);_186.next_token();}return new ddtl.IfEqualNode(_189[1],_189[2],_18a,_18b,_188);},ifequal:function(_18c,_18d){return ddtl._ifequal(_18c,_18d);},ifnotequal:function(_18e,_18f){return ddtl._ifequal(_18e,_18f,true);},for_:function(_190,_191){var _192=_191.contents.split();if(_192.length<4){throw new Error("'for' statements should have at least four words: "+_191.contents);}var _193=_192[_192.length-1]=="reversed";var _194=(_193)?-3:-2;if(_192[_192.length+_194]!="in"){throw new Error("'for' tag received an invalid argument: "+_191.contents);}var _195=_192.slice(1,_194).join(" ").split(/ *, */);for(var i=0;i<_195.length;i++){if(!_195[i]||_195[i].indexOf(" ")!=-1){throw new Error("'for' tag received an invalid argument: "+_191.contents);}}var _196=_190.parse(["endfor"]);_190.next_token();return new ddtl.ForNode(_195,_192[_192.length+_194+1],_193,_196);}});return dojox.dtl.tag.logic;});},"dojox/date/php":function(){define(["dojo/_base/kernel","dojo/_base/lang","dojo/date","dojox/string/tokenize"],function(dojo,_197,_198,dxst){dojo.getObject("date.php",true,dojox);dojox.date.php.format=function(date,_199){var df=new dojox.date.php.DateFormat(_199);return df.format(date);};dojox.date.php.DateFormat=function(_19a){if(!this.regex){var keys=[];for(var key in this.constructor.prototype){if(dojo.isString(key)&&key.length==1&&dojo.isFunction(this[key])){keys.push(key);}}this.constructor.prototype.regex=new RegExp("(?:(\\\\.)|(["+keys.join("")+"]))","g");}var _19b=[];this.tokens=dxst(_19a,this.regex,function(_19c,_19d,i){if(_19d){_19b.push([i,_19d]);return _19d;}if(_19c){return _19c.charAt(1);}});this.replacements=_19b;};dojo.extend(dojox.date.php.DateFormat,{weekdays:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],weekdays_3:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],months:["January","February","March","April","May","June","July","August","September","October","November","December"],months_3:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],monthdays:[31,28,31,30,31,30,31,31,30,31,30,31],format:function(date){this.date=date;for(var i=0,_19e;_19e=this.replacements[i];i++){this.tokens[_19e[0]]=this[_19e[1]]();}return this.tokens.join("");},d:function(){var j=this.j();return (j.length==1)?"0"+j:j;},D:function(){return this.weekdays_3[this.date.getDay()];},j:function(){return this.date.getDate()+"";},l:function(){return this.weekdays[this.date.getDay()];},N:function(){var w=this.w();return (!w)?7:w;},S:function(){switch(this.date.getDate()){case 11:case 12:case 13:return "th";case 1:case 21:case 31:return "st";case 2:case 22:return "nd";case 3:case 23:return "rd";default:return "th";}},w:function(){return this.date.getDay()+"";},z:function(){var _19f=this.date.getTime()-new Date(this.date.getFullYear(),0,1).getTime();return Math.floor(_19f/86400000)+"";},W:function(){var week;var _1a0=new Date(this.date.getFullYear(),0,1).getDay()+1;var w=this.date.getDay()+1;var z=parseInt(this.z());if(z<=(8-_1a0)&&_1a0>4){var _1a1=new Date(this.date.getFullYear()-1,this.date.getMonth(),this.date.getDate());if(_1a0==5||(_1a0==6&&_198.isLeapYear(_1a1))){week=53;}else{week=52;}}else{var i;if(Boolean(this.L())){i=366;}else{i=365;}if((i-z)<(4-w)){week=1;}else{var j=z+(7-w)+(_1a0-1);week=Math.ceil(j/7);if(_1a0>4){--week;}}}return week;},F:function(){return this.months[this.date.getMonth()];},m:function(){var n=this.n();return (n.length==1)?"0"+n:n;},M:function(){return this.months_3[this.date.getMonth()];},n:function(){return this.date.getMonth()+1+"";},t:function(){return (Boolean(this.L())&&this.date.getMonth()==1)?29:this.monthdays[this.getMonth()];},L:function(){return (_198.isLeapYear(this.date))?"1":"0";},o:function(){},Y:function(){return this.date.getFullYear()+"";},y:function(){return this.Y().slice(-2);},a:function(){return this.date.getHours()>=12?"pm":"am";},b:function(){return this.a().toUpperCase();},B:function(){var off=this.date.getTimezoneOffset()+60;var secs=(this.date.getHours()*3600)+(this.date.getMinutes()*60)+this.getSeconds()+(off*60);var beat=Math.abs(Math.floor(secs/86.4)%1000)+"";while(beat.length<2){beat="0"+beat;}return beat;},g:function(){return (this.date.getHours()%12||12)+"";},G:function(){return this.date.getHours()+"";},h:function(){var g=this.g();return (g.length==1)?"0"+g:g;},H:function(){var G=this.G();return (G.length==1)?"0"+G:G;},i:function(){var mins=this.date.getMinutes()+"";return (mins.length==1)?"0"+mins:mins;},s:function(){var secs=this.date.getSeconds()+"";return (secs.length==1)?"0"+secs:secs;},e:function(){return _198.getTimezoneName(this.date);},I:function(){},O:function(){var off=Math.abs(this.date.getTimezoneOffset());var _1a2=Math.floor(off/60)+"";var mins=(off%60)+"";if(_1a2.length==1){_1a2="0"+_1a2;}if(mins.length==1){_1a2="0"+mins;}return ((this.date.getTimezoneOffset()<0)?"+":"-")+_1a2+mins;},P:function(){var O=this.O();return O.substring(0,2)+":"+O.substring(2,4);},T:function(){return this.e().substring(0,3);},Z:function(){return this.date.getTimezoneOffset()*-60;},c:function(){return this.Y()+"-"+this.m()+"-"+this.d()+"T"+this.h()+":"+this.i()+":"+this.s()+this.P();},r:function(){return this.D()+", "+this.d()+" "+this.M()+" "+this.Y()+" "+this.H()+":"+this.i()+":"+this.s()+" "+this.O();},U:function(){return Math.floor(this.date.getTime()/1000);}});return dojox.date.php;});},"dojo/date":function(){define(["./has","./_base/lang"],function(has,lang){var date={};date.getDaysInMonth=function(_1a3){var _1a4=_1a3.getMonth();var days=[31,28,31,30,31,30,31,31,30,31,30,31];if(_1a4==1&&date.isLeapYear(_1a3)){return 29;}return days[_1a4];};date.isLeapYear=function(_1a5){var year=_1a5.getFullYear();return !(year%400)||(!(year%4)&&!!(year%100));};date.getTimezoneName=function(_1a6){var str=_1a6.toString();var tz="";var _1a7;var pos=str.indexOf("(");if(pos>-1){tz=str.substring(++pos,str.indexOf(")"));}else{var pat=/([A-Z\/]+) \d{4}$/;if((_1a7=str.match(pat))){tz=_1a7[1];}else{str=_1a6.toLocaleString();pat=/ ([A-Z\/]+)$/;if((_1a7=str.match(pat))){tz=_1a7[1];}}}return (tz=="AM"||tz=="PM")?"":tz;};date.compare=function(_1a8,_1a9,_1aa){_1a8=new Date(+_1a8);_1a9=new Date(+(_1a9||new Date()));if(_1aa=="date"){_1a8.setHours(0,0,0,0);_1a9.setHours(0,0,0,0);}else{if(_1aa=="time"){_1a8.setFullYear(0,0,0);_1a9.setFullYear(0,0,0);}}if(_1a8>_1a9){return 1;}if(_1a8<_1a9){return -1;}return 0;};date.add=function(date,_1ab,_1ac){var sum=new Date(+date);var _1ad=false;var _1ae="Date";switch(_1ab){case "day":break;case "weekday":var days,_1af;var mod=_1ac%5;if(!mod){days=(_1ac>0)?5:-5;_1af=(_1ac>0)?((_1ac-5)/5):((_1ac+5)/5);}else{days=mod;_1af=parseInt(_1ac/5);}var strt=date.getDay();var adj=0;if(strt==6&&_1ac>0){adj=1;}else{if(strt==0&&_1ac<0){adj=-1;}}var trgt=strt+days;if(trgt==0||trgt==6){adj=(_1ac>0)?2:-2;}_1ac=(7*_1af)+days+adj;break;case "year":_1ae="FullYear";_1ad=true;break;case "week":_1ac*=7;break;case "quarter":_1ac*=3;case "month":_1ad=true;_1ae="Month";break;default:_1ae="UTC"+_1ab.charAt(0).toUpperCase()+_1ab.substring(1)+"s";}if(_1ae){sum["set"+_1ae](sum["get"+_1ae]()+_1ac);}if(_1ad&&(sum.getDate()<date.getDate())){sum.setDate(0);}return sum;};date.difference=function(_1b0,_1b1,_1b2){_1b1=_1b1||new Date();_1b2=_1b2||"day";var _1b3=_1b1.getFullYear()-_1b0.getFullYear();var _1b4=1;switch(_1b2){case "quarter":var m1=_1b0.getMonth();var m2=_1b1.getMonth();var q1=Math.floor(m1/3)+1;var q2=Math.floor(m2/3)+1;q2+=(_1b3*4);_1b4=q2-q1;break;case "weekday":var days=Math.round(date.difference(_1b0,_1b1,"day"));var _1b5=parseInt(date.difference(_1b0,_1b1,"week"));var mod=days%7;if(mod==0){days=_1b5*5;}else{var adj=0;var aDay=_1b0.getDay();var bDay=_1b1.getDay();_1b5=parseInt(days/7);mod=days%7;var _1b6=new Date(_1b0);_1b6.setDate(_1b6.getDate()+(_1b5*7));var _1b7=_1b6.getDay();if(days>0){switch(true){case aDay==6:adj=-1;break;case aDay==0:adj=0;break;case bDay==6:adj=-1;break;case bDay==0:adj=-2;break;case (_1b7+mod)>5:adj=-2;}}else{if(days<0){switch(true){case aDay==6:adj=0;break;case aDay==0:adj=1;break;case bDay==6:adj=2;break;case bDay==0:adj=1;break;case (_1b7+mod)<0:adj=2;}}}days+=adj;days-=(_1b5*2);}_1b4=days;break;case "year":_1b4=_1b3;break;case "month":_1b4=(_1b1.getMonth()-_1b0.getMonth())+(_1b3*12);break;case "week":_1b4=parseInt(date.difference(_1b0,_1b1,"day")/7);break;case "day":_1b4/=24;case "hour":_1b4/=60;case "minute":_1b4/=60;case "second":_1b4/=1000;case "millisecond":_1b4*=_1b1.getTime()-_1b0.getTime();}return Math.round(_1b4);};1&&lang.mixin(lang.getObject("dojo.date",true),date);return date;});},"dojox/dtl/tag/loop":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/json","../_base","dojox/string/tokenize"],function(lang,_1b8,json,dd,_1b9){lang.getObject("dojox.dtl.tag.loop",true);var ddtl=dd.tag.loop;ddtl.CycleNode=lang.extend(function(_1ba,name,text,_1bb){this.cyclevars=_1ba;this.name=name;this.contents=text;this.shared=_1bb||{counter:-1,map:{}};},{render:function(_1bc,_1bd){if(_1bc.forloop&&!_1bc.forloop.counter0){this.shared.counter=-1;}++this.shared.counter;var _1be=this.cyclevars[this.shared.counter%this.cyclevars.length];var map=this.shared.map;if(!map[_1be]){map[_1be]=new dd._Filter(_1be);}_1be=map[_1be].resolve(_1bc,_1bd);if(this.name){_1bc[this.name]=_1be;}this.contents.set(_1be);return this.contents.render(_1bc,_1bd);},unrender:function(_1bf,_1c0){return this.contents.unrender(_1bf,_1c0);},clone:function(_1c1){return new this.constructor(this.cyclevars,this.name,this.contents.clone(_1c1),this.shared);}});ddtl.IfChangedNode=lang.extend(function(_1c2,vars,_1c3){this.nodes=_1c2;this._vars=vars;this.shared=_1c3||{last:null,counter:0};this.vars=_1b8.map(vars,function(item){return new dojox.dtl._Filter(item);});},{render:function(_1c4,_1c5){if(_1c4.forloop){if(_1c4.forloop.counter<=this.shared.counter){this.shared.last=null;}this.shared.counter=_1c4.forloop.counter;}var _1c6;if(this.vars.length){_1c6=json.toJson(_1b8.map(this.vars,function(item){return item.resolve(_1c4);}));}else{_1c6=this.nodes.dummyRender(_1c4,_1c5);}if(_1c6!=this.shared.last){var _1c7=(this.shared.last===null);this.shared.last=_1c6;_1c4=_1c4.push();_1c4.ifchanged={firstloop:_1c7};_1c5=this.nodes.render(_1c4,_1c5);_1c4=_1c4.pop();}else{_1c5=this.nodes.unrender(_1c4,_1c5);}return _1c5;},unrender:function(_1c8,_1c9){return this.nodes.unrender(_1c8,_1c9);},clone:function(_1ca){return new this.constructor(this.nodes.clone(_1ca),this._vars,this.shared);}});ddtl.RegroupNode=lang.extend(function(_1cb,key,_1cc){this._expression=_1cb;this.expression=new dd._Filter(_1cb);this.key=key;this.alias=_1cc;},{_push:function(_1cd,_1ce,_1cf){if(_1cf.length){_1cd.push({grouper:_1ce,list:_1cf});}},render:function(_1d0,_1d1){_1d0[this.alias]=[];var list=this.expression.resolve(_1d0);if(list){var last=null;var _1d2=[];for(var i=0;i<list.length;i++){var id=list[i][this.key];if(last!==id){this._push(_1d0[this.alias],last,_1d2);last=id;_1d2=[list[i]];}else{_1d2.push(list[i]);}}this._push(_1d0[this.alias],last,_1d2);}return _1d1;},unrender:function(_1d3,_1d4){return _1d4;},clone:function(_1d5,_1d6){return this;}});lang.mixin(ddtl,{cycle:function(_1d7,_1d8){var args=_1d8.split_contents();if(args.length<2){throw new Error("'cycle' tag requires at least two arguments");}if(args[1].indexOf(",")!=-1){var vars=args[1].split(",");args=[args[0]];for(var i=0;i<vars.length;i++){args.push("\""+vars[i]+"\"");}}if(args.length==2){var name=args[args.length-1];if(!_1d7._namedCycleNodes){throw new Error("No named cycles in template: '"+name+"' is not defined");}if(!_1d7._namedCycleNodes[name]){throw new Error("Named cycle '"+name+"' does not exist");}return _1d7._namedCycleNodes[name];}if(args.length>4&&args[args.length-2]=="as"){var name=args[args.length-1];var node=new ddtl.CycleNode(args.slice(1,args.length-2),name,_1d7.create_text_node());if(!_1d7._namedCycleNodes){_1d7._namedCycleNodes={};}_1d7._namedCycleNodes[name]=node;}else{node=new ddtl.CycleNode(args.slice(1),null,_1d7.create_text_node());}return node;},ifchanged:function(_1d9,_1da){var _1db=_1da.contents.split();var _1dc=_1d9.parse(["endifchanged"]);_1d9.delete_first_token();return new ddtl.IfChangedNode(_1dc,_1db.slice(1));},regroup:function(_1dd,_1de){var _1df=_1b9(_1de.contents,/(\s+)/g,function(_1e0){return _1e0;});if(_1df.length<11||_1df[_1df.length-3]!="as"||_1df[_1df.length-7]!="by"){throw new Error("Expected the format: regroup list by key as newList");}var _1e1=_1df.slice(2,-8).join("");var key=_1df[_1df.length-5];var _1e2=_1df[_1df.length-1];return new ddtl.RegroupNode(_1e1,key,_1e2);}});return dojox.dtl.tag.loop;});}}});define("dojox/dtl",["./dtl/_base"],function(_1e3){return _1e3;});