/*
	Copyright (c) 2004-2011, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is an optimized version of Dojo, built for deployment and not for
	development. To get sources and documentation, please visit:

		http://dojotoolkit.org
*/

//>>built
require({cache:{"dijit/_editor/plugins/FontChoice":function(){define(["require","dojo/_base/array","dojo/_base/declare","dojo/dom-construct","dojo/i18n","dojo/_base/lang","dojo/store/Memory","../../registry","../../_Widget","../../_TemplatedMixin","../../_WidgetsInTemplateMixin","../../form/FilteringSelect","../_Plugin","../range","dojo/i18n!../nls/FontChoice"],function(_1,_2,_3,_4,_5,_6,_7,_8,_9,_a,_b,_c,_d,_e){var _f=_3("dijit._editor.plugins._FontDropDown",[_9,_a,_b],{label:"",plainText:false,templateString:"<span style='white-space: nowrap' class='dijit dijitReset dijitInline'>"+"<label class='dijitLeft dijitInline' for='${selectId}'>${label}</label>"+"<input data-dojo-type='../../form/FilteringSelect' required='false' "+"data-dojo-props='labelType:\"html\", labelAttr:\"label\", searchAttr:\"name\"' "+"class='${comboClass}' "+"tabIndex='-1' id='${selectId}' data-dojo-attach-point='select' value=''/>"+"</span>",contextRequire:_1,postMixInProperties:function(){this.inherited(arguments);this.strings=_5.getLocalization("dijit._editor","FontChoice");this.label=this.strings[this.command];this.id=_8.getUniqueId(this.declaredClass.replace(/\./g,"_"));this.selectId=this.id+"_select";this.inherited(arguments);},postCreate:function(){this.select.set("store",new _7({idProperty:"value",data:_2.map(this.values,function(_10){var _11=this.strings[_10]||_10;return {label:this.getLabel(_10,_11),name:_11,value:_10};},this)}));this.select.set("value","",false);this.disabled=this.select.get("disabled");},_setValueAttr:function(_12,_13){_13=_13!==false;this.select.set("value",_2.indexOf(this.values,_12)<0?"":_12,_13);if(!_13){this.select._lastValueReported=null;}},_getValueAttr:function(){return this.select.get("value");},focus:function(){this.select.focus();},_setDisabledAttr:function(_14){this._set("disabled",_14);this.select.set("disabled",_14);}});var _15=_3("dijit._editor.plugins._FontNameDropDown",_f,{generic:false,command:"fontName",comboClass:"dijitFontNameCombo",postMixInProperties:function(){if(!this.values){this.values=this.generic?["serif","sans-serif","monospace","cursive","fantasy"]:["Arial","Times New Roman","Comic Sans MS","Courier New"];}this.inherited(arguments);},getLabel:function(_16,_17){if(this.plainText){return _17;}else{return "<div style='font-family: "+_16+"'>"+_17+"</div>";}},_setValueAttr:function(_18,_19){_19=_19!==false;if(this.generic){var map={"Arial":"sans-serif","Helvetica":"sans-serif","Myriad":"sans-serif","Times":"serif","Times New Roman":"serif","Comic Sans MS":"cursive","Apple Chancery":"cursive","Courier":"monospace","Courier New":"monospace","Papyrus":"fantasy","Estrangelo Edessa":"cursive","Gabriola":"fantasy"};_18=map[_18]||_18;}this.inherited(arguments,[_18,_19]);}});var _1a=_3("dijit._editor.plugins._FontSizeDropDown",_f,{command:"fontSize",comboClass:"dijitFontSizeCombo",values:[1,2,3,4,5,6,7],getLabel:function(_1b,_1c){if(this.plainText){return _1c;}else{return "<font size="+_1b+"'>"+_1c+"</font>";}},_setValueAttr:function(_1d,_1e){_1e=_1e!==false;if(_1d.indexOf&&_1d.indexOf("px")!=-1){var _1f=parseInt(_1d,10);_1d={10:1,13:2,16:3,18:4,24:5,32:6,48:7}[_1f]||_1d;}this.inherited(arguments,[_1d,_1e]);}});var _20=_3("dijit._editor.plugins._FormatBlockDropDown",_f,{command:"formatBlock",comboClass:"dijitFormatBlockCombo",values:["noFormat","p","h1","h2","h3","pre"],postCreate:function(){this.inherited(arguments);this.set("value","noFormat",false);},getLabel:function(_21,_22){if(this.plainText||_21=="noFormat"){return _22;}else{return "<"+_21+">"+_22+"</"+_21+">";}},_execCommand:function(_23,_24,_25){if(_25==="noFormat"){var _26;var end;var sel=_e.getSelection(_23.window);if(sel&&sel.rangeCount>0){var _27=sel.getRangeAt(0);var _28,tag;if(_27){_26=_27.startContainer;end=_27.endContainer;while(_26&&_26!==_23.editNode&&_26!==_23.document.body&&_26.nodeType!==1){_26=_26.parentNode;}while(end&&end!==_23.editNode&&end!==_23.document.body&&end.nodeType!==1){end=end.parentNode;}var _29=_6.hitch(this,function(_2a,ary){if(_2a.childNodes&&_2a.childNodes.length){var i;for(i=0;i<_2a.childNodes.length;i++){var c=_2a.childNodes[i];if(c.nodeType==1){if(_23.selection.inSelection(c)){var tag=c.tagName?c.tagName.toLowerCase():"";if(_2.indexOf(this.values,tag)!==-1){ary.push(c);}_29(c,ary);}}}}});var _2b=_6.hitch(this,function(_2c){if(_2c&&_2c.length){_23.beginEditing();while(_2c.length){this._removeFormat(_23,_2c.pop());}_23.endEditing();}});var _2d=[];if(_26==end){var _2e;_28=_26;while(_28&&_28!==_23.editNode&&_28!==_23.document.body){if(_28.nodeType==1){tag=_28.tagName?_28.tagName.toLowerCase():"";if(_2.indexOf(this.values,tag)!==-1){_2e=_28;break;}}_28=_28.parentNode;}_29(_26,_2d);if(_2e){_2d=[_2e].concat(_2d);}_2b(_2d);}else{_28=_26;while(_23.selection.inSelection(_28)){if(_28.nodeType==1){tag=_28.tagName?_28.tagName.toLowerCase():"";if(_2.indexOf(this.values,tag)!==-1){_2d.push(_28);}_29(_28,_2d);}_28=_28.nextSibling;}_2b(_2d);}_23.onDisplayChanged();}}}else{_23.execCommand(_24,_25);}},_removeFormat:function(_2f,_30){if(_2f.customUndo){while(_30.firstChild){_4.place(_30.firstChild,_30,"before");}_30.parentNode.removeChild(_30);}else{_2f.selection.selectElementChildren(_30);var _31=_2f.selection.getSelectedHtml();_2f.selection.selectElement(_30);_2f.execCommand("inserthtml",_31||"");}}});var _32=_3("dijit._editor.plugins.FontChoice",_d,{useDefaultCommand:false,_initButton:function(){var _33={fontName:_15,fontSize:_1a,formatBlock:_20}[this.command],_34=this.params;if(this.params.custom){_34.values=this.params.custom;}var _35=this.editor;this.button=new _33(_6.delegate({dir:_35.dir,lang:_35.lang},_34));this.own(this.button.select.on("change",_6.hitch(this,function(_36){if(this.editor.focused){this.editor.focus();}if(this.command=="fontName"&&_36.indexOf(" ")!=-1){_36="'"+_36+"'";}if(this.button._execCommand){this.button._execCommand(this.editor,this.command,_36);}else{this.editor.execCommand(this.command,_36);}})));},updateState:function(){var _37=this.editor;var _38=this.command;if(!_37||!_37.isLoaded||!_38.length){return;}if(this.button){var _39=this.get("disabled");this.button.set("disabled",_39);if(_39){return;}var _3a;try{_3a=_37.queryCommandValue(_38)||"";}catch(e){_3a="";}var _3b=_6.isString(_3a)&&_3a.match(/'([^']*)'/);if(_3b){_3a=_3b[1];}if(_38==="formatBlock"){if(!_3a||_3a=="p"){_3a=null;var _3c;var sel=_e.getSelection(this.editor.window);if(sel&&sel.rangeCount>0){var _3d=sel.getRangeAt(0);if(_3d){_3c=_3d.endContainer;}}while(_3c&&_3c!==_37.editNode&&_3c!==_37.document){var tg=_3c.tagName?_3c.tagName.toLowerCase():"";if(tg&&_2.indexOf(this.button.values,tg)>-1){_3a=tg;break;}_3c=_3c.parentNode;}if(!_3a){_3a="noFormat";}}else{if(_2.indexOf(this.button.values,_3a)<0){_3a="noFormat";}}}if(_3a!==this.button.get("value")){this.button.set("value",_3a,false);}}}});_2.forEach(["fontName","fontSize","formatBlock"],function(_3e){_d.registry[_3e]=function(_3f){return new _32({command:_3e,plainText:_3f.plainText});};});_32._FontDropDown=_f;_32._FontNameDropDown=_15;_32._FontSizeDropDown=_1a;_32._FormatBlockDropDown=_20;return _32;});},"dijit/form/TextBox":function(){define(["dojo/_base/declare","dojo/dom-construct","dojo/dom-style","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/sniff","./_FormValueWidget","./_TextBoxMixin","dojo/text!./templates/TextBox.html","../main"],function(_40,_41,_42,_43,_44,on,has,_45,_46,_47,_48){var _49=_40("dijit.form.TextBox"+(has("dojo-bidi")?"_NoBidi":""),[_45,_46],{templateString:_47,_singleNodeTemplate:"<input class=\"dijit dijitReset dijitLeft dijitInputField\" data-dojo-attach-point=\"textbox,focusNode\" autocomplete=\"off\" type=\"${type}\" ${!nameAttrSetting} />",_buttonInputDisabled:has("ie")?"disabled":"",baseClass:"dijitTextBox",postMixInProperties:function(){var _4a=this.type.toLowerCase();if(this.templateString&&this.templateString.toLowerCase()=="input"||((_4a=="hidden"||_4a=="file")&&this.templateString==this.constructor.prototype.templateString)){this.templateString=this._singleNodeTemplate;}this.inherited(arguments);},postCreate:function(){this.inherited(arguments);if(has("ie")<9){this.defer(function(){try{var s=_42.getComputedStyle(this.domNode);if(s){var ff=s.fontFamily;if(ff){var _4b=this.domNode.getElementsByTagName("INPUT");if(_4b){for(var i=0;i<_4b.length;i++){_4b[i].style.fontFamily=ff;}}}}}catch(e){}});}},_setPlaceHolderAttr:function(v){this._set("placeHolder",v);if(!this._phspan){this._attachPoints.push("_phspan");this._phspan=_41.create("span",{onmousedown:function(e){e.preventDefault();},className:"dijitPlaceHolder dijitInputField"},this.textbox,"after");this.own(on(this._phspan,"touchend, MSPointerUp",_44.hitch(this,function(){this.focus();})));}this._phspan.innerHTML="";this._phspan.appendChild(this._phspan.ownerDocument.createTextNode(v));this._updatePlaceHolder();},_onInput:function(evt){this.inherited(arguments);this._updatePlaceHolder();},_updatePlaceHolder:function(){if(this._phspan){this._phspan.style.display=(this.placeHolder&&!this.textbox.value)?"":"none";}},_setValueAttr:function(_4c,_4d,_4e){this.inherited(arguments);this._updatePlaceHolder();},getDisplayedValue:function(){_43.deprecated(this.declaredClass+"::getDisplayedValue() is deprecated. Use get('displayedValue') instead.","","2.0");return this.get("displayedValue");},setDisplayedValue:function(_4f){_43.deprecated(this.declaredClass+"::setDisplayedValue() is deprecated. Use set('displayedValue', ...) instead.","","2.0");this.set("displayedValue",_4f);},_onBlur:function(e){if(this.disabled){return;}this.inherited(arguments);this._updatePlaceHolder();if(has("mozilla")){if(this.selectOnClick){this.textbox.selectionStart=this.textbox.selectionEnd=undefined;}}},_onFocus:function(by){if(this.disabled||this.readOnly){return;}this.inherited(arguments);this._updatePlaceHolder();}});if(has("ie")){_49.prototype._isTextSelected=function(){var _50=this.ownerDocument.selection.createRange();var _51=_50.parentElement();return _51==this.textbox&&_50.text.length>0;};_48._setSelectionRange=_46._setSelectionRange=function(_52,_53,_54){if(_52.createTextRange){var r=_52.createTextRange();r.collapse(true);r.moveStart("character",-99999);r.moveStart("character",_53);r.moveEnd("character",_54-_53);r.select();}};}if(has("dojo-bidi")){_49=_40("dijit.form.TextBox",_49,{_setPlaceHolderAttr:function(v){this.inherited(arguments);this.applyTextDir(this._phspan);}});}return _49;});},"dojo/currency":function(){define(["./_base/array","./_base/lang","./number","./i18n","./i18n!./cldr/nls/currency","./cldr/monetary"],function(_55,_56,_57,_58,_59,_5a){var _5b={};_56.setObject("dojo.currency",_5b);_5b._mixInDefaults=function(_5c){_5c=_5c||{};_5c.type="currency";var _5d=_58.getLocalization("dojo.cldr","currency",_5c.locale)||{};var iso=_5c.currency;var _5e=_5a.getData(iso);_55.forEach(["displayName","symbol","group","decimal"],function(_5f){_5e[_5f]=_5d[iso+"_"+_5f];});_5e.fractional=[true,false];return _56.mixin(_5e,_5c);};_5b.format=function(_60,_61){return _57.format(_60,_5b._mixInDefaults(_61));};_5b.regexp=function(_62){return _57.regexp(_5b._mixInDefaults(_62));};_5b.parse=function(_63,_64){return _57.parse(_63,_5b._mixInDefaults(_64));};return _5b;});},"dijit/layout/ScrollingTabController":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/fx","dojo/_base/lang","dojo/on","dojo/query","dojo/sniff","../registry","dojo/text!./templates/ScrollingTabController.html","dojo/text!./templates/_ScrollingTabControllerButton.html","./TabController","./utils","../_WidgetsInTemplateMixin","../Menu","../MenuItem","../form/Button","../_HasDropDown","dojo/NodeList-dom","../a11yclick"],function(_65,_66,_67,_68,_69,fx,_6a,on,_6b,has,_6c,_6d,_6e,_6f,_70,_71,_72,_73,_74,_75){var _76=_66("dijit.layout.ScrollingTabController",[_6f,_71],{baseClass:"dijitTabController dijitScrollingTabController",templateString:_6d,useMenu:true,useSlider:true,tabStripClass:"",_minScroll:5,_setClassAttr:{node:"containerNode",type:"class"},buildRendering:function(){this.inherited(arguments);var n=this.domNode;this.scrollNode=this.tablistWrapper;this._initButtons();if(!this.tabStripClass){this.tabStripClass="dijitTabContainer"+this.tabPosition.charAt(0).toUpperCase()+this.tabPosition.substr(1).replace(/-.*/,"")+"None";_67.add(n,"tabStrip-disabled");}_67.add(this.tablistWrapper,this.tabStripClass);},onStartup:function(){this.inherited(arguments);_69.set(this.domNode,"visibility","");this._postStartup=true;this.own(on(this.containerNode,"attrmodified-label, attrmodified-iconclass",_6a.hitch(this,function(evt){if(this._dim){this.resize(this._dim);}})));},onAddChild:function(_77,_78){this.inherited(arguments);_69.set(this.containerNode,"width",(_69.get(this.containerNode,"width")+200)+"px");},onRemoveChild:function(_79,_7a){var _7b=this.pane2button(_79.id);if(this._selectedTab===_7b.domNode){this._selectedTab=null;}this.inherited(arguments);},_initButtons:function(){this._btnWidth=0;this._buttons=_6b("> .tabStripButton",this.domNode).filter(function(btn){if((this.useMenu&&btn==this._menuBtn.domNode)||(this.useSlider&&(btn==this._rightBtn.domNode||btn==this._leftBtn.domNode))){this._btnWidth+=_68.getMarginSize(btn).w;return true;}else{_69.set(btn,"display","none");return false;}},this);},_getTabsWidth:function(){var _7c=this.getChildren();if(_7c.length){var _7d=_7c[this.isLeftToRight()?0:_7c.length-1].domNode,_7e=_7c[this.isLeftToRight()?_7c.length-1:0].domNode;return _7e.offsetLeft+_7e.offsetWidth-_7d.offsetLeft;}else{return 0;}},_enableBtn:function(_7f){var _80=this._getTabsWidth();_7f=_7f||_69.get(this.scrollNode,"width");return _80>0&&_7f<_80;},resize:function(dim){this._dim=dim;this.scrollNode.style.height="auto";var cb=this._contentBox=_70.marginBox2contentBox(this.domNode,{h:0,w:dim.w});cb.h=this.scrollNode.offsetHeight;_68.setContentSize(this.domNode,cb);var _81=this._enableBtn(this._contentBox.w);this._buttons.style("display",_81?"":"none");this._leftBtn.region="left";this._rightBtn.region="right";this._menuBtn.region=this.isLeftToRight()?"right":"left";_70.layoutChildren(this.domNode,this._contentBox,[this._menuBtn,this._leftBtn,this._rightBtn,{domNode:this.scrollNode,region:"center"}]);if(this._selectedTab){if(this._anim&&this._anim.status()=="playing"){this._anim.stop();}this.scrollNode.scrollLeft=this._convertToScrollLeft(this._getScrollForSelectedTab());}this._setButtonClass(this._getScroll());this._postResize=true;return {h:this._contentBox.h,w:dim.w};},_getScroll:function(){return (this.isLeftToRight()||has("ie")<8||(has("ie")&&has("quirks"))||has("webkit"))?this.scrollNode.scrollLeft:_69.get(this.containerNode,"width")-_69.get(this.scrollNode,"width")+(has("ie")>=8?-1:1)*this.scrollNode.scrollLeft;},_convertToScrollLeft:function(val){if(this.isLeftToRight()||has("ie")<8||(has("ie")&&has("quirks"))||has("webkit")){return val;}else{var _82=_69.get(this.containerNode,"width")-_69.get(this.scrollNode,"width");return (has("ie")>=8?-1:1)*(val-_82);}},onSelectChild:function(_83){var tab=this.pane2button(_83.id);if(!tab){return;}var _84=tab.domNode;if(_84!=this._selectedTab){this._selectedTab=_84;if(this._postResize){var sl=this._getScroll();if(sl>_84.offsetLeft||sl+_69.get(this.scrollNode,"width")<_84.offsetLeft+_69.get(_84,"width")){this.createSmoothScroll().play();}}}this.inherited(arguments);},_getScrollBounds:function(){var _85=this.getChildren(),_86=_69.get(this.scrollNode,"width"),_87=_69.get(this.containerNode,"width"),_88=_87-_86,_89=this._getTabsWidth();if(_85.length&&_89>_86){return {min:this.isLeftToRight()?0:_85[_85.length-1].domNode.offsetLeft,max:this.isLeftToRight()?(_85[_85.length-1].domNode.offsetLeft+_85[_85.length-1].domNode.offsetWidth)-_86:_88};}else{var _8a=this.isLeftToRight()?0:_88;return {min:_8a,max:_8a};}},_getScrollForSelectedTab:function(){var w=this.scrollNode,n=this._selectedTab,_8b=_69.get(this.scrollNode,"width"),_8c=this._getScrollBounds();var pos=(n.offsetLeft+_69.get(n,"width")/2)-_8b/2;pos=Math.min(Math.max(pos,_8c.min),_8c.max);return pos;},createSmoothScroll:function(x){if(arguments.length>0){var _8d=this._getScrollBounds();x=Math.min(Math.max(x,_8d.min),_8d.max);}else{x=this._getScrollForSelectedTab();}if(this._anim&&this._anim.status()=="playing"){this._anim.stop();}var _8e=this,w=this.scrollNode,_8f=new fx.Animation({beforeBegin:function(){if(this.curve){delete this.curve;}var _90=w.scrollLeft,_91=_8e._convertToScrollLeft(x);_8f.curve=new fx._Line(_90,_91);},onAnimate:function(val){w.scrollLeft=val;}});this._anim=_8f;this._setButtonClass(x);return _8f;},_getBtnNode:function(e){var n=e.target;while(n&&!_67.contains(n,"tabStripButton")){n=n.parentNode;}return n;},doSlideRight:function(e){this.doSlide(1,this._getBtnNode(e));},doSlideLeft:function(e){this.doSlide(-1,this._getBtnNode(e));},doSlide:function(_92,_93){if(_93&&_67.contains(_93,"dijitTabDisabled")){return;}var _94=_69.get(this.scrollNode,"width");var d=(_94*0.75)*_92;var to=this._getScroll()+d;this._setButtonClass(to);this.createSmoothScroll(to).play();},_setButtonClass:function(_95){var _96=this._getScrollBounds();this._leftBtn.set("disabled",_95<=_96.min);this._rightBtn.set("disabled",_95>=_96.max);}});var _97=_66("dijit.layout._ScrollingTabControllerButtonMixin",null,{baseClass:"dijitTab tabStripButton",templateString:_6e,tabIndex:"",isFocusable:function(){return false;}});_66("dijit.layout._ScrollingTabControllerButton",[_74,_97]);_66("dijit.layout._ScrollingTabControllerMenuButton",[_74,_75,_97],{containerId:"",tabIndex:"-1",isLoaded:function(){return false;},loadDropDown:function(_98){this.dropDown=new _72({id:this.containerId+"_menu",ownerDocument:this.ownerDocument,dir:this.dir,lang:this.lang,textDir:this.textDir});var _99=_6c.byId(this.containerId);_65.forEach(_99.getChildren(),function(_9a){var _9b=new _73({id:_9a.id+"_stcMi",label:_9a.title,iconClass:_9a.iconClass,disabled:_9a.disabled,ownerDocument:this.ownerDocument,dir:_9a.dir,lang:_9a.lang,textDir:_9a.textDir||_99.textDir,onClick:function(){_99.selectChild(_9a);}});this.dropDown.addChild(_9b);},this);_98();},closeDropDown:function(_9c){this.inherited(arguments);if(this.dropDown){this._popupStateNode.removeAttribute("aria-owns");this.dropDown.destroyRecursive();delete this.dropDown;}}});return _76;});},"dijit/DialogUnderlay":function(){define(["dojo/_base/declare","dojo/_base/lang","dojo/aspect","dojo/dom-attr","dojo/dom-style","dojo/on","dojo/window","./_Widget","./_TemplatedMixin","./BackgroundIframe","./Viewport","./main"],function(_9d,_9e,_9f,_a0,_a1,on,_a2,_a3,_a4,_a5,_a6,_a7){var _a8=_9d("dijit.DialogUnderlay",[_a3,_a4],{templateString:"<div class='dijitDialogUnderlayWrapper'><div class='dijitDialogUnderlay' tabIndex='-1' data-dojo-attach-point='node'></div></div>",dialogId:"","class":"",_modalConnects:[],_setDialogIdAttr:function(id){_a0.set(this.node,"id",id+"_underlay");this._set("dialogId",id);},_setClassAttr:function(_a9){this.node.className="dijitDialogUnderlay "+_a9;this._set("class",_a9);},postCreate:function(){this.ownerDocumentBody.appendChild(this.domNode);this.own(on(this.domNode,"keydown",_9e.hitch(this,"_onKeyDown")));this.inherited(arguments);},layout:function(){var is=this.node.style,os=this.domNode.style;os.display="none";var _aa=_a2.getBox(this.ownerDocument);os.top=_aa.t+"px";os.left=_aa.l+"px";is.width=_aa.w+"px";is.height=_aa.h+"px";os.display="block";},show:function(){this.domNode.style.display="block";this.open=true;this.layout();this.bgIframe=new _a5(this.domNode);var win=_a2.get(this.ownerDocument);this._modalConnects=[_a6.on("resize",_9e.hitch(this,"layout")),on(win,"scroll",_9e.hitch(this,"layout"))];},hide:function(){this.bgIframe.destroy();delete this.bgIframe;this.domNode.style.display="none";while(this._modalConnects.length){(this._modalConnects.pop()).remove();}this.open=false;},destroy:function(){while(this._modalConnects.length){(this._modalConnects.pop()).remove();}this.inherited(arguments);},_onKeyDown:function(){}});_a8.show=function(_ab,_ac){var _ad=_a8._singleton;if(!_ad||_ad._destroyed){_ad=_a7._underlay=_a8._singleton=new _a8(_ab);}else{if(_ab){_ad.set(_ab);}}_a1.set(_ad.domNode,"zIndex",_ac);if(!_ad.open){_ad.show();}};_a8.hide=function(){var _ae=_a8._singleton;if(_ae&&!_ae._destroyed){_ae.hide();}};return _a8;});},"dijit/_editor/html":function(){define(["dojo/_base/array","dojo/_base/lang","dojo/sniff"],function(_af,_b0,has){var _b1={};_b0.setObject("dijit._editor.html",_b1);var _b2=_b1.escapeXml=function(str,_b3){str=str.replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;");if(!_b3){str=str.replace(/'/gm,"&#39;");}return str;};_b1.getNodeHtml=function(_b4){var _b5=[];_b1.getNodeHtmlHelper(_b4,_b5);return _b5.join("");};_b1.getNodeHtmlHelper=function(_b6,_b7){switch(_b6.nodeType){case 1:var _b8=_b6.nodeName.toLowerCase();if(!_b8||_b8.charAt(0)=="/"){return "";}_b7.push("<",_b8);var _b9=[],_ba={};var _bb;if(has("dom-attributes-explicit")||has("dom-attributes-specified-flag")){var i=0;while((_bb=_b6.attributes[i++])){var n=_bb.name;if(n.substr(0,3)!=="_dj"&&(!has("dom-attributes-specified-flag")||_bb.specified)&&!(n in _ba)){var v=_bb.value;if(n=="src"||n=="href"){if(_b6.getAttribute("_djrealurl")){v=_b6.getAttribute("_djrealurl");}}if(has("ie")===8&&n==="style"){v=v.replace("HEIGHT:","height:").replace("WIDTH:","width:");}_b9.push([n,v]);_ba[n]=v;}}}else{var _bc=/^input$|^img$/i.test(_b6.nodeName)?_b6:_b6.cloneNode(false);var s=_bc.outerHTML;var _bd=/[\w-]+=("[^"]*"|'[^']*'|\S*)/gi;var _be=s.match(_bd);s=s.substr(0,s.indexOf(">"));_af.forEach(_be,function(_bf){if(_bf){var idx=_bf.indexOf("=");if(idx>0){var key=_bf.substring(0,idx);if(key.substr(0,3)!="_dj"){if(key=="src"||key=="href"){if(_b6.getAttribute("_djrealurl")){_b9.push([key,_b6.getAttribute("_djrealurl")]);return;}}var val,_c0;switch(key){case "style":val=_b6.style.cssText.toLowerCase();break;case "class":val=_b6.className;break;case "width":if(_b8==="img"){_c0=/width=(\S+)/i.exec(s);if(_c0){val=_c0[1];}break;}case "height":if(_b8==="img"){_c0=/height=(\S+)/i.exec(s);if(_c0){val=_c0[1];}break;}default:val=_b6.getAttribute(key);}if(val!=null){_b9.push([key,val.toString()]);}}}}},this);}_b9.sort(function(a,b){return a[0]<b[0]?-1:(a[0]==b[0]?0:1);});var j=0;while((_bb=_b9[j++])){_b7.push(" ",_bb[0],"=\"",(typeof _bb[1]==="string"?_b2(_bb[1],true):_bb[1]),"\"");}switch(_b8){case "br":case "hr":case "img":case "input":case "base":case "meta":case "area":case "basefont":_b7.push(" />");break;case "script":_b7.push(">",_b6.innerHTML,"</",_b8,">");break;default:_b7.push(">");if(_b6.hasChildNodes()){_b1.getChildrenHtmlHelper(_b6,_b7);}_b7.push("</",_b8,">");}break;case 4:case 3:_b7.push(_b2(_b6.nodeValue,true));break;case 8:_b7.push("<!--",_b2(_b6.nodeValue,true),"-->");break;default:_b7.push("<!-- Element not recognized - Type: ",_b6.nodeType," Name: ",_b6.nodeName,"-->");}};_b1.getChildrenHtml=function(_c1){var _c2=[];_b1.getChildrenHtmlHelper(_c1,_c2);return _c2.join("");};_b1.getChildrenHtmlHelper=function(dom,_c3){if(!dom){return;}var _c4=dom["childNodes"]||dom;var _c5=!has("ie")||_c4!==dom;var _c6,i=0;while((_c6=_c4[i++])){if(!_c5||_c6.parentNode==dom){_b1.getNodeHtmlHelper(_c6,_c3);}}};return _b1;});},"dijit/_HasDropDown":function(){define(["dojo/_base/declare","dojo/_base/Deferred","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/has","dojo/keys","dojo/_base/lang","dojo/on","dojo/touch","./registry","./focus","./popup","./_FocusMixin"],function(_c7,_c8,dom,_c9,_ca,_cb,_cc,has,_cd,_ce,on,_cf,_d0,_d1,_d2,_d3){return _c7("dijit._HasDropDown",_d3,{_buttonNode:null,_arrowWrapperNode:null,_popupStateNode:null,_aroundNode:null,dropDown:null,autoWidth:true,forceWidth:false,maxHeight:-1,dropDownPosition:["below","above"],_stopClickEvents:true,_onDropDownMouseDown:function(e){if(this.disabled||this.readOnly){return;}e.preventDefault();this._docHandler=this.own(on(this.ownerDocument,_cf.release,_ce.hitch(this,"_onDropDownMouseUp")))[0];this.toggleDropDown();},_onDropDownMouseUp:function(e){if(e&&this._docHandler){this._docHandler.remove();this._docHandler=null;}var _d4=this.dropDown,_d5=false;if(e&&this._opened){var c=_cb.position(this._buttonNode,true);if(!(e.pageX>=c.x&&e.pageX<=c.x+c.w)||!(e.pageY>=c.y&&e.pageY<=c.y+c.h)){var t=e.target;while(t&&!_d5){if(_ca.contains(t,"dijitPopup")){_d5=true;}else{t=t.parentNode;}}if(_d5){t=e.target;if(_d4.onItemClick){var _d6;while(t&&!(_d6=_d0.byNode(t))){t=t.parentNode;}if(_d6&&_d6.onClick&&_d6.getParent){_d6.getParent().onItemClick(_d6,e);}}return;}}}if(this._opened){if(_d4.focus&&_d4.autoFocus!==false){this._focusDropDownTimer=this.defer(function(){_d4.focus();delete this._focusDropDownTimer;});}}else{if(this.focus){this.defer("focus");}}},_onDropDownClick:function(e){if(this._stopClickEvents){e.stopPropagation();e.preventDefault();}},buildRendering:function(){this.inherited(arguments);this._buttonNode=this._buttonNode||this.focusNode||this.domNode;this._popupStateNode=this._popupStateNode||this.focusNode||this._buttonNode;var _d7={"after":this.isLeftToRight()?"Right":"Left","before":this.isLeftToRight()?"Left":"Right","above":"Up","below":"Down","left":"Left","right":"Right"}[this.dropDownPosition[0]]||this.dropDownPosition[0]||"Down";_ca.add(this._arrowWrapperNode||this._buttonNode,"dijit"+_d7+"ArrowButton");},postCreate:function(){this.inherited(arguments);var _d8=this.focusNode||this.domNode;this.own(on(this._buttonNode,_cf.press,_ce.hitch(this,"_onDropDownMouseDown")),on(this._buttonNode,"click",_ce.hitch(this,"_onDropDownClick")),on(_d8,"keydown",_ce.hitch(this,"_onKey")),on(_d8,"keyup",_ce.hitch(this,"_onKeyUp")));},destroy:function(){if(this.dropDown){if(!this.dropDown._destroyed){this.dropDown.destroyRecursive();}delete this.dropDown;}this.inherited(arguments);},_onKey:function(e){if(this.disabled||this.readOnly){return;}var d=this.dropDown,_d9=e.target;if(d&&this._opened&&d.handleKey){if(d.handleKey(e)===false){e.stopPropagation();e.preventDefault();return;}}if(d&&this._opened&&e.keyCode==_cd.ESCAPE){this.closeDropDown();e.stopPropagation();e.preventDefault();}else{if(!this._opened&&(e.keyCode==_cd.DOWN_ARROW||((e.keyCode==_cd.ENTER||(e.keyCode==_cd.SPACE&&(!this._searchTimer||(e.ctrlKey||e.altKey||e.metaKey))))&&((_d9.tagName||"").toLowerCase()!=="input"||(_d9.type&&_d9.type.toLowerCase()!=="text"))))){this._toggleOnKeyUp=true;e.stopPropagation();e.preventDefault();}}},_onKeyUp:function(){if(this._toggleOnKeyUp){delete this._toggleOnKeyUp;this.toggleDropDown();var d=this.dropDown;if(d&&d.focus){this.defer(_ce.hitch(d,"focus"),1);}}},_onBlur:function(){this.closeDropDown(false);this.inherited(arguments);},isLoaded:function(){return true;},loadDropDown:function(_da){_da();},loadAndOpenDropDown:function(){var d=new _c8(),_db=_ce.hitch(this,function(){this.openDropDown();d.resolve(this.dropDown);});if(!this.isLoaded()){this.loadDropDown(_db);}else{_db();}return d;},toggleDropDown:function(){if(this.disabled||this.readOnly){return;}if(!this._opened){this.loadAndOpenDropDown();}else{this.closeDropDown(true);}},openDropDown:function(){var _dc=this.dropDown,_dd=_dc.domNode,_de=this._aroundNode||this.domNode,_df=this;var _e0=_d2.open({parent:this,popup:_dc,around:_de,orient:this.dropDownPosition,maxHeight:this.maxHeight,onExecute:function(){_df.closeDropDown(true);},onCancel:function(){_df.closeDropDown(true);},onClose:function(){_c9.set(_df._popupStateNode,"popupActive",false);_ca.remove(_df._popupStateNode,"dijitHasDropDownOpen");_df._set("_opened",false);}});if(this.forceWidth||(this.autoWidth&&_de.offsetWidth>_dc._popupWrapper.offsetWidth)){var _e1={w:_de.offsetWidth-(_dc._popupWrapper.offsetWidth-_dc.domNode.offsetWidth)};if(_ce.isFunction(_dc.resize)){_dc.resize(_e1);}else{_cb.setMarginBox(_dd,_e1);}}_c9.set(this._popupStateNode,"popupActive","true");_ca.add(this._popupStateNode,"dijitHasDropDownOpen");this._set("_opened",true);this._popupStateNode.setAttribute("aria-expanded","true");this._popupStateNode.setAttribute("aria-owns",_dc.id);if(_dd.getAttribute("role")!=="presentation"&&!_dd.getAttribute("aria-labelledby")){_dd.setAttribute("aria-labelledby",this.id);}return _e0;},closeDropDown:function(_e2){if(this._focusDropDownTimer){this._focusDropDownTimer.remove();delete this._focusDropDownTimer;}if(this._opened){this._popupStateNode.setAttribute("aria-expanded","false");if(_e2){this.focus();}_d2.close(this.dropDown);this._opened=false;}}});});},"dijit/tree/TreeStoreModel":function(){define(["dojo/_base/array","dojo/aspect","dojo/_base/declare","dojo/_base/lang"],function(_e3,_e4,_e5,_e6){return _e5("dijit.tree.TreeStoreModel",null,{store:null,childrenAttrs:["children"],newItemIdAttr:"id",labelAttr:"",root:null,query:null,deferItemLoadingUntilExpand:false,constructor:function(_e7){_e6.mixin(this,_e7);this.connects=[];var _e8=this.store;if(!_e8.getFeatures()["dojo.data.api.Identity"]){throw new Error("dijit.tree.TreeStoreModel: store must support dojo.data.Identity");}if(_e8.getFeatures()["dojo.data.api.Notification"]){this.connects=this.connects.concat([_e4.after(_e8,"onNew",_e6.hitch(this,"onNewItem"),true),_e4.after(_e8,"onDelete",_e6.hitch(this,"onDeleteItem"),true),_e4.after(_e8,"onSet",_e6.hitch(this,"onSetItem"),true)]);}},destroy:function(){var h;while(h=this.connects.pop()){h.remove();}},getRoot:function(_e9,_ea){if(this.root){_e9(this.root);}else{this.store.fetch({query:this.query,onComplete:_e6.hitch(this,function(_eb){if(_eb.length!=1){throw new Error("dijit.tree.TreeStoreModel: root query returned "+_eb.length+" items, but must return exactly one");}this.root=_eb[0];_e9(this.root);}),onError:_ea});}},mayHaveChildren:function(_ec){return _e3.some(this.childrenAttrs,function(_ed){return this.store.hasAttribute(_ec,_ed);},this);},getChildren:function(_ee,_ef,_f0){var _f1=this.store;if(!_f1.isItemLoaded(_ee)){var _f2=_e6.hitch(this,arguments.callee);_f1.loadItem({item:_ee,onItem:function(_f3){_f2(_f3,_ef,_f0);},onError:_f0});return;}var _f4=[];for(var i=0;i<this.childrenAttrs.length;i++){var _f5=_f1.getValues(_ee,this.childrenAttrs[i]);_f4=_f4.concat(_f5);}var _f6=0;if(!this.deferItemLoadingUntilExpand){_e3.forEach(_f4,function(_f7){if(!_f1.isItemLoaded(_f7)){_f6++;}});}if(_f6==0){_ef(_f4);}else{_e3.forEach(_f4,function(_f8,idx){if(!_f1.isItemLoaded(_f8)){_f1.loadItem({item:_f8,onItem:function(_f9){_f4[idx]=_f9;if(--_f6==0){_ef(_f4);}},onError:_f0});}});}},isItem:function(_fa){return this.store.isItem(_fa);},fetchItemByIdentity:function(_fb){this.store.fetchItemByIdentity(_fb);},getIdentity:function(_fc){return this.store.getIdentity(_fc);},getLabel:function(_fd){if(this.labelAttr){return this.store.getValue(_fd,this.labelAttr);}else{return this.store.getLabel(_fd);}},newItem:function(_fe,_ff,_100){var _101={parent:_ff,attribute:this.childrenAttrs[0]},_102;if(this.newItemIdAttr&&_fe[this.newItemIdAttr]){this.fetchItemByIdentity({identity:_fe[this.newItemIdAttr],scope:this,onItem:function(item){if(item){this.pasteItem(item,null,_ff,true,_100);}else{_102=this.store.newItem(_fe,_101);if(_102&&(_100!=undefined)){this.pasteItem(_102,_ff,_ff,false,_100);}}}});}else{_102=this.store.newItem(_fe,_101);if(_102&&(_100!=undefined)){this.pasteItem(_102,_ff,_ff,false,_100);}}},pasteItem:function(_103,_104,_105,_106,_107){var _108=this.store,_109=this.childrenAttrs[0];if(_104){_e3.forEach(this.childrenAttrs,function(attr){if(_108.containsValue(_104,attr,_103)){if(!_106){var _10a=_e3.filter(_108.getValues(_104,attr),function(x){return x!=_103;});_108.setValues(_104,attr,_10a);}_109=attr;}});}if(_105){if(typeof _107=="number"){var _10b=_108.getValues(_105,_109).slice();_10b.splice(_107,0,_103);_108.setValues(_105,_109,_10b);}else{_108.setValues(_105,_109,_108.getValues(_105,_109).concat(_103));}}},onChange:function(){},onChildrenChange:function(){},onDelete:function(){},onNewItem:function(item,_10c){if(!_10c){return;}this.getChildren(_10c.item,_e6.hitch(this,function(_10d){this.onChildrenChange(_10c.item,_10d);}));},onDeleteItem:function(item){this.onDelete(item);},onSetItem:function(item,_10e){if(_e3.indexOf(this.childrenAttrs,_10e)!=-1){this.getChildren(item,_e6.hitch(this,function(_10f){this.onChildrenChange(item,_10f);}));}else{this.onChange(item);}}});});},"dijit/_editor/plugins/EnterKeyHandling":function(){define(["dojo/_base/declare","dojo/dom-construct","dojo/keys","dojo/_base/lang","dojo/on","dojo/sniff","dojo/_base/window","dojo/window","../_Plugin","../RichText","../range","../../_base/focus"],function(_110,_111,keys,lang,on,has,win,_112,_113,_114,_115,_116){return _110("dijit._editor.plugins.EnterKeyHandling",_113,{blockNodeForEnter:"BR",constructor:function(args){if(args){if("blockNodeForEnter" in args){args.blockNodeForEnter=args.blockNodeForEnter.toUpperCase();}lang.mixin(this,args);}},setEditor:function(_117){if(this.editor===_117){return;}this.editor=_117;if(this.blockNodeForEnter=="BR"){this.editor.customUndo=true;_117.onLoadDeferred.then(lang.hitch(this,function(d){this.own(on(_117.document,"keydown",lang.hitch(this,function(e){if(e.keyCode==keys.ENTER){var ne=lang.mixin({},e);ne.shiftKey=true;if(!this.handleEnterKey(ne)){e.stopPropagation();e.preventDefault();}}})));if(has("ie")>=9){this.own(on(_117.document,"paste",lang.hitch(this,function(e){setTimeout(lang.hitch(this,function(){var r=this.editor.document.selection.createRange();r.move("character",-1);r.select();r.move("character",1);r.select();}),0);})));}return d;}));}else{if(this.blockNodeForEnter){var h=lang.hitch(this,"handleEnterKey");_117.addKeyHandler(13,0,0,h);_117.addKeyHandler(13,0,1,h);this.own(this.editor.on("KeyPressed",lang.hitch(this,"onKeyPressed")));}}},onKeyPressed:function(){if(this._checkListLater){if(win.withGlobal(this.editor.window,"isCollapsed",_116)){var _118=this.editor.selection.getAncestorElement("LI");if(!_118){_114.prototype.execCommand.call(this.editor,"formatblock",this.blockNodeForEnter);var _119=this.editor.selection.getAncestorElement(this.blockNodeForEnter);if(_119){_119.innerHTML=this.bogusHtmlContent;if(has("ie")<=9){var r=this.editor.document.selection.createRange();r.move("character",-1);r.select();}}else{console.error("onKeyPressed: Cannot find the new block node");}}else{if(has("mozilla")){if(_118.parentNode.parentNode.nodeName=="LI"){_118=_118.parentNode.parentNode;}}var fc=_118.firstChild;if(fc&&fc.nodeType==1&&(fc.nodeName=="UL"||fc.nodeName=="OL")){_118.insertBefore(fc.ownerDocument.createTextNode(" "),fc);var _11a=_115.create(this.editor.window);_11a.setStart(_118.firstChild,0);var _11b=_115.getSelection(this.editor.window,true);_11b.removeAllRanges();_11b.addRange(_11a);}}}this._checkListLater=false;}if(this._pressedEnterInBlock){if(this._pressedEnterInBlock.previousSibling){this.removeTrailingBr(this._pressedEnterInBlock.previousSibling);}delete this._pressedEnterInBlock;}},bogusHtmlContent:"&#160;",blockNodes:/^(?:P|H1|H2|H3|H4|H5|H6|LI)$/,handleEnterKey:function(e){var _11c,_11d,_11e,_11f,_120,_121,doc=this.editor.document,br,rs,txt;if(e.shiftKey){var _122=this.editor.selection.getParentElement();var _123=_115.getAncestor(_122,this.blockNodes);if(_123){if(_123.tagName=="LI"){return true;}_11c=_115.getSelection(this.editor.window);_11d=_11c.getRangeAt(0);if(!_11d.collapsed){_11d.deleteContents();_11c=_115.getSelection(this.editor.window);_11d=_11c.getRangeAt(0);}if(_115.atBeginningOfContainer(_123,_11d.startContainer,_11d.startOffset)){br=doc.createElement("br");_11e=_115.create(this.editor.window);_123.insertBefore(br,_123.firstChild);_11e.setStartAfter(br);_11c.removeAllRanges();_11c.addRange(_11e);}else{if(_115.atEndOfContainer(_123,_11d.startContainer,_11d.startOffset)){_11e=_115.create(this.editor.window);br=doc.createElement("br");_123.appendChild(br);_123.appendChild(doc.createTextNode(" "));_11e.setStart(_123.lastChild,0);_11c.removeAllRanges();_11c.addRange(_11e);}else{rs=_11d.startContainer;if(rs&&rs.nodeType==3){txt=rs.nodeValue;_11f=doc.createTextNode(txt.substring(0,_11d.startOffset));_120=doc.createTextNode(txt.substring(_11d.startOffset));_121=doc.createElement("br");if(_120.nodeValue==""&&has("webkit")){_120=doc.createTextNode(" ");}_111.place(_11f,rs,"after");_111.place(_121,_11f,"after");_111.place(_120,_121,"after");_111.destroy(rs);_11e=_115.create(this.editor.window);_11e.setStart(_120,0);_11c.removeAllRanges();_11c.addRange(_11e);return false;}return true;}}}else{_11c=_115.getSelection(this.editor.window);if(_11c.rangeCount){_11d=_11c.getRangeAt(0);if(_11d&&_11d.startContainer){if(!_11d.collapsed){_11d.deleteContents();_11c=_115.getSelection(this.editor.window);_11d=_11c.getRangeAt(0);}rs=_11d.startContainer;if(rs&&rs.nodeType==3){var _124=false;var _125=_11d.startOffset;if(rs.length<_125){ret=this._adjustNodeAndOffset(rs,_125);rs=ret.node;_125=ret.offset;}txt=rs.nodeValue;_11f=doc.createTextNode(txt.substring(0,_125));_120=doc.createTextNode(txt.substring(_125));_121=doc.createElement("br");if(!_120.length){_120=doc.createTextNode(" ");_124=true;}if(_11f.length){_111.place(_11f,rs,"after");}else{_11f=rs;}_111.place(_121,_11f,"after");_111.place(_120,_121,"after");_111.destroy(rs);_11e=_115.create(this.editor.window);_11e.setStart(_120,0);_11e.setEnd(_120,_120.length);_11c.removeAllRanges();_11c.addRange(_11e);if(_124&&!has("webkit")){this.editor.selection.remove();}else{this.editor.selection.collapse(true);}}else{var _126;if(_11d.startOffset>=0){_126=rs.childNodes[_11d.startOffset];}var _121=doc.createElement("br");var _120=doc.createTextNode(" ");if(!_126){rs.appendChild(_121);rs.appendChild(_120);}else{_111.place(_121,_126,"before");_111.place(_120,_121,"after");}_11e=_115.create(this.editor.window);_11e.setStart(_120,0);_11e.setEnd(_120,_120.length);_11c.removeAllRanges();_11c.addRange(_11e);this.editor.selection.collapse(true);}}}else{_114.prototype.execCommand.call(this.editor,"inserthtml","<br>");}}return false;}var _127=true;_11c=_115.getSelection(this.editor.window);_11d=_11c.getRangeAt(0);if(!_11d.collapsed){_11d.deleteContents();_11c=_115.getSelection(this.editor.window);_11d=_11c.getRangeAt(0);}var _128=_115.getBlockAncestor(_11d.endContainer,null,this.editor.editNode);var _129=_128.blockNode;if((this._checkListLater=(_129&&(_129.nodeName=="LI"||_129.parentNode.nodeName=="LI")))){if(has("mozilla")){this._pressedEnterInBlock=_129;}if(/^(\s|&nbsp;|&#160;|\xA0|<span\b[^>]*\bclass=['"]Apple-style-span['"][^>]*>(\s|&nbsp;|&#160;|\xA0)<\/span>)?(<br>)?$/.test(_129.innerHTML)){_129.innerHTML="";if(has("webkit")){_11e=_115.create(this.editor.window);_11e.setStart(_129,0);_11c.removeAllRanges();_11c.addRange(_11e);}this._checkListLater=false;}return true;}if(!_128.blockNode||_128.blockNode===this.editor.editNode){try{_114.prototype.execCommand.call(this.editor,"formatblock",this.blockNodeForEnter);}catch(e2){}_128={blockNode:this.editor.selection.getAncestorElement(this.blockNodeForEnter),blockContainer:this.editor.editNode};if(_128.blockNode){if(_128.blockNode!=this.editor.editNode&&(!(_128.blockNode.textContent||_128.blockNode.innerHTML).replace(/^\s+|\s+$/g,"").length)){this.removeTrailingBr(_128.blockNode);return false;}}else{_128.blockNode=this.editor.editNode;}_11c=_115.getSelection(this.editor.window);_11d=_11c.getRangeAt(0);}var _12a=doc.createElement(this.blockNodeForEnter);_12a.innerHTML=this.bogusHtmlContent;this.removeTrailingBr(_128.blockNode);var _12b=_11d.endOffset;var node=_11d.endContainer;if(node.length<_12b){var ret=this._adjustNodeAndOffset(node,_12b);node=ret.node;_12b=ret.offset;}if(_115.atEndOfContainer(_128.blockNode,node,_12b)){if(_128.blockNode===_128.blockContainer){_128.blockNode.appendChild(_12a);}else{_111.place(_12a,_128.blockNode,"after");}_127=false;_11e=_115.create(this.editor.window);_11e.setStart(_12a,0);_11c.removeAllRanges();_11c.addRange(_11e);if(this.editor.height){_112.scrollIntoView(_12a);}}else{if(_115.atBeginningOfContainer(_128.blockNode,_11d.startContainer,_11d.startOffset)){_111.place(_12a,_128.blockNode,_128.blockNode===_128.blockContainer?"first":"before");if(_12a.nextSibling&&this.editor.height){_11e=_115.create(this.editor.window);_11e.setStart(_12a.nextSibling,0);_11c.removeAllRanges();_11c.addRange(_11e);_112.scrollIntoView(_12a.nextSibling);}_127=false;}else{if(_128.blockNode===_128.blockContainer){_128.blockNode.appendChild(_12a);}else{_111.place(_12a,_128.blockNode,"after");}_127=false;if(_128.blockNode.style){if(_12a.style){if(_128.blockNode.style.cssText){_12a.style.cssText=_128.blockNode.style.cssText;}}}rs=_11d.startContainer;var _12c;if(rs&&rs.nodeType==3){var _12d,_12e;_12b=_11d.endOffset;if(rs.length<_12b){ret=this._adjustNodeAndOffset(rs,_12b);rs=ret.node;_12b=ret.offset;}txt=rs.nodeValue;_11f=doc.createTextNode(txt.substring(0,_12b));_120=doc.createTextNode(txt.substring(_12b,txt.length));_111.place(_11f,rs,"before");_111.place(_120,rs,"after");_111.destroy(rs);var _12f=_11f.parentNode;while(_12f!==_128.blockNode){var tg=_12f.tagName;var _130=doc.createElement(tg);if(_12f.style){if(_130.style){if(_12f.style.cssText){_130.style.cssText=_12f.style.cssText;}}}if(_12f.tagName==="FONT"){if(_12f.color){_130.color=_12f.color;}if(_12f.face){_130.face=_12f.face;}if(_12f.size){_130.size=_12f.size;}}_12d=_120;while(_12d){_12e=_12d.nextSibling;_130.appendChild(_12d);_12d=_12e;}_111.place(_130,_12f,"after");_11f=_12f;_120=_130;_12f=_12f.parentNode;}_12d=_120;if(_12d.nodeType==1||(_12d.nodeType==3&&_12d.nodeValue)){_12a.innerHTML="";}_12c=_12d;while(_12d){_12e=_12d.nextSibling;_12a.appendChild(_12d);_12d=_12e;}}_11e=_115.create(this.editor.window);var _131;var _132=_12c;if(this.blockNodeForEnter!=="BR"){while(_132){_131=_132;_12e=_132.firstChild;_132=_12e;}if(_131&&_131.parentNode){_12a=_131.parentNode;_11e.setStart(_12a,0);_11c.removeAllRanges();_11c.addRange(_11e);if(this.editor.height){_112.scrollIntoView(_12a);}if(has("mozilla")){this._pressedEnterInBlock=_128.blockNode;}}else{_127=true;}}else{_11e.setStart(_12a,0);_11c.removeAllRanges();_11c.addRange(_11e);if(this.editor.height){_112.scrollIntoView(_12a);}if(has("mozilla")){this._pressedEnterInBlock=_128.blockNode;}}}}return _127;},_adjustNodeAndOffset:function(node,_133){while(node.length<_133&&node.nextSibling&&node.nextSibling.nodeType==3){_133=_133-node.length;node=node.nextSibling;}return {"node":node,"offset":_133};},removeTrailingBr:function(_134){var para=/P|DIV|LI/i.test(_134.tagName)?_134:this.editor.selection.getParentOfType(_134,["P","DIV","LI"]);if(!para){return;}if(para.lastChild){if((para.childNodes.length>1&&para.lastChild.nodeType==3&&/^[\s\xAD]*$/.test(para.lastChild.nodeValue))||para.lastChild.tagName=="BR"){_111.destroy(para.lastChild);}}if(!para.childNodes.length){para.innerHTML=this.bogusHtmlContent;}}});});},"dijit/_MenuBase":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/_base/lang","dojo/mouse","dojo/on","dojo/window","./a11yclick","./registry","./_Widget","./_CssStateMixin","./_KeyNavContainer","./_TemplatedMixin"],function(_135,_136,dom,_137,_138,lang,_139,on,_13a,_13b,_13c,_13d,_13e,_13f,_140){return _136("dijit._MenuBase",[_13d,_140,_13f,_13e],{selected:null,_setSelectedAttr:function(item){if(this.selected!=item){if(this.selected){this.selected._setSelected(false);this._onChildDeselect(this.selected);}if(item){item._setSelected(true);}this._set("selected",item);}},activated:false,_setActivatedAttr:function(val){_138.toggle(this.domNode,"dijitMenuActive",val);_138.toggle(this.domNode,"dijitMenuPassive",!val);this._set("activated",val);},parentMenu:null,popupDelay:500,passivePopupDelay:Infinity,autoFocus:false,childSelector:function(node){var _141=_13c.byNode(node);return node.parentNode==this.containerNode&&_141&&_141.focus;},postCreate:function(){var self=this,_142=typeof this.childSelector=="string"?this.childSelector:lang.hitch(this,"childSelector");this.own(on(this.containerNode,on.selector(_142,_139.enter),function(){self.onItemHover(_13c.byNode(this));}),on(this.containerNode,on.selector(_142,_139.leave),function(){self.onItemUnhover(_13c.byNode(this));}),on(this.containerNode,on.selector(_142,_13b),function(evt){self.onItemClick(_13c.byNode(this),evt);evt.stopPropagation();evt.preventDefault();}));this.inherited(arguments);},onKeyboardSearch:function(item,evt,_143,_144){this.inherited(arguments);if(!!item&&(_144==-1||(!!item.popup&&_144==1))){this.onItemClick(item,evt);}},_keyboardSearchCompare:function(item,_145){if(!!item.shortcutKey){return _145==item.shortcutKey.toLowerCase()?-1:0;}return this.inherited(arguments)?1:0;},onExecute:function(){},onCancel:function(){},_moveToPopup:function(evt){if(this.focusedChild&&this.focusedChild.popup&&!this.focusedChild.disabled){this.onItemClick(this.focusedChild,evt);}else{var _146=this._getTopMenu();if(_146&&_146._isMenuBar){_146.focusNext();}}},_onPopupHover:function(){this.set("selected",this.currentPopupItem);this._stopPendingCloseTimer();},onItemHover:function(item){if(this.activated){this.set("selected",item);if(item.popup&&!item.disabled&&!this.hover_timer){this.hover_timer=this.defer(function(){this._openItemPopup(item);},this.popupDelay);}}else{if(this.passivePopupDelay<Infinity){if(this.passive_hover_timer){this.passive_hover_timer.remove();}this.passive_hover_timer=this.defer(function(){this.onItemClick(item,{type:"click"});},this.passivePopupDelay);}}this._hoveredChild=item;item._set("hovering",true);},_onChildDeselect:function(item){this._stopPopupTimer();if(this.currentPopupItem==item){this._stopPendingCloseTimer();this._pendingClose_timer=this.defer(function(){this._pendingClose_timer=null;this.currentPopupItem=null;item._closePopup();},this.popupDelay);}},onItemUnhover:function(item){if(this._hoveredChild==item){this._hoveredChild=null;}if(this.passive_hover_timer){this.passive_hover_timer.remove();this.passive_hover_timer=null;}item._set("hovering",false);},_stopPopupTimer:function(){if(this.hover_timer){this.hover_timer=this.hover_timer.remove();}},_stopPendingCloseTimer:function(){if(this._pendingClose_timer){this._pendingClose_timer=this._pendingClose_timer.remove();}},_getTopMenu:function(){for(var top=this;top.parentMenu;top=top.parentMenu){}return top;},onItemClick:function(item,evt){if(this.passive_hover_timer){this.passive_hover_timer.remove();}this.focusChild(item);if(item.disabled){return false;}if(item.popup){this.set("selected",item);this.set("activated",true);var _147=/^key/.test(evt._origType||evt.type)||(evt.clientX==0&&evt.clientY==0);this._openItemPopup(item,_147);}else{this.onExecute();item._onClick?item._onClick(evt):item.onClick(evt);}},_openItemPopup:function(_148,_149){if(_148==this.currentPopupItem){return;}if(this.currentPopupItem){this._stopPendingCloseTimer();this.currentPopupItem._closePopup();}this._stopPopupTimer();var _14a=_148.popup;_14a.parentMenu=this;this.own(this._mouseoverHandle=on.once(_14a.domNode,"mouseover",lang.hitch(this,"_onPopupHover")));var self=this;_148._openPopup({parent:this,orient:this._orient||["after","before"],onCancel:function(){if(_149){self.focusChild(_148);}self._cleanUp();},onExecute:lang.hitch(this,"_cleanUp",true),onClose:function(){if(self._mouseoverHandle){self._mouseoverHandle.remove();delete self._mouseoverHandle;}}},_149);this.currentPopupItem=_148;},onOpen:function(){this.isShowingNow=true;this.set("activated",true);},onClose:function(){this.set("activated",false);this.set("selected",null);this.isShowingNow=false;this.parentMenu=null;},_closeChild:function(){this._stopPopupTimer();if(this.currentPopupItem){if(this.focused){_137.set(this.selected.focusNode,"tabIndex",this.tabIndex);this.selected.focusNode.focus();}this.currentPopupItem._closePopup();this.currentPopupItem=null;}},_onItemFocus:function(item){if(this._hoveredChild&&this._hoveredChild!=item){this.onItemUnhover(this._hoveredChild);}this.set("selected",item);},_onBlur:function(){this._cleanUp(true);this.inherited(arguments);},_cleanUp:function(_14b){this._closeChild();if(typeof this.isShowingNow=="undefined"){this.set("activated",false);}if(_14b){this.set("selected",null);}}});});},"dijit/tree/ForestStoreModel":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/_base/kernel","dojo/_base/lang","./TreeStoreModel"],function(_14c,_14d,_14e,lang,_14f){return _14d("dijit.tree.ForestStoreModel",_14f,{rootId:"$root$",rootLabel:"ROOT",query:null,constructor:function(_150){this.root={store:this,root:true,id:_150.rootId,label:_150.rootLabel,children:_150.rootChildren};},mayHaveChildren:function(item){return item===this.root||this.inherited(arguments);},getChildren:function(_151,_152,_153){if(_151===this.root){if(this.root.children){_152(this.root.children);}else{this.store.fetch({query:this.query,onComplete:lang.hitch(this,function(_154){this.root.children=_154;_152(_154);}),onError:_153});}}else{this.inherited(arguments);}},isItem:function(_155){return (_155===this.root)?true:this.inherited(arguments);},fetchItemByIdentity:function(_156){if(_156.identity==this.root.id){var _157=_156.scope||_14e.global;if(_156.onItem){_156.onItem.call(_157,this.root);}}else{this.inherited(arguments);}},getIdentity:function(item){return (item===this.root)?this.root.id:this.inherited(arguments);},getLabel:function(item){return (item===this.root)?this.root.label:this.inherited(arguments);},newItem:function(args,_158,_159){if(_158===this.root){this.onNewRootItem(args);return this.store.newItem(args);}else{return this.inherited(arguments);}},onNewRootItem:function(){},pasteItem:function(_15a,_15b,_15c,_15d,_15e){if(_15b===this.root){if(!_15d){this.onLeaveRoot(_15a);}}this.inherited(arguments,[_15a,_15b===this.root?null:_15b,_15c===this.root?null:_15c,_15d,_15e]);if(_15c===this.root){this.onAddToRoot(_15a);}},onAddToRoot:function(item){},onLeaveRoot:function(item){},_requeryTop:function(){var _15f=this.root.children||[];this.store.fetch({query:this.query,onComplete:lang.hitch(this,function(_160){this.root.children=_160;if(_15f.length!=_160.length||_14c.some(_15f,function(item,idx){return _160[idx]!=item;})){this.onChildrenChange(this.root,_160);}})});},onNewItem:function(item,_161){this._requeryTop();this.inherited(arguments);},onDeleteItem:function(item){if(_14c.indexOf(this.root.children,item)!=-1){this._requeryTop();}this.inherited(arguments);},onSetItem:function(item,_162,_163,_164){this._requeryTop();this.inherited(arguments);}});});},"dijit/PopupMenuBarItem":function(){define(["dojo/_base/declare","./PopupMenuItem","./MenuBarItem"],function(_165,_166,_167){var _168=_167._MenuBarItemMixin;return _165("dijit.PopupMenuBarItem",[_166,_168],{});});},"dijit/TitlePane":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-geometry","dojo/fx","dojo/has","dojo/_base/kernel","dojo/keys","./_CssStateMixin","./_TemplatedMixin","./layout/ContentPane","dojo/text!./templates/TitlePane.html","./_base/manager","./a11yclick"],function(_169,_16a,dom,_16b,_16c,_16d,_16e,has,_16f,keys,_170,_171,_172,_173,_174){var _175=_16a("dijit.TitlePane",[_172,_171,_170],{title:"",_setTitleAttr:{node:"titleNode",type:"innerHTML"},open:true,toggleable:true,tabIndex:"0",duration:_174.defaultDuration,baseClass:"dijitTitlePane",templateString:_173,doLayout:false,_setTooltipAttr:{node:"focusNode",type:"attribute",attribute:"title"},buildRendering:function(){this.inherited(arguments);dom.setSelectable(this.titleNode,false);},postCreate:function(){this.inherited(arguments);if(this.toggleable){this._trackMouseState(this.titleBarNode,this.baseClass+"Title");}var _176=this.hideNode,_177=this.wipeNode;this._wipeIn=_16e.wipeIn({node:_177,duration:this.duration,beforeBegin:function(){_176.style.display="";}});this._wipeOut=_16e.wipeOut({node:_177,duration:this.duration,onEnd:function(){_176.style.display="none";}});},_setOpenAttr:function(open,_178){_169.forEach([this._wipeIn,this._wipeOut],function(_179){if(_179&&_179.status()=="playing"){_179.stop();}});if(_178){var anim=this[open?"_wipeIn":"_wipeOut"];anim.play();}else{this.hideNode.style.display=this.wipeNode.style.display=open?"":"none";}if(this._started){if(open){this._onShow();}else{this.onHide();}}this.containerNode.setAttribute("aria-hidden",open?"false":"true");this.focusNode.setAttribute("aria-pressed",open?"true":"false");this._set("open",open);this._setCss();},_setToggleableAttr:function(_17a){this.focusNode.setAttribute("role",_17a?"button":"heading");if(_17a){this.focusNode.setAttribute("aria-controls",this.id+"_pane");this.focusNode.setAttribute("tabIndex",this.tabIndex);this.focusNode.setAttribute("aria-pressed",this.open);}else{_16b.remove(this.focusNode,"aria-controls");_16b.remove(this.focusNode,"tabIndex");_16b.remove(this.focusNode,"aria-pressed");}this._set("toggleable",_17a);this._setCss();},_setContentAttr:function(_17b){if(!this.open||!this._wipeOut||this._wipeOut.status()=="playing"){this.inherited(arguments);}else{if(this._wipeIn&&this._wipeIn.status()=="playing"){this._wipeIn.stop();}_16d.setMarginBox(this.wipeNode,{h:_16d.getMarginBox(this.wipeNode).h});this.inherited(arguments);if(this._wipeIn){this._wipeIn.play();}else{this.hideNode.style.display="";}}},toggle:function(){this._setOpenAttr(!this.open,true);},_setCss:function(){var node=this.titleBarNode||this.focusNode;var _17c=this._titleBarClass;this._titleBarClass=this.baseClass+"Title"+(this.toggleable?"":"Fixed")+(this.open?"Open":"Closed");_16c.replace(node,this._titleBarClass,_17c||"");_16c.replace(node,this._titleBarClass.replace("TitlePaneTitle",""),(_17c||"").replace("TitlePaneTitle",""));this.arrowNodeInner.innerHTML=this.open?"-":"+";},_onTitleKey:function(e){if(e.keyCode==keys.DOWN_ARROW&&this.open){this.containerNode.focus();e.preventDefault();}},_onTitleClick:function(){if(this.toggleable){this.toggle();}},setTitle:function(_17d){_16f.deprecated("dijit.TitlePane.setTitle() is deprecated.  Use set('title', ...) instead.","","2.0");this.set("title",_17d);}});if(has("dojo-bidi")){_175.extend({_setTitleAttr:function(_17e){this._set("title",_17e);this.titleNode.innerHTML=_17e;this.applyTextDir(this.titleNode);},_setTooltipAttr:function(_17f){this._set("tooltip",_17f);if(this.textDir){_17f=this.enforceTextDirWithUcc(null,_17f);}_16b.set(this.focusNode,"title",_17f);},_setTextDirAttr:function(_180){if(this._created&&this.textDir!=_180){this._set("textDir",_180);this.set("title",this.title);this.set("tooltip",this.tooltip);}}});}return _175;});},"dijit/form/_ComboBoxMenuMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/has","dojo/i18n","dojo/i18n!./nls/ComboBox"],function(_181,_182,_183,has,i18n){var _184=_182("dijit.form._ComboBoxMenuMixin"+(has("dojo-bidi")?"_NoBidi":""),null,{_messages:null,postMixInProperties:function(){this.inherited(arguments);this._messages=i18n.getLocalization("dijit.form","ComboBox",this.lang);},buildRendering:function(){this.inherited(arguments);this.previousButton.innerHTML=this._messages["previousMessage"];this.nextButton.innerHTML=this._messages["nextMessage"];},_setValueAttr:function(_185){this._set("value",_185);this.onChange(_185);},onClick:function(node){if(node==this.previousButton){this._setSelectedAttr(null);this.onPage(-1);}else{if(node==this.nextButton){this._setSelectedAttr(null);this.onPage(1);}else{this.onChange(node);}}},onChange:function(){},onPage:function(){},onClose:function(){this._setSelectedAttr(null);},_createOption:function(item,_186){var _187=this._createMenuItem();var _188=_186(item);if(_188.html){_187.innerHTML=_188.label;}else{_187.appendChild(_187.ownerDocument.createTextNode(_188.label));}if(_187.innerHTML==""){_187.innerHTML="&#160;";}return _187;},createOptions:function(_189,_18a,_18b){this.items=_189;this.previousButton.style.display=(_18a.start==0)?"none":"";_183.set(this.previousButton,"id",this.id+"_prev");_181.forEach(_189,function(item,i){var _18c=this._createOption(item,_18b);_18c.setAttribute("item",i);_183.set(_18c,"id",this.id+i);this.nextButton.parentNode.insertBefore(_18c,this.nextButton);},this);var _18d=false;if(_189.total&&!_189.total.then&&_189.total!=-1){if((_18a.start+_18a.count)<_189.total){_18d=true;}else{if((_18a.start+_18a.count)>_189.total&&_18a.count==_189.length){_18d=true;}}}else{if(_18a.count==_189.length){_18d=true;}}this.nextButton.style.display=_18d?"":"none";_183.set(this.nextButton,"id",this.id+"_next");},clearResultList:function(){var _18e=this.containerNode;while(_18e.childNodes.length>2){_18e.removeChild(_18e.childNodes[_18e.childNodes.length-2]);}this._setSelectedAttr(null);},highlightFirstOption:function(){this.selectFirstNode();},highlightLastOption:function(){this.selectLastNode();},selectFirstNode:function(){this.inherited(arguments);if(this.getHighlightedOption()==this.previousButton){this.selectNextNode();}},selectLastNode:function(){this.inherited(arguments);if(this.getHighlightedOption()==this.nextButton){this.selectPreviousNode();}},getHighlightedOption:function(){return this.selected;}});if(has("dojo-bidi")){_184=_182("dijit.form._ComboBoxMenuMixin",_184,{_createOption:function(){var _18f=this.inherited(arguments);this.applyTextDir(_18f);return _18f;}});}return _184;});},"dijit/form/_SearchMixin":function(){define(["dojo/_base/declare","dojo/keys","dojo/_base/lang","dojo/query","dojo/string","dojo/when","../registry"],function(_190,keys,lang,_191,_192,when,_193){return _190("dijit.form._SearchMixin",null,{pageSize:Infinity,store:null,fetchProperties:{},query:{},searchDelay:200,searchAttr:"name",queryExpr:"${0}*",ignoreCase:true,_patternToRegExp:function(_194){return new RegExp("^"+_194.replace(/(\\.)|(\*)|(\?)|\W/g,function(str,_195,star,_196){return star?".*":_196?".":_195?_195:"\\"+str;})+"$",this.ignoreCase?"mi":"m");},_abortQuery:function(){if(this.searchTimer){this.searchTimer=this.searchTimer.remove();}if(this._queryDeferHandle){this._queryDeferHandle=this._queryDeferHandle.remove();}if(this._fetchHandle){if(this._fetchHandle.abort){this._cancelingQuery=true;this._fetchHandle.abort();this._cancelingQuery=false;}if(this._fetchHandle.cancel){this._cancelingQuery=true;this._fetchHandle.cancel();this._cancelingQuery=false;}this._fetchHandle=null;}},_processInput:function(evt){if(this.disabled||this.readOnly){return;}var key=evt.charOrCode;if("type" in evt&&evt.type.substring(0,3)=="key"&&(evt.altKey||((evt.ctrlKey||evt.metaKey)&&(key!="x"&&key!="v"))||key==keys.SHIFT)){return;}var _197=false;this._prev_key_backspace=false;switch(key){case keys.DELETE:case keys.BACKSPACE:this._prev_key_backspace=true;this._maskValidSubsetError=true;_197=true;break;default:_197=typeof key=="string"||key==229;}if(_197){if(!this.store){this.onSearch();}else{this.searchTimer=this.defer("_startSearchFromInput",1);}}},onSearch:function(){},_startSearchFromInput:function(){this._startSearch(this.focusNode.value);},_startSearch:function(text){this._abortQuery();var _198=this,_191=lang.clone(this.query),_199={start:0,count:this.pageSize,queryOptions:{ignoreCase:this.ignoreCase,deep:true}},qs=_192.substitute(this.queryExpr,[text.replace(/([\\\*\?])/g,"\\$1")]),q,_19a=function(){var _19b=_198._fetchHandle=_198.store.query(_191,_199);if(_198.disabled||_198.readOnly||(q!==_198._lastQuery)){return;}when(_19b,function(res){_198._fetchHandle=null;if(!_198.disabled&&!_198.readOnly&&(q===_198._lastQuery)){when(_19b.total,function(_19c){res.total=_19c;var _19d=_198.pageSize;if(isNaN(_19d)||_19d>res.total){_19d=res.total;}res.nextPage=function(_19e){_199.direction=_19e=_19e!==false;_199.count=_19d;if(_19e){_199.start+=res.length;if(_199.start>=res.total){_199.count=0;}}else{_199.start-=_19d;if(_199.start<0){_199.count=Math.max(_19d+_199.start,0);_199.start=0;}}if(_199.count<=0){res.length=0;_198.onSearch(res,_191,_199);}else{_19a();}};_198.onSearch(res,_191,_199);});}},function(err){_198._fetchHandle=null;if(!_198._cancelingQuery){console.error(_198.declaredClass+" "+err.toString());}});};lang.mixin(_199,this.fetchProperties);if(this.store._oldAPI){q=qs;}else{q=this._patternToRegExp(qs);q.toString=function(){return qs;};}this._lastQuery=_191[this.searchAttr]=q;this._queryDeferHandle=this.defer(_19a,this.searchDelay);},constructor:function(){this.query={};this.fetchProperties={};},postMixInProperties:function(){if(!this.store){var list=this.list;if(list){this.store=_193.byId(list);}}this.inherited(arguments);}});});},"dijit/form/ToggleButton":function(){define(["dojo/_base/declare","dojo/_base/kernel","./Button","./_ToggleButtonMixin"],function(_19f,_1a0,_1a1,_1a2){return _19f("dijit.form.ToggleButton",[_1a1,_1a2],{baseClass:"dijitToggleButton",setChecked:function(_1a3){_1a0.deprecated("setChecked("+_1a3+") is deprecated. Use set('checked',"+_1a3+") instead.","","2.0");this.set("checked",_1a3);}});});},"dijit/form/NumberSpinner":function(){define(["dojo/_base/declare","dojo/keys","./_Spinner","./NumberTextBox"],function(_1a4,keys,_1a5,_1a6){return _1a4("dijit.form.NumberSpinner",[_1a5,_1a6.Mixin],{baseClass:"dijitTextBox dijitSpinner dijitNumberTextBox",adjust:function(val,_1a7){var tc=this.constraints,v=isNaN(val),_1a8=!isNaN(tc.max),_1a9=!isNaN(tc.min);if(v&&_1a7!=0){val=(_1a7>0)?_1a9?tc.min:_1a8?tc.max:0:_1a8?this.constraints.max:_1a9?tc.min:0;}var _1aa=val+_1a7;if(v||isNaN(_1aa)){return val;}if(_1a8&&(_1aa>tc.max)){_1aa=tc.max;}if(_1a9&&(_1aa<tc.min)){_1aa=tc.min;}return _1aa;},_onKeyDown:function(e){if(this.disabled||this.readOnly){return;}if((e.keyCode==keys.HOME||e.keyCode==keys.END)&&!(e.ctrlKey||e.altKey||e.metaKey)&&typeof this.get("value")!="undefined"){var _1ab=this.constraints[(e.keyCode==keys.HOME?"min":"max")];if(typeof _1ab=="number"){this._setValueAttr(_1ab,false);}e.stopPropagation();e.preventDefault();}}});});},"dijit/form/Textarea":function(){define(["dojo/_base/declare","dojo/dom-style","./_ExpandingTextAreaMixin","./SimpleTextarea"],function(_1ac,_1ad,_1ae,_1af){return _1ac("dijit.form.Textarea",[_1af,_1ae],{baseClass:"dijitTextBox dijitTextArea dijitExpandingTextArea",cols:"",buildRendering:function(){this.inherited(arguments);_1ad.set(this.textbox,{overflowY:"hidden",overflowX:"auto",boxSizing:"border-box",MsBoxSizing:"border-box",WebkitBoxSizing:"border-box",MozBoxSizing:"border-box"});}});});},"dijit/form/DateTextBox":function(){define(["dojo/_base/declare","../Calendar","./_DateTimeTextBox"],function(_1b0,_1b1,_1b2){return _1b0("dijit.form.DateTextBox",_1b2,{baseClass:"dijitTextBox dijitComboBox dijitDateTextBox",popupClass:_1b1,_selector:"date",maxHeight:Infinity,value:new Date("")});});},"dijit/layout/AccordionContainer":function(){define(["require","dojo/_base/array","dojo/_base/declare","dojo/_base/fx","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/keys","dojo/_base/lang","dojo/sniff","dojo/topic","../focus","../_base/manager","dojo/ready","../_Widget","../_Container","../_TemplatedMixin","../_CssStateMixin","./StackContainer","./ContentPane","dojo/text!./templates/AccordionButton.html","../a11yclick"],function(_1b3,_1b4,_1b5,fx,dom,_1b6,_1b7,_1b8,_1b9,keys,lang,has,_1ba,_1bb,_1bc,_1bd,_1be,_1bf,_1c0,_1c1,_1c2,_1c3,_1c4){var _1c5=_1b5("dijit.layout._AccordionButton",[_1be,_1c0,_1c1],{templateString:_1c4,label:"",_setLabelAttr:{node:"titleTextNode",type:"innerHTML"},title:"",_setTitleAttr:{node:"titleTextNode",type:"attribute",attribute:"title"},iconClassAttr:"",_setIconClassAttr:{node:"iconNode",type:"class"},baseClass:"dijitAccordionTitle",getParent:function(){return this.parent;},buildRendering:function(){this.inherited(arguments);var _1c6=this.id.replace(" ","_");_1b6.set(this.titleTextNode,"id",_1c6+"_title");this.focusNode.setAttribute("aria-labelledby",_1b6.get(this.titleTextNode,"id"));dom.setSelectable(this.domNode,false);},getTitleHeight:function(){return _1b9.getMarginSize(this.domNode).h;},_onTitleClick:function(){var _1c7=this.getParent();_1c7.selectChild(this.contentWidget,true);_1bb.focus(this.focusNode);},_onTitleKeyDown:function(evt){return this.getParent()._onKeyDown(evt,this.contentWidget);},_setSelectedAttr:function(_1c8){this._set("selected",_1c8);this.focusNode.setAttribute("aria-expanded",_1c8?"true":"false");this.focusNode.setAttribute("aria-selected",_1c8?"true":"false");this.focusNode.setAttribute("tabIndex",_1c8?"0":"-1");}});if(has("dojo-bidi")){_1c5.extend({_setLabelAttr:function(_1c9){this._set("label",_1c9);_1b6.set(this.titleTextNode,"innerHTML",_1c9);this.applyTextDir(this.titleTextNode);},_setTitleAttr:function(_1ca){this._set("title",_1ca);_1b6.set(this.titleTextNode,"title",_1ca);this.applyTextDir(this.titleTextNode);}});}var _1cb=_1b5("dijit.layout._AccordionInnerContainer"+(has("dojo-bidi")?"_NoBidi":""),[_1be,_1c1],{baseClass:"dijitAccordionInnerContainer",isLayoutContainer:true,buildRendering:function(){this.domNode=_1b8.place("<div class='"+this.baseClass+"' role='presentation'>",this.contentWidget.domNode,"after");var _1cc=this.contentWidget,cls=lang.isString(this.buttonWidget)?lang.getObject(this.buttonWidget):this.buttonWidget;this.button=_1cc._buttonWidget=(new cls({contentWidget:_1cc,label:_1cc.title,title:_1cc.tooltip,dir:_1cc.dir,lang:_1cc.lang,textDir:_1cc.textDir||this.textDir,iconClass:_1cc.iconClass,id:_1cc.id+"_button",parent:this.parent})).placeAt(this.domNode);this.containerNode=_1b8.place("<div class='dijitAccordionChildWrapper' role='tabpanel' style='display:none'>",this.domNode);this.containerNode.setAttribute("aria-labelledby",this.button.id);_1b8.place(this.contentWidget.domNode,this.containerNode);},postCreate:function(){this.inherited(arguments);var _1cd=this.button,cw=this.contentWidget;this._contentWidgetWatches=[cw.watch("title",lang.hitch(this,function(name,_1ce,_1cf){_1cd.set("label",_1cf);})),cw.watch("tooltip",lang.hitch(this,function(name,_1d0,_1d1){_1cd.set("title",_1d1);})),cw.watch("iconClass",lang.hitch(this,function(name,_1d2,_1d3){_1cd.set("iconClass",_1d3);}))];},_setSelectedAttr:function(_1d4){this._set("selected",_1d4);this.button.set("selected",_1d4);if(_1d4){var cw=this.contentWidget;if(cw.onSelected){cw.onSelected();}}},startup:function(){this.contentWidget.startup();},destroy:function(){this.button.destroyRecursive();_1b4.forEach(this._contentWidgetWatches||[],function(w){w.unwatch();});delete this.contentWidget._buttonWidget;delete this.contentWidget._wrapperWidget;this.inherited(arguments);},destroyDescendants:function(_1d5){this.contentWidget.destroyRecursive(_1d5);}});if(has("dojo-bidi")){_1cb=_1b5("dijit.layout._AccordionInnerContainer",_1cb,{postCreate:function(){this.inherited(arguments);var _1d6=this.button;this._contentWidgetWatches.push(this.contentWidget.watch("textDir",function(name,_1d7,_1d8){_1d6.set("textDir",_1d8);}));}});}var _1d9=_1b5("dijit.layout.AccordionContainer",_1c2,{duration:_1bc.defaultDuration,buttonWidget:_1c5,baseClass:"dijitAccordionContainer",buildRendering:function(){this.inherited(arguments);this.domNode.style.overflow="hidden";this.domNode.setAttribute("role","tablist");},startup:function(){if(this._started){return;}this.inherited(arguments);if(this.selectedChildWidget){this.selectedChildWidget._wrapperWidget.set("selected",true);}},layout:function(){var _1da=this.selectedChildWidget;if(!_1da){return;}var _1db=_1da._wrapperWidget.domNode,_1dc=_1b9.getMarginExtents(_1db),_1dd=_1b9.getPadBorderExtents(_1db),_1de=_1da._wrapperWidget.containerNode,_1df=_1b9.getMarginExtents(_1de),_1e0=_1b9.getPadBorderExtents(_1de),_1e1=this._contentBox;var _1e2=0;_1b4.forEach(this.getChildren(),function(_1e3){if(_1e3!=_1da){_1e2+=_1b9.getMarginSize(_1e3._wrapperWidget.domNode).h;}});this._verticalSpace=_1e1.h-_1e2-_1dc.h-_1dd.h-_1df.h-_1e0.h-_1da._buttonWidget.getTitleHeight();this._containerContentBox={h:this._verticalSpace,w:this._contentBox.w-_1dc.w-_1dd.w-_1df.w-_1e0.w};if(_1da){_1da.resize(this._containerContentBox);}},_setupChild:function(_1e4){_1e4._wrapperWidget=_1cb({contentWidget:_1e4,buttonWidget:this.buttonWidget,id:_1e4.id+"_wrapper",dir:_1e4.dir,lang:_1e4.lang,textDir:_1e4.textDir||this.textDir,parent:this});this.inherited(arguments);_1b8.place(_1e4.domNode,_1e4._wrapper,"replace");},removeChild:function(_1e5){if(_1e5._wrapperWidget){_1b8.place(_1e5.domNode,_1e5._wrapperWidget.domNode,"after");_1e5._wrapperWidget.destroy();delete _1e5._wrapperWidget;}_1b7.remove(_1e5.domNode,"dijitHidden");this.inherited(arguments);},getChildren:function(){return _1b4.map(this.inherited(arguments),function(_1e6){return _1e6.declaredClass=="dijit.layout._AccordionInnerContainer"?_1e6.contentWidget:_1e6;},this);},destroy:function(){if(this._animation){this._animation.stop();}_1b4.forEach(this.getChildren(),function(_1e7){if(_1e7._wrapperWidget){_1e7._wrapperWidget.destroy();}else{_1e7.destroyRecursive();}});this.inherited(arguments);},_showChild:function(_1e8){_1e8._wrapperWidget.containerNode.style.display="block";return this.inherited(arguments);},_hideChild:function(_1e9){_1e9._wrapperWidget.containerNode.style.display="none";this.inherited(arguments);},_transition:function(_1ea,_1eb,_1ec){if(has("ie")<8){_1ec=false;}if(this._animation){this._animation.stop(true);delete this._animation;}var self=this;if(_1ea){_1ea._wrapperWidget.set("selected",true);var d=this._showChild(_1ea);if(this.doLayout&&_1ea.resize){_1ea.resize(this._containerContentBox);}}if(_1eb){_1eb._wrapperWidget.set("selected",false);if(!_1ec){this._hideChild(_1eb);}}if(_1ec){var _1ed=_1ea._wrapperWidget.containerNode,_1ee=_1eb._wrapperWidget.containerNode;var _1ef=_1ea._wrapperWidget.containerNode,_1f0=_1b9.getMarginExtents(_1ef),_1f1=_1b9.getPadBorderExtents(_1ef),_1f2=_1f0.h+_1f1.h;_1ee.style.height=(self._verticalSpace-_1f2)+"px";this._animation=new fx.Animation({node:_1ed,duration:this.duration,curve:[1,this._verticalSpace-_1f2-1],onAnimate:function(_1f3){_1f3=Math.floor(_1f3);_1ed.style.height=_1f3+"px";_1ee.style.height=(self._verticalSpace-_1f2-_1f3)+"px";},onEnd:function(){delete self._animation;_1ed.style.height="auto";_1eb._wrapperWidget.containerNode.style.display="none";_1ee.style.height="auto";self._hideChild(_1eb);}});this._animation.onStop=this._animation.onEnd;this._animation.play();}return d;},_onKeyDown:function(e,_1f4){if(this.disabled||e.altKey||!(_1f4||e.ctrlKey)){return;}var c=e.keyCode;if((_1f4&&(c==keys.LEFT_ARROW||c==keys.UP_ARROW))||(e.ctrlKey&&c==keys.PAGE_UP)){this._adjacent(false)._buttonWidget._onTitleClick();e.stopPropagation();e.preventDefault();}else{if((_1f4&&(c==keys.RIGHT_ARROW||c==keys.DOWN_ARROW))||(e.ctrlKey&&(c==keys.PAGE_DOWN||c==keys.TAB))){this._adjacent(true)._buttonWidget._onTitleClick();e.stopPropagation();e.preventDefault();}}}});if(has("dijit-legacy-requires")){_1bd(0,function(){var _1f5=["dijit/layout/AccordionPane"];_1b3(_1f5);});}_1d9._InnerContainer=_1cb;_1d9._Button=_1c5;return _1d9;});},"dijit/form/ComboButton":function(){define(["dojo/_base/declare","dojo/keys","../focus","./DropDownButton","dojo/text!./templates/ComboButton.html"],function(_1f6,keys,_1f7,_1f8,_1f9){return _1f6("dijit.form.ComboButton",_1f8,{templateString:_1f9,_setIdAttr:"",_setTabIndexAttr:["focusNode","titleNode"],_setTitleAttr:"titleNode",optionsTitle:"",baseClass:"dijitComboButton",cssStateNodes:{"buttonNode":"dijitButtonNode","titleNode":"dijitButtonContents","_popupStateNode":"dijitDownArrowButton"},_focusedNode:null,_onButtonKeyDown:function(evt){if(evt.keyCode==keys[this.isLeftToRight()?"RIGHT_ARROW":"LEFT_ARROW"]){_1f7.focus(this._popupStateNode);evt.stopPropagation();evt.preventDefault();}},_onArrowKeyDown:function(evt){if(evt.keyCode==keys[this.isLeftToRight()?"LEFT_ARROW":"RIGHT_ARROW"]){_1f7.focus(this.titleNode);evt.stopPropagation();evt.preventDefault();}},focus:function(_1fa){if(!this.disabled){_1f7.focus(_1fa=="start"?this.titleNode:this._popupStateNode);}}});});},"dijit/layout/SplitContainer":function(){define(["dojo/_base/array","dojo/cookie","dojo/_base/declare","dojo/dom","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/_base/event","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/sniff","../registry","../_WidgetBase","./_LayoutWidget"],function(_1fb,_1fc,_1fd,dom,_1fe,_1ff,_200,_201,_202,_203,lang,on,has,_204,_205,_206){var _207=_1fd("dijit.layout.SplitContainer",_206,{constructor:function(){_203.deprecated("dijit.layout.SplitContainer is deprecated","use BorderContainer with splitter instead",2);},activeSizing:false,sizerWidth:7,orientation:"horizontal",persist:true,baseClass:"dijitSplitContainer",postMixInProperties:function(){this.inherited("postMixInProperties",arguments);this.isHorizontal=(this.orientation=="horizontal");},postCreate:function(){this.inherited(arguments);this.sizers=[];if(has("mozilla")){this.domNode.style.overflow="-moz-scrollbars-none";}if(typeof this.sizerWidth=="object"){try{this.sizerWidth=parseInt(this.sizerWidth.toString());}catch(e){this.sizerWidth=7;}}var _208=this.ownerDocument.createElement("div");this.virtualSizer=_208;_208.style.position="relative";_208.style.zIndex=10;_208.className=this.isHorizontal?"dijitSplitContainerVirtualSizerH":"dijitSplitContainerVirtualSizerV";this.domNode.appendChild(_208);dom.setSelectable(_208,false);},destroy:function(){delete this.virtualSizer;if(this._ownconnects){var h;while(h=this._ownconnects.pop()){h.remove();}}this.inherited(arguments);},startup:function(){if(this._started){return;}_1fb.forEach(this.getChildren(),function(_209,i,_20a){this._setupChild(_209);if(i<_20a.length-1){this._addSizer();}},this);if(this.persist){this._restoreState();}this.inherited(arguments);},_setupChild:function(_20b){this.inherited(arguments);_20b.domNode.style.position="absolute";_1fe.add(_20b.domNode,"dijitSplitPane");},_onSizerMouseDown:function(e){if(e.target.id){for(var i=0;i<this.sizers.length;i++){if(this.sizers[i].id==e.target.id){break;}}if(i<this.sizers.length){this.beginSizing(e,i);}}},_addSizer:function(_20c){_20c=_20c===undefined?this.sizers.length:_20c;var _20d=this.ownerDocument.createElement("div");_20d.id=_204.getUniqueId("dijit_layout_SplitterContainer_Splitter");this.sizers.splice(_20c,0,_20d);this.domNode.appendChild(_20d);_20d.className=this.isHorizontal?"dijitSplitContainerSizerH":"dijitSplitContainerSizerV";var _20e=this.ownerDocument.createElement("div");_20e.className="thumb";_20d.appendChild(_20e);this.connect(_20d,"onmousedown","_onSizerMouseDown");dom.setSelectable(_20d,false);},removeChild:function(_20f){if(this.sizers.length){var i=_1fb.indexOf(this.getChildren(),_20f);if(i!=-1){if(i==this.sizers.length){i--;}_1ff.destroy(this.sizers[i]);this.sizers.splice(i,1);}}this.inherited(arguments);if(this._started){this.layout();}},addChild:function(_210,_211){if(typeof _211=="undefined"||_211=="last"){_211=this.getChildren().length;}this.inherited(arguments,[_210,_211]);if(this._started){var _212=this.getChildren();if(_212.length>1){this._addSizer(_211);}this.layout();}},layout:function(){this.paneWidth=this._contentBox.w;this.paneHeight=this._contentBox.h;var _213=this.getChildren();if(!_213.length){return;}var _214=this.isHorizontal?this.paneWidth:this.paneHeight;if(_213.length>1){_214-=this.sizerWidth*(_213.length-1);}var _215=0;_1fb.forEach(_213,function(_216){_215+=_216.sizeShare;});var _217=_214/_215;var _218=0;_1fb.forEach(_213.slice(0,_213.length-1),function(_219){var size=Math.round(_217*_219.sizeShare);_219.sizeActual=size;_218+=size;});_213[_213.length-1].sizeActual=_214-_218;this._checkSizes();var pos=0;var size=_213[0].sizeActual;this._movePanel(_213[0],pos,size);_213[0].position=pos;pos+=size;if(!this.sizers){return;}_1fb.some(_213.slice(1),function(_21a,i){if(!this.sizers[i]){return true;}this._moveSlider(this.sizers[i],pos,this.sizerWidth);this.sizers[i].position=pos;pos+=this.sizerWidth;size=_21a.sizeActual;this._movePanel(_21a,pos,size);_21a.position=pos;pos+=size;},this);},_movePanel:function(_21b,pos,size){var box;if(this.isHorizontal){_21b.domNode.style.left=pos+"px";_21b.domNode.style.top=0;box={w:size,h:this.paneHeight};if(_21b.resize){_21b.resize(box);}else{_200.setMarginBox(_21b.domNode,box);}}else{_21b.domNode.style.left=0;_21b.domNode.style.top=pos+"px";box={w:this.paneWidth,h:size};if(_21b.resize){_21b.resize(box);}else{_200.setMarginBox(_21b.domNode,box);}}},_moveSlider:function(_21c,pos,size){if(this.isHorizontal){_21c.style.left=pos+"px";_21c.style.top=0;_200.setMarginBox(_21c,{w:size,h:this.paneHeight});}else{_21c.style.left=0;_21c.style.top=pos+"px";_200.setMarginBox(_21c,{w:this.paneWidth,h:size});}},_growPane:function(_21d,pane){if(_21d>0){if(pane.sizeActual>pane.sizeMin){if((pane.sizeActual-pane.sizeMin)>_21d){pane.sizeActual=pane.sizeActual-_21d;_21d=0;}else{_21d-=pane.sizeActual-pane.sizeMin;pane.sizeActual=pane.sizeMin;}}}return _21d;},_checkSizes:function(){var _21e=0;var _21f=0;var _220=this.getChildren();_1fb.forEach(_220,function(_221){_21f+=_221.sizeActual;_21e+=_221.sizeMin;});if(_21e<=_21f){var _222=0;_1fb.forEach(_220,function(_223){if(_223.sizeActual<_223.sizeMin){_222+=_223.sizeMin-_223.sizeActual;_223.sizeActual=_223.sizeMin;}});if(_222>0){var list=this.isDraggingLeft?_220.reverse():_220;_1fb.forEach(list,function(_224){_222=this._growPane(_222,_224);},this);}}else{_1fb.forEach(_220,function(_225){_225.sizeActual=Math.round(_21f*(_225.sizeMin/_21e));});}},beginSizing:function(e,i){var _226=this.getChildren();this.paneBefore=_226[i];this.paneAfter=_226[i+1];this.paneBefore.sizeBeforeDrag=this.paneBefore.sizeActual;this.paneAfter.sizeBeforeDrag=this.paneAfter.sizeActual;this.paneAfter.positionBeforeDrag=this.paneAfter.position;this.isSizing=true;this.sizingSplitter=this.sizers[i];this.sizingSplitter.positionBeforeDrag=_201.get(this.sizingSplitter,(this.isHorizontal?"left":"top"));if(!this.cover){this.cover=_1ff.create("div",{style:{position:"absolute",zIndex:5,top:0,left:0,width:"100%",height:"100%"}},this.domNode);}else{this.cover.style.zIndex=5;}this.sizingSplitter.style.zIndex=6;this.startPoint=this.lastPoint=(this.isHorizontal?e.pageX:e.pageY);this.maxDelta=this.paneAfter.sizeActual-this.paneAfter.sizeMin;this.minDelta=-1*(this.paneBefore.sizeActual-this.paneBefore.sizeMin);if(!this.activeSizing){this._showSizingLine();}this._ownconnects=[on(this.ownerDocument.documentElement,"mousemove",lang.hitch(this,"changeSizing")),on(this.ownerDocument.documentElement,"mouseup",lang.hitch(this,"endSizing"))];_202.stop(e);},changeSizing:function(e){if(!this.isSizing){return;}this.lastPoint=this.isHorizontal?e.pageX:e.pageY;var _227=Math.max(Math.min(this.lastPoint-this.startPoint,this.maxDelta),this.minDelta);if(this.activeSizing){this._updateSize(_227);}else{this._moveSizingLine(_227);}_202.stop(e);},endSizing:function(){if(!this.isSizing){return;}if(this.cover){this.cover.style.zIndex=-1;}if(!this.activeSizing){this._hideSizingLine();}var _228=Math.max(Math.min(this.lastPoint-this.startPoint,this.maxDelta),this.minDelta);this._updateSize(_228);this.isSizing=false;if(this.persist){this._saveState(this);}var h;while(h=this._ownconnects.pop()){h.remove();}},_updateSize:function(_229){this.paneBefore.sizeActual=this.paneBefore.sizeBeforeDrag+_229;this.paneAfter.position=this.paneAfter.positionBeforeDrag+_229;this.paneAfter.sizeActual=this.paneAfter.sizeBeforeDrag-_229;_1fb.forEach(this.getChildren(),function(_22a){_22a.sizeShare=_22a.sizeActual;});if(this._started){this.layout();}},_showSizingLine:function(){this._moveSizingLine(0);_200.setMarginBox(this.virtualSizer,this.isHorizontal?{w:this.sizerWidth,h:this.paneHeight}:{w:this.paneWidth,h:this.sizerWidth});this.virtualSizer.style.display="block";},_hideSizingLine:function(){this.virtualSizer.style.display="none";},_moveSizingLine:function(_22b){var pos=_22b+this.sizingSplitter.positionBeforeDrag;_201.set(this.virtualSizer,(this.isHorizontal?"left":"top"),pos+"px");},_getCookieName:function(i){return this.id+"_"+i;},_restoreState:function(){_1fb.forEach(this.getChildren(),function(_22c,i){var _22d=this._getCookieName(i);var _22e=_1fc(_22d);if(_22e){var pos=parseInt(_22e);if(typeof pos=="number"){_22c.sizeShare=pos;}}},this);},_saveState:function(){if(!this.persist){return;}_1fb.forEach(this.getChildren(),function(_22f,i){_1fc(this._getCookieName(i),_22f.sizeShare,{expires:365});},this);}});_207.ChildWidgetProperties={sizeMin:10,sizeShare:10};lang.extend(_205,_207.ChildWidgetProperties);return _207;});},"dijit/form/_AutoCompleterMixin":function(){define(["dojo/aspect","dojo/_base/declare","dojo/dom-attr","dojo/keys","dojo/_base/lang","dojo/query","dojo/regexp","dojo/sniff","./DataList","./_TextBoxMixin","./_SearchMixin"],function(_230,_231,_232,keys,lang,_233,_234,has,_235,_236,_237){var _238=_231("dijit.form._AutoCompleterMixin",_237,{item:null,autoComplete:true,highlightMatch:"first",labelAttr:"",labelType:"text",maxHeight:-1,_stopClickEvents:false,_getCaretPos:function(_239){var pos=0;if(typeof (_239.selectionStart)=="number"){pos=_239.selectionStart;}else{if(has("ie")){var tr=_239.ownerDocument.selection.createRange().duplicate();var ntr=_239.createTextRange();tr.move("character",0);ntr.move("character",0);try{ntr.setEndPoint("EndToEnd",tr);pos=String(ntr.text).replace(/\r/g,"").length;}catch(e){}}}return pos;},_setCaretPos:function(_23a,_23b){_23b=parseInt(_23b);_236.selectInputText(_23a,_23b,_23b);},_setDisabledAttr:function(_23c){this.inherited(arguments);this.domNode.setAttribute("aria-disabled",_23c?"true":"false");},_onKey:function(evt){if(evt.charCode>=32){return;}var key=evt.charCode||evt.keyCode;if(key==keys.ALT||key==keys.CTRL||key==keys.META||key==keys.SHIFT){return;}var pw=this.dropDown;var _23d=null;this._abortQuery();this.inherited(arguments);if(evt.altKey||evt.ctrlKey||evt.metaKey){return;}if(this._opened){_23d=pw.getHighlightedOption();}switch(key){case keys.PAGE_DOWN:case keys.DOWN_ARROW:case keys.PAGE_UP:case keys.UP_ARROW:if(this._opened){this._announceOption(_23d);}evt.stopPropagation();evt.preventDefault();break;case keys.ENTER:if(_23d){if(_23d==pw.nextButton){this._nextSearch(1);evt.stopPropagation();evt.preventDefault();break;}else{if(_23d==pw.previousButton){this._nextSearch(-1);evt.stopPropagation();evt.preventDefault();break;}}evt.stopPropagation();evt.preventDefault();}else{this._setBlurValue();this._setCaretPos(this.focusNode,this.focusNode.value.length);}case keys.TAB:var _23e=this.get("displayedValue");if(pw&&(_23e==pw._messages["previousMessage"]||_23e==pw._messages["nextMessage"])){break;}if(_23d){this._selectOption(_23d);}case keys.ESCAPE:if(this._opened){this._lastQuery=null;this.closeDropDown();}break;}},_autoCompleteText:function(text){var fn=this.focusNode;_236.selectInputText(fn,fn.value.length);var _23f=this.ignoreCase?"toLowerCase":"substr";if(text[_23f](0).indexOf(this.focusNode.value[_23f](0))==0){var cpos=this.autoComplete?this._getCaretPos(fn):fn.value.length;if((cpos+1)>fn.value.length){fn.value=text;_236.selectInputText(fn,cpos);}}else{fn.value=text;_236.selectInputText(fn);}},_openResultList:function(_240,_241,_242){var _243=this.dropDown.getHighlightedOption();this.dropDown.clearResultList();if(!_240.length&&_242.start==0){this.closeDropDown();return;}this._nextSearch=this.dropDown.onPage=lang.hitch(this,function(_244){_240.nextPage(_244!==-1);this.focus();});this.dropDown.createOptions(_240,_242,lang.hitch(this,"_getMenuLabelFromItem"));this._showResultList();if("direction" in _242){if(_242.direction){this.dropDown.highlightFirstOption();}else{if(!_242.direction){this.dropDown.highlightLastOption();}}if(_243){this._announceOption(this.dropDown.getHighlightedOption());}}else{if(this.autoComplete&&!this._prev_key_backspace&&!/^[*]+$/.test(_241[this.searchAttr].toString())){this._announceOption(this.dropDown.containerNode.firstChild.nextSibling);}}},_showResultList:function(){this.closeDropDown(true);this.openDropDown();this.domNode.setAttribute("aria-expanded","true");},loadDropDown:function(){this._startSearchAll();},isLoaded:function(){return false;},closeDropDown:function(){this._abortQuery();if(this._opened){this.inherited(arguments);this.domNode.setAttribute("aria-expanded","false");}},_setBlurValue:function(){var _245=this.get("displayedValue");var pw=this.dropDown;if(pw&&(_245==pw._messages["previousMessage"]||_245==pw._messages["nextMessage"])){this._setValueAttr(this._lastValueReported,true);}else{if(typeof this.item=="undefined"){this.item=null;this.set("displayedValue",_245);}else{if(this.value!=this._lastValueReported){this._handleOnChange(this.value,true);}this._refreshState();}}this.focusNode.removeAttribute("aria-activedescendant");},_setItemAttr:function(item,_246,_247){var _248="";if(item){if(!_247){_247=this.store._oldAPI?this.store.getValue(item,this.searchAttr):item[this.searchAttr];}_248=this._getValueField()!=this.searchAttr?this.store.getIdentity(item):_247;}this.set("value",_248,_246,_247,item);},_announceOption:function(node){if(!node){return;}var _249;if(node==this.dropDown.nextButton||node==this.dropDown.previousButton){_249=node.innerHTML;this.item=undefined;this.value="";}else{var item=this.dropDown.items[node.getAttribute("item")];_249=(this.store._oldAPI?this.store.getValue(item,this.searchAttr):item[this.searchAttr]).toString();this.set("item",item,false,_249);}this.focusNode.value=this.focusNode.value.substring(0,this._lastInput.length);this.focusNode.setAttribute("aria-activedescendant",_232.get(node,"id"));this._autoCompleteText(_249);},_selectOption:function(_24a){this.closeDropDown();if(_24a){this._announceOption(_24a);}this._setCaretPos(this.focusNode,this.focusNode.value.length);this._handleOnChange(this.value,true);this.focusNode.removeAttribute("aria-activedescendant");},_startSearchAll:function(){this._startSearch("");},_startSearchFromInput:function(){this.item=undefined;this.inherited(arguments);},_startSearch:function(key){if(!this.dropDown){var _24b=this.id+"_popup",_24c=lang.isString(this.dropDownClass)?lang.getObject(this.dropDownClass,false):this.dropDownClass;this.dropDown=new _24c({onChange:lang.hitch(this,this._selectOption),id:_24b,dir:this.dir,textDir:this.textDir});}this._lastInput=key;this.inherited(arguments);},_getValueField:function(){return this.searchAttr;},postMixInProperties:function(){this.inherited(arguments);if(!this.store){var _24d=this.srcNodeRef;this.store=new _235({},_24d);if(!("value" in this.params)){var item=(this.item=this.store.fetchSelectedItem());if(item){var _24e=this._getValueField();this.value=this.store._oldAPI?this.store.getValue(item,_24e):item[_24e];}}}},postCreate:function(){var _24f=_233("label[for=\""+this.id+"\"]");if(_24f.length){if(!_24f[0].id){_24f[0].id=this.id+"_label";}this.domNode.setAttribute("aria-labelledby",_24f[0].id);}this.inherited(arguments);_230.after(this,"onSearch",lang.hitch(this,"_openResultList"),true);},_getMenuLabelFromItem:function(item){var _250=this.labelFunc(item,this.store),_251=this.labelType;if(this.highlightMatch!="none"&&this.labelType=="text"&&this._lastInput){_250=this.doHighlight(_250,this._lastInput);_251="html";}return {html:_251=="html",label:_250};},doHighlight:function(_252,find){var _253=(this.ignoreCase?"i":"")+(this.highlightMatch=="all"?"g":""),i=this.queryExpr.indexOf("${0}");find=_234.escapeString(find);return this._escapeHtml(_252.replace(new RegExp((i==0?"^":"")+"("+find+")"+(i==(this.queryExpr.length-4)?"$":""),_253),"\uffff$1\uffff")).replace(/\uFFFF([^\uFFFF]+)\uFFFF/g,"<span class=\"dijitComboBoxHighlightMatch\">$1</span>");},_escapeHtml:function(str){str=String(str).replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;");return str;},reset:function(){this.item=null;this.inherited(arguments);},labelFunc:function(item,_254){return (_254._oldAPI?_254.getValue(item,this.labelAttr||this.searchAttr):item[this.labelAttr||this.searchAttr]).toString();},_setValueAttr:function(_255,_256,_257,item){this._set("item",item||null);if(_255==null){_255="";}this.inherited(arguments);}});if(has("dojo-bidi")){_238.extend({_setTextDirAttr:function(_258){this.inherited(arguments);if(this.dropDown){this.dropDown._set("textDir",_258);}}});}return _238;});},"dijit/form/MappedTextBox":function(){define(["dojo/_base/declare","dojo/sniff","dojo/dom-construct","./ValidationTextBox"],function(_259,has,_25a,_25b){return _259("dijit.form.MappedTextBox",_25b,{postMixInProperties:function(){this.inherited(arguments);this.nameAttrSetting="";},_setNameAttr:"valueNode",serialize:function(val){return val.toString?val.toString():"";},toString:function(){var val=this.filter(this.get("value"));return val!=null?(typeof val=="string"?val:this.serialize(val,this.constraints)):"";},validate:function(){this.valueNode.value=this.toString();return this.inherited(arguments);},buildRendering:function(){this.inherited(arguments);this.valueNode=_25a.place("<input type='hidden'"+((this.name&&!has("msapp"))?" name=\""+this.name.replace(/"/g,"&quot;")+"\"":"")+"/>",this.textbox,"after");},reset:function(){this.valueNode.value="";this.inherited(arguments);}});});},"dijit/form/ComboBoxMixin":function(){define(["dojo/_base/declare","dojo/Deferred","dojo/_base/kernel","dojo/_base/lang","dojo/store/util/QueryResults","./_AutoCompleterMixin","./_ComboBoxMenu","../_HasDropDown","dojo/text!./templates/DropDownBox.html"],function(_25c,_25d,_25e,lang,_25f,_260,_261,_262,_263){return _25c("dijit.form.ComboBoxMixin",[_262,_260],{dropDownClass:_261,hasDownArrow:true,templateString:_263,baseClass:"dijitTextBox dijitComboBox",cssStateNodes:{"_buttonNode":"dijitDownArrowButton"},_setHasDownArrowAttr:function(val){this._set("hasDownArrow",val);this._buttonNode.style.display=val?"":"none";},_showResultList:function(){this.displayMessage("");this.inherited(arguments);},_setStoreAttr:function(_264){if(!_264.get){lang.mixin(_264,{_oldAPI:true,get:function(id){var _265=new _25d();this.fetchItemByIdentity({identity:id,onItem:function(_266){_265.resolve(_266);},onError:function(_267){_265.reject(_267);}});return _265.promise;},query:function(_268,_269){var _26a=new _25d(function(){_26b.abort&&_26b.abort();});_26a.total=new _25d();var _26b=this.fetch(lang.mixin({query:_268,onBegin:function(_26c){_26a.total.resolve(_26c);},onComplete:function(_26d){_26a.resolve(_26d);},onError:function(_26e){_26a.reject(_26e);}},_269));return _25f(_26a);}});}this._set("store",_264);},postMixInProperties:function(){var _26f=this.params.store||this.store;if(_26f){this._setStoreAttr(_26f);}this.inherited(arguments);if(!this.params.store&&!this.store._oldAPI){var _270=this.declaredClass;lang.mixin(this.store,{getValue:function(item,attr){_25e.deprecated(_270+".store.getValue(item, attr) is deprecated for builtin store.  Use item.attr directly","","2.0");return item[attr];},getLabel:function(item){_25e.deprecated(_270+".store.getLabel(item) is deprecated for builtin store.  Use item.label directly","","2.0");return item.name;},fetch:function(args){_25e.deprecated(_270+".store.fetch() is deprecated for builtin store.","Use store.query()","2.0");var shim=["dojo/data/ObjectStore"];require(shim,lang.hitch(this,function(_271){new _271({objectStore:this}).fetch(args);}));}});}}});});},"dijit/form/_TextBoxMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom","dojo/has","dojo/keys","dojo/_base/lang","dojo/on","../main"],function(_272,_273,dom,has,keys,lang,on,_274){var _275=_273("dijit.form._TextBoxMixin"+(has("dojo-bidi")?"_NoBidi":""),null,{trim:false,uppercase:false,lowercase:false,propercase:false,maxLength:"",selectOnClick:false,placeHolder:"",_getValueAttr:function(){return this.parse(this.get("displayedValue"),this.constraints);},_setValueAttr:function(_276,_277,_278){var _279;if(_276!==undefined){_279=this.filter(_276);if(typeof _278!="string"){if(_279!==null&&((typeof _279!="number")||!isNaN(_279))){_278=this.filter(this.format(_279,this.constraints));}else{_278="";}}}if(_278!=null&&((typeof _278)!="number"||!isNaN(_278))&&this.textbox.value!=_278){this.textbox.value=_278;this._set("displayedValue",this.get("displayedValue"));}this.inherited(arguments,[_279,_277]);},displayedValue:"",_getDisplayedValueAttr:function(){return this.filter(this.textbox.value);},_setDisplayedValueAttr:function(_27a){if(_27a==null){_27a="";}else{if(typeof _27a!="string"){_27a=String(_27a);}}this.textbox.value=_27a;this._setValueAttr(this.get("value"),undefined);this._set("displayedValue",this.get("displayedValue"));},format:function(_27b){return _27b==null?"":(_27b.toString?_27b.toString():_27b);},parse:function(_27c){return _27c;},_refreshState:function(){},onInput:function(){},__skipInputEvent:false,_onInput:function(evt){this._processInput(evt);if(this.intermediateChanges){this.defer(function(){this._handleOnChange(this.get("value"),false);});}},_processInput:function(evt){this._refreshState();this._set("displayedValue",this.get("displayedValue"));},postCreate:function(){this.textbox.setAttribute("value",this.textbox.value);this.inherited(arguments);var _27d=function(e){var _27e;if(e.type=="keydown"){_27e=e.keyCode;switch(_27e){case keys.SHIFT:case keys.ALT:case keys.CTRL:case keys.META:case keys.CAPS_LOCK:case keys.NUM_LOCK:case keys.SCROLL_LOCK:return;}if(!e.ctrlKey&&!e.metaKey&&!e.altKey){switch(_27e){case keys.NUMPAD_0:case keys.NUMPAD_1:case keys.NUMPAD_2:case keys.NUMPAD_3:case keys.NUMPAD_4:case keys.NUMPAD_5:case keys.NUMPAD_6:case keys.NUMPAD_7:case keys.NUMPAD_8:case keys.NUMPAD_9:case keys.NUMPAD_MULTIPLY:case keys.NUMPAD_PLUS:case keys.NUMPAD_ENTER:case keys.NUMPAD_MINUS:case keys.NUMPAD_PERIOD:case keys.NUMPAD_DIVIDE:return;}if((_27e>=65&&_27e<=90)||(_27e>=48&&_27e<=57)||_27e==keys.SPACE){return;}var _27f=false;for(var i in keys){if(keys[i]===e.keyCode){_27f=true;break;}}if(!_27f){return;}}}_27e=e.charCode>=32?String.fromCharCode(e.charCode):e.charCode;if(!_27e){_27e=(e.keyCode>=65&&e.keyCode<=90)||(e.keyCode>=48&&e.keyCode<=57)||e.keyCode==keys.SPACE?String.fromCharCode(e.keyCode):e.keyCode;}if(!_27e){_27e=229;}if(e.type=="keypress"){if(typeof _27e!="string"){return;}if((_27e>="a"&&_27e<="z")||(_27e>="A"&&_27e<="Z")||(_27e>="0"&&_27e<="9")||(_27e===" ")){if(e.ctrlKey||e.metaKey||e.altKey){return;}}}if(e.type=="input"){if(this.__skipInputEvent){this.__skipInputEvent=false;return;}}else{this.__skipInputEvent=true;}var faux={faux:true},attr;for(attr in e){if(attr!="layerX"&&attr!="layerY"){var v=e[attr];if(typeof v!="function"&&typeof v!="undefined"){faux[attr]=v;}}}lang.mixin(faux,{charOrCode:_27e,_wasConsumed:false,preventDefault:function(){faux._wasConsumed=true;e.preventDefault();},stopPropagation:function(){e.stopPropagation();}});if(this.onInput(faux)===false){faux.preventDefault();faux.stopPropagation();}if(faux._wasConsumed){return;}this.defer(function(){this._onInput(faux);});if(e.type=="keypress"){e.stopPropagation();}};this.own(on(this.textbox,"keydown, keypress, paste, cut, input, compositionend",lang.hitch(this,_27d)));},_blankValue:"",filter:function(val){if(val===null){return this._blankValue;}if(typeof val!="string"){return val;}if(this.trim){val=lang.trim(val);}if(this.uppercase){val=val.toUpperCase();}if(this.lowercase){val=val.toLowerCase();}if(this.propercase){val=val.replace(/[^\s]+/g,function(word){return word.substring(0,1).toUpperCase()+word.substring(1);});}return val;},_setBlurValue:function(){this._setValueAttr(this.get("value"),true);},_onBlur:function(e){if(this.disabled){return;}this._setBlurValue();this.inherited(arguments);},_isTextSelected:function(){return this.textbox.selectionStart!=this.textbox.selectionEnd;},_onFocus:function(by){if(this.disabled||this.readOnly){return;}if(this.selectOnClick&&by=="mouse"){this._selectOnClickHandle=on.once(this.domNode,"mouseup, touchend",lang.hitch(this,function(evt){if(!this._isTextSelected()){_275.selectInputText(this.textbox);}}));this.own(this._selectOnClickHandle);this.defer(function(){if(this._selectOnClickHandle){this._selectOnClickHandle.remove();this._selectOnClickHandle=null;}},500);}this.inherited(arguments);this._refreshState();},reset:function(){this.textbox.value="";this.inherited(arguments);}});if(has("dojo-bidi")){_275=_273("dijit.form._TextBoxMixin",_275,{_setValueAttr:function(){this.inherited(arguments);this.applyTextDir(this.focusNode);},_setDisplayedValueAttr:function(){this.inherited(arguments);this.applyTextDir(this.focusNode);},_onInput:function(){this.applyTextDir(this.focusNode);this.inherited(arguments);}});}_275._setSelectionRange=_274._setSelectionRange=function(_280,_281,stop){if(_280.setSelectionRange){_280.setSelectionRange(_281,stop);}};_275.selectInputText=_274.selectInputText=function(_282,_283,stop){_282=dom.byId(_282);if(isNaN(_283)){_283=0;}if(isNaN(stop)){stop=_282.value?_282.value.length:0;}try{_282.focus();_275._setSelectionRange(_282,_283,stop);}catch(e){}};return _275;});},"dijit/form/SimpleTextarea":function(){define(["dojo/_base/declare","dojo/dom-class","dojo/sniff","./TextBox"],function(_284,_285,has,_286){return _284("dijit.form.SimpleTextarea",_286,{baseClass:"dijitTextBox dijitTextArea",rows:"3",cols:"20",templateString:"<textarea ${!nameAttrSetting} data-dojo-attach-point='focusNode,containerNode,textbox' autocomplete='off'></textarea>",postMixInProperties:function(){if(!this.value&&this.srcNodeRef){this.value=this.srcNodeRef.value;}this.inherited(arguments);},buildRendering:function(){this.inherited(arguments);if(has("ie")&&this.cols){_285.add(this.textbox,"dijitTextAreaCols");}},filter:function(_287){if(_287){_287=_287.replace(/\r/g,"");}return this.inherited(arguments);},_onInput:function(e){if(this.maxLength){var _288=parseInt(this.maxLength);var _289=this.textbox.value.replace(/\r/g,"");var _28a=_289.length-_288;if(_28a>0){var _28b=this.textbox;if(_28b.selectionStart){var pos=_28b.selectionStart;var cr=0;if(has("opera")){cr=(this.textbox.value.substring(0,pos).match(/\r/g)||[]).length;}this.textbox.value=_289.substring(0,pos-_28a-cr)+_289.substring(pos-cr);_28b.setSelectionRange(pos-_28a,pos-_28a);}else{if(this.ownerDocument.selection){_28b.focus();var _28c=this.ownerDocument.selection.createRange();_28c.moveStart("character",-_28a);_28c.text="";_28c.select();}}}}this.inherited(arguments);}});});},"dijit/PopupMenuItem":function(){define(["dojo/_base/declare","dojo/dom-style","dojo/_base/lang","dojo/query","./popup","./registry","./MenuItem","./hccss"],function(_28d,_28e,lang,_28f,pm,_290,_291){return _28d("dijit.PopupMenuItem",_291,{_fillContent:function(){if(this.srcNodeRef){var _292=_28f("*",this.srcNodeRef);this.inherited(arguments,[_292[0]]);this.dropDownContainer=this.srcNodeRef;}},_openPopup:function(_293,_294){var _295=this.popup;pm.open(lang.delegate(_293,{popup:this.popup,around:this.domNode}));if(_294&&_295.focus){_295.focus();}},_closePopup:function(){pm.close(this.popup);this.popup.parentMenu=null;},startup:function(){if(this._started){return;}this.inherited(arguments);if(!this.popup){var node=_28f("[widgetId]",this.dropDownContainer)[0];this.popup=_290.byNode(node);}this.ownerDocumentBody.appendChild(this.popup.domNode);this.popup.domNode.setAttribute("aria-labelledby",this.containerNode.id);this.popup.startup();this.popup.domNode.style.display="none";if(this.arrowWrapper){_28e.set(this.arrowWrapper,"visibility","");}this.focusNode.setAttribute("aria-haspopup","true");},destroyDescendants:function(_296){if(this.popup){if(!this.popup._destroyed){this.popup.destroyRecursive(_296);}delete this.popup;}this.inherited(arguments);}});});},"dijit/_TimePicker":function(){define(["dojo/_base/array","dojo/date","dojo/date/locale","dojo/date/stamp","dojo/_base/declare","dojo/dom-class","dojo/dom-construct","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/sniff","dojo/query","dojo/mouse","dojo/on","./_WidgetBase","./form/_ListMouseMixin"],function(_297,_298,_299,_29a,_29b,_29c,_29d,_29e,keys,lang,has,_29f,_2a0,on,_2a1,_2a2){var _2a3=_29b("dijit._TimePicker",[_2a1,_2a2],{baseClass:"dijitTimePicker",clickableIncrement:"T00:15:00",visibleIncrement:"T01:00:00",value:new Date(),_visibleIncrement:2,_clickableIncrement:1,_totalIncrements:10,constraints:{},serialize:_29a.toISOString,buildRendering:function(){this.inherited(arguments);this.containerNode=this.domNode;this.timeMenu=this.domNode;},setValue:function(_2a4){_29e.deprecated("dijit._TimePicker:setValue() is deprecated.  Use set('value', ...) instead.","","2.0");this.set("value",_2a4);},_setValueAttr:function(date){this._set("value",date);this._showText();},_setFilterStringAttr:function(val){this._set("filterString",val);this._showText();},isDisabledDate:function(){return false;},_getFilteredNodes:function(_2a5,_2a6,_2a7,_2a8){var _2a9=[];for(var i=0;i<this._maxIncrement;i++){var n=this._createOption(i);if(n){_2a9.push(n);}}return _2a9;},_showText:function(){var _2aa=_29a.fromISOString;this.domNode.innerHTML="";this._clickableIncrementDate=_2aa(this.clickableIncrement);this._visibleIncrementDate=_2aa(this.visibleIncrement);var _2ab=function(date){return date.getHours()*60*60+date.getMinutes()*60+date.getSeconds();},_2ac=_2ab(this._clickableIncrementDate),_2ad=_2ab(this._visibleIncrementDate),time=(this.value||this.currentFocus).getTime();this._refDate=_2aa("T00:00:00");this._refDate.setFullYear(1970,0,1);this._clickableIncrement=1;this._visibleIncrement=_2ad/_2ac;this._maxIncrement=(60*60*24)/_2ac;var _2ae=this._getFilteredNodes();_297.forEach(_2ae,function(n){this.domNode.appendChild(n);},this);if(!_2ae.length&&this.filterString){this.filterString="";this._showText();}},constructor:function(){this.constraints={};},postMixInProperties:function(){this.inherited(arguments);this._setConstraintsAttr(this.constraints);},_setConstraintsAttr:function(_2af){for(var key in _2af){this._set(key,_2af[key]);}if(!_2af.locale){_2af.locale=this.lang;}},_createOption:function(_2b0){var date=new Date(this._refDate);var _2b1=this._clickableIncrementDate;date.setTime(date.getTime()+_2b1.getHours()*_2b0*3600000+_2b1.getMinutes()*_2b0*60000+_2b1.getSeconds()*_2b0*1000);if(this.constraints.selector=="time"){date.setFullYear(1970,0,1);}var _2b2=_299.format(date,this.constraints);if(this.filterString&&_2b2.toLowerCase().indexOf(this.filterString)!==0){return null;}var div=this.ownerDocument.createElement("div");div.className=this.baseClass+"Item";div.date=date;div.idx=_2b0;_29d.create("div",{"class":this.baseClass+"ItemInner",innerHTML:_2b2},div);if(_2b0%this._visibleIncrement<1&&_2b0%this._visibleIncrement>-1){_29c.add(div,this.baseClass+"Marker");}else{if(!(_2b0%this._clickableIncrement)){_29c.add(div,this.baseClass+"Tick");}}if(this.isDisabledDate(date)){_29c.add(div,this.baseClass+"ItemDisabled");}if(this.value&&!_298.compare(this.value,date,this.constraints.selector)){div.selected=true;_29c.add(div,this.baseClass+"ItemSelected");this._selectedDiv=div;if(_29c.contains(div,this.baseClass+"Marker")){_29c.add(div,this.baseClass+"MarkerSelected");}else{_29c.add(div,this.baseClass+"TickSelected");}this._highlightOption(div,true);}return div;},onOpen:function(){this.inherited(arguments);this.set("selected",this._selectedDiv);},_onOptionSelected:function(tgt){var _2b3=tgt.target.date||tgt.target.parentNode.date;if(!_2b3||this.isDisabledDate(_2b3)){return;}this._highlighted_option=null;this.set("value",_2b3);this.onChange(_2b3);},onChange:function(){},_highlightOption:function(node,_2b4){if(!node){return;}if(_2b4){if(this._highlighted_option){this._highlightOption(this._highlighted_option,false);}this._highlighted_option=node;}else{if(this._highlighted_option!==node){return;}else{this._highlighted_option=null;}}_29c.toggle(node,this.baseClass+"ItemHover",_2b4);if(_29c.contains(node,this.baseClass+"Marker")){_29c.toggle(node,this.baseClass+"MarkerHover",_2b4);}else{_29c.toggle(node,this.baseClass+"TickHover",_2b4);}},handleKey:function(e){if(e.keyCode==keys.DOWN_ARROW){this.selectNextNode();e.stopPropagation();e.preventDefault();return false;}else{if(e.keyCode==keys.UP_ARROW){this.selectPreviousNode();e.stopPropagation();e.preventDefault();return false;}else{if(e.keyCode==keys.ENTER||e.keyCode===keys.TAB){if(!this._keyboardSelected&&e.keyCode===keys.TAB){return true;}if(this._highlighted_option){this._onOptionSelected({target:this._highlighted_option});}return e.keyCode===keys.TAB;}}}return undefined;},onHover:function(node){this._highlightOption(node,true);},onUnhover:function(node){this._highlightOption(node,false);},onSelect:function(node){this._highlightOption(node,true);},onDeselect:function(node){this._highlightOption(node,false);},onClick:function(node){this._onOptionSelected({target:node});}});return _2a3;});},"dijit/form/RadioButton":function(){define(["dojo/_base/declare","./CheckBox","./_RadioButtonMixin"],function(_2b5,_2b6,_2b7){return _2b5("dijit.form.RadioButton",[_2b6,_2b7],{baseClass:"dijitRadio"});});},"dijit/InlineEditBox":function(){define(["require","dojo/_base/array","dojo/aspect","dojo/_base/declare","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-style","dojo/i18n","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/on","dojo/sniff","dojo/when","./a11yclick","./focus","./_Widget","./_TemplatedMixin","./_WidgetsInTemplateMixin","./_Container","./form/Button","./form/_TextBoxMixin","./form/TextBox","dojo/text!./templates/InlineEditBox.html","dojo/i18n!./nls/common"],function(_2b8,_2b9,_2ba,_2bb,_2bc,_2bd,_2be,_2bf,i18n,_2c0,keys,lang,on,has,when,_2c1,fm,_2c2,_2c3,_2c4,_2c5,_2c6,_2c7,_2c8,_2c9){var _2ca=_2bb("dijit._InlineEditor",[_2c2,_2c3,_2c4],{templateString:_2c9,contextRequire:_2b8,postMixInProperties:function(){this.inherited(arguments);this.messages=i18n.getLocalization("dijit","common",this.lang);_2b9.forEach(["buttonSave","buttonCancel"],function(prop){if(!this[prop]){this[prop]=this.messages[prop];}},this);},buildRendering:function(){this.inherited(arguments);var Cls=typeof this.editor=="string"?(lang.getObject(this.editor)||_2b8(this.editor)):this.editor;var _2cb=this.sourceStyle,_2cc="line-height:"+_2cb.lineHeight+";",_2cd=_2bf.getComputedStyle(this.domNode);_2b9.forEach(["Weight","Family","Size","Style"],function(prop){var _2ce=_2cb["font"+prop],_2cf=_2cd["font"+prop];if(_2cf!=_2ce){_2cc+="font-"+prop+":"+_2cb["font"+prop]+";";}},this);_2b9.forEach(["marginTop","marginBottom","marginLeft","marginRight","position","left","top","right","bottom","float","clear","display"],function(prop){this.domNode.style[prop]=_2cb[prop];},this);var _2d0=this.inlineEditBox.width;if(_2d0=="100%"){_2cc+="width:100%;";this.domNode.style.display="block";}else{_2cc+="width:"+(_2d0+(Number(_2d0)==_2d0?"px":""))+";";}var _2d1=lang.delegate(this.inlineEditBox.editorParams,{style:_2cc,dir:this.dir,lang:this.lang,textDir:this.textDir});this.editWidget=new Cls(_2d1,this.editorPlaceholder);if(this.inlineEditBox.autoSave){_2be.destroy(this.buttonContainer);}},postCreate:function(){this.inherited(arguments);var ew=this.editWidget;if(this.inlineEditBox.autoSave){this.own(_2ba.after(ew,"onChange",lang.hitch(this,"_onChange"),true),on(ew,"keydown",lang.hitch(this,"_onKeyDown")));}else{if("intermediateChanges" in ew){ew.set("intermediateChanges",true);this.own(_2ba.after(ew,"onChange",lang.hitch(this,"_onIntermediateChange"),true));this.saveButton.set("disabled",true);}}},startup:function(){this.editWidget.startup();this.inherited(arguments);},_onIntermediateChange:function(){this.saveButton.set("disabled",(this.getValue()==this._resetValue)||!this.enableSave());},destroy:function(){this.editWidget.destroy(true);this.inherited(arguments);},getValue:function(){var ew=this.editWidget;return String(ew.get(("displayedValue" in ew||"_getDisplayedValueAttr" in ew)?"displayedValue":"value"));},_onKeyDown:function(e){if(this.inlineEditBox.autoSave&&this.inlineEditBox.editing){if(e.altKey||e.ctrlKey){return;}if(e.keyCode==keys.ESCAPE){e.stopPropagation();e.preventDefault();this.cancel(true);}else{if(e.keyCode==keys.ENTER&&e.target.tagName=="INPUT"){e.stopPropagation();e.preventDefault();this._onChange();}}}},_onBlur:function(){this.inherited(arguments);if(this.inlineEditBox.autoSave&&this.inlineEditBox.editing){if(this.getValue()==this._resetValue){this.cancel(false);}else{if(this.enableSave()){this.save(false);}}}},_onChange:function(){if(this.inlineEditBox.autoSave&&this.inlineEditBox.editing&&this.enableSave()){fm.focus(this.inlineEditBox.displayNode);}},enableSave:function(){return this.editWidget.isValid?this.editWidget.isValid():true;},focus:function(){this.editWidget.focus();if(this.editWidget.focusNode){fm._onFocusNode(this.editWidget.focusNode);if(this.editWidget.focusNode.tagName=="INPUT"){this.defer(function(){_2c7.selectInputText(this.editWidget.focusNode);});}}}});var _2d2=_2bb("dijit.InlineEditBox"+(has("dojo-bidi")?"_NoBidi":""),_2c2,{editing:false,autoSave:true,buttonSave:"",buttonCancel:"",renderAsHtml:false,editor:_2c8,editorWrapper:_2ca,editorParams:{},disabled:false,onChange:function(){},onCancel:function(){},width:"100%",value:"",noValueIndicator:has("ie")<=6?"<span style='font-family: wingdings; text-decoration: underline;'>&#160;&#160;&#160;&#160;&#x270d;&#160;&#160;&#160;&#160;</span>":"<span style='text-decoration: underline;'>&#160;&#160;&#160;&#160;&#x270d;&#160;&#160;&#160;&#160;</span>",constructor:function(){this.editorParams={};},postMixInProperties:function(){this.inherited(arguments);this.displayNode=this.srcNodeRef;this.own(on(this.displayNode,_2c1,lang.hitch(this,"_onClick")),on(this.displayNode,"mouseover, focus",lang.hitch(this,"_onMouseOver")),on(this.displayNode,"mouseout, blur",lang.hitch(this,"_onMouseOut")));this.displayNode.setAttribute("role","button");if(!this.displayNode.getAttribute("tabIndex")){this.displayNode.setAttribute("tabIndex",0);}if(!this.value&&!("value" in this.params)){this.value=lang.trim(this.renderAsHtml?this.displayNode.innerHTML:(this.displayNode.innerText||this.displayNode.textContent||""));}if(!this.value){this.displayNode.innerHTML=this.noValueIndicator;}_2bd.add(this.displayNode,"dijitInlineEditBoxDisplayMode");},setDisabled:function(_2d3){_2c0.deprecated("dijit.InlineEditBox.setDisabled() is deprecated.  Use set('disabled', bool) instead.","","2.0");this.set("disabled",_2d3);},_setDisabledAttr:function(_2d4){this.domNode.setAttribute("aria-disabled",_2d4?"true":"false");if(_2d4){this.displayNode.removeAttribute("tabIndex");}else{this.displayNode.setAttribute("tabIndex",0);}_2bd.toggle(this.displayNode,"dijitInlineEditBoxDisplayModeDisabled",_2d4);this._set("disabled",_2d4);},_onMouseOver:function(){if(!this.disabled){_2bd.add(this.displayNode,"dijitInlineEditBoxDisplayModeHover");}},_onMouseOut:function(){_2bd.remove(this.displayNode,"dijitInlineEditBoxDisplayModeHover");},_onClick:function(e){if(this.disabled){return;}if(e){e.stopPropagation();e.preventDefault();}this._onMouseOut();this.defer("edit");},edit:function(){if(this.disabled||this.editing){return;}this._set("editing",true);this._savedTabIndex=_2bc.get(this.displayNode,"tabIndex")||"0";if(!this.wrapperWidget){var _2d5=_2be.create("span",null,this.domNode,"before");var Ewc=typeof this.editorWrapper=="string"?lang.getObject(this.editorWrapper):this.editorWrapper;this.wrapperWidget=new Ewc({value:this.value,buttonSave:this.buttonSave,buttonCancel:this.buttonCancel,dir:this.dir,lang:this.lang,tabIndex:this._savedTabIndex,editor:this.editor,inlineEditBox:this,sourceStyle:_2bf.getComputedStyle(this.displayNode),save:lang.hitch(this,"save"),cancel:lang.hitch(this,"cancel"),textDir:this.textDir},_2d5);if(!this.wrapperWidget._started){this.wrapperWidget.startup();}if(!this._started){this.startup();}}var ww=this.wrapperWidget;_2bd.add(this.displayNode,"dijitOffScreen");_2bd.remove(ww.domNode,"dijitOffScreen");_2bf.set(ww.domNode,{visibility:"visible"});_2bc.set(this.displayNode,"tabIndex","-1");var ew=ww.editWidget;var self=this;when(ew.onLoadDeferred,lang.hitch(ww,function(){ew.set(("displayedValue" in ew||"_setDisplayedValueAttr" in ew)?"displayedValue":"value",self.value);this.defer(function(){ww.saveButton.set("disabled","intermediateChanges" in ew);this.focus();this._resetValue=this.getValue();});}));},_onBlur:function(){this.inherited(arguments);if(!this.editing){}},destroy:function(){if(this.wrapperWidget&&!this.wrapperWidget._destroyed){this.wrapperWidget.destroy();delete this.wrapperWidget;}this.inherited(arguments);},_showText:function(_2d6){var ww=this.wrapperWidget;_2bf.set(ww.domNode,{visibility:"hidden"});_2bd.add(ww.domNode,"dijitOffScreen");_2bd.remove(this.displayNode,"dijitOffScreen");_2bc.set(this.displayNode,"tabIndex",this._savedTabIndex);if(_2d6){fm.focus(this.displayNode);}},save:function(_2d7){if(this.disabled||!this.editing){return;}this._set("editing",false);var ww=this.wrapperWidget;var _2d8=ww.getValue();this.set("value",_2d8);this._showText(_2d7);},setValue:function(val){_2c0.deprecated("dijit.InlineEditBox.setValue() is deprecated.  Use set('value', ...) instead.","","2.0");return this.set("value",val);},_setValueAttr:function(val){val=lang.trim(val);var _2d9=this.renderAsHtml?val:val.replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;").replace(/\n/g,"<br>");this.displayNode.innerHTML=_2d9||this.noValueIndicator;this._set("value",val);if(this._started){this.defer(function(){this.onChange(val);});}},getValue:function(){_2c0.deprecated("dijit.InlineEditBox.getValue() is deprecated.  Use get('value') instead.","","2.0");return this.get("value");},cancel:function(_2da){if(this.disabled||!this.editing){return;}this._set("editing",false);this.defer("onCancel");this._showText(_2da);}});if(has("dojo-bidi")){_2d2=_2bb("dijit.InlineEditBox",_2d2,{_setValueAttr:function(){this.inherited(arguments);this.applyTextDir(this.displayNode);}});}_2d2._InlineEditor=_2ca;return _2d2;});},"dojo/dnd/autoscroll":function(){define(["../_base/lang","../sniff","../_base/window","../dom-geometry","../dom-style","../window"],function(lang,has,win,_2db,_2dc,_2dd){var _2de={};lang.setObject("dojo.dnd.autoscroll",_2de);_2de.getViewport=_2dd.getBox;_2de.V_TRIGGER_AUTOSCROLL=32;_2de.H_TRIGGER_AUTOSCROLL=32;_2de.V_AUTOSCROLL_VALUE=16;_2de.H_AUTOSCROLL_VALUE=16;var _2df,doc=win.doc,_2e0=Infinity,_2e1=Infinity;_2de.autoScrollStart=function(d){doc=d;_2df=_2dd.getBox(doc);var html=win.body(doc).parentNode;_2e0=Math.max(html.scrollHeight-_2df.h,0);_2e1=Math.max(html.scrollWidth-_2df.w,0);};_2de.autoScroll=function(e){var v=_2df||_2dd.getBox(doc),html=win.body(doc).parentNode,dx=0,dy=0;if(e.clientX<_2de.H_TRIGGER_AUTOSCROLL){dx=-_2de.H_AUTOSCROLL_VALUE;}else{if(e.clientX>v.w-_2de.H_TRIGGER_AUTOSCROLL){dx=Math.min(_2de.H_AUTOSCROLL_VALUE,_2e1-html.scrollLeft);}}if(e.clientY<_2de.V_TRIGGER_AUTOSCROLL){dy=-_2de.V_AUTOSCROLL_VALUE;}else{if(e.clientY>v.h-_2de.V_TRIGGER_AUTOSCROLL){dy=Math.min(_2de.V_AUTOSCROLL_VALUE,_2e0-html.scrollTop);}}window.scrollBy(dx,dy);};_2de._validNodes={"div":1,"p":1,"td":1};_2de._validOverflow={"auto":1,"scroll":1};_2de.autoScrollNodes=function(e){var b,t,w,h,rx,ry,dx=0,dy=0,_2e2,_2e3;for(var n=e.target;n;){if(n.nodeType==1&&(n.tagName.toLowerCase() in _2de._validNodes)){var s=_2dc.getComputedStyle(n),_2e4=(s.overflow.toLowerCase() in _2de._validOverflow),_2e5=(s.overflowX.toLowerCase() in _2de._validOverflow),_2e6=(s.overflowY.toLowerCase() in _2de._validOverflow);if(_2e4||_2e5||_2e6){b=_2db.getContentBox(n,s);t=_2db.position(n,true);}if(_2e4||_2e5){w=Math.min(_2de.H_TRIGGER_AUTOSCROLL,b.w/2);rx=e.pageX-t.x;if(has("webkit")||has("opera")){rx+=win.body().scrollLeft;}dx=0;if(rx>0&&rx<b.w){if(rx<w){dx=-w;}else{if(rx>b.w-w){dx=w;}}_2e2=n.scrollLeft;n.scrollLeft=n.scrollLeft+dx;}}if(_2e4||_2e6){h=Math.min(_2de.V_TRIGGER_AUTOSCROLL,b.h/2);ry=e.pageY-t.y;if(has("webkit")||has("opera")){ry+=win.body().scrollTop;}dy=0;if(ry>0&&ry<b.h){if(ry<h){dy=-h;}else{if(ry>b.h-h){dy=h;}}_2e3=n.scrollTop;n.scrollTop=n.scrollTop+dy;}}if(dx||dy){return;}}try{n=n.parentNode;}catch(x){n=null;}}_2de.autoScroll(e);};return _2de;});},"dijit/form/_RadioButtonMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/_base/lang","dojo/query","../registry"],function(_2e7,_2e8,_2e9,lang,_2ea,_2eb){return _2e8("dijit.form._RadioButtonMixin",null,{type:"radio",_getRelatedWidgets:function(){var ary=[];_2ea("input[type=radio]",this.focusNode.form||this.ownerDocument).forEach(lang.hitch(this,function(_2ec){if(_2ec.name==this.name&&_2ec.form==this.focusNode.form){var _2ed=_2eb.getEnclosingWidget(_2ec);if(_2ed){ary.push(_2ed);}}}));return ary;},_setCheckedAttr:function(_2ee){this.inherited(arguments);if(!this._created){return;}if(_2ee){_2e7.forEach(this._getRelatedWidgets(),lang.hitch(this,function(_2ef){if(_2ef!=this&&_2ef.checked){_2ef.set("checked",false);}}));}},_getSubmitValue:function(_2f0){return _2f0==null?"on":_2f0;},_onClick:function(e){if(this.checked||this.disabled){e.stopPropagation();e.preventDefault();return false;}if(this.readOnly){e.stopPropagation();e.preventDefault();_2e7.forEach(this._getRelatedWidgets(),lang.hitch(this,function(_2f1){_2e9.set(this.focusNode||this.domNode,"checked",_2f1.checked);}));return false;}return this.inherited(arguments);}});});},"dojo/dnd/TimedMoveable":function(){define(["../_base/declare","./Moveable"],function(_2f2,_2f3){var _2f4=_2f3.prototype.onMove;return _2f2("dojo.dnd.TimedMoveable",_2f3,{timeout:40,constructor:function(node,_2f5){if(!_2f5){_2f5={};}if(_2f5.timeout&&typeof _2f5.timeout=="number"&&_2f5.timeout>=0){this.timeout=_2f5.timeout;}},onMoveStop:function(_2f6){if(_2f6._timer){clearTimeout(_2f6._timer);_2f4.call(this,_2f6,_2f6._leftTop);}_2f3.prototype.onMoveStop.apply(this,arguments);},onMove:function(_2f7,_2f8){_2f7._leftTop=_2f8;if(!_2f7._timer){var _2f9=this;_2f7._timer=setTimeout(function(){_2f7._timer=null;_2f4.call(_2f9,_2f7,_2f7._leftTop);},this.timeout);}}});});},"dijit/layout/LinkPane":function(){define(["./ContentPane","../_TemplatedMixin","dojo/_base/declare"],function(_2fa,_2fb,_2fc){return _2fc("dijit.layout.LinkPane",[_2fa,_2fb],{templateString:"<div class=\"dijitLinkPane\" data-dojo-attach-point=\"containerNode\"></div>",postMixInProperties:function(){if(this.srcNodeRef){this.title+=this.srcNodeRef.innerHTML;}this.inherited(arguments);},_fillContent:function(){}});});},"dijit/form/_ListMouseMixin":function(){define(["dojo/_base/declare","dojo/on","dojo/touch","./_ListBase"],function(_2fd,on,_2fe,_2ff){return _2fd("dijit.form._ListMouseMixin",_2ff,{postCreate:function(){this.inherited(arguments);this.domNode.dojoClick=true;this.own(on(this.domNode,"mousedown",function(evt){evt.preventDefault();}));this._listConnect("click","_onClick");this._listConnect(_2fe.press,"_onMouseDown");this._listConnect(_2fe.release,"_onMouseUp");this._listConnect(_2fe.over,"_onMouseOver");this._listConnect(_2fe.out,"_onMouseOut");},_onClick:function(evt,_300){this._setSelectedAttr(_300);if(this._deferredClick){this._deferredClick.remove();}this._deferredClick=this.defer(function(){this._deferredClick=null;this.onClick(_300);});},_onMouseDown:function(evt,_301){if(this._hoveredNode){this.onUnhover(this._hoveredNode);this._hoveredNode=null;}this._isDragging=true;this._setSelectedAttr(_301);},_onMouseUp:function(evt,_302){this._isDragging=false;var _303=this.selected;var _304=this._hoveredNode;if(_303&&_302==_303){this.defer(function(){this._onClick(evt,_303);});}else{if(_304){this.defer(function(){this._onClick(evt,_304);});}}},_onMouseOut:function(evt,_305){if(this._hoveredNode){this.onUnhover(this._hoveredNode);this._hoveredNode=null;}if(this._isDragging){this._cancelDrag=(new Date()).getTime()+1000;}},_onMouseOver:function(evt,_306){if(this._cancelDrag){var time=(new Date()).getTime();if(time>this._cancelDrag){this._isDragging=false;}this._cancelDrag=null;}this._hoveredNode=_306;this.onHover(_306);if(this._isDragging){this._setSelectedAttr(_306);}}});});},"dojo/cldr/monetary":function(){define(["../_base/kernel","../_base/lang"],function(dojo,lang){var _307={};lang.setObject("dojo.cldr.monetary",_307);_307.getData=function(code){var _308={ADP:0,AFN:0,ALL:0,AMD:0,BHD:3,BIF:0,BYR:0,CLF:0,CLP:0,COP:0,CRC:0,DJF:0,ESP:0,GNF:0,GYD:0,HUF:0,IDR:0,IQD:0,IRR:3,ISK:0,ITL:0,JOD:3,JPY:0,KMF:0,KPW:0,KRW:0,KWD:3,LAK:0,LBP:0,LUF:0,LYD:3,MGA:0,MGF:0,MMK:0,MNT:0,MRO:0,MUR:0,OMR:3,PKR:0,PYG:0,RSD:0,RWF:0,SLL:0,SOS:0,STD:0,SYP:0,TMM:0,TND:3,TRL:0,TZS:0,UGX:0,UZS:0,VND:0,VUV:0,XAF:0,XOF:0,XPF:0,YER:0,ZMK:0,ZWD:0};var _309={};var _30a=_308[code],_30b=_309[code];if(typeof _30a=="undefined"){_30a=2;}if(typeof _30b=="undefined"){_30b=0;}return {places:_30a,round:_30b};};return _307;});},"dojo/cookie":function(){define(["./_base/kernel","./regexp"],function(dojo,_30c){dojo.cookie=function(name,_30d,_30e){var c=document.cookie,ret;if(arguments.length==1){var _30f=c.match(new RegExp("(?:^|; )"+_30c.escapeString(name)+"=([^;]*)"));ret=_30f?decodeURIComponent(_30f[1]):undefined;}else{_30e=_30e||{};var exp=_30e.expires;if(typeof exp=="number"){var d=new Date();d.setTime(d.getTime()+exp*24*60*60*1000);exp=_30e.expires=d;}if(exp&&exp.toUTCString){_30e.expires=exp.toUTCString();}_30d=encodeURIComponent(_30d);var _310=name+"="+_30d,_311;for(_311 in _30e){_310+="; "+_311;var _312=_30e[_311];if(_312!==true){_310+="="+_312;}}document.cookie=_310;}return ret;};dojo.cookie.isSupported=function(){if(!("cookieEnabled" in navigator)){this("__djCookieTest__","CookiesAllowed");navigator.cookieEnabled=this("__djCookieTest__")=="CookiesAllowed";if(navigator.cookieEnabled){this("__djCookieTest__","",{expires:-1});}}return navigator.cookieEnabled;};return dojo.cookie;});},"dijit/ProgressBar":function(){define(["require","dojo/_base/declare","dojo/dom-class","dojo/_base/lang","dojo/number","./_Widget","./_TemplatedMixin","dojo/text!./templates/ProgressBar.html"],function(_313,_314,_315,lang,_316,_317,_318,_319){return _314("dijit.ProgressBar",[_317,_318],{progress:"0",value:"",maximum:100,places:0,indeterminate:false,label:"",name:"",templateString:_319,_indeterminateHighContrastImagePath:_313.toUrl("./themes/a11y/indeterminate_progress.gif"),postMixInProperties:function(){this.inherited(arguments);if(!(this.params&&"value" in this.params)){this.value=this.indeterminate?Infinity:this.progress;}},buildRendering:function(){this.inherited(arguments);this.indeterminateHighContrastImage.setAttribute("src",this._indeterminateHighContrastImagePath.toString());this.update();},_setDirAttr:function(val){_315.toggle(this.domNode,"dijitProgressBarRtl",val=="rtl");this.inherited(arguments);},update:function(_31a){lang.mixin(this,_31a||{});var tip=this.internalProgress,ap=this.domNode;var _31b=1;if(this.indeterminate){ap.removeAttribute("aria-valuenow");}else{if(String(this.progress).indexOf("%")!=-1){_31b=Math.min(parseFloat(this.progress)/100,1);this.progress=_31b*this.maximum;}else{this.progress=Math.min(this.progress,this.maximum);_31b=this.maximum?this.progress/this.maximum:0;}ap.setAttribute("aria-valuenow",this.progress);}ap.setAttribute("aria-labelledby",this.labelNode.id);ap.setAttribute("aria-valuemin",0);ap.setAttribute("aria-valuemax",this.maximum);this.labelNode.innerHTML=this.report(_31b);_315.toggle(this.domNode,"dijitProgressBarIndeterminate",this.indeterminate);tip.style.width=(_31b*100)+"%";this.onChange();},_setValueAttr:function(v){this._set("value",v);if(v==Infinity){this.update({indeterminate:true});}else{this.update({indeterminate:false,progress:v});}},_setLabelAttr:function(_31c){this._set("label",_31c);this.update();},_setIndeterminateAttr:function(_31d){this._set("indeterminate",_31d);this.update();},report:function(_31e){return this.label?this.label:(this.indeterminate?"&#160;":_316.format(_31e,{type:"percent",places:this.places,locale:this.lang}));},onChange:function(){}});});},"dijit/form/NumberTextBox":function(){define(["dojo/_base/declare","dojo/_base/lang","dojo/number","./RangeBoundTextBox"],function(_31f,lang,_320,_321){var _322=_31f("dijit.form.NumberTextBoxMixin",null,{pattern:function(_323){return "("+(this.focused&&this.editOptions?this._regExpGenerator(lang.delegate(_323,this.editOptions))+"|":"")+this._regExpGenerator(_323)+")";},value:NaN,editOptions:{pattern:"#.######"},_formatter:_320.format,_regExpGenerator:_320.regexp,postMixInProperties:function(){this.inherited(arguments);this._set("type","text");},_setConstraintsAttr:function(_324){var _325=typeof _324.places=="number"?_324.places:0;if(_325){_325++;}if(typeof _324.max!="number"){_324.max=9*Math.pow(10,15-_325);}if(typeof _324.min!="number"){_324.min=-9*Math.pow(10,15-_325);}this.inherited(arguments,[_324]);if(this.focusNode&&this.focusNode.value&&!isNaN(this.value)){this.set("value",this.value);}},_onFocus:function(){if(this.disabled){return;}var val=this.get("value");if(typeof val=="number"&&!isNaN(val)){var _326=this.format(val,this.constraints);if(_326!==undefined){this.textbox.value=_326;}}this.inherited(arguments);},format:function(_327,_328){var _329=String(_327);if(typeof _327!="number"){return _329;}if(isNaN(_327)){return "";}if(!("rangeCheck" in this&&this.rangeCheck(_327,_328))&&_328.exponent!==false&&/\de[-+]?\d/i.test(_329)){return _329;}if(this.editOptions&&this.focused){_328=lang.mixin({},_328,this.editOptions);}return this._formatter(_327,_328);},_parser:_320.parse,parse:function(_32a,_32b){var v=this._parser(_32a,lang.mixin({},_32b,(this.editOptions&&this.focused)?this.editOptions:{}));if(this.editOptions&&this.focused&&isNaN(v)){v=this._parser(_32a,_32b);}return v;},_getDisplayedValueAttr:function(){var v=this.inherited(arguments);return isNaN(v)?this.textbox.value:v;},filter:function(_32c){return (_32c==null||_32c==="")?NaN:this.inherited(arguments);},serialize:function(_32d,_32e){return (typeof _32d!="number"||isNaN(_32d))?"":this.inherited(arguments);},_setBlurValue:function(){var val=lang.hitch(lang.delegate(this,{focused:true}),"get")("value");this._setValueAttr(val,true);},_setValueAttr:function(_32f,_330,_331){if(_32f!==undefined&&_331===undefined){_331=String(_32f);if(typeof _32f=="number"){if(isNaN(_32f)){_331="";}else{if(("rangeCheck" in this&&this.rangeCheck(_32f,this.constraints))||this.constraints.exponent===false||!/\de[-+]?\d/i.test(_331)){_331=undefined;}}}else{if(!_32f){_331="";_32f=NaN;}else{_32f=undefined;}}}this.inherited(arguments,[_32f,_330,_331]);},_getValueAttr:function(){var v=this.inherited(arguments);if(isNaN(v)&&this.textbox.value!==""){if(this.constraints.exponent!==false&&/\de[-+]?\d/i.test(this.textbox.value)&&(new RegExp("^"+_320._realNumberRegexp(lang.delegate(this.constraints))+"$").test(this.textbox.value))){var n=Number(this.textbox.value);return isNaN(n)?undefined:n;}else{return undefined;}}else{return v;}},isValid:function(_332){if(!this.focused||this._isEmpty(this.textbox.value)){return this.inherited(arguments);}else{var v=this.get("value");if(!isNaN(v)&&this.rangeCheck(v,this.constraints)){if(this.constraints.exponent!==false&&/\de[-+]?\d/i.test(this.textbox.value)){return true;}else{return this.inherited(arguments);}}else{return false;}}}});var _333=_31f("dijit.form.NumberTextBox",[_321,_322],{baseClass:"dijitTextBox dijitNumberTextBox"});_333.Mixin=_322;return _333;});},"dijit/form/TimeTextBox":function(){define(["dojo/_base/declare","dojo/keys","dojo/_base/lang","../_TimePicker","./_DateTimeTextBox"],function(_334,keys,lang,_335,_336){return _334("dijit.form.TimeTextBox",_336,{baseClass:"dijitTextBox dijitComboBox dijitTimeTextBox",popupClass:_335,_selector:"time",value:new Date(""),maxHeight:-1,_onKey:function(evt){if(this.disabled||this.readOnly){return;}this.inherited(arguments);switch(evt.keyCode){case keys.ENTER:case keys.TAB:case keys.ESCAPE:case keys.DOWN_ARROW:case keys.UP_ARROW:break;default:this.defer(function(){var val=this.get("displayedValue");this.filterString=(val&&!this.parse(val,this.constraints))?val.toLowerCase():"";if(this._opened){this.closeDropDown();}this.openDropDown();});}}});});},"dijit/ColorPalette":function(){define(["require","dojo/text!./templates/ColorPalette.html","./_Widget","./_TemplatedMixin","./_PaletteMixin","./hccss","dojo/i18n","dojo/_base/Color","dojo/_base/declare","dojo/dom-construct","dojo/string","dojo/i18n!dojo/nls/colors","dojo/colors"],function(_337,_338,_339,_33a,_33b,has,i18n,_33c,_33d,_33e,_33f){var _340=_33d("dijit.ColorPalette",[_339,_33a,_33b],{palette:"7x10",_palettes:{"7x10":[["white","seashell","cornsilk","lemonchiffon","lightyellow","palegreen","paleturquoise","lightcyan","lavender","plum"],["lightgray","pink","bisque","moccasin","khaki","lightgreen","lightseagreen","lightskyblue","cornflowerblue","violet"],["silver","lightcoral","sandybrown","orange","palegoldenrod","chartreuse","mediumturquoise","skyblue","mediumslateblue","orchid"],["gray","red","orangered","darkorange","yellow","limegreen","darkseagreen","royalblue","slateblue","mediumorchid"],["dimgray","crimson","chocolate","coral","gold","forestgreen","seagreen","blue","blueviolet","darkorchid"],["darkslategray","firebrick","saddlebrown","sienna","olive","green","darkcyan","mediumblue","darkslateblue","darkmagenta"],["black","darkred","maroon","brown","darkolivegreen","darkgreen","midnightblue","navy","indigo","purple"]],"3x4":[["white","lime","green","blue"],["silver","yellow","fuchsia","navy"],["gray","red","purple","black"]]},templateString:_338,baseClass:"dijitColorPalette",_dyeFactory:function(_341,row,col,_342){return new this._dyeClass(_341,row,col,_342);},buildRendering:function(){this.inherited(arguments);this._dyeClass=_33d(_340._Color,{palette:this.palette});this._preparePalette(this._palettes[this.palette],i18n.getLocalization("dojo","colors",this.lang));}});_340._Color=_33d("dijit._Color",_33c,{template:"<span class='dijitInline dijitPaletteImg'>"+"<img src='${blankGif}' alt='${alt}' title='${title}' class='dijitColorPaletteSwatch' style='background-color: ${color}'/>"+"</span>",hcTemplate:"<span class='dijitInline dijitPaletteImg' style='position: relative; overflow: hidden; height: 12px; width: 14px;'>"+"<img src='${image}' alt='${alt}' title='${title}' style='position: absolute; left: ${left}px; top: ${top}px; ${size}'/>"+"</span>",_imagePaths:{"7x10":_337.toUrl("./themes/a11y/colors7x10.png"),"3x4":_337.toUrl("./themes/a11y/colors3x4.png")},constructor:function(_343,row,col,_344){this._title=_344;this._row=row;this._col=col;this.setColor(_33c.named[_343]);},getValue:function(){return this.toHex();},fillCell:function(cell,_345){var html=_33f.substitute(has("highcontrast")?this.hcTemplate:this.template,{color:this.toHex(),blankGif:_345,alt:this._title,title:this._title,image:this._imagePaths[this.palette].toString(),left:this._col*-20-5,top:this._row*-20-5,size:this.palette=="7x10"?"height: 145px; width: 206px":"height: 64px; width: 86px"});_33e.place(html,cell);}});return _340;});},"dijit/form/CurrencyTextBox":function(){define(["dojo/currency","dojo/_base/declare","dojo/_base/lang","./NumberTextBox"],function(_346,_347,lang,_348){return _347("dijit.form.CurrencyTextBox",_348,{currency:"",baseClass:"dijitTextBox dijitCurrencyTextBox",_formatter:_346.format,_parser:_346.parse,_regExpGenerator:_346.regexp,parse:function(_349,_34a){var v=this.inherited(arguments);if(isNaN(v)&&/\d+/.test(_349)){v=lang.hitch(lang.delegate(this,{_parser:_348.prototype._parser}),"inherited")(arguments);}return v;},_setConstraintsAttr:function(_34b){if(!_34b.currency&&this.currency){_34b.currency=this.currency;}this.inherited(arguments,[_346._mixInDefaults(lang.mixin(_34b,{exponent:false}))]);}});});},"dijit/layout/LayoutContainer":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-class","dojo/dom-style","dojo/_base/lang","../_WidgetBase","./_LayoutWidget","./utils"],function(_34c,_34d,_34e,_34f,lang,_350,_351,_352){var _353=_34d("dijit.layout.LayoutContainer",_351,{design:"headline",baseClass:"dijitLayoutContainer",startup:function(){if(this._started){return;}_34c.forEach(this.getChildren(),this._setupChild,this);this.inherited(arguments);},_setupChild:function(_354){this.inherited(arguments);var _355=_354.region;if(_355){_34e.add(_354.domNode,this.baseClass+"Pane");}},_getOrderedChildren:function(){var _356=_34c.map(this.getChildren(),function(_357,idx){return {pane:_357,weight:[_357.region=="center"?Infinity:0,_357.layoutPriority,(this.design=="sidebar"?1:-1)*(/top|bottom/.test(_357.region)?1:-1),idx]};},this);_356.sort(function(a,b){var aw=a.weight,bw=b.weight;for(var i=0;i<aw.length;i++){if(aw[i]!=bw[i]){return aw[i]-bw[i];}}return 0;});return _34c.map(_356,function(w){return w.pane;});},layout:function(){_352.layoutChildren(this.domNode,this._contentBox,this._getOrderedChildren());},addChild:function(_358,_359){this.inherited(arguments);if(this._started){this.layout();}},removeChild:function(_35a){this.inherited(arguments);if(this._started){this.layout();}_34e.remove(_35a.domNode,this.baseClass+"Pane");_34f.set(_35a.domNode,{top:"auto",bottom:"auto",left:"auto",right:"auto",position:"static"});_34f.set(_35a.domNode,/top|bottom/.test(_35a.region)?"width":"height","auto");}});_353.ChildWidgetProperties={region:"",layoutAlign:"",layoutPriority:0};lang.extend(_350,_353.ChildWidgetProperties);return _353;});},"dijit/Tooltip":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/_base/fx","dojo/dom","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/lang","dojo/mouse","dojo/on","dojo/sniff","./_base/manager","./place","./_Widget","./_TemplatedMixin","./BackgroundIframe","dojo/text!./templates/Tooltip.html","./main"],function(_35b,_35c,fx,dom,_35d,_35e,_35f,lang,_360,on,has,_361,_362,_363,_364,_365,_366,_367){var _368=_35c("dijit._MasterTooltip",[_363,_364],{duration:_361.defaultDuration,templateString:_366,postCreate:function(){this.ownerDocumentBody.appendChild(this.domNode);this.bgIframe=new _365(this.domNode);this.fadeIn=fx.fadeIn({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,"_onShow")});this.fadeOut=fx.fadeOut({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,"_onHide")});},show:function(_369,_36a,_36b,rtl,_36c){if(this.aroundNode&&this.aroundNode===_36a&&this.containerNode.innerHTML==_369){return;}if(this.fadeOut.status()=="playing"){this._onDeck=arguments;return;}this.containerNode.innerHTML=_369;if(_36c){this.set("textDir",_36c);}this.containerNode.align=rtl?"right":"left";var pos=_362.around(this.domNode,_36a,_36b&&_36b.length?_36b:_36d.defaultPosition,!rtl,lang.hitch(this,"orient"));var _36e=pos.aroundNodePos;if(pos.corner.charAt(0)=="M"&&pos.aroundCorner.charAt(0)=="M"){this.connectorNode.style.top=_36e.y+((_36e.h-this.connectorNode.offsetHeight)>>1)-pos.y+"px";this.connectorNode.style.left="";}else{if(pos.corner.charAt(1)=="M"&&pos.aroundCorner.charAt(1)=="M"){this.connectorNode.style.left=_36e.x+((_36e.w-this.connectorNode.offsetWidth)>>1)-pos.x+"px";}else{this.connectorNode.style.left="";this.connectorNode.style.top="";}}_35f.set(this.domNode,"opacity",0);this.fadeIn.play();this.isShowingNow=true;this.aroundNode=_36a;},orient:function(node,_36f,_370,_371,_372){this.connectorNode.style.top="";var _373=_371.h,_374=_371.w;node.className="dijitTooltip "+{"MR-ML":"dijitTooltipRight","ML-MR":"dijitTooltipLeft","TM-BM":"dijitTooltipAbove","BM-TM":"dijitTooltipBelow","BL-TL":"dijitTooltipBelow dijitTooltipABLeft","TL-BL":"dijitTooltipAbove dijitTooltipABLeft","BR-TR":"dijitTooltipBelow dijitTooltipABRight","TR-BR":"dijitTooltipAbove dijitTooltipABRight","BR-BL":"dijitTooltipRight","BL-BR":"dijitTooltipLeft"}[_36f+"-"+_370];this.domNode.style.width="auto";var size=_35e.position(this.domNode);if(has("ie")==9){size.w+=2;}var _375=Math.min((Math.max(_374,1)),size.w);_35e.setMarginBox(this.domNode,{w:_375});if(_370.charAt(0)=="B"&&_36f.charAt(0)=="B"){var bb=_35e.position(node);var _376=this.connectorNode.offsetHeight;if(bb.h>_373){var _377=_373-((_372.h+_376)>>1);this.connectorNode.style.top=_377+"px";this.connectorNode.style.bottom="";}else{this.connectorNode.style.bottom=Math.min(Math.max(_372.h/2-_376/2,0),bb.h-_376)+"px";this.connectorNode.style.top="";}}else{this.connectorNode.style.top="";this.connectorNode.style.bottom="";}return Math.max(0,size.w-_374);},_onShow:function(){if(has("ie")){this.domNode.style.filter="";}},hide:function(_378){if(this._onDeck&&this._onDeck[1]==_378){this._onDeck=null;}else{if(this.aroundNode===_378){this.fadeIn.stop();this.isShowingNow=false;this.aroundNode=null;this.fadeOut.play();}else{}}},_onHide:function(){this.domNode.style.cssText="";this.containerNode.innerHTML="";if(this._onDeck){this.show.apply(this,this._onDeck);this._onDeck=null;}}});if(has("dojo-bidi")){_368.extend({_setAutoTextDir:function(node){this.applyTextDir(node);_35b.forEach(node.children,function(_379){this._setAutoTextDir(_379);},this);},_setTextDirAttr:function(_37a){this._set("textDir",_37a);if(_37a=="auto"){this._setAutoTextDir(this.containerNode);}else{this.containerNode.dir=this.textDir;}}});}_367.showTooltip=function(_37b,_37c,_37d,rtl,_37e){if(_37d){_37d=_35b.map(_37d,function(val){return {after:"after-centered",before:"before-centered"}[val]||val;});}if(!_36d._masterTT){_367._masterTT=_36d._masterTT=new _368();}return _36d._masterTT.show(_37b,_37c,_37d,rtl,_37e);};_367.hideTooltip=function(_37f){return _36d._masterTT&&_36d._masterTT.hide(_37f);};var _36d=_35c("dijit.Tooltip",_363,{label:"",showDelay:400,connectId:[],position:[],selector:"",_setConnectIdAttr:function(_380){_35b.forEach(this._connections||[],function(_381){_35b.forEach(_381,function(_382){_382.remove();});},this);this._connectIds=_35b.filter(lang.isArrayLike(_380)?_380:(_380?[_380]:[]),function(id){return dom.byId(id,this.ownerDocument);},this);this._connections=_35b.map(this._connectIds,function(id){var node=dom.byId(id,this.ownerDocument),_383=this.selector,_384=_383?function(_385){return on.selector(_383,_385);}:function(_386){return _386;},self=this;return [on(node,_384(_360.enter),function(){self._onHover(this);}),on(node,_384("focusin"),function(){self._onHover(this);}),on(node,_384(_360.leave),lang.hitch(self,"_onUnHover")),on(node,_384("focusout"),lang.hitch(self,"_onUnHover"))];},this);this._set("connectId",_380);},addTarget:function(node){var id=node.id||node;if(_35b.indexOf(this._connectIds,id)==-1){this.set("connectId",this._connectIds.concat(id));}},removeTarget:function(node){var id=node.id||node,idx=_35b.indexOf(this._connectIds,id);if(idx>=0){this._connectIds.splice(idx,1);this.set("connectId",this._connectIds);}},buildRendering:function(){this.inherited(arguments);_35d.add(this.domNode,"dijitTooltipData");},startup:function(){this.inherited(arguments);var ids=this.connectId;_35b.forEach(lang.isArrayLike(ids)?ids:[ids],this.addTarget,this);},getContent:function(node){return this.label||this.domNode.innerHTML;},_onHover:function(_387){if(!this._showTimer){this._showTimer=this.defer(function(){this.open(_387);},this.showDelay);}},_onUnHover:function(){if(this._showTimer){this._showTimer.remove();delete this._showTimer;}this.close();},open:function(_388){if(this._showTimer){this._showTimer.remove();delete this._showTimer;}var _389=this.getContent(_388);if(!_389){return;}_36d.show(_389,_388,this.position,!this.isLeftToRight(),this.textDir);this._connectNode=_388;this.onShow(_388,this.position);},close:function(){if(this._connectNode){_36d.hide(this._connectNode);delete this._connectNode;this.onHide();}if(this._showTimer){this._showTimer.remove();delete this._showTimer;}},onShow:function(){},onHide:function(){},destroy:function(){this.close();_35b.forEach(this._connections||[],function(_38a){_35b.forEach(_38a,function(_38b){_38b.remove();});},this);this.inherited(arguments);}});_36d._MasterTooltip=_368;_36d.show=_367.showTooltip;_36d.hide=_367.hideTooltip;_36d.defaultPosition=["after-centered","before-centered"];return _36d;});},"dijit/form/VerticalSlider":function(){define(["dojo/_base/declare","./HorizontalSlider","dojo/text!./templates/VerticalSlider.html"],function(_38c,_38d,_38e){return _38c("dijit.form.VerticalSlider",_38d,{templateString:_38e,_mousePixelCoord:"pageY",_pixelCount:"h",_startingPixelCoord:"y",_handleOffsetCoord:"top",_progressPixelSize:"height",_descending:true,_isReversed:function(){return this._descending;}});});},"dijit/form/DropDownButton":function(){define(["dojo/_base/declare","dojo/_base/lang","dojo/query","../registry","../popup","./Button","../_Container","../_HasDropDown","dojo/text!./templates/DropDownButton.html"],function(_38f,lang,_390,_391,_392,_393,_394,_395,_396){return _38f("dijit.form.DropDownButton",[_393,_394,_395],{baseClass:"dijitDropDownButton",templateString:_396,_fillContent:function(){if(this.srcNodeRef){var _397=_390("*",this.srcNodeRef);this.inherited(arguments,[_397[0]]);this.dropDownContainer=this.srcNodeRef;}},startup:function(){if(this._started){return;}if(!this.dropDown&&this.dropDownContainer){var _398=_390("[widgetId]",this.dropDownContainer)[0];if(_398){this.dropDown=_391.byNode(_398);}delete this.dropDownContainer;}if(this.dropDown){_392.hide(this.dropDown);}this.inherited(arguments);},isLoaded:function(){var _399=this.dropDown;return (!!_399&&(!_399.href||_399.isLoaded));},loadDropDown:function(_39a){var _39b=this.dropDown;var _39c=_39b.on("load",lang.hitch(this,function(){_39c.remove();_39a();}));_39b.refresh();},isFocusable:function(){return this.inherited(arguments)&&!this._mouseDown;}});});},"dojo/date":function(){define(["./has","./_base/lang"],function(has,lang){var date={};date.getDaysInMonth=function(_39d){var _39e=_39d.getMonth();var days=[31,28,31,30,31,30,31,31,30,31,30,31];if(_39e==1&&date.isLeapYear(_39d)){return 29;}return days[_39e];};date.isLeapYear=function(_39f){var year=_39f.getFullYear();return !(year%400)||(!(year%4)&&!!(year%100));};date.getTimezoneName=function(_3a0){var str=_3a0.toString();var tz="";var _3a1;var pos=str.indexOf("(");if(pos>-1){tz=str.substring(++pos,str.indexOf(")"));}else{var pat=/([A-Z\/]+) \d{4}$/;if((_3a1=str.match(pat))){tz=_3a1[1];}else{str=_3a0.toLocaleString();pat=/ ([A-Z\/]+)$/;if((_3a1=str.match(pat))){tz=_3a1[1];}}}return (tz=="AM"||tz=="PM")?"":tz;};date.compare=function(_3a2,_3a3,_3a4){_3a2=new Date(+_3a2);_3a3=new Date(+(_3a3||new Date()));if(_3a4=="date"){_3a2.setHours(0,0,0,0);_3a3.setHours(0,0,0,0);}else{if(_3a4=="time"){_3a2.setFullYear(0,0,0);_3a3.setFullYear(0,0,0);}}if(_3a2>_3a3){return 1;}if(_3a2<_3a3){return -1;}return 0;};date.add=function(date,_3a5,_3a6){var sum=new Date(+date);var _3a7=false;var _3a8="Date";switch(_3a5){case "day":break;case "weekday":var days,_3a9;var mod=_3a6%5;if(!mod){days=(_3a6>0)?5:-5;_3a9=(_3a6>0)?((_3a6-5)/5):((_3a6+5)/5);}else{days=mod;_3a9=parseInt(_3a6/5);}var strt=date.getDay();var adj=0;if(strt==6&&_3a6>0){adj=1;}else{if(strt==0&&_3a6<0){adj=-1;}}var trgt=strt+days;if(trgt==0||trgt==6){adj=(_3a6>0)?2:-2;}_3a6=(7*_3a9)+days+adj;break;case "year":_3a8="FullYear";_3a7=true;break;case "week":_3a6*=7;break;case "quarter":_3a6*=3;case "month":_3a7=true;_3a8="Month";break;default:_3a8="UTC"+_3a5.charAt(0).toUpperCase()+_3a5.substring(1)+"s";}if(_3a8){sum["set"+_3a8](sum["get"+_3a8]()+_3a6);}if(_3a7&&(sum.getDate()<date.getDate())){sum.setDate(0);}return sum;};date.difference=function(_3aa,_3ab,_3ac){_3ab=_3ab||new Date();_3ac=_3ac||"day";var _3ad=_3ab.getFullYear()-_3aa.getFullYear();var _3ae=1;switch(_3ac){case "quarter":var m1=_3aa.getMonth();var m2=_3ab.getMonth();var q1=Math.floor(m1/3)+1;var q2=Math.floor(m2/3)+1;q2+=(_3ad*4);_3ae=q2-q1;break;case "weekday":var days=Math.round(date.difference(_3aa,_3ab,"day"));var _3af=parseInt(date.difference(_3aa,_3ab,"week"));var mod=days%7;if(mod==0){days=_3af*5;}else{var adj=0;var aDay=_3aa.getDay();var bDay=_3ab.getDay();_3af=parseInt(days/7);mod=days%7;var _3b0=new Date(_3aa);_3b0.setDate(_3b0.getDate()+(_3af*7));var _3b1=_3b0.getDay();if(days>0){switch(true){case aDay==6:adj=-1;break;case aDay==0:adj=0;break;case bDay==6:adj=-1;break;case bDay==0:adj=-2;break;case (_3b1+mod)>5:adj=-2;}}else{if(days<0){switch(true){case aDay==6:adj=0;break;case aDay==0:adj=1;break;case bDay==6:adj=2;break;case bDay==0:adj=1;break;case (_3b1+mod)<0:adj=2;}}}days+=adj;days-=(_3af*2);}_3ae=days;break;case "year":_3ae=_3ad;break;case "month":_3ae=(_3ab.getMonth()-_3aa.getMonth())+(_3ad*12);break;case "week":_3ae=parseInt(date.difference(_3aa,_3ab,"day")/7);break;case "day":_3ae/=24;case "hour":_3ae/=60;case "minute":_3ae/=60;case "second":_3ae/=1000;case "millisecond":_3ae*=_3ab.getTime()-_3aa.getTime();}return Math.round(_3ae);};1&&lang.mixin(lang.getObject("dojo.date",true),date);return date;});},"dijit/layout/_ContentPaneResizeMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/lang","dojo/query","dojo/sniff","../registry","../Viewport","./utils"],function(_3b2,_3b3,_3b4,_3b5,_3b6,lang,_3b7,has,_3b8,_3b9,_3ba){return _3b3("dijit.layout._ContentPaneResizeMixin",null,{doLayout:true,isLayoutContainer:true,startup:function(){if(this._started){return;}var _3bb=this.getParent();this._childOfLayoutWidget=_3bb&&_3bb.isLayoutContainer;this._needLayout=!this._childOfLayoutWidget;this.inherited(arguments);if(this._isShown()){this._onShow();}if(!this._childOfLayoutWidget){this.own(_3b9.on("resize",lang.hitch(this,"resize")));}},_checkIfSingleChild:function(){var _3bc=[],_3bd=false;_3b7("> *",this.containerNode).some(function(node){var _3be=_3b8.byNode(node);if(_3be&&_3be.resize){_3bc.push(_3be);}else{if(!/script|link|style/i.test(node.nodeName)&&node.offsetHeight){_3bd=true;}}});this._singleChild=_3bc.length==1&&!_3bd?_3bc[0]:null;_3b4.toggle(this.containerNode,this.baseClass+"SingleChild",!!this._singleChild);},resize:function(_3bf,_3c0){this._resizeCalled=true;this._scheduleLayout(_3bf,_3c0);},_scheduleLayout:function(_3c1,_3c2){if(this._isShown()){this._layout(_3c1,_3c2);}else{this._needLayout=true;this._changeSize=_3c1;this._resultSize=_3c2;}},_layout:function(_3c3,_3c4){delete this._needLayout;if(!this._wasShown&&this.open!==false){this._onShow();}if(_3c3){_3b5.setMarginBox(this.domNode,_3c3);}var cn=this.containerNode;if(cn===this.domNode){var mb=_3c4||{};lang.mixin(mb,_3c3||{});if(!("h" in mb)||!("w" in mb)){mb=lang.mixin(_3b5.getMarginBox(cn),mb);}this._contentBox=_3ba.marginBox2contentBox(cn,mb);}else{this._contentBox=_3b5.getContentBox(cn);}this._layoutChildren();},_layoutChildren:function(){if(this.doLayout){this._checkIfSingleChild();}if(this._singleChild&&this._singleChild.resize){var cb=this._contentBox||_3b5.getContentBox(this.containerNode);this._singleChild.resize({w:cb.w,h:cb.h});}else{var _3c5=this.getChildren(),_3c6,i=0;while(_3c6=_3c5[i++]){if(_3c6.resize){_3c6.resize();}}}},_isShown:function(){if(this._childOfLayoutWidget){if(this._resizeCalled&&"open" in this){return this.open;}return this._resizeCalled;}else{if("open" in this){return this.open;}else{var node=this.domNode,_3c7=this.domNode.parentNode;return (node.style.display!="none")&&(node.style.visibility!="hidden")&&!_3b4.contains(node,"dijitHidden")&&_3c7&&_3c7.style&&(_3c7.style.display!="none");}}},_onShow:function(){this._wasShown=true;if(this._needLayout){this._layout(this._changeSize,this._resultSize);}this.inherited(arguments);}});});},"dijit/form/RangeBoundTextBox":function(){define(["dojo/_base/declare","dojo/i18n","./MappedTextBox"],function(_3c8,i18n,_3c9){var _3ca=_3c8("dijit.form.RangeBoundTextBox",_3c9,{rangeMessage:"",rangeCheck:function(_3cb,_3cc){return ("min" in _3cc?(this.compare(_3cb,_3cc.min)>=0):true)&&("max" in _3cc?(this.compare(_3cb,_3cc.max)<=0):true);},isInRange:function(){return this.rangeCheck(this.get("value"),this.constraints);},_isDefinitelyOutOfRange:function(){var val=this.get("value");if(val==null){return false;}var _3cd=false;if("min" in this.constraints){var min=this.constraints.min;_3cd=this.compare(val,((typeof min=="number")&&min>=0&&val!=0)?0:min)<0;}if(!_3cd&&("max" in this.constraints)){var max=this.constraints.max;_3cd=this.compare(val,((typeof max!="number")||max>0)?max:0)>0;}return _3cd;},_isValidSubset:function(){return this.inherited(arguments)&&!this._isDefinitelyOutOfRange();},isValid:function(_3ce){return this.inherited(arguments)&&((this._isEmpty(this.textbox.value)&&!this.required)||this.isInRange(_3ce));},getErrorMessage:function(_3cf){var v=this.get("value");if(v!=null&&v!==""&&(typeof v!="number"||!isNaN(v))&&!this.isInRange(_3cf)){return this.rangeMessage;}return this.inherited(arguments);},postMixInProperties:function(){this.inherited(arguments);if(!this.rangeMessage){this.messages=i18n.getLocalization("dijit.form","validate",this.lang);this.rangeMessage=this.messages.rangeMessage;}}});return _3ca;});},"dijit/_editor/RichText":function(){define(["dojo/_base/array","dojo/_base/config","dojo/_base/declare","dojo/_base/Deferred","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/on","dojo/query","dojo/domReady","dojo/sniff","dojo/topic","dojo/_base/unload","dojo/_base/url","dojo/window","../_Widget","../_CssStateMixin","../selection","./range","./html","../focus","../main"],function(_3d0,_3d1,_3d2,_3d3,dom,_3d4,_3d5,_3d6,_3d7,_3d8,_3d9,keys,lang,on,_3da,_3db,has,_3dc,_3dd,_3de,_3df,_3e0,_3e1,_3e2,_3e3,_3e4,_3e5,_3e6){var _3e7=_3d2("dijit._editor.RichText",[_3e0,_3e1],{constructor:function(_3e8){this.contentPreFilters=[];this.contentPostFilters=[];this.contentDomPreFilters=[];this.contentDomPostFilters=[];this.editingAreaStyleSheets=[];this.events=[].concat(this.events);this._keyHandlers={};if(_3e8&&lang.isString(_3e8.value)){this.value=_3e8.value;}this.onLoadDeferred=new _3d3();},baseClass:"dijitEditor",inheritWidth:false,focusOnLoad:false,name:"",styleSheets:"",height:"300px",minHeight:"1em",isClosed:true,isLoaded:false,_SEPARATOR:"@@**%%__RICHTEXTBOUNDRY__%%**@@",_NAME_CONTENT_SEP:"@@**%%:%%**@@",onLoadDeferred:null,isTabIndent:false,disableSpellCheck:false,postCreate:function(){if("textarea"===this.domNode.tagName.toLowerCase()){console.warn("RichText should not be used with the TEXTAREA tag.  See dijit._editor.RichText docs.");}this.contentPreFilters=[lang.hitch(this,"_preFixUrlAttributes")].concat(this.contentPreFilters);if(has("mozilla")){this.contentPreFilters=[this._normalizeFontStyle].concat(this.contentPreFilters);this.contentPostFilters=[this._removeMozBogus].concat(this.contentPostFilters);}if(has("webkit")){this.contentPreFilters=[this._removeWebkitBogus].concat(this.contentPreFilters);this.contentPostFilters=[this._removeWebkitBogus].concat(this.contentPostFilters);}if(has("ie")){this.contentPostFilters=[this._normalizeFontStyle].concat(this.contentPostFilters);this.contentDomPostFilters=[lang.hitch(this,this._stripBreakerNodes)].concat(this.contentDomPostFilters);}this.inherited(arguments);_3dc.publish(_3e6._scopeName+"._editor.RichText::init",this);},startup:function(){this.inherited(arguments);this.open();this.setupDefaultShortcuts();},setupDefaultShortcuts:function(){var exec=lang.hitch(this,function(cmd,arg){return function(){return !this.execCommand(cmd,arg);};});var _3e9={b:exec("bold"),i:exec("italic"),u:exec("underline"),a:exec("selectall"),s:function(){this.save(true);},m:function(){this.isTabIndent=!this.isTabIndent;},"1":exec("formatblock","h1"),"2":exec("formatblock","h2"),"3":exec("formatblock","h3"),"4":exec("formatblock","h4"),"\\":exec("insertunorderedlist")};if(!has("ie")){_3e9.Z=exec("redo");}var key;for(key in _3e9){this.addKeyHandler(key,true,false,_3e9[key]);}},events:["onKeyDown","onKeyUp"],captureEvents:[],_editorCommandsLocalized:false,_localizeEditorCommands:function(){if(_3e7._editorCommandsLocalized){this._local2NativeFormatNames=_3e7._local2NativeFormatNames;this._native2LocalFormatNames=_3e7._native2LocalFormatNames;return;}_3e7._editorCommandsLocalized=true;_3e7._local2NativeFormatNames={};_3e7._native2LocalFormatNames={};this._local2NativeFormatNames=_3e7._local2NativeFormatNames;this._native2LocalFormatNames=_3e7._native2LocalFormatNames;var _3ea=["div","p","pre","h1","h2","h3","h4","h5","h6","ol","ul","address"];var _3eb="",_3ec,i=0;while((_3ec=_3ea[i++])){if(_3ec.charAt(1)!=="l"){_3eb+="<"+_3ec+"><span>content</span></"+_3ec+"><br/>";}else{_3eb+="<"+_3ec+"><li>content</li></"+_3ec+"><br/>";}}var _3ed={position:"absolute",top:"0px",zIndex:10,opacity:0.01};var div=_3d6.create("div",{style:_3ed,innerHTML:_3eb});this.ownerDocumentBody.appendChild(div);var _3ee=lang.hitch(this,function(){var node=div.firstChild;while(node){try{this.selection.selectElement(node.firstChild);var _3ef=node.tagName.toLowerCase();this._local2NativeFormatNames[_3ef]=document.queryCommandValue("formatblock");this._native2LocalFormatNames[this._local2NativeFormatNames[_3ef]]=_3ef;node=node.nextSibling.nextSibling;}catch(e){}}_3d6.destroy(div);});this.defer(_3ee);},open:function(_3f0){if(!this.onLoadDeferred||this.onLoadDeferred.fired>=0){this.onLoadDeferred=new _3d3();}if(!this.isClosed){this.close();}_3dc.publish(_3e6._scopeName+"._editor.RichText::open",this);if(arguments.length===1&&_3f0.nodeName){this.domNode=_3f0;}var dn=this.domNode;var html;if(lang.isString(this.value)){html=this.value;delete this.value;dn.innerHTML="";}else{if(dn.nodeName&&dn.nodeName.toLowerCase()=="textarea"){var ta=(this.textarea=dn);this.name=ta.name;html=ta.value;dn=this.domNode=this.ownerDocument.createElement("div");dn.setAttribute("widgetId",this.id);ta.removeAttribute("widgetId");dn.cssText=ta.cssText;dn.className+=" "+ta.className;_3d6.place(dn,ta,"before");var _3f1=lang.hitch(this,function(){_3d8.set(ta,{display:"block",position:"absolute",top:"-1000px"});if(has("ie")){var s=ta.style;this.__overflow=s.overflow;s.overflow="hidden";}});if(has("ie")){this.defer(_3f1,10);}else{_3f1();}if(ta.form){var _3f2=ta.value;this.reset=function(){var _3f3=this.getValue();if(_3f3!==_3f2){this.replaceValue(_3f2);}};on(ta.form,"submit",lang.hitch(this,function(){_3d4.set(ta,"disabled",this.disabled);ta.value=this.getValue();}));}}else{html=_3e4.getChildrenHtml(dn);dn.innerHTML="";}}this.value=html;if(dn.nodeName&&dn.nodeName==="LI"){dn.innerHTML=" <br>";}this.header=dn.ownerDocument.createElement("div");dn.appendChild(this.header);this.editingArea=dn.ownerDocument.createElement("div");dn.appendChild(this.editingArea);this.footer=dn.ownerDocument.createElement("div");dn.appendChild(this.footer);if(!this.name){this.name=this.id+"_AUTOGEN";}if(this.name!==""&&(!_3d1["useXDomain"]||_3d1["allowXdRichTextSave"])){var _3f4=dom.byId(_3e6._scopeName+"._editor.RichText.value");if(_3f4&&_3f4.value!==""){var _3f5=_3f4.value.split(this._SEPARATOR),i=0,dat;while((dat=_3f5[i++])){var data=dat.split(this._NAME_CONTENT_SEP);if(data[0]===this.name){html=data[1];_3f5=_3f5.splice(i,1);_3f4.value=_3f5.join(this._SEPARATOR);break;}}}if(!_3e7._globalSaveHandler){_3e7._globalSaveHandler={};_3dd.addOnUnload(function(){var id;for(id in _3e7._globalSaveHandler){var f=_3e7._globalSaveHandler[id];if(lang.isFunction(f)){f();}}});}_3e7._globalSaveHandler[this.id]=lang.hitch(this,"_saveContent");}this.isClosed=false;var ifr=(this.editorObject=this.iframe=this.ownerDocument.createElement("iframe"));ifr.id=this.id+"_iframe";ifr.style.border="none";ifr.style.width="100%";if(this._layoutMode){ifr.style.height="100%";}else{if(has("ie")>=7){if(this.height){ifr.style.height=this.height;}if(this.minHeight){ifr.style.minHeight=this.minHeight;}}else{ifr.style.height=this.height?this.height:this.minHeight;}}ifr.frameBorder=0;ifr._loadFunc=lang.hitch(this,function(w){this.window=w;this.document=this.window.document;this.selection=new _3e2.SelectionManager(w);if(has("ie")){this._localizeEditorCommands();}this.onLoad(html);});var src=this._getIframeDocTxt(),s="javascript: '"+src.replace(/\\/g,"\\\\").replace(/'/g,"\\'")+"'";if(has("ie")>=9){this.editingArea.appendChild(ifr);ifr.src=s;}else{ifr.setAttribute("src",s);this.editingArea.appendChild(ifr);}if(dn.nodeName==="LI"){dn.lastChild.style.marginTop="-1.2em";}_3d5.add(this.domNode,this.baseClass);},_local2NativeFormatNames:{},_native2LocalFormatNames:{},_getIframeDocTxt:function(){var _3f6=_3d8.getComputedStyle(this.domNode);var html="";var _3f7=true;if(has("ie")||has("webkit")||(!this.height&&!has("mozilla"))){html="<div id='dijitEditorBody'></div>";_3f7=false;}else{if(has("mozilla")){this._cursorToStart=true;html="&#160;";}}var font=[_3f6.fontWeight,_3f6.fontSize,_3f6.fontFamily].join(" ");var _3f8=_3f6.lineHeight;if(_3f8.indexOf("px")>=0){_3f8=parseFloat(_3f8)/parseFloat(_3f6.fontSize);}else{if(_3f8.indexOf("em")>=0){_3f8=parseFloat(_3f8);}else{_3f8="normal";}}var _3f9="";var self=this;this.style.replace(/(^|;)\s*(line-|font-?)[^;]+/ig,function(_3fa){_3fa=_3fa.replace(/^;/ig,"")+";";var s=_3fa.split(":")[0];if(s){s=lang.trim(s);s=s.toLowerCase();var i;var sC="";for(i=0;i<s.length;i++){var c=s.charAt(i);switch(c){case "-":i++;c=s.charAt(i).toUpperCase();default:sC+=c;}}_3d8.set(self.domNode,sC,"");}_3f9+=_3fa+";";});var _3fb=_3da("label[for=\""+this.id+"\"]");var _3fc="";if(_3fb.length){_3fc=_3fb[0].innerHTML;}else{if(this["aria-label"]){_3fc=this["aria-label"];}else{if(this["aria-labelledby"]){_3fc=dom.byId(this["aria-labelledby"]).innerHTML;}}}this.iframe.setAttribute("title",_3fc);return ["<!DOCTYPE html>",this.isLeftToRight()?"<html lang='"+this.lang+"'>\n<head>\n":"<html dir='rtl' lang='"+this.lang+"'>\n<head>\n",_3fc?"<title>"+_3fc+"</title>":"","<meta http-equiv='Content-Type' content='text/html'>\n","<style>\n","\tbody,html {\n","\t\tbackground:transparent;\n","\t\tpadding: 1px 0 0 0;\n","\t\tmargin: -1px 0 0 0;\n","\t}\n","\tbody,html, #dijitEditorBody{ outline: none; }","html { height: 100%; width: 100%; overflow: hidden; }\n",this.height?"\tbody { height: 100%; width: 100%; overflow: auto; }\n":"\tbody { min-height: "+this.minHeight+"; width: 100%; overflow-x: auto; overflow-y: hidden; }\n","\tbody{\n","\t\ttop:0px;\n","\t\tleft:0px;\n","\t\tright:0px;\n","\t\tfont:",font,";\n",((this.height||has("opera"))?"":"\t\tposition: fixed;\n"),"\t\tline-height:",_3f8,";\n","\t}\n","\tp{ margin: 1em 0; }\n","\tli > ul:-moz-first-node, li > ol:-moz-first-node{ padding-top: 1.2em; }\n",(!has("ie")?"\tli{ min-height:1.2em; }\n":""),"</style>\n",this._applyEditingAreaStyleSheets(),"\n","</head>\n<body role='main' ",(_3f7?"id='dijitEditorBody' ":""),"onload='frameElement && frameElement._loadFunc(window,document)' ","style='"+_3f9+"'>",html,"</body>\n</html>"].join("");},_applyEditingAreaStyleSheets:function(){var _3fd=[];if(this.styleSheets){_3fd=this.styleSheets.split(";");this.styleSheets="";}_3fd=_3fd.concat(this.editingAreaStyleSheets);this.editingAreaStyleSheets=[];var text="",i=0,url,_3fe=_3df.get(this.ownerDocument);while((url=_3fd[i++])){var _3ff=(new _3de(_3fe.location,url)).toString();this.editingAreaStyleSheets.push(_3ff);text+="<link rel=\"stylesheet\" type=\"text/css\" href=\""+_3ff+"\"/>";}return text;},addStyleSheet:function(uri){var url=uri.toString(),_400=_3df.get(this.ownerDocument);if(url.charAt(0)==="."||(url.charAt(0)!=="/"&&!uri.host)){url=(new _3de(_400.location,url)).toString();}if(_3d0.indexOf(this.editingAreaStyleSheets,url)>-1){return;}this.editingAreaStyleSheets.push(url);this.onLoadDeferred.then(lang.hitch(this,function(){if(this.document.createStyleSheet){this.document.createStyleSheet(url);}else{var head=this.document.getElementsByTagName("head")[0];var _401=this.document.createElement("link");_401.rel="stylesheet";_401.type="text/css";_401.href=url;head.appendChild(_401);}}));},removeStyleSheet:function(uri){var url=uri.toString(),_402=_3df.get(this.ownerDocument);if(url.charAt(0)==="."||(url.charAt(0)!=="/"&&!uri.host)){url=(new _3de(_402.location,url)).toString();}var _403=_3d0.indexOf(this.editingAreaStyleSheets,url);if(_403===-1){return;}delete this.editingAreaStyleSheets[_403];_3da("link[href=\""+url+"\"]",this.window.document).orphan();},disabled:false,_mozSettingProps:{"styleWithCSS":false},_setDisabledAttr:function(_404){_404=!!_404;this._set("disabled",_404);if(!this.isLoaded){return;}if(has("ie")||has("webkit")||has("opera")){var _405=has("ie")&&(this.isLoaded||!this.focusOnLoad);if(_405){this.editNode.unselectable="on";}this.editNode.contentEditable=!_404;if(_405){this.defer(function(){if(this.editNode){this.editNode.unselectable="off";}});}}else{try{this.document.designMode=(_404?"off":"on");}catch(e){return;}if(!_404&&this._mozSettingProps){var ps=this._mozSettingProps;var n;for(n in ps){if(ps.hasOwnProperty(n)){try{this.document.execCommand(n,false,ps[n]);}catch(e2){}}}}}this._disabledOK=true;},onLoad:function(html){if(!this.window.__registeredWindow){this.window.__registeredWindow=true;this._iframeRegHandle=_3e5.registerIframe(this.iframe);}if(!has("ie")&&!has("webkit")&&(this.height||has("mozilla"))){this.editNode=this.document.body;}else{this.editNode=this.document.body.firstChild;var _406=this;if(has("ie")){this.tabStop=_3d6.create("div",{tabIndex:-1},this.editingArea);this.iframe.onfocus=function(){_406.editNode.setActive();};}}this.focusNode=this.editNode;var _407=this.events.concat(this.captureEvents);var ap=this.iframe?this.document:this.editNode;this.own(_3d0.map(_407,function(item){var type=item.toLowerCase().replace(/^on/,"");on(ap,type,lang.hitch(this,item));},this));this.own(on(ap,"mouseup",lang.hitch(this,"onClick")));if(has("ie")){this.own(on(this.document,"mousedown",lang.hitch(this,"_onIEMouseDown")));this.editNode.style.zoom=1;}else{this.own(on(this.document,"mousedown",lang.hitch(this,function(){delete this._cursorToStart;})));}if(has("webkit")){this._webkitListener=this.own(on(this.document,"mouseup",lang.hitch(this,"onDisplayChanged")))[0];this.own(on(this.document,"mousedown",lang.hitch(this,function(e){var t=e.target;if(t&&(t===this.document.body||t===this.document)){this.defer("placeCursorAtEnd");}})));}if(has("ie")){try{this.document.execCommand("RespectVisibilityInDesign",true,null);}catch(e){}}this.isLoaded=true;this.set("disabled",this.disabled);var _408=lang.hitch(this,function(){this.setValue(html);if(this.onLoadDeferred){this.onLoadDeferred.resolve(true);}this.onDisplayChanged();if(this.focusOnLoad){_3db(lang.hitch(this,"defer","focus",this.updateInterval));}this.value=this.getValue(true);});if(this.setValueDeferred){this.setValueDeferred.then(_408);}else{_408();}},onKeyDown:function(e){if(e.keyCode===keys.TAB&&this.isTabIndent){e.stopPropagation();e.preventDefault();if(this.queryCommandEnabled((e.shiftKey?"outdent":"indent"))){this.execCommand((e.shiftKey?"outdent":"indent"));}}if(has("ie")){if(e.keyCode==keys.TAB&&!this.isTabIndent){if(e.shiftKey&&!e.ctrlKey&&!e.altKey){this.iframe.focus();}else{if(!e.shiftKey&&!e.ctrlKey&&!e.altKey){this.tabStop.focus();}}}else{if(e.keyCode===keys.BACKSPACE&&this.document.selection.type==="Control"){e.stopPropagation();e.preventDefault();this.execCommand("delete");}}}if(has("ff")){if(e.keyCode===keys.PAGE_UP||e.keyCode===keys.PAGE_DOWN){if(this.editNode.clientHeight>=this.editNode.scrollHeight){e.preventDefault();}}}var _409=this._keyHandlers[e.keyCode],args=arguments;if(_409&&!e.altKey){_3d0.some(_409,function(h){if(!(h.shift^e.shiftKey)&&!(h.ctrl^(e.ctrlKey||e.metaKey))){if(!h.handler.apply(this,args)){e.preventDefault();}return true;}},this);}this.defer("onKeyPressed",1);return true;},onKeyUp:function(){},setDisabled:function(_40a){_3d9.deprecated("dijit.Editor::setDisabled is deprecated","use dijit.Editor::attr(\"disabled\",boolean) instead",2);this.set("disabled",_40a);},_setValueAttr:function(_40b){this.setValue(_40b);},_setDisableSpellCheckAttr:function(_40c){if(this.document){_3d4.set(this.document.body,"spellcheck",!_40c);}else{this.onLoadDeferred.then(lang.hitch(this,function(){_3d4.set(this.document.body,"spellcheck",!_40c);}));}this._set("disableSpellCheck",_40c);},addKeyHandler:function(key,ctrl,_40d,_40e){if(typeof key=="string"){key=key.toUpperCase().charCodeAt(0);}if(!lang.isArray(this._keyHandlers[key])){this._keyHandlers[key]=[];}this._keyHandlers[key].push({shift:_40d||false,ctrl:ctrl||false,handler:_40e});},onKeyPressed:function(){this.onDisplayChanged();},onClick:function(e){this.onDisplayChanged(e);},_onIEMouseDown:function(){if(!this.focused&&!this.disabled){this.focus();}},_onBlur:function(e){if(has("ie")>=9){this.defer(function(){if(!_3e5.curNode){this.ownerDocumentBody.focus();}});}this.inherited(arguments);var _40f=this.getValue(true);if(_40f!==this.value){this.onChange(_40f);}this._set("value",_40f);},_onFocus:function(e){if(!this.disabled){if(!this._disabledOK){this.set("disabled",false);}this.inherited(arguments);}},blur:function(){if(!has("ie")&&this.window.document.documentElement&&this.window.document.documentElement.focus){this.window.document.documentElement.focus();}else{if(this.ownerDocumentBody.focus){this.ownerDocumentBody.focus();}}},focus:function(){if(!this.isLoaded){this.focusOnLoad=true;return;}if(this._cursorToStart){delete this._cursorToStart;if(this.editNode.childNodes){this.placeCursorAtStart();return;}}if(!has("ie")){_3e5.focus(this.iframe);}else{if(this.editNode&&this.editNode.focus){this.iframe.fireEvent("onfocus",document.createEventObject());}}},updateInterval:200,_updateTimer:null,onDisplayChanged:function(){if(this._updateTimer){this._updateTimer.remove();}this._updateTimer=this.defer("onNormalizedDisplayChanged",this.updateInterval);},onNormalizedDisplayChanged:function(){delete this._updateTimer;},onChange:function(){},_normalizeCommand:function(cmd,_410){var _411=cmd.toLowerCase();if(_411==="formatblock"){if(has("safari")&&_410===undefined){_411="heading";}}else{if(_411==="hilitecolor"&&!has("mozilla")){_411="backcolor";}}return _411;},_qcaCache:{},queryCommandAvailable:function(_412){var ca=this._qcaCache[_412];if(ca!==undefined){return ca;}return (this._qcaCache[_412]=this._queryCommandAvailable(_412));},_queryCommandAvailable:function(_413){var ie=1;var _414=1<<1;var _415=1<<2;var _416=1<<3;function _417(_418){return {ie:Boolean(_418&ie),mozilla:Boolean(_418&_414),webkit:Boolean(_418&_415),opera:Boolean(_418&_416)};};var _419=null;switch(_413.toLowerCase()){case "bold":case "italic":case "underline":case "subscript":case "superscript":case "fontname":case "fontsize":case "forecolor":case "hilitecolor":case "justifycenter":case "justifyfull":case "justifyleft":case "justifyright":case "delete":case "selectall":case "toggledir":_419=_417(_414|ie|_415|_416);break;case "createlink":case "unlink":case "removeformat":case "inserthorizontalrule":case "insertimage":case "insertorderedlist":case "insertunorderedlist":case "indent":case "outdent":case "formatblock":case "inserthtml":case "undo":case "redo":case "strikethrough":case "tabindent":_419=_417(_414|ie|_416|_415);break;case "blockdirltr":case "blockdirrtl":case "dirltr":case "dirrtl":case "inlinedirltr":case "inlinedirrtl":_419=_417(ie);break;case "cut":case "copy":case "paste":_419=_417(ie|_414|_415|_416);break;case "inserttable":_419=_417(_414|ie);break;case "insertcell":case "insertcol":case "insertrow":case "deletecells":case "deletecols":case "deleterows":case "mergecells":case "splitcell":_419=_417(ie|_414);break;default:return false;}return (has("ie")&&_419.ie)||(has("mozilla")&&_419.mozilla)||(has("webkit")&&_419.webkit)||(has("opera")&&_419.opera);},execCommand:function(_41a,_41b){var _41c;if(this.focused){this.focus();}_41a=this._normalizeCommand(_41a,_41b);if(_41b!==undefined){if(_41a==="heading"){throw new Error("unimplemented");}else{if((_41a==="formatblock")&&has("ie")){_41b="<"+_41b+">";}}}var _41d="_"+_41a+"Impl";if(this[_41d]){_41c=this[_41d](_41b);}else{_41b=arguments.length>1?_41b:null;if(_41b||_41a!=="createlink"){_41c=this.document.execCommand(_41a,false,_41b);}}this.onDisplayChanged();return _41c;},queryCommandEnabled:function(_41e){if(this.disabled||!this._disabledOK){return false;}_41e=this._normalizeCommand(_41e);var _41f="_"+_41e+"EnabledImpl";if(this[_41f]){return this[_41f](_41e);}else{return this._browserQueryCommandEnabled(_41e);}},queryCommandState:function(_420){if(this.disabled||!this._disabledOK){return false;}_420=this._normalizeCommand(_420);try{return this.document.queryCommandState(_420);}catch(e){return false;}},queryCommandValue:function(_421){if(this.disabled||!this._disabledOK){return false;}var r;_421=this._normalizeCommand(_421);if(has("ie")&&_421==="formatblock"){r=this._native2LocalFormatNames[this.document.queryCommandValue(_421)];}else{if(has("mozilla")&&_421==="hilitecolor"){var _422;try{_422=this.document.queryCommandValue("styleWithCSS");}catch(e){_422=false;}this.document.execCommand("styleWithCSS",false,true);r=this.document.queryCommandValue(_421);this.document.execCommand("styleWithCSS",false,_422);}else{r=this.document.queryCommandValue(_421);}}return r;},_sCall:function(name,args){return this.selection[name].apply(this.selection,args);},placeCursorAtStart:function(){this.focus();var _423=false;if(has("mozilla")){var _424=this.editNode.firstChild;while(_424){if(_424.nodeType===3){if(_424.nodeValue.replace(/^\s+|\s+$/g,"").length>0){_423=true;this.selection.selectElement(_424);break;}}else{if(_424.nodeType===1){_423=true;var tg=_424.tagName?_424.tagName.toLowerCase():"";if(/br|input|img|base|meta|area|basefont|hr|link/.test(tg)){this.selection.selectElement(_424);}else{this.selection.selectElementChildren(_424);}break;}}_424=_424.nextSibling;}}else{_423=true;this.selection.selectElementChildren(this.editNode);}if(_423){this.selection.collapse(true);}},placeCursorAtEnd:function(){this.focus();var _425=false;if(has("mozilla")){var last=this.editNode.lastChild;while(last){if(last.nodeType===3){if(last.nodeValue.replace(/^\s+|\s+$/g,"").length>0){_425=true;this.selection.selectElement(last);break;}}else{if(last.nodeType===1){_425=true;this.selection.selectElement(last.lastChild||last);break;}}last=last.previousSibling;}}else{_425=true;this.selection.selectElementChildren(this.editNode);}if(_425){this.selection.collapse(false);}},getValue:function(_426){if(this.textarea){if(this.isClosed||!this.isLoaded){return this.textarea.value;}}return this._postFilterContent(null,_426);},_getValueAttr:function(){return this.getValue(true);},setValue:function(html){if(!this.isLoaded){this.onLoadDeferred.then(lang.hitch(this,function(){this.setValue(html);}));return;}this._cursorToStart=true;if(this.textarea&&(this.isClosed||!this.isLoaded)){this.textarea.value=html;}else{html=this._preFilterContent(html);var node=this.isClosed?this.domNode:this.editNode;if(html&&has("mozilla")&&html.toLowerCase()==="<p></p>"){html="<p>&#160;</p>";}if(!html&&has("webkit")){html="&#160;";}node.innerHTML=html;this._preDomFilterContent(node);}this.onDisplayChanged();this._set("value",this.getValue(true));},replaceValue:function(html){if(this.isClosed){this.setValue(html);}else{if(this.window&&this.window.getSelection&&!has("mozilla")){this.setValue(html);}else{if(this.window&&this.window.getSelection){html=this._preFilterContent(html);this.execCommand("selectall");if(!html){this._cursorToStart=true;html="&#160;";}this.execCommand("inserthtml",html);this._preDomFilterContent(this.editNode);}else{if(this.document&&this.document.selection){this.setValue(html);}}}}this._set("value",this.getValue(true));},_preFilterContent:function(html){var ec=html;_3d0.forEach(this.contentPreFilters,function(ef){if(ef){ec=ef(ec);}});return ec;},_preDomFilterContent:function(dom){dom=dom||this.editNode;_3d0.forEach(this.contentDomPreFilters,function(ef){if(ef&&lang.isFunction(ef)){ef(dom);}},this);},_postFilterContent:function(dom,_427){var ec;if(!lang.isString(dom)){dom=dom||this.editNode;if(this.contentDomPostFilters.length){if(_427){dom=lang.clone(dom);}_3d0.forEach(this.contentDomPostFilters,function(ef){dom=ef(dom);});}ec=_3e4.getChildrenHtml(dom);}else{ec=dom;}if(!lang.trim(ec.replace(/^\xA0\xA0*/,"").replace(/\xA0\xA0*$/,"")).length){ec="";}_3d0.forEach(this.contentPostFilters,function(ef){ec=ef(ec);});return ec;},_saveContent:function(){var _428=dom.byId(_3e6._scopeName+"._editor.RichText.value");if(_428){if(_428.value){_428.value+=this._SEPARATOR;}_428.value+=this.name+this._NAME_CONTENT_SEP+this.getValue(true);}},escapeXml:function(str,_429){str=str.replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;");if(!_429){str=str.replace(/'/gm,"&#39;");}return str;},getNodeHtml:function(node){_3d9.deprecated("dijit.Editor::getNodeHtml is deprecated","use dijit/_editor/html::getNodeHtml instead",2);return _3e4.getNodeHtml(node);},getNodeChildrenHtml:function(dom){_3d9.deprecated("dijit.Editor::getNodeChildrenHtml is deprecated","use dijit/_editor/html::getChildrenHtml instead",2);return _3e4.getChildrenHtml(dom);},close:function(save){if(this.isClosed){return;}if(!arguments.length){save=true;}if(save){this._set("value",this.getValue(true));}if(this.interval){clearInterval(this.interval);}if(this._webkitListener){this._webkitListener.remove();delete this._webkitListener;}if(has("ie")){this.iframe.onfocus=null;}this.iframe._loadFunc=null;if(this._iframeRegHandle){this._iframeRegHandle.remove();delete this._iframeRegHandle;}if(this.textarea){var s=this.textarea.style;s.position="";s.left=s.top="";if(has("ie")){s.overflow=this.__overflow;this.__overflow=null;}this.textarea.value=this.value;_3d6.destroy(this.domNode);this.domNode=this.textarea;}else{this.domNode.innerHTML=this.value;}delete this.iframe;_3d5.remove(this.domNode,this.baseClass);this.isClosed=true;this.isLoaded=false;delete this.editNode;delete this.focusNode;if(this.window&&this.window._frameElement){this.window._frameElement=null;}this.window=null;this.document=null;this.editingArea=null;this.editorObject=null;},destroy:function(){if(!this.isClosed){this.close(false);}if(this._updateTimer){this._updateTimer.remove();}this.inherited(arguments);if(_3e7._globalSaveHandler){delete _3e7._globalSaveHandler[this.id];}},_removeMozBogus:function(html){return html.replace(/\stype="_moz"/gi,"").replace(/\s_moz_dirty=""/gi,"").replace(/_moz_resizing="(true|false)"/gi,"");},_removeWebkitBogus:function(html){html=html.replace(/\sclass="webkit-block-placeholder"/gi,"");html=html.replace(/\sclass="apple-style-span"/gi,"");html=html.replace(/<meta charset=\"utf-8\" \/>/gi,"");return html;},_normalizeFontStyle:function(html){return html.replace(/<(\/)?strong([ \>])/gi,"<$1b$2").replace(/<(\/)?em([ \>])/gi,"<$1i$2");},_preFixUrlAttributes:function(html){return html.replace(/(?:(<a(?=\s).*?\shref=)("|')(.*?)\2)|(?:(<a\s.*?href=)([^"'][^ >]+))/gi,"$1$4$2$3$5$2 _djrealurl=$2$3$5$2").replace(/(?:(<img(?=\s).*?\ssrc=)("|')(.*?)\2)|(?:(<img\s.*?src=)([^"'][^ >]+))/gi,"$1$4$2$3$5$2 _djrealurl=$2$3$5$2");},_browserQueryCommandEnabled:function(_42a){if(!_42a){return false;}var elem=has("ie")?this.document.selection.createRange():this.document;try{return elem.queryCommandEnabled(_42a);}catch(e){return false;}},_createlinkEnabledImpl:function(){var _42b=true;if(has("opera")){var sel=this.window.getSelection();if(sel.isCollapsed){_42b=true;}else{_42b=this.document.queryCommandEnabled("createlink");}}else{_42b=this._browserQueryCommandEnabled("createlink");}return _42b;},_unlinkEnabledImpl:function(){var _42c=true;if(has("mozilla")||has("webkit")){_42c=this.selection.hasAncestorElement("a");}else{_42c=this._browserQueryCommandEnabled("unlink");}return _42c;},_inserttableEnabledImpl:function(){var _42d=true;if(has("mozilla")||has("webkit")){_42d=true;}else{_42d=this._browserQueryCommandEnabled("inserttable");}return _42d;},_cutEnabledImpl:function(){var _42e=true;if(has("webkit")){var sel=this.window.getSelection();if(sel){sel=sel.toString();}_42e=!!sel;}else{_42e=this._browserQueryCommandEnabled("cut");}return _42e;},_copyEnabledImpl:function(){var _42f=true;if(has("webkit")){var sel=this.window.getSelection();if(sel){sel=sel.toString();}_42f=!!sel;}else{_42f=this._browserQueryCommandEnabled("copy");}return _42f;},_pasteEnabledImpl:function(){var _430=true;if(has("webkit")){return true;}else{_430=this._browserQueryCommandEnabled("paste");}return _430;},_inserthorizontalruleImpl:function(_431){if(has("ie")){return this._inserthtmlImpl("<hr>");}return this.document.execCommand("inserthorizontalrule",false,_431);},_unlinkImpl:function(_432){if((this.queryCommandEnabled("unlink"))&&(has("mozilla")||has("webkit"))){var a=this.selection.getAncestorElement("a");this.selection.selectElement(a);return this.document.execCommand("unlink",false,null);}return this.document.execCommand("unlink",false,_432);},_hilitecolorImpl:function(_433){var _434;var _435=this._handleTextColorOrProperties("hilitecolor",_433);if(!_435){if(has("mozilla")){this.document.execCommand("styleWithCSS",false,true);_434=this.document.execCommand("hilitecolor",false,_433);this.document.execCommand("styleWithCSS",false,false);}else{_434=this.document.execCommand("hilitecolor",false,_433);}}return _434;},_backcolorImpl:function(_436){if(has("ie")){_436=_436?_436:null;}var _437=this._handleTextColorOrProperties("backcolor",_436);if(!_437){_437=this.document.execCommand("backcolor",false,_436);}return _437;},_forecolorImpl:function(_438){if(has("ie")){_438=_438?_438:null;}var _439=false;_439=this._handleTextColorOrProperties("forecolor",_438);if(!_439){_439=this.document.execCommand("forecolor",false,_438);}return _439;},_inserthtmlImpl:function(_43a){_43a=this._preFilterContent(_43a);var rv=true;if(has("ie")){var _43b=this.document.selection.createRange();if(this.document.selection.type.toUpperCase()==="CONTROL"){var n=_43b.item(0);while(_43b.length){_43b.remove(_43b.item(0));}n.outerHTML=_43a;}else{_43b.pasteHTML(_43a);}_43b.select();}else{if(has("mozilla")&&!_43a.length){this.selection.remove();}else{rv=this.document.execCommand("inserthtml",false,_43a);}}return rv;},_boldImpl:function(_43c){var _43d=false;if(has("ie")){this._adaptIESelection();_43d=this._adaptIEFormatAreaAndExec("bold");}if(!_43d){_43d=this.document.execCommand("bold",false,_43c);}return _43d;},_italicImpl:function(_43e){var _43f=false;if(has("ie")){this._adaptIESelection();_43f=this._adaptIEFormatAreaAndExec("italic");}if(!_43f){_43f=this.document.execCommand("italic",false,_43e);}return _43f;},_underlineImpl:function(_440){var _441=false;if(has("ie")){this._adaptIESelection();_441=this._adaptIEFormatAreaAndExec("underline");}if(!_441){_441=this.document.execCommand("underline",false,_440);}return _441;},_strikethroughImpl:function(_442){var _443=false;if(has("ie")){this._adaptIESelection();_443=this._adaptIEFormatAreaAndExec("strikethrough");}if(!_443){_443=this.document.execCommand("strikethrough",false,_442);}return _443;},_superscriptImpl:function(_444){var _445=false;if(has("ie")){this._adaptIESelection();_445=this._adaptIEFormatAreaAndExec("superscript");}if(!_445){_445=this.document.execCommand("superscript",false,_444);}return _445;},_subscriptImpl:function(_446){var _447=false;if(has("ie")){this._adaptIESelection();_447=this._adaptIEFormatAreaAndExec("subscript");}if(!_447){_447=this.document.execCommand("subscript",false,_446);}return _447;},_fontnameImpl:function(_448){var _449;if(has("ie")){_449=this._handleTextColorOrProperties("fontname",_448);}if(!_449){_449=this.document.execCommand("fontname",false,_448);}return _449;},_fontsizeImpl:function(_44a){var _44b;if(has("ie")){_44b=this._handleTextColorOrProperties("fontsize",_44a);}if(!_44b){_44b=this.document.execCommand("fontsize",false,_44a);}return _44b;},_insertorderedlistImpl:function(_44c){var _44d=false;if(has("ie")){_44d=this._adaptIEList("insertorderedlist",_44c);}if(!_44d){_44d=this.document.execCommand("insertorderedlist",false,_44c);}return _44d;},_insertunorderedlistImpl:function(_44e){var _44f=false;if(has("ie")){_44f=this._adaptIEList("insertunorderedlist",_44e);}if(!_44f){_44f=this.document.execCommand("insertunorderedlist",false,_44e);}return _44f;},getHeaderHeight:function(){return this._getNodeChildrenHeight(this.header);},getFooterHeight:function(){return this._getNodeChildrenHeight(this.footer);},_getNodeChildrenHeight:function(node){var h=0;if(node&&node.childNodes){var i;for(i=0;i<node.childNodes.length;i++){var size=_3d7.position(node.childNodes[i]);h+=size.h;}}return h;},_isNodeEmpty:function(node,_450){if(node.nodeType===1){if(node.childNodes.length>0){return this._isNodeEmpty(node.childNodes[0],_450);}return true;}else{if(node.nodeType===3){return (node.nodeValue.substring(_450)==="");}}return false;},_removeStartingRangeFromRange:function(node,_451){if(node.nextSibling){_451.setStart(node.nextSibling,0);}else{var _452=node.parentNode;while(_452&&_452.nextSibling==null){_452=_452.parentNode;}if(_452){_451.setStart(_452.nextSibling,0);}}return _451;},_adaptIESelection:function(){var _453=_3e3.getSelection(this.window);if(_453&&_453.rangeCount&&!_453.isCollapsed){var _454=_453.getRangeAt(0);var _455=_454.startContainer;var _456=_454.startOffset;while(_455.nodeType===3&&_456>=_455.length&&_455.nextSibling){_456=_456-_455.length;_455=_455.nextSibling;}var _457=null;while(this._isNodeEmpty(_455,_456)&&_455!==_457){_457=_455;_454=this._removeStartingRangeFromRange(_455,_454);_455=_454.startContainer;_456=0;}_453.removeAllRanges();_453.addRange(_454);}},_adaptIEFormatAreaAndExec:function(_458){var _459=_3e3.getSelection(this.window);var doc=this.document;var rs,ret,_45a,txt,_45b,_45c,_45d,_45e;if(_458&&_459&&_459.isCollapsed){var _45f=this.queryCommandValue(_458);if(_45f){var _460=this._tagNamesForCommand(_458);_45a=_459.getRangeAt(0);var fs=_45a.startContainer;if(fs.nodeType===3){var _461=_45a.endOffset;if(fs.length<_461){ret=this._adjustNodeAndOffset(rs,_461);fs=ret.node;_461=ret.offset;}}var _462;while(fs&&fs!==this.editNode){var _463=fs.tagName?fs.tagName.toLowerCase():"";if(_3d0.indexOf(_460,_463)>-1){_462=fs;break;}fs=fs.parentNode;}if(_462){rs=_45a.startContainer;var _464=doc.createElement(_462.tagName);_3d6.place(_464,_462,"after");if(rs&&rs.nodeType===3){var _465,_466;var _467=_45a.endOffset;if(rs.length<_467){ret=this._adjustNodeAndOffset(rs,_467);rs=ret.node;_467=ret.offset;}txt=rs.nodeValue;_45b=doc.createTextNode(txt.substring(0,_467));var _468=txt.substring(_467,txt.length);if(_468){_45c=doc.createTextNode(_468);}_3d6.place(_45b,rs,"before");if(_45c){_45d=doc.createElement("span");_45d.className="ieFormatBreakerSpan";_3d6.place(_45d,rs,"after");_3d6.place(_45c,_45d,"after");_45c=_45d;}_3d6.destroy(rs);var _469=_45b.parentNode;var _46a=[];var _46b;while(_469!==_462){var tg=_469.tagName;_46b={tagName:tg};_46a.push(_46b);var _46c=doc.createElement(tg);if(_469.style){if(_46c.style){if(_469.style.cssText){_46c.style.cssText=_469.style.cssText;_46b.cssText=_469.style.cssText;}}}if(_469.tagName==="FONT"){if(_469.color){_46c.color=_469.color;_46b.color=_469.color;}if(_469.face){_46c.face=_469.face;_46b.face=_469.face;}if(_469.size){_46c.size=_469.size;_46b.size=_469.size;}}if(_469.className){_46c.className=_469.className;_46b.className=_469.className;}if(_45c){_465=_45c;while(_465){_466=_465.nextSibling;_46c.appendChild(_465);_465=_466;}}if(_46c.tagName==_469.tagName){_45d=doc.createElement("span");_45d.className="ieFormatBreakerSpan";_3d6.place(_45d,_469,"after");_3d6.place(_46c,_45d,"after");}else{_3d6.place(_46c,_469,"after");}_45b=_469;_45c=_46c;_469=_469.parentNode;}if(_45c){_465=_45c;if(_465.nodeType===1||(_465.nodeType===3&&_465.nodeValue)){_464.innerHTML="";}while(_465){_466=_465.nextSibling;_464.appendChild(_465);_465=_466;}}var _46d;if(_46a.length){_46b=_46a.pop();var _46e=doc.createElement(_46b.tagName);if(_46b.cssText&&_46e.style){_46e.style.cssText=_46b.cssText;}if(_46b.className){_46e.className=_46b.className;}if(_46b.tagName==="FONT"){if(_46b.color){_46e.color=_46b.color;}if(_46b.face){_46e.face=_46b.face;}if(_46b.size){_46e.size=_46b.size;}}_3d6.place(_46e,_464,"before");while(_46a.length){_46b=_46a.pop();var _46f=doc.createElement(_46b.tagName);if(_46b.cssText&&_46f.style){_46f.style.cssText=_46b.cssText;}if(_46b.className){_46f.className=_46b.className;}if(_46b.tagName==="FONT"){if(_46b.color){_46f.color=_46b.color;}if(_46b.face){_46f.face=_46b.face;}if(_46b.size){_46f.size=_46b.size;}}_46e.appendChild(_46f);_46e=_46f;}_45e=doc.createTextNode(".");_45d.appendChild(_45e);_46e.appendChild(_45e);_46d=_3e3.create(this.window);_46d.setStart(_45e,0);_46d.setEnd(_45e,_45e.length);_459.removeAllRanges();_459.addRange(_46d);this.selection.collapse(false);_45e.parentNode.innerHTML="";}else{_45d=doc.createElement("span");_45d.className="ieFormatBreakerSpan";_45e=doc.createTextNode(".");_45d.appendChild(_45e);_3d6.place(_45d,_464,"before");_46d=_3e3.create(this.window);_46d.setStart(_45e,0);_46d.setEnd(_45e,_45e.length);_459.removeAllRanges();_459.addRange(_46d);this.selection.collapse(false);_45e.parentNode.innerHTML="";}if(!_464.firstChild){_3d6.destroy(_464);}return true;}}return false;}else{_45a=_459.getRangeAt(0);rs=_45a.startContainer;if(rs&&rs.nodeType===3){var _461=_45a.startOffset;if(rs.length<_461){ret=this._adjustNodeAndOffset(rs,_461);rs=ret.node;_461=ret.offset;}txt=rs.nodeValue;_45b=doc.createTextNode(txt.substring(0,_461));var _468=txt.substring(_461);if(_468!==""){_45c=doc.createTextNode(txt.substring(_461));}_45d=doc.createElement("span");_45e=doc.createTextNode(".");_45d.appendChild(_45e);if(_45b.length){_3d6.place(_45b,rs,"after");}else{_45b=rs;}_3d6.place(_45d,_45b,"after");if(_45c){_3d6.place(_45c,_45d,"after");}_3d6.destroy(rs);var _46d=_3e3.create(this.window);_46d.setStart(_45e,0);_46d.setEnd(_45e,_45e.length);_459.removeAllRanges();_459.addRange(_46d);doc.execCommand(_458);_3d6.place(_45d.firstChild,_45d,"before");_3d6.destroy(_45d);_46d.setStart(_45e,0);_46d.setEnd(_45e,_45e.length);_459.removeAllRanges();_459.addRange(_46d);this.selection.collapse(false);_45e.parentNode.innerHTML="";return true;}}}else{return false;}},_adaptIEList:function(_470){var _471=_3e3.getSelection(this.window);if(_471.isCollapsed){if(_471.rangeCount&&!this.queryCommandValue(_470)){var _472=_471.getRangeAt(0);var sc=_472.startContainer;if(sc&&sc.nodeType==3){if(!_472.startOffset){var _473="ul";if(_470==="insertorderedlist"){_473="ol";}var list=this.document.createElement(_473);var li=_3d6.create("li",null,list);_3d6.place(list,sc,"before");li.appendChild(sc);_3d6.create("br",null,list,"after");var _474=_3e3.create(this.window);_474.setStart(sc,0);_474.setEnd(sc,sc.length);_471.removeAllRanges();_471.addRange(_474);this.selection.collapse(true);return true;}}}}return false;},_handleTextColorOrProperties:function(_475,_476){var _477=_3e3.getSelection(this.window);var doc=this.document;var rs,ret,_478,txt,_479,_47a,_47b,_47c;_476=_476||null;if(_475&&_477&&_477.isCollapsed){if(_477.rangeCount){_478=_477.getRangeAt(0);rs=_478.startContainer;if(rs&&rs.nodeType===3){var _47d=_478.startOffset;if(rs.length<_47d){ret=this._adjustNodeAndOffset(rs,_47d);rs=ret.node;_47d=ret.offset;}txt=rs.nodeValue;_479=doc.createTextNode(txt.substring(0,_47d));var _47e=txt.substring(_47d);if(_47e!==""){_47a=doc.createTextNode(txt.substring(_47d));}_47b=doc.createElement("span");_47c=doc.createTextNode(".");_47b.appendChild(_47c);var _47f=doc.createElement("span");_47b.appendChild(_47f);if(_479.length){_3d6.place(_479,rs,"after");}else{_479=rs;}_3d6.place(_47b,_479,"after");if(_47a){_3d6.place(_47a,_47b,"after");}_3d6.destroy(rs);var _480=_3e3.create(this.window);_480.setStart(_47c,0);_480.setEnd(_47c,_47c.length);_477.removeAllRanges();_477.addRange(_480);if(has("webkit")){var _481="color";if(_475==="hilitecolor"||_475==="backcolor"){_481="backgroundColor";}_3d8.set(_47b,_481,_476);this.selection.remove();_3d6.destroy(_47f);_47b.innerHTML="&#160;";this.selection.selectElement(_47b);this.focus();}else{this.execCommand(_475,_476);_3d6.place(_47b.firstChild,_47b,"before");_3d6.destroy(_47b);_480.setStart(_47c,0);_480.setEnd(_47c,_47c.length);_477.removeAllRanges();_477.addRange(_480);this.selection.collapse(false);_47c.parentNode.removeChild(_47c);}return true;}}}return false;},_adjustNodeAndOffset:function(node,_482){while(node.length<_482&&node.nextSibling&&node.nextSibling.nodeType===3){_482=_482-node.length;node=node.nextSibling;}return {"node":node,"offset":_482};},_tagNamesForCommand:function(_483){if(_483==="bold"){return ["b","strong"];}else{if(_483==="italic"){return ["i","em"];}else{if(_483==="strikethrough"){return ["s","strike"];}else{if(_483==="superscript"){return ["sup"];}else{if(_483==="subscript"){return ["sub"];}else{if(_483==="underline"){return ["u"];}}}}}}return [];},_stripBreakerNodes:function(node){if(!this.isLoaded){return;}_3da(".ieFormatBreakerSpan",node).forEach(function(b){while(b.firstChild){_3d6.place(b.firstChild,b,"before");}_3d6.destroy(b);});return node;}});return _3e7;});},"dojo/dnd/Moveable":function(){define(["../_base/array","../_base/declare","../_base/lang","../dom","../dom-class","../Evented","../on","../topic","../touch","./common","./Mover","../_base/window"],function(_484,_485,lang,dom,_486,_487,on,_488,_489,dnd,_48a,win){var _48b=_485("dojo.dnd.Moveable",[_487],{handle:"",delay:0,skip:false,constructor:function(node,_48c){this.node=dom.byId(node);if(!_48c){_48c={};}this.handle=_48c.handle?dom.byId(_48c.handle):null;if(!this.handle){this.handle=this.node;}this.delay=_48c.delay>0?_48c.delay:0;this.skip=_48c.skip;this.mover=_48c.mover?_48c.mover:_48a;this.events=[on(this.handle,_489.press,lang.hitch(this,"onMouseDown")),on(this.handle,"dragstart",lang.hitch(this,"onSelectStart")),on(this.handle,"selectstart",lang.hitch(this,"onSelectStart"))];},markupFactory:function(_48d,node,Ctor){return new Ctor(node,_48d);},destroy:function(){_484.forEach(this.events,function(_48e){_48e.remove();});this.events=this.node=this.handle=null;},onMouseDown:function(e){if(this.skip&&dnd.isFormElement(e)){return;}if(this.delay){this.events.push(on(this.handle,_489.move,lang.hitch(this,"onMouseMove")),on(this.handle,_489.release,lang.hitch(this,"onMouseUp")));this._lastX=e.pageX;this._lastY=e.pageY;}else{this.onDragDetected(e);}e.stopPropagation();e.preventDefault();},onMouseMove:function(e){if(Math.abs(e.pageX-this._lastX)>this.delay||Math.abs(e.pageY-this._lastY)>this.delay){this.onMouseUp(e);this.onDragDetected(e);}e.stopPropagation();e.preventDefault();},onMouseUp:function(e){for(var i=0;i<2;++i){this.events.pop().remove();}e.stopPropagation();e.preventDefault();},onSelectStart:function(e){if(!this.skip||!dnd.isFormElement(e)){e.stopPropagation();e.preventDefault();}},onDragDetected:function(e){new this.mover(this.node,e,this);},onMoveStart:function(_48f){_488.publish("/dnd/move/start",_48f);_486.add(win.body(),"dojoMove");_486.add(this.node,"dojoMoveItem");},onMoveStop:function(_490){_488.publish("/dnd/move/stop",_490);_486.remove(win.body(),"dojoMove");_486.remove(this.node,"dojoMoveItem");},onFirstMove:function(){},onMove:function(_491,_492){this.onMoving(_491,_492);var s=_491.node.style;s.left=_492.l+"px";s.top=_492.t+"px";this.onMoved(_491,_492);},onMoving:function(){},onMoved:function(){}});return _48b;});},"dijit/TooltipDialog":function(){define(["dojo/_base/declare","dojo/dom-class","dojo/has","dojo/keys","dojo/_base/lang","dojo/on","./focus","./layout/ContentPane","./_DialogMixin","./form/_FormMixin","./_TemplatedMixin","dojo/text!./templates/TooltipDialog.html","./main"],function(_493,_494,has,keys,lang,on,_495,_496,_497,_498,_499,_49a,_49b){var _49c=_493("dijit.TooltipDialog",[_496,_499,_498,_497],{title:"",doLayout:false,autofocus:true,baseClass:"dijitTooltipDialog",_firstFocusItem:null,_lastFocusItem:null,templateString:_49a,_setTitleAttr:"containerNode",postCreate:function(){this.inherited(arguments);this.own(on(this.containerNode,"keydown",lang.hitch(this,"_onKey")));},orient:function(node,_49d,_49e){var newC={"MR-ML":"dijitTooltipRight","ML-MR":"dijitTooltipLeft","TM-BM":"dijitTooltipAbove","BM-TM":"dijitTooltipBelow","BL-TL":"dijitTooltipBelow dijitTooltipABLeft","TL-BL":"dijitTooltipAbove dijitTooltipABLeft","BR-TR":"dijitTooltipBelow dijitTooltipABRight","TR-BR":"dijitTooltipAbove dijitTooltipABRight","BR-BL":"dijitTooltipRight","BL-BR":"dijitTooltipLeft","BR-TL":"dijitTooltipBelow dijitTooltipABLeft","BL-TR":"dijitTooltipBelow dijitTooltipABRight","TL-BR":"dijitTooltipAbove dijitTooltipABRight","TR-BL":"dijitTooltipAbove dijitTooltipABLeft"}[_49d+"-"+_49e];_494.replace(this.domNode,newC,this._currentOrientClass||"");this._currentOrientClass=newC;},focus:function(){this._getFocusItems(this.containerNode);_495.focus(this._firstFocusItem);},onOpen:function(pos){this.orient(this.domNode,pos.aroundCorner,pos.corner);var _49f=pos.aroundNodePos;if(pos.corner.charAt(0)=="M"&&pos.aroundCorner.charAt(0)=="M"){this.connectorNode.style.top=_49f.y+((_49f.h-this.connectorNode.offsetHeight)>>1)-pos.y+"px";this.connectorNode.style.left="";}else{if(pos.corner.charAt(1)=="M"&&pos.aroundCorner.charAt(1)=="M"){this.connectorNode.style.left=_49f.x+((_49f.w-this.connectorNode.offsetWidth)>>1)-pos.x+"px";}}this._onShow();},onClose:function(){this.onHide();},_onKey:function(evt){if(evt.keyCode==keys.ESCAPE){this.defer("onCancel");evt.stopPropagation();evt.preventDefault();}else{if(evt.keyCode==keys.TAB){var node=evt.target;this._getFocusItems(this.containerNode);if(this._firstFocusItem==this._lastFocusItem){evt.stopPropagation();evt.preventDefault();}else{if(node==this._firstFocusItem&&evt.shiftKey){_495.focus(this._lastFocusItem);evt.stopPropagation();evt.preventDefault();}else{if(node==this._lastFocusItem&&!evt.shiftKey){_495.focus(this._firstFocusItem);evt.stopPropagation();evt.preventDefault();}else{evt.stopPropagation();}}}}}}});if(has("dojo-bidi")){_49c.extend({_setTitleAttr:function(_4a0){this.containerNode.title=(this.textDir&&this.enforceTextDirWithUcc)?this.enforceTextDirWithUcc(null,_4a0):_4a0;this._set("title",_4a0);},_setTextDirAttr:function(_4a1){if(!this._created||this.textDir!=_4a1){this._set("textDir",_4a1);if(this.textDir&&this.title){this.containerNode.title=this.enforceTextDirWithUcc(null,this.title);}}}});}return _49c;});},"dojo/store/util/SimpleQueryEngine":function(){define(["../../_base/array"],function(_4a2){return function(_4a3,_4a4){switch(typeof _4a3){default:throw new Error("Can not query with a "+typeof _4a3);case "object":case "undefined":var _4a5=_4a3;_4a3=function(_4a6){for(var key in _4a5){var _4a7=_4a5[key];if(_4a7&&_4a7.test){if(!_4a7.test(_4a6[key],_4a6)){return false;}}else{if(_4a7!=_4a6[key]){return false;}}}return true;};break;case "string":if(!this[_4a3]){throw new Error("No filter function "+_4a3+" was found in store");}_4a3=this[_4a3];case "function":}function _4a8(_4a9){var _4aa=_4a2.filter(_4a9,_4a3);var _4ab=_4a4&&_4a4.sort;if(_4ab){_4aa.sort(typeof _4ab=="function"?_4ab:function(a,b){for(var sort,i=0;sort=_4ab[i];i++){var _4ac=a[sort.attribute];var _4ad=b[sort.attribute];if(_4ac!=_4ad){return !!sort.descending==(_4ac==null||_4ac>_4ad)?-1:1;}}return 0;});}if(_4a4&&(_4a4.start||_4a4.count)){var _4ae=_4aa.length;_4aa=_4aa.slice(_4a4.start||0,(_4a4.start||0)+(_4a4.count||Infinity));_4aa.total=_4ae;}return _4aa;};_4a8.matches=_4a3;return _4a8;};});},"dijit/form/_ExpandingTextAreaMixin":function(){define(["dojo/_base/declare","dojo/dom-construct","dojo/has","dojo/_base/lang","dojo/on","dojo/_base/window","../Viewport"],function(_4af,_4b0,has,lang,on,win,_4b1){has.add("textarea-needs-help-shrinking",function(){var body=win.body(),te=_4b0.create("textarea",{rows:"5",cols:"20",value:" ",style:{zoom:1,fontSize:"12px",height:"96px",overflow:"hidden",visibility:"hidden",position:"absolute",border:"5px solid white",margin:"0",padding:"0",boxSizing:"border-box",MsBoxSizing:"border-box",WebkitBoxSizing:"border-box",MozBoxSizing:"border-box"}},body,"last");var _4b2=te.scrollHeight>=te.clientHeight;body.removeChild(te);return _4b2;});return _4af("dijit.form._ExpandingTextAreaMixin",null,{_setValueAttr:function(){this.inherited(arguments);this.resize();},postCreate:function(){this.inherited(arguments);var _4b3=this.textbox;_4b3.style.overflowY="hidden";this.own(on(_4b3,"focus, resize",lang.hitch(this,"_resizeLater")));},startup:function(){this.inherited(arguments);this.own(_4b1.on("resize",lang.hitch(this,"_resizeLater")));this._resizeLater();},_onInput:function(e){this.inherited(arguments);this.resize();},_estimateHeight:function(){var _4b4=this.textbox;_4b4.rows=(_4b4.value.match(/\n/g)||[]).length+1;},_resizeLater:function(){this.defer("resize");},resize:function(){var _4b5=this.textbox;function _4b6(){var _4b7=false;if(_4b5.value===""){_4b5.value=" ";_4b7=true;}var sh=_4b5.scrollHeight;if(_4b7){_4b5.value="";}return sh;};if(_4b5.style.overflowY=="hidden"){_4b5.scrollTop=0;}if(this.busyResizing){return;}this.busyResizing=true;if(_4b6()||_4b5.offsetHeight){var newH=_4b6()+Math.max(_4b5.offsetHeight-_4b5.clientHeight,0);var _4b8=newH+"px";if(_4b8!=_4b5.style.height){_4b5.style.height=_4b8;_4b5.rows=1;}if(has("textarea-needs-help-shrinking")){var _4b9=_4b6(),_4ba=_4b9,_4bb=_4b5.style.minHeight,_4bc=4,_4bd,_4be=_4b5.scrollTop;_4b5.style.minHeight=_4b8;_4b5.style.height="auto";while(newH>0){_4b5.style.minHeight=Math.max(newH-_4bc,4)+"px";_4bd=_4b6();var _4bf=_4ba-_4bd;newH-=_4bf;if(_4bf<_4bc){break;}_4ba=_4bd;_4bc<<=1;}_4b5.style.height=newH+"px";_4b5.style.minHeight=_4bb;_4b5.scrollTop=_4be;}_4b5.style.overflowY=_4b6()>_4b5.clientHeight?"auto":"hidden";if(_4b5.style.overflowY=="hidden"){_4b5.scrollTop=0;}}else{this._estimateHeight();}this.busyResizing=false;}});});},"dijit/MenuItem":function(){define(["dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/_base/kernel","dojo/sniff","dojo/_base/lang","./_Widget","./_TemplatedMixin","./_Contained","./_CssStateMixin","dojo/text!./templates/MenuItem.html"],function(_4c0,dom,_4c1,_4c2,_4c3,has,lang,_4c4,_4c5,_4c6,_4c7,_4c8){var _4c9=_4c0("dijit.MenuItem"+(has("dojo-bidi")?"_NoBidi":""),[_4c4,_4c5,_4c6,_4c7],{templateString:_4c8,baseClass:"dijitMenuItem",label:"",_setLabelAttr:function(val){this._set("label",val);var _4ca="";var text;var ndx=val.search(/{\S}/);if(ndx>=0){_4ca=val.charAt(ndx+1);var _4cb=val.substr(0,ndx);var _4cc=val.substr(ndx+3);text=_4cb+_4ca+_4cc;val=_4cb+"<span class=\"dijitMenuItemShortcutKey\">"+_4ca+"</span>"+_4cc;}else{text=val;}this.domNode.setAttribute("aria-label",text+" "+this.accelKey);this.containerNode.innerHTML=val;this._set("shortcutKey",_4ca);},iconClass:"dijitNoIcon",_setIconClassAttr:{node:"iconNode",type:"class"},accelKey:"",disabled:false,_fillContent:function(_4cd){if(_4cd&&!("label" in this.params)){this._set("label",_4cd.innerHTML);}},buildRendering:function(){this.inherited(arguments);var _4ce=this.id+"_text";_4c1.set(this.containerNode,"id",_4ce);if(this.accelKeyNode){_4c1.set(this.accelKeyNode,"id",this.id+"_accel");}dom.setSelectable(this.domNode,false);},onClick:function(){},focus:function(){try{if(has("ie")==8){this.containerNode.focus();}this.focusNode.focus();}catch(e){}},_onFocus:function(){this.getParent()._onItemFocus(this);this.inherited(arguments);},_setSelected:function(_4cf){_4c2.toggle(this.domNode,"dijitMenuItemSelected",_4cf);},setLabel:function(_4d0){_4c3.deprecated("dijit.MenuItem.setLabel() is deprecated.  Use set('label', ...) instead.","","2.0");this.set("label",_4d0);},setDisabled:function(_4d1){_4c3.deprecated("dijit.Menu.setDisabled() is deprecated.  Use set('disabled', bool) instead.","","2.0");this.set("disabled",_4d1);},_setDisabledAttr:function(_4d2){this.focusNode.setAttribute("aria-disabled",_4d2?"true":"false");this._set("disabled",_4d2);},_setAccelKeyAttr:function(_4d3){if(this.accelKeyNode){this.accelKeyNode.style.display=_4d3?"":"none";this.accelKeyNode.innerHTML=_4d3;_4c1.set(this.containerNode,"colSpan",_4d3?"1":"2");}this._set("accelKey",_4d3);}});if(has("dojo-bidi")){_4c9=_4c0("dijit.MenuItem",_4c9,{_setLabelAttr:function(val){this.inherited(arguments);if(this.textDir==="auto"){this.applyTextDir(this.textDirNode);}}});}return _4c9;});},"dijit/MenuBarItem":function(){define(["dojo/_base/declare","./MenuItem","dojo/text!./templates/MenuBarItem.html"],function(_4d4,_4d5,_4d6){var _4d7=_4d4("dijit._MenuBarItemMixin",null,{templateString:_4d6,_setIconClassAttr:null});var _4d8=_4d4("dijit.MenuBarItem",[_4d5,_4d7],{});_4d8._MenuBarItemMixin=_4d7;return _4d8;});},"dijit/layout/TabController":function(){define(["dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/has","dojo/i18n","dojo/_base/lang","./StackController","../registry","../Menu","../MenuItem","dojo/text!./templates/_TabButton.html","dojo/i18n!../nls/common"],function(_4d9,dom,_4da,_4db,has,i18n,lang,_4dc,_4dd,Menu,_4de,_4df){var _4e0=_4d9("dijit.layout._TabButton"+(has("dojo-bidi")?"_NoBidi":""),_4dc.StackButton,{baseClass:"dijitTab",cssStateNodes:{closeNode:"dijitTabCloseButton"},templateString:_4df,_setNameAttr:"focusNode",scrollOnFocus:false,buildRendering:function(){this.inherited(arguments);dom.setSelectable(this.containerNode,false);},startup:function(){this.inherited(arguments);var n=this.domNode;this.defer(function(){n.className=n.className;},1);},_setCloseButtonAttr:function(disp){this._set("closeButton",disp);_4db.toggle(this.domNode,"dijitClosable",disp);this.closeNode.style.display=disp?"":"none";if(disp){var _4e1=i18n.getLocalization("dijit","common");if(this.closeNode){_4da.set(this.closeNode,"title",_4e1.itemClose);}}},_setDisabledAttr:function(_4e2){this.inherited(arguments);if(this.closeNode){if(_4e2){_4da.remove(this.closeNode,"title");}else{var _4e3=i18n.getLocalization("dijit","common");_4da.set(this.closeNode,"title",_4e3.itemClose);}}},_setLabelAttr:function(_4e4){this.inherited(arguments);if(!this.showLabel&&!this.params.title){this.iconNode.alt=lang.trim(this.containerNode.innerText||this.containerNode.textContent||"");}}});if(has("dojo-bidi")){_4e0=_4d9("dijit.layout._TabButton",_4e0,{_setLabelAttr:function(_4e5){this.inherited(arguments);this.applyTextDir(this.iconNode,this.iconNode.alt);}});}var _4e6=_4d9("dijit.layout.TabController",_4dc,{baseClass:"dijitTabController",templateString:"<div role='tablist' data-dojo-attach-event='onkeydown:onkeydown'></div>",tabPosition:"top",buttonWidget:_4e0,buttonWidgetCloseClass:"dijitTabCloseButton",postCreate:function(){this.inherited(arguments);var _4e7=new Menu({id:this.id+"_Menu",ownerDocument:this.ownerDocument,dir:this.dir,lang:this.lang,textDir:this.textDir,targetNodeIds:[this.domNode],selector:function(node){return _4db.contains(node,"dijitClosable")&&!_4db.contains(node,"dijitTabDisabled");}});this.own(_4e7);var _4e8=i18n.getLocalization("dijit","common"),_4e9=this;_4e7.addChild(new _4de({label:_4e8.itemClose,ownerDocument:this.ownerDocument,dir:this.dir,lang:this.lang,textDir:this.textDir,onClick:function(evt){var _4ea=_4dd.byNode(this.getParent().currentTarget);_4e9.onCloseButtonClick(_4ea.page);}}));}});_4e6.TabButton=_4e0;return _4e6;});},"dojo/cldr/supplemental":function(){define(["../_base/lang","../i18n"],function(lang,i18n){var _4eb={};lang.setObject("dojo.cldr.supplemental",_4eb);_4eb.getFirstDayOfWeek=function(_4ec){var _4ed={bd:5,mv:5,ae:6,af:6,bh:6,dj:6,dz:6,eg:6,iq:6,ir:6,jo:6,kw:6,ly:6,ma:6,om:6,qa:6,sa:6,sd:6,sy:6,ye:6,ag:0,ar:0,as:0,au:0,br:0,bs:0,bt:0,bw:0,by:0,bz:0,ca:0,cn:0,co:0,dm:0,"do":0,et:0,gt:0,gu:0,hk:0,hn:0,id:0,ie:0,il:0,"in":0,jm:0,jp:0,ke:0,kh:0,kr:0,la:0,mh:0,mm:0,mo:0,mt:0,mx:0,mz:0,ni:0,np:0,nz:0,pa:0,pe:0,ph:0,pk:0,pr:0,py:0,sg:0,sv:0,th:0,tn:0,tt:0,tw:0,um:0,us:0,ve:0,vi:0,ws:0,za:0,zw:0};var _4ee=_4eb._region(_4ec);var dow=_4ed[_4ee];return (dow===undefined)?1:dow;};_4eb._region=function(_4ef){_4ef=i18n.normalizeLocale(_4ef);var tags=_4ef.split("-");var _4f0=tags[1];if(!_4f0){_4f0={aa:"et",ab:"ge",af:"za",ak:"gh",am:"et",ar:"eg",as:"in",av:"ru",ay:"bo",az:"az",ba:"ru",be:"by",bg:"bg",bi:"vu",bm:"ml",bn:"bd",bo:"cn",br:"fr",bs:"ba",ca:"es",ce:"ru",ch:"gu",co:"fr",cr:"ca",cs:"cz",cv:"ru",cy:"gb",da:"dk",de:"de",dv:"mv",dz:"bt",ee:"gh",el:"gr",en:"us",es:"es",et:"ee",eu:"es",fa:"ir",ff:"sn",fi:"fi",fj:"fj",fo:"fo",fr:"fr",fy:"nl",ga:"ie",gd:"gb",gl:"es",gn:"py",gu:"in",gv:"gb",ha:"ng",he:"il",hi:"in",ho:"pg",hr:"hr",ht:"ht",hu:"hu",hy:"am",ia:"fr",id:"id",ig:"ng",ii:"cn",ik:"us","in":"id",is:"is",it:"it",iu:"ca",iw:"il",ja:"jp",ji:"ua",jv:"id",jw:"id",ka:"ge",kg:"cd",ki:"ke",kj:"na",kk:"kz",kl:"gl",km:"kh",kn:"in",ko:"kr",ks:"in",ku:"tr",kv:"ru",kw:"gb",ky:"kg",la:"va",lb:"lu",lg:"ug",li:"nl",ln:"cd",lo:"la",lt:"lt",lu:"cd",lv:"lv",mg:"mg",mh:"mh",mi:"nz",mk:"mk",ml:"in",mn:"mn",mo:"ro",mr:"in",ms:"my",mt:"mt",my:"mm",na:"nr",nb:"no",nd:"zw",ne:"np",ng:"na",nl:"nl",nn:"no",no:"no",nr:"za",nv:"us",ny:"mw",oc:"fr",om:"et",or:"in",os:"ge",pa:"in",pl:"pl",ps:"af",pt:"br",qu:"pe",rm:"ch",rn:"bi",ro:"ro",ru:"ru",rw:"rw",sa:"in",sd:"in",se:"no",sg:"cf",si:"lk",sk:"sk",sl:"si",sm:"ws",sn:"zw",so:"so",sq:"al",sr:"rs",ss:"za",st:"za",su:"id",sv:"se",sw:"tz",ta:"in",te:"in",tg:"tj",th:"th",ti:"et",tk:"tm",tl:"ph",tn:"za",to:"to",tr:"tr",ts:"za",tt:"ru",ty:"pf",ug:"cn",uk:"ua",ur:"pk",uz:"uz",ve:"za",vi:"vn",wa:"be",wo:"sn",xh:"za",yi:"il",yo:"ng",za:"cn",zh:"cn",zu:"za",ace:"id",ady:"ru",agq:"cm",alt:"ru",amo:"ng",asa:"tz",ast:"es",awa:"in",bal:"pk",ban:"id",bas:"cm",bax:"cm",bbc:"id",bem:"zm",bez:"tz",bfq:"in",bft:"pk",bfy:"in",bhb:"in",bho:"in",bik:"ph",bin:"ng",bjj:"in",bku:"ph",bqv:"ci",bra:"in",brx:"in",bss:"cm",btv:"pk",bua:"ru",buc:"yt",bug:"id",bya:"id",byn:"er",cch:"ng",ccp:"in",ceb:"ph",cgg:"ug",chk:"fm",chm:"ru",chp:"ca",chr:"us",cja:"kh",cjm:"vn",ckb:"iq",crk:"ca",csb:"pl",dar:"ru",dav:"ke",den:"ca",dgr:"ca",dje:"ne",doi:"in",dsb:"de",dua:"cm",dyo:"sn",dyu:"bf",ebu:"ke",efi:"ng",ewo:"cm",fan:"gq",fil:"ph",fon:"bj",fur:"it",gaa:"gh",gag:"md",gbm:"in",gcr:"gf",gez:"et",gil:"ki",gon:"in",gor:"id",grt:"in",gsw:"ch",guz:"ke",gwi:"ca",haw:"us",hil:"ph",hne:"in",hnn:"ph",hoc:"in",hoj:"in",ibb:"ng",ilo:"ph",inh:"ru",jgo:"cm",jmc:"tz",kaa:"uz",kab:"dz",kaj:"ng",kam:"ke",kbd:"ru",kcg:"ng",kde:"tz",kdt:"th",kea:"cv",ken:"cm",kfo:"ci",kfr:"in",kha:"in",khb:"cn",khq:"ml",kht:"in",kkj:"cm",kln:"ke",kmb:"ao",koi:"ru",kok:"in",kos:"fm",kpe:"lr",krc:"ru",kri:"sl",krl:"ru",kru:"in",ksb:"tz",ksf:"cm",ksh:"de",kum:"ru",lag:"tz",lah:"pk",lbe:"ru",lcp:"cn",lep:"in",lez:"ru",lif:"np",lis:"cn",lki:"ir",lmn:"in",lol:"cd",lua:"cd",luo:"ke",luy:"ke",lwl:"th",mad:"id",mag:"in",mai:"in",mak:"id",man:"gn",mas:"ke",mdf:"ru",mdh:"ph",mdr:"id",men:"sl",mer:"ke",mfe:"mu",mgh:"mz",mgo:"cm",min:"id",mni:"in",mnk:"gm",mnw:"mm",mos:"bf",mua:"cm",mwr:"in",myv:"ru",nap:"it",naq:"na",nds:"de","new":"np",niu:"nu",nmg:"cm",nnh:"cm",nod:"th",nso:"za",nus:"sd",nym:"tz",nyn:"ug",pag:"ph",pam:"ph",pap:"bq",pau:"pw",pon:"fm",prd:"ir",raj:"in",rcf:"re",rej:"id",rjs:"np",rkt:"in",rof:"tz",rwk:"tz",saf:"gh",sah:"ru",saq:"ke",sas:"id",sat:"in",saz:"in",sbp:"tz",scn:"it",sco:"gb",sdh:"ir",seh:"mz",ses:"ml",shi:"ma",shn:"mm",sid:"et",sma:"se",smj:"se",smn:"fi",sms:"fi",snk:"ml",srn:"sr",srr:"sn",ssy:"er",suk:"tz",sus:"gn",swb:"yt",swc:"cd",syl:"bd",syr:"sy",tbw:"ph",tcy:"in",tdd:"cn",tem:"sl",teo:"ug",tet:"tl",tig:"er",tiv:"ng",tkl:"tk",tmh:"ne",tpi:"pg",trv:"tw",tsg:"ph",tts:"th",tum:"mw",tvl:"tv",twq:"ne",tyv:"ru",tzm:"ma",udm:"ru",uli:"fm",umb:"ao",unr:"in",unx:"in",vai:"lr",vun:"tz",wae:"ch",wal:"et",war:"ph",xog:"ug",xsr:"np",yao:"mz",yap:"fm",yav:"cm",zza:"tr"}[tags[0]];}else{if(_4f0.length==4){_4f0=tags[2];}}return _4f0;};_4eb.getWeekend=function(_4f1){var _4f2={"in":0,af:4,dz:4,ir:4,om:4,sa:4,ye:4,ae:5,bh:5,eg:5,il:5,iq:5,jo:5,kw:5,ly:5,ma:5,qa:5,sd:5,sy:5,tn:5},_4f3={af:5,dz:5,ir:5,om:5,sa:5,ye:5,ae:6,bh:5,eg:6,il:6,iq:6,jo:6,kw:6,ly:6,ma:6,qa:6,sd:6,sy:6,tn:6},_4f4=_4eb._region(_4f1),_4f5=_4f2[_4f4],end=_4f3[_4f4];if(_4f5===undefined){_4f5=6;}if(end===undefined){end=0;}return {start:_4f5,end:end};};return _4eb;});},"dijit/MenuBar":function(){define(["dojo/_base/declare","dojo/keys","./_MenuBase","dojo/text!./templates/MenuBar.html"],function(_4f6,keys,_4f7,_4f8){return _4f6("dijit.MenuBar",_4f7,{templateString:_4f8,baseClass:"dijitMenuBar",popupDelay:0,_isMenuBar:true,_orient:["below"],_moveToPopup:function(evt){if(this.focusedChild&&this.focusedChild.popup&&!this.focusedChild.disabled){this.onItemClick(this.focusedChild,evt);}},focusChild:function(item){this.inherited(arguments);if(this.activated&&item.popup&&!item.disabled){this._openItemPopup(item,true);}},_onChildDeselect:function(item){if(this.currentPopupItem==item){this.currentPopupItem=null;item._closePopup();}this.inherited(arguments);},_onLeftArrow:function(){this.focusPrev();},_onRightArrow:function(){this.focusNext();},_onDownArrow:function(evt){this._moveToPopup(evt);},_onUpArrow:function(){},onItemClick:function(item,evt){if(item.popup&&item.popup.isShowingNow&&(!/^key/.test(evt.type)||evt.keyCode!==keys.DOWN_ARROW)){item.focusNode.focus();this._cleanUp(true);}else{this.inherited(arguments);}}});});},"dijit/ToolbarSeparator":function(){define(["dojo/_base/declare","dojo/dom","./_Widget","./_TemplatedMixin"],function(_4f9,dom,_4fa,_4fb){return _4f9("dijit.ToolbarSeparator",[_4fa,_4fb],{templateString:"<div class=\"dijitToolbarSeparator dijitInline\" role=\"presentation\"></div>",buildRendering:function(){this.inherited(arguments);dom.setSelectable(this.domNode,false);},isFocusable:function(){return false;}});});},"dijit/layout/StackController":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-class","dojo/dom-construct","dojo/keys","dojo/_base/lang","dojo/on","dojo/topic","../focus","../registry","../_Widget","../_TemplatedMixin","../_Container","../form/ToggleButton","dojo/touch","dojo/i18n!../nls/common"],function(_4fc,_4fd,_4fe,_4ff,keys,lang,on,_500,_501,_502,_503,_504,_505,_506){var _507=_4fd("dijit.layout._StackButton",_506,{tabIndex:"-1",closeButton:false,_aria_attr:"aria-selected",buildRendering:function(evt){this.inherited(arguments);(this.focusNode||this.domNode).setAttribute("role","tab");}});var _508=_4fd("dijit.layout.StackController",[_503,_504,_505],{baseClass:"dijitStackController",templateString:"<span role='tablist' data-dojo-attach-event='onkeydown'></span>",containerId:"",buttonWidget:_507,buttonWidgetCloseClass:"dijitStackCloseButton",pane2button:function(id){return _502.byId(this.id+"_"+id);},postCreate:function(){this.inherited(arguments);this.own(_500.subscribe(this.containerId+"-startup",lang.hitch(this,"onStartup")),_500.subscribe(this.containerId+"-addChild",lang.hitch(this,"onAddChild")),_500.subscribe(this.containerId+"-removeChild",lang.hitch(this,"onRemoveChild")),_500.subscribe(this.containerId+"-selectChild",lang.hitch(this,"onSelectChild")),_500.subscribe(this.containerId+"-containerKeyDown",lang.hitch(this,"onContainerKeyDown")));this.containerNode.dojoClick=true;this.own(on(this.containerNode,"click",lang.hitch(this,function(evt){var _509=_502.getEnclosingWidget(evt.target);if(_509!=this.containerNode&&!_509.disabled&&_509.page){for(var _50a=evt.target;_50a!==this.containerNode;_50a=_50a.parentNode){if(_4fe.contains(_50a,this.buttonWidgetCloseClass)){this.onCloseButtonClick(_509.page);break;}else{if(_50a==_509.domNode){this.onButtonClick(_509.page);break;}}}}})));},onStartup:function(info){this.textDir=info.textDir;_4fc.forEach(info.children,this.onAddChild,this);if(info.selected){this.onSelectChild(info.selected);}var _50b=_502.byId(this.containerId).containerNode,_50c=lang.hitch(this,"pane2button"),_50d={"title":"label","showtitle":"showLabel","iconclass":"iconClass","closable":"closeButton","tooltip":"title","disabled":"disabled","textdir":"textdir"},_50e=function(attr,_50f){return on(_50b,"attrmodified-"+attr,function(evt){var _510=_50c(evt.detail&&evt.detail.widget&&evt.detail.widget.id);if(_510){_510.set(_50f,evt.detail.newValue);}});};for(var attr in _50d){this.own(_50e(attr,_50d[attr]));}},destroy:function(_511){this.destroyDescendants(_511);this.inherited(arguments);},onAddChild:function(page,_512){var Cls=lang.isString(this.buttonWidget)?lang.getObject(this.buttonWidget):this.buttonWidget;var _513=new Cls({id:this.id+"_"+page.id,name:this.id+"_"+page.id,label:page.title,disabled:page.disabled,ownerDocument:this.ownerDocument,dir:page.dir,lang:page.lang,textDir:page.textDir||this.textDir,showLabel:page.showTitle,iconClass:page.iconClass,closeButton:page.closable,title:page.tooltip,page:page});this.addChild(_513,_512);page.controlButton=_513;if(!this._currentChild){this.onSelectChild(page);}var _514=page._wrapper.getAttribute("aria-labelledby")?page._wrapper.getAttribute("aria-labelledby")+" "+_513.id:_513.id;page._wrapper.removeAttribute("aria-label");page._wrapper.setAttribute("aria-labelledby",_514);},onRemoveChild:function(page){if(this._currentChild===page){this._currentChild=null;}var _515=this.pane2button(page.id);if(_515){this.removeChild(_515);_515.destroy();}delete page.controlButton;},onSelectChild:function(page){if(!page){return;}if(this._currentChild){var _516=this.pane2button(this._currentChild.id);_516.set("checked",false);_516.focusNode.setAttribute("tabIndex","-1");}var _517=this.pane2button(page.id);_517.set("checked",true);this._currentChild=page;_517.focusNode.setAttribute("tabIndex","0");var _518=_502.byId(this.containerId);},onButtonClick:function(page){var _519=this.pane2button(page.id);_501.focus(_519.focusNode);if(this._currentChild&&this._currentChild.id===page.id){_519.set("checked",true);}var _51a=_502.byId(this.containerId);_51a.selectChild(page);},onCloseButtonClick:function(page){var _51b=_502.byId(this.containerId);_51b.closeChild(page);if(this._currentChild){var b=this.pane2button(this._currentChild.id);if(b){_501.focus(b.focusNode||b.domNode);}}},adjacent:function(_51c){if(!this.isLeftToRight()&&(!this.tabPosition||/top|bottom/.test(this.tabPosition))){_51c=!_51c;}var _51d=this.getChildren();var idx=_4fc.indexOf(_51d,this.pane2button(this._currentChild.id)),_51e=_51d[idx];var _51f;do{idx=(idx+(_51c?1:_51d.length-1))%_51d.length;_51f=_51d[idx];}while(_51f.disabled&&_51f!=_51e);return _51f;},onkeydown:function(e,_520){if(this.disabled||e.altKey){return;}var _521=null;if(e.ctrlKey||!e._djpage){switch(e.keyCode){case keys.LEFT_ARROW:case keys.UP_ARROW:if(!e._djpage){_521=false;}break;case keys.PAGE_UP:if(e.ctrlKey){_521=false;}break;case keys.RIGHT_ARROW:case keys.DOWN_ARROW:if(!e._djpage){_521=true;}break;case keys.PAGE_DOWN:if(e.ctrlKey){_521=true;}break;case keys.HOME:var _522=this.getChildren();for(var idx=0;idx<_522.length;idx++){var _523=_522[idx];if(!_523.disabled){this.onButtonClick(_523.page);break;}}e.stopPropagation();e.preventDefault();break;case keys.END:var _522=this.getChildren();for(var idx=_522.length-1;idx>=0;idx--){var _523=_522[idx];if(!_523.disabled){this.onButtonClick(_523.page);break;}}e.stopPropagation();e.preventDefault();break;case keys.DELETE:case "W".charCodeAt(0):if(this._currentChild.closable&&(e.keyCode==keys.DELETE||e.ctrlKey)){this.onCloseButtonClick(this._currentChild);}e.stopPropagation();e.preventDefault();break;case keys.TAB:if(e.ctrlKey){this.onButtonClick(this.adjacent(!e.shiftKey).page);e.stopPropagation();e.preventDefault();}break;}if(_521!==null){this.onButtonClick(this.adjacent(_521).page);e.stopPropagation();e.preventDefault();}}},onContainerKeyDown:function(info){info.e._djpage=info.page;this.onkeydown(info.e);}});_508.StackButton=_507;return _508;});},"dojo/dnd/Mover":function(){define(["../_base/array","../_base/declare","../_base/lang","../sniff","../_base/window","../dom","../dom-geometry","../dom-style","../Evented","../on","../touch","./common","./autoscroll"],function(_524,_525,lang,has,win,dom,_526,_527,_528,on,_529,dnd,_52a){return _525("dojo.dnd.Mover",[_528],{constructor:function(node,e,host){this.node=dom.byId(node);this.marginBox={l:e.pageX,t:e.pageY};this.mouseButton=e.button;var h=(this.host=host),d=node.ownerDocument;function _52b(e){e.preventDefault();e.stopPropagation();};this.events=[on(d,_529.move,lang.hitch(this,"onFirstMove")),on(d,_529.move,lang.hitch(this,"onMouseMove")),on(d,_529.release,lang.hitch(this,"onMouseUp")),on(d,"dragstart",_52b),on(d.body,"selectstart",_52b)];_52a.autoScrollStart(d);if(h&&h.onMoveStart){h.onMoveStart(this);}},onMouseMove:function(e){_52a.autoScroll(e);var m=this.marginBox;this.host.onMove(this,{l:m.l+e.pageX,t:m.t+e.pageY},e);e.preventDefault();e.stopPropagation();},onMouseUp:function(e){if(has("webkit")&&has("mac")&&this.mouseButton==2?e.button==0:this.mouseButton==e.button){this.destroy();}e.preventDefault();e.stopPropagation();},onFirstMove:function(e){var s=this.node.style,l,t,h=this.host;switch(s.position){case "relative":case "absolute":l=Math.round(parseFloat(s.left))||0;t=Math.round(parseFloat(s.top))||0;break;default:s.position="absolute";var m=_526.getMarginBox(this.node);var b=win.doc.body;var bs=_527.getComputedStyle(b);var bm=_526.getMarginBox(b,bs);var bc=_526.getContentBox(b,bs);l=m.l-(bc.l-bm.l);t=m.t-(bc.t-bm.t);break;}this.marginBox.l=l-this.marginBox.l;this.marginBox.t=t-this.marginBox.t;if(h&&h.onFirstMove){h.onFirstMove(this,e);}this.events.shift().remove();},destroy:function(){_524.forEach(this.events,function(_52c){_52c.remove();});var h=this.host;if(h&&h.onMoveStop){h.onMoveStop(this);}this.events=this.node=this.host=null;}});});},"dijit/form/HorizontalRule":function(){define(["dojo/_base/declare","../_Widget","../_TemplatedMixin"],function(_52d,_52e,_52f){return _52d("dijit.form.HorizontalRule",[_52e,_52f],{templateString:"<div class=\"dijitRuleContainer dijitRuleContainerH\"></div>",count:3,container:"containerNode",ruleStyle:"",_positionPrefix:"<div class=\"dijitRuleMark dijitRuleMarkH\" style=\"left:",_positionSuffix:"%;",_suffix:"\"></div>",_genHTML:function(pos){return this._positionPrefix+pos+this._positionSuffix+this.ruleStyle+this._suffix;},_isHorizontal:true,buildRendering:function(){this.inherited(arguments);var _530;if(this.count==1){_530=this._genHTML(50,0);}else{var i;var _531=100/(this.count-1);if(!this._isHorizontal||this.isLeftToRight()){_530=this._genHTML(0,0);for(i=1;i<this.count-1;i++){_530+=this._genHTML(_531*i,i);}_530+=this._genHTML(100,this.count-1);}else{_530=this._genHTML(100,0);for(i=1;i<this.count-1;i++){_530+=this._genHTML(100-_531*i,i);}_530+=this._genHTML(0,this.count-1);}}this.domNode.innerHTML=_530;}});});},"dijit/layout/TabContainer":function(){define(["dojo/_base/lang","dojo/_base/declare","./_TabContainerBase","./TabController","./ScrollingTabController"],function(lang,_532,_533,_534,_535){return _532("dijit.layout.TabContainer",_533,{useMenu:true,useSlider:true,controllerWidget:"",_makeController:function(_536){var cls=this.baseClass+"-tabs"+(this.doLayout?"":" dijitTabNoLayout"),_534=typeof this.controllerWidget=="string"?lang.getObject(this.controllerWidget):this.controllerWidget;return new _534({id:this.id+"_tablist",ownerDocument:this.ownerDocument,dir:this.dir,lang:this.lang,textDir:this.textDir,tabPosition:this.tabPosition,doLayout:this.doLayout,containerId:this.id,"class":cls,nested:this.nested,useMenu:this.useMenu,useSlider:this.useSlider,tabStripClass:this.tabStrip?this.baseClass+(this.tabStrip?"":"No")+"Strip":null},_536);},postMixInProperties:function(){this.inherited(arguments);if(!this.controllerWidget){this.controllerWidget=(this.tabPosition=="top"||this.tabPosition=="bottom")&&!this.nested?_535:_534;}}});});},"dijit/form/_Spinner":function(){define(["dojo/_base/declare","dojo/keys","dojo/_base/lang","dojo/sniff","dojo/mouse","dojo/on","../typematic","./RangeBoundTextBox","dojo/text!./templates/Spinner.html","./_TextBoxMixin"],function(_537,keys,lang,has,_538,on,_539,_53a,_53b,_53c){return _537("dijit.form._Spinner",_53a,{defaultTimeout:500,minimumTimeout:10,timeoutChangeRate:0.9,smallDelta:1,largeDelta:10,templateString:_53b,baseClass:"dijitTextBox dijitSpinner",cssStateNodes:{"upArrowNode":"dijitUpArrowButton","downArrowNode":"dijitDownArrowButton"},adjust:function(val){return val;},_arrowPressed:function(_53d,_53e,_53f){if(this.disabled||this.readOnly){return;}this._setValueAttr(this.adjust(this.get("value"),_53e*_53f),false);_53c.selectInputText(this.textbox,this.textbox.value.length);},_arrowReleased:function(){this._wheelTimer=null;},_typematicCallback:function(_540,node,evt){var inc=this.smallDelta;if(node==this.textbox){var key=evt.keyCode;inc=(key==keys.PAGE_UP||key==keys.PAGE_DOWN)?this.largeDelta:this.smallDelta;node=(key==keys.UP_ARROW||key==keys.PAGE_UP)?this.upArrowNode:this.downArrowNode;}if(_540==-1){this._arrowReleased(node);}else{this._arrowPressed(node,(node==this.upArrowNode)?1:-1,inc);}},_wheelTimer:null,_mouseWheeled:function(evt){evt.stopPropagation();evt.preventDefault();var _541=evt.wheelDelta/120;if(Math.floor(_541)!=_541){_541=evt.wheelDelta>0?1:-1;}var _542=evt.detail?(evt.detail*-1):_541;if(_542!==0){var node=this[(_542>0?"upArrowNode":"downArrowNode")];this._arrowPressed(node,_542,this.smallDelta);if(this._wheelTimer){this._wheelTimer.remove();}this._wheelTimer=this.defer(function(){this._arrowReleased(node);},50);}},_setConstraintsAttr:function(_543){this.inherited(arguments);if(this.focusNode){if(this.constraints.min!==undefined){this.focusNode.setAttribute("aria-valuemin",this.constraints.min);}else{this.focusNode.removeAttribute("aria-valuemin");}if(this.constraints.max!==undefined){this.focusNode.setAttribute("aria-valuemax",this.constraints.max);}else{this.focusNode.removeAttribute("aria-valuemax");}}},_setValueAttr:function(_544,_545){this.focusNode.setAttribute("aria-valuenow",_544);this.inherited(arguments);},postCreate:function(){this.inherited(arguments);this.own(on(this.domNode,_538.wheel,lang.hitch(this,"_mouseWheeled")),_539.addListener(this.upArrowNode,this.textbox,{keyCode:keys.UP_ARROW,ctrlKey:false,altKey:false,shiftKey:false,metaKey:false},this,"_typematicCallback",this.timeoutChangeRate,this.defaultTimeout,this.minimumTimeout),_539.addListener(this.downArrowNode,this.textbox,{keyCode:keys.DOWN_ARROW,ctrlKey:false,altKey:false,shiftKey:false,metaKey:false},this,"_typematicCallback",this.timeoutChangeRate,this.defaultTimeout,this.minimumTimeout),_539.addListener(this.upArrowNode,this.textbox,{keyCode:keys.PAGE_UP,ctrlKey:false,altKey:false,shiftKey:false,metaKey:false},this,"_typematicCallback",this.timeoutChangeRate,this.defaultTimeout,this.minimumTimeout),_539.addListener(this.downArrowNode,this.textbox,{keyCode:keys.PAGE_DOWN,ctrlKey:false,altKey:false,shiftKey:false,metaKey:false},this,"_typematicCallback",this.timeoutChangeRate,this.defaultTimeout,this.minimumTimeout));}});});},"dijit/form/Button":function(){define(["require","dojo/_base/declare","dojo/dom-class","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/ready","./_FormWidget","./_ButtonMixin","dojo/text!./templates/Button.html"],function(_546,_547,_548,has,_549,lang,_54a,_54b,_54c,_54d){if(has("dijit-legacy-requires")){_54a(0,function(){var _54e=["dijit/form/DropDownButton","dijit/form/ComboButton","dijit/form/ToggleButton"];_546(_54e);});}var _54f=_547("dijit.form.Button"+(has("dojo-bidi")?"_NoBidi":""),[_54b,_54c],{showLabel:true,iconClass:"dijitNoIcon",_setIconClassAttr:{node:"iconNode",type:"class"},baseClass:"dijitButton",templateString:_54d,_setValueAttr:"valueNode",_setNameAttr:function(name){if(this.valueNode){this.valueNode.setAttribute("name",name);}},_fillContent:function(_550){if(_550&&(!this.params||!("label" in this.params))){var _551=lang.trim(_550.innerHTML);if(_551){this.label=_551;}}},_setShowLabelAttr:function(val){if(this.containerNode){_548.toggle(this.containerNode,"dijitDisplayNone",!val);}this._set("showLabel",val);},setLabel:function(_552){_549.deprecated("dijit.form.Button.setLabel() is deprecated.  Use set('label', ...) instead.","","2.0");this.set("label",_552);},_setLabelAttr:function(_553){this.inherited(arguments);if(!this.showLabel&&!("title" in this.params)){this.titleNode.title=lang.trim(this.containerNode.innerText||this.containerNode.textContent||"");}}});if(has("dojo-bidi")){_54f=_547("dijit.form.Button",_54f,{_setLabelAttr:function(_554){this.inherited(arguments);if(this.titleNode.title){this.applyTextDir(this.titleNode,this.titleNode.title);}},_setTextDirAttr:function(_555){if(this._created&&this.textDir!=_555){this._set("textDir",_555);this._setLabelAttr(this.label);}}});}return _54f;});},"dojo/dnd/move":function(){define(["../_base/declare","../dom-geometry","../dom-style","./common","./Mover","./Moveable"],function(_556,_557,_558,dnd,_559,_55a){var _55b=_556("dojo.dnd.move.constrainedMoveable",_55a,{constraints:function(){},within:false,constructor:function(node,_55c){if(!_55c){_55c={};}this.constraints=_55c.constraints;this.within=_55c.within;},onFirstMove:function(_55d){var c=this.constraintBox=this.constraints.call(this,_55d);c.r=c.l+c.w;c.b=c.t+c.h;if(this.within){var mb=_557.getMarginSize(_55d.node);c.r-=mb.w;c.b-=mb.h;}},onMove:function(_55e,_55f){var c=this.constraintBox,s=_55e.node.style;this.onMoving(_55e,_55f);_55f.l=_55f.l<c.l?c.l:c.r<_55f.l?c.r:_55f.l;_55f.t=_55f.t<c.t?c.t:c.b<_55f.t?c.b:_55f.t;s.left=_55f.l+"px";s.top=_55f.t+"px";this.onMoved(_55e,_55f);}});var _560=_556("dojo.dnd.move.boxConstrainedMoveable",_55b,{box:{},constructor:function(node,_561){var box=_561&&_561.box;this.constraints=function(){return box;};}});var _562=_556("dojo.dnd.move.parentConstrainedMoveable",_55b,{area:"content",constructor:function(node,_563){var area=_563&&_563.area;this.constraints=function(){var n=this.node.parentNode,s=_558.getComputedStyle(n),mb=_557.getMarginBox(n,s);if(area=="margin"){return mb;}var t=_557.getMarginExtents(n,s);mb.l+=t.l,mb.t+=t.t,mb.w-=t.w,mb.h-=t.h;if(area=="border"){return mb;}t=_557.getBorderExtents(n,s);mb.l+=t.l,mb.t+=t.t,mb.w-=t.w,mb.h-=t.h;if(area=="padding"){return mb;}t=_557.getPadExtents(n,s);mb.l+=t.l,mb.t+=t.t,mb.w-=t.w,mb.h-=t.h;return mb;};}});return {constrainedMoveable:_55b,boxConstrainedMoveable:_560,parentConstrainedMoveable:_562};});},"dijit/layout/_TabContainerBase":function(){define(["dojo/text!./templates/TabContainer.html","./StackContainer","./utils","../_TemplatedMixin","dojo/_base/declare","dojo/dom-class","dojo/dom-geometry","dojo/dom-style"],function(_564,_565,_566,_567,_568,_569,_56a,_56b){return _568("dijit.layout._TabContainerBase",[_565,_567],{tabPosition:"top",baseClass:"dijitTabContainer",tabStrip:false,nested:false,templateString:_564,postMixInProperties:function(){this.baseClass+=this.tabPosition.charAt(0).toUpperCase()+this.tabPosition.substr(1).replace(/-.*/,"");this.srcNodeRef&&_56b.set(this.srcNodeRef,"visibility","hidden");this.inherited(arguments);},buildRendering:function(){this.inherited(arguments);this.tablist=this._makeController(this.tablistNode);if(!this.doLayout){_569.add(this.domNode,"dijitTabContainerNoLayout");}if(this.nested){_569.add(this.domNode,"dijitTabContainerNested");_569.add(this.tablist.containerNode,"dijitTabContainerTabListNested");_569.add(this.tablistSpacer,"dijitTabContainerSpacerNested");_569.add(this.containerNode,"dijitTabPaneWrapperNested");}else{_569.add(this.domNode,"tabStrip-"+(this.tabStrip?"enabled":"disabled"));}},_setupChild:function(tab){_569.add(tab.domNode,"dijitTabPane");this.inherited(arguments);},startup:function(){if(this._started){return;}this.tablist.startup();this.inherited(arguments);},layout:function(){if(!this._contentBox||typeof (this._contentBox.l)=="undefined"){return;}var sc=this.selectedChildWidget;if(this.doLayout){var _56c=this.tabPosition.replace(/-h/,"");this.tablist.region=_56c;var _56d=[this.tablist,{domNode:this.tablistSpacer,region:_56c},{domNode:this.containerNode,region:"center"}];_566.layoutChildren(this.domNode,this._contentBox,_56d);this._containerContentBox=_566.marginBox2contentBox(this.containerNode,_56d[2]);if(sc&&sc.resize){sc.resize(this._containerContentBox);}}else{if(this.tablist.resize){var s=this.tablist.domNode.style;s.width="0";var _56e=_56a.getContentBox(this.domNode).w;s.width="";this.tablist.resize({w:_56e});}if(sc&&sc.resize){sc.resize();}}},destroy:function(_56f){if(this.tablist){this.tablist.destroy(_56f);}this.inherited(arguments);}});});},"dijit/form/Form":function(){define(["dojo/_base/declare","dojo/dom-attr","dojo/_base/kernel","dojo/sniff","../_Widget","../_TemplatedMixin","./_FormMixin","../layout/_ContentPaneResizeMixin"],function(_570,_571,_572,has,_573,_574,_575,_576){return _570("dijit.form.Form",[_573,_574,_575,_576],{name:"",action:"",method:"",encType:"","accept-charset":"",accept:"",target:"",templateString:"<form data-dojo-attach-point='containerNode' data-dojo-attach-event='onreset:_onReset,onsubmit:_onSubmit' ${!nameAttrSetting}></form>",postMixInProperties:function(){this.nameAttrSetting=this.name?("name='"+this.name+"'"):"";this.inherited(arguments);},execute:function(){},onExecute:function(){},_setEncTypeAttr:function(_577){_571.set(this.domNode,"encType",_577);if(has("ie")){this.domNode.encoding=_577;}this._set("encType",_577);},reset:function(e){var faux={returnValue:true,preventDefault:function(){this.returnValue=false;},stopPropagation:function(){},currentTarget:e?e.target:this.domNode,target:e?e.target:this.domNode};if(!(this.onReset(faux)===false)&&faux.returnValue){this.inherited(arguments,[]);}},onReset:function(){return true;},_onReset:function(e){this.reset(e);e.stopPropagation();e.preventDefault();return false;},_onSubmit:function(e){var fp=this.constructor.prototype;if(this.execute!=fp.execute||this.onExecute!=fp.onExecute){_572.deprecated("dijit.form.Form:execute()/onExecute() are deprecated. Use onSubmit() instead.","","2.0");this.onExecute();this.execute(this.getValues());}if(this.onSubmit(e)===false){e.stopPropagation();e.preventDefault();}},onSubmit:function(){return this.isValid();},submit:function(){if(!(this.onSubmit()===false)){this.containerNode.submit();}}});});},"dojo/store/Memory":function(){define(["../_base/declare","./util/QueryResults","./util/SimpleQueryEngine"],function(_578,_579,_57a){var base=null;return _578("dojo.store.Memory",base,{constructor:function(_57b){for(var i in _57b){this[i]=_57b[i];}this.setData(this.data||[]);},data:null,idProperty:"id",index:null,queryEngine:_57a,get:function(id){return this.data[this.index[id]];},getIdentity:function(_57c){return _57c[this.idProperty];},put:function(_57d,_57e){var data=this.data,_57f=this.index,_580=this.idProperty;var id=_57d[_580]=(_57e&&"id" in _57e)?_57e.id:_580 in _57d?_57d[_580]:Math.random();if(id in _57f){if(_57e&&_57e.overwrite===false){throw new Error("Object already exists");}data[_57f[id]]=_57d;}else{_57f[id]=data.push(_57d)-1;}return id;},add:function(_581,_582){(_582=_582||{}).overwrite=false;return this.put(_581,_582);},remove:function(id){var _583=this.index;var data=this.data;if(id in _583){data.splice(_583[id],1);this.setData(data);return true;}},query:function(_584,_585){return _579(this.queryEngine(_584,_585)(this.data));},setData:function(data){if(data.items){this.idProperty=data.identifier;data=this.data=data.items;}else{this.data=data;}this.index={};for(var i=0,l=data.length;i<l;i++){this.index[data[i][this.idProperty]]=i;}}});});},"dijit/Editor":function(){define(["require","dojo/_base/array","dojo/_base/declare","dojo/Deferred","dojo/i18n","dojo/dom-attr","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/keys","dojo/_base/lang","dojo/sniff","dojo/string","dojo/topic","./_Container","./Toolbar","./ToolbarSeparator","./layout/_LayoutWidget","./form/ToggleButton","./_editor/_Plugin","./_editor/plugins/EnterKeyHandling","./_editor/html","./_editor/range","./_editor/RichText","./main","dojo/i18n!./_editor/nls/commands"],function(_586,_587,_588,_589,i18n,_58a,_58b,_58c,_58d,keys,lang,has,_58e,_58f,_590,_591,_592,_593,_594,_595,_596,html,_597,_598,_599){var _59a=_588("dijit.Editor",_598,{plugins:null,extraPlugins:null,constructor:function(){if(!lang.isArray(this.plugins)){this.plugins=["undo","redo","|","cut","copy","paste","|","bold","italic","underline","strikethrough","|","insertOrderedList","insertUnorderedList","indent","outdent","|","justifyLeft","justifyRight","justifyCenter","justifyFull",_596];}this._plugins=[];this._editInterval=this.editActionInterval*1000;if(has("ie")){this.events.push("onBeforeDeactivate");this.events.push("onBeforeActivate");}},postMixInProperties:function(){this.setValueDeferred=new _589();this.inherited(arguments);},postCreate:function(){this.inherited(arguments);this._steps=this._steps.slice(0);this._undoedSteps=this._undoedSteps.slice(0);if(lang.isArray(this.extraPlugins)){this.plugins=this.plugins.concat(this.extraPlugins);}this.commands=i18n.getLocalization("dijit._editor","commands",this.lang);if(has("webkit")){_58d.set(this.domNode,"KhtmlUserSelect","none");}},startup:function(){this.inherited(arguments);if(!this.toolbar){this.toolbar=new _591({ownerDocument:this.ownerDocument,dir:this.dir,lang:this.lang,"aria-label":this.id});this.header.appendChild(this.toolbar.domNode);}_587.forEach(this.plugins,this.addPlugin,this);this.setValueDeferred.resolve(true);_58b.add(this.iframe.parentNode,"dijitEditorIFrameContainer");_58b.add(this.iframe,"dijitEditorIFrame");_58a.set(this.iframe,"allowTransparency",true);this.toolbar.startup();this.onNormalizedDisplayChanged();},destroy:function(){_587.forEach(this._plugins,function(p){if(p&&p.destroy){p.destroy();}});this._plugins=[];this.toolbar.destroyRecursive();delete this.toolbar;this.inherited(arguments);},addPlugin:function(_59b,_59c){var args=lang.isString(_59b)?{name:_59b}:lang.isFunction(_59b)?{ctor:_59b}:_59b;if(!args.setEditor){var o={"args":args,"plugin":null,"editor":this};if(args.name){if(_595.registry[args.name]){o.plugin=_595.registry[args.name](args);}else{_58f.publish(_599._scopeName+".Editor.getPlugin",o);}}if(!o.plugin){try{var pc=args.ctor||lang.getObject(args.name)||_586(args.name);if(pc){o.plugin=new pc(args);}}catch(e){throw new Error(this.id+": cannot find plugin ["+args.name+"]");}}if(!o.plugin){throw new Error(this.id+": cannot find plugin ["+args.name+"]");}_59b=o.plugin;}if(arguments.length>1){this._plugins[_59c]=_59b;}else{this._plugins.push(_59b);}_59b.setEditor(this);if(lang.isFunction(_59b.setToolbar)){_59b.setToolbar(this.toolbar);}},resize:function(size){if(size){_593.prototype.resize.apply(this,arguments);}},layout:function(){var _59d=(this._contentBox.h-(this.getHeaderHeight()+this.getFooterHeight()+_58c.getPadBorderExtents(this.iframe.parentNode).h+_58c.getMarginExtents(this.iframe.parentNode).h));this.editingArea.style.height=_59d+"px";if(this.iframe){this.iframe.style.height="100%";}this._layoutMode=true;},_onIEMouseDown:function(e){var _59e;var b=this.document.body;var _59f=b.clientWidth;var _5a0=b.clientHeight;var _5a1=b.clientLeft;var _5a2=b.offsetWidth;var _5a3=b.offsetHeight;var _5a4=b.offsetLeft;if(/^rtl$/i.test(b.dir||"")){if(_59f<_5a2&&e.x>_59f&&e.x<_5a2){_59e=true;}}else{if(e.x<_5a1&&e.x>_5a4){_59e=true;}}if(!_59e){if(_5a0<_5a3&&e.y>_5a0&&e.y<_5a3){_59e=true;}}if(!_59e){delete this._cursorToStart;delete this._savedSelection;if(e.target.tagName=="BODY"){this.defer("placeCursorAtEnd");}this.inherited(arguments);}},onBeforeActivate:function(){this._restoreSelection();},onBeforeDeactivate:function(e){if(this.customUndo){this.endEditing(true);}if(e.target.tagName!="BODY"){this._saveSelection();}},customUndo:true,editActionInterval:3,beginEditing:function(cmd){if(!this._inEditing){this._inEditing=true;this._beginEditing(cmd);}if(this.editActionInterval>0){if(this._editTimer){this._editTimer.remove();}this._editTimer=this.defer("endEditing",this._editInterval);}},_steps:[],_undoedSteps:[],execCommand:function(cmd){if(this.customUndo&&(cmd=="undo"||cmd=="redo")){return this[cmd]();}else{if(this.customUndo){this.endEditing();this._beginEditing();}var r=this.inherited(arguments);if(this.customUndo){this._endEditing();}return r;}},_pasteImpl:function(){return this._clipboardCommand("paste");},_cutImpl:function(){return this._clipboardCommand("cut");},_copyImpl:function(){return this._clipboardCommand("copy");},_clipboardCommand:function(cmd){var r;try{r=this.document.execCommand(cmd,false,null);if(has("webkit")&&!r){throw {code:1011};}}catch(e){if(e.code==1011||(e.code==9&&has("opera"))){var sub=_58e.substitute,_5a5={cut:"X",copy:"C",paste:"V"};alert(sub(this.commands.systemShortcut,[this.commands[cmd],sub(this.commands[has("mac")?"appleKey":"ctrlKey"],[_5a5[cmd]])]));}r=false;}return r;},queryCommandEnabled:function(cmd){if(this.customUndo&&(cmd=="undo"||cmd=="redo")){return cmd=="undo"?(this._steps.length>1):(this._undoedSteps.length>0);}else{return this.inherited(arguments);}},_moveToBookmark:function(b){var _5a6=b.mark;var mark=b.mark;var col=b.isCollapsed;var r,_5a7,_5a8,sel;if(mark){if(has("ie")<9||(has("ie")===9&&has("quirks"))){if(lang.isArray(mark)){_5a6=[];_587.forEach(mark,function(n){_5a6.push(_597.getNode(n,this.editNode));},this);this.selection.moveToBookmark({mark:_5a6,isCollapsed:col});}else{if(mark.startContainer&&mark.endContainer){sel=_597.getSelection(this.window);if(sel&&sel.removeAllRanges){sel.removeAllRanges();r=_597.create(this.window);_5a7=_597.getNode(mark.startContainer,this.editNode);_5a8=_597.getNode(mark.endContainer,this.editNode);if(_5a7&&_5a8){r.setStart(_5a7,mark.startOffset);r.setEnd(_5a8,mark.endOffset);sel.addRange(r);}}}}}else{sel=_597.getSelection(this.window);if(sel&&sel.removeAllRanges){sel.removeAllRanges();r=_597.create(this.window);_5a7=_597.getNode(mark.startContainer,this.editNode);_5a8=_597.getNode(mark.endContainer,this.editNode);if(_5a7&&_5a8){r.setStart(_5a7,mark.startOffset);r.setEnd(_5a8,mark.endOffset);sel.addRange(r);}}}}},_changeToStep:function(from,to){this.setValue(to.text);var b=to.bookmark;if(!b){return;}this._moveToBookmark(b);},undo:function(){var ret=false;if(!this._undoRedoActive){this._undoRedoActive=true;this.endEditing(true);var s=this._steps.pop();if(s&&this._steps.length>0){this.focus();this._changeToStep(s,this._steps[this._steps.length-1]);this._undoedSteps.push(s);this.onDisplayChanged();delete this._undoRedoActive;ret=true;}delete this._undoRedoActive;}return ret;},redo:function(){var ret=false;if(!this._undoRedoActive){this._undoRedoActive=true;this.endEditing(true);var s=this._undoedSteps.pop();if(s&&this._steps.length>0){this.focus();this._changeToStep(this._steps[this._steps.length-1],s);this._steps.push(s);this.onDisplayChanged();ret=true;}delete this._undoRedoActive;}return ret;},endEditing:function(_5a9){if(this._editTimer){this._editTimer=this._editTimer.remove();}if(this._inEditing){this._endEditing(_5a9);this._inEditing=false;}},_getBookmark:function(){var b=this.selection.getBookmark();var tmp=[];if(b&&b.mark){var mark=b.mark;if(has("ie")<9||(has("ie")===9&&has("quirks"))){var sel=_597.getSelection(this.window);if(!lang.isArray(mark)){if(sel){var _5aa;if(sel.rangeCount){_5aa=sel.getRangeAt(0);}if(_5aa){b.mark=_5aa.cloneRange();}else{b.mark=this.selection.getBookmark();}}}else{_587.forEach(b.mark,function(n){tmp.push(_597.getIndex(n,this.editNode).o);},this);b.mark=tmp;}}try{if(b.mark&&b.mark.startContainer){tmp=_597.getIndex(b.mark.startContainer,this.editNode).o;b.mark={startContainer:tmp,startOffset:b.mark.startOffset,endContainer:b.mark.endContainer===b.mark.startContainer?tmp:_597.getIndex(b.mark.endContainer,this.editNode).o,endOffset:b.mark.endOffset};}}catch(e){b.mark=null;}}return b;},_beginEditing:function(){if(this._steps.length===0){this._steps.push({"text":html.getChildrenHtml(this.editNode),"bookmark":this._getBookmark()});}},_endEditing:function(){var v=html.getChildrenHtml(this.editNode);this._undoedSteps=[];this._steps.push({text:v,bookmark:this._getBookmark()});},onKeyDown:function(e){if(!has("ie")&&!this.iframe&&e.keyCode==keys.TAB&&!this.tabIndent){this._saveSelection();}if(!this.customUndo){this.inherited(arguments);return;}var k=e.keyCode;if(e.ctrlKey&&!e.shiftKey&&!e.altKey){if(k==90||k==122){e.stopPropagation();e.preventDefault();this.undo();return;}else{if(k==89||k==121){e.stopPropagation();e.preventDefault();this.redo();return;}}}this.inherited(arguments);switch(k){case keys.ENTER:case keys.BACKSPACE:case keys.DELETE:this.beginEditing();break;case 88:case 86:if(e.ctrlKey&&!e.altKey&&!e.metaKey){this.endEditing();if(e.keyCode==88){this.beginEditing("cut");}else{this.beginEditing("paste");}this.defer("endEditing",1);break;}default:if(!e.ctrlKey&&!e.altKey&&!e.metaKey&&(e.keyCode<keys.F1||e.keyCode>keys.F15)){this.beginEditing();break;}case keys.ALT:this.endEditing();break;case keys.UP_ARROW:case keys.DOWN_ARROW:case keys.LEFT_ARROW:case keys.RIGHT_ARROW:case keys.HOME:case keys.END:case keys.PAGE_UP:case keys.PAGE_DOWN:this.endEditing(true);break;case keys.CTRL:case keys.SHIFT:case keys.TAB:break;}},_onBlur:function(){this.inherited(arguments);this.endEditing(true);},_saveSelection:function(){try{this._savedSelection=this._getBookmark();}catch(e){}},_restoreSelection:function(){if(this._savedSelection){delete this._cursorToStart;if(this.selection.isCollapsed()){this._moveToBookmark(this._savedSelection);}delete this._savedSelection;}},onClick:function(){this.endEditing(true);this.inherited(arguments);},replaceValue:function(html){if(!this.customUndo){this.inherited(arguments);}else{if(this.isClosed){this.setValue(html);}else{this.beginEditing();if(!html){html="&#160;";}this.setValue(html);this.endEditing();}}},_setDisabledAttr:function(_5ab){this.setValueDeferred.then(lang.hitch(this,function(){if((!this.disabled&&_5ab)||(!this._buttonEnabledPlugins&&_5ab)){_587.forEach(this._plugins,function(p){p.set("disabled",true);});}else{if(this.disabled&&!_5ab){_587.forEach(this._plugins,function(p){p.set("disabled",false);});}}}));this.inherited(arguments);},_setStateClass:function(){try{this.inherited(arguments);if(this.document&&this.document.body){_58d.set(this.document.body,"color",_58d.get(this.iframe,"color"));}}catch(e){}}});function _5ac(args){return new _595({command:args.name});};function _5ad(args){return new _595({buttonClass:_594,command:args.name});};lang.mixin(_595.registry,{"undo":_5ac,"redo":_5ac,"cut":_5ac,"copy":_5ac,"paste":_5ac,"insertOrderedList":_5ac,"insertUnorderedList":_5ac,"indent":_5ac,"outdent":_5ac,"justifyCenter":_5ac,"justifyFull":_5ac,"justifyLeft":_5ac,"justifyRight":_5ac,"delete":_5ac,"selectAll":_5ac,"removeFormat":_5ac,"unlink":_5ac,"insertHorizontalRule":_5ac,"bold":_5ad,"italic":_5ad,"underline":_5ad,"strikethrough":_5ad,"subscript":_5ad,"superscript":_5ad,"|":function(){return new _595({setEditor:function(_5ae){this.editor=_5ae;this.button=new _592({ownerDocument:_5ae.ownerDocument});}});}});return _59a;});},"dijit/Toolbar":function(){define(["require","dojo/_base/declare","dojo/has","dojo/keys","dojo/ready","./_Widget","./_KeyNavContainer","./_TemplatedMixin"],function(_5af,_5b0,has,keys,_5b1,_5b2,_5b3,_5b4){if(has("dijit-legacy-requires")){_5b1(0,function(){var _5b5=["dijit/ToolbarSeparator"];_5af(_5b5);});}return _5b0("dijit.Toolbar",[_5b2,_5b4,_5b3],{templateString:"<div class=\"dijit\" role=\"toolbar\" tabIndex=\"${tabIndex}\" data-dojo-attach-point=\"containerNode\">"+"</div>",baseClass:"dijitToolbar",_onLeftArrow:function(){this.focusPrev();},_onRightArrow:function(){this.focusNext();}});});},"dijit/layout/StackContainer":function(){define(["dojo/_base/array","dojo/cookie","dojo/_base/declare","dojo/dom-class","dojo/dom-construct","dojo/has","dojo/_base/lang","dojo/on","dojo/ready","dojo/topic","dojo/when","../registry","../_WidgetBase","./_LayoutWidget","dojo/i18n!../nls/common"],function(_5b6,_5b7,_5b8,_5b9,_5ba,has,lang,on,_5bb,_5bc,when,_5bd,_5be,_5bf){if(has("dijit-legacy-requires")){_5bb(0,function(){var _5c0=["dijit/layout/StackController"];require(_5c0);});}var _5c1=_5b8("dijit.layout.StackContainer",_5bf,{doLayout:true,persist:false,baseClass:"dijitStackContainer",buildRendering:function(){this.inherited(arguments);_5b9.add(this.domNode,"dijitLayoutContainer");},postCreate:function(){this.inherited(arguments);this.own(on(this.domNode,"keydown",lang.hitch(this,"_onKeyDown")));},startup:function(){if(this._started){return;}var _5c2=this.getChildren();_5b6.forEach(_5c2,this._setupChild,this);if(this.persist){this.selectedChildWidget=_5bd.byId(_5b7(this.id+"_selectedChild"));}else{_5b6.some(_5c2,function(_5c3){if(_5c3.selected){this.selectedChildWidget=_5c3;}return _5c3.selected;},this);}var _5c4=this.selectedChildWidget;if(!_5c4&&_5c2[0]){_5c4=this.selectedChildWidget=_5c2[0];_5c4.selected=true;}_5bc.publish(this.id+"-startup",{children:_5c2,selected:_5c4,textDir:this.textDir});this.inherited(arguments);},resize:function(){if(!this._hasBeenShown){this._hasBeenShown=true;var _5c5=this.selectedChildWidget;if(_5c5){this._showChild(_5c5);}}this.inherited(arguments);},_setupChild:function(_5c6){var _5c7=_5c6.domNode,_5c8=_5ba.place("<div role='tabpanel' class='"+this.baseClass+"ChildWrapper dijitHidden'>",_5c6.domNode,"replace"),_5c9=_5c6["aria-label"]||_5c6.title||_5c6.label;if(_5c9){_5c8.setAttribute("aria-label",_5c9);}_5ba.place(_5c7,_5c8);_5c6._wrapper=_5c8;this.inherited(arguments);if(_5c7.style.display=="none"){_5c7.style.display="block";}_5c6.domNode.title="";},addChild:function(_5ca,_5cb){this.inherited(arguments);if(this._started){_5bc.publish(this.id+"-addChild",_5ca,_5cb);this.layout();if(!this.selectedChildWidget){this.selectChild(_5ca);}}},removeChild:function(page){var idx=_5b6.indexOf(this.getChildren(),page);this.inherited(arguments);_5ba.destroy(page._wrapper);delete page._wrapper;if(this._started){_5bc.publish(this.id+"-removeChild",page);}if(this._descendantsBeingDestroyed){return;}if(this.selectedChildWidget===page){this.selectedChildWidget=undefined;if(this._started){var _5cc=this.getChildren();if(_5cc.length){this.selectChild(_5cc[Math.max(idx-1,0)]);}}}if(this._started){this.layout();}},selectChild:function(page,_5cd){var d;page=_5bd.byId(page);if(this.selectedChildWidget!=page){d=this._transition(page,this.selectedChildWidget,_5cd);this._set("selectedChildWidget",page);_5bc.publish(this.id+"-selectChild",page);if(this.persist){_5b7(this.id+"_selectedChild",this.selectedChildWidget.id);}}return when(d||true);},_transition:function(_5ce,_5cf){if(_5cf){this._hideChild(_5cf);}var d=this._showChild(_5ce);if(_5ce.resize){if(this.doLayout){_5ce.resize(this._containerContentBox||this._contentBox);}else{_5ce.resize();}}return d;},_adjacent:function(_5d0){var _5d1=this.getChildren();var _5d2=_5b6.indexOf(_5d1,this.selectedChildWidget);_5d2+=_5d0?1:_5d1.length-1;return _5d1[_5d2%_5d1.length];},forward:function(){return this.selectChild(this._adjacent(true),true);},back:function(){return this.selectChild(this._adjacent(false),true);},_onKeyDown:function(e){_5bc.publish(this.id+"-containerKeyDown",{e:e,page:this});},layout:function(){var _5d3=this.selectedChildWidget;if(_5d3&&_5d3.resize){if(this.doLayout){_5d3.resize(this._containerContentBox||this._contentBox);}else{_5d3.resize();}}},_showChild:function(page){var _5d4=this.getChildren();page.isFirstChild=(page==_5d4[0]);page.isLastChild=(page==_5d4[_5d4.length-1]);page._set("selected",true);if(page._wrapper){_5b9.replace(page._wrapper,"dijitVisible","dijitHidden");}return (page._onShow&&page._onShow())||true;},_hideChild:function(page){page._set("selected",false);if(page._wrapper){_5b9.replace(page._wrapper,"dijitHidden","dijitVisible");}page.onHide&&page.onHide();},closeChild:function(page){var _5d5=page.onClose&&page.onClose(this,page);if(_5d5){this.removeChild(page);page.destroyRecursive();}},destroyDescendants:function(_5d6){this._descendantsBeingDestroyed=true;this.selectedChildWidget=undefined;_5b6.forEach(this.getChildren(),function(_5d7){if(!_5d6){this.removeChild(_5d7);}_5d7.destroyRecursive(_5d6);},this);this._descendantsBeingDestroyed=false;}});_5c1.ChildWidgetProperties={selected:false,disabled:false,closable:false,iconClass:"dijitNoIcon",showTitle:true};lang.extend(_5be,_5c1.ChildWidgetProperties);return _5c1;});},"dojo/regexp":function(){define(["./_base/kernel","./_base/lang"],function(dojo,lang){var _5d8={};lang.setObject("dojo.regexp",_5d8);_5d8.escapeString=function(str,_5d9){return str.replace(/([\.$?*|{}\(\)\[\]\\\/\+^])/g,function(ch){if(_5d9&&_5d9.indexOf(ch)!=-1){return ch;}return "\\"+ch;});};_5d8.buildGroupRE=function(arr,re,_5da){if(!(arr instanceof Array)){return re(arr);}var b=[];for(var i=0;i<arr.length;i++){b.push(re(arr[i]));}return _5d8.group(b.join("|"),_5da);};_5d8.group=function(_5db,_5dc){return "("+(_5dc?"?:":"")+_5db+")";};return _5d8;});},"dijit/form/ComboBox":function(){define(["dojo/_base/declare","./ValidationTextBox","./ComboBoxMixin"],function(_5dd,_5de,_5df){return _5dd("dijit.form.ComboBox",[_5de,_5df],{});});},"dijit/_editor/plugins/LinkDialog":function(){define(["require","dojo/_base/declare","dojo/dom-attr","dojo/keys","dojo/_base/lang","dojo/on","dojo/sniff","dojo/query","dojo/string","../../_Widget","../_Plugin","../../form/DropDownButton","../range"],function(_5e0,_5e1,_5e2,keys,lang,on,has,_5e3,_5e4,_5e5,_5e6,_5e7,_5e8){var _5e9=_5e1("dijit._editor.plugins.LinkDialog",_5e6,{buttonClass:_5e7,useDefaultCommand:false,urlRegExp:"((https?|ftps?|file)\\://|./|../|/|)(/[a-zA-Z]{1,1}:/|)(((?:(?:[\\da-zA-Z](?:[-\\da-zA-Z]{0,61}[\\da-zA-Z])?)\\.)*(?:[a-zA-Z](?:[-\\da-zA-Z]{0,80}[\\da-zA-Z])?)\\.?)|(((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){3}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])|(0[xX]0*[\\da-fA-F]?[\\da-fA-F]\\.){3}0[xX]0*[\\da-fA-F]?[\\da-fA-F]|(0+[0-3][0-7][0-7]\\.){3}0+[0-3][0-7][0-7]|(0|[1-9]\\d{0,8}|[1-3]\\d{9}|4[01]\\d{8}|42[0-8]\\d{7}|429[0-3]\\d{6}|4294[0-8]\\d{5}|42949[0-5]\\d{4}|429496[0-6]\\d{3}|4294967[01]\\d{2}|42949672[0-8]\\d|429496729[0-5])|0[xX]0*[\\da-fA-F]{1,8}|([\\da-fA-F]{1,4}\\:){7}[\\da-fA-F]{1,4}|([\\da-fA-F]{1,4}\\:){6}((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){3}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])))(\\:\\d+)?(/(?:[^?#\\s/]+/)*(?:[^?#\\s/]{0,}(?:\\?[^?#\\s/]*)?(?:#.*)?)?)?",emailRegExp:"<?(mailto\\:)([!#-'*+\\-\\/-9=?A-Z^-~]+[.])*[!#-'*+\\-\\/-9=?A-Z^-~]+"+"@"+"((?:(?:[\\da-zA-Z](?:[-\\da-zA-Z]{0,61}[\\da-zA-Z])?)\\.)+(?:[a-zA-Z](?:[-\\da-zA-Z]{0,6}[\\da-zA-Z])?)\\.?)|localhost|^[^-][a-zA-Z0-9_-]*>?",htmlTemplate:"<a href=\"${urlInput}\" _djrealurl=\"${urlInput}\""+" target=\"${targetSelect}\""+">${textInput}</a>",tag:"a",_hostRxp:/^((([^\[:]+):)?([^@]+)@)?(\[([^\]]+)\]|([^\[:]*))(:([0-9]+))?$/,_userAtRxp:/^([!#-'*+\-\/-9=?A-Z^-~]+[.])*[!#-'*+\-\/-9=?A-Z^-~]+@/i,linkDialogTemplate:["<table role='presentation'><tr><td>","<label for='${id}_urlInput'>${url}</label>","</td><td>","<input data-dojo-type='dijit.form.ValidationTextBox' required='true' "+"id='${id}_urlInput' name='urlInput' data-dojo-props='intermediateChanges:true'/>","</td></tr><tr><td>","<label for='${id}_textInput'>${text}</label>","</td><td>","<input data-dojo-type='dijit.form.ValidationTextBox' required='true' id='${id}_textInput' "+"name='textInput' data-dojo-props='intermediateChanges:true'/>","</td></tr><tr><td>","<label for='${id}_targetSelect'>${target}</label>","</td><td>","<select id='${id}_targetSelect' name='targetSelect' data-dojo-type='dijit.form.Select'>","<option selected='selected' value='_self'>${currentWindow}</option>","<option value='_blank'>${newWindow}</option>","<option value='_top'>${topWindow}</option>","<option value='_parent'>${parentWindow}</option>","</select>","</td></tr><tr><td colspan='2'>","<button data-dojo-type='dijit.form.Button' type='submit' id='${id}_setButton'>${set}</button>","<button data-dojo-type='dijit.form.Button' type='button' id='${id}_cancelButton'>${buttonCancel}</button>","</td></tr></table>"].join(""),_initButton:function(){this.inherited(arguments);this.button.loadDropDown=lang.hitch(this,"_loadDropDown");this._connectTagEvents();},_loadDropDown:function(_5ea){_5e0(["dojo/i18n","../../TooltipDialog","../../registry","../../form/Button","../../form/Select","../../form/ValidationTextBox","dojo/i18n!../../nls/common","dojo/i18n!../nls/LinkDialog"],lang.hitch(this,function(i18n,_5eb,_5ec){var _5ed=this;this.tag=this.command=="insertImage"?"img":"a";var _5ee=lang.delegate(i18n.getLocalization("dijit","common",this.lang),i18n.getLocalization("dijit._editor","LinkDialog",this.lang));var _5ef=(this.dropDown=this.button.dropDown=new _5eb({title:_5ee[this.command+"Title"],ownerDocument:this.editor.ownerDocument,dir:this.editor.dir,execute:lang.hitch(this,"setValue"),onOpen:function(){_5ed._onOpenDialog();_5eb.prototype.onOpen.apply(this,arguments);},onCancel:function(){setTimeout(lang.hitch(_5ed,"_onCloseDialog"),0);}}));_5ee.urlRegExp=this.urlRegExp;_5ee.id=_5ec.getUniqueId(this.editor.id);this._uniqueId=_5ee.id;this._setContent(_5ef.title+"<div style='border-bottom: 1px black solid;padding-bottom:2pt;margin-bottom:4pt'></div>"+_5e4.substitute(this.linkDialogTemplate,_5ee));_5ef.startup();this._urlInput=_5ec.byId(this._uniqueId+"_urlInput");this._textInput=_5ec.byId(this._uniqueId+"_textInput");this._setButton=_5ec.byId(this._uniqueId+"_setButton");this.own(_5ec.byId(this._uniqueId+"_cancelButton").on("click",lang.hitch(this.dropDown,"onCancel")));if(this._urlInput){this.own(this._urlInput.on("change",lang.hitch(this,"_checkAndFixInput")));}if(this._textInput){this.own(this._textInput.on("change",lang.hitch(this,"_checkAndFixInput")));}this._urlRegExp=new RegExp("^"+this.urlRegExp+"$","i");this._emailRegExp=new RegExp("^"+this.emailRegExp+"$","i");this._urlInput.isValid=lang.hitch(this,function(){var _5f0=this._urlInput.get("value");return this._urlRegExp.test(_5f0)||this._emailRegExp.test(_5f0);});this.own(on(_5ef.domNode,"keydown",lang.hitch(this,lang.hitch(this,function(e){if(e&&e.keyCode==keys.ENTER&&!e.shiftKey&&!e.metaKey&&!e.ctrlKey&&!e.altKey){if(!this._setButton.get("disabled")){_5ef.onExecute();_5ef.execute(_5ef.get("value"));}}}))));_5ea();}));},_checkAndFixInput:function(){var self=this;var url=this._urlInput.get("value");var _5f1=function(url){var _5f2=false;var _5f3=false;if(url&&url.length>1){url=lang.trim(url);if(url.indexOf("mailto:")!==0){if(url.indexOf("/")>0){if(url.indexOf("://")===-1){if(url.charAt(0)!=="/"&&url.indexOf("./")&&url.indexOf("../")!==0){if(self._hostRxp.test(url)){_5f2=true;}}}}else{if(self._userAtRxp.test(url)){_5f3=true;}}}}if(_5f2){self._urlInput.set("value","http://"+url);}if(_5f3){self._urlInput.set("value","mailto:"+url);}self._setButton.set("disabled",!self._isValid());};if(this._delayedCheck){clearTimeout(this._delayedCheck);this._delayedCheck=null;}this._delayedCheck=setTimeout(function(){_5f1(url);},250);},_connectTagEvents:function(){this.editor.onLoadDeferred.then(lang.hitch(this,function(){this.own(on(this.editor.editNode,"dblclick",lang.hitch(this,"_onDblClick")));}));},_isValid:function(){return this._urlInput.isValid()&&this._textInput.isValid();},_setContent:function(_5f4){this.dropDown.set({parserScope:"dojo",content:_5f4});},_checkValues:function(args){if(args&&args.urlInput){args.urlInput=args.urlInput.replace(/"/g,"&quot;");}return args;},setValue:function(args){this._onCloseDialog();if(has("ie")<9){var sel=_5e8.getSelection(this.editor.window);var _5f5=sel.getRangeAt(0);var a=_5f5.endContainer;if(a.nodeType===3){a=a.parentNode;}if(a&&(a.nodeName&&a.nodeName.toLowerCase()!==this.tag)){a=this.editor.selection.getSelectedElement(this.tag);}if(a&&(a.nodeName&&a.nodeName.toLowerCase()===this.tag)){if(this.editor.queryCommandEnabled("unlink")){this.editor.selection.selectElementChildren(a);this.editor.execCommand("unlink");}}}args=this._checkValues(args);this.editor.execCommand("inserthtml",_5e4.substitute(this.htmlTemplate,args));_5e3("a",this.editor.document).forEach(function(a){if(!a.innerHTML&&!_5e2.has(a,"name")){a.parentNode.removeChild(a);}},this);},_onCloseDialog:function(){if(this.editor.focused){this.editor.focus();}},_getCurrentValues:function(a){var url,text,_5f6;if(a&&a.tagName.toLowerCase()===this.tag){url=a.getAttribute("_djrealurl")||a.getAttribute("href");_5f6=a.getAttribute("target")||"_self";text=a.textContent||a.innerText;this.editor.selection.selectElement(a,true);}else{text=this.editor.selection.getSelectedText();}return {urlInput:url||"",textInput:text||"",targetSelect:_5f6||""};},_onOpenDialog:function(){var a,b,fc;if(has("ie")){var sel=_5e8.getSelection(this.editor.window);if(sel.rangeCount){var _5f7=sel.getRangeAt(0);a=_5f7.endContainer;if(a.nodeType===3){a=a.parentNode;}if(a&&(a.nodeName&&a.nodeName.toLowerCase()!==this.tag)){a=this.editor.selection.getSelectedElement(this.tag);}if(!a||(a.nodeName&&a.nodeName.toLowerCase()!==this.tag)){b=this.editor.selection.getAncestorElement(this.tag);if(b&&(b.nodeName&&b.nodeName.toLowerCase()==this.tag)){a=b;this.editor.selection.selectElement(a);}else{if(_5f7.startContainer===_5f7.endContainer){fc=_5f7.startContainer.firstChild;if(fc&&(fc.nodeName&&fc.nodeName.toLowerCase()==this.tag)){a=fc;this.editor.selection.selectElement(a);}}}}}}else{a=this.editor.selection.getAncestorElement(this.tag);}this.dropDown.reset();this._setButton.set("disabled",true);this.dropDown.set("value",this._getCurrentValues(a));},_onDblClick:function(e){if(e&&e.target){var t=e.target;var tg=t.tagName?t.tagName.toLowerCase():"";if(tg===this.tag&&_5e2.get(t,"href")){var _5f8=this.editor;this.editor.selection.selectElement(t);_5f8.onDisplayChanged();if(_5f8._updateTimer){_5f8._updateTimer.remove();delete _5f8._updateTimer;}_5f8.onNormalizedDisplayChanged();var _5f9=this.button;setTimeout(function(){_5f9.set("disabled",false);_5f9.loadAndOpenDropDown().then(function(){if(_5f9.dropDown.focus){_5f9.dropDown.focus();}});},10);}}}});var _5fa=_5e1("dijit._editor.plugins.ImgLinkDialog",[_5e9],{linkDialogTemplate:["<table role='presentation'><tr><td>","<label for='${id}_urlInput'>${url}</label>","</td><td>","<input dojoType='dijit.form.ValidationTextBox' regExp='${urlRegExp}' "+"required='true' id='${id}_urlInput' name='urlInput' data-dojo-props='intermediateChanges:true'/>","</td></tr><tr><td>","<label for='${id}_textInput'>${text}</label>","</td><td>","<input data-dojo-type='dijit.form.ValidationTextBox' required='false' id='${id}_textInput' "+"name='textInput' data-dojo-props='intermediateChanges:true'/>","</td></tr><tr><td>","</td><td>","</td></tr><tr><td colspan='2'>","<button data-dojo-type='dijit.form.Button' type='submit' id='${id}_setButton'>${set}</button>","<button data-dojo-type='dijit.form.Button' type='button' id='${id}_cancelButton'>${buttonCancel}</button>","</td></tr></table>"].join(""),htmlTemplate:"<img src=\"${urlInput}\" _djrealurl=\"${urlInput}\" alt=\"${textInput}\" />",tag:"img",_getCurrentValues:function(img){var url,text;if(img&&img.tagName.toLowerCase()===this.tag){url=img.getAttribute("_djrealurl")||img.getAttribute("src");text=img.getAttribute("alt");this.editor.selection.selectElement(img,true);}else{text=this.editor.selection.getSelectedText();}return {urlInput:url||"",textInput:text||""};},_isValid:function(){return this._urlInput.isValid();},_connectTagEvents:function(){this.inherited(arguments);this.editor.onLoadDeferred.then(lang.hitch(this,function(){this.own(on(this.editor.editNode,"mousedown",lang.hitch(this,"_selectTag")));}));},_selectTag:function(e){if(e&&e.target){var t=e.target;var tg=t.tagName?t.tagName.toLowerCase():"";if(tg===this.tag){this.editor.selection.selectElement(t);}}},_checkValues:function(args){if(args&&args.urlInput){args.urlInput=args.urlInput.replace(/"/g,"&quot;");}if(args&&args.textInput){args.textInput=args.textInput.replace(/"/g,"&quot;");}return args;},_onDblClick:function(e){if(e&&e.target){var t=e.target;var tg=t.tagName?t.tagName.toLowerCase():"";if(tg===this.tag&&_5e2.get(t,"src")){var _5fb=this.editor;this.editor.selection.selectElement(t);_5fb.onDisplayChanged();if(_5fb._updateTimer){_5fb._updateTimer.remove();delete _5fb._updateTimer;}_5fb.onNormalizedDisplayChanged();var _5fc=this.button;setTimeout(function(){_5fc.set("disabled",false);_5fc.loadAndOpenDropDown().then(function(){if(_5fc.dropDown.focus){_5fc.dropDown.focus();}});},10);}}}});_5e6.registry["createLink"]=function(){return new _5e9({command:"createLink"});};_5e6.registry["insertImage"]=function(){return new _5fa({command:"insertImage"});};_5e9.ImgLinkDialog=_5fa;return _5e9;});},"dijit/DropDownMenu":function(){define(["dojo/_base/declare","dojo/keys","dojo/text!./templates/Menu.html","./_OnDijitClickMixin","./_MenuBase"],function(_5fd,keys,_5fe,_5ff,_600){return _5fd("dijit.DropDownMenu",[_600,_5ff],{templateString:_5fe,baseClass:"dijitMenu",_onUpArrow:function(){this.focusPrev();},_onDownArrow:function(){this.focusNext();},_onRightArrow:function(evt){this._moveToPopup(evt);evt.stopPropagation();evt.preventDefault();},_onLeftArrow:function(){if(this.parentMenu){if(this.parentMenu._isMenuBar){this.parentMenu.focusPrev();}else{this.onCancel(false);}}else{evt.stopPropagation();evt.preventDefault();}}});});},"dijit/form/_FormMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/window"],function(_601,_602,_603,lang,on,_604){return _602("dijit.form._FormMixin",null,{state:"",_getDescendantFormWidgets:function(_605){var res=[];_601.forEach(_605||this.getChildren(),function(_606){if("value" in _606){res.push(_606);}else{res=res.concat(this._getDescendantFormWidgets(_606.getChildren()));}},this);return res;},reset:function(){_601.forEach(this._getDescendantFormWidgets(),function(_607){if(_607.reset){_607.reset();}});},validate:function(){var _608=false;return _601.every(_601.map(this._getDescendantFormWidgets(),function(_609){_609._hasBeenBlurred=true;var _60a=_609.disabled||!_609.validate||_609.validate();if(!_60a&&!_608){_604.scrollIntoView(_609.containerNode||_609.domNode);_609.focus();_608=true;}return _60a;}),function(item){return item;});},setValues:function(val){_603.deprecated(this.declaredClass+"::setValues() is deprecated. Use set('value', val) instead.","","2.0");return this.set("value",val);},_setValueAttr:function(obj){var map={};_601.forEach(this._getDescendantFormWidgets(),function(_60b){if(!_60b.name){return;}var _60c=map[_60b.name]||(map[_60b.name]=[]);_60c.push(_60b);});for(var name in map){if(!map.hasOwnProperty(name)){continue;}var _60d=map[name],_60e=lang.getObject(name,false,obj);if(_60e===undefined){continue;}_60e=[].concat(_60e);if(typeof _60d[0].checked=="boolean"){_601.forEach(_60d,function(w){w.set("value",_601.indexOf(_60e,w._get("value"))!=-1);});}else{if(_60d[0].multiple){_60d[0].set("value",_60e);}else{_601.forEach(_60d,function(w,i){w.set("value",_60e[i]);});}}}},getValues:function(){_603.deprecated(this.declaredClass+"::getValues() is deprecated. Use get('value') instead.","","2.0");return this.get("value");},_getValueAttr:function(){var obj={};_601.forEach(this._getDescendantFormWidgets(),function(_60f){var name=_60f.name;if(!name||_60f.disabled){return;}var _610=_60f.get("value");if(typeof _60f.checked=="boolean"){if(/Radio/.test(_60f.declaredClass)){if(_610!==false){lang.setObject(name,_610,obj);}else{_610=lang.getObject(name,false,obj);if(_610===undefined){lang.setObject(name,null,obj);}}}else{var ary=lang.getObject(name,false,obj);if(!ary){ary=[];lang.setObject(name,ary,obj);}if(_610!==false){ary.push(_610);}}}else{var prev=lang.getObject(name,false,obj);if(typeof prev!="undefined"){if(lang.isArray(prev)){prev.push(_610);}else{lang.setObject(name,[prev,_610],obj);}}else{lang.setObject(name,_610,obj);}}});return obj;},isValid:function(){return this.state=="";},onValidStateChange:function(){},_getState:function(){var _611=_601.map(this._descendants,function(w){return w.get("state")||"";});return _601.indexOf(_611,"Error")>=0?"Error":_601.indexOf(_611,"Incomplete")>=0?"Incomplete":"";},disconnectChildren:function(){},connectChildren:function(_612){this._descendants=this._getDescendantFormWidgets();_601.forEach(this._descendants,function(_613){if(!_613._started){_613.startup();}});if(!_612){this._onChildChange();}},_onChildChange:function(attr){if(!attr||attr=="state"||attr=="disabled"){this._set("state",this._getState());}if(!attr||attr=="value"||attr=="disabled"||attr=="checked"){if(this._onChangeDelayTimer){this._onChangeDelayTimer.remove();}this._onChangeDelayTimer=this.defer(function(){delete this._onChangeDelayTimer;this._set("value",this.get("value"));},10);}},startup:function(){this.inherited(arguments);this._descendants=this._getDescendantFormWidgets();this.value=this.get("value");this.state=this._getState();var self=this;this.own(on(this.containerNode,"attrmodified-state, attrmodified-disabled, attrmodified-value, attrmodified-checked",function(evt){if(evt.target==self.domNode){return;}self._onChildChange(evt.type.replace("attrmodified-",""));}));this.watch("state",function(attr,_614,_615){this.onValidStateChange(_615=="");});},destroy:function(){this.inherited(arguments);}});});},"dijit/Menu":function(){define(["require","dojo/_base/array","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-geometry","dojo/dom-style","dojo/keys","dojo/_base/lang","dojo/on","dojo/sniff","dojo/_base/window","dojo/window","./popup","./DropDownMenu","dojo/ready"],function(_616,_617,_618,dom,_619,_61a,_61b,keys,lang,on,has,win,_61c,pm,_61d,_61e){if(has("dijit-legacy-requires")){_61e(0,function(){var _61f=["dijit/MenuItem","dijit/PopupMenuItem","dijit/CheckedMenuItem","dijit/MenuSeparator"];_616(_61f);});}return _618("dijit.Menu",_61d,{constructor:function(){this._bindings=[];},targetNodeIds:[],selector:"",contextMenuForWindow:false,leftClickToOpen:false,refocus:true,postCreate:function(){if(this.contextMenuForWindow){this.bindDomNode(this.ownerDocumentBody);}else{_617.forEach(this.targetNodeIds,this.bindDomNode,this);}this.inherited(arguments);},_iframeContentWindow:function(_620){return _61c.get(this._iframeContentDocument(_620))||this._iframeContentDocument(_620)["__parent__"]||(_620.name&&document.frames[_620.name])||null;},_iframeContentDocument:function(_621){return _621.contentDocument||(_621.contentWindow&&_621.contentWindow.document)||(_621.name&&document.frames[_621.name]&&document.frames[_621.name].document)||null;},bindDomNode:function(node){node=dom.byId(node,this.ownerDocument);var cn;if(node.tagName.toLowerCase()=="iframe"){var _622=node,_623=this._iframeContentWindow(_622);cn=win.body(_623.document);}else{cn=(node==win.body(this.ownerDocument)?this.ownerDocument.documentElement:node);}var _624={node:node,iframe:_622};_619.set(node,"_dijitMenu"+this.id,this._bindings.push(_624));var _625=lang.hitch(this,function(cn){var _626=this.selector,_627=_626?function(_628){return on.selector(_626,_628);}:function(_629){return _629;},self=this;return [on(cn,_627(this.leftClickToOpen?"click":"contextmenu"),function(evt){evt.stopPropagation();evt.preventDefault();self._scheduleOpen(this,_622,{x:evt.pageX,y:evt.pageY});}),on(cn,_627("keydown"),function(evt){if(evt.shiftKey&&evt.keyCode==keys.F10){evt.stopPropagation();evt.preventDefault();self._scheduleOpen(this,_622);}})];});_624.connects=cn?_625(cn):[];if(_622){_624.onloadHandler=lang.hitch(this,function(){var _62a=this._iframeContentWindow(_622),cn=win.body(_62a.document);_624.connects=_625(cn);});if(_622.addEventListener){_622.addEventListener("load",_624.onloadHandler,false);}else{_622.attachEvent("onload",_624.onloadHandler);}}},unBindDomNode:function(_62b){var node;try{node=dom.byId(_62b,this.ownerDocument);}catch(e){return;}var _62c="_dijitMenu"+this.id;if(node&&_619.has(node,_62c)){var bid=_619.get(node,_62c)-1,b=this._bindings[bid],h;while((h=b.connects.pop())){h.remove();}var _62d=b.iframe;if(_62d){if(_62d.removeEventListener){_62d.removeEventListener("load",b.onloadHandler,false);}else{_62d.detachEvent("onload",b.onloadHandler);}}_619.remove(node,_62c);delete this._bindings[bid];}},_scheduleOpen:function(_62e,_62f,_630){if(!this._openTimer){this._openTimer=this.defer(function(){delete this._openTimer;this._openMyself({target:_62e,iframe:_62f,coords:_630});},1);}},_openMyself:function(args){var _631=args.target,_632=args.iframe,_633=args.coords,_634=!_633;this.currentTarget=_631;if(_633){if(_632){var ifc=_61a.position(_632,true),_635=this._iframeContentWindow(_632),_636=_61a.docScroll(_635.document);var cs=_61b.getComputedStyle(_632),tp=_61b.toPixelValue,left=(has("ie")&&has("quirks")?0:tp(_632,cs.paddingLeft))+(has("ie")&&has("quirks")?tp(_632,cs.borderLeftWidth):0),top=(has("ie")&&has("quirks")?0:tp(_632,cs.paddingTop))+(has("ie")&&has("quirks")?tp(_632,cs.borderTopWidth):0);_633.x+=ifc.x+left-_636.x;_633.y+=ifc.y+top-_636.y;}}else{_633=_61a.position(_631,true);_633.x+=10;_633.y+=10;}var self=this;var _637=this._focusManager.get("prevNode");var _638=this._focusManager.get("curNode");var _639=!_638||(dom.isDescendant(_638,this.domNode))?_637:_638;function _63a(){if(self.refocus&&_639){_639.focus();}pm.close(self);};pm.open({popup:this,x:_633.x,y:_633.y,onExecute:_63a,onCancel:_63a,orient:this.isLeftToRight()?"L":"R"});this.focus();if(!_634){this.defer(function(){this._cleanUp(true);});}this._onBlur=function(){this.inherited("_onBlur",arguments);pm.close(this);};},destroy:function(){_617.forEach(this._bindings,function(b){if(b){this.unBindDomNode(b.node);}},this);this.inherited(arguments);}});});},"dijit/form/_CheckBoxMixin":function(){define(["dojo/_base/declare","dojo/dom-attr"],function(_63b,_63c){return _63b("dijit.form._CheckBoxMixin",null,{type:"checkbox",value:"on",readOnly:false,_aria_attr:"aria-checked",_setReadOnlyAttr:function(_63d){this._set("readOnly",_63d);_63c.set(this.focusNode,"readOnly",_63d);},_setLabelAttr:undefined,_getSubmitValue:function(_63e){return (_63e==null||_63e==="")?"on":_63e;},_setValueAttr:function(_63f){_63f=this._getSubmitValue(_63f);this._set("value",_63f);_63c.set(this.focusNode,"value",_63f);},reset:function(){this.inherited(arguments);this._set("value",this._getSubmitValue(this.params.value));_63c.set(this.focusNode,"value",this.value);},_onClick:function(e){if(this.readOnly){e.stopPropagation();e.preventDefault();return false;}return this.inherited(arguments);}});});},"dijit/layout/ContentPane":function(){define(["dojo/_base/kernel","dojo/_base/lang","../_Widget","../_Container","./_ContentPaneResizeMixin","dojo/string","dojo/html","dojo/i18n!../nls/loading","dojo/_base/array","dojo/_base/declare","dojo/_base/Deferred","dojo/dom","dojo/dom-attr","dojo/dom-construct","dojo/_base/xhr","dojo/i18n","dojo/when"],function(_640,lang,_641,_642,_643,_644,html,_645,_646,_647,_648,dom,_649,_64a,xhr,i18n,when){return _647("dijit.layout.ContentPane",[_641,_642,_643],{href:"",content:"",extractContent:false,parseOnLoad:true,parserScope:_640._scopeName,preventCache:false,preload:false,refreshOnShow:false,loadingMessage:"<span class='dijitContentPaneLoading'><span class='dijitInline dijitIconLoading'></span>${loadingState}</span>",errorMessage:"<span class='dijitContentPaneError'><span class='dijitInline dijitIconError'></span>${errorState}</span>",isLoaded:false,baseClass:"dijitContentPane",ioArgs:{},onLoadDeferred:null,_setTitleAttr:null,stopParser:true,template:false,markupFactory:function(_64b,node,ctor){var self=new ctor(_64b,node);return !self.href&&self._contentSetter&&self._contentSetter.parseDeferred&&!self._contentSetter.parseDeferred.isFulfilled()?self._contentSetter.parseDeferred.then(function(){return self;}):self;},create:function(_64c,_64d){if((!_64c||!_64c.template)&&_64d&&!("href" in _64c)&&!("content" in _64c)){_64d=dom.byId(_64d);var df=_64d.ownerDocument.createDocumentFragment();while(_64d.firstChild){df.appendChild(_64d.firstChild);}_64c=lang.delegate(_64c,{content:df});}this.inherited(arguments,[_64c,_64d]);},postMixInProperties:function(){this.inherited(arguments);var _64e=i18n.getLocalization("dijit","loading",this.lang);this.loadingMessage=_644.substitute(this.loadingMessage,_64e);this.errorMessage=_644.substitute(this.errorMessage,_64e);},buildRendering:function(){this.inherited(arguments);if(!this.containerNode){this.containerNode=this.domNode;}this.domNode.removeAttribute("title");},startup:function(){this.inherited(arguments);if(this._contentSetter){_646.forEach(this._contentSetter.parseResults,function(obj){if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){obj.startup();obj._started=true;}},this);}},_startChildren:function(){_646.forEach(this.getChildren(),function(obj){if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){obj.startup();obj._started=true;}});if(this._contentSetter){_646.forEach(this._contentSetter.parseResults,function(obj){if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){obj.startup();obj._started=true;}},this);}},setHref:function(href){_640.deprecated("dijit.layout.ContentPane.setHref() is deprecated. Use set('href', ...) instead.","","2.0");return this.set("href",href);},_setHrefAttr:function(href){this.cancel();this.onLoadDeferred=new _648(lang.hitch(this,"cancel"));this.onLoadDeferred.then(lang.hitch(this,"onLoad"));this._set("href",href);if(this.preload||(this._created&&this._isShown())){this._load();}else{this._hrefChanged=true;}return this.onLoadDeferred;},setContent:function(data){_640.deprecated("dijit.layout.ContentPane.setContent() is deprecated.  Use set('content', ...) instead.","","2.0");this.set("content",data);},_setContentAttr:function(data){this._set("href","");this.cancel();this.onLoadDeferred=new _648(lang.hitch(this,"cancel"));if(this._created){this.onLoadDeferred.then(lang.hitch(this,"onLoad"));}this._setContent(data||"");this._isDownloaded=false;return this.onLoadDeferred;},_getContentAttr:function(){return this.containerNode.innerHTML;},cancel:function(){if(this._xhrDfd&&(this._xhrDfd.fired==-1)){this._xhrDfd.cancel();}delete this._xhrDfd;this.onLoadDeferred=null;},destroy:function(){this.cancel();this.inherited(arguments);},destroyRecursive:function(_64f){if(this._beingDestroyed){return;}this.inherited(arguments);},_onShow:function(){this.inherited(arguments);if(this.href){if(!this._xhrDfd&&(!this.isLoaded||this._hrefChanged||this.refreshOnShow)){return this.refresh();}}},refresh:function(){this.cancel();this.onLoadDeferred=new _648(lang.hitch(this,"cancel"));this.onLoadDeferred.then(lang.hitch(this,"onLoad"));this._load();return this.onLoadDeferred;},_load:function(){this._setContent(this.onDownloadStart(),true);var self=this;var _650={preventCache:(this.preventCache||this.refreshOnShow),url:this.href,handleAs:"text"};if(lang.isObject(this.ioArgs)){lang.mixin(_650,this.ioArgs);}var hand=(this._xhrDfd=(this.ioMethod||xhr.get)(_650)),_651;hand.then(function(html){_651=html;try{self._isDownloaded=true;return self._setContent(html,false);}catch(err){self._onError("Content",err);}},function(err){if(!hand.canceled){self._onError("Download",err);}delete self._xhrDfd;return err;}).then(function(){self.onDownloadEnd();delete self._xhrDfd;return _651;});delete this._hrefChanged;},_onLoadHandler:function(data){this._set("isLoaded",true);try{this.onLoadDeferred.resolve(data);}catch(e){console.error("Error "+this.widgetId+" running custom onLoad code: "+e.message);}},_onUnloadHandler:function(){this._set("isLoaded",false);try{this.onUnload();}catch(e){console.error("Error "+this.widgetId+" running custom onUnload code: "+e.message);}},destroyDescendants:function(_652){if(this.isLoaded){this._onUnloadHandler();}var _653=this._contentSetter;_646.forEach(this.getChildren(),function(_654){if(_654.destroyRecursive){_654.destroyRecursive(_652);}else{if(_654.destroy){_654.destroy(_652);}}_654._destroyed=true;});if(_653){_646.forEach(_653.parseResults,function(_655){if(!_655._destroyed){if(_655.destroyRecursive){_655.destroyRecursive(_652);}else{if(_655.destroy){_655.destroy(_652);}}_655._destroyed=true;}});delete _653.parseResults;}if(!_652){_64a.empty(this.containerNode);}delete this._singleChild;},_setContent:function(cont,_656){this.destroyDescendants();var _657=this._contentSetter;if(!(_657&&_657 instanceof html._ContentSetter)){_657=this._contentSetter=new html._ContentSetter({node:this.containerNode,_onError:lang.hitch(this,this._onError),onContentError:lang.hitch(this,function(e){var _658=this.onContentError(e);try{this.containerNode.innerHTML=_658;}catch(e){console.error("Fatal "+this.id+" could not change content due to "+e.message,e);}})});}var _659=lang.mixin({cleanContent:this.cleanContent,extractContent:this.extractContent,parseContent:!cont.domNode&&this.parseOnLoad,parserScope:this.parserScope,startup:false,dir:this.dir,lang:this.lang,textDir:this.textDir},this._contentSetterParams||{});var p=_657.set((lang.isObject(cont)&&cont.domNode)?cont.domNode:cont,_659);var self=this;return when(p&&p.then?p:_657.parseDeferred,function(){delete self._contentSetterParams;if(!_656){if(self._started){self._startChildren();self._scheduleLayout();}self._onLoadHandler(cont);}});},_onError:function(type,err,_65a){this.onLoadDeferred.reject(err);var _65b=this["on"+type+"Error"].call(this,err);if(_65a){console.error(_65a,err);}else{if(_65b){this._setContent(_65b,true);}}},onLoad:function(){},onUnload:function(){},onDownloadStart:function(){return this.loadingMessage;},onContentError:function(){},onDownloadError:function(){return this.errorMessage;},onDownloadEnd:function(){}});});},"dijit/_KeyNavContainer":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/_base/kernel","dojo/keys","dojo/_base/lang","./registry","./_Container","./_FocusMixin","./_KeyNavMixin"],function(_65c,_65d,_65e,_65f,keys,lang,_660,_661,_662,_663){return _65d("dijit._KeyNavContainer",[_662,_663,_661],{connectKeyNavHandlers:function(_664,_665){var _666=(this._keyNavCodes={});var prev=lang.hitch(this,"focusPrev");var next=lang.hitch(this,"focusNext");_65c.forEach(_664,function(code){_666[code]=prev;});_65c.forEach(_665,function(code){_666[code]=next;});_666[keys.HOME]=lang.hitch(this,"focusFirstChild");_666[keys.END]=lang.hitch(this,"focusLastChild");},startupKeyNavChildren:function(){_65f.deprecated("startupKeyNavChildren() call no longer needed","","2.0");},startup:function(){this.inherited(arguments);_65c.forEach(this.getChildren(),lang.hitch(this,"_startupChild"));},addChild:function(_667,_668){this.inherited(arguments);this._startupChild(_667);},_startupChild:function(_669){_669.set("tabIndex","-1");},_getFirst:function(){var _66a=this.getChildren();return _66a.length?_66a[0]:null;},_getLast:function(){var _66b=this.getChildren();return _66b.length?_66b[_66b.length-1]:null;},focusNext:function(){this.focusChild(this._getNextFocusableChild(this.focusedChild,1));},focusPrev:function(){this.focusChild(this._getNextFocusableChild(this.focusedChild,-1),true);},childSelector:function(node){var node=_660.byNode(node);return node&&node.getParent()==this;}});});},"dijit/layout/utils":function(){define(["dojo/_base/array","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/lang"],function(_66c,_66d,_66e,_66f,lang){function _670(word){return word.substring(0,1).toUpperCase()+word.substring(1);};function size(_671,dim){var _672=_671.resize?_671.resize(dim):_66e.setMarginBox(_671.domNode,dim);if(_672){lang.mixin(_671,_672);}else{lang.mixin(_671,_66e.getMarginBox(_671.domNode));lang.mixin(_671,dim);}};var _673={marginBox2contentBox:function(node,mb){var cs=_66f.getComputedStyle(node);var me=_66e.getMarginExtents(node,cs);var pb=_66e.getPadBorderExtents(node,cs);return {l:_66f.toPixelValue(node,cs.paddingLeft),t:_66f.toPixelValue(node,cs.paddingTop),w:mb.w-(me.w+pb.w),h:mb.h-(me.h+pb.h)};},layoutChildren:function(_674,dim,_675,_676,_677){dim=lang.mixin({},dim);_66d.add(_674,"dijitLayoutContainer");_675=_66c.filter(_675,function(item){return item.region!="center"&&item.layoutAlign!="client";}).concat(_66c.filter(_675,function(item){return item.region=="center"||item.layoutAlign=="client";}));_66c.forEach(_675,function(_678){var elm=_678.domNode,pos=(_678.region||_678.layoutAlign);if(!pos){throw new Error("No region setting for "+_678.id);}var _679=elm.style;_679.left=dim.l+"px";_679.top=dim.t+"px";_679.position="absolute";_66d.add(elm,"dijitAlign"+_670(pos));var _67a={};if(_676&&_676==_678.id){_67a[_678.region=="top"||_678.region=="bottom"?"h":"w"]=_677;}if(pos=="leading"){pos=_678.isLeftToRight()?"left":"right";}if(pos=="trailing"){pos=_678.isLeftToRight()?"right":"left";}if(pos=="top"||pos=="bottom"){_67a.w=dim.w;size(_678,_67a);dim.h-=_678.h;if(pos=="top"){dim.t+=_678.h;}else{_679.top=dim.t+dim.h+"px";}}else{if(pos=="left"||pos=="right"){_67a.h=dim.h;size(_678,_67a);dim.w-=_678.w;if(pos=="left"){dim.l+=_678.w;}else{_679.left=dim.l+dim.w+"px";}}else{if(pos=="client"||pos=="center"){size(_678,dim);}}}});}};lang.setObject("dijit.layout.utils",_673);return _673;});},"dijit/form/DataList":function(){define(["dojo/_base/declare","dojo/dom","dojo/_base/lang","dojo/query","dojo/store/Memory","../registry"],function(_67b,dom,lang,_67c,_67d,_67e){function _67f(_680){return {id:_680.value,value:_680.value,name:lang.trim(_680.innerText||_680.textContent||"")};};return _67b("dijit.form.DataList",_67d,{constructor:function(_681,_682){this.domNode=dom.byId(_682);lang.mixin(this,_681);if(this.id){_67e.add(this);}this.domNode.style.display="none";this.inherited(arguments,[{data:_67c("option",this.domNode).map(_67f)}]);},destroy:function(){_67e.remove(this.id);},fetchSelectedItem:function(){var _683=_67c("> option[selected]",this.domNode)[0]||_67c("> option",this.domNode)[0];return _683&&_67f(_683);}});});},"dijit/form/CheckBox":function(){define(["require","dojo/_base/declare","dojo/dom-attr","dojo/has","dojo/query","dojo/ready","./ToggleButton","./_CheckBoxMixin","dojo/text!./templates/CheckBox.html","dojo/NodeList-dom","../a11yclick"],function(_684,_685,_686,has,_687,_688,_689,_68a,_68b){if(has("dijit-legacy-requires")){_688(0,function(){var _68c=["dijit/form/RadioButton"];_684(_68c);});}return _685("dijit.form.CheckBox",[_689,_68a],{templateString:_68b,baseClass:"dijitCheckBox",_setValueAttr:function(_68d,_68e){if(typeof _68d=="string"){this.inherited(arguments);_68d=true;}if(this._created){this.set("checked",_68d,_68e);}},_getValueAttr:function(){return this.checked&&this._get("value");},_setIconClassAttr:null,_setNameAttr:"focusNode",postMixInProperties:function(){this.inherited(arguments);this.checkedAttrSetting="";},_fillContent:function(){},_onFocus:function(){if(this.id){_687("label[for='"+this.id+"']").addClass("dijitFocusedLabel");}this.inherited(arguments);},_onBlur:function(){if(this.id){_687("label[for='"+this.id+"']").removeClass("dijitFocusedLabel");}this.inherited(arguments);}});});},"dijit/_editor/_Plugin":function(){define(["dojo/_base/connect","dojo/_base/declare","dojo/_base/lang","../Destroyable","../form/Button"],function(_68f,_690,lang,_691,_692){var _693=_690("dijit._editor._Plugin",_691,{constructor:function(args){this.params=args||{};lang.mixin(this,this.params);this._attrPairNames={};},editor:null,iconClassPrefix:"dijitEditorIcon",button:null,command:"",useDefaultCommand:true,buttonClass:_692,disabled:false,getLabel:function(key){return this.editor.commands[key];},_initButton:function(){if(this.command.length){var _694=this.getLabel(this.command),_695=this.editor,_696=this.iconClassPrefix+" "+this.iconClassPrefix+this.command.charAt(0).toUpperCase()+this.command.substr(1);if(!this.button){var _697=lang.mixin({label:_694,ownerDocument:_695.ownerDocument,dir:_695.dir,lang:_695.lang,showLabel:false,iconClass:_696,dropDown:this.dropDown,tabIndex:"-1"},this.params||{});this.button=new this.buttonClass(_697);}}if(this.get("disabled")&&this.button){this.button.set("disabled",this.get("disabled"));}},destroy:function(){if(this.dropDown){this.dropDown.destroyRecursive();}this.inherited(arguments);},connect:function(o,f,tf){this.own(_68f.connect(o,f,this,tf));},updateState:function(){var e=this.editor,c=this.command,_698,_699;if(!e||!e.isLoaded||!c.length){return;}var _69a=this.get("disabled");if(this.button){try{_699=!_69a&&e.queryCommandEnabled(c);if(this.enabled!==_699){this.enabled=_699;this.button.set("disabled",!_699);}if(_699){if(typeof this.button.checked=="boolean"){_698=e.queryCommandState(c);if(this.checked!==_698){this.checked=_698;this.button.set("checked",e.queryCommandState(c));}}}}catch(e){}}},setEditor:function(_69b){this.editor=_69b;this._initButton();if(this.button&&this.useDefaultCommand){if(this.editor.queryCommandAvailable(this.command)){this.own(this.button.on("click",lang.hitch(this.editor,"execCommand",this.command,this.commandArg)));}else{this.button.domNode.style.display="none";}}this.own(this.editor.on("NormalizedDisplayChanged",lang.hitch(this,"updateState")));},setToolbar:function(_69c){if(this.button){_69c.addChild(this.button);}},set:function(name,_69d){if(typeof name==="object"){for(var x in name){this.set(x,name[x]);}return this;}var _69e=this._getAttrNames(name);if(this[_69e.s]){var _69f=this[_69e.s].apply(this,Array.prototype.slice.call(arguments,1));}else{this._set(name,_69d);}return _69f||this;},get:function(name){var _6a0=this._getAttrNames(name);return this[_6a0.g]?this[_6a0.g]():this[name];},_setDisabledAttr:function(_6a1){this._set("disabled",_6a1);this.updateState();},_getAttrNames:function(name){var apn=this._attrPairNames;if(apn[name]){return apn[name];}var uc=name.charAt(0).toUpperCase()+name.substr(1);return (apn[name]={s:"_set"+uc+"Attr",g:"_get"+uc+"Attr"});},_set:function(name,_6a2){this[name]=_6a2;}});_693.registry={};return _693;});},"dijit/tree/_dndSelector":function(){define(["dojo/_base/array","dojo/_base/connect","dojo/_base/declare","dojo/_base/kernel","dojo/_base/lang","dojo/dom","dojo/mouse","dojo/on","dojo/touch","../a11yclick","./_dndContainer"],function(_6a3,_6a4,_6a5,_6a6,lang,dom,_6a7,on,_6a8,_6a9,_6aa){return _6a5("dijit.tree._dndSelector",_6aa,{constructor:function(){this.selection={};this.anchor=null;this.events.push(on(this.tree.domNode,_6a8.press,lang.hitch(this,"onMouseDown")),on(this.tree.domNode,_6a8.release,lang.hitch(this,"onMouseUp")),on(this.tree.domNode,_6a8.move,lang.hitch(this,"onMouseMove")),on(this.tree.domNode,_6a9.press,lang.hitch(this,"onClickPress")),on(this.tree.domNode,_6a9.release,lang.hitch(this,"onClickRelease")));},singular:false,getSelectedTreeNodes:function(){var _6ab=[],sel=this.selection;for(var i in sel){_6ab.push(sel[i]);}return _6ab;},selectNone:function(){this.setSelection([]);return this;},destroy:function(){this.inherited(arguments);this.selection=this.anchor=null;},addTreeNode:function(node,_6ac){this.setSelection(this.getSelectedTreeNodes().concat([node]));if(_6ac){this.anchor=node;}return node;},removeTreeNode:function(node){var _6ad=_6a3.filter(this.getSelectedTreeNodes(),function(_6ae){return !dom.isDescendant(_6ae.domNode,node.domNode);});this.setSelection(_6ad);return node;},isTreeNodeSelected:function(node){return node.id&&!!this.selection[node.id];},setSelection:function(_6af){var _6b0=this.getSelectedTreeNodes();_6a3.forEach(this._setDifference(_6b0,_6af),lang.hitch(this,function(node){node.setSelected(false);if(this.anchor==node){delete this.anchor;}delete this.selection[node.id];}));_6a3.forEach(this._setDifference(_6af,_6b0),lang.hitch(this,function(node){node.setSelected(true);this.selection[node.id]=node;}));this._updateSelectionProperties();},_setDifference:function(xs,ys){_6a3.forEach(ys,function(y){y.__exclude__=true;});var ret=_6a3.filter(xs,function(x){return !x.__exclude__;});_6a3.forEach(ys,function(y){delete y["__exclude__"];});return ret;},_updateSelectionProperties:function(){var _6b1=this.getSelectedTreeNodes();var _6b2=[],_6b3=[],_6b4=[];_6a3.forEach(_6b1,function(node){var ary=node.getTreePath(),_6b5=this.tree.model;_6b3.push(node);_6b2.push(ary);ary=_6a3.map(ary,function(item){return _6b5.getIdentity(item);},this);_6b4.push(ary.join("/"));},this);var _6b6=_6a3.map(_6b3,function(node){return node.item;});this.tree._set("paths",_6b2);this.tree._set("path",_6b2[0]||[]);this.tree._set("selectedNodes",_6b3);this.tree._set("selectedNode",_6b3[0]||null);this.tree._set("selectedItems",_6b6);this.tree._set("selectedItem",_6b6[0]||null);},onClickPress:function(e){if(this.current&&this.current.isExpandable&&this.tree.isExpandoNode(e.target,this.current)){return;}if(_6a7.isLeft(e)){e.preventDefault();}var _6b7=e.type=="keydown"?this.tree.focusedChild:this.current;if(!_6b7){return;}var copy=_6a4.isCopyKey(e),id=_6b7.id;if(!this.singular&&!e.shiftKey&&this.selection[id]){this._doDeselect=true;return;}else{this._doDeselect=false;}this.userSelect(_6b7,copy,e.shiftKey);},onClickRelease:function(e){if(!this._doDeselect){return;}this._doDeselect=false;this.userSelect(e.type=="keyup"?this.tree.focusedChild:this.current,_6a4.isCopyKey(e),e.shiftKey);},onMouseMove:function(){this._doDeselect=false;},onMouseDown:function(){},onMouseUp:function(){},_compareNodes:function(n1,n2){if(n1===n2){return 0;}if("sourceIndex" in document.documentElement){return n1.sourceIndex-n2.sourceIndex;}else{if("compareDocumentPosition" in document.documentElement){return n1.compareDocumentPosition(n2)&2?1:-1;}else{if(document.createRange){var r1=doc.createRange();r1.setStartBefore(n1);var r2=doc.createRange();r2.setStartBefore(n2);return r1.compareBoundaryPoints(r1.END_TO_END,r2);}else{throw Error("dijit.tree._compareNodes don't know how to compare two different nodes in this browser");}}}},userSelect:function(node,_6b8,_6b9){if(this.singular){if(this.anchor==node&&_6b8){this.selectNone();}else{this.setSelection([node]);this.anchor=node;}}else{if(_6b9&&this.anchor){var cr=this._compareNodes(this.anchor.rowNode,node.rowNode),_6ba,end,_6bb=this.anchor;if(cr<0){_6ba=_6bb;end=node;}else{_6ba=node;end=_6bb;}var _6bc=[];while(_6ba!=end){_6bc.push(_6ba);_6ba=this.tree._getNext(_6ba);}_6bc.push(end);this.setSelection(_6bc);}else{if(this.selection[node.id]&&_6b8){this.removeTreeNode(node);}else{if(_6b8){this.addTreeNode(node,true);}else{this.setSelection([node]);this.anchor=node;}}}}},getItem:function(key){var _6bd=this.selection[key];return {data:_6bd,type:["treeNode"]};},forInSelectedItems:function(f,o){o=o||_6a6.global;for(var id in this.selection){f.call(o,this.getItem(id),id,this);}}});});},"dojo/html":function(){define(["./_base/kernel","./_base/lang","./_base/array","./_base/declare","./dom","./dom-construct","./parser"],function(_6be,lang,_6bf,_6c0,dom,_6c1,_6c2){var html={};lang.setObject("dojo.html",html);var _6c3=0;html._secureForInnerHtml=function(cont){return cont.replace(/(?:\s*<!DOCTYPE\s[^>]+>|<title[^>]*>[\s\S]*?<\/title>)/ig,"");};html._emptyNode=_6c1.empty;html._setNodeContent=function(node,cont){_6c1.empty(node);if(cont){if(typeof cont=="string"){cont=_6c1.toDom(cont,node.ownerDocument);}if(!cont.nodeType&&lang.isArrayLike(cont)){for(var _6c4=cont.length,i=0;i<cont.length;i=_6c4==cont.length?i+1:0){_6c1.place(cont[i],node,"last");}}else{_6c1.place(cont,node,"last");}}return node;};html._ContentSetter=_6c0("dojo.html._ContentSetter",null,{node:"",content:"",id:"",cleanContent:false,extractContent:false,parseContent:false,parserScope:_6be._scopeName,startup:true,constructor:function(_6c5,node){lang.mixin(this,_6c5||{});node=this.node=dom.byId(this.node||node);if(!this.id){this.id=["Setter",(node)?node.id||node.tagName:"",_6c3++].join("_");}},set:function(cont,_6c6){if(undefined!==cont){this.content=cont;}if(_6c6){this._mixin(_6c6);}this.onBegin();this.setContent();var ret=this.onEnd();if(ret&&ret.then){return ret;}else{return this.node;}},setContent:function(){var node=this.node;if(!node){throw new Error(this.declaredClass+": setContent given no node");}try{node=html._setNodeContent(node,this.content);}catch(e){var _6c7=this.onContentError(e);try{node.innerHTML=_6c7;}catch(e){console.error("Fatal "+this.declaredClass+".setContent could not change content due to "+e.message,e);}}this.node=node;},empty:function(){if(this.parseDeferred){if(!this.parseDeferred.isResolved()){this.parseDeferred.cancel();}delete this.parseDeferred;}if(this.parseResults&&this.parseResults.length){_6bf.forEach(this.parseResults,function(w){if(w.destroy){w.destroy();}});delete this.parseResults;}_6c1.empty(this.node);},onBegin:function(){var cont=this.content;if(lang.isString(cont)){if(this.cleanContent){cont=html._secureForInnerHtml(cont);}if(this.extractContent){var _6c8=cont.match(/<body[^>]*>\s*([\s\S]+)\s*<\/body>/im);if(_6c8){cont=_6c8[1];}}}this.empty();this.content=cont;return this.node;},onEnd:function(){if(this.parseContent){this._parse();}return this.node;},tearDown:function(){delete this.parseResults;delete this.parseDeferred;delete this.node;delete this.content;},onContentError:function(err){return "Error occurred setting content: "+err;},onExecError:function(err){return "Error occurred executing scripts: "+err;},_mixin:function(_6c9){var _6ca={},key;for(key in _6c9){if(key in _6ca){continue;}this[key]=_6c9[key];}},_parse:function(){var _6cb=this.node;try{var _6cc={};_6bf.forEach(["dir","lang","textDir"],function(name){if(this[name]){_6cc[name]=this[name];}},this);var self=this;this.parseDeferred=_6c2.parse({rootNode:_6cb,noStart:!this.startup,inherited:_6cc,scope:this.parserScope}).then(function(_6cd){return self.parseResults=_6cd;},function(e){self._onError("Content",e,"Error parsing in _ContentSetter#"+this.id);});}catch(e){this._onError("Content",e,"Error parsing in _ContentSetter#"+this.id);}},_onError:function(type,err,_6ce){var _6cf=this["on"+type+"Error"].call(this,err);if(_6ce){console.error(_6ce,err);}else{if(_6cf){html._setNodeContent(this.node,_6cf,true);}}}});html.set=function(node,cont,_6d0){if(undefined==cont){console.warn("dojo.html.set: no cont argument provided, using empty string");cont="";}if(!_6d0){return html._setNodeContent(node,cont,true);}else{var op=new html._ContentSetter(lang.mixin(_6d0,{content:cont,node:node}));return op.set();}};return html;});},"dijit/_PaletteMixin":function(){define(["dojo/_base/declare","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/keys","dojo/_base/lang","dojo/on","./_CssStateMixin","./a11yclick","./focus","./typematic"],function(_6d1,_6d2,_6d3,_6d4,keys,lang,on,_6d5,_6d6,_6d7,_6d8){var _6d9=_6d1("dijit._PaletteMixin",_6d5,{defaultTimeout:500,timeoutChangeRate:0.9,value:"",_selectedCell:-1,tabIndex:"0",cellClass:"dijitPaletteCell",dyeClass:null,_dyeFactory:function(_6da){var _6db=typeof this.dyeClass=="string"?lang.getObject(this.dyeClass):this.dyeClass;return new _6db(_6da);},_preparePalette:function(_6dc,_6dd){this._cells=[];var url=this._blankGif;this.own(on(this.gridNode,_6d6,lang.hitch(this,"_onCellClick")));for(var row=0;row<_6dc.length;row++){var _6de=_6d4.create("tr",{tabIndex:"-1",role:"row"},this.gridNode);for(var col=0;col<_6dc[row].length;col++){var _6df=_6dc[row][col];if(_6df){var _6e0=this._dyeFactory(_6df,row,col,_6dd[_6df]);var _6e1=_6d4.create("td",{"class":this.cellClass,tabIndex:"-1",title:_6dd[_6df],role:"gridcell"},_6de);_6e0.fillCell(_6e1,url);_6e1.idx=this._cells.length;this._cells.push({node:_6e1,dye:_6e0});}}}this._xDim=_6dc[0].length;this._yDim=_6dc.length;var _6e2={UP_ARROW:-this._xDim,DOWN_ARROW:this._xDim,RIGHT_ARROW:this.isLeftToRight()?1:-1,LEFT_ARROW:this.isLeftToRight()?-1:1};for(var key in _6e2){this.own(_6d8.addKeyListener(this.domNode,{keyCode:keys[key],ctrlKey:false,altKey:false,shiftKey:false},this,function(){var _6e3=_6e2[key];return function(_6e4){this._navigateByKey(_6e3,_6e4);};}(),this.timeoutChangeRate,this.defaultTimeout));}},postCreate:function(){this.inherited(arguments);this._setCurrent(this._cells[0].node);},focus:function(){_6d7.focus(this._currentFocus);},_onCellClick:function(evt){var _6e5=evt.target;while(_6e5.tagName!="TD"){if(!_6e5.parentNode||_6e5==this.gridNode){return;}_6e5=_6e5.parentNode;}var _6e6=this._getDye(_6e5).getValue();this._setCurrent(_6e5);_6d7.focus(_6e5);this._setValueAttr(_6e6,true);evt.stopPropagation();evt.preventDefault();},_setCurrent:function(node){if("_currentFocus" in this){_6d2.set(this._currentFocus,"tabIndex","-1");}this._currentFocus=node;if(node){_6d2.set(node,"tabIndex",this.tabIndex);}},_setValueAttr:function(_6e7,_6e8){if(this._selectedCell>=0){_6d3.remove(this._cells[this._selectedCell].node,this.cellClass+"Selected");}this._selectedCell=-1;if(_6e7){for(var i=0;i<this._cells.length;i++){if(_6e7==this._cells[i].dye.getValue()){this._selectedCell=i;_6d3.add(this._cells[i].node,this.cellClass+"Selected");break;}}}this._set("value",this._selectedCell>=0?_6e7:null);if(_6e8||_6e8===undefined){this.onChange(_6e7);}},onChange:function(){},_navigateByKey:function(_6e9,_6ea){if(_6ea==-1){return;}var _6eb=this._currentFocus.idx+_6e9;if(_6eb<this._cells.length&&_6eb>-1){var _6ec=this._cells[_6eb].node;this._setCurrent(_6ec);this.defer(lang.hitch(_6d7,"focus",_6ec));}},_getDye:function(cell){return this._cells[cell.idx].dye;}});return _6d9;});},"dijit/form/ValidationTextBox":function(){define(["dojo/_base/declare","dojo/_base/kernel","dojo/i18n","./TextBox","../Tooltip","dojo/text!./templates/ValidationTextBox.html","dojo/i18n!./nls/validate"],function(_6ed,_6ee,i18n,_6ef,_6f0,_6f1){var _6f2;return _6f2=_6ed("dijit.form.ValidationTextBox",_6ef,{templateString:_6f1,required:false,promptMessage:"",invalidMessage:"$_unset_$",missingMessage:"$_unset_$",message:"",constraints:{},pattern:".*",regExp:"",regExpGen:function(){},state:"",tooltipPosition:[],_deprecateRegExp:function(attr,_6f3){if(_6f3!=_6f2.prototype[attr]){_6ee.deprecated("ValidationTextBox id="+this.id+", set('"+attr+"', ...) is deprecated.  Use set('pattern', ...) instead.","","2.0");this.set("pattern",_6f3);}},_setRegExpGenAttr:function(_6f4){this._deprecateRegExp("regExpGen",_6f4);this._set("regExpGen",this._computeRegexp);},_setRegExpAttr:function(_6f5){this._deprecateRegExp("regExp",_6f5);},_setValueAttr:function(){this.inherited(arguments);this._refreshState();},validator:function(_6f6,_6f7){return (new RegExp("^(?:"+this._computeRegexp(_6f7)+")"+(this.required?"":"?")+"$")).test(_6f6)&&(!this.required||!this._isEmpty(_6f6))&&(this._isEmpty(_6f6)||this.parse(_6f6,_6f7)!==undefined);},_isValidSubset:function(){return this.textbox.value.search(this._partialre)==0;},isValid:function(){return this.validator(this.textbox.value,this.get("constraints"));},_isEmpty:function(_6f8){return (this.trim?/^\s*$/:/^$/).test(_6f8);},getErrorMessage:function(){var _6f9=this.invalidMessage=="$_unset_$"?this.messages.invalidMessage:!this.invalidMessage?this.promptMessage:this.invalidMessage;var _6fa=this.missingMessage=="$_unset_$"?this.messages.missingMessage:!this.missingMessage?_6f9:this.missingMessage;return (this.required&&this._isEmpty(this.textbox.value))?_6fa:_6f9;},getPromptMessage:function(){return this.promptMessage;},_maskValidSubsetError:true,validate:function(_6fb){var _6fc="";var _6fd=this.disabled||this.isValid(_6fb);if(_6fd){this._maskValidSubsetError=true;}var _6fe=this._isEmpty(this.textbox.value);var _6ff=!_6fd&&_6fb&&this._isValidSubset();this._set("state",_6fd?"":(((((!this._hasBeenBlurred||_6fb)&&_6fe)||_6ff)&&(this._maskValidSubsetError||(_6ff&&!this._hasBeenBlurred&&_6fb)))?"Incomplete":"Error"));this.focusNode.setAttribute("aria-invalid",_6fd?"false":"true");if(this.state=="Error"){this._maskValidSubsetError=_6fb&&_6ff;_6fc=this.getErrorMessage(_6fb);}else{if(this.state=="Incomplete"){_6fc=this.getPromptMessage(_6fb);this._maskValidSubsetError=!this._hasBeenBlurred||_6fb;}else{if(_6fe){_6fc=this.getPromptMessage(_6fb);}}}this.set("message",_6fc);return _6fd;},displayMessage:function(_700){if(_700&&this.focused){_6f0.show(_700,this.domNode,this.tooltipPosition,!this.isLeftToRight());}else{_6f0.hide(this.domNode);}},_refreshState:function(){if(this._created){this.validate(this.focused);}this.inherited(arguments);},constructor:function(_701){this.constraints={};this.baseClass+=" dijitValidationTextBox";},startup:function(){this.inherited(arguments);this._refreshState();},_setConstraintsAttr:function(_702){if(!_702.locale&&this.lang){_702.locale=this.lang;}this._set("constraints",_702);this._refreshState();},_setPatternAttr:function(_703){this._set("pattern",_703);},_computeRegexp:function(_704){var p=this.pattern;if(typeof p=="function"){p=p.call(this,_704);}if(p!=this._lastRegExp){var _705="";this._lastRegExp=p;if(p!=".*"){p.replace(/\\.|\[\]|\[.*?[^\\]{1}\]|\{.*?\}|\(\?[=:!]|./g,function(re){switch(re.charAt(0)){case "{":case "+":case "?":case "*":case "^":case "$":case "|":case "(":_705+=re;break;case ")":_705+="|$)";break;default:_705+="(?:"+re+"|$)";break;}});}try{"".search(_705);}catch(e){_705=this.pattern;console.warn("RegExp error in "+this.declaredClass+": "+this.pattern);}this._partialre="^(?:"+_705+")$";}return p;},postMixInProperties:function(){this.inherited(arguments);this.messages=i18n.getLocalization("dijit.form","validate",this.lang);this._setConstraintsAttr(this.constraints);},_setDisabledAttr:function(_706){this.inherited(arguments);this._refreshState();},_setRequiredAttr:function(_707){this._set("required",_707);this.focusNode.setAttribute("aria-required",_707);this._refreshState();},_setMessageAttr:function(_708){this._set("message",_708);this.displayMessage(_708);},reset:function(){this._maskValidSubsetError=true;this.inherited(arguments);},_onBlur:function(){this.displayMessage("");this.inherited(arguments);}});});},"dijit/layout/BorderContainer":function(){define(["dojo/_base/array","dojo/cookie","dojo/_base/declare","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/keys","dojo/_base/lang","dojo/on","dojo/touch","../_WidgetBase","../_Widget","../_TemplatedMixin","./LayoutContainer","./utils"],function(_709,_70a,_70b,_70c,_70d,_70e,_70f,keys,lang,on,_710,_711,_712,_713,_714,_715){var _716=_70b("dijit.layout._Splitter",[_712,_713],{live:true,templateString:"<div class=\"dijitSplitter\" data-dojo-attach-event=\"onkeydown:_onKeyDown,press:_startDrag,onmouseenter:_onMouse,onmouseleave:_onMouse\" tabIndex=\"0\" role=\"separator\"><div class=\"dijitSplitterThumb\"></div></div>",constructor:function(){this._handlers=[];},postMixInProperties:function(){this.inherited(arguments);this.horizontal=/top|bottom/.test(this.region);this._factor=/top|left/.test(this.region)?1:-1;this._cookieName=this.container.id+"_"+this.region;},buildRendering:function(){this.inherited(arguments);_70c.add(this.domNode,"dijitSplitter"+(this.horizontal?"H":"V"));if(this.container.persist){var _717=_70a(this._cookieName);if(_717){this.child.domNode.style[this.horizontal?"height":"width"]=_717;}}},_computeMaxSize:function(){var dim=this.horizontal?"h":"w",_718=_70e.getMarginBox(this.child.domNode)[dim],_719=_709.filter(this.container.getChildren(),function(_71a){return _71a.region=="center";})[0];var _71b=_70e.getContentBox(_719.domNode)[dim]-10;return Math.min(this.child.maxSize,_718+_71b);},_startDrag:function(e){if(!this.cover){this.cover=_70d.place("<div class=dijitSplitterCover></div>",this.child.domNode,"after");}_70c.add(this.cover,"dijitSplitterCoverActive");if(this.fake){_70d.destroy(this.fake);}if(!(this._resize=this.live)){(this.fake=this.domNode.cloneNode(true)).removeAttribute("id");_70c.add(this.domNode,"dijitSplitterShadow");_70d.place(this.fake,this.domNode,"after");}_70c.add(this.domNode,"dijitSplitterActive dijitSplitter"+(this.horizontal?"H":"V")+"Active");if(this.fake){_70c.remove(this.fake,"dijitSplitterHover dijitSplitter"+(this.horizontal?"H":"V")+"Hover");}var _71c=this._factor,_71d=this.horizontal,axis=_71d?"pageY":"pageX",_71e=e[axis],_71f=this.domNode.style,dim=_71d?"h":"w",_720=_70f.getComputedStyle(this.child.domNode),_721=_70e.getMarginBox(this.child.domNode,_720)[dim],max=this._computeMaxSize(),min=Math.max(this.child.minSize,_70e.getPadBorderExtents(this.child.domNode,_720)[dim]+10),_722=this.region,_723=_722=="top"||_722=="bottom"?"top":"left",_724=parseInt(_71f[_723],10),_725=this._resize,_726=lang.hitch(this.container,"_layoutChildren",this.child.id),de=this.ownerDocument;this._handlers=this._handlers.concat([on(de,_710.move,this._drag=function(e,_727){var _728=e[axis]-_71e,_729=_71c*_728+_721,_72a=Math.max(Math.min(_729,max),min);if(_725||_727){_726(_72a);}_71f[_723]=_728+_724+_71c*(_72a-_729)+"px";}),on(de,"dragstart",function(e){e.stopPropagation();e.preventDefault();}),on(this.ownerDocumentBody,"selectstart",function(e){e.stopPropagation();e.preventDefault();}),on(de,_710.release,lang.hitch(this,"_stopDrag"))]);e.stopPropagation();e.preventDefault();},_onMouse:function(e){var o=(e.type=="mouseover"||e.type=="mouseenter");_70c.toggle(this.domNode,"dijitSplitterHover",o);_70c.toggle(this.domNode,"dijitSplitter"+(this.horizontal?"H":"V")+"Hover",o);},_stopDrag:function(e){try{if(this.cover){_70c.remove(this.cover,"dijitSplitterCoverActive");}if(this.fake){_70d.destroy(this.fake);}_70c.remove(this.domNode,"dijitSplitterActive dijitSplitter"+(this.horizontal?"H":"V")+"Active dijitSplitterShadow");this._drag(e);this._drag(e,true);}finally{this._cleanupHandlers();delete this._drag;}if(this.container.persist){_70a(this._cookieName,this.child.domNode.style[this.horizontal?"height":"width"],{expires:365});}},_cleanupHandlers:function(){var h;while(h=this._handlers.pop()){h.remove();}},_onKeyDown:function(e){this._resize=true;var _72b=this.horizontal;var tick=1;switch(e.keyCode){case _72b?keys.UP_ARROW:keys.LEFT_ARROW:tick*=-1;case _72b?keys.DOWN_ARROW:keys.RIGHT_ARROW:break;default:return;}var _72c=_70e.getMarginSize(this.child.domNode)[_72b?"h":"w"]+this._factor*tick;this.container._layoutChildren(this.child.id,Math.max(Math.min(_72c,this._computeMaxSize()),this.child.minSize));e.stopPropagation();e.preventDefault();},destroy:function(){this._cleanupHandlers();delete this.child;delete this.container;delete this.cover;delete this.fake;this.inherited(arguments);}});var _72d=_70b("dijit.layout._Gutter",[_712,_713],{templateString:"<div class=\"dijitGutter\" role=\"presentation\"></div>",postMixInProperties:function(){this.inherited(arguments);this.horizontal=/top|bottom/.test(this.region);},buildRendering:function(){this.inherited(arguments);_70c.add(this.domNode,"dijitGutter"+(this.horizontal?"H":"V"));}});var _72e=_70b("dijit.layout.BorderContainer",_714,{gutters:true,liveSplitters:true,persist:false,baseClass:"dijitBorderContainer",_splitterClass:_716,postMixInProperties:function(){if(!this.gutters){this.baseClass+="NoGutter";}this.inherited(arguments);},_setupChild:function(_72f){this.inherited(arguments);var _730=_72f.region,ltr=_72f.isLeftToRight();if(_730=="leading"){_730=ltr?"left":"right";}if(_730=="trailing"){_730=ltr?"right":"left";}if(_730){if(_730!="center"&&(_72f.splitter||this.gutters)&&!_72f._splitterWidget){var _731=_72f.splitter?this._splitterClass:_72d;if(lang.isString(_731)){_731=lang.getObject(_731);}var _732=new _731({id:_72f.id+"_splitter",container:this,child:_72f,region:_730,live:this.liveSplitters});_732.isSplitter=true;_72f._splitterWidget=_732;var _733=_730=="bottom"||_730==(this.isLeftToRight()?"right":"left");_70d.place(_732.domNode,_72f.domNode,_733?"before":"after");_732.startup();}}},layout:function(){this._layoutChildren();},removeChild:function(_734){var _735=_734._splitterWidget;if(_735){_735.destroy();delete _734._splitterWidget;}this.inherited(arguments);},getChildren:function(){return _709.filter(this.inherited(arguments),function(_736){return !_736.isSplitter;});},getSplitter:function(_737){return _709.filter(this.getChildren(),function(_738){return _738.region==_737;})[0]._splitterWidget;},resize:function(_739,_73a){if(!this.cs||!this.pe){var node=this.domNode;this.cs=_70f.getComputedStyle(node);this.pe=_70e.getPadExtents(node,this.cs);this.pe.r=_70f.toPixelValue(node,this.cs.paddingRight);this.pe.b=_70f.toPixelValue(node,this.cs.paddingBottom);_70f.set(node,"padding","0px");}this.inherited(arguments);},_layoutChildren:function(_73b,_73c){if(!this._borderBox||!this._borderBox.h){return;}var _73d=[];_709.forEach(this._getOrderedChildren(),function(pane){_73d.push(pane);if(pane._splitterWidget){_73d.push(pane._splitterWidget);}});var dim={l:this.pe.l,t:this.pe.t,w:this._borderBox.w-this.pe.w,h:this._borderBox.h-this.pe.h};_715.layoutChildren(this.domNode,dim,_73d,_73b,_73c);},destroyRecursive:function(){_709.forEach(this.getChildren(),function(_73e){var _73f=_73e._splitterWidget;if(_73f){_73f.destroy();}delete _73e._splitterWidget;});this.inherited(arguments);}});_72e.ChildWidgetProperties={splitter:false,minSize:0,maxSize:Infinity};lang.mixin(_72e.ChildWidgetProperties,_714.ChildWidgetProperties);lang.extend(_711,_72e.ChildWidgetProperties);_72e._Splitter=_716;_72e._Gutter=_72d;return _72e;});},"dojo/number":function(){define(["./_base/lang","./i18n","./i18n!./cldr/nls/number","./string","./regexp"],function(lang,i18n,_740,_741,_742){var _743={};lang.setObject("dojo.number",_743);_743.format=function(_744,_745){_745=lang.mixin({},_745||{});var _746=i18n.normalizeLocale(_745.locale),_747=i18n.getLocalization("dojo.cldr","number",_746);_745.customs=_747;var _748=_745.pattern||_747[(_745.type||"decimal")+"Format"];if(isNaN(_744)||Math.abs(_744)==Infinity){return null;}return _743._applyPattern(_744,_748,_745);};_743._numberPatternRE=/[#0,]*[#0](?:\.0*#*)?/;_743._applyPattern=function(_749,_74a,_74b){_74b=_74b||{};var _74c=_74b.customs.group,_74d=_74b.customs.decimal,_74e=_74a.split(";"),_74f=_74e[0];_74a=_74e[(_749<0)?1:0]||("-"+_74f);if(_74a.indexOf("%")!=-1){_749*=100;}else{if(_74a.indexOf("‰")!=-1){_749*=1000;}else{if(_74a.indexOf("¤")!=-1){_74c=_74b.customs.currencyGroup||_74c;_74d=_74b.customs.currencyDecimal||_74d;_74a=_74a.replace(/\u00a4{1,3}/,function(_750){var prop=["symbol","currency","displayName"][_750.length-1];return _74b[prop]||_74b.currency||"";});}else{if(_74a.indexOf("E")!=-1){throw new Error("exponential notation not supported");}}}}var _751=_743._numberPatternRE;var _752=_74f.match(_751);if(!_752){throw new Error("unable to find a number expression in pattern: "+_74a);}if(_74b.fractional===false){_74b.places=0;}return _74a.replace(_751,_743._formatAbsolute(_749,_752[0],{decimal:_74d,group:_74c,places:_74b.places,round:_74b.round}));};_743.round=function(_753,_754,_755){var _756=10/(_755||10);return (_756*+_753).toFixed(_754)/_756;};if((0.9).toFixed()==0){var _757=_743.round;_743.round=function(v,p,m){var d=Math.pow(10,-p||0),a=Math.abs(v);if(!v||a>=d){d=0;}else{a/=d;if(a<0.5||a>=0.95){d=0;}}return _757(v,p,m)+(v>0?d:-d);};}_743._formatAbsolute=function(_758,_759,_75a){_75a=_75a||{};if(_75a.places===true){_75a.places=0;}if(_75a.places===Infinity){_75a.places=6;}var _75b=_759.split("."),_75c=typeof _75a.places=="string"&&_75a.places.indexOf(","),_75d=_75a.places;if(_75c){_75d=_75a.places.substring(_75c+1);}else{if(!(_75d>=0)){_75d=(_75b[1]||[]).length;}}if(!(_75a.round<0)){_758=_743.round(_758,_75d,_75a.round);}var _75e=String(Math.abs(_758)).split("."),_75f=_75e[1]||"";if(_75b[1]||_75a.places){if(_75c){_75a.places=_75a.places.substring(0,_75c);}var pad=_75a.places!==undefined?_75a.places:(_75b[1]&&_75b[1].lastIndexOf("0")+1);if(pad>_75f.length){_75e[1]=_741.pad(_75f,pad,"0",true);}if(_75d<_75f.length){_75e[1]=_75f.substr(0,_75d);}}else{if(_75e[1]){_75e.pop();}}var _760=_75b[0].replace(",","");pad=_760.indexOf("0");if(pad!=-1){pad=_760.length-pad;if(pad>_75e[0].length){_75e[0]=_741.pad(_75e[0],pad);}if(_760.indexOf("#")==-1){_75e[0]=_75e[0].substr(_75e[0].length-pad);}}var _761=_75b[0].lastIndexOf(","),_762,_763;if(_761!=-1){_762=_75b[0].length-_761-1;var _764=_75b[0].substr(0,_761);_761=_764.lastIndexOf(",");if(_761!=-1){_763=_764.length-_761-1;}}var _765=[];for(var _766=_75e[0];_766;){var off=_766.length-_762;_765.push((off>0)?_766.substr(off):_766);_766=(off>0)?_766.slice(0,off):"";if(_763){_762=_763;delete _763;}}_75e[0]=_765.reverse().join(_75a.group||",");return _75e.join(_75a.decimal||".");};_743.regexp=function(_767){return _743._parseInfo(_767).regexp;};_743._parseInfo=function(_768){_768=_768||{};var _769=i18n.normalizeLocale(_768.locale),_76a=i18n.getLocalization("dojo.cldr","number",_769),_76b=_768.pattern||_76a[(_768.type||"decimal")+"Format"],_76c=_76a.group,_76d=_76a.decimal,_76e=1;if(_76b.indexOf("%")!=-1){_76e/=100;}else{if(_76b.indexOf("‰")!=-1){_76e/=1000;}else{var _76f=_76b.indexOf("¤")!=-1;if(_76f){_76c=_76a.currencyGroup||_76c;_76d=_76a.currencyDecimal||_76d;}}}var _770=_76b.split(";");if(_770.length==1){_770.push("-"+_770[0]);}var re=_742.buildGroupRE(_770,function(_771){_771="(?:"+_742.escapeString(_771,".")+")";return _771.replace(_743._numberPatternRE,function(_772){var _773={signed:false,separator:_768.strict?_76c:[_76c,""],fractional:_768.fractional,decimal:_76d,exponent:false},_774=_772.split("."),_775=_768.places;if(_774.length==1&&_76e!=1){_774[1]="###";}if(_774.length==1||_775===0){_773.fractional=false;}else{if(_775===undefined){_775=_768.pattern?_774[1].lastIndexOf("0")+1:Infinity;}if(_775&&_768.fractional==undefined){_773.fractional=true;}if(!_768.places&&(_775<_774[1].length)){_775+=","+_774[1].length;}_773.places=_775;}var _776=_774[0].split(",");if(_776.length>1){_773.groupSize=_776.pop().length;if(_776.length>1){_773.groupSize2=_776.pop().length;}}return "("+_743._realNumberRegexp(_773)+")";});},true);if(_76f){re=re.replace(/([\s\xa0]*)(\u00a4{1,3})([\s\xa0]*)/g,function(_777,_778,_779,_77a){var prop=["symbol","currency","displayName"][_779.length-1],_77b=_742.escapeString(_768[prop]||_768.currency||"");_778=_778?"[\\s\\xa0]":"";_77a=_77a?"[\\s\\xa0]":"";if(!_768.strict){if(_778){_778+="*";}if(_77a){_77a+="*";}return "(?:"+_778+_77b+_77a+")?";}return _778+_77b+_77a;});}return {regexp:re.replace(/[\xa0 ]/g,"[\\s\\xa0]"),group:_76c,decimal:_76d,factor:_76e};};_743.parse=function(_77c,_77d){var info=_743._parseInfo(_77d),_77e=(new RegExp("^"+info.regexp+"$")).exec(_77c);if(!_77e){return NaN;}var _77f=_77e[1];if(!_77e[1]){if(!_77e[2]){return NaN;}_77f=_77e[2];info.factor*=-1;}_77f=_77f.replace(new RegExp("["+info.group+"\\s\\xa0"+"]","g"),"").replace(info.decimal,".");return _77f*info.factor;};_743._realNumberRegexp=function(_780){_780=_780||{};if(!("places" in _780)){_780.places=Infinity;}if(typeof _780.decimal!="string"){_780.decimal=".";}if(!("fractional" in _780)||/^0/.test(_780.places)){_780.fractional=[true,false];}if(!("exponent" in _780)){_780.exponent=[true,false];}if(!("eSigned" in _780)){_780.eSigned=[true,false];}var _781=_743._integerRegexp(_780),_782=_742.buildGroupRE(_780.fractional,function(q){var re="";if(q&&(_780.places!==0)){re="\\"+_780.decimal;if(_780.places==Infinity){re="(?:"+re+"\\d+)?";}else{re+="\\d{"+_780.places+"}";}}return re;},true);var _783=_742.buildGroupRE(_780.exponent,function(q){if(q){return "([eE]"+_743._integerRegexp({signed:_780.eSigned})+")";}return "";});var _784=_781+_782;if(_782){_784="(?:(?:"+_784+")|(?:"+_782+"))";}return _784+_783;};_743._integerRegexp=function(_785){_785=_785||{};if(!("signed" in _785)){_785.signed=[true,false];}if(!("separator" in _785)){_785.separator="";}else{if(!("groupSize" in _785)){_785.groupSize=3;}}var _786=_742.buildGroupRE(_785.signed,function(q){return q?"[-+]":"";},true);var _787=_742.buildGroupRE(_785.separator,function(sep){if(!sep){return "(?:\\d+)";}sep=_742.escapeString(sep);if(sep==" "){sep="\\s";}else{if(sep==" "){sep="\\s\\xa0";}}var grp=_785.groupSize,grp2=_785.groupSize2;if(grp2){var _788="(?:0|[1-9]\\d{0,"+(grp2-1)+"}(?:["+sep+"]\\d{"+grp2+"})*["+sep+"]\\d{"+grp+"})";return ((grp-grp2)>0)?"(?:"+_788+"|(?:0|[1-9]\\d{0,"+(grp-1)+"}))":_788;}return "(?:0|[1-9]\\d{0,"+(grp-1)+"}(?:["+sep+"]\\d{"+grp+"})*)";},true);return _786+_787;};return _743;});},"dijit/_WidgetsInTemplateMixin":function(){define(["dojo/_base/array","dojo/aspect","dojo/_base/declare","dojo/_base/lang","dojo/parser"],function(_789,_78a,_78b,lang,_78c){return _78b("dijit._WidgetsInTemplateMixin",null,{_earlyTemplatedStartup:false,widgetsInTemplate:true,contextRequire:null,_beforeFillContent:function(){if(this.widgetsInTemplate){var node=this.domNode;if(this.containerNode&&!this.searchContainerNode){this.containerNode.stopParser=true;}_78c.parse(node,{noStart:!this._earlyTemplatedStartup,template:true,inherited:{dir:this.dir,lang:this.lang,textDir:this.textDir},propsThis:this,contextRequire:this.contextRequire,scope:"dojo"}).then(lang.hitch(this,function(_78d){this._startupWidgets=_78d;for(var i=0;i<_78d.length;i++){this._processTemplateNode(_78d[i],function(n,p){return n[p];},function(_78e,type,_78f){if(type in _78e){return _78e.connect(_78e,type,_78f);}else{return _78e.on(type,_78f,true);}});}if(this.containerNode&&this.containerNode.stopParser){delete this.containerNode.stopParser;}}));if(!this._startupWidgets){throw new Error(this.declaredClass+": parser returned unfilled promise (probably waiting for module auto-load), "+"unsupported by _WidgetsInTemplateMixin.   Must pre-load all supporting widgets before instantiation.");}}},_processTemplateNode:function(_790,_791,_792){if(_791(_790,"dojoType")||_791(_790,"data-dojo-type")){return true;}return this.inherited(arguments);},startup:function(){_789.forEach(this._startupWidgets,function(w){if(w&&!w._started&&w.startup){w.startup();}});this._startupWidgets=null;this.inherited(arguments);}});});},"dijit/form/HorizontalRuleLabels":function(){define(["dojo/_base/declare","dojo/has","dojo/number","dojo/query","dojo/_base/lang","./HorizontalRule"],function(_793,has,_794,_795,lang,_796){var _797=_793("dijit.form.HorizontalRuleLabels",_796,{templateString:"<div class=\"dijitRuleContainer dijitRuleContainerH dijitRuleLabelsContainer dijitRuleLabelsContainerH\"></div>",labelStyle:"",labels:[],numericMargin:0,minimum:0,maximum:1,constraints:{pattern:"#%"},_positionPrefix:"<div class=\"dijitRuleLabelContainer dijitRuleLabelContainerH\" style=\"left:",_labelPrefix:"\"><div class=\"dijitRuleLabel dijitRuleLabelH\">",_suffix:"</div></div>",_calcPosition:function(pos){return pos;},_genHTML:function(pos,ndx){var _798=this.labels[ndx];return this._positionPrefix+this._calcPosition(pos)+this._positionSuffix+this.labelStyle+this._genDirectionHTML(_798)+this._labelPrefix+_798+this._suffix;},_genDirectionHTML:function(_799){return "";},getLabels:function(){var _79a=this.labels;if(!_79a.length&&this.srcNodeRef){_79a=_795("> li",this.srcNodeRef).map(function(node){return String(node.innerHTML);});}if(!_79a.length&&this.count>1){var _79b=this.minimum;var inc=(this.maximum-_79b)/(this.count-1);for(var i=0;i<this.count;i++){_79a.push((i<this.numericMargin||i>=(this.count-this.numericMargin))?"":_794.format(_79b,this.constraints));_79b+=inc;}}return _79a;},postMixInProperties:function(){this.inherited(arguments);this.labels=this.getLabels();this.count=this.labels.length;}});if(has("dojo-bidi")){_797.extend({_setTextDirAttr:function(_79c){if(this.textDir!=_79c){this._set("textDir",_79c);_795(".dijitRuleLabelContainer",this.domNode).forEach(lang.hitch(this,function(_79d){_79d.style.direction=this.getTextDir(_79d.innerText||_79d.textContent||"");}));}},_genDirectionHTML:function(_79e){return (this.textDir?("direction:"+this.getTextDir(_79e)+";"):"");}});}return _797;});},"dijit/form/FilteringSelect":function(){define(["dojo/_base/declare","dojo/_base/lang","dojo/when","./MappedTextBox","./ComboBoxMixin"],function(_79f,lang,when,_7a0,_7a1){return _79f("dijit.form.FilteringSelect",[_7a0,_7a1],{required:true,_lastDisplayedValue:"",_isValidSubset:function(){return this._opened;},isValid:function(){return !!this.item||(!this.required&&this.get("displayedValue")=="");},_refreshState:function(){if(!this.searchTimer){this.inherited(arguments);}},_callbackSetLabel:function(_7a2,_7a3,_7a4,_7a5){if((_7a3&&_7a3[this.searchAttr]!==this._lastQuery)||(!_7a3&&_7a2.length&&this.store.getIdentity(_7a2[0])!=this._lastQuery)){return;}if(!_7a2.length){this.set("value","",_7a5||(_7a5===undefined&&!this.focused),this.textbox.value,null);}else{this.set("item",_7a2[0],_7a5);}},_openResultList:function(_7a6,_7a7,_7a8){if(_7a7[this.searchAttr]!==this._lastQuery){return;}this.inherited(arguments);if(this.item===undefined){this.validate(true);}},_getValueAttr:function(){return this.valueNode.value;},_getValueField:function(){return "value";},_setValueAttr:function(_7a9,_7aa,_7ab,item){if(!this._onChangeActive){_7aa=null;}if(item===undefined){if(_7a9===null||_7a9===""){_7a9="";if(!lang.isString(_7ab)){this._setDisplayedValueAttr(_7ab||"",_7aa);return;}}var self=this;this._lastQuery=_7a9;when(this.store.get(_7a9),function(item){self._callbackSetLabel(item?[item]:[],undefined,undefined,_7aa);});}else{this.valueNode.value=_7a9;this.inherited(arguments);}},_setItemAttr:function(item,_7ac,_7ad){this.inherited(arguments);this._lastDisplayedValue=this.textbox.value;},_getDisplayQueryString:function(text){return text.replace(/([\\\*\?])/g,"\\$1");},_setDisplayedValueAttr:function(_7ae,_7af){if(_7ae==null){_7ae="";}if(!this._created){if(!("displayedValue" in this.params)){return;}_7af=false;}if(this.store){this.closeDropDown();var _7b0=lang.clone(this.query);var qs=this._getDisplayQueryString(_7ae),q;if(this.store._oldAPI){q=qs;}else{q=this._patternToRegExp(qs);q.toString=function(){return qs;};}this._lastQuery=_7b0[this.searchAttr]=q;this.textbox.value=_7ae;this._lastDisplayedValue=_7ae;this._set("displayedValue",_7ae);var _7b1=this;var _7b2={ignoreCase:this.ignoreCase,deep:true};lang.mixin(_7b2,this.fetchProperties);this._fetchHandle=this.store.query(_7b0,_7b2);when(this._fetchHandle,function(_7b3){_7b1._fetchHandle=null;_7b1._callbackSetLabel(_7b3||[],_7b0,_7b2,_7af);},function(err){_7b1._fetchHandle=null;if(!_7b1._cancelingQuery){console.error("dijit.form.FilteringSelect: "+err.toString());}});}},undo:function(){this.set("displayedValue",this._lastDisplayedValue);}});});},"dojo/data/util/sorter":function(){define(["../../_base/lang"],function(lang){var _7b4={};lang.setObject("dojo.data.util.sorter",_7b4);_7b4.basicComparator=function(a,b){var r=-1;if(a===null){a=undefined;}if(b===null){b=undefined;}if(a==b){r=0;}else{if(a>b||a==null){r=1;}}return r;};_7b4.createSortFunction=function(_7b5,_7b6){var _7b7=[];function _7b8(attr,dir,comp,s){return function(_7b9,_7ba){var a=s.getValue(_7b9,attr);var b=s.getValue(_7ba,attr);return dir*comp(a,b);};};var _7bb;var map=_7b6.comparatorMap;var bc=_7b4.basicComparator;for(var i=0;i<_7b5.length;i++){_7bb=_7b5[i];var attr=_7bb.attribute;if(attr){var dir=(_7bb.descending)?-1:1;var comp=bc;if(map){if(typeof attr!=="string"&&("toString" in attr)){attr=attr.toString();}comp=map[attr]||bc;}_7b7.push(_7b8(attr,dir,comp,_7b6));}}return function(rowA,rowB){var i=0;while(i<_7b7.length){var ret=_7b7[i++](rowA,rowB);if(ret!==0){return ret;}}return 0;};};return _7b4;});},"dijit/form/_ButtonMixin":function(){define(["dojo/_base/declare","dojo/dom","dojo/has","../registry"],function(_7bc,dom,has,_7bd){var _7be=_7bc("dijit.form._ButtonMixin"+(has("dojo-bidi")?"_NoBidi":""),null,{label:"",type:"button",__onClick:function(e){e.stopPropagation();e.preventDefault();if(!this.disabled){this.valueNode.click(e);}return false;},_onClick:function(e){if(this.disabled){e.stopPropagation();e.preventDefault();return false;}if(this.onClick(e)===false){e.preventDefault();}cancelled=e.defaultPrevented;if(!cancelled&&this.type=="submit"&&!(this.valueNode||this.focusNode).form){for(var node=this.domNode;node.parentNode;node=node.parentNode){var _7bf=_7bd.byNode(node);if(_7bf&&typeof _7bf._onSubmit=="function"){_7bf._onSubmit(e);e.preventDefault();cancelled=true;break;}}}return !cancelled;},postCreate:function(){this.inherited(arguments);dom.setSelectable(this.focusNode,false);},onClick:function(){return true;},_setLabelAttr:function(_7c0){this._set("label",_7c0);var _7c1=this.containerNode||this.focusNode;_7c1.innerHTML=_7c0;}});if(has("dojo-bidi")){_7be=_7bc("dijit.form._ButtonMixin",_7be,{_setLabelAttr:function(){this.inherited(arguments);var _7c2=this.containerNode||this.focusNode;this.applyTextDir(_7c2);}});}return _7be;});},"dojo/colors":function(){define(["./_base/kernel","./_base/lang","./_base/Color","./_base/array"],function(dojo,lang,_7c3,_7c4){var _7c5={};lang.setObject("dojo.colors",_7c5);var _7c6=function(m1,m2,h){if(h<0){++h;}if(h>1){--h;}var h6=6*h;if(h6<1){return m1+(m2-m1)*h6;}if(2*h<1){return m2;}if(3*h<2){return m1+(m2-m1)*(2/3-h)*6;}return m1;};dojo.colorFromRgb=_7c3.fromRgb=function(_7c7,obj){var m=_7c7.toLowerCase().match(/^(rgba?|hsla?)\(([\s\.\-,%0-9]+)\)/);if(m){var c=m[2].split(/\s*,\s*/),l=c.length,t=m[1],a;if((t=="rgb"&&l==3)||(t=="rgba"&&l==4)){var r=c[0];if(r.charAt(r.length-1)=="%"){a=_7c4.map(c,function(x){return parseFloat(x)*2.56;});if(l==4){a[3]=c[3];}return _7c3.fromArray(a,obj);}return _7c3.fromArray(c,obj);}if((t=="hsl"&&l==3)||(t=="hsla"&&l==4)){var H=((parseFloat(c[0])%360)+360)%360/360,S=parseFloat(c[1])/100,L=parseFloat(c[2])/100,m2=L<=0.5?L*(S+1):L+S-L*S,m1=2*L-m2;a=[_7c6(m1,m2,H+1/3)*256,_7c6(m1,m2,H)*256,_7c6(m1,m2,H-1/3)*256,1];if(l==4){a[3]=c[3];}return _7c3.fromArray(a,obj);}}return null;};var _7c8=function(c,low,high){c=Number(c);return isNaN(c)?high:c<low?low:c>high?high:c;};_7c3.prototype.sanitize=function(){var t=this;t.r=Math.round(_7c8(t.r,0,255));t.g=Math.round(_7c8(t.g,0,255));t.b=Math.round(_7c8(t.b,0,255));t.a=_7c8(t.a,0,1);return this;};_7c5.makeGrey=_7c3.makeGrey=function(g,a){return _7c3.fromArray([g,g,g,a]);};lang.mixin(_7c3.named,{"aliceblue":[240,248,255],"antiquewhite":[250,235,215],"aquamarine":[127,255,212],"azure":[240,255,255],"beige":[245,245,220],"bisque":[255,228,196],"blanchedalmond":[255,235,205],"blueviolet":[138,43,226],"brown":[165,42,42],"burlywood":[222,184,135],"cadetblue":[95,158,160],"chartreuse":[127,255,0],"chocolate":[210,105,30],"coral":[255,127,80],"cornflowerblue":[100,149,237],"cornsilk":[255,248,220],"crimson":[220,20,60],"cyan":[0,255,255],"darkblue":[0,0,139],"darkcyan":[0,139,139],"darkgoldenrod":[184,134,11],"darkgray":[169,169,169],"darkgreen":[0,100,0],"darkgrey":[169,169,169],"darkkhaki":[189,183,107],"darkmagenta":[139,0,139],"darkolivegreen":[85,107,47],"darkorange":[255,140,0],"darkorchid":[153,50,204],"darkred":[139,0,0],"darksalmon":[233,150,122],"darkseagreen":[143,188,143],"darkslateblue":[72,61,139],"darkslategray":[47,79,79],"darkslategrey":[47,79,79],"darkturquoise":[0,206,209],"darkviolet":[148,0,211],"deeppink":[255,20,147],"deepskyblue":[0,191,255],"dimgray":[105,105,105],"dimgrey":[105,105,105],"dodgerblue":[30,144,255],"firebrick":[178,34,34],"floralwhite":[255,250,240],"forestgreen":[34,139,34],"gainsboro":[220,220,220],"ghostwhite":[248,248,255],"gold":[255,215,0],"goldenrod":[218,165,32],"greenyellow":[173,255,47],"grey":[128,128,128],"honeydew":[240,255,240],"hotpink":[255,105,180],"indianred":[205,92,92],"indigo":[75,0,130],"ivory":[255,255,240],"khaki":[240,230,140],"lavender":[230,230,250],"lavenderblush":[255,240,245],"lawngreen":[124,252,0],"lemonchiffon":[255,250,205],"lightblue":[173,216,230],"lightcoral":[240,128,128],"lightcyan":[224,255,255],"lightgoldenrodyellow":[250,250,210],"lightgray":[211,211,211],"lightgreen":[144,238,144],"lightgrey":[211,211,211],"lightpink":[255,182,193],"lightsalmon":[255,160,122],"lightseagreen":[32,178,170],"lightskyblue":[135,206,250],"lightslategray":[119,136,153],"lightslategrey":[119,136,153],"lightsteelblue":[176,196,222],"lightyellow":[255,255,224],"limegreen":[50,205,50],"linen":[250,240,230],"magenta":[255,0,255],"mediumaquamarine":[102,205,170],"mediumblue":[0,0,205],"mediumorchid":[186,85,211],"mediumpurple":[147,112,219],"mediumseagreen":[60,179,113],"mediumslateblue":[123,104,238],"mediumspringgreen":[0,250,154],"mediumturquoise":[72,209,204],"mediumvioletred":[199,21,133],"midnightblue":[25,25,112],"mintcream":[245,255,250],"mistyrose":[255,228,225],"moccasin":[255,228,181],"navajowhite":[255,222,173],"oldlace":[253,245,230],"olivedrab":[107,142,35],"orange":[255,165,0],"orangered":[255,69,0],"orchid":[218,112,214],"palegoldenrod":[238,232,170],"palegreen":[152,251,152],"paleturquoise":[175,238,238],"palevioletred":[219,112,147],"papayawhip":[255,239,213],"peachpuff":[255,218,185],"peru":[205,133,63],"pink":[255,192,203],"plum":[221,160,221],"powderblue":[176,224,230],"rosybrown":[188,143,143],"royalblue":[65,105,225],"saddlebrown":[139,69,19],"salmon":[250,128,114],"sandybrown":[244,164,96],"seagreen":[46,139,87],"seashell":[255,245,238],"sienna":[160,82,45],"skyblue":[135,206,235],"slateblue":[106,90,205],"slategray":[112,128,144],"slategrey":[112,128,144],"snow":[255,250,250],"springgreen":[0,255,127],"steelblue":[70,130,180],"tan":[210,180,140],"thistle":[216,191,216],"tomato":[255,99,71],"turquoise":[64,224,208],"violet":[238,130,238],"wheat":[245,222,179],"whitesmoke":[245,245,245],"yellowgreen":[154,205,50]});return _7c3;});},"dijit/tree/_dndContainer":function(){define(["dojo/aspect","dojo/_base/declare","dojo/dom-class","dojo/_base/lang","dojo/on","dojo/touch"],function(_7c9,_7ca,_7cb,lang,on,_7cc){return _7ca("dijit.tree._dndContainer",null,{constructor:function(tree,_7cd){this.tree=tree;this.node=tree.domNode;lang.mixin(this,_7cd);this.containerState="";_7cb.add(this.node,"dojoDndContainer");this.events=[on(this.node,_7cc.enter,lang.hitch(this,"onOverEvent")),on(this.node,_7cc.leave,lang.hitch(this,"onOutEvent")),_7c9.after(this.tree,"_onNodeMouseEnter",lang.hitch(this,"onMouseOver"),true),_7c9.after(this.tree,"_onNodeMouseLeave",lang.hitch(this,"onMouseOut"),true),on(this.node,"dragstart, selectstart",function(evt){evt.preventDefault();})];},destroy:function(){var h;while(h=this.events.pop()){h.remove();}this.node=this.parent=null;},onMouseOver:function(_7ce){this.current=_7ce;},onMouseOut:function(){this.current=null;},_changeState:function(type,_7cf){var _7d0="dojoDnd"+type;var _7d1=type.toLowerCase()+"State";_7cb.replace(this.node,_7d0+_7cf,_7d0+this[_7d1]);this[_7d1]=_7cf;},_addItemClass:function(node,type){_7cb.add(node,"dojoDndItem"+type);},_removeItemClass:function(node,type){_7cb.remove(node,"dojoDndItem"+type);},onOverEvent:function(){this._changeState("Container","Over");},onOutEvent:function(){this._changeState("Container","");}});});},"dojo/date/locale":function(){define(["../_base/lang","../_base/array","../date","../cldr/supplemental","../i18n","../regexp","../string","../i18n!../cldr/nls/gregorian","module"],function(lang,_7d2,date,_7d3,i18n,_7d4,_7d5,_7d6,_7d7){var _7d8={};lang.setObject(_7d7.id.replace(/\//g,"."),_7d8);function _7d9(_7da,_7db,_7dc,_7dd){return _7dd.replace(/([a-z])\1*/ig,function(_7de){var s,pad,c=_7de.charAt(0),l=_7de.length,_7df=["abbr","wide","narrow"];switch(c){case "G":s=_7db[(l<4)?"eraAbbr":"eraNames"][_7da.getFullYear()<0?0:1];break;case "y":s=_7da.getFullYear();switch(l){case 1:break;case 2:if(!_7dc.fullYear){s=String(s);s=s.substr(s.length-2);break;}default:pad=true;}break;case "Q":case "q":s=Math.ceil((_7da.getMonth()+1)/3);pad=true;break;case "M":case "L":var m=_7da.getMonth();if(l<3){s=m+1;pad=true;}else{var _7e0=["months",c=="L"?"standAlone":"format",_7df[l-3]].join("-");s=_7db[_7e0][m];}break;case "w":var _7e1=0;s=_7d8._getWeekOfYear(_7da,_7e1);pad=true;break;case "d":s=_7da.getDate();pad=true;break;case "D":s=_7d8._getDayOfYear(_7da);pad=true;break;case "e":case "c":var d=_7da.getDay();if(l<2){s=(d-_7d3.getFirstDayOfWeek(_7dc.locale)+8)%7;break;}case "E":d=_7da.getDay();if(l<3){s=d+1;pad=true;}else{var _7e2=["days",c=="c"?"standAlone":"format",_7df[l-3]].join("-");s=_7db[_7e2][d];}break;case "a":var _7e3=_7da.getHours()<12?"am":"pm";s=_7dc[_7e3]||_7db["dayPeriods-format-wide-"+_7e3];break;case "h":case "H":case "K":case "k":var h=_7da.getHours();switch(c){case "h":s=(h%12)||12;break;case "H":s=h;break;case "K":s=(h%12);break;case "k":s=h||24;break;}pad=true;break;case "m":s=_7da.getMinutes();pad=true;break;case "s":s=_7da.getSeconds();pad=true;break;case "S":s=Math.round(_7da.getMilliseconds()*Math.pow(10,l-3));pad=true;break;case "v":case "z":s=_7d8._getZone(_7da,true,_7dc);if(s){break;}l=4;case "Z":var _7e4=_7d8._getZone(_7da,false,_7dc);var tz=[(_7e4<=0?"+":"-"),_7d5.pad(Math.floor(Math.abs(_7e4)/60),2),_7d5.pad(Math.abs(_7e4)%60,2)];if(l==4){tz.splice(0,0,"GMT");tz.splice(3,0,":");}s=tz.join("");break;default:throw new Error("dojo.date.locale.format: invalid pattern char: "+_7dd);}if(pad){s=_7d5.pad(s,l);}return s;});};_7d8._getZone=function(_7e5,_7e6,_7e7){if(_7e6){return date.getTimezoneName(_7e5);}else{return _7e5.getTimezoneOffset();}};_7d8.format=function(_7e8,_7e9){_7e9=_7e9||{};var _7ea=i18n.normalizeLocale(_7e9.locale),_7eb=_7e9.formatLength||"short",_7ec=_7d8._getGregorianBundle(_7ea),str=[],_7ed=lang.hitch(this,_7d9,_7e8,_7ec,_7e9);if(_7e9.selector=="year"){return _7ee(_7ec["dateFormatItem-yyyy"]||"yyyy",_7ed);}var _7ef;if(_7e9.selector!="date"){_7ef=_7e9.timePattern||_7ec["timeFormat-"+_7eb];if(_7ef){str.push(_7ee(_7ef,_7ed));}}if(_7e9.selector!="time"){_7ef=_7e9.datePattern||_7ec["dateFormat-"+_7eb];if(_7ef){str.push(_7ee(_7ef,_7ed));}}return str.length==1?str[0]:_7ec["dateTimeFormat-"+_7eb].replace(/\'/g,"").replace(/\{(\d+)\}/g,function(_7f0,key){return str[key];});};_7d8.regexp=function(_7f1){return _7d8._parseInfo(_7f1).regexp;};_7d8._parseInfo=function(_7f2){_7f2=_7f2||{};var _7f3=i18n.normalizeLocale(_7f2.locale),_7f4=_7d8._getGregorianBundle(_7f3),_7f5=_7f2.formatLength||"short",_7f6=_7f2.datePattern||_7f4["dateFormat-"+_7f5],_7f7=_7f2.timePattern||_7f4["timeFormat-"+_7f5],_7f8;if(_7f2.selector=="date"){_7f8=_7f6;}else{if(_7f2.selector=="time"){_7f8=_7f7;}else{_7f8=_7f4["dateTimeFormat-"+_7f5].replace(/\{(\d+)\}/g,function(_7f9,key){return [_7f7,_7f6][key];});}}var _7fa=[],re=_7ee(_7f8,lang.hitch(this,_7fb,_7fa,_7f4,_7f2));return {regexp:re,tokens:_7fa,bundle:_7f4};};_7d8.parse=function(_7fc,_7fd){var _7fe=/[\u200E\u200F\u202A\u202E]/g,info=_7d8._parseInfo(_7fd),_7ff=info.tokens,_800=info.bundle,re=new RegExp("^"+info.regexp.replace(_7fe,"")+"$",info.strict?"":"i"),_801=re.exec(_7fc&&_7fc.replace(_7fe,""));if(!_801){return null;}var _802=["abbr","wide","narrow"],_803=[1970,0,1,0,0,0,0],amPm="",_804=_7d2.every(_801,function(v,i){if(!i){return true;}var _805=_7ff[i-1],l=_805.length,c=_805.charAt(0);switch(c){case "y":if(l!=2&&_7fd.strict){_803[0]=v;}else{if(v<100){v=Number(v);var year=""+new Date().getFullYear(),_806=year.substring(0,2)*100,_807=Math.min(Number(year.substring(2,4))+20,99);_803[0]=(v<_807)?_806+v:_806-100+v;}else{if(_7fd.strict){return false;}_803[0]=v;}}break;case "M":case "L":if(l>2){var _808=_800["months-"+(c=="L"?"standAlone":"format")+"-"+_802[l-3]].concat();if(!_7fd.strict){v=v.replace(".","").toLowerCase();_808=_7d2.map(_808,function(s){return s.replace(".","").toLowerCase();});}v=_7d2.indexOf(_808,v);if(v==-1){return false;}}else{v--;}_803[1]=v;break;case "E":case "e":case "c":var days=_800["days-"+(c=="c"?"standAlone":"format")+"-"+_802[l-3]].concat();if(!_7fd.strict){v=v.toLowerCase();days=_7d2.map(days,function(d){return d.toLowerCase();});}v=_7d2.indexOf(days,v);if(v==-1){return false;}break;case "D":_803[1]=0;case "d":_803[2]=v;break;case "a":var am=_7fd.am||_800["dayPeriods-format-wide-am"],pm=_7fd.pm||_800["dayPeriods-format-wide-pm"];if(!_7fd.strict){var _809=/\./g;v=v.replace(_809,"").toLowerCase();am=am.replace(_809,"").toLowerCase();pm=pm.replace(_809,"").toLowerCase();}if(_7fd.strict&&v!=am&&v!=pm){return false;}amPm=(v==pm)?"p":(v==am)?"a":"";break;case "K":if(v==24){v=0;}case "h":case "H":case "k":if(v>23){return false;}_803[3]=v;break;case "m":_803[4]=v;break;case "s":_803[5]=v;break;case "S":_803[6]=v;}return true;});var _80a=+_803[3];if(amPm==="p"&&_80a<12){_803[3]=_80a+12;}else{if(amPm==="a"&&_80a==12){_803[3]=0;}}var _80b=new Date(_803[0],_803[1],_803[2],_803[3],_803[4],_803[5],_803[6]);if(_7fd.strict){_80b.setFullYear(_803[0]);}var _80c=_7ff.join(""),_80d=_80c.indexOf("d")!=-1,_80e=_80c.indexOf("M")!=-1;if(!_804||(_80e&&_80b.getMonth()>_803[1])||(_80d&&_80b.getDate()>_803[2])){return null;}if((_80e&&_80b.getMonth()<_803[1])||(_80d&&_80b.getDate()<_803[2])){_80b=date.add(_80b,"hour",1);}return _80b;};function _7ee(_80f,_810,_811,_812){var _813=function(x){return x;};_810=_810||_813;_811=_811||_813;_812=_812||_813;var _814=_80f.match(/(''|[^'])+/g),_815=_80f.charAt(0)=="'";_7d2.forEach(_814,function(_816,i){if(!_816){_814[i]="";}else{_814[i]=(_815?_811:_810)(_816.replace(/''/g,"'"));_815=!_815;}});return _812(_814.join(""));};function _7fb(_817,_818,_819,_81a){_81a=_7d4.escapeString(_81a);if(!_819.strict){_81a=_81a.replace(" a"," ?a");}return _81a.replace(/([a-z])\1*/ig,function(_81b){var s,c=_81b.charAt(0),l=_81b.length,p2="",p3="";if(_819.strict){if(l>1){p2="0"+"{"+(l-1)+"}";}if(l>2){p3="0"+"{"+(l-2)+"}";}}else{p2="0?";p3="0{0,2}";}switch(c){case "y":s="\\d{2,4}";break;case "M":case "L":s=(l>2)?"\\S+?":"1[0-2]|"+p2+"[1-9]";break;case "D":s="[12][0-9][0-9]|3[0-5][0-9]|36[0-6]|"+p2+"[1-9][0-9]|"+p3+"[1-9]";break;case "d":s="3[01]|[12]\\d|"+p2+"[1-9]";break;case "w":s="[1-4][0-9]|5[0-3]|"+p2+"[1-9]";break;case "E":case "e":case "c":s=".+?";break;case "h":s="1[0-2]|"+p2+"[1-9]";break;case "k":s="1[01]|"+p2+"\\d";break;case "H":s="1\\d|2[0-3]|"+p2+"\\d";break;case "K":s="1\\d|2[0-4]|"+p2+"[1-9]";break;case "m":case "s":s="[0-5]\\d";break;case "S":s="\\d{"+l+"}";break;case "a":var am=_819.am||_818["dayPeriods-format-wide-am"],pm=_819.pm||_818["dayPeriods-format-wide-pm"];s=am+"|"+pm;if(!_819.strict){if(am!=am.toLowerCase()){s+="|"+am.toLowerCase();}if(pm!=pm.toLowerCase()){s+="|"+pm.toLowerCase();}if(s.indexOf(".")!=-1){s+="|"+s.replace(/\./g,"");}}s=s.replace(/\./g,"\\.");break;default:s=".*";}if(_817){_817.push(_81b);}return "("+s+")";}).replace(/[\xa0 ]/g,"[\\s\\xa0]");};var _81c=[];_7d8.addCustomFormats=function(_81d,_81e){_81c.push({pkg:_81d,name:_81e});};_7d8._getGregorianBundle=function(_81f){var _820={};_7d2.forEach(_81c,function(desc){var _821=i18n.getLocalization(desc.pkg,desc.name,_81f);_820=lang.mixin(_820,_821);},this);return _820;};_7d8.addCustomFormats(_7d7.id.replace(/\/date\/locale$/,".cldr"),"gregorian");_7d8.getNames=function(item,type,_822,_823){var _824,_825=_7d8._getGregorianBundle(_823),_826=[item,_822,type];if(_822=="standAlone"){var key=_826.join("-");_824=_825[key];if(_824[0]==1){_824=undefined;}}_826[1]="format";return (_824||_825[_826.join("-")]).concat();};_7d8.isWeekend=function(_827,_828){var _829=_7d3.getWeekend(_828),day=(_827||new Date()).getDay();if(_829.end<_829.start){_829.end+=7;if(day<_829.start){day+=7;}}return day>=_829.start&&day<=_829.end;};_7d8._getDayOfYear=function(_82a){return date.difference(new Date(_82a.getFullYear(),0,1,_82a.getHours()),_82a)+1;};_7d8._getWeekOfYear=function(_82b,_82c){if(arguments.length==1){_82c=0;}var _82d=new Date(_82b.getFullYear(),0,1).getDay(),adj=(_82d-_82c+7)%7,week=Math.floor((_7d8._getDayOfYear(_82b)+adj-1)/7);if(_82d==_82c){week++;}return week;};return _7d8;});},"dijit/form/VerticalRule":function(){define(["dojo/_base/declare","./HorizontalRule"],function(_82e,_82f){return _82e("dijit.form.VerticalRule",_82f,{templateString:"<div class=\"dijitRuleContainer dijitRuleContainerV\"></div>",_positionPrefix:"<div class=\"dijitRuleMark dijitRuleMarkV\" style=\"top:",_isHorizontal:false});});},"dijit/form/_FormSelectWidget":function(){define(["dojo/_base/array","dojo/_base/Deferred","dojo/aspect","dojo/data/util/sorter","dojo/_base/declare","dojo/dom","dojo/dom-class","dojo/_base/kernel","dojo/_base/lang","dojo/query","dojo/when","dojo/store/util/QueryResults","./_FormValueWidget"],function(_830,_831,_832,_833,_834,dom,_835,_836,lang,_837,when,_838,_839){var _83a=_834("dijit.form._FormSelectWidget",_839,{multiple:false,options:null,store:null,query:null,queryOptions:null,labelAttr:"",onFetch:null,sortByLabel:true,loadChildrenOnOpen:false,onLoadDeferred:null,getOptions:function(_83b){var opts=this.options||[];if(_83b==null){return opts;}if(lang.isArray(_83b)){return _830.map(_83b,"return this.getOptions(item);",this);}if(lang.isString(_83b)){_83b={value:_83b};}if(lang.isObject(_83b)){if(!_830.some(opts,function(_83c,idx){for(var a in _83b){if(!(a in _83c)||_83c[a]!=_83b[a]){return false;}}_83b=idx;return true;})){_83b=-1;}}if(_83b>=0&&_83b<opts.length){return opts[_83b];}return null;},addOption:function(_83d){_830.forEach(lang.isArray(_83d)?_83d:[_83d],function(i){if(i&&lang.isObject(i)){this.options.push(i);}},this);this._loadChildren();},removeOption:function(_83e){var _83f=this.getOptions(lang.isArray(_83e)?_83e:[_83e]);_830.forEach(_83f,function(_840){if(_840){this.options=_830.filter(this.options,function(node){return (node.value!==_840.value||node.label!==_840.label);});this._removeOptionItem(_840);}},this);this._loadChildren();},updateOption:function(_841){_830.forEach(lang.isArray(_841)?_841:[_841],function(i){var _842=this.getOptions({value:i.value}),k;if(_842){for(k in i){_842[k]=i[k];}}},this);this._loadChildren();},setStore:function(_843,_844,_845){var _846=this.store;_845=_845||{};if(_846!==_843){var h;while((h=this._notifyConnections.pop())){h.remove();}if(!_843.get){lang.mixin(_843,{_oldAPI:true,get:function(id){var _847=new _831();this.fetchItemByIdentity({identity:id,onItem:function(_848){_847.resolve(_848);},onError:function(_849){_847.reject(_849);}});return _847.promise;},query:function(_84a,_84b){var _84c=new _831(function(){if(_84d.abort){_84d.abort();}});_84c.total=new _831();var _84d=this.fetch(lang.mixin({query:_84a,onBegin:function(_84e){_84c.total.resolve(_84e);},onComplete:function(_84f){_84c.resolve(_84f);},onError:function(_850){_84c.reject(_850);}},_84b));return new _838(_84c);}});if(_843.getFeatures()["dojo.data.api.Notification"]){this._notifyConnections=[_832.after(_843,"onNew",lang.hitch(this,"_onNewItem"),true),_832.after(_843,"onDelete",lang.hitch(this,"_onDeleteItem"),true),_832.after(_843,"onSet",lang.hitch(this,"_onSetItem"),true)];}}this._set("store",_843);}if(this.options&&this.options.length){this.removeOption(this.options);}if(this._queryRes&&this._queryRes.close){this._queryRes.close();}if(_845.query){this._set("query",_845.query);this._set("queryOptions",_845.queryOptions);}if(_843){this._loadingStore=true;this.onLoadDeferred=new _831();this._queryRes=_843.query(this.query,this.queryOptions);when(this._queryRes,lang.hitch(this,function(_851){if(this.sortByLabel&&!_845.sort&&_851.length){if(_843.getValue){_851.sort(_833.createSortFunction([{attribute:_843.getLabelAttributes(_851[0])[0]}],_843));}else{var _852=this.labelAttr;_851.sort(function(a,b){return a[_852]>b[_852]?1:b[_852]>a[_852]?-1:0;});}}if(_845.onFetch){_851=_845.onFetch.call(this,_851,_845);}_830.forEach(_851,function(i){this._addOptionForItem(i);},this);if(this._queryRes.observe){this._queryRes.observe(lang.hitch(this,function(_853,_854,_855){if(_854==_855){this._onSetItem(_853);}else{if(_854!=-1){this._onDeleteItem(_853);}if(_855!=-1){this._onNewItem(_853);}}}),true);}this._loadingStore=false;this.set("value","_pendingValue" in this?this._pendingValue:_844);delete this._pendingValue;if(!this.loadChildrenOnOpen){this._loadChildren();}else{this._pseudoLoadChildren(_851);}this.onLoadDeferred.resolve(true);this.onSetStore();}),function(err){console.error("dijit.form.Select: "+err.toString());this.onLoadDeferred.reject(err);});}return _846;},_setValueAttr:function(_856,_857){if(!this._onChangeActive){_857=null;}if(this._loadingStore){this._pendingValue=_856;return;}if(_856==null){return;}if(lang.isArray(_856)){_856=_830.map(_856,function(_858){return lang.isObject(_858)?_858:{value:_858};});}else{if(lang.isObject(_856)){_856=[_856];}else{_856=[{value:_856}];}}_856=_830.filter(this.getOptions(_856),function(i){return i&&i.value;});var opts=this.getOptions()||[];if(!this.multiple&&(!_856[0]||!_856[0].value)&&!!opts.length){_856[0]=opts[0];}_830.forEach(opts,function(opt){opt.selected=_830.some(_856,function(v){return v.value===opt.value;});});var val=_830.map(_856,function(opt){return opt.value;});if(typeof val=="undefined"||typeof val[0]=="undefined"){return;}var disp=_830.map(_856,function(opt){return opt.label;});this._setDisplay(this.multiple?disp:disp[0]);this.inherited(arguments,[this.multiple?val:val[0],_857]);this._updateSelection();},_getDisplayedValueAttr:function(){var ret=_830.map([].concat(this.get("selectedOptions")),function(v){if(v&&"label" in v){return v.label;}else{if(v){return v.value;}}return null;},this);return this.multiple?ret:ret[0];},_setDisplayedValueAttr:function(_859){this.set("value",this.getOptions(typeof _859=="string"?{label:_859}:_859));},_loadChildren:function(){if(this._loadingStore){return;}_830.forEach(this._getChildren(),function(_85a){_85a.destroyRecursive();});_830.forEach(this.options,this._addOptionItem,this);this._updateSelection();},_updateSelection:function(){this.focusedChild=null;this._set("value",this._getValueFromOpts());var val=[].concat(this.value);if(val&&val[0]){var self=this;_830.forEach(this._getChildren(),function(_85b){var _85c=_830.some(val,function(v){return _85b.option&&(v===_85b.option.value);});if(_85c&&!self.multiple){self.focusedChild=_85b;}_835.toggle(_85b.domNode,this.baseClass.replace(/\s+|$/g,"SelectedOption "),_85c);_85b.domNode.setAttribute("aria-selected",_85c?"true":"false");},this);}},_getValueFromOpts:function(){var opts=this.getOptions()||[];if(!this.multiple&&opts.length){var opt=_830.filter(opts,function(i){return i.selected;})[0];if(opt&&opt.value){return opt.value;}else{opts[0].selected=true;return opts[0].value;}}else{if(this.multiple){return _830.map(_830.filter(opts,function(i){return i.selected;}),function(i){return i.value;})||[];}}return "";},_onNewItem:function(item,_85d){if(!_85d||!_85d.parent){this._addOptionForItem(item);}},_onDeleteItem:function(item){var _85e=this.store;this.removeOption({value:_85e.getIdentity(item)});},_onSetItem:function(item){this.updateOption(this._getOptionObjForItem(item));},_getOptionObjForItem:function(item){var _85f=this.store,_860=(this.labelAttr&&this.labelAttr in item)?item[this.labelAttr]:_85f.getLabel(item),_861=(_860?_85f.getIdentity(item):null);return {value:_861,label:_860,item:item};},_addOptionForItem:function(item){var _862=this.store;if(_862.isItemLoaded&&!_862.isItemLoaded(item)){_862.loadItem({item:item,onItem:function(i){this._addOptionForItem(i);},scope:this});return;}var _863=this._getOptionObjForItem(item);this.addOption(_863);},constructor:function(_864){this._oValue=(_864||{}).value||null;this._notifyConnections=[];},buildRendering:function(){this.inherited(arguments);dom.setSelectable(this.focusNode,false);},_fillContent:function(){if(!this.options){this.options=this.srcNodeRef?_837("> *",this.srcNodeRef).map(function(node){if(node.getAttribute("type")==="separator"){return {value:"",label:"",selected:false,disabled:false};}return {value:(node.getAttribute("data-"+_836._scopeName+"-value")||node.getAttribute("value")),label:String(node.innerHTML),selected:node.getAttribute("selected")||false,disabled:node.getAttribute("disabled")||false};},this):[];}if(!this.value){this._set("value",this._getValueFromOpts());}else{if(this.multiple&&typeof this.value=="string"){this._set("value",this.value.split(","));}}},postCreate:function(){this.inherited(arguments);_832.after(this,"onChange",lang.hitch(this,"_updateSelection"));var _865=this.store;if(_865&&(_865.getIdentity||_865.getFeatures()["dojo.data.api.Identity"])){this.store=null;this.setStore(_865,this._oValue);}},startup:function(){this._loadChildren();this.inherited(arguments);},destroy:function(){var h;while((h=this._notifyConnections.pop())){h.remove();}if(this._queryRes&&this._queryRes.close){this._queryRes.close();}this.inherited(arguments);},_addOptionItem:function(){},_removeOptionItem:function(){},_setDisplay:function(){},_getChildren:function(){return [];},_getSelectedOptionsAttr:function(){return this.getOptions({selected:true});},_pseudoLoadChildren:function(){},onSetStore:function(){}});return _83a;});},"dijit/form/Select":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/dom-class","dojo/dom-geometry","dojo/i18n","dojo/_base/lang","dojo/on","dojo/sniff","./_FormSelectWidget","../_HasDropDown","../DropDownMenu","../MenuItem","../MenuSeparator","../Tooltip","../_KeyNavMixin","../registry","dojo/text!./templates/Select.html","dojo/i18n!./nls/validate"],function(_866,_867,_868,_869,_86a,i18n,lang,on,has,_86b,_86c,_86d,_86e,_86f,_870,_871,_872,_873){var _874=_867("dijit.form._SelectMenu",_86d,{autoFocus:true,buildRendering:function(){this.inherited(arguments);this.domNode.setAttribute("role","listbox");},postCreate:function(){this.inherited(arguments);this.own(on(this.domNode,"selectstart",function(evt){evt.preventDefault();evt.stopPropagation();}));},focus:function(){var _875=false,val=this.parentWidget.value;if(lang.isArray(val)){val=val[val.length-1];}if(val){_866.forEach(this.parentWidget._getChildren(),function(_876){if(_876.option&&(val===_876.option.value)){_875=true;this.focusChild(_876,false);}},this);}if(!_875){this.inherited(arguments);}}});var _877=_867("dijit.form.Select"+(has("dojo-bidi")?"_NoBidi":""),[_86b,_86c,_871],{baseClass:"dijitSelect dijitValidationTextBox",templateString:_873,_buttonInputDisabled:has("ie")?"disabled":"",required:false,state:"",message:"",tooltipPosition:[],emptyLabel:"&#160;",_isLoaded:false,_childrenLoaded:false,_fillContent:function(){this.inherited(arguments);if(this.options.length&&!this.value&&this.srcNodeRef){var si=this.srcNodeRef.selectedIndex||0;this._set("value",this.options[si>=0?si:0].value);}this.dropDown=new _874({id:this.id+"_menu",parentWidget:this});_869.add(this.dropDown.domNode,this.baseClass.replace(/\s+|$/g,"Menu "));},_getMenuItemForOption:function(_878){if(!_878.value&&!_878.label){return new _86f({ownerDocument:this.ownerDocument});}else{var _879=lang.hitch(this,"_setValueAttr",_878);var item=new _86e({option:_878,label:_878.label||this.emptyLabel,onClick:_879,ownerDocument:this.ownerDocument,dir:this.dir,textDir:this.textDir,disabled:_878.disabled||false});item.focusNode.setAttribute("role","option");return item;}},_addOptionItem:function(_87a){if(this.dropDown){this.dropDown.addChild(this._getMenuItemForOption(_87a));}},_getChildren:function(){if(!this.dropDown){return [];}return this.dropDown.getChildren();},focus:function(){if(!this.disabled&&this.focusNode.focus){try{this.focusNode.focus();}catch(e){}}},focusChild:function(_87b){if(_87b){this.set("value",_87b.option);}},_getFirst:function(){var _87c=this._getChildren();return _87c.length?_87c[0]:null;},_getLast:function(){var _87d=this._getChildren();return _87d.length?_87d[_87d.length-1]:null;},childSelector:function(node){var node=_872.byNode(node);return node&&node.getParent()==this.dropDown;},onKeyboardSearch:function(item,evt,_87e,_87f){if(item){this.focusChild(item);}},_loadChildren:function(_880){if(_880===true){if(this.dropDown){delete this.dropDown.focusedChild;this.focusedChild=null;}if(this.options.length){this.inherited(arguments);}else{_866.forEach(this._getChildren(),function(_881){_881.destroyRecursive();});var item=new _86e({ownerDocument:this.ownerDocument,label:this.emptyLabel});this.dropDown.addChild(item);}}else{this._updateSelection();}this._isLoaded=false;this._childrenLoaded=true;if(!this._loadingStore){this._setValueAttr(this.value,false);}},_refreshState:function(){if(this._started){this.validate(this.focused);}},startup:function(){this.inherited(arguments);this._refreshState();},_setValueAttr:function(_882){this.inherited(arguments);_868.set(this.valueNode,"value",this.get("value"));this._refreshState();},_setNameAttr:"valueNode",_setDisabledAttr:function(_883){this.inherited(arguments);this._refreshState();},_setRequiredAttr:function(_884){this._set("required",_884);this.focusNode.setAttribute("aria-required",_884);this._refreshState();},_setOptionsAttr:function(_885){this._isLoaded=false;this._set("options",_885);},_setDisplay:function(_886){var lbl=_886||this.emptyLabel;this.containerNode.innerHTML="<span role=\"option\" class=\"dijitReset dijitInline "+this.baseClass.replace(/\s+|$/g,"Label ")+"\">"+lbl+"</span>";},validate:function(_887){var _888=this.disabled||this.isValid(_887);this._set("state",_888?"":(this._hasBeenBlurred?"Error":"Incomplete"));this.focusNode.setAttribute("aria-invalid",_888?"false":"true");var _889=_888?"":this._missingMsg;if(_889&&this.focused&&this._hasBeenBlurred){_870.show(_889,this.domNode,this.tooltipPosition,!this.isLeftToRight());}else{_870.hide(this.domNode);}this._set("message",_889);return _888;},isValid:function(){return (!this.required||this.value===0||!(/^\s*$/.test(this.value||"")));},reset:function(){this.inherited(arguments);_870.hide(this.domNode);this._refreshState();},postMixInProperties:function(){this.inherited(arguments);this._missingMsg=i18n.getLocalization("dijit.form","validate",this.lang).missingMessage;},postCreate:function(){this.inherited(arguments);this.own(on(this.domNode,"selectstart",function(evt){evt.preventDefault();evt.stopPropagation();}));this.domNode.setAttribute("aria-expanded","false");if(has("ie")<9){this.defer(function(){try{var s=domStyle.getComputedStyle(this.domNode);if(s){var ff=s.fontFamily;if(ff){var _88a=this.domNode.getElementsByTagName("INPUT");if(_88a){for(var i=0;i<_88a.length;i++){_88a[i].style.fontFamily=ff;}}}}}catch(e){}});}},_setStyleAttr:function(_88b){this.inherited(arguments);_869.toggle(this.domNode,this.baseClass.replace(/\s+|$/g,"FixedWidth "),!!this.domNode.style.width);},isLoaded:function(){return this._isLoaded;},loadDropDown:function(_88c){this._loadChildren(true);this._isLoaded=true;_88c();},destroy:function(_88d){if(this.dropDown&&!this.dropDown._destroyed){this.dropDown.destroyRecursive(_88d);delete this.dropDown;}this.inherited(arguments);},_onFocus:function(){this.validate(true);this.inherited(arguments);},_onBlur:function(){_870.hide(this.domNode);this.inherited(arguments);this.validate(false);}});if(has("dojo-bidi")){_877=_867("dijit.form.Select",_877,{_setDisplay:function(_88e){this.inherited(arguments);this.applyTextDir(this.containerNode);}});}_877._Menu=_874;function _88f(_890){return function(evt){if(!this._isLoaded){this.loadDropDown(lang.hitch(this,_890,evt));}else{this.inherited(_890,arguments);}};};_877.prototype._onContainerKeydown=_88f("_onContainerKeydown");_877.prototype._onContainerKeypress=_88f("_onContainerKeypress");return _877;});},"dijit/_editor/range":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/_base/lang"],function(_891,_892,lang){var _893={getIndex:function(node,_894){var ret=[],retR=[];var _895=node;var _896,n;while(node!=_894){var i=0;_896=node.parentNode;while((n=_896.childNodes[i++])){if(n===node){--i;break;}}ret.unshift(i);retR.unshift(i-_896.childNodes.length);node=_896;}if(ret.length>0&&_895.nodeType==3){n=_895.previousSibling;while(n&&n.nodeType==3){ret[ret.length-1]--;n=n.previousSibling;}n=_895.nextSibling;while(n&&n.nodeType==3){retR[retR.length-1]++;n=n.nextSibling;}}return {o:ret,r:retR};},getNode:function(_897,_898){if(!lang.isArray(_897)||_897.length==0){return _898;}var node=_898;_891.every(_897,function(i){if(i>=0&&i<node.childNodes.length){node=node.childNodes[i];}else{node=null;return false;}return true;});return node;},getCommonAncestor:function(n1,n2,root){root=root||n1.ownerDocument.body;var _899=function(n){var as=[];while(n){as.unshift(n);if(n!==root){n=n.parentNode;}else{break;}}return as;};var n1as=_899(n1);var n2as=_899(n2);var m=Math.min(n1as.length,n2as.length);var com=n1as[0];for(var i=1;i<m;i++){if(n1as[i]===n2as[i]){com=n1as[i];}else{break;}}return com;},getAncestor:function(node,_89a,root){root=root||node.ownerDocument.body;while(node&&node!==root){var name=node.nodeName.toUpperCase();if(_89a.test(name)){return node;}node=node.parentNode;}return null;},BlockTagNames:/^(?:P|DIV|H1|H2|H3|H4|H5|H6|ADDRESS|PRE|OL|UL|LI|DT|DE)$/,getBlockAncestor:function(node,_89b,root){root=root||node.ownerDocument.body;_89b=_89b||_893.BlockTagNames;var _89c=null,_89d;while(node&&node!==root){var name=node.nodeName.toUpperCase();if(!_89c&&_89b.test(name)){_89c=node;}if(!_89d&&(/^(?:BODY|TD|TH|CAPTION)$/).test(name)){_89d=node;}node=node.parentNode;}return {blockNode:_89c,blockContainer:_89d||node.ownerDocument.body};},atBeginningOfContainer:function(_89e,node,_89f){var _8a0=false;var _8a1=(_89f==0);if(!_8a1&&node.nodeType==3){if(/^[\s\xA0]+$/.test(node.nodeValue.substr(0,_89f))){_8a1=true;}}if(_8a1){var _8a2=node;_8a0=true;while(_8a2&&_8a2!==_89e){if(_8a2.previousSibling){_8a0=false;break;}_8a2=_8a2.parentNode;}}return _8a0;},atEndOfContainer:function(_8a3,node,_8a4){var _8a5=false;var _8a6=(_8a4==(node.length||node.childNodes.length));if(!_8a6&&node.nodeType==3){if(/^[\s\xA0]+$/.test(node.nodeValue.substr(_8a4))){_8a6=true;}}if(_8a6){var _8a7=node;_8a5=true;while(_8a7&&_8a7!==_8a3){if(_8a7.nextSibling){_8a5=false;break;}_8a7=_8a7.parentNode;}}return _8a5;},adjacentNoneTextNode:function(_8a8,next){var node=_8a8;var len=(0-_8a8.length)||0;var prop=next?"nextSibling":"previousSibling";while(node){if(node.nodeType!=3){break;}len+=node.length;node=node[prop];}return [node,len];},create:function(win){win=win||window;if(win.getSelection){return win.document.createRange();}else{return new _8a9();}},getSelection:function(_8aa,_8ab){if(_8aa.getSelection){return _8aa.getSelection();}else{var s=new ie.selection(_8aa);if(!_8ab){s._getCurrentSelection();}return s;}}};if(!window.getSelection){var ie=_893.ie={cachedSelection:{},selection:function(_8ac){this._ranges=[];this.addRange=function(r,_8ad){this._ranges.push(r);if(!_8ad){r._select();}this.rangeCount=this._ranges.length;};this.removeAllRanges=function(){this._ranges=[];this.rangeCount=0;};var _8ae=function(){var r=_8ac.document.selection.createRange();var type=_8ac.document.selection.type.toUpperCase();if(type=="CONTROL"){return new _8a9(ie.decomposeControlRange(r));}else{return new _8a9(ie.decomposeTextRange(r));}};this.getRangeAt=function(i){return this._ranges[i];};this._getCurrentSelection=function(){this.removeAllRanges();var r=_8ae();if(r){this.addRange(r,true);this.isCollapsed=r.collapsed;}else{this.isCollapsed=true;}};},decomposeControlRange:function(_8af){var _8b0=_8af.item(0),_8b1=_8af.item(_8af.length-1);var _8b2=_8b0.parentNode,_8b3=_8b1.parentNode;var _8b4=_893.getIndex(_8b0,_8b2).o[0];var _8b5=_893.getIndex(_8b1,_8b3).o[0]+1;return [_8b2,_8b4,_8b3,_8b5];},getEndPoint:function(_8b6,end){var _8b7=_8b6.duplicate();_8b7.collapse(!end);var _8b8="EndTo"+(end?"End":"Start");var _8b9=_8b7.parentElement();var _8ba,_8bb,_8bc;if(_8b9.childNodes.length>0){_891.every(_8b9.childNodes,function(node,i){var _8bd;if(node.nodeType!=3){_8b7.moveToElementText(node);if(_8b7.compareEndPoints(_8b8,_8b6)>0){if(_8bc&&_8bc.nodeType==3){_8ba=_8bc;_8bd=true;}else{_8ba=_8b9;_8bb=i;return false;}}else{if(i==_8b9.childNodes.length-1){_8ba=_8b9;_8bb=_8b9.childNodes.length;return false;}}}else{if(i==_8b9.childNodes.length-1){_8ba=node;_8bd=true;}}if(_8bd&&_8ba){var _8be=_893.adjacentNoneTextNode(_8ba)[0];if(_8be){_8ba=_8be.nextSibling;}else{_8ba=_8b9.firstChild;}var _8bf=_893.adjacentNoneTextNode(_8ba);_8be=_8bf[0];var _8c0=_8bf[1];if(_8be){_8b7.moveToElementText(_8be);_8b7.collapse(false);}else{_8b7.moveToElementText(_8b9);}_8b7.setEndPoint(_8b8,_8b6);_8bb=_8b7.text.length-_8c0;return false;}_8bc=node;return true;});}else{_8ba=_8b9;_8bb=0;}if(!end&&_8ba.nodeType==1&&_8bb==_8ba.childNodes.length){var _8c1=_8ba.nextSibling;if(_8c1&&_8c1.nodeType==3){_8ba=_8c1;_8bb=0;}}return [_8ba,_8bb];},setEndPoint:function(_8c2,_8c3,_8c4){var _8c5=_8c2.duplicate(),node,len;if(_8c3.nodeType!=3){if(_8c4>0){node=_8c3.childNodes[_8c4-1];if(node){if(node.nodeType==3){_8c3=node;_8c4=node.length;}else{if(node.nextSibling&&node.nextSibling.nodeType==3){_8c3=node.nextSibling;_8c4=0;}else{_8c5.moveToElementText(node.nextSibling?node:_8c3);var _8c6=node.parentNode;var _8c7=_8c6.insertBefore(node.ownerDocument.createTextNode(" "),node.nextSibling);_8c5.collapse(false);_8c6.removeChild(_8c7);}}}}else{_8c5.moveToElementText(_8c3);_8c5.collapse(true);}}if(_8c3.nodeType==3){var _8c8=_893.adjacentNoneTextNode(_8c3);var _8c9=_8c8[0];len=_8c8[1];if(_8c9){_8c5.moveToElementText(_8c9);_8c5.collapse(false);if(_8c9.contentEditable!="inherit"){len++;}}else{_8c5.moveToElementText(_8c3.parentNode);_8c5.collapse(true);_8c5.move("character",1);_8c5.move("character",-1);}_8c4+=len;if(_8c4>0){if(_8c5.move("character",_8c4)!=_8c4){console.error("Error when moving!");}}}return _8c5;},decomposeTextRange:function(_8ca){var _8cb=ie.getEndPoint(_8ca);var _8cc=_8cb[0],_8cd=_8cb[1];var _8ce=_8cb[0],_8cf=_8cb[1];if(_8ca.htmlText.length){if(_8ca.htmlText==_8ca.text){_8cf=_8cd+_8ca.text.length;}else{_8cb=ie.getEndPoint(_8ca,true);_8ce=_8cb[0],_8cf=_8cb[1];}}return [_8cc,_8cd,_8ce,_8cf];},setRange:function(_8d0,_8d1,_8d2,_8d3,_8d4,_8d5){var _8d6=ie.setEndPoint(_8d0,_8d1,_8d2);_8d0.setEndPoint("StartToStart",_8d6);if(!_8d5){var end=ie.setEndPoint(_8d0,_8d3,_8d4);}_8d0.setEndPoint("EndToEnd",end||_8d6);return _8d0;}};var _8a9=_893.W3CRange=_892(null,{constructor:function(){if(arguments.length>0){this.setStart(arguments[0][0],arguments[0][1]);this.setEnd(arguments[0][2],arguments[0][3]);}else{this.commonAncestorContainer=null;this.startContainer=null;this.startOffset=0;this.endContainer=null;this.endOffset=0;this.collapsed=true;}},_updateInternal:function(){if(this.startContainer!==this.endContainer){this.commonAncestorContainer=_893.getCommonAncestor(this.startContainer,this.endContainer);}else{this.commonAncestorContainer=this.startContainer;}this.collapsed=(this.startContainer===this.endContainer)&&(this.startOffset==this.endOffset);},setStart:function(node,_8d7){_8d7=parseInt(_8d7);if(this.startContainer===node&&this.startOffset==_8d7){return;}delete this._cachedBookmark;this.startContainer=node;this.startOffset=_8d7;if(!this.endContainer){this.setEnd(node,_8d7);}else{this._updateInternal();}},setEnd:function(node,_8d8){_8d8=parseInt(_8d8);if(this.endContainer===node&&this.endOffset==_8d8){return;}delete this._cachedBookmark;this.endContainer=node;this.endOffset=_8d8;if(!this.startContainer){this.setStart(node,_8d8);}else{this._updateInternal();}},setStartAfter:function(node,_8d9){this._setPoint("setStart",node,_8d9,1);},setStartBefore:function(node,_8da){this._setPoint("setStart",node,_8da,0);},setEndAfter:function(node,_8db){this._setPoint("setEnd",node,_8db,1);},setEndBefore:function(node,_8dc){this._setPoint("setEnd",node,_8dc,0);},_setPoint:function(what,node,_8dd,ext){var _8de=_893.getIndex(node,node.parentNode).o;this[what](node.parentNode,_8de.pop()+ext);},_getIERange:function(){var r=(this._body||this.endContainer.ownerDocument.body).createTextRange();ie.setRange(r,this.startContainer,this.startOffset,this.endContainer,this.endOffset,this.collapsed);return r;},getBookmark:function(){this._getIERange();return this._cachedBookmark;},_select:function(){var r=this._getIERange();r.select();},deleteContents:function(){var s=this.startContainer,r=this._getIERange();if(s.nodeType===3&&!this.startOffset){this.setStartBefore(s);}r.pasteHTML("");this.endContainer=this.startContainer;this.endOffset=this.startOffset;this.collapsed=true;},cloneRange:function(){var r=new _8a9([this.startContainer,this.startOffset,this.endContainer,this.endOffset]);r._body=this._body;return r;},detach:function(){this._body=null;this.commonAncestorContainer=null;this.startContainer=null;this.startOffset=0;this.endContainer=null;this.endOffset=0;this.collapsed=true;}});}lang.setObject("dijit.range",_893);return _893;});},"dijit/_KeyNavMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/keys","dojo/_base/lang","dojo/on","dijit/registry","dijit/_FocusMixin"],function(_8df,_8e0,_8e1,keys,lang,on,_8e2,_8e3){return _8e0("dijit._KeyNavMixin",_8e3,{tabIndex:"0",childSelector:null,postCreate:function(){this.inherited(arguments);_8e1.set(this.domNode,"tabIndex",this.tabIndex);if(!this._keyNavCodes){var _8e4=this._keyNavCodes={};_8e4[keys.HOME]=lang.hitch(this,"focusFirstChild");_8e4[keys.END]=lang.hitch(this,"focusLastChild");_8e4[this.isLeftToRight()?keys.LEFT_ARROW:keys.RIGHT_ARROW]=lang.hitch(this,"_onLeftArrow");_8e4[this.isLeftToRight()?keys.RIGHT_ARROW:keys.LEFT_ARROW]=lang.hitch(this,"_onRightArrow");_8e4[keys.UP_ARROW]=lang.hitch(this,"_onUpArrow");_8e4[keys.DOWN_ARROW]=lang.hitch(this,"_onDownArrow");}var self=this,_8e5=typeof this.childSelector=="string"?this.childSelector:lang.hitch(this,"childSelector");this.own(on(this.domNode,"keypress",lang.hitch(this,"_onContainerKeypress")),on(this.domNode,"keydown",lang.hitch(this,"_onContainerKeydown")),on(this.domNode,"focus",lang.hitch(this,"_onContainerFocus")),on(this.containerNode,on.selector(_8e5,"focusin"),function(evt){self._onChildFocus(_8e2.getEnclosingWidget(this),evt);}));},_onLeftArrow:function(){},_onRightArrow:function(){},_onUpArrow:function(){},_onDownArrow:function(){},focus:function(){this.focusFirstChild();},_getFirstFocusableChild:function(){return this._getNextFocusableChild(null,1);},_getLastFocusableChild:function(){return this._getNextFocusableChild(null,-1);},focusFirstChild:function(){this.focusChild(this._getFirstFocusableChild());},focusLastChild:function(){this.focusChild(this._getLastFocusableChild());},focusChild:function(_8e6,last){if(!_8e6){return;}if(this.focusedChild&&_8e6!==this.focusedChild){this._onChildBlur(this.focusedChild);}_8e6.set("tabIndex",this.tabIndex);_8e6.focus(last?"end":"start");},_onContainerFocus:function(evt){if(evt.target!==this.domNode||this.focusedChild){return;}this.focus();},_onFocus:function(){_8e1.set(this.domNode,"tabIndex","-1");this.inherited(arguments);},_onBlur:function(evt){_8e1.set(this.domNode,"tabIndex",this.tabIndex);if(this.focusedChild){this.focusedChild.set("tabIndex","-1");this.lastFocusedChild=this.focusedChild;this._set("focusedChild",null);}this.inherited(arguments);},_onChildFocus:function(_8e7){if(_8e7&&_8e7!=this.focusedChild){if(this.focusedChild&&!this.focusedChild._destroyed){this.focusedChild.set("tabIndex","-1");}_8e7.set("tabIndex",this.tabIndex);this.lastFocused=_8e7;this._set("focusedChild",_8e7);}},_searchString:"",multiCharSearchDuration:1000,onKeyboardSearch:function(item,evt,_8e8,_8e9){if(item){this.focusChild(item);}},_keyboardSearchCompare:function(item,_8ea){var _8eb=item.domNode,text=item.label||(_8eb.focusNode?_8eb.focusNode.label:"")||_8eb.innerText||_8eb.textContent||"",_8ec=text.replace(/^\s+/,"").substr(0,_8ea.length).toLowerCase();return (!!_8ea.length&&_8ec==_8ea)?-1:0;},_onContainerKeydown:function(evt){var func=this._keyNavCodes[evt.keyCode];if(func){func(evt,this.focusedChild);evt.stopPropagation();evt.preventDefault();this._searchString="";}else{if(evt.keyCode==keys.SPACE&&this._searchTimer&&!(evt.ctrlKey||evt.altKey||evt.metaKey)){evt.stopImmediatePropagation();evt.preventDefault();this._keyboardSearch(evt," ");}}},_onContainerKeypress:function(evt){if(evt.charCode<keys.SPACE||evt.ctrlKey||evt.altKey||evt.metaKey||(evt.charCode==keys.SPACE&&this._searchTimer)){return;}evt.preventDefault();evt.stopPropagation();this._keyboardSearch(evt,String.fromCharCode(evt.charCode).toLowerCase());},_keyboardSearch:function(evt,_8ed){var _8ee=null,_8ef,_8f0=0,_8f1=lang.hitch(this,function(){if(this._searchTimer){this._searchTimer.remove();}this._searchString+=_8ed;var _8f2=/^(.)\1*$/.test(this._searchString);var _8f3=_8f2?1:this._searchString.length;_8ef=this._searchString.substr(0,_8f3);this._searchTimer=this.defer(function(){this._searchTimer=null;this._searchString="";},this.multiCharSearchDuration);var _8f4=this.focusedChild||null;if(_8f3==1||!_8f4){_8f4=this._getNextFocusableChild(_8f4,1);if(!_8f4){return;}}var stop=_8f4;do{var rc=this._keyboardSearchCompare(_8f4,_8ef);if(!!rc&&_8f0++==0){_8ee=_8f4;}if(rc==-1){_8f0=-1;break;}_8f4=this._getNextFocusableChild(_8f4,1);}while(_8f4!=stop);});_8f1();this.onKeyboardSearch(_8ee,evt,_8ef,_8f0);},_onChildBlur:function(){},_getNextFocusableChild:function(_8f5,dir){var _8f6=_8f5;do{if(!_8f5){_8f5=this[dir>0?"_getFirst":"_getLast"]();if(!_8f5){break;}}else{_8f5=this._getNext(_8f5,dir);}if(_8f5!=null&&_8f5!=_8f6&&_8f5.isFocusable()){return _8f5;}}while(_8f5!=_8f6);return null;},_getFirst:function(){return null;},_getLast:function(){return null;},_getNext:function(_8f7,dir){if(_8f7){_8f7=_8f7.domNode;while(_8f7){_8f7=_8f7[dir<0?"previousSibling":"nextSibling"];if(_8f7&&"getAttribute" in _8f7){var w=_8e2.byNode(_8f7);if(w){return w;}}}}return null;}});});},"dojo/store/util/QueryResults":function(){define(["../../_base/array","../../_base/lang","../../when"],function(_8f8,lang,when){var _8f9=function(_8fa){if(!_8fa){return _8fa;}if(_8fa.then){_8fa=lang.delegate(_8fa);}function _8fb(_8fc){if(!_8fa[_8fc]){_8fa[_8fc]=function(){var args=arguments;return when(_8fa,function(_8fd){Array.prototype.unshift.call(args,_8fd);return _8f9(_8f8[_8fc].apply(_8f8,args));});};}};_8fb("forEach");_8fb("filter");_8fb("map");if(!_8fa.total){_8fa.total=when(_8fa,function(_8fe){return _8fe.length;});}return _8fa;};lang.setObject("dojo.store.util.QueryResults",_8f9);return _8f9;});},"dijit/form/_ListBase":function(){define(["dojo/_base/declare","dojo/on","dojo/window"],function(_8ff,on,_900){return _8ff("dijit.form._ListBase",null,{selected:null,_listConnect:function(_901,_902){var self=this;return self.own(on(self.containerNode,on.selector(function(_903,_904,_905){return _903.parentNode==_905;},_901),function(evt){evt.preventDefault();self[_902](evt,this);}));},selectFirstNode:function(){var _906=this.containerNode.firstChild;while(_906&&_906.style.display=="none"){_906=_906.nextSibling;}this._setSelectedAttr(_906);},selectLastNode:function(){var last=this.containerNode.lastChild;while(last&&last.style.display=="none"){last=last.previousSibling;}this._setSelectedAttr(last);},selectNextNode:function(){var _907=this.selected;if(!_907){this.selectFirstNode();}else{var next=_907.nextSibling;while(next&&next.style.display=="none"){next=next.nextSibling;}if(!next){this.selectFirstNode();}else{this._setSelectedAttr(next);}}},selectPreviousNode:function(){var _908=this.selected;if(!_908){this.selectLastNode();}else{var prev=_908.previousSibling;while(prev&&prev.style.display=="none"){prev=prev.previousSibling;}if(!prev){this.selectLastNode();}else{this._setSelectedAttr(prev);}}},_setSelectedAttr:function(node){if(this.selected!=node){var _909=this.selected;if(_909){this.onDeselect(_909);}if(node){_900.scrollIntoView(node);this.onSelect(node);}this._set("selected",node);}else{if(node){this.onSelect(node);}}}});});},"dojo/dnd/common":function(){define(["../sniff","../_base/kernel","../_base/lang","../dom"],function(has,_90a,lang,dom){var _90b=lang.getObject("dojo.dnd",true);_90b.getCopyKeyState=function(evt){return evt[has("mac")?"metaKey":"ctrlKey"];};_90b._uniqueId=0;_90b.getUniqueId=function(){var id;do{id=_90a._scopeName+"Unique"+(++_90b._uniqueId);}while(dom.byId(id));return id;};_90b._empty={};_90b.isFormElement=function(e){var t=e.target;if(t.nodeType==3){t=t.parentNode;}return " button textarea input select option ".indexOf(" "+t.tagName.toLowerCase()+" ")>=0;};return _90b;});},"dijit/CalendarLite":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/cldr/supplemental","dojo/date","dojo/date/locale","dojo/date/stamp","dojo/dom","dojo/dom-class","dojo/_base/lang","dojo/on","dojo/sniff","dojo/string","./_WidgetBase","./_TemplatedMixin","dojo/text!./templates/Calendar.html","./a11yclick","./hccss"],function(_90c,_90d,_90e,date,_90f,_910,dom,_911,lang,on,has,_912,_913,_914,_915){var _916=_90d("dijit.CalendarLite",[_913,_914],{templateString:_915,dowTemplateString:"<th class=\"dijitReset dijitCalendarDayLabelTemplate\" role=\"columnheader\" scope=\"col\"><span class=\"dijitCalendarDayLabel\">${d}</span></th>",dateTemplateString:"<td class=\"dijitReset\" role=\"gridcell\" data-dojo-attach-point=\"dateCells\"><span class=\"dijitCalendarDateLabel\" data-dojo-attach-point=\"dateLabels\"></span></td>",weekTemplateString:"<tr class=\"dijitReset dijitCalendarWeekTemplate\" role=\"row\">${d}${d}${d}${d}${d}${d}${d}</tr>",value:new Date(""),datePackage:"",dayWidth:"narrow",tabIndex:"0",currentFocus:new Date(),_setSummaryAttr:"gridNode",baseClass:"dijitCalendar",_isValidDate:function(_917){return _917&&!isNaN(_917)&&typeof _917=="object"&&_917.toString()!=this.constructor.prototype.value.toString();},_getValueAttr:function(){var _918=this._get("value");if(_918&&!isNaN(_918)){var _919=new this.dateClassObj(_918);_919.setHours(0,0,0,0);if(_919.getDate()<_918.getDate()){_919=this.dateModule.add(_919,"hour",1);}return _919;}else{return null;}},_setValueAttr:function(_91a,_91b){if(typeof _91a=="string"){_91a=_910.fromISOString(_91a);}_91a=this._patchDate(_91a);if(this._isValidDate(_91a)&&!this.isDisabledDate(_91a,this.lang)){this._set("value",_91a);this.set("currentFocus",_91a);this._markSelectedDates([_91a]);if(this._created&&(_91b||typeof _91b=="undefined")){this.onChange(this.get("value"));}}else{this._set("value",null);this._markSelectedDates([]);}},_patchDate:function(_91c){if(_91c){_91c=new this.dateClassObj(_91c);_91c.setHours(1,0,0,0);}return _91c;},_setText:function(node,text){while(node.firstChild){node.removeChild(node.firstChild);}node.appendChild(node.ownerDocument.createTextNode(text));},_populateGrid:function(){var _91d=new this.dateClassObj(this.currentFocus);_91d.setDate(1);var _91e=_91d.getDay(),_91f=this.dateModule.getDaysInMonth(_91d),_920=this.dateModule.getDaysInMonth(this.dateModule.add(_91d,"month",-1)),_921=new this.dateClassObj(),_922=_90e.getFirstDayOfWeek(this.lang);if(_922>_91e){_922-=7;}if(!this.summary){var _923=this.dateLocaleModule.getNames("months","wide","standAlone",this.lang,_91d);this.gridNode.setAttribute("summary",_923[_91d.getMonth()]);}this._date2cell={};_90c.forEach(this.dateCells,function(_924,idx){var i=idx+_922;var date=new this.dateClassObj(_91d),_925,_926="dijitCalendar",adj=0;if(i<_91e){_925=_920-_91e+i+1;adj=-1;_926+="Previous";}else{if(i>=(_91e+_91f)){_925=i-_91e-_91f+1;adj=1;_926+="Next";}else{_925=i-_91e+1;_926+="Current";}}if(adj){date=this.dateModule.add(date,"month",adj);}date.setDate(_925);if(!this.dateModule.compare(date,_921,"date")){_926="dijitCalendarCurrentDate "+_926;}if(this.isDisabledDate(date,this.lang)){_926="dijitCalendarDisabledDate "+_926;_924.setAttribute("aria-disabled","true");}else{_926="dijitCalendarEnabledDate "+_926;_924.removeAttribute("aria-disabled");_924.setAttribute("aria-selected","false");}var _927=this.getClassForDate(date,this.lang);if(_927){_926=_927+" "+_926;}_924.className=_926+"Month dijitCalendarDateTemplate";var _928=date.valueOf();this._date2cell[_928]=_924;_924.dijitDateValue=_928;this._setText(this.dateLabels[idx],date.getDateLocalized?date.getDateLocalized(this.lang):date.getDate());},this);},_populateControls:function(){var _929=new this.dateClassObj(this.currentFocus);_929.setDate(1);this.monthWidget.set("month",_929);var y=_929.getFullYear()-1;var d=new this.dateClassObj();_90c.forEach(["previous","current","next"],function(name){d.setFullYear(y++);this._setText(this[name+"YearLabelNode"],this.dateLocaleModule.format(d,{selector:"year",locale:this.lang}));},this);},goToToday:function(){this.set("value",new this.dateClassObj());},constructor:function(_92a){this.dateModule=_92a.datePackage?lang.getObject(_92a.datePackage,false):date;this.dateClassObj=this.dateModule.Date||Date;this.dateLocaleModule=_92a.datePackage?lang.getObject(_92a.datePackage+".locale",false):_90f;},_createMonthWidget:function(){return _916._MonthWidget({id:this.id+"_mddb",lang:this.lang,dateLocaleModule:this.dateLocaleModule},this.monthNode);},buildRendering:function(){var d=this.dowTemplateString,_92b=this.dateLocaleModule.getNames("days",this.dayWidth,"standAlone",this.lang),_92c=_90e.getFirstDayOfWeek(this.lang);this.dayCellsHtml=_912.substitute([d,d,d,d,d,d,d].join(""),{d:""},function(){return _92b[_92c++%7];});var r=_912.substitute(this.weekTemplateString,{d:this.dateTemplateString});this.dateRowsHtml=[r,r,r,r,r,r].join("");this.dateCells=[];this.dateLabels=[];this.inherited(arguments);dom.setSelectable(this.domNode,false);var _92d=new this.dateClassObj(this.currentFocus);this.monthWidget=this._createMonthWidget();this.set("currentFocus",_92d,false);},postCreate:function(){this.inherited(arguments);this._connectControls();},_connectControls:function(){var _92e=lang.hitch(this,function(_92f,part,_930){return on(this[_92f],"click",lang.hitch(this,function(){this._setCurrentFocusAttr(this.dateModule.add(this.currentFocus,part,_930));}));});this.own(_92e("incrementMonth","month",1),_92e("decrementMonth","month",-1),_92e("nextYearLabelNode","year",1),_92e("previousYearLabelNode","year",-1));},_setCurrentFocusAttr:function(date,_931){var _932=this.currentFocus,_933=this._getNodeByDate(_932);date=this._patchDate(date);this._set("currentFocus",date);if(!this._date2cell||this.dateModule.difference(_932,date,"month")!=0){this._populateGrid();this._populateControls();this._markSelectedDates([this.value]);}var _934=this._getNodeByDate(date);_934.setAttribute("tabIndex",this.tabIndex);if(this.focused||_931){_934.focus();}if(_933&&_933!=_934){if(has("webkit")){_933.setAttribute("tabIndex","-1");}else{_933.removeAttribute("tabIndex");}}},focus:function(){this._setCurrentFocusAttr(this.currentFocus,true);},_onDayClick:function(evt){evt.stopPropagation();evt.preventDefault();for(var node=evt.target;node&&!node.dijitDateValue;node=node.parentNode){}if(node&&!_911.contains(node,"dijitCalendarDisabledDate")){this.set("value",node.dijitDateValue);}},_getNodeByDate:function(_935){_935=this._patchDate(_935);return _935&&this._date2cell?this._date2cell[_935.valueOf()]:null;},_markSelectedDates:function(_936){function mark(_937,cell){_911.toggle(cell,"dijitCalendarSelectedDate",_937);cell.setAttribute("aria-selected",_937?"true":"false");};_90c.forEach(this._selectedCells||[],lang.partial(mark,false));this._selectedCells=_90c.filter(_90c.map(_936,this._getNodeByDate,this),function(n){return n;});_90c.forEach(this._selectedCells,lang.partial(mark,true));},onChange:function(){},isDisabledDate:function(){},getClassForDate:function(){}});_916._MonthWidget=_90d("dijit.CalendarLite._MonthWidget",_913,{_setMonthAttr:function(_938){var _939=this.dateLocaleModule.getNames("months","wide","standAlone",this.lang,_938),_93a=(has("ie")==6?"":"<div class='dijitSpacer'>"+_90c.map(_939,function(s){return "<div>"+s+"</div>";}).join("")+"</div>");this.domNode.innerHTML=_93a+"<div class='dijitCalendarMonthLabel dijitCalendarCurrentMonthLabel'>"+_939[_938.getMonth()]+"</div>";}});return _916;});},"dijit/CheckedMenuItem":function(){define(["dojo/_base/declare","dojo/dom-class","./MenuItem","dojo/text!./templates/CheckedMenuItem.html","./hccss"],function(_93b,_93c,_93d,_93e){return _93b("dijit.CheckedMenuItem",_93d,{baseClass:"dijitCheckedMenuItem",templateString:_93e,checked:false,_setCheckedAttr:function(_93f){_93c.toggle(this.domNode,this.baseClass+"Checked",_93f);this.domNode.setAttribute("aria-checked",_93f?"true":"false");this._set("checked",_93f);},iconClass:"",role:"menuitemcheckbox",checkedChar:"&#10003;",onChange:function(){},_onClick:function(evt){if(!this.disabled){this.set("checked",!this.checked);this.onChange(this.checked);}this.onClick(evt);}});});},"dijit/form/VerticalRuleLabels":function(){define(["dojo/_base/declare","./HorizontalRuleLabels"],function(_940,_941){return _940("dijit.form.VerticalRuleLabels",_941,{templateString:"<div class=\"dijitRuleContainer dijitRuleContainerV dijitRuleLabelsContainer dijitRuleLabelsContainerV\"></div>",_positionPrefix:"<div class=\"dijitRuleLabelContainer dijitRuleLabelContainerV\" style=\"top:",_labelPrefix:"\"><span class=\"dijitRuleLabel dijitRuleLabelV\">",_calcPosition:function(pos){return 100-pos;},_isHorizontal:false});});},"dijit/Declaration":function(){define(["dojo/_base/array","dojo/aspect","dojo/_base/declare","dojo/_base/lang","dojo/parser","dojo/query","./_Widget","./_TemplatedMixin","./_WidgetsInTemplateMixin","dojo/NodeList-dom"],function(_942,_943,_944,lang,_945,_946,_947,_948,_949){return _944("dijit.Declaration",_947,{_noScript:true,stopParser:true,widgetClass:"",defaults:null,mixins:[],buildRendering:function(){var src=this.srcNodeRef.parentNode.removeChild(this.srcNodeRef),_94a=_946("> script[type='dojo/method']",src).orphan(),_94b=_946("> script[type='dojo/connect']",src).orphan(),_94c=_946("> script[type='dojo/aspect']",src).orphan(),_94d=src.nodeName;var _94e=this.defaults||{};_942.forEach(_94a,function(s){var evt=s.getAttribute("event")||s.getAttribute("data-dojo-event"),func=_945._functionFromScript(s,"data-dojo-");if(evt){_94e[evt]=func;}else{_94c.push(s);}});if(this.mixins.length){this.mixins=_942.map(this.mixins,function(name){return lang.getObject(name);});}else{this.mixins=[_947,_948,_949];}_94e._skipNodeCache=true;_94e.templateString="<"+_94d+" class='"+src.className+"'"+" data-dojo-attach-point='"+(src.getAttribute("data-dojo-attach-point")||src.getAttribute("dojoAttachPoint")||"")+"' data-dojo-attach-event='"+(src.getAttribute("data-dojo-attach-event")||src.getAttribute("dojoAttachEvent")||"")+"' >"+src.innerHTML.replace(/\%7B/g,"{").replace(/\%7D/g,"}")+"</"+_94d+">";var wc=_944(this.widgetClass,this.mixins,_94e);_942.forEach(_94c,function(s){var _94f=s.getAttribute("data-dojo-advice")||"after",_950=s.getAttribute("data-dojo-method")||"postscript",func=_945._functionFromScript(s);_943.after(wc.prototype,_950,func,true);});_942.forEach(_94b,function(s){var evt=s.getAttribute("event")||s.getAttribute("data-dojo-event"),func=_945._functionFromScript(s);_943.after(wc.prototype,evt,func,true);});}});});},"dijit/MenuSeparator":function(){define(["dojo/_base/declare","dojo/dom","./_WidgetBase","./_TemplatedMixin","./_Contained","dojo/text!./templates/MenuSeparator.html"],function(_951,dom,_952,_953,_954,_955){return _951("dijit.MenuSeparator",[_952,_953,_954],{templateString:_955,buildRendering:function(){this.inherited(arguments);dom.setSelectable(this.domNode,false);},isFocusable:function(){return false;}});});},"dijit/form/_ComboBoxMenu":function(){define(["dojo/_base/declare","dojo/dom-class","dojo/dom-style","dojo/keys","../_WidgetBase","../_TemplatedMixin","./_ComboBoxMenuMixin","./_ListMouseMixin"],function(_956,_957,_958,keys,_959,_95a,_95b,_95c){return _956("dijit.form._ComboBoxMenu",[_959,_95a,_95c,_95b],{templateString:"<div class='dijitReset dijitMenu' data-dojo-attach-point='containerNode' style='overflow: auto; overflow-x: hidden;' role='listbox'>"+"<div class='dijitMenuItem dijitMenuPreviousButton' data-dojo-attach-point='previousButton' role='option'></div>"+"<div class='dijitMenuItem dijitMenuNextButton' data-dojo-attach-point='nextButton' role='option'></div>"+"</div>",baseClass:"dijitComboBoxMenu",postCreate:function(){this.inherited(arguments);if(!this.isLeftToRight()){_957.add(this.previousButton,"dijitMenuItemRtl");_957.add(this.nextButton,"dijitMenuItemRtl");}this.containerNode.setAttribute("role","listbox");},_createMenuItem:function(){var item=this.ownerDocument.createElement("div");item.className="dijitReset dijitMenuItem"+(this.isLeftToRight()?"":" dijitMenuItemRtl");item.setAttribute("role","option");return item;},onHover:function(node){_957.add(node,"dijitMenuItemHover");},onUnhover:function(node){_957.remove(node,"dijitMenuItemHover");},onSelect:function(node){_957.add(node,"dijitMenuItemSelected");},onDeselect:function(node){_957.remove(node,"dijitMenuItemSelected");},_page:function(up){var _95d=0;var _95e=this.domNode.scrollTop;var _95f=_958.get(this.domNode,"height");if(!this.getHighlightedOption()){this.selectNextNode();}while(_95d<_95f){var _960=this.getHighlightedOption();if(up){if(!_960.previousSibling||_960.previousSibling.style.display=="none"){break;}this.selectPreviousNode();}else{if(!_960.nextSibling||_960.nextSibling.style.display=="none"){break;}this.selectNextNode();}var _961=this.domNode.scrollTop;_95d+=(_961-_95e)*(up?-1:1);_95e=_961;}},handleKey:function(evt){switch(evt.keyCode){case keys.DOWN_ARROW:this.selectNextNode();return false;case keys.PAGE_DOWN:this._page(false);return false;case keys.UP_ARROW:this.selectPreviousNode();return false;case keys.PAGE_UP:this._page(true);return false;default:return true;}}});});},"dijit/Dialog":function(){define(["require","dojo/_base/array","dojo/aspect","dojo/_base/declare","dojo/Deferred","dojo/dom","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/fx","dojo/i18n","dojo/keys","dojo/_base/lang","dojo/on","dojo/ready","dojo/sniff","dojo/window","dojo/dnd/Moveable","dojo/dnd/TimedMoveable","./focus","./_base/manager","./_Widget","./_TemplatedMixin","./_CssStateMixin","./form/_FormMixin","./_DialogMixin","./DialogUnderlay","./layout/ContentPane","dojo/text!./templates/Dialog.html","dojo/i18n!./nls/common"],function(_962,_963,_964,_965,_966,dom,_967,_968,_969,fx,i18n,keys,lang,on,_96a,has,_96b,_96c,_96d,_96e,_96f,_970,_971,_972,_973,_974,_975,_976,_977){var _978=_965("dijit._DialogBase"+(has("dojo-bidi")?"_NoBidi":""),[_971,_973,_974,_972],{templateString:_977,baseClass:"dijitDialog",cssStateNodes:{closeButtonNode:"dijitDialogCloseIcon"},_setTitleAttr:{node:"titleNode",type:"innerHTML"},open:false,duration:_96f.defaultDuration,refocus:true,autofocus:true,_firstFocusItem:null,_lastFocusItem:null,doLayout:false,draggable:true,_setDraggableAttr:function(val){this._set("draggable",val);},maxRatio:0.9,closable:true,_setClosableAttr:function(val){this.closeButtonNode.style.display=val?"":"none";this._set("closable",val);},postMixInProperties:function(){var _979=i18n.getLocalization("dijit","common");lang.mixin(this,_979);this.inherited(arguments);},postCreate:function(){_969.set(this.domNode,{display:"none",position:"absolute"});this.ownerDocumentBody.appendChild(this.domNode);this.inherited(arguments);_964.after(this,"onExecute",lang.hitch(this,"hide"),true);_964.after(this,"onCancel",lang.hitch(this,"hide"),true);this._modalconnects=[];},onLoad:function(){this._size();this._position();if(this.autofocus&&_97a.isTop(this)){this._getFocusItems(this.domNode);_96e.focus(this._firstFocusItem);}this.inherited(arguments);},focus:function(){this._getFocusItems(this.domNode);_96e.focus(this._firstFocusItem);},_endDrag:function(){var _97b=_968.position(this.domNode),_97c=_96b.getBox(this.ownerDocument);_97b.y=Math.min(Math.max(_97b.y,0),(_97c.h-_97b.h));_97b.x=Math.min(Math.max(_97b.x,0),(_97c.w-_97b.w));this._relativePosition=_97b;this._position();},_setup:function(){var node=this.domNode;if(this.titleBar&&this.draggable){this._moveable=new ((has("ie")==6)?_96d:_96c)(node,{handle:this.titleBar});_964.after(this._moveable,"onMoveStop",lang.hitch(this,"_endDrag"),true);}else{_967.add(node,"dijitDialogFixed");}this.underlayAttrs={dialogId:this.id,"class":_963.map(this["class"].split(/\s/),function(s){return s+"_underlay";}).join(" "),_onKeyDown:lang.hitch(this,"_onKey"),ownerDocument:this.ownerDocument};},_size:function(){this._checkIfSingleChild();if(this._singleChild){if(typeof this._singleChildOriginalStyle!="undefined"){this._singleChild.domNode.style.cssText=this._singleChildOriginalStyle;delete this._singleChildOriginalStyle;}}else{_969.set(this.containerNode,{width:"auto",height:"auto"});}var bb=_968.position(this.domNode);var _97d=_96b.getBox(this.ownerDocument);_97d.w*=this.maxRatio;_97d.h*=this.maxRatio;if(bb.w>=_97d.w||bb.h>=_97d.h){var _97e=_968.position(this.containerNode),w=Math.min(bb.w,_97d.w)-(bb.w-_97e.w),h=Math.min(bb.h,_97d.h)-(bb.h-_97e.h);if(this._singleChild&&this._singleChild.resize){if(typeof this._singleChildOriginalStyle=="undefined"){this._singleChildOriginalStyle=this._singleChild.domNode.style.cssText;}this._singleChild.resize({w:w,h:h});}else{_969.set(this.containerNode,{width:w+"px",height:h+"px",overflow:"auto",position:"relative"});}}else{if(this._singleChild&&this._singleChild.resize){this._singleChild.resize();}}},_position:function(){if(!_967.contains(this.ownerDocumentBody,"dojoMove")){var node=this.domNode,_97f=_96b.getBox(this.ownerDocument),p=this._relativePosition,bb=p?null:_968.position(node),l=Math.floor(_97f.l+(p?p.x:(_97f.w-bb.w)/2)),t=Math.floor(_97f.t+(p?p.y:(_97f.h-bb.h)/2));_969.set(node,{left:l+"px",top:t+"px"});}},_onKey:function(evt){if(evt.keyCode==keys.TAB){this._getFocusItems(this.domNode);var node=evt.target;if(this._firstFocusItem==this._lastFocusItem){evt.stopPropagation();evt.preventDefault();}else{if(node==this._firstFocusItem&&evt.shiftKey){_96e.focus(this._lastFocusItem);evt.stopPropagation();evt.preventDefault();}else{if(node==this._lastFocusItem&&!evt.shiftKey){_96e.focus(this._firstFocusItem);evt.stopPropagation();evt.preventDefault();}}}}else{if(this.closable&&evt.keyCode==keys.ESCAPE){this.onCancel();evt.stopPropagation();evt.preventDefault();}}},show:function(){if(this.open){return;}if(!this._started){this.startup();}if(!this._alreadyInitialized){this._setup();this._alreadyInitialized=true;}if(this._fadeOutDeferred){this._fadeOutDeferred.cancel();_97a.hide(this);}var win=_96b.get(this.ownerDocument);this._modalconnects.push(on(win,"scroll",lang.hitch(this,"resize")));this._modalconnects.push(on(this.domNode,"keydown",lang.hitch(this,"_onKey")));_969.set(this.domNode,{opacity:0,display:""});this._set("open",true);this._onShow();this._size();this._position();var _980;this._fadeInDeferred=new _966(lang.hitch(this,function(){_980.stop();delete this._fadeInDeferred;}));var _981=this._fadeInDeferred.promise;_980=fx.fadeIn({node:this.domNode,duration:this.duration,beforeBegin:lang.hitch(this,function(){_97a.show(this,this.underlayAttrs);}),onEnd:lang.hitch(this,function(){if(this.autofocus&&_97a.isTop(this)){this._getFocusItems(this.domNode);_96e.focus(this._firstFocusItem);}this._fadeInDeferred.resolve(true);delete this._fadeInDeferred;})}).play();return _981;},hide:function(){if(!this._alreadyInitialized||!this.open){return;}if(this._fadeInDeferred){this._fadeInDeferred.cancel();}var _982;this._fadeOutDeferred=new _966(lang.hitch(this,function(){_982.stop();delete this._fadeOutDeferred;}));this._fadeOutDeferred.then(lang.hitch(this,"onHide"));var _983=this._fadeOutDeferred.promise;_982=fx.fadeOut({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,function(){this.domNode.style.display="none";_97a.hide(this);this._fadeOutDeferred.resolve(true);delete this._fadeOutDeferred;})}).play();if(this._scrollConnected){this._scrollConnected=false;}var h;while(h=this._modalconnects.pop()){h.remove();}if(this._relativePosition){delete this._relativePosition;}this._set("open",false);return _983;},resize:function(){if(this.domNode.style.display!="none"){this._size();if(!has("touch")){this._position();}}},destroy:function(){if(this._fadeInDeferred){this._fadeInDeferred.cancel();}if(this._fadeOutDeferred){this._fadeOutDeferred.cancel();}if(this._moveable){this._moveable.destroy();}var h;while(h=this._modalconnects.pop()){h.remove();}_97a.hide(this);this.inherited(arguments);}});if(has("dojo-bidi")){_978=_965("dijit._DialogBase",_978,{_setTitleAttr:function(_984){this._set("title",_984);this.titleNode.innerHTML=_984;this.applyTextDir(this.titleNode);},_setTextDirAttr:function(_985){if(this._created&&this.textDir!=_985){this._set("textDir",_985);this.set("title",this.title);}}});}var _986=_965("dijit.Dialog",[_976,_978],{});_986._DialogBase=_978;var _97a=_986._DialogLevelManager={_beginZIndex:950,show:function(_987,_988){ds[ds.length-1].focus=_96e.curNode;var _989=ds[ds.length-1].dialog?ds[ds.length-1].zIndex+2:_986._DialogLevelManager._beginZIndex;_969.set(_987.domNode,"zIndex",_989);_975.show(_988,_989-1);ds.push({dialog:_987,underlayAttrs:_988,zIndex:_989});},hide:function(_98a){if(ds[ds.length-1].dialog==_98a){ds.pop();var pd=ds[ds.length-1];if(ds.length==1){_975.hide();}else{_975.show(pd.underlayAttrs,pd.zIndex-1);}if(_98a.refocus){var _98b=pd.focus;if(pd.dialog&&(!_98b||!dom.isDescendant(_98b,pd.dialog.domNode))){pd.dialog._getFocusItems(pd.dialog.domNode);_98b=pd.dialog._firstFocusItem;}if(_98b){try{_98b.focus();}catch(e){}}}}else{var idx=_963.indexOf(_963.map(ds,function(elem){return elem.dialog;}),_98a);if(idx!=-1){ds.splice(idx,1);}}},isTop:function(_98c){return ds[ds.length-1].dialog==_98c;}};var ds=_986._dialogStack=[{dialog:null,focus:null,underlayAttrs:null}];_96e.watch("curNode",function(attr,_98d,node){var _98e=ds[ds.length-1].dialog;if(node&&_98e&&!_98e._fadeOutDeferred&&node.ownerDocument==_98e.ownerDocument){do{if(node==_98e.domNode||_967.contains(node,"dijitPopup")){return;}}while(node=node.parentNode);_98e.focus();}});if(has("dijit-legacy-requires")){_96a(0,function(){var _98f=["dijit/TooltipDialog"];_962(_98f);});}return _986;});},"dijit/form/MultiSelect":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-geometry","dojo/has","dojo/query","./_FormValueWidget"],function(_990,_991,_992,has,_993,_994){var _995=_991("dijit.form.MultiSelect"+(has("dojo-bidi")?"_NoBidi":""),_994,{size:7,baseClass:"dijitMultiSelect",templateString:"<select multiple='true' ${!nameAttrSetting} data-dojo-attach-point='containerNode,focusNode' data-dojo-attach-event='onchange: _onChange'></select>",addSelected:function(_996){_996.getSelected().forEach(function(n){this.containerNode.appendChild(n);this.domNode.scrollTop=this.domNode.offsetHeight;var _997=_996.domNode.scrollTop;_996.domNode.scrollTop=0;_996.domNode.scrollTop=_997;},this);this._set("value",this.get("value"));},getSelected:function(){return _993("option",this.containerNode).filter(function(n){return n.selected;});},_getValueAttr:function(){return _990.map(this.getSelected(),function(n){return n.value;});},multiple:true,_setValueAttr:function(_998,_999){_993("option",this.containerNode).forEach(function(n){n.selected=(_990.indexOf(_998,n.value)!=-1);});this.inherited(arguments);},invertSelection:function(_99a){var val=[];_993("option",this.containerNode).forEach(function(n){if(!n.selected){val.push(n.value);}});this._setValueAttr(val,!(_99a===false||_99a==null));},_onChange:function(){this._handleOnChange(this.get("value"),true);},resize:function(size){if(size){_992.setMarginBox(this.domNode,size);}},postCreate:function(){this._set("value",this.get("value"));this.inherited(arguments);}});if(has("dojo-bidi")){_995=_991("dijit.form.MultiSelect",_995,{addSelected:function(_99b){_99b.getSelected().forEach(function(n){n.text=this.enforceTextDirWithUcc(this.restoreOriginalText(n),n.text);},this);this.inherited(arguments);},_setTextDirAttr:function(_99c){if((this.textDir!=_99c||!this._created)&&this.enforceTextDirWithUcc){this._set("textDir",_99c);_993("option",this.containerNode).forEach(function(_99d){if(!this._created&&_99d.value===_99d.text){_99d.value=_99d.text;}_99d.text=this.enforceTextDirWithUcc(_99d,_99d.originalText||_99d.text);},this);}}});}return _995;});},"dijit/form/_DateTimeTextBox":function(){define(["dojo/date","dojo/date/locale","dojo/date/stamp","dojo/_base/declare","dojo/_base/lang","./RangeBoundTextBox","../_HasDropDown","dojo/text!./templates/DropDownBox.html"],function(date,_99e,_99f,_9a0,lang,_9a1,_9a2,_9a3){new Date("X");var _9a4=_9a0("dijit.form._DateTimeTextBox",[_9a1,_9a2],{templateString:_9a3,hasDownArrow:true,cssStateNodes:{"_buttonNode":"dijitDownArrowButton"},pattern:_99e.regexp,datePackage:"",postMixInProperties:function(){this.inherited(arguments);this._set("type","text");},compare:function(val1,val2){var _9a5=this._isInvalidDate(val1);var _9a6=this._isInvalidDate(val2);return _9a5?(_9a6?0:-1):(_9a6?1:date.compare(val1,val2,this._selector));},autoWidth:true,format:function(_9a7,_9a8){if(!_9a7){return "";}return this.dateLocaleModule.format(_9a7,_9a8);},"parse":function(_9a9,_9aa){return this.dateLocaleModule.parse(_9a9,_9aa)||(this._isEmpty(_9a9)?null:undefined);},serialize:function(val,_9ab){if(val.toGregorian){val=val.toGregorian();}return _99f.toISOString(val,_9ab);},dropDownDefaultValue:new Date(),value:new Date(""),_blankValue:null,popupClass:"",_selector:"",constructor:function(_9ac){this.dateModule=_9ac.datePackage?lang.getObject(_9ac.datePackage,false):date;this.dateClassObj=this.dateModule.Date||Date;this.dateLocaleModule=_9ac.datePackage?lang.getObject(_9ac.datePackage+".locale",false):_99e;this._set("pattern",this.dateLocaleModule.regexp);this._invalidDate=this.constructor.prototype.value.toString();},buildRendering:function(){this.inherited(arguments);if(!this.hasDownArrow){this._buttonNode.style.display="none";}if(!this.hasDownArrow){this._buttonNode=this.domNode;this.baseClass+=" dijitComboBoxOpenOnClick";}},_setConstraintsAttr:function(_9ad){_9ad.selector=this._selector;_9ad.fullYear=true;var _9ae=_99f.fromISOString;if(typeof _9ad.min=="string"){_9ad.min=_9ae(_9ad.min);}if(typeof _9ad.max=="string"){_9ad.max=_9ae(_9ad.max);}this.inherited(arguments);},_isInvalidDate:function(_9af){return !_9af||isNaN(_9af)||typeof _9af!="object"||_9af.toString()==this._invalidDate;},_setValueAttr:function(_9b0,_9b1,_9b2){if(_9b0!==undefined){if(typeof _9b0=="string"){_9b0=_99f.fromISOString(_9b0);}if(this._isInvalidDate(_9b0)){_9b0=null;}if(_9b0 instanceof Date&&!(this.dateClassObj instanceof Date)){_9b0=new this.dateClassObj(_9b0);}}this.inherited(arguments);if(this.value instanceof Date){this.filterString="";}if(this.dropDown){this.dropDown.set("value",_9b0,false);}},_set:function(attr,_9b3){var _9b4=this._get("value");if(attr=="value"&&_9b4 instanceof Date&&this.compare(_9b3,_9b4)==0){return;}this.inherited(arguments);},_setDropDownDefaultValueAttr:function(val){if(this._isInvalidDate(val)){val=new this.dateClassObj();}this._set("dropDownDefaultValue",val);},openDropDown:function(_9b5){if(this.dropDown){this.dropDown.destroy();}var _9b6=lang.isString(this.popupClass)?lang.getObject(this.popupClass,false):this.popupClass,_9b7=this,_9b8=this.get("value");this.dropDown=new _9b6({onChange:function(_9b9){_9b7.set("value",_9b9,true);},id:this.id+"_popup",dir:_9b7.dir,lang:_9b7.lang,value:_9b8,textDir:_9b7.textDir,currentFocus:!this._isInvalidDate(_9b8)?_9b8:this.dropDownDefaultValue,constraints:_9b7.constraints,filterString:_9b7.filterString,datePackage:_9b7.params.datePackage,isDisabledDate:function(date){return !_9b7.rangeCheck(date,_9b7.constraints);}});this.inherited(arguments);},_getDisplayedValueAttr:function(){return this.textbox.value;},_setDisplayedValueAttr:function(_9ba,_9bb){this._setValueAttr(this.parse(_9ba,this.constraints),_9bb,_9ba);}});return _9a4;});},"dijit/form/_ToggleButtonMixin":function(){define(["dojo/_base/declare","dojo/dom-attr"],function(_9bc,_9bd){return _9bc("dijit.form._ToggleButtonMixin",null,{checked:false,_aria_attr:"aria-pressed",_onClick:function(evt){var _9be=this.checked;this._set("checked",!_9be);var ret=this.inherited(arguments);this.set("checked",ret?this.checked:_9be);return ret;},_setCheckedAttr:function(_9bf,_9c0){this._set("checked",_9bf);var node=this.focusNode||this.domNode;if(this._created){if(_9bd.get(node,"checked")!=!!_9bf){_9bd.set(node,"checked",!!_9bf);}}node.setAttribute(this._aria_attr,String(_9bf));this._handleOnChange(_9bf,_9c0);},postCreate:function(){this.inherited(arguments);var node=this.focusNode||this.domNode;if(this.checked){node.setAttribute("checked","checked");}},reset:function(){this._hasBeenBlurred=false;this.set("checked",this.params.checked||false);}});});},"dijit/Calendar":function(){define(["dojo/_base/array","dojo/date","dojo/date/locale","dojo/_base/declare","dojo/dom-attr","dojo/dom-class","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/on","dojo/sniff","./CalendarLite","./_Widget","./_CssStateMixin","./_TemplatedMixin","./form/DropDownButton"],function(_9c1,date,_9c2,_9c3,_9c4,_9c5,_9c6,keys,lang,on,has,_9c7,_9c8,_9c9,_9ca,_9cb){var _9cc=_9c3("dijit.Calendar",[_9c7,_9c8,_9c9],{cssStateNodes:{"decrementMonth":"dijitCalendarArrow","incrementMonth":"dijitCalendarArrow","previousYearLabelNode":"dijitCalendarPreviousYear","nextYearLabelNode":"dijitCalendarNextYear"},setValue:function(_9cd){_9c6.deprecated("dijit.Calendar:setValue() is deprecated.  Use set('value', ...) instead.","","2.0");this.set("value",_9cd);},_createMonthWidget:function(){return new _9cc._MonthDropDownButton({id:this.id+"_mddb",tabIndex:-1,onMonthSelect:lang.hitch(this,"_onMonthSelect"),lang:this.lang,dateLocaleModule:this.dateLocaleModule},this.monthNode);},postCreate:function(){this.inherited(arguments);this.own(on(this.domNode,"keydown",lang.hitch(this,"_onKeyDown")),on(this.dateRowsNode,"mouseover",lang.hitch(this,"_onDayMouseOver")),on(this.dateRowsNode,"mouseout",lang.hitch(this,"_onDayMouseOut")),on(this.dateRowsNode,"mousedown",lang.hitch(this,"_onDayMouseDown")),on(this.dateRowsNode,"mouseup",lang.hitch(this,"_onDayMouseUp")));},_onMonthSelect:function(_9ce){var date=new this.dateClassObj(this.currentFocus);date.setDate(1);date.setMonth(_9ce);var _9cf=this.dateModule.getDaysInMonth(date);var _9d0=this.currentFocus.getDate();date.setDate(Math.min(_9d0,_9cf));this._setCurrentFocusAttr(date);},_onDayMouseOver:function(evt){var node=_9c5.contains(evt.target,"dijitCalendarDateLabel")?evt.target.parentNode:evt.target;if(node&&((node.dijitDateValue&&!_9c5.contains(node,"dijitCalendarDisabledDate"))||node==this.previousYearLabelNode||node==this.nextYearLabelNode)){_9c5.add(node,"dijitCalendarHoveredDate");this._currentNode=node;}},_onDayMouseOut:function(evt){if(!this._currentNode){return;}if(evt.relatedTarget&&evt.relatedTarget.parentNode==this._currentNode){return;}var cls="dijitCalendarHoveredDate";if(_9c5.contains(this._currentNode,"dijitCalendarActiveDate")){cls+=" dijitCalendarActiveDate";}_9c5.remove(this._currentNode,cls);this._currentNode=null;},_onDayMouseDown:function(evt){var node=evt.target.parentNode;if(node&&node.dijitDateValue&&!_9c5.contains(node,"dijitCalendarDisabledDate")){_9c5.add(node,"dijitCalendarActiveDate");this._currentNode=node;}},_onDayMouseUp:function(evt){var node=evt.target.parentNode;if(node&&node.dijitDateValue){_9c5.remove(node,"dijitCalendarActiveDate");}},handleKey:function(evt){var _9d1=-1,_9d2,_9d3=this.currentFocus;switch(evt.keyCode){case keys.RIGHT_ARROW:_9d1=1;case keys.LEFT_ARROW:_9d2="day";if(!this.isLeftToRight()){_9d1*=-1;}break;case keys.DOWN_ARROW:_9d1=1;case keys.UP_ARROW:_9d2="week";break;case keys.PAGE_DOWN:_9d1=1;case keys.PAGE_UP:_9d2=evt.ctrlKey||evt.altKey?"year":"month";break;case keys.END:_9d3=this.dateModule.add(_9d3,"month",1);_9d2="day";case keys.HOME:_9d3=new this.dateClassObj(_9d3);_9d3.setDate(1);break;default:return true;}if(_9d2){_9d3=this.dateModule.add(_9d3,_9d2,_9d1);}this._setCurrentFocusAttr(_9d3);return false;},_onKeyDown:function(evt){if(!this.handleKey(evt)){evt.stopPropagation();evt.preventDefault();}},onValueSelected:function(){},onChange:function(_9d4){this.onValueSelected(_9d4);},getClassForDate:function(){}});_9cc._MonthDropDownButton=_9c3("dijit.Calendar._MonthDropDownButton",_9cb,{onMonthSelect:function(){},postCreate:function(){this.inherited(arguments);this.dropDown=new _9cc._MonthDropDown({id:this.id+"_mdd",onChange:this.onMonthSelect});},_setMonthAttr:function(_9d5){var _9d6=this.dateLocaleModule.getNames("months","wide","standAlone",this.lang,_9d5);this.dropDown.set("months",_9d6);this.containerNode.innerHTML=(has("ie")==6?"":"<div class='dijitSpacer'>"+this.dropDown.domNode.innerHTML+"</div>")+"<div class='dijitCalendarMonthLabel dijitCalendarCurrentMonthLabel'>"+_9d6[_9d5.getMonth()]+"</div>";}});_9cc._MonthDropDown=_9c3("dijit.Calendar._MonthDropDown",[_9c8,_9ca],{months:[],templateString:"<div class='dijitCalendarMonthMenu dijitMenu' "+"data-dojo-attach-event='onclick:_onClick,onmouseover:_onMenuHover,onmouseout:_onMenuHover'></div>",_setMonthsAttr:function(_9d7){this.domNode.innerHTML=_9c1.map(_9d7,function(_9d8,idx){return _9d8?"<div class='dijitCalendarMonthLabel' month='"+idx+"'>"+_9d8+"</div>":"";}).join("");},_onClick:function(evt){this.onChange(_9c4.get(evt.target,"month"));},onChange:function(){},_onMenuHover:function(evt){_9c5.toggle(evt.target,"dijitCalendarMonthLabelHover",evt.type=="mouseover");}});return _9cc;});},"dojo/fx":function(){define(["./_base/lang","./Evented","./_base/kernel","./_base/array","./aspect","./_base/fx","./dom","./dom-style","./dom-geometry","./ready","require"],function(lang,_9d9,dojo,_9da,_9db,_9dc,dom,_9dd,geom,_9de,_9df){if(!dojo.isAsync){_9de(0,function(){var _9e0=["./fx/Toggler"];_9df(_9e0);});}var _9e1=dojo.fx={};var _9e2={_fire:function(evt,args){if(this[evt]){this[evt].apply(this,args||[]);}return this;}};var _9e3=function(_9e4){this._index=-1;this._animations=_9e4||[];this._current=this._onAnimateCtx=this._onEndCtx=null;this.duration=0;_9da.forEach(this._animations,function(a){this.duration+=a.duration;if(a.delay){this.duration+=a.delay;}},this);};_9e3.prototype=new _9d9();lang.extend(_9e3,{_onAnimate:function(){this._fire("onAnimate",arguments);},_onEnd:function(){this._onAnimateCtx.remove();this._onEndCtx.remove();this._onAnimateCtx=this._onEndCtx=null;if(this._index+1==this._animations.length){this._fire("onEnd");}else{this._current=this._animations[++this._index];this._onAnimateCtx=_9db.after(this._current,"onAnimate",lang.hitch(this,"_onAnimate"),true);this._onEndCtx=_9db.after(this._current,"onEnd",lang.hitch(this,"_onEnd"),true);this._current.play(0,true);}},play:function(_9e5,_9e6){if(!this._current){this._current=this._animations[this._index=0];}if(!_9e6&&this._current.status()=="playing"){return this;}var _9e7=_9db.after(this._current,"beforeBegin",lang.hitch(this,function(){this._fire("beforeBegin");}),true),_9e8=_9db.after(this._current,"onBegin",lang.hitch(this,function(arg){this._fire("onBegin",arguments);}),true),_9e9=_9db.after(this._current,"onPlay",lang.hitch(this,function(arg){this._fire("onPlay",arguments);_9e7.remove();_9e8.remove();_9e9.remove();}));if(this._onAnimateCtx){this._onAnimateCtx.remove();}this._onAnimateCtx=_9db.after(this._current,"onAnimate",lang.hitch(this,"_onAnimate"),true);if(this._onEndCtx){this._onEndCtx.remove();}this._onEndCtx=_9db.after(this._current,"onEnd",lang.hitch(this,"_onEnd"),true);this._current.play.apply(this._current,arguments);return this;},pause:function(){if(this._current){var e=_9db.after(this._current,"onPause",lang.hitch(this,function(arg){this._fire("onPause",arguments);e.remove();}),true);this._current.pause();}return this;},gotoPercent:function(_9ea,_9eb){this.pause();var _9ec=this.duration*_9ea;this._current=null;_9da.some(this._animations,function(a){if(a.duration<=_9ec){this._current=a;return true;}_9ec-=a.duration;return false;});if(this._current){this._current.gotoPercent(_9ec/this._current.duration,_9eb);}return this;},stop:function(_9ed){if(this._current){if(_9ed){for(;this._index+1<this._animations.length;++this._index){this._animations[this._index].stop(true);}this._current=this._animations[this._index];}var e=_9db.after(this._current,"onStop",lang.hitch(this,function(arg){this._fire("onStop",arguments);e.remove();}),true);this._current.stop();}return this;},status:function(){return this._current?this._current.status():"stopped";},destroy:function(){if(this._onAnimateCtx){this._onAnimateCtx.remove();}if(this._onEndCtx){this._onEndCtx.remove();}}});lang.extend(_9e3,_9e2);_9e1.chain=function(_9ee){return new _9e3(_9ee);};var _9ef=function(_9f0){this._animations=_9f0||[];this._connects=[];this._finished=0;this.duration=0;_9da.forEach(_9f0,function(a){var _9f1=a.duration;if(a.delay){_9f1+=a.delay;}if(this.duration<_9f1){this.duration=_9f1;}this._connects.push(_9db.after(a,"onEnd",lang.hitch(this,"_onEnd"),true));},this);this._pseudoAnimation=new _9dc.Animation({curve:[0,1],duration:this.duration});var self=this;_9da.forEach(["beforeBegin","onBegin","onPlay","onAnimate","onPause","onStop","onEnd"],function(evt){self._connects.push(_9db.after(self._pseudoAnimation,evt,function(){self._fire(evt,arguments);},true));});};lang.extend(_9ef,{_doAction:function(_9f2,args){_9da.forEach(this._animations,function(a){a[_9f2].apply(a,args);});return this;},_onEnd:function(){if(++this._finished>this._animations.length){this._fire("onEnd");}},_call:function(_9f3,args){var t=this._pseudoAnimation;t[_9f3].apply(t,args);},play:function(_9f4,_9f5){this._finished=0;this._doAction("play",arguments);this._call("play",arguments);return this;},pause:function(){this._doAction("pause",arguments);this._call("pause",arguments);return this;},gotoPercent:function(_9f6,_9f7){var ms=this.duration*_9f6;_9da.forEach(this._animations,function(a){a.gotoPercent(a.duration<ms?1:(ms/a.duration),_9f7);});this._call("gotoPercent",arguments);return this;},stop:function(_9f8){this._doAction("stop",arguments);this._call("stop",arguments);return this;},status:function(){return this._pseudoAnimation.status();},destroy:function(){_9da.forEach(this._connects,function(_9f9){_9f9.remove();});}});lang.extend(_9ef,_9e2);_9e1.combine=function(_9fa){return new _9ef(_9fa);};_9e1.wipeIn=function(args){var node=args.node=dom.byId(args.node),s=node.style,o;var anim=_9dc.animateProperty(lang.mixin({properties:{height:{start:function(){o=s.overflow;s.overflow="hidden";if(s.visibility=="hidden"||s.display=="none"){s.height="1px";s.display="";s.visibility="";return 1;}else{var _9fb=_9dd.get(node,"height");return Math.max(_9fb,1);}},end:function(){return node.scrollHeight;}}}},args));var fini=function(){s.height="auto";s.overflow=o;};_9db.after(anim,"onStop",fini,true);_9db.after(anim,"onEnd",fini,true);return anim;};_9e1.wipeOut=function(args){var node=args.node=dom.byId(args.node),s=node.style,o;var anim=_9dc.animateProperty(lang.mixin({properties:{height:{end:1}}},args));_9db.after(anim,"beforeBegin",function(){o=s.overflow;s.overflow="hidden";s.display="";},true);var fini=function(){s.overflow=o;s.height="auto";s.display="none";};_9db.after(anim,"onStop",fini,true);_9db.after(anim,"onEnd",fini,true);return anim;};_9e1.slideTo=function(args){var node=args.node=dom.byId(args.node),top=null,left=null;var init=(function(n){return function(){var cs=_9dd.getComputedStyle(n);var pos=cs.position;top=(pos=="absolute"?n.offsetTop:parseInt(cs.top)||0);left=(pos=="absolute"?n.offsetLeft:parseInt(cs.left)||0);if(pos!="absolute"&&pos!="relative"){var ret=geom.position(n,true);top=ret.y;left=ret.x;n.style.position="absolute";n.style.top=top+"px";n.style.left=left+"px";}};})(node);init();var anim=_9dc.animateProperty(lang.mixin({properties:{top:args.top||0,left:args.left||0}},args));_9db.after(anim,"beforeBegin",init,true);return anim;};return _9e1;});},"dijit/_DialogMixin":function(){define(["dojo/_base/declare","./a11y"],function(_9fc,a11y){return _9fc("dijit._DialogMixin",null,{execute:function(){},onCancel:function(){},onExecute:function(){},_onSubmit:function(){this.onExecute();this.execute(this.get("value"));},_getFocusItems:function(){var _9fd=a11y._getTabNavigable(this.containerNode);this._firstFocusItem=_9fd.lowest||_9fd.first||this.closeButtonNode||this.domNode;this._lastFocusItem=_9fd.last||_9fd.highest||this._firstFocusItem;}});});},"dijit/Tree":function(){define(["dojo/_base/array","dojo/aspect","dojo/_base/connect","dojo/cookie","dojo/_base/declare","dojo/Deferred","dojo/promise/all","dojo/dom","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/errors/create","dojo/fx","dojo/has","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/on","dojo/topic","dojo/touch","dojo/when","./a11yclick","./focus","./registry","./_base/manager","./_Widget","./_TemplatedMixin","./_Container","./_Contained","./_CssStateMixin","./_KeyNavMixin","dojo/text!./templates/TreeNode.html","dojo/text!./templates/Tree.html","./tree/TreeStoreModel","./tree/ForestStoreModel","./tree/_dndSelector","dojo/query!css2"],function(_9fe,_9ff,_a00,_a01,_a02,_a03,all,dom,_a04,_a05,_a06,_a07,_a08,has,_a09,keys,lang,on,_a0a,_a0b,when,_a0c,_a0d,_a0e,_a0f,_a10,_a11,_a12,_a13,_a14,_a15,_a16,_a17,_a18,_a19,_a1a){function _a1b(d){return lang.delegate(d.promise||d,{addCallback:function(_a1c){this.then(_a1c);},addErrback:function(_a1d){this.otherwise(_a1d);}});};var _a1e=_a02("dijit._TreeNode",[_a10,_a11,_a12,_a13,_a14],{item:null,isTreeNode:true,label:"",_setLabelAttr:function(val){this.labelNode[this.labelType=="html"?"innerHTML":"innerText" in this.labelNode?"innerText":"textContent"]=val;this._set("label",val);},labelType:"text",isExpandable:null,isExpanded:false,state:"NotLoaded",templateString:_a16,baseClass:"dijitTreeNode",cssStateNodes:{rowNode:"dijitTreeRow"},_setTooltipAttr:{node:"rowNode",type:"attribute",attribute:"title"},buildRendering:function(){this.inherited(arguments);this._setExpando();this._updateItemClasses(this.item);if(this.isExpandable){this.labelNode.setAttribute("aria-expanded",this.isExpanded);}this.setSelected(false);},_setIndentAttr:function(_a1f){var _a20=(Math.max(_a1f,0)*this.tree._nodePixelIndent)+"px";_a06.set(this.domNode,"backgroundPosition",_a20+" 0px");_a06.set(this.rowNode,this.isLeftToRight()?"paddingLeft":"paddingRight",_a20);_9fe.forEach(this.getChildren(),function(_a21){_a21.set("indent",_a1f+1);});this._set("indent",_a1f);},markProcessing:function(){this.state="Loading";this._setExpando(true);},unmarkProcessing:function(){this._setExpando(false);},_updateItemClasses:function(item){var tree=this.tree,_a22=tree.model;if(tree._v10Compat&&item===_a22.root){item=null;}this._applyClassAndStyle(item,"icon","Icon");this._applyClassAndStyle(item,"label","Label");this._applyClassAndStyle(item,"row","Row");this.tree._startPaint(true);},_applyClassAndStyle:function(item,_a23,_a24){var _a25="_"+_a23+"Class";var _a26=_a23+"Node";var _a27=this[_a25];this[_a25]=this.tree["get"+_a24+"Class"](item,this.isExpanded);_a04.replace(this[_a26],this[_a25]||"",_a27||"");_a06.set(this[_a26],this.tree["get"+_a24+"Style"](item,this.isExpanded)||{});},_updateLayout:function(){var _a28=this.getParent();if(!_a28||!_a28.rowNode||_a28.rowNode.style.display=="none"){_a04.add(this.domNode,"dijitTreeIsRoot");}else{_a04.toggle(this.domNode,"dijitTreeIsLast",!this.getNextSibling());}},_setExpando:function(_a29){var _a2a=["dijitTreeExpandoLoading","dijitTreeExpandoOpened","dijitTreeExpandoClosed","dijitTreeExpandoLeaf"],_a2b=["*","-","+","*"],idx=_a29?0:(this.isExpandable?(this.isExpanded?1:2):3);_a04.replace(this.expandoNode,_a2a[idx],_a2a);this.expandoNodeText.innerHTML=_a2b[idx];},expand:function(){if(this._expandDeferred){return _a1b(this._expandDeferred);}if(this._collapseDeferred){this._collapseDeferred.cancel();delete this._collapseDeferred;}this.isExpanded=true;this.labelNode.setAttribute("aria-expanded","true");if(this.tree.showRoot||this!==this.tree.rootNode){this.containerNode.setAttribute("role","group");}_a04.add(this.contentNode,"dijitTreeContentExpanded");this._setExpando();this._updateItemClasses(this.item);if(this==this.tree.rootNode&&this.tree.showRoot){this.tree.domNode.setAttribute("aria-expanded","true");}var _a2c=_a08.wipeIn({node:this.containerNode,duration:_a0f.defaultDuration});var def=(this._expandDeferred=new _a03(function(){_a2c.stop();}));_9ff.after(_a2c,"onEnd",function(){def.resolve(true);},true);_a2c.play();return _a1b(def);},collapse:function(){if(this._collapseDeferred){return _a1b(this._collapseDeferred);}if(this._expandDeferred){this._expandDeferred.cancel();delete this._expandDeferred;}this.isExpanded=false;this.labelNode.setAttribute("aria-expanded","false");if(this==this.tree.rootNode&&this.tree.showRoot){this.tree.domNode.setAttribute("aria-expanded","false");}_a04.remove(this.contentNode,"dijitTreeContentExpanded");this._setExpando();this._updateItemClasses(this.item);var _a2d=_a08.wipeOut({node:this.containerNode,duration:_a0f.defaultDuration});var def=(this._collapseDeferred=new _a03(function(){_a2d.stop();}));_9ff.after(_a2d,"onEnd",function(){def.resolve(true);},true);_a2d.play();return _a1b(def);},indent:0,setChildItems:function(_a2e){var tree=this.tree,_a2f=tree.model,defs=[];var _a30=this.getChildren();_9fe.forEach(_a30,function(_a31){_a12.prototype.removeChild.call(this,_a31);},this);this.defer(function(){_9fe.forEach(_a30,function(node){if(!node._destroyed&&!node.getParent()){tree.dndController.removeTreeNode(node);function _a32(node){var id=_a2f.getIdentity(node.item),ary=tree._itemNodesMap[id];if(ary.length==1){delete tree._itemNodesMap[id];}else{var _a33=_9fe.indexOf(ary,node);if(_a33!=-1){ary.splice(_a33,1);}}_9fe.forEach(node.getChildren(),_a32);};_a32(node);if(tree.persist){var _a34=_9fe.map(node.getTreePath(),function(item){return tree.model.getIdentity(item);}).join("/");for(var path in tree._openedNodes){if(path.substr(0,_a34.length)==_a34){delete tree._openedNodes[path];}}tree._saveExpandedNodes();}node.destroyRecursive();}});});this.state="Loaded";if(_a2e&&_a2e.length>0){this.isExpandable=true;_9fe.forEach(_a2e,function(item){var id=_a2f.getIdentity(item),_a35=tree._itemNodesMap[id],node;if(_a35){for(var i=0;i<_a35.length;i++){if(_a35[i]&&!_a35[i].getParent()){node=_a35[i];node.set("indent",this.indent+1);break;}}}if(!node){node=this.tree._createTreeNode({item:item,tree:tree,isExpandable:_a2f.mayHaveChildren(item),label:tree.getLabel(item),labelType:(tree.model&&tree.model.labelType)||"text",tooltip:tree.getTooltip(item),ownerDocument:tree.ownerDocument,dir:tree.dir,lang:tree.lang,textDir:tree.textDir,indent:this.indent+1});if(_a35){_a35.push(node);}else{tree._itemNodesMap[id]=[node];}}this.addChild(node);if(this.tree.autoExpand||this.tree._state(node)){defs.push(tree._expandNode(node));}},this);_9fe.forEach(this.getChildren(),function(_a36){_a36._updateLayout();});}else{this.isExpandable=false;}if(this._setExpando){this._setExpando(false);}this._updateItemClasses(this.item);var def=all(defs);this.tree._startPaint(def);return _a1b(def);},getTreePath:function(){var node=this;var path=[];while(node&&node!==this.tree.rootNode){path.unshift(node.item);node=node.getParent();}path.unshift(this.tree.rootNode.item);return path;},getIdentity:function(){return this.tree.model.getIdentity(this.item);},removeChild:function(node){this.inherited(arguments);var _a37=this.getChildren();if(_a37.length==0){this.isExpandable=false;this.collapse();}_9fe.forEach(_a37,function(_a38){_a38._updateLayout();});},makeExpandable:function(){this.isExpandable=true;this._setExpando(false);},setSelected:function(_a39){this.labelNode.setAttribute("aria-selected",_a39?"true":"false");_a04.toggle(this.rowNode,"dijitTreeRowSelected",_a39);},focus:function(){_a0d.focus(this.focusNode);}});if(has("dojo-bidi")){_a1e.extend({_setTextDirAttr:function(_a3a){if(_a3a&&((this.textDir!=_a3a)||!this._created)){this._set("textDir",_a3a);this.applyTextDir(this.labelNode);_9fe.forEach(this.getChildren(),function(_a3b){_a3b.set("textDir",_a3a);},this);}}});}var Tree=_a02("dijit.Tree",[_a10,_a15,_a11,_a14],{baseClass:"dijitTree",store:null,model:null,query:null,label:"",showRoot:true,childrenAttr:["children"],paths:[],path:[],selectedItems:null,selectedItem:null,openOnClick:false,openOnDblClick:false,templateString:_a17,persist:false,autoExpand:false,dndController:_a1a,dndParams:["onDndDrop","itemCreator","onDndCancel","checkAcceptance","checkItemAcceptance","dragThreshold","betweenThreshold"],onDndDrop:null,itemCreator:null,onDndCancel:null,checkAcceptance:null,checkItemAcceptance:null,dragThreshold:5,betweenThreshold:0,_nodePixelIndent:19,_publish:function(_a3c,_a3d){_a0a.publish(this.id,lang.mixin({tree:this,event:_a3c},_a3d||{}));},postMixInProperties:function(){this.tree=this;if(this.autoExpand){this.persist=false;}this._itemNodesMap={};if(!this.cookieName&&this.id){this.cookieName=this.id+"SaveStateCookie";}this.expandChildrenDeferred=new _a03();this.pendingCommandsPromise=this.expandChildrenDeferred.promise;this.inherited(arguments);},postCreate:function(){this._initState();var self=this;this.own(on(this.containerNode,on.selector(".dijitTreeNode",_a0b.enter),function(evt){self._onNodeMouseEnter(_a0e.byNode(this),evt);}),on(this.containerNode,on.selector(".dijitTreeNode",_a0b.leave),function(evt){self._onNodeMouseLeave(_a0e.byNode(this),evt);}),on(this.containerNode,_a0c,function(evt){var node=_a0e.getEnclosingWidget(evt.target);if(node.isInstanceOf(_a1e)){self._onClick(node,evt);}}),on(this.containerNode,on.selector(".dijitTreeNode","dblclick"),function(evt){self._onDblClick(_a0e.byNode(this),evt);}));if(!this.model){this._store2model();}this.own(_9ff.after(this.model,"onChange",lang.hitch(this,"_onItemChange"),true),_9ff.after(this.model,"onChildrenChange",lang.hitch(this,"_onItemChildrenChange"),true),_9ff.after(this.model,"onDelete",lang.hitch(this,"_onItemDelete"),true));this.inherited(arguments);if(this.dndController){if(lang.isString(this.dndController)){this.dndController=lang.getObject(this.dndController);}var _a3e={};for(var i=0;i<this.dndParams.length;i++){if(this[this.dndParams[i]]){_a3e[this.dndParams[i]]=this[this.dndParams[i]];}}this.dndController=new this.dndController(this,_a3e);}this._load();this.onLoadDeferred=_a1b(this.pendingCommandsPromise);this.onLoadDeferred.then(lang.hitch(this,"onLoad"));},_store2model:function(){this._v10Compat=true;_a09.deprecated("Tree: from version 2.0, should specify a model object rather than a store/query");var _a3f={id:this.id+"_ForestStoreModel",store:this.store,query:this.query,childrenAttrs:this.childrenAttr};if(this.params.mayHaveChildren){_a3f.mayHaveChildren=lang.hitch(this,"mayHaveChildren");}if(this.params.getItemChildren){_a3f.getChildren=lang.hitch(this,function(item,_a40,_a41){this.getItemChildren((this._v10Compat&&item===this.model.root)?null:item,_a40,_a41);});}this.model=new _a19(_a3f);this.showRoot=Boolean(this.label);},onLoad:function(){},_load:function(){this.model.getRoot(lang.hitch(this,function(item){var rn=(this.rootNode=this.tree._createTreeNode({item:item,tree:this,isExpandable:true,label:this.label||this.getLabel(item),labelType:this.model.labelType||"text",textDir:this.textDir,indent:this.showRoot?0:-1}));if(!this.showRoot){rn.rowNode.style.display="none";this.domNode.setAttribute("role","presentation");this.domNode.removeAttribute("aria-expanded");this.domNode.removeAttribute("aria-multiselectable");if(this["aria-label"]){rn.containerNode.setAttribute("aria-label",this["aria-label"]);this.domNode.removeAttribute("aria-label");}else{if(this["aria-labelledby"]){rn.containerNode.setAttribute("aria-labelledby",this["aria-labelledby"]);this.domNode.removeAttribute("aria-labelledby");}}rn.labelNode.setAttribute("role","presentation");rn.containerNode.setAttribute("role","tree");rn.containerNode.setAttribute("aria-expanded","true");rn.containerNode.setAttribute("aria-multiselectable",!this.dndController.singular);}else{this.domNode.setAttribute("aria-multiselectable",!this.dndController.singular);this.rootLoadingIndicator.style.display="none";}this.containerNode.appendChild(rn.domNode);var _a42=this.model.getIdentity(item);if(this._itemNodesMap[_a42]){this._itemNodesMap[_a42].push(rn);}else{this._itemNodesMap[_a42]=[rn];}rn._updateLayout();this._expandNode(rn).then(lang.hitch(this,function(){this.rootLoadingIndicator.style.display="none";this.expandChildrenDeferred.resolve(true);}));}),lang.hitch(this,function(err){console.error(this,": error loading root: ",err);}));},getNodesByItem:function(item){if(!item){return [];}var _a43=lang.isString(item)?item:this.model.getIdentity(item);return [].concat(this._itemNodesMap[_a43]);},_setSelectedItemAttr:function(item){this.set("selectedItems",[item]);},_setSelectedItemsAttr:function(_a44){var tree=this;return this.pendingCommandsPromise=this.pendingCommandsPromise.always(lang.hitch(this,function(){var _a45=_9fe.map(_a44,function(item){return (!item||lang.isString(item))?item:tree.model.getIdentity(item);});var _a46=[];_9fe.forEach(_a45,function(id){_a46=_a46.concat(tree._itemNodesMap[id]||[]);});this.set("selectedNodes",_a46);}));},_setPathAttr:function(path){if(path.length){return _a1b(this.set("paths",[path]).then(function(_a47){return _a47[0];}));}else{return _a1b(this.set("paths",[]).then(function(_a48){return _a48[0];}));}},_setPathsAttr:function(_a49){var tree=this;function _a4a(path,_a4b){var _a4c=path.shift();var _a4d=_9fe.filter(_a4b,function(node){return node.getIdentity()==_a4c;})[0];if(!!_a4d){if(path.length){return tree._expandNode(_a4d).then(function(){return _a4a(path,_a4d.getChildren());});}else{return _a4d;}}else{throw new Tree.PathError("Could not expand path at "+_a4c);}};return _a1b(this.pendingCommandsPromise=this.pendingCommandsPromise.always(function(){return all(_9fe.map(_a49,function(path){path=_9fe.map(path,function(item){return lang.isString(item)?item:tree.model.getIdentity(item);});if(path.length){return _a4a(path,[tree.rootNode]);}else{throw new Tree.PathError("Empty path");}}));}).then(function setNodes(_a4e){tree.set("selectedNodes",_a4e);return tree.paths;}));},_setSelectedNodeAttr:function(node){this.set("selectedNodes",[node]);},_setSelectedNodesAttr:function(_a4f){this.dndController.setSelection(_a4f);},expandAll:function(){var _a50=this;function _a51(node){return _a50._expandNode(node).then(function(){var _a52=_9fe.filter(node.getChildren()||[],function(node){return node.isExpandable;});return all(_9fe.map(_a52,_a51));});};return _a1b(_a51(this.rootNode));},collapseAll:function(){var _a53=this;function _a54(node){var _a55=_9fe.filter(node.getChildren()||[],function(node){return node.isExpandable;}),defs=all(_9fe.map(_a55,_a54));if(!node.isExpanded||(node==_a53.rootNode&&!_a53.showRoot)){return defs;}else{return defs.then(function(){return _a53._collapseNode(node);});}};return _a1b(_a54(this.rootNode));},mayHaveChildren:function(){},getItemChildren:function(){},getLabel:function(item){return this.model.getLabel(item);},getIconClass:function(item,_a56){return (!item||this.model.mayHaveChildren(item))?(_a56?"dijitFolderOpened":"dijitFolderClosed"):"dijitLeaf";},getLabelClass:function(){},getRowClass:function(){},getIconStyle:function(){},getLabelStyle:function(){},getRowStyle:function(){},getTooltip:function(){return "";},_onDownArrow:function(evt,node){var _a57=this._getNext(node);if(_a57&&_a57.isTreeNode){this.focusNode(_a57);}},_onUpArrow:function(evt,node){var _a58=node.getPreviousSibling();if(_a58){node=_a58;while(node.isExpandable&&node.isExpanded&&node.hasChildren()){var _a59=node.getChildren();node=_a59[_a59.length-1];}}else{var _a5a=node.getParent();if(!(!this.showRoot&&_a5a===this.rootNode)){node=_a5a;}}if(node&&node.isTreeNode){this.focusNode(node);}},_onRightArrow:function(evt,node){if(node.isExpandable&&!node.isExpanded){this._expandNode(node);}else{if(node.hasChildren()){node=node.getChildren()[0];if(node&&node.isTreeNode){this.focusNode(node);}}}},_onLeftArrow:function(evt,node){if(node.isExpandable&&node.isExpanded){this._collapseNode(node);}else{var _a5b=node.getParent();if(_a5b&&_a5b.isTreeNode&&!(!this.showRoot&&_a5b===this.rootNode)){this.focusNode(_a5b);}}},focusLastChild:function(){var node=this._getLast();if(node&&node.isTreeNode){this.focusNode(node);}},_getFirst:function(){return this.showRoot?this.rootNode:this.rootNode.getChildren()[0];},_getLast:function(){var node=this.rootNode;while(node.isExpanded){var c=node.getChildren();if(!c.length){break;}node=c[c.length-1];}return node;},_getNext:function(node){if(node.isExpandable&&node.isExpanded&&node.hasChildren()){return node.getChildren()[0];}else{while(node&&node.isTreeNode){var _a5c=node.getNextSibling();if(_a5c){return _a5c;}node=node.getParent();}return null;}},childSelector:".dijitTreeRow",isExpandoNode:function(node,_a5d){return dom.isDescendant(node,_a5d.expandoNode)||dom.isDescendant(node,_a5d.expandoNodeText);},__click:function(_a5e,e,_a5f,func){var _a60=e.target,_a61=this.isExpandoNode(_a60,_a5e);if(_a5e.isExpandable&&(_a5f||_a61)){this._onExpandoClick({node:_a5e});}else{this._publish("execute",{item:_a5e.item,node:_a5e,evt:e});this[func](_a5e.item,_a5e,e);this.focusNode(_a5e);}e.stopPropagation();e.preventDefault();},_onClick:function(_a62,e){this.__click(_a62,e,this.openOnClick,"onClick");},_onDblClick:function(_a63,e){this.__click(_a63,e,this.openOnDblClick,"onDblClick");},_onExpandoClick:function(_a64){var node=_a64.node;this.focusNode(node);if(node.isExpanded){this._collapseNode(node);}else{this._expandNode(node);}},onClick:function(){},onDblClick:function(){},onOpen:function(){},onClose:function(){},_getNextNode:function(node){_a09.deprecated(this.declaredClass+"::_getNextNode(node) is deprecated. Use _getNext(node) instead.","","2.0");return this._getNext(node);},_getRootOrFirstNode:function(){_a09.deprecated(this.declaredClass+"::_getRootOrFirstNode() is deprecated. Use _getFirst() instead.","","2.0");return this._getFirst();},_collapseNode:function(node){if(node._expandNodeDeferred){delete node._expandNodeDeferred;}if(node.state=="Loading"){return;}if(node.isExpanded){var ret=node.collapse();this.onClose(node.item,node);this._state(node,false);this._startPaint(ret);return ret;}},_expandNode:function(node){if(node._expandNodeDeferred){return node._expandNodeDeferred;}var _a65=this.model,item=node.item,_a66=this;if(!node._loadDeferred){node.markProcessing();node._loadDeferred=new _a03();_a65.getChildren(item,function(_a67){node.unmarkProcessing();node.setChildItems(_a67).then(function(){node._loadDeferred.resolve(_a67);});},function(err){console.error(_a66,": error loading "+node.label+" children: ",err);node._loadDeferred.reject(err);});}var def=node._loadDeferred.then(lang.hitch(this,function(){var def2=node.expand();this.onOpen(node.item,node);this._state(node,true);return def2;}));this._startPaint(def);return def;},focusNode:function(node){this.focusChild(node);},_onNodeMouseEnter:function(){},_onNodeMouseLeave:function(){},_onItemChange:function(item){var _a68=this.model,_a69=_a68.getIdentity(item),_a6a=this._itemNodesMap[_a69];if(_a6a){var _a6b=this.getLabel(item),_a6c=this.getTooltip(item);_9fe.forEach(_a6a,function(node){node.set({item:item,label:_a6b,tooltip:_a6c});node._updateItemClasses(item);});}},_onItemChildrenChange:function(_a6d,_a6e){var _a6f=this.model,_a70=_a6f.getIdentity(_a6d),_a71=this._itemNodesMap[_a70];if(_a71){_9fe.forEach(_a71,function(_a72){_a72.setChildItems(_a6e);});}},_onItemDelete:function(item){var _a73=this.model,_a74=_a73.getIdentity(item),_a75=this._itemNodesMap[_a74];if(_a75){_9fe.forEach(_a75,function(node){this.dndController.removeTreeNode(node);var _a76=node.getParent();if(_a76){_a76.removeChild(node);}node.destroyRecursive();},this);delete this._itemNodesMap[_a74];}},_initState:function(){this._openedNodes={};if(this.persist&&this.cookieName){var oreo=_a01(this.cookieName);if(oreo){_9fe.forEach(oreo.split(","),function(item){this._openedNodes[item]=true;},this);}}},_state:function(node,_a77){if(!this.persist){return false;}var path=_9fe.map(node.getTreePath(),function(item){return this.model.getIdentity(item);},this).join("/");if(arguments.length===1){return this._openedNodes[path];}else{if(_a77){this._openedNodes[path]=true;}else{delete this._openedNodes[path];}this._saveExpandedNodes();}},_saveExpandedNodes:function(){if(this.persist&&this.cookieName){var ary=[];for(var id in this._openedNodes){ary.push(id);}_a01(this.cookieName,ary.join(","),{expires:365});}},destroy:function(){if(this._curSearch){this._curSearch.timer.remove();delete this._curSearch;}if(this.rootNode){this.rootNode.destroyRecursive();}if(this.dndController&&!lang.isString(this.dndController)){this.dndController.destroy();}this.rootNode=null;this.inherited(arguments);},destroyRecursive:function(){this.destroy();},resize:function(_a78){if(_a78){_a05.setMarginBox(this.domNode,_a78);}this._nodePixelIndent=_a05.position(this.tree.indentDetector).w||this._nodePixelIndent;this.expandChildrenDeferred.then(lang.hitch(this,function(){this.rootNode.set("indent",this.showRoot?0:-1);this._adjustWidths();}));},_outstandingPaintOperations:0,_startPaint:function(p){this._outstandingPaintOperations++;if(this._adjustWidthsTimer){this._adjustWidthsTimer.remove();delete this._adjustWidthsTimer;}var oc=lang.hitch(this,function(){this._outstandingPaintOperations--;if(this._outstandingPaintOperations<=0&&!this._adjustWidthsTimer&&this._started){this._adjustWidthsTimer=this.defer("_adjustWidths");}});when(p,oc,oc);},_adjustWidths:function(){if(this._adjustWidthsTimer){this._adjustWidthsTimer.remove();delete this._adjustWidthsTimer;}this.containerNode.style.width="auto";this.containerNode.style.width=this.domNode.scrollWidth>this.domNode.offsetWidth?"auto":"100%";},_createTreeNode:function(args){return new _a1e(args);},focus:function(){if(this.lastFocusedChild){this.focusNode(this.lastFocusedChild);}else{this.focusFirstChild();}}});if(has("dojo-bidi")){Tree.extend({_setTextDirAttr:function(_a79){if(_a79&&this.textDir!=_a79){this._set("textDir",_a79);this.rootNode.set("textDir",_a79);}}});}Tree.PathError=_a07("TreePathError");Tree._TreeNode=_a1e;return Tree;});},"dijit/form/HorizontalSlider":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dnd/move","dojo/_base/fx","dojo/dom-geometry","dojo/dom-style","dojo/keys","dojo/_base/lang","dojo/sniff","dojo/dnd/Moveable","dojo/dnd/Mover","dojo/query","dojo/mouse","dojo/on","../_base/manager","../focus","../typematic","./Button","./_FormValueWidget","../_Container","dojo/text!./templates/HorizontalSlider.html"],function(_a7a,_a7b,move,fx,_a7c,_a7d,keys,lang,has,_a7e,_a7f,_a80,_a81,on,_a82,_a83,_a84,_a85,_a86,_a87,_a88){var _a89=_a7b("dijit.form._SliderMover",_a7f,{onMouseMove:function(e){var _a8a=this.widget;var _a8b=_a8a._abspos;if(!_a8b){_a8b=_a8a._abspos=_a7c.position(_a8a.sliderBarContainer,true);_a8a._setPixelValue_=lang.hitch(_a8a,"_setPixelValue");_a8a._isReversed_=_a8a._isReversed();}var _a8c=e[_a8a._mousePixelCoord]-_a8b[_a8a._startingPixelCoord];_a8a._setPixelValue_(_a8a._isReversed_?(_a8b[_a8a._pixelCount]-_a8c):_a8c,_a8b[_a8a._pixelCount],false);},destroy:function(e){_a7f.prototype.destroy.apply(this,arguments);var _a8d=this.widget;_a8d._abspos=null;_a8d._setValueAttr(_a8d.value,true);}});var _a8e=_a7b("dijit.form.HorizontalSlider",[_a86,_a87],{templateString:_a88,value:0,showButtons:true,minimum:0,maximum:100,discreteValues:Infinity,pageIncrement:2,clickSelect:true,slideDuration:_a82.defaultDuration,_setIdAttr:"",_setNameAttr:"valueNode",baseClass:"dijitSlider",cssStateNodes:{incrementButton:"dijitSliderIncrementButton",decrementButton:"dijitSliderDecrementButton",focusNode:"dijitSliderThumb"},_mousePixelCoord:"pageX",_pixelCount:"w",_startingPixelCoord:"x",_handleOffsetCoord:"left",_progressPixelSize:"width",_onKeyUp:function(e){if(this.disabled||this.readOnly||e.altKey||e.ctrlKey||e.metaKey){return;}this._setValueAttr(this.value,true);},_onKeyDown:function(e){if(this.disabled||this.readOnly||e.altKey||e.ctrlKey||e.metaKey){return;}switch(e.keyCode){case keys.HOME:this._setValueAttr(this.minimum,false);break;case keys.END:this._setValueAttr(this.maximum,false);break;case ((this._descending||this.isLeftToRight())?keys.RIGHT_ARROW:keys.LEFT_ARROW):case (this._descending===false?keys.DOWN_ARROW:keys.UP_ARROW):case (this._descending===false?keys.PAGE_DOWN:keys.PAGE_UP):this.increment(e);break;case ((this._descending||this.isLeftToRight())?keys.LEFT_ARROW:keys.RIGHT_ARROW):case (this._descending===false?keys.UP_ARROW:keys.DOWN_ARROW):case (this._descending===false?keys.PAGE_UP:keys.PAGE_DOWN):this.decrement(e);break;default:return;}e.stopPropagation();e.preventDefault();},_onHandleClick:function(e){if(this.disabled||this.readOnly){return;}if(!has("ie")){_a83.focus(this.sliderHandle);}e.stopPropagation();e.preventDefault();},_isReversed:function(){return !this.isLeftToRight();},_onBarClick:function(e){if(this.disabled||this.readOnly||!this.clickSelect){return;}_a83.focus(this.sliderHandle);e.stopPropagation();e.preventDefault();var _a8f=_a7c.position(this.sliderBarContainer,true);var _a90=e[this._mousePixelCoord]-_a8f[this._startingPixelCoord];this._setPixelValue(this._isReversed()?(_a8f[this._pixelCount]-_a90):_a90,_a8f[this._pixelCount],true);this._movable.onMouseDown(e);},_setPixelValue:function(_a91,_a92,_a93){if(this.disabled||this.readOnly){return;}var _a94=this.discreteValues;if(_a94<=1||_a94==Infinity){_a94=_a92;}_a94--;var _a95=_a92/_a94;var _a96=Math.round(_a91/_a95);this._setValueAttr(Math.max(Math.min((this.maximum-this.minimum)*_a96/_a94+this.minimum,this.maximum),this.minimum),_a93);},_setValueAttr:function(_a97,_a98){this._set("value",_a97);this.valueNode.value=_a97;this.focusNode.setAttribute("aria-valuenow",_a97);this.inherited(arguments);var _a99=(_a97-this.minimum)/(this.maximum-this.minimum);var _a9a=(this._descending===false)?this.remainingBar:this.progressBar;var _a9b=(this._descending===false)?this.progressBar:this.remainingBar;if(this._inProgressAnim&&this._inProgressAnim.status!="stopped"){this._inProgressAnim.stop(true);}if(_a98&&this.slideDuration>0&&_a9a.style[this._progressPixelSize]){var _a9c=this;var _a9d={};var _a9e=parseFloat(_a9a.style[this._progressPixelSize]);var _a9f=this.slideDuration*(_a99-_a9e/100);if(_a9f==0){return;}if(_a9f<0){_a9f=0-_a9f;}_a9d[this._progressPixelSize]={start:_a9e,end:_a99*100,units:"%"};this._inProgressAnim=fx.animateProperty({node:_a9a,duration:_a9f,onAnimate:function(v){_a9b.style[_a9c._progressPixelSize]=(100-parseFloat(v[_a9c._progressPixelSize]))+"%";},onEnd:function(){delete _a9c._inProgressAnim;},properties:_a9d});this._inProgressAnim.play();}else{_a9a.style[this._progressPixelSize]=(_a99*100)+"%";_a9b.style[this._progressPixelSize]=((1-_a99)*100)+"%";}},_bumpValue:function(_aa0,_aa1){if(this.disabled||this.readOnly){return;}var s=_a7d.getComputedStyle(this.sliderBarContainer);var c=_a7c.getContentBox(this.sliderBarContainer,s);var _aa2=this.discreteValues;if(_aa2<=1||_aa2==Infinity){_aa2=c[this._pixelCount];}_aa2--;var _aa3=(this.value-this.minimum)*_aa2/(this.maximum-this.minimum)+_aa0;if(_aa3<0){_aa3=0;}if(_aa3>_aa2){_aa3=_aa2;}_aa3=_aa3*(this.maximum-this.minimum)/_aa2+this.minimum;this._setValueAttr(_aa3,_aa1);},_onClkBumper:function(val){if(this.disabled||this.readOnly||!this.clickSelect){return;}this._setValueAttr(val,true);},_onClkIncBumper:function(){this._onClkBumper(this._descending===false?this.minimum:this.maximum);},_onClkDecBumper:function(){this._onClkBumper(this._descending===false?this.maximum:this.minimum);},decrement:function(e){this._bumpValue(e.keyCode==keys.PAGE_DOWN?-this.pageIncrement:-1);},increment:function(e){this._bumpValue(e.keyCode==keys.PAGE_UP?this.pageIncrement:1);},_mouseWheeled:function(evt){evt.stopPropagation();evt.preventDefault();this._bumpValue(evt.wheelDelta<0?-1:1,true);},startup:function(){if(this._started){return;}_a7a.forEach(this.getChildren(),function(_aa4){if(this[_aa4.container]!=this.containerNode){this[_aa4.container].appendChild(_aa4.domNode);}},this);this.inherited(arguments);},_typematicCallback:function(_aa5,_aa6,e){if(_aa5==-1){this._setValueAttr(this.value,true);}else{this[(_aa6==(this._descending?this.incrementButton:this.decrementButton))?"decrement":"increment"](e);}},buildRendering:function(){this.inherited(arguments);if(this.showButtons){this.incrementButton.style.display="";this.decrementButton.style.display="";}var _aa7=_a80("label[for=\""+this.id+"\"]");if(_aa7.length){if(!_aa7[0].id){_aa7[0].id=this.id+"_label";}this.focusNode.setAttribute("aria-labelledby",_aa7[0].id);}this.focusNode.setAttribute("aria-valuemin",this.minimum);this.focusNode.setAttribute("aria-valuemax",this.maximum);},postCreate:function(){this.inherited(arguments);if(this.showButtons){this.own(_a84.addMouseListener(this.decrementButton,this,"_typematicCallback",25,500),_a84.addMouseListener(this.incrementButton,this,"_typematicCallback",25,500));}this.own(on(this.domNode,_a81.wheel,lang.hitch(this,"_mouseWheeled")));var _aa8=_a7b(_a89,{widget:this});this._movable=new _a7e(this.sliderHandle,{mover:_aa8});this._layoutHackIE7();},destroy:function(){this._movable.destroy();if(this._inProgressAnim&&this._inProgressAnim.status!="stopped"){this._inProgressAnim.stop(true);}this.inherited(arguments);}});_a8e._Mover=_a89;return _a8e;});},"url:dijit/templates/Menu.html":"<table class=\"dijit dijitMenu dijitMenuPassive dijitReset dijitMenuTable\" role=\"menu\" tabIndex=\"${tabIndex}\"\n\t   cellspacing=\"0\">\n\t<tbody class=\"dijitReset\" data-dojo-attach-point=\"containerNode\"></tbody>\n</table>\n","url:dijit/templates/TreeNode.html":"<div class=\"dijitTreeNode\" role=\"presentation\"\n\t><div data-dojo-attach-point=\"rowNode\" class=\"dijitTreeRow\" role=\"presentation\"\n\t\t><span data-dojo-attach-point=\"expandoNode\" class=\"dijitInline dijitTreeExpando\" role=\"presentation\"></span\n\t\t><span data-dojo-attach-point=\"expandoNodeText\" class=\"dijitExpandoText\" role=\"presentation\"></span\n\t\t><span data-dojo-attach-point=\"contentNode\"\n\t\t\tclass=\"dijitTreeContent\" role=\"presentation\">\n\t\t\t<span role=\"presentation\" class=\"dijitInline dijitIcon dijitTreeIcon\" data-dojo-attach-point=\"iconNode\"></span\n\t\t\t><span data-dojo-attach-point=\"labelNode,focusNode\" class=\"dijitTreeLabel\" role=\"treeitem\" tabindex=\"-1\" aria-selected=\"false\"></span>\n\t\t</span\n\t></div>\n\t<div data-dojo-attach-point=\"containerNode\" class=\"dijitTreeNodeContainer\" role=\"presentation\" style=\"display: none;\"></div>\n</div>\n","url:dijit/form/templates/Spinner.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\"\n\tid=\"widget_${id}\" role=\"presentation\"\n\t><div class=\"dijitReset dijitButtonNode dijitSpinnerButtonContainer\"\n\t\t><input class=\"dijitReset dijitInputField dijitSpinnerButtonInner\" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t/><div class=\"dijitReset dijitLeft dijitButtonNode dijitArrowButton dijitUpArrowButton\"\n\t\t\tdata-dojo-attach-point=\"upArrowNode\"\n\t\t\t><div class=\"dijitArrowButtonInner\"\n\t\t\t\t><input class=\"dijitReset dijitInputField\" value=\"&#9650; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t\t\t\t${_buttonInputDisabled}\n\t\t\t/></div\n\t\t></div\n\t\t><div class=\"dijitReset dijitLeft dijitButtonNode dijitArrowButton dijitDownArrowButton\"\n\t\t\tdata-dojo-attach-point=\"downArrowNode\"\n\t\t\t><div class=\"dijitArrowButtonInner\"\n\t\t\t\t><input class=\"dijitReset dijitInputField\" value=\"&#9660; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t\t\t\t${_buttonInputDisabled}\n\t\t\t/></div\n\t\t></div\n\t></div\n\t><div class='dijitReset dijitValidationContainer'\n\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t/></div\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class='dijitReset dijitInputInner' data-dojo-attach-point=\"textbox,focusNode\" type=\"${type}\" data-dojo-attach-event=\"onkeydown:_onKeyDown\"\n\t\t\trole=\"spinbutton\" autocomplete=\"off\" ${!nameAttrSetting}\n\t/></div\n></div>\n","url:dijit/templates/MenuBar.html":"<div class=\"dijitMenuBar dijitMenuPassive\" data-dojo-attach-point=\"containerNode\" role=\"menubar\" tabIndex=\"${tabIndex}\"\n\t ></div>\n","url:dijit/layout/templates/AccordionButton.html":"<div data-dojo-attach-event='ondijitclick:_onTitleClick' class='dijitAccordionTitle' role=\"presentation\">\n\t<div data-dojo-attach-point='titleNode,focusNode' data-dojo-attach-event='onkeydown:_onTitleKeyDown'\n\t\t\tclass='dijitAccordionTitleFocus' role=\"tab\" aria-expanded=\"false\"\n\t\t><span class='dijitInline dijitAccordionArrow' role=\"presentation\"></span\n\t\t><span class='arrowTextUp' role=\"presentation\">+</span\n\t\t><span class='arrowTextDown' role=\"presentation\">-</span\n\t\t><span role=\"presentation\" class=\"dijitInline dijitIcon\" data-dojo-attach-point=\"iconNode\"></span>\n\t\t<span role=\"presentation\" data-dojo-attach-point='titleTextNode, textDirNode' class='dijitAccordionText'></span>\n\t</div>\n</div>\n","url:dijit/templates/TitlePane.html":"<div>\n\t<div data-dojo-attach-event=\"ondijitclick:_onTitleClick, onkeydown:_onTitleKey\"\n\t\t\tclass=\"dijitTitlePaneTitle\" data-dojo-attach-point=\"titleBarNode\" id=\"${id}_titleBarNode\">\n\t\t<div class=\"dijitTitlePaneTitleFocus\" data-dojo-attach-point=\"focusNode\">\n\t\t\t<span data-dojo-attach-point=\"arrowNode\" class=\"dijitInline dijitArrowNode\" role=\"presentation\"></span\n\t\t\t><span data-dojo-attach-point=\"arrowNodeInner\" class=\"dijitArrowNodeInner\"></span\n\t\t\t><span data-dojo-attach-point=\"titleNode\" class=\"dijitTitlePaneTextNode\"></span>\n\t\t</div>\n\t</div>\n\t<div class=\"dijitTitlePaneContentOuter\" data-dojo-attach-point=\"hideNode\" role=\"presentation\">\n\t\t<div class=\"dijitReset\" data-dojo-attach-point=\"wipeNode\" role=\"presentation\">\n\t\t\t<div class=\"dijitTitlePaneContentInner\" data-dojo-attach-point=\"containerNode\" role=\"region\" id=\"${id}_pane\" aria-labelledby=\"${id}_titleBarNode\">\n\t\t\t\t<!-- nested divs because wipeIn()/wipeOut() doesn't work right on node w/padding etc.  Put padding on inner div. -->\n\t\t\t</div>\n\t\t</div>\n\t</div>\n</div>\n","url:dijit/templates/MenuSeparator.html":"<tr class=\"dijitMenuSeparator\" role=\"separator\">\n\t<td class=\"dijitMenuSeparatorIconCell\">\n\t\t<div class=\"dijitMenuSeparatorTop\"></div>\n\t\t<div class=\"dijitMenuSeparatorBottom\"></div>\n\t</td>\n\t<td colspan=\"3\" class=\"dijitMenuSeparatorLabelCell\">\n\t\t<div class=\"dijitMenuSeparatorTop dijitMenuSeparatorLabel\"></div>\n\t\t<div class=\"dijitMenuSeparatorBottom\"></div>\n\t</td>\n</tr>\n","url:dijit/templates/ProgressBar.html":"<div class=\"dijitProgressBar dijitProgressBarEmpty\" role=\"progressbar\"\n\t><div  data-dojo-attach-point=\"internalProgress\" class=\"dijitProgressBarFull\"\n\t\t><div class=\"dijitProgressBarTile\" role=\"presentation\"></div\n\t\t><span style=\"visibility:hidden\">&#160;</span\n\t></div\n\t><div data-dojo-attach-point=\"labelNode\" class=\"dijitProgressBarLabel\" id=\"${id}_label\"></div\n\t><span data-dojo-attach-point=\"indeterminateHighContrastImage\"\n\t\t   class=\"dijitInline dijitProgressBarIndeterminateHighContrastImage\"></span\n></div>\n","url:dijit/form/templates/DropDownButton.html":"<span class=\"dijit dijitReset dijitInline\"\n\t><span class='dijitReset dijitInline dijitButtonNode'\n\t\tdata-dojo-attach-event=\"ondijitclick:__onClick\" data-dojo-attach-point=\"_buttonNode\"\n\t\t><span class=\"dijitReset dijitStretch dijitButtonContents\"\n\t\t\tdata-dojo-attach-point=\"focusNode,titleNode,_arrowWrapperNode,_popupStateNode\"\n\t\t\trole=\"button\" aria-haspopup=\"true\" aria-labelledby=\"${id}_label\"\n\t\t\t><span class=\"dijitReset dijitInline dijitIcon\"\n\t\t\t\tdata-dojo-attach-point=\"iconNode\"\n\t\t\t></span\n\t\t\t><span class=\"dijitReset dijitInline dijitButtonText\"\n\t\t\t\tdata-dojo-attach-point=\"containerNode\"\n\t\t\t\tid=\"${id}_label\"\n\t\t\t></span\n\t\t\t><span class=\"dijitReset dijitInline dijitArrowButtonInner\"></span\n\t\t\t><span class=\"dijitReset dijitInline dijitArrowButtonChar\">&#9660;</span\n\t\t></span\n\t></span\n\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" class=\"dijitOffScreen\" tabIndex=\"-1\"\n\t\tdata-dojo-attach-event=\"onclick:_onClick\"\n\t\tdata-dojo-attach-point=\"valueNode\" role=\"presentation\"\n/></span>\n","url:dijit/form/templates/DropDownBox.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\"\n\tid=\"widget_${id}\"\n\trole=\"combobox\"\n\taria-haspopup=\"true\"\n\tdata-dojo-attach-point=\"_popupStateNode\"\n\t><div class='dijitReset dijitRight dijitButtonNode dijitArrowButton dijitDownArrowButton dijitArrowButtonContainer'\n\t\tdata-dojo-attach-point=\"_buttonNode\" role=\"presentation\"\n\t\t><input class=\"dijitReset dijitInputField dijitArrowButtonInner\" value=\"&#9660; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"button presentation\" aria-hidden=\"true\"\n\t\t\t${_buttonInputDisabled}\n\t/></div\n\t><div class='dijitReset dijitValidationContainer'\n\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t/></div\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class='dijitReset dijitInputInner' ${!nameAttrSetting} type=\"text\" autocomplete=\"off\"\n\t\t\tdata-dojo-attach-point=\"textbox,focusNode\" role=\"textbox\"\n\t/></div\n></div>\n","url:dijit/templates/CheckedMenuItem.html":"<tr class=\"dijitReset dijitMenuItem\" data-dojo-attach-point=\"focusNode\" role=\"${role}\" tabIndex=\"-1\" aria-checked=\"${checked}\">\n\t<td class=\"dijitReset dijitMenuItemIconCell\" role=\"presentation\">\n\t\t<span class=\"dijitInline dijitIcon dijitMenuItemIcon dijitCheckedMenuItemIcon\" data-dojo-attach-point=\"iconNode\"></span>\n\t\t<span class=\"dijitMenuItemIconChar dijitCheckedMenuItemIconChar\">${checkedChar}</span>\n\t</td>\n\t<td class=\"dijitReset dijitMenuItemLabel\" colspan=\"2\" data-dojo-attach-point=\"containerNode,labelNode,textDirNode\"></td>\n\t<td class=\"dijitReset dijitMenuItemAccelKey\" style=\"display: none\" data-dojo-attach-point=\"accelKeyNode\"></td>\n\t<td class=\"dijitReset dijitMenuArrowCell\" role=\"presentation\">&#160;</td>\n</tr>\n","url:dijit/templates/Tooltip.html":"<div class=\"dijitTooltip dijitTooltipLeft\" id=\"dojoTooltip\"\n\t><div class=\"dijitTooltipConnector\" data-dojo-attach-point=\"connectorNode\"></div\n\t><div class=\"dijitTooltipContainer dijitTooltipContents\" data-dojo-attach-point=\"containerNode\" role='alert'></div\n></div>\n","url:dijit/form/templates/ValidationTextBox.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\"\n\tid=\"widget_${id}\" role=\"presentation\"\n\t><div class='dijitReset dijitValidationContainer'\n\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t/></div\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class=\"dijitReset dijitInputInner\" data-dojo-attach-point='textbox,focusNode' autocomplete=\"off\"\n\t\t\t${!nameAttrSetting} type='${type}'\n\t/></div\n></div>\n","url:dijit/templates/InlineEditBox.html":"<span data-dojo-attach-point=\"editNode\" role=\"presentation\" class=\"dijitReset dijitInline dijitOffScreen\"\n\t><span data-dojo-attach-point=\"editorPlaceholder\"></span\n\t><span data-dojo-attach-point=\"buttonContainer\"\n\t\t><button data-dojo-type=\"./form/Button\" data-dojo-props=\"label: '${buttonSave}', 'class': 'saveButton'\"\n\t\t\tdata-dojo-attach-point=\"saveButton\" data-dojo-attach-event=\"onClick:save\"></button\n\t\t><button data-dojo-type=\"./form/Button\"  data-dojo-props=\"label: '${buttonCancel}', 'class': 'cancelButton'\"\n\t\t\tdata-dojo-attach-point=\"cancelButton\" data-dojo-attach-event=\"onClick:cancel\"></button\n\t></span\n></span>\n","url:dijit/templates/ColorPalette.html":"<div class=\"dijitInline dijitColorPalette\" role=\"grid\">\n\t<table dojoAttachPoint=\"paletteTableNode\" class=\"dijitPaletteTable\" cellSpacing=\"0\" cellPadding=\"0\" role=\"presentation\">\n\t\t<tbody data-dojo-attach-point=\"gridNode\"></tbody>\n\t</table>\n</div>\n","url:dijit/layout/templates/_ScrollingTabControllerButton.html":"<div data-dojo-attach-event=\"ondijitclick:_onClick\" class=\"dijitTabInnerDiv dijitTabContent dijitButtonContents\"  data-dojo-attach-point=\"focusNode\" role=\"button\">\n\t<span role=\"presentation\" class=\"dijitInline dijitTabStripIcon\" data-dojo-attach-point=\"iconNode\"></span>\n\t<span data-dojo-attach-point=\"containerNode,titleNode\" class=\"dijitButtonText\"></span>\n</div>","url:dijit/layout/templates/TabContainer.html":"<div class=\"dijitTabContainer\">\n\t<div class=\"dijitTabListWrapper\" data-dojo-attach-point=\"tablistNode\"></div>\n\t<div data-dojo-attach-point=\"tablistSpacer\" class=\"dijitTabSpacer ${baseClass}-spacer\"></div>\n\t<div class=\"dijitTabPaneWrapper ${baseClass}-container\" data-dojo-attach-point=\"containerNode\"></div>\n</div>\n","url:dijit/form/templates/ComboButton.html":"<table class=\"dijit dijitReset dijitInline dijitLeft\"\n\tcellspacing='0' cellpadding='0' role=\"presentation\"\n\t><tbody role=\"presentation\"><tr role=\"presentation\"\n\t\t><td class=\"dijitReset dijitStretch dijitButtonNode\" data-dojo-attach-point=\"buttonNode\" data-dojo-attach-event=\"ondijitclick:__onClick,onkeydown:_onButtonKeyDown\"\n\t\t><div id=\"${id}_button\" class=\"dijitReset dijitButtonContents\"\n\t\t\tdata-dojo-attach-point=\"titleNode\"\n\t\t\trole=\"button\" aria-labelledby=\"${id}_label\"\n\t\t\t><div class=\"dijitReset dijitInline dijitIcon\" data-dojo-attach-point=\"iconNode\" role=\"presentation\"></div\n\t\t\t><div class=\"dijitReset dijitInline dijitButtonText\" id=\"${id}_label\" data-dojo-attach-point=\"containerNode\" role=\"presentation\"></div\n\t\t></div\n\t\t></td\n\t\t><td id=\"${id}_arrow\" class='dijitReset dijitRight dijitButtonNode dijitArrowButton'\n\t\t\tdata-dojo-attach-point=\"_popupStateNode,focusNode,_buttonNode\"\n\t\t\tdata-dojo-attach-event=\"onkeydown:_onArrowKeyDown\"\n\t\t\ttitle=\"${optionsTitle}\"\n\t\t\trole=\"button\" aria-haspopup=\"true\"\n\t\t\t><div class=\"dijitReset dijitArrowButtonInner\" role=\"presentation\"></div\n\t\t\t><div class=\"dijitReset dijitArrowButtonChar\" role=\"presentation\">&#9660;</div\n\t\t></td\n\t\t><td style=\"display:none !important;\"\n\t\t\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" data-dojo-attach-point=\"valueNode\" role=\"presentation\"\n\t\t\t\tdata-dojo-attach-event=\"onclick:_onClick\"\n\t\t/></td></tr></tbody\n></table>\n","url:dijit/templates/Tree.html":"<div role=\"tree\">\n\t<div class=\"dijitInline dijitTreeIndent\" style=\"position: absolute; top: -9999px\" data-dojo-attach-point=\"indentDetector\"></div>\n\t<div class=\"dijitTreeExpando dijitTreeExpandoLoading\" data-dojo-attach-point=\"rootLoadingIndicator\"></div>\n\t<div data-dojo-attach-point=\"containerNode\" class=\"dijitTreeContainer\" role=\"presentation\">\n\t</div>\n</div>\n","url:dijit/templates/Dialog.html":"<div class=\"dijitDialog\" role=\"dialog\" aria-labelledby=\"${id}_title\">\n\t<div data-dojo-attach-point=\"titleBar\" class=\"dijitDialogTitleBar\">\n\t\t<span data-dojo-attach-point=\"titleNode\" class=\"dijitDialogTitle\" id=\"${id}_title\"\n\t\t\t\trole=\"heading\" level=\"1\"></span>\n\t\t<span data-dojo-attach-point=\"closeButtonNode\" class=\"dijitDialogCloseIcon\" data-dojo-attach-event=\"ondijitclick: onCancel\" title=\"${buttonCancel}\" role=\"button\" tabindex=\"0\">\n\t\t\t<span data-dojo-attach-point=\"closeText\" class=\"closeText\" title=\"${buttonCancel}\">x</span>\n\t\t</span>\n\t</div>\n\t<div data-dojo-attach-point=\"containerNode\" class=\"dijitDialogPaneContent\"></div>\n</div>\n","url:dijit/form/templates/TextBox.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\" id=\"widget_${id}\" role=\"presentation\"\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class=\"dijitReset dijitInputInner\" data-dojo-attach-point='textbox,focusNode' autocomplete=\"off\"\n\t\t\t${!nameAttrSetting} type='${type}'\n\t/></div\n></div>\n","url:dijit/form/templates/Select.html":"<table class=\"dijit dijitReset dijitInline dijitLeft\"\n\tdata-dojo-attach-point=\"_buttonNode,tableNode,focusNode,_popupStateNode\" cellspacing='0' cellpadding='0'\n\trole=\"listbox\" aria-haspopup=\"true\"\n\t><tbody role=\"presentation\"><tr role=\"presentation\"\n\t\t><td class=\"dijitReset dijitStretch dijitButtonContents\" role=\"presentation\"\n\t\t\t><div class=\"dijitReset dijitInputField dijitButtonText\"  data-dojo-attach-point=\"containerNode,textDirNode\" role=\"presentation\"></div\n\t\t\t><div class=\"dijitReset dijitValidationContainer\"\n\t\t\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t\t/></div\n\t\t\t><input type=\"hidden\" ${!nameAttrSetting} data-dojo-attach-point=\"valueNode\" value=\"${value}\" aria-hidden=\"true\"\n\t\t/></td\n\t\t><td class=\"dijitReset dijitRight dijitButtonNode dijitArrowButton dijitDownArrowButton dijitArrowButtonContainer\"\n\t\t\tdata-dojo-attach-point=\"titleNode\" role=\"presentation\"\n\t\t\t><input class=\"dijitReset dijitInputField dijitArrowButtonInner\" value=\"&#9660; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t\t\t${_buttonInputDisabled}\n\t\t/></td\n\t></tr></tbody\n></table>\n","url:dijit/templates/MenuItem.html":"<tr class=\"dijitReset dijitMenuItem\" data-dojo-attach-point=\"focusNode\" role=\"menuitem\" tabIndex=\"-1\">\n\t<td class=\"dijitReset dijitMenuItemIconCell\" role=\"presentation\">\n\t\t<span role=\"presentation\" class=\"dijitInline dijitIcon dijitMenuItemIcon\" data-dojo-attach-point=\"iconNode\"></span>\n\t</td>\n\t<td class=\"dijitReset dijitMenuItemLabel\" colspan=\"2\" data-dojo-attach-point=\"containerNode,textDirNode\"></td>\n\t<td class=\"dijitReset dijitMenuItemAccelKey\" style=\"display: none\" data-dojo-attach-point=\"accelKeyNode\"></td>\n\t<td class=\"dijitReset dijitMenuArrowCell\" role=\"presentation\">\n\t\t<span data-dojo-attach-point=\"arrowWrapper\" style=\"visibility: hidden\">\n\t\t\t<span class=\"dijitInline dijitIcon dijitMenuExpand\"></span>\n\t\t\t<span class=\"dijitMenuExpandA11y\">+</span>\n\t\t</span>\n\t</td>\n</tr>\n","url:dijit/templates/MenuBarItem.html":"<div class=\"dijitReset dijitInline dijitMenuItem dijitMenuItemLabel\" data-dojo-attach-point=\"focusNode\"\n\t \trole=\"menuitem\" tabIndex=\"-1\">\n\t<span data-dojo-attach-point=\"containerNode,textDirNode\"></span>\n</div>\n","url:dijit/layout/templates/_TabButton.html":"<div role=\"presentation\" data-dojo-attach-point=\"titleNode,innerDiv,tabContent\" class=\"dijitTabInner dijitTabContent\">\n\t<span role=\"presentation\" class=\"dijitInline dijitIcon dijitTabButtonIcon\" data-dojo-attach-point=\"iconNode\"></span>\n\t<span data-dojo-attach-point='containerNode,focusNode' class='tabLabel'></span>\n\t<span class=\"dijitInline dijitTabCloseButton dijitTabCloseIcon\" data-dojo-attach-point='closeNode'\n\t\t  role=\"presentation\">\n\t\t<span data-dojo-attach-point='closeText' class='dijitTabCloseText'>[x]</span\n\t\t\t\t></span>\n</div>\n","url:dijit/form/templates/HorizontalSlider.html":"<table class=\"dijit dijitReset dijitSlider dijitSliderH\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" rules=\"none\" data-dojo-attach-event=\"onkeydown:_onKeyDown, onkeyup:_onKeyUp\"\n\trole=\"presentation\"\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\n\t\t><td data-dojo-attach-point=\"topDecoration\" class=\"dijitReset dijitSliderDecoration dijitSliderDecorationT dijitSliderDecorationH\"></td\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset dijitSliderButtonContainer dijitSliderButtonContainerH\"\n\t\t\t><div class=\"dijitSliderDecrementIconH\" style=\"display:none\" data-dojo-attach-point=\"decrementButton\"><span class=\"dijitSliderButtonInner\">-</span></div\n\t\t></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><div class=\"dijitSliderBar dijitSliderBumper dijitSliderBumperH dijitSliderLeftBumper\" data-dojo-attach-event=\"press:_onClkDecBumper\"></div\n\t\t></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><input data-dojo-attach-point=\"valueNode\" type=\"hidden\" ${!nameAttrSetting}\n\t\t\t/><div class=\"dijitReset dijitSliderBarContainerH\" role=\"presentation\" data-dojo-attach-point=\"sliderBarContainer\"\n\t\t\t\t><div role=\"presentation\" data-dojo-attach-point=\"progressBar\" class=\"dijitSliderBar dijitSliderBarH dijitSliderProgressBar dijitSliderProgressBarH\" data-dojo-attach-event=\"press:_onBarClick\"\n\t\t\t\t\t><div class=\"dijitSliderMoveable dijitSliderMoveableH\"\n\t\t\t\t\t\t><div data-dojo-attach-point=\"sliderHandle,focusNode\" class=\"dijitSliderImageHandle dijitSliderImageHandleH\" data-dojo-attach-event=\"press:_onHandleClick\" role=\"slider\"></div\n\t\t\t\t\t></div\n\t\t\t\t></div\n\t\t\t\t><div role=\"presentation\" data-dojo-attach-point=\"remainingBar\" class=\"dijitSliderBar dijitSliderBarH dijitSliderRemainingBar dijitSliderRemainingBarH\" data-dojo-attach-event=\"press:_onBarClick\"></div\n\t\t\t></div\n\t\t></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><div class=\"dijitSliderBar dijitSliderBumper dijitSliderBumperH dijitSliderRightBumper\" data-dojo-attach-event=\"press:_onClkIncBumper\"></div\n\t\t></td\n\t\t><td class=\"dijitReset dijitSliderButtonContainer dijitSliderButtonContainerH\"\n\t\t\t><div class=\"dijitSliderIncrementIconH\" style=\"display:none\" data-dojo-attach-point=\"incrementButton\"><span class=\"dijitSliderButtonInner\">+</span></div\n\t\t></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\n\t\t><td data-dojo-attach-point=\"containerNode,bottomDecoration\" class=\"dijitReset dijitSliderDecoration dijitSliderDecorationB dijitSliderDecorationH\"></td\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\n\t></tr\n></table>\n","url:dijit/form/templates/CheckBox.html":"<div class=\"dijit dijitReset dijitInline\" role=\"presentation\"\n\t><input\n\t \t${!nameAttrSetting} type=\"${type}\" role=\"${type}\" aria-checked=\"false\" ${checkedAttrSetting}\n\t\tclass=\"dijitReset dijitCheckBoxInput\"\n\t\tdata-dojo-attach-point=\"focusNode\"\n\t \tdata-dojo-attach-event=\"ondijitclick:_onClick\"\n/></div>\n","url:dijit/form/templates/VerticalSlider.html":"<table class=\"dijit dijitReset dijitSlider dijitSliderV\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" rules=\"none\" data-dojo-attach-event=\"onkeydown:_onKeyDown,onkeyup:_onKeyUp\"\n\trole=\"presentation\"\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\"></td\n\t\t><td class=\"dijitReset dijitSliderButtonContainer dijitSliderButtonContainerV\"\n\t\t\t><div class=\"dijitSliderIncrementIconV\" style=\"display:none\" data-dojo-attach-point=\"decrementButton\"><span class=\"dijitSliderButtonInner\">+</span></div\n\t\t></td\n\t\t><td class=\"dijitReset\"></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\"></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><center><div class=\"dijitSliderBar dijitSliderBumper dijitSliderBumperV dijitSliderTopBumper\" data-dojo-attach-event=\"press:_onClkIncBumper\"></div></center\n\t\t></td\n\t\t><td class=\"dijitReset\"></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td data-dojo-attach-point=\"leftDecoration\" class=\"dijitReset dijitSliderDecoration dijitSliderDecorationL dijitSliderDecorationV\"></td\n\t\t><td class=\"dijitReset dijitSliderDecorationC\" style=\"height:100%;\"\n\t\t\t><input data-dojo-attach-point=\"valueNode\" type=\"hidden\" ${!nameAttrSetting}\n\t\t\t/><center class=\"dijitReset dijitSliderBarContainerV\" role=\"presentation\" data-dojo-attach-point=\"sliderBarContainer\"\n\t\t\t\t><div role=\"presentation\" data-dojo-attach-point=\"remainingBar\" class=\"dijitSliderBar dijitSliderBarV dijitSliderRemainingBar dijitSliderRemainingBarV\" data-dojo-attach-event=\"press:_onBarClick\"><!--#5629--></div\n\t\t\t\t><div role=\"presentation\" data-dojo-attach-point=\"progressBar\" class=\"dijitSliderBar dijitSliderBarV dijitSliderProgressBar dijitSliderProgressBarV\" data-dojo-attach-event=\"press:_onBarClick\"\n\t\t\t\t\t><div class=\"dijitSliderMoveable dijitSliderMoveableV\" style=\"vertical-align:top;\"\n\t\t\t\t\t\t><div data-dojo-attach-point=\"sliderHandle,focusNode\" class=\"dijitSliderImageHandle dijitSliderImageHandleV\" data-dojo-attach-event=\"press:_onHandleClick\" role=\"slider\"></div\n\t\t\t\t\t></div\n\t\t\t\t></div\n\t\t\t></center\n\t\t></td\n\t\t><td data-dojo-attach-point=\"containerNode,rightDecoration\" class=\"dijitReset dijitSliderDecoration dijitSliderDecorationR dijitSliderDecorationV\"></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\"></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><center><div class=\"dijitSliderBar dijitSliderBumper dijitSliderBumperV dijitSliderBottomBumper\" data-dojo-attach-event=\"press:_onClkDecBumper\"></div></center\n\t\t></td\n\t\t><td class=\"dijitReset\"></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\"></td\n\t\t><td class=\"dijitReset dijitSliderButtonContainer dijitSliderButtonContainerV\"\n\t\t\t><div class=\"dijitSliderDecrementIconV\" style=\"display:none\" data-dojo-attach-point=\"incrementButton\"><span class=\"dijitSliderButtonInner\">-</span></div\n\t\t></td\n\t\t><td class=\"dijitReset\"></td\n\t></tr\n></table>\n","url:dijit/templates/Calendar.html":"<table cellspacing=\"0\" cellpadding=\"0\" class=\"dijitCalendarContainer\" role=\"grid\" aria-labelledby=\"${id}_mddb ${id}_year\" data-dojo-attach-point=\"gridNode\">\n\t<thead>\n\t\t<tr class=\"dijitReset dijitCalendarMonthContainer\" valign=\"top\">\n\t\t\t<th class='dijitReset dijitCalendarArrow' data-dojo-attach-point=\"decrementMonth\" scope=\"col\">\n\t\t\t\t<span class=\"dijitInline dijitCalendarIncrementControl dijitCalendarDecrease\" role=\"presentation\"></span>\n\t\t\t\t<span data-dojo-attach-point=\"decreaseArrowNode\" class=\"dijitA11ySideArrow\">-</span>\n\t\t\t</th>\n\t\t\t<th class='dijitReset' colspan=\"5\" scope=\"col\">\n\t\t\t\t<div data-dojo-attach-point=\"monthNode\">\n\t\t\t\t</div>\n\t\t\t</th>\n\t\t\t<th class='dijitReset dijitCalendarArrow' scope=\"col\" data-dojo-attach-point=\"incrementMonth\">\n\t\t\t\t<span class=\"dijitInline dijitCalendarIncrementControl dijitCalendarIncrease\" role=\"presentation\"></span>\n\t\t\t\t<span data-dojo-attach-point=\"increaseArrowNode\" class=\"dijitA11ySideArrow\">+</span>\n\t\t\t</th>\n\t\t</tr>\n\t\t<tr role=\"row\">\n\t\t\t${!dayCellsHtml}\n\t\t</tr>\n\t</thead>\n\t<tbody data-dojo-attach-point=\"dateRowsNode\" data-dojo-attach-event=\"ondijitclick: _onDayClick\" class=\"dijitReset dijitCalendarBodyContainer\">\n\t\t\t${!dateRowsHtml}\n\t</tbody>\n\t<tfoot class=\"dijitReset dijitCalendarYearContainer\">\n\t\t<tr>\n\t\t\t<td class='dijitReset' valign=\"top\" colspan=\"7\" role=\"presentation\">\n\t\t\t\t<div class=\"dijitCalendarYearLabel\">\n\t\t\t\t\t<span data-dojo-attach-point=\"previousYearLabelNode\" class=\"dijitInline dijitCalendarPreviousYear\" role=\"button\"></span>\n\t\t\t\t\t<span data-dojo-attach-point=\"currentYearLabelNode\" class=\"dijitInline dijitCalendarSelectedYear\" role=\"button\" id=\"${id}_year\"></span>\n\t\t\t\t\t<span data-dojo-attach-point=\"nextYearLabelNode\" class=\"dijitInline dijitCalendarNextYear\" role=\"button\"></span>\n\t\t\t\t</div>\n\t\t\t</td>\n\t\t</tr>\n\t</tfoot>\n</table>\n","url:dijit/layout/templates/ScrollingTabController.html":"<div class=\"dijitTabListContainer-${tabPosition}\" style=\"visibility:hidden\">\n\t<div data-dojo-type=\"dijit.layout._ScrollingTabControllerMenuButton\"\n\t\t class=\"tabStripButton-${tabPosition}\"\n\t\t id=\"${id}_menuBtn\"\n\t\t data-dojo-props=\"containerId: '${containerId}', iconClass: 'dijitTabStripMenuIcon',\n\t\t\t\t\tdropDownPosition: ['below-alt', 'above-alt']\"\n\t\t data-dojo-attach-point=\"_menuBtn\" showLabel=\"false\" title=\"\">&#9660;</div>\n\t<div data-dojo-type=\"dijit.layout._ScrollingTabControllerButton\"\n\t\t class=\"tabStripButton-${tabPosition}\"\n\t\t id=\"${id}_leftBtn\"\n\t\t data-dojo-props=\"iconClass:'dijitTabStripSlideLeftIcon', showLabel:false, title:''\"\n\t\t data-dojo-attach-point=\"_leftBtn\" data-dojo-attach-event=\"onClick: doSlideLeft\">&#9664;</div>\n\t<div data-dojo-type=\"dijit.layout._ScrollingTabControllerButton\"\n\t\t class=\"tabStripButton-${tabPosition}\"\n\t\t id=\"${id}_rightBtn\"\n\t\t data-dojo-props=\"iconClass:'dijitTabStripSlideRightIcon', showLabel:false, title:''\"\n\t\t data-dojo-attach-point=\"_rightBtn\" data-dojo-attach-event=\"onClick: doSlideRight\">&#9654;</div>\n\t<div class='dijitTabListWrapper' data-dojo-attach-point='tablistWrapper'>\n\t\t<div role='tablist' data-dojo-attach-event='onkeydown:onkeydown'\n\t\t\t data-dojo-attach-point='containerNode' class='nowrapTabStrip'></div>\n\t</div>\n</div>","url:dijit/form/templates/Button.html":"<span class=\"dijit dijitReset dijitInline\" role=\"presentation\"\n\t><span class=\"dijitReset dijitInline dijitButtonNode\"\n\t\tdata-dojo-attach-event=\"ondijitclick:__onClick\" role=\"presentation\"\n\t\t><span class=\"dijitReset dijitStretch dijitButtonContents\"\n\t\t\tdata-dojo-attach-point=\"titleNode,focusNode\"\n\t\t\trole=\"button\" aria-labelledby=\"${id}_label\"\n\t\t\t><span class=\"dijitReset dijitInline dijitIcon\" data-dojo-attach-point=\"iconNode\"></span\n\t\t\t><span class=\"dijitReset dijitToggleButtonIconChar\">&#x25CF;</span\n\t\t\t><span class=\"dijitReset dijitInline dijitButtonText\"\n\t\t\t\tid=\"${id}_label\"\n\t\t\t\tdata-dojo-attach-point=\"containerNode\"\n\t\t\t></span\n\t\t></span\n\t></span\n\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" class=\"dijitOffScreen\"\n\t\tdata-dojo-attach-event=\"onclick:_onClick\"\n\t\ttabIndex=\"-1\" role=\"presentation\" data-dojo-attach-point=\"valueNode\"\n/></span>\n","url:dijit/templates/TooltipDialog.html":"<div role=\"alertdialog\" tabIndex=\"-1\">\n\t<div class=\"dijitTooltipContainer\" role=\"presentation\">\n\t\t<div class=\"dijitTooltipContents dijitTooltipFocusNode\" data-dojo-attach-point=\"containerNode\"></div>\n\t</div>\n\t<div class=\"dijitTooltipConnector\" role=\"presentation\" data-dojo-attach-point=\"connectorNode\"></div>\n</div>\n","*now":function(r){r(["dojo/i18n!*preload*dijit/nls/dijit-all*[\"ar\",\"ca\",\"cs\",\"da\",\"de\",\"el\",\"en-gb\",\"en-us\",\"es-es\",\"fi-fi\",\"fr-fr\",\"he-il\",\"hu\",\"it-it\",\"ja-jp\",\"ko-kr\",\"nl-nl\",\"nb\",\"pl\",\"pt-br\",\"pt-pt\",\"ru\",\"sk\",\"sl\",\"sv\",\"th\",\"tr\",\"zh-tw\",\"zh-cn\",\"ROOT\"]"]);}}});define("dijit/dijit-all",["./main","./dijit","./ColorPalette","./Declaration","./Dialog","./DialogUnderlay","./TooltipDialog","./Editor","./_editor/plugins/FontChoice","./_editor/plugins/LinkDialog","./Menu","./MenuItem","./PopupMenuItem","./CheckedMenuItem","./MenuBar","./MenuBarItem","./PopupMenuBarItem","./MenuSeparator","./ProgressBar","./TitlePane","./Toolbar","./Tooltip","./Tree","./InlineEditBox","./form/Form","./form/Button","./form/DropDownButton","./form/ComboButton","./form/ToggleButton","./form/CheckBox","./form/RadioButton","./form/TextBox","./form/ValidationTextBox","./form/CurrencyTextBox","./form/DateTextBox","./form/TimeTextBox","./form/NumberSpinner","./form/NumberTextBox","./form/ComboBox","./form/FilteringSelect","./form/MultiSelect","./form/Select","./form/HorizontalSlider","./form/VerticalSlider","./form/HorizontalRule","./form/VerticalRule","./form/HorizontalRuleLabels","./form/VerticalRuleLabels","./form/SimpleTextarea","./form/Textarea","./layout/AccordionContainer","./layout/ContentPane","./layout/BorderContainer","./layout/LayoutContainer","./layout/LinkPane","./layout/SplitContainer","./layout/StackContainer","./layout/TabContainer"],function(_aa9){console.warn("dijit-all may include much more code than your application actually requires. We strongly recommend that you investigate a custom build or the web build tool");return _aa9;});