/*!
 * @overview  Ember - JavaScript Application Framework
 * @copyright Copyright 2011-2015 Tilde Inc. and contributors
 *            Portions Copyright 2006-2011 Strobe Inc.
 *            Portions Copyright 2008-2011 Apple Inc. All rights reserved.
 * @license   Licensed under MIT license
 *            See https://raw.github.com/emberjs/ember.js/master/LICENSE
 * @version   1.12.0
 */

(function() {
var enifed, requireModule, eriuqer, requirejs, Ember;
var mainContext = this;

(function() {

  Ember = this.Ember = this.Ember || {};
  if (typeof Ember === 'undefined') { Ember = {}; };

  if (typeof Ember.__loader === 'undefined') {
    var registry = {};
    var seen = {};

    enifed = function(name, deps, callback) {
      var value = { };

      if (!callback) {
        value.deps = [];
        value.callback = deps;
      } else {
        value.deps = deps;
        value.callback = callback;
      }

        registry[name] = value;
    };

    requirejs = eriuqer = requireModule = function(name) {
      return internalRequire(name, null);
    }

    function internalRequire(name, referrerName) {
      var exports = seen[name];

      if (exports !== undefined) {
        return exports;
      }

      exports = seen[name] = {};

      if (!registry[name]) {
        if (referrerName) {
          throw new Error('Could not find module ' + name + ' required by: ' + referrerName);
        } else {
          throw new Error('Could not find module ' + name);
        }
      }

      var mod = registry[name];
      var deps = mod.deps;
      var callback = mod.callback;
      var reified = [];
      var length = deps.length;

      for (var i=0; i<length; i++) {
        if (deps[i] === 'exports') {
          reified.push(exports);
        } else {
          reified.push(internalRequire(resolve(deps[i], name), name));
        }
      }

      callback.apply(this, reified);

      return exports;
    };

    function resolve(child, name) {
      if (child.charAt(0) !== '.') {
        return child;
      }
      var parts = child.split('/');
      var parentBase = name.split('/').slice(0, -1);

      for (var i=0, l=parts.length; i<l; i++) {
        var part = parts[i];

        if (part === '..') {
          parentBase.pop();
        } else if (part === '.') {
          continue;
        } else {
          parentBase.push(part);
        }
      }

      return parentBase.join('/');
    }

    requirejs._eak_seen = registry;

    Ember.__loader = {
      define: enifed,
      require: eriuqer,
      registry: registry
    };
  } else {
    enifed = Ember.__loader.define;
    requirejs = eriuqer = requireModule = Ember.__loader.require;
  }
})();

enifed("backburner",
  ["backburner/utils","backburner/platform","backburner/binary-search","backburner/deferred-action-queues","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __exports__) {
    "use strict";
    var each = __dependency1__.each;
    var isString = __dependency1__.isString;
    var isFunction = __dependency1__.isFunction;
    var isNumber = __dependency1__.isNumber;
    var isCoercableNumber = __dependency1__.isCoercableNumber;
    var wrapInTryCatch = __dependency1__.wrapInTryCatch;
    var now = __dependency1__.now;

    var needsIETryCatchFix = __dependency2__.needsIETryCatchFix;

    var searchTimer = __dependency3__["default"];

    var DeferredActionQueues = __dependency4__["default"];

    var slice = [].slice;
    var pop = [].pop;
    var global = this;

    function Backburner(queueNames, options) {
      this.queueNames = queueNames;
      this.options = options || {};
      if (!this.options.defaultQueue) {
        this.options.defaultQueue = queueNames[0];
      }
      this.instanceStack = [];
      this._debouncees = [];
      this._throttlers = [];
      this._timers = [];
    }

    Backburner.prototype = {
      begin: function() {
        var options = this.options;
        var onBegin = options && options.onBegin;
        var previousInstance = this.currentInstance;

        if (previousInstance) {
          this.instanceStack.push(previousInstance);
        }

        this.currentInstance = new DeferredActionQueues(this.queueNames, options);
        if (onBegin) {
          onBegin(this.currentInstance, previousInstance);
        }
      },

      end: function() {
        var options = this.options;
        var onEnd = options && options.onEnd;
        var currentInstance = this.currentInstance;
        var nextInstance = null;

        // Prevent double-finally bug in Safari 6.0.2 and iOS 6
        // This bug appears to be resolved in Safari 6.0.5 and iOS 7
        var finallyAlreadyCalled = false;
        try {
          currentInstance.flush();
        } finally {
          if (!finallyAlreadyCalled) {
            finallyAlreadyCalled = true;

            this.currentInstance = null;

            if (this.instanceStack.length) {
              nextInstance = this.instanceStack.pop();
              this.currentInstance = nextInstance;
            }

            if (onEnd) {
              onEnd(currentInstance, nextInstance);
            }
          }
        }
      },

      run: function(target, method /*, args */) {
        var onError = getOnError(this.options);

        this.begin();

        if (!method) {
          method = target;
          target = null;
        }

        if (isString(method)) {
          method = target[method];
        }

        var args = slice.call(arguments, 2);

        // guard against Safari 6's double-finally bug
        var didFinally = false;

        if (onError) {
          try {
            return method.apply(target, args);
          } catch(error) {
            onError(error);
          } finally {
            if (!didFinally) {
              didFinally = true;
              this.end();
            }
          }
        } else {
          try {
            return method.apply(target, args);
          } finally {
            if (!didFinally) {
              didFinally = true;
              this.end();
            }
          }
        }
      },

      join: function(target, method /*, args */) {
        if (this.currentInstance) {
          if (!method) {
            method = target;
            target = null;
          }

          if (isString(method)) {
            method = target[method];
          }

          return method.apply(target, slice.call(arguments, 2));
        } else {
          return this.run.apply(this, arguments);
        }
      },

      defer: function(queueName, target, method /* , args */) {
        if (!method) {
          method = target;
          target = null;
        }

        if (isString(method)) {
          method = target[method];
        }

        var stack = this.DEBUG ? new Error() : undefined;
        var length = arguments.length;
        var args;

        if (length > 3) {
          args = new Array(length - 3);
          for (var i = 3; i < length; i++) {
            args[i-3] = arguments[i];
          }
        } else {
          args = undefined;
        }

        if (!this.currentInstance) { createAutorun(this); }
        return this.currentInstance.schedule(queueName, target, method, args, false, stack);
      },

      deferOnce: function(queueName, target, method /* , args */) {
        if (!method) {
          method = target;
          target = null;
        }

        if (isString(method)) {
          method = target[method];
        }

        var stack = this.DEBUG ? new Error() : undefined;
        var length = arguments.length;
        var args;

        if (length > 3) {
          args = new Array(length - 3);
          for (var i = 3; i < length; i++) {
            args[i-3] = arguments[i];
          }
        } else {
          args = undefined;
        }

        if (!this.currentInstance) {
          createAutorun(this);
        }
        return this.currentInstance.schedule(queueName, target, method, args, true, stack);
      },

      setTimeout: function() {
        var l = arguments.length;
        var args = new Array(l);

        for (var x = 0; x < l; x++) {
          args[x] = arguments[x];
        }

        var length = args.length,
            method, wait, target,
            methodOrTarget, methodOrWait, methodOrArgs;

        if (length === 0) {
          return;
        } else if (length === 1) {
          method = args.shift();
          wait = 0;
        } else if (length === 2) {
          methodOrTarget = args[0];
          methodOrWait = args[1];

          if (isFunction(methodOrWait) || isFunction(methodOrTarget[methodOrWait])) {
            target = args.shift();
            method = args.shift();
            wait = 0;
          } else if (isCoercableNumber(methodOrWait)) {
            method = args.shift();
            wait = args.shift();
          } else {
            method = args.shift();
            wait =  0;
          }
        } else {
          var last = args[args.length - 1];

          if (isCoercableNumber(last)) {
            wait = args.pop();
          } else {
            wait = 0;
          }

          methodOrTarget = args[0];
          methodOrArgs = args[1];

          if (isFunction(methodOrArgs) || (isString(methodOrArgs) &&
                                          methodOrTarget !== null &&
                                          methodOrArgs in methodOrTarget)) {
            target = args.shift();
            method = args.shift();
          } else {
            method = args.shift();
          }
        }

        var executeAt = now() + parseInt(wait, 10);

        if (isString(method)) {
          method = target[method];
        }

        var onError = getOnError(this.options);

        function fn() {
          if (onError) {
            try {
              method.apply(target, args);
            } catch (e) {
              onError(e);
            }
          } else {
            method.apply(target, args);
          }
        }

        // find position to insert
        var i = searchTimer(executeAt, this._timers);

        this._timers.splice(i, 0, executeAt, fn);

        updateLaterTimer(this, executeAt, wait);

        return fn;
      },

      throttle: function(target, method /* , args, wait, [immediate] */) {
        var backburner = this;
        var args = arguments;
        var immediate = pop.call(args);
        var wait, throttler, index, timer;

        if (isNumber(immediate) || isString(immediate)) {
          wait = immediate;
          immediate = true;
        } else {
          wait = pop.call(args);
        }

        wait = parseInt(wait, 10);

        index = findThrottler(target, method, this._throttlers);
        if (index > -1) { return this._throttlers[index]; } // throttled

        timer = global.setTimeout(function() {
          if (!immediate) {
            backburner.run.apply(backburner, args);
          }
          var index = findThrottler(target, method, backburner._throttlers);
          if (index > -1) {
            backburner._throttlers.splice(index, 1);
          }
        }, wait);

        if (immediate) {
          this.run.apply(this, args);
        }

        throttler = [target, method, timer];

        this._throttlers.push(throttler);

        return throttler;
      },

      debounce: function(target, method /* , args, wait, [immediate] */) {
        var backburner = this;
        var args = arguments;
        var immediate = pop.call(args);
        var wait, index, debouncee, timer;

        if (isNumber(immediate) || isString(immediate)) {
          wait = immediate;
          immediate = false;
        } else {
          wait = pop.call(args);
        }

        wait = parseInt(wait, 10);
        // Remove debouncee
        index = findDebouncee(target, method, this._debouncees);

        if (index > -1) {
          debouncee = this._debouncees[index];
          this._debouncees.splice(index, 1);
          clearTimeout(debouncee[2]);
        }

        timer = global.setTimeout(function() {
          if (!immediate) {
            backburner.run.apply(backburner, args);
          }
          var index = findDebouncee(target, method, backburner._debouncees);
          if (index > -1) {
            backburner._debouncees.splice(index, 1);
          }
        }, wait);

        if (immediate && index === -1) {
          backburner.run.apply(backburner, args);
        }

        debouncee = [
          target,
          method,
          timer
        ];

        backburner._debouncees.push(debouncee);

        return debouncee;
      },

      cancelTimers: function() {
        var clearItems = function(item) {
          clearTimeout(item[2]);
        };

        each(this._throttlers, clearItems);
        this._throttlers = [];

        each(this._debouncees, clearItems);
        this._debouncees = [];

        if (this._laterTimer) {
          clearTimeout(this._laterTimer);
          this._laterTimer = null;
        }
        this._timers = [];

        if (this._autorun) {
          clearTimeout(this._autorun);
          this._autorun = null;
        }
      },

      hasTimers: function() {
        return !!this._timers.length || !!this._debouncees.length || !!this._throttlers.length || this._autorun;
      },

      cancel: function(timer) {
        var timerType = typeof timer;

        if (timer && timerType === 'object' && timer.queue && timer.method) { // we're cancelling a deferOnce
          return timer.queue.cancel(timer);
        } else if (timerType === 'function') { // we're cancelling a setTimeout
          for (var i = 0, l = this._timers.length; i < l; i += 2) {
            if (this._timers[i + 1] === timer) {
              this._timers.splice(i, 2); // remove the two elements
              if (i === 0) {
                if (this._laterTimer) { // Active timer? Then clear timer and reset for future timer
                  clearTimeout(this._laterTimer);
                  this._laterTimer = null;
                }
                if (this._timers.length > 0) { // Update to next available timer when available
                  updateLaterTimer(this, this._timers[0], this._timers[0] - now());
                }
              }
              return true;
            }
          }
        } else if (Object.prototype.toString.call(timer) === "[object Array]"){ // we're cancelling a throttle or debounce
          return this._cancelItem(findThrottler, this._throttlers, timer) ||
                   this._cancelItem(findDebouncee, this._debouncees, timer);
        } else {
          return; // timer was null or not a timer
        }
      },

      _cancelItem: function(findMethod, array, timer){
        var item, index;

        if (timer.length < 3) { return false; }

        index = findMethod(timer[0], timer[1], array);

        if (index > -1) {

          item = array[index];

          if (item[2] === timer[2]) {
            array.splice(index, 1);
            clearTimeout(timer[2]);
            return true;
          }
        }

        return false;
      }
    };

    Backburner.prototype.schedule = Backburner.prototype.defer;
    Backburner.prototype.scheduleOnce = Backburner.prototype.deferOnce;
    Backburner.prototype.later = Backburner.prototype.setTimeout;

    if (needsIETryCatchFix) {
      var originalRun = Backburner.prototype.run;
      Backburner.prototype.run = wrapInTryCatch(originalRun);

      var originalEnd = Backburner.prototype.end;
      Backburner.prototype.end = wrapInTryCatch(originalEnd);
    }

    function getOnError(options) {
      return options.onError || (options.onErrorTarget && options.onErrorTarget[options.onErrorMethod]);
    }

    function createAutorun(backburner) {
      backburner.begin();
      backburner._autorun = global.setTimeout(function() {
        backburner._autorun = null;
        backburner.end();
      });
    }

    function updateLaterTimer(backburner, executeAt, wait) {
      var n = now();
      if (!backburner._laterTimer || executeAt < backburner._laterTimerExpiresAt || backburner._laterTimerExpiresAt < n) {

        if (backburner._laterTimer) {
          // Clear when:
          // - Already expired
          // - New timer is earlier
          clearTimeout(backburner._laterTimer);

          if (backburner._laterTimerExpiresAt < n) { // If timer was never triggered
            // Calculate the left-over wait-time
            wait = Math.max(0, executeAt - n);
          }
        }

        backburner._laterTimer = global.setTimeout(function() {
          backburner._laterTimer = null;
          backburner._laterTimerExpiresAt = null;
          executeTimers(backburner);
        }, wait);

        backburner._laterTimerExpiresAt = n + wait;
      }
    }

    function executeTimers(backburner) {
      var n = now();
      var fns, i, l;

      backburner.run(function() {
        i = searchTimer(n, backburner._timers);

        fns = backburner._timers.splice(0, i);

        for (i = 1, l = fns.length; i < l; i += 2) {
          backburner.schedule(backburner.options.defaultQueue, null, fns[i]);
        }
      });

      if (backburner._timers.length) {
        updateLaterTimer(backburner, backburner._timers[0], backburner._timers[0] - n);
      }
    }

    function findDebouncee(target, method, debouncees) {
      return findItem(target, method, debouncees);
    }

    function findThrottler(target, method, throttlers) {
      return findItem(target, method, throttlers);
    }

    function findItem(target, method, collection) {
      var item;
      var index = -1;

      for (var i = 0, l = collection.length; i < l; i++) {
        item = collection[i];
        if (item[0] === target && item[1] === method) {
          index = i;
          break;
        }
      }

      return index;
    }

    __exports__["default"] = Backburner;
  });
enifed("backburner.umd",
  ["./backburner"],
  function(__dependency1__) {
    "use strict";
    var Backburner = __dependency1__["default"];

    /* global define:true module:true window: true */
    if (typeof enifed === 'function' && enifed.amd) {
      enifed(function() { return Backburner; });
    } else if (typeof module !== 'undefined' && module.exports) {
      module.exports = Backburner;
    } else if (typeof this !== 'undefined') {
      this['Backburner'] = Backburner;
    }
  });
enifed("backburner/binary-search",
  ["exports"],
  function(__exports__) {
    "use strict";
    __exports__["default"] = function binarySearch(time, timers) {
      var start = 0;
      var end = timers.length - 2;
      var middle, l;

      while (start < end) {
        // since timers is an array of pairs 'l' will always
        // be an integer
        l = (end - start) / 2;

        // compensate for the index in case even number
        // of pairs inside timers
        middle = start + l - (l % 2);

        if (time >= timers[middle]) {
          start = middle + 2;
        } else {
          end = middle;
        }
      }

      return (time >= timers[start]) ? start + 2 : start;
    }
  });
enifed("backburner/deferred-action-queues",
  ["./utils","./queue","exports"],
  function(__dependency1__, __dependency2__, __exports__) {
    "use strict";
    var each = __dependency1__.each;
    var Queue = __dependency2__["default"];

    function DeferredActionQueues(queueNames, options) {
      var queues = this.queues = Object.create(null);
      this.queueNames = queueNames = queueNames || [];

      this.options = options;

      each(queueNames, function(queueName) {
        queues[queueName] = new Queue(queueName, options[queueName], options);
      });
    }

    function noSuchQueue(name) {
      throw new Error("You attempted to schedule an action in a queue (" + name + ") that doesn't exist");
    }

    DeferredActionQueues.prototype = {
      schedule: function(name, target, method, args, onceFlag, stack) {
        var queues = this.queues;
        var queue = queues[name];

        if (!queue) {
          noSuchQueue(name);
        }

        if (onceFlag) {
          return queue.pushUnique(target, method, args, stack);
        } else {
          return queue.push(target, method, args, stack);
        }
      },

      flush: function() {
        var queues = this.queues;
        var queueNames = this.queueNames;
        var queueName, queue, queueItems, priorQueueNameIndex;
        var queueNameIndex = 0;
        var numberOfQueues = queueNames.length;
        var options = this.options;

        while (queueNameIndex < numberOfQueues) {
          queueName = queueNames[queueNameIndex];
          queue = queues[queueName];

          var numberOfQueueItems = queue._queue.length;

          if (numberOfQueueItems === 0) {
            queueNameIndex++;
          } else {
            queue.flush(false /* async */);
            queueNameIndex = 0;
          }
        }
      }
    };

    __exports__["default"] = DeferredActionQueues;
  });
enifed("backburner/platform",
  ["exports"],
  function(__exports__) {
    "use strict";
    // In IE 6-8, try/finally doesn't work without a catch.
    // Unfortunately, this is impossible to test for since wrapping it in a parent try/catch doesn't trigger the bug.
    // This tests for another broken try/catch behavior that only exhibits in the same versions of IE.
    var needsIETryCatchFix = (function(e,x){
      try{ x(); }
      catch(e) { } // jshint ignore:line
      return !!e;
    })();
    __exports__.needsIETryCatchFix = needsIETryCatchFix;
  });
enifed("backburner/queue",
  ["./utils","exports"],
  function(__dependency1__, __exports__) {
    "use strict";
    var isString = __dependency1__.isString;

    function Queue(name, options, globalOptions) {
      this.name = name;
      this.globalOptions = globalOptions || {};
      this.options = options;
      this._queue = [];
      this.targetQueues = Object.create(null);
      this._queueBeingFlushed = undefined;
    }

    Queue.prototype = {
      push: function(target, method, args, stack) {
        var queue = this._queue;
        queue.push(target, method, args, stack);

        return {
          queue: this,
          target: target,
          method: method
        };
      },

      pushUniqueWithoutGuid: function(target, method, args, stack) {
        var queue = this._queue;

        for (var i = 0, l = queue.length; i < l; i += 4) {
          var currentTarget = queue[i];
          var currentMethod = queue[i+1];

          if (currentTarget === target && currentMethod === method) {
            queue[i+2] = args;  // replace args
            queue[i+3] = stack; // replace stack
            return;
          }
        }

        queue.push(target, method, args, stack);
      },

      targetQueue: function(targetQueue, target, method, args, stack) {
        var queue = this._queue;

        for (var i = 0, l = targetQueue.length; i < l; i += 4) {
          var currentMethod = targetQueue[i];
          var currentIndex  = targetQueue[i + 1];

          if (currentMethod === method) {
            queue[currentIndex + 2] = args;  // replace args
            queue[currentIndex + 3] = stack; // replace stack
            return;
          }
        }

        targetQueue.push(
          method,
          queue.push(target, method, args, stack) - 4
        );
      },

      pushUniqueWithGuid: function(guid, target, method, args, stack) {
        var hasLocalQueue = this.targetQueues[guid];

        if (hasLocalQueue) {
          this.targetQueue(hasLocalQueue, target, method, args, stack);
        } else {
          this.targetQueues[guid] = [
            method,
            this._queue.push(target, method, args, stack) - 4
          ];
        }

        return {
          queue: this,
          target: target,
          method: method
        };
      },

      pushUnique: function(target, method, args, stack) {
        var queue = this._queue, currentTarget, currentMethod, i, l;
        var KEY = this.globalOptions.GUID_KEY;

        if (target && KEY) {
          var guid = target[KEY];
          if (guid) {
            return this.pushUniqueWithGuid(guid, target, method, args, stack);
          }
        }

        this.pushUniqueWithoutGuid(target, method, args, stack);

        return {
          queue: this,
          target: target,
          method: method
        };
      },

      invoke: function(target, method, args, _, _errorRecordedForStack) {
        if (args && args.length > 0) {
          method.apply(target, args);
        } else {
          method.call(target);
        }
      },

      invokeWithOnError: function(target, method, args, onError, errorRecordedForStack) {
        try {
          if (args && args.length > 0) {
            method.apply(target, args);
          } else {
            method.call(target);
          }
        } catch(error) {
          onError(error, errorRecordedForStack);
        }
      },

      flush: function(sync) {
        var queue = this._queue;
        var length = queue.length;

        if (length === 0) {
          return;
        }

        var globalOptions = this.globalOptions;
        var options = this.options;
        var before = options && options.before;
        var after = options && options.after;
        var onError = globalOptions.onError || (globalOptions.onErrorTarget &&
                                                globalOptions.onErrorTarget[globalOptions.onErrorMethod]);
        var target, method, args, errorRecordedForStack;
        var invoke = onError ? this.invokeWithOnError : this.invoke;

        this.targetQueues = Object.create(null);
        var queueItems = this._queueBeingFlushed = this._queue.slice();
        this._queue = [];

        if (before) {
          before();
        }

        for (var i = 0; i < length; i += 4) {
          target                = queueItems[i];
          method                = queueItems[i+1];
          args                  = queueItems[i+2];
          errorRecordedForStack = queueItems[i+3]; // Debugging assistance

          if (isString(method)) {
            method = target[method];
          }

          // method could have been nullified / canceled during flush
          if (method) {
            //
            //    ** Attention intrepid developer **
            //
            //    To find out the stack of this task when it was scheduled onto
            //    the run loop, add the following to your app.js:
            //
            //    Ember.run.backburner.DEBUG = true; // NOTE: This slows your app, don't leave it on in production.
            //
            //    Once that is in place, when you are at a breakpoint and navigate
            //    here in the stack explorer, you can look at `errorRecordedForStack.stack`,
            //    which will be the captured stack when this job was scheduled.
            //
            invoke(target, method, args, onError, errorRecordedForStack);
          }
        }

        if (after) {
          after();
        }

        this._queueBeingFlushed = undefined;

        if (sync !== false &&
            this._queue.length > 0) {
          // check if new items have been added
          this.flush(true);
        }
      },

      cancel: function(actionToCancel) {
        var queue = this._queue, currentTarget, currentMethod, i, l;
        var target = actionToCancel.target;
        var method = actionToCancel.method;
        var GUID_KEY = this.globalOptions.GUID_KEY;

        if (GUID_KEY && this.targetQueues && target) {
          var targetQueue = this.targetQueues[target[GUID_KEY]];

          if (targetQueue) {
            for (i = 0, l = targetQueue.length; i < l; i++) {
              if (targetQueue[i] === method) {
                targetQueue.splice(i, 1);
              }
            }
          }
        }

        for (i = 0, l = queue.length; i < l; i += 4) {
          currentTarget = queue[i];
          currentMethod = queue[i+1];

          if (currentTarget === target &&
              currentMethod === method) {
            queue.splice(i, 4);
            return true;
          }
        }

        // if not found in current queue
        // could be in the queue that is being flushed
        queue = this._queueBeingFlushed;

        if (!queue) {
          return;
        }

        for (i = 0, l = queue.length; i < l; i += 4) {
          currentTarget = queue[i];
          currentMethod = queue[i+1];

          if (currentTarget === target &&
              currentMethod === method) {
            // don't mess with array during flush
            // just nullify the method
            queue[i+1] = null;
            return true;
          }
        }
      }
    };

    __exports__["default"] = Queue;
  });
enifed("backburner/utils",
  ["exports"],
  function(__exports__) {
    "use strict";
    var NUMBER = /\d+/;

    function each(collection, callback) {
      for (var i = 0; i < collection.length; i++) {
        callback(collection[i]);
      }
    }

    __exports__.each = each;// Date.now is not available in browsers < IE9
    // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/now#Compatibility
    var now = Date.now || function() { return new Date().getTime(); };
    __exports__.now = now;
    function isString(suspect) {
      return typeof suspect === 'string';
    }

    __exports__.isString = isString;function isFunction(suspect) {
      return typeof suspect === 'function';
    }

    __exports__.isFunction = isFunction;function isNumber(suspect) {
      return typeof suspect === 'number';
    }

    __exports__.isNumber = isNumber;function isCoercableNumber(number) {
      return isNumber(number) || NUMBER.test(number);
    }

    __exports__.isCoercableNumber = isCoercableNumber;function wrapInTryCatch(func) {
      return function () {
        try {
          return func.apply(this, arguments);
        } catch (e) {
          throw e;
        }
      };
    }

    __exports__.wrapInTryCatch = wrapInTryCatch;
  });
enifed("calculateVersion",
  [],
  function() {
    "use strict";
    'use strict';

    var fs   = eriuqer('fs');
    var path = eriuqer('path');

    module.exports = function () {
      var packageVersion = eriuqer('../package.json').version;
      var output         = [packageVersion];
      var gitPath        = path.join(__dirname,'..','.git');
      var headFilePath   = path.join(gitPath, 'HEAD');

      if (packageVersion.indexOf('+') > -1) {
        try {
          if (fs.existsSync(headFilePath)) {
            var headFile = fs.readFileSync(headFilePath, {encoding: 'utf8'});
            var branchName = headFile.split('/').slice(-1)[0].trim();
            var refPath = headFile.split(' ')[1];
            var branchSHA;

            if (refPath) {
              var branchPath = path.join(gitPath, refPath.trim());
              branchSHA  = fs.readFileSync(branchPath);
            } else {
              branchSHA = branchName;
            }

            output.push(branchSHA.slice(0,10));
          }
        } catch (err) {
          console.error(err.stack);
        }
        return output.join('.');
      } else {
        return packageVersion;
      }
    };
  });
enifed('container', ['exports', 'container/registry', 'container/container'], function (exports, Registry, Container) {

  'use strict';

  Ember.MODEL_FACTORY_INJECTIONS = false;

  if (Ember.ENV && typeof Ember.ENV.MODEL_FACTORY_INJECTIONS !== 'undefined') {
    Ember.MODEL_FACTORY_INJECTIONS = !!Ember.ENV.MODEL_FACTORY_INJECTIONS;
  }

  exports.Registry = Registry['default'];
  exports.Container = Container['default'];

});
enifed('container/container', ['exports', 'ember-metal/core', 'ember-metal/keys', 'ember-metal/dictionary'], function (exports, Ember, emberKeys, dictionary) {

  'use strict';

  var Registry;

  /**
   A lightweight container used to instantiate and cache objects.

   Every `Container` must be associated with a `Registry`, which is referenced
   to determine the factory and options that should be used to instantiate
   objects.

   The public API for `Container` is still in flux and should not be considered
   stable.

   @private
   @class Container
   */
  function Container(registry, options) {
    this._registry = registry || (function () {
      
      // TODO - See note above about transpiler import workaround.
      if (!Registry) {
        Registry = requireModule('container/registry')['default'];
      }

      return new Registry();
    })();

    this.cache = dictionary['default'](options && options.cache ? options.cache : null);
    this.factoryCache = dictionary['default'](options && options.factoryCache ? options.factoryCache : null);
    this.validationCache = dictionary['default'](options && options.validationCache ? options.validationCache : null);
  }

  Container.prototype = {
    /**
     @private
      @property _registry
     @type Registry
     @since 1.11.0
     */
    _registry: null,

    /**
     @property cache
     @type InheritingDict
     */
    cache: null,

    /**
     @property factoryCache
     @type InheritingDict
     */
    factoryCache: null,

    /**
     @property validationCache
     @type InheritingDict
     */
    validationCache: null,

    /**
     Given a fullName return a corresponding instance.
      The default behaviour is for lookup to return a singleton instance.
     The singleton is scoped to the container, allowing multiple containers
     to all have their own locally scoped singletons.
      ```javascript
     var registry = new Registry();
     var container = registry.container();
      registry.register('api:twitter', Twitter);
      var twitter = container.lookup('api:twitter');
      twitter instanceof Twitter; // => true
      // by default the container will return singletons
     var twitter2 = container.lookup('api:twitter');
     twitter2 instanceof Twitter; // => true
      twitter === twitter2; //=> true
     ```
      If singletons are not wanted an optional flag can be provided at lookup.
      ```javascript
     var registry = new Registry();
     var container = registry.container();
      registry.register('api:twitter', Twitter);
      var twitter = container.lookup('api:twitter', { singleton: false });
     var twitter2 = container.lookup('api:twitter', { singleton: false });
      twitter === twitter2; //=> false
     ```
      @method lookup
     @param {String} fullName
     @param {Object} options
     @return {any}
     */
    lookup: function (fullName, options) {
            return lookup(this, this._registry.normalize(fullName), options);
    },

    /**
     Given a fullName return the corresponding factory.
      @method lookupFactory
     @param {String} fullName
     @return {any}
     */
    lookupFactory: function (fullName) {
            return factoryFor(this, this._registry.normalize(fullName));
    },

    /**
     A depth first traversal, destroying the container, its descendant containers and all
     their managed objects.
      @method destroy
     */
    destroy: function () {
      eachDestroyable(this, function (item) {
        if (item.destroy) {
          item.destroy();
        }
      });

      this.isDestroyed = true;
    },

    /**
     Clear either the entire cache or just the cache for a particular key.
      @method reset
     @param {String} fullName optional key to reset; if missing, resets everything
     */
    reset: function (fullName) {
      if (arguments.length > 0) {
        resetMember(this, this._registry.normalize(fullName));
      } else {
        resetCache(this);
      }
    }
  };

  (function exposeRegistryMethods() {
    var methods = ['register', 'unregister', 'resolve', 'normalize', 'typeInjection', 'injection', 'factoryInjection', 'factoryTypeInjection', 'has', 'options', 'optionsForType'];

    function exposeRegistryMethod(method) {
      Container.prototype[method] = function () {
                return this._registry[method].apply(this._registry, arguments);
      };
    }

    for (var i = 0, l = methods.length; i < l; i++) {
      exposeRegistryMethod(methods[i]);
    }
  })();

  function lookup(container, fullName, options) {
    options = options || {};

    if (container.cache[fullName] && options.singleton !== false) {
      return container.cache[fullName];
    }

    var value = instantiate(container, fullName);

    if (value === undefined) {
      return;
    }

    if (container._registry.getOption(fullName, 'singleton') !== false && options.singleton !== false) {
      container.cache[fullName] = value;
    }

    return value;
  }

  function buildInjections(container) {
    var hash = {};

    if (arguments.length > 1) {
      var injectionArgs = Array.prototype.slice.call(arguments, 1);
      var injections = [];
      var injection;

      for (var i = 0, l = injectionArgs.length; i < l; i++) {
        if (injectionArgs[i]) {
          injections = injections.concat(injectionArgs[i]);
        }
      }

      container._registry.validateInjections(injections);

      for (i = 0, l = injections.length; i < l; i++) {
        injection = injections[i];
        hash[injection.property] = lookup(container, injection.fullName);
      }
    }

    return hash;
  }

  function factoryFor(container, fullName) {
    var cache = container.factoryCache;
    if (cache[fullName]) {
      return cache[fullName];
    }
    var registry = container._registry;
    var factory = registry.resolve(fullName);
    if (factory === undefined) {
      return;
    }

    var type = fullName.split(':')[0];
    if (!factory || typeof factory.extend !== 'function' || !Ember['default'].MODEL_FACTORY_INJECTIONS && type === 'model') {
      if (factory && typeof factory._onLookup === 'function') {
        factory._onLookup(fullName);
      }

      // TODO: think about a 'safe' merge style extension
      // for now just fallback to create time injection
      cache[fullName] = factory;
      return factory;
    } else {
      var injections = injectionsFor(container, fullName);
      var factoryInjections = factoryInjectionsFor(container, fullName);

      factoryInjections._toString = registry.makeToString(factory, fullName);

      var injectedFactory = factory.extend(injections);
      injectedFactory.reopenClass(factoryInjections);

      if (factory && typeof factory._onLookup === 'function') {
        factory._onLookup(fullName);
      }

      cache[fullName] = injectedFactory;

      return injectedFactory;
    }
  }

  function injectionsFor(container, fullName) {
    var registry = container._registry;
    var splitName = fullName.split(':');
    var type = splitName[0];

    var injections = buildInjections(container, registry.getTypeInjections(type), registry.getInjections(fullName));
    injections._debugContainerKey = fullName;
    injections.container = container;

    return injections;
  }

  function factoryInjectionsFor(container, fullName) {
    var registry = container._registry;
    var splitName = fullName.split(':');
    var type = splitName[0];

    var factoryInjections = buildInjections(container, registry.getFactoryTypeInjections(type), registry.getFactoryInjections(fullName));
    factoryInjections._debugContainerKey = fullName;

    return factoryInjections;
  }

  function instantiate(container, fullName) {
    var factory = factoryFor(container, fullName);
    var lazyInjections, validationCache;

    if (container._registry.getOption(fullName, 'instantiate') === false) {
      return factory;
    }

    if (factory) {
      if (typeof factory.create !== 'function') {
        throw new Error('Failed to create an instance of \'' + fullName + '\'. ' + 'Most likely an improperly defined class or an invalid module export.');
      }

      validationCache = container.validationCache;

      // Ensure that all lazy injections are valid at instantiation time
      if (!validationCache[fullName] && typeof factory._lazyInjections === 'function') {
        lazyInjections = factory._lazyInjections();
        lazyInjections = container._registry.normalizeInjectionsHash(lazyInjections);

        container._registry.validateInjections(lazyInjections);
      }

      validationCache[fullName] = true;

      if (typeof factory.extend === 'function') {
        // assume the factory was extendable and is already injected
        return factory.create();
      } else {
        // assume the factory was extendable
        // to create time injections
        // TODO: support new'ing for instantiation and merge injections for pure JS Functions
        return factory.create(injectionsFor(container, fullName));
      }
    }
  }

  function eachDestroyable(container, callback) {
    var cache = container.cache;
    var keys = emberKeys['default'](cache);
    var key, value;

    for (var i = 0, l = keys.length; i < l; i++) {
      key = keys[i];
      value = cache[key];

      if (container._registry.getOption(key, 'instantiate') !== false) {
        callback(value);
      }
    }
  }

  function resetCache(container) {
    eachDestroyable(container, function (value) {
      if (value.destroy) {
        value.destroy();
      }
    });

    container.cache.dict = dictionary['default'](null);
  }

  function resetMember(container, fullName) {
    var member = container.cache[fullName];

    delete container.factoryCache[fullName];

    if (member) {
      delete container.cache[fullName];

      if (member.destroy) {
        member.destroy();
      }
    }
  }

  exports['default'] = Container;

});
enifed('container/registry', ['exports', 'ember-metal/core', 'ember-metal/dictionary', './container'], function (exports, Ember, dictionary, Container) {

  'use strict';

  var VALID_FULL_NAME_REGEXP = /^[^:]+.+:[^:]+$/;

  var instanceInitializersFeatureEnabled;
  
    instanceInitializersFeatureEnabled = true;
  

  /**
   A lightweight registry used to store factory and option information keyed
   by type.

   A `Registry` stores the factory and option information needed by a
   `Container` to instantiate and cache objects.

   The public API for `Registry` is still in flux and should not be considered
   stable.

   @private
   @class Registry
   @since 1.11.0
  */
  function Registry(options) {
    this.fallback = options && options.fallback ? options.fallback : null;

    this.resolver = options && options.resolver ? options.resolver : function () {};

    this.registrations = dictionary['default'](options && options.registrations ? options.registrations : null);

    this._typeInjections = dictionary['default'](null);
    this._injections = dictionary['default'](null);
    this._factoryTypeInjections = dictionary['default'](null);
    this._factoryInjections = dictionary['default'](null);

    this._normalizeCache = dictionary['default'](null);
    this._resolveCache = dictionary['default'](null);

    this._options = dictionary['default'](null);
    this._typeOptions = dictionary['default'](null);
  }

  Registry.prototype = {
    /**
     A backup registry for resolving registrations when no matches can be found.
      @property fallback
     @type Registry
     */
    fallback: null,

    /**
     @property resolver
     @type function
     */
    resolver: null,

    /**
     @property registrations
     @type InheritingDict
     */
    registrations: null,

    /**
     @private
      @property _typeInjections
     @type InheritingDict
     */
    _typeInjections: null,

    /**
     @private
      @property _injections
     @type InheritingDict
     */
    _injections: null,

    /**
     @private
      @property _factoryTypeInjections
     @type InheritingDict
     */
    _factoryTypeInjections: null,

    /**
     @private
      @property _factoryInjections
     @type InheritingDict
     */
    _factoryInjections: null,

    /**
     @private
      @property _normalizeCache
     @type InheritingDict
     */
    _normalizeCache: null,

    /**
     @private
      @property _resolveCache
     @type InheritingDict
     */
    _resolveCache: null,

    /**
     @private
      @property _options
     @type InheritingDict
     */
    _options: null,

    /**
     @private
      @property _typeOptions
     @type InheritingDict
     */
    _typeOptions: null,

    /**
     The first container created for this registry.
      This allows deprecated access to `lookup` and `lookupFactory` to avoid
     breaking compatibility for Ember 1.x initializers.
      @private
     @property _defaultContainer
     @type Container
     */
    _defaultContainer: null,

    /**
     Creates a container based on this registry.
      @method container
     @param {Object} options
     @return {Container} created container
     */
    container: function (options) {
      var container = new Container['default'](this, options);

      // 2.0TODO - remove `registerContainer`
      this.registerContainer(container);

      return container;
    },

    /**
     Register the first container created for a registery to allow deprecated
     access to its `lookup` and `lookupFactory` methods to avoid breaking
     compatibility for Ember 1.x initializers.
      2.0TODO: Remove this method. The bookkeeping is only needed to support
              deprecated behavior.
      @param {Container} newly created container
     */
    registerContainer: function (container) {
      if (!this._defaultContainer) {
        this._defaultContainer = container;
      }
      if (this.fallback) {
        this.fallback.registerContainer(container);
      }
    },

    lookup: function (fullName, options) {
      
      if (instanceInitializersFeatureEnabled) {
              }

      return this._defaultContainer.lookup(fullName, options);
    },

    lookupFactory: function (fullName) {
      
      if (instanceInitializersFeatureEnabled) {
              }

      return this._defaultContainer.lookupFactory(fullName);
    },

    /**
     Registers a factory for later injection.
      Example:
      ```javascript
     var registry = new Registry();
      registry.register('model:user', Person, {singleton: false });
     registry.register('fruit:favorite', Orange);
     registry.register('communication:main', Email, {singleton: false});
     ```
      @method register
     @param {String} fullName
     @param {Function} factory
     @param {Object} options
     */
    register: function (fullName, factory, options) {
      
      if (factory === undefined) {
        throw new TypeError('Attempting to register an unknown factory: `' + fullName + '`');
      }

      var normalizedName = this.normalize(fullName);

      if (this._resolveCache[normalizedName]) {
        throw new Error('Cannot re-register: `' + fullName + '`, as it has already been resolved.');
      }

      this.registrations[normalizedName] = factory;
      this._options[normalizedName] = options || {};
    },

    /**
     Unregister a fullName
      ```javascript
     var registry = new Registry();
     registry.register('model:user', User);
      registry.resolve('model:user').create() instanceof User //=> true
      registry.unregister('model:user')
     registry.resolve('model:user') === undefined //=> true
     ```
      @method unregister
     @param {String} fullName
     */
    unregister: function (fullName) {
      
      var normalizedName = this.normalize(fullName);

      delete this.registrations[normalizedName];
      delete this._resolveCache[normalizedName];
      delete this._options[normalizedName];
    },

    /**
     Given a fullName return the corresponding factory.
      By default `resolve` will retrieve the factory from
     the registry.
      ```javascript
     var registry = new Registry();
     registry.register('api:twitter', Twitter);
      registry.resolve('api:twitter') // => Twitter
     ```
      Optionally the registry can be provided with a custom resolver.
     If provided, `resolve` will first provide the custom resolver
     the opportunity to resolve the fullName, otherwise it will fallback
     to the registry.
      ```javascript
     var registry = new Registry();
     registry.resolver = function(fullName) {
        // lookup via the module system of choice
      };
      // the twitter factory is added to the module system
     registry.resolve('api:twitter') // => Twitter
     ```
      @method resolve
     @param {String} fullName
     @return {Function} fullName's factory
     */
    resolve: function (fullName) {
            var factory = resolve(this, this.normalize(fullName));
      if (factory === undefined && this.fallback) {
        factory = this.fallback.resolve(fullName);
      }
      return factory;
    },

    /**
     A hook that can be used to describe how the resolver will
     attempt to find the factory.
      For example, the default Ember `.describe` returns the full
     class name (including namespace) where Ember's resolver expects
     to find the `fullName`.
      @method describe
     @param {String} fullName
     @return {string} described fullName
     */
    describe: function (fullName) {
      return fullName;
    },

    /**
     A hook to enable custom fullName normalization behaviour
      @method normalizeFullName
     @param {String} fullName
     @return {string} normalized fullName
     */
    normalizeFullName: function (fullName) {
      return fullName;
    },

    /**
     normalize a fullName based on the applications conventions
      @method normalize
     @param {String} fullName
     @return {string} normalized fullName
     */
    normalize: function (fullName) {
      return this._normalizeCache[fullName] || (this._normalizeCache[fullName] = this.normalizeFullName(fullName));
    },

    /**
     @method makeToString
      @param {any} factory
     @param {string} fullName
     @return {function} toString function
     */
    makeToString: function (factory, fullName) {
      return factory.toString();
    },

    /**
     Given a fullName check if the container is aware of its factory
     or singleton instance.
      @method has
     @param {String} fullName
     @return {Boolean}
     */
    has: function (fullName) {
            return has(this, this.normalize(fullName));
    },

    /**
     Allow registering options for all factories of a type.
      ```javascript
     var registry = new Registry();
     var container = registry.container();
      // if all of type `connection` must not be singletons
     registry.optionsForType('connection', { singleton: false });
      registry.register('connection:twitter', TwitterConnection);
     registry.register('connection:facebook', FacebookConnection);
      var twitter = container.lookup('connection:twitter');
     var twitter2 = container.lookup('connection:twitter');
      twitter === twitter2; // => false
      var facebook = container.lookup('connection:facebook');
     var facebook2 = container.lookup('connection:facebook');
      facebook === facebook2; // => false
     ```
      @method optionsForType
     @param {String} type
     @param {Object} options
     */
    optionsForType: function (type, options) {
      this._typeOptions[type] = options;
    },

    getOptionsForType: function (type) {
      var optionsForType = this._typeOptions[type];
      if (optionsForType === undefined && this.fallback) {
        optionsForType = this.fallback.getOptionsForType(type);
      }
      return optionsForType;
    },

    /**
     @method options
     @param {String} fullName
     @param {Object} options
     */
    options: function (fullName, options) {
      options = options || {};
      var normalizedName = this.normalize(fullName);
      this._options[normalizedName] = options;
    },

    getOptions: function (fullName) {
      var normalizedName = this.normalize(fullName);
      var options = this._options[normalizedName];
      if (options === undefined && this.fallback) {
        options = this.fallback.getOptions(fullName);
      }
      return options;
    },

    getOption: function (fullName, optionName) {
      var options = this._options[fullName];

      if (options && options[optionName] !== undefined) {
        return options[optionName];
      }

      var type = fullName.split(':')[0];
      options = this._typeOptions[type];

      if (options && options[optionName] !== undefined) {
        return options[optionName];
      } else if (this.fallback) {
        return this.fallback.getOption(fullName, optionName);
      }
    },

    option: function (fullName, optionName) {
            return this.getOption(fullName, optionName);
    },

    /**
     Used only via `injection`.
      Provides a specialized form of injection, specifically enabling
     all objects of one type to be injected with a reference to another
     object.
      For example, provided each object of type `controller` needed a `router`.
     one would do the following:
      ```javascript
     var registry = new Registry();
     var container = registry.container();
      registry.register('router:main', Router);
     registry.register('controller:user', UserController);
     registry.register('controller:post', PostController);
      registry.typeInjection('controller', 'router', 'router:main');
      var user = container.lookup('controller:user');
     var post = container.lookup('controller:post');
      user.router instanceof Router; //=> true
     post.router instanceof Router; //=> true
      // both controllers share the same router
     user.router === post.router; //=> true
     ```
      @private
     @method typeInjection
     @param {String} type
     @param {String} property
     @param {String} fullName
     */
    typeInjection: function (type, property, fullName) {
      
      var fullNameType = fullName.split(':')[0];
      if (fullNameType === type) {
        throw new Error('Cannot inject a `' + fullName + '` on other ' + type + '(s).');
      }

      var injections = this._typeInjections[type] || (this._typeInjections[type] = []);

      injections.push({
        property: property,
        fullName: fullName
      });
    },

    /**
     Defines injection rules.
      These rules are used to inject dependencies onto objects when they
     are instantiated.
      Two forms of injections are possible:
      * Injecting one fullName on another fullName
     * Injecting one fullName on a type
      Example:
      ```javascript
     var registry = new Registry();
     var container = registry.container();
      registry.register('source:main', Source);
     registry.register('model:user', User);
     registry.register('model:post', Post);
      // injecting one fullName on another fullName
     // eg. each user model gets a post model
     registry.injection('model:user', 'post', 'model:post');
      // injecting one fullName on another type
     registry.injection('model', 'source', 'source:main');
      var user = container.lookup('model:user');
     var post = container.lookup('model:post');
      user.source instanceof Source; //=> true
     post.source instanceof Source; //=> true
      user.post instanceof Post; //=> true
      // and both models share the same source
     user.source === post.source; //=> true
     ```
      @method injection
     @param {String} factoryName
     @param {String} property
     @param {String} injectionName
     */
    injection: function (fullName, property, injectionName) {
      this.validateFullName(injectionName);
      var normalizedInjectionName = this.normalize(injectionName);

      if (fullName.indexOf(':') === -1) {
        return this.typeInjection(fullName, property, normalizedInjectionName);
      }

            var normalizedName = this.normalize(fullName);

      var injections = this._injections[normalizedName] || (this._injections[normalizedName] = []);

      injections.push({
        property: property,
        fullName: normalizedInjectionName
      });
    },

    /**
     Used only via `factoryInjection`.
      Provides a specialized form of injection, specifically enabling
     all factory of one type to be injected with a reference to another
     object.
      For example, provided each factory of type `model` needed a `store`.
     one would do the following:
      ```javascript
     var registry = new Registry();
      registry.register('store:main', SomeStore);
      registry.factoryTypeInjection('model', 'store', 'store:main');
      var store = registry.lookup('store:main');
     var UserFactory = registry.lookupFactory('model:user');
      UserFactory.store instanceof SomeStore; //=> true
     ```
      @private
     @method factoryTypeInjection
     @param {String} type
     @param {String} property
     @param {String} fullName
     */
    factoryTypeInjection: function (type, property, fullName) {
      var injections = this._factoryTypeInjections[type] || (this._factoryTypeInjections[type] = []);

      injections.push({
        property: property,
        fullName: this.normalize(fullName)
      });
    },

    /**
     Defines factory injection rules.
      Similar to regular injection rules, but are run against factories, via
     `Registry#lookupFactory`.
      These rules are used to inject objects onto factories when they
     are looked up.
      Two forms of injections are possible:
      * Injecting one fullName on another fullName
     * Injecting one fullName on a type
      Example:
      ```javascript
     var registry = new Registry();
     var container = registry.container();
      registry.register('store:main', Store);
     registry.register('store:secondary', OtherStore);
     registry.register('model:user', User);
     registry.register('model:post', Post);
      // injecting one fullName on another type
     registry.factoryInjection('model', 'store', 'store:main');
      // injecting one fullName on another fullName
     registry.factoryInjection('model:post', 'secondaryStore', 'store:secondary');
      var UserFactory = container.lookupFactory('model:user');
     var PostFactory = container.lookupFactory('model:post');
     var store = container.lookup('store:main');
      UserFactory.store instanceof Store; //=> true
     UserFactory.secondaryStore instanceof OtherStore; //=> false
      PostFactory.store instanceof Store; //=> true
     PostFactory.secondaryStore instanceof OtherStore; //=> true
      // and both models share the same source instance
     UserFactory.store === PostFactory.store; //=> true
     ```
      @method factoryInjection
     @param {String} factoryName
     @param {String} property
     @param {String} injectionName
     */
    factoryInjection: function (fullName, property, injectionName) {
      var normalizedName = this.normalize(fullName);
      var normalizedInjectionName = this.normalize(injectionName);

      this.validateFullName(injectionName);

      if (fullName.indexOf(':') === -1) {
        return this.factoryTypeInjection(normalizedName, property, normalizedInjectionName);
      }

      var injections = this._factoryInjections[normalizedName] || (this._factoryInjections[normalizedName] = []);

      injections.push({
        property: property,
        fullName: normalizedInjectionName
      });
    },

    validateFullName: function (fullName) {
      if (!VALID_FULL_NAME_REGEXP.test(fullName)) {
        throw new TypeError('Invalid Fullname, expected: `type:name` got: ' + fullName);
      }
      return true;
    },

    validateInjections: function (injections) {
      if (!injections) {
        return;
      }

      var fullName;

      for (var i = 0, length = injections.length; i < length; i++) {
        fullName = injections[i].fullName;

        if (!this.has(fullName)) {
          throw new Error('Attempting to inject an unknown injection: `' + fullName + '`');
        }
      }
    },

    normalizeInjectionsHash: function (hash) {
      var injections = [];

      for (var key in hash) {
        if (hash.hasOwnProperty(key)) {
          
          injections.push({
            property: key,
            fullName: hash[key]
          });
        }
      }

      return injections;
    },

    getInjections: function (fullName) {
      var injections = this._injections[fullName] || [];
      if (this.fallback) {
        injections = injections.concat(this.fallback.getInjections(fullName));
      }
      return injections;
    },

    getTypeInjections: function (type) {
      var injections = this._typeInjections[type] || [];
      if (this.fallback) {
        injections = injections.concat(this.fallback.getTypeInjections(type));
      }
      return injections;
    },

    getFactoryInjections: function (fullName) {
      var injections = this._factoryInjections[fullName] || [];
      if (this.fallback) {
        injections = injections.concat(this.fallback.getFactoryInjections(fullName));
      }
      return injections;
    },

    getFactoryTypeInjections: function (type) {
      var injections = this._factoryTypeInjections[type] || [];
      if (this.fallback) {
        injections = injections.concat(this.fallback.getFactoryTypeInjections(type));
      }
      return injections;
    }
  };

  function resolve(registry, normalizedName) {
    var cached = registry._resolveCache[normalizedName];
    if (cached) {
      return cached;
    }

    var resolved = registry.resolver(normalizedName) || registry.registrations[normalizedName];
    registry._resolveCache[normalizedName] = resolved;

    return resolved;
  }

  function has(registry, fullName) {
    return registry.resolve(fullName) !== undefined;
  }

  exports['default'] = Registry;

});
enifed("dag-map",
  ["exports"],
  function(__exports__) {
    "use strict";
    function visit(vertex, fn, visited, path) {
      var name = vertex.name;
      var vertices = vertex.incoming;
      var names = vertex.incomingNames;
      var len = names.length;
      var i;

      if (!visited) {
        visited = {};
      }
      if (!path) {
        path = [];
      }
      if (visited.hasOwnProperty(name)) {
        return;
      }
      path.push(name);
      visited[name] = true;
      for (i = 0; i < len; i++) {
        visit(vertices[names[i]], fn, visited, path);
      }
      fn(vertex, path);
      path.pop();
    }


    /**
     * DAG stands for Directed acyclic graph.
     *
     * It is used to build a graph of dependencies checking that there isn't circular
     * dependencies. p.e Registering initializers with a certain precedence order.
     *
     * @class DAG
     * @constructor
     */
    function DAG() {
      this.names = [];
      this.vertices = Object.create(null);
    }

    /**
     * DAG Vertex
     *
     * @class Vertex
     * @constructor
     */

    function Vertex(name) {
      this.name = name;
      this.incoming = {};
      this.incomingNames = [];
      this.hasOutgoing = false;
      this.value = null;
    }

    /**
     * Adds a vertex entry to the graph unless it is already added.
     *
     * @private
     * @method add
     * @param {String} name The name of the vertex to add
     */
    DAG.prototype.add = function(name) {
      if (!name) {
        throw new Error("Can't add Vertex without name");
      }
      if (this.vertices[name] !== undefined) {
        return this.vertices[name];
      }
      var vertex = new Vertex(name);
      this.vertices[name] = vertex;
      this.names.push(name);
      return vertex;
    };

    /**
     * Adds a vertex to the graph and sets its value.
     *
     * @private
     * @method map
     * @param {String} name The name of the vertex.
     * @param         value The value to put in the vertex.
     */
    DAG.prototype.map = function(name, value) {
      this.add(name).value = value;
    };

    /**
     * Connects the vertices with the given names, adding them to the graph if
     * necessary, only if this does not produce is any circular dependency.
     *
     * @private
     * @method addEdge
     * @param {String} fromName The name the vertex where the edge starts.
     * @param {String} toName The name the vertex where the edge ends.
     */
    DAG.prototype.addEdge = function(fromName, toName) {
      if (!fromName || !toName || fromName === toName) {
        return;
      }
      var from = this.add(fromName);
      var to = this.add(toName);
      if (to.incoming.hasOwnProperty(fromName)) {
        return;
      }
      function checkCycle(vertex, path) {
        if (vertex.name === toName) {
          throw new Error("cycle detected: " + toName + " <- " + path.join(" <- "));
        }
      }
      visit(from, checkCycle);
      from.hasOutgoing = true;
      to.incoming[fromName] = from;
      to.incomingNames.push(fromName);
    };

    /**
     * Visits all the vertex of the graph calling the given function with each one,
     * ensuring that the vertices are visited respecting their precedence.
     *
     * @method  topsort
     * @param {Function} fn The function to be invoked on each vertex.
     */
    DAG.prototype.topsort = function(fn) {
      var visited = {};
      var vertices = this.vertices;
      var names = this.names;
      var len = names.length;
      var i, vertex;

      for (i = 0; i < len; i++) {
        vertex = vertices[names[i]];
        if (!vertex.hasOutgoing) {
          visit(vertex, fn, visited);
        }
      }
    };

    /**
     * Adds a vertex with the given name and value to the graph and joins it with the
     * vertices referenced in _before_ and _after_. If there isn't vertices with those
     * names, they are added too.
     *
     * If either _before_ or _after_ are falsy/empty, the added vertex will not have
     * an incoming/outgoing edge.
     *
     * @method addEdges
     * @param {String} name The name of the vertex to be added.
     * @param         value The value of that vertex.
     * @param        before An string or array of strings with the names of the vertices before
     *                      which this vertex must be visited.
     * @param         after An string or array of strings with the names of the vertex after
     *                      which this vertex must be visited.
     *
     */
    DAG.prototype.addEdges = function(name, value, before, after) {
      var i;
      this.map(name, value);
      if (before) {
        if (typeof before === 'string') {
          this.addEdge(name, before);
        } else {
          for (i = 0; i < before.length; i++) {
            this.addEdge(name, before[i]);
          }
        }
      }
      if (after) {
        if (typeof after === 'string') {
          this.addEdge(after, name);
        } else {
          for (i = 0; i < after.length; i++) {
            this.addEdge(after[i], name);
          }
        }
      }
    };

    __exports__["default"] = DAG;
  });
enifed("dag-map.umd",
  ["./dag-map"],
  function(__dependency1__) {
    "use strict";
    var DAG = __dependency1__["default"];

    /* global define:true module:true window: true */
    if (typeof enifed === 'function' && enifed.amd) {
      enifed(function() { return DAG; });
    } else if (typeof module !== 'undefined' && module.exports) {
      module.exports = DAG;
    } else if (typeof this !== 'undefined') {
      this['DAG'] = DAG;
    }
  });
enifed("dom-helper",
  ["./morph-range","./morph-attr","./dom-helper/build-html-dom","./dom-helper/classes","./dom-helper/prop","exports"],
  function(__dependency1__, __dependency2__, __dependency3__, __dependency4__, __dependency5__, __exports__) {
    "use strict";
    var Morph = __dependency1__["default"];
    var AttrMorph = __dependency2__["default"];
    var buildHTMLDOM = __dependency3__.buildHTMLDOM;
    var svgNamespace = __dependency3__.svgNamespace;
    var svgHTMLIntegrationPoints = __dependency3__.svgHTMLIntegrationPoints;
    var addClasses = __dependency4__.addClasses;
    var removeClasses = __dependency4__.removeClasses;
    var normalizeProperty = __dependency5__.normalizeProperty;
    var isAttrRemovalValue = __dependency5__.isAttrRemovalValue;

    var doc = typeof document === 'undefined' ? false : document;

    var deletesBlankTextNodes = doc && (function(document){
      var element = document.createElement('div');
      element.appendChild( document.createTextNode('') );
      var clonedElement = element.cloneNode(true);
      return clonedElement.childNodes.length === 0;
    })(doc);

    var ignoresCheckedAttribute = doc && (function(document){
      var element = document.createElement('input');
      element.setAttribute('checked', 'checked');
      var clonedElement = element.cloneNode(false);
      return !clonedElement.checked;
    })(doc);

    var canRemoveSvgViewBoxAttribute = doc && (doc.createElementNS ? (function(document){
      var element = document.createElementNS(svgNamespace, 'svg');
      element.setAttribute('viewBox', '0 0 100 100');
      element.removeAttribute('viewBox');
      return !element.getAttribute('viewBox');
    })(doc) : true);

    var canClone = doc && (function(document){
      var element = document.createElement('div');
      element.appendChild( document.createTextNode(' '));
      element.appendChild( document.createTextNode(' '));
      var clonedElement = element.cloneNode(true);
      return clonedElement.childNodes[0].nodeValue === ' ';
    })(doc);

    // This is not the namespace of the element, but of
    // the elements inside that elements.
    function interiorNamespace(element){
      if (
        element &&
        element.namespaceURI === svgNamespace &&
        !svgHTMLIntegrationPoints[element.tagName]
      ) {
        return svgNamespace;
      } else {
        return null;
      }
    }

    // The HTML spec allows for "omitted start tags". These tags are optional
    // when their intended child is the first thing in the parent tag. For
    // example, this is a tbody start tag:
    //
    // <table>
    //   <tbody>
    //     <tr>
    //
    // The tbody may be omitted, and the browser will accept and render:
    //
    // <table>
    //   <tr>
    //
    // However, the omitted start tag will still be added to the DOM. Here
    // we test the string and context to see if the browser is about to
    // perform this cleanup.
    //
    // http://www.whatwg.org/specs/web-apps/current-work/multipage/syntax.html#optional-tags
    // describes which tags are omittable. The spec for tbody and colgroup
    // explains this behavior:
    //
    // http://www.whatwg.org/specs/web-apps/current-work/multipage/tables.html#the-tbody-element
    // http://www.whatwg.org/specs/web-apps/current-work/multipage/tables.html#the-colgroup-element
    //

    var omittedStartTagChildTest = /<([\w:]+)/;
    function detectOmittedStartTag(string, contextualElement){
      // Omitted start tags are only inside table tags.
      if (contextualElement.tagName === 'TABLE') {
        var omittedStartTagChildMatch = omittedStartTagChildTest.exec(string);
        if (omittedStartTagChildMatch) {
          var omittedStartTagChild = omittedStartTagChildMatch[1];
          // It is already asserted that the contextual element is a table
          // and not the proper start tag. Just see if a tag was omitted.
          return omittedStartTagChild === 'tr' ||
                 omittedStartTagChild === 'col';
        }
      }
    }

    function buildSVGDOM(html, dom){
      var div = dom.document.createElement('div');
      div.innerHTML = '<svg>'+html+'</svg>';
      return div.firstChild.childNodes;
    }

    /*
     * A class wrapping DOM functions to address environment compatibility,
     * namespaces, contextual elements for morph un-escaped content
     * insertion.
     *
     * When entering a template, a DOMHelper should be passed:
     *
     *   template(context, { hooks: hooks, dom: new DOMHelper() });
     *
     * TODO: support foreignObject as a passed contextual element. It has
     * a namespace (svg) that does not match its internal namespace
     * (xhtml).
     *
     * @class DOMHelper
     * @constructor
     * @param {HTMLDocument} _document The document DOM methods are proxied to
     */
    function DOMHelper(_document){
      this.document = _document || document;
      if (!this.document) {
        throw new Error("A document object must be passed to the DOMHelper, or available on the global scope");
      }
      this.canClone = canClone;
      this.namespace = null;
    }

    var prototype = DOMHelper.prototype;
    prototype.constructor = DOMHelper;

    prototype.getElementById = function(id, rootNode) {
      rootNode = rootNode || this.document;
      return rootNode.getElementById(id);
    };

    prototype.insertBefore = function(element, childElement, referenceChild) {
      return element.insertBefore(childElement, referenceChild);
    };

    prototype.appendChild = function(element, childElement) {
      return element.appendChild(childElement);
    };

    prototype.childAt = function(element, indices) {
      var child = element;

      for (var i = 0; i < indices.length; i++) {
        child = child.childNodes.item(indices[i]);
      }

      return child;
    };

    // Note to a Fellow Implementor:
    // Ahh, accessing a child node at an index. Seems like it should be so simple,
    // doesn't it? Unfortunately, this particular method has caused us a surprising
    // amount of pain. As you'll note below, this method has been modified to walk
    // the linked list of child nodes rather than access the child by index
    // directly, even though there are two (2) APIs in the DOM that do this for us.
    // If you're thinking to yourself, "What an oversight! What an opportunity to
    // optimize this code!" then to you I say: stop! For I have a tale to tell.
    //
    // First, this code must be compatible with simple-dom for rendering on the
    // server where there is no real DOM. Previously, we accessed a child node
    // directly via `element.childNodes[index]`. While we *could* in theory do a
    // full-fidelity simulation of a live `childNodes` array, this is slow,
    // complicated and error-prone.
    //
    // "No problem," we thought, "we'll just use the similar
    // `childNodes.item(index)` API." Then, we could just implement our own `item`
    // method in simple-dom and walk the child node linked list there, allowing
    // us to retain the performance advantages of the (surely optimized) `item()`
    // API in the browser.
    //
    // Unfortunately, an enterprising soul named Samy Alzahrani discovered that in
    // IE8, accessing an item out-of-bounds via `item()` causes an exception where
    // other browsers return null. This necessitated a... check of
    // `childNodes.length`, bringing us back around to having to support a
    // full-fidelity `childNodes` array!
    //
    // Worst of all, Kris Selden investigated how browsers are actualy implemented
    // and discovered that they're all linked lists under the hood anyway. Accessing
    // `childNodes` requires them to allocate a new live collection backed by that
    // linked list, which is itself a rather expensive operation. Our assumed
    // optimization had backfired! That is the danger of magical thinking about
    // the performance of native implementations.
    //
    // And this, my friends, is why the following implementation just walks the
    // linked list, as surprised as that may make you. Please ensure you understand
    // the above before changing this and submitting a PR.
    //
    // Tom Dale, January 18th, 2015, Portland OR
    prototype.childAtIndex = function(element, index) {
      var node = element.firstChild;

      for (var idx = 0; node && idx < index; idx++) {
        node = node.nextSibling;
      }

      return node;
    };

    prototype.appendText = function(element, text) {
      return element.appendChild(this.document.createTextNode(text));
    };

    prototype.setAttribute = function(element, name, value) {
      element.setAttribute(name, String(value));
    };

    prototype.setAttributeNS = function(element, namespace, name, value) {
      element.setAttributeNS(namespace, name, String(value));
    };

    if (canRemoveSvgViewBoxAttribute){
      prototype.removeAttribute = function(element, name) {
        element.removeAttribute(name);
      };
    } else {
      prototype.removeAttribute = function(element, name) {
        if (element.tagName === 'svg' && name === 'viewBox') {
          element.setAttribute(name, null);
        } else {
          element.removeAttribute(name);
        }
      };
    }

    prototype.setPropertyStrict = function(element, name, value) {
      element[name] = value;
    };

    prototype.setProperty = function(element, name, value, namespace) {
      var lowercaseName = name.toLowerCase();
      if (element.namespaceURI === svgNamespace || lowercaseName === 'style') {
        if (isAttrRemovalValue(value)) {
          element.removeAttribute(name);
        } else {
          if (namespace) {
            element.setAttributeNS(namespace, name, value);
          } else {
            element.setAttribute(name, value);
          }
        }
      } else {
        var normalized = normalizeProperty(element, name);
        if (normalized) {
          element[normalized] = value;
        } else {
          if (isAttrRemovalValue(value)) {
            element.removeAttribute(name);
          } else {
            if (namespace && element.setAttributeNS) {
              element.setAttributeNS(namespace, name, value);
            } else {
              element.setAttribute(name, value);
            }
          }
        }
      }
    };

    if (doc && doc.createElementNS) {
      // Only opt into namespace detection if a contextualElement
      // is passed.
      prototype.createElement = function(tagName, contextualElement) {
        var namespace = this.namespace;
        if (contextualElement) {
          if (tagName === 'svg') {
            namespace = svgNamespace;
          } else {
            namespace = interiorNamespace(contextualElement);
          }
        }
        if (namespace) {
          return this.document.createElementNS(namespace, tagName);
        } else {
          return this.document.createElement(tagName);
        }
      };
      prototype.setAttributeNS = function(element, namespace, name, value) {
        element.setAttributeNS(namespace, name, String(value));
      };
    } else {
      prototype.createElement = function(tagName) {
        return this.document.createElement(tagName);
      };
      prototype.setAttributeNS = function(element, namespace, name, value) {
        element.setAttribute(name, String(value));
      };
    }

    prototype.addClasses = addClasses;
    prototype.removeClasses = removeClasses;

    prototype.setNamespace = function(ns) {
      this.namespace = ns;
    };

    prototype.detectNamespace = function(element) {
      this.namespace = interiorNamespace(element);
    };

    prototype.createDocumentFragment = function(){
      return this.document.createDocumentFragment();
    };

    prototype.createTextNode = function(text){
      return this.document.createTextNode(text);
    };

    prototype.createComment = function(text){
      return this.document.createComment(text);
    };

    prototype.repairClonedNode = function(element, blankChildTextNodes, isChecked){
      if (deletesBlankTextNodes && blankChildTextNodes.length > 0) {
        for (var i=0, len=blankChildTextNodes.length;i<len;i++){
          var textNode = this.document.createTextNode(''),
              offset = blankChildTextNodes[i],
              before = this.childAtIndex(element, offset);
          if (before) {
            element.insertBefore(textNode, before);
          } else {
            element.appendChild(textNode);
          }
        }
      }
      if (ignoresCheckedAttribute && isChecked) {
        element.setAttribute('checked', 'checked');
      }
    };

    prototype.cloneNode = function(element, deep){
      var clone = element.cloneNode(!!deep);
      return clone;
    };

    prototype.createAttrMorph = function(element, attrName, namespace){
      return new AttrMorph(element, attrName, this, namespace);
    };

    prototype.createUnsafeAttrMorph = function(element, attrName, namespace){
      var morph = this.createAttrMorph(element, attrName, namespace);
      morph.escaped = false;
      return morph;
    };

    prototype.createMorph = function(parent, start, end, contextualElement){
      if (contextualElement && contextualElement.nodeType === 11) {
        throw new Error("Cannot pass a fragment as the contextual element to createMorph");
      }

      if (!contextualElement && parent.nodeType === 1) {
        contextualElement = parent;
      }
      var morph = new Morph(this, contextualElement);
      morph.firstNode = start;
      morph.lastNode = end;
      morph.state = {};
      morph.isDirty = true;
      return morph;
    };

    prototype.createUnsafeMorph = function(parent, start, end, contextualElement){
      var morph = this.createMorph(parent, start, end, contextualElement);
      morph.parseTextAsHTML = true;
      return morph;
    };

    // This helper is just to keep the templates good looking,
    // passing integers instead of element references.
    prototype.createMorphAt = function(parent, startIndex, endIndex, contextualElement){
      var single = startIndex === endIndex;
      var start = this.childAtIndex(parent, startIndex);
      var end = single ? start : this.childAtIndex(parent, endIndex);
      return this.createMorph(parent, start, end, contextualElement);
    };

    prototype.createUnsafeMorphAt = function(parent, startIndex, endIndex, contextualElement) {
      var morph = this.createMorphAt(parent, startIndex, endIndex, contextualElement);
      morph.parseTextAsHTML = true;
      return morph;
    };

    prototype.insertMorphBefore = function(element, referenceChild, contextualElement) {
      var insertion = this.document.createComment('');
      element.insertBefore(insertion, referenceChild);
      return this.createMorph(element, insertion, insertion, contextualElement);
    };

    prototype.appendMorph = function(element, contextualElement) {
      var insertion = this.document.createComment('');
      element.appendChild(insertion);
      return this.createMorph(element, insertion, insertion, contextualElement);
    };

    prototype.insertBoundary = function(fragment, index) {
      // this will always be null or firstChild
      var child = index === null ? null : this.childAtIndex(fragment, index);
      this.insertBefore(fragment, this.createTextNode(''), child);
    };

    prototype.parseHTML = function(html, contextualElement) {
      var childNodes;

      if (interiorNamespace(contextualElement) === svgNamespace) {
        childNodes = buildSVGDOM(html, this);
      } else {
        var nodes = buildHTMLDOM(html, contextualElement, this);
        if (detectOmittedStartTag(html, contextualElement)) {
          var node = nodes[0];
          while (node && node.nodeType !== 1) {
            node = node.nextSibling;
          }
          childNodes = node.childNodes;
        } else {
          childNodes = nodes;
        }
      }

      // Copy node list to a fragment.
      var fragment = this.document.createDocumentFragment();

      if (childNodes && childNodes.length > 0) {
        var currentNode = childNodes[0];

        // We prepend an <option> to <select> boxes to absorb any browser bugs
        // related to auto-select behavior. Skip past it.
        if (contextualElement.tagName === 'SELECT') {
          currentNode = currentNode.nextSibling;
        }

        while (currentNode) {
          var tempNode = currentNode;
          currentNode = currentNode.nextSibling;

          fragment.appendChild(tempNode);
        }
      }

      return fragment;
    };

    var parsingNode;

    // Used to determine whether a URL needs to be sanitized.
    prototype.protocolForURL = function(url) {
      if (!parsingNode) {
        parsingNode = this.document.createElement('a');
      }

      parsingNode.href = url;
      return parsingNode.protocol;
    };

    __exports__["default"] = DOMHelper;
  });
enifed("dom-helper/build-html-dom",
  ["exports"],
  function(__exports__) {
    "use strict";
    /* global XMLSerializer:false */
    var svgHTMLIntegrationPoints = {foreignObject: 1, desc: 1, title: 1};
    __exports__.svgHTMLIntegrationPoints = svgHTMLIntegrationPoints;var svgNamespace = 'http://www.w3.org/2000/svg';
    __exports__.svgNamespace = svgNamespace;
    var doc = typeof document === 'undefined' ? false : document;

    // Safari does not like using innerHTML on SVG HTML integration
    // points (desc/title/foreignObject).
    var needsIntegrationPointFix = doc && (function(document) {
      if (document.createElementNS === undefined) {
        return;
      }
      // In FF title will not accept innerHTML.
      var testEl = document.createElementNS(svgNamespace, 'title');
      testEl.innerHTML = "<div></div>";
      return testEl.childNodes.length === 0 || testEl.childNodes[0].nodeType !== 1;
    })(doc);

    // Internet Explorer prior to 9 does not allow setting innerHTML if the first element
    // is a "zero-scope" element. This problem can be worked around by making
    // the first node an invisible text node. We, like Modernizr, use &shy;
    var needsShy = doc && (function(document) {
      var testEl = document.createElement('div');
      testEl.innerHTML = "<div></div>";
      testEl.firstChild.innerHTML = "<script><\/script>";
      return testEl.firstChild.innerHTML === '';
    })(doc);

    // IE 8 (and likely earlier) likes to move whitespace preceeding
    // a script tag to appear after it. This means that we can
    // accidentally remove whitespace when updating a morph.
    var movesWhitespace = doc && (function(document) {
      var testEl = document.createElement('div');
      testEl.innerHTML = "Test: <script type='text/x-placeholder'><\/script>Value";
      return testEl.childNodes[0].nodeValue === 'Test:' &&
              testEl.childNodes[2].nodeValue === ' Value';
    })(doc);

    var tagNamesRequiringInnerHTMLFix = doc && (function(document) {
      var tagNamesRequiringInnerHTMLFix;
      // IE 9 and earlier don't allow us to set innerHTML on col, colgroup, frameset,
      // html, style, table, tbody, tfoot, thead, title, tr. Detect this and add
      // them to an initial list of corrected tags.
      //
      // Here we are only dealing with the ones which can have child nodes.
      //
      var tableNeedsInnerHTMLFix;
      var tableInnerHTMLTestElement = document.createElement('table');
      try {
        tableInnerHTMLTestElement.innerHTML = '<tbody></tbody>';
      } catch (e) {
      } finally {
        tableNeedsInnerHTMLFix = (tableInnerHTMLTestElement.childNodes.length === 0);
      }
      if (tableNeedsInnerHTMLFix) {
        tagNamesRequiringInnerHTMLFix = {
          colgroup: ['table'],
          table: [],
          tbody: ['table'],
          tfoot: ['table'],
          thead: ['table'],
          tr: ['table', 'tbody']
        };
      }

      // IE 8 doesn't allow setting innerHTML on a select tag. Detect this and
      // add it to the list of corrected tags.
      //
      var selectInnerHTMLTestElement = document.createElement('select');
      selectInnerHTMLTestElement.innerHTML = '<option></option>';
      if (!selectInnerHTMLTestElement.childNodes[0]) {
        tagNamesRequiringInnerHTMLFix = tagNamesRequiringInnerHTMLFix || {};
        tagNamesRequiringInnerHTMLFix.select = [];
      }
      return tagNamesRequiringInnerHTMLFix;
    })(doc);

    function scriptSafeInnerHTML(element, html) {
      // without a leading text node, IE will drop a leading script tag.
      html = '&shy;'+html;

      element.innerHTML = html;

      var nodes = element.childNodes;

      // Look for &shy; to remove it.
      var shyElement = nodes[0];
      while (shyElement.nodeType === 1 && !shyElement.nodeName) {
        shyElement = shyElement.firstChild;
      }
      // At this point it's the actual unicode character.
      if (shyElement.nodeType === 3 && shyElement.nodeValue.charAt(0) === "\u00AD") {
        var newValue = shyElement.nodeValue.slice(1);
        if (newValue.length) {
          shyElement.nodeValue = shyElement.nodeValue.slice(1);
        } else {
          shyElement.parentNode.removeChild(shyElement);
        }
      }

      return nodes;
    }

    function buildDOMWithFix(html, contextualElement){
      var tagName = contextualElement.tagName;

      // Firefox versions < 11 do not have support for element.outerHTML.
      var outerHTML = contextualElement.outerHTML || new XMLSerializer().serializeToString(contextualElement);
      if (!outerHTML) {
        throw "Can't set innerHTML on "+tagName+" in this browser";
      }

      html = fixSelect(html, contextualElement);

      var wrappingTags = tagNamesRequiringInnerHTMLFix[tagName.toLowerCase()];

      var startTag = outerHTML.match(new RegExp("<"+tagName+"([^>]*)>", 'i'))[0];
      var endTag = '</'+tagName+'>';

      var wrappedHTML = [startTag, html, endTag];

      var i = wrappingTags.length;
      var wrappedDepth = 1 + i;
      while(i--) {
        wrappedHTML.unshift('<'+wrappingTags[i]+'>');
        wrappedHTML.push('</'+wrappingTags[i]+'>');
      }

      var wrapper = document.createElement('div');
      scriptSafeInnerHTML(wrapper, wrappedHTML.join(''));
      var element = wrapper;
      while (wrappedDepth--) {
        element = element.firstChild;
        while (element && element.nodeType !== 1) {
          element = element.nextSibling;
        }
      }
      while (element && element.tagName !== tagName) {
        element = element.nextSibling;
      }
      return element ? element.childNodes : [];
    }

    var buildDOM;
    if (needsShy) {
      buildDOM = function buildDOM(html, contextualElement, dom){
        html = fixSelect(html, contextualElement);

        contextualElement = dom.cloneNode(contextualElement, false);
        scriptSafeInnerHTML(contextualElement, html);
        return contextualElement.childNodes;
      };
    } else {
      buildDOM = function buildDOM(html, contextualElement, dom){
        html = fixSelect(html, contextualElement);

        contextualElement = dom.cloneNode(contextualElement, false);
        contextualElement.innerHTML = html;
        return contextualElement.childNodes;
      };
    }

    function fixSelect(html, contextualElement) {
      if (contextualElement.tagName === 'SELECT') {
        html = "<option></option>" + html;
      }

      return html;
    }

    var buildIESafeDOM;
    if (tagNamesRequiringInnerHTMLFix || movesWhitespace) {
      buildIESafeDOM = function buildIESafeDOM(html, contextualElement, dom) {
        // Make a list of the leading text on script nodes. Include
        // script tags without any whitespace for easier processing later.
        var spacesBefore = [];
        var spacesAfter = [];
        if (typeof html === 'string') {
          html = html.replace(/(\s*)(<script)/g, function(match, spaces, tag) {
            spacesBefore.push(spaces);
            return tag;
          });

          html = html.replace(/(<\/script>)(\s*)/g, function(match, tag, spaces) {
            spacesAfter.push(spaces);
            return tag;
          });
        }

        // Fetch nodes
        var nodes;
        if (tagNamesRequiringInnerHTMLFix[contextualElement.tagName.toLowerCase()]) {
          // buildDOMWithFix uses string wrappers for problematic innerHTML.
          nodes = buildDOMWithFix(html, contextualElement);
        } else {
          nodes = buildDOM(html, contextualElement, dom);
        }

        // Build a list of script tags, the nodes themselves will be
        // mutated as we add test nodes.
        var i, j, node, nodeScriptNodes;
        var scriptNodes = [];
        for (i=0;i<nodes.length;i++) {
          node=nodes[i];
          if (node.nodeType !== 1) {
            continue;
          }
          if (node.tagName === 'SCRIPT') {
            scriptNodes.push(node);
          } else {
            nodeScriptNodes = node.getElementsByTagName('script');
            for (j=0;j<nodeScriptNodes.length;j++) {
              scriptNodes.push(nodeScriptNodes[j]);
            }
          }
        }

        // Walk the script tags and put back their leading text nodes.
        var scriptNode, textNode, spaceBefore, spaceAfter;
        for (i=0;i<scriptNodes.length;i++) {
          scriptNode = scriptNodes[i];
          spaceBefore = spacesBefore[i];
          if (spaceBefore && spaceBefore.length > 0) {
            textNode = dom.document.createTextNode(spaceBefore);
            scriptNode.parentNode.insertBefore(textNode, scriptNode);
          }

          spaceAfter = spacesAfter[i];
          if (spaceAfter && spaceAfter.length > 0) {
            textNode = dom.document.createTextNode(spaceAfter);
            scriptNode.parentNode.insertBefore(textNode, scriptNode.nextSibling);
          }
        }

        return nodes;
      };
    } else {
      buildIESafeDOM = buildDOM;
    }

    var buildHTMLDOM;
    if (needsIntegrationPointFix) {
      buildHTMLDOM = function buildHTMLDOM(html, contextualElement, dom){
        if (svgHTMLIntegrationPoints[contextualElement.tagName]) {
          return buildIESafeDOM(html, document.createElement('div'), dom);
        } else {
          return buildIESafeDOM(html, contextualElement, dom);
        }
      };
    } else {
      buildHTMLDOM = buildIESafeDOM;
    }

    __exports__.buildHTMLDOM = buildHTMLDOM;
  });
enifed("dom-helper/classes",
  ["exports"],
  function(__exports__) {
    "use strict";
    var doc = typeof document === 'undefined' ? false : document;

    // PhantomJS has a broken classList. See https://github.com/ariya/phantomjs/issues/12782
    var canClassList = doc && (function(){
      var d = document.createElement('div');
      if (!d.classList) {
        return false;
      }
      d.classList.add('boo');
      d.classList.add('boo', 'baz');
      return (d.className === 'boo baz');
    })();

    function buildClassList(element) {
      var classString = (element.getAttribute('class') || '');
      return classString !== '' && classString !== ' ' ? classString.split(' ') : [];
    }

    function intersect(containingArray, valuesArray) {
      var containingIndex = 0;
      var containingLength = containingArray.length;
      var valuesIndex = 0;
      var valuesLength = valuesArray.length;

      var intersection = new Array(valuesLength);

      // TODO: rewrite this loop in an optimal manner
      for (;containingIndex<containingLength;containingIndex++) {
        valuesIndex = 0;
        for (;valuesIndex<valuesLength;valuesIndex++) {
          if (valuesArray[valuesIndex] === containingArray[containingIndex]) {
            intersection[valuesIndex] = containingIndex;
            break;
          }
        }
      }

      return intersection;
    }

    function addClassesViaAttribute(element, classNames) {
      var existingClasses = buildClassList(element);

      var indexes = intersect(existingClasses, classNames);
      var didChange = false;

      for (var i=0, l=classNames.length; i<l; i++) {
        if (indexes[i] === undefined) {
          didChange = true;
          existingClasses.push(classNames[i]);
        }
      }

      if (didChange) {
        element.setAttribute('class', existingClasses.length > 0 ? existingClasses.join(' ') : '');
      }
    }

    function removeClassesViaAttribute(element, classNames) {
      var existingClasses = buildClassList(element);

      var indexes = intersect(classNames, existingClasses);
      var didChange = false;
      var newClasses = [];

      for (var i=0, l=existingClasses.length; i<l; i++) {
        if (indexes[i] === undefined) {
          newClasses.push(existingClasses[i]);
        } else {
          didChange = true;
        }
      }

      if (didChange) {
        element.setAttribute('class', newClasses.length > 0 ? newClasses.join(' ') : '');
      }
    }

    var addClasses, removeClasses;
    if (canClassList) {
      addClasses = function addClasses(element, classNames) {
        if (element.classList) {
          if (classNames.length === 1) {
            element.classList.add(classNames[0]);
          } else if (classNames.length === 2) {
            element.classList.add(classNames[0], classNames[1]);
          } else {
            element.classList.add.apply(element.classList, classNames);
          }
        } else {
          addClassesViaAttribute(element, classNames);
        }
      };
      removeClasses = function removeClasses(element, classNames) {
        if (element.classList) {
          if (classNames.length === 1) {
            element.classList.remove(classNames[0]);
          } else if (classNames.length === 2) {
            element.classList.remove(classNames[0], classNames[1]);
          } else {
            element.classList.remove.apply(element.classList, classNames);
          }
        } else {
          removeClassesViaAttribute(element, classNames);
        }
      };
    } else {
      addClasses = addClassesViaAttribute;
      removeClasses = removeClassesViaAttribute;
    }

    __exports__.addClasses = addClasses;
    __exports__.removeClasses = removeClasses;
  });
enifed("dom-helper/prop",
  ["exports"],
  function(__exports__) {
    "use strict";
    function isAttrRemovalValue(value) {
      return value === null || value === undefined;
    }

    __exports__.isAttrRemovalValue = isAttrRemovalValue;// TODO should this be an o_create kind of thing?
    var propertyCaches = {};
    __exports__.propertyCaches = propertyCaches;
    function normalizeProperty(element, attrName) {
      var tagName = element.tagName;
      var key;
      var cache = propertyCaches[tagName];
      if (!cache) {
        // TODO should this be an o_create kind of thing?
        cache = {};
        for (key in element) {
          cache[key.toLowerCase()] = key;
        }
        propertyCaches[tagName] = cache;
      }

      // presumes that the attrName has been lowercased.
      return cache[attrName];
    }

    __exports__.normalizeProperty = normalizeProperty;
  });
enifed('ember-application', ['ember-metal/core', 'ember-runtime/system/lazy_load', 'ember-application/system/resolver', 'ember-application/system/application', 'ember-application/ext/controller'], function (Ember, lazy_load, DefaultResolver, Application) {

	'use strict';

	Ember['default'].Application = Application['default'];
	Ember['default'].Resolver = DefaultResolver.Resolver;
	Ember['default'].DefaultResolver = DefaultResolver['default'];

	lazy_load.runLoadHooks('Ember.Application', Application['default']);

});
enifed('ember-application/ext/controller', ['exports', 'ember-metal/core', 'ember-metal/property_get', 'ember-metal/error', 'ember-metal/utils', 'ember-metal/computed', 'ember-runtime/mixins/controller', 'ember-routing/system/controller_for'], function (exports, Ember, property_get, EmberError, utils, computed, ControllerMixin, controllerFor) {

  'use strict';

  /**
  @module ember
  @submodule ember-application
  */

  function verifyNeedsDependencies(controller, container, needs) {
    var dependency, i, l;
    var missing = [];

    for (i = 0, l = needs.length; i < l; i++) {
      dependency = needs[i];

      
      if (dependency.indexOf(":") === -1) {
        dependency = "controller:" + dependency;
      }

      // Structure assert to still do verification but not string concat in production
      if (!container._registry.has(dependency)) {
        missing.push(dependency);
      }
    }
    if (missing.length) {
      throw new EmberError['default'](utils.inspect(controller) + " needs [ " + missing.join(", ") + " ] but " + (missing.length > 1 ? "they" : "it") + " could not be found");
    }
  }

  var defaultControllersComputedProperty = computed.computed(function () {
    var controller = this;

    return {
      needs: property_get.get(controller, "needs"),
      container: property_get.get(controller, "container"),
      unknownProperty: function (controllerName) {
        var needs = this.needs;
        var dependency, i, l;

        for (i = 0, l = needs.length; i < l; i++) {
          dependency = needs[i];
          if (dependency === controllerName) {
            return this.container.lookup("controller:" + controllerName);
          }
        }

        var errorMessage = utils.inspect(controller) + "#needs does not include `" + controllerName + "`. To access the " + controllerName + " controller from " + utils.inspect(controller) + ", " + utils.inspect(controller) + " should have a `needs` property that is an array of the controllers it has access to.";
        throw new ReferenceError(errorMessage);
      },
      setUnknownProperty: function (key, value) {
        throw new Error("You cannot overwrite the value of `controllers." + key + "` of " + utils.inspect(controller));
      }
    };
  });

  /**
    @class ControllerMixin
    @namespace Ember
  */
  ControllerMixin['default'].reopen({
    concatenatedProperties: ["needs"],

    /**
      An array of other controller objects available inside
      instances of this controller via the `controllers`
      property:
       For example, when you define a controller:
       ```javascript
      App.CommentsController = Ember.ArrayController.extend({
        needs: ['post']
      });
      ```
       The application's single instance of these other
      controllers are accessible by name through the
      `controllers` property:
       ```javascript
      this.get('controllers.post'); // instance of App.PostController
      ```
       Given that you have a nested controller (nested resource):
       ```javascript
      App.CommentsNewController = Ember.ObjectController.extend({
      });
      ```
       When you define a controller that requires access to a nested one:
       ```javascript
      App.IndexController = Ember.ObjectController.extend({
        needs: ['commentsNew']
      });
      ```
       You will be able to get access to it:
       ```javascript
      this.get('controllers.commentsNew'); // instance of App.CommentsNewController
      ```
       This is only available for singleton controllers.
       @property {Array} needs
      @default []
    */
    needs: [],

    init: function () {
      var needs = property_get.get(this, "needs");
      var length = property_get.get(needs, "length");

      if (length > 0) {
        
        if (this.container) {
          verifyNeedsDependencies(this, this.container, needs);
        }

        // if needs then initialize controllers proxy
        property_get.get(this, "controllers");
      }

      this._super.apply(this, arguments);
    },

    /**
      @method controllerFor
      @see {Ember.Route#controllerFor}
      @deprecated Use `needs` instead
    */
    controllerFor: function (controllerName) {
            return controllerFor['default'](property_get.get(this, "container"), controllerName);
    },

    /**
      Stores the instances of other controllers available from within
      this controller. Any controller listed by name in the `needs`
      property will be accessible by name through this property.
       ```javascript
      App.CommentsController = Ember.ArrayController.extend({
        needs: ['post'],
        postTitle: function() {
          var currentPost = this.get('controllers.post'); // instance of App.PostController
          return currentPost.get('title');
        }.property('controllers.post.title')
      });
      ```
       @see {Ember.ControllerMixin#needs}
      @property {Object} controllers
      @default null
    */
    controllers: defaultControllersComputedProperty
  });

  exports['default'] = ControllerMixin['default'];

});
enifed('ember-application/system/application-instance', ['exports', 'ember-metal/property_get', 'ember-metal/property_set', 'ember-runtime/system/object', 'ember-metal/run_loop', 'ember-metal/computed', 'container/registry'], function (exports, property_get, property_set, EmberObject, run, computed, Registry) {

  'use strict';

  /**
  @module ember
  @submodule ember-application
  @private
  */

  exports['default'] = EmberObject['default'].extend({
    /**
      The application instance's container. The container stores all of the
      instance-specific state for this application run.
       @property {Ember.Container} container
    */
    container: null,

    /**
      The application's registry. The registry contains the classes, templates,
      and other code that makes up the application.
       @property {Ember.Registry} registry
    */
    applicationRegistry: null,

    /**
      The registry for this application instance. It should use the
      `applicationRegistry` as a fallback.
       @property {Ember.Registry} registry
    */
    registry: null,

    /**
      The DOM events for which the event dispatcher should listen.
       By default, the application's `Ember.EventDispatcher` listens
      for a set of standard DOM events, such as `mousedown` and
      `keyup`, and delegates them to your application's `Ember.View`
      instances.
       @private
      @property {Object} customEvents
    */
    customEvents: null,

    /**
      The root DOM element of the Application as an element or a
      [jQuery-compatible selector
      string](http://api.jquery.com/category/selectors/).
       @private
      @property {String|DOMElement} rootElement
    */
    rootElement: null,

    init: function () {
      this._super.apply(this, arguments);

      // Create a per-instance registry that will use the application's registry
      // as a fallback for resolving registrations.
      this.registry = new Registry['default']({
        fallback: this.applicationRegistry,
        resolver: this.applicationRegistry.resolver
      });
      this.registry.normalizeFullName = this.applicationRegistry.normalizeFullName;
      this.registry.makeToString = this.applicationRegistry.makeToString;

      // Create a per-instance container from the instance's registry
      this.container = this.registry.container();

      // Register this instance in the per-instance registry.
      //
      // Why do we need to register the instance in the first place?
      // Because we need a good way for the root route (a.k.a ApplicationRoute)
      // to notify us when it has created the root-most view. That view is then
      // appended to the rootElement, in the case of apps, to the fixture harness
      // in tests, or rendered to a string in the case of FastBoot.
      this.registry.register("-application-instance:main", this, { instantiate: false });
    },

    router: computed.computed(function () {
      return this.container.lookup("router:main");
    }).readOnly(),

    /**
      Instantiates and sets up the router, specifically overriding the default
      location. This is useful for manually starting the app in FastBoot or
      testing environments, where trying to modify the URL would be
      inappropriate.
       @param options
      @private
    */
    overrideRouterLocation: function (options) {
      var location = options && options.location;
      var router = property_get.get(this, "router");

      if (location) {
        property_set.set(router, "location", location);
      }
    },

    /**
      This hook is called by the root-most Route (a.k.a. the ApplicationRoute)
      when it has finished creating the root View. By default, we simply take the
      view and append it to the `rootElement` specified on the Application.
       In cases like FastBoot and testing, we can override this hook and implement
      custom behavior, such as serializing to a string and sending over an HTTP
      socket rather than appending to DOM.
       @param view {Ember.View} the root-most view
      @private
    */
    didCreateRootView: function (view) {
      view.appendTo(this.rootElement);
    },

    /**
      Tells the router to start routing. The router will ask the location for the
      current URL of the page to determine the initial URL to start routing to.
      To start the app at a specific URL, call `handleURL` instead.
       @private
    */
    startRouting: function () {
      var router = property_get.get(this, "router");
      var isModuleBasedResolver = !!this.registry.resolver.moduleBasedResolver;

      router.startRouting(isModuleBasedResolver);
      this._didSetupRouter = true;
    },

    /** @private
      Sets up the router, initializing the child router and configuring the
      location before routing begins.
       Because setup should only occur once, multiple calls to `setupRouter`
      beyond the first call have no effect.
    */
    setupRouter: function () {
      if (this._didSetupRouter) {
        return;
      }
      this._didSetupRouter = true;

      var router = property_get.get(this, "router");
      var isModuleBasedResolver = !!this.registry.resolver.moduleBasedResolver;
      router.setupRouter(isModuleBasedResolver);
    },

    /**
      Directs the router to route to a particular URL. This is useful in tests,
      for example, to tell the app to start at a particular URL. Ensure that you
      have called `setupRouter()` before calling this method.
       @param url {String} the URL the router should route to
      @private
    */
    handleURL: function (url) {
      var router = property_get.get(this, "router");

      this.setupRouter();
      return router.handleURL(url);
    },

    /**
      @private
    */
    setupEventDispatcher: function () {
      var dispatcher = this.container.lookup("event_dispatcher:main");
      dispatcher.setup(this.customEvents, this.rootElement);

      return dispatcher;
    },

    /**
      @private
    */
    willDestroy: function () {
      this._super.apply(this, arguments);
      run['default'](this.container, "destroy");
    }
  });

});
enifed('ember-application/system/application', ['exports', 'dag-map', 'container/registry', 'ember-metal', 'ember-metal/property_get', 'ember-metal/property_set', 'ember-runtime/system/lazy_load', 'ember-runtime/system/namespace', 'ember-runtime/mixins/deferred', 'ember-application/system/resolver', 'ember-metal/platform/create', 'ember-metal/run_loop', 'ember-metal/utils', 'ember-runtime/controllers/controller', 'ember-metal/enumerable_utils', 'ember-runtime/controllers/object_controller', 'ember-runtime/controllers/array_controller', 'ember-views/system/renderer', 'dom-helper', 'ember-views/views/select', 'ember-routing-views/views/outlet', 'ember-views/views/view', 'ember-views/views/metamorph_view', 'ember-views/system/event_dispatcher', 'ember-views/system/jquery', 'ember-routing/system/route', 'ember-routing/system/router', 'ember-routing/location/hash_location', 'ember-routing/location/history_location', 'ember-routing/location/auto_location', 'ember-routing/location/none_location', 'ember-routing/system/cache', 'ember-application/system/application-instance', 'ember-extension-support/container_debug_adapter', 'ember-metal/environment'], function (exports, DAG, Registry, Ember, property_get, property_set, lazy_load, Namespace, DeferredMixin, DefaultResolver, create, run, utils, Controller, EnumerableUtils, ObjectController, ArrayController, Renderer, DOMHelper, SelectView, outlet, EmberView, _MetamorphView, EventDispatcher, jQuery, Route, Router, HashLocation, HistoryLocation, AutoLocation, NoneLocation, BucketCache, ApplicationInstance, ContainerDebugAdapter, environment) {

  'use strict';

  /**
  @module ember
  @submodule ember-application
  */
  function props(obj) {
    var properties = [];

    for (var key in obj) {
      properties.push(key);
    }

    return properties;
  }

  var librariesRegistered = false;

  /**
    An instance of `Ember.Application` is the starting point for every Ember
    application. It helps to instantiate, initialize and coordinate the many
    objects that make up your app.

    Each Ember app has one and only one `Ember.Application` object. In fact, the
    very first thing you should do in your application is create the instance:

    ```javascript
    window.App = Ember.Application.create();
    ```

    Typically, the application object is the only global variable. All other
    classes in your app should be properties on the `Ember.Application` instance,
    which highlights its first role: a global namespace.

    For example, if you define a view class, it might look like this:

    ```javascript
    App.MyView = Ember.View.extend();
    ```

    By default, calling `Ember.Application.create()` will automatically initialize
    your application by calling the `Ember.Application.initialize()` method. If
    you need to delay initialization, you can call your app's `deferReadiness()`
    method. When you are ready for your app to be initialized, call its
    `advanceReadiness()` method.

    You can define a `ready` method on the `Ember.Application` instance, which
    will be run by Ember when the application is initialized.

    Because `Ember.Application` inherits from `Ember.Namespace`, any classes
    you create will have useful string representations when calling `toString()`.
    See the `Ember.Namespace` documentation for more information.

    While you can think of your `Ember.Application` as a container that holds the
    other classes in your application, there are several other responsibilities
    going on under-the-hood that you may want to understand.

    ### Event Delegation

    Ember uses a technique called _event delegation_. This allows the framework
    to set up a global, shared event listener instead of requiring each view to
    do it manually. For example, instead of each view registering its own
    `mousedown` listener on its associated element, Ember sets up a `mousedown`
    listener on the `body`.

    If a `mousedown` event occurs, Ember will look at the target of the event and
    start walking up the DOM node tree, finding corresponding views and invoking
    their `mouseDown` method as it goes.

    `Ember.Application` has a number of default events that it listens for, as
    well as a mapping from lowercase events to camel-cased view method names. For
    example, the `keypress` event causes the `keyPress` method on the view to be
    called, the `dblclick` event causes `doubleClick` to be called, and so on.

    If there is a bubbling browser event that Ember does not listen for by
    default, you can specify custom events and their corresponding view method
    names by setting the application's `customEvents` property:

    ```javascript
    var App = Ember.Application.create({
      customEvents: {
        // add support for the paste event
        paste: 'paste'
      }
    });
    ```

    By default, the application sets up these event listeners on the document
    body. However, in cases where you are embedding an Ember application inside
    an existing page, you may want it to set up the listeners on an element
    inside the body.

    For example, if only events inside a DOM element with the ID of `ember-app`
    should be delegated, set your application's `rootElement` property:

    ```javascript
    var App = Ember.Application.create({
      rootElement: '#ember-app'
    });
    ```

    The `rootElement` can be either a DOM element or a jQuery-compatible selector
    string. Note that *views appended to the DOM outside the root element will
    not receive events.* If you specify a custom root element, make sure you only
    append views inside it!

    To learn more about the advantages of event delegation and the Ember view
    layer, and a list of the event listeners that are setup by default, visit the
    [Ember View Layer guide](http://emberjs.com/guides/understanding-ember/the-view-layer/#toc_event-delegation).

    ### Initializers

    Libraries on top of Ember can add initializers, like so:

    ```javascript
    Ember.Application.initializer({
      name: 'api-adapter',

      initialize: function(container, application) {
        application.register('api-adapter:main', ApiAdapter);
      }
    });
    ```

    Initializers provide an opportunity to access the container, which
    organizes the different components of an Ember application. Additionally
    they provide a chance to access the instantiated application. Beyond
    being used for libraries, initializers are also a great way to organize
    dependency injection or setup in your own application.

    ### Routing

    In addition to creating your application's router, `Ember.Application` is
    also responsible for telling the router when to start routing. Transitions
    between routes can be logged with the `LOG_TRANSITIONS` flag, and more
    detailed intra-transition logging can be logged with
    the `LOG_TRANSITIONS_INTERNAL` flag:

    ```javascript
    var App = Ember.Application.create({
      LOG_TRANSITIONS: true, // basic logging of successful transitions
      LOG_TRANSITIONS_INTERNAL: true // detailed logging of all routing steps
    });
    ```

    By default, the router will begin trying to translate the current URL into
    application state once the browser emits the `DOMContentReady` event. If you
    need to defer routing, you can call the application's `deferReadiness()`
    method. Once routing can begin, call the `advanceReadiness()` method.

    If there is any setup required before routing begins, you can implement a
    `ready()` method on your app that will be invoked immediately before routing
    begins.

    @class Application
    @namespace Ember
    @extends Ember.Namespace
  */

  var Application = Namespace['default'].extend(DeferredMixin['default'], {
    _suppressDeferredDeprecation: true,

    /**
      The root DOM element of the Application. This can be specified as an
      element or a
      [jQuery-compatible selector string](http://api.jquery.com/category/selectors/).
       This is the element that will be passed to the Application's,
      `eventDispatcher`, which sets up the listeners for event delegation. Every
      view in your application should be a child of the element you specify here.
       @property rootElement
      @type DOMElement
      @default 'body'
    */
    rootElement: 'body',

    /**
      The `Ember.EventDispatcher` responsible for delegating events to this
      application's views.
       The event dispatcher is created by the application at initialization time
      and sets up event listeners on the DOM element described by the
      application's `rootElement` property.
       See the documentation for `Ember.EventDispatcher` for more information.
       @property eventDispatcher
      @type Ember.EventDispatcher
      @default null
    */
    eventDispatcher: null,

    /**
      The DOM events for which the event dispatcher should listen.
       By default, the application's `Ember.EventDispatcher` listens
      for a set of standard DOM events, such as `mousedown` and
      `keyup`, and delegates them to your application's `Ember.View`
      instances.
       If you would like additional bubbling events to be delegated to your
      views, set your `Ember.Application`'s `customEvents` property
      to a hash containing the DOM event name as the key and the
      corresponding view method name as the value. For example:
       ```javascript
      var App = Ember.Application.create({
        customEvents: {
          // add support for the paste event
          paste: 'paste'
        }
      });
      ```
       @property customEvents
      @type Object
      @default null
    */
    customEvents: null,

    /**
      Whether the application should automatically start routing and render
      templates to the `rootElement` on DOM ready. While default by true,
      other environments such as FastBoot or a testing harness can set this
      property to `false` and control the precise timing and behavior of the boot
      process.
       @property autoboot
      @type Boolean
      @default true
      @private
    */
    autoboot: true,

    init: function () {
      this._super.apply(this, arguments);

      if (!this.$) {
        this.$ = jQuery['default'];
      }

      this.buildRegistry();

      registerLibraries();
      logLibraryVersions();

      // Start off the number of deferrals at 1. This will be
      // decremented by the Application's own `initialize` method.
      this._readinessDeferrals = 1;

      
        this.Router = (this.Router || Router['default']).extend();
        this.waitForDOMReady(this.buildDefaultInstance());
      
    },

    /**
      Build and configure the registry for the current application.
       @private
      @method buildRegistry
      @return {Ember.Registry} the configured registry
    */
    buildRegistry: function () {
      var registry = this.registry = Application.buildRegistry(this);

      return registry;
    },

    /**
      Create a container for the current application's registry.
       @private
      @method buildInstance
      @return {Ember.Container} the configured container
    */
    buildInstance: function () {
      return ApplicationInstance['default'].create({
        customEvents: property_get.get(this, 'customEvents'),
        rootElement: property_get.get(this, 'rootElement'),
        applicationRegistry: this.registry
      });
    },

    buildDefaultInstance: function () {
      var instance = this.buildInstance();

      // For the default instance only, set the view registry to the global
      // Ember.View.views hash for backwards-compatibility.
      EmberView['default'].views = instance.container.lookup('-view-registry:main');

      // TODO2.0: Legacy support for App.__container__
      // and global methods on App that rely on a single,
      // default instance.
      this.__deprecatedInstance__ = instance;
      this.__container__ = instance.container;

      return instance;
    },

    /**
      Automatically initialize the application once the DOM has
      become ready.
       The initialization itself is scheduled on the actions queue
      which ensures that application loading finishes before
      booting.
       If you are asynchronously loading code, you should call
      `deferReadiness()` to defer booting, and then call
      `advanceReadiness()` once all of your code has finished
      loading.
       @private
      @method scheduleInitialize
    */
    waitForDOMReady: function (_instance) {
      if (!this.$ || this.$.isReady) {
        run['default'].schedule('actions', this, 'domReady', _instance);
      } else {
        this.$().ready(run['default'].bind(this, 'domReady', _instance));
      }
    },

    /**
      Use this to defer readiness until some condition is true.
       Example:
       ```javascript
      var App = Ember.Application.create();
       App.deferReadiness();
       // Ember.$ is a reference to the jQuery object/function
      Ember.$.getJSON('/auth-token', function(token) {
        App.token = token;
        App.advanceReadiness();
      });
      ```
       This allows you to perform asynchronous setup logic and defer
      booting your application until the setup has finished.
       However, if the setup requires a loading UI, it might be better
      to use the router for this purpose.
       @method deferReadiness
    */
    deferReadiness: function () {
                  this._readinessDeferrals++;
    },

    /**
      Call `advanceReadiness` after any asynchronous setup logic has completed.
      Each call to `deferReadiness` must be matched by a call to `advanceReadiness`
      or the application will never become ready and routing will not begin.
       @method advanceReadiness
      @see {Ember.Application#deferReadiness}
    */
    advanceReadiness: function () {
            this._readinessDeferrals--;

      if (this._readinessDeferrals === 0) {
        run['default'].once(this, this.didBecomeReady);
      }
    },

    /**
      Registers a factory that can be used for dependency injection (with
      `App.inject`) or for service lookup. Each factory is registered with
      a full name including two parts: `type:name`.
       A simple example:
       ```javascript
      var App = Ember.Application.create();
       App.Orange = Ember.Object.extend();
      App.register('fruit:favorite', App.Orange);
      ```
       Ember will resolve factories from the `App` namespace automatically.
      For example `App.CarsController` will be discovered and returned if
      an application requests `controller:cars`.
       An example of registering a controller with a non-standard name:
       ```javascript
      var App = Ember.Application.create();
      var Session = Ember.Controller.extend();
       App.register('controller:session', Session);
       // The Session controller can now be treated like a normal controller,
      // despite its non-standard name.
      App.ApplicationController = Ember.Controller.extend({
        needs: ['session']
      });
      ```
       Registered factories are **instantiated** by having `create`
      called on them. Additionally they are **singletons**, each time
      they are looked up they return the same instance.
       Some examples modifying that default behavior:
       ```javascript
      var App = Ember.Application.create();
       App.Person = Ember.Object.extend();
      App.Orange = Ember.Object.extend();
      App.Email = Ember.Object.extend();
      App.session = Ember.Object.create();
       App.register('model:user', App.Person, { singleton: false });
      App.register('fruit:favorite', App.Orange);
      App.register('communication:main', App.Email, { singleton: false });
      App.register('session', App.session, { instantiate: false });
      ```
       @method register
      @param  fullName {String} type:name (e.g., 'model:user')
      @param  factory {Function} (e.g., App.Person)
      @param  options {Object} (optional) disable instantiation or singleton usage
    **/
    register: function () {
      var _registry;

      (_registry = this.registry).register.apply(_registry, arguments);
    },

    /**
      Define a dependency injection onto a specific factory or all factories
      of a type.
       When Ember instantiates a controller, view, or other framework component
      it can attach a dependency to that component. This is often used to
      provide services to a set of framework components.
       An example of providing a session object to all controllers:
       ```javascript
      var App = Ember.Application.create();
      var Session = Ember.Object.extend({ isAuthenticated: false });
       // A factory must be registered before it can be injected
      App.register('session:main', Session);
       // Inject 'session:main' onto all factories of the type 'controller'
      // with the name 'session'
      App.inject('controller', 'session', 'session:main');
       App.IndexController = Ember.Controller.extend({
        isLoggedIn: Ember.computed.alias('session.isAuthenticated')
      });
      ```
       Injections can also be performed on specific factories.
       ```javascript
      App.inject(<full_name or type>, <property name>, <full_name>)
      App.inject('route', 'source', 'source:main')
      App.inject('route:application', 'email', 'model:email')
      ```
       It is important to note that injections can only be performed on
      classes that are instantiated by Ember itself. Instantiating a class
      directly (via `create` or `new`) bypasses the dependency injection
      system.
       **Note:** Ember-Data instantiates its models in a unique manner, and consequently
      injections onto models (or all models) will not work as expected. Injections
      on models can be enabled by setting `Ember.MODEL_FACTORY_INJECTIONS`
      to `true`.
       @method inject
      @param  factoryNameOrType {String}
      @param  property {String}
      @param  injectionName {String}
    **/
    inject: function () {
      var _registry2;

      (_registry2 = this.registry).injection.apply(_registry2, arguments);
    },

    /**
      Calling initialize manually is not supported.
       Please see Ember.Application#advanceReadiness and
      Ember.Application#deferReadiness.
       @private
      @deprecated
      @method initialize
     **/
    initialize: function () {
          },

    /**
      Initialize the application. This happens automatically.
       Run any initializers and run the application load hook. These hooks may
      choose to defer readiness. For example, an authentication hook might want
      to defer readiness until the auth token has been retrieved.
       @private
      @method _initialize
    */
    domReady: function (_instance) {
      if (this.isDestroyed) {
        return;
      }

      var app = this;

      this.boot().then(function () {
        app.runInstanceInitializers(_instance);
      });

      return this;
    },

    boot: function () {
      if (this._bootPromise) {
        return this._bootPromise;
      }

      var defer = new Ember['default'].RSVP.defer();
      this._bootPromise = defer.promise;
      this._bootResolver = defer;

      this.runInitializers(this.registry);
      lazy_load.runLoadHooks('application', this);

      this.advanceReadiness();

      return this._bootPromise;
    },

    /**
      Reset the application. This is typically used only in tests. It cleans up
      the application in the following order:
       1. Deactivate existing routes
      2. Destroy all objects in the container
      3. Create a new application container
      4. Re-route to the existing url
       Typical Example:
       ```javascript
      var App;
       run(function() {
        App = Ember.Application.create();
      });
       module('acceptance test', {
        setup: function() {
          App.reset();
        }
      });
       test('first test', function() {
        // App is freshly reset
      });
       test('second test', function() {
        // App is again freshly reset
      });
      ```
       Advanced Example:
       Occasionally you may want to prevent the app from initializing during
      setup. This could enable extra configuration, or enable asserting prior
      to the app becoming ready.
       ```javascript
      var App;
       run(function() {
        App = Ember.Application.create();
      });
       module('acceptance test', {
        setup: function() {
          run(function() {
            App.reset();
            App.deferReadiness();
          });
        }
      });
       test('first test', function() {
        ok(true, 'something before app is initialized');
         run(function() {
          App.advanceReadiness();
        });
         ok(true, 'something after app is initialized');
      });
      ```
       @method reset
    **/
    reset: function () {
      var instance = this.__deprecatedInstance__;

      this._readinessDeferrals = 1;
      this._bootPromise = null;
      this._bootResolver = null;

      function handleReset() {
        run['default'](instance, 'destroy');

        this.buildDefaultInstance();

        run['default'].schedule('actions', this, 'domReady');
      }

      run['default'].join(this, handleReset);
    },

    /**
      @private
      @method runInitializers
    */
    runInitializers: function (registry) {
      var App = this;
      this._runInitializer('initializers', function (name, initializer) {
        
        
          initializer.initialize(registry, App);
              });
    },

    runInstanceInitializers: function (instance) {
      this._runInitializer('instanceInitializers', function (name, initializer) {
                initializer.initialize(instance);
      });
    },

    _runInitializer: function (bucketName, cb) {
      var initializersByName = property_get.get(this.constructor, bucketName);
      var initializers = props(initializersByName);
      var graph = new DAG['default']();
      var initializer;

      for (var i = 0; i < initializers.length; i++) {
        initializer = initializersByName[initializers[i]];
        graph.addEdges(initializer.name, initializer, initializer.before, initializer.after);
      }

      graph.topsort(function (vertex) {
        cb(vertex.name, vertex.value);
      });
    },

    /**
      @private
      @method didBecomeReady
    */
    didBecomeReady: function () {
      if (this.autoboot) {
        if (environment['default'].hasDOM) {
          this.__deprecatedInstance__.setupEventDispatcher();
        }

        this.ready(); // user hook
        this.__deprecatedInstance__.startRouting();

        if (!Ember['default'].testing) {
          // Eagerly name all classes that are already loaded
          Ember['default'].Namespace.processAll();
          Ember['default'].BOOTED = true;
        }

        this.resolve(this);
      }

      this._bootResolver.resolve();
    },

    /**
      Called when the Application has become ready.
      The call will be delayed until the DOM has become ready.
       @event ready
    */
    ready: function () {
      return this;
    },

    /**
      @deprecated Use 'Resolver' instead
      Set this to provide an alternate class to `Ember.DefaultResolver`
        @property resolver
    */
    resolver: null,

    /**
      Set this to provide an alternate class to `Ember.DefaultResolver`
       @property resolver
    */
    Resolver: null,

    // This method must be moved to the application instance object
    willDestroy: function () {
      this._super.apply(this, arguments);
      Ember['default'].BOOTED = false;
      this._bootPromise = null;
      this._bootResolver = null;
      this.__deprecatedInstance__.destroy();
    },

    initializer: function (options) {
      this.constructor.initializer(options);
    },

    /**
      @method then
      @private
      @deprecated
    */
    then: function () {
      
      this._super.apply(this, arguments);
    }
  });

  
    Application.reopen({
      instanceInitializer: function (options) {
        this.constructor.instanceInitializer(options);
      }
    });

    Application.reopenClass({
      instanceInitializer: buildInitializerMethod('instanceInitializers', 'instance initializer')
    });
  

  
  Application.reopenClass({
    initializers: create['default'](null),
    instanceInitializers: create['default'](null),

    /**
      Initializer receives an object which has the following attributes:
      `name`, `before`, `after`, `initialize`. The only required attribute is
      `initialize`, all others are optional.
       * `name` allows you to specify under which name the initializer is registered.
      This must be a unique name, as trying to register two initializers with the
      same name will result in an error.
       ```javascript
      Ember.Application.initializer({
        name: 'namedInitializer',
         initialize: function(container, application) {
          Ember.debug('Running namedInitializer!');
        }
      });
      ```
       * `before` and `after` are used to ensure that this initializer is ran prior
      or after the one identified by the value. This value can be a single string
      or an array of strings, referencing the `name` of other initializers.
       An example of ordering initializers, we create an initializer named `first`:
       ```javascript
      Ember.Application.initializer({
        name: 'first',
         initialize: function(container, application) {
          Ember.debug('First initializer!');
        }
      });
       // DEBUG: First initializer!
      ```
       We add another initializer named `second`, specifying that it should run
      after the initializer named `first`:
       ```javascript
      Ember.Application.initializer({
        name: 'second',
        after: 'first',
         initialize: function(container, application) {
          Ember.debug('Second initializer!');
        }
      });
       // DEBUG: First initializer!
      // DEBUG: Second initializer!
      ```
       Afterwards we add a further initializer named `pre`, this time specifying
      that it should run before the initializer named `first`:
       ```javascript
      Ember.Application.initializer({
        name: 'pre',
        before: 'first',
         initialize: function(container, application) {
          Ember.debug('Pre initializer!');
        }
      });
       // DEBUG: Pre initializer!
      // DEBUG: First initializer!
      // DEBUG: Second initializer!
      ```
       Finally we add an initializer named `post`, specifying it should run after
      both the `first` and the `second` initializers:
       ```javascript
      Ember.Application.initializer({
        name: 'post',
        after: ['first', 'second'],
         initialize: function(container, application) {
          Ember.debug('Post initializer!');
        }
      });
       // DEBUG: Pre initializer!
      // DEBUG: First initializer!
      // DEBUG: Second initializer!
      // DEBUG: Post initializer!
      ```
       * `initialize` is a callback function that receives two arguments, `container`
      and `application` on which you can operate.
       Example of using `container` to preload data into the store:
       ```javascript
      Ember.Application.initializer({
        name: 'preload-data',
         initialize: function(container, application) {
          var store = container.lookup('store:main');
           store.pushPayload(preloadedData);
        }
      });
      ```
       Example of using `application` to register an adapter:
       ```javascript
      Ember.Application.initializer({
        name: 'api-adapter',
         initialize: function(container, application) {
          application.register('api-adapter:main', ApiAdapter);
        }
      });
      ```
       @method initializer
      @param initializer {Object}
     */
    initializer: buildInitializerMethod('initializers', 'initializer'),

    /**
      This creates a registry with the default Ember naming conventions.
       It also configures the registry:
       * registered views are created every time they are looked up (they are
        not singletons)
      * registered templates are not factories; the registered value is
        returned directly.
      * the router receives the application as its `namespace` property
      * all controllers receive the router as their `target` and `controllers`
        properties
      * all controllers receive the application as their `namespace` property
      * the application view receives the application controller as its
        `controller` property
      * the application view receives the application template as its
        `defaultTemplate` property
       @private
      @method buildRegistry
      @static
      @param {Ember.Application} namespace the application for which to
        build the registry
      @return {Ember.Registry} the built registry
    */
    buildRegistry: function (namespace) {
      var registry = new Registry['default']();

      registry.set = property_set.set;
      registry.resolver = resolverFor(namespace);
      registry.normalizeFullName = registry.resolver.normalize;
      registry.describe = registry.resolver.describe;
      registry.makeToString = registry.resolver.makeToString;

      registry.optionsForType('component', { singleton: false });
      registry.optionsForType('view', { singleton: false });
      registry.optionsForType('template', { instantiate: false });
      registry.optionsForType('helper', { instantiate: false });

      registry.register('application:main', namespace, { instantiate: false });

      registry.register('controller:basic', Controller['default'], { instantiate: false });
      registry.register('controller:object', ObjectController['default'], { instantiate: false });
      registry.register('controller:array', ArrayController['default'], { instantiate: false });

      registry.register('renderer:-dom', { create: function () {
          return new Renderer['default'](new DOMHelper['default']());
        } });

      registry.injection('view', 'renderer', 'renderer:-dom');
      registry.register('view:select', SelectView['default']);
      registry.register('view:-outlet', outlet.OutletView);

      registry.register('-view-registry:main', { create: function () {
          return {};
        } });

      registry.injection('view', '_viewRegistry', '-view-registry:main');

      registry.register('view:default', _MetamorphView['default']);
      registry.register('view:toplevel', EmberView['default'].extend());

      registry.register('route:basic', Route['default'], { instantiate: false });
      registry.register('event_dispatcher:main', EventDispatcher['default']);

      registry.injection('router:main', 'namespace', 'application:main');
      registry.injection('view:-outlet', 'namespace', 'application:main');

      registry.register('location:auto', AutoLocation['default']);
      registry.register('location:hash', HashLocation['default']);
      registry.register('location:history', HistoryLocation['default']);
      registry.register('location:none', NoneLocation['default']);

      registry.injection('controller', 'target', 'router:main');
      registry.injection('controller', 'namespace', 'application:main');

      registry.register('-bucket-cache:main', BucketCache['default']);
      registry.injection('router', '_bucketCache', '-bucket-cache:main');
      registry.injection('route', '_bucketCache', '-bucket-cache:main');
      registry.injection('controller', '_bucketCache', '-bucket-cache:main');

      registry.injection('route', 'router', 'router:main');

      // DEBUGGING
      registry.register('resolver-for-debugging:main', registry.resolver.__resolver__, { instantiate: false });
      registry.injection('container-debug-adapter:main', 'resolver', 'resolver-for-debugging:main');
      registry.injection('data-adapter:main', 'containerDebugAdapter', 'container-debug-adapter:main');
      // Custom resolver authors may want to register their own ContainerDebugAdapter with this key

      registry.register('container-debug-adapter:main', ContainerDebugAdapter['default']);

      return registry;
    }
  });

  /**
    This function defines the default lookup rules for container lookups:

    * templates are looked up on `Ember.TEMPLATES`
    * other names are looked up on the application after classifying the name.
      For example, `controller:post` looks up `App.PostController` by default.
    * if the default lookup fails, look for registered classes on the container

    This allows the application to register default injections in the container
    that could be overridden by the normal naming convention.

    @private
    @method resolverFor
    @param {Ember.Namespace} namespace the namespace to look for classes
    @return {*} the resolved value for a given lookup
  */
  function resolverFor(namespace) {
    
    var ResolverClass = namespace.get('resolver') || namespace.get('Resolver') || DefaultResolver['default'];
    var resolver = ResolverClass.create({
      namespace: namespace
    });

    function resolve(fullName) {
      return resolver.resolve(fullName);
    }

    resolve.describe = function (fullName) {
      return resolver.lookupDescription(fullName);
    };

    resolve.makeToString = function (factory, fullName) {
      return resolver.makeToString(factory, fullName);
    };

    resolve.normalize = function (fullName) {
      if (resolver.normalize) {
        return resolver.normalize(fullName);
      } else {
                return fullName;
      }
    };

    resolve.__resolver__ = resolver;

    return resolve;
  }

  function registerLibraries() {
    if (!librariesRegistered) {
      librariesRegistered = true;

      if (environment['default'].hasDOM) {
        Ember['default'].libraries.registerCoreLibrary('jQuery', jQuery['default']().jquery);
      }
    }
  }

  function logLibraryVersions() {
    if (Ember['default'].LOG_VERSION) {
      // we only need to see this once per Application#init
      Ember['default'].LOG_VERSION = false;
      var libs = Ember['default'].libraries._registry;

      var nameLengths = EnumerableUtils['default'].map(libs, function (item) {
        return property_get.get(item, 'name.length');
      });

      var maxNameLength = Math.max.apply(this, nameLengths);

            for (var i = 0, l = libs.length; i < l; i++) {
        var lib = libs[i];
        var spaces = new Array(maxNameLength - lib.name.length + 1).join(' ');
              }
          }
  }

  function buildInitializerMethod(bucketName, humanName) {
    return function (initializer) {
      // If this is the first initializer being added to a subclass, we are going to reopen the class
      // to make sure we have a new `initializers` object, which extends from the parent class' using
      // prototypal inheritance. Without this, attempting to add initializers to the subclass would
      // pollute the parent class as well as other subclasses.
      if (this.superclass[bucketName] !== undefined && this.superclass[bucketName] === this[bucketName]) {
        var attrs = {};
        attrs[bucketName] = create['default'](this[bucketName]);
        this.reopenClass(attrs);
      }

                  
      this[bucketName][initializer.name] = initializer;
    };
  }

  exports['default'] = Application;

});
enifed('ember-application/system/resolver', ['exports', 'ember-metal/core', 'ember-metal/property_get', 'ember-metal/logger', 'ember-runtime/system/string', 'ember-runtime/system/object', 'ember-runtime/system/namespace', 'ember-htmlbars/helpers', 'ember-metal/dictionary'], function (exports, Ember, property_get, Logger, string, EmberObject, Namespace, helpers, dictionary) {

  'use strict';

  /**
  @module ember
  @submodule ember-application
  */

  var Resolver = EmberObject['default'].extend({
    /**
      This will be set to the Application instance when it is
      created.
       @property namespace
    */
    namespace: null,
    normalize: null, // required
    resolve: null, // required
    parseName: null, // required
    lookupDescription: null, // required
    makeToString: null, // required
    resolveOther: null, // required
    _logLookup: null // required
  });exports['default'] = EmberObject['default'].extend({
    /**
      This will be set to the Application instance when it is
      created.
       @property namespace
    */
    namespace: null,

    init: function () {
      this._parseNameCache = dictionary['default'](null);
    },
    normalize: function (fullName) {
      var _fullName$split = fullName.split(':', 2);

      var type = _fullName$split[0];
      var name = _fullName$split[1];

      
      if (type !== 'template') {
        var result = name;

        if (result.indexOf('.') > -1) {
          result = result.replace(/\.(.)/g, function (m) {
            return m.charAt(1).toUpperCase();
          });
        }

        if (name.indexOf('_') > -1) {
          result = result.replace(/_(.)/g, function (m) {
            return m.charAt(1).toUpperCase();
          });
        }

        return type + ':' + result;
      } else {
        return fullName;
      }
    },

    /**
      This method is called via the container's resolver method.
      It parses the provided `fullName` and then looks up and
      returns the appropriate template or class.
       @method resolve
      @param {String} fullName the lookup string
      @return {Object} the resolved factory
    */
    resolve: function (fullName) {
      var parsedName = this.parseName(fullName);
      var resolveMethodName = parsedName.resolveMethodName;
      var resolved;

      if (this[resolveMethodName]) {
        resolved = this[resolveMethodName](parsedName);
      }

      resolved = resolved || this.resolveOther(parsedName);

      if (parsedName.root && parsedName.root.LOG_RESOLVER) {
        this._logLookup(resolved, parsedName);
      }

      return resolved;
    },

    /**
      Convert the string name of the form 'type:name' to
      a Javascript object with the parsed aspects of the name
      broken out.
       @protected
      @param {String} fullName the lookup string
      @method parseName
    */

    parseName: function (fullName) {
      return this._parseNameCache[fullName] || (this._parseNameCache[fullName] = this._parseName(fullName));
    },

    _parseName: function (fullName) {
      var _fullName$split2 = fullName.split(':');

      var type = _fullName$split2[0];
      var fullNameWithoutType = _fullName$split2[1];

      var name = fullNameWithoutType;
      var namespace = property_get.get(this, 'namespace');
      var root = namespace;

      if (type !== 'template' && name.indexOf('/') !== -1) {
        var parts = name.split('/');
        name = parts[parts.length - 1];
        var namespaceName = string.capitalize(parts.slice(0, -1).join('.'));
        root = Namespace['default'].byName(namespaceName);

              }

      var resolveMethodName = fullNameWithoutType === 'main' ? 'Main' : string.classify(type);

      if (!(name && type)) {
        throw new TypeError('Invalid fullName: `' + fullName + '`, must be of the form `type:name` ');
      }

      return {
        fullName: fullName,
        type: type,
        fullNameWithoutType: fullNameWithoutType,
        name: name,
        root: root,
        resolveMethodName: 'resolve' + resolveMethodName
      };
    },

    /**
      Returns a human-readable description for a fullName. Used by the
      Application namespace in assertions to describe the
      precise name of the class that Ember is looking for, rather than
      container keys.
       @protected
      @param {String} fullName the lookup string
      @method lookupDescription
    */
    lookupDescription: function (fullName) {
      var parsedName = this.parseName(fullName);
      var description;

      if (parsedName.type === 'template') {
        return 'template at ' + parsedName.fullNameWithoutType.replace(/\./g, '/');
      }

      description = parsedName.root + '.' + string.classify(parsedName.name).replace(/\./g, '');

      if (parsedName.type !== 'model') {
        description += string.classify(parsedName.type);
      }

      return description;
    },

    makeToString: function (factory, fullName) {
      return factory.toString();
    },

    /**
      Given a parseName object (output from `parseName`), apply
      the conventions expected by `Ember.Router`
       @protected
      @param {Object} parsedName a parseName object with the parsed
        fullName lookup string
      @method useRouterNaming
    */
    useRouterNaming: function (parsedName) {
      parsedName.name = parsedName.name.replace(/\./g, '_');
      if (parsedName.name === 'basic') {
        parsedName.name = '';
      }
    },
    /**
      Look up the template in Ember.TEMPLATES
       @protected
      @param {Object} parsedName a parseName object with the parsed
        fullName lookup string
      @method resolveTemplate
    */
    resolveTemplate: function (parsedName) {
      var templateName = parsedName.fullNameWithoutType.replace(/\./g, '/');

      if (Ember['default'].TEMPLATES[templateName]) {
        return Ember['default'].TEMPLATES[templateName];
      }

      templateName = string.decamelize(templateName);
      if (Ember['default'].TEMPLATES[templateName]) {
        return Ember['default'].TEMPLATES[templateName];
      }
    },

    /**
      Lookup the view using `resolveOther`
       @protected
      @param {Object} parsedName a parseName object with the parsed
        fullName lookup string
      @method resolveView
    */
    resolveView: function (parsedName) {
      this.useRouterNaming(parsedName);
      return this.resolveOther(parsedName);
    },

    /**
      Lookup the controller using `resolveOther`
       @protected
      @param {Object} parsedName a parseName object with the parsed
        fullName lookup string
      @method resolveController
    */
    resolveController: function (parsedName) {
      this.useRouterNaming(parsedName);
      return this.resolveOther(parsedName);
    },
    /**
      Lookup the route using `resolveOther`
       @protected
      @param {Object} parsedName a parseName object with the parsed
        fullName lookup string
      @method resolveRoute
    */
    resolveRoute: function (parsedName) {
      this.useRouterNaming(parsedName);
      return this.resolveOther(parsedName);
    },

    /**
      Lookup the model on the Application namespace
       @protected
      @param {Object} parsedName a parseName object with the parsed
        fullName lookup string
      @method resolveModel
    */
    resolveModel: function (parsedName) {
      var className = string.classify(parsedName.name);
      var factory = property_get.get(parsedName.root, className);

      if (factory) {
        return factory;
      }
    },
    /**
      Look up the specified object (from parsedName) on the appropriate
      namespace (usually on the Application)
       @protected
      @param {Object} parsedName a parseName object with the parsed
        fullName lookup string
      @method resolveHelper
    */
    resolveHelper: function (parsedName) {
      return this.resolveOther(parsedName) || helpers['default'][parsedName.fullNameWithoutType];
    },
    /**
      Look up the specified object (from parsedName) on the appropriate
      namespace (usually on the Application)
       @protected
      @param {Object} parsedName a parseName object with the parsed
        fullName lookup string
      @method resolveOther
    */
    resolveOther: function (parsedName) {
      var className = string.classify(parsedName.name) + string.classify(parsedName.type);
      var factory = property_get.get(parsedName.root, className);
      if (factory) {
        return factory;
      }
    },

    resolveMain: function (parsedName) {
      var className = string.classify(parsedName.type);
      return property_get.get(parsedName.root, className);
    },

    /**
     @method _logLookup
     @param {Boolean} found
     @param {Object} parsedName
     @private
    */
    _logLookup: function (found, parsedName) {
      var symbol, padding;

      if (found) {
        symbol = '[✓]';
      } else {
        symbol = '[ ]';
      }

      if (parsedName.fullName.length > 60) {
        padding = '.';
      } else {
        padding = new Array(60 - parsedName.fullName.length).join('.');
      }

      Logger['default'].info(symbol, parsedName.fullName, padding, this.lookupDescription(parsedName.fullName));
    }
  });

  exports.Resolver = Resolver;

});
enifed('ember-extension-support', ['ember-metal/core', 'ember-extension-support/data_adapter', 'ember-extension-support/container_debug_adapter'], function (Ember, DataAdapter, ContainerDebugAdapter) {

	'use strict';

	/**
	Ember Extension Support

	@module ember
	@submodule ember-extension-support
	@requires ember-application
	*/

	Ember['default'].DataAdapter = DataAdapter['default'];
	Ember['default'].ContainerDebugAdapter = ContainerDebugAdapter['default'];

});
enifed('ember-extension-support/container_debug_adapter', ['exports', 'ember-metal/core', 'ember-runtime/system/native_array', 'ember-metal/utils', 'ember-runtime/system/string', 'ember-runtime/system/namespace', 'ember-runtime/system/object'], function (exports, Ember, native_array, utils, string, Namespace, EmberObject) {

  'use strict';

  exports['default'] = EmberObject['default'].extend({
    /**
      The container of the application being debugged.
      This property will be injected
      on creation.
       @property container
      @default null
    */
    container: null,

    /**
      The resolver instance of the application
      being debugged. This property will be injected
      on creation.
       @property resolver
      @default null
    */
    resolver: null,

    /**
      Returns true if it is possible to catalog a list of available
      classes in the resolver for a given type.
       @method canCatalogEntriesByType
      @param {String} type The type. e.g. "model", "controller", "route"
      @return {boolean} whether a list is available for this type.
    */
    canCatalogEntriesByType: function (type) {
      if (type === "model" || type === "template") {
        return false;
      }

      return true;
    },

    /**
      Returns the available classes a given type.
       @method catalogEntriesByType
      @param {String} type The type. e.g. "model", "controller", "route"
      @return {Array} An array of strings.
    */
    catalogEntriesByType: function (type) {
      var namespaces = native_array.A(Namespace['default'].NAMESPACES);
      var types = native_array.A();
      var typeSuffixRegex = new RegExp(string.classify(type) + "$");

      namespaces.forEach(function (namespace) {
        if (namespace !== Ember['default']) {
          for (var key in namespace) {
            if (!namespace.hasOwnProperty(key)) {
              continue;
            }
            if (typeSuffixRegex.test(key)) {
              var klass = namespace[key];
              if (utils.typeOf(klass) === "class") {
                types.push(string.dasherize(key.replace(typeSuffixRegex, "")));
              }
            }
          }
        }
      });
      return types;
    }
  });

});
enifed('ember-extension-support/data_adapter', ['exports', 'ember-metal/property_get', 'ember-metal/run_loop', 'ember-runtime/system/string', 'ember-runtime/system/namespace', 'ember-runtime/system/object', 'ember-runtime/system/native_array', 'ember-application/system/application'], function (exports, property_get, run, string, Namespace, EmberObject, native_array, Application) {

  'use strict';

  exports['default'] = EmberObject['default'].extend({
    init: function () {
      this._super.apply(this, arguments);
      this.releaseMethods = native_array.A();
    },

    /**
      The container of the application being debugged.
      This property will be injected
      on creation.
       @property container
      @default null
      @since 1.3.0
    */
    container: null,

    /**
      The container-debug-adapter which is used
      to list all models.
       @property containerDebugAdapter
      @default undefined
      @since 1.5.0
    **/
    containerDebugAdapter: undefined,

    /**
      Number of attributes to send
      as columns. (Enough to make the record
      identifiable).
       @private
      @property attributeLimit
      @default 3
      @since 1.3.0
    */
    attributeLimit: 3,

    /**
      Stores all methods that clear observers.
      These methods will be called on destruction.
       @private
      @property releaseMethods
      @since 1.3.0
    */
    releaseMethods: native_array.A(),

    /**
      Specifies how records can be filtered.
      Records returned will need to have a `filterValues`
      property with a key for every name in the returned array.
       @public
      @method getFilters
      @return {Array} List of objects defining filters.
       The object should have a `name` and `desc` property.
    */
    getFilters: function () {
      return native_array.A();
    },

    /**
      Fetch the model types and observe them for changes.
       @public
      @method watchModelTypes
       @param {Function} typesAdded Callback to call to add types.
      Takes an array of objects containing wrapped types (returned from `wrapModelType`).
       @param {Function} typesUpdated Callback to call when a type has changed.
      Takes an array of objects containing wrapped types.
       @return {Function} Method to call to remove all observers
    */
    watchModelTypes: function (typesAdded, typesUpdated) {
      var modelTypes = this.getModelTypes();
      var self = this;
      var releaseMethods = native_array.A();
      var typesToSend;

      typesToSend = modelTypes.map(function (type) {
        var klass = type.klass;
        var wrapped = self.wrapModelType(klass, type.name);
        releaseMethods.push(self.observeModelType(klass, typesUpdated));
        return wrapped;
      });

      typesAdded(typesToSend);

      var release = function () {
        releaseMethods.forEach(function (fn) {
          fn();
        });
        self.releaseMethods.removeObject(release);
      };
      this.releaseMethods.pushObject(release);
      return release;
    },

    _nameToClass: function (type) {
      if (typeof type === "string") {
        type = this.container.lookupFactory("model:" + type);
      }
      return type;
    },

    /**
      Fetch the records of a given type and observe them for changes.
       @public
      @method watchRecords
       @param {Function} recordsAdded Callback to call to add records.
      Takes an array of objects containing wrapped records.
      The object should have the following properties:
        columnValues: {Object} key and value of a table cell
        object: {Object} the actual record object
       @param {Function} recordsUpdated Callback to call when a record has changed.
      Takes an array of objects containing wrapped records.
       @param {Function} recordsRemoved Callback to call when a record has removed.
      Takes the following parameters:
        index: the array index where the records were removed
        count: the number of records removed
       @return {Function} Method to call to remove all observers
    */
    watchRecords: function (type, recordsAdded, recordsUpdated, recordsRemoved) {
      var self = this;
      var releaseMethods = native_array.A();
      var records = this.getRecords(type);
      var release;

      var recordUpdated = function (updatedRecord) {
        recordsUpdated([updatedRecord]);
      };

      var recordsToSend = records.map(function (record) {
        releaseMethods.push(self.observeRecord(record, recordUpdated));
        return self.wrapRecord(record);
      });

      var contentDidChange = function (array, idx, removedCount, addedCount) {
        for (var i = idx; i < idx + addedCount; i++) {
          var record = array.objectAt(i);
          var wrapped = self.wrapRecord(record);
          releaseMethods.push(self.observeRecord(record, recordUpdated));
          recordsAdded([wrapped]);
        }

        if (removedCount) {
          recordsRemoved(idx, removedCount);
        }
      };

      var observer = { didChange: contentDidChange, willChange: function () {
          return this;
        } };
      records.addArrayObserver(self, observer);

      release = function () {
        releaseMethods.forEach(function (fn) {
          fn();
        });
        records.removeArrayObserver(self, observer);
        self.releaseMethods.removeObject(release);
      };

      recordsAdded(recordsToSend);

      this.releaseMethods.pushObject(release);
      return release;
    },

    /**
      Clear all observers before destruction
      @private
      @method willDestroy
    */
    willDestroy: function () {
      this._super.apply(this, arguments);
      this.releaseMethods.forEach(function (fn) {
        fn();
      });
    },

    /**
      Detect whether a class is a model.
       Test that against the model class
      of your persistence library
       @private
      @method detect
      @param {Class} klass The class to test
      @return boolean Whether the class is a model class or not
    */
    detect: function (klass) {
      return false;
    },

    /**
      Get the columns for a given model type.
       @private
      @method columnsForType
      @param {Class} type The model type
      @return {Array} An array of columns of the following format:
       name: {String} name of the column
       desc: {String} Humanized description (what would show in a table column name)
    */
    columnsForType: function (type) {
      return native_array.A();
    },

    /**
      Adds observers to a model type class.
       @private
      @method observeModelType
      @param {Class} type The model type class
      @param {Function} typesUpdated Called when a type is modified.
      @return {Function} The function to call to remove observers
    */

    observeModelType: function (type, typesUpdated) {
      var self = this;
      var records = this.getRecords(type);

      var onChange = function () {
        typesUpdated([self.wrapModelType(type)]);
      };
      var observer = {
        didChange: function () {
          run['default'].scheduleOnce("actions", this, onChange);
        },
        willChange: function () {
          return this;
        }
      };

      records.addArrayObserver(this, observer);

      var release = function () {
        records.removeArrayObserver(self, observer);
      };

      return release;
    },

    /**
      Wraps a given model type and observes changes to it.
       @private
      @method wrapModelType
      @param {Class} type A model class
      @param {String}  Optional name of the class
      @return {Object} contains the wrapped type and the function to remove observers
      Format:
        type: {Object} the wrapped type
          The wrapped type has the following format:
            name: {String} name of the type
            count: {Integer} number of records available
            columns: {Columns} array of columns to describe the record
            object: {Class} the actual Model type class
        release: {Function} The function to remove observers
    */
    wrapModelType: function (type, name) {
      var records = this.getRecords(type);
      var typeToSend;

      typeToSend = {
        name: name || type.toString(),
        count: property_get.get(records, "length"),
        columns: this.columnsForType(type),
        object: type
      };

      return typeToSend;
    },

    /**
      Fetches all models defined in the application.
       @private
      @method getModelTypes
      @return {Array} Array of model types
    */
    getModelTypes: function () {
      var self = this;
      var containerDebugAdapter = this.get("containerDebugAdapter");
      var types;

      if (containerDebugAdapter.canCatalogEntriesByType("model")) {
        types = containerDebugAdapter.catalogEntriesByType("model");
      } else {
        types = this._getObjectsOnNamespaces();
      }

      // New adapters return strings instead of classes
      types = native_array.A(types).map(function (name) {
        return {
          klass: self._nameToClass(name),
          name: name
        };
      });
      types = native_array.A(types).filter(function (type) {
        return self.detect(type.klass);
      });

      return native_array.A(types);
    },

    /**
      Loops over all namespaces and all objects
      attached to them
       @private
      @method _getObjectsOnNamespaces
      @return {Array} Array of model type strings
    */
    _getObjectsOnNamespaces: function () {
      var namespaces = native_array.A(Namespace['default'].NAMESPACES);
      var types = native_array.A();
      var self = this;

      namespaces.forEach(function (namespace) {
        for (var key in namespace) {
          if (!namespace.hasOwnProperty(key)) {
            continue;
          }
          // Even though we will filter again in `getModelTypes`,
          // we should not call `lookupContainer` on non-models
          // (especially when `Ember.MODEL_FACTORY_INJECTIONS` is `true`)
          if (!self.detect(namespace[key])) {
            continue;
          }
          var name = string.dasherize(key);
          if (!(namespace instanceof Application['default']) && namespace.toString()) {
            name = namespace + "/" + name;
          }
          types.push(name);
        }
      });
      return types;
    },

    /**
      Fetches all loaded records for a given type.
       @private
      @method getRecords
      @return {Array} An array of records.
       This array will be observed for changes,
       so it should update when new records are added/removed.
    */
    getRecords: function (type) {
      return native_array.A();
    },

    /**
      Wraps a record and observers changes to it.
       @private
      @method wrapRecord
      @param {Object} record The record instance.
      @return {Object} The wrapped record. Format:
      columnValues: {Array}
      searchKeywords: {Array}
    */
    wrapRecord: function (record) {
      var recordToSend = { object: record };

      recordToSend.columnValues = this.getRecordColumnValues(record);
      recordToSend.searchKeywords = this.getRecordKeywords(record);
      recordToSend.filterValues = this.getRecordFilterValues(record);
      recordToSend.color = this.getRecordColor(record);

      return recordToSend;
    },

    /**
      Gets the values for each column.
       @private
      @method getRecordColumnValues
      @return {Object} Keys should match column names defined
      by the model type.
    */
    getRecordColumnValues: function (record) {
      return {};
    },

    /**
      Returns keywords to match when searching records.
       @private
      @method getRecordKeywords
      @return {Array} Relevant keywords for search.
    */
    getRecordKeywords: function (record) {
      return native_array.A();
    },

    /**
      Returns the values of filters defined by `getFilters`.
       @private
      @method getRecordFilterValues
      @param {Object} record The record instance
      @return {Object} The filter values
    */
    getRecordFilterValues: function (record) {
      return {};
    },

    /**
      Each record can have a color that represents its state.
       @private
      @method getRecordColor
      @param {Object} record The record instance
      @return {String} The record's color
        Possible options: black, red, blue, green
    */
    getRecordColor: function (record) {
      return null;
    },

    /**
      Observes all relevant properties and re-sends the wrapped record
      when a change occurs.
       @private
      @method observerRecord
      @param {Object} record The record instance
      @param {Function} recordUpdated The callback to call when a record is updated.
      @return {Function} The function to call to remove all observers.
    */
    observeRecord: function (record, recordUpdated) {
      return function () {};
    }
  });

});
enifed('ember-htmlbars', ['ember-metal/core', 'ember-template-compiler', 'ember-htmlbars/system/make-view-helper', 'ember-htmlbars/system/make_bound_helper', 'ember-htmlbars/helpers', 'ember-htmlbars/helpers/view', 'ember-htmlbars/helpers/component', 'ember-htmlbars/helpers/yield', 'ember-htmlbars/helpers/with', 'ember-htmlbars/helpers/log', 'ember-htmlbars/helpers/debugger', 'ember-htmlbars/helpers/bind-attr', 'ember-htmlbars/helpers/if_unless', 'ember-htmlbars/helpers/loc', 'ember-htmlbars/helpers/partial', 'ember-htmlbars/helpers/template', 'ember-htmlbars/helpers/input', 'ember-htmlbars/helpers/text_area', 'ember-htmlbars/helpers/collection', 'ember-htmlbars/helpers/each', 'ember-htmlbars/helpers/unbound', 'ember-htmlbars/system/bootstrap', 'ember-htmlbars/compat'], function (Ember, ember_template_compiler, makeViewHelper, makeBoundHelper, helpers, view, component, _yield, _with, log, _debugger, bind_attr, if_unless, loc, partial, template, input, text_area, collection, each, unbound) {

  'use strict';

  helpers.registerHelper("view", view.viewHelper);
  
    helpers.registerHelper("component", component.componentHelper);
  
  helpers.registerHelper("yield", _yield.yieldHelper);
  helpers.registerHelper("with", _with.withHelper);
  helpers.registerHelper("if", if_unless.ifHelper);
  helpers.registerHelper("unless", if_unless.unlessHelper);
  helpers.registerHelper("log", log.logHelper);
  helpers.registerHelper("debugger", _debugger.debuggerHelper);
  helpers.registerHelper("loc", loc.locHelper);
  helpers.registerHelper("partial", partial.partialHelper);
  helpers.registerHelper("template", template.templateHelper);
  helpers.registerHelper("bind-attr", bind_attr.bindAttrHelper);
  helpers.registerHelper("bindAttr", bind_attr.bindAttrHelperDeprecated);
  helpers.registerHelper("input", input.inputHelper);
  helpers.registerHelper("textarea", text_area.textareaHelper);
  helpers.registerHelper("collection", collection.collectionHelper);
  helpers.registerHelper("each", each.eachHelper);
  helpers.registerHelper("unbound", unbound.unboundHelper);

  Ember['default'].HTMLBars = {
    _registerHelper: helpers.registerHelper,
    template: ember_template_compiler.template,
    compile: ember_template_compiler.compile,
    precompile: ember_template_compiler.precompile,
    makeViewHelper: makeViewHelper['default'],
    makeBoundHelper: makeBoundHelper['default'],
    registerPlugin: ember_template_compiler.registerPlugin
  };

});
enifed('ember-htmlbars/compat', ['exports', 'ember-metal/core', 'ember-htmlbars/helpers', 'ember-htmlbars/compat/helper', 'ember-htmlbars/compat/handlebars-get', 'ember-htmlbars/compat/make-bound-helper', 'ember-htmlbars/compat/register-bound-helper', 'ember-htmlbars/system/make-view-helper', 'ember-htmlbars/utils/string'], function (exports, Ember, helpers, helper, compatHandlebarsGet, compatMakeBoundHelper, compatRegisterBoundHelper, makeViewHelper, string) {

  'use strict';

  var EmberHandlebars = Ember['default'].Handlebars = Ember['default'].Handlebars || {};
  EmberHandlebars.helpers = helpers['default'];
  EmberHandlebars.helper = helper.handlebarsHelper;
  EmberHandlebars.registerHelper = helper.registerHandlebarsCompatibleHelper;
  EmberHandlebars.registerBoundHelper = compatRegisterBoundHelper['default'];
  EmberHandlebars.makeBoundHelper = compatMakeBoundHelper['default'];
  EmberHandlebars.get = compatHandlebarsGet['default'];
  EmberHandlebars.makeViewHelper = makeViewHelper['default'];

  EmberHandlebars.SafeString = string.SafeString;
  EmberHandlebars.Utils = {
    escapeExpression: string.escapeExpression
  };

  exports['default'] = EmberHandlebars;

});
enifed('ember-htmlbars/compat/handlebars-get', ['exports'], function (exports) {

  'use strict';

  /**
  @module ember
  @submodule ember-htmlbars
  */

  /**
    Lookup both on root and on window. If the path starts with
    a keyword, the corresponding object will be looked up in the
    template's data hash and used to resolve the path.

    @method get
    @for Ember.Handlebars
    @param {Object} root The object to look up the property on
    @param {String} path The path to be lookedup
    @param {Object} options The template's option hash
    @deprecated
  */
  exports['default'] = handlebarsGet;

  function handlebarsGet(root, path, options) {
    
    return options.data.view.getStream(path).value();
  }

});
enifed('ember-htmlbars/compat/helper', ['exports', 'ember-metal/merge', 'ember-htmlbars/helpers', 'ember-views/views/view', 'ember-views/views/component', 'ember-htmlbars/system/make-view-helper', 'ember-htmlbars/compat/make-bound-helper', 'ember-metal/streams/utils'], function (exports, merge, helpers, View, Component, makeViewHelper, makeBoundHelper, utils) {

  'use strict';

  exports.registerHandlebarsCompatibleHelper = registerHandlebarsCompatibleHelper;
  exports.handlebarsHelper = handlebarsHelper;

  var slice = [].slice;

  function calculateCompatType(item) {
    if (utils.isStream(item)) {
      return "ID";
    } else {
      var itemType = typeof item;

      return itemType.toUpperCase();
    }
  }

  /**
    Wraps an Handlebars helper with an HTMLBars helper for backwards compatibility.

    @class HandlebarsCompatibleHelper
    @constructor
    @private
  */
  function HandlebarsCompatibleHelper(fn) {
    this.helperFunction = function helperFunc(params, hash, options, env) {
      var param, blockResult, fnResult;
      var context = env.data.view;
      var handlebarsOptions = {
        hash: {},
        types: new Array(params.length),
        hashTypes: {}
      };

      merge['default'](handlebarsOptions, options);
      merge['default'](handlebarsOptions, env);

      handlebarsOptions.hash = {};

      if (options.isBlock) {
        handlebarsOptions.fn = function () {
          blockResult = options.template.render(context, env, options.morph.contextualElement);
        };

        if (options.inverse) {
          handlebarsOptions.inverse = function () {
            blockResult = options.inverse.render(context, env, options.morph.contextualElement);
          };
        }
      }

      for (var prop in hash) {
        param = hash[prop];

        handlebarsOptions.hashTypes[prop] = calculateCompatType(param);

        if (utils.isStream(param)) {
          handlebarsOptions.hash[prop] = param._label;
        } else {
          handlebarsOptions.hash[prop] = param;
        }
      }

      var args = new Array(params.length);
      for (var i = 0, l = params.length; i < l; i++) {
        param = params[i];

        handlebarsOptions.types[i] = calculateCompatType(param);

        if (utils.isStream(param)) {
          args[i] = param._label;
        } else {
          args[i] = param;
        }
      }
      args.push(handlebarsOptions);

      fnResult = fn.apply(this, args);

      return options.isBlock ? blockResult : fnResult;
    };

    this.isHTMLBars = true;
  }

  HandlebarsCompatibleHelper.prototype = {
    preprocessArguments: function () {}
  };
  function registerHandlebarsCompatibleHelper(name, value) {
    var helper;

    if (value && value.isHTMLBars) {
      helper = value;
    } else {
      helper = new HandlebarsCompatibleHelper(value);
    }

    helpers['default'][name] = helper;
  }

  function handlebarsHelper(name, value) {
    
    if (View['default'].detect(value)) {
      helpers['default'][name] = makeViewHelper['default'](value);
    } else {
      var boundHelperArgs = slice.call(arguments, 1);
      var boundFn = makeBoundHelper['default'].apply(this, boundHelperArgs);

      helpers['default'][name] = boundFn;
    }
  }

  exports['default'] = HandlebarsCompatibleHelper;

});
enifed('ember-htmlbars/compat/make-bound-helper', ['exports', 'ember-metal/core', 'ember-metal/mixin', 'ember-htmlbars/system/helper', 'ember-metal/streams/stream', 'ember-metal/streams/utils'], function (exports, Ember, mixin, Helper, Stream, utils) {

  'use strict';



  /**
    A helper function used by `registerBoundHelper`. Takes the
    provided Handlebars helper function fn and returns it in wrapped
    bound helper form.

    The main use case for using this outside of `registerBoundHelper`
    is for registering helpers on the container:

    ```js
    var boundHelperFn = Ember.Handlebars.makeBoundHelper(function(word) {
      return word.toUpperCase();
    });

    container.register('helper:my-bound-helper', boundHelperFn);
    ```

    In the above example, if the helper function hadn't been wrapped in
    `makeBoundHelper`, the registered helper would be unbound.

    @method makeBoundHelper
    @for Ember.Handlebars
    @param {Function} function
    @param {String} dependentKeys*
    @since 1.2.0
    @deprecated
  */
  exports['default'] = makeBoundHelper;
  /**
  @module ember
  @submodule ember-htmlbars
  */

  function makeBoundHelper(fn, compatMode) {
    var dependentKeys = [];
    for (var i = 1; i < arguments.length; i++) {
      dependentKeys.push(arguments[i]);
    }

    function helperFunc(params, hash, options, env) {
      var view = env.data.view;
      var numParams = params.length;
      var param;

      
      for (var prop in hash) {
        if (mixin.IS_BINDING.test(prop)) {
          hash[prop.slice(0, -7)] = view.getStream(hash[prop]);
          delete hash[prop];
        }
      }

      function valueFn() {
        var args = utils.readArray(params);
        var properties = new Array(params.length);
        for (var i = 0, l = params.length; i < l; i++) {
          param = params[i];

          if (utils.isStream(param)) {
            properties[i] = param._label;
          } else {
            properties[i] = param;
          }
        }

        args.push({
          hash: utils.readHash(hash),
          data: { properties: properties }
        });
        return fn.apply(view, args);
      }

      // If none of the hash parameters are bound, act as an unbound helper.
      // This prevents views from being unnecessarily created
      var hasStream = utils.scanArray(params) || utils.scanHash(hash);
      if (hasStream) {
        var lazyValue = new Stream['default'](valueFn);

        for (i = 0; i < numParams; i++) {
          param = params[i];
          if (utils.isStream(param)) {
            param.subscribe(lazyValue.notify, lazyValue);
          }
        }

        for (prop in hash) {
          param = hash[prop];
          if (utils.isStream(param)) {
            param.subscribe(lazyValue.notify, lazyValue);
          }
        }

        if (numParams > 0) {
          var firstParam = params[0];
          // Only bother with subscriptions if the first argument
          // is a stream itself, and not a primitive.
          if (utils.isStream(firstParam)) {
            var onDependentKeyNotify = function onDependentKeyNotify(stream) {
              stream.value();
              lazyValue.notify();
            };
            for (i = 0; i < dependentKeys.length; i++) {
              var childParam = firstParam.get(dependentKeys[i]);
              childParam.value();
              childParam.subscribe(onDependentKeyNotify);
            }
          }
        }

        return lazyValue;
      } else {
        return valueFn();
      }
    }

    return new Helper['default'](helperFunc);
  }

});
enifed('ember-htmlbars/compat/register-bound-helper', ['exports', 'ember-htmlbars/helpers', 'ember-htmlbars/compat/make-bound-helper'], function (exports, helpers, makeBoundHelper) {

  'use strict';



  /**
    Register a bound handlebars helper. Bound helpers behave similarly to regular
    handlebars helpers, with the added ability to re-render when the underlying data
    changes.

    ## Simple example

    ```javascript
    Ember.Handlebars.registerBoundHelper('capitalize', function(value) {
      return Ember.String.capitalize(value);
    });
    ```

    The above bound helper can be used inside of templates as follows:

    ```handlebars
    {{capitalize name}}
    ```

    In this case, when the `name` property of the template's context changes,
    the rendered value of the helper will update to reflect this change.

    ## Example with options

    Like normal handlebars helpers, bound helpers have access to the options
    passed into the helper call.

    ```javascript
    Ember.Handlebars.registerBoundHelper('repeat', function(value, options) {
      var count = options.hash.count;
      var a = [];
      while(a.length < count) {
          a.push(value);
      }
      return a.join('');
    });
    ```

    This helper could be used in a template as follows:

    ```handlebars
    {{repeat text count=3}}
    ```

    ## Example with bound options

    Bound hash options are also supported. Example:

    ```handlebars
    {{repeat text count=numRepeats}}
    ```

    In this example, count will be bound to the value of
    the `numRepeats` property on the context. If that property
    changes, the helper will be re-rendered.

    ## Example with extra dependencies

    The `Ember.Handlebars.registerBoundHelper` method takes a variable length
    third parameter which indicates extra dependencies on the passed in value.
    This allows the handlebars helper to update when these dependencies change.

    ```javascript
    Ember.Handlebars.registerBoundHelper('capitalizeName', function(value) {
      return value.get('name').toUpperCase();
    }, 'name');
    ```

    ## Example with multiple bound properties

    `Ember.Handlebars.registerBoundHelper` supports binding to
    multiple properties, e.g.:

    ```javascript
    Ember.Handlebars.registerBoundHelper('concatenate', function() {
      var values = Array.prototype.slice.call(arguments, 0, -1);
      return values.join('||');
    });
    ```

    Which allows for template syntax such as `{{concatenate prop1 prop2}}` or
    `{{concatenate prop1 prop2 prop3}}`. If any of the properties change,
    the helper will re-render.  Note that dependency keys cannot be
    using in conjunction with multi-property helpers, since it is ambiguous
    which property the dependent keys would belong to.

    ## Use with unbound helper

    The `{{unbound}}` helper can be used with bound helper invocations
    to render them in their unbound form, e.g.

    ```handlebars
    {{unbound capitalize name}}
    ```

    In this example, if the name property changes, the helper
    will not re-render.

    ## Use with blocks not supported

    Bound helpers do not support use with Handlebars blocks or
    the addition of child views of any kind.

    @method registerBoundHelper
    @for Ember.Handlebars
    @param {String} name
    @param {Function} function
    @param {String} dependentKeys*
  */
  exports['default'] = registerBoundHelper;
  /**
  @module ember
  @submodule ember-htmlbars
  */

  var slice = [].slice;
  function registerBoundHelper(name, fn) {
    var boundHelperArgs = slice.call(arguments, 1);
    var boundFn = makeBoundHelper['default'].apply(this, boundHelperArgs);

    helpers['default'][name] = boundFn;
  }

});
enifed('ember-htmlbars/env', ['exports', 'ember-metal/environment', 'dom-helper', 'ember-htmlbars/hooks/inline', 'ember-htmlbars/hooks/content', 'ember-htmlbars/hooks/component', 'ember-htmlbars/hooks/block', 'ember-htmlbars/hooks/element', 'ember-htmlbars/hooks/subexpr', 'ember-htmlbars/hooks/attribute', 'ember-htmlbars/hooks/concat', 'ember-htmlbars/hooks/get', 'ember-htmlbars/hooks/set', 'ember-htmlbars/helpers'], function (exports, environment, DOMHelper, inline, content, component, block, element, subexpr, attribute, concat, get, set, helpers) {

  'use strict';

  exports['default'] = {
    hooks: {
      get: get['default'],
      set: set['default'],
      inline: inline['default'],
      content: content['default'],
      block: block['default'],
      element: element['default'],
      subexpr: subexpr['default'],
      component: component['default'],
      attribute: attribute['default'],
      concat: concat['default']
    },

    helpers: helpers['default'],

    useFragmentCache: true
  };

  var domHelper = environment['default'].hasDOM ? new DOMHelper['default']() : null;

  exports.domHelper = domHelper;

});
enifed('ember-htmlbars/helpers', ['exports', 'ember-metal/platform/create', 'ember-htmlbars/system/helper'], function (exports, o_create, Helper) {

  'use strict';

  exports.registerHelper = registerHelper;

  /**
    @private
    @method _registerHelper
    @for Ember.HTMLBars
    @param {String} name
    @param {Object|Function} helperFunc the helper function to add
  */
  var helpers = o_create['default'](null);
  function registerHelper(name, helperFunc) {
    var helper;

    if (helperFunc && helperFunc.isHelper) {
      helper = helperFunc;
    } else {
      helper = new Helper['default'](helperFunc);
    }

    helpers[name] = helper;
  }

  exports['default'] = helpers;

});
enifed('ember-htmlbars/helpers/bind-attr', ['exports', 'ember-metal/core', 'ember-runtime/system/string', 'ember-views/attr_nodes/attr_node', 'ember-views/attr_nodes/legacy_bind', 'ember-metal/keys', 'ember-htmlbars/helpers', 'ember-metal/enumerable_utils', 'ember-metal/streams/utils', 'ember-views/streams/class_name_binding'], function (exports, Ember, string, AttrNode, LegacyBindAttrNode, keys, helpers, enumerable_utils, utils, class_name_binding) {

  'use strict';

  exports.bindAttrHelper = bindAttrHelper;
  exports.bindAttrHelperDeprecated = bindAttrHelperDeprecated;

  /**
  @module ember
  @submodule ember-htmlbars
  */

  function bindAttrHelper(params, hash, options, env) {
    var element = options.element;

    
    var view = env.data.view;

    // Handle classes differently, as we can bind multiple classes
    var classNameBindings = hash["class"];
    if (classNameBindings !== null && classNameBindings !== undefined) {
      if (!utils.isStream(classNameBindings)) {
        classNameBindings = applyClassNameBindings(classNameBindings, view);
      }

      var classView = new AttrNode['default']("class", classNameBindings);
      classView._morph = env.dom.createAttrMorph(element, "class");

      
      view.appendChild(classView);
    }

    var attrKeys = keys['default'](hash);

    var attr, path, lazyValue, attrView;
    for (var i = 0, l = attrKeys.length; i < l; i++) {
      attr = attrKeys[i];
      if (attr === "class") {
        continue;
      }
      path = hash[attr];
      if (utils.isStream(path)) {
        lazyValue = path;
      } else {
                lazyValue = view.getStream(path);
      }

      attrView = new LegacyBindAttrNode['default'](attr, lazyValue);
      attrView._morph = env.dom.createAttrMorph(element, attr);

      
      view.appendChild(attrView);
    }
  }

  function applyClassNameBindings(classNameBindings, view) {
    var arrayOfClassNameBindings = classNameBindings.split(" ");
    var boundClassNameBindings = enumerable_utils.map(arrayOfClassNameBindings, function (classNameBinding) {
      return class_name_binding.streamifyClassNameBinding(view, classNameBinding);
    });
    var concatenatedClassNames = utils.concat(boundClassNameBindings, " ");
    return concatenatedClassNames;
  }

  /**
    See `bind-attr`

    @method bindAttr
    @for Ember.Handlebars.helpers
    @deprecated
    @param {Function} context
    @param {Hash} options
    @return {String} HTML string
  */
  function bindAttrHelperDeprecated() {
    
    return helpers['default']["bind-attr"].helperFunction.apply(this, arguments);
  }

  exports['default'] = bindAttrHelper;

});
enifed('ember-htmlbars/helpers/collection', ['exports', 'ember-metal/core', 'ember-metal/mixin', 'ember-runtime/system/string', 'ember-metal/property_get', 'ember-views/views/collection_view', 'ember-views/streams/utils', 'ember-metal/enumerable_utils', 'ember-views/streams/class_name_binding', 'ember-htmlbars/system/merge-view-bindings'], function (exports, Ember, mixin, string, property_get, CollectionView, utils, enumerable_utils, class_name_binding, mergeViewBindings) {

  'use strict';

  exports.collectionHelper = collectionHelper;

  /**
    `{{collection}}` is a `Ember.Handlebars` helper for adding instances of
    `Ember.CollectionView` to a template. See [Ember.CollectionView](/api/classes/Ember.CollectionView.html)
     for additional information on how a `CollectionView` functions.

    `{{collection}}`'s primary use is as a block helper with a `contentBinding`
    option pointing towards an `Ember.Array`-compatible object. An `Ember.View`
    instance will be created for each item in its `content` property. Each view
    will have its own `content` property set to the appropriate item in the
    collection.

    The provided block will be applied as the template for each item's view.

    Given an empty `<body>` the following template:

    ```handlebars
    {{! application.hbs }}
    {{#collection content=model}}
      Hi {{view.content.name}}
    {{/collection}}
    ```

    And the following application code

    ```javascript
    App = Ember.Application.create();
    App.ApplicationRoute = Ember.Route.extend({
      model: function() {
        return [{name: 'Yehuda'},{name: 'Tom'},{name: 'Peter'}];
      }
    });
    ```

    The following HTML will result:

    ```html
    <div class="ember-view">
      <div class="ember-view">Hi Yehuda</div>
      <div class="ember-view">Hi Tom</div>
      <div class="ember-view">Hi Peter</div>
    </div>
    ```

    ### Non-block version of collection

    If you provide an `itemViewClass` option that has its own `template` you may
    omit the block.

    The following template:

    ```handlebars
    {{! application.hbs }}
    {{collection content=model itemViewClass="an-item"}}
    ```

    And application code

    ```javascript
    App = Ember.Application.create();
    App.ApplicationRoute = Ember.Route.extend({
      model: function() {
        return [{name: 'Yehuda'},{name: 'Tom'},{name: 'Peter'}];
      }
    });

    App.AnItemView = Ember.View.extend({
      template: Ember.Handlebars.compile("Greetings {{view.content.name}}")
    });
    ```

    Will result in the HTML structure below

    ```html
    <div class="ember-view">
      <div class="ember-view">Greetings Yehuda</div>
      <div class="ember-view">Greetings Tom</div>
      <div class="ember-view">Greetings Peter</div>
    </div>
    ```

    ### Specifying a CollectionView subclass

    By default the `{{collection}}` helper will create an instance of
    `Ember.CollectionView`. You can supply a `Ember.CollectionView` subclass to
    the helper by passing it as the first argument:

    ```handlebars
    {{#collection "my-custom-collection" content=model}}
      Hi {{view.content.name}}
    {{/collection}}
    ```

    This example would look for the class `App.MyCustomCollection`.

    ### Forwarded `item.*`-named Options

    As with the `{{view}}`, helper options passed to the `{{collection}}` will be
    set on the resulting `Ember.CollectionView` as properties. Additionally,
    options prefixed with `item` will be applied to the views rendered for each
    item (note the camelcasing):

    ```handlebars
    {{#collection content=model
                  itemTagName="p"
                  itemClassNames="greeting"}}
      Howdy {{view.content.name}}
    {{/collection}}
    ```

    Will result in the following HTML structure:

    ```html
    <div class="ember-view">
      <p class="ember-view greeting">Howdy Yehuda</p>
      <p class="ember-view greeting">Howdy Tom</p>
      <p class="ember-view greeting">Howdy Peter</p>
    </div>
    ```

    @method collection
    @for Ember.Handlebars.helpers
    @deprecated Use `{{each}}` helper instead.
  */
  function collectionHelper(params, hash, options, env) {
    var path = params[0];

    
    
    var data = env.data;
    var template = options.template;
    var inverse = options.inverse;
    var view = data.view;

    // This should be deterministic, and should probably come from a
    // parent view and not the controller.
    var controller = property_get.get(view, "controller");
    var container = controller && controller.container ? controller.container : view.container;

    // If passed a path string, convert that into an object.
    // Otherwise, just default to the standard class.
    var collectionClass;
    if (path) {
      collectionClass = utils.readViewFactory(path, container);
          } else {
      collectionClass = CollectionView['default'];
    }

    var itemHash = {};
    var match;

    // Extract item view class if provided else default to the standard class
    var collectionPrototype = collectionClass.proto();
    var itemViewClass;

    if (hash.itemView) {
      itemViewClass = utils.readViewFactory(hash.itemView, container);
    } else if (hash.itemViewClass) {
      itemViewClass = utils.readViewFactory(hash.itemViewClass, container);
    } else {
      itemViewClass = collectionPrototype.itemViewClass;
    }

    if (typeof itemViewClass === "string") {
      itemViewClass = container.lookupFactory("view:" + itemViewClass);
    }

    
    delete hash.itemViewClass;
    delete hash.itemView;

    // Go through options passed to the {{collection}} helper and extract options
    // that configure item views instead of the collection itself.
    for (var prop in hash) {
      if (prop === "itemController" || prop === "itemClassBinding") {
        continue;
      }
      if (hash.hasOwnProperty(prop)) {
        match = prop.match(/^item(.)(.*)$/);
        if (match) {
          var childProp = match[1].toLowerCase() + match[2];

          if (mixin.IS_BINDING.test(prop)) {
            itemHash[childProp] = view._getBindingForStream(hash[prop]);
          } else {
            itemHash[childProp] = hash[prop];
          }
          delete hash[prop];
        }
      }
    }

    if (template) {
      itemHash.template = template;
      delete options.template;
    }

    var emptyViewClass;
    if (inverse) {
      emptyViewClass = property_get.get(collectionPrototype, "emptyViewClass");
      emptyViewClass = emptyViewClass.extend({
        template: inverse,
        tagName: itemHash.tagName
      });
    } else if (hash.emptyViewClass) {
      emptyViewClass = utils.readViewFactory(hash.emptyViewClass, container);
    }
    if (emptyViewClass) {
      hash.emptyView = emptyViewClass;
    }

    var viewOptions = mergeViewBindings['default'](view, {}, itemHash);

    if (hash.itemClassBinding) {
      var itemClassBindings = hash.itemClassBinding.split(" ");
      viewOptions.classNameBindings = enumerable_utils.map(itemClassBindings, function (classBinding) {
        return class_name_binding.streamifyClassNameBinding(view, classBinding);
      });
    }

    hash.itemViewClass = itemViewClass;
    hash._itemViewProps = viewOptions;

    options.helperName = options.helperName || "collection";

    return env.helpers.view.helperFunction.call(this, [collectionClass], hash, options, env);
  }

});
enifed('ember-htmlbars/helpers/component', ['exports', 'ember-metal/core', 'ember-metal/streams/utils', 'ember-views/streams/utils', 'ember-metal/error', 'ember-views/views/bound_component_view', 'ember-htmlbars/system/merge-view-bindings', 'ember-htmlbars/system/append-templated-view'], function (exports, Ember, utils, streams__utils, EmberError, BoundComponentView, mergeViewBindings, appendTemplatedView) {

  'use strict';

  exports.componentHelper = componentHelper;

  /**
    The `{{component}}` helper lets you add instances of `Ember.Component` to a
    template. See [Ember.Component](/api/classes/Ember.Component.html) for
    additional information on how a `Component` functions.

    `{{component}}`'s primary use is for cases where you want to dynamically
    change which type of component is rendered as the state of your application
    changes.

    The provided block will be applied as the template for the component.

    Given an empty `<body>` the following template:

    ```handlebars
    {{! application.hbs }}
    {{component infographicComponentName}}
    ```

    And the following application code

    ```javascript
    App = Ember.Application.create();
    App.ApplicationController = Ember.Controller.extend({
      infographicComponentName: function() {
        if (this.get('isMarketOpen')) {
          return "live-updating-chart";
        } else {
          return "market-close-summary";
        }
      }.property('isMarketOpen')
    });
    ```

    The `live-updating-chart` component will be appended when `isMarketOpen` is
    `true`, and the `market-close-summary` component will be appended when
    `isMarketOpen` is `false`. If the value changes while the app is running,
    the component will be automatically swapped out accordingly.

    Note: You should not use this helper when you are consistently rendering the same
    component. In that case, use standard component syntax, for example:

    ```handlebars
    {{! application.hbs }}
    {{live-updating-chart}}
    ```

    @method component
    @since 1.11.0
    @for Ember.Handlebars.helpers
  */
  function componentHelper(params, hash, options, env) {
    
    var view = env.data.view;
    var componentNameParam = params[0];
    var container = view.container || utils.read(view._keywords.view).container;

    var props = {
      helperName: options.helperName || "component"
    };
    if (options.template) {
      props.template = options.template;
    }

    var viewClass;
    if (utils.isStream(componentNameParam)) {
      viewClass = BoundComponentView['default'];
      props = { _boundComponentOptions: Ember['default'].merge(hash, props) };
      props._boundComponentOptions.componentNameStream = componentNameParam;
    } else {
      viewClass = streams__utils.readComponentFactory(componentNameParam, container);
      if (!viewClass) {
        throw new EmberError['default']("HTMLBars error: Could not find component named \"" + componentNameParam + "\".");
      }
      mergeViewBindings['default'](view, props, hash);
    }

    appendTemplatedView['default'](view, options.morph, viewClass, props);
  }

});
enifed('ember-htmlbars/helpers/debugger', ['exports', 'ember-metal/logger'], function (exports, Logger) {

  'use strict';

  exports.debuggerHelper = debuggerHelper;

  /**
    Execute the `debugger` statement in the current template's context.

    ```handlebars
    {{debugger}}
    ```

    When using the debugger helper you will have access to a `get` function. This
    function retrieves values available in the context of the template.

    For example, if you're wondering why a value `{{foo}}` isn't rendering as
    expected within a template, you could place a `{{debugger}}` statement and,
    when the `debugger;` breakpoint is hit, you can attempt to retrieve this value:

    ```
    > get('foo')
    ```

    `get` is also aware of keywords. So in this situation

    ```handlebars
    {{#each items as |item|}}
      {{debugger}}
    {{/each}}
    ```

    you'll be able to get values from the current item:

    ```
    > get('item.name')
    ```

    You can also access the context of the view to make sure it is the object that
    you expect:

    ```
    > context
    ```

    @method debugger
    @for Ember.Handlebars.helpers
    @param {String} property
  */
  function debuggerHelper(params, hash, options, env) {

    /* jshint unused: false */
    var view = env.data.view;

    /* jshint unused: false */
    var context = view.get('context');

    /* jshint unused: false */
    function get(path) {
      return view.getStream(path).value();
    }

    Logger['default'].info('Use `view`, `context`, and `get(<path>)` to debug this template.');

    debugger;
  }

});
enifed('ember-htmlbars/helpers/each', ['exports', 'ember-metal/core', 'ember-views/views/each'], function (exports, Ember, EachView) {

  'use strict';

  exports.eachHelper = eachHelper;

  /**
  @module ember
  @submodule ember-htmlbars
  */
  function eachHelper(params, hash, options, env) {
    var view = env.data.view;
    var helperName = "each";
    var path = params[0] || view.getStream("");

    
    var blockParams = options.template && options.template.blockParams;

    if (blockParams) {
      hash.keyword = true;
      hash.blockParams = blockParams;
    }

    
    hash.dataSource = path;
    options.helperName = options.helperName || helperName;

    return env.helpers.collection.helperFunction.call(this, [EachView['default']], hash, options, env);
  }

  exports.EachView = EachView['default'];

});
enifed('ember-htmlbars/helpers/if_unless', ['exports', 'ember-metal/core', 'ember-metal/streams/conditional', 'ember-views/streams/should_display', 'ember-metal/property_get', 'ember-metal/streams/utils', 'ember-views/views/bound_if_view', 'ember-htmlbars/templates/empty'], function (exports, Ember, conditional, shouldDisplay, property_get, utils, BoundIfView, emptyTemplate) {

  'use strict';

  exports.ifHelper = ifHelper;
  exports.unlessHelper = unlessHelper;

  /**
  @module ember
  @submodule ember-htmlbars
  */

  function ifHelper(params, hash, options, env) {
    var helperName = options.helperName || "if";
    return appendConditional(false, helperName, params, hash, options, env);
  }

  /**
    @method unless
    @for Ember.Handlebars.helpers
  */
  function unlessHelper(params, hash, options, env) {
    var helperName = options.helperName || "unless";
    return appendConditional(true, helperName, params, hash, options, env);
  }

  function assertInlineIfNotEnabled() {
      }

  function appendConditional(inverted, helperName, params, hash, options, env) {
    var view = env.data.view;

    if (options.isBlock) {
      return appendBlockConditional(view, inverted, helperName, params, hash, options, env);
    } else {
      
        return appendInlineConditional(view, inverted, helperName, params, hash, options, env);
          }
  }

  function appendBlockConditional(view, inverted, helperName, params, hash, options, env) {
    
    var condition = shouldDisplay['default'](params[0]);
    var truthyTemplate = (inverted ? options.inverse : options.template) || emptyTemplate['default'];
    var falsyTemplate = (inverted ? options.template : options.inverse) || emptyTemplate['default'];

    if (utils.isStream(condition)) {
      view.appendChild(BoundIfView['default'], {
        _morph: options.morph,
        _context: property_get.get(view, "context"),
        conditionStream: condition,
        truthyTemplate: truthyTemplate,
        falsyTemplate: falsyTemplate,
        helperName: helperName
      });
    } else {
      var template = condition ? truthyTemplate : falsyTemplate;
      if (template) {
        return template.render(view, env, options.morph.contextualElement);
      }
    }
  }

  function appendInlineConditional(view, inverted, helperName, params) {
    
    return conditional['default'](shouldDisplay['default'](params[0]), inverted ? params[2] : params[1], inverted ? params[1] : params[2]);
  }

});
enifed('ember-htmlbars/helpers/input', ['exports', 'ember-views/views/checkbox', 'ember-views/views/text_field', 'ember-metal/streams/utils', 'ember-metal/core'], function (exports, Checkbox, TextField, utils, Ember) {

  'use strict';

  exports.inputHelper = inputHelper;

  // Ember.assert

  /**
  @module ember
  @submodule ember-htmlbars
  */

  /**

    The `{{input}}` helper inserts an HTML `<input>` tag into the template,
    with a `type` value of either `text` or `checkbox`. If no `type` is provided,
    `text` will be the default value applied. The attributes of `{{input}}`
    match those of the native HTML tag as closely as possible for these two types.

    ## Use as text field
    An `{{input}}` with no `type` or a `type` of `text` will render an HTML text input.
    The following HTML attributes can be set via the helper:

   <table>
    <tr><td>`readonly`</td><td>`required`</td><td>`autofocus`</td></tr>
    <tr><td>`value`</td><td>`placeholder`</td><td>`disabled`</td></tr>
    <tr><td>`size`</td><td>`tabindex`</td><td>`maxlength`</td></tr>
    <tr><td>`name`</td><td>`min`</td><td>`max`</td></tr>
    <tr><td>`pattern`</td><td>`accept`</td><td>`autocomplete`</td></tr>
    <tr><td>`autosave`</td><td>`formaction`</td><td>`formenctype`</td></tr>
    <tr><td>`formmethod`</td><td>`formnovalidate`</td><td>`formtarget`</td></tr>
    <tr><td>`height`</td><td>`inputmode`</td><td>`multiple`</td></tr>
    <tr><td>`step`</td><td>`width`</td><td>`form`</td></tr>
    <tr><td>`selectionDirection`</td><td>`spellcheck`</td><td>&nbsp;</td></tr>
   </table>


    When set to a quoted string, these values will be directly applied to the HTML
    element. When left unquoted, these values will be bound to a property on the
    template's current rendering context (most typically a controller instance).

    ## Unbound:

    ```handlebars
    {{input value="http://www.facebook.com"}}
    ```


    ```html
    <input type="text" value="http://www.facebook.com"/>
    ```

    ## Bound:

    ```javascript
    App.ApplicationController = Ember.Controller.extend({
      firstName: "Stanley",
      entryNotAllowed: true
    });
    ```


    ```handlebars
    {{input type="text" value=firstName disabled=entryNotAllowed size="50"}}
    ```


    ```html
    <input type="text" value="Stanley" disabled="disabled" size="50"/>
    ```

    ## Actions

    The helper can send multiple actions based on user events.

    The action property defines the action which is sent when
    the user presses the return key.

    ```handlebars
    {{input action="submit"}}
    ```

    The helper allows some user events to send actions.

  * `enter`
  * `insert-newline`
  * `escape-press`
  * `focus-in`
  * `focus-out`
  * `key-press`
  * `key-up`


    For example, if you desire an action to be sent when the input is blurred,
    you only need to setup the action name to the event name property.

    ```handlebars
    {{input focus-in="alertMessage"}}
    ```

    See more about [Text Support Actions](/api/classes/Ember.TextField.html)

    ## Extension

    Internally, `{{input type="text"}}` creates an instance of `Ember.TextField`, passing
    arguments from the helper to `Ember.TextField`'s `create` method. You can extend the
    capabilities of text inputs in your applications by reopening this class. For example,
    if you are building a Bootstrap project where `data-*` attributes are used, you
    can add one to the `TextField`'s `attributeBindings` property:


    ```javascript
    Ember.TextField.reopen({
      attributeBindings: ['data-error']
    });
    ```

    Keep in mind when writing `Ember.TextField` subclasses that `Ember.TextField`
    itself extends `Ember.Component`, meaning that it does NOT inherit
    the `controller` of the parent view.

    See more about [Ember components](/api/classes/Ember.Component.html)


    ## Use as checkbox

    An `{{input}}` with a `type` of `checkbox` will render an HTML checkbox input.
    The following HTML attributes can be set via the helper:

  * `checked`
  * `disabled`
  * `tabindex`
  * `indeterminate`
  * `name`
  * `autofocus`
  * `form`


    When set to a quoted string, these values will be directly applied to the HTML
    element. When left unquoted, these values will be bound to a property on the
    template's current rendering context (most typically a controller instance).

    ## Unbound:

    ```handlebars
    {{input type="checkbox" name="isAdmin"}}
    ```

    ```html
    <input type="checkbox" name="isAdmin" />
    ```

    ## Bound:

    ```javascript
    App.ApplicationController = Ember.Controller.extend({
      isAdmin: true
    });
    ```


    ```handlebars
    {{input type="checkbox" checked=isAdmin }}
    ```


    ```html
    <input type="checkbox" checked="checked" />
    ```

    ## Extension

    Internally, `{{input type="checkbox"}}` creates an instance of `Ember.Checkbox`, passing
    arguments from the helper to `Ember.Checkbox`'s `create` method. You can extend the
    capablilties of checkbox inputs in your applications by reopening this class. For example,
    if you wanted to add a css class to all checkboxes in your application:


    ```javascript
    Ember.Checkbox.reopen({
      classNames: ['my-app-checkbox']
    });
    ```


    @method input
    @for Ember.Handlebars.helpers
    @param {Hash} options
  */
  function inputHelper(params, hash, options, env) {
    
    var onEvent = hash.on;
    var inputType;

    inputType = utils.read(hash.type);

    if (inputType === "checkbox") {
      delete hash.type;

      
      env.helpers.view.helperFunction.call(this, [Checkbox['default']], hash, options, env);
    } else {
      delete hash.on;

      hash.onEvent = onEvent || "enter";
      env.helpers.view.helperFunction.call(this, [TextField['default']], hash, options, env);
    }
  }

});
enifed('ember-htmlbars/helpers/loc', ['exports', 'ember-metal/core', 'ember-runtime/system/string', 'ember-metal/streams/utils'], function (exports, Ember, string, utils) {

  'use strict';

  exports.locHelper = locHelper;

  /**
  @module ember
  @submodule ember-htmlbars
  */

  /**
    Calls [Ember.String.loc](/api/classes/Ember.String.html#method_loc) with the
    provided string.

    This is a convenient way to localize text within a template:

    ```javascript
    Ember.STRINGS = {
      '_welcome_': 'Bonjour'
    };
    ```

    ```handlebars
    <div class='message'>
      {{loc '_welcome_'}}
    </div>
    ```

    ```html
    <div class='message'>
      Bonjour
    </div>
    ```

    See [Ember.String.loc](/api/classes/Ember.String.html#method_loc) for how to
    set up localized string references.

    @method loc
    @for Ember.Handlebars.helpers
    @param {String} str The string to format
    @see {Ember.String#loc}
  */
  function locHelper(params, hash, options, env) {
    
    return string.loc.apply(env.data.view, params);
  }

});
enifed('ember-htmlbars/helpers/log', ['exports', 'ember-metal/logger', 'ember-metal/streams/utils'], function (exports, Logger, utils) {

  'use strict';

  exports.logHelper = logHelper;

  /**
    `log` allows you to output the value of variables in the current rendering
    context. `log` also accepts primitive types such as strings or numbers.

    ```handlebars
    {{log "myVariable:" myVariable }}
    ```

    @method log
    @for Ember.Handlebars.helpers
    @param {String} property
  */
  function logHelper(params, hash, options, env) {
    var logger = Logger['default'].log;
    var values = [];

    for (var i = 0; i < params.length; i++) {
      values.push(utils.read(params[i]));
    }

    logger.apply(logger, values);
  }

});
enifed('ember-htmlbars/helpers/partial', ['exports', 'ember-metal/property_get', 'ember-metal/streams/utils', 'ember-views/views/bound_partial_view', 'ember-views/system/lookup_partial'], function (exports, property_get, utils, BoundPartialView, lookupPartial) {

  'use strict';

  exports.partialHelper = partialHelper;

  /**
  @module ember
  @submodule ember-htmlbars
  */

  /**
    The `partial` helper renders another template without
    changing the template context:

    ```handlebars
    {{foo}}
    {{partial "nav"}}
    ```

    The above example template will render a template named
    "_nav", which has the same context as the parent template
    it's rendered into, so if the "_nav" template also referenced
    `{{foo}}`, it would print the same thing as the `{{foo}}`
    in the above example.

    If a "_nav" template isn't found, the `partial` helper will
    fall back to a template named "nav".

    ## Bound template names

    The parameter supplied to `partial` can also be a path
    to a property containing a template name, e.g.:

    ```handlebars
    {{partial someTemplateName}}
    ```

    The above example will look up the value of `someTemplateName`
    on the template context (e.g. a controller) and use that
    value as the name of the template to render. If the resolved
    value is falsy, nothing will be rendered. If `someTemplateName`
    changes, the partial will be re-rendered using the new template
    name.


    @method partial
    @for Ember.Handlebars.helpers
    @param {String} partialName the name of the template to render minus the leading underscore
  */

  function partialHelper(params, hash, options, env) {
    var view = env.data.view;
    var templateName = params[0];

    if (utils.isStream(templateName)) {
      view.appendChild(BoundPartialView['default'], {
        _morph: options.morph,
        _context: property_get.get(view, "context"),
        templateNameStream: templateName,
        helperName: options.helperName || "partial"
      });
    } else {
      var template = lookupPartial['default'](view, templateName);
      return template.render(view, env, options.morph.contextualElement);
    }
  }

});
enifed('ember-htmlbars/helpers/template', ['exports', 'ember-metal/core'], function (exports, Ember) {

  'use strict';

  exports.templateHelper = templateHelper;

  // Ember.deprecate;

  /**
  @module ember
  @submodule ember-htmlbars
  */

  /**
    @deprecated
    @method template
    @for Ember.Handlebars.helpers
    @param {String} templateName the template to render
  */
  function templateHelper(params, hash, options, env) {
    
    options.helperName = options.helperName || "template";

    return env.helpers.partial.helperFunction.call(this, params, hash, options, env);
  }

});
enifed('ember-htmlbars/helpers/text_area', ['exports', 'ember-metal/core', 'ember-views/views/text_area'], function (exports, Ember, TextArea) {

  'use strict';

  exports.textareaHelper = textareaHelper;

  /**
    `{{textarea}}` inserts a new instance of `<textarea>` tag into the template.
    The attributes of `{{textarea}}` match those of the native HTML tags as
    closely as possible.

    The following HTML attributes can be set:

      * `value`
      * `name`
      * `rows`
      * `cols`
      * `placeholder`
      * `disabled`
      * `maxlength`
      * `tabindex`
      * `selectionEnd`
      * `selectionStart`
      * `selectionDirection`
      * `wrap`
      * `readonly`
      * `autofocus`
      * `form`
      * `spellcheck`
      * `required`

    When set to a quoted string, these value will be directly applied to the HTML
    element. When left unquoted, these values will be bound to a property on the
    template's current rendering context (most typically a controller instance).

    Unbound:

    ```handlebars
    {{textarea value="Lots of static text that ISN'T bound"}}
    ```

    Would result in the following HTML:

    ```html
    <textarea class="ember-text-area">
      Lots of static text that ISN'T bound
    </textarea>
    ```

    Bound:

    In the following example, the `writtenWords` property on `App.ApplicationController`
    will be updated live as the user types 'Lots of text that IS bound' into
    the text area of their browser's window.

    ```javascript
    App.ApplicationController = Ember.Controller.extend({
      writtenWords: "Lots of text that IS bound"
    });
    ```

    ```handlebars
    {{textarea value=writtenWords}}
    ```

     Would result in the following HTML:

    ```html
    <textarea class="ember-text-area">
      Lots of text that IS bound
    </textarea>
    ```

    If you wanted a one way binding between the text area and a div tag
    somewhere else on your screen, you could use `Ember.computed.oneWay`:

    ```javascript
    App.ApplicationController = Ember.Controller.extend({
      writtenWords: "Lots of text that IS bound",
      outputWrittenWords: Ember.computed.oneWay("writtenWords")
    });
    ```

    ```handlebars
    {{textarea value=writtenWords}}

    <div>
      {{outputWrittenWords}}
    </div>
    ```

    Would result in the following HTML:

    ```html
    <textarea class="ember-text-area">
      Lots of text that IS bound
    </textarea>

    <-- the following div will be updated in real time as you type -->

    <div>
      Lots of text that IS bound
    </div>
    ```

    Finally, this example really shows the power and ease of Ember when two
    properties are bound to eachother via `Ember.computed.alias`. Type into
    either text area box and they'll both stay in sync. Note that
    `Ember.computed.alias` costs more in terms of performance, so only use it when
    your really binding in both directions:

    ```javascript
    App.ApplicationController = Ember.Controller.extend({
      writtenWords: "Lots of text that IS bound",
      twoWayWrittenWords: Ember.computed.alias("writtenWords")
    });
    ```

    ```handlebars
    {{textarea value=writtenWords}}
    {{textarea value=twoWayWrittenWords}}
    ```

    ```html
    <textarea id="ember1" class="ember-text-area">
      Lots of text that IS bound
    </textarea>

    <-- both updated in real time -->

    <textarea id="ember2" class="ember-text-area">
      Lots of text that IS bound
    </textarea>
    ```

    ## Actions

    The helper can send multiple actions based on user events.

    The action property defines the action which is send when
    the user presses the return key.

    ```handlebars
    {{input action="submit"}}
    ```

    The helper allows some user events to send actions.

  * `enter`
  * `insert-newline`
  * `escape-press`
  * `focus-in`
  * `focus-out`
  * `key-press`

    For example, if you desire an action to be sent when the input is blurred,
    you only need to setup the action name to the event name property.

    ```handlebars
    {{textarea focus-in="alertMessage"}}
    ```

    See more about [Text Support Actions](/api/classes/Ember.TextArea.html)

    ## Extension

    Internally, `{{textarea}}` creates an instance of `Ember.TextArea`, passing
    arguments from the helper to `Ember.TextArea`'s `create` method. You can
    extend the capabilities of text areas in your application by reopening this
    class. For example, if you are building a Bootstrap project where `data-*`
    attributes are used, you can globally add support for a `data-*` attribute
    on all `{{textarea}}`s' in your app by reopening `Ember.TextArea` or
    `Ember.TextSupport` and adding it to the `attributeBindings` concatenated
    property:

    ```javascript
    Ember.TextArea.reopen({
      attributeBindings: ['data-error']
    });
    ```

    Keep in mind when writing `Ember.TextArea` subclasses that `Ember.TextArea`
    itself extends `Ember.Component`, meaning that it does NOT inherit
    the `controller` of the parent view.

    See more about [Ember components](/api/classes/Ember.Component.html)

    @method textarea
    @for Ember.Handlebars.helpers
    @param {Hash} options
  */
  function textareaHelper(params, hash, options, env) {
    
    return env.helpers.view.helperFunction.call(this, [TextArea['default']], hash, options, env);
  }

});
enifed('ember-htmlbars/helpers/unbound', ['exports', 'ember-metal/error', 'ember-metal/mixin', 'ember-metal/streams/utils', 'ember-htmlbars/system/lookup-helper'], function (exports, EmberError, mixin, utils, lookupHelper) {

  'use strict';

  exports.unboundHelper = unboundHelper;

  /**
  @module ember
  @submodule ember-htmlbars
  */

  /**
    `unbound` allows you to output a property without binding. *Important:* The
    output will not be updated if the property changes. Use with caution.

    ```handlebars
    <div>{{unbound somePropertyThatDoesntChange}}</div>
    ```

    `unbound` can also be used in conjunction with a bound helper to
    render it in its unbound form:

    ```handlebars
    <div>{{unbound helperName somePropertyThatDoesntChange}}</div>
    ```

    @method unbound
    @for Ember.Handlebars.helpers
    @param {String} property
    @return {String} HTML string
  */
  function unboundHelper(params, hash, options, env) {
    
    if (params.length === 1) {
      return utils.read(params[0]);
    } else {
      options.helperName = options.helperName || "unbound";

      var view = env.data.view;
      var helperName = params[0]._label;
      var helper = lookupHelper['default'](helperName, view, env);

      if (!helper) {
        throw new EmberError['default']("HTMLBars error: Could not find component or helper named " + helperName + ".");
      }

      return helper.helperFunction.call(this, readParams(params), readHash(hash, view), options, env);
    }
  }

  function readParams(params) {
    var l = params.length;
    var unboundParams = new Array(l - 1);

    for (var i = 1; i < l; i++) {
      unboundParams[i - 1] = utils.read(params[i]);
    }

    return unboundParams;
  }

  function readHash(hash, view) {
    var unboundHash = {};

    for (var prop in hash) {
      if (mixin.IS_BINDING.test(prop)) {
        var value = hash[prop];
        if (typeof value === "string") {
          value = view.getStream(value);
        }

        unboundHash[prop.slice(0, -7)] = utils.read(value);
      } else {
        unboundHash[prop] = utils.read(hash[prop]);
      }
    }

    return unboundHash;
  }

});
enifed('ember-htmlbars/helpers/view', ['exports', 'ember-metal/core', 'ember-metal/streams/utils', 'ember-views/streams/utils', 'ember-views/views/view', 'ember-htmlbars/system/merge-view-bindings', 'ember-htmlbars/system/append-templated-view'], function (exports, Ember, utils, streams__utils, View, mergeViewBindings, appendTemplatedView) {

  'use strict';

  exports.viewHelper = viewHelper;

  /**
    `{{view}}` inserts a new instance of an `Ember.View` into a template passing its
    options to the `Ember.View`'s `create` method and using the supplied block as
    the view's own template.

    An empty `<body>` and the following template:

    ```handlebars
    A span:
    {{#view tagName="span"}}
      hello.
    {{/view}}
    ```

    Will result in HTML structure:

    ```html
    <body>
      <!-- Note: the handlebars template script
           also results in a rendered Ember.View
           which is the outer <div> here -->

      <div class="ember-view">
        A span:
        <span id="ember1" class="ember-view">
          Hello.
        </span>
      </div>
    </body>
    ```

    ### `parentView` setting

    The `parentView` property of the new `Ember.View` instance created through
    `{{view}}` will be set to the `Ember.View` instance of the template where
    `{{view}}` was called.

    ```javascript
    aView = Ember.View.create({
      template: Ember.Handlebars.compile("{{#view}} my parent: {{parentView.elementId}} {{/view}}")
    });

    aView.appendTo('body');
    ```

    Will result in HTML structure:

    ```html
    <div id="ember1" class="ember-view">
      <div id="ember2" class="ember-view">
        my parent: ember1
      </div>
    </div>
    ```

    ### Setting CSS id and class attributes

    The HTML `id` attribute can be set on the `{{view}}`'s resulting element with
    the `id` option. This option will _not_ be passed to `Ember.View.create`.

    ```handlebars
    {{#view tagName="span" id="a-custom-id"}}
      hello.
    {{/view}}
    ```

    Results in the following HTML structure:

    ```html
    <div class="ember-view">
      <span id="a-custom-id" class="ember-view">
        hello.
      </span>
    </div>
    ```

    The HTML `class` attribute can be set on the `{{view}}`'s resulting element
    with the `class` or `classNameBindings` options. The `class` option will
    directly set the CSS `class` attribute and will not be passed to
    `Ember.View.create`. `classNameBindings` will be passed to `create` and use
    `Ember.View`'s class name binding functionality:

    ```handlebars
    {{#view tagName="span" class="a-custom-class"}}
      hello.
    {{/view}}
    ```

    Results in the following HTML structure:

    ```html
    <div class="ember-view">
      <span id="ember2" class="ember-view a-custom-class">
        hello.
      </span>
    </div>
    ```

    ### Supplying a different view class

    `{{view}}` can take an optional first argument before its supplied options to
    specify a path to a custom view class.

    ```handlebars
    {{#view "custom"}}{{! will look up App.CustomView }}
      hello.
    {{/view}}
    ```

    The first argument can also be a relative path accessible from the current
    context.

    ```javascript
    MyApp = Ember.Application.create({});
    MyApp.OuterView = Ember.View.extend({
      innerViewClass: Ember.View.extend({
        classNames: ['a-custom-view-class-as-property']
      }),
      template: Ember.Handlebars.compile('{{#view view.innerViewClass}} hi {{/view}}')
    });

    MyApp.OuterView.create().appendTo('body');
    ```

    Will result in the following HTML:

    ```html
    <div id="ember1" class="ember-view">
      <div id="ember2" class="ember-view a-custom-view-class-as-property">
        hi
      </div>
    </div>
    ```

    ### Blockless use

    If you supply a custom `Ember.View` subclass that specifies its own template
    or provide a `templateName` option to `{{view}}` it can be used without
    supplying a block. Attempts to use both a `templateName` option and supply a
    block will throw an error.

    ```javascript
    var App = Ember.Application.create();
    App.WithTemplateDefinedView = Ember.View.extend({
      templateName: 'defined-template'
    });
    ```

    ```handlebars
    {{! application.hbs }}
    {{view 'with-template-defined'}}
    ```

    ```handlebars
    {{! defined-template.hbs }}
    Some content for the defined template view.
    ```

    ### `viewName` property

    You can supply a `viewName` option to `{{view}}`. The `Ember.View` instance
    will be referenced as a property of its parent view by this name.

    ```javascript
    aView = Ember.View.create({
      template: Ember.Handlebars.compile('{{#view viewName="aChildByName"}} hi {{/view}}')
    });

    aView.appendTo('body');
    aView.get('aChildByName') // the instance of Ember.View created by {{view}} helper
    ```

    @method view
    @for Ember.Handlebars.helpers
  */
  function viewHelper(params, hash, options, env) {
    
    var view = env.data.view;
    var container = view.container || utils.read(view._keywords.view).container;
    var viewClassOrInstance;
    if (params.length === 0) {
      if (container) {
        viewClassOrInstance = container.lookupFactory("view:toplevel");
      } else {
        viewClassOrInstance = View['default'];
      }
    } else {
      viewClassOrInstance = streams__utils.readViewFactory(params[0], container);
    }

    var props = {
      helperName: options.helperName || "view"
    };

    if (options.template) {
      props.template = options.template;
    }

    mergeViewBindings['default'](view, props, hash);
    appendTemplatedView['default'](view, options.morph, viewClassOrInstance, props);
  }

});
enifed('ember-htmlbars/helpers/with', ['exports', 'ember-metal/core', 'ember-views/views/with_view'], function (exports, Ember, WithView) {

  'use strict';

  exports.withHelper = withHelper;

  /**
    Use the `{{with}}` helper when you want to aliases the to a new name. It's helpful
    for semantic clarity and to retain default scope or to reference from another
    `{{with}}` block.

    ```handlebars
    // posts might not be
    {{#with user.posts as |blogPosts|}}
      <div class="notice">
        There are {{blogPosts.length}} blog posts written by {{user.name}}.
      </div>

      {{#each blogPosts as |post|}}
        <li>{{post.title}}</li>
      {{/each}}
    {{/with}}
    ```

    Without the `as` operator, it would be impossible to reference `user.name` in the example above.

    NOTE: The alias should not reuse a name from the bound property path.
    For example: `{{#with foo as |foo.bar|}}` is not supported because it attempts to alias using
    the first part of the property path, `foo`. Instead, use `{{#with foo.bar as |baz|}}`.

    ### `controller` option

    Adding `controller='something'` instructs the `{{with}}` helper to create and use an instance of
    the specified controller wrapping the aliased keyword.

    This is very similar to using an `itemController` option with the `{{each}}` helper.

    ```handlebars
    {{#with users.posts controller='userBlogPosts' as |posts|}}
      {{!- `posts` is wrapped in our controller instance }}
    {{/with}}
    ```

    In the above example, the `posts` keyword is now wrapped in the `userBlogPost` controller,
    which provides an elegant way to decorate the context with custom
    functions/properties.

    @method with
    @for Ember.Handlebars.helpers
    @param {Function} context
    @param {Hash} options
    @return {String} HTML string
  */
  function withHelper(params, hash, options, env) {
    
    
    var view = env.data.view;
    var preserveContext;

    if (options.template.blockParams) {
      preserveContext = true;
    } else {
            preserveContext = false;
    }

    view.appendChild(WithView['default'], {
      _morph: options.morph,
      withValue: params[0],
      preserveContext: preserveContext,
      previousContext: view.get("context"),
      controllerName: hash.controller,
      mainTemplate: options.template,
      inverseTemplate: options.inverse,
      helperName: options.helperName || "with"
    });
  }

});
enifed('ember-htmlbars/helpers/yield', ['exports', 'ember-metal/core', 'ember-metal/property_get'], function (exports, Ember, property_get) {

  'use strict';

  exports.yieldHelper = yieldHelper;

  /**
    `{{yield}}` denotes an area of a template that will be rendered inside
    of another template. It has two main uses:

    ### Use with `layout`
    When used in a Handlebars template that is assigned to an `Ember.View`
    instance's `layout` property Ember will render the layout template first,
    inserting the view's own rendered output at the `{{yield}}` location.

    An empty `<body>` and the following application code:

    ```javascript
    AView = Ember.View.extend({
      classNames: ['a-view-with-layout'],
      layout: Ember.Handlebars.compile('<div class="wrapper">{{yield}}</div>'),
      template: Ember.Handlebars.compile('<span>I am wrapped</span>')
    });

    aView = AView.create();
    aView.appendTo('body');
    ```

    Will result in the following HTML output:

    ```html
    <body>
      <div class='ember-view a-view-with-layout'>
        <div class="wrapper">
          <span>I am wrapped</span>
        </div>
      </div>
    </body>
    ```

    The `yield` helper cannot be used outside of a template assigned to an
    `Ember.View`'s `layout` property and will throw an error if attempted.

    ```javascript
    BView = Ember.View.extend({
      classNames: ['a-view-with-layout'],
      template: Ember.Handlebars.compile('{{yield}}')
    });

    bView = BView.create();
    bView.appendTo('body');

    // throws
    // Uncaught Error: assertion failed:
    // You called yield in a template that was not a layout
    ```

    ### Use with Ember.Component
    When designing components `{{yield}}` is used to denote where, inside the component's
    template, an optional block passed to the component should render:

    ```handlebars
    <!-- application.hbs -->
    {{#labeled-textfield value=someProperty}}
      First name:
    {{/labeled-textfield}}
    ```

    ```handlebars
    <!-- components/labeled-textfield.hbs -->
    <label>
      {{yield}} {{input value=value}}
    </label>
    ```

    Result:

    ```html
    <label>
      First name: <input type="text" />
    </label>
    ```

    @method yield
    @for Ember.Handlebars.helpers
    @param {Hash} options
    @return {String} HTML string
  */
  function yieldHelper(params, hash, options, env) {
    var view = env.data.view;
    var layoutView = view;

    // Yea gods
    while (layoutView && !property_get.get(layoutView, "layout")) {
      if (layoutView._contextView) {
        layoutView = layoutView._contextView;
      } else {
        layoutView = layoutView._parentView;
      }
    }

    
    return layoutView._yield(view, env, options.morph, params);
  }

});
enifed('ember-htmlbars/hooks/attribute', ['exports', 'ember-views/attr_nodes/attr_node', 'ember-metal/error', 'ember-metal/streams/utils', 'morph-attr/sanitize-attribute-value'], function (exports, AttrNode, EmberError, utils, sanitizeAttributeValue) {

  'use strict';



  exports['default'] = attribute;
  /**
  @module ember
  @submodule ember-htmlbars
  */

  var boundAttributesEnabled = false;

  
    boundAttributesEnabled = true;
  
  function attribute(env, morph, element, attrName, attrValue) {
    if (boundAttributesEnabled) {
      var attrNode = new AttrNode['default'](attrName, attrValue);
      attrNode._morph = morph;
      env.data.view.appendChild(attrNode);
    } else {
      if (utils.isStream(attrValue)) {
        throw new EmberError['default']("Bound attributes are not yet supported in Ember.js");
      } else {
        var sanitizedValue = sanitizeAttributeValue['default'](env.dom, element, attrName, attrValue);
        env.dom.setProperty(element, attrName, sanitizedValue);
      }
    }
  }

});
enifed('ember-htmlbars/hooks/block', ['exports', 'ember-views/views/simple_bound_view', 'ember-metal/streams/utils', 'ember-htmlbars/system/lookup-helper'], function (exports, simple_bound_view, utils, lookupHelper) {

  'use strict';



  exports['default'] = block;
  /**
  @module ember
  @submodule ember-htmlbars
  */

  function block(env, morph, view, path, params, hash, template, inverse) {
    var helper = lookupHelper['default'](path, view, env);

    
    var options = {
      morph: morph,
      template: template,
      inverse: inverse,
      isBlock: true
    };
    var result = helper.helperFunction.call(undefined, params, hash, options, env);

    if (utils.isStream(result)) {
      simple_bound_view.appendSimpleBoundView(view, morph, result);
    } else {
      morph.setContent(result);
    }
  }

});
enifed('ember-htmlbars/hooks/component', ['exports', 'ember-metal/core', 'ember-htmlbars/system/lookup-helper'], function (exports, Ember, lookupHelper) {

  'use strict';



  exports['default'] = component;
  /**
  @module ember
  @submodule ember-htmlbars
  */

  function component(env, morph, view, tagName, attrs, template) {
    var helper = lookupHelper['default'](tagName, view, env);

    
    return helper.helperFunction.call(undefined, [], attrs, { morph: morph, template: template }, env);
  }

});
enifed('ember-htmlbars/hooks/concat', ['exports', 'ember-metal/streams/utils'], function (exports, utils) {

  'use strict';



  exports['default'] = concat;
  /**
  @module ember
  @submodule ember-htmlbars
  */

  function concat(env, parts) {
    return utils.concat(parts, "");
  }

});
enifed('ember-htmlbars/hooks/content', ['exports', 'ember-views/views/simple_bound_view', 'ember-metal/streams/utils', 'ember-htmlbars/system/lookup-helper'], function (exports, simple_bound_view, utils, lookupHelper) {

  'use strict';



  exports['default'] = content;
  /**
  @module ember
  @submodule ember-htmlbars
  */

  function content(env, morph, view, path) {
    var helper = lookupHelper['default'](path, view, env);
    var result;

    if (helper) {
      var options = {
        morph: morph,
        isInline: true
      };
      result = helper.helperFunction.call(undefined, [], {}, options, env);
    } else {
      result = view.getStream(path);
    }

    if (utils.isStream(result)) {
      simple_bound_view.appendSimpleBoundView(view, morph, result);
    } else {
      morph.setContent(result);
    }
  }

});
enifed('ember-htmlbars/hooks/element', ['exports', 'ember-metal/core', 'ember-metal/streams/utils', 'ember-htmlbars/system/lookup-helper'], function (exports, Ember, utils, lookupHelper) {

  'use strict';



  exports['default'] = element;
  /**
  @module ember
  @submodule ember-htmlbars
  */

  function element(env, domElement, view, path, params, hash) {
    //jshint ignore:line
    var helper = lookupHelper['default'](path, view, env);
    var valueOrLazyValue;

    if (helper) {
      var options = {
        element: domElement
      };
      valueOrLazyValue = helper.helperFunction.call(undefined, params, hash, options, env);
    } else {
      valueOrLazyValue = view.getStream(path);
    }

    var value = utils.read(valueOrLazyValue);
    if (value) {
      
      var parts = value.toString().split(/\s+/);
      for (var i = 0, l = parts.length; i < l; i++) {
        var attrParts = parts[i].split("=");
        var attrName = attrParts[0];
        var attrValue = attrParts[1];

        attrValue = attrValue.replace(/^['"]/, "").replace(/['"]$/, "");

        env.dom.setAttribute(domElement, attrName, attrValue);
      }
    }
  }

});
enifed('ember-htmlbars/hooks/get', ['exports'], function (exports) {

  'use strict';

  /**
  @module ember
  @submodule ember-htmlbars
  */

  exports['default'] = get;

  function get(env, view, path) {
    return view.getStream(path);
  }

});
enifed('ember-htmlbars/hooks/inline', ['exports', 'ember-views/views/simple_bound_view', 'ember-metal/streams/utils', 'ember-htmlbars/system/lookup-helper'], function (exports, simple_bound_view, utils, lookupHelper) {

  'use strict';



  exports['default'] = inline;
  /**
  @module ember
  @submodule ember-htmlbars
  */

  function inline(env, morph, view, path, params, hash) {
    var helper = lookupHelper['default'](path, view, env);

    
    var result = helper.helperFunction.call(undefined, params, hash, { morph: morph }, env);

    if (utils.isStream(result)) {
      simple_bound_view.appendSimpleBoundView(view, morph, result);
    } else {
      morph.setContent(result);
    }
  }

});
enifed('ember-htmlbars/hooks/set', ['exports'], function (exports) {

  'use strict';

  /**
  @module ember
  @submodule ember-htmlbars
  */

  exports['default'] = set;

  function set(env, view, name, value) {
    view._keywords[name] = value;
  }

});
enifed('ember-htmlbars/hooks/subexpr', ['exports', 'ember-htmlbars/system/lookup-helper'], function (exports, lookupHelper) {

  'use strict';



  exports['default'] = subexpr;
  /**
  @module ember
  @submodule ember-htmlbars
  */

  function subexpr(env, view, path, params, hash) {
    var helper = lookupHelper['default'](path, view, env);

    
    var options = {
      isInline: true
    };
    return helper.helperFunction.call(undefined, params, hash, options, env);
  }

});
enifed('ember-htmlbars/system/append-templated-view', ['exports', 'ember-metal/core', 'ember-metal/property_get', 'ember-views/views/view'], function (exports, Ember, property_get, View) {

  'use strict';



  exports['default'] = appendTemplatedView;
  /**
  @module ember
  @submodule ember-htmlbars
  */

  function appendTemplatedView(parentView, morph, viewClassOrInstance, props) {
    var viewProto;
    if (View['default'].detectInstance(viewClassOrInstance)) {
      viewProto = viewClassOrInstance;
    } else {
      viewProto = viewClassOrInstance.proto();
    }

    
    // We only want to override the `_context` computed property if there is
    // no specified controller. See View#_context for more information.

    var noControllerInProto = !viewProto.controller;
    if (viewProto.controller && viewProto.controller.isDescriptor) {
      noControllerInProto = true;
    }
    if (noControllerInProto && !viewProto.controllerBinding && !props.controller && !props.controllerBinding) {
      props._context = property_get.get(parentView, "context"); // TODO: is this right?!
    }

    props._morph = morph;

    return parentView.appendChild(viewClassOrInstance, props);
  }

});
enifed('ember-htmlbars/system/bootstrap', ['exports', 'ember-metal/core', 'ember-views/component_lookup', 'ember-views/system/jquery', 'ember-metal/error', 'ember-runtime/system/lazy_load', 'ember-template-compiler/system/compile', 'ember-metal/environment'], function (exports, Ember, ComponentLookup, jQuery, EmberError, lazy_load, htmlbarsCompile, environment) {

  'use strict';

  /*globals Handlebars */

  /**
  @module ember
  @submodule ember-htmlbars
  */

  function bootstrap(ctx) {
    var selectors = "script[type=\"text/x-handlebars\"], script[type=\"text/x-raw-handlebars\"]";

    jQuery['default'](selectors, ctx).each(function () {
      // Get a reference to the script tag
      var script = jQuery['default'](this);

      var compile = script.attr("type") === "text/x-raw-handlebars" ? jQuery['default'].proxy(Handlebars.compile, Handlebars) : htmlbarsCompile['default'];
      // Get the name of the script, used by Ember.View's templateName property.
      // First look for data-template-name attribute, then fall back to its
      // id if no name is found.
      var templateName = script.attr("data-template-name") || script.attr("id") || "application";
      var template = compile(script.html());

      // Check if template of same name already exists
      if (Ember['default'].TEMPLATES[templateName] !== undefined) {
        throw new EmberError['default']("Template named \"" + templateName + "\" already exists.");
      }

      // For templates which have a name, we save them and then remove them from the DOM
      Ember['default'].TEMPLATES[templateName] = template;

      // Remove script tag from DOM
      script.remove();
    });
  }

  function _bootstrap() {
    bootstrap(jQuery['default'](document));
  }

  function registerComponentLookup(registry) {
    registry.register("component-lookup:main", ComponentLookup['default']);
  }

  /*
    We tie this to application.load to ensure that we've at least
    attempted to bootstrap at the point that the application is loaded.

    We also tie this to document ready since we're guaranteed that all
    the inline templates are present at this point.

    There's no harm to running this twice, since we remove the templates
    from the DOM after processing.
  */

  lazy_load.onLoad("Ember.Application", function (Application) {
    Application.initializer({
      name: "domTemplates",
      initialize: environment['default'].hasDOM ? _bootstrap : function () {}
    });

    Application.initializer({
      name: "registerComponentLookup",
      after: "domTemplates",
      initialize: registerComponentLookup
    });
  });

  exports['default'] = bootstrap;

});
enifed('ember-htmlbars/system/helper', ['exports'], function (exports) {

  'use strict';

  /**
  @module ember
  @submodule ember-htmlbars
  */

  /**
    @class Helper
    @namespace Ember.HTMLBars
  */
  function Helper(helper) {
    this.helperFunction = helper;

    this.isHelper = true;
    this.isHTMLBars = true;
  }

  exports['default'] = Helper;

});
enifed('ember-htmlbars/system/lookup-helper', ['exports', 'ember-metal/core', 'ember-metal/cache', 'ember-htmlbars/system/make-view-helper', 'ember-htmlbars/compat/helper'], function (exports, Ember, Cache, makeViewHelper, HandlebarsCompatibleHelper) {

  'use strict';

  /**
    Used to lookup/resolve handlebars helpers. The lookup order is:

    * Look for a registered helper
    * If a dash exists in the name:
      * Look for a helper registed in the container
      * Use Ember.ComponentLookup to find an Ember.Component that resolves
        to the given name

    @private
    @method resolveHelper
    @param {Container} container
    @param {String} name the name of the helper to lookup
    @return {Handlebars Helper}
  */
  exports['default'] = lookupHelper;
  /**
  @module ember
  @submodule ember-htmlbars
  */

  var ISNT_HELPER_CACHE = new Cache['default'](1000, function (key) {
    return key.indexOf("-") === -1;
  });function lookupHelper(name, view, env) {
    var helper = env.helpers[name];
    if (helper) {
      return helper;
    }

    var container = view.container;

    if (!container || ISNT_HELPER_CACHE.get(name)) {
      return;
    }

    var helperName = "helper:" + name;
    helper = container.lookup(helperName);
    if (!helper) {
      var componentLookup = container.lookup("component-lookup:main");
      
      var Component = componentLookup.lookupFactory(name, container);
      if (Component) {
        helper = makeViewHelper['default'](Component);
        container._registry.register(helperName, helper);
      }
    }

    if (helper && !helper.isHTMLBars) {
      helper = new HandlebarsCompatibleHelper['default'](helper);
      container._registry.unregister(helperName);
      container._registry.register(helperName, helper);
    }

    return helper;
  }

  exports.ISNT_HELPER_CACHE = ISNT_HELPER_CACHE;

});
enifed('ember-htmlbars/system/make-view-helper', ['exports', 'ember-metal/core', 'ember-htmlbars/system/helper'], function (exports, Ember, Helper) {

  'use strict';



  /**
    Returns a helper function that renders the provided ViewClass.

    Used internally by Ember.Handlebars.helper and other methods
    involving helper/component registration.

    @private
    @method makeViewHelper
    @param {Function} ViewClass view class constructor
    @since 1.2.0
  */
  exports['default'] = makeViewHelper;
  /**
  @module ember
  @submodule ember-htmlbars
  */

  function makeViewHelper(ViewClass) {
    function helperFunc(params, hash, options, env) {
      
      return env.helpers.view.helperFunction.call(this, [ViewClass], hash, options, env);
    }

    return new Helper['default'](helperFunc);
  }

});
enifed('ember-htmlbars/system/make_bound_helper', ['exports', 'ember-metal/core', 'ember-htmlbars/system/helper', 'ember-metal/streams/stream', 'ember-metal/streams/utils'], function (exports, Ember, Helper, Stream, utils) {

  'use strict';



  /**
    Create a bound helper. Accepts a function that receives the ordered and hash parameters
    from the template. If a bound property was provided in the template it will be resolved to its
    value and any changes to the bound property cause the helper function to be re-run with the updated
    values.

    * `params` - An array of resolved ordered parameters.
    * `hash` - An object containing the hash parameters.

    For example:

    * With an unquoted ordered parameter:

      ```javascript
      {{x-capitalize foo}}
      ```

      Assuming `foo` was set to `"bar"`, the bound helper would receive `["bar"]` as its first argument, and
      an empty hash as its second.

    * With a quoted ordered parameter:

      ```javascript
      {{x-capitalize "foo"}}
      ```

      The bound helper would receive `["foo"]` as its first argument, and an empty hash as its second.

    * With an unquoted hash parameter:

      ```javascript
      {{x-repeat "foo" count=repeatCount}}
      ```

      Assuming that `repeatCount` resolved to 2, the bound helper would receive `["foo"]` as its first argument,
      and { count: 2 } as its second.

    @private
    @method makeBoundHelper
    @for Ember.HTMLBars
    @param {Function} function
    @since 1.10.0
  */
  exports['default'] = makeBoundHelper;
  /**
  @module ember
  @submodule ember-htmlbars
  */

  function makeBoundHelper(fn) {
    function helperFunc(params, hash, options, env) {
      var view = env.data.view;
      var numParams = params.length;
      var param, prop;

      
      function valueFn() {
        return fn.call(view, utils.readArray(params), utils.readHash(hash), options, env);
      }

      // If none of the hash parameters are bound, act as an unbound helper.
      // This prevents views from being unnecessarily created
      var hasStream = utils.scanArray(params) || utils.scanHash(hash);
      if (hasStream) {
        var lazyValue = new Stream['default'](valueFn);

        for (var i = 0; i < numParams; i++) {
          param = params[i];
          utils.subscribe(param, lazyValue.notify, lazyValue);
        }

        for (prop in hash) {
          param = hash[prop];
          utils.subscribe(param, lazyValue.notify, lazyValue);
        }

        return lazyValue;
      } else {
        return valueFn();
      }
    }

    return new Helper['default'](helperFunc);
  }

});
enifed('ember-htmlbars/system/merge-view-bindings', ['exports', 'ember-metal/core', 'ember-metal/mixin', 'ember-metal/streams/simple', 'ember-metal/streams/utils', 'ember-views/streams/class_name_binding'], function (exports, Ember, mixin, SimpleStream, utils, class_name_binding) {

  'use strict';



  exports['default'] = mergeViewBindings;

  var a_push = Array.prototype.push;
  function mergeViewBindings(view, props, hash) {
    mergeGenericViewBindings(view, props, hash);
    mergeDOMViewBindings(view, props, hash);
    return props;
  }

  function mergeGenericViewBindings(view, props, hash) {
    for (var key in hash) {
      if (key === "id" || key === "tag" || key === "class" || key === "classBinding" || key === "classNameBindings" || key === "attributeBindings") {
        continue;
      }

      var value = hash[key];

      if (mixin.IS_BINDING.test(key)) {
        if (typeof value === "string") {
          
          props[key] = view._getBindingForStream(value);
        } else if (utils.isStream(value)) {
          
          props[key] = view._getBindingForStream(value);
        } else {
          props[key] = value;
        }
      } else {
        if (utils.isStream(value)) {
          props[key + "Binding"] = view._getBindingForStream(value);
        } else {
          props[key] = value;
        }
      }
    }
  }

  function mergeDOMViewBindings(view, props, hash) {
    
    if (hash.id) {
      props.id = props.elementId = utils.read(hash.id);
    }

    if (hash.tag) {
      props.tagName = utils.read(hash.tag);
    }

    var classBindings = [];

    if (hash["class"]) {
      if (typeof hash["class"] === "string") {
        props.classNames = hash["class"].split(" ");
      } else if (hash["class"]._label) {
        // label exists for via property paths in the template
        // but not for streams with nested sub-expressions
        classBindings.push(hash["class"]._label);
      } else {
        // this stream did not have a label which means that
        // it is not a simple property path type stream (likely
        // the result of a sub-expression)
        classBindings.push(hash["class"]);
      }
    }

    if (hash.classBinding) {
      a_push.apply(classBindings, hash.classBinding.split(" "));
    }

    if (hash.classNameBindings) {
      a_push.apply(classBindings, hash.classNameBindings.split(" "));
    }

    if (classBindings.length > 0) {
      props.classNameBindings = classBindings;

      for (var i = 0; i < classBindings.length; i++) {
        var initialValue = classBindings[i];
        var classBinding;

        if (utils.isStream(initialValue)) {
          classBinding = initialValue;
        } else {
          classBinding = class_name_binding.streamifyClassNameBinding(view, initialValue);
        }

        if (utils.isStream(classBinding)) {
          classBindings[i] = classBinding;
        } else {
          classBindings[i] = new SimpleStream['default'](classBinding);
        }
      }
    }
  }

});
enifed('ember-htmlbars/system/render-view', ['exports', 'ember-metal/core', 'ember-metal/property_get', 'ember-htmlbars/env'], function (exports, Ember, property_get, defaultEnv) {

  'use strict';



  exports['default'] = renderView;

  function renderView(view, buffer, template) {
    if (!template) {
      return;
    }

    var output;

    if (template.isHTMLBars) {
            output = renderHTMLBarsTemplate(view, buffer, template);
    } else {
            output = renderLegacyTemplate(view, buffer, template);
    }

    if (output !== undefined) {
      buffer.push(output);
    }
  }

  function renderHTMLBarsTemplate(view, buffer, template) {
    
    var contextualElement = buffer.innerContextualElement();
    var args = view._blockArguments;
    var env = {
      view: this,
      dom: view.renderer._dom,
      hooks: defaultEnv['default'].hooks,
      helpers: defaultEnv['default'].helpers,
      useFragmentCache: defaultEnv['default'].useFragmentCache,
      data: {
        view: view,
        buffer: buffer
      }
    };

    return template.render(view, env, contextualElement, args);
  }

  function renderLegacyTemplate(view, buffer, template) {
    var context = property_get.get(view, "context");
    var options = {
      data: {
        view: view,
        buffer: buffer
      }
    };

    return template(context, options);
  }

});
enifed('ember-htmlbars/templates/component', ['exports', 'ember-template-compiler/system/template'], function (exports, template) {

  'use strict';

  exports['default'] = template['default']((function () {
    return {
      isHTMLBars: true,
      revision: "Ember@1.12.0",
      blockParams: 0,
      cachedFragment: null,
      hasRendered: false,
      build: function build(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      render: function render(context, env, contextualElement) {
        var dom = env.dom;
        var hooks = env.hooks,
            content = hooks.content;
        dom.detectNamespace(contextualElement);
        var fragment;
        if (env.useFragmentCache && dom.canClone) {
          if (this.cachedFragment === null) {
            fragment = this.build(dom);
            if (this.hasRendered) {
              this.cachedFragment = fragment;
            } else {
              this.hasRendered = true;
            }
          }
          if (this.cachedFragment) {
            fragment = dom.cloneNode(this.cachedFragment, true);
          }
        } else {
          fragment = this.build(dom);
        }
        var morph0 = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, null);
        dom.insertBoundary(fragment, 0);
        content(env, morph0, context, "yield");
        return fragment;
      }
    };
  })());

});
enifed('ember-htmlbars/templates/empty', ['exports', 'ember-template-compiler/system/template'], function (exports, template) {

  'use strict';

  exports['default'] = template['default']((function () {
    return {
      isHTMLBars: true,
      revision: "Ember@1.12.0",
      blockParams: 0,
      cachedFragment: null,
      hasRendered: false,
      build: function build(dom) {
        var el0 = dom.createDocumentFragment();
        return el0;
      },
      render: function render(context, env, contextualElement) {
        var dom = env.dom;
        dom.detectNamespace(contextualElement);
        var fragment;
        if (env.useFragmentCache && dom.canClone) {
          if (this.cachedFragment === null) {
            fragment = this.build(dom);
            if (this.hasRendered) {
              this.cachedFragment = fragment;
            } else {
              this.hasRendered = true;
            }
          }
          if (this.cachedFragment) {
            fragment = dom.cloneNode(this.cachedFragment, true);
          }
        } else {
          fragment = this.build(dom);
        }
        return fragment;
      }
    };
  })());

});
enifed('ember-htmlbars/templates/link-to-escaped', ['exports', 'ember-template-compiler/system/template'], function (exports, template) {

  'use strict';

  exports['default'] = template['default']((function () {
    return {
      isHTMLBars: true,
      revision: "Ember@1.12.0",
      blockParams: 0,
      cachedFragment: null,
      hasRendered: false,
      build: function build(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      render: function render(context, env, contextualElement) {
        var dom = env.dom;
        var hooks = env.hooks,
            content = hooks.content;
        dom.detectNamespace(contextualElement);
        var fragment;
        if (env.useFragmentCache && dom.canClone) {
          if (this.cachedFragment === null) {
            fragment = this.build(dom);
            if (this.hasRendered) {
              this.cachedFragment = fragment;
            } else {
              this.hasRendered = true;
            }
          }
          if (this.cachedFragment) {
            fragment = dom.cloneNode(this.cachedFragment, true);
          }
        } else {
          fragment = this.build(dom);
        }
        var morph0 = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, null);
        dom.insertBoundary(fragment, 0);
        content(env, morph0, context, "linkTitle");
        return fragment;
      }
    };
  })());

});
enifed('ember-htmlbars/templates/link-to-unescaped', ['exports', 'ember-template-compiler/system/template'], function (exports, template) {

  'use strict';

  exports['default'] = template['default']((function () {
    return {
      isHTMLBars: true,
      revision: "Ember@1.12.0",
      blockParams: 0,
      cachedFragment: null,
      hasRendered: false,
      build: function build(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      render: function render(context, env, contextualElement) {
        var dom = env.dom;
        var hooks = env.hooks,
            content = hooks.content;
        dom.detectNamespace(contextualElement);
        var fragment;
        if (env.useFragmentCache && dom.canClone) {
          if (this.cachedFragment === null) {
            fragment = this.build(dom);
            if (this.hasRendered) {
              this.cachedFragment = fragment;
            } else {
              this.hasRendered = true;
            }
          }
          if (this.cachedFragment) {
            fragment = dom.cloneNode(this.cachedFragment, true);
          }
        } else {
          fragment = this.build(dom);
        }
        var morph0 = dom.createUnsafeMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, null);
        dom.insertBoundary(fragment, 0);
        content(env, morph0, context, "linkTitle");
        return fragment;
      }
    };
  })());

});
enifed('ember-htmlbars/templates/select-option', ['exports', 'ember-template-compiler/system/template'], function (exports, template) {

  'use strict';

  exports['default'] = template['default']((function () {
    return {
      isHTMLBars: true,
      revision: "Ember@1.12.0",
      blockParams: 0,
      cachedFragment: null,
      hasRendered: false,
      build: function build(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      render: function render(context, env, contextualElement) {
        var dom = env.dom;
        var hooks = env.hooks,
            content = hooks.content;
        dom.detectNamespace(contextualElement);
        var fragment;
        if (env.useFragmentCache && dom.canClone) {
          if (this.cachedFragment === null) {
            fragment = this.build(dom);
            if (this.hasRendered) {
              this.cachedFragment = fragment;
            } else {
              this.hasRendered = true;
            }
          }
          if (this.cachedFragment) {
            fragment = dom.cloneNode(this.cachedFragment, true);
          }
        } else {
          fragment = this.build(dom);
        }
        var morph0 = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, null);
        dom.insertBoundary(fragment, 0);
        content(env, morph0, context, "view.label");
        return fragment;
      }
    };
  })());

});
enifed('ember-htmlbars/templates/select', ['exports', 'ember-template-compiler/system/template'], function (exports, template) {

  'use strict';

  exports['default'] = template['default']((function () {
    var child0 = (function () {
      return {
        isHTMLBars: true,
        revision: "Ember@1.12.0",
        blockParams: 0,
        cachedFragment: null,
        hasRendered: false,
        build: function build(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createElement("option");
          dom.setAttribute(el1, "value", "");
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          return el0;
        },
        render: function render(context, env, contextualElement) {
          var dom = env.dom;
          var hooks = env.hooks,
              content = hooks.content;
          dom.detectNamespace(contextualElement);
          var fragment;
          if (env.useFragmentCache && dom.canClone) {
            if (this.cachedFragment === null) {
              fragment = this.build(dom);
              if (this.hasRendered) {
                this.cachedFragment = fragment;
              } else {
                this.hasRendered = true;
              }
            }
            if (this.cachedFragment) {
              fragment = dom.cloneNode(this.cachedFragment, true);
            }
          } else {
            fragment = this.build(dom);
          }
          var morph0 = dom.createMorphAt(dom.childAt(fragment, [0]), 0, 0);
          content(env, morph0, context, "view.prompt");
          return fragment;
        }
      };
    })();
    var child1 = (function () {
      var child0 = (function () {
        return {
          isHTMLBars: true,
          revision: "Ember@1.12.0",
          blockParams: 0,
          cachedFragment: null,
          hasRendered: false,
          build: function build(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            return el0;
          },
          render: function render(context, env, contextualElement) {
            var dom = env.dom;
            var hooks = env.hooks,
                get = hooks.get,
                inline = hooks.inline;
            dom.detectNamespace(contextualElement);
            var fragment;
            if (env.useFragmentCache && dom.canClone) {
              if (this.cachedFragment === null) {
                fragment = this.build(dom);
                if (this.hasRendered) {
                  this.cachedFragment = fragment;
                } else {
                  this.hasRendered = true;
                }
              }
              if (this.cachedFragment) {
                fragment = dom.cloneNode(this.cachedFragment, true);
              }
            } else {
              fragment = this.build(dom);
            }
            var morph0 = dom.createMorphAt(fragment, 0, 0, contextualElement);
            dom.insertBoundary(fragment, null);
            dom.insertBoundary(fragment, 0);
            inline(env, morph0, context, "view", [get(env, context, "view.groupView")], { "content": get(env, context, "group.content"), "label": get(env, context, "group.label") });
            return fragment;
          }
        };
      })();
      return {
        isHTMLBars: true,
        revision: "Ember@1.12.0",
        blockParams: 0,
        cachedFragment: null,
        hasRendered: false,
        build: function build(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        render: function render(context, env, contextualElement) {
          var dom = env.dom;
          var hooks = env.hooks,
              get = hooks.get,
              block = hooks.block;
          dom.detectNamespace(contextualElement);
          var fragment;
          if (env.useFragmentCache && dom.canClone) {
            if (this.cachedFragment === null) {
              fragment = this.build(dom);
              if (this.hasRendered) {
                this.cachedFragment = fragment;
              } else {
                this.hasRendered = true;
              }
            }
            if (this.cachedFragment) {
              fragment = dom.cloneNode(this.cachedFragment, true);
            }
          } else {
            fragment = this.build(dom);
          }
          var morph0 = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, null);
          dom.insertBoundary(fragment, 0);
          block(env, morph0, context, "each", [get(env, context, "view.groupedContent")], { "keyword": "group" }, child0, null);
          return fragment;
        }
      };
    })();
    var child2 = (function () {
      var child0 = (function () {
        return {
          isHTMLBars: true,
          revision: "Ember@1.12.0",
          blockParams: 0,
          cachedFragment: null,
          hasRendered: false,
          build: function build(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            return el0;
          },
          render: function render(context, env, contextualElement) {
            var dom = env.dom;
            var hooks = env.hooks,
                get = hooks.get,
                inline = hooks.inline;
            dom.detectNamespace(contextualElement);
            var fragment;
            if (env.useFragmentCache && dom.canClone) {
              if (this.cachedFragment === null) {
                fragment = this.build(dom);
                if (this.hasRendered) {
                  this.cachedFragment = fragment;
                } else {
                  this.hasRendered = true;
                }
              }
              if (this.cachedFragment) {
                fragment = dom.cloneNode(this.cachedFragment, true);
              }
            } else {
              fragment = this.build(dom);
            }
            var morph0 = dom.createMorphAt(fragment, 0, 0, contextualElement);
            dom.insertBoundary(fragment, null);
            dom.insertBoundary(fragment, 0);
            inline(env, morph0, context, "view", [get(env, context, "view.optionView")], { "content": get(env, context, "item") });
            return fragment;
          }
        };
      })();
      return {
        isHTMLBars: true,
        revision: "Ember@1.12.0",
        blockParams: 0,
        cachedFragment: null,
        hasRendered: false,
        build: function build(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        render: function render(context, env, contextualElement) {
          var dom = env.dom;
          var hooks = env.hooks,
              get = hooks.get,
              block = hooks.block;
          dom.detectNamespace(contextualElement);
          var fragment;
          if (env.useFragmentCache && dom.canClone) {
            if (this.cachedFragment === null) {
              fragment = this.build(dom);
              if (this.hasRendered) {
                this.cachedFragment = fragment;
              } else {
                this.hasRendered = true;
              }
            }
            if (this.cachedFragment) {
              fragment = dom.cloneNode(this.cachedFragment, true);
            }
          } else {
            fragment = this.build(dom);
          }
          var morph0 = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, null);
          dom.insertBoundary(fragment, 0);
          block(env, morph0, context, "each", [get(env, context, "view.content")], { "keyword": "item" }, child0, null);
          return fragment;
        }
      };
    })();
    return {
      isHTMLBars: true,
      revision: "Ember@1.12.0",
      blockParams: 0,
      cachedFragment: null,
      hasRendered: false,
      build: function build(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      render: function render(context, env, contextualElement) {
        var dom = env.dom;
        var hooks = env.hooks,
            get = hooks.get,
            block = hooks.block;
        dom.detectNamespace(contextualElement);
        var fragment;
        if (env.useFragmentCache && dom.canClone) {
          if (this.cachedFragment === null) {
            fragment = this.build(dom);
            if (this.hasRendered) {
              this.cachedFragment = fragment;
            } else {
              this.hasRendered = true;
            }
          }
          if (this.cachedFragment) {
            fragment = dom.cloneNode(this.cachedFragment, true);
          }
        } else {
          fragment = this.build(dom);
        }
        var morph0 = dom.createMorphAt(fragment, 0, 0, contextualElement);
        var morph1 = dom.createMorphAt(fragment, 1, 1, contextualElement);
        dom.insertBoundary(fragment, 0);
        block(env, morph0, context, "if", [get(env, context, "view.prompt")], {}, child0, null);
        block(env, morph1, context, "if", [get(env, context, "view.optionGroupPath")], {}, child1, child2);
        return fragment;
      }
    };
  })());

});
enifed('ember-htmlbars/utils/string', ['exports', 'htmlbars-util', 'ember-runtime/system/string'], function (exports, htmlbars_util, EmberStringUtils) {

  'use strict';

  exports.htmlSafe = htmlSafe;

  /**
  @module ember
  @submodule ember-htmlbars
  */

  // required so we can extend this object.
  function htmlSafe(str) {
    if (str === null || str === undefined) {
      return "";
    }

    if (typeof str !== "string") {
      str = "" + str;
    }
    return new htmlbars_util.SafeString(str);
  }

  EmberStringUtils['default'].htmlSafe = htmlSafe;
  if (Ember.EXTEND_PROTOTYPES === true || Ember.EXTEND_PROTOTYPES.String) {

    /**
      Mark a string as being safe for unescaped output with Handlebars.
       ```javascript
      '<div>someString</div>'.htmlSafe()
      ```
       See [Ember.String.htmlSafe](/api/classes/Ember.String.html#method_htmlSafe).
       @method htmlSafe
      @for String
      @return {Handlebars.SafeString} a string that will not be html escaped by Handlebars
    */
    String.prototype.htmlSafe = function () {
      return htmlSafe(this);
    };
  }

  exports.SafeString = htmlbars_util.SafeString;
  exports.escapeExpression = htmlbars_util.escapeExpression;

});
enifed('ember-metal-views', ['exports', 'ember-metal-views/renderer'], function (exports, Renderer) {

	'use strict';



	exports.Renderer = Renderer['default'];

});
enifed('ember-metal-views/renderer', ['exports', 'dom-helper', 'ember-metal/environment'], function (exports, DOMHelper, environment) {

  'use strict';

  var domHelper = environment['default'].hasDOM ? new DOMHelper['default']() : null;

  function Renderer(_helper, _destinedForDOM) {
    this._uuid = 0;

    // These sizes and values are somewhat arbitrary (but sensible)
    // pre-allocation defaults.
    this._views = new Array(2000);
    this._queue = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
    this._parents = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
    this._elements = new Array(17);
    this._inserts = {};
    this._dom = _helper || domHelper;
    this._destinedForDOM = _destinedForDOM === undefined ? true : _destinedForDOM;
  }

  function Renderer_renderTree(_view, _parentView, _refMorph) {
    var views = this._views;
    views[0] = _view;
    var index = 0;
    var total = 1;
    var levelBase = _parentView ? _parentView._level + 1 : 0;

    var root = _parentView == null ? _view : _parentView._root;

    // if root view has a _morph assigned
    var willInsert = !!root._morph;

    var queue = this._queue;
    queue[0] = 0;
    var length = 1;

    var parentIndex = -1;
    var parents = this._parents;
    var parent = _parentView || null;
    var elements = this._elements;
    var element = null;
    var contextualElement = null;
    var level = 0;

    var view = _view;
    var children, i, child;
    while (length) {
      elements[level] = element;
      if (!view._morph) {
        // ensure props we add are in same order
        view._morph = null;
      }
      view._root = root;
      this.uuid(view);
      view._level = levelBase + level;
      if (view._elementCreated) {
        this.remove(view, false, true);
      }

      this.willCreateElement(view);

      contextualElement = view._morph && view._morph.contextualElement;
      if (!contextualElement && parent && parent._childViewsMorph) {
        contextualElement = parent._childViewsMorph.contextualElement;
      }
      if (!contextualElement && view._didCreateElementWithoutMorph) {
        // This code path is used by view.createElement(), which has two purposes:
        //
        // 1. Legacy usage of `createElement()`. Nobody really knows what the point
        //    of that is. This usage may be removed in Ember 2.0.
        // 2. FastBoot, which creates an element and has no DOM to insert it into.
        //
        // For FastBoot purposes, rendering the DOM without a contextual element
        // should work fine, because it essentially re-emits the original markup
        // as a String, which will then be parsed again by the browser, which will
        // apply the appropriate parsing rules.
        contextualElement = typeof document !== "undefined" ? document.body : null;
      }
      element = this.createElement(view, contextualElement);

      parents[level++] = parentIndex;
      parentIndex = index;
      parent = view;

      // enqueue for end
      queue[length++] = index;
      // enqueue children
      children = this.childViews(view);
      if (children) {
        for (i = children.length - 1; i >= 0; i--) {
          child = children[i];
          index = total++;
          views[index] = child;
          queue[length++] = index;
          view = child;
        }
      }

      index = queue[--length];
      view = views[index];

      while (parentIndex === index) {
        level--;
        view._elementCreated = true;
        this.didCreateElement(view);
        if (willInsert) {
          this.willInsertElement(view);
        }

        if (level === 0) {
          length--;
          break;
        }

        parentIndex = parents[level];
        parent = parentIndex === -1 ? _parentView : views[parentIndex];
        this.insertElement(view, parent, element, null);
        index = queue[--length];
        view = views[index];
        element = elements[level];
        elements[level] = null;
      }
    }

    this.insertElement(view, _parentView, element, _refMorph);

    for (i = total - 1; i >= 0; i--) {
      if (willInsert) {
        views[i]._elementInserted = true;
        this.didInsertElement(views[i]);
      }
      views[i] = null;
    }

    return element;
  }

  Renderer.prototype.uuid = function Renderer_uuid(view) {
    if (view._uuid === undefined) {
      view._uuid = ++this._uuid;
      view._renderer = this;
    } // else assert(view._renderer === this)
    return view._uuid;
  };

  Renderer.prototype.scheduleInsert = function Renderer_scheduleInsert(view, morph) {
    if (view._morph || view._elementCreated) {
      throw new Error("You cannot insert a View that has already been rendered");
    }
        view._morph = morph;
    var viewId = this.uuid(view);
    this._inserts[viewId] = this.scheduleRender(this, function scheduledRenderTree() {
      this._inserts[viewId] = null;
      this.renderTree(view);
    });
  };

  Renderer.prototype.appendTo = function Renderer_appendTo(view, target) {
    var morph = this._dom.appendMorph(target);
    this.scheduleInsert(view, morph);
  };

  Renderer.prototype.appendAttrTo = function Renderer_appendAttrTo(view, target, attrName) {
    var morph = this._dom.createAttrMorph(target, attrName);
    this.scheduleInsert(view, morph);
  };

  Renderer.prototype.replaceIn = function Renderer_replaceIn(view, target) {
    var morph;
    if (target.firstChild) {
      morph = this._dom.createMorph(target, target.firstChild, target.lastChild);
    } else {
      morph = this._dom.appendMorph(target);
    }
    this.scheduleInsert(view, morph);
  };

  function Renderer_remove(_view, shouldDestroy, reset) {
    var viewId = this.uuid(_view);

    if (this._inserts[viewId]) {
      this.cancelRender(this._inserts[viewId]);
      this._inserts[viewId] = undefined;
    }

    if (!_view._elementCreated) {
      return;
    }

    var removeQueue = [];
    var destroyQueue = [];
    var morph = _view._morph;
    var idx, len, view, queue, childViews, i, l;

    removeQueue.push(_view);

    for (idx = 0; idx < removeQueue.length; idx++) {
      view = removeQueue[idx];

      if (!shouldDestroy && view._childViewsMorph) {
        queue = removeQueue;
      } else {
        queue = destroyQueue;
      }

      this.beforeRemove(removeQueue[idx]);

      childViews = this.childViews(view);
      if (childViews) {
        for (i = 0, l = childViews.length; i < l; i++) {
          queue.push(childViews[i]);
        }
      }
    }

    for (idx = 0; idx < destroyQueue.length; idx++) {
      view = destroyQueue[idx];

      this.beforeRemove(destroyQueue[idx]);

      childViews = this.childViews(view);
      if (childViews) {
        for (i = 0, l = childViews.length; i < l; i++) {
          destroyQueue.push(childViews[i]);
        }
      }
    }

    // destroy DOM from root insertion
    if (morph && !reset) {
      morph.destroy();
    }

    for (idx = 0, len = removeQueue.length; idx < len; idx++) {
      this.afterRemove(removeQueue[idx], false);
    }

    for (idx = 0, len = destroyQueue.length; idx < len; idx++) {
      this.afterRemove(destroyQueue[idx], true);
    }

    if (reset) {
      _view._morph = morph;
    }
  }

  function Renderer_insertElement(view, parentView, element, refMorph) {
    if (element === null || element === undefined) {
      return;
    }

    if (view._morph) {
      view._morph.setContent(element);
    } else if (parentView) {
      view._morph = parentView._childViewsMorph.insertContentBeforeMorph(element, refMorph);
    }
  }

  function Renderer_beforeRemove(view) {
    if (view._elementCreated) {
      this.willDestroyElement(view);
    }
    if (view._elementInserted) {
      this.willRemoveElement(view);
    }
  }

  function Renderer_afterRemove(view, shouldDestroy) {
    view._elementInserted = false;
    view._morph = null;
    view._childViewsMorph = null;
    if (view._elementCreated) {
      view._elementCreated = false;
      this.didDestroyElement(view);
    }
    if (shouldDestroy) {
      this.destroyView(view);
    }
  }

  Renderer.prototype.remove = Renderer_remove;
  Renderer.prototype.removeAndDestroy = function (view) {
    this.remove(view, true);
  };

  Renderer.prototype.renderTree = Renderer_renderTree;
  Renderer.prototype.insertElement = Renderer_insertElement;
  Renderer.prototype.beforeRemove = Renderer_beforeRemove;
  Renderer.prototype.afterRemove = Renderer_afterRemove;

  /// HOOKS
  var noop = function () {};

  Renderer.prototype.willCreateElement = noop; // inBuffer
  Renderer.prototype.createElement = noop; // renderToBuffer or createElement
  Renderer.prototype.didCreateElement = noop; // hasElement
  Renderer.prototype.willInsertElement = noop; // will place into DOM
  Renderer.prototype.didInsertElement = noop; // inDOM // placed into DOM
  Renderer.prototype.willRemoveElement = noop; // removed from DOM  willDestroyElement currently paired with didInsertElement
  Renderer.prototype.willDestroyElement = noop; // willClearRender (currently balanced with render) this is now paired with createElement
  Renderer.prototype.didDestroyElement = noop; // element destroyed so view.destroy shouldn't try to remove it removedFromDOM
  Renderer.prototype.destroyView = noop;
  Renderer.prototype.childViews = noop;

  exports['default'] = Renderer;

});
enifed('ember-metal', ['exports', 'ember-metal/core', 'ember-metal/merge', 'ember-metal/instrumentation', 'ember-metal/utils', 'ember-metal/error', 'ember-metal/enumerable_utils', 'ember-metal/cache', 'ember-metal/platform/define_property', 'ember-metal/platform/create', 'ember-metal/array', 'ember-metal/logger', 'ember-metal/property_get', 'ember-metal/events', 'ember-metal/observer_set', 'ember-metal/property_events', 'ember-metal/properties', 'ember-metal/property_set', 'ember-metal/map', 'ember-metal/get_properties', 'ember-metal/set_properties', 'ember-metal/watch_key', 'ember-metal/chains', 'ember-metal/watch_path', 'ember-metal/watching', 'ember-metal/expand_properties', 'ember-metal/computed', 'ember-metal/alias', 'ember-metal/computed_macros', 'ember-metal/observer', 'ember-metal/mixin', 'ember-metal/binding', 'ember-metal/run_loop', 'ember-metal/libraries', 'ember-metal/is_none', 'ember-metal/is_empty', 'ember-metal/is_blank', 'ember-metal/is_present', 'ember-metal/keys', 'backburner', 'ember-metal/streams/utils', 'ember-metal/streams/stream'], function (exports, Ember, merge, instrumentation, utils, EmberError, EnumerableUtils, Cache, define_property, create, array, Logger, property_get, events, ObserverSet, property_events, properties, property_set, map, getProperties, setProperties, watch_key, chains, watch_path, watching, expandProperties, computed, alias, computed_macros, observer, mixin, binding, run, Libraries, isNone, isEmpty, isBlank, isPresent, keys, Backburner, streams__utils, Stream) {

  'use strict';

  /**
  Ember Metal

  @module ember
  @submodule ember-metal
  */

  // BEGIN IMPORTS
  computed.computed.empty = computed_macros.empty;
  computed.computed.notEmpty = computed_macros.notEmpty;
  computed.computed.none = computed_macros.none;
  computed.computed.not = computed_macros.not;
  computed.computed.bool = computed_macros.bool;
  computed.computed.match = computed_macros.match;
  computed.computed.equal = computed_macros.equal;
  computed.computed.gt = computed_macros.gt;
  computed.computed.gte = computed_macros.gte;
  computed.computed.lt = computed_macros.lt;
  computed.computed.lte = computed_macros.lte;
  computed.computed.alias = alias['default'];
  computed.computed.oneWay = computed_macros.oneWay;
  computed.computed.reads = computed_macros.oneWay;
  computed.computed.readOnly = computed_macros.readOnly;
  computed.computed.defaultTo = computed_macros.defaultTo;
  computed.computed.deprecatingAlias = computed_macros.deprecatingAlias;
  computed.computed.and = computed_macros.and;
  computed.computed.or = computed_macros.or;
  computed.computed.any = computed_macros.any;
  computed.computed.collect = computed_macros.collect; // END IMPORTS

  // BEGIN EXPORTS
  var EmberInstrumentation = Ember['default'].Instrumentation = {};
  EmberInstrumentation.instrument = instrumentation.instrument;
  EmberInstrumentation.subscribe = instrumentation.subscribe;
  EmberInstrumentation.unsubscribe = instrumentation.unsubscribe;
  EmberInstrumentation.reset = instrumentation.reset;

  Ember['default'].instrument = instrumentation.instrument;
  Ember['default'].subscribe = instrumentation.subscribe;

  Ember['default']._Cache = Cache['default'];

  Ember['default'].generateGuid = utils.generateGuid;
  Ember['default'].GUID_KEY = utils.GUID_KEY;
  Ember['default'].create = create['default'];
  Ember['default'].keys = keys['default'];
  Ember['default'].platform = {
    defineProperty: properties.defineProperty,
    hasPropertyAccessors: define_property.hasPropertyAccessors
  };

  var EmberArrayPolyfills = Ember['default'].ArrayPolyfills = {};

  EmberArrayPolyfills.map = array.map;
  EmberArrayPolyfills.forEach = array.forEach;
  EmberArrayPolyfills.filter = array.filter;
  EmberArrayPolyfills.indexOf = array.indexOf;

  Ember['default'].Error = EmberError['default'];
  Ember['default'].guidFor = utils.guidFor;
  Ember['default'].META_DESC = utils.META_DESC;
  Ember['default'].EMPTY_META = utils.EMPTY_META;
  Ember['default'].meta = utils.meta;
  Ember['default'].getMeta = utils.getMeta;
  Ember['default'].setMeta = utils.setMeta;
  Ember['default'].metaPath = utils.metaPath;
  Ember['default'].inspect = utils.inspect;
  Ember['default'].typeOf = utils.typeOf;
  Ember['default'].tryCatchFinally = utils.deprecatedTryCatchFinally;
  Ember['default'].isArray = utils.isArray;
  Ember['default'].makeArray = utils.makeArray;
  Ember['default'].canInvoke = utils.canInvoke;
  Ember['default'].tryInvoke = utils.tryInvoke;
  Ember['default'].tryFinally = utils.deprecatedTryFinally;
  Ember['default'].wrap = utils.wrap;
  Ember['default'].apply = utils.apply;
  Ember['default'].applyStr = utils.applyStr;
  Ember['default'].uuid = utils.uuid;

  Ember['default'].Logger = Logger['default'];

  Ember['default'].get = property_get.get;
  Ember['default'].getWithDefault = property_get.getWithDefault;
  Ember['default'].normalizeTuple = property_get.normalizeTuple;
  Ember['default']._getPath = property_get._getPath;

  Ember['default'].EnumerableUtils = EnumerableUtils['default'];

  Ember['default'].on = events.on;
  Ember['default'].addListener = events.addListener;
  Ember['default'].removeListener = events.removeListener;
  Ember['default']._suspendListener = events.suspendListener;
  Ember['default']._suspendListeners = events.suspendListeners;
  Ember['default'].sendEvent = events.sendEvent;
  Ember['default'].hasListeners = events.hasListeners;
  Ember['default'].watchedEvents = events.watchedEvents;
  Ember['default'].listenersFor = events.listenersFor;
  Ember['default'].accumulateListeners = events.accumulateListeners;

  Ember['default']._ObserverSet = ObserverSet['default'];

  Ember['default'].propertyWillChange = property_events.propertyWillChange;
  Ember['default'].propertyDidChange = property_events.propertyDidChange;
  Ember['default'].overrideChains = property_events.overrideChains;
  Ember['default'].beginPropertyChanges = property_events.beginPropertyChanges;
  Ember['default'].endPropertyChanges = property_events.endPropertyChanges;
  Ember['default'].changeProperties = property_events.changeProperties;

  Ember['default'].defineProperty = properties.defineProperty;

  Ember['default'].set = property_set.set;
  Ember['default'].trySet = property_set.trySet;

  Ember['default'].OrderedSet = map.OrderedSet;
  Ember['default'].Map = map.Map;
  Ember['default'].MapWithDefault = map.MapWithDefault;

  Ember['default'].getProperties = getProperties['default'];
  Ember['default'].setProperties = setProperties['default'];

  Ember['default'].watchKey = watch_key.watchKey;
  Ember['default'].unwatchKey = watch_key.unwatchKey;

  Ember['default'].flushPendingChains = chains.flushPendingChains;
  Ember['default'].removeChainWatcher = chains.removeChainWatcher;
  Ember['default']._ChainNode = chains.ChainNode;
  Ember['default'].finishChains = chains.finishChains;

  Ember['default'].watchPath = watch_path.watchPath;
  Ember['default'].unwatchPath = watch_path.unwatchPath;

  Ember['default'].watch = watching.watch;
  Ember['default'].isWatching = watching.isWatching;
  Ember['default'].unwatch = watching.unwatch;
  Ember['default'].rewatch = watching.rewatch;
  Ember['default'].destroy = watching.destroy;

  Ember['default'].expandProperties = expandProperties['default'];

  Ember['default'].ComputedProperty = computed.ComputedProperty;
  Ember['default'].computed = computed.computed;
  Ember['default'].cacheFor = computed.cacheFor;

  Ember['default'].addObserver = observer.addObserver;
  Ember['default'].observersFor = observer.observersFor;
  Ember['default'].removeObserver = observer.removeObserver;
  Ember['default'].addBeforeObserver = observer.addBeforeObserver;
  Ember['default']._suspendBeforeObserver = observer._suspendBeforeObserver;
  Ember['default']._suspendBeforeObservers = observer._suspendBeforeObservers;
  Ember['default']._suspendObserver = observer._suspendObserver;
  Ember['default']._suspendObservers = observer._suspendObservers;
  Ember['default'].beforeObserversFor = observer.beforeObserversFor;
  Ember['default'].removeBeforeObserver = observer.removeBeforeObserver;

  Ember['default'].IS_BINDING = mixin.IS_BINDING;
  Ember['default'].required = mixin.required;
  Ember['default'].aliasMethod = mixin.aliasMethod;
  Ember['default'].observer = mixin.observer;
  Ember['default'].immediateObserver = mixin.immediateObserver;
  Ember['default'].beforeObserver = mixin.beforeObserver;
  Ember['default'].mixin = mixin.mixin;
  Ember['default'].Mixin = mixin.Mixin;

  Ember['default'].oneWay = binding.oneWay;
  Ember['default'].bind = binding.bind;
  Ember['default'].Binding = binding.Binding;
  Ember['default'].isGlobalPath = binding.isGlobalPath;

  Ember['default'].run = run['default'];

  /**
   * @class Backburner
   * @for Ember
   * @private
  */
  Ember['default'].Backburner = Backburner['default'];

  Ember['default'].libraries = new Libraries['default']();
  Ember['default'].libraries.registerCoreLibrary("Ember", Ember['default'].VERSION);

  Ember['default'].isNone = isNone['default'];
  Ember['default'].isEmpty = isEmpty['default'];
  Ember['default'].isBlank = isBlank['default'];
  Ember['default'].isPresent = isPresent['default'];

  Ember['default'].merge = merge['default'];

  
  /**
    A function may be assigned to `Ember.onerror` to be called when Ember
    internals encounter an error. This is useful for specialized error handling
    and reporting code.

    ```javascript
    Ember.onerror = function(error) {
      Em.$.ajax('/report-error', 'POST', {
        stack: error.stack,
        otherInformation: 'whatever app state you want to provide'
      });
    };
    ```

    Internally, `Ember.onerror` is used as Backburner's error handler.

    @event onerror
    @for Ember
    @param {Exception} error the error object
  */
  Ember['default'].onerror = null;
  // END EXPORTS

  // do this for side-effects of updating Ember.assert, warn, etc when
  // ember-debug is present
  if (Ember['default'].__loader.registry["ember-debug"]) {
    requireModule("ember-debug");
  }

  exports['default'] = Ember['default'];

});
enifed('ember-metal/alias', ['exports', 'ember-metal/property_get', 'ember-metal/property_set', 'ember-metal/core', 'ember-metal/error', 'ember-metal/properties', 'ember-metal/computed', 'ember-metal/platform/create', 'ember-metal/utils', 'ember-metal/dependent_keys'], function (exports, property_get, property_set, Ember, EmberError, properties, computed, create, utils, dependent_keys) {

  'use strict';

  exports.AliasedProperty = AliasedProperty;

  exports['default'] = alias;

  function alias(altKey) {
    return new AliasedProperty(altKey);
  }

  function AliasedProperty(altKey) {
    this.isDescriptor = true;
    this.altKey = altKey;
    this._dependentKeys = [altKey];
  }

  AliasedProperty.prototype = create['default'](properties.Descriptor.prototype);

  AliasedProperty.prototype.get = function AliasedProperty_get(obj, keyName) {
    return property_get.get(obj, this.altKey);
  };

  AliasedProperty.prototype.set = function AliasedProperty_set(obj, keyName, value) {
    return property_set.set(obj, this.altKey, value);
  };

  AliasedProperty.prototype.willWatch = function (obj, keyName) {
    dependent_keys.addDependentKeys(this, obj, keyName, utils.meta(obj));
  };

  AliasedProperty.prototype.didUnwatch = function (obj, keyName) {
    dependent_keys.removeDependentKeys(this, obj, keyName, utils.meta(obj));
  };

  AliasedProperty.prototype.setup = function (obj, keyName) {
        var m = utils.meta(obj);
    if (m.watching[keyName]) {
      dependent_keys.addDependentKeys(this, obj, keyName, m);
    }
  };

  AliasedProperty.prototype.teardown = function (obj, keyName) {
    var m = utils.meta(obj);
    if (m.watching[keyName]) {
      dependent_keys.removeDependentKeys(this, obj, keyName, m);
    }
  };

  AliasedProperty.prototype.readOnly = function () {
    this.set = AliasedProperty_readOnlySet;
    return this;
  };

  function AliasedProperty_readOnlySet(obj, keyName, value) {
    throw new EmberError['default']("Cannot set read-only property '" + keyName + "' on object: " + utils.inspect(obj));
  }

  AliasedProperty.prototype.oneWay = function () {
    this.set = AliasedProperty_oneWaySet;
    return this;
  };

  function AliasedProperty_oneWaySet(obj, keyName, value) {
    properties.defineProperty(obj, keyName, null);
    return property_set.set(obj, keyName, value);
  }

  // Backwards compatibility with Ember Data
  AliasedProperty.prototype._meta = undefined;
  AliasedProperty.prototype.meta = computed.ComputedProperty.prototype.meta;

});
enifed('ember-metal/array', ['exports'], function (exports) {

  'use strict';

  /**
  @module ember-metal
  */

  var ArrayPrototype = Array.prototype;

  // Testing this is not ideal, but we want to use native functions
  // if available, but not to use versions created by libraries like Prototype
  var isNativeFunc = function (func) {
    // This should probably work in all browsers likely to have ES5 array methods
    return func && Function.prototype.toString.call(func).indexOf("[native code]") > -1;
  };

  var defineNativeShim = function (nativeFunc, shim) {
    if (isNativeFunc(nativeFunc)) {
      return nativeFunc;
    }
    return shim;
  };

  // From: https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/array/map
  var map = defineNativeShim(ArrayPrototype.map, function (fun) {
    //"use strict";

    if (this === void 0 || this === null || typeof fun !== "function") {
      throw new TypeError();
    }

    var t = Object(this);
    var len = t.length >>> 0;
    var res = new Array(len);

    for (var i = 0; i < len; i++) {
      if (i in t) {
        res[i] = fun.call(arguments[1], t[i], i, t);
      }
    }

    return res;
  });

  // From: https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/array/foreach
  var forEach = defineNativeShim(ArrayPrototype.forEach, function (fun) {
    //"use strict";

    if (this === void 0 || this === null || typeof fun !== "function") {
      throw new TypeError();
    }

    var t = Object(this);
    var len = t.length >>> 0;

    for (var i = 0; i < len; i++) {
      if (i in t) {
        fun.call(arguments[1], t[i], i, t);
      }
    }
  });

  var indexOf = defineNativeShim(ArrayPrototype.indexOf, function (obj, fromIndex) {
    if (fromIndex === null || fromIndex === undefined) {
      fromIndex = 0;
    } else if (fromIndex < 0) {
      fromIndex = Math.max(0, this.length + fromIndex);
    }

    for (var i = fromIndex, j = this.length; i < j; i++) {
      if (this[i] === obj) {
        return i;
      }
    }
    return -1;
  });

  var lastIndexOf = defineNativeShim(ArrayPrototype.lastIndexOf, function (obj, fromIndex) {
    var len = this.length;
    var idx;

    if (fromIndex === undefined) {
      fromIndex = len - 1;
    } else {
      fromIndex = fromIndex < 0 ? Math.ceil(fromIndex) : Math.floor(fromIndex);
    }

    if (fromIndex < 0) {
      fromIndex += len;
    }

    for (idx = fromIndex; idx >= 0; idx--) {
      if (this[idx] === obj) {
        return idx;
      }
    }
    return -1;
  });

  var filter = defineNativeShim(ArrayPrototype.filter, function (fn, context) {
    var i, value;
    var result = [];
    var length = this.length;

    for (i = 0; i < length; i++) {
      if (this.hasOwnProperty(i)) {
        value = this[i];
        if (fn.call(context, value, i, this)) {
          result.push(value);
        }
      }
    }
    return result;
  });

  if (Ember.SHIM_ES5) {
    ArrayPrototype.map = ArrayPrototype.map || map;
    ArrayPrototype.forEach = ArrayPrototype.forEach || forEach;
    ArrayPrototype.filter = ArrayPrototype.filter || filter;
    ArrayPrototype.indexOf = ArrayPrototype.indexOf || indexOf;
    ArrayPrototype.lastIndexOf = ArrayPrototype.lastIndexOf || lastIndexOf;
  }

  /**
    Array polyfills to support ES5 features in older browsers.

    @namespace Ember
    @property ArrayPolyfills
  */

  exports.map = map;
  exports.forEach = forEach;
  exports.filter = filter;
  exports.indexOf = indexOf;
  exports.lastIndexOf = lastIndexOf;

});
enifed('ember-metal/binding', ['exports', 'ember-metal/core', 'ember-metal/property_get', 'ember-metal/property_set', 'ember-metal/utils', 'ember-metal/observer', 'ember-metal/run_loop', 'ember-metal/path_cache'], function (exports, Ember, property_get, property_set, utils, observer, run, path_cache) {

  'use strict';

  exports.bind = bind;
  exports.oneWay = oneWay;
  exports.Binding = Binding;

  /**
    An `Ember.Binding` connects the properties of two objects so that whenever
    the value of one property changes, the other property will be changed also.

    ## Automatic Creation of Bindings with `/^*Binding/`-named Properties

    You do not usually create Binding objects directly but instead describe
    bindings in your class or object definition using automatic binding
    detection.

    Properties ending in a `Binding` suffix will be converted to `Ember.Binding`
    instances. The value of this property should be a string representing a path
    to another object or a custom binding instance created using Binding helpers
    (see "One Way Bindings"):

    ```
    valueBinding: "MyApp.someController.title"
    ```

    This will create a binding from `MyApp.someController.title` to the `value`
    property of your object instance automatically. Now the two values will be
    kept in sync.

    ## One Way Bindings

    One especially useful binding customization you can use is the `oneWay()`
    helper. This helper tells Ember that you are only interested in
    receiving changes on the object you are binding from. For example, if you
    are binding to a preference and you want to be notified if the preference
    has changed, but your object will not be changing the preference itself, you
    could do:

    ```
    bigTitlesBinding: Ember.Binding.oneWay("MyApp.preferencesController.bigTitles")
    ```

    This way if the value of `MyApp.preferencesController.bigTitles` changes the
    `bigTitles` property of your object will change also. However, if you
    change the value of your `bigTitles` property, it will not update the
    `preferencesController`.

    One way bindings are almost twice as fast to setup and twice as fast to
    execute because the binding only has to worry about changes to one side.

    You should consider using one way bindings anytime you have an object that
    may be created frequently and you do not intend to change a property; only
    to monitor it for changes (such as in the example above).

    ## Adding Bindings Manually

    All of the examples above show you how to configure a custom binding, but the
    result of these customizations will be a binding template, not a fully active
    Binding instance. The binding will actually become active only when you
    instantiate the object the binding belongs to. It is useful however, to
    understand what actually happens when the binding is activated.

    For a binding to function it must have at least a `from` property and a `to`
    property. The `from` property path points to the object/key that you want to
    bind from while the `to` path points to the object/key you want to bind to.

    When you define a custom binding, you are usually describing the property
    you want to bind from (such as `MyApp.someController.value` in the examples
    above). When your object is created, it will automatically assign the value
    you want to bind `to` based on the name of your binding key. In the
    examples above, during init, Ember objects will effectively call
    something like this on your binding:

    ```javascript
    binding = Ember.Binding.from("valueBinding").to("value");
    ```

    This creates a new binding instance based on the template you provide, and
    sets the to path to the `value` property of the new object. Now that the
    binding is fully configured with a `from` and a `to`, it simply needs to be
    connected to become active. This is done through the `connect()` method:

    ```javascript
    binding.connect(this);
    ```

    Note that when you connect a binding you pass the object you want it to be
    connected to. This object will be used as the root for both the from and
    to side of the binding when inspecting relative paths. This allows the
    binding to be automatically inherited by subclassed objects as well.

    This also allows you to bind between objects using the paths you declare in
    `from` and `to`:

    ```javascript
    // Example 1
    binding = Ember.Binding.from("App.someObject.value").to("value");
    binding.connect(this);

    // Example 2
    binding = Ember.Binding.from("parentView.value").to("App.someObject.value");
    binding.connect(this);
    ```

    Now that the binding is connected, it will observe both the from and to side
    and relay changes.

    If you ever needed to do so (you almost never will, but it is useful to
    understand this anyway), you could manually create an active binding by
    using the `Ember.bind()` helper method. (This is the same method used by
    to setup your bindings on objects):

    ```javascript
    Ember.bind(MyApp.anotherObject, "value", "MyApp.someController.value");
    ```

    Both of these code fragments have the same effect as doing the most friendly
    form of binding creation like so:

    ```javascript
    MyApp.anotherObject = Ember.Object.create({
      valueBinding: "MyApp.someController.value",

      // OTHER CODE FOR THIS OBJECT...
    });
    ```

    Ember's built in binding creation method makes it easy to automatically
    create bindings for you. You should always use the highest-level APIs
    available, even if you understand how it works underneath.

    @class Binding
    @namespace Ember
    @since Ember 0.9
  */
  // Ember.Binding = Binding; ES6TODO: where to put this?

  /**
    Global helper method to create a new binding. Just pass the root object
    along with a `to` and `from` path to create and connect the binding.

    @method bind
    @for Ember
    @param {Object} obj The root object of the transform.
    @param {String} to The path to the 'to' side of the binding.
      Must be relative to obj.
    @param {String} from The path to the 'from' side of the binding.
      Must be relative to obj or a global path.
    @return {Ember.Binding} binding instance
  */
  Ember['default'].LOG_BINDINGS = false || !!Ember['default'].ENV.LOG_BINDINGS;

  /**
    Returns true if the provided path is global (e.g., `MyApp.fooController.bar`)
    instead of local (`foo.bar.baz`).

    @method isGlobalPath
    @for Ember
    @private
    @param {String} path
    @return Boolean
  */

  function getWithGlobals(obj, path) {
    return property_get.get(path_cache.isGlobal(path) ? Ember['default'].lookup : obj, path);
  }

  // ..........................................................
  // BINDING
  //

  function Binding(toPath, fromPath) {
    this._direction = undefined;
    this._from = fromPath;
    this._to = toPath;
    this._readyToSync = undefined;
    this._oneWay = undefined;
  }

  /**
  @class Binding
  @namespace Ember
  */

  Binding.prototype = {
    /**
      This copies the Binding so it can be connected to another object.
       @method copy
      @return {Ember.Binding} `this`
    */
    copy: function () {
      var copy = new Binding(this._to, this._from);
      if (this._oneWay) {
        copy._oneWay = true;
      }
      return copy;
    },

    // ..........................................................
    // CONFIG
    //

    /**
      This will set `from` property path to the specified value. It will not
      attempt to resolve this property path to an actual object until you
      connect the binding.
       The binding will search for the property path starting at the root object
      you pass when you `connect()` the binding. It follows the same rules as
      `get()` - see that method for more information.
       @method from
      @param {String} path the property path to connect to
      @return {Ember.Binding} `this`
    */
    from: function (path) {
      this._from = path;
      return this;
    },

    /**
      This will set the `to` property path to the specified value. It will not
      attempt to resolve this property path to an actual object until you
      connect the binding.
       The binding will search for the property path starting at the root object
      you pass when you `connect()` the binding. It follows the same rules as
      `get()` - see that method for more information.
       @method to
      @param {String|Tuple} path A property path or tuple
      @return {Ember.Binding} `this`
    */
    to: function (path) {
      this._to = path;
      return this;
    },

    /**
      Configures the binding as one way. A one-way binding will relay changes
      on the `from` side to the `to` side, but not the other way around. This
      means that if you change the `to` side directly, the `from` side may have
      a different value.
       @method oneWay
      @return {Ember.Binding} `this`
    */
    oneWay: function () {
      this._oneWay = true;
      return this;
    },

    /**
      @method toString
      @return {String} string representation of binding
    */
    toString: function () {
      var oneWay = this._oneWay ? "[oneWay]" : "";
      return "Ember.Binding<" + utils.guidFor(this) + ">(" + this._from + " -> " + this._to + ")" + oneWay;
    },

    // ..........................................................
    // CONNECT AND SYNC
    //

    /**
      Attempts to connect this binding instance so that it can receive and relay
      changes. This method will raise an exception if you have not set the
      from/to properties yet.
       @method connect
      @param {Object} obj The root object for this binding.
      @return {Ember.Binding} `this`
    */
    connect: function (obj) {
      
      var fromPath = this._from;
      var toPath = this._to;
      property_set.trySet(obj, toPath, getWithGlobals(obj, fromPath));

      // add an observer on the object to be notified when the binding should be updated
      observer.addObserver(obj, fromPath, this, this.fromDidChange);

      // if the binding is a two-way binding, also set up an observer on the target
      if (!this._oneWay) {
        observer.addObserver(obj, toPath, this, this.toDidChange);
      }

      this._readyToSync = true;

      return this;
    },

    /**
      Disconnects the binding instance. Changes will no longer be relayed. You
      will not usually need to call this method.
       @method disconnect
      @param {Object} obj The root object you passed when connecting the binding.
      @return {Ember.Binding} `this`
    */
    disconnect: function (obj) {
      
      var twoWay = !this._oneWay;

      // remove an observer on the object so we're no longer notified of
      // changes that should update bindings.
      observer.removeObserver(obj, this._from, this, this.fromDidChange);

      // if the binding is two-way, remove the observer from the target as well
      if (twoWay) {
        observer.removeObserver(obj, this._to, this, this.toDidChange);
      }

      this._readyToSync = false; // disable scheduled syncs...
      return this;
    },

    // ..........................................................
    // PRIVATE
    //

    /* called when the from side changes */
    fromDidChange: function (target) {
      this._scheduleSync(target, "fwd");
    },

    /* called when the to side changes */
    toDidChange: function (target) {
      this._scheduleSync(target, "back");
    },

    _scheduleSync: function (obj, dir) {
      var existingDir = this._direction;

      // if we haven't scheduled the binding yet, schedule it
      if (existingDir === undefined) {
        run['default'].schedule("sync", this, this._sync, obj);
        this._direction = dir;
      }

      // If both a 'back' and 'fwd' sync have been scheduled on the same object,
      // default to a 'fwd' sync so that it remains deterministic.
      if (existingDir === "back" && dir === "fwd") {
        this._direction = "fwd";
      }
    },

    _sync: function (obj) {
      var log = Ember['default'].LOG_BINDINGS;

      // don't synchronize destroyed objects or disconnected bindings
      if (obj.isDestroyed || !this._readyToSync) {
        return;
      }

      // get the direction of the binding for the object we are
      // synchronizing from
      var direction = this._direction;

      var fromPath = this._from;
      var toPath = this._to;

      this._direction = undefined;

      // if we're synchronizing from the remote object...
      if (direction === "fwd") {
        var fromValue = getWithGlobals(obj, this._from);
        if (log) {
          Ember['default'].Logger.log(" ", this.toString(), "->", fromValue, obj);
        }
        if (this._oneWay) {
          property_set.trySet(obj, toPath, fromValue);
        } else {
          observer._suspendObserver(obj, toPath, this, this.toDidChange, function () {
            property_set.trySet(obj, toPath, fromValue);
          });
        }
        // if we're synchronizing *to* the remote object
      } else if (direction === "back") {
        var toValue = property_get.get(obj, this._to);
        if (log) {
          Ember['default'].Logger.log(" ", this.toString(), "<-", toValue, obj);
        }
        observer._suspendObserver(obj, fromPath, this, this.fromDidChange, function () {
          property_set.trySet(path_cache.isGlobal(fromPath) ? Ember['default'].lookup : obj, fromPath, toValue);
        });
      }
    }

  };

  function mixinProperties(to, from) {
    for (var key in from) {
      if (from.hasOwnProperty(key)) {
        to[key] = from[key];
      }
    }
  }

  mixinProperties(Binding, {

    /*
      See `Ember.Binding.from`.
       @method from
      @static
    */
    from: function (from) {
      var C = this;
      return new C(undefined, from);
    },

    /*
      See `Ember.Binding.to`.
       @method to
      @static
    */
    to: function (to) {
      var C = this;
      return new C(to, undefined);
    },

    /**
      Creates a new Binding instance and makes it apply in a single direction.
      A one-way binding will relay changes on the `from` side object (supplied
      as the `from` argument) the `to` side, but not the other way around.
      This means that if you change the "to" side directly, the "from" side may have
      a different value.
       See `Binding.oneWay`.
       @method oneWay
      @param {String} from from path.
      @param {Boolean} [flag] (Optional) passing nothing here will make the
        binding `oneWay`. You can instead pass `false` to disable `oneWay`, making the
        binding two way again.
      @return {Ember.Binding} `this`
    */
    oneWay: function (from, flag) {
      var C = this;
      return new C(undefined, from).oneWay(flag);
    }

  });
  function bind(obj, to, from) {
    return new Binding(to, from).connect(obj);
  }

  function oneWay(obj, to, from) {
    return new Binding(to, from).oneWay().connect(obj);
  }

  exports.isGlobalPath = path_cache.isGlobal;

});
enifed('ember-metal/cache', ['exports', 'ember-metal/dictionary'], function (exports, dictionary) {

  'use strict';

  exports['default'] = Cache;

  function Cache(limit, func) {
    this.store = dictionary['default'](null);
    this.size = 0;
    this.misses = 0;
    this.hits = 0;
    this.limit = limit;
    this.func = func;
  }

  var UNDEFINED = function () {};

  Cache.prototype = {
    set: function (key, value) {
      if (this.limit > this.size) {
        this.size++;
        if (value === undefined) {
          this.store[key] = UNDEFINED;
        } else {
          this.store[key] = value;
        }
      }

      return value;
    },

    get: function (key) {
      var value = this.store[key];

      if (value === undefined) {
        this.misses++;
        value = this.set(key, this.func(key));
      } else if (value === UNDEFINED) {
        this.hits++;
        value = undefined;
      } else {
        this.hits++;
        // nothing to translate
      }

      return value;
    },

    purge: function () {
      this.store = dictionary['default'](null);
      this.size = 0;
      this.hits = 0;
      this.misses = 0;
    }
  };

});
enifed('ember-metal/chains', ['exports', 'ember-metal/core', 'ember-metal/property_get', 'ember-metal/utils', 'ember-metal/array', 'ember-metal/watch_key'], function (exports, Ember, property_get, utils, array, watch_key) {

  'use strict';

  exports.flushPendingChains = flushPendingChains;
  exports.finishChains = finishChains;
  exports.removeChainWatcher = removeChainWatcher;
  exports.ChainNode = ChainNode;

  // attempts to add the pendingQueue chains again. If some of them end up
  // back in the queue and reschedule is true, schedules a timeout to try
  // again.
  var warn = Ember['default'].warn;
  var FIRST_KEY = /^([^\.]+)/;

  function firstKey(path) {
    return path.match(FIRST_KEY)[0];
  }

  function isObject(obj) {
    return obj && typeof obj === "object";
  }

  var pendingQueue = [];
  function flushPendingChains() {
    if (pendingQueue.length === 0) {
      return;
    }

    var queue = pendingQueue;
    pendingQueue = [];

    array.forEach.call(queue, function (q) {
      q[0].add(q[1]);
    });

    warn("Watching an undefined global, Ember expects watched globals to be" + " setup by the time the run loop is flushed, check for typos", pendingQueue.length === 0);
  }

  function addChainWatcher(obj, keyName, node) {
    if (!isObject(obj)) {
      return;
    }

    var m = utils.meta(obj);
    var nodes = m.chainWatchers;

    if (!m.hasOwnProperty("chainWatchers")) {
      // FIXME?!
      nodes = m.chainWatchers = {};
    }

    if (!nodes[keyName]) {
      nodes[keyName] = [];
    }
    nodes[keyName].push(node);
    watch_key.watchKey(obj, keyName, m);
  }

  function removeChainWatcher(obj, keyName, node) {
    if (!isObject(obj)) {
      return;
    }

    var m = obj["__ember_meta__"];
    if (m && !m.hasOwnProperty("chainWatchers")) {
      return;
    }

    var nodes = m && m.chainWatchers;

    if (nodes && nodes[keyName]) {
      nodes = nodes[keyName];
      for (var i = 0, l = nodes.length; i < l; i++) {
        if (nodes[i] === node) {
          nodes.splice(i, 1);
          break;
        }
      }
    }
    watch_key.unwatchKey(obj, keyName, m);
  }

  // A ChainNode watches a single key on an object. If you provide a starting
  // value for the key then the node won't actually watch it. For a root node
  // pass null for parent and key and object for value.
  function ChainNode(parent, key, value) {
    this._parent = parent;
    this._key = key;

    // _watching is true when calling get(this._parent, this._key) will
    // return the value of this node.
    //
    // It is false for the root of a chain (because we have no parent)
    // and for global paths (because the parent node is the object with
    // the observer on it)
    this._watching = value === undefined;

    this._value = value;
    this._paths = {};
    if (this._watching) {
      this._object = parent.value();
      if (this._object) {
        addChainWatcher(this._object, this._key, this);
      }
    }

    // Special-case: the EachProxy relies on immediate evaluation to
    // establish its observers.
    //
    // TODO: Replace this with an efficient callback that the EachProxy
    // can implement.
    if (this._parent && this._parent._key === "@each") {
      this.value();
    }
  }

  function lazyGet(obj, key) {
    if (!obj) {
      return;
    }

    var meta = obj["__ember_meta__"];
    // check if object meant only to be a prototype
    if (meta && meta.proto === obj) {
      return;
    }

    if (key === "@each") {
      return property_get.get(obj, key);
    }

    // if a CP only return cached value
    var possibleDesc = obj[key];
    var desc = possibleDesc !== null && typeof possibleDesc === "object" && possibleDesc.isDescriptor ? possibleDesc : undefined;
    if (desc && desc._cacheable) {
      if (meta.cache && key in meta.cache) {
        return meta.cache[key];
      } else {
        return;
      }
    }

    return property_get.get(obj, key);
  }

  ChainNode.prototype = {
    value: function () {
      if (this._value === undefined && this._watching) {
        var obj = this._parent.value();
        this._value = lazyGet(obj, this._key);
      }
      return this._value;
    },

    destroy: function () {
      if (this._watching) {
        var obj = this._object;
        if (obj) {
          removeChainWatcher(obj, this._key, this);
        }
        this._watching = false; // so future calls do nothing
      }
    },

    // copies a top level object only
    copy: function (obj) {
      var ret = new ChainNode(null, null, obj);
      var paths = this._paths;
      var path;

      for (path in paths) {
        // this check will also catch non-number vals.
        if (paths[path] <= 0) {
          continue;
        }
        ret.add(path);
      }
      return ret;
    },

    // called on the root node of a chain to setup watchers on the specified
    // path.
    add: function (path) {
      var obj, tuple, key, src, paths;

      paths = this._paths;
      paths[path] = (paths[path] || 0) + 1;

      obj = this.value();
      tuple = property_get.normalizeTuple(obj, path);

      // the path was a local path
      if (tuple[0] && tuple[0] === obj) {
        path = tuple[1];
        key = firstKey(path);
        path = path.slice(key.length + 1);

        // global path, but object does not exist yet.
        // put into a queue and try to connect later.
      } else if (!tuple[0]) {
        pendingQueue.push([this, path]);
        tuple.length = 0;
        return;

        // global path, and object already exists
      } else {
        src = tuple[0];
        key = path.slice(0, 0 - (tuple[1].length + 1));
        path = tuple[1];
      }

      tuple.length = 0;
      this.chain(key, path, src);
    },

    // called on the root node of a chain to teardown watcher on the specified
    // path
    remove: function (path) {
      var obj, tuple, key, src, paths;

      paths = this._paths;
      if (paths[path] > 0) {
        paths[path]--;
      }

      obj = this.value();
      tuple = property_get.normalizeTuple(obj, path);
      if (tuple[0] === obj) {
        path = tuple[1];
        key = firstKey(path);
        path = path.slice(key.length + 1);
      } else {
        src = tuple[0];
        key = path.slice(0, 0 - (tuple[1].length + 1));
        path = tuple[1];
      }

      tuple.length = 0;
      this.unchain(key, path);
    },

    count: 0,

    chain: function (key, path, src) {
      var chains = this._chains;
      var node;
      if (!chains) {
        chains = this._chains = {};
      }

      node = chains[key];
      if (!node) {
        node = chains[key] = new ChainNode(this, key, src);
      }
      node.count++; // count chains...

      // chain rest of path if there is one
      if (path) {
        key = firstKey(path);
        path = path.slice(key.length + 1);
        node.chain(key, path); // NOTE: no src means it will observe changes...
      }
    },

    unchain: function (key, path) {
      var chains = this._chains;
      var node = chains[key];

      // unchain rest of path first...
      if (path && path.length > 1) {
        var nextKey = firstKey(path);
        var nextPath = path.slice(nextKey.length + 1);
        node.unchain(nextKey, nextPath);
      }

      // delete node if needed.
      node.count--;
      if (node.count <= 0) {
        delete chains[node._key];
        node.destroy();
      }
    },

    willChange: function (events) {
      var chains = this._chains;
      if (chains) {
        for (var key in chains) {
          if (!chains.hasOwnProperty(key)) {
            continue;
          }
          chains[key].willChange(events);
        }
      }

      if (this._parent) {
        this._parent.chainWillChange(this, this._key, 1, events);
      }
    },

    chainWillChange: function (chain, path, depth, events) {
      if (this._key) {
        path = this._key + "." + path;
      }

      if (this._parent) {
        this._parent.chainWillChange(this, path, depth + 1, events);
      } else {
        if (depth > 1) {
          events.push(this.value(), path);
        }
        path = "this." + path;
        if (this._paths[path] > 0) {
          events.push(this.value(), path);
        }
      }
    },

    chainDidChange: function (chain, path, depth, events) {
      if (this._key) {
        path = this._key + "." + path;
      }

      if (this._parent) {
        this._parent.chainDidChange(this, path, depth + 1, events);
      } else {
        if (depth > 1) {
          events.push(this.value(), path);
        }
        path = "this." + path;
        if (this._paths[path] > 0) {
          events.push(this.value(), path);
        }
      }
    },

    didChange: function (events) {
      // invalidate my own value first.
      if (this._watching) {
        var obj = this._parent.value();
        if (obj !== this._object) {
          removeChainWatcher(this._object, this._key, this);
          this._object = obj;
          addChainWatcher(obj, this._key, this);
        }
        this._value = undefined;

        // Special-case: the EachProxy relies on immediate evaluation to
        // establish its observers.
        if (this._parent && this._parent._key === "@each") {
          this.value();
        }
      }

      // then notify chains...
      var chains = this._chains;
      if (chains) {
        for (var key in chains) {
          if (!chains.hasOwnProperty(key)) {
            continue;
          }
          chains[key].didChange(events);
        }
      }

      // if no events are passed in then we only care about the above wiring update
      if (events === null) {
        return;
      }

      // and finally tell parent about my path changing...
      if (this._parent) {
        this._parent.chainDidChange(this, this._key, 1, events);
      }
    }
  };
  function finishChains(obj) {
    // We only create meta if we really have to
    var m = obj["__ember_meta__"];
    var chains, chainWatchers, chainNodes;

    if (m) {
      // finish any current chains node watchers that reference obj
      chainWatchers = m.chainWatchers;
      if (chainWatchers) {
        for (var key in chainWatchers) {
          if (!chainWatchers.hasOwnProperty(key)) {
            continue;
          }

          chainNodes = chainWatchers[key];
          if (chainNodes) {
            for (var i = 0, l = chainNodes.length; i < l; i++) {
              chainNodes[i].didChange(null);
            }
          }
        }
      }
      // copy chains from prototype
      chains = m.chains;
      if (chains && chains.value() !== obj) {
        utils.meta(obj).chains = chains = chains.copy(obj);
      }
    }
  }

});
enifed('ember-metal/computed', ['exports', 'ember-metal/property_set', 'ember-metal/utils', 'ember-metal/expand_properties', 'ember-metal/error', 'ember-metal/properties', 'ember-metal/property_events', 'ember-metal/dependent_keys'], function (exports, property_set, utils, expandProperties, EmberError, properties, property_events, dependent_keys) {

  'use strict';

  exports.ComputedProperty = ComputedProperty;
  exports.computed = computed;
  exports.cacheFor = cacheFor;

  var metaFor = utils.meta;

  function UNDEFINED() {}

  // ..........................................................
  // COMPUTED PROPERTY
  //

  /**
    A computed property transforms an object's function into a property.

    By default the function backing the computed property will only be called
    once and the result will be cached. You can specify various properties
    that your computed property depends on. This will force the cached
    result to be recomputed if the dependencies are modified.

    In the following example we declare a computed property (by calling
    `.property()` on the fullName function) and setup the property
    dependencies (depending on firstName and lastName). The fullName function
    will be called once (regardless of how many times it is accessed) as long
    as its dependencies have not changed. Once firstName or lastName are updated
    any future calls (or anything bound) to fullName will incorporate the new
    values.

    ```javascript
    var Person = Ember.Object.extend({
      // these will be supplied by `create`
      firstName: null,
      lastName: null,

      fullName: function() {
        var firstName = this.get('firstName');
        var lastName = this.get('lastName');

       return firstName + ' ' + lastName;
      }.property('firstName', 'lastName')
    });

    var tom = Person.create({
      firstName: 'Tom',
      lastName: 'Dale'
    });

    tom.get('fullName') // 'Tom Dale'
    ```

    You can also define what Ember should do when setting a computed property.
    If you try to set a computed property, it will be invoked with the key and
    value you want to set it to. You can also accept the previous value as the
    third parameter.

    ```javascript
    var Person = Ember.Object.extend({
      // these will be supplied by `create`
      firstName: null,
      lastName: null,

      fullName: function(key, value, oldValue) {
        // getter
        if (arguments.length === 1) {
          var firstName = this.get('firstName');
          var lastName = this.get('lastName');

          return firstName + ' ' + lastName;

        // setter
        } else {
          var name = value.split(' ');

          this.set('firstName', name[0]);
          this.set('lastName', name[1]);

          return value;
        }
      }.property('firstName', 'lastName')
    });

    var person = Person.create();

    person.set('fullName', 'Peter Wagenet');
    person.get('firstName'); // 'Peter'
    person.get('lastName');  // 'Wagenet'
    ```

    @class ComputedProperty
    @namespace Ember
    @constructor
  */
  function ComputedProperty(config, opts) {
    this.isDescriptor = true;
    
      if (typeof config === "function") {
        config.__ember_arity = config.length;
        this._getter = config;
        if (config.__ember_arity > 1) {
                    this._setter = config;
        }
      } else {
        this._getter = config.get;
        this._setter = config.set;
        if (this._setter && this._setter.__ember_arity === undefined) {
          this._setter.__ember_arity = this._setter.length;
        }
      }
    
    this._dependentKeys = undefined;
    this._suspended = undefined;
    this._meta = undefined;

        this._cacheable = opts && opts.cacheable !== undefined ? opts.cacheable : true; // TODO: Set always to `true` once this deprecation is gone.
    this._dependentKeys = opts && opts.dependentKeys;
        this._readOnly = opts && (opts.readOnly !== undefined || !!opts.readOnly) || false; // TODO: Set always to `false` once this deprecation is gone.
  }

  ComputedProperty.prototype = new properties.Descriptor();

  var ComputedPropertyPrototype = ComputedProperty.prototype;

  /**
    Properties are cacheable by default. Computed property will automatically
    cache the return value of your function until one of the dependent keys changes.

    Call `volatile()` to set it into non-cached mode. When in this mode
    the computed property will not automatically cache the return value.

    However, if a property is properly observable, there is no reason to disable
    caching.

    @method cacheable
    @param {Boolean} aFlag optional set to `false` to disable caching
    @return {Ember.ComputedProperty} this
    @chainable
    @deprecated All computed properties are cacheble by default. Use `volatile()` instead to opt-out to caching.
  */
  ComputedPropertyPrototype.cacheable = function (aFlag) {
        this._cacheable = aFlag !== false;
    return this;
  };

  /**
    Call on a computed property to set it into non-cached mode. When in this
    mode the computed property will not automatically cache the return value.

    ```javascript
    var outsideService = Ember.Object.extend({
      value: function() {
        return OutsideService.getValue();
      }.property().volatile()
    }).create();
    ```

    @method volatile
    @return {Ember.ComputedProperty} this
    @chainable
  */
  ComputedPropertyPrototype["volatile"] = function () {
    this._cacheable = false;
    return this;
  };

  /**
    Call on a computed property to set it into read-only mode. When in this
    mode the computed property will throw an error when set.

    ```javascript
    var Person = Ember.Object.extend({
      guid: function() {
        return 'guid-guid-guid';
      }.property().readOnly()
    });

    var person = Person.create();

    person.set('guid', 'new-guid'); // will throw an exception
    ```

    @method readOnly
    @return {Ember.ComputedProperty} this
    @chainable
  */
  ComputedPropertyPrototype.readOnly = function (readOnly) {
        this._readOnly = readOnly === undefined || !!readOnly; // Force to true once this deprecation is gone
    
    return this;
  };

  /**
    Sets the dependent keys on this computed property. Pass any number of
    arguments containing key paths that this computed property depends on.

    ```javascript
    var President = Ember.Object.extend({
      fullName: computed(function() {
        return this.get('firstName') + ' ' + this.get('lastName');

        // Tell Ember that this computed property depends on firstName
        // and lastName
      }).property('firstName', 'lastName')
    });

    var president = President.create({
      firstName: 'Barack',
      lastName: 'Obama'
    });

    president.get('fullName'); // 'Barack Obama'
    ```

    @method property
    @param {String} path* zero or more property paths
    @return {Ember.ComputedProperty} this
    @chainable
  */
  ComputedPropertyPrototype.property = function () {
    var args;

    var addArg = function (property) {
      args.push(property);
    };

    args = [];
    for (var i = 0, l = arguments.length; i < l; i++) {
      expandProperties['default'](arguments[i], addArg);
    }

    this._dependentKeys = args;
    return this;
  };

  /**
    In some cases, you may want to annotate computed properties with additional
    metadata about how they function or what values they operate on. For example,
    computed property functions may close over variables that are then no longer
    available for introspection.

    You can pass a hash of these values to a computed property like this:

    ```
    person: function() {
      var personId = this.get('personId');
      return App.Person.create({ id: personId });
    }.property().meta({ type: App.Person })
    ```

    The hash that you pass to the `meta()` function will be saved on the
    computed property descriptor under the `_meta` key. Ember runtime
    exposes a public API for retrieving these values from classes,
    via the `metaForProperty()` function.

    @method meta
    @param {Hash} meta
    @chainable
  */

  ComputedPropertyPrototype.meta = function (meta) {
    if (arguments.length === 0) {
      return this._meta || {};
    } else {
      this._meta = meta;
      return this;
    }
  };

  /* impl descriptor API */
  ComputedPropertyPrototype.didChange = function (obj, keyName) {
    // _suspended is set via a CP.set to ensure we don't clear
    // the cached value set by the setter
    if (this._cacheable && this._suspended !== obj) {
      var meta = metaFor(obj);
      if (meta.cache && meta.cache[keyName] !== undefined) {
        meta.cache[keyName] = undefined;
        dependent_keys.removeDependentKeys(this, obj, keyName, meta);
      }
    }
  };

  function finishChains(chainNodes) {
    for (var i = 0, l = chainNodes.length; i < l; i++) {
      chainNodes[i].didChange(null);
    }
  }

  /**
    Access the value of the function backing the computed property.
    If this property has already been cached, return the cached result.
    Otherwise, call the function passing the property name as an argument.

    ```javascript
    var Person = Ember.Object.extend({
      fullName: function(keyName) {
        // the keyName parameter is 'fullName' in this case.
        return this.get('firstName') + ' ' + this.get('lastName');
      }.property('firstName', 'lastName')
    });


    var tom = Person.create({
      firstName: 'Tom',
      lastName: 'Dale'
    });

    tom.get('fullName') // 'Tom Dale'
    ```

    @method get
    @param {String} keyName The key being accessed.
    @return {Object} The return value of the function backing the CP.
  */
  ComputedPropertyPrototype.get = function (obj, keyName) {
    var ret, cache, meta, chainNodes;
    if (this._cacheable) {
      meta = metaFor(obj);
      cache = meta.cache;

      var result = cache && cache[keyName];

      if (result === UNDEFINED) {
        return undefined;
      } else if (result !== undefined) {
        return result;
      }

      ret = this._getter.call(obj, keyName);
      cache = meta.cache;
      if (!cache) {
        cache = meta.cache = {};
      }
      if (ret === undefined) {
        cache[keyName] = UNDEFINED;
      } else {
        cache[keyName] = ret;
      }

      chainNodes = meta.chainWatchers && meta.chainWatchers[keyName];
      if (chainNodes) {
        finishChains(chainNodes);
      }
      dependent_keys.addDependentKeys(this, obj, keyName, meta);
    } else {
      ret = this._getter.call(obj, keyName);
    }
    return ret;
  };

  /**
    Set the value of a computed property. If the function that backs your
    computed property does not accept arguments then the default action for
    setting would be to define the property on the current object, and set
    the value of the property to the value being set.

    Generally speaking if you intend for your computed property to be set
    your backing function should accept either two or three arguments.

    ```javascript
    var Person = Ember.Object.extend({
      // these will be supplied by `create`
      firstName: null,
      lastName: null,

      fullName: function(key, value, oldValue) {
        // getter
        if (arguments.length === 1) {
          var firstName = this.get('firstName');
          var lastName = this.get('lastName');

          return firstName + ' ' + lastName;

        // setter
        } else {
          var name = value.split(' ');

          this.set('firstName', name[0]);
          this.set('lastName', name[1]);

          return value;
        }
      }.property('firstName', 'lastName')
    });

    var person = Person.create();

    person.set('fullName', 'Peter Wagenet');
    person.get('firstName'); // 'Peter'
    person.get('lastName');  // 'Wagenet'
    ```

    @method set
    @param {String} keyName The key being accessed.
    @param {Object} newValue The new value being assigned.
    @param {String} oldValue The old value being replaced.
    @return {Object} The return value of the function backing the CP.
  */
  ComputedPropertyPrototype.set = function computedPropertySetWithSuspend(obj, keyName, value) {
    var oldSuspended = this._suspended;

    this._suspended = obj;

    try {
      this._set(obj, keyName, value);
    } finally {
      this._suspended = oldSuspended;
    }
  };

  ComputedPropertyPrototype._set = function computedPropertySet(obj, keyName, value) {
    var cacheable = this._cacheable;
    var setter = this._setter;
    var meta = metaFor(obj, cacheable);
    var cache = meta.cache;
    var hadCachedValue = false;

    var cachedValue, ret;

    if (this._readOnly) {
      throw new EmberError['default']("Cannot set read-only property \"" + keyName + "\" on object: " + utils.inspect(obj));
    }

    if (cacheable && cache && cache[keyName] !== undefined) {
      if (cache[keyName] !== UNDEFINED) {
        cachedValue = cache[keyName];
      }

      hadCachedValue = true;
    }

    if (!setter) {
      properties.defineProperty(obj, keyName, null, cachedValue);
      property_set.set(obj, keyName, value);
      return;
    } else if (setter.__ember_arity === 2) {
      // Is there any way of deprecate this in a sensitive way?
      // Maybe now that getters and setters are the prefered options we can....
      ret = setter.call(obj, keyName, value);
    } else {
      ret = setter.call(obj, keyName, value, cachedValue);
    }

    if (hadCachedValue && cachedValue === ret) {
      return;
    }

    var watched = meta.watching[keyName];
    if (watched) {
      property_events.propertyWillChange(obj, keyName);
    }

    if (hadCachedValue) {
      cache[keyName] = undefined;
    }

    if (cacheable) {
      if (!hadCachedValue) {
        dependent_keys.addDependentKeys(this, obj, keyName, meta);
      }
      if (!cache) {
        cache = meta.cache = {};
      }
      if (ret === undefined) {
        cache[keyName] = UNDEFINED;
      } else {
        cache[keyName] = ret;
      }
    }

    if (watched) {
      property_events.propertyDidChange(obj, keyName);
    }

    return ret;
  };

  /* called before property is overridden */
  ComputedPropertyPrototype.teardown = function (obj, keyName) {
    var meta = metaFor(obj);

    if (meta.cache) {
      if (keyName in meta.cache) {
        dependent_keys.removeDependentKeys(this, obj, keyName, meta);
      }

      if (this._cacheable) {
        delete meta.cache[keyName];
      }
    }

    return null; // no value to restore
  };

  /**
    This helper returns a new property descriptor that wraps the passed
    computed property function. You can use this helper to define properties
    with mixins or via `Ember.defineProperty()`.

    The function you pass will be used to both get and set property values.
    The function should accept two parameters, key and value. If value is not
    undefined you should set the value first. In either case return the
    current value of the property.

    A computed property defined in this way might look like this:

    ```js
    var Person = Ember.Object.extend({
      firstName: 'Betty',
      lastName: 'Jones',

      fullName: Ember.computed('firstName', 'lastName', function(key, value) {
        return this.get('firstName') + ' ' + this.get('lastName');
      })
    });

    var client = Person.create();

    client.get('fullName'); // 'Betty Jones'

    client.set('lastName', 'Fuller');
    client.get('fullName'); // 'Betty Fuller'
    ```

    _Note: This is the preferred way to define computed properties when writing third-party
    libraries that depend on or use Ember, since there is no guarantee that the user
    will have prototype extensions enabled._

    You might use this method if you disabled
    [Prototype Extensions](http://emberjs.com/guides/configuring-ember/disabling-prototype-extensions/).
    The alternative syntax might look like this
    (if prototype extensions are enabled, which is the default behavior):

    ```js
    fullName: function () {
      return this.get('firstName') + ' ' + this.get('lastName');
    }.property('firstName', 'lastName')
    ```

    @class computed
    @namespace Ember
    @constructor
    @static
    @param {String} [dependentKeys*] Optional dependent keys that trigger this computed property.
    @param {Function} func The computed property function.
    @return {Ember.ComputedProperty} property descriptor instance
  */
  function computed(func) {
    var args;

    if (arguments.length > 1) {
      args = [].slice.call(arguments);
      func = args.pop();
    }

    var cp = new ComputedProperty(func);
    // jscs:disable
    
    if (args) {
      cp.property.apply(cp, args);
    }

    return cp;
  }

  /**
    Returns the cached value for a property, if one exists.
    This can be useful for peeking at the value of a computed
    property that is generated lazily, without accidentally causing
    it to be created.

    @method cacheFor
    @for Ember
    @param {Object} obj the object whose property you want to check
    @param {String} key the name of the property whose cached value you want
      to return
    @return {Object} the cached value
  */
  function cacheFor(obj, key) {
    var meta = obj["__ember_meta__"];
    var cache = meta && meta.cache;
    var ret = cache && cache[key];

    if (ret === UNDEFINED) {
      return undefined;
    }
    return ret;
  }

  cacheFor.set = function (cache, key, value) {
    if (value === undefined) {
      cache[key] = UNDEFINED;
    } else {
      cache[key] = value;
    }
  };

  cacheFor.get = function (cache, key) {
    var ret = cache[key];
    if (ret === UNDEFINED) {
      return undefined;
    }
    return ret;
  };

  cacheFor.remove = function (cache, key) {
    cache[key] = undefined;
  };

});
enifed('ember-metal/computed_macros', ['exports', 'ember-metal/core', 'ember-metal/property_get', 'ember-metal/property_set', 'ember-metal/computed', 'ember-metal/is_empty', 'ember-metal/is_none', 'ember-metal/alias'], function (exports, Ember, property_get, property_set, computed, isEmpty, isNone, alias) {

  'use strict';

  exports.empty = empty;
  exports.notEmpty = notEmpty;
  exports.none = none;
  exports.not = not;
  exports.bool = bool;
  exports.match = match;
  exports.equal = equal;
  exports.gt = gt;
  exports.gte = gte;
  exports.lt = lt;
  exports.lte = lte;
  exports.oneWay = oneWay;
  exports.readOnly = readOnly;
  exports.defaultTo = defaultTo;
  exports.deprecatingAlias = deprecatingAlias;

  /**
    A computed property that returns true if the value of the dependent
    property is null, an empty string, empty array, or empty function.

    Example

    ```javascript
    var ToDoList = Ember.Object.extend({
      isDone: Ember.computed.empty('todos')
    });

    var todoList = ToDoList.create({
      todos: ['Unit Test', 'Documentation', 'Release']
    });

    todoList.get('isDone'); // false
    todoList.get('todos').clear();
    todoList.get('isDone'); // true
    ```

    @since 1.6.0
    @method empty
    @for Ember.computed
    @param {String} dependentKey
    @return {Ember.ComputedProperty} computed property which negate
    the original value for property
  */
  function getProperties(self, propertyNames) {
    var ret = {};
    for (var i = 0; i < propertyNames.length; i++) {
      ret[propertyNames[i]] = property_get.get(self, propertyNames[i]);
    }
    return ret;
  }

  function generateComputedWithProperties(macro) {
    return function () {
      for (var _len = arguments.length, properties = Array(_len), _key = 0; _key < _len; _key++) {
        properties[_key] = arguments[_key];
      }

      var computedFunc = computed.computed(function () {
        return macro.apply(this, [getProperties(this, properties)]);
      });

      return computedFunc.property.apply(computedFunc, properties);
    };
  }
  function empty(dependentKey) {
    return computed.computed(dependentKey + ".length", function () {
      return isEmpty['default'](property_get.get(this, dependentKey));
    });
  }

  function notEmpty(dependentKey) {
    return computed.computed(dependentKey + ".length", function () {
      return !isEmpty['default'](property_get.get(this, dependentKey));
    });
  }

  function none(dependentKey) {
    return computed.computed(dependentKey, function () {
      return isNone['default'](property_get.get(this, dependentKey));
    });
  }

  function not(dependentKey) {
    return computed.computed(dependentKey, function () {
      return !property_get.get(this, dependentKey);
    });
  }

  function bool(dependentKey) {
    return computed.computed(dependentKey, function () {
      return !!property_get.get(this, dependentKey);
    });
  }

  function match(dependentKey, regexp) {
    return computed.computed(dependentKey, function () {
      var value = property_get.get(this, dependentKey);

      return typeof value === "string" ? regexp.test(value) : false;
    });
  }

  function equal(dependentKey, value) {
    return computed.computed(dependentKey, function () {
      return property_get.get(this, dependentKey) === value;
    });
  }

  function gt(dependentKey, value) {
    return computed.computed(dependentKey, function () {
      return property_get.get(this, dependentKey) > value;
    });
  }

  function gte(dependentKey, value) {
    return computed.computed(dependentKey, function () {
      return property_get.get(this, dependentKey) >= value;
    });
  }

  function lt(dependentKey, value) {
    return computed.computed(dependentKey, function () {
      return property_get.get(this, dependentKey) < value;
    });
  }

  function lte(dependentKey, value) {
    return computed.computed(dependentKey, function () {
      return property_get.get(this, dependentKey) <= value;
    });
  }

  /**
    A computed property that performs a logical `and` on the
    original values for the provided dependent properties.

    Example

    ```javascript
    var Hamster = Ember.Object.extend({
      readyForCamp: Ember.computed.and('hasTent', 'hasBackpack')
    });

    var hamster = Hamster.create();

    hamster.get('readyForCamp'); // false
    hamster.set('hasTent', true);
    hamster.get('readyForCamp'); // false
    hamster.set('hasBackpack', true);
    hamster.get('readyForCamp'); // true
    hamster.set('hasBackpack', 'Yes');
    hamster.get('readyForCamp'); // 'Yes'
    ```

    @method and
    @for Ember.computed
    @param {String} dependentKey*
    @return {Ember.ComputedProperty} computed property which performs
    a logical `and` on the values of all the original values for properties.
  */
  var and = generateComputedWithProperties(function (properties) {
    var value;
    for (var key in properties) {
      value = properties[key];
      if (properties.hasOwnProperty(key) && !value) {
        return false;
      }
    }
    return value;
  });

  var or = generateComputedWithProperties(function (properties) {
    for (var key in properties) {
      if (properties.hasOwnProperty(key) && properties[key]) {
        return properties[key];
      }
    }
    return false;
  });

  var any = generateComputedWithProperties(function (properties) {
    for (var key in properties) {
      if (properties.hasOwnProperty(key) && properties[key]) {
        return properties[key];
      }
    }
    return null;
  });

  var collect = generateComputedWithProperties(function (properties) {
    var res = Ember['default'].A();
    for (var key in properties) {
      if (properties.hasOwnProperty(key)) {
        if (isNone['default'](properties[key])) {
          res.push(null);
        } else {
          res.push(properties[key]);
        }
      }
    }
    return res;
  });function oneWay(dependentKey) {
    return alias['default'](dependentKey).oneWay();
  }

  function readOnly(dependentKey) {
    return alias['default'](dependentKey).readOnly();
  }

  function defaultTo(defaultPath) {
    return computed.computed({
      get: function (key) {
                return property_get.get(this, defaultPath);
      },

      set: function (key, newValue, cachedValue) {
                return newValue != null ? newValue : property_get.get(this, defaultPath);
      }
    });
  }

  function deprecatingAlias(dependentKey) {
    return computed.computed(dependentKey, {
      get: function (key) {
                return property_get.get(this, dependentKey);
      },
      set: function (key, value) {
                property_set.set(this, dependentKey, value);
        return value;
      }
    });
  }

  exports.and = and;
  exports.or = or;
  exports.any = any;
  exports.collect = collect;

});
enifed('ember-metal/core', ['exports'], function (exports) {

  'use strict';

  exports.K = K;

  /*globals Ember:true,ENV,EmberENV */

  /**
  @module ember
  @submodule ember-metal
  */

  /**
    All Ember methods and functions are defined inside of this namespace. You
    generally should not add new properties to this namespace as it may be
    overwritten by future versions of Ember.

    You can also use the shorthand `Em` instead of `Ember`.

    Ember-Runtime is a framework that provides core functions for Ember including
    cross-platform functions, support for property observing and objects. Its
    focus is on small size and performance. You can use this in place of or
    along-side other cross-platform libraries such as jQuery.

    The core Runtime framework is based on the jQuery API with a number of
    performance optimizations.

    @class Ember
    @static
    @version 1.12.0
  */

  if ('undefined' === typeof Ember) {
    // Create core object. Make it act like an instance of Ember.Namespace so that
    // objects assigned to it are given a sane string representation.
    Ember = {};
  }

  // Default imports, exports and lookup to the global object;
  var global = mainContext || {}; // jshint ignore:line
  Ember.imports = Ember.imports || global;
  Ember.lookup = Ember.lookup || global;
  var emExports = Ember.exports = Ember.exports || global;

  // aliases needed to keep minifiers from removing the global context
  emExports.Em = emExports.Ember = Ember;

  // Make sure these are set whether Ember was already defined or not

  Ember.isNamespace = true;

  Ember.toString = function () {
    return 'Ember';
  };

  /**
    @property VERSION
    @type String
    @default '1.12.0'
    @static
  */
  Ember.VERSION = '1.12.0';

  /**
    Standard environmental variables. You can define these in a global `EmberENV`
    variable before loading Ember to control various configuration settings.

    For backwards compatibility with earlier versions of Ember the global `ENV`
    variable will be used if `EmberENV` is not defined.

    @property ENV
    @type Hash
  */

  if (Ember.ENV) {
    // do nothing if Ember.ENV is already setup
      } else if ('undefined' !== typeof EmberENV) {
    Ember.ENV = EmberENV;
  } else if ('undefined' !== typeof ENV) {
    Ember.ENV = ENV;
  } else {
    Ember.ENV = {};
  }

  Ember.config = Ember.config || {};

  // We disable the RANGE API by default for performance reasons
  if ('undefined' === typeof Ember.ENV.DISABLE_RANGE_API) {
    Ember.ENV.DISABLE_RANGE_API = true;
  }

  /**
    Hash of enabled Canary features. Add to this before creating your application.

    You can also define `EmberENV.FEATURES` if you need to enable features flagged at runtime.

    @class FEATURES
    @namespace Ember
    @static
    @since 1.1.0
  */
  Ember.FEATURES = {"features-stripped-test":false,"ember-routing-named-substates":true,"mandatory-setter":false,"ember-htmlbars-component-generation":false,"ember-htmlbars-component-helper":true,"ember-htmlbars-inline-if-helper":true,"ember-htmlbars-attribute-syntax":true,"ember-routing-transitioning-classes":true,"new-computed-syntax":true,"ember-testing-checkbox-helpers":false,"ember-metal-stream":false,"ember-application-instance-initializers":true,"ember-application-initializer-context":true,"ember-router-willtransition":true,"ember-application-visit":false,"ember-views-component-block-info":false,"ember-routing-core-outlet":false,"ember-libraries-isregistered":false}; //jshint ignore:line

  if (Ember.ENV.FEATURES) {
    for (var feature in Ember.ENV.FEATURES) {
      if (Ember.ENV.FEATURES.hasOwnProperty(feature)) {
        Ember.FEATURES[feature] = Ember.ENV.FEATURES[feature];
      }
    }
  }

  /**
    Test that a feature is enabled. Parsed by Ember's build tools to leave
    experimental features out of beta/stable builds.

    You can define the following configuration options:

    * `EmberENV.ENABLE_ALL_FEATURES` - force all features to be enabled.
    * `EmberENV.ENABLE_OPTIONAL_FEATURES` - enable any features that have not been explicitly
      enabled/disabled.

    @method isEnabled
    @param {String} feature
    @return {Boolean}
    @for Ember.FEATURES
    @since 1.1.0
  */

  Ember.FEATURES.isEnabled = function (feature) {
    var featureValue = Ember.FEATURES[feature];

    if (Ember.ENV.ENABLE_ALL_FEATURES) {
      return true;
    } else if (featureValue === true || featureValue === false || featureValue === undefined) {
      return featureValue;
    } else if (Ember.ENV.ENABLE_OPTIONAL_FEATURES) {
      return true;
    } else {
      return false;
    }
  };

  // ..........................................................
  // BOOTSTRAP
  //

  /**
    Determines whether Ember should enhance some built-in object prototypes to
    provide a more friendly API. If enabled, a few methods will be added to
    `Function`, `String`, and `Array`. `Object.prototype` will not be enhanced,
    which is the one that causes most trouble for people.

    In general we recommend leaving this option set to true since it rarely
    conflicts with other code. If you need to turn it off however, you can
    define an `EmberENV.EXTEND_PROTOTYPES` config to disable it.

    @property EXTEND_PROTOTYPES
    @type Boolean
    @default true
    @for Ember
  */
  Ember.EXTEND_PROTOTYPES = Ember.ENV.EXTEND_PROTOTYPES;

  if (typeof Ember.EXTEND_PROTOTYPES === 'undefined') {
    Ember.EXTEND_PROTOTYPES = true;
  }

  /**
    Determines whether Ember logs a full stack trace during deprecation warnings

    @property LOG_STACKTRACE_ON_DEPRECATION
    @type Boolean
    @default true
  */
  Ember.LOG_STACKTRACE_ON_DEPRECATION = Ember.ENV.LOG_STACKTRACE_ON_DEPRECATION !== false;

  /**
    Determines whether Ember should add ECMAScript 5 Array shims to older browsers.

    @property SHIM_ES5
    @type Boolean
    @default Ember.EXTEND_PROTOTYPES
  */
  Ember.SHIM_ES5 = Ember.ENV.SHIM_ES5 === false ? false : Ember.EXTEND_PROTOTYPES;

  /**
    Determines whether Ember logs info about version of used libraries

    @property LOG_VERSION
    @type Boolean
    @default true
  */
  Ember.LOG_VERSION = Ember.ENV.LOG_VERSION === false ? false : true;

  /**
    Empty function. Useful for some operations. Always returns `this`.

    @method K
    @private
    @return {Object}
  */
  function K() {
    return this;
  }
  Ember.K = K;
  //TODO: ES6 GLOBAL TODO

  // Stub out the methods defined by the ember-debug package in case it's not loaded

  if ('undefined' === typeof Ember.assert) {
    Ember.assert = K;
  }
  if ('undefined' === typeof Ember.warn) {
    Ember.warn = K;
  }
  if ('undefined' === typeof Ember.debug) {
    Ember.debug = K;
  }
  if ('undefined' === typeof Ember.runInDebug) {
    Ember.runInDebug = K;
  }
  if ('undefined' === typeof Ember.deprecate) {
    Ember.deprecate = K;
  }
  if ('undefined' === typeof Ember.deprecateFunc) {
    Ember.deprecateFunc = function (_, func) {
      return func;
    };
  }

  exports['default'] = Ember;

});
enifed('ember-metal/dependent_keys', ['exports', 'ember-metal/platform/create', 'ember-metal/watching'], function (exports, o_create, watching) {

  
  exports.addDependentKeys = addDependentKeys;
  exports.removeDependentKeys = removeDependentKeys;

  "REMOVE_USE_STRICT: true"; /**
                             @module ember-metal
                             */

  // ..........................................................
  // DEPENDENT KEYS
  //

  // data structure:
  //  meta.deps = {
  //    'depKey': {
  //      'keyName': count,
  //    }
  //  }

  /*
    This function returns a map of unique dependencies for a
    given object and key.
  */
  function keysForDep(depsMeta, depKey) {
    var keys = depsMeta[depKey];
    if (!keys) {
      // if there are no dependencies yet for a the given key
      // create a new empty list of dependencies for the key
      keys = depsMeta[depKey] = {};
    } else if (!depsMeta.hasOwnProperty(depKey)) {
      // otherwise if the dependency list is inherited from
      // a superclass, clone the hash
      keys = depsMeta[depKey] = o_create['default'](keys);
    }
    return keys;
  }

  function metaForDeps(meta) {
    return keysForDep(meta, "deps");
  }
  function addDependentKeys(desc, obj, keyName, meta) {
    // the descriptor has a list of dependent keys, so
    // add all of its dependent keys.
    var depsMeta, idx, len, depKey, keys;
    var depKeys = desc._dependentKeys;
    if (!depKeys) {
      return;
    }

    depsMeta = metaForDeps(meta);

    for (idx = 0, len = depKeys.length; idx < len; idx++) {
      depKey = depKeys[idx];
      // Lookup keys meta for depKey
      keys = keysForDep(depsMeta, depKey);
      // Increment the number of times depKey depends on keyName.
      keys[keyName] = (keys[keyName] || 0) + 1;
      // Watch the depKey
      watching.watch(obj, depKey, meta);
    }
  }

  function removeDependentKeys(desc, obj, keyName, meta) {
    // the descriptor has a list of dependent keys, so
    // remove all of its dependent keys.
    var depKeys = desc._dependentKeys;
    var depsMeta, idx, len, depKey, keys;
    if (!depKeys) {
      return;
    }

    depsMeta = metaForDeps(meta);

    for (idx = 0, len = depKeys.length; idx < len; idx++) {
      depKey = depKeys[idx];
      // Lookup keys meta for depKey
      keys = keysForDep(depsMeta, depKey);
      // Decrement the number of times depKey depends on keyName.
      keys[keyName] = (keys[keyName] || 0) - 1;
      // Unwatch the depKey
      watching.unwatch(obj, depKey, meta);
    }
  }

});
enifed('ember-metal/deprecate_property', ['exports', 'ember-metal/core', 'ember-metal/platform/define_property', 'ember-metal/properties', 'ember-metal/property_get', 'ember-metal/property_set'], function (exports, Ember, define_property, properties, property_get, property_set) {

  'use strict';

  exports.deprecateProperty = deprecateProperty;

  /**
    Used internally to allow changing properties in a backwards compatible way, and print a helpful
    deprecation warning.

    @method deprecateProperty
    @param {Object} object The object to add the deprecated property to.
    @param {String} deprecatedKey The property to add (and print deprecation warnings upon accessing).
    @param {String} newKey The property that will be aliased.
    @private
    @since 1.7.0
  */

  function deprecateProperty(object, deprecatedKey, newKey) {
    function deprecate() {
          }

    if (define_property.hasPropertyAccessors) {
      properties.defineProperty(object, deprecatedKey, {
        configurable: true,
        enumerable: false,
        set: function (value) {
          deprecate();
          property_set.set(this, newKey, value);
        },
        get: function () {
          deprecate();
          return property_get.get(this, newKey);
        }
      });
    }
  }

});
enifed('ember-metal/dictionary', ['exports', 'ember-metal/platform/create'], function (exports, create) {

  'use strict';



  // the delete is meant to hint at runtimes that this object should remain in
  // dictionary mode. This is clearly a runtime specific hack, but currently it
  // appears worthwhile in some usecases. Please note, these deletes do increase
  // the cost of creation dramatically over a plain Object.create. And as this
  // only makes sense for long-lived dictionaries that aren't instantiated often.
  exports['default'] = makeDictionary;
  function makeDictionary(parent) {
    var dict = create['default'](parent);
    dict['_dict'] = null;
    delete dict['_dict'];
    return dict;
  }

});
enifed('ember-metal/enumerable_utils', ['exports', 'ember-metal/array'], function (exports, ember_metal__array) {

  'use strict';

  exports.map = map;
  exports.forEach = forEach;
  exports.filter = filter;
  exports.indexOf = indexOf;
  exports.indexesOf = indexesOf;
  exports.addObject = addObject;
  exports.removeObject = removeObject;
  exports._replace = _replace;
  exports.replace = replace;
  exports.intersection = intersection;

  /**
   * Defines some convenience methods for working with Enumerables.
   * `Ember.EnumerableUtils` uses `Ember.ArrayPolyfills` when necessary.
   *
   * @class EnumerableUtils
   * @namespace Ember
   * @static
   * */

  /**
   * Calls the map function on the passed object with a specified callback. This
   * uses `Ember.ArrayPolyfill`'s-map method when necessary.
   *
   * @method map
   * @param {Object} obj The object that should be mapped
   * @param {Function} callback The callback to execute
   * @param {Object} thisArg Value to use as this when executing *callback*
   *
   * @return {Array} An array of mapped values.
   */
  var splice = Array.prototype.splice;
  function map(obj, callback, thisArg) {
    return obj.map ? obj.map(callback, thisArg) : ember_metal__array.map.call(obj, callback, thisArg);
  }

  function forEach(obj, callback, thisArg) {
    return obj.forEach ? obj.forEach(callback, thisArg) : ember_metal__array.forEach.call(obj, callback, thisArg);
  }

  function filter(obj, callback, thisArg) {
    return obj.filter ? obj.filter(callback, thisArg) : ember_metal__array.filter.call(obj, callback, thisArg);
  }

  function indexOf(obj, element, index) {
    return obj.indexOf ? obj.indexOf(element, index) : ember_metal__array.indexOf.call(obj, element, index);
  }

  function indexesOf(obj, elements) {
    return elements === undefined ? [] : map(elements, function (item) {
      return indexOf(obj, item);
    });
  }

  function addObject(array, item) {
    var index = indexOf(array, item);
    if (index === -1) {
      array.push(item);
    }
  }

  function removeObject(array, item) {
    var index = indexOf(array, item);
    if (index !== -1) {
      array.splice(index, 1);
    }
  }

  function _replace(array, idx, amt, objects) {
    var args = [].concat(objects);
    var ret = [];
    // https://code.google.com/p/chromium/issues/detail?id=56588
    var size = 60000;
    var start = idx;
    var ends = amt;
    var count, chunk;

    while (args.length) {
      count = ends > size ? size : ends;
      if (count <= 0) {
        count = 0;
      }

      chunk = args.splice(0, size);
      chunk = [start, count].concat(chunk);

      start += size;
      ends -= count;

      ret = ret.concat(splice.apply(array, chunk));
    }
    return ret;
  }

  function replace(array, idx, amt, objects) {
    if (array.replace) {
      return array.replace(idx, amt, objects);
    } else {
      return _replace(array, idx, amt, objects);
    }
  }

  function intersection(array1, array2) {
    var result = [];
    forEach(array1, function (element) {
      if (indexOf(array2, element) >= 0) {
        result.push(element);
      }
    });

    return result;
  }

  // TODO: this only exists to maintain the existing api, as we move forward it
  // should only be part of the "global build" via some shim
  exports['default'] = {
    _replace: _replace,
    addObject: addObject,
    filter: filter,
    forEach: forEach,
    indexOf: indexOf,
    indexesOf: indexesOf,
    intersection: intersection,
    map: map,
    removeObject: removeObject,
    replace: replace
  };

});
enifed('ember-metal/environment', ['exports', 'ember-metal/core'], function (exports, Ember) {

  'use strict';

  var environment;

  // This code attempts to automatically detect an environment with DOM
  // by searching for window and document.createElement. An environment
  // with DOM may disable the DOM functionality of Ember explicitly by
  // defining a `disableBrowserEnvironment` ENV.
  var hasDOM = typeof window !== 'undefined' && typeof document !== 'undefined' && typeof document.createElement !== 'undefined' && !Ember['default'].ENV.disableBrowserEnvironment;

  if (hasDOM) {
    environment = {
      hasDOM: true,
      isChrome: !!window.chrome && !window.opera,
      location: window.location,
      history: window.history,
      userAgent: window.navigator.userAgent,
      global: window
    };
  } else {
    environment = {
      hasDOM: false,
      isChrome: false,
      location: null,
      history: null,
      userAgent: 'Lynx (textmode)',
      global: null
    };
  }

  exports['default'] = environment;

});
enifed('ember-metal/error', ['exports', 'ember-metal/platform/create'], function (exports, create) {

  'use strict';

  var errorProps = ['description', 'fileName', 'lineNumber', 'message', 'name', 'number', 'stack'];

  /**
    A subclass of the JavaScript Error object for use in Ember.

    @class Error
    @namespace Ember
    @extends Error
    @constructor
  */
  function EmberError() {
    var tmp = Error.apply(this, arguments);

    // Adds a `stack` property to the given error object that will yield the
    // stack trace at the time captureStackTrace was called.
    // When collecting the stack trace all frames above the topmost call
    // to this function, including that call, will be left out of the
    // stack trace.
    // This is useful because we can hide Ember implementation details
    // that are not very helpful for the user.
    if (Error.captureStackTrace) {
      Error.captureStackTrace(this, Ember.Error);
    }
    // Unfortunately errors are not enumerable in Chrome (at least), so `for prop in tmp` doesn't work.
    for (var idx = 0; idx < errorProps.length; idx++) {
      this[errorProps[idx]] = tmp[errorProps[idx]];
    }
  }

  EmberError.prototype = create['default'](Error.prototype);

  exports['default'] = EmberError;

});
enifed('ember-metal/events', ['exports', 'ember-metal/core', 'ember-metal/utils', 'ember-metal/platform/create'], function (exports, Ember, utils, create) {

  
  exports.accumulateListeners = accumulateListeners;
  exports.addListener = addListener;
  exports.suspendListener = suspendListener;
  exports.suspendListeners = suspendListeners;
  exports.watchedEvents = watchedEvents;
  exports.sendEvent = sendEvent;
  exports.hasListeners = hasListeners;
  exports.listenersFor = listenersFor;
  exports.on = on;
  exports.removeListener = removeListener;

  "REMOVE_USE_STRICT: true"; /* listener flags */
  var ONCE = 1;
  var SUSPENDED = 2;

  /*
    The event system uses a series of nested hashes to store listeners on an
    object. When a listener is registered, or when an event arrives, these
    hashes are consulted to determine which target and action pair to invoke.

    The hashes are stored in the object's meta hash, and look like this:

        // Object's meta hash
        {
          listeners: {       // variable name: `listenerSet`
            "foo:changed": [ // variable name: `actions`
              target, method, flags
            ]
          }
        }

  */

  function indexOf(array, target, method) {
    var index = -1;
    // hashes are added to the end of the event array
    // so it makes sense to start searching at the end
    // of the array and search in reverse
    for (var i = array.length - 3; i >= 0; i -= 3) {
      if (target === array[i] && method === array[i + 1]) {
        index = i;
        break;
      }
    }
    return index;
  }

  function actionsFor(obj, eventName) {
    var meta = utils.meta(obj, true);
    var actions;
    var listeners = meta.listeners;

    if (!listeners) {
      listeners = meta.listeners = create['default'](null);
      listeners.__source__ = obj;
    } else if (listeners.__source__ !== obj) {
      // setup inherited copy of the listeners object
      listeners = meta.listeners = create['default'](listeners);
      listeners.__source__ = obj;
    }

    actions = listeners[eventName];

    // if there are actions, but the eventName doesn't exist in our listeners, then copy them from the prototype
    if (actions && actions.__source__ !== obj) {
      actions = listeners[eventName] = listeners[eventName].slice();
      actions.__source__ = obj;
    } else if (!actions) {
      actions = listeners[eventName] = [];
      actions.__source__ = obj;
    }

    return actions;
  }
  function accumulateListeners(obj, eventName, otherActions) {
    var meta = obj["__ember_meta__"];
    var actions = meta && meta.listeners && meta.listeners[eventName];

    if (!actions) {
      return;
    }

    var newActions = [];

    for (var i = actions.length - 3; i >= 0; i -= 3) {
      var target = actions[i];
      var method = actions[i + 1];
      var flags = actions[i + 2];
      var actionIndex = indexOf(otherActions, target, method);

      if (actionIndex === -1) {
        otherActions.push(target, method, flags);
        newActions.push(target, method, flags);
      }
    }

    return newActions;
  }

  function addListener(obj, eventName, target, method, once) {
    
    if (!method && "function" === typeof target) {
      method = target;
      target = null;
    }

    var actions = actionsFor(obj, eventName);
    var actionIndex = indexOf(actions, target, method);
    var flags = 0;

    if (once) {
      flags |= ONCE;
    }

    if (actionIndex !== -1) {
      return;
    }

    actions.push(target, method, flags);

    if ("function" === typeof obj.didAddListener) {
      obj.didAddListener(eventName, target, method);
    }
  }

  /**
    Remove an event listener

    Arguments should match those passed to `Ember.addListener`.

    @method removeListener
    @for Ember
    @param obj
    @param {String} eventName
    @param {Object|Function} target A target object or a function
    @param {Function|String} method A function or the name of a function to be called on `target`
  */
  function removeListener(obj, eventName, target, method) {
    
    if (!method && "function" === typeof target) {
      method = target;
      target = null;
    }

    function _removeListener(target, method) {
      var actions = actionsFor(obj, eventName);
      var actionIndex = indexOf(actions, target, method);

      // action doesn't exist, give up silently
      if (actionIndex === -1) {
        return;
      }

      actions.splice(actionIndex, 3);

      if ("function" === typeof obj.didRemoveListener) {
        obj.didRemoveListener(eventName, target, method);
      }
    }

    if (method) {
      _removeListener(target, method);
    } else {
      var meta = obj["__ember_meta__"];
      var actions = meta && meta.listeners && meta.listeners[eventName];

      if (!actions) {
        return;
      }
      for (var i = actions.length - 3; i >= 0; i -= 3) {
        _removeListener(actions[i], actions[i + 1]);
      }
    }
  }
  function suspendListener(obj, eventName, target, method, callback) {
    if (!method && "function" === typeof target) {
      method = target;
      target = null;
    }

    var actions = actionsFor(obj, eventName);
    var actionIndex = indexOf(actions, target, method);

    if (actionIndex !== -1) {
      actions[actionIndex + 2] |= SUSPENDED; // mark the action as suspended
    }

    function tryable() {
      return callback.call(target);
    }
    function finalizer() {
      if (actionIndex !== -1) {
        actions[actionIndex + 2] &= ~SUSPENDED;
      }
    }

    return utils.tryFinally(tryable, finalizer);
  }

  function suspendListeners(obj, eventNames, target, method, callback) {
    if (!method && "function" === typeof target) {
      method = target;
      target = null;
    }

    var suspendedActions = [];
    var actionsList = [];
    var eventName, actions, i, l;

    for (i = 0, l = eventNames.length; i < l; i++) {
      eventName = eventNames[i];
      actions = actionsFor(obj, eventName);
      var actionIndex = indexOf(actions, target, method);

      if (actionIndex !== -1) {
        actions[actionIndex + 2] |= SUSPENDED;
        suspendedActions.push(actionIndex);
        actionsList.push(actions);
      }
    }

    function tryable() {
      return callback.call(target);
    }

    function finalizer() {
      for (var i = 0, l = suspendedActions.length; i < l; i++) {
        var actionIndex = suspendedActions[i];
        actionsList[i][actionIndex + 2] &= ~SUSPENDED;
      }
    }

    return utils.tryFinally(tryable, finalizer);
  }

  function watchedEvents(obj) {
    var listeners = obj["__ember_meta__"].listeners;
    var ret = [];

    if (listeners) {
      for (var eventName in listeners) {
        if (eventName !== "__source__" && listeners[eventName]) {
          ret.push(eventName);
        }
      }
    }
    return ret;
  }

  function sendEvent(obj, eventName, params, actions) {
    // first give object a chance to handle it
    if (obj !== Ember['default'] && "function" === typeof obj.sendEvent) {
      obj.sendEvent(eventName, params);
    }

    if (!actions) {
      var meta = obj["__ember_meta__"];
      actions = meta && meta.listeners && meta.listeners[eventName];
    }

    if (!actions) {
      return;
    }

    for (var i = actions.length - 3; i >= 0; i -= 3) {
      // looping in reverse for once listeners
      var target = actions[i];
      var method = actions[i + 1];
      var flags = actions[i + 2];

      if (!method) {
        continue;
      }
      if (flags & SUSPENDED) {
        continue;
      }
      if (flags & ONCE) {
        removeListener(obj, eventName, target, method);
      }
      if (!target) {
        target = obj;
      }
      if ("string" === typeof method) {
        if (params) {
          utils.applyStr(target, method, params);
        } else {
          target[method]();
        }
      } else {
        if (params) {
          utils.apply(target, method, params);
        } else {
          method.call(target);
        }
      }
    }
    return true;
  }

  function hasListeners(obj, eventName) {
    var meta = obj["__ember_meta__"];
    var actions = meta && meta.listeners && meta.listeners[eventName];

    return !!(actions && actions.length);
  }

  function listenersFor(obj, eventName) {
    var ret = [];
    var meta = obj["__ember_meta__"];
    var actions = meta && meta.listeners && meta.listeners[eventName];

    if (!actions) {
      return ret;
    }

    for (var i = 0, l = actions.length; i < l; i += 3) {
      var target = actions[i];
      var method = actions[i + 1];
      ret.push([target, method]);
    }

    return ret;
  }

  function on() {
    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    var func = args.pop();
    var events = args;
    func.__ember_listens__ = events;
    return func;
  }

});
enifed('ember-metal/expand_properties', ['exports', 'ember-metal/error', 'ember-metal/enumerable_utils', 'ember-metal/utils'], function (exports, EmberError, enumerable_utils, utils) {

  'use strict';



  /**
    Expands `pattern`, invoking `callback` for each expansion.

    The only pattern supported is brace-expansion, anything else will be passed
    once to `callback` directly.

    Example

    ```js
    function echo(arg){ console.log(arg); }

    Ember.expandProperties('foo.bar', echo);              //=> 'foo.bar'
    Ember.expandProperties('{foo,bar}', echo);            //=> 'foo', 'bar'
    Ember.expandProperties('foo.{bar,baz}', echo);        //=> 'foo.bar', 'foo.baz'
    Ember.expandProperties('{foo,bar}.baz', echo);        //=> 'foo.baz', 'bar.baz'
    Ember.expandProperties('foo.{bar,baz}.@each', echo)   //=> 'foo.bar.@each', 'foo.baz.@each'
    Ember.expandProperties('{foo,bar}.{spam,eggs}', echo) //=> 'foo.spam', 'foo.eggs', 'bar.spam', 'bar.eggs'
    Ember.expandProperties('{foo}.bar.{baz}')             //=> 'foo.bar.baz'
    ```

    @method
    @private
    @param {String} pattern The property pattern to expand.
    @param {Function} callback The callback to invoke.  It is invoked once per
    expansion, and is passed the expansion.
    */
  exports['default'] = expandProperties;

  var SPLIT_REGEX = /\{|\}/;
  function expandProperties(pattern, callback) {
    if (pattern.indexOf(' ') > -1) {
      throw new EmberError['default']('Brace expanded properties cannot contain spaces, e.g. \'user.{firstName, lastName}\' should be \'user.{firstName,lastName}\'');
    }

    if ('string' === utils.typeOf(pattern)) {
      var parts = pattern.split(SPLIT_REGEX);
      var properties = [parts];

      enumerable_utils.forEach(parts, function (part, index) {
        if (part.indexOf(',') >= 0) {
          properties = duplicateAndReplace(properties, part.split(','), index);
        }
      });

      enumerable_utils.forEach(properties, function (property) {
        callback(property.join(''));
      });
    } else {
      callback(pattern);
    }
  }

  function duplicateAndReplace(properties, currentParts, index) {
    var all = [];

    enumerable_utils.forEach(properties, function (property) {
      enumerable_utils.forEach(currentParts, function (part) {
        var current = property.slice(0);
        current[index] = part;
        all.push(current);
      });
    });

    return all;
  }

});
enifed('ember-metal/get_properties', ['exports', 'ember-metal/property_get', 'ember-metal/utils'], function (exports, property_get, utils) {

  'use strict';



  /**
    To get multiple properties at once, call `Ember.getProperties`
    with an object followed by a list of strings or an array:

    ```javascript
    Ember.getProperties(record, 'firstName', 'lastName', 'zipCode');
    // { firstName: 'John', lastName: 'Doe', zipCode: '10011' }
    ```

    is equivalent to:

    ```javascript
    Ember.getProperties(record, ['firstName', 'lastName', 'zipCode']);
    // { firstName: 'John', lastName: 'Doe', zipCode: '10011' }
    ```

    @method getProperties
    @for Ember
    @param {Object} obj
    @param {String...|Array} list of keys to get
    @return {Object}
  */
  exports['default'] = getProperties;
  function getProperties(obj) {
    var ret = {};
    var propertyNames = arguments;
    var i = 1;

    if (arguments.length === 2 && utils.typeOf(arguments[1]) === "array") {
      i = 0;
      propertyNames = arguments[1];
    }
    for (var len = propertyNames.length; i < len; i++) {
      ret[propertyNames[i]] = property_get.get(obj, propertyNames[i]);
    }
    return ret;
  }

});
enifed('ember-metal/injected_property', ['exports', 'ember-metal/core', 'ember-metal/computed', 'ember-metal/alias', 'ember-metal/properties', 'ember-metal/platform/create'], function (exports, Ember, computed, alias, properties, create) {

  'use strict';

  function InjectedProperty(type, name) {
    this.type = type;
    this.name = name;

    this._super$Constructor(injectedPropertyGet);
    AliasedPropertyPrototype.oneWay.call(this);
  }

  function injectedPropertyGet(keyName) {
    var possibleDesc = this[keyName];
    var desc = possibleDesc !== null && typeof possibleDesc === "object" && possibleDesc.isDescriptor ? possibleDesc : undefined;

    
    return this.container.lookup(desc.type + ":" + (desc.name || keyName));
  }

  InjectedProperty.prototype = create['default'](properties.Descriptor.prototype);

  var InjectedPropertyPrototype = InjectedProperty.prototype;
  var ComputedPropertyPrototype = computed.ComputedProperty.prototype;
  var AliasedPropertyPrototype = alias.AliasedProperty.prototype;

  InjectedPropertyPrototype._super$Constructor = computed.ComputedProperty;

  InjectedPropertyPrototype.get = ComputedPropertyPrototype.get;
  InjectedPropertyPrototype.readOnly = ComputedPropertyPrototype.readOnly;

  InjectedPropertyPrototype.teardown = ComputedPropertyPrototype.teardown;

  exports['default'] = InjectedProperty;

});
enifed('ember-metal/instrumentation', ['exports', 'ember-metal/core', 'ember-metal/utils'], function (exports, Ember, utils) {

  'use strict';

  exports.instrument = instrument;
  exports._instrumentStart = _instrumentStart;
  exports.subscribe = subscribe;
  exports.unsubscribe = unsubscribe;
  exports.reset = reset;

  /**
    Notifies event's subscribers, calls `before` and `after` hooks.

    @method instrument
    @namespace Ember.Instrumentation

    @param {String} [name] Namespaced event name.
    @param {Object} payload
    @param {Function} callback Function that you're instrumenting.
    @param {Object} binding Context that instrument function is called with.
  */
  var subscribers = [];
  var cache = {};

  var populateListeners = function (name) {
    var listeners = [];
    var subscriber;

    for (var i = 0, l = subscribers.length; i < l; i++) {
      subscriber = subscribers[i];
      if (subscriber.regex.test(name)) {
        listeners.push(subscriber.object);
      }
    }

    cache[name] = listeners;
    return listeners;
  };

  var time = (function () {
    var perf = "undefined" !== typeof window ? window.performance || {} : {};
    var fn = perf.now || perf.mozNow || perf.webkitNow || perf.msNow || perf.oNow;
    // fn.bind will be available in all the browsers that support the advanced window.performance... ;-)
    return fn ? fn.bind(perf) : function () {
      return +new Date();
    };
  })();
  function instrument(name, _payload, callback, binding) {
    if (arguments.length <= 3 && typeof _payload === "function") {
      binding = callback;
      callback = _payload;
      _payload = undefined;
    }
    if (subscribers.length === 0) {
      return callback.call(binding);
    }
    var payload = _payload || {};
    var finalizer = _instrumentStart(name, function () {
      return payload;
    });
    if (finalizer) {
      var tryable = function _instrumenTryable() {
        return callback.call(binding);
      };
      var catchable = function _instrumentCatchable(e) {
        payload.exception = e;
      };
      return utils.tryCatchFinally(tryable, catchable, finalizer);
    } else {
      return callback.call(binding);
    }
  }

  function _instrumentStart(name, _payload) {
    var listeners = cache[name];

    if (!listeners) {
      listeners = populateListeners(name);
    }

    if (listeners.length === 0) {
      return;
    }

    var payload = _payload();

    var STRUCTURED_PROFILE = Ember['default'].STRUCTURED_PROFILE;
    var timeName;
    if (STRUCTURED_PROFILE) {
      timeName = name + ": " + payload.object;
      console.time(timeName);
    }

    var l = listeners.length;
    var beforeValues = new Array(l);
    var i, listener;
    var timestamp = time();
    for (i = 0; i < l; i++) {
      listener = listeners[i];
      beforeValues[i] = listener.before(name, timestamp, payload);
    }

    return function _instrumentEnd() {
      var i, l, listener;
      var timestamp = time();
      for (i = 0, l = listeners.length; i < l; i++) {
        listener = listeners[i];
        listener.after(name, timestamp, payload, beforeValues[i]);
      }

      if (STRUCTURED_PROFILE) {
        console.timeEnd(timeName);
      }
    };
  }

  function subscribe(pattern, object) {
    var paths = pattern.split(".");
    var path;
    var regex = [];

    for (var i = 0, l = paths.length; i < l; i++) {
      path = paths[i];
      if (path === "*") {
        regex.push("[^\\.]*");
      } else {
        regex.push(path);
      }
    }

    regex = regex.join("\\.");
    regex = regex + "(\\..*)?";

    var subscriber = {
      pattern: pattern,
      regex: new RegExp("^" + regex + "$"),
      object: object
    };

    subscribers.push(subscriber);
    cache = {};

    return subscriber;
  }

  function unsubscribe(subscriber) {
    var index;

    for (var i = 0, l = subscribers.length; i < l; i++) {
      if (subscribers[i] === subscriber) {
        index = i;
      }
    }

    subscribers.splice(index, 1);
    cache = {};
  }

  function reset() {
    subscribers.length = 0;
    cache = {};
  }

  exports.subscribers = subscribers;

});
enifed('ember-metal/is_blank', ['exports', 'ember-metal/is_empty'], function (exports, isEmpty) {

  'use strict';



  /**
    A value is blank if it is empty or a whitespace string.

    ```javascript
    Ember.isBlank();                // true
    Ember.isBlank(null);            // true
    Ember.isBlank(undefined);       // true
    Ember.isBlank('');              // true
    Ember.isBlank([]);              // true
    Ember.isBlank('\n\t');          // true
    Ember.isBlank('  ');            // true
    Ember.isBlank({});              // false
    Ember.isBlank('\n\t Hello');    // false
    Ember.isBlank('Hello world');   // false
    Ember.isBlank([1,2,3]);         // false
    ```

    @method isBlank
    @for Ember
    @param {Object} obj Value to test
    @return {Boolean}
    @since 1.5.0
    */
  exports['default'] = isBlank;
  function isBlank(obj) {
    return isEmpty['default'](obj) || typeof obj === 'string' && obj.match(/\S/) === null;
  }

});
enifed('ember-metal/is_empty', ['exports', 'ember-metal/property_get', 'ember-metal/is_none'], function (exports, property_get, isNone) {

  'use strict';

  function isEmpty(obj) {
    var none = isNone['default'](obj);
    if (none) {
      return none;
    }

    if (typeof obj.size === 'number') {
      return !obj.size;
    }

    var objectType = typeof obj;

    if (objectType === 'object') {
      var size = property_get.get(obj, 'size');
      if (typeof size === 'number') {
        return !size;
      }
    }

    if (typeof obj.length === 'number' && objectType !== 'function') {
      return !obj.length;
    }

    if (objectType === 'object') {
      var length = property_get.get(obj, 'length');
      if (typeof length === 'number') {
        return !length;
      }
    }

    return false;
  }

  exports['default'] = isEmpty;

});
enifed('ember-metal/is_none', ['exports'], function (exports) {

  'use strict';

  /**
    Returns true if the passed value is null or undefined. This avoids errors
    from JSLint complaining about use of ==, which can be technically
    confusing.

    ```javascript
    Ember.isNone();              // true
    Ember.isNone(null);          // true
    Ember.isNone(undefined);     // true
    Ember.isNone('');            // false
    Ember.isNone([]);            // false
    Ember.isNone(function() {});  // false
    ```

    @method isNone
    @for Ember
    @param {Object} obj Value to test
    @return {Boolean}
  */
  function isNone(obj) {
    return obj === null || obj === undefined;
  }

  exports['default'] = isNone;

});
enifed('ember-metal/is_present', ['exports', 'ember-metal/is_blank'], function (exports, isBlank) {

  'use strict';



  /**
    A value is present if it not `isBlank`.

    ```javascript
    Ember.isPresent();                // false
    Ember.isPresent(null);            // false
    Ember.isPresent(undefined);       // false
    Ember.isPresent('');              // false
    Ember.isPresent([]);              // false
    Ember.isPresent('\n\t');          // false
    Ember.isPresent('  ');            // false
    Ember.isPresent({});              // true
    Ember.isPresent('\n\t Hello');    // true
    Ember.isPresent('Hello world');   // true
    Ember.isPresent([1,2,3]);         // true
    ```

    @method isPresent
    @for Ember
    @param {Object} obj Value to test
    @return {Boolean}
    @since 1.8.0
    */
  exports['default'] = isPresent;
  function isPresent(obj) {
    return !isBlank['default'](obj);
  }

});
enifed('ember-metal/keys', ['exports', 'ember-metal/platform/define_property'], function (exports, define_property) {

  'use strict';

  var keys = Object.keys;

  if (!keys || !define_property.canDefineNonEnumerableProperties) {
    // modified from
    // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/keys
    keys = (function () {
      var hasOwnProperty = Object.prototype.hasOwnProperty;
      var hasDontEnumBug = !({ toString: null }).propertyIsEnumerable('toString');
      var dontEnums = ['toString', 'toLocaleString', 'valueOf', 'hasOwnProperty', 'isPrototypeOf', 'propertyIsEnumerable', 'constructor'];
      var dontEnumsLength = dontEnums.length;

      return function keys(obj) {
        if (typeof obj !== 'object' && (typeof obj !== 'function' || obj === null)) {
          throw new TypeError('Object.keys called on non-object');
        }

        var result = [];
        var prop, i;

        for (prop in obj) {
          if (prop !== '_super' && prop.lastIndexOf('__', 0) !== 0 && hasOwnProperty.call(obj, prop)) {
            result.push(prop);
          }
        }

        if (hasDontEnumBug) {
          for (i = 0; i < dontEnumsLength; i++) {
            if (hasOwnProperty.call(obj, dontEnums[i])) {
              result.push(dontEnums[i]);
            }
          }
        }
        return result;
      };
    })();
  }

  exports['default'] = keys;

});
enifed('ember-metal/libraries', ['exports', 'ember-metal/core', 'ember-metal/enumerable_utils'], function (exports, Ember, enumerable_utils) {

  'use strict';

  function Libraries() {
    this._registry = [];
    this._coreLibIndex = 0;
  }

  Libraries.prototype = {
    constructor: Libraries,

    _getLibraryByName: function (name) {
      var libs = this._registry;
      var count = libs.length;

      for (var i = 0; i < count; i++) {
        if (libs[i].name === name) {
          return libs[i];
        }
      }
    },

    register: function (name, version, isCoreLibrary) {
      var index = this._registry.length;

      if (!this._getLibraryByName(name)) {
        if (isCoreLibrary) {
          index = this._coreLibIndex++;
        }
        this._registry.splice(index, 0, { name: name, version: version });
      } else {
              }
    },

    registerCoreLibrary: function (name, version) {
      this.register(name, version, true);
    },

    deRegister: function (name) {
      var lib = this._getLibraryByName(name);
      var index;

      if (lib) {
        index = enumerable_utils.indexOf(this._registry, lib);
        this._registry.splice(index, 1);
      }
    },

    each: function (callback) {
            enumerable_utils.forEach(this._registry, function (lib) {
        callback(lib.name, lib.version);
      });
    }
  };

  
  exports['default'] = Libraries;

});
enifed('ember-metal/logger', ['exports', 'ember-metal/core', 'ember-metal/error'], function (exports, Ember, EmberError) {

  'use strict';

  function K() {
    return this;
  }

  function consoleMethod(name) {
    var consoleObj, logToConsole;
    if (Ember['default'].imports.console) {
      consoleObj = Ember['default'].imports.console;
    } else if (typeof console !== "undefined") {
      consoleObj = console;
    }

    var method = typeof consoleObj === "object" ? consoleObj[name] : null;

    if (method) {
      // Older IE doesn't support bind, but Chrome needs it
      if (typeof method.bind === "function") {
        logToConsole = method.bind(consoleObj);
        logToConsole.displayName = "console." + name;
        return logToConsole;
      } else if (typeof method.apply === "function") {
        logToConsole = function () {
          method.apply(consoleObj, arguments);
        };
        logToConsole.displayName = "console." + name;
        return logToConsole;
      } else {
        return function () {
          var message = Array.prototype.join.call(arguments, ", ");
          method(message);
        };
      }
    }
  }

  function assertPolyfill(test, message) {
    if (!test) {
      try {
        // attempt to preserve the stack
        throw new EmberError['default']("assertion failed: " + message);
      } catch (error) {
        setTimeout(function () {
          throw error;
        }, 0);
      }
    }
  }

  /**
    Inside Ember-Metal, simply uses the methods from `imports.console`.
    Override this to provide more robust logging functionality.

    @class Logger
    @namespace Ember
  */
  exports['default'] = {
    /**
     Logs the arguments to the console.
     You can pass as many arguments as you want and they will be joined together with a space.
       ```javascript
      var foo = 1;
      Ember.Logger.log('log value of foo:', foo);
      // "log value of foo: 1" will be printed to the console
      ```
      @method log
     @for Ember.Logger
     @param {*} arguments
    */
    log: consoleMethod("log") || K,

    /**
     Prints the arguments to the console with a warning icon.
     You can pass as many arguments as you want and they will be joined together with a space.
       ```javascript
      Ember.Logger.warn('Something happened!');
      // "Something happened!" will be printed to the console with a warning icon.
      ```
      @method warn
     @for Ember.Logger
     @param {*} arguments
    */
    warn: consoleMethod("warn") || K,

    /**
     Prints the arguments to the console with an error icon, red text and a stack trace.
     You can pass as many arguments as you want and they will be joined together with a space.
       ```javascript
      Ember.Logger.error('Danger! Danger!');
      // "Danger! Danger!" will be printed to the console in red text.
      ```
      @method error
     @for Ember.Logger
     @param {*} arguments
    */
    error: consoleMethod("error") || K,

    /**
     Logs the arguments to the console.
     You can pass as many arguments as you want and they will be joined together with a space.
       ```javascript
      var foo = 1;
      Ember.Logger.info('log value of foo:', foo);
      // "log value of foo: 1" will be printed to the console
      ```
      @method info
     @for Ember.Logger
     @param {*} arguments
    */
    info: consoleMethod("info") || K,

    /**
     Logs the arguments to the console in blue text.
     You can pass as many arguments as you want and they will be joined together with a space.
       ```javascript
      var foo = 1;
      Ember.Logger.debug('log value of foo:', foo);
      // "log value of foo: 1" will be printed to the console
      ```
      @method debug
     @for Ember.Logger
     @param {*} arguments
    */
    debug: consoleMethod("debug") || consoleMethod("info") || K,

    /**
     If the value passed into `Ember.Logger.assert` is not truthy it will throw an error with a stack trace.
       ```javascript
      Ember.Logger.assert(true); // undefined
      Ember.Logger.assert(true === false); // Throws an Assertion failed error.
      ```
      @method assert
     @for Ember.Logger
     @param {Boolean} bool Value to test
    */
    assert: consoleMethod("assert") || assertPolyfill
  };

});
enifed('ember-metal/map', ['exports', 'ember-metal/utils', 'ember-metal/array', 'ember-metal/platform/create', 'ember-metal/deprecate_property'], function (exports, utils, array, create, deprecate_property) {

  'use strict';

  exports.OrderedSet = OrderedSet;
  exports.Map = Map;
  exports.MapWithDefault = MapWithDefault;

  /**
  @module ember-metal
  */

  /*
    JavaScript (before ES6) does not have a Map implementation. Objects,
    which are often used as dictionaries, may only have Strings as keys.

    Because Ember has a way to get a unique identifier for every object
    via `Ember.guidFor`, we can implement a performant Map with arbitrary
    keys. Because it is commonly used in low-level bookkeeping, Map is
    implemented as a pure JavaScript object for performance.

    This implementation follows the current iteration of the ES6 proposal for
    maps (http://wiki.ecmascript.org/doku.php?id=harmony:simple_maps_and_sets),
    with one exception:  as we do not have the luxury of in-VM iteration, we implement a
    forEach method for iteration.

    Map is mocked out to look like an Ember object, so you can do
    `Ember.Map.create()` for symmetry with other Ember classes.
  */

  function missingFunction(fn) {
    throw new TypeError("" + Object.prototype.toString.call(fn) + " is not a function");
  }

  function missingNew(name) {
    throw new TypeError("Constructor " + name + " requires 'new'");
  }

  function copyNull(obj) {
    var output = create['default'](null);

    for (var prop in obj) {
      // hasOwnPropery is not needed because obj is Object.create(null);
      output[prop] = obj[prop];
    }

    return output;
  }

  function copyMap(original, newObject) {
    var keys = original._keys.copy();
    var values = copyNull(original._values);

    newObject._keys = keys;
    newObject._values = values;
    newObject.size = original.size;

    return newObject;
  }

  /**
    This class is used internally by Ember and Ember Data.
    Please do not use it at this time. We plan to clean it up
    and add many tests soon.

    @class OrderedSet
    @namespace Ember
    @constructor
    @private
  */
  function OrderedSet() {

    if (this instanceof OrderedSet) {
      this.clear();
      this._silenceRemoveDeprecation = false;
    } else {
      missingNew("OrderedSet");
    }
  }

  /**
    @method create
    @static
    @return {Ember.OrderedSet}
  */
  OrderedSet.create = function () {
    var Constructor = this;

    return new Constructor();
  };

  OrderedSet.prototype = {
    constructor: OrderedSet,
    /**
      @method clear
    */
    clear: function () {
      this.presenceSet = create['default'](null);
      this.list = [];
      this.size = 0;
    },

    /**
      @method add
      @param obj
      @param guid (optional, and for internal use)
      @return {Ember.OrderedSet}
    */
    add: function (obj, _guid) {
      var guid = _guid || utils.guidFor(obj);
      var presenceSet = this.presenceSet;
      var list = this.list;

      if (presenceSet[guid] !== true) {
        presenceSet[guid] = true;
        this.size = list.push(obj);
      }

      return this;
    },

    /**
      @deprecated
       @method remove
      @param obj
      @param _guid (optional and for internal use only)
      @return {Boolean}
    */
    remove: function (obj, _guid) {
      
      return this["delete"](obj, _guid);
    },

    /**
      @since 1.8.0
      @method delete
      @param obj
      @param _guid (optional and for internal use only)
      @return {Boolean}
    */
    "delete": function (obj, _guid) {
      var guid = _guid || utils.guidFor(obj);
      var presenceSet = this.presenceSet;
      var list = this.list;

      if (presenceSet[guid] === true) {
        delete presenceSet[guid];
        var index = array.indexOf.call(list, obj);
        if (index > -1) {
          list.splice(index, 1);
        }
        this.size = list.length;
        return true;
      } else {
        return false;
      }
    },

    /**
      @method isEmpty
      @return {Boolean}
    */
    isEmpty: function () {
      return this.size === 0;
    },

    /**
      @method has
      @param obj
      @return {Boolean}
    */
    has: function (obj) {
      if (this.size === 0) {
        return false;
      }

      var guid = utils.guidFor(obj);
      var presenceSet = this.presenceSet;

      return presenceSet[guid] === true;
    },

    /**
      @method forEach
      @param {Function} fn
      @param self
    */
    forEach: function (fn /*, ...thisArg*/) {
      if (typeof fn !== "function") {
        missingFunction(fn);
      }

      if (this.size === 0) {
        return;
      }

      var list = this.list;
      var length = arguments.length;
      var i;

      if (length === 2) {
        for (i = 0; i < list.length; i++) {
          fn.call(arguments[1], list[i]);
        }
      } else {
        for (i = 0; i < list.length; i++) {
          fn(list[i]);
        }
      }
    },

    /**
      @method toArray
      @return {Array}
    */
    toArray: function () {
      return this.list.slice();
    },

    /**
      @method copy
      @return {Ember.OrderedSet}
    */
    copy: function () {
      var Constructor = this.constructor;
      var set = new Constructor();

      set._silenceRemoveDeprecation = this._silenceRemoveDeprecation;
      set.presenceSet = copyNull(this.presenceSet);
      set.list = this.toArray();
      set.size = this.size;

      return set;
    }
  };

  deprecate_property.deprecateProperty(OrderedSet.prototype, "length", "size");

  /**
    A Map stores values indexed by keys. Unlike JavaScript's
    default Objects, the keys of a Map can be any JavaScript
    object.

    Internally, a Map has two data structures:

    1. `keys`: an OrderedSet of all of the existing keys
    2. `values`: a JavaScript Object indexed by the `Ember.guidFor(key)`

    When a key/value pair is added for the first time, we
    add the key to the `keys` OrderedSet, and create or
    replace an entry in `values`. When an entry is deleted,
    we delete its entry in `keys` and `values`.

    @class Map
    @namespace Ember
    @private
    @constructor
  */
  function Map() {
    if (this instanceof this.constructor) {
      this._keys = OrderedSet.create();
      this._keys._silenceRemoveDeprecation = true;
      this._values = create['default'](null);
      this.size = 0;
    } else {
      missingNew("OrderedSet");
    }
  }

  Ember.Map = Map;

  /**
    @method create
    @static
  */
  Map.create = function () {
    var Constructor = this;
    return new Constructor();
  };

  Map.prototype = {
    constructor: Map,

    /**
      This property will change as the number of objects in the map changes.
       @since 1.8.0
      @property size
      @type number
      @default 0
    */
    size: 0,

    /**
      Retrieve the value associated with a given key.
       @method get
      @param {*} key
      @return {*} the value associated with the key, or `undefined`
    */
    get: function (key) {
      if (this.size === 0) {
        return;
      }

      var values = this._values;
      var guid = utils.guidFor(key);

      return values[guid];
    },

    /**
      Adds a value to the map. If a value for the given key has already been
      provided, the new value will replace the old value.
       @method set
      @param {*} key
      @param {*} value
      @return {Ember.Map}
    */
    set: function (key, value) {
      var keys = this._keys;
      var values = this._values;
      var guid = utils.guidFor(key);

      // ensure we don't store -0
      var k = key === -0 ? 0 : key;

      keys.add(k, guid);

      values[guid] = value;

      this.size = keys.size;

      return this;
    },

    /**
      @deprecated see delete
      Removes a value from the map for an associated key.
       @method remove
      @param {*} key
      @return {Boolean} true if an item was removed, false otherwise
    */
    remove: function (key) {
      
      return this["delete"](key);
    },

    /**
      Removes a value from the map for an associated key.
       @since 1.8.0
      @method delete
      @param {*} key
      @return {Boolean} true if an item was removed, false otherwise
    */
    "delete": function (key) {
      if (this.size === 0) {
        return false;
      }
      // don't use ES6 "delete" because it will be annoying
      // to use in browsers that are not ES6 friendly;
      var keys = this._keys;
      var values = this._values;
      var guid = utils.guidFor(key);

      if (keys["delete"](key, guid)) {
        delete values[guid];
        this.size = keys.size;
        return true;
      } else {
        return false;
      }
    },

    /**
      Check whether a key is present.
       @method has
      @param {*} key
      @return {Boolean} true if the item was present, false otherwise
    */
    has: function (key) {
      return this._keys.has(key);
    },

    /**
      Iterate over all the keys and values. Calls the function once
      for each key, passing in value, key, and the map being iterated over,
      in that order.
       The keys are guaranteed to be iterated over in insertion order.
       @method forEach
      @param {Function} callback
      @param {*} self if passed, the `this` value inside the
        callback. By default, `this` is the map.
    */
    forEach: function (callback /*, ...thisArg*/) {
      if (typeof callback !== "function") {
        missingFunction(callback);
      }

      if (this.size === 0) {
        return;
      }

      var length = arguments.length;
      var map = this;
      var cb, thisArg;

      if (length === 2) {
        thisArg = arguments[1];
        cb = function (key) {
          callback.call(thisArg, map.get(key), key, map);
        };
      } else {
        cb = function (key) {
          callback(map.get(key), key, map);
        };
      }

      this._keys.forEach(cb);
    },

    /**
      @method clear
    */
    clear: function () {
      this._keys.clear();
      this._values = create['default'](null);
      this.size = 0;
    },

    /**
      @method copy
      @return {Ember.Map}
    */
    copy: function () {
      return copyMap(this, new Map());
    }
  };

  deprecate_property.deprecateProperty(Map.prototype, "length", "size");

  /**
    @class MapWithDefault
    @namespace Ember
    @extends Ember.Map
    @private
    @constructor
    @param [options]
      @param {*} [options.defaultValue]
  */
  function MapWithDefault(options) {
    this._super$constructor();
    this.defaultValue = options.defaultValue;
  }

  /**
    @method create
    @static
    @param [options]
      @param {*} [options.defaultValue]
    @return {Ember.MapWithDefault|Ember.Map} If options are passed, returns
      `Ember.MapWithDefault` otherwise returns `Ember.Map`
  */
  MapWithDefault.create = function (options) {
    if (options) {
      return new MapWithDefault(options);
    } else {
      return new Map();
    }
  };

  MapWithDefault.prototype = create['default'](Map.prototype);
  MapWithDefault.prototype.constructor = MapWithDefault;
  MapWithDefault.prototype._super$constructor = Map;
  MapWithDefault.prototype._super$get = Map.prototype.get;

  /**
    Retrieve the value associated with a given key.

    @method get
    @param {*} key
    @return {*} the value associated with the key, or the default value
  */
  MapWithDefault.prototype.get = function (key) {
    var hasValue = this.has(key);

    if (hasValue) {
      return this._super$get(key);
    } else {
      var defaultValue = this.defaultValue(key);
      this.set(key, defaultValue);
      return defaultValue;
    }
  };

  /**
    @method copy
    @return {Ember.MapWithDefault}
  */
  MapWithDefault.prototype.copy = function () {
    var Constructor = this.constructor;
    return copyMap(this, new Constructor({
      defaultValue: this.defaultValue
    }));
  };

  exports['default'] = Map;

});
enifed('ember-metal/merge', ['exports', 'ember-metal/keys'], function (exports, keys) {

  'use strict';



  /**
    Merge the contents of two objects together into the first object.

    ```javascript
    Ember.merge({first: 'Tom'}, {last: 'Dale'}); // {first: 'Tom', last: 'Dale'}
    var a = {first: 'Yehuda'};
    var b = {last: 'Katz'};
    Ember.merge(a, b); // a == {first: 'Yehuda', last: 'Katz'}, b == {last: 'Katz'}
    ```

    @method merge
    @for Ember
    @param {Object} original The object to merge into
    @param {Object} updates The object to copy properties from
    @return {Object}
  */
  exports['default'] = merge;
  function merge(original, updates) {
    if (!updates || typeof updates !== 'object') {
      return original;
    }

    var props = keys['default'](updates);
    var prop;
    var length = props.length;

    for (var i = 0; i < length; i++) {
      prop = props[i];
      original[prop] = updates[prop];
    }

    return original;
  }

});
enifed('ember-metal/mixin', ['exports', 'ember-metal/core', 'ember-metal/merge', 'ember-metal/array', 'ember-metal/platform/create', 'ember-metal/property_get', 'ember-metal/property_set', 'ember-metal/utils', 'ember-metal/expand_properties', 'ember-metal/properties', 'ember-metal/computed', 'ember-metal/binding', 'ember-metal/observer', 'ember-metal/events', 'ember-metal/streams/utils'], function (exports, Ember, merge, array, o_create, property_get, property_set, utils, expandProperties, ember_metal__properties, computed, ember_metal__binding, ember_metal__observer, events, streams__utils) {

  
  exports.mixin = mixin;
  exports.required = required;
  exports.aliasMethod = aliasMethod;
  exports.observer = observer;
  exports.immediateObserver = immediateObserver;
  exports.beforeObserver = beforeObserver;
  exports.Mixin = Mixin;

  /**
    @method mixin
    @for Ember
    @param obj
    @param mixins*
    @return obj
  */
  "REMOVE_USE_STRICT: true";var REQUIRED;
  var a_slice = [].slice;

  function superFunction() {
    var func = this.__nextSuper;
    var ret;

    if (func) {
      var length = arguments.length;
      this.__nextSuper = null;
      if (length === 0) {
        ret = func.call(this);
      } else if (length === 1) {
        ret = func.call(this, arguments[0]);
      } else if (length === 2) {
        ret = func.call(this, arguments[0], arguments[1]);
      } else {
        ret = func.apply(this, arguments);
      }
      this.__nextSuper = func;
      return ret;
    }
  }

  // ensure we prime superFunction to mitigate
  // v8 bug potentially incorrectly deopts this function: https://code.google.com/p/v8/issues/detail?id=3709
  var primer = {
    __nextSuper: function (a, b, c, d) {}
  };

  superFunction.call(primer);
  superFunction.call(primer, 1);
  superFunction.call(primer, 1, 2);
  superFunction.call(primer, 1, 2, 3);

  function mixinsMeta(obj) {
    var m = utils.meta(obj, true);
    var ret = m.mixins;
    if (!ret) {
      ret = m.mixins = {};
    } else if (!m.hasOwnProperty("mixins")) {
      ret = m.mixins = o_create['default'](ret);
    }
    return ret;
  }

  function isMethod(obj) {
    return "function" === typeof obj && obj.isMethod !== false && obj !== Boolean && obj !== Object && obj !== Number && obj !== Array && obj !== Date && obj !== String;
  }

  var CONTINUE = {};

  function mixinProperties(mixinsMeta, mixin) {
    var guid;

    if (mixin instanceof Mixin) {
      guid = utils.guidFor(mixin);
      if (mixinsMeta[guid]) {
        return CONTINUE;
      }
      mixinsMeta[guid] = mixin;
      return mixin.properties;
    } else {
      return mixin; // apply anonymous mixin properties
    }
  }

  function concatenatedMixinProperties(concatProp, props, values, base) {
    var concats;

    // reset before adding each new mixin to pickup concats from previous
    concats = values[concatProp] || base[concatProp];
    if (props[concatProp]) {
      concats = concats ? concats.concat(props[concatProp]) : props[concatProp];
    }

    return concats;
  }

  function giveDescriptorSuper(meta, key, property, values, descs, base) {
    var superProperty;

    // Computed properties override methods, and do not call super to them
    if (values[key] === undefined) {
      // Find the original descriptor in a parent mixin
      superProperty = descs[key];
    }

    // If we didn't find the original descriptor in a parent mixin, find
    // it on the original object.
    if (!superProperty) {
      var possibleDesc = base[key];
      var superDesc = possibleDesc !== null && typeof possibleDesc === "object" && possibleDesc.isDescriptor ? possibleDesc : undefined;

      superProperty = superDesc;
    }

    if (superProperty === undefined || !(superProperty instanceof computed.ComputedProperty)) {
      return property;
    }

    // Since multiple mixins may inherit from the same parent, we need
    // to clone the computed property so that other mixins do not receive
    // the wrapped version.
    property = o_create['default'](property);
    property._getter = utils.wrap(property._getter, superProperty._getter);
    if (superProperty._setter) {
      if (property._setter) {
        property._setter = utils.wrap(property._setter, superProperty._setter);
      } else {
        property._setter = superProperty._setter;
      }
    }

    return property;
  }

  var sourceAvailable = (function () {
    return this;
  }).toString().indexOf("return this;") > -1;

  function giveMethodSuper(obj, key, method, values, descs) {
    var superMethod;

    // Methods overwrite computed properties, and do not call super to them.
    if (descs[key] === undefined) {
      // Find the original method in a parent mixin
      superMethod = values[key];
    }

    // If we didn't find the original value in a parent mixin, find it in
    // the original object
    superMethod = superMethod || obj[key];

    // Only wrap the new method if the original method was a function
    if (superMethod === undefined || "function" !== typeof superMethod) {
      return method;
    }

    var hasSuper;
    if (sourceAvailable) {
      hasSuper = method.__hasSuper;

      if (hasSuper === undefined) {
        hasSuper = method.toString().indexOf("_super") > -1;
        method.__hasSuper = hasSuper;
      }
    }

    if (sourceAvailable === false || hasSuper) {
      return utils.wrap(method, superMethod);
    } else {
      return method;
    }
  }

  function applyConcatenatedProperties(obj, key, value, values) {
    var baseValue = values[key] || obj[key];

    if (baseValue) {
      if ("function" === typeof baseValue.concat) {
        if (value === null || value === undefined) {
          return baseValue;
        } else {
          return baseValue.concat(value);
        }
      } else {
        return utils.makeArray(baseValue).concat(value);
      }
    } else {
      return utils.makeArray(value);
    }
  }

  function applyMergedProperties(obj, key, value, values) {
    var baseValue = values[key] || obj[key];

    
    if (!baseValue) {
      return value;
    }

    var newBase = merge['default']({}, baseValue);
    var hasFunction = false;

    for (var prop in value) {
      if (!value.hasOwnProperty(prop)) {
        continue;
      }

      var propValue = value[prop];
      if (isMethod(propValue)) {
        // TODO: support for Computed Properties, etc?
        hasFunction = true;
        newBase[prop] = giveMethodSuper(obj, prop, propValue, baseValue, {});
      } else {
        newBase[prop] = propValue;
      }
    }

    if (hasFunction) {
      newBase._super = superFunction;
    }

    return newBase;
  }

  function addNormalizedProperty(base, key, value, meta, descs, values, concats, mergings) {
    if (value instanceof ember_metal__properties.Descriptor) {
      if (value === REQUIRED && descs[key]) {
        return CONTINUE;
      }

      // Wrap descriptor function to implement
      // __nextSuper() if needed
      if (value._getter) {
        value = giveDescriptorSuper(meta, key, value, values, descs, base);
      }

      descs[key] = value;
      values[key] = undefined;
    } else {
      if (concats && array.indexOf.call(concats, key) >= 0 || key === "concatenatedProperties" || key === "mergedProperties") {
        value = applyConcatenatedProperties(base, key, value, values);
      } else if (mergings && array.indexOf.call(mergings, key) >= 0) {
        value = applyMergedProperties(base, key, value, values);
      } else if (isMethod(value)) {
        value = giveMethodSuper(base, key, value, values, descs);
      }

      descs[key] = undefined;
      values[key] = value;
    }
  }

  function mergeMixins(mixins, m, descs, values, base, keys) {
    var currentMixin, props, key, concats, mergings, meta;

    function removeKeys(keyName) {
      delete descs[keyName];
      delete values[keyName];
    }

    for (var i = 0, l = mixins.length; i < l; i++) {
      currentMixin = mixins[i];
      
      props = mixinProperties(m, currentMixin);
      if (props === CONTINUE) {
        continue;
      }

      if (props) {
        meta = utils.meta(base);
        if (base.willMergeMixin) {
          base.willMergeMixin(props);
        }
        concats = concatenatedMixinProperties("concatenatedProperties", props, values, base);
        mergings = concatenatedMixinProperties("mergedProperties", props, values, base);

        for (key in props) {
          if (!props.hasOwnProperty(key)) {
            continue;
          }
          keys.push(key);
          addNormalizedProperty(base, key, props[key], meta, descs, values, concats, mergings);
        }

        // manually copy toString() because some JS engines do not enumerate it
        if (props.hasOwnProperty("toString")) {
          base.toString = props.toString;
        }
      } else if (currentMixin.mixins) {
        mergeMixins(currentMixin.mixins, m, descs, values, base, keys);
        if (currentMixin._without) {
          array.forEach.call(currentMixin._without, removeKeys);
        }
      }
    }
  }

  var IS_BINDING = /^.+Binding$/;

  function detectBinding(obj, key, value, m) {
    if (IS_BINDING.test(key)) {
      var bindings = m.bindings;
      if (!bindings) {
        bindings = m.bindings = {};
      } else if (!m.hasOwnProperty("bindings")) {
        bindings = m.bindings = o_create['default'](m.bindings);
      }
      bindings[key] = value;
    }
  }

  function connectStreamBinding(obj, key, stream) {
    var onNotify = function (stream) {
      ember_metal__observer._suspendObserver(obj, key, null, didChange, function () {
        property_set.trySet(obj, key, stream.value());
      });
    };

    var didChange = function () {
      stream.setValue(property_get.get(obj, key), onNotify);
    };

    // Initialize value
    property_set.set(obj, key, stream.value());

    ember_metal__observer.addObserver(obj, key, null, didChange);

    stream.subscribe(onNotify);

    if (obj._streamBindingSubscriptions === undefined) {
      obj._streamBindingSubscriptions = o_create['default'](null);
    }

    obj._streamBindingSubscriptions[key] = onNotify;
  }

  function connectBindings(obj, m) {
    // TODO Mixin.apply(instance) should disconnect binding if exists
    var bindings = m.bindings;
    var key, binding, to;
    if (bindings) {
      for (key in bindings) {
        binding = bindings[key];
        if (binding) {
          to = key.slice(0, -7); // strip Binding off end
          if (streams__utils.isStream(binding)) {
            connectStreamBinding(obj, to, binding);
            continue;
          } else if (binding instanceof ember_metal__binding.Binding) {
            binding = binding.copy(); // copy prototypes' instance
            binding.to(to);
          } else {
            // binding is string path
            binding = new ember_metal__binding.Binding(to, binding);
          }
          binding.connect(obj);
          obj[key] = binding;
        }
      }
      // mark as applied
      m.bindings = {};
    }
  }

  function finishPartial(obj, m) {
    connectBindings(obj, m || utils.meta(obj));
    return obj;
  }

  function followAlias(obj, desc, m, descs, values) {
    var altKey = desc.methodName;
    var value;
    var possibleDesc;
    if (descs[altKey] || values[altKey]) {
      value = values[altKey];
      desc = descs[altKey];
    } else if ((possibleDesc = obj[altKey]) && possibleDesc !== null && typeof possibleDesc === "object" && possibleDesc.isDescriptor) {
      desc = possibleDesc;
      value = undefined;
    } else {
      desc = undefined;
      value = obj[altKey];
    }

    return { desc: desc, value: value };
  }

  function updateObserversAndListeners(obj, key, observerOrListener, pathsKey, updateMethod) {
    var paths = observerOrListener[pathsKey];

    if (paths) {
      for (var i = 0, l = paths.length; i < l; i++) {
        updateMethod(obj, paths[i], null, key);
      }
    }
  }

  function replaceObserversAndListeners(obj, key, observerOrListener) {
    var prev = obj[key];

    if ("function" === typeof prev) {
      updateObserversAndListeners(obj, key, prev, "__ember_observesBefore__", ember_metal__observer.removeBeforeObserver);
      updateObserversAndListeners(obj, key, prev, "__ember_observes__", ember_metal__observer.removeObserver);
      updateObserversAndListeners(obj, key, prev, "__ember_listens__", events.removeListener);
    }

    if ("function" === typeof observerOrListener) {
      updateObserversAndListeners(obj, key, observerOrListener, "__ember_observesBefore__", ember_metal__observer.addBeforeObserver);
      updateObserversAndListeners(obj, key, observerOrListener, "__ember_observes__", ember_metal__observer.addObserver);
      updateObserversAndListeners(obj, key, observerOrListener, "__ember_listens__", events.addListener);
    }
  }

  function applyMixin(obj, mixins, partial) {
    var descs = {};
    var values = {};
    var m = utils.meta(obj);
    var keys = [];
    var key, value, desc;

    obj._super = superFunction;

    // Go through all mixins and hashes passed in, and:
    //
    // * Handle concatenated properties
    // * Handle merged properties
    // * Set up _super wrapping if necessary
    // * Set up computed property descriptors
    // * Copying `toString` in broken browsers
    mergeMixins(mixins, mixinsMeta(obj), descs, values, obj, keys);

    for (var i = 0, l = keys.length; i < l; i++) {
      key = keys[i];
      if (key === "constructor" || !values.hasOwnProperty(key)) {
        continue;
      }

      desc = descs[key];
      value = values[key];

      if (desc === REQUIRED) {
        continue;
      }

      while (desc && desc instanceof Alias) {
        var followed = followAlias(obj, desc, m, descs, values);
        desc = followed.desc;
        value = followed.value;
      }

      if (desc === undefined && value === undefined) {
        continue;
      }

      replaceObserversAndListeners(obj, key, value);
      detectBinding(obj, key, value, m);
      ember_metal__properties.defineProperty(obj, key, desc, value, m);
    }

    if (!partial) {
      // don't apply to prototype
      finishPartial(obj, m);
    }

    return obj;
  }
  function mixin(obj) {
    for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }

    applyMixin(obj, args, false);
    return obj;
  }

  /**
    The `Ember.Mixin` class allows you to create mixins, whose properties can be
    added to other classes. For instance,

    ```javascript
    App.Editable = Ember.Mixin.create({
      edit: function() {
        console.log('starting to edit');
        this.set('isEditing', true);
      },
      isEditing: false
    });

    // Mix mixins into classes by passing them as the first arguments to
    // .extend.
    App.CommentView = Ember.View.extend(App.Editable, {
      template: Ember.Handlebars.compile('{{#if view.isEditing}}...{{else}}...{{/if}}')
    });

    commentView = App.CommentView.create();
    commentView.edit(); // outputs 'starting to edit'
    ```

    Note that Mixins are created with `Ember.Mixin.create`, not
    `Ember.Mixin.extend`.

    Note that mixins extend a constructor's prototype so arrays and object literals
    defined as properties will be shared amongst objects that implement the mixin.
    If you want to define a property in a mixin that is not shared, you can define
    it either as a computed property or have it be created on initialization of the object.

    ```javascript
    //filters array will be shared amongst any object implementing mixin
    App.Filterable = Ember.Mixin.create({
      filters: Ember.A()
    });

    //filters will be a separate  array for every object implementing the mixin
    App.Filterable = Ember.Mixin.create({
      filters: Ember.computed(function() {return Ember.A();})
    });

    //filters will be created as a separate array during the object's initialization
    App.Filterable = Ember.Mixin.create({
      init: function() {
        this._super.apply(this, arguments);
        this.set("filters", Ember.A());
      }
    });
    ```

    @class Mixin
    @namespace Ember
  */
  exports['default'] = Mixin;
  function Mixin(args, properties) {
    this.properties = properties;

    var length = args && args.length;

    if (length > 0) {
      var m = new Array(length);

      for (var i = 0; i < length; i++) {
        var x = args[i];
        if (x instanceof Mixin) {
          m[i] = x;
        } else {
          m[i] = new Mixin(undefined, x);
        }
      }

      this.mixins = m;
    } else {
      this.mixins = undefined;
    }
    this.ownerConstructor = undefined;
  }

  Mixin._apply = applyMixin;

  Mixin.applyPartial = function (obj) {
    var args = a_slice.call(arguments, 1);
    return applyMixin(obj, args, true);
  };

  Mixin.finishPartial = finishPartial;

  // ES6TODO: this relies on a global state?
  Ember['default'].anyUnprocessedMixins = false;

  /**
    @method create
    @static
    @param arguments*
  */
  Mixin.create = function () {
    for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      args[_key2] = arguments[_key2];
    }

    // ES6TODO: this relies on a global state?
    Ember['default'].anyUnprocessedMixins = true;
    var M = this;
    return new M(args, undefined);
  };

  var MixinPrototype = Mixin.prototype;

  /**
    @method reopen
    @param arguments*
  */
  MixinPrototype.reopen = function () {
    var currentMixin;

    if (this.properties) {
      currentMixin = new Mixin(undefined, this.properties);
      this.properties = undefined;
      this.mixins = [currentMixin];
    } else if (!this.mixins) {
      this.mixins = [];
    }

    var len = arguments.length;
    var mixins = this.mixins;
    var idx;

    for (idx = 0; idx < len; idx++) {
      currentMixin = arguments[idx];
      
      if (currentMixin instanceof Mixin) {
        mixins.push(currentMixin);
      } else {
        mixins.push(new Mixin(undefined, currentMixin));
      }
    }

    return this;
  };

  /**
    @method apply
    @param obj
    @return applied object
  */
  MixinPrototype.apply = function (obj) {
    return applyMixin(obj, [this], false);
  };

  MixinPrototype.applyPartial = function (obj) {
    return applyMixin(obj, [this], true);
  };

  function _detect(curMixin, targetMixin, seen) {
    var guid = utils.guidFor(curMixin);

    if (seen[guid]) {
      return false;
    }
    seen[guid] = true;

    if (curMixin === targetMixin) {
      return true;
    }
    var mixins = curMixin.mixins;
    var loc = mixins ? mixins.length : 0;
    while (--loc >= 0) {
      if (_detect(mixins[loc], targetMixin, seen)) {
        return true;
      }
    }
    return false;
  }

  /**
    @method detect
    @param obj
    @return {Boolean}
  */
  MixinPrototype.detect = function (obj) {
    if (!obj) {
      return false;
    }
    if (obj instanceof Mixin) {
      return _detect(obj, this, {});
    }
    var m = obj["__ember_meta__"];
    var mixins = m && m.mixins;
    if (mixins) {
      return !!mixins[utils.guidFor(this)];
    }
    return false;
  };

  MixinPrototype.without = function () {
    for (var _len3 = arguments.length, args = Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
      args[_key3] = arguments[_key3];
    }

    var ret = new Mixin([this]);
    ret._without = args;
    return ret;
  };

  function _keys(ret, mixin, seen) {
    if (seen[utils.guidFor(mixin)]) {
      return;
    }
    seen[utils.guidFor(mixin)] = true;

    if (mixin.properties) {
      var props = mixin.properties;
      for (var key in props) {
        if (props.hasOwnProperty(key)) {
          ret[key] = true;
        }
      }
    } else if (mixin.mixins) {
      array.forEach.call(mixin.mixins, function (x) {
        _keys(ret, x, seen);
      });
    }
  }

  MixinPrototype.keys = function () {
    var keys = {};
    var seen = {};
    var ret = [];
    _keys(keys, this, seen);
    for (var key in keys) {
      if (keys.hasOwnProperty(key)) {
        ret.push(key);
      }
    }
    return ret;
  };

  // returns the mixins currently applied to the specified object
  // TODO: Make Ember.mixin
  Mixin.mixins = function (obj) {
    var m = obj["__ember_meta__"];
    var mixins = m && m.mixins;
    var ret = [];

    if (!mixins) {
      return ret;
    }

    for (var key in mixins) {
      var currentMixin = mixins[key];

      // skip primitive mixins since these are always anonymous
      if (!currentMixin.properties) {
        ret.push(currentMixin);
      }
    }

    return ret;
  };

  REQUIRED = new ember_metal__properties.Descriptor();
  REQUIRED.toString = function () {
    return "(Required Property)";
  };
  function required() {
        return REQUIRED;
  }

  function Alias(methodName) {
    this.isDescriptor = true;
    this.methodName = methodName;
  }

  Alias.prototype = new ember_metal__properties.Descriptor();
  function aliasMethod(methodName) {
    return new Alias(methodName);
  }

  function observer() {
    for (var _len4 = arguments.length, args = Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
      args[_key4] = arguments[_key4];
    }

    var func = args.slice(-1)[0];
    var paths;

    var addWatchedProperty = function (path) {
      paths.push(path);
    };
    var _paths = args.slice(0, -1);

    if (typeof func !== "function") {
      // revert to old, soft-deprecated argument ordering

      func = args[0];
      _paths = args.slice(1);
    }

    paths = [];

    for (var i = 0; i < _paths.length; ++i) {
      expandProperties['default'](_paths[i], addWatchedProperty);
    }

    if (typeof func !== "function") {
      throw new Ember['default'].Error("Ember.observer called without a function");
    }

    func.__ember_observes__ = paths;
    return func;
  }

  function immediateObserver() {
    for (var i = 0, l = arguments.length; i < l; i++) {
      var arg = arguments[i];
          }

    return observer.apply(this, arguments);
  }

  function beforeObserver() {
    for (var _len5 = arguments.length, args = Array(_len5), _key5 = 0; _key5 < _len5; _key5++) {
      args[_key5] = arguments[_key5];
    }

    var func = args.slice(-1)[0];
    var paths;

    var addWatchedProperty = function (path) {
      paths.push(path);
    };

    var _paths = args.slice(0, -1);

    if (typeof func !== "function") {
      // revert to old, soft-deprecated argument ordering

      func = args[0];
      _paths = args.slice(1);
    }

    paths = [];

    for (var i = 0; i < _paths.length; ++i) {
      expandProperties['default'](_paths[i], addWatchedProperty);
    }

    if (typeof func !== "function") {
      throw new Ember['default'].Error("Ember.beforeObserver called without a function");
    }

    func.__ember_observesBefore__ = paths;
    return func;
  }

  exports.IS_BINDING = IS_BINDING;
  exports.REQUIRED = REQUIRED;

});
enifed('ember-metal/observer', ['exports', 'ember-metal/watching', 'ember-metal/array', 'ember-metal/events'], function (exports, watching, array, ember_metal__events) {

  'use strict';

  exports.addObserver = addObserver;
  exports.observersFor = observersFor;
  exports.removeObserver = removeObserver;
  exports.addBeforeObserver = addBeforeObserver;
  exports._suspendBeforeObserver = _suspendBeforeObserver;
  exports._suspendObserver = _suspendObserver;
  exports._suspendBeforeObservers = _suspendBeforeObservers;
  exports._suspendObservers = _suspendObservers;
  exports.beforeObserversFor = beforeObserversFor;
  exports.removeBeforeObserver = removeBeforeObserver;

  /**
    @method addObserver
    @for Ember
    @param obj
    @param {String} path
    @param {Object|Function} targetOrMethod
    @param {Function|String} [method]
  */
  var AFTER_OBSERVERS = ":change";
  var BEFORE_OBSERVERS = ":before";

  function changeEvent(keyName) {
    return keyName + AFTER_OBSERVERS;
  }

  function beforeEvent(keyName) {
    return keyName + BEFORE_OBSERVERS;
  }
  function addObserver(obj, _path, target, method) {
    ember_metal__events.addListener(obj, changeEvent(_path), target, method);
    watching.watch(obj, _path);

    return this;
  }

  function observersFor(obj, path) {
    return ember_metal__events.listenersFor(obj, changeEvent(path));
  }

  function removeObserver(obj, path, target, method) {
    watching.unwatch(obj, path);
    ember_metal__events.removeListener(obj, changeEvent(path), target, method);

    return this;
  }

  function addBeforeObserver(obj, path, target, method) {
    ember_metal__events.addListener(obj, beforeEvent(path), target, method);
    watching.watch(obj, path);

    return this;
  }

  function _suspendBeforeObserver(obj, path, target, method, callback) {
    return ember_metal__events.suspendListener(obj, beforeEvent(path), target, method, callback);
  }

  function _suspendObserver(obj, path, target, method, callback) {
    return ember_metal__events.suspendListener(obj, changeEvent(path), target, method, callback);
  }

  function _suspendBeforeObservers(obj, paths, target, method, callback) {
    var events = array.map.call(paths, beforeEvent);
    return ember_metal__events.suspendListeners(obj, events, target, method, callback);
  }

  function _suspendObservers(obj, paths, target, method, callback) {
    var events = array.map.call(paths, changeEvent);
    return ember_metal__events.suspendListeners(obj, events, target, method, callback);
  }

  function beforeObserversFor(obj, path) {
    return ember_metal__events.listenersFor(obj, beforeEvent(path));
  }

  function removeBeforeObserver(obj, path, target, method) {
    watching.unwatch(obj, path);
    ember_metal__events.removeListener(obj, beforeEvent(path), target, method);

    return this;
  }

});
enifed('ember-metal/observer_set', ['exports', 'ember-metal/utils', 'ember-metal/events'], function (exports, utils, events) {

  'use strict';

  exports['default'] = ObserverSet;
  function ObserverSet() {
    this.clear();
  }

  ObserverSet.prototype.add = function (sender, keyName, eventName) {
    var observerSet = this.observerSet;
    var observers = this.observers;
    var senderGuid = utils.guidFor(sender);
    var keySet = observerSet[senderGuid];
    var index;

    if (!keySet) {
      observerSet[senderGuid] = keySet = {};
    }
    index = keySet[keyName];
    if (index === undefined) {
      index = observers.push({
        sender: sender,
        keyName: keyName,
        eventName: eventName,
        listeners: []
      }) - 1;
      keySet[keyName] = index;
    }
    return observers[index].listeners;
  };

  ObserverSet.prototype.flush = function () {
    var observers = this.observers;
    var i, len, observer, sender;
    this.clear();
    for (i = 0, len = observers.length; i < len; ++i) {
      observer = observers[i];
      sender = observer.sender;
      if (sender.isDestroying || sender.isDestroyed) {
        continue;
      }
      events.sendEvent(sender, observer.eventName, [sender, observer.keyName], observer.listeners);
    }
  };

  ObserverSet.prototype.clear = function () {
    this.observerSet = {};
    this.observers = [];
  };

});
enifed('ember-metal/path_cache', ['exports', 'ember-metal/cache'], function (exports, Cache) {

  'use strict';

  exports.isGlobal = isGlobal;
  exports.isGlobalPath = isGlobalPath;
  exports.hasThis = hasThis;
  exports.isPath = isPath;
  exports.getFirstKey = getFirstKey;
  exports.getTailPath = getTailPath;

  var IS_GLOBAL = /^[A-Z$]/;
  var IS_GLOBAL_PATH = /^[A-Z$].*[\.]/;
  var HAS_THIS = 'this.';

  var isGlobalCache = new Cache['default'](1000, function (key) {
    return IS_GLOBAL.test(key);
  });

  var isGlobalPathCache = new Cache['default'](1000, function (key) {
    return IS_GLOBAL_PATH.test(key);
  });

  var hasThisCache = new Cache['default'](1000, function (key) {
    return key.lastIndexOf(HAS_THIS, 0) === 0;
  });

  var firstDotIndexCache = new Cache['default'](1000, function (key) {
    return key.indexOf('.');
  });

  var firstKeyCache = new Cache['default'](1000, function (path) {
    var index = firstDotIndexCache.get(path);
    if (index === -1) {
      return path;
    } else {
      return path.slice(0, index);
    }
  });

  var tailPathCache = new Cache['default'](1000, function (path) {
    var index = firstDotIndexCache.get(path);
    if (index !== -1) {
      return path.slice(index + 1);
    }
  });

  var caches = {
    isGlobalCache: isGlobalCache,
    isGlobalPathCache: isGlobalPathCache,
    hasThisCache: hasThisCache,
    firstDotIndexCache: firstDotIndexCache,
    firstKeyCache: firstKeyCache,
    tailPathCache: tailPathCache
  };function isGlobal(path) {
    return isGlobalCache.get(path);
  }

  function isGlobalPath(path) {
    return isGlobalPathCache.get(path);
  }

  function hasThis(path) {
    return hasThisCache.get(path);
  }

  function isPath(path) {
    return firstDotIndexCache.get(path) !== -1;
  }

  function getFirstKey(path) {
    return firstKeyCache.get(path);
  }

  function getTailPath(path) {
    return tailPathCache.get(path);
  }

  exports.caches = caches;

});
enifed('ember-metal/platform/create', ['exports', 'ember-metal/platform/define_properties'], function (exports, defineProperties) {

  


  'REMOVE_USE_STRICT: true'; /**
                             @class platform
                             @namespace Ember
                             @static
                             */

  /**
    Identical to `Object.create()`. Implements if not available natively.

    @since 1.8.0
    @method create
    @for Ember
  */
  var create;
  // ES5 15.2.3.5
  // http://es5.github.com/#x15.2.3.5
  if (!(Object.create && !Object.create(null).hasOwnProperty)) {
    /* jshint scripturl:true, proto:true */
    // Contributed by Brandon Benvie, October, 2012
    var createEmpty;
    var supportsProto = !({ '__proto__': null } instanceof Object);
    // the following produces false positives
    // in Opera Mini => not a reliable check
    // Object.prototype.__proto__ === null
    if (supportsProto || typeof document === 'undefined') {
      createEmpty = function () {
        return { '__proto__': null };
      };
    } else {
      // In old IE __proto__ can't be used to manually set `null`, nor does
      // any other method exist to make an object that inherits from nothing,
      // aside from Object.prototype itself. Instead, create a new global
      // object and *steal* its Object.prototype and strip it bare. This is
      // used as the prototype to create nullary objects.
      createEmpty = function () {
        var iframe = document.createElement('iframe');
        var parent = document.body || document.documentElement;
        iframe.style.display = 'none';
        parent.appendChild(iframe);
        iframe.src = 'javascript:';
        var empty = iframe.contentWindow.Object.prototype;
        parent.removeChild(iframe);
        iframe = null;
        delete empty.constructor;
        delete empty.hasOwnProperty;
        delete empty.propertyIsEnumerable;
        delete empty.isPrototypeOf;
        delete empty.toLocaleString;
        delete empty.toString;
        delete empty.valueOf;

        function Empty() {}
        Empty.prototype = empty;
        // short-circuit future calls
        createEmpty = function () {
          return new Empty();
        };
        return new Empty();
      };
    }

    create = Object.create = function create(prototype, properties) {

      var object;
      function Type() {} // An empty constructor.

      if (prototype === null) {
        object = createEmpty();
      } else {
        if (typeof prototype !== 'object' && typeof prototype !== 'function') {
          // In the native implementation `parent` can be `null`
          // OR *any* `instanceof Object`  (Object|Function|Array|RegExp|etc)
          // Use `typeof` tho, b/c in old IE, DOM elements are not `instanceof Object`
          // like they are in modern browsers. Using `Object.create` on DOM elements
          // is...err...probably inappropriate, but the native version allows for it.
          throw new TypeError('Object prototype may only be an Object or null'); // same msg as Chrome
        }

        Type.prototype = prototype;

        object = new Type();
      }

      if (properties !== undefined) {
        defineProperties['default'](object, properties);
      }

      return object;
    };
  } else {
    create = Object.create;
  }

  exports['default'] = create;

});
enifed('ember-metal/platform/define_properties', ['exports', 'ember-metal/platform/define_property'], function (exports, define_property) {

  'use strict';

  var defineProperties = Object.defineProperties;

  // ES5 15.2.3.7
  // http://es5.github.com/#x15.2.3.7
  if (!defineProperties) {
    defineProperties = function defineProperties(object, properties) {
      for (var property in properties) {
        if (properties.hasOwnProperty(property) && property !== "__proto__") {
          define_property.defineProperty(object, property, properties[property]);
        }
      }
      return object;
    };

    Object.defineProperties = defineProperties;
  }

  exports['default'] = defineProperties;

});
enifed('ember-metal/platform/define_property', ['exports'], function (exports) {

  'use strict';

  /*globals Node */

  /**
  @class platform
  @namespace Ember
  @static
  */

  /**
    Set to true if the platform supports native getters and setters.

    @property hasPropertyAccessors
    @final
  */

  /**
    Identical to `Object.defineProperty()`. Implements as much functionality
    as possible if not available natively.

    @method defineProperty
    @param {Object} obj The object to modify
    @param {String} keyName property name to modify
    @param {Object} desc descriptor hash
    @return {void}
  */
  var defineProperty = (function checkCompliance(defineProperty) {
    if (!defineProperty) {
      return;
    }

    try {
      var a = 5;
      var obj = {};
      defineProperty(obj, 'a', {
        configurable: true,
        enumerable: true,
        get: function () {
          return a;
        },
        set: function (v) {
          a = v;
        }
      });
      if (obj.a !== 5) {
        return;
      }

      obj.a = 10;
      if (a !== 10) {
        return;
      }

      // check non-enumerability
      defineProperty(obj, 'a', {
        configurable: true,
        enumerable: false,
        writable: true,
        value: true
      });
      for (var key in obj) {
        if (key === 'a') {
          return;
        }
      }

      // Detects a bug in Android <3.2 where you cannot redefine a property using
      // Object.defineProperty once accessors have already been set.
      if (obj.a !== true) {
        return;
      }

      // Detects a bug in Android <3 where redefining a property without a value changes the value
      // Object.defineProperty once accessors have already been set.
      defineProperty(obj, 'a', {
        enumerable: false
      });
      if (obj.a !== true) {
        return;
      }

      // defineProperty is compliant
      return defineProperty;
    } catch (e) {
      // IE8 defines Object.defineProperty but calling it on an Object throws
      return;
    }
  })(Object.defineProperty);

  var hasES5CompliantDefineProperty = !!defineProperty;

  if (hasES5CompliantDefineProperty && typeof document !== 'undefined') {
    // This is for Safari 5.0, which supports Object.defineProperty, but not
    // on DOM nodes.
    var canDefinePropertyOnDOM = (function () {
      try {
        defineProperty(document.createElement('div'), 'definePropertyOnDOM', {});
        return true;
      } catch (e) {}

      return false;
    })();

    if (!canDefinePropertyOnDOM) {
      defineProperty = function (obj, keyName, desc) {
        var isNode;

        if (typeof Node === 'object') {
          isNode = obj instanceof Node;
        } else {
          isNode = typeof obj === 'object' && typeof obj.nodeType === 'number' && typeof obj.nodeName === 'string';
        }

        if (isNode) {
          // TODO: Should we have a warning here?
          return obj[keyName] = desc.value;
        } else {
          return Object.defineProperty(obj, keyName, desc);
        }
      };
    }
  }

  if (!hasES5CompliantDefineProperty) {
    defineProperty = function definePropertyPolyfill(obj, keyName, desc) {
      if (!desc.get) {
        obj[keyName] = desc.value;
      }
    };
  }

  var hasPropertyAccessors = hasES5CompliantDefineProperty;
  var canDefineNonEnumerableProperties = hasES5CompliantDefineProperty;

  exports.hasES5CompliantDefineProperty = hasES5CompliantDefineProperty;
  exports.defineProperty = defineProperty;
  exports.hasPropertyAccessors = hasPropertyAccessors;
  exports.canDefineNonEnumerableProperties = canDefineNonEnumerableProperties;

});
enifed('ember-metal/properties', ['exports', 'ember-metal/core', 'ember-metal/utils', 'ember-metal/platform/define_property', 'ember-metal/property_events'], function (exports, Ember, utils, define_property, property_events) {

  'use strict';

  exports.Descriptor = Descriptor;
  exports.MANDATORY_SETTER_FUNCTION = MANDATORY_SETTER_FUNCTION;
  exports.DEFAULT_GETTER_FUNCTION = DEFAULT_GETTER_FUNCTION;
  exports.defineProperty = defineProperty;

  // ..........................................................
  // DESCRIPTOR
  //

  /**
    Objects of this type can implement an interface to respond to requests to
    get and set. The default implementation handles simple properties.
  */
  function Descriptor() {
    this.isDescriptor = true;
  }

  function MANDATORY_SETTER_FUNCTION(name) {
    return function SETTER_FUNCTION(value) {
          };
  }

  function DEFAULT_GETTER_FUNCTION(name) {
    return function GETTER_FUNCTION() {
      var meta = this["__ember_meta__"];
      return meta && meta.values[name];
    };
  }

  function defineProperty(obj, keyName, desc, data, meta) {
    var possibleDesc, existingDesc, watching, value;

    if (!meta) {
      meta = utils.meta(obj);
    }
    var watchEntry = meta.watching[keyName];
    possibleDesc = obj[keyName];
    existingDesc = possibleDesc !== null && typeof possibleDesc === "object" && possibleDesc.isDescriptor ? possibleDesc : undefined;

    watching = watchEntry !== undefined && watchEntry > 0;

    if (existingDesc) {
      existingDesc.teardown(obj, keyName);
    }

    if (desc instanceof Descriptor) {
      value = desc;

      
        obj[keyName] = value;
      
      if (desc.setup) {
        desc.setup(obj, keyName);
      }
    } else {
      if (desc == null) {
        value = data;

        
          obj[keyName] = data;
        
      } else {
        value = desc;

        // compatibility with ES5
        define_property.defineProperty(obj, keyName, desc);
      }
    }

    // if key is being watched, override chains that
    // were initialized with the prototype
    if (watching) {
      property_events.overrideChains(obj, keyName, meta);
    }

    // The `value` passed to the `didDefineProperty` hook is
    // either the descriptor or data, whichever was passed.
    if (obj.didDefineProperty) {
      obj.didDefineProperty(obj, keyName, value);
    }

    return this;
  }

});
enifed('ember-metal/property_events', ['exports', 'ember-metal/utils', 'ember-metal/events', 'ember-metal/observer_set'], function (exports, utils, ember_metal__events, ObserverSet) {

  'use strict';

  exports.propertyWillChange = propertyWillChange;
  exports.propertyDidChange = propertyDidChange;
  exports.overrideChains = overrideChains;
  exports.beginPropertyChanges = beginPropertyChanges;
  exports.endPropertyChanges = endPropertyChanges;
  exports.changeProperties = changeProperties;

  var beforeObserverSet = new ObserverSet['default']();
  var observerSet = new ObserverSet['default']();
  var deferred = 0;

  // ..........................................................
  // PROPERTY CHANGES
  //

  /**
    This function is called just before an object property is about to change.
    It will notify any before observers and prepare caches among other things.

    Normally you will not need to call this method directly but if for some
    reason you can't directly watch a property you can invoke this method
    manually along with `Ember.propertyDidChange()` which you should call just
    after the property value changes.

    @method propertyWillChange
    @for Ember
    @param {Object} obj The object with the property that will change
    @param {String} keyName The property key (or path) that will change.
    @return {void}
  */
  function propertyWillChange(obj, keyName) {
    var m = obj["__ember_meta__"];
    var watching = m && m.watching[keyName] > 0 || keyName === "length";
    var proto = m && m.proto;
    var possibleDesc = obj[keyName];
    var desc = possibleDesc !== null && typeof possibleDesc === "object" && possibleDesc.isDescriptor ? possibleDesc : undefined;

    if (!watching) {
      return;
    }

    if (proto === obj) {
      return;
    }

    if (desc && desc.willChange) {
      desc.willChange(obj, keyName);
    }

    dependentKeysWillChange(obj, keyName, m);
    chainsWillChange(obj, keyName, m);
    notifyBeforeObservers(obj, keyName);
  }

  /**
    This function is called just after an object property has changed.
    It will notify any observers and clear caches among other things.

    Normally you will not need to call this method directly but if for some
    reason you can't directly watch a property you can invoke this method
    manually along with `Ember.propertyWillChange()` which you should call just
    before the property value changes.

    @method propertyDidChange
    @for Ember
    @param {Object} obj The object with the property that will change
    @param {String} keyName The property key (or path) that will change.
    @return {void}
  */
  function propertyDidChange(obj, keyName) {
    var m = obj["__ember_meta__"];
    var watching = m && m.watching[keyName] > 0 || keyName === "length";
    var proto = m && m.proto;
    var possibleDesc = obj[keyName];
    var desc = possibleDesc !== null && typeof possibleDesc === "object" && possibleDesc.isDescriptor ? possibleDesc : undefined;

    if (proto === obj) {
      return;
    }

    // shouldn't this mean that we're watching this key?
    if (desc && desc.didChange) {
      desc.didChange(obj, keyName);
    }

    if (!watching && keyName !== "length") {
      return;
    }

    if (m && m.deps && m.deps[keyName]) {
      dependentKeysDidChange(obj, keyName, m);
    }

    chainsDidChange(obj, keyName, m, false);
    notifyObservers(obj, keyName);
  }

  var WILL_SEEN, DID_SEEN;
  // called whenever a property is about to change to clear the cache of any dependent keys (and notify those properties of changes, etc...)
  function dependentKeysWillChange(obj, depKey, meta) {
    if (obj.isDestroying) {
      return;
    }

    var deps;
    if (meta && meta.deps && (deps = meta.deps[depKey])) {
      var seen = WILL_SEEN;
      var top = !seen;

      if (top) {
        seen = WILL_SEEN = {};
      }

      iterDeps(propertyWillChange, obj, deps, depKey, seen, meta);

      if (top) {
        WILL_SEEN = null;
      }
    }
  }

  // called whenever a property has just changed to update dependent keys
  function dependentKeysDidChange(obj, depKey, meta) {
    if (obj.isDestroying) {
      return;
    }

    var deps;
    if (meta && meta.deps && (deps = meta.deps[depKey])) {
      var seen = DID_SEEN;
      var top = !seen;

      if (top) {
        seen = DID_SEEN = {};
      }

      iterDeps(propertyDidChange, obj, deps, depKey, seen, meta);

      if (top) {
        DID_SEEN = null;
      }
    }
  }

  function keysOf(obj) {
    var keys = [];

    for (var key in obj) {
      keys.push(key);
    }

    return keys;
  }

  function iterDeps(method, obj, deps, depKey, seen, meta) {
    var keys, key, i, possibleDesc, desc;
    var guid = utils.guidFor(obj);
    var current = seen[guid];

    if (!current) {
      current = seen[guid] = {};
    }

    if (current[depKey]) {
      return;
    }

    current[depKey] = true;

    if (deps) {
      keys = keysOf(deps);
      for (i = 0; i < keys.length; i++) {
        key = keys[i];
        possibleDesc = obj[key];
        desc = possibleDesc !== null && typeof possibleDesc === "object" && possibleDesc.isDescriptor ? possibleDesc : undefined;

        if (desc && desc._suspended === obj) {
          continue;
        }

        method(obj, key);
      }
    }
  }

  function chainsWillChange(obj, keyName, m) {
    if (!(m.hasOwnProperty("chainWatchers") && m.chainWatchers[keyName])) {
      return;
    }

    var nodes = m.chainWatchers[keyName];
    var events = [];
    var i, l;

    for (i = 0, l = nodes.length; i < l; i++) {
      nodes[i].willChange(events);
    }

    for (i = 0, l = events.length; i < l; i += 2) {
      propertyWillChange(events[i], events[i + 1]);
    }
  }

  function chainsDidChange(obj, keyName, m, suppressEvents) {
    if (!(m && m.hasOwnProperty("chainWatchers") && m.chainWatchers[keyName])) {
      return;
    }

    var nodes = m.chainWatchers[keyName];
    var events = suppressEvents ? null : [];
    var i, l;

    for (i = 0, l = nodes.length; i < l; i++) {
      nodes[i].didChange(events);
    }

    if (suppressEvents) {
      return;
    }

    for (i = 0, l = events.length; i < l; i += 2) {
      propertyDidChange(events[i], events[i + 1]);
    }
  }

  function overrideChains(obj, keyName, m) {
    chainsDidChange(obj, keyName, m, true);
  }

  /**
    @method beginPropertyChanges
    @chainable
    @private
  */
  function beginPropertyChanges() {
    deferred++;
  }

  /**
    @method endPropertyChanges
    @private
  */
  function endPropertyChanges() {
    deferred--;
    if (deferred <= 0) {
      beforeObserverSet.clear();
      observerSet.flush();
    }
  }

  /**
    Make a series of property changes together in an
    exception-safe way.

    ```javascript
    Ember.changeProperties(function() {
      obj1.set('foo', mayBlowUpWhenSet);
      obj2.set('bar', baz);
    });
    ```

    @method changeProperties
    @param {Function} callback
    @param [binding]
  */
  function changeProperties(callback, binding) {
    beginPropertyChanges();
    utils.tryFinally(callback, endPropertyChanges, binding);
  }

  function notifyBeforeObservers(obj, keyName) {
    if (obj.isDestroying) {
      return;
    }

    var eventName = keyName + ":before";
    var listeners, added;
    if (deferred) {
      listeners = beforeObserverSet.add(obj, keyName, eventName);
      added = ember_metal__events.accumulateListeners(obj, eventName, listeners);
      ember_metal__events.sendEvent(obj, eventName, [obj, keyName], added);
    } else {
      ember_metal__events.sendEvent(obj, eventName, [obj, keyName]);
    }
  }

  function notifyObservers(obj, keyName) {
    if (obj.isDestroying) {
      return;
    }

    var eventName = keyName + ":change";
    var listeners;
    if (deferred) {
      listeners = observerSet.add(obj, keyName, eventName);
      ember_metal__events.accumulateListeners(obj, eventName, listeners);
    } else {
      ember_metal__events.sendEvent(obj, eventName, [obj, keyName]);
    }
  }

});
enifed('ember-metal/property_get', ['exports', 'ember-metal/core', 'ember-metal/error', 'ember-metal/path_cache', 'ember-metal/platform/define_property'], function (exports, Ember, EmberError, path_cache, define_property) {

  'use strict';

  exports.get = get;
  exports.normalizeTuple = normalizeTuple;
  exports._getPath = _getPath;
  exports.getWithDefault = getWithDefault;

  // ..........................................................
  // GET AND SET
  //
  // If we are on a platform that supports accessors we can use those.
  // Otherwise simulate accessors by looking up the property directly on the
  // object.

  /**
    Gets the value of a property on an object. If the property is computed,
    the function will be invoked. If the property is not defined but the
    object implements the `unknownProperty` method then that will be invoked.

    If you plan to run on IE8 and older browsers then you should use this
    method anytime you want to retrieve a property on an object that you don't
    know for sure is private. (Properties beginning with an underscore '_'
    are considered private.)

    On all newer browsers, you only need to use this method to retrieve
    properties if the property might not be defined on the object and you want
    to respect the `unknownProperty` handler. Otherwise you can ignore this
    method.

    Note that if the object itself is `undefined`, this method will throw
    an error.

    @method get
    @for Ember
    @param {Object} obj The object to retrieve from.
    @param {String} keyName The property key to retrieve
    @return {Object} the property value or `null`.
  */
  var FIRST_KEY = /^([^\.]+)/;
  function get(obj, keyName) {
    // Helpers that operate with 'this' within an #each
    if (keyName === "") {
      return obj;
    }

    if (!keyName && "string" === typeof obj) {
      keyName = obj;
      obj = Ember['default'].lookup;
    }

        
    if (!obj) {
      return _getPath(obj, keyName);
    }

    var meta = obj["__ember_meta__"];
    var possibleDesc = obj[keyName];
    var desc = possibleDesc !== null && typeof possibleDesc === "object" && possibleDesc.isDescriptor ? possibleDesc : undefined;
    var ret;

    if (desc === undefined && path_cache.isPath(keyName)) {
      return _getPath(obj, keyName);
    }

    if (desc) {
      return desc.get(obj, keyName);
    } else {
      
        ret = obj[keyName];
      

      if (ret === undefined && "object" === typeof obj && !(keyName in obj) && "function" === typeof obj.unknownProperty) {
        return obj.unknownProperty(keyName);
      }

      return ret;
    }
  }

  function normalizeTuple(target, path) {
    var hasThis = path_cache.hasThis(path);
    var isGlobal = !hasThis && path_cache.isGlobal(path);
    var key;

    if (!target && !isGlobal) {
      return [undefined, ""];
    }

    if (hasThis) {
      path = path.slice(5);
    }

    if (!target || isGlobal) {
      target = Ember['default'].lookup;
    }

    if (isGlobal && path_cache.isPath(path)) {
      key = path.match(FIRST_KEY)[0];
      target = get(target, key);
      path = path.slice(key.length + 1);
    }

    // must return some kind of path to be valid else other things will break.
    validateIsPath(path);

    return [target, path];
  }

  function validateIsPath(path) {
    if (!path || path.length === 0) {
      throw new EmberError['default']("Object in path " + path + " could not be found or was destroyed.");
    }
  }
  function _getPath(root, path) {
    var hasThis, parts, tuple, idx, len;

    // detect complicated paths and normalize them
    hasThis = path_cache.hasThis(path);

    if (!root || hasThis) {
      tuple = normalizeTuple(root, path);
      root = tuple[0];
      path = tuple[1];
      tuple.length = 0;
    }

    parts = path.split(".");
    len = parts.length;
    for (idx = 0; root != null && idx < len; idx++) {
      root = get(root, parts[idx], true);
      if (root && root.isDestroyed) {
        return undefined;
      }
    }
    return root;
  }

  function getWithDefault(root, key, defaultValue) {
    var value = get(root, key);

    if (value === undefined) {
      return defaultValue;
    }
    return value;
  }

  exports['default'] = get;

});
enifed('ember-metal/property_set', ['exports', 'ember-metal/core', 'ember-metal/property_get', 'ember-metal/property_events', 'ember-metal/properties', 'ember-metal/error', 'ember-metal/path_cache', 'ember-metal/platform/define_property'], function (exports, Ember, property_get, property_events, properties, EmberError, path_cache, define_property) {

  'use strict';

  exports.set = set;
  exports.trySet = trySet;

  /**
    Sets the value of a property on an object, respecting computed properties
    and notifying observers and other listeners of the change. If the
    property is not defined but the object implements the `setUnknownProperty`
    method then that will be invoked as well.

    @method set
    @for Ember
    @param {Object} obj The object to modify.
    @param {String} keyName The property key to set
    @param {Object} value The value to set
    @return {Object} the passed value.
  */
  function set(obj, keyName, value, tolerant) {
    if (typeof obj === "string") {
            value = keyName;
      keyName = obj;
      obj = Ember['default'].lookup;
    }

    
    if (obj === Ember['default'].lookup) {
      return setPath(obj, keyName, value, tolerant);
    }

    var meta, possibleDesc, desc;
    if (obj) {
      meta = obj["__ember_meta__"];
      possibleDesc = obj[keyName];
      desc = possibleDesc !== null && typeof possibleDesc === "object" && possibleDesc.isDescriptor ? possibleDesc : undefined;
    }

    var isUnknown, currentValue;
    if ((!obj || desc === undefined) && path_cache.isPath(keyName)) {
      return setPath(obj, keyName, value, tolerant);
    }

        
    if (desc) {
      desc.set(obj, keyName, value);
    } else {

      if (obj !== null && value !== undefined && typeof obj === "object" && obj[keyName] === value) {
        return value;
      }

      isUnknown = "object" === typeof obj && !(keyName in obj);

      // setUnknownProperty is called if `obj` is an object,
      // the property does not already exist, and the
      // `setUnknownProperty` method exists on the object
      if (isUnknown && "function" === typeof obj.setUnknownProperty) {
        obj.setUnknownProperty(keyName, value);
      } else if (meta && meta.watching[keyName] > 0) {
        if (meta.proto !== obj) {
          
            currentValue = obj[keyName];
          
        }
        // only trigger a change if the value has changed
        if (value !== currentValue) {
          property_events.propertyWillChange(obj, keyName);
          
            obj[keyName] = value;
          
          property_events.propertyDidChange(obj, keyName);
        }
      } else {
        obj[keyName] = value;
      }
    }
    return value;
  }

  function setPath(root, path, value, tolerant) {
    var keyName;

    // get the last part of the path
    keyName = path.slice(path.lastIndexOf(".") + 1);

    // get the first part of the part
    path = path === keyName ? keyName : path.slice(0, path.length - (keyName.length + 1));

    // unless the path is this, look up the first part to
    // get the root
    if (path !== "this") {
      root = property_get._getPath(root, path);
    }

    if (!keyName || keyName.length === 0) {
      throw new EmberError['default']("Property set failed: You passed an empty path");
    }

    if (!root) {
      if (tolerant) {
        return;
      } else {
        throw new EmberError['default']("Property set failed: object in path \"" + path + "\" could not be found or was destroyed.");
      }
    }

    return set(root, keyName, value);
  }
  function trySet(root, path, value) {
    return set(root, path, value, true);
  }

});
enifed('ember-metal/run_loop', ['exports', 'ember-metal/core', 'ember-metal/utils', 'ember-metal/array', 'ember-metal/property_events', 'backburner'], function (exports, Ember, utils, array, property_events, Backburner) {

  'use strict';

  function onBegin(current) {
    run.currentRunLoop = current;
  }

  function onEnd(current, next) {
    run.currentRunLoop = next;
  }

  // ES6TODO: should Backburner become es6?
  var backburner = new Backburner['default'](['sync', 'actions', 'destroy'], {
    GUID_KEY: utils.GUID_KEY,
    sync: {
      before: property_events.beginPropertyChanges,
      after: property_events.endPropertyChanges
    },
    defaultQueue: 'actions',
    onBegin: onBegin,
    onEnd: onEnd,
    onErrorTarget: Ember['default'],
    onErrorMethod: 'onerror'
  });

  // ..........................................................
  // run - this is ideally the only public API the dev sees
  //

  /**
    Runs the passed target and method inside of a RunLoop, ensuring any
    deferred actions including bindings and views updates are flushed at the
    end.

    Normally you should not need to invoke this method yourself. However if
    you are implementing raw event handlers when interfacing with other
    libraries or plugins, you should probably wrap all of your code inside this
    call.

    ```javascript
    run(function() {
      // code to be executed within a RunLoop
    });
    ```

    @class run
    @namespace Ember
    @static
    @constructor
    @param {Object} [target] target of method to call
    @param {Function|String} method Method to invoke.
      May be a function or a string. If you pass a string
      then it will be looked up on the passed target.
    @param {Object} [args*] Any additional arguments you wish to pass to the method.
    @return {Object} return value from invoking the passed function.
  */
  exports['default'] = run;
  function run() {
    return backburner.run.apply(backburner, arguments);
  }

  /**
    If no run-loop is present, it creates a new one. If a run loop is
    present it will queue itself to run on the existing run-loops action
    queue.

    Please note: This is not for normal usage, and should be used sparingly.

    If invoked when not within a run loop:

    ```javascript
    run.join(function() {
      // creates a new run-loop
    });
    ```

    Alternatively, if called within an existing run loop:

    ```javascript
    run(function() {
      // creates a new run-loop
      run.join(function() {
        // joins with the existing run-loop, and queues for invocation on
        // the existing run-loops action queue.
      });
    });
    ```

    @method join
    @namespace Ember
    @param {Object} [target] target of method to call
    @param {Function|String} method Method to invoke.
      May be a function or a string. If you pass a string
      then it will be looked up on the passed target.
    @param {Object} [args*] Any additional arguments you wish to pass to the method.
    @return {Object} Return value from invoking the passed function. Please note,
    when called within an existing loop, no return value is possible.
  */
  run.join = function () {
    return backburner.join.apply(backburner, arguments);
  };

  /**
    Allows you to specify which context to call the specified function in while
    adding the execution of that function to the Ember run loop. This ability
    makes this method a great way to asynchronously integrate third-party libraries
    into your Ember application.

    `run.bind` takes two main arguments, the desired context and the function to
    invoke in that context. Any additional arguments will be supplied as arguments
    to the function that is passed in.

    Let's use the creation of a TinyMCE component as an example. Currently,
    TinyMCE provides a setup configuration option we can use to do some processing
    after the TinyMCE instance is initialized but before it is actually rendered.
    We can use that setup option to do some additional setup for our component.
    The component itself could look something like the following:

    ```javascript
    App.RichTextEditorComponent = Ember.Component.extend({
      initializeTinyMCE: Ember.on('didInsertElement', function() {
        tinymce.init({
          selector: '#' + this.$().prop('id'),
          setup: Ember.run.bind(this, this.setupEditor)
        });
      }),

      setupEditor: function(editor) {
        this.set('editor', editor);

        editor.on('change', function() {
          console.log('content changed!');
        });
      }
    });
    ```

    In this example, we use Ember.run.bind to bind the setupEditor method to the
    context of the App.RichTextEditorComponent and to have the invocation of that
    method be safely handled and executed by the Ember run loop.

    @method bind
    @namespace Ember
    @param {Object} [target] target of method to call
    @param {Function|String} method Method to invoke.
      May be a function or a string. If you pass a string
      then it will be looked up on the passed target.
    @param {Object} [args*] Any additional arguments you wish to pass to the method.
    @return {Function} returns a new function that will always have a particular context
    @since 1.4.0
  */
  run.bind = function () {
    for (var _len = arguments.length, curried = Array(_len), _key = 0; _key < _len; _key++) {
      curried[_key] = arguments[_key];
    }

    return function () {
      for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        args[_key2] = arguments[_key2];
      }

      return run.join.apply(run, curried.concat(args));
    };
  };

  run.backburner = backburner;
  run.currentRunLoop = null;
  run.queues = backburner.queueNames;

  /**
    Begins a new RunLoop. Any deferred actions invoked after the begin will
    be buffered until you invoke a matching call to `run.end()`. This is
    a lower-level way to use a RunLoop instead of using `run()`.

    ```javascript
    run.begin();
    // code to be executed within a RunLoop
    run.end();
    ```

    @method begin
    @return {void}
  */
  run.begin = function () {
    backburner.begin();
  };

  /**
    Ends a RunLoop. This must be called sometime after you call
    `run.begin()` to flush any deferred actions. This is a lower-level way
    to use a RunLoop instead of using `run()`.

    ```javascript
    run.begin();
    // code to be executed within a RunLoop
    run.end();
    ```

    @method end
    @return {void}
  */
  run.end = function () {
    backburner.end();
  };

  /**
    Array of named queues. This array determines the order in which queues
    are flushed at the end of the RunLoop. You can define your own queues by
    simply adding the queue name to this array. Normally you should not need
    to inspect or modify this property.

    @property queues
    @type Array
    @default ['sync', 'actions', 'destroy']
  */

  /**
    Adds the passed target/method and any optional arguments to the named
    queue to be executed at the end of the RunLoop. If you have not already
    started a RunLoop when calling this method one will be started for you
    automatically.

    At the end of a RunLoop, any methods scheduled in this way will be invoked.
    Methods will be invoked in an order matching the named queues defined in
    the `run.queues` property.

    ```javascript
    run.schedule('sync', this, function() {
      // this will be executed in the first RunLoop queue, when bindings are synced
      console.log('scheduled on sync queue');
    });

    run.schedule('actions', this, function() {
      // this will be executed in the 'actions' queue, after bindings have synced.
      console.log('scheduled on actions queue');
    });

    // Note the functions will be run in order based on the run queues order.
    // Output would be:
    //   scheduled on sync queue
    //   scheduled on actions queue
    ```

    @method schedule
    @param {String} queue The name of the queue to schedule against.
      Default queues are 'sync' and 'actions'
    @param {Object} [target] target object to use as the context when invoking a method.
    @param {String|Function} method The method to invoke. If you pass a string it
      will be resolved on the target object at the time the scheduled item is
      invoked allowing you to change the target function.
    @param {Object} [arguments*] Optional arguments to be passed to the queued method.
    @return {void}
  */
  run.schedule = function () {
    checkAutoRun();
    backburner.schedule.apply(backburner, arguments);
  };

  // Used by global test teardown
  run.hasScheduledTimers = function () {
    return backburner.hasTimers();
  };

  // Used by global test teardown
  run.cancelTimers = function () {
    backburner.cancelTimers();
  };

  /**
    Immediately flushes any events scheduled in the 'sync' queue. Bindings
    use this queue so this method is a useful way to immediately force all
    bindings in the application to sync.

    You should call this method anytime you need any changed state to propagate
    throughout the app immediately without repainting the UI (which happens
    in the later 'render' queue added by the `ember-views` package).

    ```javascript
    run.sync();
    ```

    @method sync
    @return {void}
  */
  run.sync = function () {
    if (backburner.currentInstance) {
      backburner.currentInstance.queues.sync.flush();
    }
  };

  /**
    Invokes the passed target/method and optional arguments after a specified
    period of time. The last parameter of this method must always be a number
    of milliseconds.

    You should use this method whenever you need to run some action after a
    period of time instead of using `setTimeout()`. This method will ensure that
    items that expire during the same script execution cycle all execute
    together, which is often more efficient than using a real setTimeout.

    ```javascript
    run.later(myContext, function() {
      // code here will execute within a RunLoop in about 500ms with this == myContext
    }, 500);
    ```

    @method later
    @param {Object} [target] target of method to invoke
    @param {Function|String} method The method to invoke.
      If you pass a string it will be resolved on the
      target at the time the method is invoked.
    @param {Object} [args*] Optional arguments to pass to the timeout.
    @param {Number} wait Number of milliseconds to wait.
    @return {*} Timer information for use in cancelling, see `run.cancel`.
  */
  run.later = function () {
    return backburner.later.apply(backburner, arguments);
  };

  /**
    Schedule a function to run one time during the current RunLoop. This is equivalent
    to calling `scheduleOnce` with the "actions" queue.

    @method once
    @param {Object} [target] The target of the method to invoke.
    @param {Function|String} method The method to invoke.
      If you pass a string it will be resolved on the
      target at the time the method is invoked.
    @param {Object} [args*] Optional arguments to pass to the timeout.
    @return {Object} Timer information for use in cancelling, see `run.cancel`.
  */
  run.once = function () {
    for (var _len3 = arguments.length, args = Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
      args[_key3] = arguments[_key3];
    }

    checkAutoRun();
    args.unshift('actions');
    return backburner.scheduleOnce.apply(backburner, args);
  };

  /**
    Schedules a function to run one time in a given queue of the current RunLoop.
    Calling this method with the same queue/target/method combination will have
    no effect (past the initial call).

    Note that although you can pass optional arguments these will not be
    considered when looking for duplicates. New arguments will replace previous
    calls.

    ```javascript
    function sayHi() {
      console.log('hi');
    }

    run(function() {
      run.scheduleOnce('afterRender', myContext, sayHi);
      run.scheduleOnce('afterRender', myContext, sayHi);
      // sayHi will only be executed once, in the afterRender queue of the RunLoop
    });
    ```

    Also note that passing an anonymous function to `run.scheduleOnce` will
    not prevent additional calls with an identical anonymous function from
    scheduling the items multiple times, e.g.:

    ```javascript
    function scheduleIt() {
      run.scheduleOnce('actions', myContext, function() {
        console.log('Closure');
      });
    }

    scheduleIt();
    scheduleIt();

    // "Closure" will print twice, even though we're using `run.scheduleOnce`,
    // because the function we pass to it is anonymous and won't match the
    // previously scheduled operation.
    ```

    Available queues, and their order, can be found at `run.queues`

    @method scheduleOnce
    @param {String} [queue] The name of the queue to schedule against. Default queues are 'sync' and 'actions'.
    @param {Object} [target] The target of the method to invoke.
    @param {Function|String} method The method to invoke.
      If you pass a string it will be resolved on the
      target at the time the method is invoked.
    @param {Object} [args*] Optional arguments to pass to the timeout.
    @return {Object} Timer information for use in cancelling, see `run.cancel`.
  */
  run.scheduleOnce = function () {
    checkAutoRun();
    return backburner.scheduleOnce.apply(backburner, arguments);
  };

  /**
    Schedules an item to run from within a separate run loop, after
    control has been returned to the system. This is equivalent to calling
    `run.later` with a wait time of 1ms.

    ```javascript
    run.next(myContext, function() {
      // code to be executed in the next run loop,
      // which will be scheduled after the current one
    });
    ```

    Multiple operations scheduled with `run.next` will coalesce
    into the same later run loop, along with any other operations
    scheduled by `run.later` that expire right around the same
    time that `run.next` operations will fire.

    Note that there are often alternatives to using `run.next`.
    For instance, if you'd like to schedule an operation to happen
    after all DOM element operations have completed within the current
    run loop, you can make use of the `afterRender` run loop queue (added
    by the `ember-views` package, along with the preceding `render` queue
    where all the DOM element operations happen). Example:

    ```javascript
    App.MyCollectionView = Ember.CollectionView.extend({
      didInsertElement: function() {
        run.scheduleOnce('afterRender', this, 'processChildElements');
      },
      processChildElements: function() {
        // ... do something with collectionView's child view
        // elements after they've finished rendering, which
        // can't be done within the CollectionView's
        // `didInsertElement` hook because that gets run
        // before the child elements have been added to the DOM.
      }
    });
    ```

    One benefit of the above approach compared to using `run.next` is
    that you will be able to perform DOM/CSS operations before unprocessed
    elements are rendered to the screen, which may prevent flickering or
    other artifacts caused by delaying processing until after rendering.

    The other major benefit to the above approach is that `run.next`
    introduces an element of non-determinism, which can make things much
    harder to test, due to its reliance on `setTimeout`; it's much harder
    to guarantee the order of scheduled operations when they are scheduled
    outside of the current run loop, i.e. with `run.next`.

    @method next
    @param {Object} [target] target of method to invoke
    @param {Function|String} method The method to invoke.
      If you pass a string it will be resolved on the
      target at the time the method is invoked.
    @param {Object} [args*] Optional arguments to pass to the timeout.
    @return {Object} Timer information for use in cancelling, see `run.cancel`.
  */
  run.next = function () {
    for (var _len4 = arguments.length, args = Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
      args[_key4] = arguments[_key4];
    }

    args.push(1);
    return backburner.later.apply(backburner, args);
  };

  /**
    Cancels a scheduled item. Must be a value returned by `run.later()`,
    `run.once()`, `run.next()`, `run.debounce()`, or
    `run.throttle()`.

    ```javascript
    var runNext = run.next(myContext, function() {
      // will not be executed
    });

    run.cancel(runNext);

    var runLater = run.later(myContext, function() {
      // will not be executed
    }, 500);

    run.cancel(runLater);

    var runOnce = run.once(myContext, function() {
      // will not be executed
    });

    run.cancel(runOnce);

    var throttle = run.throttle(myContext, function() {
      // will not be executed
    }, 1, false);

    run.cancel(throttle);

    var debounce = run.debounce(myContext, function() {
      // will not be executed
    }, 1);

    run.cancel(debounce);

    var debounceImmediate = run.debounce(myContext, function() {
      // will be executed since we passed in true (immediate)
    }, 100, true);

    // the 100ms delay until this method can be called again will be cancelled
    run.cancel(debounceImmediate);
    ```

    @method cancel
    @param {Object} timer Timer object to cancel
    @return {Boolean} true if cancelled or false/undefined if it wasn't found
  */
  run.cancel = function (timer) {
    return backburner.cancel(timer);
  };

  /**
    Delay calling the target method until the debounce period has elapsed
    with no additional debounce calls. If `debounce` is called again before
    the specified time has elapsed, the timer is reset and the entire period
    must pass again before the target method is called.

    This method should be used when an event may be called multiple times
    but the action should only be called once when the event is done firing.
    A common example is for scroll events where you only want updates to
    happen once scrolling has ceased.

    ```javascript
    function whoRan() {
      console.log(this.name + ' ran.');
    }

    var myContext = { name: 'debounce' };

    run.debounce(myContext, whoRan, 150);

    // less than 150ms passes
    run.debounce(myContext, whoRan, 150);

    // 150ms passes
    // whoRan is invoked with context myContext
    // console logs 'debounce ran.' one time.
    ```

    Immediate allows you to run the function immediately, but debounce
    other calls for this function until the wait time has elapsed. If
    `debounce` is called again before the specified time has elapsed,
    the timer is reset and the entire period must pass again before
    the method can be called again.

    ```javascript
    function whoRan() {
      console.log(this.name + ' ran.');
    }

    var myContext = { name: 'debounce' };

    run.debounce(myContext, whoRan, 150, true);

    // console logs 'debounce ran.' one time immediately.
    // 100ms passes
    run.debounce(myContext, whoRan, 150, true);

    // 150ms passes and nothing else is logged to the console and
    // the debouncee is no longer being watched
    run.debounce(myContext, whoRan, 150, true);

    // console logs 'debounce ran.' one time immediately.
    // 150ms passes and nothing else is logged to the console and
    // the debouncee is no longer being watched

    ```

    @method debounce
    @param {Object} [target] target of method to invoke
    @param {Function|String} method The method to invoke.
      May be a function or a string. If you pass a string
      then it will be looked up on the passed target.
    @param {Object} [args*] Optional arguments to pass to the timeout.
    @param {Number} wait Number of milliseconds to wait.
    @param {Boolean} immediate Trigger the function on the leading instead
      of the trailing edge of the wait interval. Defaults to false.
    @return {Array} Timer information for use in cancelling, see `run.cancel`.
  */
  run.debounce = function () {
    return backburner.debounce.apply(backburner, arguments);
  };

  /**
    Ensure that the target method is never called more frequently than
    the specified spacing period. The target method is called immediately.

    ```javascript
    function whoRan() {
      console.log(this.name + ' ran.');
    }

    var myContext = { name: 'throttle' };

    run.throttle(myContext, whoRan, 150);
    // whoRan is invoked with context myContext
    // console logs 'throttle ran.'

    // 50ms passes
    run.throttle(myContext, whoRan, 150);

    // 50ms passes
    run.throttle(myContext, whoRan, 150);

    // 150ms passes
    run.throttle(myContext, whoRan, 150);
    // whoRan is invoked with context myContext
    // console logs 'throttle ran.'
    ```

    @method throttle
    @param {Object} [target] target of method to invoke
    @param {Function|String} method The method to invoke.
      May be a function or a string. If you pass a string
      then it will be looked up on the passed target.
    @param {Object} [args*] Optional arguments to pass to the timeout.
    @param {Number} spacing Number of milliseconds to space out requests.
    @param {Boolean} immediate Trigger the function on the leading instead
      of the trailing edge of the wait interval. Defaults to true.
    @return {Array} Timer information for use in cancelling, see `run.cancel`.
  */
  run.throttle = function () {
    return backburner.throttle.apply(backburner, arguments);
  };

  // Make sure it's not an autorun during testing
  function checkAutoRun() {
    if (!run.currentRunLoop) {
          }
  }

  /**
    Add a new named queue after the specified queue.

    The queue to add will only be added once.

    @method _addQueue
    @param {String} name the name of the queue to add.
    @param {String} after the name of the queue to add after.
    @private
  */
  run._addQueue = function (name, after) {
    if (array.indexOf.call(run.queues, name) === -1) {
      run.queues.splice(array.indexOf.call(run.queues, after) + 1, 0, name);
    }
  };
  /* queue, target, method */ /*target, method*/ /*queue, target, method*/

});
enifed('ember-metal/set_properties', ['exports', 'ember-metal/property_events', 'ember-metal/property_set', 'ember-metal/keys'], function (exports, property_events, property_set, keys) {

  'use strict';



  /**
    Set a list of properties on an object. These properties are set inside
    a single `beginPropertyChanges` and `endPropertyChanges` batch, so
    observers will be buffered.

    ```javascript
    var anObject = Ember.Object.create();

    anObject.setProperties({
      firstName: 'Stanley',
      lastName: 'Stuart',
      age: 21
    });
    ```

    @method setProperties
    @param obj
    @param {Object} properties
    @return obj
  */
  exports['default'] = setProperties;
  function setProperties(obj, properties) {
    if (!properties || typeof properties !== "object") {
      return obj;
    }
    property_events.changeProperties(function () {
      var props = keys['default'](properties);
      var propertyName;

      for (var i = 0, l = props.length; i < l; i++) {
        propertyName = props[i];

        property_set.set(obj, propertyName, properties[propertyName]);
      }
    });
    return obj;
  }

});
enifed('ember-metal/streams/conditional', ['exports', 'ember-metal/streams/stream', 'ember-metal/streams/utils', 'ember-metal/platform/create'], function (exports, Stream, utils, create) {

  'use strict';



  exports['default'] = conditional;

  function conditional(test, consequent, alternate) {
    if (utils.isStream(test)) {
      return new ConditionalStream(test, consequent, alternate);
    } else {
      if (test) {
        return consequent;
      } else {
        return alternate;
      }
    }
  }

  function ConditionalStream(test, consequent, alternate) {
    this.init();

    this.oldTestResult = undefined;
    this.test = test;
    this.consequent = consequent;
    this.alternate = alternate;
  }

  ConditionalStream.prototype = create['default'](Stream['default'].prototype);

  ConditionalStream.prototype.valueFn = function () {
    var oldTestResult = this.oldTestResult;
    var newTestResult = !!utils.read(this.test);

    if (newTestResult !== oldTestResult) {
      switch (oldTestResult) {
        case true:
          utils.unsubscribe(this.consequent, this.notify, this);break;
        case false:
          utils.unsubscribe(this.alternate, this.notify, this);break;
        case undefined:
          utils.subscribe(this.test, this.notify, this);
      }

      switch (newTestResult) {
        case true:
          utils.subscribe(this.consequent, this.notify, this);break;
        case false:
          utils.subscribe(this.alternate, this.notify, this);
      }

      this.oldTestResult = newTestResult;
    }

    return newTestResult ? utils.read(this.consequent) : utils.read(this.alternate);
  };

});
enifed('ember-metal/streams/simple', ['exports', 'ember-metal/merge', 'ember-metal/streams/stream', 'ember-metal/platform/create', 'ember-metal/streams/utils'], function (exports, merge, Stream, create, utils) {

  'use strict';

  function SimpleStream(source) {
    this.init();
    this.source = source;

    if (utils.isStream(source)) {
      source.subscribe(this._didChange, this);
    }
  }

  SimpleStream.prototype = create['default'](Stream['default'].prototype);

  merge['default'](SimpleStream.prototype, {
    valueFn: function () {
      return utils.read(this.source);
    },

    setValue: function (value) {
      var source = this.source;

      if (utils.isStream(source)) {
        source.setValue(value);
      }
    },

    setSource: function (nextSource) {
      var prevSource = this.source;
      if (nextSource !== prevSource) {
        if (utils.isStream(prevSource)) {
          prevSource.unsubscribe(this._didChange, this);
        }

        if (utils.isStream(nextSource)) {
          nextSource.subscribe(this._didChange, this);
        }

        this.source = nextSource;
        this.notify();
      }
    },

    _didChange: function () {
      this.notify();
    },

    _super$destroy: Stream['default'].prototype.destroy,

    destroy: function () {
      if (this._super$destroy()) {
        if (utils.isStream(this.source)) {
          this.source.unsubscribe(this._didChange, this);
        }
        this.source = undefined;
        return true;
      }
    }
  });

  exports['default'] = SimpleStream;

});
enifed('ember-metal/streams/stream', ['exports', 'ember-metal/platform/create', 'ember-metal/path_cache'], function (exports, create, path_cache) {

  'use strict';

  function Subscriber(callback, context) {
    this.next = null;
    this.prev = null;
    this.callback = callback;
    this.context = context;
  }

  Subscriber.prototype.removeFrom = function (stream) {
    var next = this.next;
    var prev = this.prev;

    if (prev) {
      prev.next = next;
    } else {
      stream.subscriberHead = next;
    }

    if (next) {
      next.prev = prev;
    } else {
      stream.subscriberTail = prev;
    }
  };

  /*
    @public
    @class Stream
    @namespace Ember.stream
    @constructor
  */
  function Stream(fn) {
    this.init();
    this.valueFn = fn;
  }

  Stream.prototype = {
    isStream: true,

    init: function () {
      this.state = "dirty";
      this.cache = undefined;
      this.subscriberHead = null;
      this.subscriberTail = null;
      this.children = undefined;
      this._label = undefined;
    },

    get: function (path) {
      var firstKey = path_cache.getFirstKey(path);
      var tailPath = path_cache.getTailPath(path);

      if (this.children === undefined) {
        this.children = create['default'](null);
      }

      var keyStream = this.children[firstKey];

      if (keyStream === undefined) {
        keyStream = this._makeChildStream(firstKey, path);
        this.children[firstKey] = keyStream;
      }

      if (tailPath === undefined) {
        return keyStream;
      } else {
        return keyStream.get(tailPath);
      }
    },

    value: function () {
      if (this.state === "clean") {
        return this.cache;
      } else if (this.state === "dirty") {
        this.state = "clean";
        return this.cache = this.valueFn();
      }
      // TODO: Ensure value is never called on a destroyed stream
      // so that we can uncomment this assertion.
      //
      // Ember.assert("Stream error: value was called in an invalid state: " + this.state);
    },

    valueFn: function () {
      throw new Error("Stream error: valueFn not implemented");
    },

    setValue: function () {
      throw new Error("Stream error: setValue not implemented");
    },

    notify: function () {
      this.notifyExcept();
    },

    notifyExcept: function (callbackToSkip, contextToSkip) {
      if (this.state === "clean") {
        this.state = "dirty";
        this._notifySubscribers(callbackToSkip, contextToSkip);
      }
    },

    subscribe: function (callback, context) {
      var subscriber = new Subscriber(callback, context, this);
      if (this.subscriberHead === null) {
        this.subscriberHead = this.subscriberTail = subscriber;
      } else {
        var tail = this.subscriberTail;
        tail.next = subscriber;
        subscriber.prev = tail;
        this.subscriberTail = subscriber;
      }

      var stream = this;
      return function () {
        subscriber.removeFrom(stream);
      };
    },

    unsubscribe: function (callback, context) {
      var subscriber = this.subscriberHead;

      while (subscriber) {
        var next = subscriber.next;
        if (subscriber.callback === callback && subscriber.context === context) {
          subscriber.removeFrom(this);
        }
        subscriber = next;
      }
    },

    _notifySubscribers: function (callbackToSkip, contextToSkip) {
      var subscriber = this.subscriberHead;

      while (subscriber) {
        var next = subscriber.next;

        var callback = subscriber.callback;
        var context = subscriber.context;

        subscriber = next;

        if (callback === callbackToSkip && context === contextToSkip) {
          continue;
        }

        if (context === undefined) {
          callback(this);
        } else {
          callback.call(context, this);
        }
      }
    },

    destroy: function () {
      if (this.state !== "destroyed") {
        this.state = "destroyed";

        var children = this.children;
        for (var key in children) {
          children[key].destroy();
        }

        this.subscriberHead = this.subscriberTail = null;

        return true;
      }
    },

    isGlobal: function () {
      var stream = this;
      while (stream !== undefined) {
        if (stream._isRoot) {
          return stream._isGlobal;
        }
        stream = stream.source;
      }
    }
  };

  exports['default'] = Stream;

});
enifed('ember-metal/streams/stream_binding', ['exports', 'ember-metal/platform/create', 'ember-metal/merge', 'ember-metal/run_loop', 'ember-metal/streams/stream'], function (exports, create, merge, run, Stream) {

  'use strict';

  function StreamBinding(stream) {
    
    this.init();
    this.stream = stream;
    this.senderCallback = undefined;
    this.senderContext = undefined;
    this.senderValue = undefined;

    stream.subscribe(this._onNotify, this);
  }

  StreamBinding.prototype = create['default'](Stream['default'].prototype);

  merge['default'](StreamBinding.prototype, {
    valueFn: function () {
      return this.stream.value();
    },

    _onNotify: function () {
      this._scheduleSync(undefined, undefined, this);
    },

    setValue: function (value, callback, context) {
      this._scheduleSync(value, callback, context);
    },

    _scheduleSync: function (value, callback, context) {
      if (this.senderCallback === undefined && this.senderContext === undefined) {
        this.senderCallback = callback;
        this.senderContext = context;
        this.senderValue = value;
        run['default'].schedule("sync", this, this._sync);
      } else if (this.senderContext !== this) {
        this.senderCallback = callback;
        this.senderContext = context;
        this.senderValue = value;
      }
    },

    _sync: function () {
      if (this.state === "destroyed") {
        return;
      }

      if (this.senderContext !== this) {
        this.stream.setValue(this.senderValue);
      }

      var senderCallback = this.senderCallback;
      var senderContext = this.senderContext;
      this.senderCallback = undefined;
      this.senderContext = undefined;
      this.senderValue = undefined;

      // Force StreamBindings to always notify
      this.state = "clean";

      this.notifyExcept(senderCallback, senderContext);
    },

    _super$destroy: Stream['default'].prototype.destroy,

    destroy: function () {
      if (this._super$destroy()) {
        this.stream.unsubscribe(this._onNotify, this);
        return true;
      }
    }
  });

  exports['default'] = StreamBinding;

});
enifed('ember-metal/streams/utils', ['exports', './stream'], function (exports, Stream) {

  'use strict';

  exports.isStream = isStream;
  exports.subscribe = subscribe;
  exports.unsubscribe = unsubscribe;
  exports.read = read;
  exports.readArray = readArray;
  exports.readHash = readHash;
  exports.scanArray = scanArray;
  exports.scanHash = scanHash;
  exports.concat = concat;
  exports.chain = chain;

  /*
   Check whether an object is a stream or not

   @public
   @for Ember.stream
   @function isStream
   @param {Object|Stream} object object to check whether it is a stream
   @return {Boolean} `true` if the object is a stream, `false` otherwise
  */
  function isStream(object) {
    return object && object.isStream;
  }

  function subscribe(object, callback, context) {
    if (object && object.isStream) {
      object.subscribe(callback, context);
    }
  }

  function unsubscribe(object, callback, context) {
    if (object && object.isStream) {
      object.unsubscribe(callback, context);
    }
  }

  function read(object) {
    if (object && object.isStream) {
      return object.value();
    } else {
      return object;
    }
  }

  function readArray(array) {
    var length = array.length;
    var ret = new Array(length);
    for (var i = 0; i < length; i++) {
      ret[i] = read(array[i]);
    }
    return ret;
  }

  function readHash(object) {
    var ret = {};
    for (var key in object) {
      ret[key] = read(object[key]);
    }
    return ret;
  }

  function scanArray(array) {
    var length = array.length;
    var containsStream = false;

    for (var i = 0; i < length; i++) {
      if (isStream(array[i])) {
        containsStream = true;
        break;
      }
    }

    return containsStream;
  }

  function scanHash(hash) {
    var containsStream = false;

    for (var prop in hash) {
      if (isStream(hash[prop])) {
        containsStream = true;
        break;
      }
    }

    return containsStream;
  }

  function concat(array, separator) {
    // TODO: Create subclass ConcatStream < Stream. Defer
    // subscribing to streams until the value() is called.
    var hasStream = scanArray(array);
    if (hasStream) {
      var i, l;
      var stream = new Stream['default'](function () {
        return readArray(array).join(separator);
      });

      for (i = 0, l = array.length; i < l; i++) {
        subscribe(array[i], stream.notify, stream);
      }

      return stream;
    } else {
      return array.join(separator);
    }
  }

  function chain(value, fn) {
    if (isStream(value)) {
      var stream = new Stream['default'](fn);
      subscribe(value, stream.notify, stream);
      return stream;
    } else {
      return fn();
    }
  }

});
enifed('ember-metal/utils', ['exports', 'ember-metal/core', 'ember-metal/platform/create', 'ember-metal/platform/define_property', 'ember-metal/array'], function (exports, Ember, o_create, define_property, array) {

  
  exports.uuid = uuid;
  exports.generateGuid = generateGuid;
  exports.guidFor = guidFor;
  exports.getMeta = getMeta;
  exports.setMeta = setMeta;
  exports.metaPath = metaPath;
  exports.wrap = wrap;
  exports.makeArray = makeArray;
  exports.tryInvoke = tryInvoke;
  exports.inspect = inspect;
  exports.apply = apply;
  exports.applyStr = applyStr;
  exports.meta = meta;
  exports.typeOf = typeOf;
  exports.isArray = isArray;
  exports.canInvoke = canInvoke;

  /**
    Generates a universally unique identifier. This method
    is used internally by Ember for assisting with
    the generation of GUID's and other unique identifiers
    such as `bind-attr` data attributes.

    @public
    @return {Number} [description]
   */
  "REMOVE_USE_STRICT: true"; /**
                             @module ember-metal
                             */

  /**
    Previously we used `Ember.$.uuid`, however `$.uuid` has been removed from
    jQuery master. We'll just bootstrap our own uuid now.

    @private
    @return {Number} the uuid
  */
  var _uuid = 0;
  function uuid() {
    return ++_uuid;
  }

  /**
    Prefix used for guids through out Ember.
    @private
    @property GUID_PREFIX
    @for Ember
    @type String
    @final
  */
  var GUID_PREFIX = "ember";

  // Used for guid generation...
  var numberCache = [];
  var stringCache = {};

  /**
    Strongly hint runtimes to intern the provided string.

    When do I need to use this function?

    For the most part, never. Pre-mature optimization is bad, and often the
    runtime does exactly what you need it to, and more often the trade-off isn't
    worth it.

    Why?

    Runtimes store strings in at least 2 different representations:
    Ropes and Symbols (interned strings). The Rope provides a memory efficient
    data-structure for strings created from concatenation or some other string
    manipulation like splitting.

    Unfortunately checking equality of different ropes can be quite costly as
    runtimes must resort to clever string comparison algorithms. These
    algorithms typically cost in proportion to the length of the string.
    Luckily, this is where the Symbols (interned strings) shine. As Symbols are
    unique by their string content, equality checks can be done by pointer
    comparison.

    How do I know if my string is a rope or symbol?

    Typically (warning general sweeping statement, but truthy in runtimes at
    present) static strings created as part of the JS source are interned.
    Strings often used for comparisons can be interned at runtime if some
    criteria are met.  One of these criteria can be the size of the entire rope.
    For example, in chrome 38 a rope longer then 12 characters will not
    intern, nor will segments of that rope.

    Some numbers: http://jsperf.com/eval-vs-keys/8

    Known Trick™

    @private
    @return {String} interned version of the provided string
  */
  function intern(str) {
    var obj = {};
    obj[str] = 1;
    for (var key in obj) {
      if (key === str) {
        return key;
      }
    }
    return str;
  }

  /**
    A unique key used to assign guids and other private metadata to objects.
    If you inspect an object in your browser debugger you will often see these.
    They can be safely ignored.

    On browsers that support it, these properties are added with enumeration
    disabled so they won't show up when you iterate over your properties.

    @private
    @property GUID_KEY
    @for Ember
    @type String
    @final
  */
  var GUID_KEY = intern("__ember" + +new Date());

  var GUID_DESC = {
    writable: true,
    configurable: true,
    enumerable: false,
    value: null
  };

  var undefinedDescriptor = {
    configurable: true,
    writable: true,
    enumerable: false,
    value: undefined
  };

  var nullDescriptor = {
    configurable: true,
    writable: true,
    enumerable: false,
    value: null
  };

  var META_DESC = {
    writable: true,
    configurable: true,
    enumerable: false,
    value: null
  };

  var EMBER_META_PROPERTY = {
    name: "__ember_meta__",
    descriptor: META_DESC
  };

  var GUID_KEY_PROPERTY = {
    name: GUID_KEY,
    descriptor: nullDescriptor
  };

  var NEXT_SUPER_PROPERTY = {
    name: "__nextSuper",
    descriptor: undefinedDescriptor
  };function generateGuid(obj, prefix) {
    if (!prefix) {
      prefix = GUID_PREFIX;
    }

    var ret = prefix + uuid();
    if (obj) {
      if (obj[GUID_KEY] === null) {
        obj[GUID_KEY] = ret;
      } else {
        GUID_DESC.value = ret;
        if (obj.__defineNonEnumerable) {
          obj.__defineNonEnumerable(GUID_KEY_PROPERTY);
        } else {
          define_property.defineProperty(obj, GUID_KEY, GUID_DESC);
        }
      }
    }
    return ret;
  }

  function guidFor(obj) {

    // special cases where we don't want to add a key to object
    if (obj === undefined) {
      return "(undefined)";
    }

    if (obj === null) {
      return "(null)";
    }

    var ret;
    var type = typeof obj;

    // Don't allow prototype changes to String etc. to change the guidFor
    switch (type) {
      case "number":
        ret = numberCache[obj];

        if (!ret) {
          ret = numberCache[obj] = "nu" + obj;
        }

        return ret;

      case "string":
        ret = stringCache[obj];

        if (!ret) {
          ret = stringCache[obj] = "st" + uuid();
        }

        return ret;

      case "boolean":
        return obj ? "(true)" : "(false)";

      default:
        if (obj[GUID_KEY]) {
          return obj[GUID_KEY];
        }

        if (obj === Object) {
          return "(Object)";
        }

        if (obj === Array) {
          return "(Array)";
        }

        ret = GUID_PREFIX + uuid();

        if (obj[GUID_KEY] === null) {
          obj[GUID_KEY] = ret;
        } else {
          GUID_DESC.value = ret;

          if (obj.__defineNonEnumerable) {
            obj.__defineNonEnumerable(GUID_KEY_PROPERTY);
          } else {
            define_property.defineProperty(obj, GUID_KEY, GUID_DESC);
          }
        }
        return ret;
    }
  }

  // ..........................................................
  // META
  //
  function Meta(obj) {
    this.watching = {};
    this.cache = undefined;
    this.cacheMeta = undefined;
    this.source = obj;
    this.deps = undefined;
    this.listeners = undefined;
    this.mixins = undefined;
    this.bindings = undefined;
    this.chains = undefined;
    this.values = undefined;
    this.proto = undefined;
  }

  Meta.prototype = {
    chainWatchers: null // FIXME
  };

  if (!define_property.canDefineNonEnumerableProperties) {
    // on platforms that don't support enumerable false
    // make meta fail jQuery.isPlainObject() to hide from
    // jQuery.extend() by having a property that fails
    // hasOwnProperty check.
    Meta.prototype.__preventPlainObject__ = true;

    // Without non-enumerable properties, meta objects will be output in JSON
    // unless explicitly suppressed
    Meta.prototype.toJSON = function () {};
  }

  // Placeholder for non-writable metas.
  var EMPTY_META = new Meta(null);

  
  /**
    Retrieves the meta hash for an object. If `writable` is true ensures the
    hash is writable for this object as well.

    The meta object contains information about computed property descriptors as
    well as any watched properties and other information. You generally will
    not access this information directly but instead work with higher level
    methods that manipulate this hash indirectly.

    @method meta
    @for Ember
    @private

    @param {Object} obj The object to retrieve meta for
    @param {Boolean} [writable=true] Pass `false` if you do not intend to modify
      the meta hash, allowing the method to avoid making an unnecessary copy.
    @return {Object} the meta hash for an object
  */
  function meta(obj, writable) {
    var ret = obj.__ember_meta__;
    if (writable === false) {
      return ret || EMPTY_META;
    }

    if (!ret) {
      if (define_property.canDefineNonEnumerableProperties) {
        if (obj.__defineNonEnumerable) {
          obj.__defineNonEnumerable(EMBER_META_PROPERTY);
        } else {
          define_property.defineProperty(obj, "__ember_meta__", META_DESC);
        }
      }

      ret = new Meta(obj);

      
      obj.__ember_meta__ = ret;
    } else if (ret.source !== obj) {
      if (obj.__defineNonEnumerable) {
        obj.__defineNonEnumerable(EMBER_META_PROPERTY);
      } else {
        define_property.defineProperty(obj, "__ember_meta__", META_DESC);
      }

      ret = o_create['default'](ret);
      ret.watching = o_create['default'](ret.watching);
      ret.cache = undefined;
      ret.cacheMeta = undefined;
      ret.source = obj;

      
      obj["__ember_meta__"] = ret;
    }
    return ret;
  }
  function getMeta(obj, property) {
    var _meta = meta(obj, false);
    return _meta[property];
  }

  function setMeta(obj, property, value) {
    var _meta = meta(obj, true);
    _meta[property] = value;
    return value;
  }

  function metaPath(obj, path, writable) {
        var _meta = meta(obj, writable);
    var keyName, value;

    for (var i = 0, l = path.length; i < l; i++) {
      keyName = path[i];
      value = _meta[keyName];

      if (!value) {
        if (!writable) {
          return undefined;
        }
        value = _meta[keyName] = { __ember_source__: obj };
      } else if (value.__ember_source__ !== obj) {
        if (!writable) {
          return undefined;
        }
        value = _meta[keyName] = o_create['default'](value);
        value.__ember_source__ = obj;
      }

      _meta = value;
    }

    return value;
  }

  function wrap(func, superFunc) {
    function superWrapper() {
      var ret;
      var sup = this && this.__nextSuper;
      var length = arguments.length;

      if (this) {
        this.__nextSuper = superFunc;
      }

      if (length === 0) {
        ret = func.call(this);
      } else if (length === 1) {
        ret = func.call(this, arguments[0]);
      } else if (length === 2) {
        ret = func.call(this, arguments[0], arguments[1]);
      } else {
        var args = new Array(length);
        for (var i = 0; i < length; i++) {
          args[i] = arguments[i];
        }
        ret = apply(this, func, args);
      }

      if (this) {
        this.__nextSuper = sup;
      }

      return ret;
    }

    superWrapper.wrappedFunction = func;
    superWrapper.__ember_observes__ = func.__ember_observes__;
    superWrapper.__ember_observesBefore__ = func.__ember_observesBefore__;
    superWrapper.__ember_listens__ = func.__ember_listens__;

    return superWrapper;
  }

  var EmberArray;

  /**
    Returns true if the passed object is an array or Array-like.

    Ember Array Protocol:

      - the object has an objectAt property
      - the object is a native Array
      - the object is an Object, and has a length property

    Unlike `Ember.typeOf` this method returns true even if the passed object is
    not formally array but appears to be array-like (i.e. implements `Ember.Array`)

    ```javascript
    Ember.isArray();                                          // false
    Ember.isArray([]);                                        // true
    Ember.isArray(Ember.ArrayProxy.create({ content: [] }));  // true
    ```

    @method isArray
    @for Ember
    @param {Object} obj The object to test
    @return {Boolean} true if the passed object is an array or Array-like
  */
  // ES6TODO: Move up to runtime? This is only use in ember-metal by concatenatedProperties
  function isArray(obj) {
    var modulePath, type;

    if (typeof EmberArray === "undefined") {
      modulePath = "ember-runtime/mixins/array";
      if (Ember['default'].__loader.registry[modulePath]) {
        EmberArray = Ember['default'].__loader.require(modulePath)["default"];
      }
    }

    if (!obj || obj.setInterval) {
      return false;
    }
    if (Array.isArray && Array.isArray(obj)) {
      return true;
    }
    if (EmberArray && EmberArray.detect(obj)) {
      return true;
    }

    type = typeOf(obj);
    if ("array" === type) {
      return true;
    }
    if (obj.length !== undefined && "object" === type) {
      return true;
    }
    return false;
  }
  function makeArray(obj) {
    if (obj === null || obj === undefined) {
      return [];
    }
    return isArray(obj) ? obj : [obj];
  }

  /**
    Checks to see if the `methodName` exists on the `obj`.

    ```javascript
    var foo = { bar: function() { return 'bar'; }, baz: null };

    Ember.canInvoke(foo, 'bar'); // true
    Ember.canInvoke(foo, 'baz'); // false
    Ember.canInvoke(foo, 'bat'); // false
    ```

    @method canInvoke
    @for Ember
    @param {Object} obj The object to check for the method
    @param {String} methodName The method name to check for
    @return {Boolean}
  */
  function canInvoke(obj, methodName) {
    return !!(obj && typeof obj[methodName] === "function");
  }
  function tryInvoke(obj, methodName, args) {
    if (canInvoke(obj, methodName)) {
      return args ? applyStr(obj, methodName, args) : applyStr(obj, methodName);
    }
  }

  // https://github.com/emberjs/ember.js/pull/1617
  var needsFinallyFix = (function () {
    var count = 0;
    try {
      // jscs:disable
      try {} finally {
        count++;
        throw new Error("needsFinallyFixTest");
      }
      // jscs:enable
    } catch (e) {}

    return count !== 1;
  })();

  /**
    Provides try/finally functionality, while working
    around Safari's double finally bug.

    ```javascript
    var tryable = function() {
      someResource.lock();
      runCallback(); // May throw error.
    };

    var finalizer = function() {
      someResource.unlock();
    };

    Ember.tryFinally(tryable, finalizer);
    ```

    @method tryFinally
    @deprecated Use JavaScript's native try/finally
    @for Ember
    @param {Function} tryable The function to run the try callback
    @param {Function} finalizer The function to run the finally callback
    @param {Object} [binding] The optional calling object. Defaults to 'this'
    @return {*} The return value is the that of the finalizer,
    unless that value is undefined, in which case it is the return value
    of the tryable
  */

  var tryFinally;
  if (needsFinallyFix) {
    tryFinally = function (tryable, finalizer, binding) {
      var result, finalResult, finalError;

      binding = binding || this;

      try {
        result = tryable.call(binding);
      } finally {
        try {
          finalResult = finalizer.call(binding);
        } catch (e) {
          finalError = e;
        }
      }

      if (finalError) {
        throw finalError;
      }

      return finalResult === undefined ? result : finalResult;
    };
  } else {
    tryFinally = function (tryable, finalizer, binding) {
      var result, finalResult;

      binding = binding || this;

      try {
        result = tryable.call(binding);
      } finally {
        finalResult = finalizer.call(binding);
      }

      return finalResult === undefined ? result : finalResult;
    };
  }

  var deprecatedTryFinally = function () {
        return tryFinally.apply(this, arguments);
  };

  /**
    Provides try/catch/finally functionality, while working
    around Safari's double finally bug.

    ```javascript
    var tryable = function() {
      for (i = 0, l = listeners.length; i < l; i++) {
        listener = listeners[i];
        beforeValues[i] = listener.before(name, time(), payload);
      }

      return callback.call(binding);
    };

    var catchable = function(e) {
      payload = payload || {};
      payload.exception = e;
    };

    var finalizer = function() {
      for (i = 0, l = listeners.length; i < l; i++) {
        listener = listeners[i];
        listener.after(name, time(), payload, beforeValues[i]);
      }
    };

    Ember.tryCatchFinally(tryable, catchable, finalizer);
    ```

    @method tryCatchFinally
    @deprecated Use JavaScript's native try/catch/finally instead
    @for Ember
    @param {Function} tryable The function to run the try callback
    @param {Function} catchable The function to run the catchable callback
    @param {Function} finalizer The function to run the finally callback
    @param {Object} [binding] The optional calling object. Defaults to 'this'
    @return {*} The return value is the that of the finalizer,
    unless that value is undefined, in which case it is the return value
    of the tryable.
  */
  var tryCatchFinally;
  if (needsFinallyFix) {
    tryCatchFinally = function (tryable, catchable, finalizer, binding) {
      var result, finalResult, finalError;

      binding = binding || this;

      try {
        result = tryable.call(binding);
      } catch (error) {
        result = catchable.call(binding, error);
      } finally {
        try {
          finalResult = finalizer.call(binding);
        } catch (e) {
          finalError = e;
        }
      }

      if (finalError) {
        throw finalError;
      }

      return finalResult === undefined ? result : finalResult;
    };
  } else {
    tryCatchFinally = function (tryable, catchable, finalizer, binding) {
      var result, finalResult;

      binding = binding || this;

      try {
        result = tryable.call(binding);
      } catch (error) {
        result = catchable.call(binding, error);
      } finally {
        finalResult = finalizer.call(binding);
      }

      return finalResult === undefined ? result : finalResult;
    };
  }

  var deprecatedTryCatchFinally = function () {
        return tryCatchFinally.apply(this, arguments);
  };

  // ........................................
  // TYPING & ARRAY MESSAGING
  //

  var TYPE_MAP = {};
  var t = "Boolean Number String Function Array Date RegExp Object".split(" ");
  array.forEach.call(t, function (name) {
    TYPE_MAP["[object " + name + "]"] = name.toLowerCase();
  });

  var toString = Object.prototype.toString;

  var EmberObject;

  /**
    Returns a consistent type for the passed item.

    Use this instead of the built-in `typeof` to get the type of an item.
    It will return the same result across all browsers and includes a bit
    more detail. Here is what will be returned:

        | Return Value  | Meaning                                              |
        |---------------|------------------------------------------------------|
        | 'string'      | String primitive or String object.                   |
        | 'number'      | Number primitive or Number object.                   |
        | 'boolean'     | Boolean primitive or Boolean object.                 |
        | 'null'        | Null value                                           |
        | 'undefined'   | Undefined value                                      |
        | 'function'    | A function                                           |
        | 'array'       | An instance of Array                                 |
        | 'regexp'      | An instance of RegExp                                |
        | 'date'        | An instance of Date                                  |
        | 'class'       | An Ember class (created using Ember.Object.extend()) |
        | 'instance'    | An Ember object instance                             |
        | 'error'       | An instance of the Error object                      |
        | 'object'      | A JavaScript object not inheriting from Ember.Object |

    Examples:

    ```javascript
    Ember.typeOf();                       // 'undefined'
    Ember.typeOf(null);                   // 'null'
    Ember.typeOf(undefined);              // 'undefined'
    Ember.typeOf('michael');              // 'string'
    Ember.typeOf(new String('michael'));  // 'string'
    Ember.typeOf(101);                    // 'number'
    Ember.typeOf(new Number(101));        // 'number'
    Ember.typeOf(true);                   // 'boolean'
    Ember.typeOf(new Boolean(true));      // 'boolean'
    Ember.typeOf(Ember.makeArray);        // 'function'
    Ember.typeOf([1, 2, 90]);             // 'array'
    Ember.typeOf(/abc/);                  // 'regexp'
    Ember.typeOf(new Date());             // 'date'
    Ember.typeOf(Ember.Object.extend());  // 'class'
    Ember.typeOf(Ember.Object.create());  // 'instance'
    Ember.typeOf(new Error('teamocil'));  // 'error'

    // 'normal' JavaScript object
    Ember.typeOf({ a: 'b' });             // 'object'
    ```

    @method typeOf
    @for Ember
    @param {Object} item the item to check
    @return {String} the type
  */
  function typeOf(item) {
    var ret, modulePath;

    // ES6TODO: Depends on Ember.Object which is defined in runtime.
    if (typeof EmberObject === "undefined") {
      modulePath = "ember-runtime/system/object";
      if (Ember['default'].__loader.registry[modulePath]) {
        EmberObject = Ember['default'].__loader.require(modulePath)["default"];
      }
    }

    ret = item === null || item === undefined ? String(item) : TYPE_MAP[toString.call(item)] || "object";

    if (ret === "function") {
      if (EmberObject && EmberObject.detect(item)) {
        ret = "class";
      }
    } else if (ret === "object") {
      if (item instanceof Error) {
        ret = "error";
      } else if (EmberObject && item instanceof EmberObject) {
        ret = "instance";
      } else if (item instanceof Date) {
        ret = "date";
      }
    }

    return ret;
  }
  function inspect(obj) {
    var type = typeOf(obj);
    if (type === "array") {
      return "[" + obj + "]";
    }
    if (type !== "object") {
      return obj + "";
    }

    var v;
    var ret = [];
    for (var key in obj) {
      if (obj.hasOwnProperty(key)) {
        v = obj[key];
        if (v === "toString") {
          continue;
        } // ignore useless items
        if (typeOf(v) === "function") {
          v = "function() { ... }";
        }

        if (v && typeof v.toString !== "function") {
          ret.push(key + ": " + toString.call(v));
        } else {
          ret.push(key + ": " + v);
        }
      }
    }
    return "{" + ret.join(", ") + "}";
  }

  function apply(t, m, a) {
    var l = a && a.length;
    if (!a || !l) {
      return m.call(t);
    }
    switch (l) {
      case 1:
        return m.call(t, a[0]);
      case 2:
        return m.call(t, a[0], a[1]);
      case 3:
        return m.call(t, a[0], a[1], a[2]);
      case 4:
        return m.call(t, a[0], a[1], a[2], a[3]);
      case 5:
        return m.call(t, a[0], a[1], a[2], a[3], a[4]);
      default:
        return m.apply(t, a);
    }
  }

  function applyStr(t, m, a) {
    var l = a && a.length;
    if (!a || !l) {
      return t[m]();
    }
    switch (l) {
      case 1:
        return t[m](a[0]);
      case 2:
        return t[m](a[0], a[1]);
      case 3:
        return t[m](a[0], a[1], a[2]);
      case 4:
        return t[m](a[0], a[1], a[2], a[3]);
      case 5:
        return t[m](a[0], a[1], a[2], a[3], a[4]);
      default:
        return t[m].apply(t, a);
    }
  }

  exports.GUID_DESC = GUID_DESC;
  exports.EMBER_META_PROPERTY = EMBER_META_PROPERTY;
  exports.GUID_KEY_PROPERTY = GUID_KEY_PROPERTY;
  exports.NEXT_SUPER_PROPERTY = NEXT_SUPER_PROPERTY;
  exports.GUID_KEY = GUID_KEY;
  exports.META_DESC = META_DESC;
  exports.EMPTY_META = EMPTY_META;
  exports.tryCatchFinally = tryCatchFinally;
  exports.deprecatedTryCatchFinally = deprecatedTryCatchFinally;
  exports.tryFinally = tryFinally;
  exports.deprecatedTryFinally = deprecatedTryFinally;

});
enifed('ember-metal/watch_key', ['exports', 'ember-metal/core', 'ember-metal/utils', 'ember-metal/platform/define_property', 'ember-metal/properties'], function (exports, Ember, utils, define_property, properties) {

  'use strict';

  exports.watchKey = watchKey;
  exports.unwatchKey = unwatchKey;

  function watchKey(obj, keyName, meta) {
    // can't watch length on Array - it is special...
    if (keyName === "length" && utils.typeOf(obj) === "array") {
      return;
    }

    var m = meta || utils.meta(obj);
    var watching = m.watching;

    // activate watching first time
    if (!watching[keyName]) {
      watching[keyName] = 1;

      var possibleDesc = obj[keyName];
      var desc = possibleDesc !== null && typeof possibleDesc === "object" && possibleDesc.isDescriptor ? possibleDesc : undefined;
      if (desc && desc.willWatch) {
        desc.willWatch(obj, keyName);
      }

      if ("function" === typeof obj.willWatchProperty) {
        obj.willWatchProperty(keyName);
      }

          } else {
      watching[keyName] = (watching[keyName] || 0) + 1;
    }
  }

  
  // This is super annoying, but required until
  // https://github.com/babel/babel/issues/906 is resolved
  ;
  function unwatchKey(obj, keyName, meta) {
    var m = meta || utils.meta(obj);
    var watching = m.watching;

    if (watching[keyName] === 1) {
      watching[keyName] = 0;

      var possibleDesc = obj[keyName];
      var desc = possibleDesc !== null && typeof possibleDesc === "object" && possibleDesc.isDescriptor ? possibleDesc : undefined;
      if (desc && desc.didUnwatch) {
        desc.didUnwatch(obj, keyName);
      }

      if ("function" === typeof obj.didUnwatchProperty) {
        obj.didUnwatchProperty(keyName);
      }

          } else if (watching[keyName] > 1) {
      watching[keyName]--;
    }
  }

});
enifed('ember-metal/watch_path', ['exports', 'ember-metal/utils', 'ember-metal/chains'], function (exports, utils, chains) {

  'use strict';

  exports.watchPath = watchPath;
  exports.unwatchPath = unwatchPath;

  function chainsFor(obj, meta) {
    var m = meta || utils.meta(obj);
    var ret = m.chains;
    if (!ret) {
      ret = m.chains = new chains.ChainNode(null, null, obj);
    } else if (ret.value() !== obj) {
      ret = m.chains = ret.copy(obj);
    }
    return ret;
  }
  function watchPath(obj, keyPath, meta) {
    // can't watch length on Array - it is special...
    if (keyPath === "length" && utils.typeOf(obj) === "array") {
      return;
    }

    var m = meta || utils.meta(obj);
    var watching = m.watching;

    if (!watching[keyPath]) {
      // activate watching first time
      watching[keyPath] = 1;
      chainsFor(obj, m).add(keyPath);
    } else {
      watching[keyPath] = (watching[keyPath] || 0) + 1;
    }
  }

  function unwatchPath(obj, keyPath, meta) {
    var m = meta || utils.meta(obj);
    var watching = m.watching;

    if (watching[keyPath] === 1) {
      watching[keyPath] = 0;
      chainsFor(obj, m).remove(keyPath);
    } else if (watching[keyPath] > 1) {
      watching[keyPath]--;
    }
  }

});
enifed('ember-metal/watching', ['exports', 'ember-metal/utils', 'ember-metal/chains', 'ember-metal/watch_key', 'ember-metal/watch_path', 'ember-metal/path_cache'], function (exports, utils, chains, watch_key, watch_path, path_cache) {

  'use strict';

  exports.isWatching = isWatching;
  exports.unwatch = unwatch;
  exports.destroy = destroy;
  exports.watch = watch;

  function watch(obj, _keyPath, m) {
    // can't watch length on Array - it is special...
    if (_keyPath === "length" && utils.typeOf(obj) === "array") {
      return;
    }

    if (!path_cache.isPath(_keyPath)) {
      watch_key.watchKey(obj, _keyPath, m);
    } else {
      watch_path.watchPath(obj, _keyPath, m);
    }
  }

  function isWatching(obj, key) {
    var meta = obj["__ember_meta__"];
    return (meta && meta.watching[key]) > 0;
  }

  watch.flushPending = chains.flushPendingChains;
  function unwatch(obj, _keyPath, m) {
    // can't watch length on Array - it is special...
    if (_keyPath === "length" && utils.typeOf(obj) === "array") {
      return;
    }

    if (!path_cache.isPath(_keyPath)) {
      watch_key.unwatchKey(obj, _keyPath, m);
    } else {
      watch_path.unwatchPath(obj, _keyPath, m);
    }
  }

  var NODE_STACK = [];
  function destroy(obj) {
    var meta = obj["__ember_meta__"];
    var node, nodes, key, nodeObject;

    if (meta) {
      obj["__ember_meta__"] = null;
      // remove chainWatchers to remove circular references that would prevent GC
      node = meta.chains;
      if (node) {
        NODE_STACK.push(node);
        // process tree
        while (NODE_STACK.length > 0) {
          node = NODE_STACK.pop();
          // push children
          nodes = node._chains;
          if (nodes) {
            for (key in nodes) {
              if (nodes.hasOwnProperty(key)) {
                NODE_STACK.push(nodes[key]);
              }
            }
          }
          // remove chainWatcher in node object
          if (node._watching) {
            nodeObject = node._object;
            if (nodeObject) {
              chains.removeChainWatcher(nodeObject, node._key, node);
            }
          }
        }
      }
    }
  }

});
enifed('ember-routing-htmlbars', ['exports', 'ember-metal/core', 'ember-htmlbars/helpers', 'ember-routing-htmlbars/helpers/outlet', 'ember-routing-htmlbars/helpers/render', 'ember-routing-htmlbars/helpers/link-to', 'ember-routing-htmlbars/helpers/action', 'ember-routing-htmlbars/helpers/query-params'], function (exports, Ember, helpers, outlet, render, link_to, action, query_params) {

	'use strict';

	/**
	Ember Routing HTMLBars Helpers

	@module ember
	@submodule ember-routing-htmlbars
	@requires ember-routing
	*/

	helpers.registerHelper("outlet", outlet.outletHelper);
	helpers.registerHelper("render", render.renderHelper);
	helpers.registerHelper("link-to", link_to.linkToHelper);
	helpers.registerHelper("linkTo", link_to.deprecatedLinkToHelper);
	helpers.registerHelper("action", action.actionHelper);
	helpers.registerHelper("query-params", query_params.queryParamsHelper);

	exports['default'] = Ember['default'];

});
enifed('ember-routing-htmlbars/helpers/action', ['exports', 'ember-metal/core', 'ember-metal/utils', 'ember-metal/run_loop', 'ember-views/streams/utils', 'ember-views/system/utils', 'ember-views/system/action_manager', 'ember-metal/streams/utils'], function (exports, Ember, utils, run, streams__utils, system__utils, ActionManager, ember_metal__streams__utils) {

  'use strict';

  exports.actionHelper = actionHelper;

  /**
    The `{{action}}` helper provides a useful shortcut for registering an HTML
    element within a template for a single DOM event and forwarding that
    interaction to the template's controller or specified `target` option.

    If the controller does not implement the specified action, the event is sent
    to the current route, and it bubbles up the route hierarchy from there.

    For more advanced event handling see [Ember.Component](/api/classes/Ember.Component.html)


    ### Use
    Given the following application Handlebars template on the page

    ```handlebars
    <div {{action 'anActionName'}}>
      click me
    </div>
    ```

    And application code

    ```javascript
    App.ApplicationController = Ember.Controller.extend({
      actions: {
        anActionName: function() {
        }
      }
    });
    ```

    Will result in the following rendered HTML

    ```html
    <div class="ember-view">
      <div data-ember-action="1">
        click me
      </div>
    </div>
    ```

    Clicking "click me" will trigger the `anActionName` action of the
    `App.ApplicationController`. In this case, no additional parameters will be passed.

    If you provide additional parameters to the helper:

    ```handlebars
    <button {{action 'edit' post}}>Edit</button>
    ```

    Those parameters will be passed along as arguments to the JavaScript
    function implementing the action.

    ### Event Propagation

    Events triggered through the action helper will automatically have
    `.preventDefault()` called on them. You do not need to do so in your event
    handlers. If you need to allow event propagation (to handle file inputs for
    example) you can supply the `preventDefault=false` option to the `{{action}}` helper:

    ```handlebars
    <div {{action "sayHello" preventDefault=false}}>
      <input type="file" />
      <input type="checkbox" />
    </div>
    ```

    To disable bubbling, pass `bubbles=false` to the helper:

    ```handlebars
    <button {{action 'edit' post bubbles=false}}>Edit</button>
    ```

    If you need the default handler to trigger you should either register your
    own event handler, or use event methods on your view class. See [Ember.View](/api/classes/Ember.View.html)
    'Responding to Browser Events' for more information.

    ### Specifying DOM event type

    By default the `{{action}}` helper registers for DOM `click` events. You can
    supply an `on` option to the helper to specify a different DOM event name:

    ```handlebars
    <div {{action "anActionName" on="doubleClick"}}>
      click me
    </div>
    ```

    See `Ember.View` 'Responding to Browser Events' for a list of
    acceptable DOM event names.

    ### Specifying whitelisted modifier keys

    By default the `{{action}}` helper will ignore click event with pressed modifier
    keys. You can supply an `allowedKeys` option to specify which keys should not be ignored.

    ```handlebars
    <div {{action "anActionName" allowedKeys="alt"}}>
      click me
    </div>
    ```

    This way the `{{action}}` will fire when clicking with the alt key pressed down.

    Alternatively, supply "any" to the `allowedKeys` option to accept any combination of modifier keys.

    ```handlebars
    <div {{action "anActionName" allowedKeys="any"}}>
      click me with any key pressed
    </div>
    ```

    ### Specifying a Target

    There are several possible target objects for `{{action}}` helpers:

    In a typical Ember application, where templates are managed through use of the
    `{{outlet}}` helper, actions will bubble to the current controller, then
    to the current route, and then up the route hierarchy.

    Alternatively, a `target` option can be provided to the helper to change
    which object will receive the method call. This option must be a path
    to an object, accessible in the current context:

    ```handlebars
    {{! the application template }}
    <div {{action "anActionName" target=view}}>
      click me
    </div>
    ```

    ```javascript
    App.ApplicationView = Ember.View.extend({
      actions: {
        anActionName: function() {}
      }
    });

    ```

    ### Additional Parameters

    You may specify additional parameters to the `{{action}}` helper. These
    parameters are passed along as the arguments to the JavaScript function
    implementing the action.

    ```handlebars
    {{#each person in people}}
      <div {{action "edit" person}}>
        click me
      </div>
    {{/each}}
    ```

    Clicking "click me" will trigger the `edit` method on the current controller
    with the value of `person` as a parameter.

    @method action
    @for Ember.Handlebars.helpers
    @param {String} actionName
    @param {Object} [context]*
    @param {Hash} options
  */
  function actionArgs(parameters, actionName) {
    var ret, i, l;

    if (actionName === undefined) {
      ret = new Array(parameters.length);
      for (i = 0, l = parameters.length; i < l; i++) {
        ret[i] = streams__utils.readUnwrappedModel(parameters[i]);
      }
    } else {
      ret = new Array(parameters.length + 1);
      ret[0] = actionName;
      for (i = 0, l = parameters.length; i < l; i++) {
        ret[i + 1] = streams__utils.readUnwrappedModel(parameters[i]);
      }
    }

    return ret;
  }

  var ActionHelper = {};

  // registeredActions is re-exported for compatibility with older plugins
  // that were using this undocumented API.
  ActionHelper.registeredActions = ActionManager['default'].registeredActions;

  var keys = ["alt", "shift", "meta", "ctrl"];

  var POINTER_EVENT_TYPE_REGEX = /^click|mouse|touch/;

  var isAllowedEvent = function (event, allowedKeys) {
    if (typeof allowedKeys === "undefined") {
      if (POINTER_EVENT_TYPE_REGEX.test(event.type)) {
        return system__utils.isSimpleClick(event);
      } else {
        allowedKeys = "";
      }
    }

    if (allowedKeys.indexOf("any") >= 0) {
      return true;
    }

    for (var i = 0, l = keys.length; i < l; i++) {
      if (event[keys[i] + "Key"] && allowedKeys.indexOf(keys[i]) === -1) {
        return false;
      }
    }

    return true;
  };

  ActionHelper.registerAction = function (actionNameOrStream, options, allowedKeys) {
    var actionId = utils.uuid();
    var eventName = options.eventName;
    var parameters = options.parameters;

    ActionManager['default'].registeredActions[actionId] = {
      eventName: eventName,
      handler: function (event) {
        if (!isAllowedEvent(event, allowedKeys)) {
          return true;
        }

        if (options.preventDefault !== false) {
          event.preventDefault();
        }

        if (options.bubbles === false) {
          event.stopPropagation();
        }

        var target = options.target.value();

        var actionName;

        if (ember_metal__streams__utils.isStream(actionNameOrStream)) {
          actionName = actionNameOrStream.value();

                  } else {
          actionName = actionNameOrStream;
        }

        run['default'](function runRegisteredAction() {
          if (target.send) {
            target.send.apply(target, actionArgs(parameters, actionName));
          } else {
                        target[actionName].apply(target, actionArgs(parameters));
          }
        });
      }
    };

    options.view.on("willClearRender", function () {
      delete ActionManager['default'].registeredActions[actionId];
    });

    return actionId;
  };
  function actionHelper(params, hash, options, env) {
    var view = env.data.view;
    var target;
    if (!hash.target) {
      target = view.getStream("controller");
    } else if (ember_metal__streams__utils.isStream(hash.target)) {
      target = hash.target;
    } else {
      target = view.getStream(hash.target);
    }

    // Ember.assert("You specified a quoteless path to the {{action}} helper which did not resolve to an action name (a string). Perhaps you meant to use a quoted actionName? (e.g. {{action 'save'}}).", !params[0].isStream);
    // Ember.deprecate("You specified a quoteless path to the {{action}} helper which did not resolve to an action name (a string). Perhaps you meant to use a quoted actionName? (e.g. {{action 'save'}}).", params[0].isStream);

    var actionOptions = {
      eventName: hash.on || "click",
      parameters: params.slice(1),
      view: view,
      bubbles: hash.bubbles,
      preventDefault: hash.preventDefault,
      target: target,
      withKeyCode: hash.withKeyCode
    };

    var actionId = ActionHelper.registerAction(params[0], actionOptions, hash.allowedKeys);
    env.dom.setAttribute(options.element, "data-ember-action", actionId);
  }

  exports.ActionHelper = ActionHelper;

});
enifed('ember-routing-htmlbars/helpers/link-to', ['exports', 'ember-metal/core', 'ember-routing-views/views/link', 'ember-metal/streams/utils', 'ember-runtime/mixins/controller', 'ember-htmlbars/templates/link-to-escaped', 'ember-htmlbars/templates/link-to-unescaped', 'ember-htmlbars'], function (exports, Ember, link, utils, ControllerMixin, inlineEscapedLinkTo, inlineUnescapedLinkTo) {

  'use strict';

  exports.deprecatedLinkToHelper = deprecatedLinkToHelper;
  exports.linkToHelper = linkToHelper;

  /**
  @module ember
  @submodule ember-routing-htmlbars
  */

  function linkToHelper(params, hash, options, env) {
    var queryParamsObject;
    var view = env.data.view;

    
    var lastParam = params[params.length - 1];

    if (lastParam && lastParam.isQueryParams) {
      hash.queryParamsObject = queryParamsObject = params.pop();
    }

    if (hash.disabledWhen) {
      hash.disabled = hash.disabledWhen;
      delete hash.disabledWhen;
    }

    if (!options.template) {
      var linkTitle = params.shift();
      var parseTextAsHTML = options.morph.parseTextAsHTML;

      if (parseTextAsHTML) {
        hash.layout = inlineUnescapedLinkTo['default'];
      } else {
        hash.layout = inlineEscapedLinkTo['default'];
      }

      hash.linkTitle = linkTitle;
    }

    for (var i = 0; i < params.length; i++) {
      if (utils.isStream(params[i])) {
        var lazyValue = params[i];

        if (!lazyValue._isController) {
          while (ControllerMixin['default'].detect(lazyValue.value())) {
            
            lazyValue = lazyValue.get("model");
          }
        }

        params[i] = lazyValue;
      }
    }

    hash.params = params;

    options.helperName = options.helperName || "link-to";

    return env.helpers.view.helperFunction.call(this, [link.LinkView], hash, options, env);
  }

  /**
    See [link-to](/api/classes/Ember.Handlebars.helpers.html#method_link-to)

    @method linkTo
    @for Ember.Handlebars.helpers
    @deprecated
    @param {String} routeName
    @param {Object} [context]*
    @return {String} HTML string
  */
  function deprecatedLinkToHelper(params, hash, options, env) {
    
    return env.helpers["link-to"].helperFunction.call(this, params, hash, options, env);
  }

});
enifed('ember-routing-htmlbars/helpers/outlet', ['exports', 'ember-metal/core'], function (exports, Ember) {

  'use strict';

  exports.outletHelper = outletHelper;

  // assert

  /**
    The `outlet` helper is a placeholder that the router will fill in with
    the appropriate template based on the current state of the application.

    ``` handlebars
    {{outlet}}
    ```

    By default, a template based on Ember's naming conventions will be rendered
    into the `outlet` (e.g. `App.PostsRoute` will render the `posts` template).

    You can render a different template by using the `render()` method in the
    route's `renderTemplate` hook. The following will render the `favoritePost`
    template into the `outlet`.

    ``` javascript
    App.PostsRoute = Ember.Route.extend({
      renderTemplate: function() {
        this.render('favoritePost');
      }
    });
    ```

    You can create custom named outlets for more control.

    ``` handlebars
    {{outlet 'favoritePost'}}
    {{outlet 'posts'}}
    ```

    Then you can define what template is rendered into each outlet in your
    route.


    ``` javascript
    App.PostsRoute = Ember.Route.extend({
      renderTemplate: function() {
        this.render('favoritePost', { outlet: 'favoritePost' });
        this.render('posts', { outlet: 'posts' });
      }
    });
    ```

    You can specify the view that the outlet uses to contain and manage the
    templates rendered into it.

    ``` handlebars
    {{outlet view='sectionContainer'}}
    ```

    ``` javascript
    App.SectionContainer = Ember.ContainerView.extend({
      tagName: 'section',
      classNames: ['special']
    });
    ```

    @method outlet
    @for Ember.Handlebars.helpers
    @param {String} property the property on the controller
      that holds the view for this outlet
    @return {String} HTML string
  */
  function outletHelper(params, hash, options, env) {
    var viewName;
    var viewClass;
    var viewFullName;
    var view = env.data.view;

    
    var property = params[0] || "main";

    // provide controller override
    viewName = hash.view;

    if (viewName) {
      viewFullName = "view:" + viewName;
                }

    viewClass = viewName ? view.container.lookupFactory(viewFullName) : hash.viewClass || view.container.lookupFactory("view:-outlet");
    hash._outletName = property;
    options.helperName = options.helperName || "outlet";
    return env.helpers.view.helperFunction.call(this, [viewClass], hash, options, env);
  }

});
enifed('ember-routing-htmlbars/helpers/query-params', ['exports', 'ember-metal/core', 'ember-routing/system/query_params'], function (exports, Ember, QueryParams) {

  'use strict';

  exports.queryParamsHelper = queryParamsHelper;

  /**
    This is a sub-expression to be used in conjunction with the link-to helper.
    It will supply url query parameters to the target route.

    Example

    {{#link-to 'posts' (query-params direction="asc")}}Sort{{/link-to}}

    @method query-params
    @for Ember.Handlebars.helpers
    @param {Object} hash takes a hash of query parameters
    @return {String} HTML string
  */
  function queryParamsHelper(params, hash) {
    
    return QueryParams['default'].create({
      values: hash
    });
  }

});
enifed('ember-routing-htmlbars/helpers/render', ['exports', 'ember-metal/core', 'ember-metal/property_get', 'ember-metal/error', 'ember-runtime/system/string', 'ember-routing/system/generate_controller', 'ember-metal/streams/utils', 'ember-htmlbars/system/merge-view-bindings', 'ember-htmlbars/system/append-templated-view', 'ember-metal/platform/create'], function (exports, Ember, property_get, EmberError, string, generateController, utils, mergeViewBindings, appendTemplatedView, create) {

  'use strict';

  exports.renderHelper = renderHelper;

  /**
    Calling ``{{render}}`` from within a template will insert another
    template that matches the provided name. The inserted template will
    access its properties on its own controller (rather than the controller
    of the parent template).

    If a view class with the same name exists, the view class also will be used.

    Note: A given controller may only be used *once* in your app in this manner.
    A singleton instance of the controller will be created for you.

    Example:

    ```javascript
    App.NavigationController = Ember.Controller.extend({
      who: "world"
    });
    ```

    ```handlebars
    <!-- navigation.hbs -->
    Hello, {{who}}.
    ```

    ```handlebars
    <!-- application.hbs -->
    <h1>My great app</h1>
    {{render "navigation"}}
    ```

    ```html
    <h1>My great app</h1>
    <div class='ember-view'>
      Hello, world.
    </div>
    ```

    Optionally you may provide a second argument: a property path
    that will be bound to the `model` property of the controller.

    If a `model` property path is specified, then a new instance of the
    controller will be created and `{{render}}` can be used multiple times
    with the same name.

   For example if you had this `author` template.

   ```handlebars
  <div class="author">
  Written by {{firstName}} {{lastName}}.
  Total Posts: {{postCount}}
  </div>
  ```

  You could render it inside the `post` template using the `render` helper.

  ```handlebars
  <div class="post">
  <h1>{{title}}</h1>
  <div>{{body}}</div>
  {{render "author" author}}
  </div>
   ```

    @method render
    @for Ember.Handlebars.helpers
    @param {String} name
    @param {Object?} context
    @param {Hash} options
    @return {String} HTML string
  */
  function renderHelper(params, hash, options, env) {
    var currentView = env.data.view;
    var container, router, controller, view, initialContext;

    var name = params[0];
    var context = params[1];

    container = currentView._keywords.controller.value().container;
    router = container.lookup("router:main");

    
    
    if (params.length === 1) {
      // use the singleton controller
          } else if (params.length === 2) {
      // create a new controller
      initialContext = context.value();
    } else {
      throw new EmberError['default']("You must pass a templateName to render");
    }

    // # legacy namespace
    name = name.replace(/\//g, ".");
    // \ legacy slash as namespace support

    var templateName = "template:" + name;
    
    var template = options.template;
    view = container.lookup("view:" + name);
    if (!view) {
      view = container.lookup("view:default");
    }
    var viewHasTemplateSpecified = !!property_get.get(view, "template");
    if (!viewHasTemplateSpecified) {
      template = template || container.lookup(templateName);
    }

    // provide controller override
    var controllerName;
    var controllerFullName;

    if (hash.controller) {
      controllerName = hash.controller;
      controllerFullName = "controller:" + controllerName;
      delete hash.controller;

          } else {
      controllerName = name;
      controllerFullName = "controller:" + controllerName;
    }

    var parentController = currentView._keywords.controller.value();

    // choose name
    if (params.length > 1) {
      var factory = container.lookupFactory(controllerFullName) || generateController.generateControllerFactory(container, controllerName, initialContext);

      controller = factory.create({
        modelBinding: context, // TODO: Use a StreamBinding
        parentController: parentController,
        target: parentController
      });

      view.one("willDestroyElement", function () {
        controller.destroy();
      });
    } else {
      controller = container.lookup(controllerFullName) || generateController['default'](container, controllerName);

      controller.setProperties({
        target: parentController,
        parentController: parentController
      });
    }

    hash.viewName = string.camelize(name);

    if (router && !initialContext) {
      router._connectActiveView(name, view);
    }

    var props = {
      template: template,
      controller: controller,
      helperName: "render \"" + name + "\""
    };

    impersonateAnOutlet(currentView, view, name);
    mergeViewBindings['default'](currentView, props, hash);
    appendTemplatedView['default'](currentView, options.morph, view, props);
  }

  // Megahax to make outlets inside the render helper work, until we
  // can kill that behavior at 2.0.
  function impersonateAnOutlet(currentView, view, name) {
    view._childOutlets = Ember['default'].A();
    view._isOutlet = true;
    view._outletName = "__ember_orphans__";
    view._matchOutletName = name;
    view._parentOutlet = function () {
      var parent = this._parentView;
      while (parent && !parent._isOutlet) {
        parent = parent._parentView;
      }
      return parent;
    };
    view.setOutletState = function (state) {
      var ownState;
      if (state && (ownState = state.outlets[this._matchOutletName])) {
        this._outletState = {
          render: { name: "render helper stub" },
          outlets: create['default'](null)
        };
        this._outletState.outlets[ownState.render.outlet] = ownState;
        ownState.wasUsed = true;
      } else {
        this._outletState = null;
      }
      for (var i = 0; i < this._childOutlets.length; i++) {
        var child = this._childOutlets[i];
        child.setOutletState(this._outletState && this._outletState.outlets[child._outletName]);
      }
    };

    var pointer = currentView;
    var po;
    while (pointer && !pointer._isOutlet) {
      pointer = pointer._parentView;
    }
    while (pointer && (po = pointer._parentOutlet())) {
      pointer = po;
    }
    if (pointer) {
      // we've found the toplevel outlet. Subscribe to its
      // __ember_orphan__ child outlet, which is our hack convention for
      // stashing outlet state that may target the render helper.
      pointer._childOutlets.push(view);
      if (pointer._outletState) {
        view.setOutletState(pointer._outletState.outlets[view._outletName]);
      }
    }
  }

});
enifed('ember-routing-views', ['exports', 'ember-metal/core', 'ember-routing-views/views/link', 'ember-routing-views/views/outlet'], function (exports, Ember, link, outlet) {

  'use strict';

  /**
  Ember Routing Views

  @module ember
  @submodule ember-routing-views
  @requires ember-routing
  */

  Ember['default'].LinkView = link.LinkView;
  Ember['default'].OutletView = outlet.OutletView;
  
  exports['default'] = Ember['default'];

});
enifed('ember-routing-views/views/link', ['exports', 'ember-metal/core', 'ember-metal/property_get', 'ember-metal/merge', 'ember-metal/run_loop', 'ember-metal/computed', 'ember-runtime/system/string', 'ember-metal/keys', 'ember-views/system/utils', 'ember-views/views/component', 'ember-routing/utils', 'ember-metal/streams/utils'], function (exports, Ember, property_get, merge, run, computed, string, keys, utils, EmberComponent, ember_routing__utils, streams__utils) {

  'use strict';

  /**
  @module ember
  @submodule ember-routing-views
  */

  var numberOfContextsAcceptedByHandler = function (handler, handlerInfos) {
    var req = 0;
    for (var i = 0, l = handlerInfos.length; i < l; i++) {
      req = req + handlerInfos[i].names.length;
      if (handlerInfos[i].handler === handler) {
        break;
      }
    }

    return req;
  };

  var linkViewClassNameBindings = ["active", "loading", "disabled"];
  
    linkViewClassNameBindings = ["active", "loading", "disabled", "transitioningIn", "transitioningOut"];
  

  /**
    `Ember.LinkView` renders an element whose `click` event triggers a
    transition of the application's instance of `Ember.Router` to
    a supplied route by name.

    Instances of `LinkView` will most likely be created through
    the `link-to` Handlebars helper, but properties of this class
    can be overridden to customize application-wide behavior.

    @class LinkView
    @namespace Ember
    @extends Ember.View
    @see {Handlebars.helpers.link-to}
  **/
  var LinkView = EmberComponent['default'].extend({
    tagName: "a",

    /**
      @deprecated Use current-when instead.
      @property currentWhen
    */
    currentWhen: null,

    /**
      Used to determine when this LinkView is active.
       @property currentWhen
    */
    "current-when": null,

    /**
      Sets the `title` attribute of the `LinkView`'s HTML element.
       @property title
      @default null
    **/
    title: null,

    /**
      Sets the `rel` attribute of the `LinkView`'s HTML element.
       @property rel
      @default null
    **/
    rel: null,

    /**
      Sets the `tabindex` attribute of the `LinkView`'s HTML element.
       @property tabindex
      @default null
    **/
    tabindex: null,

    /**
      Sets the `target` attribute of the `LinkView`'s HTML element.
       @since 1.8.0
      @property target
      @default null
    **/
    target: null,

    /**
      The CSS class to apply to `LinkView`'s element when its `active`
      property is `true`.
       @property activeClass
      @type String
      @default active
    **/
    activeClass: "active",

    /**
      The CSS class to apply to `LinkView`'s element when its `loading`
      property is `true`.
       @property loadingClass
      @type String
      @default loading
    **/
    loadingClass: "loading",

    /**
      The CSS class to apply to a `LinkView`'s element when its `disabled`
      property is `true`.
       @property disabledClass
      @type String
      @default disabled
    **/
    disabledClass: "disabled",
    _isDisabled: false,

    /**
      Determines whether the `LinkView` will trigger routing via
      the `replaceWith` routing strategy.
       @property replace
      @type Boolean
      @default false
    **/
    replace: false,

    /**
      By default the `{{link-to}}` helper will bind to the `href` and
      `title` attributes. It's discouraged that you override these defaults,
      however you can push onto the array if needed.
       @property attributeBindings
      @type Array | String
      @default ['href', 'title', 'rel', 'tabindex', 'target']
     **/
    attributeBindings: ["href", "title", "rel", "tabindex", "target"],

    /**
      By default the `{{link-to}}` helper will bind to the `active`, `loading`, and
      `disabled` classes. It is discouraged to override these directly.
       @property classNameBindings
      @type Array
      @default ['active', 'loading', 'disabled']
     **/
    classNameBindings: linkViewClassNameBindings,

    /**
      By default the `{{link-to}}` helper responds to the `click` event. You
      can override this globally by setting this property to your custom
      event name.
       This is particularly useful on mobile when one wants to avoid the 300ms
      click delay using some sort of custom `tap` event.
       @property eventName
      @type String
      @default click
    */
    eventName: "click",

    // this is doc'ed here so it shows up in the events
    // section of the API documentation, which is where
    // people will likely go looking for it.
    /**
      Triggers the `LinkView`'s routing behavior. If
      `eventName` is changed to a value other than `click`
      the routing behavior will trigger on that custom event
      instead.
       @event click
    **/

    /**
      An overridable method called when LinkView objects are instantiated.
       Example:
       ```javascript
      App.MyLinkView = Ember.LinkView.extend({
        init: function() {
          this._super.apply(this, arguments);
          Ember.Logger.log('Event is ' + this.get('eventName'));
        }
      });
      ```
       NOTE: If you do override `init` for a framework class like `Ember.View` or
      `Ember.ArrayController`, be sure to call `this._super.apply(this, arguments)` in your
      `init` declaration! If you don't, Ember may not have an opportunity to
      do important setup work, and you'll see strange behavior in your
      application.
       @method init
    */
    init: function () {
      this._super.apply(this, arguments);

      
      // Map desired event name to invoke function
      var eventName = property_get.get(this, "eventName");
      this.on(eventName, this, this._invoke);
    },

    /**
      This method is invoked by observers installed during `init` that fire
      whenever the params change
       @private
      @method _paramsChanged
      @since 1.3.0
     */
    _paramsChanged: function () {
      this.notifyPropertyChange("resolvedParams");
    },

    /**
     This is called to setup observers that will trigger a rerender.
      @private
     @method _setupPathObservers
     @since 1.3.0
    **/
    _setupPathObservers: function () {
      var params = this.params;

      var scheduledParamsChanged = this._wrapAsScheduled(this._paramsChanged);

      for (var i = 0; i < params.length; i++) {
        streams__utils.subscribe(params[i], scheduledParamsChanged, this);
      }

      var queryParamsObject = this.queryParamsObject;
      if (queryParamsObject) {
        var values = queryParamsObject.values;
        for (var k in values) {
          if (!values.hasOwnProperty(k)) {
            continue;
          }

          streams__utils.subscribe(values[k], scheduledParamsChanged, this);
        }
      }
    },

    afterRender: function () {
      this._super.apply(this, arguments);
      this._setupPathObservers();
    },

    /**
       Accessed as a classname binding to apply the `LinkView`'s `disabledClass`
      CSS `class` to the element when the link is disabled.
       When `true` interactions with the element will not trigger route changes.
      @property disabled
    */
    disabled: computed.computed({
      get: function (key, value) {
        return false;
      },
      set: function (key, value) {
        if (value !== undefined) {
          this.set("_isDisabled", value);
        }

        return value ? property_get.get(this, "disabledClass") : false;
      }
    }),

    /**
      Accessed as a classname binding to apply the `LinkView`'s `activeClass`
      CSS `class` to the element when the link is active.
       A `LinkView` is considered active when its `currentWhen` property is `true`
      or the application's current route is the route the `LinkView` would trigger
      transitions into.
       The `currentWhen` property can match against multiple routes by separating
      route names using the ` ` (space) character.
       @property active
    **/
    active: computed.computed("loadedParams", function computeLinkViewActive() {
      var router = property_get.get(this, "router");
      if (!router) {
        return;
      }
      return computeActive(this, router.currentState);
    }),

    willBeActive: computed.computed("router.targetState", function () {
      var router = property_get.get(this, "router");
      if (!router) {
        return;
      }
      var targetState = router.targetState;
      if (router.currentState === targetState) {
        return;
      }

      return !!computeActive(this, targetState);
    }),

    transitioningIn: computed.computed("active", "willBeActive", function () {
      var willBeActive = property_get.get(this, "willBeActive");
      if (typeof willBeActive === "undefined") {
        return false;
      }

      return !property_get.get(this, "active") && willBeActive && "ember-transitioning-in";
    }),

    transitioningOut: computed.computed("active", "willBeActive", function () {
      var willBeActive = property_get.get(this, "willBeActive");
      if (typeof willBeActive === "undefined") {
        return false;
      }

      return property_get.get(this, "active") && !willBeActive && "ember-transitioning-out";
    }),

    /**
      Accessed as a classname binding to apply the `LinkView`'s `loadingClass`
      CSS `class` to the element when the link is loading.
       A `LinkView` is considered loading when it has at least one
      parameter whose value is currently null or undefined. During
      this time, clicking the link will perform no transition and
      emit a warning that the link is still in a loading state.
       @property loading
    **/
    loading: computed.computed("loadedParams", function computeLinkViewLoading() {
      if (!property_get.get(this, "loadedParams")) {
        return property_get.get(this, "loadingClass");
      }
    }),

    /**
      Returns the application's main router from the container.
       @private
      @property router
    **/
    router: computed.computed(function () {
      var controller = property_get.get(this, "controller");
      if (controller && controller.container) {
        return controller.container.lookup("router:main");
      }
    }),

    /**
      Event handler that invokes the link, activating the associated route.
       @private
      @method _invoke
      @param {Event} event
    */
    _invoke: function (event) {
      if (!utils.isSimpleClick(event)) {
        return true;
      }

      if (this.preventDefault !== false) {
        var targetAttribute = property_get.get(this, "target");
        if (!targetAttribute || targetAttribute === "_self") {
          event.preventDefault();
        }
      }

      if (this.bubbles === false) {
        event.stopPropagation();
      }

      if (property_get.get(this, "_isDisabled")) {
        return false;
      }

      if (property_get.get(this, "loading")) {
        Ember['default'].Logger.warn("This link-to is in an inactive loading state because at least one of its parameters presently has a null/undefined value, or the provided route name is invalid.");
        return false;
      }

      var targetAttribute2 = property_get.get(this, "target");
      if (targetAttribute2 && targetAttribute2 !== "_self") {
        return false;
      }

      var router = property_get.get(this, "router");
      var loadedParams = property_get.get(this, "loadedParams");

      var transition = router._doTransition(loadedParams.targetRouteName, loadedParams.models, loadedParams.queryParams);
      if (property_get.get(this, "replace")) {
        transition.method("replace");
      }

      
        return;
      

      // Schedule eager URL update, but after we've given the transition
      // a chance to synchronously redirect.
      // We need to always generate the URL instead of using the href because
      // the href will include any rootURL set, but the router expects a URL
      // without it! Note that we don't use the first level router because it
      // calls location.formatURL(), which also would add the rootURL!
      var args = ember_routing__utils.routeArgs(loadedParams.targetRouteName, loadedParams.models, transition.state.queryParams);
      var url = router.router.generate.apply(router.router, args);

      run['default'].scheduleOnce("routerTransitions", this, this._eagerUpdateUrl, transition, url);
    },

    /**
      @private
      @method _eagerUpdateUrl
      @param transition
      @param href
     */
    _eagerUpdateUrl: function (transition, href) {
      if (!transition.isActive || !transition.urlMethod) {
        // transition was aborted, already ran to completion,
        // or it has a null url-updated method.
        return;
      }

      if (href.indexOf("#") === 0) {
        href = href.slice(1);
      }

      // Re-use the routerjs hooks set up by the Ember router.
      var routerjs = property_get.get(this, "router.router");
      if (transition.urlMethod === "update") {
        routerjs.updateURL(href);
      } else if (transition.urlMethod === "replace") {
        routerjs.replaceURL(href);
      }

      // Prevent later update url refire.
      transition.method(null);
    },

    /**
      Computed property that returns an array of the
      resolved parameters passed to the `link-to` helper,
      e.g.:
       ```hbs
      {{link-to a b '123' c}}
      ```
       will generate a `resolvedParams` of:
       ```js
      [aObject, bObject, '123', cObject]
      ```
       @private
      @property
      @return {Array}
     */
    resolvedParams: computed.computed("router.url", function () {
      var params = this.params;
      var targetRouteName;
      var models = [];
      var onlyQueryParamsSupplied = params.length === 0;

      if (onlyQueryParamsSupplied) {
        var appController = this.container.lookup("controller:application");
        targetRouteName = property_get.get(appController, "currentRouteName");
      } else {
        targetRouteName = streams__utils.read(params[0]);

        for (var i = 1; i < params.length; i++) {
          models.push(streams__utils.read(params[i]));
        }
      }

      var suppliedQueryParams = getResolvedQueryParams(this, targetRouteName);

      return {
        targetRouteName: targetRouteName,
        models: models,
        queryParams: suppliedQueryParams
      };
    }),

    /**
      Computed property that returns the current route name,
      dynamic segments, and query params. Returns falsy if
      for null/undefined params to indicate that the link view
      is still in a loading state.
       @private
      @property
      @return {Array} An array with the route name and any dynamic segments
    **/
    loadedParams: computed.computed("resolvedParams", function computeLinkViewRouteArgs() {
      var router = property_get.get(this, "router");
      if (!router) {
        return;
      }

      var resolvedParams = property_get.get(this, "resolvedParams");
      var namedRoute = resolvedParams.targetRouteName;

      if (!namedRoute) {
        return;
      }

      
      if (!paramsAreLoaded(resolvedParams.models)) {
        return;
      }

      return resolvedParams;
    }),

    queryParamsObject: null,

    /**
      Sets the element's `href` attribute to the url for
      the `LinkView`'s targeted route.
       If the `LinkView`'s `tagName` is changed to a value other
      than `a`, this property will be ignored.
       @property href
    **/
    href: computed.computed("loadedParams", function computeLinkViewHref() {
      if (property_get.get(this, "tagName") !== "a") {
        return;
      }

      var router = property_get.get(this, "router");
      var loadedParams = property_get.get(this, "loadedParams");

      if (!loadedParams) {
        return property_get.get(this, "loadingHref");
      }

      var visibleQueryParams = {};
      merge['default'](visibleQueryParams, loadedParams.queryParams);
      router._prepareQueryParams(loadedParams.targetRouteName, loadedParams.models, visibleQueryParams);

      var args = ember_routing__utils.routeArgs(loadedParams.targetRouteName, loadedParams.models, visibleQueryParams);
      var result = router.generate.apply(router, args);
      return result;
    }),

    /**
      The default href value to use while a link-to is loading.
      Only applies when tagName is 'a'
       @property loadingHref
      @type String
      @default #
    */
    loadingHref: "#"
  });

  LinkView.toString = function () {
    return "LinkView";
  };

  function getResolvedQueryParams(linkView, targetRouteName) {
    var queryParamsObject = linkView.queryParamsObject;
    var resolvedQueryParams = {};

    if (!queryParamsObject) {
      return resolvedQueryParams;
    }

    var values = queryParamsObject.values;
    for (var key in values) {
      if (!values.hasOwnProperty(key)) {
        continue;
      }
      resolvedQueryParams[key] = streams__utils.read(values[key]);
    }

    return resolvedQueryParams;
  }

  function paramsAreLoaded(params) {
    for (var i = 0, len = params.length; i < len; ++i) {
      var param = params[i];
      if (param === null || typeof param === "undefined") {
        return false;
      }
    }
    return true;
  }

  function computeActive(route, routerState) {
    if (property_get.get(route, "loading")) {
      return false;
    }

    var currentWhen = route["current-when"] || route.currentWhen;
    var isCurrentWhenSpecified = !!currentWhen;
    currentWhen = currentWhen || property_get.get(route, "loadedParams").targetRouteName;
    currentWhen = currentWhen.split(" ");
    for (var i = 0, len = currentWhen.length; i < len; i++) {
      if (isActiveForRoute(route, currentWhen[i], isCurrentWhenSpecified, routerState)) {
        return property_get.get(route, "activeClass");
      }
    }

    return false;
  }

  function isActiveForRoute(route, routeName, isCurrentWhenSpecified, routerState) {
    var router = property_get.get(route, "router");
    var loadedParams = property_get.get(route, "loadedParams");
    var contexts = loadedParams.models;

    var handlers = router.router.recognizer.handlersFor(routeName);
    var leafName = handlers[handlers.length - 1].handler;
    var maximumContexts = numberOfContextsAcceptedByHandler(routeName, handlers);

    // NOTE: any ugliness in the calculation of activeness is largely
    // due to the fact that we support automatic normalizing of
    // `resource` -> `resource.index`, even though there might be
    // dynamic segments / query params defined on `resource.index`
    // which complicates (and makes somewhat ambiguous) the calculation
    // of activeness for links that link to `resource` instead of
    // directly to `resource.index`.

    // if we don't have enough contexts revert back to full route name
    // this is because the leaf route will use one of the contexts
    if (contexts.length > maximumContexts) {
      routeName = leafName;
    }

    return routerState.isActiveIntent(routeName, contexts, loadedParams.queryParams, !isCurrentWhenSpecified);
  }

  exports.LinkView = LinkView;

});
enifed('ember-routing-views/views/outlet', ['exports', 'ember-views/views/container_view', 'ember-views/views/metamorph_view', 'ember-metal/property_get'], function (exports, ContainerView, metamorph_view, property_get) {

  'use strict';

  /**
  @module ember
  @submodule ember-routing-views
  */

  var CoreOutletView = ContainerView['default'].extend({
    init: function () {
      this._super();
      this._childOutlets = Ember.A();
      this._outletState = null;
    },

    _isOutlet: true,

    _parentOutlet: function () {
      var parent = this._parentView;
      while (parent && !parent._isOutlet) {
        parent = parent._parentView;
      }
      return parent;
    },

    _linkParent: Ember.on("init", "parentViewDidChange", function () {
      var parent = this._parentOutlet();
      if (parent) {
        parent._childOutlets.push(this);
        if (parent._outletState) {
          this.setOutletState(parent._outletState.outlets[this._outletName]);
        }
      }
    }),

    willDestroy: function () {
      var parent = this._parentOutlet();
      if (parent) {
        parent._childOutlets.removeObject(this);
      }
      this._super();
    },

    _diffState: function (state) {
      while (state && emptyRouteState(state)) {
        state = state.outlets.main;
      }
      var different = !sameRouteState(this._outletState, state);
      this._outletState = state;
      return different;
    },

    setOutletState: function (state) {
      if (!this._diffState(state)) {
        var children = this._childOutlets;
        for (var i = 0; i < children.length; i++) {
          var child = children[i];
          child.setOutletState(this._outletState && this._outletState.outlets[child._outletName]);
        }
      } else {
        var view = this._buildView(this._outletState);
        var length = property_get.get(this, "length");
        if (view) {
          this.replace(0, length, [view]);
        } else {
          this.replace(0, length, []);
        }
      }
    },

    _buildView: function (state) {
      if (!state) {
        return;
      }

      var LOG_VIEW_LOOKUPS = property_get.get(this, "namespace.LOG_VIEW_LOOKUPS");
      var view;
      var render = state.render;
      var ViewClass = render.ViewClass;
      var isDefaultView = false;

      if (!ViewClass) {
        isDefaultView = true;
        ViewClass = this.container.lookupFactory(this._isTopLevel ? "view:toplevel" : "view:default");
      }

      view = ViewClass.create({
        _debugTemplateName: render.name,
        renderedName: render.name,
        controller: render.controller
      });

      if (!property_get.get(view, "template")) {
        view.set("template", render.template);
      }

      if (LOG_VIEW_LOOKUPS) {
              }

      return view;
    }
  });

  function emptyRouteState(state) {
    return !state.render.ViewClass && !state.render.template;
  }

  function sameRouteState(a, b) {
    if (!a && !b) {
      return true;
    }
    if (!a || !b) {
      return false;
    }
    a = a.render;
    b = b.render;
    for (var key in a) {
      if (a.hasOwnProperty(key)) {
        // name is only here for logging & debugging. If two different
        // names result in otherwise identical states, they're still
        // identical.
        if (a[key] !== b[key] && key !== "name") {
          return false;
        }
      }
    }
    return true;
  }

  var OutletView = CoreOutletView.extend(metamorph_view._Metamorph);

  exports.CoreOutletView = CoreOutletView;
  exports.OutletView = OutletView;

});
enifed('ember-routing', ['exports', 'ember-metal/core', 'ember-routing/ext/run_loop', 'ember-routing/ext/controller', 'ember-routing/location/api', 'ember-routing/location/none_location', 'ember-routing/location/hash_location', 'ember-routing/location/history_location', 'ember-routing/location/auto_location', 'ember-routing/system/generate_controller', 'ember-routing/system/controller_for', 'ember-routing/system/dsl', 'ember-routing/system/router', 'ember-routing/system/route'], function (exports, Ember, __dep1__, __dep2__, EmberLocation, NoneLocation, HashLocation, HistoryLocation, AutoLocation, generateController, controllerFor, RouterDSL, Router, Route) {

	'use strict';

	/**
	Ember Routing

	@module ember
	@submodule ember-routing
	@requires ember-views
	*/

	Ember['default'].Location = EmberLocation['default'];
	Ember['default'].AutoLocation = AutoLocation['default'];
	Ember['default'].HashLocation = HashLocation['default'];
	Ember['default'].HistoryLocation = HistoryLocation['default'];
	Ember['default'].NoneLocation = NoneLocation['default'];

	Ember['default'].controllerFor = controllerFor['default'];
	Ember['default'].generateControllerFactory = generateController.generateControllerFactory;
	Ember['default'].generateController = generateController['default'];
	Ember['default'].RouterDSL = RouterDSL['default'];
	Ember['default'].Router = Router['default'];
	Ember['default'].Route = Route['default'];

	exports['default'] = Ember['default'];

});
enifed('ember-routing/ext/controller', ['exports', 'ember-metal/core', 'ember-metal/property_get', 'ember-metal/property_set', 'ember-metal/computed', 'ember-metal/utils', 'ember-metal/merge', 'ember-runtime/mixins/controller'], function (exports, Ember, property_get, property_set, computed, utils, merge, ControllerMixin) {

  'use strict';

  ControllerMixin['default'].reopen({
    concatenatedProperties: ["queryParams", "_pCacheMeta"],

    init: function () {
      this._super.apply(this, arguments);
      listenForQueryParamChanges(this);
    },

    /**
      Defines which query parameters the controller accepts.
      If you give the names ['category','page'] it will bind
      the values of these query parameters to the variables
      `this.category` and `this.page`
       @property queryParams
      @public
    */
    queryParams: null,

    /**
      @property _qpDelegate
      @private
    */
    _qpDelegate: null,

    /**
      @property _normalizedQueryParams
      @private
    */
    _normalizedQueryParams: computed.computed(function () {
      var m = utils.meta(this);
      if (m.proto !== this) {
        return property_get.get(m.proto, "_normalizedQueryParams");
      }

      var queryParams = property_get.get(this, "queryParams");
      if (queryParams._qpMap) {
        return queryParams._qpMap;
      }

      var qpMap = queryParams._qpMap = {};

      for (var i = 0, len = queryParams.length; i < len; ++i) {
        accumulateQueryParamDescriptors(queryParams[i], qpMap);
      }

      return qpMap;
    }),

    /**
      @property _cacheMeta
      @private
    */
    _cacheMeta: computed.computed(function () {
      var m = utils.meta(this);
      if (m.proto !== this) {
        return property_get.get(m.proto, "_cacheMeta");
      }

      var cacheMeta = {};
      var qpMap = property_get.get(this, "_normalizedQueryParams");
      for (var prop in qpMap) {
        if (!qpMap.hasOwnProperty(prop)) {
          continue;
        }

        var qp = qpMap[prop];
        var scope = qp.scope;
        var parts;

        if (scope === "controller") {
          parts = [];
        }

        cacheMeta[prop] = {
          parts: parts, // provided by route if 'model' scope
          values: null, // provided by route
          scope: scope,
          prefix: "",
          def: property_get.get(this, prop)
        };
      }

      return cacheMeta;
    }),

    /**
      @method _updateCacheParams
      @private
    */
    _updateCacheParams: function (params) {
      var cacheMeta = property_get.get(this, "_cacheMeta");
      for (var prop in cacheMeta) {
        if (!cacheMeta.hasOwnProperty(prop)) {
          continue;
        }
        var propMeta = cacheMeta[prop];
        propMeta.values = params;

        var cacheKey = this._calculateCacheKey(propMeta.prefix, propMeta.parts, propMeta.values);
        var cache = this._bucketCache;

        if (cache) {
          var value = cache.lookup(cacheKey, prop, propMeta.def);
          property_set.set(this, prop, value);
        }
      }
    },

    /**
      @method _qpChanged
      @private
    */
    _qpChanged: function (controller, _prop) {
      var prop = _prop.substr(0, _prop.length - 3);
      var cacheMeta = property_get.get(controller, "_cacheMeta");
      var propCache = cacheMeta[prop];
      var cacheKey = controller._calculateCacheKey(propCache.prefix || "", propCache.parts, propCache.values);
      var value = property_get.get(controller, prop);

      // 1. Update model-dep cache
      var cache = this._bucketCache;
      if (cache) {
        controller._bucketCache.stash(cacheKey, prop, value);
      }

      // 2. Notify a delegate (e.g. to fire a qp transition)
      var delegate = controller._qpDelegate;
      if (delegate) {
        delegate(controller, prop);
      }
    },

    /**
      @method _calculateCacheKey
      @private
    */
    _calculateCacheKey: function (prefix, _parts, values) {
      var parts = _parts || [];
      var suffixes = "";
      for (var i = 0, len = parts.length; i < len; ++i) {
        var part = parts[i];
        var value = property_get.get(values, part);
        suffixes += "::" + part + ":" + value;
      }
      return prefix + suffixes.replace(ALL_PERIODS_REGEX, "-");
    },

    /**
      Transition the application into another route. The route may
      be either a single route or route path:
       ```javascript
      aController.transitionToRoute('blogPosts');
      aController.transitionToRoute('blogPosts.recentEntries');
      ```
       Optionally supply a model for the route in question. The model
      will be serialized into the URL using the `serialize` hook of
      the route:
       ```javascript
      aController.transitionToRoute('blogPost', aPost);
      ```
       If a literal is passed (such as a number or a string), it will
      be treated as an identifier instead. In this case, the `model`
      hook of the route will be triggered:
       ```javascript
      aController.transitionToRoute('blogPost', 1);
      ```
       Multiple models will be applied last to first recursively up the
      resource tree.
       ```javascript
      App.Router.map(function() {
        this.resource('blogPost', {path:':blogPostId'}, function() {
          this.resource('blogComment', {path: ':blogCommentId'});
        });
      });
       aController.transitionToRoute('blogComment', aPost, aComment);
      aController.transitionToRoute('blogComment', 1, 13);
      ```
       It is also possible to pass a URL (a string that starts with a
      `/`). This is intended for testing and debugging purposes and
      should rarely be used in production code.
       ```javascript
      aController.transitionToRoute('/');
      aController.transitionToRoute('/blog/post/1/comment/13');
      aController.transitionToRoute('/blog/posts?sort=title');
      ```
       An options hash with a `queryParams` property may be provided as
      the final argument to add query parameters to the destination URL.
       ```javascript
      aController.transitionToRoute('blogPost', 1, {
        queryParams: {showComments: 'true'}
      });
       // if you just want to transition the query parameters without changing the route
      aController.transitionToRoute({queryParams: {sort: 'date'}});
      ```
       See also [replaceRoute](/api/classes/Ember.ControllerMixin.html#method_replaceRoute).
       @param {String} name the name of the route or a URL
      @param {...Object} models the model(s) or identifier(s) to be used
        while transitioning to the route.
      @param {Object} [options] optional hash with a queryParams property
        containing a mapping of query parameters
      @for Ember.ControllerMixin
      @method transitionToRoute
    */
    transitionToRoute: function () {
      // target may be either another controller or a router
      var target = property_get.get(this, "target");
      var method = target.transitionToRoute || target.transitionTo;
      return method.apply(target, arguments);
    },

    /**
      @deprecated
      @for Ember.ControllerMixin
      @method transitionTo
    */
    transitionTo: function () {
            return this.transitionToRoute.apply(this, arguments);
    },

    /**
      Transition into another route while replacing the current URL, if possible.
      This will replace the current history entry instead of adding a new one.
      Beside that, it is identical to `transitionToRoute` in all other respects.
       ```javascript
      aController.replaceRoute('blogPosts');
      aController.replaceRoute('blogPosts.recentEntries');
      ```
       Optionally supply a model for the route in question. The model
      will be serialized into the URL using the `serialize` hook of
      the route:
       ```javascript
      aController.replaceRoute('blogPost', aPost);
      ```
       If a literal is passed (such as a number or a string), it will
      be treated as an identifier instead. In this case, the `model`
      hook of the route will be triggered:
       ```javascript
      aController.replaceRoute('blogPost', 1);
      ```
       Multiple models will be applied last to first recursively up the
      resource tree.
       ```javascript
      App.Router.map(function() {
        this.resource('blogPost', {path:':blogPostId'}, function() {
          this.resource('blogComment', {path: ':blogCommentId'});
        });
      });
       aController.replaceRoute('blogComment', aPost, aComment);
      aController.replaceRoute('blogComment', 1, 13);
      ```
       It is also possible to pass a URL (a string that starts with a
      `/`). This is intended for testing and debugging purposes and
      should rarely be used in production code.
       ```javascript
      aController.replaceRoute('/');
      aController.replaceRoute('/blog/post/1/comment/13');
      ```
       @param {String} name the name of the route or a URL
      @param {...Object} models the model(s) or identifier(s) to be used
      while transitioning to the route.
      @for Ember.ControllerMixin
      @method replaceRoute
    */
    replaceRoute: function () {
      // target may be either another controller or a router
      var target = property_get.get(this, "target");
      var method = target.replaceRoute || target.replaceWith;
      return method.apply(target, arguments);
    },

    /**
      @deprecated
      @for Ember.ControllerMixin
      @method replaceWith
    */
    replaceWith: function () {
            return this.replaceRoute.apply(this, arguments);
    }
  });

  var ALL_PERIODS_REGEX = /\./g;

  function accumulateQueryParamDescriptors(_desc, accum) {
    var desc = _desc;
    var tmp;
    if (utils.typeOf(desc) === "string") {
      tmp = {};
      tmp[desc] = { as: null };
      desc = tmp;
    }

    for (var key in desc) {
      if (!desc.hasOwnProperty(key)) {
        return;
      }

      var singleDesc = desc[key];
      if (utils.typeOf(singleDesc) === "string") {
        singleDesc = { as: singleDesc };
      }

      tmp = accum[key] || { as: null, scope: "model" };
      merge['default'](tmp, singleDesc);

      accum[key] = tmp;
    }
  }

  function listenForQueryParamChanges(controller) {
    var qpMap = property_get.get(controller, "_normalizedQueryParams");
    for (var prop in qpMap) {
      if (!qpMap.hasOwnProperty(prop)) {
        continue;
      }
      controller.addObserver(prop + ".[]", controller, controller._qpChanged);
    }
  }

  exports['default'] = ControllerMixin['default'];

});
enifed('ember-routing/ext/run_loop', ['ember-metal/run_loop'], function (run) {

	'use strict';

	run['default']._addQueue('routerTransitions', 'actions');

});
enifed('ember-routing/location/api', ['exports', 'ember-metal/core', 'ember-metal/environment', 'ember-routing/location/util'], function (exports, Ember, environment, util) {

  'use strict';

  exports['default'] = {
    /**
     This is deprecated in favor of using the container to lookup the location
     implementation as desired.
      For example:
      ```javascript
     // Given a location registered as follows:
     container.register('location:history-test', HistoryTestLocation);
      // You could create a new instance via:
     container.lookup('location:history-test');
     ```
       @method create
      @param {Object} options
      @return {Object} an instance of an implementation of the `location` API
      @deprecated Use the container to lookup the location implementation that you
      need.
    */
    create: function (options) {
      var implementation = options && options.implementation;
      
      var implementationClass = this.implementations[implementation];
      
      return implementationClass.create.apply(implementationClass, arguments);
    },

    /**
     This is deprecated in favor of using the container to register the
     location implementation as desired.
      Example:
      ```javascript
     Application.initializer({
      name: "history-test-location",
       initialize: function(container, application) {
        application.register('location:history-test', HistoryTestLocation);
      }
     });
     ```
      @method registerImplementation
     @param {String} name
     @param {Object} implementation of the `location` API
     @deprecated Register your custom location implementation with the
     container directly.
    */
    registerImplementation: function (name, implementation) {
      
      this.implementations[name] = implementation;
    },

    implementations: {},
    _location: environment['default'].location,

    /**
      Returns the current `location.hash` by parsing location.href since browsers
      inconsistently URL-decode `location.hash`.
       https://bugzilla.mozilla.org/show_bug.cgi?id=483304
       @private
      @method getHash
      @since 1.4.0
    */
    _getHash: function () {
      return util.getHash(this.location);
    }
  };

});
enifed('ember-routing/location/auto_location', ['exports', 'ember-metal/core', 'ember-metal/property_get', 'ember-metal/property_set', 'ember-metal/utils', 'ember-runtime/system/object', 'ember-metal/environment', 'ember-routing/location/util'], function (exports, Ember, property_get, property_set, utils, EmberObject, environment, util) {

  'use strict';

  exports.getHistoryPath = getHistoryPath;
  exports.getHashPath = getHashPath;

  /**
    @private

    Returns the current path as it should appear for HistoryLocation supported
    browsers. This may very well differ from the real current path (e.g. if it
    starts off as a hashed URL)
  */
  exports['default'] = EmberObject['default'].extend({
    /**
      @private
       The browser's `location` object. This is typically equivalent to
      `window.location`, but may be overridden for testing.
       @property location
      @default environment.location
    */
    location: environment['default'].location,

    /**
      @private
       The browser's `history` object. This is typically equivalent to
      `window.history`, but may be overridden for testing.
       @since 1.5.1
      @property history
      @default environment.history
    */
    history: environment['default'].history,

    /**
     @private
      The user agent's global variable. In browsers, this will be `window`.
      @since 1.11
     @property global
     @default environment.global
    */
    global: environment['default'].global,

    /**
      @private
       The browser's `userAgent`. This is typically equivalent to
      `navigator.userAgent`, but may be overridden for testing.
       @since 1.5.1
      @property userAgent
      @default environment.history
    */
    userAgent: environment['default'].userAgent,

    /**
      @private
       This property is used by the router to know whether to cancel the routing
      setup process, which is needed while we redirect the browser.
       @since 1.5.1
      @property cancelRouterSetup
      @default false
    */
    cancelRouterSetup: false,

    /**
      @private
       Will be pre-pended to path upon state change.
       @since 1.5.1
      @property rootURL
      @default '/'
    */
    rootURL: "/",

    /**
     Called by the router to instruct the location to do any feature detection
     necessary. In the case of AutoLocation, we detect whether to use history
     or hash concrete implementations.
    */
    detect: function () {
      var rootURL = this.rootURL;

      
      var implementation = detectImplementation({
        location: this.location,
        history: this.history,
        userAgent: this.userAgent,
        rootURL: rootURL,
        documentMode: this.documentMode,
        global: this.global
      });

      if (implementation === false) {
        property_set.set(this, "cancelRouterSetup", true);
        implementation = "none";
      }

      var concrete = this.container.lookup("location:" + implementation);
      
      property_set.set(this, "concreteImplementation", concrete);
    },

    initState: delegateToConcreteImplementation("initState"),
    getURL: delegateToConcreteImplementation("getURL"),
    setURL: delegateToConcreteImplementation("setURL"),
    replaceURL: delegateToConcreteImplementation("replaceURL"),
    onUpdateURL: delegateToConcreteImplementation("onUpdateURL"),
    formatURL: delegateToConcreteImplementation("formatURL"),

    willDestroy: function () {
      var concreteImplementation = property_get.get(this, "concreteImplementation");

      if (concreteImplementation) {
        concreteImplementation.destroy();
      }
    }
  });

  function delegateToConcreteImplementation(methodName) {
    return function () {
      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      var concreteImplementation = property_get.get(this, "concreteImplementation");
            return utils.tryInvoke(concreteImplementation, methodName, args);
    };
  }

  /**
    Given the browser's `location`, `history` and `userAgent`, and a configured
    root URL, this function detects whether the browser supports the [History
    API](https://developer.mozilla.org/en-US/docs/Web/API/History) and returns a
    string representing the Location object to use based on its determination.

    For example, if the page loads in an evergreen browser, this function would
    return the string "history", meaning the history API and thus HistoryLocation
    should be used. If the page is loaded in IE8, it will return the string
    "hash," indicating that the History API should be simulated by manipulating the
    hash portion of the location.

  */

  function detectImplementation(options) {
    var location = options.location;
    var userAgent = options.userAgent;
    var history = options.history;
    var documentMode = options.documentMode;
    var global = options.global;
    var rootURL = options.rootURL;

    var implementation = "none";
    var cancelRouterSetup = false;
    var currentPath = util.getFullPath(location);

    if (util.supportsHistory(userAgent, history)) {
      var historyPath = getHistoryPath(rootURL, location);

      // If the browser supports history and we have a history path, we can use
      // the history location with no redirects.
      if (currentPath === historyPath) {
        return "history";
      } else {
        if (currentPath.substr(0, 2) === "/#") {
          history.replaceState({ path: historyPath }, null, historyPath);
          implementation = "history";
        } else {
          cancelRouterSetup = true;
          util.replacePath(location, historyPath);
        }
      }
    } else if (util.supportsHashChange(documentMode, global)) {
      var hashPath = getHashPath(rootURL, location);

      // Be sure we're using a hashed path, otherwise let's switch over it to so
      // we start off clean and consistent. We'll count an index path with no
      // hash as "good enough" as well.
      if (currentPath === hashPath || currentPath === "/" && hashPath === "/#/") {
        implementation = "hash";
      } else {
        // Our URL isn't in the expected hash-supported format, so we want to
        // cancel the router setup and replace the URL to start off clean
        cancelRouterSetup = true;
        util.replacePath(location, hashPath);
      }
    }

    if (cancelRouterSetup) {
      return false;
    }

    return implementation;
  }
  function getHistoryPath(rootURL, location) {
    var path = util.getPath(location);
    var hash = util.getHash(location);
    var query = util.getQuery(location);
    var rootURLIndex = path.indexOf(rootURL);
    var routeHash, hashParts;

    
    // By convention, Ember.js routes using HashLocation are required to start
    // with `#/`. Anything else should NOT be considered a route and should
    // be passed straight through, without transformation.
    if (hash.substr(0, 2) === "#/") {
      // There could be extra hash segments after the route
      hashParts = hash.substr(1).split("#");
      // The first one is always the route url
      routeHash = hashParts.shift();

      // If the path already has a trailing slash, remove the one
      // from the hashed route so we don't double up.
      if (path.slice(-1) === "/") {
        routeHash = routeHash.substr(1);
      }

      // This is the "expected" final order
      path = path + routeHash + query;

      if (hashParts.length) {
        path += "#" + hashParts.join("#");
      }
    } else {
      path = path + query + hash;
    }

    return path;
  }

  function getHashPath(rootURL, location) {
    var path = rootURL;
    var historyPath = getHistoryPath(rootURL, location);
    var routePath = historyPath.substr(rootURL.length);

    if (routePath !== "") {
      if (routePath.charAt(0) !== "/") {
        routePath = "/" + routePath;
      }

      path += "#" + routePath;
    }

    return path;
  }

});
enifed('ember-routing/location/hash_location', ['exports', 'ember-metal/core', 'ember-metal/property_get', 'ember-metal/property_set', 'ember-metal/run_loop', 'ember-metal/utils', 'ember-runtime/system/object', 'ember-routing/location/api'], function (exports, Ember, property_get, property_set, run, utils, EmberObject, EmberLocation) {

  'use strict';

  exports['default'] = EmberObject['default'].extend({
    implementation: "hash",

    init: function () {
      property_set.set(this, "location", property_get.get(this, "_location") || window.location);
    },

    /**
      @private
       Returns normalized location.hash
       @since 1.5.1
      @method getHash
    */
    getHash: EmberLocation['default']._getHash,

    /**
      Returns the normalized URL, constructed from `location.hash`.
       e.g. `#/foo` => `/foo` as well as `#/foo#bar` => `/foo#bar`.
       By convention, hashed paths must begin with a forward slash, otherwise they
      are not treated as a path so we can distinguish intent.
       @private
      @method getURL
    */
    getURL: function () {
      var originalPath = this.getHash().substr(1);
      var outPath = originalPath;

      if (outPath.charAt(0) !== "/") {
        outPath = "/";

        // Only add the # if the path isn't empty.
        // We do NOT want `/#` since the ampersand
        // is only included (conventionally) when
        // the location.hash has a value
        if (originalPath) {
          outPath += "#" + originalPath;
        }
      }

      return outPath;
    },

    /**
      Set the `location.hash` and remembers what was set. This prevents
      `onUpdateURL` callbacks from triggering when the hash was set by
      `HashLocation`.
       @private
      @method setURL
      @param path {String}
    */
    setURL: function (path) {
      property_get.get(this, "location").hash = path;
      property_set.set(this, "lastSetURL", path);
    },

    /**
      Uses location.replace to update the url without a page reload
      or history modification.
       @private
      @method replaceURL
      @param path {String}
    */
    replaceURL: function (path) {
      property_get.get(this, "location").replace("#" + path);
      property_set.set(this, "lastSetURL", path);
    },

    /**
      Register a callback to be invoked when the hash changes. These
      callbacks will execute when the user presses the back or forward
      button, but not after `setURL` is invoked.
       @private
      @method onUpdateURL
      @param callback {Function}
    */
    onUpdateURL: function (callback) {
      var self = this;
      var guid = utils.guidFor(this);

      Ember['default'].$(window).on("hashchange.ember-location-" + guid, function () {
        run['default'](function () {
          var path = self.getURL();
          if (property_get.get(self, "lastSetURL") === path) {
            return;
          }

          property_set.set(self, "lastSetURL", null);

          callback(path);
        });
      });
    },

    /**
      Given a URL, formats it to be placed into the page as part
      of an element's `href` attribute.
       This is used, for example, when using the {{action}} helper
      to generate a URL based on an event.
       @private
      @method formatURL
      @param url {String}
    */
    formatURL: function (url) {
      return "#" + url;
    },

    /**
      Cleans up the HashLocation event listener.
       @private
      @method willDestroy
    */
    willDestroy: function () {
      var guid = utils.guidFor(this);

      Ember['default'].$(window).off("hashchange.ember-location-" + guid);
    }
  });

});
enifed('ember-routing/location/history_location', ['exports', 'ember-metal/property_get', 'ember-metal/property_set', 'ember-metal/utils', 'ember-runtime/system/object', 'ember-routing/location/api', 'ember-views/system/jquery'], function (exports, property_get, property_set, utils, EmberObject, EmberLocation, jQuery) {

  'use strict';

  var popstateFired = false;

  /**
    Ember.HistoryLocation implements the location API using the browser's
    history.pushState API.

    @class HistoryLocation
    @namespace Ember
    @extends Ember.Object
  */
  exports['default'] = EmberObject['default'].extend({
    implementation: "history",

    init: function () {
      property_set.set(this, "location", property_get.get(this, "location") || window.location);
      property_set.set(this, "baseURL", jQuery['default']("base").attr("href") || "");
    },

    /**
      Used to set state on first call to setURL
       @private
      @method initState
    */
    initState: function () {
      var history = property_get.get(this, "history") || window.history;
      property_set.set(this, "history", history);

      if (history && "state" in history) {
        this.supportsHistory = true;
      }

      this.replaceState(this.formatURL(this.getURL()));
    },

    /**
      Will be pre-pended to path upon state change
       @property rootURL
      @default '/'
    */
    rootURL: "/",

    /**
      Returns the current `location.pathname` without `rootURL` or `baseURL`
       @private
      @method getURL
      @return url {String}
    */
    getURL: function () {
      var rootURL = property_get.get(this, "rootURL");
      var location = property_get.get(this, "location");
      var path = location.pathname;
      var baseURL = property_get.get(this, "baseURL");

      rootURL = rootURL.replace(/\/$/, "");
      baseURL = baseURL.replace(/\/$/, "");

      var url = path.replace(baseURL, "").replace(rootURL, "");
      var search = location.search || "";

      url += search;
      url += this.getHash();

      return url;
    },

    /**
      Uses `history.pushState` to update the url without a page reload.
       @private
      @method setURL
      @param path {String}
    */
    setURL: function (path) {
      var state = this.getState();
      path = this.formatURL(path);

      if (!state || state.path !== path) {
        this.pushState(path);
      }
    },

    /**
      Uses `history.replaceState` to update the url without a page reload
      or history modification.
       @private
      @method replaceURL
      @param path {String}
    */
    replaceURL: function (path) {
      var state = this.getState();
      path = this.formatURL(path);

      if (!state || state.path !== path) {
        this.replaceState(path);
      }
    },

    /**
      Get the current `history.state`. Checks for if a polyfill is
      required and if so fetches this._historyState. The state returned
      from getState may be null if an iframe has changed a window's
      history.
       @private
      @method getState
      @return state {Object}
    */
    getState: function () {
      if (this.supportsHistory) {
        return property_get.get(this, "history").state;
      }

      return this._historyState;
    },

    /**
     Pushes a new state.
      @private
     @method pushState
     @param path {String}
    */
    pushState: function (path) {
      var state = { path: path };

      property_get.get(this, "history").pushState(state, null, path);

      this._historyState = state;

      // used for webkit workaround
      this._previousURL = this.getURL();
    },

    /**
     Replaces the current state.
      @private
     @method replaceState
     @param path {String}
    */
    replaceState: function (path) {
      var state = { path: path };
      property_get.get(this, "history").replaceState(state, null, path);

      this._historyState = state;

      // used for webkit workaround
      this._previousURL = this.getURL();
    },

    /**
      Register a callback to be invoked whenever the browser
      history changes, including using forward and back buttons.
       @private
      @method onUpdateURL
      @param callback {Function}
    */
    onUpdateURL: function (callback) {
      var guid = utils.guidFor(this);
      var self = this;

      jQuery['default'](window).on("popstate.ember-location-" + guid, function (e) {
        // Ignore initial page load popstate event in Chrome
        if (!popstateFired) {
          popstateFired = true;
          if (self.getURL() === self._previousURL) {
            return;
          }
        }
        callback(self.getURL());
      });
    },

    /**
      Used when using `{{action}}` helper.  The url is always appended to the rootURL.
       @private
      @method formatURL
      @param url {String}
      @return formatted url {String}
    */
    formatURL: function (url) {
      var rootURL = property_get.get(this, "rootURL");
      var baseURL = property_get.get(this, "baseURL");

      if (url !== "") {
        rootURL = rootURL.replace(/\/$/, "");
        baseURL = baseURL.replace(/\/$/, "");
      } else if (baseURL.match(/^\//) && rootURL.match(/^\//)) {
        baseURL = baseURL.replace(/\/$/, "");
      }

      return baseURL + rootURL + url;
    },

    /**
      Cleans up the HistoryLocation event listener.
       @private
      @method willDestroy
    */
    willDestroy: function () {
      var guid = utils.guidFor(this);

      jQuery['default'](window).off("popstate.ember-location-" + guid);
    },

    /**
      @private
       Returns normalized location.hash
       @method getHash
    */
    getHash: EmberLocation['default']._getHash
  });

});
enifed('ember-routing/location/none_location', ['exports', 'ember-metal/property_get', 'ember-metal/property_set', 'ember-runtime/system/object'], function (exports, property_get, property_set, EmberObject) {

  'use strict';

  exports['default'] = EmberObject['default'].extend({
    implementation: "none",
    path: "",

    /**
      Returns the current path.
       @private
      @method getURL
      @return {String} path
    */
    getURL: function () {
      return property_get.get(this, "path");
    },

    /**
      Set the path and remembers what was set. Using this method
      to change the path will not invoke the `updateURL` callback.
       @private
      @method setURL
      @param path {String}
    */
    setURL: function (path) {
      property_set.set(this, "path", path);
    },

    /**
      Register a callback to be invoked when the path changes. These
      callbacks will execute when the user presses the back or forward
      button, but not after `setURL` is invoked.
       @private
      @method onUpdateURL
      @param callback {Function}
    */
    onUpdateURL: function (callback) {
      this.updateCallback = callback;
    },

    /**
      Sets the path and calls the `updateURL` callback.
       @private
      @method handleURL
      @param callback {Function}
    */
    handleURL: function (url) {
      property_set.set(this, "path", url);
      this.updateCallback(url);
    },

    /**
      Given a URL, formats it to be placed into the page as part
      of an element's `href` attribute.
       This is used, for example, when using the {{action}} helper
      to generate a URL based on an event.
       @private
      @method formatURL
      @param url {String}
      @return {String} url
    */
    formatURL: function (url) {
      // The return value is not overly meaningful, but we do not want to throw
      // errors when test code renders templates containing {{action href=true}}
      // helpers.
      return url;
    }
  });

});
enifed('ember-routing/location/util', ['exports'], function (exports) {

  'use strict';

  exports.getPath = getPath;
  exports.getQuery = getQuery;
  exports.getHash = getHash;
  exports.getFullPath = getFullPath;
  exports.getOrigin = getOrigin;
  exports.supportsHashChange = supportsHashChange;
  exports.supportsHistory = supportsHistory;
  exports.replacePath = replacePath;

  /**
    @private

    Returns the current `location.pathname`, normalized for IE inconsistencies.
  */
  function getPath(location) {
    var pathname = location.pathname;
    // Various versions of IE/Opera don't always return a leading slash
    if (pathname.charAt(0) !== '/') {
      pathname = '/' + pathname;
    }

    return pathname;
  }

  function getQuery(location) {
    return location.search;
  }

  function getHash(location) {
    var href = location.href;
    var hashIndex = href.indexOf('#');

    if (hashIndex === -1) {
      return '';
    } else {
      return href.substr(hashIndex);
    }
  }

  function getFullPath(location) {
    return getPath(location) + getQuery(location) + getHash(location);
  }

  function getOrigin(location) {
    var origin = location.origin;

    // Older browsers, especially IE, don't have origin
    if (!origin) {
      origin = location.protocol + '//' + location.hostname;

      if (location.port) {
        origin += ':' + location.port;
      }
    }

    return origin;
  }

  function supportsHashChange(documentMode, global) {
    return 'onhashchange' in global && (documentMode === undefined || documentMode > 7);
  }

  function supportsHistory(userAgent, history) {
    // Boosted from Modernizr: https://github.com/Modernizr/Modernizr/blob/master/feature-detects/history.js
    // The stock browser on Android 2.2 & 2.3 returns positive on history support
    // Unfortunately support is really buggy and there is no clean way to detect
    // these bugs, so we fall back to a user agent sniff :(

    // We only want Android 2, stock browser, and not Chrome which identifies
    // itself as 'Mobile Safari' as well
    if (userAgent.indexOf('Android 2') !== -1 && userAgent.indexOf('Mobile Safari') !== -1 && userAgent.indexOf('Chrome') === -1) {
      return false;
    }

    return !!(history && 'pushState' in history);
  }

  function replacePath(location, path) {
    location.replace(getOrigin(location) + path);
  }

});
enifed('ember-routing/system/cache', ['exports', 'ember-runtime/system/object'], function (exports, EmberObject) {

  'use strict';

  exports['default'] = EmberObject['default'].extend({
    init: function () {
      this.cache = {};
    },
    has: function (bucketKey) {
      return bucketKey in this.cache;
    },
    stash: function (bucketKey, key, value) {
      var bucket = this.cache[bucketKey];
      if (!bucket) {
        bucket = this.cache[bucketKey] = {};
      }
      bucket[key] = value;
    },
    lookup: function (bucketKey, prop, defaultValue) {
      var cache = this.cache;
      if (!(bucketKey in cache)) {
        return defaultValue;
      }
      var bucket = cache[bucketKey];
      if (prop in bucket) {
        return bucket[prop];
      } else {
        return defaultValue;
      }
    },
    cache: null
  });

});
enifed('ember-routing/system/controller_for', ['exports'], function (exports) {

  'use strict';

  /**
  @module ember
  @submodule ember-routing
  */

  /**

    Finds a controller instance.

    @for Ember
    @method controllerFor
    @private
  */
  exports['default'] = controllerFor;

  function controllerFor(container, controllerName, lookupOptions) {
    return container.lookup('controller:' + controllerName, lookupOptions);
  }

});
enifed('ember-routing/system/dsl', ['exports', 'ember-metal/core', 'ember-metal/array'], function (exports, Ember, array) {

  'use strict';

  function DSL(name, options) {
    this.parent = name;
    this.enableLoadingSubstates = options && options.enableLoadingSubstates;
    this.matches = [];
  }
  exports['default'] = DSL;

  DSL.prototype = {
    route: function (name, options, callback) {
      if (arguments.length === 2 && typeof options === "function") {
        callback = options;
        options = {};
      }

      if (arguments.length === 1) {
        options = {};
      }

      var type = options.resetNamespace === true ? "resource" : "route";
      
      
        if (this.enableLoadingSubstates) {
          createRoute(this, name + "_loading", { resetNamespace: options.resetNamespace });
          createRoute(this, name + "_error", { path: "/_unused_dummy_error_path_route_" + name + "/:error" });
        }
      

      if (callback) {
        var fullName = getFullName(this, name, options.resetNamespace);
        var dsl = new DSL(fullName, {
          enableLoadingSubstates: this.enableLoadingSubstates
        });

        createRoute(dsl, "loading");
        createRoute(dsl, "error", { path: "/_unused_dummy_error_path_route_" + name + "/:error" });

        callback.call(dsl);

        createRoute(this, name, options, dsl.generate());
      } else {
        createRoute(this, name, options);
      }
    },

    push: function (url, name, callback) {
      var parts = name.split(".");
      if (url === "" || url === "/" || parts[parts.length - 1] === "index") {
        this.explicitIndex = true;
      }

      this.matches.push([url, name, callback]);
    },

    resource: function (name, options, callback) {
      if (arguments.length === 2 && typeof options === "function") {
        callback = options;
        options = {};
      }

      if (arguments.length === 1) {
        options = {};
      }

      options.resetNamespace = true;
      this.route(name, options, callback);
    },

    generate: function () {
      var dslMatches = this.matches;

      if (!this.explicitIndex) {
        this.route("index", { path: "/" });
      }

      return function (match) {
        for (var i = 0, l = dslMatches.length; i < l; i++) {
          var dslMatch = dslMatches[i];
          match(dslMatch[0]).to(dslMatch[1], dslMatch[2]);
        }
      };
    }
  };

  function canNest(dsl) {
    return dsl.parent && dsl.parent !== "application";
  }

  function getFullName(dsl, name, resetNamespace) {
    if (canNest(dsl) && resetNamespace !== true) {
      return dsl.parent + "." + name;
    } else {
      return name;
    }
  }

  function createRoute(dsl, name, options, callback) {
    options = options || {};

    var fullName = getFullName(dsl, name, options.resetNamespace);

    if (typeof options.path !== "string") {
      options.path = "/" + name;
    }

    dsl.push(options.path, fullName, callback);
  }

  DSL.map = function (callback) {
    var dsl = new DSL();
    callback.call(dsl);
    return dsl;
  };

});
enifed('ember-routing/system/generate_controller', ['exports', 'ember-metal/core', 'ember-metal/property_get', 'ember-metal/utils'], function (exports, Ember, property_get, utils) {

  'use strict';

  exports.generateControllerFactory = generateControllerFactory;

  /**
  @module ember
  @submodule ember-routing
  */

  /**
    Generates a controller factory

    The type of the generated controller factory is derived
    from the context. If the context is an array an array controller
    is generated, if an object, an object controller otherwise, a basic
    controller is generated.

    You can customize your generated controllers by defining
    `App.ObjectController` or `App.ArrayController`.

    @for Ember
    @method generateControllerFactory
    @private
  */

  exports['default'] = generateController;
  function generateControllerFactory(container, controllerName, context) {
    var Factory, fullName, factoryName, controllerType;

    if (context && utils.isArray(context)) {
      controllerType = "array";
    } else if (context) {
      controllerType = "object";
    } else {
      controllerType = "basic";
    }

    factoryName = "controller:" + controllerType;

    Factory = container.lookupFactory(factoryName).extend({
      isGenerated: true,
      toString: function () {
        return "(generated " + controllerName + " controller)";
      }
    });

    fullName = "controller:" + controllerName;

    container._registry.register(fullName, Factory);

    return Factory;
  }

  function generateController(container, controllerName, context) {
    generateControllerFactory(container, controllerName, context);
    var fullName = "controller:" + controllerName;
    var instance = container.lookup(fullName);

    if (property_get.get(instance, "namespace.LOG_ACTIVE_GENERATION")) {
          }

    return instance;
  }

});
enifed('ember-routing/system/query_params', ['exports', 'ember-runtime/system/object'], function (exports, EmberObject) {

  'use strict';

  exports['default'] = EmberObject['default'].extend({
    isQueryParams: true,
    values: null
  });

});
enifed('ember-routing/system/route', ['exports', 'ember-metal/core', 'ember-metal/error', 'ember-metal/property_get', 'ember-metal/property_set', 'ember-metal/get_properties', 'ember-metal/enumerable_utils', 'ember-metal/is_none', 'ember-metal/computed', 'ember-metal/merge', 'ember-metal/utils', 'ember-metal/run_loop', 'ember-metal/keys', 'ember-runtime/copy', 'ember-runtime/system/string', 'ember-runtime/system/object', 'ember-runtime/mixins/evented', 'ember-runtime/mixins/action_handler', 'ember-routing/system/generate_controller', 'ember-routing/utils'], function (exports, Ember, EmberError, property_get, property_set, getProperties, enumerable_utils, isNone, computed, merge, utils, run, keys, copy, string, EmberObject, Evented, ActionHandler, generateController, ember_routing__utils) {

  'use strict';

  var slice = Array.prototype.slice;

  function K() {
    return this;
  }

  /**
  @module ember
  @submodule ember-routing
  */

  /**
    The `Ember.Route` class is used to define individual routes. Refer to
    the [routing guide](http://emberjs.com/guides/routing/) for documentation.

    @class Route
    @namespace Ember
    @extends Ember.Object
    @uses Ember.ActionHandler
    @uses Ember.Evented
  */
  var Route = EmberObject['default'].extend(ActionHandler['default'], Evented['default'], {
    /**
      Configuration hash for this route's queryParams. The possible
      configuration options and their defaults are as follows
      (assuming a query param whose controller property is `page`):
       ```javascript
      queryParams: {
        page: {
          // By default, controller query param properties don't
          // cause a full transition when they are changed, but
          // rather only cause the URL to update. Setting
          // `refreshModel` to true will cause an "in-place"
          // transition to occur, whereby the model hooks for
          // this route (and any child routes) will re-fire, allowing
          // you to reload models (e.g., from the server) using the
          // updated query param values.
          refreshModel: false,
           // By default, changes to controller query param properties
          // cause the URL to update via `pushState`, which means an
          // item will be added to the browser's history, allowing
          // you to use the back button to restore the app to the
          // previous state before the query param property was changed.
          // Setting `replace` to true will use `replaceState` (or its
          // hash location equivalent), which causes no browser history
          // item to be added. This options name and default value are
          // the same as the `link-to` helper's `replace` option.
          replace: false,
           // By default, the query param URL key is the same name as
          // the controller property name. Use `as` to specify a
          // different URL key.
          as: 'page'
        }
      }
      ```
       @property queryParams
      @for Ember.Route
      @type Hash
    */
    queryParams: {},

    /**
      @private
       @property _qp
    */
    _qp: computed.computed(function () {
      var controllerName = this.controllerName || this.routeName;
      var controllerClass = this.container.lookupFactory("controller:" + controllerName);

      if (!controllerClass) {
        return defaultQPMeta;
      }

      var controllerProto = controllerClass.proto();
      var qpProps = property_get.get(controllerProto, "_normalizedQueryParams");
      var cacheMeta = property_get.get(controllerProto, "_cacheMeta");

      var qps = [];
      var map = {};
      var self = this;
      for (var propName in qpProps) {
        if (!qpProps.hasOwnProperty(propName)) {
          continue;
        }

        var desc = qpProps[propName];
        var urlKey = desc.as || this.serializeQueryParamKey(propName);
        var defaultValue = property_get.get(controllerProto, propName);

        if (utils.isArray(defaultValue)) {
          defaultValue = Ember['default'].A(defaultValue.slice());
        }

        var type = utils.typeOf(defaultValue);
        var defaultValueSerialized = this.serializeQueryParam(defaultValue, urlKey, type);
        var fprop = controllerName + ":" + propName;
        var qp = {
          def: defaultValue,
          sdef: defaultValueSerialized,
          type: type,
          urlKey: urlKey,
          prop: propName,
          fprop: fprop,
          ctrl: controllerName,
          cProto: controllerProto,
          svalue: defaultValueSerialized,
          cacheType: desc.scope,
          route: this,
          cacheMeta: cacheMeta[propName]
        };

        map[propName] = map[urlKey] = map[fprop] = qp;
        qps.push(qp);
      }

      return {
        qps: qps,
        map: map,
        states: {
          active: function (controller, prop) {
            return self._activeQPChanged(controller, map[prop]);
          },
          allowOverrides: function (controller, prop) {
            return self._updatingQPChanged(controller, map[prop]);
          },
          changingKeys: function (controller, prop) {
            return self._updateSerializedQPValue(controller, map[prop]);
          }
        }
      };
    }),

    /**
      @private
       @property _names
    */
    _names: null,

    /**
      @private
       @method _stashNames
    */
    _stashNames: function (_handlerInfo, dynamicParent) {
      var handlerInfo = _handlerInfo;
      if (this._names) {
        return;
      }
      var names = this._names = handlerInfo._names;

      if (!names.length) {
        handlerInfo = dynamicParent;
        names = handlerInfo && handlerInfo._names || [];
      }

      var qps = property_get.get(this, "_qp.qps");
      var len = qps.length;

      var namePaths = new Array(names.length);
      for (var a = 0, nlen = names.length; a < nlen; ++a) {
        namePaths[a] = handlerInfo.name + "." + names[a];
      }

      for (var i = 0; i < len; ++i) {
        var qp = qps[i];
        var cacheMeta = qp.cacheMeta;
        if (cacheMeta.scope === "model") {
          cacheMeta.parts = namePaths;
        }
        cacheMeta.prefix = qp.ctrl;
      }
    },

    /**
      @private
       @property _updateSerializedQPValue
    */
    _updateSerializedQPValue: function (controller, qp) {
      var value = property_get.get(controller, qp.prop);
      qp.svalue = this.serializeQueryParam(value, qp.urlKey, qp.type);
    },

    /**
      @private
       @property _activeQPChanged
    */
    _activeQPChanged: function (controller, qp) {
      var value = property_get.get(controller, qp.prop);
      this.router._queuedQPChanges[qp.fprop] = value;
      run['default'].once(this, this._fireQueryParamTransition);
    },

    /**
      @private
      @method _updatingQPChanged
    */
    _updatingQPChanged: function (controller, qp) {
      var router = this.router;
      if (!router._qpUpdates) {
        router._qpUpdates = {};
      }
      router._qpUpdates[qp.urlKey] = true;
    },

    mergedProperties: ["events", "queryParams"],

    /**
      Retrieves parameters, for current route using the state.params
      variable and getQueryParamsFor, using the supplied routeName.
       @method paramsFor
      @param {String} name
     */
    paramsFor: function (name) {
      var route = this.container.lookup("route:" + name);

      if (!route) {
        return {};
      }

      var transition = this.router.router.activeTransition;
      var state = transition ? transition.state : this.router.router.state;

      var params = {};
      merge['default'](params, state.params[name]);
      merge['default'](params, getQueryParamsFor(route, state));

      return params;
    },

    /**
      Serializes the query parameter key
       @method serializeQueryParamKey
      @param {String} controllerPropertyName
    */
    serializeQueryParamKey: function (controllerPropertyName) {
      return controllerPropertyName;
    },

    /**
      Serializes value of the query parameter based on defaultValueType
       @method serializeQueryParam
      @param {Object} value
      @param {String} urlKey
      @param {String} defaultValueType
    */
    serializeQueryParam: function (value, urlKey, defaultValueType) {
      // urlKey isn't used here, but anyone overriding
      // can use it to provide serialization specific
      // to a certain query param.
      if (defaultValueType === "array") {
        return JSON.stringify(value);
      }
      return "" + value;
    },

    /**
      Deserializes value of the query parameter based on defaultValueType
       @method deserializeQueryParam
      @param {Object} value
      @param {String} urlKey
      @param {String} defaultValueType
    */
    deserializeQueryParam: function (value, urlKey, defaultValueType) {
      // urlKey isn't used here, but anyone overriding
      // can use it to provide deserialization specific
      // to a certain query param.

      // Use the defaultValueType of the default value (the initial value assigned to a
      // controller query param property), to intelligently deserialize and cast.
      if (defaultValueType === "boolean") {
        return value === "true" ? true : false;
      } else if (defaultValueType === "number") {
        return Number(value).valueOf();
      } else if (defaultValueType === "array") {
        return Ember['default'].A(JSON.parse(value));
      }
      return value;
    },

    /**
      @private
      @property _fireQueryParamTransition
    */
    _fireQueryParamTransition: function () {
      this.transitionTo({ queryParams: this.router._queuedQPChanges });
      this.router._queuedQPChanges = {};
    },

    /**
      @private
       @property _optionsForQueryParam
    */
    _optionsForQueryParam: function (qp) {
      return property_get.get(this, "queryParams." + qp.urlKey) || property_get.get(this, "queryParams." + qp.prop) || {};
    },

    /**
      A hook you can use to reset controller values either when the model
      changes or the route is exiting.
       ```javascript
      App.ArticlesRoute = Ember.Route.extend({
        // ...
         resetController: function (controller, isExiting, transition) {
          if (isExiting) {
            controller.set('page', 1);
          }
        }
      });
      ```
       @method resetController
      @param {Controller} controller instance
      @param {Boolean} isExiting
      @param {Object} transition
      @since 1.7.0
    */
    resetController: K,

    /**
      @private
       @method exit
    */
    exit: function () {
      this.deactivate();
      this.trigger("deactivate");
      this.teardownViews();
    },

    /**
      @private
       @method _reset
      @since 1.7.0
    */
    _reset: function (isExiting, transition) {
      var controller = this.controller;

      controller._qpDelegate = property_get.get(this, "_qp.states.inactive");

      this.resetController(controller, isExiting, transition);
    },

    /**
      @private
       @method enter
    */
    enter: function () {
      this.connections = [];
      this.activate();
      this.trigger("activate");
    },

    /**
      The name of the view to use by default when rendering this routes template.
       When rendering a template, the route will, by default, determine the
      template and view to use from the name of the route itself. If you need to
      define a specific view, set this property.
       This is useful when multiple routes would benefit from using the same view
      because it doesn't require a custom `renderTemplate` method. For example,
      the following routes will all render using the `App.PostsListView` view:
       ```javascript
      var PostsList = Ember.Route.extend({
        viewName: 'postsList'
      });
       App.PostsIndexRoute = PostsList.extend();
      App.PostsArchivedRoute = PostsList.extend();
      ```
       @property viewName
      @type String
      @default null
      @since 1.4.0
    */
    viewName: null,

    /**
      The name of the template to use by default when rendering this routes
      template.
       This is similar with `viewName`, but is useful when you just want a custom
      template without a view.
       ```javascript
      var PostsList = Ember.Route.extend({
        templateName: 'posts/list'
      });
       App.PostsIndexRoute = PostsList.extend();
      App.PostsArchivedRoute = PostsList.extend();
      ```
       @property templateName
      @type String
      @default null
      @since 1.4.0
    */
    templateName: null,

    /**
      The name of the controller to associate with this route.
       By default, Ember will lookup a route's controller that matches the name
      of the route (i.e. `App.PostController` for `App.PostRoute`). However,
      if you would like to define a specific controller to use, you can do so
      using this property.
       This is useful in many ways, as the controller specified will be:
       * passed to the `setupController` method.
      * used as the controller for the view being rendered by the route.
      * returned from a call to `controllerFor` for the route.
       @property controllerName
      @type String
      @default null
      @since 1.4.0
    */
    controllerName: null,

    /**
      The `willTransition` action is fired at the beginning of any
      attempted transition with a `Transition` object as the sole
      argument. This action can be used for aborting, redirecting,
      or decorating the transition from the currently active routes.
       A good example is preventing navigation when a form is
      half-filled out:
       ```javascript
      App.ContactFormRoute = Ember.Route.extend({
        actions: {
          willTransition: function(transition) {
            if (this.controller.get('userHasEnteredData')) {
              this.controller.displayNavigationConfirm();
              transition.abort();
            }
          }
        }
      });
      ```
       You can also redirect elsewhere by calling
      `this.transitionTo('elsewhere')` from within `willTransition`.
      Note that `willTransition` will not be fired for the
      redirecting `transitionTo`, since `willTransition` doesn't
      fire when there is already a transition underway. If you want
      subsequent `willTransition` actions to fire for the redirecting
      transition, you must first explicitly call
      `transition.abort()`.
       @event willTransition
      @param {Transition} transition
    */

    /**
      The `didTransition` action is fired after a transition has
      successfully been completed. This occurs after the normal model
      hooks (`beforeModel`, `model`, `afterModel`, `setupController`)
      have resolved. The `didTransition` action has no arguments,
      however, it can be useful for tracking page views or resetting
      state on the controller.
       ```javascript
      App.LoginRoute = Ember.Route.extend({
        actions: {
          didTransition: function() {
            this.controller.get('errors.base').clear();
            return true; // Bubble the didTransition event
          }
        }
      });
      ```
       @event didTransition
      @since 1.2.0
    */

    /**
      The `loading` action is fired on the route when a route's `model`
      hook returns a promise that is not already resolved. The current
      `Transition` object is the first parameter and the route that
      triggered the loading event is the second parameter.
       ```javascript
      App.ApplicationRoute = Ember.Route.extend({
        actions: {
          loading: function(transition, route) {
            var view = Ember.View.create({
              classNames: ['app-loading']
            })
            .append();
             this.router.one('didTransition', function() {
              view.destroy();
            });
             return true; // Bubble the loading event
          }
        }
      });
      ```
       @event loading
      @param {Transition} transition
      @param {Ember.Route} route The route that triggered the loading event
      @since 1.2.0
    */

    /**
      When attempting to transition into a route, any of the hooks
      may return a promise that rejects, at which point an `error`
      action will be fired on the partially-entered routes, allowing
      for per-route error handling logic, or shared error handling
      logic defined on a parent route.
       Here is an example of an error handler that will be invoked
      for rejected promises from the various hooks on the route,
      as well as any unhandled errors from child routes:
       ```javascript
      App.AdminRoute = Ember.Route.extend({
        beforeModel: function() {
          return Ember.RSVP.reject('bad things!');
        },
         actions: {
          error: function(error, transition) {
            // Assuming we got here due to the error in `beforeModel`,
            // we can expect that error === "bad things!",
            // but a promise model rejecting would also
            // call this hook, as would any errors encountered
            // in `afterModel`.
             // The `error` hook is also provided the failed
            // `transition`, which can be stored and later
            // `.retry()`d if desired.
             this.transitionTo('login');
          }
        }
      });
      ```
       `error` actions that bubble up all the way to `ApplicationRoute`
      will fire a default error handler that logs the error. You can
      specify your own global default error handler by overriding the
      `error` handler on `ApplicationRoute`:
       ```javascript
      App.ApplicationRoute = Ember.Route.extend({
        actions: {
          error: function(error, transition) {
            this.controllerFor('banner').displayError(error.message);
          }
        }
      });
      ```
      @event error
      @param {Error} error
      @param {Transition} transition
    */

    /**
      This event is triggered when the router enters the route. It is
      not executed when the model for the route changes.
       ```javascript
      App.ApplicationRoute = Ember.Route.extend({
        collectAnalytics: function(){
          collectAnalytics();
        }.on('activate')
      });
      ```
       @event activate
      @since 1.9.0
    */

    /**
      This event is triggered when the router completely exits this
      route. It is not executed when the model for the route changes.
       ```javascript
      App.IndexRoute = Ember.Route.extend({
        trackPageLeaveAnalytics: function(){
          trackPageLeaveAnalytics();
        }.on('deactivate')
      });
      ```
       @event deactivate
      @since 1.9.0
    */

    /**
      The controller associated with this route.
       Example
       ```javascript
      App.FormRoute = Ember.Route.extend({
        actions: {
          willTransition: function(transition) {
            if (this.controller.get('userHasEnteredData') &&
                !confirm('Are you sure you want to abandon progress?')) {
              transition.abort();
            } else {
              // Bubble the `willTransition` action so that
              // parent routes can decide whether or not to abort.
              return true;
            }
          }
        }
      });
      ```
       @property controller
      @type Ember.Controller
      @since 1.6.0
    */

    _actions: {

      queryParamsDidChange: function (changed, totalPresent, removed) {
        var qpMap = property_get.get(this, "_qp").map;

        var totalChanged = keys['default'](changed).concat(keys['default'](removed));
        for (var i = 0, len = totalChanged.length; i < len; ++i) {
          var qp = qpMap[totalChanged[i]];
          if (qp && property_get.get(this._optionsForQueryParam(qp), "refreshModel")) {
            this.refresh();
          }
        }

        return true;
      },

      finalizeQueryParamChange: function (params, finalParams, transition) {
        if (this.routeName !== "application") {
          return true;
        }

        // Transition object is absent for intermediate transitions.
        if (!transition) {
          return;
        }

        var handlerInfos = transition.state.handlerInfos;
        var router = this.router;
        var qpMeta = router._queryParamsFor(handlerInfos[handlerInfos.length - 1].name);
        var changes = router._qpUpdates;
        var replaceUrl;

        ember_routing__utils.stashParamNames(router, handlerInfos);

        for (var i = 0, len = qpMeta.qps.length; i < len; ++i) {
          var qp = qpMeta.qps[i];
          var route = qp.route;
          var controller = route.controller;
          var presentKey = qp.urlKey in params && qp.urlKey;

          // Do a reverse lookup to see if the changed query
          // param URL key corresponds to a QP property on
          // this controller.
          var value, svalue;
          if (changes && qp.urlKey in changes) {
            // Value updated in/before setupController
            value = property_get.get(controller, qp.prop);
            svalue = route.serializeQueryParam(value, qp.urlKey, qp.type);
          } else {
            if (presentKey) {
              svalue = params[presentKey];
              value = route.deserializeQueryParam(svalue, qp.urlKey, qp.type);
            } else {
              // No QP provided; use default value.
              svalue = qp.sdef;
              value = copyDefaultValue(qp.def);
            }
          }

          controller._qpDelegate = property_get.get(this, "_qp.states.inactive");

          var thisQueryParamChanged = svalue !== qp.svalue;
          if (thisQueryParamChanged) {
            if (transition.queryParamsOnly && replaceUrl !== false) {
              var options = route._optionsForQueryParam(qp);
              var replaceConfigValue = property_get.get(options, "replace");
              if (replaceConfigValue) {
                replaceUrl = true;
              } else if (replaceConfigValue === false) {
                // Explicit pushState wins over any other replaceStates.
                replaceUrl = false;
              }
            }

            property_set.set(controller, qp.prop, value);
          }

          // Stash current serialized value of controller.
          qp.svalue = svalue;

          var thisQueryParamHasDefaultValue = qp.sdef === svalue;
          if (!thisQueryParamHasDefaultValue) {
            finalParams.push({
              value: svalue,
              visible: true,
              key: presentKey || qp.urlKey
            });
          }
        }

        if (replaceUrl) {
          transition.method("replace");
        }

        enumerable_utils.forEach(qpMeta.qps, function (qp) {
          var routeQpMeta = property_get.get(qp.route, "_qp");
          var finalizedController = qp.route.controller;
          finalizedController._qpDelegate = property_get.get(routeQpMeta, "states.active");
        });

        router._qpUpdates = null;
      }
    },

    /**
      @deprecated
       Please use `actions` instead.
      @method events
    */
    events: null,

    /**
      This hook is executed when the router completely exits this route. It is
      not executed when the model for the route changes.
       @method deactivate
    */
    deactivate: K,

    /**
      This hook is executed when the router enters the route. It is not executed
      when the model for the route changes.
       @method activate
    */
    activate: K,

    /**
      Transition the application into another route. The route may
      be either a single route or route path:
       ```javascript
      this.transitionTo('blogPosts');
      this.transitionTo('blogPosts.recentEntries');
      ```
       Optionally supply a model for the route in question. The model
      will be serialized into the URL using the `serialize` hook of
      the route:
       ```javascript
      this.transitionTo('blogPost', aPost);
      ```
       If a literal is passed (such as a number or a string), it will
      be treated as an identifier instead. In this case, the `model`
      hook of the route will be triggered:
       ```javascript
      this.transitionTo('blogPost', 1);
      ```
       Multiple models will be applied last to first recursively up the
      resource tree.
       ```javascript
      App.Router.map(function() {
        this.resource('blogPost', { path:':blogPostId' }, function() {
          this.resource('blogComment', { path: ':blogCommentId' });
        });
      });
       this.transitionTo('blogComment', aPost, aComment);
      this.transitionTo('blogComment', 1, 13);
      ```
       It is also possible to pass a URL (a string that starts with a
      `/`). This is intended for testing and debugging purposes and
      should rarely be used in production code.
       ```javascript
      this.transitionTo('/');
      this.transitionTo('/blog/post/1/comment/13');
      this.transitionTo('/blog/posts?sort=title');
      ```
       An options hash with a `queryParams` property may be provided as
      the final argument to add query parameters to the destination URL.
       ```javascript
      this.transitionTo('blogPost', 1, {
        queryParams: {showComments: 'true'}
      });
       // if you just want to transition the query parameters without changing the route
      this.transitionTo({queryParams: {sort: 'date'}});
      ```
       See also 'replaceWith'.
       Simple Transition Example
       ```javascript
      App.Router.map(function() {
        this.route('index');
        this.route('secret');
        this.route('fourOhFour', { path: '*:' });
      });
       App.IndexRoute = Ember.Route.extend({
        actions: {
          moveToSecret: function(context) {
            if (authorized()) {
              this.transitionTo('secret', context);
            } else {
              this.transitionTo('fourOhFour');
            }
          }
        }
      });
      ```
       Transition to a nested route
       ```javascript
      App.Router.map(function() {
        this.resource('articles', { path: '/articles' }, function() {
          this.route('new');
        });
      });
       App.IndexRoute = Ember.Route.extend({
        actions: {
          transitionToNewArticle: function() {
            this.transitionTo('articles.new');
          }
        }
      });
      ```
       Multiple Models Example
       ```javascript
      App.Router.map(function() {
        this.route('index');
         this.resource('breakfast', { path: ':breakfastId' }, function() {
          this.resource('cereal', { path: ':cerealId' });
        });
      });
       App.IndexRoute = Ember.Route.extend({
        actions: {
          moveToChocolateCereal: function() {
            var cereal = { cerealId: 'ChocolateYumminess' };
            var breakfast = { breakfastId: 'CerealAndMilk' };
             this.transitionTo('cereal', breakfast, cereal);
          }
        }
      });
      ```
       Nested Route with Query String Example
       ```javascript
      App.Router.map(function() {
        this.resource('fruits', function() {
          this.route('apples');
        });
      });
       App.IndexRoute = Ember.Route.extend({
        actions: {
          transitionToApples: function() {
            this.transitionTo('fruits.apples', {queryParams: {color: 'red'}});
          }
        }
      });
      ```
       @method transitionTo
      @param {String} name the name of the route or a URL
      @param {...Object} models the model(s) or identifier(s) to be used while
        transitioning to the route.
      @param {Object} [options] optional hash with a queryParams property
        containing a mapping of query parameters
      @return {Transition} the transition object associated with this
        attempted transition
    */
    transitionTo: function (name, context) {
      var router = this.router;
      return router.transitionTo.apply(router, arguments);
    },

    /**
      Perform a synchronous transition into another route without attempting
      to resolve promises, update the URL, or abort any currently active
      asynchronous transitions (i.e. regular transitions caused by
      `transitionTo` or URL changes).
       This method is handy for performing intermediate transitions on the
      way to a final destination route, and is called internally by the
      default implementations of the `error` and `loading` handlers.
       @method intermediateTransitionTo
      @param {String} name the name of the route
      @param {...Object} models the model(s) to be used while transitioning
      to the route.
      @since 1.2.0
     */
    intermediateTransitionTo: function () {
      var router = this.router;
      router.intermediateTransitionTo.apply(router, arguments);
    },

    /**
      Refresh the model on this route and any child routes, firing the
      `beforeModel`, `model`, and `afterModel` hooks in a similar fashion
      to how routes are entered when transitioning in from other route.
      The current route params (e.g. `article_id`) will be passed in
      to the respective model hooks, and if a different model is returned,
      `setupController` and associated route hooks will re-fire as well.
       An example usage of this method is re-querying the server for the
      latest information using the same parameters as when the route
      was first entered.
       Note that this will cause `model` hooks to fire even on routes
      that were provided a model object when the route was initially
      entered.
       @method refresh
      @return {Transition} the transition object associated with this
        attempted transition
      @since 1.4.0
     */
    refresh: function () {
      return this.router.router.refresh(this);
    },

    /**
      Transition into another route while replacing the current URL, if possible.
      This will replace the current history entry instead of adding a new one.
      Beside that, it is identical to `transitionTo` in all other respects. See
      'transitionTo' for additional information regarding multiple models.
       Example
       ```javascript
      App.Router.map(function() {
        this.route('index');
        this.route('secret');
      });
       App.SecretRoute = Ember.Route.extend({
        afterModel: function() {
          if (!authorized()){
            this.replaceWith('index');
          }
        }
      });
      ```
       @method replaceWith
      @param {String} name the name of the route or a URL
      @param {...Object} models the model(s) or identifier(s) to be used while
        transitioning to the route.
      @return {Transition} the transition object associated with this
        attempted transition
    */
    replaceWith: function () {
      var router = this.router;
      return router.replaceWith.apply(router, arguments);
    },

    /**
      Sends an action to the router, which will delegate it to the currently
      active route hierarchy per the bubbling rules explained under `actions`.
       Example
       ```javascript
      App.Router.map(function() {
        this.route('index');
      });
       App.ApplicationRoute = Ember.Route.extend({
        actions: {
          track: function(arg) {
            console.log(arg, 'was clicked');
          }
        }
      });
       App.IndexRoute = Ember.Route.extend({
        actions: {
          trackIfDebug: function(arg) {
            if (debug) {
              this.send('track', arg);
            }
          }
        }
      });
      ```
       @method send
      @param {String} name the name of the action to trigger
      @param {...*} args
    */
    send: function () {
      if (this.router || !Ember['default'].testing) {
        var _router;

        (_router = this.router).send.apply(_router, arguments);
      } else {
        var name = arguments[0];
        var args = slice.call(arguments, 1);
        var action = this._actions[name];
        if (action) {
          return this._actions[name].apply(this, args);
        }
      }
    },

    /**
      This hook is the entry point for router.js
       @private
      @method setup
    */
    setup: function (context, transition) {
      var controllerName = this.controllerName || this.routeName;
      var controller = this.controllerFor(controllerName, true);

      if (!controller) {
        controller = this.generateController(controllerName, context);
      }

      // Assign the route's controller so that it can more easily be
      // referenced in action handlers
      this.controller = controller;

      if (this.setupControllers) {
                this.setupControllers(controller, context);
      } else {
        var states = property_get.get(this, "_qp.states");
        if (transition) {
          // Update the model dep values used to calculate cache keys.
          ember_routing__utils.stashParamNames(this.router, transition.state.handlerInfos);
          controller._qpDelegate = states.changingKeys;
          controller._updateCacheParams(transition.params);
        }
        controller._qpDelegate = states.allowOverrides;

        if (transition) {
          var qpValues = getQueryParamsFor(this, transition.state);
          controller.setProperties(qpValues);
        }

        this.setupController(controller, context, transition);
      }

      if (this.renderTemplates) {
                this.renderTemplates(context);
      } else {
        this.renderTemplate(controller, context);
      }
    },

    /**
      This hook is the first of the route entry validation hooks
      called when an attempt is made to transition into a route
      or one of its children. It is called before `model` and
      `afterModel`, and is appropriate for cases when:
       1) A decision can be made to redirect elsewhere without
         needing to resolve the model first.
      2) Any async operations need to occur first before the
         model is attempted to be resolved.
       This hook is provided the current `transition` attempt
      as a parameter, which can be used to `.abort()` the transition,
      save it for a later `.retry()`, or retrieve values set
      on it from a previous hook. You can also just call
      `this.transitionTo` to another route to implicitly
      abort the `transition`.
       You can return a promise from this hook to pause the
      transition until the promise resolves (or rejects). This could
      be useful, for instance, for retrieving async code from
      the server that is required to enter a route.
       ```javascript
      App.PostRoute = Ember.Route.extend({
        beforeModel: function(transition) {
          if (!App.Post) {
            return Ember.$.getScript('/models/post.js');
          }
        }
      });
      ```
       If `App.Post` doesn't exist in the above example,
      `beforeModel` will use jQuery's `getScript`, which
      returns a promise that resolves after the server has
      successfully retrieved and executed the code from the
      server. Note that if an error were to occur, it would
      be passed to the `error` hook on `Ember.Route`, but
      it's also possible to handle errors specific to
      `beforeModel` right from within the hook (to distinguish
      from the shared error handling behavior of the `error`
      hook):
       ```javascript
      App.PostRoute = Ember.Route.extend({
        beforeModel: function(transition) {
          if (!App.Post) {
            var self = this;
            return Ember.$.getScript('post.js').then(null, function(e) {
              self.transitionTo('help');
               // Note that the above transitionTo will implicitly
              // halt the transition. If you were to return
              // nothing from this promise reject handler,
              // according to promise semantics, that would
              // convert the reject into a resolve and the
              // transition would continue. To propagate the
              // error so that it'd be handled by the `error`
              // hook, you would have to
              return Ember.RSVP.reject(e);
            });
          }
        }
      });
      ```
       @method beforeModel
      @param {Transition} transition
      @return {Promise} if the value returned from this hook is
        a promise, the transition will pause until the transition
        resolves. Otherwise, non-promise return values are not
        utilized in any way.
    */
    beforeModel: K,

    /**
      This hook is called after this route's model has resolved.
      It follows identical async/promise semantics to `beforeModel`
      but is provided the route's resolved model in addition to
      the `transition`, and is therefore suited to performing
      logic that can only take place after the model has already
      resolved.
       ```javascript
      App.PostsRoute = Ember.Route.extend({
        afterModel: function(posts, transition) {
          if (posts.get('length') === 1) {
            this.transitionTo('post.show', posts.get('firstObject'));
          }
        }
      });
      ```
       Refer to documentation for `beforeModel` for a description
      of transition-pausing semantics when a promise is returned
      from this hook.
       @method afterModel
      @param {Object} resolvedModel the value returned from `model`,
        or its resolved value if it was a promise
      @param {Transition} transition
      @return {Promise} if the value returned from this hook is
        a promise, the transition will pause until the transition
        resolves. Otherwise, non-promise return values are not
        utilized in any way.
     */
    afterModel: K,

    /**
      A hook you can implement to optionally redirect to another route.
       If you call `this.transitionTo` from inside of this hook, this route
      will not be entered in favor of the other hook.
       `redirect` and `afterModel` behave very similarly and are
      called almost at the same time, but they have an important
      distinction in the case that, from one of these hooks, a
      redirect into a child route of this route occurs: redirects
      from `afterModel` essentially invalidate the current attempt
      to enter this route, and will result in this route's `beforeModel`,
      `model`, and `afterModel` hooks being fired again within
      the new, redirecting transition. Redirects that occur within
      the `redirect` hook, on the other hand, will _not_ cause
      these hooks to be fired again the second time around; in
      other words, by the time the `redirect` hook has been called,
      both the resolved model and attempted entry into this route
      are considered to be fully validated.
       @method redirect
      @param {Object} model the model for this route
      @param {Transition} transition the transition object associated with the current transition
    */
    redirect: K,

    /**
      Called when the context is changed by router.js.
       @private
      @method contextDidChange
    */
    contextDidChange: function () {
      this.currentModel = this.context;
    },

    /**
      A hook you can implement to convert the URL into the model for
      this route.
       ```javascript
      App.Router.map(function() {
        this.resource('post', { path: '/posts/:post_id' });
      });
      ```
       The model for the `post` route is `store.find('post', params.post_id)`.
       By default, if your route has a dynamic segment ending in `_id`:
       * The model class is determined from the segment (`post_id`'s
        class is `App.Post`)
      * The find method is called on the model class with the value of
        the dynamic segment.
       Note that for routes with dynamic segments, this hook is not always
      executed. If the route is entered through a transition (e.g. when
      using the `link-to` Handlebars helper or the `transitionTo` method
      of routes), and a model context is already provided this hook
      is not called.
       A model context does not include a primitive string or number,
      which does cause the model hook to be called.
       Routes without dynamic segments will always execute the model hook.
       ```javascript
      // no dynamic segment, model hook always called
      this.transitionTo('posts');
       // model passed in, so model hook not called
      thePost = store.find('post', 1);
      this.transitionTo('post', thePost);
       // integer passed in, model hook is called
      this.transitionTo('post', 1);
      ```
        This hook follows the asynchronous/promise semantics
      described in the documentation for `beforeModel`. In particular,
      if a promise returned from `model` fails, the error will be
      handled by the `error` hook on `Ember.Route`.
       Example
       ```javascript
      App.PostRoute = Ember.Route.extend({
        model: function(params) {
          return this.store.find('post', params.post_id);
        }
      });
      ```
       @method model
      @param {Object} params the parameters extracted from the URL
      @param {Transition} transition
      @return {Object|Promise} the model for this route. If
        a promise is returned, the transition will pause until
        the promise resolves, and the resolved value of the promise
        will be used as the model for this route.
    */
    model: function (params, transition) {
      var match, name, sawParams, value;

      var queryParams = property_get.get(this, "_qp.map");

      for (var prop in params) {
        if (prop === "queryParams" || queryParams && prop in queryParams) {
          continue;
        }

        if (match = prop.match(/^(.*)_id$/)) {
          name = match[1];
          value = params[prop];
        }
        sawParams = true;
      }

      if (!name && sawParams) {
        return copy['default'](params);
      } else if (!name) {
        if (transition.resolveIndex < 1) {
          return;
        }

        var parentModel = transition.state.handlerInfos[transition.resolveIndex - 1].context;

        return parentModel;
      }

      return this.findModel(name, value);
    },

    /**
      @private
      @method deserialize
      @param {Object} params the parameters extracted from the URL
      @param {Transition} transition
      @return {Object|Promise} the model for this route.
       Router.js hook.
     */
    deserialize: function (params, transition) {
      return this.model(this.paramsFor(this.routeName), transition);
    },

    /**
       @method findModel
      @param {String} type the model type
      @param {Object} value the value passed to find
    */
    findModel: function () {
      var store = property_get.get(this, "store");
      return store.find.apply(store, arguments);
    },

    /**
      Store property provides a hook for data persistence libraries to inject themselves.
       By default, this store property provides the exact same functionality previously
      in the model hook.
       Currently, the required interface is:
       `store.find(modelName, findArguments)`
       @method store
      @param {Object} store
    */
    store: computed.computed(function () {
      var container = this.container;
      var routeName = this.routeName;
      var namespace = property_get.get(this, "router.namespace");

      return {
        find: function (name, value) {
          var modelClass = container.lookupFactory("model:" + name);

          
          if (!modelClass) {
            return;
          }

          
          return modelClass.find(value);
        }
      };
    }),

    /**
      A hook you can implement to convert the route's model into parameters
      for the URL.
       ```javascript
      App.Router.map(function() {
        this.resource('post', { path: '/posts/:post_id' });
      });
       App.PostRoute = Ember.Route.extend({
        model: function(params) {
          // the server returns `{ id: 12 }`
          return Ember.$.getJSON('/posts/' + params.post_id);
        },
         serialize: function(model) {
          // this will make the URL `/posts/12`
          return { post_id: model.id };
        }
      });
      ```
       The default `serialize` method will insert the model's `id` into the
      route's dynamic segment (in this case, `:post_id`) if the segment contains '_id'.
      If the route has multiple dynamic segments or does not contain '_id', `serialize`
      will return `Ember.getProperties(model, params)`
       This method is called when `transitionTo` is called with a context
      in order to populate the URL.
       @method serialize
      @param {Object} model the route's model
      @param {Array} params an Array of parameter names for the current
        route (in the example, `['post_id']`.
      @return {Object} the serialized parameters
    */
    serialize: function (model, params) {
      if (params.length < 1) {
        return;
      }
      if (!model) {
        return;
      }

      var name = params[0];
      var object = {};

      if (params.length === 1) {
        if (name in model) {
          object[name] = property_get.get(model, name);
        } else if (/_id$/.test(name)) {
          object[name] = property_get.get(model, "id");
        }
      } else {
        object = getProperties['default'](model, params);
      }

      return object;
    },

    /**
      A hook you can use to setup the controller for the current route.
       This method is called with the controller for the current route and the
      model supplied by the `model` hook.
       By default, the `setupController` hook sets the `model` property of
      the controller to the `model`.
       If you implement the `setupController` hook in your Route, it will
      prevent this default behavior. If you want to preserve that behavior
      when implementing your `setupController` function, make sure to call
      `_super`:
       ```javascript
      App.PhotosRoute = Ember.Route.extend({
        model: function() {
          return this.store.find('photo');
        },
         setupController: function (controller, model) {
          // Call _super for default behavior
          this._super(controller, model);
          // Implement your custom setup after
          this.controllerFor('application').set('showingPhotos', true);
        }
      });
      ```
       This means that your template will get a proxy for the model as its
      context, and you can act as though the model itself was the context.
       The provided controller will be one resolved based on the name
      of this route.
       If no explicit controller is defined, Ember will automatically create
      an appropriate controller for the model.
       * if the model is an `Ember.Array` (including record arrays from Ember
        Data), the controller is an `Ember.ArrayController`.
      * otherwise, the controller is an `Ember.ObjectController`.
       As an example, consider the router:
       ```javascript
      App.Router.map(function() {
        this.resource('post', { path: '/posts/:post_id' });
      });
      ```
       For the `post` route, a controller named `App.PostController` would
      be used if it is defined. If it is not defined, an `Ember.ObjectController`
      instance would be used.
       Example
       ```javascript
      App.PostRoute = Ember.Route.extend({
        setupController: function(controller, model) {
          controller.set('model', model);
        }
      });
      ```
       @method setupController
      @param {Controller} controller instance
      @param {Object} model
    */
    setupController: function (controller, context, transition) {
      if (controller && context !== undefined) {
        property_set.set(controller, "model", context);
      }
    },

    /**
      Returns the controller for a particular route or name.
       The controller instance must already have been created, either through entering the
      associated route or using `generateController`.
       ```javascript
      App.PostRoute = Ember.Route.extend({
        setupController: function(controller, post) {
          this._super(controller, post);
          this.controllerFor('posts').set('currentPost', post);
        }
      });
      ```
       @method controllerFor
      @param {String} name the name of the route or controller
      @return {Ember.Controller}
    */
    controllerFor: function (name, _skipAssert) {
      var container = this.container;
      var route = container.lookup("route:" + name);
      var controller;

      if (route && route.controllerName) {
        name = route.controllerName;
      }

      controller = container.lookup("controller:" + name);

      // NOTE: We're specifically checking that skipAssert is true, because according
      //   to the old API the second parameter was model. We do not want people who
      //   passed a model to skip the assertion.
      
      return controller;
    },

    /**
      Generates a controller for a route.
       If the optional model is passed then the controller type is determined automatically,
      e.g., an ArrayController for arrays.
       Example
       ```javascript
      App.PostRoute = Ember.Route.extend({
        setupController: function(controller, post) {
          this._super(controller, post);
          this.generateController('posts', post);
        }
      });
      ```
       @method generateController
      @param {String} name the name of the controller
      @param {Object} model the model to infer the type of the controller (optional)
    */
    generateController: function (name, model) {
      var container = this.container;

      model = model || this.modelFor(name);

      return generateController['default'](container, name, model);
    },

    /**
      Returns the model of a parent (or any ancestor) route
      in a route hierarchy.  During a transition, all routes
      must resolve a model object, and if a route
      needs access to a parent route's model in order to
      resolve a model (or just reuse the model from a parent),
      it can call `this.modelFor(theNameOfParentRoute)` to
      retrieve it.
       Example
       ```javascript
      App.Router.map(function() {
          this.resource('post', { path: '/post/:post_id' }, function() {
              this.resource('comments');
          });
      });
       App.CommentsRoute = Ember.Route.extend({
          afterModel: function() {
              this.set('post', this.modelFor('post'));
          }
      });
      ```
       @method modelFor
      @param {String} name the name of the route
      @return {Object} the model object
    */
    modelFor: function (name) {
      var route = this.container.lookup("route:" + name);
      var transition = this.router ? this.router.router.activeTransition : null;

      // If we are mid-transition, we want to try and look up
      // resolved parent contexts on the current transitionEvent.
      if (transition) {
        var modelLookupName = route && route.routeName || name;
        if (transition.resolvedModels.hasOwnProperty(modelLookupName)) {
          return transition.resolvedModels[modelLookupName];
        }
      }

      return route && route.currentModel;
    },

    /**
      A hook you can use to render the template for the current route.
       This method is called with the controller for the current route and the
      model supplied by the `model` hook. By default, it renders the route's
      template, configured with the controller for the route.
       This method can be overridden to set up and render additional or
      alternative templates.
       ```javascript
      App.PostsRoute = Ember.Route.extend({
        renderTemplate: function(controller, model) {
          var favController = this.controllerFor('favoritePost');
           // Render the `favoritePost` template into
          // the outlet `posts`, and display the `favoritePost`
          // controller.
          this.render('favoritePost', {
            outlet: 'posts',
            controller: favController
          });
        }
      });
      ```
       @method renderTemplate
      @param {Object} controller the route's controller
      @param {Object} model the route's model
    */
    renderTemplate: function (controller, model) {
      this.render();
    },

    /**
      `render` is used to render a template into a region of another template
      (indicated by an `{{outlet}}`). `render` is used both during the entry
      phase of routing (via the `renderTemplate` hook) and later in response to
      user interaction.
       For example, given the following minimal router and templates:
       ```javascript
      Router.map(function() {
        this.resource('photos');
      });
      ```
       ```handlebars
      <!-- application.hbs -->
      <div class='something-in-the-app-hbs'>
        {{outlet "anOutletName"}}
      </div>
      ```
       ```handlebars
      <!-- photos.hbs -->
      <h1>Photos</h1>
      ```
       You can render `photos.hbs` into the `"anOutletName"` outlet of
      `application.hbs` by calling `render`:
       ```javascript
      // posts route
      Ember.Route.extend({
        renderTemplate: function() {
          this.render('photos', {
            into: 'application',
            outlet: 'anOutletName'
          })
        }
      });
      ```
       `render` additionally allows you to supply which `view`, `controller`, and
      `model` objects should be loaded and associated with the rendered template.
        ```javascript
      // posts route
      Ember.Route.extend({
        renderTemplate: function(controller, model){
          this.render('posts', {    // the template to render, referenced by name
            into: 'application',    // the template to render into, referenced by name
            outlet: 'anOutletName', // the outlet inside `options.template` to render into.
            view: 'aViewName',      // the view to use for this template, referenced by name
            controller: 'someControllerName', // the controller to use for this template, referenced by name
            model: model            // the model to set on `options.controller`.
          })
        }
      });
      ```
       The string values provided for the template name, view, and controller
      will eventually pass through to the resolver for lookup. See
      Ember.Resolver for how these are mapped to JavaScript objects in your
      application.
       Not all options need to be passed to `render`. Default values will be used
      based on the name of the route specified in the router or the Route's
      `controllerName`, `viewName` and `templateName` properties.
       For example:
       ```javascript
      // router
      Router.map(function() {
        this.route('index');
        this.resource('post', { path: '/posts/:post_id' });
      });
      ```
       ```javascript
      // post route
      PostRoute = App.Route.extend({
        renderTemplate: function() {
          this.render(); // all defaults apply
        }
      });
      ```
       The name of the `PostRoute`, defined by the router, is `post`.
       The following equivalent default options will be applied when
      the Route calls `render`:
       ```javascript
      //
      this.render('post', {  // the template name associated with 'post' Route
        into: 'application', // the parent route to 'post' Route
        outlet: 'main',      // {{outlet}} and {{outlet 'main' are synonymous}},
        view: 'post',        // the view associated with the 'post' Route
        controller: 'post',  // the controller associated with the 'post' Route
      })
      ```
       By default the controller's `model` will be the route's model, so it does not
      need to be passed unless you wish to change which model is being used.
       @method render
      @param {String} name the name of the template to render
      @param {Object} [options] the options
      @param {String} [options.into] the template to render into,
                      referenced by name. Defaults to the parent template
      @param {String} [options.outlet] the outlet inside `options.template` to render into.
                      Defaults to 'main'
      @param {String|Object} [options.controller] the controller to use for this template,
                      referenced by name or as a controller instance. Defaults to the Route's paired controller
      @param {Object} [options.model] the model object to set on `options.controller`.
                      Defaults to the return value of the Route's model hook
    */
    render: function (_name, options) {
      
      var namePassed = typeof _name === "string" && !!_name;
      var isDefaultRender = arguments.length === 0 || Ember['default'].isEmpty(arguments[0]);
      var name;

      if (typeof _name === "object" && !options) {
        name = this.routeName;
        options = _name;
      } else {
        name = _name;
      }

      var renderOptions = buildRenderOptions(this, namePassed, isDefaultRender, name, options);
      this.connections.push(renderOptions);
      run['default'].once(this.router, "_setOutlets");
    },

    /**
      Disconnects a view that has been rendered into an outlet.
       You may pass any or all of the following options to `disconnectOutlet`:
       * `outlet`: the name of the outlet to clear (default: 'main')
      * `parentView`: the name of the view containing the outlet to clear
         (default: the view rendered by the parent route)
       Example:
       ```javascript
      App.ApplicationRoute = App.Route.extend({
        actions: {
          showModal: function(evt) {
            this.render(evt.modalName, {
              outlet: 'modal',
              into: 'application'
            });
          },
          hideModal: function(evt) {
            this.disconnectOutlet({
              outlet: 'modal',
              parentView: 'application'
            });
          }
        }
      });
      ```
       Alternatively, you can pass the `outlet` name directly as a string.
       Example:
       ```javascript
      hideModal: function(evt) {
        this.disconnectOutlet('modal');
      }
      ```
       @method disconnectOutlet
      @param {Object|String} options the options hash or outlet name
    */
    disconnectOutlet: function (options) {
      var outletName;
      var parentView;
      if (!options || typeof options === "string") {
        outletName = options;
      } else {
        outletName = options.outlet;
        parentView = options.parentView;
      }
      parentView = parentView && parentView.replace(/\//g, ".");
      outletName = outletName || "main";
      this._disconnectOutlet(outletName, parentView);
      for (var i = 0; i < this.router.router.currentHandlerInfos.length; i++) {
        // This non-local state munging is sadly necessary to maintain
        // backward compatibility with our existing semantics, which allow
        // any route to disconnectOutlet things originally rendered by any
        // other route. This should all get cut in 2.0.
        this.router.router.currentHandlerInfos[i].handler._disconnectOutlet(outletName, parentView);
      }
    },

    _disconnectOutlet: function (outletName, parentView) {
      var parent = parentRoute(this);
      if (parent && parentView === parent.routeName) {
        parentView = undefined;
      }
      for (var i = 0; i < this.connections.length; i++) {
        var connection = this.connections[i];
        if (connection.outlet === outletName && connection.into === parentView) {
          // This neuters the disconnected outlet such that it doesn't
          // render anything, but it leaves an entry in the outlet
          // hierarchy so that any existing other renders that target it
          // don't suddenly blow up. They will still stick themselves
          // into its outlets, which won't render anywhere. All of this
          // statefulness should get the machete in 2.0.
          this.connections[i] = {
            into: connection.into,
            outlet: connection.outlet,
            name: connection.name
          };
          run['default'].once(this.router, "_setOutlets");
        }
      }
    },

    willDestroy: function () {
      this.teardownViews();
    },

    /**
      @private
       @method teardownViews
    */
    teardownViews: function () {
      if (this.connections && this.connections.length > 0) {
        this.connections = [];
        run['default'].once(this.router, "_setOutlets");
      }
    }
  });

  var defaultQPMeta = {
    qps: [],
    map: {},
    states: {}
  };

  function parentRoute(route) {
    var handlerInfo = handlerInfoFor(route, route.router.router.state.handlerInfos, -1);
    return handlerInfo && handlerInfo.handler;
  }

  function handlerInfoFor(route, handlerInfos, _offset) {
    if (!handlerInfos) {
      return;
    }

    var offset = _offset || 0;
    var current;
    for (var i = 0, l = handlerInfos.length; i < l; i++) {
      current = handlerInfos[i].handler;
      if (current === route) {
        return handlerInfos[i + offset];
      }
    }
  }

  function buildRenderOptions(route, namePassed, isDefaultRender, name, options) {
    var controller = options && options.controller;
    var templateName;
    var viewName;
    var ViewClass;
    var template;
    var LOG_VIEW_LOOKUPS = property_get.get(route.router, "namespace.LOG_VIEW_LOOKUPS");
    var into = options && options.into && options.into.replace(/\//g, ".");
    var outlet = options && options.outlet || "main";

    if (name) {
      name = name.replace(/\//g, ".");
      templateName = name;
    } else {
      name = route.routeName;
      templateName = route.templateName || name;
    }

    if (!controller) {
      if (namePassed) {
        controller = route.container.lookup("controller:" + name) || route.controllerName || route.routeName;
      } else {
        controller = route.controllerName || route.container.lookup("controller:" + name);
      }
    }

    if (typeof controller === "string") {
      var controllerName = controller;
      controller = route.container.lookup("controller:" + controllerName);
      if (!controller) {
        throw new EmberError['default']("You passed `controller: '" + controllerName + "'` into the `render` method, but no such controller could be found.");
      }
    }

    if (options && options.model) {
      controller.set("model", options.model);
    }

    viewName = options && options.view || namePassed && name || route.viewName || name;
    ViewClass = route.container.lookupFactory("view:" + viewName);
    template = route.container.lookup("template:" + templateName);
    if (!ViewClass && !template) {
            if (LOG_VIEW_LOOKUPS) {
              }
    }

    var parent;
    if (into && (parent = parentRoute(route)) && into === parentRoute(route).routeName) {
      into = undefined;
    }

    var renderOptions = {
      into: into,
      outlet: outlet,
      name: name,
      controller: controller,
      ViewClass: ViewClass,
      template: template
    };

    return renderOptions;
  }

  function getFullQueryParams(router, state) {
    if (state.fullQueryParams) {
      return state.fullQueryParams;
    }

    state.fullQueryParams = {};
    merge['default'](state.fullQueryParams, state.queryParams);

    var targetRouteName = state.handlerInfos[state.handlerInfos.length - 1].name;
    router._deserializeQueryParams(targetRouteName, state.fullQueryParams);
    return state.fullQueryParams;
  }

  function getQueryParamsFor(route, state) {
    state.queryParamsFor = state.queryParamsFor || {};
    var name = route.routeName;

    if (state.queryParamsFor[name]) {
      return state.queryParamsFor[name];
    }

    var fullQueryParams = getFullQueryParams(route.router, state);

    var params = state.queryParamsFor[name] = {};

    // Copy over all the query params for this route/controller into params hash.
    var qpMeta = property_get.get(route, "_qp");
    var qps = qpMeta.qps;
    for (var i = 0, len = qps.length; i < len; ++i) {
      // Put deserialized qp on params hash.
      var qp = qps[i];

      var qpValueWasPassedIn = (qp.prop in fullQueryParams);
      params[qp.prop] = qpValueWasPassedIn ? fullQueryParams[qp.prop] : copyDefaultValue(qp.def);
    }

    return params;
  }

  function copyDefaultValue(value) {
    if (utils.isArray(value)) {
      return Ember['default'].A(value.slice());
    }
    return value;
  }

  exports['default'] = Route;

});
enifed('ember-routing/system/router', ['exports', 'ember-metal/core', 'ember-metal/error', 'ember-metal/property_get', 'ember-metal/property_set', 'ember-metal/properties', 'ember-metal/computed', 'ember-metal/merge', 'ember-metal/run_loop', 'ember-runtime/system/string', 'ember-runtime/system/object', 'ember-runtime/mixins/evented', 'ember-routing/system/dsl', 'ember-routing/location/api', 'ember-routing/utils', 'ember-metal/platform/create', './router_state', 'router', 'router/transition'], function (exports, Ember, EmberError, property_get, property_set, properties, computed, merge, run, string, EmberObject, Evented, EmberRouterDSL, EmberLocation, utils, create, RouterState, Router) {

  'use strict';

  function K() {
    return this;
  }

  var slice = [].slice;

  /**
    The `Ember.Router` class manages the application state and URLs. Refer to
    the [routing guide](http://emberjs.com/guides/routing/) for documentation.

    @class Router
    @namespace Ember
    @extends Ember.Object
    @uses Ember.Evented
  */
  var EmberRouter = EmberObject['default'].extend(Evented['default'], {
    /**
      The `location` property determines the type of URL's that your
      application will use.
       The following location types are currently available:
       * `auto`
      * `hash`
      * `history`
      * `none`
       @property location
      @default 'hash'
      @see {Ember.Location}
    */
    location: "hash",

    /**
     Represents the URL of the root of the application, often '/'. This prefix is
     assumed on all routes defined on this router.
      @property rootURL
     @default '/'
    */
    rootURL: "/",

    _initRouterJs: function (moduleBasedResolver) {
      var router = this.router = new Router['default']();
      router.triggerEvent = triggerEvent;

      router._triggerWillChangeContext = K;
      router._triggerWillLeave = K;

      var dslCallbacks = this.constructor.dslCallbacks || [K];
      var dsl = new EmberRouterDSL['default'](null, {
        enableLoadingSubstates: !!moduleBasedResolver
      });

      function generateDSL() {
        this.resource("application", { path: "/", overrideNameAssertion: true }, function () {
          for (var i = 0; i < dslCallbacks.length; i++) {
            dslCallbacks[i].call(this);
          }
        });
      }

      generateDSL.call(dsl);

      if (property_get.get(this, "namespace.LOG_TRANSITIONS_INTERNAL")) {
        router.log = Ember['default'].Logger.debug;
      }

      router.map(dsl.generate());
    },

    init: function () {
      this._activeViews = {};
      this._qpCache = {};
      this._queuedQPChanges = {};
    },

    /**
      Represents the current URL.
       @method url
      @return {String} The current URL.
    */
    url: computed.computed(function () {
      return property_get.get(this, "location").getURL();
    }),

    /**
      Initializes the current router instance and sets up the change handling
      event listeners used by the instances `location` implementation.
       A property named `initialURL` will be used to determine the initial URL.
      If no value is found `/` will be used.
       @method startRouting
      @private
    */
    startRouting: function (moduleBasedResolver) {
      var initialURL = property_get.get(this, "initialURL");

      if (this.setupRouter(moduleBasedResolver)) {
        if (typeof initialURL === "undefined") {
          initialURL = property_get.get(this, "location").getURL();
        }
        var initialTransition = this.handleURL(initialURL);
        if (initialTransition && initialTransition.error) {
          throw initialTransition.error;
        }
      }
    },

    setupRouter: function (moduleBasedResolver) {
      this._initRouterJs(moduleBasedResolver);
      this._setupLocation();

      var router = this.router;
      var location = property_get.get(this, "location");
      var self = this;

      // Allow the Location class to cancel the router setup while it refreshes
      // the page
      if (property_get.get(location, "cancelRouterSetup")) {
        return false;
      }

      this._setupRouter(router, location);

      location.onUpdateURL(function (url) {
        self.handleURL(url);
      });

      return true;
    },

    /**
      Handles updating the paths and notifying any listeners of the URL
      change.
       Triggers the router level `didTransition` hook.
       @method didTransition
      @private
      @since 1.2.0
    */
    didTransition: function (infos) {
      updatePaths(this);

      this._cancelSlowTransitionTimer();

      this.notifyPropertyChange("url");
      this.set("currentState", this.targetState);

      // Put this in the runloop so url will be accurate. Seems
      // less surprising than didTransition being out of sync.
      run['default'].once(this, this.trigger, "didTransition");

      if (property_get.get(this, "namespace").LOG_TRANSITIONS) {
        Ember['default'].Logger.log("Transitioned into '" + EmberRouter._routePath(infos) + "'");
      }
    },

    _setOutlets: function () {
      var handlerInfos = this.router.currentHandlerInfos;
      var route;
      var defaultParentState;
      var liveRoutes = null;

      if (!handlerInfos) {
        return;
      }

      for (var i = 0; i < handlerInfos.length; i++) {
        route = handlerInfos[i].handler;
        var connections = route.connections;
        var ownState;
        for (var j = 0; j < connections.length; j++) {
          var appended = appendLiveRoute(liveRoutes, defaultParentState, connections[j]);
          liveRoutes = appended.liveRoutes;
          if (appended.ownState.render.name === route.routeName || appended.ownState.render.outlet === "main") {
            ownState = appended.ownState;
          }
        }
        if (connections.length === 0) {
          ownState = representEmptyRoute(liveRoutes, defaultParentState, route);
        }
        defaultParentState = ownState;
      }
      if (!this._toplevelView) {
        var OutletView = this.container.lookupFactory("view:-outlet");
        this._toplevelView = OutletView.create({ _isTopLevel: true });
        var instance = this.container.lookup("-application-instance:main");
        instance.didCreateRootView(this._toplevelView);
      }
      this._toplevelView.setOutletState(liveRoutes);
    },

    /**
      Handles notifying any listeners of an impending URL
      change.
       Triggers the router level `willTransition` hook.
       @method willTransition
      @private
      @since 1.11.0
    */
    willTransition: function (oldInfos, newInfos, transition) {
      run['default'].once(this, this.trigger, "willTransition", transition);

      if (property_get.get(this, "namespace").LOG_TRANSITIONS) {
        Ember['default'].Logger.log("Preparing to transition from '" + EmberRouter._routePath(oldInfos) + "' to '" + EmberRouter._routePath(newInfos) + "'");
      }
    },

    handleURL: function (url) {
      // Until we have an ember-idiomatic way of accessing #hashes, we need to
      // remove it because router.js doesn't know how to handle it.
      url = url.split(/#(.+)?/)[0];
      return this._doURLTransition("handleURL", url);
    },

    _doURLTransition: function (routerJsMethod, url) {
      var transition = this.router[routerJsMethod](url || "/");
      didBeginTransition(transition, this);
      return transition;
    },

    transitionTo: function () {
      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      var queryParams;
      if (resemblesURL(args[0])) {
        return this._doURLTransition("transitionTo", args[0]);
      }

      var possibleQueryParams = args[args.length - 1];
      if (possibleQueryParams && possibleQueryParams.hasOwnProperty("queryParams")) {
        queryParams = args.pop().queryParams;
      } else {
        queryParams = {};
      }

      var targetRouteName = args.shift();
      return this._doTransition(targetRouteName, args, queryParams);
    },

    intermediateTransitionTo: function () {
      var _router;

      (_router = this.router).intermediateTransitionTo.apply(_router, arguments);

      updatePaths(this);

      var infos = this.router.currentHandlerInfos;
      if (property_get.get(this, "namespace").LOG_TRANSITIONS) {
        Ember['default'].Logger.log("Intermediate-transitioned into '" + EmberRouter._routePath(infos) + "'");
      }
    },

    replaceWith: function () {
      return this.transitionTo.apply(this, arguments).method("replace");
    },

    generate: function () {
      var _router2;

      var url = (_router2 = this.router).generate.apply(_router2, arguments);
      return this.location.formatURL(url);
    },

    /**
      Determines if the supplied route is currently active.
       @method isActive
      @param routeName
      @return {Boolean}
      @private
    */
    isActive: function (routeName) {
      var router = this.router;
      return router.isActive.apply(router, arguments);
    },

    /**
      An alternative form of `isActive` that doesn't require
      manual concatenation of the arguments into a single
      array.
       @method isActiveIntent
      @param routeName
      @param models
      @param queryParams
      @return {Boolean}
      @private
      @since 1.7.0
    */
    isActiveIntent: function (routeName, models, queryParams) {
      return this.currentState.isActiveIntent(routeName, models, queryParams);
    },

    send: function (name, context) {
      var _router3;

      (_router3 = this.router).trigger.apply(_router3, arguments);
    },

    /**
      Does this router instance have the given route.
       @method hasRoute
      @return {Boolean}
      @private
    */
    hasRoute: function (route) {
      return this.router.hasRoute(route);
    },

    /**
      Resets the state of the router by clearing the current route
      handlers and deactivating them.
       @private
      @method reset
     */
    reset: function () {
      if (this.router) {
        this.router.reset();
      }
    },

    willDestroy: function () {
      if (this._toplevelView) {
        this._toplevelView.destroy();
        this._toplevelView = null;
      }
      this._super.apply(this, arguments);
      this.reset();
    },

    _lookupActiveView: function (templateName) {
      var active = this._activeViews[templateName];
      return active && active[0];
    },

    _connectActiveView: function (templateName, view) {
      var existing = this._activeViews[templateName];

      if (existing) {
        existing[0].off("willDestroyElement", this, existing[1]);
      }

      function disconnectActiveView() {
        delete this._activeViews[templateName];
      }

      this._activeViews[templateName] = [view, disconnectActiveView];
      view.one("willDestroyElement", this, disconnectActiveView);
    },

    _setupLocation: function () {
      var location = property_get.get(this, "location");
      var rootURL = property_get.get(this, "rootURL");

      if ("string" === typeof location && this.container) {
        var resolvedLocation = this.container.lookup("location:" + location);

        if ("undefined" !== typeof resolvedLocation) {
          location = property_set.set(this, "location", resolvedLocation);
        } else {
          // Allow for deprecated registration of custom location API's
          var options = {
            implementation: location
          };

          location = property_set.set(this, "location", EmberLocation['default'].create(options));
        }
      }

      if (location !== null && typeof location === "object") {
        if (rootURL) {
          property_set.set(location, "rootURL", rootURL);
        }

        // Allow the location to do any feature detection, such as AutoLocation
        // detecting history support. This gives it a chance to set its
        // `cancelRouterSetup` property which aborts routing.
        if (typeof location.detect === "function") {
          location.detect();
        }

        // ensure that initState is called AFTER the rootURL is set on
        // the location instance
        if (typeof location.initState === "function") {
          location.initState();
        }
      }
    },

    _getHandlerFunction: function () {
      var seen = create['default'](null);
      var container = this.container;
      var DefaultRoute = container.lookupFactory("route:basic");
      var self = this;

      return function (name) {
        var routeName = "route:" + name;
        var handler = container.lookup(routeName);

        if (seen[name]) {
          return handler;
        }

        seen[name] = true;

        if (!handler) {
          container._registry.register(routeName, DefaultRoute.extend());
          handler = container.lookup(routeName);

          if (property_get.get(self, "namespace.LOG_ACTIVE_GENERATION")) {
                      }
        }

        handler.routeName = name;
        return handler;
      };
    },

    _setupRouter: function (router, location) {
      var lastURL;
      var emberRouter = this;

      router.getHandler = this._getHandlerFunction();

      var doUpdateURL = function () {
        location.setURL(lastURL);
      };

      router.updateURL = function (path) {
        lastURL = path;
        run['default'].once(doUpdateURL);
      };

      if (location.replaceURL) {
        var doReplaceURL = function () {
          location.replaceURL(lastURL);
        };

        router.replaceURL = function (path) {
          lastURL = path;
          run['default'].once(doReplaceURL);
        };
      }

      router.didTransition = function (infos) {
        emberRouter.didTransition(infos);
      };

      
        router.willTransition = function (oldInfos, newInfos, transition) {
          emberRouter.willTransition(oldInfos, newInfos, transition);
        };
      
    },

    _serializeQueryParams: function (targetRouteName, queryParams) {
      var groupedByUrlKey = {};

      forEachQueryParam(this, targetRouteName, queryParams, function (key, value, qp) {
        var urlKey = qp.urlKey;
        if (!groupedByUrlKey[urlKey]) {
          groupedByUrlKey[urlKey] = [];
        }
        groupedByUrlKey[urlKey].push({
          qp: qp,
          value: value
        });
        delete queryParams[key];
      });

      for (var key in groupedByUrlKey) {
        var qps = groupedByUrlKey[key];
                var qp = qps[0].qp;
        queryParams[qp.urlKey] = qp.route.serializeQueryParam(qps[0].value, qp.urlKey, qp.type);
      }
    },

    _deserializeQueryParams: function (targetRouteName, queryParams) {
      forEachQueryParam(this, targetRouteName, queryParams, function (key, value, qp) {
        delete queryParams[key];
        queryParams[qp.prop] = qp.route.deserializeQueryParam(value, qp.urlKey, qp.type);
      });
    },

    _pruneDefaultQueryParamValues: function (targetRouteName, queryParams) {
      var qps = this._queryParamsFor(targetRouteName);
      for (var key in queryParams) {
        var qp = qps.map[key];
        if (qp && qp.sdef === queryParams[key]) {
          delete queryParams[key];
        }
      }
    },

    _doTransition: function (_targetRouteName, models, _queryParams) {
      var targetRouteName = _targetRouteName || utils.getActiveTargetName(this.router);
      
      var queryParams = {};
      merge['default'](queryParams, _queryParams);
      this._prepareQueryParams(targetRouteName, models, queryParams);

      var transitionArgs = utils.routeArgs(targetRouteName, models, queryParams);
      var transitionPromise = this.router.transitionTo.apply(this.router, transitionArgs);

      didBeginTransition(transitionPromise, this);

      return transitionPromise;
    },

    _prepareQueryParams: function (targetRouteName, models, queryParams) {
      this._hydrateUnsuppliedQueryParams(targetRouteName, models, queryParams);
      this._serializeQueryParams(targetRouteName, queryParams);
      this._pruneDefaultQueryParamValues(targetRouteName, queryParams);
    },

    /**
      Returns a merged query params meta object for a given route.
      Useful for asking a route what its known query params are.
     */
    _queryParamsFor: function (leafRouteName) {
      if (this._qpCache[leafRouteName]) {
        return this._qpCache[leafRouteName];
      }

      var map = {};
      var qps = [];
      this._qpCache[leafRouteName] = {
        map: map,
        qps: qps
      };

      var routerjs = this.router;
      var recogHandlerInfos = routerjs.recognizer.handlersFor(leafRouteName);

      for (var i = 0, len = recogHandlerInfos.length; i < len; ++i) {
        var recogHandler = recogHandlerInfos[i];
        var route = routerjs.getHandler(recogHandler.handler);
        var qpMeta = property_get.get(route, "_qp");

        if (!qpMeta) {
          continue;
        }

        merge['default'](map, qpMeta.map);
        qps.push.apply(qps, qpMeta.qps);
      }

      return {
        qps: qps,
        map: map
      };
    },

    /*
      becomeResolved: function(payload, resolvedContext) {
        var params = this.serialize(resolvedContext);
         if (payload) {
          this.stashResolvedModel(payload, resolvedContext);
          payload.params = payload.params || {};
          payload.params[this.name] = params;
        }
         return this.factory('resolved', {
          context: resolvedContext,
          name: this.name,
          handler: this.handler,
          params: params
        });
      },
    */

    _hydrateUnsuppliedQueryParams: function (leafRouteName, contexts, queryParams) {
      var state = calculatePostTransitionState(this, leafRouteName, contexts);
      var handlerInfos = state.handlerInfos;
      var appCache = this._bucketCache;

      utils.stashParamNames(this, handlerInfos);

      for (var i = 0, len = handlerInfos.length; i < len; ++i) {
        var route = handlerInfos[i].handler;
        var qpMeta = property_get.get(route, "_qp");

        for (var j = 0, qpLen = qpMeta.qps.length; j < qpLen; ++j) {
          var qp = qpMeta.qps[j];
          var presentProp = qp.prop in queryParams && qp.prop || qp.fprop in queryParams && qp.fprop;

          if (presentProp) {
            if (presentProp !== qp.fprop) {
              queryParams[qp.fprop] = queryParams[presentProp];
              delete queryParams[presentProp];
            }
          } else {
            var controllerProto = qp.cProto;
            var cacheMeta = property_get.get(controllerProto, "_cacheMeta");

            var cacheKey = controllerProto._calculateCacheKey(qp.ctrl, cacheMeta[qp.prop].parts, state.params);
            queryParams[qp.fprop] = appCache.lookup(cacheKey, qp.prop, qp.def);
          }
        }
      }
    },

    _scheduleLoadingEvent: function (transition, originRoute) {
      this._cancelSlowTransitionTimer();
      this._slowTransitionTimer = run['default'].scheduleOnce("routerTransitions", this, "_handleSlowTransition", transition, originRoute);
    },

    currentState: null,
    targetState: null,

    _handleSlowTransition: function (transition, originRoute) {
      if (!this.router.activeTransition) {
        // Don't fire an event if we've since moved on from
        // the transition that put us in a loading state.
        return;
      }

      this.set("targetState", RouterState['default'].create({
        emberRouter: this,
        routerJs: this.router,
        routerJsState: this.router.activeTransition.state
      }));

      transition.trigger(true, "loading", transition, originRoute);
    },

    _cancelSlowTransitionTimer: function () {
      if (this._slowTransitionTimer) {
        run['default'].cancel(this._slowTransitionTimer);
      }
      this._slowTransitionTimer = null;
    }
  });

  /*
    Helper function for iterating root-ward, starting
    from (but not including) the provided `originRoute`.

    Returns true if the last callback fired requested
    to bubble upward.

    @private
   */
  function forEachRouteAbove(originRoute, transition, callback) {
    var handlerInfos = transition.state.handlerInfos;
    var originRouteFound = false;
    var handlerInfo, route;

    for (var i = handlerInfos.length - 1; i >= 0; --i) {
      handlerInfo = handlerInfos[i];
      route = handlerInfo.handler;

      if (!originRouteFound) {
        if (originRoute === route) {
          originRouteFound = true;
        }
        continue;
      }

      if (callback(route, handlerInfos[i + 1].handler) !== true) {
        return false;
      }
    }
    return true;
  }

  // These get invoked when an action bubbles above ApplicationRoute
  // and are not meant to be overridable.
  var defaultActionHandlers = {

    willResolveModel: function (transition, originRoute) {
      originRoute.router._scheduleLoadingEvent(transition, originRoute);
    },

    error: function (error, transition, originRoute) {
      // Attempt to find an appropriate error substate to enter.
      var router = originRoute.router;

      var tryTopLevel = forEachRouteAbove(originRoute, transition, function (route, childRoute) {
        var childErrorRouteName = findChildRouteName(route, childRoute, "error");
        if (childErrorRouteName) {
          router.intermediateTransitionTo(childErrorRouteName, error);
          return;
        }
        return true;
      });

      if (tryTopLevel) {
        // Check for top-level error state to enter.
        if (routeHasBeenDefined(originRoute.router, "application_error")) {
          router.intermediateTransitionTo("application_error", error);
          return;
        }
      }

      logError(error, "Error while processing route: " + transition.targetName);
    },

    loading: function (transition, originRoute) {
      // Attempt to find an appropriate loading substate to enter.
      var router = originRoute.router;

      var tryTopLevel = forEachRouteAbove(originRoute, transition, function (route, childRoute) {
        var childLoadingRouteName = findChildRouteName(route, childRoute, "loading");

        if (childLoadingRouteName) {
          router.intermediateTransitionTo(childLoadingRouteName);
          return;
        }

        // Don't bubble above pivot route.
        if (transition.pivotHandler !== route) {
          return true;
        }
      });

      if (tryTopLevel) {
        // Check for top-level loading state to enter.
        if (routeHasBeenDefined(originRoute.router, "application_loading")) {
          router.intermediateTransitionTo("application_loading");
          return;
        }
      }
    }
  };

  function logError(_error, initialMessage) {
    var errorArgs = [];
    var error;
    if (_error && typeof _error === "object" && typeof _error.errorThrown === "object") {
      error = _error.errorThrown;
    } else {
      error = _error;
    }

    if (initialMessage) {
      errorArgs.push(initialMessage);
    }

    if (error) {
      if (error.message) {
        errorArgs.push(error.message);
      }
      if (error.stack) {
        errorArgs.push(error.stack);
      }

      if (typeof error === "string") {
        errorArgs.push(error);
      }
    }

    Ember['default'].Logger.error.apply(this, errorArgs);
  }

  function findChildRouteName(parentRoute, originatingChildRoute, name) {
    var router = parentRoute.router;
    var childName;
    var targetChildRouteName = originatingChildRoute.routeName.split(".").pop();
    var namespace = parentRoute.routeName === "application" ? "" : parentRoute.routeName + ".";

    
      // First, try a named loading state, e.g. 'foo_loading'
      childName = namespace + targetChildRouteName + "_" + name;
      if (routeHasBeenDefined(router, childName)) {
        return childName;
      }
    

    // Second, try general loading state, e.g. 'loading'
    childName = namespace + name;
    if (routeHasBeenDefined(router, childName)) {
      return childName;
    }
  }

  function routeHasBeenDefined(router, name) {
    var container = router.container;
    return router.hasRoute(name) && (container._registry.has("template:" + name) || container._registry.has("route:" + name));
  }

  function triggerEvent(handlerInfos, ignoreFailure, args) {
    var name = args.shift();

    if (!handlerInfos) {
      if (ignoreFailure) {
        return;
      }
      throw new EmberError['default']("Can't trigger action '" + name + "' because your app hasn't finished transitioning into its first route. To trigger an action on destination routes during a transition, you can call `.send()` on the `Transition` object passed to the `model/beforeModel/afterModel` hooks.");
    }

    var eventWasHandled = false;
    var handlerInfo, handler;

    for (var i = handlerInfos.length - 1; i >= 0; i--) {
      handlerInfo = handlerInfos[i];
      handler = handlerInfo.handler;

      if (handler._actions && handler._actions[name]) {
        if (handler._actions[name].apply(handler, args) === true) {
          eventWasHandled = true;
        } else {
          return;
        }
      }
    }

    if (defaultActionHandlers[name]) {
      defaultActionHandlers[name].apply(null, args);
      return;
    }

    if (!eventWasHandled && !ignoreFailure) {
      throw new EmberError['default']("Nothing handled the action '" + name + "'. If you did handle the action, this error can be caused by returning true from an action handler in a controller, causing the action to bubble.");
    }
  }

  function calculatePostTransitionState(emberRouter, leafRouteName, contexts) {
    var routerjs = emberRouter.router;
    var state = routerjs.applyIntent(leafRouteName, contexts);
    var handlerInfos = state.handlerInfos;
    var params = state.params;

    for (var i = 0, len = handlerInfos.length; i < len; ++i) {
      var handlerInfo = handlerInfos[i];
      if (!handlerInfo.isResolved) {
        handlerInfo = handlerInfo.becomeResolved(null, handlerInfo.context);
      }
      params[handlerInfo.name] = handlerInfo.params;
    }
    return state;
  }

  function updatePaths(router) {
    var appController = router.container.lookup("controller:application");

    if (!appController) {
      // appController might not exist when top-level loading/error
      // substates have been entered since ApplicationRoute hasn't
      // actually been entered at that point.
      return;
    }

    var infos = router.router.currentHandlerInfos;
    var path = EmberRouter._routePath(infos);

    if (!("currentPath" in appController)) {
      properties.defineProperty(appController, "currentPath");
    }

    property_set.set(appController, "currentPath", path);

    if (!("currentRouteName" in appController)) {
      properties.defineProperty(appController, "currentRouteName");
    }

    property_set.set(appController, "currentRouteName", infos[infos.length - 1].name);
  }

  EmberRouter.reopenClass({
    router: null,

    /**
      The `Router.map` function allows you to define mappings from URLs to routes
      and resources in your application. These mappings are defined within the
      supplied callback function using `this.resource` and `this.route`.
       ```javascript
      App.Router.map(function(){
        this.route('about');
        this.resource('article');
      });
      ```
       For more detailed examples please see
      [the guides](http://emberjs.com/guides/routing/defining-your-routes/).
       @method map
      @param callback
    */
    map: function (callback) {

      if (!this.dslCallbacks) {
        this.dslCallbacks = [];
        this.reopenClass({ dslCallbacks: this.dslCallbacks });
      }

      this.dslCallbacks.push(callback);

      return this;
    },

    _routePath: function (handlerInfos) {
      var path = [];

      // We have to handle coalescing resource names that
      // are prefixed with their parent's names, e.g.
      // ['foo', 'foo.bar.baz'] => 'foo.bar.baz', not 'foo.foo.bar.baz'

      function intersectionMatches(a1, a2) {
        for (var i = 0, len = a1.length; i < len; ++i) {
          if (a1[i] !== a2[i]) {
            return false;
          }
        }
        return true;
      }

      var name, nameParts, oldNameParts;
      for (var i = 1, l = handlerInfos.length; i < l; i++) {
        name = handlerInfos[i].name;
        nameParts = name.split(".");
        oldNameParts = slice.call(path);

        while (oldNameParts.length) {
          if (intersectionMatches(oldNameParts, nameParts)) {
            break;
          }
          oldNameParts.shift();
        }

        path.push.apply(path, nameParts.slice(oldNameParts.length));
      }

      return path.join(".");
    }
  });

  function didBeginTransition(transition, router) {
    var routerState = RouterState['default'].create({
      emberRouter: router,
      routerJs: router.router,
      routerJsState: transition.state
    });

    if (!router.currentState) {
      router.set("currentState", routerState);
    }
    router.set("targetState", routerState);

    transition.then(null, function (error) {
      if (!error || !error.name) {
        return;
      }

      
      return error;
    }, "Ember: Process errors from Router");
  }

  function resemblesURL(str) {
    return typeof str === "string" && (str === "" || str.charAt(0) === "/");
  }

  function forEachQueryParam(router, targetRouteName, queryParams, callback) {
    var qpCache = router._queryParamsFor(targetRouteName);

    for (var key in queryParams) {
      if (!queryParams.hasOwnProperty(key)) {
        continue;
      }
      var value = queryParams[key];
      var qp = qpCache.map[key];

      if (qp) {
        callback(key, value, qp);
      }
    }
  }

  function findLiveRoute(liveRoutes, name) {
    if (!liveRoutes) {
      return;
    }
    var stack = [liveRoutes];
    while (stack.length > 0) {
      var test = stack.shift();
      if (test.render.name === name) {
        return test;
      }
      var outlets = test.outlets;
      for (var outletName in outlets) {
        stack.push(outlets[outletName]);
      }
    }
  }

  function appendLiveRoute(liveRoutes, defaultParentState, renderOptions) {
    var target;
    var myState = {
      render: renderOptions,
      outlets: create['default'](null)
    };
    if (renderOptions.into) {
      target = findLiveRoute(liveRoutes, renderOptions.into);
    } else {
      target = defaultParentState;
    }
    if (target) {
      property_set.set(target.outlets, renderOptions.outlet, myState);
    } else {
      if (renderOptions.into) {
        // Megahax time. Post-2.0-breaking-changes, we will just assert
        // right here that the user tried to target a nonexistent
        // thing. But for now we still need to support the `render`
        // helper, and people are allowed to target templates rendered
        // by the render helper. So instead we defer doing anyting with
        // these orphan renders until afterRender.
        appendOrphan(liveRoutes, renderOptions.into, myState);
      } else {
        liveRoutes = myState;
      }
    }
    return {
      liveRoutes: liveRoutes,
      ownState: myState
    };
  }

  function appendOrphan(liveRoutes, into, myState) {
    if (!liveRoutes.outlets.__ember_orphans__) {
      liveRoutes.outlets.__ember_orphans__ = {
        render: {
          name: "__ember_orphans__"
        },
        outlets: create['default'](null)
      };
    }
    liveRoutes.outlets.__ember_orphans__.outlets[into] = myState;
    Ember['default'].run.schedule("afterRender", function () {
      // `wasUsed` gets set by the render helper. See the function
      // `impersonateAnOutlet`.
          });
  }

  function representEmptyRoute(liveRoutes, defaultParentState, route) {
    // the route didn't render anything
    var alreadyAppended = findLiveRoute(liveRoutes, route.routeName);
    if (alreadyAppended) {
      // But some other route has already rendered our default
      // template, so that becomes the default target for any
      // children we may have.
      return alreadyAppended;
    } else {
      // Create an entry to represent our default template name,
      // just so other routes can target it and inherit its place
      // in the outlet hierarchy.
      defaultParentState.outlets.main = {
        render: {
          name: route.routeName,
          outlet: "main"
        },
        outlets: {}
      };
      return defaultParentState;
    }
  }

  exports['default'] = EmberRouter;

});
enifed('ember-routing/system/router_state', ['exports', 'ember-metal/core', 'ember-runtime/system/object', 'ember-metal/merge'], function (exports, Ember, EmberObject, merge) {

  'use strict';

  var RouterState = EmberObject['default'].extend({
    emberRouter: null,
    routerJs: null,
    routerJsState: null,

    isActiveIntent: function (routeName, models, queryParams, queryParamsMustMatch) {
      var state = this.routerJsState;
      if (!this.routerJs.isActiveIntent(routeName, models, null, state)) {
        return false;
      }

      var emptyQueryParams = Ember['default'].isEmpty(Ember['default'].keys(queryParams));

      if (queryParamsMustMatch && !emptyQueryParams) {
        var visibleQueryParams = {};
        merge['default'](visibleQueryParams, queryParams);

        this.emberRouter._prepareQueryParams(routeName, models, visibleQueryParams);
        return shallowEqual(visibleQueryParams, state.queryParams);
      }

      return true;
    }
  });

  function shallowEqual(a, b) {
    var k;
    for (k in a) {
      if (a.hasOwnProperty(k) && a[k] !== b[k]) {
        return false;
      }
    }
    for (k in b) {
      if (b.hasOwnProperty(k) && a[k] !== b[k]) {
        return false;
      }
    }
    return true;
  }

  exports['default'] = RouterState;

});
enifed('ember-routing/utils', ['exports', 'ember-metal/utils'], function (exports, utils) {

  'use strict';

  exports.routeArgs = routeArgs;
  exports.getActiveTargetName = getActiveTargetName;
  exports.stashParamNames = stashParamNames;

  function routeArgs(targetRouteName, models, queryParams) {
    var args = [];
    if (utils.typeOf(targetRouteName) === 'string') {
      args.push('' + targetRouteName);
    }
    args.push.apply(args, models);
    args.push({ queryParams: queryParams });
    return args;
  }

  function getActiveTargetName(router) {
    var handlerInfos = router.activeTransition ? router.activeTransition.state.handlerInfos : router.state.handlerInfos;
    return handlerInfos[handlerInfos.length - 1].name;
  }

  function stashParamNames(router, handlerInfos) {
    if (handlerInfos._namesStashed) {
      return;
    }

    // This helper exists because router.js/route-recognizer.js awkwardly
    // keeps separate a handlerInfo's list of parameter names depending
    // on whether a URL transition or named transition is happening.
    // Hopefully we can remove this in the future.
    var targetRouteName = handlerInfos[handlerInfos.length - 1].name;
    var recogHandlers = router.router.recognizer.handlersFor(targetRouteName);
    var dynamicParent = null;

    for (var i = 0, len = handlerInfos.length; i < len; ++i) {
      var handlerInfo = handlerInfos[i];
      var names = recogHandlers[i].names;

      if (names.length) {
        dynamicParent = handlerInfo;
      }

      handlerInfo._names = names;

      var route = handlerInfo.handler;
      route._stashNames(handlerInfo, dynamicParent);
    }

    handlerInfos._namesStashed = true;
  }

});
enifed('ember-runtime', ['exports', 'ember-metal', 'ember-runtime/core', 'ember-runtime/compare', 'ember-runtime/copy', 'ember-runtime/inject', 'ember-runtime/system/namespace', 'ember-runtime/system/object', 'ember-runtime/system/tracked_array', 'ember-runtime/system/subarray', 'ember-runtime/system/container', 'ember-runtime/system/array_proxy', 'ember-runtime/system/object_proxy', 'ember-runtime/system/core_object', 'ember-runtime/system/native_array', 'ember-runtime/system/set', 'ember-runtime/system/string', 'ember-runtime/system/deferred', 'ember-runtime/system/lazy_load', 'ember-runtime/mixins/array', 'ember-runtime/mixins/comparable', 'ember-runtime/mixins/copyable', 'ember-runtime/mixins/enumerable', 'ember-runtime/mixins/freezable', 'ember-runtime/mixins/-proxy', 'ember-runtime/mixins/observable', 'ember-runtime/mixins/action_handler', 'ember-runtime/mixins/deferred', 'ember-runtime/mixins/mutable_enumerable', 'ember-runtime/mixins/mutable_array', 'ember-runtime/mixins/target_action_support', 'ember-runtime/mixins/evented', 'ember-runtime/mixins/promise_proxy', 'ember-runtime/mixins/sortable', 'ember-runtime/computed/array_computed', 'ember-runtime/computed/reduce_computed', 'ember-runtime/computed/reduce_computed_macros', 'ember-runtime/controllers/array_controller', 'ember-runtime/controllers/object_controller', 'ember-runtime/controllers/controller', 'ember-runtime/mixins/controller', 'ember-runtime/system/service', 'ember-runtime/ext/rsvp', 'ember-runtime/ext/string', 'ember-runtime/ext/function'], function (exports, Ember, core, compare, copy, inject, Namespace, EmberObject, TrackedArray, SubArray, container, ArrayProxy, ObjectProxy, CoreObject, NativeArray, Set, EmberStringUtils, Deferred, lazy_load, EmberArray, Comparable, Copyable, Enumerable, freezable, _ProxyMixin, Observable, ActionHandler, DeferredMixin, MutableEnumerable, MutableArray, TargetActionSupport, Evented, PromiseProxyMixin, SortableMixin, array_computed, reduce_computed, reduce_computed_macros, ArrayController, ObjectController, Controller, ControllerMixin, Service, RSVP) {

	'use strict';

	/**
	Ember Runtime

	@module ember
	@submodule ember-runtime
	@requires ember-metal
	*/

	// BEGIN IMPORTS
	Ember['default'].compare = compare['default'];
	Ember['default'].copy = copy['default'];
	Ember['default'].isEqual = core.isEqual;

	Ember['default'].inject = inject['default'];

	Ember['default'].Array = EmberArray['default'];

	Ember['default'].Comparable = Comparable['default'];
	Ember['default'].Copyable = Copyable['default'];

	Ember['default'].SortableMixin = SortableMixin['default'];

	Ember['default'].Freezable = freezable.Freezable;
	Ember['default'].FROZEN_ERROR = freezable.FROZEN_ERROR;

	Ember['default'].DeferredMixin = DeferredMixin['default'];

	Ember['default'].MutableEnumerable = MutableEnumerable['default'];
	Ember['default'].MutableArray = MutableArray['default'];

	Ember['default'].TargetActionSupport = TargetActionSupport['default'];
	Ember['default'].Evented = Evented['default'];

	Ember['default'].PromiseProxyMixin = PromiseProxyMixin['default'];

	Ember['default'].Observable = Observable['default'];

	Ember['default'].arrayComputed = array_computed.arrayComputed;
	Ember['default'].ArrayComputedProperty = array_computed.ArrayComputedProperty;
	Ember['default'].reduceComputed = reduce_computed.reduceComputed;
	Ember['default'].ReduceComputedProperty = reduce_computed.ReduceComputedProperty;

	// ES6TODO: this seems a less than ideal way/place to add properties to Ember.computed
	var EmComputed = Ember['default'].computed;

	EmComputed.sum = reduce_computed_macros.sum;
	EmComputed.min = reduce_computed_macros.min;
	EmComputed.max = reduce_computed_macros.max;
	EmComputed.map = reduce_computed_macros.map;
	EmComputed.sort = reduce_computed_macros.sort;
	EmComputed.setDiff = reduce_computed_macros.setDiff;
	EmComputed.mapBy = reduce_computed_macros.mapBy;
	EmComputed.mapProperty = reduce_computed_macros.mapProperty;
	EmComputed.filter = reduce_computed_macros.filter;
	EmComputed.filterBy = reduce_computed_macros.filterBy;
	EmComputed.filterProperty = reduce_computed_macros.filterProperty;
	EmComputed.uniq = reduce_computed_macros.uniq;
	EmComputed.union = reduce_computed_macros.union;
	EmComputed.intersect = reduce_computed_macros.intersect;

	Ember['default'].String = EmberStringUtils['default'];
	Ember['default'].Object = EmberObject['default'];
	Ember['default'].TrackedArray = TrackedArray['default'];
	Ember['default'].SubArray = SubArray['default'];
	Ember['default'].Container = container.Container;
	Ember['default'].Registry = container.Registry;
	Ember['default'].Namespace = Namespace['default'];
	Ember['default'].Enumerable = Enumerable['default'];
	Ember['default'].ArrayProxy = ArrayProxy['default'];
	Ember['default'].ObjectProxy = ObjectProxy['default'];
	Ember['default'].ActionHandler = ActionHandler['default'];
	Ember['default'].CoreObject = CoreObject['default'];
	Ember['default'].NativeArray = NativeArray['default'];
	// ES6TODO: Currently we must rely on the global from ember-metal/core to avoid circular deps
	// Ember.A = A;
	Ember['default'].Set = Set['default'];
	Ember['default'].Deferred = Deferred['default'];
	Ember['default'].onLoad = lazy_load.onLoad;
	Ember['default'].runLoadHooks = lazy_load.runLoadHooks;

	Ember['default'].ArrayController = ArrayController['default'];
	Ember['default'].ObjectController = ObjectController['default'];
	Ember['default'].Controller = Controller['default'];
	Ember['default'].ControllerMixin = ControllerMixin['default'];

	Ember['default'].Service = Service['default'];

	Ember['default']._ProxyMixin = _ProxyMixin['default'];

	Ember['default'].RSVP = RSVP['default'];
	// END EXPORTS

	exports['default'] = Ember['default'];

});
enifed('ember-runtime/compare', ['exports', 'ember-metal/utils', 'ember-runtime/mixins/comparable'], function (exports, utils, Comparable) {

  'use strict';



  /**
   This will compare two javascript values of possibly different types.
   It will tell you which one is greater than the other by returning:

    - -1 if the first is smaller than the second,
    - 0 if both are equal,
    - 1 if the first is greater than the second.

   The order is calculated based on `Ember.ORDER_DEFINITION`, if types are different.
   In case they have the same type an appropriate comparison for this type is made.

    ```javascript
    Ember.compare('hello', 'hello');  // 0
    Ember.compare('abc', 'dfg');      // -1
    Ember.compare(2, 1);              // 1
    ```

   @method compare
   @for Ember
   @param {Object} v First value to compare
   @param {Object} w Second value to compare
   @return {Number} -1 if v < w, 0 if v = w and 1 if v > w.
  */
  exports['default'] = compare;
  var TYPE_ORDER = {
    'undefined': 0,
    'null': 1,
    'boolean': 2,
    'number': 3,
    'string': 4,
    'array': 5,
    'object': 6,
    'instance': 7,
    'function': 8,
    'class': 9,
    'date': 10
  };

  //
  // the spaceship operator
  //
  function spaceship(a, b) {
    var diff = a - b;
    return (diff > 0) - (diff < 0);
  }
  function compare(v, w) {
    if (v === w) {
      return 0;
    }

    var type1 = utils.typeOf(v);
    var type2 = utils.typeOf(w);

    if (Comparable['default']) {
      if (type1 === 'instance' && Comparable['default'].detect(v) && v.constructor.compare) {
        return v.constructor.compare(v, w);
      }

      if (type2 === 'instance' && Comparable['default'].detect(w) && w.constructor.compare) {
        return w.constructor.compare(w, v) * -1;
      }
    }

    var res = spaceship(TYPE_ORDER[type1], TYPE_ORDER[type2]);

    if (res !== 0) {
      return res;
    }

    // types are equal - so we have to check values now
    switch (type1) {
      case 'boolean':
      case 'number':
        return spaceship(v, w);

      case 'string':
        return spaceship(v.localeCompare(w), 0);

      case 'array':
        var vLen = v.length;
        var wLen = w.length;
        var len = Math.min(vLen, wLen);

        for (var i = 0; i < len; i++) {
          var r = compare(v[i], w[i]);
          if (r !== 0) {
            return r;
          }
        }

        // all elements are equal now
        // shorter array should be ordered first
        return spaceship(vLen, wLen);

      case 'instance':
        if (Comparable['default'] && Comparable['default'].detect(v)) {
          return v.compare(v, w);
        }
        return 0;

      case 'date':
        return spaceship(v.getTime(), w.getTime());

      default:
        return 0;
    }
  }

});
enifed('ember-runtime/computed/array_computed', ['exports', 'ember-metal/core', 'ember-runtime/computed/reduce_computed', 'ember-metal/enumerable_utils', 'ember-metal/platform/create', 'ember-metal/observer', 'ember-metal/error'], function (exports, Ember, reduce_computed, enumerable_utils, o_create, observer, EmberError) {

  'use strict';

  exports.arrayComputed = arrayComputed;
  exports.ArrayComputedProperty = ArrayComputedProperty;

  var a_slice = [].slice;

  function ArrayComputedProperty() {
    var cp = this;

    reduce_computed.ReduceComputedProperty.apply(this, arguments);

    this._getter = (function (reduceFunc) {
      return function (propertyName) {
        if (!cp._hasInstanceMeta(this, propertyName)) {
          // When we recompute an array computed property, we need already
          // retrieved arrays to be updated; we can't simply empty the cache and
          // hope the array is re-retrieved.
          enumerable_utils.forEach(cp._dependentKeys, function (dependentKey) {
            observer.addObserver(this, dependentKey, function () {
              cp.recomputeOnce.call(this, propertyName);
            });
          }, this);
        }

        return reduceFunc.apply(this, arguments);
      };
    })(this._getter);

    return this;
  }

  ArrayComputedProperty.prototype = o_create['default'](reduce_computed.ReduceComputedProperty.prototype);

  ArrayComputedProperty.prototype.initialValue = function () {
    return Ember['default'].A();
  };

  ArrayComputedProperty.prototype.resetValue = function (array) {
    array.clear();
    return array;
  };

  // This is a stopgap to keep the reference counts correct with lazy CPs.
  ArrayComputedProperty.prototype.didChange = function (obj, keyName) {
    return;
  };

  /**
    Creates a computed property which operates on dependent arrays and
    is updated with "one at a time" semantics. When items are added or
    removed from the dependent array(s) an array computed only operates
    on the change instead of re-evaluating the entire array. This should
    return an array, if you'd like to use "one at a time" semantics and
    compute some value other then an array look at
    `Ember.reduceComputed`.

    If there are more than one arguments the first arguments are
    considered to be dependent property keys. The last argument is
    required to be an options object. The options object can have the
    following three properties.

    `initialize` - An optional initialize function. Typically this will be used
    to set up state on the instanceMeta object.

    `removedItem` - A function that is called each time an element is
    removed from the array.

    `addedItem` - A function that is called each time an element is
    added to the array.


    The `initialize` function has the following signature:

    ```javascript
    function(array, changeMeta, instanceMeta)
    ```

    `array` - The initial value of the arrayComputed, an empty array.

    `changeMeta` - An object which contains meta information about the
    computed. It contains the following properties:

       - `property` the computed property
       - `propertyName` the name of the property on the object

    `instanceMeta` - An object that can be used to store meta
    information needed for calculating your computed. For example a
    unique computed might use this to store the number of times a given
    element is found in the dependent array.


    The `removedItem` and `addedItem` functions both have the following signature:

    ```javascript
    function(accumulatedValue, item, changeMeta, instanceMeta)
    ```

    `accumulatedValue` - The value returned from the last time
    `removedItem` or `addedItem` was called or an empty array.

    `item` - the element added or removed from the array

    `changeMeta` - An object which contains meta information about the
    change. It contains the following properties:

      - `property` the computed property
      - `propertyName` the name of the property on the object
      - `index` the index of the added or removed item
      - `item` the added or removed item: this is exactly the same as
        the second arg
      - `arrayChanged` the array that triggered the change. Can be
        useful when depending on multiple arrays.

    For property changes triggered on an item property change (when
    depKey is something like `someArray.@each.someProperty`),
    `changeMeta` will also contain the following property:

      - `previousValues` an object whose keys are the properties that changed on
      the item, and whose values are the item's previous values.

    `previousValues` is important Ember coalesces item property changes via
    Ember.run.once. This means that by the time removedItem gets called, item has
    the new values, but you may need the previous value (eg for sorting &
    filtering).

    `instanceMeta` - An object that can be used to store meta
    information needed for calculating your computed. For example a
    unique computed might use this to store the number of times a given
    element is found in the dependent array.

    The `removedItem` and `addedItem` functions should return the accumulated
    value. It is acceptable to not return anything (ie return undefined)
    to invalidate the computation. This is generally not a good idea for
    arrayComputed but it's used in eg max and min.

    Example

    ```javascript
    Ember.computed.map = function(dependentKey, callback) {
      var options = {
        addedItem: function(array, item, changeMeta, instanceMeta) {
          var mapped = callback(item);
          array.insertAt(changeMeta.index, mapped);
          return array;
        },
        removedItem: function(array, item, changeMeta, instanceMeta) {
          array.removeAt(changeMeta.index, 1);
          return array;
        }
      };

      return Ember.arrayComputed(dependentKey, options);
    };
    ```

    @method arrayComputed
    @for Ember
    @param {String} [dependentKeys*]
    @param {Object} options
    @return {Ember.ComputedProperty}
  */
  function arrayComputed(options) {
    var args;

    if (arguments.length > 1) {
      args = a_slice.call(arguments, 0, -1);
      options = a_slice.call(arguments, -1)[0];
    }

    if (typeof options !== 'object') {
      throw new EmberError['default']('Array Computed Property declared without an options hash');
    }

    var cp = new ArrayComputedProperty(options);

    if (args) {
      cp.property.apply(cp, args);
    }

    return cp;
  }

});
enifed('ember-runtime/computed/reduce_computed', ['exports', 'ember-metal/core', 'ember-metal/property_get', 'ember-metal/utils', 'ember-metal/error', 'ember-metal/property_events', 'ember-metal/expand_properties', 'ember-metal/observer', 'ember-metal/computed', 'ember-metal/platform/create', 'ember-metal/enumerable_utils', 'ember-runtime/system/tracked_array', 'ember-runtime/mixins/array', 'ember-metal/run_loop'], function (exports, Ember, property_get, utils, EmberError, property_events, expandProperties, ember_metal__observer, computed, o_create, enumerable_utils, TrackedArray, EmberArray, run) {

  'use strict';

  exports.reduceComputed = reduceComputed;
  exports.ReduceComputedProperty = ReduceComputedProperty;

  /**
    Creates a computed property which operates on dependent arrays and
    is updated with "one at a time" semantics. When items are added or
    removed from the dependent array(s) a reduce computed only operates
    on the change instead of re-evaluating the entire array.

    If there are more than one arguments the first arguments are
    considered to be dependent property keys. The last argument is
    required to be an options object. The options object can have the
    following four properties:

    `initialValue` - A value or function that will be used as the initial
    value for the computed. If this property is a function the result of calling
    the function will be used as the initial value. This property is required.

    `initialize` - An optional initialize function. Typically this will be used
    to set up state on the instanceMeta object.

    `removedItem` - A function that is called each time an element is removed
    from the array.

    `addedItem` - A function that is called each time an element is added to
    the array.


    The `initialize` function has the following signature:

    ```javascript
    function(initialValue, changeMeta, instanceMeta)
    ```

    `initialValue` - The value of the `initialValue` property from the
    options object.

    `changeMeta` - An object which contains meta information about the
    computed. It contains the following properties:

       - `property` the computed property
       - `propertyName` the name of the property on the object

    `instanceMeta` - An object that can be used to store meta
    information needed for calculating your computed. For example a
    unique computed might use this to store the number of times a given
    element is found in the dependent array.


    The `removedItem` and `addedItem` functions both have the following signature:

    ```javascript
    function(accumulatedValue, item, changeMeta, instanceMeta)
    ```

    `accumulatedValue` - The value returned from the last time
    `removedItem` or `addedItem` was called or `initialValue`.

    `item` - the element added or removed from the array

    `changeMeta` - An object which contains meta information about the
    change. It contains the following properties:

      - `property` the computed property
      - `propertyName` the name of the property on the object
      - `index` the index of the added or removed item
      - `item` the added or removed item: this is exactly the same as
        the second arg
      - `arrayChanged` the array that triggered the change. Can be
        useful when depending on multiple arrays.

    For property changes triggered on an item property change (when
    depKey is something like `someArray.@each.someProperty`),
    `changeMeta` will also contain the following property:

      - `previousValues` an object whose keys are the properties that changed on
      the item, and whose values are the item's previous values.

    `previousValues` is important Ember coalesces item property changes via
    Ember.run.once. This means that by the time removedItem gets called, item has
    the new values, but you may need the previous value (eg for sorting &
    filtering).

    `instanceMeta` - An object that can be used to store meta
    information needed for calculating your computed. For example a
    unique computed might use this to store the number of times a given
    element is found in the dependent array.

    The `removedItem` and `addedItem` functions should return the accumulated
    value. It is acceptable to not return anything (ie return undefined)
    to invalidate the computation. This is generally not a good idea for
    arrayComputed but it's used in eg max and min.

    Note that observers will be fired if either of these functions return a value
    that differs from the accumulated value.  When returning an object that
    mutates in response to array changes, for example an array that maps
    everything from some other array (see `Ember.computed.map`), it is usually
    important that the *same* array be returned to avoid accidentally triggering observers.

    Example

    ```javascript
    Ember.computed.max = function(dependentKey) {
      return Ember.reduceComputed(dependentKey, {
        initialValue: -Infinity,

        addedItem: function(accumulatedValue, item, changeMeta, instanceMeta) {
          return Math.max(accumulatedValue, item);
        },

        removedItem: function(accumulatedValue, item, changeMeta, instanceMeta) {
          if (item < accumulatedValue) {
            return accumulatedValue;
          }
        }
      });
    };
    ```

    Dependent keys may refer to `@this` to observe changes to the object itself,
    which must be array-like, rather than a property of the object.  This is
    mostly useful for array proxies, to ensure objects are retrieved via
    `objectAtContent`.  This is how you could sort items by properties defined on an item controller.

    Example

    ```javascript
    App.PeopleController = Ember.ArrayController.extend({
      itemController: 'person',

      sortedPeople: Ember.computed.sort('@this.@each.reversedName', function(personA, personB) {
        // `reversedName` isn't defined on Person, but we have access to it via
        // the item controller App.PersonController.  If we'd used
        // `content.@each.reversedName` above, we would be getting the objects
        // directly and not have access to `reversedName`.
        //
        var reversedNameA = get(personA, 'reversedName');
        var reversedNameB = get(personB, 'reversedName');

        return Ember.compare(reversedNameA, reversedNameB);
      })
    });

    App.PersonController = Ember.ObjectController.extend({
      reversedName: function() {
        return reverse(get(this, 'name'));
      }.property('name')
    });
    ```

    Dependent keys whose values are not arrays are treated as regular
    dependencies: when they change, the computed property is completely
    recalculated.  It is sometimes useful to have dependent arrays with similar
    semantics.  Dependent keys which end in `.[]` do not use "one at a time"
    semantics.  When an item is added or removed from such a dependency, the
    computed property is completely recomputed.

    When the computed property is completely recomputed, the `accumulatedValue`
    is discarded, it starts with `initialValue` again, and each item is passed
    to `addedItem` in turn.

    Example

    ```javascript
    Ember.Object.extend({
      // When `string` is changed, `computed` is completely recomputed.
      string: 'a string',

      // When an item is added to `array`, `addedItem` is called.
      array: [],

      // When an item is added to `anotherArray`, `computed` is completely
      // recomputed.
      anotherArray: [],

      computed: Ember.reduceComputed('string', 'array', 'anotherArray.[]', {
        addedItem: addedItemCallback,
        removedItem: removedItemCallback
      })
    });
    ```

    @method reduceComputed
    @for Ember
    @param {String} [dependentKeys*]
    @param {Object} options
    @return {Ember.ComputedProperty}
  */
  var cacheSet = computed.cacheFor.set;
  var cacheGet = computed.cacheFor.get;
  var cacheRemove = computed.cacheFor.remove;
  var a_slice = [].slice;
  // Here we explicitly don't allow `@each.foo`; it would require some special
  // testing, but there's no particular reason why it should be disallowed.
  var eachPropertyPattern = /^(.*)\.@each\.(.*)/;
  var doubleEachPropertyPattern = /(.*\.@each){2,}/;
  var arrayBracketPattern = /\.\[\]$/;

  function get(obj, key) {
    if (key === '@this') {
      return obj;
    }

    return property_get.get(obj, key);
  }

  /*
    Tracks changes to dependent arrays, as well as to properties of items in
    dependent arrays.

    @class DependentArraysObserver
  */
  function DependentArraysObserver(callbacks, cp, instanceMeta, context, propertyName, sugarMeta) {
    // user specified callbacks for `addedItem` and `removedItem`
    this.callbacks = callbacks;

    // the computed property: remember these are shared across instances
    this.cp = cp;

    // the ReduceComputedPropertyInstanceMeta this DependentArraysObserver is
    // associated with
    this.instanceMeta = instanceMeta;

    // A map of array guids to dependentKeys, for the given context.  We track
    // this because we want to set up the computed property potentially before the
    // dependent array even exists, but when the array observer fires, we lack
    // enough context to know what to update: we can recover that context by
    // getting the dependentKey.
    this.dependentKeysByGuid = {};

    // a map of dependent array guids -> TrackedArray instances.  We use
    // this to lazily recompute indexes for item property observers.
    this.trackedArraysByGuid = {};

    // We suspend observers to ignore replacements from `reset` when totally
    // recomputing.  Unfortunately we cannot properly suspend the observers
    // because we only have the key; instead we make the observers no-ops
    this.suspended = false;

    // This is used to coalesce item changes from property observers within a
    // single item.
    this.changedItems = {};
    // This is used to coalesce item changes for multiple items that depend on
    // some shared state.
    this.changedItemCount = 0;
  }

  function ItemPropertyObserverContext(dependentArray, index, trackedArray) {
    
    this.dependentArray = dependentArray;
    this.index = index;
    this.item = dependentArray.objectAt(index);
    this.trackedArray = trackedArray;
    this.beforeObserver = null;
    this.observer = null;
    this.destroyed = false;
  }

  DependentArraysObserver.prototype = {
    setValue: function (newValue) {
      this.instanceMeta.setValue(newValue, true);
    },

    getValue: function () {
      return this.instanceMeta.getValue();
    },

    setupObservers: function (dependentArray, dependentKey) {
      this.dependentKeysByGuid[utils.guidFor(dependentArray)] = dependentKey;

      dependentArray.addArrayObserver(this, {
        willChange: 'dependentArrayWillChange',
        didChange: 'dependentArrayDidChange'
      });

      if (this.cp._itemPropertyKeys[dependentKey]) {
        this.setupPropertyObservers(dependentKey, this.cp._itemPropertyKeys[dependentKey]);
      }
    },

    teardownObservers: function (dependentArray, dependentKey) {
      var itemPropertyKeys = this.cp._itemPropertyKeys[dependentKey] || [];

      delete this.dependentKeysByGuid[utils.guidFor(dependentArray)];

      this.teardownPropertyObservers(dependentKey, itemPropertyKeys);

      dependentArray.removeArrayObserver(this, {
        willChange: 'dependentArrayWillChange',
        didChange: 'dependentArrayDidChange'
      });
    },

    suspendArrayObservers: function (callback, binding) {
      var oldSuspended = this.suspended;
      this.suspended = true;
      callback.call(binding);
      this.suspended = oldSuspended;
    },

    setupPropertyObservers: function (dependentKey, itemPropertyKeys) {
      var dependentArray = get(this.instanceMeta.context, dependentKey);
      var length = get(dependentArray, 'length');
      var observerContexts = new Array(length);

      this.resetTransformations(dependentKey, observerContexts);

      enumerable_utils.forEach(dependentArray, function (item, index) {
        var observerContext = this.createPropertyObserverContext(dependentArray, index, this.trackedArraysByGuid[dependentKey]);
        observerContexts[index] = observerContext;

        enumerable_utils.forEach(itemPropertyKeys, function (propertyKey) {
          ember_metal__observer.addBeforeObserver(item, propertyKey, this, observerContext.beforeObserver);
          ember_metal__observer.addObserver(item, propertyKey, this, observerContext.observer);
        }, this);
      }, this);
    },

    teardownPropertyObservers: function (dependentKey, itemPropertyKeys) {
      var dependentArrayObserver = this;
      var trackedArray = this.trackedArraysByGuid[dependentKey];
      var beforeObserver, observer, item;

      if (!trackedArray) {
        return;
      }

      trackedArray.apply(function (observerContexts, offset, operation) {
        if (operation === TrackedArray['default'].DELETE) {
          return;
        }

        enumerable_utils.forEach(observerContexts, function (observerContext) {
          observerContext.destroyed = true;
          beforeObserver = observerContext.beforeObserver;
          observer = observerContext.observer;
          item = observerContext.item;

          enumerable_utils.forEach(itemPropertyKeys, function (propertyKey) {
            ember_metal__observer.removeBeforeObserver(item, propertyKey, dependentArrayObserver, beforeObserver);
            ember_metal__observer.removeObserver(item, propertyKey, dependentArrayObserver, observer);
          });
        });
      });
    },

    createPropertyObserverContext: function (dependentArray, index, trackedArray) {
      var observerContext = new ItemPropertyObserverContext(dependentArray, index, trackedArray);

      this.createPropertyObserver(observerContext);

      return observerContext;
    },

    createPropertyObserver: function (observerContext) {
      var dependentArrayObserver = this;

      observerContext.beforeObserver = function (obj, keyName) {
        return dependentArrayObserver.itemPropertyWillChange(obj, keyName, observerContext.dependentArray, observerContext);
      };

      observerContext.observer = function (obj, keyName) {
        return dependentArrayObserver.itemPropertyDidChange(obj, keyName, observerContext.dependentArray, observerContext);
      };
    },

    resetTransformations: function (dependentKey, observerContexts) {
      this.trackedArraysByGuid[dependentKey] = new TrackedArray['default'](observerContexts);
    },

    trackAdd: function (dependentKey, index, newItems) {
      var trackedArray = this.trackedArraysByGuid[dependentKey];

      if (trackedArray) {
        trackedArray.addItems(index, newItems);
      }
    },

    trackRemove: function (dependentKey, index, removedCount) {
      var trackedArray = this.trackedArraysByGuid[dependentKey];

      if (trackedArray) {
        return trackedArray.removeItems(index, removedCount);
      }

      return [];
    },

    updateIndexes: function (trackedArray, array) {
      var length = get(array, 'length');
      // OPTIMIZE: we could stop updating once we hit the object whose observer
      // fired; ie partially apply the transformations
      trackedArray.apply(function (observerContexts, offset, operation, operationIndex) {
        // we don't even have observer contexts for removed items, even if we did,
        // they no longer have any index in the array
        if (operation === TrackedArray['default'].DELETE) {
          return;
        }
        if (operationIndex === 0 && operation === TrackedArray['default'].RETAIN && observerContexts.length === length && offset === 0) {
          // If we update many items we don't want to walk the array each time: we
          // only need to update the indexes at most once per run loop.
          return;
        }

        enumerable_utils.forEach(observerContexts, function (context, index) {
          context.index = index + offset;
        });
      });
    },

    dependentArrayWillChange: function (dependentArray, index, removedCount, addedCount) {
      if (this.suspended) {
        return;
      }

      var removedItem = this.callbacks.removedItem;
      var changeMeta;
      var guid = utils.guidFor(dependentArray);
      var dependentKey = this.dependentKeysByGuid[guid];
      var itemPropertyKeys = this.cp._itemPropertyKeys[dependentKey] || [];
      var length = get(dependentArray, 'length');
      var normalizedIndex = normalizeIndex(index, length, 0);
      var normalizedRemoveCount = normalizeRemoveCount(normalizedIndex, length, removedCount);
      var item, itemIndex, sliceIndex, observerContexts;

      observerContexts = this.trackRemove(dependentKey, normalizedIndex, normalizedRemoveCount);

      function removeObservers(propertyKey) {
        observerContexts[sliceIndex].destroyed = true;
        ember_metal__observer.removeBeforeObserver(item, propertyKey, this, observerContexts[sliceIndex].beforeObserver);
        ember_metal__observer.removeObserver(item, propertyKey, this, observerContexts[sliceIndex].observer);
      }

      for (sliceIndex = normalizedRemoveCount - 1; sliceIndex >= 0; --sliceIndex) {
        itemIndex = normalizedIndex + sliceIndex;
        if (itemIndex >= length) {
          break;
        }

        item = dependentArray.objectAt(itemIndex);

        enumerable_utils.forEach(itemPropertyKeys, removeObservers, this);

        changeMeta = new ChangeMeta(dependentArray, item, itemIndex, this.instanceMeta.propertyName, this.cp, normalizedRemoveCount);
        this.setValue(removedItem.call(this.instanceMeta.context, this.getValue(), item, changeMeta, this.instanceMeta.sugarMeta));
      }
      this.callbacks.flushedChanges.call(this.instanceMeta.context, this.getValue(), this.instanceMeta.sugarMeta);
    },

    dependentArrayDidChange: function (dependentArray, index, removedCount, addedCount) {
      if (this.suspended) {
        return;
      }

      var addedItem = this.callbacks.addedItem;
      var guid = utils.guidFor(dependentArray);
      var dependentKey = this.dependentKeysByGuid[guid];
      var observerContexts = new Array(addedCount);
      var itemPropertyKeys = this.cp._itemPropertyKeys[dependentKey];
      var length = get(dependentArray, 'length');
      var normalizedIndex = normalizeIndex(index, length, addedCount);
      var endIndex = normalizedIndex + addedCount;
      var changeMeta, observerContext;

      enumerable_utils.forEach(dependentArray.slice(normalizedIndex, endIndex), function (item, sliceIndex) {
        if (itemPropertyKeys) {
          observerContext = this.createPropertyObserverContext(dependentArray, normalizedIndex + sliceIndex, this.trackedArraysByGuid[dependentKey]);
          observerContexts[sliceIndex] = observerContext;

          enumerable_utils.forEach(itemPropertyKeys, function (propertyKey) {
            ember_metal__observer.addBeforeObserver(item, propertyKey, this, observerContext.beforeObserver);
            ember_metal__observer.addObserver(item, propertyKey, this, observerContext.observer);
          }, this);
        }

        changeMeta = new ChangeMeta(dependentArray, item, normalizedIndex + sliceIndex, this.instanceMeta.propertyName, this.cp, addedCount);
        this.setValue(addedItem.call(this.instanceMeta.context, this.getValue(), item, changeMeta, this.instanceMeta.sugarMeta));
      }, this);
      this.callbacks.flushedChanges.call(this.instanceMeta.context, this.getValue(), this.instanceMeta.sugarMeta);
      this.trackAdd(dependentKey, normalizedIndex, observerContexts);
    },

    itemPropertyWillChange: function (obj, keyName, array, observerContext) {
      var guid = utils.guidFor(obj);

      if (!this.changedItems[guid]) {
        this.changedItems[guid] = {
          array: array,
          observerContext: observerContext,
          obj: obj,
          previousValues: {}
        };
      }

      ++this.changedItemCount;
      this.changedItems[guid].previousValues[keyName] = get(obj, keyName);
    },

    itemPropertyDidChange: function (obj, keyName, array, observerContext) {
      if (--this.changedItemCount === 0) {
        this.flushChanges();
      }
    },

    flushChanges: function () {
      var changedItems = this.changedItems;
      var key, c, changeMeta;

      for (key in changedItems) {
        c = changedItems[key];
        if (c.observerContext.destroyed) {
          continue;
        }

        this.updateIndexes(c.observerContext.trackedArray, c.observerContext.dependentArray);

        changeMeta = new ChangeMeta(c.array, c.obj, c.observerContext.index, this.instanceMeta.propertyName, this.cp, changedItems.length, c.previousValues);
        this.setValue(this.callbacks.removedItem.call(this.instanceMeta.context, this.getValue(), c.obj, changeMeta, this.instanceMeta.sugarMeta));
        this.setValue(this.callbacks.addedItem.call(this.instanceMeta.context, this.getValue(), c.obj, changeMeta, this.instanceMeta.sugarMeta));
      }

      this.changedItems = {};
      this.callbacks.flushedChanges.call(this.instanceMeta.context, this.getValue(), this.instanceMeta.sugarMeta);
    }
  };

  function normalizeIndex(index, length, newItemsOffset) {
    if (index < 0) {
      return Math.max(0, length + index);
    } else if (index < length) {
      return index;
    } else {
      // index > length
      return Math.min(length - newItemsOffset, index);
    }
  }

  function normalizeRemoveCount(index, length, removedCount) {
    return Math.min(removedCount, length - index);
  }

  function ChangeMeta(dependentArray, item, index, propertyName, property, changedCount, previousValues) {
    this.arrayChanged = dependentArray;
    this.index = index;
    this.item = item;
    this.propertyName = propertyName;
    this.property = property;
    this.changedCount = changedCount;

    if (previousValues) {
      // previous values only available for item property changes
      this.previousValues = previousValues;
    }
  }

  function addItems(dependentArray, callbacks, cp, propertyName, meta) {
    enumerable_utils.forEach(dependentArray, function (item, index) {
      meta.setValue(callbacks.addedItem.call(this, meta.getValue(), item, new ChangeMeta(dependentArray, item, index, propertyName, cp, dependentArray.length), meta.sugarMeta));
    }, this);
    callbacks.flushedChanges.call(this, meta.getValue(), meta.sugarMeta);
  }

  function reset(cp, propertyName) {
    var hadMeta = cp._hasInstanceMeta(this, propertyName);
    var meta = cp._instanceMeta(this, propertyName);

    if (hadMeta) {
      meta.setValue(cp.resetValue(meta.getValue()));
    }

    if (cp.options.initialize) {
      cp.options.initialize.call(this, meta.getValue(), {
        property: cp,
        propertyName: propertyName
      }, meta.sugarMeta);
    }
  }

  function partiallyRecomputeFor(obj, dependentKey) {
    if (arrayBracketPattern.test(dependentKey)) {
      return false;
    }

    var value = get(obj, dependentKey);
    return EmberArray['default'].detect(value);
  }

  function ReduceComputedPropertyInstanceMeta(context, propertyName, initialValue) {
    this.context = context;
    this.propertyName = propertyName;
    var contextMeta = utils.meta(context);
    var contextCache = contextMeta.cache;
    if (!contextCache) {
      contextCache = contextMeta.cache = {};
    }
    this.cache = contextCache;
    this.dependentArrays = {};
    this.sugarMeta = {};
    this.initialValue = initialValue;
  }

  ReduceComputedPropertyInstanceMeta.prototype = {
    getValue: function () {
      var value = cacheGet(this.cache, this.propertyName);

      if (value !== undefined) {
        return value;
      } else {
        return this.initialValue;
      }
    },

    setValue: function (newValue, triggerObservers) {
      // This lets sugars force a recomputation, handy for very simple
      // implementations of eg max.
      if (newValue === cacheGet(this.cache, this.propertyName)) {
        return;
      }

      if (triggerObservers) {
        property_events.propertyWillChange(this.context, this.propertyName);
      }

      if (newValue === undefined) {
        cacheRemove(this.cache, this.propertyName);
      } else {
        cacheSet(this.cache, this.propertyName, newValue);
      }

      if (triggerObservers) {
        property_events.propertyDidChange(this.context, this.propertyName);
      }
    }
  };

  /**
    A computed property whose dependent keys are arrays and which is updated with
    "one at a time" semantics.

    @class ReduceComputedProperty
    @namespace Ember
    @extends Ember.ComputedProperty
    @constructor
  */

  function ReduceComputedProperty(options) {
    var cp = this;

    this.options = options;
    this._dependentKeys = null;
    this._cacheable = true;
    // A map of dependentKey -> [itemProperty, ...] that tracks what properties of
    // items in the array we must track to update this property.
    this._itemPropertyKeys = {};
    this._previousItemPropertyKeys = {};

    this.readOnly();

    this.recomputeOnce = function (propertyName) {
      // What we really want to do is coalesce by <cp, propertyName>.
      // We need a form of `scheduleOnce` that accepts an arbitrary token to
      // coalesce by, in addition to the target and method.
      run['default'].once(this, recompute, propertyName);
    };

    var recompute = function (propertyName) {
      var meta = cp._instanceMeta(this, propertyName);
      var callbacks = cp._callbacks();

      reset.call(this, cp, propertyName);

      meta.dependentArraysObserver.suspendArrayObservers(function () {
        enumerable_utils.forEach(cp._dependentKeys, function (dependentKey) {
          
          if (!partiallyRecomputeFor(this, dependentKey)) {
            return;
          }

          var dependentArray = get(this, dependentKey);
          var previousDependentArray = meta.dependentArrays[dependentKey];

          if (dependentArray === previousDependentArray) {
            // The array may be the same, but our item property keys may have
            // changed, so we set them up again.  We can't easily tell if they've
            // changed: the array may be the same object, but with different
            // contents.
            if (cp._previousItemPropertyKeys[dependentKey]) {
              delete cp._previousItemPropertyKeys[dependentKey];
              meta.dependentArraysObserver.setupPropertyObservers(dependentKey, cp._itemPropertyKeys[dependentKey]);
            }
          } else {
            meta.dependentArrays[dependentKey] = dependentArray;

            if (previousDependentArray) {
              meta.dependentArraysObserver.teardownObservers(previousDependentArray, dependentKey);
            }

            if (dependentArray) {
              meta.dependentArraysObserver.setupObservers(dependentArray, dependentKey);
            }
          }
        }, this);
      }, this);

      enumerable_utils.forEach(cp._dependentKeys, function (dependentKey) {
        if (!partiallyRecomputeFor(this, dependentKey)) {
          return;
        }

        var dependentArray = get(this, dependentKey);

        if (dependentArray) {
          addItems.call(this, dependentArray, callbacks, cp, propertyName, meta);
        }
      }, this);
    };

    this._getter = function (propertyName) {
      
      recompute.call(this, propertyName);

      return cp._instanceMeta(this, propertyName).getValue();
    };
  }

  ReduceComputedProperty.prototype = o_create['default'](computed.ComputedProperty.prototype);

  function defaultCallback(computedValue) {
    return computedValue;
  }

  ReduceComputedProperty.prototype._callbacks = function () {
    if (!this.callbacks) {
      var options = this.options;

      this.callbacks = {
        removedItem: options.removedItem || defaultCallback,
        addedItem: options.addedItem || defaultCallback,
        flushedChanges: options.flushedChanges || defaultCallback
      };
    }

    return this.callbacks;
  };

  ReduceComputedProperty.prototype._hasInstanceMeta = function (context, propertyName) {
    var contextMeta = context.__ember_meta__;
    var cacheMeta = contextMeta && contextMeta.cacheMeta;
    return !!(cacheMeta && cacheMeta[propertyName]);
  };

  ReduceComputedProperty.prototype._instanceMeta = function (context, propertyName) {
    var contextMeta = context.__ember_meta__;
    var cacheMeta = contextMeta.cacheMeta;
    var meta = cacheMeta && cacheMeta[propertyName];

    if (!cacheMeta) {
      cacheMeta = contextMeta.cacheMeta = {};
    }
    if (!meta) {
      meta = cacheMeta[propertyName] = new ReduceComputedPropertyInstanceMeta(context, propertyName, this.initialValue());
      meta.dependentArraysObserver = new DependentArraysObserver(this._callbacks(), this, meta, context, propertyName, meta.sugarMeta);
    }

    return meta;
  };

  ReduceComputedProperty.prototype.initialValue = function () {
    if (typeof this.options.initialValue === 'function') {
      return this.options.initialValue();
    } else {
      return this.options.initialValue;
    }
  };

  ReduceComputedProperty.prototype.resetValue = function (value) {
    return this.initialValue();
  };

  ReduceComputedProperty.prototype.itemPropertyKey = function (dependentArrayKey, itemPropertyKey) {
    this._itemPropertyKeys[dependentArrayKey] = this._itemPropertyKeys[dependentArrayKey] || [];
    this._itemPropertyKeys[dependentArrayKey].push(itemPropertyKey);
  };

  ReduceComputedProperty.prototype.clearItemPropertyKeys = function (dependentArrayKey) {
    if (this._itemPropertyKeys[dependentArrayKey]) {
      this._previousItemPropertyKeys[dependentArrayKey] = this._itemPropertyKeys[dependentArrayKey];
      this._itemPropertyKeys[dependentArrayKey] = [];
    }
  };

  ReduceComputedProperty.prototype.property = function () {
    var cp = this;
    var args = a_slice.call(arguments);
    var propertyArgs = {};
    var match, dependentArrayKey;

    enumerable_utils.forEach(args, function (dependentKey) {
      if (doubleEachPropertyPattern.test(dependentKey)) {
        throw new EmberError['default']('Nested @each properties not supported: ' + dependentKey);
      } else if (match = eachPropertyPattern.exec(dependentKey)) {
        dependentArrayKey = match[1];

        var itemPropertyKeyPattern = match[2];
        var addItemPropertyKey = function (itemPropertyKey) {
          cp.itemPropertyKey(dependentArrayKey, itemPropertyKey);
        };

        expandProperties['default'](itemPropertyKeyPattern, addItemPropertyKey);
        propertyArgs[utils.guidFor(dependentArrayKey)] = dependentArrayKey;
      } else {
        propertyArgs[utils.guidFor(dependentKey)] = dependentKey;
      }
    });

    var propertyArgsToArray = [];
    for (var guid in propertyArgs) {
      propertyArgsToArray.push(propertyArgs[guid]);
    }

    return computed.ComputedProperty.prototype.property.apply(this, propertyArgsToArray);
  };
  function reduceComputed(options) {
    var args;

    if (arguments.length > 1) {
      args = a_slice.call(arguments, 0, -1);
      options = a_slice.call(arguments, -1)[0];
    }

    if (typeof options !== 'object') {
      throw new EmberError['default']('Reduce Computed Property declared without an options hash');
    }

    if (!('initialValue' in options)) {
      throw new EmberError['default']('Reduce Computed Property declared without an initial value');
    }

    var cp = new ReduceComputedProperty(options);

    if (args) {
      cp.property.apply(cp, args);
    }

    return cp;
  }

});
enifed('ember-runtime/computed/reduce_computed_macros', ['exports', 'ember-metal/core', 'ember-metal/property_get', 'ember-metal/utils', 'ember-metal/error', 'ember-metal/enumerable_utils', 'ember-metal/run_loop', 'ember-metal/observer', 'ember-runtime/computed/array_computed', 'ember-runtime/computed/reduce_computed', 'ember-runtime/system/subarray', 'ember-metal/keys', 'ember-runtime/compare'], function (exports, Ember, property_get, utils, EmberError, enumerable_utils, run, observer, array_computed, reduce_computed, SubArray, keys, compare) {

  'use strict';

  exports.sum = sum;
  exports.max = max;
  exports.min = min;
  exports.map = map;
  exports.mapBy = mapBy;
  exports.filter = filter;
  exports.filterBy = filterBy;
  exports.uniq = uniq;
  exports.intersect = intersect;
  exports.setDiff = setDiff;
  exports.sort = sort;

  /**
   A computed property that returns the sum of the value
   in the dependent array.

   @method sum
   @for Ember.computed
   @param {String} dependentKey
   @return {Ember.ComputedProperty} computes the sum of all values in the dependentKey's array
   @since 1.4.0
  */

  var a_slice = [].slice;
  function sum(dependentKey) {
    return reduce_computed.reduceComputed(dependentKey, {
      initialValue: 0,

      addedItem: function (accumulatedValue, item, changeMeta, instanceMeta) {
        return accumulatedValue + item;
      },

      removedItem: function (accumulatedValue, item, changeMeta, instanceMeta) {
        return accumulatedValue - item;
      }
    });
  }

  function max(dependentKey) {
    return reduce_computed.reduceComputed(dependentKey, {
      initialValue: -Infinity,

      addedItem: function (accumulatedValue, item, changeMeta, instanceMeta) {
        return Math.max(accumulatedValue, item);
      },

      removedItem: function (accumulatedValue, item, changeMeta, instanceMeta) {
        if (item < accumulatedValue) {
          return accumulatedValue;
        }
      }
    });
  }

  function min(dependentKey) {
    return reduce_computed.reduceComputed(dependentKey, {
      initialValue: Infinity,

      addedItem: function (accumulatedValue, item, changeMeta, instanceMeta) {
        return Math.min(accumulatedValue, item);
      },

      removedItem: function (accumulatedValue, item, changeMeta, instanceMeta) {
        if (item > accumulatedValue) {
          return accumulatedValue;
        }
      }
    });
  }

  function map(dependentKey, callback) {
    var options = {
      addedItem: function (array, item, changeMeta, instanceMeta) {
        var mapped = callback.call(this, item, changeMeta.index);
        array.insertAt(changeMeta.index, mapped);
        return array;
      },
      removedItem: function (array, item, changeMeta, instanceMeta) {
        array.removeAt(changeMeta.index, 1);
        return array;
      }
    };

    return array_computed.arrayComputed(dependentKey, options);
  }

  function mapBy(dependentKey, propertyKey) {
    var callback = function (item) {
      return property_get.get(item, propertyKey);
    };
    return map(dependentKey + '.@each.' + propertyKey, callback);
  }

  /**
    @method mapProperty
    @for Ember.computed
    @deprecated Use `Ember.computed.mapBy` instead
    @param dependentKey
    @param propertyKey
  */
  var mapProperty = mapBy;function filter(dependentKey, callback) {
    var options = {
      initialize: function (array, changeMeta, instanceMeta) {
        instanceMeta.filteredArrayIndexes = new SubArray['default']();
      },

      addedItem: function (array, item, changeMeta, instanceMeta) {
        var match = !!callback.call(this, item, changeMeta.index, changeMeta.arrayChanged);
        var filterIndex = instanceMeta.filteredArrayIndexes.addItem(changeMeta.index, match);

        if (match) {
          array.insertAt(filterIndex, item);
        }

        return array;
      },

      removedItem: function (array, item, changeMeta, instanceMeta) {
        var filterIndex = instanceMeta.filteredArrayIndexes.removeItem(changeMeta.index);

        if (filterIndex > -1) {
          array.removeAt(filterIndex);
        }

        return array;
      }
    };

    return array_computed.arrayComputed(dependentKey, options);
  }

  function filterBy(dependentKey, propertyKey, value) {
    var callback;

    if (arguments.length === 2) {
      callback = function (item) {
        return property_get.get(item, propertyKey);
      };
    } else {
      callback = function (item) {
        return property_get.get(item, propertyKey) === value;
      };
    }

    return filter(dependentKey + '.@each.' + propertyKey, callback);
  }

  /**
    @method filterProperty
    @for Ember.computed
    @param dependentKey
    @param propertyKey
    @param value
    @deprecated Use `Ember.computed.filterBy` instead
  */
  var filterProperty = filterBy;function uniq() {
    var args = a_slice.call(arguments);

    args.push({
      initialize: function (array, changeMeta, instanceMeta) {
        instanceMeta.itemCounts = {};
      },

      addedItem: function (array, item, changeMeta, instanceMeta) {
        var guid = utils.guidFor(item);

        if (!instanceMeta.itemCounts[guid]) {
          instanceMeta.itemCounts[guid] = 1;
          array.pushObject(item);
        } else {
          ++instanceMeta.itemCounts[guid];
        }
        return array;
      },

      removedItem: function (array, item, _, instanceMeta) {
        var guid = utils.guidFor(item);
        var itemCounts = instanceMeta.itemCounts;

        if (--itemCounts[guid] === 0) {
          array.removeObject(item);
        }

        return array;
      }
    });

    return array_computed.arrayComputed.apply(null, args);
  }

  /**
    Alias for [Ember.computed.uniq](/api/#method_computed_uniq).

    @method union
    @for Ember.computed
    @param {String} propertyKey*
    @return {Ember.ComputedProperty} computes a new array with all the
    unique elements from the dependent array
  */
  var union = uniq;function intersect() {
    var args = a_slice.call(arguments);

    args.push({
      initialize: function (array, changeMeta, instanceMeta) {
        instanceMeta.itemCounts = {};
      },

      addedItem: function (array, item, changeMeta, instanceMeta) {
        var itemGuid = utils.guidFor(item);
        var dependentGuid = utils.guidFor(changeMeta.arrayChanged);
        var numberOfDependentArrays = changeMeta.property._dependentKeys.length;
        var itemCounts = instanceMeta.itemCounts;

        if (!itemCounts[itemGuid]) {
          itemCounts[itemGuid] = {};
        }

        if (itemCounts[itemGuid][dependentGuid] === undefined) {
          itemCounts[itemGuid][dependentGuid] = 0;
        }

        if (++itemCounts[itemGuid][dependentGuid] === 1 && numberOfDependentArrays === keys['default'](itemCounts[itemGuid]).length) {
          array.addObject(item);
        }

        return array;
      },

      removedItem: function (array, item, changeMeta, instanceMeta) {
        var itemGuid = utils.guidFor(item);
        var dependentGuid = utils.guidFor(changeMeta.arrayChanged);
        var numberOfArraysItemAppearsIn;
        var itemCounts = instanceMeta.itemCounts;

        if (itemCounts[itemGuid][dependentGuid] === undefined) {
          itemCounts[itemGuid][dependentGuid] = 0;
        }

        if (--itemCounts[itemGuid][dependentGuid] === 0) {
          delete itemCounts[itemGuid][dependentGuid];
          numberOfArraysItemAppearsIn = keys['default'](itemCounts[itemGuid]).length;

          if (numberOfArraysItemAppearsIn === 0) {
            delete itemCounts[itemGuid];
          }

          array.removeObject(item);
        }

        return array;
      }
    });

    return array_computed.arrayComputed.apply(null, args);
  }

  function setDiff(setAProperty, setBProperty) {
    if (arguments.length !== 2) {
      throw new EmberError['default']('setDiff requires exactly two dependent arrays.');
    }

    return array_computed.arrayComputed(setAProperty, setBProperty, {
      addedItem: function (array, item, changeMeta, instanceMeta) {
        var setA = property_get.get(this, setAProperty);
        var setB = property_get.get(this, setBProperty);

        if (changeMeta.arrayChanged === setA) {
          if (!setB.contains(item)) {
            array.addObject(item);
          }
        } else {
          array.removeObject(item);
        }

        return array;
      },

      removedItem: function (array, item, changeMeta, instanceMeta) {
        var setA = property_get.get(this, setAProperty);
        var setB = property_get.get(this, setBProperty);

        if (changeMeta.arrayChanged === setB) {
          if (setA.contains(item)) {
            array.addObject(item);
          }
        } else {
          array.removeObject(item);
        }

        return array;
      }
    });
  }

  function binarySearch(array, item, low, high) {
    var mid, midItem, res, guidMid, guidItem;

    if (arguments.length < 4) {
      high = property_get.get(array, 'length');
    }

    if (arguments.length < 3) {
      low = 0;
    }

    if (low === high) {
      return low;
    }

    mid = low + Math.floor((high - low) / 2);
    midItem = array.objectAt(mid);

    guidMid = utils.guidFor(midItem);
    guidItem = utils.guidFor(item);

    if (guidMid === guidItem) {
      return mid;
    }

    res = this.order(midItem, item);

    if (res === 0) {
      res = guidMid < guidItem ? -1 : 1;
    }

    if (res < 0) {
      return this.binarySearch(array, item, mid + 1, high);
    } else if (res > 0) {
      return this.binarySearch(array, item, low, mid);
    }

    return mid;
  }
  function sort(itemsKey, sortDefinition) {
    
    if (typeof sortDefinition === 'function') {
      return customSort(itemsKey, sortDefinition);
    } else {
      return propertySort(itemsKey, sortDefinition);
    }
  }

  function customSort(itemsKey, comparator) {
    return array_computed.arrayComputed(itemsKey, {
      initialize: function (array, changeMeta, instanceMeta) {
        instanceMeta.order = comparator;
        instanceMeta.binarySearch = binarySearch;
        instanceMeta.waitingInsertions = [];
        instanceMeta.insertWaiting = function () {
          var index, item;
          var waiting = instanceMeta.waitingInsertions;
          instanceMeta.waitingInsertions = [];
          for (var i = 0; i < waiting.length; i++) {
            item = waiting[i];
            index = instanceMeta.binarySearch(array, item);
            array.insertAt(index, item);
          }
        };
        instanceMeta.insertLater = function (item) {
          this.waitingInsertions.push(item);
        };
      },

      addedItem: function (array, item, changeMeta, instanceMeta) {
        instanceMeta.insertLater(item);
        return array;
      },

      removedItem: function (array, item, changeMeta, instanceMeta) {
        array.removeObject(item);
        return array;
      },

      flushedChanges: function (array, instanceMeta) {
        instanceMeta.insertWaiting();
      }
    });
  }

  function propertySort(itemsKey, sortPropertiesKey) {
    return array_computed.arrayComputed(itemsKey, {
      initialize: function (array, changeMeta, instanceMeta) {
        function setupSortProperties() {
          var sortPropertyDefinitions = property_get.get(this, sortPropertiesKey);
          var sortProperties = instanceMeta.sortProperties = [];
          var sortPropertyAscending = instanceMeta.sortPropertyAscending = {};
          var sortProperty, idx, asc;

          
          changeMeta.property.clearItemPropertyKeys(itemsKey);

          enumerable_utils.forEach(sortPropertyDefinitions, function (sortPropertyDefinition) {
            if ((idx = sortPropertyDefinition.indexOf(':')) !== -1) {
              sortProperty = sortPropertyDefinition.substring(0, idx);
              asc = sortPropertyDefinition.substring(idx + 1).toLowerCase() !== 'desc';
            } else {
              sortProperty = sortPropertyDefinition;
              asc = true;
            }

            sortProperties.push(sortProperty);
            sortPropertyAscending[sortProperty] = asc;
            changeMeta.property.itemPropertyKey(itemsKey, sortProperty);
          });

          this.addObserver(sortPropertiesKey + '.@each', this, updateSortPropertiesOnce);
        }

        function updateSortPropertiesOnce() {
          run['default'].once(this, updateSortProperties, changeMeta.propertyName);
        }

        function updateSortProperties(propertyName) {
          setupSortProperties.call(this);
          changeMeta.property.recomputeOnce.call(this, propertyName);
        }

        observer.addObserver(this, sortPropertiesKey, updateSortPropertiesOnce);
        setupSortProperties.call(this);

        instanceMeta.order = function (itemA, itemB) {
          var sortProperty, result, asc;
          var keyA = this.keyFor(itemA);
          var keyB = this.keyFor(itemB);

          for (var i = 0; i < this.sortProperties.length; ++i) {
            sortProperty = this.sortProperties[i];

            result = compare['default'](keyA[sortProperty], keyB[sortProperty]);

            if (result !== 0) {
              asc = this.sortPropertyAscending[sortProperty];
              return asc ? result : -1 * result;
            }
          }

          return 0;
        };

        instanceMeta.binarySearch = binarySearch;
        setupKeyCache(instanceMeta);
      },

      addedItem: function (array, item, changeMeta, instanceMeta) {
        var index = instanceMeta.binarySearch(array, item);
        array.insertAt(index, item);
        return array;
      },

      removedItem: function (array, item, changeMeta, instanceMeta) {
        var index = instanceMeta.binarySearch(array, item);
        array.removeAt(index);
        instanceMeta.dropKeyFor(item);
        return array;
      }
    });
  }

  function setupKeyCache(instanceMeta) {
    instanceMeta.keyFor = function (item) {
      var guid = utils.guidFor(item);
      if (this.keyCache[guid]) {
        return this.keyCache[guid];
      }
      var sortProperty;
      var key = {};
      for (var i = 0; i < this.sortProperties.length; ++i) {
        sortProperty = this.sortProperties[i];
        key[sortProperty] = property_get.get(item, sortProperty);
      }
      return this.keyCache[guid] = key;
    };

    instanceMeta.dropKeyFor = function (item) {
      var guid = utils.guidFor(item);
      this.keyCache[guid] = null;
    };

    instanceMeta.keyCache = {};
  }

  exports.mapProperty = mapProperty;
  exports.filterProperty = filterProperty;
  exports.union = union;

});
enifed('ember-runtime/controllers/array_controller', ['exports', 'ember-metal/core', 'ember-metal/property_get', 'ember-metal/enumerable_utils', 'ember-runtime/system/array_proxy', 'ember-runtime/mixins/sortable', 'ember-runtime/mixins/controller', 'ember-metal/computed', 'ember-metal/error', 'ember-runtime/mixins/array'], function (exports, Ember, property_get, enumerable_utils, ArrayProxy, SortableMixin, ControllerMixin, computed, EmberError, EmberArray) {

  'use strict';

  /**
  @module ember
  @submodule ember-runtime
  */

  exports['default'] = ArrayProxy['default'].extend(ControllerMixin['default'], SortableMixin['default'], {

    /**
      A string containing the controller name used to wrap items.
       For example:
       ```javascript
      App.MyArrayController = Ember.ArrayController.extend({
        itemController: 'myItem' // use App.MyItemController
      });
      ```
       @property itemController
      @type String
      @default null
    */
    itemController: null,

    /**
      Return the name of the controller to wrap items, or `null` if items should
      be returned directly.  The default implementation simply returns the
      `itemController` property, but subclasses can override this method to return
      different controllers for different objects.
       For example:
       ```javascript
      App.MyArrayController = Ember.ArrayController.extend({
        lookupItemController: function( object ) {
          if (object.get('isSpecial')) {
            return "special"; // use App.SpecialController
          } else {
            return "regular"; // use App.RegularController
          }
        }
      });
      ```
       @method lookupItemController
      @param {Object} object
      @return {String}
    */
    lookupItemController: function (object) {
      return property_get.get(this, 'itemController');
    },

    objectAtContent: function (idx) {
      var length = property_get.get(this, 'length');
      var arrangedContent = property_get.get(this, 'arrangedContent');
      var object = arrangedContent && arrangedContent.objectAt(idx);
      var controllerClass;

      if (idx >= 0 && idx < length) {
        controllerClass = this.lookupItemController(object);

        if (controllerClass) {
          return this.controllerAt(idx, object, controllerClass);
        }
      }

      // When `controllerClass` is falsy, we have not opted in to using item
      // controllers, so return the object directly.

      // When the index is out of range, we want to return the "out of range"
      // value, whatever that might be.  Rather than make assumptions
      // (e.g. guessing `null` or `undefined`) we defer this to `arrangedContent`.
      return object;
    },

    arrangedContentDidChange: function () {
      this._super.apply(this, arguments);
      this._resetSubControllers();
    },

    arrayContentDidChange: function (idx, removedCnt, addedCnt) {
      var subControllers = this._subControllers;

      if (subControllers.length) {
        var subControllersToRemove = subControllers.slice(idx, idx + removedCnt);

        enumerable_utils.forEach(subControllersToRemove, function (subController) {
          if (subController) {
            subController.destroy();
          }
        });

        enumerable_utils.replace(subControllers, idx, removedCnt, new Array(addedCnt));
      }

      // The shadow array of subcontrollers must be updated before we trigger
      // observers, otherwise observers will get the wrong subcontainer when
      // calling `objectAt`
      this._super(idx, removedCnt, addedCnt);
    },

    init: function () {
      this._super.apply(this, arguments);
      this._subControllers = [];
    },

    model: computed.computed({
      get: function (key) {
        return Ember['default'].A();
      },
      set: function (key, value) {
        
        return value;
      }
    }),

    /**
     * Flag to mark as being "virtual". Used to keep this instance
     * from participating in the parentController hierarchy.
     *
     * @private
     * @property _isVirtual
     * @type Boolean
     */
    _isVirtual: false,

    controllerAt: function (idx, object, controllerClass) {
      var container = property_get.get(this, 'container');
      var subControllers = this._subControllers;
      var fullName, subController, parentController;

      if (subControllers.length > idx) {
        subController = subControllers[idx];

        if (subController) {
          return subController;
        }
      }

      if (this._isVirtual) {
        parentController = property_get.get(this, 'parentController');
      } else {
        parentController = this;
      }

      fullName = 'controller:' + controllerClass;

      if (!container._registry.has(fullName)) {
        throw new EmberError['default']('Could not resolve itemController: "' + controllerClass + '"');
      }

      subController = container.lookupFactory(fullName).create({
        target: parentController,
        parentController: parentController,
        model: object
      });

      subControllers[idx] = subController;

      return subController;
    },

    _subControllers: null,

    _resetSubControllers: function () {
      var controller;
      var subControllers = this._subControllers;

      if (subControllers.length) {
        for (var i = 0, length = subControllers.length; length > i; i++) {
          controller = subControllers[i];

          if (controller) {
            controller.destroy();
          }
        }

        subControllers.length = 0;
      }
    },

    willDestroy: function () {
      this._resetSubControllers();
      this._super.apply(this, arguments);
    }
  });

});
enifed('ember-runtime/controllers/controller', ['exports', 'ember-metal/core', 'ember-runtime/system/object', 'ember-runtime/mixins/controller', 'ember-runtime/inject'], function (exports, Ember, EmberObject, Mixin, inject) {

  'use strict';

  var Controller = EmberObject['default'].extend(Mixin['default']);

  function controllerInjectionHelper(factory) {
      }

  /**
    Creates a property that lazily looks up another controller in the container.
    Can only be used when defining another controller.

    Example:

    ```javascript
    App.PostController = Ember.Controller.extend({
      posts: Ember.inject.controller()
    });
    ```

    This example will create a `posts` property on the `post` controller that
    looks up the `posts` controller in the container, making it easy to
    reference other controllers. This is functionally equivalent to:

    ```javascript
    App.PostController = Ember.Controller.extend({
      needs: 'posts',
      posts: Ember.computed.alias('controllers.posts')
    });
    ```

    @method controller
    @since 1.10.0
    @for Ember.inject
    @param {String} name (optional) name of the controller to inject, defaults
           to the property's name
    @return {Ember.InjectedProperty} injection descriptor instance
    */
  inject.createInjectionHelper('controller', controllerInjectionHelper);

  exports['default'] = Controller;

});
enifed('ember-runtime/controllers/object_controller', ['exports', 'ember-metal/core', 'ember-runtime/mixins/controller', 'ember-runtime/system/object_proxy'], function (exports, Ember, ControllerMixin, ObjectProxy) {

  'use strict';

  var objectControllerDeprecation = 'Ember.ObjectController is deprecated, ' + 'please use Ember.Controller and use `model.propertyName`.';

  exports['default'] = ObjectProxy['default'].extend(ControllerMixin['default'], {
    init: function () {
      this._super();
          }
  });

  exports.objectControllerDeprecation = objectControllerDeprecation;

});
enifed('ember-runtime/copy', ['exports', 'ember-metal/enumerable_utils', 'ember-metal/utils', 'ember-runtime/system/object', 'ember-runtime/mixins/copyable'], function (exports, enumerable_utils, utils, EmberObject, Copyable) {

  'use strict';



  /**
    Creates a clone of the passed object. This function can take just about
    any type of object and create a clone of it, including primitive values
    (which are not actually cloned because they are immutable).

    If the passed object implements the `copy()` method, then this function
    will simply call that method and return the result. Please see
    `Ember.Copyable` for further details.

    @method copy
    @for Ember
    @param {Object} obj The object to clone
    @param {Boolean} deep If true, a deep copy of the object is made
    @return {Object} The cloned object
  */
  exports['default'] = copy;
  function _copy(obj, deep, seen, copies) {
    var ret, loc, key;

    // primitive data types are immutable, just return them.
    if (typeof obj !== 'object' || obj === null) {
      return obj;
    }

    // avoid cyclical loops
    if (deep && (loc = enumerable_utils.indexOf(seen, obj)) >= 0) {
      return copies[loc];
    }

    
    // IMPORTANT: this specific test will detect a native array only. Any other
    // object will need to implement Copyable.
    if (utils.typeOf(obj) === 'array') {
      ret = obj.slice();

      if (deep) {
        loc = ret.length;

        while (--loc >= 0) {
          ret[loc] = _copy(ret[loc], deep, seen, copies);
        }
      }
    } else if (Copyable['default'] && Copyable['default'].detect(obj)) {
      ret = obj.copy(deep, seen, copies);
    } else if (obj instanceof Date) {
      ret = new Date(obj.getTime());
    } else {
      ret = {};

      for (key in obj) {
        // support Null prototype
        if (!Object.prototype.hasOwnProperty.call(obj, key)) {
          continue;
        }

        // Prevents browsers that don't respect non-enumerability from
        // copying internal Ember properties
        if (key.substring(0, 2) === '__') {
          continue;
        }

        ret[key] = deep ? _copy(obj[key], deep, seen, copies) : obj[key];
      }
    }

    if (deep) {
      seen.push(obj);
      copies.push(ret);
    }

    return ret;
  }
  function copy(obj, deep) {
    // fast paths
    if ('object' !== typeof obj || obj === null) {
      return obj; // can't copy primitives
    }

    if (Copyable['default'] && Copyable['default'].detect(obj)) {
      return obj.copy(deep);
    }

    return _copy(obj, deep, deep ? [] : null, deep ? [] : null);
  }

});
enifed('ember-runtime/core', ['exports'], function (exports) {

  'use strict';

  exports.isEqual = isEqual;

  /**
  @module ember
  @submodule ember-runtime
  */

  /**
    Compares two objects, returning true if they are logically equal. This is
    a deeper comparison than a simple triple equal. For sets it will compare the
    internal objects. For any other object that implements `isEqual()` it will
    respect that method.

    ```javascript
    Ember.isEqual('hello', 'hello');  // true
    Ember.isEqual(1, 2);              // false
    Ember.isEqual([4, 2], [4, 2]);    // false
    ```

    @method isEqual
    @for Ember
    @param {Object} a first object to compare
    @param {Object} b second object to compare
    @return {Boolean}
  */
  function isEqual(a, b) {
    if (a && typeof a.isEqual === 'function') {
      return a.isEqual(b);
    }

    if (a instanceof Date && b instanceof Date) {
      return a.getTime() === b.getTime();
    }

    return a === b;
  }

});
enifed('ember-runtime/ext/function', ['ember-metal/core', 'ember-metal/expand_properties', 'ember-metal/computed', 'ember-metal/mixin'], function (Ember, expandProperties, computed, mixin) {

  'use strict';

  /**
  @module ember
  @submodule ember-runtime
  */

  var a_slice = Array.prototype.slice;
  var FunctionPrototype = Function.prototype;

  if (Ember['default'].EXTEND_PROTOTYPES === true || Ember['default'].EXTEND_PROTOTYPES.Function) {

    /**
      The `property` extension of Javascript's Function prototype is available
      when `Ember.EXTEND_PROTOTYPES` or `Ember.EXTEND_PROTOTYPES.Function` is
      `true`, which is the default.
       Computed properties allow you to treat a function like a property:
       ```javascript
      MyApp.President = Ember.Object.extend({
        firstName: '',
        lastName:  '',
         fullName: function() {
          return this.get('firstName') + ' ' + this.get('lastName');
        }.property() // Call this flag to mark the function as a property
      });
       var president = MyApp.President.create({
        firstName: 'Barack',
        lastName: 'Obama'
      });
       president.get('fullName'); // 'Barack Obama'
      ```
       Treating a function like a property is useful because they can work with
      bindings, just like any other property.
       Many computed properties have dependencies on other properties. For
      example, in the above example, the `fullName` property depends on
      `firstName` and `lastName` to determine its value. You can tell Ember
      about these dependencies like this:
       ```javascript
      MyApp.President = Ember.Object.extend({
        firstName: '',
        lastName:  '',
         fullName: function() {
          return this.get('firstName') + ' ' + this.get('lastName');
           // Tell Ember.js that this computed property depends on firstName
          // and lastName
        }.property('firstName', 'lastName')
      });
      ```
       Make sure you list these dependencies so Ember knows when to update
      bindings that connect to a computed property. Changing a dependency
      will not immediately trigger an update of the computed property, but
      will instead clear the cache so that it is updated when the next `get`
      is called on the property.
       See [Ember.ComputedProperty](/api/classes/Ember.ComputedProperty.html), [Ember.computed](/api/#method_computed).
       @method property
      @for Function
    */
    FunctionPrototype.property = function () {
      var ret = computed.computed(this);
      // ComputedProperty.prototype.property expands properties; no need for us to
      // do so here.
      return ret.property.apply(ret, arguments);
    };

    /**
      The `observes` extension of Javascript's Function prototype is available
      when `Ember.EXTEND_PROTOTYPES` or `Ember.EXTEND_PROTOTYPES.Function` is
      true, which is the default.
       You can observe property changes simply by adding the `observes`
      call to the end of your method declarations in classes that you write.
      For example:
       ```javascript
      Ember.Object.extend({
        valueObserver: function() {
          // Executes whenever the "value" property changes
        }.observes('value')
      });
      ```
       In the future this method may become asynchronous. If you want to ensure
      synchronous behavior, use `observesImmediately`.
       See `Ember.observer`.
       @method observes
      @for Function
    */
    FunctionPrototype.observes = function () {
      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      args.push(this);
      return mixin.observer.apply(this, args);
    };

    /**
      The `observesImmediately` extension of Javascript's Function prototype is
      available when `Ember.EXTEND_PROTOTYPES` or
      `Ember.EXTEND_PROTOTYPES.Function` is true, which is the default.
       You can observe property changes simply by adding the `observesImmediately`
      call to the end of your method declarations in classes that you write.
      For example:
       ```javascript
      Ember.Object.extend({
        valueObserver: function() {
          // Executes immediately after the "value" property changes
        }.observesImmediately('value')
      });
      ```
       In the future, `observes` may become asynchronous. In this event,
      `observesImmediately` will maintain the synchronous behavior.
       See `Ember.immediateObserver`.
       @method observesImmediately
      @for Function
    */
    FunctionPrototype.observesImmediately = function () {
      
      // observes handles property expansion
      return this.observes.apply(this, arguments);
    };

    /**
      The `observesBefore` extension of Javascript's Function prototype is
      available when `Ember.EXTEND_PROTOTYPES` or
      `Ember.EXTEND_PROTOTYPES.Function` is true, which is the default.
       You can get notified when a property change is about to happen by
      adding the `observesBefore` call to the end of your method
      declarations in classes that you write. For example:
       ```javascript
      Ember.Object.extend({
        valueObserver: function() {
          // Executes whenever the "value" property is about to change
        }.observesBefore('value')
      });
      ```
       See `Ember.beforeObserver`.
       @method observesBefore
      @for Function
    */
    FunctionPrototype.observesBefore = function () {
      var watched = [];
      var addWatchedProperty = function (obs) {
        watched.push(obs);
      };

      for (var i = 0, l = arguments.length; i < l; ++i) {
        expandProperties['default'](arguments[i], addWatchedProperty);
      }

      this.__ember_observesBefore__ = watched;

      return this;
    };

    /**
      The `on` extension of Javascript's Function prototype is available
      when `Ember.EXTEND_PROTOTYPES` or `Ember.EXTEND_PROTOTYPES.Function` is
      true, which is the default.
       You can listen for events simply by adding the `on` call to the end of
      your method declarations in classes or mixins that you write. For example:
       ```javascript
      Ember.Mixin.create({
        doSomethingWithElement: function() {
          // Executes whenever the "didInsertElement" event fires
        }.on('didInsertElement')
      });
      ```
       See `Ember.on`.
       @method on
      @for Function
    */
    FunctionPrototype.on = function () {
      var events = a_slice.call(arguments);
      this.__ember_listens__ = events;

      return this;
    };
  }

});
enifed('ember-runtime/ext/rsvp', ['exports', 'ember-metal/core', 'ember-metal/logger', 'ember-metal/run_loop', 'rsvp'], function (exports, Ember, Logger, run, RSVP) {

  'use strict';

  exports.onerrorDefault = onerrorDefault;

  var testModuleName = 'ember-testing/test';
  var Test;

  var asyncStart = function () {
    if (Ember['default'].Test && Ember['default'].Test.adapter) {
      Ember['default'].Test.adapter.asyncStart();
    }
  };

  var asyncEnd = function () {
    if (Ember['default'].Test && Ember['default'].Test.adapter) {
      Ember['default'].Test.adapter.asyncEnd();
    }
  };

  RSVP.configure('async', function (callback, promise) {
    var async = !run['default'].currentRunLoop;

    if (Ember['default'].testing && async) {
      asyncStart();
    }

    run['default'].backburner.schedule('actions', function () {
      if (Ember['default'].testing && async) {
        asyncEnd();
      }
      callback(promise);
    });
  });

  RSVP.Promise.prototype.fail = function (callback, label) {
        return this['catch'](callback, label);
  };
  function onerrorDefault(e) {
    var error;

    if (e && e.errorThrown) {
      // jqXHR provides this
      error = e.errorThrown;
      if (typeof error === 'string') {
        error = new Error(error);
      }
      error.__reason_with_error_thrown__ = e;
    } else {
      error = e;
    }

    if (error && error.name !== 'TransitionAborted') {
      if (Ember['default'].testing) {
        // ES6TODO: remove when possible
        if (!Test && Ember['default'].__loader.registry[testModuleName]) {
          Test = requireModule(testModuleName)['default'];
        }

        if (Test && Test.adapter) {
          Test.adapter.exception(error);
          Logger['default'].error(error.stack);
        } else {
          throw error;
        }
      } else if (Ember['default'].onerror) {
        Ember['default'].onerror(error);
      } else {
        Logger['default'].error(error.stack);
      }
    }
  }

  RSVP.on('error', onerrorDefault);

  exports['default'] = RSVP;

});
enifed('ember-runtime/ext/string', ['ember-metal/core', 'ember-runtime/system/string'], function (Ember, string) {

  'use strict';

  /**
  @module ember
  @submodule ember-runtime
  */

  var StringPrototype = String.prototype;

  if (Ember['default'].EXTEND_PROTOTYPES === true || Ember['default'].EXTEND_PROTOTYPES.String) {

    /**
      See [Ember.String.fmt](/api/classes/Ember.String.html#method_fmt).
       @method fmt
      @for String
    */
    StringPrototype.fmt = function () {
      return string.fmt(this, arguments);
    };

    /**
      See [Ember.String.w](/api/classes/Ember.String.html#method_w).
       @method w
      @for String
    */
    StringPrototype.w = function () {
      return string.w(this);
    };

    /**
      See [Ember.String.loc](/api/classes/Ember.String.html#method_loc).
       @method loc
      @for String
    */
    StringPrototype.loc = function () {
      return string.loc(this, arguments);
    };

    /**
      See [Ember.String.camelize](/api/classes/Ember.String.html#method_camelize).
       @method camelize
      @for String
    */
    StringPrototype.camelize = function () {
      return string.camelize(this);
    };

    /**
      See [Ember.String.decamelize](/api/classes/Ember.String.html#method_decamelize).
       @method decamelize
      @for String
    */
    StringPrototype.decamelize = function () {
      return string.decamelize(this);
    };

    /**
      See [Ember.String.dasherize](/api/classes/Ember.String.html#method_dasherize).
       @method dasherize
      @for String
    */
    StringPrototype.dasherize = function () {
      return string.dasherize(this);
    };

    /**
      See [Ember.String.underscore](/api/classes/Ember.String.html#method_underscore).
       @method underscore
      @for String
    */
    StringPrototype.underscore = function () {
      return string.underscore(this);
    };

    /**
      See [Ember.String.classify](/api/classes/Ember.String.html#method_classify).
       @method classify
      @for String
    */
    StringPrototype.classify = function () {
      return string.classify(this);
    };

    /**
      See [Ember.String.capitalize](/api/classes/Ember.String.html#method_capitalize).
       @method capitalize
      @for String
    */
    StringPrototype.capitalize = function () {
      return string.capitalize(this);
    };
  }

});
enifed('ember-runtime/inject', ['exports', 'ember-metal/core', 'ember-metal/enumerable_utils', 'ember-metal/injected_property', 'ember-metal/keys'], function (exports, Ember, enumerable_utils, InjectedProperty, keys) {

  'use strict';

  exports.createInjectionHelper = createInjectionHelper;
  exports.validatePropertyInjections = validatePropertyInjections;

  /**
    This method allows other Ember modules to register injection helpers for a
    given container type. Helpers are exported to the `inject` namespace as the
    container type itself.

    @private
    @method createInjectionHelper
    @since 1.10.0
    @for Ember
    @param {String} type The container type the helper will inject
    @param {Function} validator A validation callback that is executed at mixin-time
  */
  function inject() {
      }

  // Dictionary of injection validations by type, added to by `createInjectionHelper`
  var typeValidators = {};
  function createInjectionHelper(type, validator) {
    typeValidators[type] = validator;

    inject[type] = function (name) {
      return new InjectedProperty['default'](type, name);
    };
  }

  function validatePropertyInjections(factory) {
    var proto = factory.proto();
    var types = [];
    var key, desc, validator, i, l;

    for (key in proto) {
      desc = proto[key];
      if (desc instanceof InjectedProperty['default'] && enumerable_utils.indexOf(types, desc.type) === -1) {
        types.push(desc.type);
      }
    }

    if (types.length) {
      for (i = 0, l = types.length; i < l; i++) {
        validator = typeValidators[types[i]];

        if (typeof validator === "function") {
          validator(factory);
        }
      }
    }

    return true;
  }

  exports['default'] = inject;

});
enifed('ember-runtime/mixins/-proxy', ['exports', 'ember-metal/core', 'ember-metal/property_get', 'ember-metal/property_set', 'ember-metal/utils', 'ember-metal/observer', 'ember-metal/property_events', 'ember-metal/computed', 'ember-metal/properties', 'ember-metal/mixin', 'ember-runtime/system/string'], function (exports, Ember, property_get, property_set, utils, observer, property_events, computed, properties, mixin, string) {

  'use strict';

  /**
  @module ember
  @submodule ember-runtime
  */

  function contentPropertyWillChange(content, contentKey) {
    var key = contentKey.slice(8); // remove "content."
    if (key in this) {
      return;
    } // if shadowed in proxy
    property_events.propertyWillChange(this, key);
  }

  function contentPropertyDidChange(content, contentKey) {
    var key = contentKey.slice(8); // remove "content."
    if (key in this) {
      return;
    } // if shadowed in proxy
    property_events.propertyDidChange(this, key);
  }

  /**
    `Ember.ProxyMixin` forwards all properties not defined by the proxy itself
    to a proxied `content` object.  See Ember.ObjectProxy for more details.

    @class ProxyMixin
    @namespace Ember
  */
  exports['default'] = mixin.Mixin.create({
    /**
      The object whose properties will be forwarded.
       @property content
      @type Ember.Object
      @default null
    */
    content: null,
    _contentDidChange: mixin.observer("content", function () {
          }),

    isTruthy: computed.computed.bool("content"),

    _debugContainerKey: null,

    willWatchProperty: function (key) {
      var contentKey = "content." + key;
      observer.addBeforeObserver(this, contentKey, null, contentPropertyWillChange);
      observer.addObserver(this, contentKey, null, contentPropertyDidChange);
    },

    didUnwatchProperty: function (key) {
      var contentKey = "content." + key;
      observer.removeBeforeObserver(this, contentKey, null, contentPropertyWillChange);
      observer.removeObserver(this, contentKey, null, contentPropertyDidChange);
    },

    unknownProperty: function (key) {
      var content = property_get.get(this, "content");
      if (content) {
                return property_get.get(content, key);
      }
    },

    setUnknownProperty: function (key, value) {
      var m = utils.meta(this);
      if (m.proto === this) {
        // if marked as prototype then just defineProperty
        // rather than delegate
        properties.defineProperty(this, key, null, value);
        return value;
      }

      var content = property_get.get(this, "content");
      
            return property_set.set(content, key, value);
    }

  });

});
enifed('ember-runtime/mixins/action_handler', ['exports', 'ember-metal/merge', 'ember-metal/mixin', 'ember-metal/property_get', 'ember-metal/utils'], function (exports, merge, mixin, property_get, utils) {

  'use strict';

  /**
  @module ember
  @submodule ember-runtime
  */
  var ActionHandler = mixin.Mixin.create({
    mergedProperties: ["_actions"],

    /**
      The collection of functions, keyed by name, available on this
      `ActionHandler` as action targets.
       These functions will be invoked when a matching `{{action}}` is triggered
      from within a template and the application's current route is this route.
       Actions can also be invoked from other parts of your application
      via `ActionHandler#send`.
       The `actions` hash will inherit action handlers from
      the `actions` hash defined on extended parent classes
      or mixins rather than just replace the entire hash, e.g.:
       ```js
      App.CanDisplayBanner = Ember.Mixin.create({
        actions: {
          displayBanner: function(msg) {
            // ...
          }
        }
      });
       App.WelcomeRoute = Ember.Route.extend(App.CanDisplayBanner, {
        actions: {
          playMusic: function() {
            // ...
          }
        }
      });
       // `WelcomeRoute`, when active, will be able to respond
      // to both actions, since the actions hash is merged rather
      // then replaced when extending mixins / parent classes.
      this.send('displayBanner');
      this.send('playMusic');
      ```
       Within a Controller, Route, View or Component's action handler,
      the value of the `this` context is the Controller, Route, View or
      Component object:
       ```js
      App.SongRoute = Ember.Route.extend({
        actions: {
          myAction: function() {
            this.controllerFor("song");
            this.transitionTo("other.route");
            ...
          }
        }
      });
      ```
       It is also possible to call `this._super.apply(this, arguments)` from within an
      action handler if it overrides a handler defined on a parent
      class or mixin:
       Take for example the following routes:
       ```js
      App.DebugRoute = Ember.Mixin.create({
        actions: {
          debugRouteInformation: function() {
            console.debug("trololo");
          }
        }
      });
       App.AnnoyingDebugRoute = Ember.Route.extend(App.DebugRoute, {
        actions: {
          debugRouteInformation: function() {
            // also call the debugRouteInformation of mixed in App.DebugRoute
            this._super.apply(this, arguments);
             // show additional annoyance
            window.alert(...);
          }
        }
      });
      ```
       ## Bubbling
       By default, an action will stop bubbling once a handler defined
      on the `actions` hash handles it. To continue bubbling the action,
      you must return `true` from the handler:
       ```js
      App.Router.map(function() {
        this.resource("album", function() {
          this.route("song");
        });
      });
       App.AlbumRoute = Ember.Route.extend({
        actions: {
          startPlaying: function() {
          }
        }
      });
       App.AlbumSongRoute = Ember.Route.extend({
        actions: {
          startPlaying: function() {
            // ...
             if (actionShouldAlsoBeTriggeredOnParentRoute) {
              return true;
            }
          }
        }
      });
      ```
       @property actions
      @type Hash
      @default null
    */

    /**
      Moves `actions` to `_actions` at extend time. Note that this currently
      modifies the mixin themselves, which is technically dubious but
      is practically of little consequence. This may change in the future.
       @private
      @method willMergeMixin
    */
    willMergeMixin: function (props) {
      var hashName;

      if (!props._actions) {
        
        if (utils.typeOf(props.actions) === "object") {
          hashName = "actions";
        } else if (utils.typeOf(props.events) === "object") {
                    hashName = "events";
        }

        if (hashName) {
          props._actions = merge['default'](props._actions || {}, props[hashName]);
        }

        delete props[hashName];
      }
    },

    /**
      Triggers a named action on the `ActionHandler`. Any parameters
      supplied after the `actionName` string will be passed as arguments
      to the action target function.
       If the `ActionHandler` has its `target` property set, actions may
      bubble to the `target`. Bubbling happens when an `actionName` can
      not be found in the `ActionHandler`'s `actions` hash or if the
      action target function returns `true`.
       Example
       ```js
      App.WelcomeRoute = Ember.Route.extend({
        actions: {
          playTheme: function() {
             this.send('playMusic', 'theme.mp3');
          },
          playMusic: function(track) {
            // ...
          }
        }
      });
      ```
       @method send
      @param {String} actionName The action to trigger
      @param {*} context a context to send with the action
    */
    send: function (actionName) {
      for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      var target;

      if (this._actions && this._actions[actionName]) {
        var shouldBubble = this._actions[actionName].apply(this, args) === true;
        if (!shouldBubble) {
          return;
        }
      }

      if (target = property_get.get(this, "target")) {
                target.send.apply(target, arguments);
      }
    }
  });

  exports['default'] = ActionHandler;

});
enifed('ember-runtime/mixins/array', ['exports', 'ember-metal/core', 'ember-metal/property_get', 'ember-metal/computed', 'ember-metal/is_none', 'ember-runtime/mixins/enumerable', 'ember-metal/enumerable_utils', 'ember-metal/mixin', 'ember-metal/property_events', 'ember-metal/events', 'ember-metal/watching'], function (exports, Ember, property_get, computed, isNone, Enumerable, enumerable_utils, mixin, property_events, events, watching) {

  'use strict';

  /**
  @module ember
  @submodule ember-runtime
  */

  // ..........................................................
  // HELPERS
  //
  function arrayObserversHelper(obj, target, opts, operation, notify) {
    var willChange = opts && opts.willChange || 'arrayWillChange';
    var didChange = opts && opts.didChange || 'arrayDidChange';
    var hasObservers = property_get.get(obj, 'hasArrayObservers');

    if (hasObservers === notify) {
      property_events.propertyWillChange(obj, 'hasArrayObservers');
    }

    operation(obj, '@array:before', target, willChange);
    operation(obj, '@array:change', target, didChange);

    if (hasObservers === notify) {
      property_events.propertyDidChange(obj, 'hasArrayObservers');
    }

    return obj;
  }

  // ..........................................................
  // ARRAY
  //
  /**
    This mixin implements Observer-friendly Array-like behavior. It is not a
    concrete implementation, but it can be used up by other classes that want
    to appear like arrays.

    For example, ArrayProxy and ArrayController are both concrete classes that can
    be instantiated to implement array-like behavior. Both of these classes use
    the Array Mixin by way of the MutableArray mixin, which allows observable
    changes to be made to the underlying array.

    Unlike `Ember.Enumerable,` this mixin defines methods specifically for
    collections that provide index-ordered access to their contents. When you
    are designing code that needs to accept any kind of Array-like object, you
    should use these methods instead of Array primitives because these will
    properly notify observers of changes to the array.

    Although these methods are efficient, they do add a layer of indirection to
    your application so it is a good idea to use them only when you need the
    flexibility of using both true JavaScript arrays and "virtual" arrays such
    as controllers and collections.

    You can use the methods defined in this module to access and modify array
    contents in a KVO-friendly way. You can also be notified whenever the
    membership of an array changes by using `.observes('myArray.[]')`.

    To support `Ember.Array` in your own class, you must override two
    primitives to use it: `replace()` and `objectAt()`.

    Note that the Ember.Array mixin also incorporates the `Ember.Enumerable`
    mixin. All `Ember.Array`-like objects are also enumerable.

    @class Array
    @namespace Ember
    @uses Ember.Enumerable
    @since Ember 0.9.0
  */
  exports['default'] = mixin.Mixin.create(Enumerable['default'], {

    /**
      __Required.__ You must implement this method to apply this mixin.
       Your array must support the `length` property. Your replace methods should
      set this property whenever it changes.
       @property {Number} length
    */
    length: null,

    /**
      Returns the object at the given `index`. If the given `index` is negative
      or is greater or equal than the array length, returns `undefined`.
       This is one of the primitives you must implement to support `Ember.Array`.
      If your object supports retrieving the value of an array item using `get()`
      (i.e. `myArray.get(0)`), then you do not need to implement this method
      yourself.
       ```javascript
      var arr = ['a', 'b', 'c', 'd'];
       arr.objectAt(0);   // 'a'
      arr.objectAt(3);   // 'd'
      arr.objectAt(-1);  // undefined
      arr.objectAt(4);   // undefined
      arr.objectAt(5);   // undefined
      ```
       @method objectAt
      @param {Number} idx The index of the item to return.
      @return {*} item at index or undefined
    */
    objectAt: function (idx) {
      if (idx < 0 || idx >= property_get.get(this, 'length')) {
        return undefined;
      }

      return property_get.get(this, idx);
    },

    /**
      This returns the objects at the specified indexes, using `objectAt`.
       ```javascript
      var arr = ['a', 'b', 'c', 'd'];
       arr.objectsAt([0, 1, 2]);  // ['a', 'b', 'c']
      arr.objectsAt([2, 3, 4]);  // ['c', 'd', undefined]
      ```
       @method objectsAt
      @param {Array} indexes An array of indexes of items to return.
      @return {Array}
     */
    objectsAt: function (indexes) {
      var self = this;

      return enumerable_utils.map(indexes, function (idx) {
        return self.objectAt(idx);
      });
    },

    // overrides Ember.Enumerable version
    nextObject: function (idx) {
      return this.objectAt(idx);
    },

    /**
      This is the handler for the special array content property. If you get
      this property, it will return this. If you set this property to a new
      array, it will replace the current content.
       This property overrides the default property defined in `Ember.Enumerable`.
       @property []
      @return this
    */
    '[]': computed.computed({
      get: function (key) {
        return this;
      },
      set: function (key, value) {
        this.replace(0, property_get.get(this, 'length'), value);
        return this;
      }
    }),

    firstObject: computed.computed(function () {
      return this.objectAt(0);
    }),

    lastObject: computed.computed(function () {
      return this.objectAt(property_get.get(this, 'length') - 1);
    }),

    // optimized version from Enumerable
    contains: function (obj) {
      return this.indexOf(obj) >= 0;
    },

    // Add any extra methods to Ember.Array that are native to the built-in Array.
    /**
      Returns a new array that is a slice of the receiver. This implementation
      uses the observable array methods to retrieve the objects for the new
      slice.
       ```javascript
      var arr = ['red', 'green', 'blue'];
       arr.slice(0);       // ['red', 'green', 'blue']
      arr.slice(0, 2);    // ['red', 'green']
      arr.slice(1, 100);  // ['green', 'blue']
      ```
       @method slice
      @param {Integer} beginIndex (Optional) index to begin slicing from.
      @param {Integer} endIndex (Optional) index to end the slice at (but not included).
      @return {Array} New array with specified slice
    */
    slice: function (beginIndex, endIndex) {
      var ret = Ember['default'].A();
      var length = property_get.get(this, 'length');

      if (isNone['default'](beginIndex)) {
        beginIndex = 0;
      }

      if (isNone['default'](endIndex) || endIndex > length) {
        endIndex = length;
      }

      if (beginIndex < 0) {
        beginIndex = length + beginIndex;
      }

      if (endIndex < 0) {
        endIndex = length + endIndex;
      }

      while (beginIndex < endIndex) {
        ret[ret.length] = this.objectAt(beginIndex++);
      }

      return ret;
    },

    /**
      Returns the index of the given object's first occurrence.
      If no `startAt` argument is given, the starting location to
      search is 0. If it's negative, will count backward from
      the end of the array. Returns -1 if no match is found.
       ```javascript
      var arr = ['a', 'b', 'c', 'd', 'a'];
       arr.indexOf('a');       //  0
      arr.indexOf('z');       // -1
      arr.indexOf('a', 2);    //  4
      arr.indexOf('a', -1);   //  4
      arr.indexOf('b', 3);    // -1
      arr.indexOf('a', 100);  // -1
      ```
       @method indexOf
      @param {Object} object the item to search for
      @param {Number} startAt optional starting location to search, default 0
      @return {Number} index or -1 if not found
    */
    indexOf: function (object, startAt) {
      var len = property_get.get(this, 'length');
      var idx;

      if (startAt === undefined) {
        startAt = 0;
      }

      if (startAt < 0) {
        startAt += len;
      }

      for (idx = startAt; idx < len; idx++) {
        if (this.objectAt(idx) === object) {
          return idx;
        }
      }

      return -1;
    },

    /**
      Returns the index of the given object's last occurrence.
      If no `startAt` argument is given, the search starts from
      the last position. If it's negative, will count backward
      from the end of the array. Returns -1 if no match is found.
       ```javascript
      var arr = ['a', 'b', 'c', 'd', 'a'];
       arr.lastIndexOf('a');       //  4
      arr.lastIndexOf('z');       // -1
      arr.lastIndexOf('a', 2);    //  0
      arr.lastIndexOf('a', -1);   //  4
      arr.lastIndexOf('b', 3);    //  1
      arr.lastIndexOf('a', 100);  //  4
      ```
       @method lastIndexOf
      @param {Object} object the item to search for
      @param {Number} startAt optional starting location to search, default 0
      @return {Number} index or -1 if not found
    */
    lastIndexOf: function (object, startAt) {
      var len = property_get.get(this, 'length');
      var idx;

      if (startAt === undefined || startAt >= len) {
        startAt = len - 1;
      }

      if (startAt < 0) {
        startAt += len;
      }

      for (idx = startAt; idx >= 0; idx--) {
        if (this.objectAt(idx) === object) {
          return idx;
        }
      }

      return -1;
    },

    // ..........................................................
    // ARRAY OBSERVERS
    //

    /**
      Adds an array observer to the receiving array. The array observer object
      normally must implement two methods:
       * `arrayWillChange(observedObj, start, removeCount, addCount)` - This method will be
        called just before the array is modified.
      * `arrayDidChange(observedObj, start, removeCount, addCount)` - This method will be
        called just after the array is modified.
       Both callbacks will be passed the observed object, starting index of the
      change as well a a count of the items to be removed and added. You can use
      these callbacks to optionally inspect the array during the change, clear
      caches, or do any other bookkeeping necessary.
       In addition to passing a target, you can also include an options hash
      which you can use to override the method names that will be invoked on the
      target.
       @method addArrayObserver
      @param {Object} target The observer object.
      @param {Hash} opts Optional hash of configuration options including
        `willChange` and `didChange` option.
      @return {Ember.Array} receiver
    */

    addArrayObserver: function (target, opts) {
      return arrayObserversHelper(this, target, opts, events.addListener, false);
    },

    /**
      Removes an array observer from the object if the observer is current
      registered. Calling this method multiple times with the same object will
      have no effect.
       @method removeArrayObserver
      @param {Object} target The object observing the array.
      @param {Hash} opts Optional hash of configuration options including
        `willChange` and `didChange` option.
      @return {Ember.Array} receiver
    */
    removeArrayObserver: function (target, opts) {
      return arrayObserversHelper(this, target, opts, events.removeListener, true);
    },

    /**
      Becomes true whenever the array currently has observers watching changes
      on the array.
       @property {Boolean} hasArrayObservers
    */
    hasArrayObservers: computed.computed(function () {
      return events.hasListeners(this, '@array:change') || events.hasListeners(this, '@array:before');
    }),

    /**
      If you are implementing an object that supports `Ember.Array`, call this
      method just before the array content changes to notify any observers and
      invalidate any related properties. Pass the starting index of the change
      as well as a delta of the amounts to change.
       @method arrayContentWillChange
      @param {Number} startIdx The starting index in the array that will change.
      @param {Number} removeAmt The number of items that will be removed. If you
        pass `null` assumes 0
      @param {Number} addAmt The number of items that will be added. If you
        pass `null` assumes 0.
      @return {Ember.Array} receiver
    */
    arrayContentWillChange: function (startIdx, removeAmt, addAmt) {
      var removing, lim;

      // if no args are passed assume everything changes
      if (startIdx === undefined) {
        startIdx = 0;
        removeAmt = addAmt = -1;
      } else {
        if (removeAmt === undefined) {
          removeAmt = -1;
        }

        if (addAmt === undefined) {
          addAmt = -1;
        }
      }

      // Make sure the @each proxy is set up if anyone is observing @each
      if (watching.isWatching(this, '@each')) {
        property_get.get(this, '@each');
      }

      events.sendEvent(this, '@array:before', [this, startIdx, removeAmt, addAmt]);

      if (startIdx >= 0 && removeAmt >= 0 && property_get.get(this, 'hasEnumerableObservers')) {
        removing = [];
        lim = startIdx + removeAmt;

        for (var idx = startIdx; idx < lim; idx++) {
          removing.push(this.objectAt(idx));
        }
      } else {
        removing = removeAmt;
      }

      this.enumerableContentWillChange(removing, addAmt);

      return this;
    },

    /**
      If you are implementing an object that supports `Ember.Array`, call this
      method just after the array content changes to notify any observers and
      invalidate any related properties. Pass the starting index of the change
      as well as a delta of the amounts to change.
       @method arrayContentDidChange
      @param {Number} startIdx The starting index in the array that did change.
      @param {Number} removeAmt The number of items that were removed. If you
        pass `null` assumes 0
      @param {Number} addAmt The number of items that were added. If you
        pass `null` assumes 0.
      @return {Ember.Array} receiver
    */
    arrayContentDidChange: function (startIdx, removeAmt, addAmt) {
      var adding, lim;

      // if no args are passed assume everything changes
      if (startIdx === undefined) {
        startIdx = 0;
        removeAmt = addAmt = -1;
      } else {
        if (removeAmt === undefined) {
          removeAmt = -1;
        }

        if (addAmt === undefined) {
          addAmt = -1;
        }
      }

      if (startIdx >= 0 && addAmt >= 0 && property_get.get(this, 'hasEnumerableObservers')) {
        adding = [];
        lim = startIdx + addAmt;

        for (var idx = startIdx; idx < lim; idx++) {
          adding.push(this.objectAt(idx));
        }
      } else {
        adding = addAmt;
      }

      this.enumerableContentDidChange(removeAmt, adding);
      events.sendEvent(this, '@array:change', [this, startIdx, removeAmt, addAmt]);

      var length = property_get.get(this, 'length');
      var cachedFirst = computed.cacheFor(this, 'firstObject');
      var cachedLast = computed.cacheFor(this, 'lastObject');

      if (this.objectAt(0) !== cachedFirst) {
        property_events.propertyWillChange(this, 'firstObject');
        property_events.propertyDidChange(this, 'firstObject');
      }

      if (this.objectAt(length - 1) !== cachedLast) {
        property_events.propertyWillChange(this, 'lastObject');
        property_events.propertyDidChange(this, 'lastObject');
      }

      return this;
    },

    // ..........................................................
    // ENUMERATED PROPERTIES
    //

    /**
      Returns a special object that can be used to observe individual properties
      on the array. Just get an equivalent property on this object and it will
      return an enumerable that maps automatically to the named key on the
      member objects.
       If you merely want to watch for any items being added or removed to the array,
      use the `[]` property instead of `@each`.
       @property @each
    */
    '@each': computed.computed(function () {
      if (!this.__each) {
        // ES6TODO: GRRRRR
        var EachProxy = requireModule('ember-runtime/system/each_proxy')['EachProxy'];

        this.__each = new EachProxy(this);
      }

      return this.__each;
    })
  });

});
enifed('ember-runtime/mixins/comparable', ['exports', 'ember-metal/mixin'], function (exports, mixin) {

  'use strict';

  exports['default'] = mixin.Mixin.create({

    /**
      __Required.__ You must implement this method to apply this mixin.
       Override to return the result of the comparison of the two parameters. The
      compare method should return:
       - `-1` if `a < b`
      - `0` if `a == b`
      - `1` if `a > b`
       Default implementation raises an exception.
       @method compare
      @param a {Object} the first object to compare
      @param b {Object} the second object to compare
      @return {Integer} the result of the comparison
    */
    compare: null
  });

});
enifed('ember-runtime/mixins/controller', ['exports', 'ember-metal/mixin', 'ember-metal/alias', 'ember-runtime/mixins/action_handler', 'ember-runtime/mixins/controller_content_model_alias_deprecation'], function (exports, mixin, alias, ActionHandler, ControllerContentModelAliasDeprecation) {

  'use strict';

  exports['default'] = mixin.Mixin.create(ActionHandler['default'], ControllerContentModelAliasDeprecation['default'], {
    /* ducktype as a controller */
    isController: true,

    /**
      The object to which actions from the view should be sent.
       For example, when a Handlebars template uses the `{{action}}` helper,
      it will attempt to send the action to the view's controller's `target`.
       By default, the value of the target property is set to the router, and
      is injected when a controller is instantiated. This injection is defined
      in Ember.Application#buildContainer, and is applied as part of the
      applications initialization process. It can also be set after a controller
      has been instantiated, for instance when using the render helper in a
      template, or when a controller is used as an `itemController`. In most
      cases the `target` property will automatically be set to the logical
      consumer of actions for the controller.
       @property target
      @default null
    */
    target: null,

    container: null,

    parentController: null,

    store: null,

    /**
      The controller's current model. When retrieving or modifying a controller's
      model, this property should be used instead of the `content` property.
       @property model
      @public
     */
    model: null,

    /**
      @private
     */
    content: alias['default']("model")

  });

});
enifed('ember-runtime/mixins/controller_content_model_alias_deprecation', ['exports', 'ember-metal/core', 'ember-metal/mixin'], function (exports, Ember, mixin) {

  'use strict';

  exports['default'] = mixin.Mixin.create({
    /**
      @private
       Moves `content` to `model`  at extend time if a `model` is not also specified.
       Note that this currently modifies the mixin themselves, which is technically
      dubious but is practically of little consequence. This may change in the
      future.
       @method willMergeMixin
      @since 1.4.0
    */
    willMergeMixin: function (props) {
      // Calling super is only OK here since we KNOW that
      // there is another Mixin loaded first.
      this._super.apply(this, arguments);

      var modelSpecified = !!props.model;

      if (props.content && !modelSpecified) {
        props.model = props.content;
        delete props['content'];

              }
    }
  });

});
enifed('ember-runtime/mixins/copyable', ['exports', 'ember-metal/property_get', 'ember-metal/mixin', 'ember-runtime/mixins/freezable', 'ember-runtime/system/string', 'ember-metal/error'], function (exports, property_get, mixin, freezable, string, EmberError) {

  'use strict';

  /**
  @module ember
  @submodule ember-runtime
  */

  exports['default'] = mixin.Mixin.create({
    /**
      __Required.__ You must implement this method to apply this mixin.
       Override to return a copy of the receiver. Default implementation raises
      an exception.
       @method copy
      @param {Boolean} deep if `true`, a deep copy of the object should be made
      @return {Object} copy of receiver
    */
    copy: null,

    /**
      If the object implements `Ember.Freezable`, then this will return a new
      copy if the object is not frozen and the receiver if the object is frozen.
       Raises an exception if you try to call this method on a object that does
      not support freezing.
       You should use this method whenever you want a copy of a freezable object
      since a freezable object can simply return itself without actually
      consuming more memory.
       @method frozenCopy
      @return {Object} copy of receiver or receiver
    */
    frozenCopy: function () {
      if (freezable.Freezable && freezable.Freezable.detect(this)) {
        return property_get.get(this, "isFrozen") ? this : this.copy().freeze();
      } else {
        throw new EmberError['default'](string.fmt("%@ does not support freezing", [this]));
      }
    }
  });

});
enifed('ember-runtime/mixins/deferred', ['exports', 'ember-metal/core', 'ember-metal/property_get', 'ember-metal/mixin', 'ember-metal/computed', 'ember-runtime/ext/rsvp'], function (exports, Ember, property_get, mixin, computed, RSVP) {

  'use strict';

  exports['default'] = mixin.Mixin.create({
    /**
      Add handlers to be called when the Deferred object is resolved or rejected.
       @method then
      @param {Function} resolve a callback function to be called when done
      @param {Function} reject  a callback function to be called when failed
    */
    then: function (resolve, reject, label) {
      var deferred, promise, entity;

      entity = this;
      deferred = property_get.get(this, "_deferred");
      promise = deferred.promise;

      function fulfillmentHandler(fulfillment) {
        if (fulfillment === promise) {
          return resolve(entity);
        } else {
          return resolve(fulfillment);
        }
      }

      return promise.then(resolve && fulfillmentHandler, reject, label);
    },

    /**
      Resolve a Deferred object and call any `doneCallbacks` with the given args.
       @method resolve
    */
    resolve: function (value) {
      var deferred, promise;

      deferred = property_get.get(this, "_deferred");
      promise = deferred.promise;

      if (value === this) {
        deferred.resolve(promise);
      } else {
        deferred.resolve(value);
      }
    },

    /**
      Reject a Deferred object and call any `failCallbacks` with the given args.
       @method reject
    */
    reject: function (value) {
      property_get.get(this, "_deferred").reject(value);
    },

    _deferred: computed.computed(function () {
      
      return RSVP['default'].defer("Ember: DeferredMixin - " + this);
    })
  });

});
enifed('ember-runtime/mixins/enumerable', ['exports', 'ember-metal/core', 'ember-metal/property_get', 'ember-metal/property_set', 'ember-metal/mixin', 'ember-metal/enumerable_utils', 'ember-metal/computed', 'ember-metal/property_events', 'ember-metal/events', 'ember-runtime/compare'], function (exports, Ember, property_get, property_set, mixin, enumerable_utils, computed, property_events, events, compare) {

  'use strict';

  /**
  @module ember
  @submodule ember-runtime
  */

  // ..........................................................
  // HELPERS
  //

  var contexts = [];

  function popCtx() {
    return contexts.length === 0 ? {} : contexts.pop();
  }

  function pushCtx(ctx) {
    contexts.push(ctx);
    return null;
  }

  function iter(key, value) {
    var valueProvided = arguments.length === 2;

    function i(item) {
      var cur = property_get.get(item, key);
      return valueProvided ? value === cur : !!cur;
    }

    return i;
  }

  /**
    This mixin defines the common interface implemented by enumerable objects
    in Ember. Most of these methods follow the standard Array iteration
    API defined up to JavaScript 1.8 (excluding language-specific features that
    cannot be emulated in older versions of JavaScript).

    This mixin is applied automatically to the Array class on page load, so you
    can use any of these methods on simple arrays. If Array already implements
    one of these methods, the mixin will not override them.

    ## Writing Your Own Enumerable

    To make your own custom class enumerable, you need two items:

    1. You must have a length property. This property should change whenever
       the number of items in your enumerable object changes. If you use this
       with an `Ember.Object` subclass, you should be sure to change the length
       property using `set().`

    2. You must implement `nextObject().` See documentation.

    Once you have these two methods implemented, apply the `Ember.Enumerable` mixin
    to your class and you will be able to enumerate the contents of your object
    like any other collection.

    ## Using Ember Enumeration with Other Libraries

    Many other libraries provide some kind of iterator or enumeration like
    facility. This is often where the most common API conflicts occur.
    Ember's API is designed to be as friendly as possible with other
    libraries by implementing only methods that mostly correspond to the
    JavaScript 1.8 API.

    @class Enumerable
    @namespace Ember
    @since Ember 0.9
  */
  exports['default'] = mixin.Mixin.create({

    /**
      __Required.__ You must implement this method to apply this mixin.
       Implement this method to make your class enumerable.
       This method will be called repeatedly during enumeration. The index value
      will always begin with 0 and increment monotonically. You don't have to
      rely on the index value to determine what object to return, but you should
      always check the value and start from the beginning when you see the
      requested index is 0.
       The `previousObject` is the object that was returned from the last call
      to `nextObject` for the current iteration. This is a useful way to
      manage iteration if you are tracing a linked list, for example.
       Finally the context parameter will always contain a hash you can use as
      a "scratchpad" to maintain any other state you need in order to iterate
      properly. The context object is reused and is not reset between
      iterations so make sure you setup the context with a fresh state whenever
      the index parameter is 0.
       Generally iterators will continue to call `nextObject` until the index
      reaches the your current length-1. If you run out of data before this
      time for some reason, you should simply return undefined.
       The default implementation of this method simply looks up the index.
      This works great on any Array-like objects.
       @method nextObject
      @param {Number} index the current index of the iteration
      @param {Object} previousObject the value returned by the last call to
        `nextObject`.
      @param {Object} context a context object you can use to maintain state.
      @return {Object} the next object in the iteration or undefined
    */
    nextObject: null,

    /**
      Helper method returns the first object from a collection. This is usually
      used by bindings and other parts of the framework to extract a single
      object if the enumerable contains only one item.
       If you override this method, you should implement it so that it will
      always return the same value each time it is called. If your enumerable
      contains only one object, this method should always return that object.
      If your enumerable is empty, this method should return `undefined`.
       ```javascript
      var arr = ['a', 'b', 'c'];
      arr.get('firstObject');  // 'a'
       var arr = [];
      arr.get('firstObject');  // undefined
      ```
       @property firstObject
      @return {Object} the object or undefined
    */
    firstObject: computed.computed('[]', function () {
      if (property_get.get(this, 'length') === 0) {
        return undefined;
      }

      // handle generic enumerables
      var context = popCtx();
      var ret = this.nextObject(0, null, context);

      pushCtx(context);

      return ret;
    }),

    /**
      Helper method returns the last object from a collection. If your enumerable
      contains only one object, this method should always return that object.
      If your enumerable is empty, this method should return `undefined`.
       ```javascript
      var arr = ['a', 'b', 'c'];
      arr.get('lastObject');  // 'c'
       var arr = [];
      arr.get('lastObject');  // undefined
      ```
       @property lastObject
      @return {Object} the last object or undefined
    */
    lastObject: computed.computed('[]', function () {
      var len = property_get.get(this, 'length');

      if (len === 0) {
        return undefined;
      }

      var context = popCtx();
      var idx = 0;
      var last = null;
      var cur;

      do {
        last = cur;
        cur = this.nextObject(idx++, last, context);
      } while (cur !== undefined);

      pushCtx(context);

      return last;
    }),

    /**
      Returns `true` if the passed object can be found in the receiver. The
      default version will iterate through the enumerable until the object
      is found. You may want to override this with a more efficient version.
       ```javascript
      var arr = ['a', 'b', 'c'];
       arr.contains('a'); // true
      arr.contains('z'); // false
      ```
       @method contains
      @param {Object} obj The object to search for.
      @return {Boolean} `true` if object is found in enumerable.
    */
    contains: function (obj) {
      var found = this.find(function (item) {
        return item === obj;
      });

      return found !== undefined;
    },

    /**
      Iterates through the enumerable, calling the passed function on each
      item. This method corresponds to the `forEach()` method defined in
      JavaScript 1.6.
       The callback method you provide should have the following signature (all
      parameters are optional):
       ```javascript
      function(item, index, enumerable);
      ```
       - `item` is the current item in the iteration.
      - `index` is the current index in the iteration.
      - `enumerable` is the enumerable object itself.
       Note that in addition to a callback, you can also pass an optional target
      object that will be set as `this` on the context. This is a good way
      to give your iterator function access to the current object.
       @method forEach
      @param {Function} callback The callback to execute
      @param {Object} [target] The target object to use
      @return {Object} receiver
    */
    forEach: function (callback, target) {
      if (typeof callback !== 'function') {
        throw new TypeError();
      }

      var context = popCtx();
      var len = property_get.get(this, 'length');
      var last = null;

      if (target === undefined) {
        target = null;
      }

      for (var idx = 0; idx < len; idx++) {
        var next = this.nextObject(idx, last, context);
        callback.call(target, next, idx, this);
        last = next;
      }

      last = null;
      context = pushCtx(context);

      return this;
    },

    /**
      Alias for `mapBy`
       @method getEach
      @param {String} key name of the property
      @return {Array} The mapped array.
    */
    getEach: mixin.aliasMethod('mapBy'),

    /**
      Sets the value on the named property for each member. This is more
      efficient than using other methods defined on this helper. If the object
      implements Ember.Observable, the value will be changed to `set(),` otherwise
      it will be set directly. `null` objects are skipped.
       @method setEach
      @param {String} key The key to set
      @param {Object} value The object to set
      @return {Object} receiver
    */
    setEach: function (key, value) {
      return this.forEach(function (item) {
        property_set.set(item, key, value);
      });
    },

    /**
      Maps all of the items in the enumeration to another value, returning
      a new array. This method corresponds to `map()` defined in JavaScript 1.6.
       The callback method you provide should have the following signature (all
      parameters are optional):
       ```javascript
      function(item, index, enumerable);
      ```
       - `item` is the current item in the iteration.
      - `index` is the current index in the iteration.
      - `enumerable` is the enumerable object itself.
       It should return the mapped value.
       Note that in addition to a callback, you can also pass an optional target
      object that will be set as `this` on the context. This is a good way
      to give your iterator function access to the current object.
       @method map
      @param {Function} callback The callback to execute
      @param {Object} [target] The target object to use
      @return {Array} The mapped array.
    */
    map: function (callback, target) {
      var ret = Ember['default'].A();

      this.forEach(function (x, idx, i) {
        ret[idx] = callback.call(target, x, idx, i);
      });

      return ret;
    },

    /**
      Similar to map, this specialized function returns the value of the named
      property on all items in the enumeration.
       @method mapBy
      @param {String} key name of the property
      @return {Array} The mapped array.
    */
    mapBy: function (key) {
      return this.map(function (next) {
        return property_get.get(next, key);
      });
    },

    /**
      Similar to map, this specialized function returns the value of the named
      property on all items in the enumeration.
       @method mapProperty
      @param {String} key name of the property
      @return {Array} The mapped array.
      @deprecated Use `mapBy` instead
    */

    mapProperty: mixin.aliasMethod('mapBy'),

    /**
      Returns an array with all of the items in the enumeration that the passed
      function returns true for. This method corresponds to `filter()` defined in
      JavaScript 1.6.
       The callback method you provide should have the following signature (all
      parameters are optional):
       ```javascript
      function(item, index, enumerable);
      ```
       - `item` is the current item in the iteration.
      - `index` is the current index in the iteration.
      - `enumerable` is the enumerable object itself.
       It should return `true` to include the item in the results, `false`
      otherwise.
       Note that in addition to a callback, you can also pass an optional target
      object that will be set as `this` on the context. This is a good way
      to give your iterator function access to the current object.
       @method filter
      @param {Function} callback The callback to execute
      @param {Object} [target] The target object to use
      @return {Array} A filtered array.
    */
    filter: function (callback, target) {
      var ret = Ember['default'].A();

      this.forEach(function (x, idx, i) {
        if (callback.call(target, x, idx, i)) {
          ret.push(x);
        }
      });

      return ret;
    },

    /**
      Returns an array with all of the items in the enumeration where the passed
      function returns true. This method is the inverse of filter().
       The callback method you provide should have the following signature (all
      parameters are optional):
       ```javascript
      function(item, index, enumerable);
      ```
       - *item* is the current item in the iteration.
      - *index* is the current index in the iteration
      - *enumerable* is the enumerable object itself.
       It should return the a falsey value to include the item in the results.
       Note that in addition to a callback, you can also pass an optional target
      object that will be set as "this" on the context. This is a good way
      to give your iterator function access to the current object.
       @method reject
      @param {Function} callback The callback to execute
      @param {Object} [target] The target object to use
      @return {Array} A rejected array.
     */
    reject: function (callback, target) {
      return this.filter(function () {
        return !callback.apply(target, arguments);
      });
    },

    /**
      Returns an array with just the items with the matched property. You
      can pass an optional second argument with the target value. Otherwise
      this will match any property that evaluates to `true`.
       @method filterBy
      @param {String} key the property to test
      @param {*} [value] optional value to test against.
      @return {Array} filtered array
    */
    filterBy: function (key, value) {
      return this.filter(iter.apply(this, arguments));
    },

    /**
      Returns an array with just the items with the matched property. You
      can pass an optional second argument with the target value. Otherwise
      this will match any property that evaluates to `true`.
       @method filterProperty
      @param {String} key the property to test
      @param {String} [value] optional value to test against.
      @return {Array} filtered array
      @deprecated Use `filterBy` instead
    */
    filterProperty: mixin.aliasMethod('filterBy'),

    /**
      Returns an array with the items that do not have truthy values for
      key.  You can pass an optional second argument with the target value.  Otherwise
      this will match any property that evaluates to false.
       @method rejectBy
      @param {String} key the property to test
      @param {String} [value] optional value to test against.
      @return {Array} rejected array
    */
    rejectBy: function (key, value) {
      var exactValue = function (item) {
        return property_get.get(item, key) === value;
      };

      var hasValue = function (item) {
        return !!property_get.get(item, key);
      };

      var use = arguments.length === 2 ? exactValue : hasValue;

      return this.reject(use);
    },

    /**
      Returns an array with the items that do not have truthy values for
      key.  You can pass an optional second argument with the target value.  Otherwise
      this will match any property that evaluates to false.
       @method rejectProperty
      @param {String} key the property to test
      @param {String} [value] optional value to test against.
      @return {Array} rejected array
      @deprecated Use `rejectBy` instead
    */
    rejectProperty: mixin.aliasMethod('rejectBy'),

    /**
      Returns the first item in the array for which the callback returns true.
      This method works similar to the `filter()` method defined in JavaScript 1.6
      except that it will stop working on the array once a match is found.
       The callback method you provide should have the following signature (all
      parameters are optional):
       ```javascript
      function(item, index, enumerable);
      ```
       - `item` is the current item in the iteration.
      - `index` is the current index in the iteration.
      - `enumerable` is the enumerable object itself.
       It should return the `true` to include the item in the results, `false`
      otherwise.
       Note that in addition to a callback, you can also pass an optional target
      object that will be set as `this` on the context. This is a good way
      to give your iterator function access to the current object.
       @method find
      @param {Function} callback The callback to execute
      @param {Object} [target] The target object to use
      @return {Object} Found item or `undefined`.
    */
    find: function (callback, target) {
      var len = property_get.get(this, 'length');

      if (target === undefined) {
        target = null;
      }

      var context = popCtx();
      var found = false;
      var last = null;
      var next, ret;

      for (var idx = 0; idx < len && !found; idx++) {
        next = this.nextObject(idx, last, context);

        if (found = callback.call(target, next, idx, this)) {
          ret = next;
        }

        last = next;
      }

      next = last = null;
      context = pushCtx(context);

      return ret;
    },

    /**
      Returns the first item with a property matching the passed value. You
      can pass an optional second argument with the target value. Otherwise
      this will match any property that evaluates to `true`.
       This method works much like the more generic `find()` method.
       @method findBy
      @param {String} key the property to test
      @param {String} [value] optional value to test against.
      @return {Object} found item or `undefined`
    */
    findBy: function (key, value) {
      return this.find(iter.apply(this, arguments));
    },

    /**
      Returns the first item with a property matching the passed value. You
      can pass an optional second argument with the target value. Otherwise
      this will match any property that evaluates to `true`.
       This method works much like the more generic `find()` method.
       @method findProperty
      @param {String} key the property to test
      @param {String} [value] optional value to test against.
      @return {Object} found item or `undefined`
      @deprecated Use `findBy` instead
    */
    findProperty: mixin.aliasMethod('findBy'),

    /**
      Returns `true` if the passed function returns true for every item in the
      enumeration. This corresponds with the `every()` method in JavaScript 1.6.
       The callback method you provide should have the following signature (all
      parameters are optional):
       ```javascript
      function(item, index, enumerable);
      ```
       - `item` is the current item in the iteration.
      - `index` is the current index in the iteration.
      - `enumerable` is the enumerable object itself.
       It should return the `true` or `false`.
       Note that in addition to a callback, you can also pass an optional target
      object that will be set as `this` on the context. This is a good way
      to give your iterator function access to the current object.
       Example Usage:
       ```javascript
      if (people.every(isEngineer)) {
        Paychecks.addBigBonus();
      }
      ```
       @method every
      @param {Function} callback The callback to execute
      @param {Object} [target] The target object to use
      @return {Boolean}
    */
    every: function (callback, target) {
      return !this.find(function (x, idx, i) {
        return !callback.call(target, x, idx, i);
      });
    },

    /**
      @method everyBy
      @param {String} key the property to test
      @param {String} [value] optional value to test against.
      @deprecated Use `isEvery` instead
      @return {Boolean}
    */
    everyBy: mixin.aliasMethod('isEvery'),

    /**
      @method everyProperty
      @param {String} key the property to test
      @param {String} [value] optional value to test against.
      @deprecated Use `isEvery` instead
      @return {Boolean}
    */
    everyProperty: mixin.aliasMethod('isEvery'),

    /**
      Returns `true` if the passed property resolves to `true` for all items in
      the enumerable. This method is often simpler/faster than using a callback.
       @method isEvery
      @param {String} key the property to test
      @param {String} [value] optional value to test against.
      @return {Boolean}
      @since 1.3.0
    */
    isEvery: function (key, value) {
      return this.every(iter.apply(this, arguments));
    },

    /**
      Returns `true` if the passed function returns true for any item in the
      enumeration. This corresponds with the `some()` method in JavaScript 1.6.
       The callback method you provide should have the following signature (all
      parameters are optional):
       ```javascript
      function(item, index, enumerable);
      ```
       - `item` is the current item in the iteration.
      - `index` is the current index in the iteration.
      - `enumerable` is the enumerable object itself.
       It should return the `true` to include the item in the results, `false`
      otherwise.
       Note that in addition to a callback, you can also pass an optional target
      object that will be set as `this` on the context. This is a good way
      to give your iterator function access to the current object.
       Usage Example:
       ```javascript
      if (people.any(isManager)) {
        Paychecks.addBiggerBonus();
      }
      ```
       @method any
      @param {Function} callback The callback to execute
      @param {Object} [target] The target object to use
      @return {Boolean} `true` if the passed function returns `true` for any item
    */
    any: function (callback, target) {
      var len = property_get.get(this, 'length');
      var context = popCtx();
      var found = false;
      var last = null;
      var next, idx;

      if (target === undefined) {
        target = null;
      }

      for (idx = 0; idx < len && !found; idx++) {
        next = this.nextObject(idx, last, context);
        found = callback.call(target, next, idx, this);
        last = next;
      }

      next = last = null;
      context = pushCtx(context);
      return found;
    },

    /**
      Returns `true` if the passed function returns true for any item in the
      enumeration. This corresponds with the `some()` method in JavaScript 1.6.
       The callback method you provide should have the following signature (all
      parameters are optional):
       ```javascript
      function(item, index, enumerable);
      ```
       - `item` is the current item in the iteration.
      - `index` is the current index in the iteration.
      - `enumerable` is the enumerable object itself.
       It should return the `true` to include the item in the results, `false`
      otherwise.
       Note that in addition to a callback, you can also pass an optional target
      object that will be set as `this` on the context. This is a good way
      to give your iterator function access to the current object.
       Usage Example:
       ```javascript
      if (people.some(isManager)) {
        Paychecks.addBiggerBonus();
      }
      ```
       @method some
      @param {Function} callback The callback to execute
      @param {Object} [target] The target object to use
      @return {Boolean} `true` if the passed function returns `true` for any item
      @deprecated Use `any` instead
    */
    some: mixin.aliasMethod('any'),

    /**
      Returns `true` if the passed property resolves to `true` for any item in
      the enumerable. This method is often simpler/faster than using a callback.
       @method isAny
      @param {String} key the property to test
      @param {String} [value] optional value to test against.
      @return {Boolean}
      @since 1.3.0
    */
    isAny: function (key, value) {
      return this.any(iter.apply(this, arguments));
    },

    /**
      @method anyBy
      @param {String} key the property to test
      @param {String} [value] optional value to test against.
      @return {Boolean}
      @deprecated Use `isAny` instead
    */
    anyBy: mixin.aliasMethod('isAny'),

    /**
      @method someProperty
      @param {String} key the property to test
      @param {String} [value] optional value to test against.
      @return {Boolean}
      @deprecated Use `isAny` instead
    */
    someProperty: mixin.aliasMethod('isAny'),

    /**
      This will combine the values of the enumerator into a single value. It
      is a useful way to collect a summary value from an enumeration. This
      corresponds to the `reduce()` method defined in JavaScript 1.8.
       The callback method you provide should have the following signature (all
      parameters are optional):
       ```javascript
      function(previousValue, item, index, enumerable);
      ```
       - `previousValue` is the value returned by the last call to the iterator.
      - `item` is the current item in the iteration.
      - `index` is the current index in the iteration.
      - `enumerable` is the enumerable object itself.
       Return the new cumulative value.
       In addition to the callback you can also pass an `initialValue`. An error
      will be raised if you do not pass an initial value and the enumerator is
      empty.
       Note that unlike the other methods, this method does not allow you to
      pass a target object to set as this for the callback. It's part of the
      spec. Sorry.
       @method reduce
      @param {Function} callback The callback to execute
      @param {Object} initialValue Initial value for the reduce
      @param {String} reducerProperty internal use only.
      @return {Object} The reduced value.
    */
    reduce: function (callback, initialValue, reducerProperty) {
      if (typeof callback !== 'function') {
        throw new TypeError();
      }

      var ret = initialValue;

      this.forEach(function (item, i) {
        ret = callback(ret, item, i, this, reducerProperty);
      }, this);

      return ret;
    },

    /**
      Invokes the named method on every object in the receiver that
      implements it. This method corresponds to the implementation in
      Prototype 1.6.
       @method invoke
      @param {String} methodName the name of the method
      @param {Object...} args optional arguments to pass as well.
      @return {Array} return values from calling invoke.
    */
    invoke: function (methodName) {
      for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      var ret = Ember['default'].A();

      this.forEach(function (x, idx) {
        var method = x && x[methodName];

        if ('function' === typeof method) {
          ret[idx] = args ? method.apply(x, args) : x[methodName]();
        }
      }, this);

      return ret;
    },

    /**
      Simply converts the enumerable into a genuine array. The order is not
      guaranteed. Corresponds to the method implemented by Prototype.
       @method toArray
      @return {Array} the enumerable as an array.
    */
    toArray: function () {
      var ret = Ember['default'].A();

      this.forEach(function (o, idx) {
        ret[idx] = o;
      });

      return ret;
    },

    /**
      Returns a copy of the array with all `null` and `undefined` elements removed.
       ```javascript
      var arr = ['a', null, 'c', undefined];
      arr.compact();  // ['a', 'c']
      ```
       @method compact
      @return {Array} the array without null and undefined elements.
    */
    compact: function () {
      return this.filter(function (value) {
        return value != null;
      });
    },

    /**
      Returns a new enumerable that excludes the passed value. The default
      implementation returns an array regardless of the receiver type unless
      the receiver does not contain the value.
       ```javascript
      var arr = ['a', 'b', 'a', 'c'];
      arr.without('a');  // ['b', 'c']
      ```
       @method without
      @param {Object} value
      @return {Ember.Enumerable}
    */
    without: function (value) {
      if (!this.contains(value)) {
        return this; // nothing to do
      }

      var ret = Ember['default'].A();

      this.forEach(function (k) {
        if (k !== value) {
          ret[ret.length] = k;
        }
      });

      return ret;
    },

    /**
      Returns a new enumerable that contains only unique values. The default
      implementation returns an array regardless of the receiver type.
       ```javascript
      var arr = ['a', 'a', 'b', 'b'];
      arr.uniq();  // ['a', 'b']
      ```
       This only works on primitive data types, e.g. Strings, Numbers, etc.
       @method uniq
      @return {Ember.Enumerable}
    */
    uniq: function () {
      var ret = Ember['default'].A();

      this.forEach(function (k) {
        if (enumerable_utils.indexOf(ret, k) < 0) {
          ret.push(k);
        }
      });

      return ret;
    },

    /**
      This property will trigger anytime the enumerable's content changes.
      You can observe this property to be notified of changes to the enumerable's
      content.
       For plain enumerables, this property is read only. `Array` overrides
      this method.
       @property []
      @type Array
      @return this
    */
    '[]': computed.computed({
      get: function (key) {
        return this;
      }
    }),

    // ..........................................................
    // ENUMERABLE OBSERVERS
    //

    /**
      Registers an enumerable observer. Must implement `Ember.EnumerableObserver`
      mixin.
       @method addEnumerableObserver
      @param {Object} target
      @param {Hash} [opts]
      @return this
    */
    addEnumerableObserver: function (target, opts) {
      var willChange = opts && opts.willChange || 'enumerableWillChange';
      var didChange = opts && opts.didChange || 'enumerableDidChange';
      var hasObservers = property_get.get(this, 'hasEnumerableObservers');

      if (!hasObservers) {
        property_events.propertyWillChange(this, 'hasEnumerableObservers');
      }

      events.addListener(this, '@enumerable:before', target, willChange);
      events.addListener(this, '@enumerable:change', target, didChange);

      if (!hasObservers) {
        property_events.propertyDidChange(this, 'hasEnumerableObservers');
      }

      return this;
    },

    /**
      Removes a registered enumerable observer.
       @method removeEnumerableObserver
      @param {Object} target
      @param {Hash} [opts]
      @return this
    */
    removeEnumerableObserver: function (target, opts) {
      var willChange = opts && opts.willChange || 'enumerableWillChange';
      var didChange = opts && opts.didChange || 'enumerableDidChange';
      var hasObservers = property_get.get(this, 'hasEnumerableObservers');

      if (hasObservers) {
        property_events.propertyWillChange(this, 'hasEnumerableObservers');
      }

      events.removeListener(this, '@enumerable:before', target, willChange);
      events.removeListener(this, '@enumerable:change', target, didChange);

      if (hasObservers) {
        property_events.propertyDidChange(this, 'hasEnumerableObservers');
      }

      return this;
    },

    /**
      Becomes true whenever the array currently has observers watching changes
      on the array.
       @property hasEnumerableObservers
      @type Boolean
    */
    hasEnumerableObservers: computed.computed(function () {
      return events.hasListeners(this, '@enumerable:change') || events.hasListeners(this, '@enumerable:before');
    }),

    /**
      Invoke this method just before the contents of your enumerable will
      change. You can either omit the parameters completely or pass the objects
      to be removed or added if available or just a count.
       @method enumerableContentWillChange
      @param {Ember.Enumerable|Number} removing An enumerable of the objects to
        be removed or the number of items to be removed.
      @param {Ember.Enumerable|Number} adding An enumerable of the objects to be
        added or the number of items to be added.
      @chainable
    */
    enumerableContentWillChange: function (removing, adding) {
      var removeCnt, addCnt, hasDelta;

      if ('number' === typeof removing) {
        removeCnt = removing;
      } else if (removing) {
        removeCnt = property_get.get(removing, 'length');
      } else {
        removeCnt = removing = -1;
      }

      if ('number' === typeof adding) {
        addCnt = adding;
      } else if (adding) {
        addCnt = property_get.get(adding, 'length');
      } else {
        addCnt = adding = -1;
      }

      hasDelta = addCnt < 0 || removeCnt < 0 || addCnt - removeCnt !== 0;

      if (removing === -1) {
        removing = null;
      }

      if (adding === -1) {
        adding = null;
      }

      property_events.propertyWillChange(this, '[]');

      if (hasDelta) {
        property_events.propertyWillChange(this, 'length');
      }

      events.sendEvent(this, '@enumerable:before', [this, removing, adding]);

      return this;
    },

    /**
      Invoke this method when the contents of your enumerable has changed.
      This will notify any observers watching for content changes. If you are
      implementing an ordered enumerable (such as an array), also pass the
      start and end values where the content changed so that it can be used to
      notify range observers.
       @method enumerableContentDidChange
      @param {Ember.Enumerable|Number} removing An enumerable of the objects to
        be removed or the number of items to be removed.
      @param {Ember.Enumerable|Number} adding  An enumerable of the objects to
        be added or the number of items to be added.
      @chainable
    */
    enumerableContentDidChange: function (removing, adding) {
      var removeCnt, addCnt, hasDelta;

      if ('number' === typeof removing) {
        removeCnt = removing;
      } else if (removing) {
        removeCnt = property_get.get(removing, 'length');
      } else {
        removeCnt = removing = -1;
      }

      if ('number' === typeof adding) {
        addCnt = adding;
      } else if (adding) {
        addCnt = property_get.get(adding, 'length');
      } else {
        addCnt = adding = -1;
      }

      hasDelta = addCnt < 0 || removeCnt < 0 || addCnt - removeCnt !== 0;

      if (removing === -1) {
        removing = null;
      }

      if (adding === -1) {
        adding = null;
      }

      events.sendEvent(this, '@enumerable:change', [this, removing, adding]);

      if (hasDelta) {
        property_events.propertyDidChange(this, 'length');
      }

      property_events.propertyDidChange(this, '[]');

      return this;
    },

    /**
      Converts the enumerable into an array and sorts by the keys
      specified in the argument.
       You may provide multiple arguments to sort by multiple properties.
       @method sortBy
      @param {String} property name(s) to sort on
      @return {Array} The sorted array.
      @since 1.2.0
      */
    sortBy: function () {
      var sortKeys = arguments;

      return this.toArray().sort(function (a, b) {
        for (var i = 0; i < sortKeys.length; i++) {
          var key = sortKeys[i];
          var propA = property_get.get(a, key);
          var propB = property_get.get(b, key);
          // return 1 or -1 else continue to the next sortKey
          var compareValue = compare['default'](propA, propB);

          if (compareValue) {
            return compareValue;
          }
        }
        return 0;
      });
    }
  });

});
enifed('ember-runtime/mixins/evented', ['exports', 'ember-metal/mixin', 'ember-metal/events'], function (exports, mixin, events) {

  'use strict';

  exports['default'] = mixin.Mixin.create({

    /**
     Subscribes to a named event with given function.
      ```javascript
     person.on('didLoad', function() {
       // fired once the person has loaded
     });
     ```
      An optional target can be passed in as the 2nd argument that will
     be set as the "this" for the callback. This is a good way to give your
     function access to the object triggering the event. When the target
     parameter is used the callback becomes the third argument.
      @method on
     @param {String} name The name of the event
     @param {Object} [target] The "this" binding for the callback
     @param {Function} method The callback to execute
     @return this
    */
    on: function (name, target, method) {
      events.addListener(this, name, target, method);
      return this;
    },

    /**
      Subscribes a function to a named event and then cancels the subscription
      after the first time the event is triggered. It is good to use ``one`` when
      you only care about the first time an event has taken place.
       This function takes an optional 2nd argument that will become the "this"
      value for the callback. If this argument is passed then the 3rd argument
      becomes the function.
       @method one
      @param {String} name The name of the event
      @param {Object} [target] The "this" binding for the callback
      @param {Function} method The callback to execute
      @return this
    */
    one: function (name, target, method) {
      if (!method) {
        method = target;
        target = null;
      }

      events.addListener(this, name, target, method, true);
      return this;
    },

    /**
      Triggers a named event for the object. Any additional arguments
      will be passed as parameters to the functions that are subscribed to the
      event.
       ```javascript
      person.on('didEat', function(food) {
        console.log('person ate some ' + food);
      });
       person.trigger('didEat', 'broccoli');
       // outputs: person ate some broccoli
      ```
      @method trigger
      @param {String} name The name of the event
      @param {Object...} args Optional arguments to pass on
    */
    trigger: function (name) {
      for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      events.sendEvent(this, name, args);
    },

    /**
      Cancels subscription for given name, target, and method.
       @method off
      @param {String} name The name of the event
      @param {Object} target The target of the subscription
      @param {Function} method The function of the subscription
      @return this
    */
    off: function (name, target, method) {
      events.removeListener(this, name, target, method);
      return this;
    },

    /**
      Checks to see if object has any subscriptions for named event.
       @method has
      @param {String} name The name of the event
      @return {Boolean} does the object have a subscription for event
     */
    has: function (name) {
      return events.hasListeners(this, name);
    }
  });

});
enifed('ember-runtime/mixins/freezable', ['exports', 'ember-metal/mixin', 'ember-metal/property_get', 'ember-metal/property_set'], function (exports, mixin, property_get, property_set) {

  'use strict';

  /**
  @module ember
  @submodule ember-runtime
  */

  var Freezable = mixin.Mixin.create({

    /**
      Set to `true` when the object is frozen. Use this property to detect
      whether your object is frozen or not.
       @property isFrozen
      @type Boolean
    */
    isFrozen: false,

    /**
      Freezes the object. Once this method has been called the object should
      no longer allow any properties to be edited.
       @method freeze
      @return {Object} receiver
    */
    freeze: function () {
      if (property_get.get(this, "isFrozen")) {
        return this;
      }

      property_set.set(this, "isFrozen", true);
      return this;
    }

  });

  var FROZEN_ERROR = "Frozen object cannot be modified.";

  exports.Freezable = Freezable;
  exports.FROZEN_ERROR = FROZEN_ERROR;

});
enifed('ember-runtime/mixins/mutable_array', ['exports', 'ember-metal/property_get', 'ember-metal/utils', 'ember-metal/error', 'ember-metal/mixin', 'ember-runtime/mixins/array', 'ember-runtime/mixins/mutable_enumerable', 'ember-runtime/mixins/enumerable'], function (exports, property_get, utils, EmberError, mixin, EmberArray, MutableEnumerable, Enumerable) {

  'use strict';



  // ..........................................................
  // HELPERS
  //

  var OUT_OF_RANGE_EXCEPTION = "Index out of range";
  var EMPTY = []; /**
                    This mixin defines the API for modifying array-like objects. These methods
                    can be applied only to a collection that keeps its items in an ordered set.
                    It builds upon the Array mixin and adds methods to modify the array.
                    Concrete implementations of this class include ArrayProxy and ArrayController.
                  
                    It is important to use the methods in this class to modify arrays so that
                    changes are observable. This allows the binding system in Ember to function
                    correctly.
                  
                  
                    Note that an Array can change even if it does not implement this mixin.
                    For example, one might implement a SparseArray that cannot be directly
                    modified, but if its underlying enumerable changes, it will change also.
                  
                    @class MutableArray
                    @namespace Ember
                    @uses Ember.Array
                    @uses Ember.MutableEnumerable
                  */
  exports['default'] = mixin.Mixin.create(EmberArray['default'], MutableEnumerable['default'], {

    /**
      __Required.__ You must implement this method to apply this mixin.
       This is one of the primitives you must implement to support `Ember.Array`.
      You should replace amt objects started at idx with the objects in the
      passed array. You should also call `this.enumerableContentDidChange()`
       @method replace
      @param {Number} idx Starting index in the array to replace. If
        idx >= length, then append to the end of the array.
      @param {Number} amt Number of elements that should be removed from
        the array, starting at *idx*.
      @param {Array} objects An array of zero or more objects that should be
        inserted into the array at *idx*
    */
    replace: null,

    /**
      Remove all elements from the array. This is useful if you
      want to reuse an existing array without having to recreate it.
       ```javascript
      var colors = ['red', 'green', 'blue'];
       color.length();   //  3
      colors.clear();   //  []
      colors.length();  //  0
      ```
       @method clear
      @return {Ember.Array} An empty Array.
    */
    clear: function () {
      var len = property_get.get(this, "length");
      if (len === 0) {
        return this;
      }

      this.replace(0, len, EMPTY);
      return this;
    },

    /**
      This will use the primitive `replace()` method to insert an object at the
      specified index.
       ```javascript
      var colors = ['red', 'green', 'blue'];
       colors.insertAt(2, 'yellow');  // ['red', 'green', 'yellow', 'blue']
      colors.insertAt(5, 'orange');  // Error: Index out of range
      ```
       @method insertAt
      @param {Number} idx index of insert the object at.
      @param {Object} object object to insert
      @return {Ember.Array} receiver
    */
    insertAt: function (idx, object) {
      if (idx > property_get.get(this, "length")) {
        throw new EmberError['default'](OUT_OF_RANGE_EXCEPTION);
      }

      this.replace(idx, 0, [object]);
      return this;
    },

    /**
      Remove an object at the specified index using the `replace()` primitive
      method. You can pass either a single index, or a start and a length.
       If you pass a start and length that is beyond the
      length this method will throw an `OUT_OF_RANGE_EXCEPTION`.
       ```javascript
      var colors = ['red', 'green', 'blue', 'yellow', 'orange'];
       colors.removeAt(0);     // ['green', 'blue', 'yellow', 'orange']
      colors.removeAt(2, 2);  // ['green', 'blue']
      colors.removeAt(4, 2);  // Error: Index out of range
      ```
       @method removeAt
      @param {Number} start index, start of range
      @param {Number} len length of passing range
      @return {Ember.Array} receiver
    */
    removeAt: function (start, len) {
      if ("number" === typeof start) {

        if (start < 0 || start >= property_get.get(this, "length")) {
          throw new EmberError['default'](OUT_OF_RANGE_EXCEPTION);
        }

        // fast case
        if (len === undefined) {
          len = 1;
        }

        this.replace(start, len, EMPTY);
      }

      return this;
    },

    /**
      Push the object onto the end of the array. Works just like `push()` but it
      is KVO-compliant.
       ```javascript
      var colors = ['red', 'green'];
       colors.pushObject('black');     // ['red', 'green', 'black']
      colors.pushObject(['yellow']);  // ['red', 'green', ['yellow']]
      ```
       @method pushObject
      @param {*} obj object to push
      @return object same object passed as a param
    */
    pushObject: function (obj) {
      this.insertAt(property_get.get(this, "length"), obj);
      return obj;
    },

    /**
      Add the objects in the passed numerable to the end of the array. Defers
      notifying observers of the change until all objects are added.
       ```javascript
      var colors = ['red'];
       colors.pushObjects(['yellow', 'orange']);  // ['red', 'yellow', 'orange']
      ```
       @method pushObjects
      @param {Ember.Enumerable} objects the objects to add
      @return {Ember.Array} receiver
    */
    pushObjects: function (objects) {
      if (!(Enumerable['default'].detect(objects) || utils.isArray(objects))) {
        throw new TypeError("Must pass Ember.Enumerable to Ember.MutableArray#pushObjects");
      }
      this.replace(property_get.get(this, "length"), 0, objects);
      return this;
    },

    /**
      Pop object from array or nil if none are left. Works just like `pop()` but
      it is KVO-compliant.
       ```javascript
      var colors = ['red', 'green', 'blue'];
       colors.popObject();   // 'blue'
      console.log(colors);  // ['red', 'green']
      ```
       @method popObject
      @return object
    */
    popObject: function () {
      var len = property_get.get(this, "length");
      if (len === 0) {
        return null;
      }

      var ret = this.objectAt(len - 1);
      this.removeAt(len - 1, 1);
      return ret;
    },

    /**
      Shift an object from start of array or nil if none are left. Works just
      like `shift()` but it is KVO-compliant.
       ```javascript
      var colors = ['red', 'green', 'blue'];
       colors.shiftObject();  // 'red'
      console.log(colors);   // ['green', 'blue']
      ```
       @method shiftObject
      @return object
    */
    shiftObject: function () {
      if (property_get.get(this, "length") === 0) {
        return null;
      }

      var ret = this.objectAt(0);
      this.removeAt(0);
      return ret;
    },

    /**
      Unshift an object to start of array. Works just like `unshift()` but it is
      KVO-compliant.
       ```javascript
      var colors = ['red'];
       colors.unshiftObject('yellow');    // ['yellow', 'red']
      colors.unshiftObject(['black']);   // [['black'], 'yellow', 'red']
      ```
       @method unshiftObject
      @param {*} obj object to unshift
      @return object same object passed as a param
    */
    unshiftObject: function (obj) {
      this.insertAt(0, obj);
      return obj;
    },

    /**
      Adds the named objects to the beginning of the array. Defers notifying
      observers until all objects have been added.
       ```javascript
      var colors = ['red'];
       colors.unshiftObjects(['black', 'white']);   // ['black', 'white', 'red']
      colors.unshiftObjects('yellow'); // Type Error: 'undefined' is not a function
      ```
       @method unshiftObjects
      @param {Ember.Enumerable} objects the objects to add
      @return {Ember.Array} receiver
    */
    unshiftObjects: function (objects) {
      this.replace(0, 0, objects);
      return this;
    },

    /**
      Reverse objects in the array. Works just like `reverse()` but it is
      KVO-compliant.
       @method reverseObjects
      @return {Ember.Array} receiver
     */
    reverseObjects: function () {
      var len = property_get.get(this, "length");
      if (len === 0) {
        return this;
      }

      var objects = this.toArray().reverse();
      this.replace(0, len, objects);
      return this;
    },

    /**
      Replace all the receiver's content with content of the argument.
      If argument is an empty array receiver will be cleared.
       ```javascript
      var colors = ['red', 'green', 'blue'];
       colors.setObjects(['black', 'white']);  // ['black', 'white']
      colors.setObjects([]);                  // []
      ```
       @method setObjects
      @param {Ember.Array} objects array whose content will be used for replacing
          the content of the receiver
      @return {Ember.Array} receiver with the new content
     */
    setObjects: function (objects) {
      if (objects.length === 0) {
        return this.clear();
      }

      var len = property_get.get(this, "length");
      this.replace(0, len, objects);
      return this;
    },

    // ..........................................................
    // IMPLEMENT Ember.MutableEnumerable
    //

    /**
      Remove all occurrences of an object in the array.
       ```javascript
      var cities = ['Chicago', 'Berlin', 'Lima', 'Chicago'];
       cities.removeObject('Chicago');  // ['Berlin', 'Lima']
      cities.removeObject('Lima');     // ['Berlin']
      cities.removeObject('Tokyo')     // ['Berlin']
      ```
       @method removeObject
      @param {*} obj object to remove
      @return {Ember.Array} receiver
    */
    removeObject: function (obj) {
      var loc = property_get.get(this, "length") || 0;
      while (--loc >= 0) {
        var curObject = this.objectAt(loc);

        if (curObject === obj) {
          this.removeAt(loc);
        }
      }
      return this;
    },

    /**
      Push the object onto the end of the array if it is not already
      present in the array.
       ```javascript
      var cities = ['Chicago', 'Berlin'];
       cities.addObject('Lima');    // ['Chicago', 'Berlin', 'Lima']
      cities.addObject('Berlin');  // ['Chicago', 'Berlin', 'Lima']
      ```
       @method addObject
      @param {*} obj object to add, if not already present
      @return {Ember.Array} receiver
    */
    addObject: function (obj) {
      if (!this.contains(obj)) {
        this.pushObject(obj);
      }

      return this;
    }
  });

});
enifed('ember-runtime/mixins/mutable_enumerable', ['exports', 'ember-metal/enumerable_utils', 'ember-runtime/mixins/enumerable', 'ember-metal/mixin', 'ember-metal/property_events'], function (exports, enumerable_utils, Enumerable, mixin, property_events) {

  'use strict';

  exports['default'] = mixin.Mixin.create(Enumerable['default'], {

    /**
      __Required.__ You must implement this method to apply this mixin.
       Attempts to add the passed object to the receiver if the object is not
      already present in the collection. If the object is present, this method
      has no effect.
       If the passed object is of a type not supported by the receiver,
      then this method should raise an exception.
       @method addObject
      @param {Object} object The object to add to the enumerable.
      @return {Object} the passed object
    */
    addObject: null,

    /**
      Adds each object in the passed enumerable to the receiver.
       @method addObjects
      @param {Ember.Enumerable} objects the objects to add.
      @return {Object} receiver
    */
    addObjects: function (objects) {
      property_events.beginPropertyChanges(this);
      enumerable_utils.forEach(objects, function (obj) {
        this.addObject(obj);
      }, this);
      property_events.endPropertyChanges(this);
      return this;
    },

    /**
      __Required.__ You must implement this method to apply this mixin.
       Attempts to remove the passed object from the receiver collection if the
      object is present in the collection. If the object is not present,
      this method has no effect.
       If the passed object is of a type not supported by the receiver,
      then this method should raise an exception.
       @method removeObject
      @param {Object} object The object to remove from the enumerable.
      @return {Object} the passed object
    */
    removeObject: null,

    /**
      Removes each object in the passed enumerable from the receiver.
       @method removeObjects
      @param {Ember.Enumerable} objects the objects to remove
      @return {Object} receiver
    */
    removeObjects: function (objects) {
      property_events.beginPropertyChanges(this);
      for (var i = objects.length - 1; i >= 0; i--) {
        this.removeObject(objects[i]);
      }
      property_events.endPropertyChanges(this);
      return this;
    }
  });

});
enifed('ember-runtime/mixins/observable', ['exports', 'ember-metal/core', 'ember-metal/property_get', 'ember-metal/property_set', 'ember-metal/get_properties', 'ember-metal/set_properties', 'ember-metal/mixin', 'ember-metal/events', 'ember-metal/property_events', 'ember-metal/observer', 'ember-metal/computed', 'ember-metal/is_none'], function (exports, Ember, property_get, property_set, getProperties, setProperties, mixin, events, property_events, observer, computed, isNone) {

  'use strict';

  /**
  @module ember
  @submodule ember-runtime
  */
  exports['default'] = mixin.Mixin.create({

    /**
      Retrieves the value of a property from the object.
       This method is usually similar to using `object[keyName]` or `object.keyName`,
      however it supports both computed properties and the unknownProperty
      handler.
       Because `get` unifies the syntax for accessing all these kinds
      of properties, it can make many refactorings easier, such as replacing a
      simple property with a computed property, or vice versa.
       ### Computed Properties
       Computed properties are methods defined with the `property` modifier
      declared at the end, such as:
       ```javascript
      fullName: function() {
        return this.get('firstName') + ' ' + this.get('lastName');
      }.property('firstName', 'lastName')
      ```
       When you call `get` on a computed property, the function will be
      called and the return value will be returned instead of the function
      itself.
       ### Unknown Properties
       Likewise, if you try to call `get` on a property whose value is
      `undefined`, the `unknownProperty()` method will be called on the object.
      If this method returns any value other than `undefined`, it will be returned
      instead. This allows you to implement "virtual" properties that are
      not defined upfront.
       @method get
      @param {String} keyName The property to retrieve
      @return {Object} The property value or undefined.
    */
    get: function (keyName) {
      return property_get.get(this, keyName);
    },

    /**
      To get the values of multiple properties at once, call `getProperties`
      with a list of strings or an array:
       ```javascript
      record.getProperties('firstName', 'lastName', 'zipCode');
      // { firstName: 'John', lastName: 'Doe', zipCode: '10011' }
      ```
       is equivalent to:
       ```javascript
      record.getProperties(['firstName', 'lastName', 'zipCode']);
      // { firstName: 'John', lastName: 'Doe', zipCode: '10011' }
      ```
       @method getProperties
      @param {String...|Array} list of keys to get
      @return {Hash}
    */
    getProperties: function () {
      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      return getProperties['default'].apply(null, [this].concat(args));
    },

    /**
      Sets the provided key or path to the value.
       This method is generally very similar to calling `object[key] = value` or
      `object.key = value`, except that it provides support for computed
      properties, the `setUnknownProperty()` method and property observers.
       ### Computed Properties
       If you try to set a value on a key that has a computed property handler
      defined (see the `get()` method for an example), then `set()` will call
      that method, passing both the value and key instead of simply changing
      the value itself. This is useful for those times when you need to
      implement a property that is composed of one or more member
      properties.
       ### Unknown Properties
       If you try to set a value on a key that is undefined in the target
      object, then the `setUnknownProperty()` handler will be called instead. This
      gives you an opportunity to implement complex "virtual" properties that
      are not predefined on the object. If `setUnknownProperty()` returns
      undefined, then `set()` will simply set the value on the object.
       ### Property Observers
       In addition to changing the property, `set()` will also register a property
      change with the object. Unless you have placed this call inside of a
      `beginPropertyChanges()` and `endPropertyChanges(),` any "local" observers
      (i.e. observer methods declared on the same object), will be called
      immediately. Any "remote" observers (i.e. observer methods declared on
      another object) will be placed in a queue and called at a later time in a
      coalesced manner.
       ### Chaining
       In addition to property changes, `set()` returns the value of the object
      itself so you can do chaining like this:
       ```javascript
      record.set('firstName', 'Charles').set('lastName', 'Jolley');
      ```
       @method set
      @param {String} keyName The property to set
      @param {Object} value The value to set or `null`.
      @return {Ember.Observable}
    */
    set: function (keyName, value) {
      property_set.set(this, keyName, value);
      return this;
    },

    /**
      Sets a list of properties at once. These properties are set inside
      a single `beginPropertyChanges` and `endPropertyChanges` batch, so
      observers will be buffered.
       ```javascript
      record.setProperties({ firstName: 'Charles', lastName: 'Jolley' });
      ```
       @method setProperties
      @param {Hash} hash the hash of keys and values to set
      @return {Ember.Observable}
    */
    setProperties: function (hash) {
      return setProperties['default'](this, hash);
    },

    /**
      Begins a grouping of property changes.
       You can use this method to group property changes so that notifications
      will not be sent until the changes are finished. If you plan to make a
      large number of changes to an object at one time, you should call this
      method at the beginning of the changes to begin deferring change
      notifications. When you are done making changes, call
      `endPropertyChanges()` to deliver the deferred change notifications and end
      deferring.
       @method beginPropertyChanges
      @return {Ember.Observable}
    */
    beginPropertyChanges: function () {
      property_events.beginPropertyChanges();
      return this;
    },

    /**
      Ends a grouping of property changes.
       You can use this method to group property changes so that notifications
      will not be sent until the changes are finished. If you plan to make a
      large number of changes to an object at one time, you should call
      `beginPropertyChanges()` at the beginning of the changes to defer change
      notifications. When you are done making changes, call this method to
      deliver the deferred change notifications and end deferring.
       @method endPropertyChanges
      @return {Ember.Observable}
    */
    endPropertyChanges: function () {
      property_events.endPropertyChanges();
      return this;
    },

    /**
      Notify the observer system that a property is about to change.
       Sometimes you need to change a value directly or indirectly without
      actually calling `get()` or `set()` on it. In this case, you can use this
      method and `propertyDidChange()` instead. Calling these two methods
      together will notify all observers that the property has potentially
      changed value.
       Note that you must always call `propertyWillChange` and `propertyDidChange`
      as a pair. If you do not, it may get the property change groups out of
      order and cause notifications to be delivered more often than you would
      like.
       @method propertyWillChange
      @param {String} keyName The property key that is about to change.
      @return {Ember.Observable}
    */
    propertyWillChange: function (keyName) {
      property_events.propertyWillChange(this, keyName);
      return this;
    },

    /**
      Notify the observer system that a property has just changed.
       Sometimes you need to change a value directly or indirectly without
      actually calling `get()` or `set()` on it. In this case, you can use this
      method and `propertyWillChange()` instead. Calling these two methods
      together will notify all observers that the property has potentially
      changed value.
       Note that you must always call `propertyWillChange` and `propertyDidChange`
      as a pair. If you do not, it may get the property change groups out of
      order and cause notifications to be delivered more often than you would
      like.
       @method propertyDidChange
      @param {String} keyName The property key that has just changed.
      @return {Ember.Observable}
    */
    propertyDidChange: function (keyName) {
      property_events.propertyDidChange(this, keyName);
      return this;
    },

    /**
      Convenience method to call `propertyWillChange` and `propertyDidChange` in
      succession.
       @method notifyPropertyChange
      @param {String} keyName The property key to be notified about.
      @return {Ember.Observable}
    */
    notifyPropertyChange: function (keyName) {
      this.propertyWillChange(keyName);
      this.propertyDidChange(keyName);
      return this;
    },

    addBeforeObserver: function (key, target, method) {
            observer.addBeforeObserver(this, key, target, method);
    },

    /**
      Adds an observer on a property.
       This is the core method used to register an observer for a property.
       Once you call this method, any time the key's value is set, your observer
      will be notified. Note that the observers are triggered any time the
      value is set, regardless of whether it has actually changed. Your
      observer should be prepared to handle that.
       You can also pass an optional context parameter to this method. The
      context will be passed to your observer method whenever it is triggered.
      Note that if you add the same target/method pair on a key multiple times
      with different context parameters, your observer will only be called once
      with the last context you passed.
       ### Observer Methods
       Observer methods you pass should generally have the following signature if
      you do not pass a `context` parameter:
       ```javascript
      fooDidChange: function(sender, key, value, rev) { };
      ```
       The sender is the object that changed. The key is the property that
      changes. The value property is currently reserved and unused. The rev
      is the last property revision of the object when it changed, which you can
      use to detect if the key value has really changed or not.
       If you pass a `context` parameter, the context will be passed before the
      revision like so:
       ```javascript
      fooDidChange: function(sender, key, value, context, rev) { };
      ```
       Usually you will not need the value, context or revision parameters at
      the end. In this case, it is common to write observer methods that take
      only a sender and key value as parameters or, if you aren't interested in
      any of these values, to write an observer that has no parameters at all.
       @method addObserver
      @param {String} key The key to observer
      @param {Object} target The target object to invoke
      @param {String|Function} method The method to invoke.
    */
    addObserver: function (key, target, method) {
      observer.addObserver(this, key, target, method);
    },

    /**
      Remove an observer you have previously registered on this object. Pass
      the same key, target, and method you passed to `addObserver()` and your
      target will no longer receive notifications.
       @method removeObserver
      @param {String} key The key to observer
      @param {Object} target The target object to invoke
      @param {String|Function} method The method to invoke.
    */
    removeObserver: function (key, target, method) {
      observer.removeObserver(this, key, target, method);
    },

    /**
      Returns `true` if the object currently has observers registered for a
      particular key. You can use this method to potentially defer performing
      an expensive action until someone begins observing a particular property
      on the object.
       @method hasObserverFor
      @param {String} key Key to check
      @return {Boolean}
    */
    hasObserverFor: function (key) {
      return events.hasListeners(this, key + ":change");
    },

    /**
      Retrieves the value of a property, or a default value in the case that the
      property returns `undefined`.
       ```javascript
      person.getWithDefault('lastName', 'Doe');
      ```
       @method getWithDefault
      @param {String} keyName The name of the property to retrieve
      @param {Object} defaultValue The value to return if the property value is undefined
      @return {Object} The property value or the defaultValue.
    */
    getWithDefault: function (keyName, defaultValue) {
      return property_get.getWithDefault(this, keyName, defaultValue);
    },

    /**
      Set the value of a property to the current value plus some amount.
       ```javascript
      person.incrementProperty('age');
      team.incrementProperty('score', 2);
      ```
       @method incrementProperty
      @param {String} keyName The name of the property to increment
      @param {Number} increment The amount to increment by. Defaults to 1
      @return {Number} The new property value
    */
    incrementProperty: function (keyName, increment) {
      if (isNone['default'](increment)) {
        increment = 1;
      }
            property_set.set(this, keyName, (parseFloat(property_get.get(this, keyName)) || 0) + increment);
      return property_get.get(this, keyName);
    },

    /**
      Set the value of a property to the current value minus some amount.
       ```javascript
      player.decrementProperty('lives');
      orc.decrementProperty('health', 5);
      ```
       @method decrementProperty
      @param {String} keyName The name of the property to decrement
      @param {Number} decrement The amount to decrement by. Defaults to 1
      @return {Number} The new property value
    */
    decrementProperty: function (keyName, decrement) {
      if (isNone['default'](decrement)) {
        decrement = 1;
      }
            property_set.set(this, keyName, (property_get.get(this, keyName) || 0) - decrement);
      return property_get.get(this, keyName);
    },

    /**
      Set the value of a boolean property to the opposite of its
      current value.
       ```javascript
      starship.toggleProperty('warpDriveEngaged');
      ```
       @method toggleProperty
      @param {String} keyName The name of the property to toggle
      @return {Object} The new property value
    */
    toggleProperty: function (keyName) {
      property_set.set(this, keyName, !property_get.get(this, keyName));
      return property_get.get(this, keyName);
    },

    /**
      Returns the cached value of a computed property, if it exists.
      This allows you to inspect the value of a computed property
      without accidentally invoking it if it is intended to be
      generated lazily.
       @method cacheFor
      @param {String} keyName
      @return {Object} The cached value of the computed property, if any
    */
    cacheFor: function (keyName) {
      return computed.cacheFor(this, keyName);
    },

    // intended for debugging purposes
    observersForKey: function (keyName) {
      return observer.observersFor(this, keyName);
    }
  });

});
enifed('ember-runtime/mixins/promise_proxy', ['exports', 'ember-metal/property_get', 'ember-metal/set_properties', 'ember-metal/computed', 'ember-metal/mixin', 'ember-metal/error'], function (exports, property_get, setProperties, computed, mixin, EmberError) {

  'use strict';

  var not = computed.computed.not;
  var or = computed.computed.or;

  /**
    @module ember
    @submodule ember-runtime
   */

  function tap(proxy, promise) {
    setProperties['default'](proxy, {
      isFulfilled: false,
      isRejected: false
    });

    return promise.then(function (value) {
      setProperties['default'](proxy, {
        content: value,
        isFulfilled: true
      });
      return value;
    }, function (reason) {
      setProperties['default'](proxy, {
        reason: reason,
        isRejected: true
      });
      throw reason;
    }, "Ember: PromiseProxy");
  }

  /**
    A low level mixin making ObjectProxy, ObjectController or ArrayControllers promise-aware.

    ```javascript
    var ObjectPromiseController = Ember.ObjectController.extend(Ember.PromiseProxyMixin);

    var controller = ObjectPromiseController.create({
      promise: $.getJSON('/some/remote/data.json')
    });

    controller.then(function(json){
       // the json
    }, function(reason) {
       // the reason why you have no json
    });
    ```

    the controller has bindable attributes which
    track the promises life cycle

    ```javascript
    controller.get('isPending')   //=> true
    controller.get('isSettled')  //=> false
    controller.get('isRejected')  //=> false
    controller.get('isFulfilled') //=> false
    ```

    When the the $.getJSON completes, and the promise is fulfilled
    with json, the life cycle attributes will update accordingly.

    ```javascript
    controller.get('isPending')   //=> false
    controller.get('isSettled')   //=> true
    controller.get('isRejected')  //=> false
    controller.get('isFulfilled') //=> true
    ```

    As the controller is an ObjectController, and the json now its content,
    all the json properties will be available directly from the controller.

    ```javascript
    // Assuming the following json:
    {
      firstName: 'Stefan',
      lastName: 'Penner'
    }

    // both properties will accessible on the controller
    controller.get('firstName') //=> 'Stefan'
    controller.get('lastName')  //=> 'Penner'
    ```

    If the controller is backing a template, the attributes are
    bindable from within that template

    ```handlebars
    {{#if isPending}}
      loading...
    {{else}}
      firstName: {{firstName}}
      lastName: {{lastName}}
    {{/if}}
    ```
    @class Ember.PromiseProxyMixin
  */
  exports['default'] = mixin.Mixin.create({
    /**
      If the proxied promise is rejected this will contain the reason
      provided.
       @property reason
      @default null
    */
    reason: null,

    /**
      Once the proxied promise has settled this will become `false`.
       @property isPending
      @default true
    */
    isPending: not("isSettled").readOnly(),

    /**
      Once the proxied promise has settled this will become `true`.
       @property isSettled
      @default false
    */
    isSettled: or("isRejected", "isFulfilled").readOnly(),

    /**
      Will become `true` if the proxied promise is rejected.
       @property isRejected
      @default false
    */
    isRejected: false,

    /**
      Will become `true` if the proxied promise is fulfilled.
       @property isFulfilled
      @default false
    */
    isFulfilled: false,

    /**
      The promise whose fulfillment value is being proxied by this object.
       This property must be specified upon creation, and should not be
      changed once created.
       Example:
       ```javascript
      Ember.ObjectController.extend(Ember.PromiseProxyMixin).create({
        promise: <thenable>
      });
      ```
       @property promise
    */
    promise: computed.computed({
      get: function () {
        throw new EmberError['default']("PromiseProxy's promise must be set");
      },
      set: function (key, promise) {
        return tap(this, promise);
      }
    }),

    /**
      An alias to the proxied promise's `then`.
       See RSVP.Promise.then.
       @method then
      @param {Function} callback
      @return {RSVP.Promise}
    */
    then: promiseAlias("then"),

    /**
      An alias to the proxied promise's `catch`.
       See RSVP.Promise.catch.
       @method catch
      @param {Function} callback
      @return {RSVP.Promise}
      @since 1.3.0
    */
    "catch": promiseAlias("catch"),

    /**
      An alias to the proxied promise's `finally`.
       See RSVP.Promise.finally.
       @method finally
      @param {Function} callback
      @return {RSVP.Promise}
      @since 1.3.0
    */
    "finally": promiseAlias("finally")

  });

  function promiseAlias(name) {
    return function () {
      var promise = property_get.get(this, "promise");
      return promise[name].apply(promise, arguments);
    };
  }

});
enifed('ember-runtime/mixins/sortable', ['exports', 'ember-metal/core', 'ember-metal/property_get', 'ember-metal/enumerable_utils', 'ember-runtime/mixins/mutable_enumerable', 'ember-runtime/compare', 'ember-metal/observer', 'ember-metal/computed', 'ember-metal/computed_macros', 'ember-metal/mixin'], function (exports, Ember, property_get, enumerable_utils, MutableEnumerable, compare, observer, computed, computed_macros, mixin) {

  'use strict';

  /**
  @module ember
  @submodule ember-runtime
  */

  exports['default'] = mixin.Mixin.create(MutableEnumerable['default'], {

    /**
      Specifies which properties dictate the `arrangedContent`'s sort order.
       When specifying multiple properties the sorting will use properties
      from the `sortProperties` array prioritized from first to last.
       @property {Array} sortProperties
    */
    sortProperties: null,

    /**
      Specifies the `arrangedContent`'s sort direction.
      Sorts the content in ascending order by default. Set to `false` to
      use descending order.
       @property {Boolean} sortAscending
      @default true
    */
    sortAscending: true,

    /**
      The function used to compare two values. You can override this if you
      want to do custom comparisons. Functions must be of the type expected by
      Array#sort, i.e.,
       *  return 0 if the two parameters are equal,
      *  return a negative value if the first parameter is smaller than the second or
      *  return a positive value otherwise:
       ```javascript
      function(x, y) { // These are assumed to be integers
        if (x === y)
          return 0;
        return x < y ? -1 : 1;
      }
      ```
       @property sortFunction
      @type {Function}
      @default Ember.compare
    */
    sortFunction: compare['default'],

    orderBy: function (item1, item2) {
      var result = 0;
      var sortProperties = property_get.get(this, "sortProperties");
      var sortAscending = property_get.get(this, "sortAscending");
      var sortFunction = property_get.get(this, "sortFunction");

      
      enumerable_utils.forEach(sortProperties, function (propertyName) {
        if (result === 0) {
          result = sortFunction.call(this, property_get.get(item1, propertyName), property_get.get(item2, propertyName));
          if (result !== 0 && !sortAscending) {
            result = -1 * result;
          }
        }
      }, this);

      return result;
    },

    destroy: function () {
      var content = property_get.get(this, "content");
      var sortProperties = property_get.get(this, "sortProperties");

      if (content && sortProperties) {
        enumerable_utils.forEach(content, function (item) {
          enumerable_utils.forEach(sortProperties, function (sortProperty) {
            observer.removeObserver(item, sortProperty, this, "contentItemSortPropertyDidChange");
          }, this);
        }, this);
      }

      return this._super.apply(this, arguments);
    },

    isSorted: computed_macros.notEmpty("sortProperties"),

    /**
      Overrides the default `arrangedContent` from `ArrayProxy` in order to sort by `sortFunction`.
      Also sets up observers for each `sortProperty` on each item in the content Array.
       @property arrangedContent
    */
    arrangedContent: computed.computed("content", "sortProperties.@each", {
      get: function (key) {
        var content = property_get.get(this, "content");
        var isSorted = property_get.get(this, "isSorted");
        var sortProperties = property_get.get(this, "sortProperties");
        var self = this;

        if (content && isSorted) {
          content = content.slice();
          content.sort(function (item1, item2) {
            return self.orderBy(item1, item2);
          });
          enumerable_utils.forEach(content, function (item) {
            enumerable_utils.forEach(sortProperties, function (sortProperty) {
              observer.addObserver(item, sortProperty, this, "contentItemSortPropertyDidChange");
            }, this);
          }, this);
          return Ember['default'].A(content);
        }

        return content;
      }
    }),

    _contentWillChange: mixin.beforeObserver("content", function () {
      var content = property_get.get(this, "content");
      var sortProperties = property_get.get(this, "sortProperties");

      if (content && sortProperties) {
        enumerable_utils.forEach(content, function (item) {
          enumerable_utils.forEach(sortProperties, function (sortProperty) {
            observer.removeObserver(item, sortProperty, this, "contentItemSortPropertyDidChange");
          }, this);
        }, this);
      }

      this._super.apply(this, arguments);
    }),

    sortPropertiesWillChange: mixin.beforeObserver("sortProperties", function () {
      this._lastSortAscending = undefined;
    }),

    sortPropertiesDidChange: mixin.observer("sortProperties", function () {
      this._lastSortAscending = undefined;
    }),

    sortAscendingWillChange: mixin.beforeObserver("sortAscending", function () {
      this._lastSortAscending = property_get.get(this, "sortAscending");
    }),

    sortAscendingDidChange: mixin.observer("sortAscending", function () {
      if (this._lastSortAscending !== undefined && property_get.get(this, "sortAscending") !== this._lastSortAscending) {
        var arrangedContent = property_get.get(this, "arrangedContent");
        arrangedContent.reverseObjects();
      }
    }),

    contentArrayWillChange: function (array, idx, removedCount, addedCount) {
      var isSorted = property_get.get(this, "isSorted");

      if (isSorted) {
        var arrangedContent = property_get.get(this, "arrangedContent");
        var removedObjects = array.slice(idx, idx + removedCount);
        var sortProperties = property_get.get(this, "sortProperties");

        enumerable_utils.forEach(removedObjects, function (item) {
          arrangedContent.removeObject(item);

          enumerable_utils.forEach(sortProperties, function (sortProperty) {
            observer.removeObserver(item, sortProperty, this, "contentItemSortPropertyDidChange");
          }, this);
        }, this);
      }

      return this._super(array, idx, removedCount, addedCount);
    },

    contentArrayDidChange: function (array, idx, removedCount, addedCount) {
      var isSorted = property_get.get(this, "isSorted");
      var sortProperties = property_get.get(this, "sortProperties");

      if (isSorted) {
        var addedObjects = array.slice(idx, idx + addedCount);

        enumerable_utils.forEach(addedObjects, function (item) {
          this.insertItemSorted(item);

          enumerable_utils.forEach(sortProperties, function (sortProperty) {
            observer.addObserver(item, sortProperty, this, "contentItemSortPropertyDidChange");
          }, this);
        }, this);
      }

      return this._super(array, idx, removedCount, addedCount);
    },

    insertItemSorted: function (item) {
      var arrangedContent = property_get.get(this, "arrangedContent");
      var length = property_get.get(arrangedContent, "length");

      var idx = this._binarySearch(item, 0, length);
      arrangedContent.insertAt(idx, item);
    },

    contentItemSortPropertyDidChange: function (item) {
      var arrangedContent = property_get.get(this, "arrangedContent");
      var oldIndex = arrangedContent.indexOf(item);
      var leftItem = arrangedContent.objectAt(oldIndex - 1);
      var rightItem = arrangedContent.objectAt(oldIndex + 1);
      var leftResult = leftItem && this.orderBy(item, leftItem);
      var rightResult = rightItem && this.orderBy(item, rightItem);

      if (leftResult < 0 || rightResult > 0) {
        arrangedContent.removeObject(item);
        this.insertItemSorted(item);
      }
    },

    _binarySearch: function (item, low, high) {
      var mid, midItem, res, arrangedContent;

      if (low === high) {
        return low;
      }

      arrangedContent = property_get.get(this, "arrangedContent");

      mid = low + Math.floor((high - low) / 2);
      midItem = arrangedContent.objectAt(mid);

      res = this.orderBy(midItem, item);

      if (res < 0) {
        return this._binarySearch(item, mid + 1, high);
      } else if (res > 0) {
        return this._binarySearch(item, low, mid);
      }

      return mid;
    }
  });

});
enifed('ember-runtime/mixins/target_action_support', ['exports', 'ember-metal/core', 'ember-metal/property_get', 'ember-metal/utils', 'ember-metal/mixin', 'ember-metal/computed'], function (exports, Ember, property_get, utils, mixin, computed) {

  'use strict';

  /**
  @module ember
  @submodule ember-runtime
  */
  var TargetActionSupport = mixin.Mixin.create({
    target: null,
    action: null,
    actionContext: null,

    targetObject: computed.computed(function () {
      var target = property_get.get(this, "target");

      if (utils.typeOf(target) === "string") {
        var value = property_get.get(this, target);
        if (value === undefined) {
          value = property_get.get(Ember['default'].lookup, target);
        }

        return value;
      } else {
        return target;
      }
    }).property("target"),

    actionContextObject: computed.computed(function () {
      var actionContext = property_get.get(this, "actionContext");

      if (utils.typeOf(actionContext) === "string") {
        var value = property_get.get(this, actionContext);
        if (value === undefined) {
          value = property_get.get(Ember['default'].lookup, actionContext);
        }
        return value;
      } else {
        return actionContext;
      }
    }).property("actionContext"),

    /**
    Send an `action` with an `actionContext` to a `target`. The action, actionContext
    and target will be retrieved from properties of the object. For example:
     ```javascript
    App.SaveButtonView = Ember.View.extend(Ember.TargetActionSupport, {
      target: Ember.computed.alias('controller'),
      action: 'save',
      actionContext: Ember.computed.alias('context'),
      click: function() {
        this.triggerAction(); // Sends the `save` action, along with the current context
                              // to the current controller
      }
    });
    ```
     The `target`, `action`, and `actionContext` can be provided as properties of
    an optional object argument to `triggerAction` as well.
     ```javascript
    App.SaveButtonView = Ember.View.extend(Ember.TargetActionSupport, {
      click: function() {
        this.triggerAction({
          action: 'save',
          target: this.get('controller'),
          actionContext: this.get('context')
        }); // Sends the `save` action, along with the current context
            // to the current controller
      }
    });
    ```
     The `actionContext` defaults to the object you are mixing `TargetActionSupport` into.
    But `target` and `action` must be specified either as properties or with the argument
    to `triggerAction`, or a combination:
     ```javascript
    App.SaveButtonView = Ember.View.extend(Ember.TargetActionSupport, {
      target: Ember.computed.alias('controller'),
      click: function() {
        this.triggerAction({
          action: 'save'
        }); // Sends the `save` action, along with a reference to `this`,
            // to the current controller
      }
    });
    ```
     @method triggerAction
    @param opts {Hash} (optional, with the optional keys action, target and/or actionContext)
    @return {Boolean} true if the action was sent successfully and did not return false
    */
    triggerAction: function (opts) {
      opts = opts || {};
      var action = opts.action || property_get.get(this, "action");
      var target = opts.target || property_get.get(this, "targetObject");
      var actionContext = opts.actionContext;

      function args(options, actionName) {
        var ret = [];
        if (actionName) {
          ret.push(actionName);
        }

        return ret.concat(options);
      }

      if (typeof actionContext === "undefined") {
        actionContext = property_get.get(this, "actionContextObject") || this;
      }

      if (target && action) {
        var ret;

        if (target.send) {
          ret = target.send.apply(target, args(actionContext, action));
        } else {
                    ret = target[action].apply(target, args(actionContext));
        }

        if (ret !== false) {
          ret = true;
        }

        return ret;
      } else {
        return false;
      }
    }
  });

  exports['default'] = TargetActionSupport;

});
enifed('ember-runtime/system/application', ['exports', 'ember-runtime/system/namespace'], function (exports, Namespace) {

	'use strict';

	exports['default'] = Namespace['default'].extend();

});
enifed('ember-runtime/system/array_proxy', ['exports', 'ember-metal/core', 'ember-metal/property_get', 'ember-metal/utils', 'ember-metal/computed', 'ember-metal/mixin', 'ember-metal/property_events', 'ember-metal/error', 'ember-runtime/system/object', 'ember-runtime/mixins/mutable_array', 'ember-runtime/mixins/enumerable', 'ember-runtime/system/string', 'ember-metal/alias'], function (exports, Ember, property_get, utils, computed, mixin, property_events, EmberError, EmberObject, MutableArray, Enumerable, string, alias) {

  'use strict';

  var OUT_OF_RANGE_EXCEPTION = "Index out of range";
  var EMPTY = [];

  function K() {
    return this;
  }

  /**
    An ArrayProxy wraps any other object that implements `Ember.Array` and/or
    `Ember.MutableArray,` forwarding all requests. This makes it very useful for
    a number of binding use cases or other cases where being able to swap
    out the underlying array is useful.

    A simple example of usage:

    ```javascript
    var pets = ['dog', 'cat', 'fish'];
    var ap = Ember.ArrayProxy.create({ content: Ember.A(pets) });

    ap.get('firstObject');                        // 'dog'
    ap.set('content', ['amoeba', 'paramecium']);
    ap.get('firstObject');                        // 'amoeba'
    ```

    This class can also be useful as a layer to transform the contents of
    an array, as they are accessed. This can be done by overriding
    `objectAtContent`:

    ```javascript
    var pets = ['dog', 'cat', 'fish'];
    var ap = Ember.ArrayProxy.create({
        content: Ember.A(pets),
        objectAtContent: function(idx) {
            return this.get('content').objectAt(idx).toUpperCase();
        }
    });

    ap.get('firstObject'); // . 'DOG'
    ```

    @class ArrayProxy
    @namespace Ember
    @extends Ember.Object
    @uses Ember.MutableArray
  */
  var ArrayProxy = EmberObject['default'].extend(MutableArray['default'], {

    /**
      The content array. Must be an object that implements `Ember.Array` and/or
      `Ember.MutableArray.`
       @property content
      @type Ember.Array
    */
    content: null,

    /**
     The array that the proxy pretends to be. In the default `ArrayProxy`
     implementation, this and `content` are the same. Subclasses of `ArrayProxy`
     can override this property to provide things like sorting and filtering.
      @property arrangedContent
    */
    arrangedContent: alias['default']("content"),

    /**
      Should actually retrieve the object at the specified index from the
      content. You can override this method in subclasses to transform the
      content item to something new.
       This method will only be called if content is non-`null`.
       @method objectAtContent
      @param {Number} idx The index to retrieve.
      @return {Object} the value or undefined if none found
    */
    objectAtContent: function (idx) {
      return property_get.get(this, "arrangedContent").objectAt(idx);
    },

    /**
      Should actually replace the specified objects on the content array.
      You can override this method in subclasses to transform the content item
      into something new.
       This method will only be called if content is non-`null`.
       @method replaceContent
      @param {Number} idx The starting index
      @param {Number} amt The number of items to remove from the content.
      @param {Array} objects Optional array of objects to insert or null if no
        objects.
      @return {void}
    */
    replaceContent: function (idx, amt, objects) {
      property_get.get(this, "content").replace(idx, amt, objects);
    },

    /**
      Invoked when the content property is about to change. Notifies observers that the
      entire array content will change.
       @private
      @method _contentWillChange
    */
    _contentWillChange: mixin.beforeObserver("content", function () {
      this._teardownContent();
    }),

    _teardownContent: function () {
      var content = property_get.get(this, "content");

      if (content) {
        content.removeArrayObserver(this, {
          willChange: "contentArrayWillChange",
          didChange: "contentArrayDidChange"
        });
      }
    },

    /**
      Override to implement content array `willChange` observer.
       @method contentArrayWillChange
       @param {Ember.Array} contentArray the content array
      @param {Number} start starting index of the change
      @param {Number} removeCount count of items removed
      @param {Number} addCount count of items added
     */
    contentArrayWillChange: K,
    /**
      Override to implement content array `didChange` observer.
       @method contentArrayDidChange
       @param {Ember.Array} contentArray the content array
      @param {Number} start starting index of the change
      @param {Number} removeCount count of items removed
      @param {Number} addCount count of items added
    */
    contentArrayDidChange: K,

    /**
      Invoked when the content property changes. Notifies observers that the
      entire array content has changed.
       @private
      @method _contentDidChange
    */
    _contentDidChange: mixin.observer("content", function () {
      var content = property_get.get(this, "content");

      
      this._setupContent();
    }),

    _setupContent: function () {
      var content = property_get.get(this, "content");

      if (content) {
        
        content.addArrayObserver(this, {
          willChange: "contentArrayWillChange",
          didChange: "contentArrayDidChange"
        });
      }
    },

    _arrangedContentWillChange: mixin.beforeObserver("arrangedContent", function () {
      var arrangedContent = property_get.get(this, "arrangedContent");
      var len = arrangedContent ? property_get.get(arrangedContent, "length") : 0;

      this.arrangedContentArrayWillChange(this, 0, len, undefined);
      this.arrangedContentWillChange(this);

      this._teardownArrangedContent(arrangedContent);
    }),

    _arrangedContentDidChange: mixin.observer("arrangedContent", function () {
      var arrangedContent = property_get.get(this, "arrangedContent");
      var len = arrangedContent ? property_get.get(arrangedContent, "length") : 0;

      
      this._setupArrangedContent();

      this.arrangedContentDidChange(this);
      this.arrangedContentArrayDidChange(this, 0, undefined, len);
    }),

    _setupArrangedContent: function () {
      var arrangedContent = property_get.get(this, "arrangedContent");

      if (arrangedContent) {
        
        arrangedContent.addArrayObserver(this, {
          willChange: "arrangedContentArrayWillChange",
          didChange: "arrangedContentArrayDidChange"
        });
      }
    },

    _teardownArrangedContent: function () {
      var arrangedContent = property_get.get(this, "arrangedContent");

      if (arrangedContent) {
        arrangedContent.removeArrayObserver(this, {
          willChange: "arrangedContentArrayWillChange",
          didChange: "arrangedContentArrayDidChange"
        });
      }
    },

    arrangedContentWillChange: K,
    arrangedContentDidChange: K,

    objectAt: function (idx) {
      return property_get.get(this, "content") && this.objectAtContent(idx);
    },

    length: computed.computed(function () {
      var arrangedContent = property_get.get(this, "arrangedContent");
      return arrangedContent ? property_get.get(arrangedContent, "length") : 0;
      // No dependencies since Enumerable notifies length of change
    }),

    _replace: function (idx, amt, objects) {
      var content = property_get.get(this, "content");
            if (content) {
        this.replaceContent(idx, amt, objects);
      }

      return this;
    },

    replace: function () {
      if (property_get.get(this, "arrangedContent") === property_get.get(this, "content")) {
        this._replace.apply(this, arguments);
      } else {
        throw new EmberError['default']("Using replace on an arranged ArrayProxy is not allowed.");
      }
    },

    _insertAt: function (idx, object) {
      if (idx > property_get.get(this, "content.length")) {
        throw new EmberError['default'](OUT_OF_RANGE_EXCEPTION);
      }

      this._replace(idx, 0, [object]);
      return this;
    },

    insertAt: function (idx, object) {
      if (property_get.get(this, "arrangedContent") === property_get.get(this, "content")) {
        return this._insertAt(idx, object);
      } else {
        throw new EmberError['default']("Using insertAt on an arranged ArrayProxy is not allowed.");
      }
    },

    removeAt: function (start, len) {
      if ("number" === typeof start) {
        var content = property_get.get(this, "content");
        var arrangedContent = property_get.get(this, "arrangedContent");
        var indices = [];
        var i;

        if (start < 0 || start >= property_get.get(this, "length")) {
          throw new EmberError['default'](OUT_OF_RANGE_EXCEPTION);
        }

        if (len === undefined) {
          len = 1;
        }

        // Get a list of indices in original content to remove
        for (i = start; i < start + len; i++) {
          // Use arrangedContent here so we avoid confusion with objects transformed by objectAtContent
          indices.push(content.indexOf(arrangedContent.objectAt(i)));
        }

        // Replace in reverse order since indices will change
        indices.sort(function (a, b) {
          return b - a;
        });

        property_events.beginPropertyChanges();
        for (i = 0; i < indices.length; i++) {
          this._replace(indices[i], 1, EMPTY);
        }
        property_events.endPropertyChanges();
      }

      return this;
    },

    pushObject: function (obj) {
      this._insertAt(property_get.get(this, "content.length"), obj);
      return obj;
    },

    pushObjects: function (objects) {
      if (!(Enumerable['default'].detect(objects) || utils.isArray(objects))) {
        throw new TypeError("Must pass Ember.Enumerable to Ember.MutableArray#pushObjects");
      }
      this._replace(property_get.get(this, "length"), 0, objects);
      return this;
    },

    setObjects: function (objects) {
      if (objects.length === 0) {
        return this.clear();
      }

      var len = property_get.get(this, "length");
      this._replace(0, len, objects);
      return this;
    },

    unshiftObject: function (obj) {
      this._insertAt(0, obj);
      return obj;
    },

    unshiftObjects: function (objects) {
      this._replace(0, 0, objects);
      return this;
    },

    slice: function () {
      var arr = this.toArray();
      return arr.slice.apply(arr, arguments);
    },

    arrangedContentArrayWillChange: function (item, idx, removedCnt, addedCnt) {
      this.arrayContentWillChange(idx, removedCnt, addedCnt);
    },

    arrangedContentArrayDidChange: function (item, idx, removedCnt, addedCnt) {
      this.arrayContentDidChange(idx, removedCnt, addedCnt);
    },

    init: function () {
      this._super.apply(this, arguments);
      this._setupContent();
      this._setupArrangedContent();
    },

    willDestroy: function () {
      this._teardownArrangedContent();
      this._teardownContent();
    }
  });

  exports['default'] = ArrayProxy;

});
enifed('ember-runtime/system/container', ['exports', 'ember-metal/property_set', 'container/registry', 'container/container'], function (exports, property_set, Registry, Container) {

	'use strict';

	Registry['default'].set = property_set.set;
	Container['default'].set = property_set.set;

	exports.Registry = Registry['default'];
	exports.Container = Container['default'];

});
enifed('ember-runtime/system/core_object', ['exports', 'ember-metal', 'ember-metal/merge', 'ember-metal/property_get', 'ember-metal/utils', 'ember-metal/platform/create', 'ember-metal/chains', 'ember-metal/events', 'ember-metal/mixin', 'ember-metal/enumerable_utils', 'ember-metal/error', 'ember-metal/platform/define_property', 'ember-metal/keys', 'ember-runtime/mixins/action_handler', 'ember-metal/properties', 'ember-metal/binding', 'ember-metal/computed', 'ember-metal/injected_property', 'ember-metal/run_loop', 'ember-metal/watching', 'ember-metal/core', 'ember-runtime/inject'], function (exports, Ember, merge, property_get, utils, o_create, chains, events, mixin, enumerable_utils, EmberError, define_property, keys, ActionHandler, ember_metal__properties, ember_metal__binding, computed, InjectedProperty, run, watching, core, inject) {

  


  /**
    @module ember
    @submodule ember-runtime
  */

  // using ember-metal/lib/main here to ensure that ember-debug is setup
  // if present
  "REMOVE_USE_STRICT: true";var schedule = run['default'].schedule;
  var applyMixin = mixin.Mixin._apply;
  var finishPartial = mixin.Mixin.finishPartial;
  var reopen = mixin.Mixin.prototype.reopen;
  var hasCachedComputedProperties = false;

  function makeCtor() {

    // Note: avoid accessing any properties on the object since it makes the
    // method a lot faster. This is glue code so we want it to be as fast as
    // possible.

    var wasApplied = false;
    var initMixins, initProperties;

    var Class = function () {
      if (!wasApplied) {
        Class.proto(); // prepare prototype...
      }
      this.__defineNonEnumerable(utils.GUID_KEY_PROPERTY);
      this.__defineNonEnumerable(utils.NEXT_SUPER_PROPERTY);
      var m = utils.meta(this);
      var proto = m.proto;
      m.proto = this;
      if (initMixins) {
        // capture locally so we can clear the closed over variable
        var mixins = initMixins;
        initMixins = null;
        utils.apply(this, this.reopen, mixins);
      }
      if (initProperties) {
        // capture locally so we can clear the closed over variable
        var props = initProperties;
        initProperties = null;

        var concatenatedProperties = this.concatenatedProperties;
        var mergedProperties = this.mergedProperties;

        for (var i = 0, l = props.length; i < l; i++) {
          var properties = props[i];

          
          if (typeof properties !== "object" && properties !== undefined) {
            throw new EmberError['default']("Ember.Object.create only accepts objects.");
          }

          if (!properties) {
            continue;
          }

          var keyNames = keys['default'](properties);

          for (var j = 0, ll = keyNames.length; j < ll; j++) {
            var keyName = keyNames[j];
            var value = properties[keyName];

            if (mixin.IS_BINDING.test(keyName)) {
              var bindings = m.bindings;
              if (!bindings) {
                bindings = m.bindings = {};
              } else if (!m.hasOwnProperty("bindings")) {
                bindings = m.bindings = o_create['default'](m.bindings);
              }
              bindings[keyName] = value;
            }

            var possibleDesc = this[keyName];
            var desc = possibleDesc !== null && typeof possibleDesc === "object" && possibleDesc.isDescriptor ? possibleDesc : undefined;

                                    
            if (concatenatedProperties && concatenatedProperties.length > 0 && enumerable_utils.indexOf(concatenatedProperties, keyName) >= 0) {
              var baseValue = this[keyName];

              if (baseValue) {
                if ("function" === typeof baseValue.concat) {
                  value = baseValue.concat(value);
                } else {
                  value = utils.makeArray(baseValue).concat(value);
                }
              } else {
                value = utils.makeArray(value);
              }
            }

            if (mergedProperties && mergedProperties.length && enumerable_utils.indexOf(mergedProperties, keyName) >= 0) {
              var originalValue = this[keyName];

              value = merge['default'](originalValue, value);
            }

            if (desc) {
              desc.set(this, keyName, value);
            } else {
              if (typeof this.setUnknownProperty === "function" && !(keyName in this)) {
                this.setUnknownProperty(keyName, value);
              } else {
                
                  this[keyName] = value;
                
              }
            }
          }
        }
      }

      finishPartial(this, m);

      var length = arguments.length;

      if (length === 0) {
        this.init();
      } else if (length === 1) {
        this.init(arguments[0]);
      } else {
        // v8 bug potentially incorrectly deopts this function: https://code.google.com/p/v8/issues/detail?id=3709
        // we may want to keep this around till this ages out on mobile
        var args = new Array(length);
        for (var x = 0; x < length; x++) {
          args[x] = arguments[x];
        }
        this.init.apply(this, args);
      }

      m.proto = proto;
      chains.finishChains(this);
      events.sendEvent(this, "init");
    };

    Class.toString = mixin.Mixin.prototype.toString;
    Class.willReopen = function () {
      if (wasApplied) {
        Class.PrototypeMixin = mixin.Mixin.create(Class.PrototypeMixin);
      }

      wasApplied = false;
    };
    Class._initMixins = function (args) {
      initMixins = args;
    };
    Class._initProperties = function (args) {
      initProperties = args;
    };

    Class.proto = function () {
      var superclass = Class.superclass;
      if (superclass) {
        superclass.proto();
      }

      if (!wasApplied) {
        wasApplied = true;
        Class.PrototypeMixin.applyPartial(Class.prototype);
      }

      return this.prototype;
    };

    return Class;
  }

  /**
    @class CoreObject
    @namespace Ember
  */
  var CoreObject = makeCtor();
  CoreObject.toString = function () {
    return "Ember.CoreObject";
  };
  CoreObject.PrototypeMixin = mixin.Mixin.create({
    reopen: function () {
      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      applyMixin(this, args, true);
      return this;
    },

    /**
      An overridable method called when objects are instantiated. By default,
      does nothing unless it is overridden during class definition.
       Example:
       ```javascript
      App.Person = Ember.Object.extend({
        init: function() {
          alert('Name is ' + this.get('name'));
        }
      });
       var steve = App.Person.create({
        name: "Steve"
      });
       // alerts 'Name is Steve'.
      ```
       NOTE: If you do override `init` for a framework class like `Ember.View` or
      `Ember.ArrayController`, be sure to call `this._super.apply(this, arguments)` in your
      `init` declaration! If you don't, Ember may not have an opportunity to
      do important setup work, and you'll see strange behavior in your
      application.
       @method init
    */
    init: function () {},
    __defineNonEnumerable: function (property) {
      define_property.defineProperty(this, property.name, property.descriptor);
      //this[property.name] = property.descriptor.value;
    },

    /**
      Defines the properties that will be concatenated from the superclass
      (instead of overridden).
       By default, when you extend an Ember class a property defined in
      the subclass overrides a property with the same name that is defined
      in the superclass. However, there are some cases where it is preferable
      to build up a property's value by combining the superclass' property
      value with the subclass' value. An example of this in use within Ember
      is the `classNames` property of `Ember.View`.
       Here is some sample code showing the difference between a concatenated
      property and a normal one:
       ```javascript
      App.BarView = Ember.View.extend({
        someNonConcatenatedProperty: ['bar'],
        classNames: ['bar']
      });
       App.FooBarView = App.BarView.extend({
        someNonConcatenatedProperty: ['foo'],
        classNames: ['foo']
      });
       var fooBarView = App.FooBarView.create();
      fooBarView.get('someNonConcatenatedProperty'); // ['foo']
      fooBarView.get('classNames'); // ['ember-view', 'bar', 'foo']
      ```
       This behavior extends to object creation as well. Continuing the
      above example:
       ```javascript
      var view = App.FooBarView.create({
        someNonConcatenatedProperty: ['baz'],
        classNames: ['baz']
      })
      view.get('someNonConcatenatedProperty'); // ['baz']
      view.get('classNames'); // ['ember-view', 'bar', 'foo', 'baz']
      ```
      Adding a single property that is not an array will just add it in the array:
       ```javascript
      var view = App.FooBarView.create({
        classNames: 'baz'
      })
      view.get('classNames'); // ['ember-view', 'bar', 'foo', 'baz']
      ```
       Using the `concatenatedProperties` property, we can tell Ember to mix the
      content of the properties.
       In `Ember.View` the `classNameBindings` and `attributeBindings` properties
      are also concatenated, in addition to `classNames`.
       This feature is available for you to use throughout the Ember object model,
      although typical app developers are likely to use it infrequently. Since
      it changes expectations about behavior of properties, you should properly
      document its usage in each individual concatenated property (to not
      mislead your users to think they can override the property in a subclass).
       @property concatenatedProperties
      @type Array
      @default null
    */
    concatenatedProperties: null,

    /**
      Destroyed object property flag.
       if this property is `true` the observers and bindings were already
      removed by the effect of calling the `destroy()` method.
       @property isDestroyed
      @default false
    */
    isDestroyed: false,

    /**
      Destruction scheduled flag. The `destroy()` method has been called.
       The object stays intact until the end of the run loop at which point
      the `isDestroyed` flag is set.
       @property isDestroying
      @default false
    */
    isDestroying: false,

    /**
      Destroys an object by setting the `isDestroyed` flag and removing its
      metadata, which effectively destroys observers and bindings.
       If you try to set a property on a destroyed object, an exception will be
      raised.
       Note that destruction is scheduled for the end of the run loop and does not
      happen immediately.  It will set an isDestroying flag immediately.
       @method destroy
      @return {Ember.Object} receiver
    */
    destroy: function () {
      if (this.isDestroying) {
        return;
      }
      this.isDestroying = true;

      schedule("actions", this, this.willDestroy);
      schedule("destroy", this, this._scheduledDestroy);
      return this;
    },

    /**
      Override to implement teardown.
       @method willDestroy
     */
    willDestroy: core.K,

    /**
      Invoked by the run loop to actually destroy the object. This is
      scheduled for execution by the `destroy` method.
       @private
      @method _scheduledDestroy
    */
    _scheduledDestroy: function () {
      if (this.isDestroyed) {
        return;
      }
      watching.destroy(this);
      this.isDestroyed = true;
    },

    bind: function (to, from) {
      if (!(from instanceof ember_metal__binding.Binding)) {
        from = ember_metal__binding.Binding.from(from);
      }
      from.to(to).connect(this);
      return from;
    },

    /**
      Returns a string representation which attempts to provide more information
      than Javascript's `toString` typically does, in a generic way for all Ember
      objects.
       ```javascript
      App.Person = Em.Object.extend()
      person = App.Person.create()
      person.toString() //=> "<App.Person:ember1024>"
      ```
       If the object's class is not defined on an Ember namespace, it will
      indicate it is a subclass of the registered superclass:
      ```javascript
      Student = App.Person.extend()
      student = Student.create()
      student.toString() //=> "<(subclass of App.Person):ember1025>"
      ```
       If the method `toStringExtension` is defined, its return value will be
      included in the output.
       ```javascript
      App.Teacher = App.Person.extend({
        toStringExtension: function() {
          return this.get('fullName');
        }
      });
      teacher = App.Teacher.create()
      teacher.toString(); //=> "<App.Teacher:ember1026:Tom Dale>"
      ```
       @method toString
      @return {String} string representation
    */
    toString: function () {
      var hasToStringExtension = typeof this.toStringExtension === "function";
      var extension = hasToStringExtension ? ":" + this.toStringExtension() : "";
      var ret = "<" + this.constructor.toString() + ":" + utils.guidFor(this) + extension + ">";

      this.toString = makeToString(ret);
      return ret;
    }
  });

  CoreObject.PrototypeMixin.ownerConstructor = CoreObject;

  function makeToString(ret) {
    return function () {
      return ret;
    };
  }

  CoreObject.__super__ = null;

  var ClassMixinProps = {

    ClassMixin: mixin.REQUIRED,

    PrototypeMixin: mixin.REQUIRED,

    isClass: true,

    isMethod: false,

    /**
      Creates a new subclass.
       ```javascript
      App.Person = Ember.Object.extend({
        say: function(thing) {
          alert(thing);
         }
      });
      ```
       This defines a new subclass of Ember.Object: `App.Person`. It contains one method: `say()`.
       You can also create a subclass from any existing class by calling its `extend()`  method. For example, you might want to create a subclass of Ember's built-in `Ember.View` class:
       ```javascript
      App.PersonView = Ember.View.extend({
        tagName: 'li',
        classNameBindings: ['isAdministrator']
      });
      ```
       When defining a subclass, you can override methods but still access the implementation of your parent class by calling the special `_super()` method:
       ```javascript
      App.Person = Ember.Object.extend({
        say: function(thing) {
          var name = this.get('name');
          alert(name + ' says: ' + thing);
        }
      });
       App.Soldier = App.Person.extend({
        say: function(thing) {
          this._super(thing + ", sir!");
        },
        march: function(numberOfHours) {
          alert(this.get('name') + ' marches for ' + numberOfHours + ' hours.')
        }
      });
       var yehuda = App.Soldier.create({
        name: "Yehuda Katz"
      });
       yehuda.say("Yes");  // alerts "Yehuda Katz says: Yes, sir!"
      ```
       The `create()` on line #17 creates an *instance* of the `App.Soldier` class. The `extend()` on line #8 creates a *subclass* of `App.Person`. Any instance of the `App.Person` class will *not* have the `march()` method.
       You can also pass `Mixin` classes to add additional properties to the subclass.
       ```javascript
      App.Person = Ember.Object.extend({
        say: function(thing) {
          alert(this.get('name') + ' says: ' + thing);
        }
      });
       App.SingingMixin = Mixin.create({
        sing: function(thing){
          alert(this.get('name') + ' sings: la la la ' + thing);
        }
      });
       App.BroadwayStar = App.Person.extend(App.SingingMixin, {
        dance: function() {
          alert(this.get('name') + ' dances: tap tap tap tap ');
        }
      });
      ```
       The `App.BroadwayStar` class contains three methods: `say()`, `sing()`, and `dance()`.
       @method extend
      @static
       @param {Mixin} [mixins]* One or more Mixin classes
      @param {Object} [arguments]* Object containing values to use within the new class
    */
    extend: function () {
      var Class = makeCtor();
      var proto;
      Class.ClassMixin = mixin.Mixin.create(this.ClassMixin);
      Class.PrototypeMixin = mixin.Mixin.create(this.PrototypeMixin);

      Class.ClassMixin.ownerConstructor = Class;
      Class.PrototypeMixin.ownerConstructor = Class;

      reopen.apply(Class.PrototypeMixin, arguments);

      Class.superclass = this;
      Class.__super__ = this.prototype;

      proto = Class.prototype = o_create['default'](this.prototype);
      proto.constructor = Class;
      utils.generateGuid(proto);
      utils.meta(proto).proto = proto; // this will disable observers on prototype

      Class.ClassMixin.apply(Class);
      return Class;
    },

    /**
      Equivalent to doing `extend(arguments).create()`.
      If possible use the normal `create` method instead.
       @method createWithMixins
      @static
      @param [arguments]*
    */
    createWithMixins: function () {
      for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        args[_key2] = arguments[_key2];
      }

      var C = this;
      if (args.length > 0) {
        this._initMixins(args);
      }
      return new C();
    },

    /**
      Creates an instance of a class. Accepts either no arguments, or an object
      containing values to initialize the newly instantiated object with.
       ```javascript
      App.Person = Ember.Object.extend({
        helloWorld: function() {
          alert("Hi, my name is " + this.get('name'));
        }
      });
       var tom = App.Person.create({
        name: 'Tom Dale'
      });
       tom.helloWorld(); // alerts "Hi, my name is Tom Dale".
      ```
       `create` will call the `init` function if defined during
      `Ember.AnyObject.extend`
       If no arguments are passed to `create`, it will not set values to the new
      instance during initialization:
       ```javascript
      var noName = App.Person.create();
      noName.helloWorld(); // alerts undefined
      ```
       NOTE: For performance reasons, you cannot declare methods or computed
      properties during `create`. You should instead declare methods and computed
      properties when using `extend` or use the `createWithMixins` shorthand.
       @method create
      @static
      @param [arguments]*
    */
    create: function () {
      for (var _len3 = arguments.length, args = Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
        args[_key3] = arguments[_key3];
      }

      var C = this;
      if (args.length > 0) {
        this._initProperties(args);
      }
      return new C();
    },

    /**
      Augments a constructor's prototype with additional
      properties and functions:
       ```javascript
      MyObject = Ember.Object.extend({
        name: 'an object'
      });
       o = MyObject.create();
      o.get('name'); // 'an object'
       MyObject.reopen({
        say: function(msg){
          console.log(msg);
        }
      })
       o2 = MyObject.create();
      o2.say("hello"); // logs "hello"
       o.say("goodbye"); // logs "goodbye"
      ```
       To add functions and properties to the constructor itself,
      see `reopenClass`
       @method reopen
    */
    reopen: function () {
      this.willReopen();
      reopen.apply(this.PrototypeMixin, arguments);
      return this;
    },

    /**
      Augments a constructor's own properties and functions:
       ```javascript
      MyObject = Ember.Object.extend({
        name: 'an object'
      });
       MyObject.reopenClass({
        canBuild: false
      });
       MyObject.canBuild; // false
      o = MyObject.create();
      ```
       In other words, this creates static properties and functions for the class. These are only available on the class
      and not on any instance of that class.
       ```javascript
      App.Person = Ember.Object.extend({
        name : "",
        sayHello : function() {
          alert("Hello. My name is " + this.get('name'));
        }
      });
       App.Person.reopenClass({
        species : "Homo sapiens",
        createPerson: function(newPersonsName){
          return App.Person.create({
            name:newPersonsName
          });
        }
      });
       var tom = App.Person.create({
        name : "Tom Dale"
      });
      var yehuda = App.Person.createPerson("Yehuda Katz");
       tom.sayHello(); // "Hello. My name is Tom Dale"
      yehuda.sayHello(); // "Hello. My name is Yehuda Katz"
      alert(App.Person.species); // "Homo sapiens"
      ```
       Note that `species` and `createPerson` are *not* valid on the `tom` and `yehuda`
      variables. They are only valid on `App.Person`.
       To add functions and properties to instances of
      a constructor by extending the constructor's prototype
      see `reopen`
       @method reopenClass
    */
    reopenClass: function () {
      reopen.apply(this.ClassMixin, arguments);
      applyMixin(this, arguments, false);
      return this;
    },

    detect: function (obj) {
      if ("function" !== typeof obj) {
        return false;
      }
      while (obj) {
        if (obj === this) {
          return true;
        }
        obj = obj.superclass;
      }
      return false;
    },

    detectInstance: function (obj) {
      return obj instanceof this;
    },

    /**
      In some cases, you may want to annotate computed properties with additional
      metadata about how they function or what values they operate on. For
      example, computed property functions may close over variables that are then
      no longer available for introspection.
       You can pass a hash of these values to a computed property like this:
       ```javascript
      person: function() {
        var personId = this.get('personId');
        return App.Person.create({ id: personId });
      }.property().meta({ type: App.Person })
      ```
       Once you've done this, you can retrieve the values saved to the computed
      property from your class like this:
       ```javascript
      MyClass.metaForProperty('person');
      ```
       This will return the original hash that was passed to `meta()`.
       @static
      @method metaForProperty
      @param key {String} property name
    */
    metaForProperty: function (key) {
      var proto = this.proto();
      var possibleDesc = proto[key];
      var desc = possibleDesc !== null && typeof possibleDesc === "object" && possibleDesc.isDescriptor ? possibleDesc : undefined;

            return desc._meta || {};
    },

    _computedProperties: computed.computed(function () {
      hasCachedComputedProperties = true;
      var proto = this.proto();
      var property;
      var properties = [];

      for (var name in proto) {
        property = proto[name];

        if (property instanceof computed.ComputedProperty) {
          properties.push({
            name: name,
            meta: property._meta
          });
        }
      }
      return properties;
    }).readOnly(),

    /**
      Iterate over each computed property for the class, passing its name
      and any associated metadata (see `metaForProperty`) to the callback.
       @static
      @method eachComputedProperty
      @param {Function} callback
      @param {Object} binding
    */
    eachComputedProperty: function (callback, binding) {
      var property, name;
      var empty = {};

      var properties = property_get.get(this, "_computedProperties");

      for (var i = 0, length = properties.length; i < length; i++) {
        property = properties[i];
        name = property.name;
        callback.call(binding || this, property.name, property.meta || empty);
      }
    }
  };

  function injectedPropertyAssertion() {
      }

  
  /**
    Returns a hash of property names and container names that injected
    properties will lookup on the container lazily.

    @method _lazyInjections
    @return {Object} Hash of all lazy injected property keys to container names
  */
  ClassMixinProps._lazyInjections = function () {
    var injections = {};
    var proto = this.proto();
    var key, desc;

    for (key in proto) {
      desc = proto[key];
      if (desc instanceof InjectedProperty['default']) {
        injections[key] = desc.type + ":" + (desc.name || key);
      }
    }

    return injections;
  };

  var ClassMixin = mixin.Mixin.create(ClassMixinProps);

  ClassMixin.ownerConstructor = CoreObject;

  CoreObject.ClassMixin = ClassMixin;

  ClassMixin.apply(CoreObject);

  CoreObject.reopen({
    didDefineProperty: function (proto, key, value) {
      if (hasCachedComputedProperties === false) {
        return;
      }
      if (value instanceof Ember['default'].ComputedProperty) {
        var cache = Ember['default'].meta(this.constructor).cache;

        if (cache && cache._computedProperties !== undefined) {
          cache._computedProperties = undefined;
        }
      }
    }
  });

  exports['default'] = CoreObject;

});
enifed('ember-runtime/system/deferred', ['exports', 'ember-metal/core', 'ember-runtime/mixins/deferred', 'ember-runtime/system/object'], function (exports, Ember, DeferredMixin, EmberObject) {

  'use strict';

  var Deferred = EmberObject['default'].extend(DeferredMixin['default'], {
    init: function () {
            this._super.apply(this, arguments);
    }
  });

  Deferred.reopenClass({
    promise: function (callback, binding) {
      var deferred = Deferred.create();
      callback.call(binding, deferred);
      return deferred;
    }
  });

  exports['default'] = Deferred;

});
enifed('ember-runtime/system/each_proxy', ['exports', 'ember-metal/core', 'ember-metal/property_get', 'ember-metal/utils', 'ember-metal/enumerable_utils', 'ember-metal/array', 'ember-runtime/mixins/array', 'ember-runtime/system/object', 'ember-metal/computed', 'ember-metal/observer', 'ember-metal/events', 'ember-metal/properties', 'ember-metal/property_events'], function (exports, Ember, property_get, utils, enumerable_utils, array, EmberArray, EmberObject, computed, observer, events, properties, property_events) {

  'use strict';

  /**
  @module ember
  @submodule ember-runtime
  */

  var EachArray = EmberObject['default'].extend(EmberArray['default'], {

    init: function (content, keyName, owner) {
      this._super.apply(this, arguments);
      this._keyName = keyName;
      this._owner = owner;
      this._content = content;
    },

    objectAt: function (idx) {
      var item = this._content.objectAt(idx);
      return item && property_get.get(item, this._keyName);
    },

    length: computed.computed(function () {
      var content = this._content;
      return content ? property_get.get(content, "length") : 0;
    })

  });

  var IS_OBSERVER = /^.+:(before|change)$/;

  function addObserverForContentKey(content, keyName, proxy, idx, loc) {
    var objects = proxy._objects;
    var guid;
    if (!objects) {
      objects = proxy._objects = {};
    }

    while (--loc >= idx) {
      var item = content.objectAt(loc);
      if (item) {
                observer.addBeforeObserver(item, keyName, proxy, "contentKeyWillChange");
        observer.addObserver(item, keyName, proxy, "contentKeyDidChange");

        // keep track of the index each item was found at so we can map
        // it back when the obj changes.
        guid = utils.guidFor(item);
        if (!objects[guid]) {
          objects[guid] = [];
        }

        objects[guid].push(loc);
      }
    }
  }

  function removeObserverForContentKey(content, keyName, proxy, idx, loc) {
    var objects = proxy._objects;
    if (!objects) {
      objects = proxy._objects = {};
    }

    var indices, guid;

    while (--loc >= idx) {
      var item = content.objectAt(loc);
      if (item) {
        observer.removeBeforeObserver(item, keyName, proxy, "contentKeyWillChange");
        observer.removeObserver(item, keyName, proxy, "contentKeyDidChange");

        guid = utils.guidFor(item);
        indices = objects[guid];
        indices[array.indexOf.call(indices, loc)] = null;
      }
    }
  }

  /**
    This is the object instance returned when you get the `@each` property on an
    array. It uses the unknownProperty handler to automatically create
    EachArray instances for property names.
  */
  var EachProxy = EmberObject['default'].extend({

    init: function (content) {
      this._super.apply(this, arguments);
      this._content = content;
      content.addArrayObserver(this);

      // in case someone is already observing some keys make sure they are
      // added
      enumerable_utils.forEach(events.watchedEvents(this), function (eventName) {
        this.didAddListener(eventName);
      }, this);
    },

    /**
      You can directly access mapped properties by simply requesting them.
      The `unknownProperty` handler will generate an EachArray of each item.
       @method unknownProperty
      @param keyName {String}
      @param value {*}
    */
    unknownProperty: function (keyName, value) {
      var ret = new EachArray(this._content, keyName, this);
      properties.defineProperty(this, keyName, null, ret);
      this.beginObservingContentKey(keyName);
      return ret;
    },

    // ..........................................................
    // ARRAY CHANGES
    // Invokes whenever the content array itself changes.

    arrayWillChange: function (content, idx, removedCnt, addedCnt) {
      var keys = this._keys;
      var key, lim;

      lim = removedCnt > 0 ? idx + removedCnt : -1;
      property_events.beginPropertyChanges(this);

      for (key in keys) {
        if (!keys.hasOwnProperty(key)) {
          continue;
        }

        if (lim > 0) {
          removeObserverForContentKey(content, key, this, idx, lim);
        }

        property_events.propertyWillChange(this, key);
      }

      property_events.propertyWillChange(this._content, "@each");
      property_events.endPropertyChanges(this);
    },

    arrayDidChange: function (content, idx, removedCnt, addedCnt) {
      var keys = this._keys;
      var lim;

      lim = addedCnt > 0 ? idx + addedCnt : -1;
      property_events.changeProperties(function () {
        for (var key in keys) {
          if (!keys.hasOwnProperty(key)) {
            continue;
          }

          if (lim > 0) {
            addObserverForContentKey(content, key, this, idx, lim);
          }

          property_events.propertyDidChange(this, key);
        }

        property_events.propertyDidChange(this._content, "@each");
      }, this);
    },

    // ..........................................................
    // LISTEN FOR NEW OBSERVERS AND OTHER EVENT LISTENERS
    // Start monitoring keys based on who is listening...

    didAddListener: function (eventName) {
      if (IS_OBSERVER.test(eventName)) {
        this.beginObservingContentKey(eventName.slice(0, -7));
      }
    },

    didRemoveListener: function (eventName) {
      if (IS_OBSERVER.test(eventName)) {
        this.stopObservingContentKey(eventName.slice(0, -7));
      }
    },

    // ..........................................................
    // CONTENT KEY OBSERVING
    // Actual watch keys on the source content.

    beginObservingContentKey: function (keyName) {
      var keys = this._keys;
      if (!keys) {
        keys = this._keys = {};
      }

      if (!keys[keyName]) {
        keys[keyName] = 1;
        var content = this._content;
        var len = property_get.get(content, "length");

        addObserverForContentKey(content, keyName, this, 0, len);
      } else {
        keys[keyName]++;
      }
    },

    stopObservingContentKey: function (keyName) {
      var keys = this._keys;
      if (keys && keys[keyName] > 0 && --keys[keyName] <= 0) {
        var content = this._content;
        var len = property_get.get(content, "length");

        removeObserverForContentKey(content, keyName, this, 0, len);
      }
    },

    contentKeyWillChange: function (obj, keyName) {
      property_events.propertyWillChange(this, keyName);
    },

    contentKeyDidChange: function (obj, keyName) {
      property_events.propertyDidChange(this, keyName);
    }
  });

  exports.EachArray = EachArray;
  exports.EachProxy = EachProxy;

});
enifed('ember-runtime/system/lazy_load', ['exports', 'ember-metal/core', 'ember-metal/array', 'ember-runtime/system/native_array'], function (exports, Ember, array) {

  'use strict';

  exports.onLoad = onLoad;
  exports.runLoadHooks = runLoadHooks;

  /**
    Detects when a specific package of Ember (e.g. 'Ember.Handlebars')
    has fully loaded and is available for extension.

    The provided `callback` will be called with the `name` passed
    resolved from a string into the object:

    ``` javascript
    Ember.onLoad('Ember.Handlebars' function(hbars) {
      hbars.registerHelper(...);
    });
    ```

    @method onLoad
    @for Ember
    @param name {String} name of hook
    @param callback {Function} callback to be called
  */
  var loadHooks = Ember['default'].ENV.EMBER_LOAD_HOOKS || {};
  var loaded = {};
  function onLoad(name, callback) {
    var object;

    loadHooks[name] = loadHooks[name] || Ember['default'].A();
    loadHooks[name].pushObject(callback);

    if (object = loaded[name]) {
      callback(object);
    }
  }

  function runLoadHooks(name, object) {
    loaded[name] = object;

    if (typeof window === "object" && typeof window.dispatchEvent === "function" && typeof CustomEvent === "function") {
      var event = new CustomEvent(name, { detail: object, name: name });
      window.dispatchEvent(event);
    }

    if (loadHooks[name]) {
      array.forEach.call(loadHooks[name], function (callback) {
        callback(object);
      });
    }
  }

});
enifed('ember-runtime/system/namespace', ['exports', 'ember-metal/core', 'ember-metal/property_get', 'ember-metal/array', 'ember-metal/utils', 'ember-metal/mixin', 'ember-runtime/system/object'], function (exports, Ember, property_get, array, utils, ember_metal__mixin, EmberObject) {

  'use strict';

  /**
  @module ember
  @submodule ember-runtime
  */

  // Ember.lookup, Ember.BOOTED, Ember.deprecate, Ember.NAME_KEY, Ember.anyUnprocessedMixins
  var Namespace = EmberObject['default'].extend({
    isNamespace: true,

    init: function () {
      Namespace.NAMESPACES.push(this);
      Namespace.PROCESSED = false;
    },

    toString: function () {
      var name = property_get.get(this, "name") || property_get.get(this, "modulePrefix");
      if (name) {
        return name;
      }

      findNamespaces();
      return this[NAME_KEY];
    },

    nameClasses: function () {
      processNamespace([this.toString()], this, {});
    },

    destroy: function () {
      var namespaces = Namespace.NAMESPACES;
      var toString = this.toString();

      if (toString) {
        Ember['default'].lookup[toString] = undefined;
        delete Namespace.NAMESPACES_BY_ID[toString];
      }
      namespaces.splice(array.indexOf.call(namespaces, this), 1);
      this._super.apply(this, arguments);
    }
  });

  Namespace.reopenClass({
    NAMESPACES: [Ember['default']],
    NAMESPACES_BY_ID: {},
    PROCESSED: false,
    processAll: processAllNamespaces,
    byName: function (name) {
      if (!Ember['default'].BOOTED) {
        processAllNamespaces();
      }

      return NAMESPACES_BY_ID[name];
    }
  });

  var NAMESPACES_BY_ID = Namespace.NAMESPACES_BY_ID;

  var hasOwnProp = ({}).hasOwnProperty;

  function processNamespace(paths, root, seen) {
    var idx = paths.length;

    NAMESPACES_BY_ID[paths.join(".")] = root;

    // Loop over all of the keys in the namespace, looking for classes
    for (var key in root) {
      if (!hasOwnProp.call(root, key)) {
        continue;
      }
      var obj = root[key];

      // If we are processing the `Ember` namespace, for example, the
      // `paths` will start with `["Ember"]`. Every iteration through
      // the loop will update the **second** element of this list with
      // the key, so processing `Ember.View` will make the Array
      // `['Ember', 'View']`.
      paths[idx] = key;

      // If we have found an unprocessed class
      if (obj && obj.toString === classToString) {
        // Replace the class' `toString` with the dot-separated path
        // and set its `NAME_KEY`
        obj.toString = makeToString(paths.join("."));
        obj[NAME_KEY] = paths.join(".");

        // Support nested namespaces
      } else if (obj && obj.isNamespace) {
        // Skip aliased namespaces
        if (seen[utils.guidFor(obj)]) {
          continue;
        }
        seen[utils.guidFor(obj)] = true;

        // Process the child namespace
        processNamespace(paths, obj, seen);
      }
    }

    paths.length = idx; // cut out last item
  }

  var STARTS_WITH_UPPERCASE = /^[A-Z]/;

  function tryIsNamespace(lookup, prop) {
    try {
      var obj = lookup[prop];
      return obj && obj.isNamespace && obj;
    } catch (e) {}
  }

  function findNamespaces() {
    var lookup = Ember['default'].lookup;
    var obj;

    if (Namespace.PROCESSED) {
      return;
    }

    for (var prop in lookup) {
      // Only process entities that start with uppercase A-Z
      if (!STARTS_WITH_UPPERCASE.test(prop)) {
        continue;
      }

      // Unfortunately, some versions of IE don't support window.hasOwnProperty
      if (lookup.hasOwnProperty && !lookup.hasOwnProperty(prop)) {
        continue;
      }

      // At times we are not allowed to access certain properties for security reasons.
      // There are also times where even if we can access them, we are not allowed to access their properties.
      obj = tryIsNamespace(lookup, prop);
      if (obj) {
        obj[NAME_KEY] = prop;
      }
    }
  }

  var NAME_KEY = Ember['default'].NAME_KEY = utils.GUID_KEY + "_name";

  function superClassString(mixin) {
    var superclass = mixin.superclass;
    if (superclass) {
      if (superclass[NAME_KEY]) {
        return superclass[NAME_KEY];
      } else {
        return superClassString(superclass);
      }
    } else {
      return;
    }
  }

  function classToString() {
    if (!Ember['default'].BOOTED && !this[NAME_KEY]) {
      processAllNamespaces();
    }

    var ret;

    if (this[NAME_KEY]) {
      ret = this[NAME_KEY];
    } else if (this._toString) {
      ret = this._toString;
    } else {
      var str = superClassString(this);
      if (str) {
        ret = "(subclass of " + str + ")";
      } else {
        ret = "(unknown mixin)";
      }
      this.toString = makeToString(ret);
    }

    return ret;
  }

  function processAllNamespaces() {
    var unprocessedNamespaces = !Namespace.PROCESSED;
    var unprocessedMixins = Ember['default'].anyUnprocessedMixins;

    if (unprocessedNamespaces) {
      findNamespaces();
      Namespace.PROCESSED = true;
    }

    if (unprocessedNamespaces || unprocessedMixins) {
      var namespaces = Namespace.NAMESPACES;
      var namespace;

      for (var i = 0, l = namespaces.length; i < l; i++) {
        namespace = namespaces[i];
        processNamespace([namespace.toString()], namespace, {});
      }

      Ember['default'].anyUnprocessedMixins = false;
    }
  }

  function makeToString(ret) {
    return function () {
      return ret;
    };
  }

  ember_metal__mixin.Mixin.prototype.toString = classToString; // ES6TODO: altering imported objects. SBB.

  exports['default'] = Namespace;

  // continue

});
enifed('ember-runtime/system/native_array', ['exports', 'ember-metal/core', 'ember-metal/property_get', 'ember-metal/enumerable_utils', 'ember-metal/mixin', 'ember-metal/array', 'ember-runtime/mixins/array', 'ember-runtime/mixins/mutable_array', 'ember-runtime/mixins/observable', 'ember-runtime/mixins/copyable', 'ember-runtime/mixins/freezable', 'ember-runtime/copy'], function (exports, Ember, property_get, enumerable_utils, mixin, array, EmberArray, MutableArray, Observable, Copyable, freezable, copy) {

  'use strict';

  /**
  @module ember
  @submodule ember-runtime
  */

  var NativeArray = mixin.Mixin.create(MutableArray['default'], Observable['default'], Copyable['default'], {

    // because length is a built-in property we need to know to just get the
    // original property.
    get: function (key) {
      if (key === "length") {
        return this.length;
      } else if ("number" === typeof key) {
        return this[key];
      } else {
        return this._super(key);
      }
    },

    objectAt: function (idx) {
      return this[idx];
    },

    // primitive for array support.
    replace: function (idx, amt, objects) {

      if (this.isFrozen) {
        throw freezable.FROZEN_ERROR;
      }

      // if we replaced exactly the same number of items, then pass only the
      // replaced range. Otherwise, pass the full remaining array length
      // since everything has shifted
      var len = objects ? property_get.get(objects, "length") : 0;
      this.arrayContentWillChange(idx, amt, len);

      if (len === 0) {
        this.splice(idx, amt);
      } else {
        enumerable_utils._replace(this, idx, amt, objects);
      }

      this.arrayContentDidChange(idx, amt, len);
      return this;
    },

    // If you ask for an unknown property, then try to collect the value
    // from member items.
    unknownProperty: function (key, value) {
      var ret; // = this.reducedProperty(key, value);
      if (value !== undefined && ret === undefined) {
        ret = this[key] = value;
      }
      return ret;
    },

    indexOf: array.indexOf,

    lastIndexOf: array.lastIndexOf,

    copy: function (deep) {
      if (deep) {
        return this.map(function (item) {
          return copy['default'](item, true);
        });
      }

      return this.slice();
    }
  });

  // Remove any methods implemented natively so we don't override them
  var ignore = ["length"];
  enumerable_utils.forEach(NativeArray.keys(), function (methodName) {
    if (Array.prototype[methodName]) {
      ignore.push(methodName);
    }
  });

  NativeArray = NativeArray.without.apply(NativeArray, ignore);

  /**
    Creates an `Ember.NativeArray` from an Array like object.
    Does not modify the original object. Ember.A is not needed if
    `Ember.EXTEND_PROTOTYPES` is `true` (the default value). However,
    it is recommended that you use Ember.A when creating addons for
    ember or when you can not guarantee that `Ember.EXTEND_PROTOTYPES`
    will be `true`.

    Example

    ```js
    var Pagination = Ember.CollectionView.extend({
      tagName: 'ul',
      classNames: ['pagination'],

      init: function() {
        this._super.apply(this, arguments);
        if (!this.get('content')) {
          this.set('content', Ember.A());
        }
      }
    });
    ```

    @method A
    @for Ember
    @return {Ember.NativeArray}
  */
  var A = function (arr) {
    if (arr === undefined) {
      arr = [];
    }
    return EmberArray['default'].detect(arr) ? arr : NativeArray.apply(arr);
  };

  /**
    Activates the mixin on the Array.prototype if not already applied. Calling
    this method more than once is safe. This will be called when ember is loaded
    unless you have `Ember.EXTEND_PROTOTYPES` or `Ember.EXTEND_PROTOTYPES.Array`
    set to `false`.

    Example

    ```js
    if (Ember.EXTEND_PROTOTYPES === true || Ember.EXTEND_PROTOTYPES.Array) {
      Ember.NativeArray.activate();
    }
    ```

    @method activate
    @for Ember.NativeArray
    @static
    @return {void}
  */
  NativeArray.activate = function () {
    NativeArray.apply(Array.prototype);

    exports.A = A = function (arr) {
      return arr || [];
    };
  };

  if (Ember['default'].EXTEND_PROTOTYPES === true || Ember['default'].EXTEND_PROTOTYPES.Array) {
    NativeArray.activate();
  }

  Ember['default'].A = A; // ES6TODO: Setting A onto the object returned by ember-metal/core to avoid circles
  exports['default'] = NativeArray;

  exports.A = A;
  exports.NativeArray = NativeArray;

});
enifed('ember-runtime/system/object', ['exports', 'ember-runtime/system/core_object', 'ember-runtime/mixins/observable'], function (exports, CoreObject, Observable) {

  'use strict';

  /**
  @module ember
  @submodule ember-runtime
  */

  var EmberObject = CoreObject['default'].extend(Observable['default']);
  EmberObject.toString = function () {
    return "Ember.Object";
  };

  exports['default'] = EmberObject;

});
enifed('ember-runtime/system/object_proxy', ['exports', 'ember-runtime/system/object', 'ember-runtime/mixins/-proxy'], function (exports, EmberObject, _ProxyMixin) {

  'use strict';

  exports['default'] = EmberObject['default'].extend(_ProxyMixin['default']);

});
enifed('ember-runtime/system/service', ['exports', 'ember-runtime/system/object', 'ember-runtime/inject'], function (exports, Object, inject) {

  'use strict';

  inject.createInjectionHelper('service');

  /**
    @class Service
    @namespace Ember
    @extends Ember.Object
    @since 1.10.0
  */
  exports['default'] = Object['default'].extend();

});
enifed('ember-runtime/system/set', ['exports', 'ember-metal/core', 'ember-metal/property_get', 'ember-metal/property_set', 'ember-metal/utils', 'ember-metal/is_none', 'ember-runtime/system/string', 'ember-runtime/system/core_object', 'ember-runtime/mixins/mutable_enumerable', 'ember-runtime/mixins/enumerable', 'ember-runtime/mixins/copyable', 'ember-runtime/mixins/freezable', 'ember-metal/error', 'ember-metal/property_events', 'ember-metal/mixin', 'ember-metal/computed'], function (exports, Ember, property_get, property_set, utils, isNone, string, CoreObject, MutableEnumerable, Enumerable, Copyable, freezable, EmberError, property_events, mixin, computed) {

  'use strict';

  /**
  @module ember
  @submodule ember-runtime
  */
  exports['default'] = CoreObject['default'].extend(MutableEnumerable['default'], Copyable['default'], freezable.Freezable, {

    // ..........................................................
    // IMPLEMENT ENUMERABLE APIS
    //

    /**
      This property will change as the number of objects in the set changes.
       @property length
      @type number
      @default 0
    */
    length: 0,

    /**
      Clears the set. This is useful if you want to reuse an existing set
      without having to recreate it.
       ```javascript
      var colors = new Ember.Set(["red", "green", "blue"]);
      colors.length;  // 3
      colors.clear();
      colors.length;  // 0
      ```
       @method clear
      @return {Ember.Set} An empty Set
    */
    clear: function () {
      if (this.isFrozen) {
        throw new EmberError['default'](freezable.FROZEN_ERROR);
      }

      var len = property_get.get(this, "length");
      if (len === 0) {
        return this;
      }

      var guid;

      this.enumerableContentWillChange(len, 0);
      property_events.propertyWillChange(this, "firstObject");
      property_events.propertyWillChange(this, "lastObject");

      for (var i = 0; i < len; i++) {
        guid = utils.guidFor(this[i]);
        delete this[guid];
        delete this[i];
      }

      property_set.set(this, "length", 0);

      property_events.propertyDidChange(this, "firstObject");
      property_events.propertyDidChange(this, "lastObject");
      this.enumerableContentDidChange(len, 0);

      return this;
    },

    /**
      Returns true if the passed object is also an enumerable that contains the
      same objects as the receiver.
       ```javascript
      var colors = ["red", "green", "blue"],
          same_colors = new Ember.Set(colors);
       same_colors.isEqual(colors);               // true
      same_colors.isEqual(["purple", "brown"]);  // false
      ```
       @method isEqual
      @param {Ember.Set} obj the other object.
      @return {Boolean}
    */
    isEqual: function (obj) {
      // fail fast
      if (!Enumerable['default'].detect(obj)) {
        return false;
      }

      var loc = property_get.get(this, "length");
      if (property_get.get(obj, "length") !== loc) {
        return false;
      }

      while (--loc >= 0) {
        if (!obj.contains(this[loc])) {
          return false;
        }
      }

      return true;
    },

    /**
      Adds an object to the set. Only non-`null` objects can be added to a set
      and those can only be added once. If the object is already in the set or
      the passed value is null this method will have no effect.
       This is an alias for `Ember.MutableEnumerable.addObject()`.
       ```javascript
      var colors = new Ember.Set();
      colors.add("blue");     // ["blue"]
      colors.add("blue");     // ["blue"]
      colors.add("red");      // ["blue", "red"]
      colors.add(null);       // ["blue", "red"]
      colors.add(undefined);  // ["blue", "red"]
      ```
       @method add
      @param {Object} obj The object to add.
      @return {Ember.Set} The set itself.
    */
    add: mixin.aliasMethod("addObject"),

    /**
      Removes the object from the set if it is found. If you pass a `null` value
      or an object that is already not in the set, this method will have no
      effect. This is an alias for `Ember.MutableEnumerable.removeObject()`.
       ```javascript
      var colors = new Ember.Set(["red", "green", "blue"]);
      colors.remove("red");     // ["blue", "green"]
      colors.remove("purple");  // ["blue", "green"]
      colors.remove(null);      // ["blue", "green"]
      ```
       @method remove
      @param {Object} obj The object to remove
      @return {Ember.Set} The set itself.
    */
    remove: mixin.aliasMethod("removeObject"),

    /**
      Removes the last element from the set and returns it, or `null` if it's empty.
       ```javascript
      var colors = new Ember.Set(["green", "blue"]);
      colors.pop();  // "blue"
      colors.pop();  // "green"
      colors.pop();  // null
      ```
       @method pop
      @return {Object} The removed object from the set or null.
    */
    pop: function () {
      if (property_get.get(this, "isFrozen")) {
        throw new EmberError['default'](freezable.FROZEN_ERROR);
      }

      var obj = this.length > 0 ? this[this.length - 1] : null;
      this.remove(obj);
      return obj;
    },

    /**
      Inserts the given object on to the end of the set. It returns
      the set itself.
       This is an alias for `Ember.MutableEnumerable.addObject()`.
       ```javascript
      var colors = new Ember.Set();
      colors.push("red");   // ["red"]
      colors.push("green"); // ["red", "green"]
      colors.push("blue");  // ["red", "green", "blue"]
      ```
       @method push
      @return {Ember.Set} The set itself.
    */
    push: mixin.aliasMethod("addObject"),

    /**
      Removes the last element from the set and returns it, or `null` if it's empty.
       This is an alias for `Ember.Set.pop()`.
       ```javascript
      var colors = new Ember.Set(["green", "blue"]);
      colors.shift();  // "blue"
      colors.shift();  // "green"
      colors.shift();  // null
      ```
       @method shift
      @return {Object} The removed object from the set or null.
    */
    shift: mixin.aliasMethod("pop"),

    /**
      Inserts the given object on to the end of the set. It returns
      the set itself.
       This is an alias of `Ember.Set.push()`
       ```javascript
      var colors = new Ember.Set();
      colors.unshift("red");    // ["red"]
      colors.unshift("green");  // ["red", "green"]
      colors.unshift("blue");   // ["red", "green", "blue"]
      ```
       @method unshift
      @return {Ember.Set} The set itself.
    */
    unshift: mixin.aliasMethod("push"),

    /**
      Adds each object in the passed enumerable to the set.
       This is an alias of `Ember.MutableEnumerable.addObjects()`
       ```javascript
      var colors = new Ember.Set();
      colors.addEach(["red", "green", "blue"]);  // ["red", "green", "blue"]
      ```
       @method addEach
      @param {Ember.Enumerable} objects the objects to add.
      @return {Ember.Set} The set itself.
    */
    addEach: mixin.aliasMethod("addObjects"),

    /**
      Removes each object in the passed enumerable to the set.
       This is an alias of `Ember.MutableEnumerable.removeObjects()`
       ```javascript
      var colors = new Ember.Set(["red", "green", "blue"]);
      colors.removeEach(["red", "blue"]);  //  ["green"]
      ```
       @method removeEach
      @param {Ember.Enumerable} objects the objects to remove.
      @return {Ember.Set} The set itself.
    */
    removeEach: mixin.aliasMethod("removeObjects"),

    // ..........................................................
    // PRIVATE ENUMERABLE SUPPORT
    //

    init: function (items) {
            this._super.apply(this, arguments);

      if (items) {
        this.addObjects(items);
      }
    },

    // implement Ember.Enumerable
    nextObject: function (idx) {
      return this[idx];
    },

    // more optimized version
    firstObject: computed.computed(function () {
      return this.length > 0 ? this[0] : undefined;
    }),

    // more optimized version
    lastObject: computed.computed(function () {
      return this.length > 0 ? this[this.length - 1] : undefined;
    }),

    // implements Ember.MutableEnumerable
    addObject: function (obj) {
      if (property_get.get(this, "isFrozen")) {
        throw new EmberError['default'](freezable.FROZEN_ERROR);
      }

      if (isNone['default'](obj)) {
        return this; // nothing to do
      }

      var guid = utils.guidFor(obj);
      var idx = this[guid];
      var len = property_get.get(this, "length");
      var added;

      if (idx >= 0 && idx < len && this[idx] === obj) {
        return this; // added
      }

      added = [obj];

      this.enumerableContentWillChange(null, added);
      property_events.propertyWillChange(this, "lastObject");

      len = property_get.get(this, "length");
      this[guid] = len;
      this[len] = obj;
      property_set.set(this, "length", len + 1);

      property_events.propertyDidChange(this, "lastObject");
      this.enumerableContentDidChange(null, added);

      return this;
    },

    // implements Ember.MutableEnumerable
    removeObject: function (obj) {
      if (property_get.get(this, "isFrozen")) {
        throw new EmberError['default'](freezable.FROZEN_ERROR);
      }

      if (isNone['default'](obj)) {
        return this; // nothing to do
      }

      var guid = utils.guidFor(obj);
      var idx = this[guid];
      var len = property_get.get(this, "length");
      var isFirst = idx === 0;
      var isLast = idx === len - 1;
      var last, removed;

      if (idx >= 0 && idx < len && this[idx] === obj) {
        removed = [obj];

        this.enumerableContentWillChange(removed, null);
        if (isFirst) {
          property_events.propertyWillChange(this, "firstObject");
        }
        if (isLast) {
          property_events.propertyWillChange(this, "lastObject");
        }

        // swap items - basically move the item to the end so it can be removed
        if (idx < len - 1) {
          last = this[len - 1];
          this[idx] = last;
          this[utils.guidFor(last)] = idx;
        }

        delete this[guid];
        delete this[len - 1];
        property_set.set(this, "length", len - 1);

        if (isFirst) {
          property_events.propertyDidChange(this, "firstObject");
        }
        if (isLast) {
          property_events.propertyDidChange(this, "lastObject");
        }
        this.enumerableContentDidChange(removed, null);
      }

      return this;
    },

    // optimized version
    contains: function (obj) {
      return this[utils.guidFor(obj)] >= 0;
    },

    copy: function () {
      var C = this.constructor;
      var ret = new C();
      var loc = property_get.get(this, "length");

      property_set.set(ret, "length", loc);
      while (--loc >= 0) {
        ret[loc] = this[loc];
        ret[utils.guidFor(this[loc])] = loc;
      }
      return ret;
    },

    toString: function () {
      var len = this.length;
      var array = [];
      var idx;

      for (idx = 0; idx < len; idx++) {
        array[idx] = this[idx];
      }
      return string.fmt("Ember.Set<%@>", [array.join(",")]);
    }
  });

});
enifed('ember-runtime/system/string', ['exports', 'ember-metal/core', 'ember-metal/utils', 'ember-metal/cache'], function (exports, Ember, utils, Cache) {

  'use strict';

  exports.fmt = fmt;
  exports.loc = loc;
  exports.w = w;
  exports.decamelize = decamelize;
  exports.dasherize = dasherize;
  exports.camelize = camelize;
  exports.classify = classify;
  exports.underscore = underscore;
  exports.capitalize = capitalize;

  /**
  @module ember
  @submodule ember-runtime
  */
  var STRING_DASHERIZE_REGEXP = /[ _]/g;

  var STRING_DASHERIZE_CACHE = new Cache['default'](1000, function (key) {
    return decamelize(key).replace(STRING_DASHERIZE_REGEXP, "-");
  });

  var CAMELIZE_CACHE = new Cache['default'](1000, function (key) {
    return key.replace(STRING_CAMELIZE_REGEXP, function (match, separator, chr) {
      return chr ? chr.toUpperCase() : "";
    }).replace(/^([A-Z])/, function (match, separator, chr) {
      return match.toLowerCase();
    });
  });

  var CLASSIFY_CACHE = new Cache['default'](1000, function (str) {
    var parts = str.split(".");
    var out = [];

    for (var i = 0, l = parts.length; i < l; i++) {
      var camelized = camelize(parts[i]);
      out.push(camelized.charAt(0).toUpperCase() + camelized.substr(1));
    }

    return out.join(".");
  });

  var UNDERSCORE_CACHE = new Cache['default'](1000, function (str) {
    return str.replace(STRING_UNDERSCORE_REGEXP_1, "$1_$2").replace(STRING_UNDERSCORE_REGEXP_2, "_").toLowerCase();
  });

  var CAPITALIZE_CACHE = new Cache['default'](1000, function (str) {
    return str.charAt(0).toUpperCase() + str.substr(1);
  });

  var DECAMELIZE_CACHE = new Cache['default'](1000, function (str) {
    return str.replace(STRING_DECAMELIZE_REGEXP, "$1_$2").toLowerCase();
  });

  var STRING_DECAMELIZE_REGEXP = /([a-z\d])([A-Z])/g;
  var STRING_CAMELIZE_REGEXP = /(\-|_|\.|\s)+(.)?/g;
  var STRING_UNDERSCORE_REGEXP_1 = /([a-z\d])([A-Z]+)/g;
  var STRING_UNDERSCORE_REGEXP_2 = /\-|\s+/g;

  function fmt(str, formats) {
    var cachedFormats = formats;

    if (!utils.isArray(cachedFormats) || arguments.length > 2) {
      cachedFormats = new Array(arguments.length - 1);

      for (var i = 1, l = arguments.length; i < l; i++) {
        cachedFormats[i - 1] = arguments[i];
      }
    }

    // first, replace any ORDERED replacements.
    var idx = 0; // the current index for non-numerical replacements
    return str.replace(/%@([0-9]+)?/g, function (s, argIndex) {
      argIndex = argIndex ? parseInt(argIndex, 10) - 1 : idx++;
      s = cachedFormats[argIndex];
      return s === null ? "(null)" : s === undefined ? "" : utils.inspect(s);
    });
  }

  function loc(str, formats) {
    if (!utils.isArray(formats) || arguments.length > 2) {
      formats = Array.prototype.slice.call(arguments, 1);
    }

    str = Ember['default'].STRINGS[str] || str;
    return fmt(str, formats);
  }

  function w(str) {
    return str.split(/\s+/);
  }

  function decamelize(str) {
    return DECAMELIZE_CACHE.get(str);
  }

  function dasherize(str) {
    return STRING_DASHERIZE_CACHE.get(str);
  }

  function camelize(str) {
    return CAMELIZE_CACHE.get(str);
  }

  function classify(str) {
    return CLASSIFY_CACHE.get(str);
  }

  function underscore(str) {
    return UNDERSCORE_CACHE.get(str);
  }

  function capitalize(str) {
    return CAPITALIZE_CACHE.get(str);
  }

  /**
    Defines the hash of localized strings for the current language. Used by
    the `Ember.String.loc()` helper. To localize, add string values to this
    hash.

    @property STRINGS
    @for Ember
    @type Hash
  */
  Ember['default'].STRINGS = {};

  /**
    Defines string helper methods including string formatting and localization.
    Unless `Ember.EXTEND_PROTOTYPES.String` is `false` these methods will also be
    added to the `String.prototype` as well.

    @class String
    @namespace Ember
    @static
  */
  exports['default'] = {
    /**
      Apply formatting options to the string. This will look for occurrences
      of "%@" in your string and substitute them with the arguments you pass into
      this method. If you want to control the specific order of replacement,
      you can add a number after the key as well to indicate which argument
      you want to insert.
       Ordered insertions are most useful when building loc strings where values
      you need to insert may appear in different orders.
       ```javascript
      "Hello %@ %@".fmt('John', 'Doe');     // "Hello John Doe"
      "Hello %@2, %@1".fmt('John', 'Doe');  // "Hello Doe, John"
      ```
       @method fmt
      @param {String} str The string to format
      @param {Array} formats An array of parameters to interpolate into string.
      @return {String} formatted string
    */
    fmt: fmt,

    /**
      Formats the passed string, but first looks up the string in the localized
      strings hash. This is a convenient way to localize text. See
      `Ember.String.fmt()` for more information on formatting.
       Note that it is traditional but not required to prefix localized string
      keys with an underscore or other character so you can easily identify
      localized strings.
       ```javascript
      Ember.STRINGS = {
        '_Hello World': 'Bonjour le monde',
        '_Hello %@ %@': 'Bonjour %@ %@'
      };
       Ember.String.loc("_Hello World");  // 'Bonjour le monde';
      Ember.String.loc("_Hello %@ %@", ["John", "Smith"]);  // "Bonjour John Smith";
      ```
       @method loc
      @param {String} str The string to format
      @param {Array} formats Optional array of parameters to interpolate into string.
      @return {String} formatted string
    */
    loc: loc,

    /**
      Splits a string into separate units separated by spaces, eliminating any
      empty strings in the process. This is a convenience method for split that
      is mostly useful when applied to the `String.prototype`.
       ```javascript
      Ember.String.w("alpha beta gamma").forEach(function(key) {
        console.log(key);
      });
       // > alpha
      // > beta
      // > gamma
      ```
       @method w
      @param {String} str The string to split
      @return {Array} array containing the split strings
    */
    w: w,

    /**
      Converts a camelized string into all lower case separated by underscores.
       ```javascript
      'innerHTML'.decamelize();           // 'inner_html'
      'action_name'.decamelize();        // 'action_name'
      'css-class-name'.decamelize();     // 'css-class-name'
      'my favorite items'.decamelize();  // 'my favorite items'
      ```
       @method decamelize
      @param {String} str The string to decamelize.
      @return {String} the decamelized string.
    */
    decamelize: decamelize,

    /**
      Replaces underscores, spaces, or camelCase with dashes.
       ```javascript
      'innerHTML'.dasherize();          // 'inner-html'
      'action_name'.dasherize();        // 'action-name'
      'css-class-name'.dasherize();     // 'css-class-name'
      'my favorite items'.dasherize();  // 'my-favorite-items'
      ```
       @method dasherize
      @param {String} str The string to dasherize.
      @return {String} the dasherized string.
    */
    dasherize: dasherize,

    /**
      Returns the lowerCamelCase form of a string.
       ```javascript
      'innerHTML'.camelize();          // 'innerHTML'
      'action_name'.camelize();        // 'actionName'
      'css-class-name'.camelize();     // 'cssClassName'
 