Ext.data.JsonP.command_theme({"title":"Building Themes for Ext JS","guide":"<h1>Building Themes for Ext JS</h1>\n<div class='toc'>\n<p><strong>Contents</strong></p>\n<ol>\n<li><a href='#!/guide/command_theme-section-1'>Getting Started</a></li>\n<li><a href='#!/guide/command_theme-section-2'>Multiple Themes</a></li>\n<li><a href='#!/guide/command_theme-section-3'>Building an Application's Themes</a></li>\n<li><a href='#!/guide/command_theme-section-4'>Extracting images for a single theme</a></li>\n<li><a href='#!/guide/command_theme-section-5'>Anatomy of a Theme</a></li>\n<li><a href='#!/guide/command_theme-section-6'>Managing Themes Manually</a></li>\n<li><a href='#!/guide/command_theme-section-7'>Compiling Your Custom Theme</a></li>\n</ol>\n</div>\n\n<p>This guide describes the file-level mechanics of building and managing themes with\nSencha Cmd, which can automate several of the steps required to build a theme. Note\nthat developing themes or managing styles or SASS variables are not covered here -- these\nare part of your application development process.</p>\n\n<p><p><img src=\"guides/command_theme/../command/sencha-command-128.png\" alt=\"\"></p></p>\n\n<h2 id='command_theme-section-1'>Getting Started</h2>\n\n<p>First, in order to build themes from SASS, be sure to install <a href=\"http://compass-style.org/\">Compass</a>\non your system.</p>\n\n<p>Most of this guide assumes you are working in an application generated by Sencha Cmd. If\nthat is not the case, many of these steps will change to reflect different paths and the\nlike. See the section below on \"Managing Themes Manually\".</p>\n\n<p>All applications start with a \"default\" theme. Different pieces are stored in two folders:</p>\n\n<ul>\n<li><code>./resources/theme/default</code></li>\n<li><code>./resources/theme/default/sass</code></li>\n</ul>\n\n\n<h3>Use of SASS</h3>\n\n<p>The majority of your work on themes is done in SASS. The starter files are generated for\nyou, and you edit them to complete your theme. When you compile your SASS, it should generate\na CSS file in <code>\"./.res/default\"</code> named <code>\"app.css\"</code>.</p>\n\n<h2 id='command_theme-section-2'>Multiple Themes</h2>\n\n<p>If you need two or more themes (as described in <a href=\"#/guide/command_app\">Using Sencha Cmd with Ext JS</a>),\nyou can generate new themes with this command:</p>\n\n<pre><code>sencha generate theme foo\n</code></pre>\n\n<p>This will generate the following:</p>\n\n<ul>\n<li><code>./resources/theme/foo/sass</code></li>\n</ul>\n\n\n<p>The SASS should be compiled to <code>\"./.res/foo/app.css\"</code>.</p>\n\n<h2 id='command_theme-section-3'>Building an Application's Themes</h2>\n\n<p>The <code>sencha app build</code> command will produce full image sets for all themes in a given\napplication as part of the standard build process.  To achieve this, images from the\nbase framework theme are first staged into the <code>\"resources/.img/&lt;theme name&gt;\"</code> directory\nunder the application's root directory.  Then, sliced images for each theme are generated\nusing the technique described in the following section and overlaid over the theme images\nprovided by the framework.  Finally, user supplied images located in the application's\n<code>\"resources/images\"</code> directory are overlaid into the output of the theme build operations to\nproduce the final image set.  The resultant application resource directory will have the\nfollowing structure:</p>\n\n<pre><code>resources/              \n    images/             # application-wide image content and theme image overrides\n        ...             \n    theme/              \n        default/         \n            sass/       # sass input files for the default theme\n        ...             \n.res/                    \n    default/             \n        images/         # unified image content generate by build process\n    ...                 \n</code></pre>\n\n<p>All output images are staged into a <code>\".res\"</code> directory under the application's source directory\nto enable development-time viewing of a built theme. This <code>\".res\"</code> directory is then\ncopied to the application's build output folder to maintain relative paths for\ndeployment. As this generated <code>\".res\"</code> directory is generated to a file system location\ncommonly under revision control, it may be desirable to add this directory to the revision\ncontrol system's exclusion mechanism (such as a .gitignore entry).  Doing so should not\nimpact application behavior, as this folder is fully generated by Sencha Cmd and is copied\nto the build  output location during the app build process.</p>\n\n<h2 id='command_theme-section-4'>Extracting images for a single theme</h2>\n\n<p>Typically, your themes will be compiled and built by the <code>sencha app build</code> command, but\nit is sometimes helpful to produce images for a single theme at a time. To compile a theme,\nuse the <code>compass compile</code> command in your SASS directory.</p>\n\n<pre><code>cd /path/to/MyApp/resources/sass/default\ncompass compile\n</code></pre>\n\n<p>This should produce the CSS in <code>\"../../../../.res/default/app.css\"</code> (or from the root of your\napplication folder, <code>\".res/default/app.css\"</code>).</p>\n\n<p>The next step is to build the image slices needed for IE browsers. This is done with the\nfollowing command:</p>\n\n<pre><code>cd /path/to/MyApp\nsencha theme build -out resources/sliced_images/default\n</code></pre>\n\n<p>This will place the sliced images in the <code>\"./.res/default/images\"</code> folder alongside the\nCSS file generated by SASS. If the '-out' parameter is omitted, then sliced images will be placed\nin a 'resources/images/default' directory under the default build output folder for the\napplication. All image paths are relative to the CSS file location to minimize the size\nof the CSS file.</p>\n\n<h2 id='command_theme-section-5'>Anatomy of a Theme</h2>\n\n<p>The <code>theme</code> folder is split in to two levels. For clarity, lets consider a <code>theme</code> folder\nwith two themes:</p>\n\n<pre><code>theme/\n    custom.js\n    manifest.js\n    render.js\n    shortcuts.js\n    default/\n        theme.html\n    gray/\n        theme.html\n</code></pre>\n\n<h3>theme.html</h3>\n\n<p>The <code>\"theme.html\"</code> file is the entry point for the image generation phase of the theme\nbuilder.</p>\n\n<p>You should be able to open this file in Chrome or any other modern browser and see what the\nbase image will be for your theme. This is an ideal page to test your styling because every\ncomponent in every state will be present.</p>\n\n<p>This is an example of what the <code>\"resources/theme/default/theme.html\"</code> file looks like:</p>\n\n<pre><code>&lt;html&gt;\n    &lt;head&gt;\n        &lt;title&gt;&lt;/title&gt;\n        &lt;meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"&gt;\n\n        &lt;link rel=\"stylesheet\" type=\"text/css\" href=\"../../css/default/theme.css\" /&gt;\n        &lt;link rel=\"stylesheet\" type=\"text/css\" href=\"../styles.css\" /&gt;\n\n        &lt;script type=\"text/javascript\" src=\"../../../sdk/ext-all.js\"&gt;&lt;/script&gt;\n        &lt;script type=\"text/javascript\" src=\"../manifest.js\"&gt;&lt;/script&gt;\n        &lt;script type=\"text/javascript\" src=\"../shortcuts.js\"&gt;&lt;/script&gt;\n        &lt;script type=\"text/javascript\" src=\"../custom.js\"&gt;&lt;/script&gt;\n        &lt;script type=\"text/javascript\" src=\"../render.js\"&gt;&lt;/script&gt;\n    &lt;/head&gt;\n    &lt;body class=\"ext-generator\"&gt;\n    &lt;/body&gt;\n&lt;/html&gt;\n</code></pre>\n\n<p>This file is designed to be edited as needed. This file will not be edited or regenerated\nby Sencha Cmd.</p>\n\n<p><strong>Important.</strong> While this file is freely editable, be sure to keep the relative order of\nthe <code>link</code> and <code>script</code> tags. In particular <code>\"custom.js\"</code> must come after <code>\"manifest.js\"</code> and\n<code>\"shortcuts.js\"</code> and before <code>\"render.js\"</code>.</p>\n\n<p>The most likely things you might need to edit in this file are the relative paths. All of\nthe generated files included in the page need to be preserved. You can add <code>script</code> tags\nor <code>link</code> tags as needed, but consider their order in the sequence of tags.</p>\n\n<h3>Private Files</h3>\n\n<p>The following files should be considered private and should not be edited:</p>\n\n<ul>\n<li><code>manifest.js</code> - The set of all components to render.</li>\n<li><code>shortcuts.js</code> - Reusable \"templates\" used by the manifest.</li>\n<li><code>styles.css</code> - Styles specific to the theme builder.</li>\n<li><code>render.js</code> - Renders the components described by the manifest and shortcuts.</li>\n</ul>\n\n\n<h3>Customization</h3>\n\n<p>Add value to the process through the <code>\"custom.js\"</code> file. The primary use of this file is\nto add new shortcuts or manifest entries that might be needed by custom components you\nhave created for your application. This file will not be regenerated by Sencha Cmd.</p>\n\n<h3>Third Party Components</h3>\n\n<p>If you have received custom components from a third party, you should ask them to provide\na custom theme definition file so that you can include it in your <code>theme</code> folder and as a\n<code>script</code> tag in your '\"theme.html\"'. The content of such a file should be the same as\ndescribed for a <code>\"custom.js\"</code> file.</p>\n\n<p>You will probably also need SASS files (or at least CSS files) to add to your SASS theme\nand/or as <code>link</code> tags in <code>\"theme.html\"</code>.</p>\n\n<h2 id='command_theme-section-6'>Managing Themes Manually</h2>\n\n<p>Many applications existed before Sencha Cmd provided application management features or\nfor other reasons do not have the structure assumed by the simple commands described\nhere. While the commands to handle this case require more switches and understanding, it\nis possible to use Sencha Cmd in these more complex situations.</p>\n\n<p><strong>Important.</strong> The new version of Sencha Cmd takes a different approach to theme building\nthan did previous versions (which called this mechanism the \"slicer\"). There is no longer\na <code>sencha slice</code> command. This is now handled by the new <code>sencha theme build</code> command.</p>\n\n<h3>Creating Your Custom Theme</h3>\n\n<p>In order to produce sliced images for your theme, you need the necessary files that define\nthe theme. The easiest way to get these files is to generate an application in some temporary\nfolder and copy the <code>\"./resources/theme\"</code> folder to a location of your choosing using the\nfollowing:</p>\n\n<pre><code>sencha generate app /temp/dummyApp\n</code></pre>\n\n<p>Then copy <code>\"/temp/dummApp/resources/theme\"</code> to your desired location. For example, let's say\nthat location is <code>\"/path/to/MyApp/stuff/theme\"</code>.</p>\n\n<p>Following the above rules for customization of <code>\"theme.html\"</code> you can flatten the folders in\nto a single folder and change the relative paths in <code>\"theme.html\"</code> accordingly. You can also\ncorrect the relative paths to your CSS file(s) and the framework.</p>\n\n<h2 id='command_theme-section-7'>Compiling Your Custom Theme</h2>\n\n<p>Once you have moved the theme files to <code>\"/path/to/MyApp/stuff/theme\"</code> and editing all of the\nrelative paths in <code>\"theme.html\"</code>, you can proceed to generate images. Let's assume you run\nthe command from the root of your application.</p>\n\n<pre><code>cd /path/to/MyApp\nsencha theme build -page stuff/theme/theme.html -out images/theme\n</code></pre>\n\n<p>This will load <code>\"stuff/theme/theme.html\"</code> using an embedded WebKit instance and capture an\nimage of the content of the rendered page as well as a data object describing all of the\nimage slicing required. From those two results, the image slicing will proceed to generate\nall of the images to the <code>\"images/theme\"</code> folder.</p>\n\n<p>If something is wrong with the generated images, it can be helpful to keep the page image\nand the data object for diagnostic purposes. This can be done by specifying their names in\nthe command:</p>\n\n<pre><code>cd /path/to/MyApp\nsencha theme build -page stuff/theme/theme.html -out images/theme \\\n    -image image.png -data data.json\n</code></pre>\n\n<p>The image is always a PNG file because PNG is both lossless and has a proper alpha channel.\nThe data object is always in JSON format.</p>\n"});