Ext.data.JsonP.command_app({"title":"Using Sencha Cmd with Ext JS","guide":"<h1>Using Sencha Cmd with Ext JS</h1>\n<div class='toc'>\n<p><strong>Contents</strong></p>\n<ol>\n<li><a href='#!/guide/command_app-section-1'>Generating Your Application</a></li>\n<li><a href='#!/guide/command_app-section-2'>Extending Your Application</a></li>\n<li><a href='#!/guide/command_app-section-3'>Building Your Application</a></li>\n<li><a href='#!/guide/command_app-section-4'>Customizing The Build</a></li>\n<li><a href='#!/guide/command_app-section-5'>Custom Themes</a></li>\n<li><a href='#!/guide/command_app-section-6'>Upgrading Your Application</a></li>\n</ol>\n</div>\n\n<p><p><img src=\"guides/command_app/../command/sencha-command-128.png\" alt=\"\"></p></p>\n\n<p>This guide walks through the process of using Sencha Cmd with Ext JS applications starting\nwith the <code>sencha generate app</code> command and ending with a running application.</p>\n\n<p>This guide applies mostly to <em>new</em> single-page Ext JS applications. If you have an <em>existing</em>\nsingle-page application you might consider using Sencha Cmd to build an application\nskeleton based on this guide and then migrate your application code to this preferred\nstructure. This will provide you with the maximum leverage from Sencha Cmd. If this option\nis not right for your app, you can still use Sencha Cmd to help with many aspects of your\ndevelopment. For developing single-page applications with a custom folder structure, see\n<a href=\"#/guide/command_app_single\">Single-Page Ext JS Apps</a>.</p>\n\n<p>If you work with applications that have multiple pages, it will be helpful to start by\nlearning about the simple uses of Sencha Cmd described in this and the\n<a href=\"#/guide/command_app_single\">Single-Page Ext JS Apps</a> guide. For details on developing\nmore complex, multipage Ext JS applications, refer to\n<a href=\"#/guide/command_app_multi\">Multi-Page and Mixed Apps</a>.</p>\n\n<h2 id='command_app-section-1'>Generating Your Application</h2>\n\n<p>Our starting point is to generate an application skeleton. This is done using\nthe following command:</p>\n\n<pre><code>sencha generate app MyApp /path/to/MyApp\n</code></pre>\n\n<p><strong>Important.</strong> The above command must be able to determine the appropriate SDK. This can\nbe satisfied by either executing this command from a folder containing an extracted SDK\ndistribution or by using the <code>-sdk</code> switch like so:</p>\n\n<pre><code>sencha -sdk /path/to/SDK generate app MyApp /path/to/MyApp\n</code></pre>\n\n<p>The application files generated by this command should have the following structure:</p>\n\n<pre><code>.sencha/                    # Sencha-specific files (e.g. configuration)\n    app/                    # Application-specific content\n        sencha.cfg          # Configuration file for Sencha Cmd\n        plugin.xml          # Plugin for Sencha Cmd\n    workspace/              # Workspace-specific content (see below)\n        sencha.cfg          # Configuration file for Sencha Cmd\n        plugin.xml          # Plugin for Sencha Cmd\n\next/                        # A copy of the Ext JS SDK\n    cmd/                    # Framework-specific content for Sencha Cmd\n        sencha.cfg          # Configuration file for Sencha Cmd\n    src/                    # The Ext JS source\n    ext-*.js                # Pre-compiled and bootstrap files\n    ...\n\nindex.html                  # The entry point to your application\napp.json                    # Application configuration\napp/                        # Your application's source code in MVC structure\n    app.js                  # Your application's initialization logic\n    model/                  # Folder for application model classes.\n    store/                  # Folder for application stores\n    view/                   # Folder for application view classes.\n        Main.js             # The initial default View\n    controller/             # Folder for application controllers.\n        Main.js             # The initial default Controller\n\nresources/\n    theme/                  # This folder contains Theme Builder information\n        custom.js           # Contains any theme customizations (like custom components)\n        manifest.js         # Generated (do not edit)\n        render.js           # Generated (do not edit)\n        shortcuts.js        # Generated (do not edit)\n        styles.css          # Generated (do not edit)\n        default/            # The name of the theme (\"default\" is generated initially)\n            sass/\n                app.scss    # The SASS file which compiles to \n                            # &lt;app-root&gt;/.res/default/app.css\n                config.rb   # Ruby config file for the default theme\n            theme.html      # The control file for generating a theme\n\nbuild/                      # The folder where build output is placed.\n</code></pre>\n\n<p>There is no distinction between workspace and app content in a single-page application.\nThis distinction becomes important for multi-page applications as described in\n<a href=\"#/guide/command_app_multi\">Multi-page and Mixed Apps</a>.</p>\n\n<h2 id='command_app-section-2'>Extending Your Application</h2>\n\n<p>The <code>sencha generate</code> command helps you quickly generate common MVC components such as\ncontrollers or models:</p>\n\n<pre><code>sencha help generate\n</code></pre>\n\n<p>You should see this:</p>\n\n<pre><code>Sencha Cmd v3.0.0.???\nHELP -- generate\n\nCOMMANDS:\n* app - Generates a starter application\n* controller - Generates a Controller for the current application\n* model - Generates a Model for the current application\n* profile - (Touch Only) Generates a profile for the current application\n* store - Generates a Store for the current application\n* view - Generates a View for the current application\n</code></pre>\n\n<p><strong>Important.</strong> In order to execute these commands, the current directory <strong>must</strong> be the\ntop-level folder of your application (in this case, \"/path/to/MyApp\").</p>\n\n<h3>Adding New Models</h3>\n\n<p>Adding a model to your application is done by making the <code>\"/path/to/MyApp\"</code> your current\ndirectory and running Sencha Cmd, like this:</p>\n\n<pre><code>cd /path/to/MyApp\nsencha generate model User id:int,name,email\n</code></pre>\n\n<p>This command adds a model to the application called <code>User</code> with the given 3 fields.</p>\n\n<h3>Adding New Controllers</h3>\n\n<p>Adding a controller is similar to adding a model:</p>\n\n<pre><code>cd /path/to/MyApp\nsencha generate controller Central\n</code></pre>\n\n<p>There are no other parameters in this case beyond the controller name.</p>\n\n<h3>Adding New Views</h3>\n\n<p>Adding a view to your application is also similar:</p>\n\n<pre><code>cd /path/to/MyApp\nsencha generate view SomeView\n</code></pre>\n\n<p>There are no other parameters in this case beyond the view name.</p>\n\n<h2 id='command_app-section-3'>Building Your Application</h2>\n\n<p>All that is required to build your application is to run the following command:</p>\n\n<pre><code>sencha app build\n</code></pre>\n\n<p><strong>Important.</strong> In order to execute this command, the current directory <strong>must</strong> be the\ntop-level folder of your application (in this case, <code>\"/path/to/MyApp\"</code>).</p>\n\n<p>This command will build your markup page, JavaScript code, SASS and themes into the <code>\"build\"</code>\nfolder.</p>\n\n<h2 id='command_app-section-4'>Customizing The Build</h2>\n\n<p>There are various configuration options available in the <code>\".sencha/app/sencha.cfg\"</code> file. In\nthe case of a single-page application, it is best to ignore the <code>\".sencha/workspace\"</code>\nfolder, which also has a config file.</p>\n\n<p>When configuration options cannot accomplish the task, the next level of customization is\nto extend the generated \"build.xml\" <a href=\"http://ant.apache.org/\">Ant</a> script. All that the\n<code>sencha app build</code> command does inside Sencha Cmd itself is some basic validations before\ncalling in to the <code>\"build\"</code> target of this build script. This means the entire build process\ncan be examined, extended and if necessary, even modified.</p>\n\n<h3>The classpath</h3>\n\n<p>The <code>sencha app build</code> command knows where to find the source of your application due to\nthe <code>app.classpath</code> configuration value stored in <code>\".sencha/app/sencha.cfg\"</code>. By default,\nthis value is:</p>\n\n<pre><code>app.classpath=${app.dir}/app\n</code></pre>\n\n<p>Adding directories to this comma-separated list informs the compiler where to find the\nsource code required to build the application.</p>\n\n<h3>Ant Extension Points</h3>\n\n<p>The generated <code>\"build.xml\"</code> <a href=\"http://ant.apache.org/\">Ant</a> script is a minimal Ant script that\nuses an Ant <code>import</code> task to import <code>\"build-impl.xml\"</code>. The <code>\"build.xml\"</code> file is intended to\nbe edited after it is generated. The <code>\"build-impl.xml\"</code> file, however, will be upgraded\n(replaced) by the <code>sencha app upgrade</code> command described below and is best left alone.</p>\n\n<p>In addition to the <code>import</code> task, <code>\"build.xml\"</code> contains a comment block describing all of\nthe various extension points it provides. These are in the form of optional Ant targets and\nare typically named after their build process step but with prefixes of <code>\"-before-\"</code> and\n<code>\"-after-\"</code>. In other words, the <code>\"sass\"</code> build step is wrapped by targets that will be invoked\nbefore and after the <code>\"sass\"</code> target named <code>\"-before-sass\"</code> and <code>\"-after-sass\"</code>.</p>\n\n<p>To perform additional processing before or after any build step, add an appropriately named\ntarget to <code>\"build.xml\"</code>. These targets will be invoked by <code>sencha app build</code>. These will also\nbe invoked if you use Ant to directly invoke a particular target.</p>\n\n<p><strong>Note.</strong> Because <code>sencha app build</code> simply invokes the <code>\"build\"</code> target of the Ant <code>\"build.xml\"</code>\nfile, you can equivalently invoke a build directly from Ant. This can be useful in IDE's\nlike Eclipse and NetBeans for invoking your builds but also in a Continuous Integration\nserver that understands Ant (which is just about all of them).</p>\n\n<h2 id='command_app-section-5'>Custom Themes</h2>\n\n<p>All applications start with a default theme, so it is typically not necessary to add any\nthemes. To enable an application to support multiple themes, the first step is to use the\nfollowing:</p>\n\n<pre><code>cd /path/to/MyApp\nsencha generate theme red\n</code></pre>\n\n<p>This creates the following folders and some starter content:</p>\n\n<ul>\n<li><code>./resources/theme/red/sass/app.scss</code></li>\n<li><code>./resources/theme/red/sass/config.rb</code></li>\n<li><code>./resources/theme/red/theme.html</code></li>\n</ul>\n\n\n<p>For details on how to manage and build themes, see <a href=\"#/guide/command_theme\">Building Themes</a>.</p>\n\n<h2 id='command_app-section-6'>Upgrading Your Application</h2>\n\n<p>Generated applications always include their own copies of the SDK from which they were\noriginally generated. Upgrading these application to a new version of the SDK means\nreplacing the old copy with the new one. Co this by changing directories to your\napplication folder and running the following command:</p>\n\n<pre><code>sencha app upgrade ../downloads/ext-4.1.2\n</code></pre>\n\n<p>The above command points to the path to a downloaded and extracted SDK.</p>\n\n<p><strong>Important.</strong> Do not use the <code>-sdk</code> switch for this command as you would for the\n<code>sencha generate app</code> command. Instead use the command shown above.</p>\n"});