Ext.samples = {
    samplesCatalog: [
        {
            "title": "Combination Examples",
            "items": [
                {
                    "text": "Kitchen Sink",
                    "url": "build/KitchenSink/ext-theme-neptune/",
                    "icon": "kitchensink.gif",
                    "desc": "Showcase of Ext JS components using a preview release of the new Neptune theme"
                },
                {
                    "text": "Feed Viewer",
                    "url": "feed-viewer/feed-viewer.html",
                    "icon": "feeds.png",
                    "desc": "RSS feed reader example application that features a swappable reader panel layout."
                },
                {
                    "text": "Ext JS Calendar",
                    "url": "calendar/index.html",
                    "icon": "calendar.png",
                    "desc": "Example Calendar application. Demonstrates the new Day, Week and Month views and how to combine them."
                },
                {
                    "text": "Web Desktop",
                    "url": "desktop/desktop.html",
                    "icon": "desktop.png",
                    "desc": "Demonstrates how one could build a desktop in the browser using Ext components including a module plugin system."
                },
                {
                    "text": "Portal Demo",
                    "url": "portal/portal.html",
                    "icon": "portal.png",
                    "desc": "A page layout using several custom extensions to provide a web portal interface."
                },
                {
                    "text": "Ext JS 3 & 4 on one page",
                    "url": "sandbox/sandbox.html",
                    "icon": "sandbox.gif",
                    "desc": "This example demonstrates Ext JS 4's sandboxing behavior which allows you to run Ext JS 3 & 4 on the same page."
                },
                {
                    "text": "Image Viewer",
                    "url": "organizer/organizer.html",
                    "icon": "organizer.png",
                    "desc": "DataView and TreePanel example that demonstrates dragging data items from a DataView into a TreePanel."
                },
                {
                    "text": "Theme Viewer",
                    "url": "themes/index.html",
                    "icon": "themes.png",
                    "desc": "View and test every Ext component against bundled Ext themes."
                },
                {
                    "text": "Simple Tasks",
                    "url": "simple-tasks/index.html",
                    "icon": "tasks.png",
                    "desc": "Complete personal task management application example"
                },
                {
                    "text": "Right-to-Left (RTL)",
                    "url": "rtl/rtl.html",
                    "icon": "tasks.png",
                    "desc": "Demonstrates Ext JS support for right-to-left languages",
                    "status": "new"
                }
            ]
        },
        {
            "title": "Enterprise",
            "items": [
                {
                    "text": "SOAP Grid",
                    "url": "grid/soap-grid.html",
                    "icon": "soap-grid.png",
                    "desc": "Grid loaded from SOAP data"
                },
                {
                    "text": "AMF Grid",
                    "url": "grid/amf-grid.html",
                    "icon": "amf-grid.png",
                    "desc": "Grid loaded from binary AMF (Action Message Format) data"
                }
            ]

        },
        {
            "title": "Accessibility",
            "items": [
                {
                    "text": "Keyboard Feed Viewer",
                    "url": "key-feed-viewer/feed-viewer.html",
                    "icon": "keyboard.gif",
                    "desc": "Shows Ext JS 4's comprehensive keyboard support for users who have difficulty using a pointing device"

                }
            ]
        },
        {
            "title": "Grids",
            "items": [
                {
                    "text": "Basic Array Grid",
                    "url": "build/KitchenSink/ext-theme-neptune/#array-grid",
                    "icon": "grid-array.png",
                    "desc": "A basic read-only grid loaded from local array data that demonstrates the use of custom column renderer functions."
                },
                {
                    "text": "XML Grid",
                    "url": "grid/xml-grid.html",
                    "icon": "grid-xml.gif",
                    "desc": "A simple read-only grid loaded from XML data."
                },
                {
                    "text": "Paging",
                    "url": "grid/paging.html",
                    "icon": "grid-paging.png",
                    "desc": "A grid with paging, cross-domain data loading and custom- rendered expandable row bodies."
                },
                {
                    "text": "Sliding Pager",
                    "url": "build/KitchenSink/ext-theme-neptune/#sliding-pager",
                    "icon": "slider-pager.png",
                    "desc": "A demonstration on the integration of the Slider with the Paging Toolbar using a custom plugin."
                },
                {
                    "text": "Grouping",
                    "url": "build/KitchenSink/ext-theme-neptune/#grouped-grid",
                    "icon": "grid-grouping.png",
                    "desc": "A basic grouping grid showing collapsible data groups that can be customized via the 'Group By' header menu option."
                },
                {
                    "text": "Grid Plugins",
                    "url": "grid/grid-plugins.html",
                    "icon": "grid-plugins.png",
                    "desc": "Multiple grids customized via plugins: expander rows, checkbox selection and row numbering."
                },
                {
                    "text": "Grid Filtering",
                    "url": "grid-filtering/grid-filter-local.html",
                    "icon": "grid-filter.png",
                    "desc": "Grid feature providing custom data filtering menus that support various data types."
                },
                {
                    "text": "Grid Data Binding (basic)",
                    "url": "grid/binding.html",
                    "icon": "grid-data-binding.png",
                    "desc": "Data binding a grid to a detail preview panel via the grid\"s RowSelectionModel."
                },
                {
                    "text": "Grid Data Binding (advanced)",
                    "url": "grid/binding-with-classes.html",
                    "icon": "grid-data-binding.png",
                    "desc": "Refactoring the basic data binding example to use a class-based application design model."
                },
                {
                    "text": "Multiple Sorting",
                    "url": "grid/multiple-sorting.html",
                    "icon": "grid-multiple-sorting.png",
                    "desc": "An example that shows multi-level sorting in a Grid Panel."
                },
                {
                    "text": "Grid Cell Editing",
                    "url": "build/KitchenSink/ext-theme-neptune/#cell-editing",
                    "icon": "grid-cell-editing.png",
                    "desc": "An example that shows cell editing in a Grid Panel."
                },
                {
                    "text": "Grouped Header Grid",
                    "url": "build/KitchenSink/ext-theme-neptune/#grouped-header-grid",
                    "icon": "grid-grouped-headers.gif",
                    "desc": "A basic grouping grid showing collapsible data groups that can be customized via the 'Group By' header menu option."
                },
                {
                    "text": "Grid Grouping with Summary",
                    "url": "grid/group-summary-grid.html",
                    "icon": "grid-summary.png",
                    "desc": "Advanced grouping grid that allows cell editing and includes custom dynamic summary calculations."
                },
                {
                    "text": "Infinite Grid",
                    "url": "grid/infinite-scroll.html",
                    "icon": "grid-infinite-scroll.png",
                    "desc": "Sample grid which scrolls through thousands of rows dynamically loaded from a server",
                    "status": "updated"
                },
                {
                    "text": "Grid with Live Search Capability",
                    "url": "grid/live-search-grid.html",
                    "icon": "grid-live-search.png",
                    "desc": "Grid with Live Search Capability."
                },
                {
                    "text": "Grid with Locking Capability",
                    "url": "build/KitchenSink/ext-theme-neptune/#locking-grid",
                    "icon": "grid-locking.png",
                    "desc": "An example extension that introduces the ability to add locking columns to the GridPanel."
                },
                {
                    "text": "Grouping with Remote Summary",
                    "url": "grid/remote-group-summary-grid.html",
                    "icon": "grid-group-summaries.png",
                    "desc": "Advanced grouping grid that allows cell editing and includes remotely loaded dynamic summary calculations."
                },
                {
                    "text": "Grid Row Editing",
                    "url": "grid/row-editing.html",
                    "icon": "grid-row-editor.png",
                    "desc": "An editable grid which allows the user to make modifications to an entire record at once."
                },
                {
                    "text": "RESTful Store with GridPanel and RowEditor",
                    "url": "restful/restful.html",
                    "icon": "grid-row-editor.png",
                    "desc": "A RESTful Store with JsonWriter which automatically generates CRUD requests to the server."
                },
                {
                    "text": "Editable Grid with Writable Store",
                    "url": "writer/writer.html",
                    "icon": "writer-thumb.png",
                    "desc": "This Store uses Data's writer to automatically generate CRUD requests to the server through a standard Ajax Proxy."
                },
                {
                    "text": "Editable Grid with JSONP Writable Store",
                    "url": "writer/writer-jsonp.html",
                    "icon": "writer-thumb.png",
                    "desc": "This Store uses Data's writer to automatically generate CRUD requests to the server through a standard JsonP Proxy."
                },
                {
                    "text": "Buffered Scrolling",
                    "url": "grid/buffer-grid.html",
                    "icon": "buffer-grid.png",
                    "desc": "The new grid uses a virtualized scrolling system to handle potentially infinite data sets without any impact on client side performance.",
                    "status": "updated"
                },
                {
                    "text": "List View",
                    "url": "grid/list-view.html",
                    "icon": "list-view.png",
                    "desc": "Ext 4 replaces Ext.ListView with the default Ext.grid.Panel."
                },
                {
                    "text": "Progress Bar Pager",
                    "url": "build/KitchenSink/ext-theme-neptune/#progress-bar-pager",
                    "icon": "progress-bar-pager.png",
                    "desc": "Progress Bar Pager Extension."
                },
                {
                    "text": "Property Grid",
                    "url": "build/KitchenSink/ext-theme-neptune/#property-grid",
                    "icon": "grid-property.png",
                    "desc": "Create a property grid from an object."
                },
                {
                    "text": "Reconfigure Grid",
                    "url": "build/KitchenSink/ext-theme-neptune/#reconfigure-grid",
                    "icon": "grid-reconfigure.png",
                    "desc": "Reconfigure the columns & data of a grid dynamically",
                    "status": "new"
                },
                {
                    "text": "Grid From Markup",
                    "url": "grid/transform-dom.html",
                    "icon": "grid-transform.png",
                    "desc": "Create a grid with from an existing, unformatted HTML table."
                },
                {
                    "text": "Locking Grouping Grid with Summary",
                    "url": "grid/locking-group-summary-grid.html",
                    "icon": "grid-summary.png",
                    "desc": "Advanced grouping grid that allows cell editing and includes custom dynamic summary calculations. With column locking capability"
                },
                {
                    "text": "Infinite Grid with remote filter",
                    "url": "grid/infinite-scroll-with-filter.html",
                    "icon": "grid-infinite-scroll.png",
                    "desc": "Sample grid which scrolls through thousands of rows dynamically loaded from a server with a filtering UI",
                    "status": "updated"
                },
                {
                    "text": "Locking Grouping Grid with Summary and grouped headers",
                    "url": "grid/locking-grp-summary-grp-hdrs-grid.html",
                    "icon": "grid-summary.png",
                    "desc": "Grouped grid with locked columns and grouped column headers"
                }
            ]
        },
        {
            "title": "Charts",
            "items": [
                {
                    "text": "Area Charts",
                    "url": "charts/Area.html",
                    "icon": "chart-area.gif",
                    "desc": "Display 7 sets of random data in an area series. Reload data will randomly generate a new set of data in the store."
                },
                {
                    "text": "Custom Area Charts",
                    "url": "charts/AreaBrowserStats.html",
                    "icon": "area-browsers.gif",
                    "desc": "Display browser usage trends in an area series. This chart uses custom gradients for the colors and the legend is interactive."
                },
                {
                    "text": "Bar Charts",
                    "url": "charts/Bar.html",
                    "icon": "chart-bar.gif",
                    "desc": "Display a sets of random data in a bar series. Reload data will randomly generate a new set of data in the store."
                },
                {
                    "text": "Custom Bar Charts",
                    "url": "charts/BarRenderer.html",
                    "icon": "chart-bar-renderer.gif",
                    "desc": "Displaying a horizontal bar series with a bar renderer that modifies the color of each bar."
                },
                {
                    "text": "Complex Dashboard",
                    "url": "charts/FormDashboard.html",
                    "icon": "form-dashboard.gif",
                    "desc": "Showing companies information in a complex dashboard. Edit the information for each record in the form to see live updates in the charts and grid."
                },
                {
                    "text": "Rich Tips",
                    "url": "charts/TipsChart.html",
                    "icon": "rich-tips.gif",
                    "desc": "Showing a line series with rich tips. Tips show dynamic information in Grid and Pie chart components."
                },
                {
                    "text": "Themed Line Charts",
                    "url": "charts/Charts.html",
                    "icon": "chart-themed.gif",
                    "desc": "Using 3.x theme. Displaying multiple charts and mixed charts with mouse over and click interaction."
                },
                {
                    "text": "Column Charts",
                    "url": "charts/Column.html",
                    "icon": "chart-column.gif",
                    "desc": "Display a set of random data in a column series. Reload data will randomly generate a new set of data in the store."
                },
                {
                    "text": "Line Charts",
                    "url": "charts/Line.html",
                    "icon": "chart-line.gif",
                    "desc": "Display 2 sets of random data in a line series. Reload data will randomly generate a new set of data in the store."
                },
                {
                    "text": "Column Custom Background",
                    "url": "charts/Column2.html",
                    "icon": "column2.gif",
                    "desc": "A Column chart with customized theme and animation transitions"
                },
                {
                    "text": "Mixed Series Chart",
                    "url": "charts/Mixed.html",
                    "icon": "chart-mixed.gif",
                    "desc": "Display 3 sets of random data using a line, bar, and scatter series. Reload data will randomly generate a new set of data in the store."
                },
                {
                    "text": "Pie Charts",
                    "url": "charts/Pie.html",
                    "icon": "chart-pie.gif",
                    "desc": "Display 5 sets of random data using a pie chart. Reload data will randomly generate a new set of data in the store."
                },
                {
                    "text": "Custom Pie Charts",
                    "url": "charts/PieRenderer.html",
                    "icon": "chart-pie-renderer.gif",
                    "desc": "Display 5 sets of random data using a pie chart. A renderer has been set up on to dynamically change the length and color of each slice based on the data."
                },
                {
                    "text": "Radar Charts",
                    "url": "charts/Radar.html",
                    "icon": "chart-radar.gif",
                    "desc": "Display 3 sets of random data in a radar series. Note this example uses a radial axis."
                },
                {
                    "text": "Filled Radar Charts",
                    "url": "charts/RadarFill.html",
                    "icon": "chart-radar-fill.gif",
                    "desc": "Display 3 sets of random data in a filled radar series. Click or hover on the legend items to highlight and remove them from the chart."
                },
                {
                    "text": "Scatter Charts",
                    "url": "charts/ScatterRenderer.html",
                    "icon": "chart-scatter.gif",
                    "desc": "Display 2 sets of random data in a scatter series. A renderer has been set up on to dynamically change the size and color of the items based upon it's data."
                },
                {
                    "text": "Stacked Bar Charts",
                    "url": "charts/StackedBar.html",
                    "icon": "chart-bar-stacked.gif",
                    "desc": "Showing movie taking by genre as a stacked bar chart sample. Filter the stacks by clicking on the legend items."
                },
                {
                    "text": "Live Updated Chart",
                    "url": "charts/LiveUpdates.html",
                    "icon": "live-updated.gif",
                    "desc": "Showing a line series with data updating at a regular interval."
                },
                {
                    "text": "Live Animated Chart",
                    "url": "charts/LiveAnimated.html",
                    "icon": "live-animated.gif",
                    "desc": "Showing a line series with smooth transitions on data updating at regular intervals."
                },
                {
                    "text": "Gauge Chart",
                    "url": "charts/Gauge.html",
                    "icon": "gauge.gif",
                    "desc": "Display three custom gauge charts bound to different data stores with different configuration options and easings."
                },
                {
                    "text": "Grouped Bar",
                    "url": "charts/GroupedBar.html",
                    "icon": "grouped-bar.gif",
                    "desc": "Display 3 sets of random data in a grouped bar series."
                },
                {
                    "text": "Reload Chart",
                    "url": "charts/ReloadChart.html",
                    "icon": "reload-chart.gif",
                    "desc": "Display a Column Chart Sample that animates when refreshing the data set"
                }
            ]
        },
        {
            "title": "Tabs",
            "items": [
                {
                    "text": "Basic Tabs",
                    "url": "tabs/tabs.html",
                    "icon": "tabs.png",
                    "desc": "Basic tab functionality including autoHeight, tabs from markup, Ajax loading and tab events."
                },
                {
                    "text": "Advanced Tabs",
                    "url": "tabs/tabs-adv.html",
                    "icon": "tabs-adv.png",
                    "desc": "Advanced tab features including tab scrolling, adding tabs programmatically and a context menu plugin."
                },
                {
                   "text": "Tab overflow menu",
                   "url": "tabs/tab-scroller-menu.html",
                   "icon": "tabs-adv.png",
                   "desc": "Demonstrates the TabPanel overflow menu extension, which makes management of large numbers of tabs easier"
                },
                {
                    "text": "Side Tabs",
                    "url": "tabs/side-tabs.html",
                    "icon": "side-tabs.png",
                    "desc": "Demonstrates side orientated tabs.",
                    "status": "new"
                },
                {
                   "text": "Group Tabs",
                   "url": "grouptabs/grouptabs.html",
                   "icon": "group-tabs.png",
                   "desc": "A custom example on how to setup tab grouping using vertical tabs."
                }
            ]
        },
        {
            "title": "Windows",
            "items": [
                {
                    "text": "Window Variations",
                    "url": "window/window.html",
                    "icon": "window-layout.png",
                    "desc": "A collection of Windows in different configurations, showing headers attached to any side of the window."
                },
                {
                    "text": "Layout Window",
                    "url": "window/layout.html",
                    "icon": "window.png",
                    "desc": "A window containing a basic BorderLayout with nested TabPanel."
                },
                {
                    "text": "MessageBox",
                    "url": "message-box/msg-box.html",
                    "icon": "msg-box.png",
                    "desc": "Different styles include confirm, alert, prompt, progress and wait and also support custom icons."
                }
            ]
        },
        {
            "title": "Trees",
            "items": [
                {
                    "text": "Drag and Drop Reordering",
                    "url": "build/KitchenSink/ext-theme-neptune/#tree-reorder",
                    "icon": "tree-reorder.png",
                    "desc": "A TreePanel loaded asynchronously via a JSON TreeLoader that shows drag and drop with container scroll."
                },
                {
                    "text": "Multiple trees",
                    "url": "build/KitchenSink/ext-theme-neptune/#tree-two",
                    "icon": "tree-two.png",
                    "desc": "Drag and drop between two different sorted TreePanels."
                },
                {
                    "text": "TreeGrid",
                    "url": "build/KitchenSink/ext-theme-neptune/#tree-grid",
                    "icon": "tree-columns.png",
                    "desc": "The TreeGrid component"
                },
                {
                    "text": "Locking TreeGrid",
                    "url": "tree/locking-treegrid.html",
                    "icon": "tree-columns.png",
                    "desc": "TreeGrid with lockable columns",
                    "status": "new"
                },
                {
                    "text": "Check Tree",
                    "url": "build/KitchenSink/ext-theme-neptune/#check-tree",
                    "icon": "tree-check.png",
                    "desc": "An example showing simple checkbox selection in a tree."
                },
                {
                    "text": "XML Tree",
                    "url": "build/KitchenSink/ext-theme-neptune/#tree-xml",
                    "icon": "tree-xml-loader.png",
                    "desc": "A custom TreeLoader implementation that demonstrates loading a tree from an XML document."
                },
                {
                    "text": "Custom Drop Logic",
                    "url": "tree/custom-drop-logic.html",
                    "icon": "tree-custom-node-logic.png",
                    "desc": "Apply custom logic to determine where nodes can be moved."
                },
                {
                    "text": "Buffer Rendered Tree",
                    "url": "tree/buffer-rendered-treegrid.html",
                    "icon": "tree-columns.png",
                    "desc": "Rendering very large trees efficiently.",
                    "status": "new"
                },
                {
                    "text": "Locking Buffer Rendered Tree",
                    "url": "tree/locking-buffer-rendered-treegrid.html",
                    "icon": "tree-columns.png",
                    "desc": "Rendering very large trees efficiently. With locked columns",
                    "status": "new"
                }
            ]
        },
        {
            "title": "Layout Managers",
            "items": [
                {
                    "text": "Layout Browser",
                    "url": "layout-browser/layout-browser.html",
                    "icon": "layout-browser.png",
                    "desc": "Comprehensive showcase of the standard layout managers as well as several custom and combination layouts and combination examples."
                },
                {
                    "text": "Border Layout",
                    "url": "layout/border.html",
                    "icon": "border-layout.png",
                    "desc": "A complex BorderLayout implementation that shows nesting multiple components and sub-layouts."
                },
                {
                    "text": "Accordion Layout",
                    "url": "build/KitchenSink/ext-theme-neptune/#layout-accordion",
                    "icon": "layout-accordion.gif",
                    "desc": "A basic accordion layout within a border layout."
                },
                {
                    "text": "Anchor Layout (Form)",
                    "url": "form/anchoring.html",
                    "icon": "layout-form.gif",
                    "desc": "A simple example of form fields utilizing an anchor layout in a window for flexible form resizing."
                },
                {
                    "text": "Anchor Layout (Panel)",
                    "url": "layout/anchor.html",
                    "icon": "layout-anchor.gif",
                    "desc": "An example of Panels anchored in the browser window."
                },
                {
                    "text": "Column Layout",
                    "url": "layout/column.html",
                    "icon": "layout-column.gif",
                    "desc": "An example of Panels managed by a column layout."
                },
                {
                    "text": "Table Layout",
                    "url": "layout/table.html",
                    "icon": "layout-table.gif",
                    "desc": "An example of Panels managed by a table layout."
                },
                {
                   "text": "HBox Layout",
                   "url": "layout/hbox.html",
                   "icon": "layout-column.gif",
                   "desc": "Interactive layout illustrating the capabilities of the HBox Layout."
                },
                {
                    "text": "VBox Layout",
                    "url": "layout/vbox.html",
                    "icon": "layout-vbox.gif",
                    "desc": "Interactive layout illustrating the capabilities of the VBox Layout."
                },
                {
                    "text": "Complex Layout",
                    "url": "layout/complex.html",
                    "icon": "complex-layout.png",
                    "desc": "A complex layout example."
                }
            ]
        },
        {
            "title": "Drawing",
            "items": [
                {
                    "text": "Resizable Sencha Logo",
                    "url": "draw/Sencha.html",
                    "icon": "draw-sencha.png",
                    "desc": "Resolution independent Sencha logo in a resizable component."
                },
                {
                    "text": "Browser Logos",
                    "url": "draw/Logos.html",
                    "icon": "draw-logos.png",
                    "desc": "Resolution independent logos of all the popular browsers."
                },
                {
                    "text": "Tiger",
                    "url": "draw/Tiger.html",
                    "icon": "draw-tiger.gif",
                    "desc": "The classic SVG Tiger in a floatable, draggable component. Scalable to any size, fully resolution independent."
                },
                {
                    "text": "Rotate Text",
                    "url": "draw/Rotate Text.html",
                    "icon": "draw-rotate-text.gif",
                    "desc": "Create text in a Draw Component which can be rotated easily in any browser."
                }
            ]
        },
        {
            "title": "Drag and Drop",
            "items": [
                {
                    "text": "Grid to Grid DnD",
                    "url": "build/KitchenSink/ext-theme-neptune/#dd-grid-to-grid",
                    "icon": "dd-gridtogrid.png",
                    "desc": "Shows how rows can be easily dragged and dropped between two or more grids"
                },
                {
                    "text": "Grid Cell to Cell DnD",
                    "url": "dd/cell-to-cell-dd.html",
                    "icon": "dd-celltocell.png",
                    "desc": "Illustrates how a custom plugin can enable cell drag and drop operations within the same GridView",
                    "status": "new"
                },
                {
                    "text": "Grid to Form DnD",
                    "url": "build/KitchenSink/ext-theme-neptune/#dd-grid-to-form",
                    "icon": "dd-gridtoformpanel.png",
                    "desc": "Enables a user to drag a record from a grid and drop it into a form, where it can be edited"
                },
                {
                    "text": "Field to Grid DnD",
                    "url": "build/KitchenSink/ext-theme-neptune/#dd-field-to-grid",
                    "icon": "dd-fieldtogrid.png",
                    "desc": "Demonstrates dragging a value from a field onto a grid cell"
                },
                {
                    "text": "Custom Drag and Drop",
                    "url": "dd/dragdropzones.html",
                    "icon": "dd-zones.png",
                    "desc": "A completely custom Drag and Drop example showing DnD between a DataView and a grid"
                }
            ]
        },
        {
            "title": "Toolbars and Menus",
            "items": [
                {
                    "text": "Basic Toolbar",
                    "url": "menu/menus.html",
                    "icon": "toolbar.png",
                    "desc": "Toolbar and menus that contain various components like date pickers, color pickers, sub-menus and more."
                },
                {
                    "text": "Toolbar Button Groups",
                    "url": "toolbar/toolbars.html",
                    "icon": "toolbar-button-groups.png",
                    "desc": "Group buttons together in the toolbar."
                },
                {
                    "text": "Vertical Toolbars",
                    "url": "toolbar/vertical-toolbars.html",
                    "icon": "toolbar.png",
                    "desc": "Vertical Toolbars on the left and right. Combined vertical and horizontal toolbars."
                },
                {
                   "text": "Ext Grid Actions",
                   "url": "menu/action-grid.html",
                   "icon": "actions-grid.png",
                   "desc": "Bind the same behavior to multiple buttons, toolbar and menu items using the Ext.Action class."
                },
                {
                    "text": "Reorderable Toolbar",
                    "url": "toolbar/reorderable.html",
                    "icon": "toolbar-reorderable.png",
                    "desc": "Items within a toolbar can be reordered using this plugin."
                },
                {
                   "text": "Overflow Toolbar",
                   "url": "toolbar/overflow.html",
                   "icon": "toolbar-reorderable.png",
                   "desc": "Items within a toolbar will be placed into an overflow menu if the toolbar is too narrow."
                },
                {
                    "text": "Status Bar",
                    "url": "statusbar/statusbar-demo.html",
                    "icon": "statusbar-demo.png",
                    "desc": "A simple StatusBar that can be dropped into the bottom of any panel to display status text and icons."
                },
                {
                    "text": "Status Bar (Advanced)",
                    "url": "statusbar/statusbar-advanced.html",
                    "icon": "statusbar-adv.png",
                    "desc": "Customizing the StatusBar via a plugin to provide automatic form validation monitoring and error linking."
                },
                {
                    "text": "Ext Toolbar Actions",
                    "url": "menu/actions.html",
                    "icon": "actions.png",
                    "desc": "Bind the same behavior to multiple buttons, toolbar and menu items using the Ext.Action class."
                }

            ]
        },
        {
            "title": "ComboBox",
            "items": [
                {
                    "text": "Basic ComboBox",
                    "url": "form/combos.html",
                    "icon": "combo.png",
                    "desc": "Basic combos, combos rendered from markup and customized list layout to provide item tooltips."
                },
                {
                     "text": "ComboBox Templates",
                     "url": "form/forum-search.html",
                     "icon": "combo-custom.png",
                     "desc": "Customized combo with template-based list rendering, remote loading and paging."
                }
            ]
        },
        {
            "title": "DataView",
            "items": [
                {
                    "text": "DataView",
                    "url": "view/data-view.html",
                    "icon": "data-view.png",
                    "desc": "This example shows how to use an Ext.view.View"
                },
                {
                    "text": "Animated DataView",
                    "url": "view/animated-dataview.html",
                    "icon": "animated-dataview.png",
                    "desc": "Transition animation plugin applied to a standard DataView"
                },
                {
                    "text": "Multi-sort DataView",
                    "url": "build/KitchenSink/ext-theme-neptune/#dataview-multisort",
                    "icon": "multisort-dataview.png",
                    "desc": "Example demonstrating the ability to sort a DataView by multiple sorters."
                },
                {
                    "text": "Advanced DataView",
                    "url": "view/chooser/chooser.html",
                    "icon": "advanced-dataview.png",
                    "desc": "DataView which allows you to filter and sort images."
                }
            ]
        },
        {
            "title": "Forms",
            "items": [
                {
                    "text": "Dynamic Forms",
                    "url": "form/dynamic.html",
                    "icon": "form-dynamic.png",
                    "desc": "Various example forms showing collapsible fieldsets, column layout, nested TabPanels and more."
                },
                {
                    "text": "Ajax with XML Forms",
                    "url": "form/xml-form.html",
                    "icon": "form-xml.png",
                    "desc": "Ajax-loaded form fields from remote XML data and remote field validation on submit."
                },
                {
                    "text": "Contact Us Form",
                    "url": "form/contact-form.html",
                    "icon": "form-contact.png",
                    "desc": "An example of a common popup Contact Us form."
                },
                {
                    "text": "Custom Search Fields",
                    "url": "form/forum-search.html",
                    "icon": "form-custom.png",
                    "desc": "A TriggerField search extension combined with an XTemplate for custom results rendering."
                },
                {
                    "text": "Binding a Grid to a Form",
                    "url": "build/KitchenSink/ext-theme-neptune/#form-grid",
                    "icon": "form-grid-binding.png",
                    "desc": "A grid embedded within a FormPanel that automatically loads records into the form on row selection."
                },
                {
                    "text": "Field Types",
                    "url": "form/field-types.html",
                    "icon": "form-field-types.png",
                    "desc": "This example shows off all of the field types available in Ext JS in lots of different configurations."
                },
                {
                     "text": "Advanced Validation",
                     "url": "form/adv-vtypes.html",
                     "icon": "form-adv-vtypes.png",
                     "desc": "Relational form field validation using custom vtypes."
                },
                {
                     "text": "Checkbox/Radio Groups",
                     "url": "form/check-radio.html",
                     "icon": "form-check-radio.png",
                     "desc": "Examples showing different checkbox and radio group configurations."
                },
                {
                    "text": "File Upload Field",
                    "url": "form/file-upload.html",
                    "icon": "form-file-upload.png",
                    "desc": "A demo of how to give standard file upload fields a bit of Ext style using a custom class."
                },
                {
                    "text": "Number Field",
                    "url": "build/KitchenSink/ext-theme-neptune/#form-number",
                    "icon": "form-spinner.png",
                    "desc": "An example of the Number field, with and without a spinner."
                },
                {
                    "text": "MultiSelect and ItemSelector",
                    "url": "multiselect/multiselect-demo.html",
                    "icon": "form-multiselect.png",
                    "desc": "Example controls for selecting a list of items in forms."
                },
                {
                    "text": "Registration Form",
                    "url": "form/registration.html",
                    "icon": "form-registration.png",
                    "desc": "An account registration form, with custom global error message display."
                },
                {
                    "text": "Shopping Cart Checkout",
                    "url": "build/KitchenSink/ext-theme-neptune/#form-checkout",
                    "icon": "form-checkout.png",
                    "desc": "An example of a common shopping cart checkout form."
                },
                {
                    "text": "Slider Field",
                    "url": "build/KitchenSink/ext-theme-neptune/#slider-field",
                    "icon": "form-slider.png",
                    "desc": "Example usage of an Ext.Slider to select a number value in a form."
                },
                {
                    "text": "Forms with vBox layout",
                    "url": "form/vbox-form.html",
                    "icon": "form-vbox.png",
                    "desc": "Example usage of the vBox layout with forms. An added bonus is the FieldReplicator plugin."
                },
                {
                    "text": "Forms with hBox layout",
                    "url": "form/hbox-form.html",
                    "icon": "form-hbox.png",
                    "desc": "Example usage of the hBox layout with a form. Includes automatically adjusting validation messages."
                },
                {
                     "text": "Field Containers",
                     "url": "form/fieldcontainer.html",
                     "icon": "form-fieldcontainer.png",
                     "desc": "Example usage of the FieldContainer to place several fields on a single form row."
                },
                {
                    "text": "Form with absolute layout",
                    "url": "form/absform.html",
                    "icon": "form-absolute.png",
                    "desc": "A simple example of form fields utilizing an absolute layout in a window for flexible form resizing."
                },
                {
                    "text": "Custom form Field",
                    "url": "form/custom-form.html",
                    "icon": "form-custom.png",
                    "desc": "A simple example that demonstrate how to create a custom form field."
                }
            ]
        },
        {
            "title": "Direct",
            "items": [
                {
                    "text": "Direct",
                    "url": "direct/direct.html",
                    "icon": "direct.gif",
                    "desc": "An example demonstrating Remoting and Polling the server"
                },
                {
                    "text": "Direct Form",
                    "url": "direct/direct-form.html",
                    "icon": "direct.gif",
                    "desc": "Ext.Direct Remoting with a Form"
                },
                {
                    "text": "Direct Grid",
                    "url": "direct/direct-grid.html",
                    "icon": "direct.gif",
                    "desc": "Ext.Direct Remoting with a Grid"
                },
                {
                    "text": "Direct TreeLoader",
                    "url": "direct/direct-tree.html",
                    "icon": "direct.gif",
                    "desc": "Ext.Direct Remoting with a Tree"
                },
                {
                    "text": "Direct Named Arguments",
                    "url": "direct/named-arguments.html",
                    "icon": "direct.gif",
                    "desc": "Ext.Direct Named Arguments"
                }
            ]
        },
        {
            "title": "MVC",
            "items": [
                {
                    "text": "Feed Viewer",
                    "url": "app/feed-viewer/feed-viewer.html",
                    "icon": "feeds.png",
                    "desc": "An MVC application version of the Feed Viewer example. This shows best practice for a small app"
                },
                {
                    "text": "Nested Loading",
                    "url": "app/nested-loading/nested-loading.html",
                    "icon": "nested-loading.gif",
                    "desc": "An MVC example that shows simple navigation and nested loading with the data package"
                }
            ]
        },
        {
            "title": "Miscellaneous",
            "items": [
                {
                    "text": "History",
                    "url": "history/history.html",
                    "icon": "history.png",
                    "desc": "A History manager that allows the user to navigate an Ext UI via browser back/forward."
                },
                {
                    "text": "Google Maps",
                    "url": "window/gmap.html",
                    "icon": "gmap-panel.png",
                    "desc": "A Google Maps wrapper class that enables easy display of dynamic maps in Ext panels and windows."
                },
                {
                    "text": "Editor",
                    "url": "simple-widgets/editor.html",
                    "icon": "editor.png",
                    "desc": "An example demonstrating the ease of use of the Ext.editor class to modify DOM elements"
                },
                {
                    "text": "Slider",
                    "url": "slider/slider.html",
                    "icon": "slider.png",
                    "desc": "A slider component that supports vertical mode, snapping, tooltips, customized styles and multiple thumbs."
                },
                {
                    "text": "QuickTips",
                    "url": "qtips/qtips.html",
                    "icon": "qtips.png",
                    "desc": "Various tooltip and quick tip configuration options including Ajax loading and mouse tracking."
                },
                {
                    "text": "Progress Bar",
                    "url": "simple-widgets/progress-bar.html",
                    "icon": "progress.png",
                    "desc": "A basic progress bar component shown in various configurations and with custom styles."
                },
                {
                    "text": "Panels",
                    "url": "panel/panel.html",
                    "icon": "panel.png",
                    "desc": "A basic collapsible panel example."
                },
                {
                    "text": "Resizable",
                    "url": "resizer/basic.html",
                    "icon": "resizable.png",
                    "desc": "Examples of making any element resizable with various configuration options."
                },
                {
                    "text": "Buttons",
                    "url": "build/KitchenSink/ext-theme-neptune/#basic-buttons",
                    "icon": "buttons.gif",
                    "desc": "Shows buttons in many of their possible configurations"
                },
                {
                    "text": "Spotlight",
                    "url": "core/spotlight.html",
                    "icon": "spotlight.png",
                    "desc": "A utility for masking everything except a single element on the page to visually highlight it."
                },
                {
                    "text": "Keyboard Navigation",
                    "url": "keynav/keynav.html",
                    "icon": "keyboard.gif",
                    "desc": "Shows a custom keyboard navigation using the KeyNav class"
                },
                {
                    "text": "Localization (static)",
                    "url": "locale/dutch-form.html",
                    "icon": "locale-dutch.png",
                    "desc": "Demonstrates fully localizing a form by including a custom locale script."
                },
                {
                    "text": "Localization (dynamic)",
                    "url": "locale/multi-lang.html",
                    "icon": "locale-switch.png",
                    "desc": "Dynamically render various Ext components in different locales by selecting from a locale list."
                },
                {
                    "text": "Browser State Management",
                    "url": "state/state.html",
                    "icon": "state-saving.png",
                    "desc": "An example of storing your application's state."
                },
                {
                    "text": "Basic Templating",
                    "url": "platform/templates.html",
                    "icon": "templates.png",
                    "desc": "A basic templating example."
                }
                /* Disabled until this is updated to work with the new theming system
                   NOTE: when uncommenting this, also add it back in to examples.json
                {
                    "text": "Bubble Panel",
                    "url": "panel/bubble-panel/bubble-panel.html",
                    "icon": "panel-bubble.gif",
                    "desc": "This is a custom panel UI to achieve a different look and feel while not changing the default appearance of an Ext.Panel."
                }
                */
            ]
        }
    ]
};
