// Generated by CoffeeScript 1.3.3
(function() {

  (glu.ns('todo')).createMockBackend = function(auto, recordNum) {
    var backend, tasks;
    tasks = glu.test.createTable(todo.models.task, 8);
    tasks.create({
      id: '7777',
      description: 'do stuff',
      priority: 'high'
    });
    backend = glu.test.createBackend({
      defaultRoot: '/json/',
      fallbackToAjax: auto,
      autoRespond: auto,
      routes: {
        'removeTodos': {
          url: 'todos/action/remove',
          handle: function(req) {
            return todo.remove(req.params.ids);
          }
        },
        'requestVerification': {
          url: 'todo/action/requestVerification',
          handle: function(req) {
            return todo.update(req.params.ids, {
              status: 'verifying'
            });
          }
        },
        'todoSave': {
          url: 'todo/:id/action/save',
          handle: function(req) {
            return todo.replace(req.params.id, req.jsonData);
          }
        },
        'todos': {
          url: 'todo',
          handle: function(req) {
            return todo.list(req.params);
          }
        },
        'todo': {
          url: 'todo/:id',
          handle: function(req) {
            return todo.get(req.params.id);
          }
        }
      }
    });
    backend.capture();
    return {
      backend: backend,
      tasks: tasks
    };
  };

}).call(this);
