<!DOCTYPE html><html lang="en"><head><script async="" src="https://www.googletagmanager.com/gtag/js?id=UA-140352188-1"></script><script>window.dataLayer = window.dataLayer || [];
function gtag(){dataLayer.push(arguments);}
gtag('js', new Date());
gtag('config', 'UA-140352188-1');</script><meta charSet="utf-8"/><meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1"/><meta name="description" content="The CDN for highlightjs-badge"/><meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1"/><meta name="timestamp" content="2020-03-03T18:04:07.188Z"/><link rel="shortcut icon" href="/favicon.ico"/><title>UNPKG - highlightjs-badge</title><script>window.Promise || document.write('\x3Cscript src="/es6-promise@4.2.5/dist/es6-promise.min.js">\x3C/script>\x3Cscript>ES6Promise.polyfill()\x3C/script>')</script><script>window.fetch || document.write('\x3Cscript src="/whatwg-fetch@3.0.0/dist/fetch.umd.js">\x3C/script>')</script><script>window.__DATA__ = {"packageName":"highlightjs-badge","packageVersion":"0.1.6","availableVersions":["0.1.4","0.1.5","0.1.6"],"filename":"/highlightjs-badge.js","target":{"path":"/highlightjs-badge.js","type":"file","details":{"contentType":"application/javascript","integrity":"sha384-CpjgcUkD7JUsVR2xoRalc5slyLZ5tJkToct4og79BdHNgWzarF75N8TDVaXj7YuK","language":"JavaScript","size":13832,"uri":null,"highlights":["<span class=\"code-meta\">\"use strict\"</span>;\r\n","<span class=\"code-comment\">/*\r\n</span>","<span class=\"code-comment\">----------------------------------------\r\n</span>","<span class=\"code-comment\">highlightJs Badge\r\n</span>","<span class=\"code-comment\">----------------------------------------\r\n</span>","<span class=\"code-comment\">\r\n</span>","<span class=\"code-comment\">A copy code and language display badge\r\n</span>","<span class=\"code-comment\">for the highlightJs Syntax highlighter.\r\n</span>","<span class=\"code-comment\">\r\n</span>","<span class=\"code-comment\">by Rick Strahl, 2019-2020\r\n</span>","<span class=\"code-comment\">License: MIT\r\n</span>","<span class=\"code-comment\">\r\n</span>","<span class=\"code-comment\">Make sure this script is loaded last in your\r\n</span>","<span class=\"code-comment\">script loading.\r\n</span>","<span class=\"code-comment\">\r\n</span>","<span class=\"code-comment\">Usage:\r\n</span>","<span class=\"code-comment\">------\r\n</span>","<span class=\"code-comment\">Load `highlightjs-badge.js` after `highlight.js`:\r\n</span>","<span class=\"code-comment\">\r\n</span>","<span class=\"code-comment\">```js\r\n</span>","<span class=\"code-comment\">&lt;link href=\"highlightjs/styles/vs2015.css\" rel=\"stylesheet\"&gt;\r\n</span>","<span class=\"code-comment\">&lt;script src=\"highlighjs/highlight.pack.js\"&gt;&lt;/script&gt;\r\n</span>","<span class=\"code-comment\">\r\n</span>","<span class=\"code-comment\">&lt;script src=\"highlightjs-badge.js\"&gt;&lt;/script&gt;  \r\n</span>","<span class=\"code-comment\">&lt;script&gt;\r\n</span>","<span class=\"code-comment\">    setTimeout(function () {\r\n</span>","<span class=\"code-comment\">        var pres = document.querySelectorAll(\"pre&gt;code\");\r\n</span>","<span class=\"code-comment\">        for (var i = 0; i &lt; pres.length; i++) {\r\n</span>","<span class=\"code-comment\">            hljs.highlightBlock(pres[i]);\r\n</span>","<span class=\"code-comment\">        }\r\n</span>","<span class=\"code-comment\">        var options = {\r\n</span>","<span class=\"code-comment\">            contentSelector: \"#ArticleBody\",\r\n</span>","<span class=\"code-comment\">            // Delay in ms used for `setTimeout` before badging is applied\r\n</span>","<span class=\"code-comment\">            // Use if you need to time highlighting and badge application\r\n</span>","<span class=\"code-comment\">            // since the badges need to be applied afterwards.\r\n</span>","<span class=\"code-comment\">            // 0 - direct execution (ie. you handle timing\r\n</span>","<span class=\"code-comment\">            loadDelay:0,\r\n</span>","<span class=\"code-comment\">\r\n</span>","<span class=\"code-comment\">            // CSS class(es) used to render the copy icon.\r\n</span>","<span class=\"code-comment\">            copyIconClass: \"fa fa-copy\",\r\n</span>","<span class=\"code-comment\">            // CSS class(es) used to render the done icon.\r\n</span>","<span class=\"code-comment\">            checkIconClass: \"fa fa-check text-success\"\r\n</span>","<span class=\"code-comment\">        };\r\n</span>","<span class=\"code-comment\">        window.highlightJsBadge(options);\r\n</span>","<span class=\"code-comment\">    },10);\r\n</span>","<span class=\"code-comment\">&lt;/script&gt;\r\n</span>","<span class=\"code-comment\">```\r\n</span>","<span class=\"code-comment\">\r\n</span>","<span class=\"code-comment\">The script contains the template and CSS so nothing\r\n</span>","<span class=\"code-comment\">else is needed to run it.\r\n</span>","<span class=\"code-comment\">\r\n</span>","<span class=\"code-comment\">Customization:\r\n</span>","<span class=\"code-comment\">--------------\r\n</span>","<span class=\"code-comment\">This code automatically embeds styling and the template.\r\n</span>","<span class=\"code-comment\">\r\n</span>","<span class=\"code-comment\">If you want to customize you can either create a template\r\n</span>","<span class=\"code-comment\">in your HTML **using the code at the end of this file**.\r\n</span>","<span class=\"code-comment\">\r\n</span>","<span class=\"code-comment\">Alternately you can customize the `getTemplate()` function\r\n</span>","<span class=\"code-comment\">that renders the code from a string and keep it self contained\r\n</span>","<span class=\"code-comment\">within this script.\r\n</span>","<span class=\"code-comment\">\r\n</span>","<span class=\"code-comment\">Requirements:\r\n</span>","<span class=\"code-comment\">-------------\r\n</span>","<span class=\"code-comment\">Uses some ES6 features so won't work in IE without shims:\r\n</span>","<span class=\"code-comment\">\r\n</span>","<span class=\"code-comment\">* Object.assign\r\n</span>","<span class=\"code-comment\">* String.trim\r\n</span>","<span class=\"code-comment\">\r\n</span>","<span class=\"code-comment\">*/</span>\r\n","\r\n","<span class=\"code-comment\">// module header</span>\r\n","(<span class=\"code-function\"><span class=\"code-keyword\">function</span>(<span class=\"code-params\"> global, factory </span>) </span>{\r\n","\r\n","\t<span class=\"code-keyword\">if</span> ( <span class=\"code-keyword\">typeof</span> <span class=\"code-built_in\">module</span> === <span class=\"code-string\">\"object\"</span> &amp;&amp; <span class=\"code-keyword\">typeof</span> <span class=\"code-built_in\">module</span>.exports === <span class=\"code-string\">\"object\"</span> ) {\r\n","\t\t<span class=\"code-comment\">// For CommonJS and CommonJS-like environments where a proper `window`</span>\r\n","\t\t<span class=\"code-comment\">// is present, execute the factory\t\t</span>\r\n","\t\t<span class=\"code-built_in\">module</span>.exports = global.document ?\r\n","\t\t\tfactory( global, <span class=\"code-literal\">true</span> ) :\r\n","\t\t\t<span class=\"code-function\"><span class=\"code-keyword\">function</span>(<span class=\"code-params\"> w </span>) </span>{\r\n","\t\t\t\t<span class=\"code-keyword\">if</span> ( !w.document ) {\r\n","\t\t\t\t\t<span class=\"code-keyword\">throw</span> <span class=\"code-keyword\">new</span> <span class=\"code-built_in\">Error</span>( <span class=\"code-string\">\"A window with a document is required\"</span> );\r\n","\t\t\t\t}\r\n","\t\t\t\t<span class=\"code-keyword\">return</span> factory( w );\r\n","\t\t\t};\r\n","\t} <span class=\"code-keyword\">else</span> {\r\n","\t\tfactory( global );\r\n","\t}\r\n","\r\n","<span class=\"code-comment\">// Pass this if window is not defined yet</span>\r\n","}(<span class=\"code-keyword\">typeof</span> <span class=\"code-built_in\">window</span> !== <span class=\"code-string\">\"undefined\"</span> ? <span class=\"code-built_in\">window</span> : <span class=\"code-keyword\">this</span>, <span class=\"code-function\"><span class=\"code-keyword\">function</span>(<span class=\"code-params\"> window, noGlobal </span>) </span>{\r\n","\r\n","\r\n","    \r\n","<span class=\"code-keyword\">if</span> (<span class=\"code-keyword\">typeof</span> highlightJsBadgeAutoLoad !== <span class=\"code-string\">'boolean'</span>)\r\n","    <span class=\"code-keyword\">var</span> highlightJsBadgeAutoLoad = <span class=\"code-literal\">false</span>;\r\n","\r\n","<span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">highlightJsBadge</span>(<span class=\"code-params\">opt</span>) </span>{\r\n","    <span class=\"code-keyword\">var</span> options = {\r\n","        <span class=\"code-comment\">// the selector for the badge template</span>\r\n","        templateSelector: <span class=\"code-string\">\"#CodeBadgeTemplate\"</span>,\r\n","\r\n","        <span class=\"code-comment\">// base content selector that is searched for snippets</span>\r\n","        contentSelector: <span class=\"code-string\">\"body\"</span>,\r\n","\r\n","        <span class=\"code-comment\">// Delay in ms used for `setTimeout` before badging is applied</span>\r\n","        <span class=\"code-comment\">// Use if you need to time highlighting and badge application</span>\r\n","        <span class=\"code-comment\">// since the badges need to be applied afterwards.</span>\r\n","        <span class=\"code-comment\">// 0 - direct execution (ie. you handle timing</span>\r\n","        loadDelay: <span class=\"code-number\">0</span>,\r\n","\r\n","        <span class=\"code-comment\">// CSS class(es) used to render the copy icon.</span>\r\n","        copyIconClass: <span class=\"code-string\">\"fa fa-copy\"</span>,     \r\n","        <span class=\"code-comment\">// optional content for icons class (&lt;i class=\"fa fa-copy\"&gt;&lt;/i&gt; or &lt;i class=\"material-icons\"&gt;file_copy&lt;/i&gt;)</span>\r\n","        copyIconContent: <span class=\"code-string\">\"\"</span>,\r\n","\r\n","        <span class=\"code-comment\">// CSS class(es) used to render the done icon.</span>\r\n","        checkIconClass: <span class=\"code-string\">\"fa fa-check text-success\"</span>,\r\n","        checkIconContent: <span class=\"code-string\">\"\"</span>  \r\n","    };\r\n","\r\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">initialize</span>(<span class=\"code-params\">opt</span>) </span>{\r\n","        <span class=\"code-built_in\">Object</span>.assign(options, opt);\r\n","\r\n","        <span class=\"code-keyword\">if</span> (<span class=\"code-built_in\">document</span>.readyState == <span class=\"code-string\">'loading'</span>)\r\n","            <span class=\"code-built_in\">document</span>.addEventListener(<span class=\"code-string\">\"DOMContentLoaded\"</span>, load);\r\n","        <span class=\"code-keyword\">else</span>\r\n","            load();\r\n","    }\r\n","\r\n","\r\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">load</span>(<span class=\"code-params\"></span>) </span>{\r\n","        <span class=\"code-keyword\">if</span> (options.loadDelay)\r\n","            setTimeout(addCodeBadge, loadDelay);\r\n","        <span class=\"code-keyword\">else</span>\r\n","            addCodeBadge();\r\n","    }\r\n","\r\n","  <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">addCodeBadge</span>(<span class=\"code-params\"></span>) </span>{      \r\n","        <span class=\"code-comment\">// first make sure the template exists - if not we embed it</span>\r\n","        <span class=\"code-keyword\">if</span> (!<span class=\"code-built_in\">document</span>.querySelector(options.templateSelector)) {\r\n","            <span class=\"code-keyword\">var</span> node = <span class=\"code-built_in\">document</span>.createElement(<span class=\"code-string\">\"div\"</span>);\r\n","            node.innerHTML = getTemplate();            \r\n","            <span class=\"code-keyword\">var</span> style = node.querySelector(<span class=\"code-string\">\"style\"</span>);\r\n","            <span class=\"code-keyword\">var</span> template = node.querySelector(options.templateSelector);\r\n","            <span class=\"code-built_in\">document</span>.body.appendChild(style);\r\n","            <span class=\"code-built_in\">document</span>.body.appendChild(template);\r\n","        }\r\n","      \r\n","        <span class=\"code-keyword\">var</span> hudText = <span class=\"code-built_in\">document</span>.querySelector(options.templateSelector).innerHTML;\r\n","\r\n","        <span class=\"code-keyword\">var</span> $codes = <span class=\"code-built_in\">document</span>.querySelectorAll(<span class=\"code-string\">\"pre&gt;code.hljs\"</span>);        \r\n","        <span class=\"code-keyword\">for</span> (<span class=\"code-keyword\">var</span> index = <span class=\"code-number\">0</span>; index &lt; $codes.length; index++) {\r\n","            <span class=\"code-keyword\">var</span> el = $codes[index];\r\n","            <span class=\"code-keyword\">if</span> (el.querySelector(<span class=\"code-string\">\".code-badge\"</span>))\r\n","                <span class=\"code-keyword\">continue</span>; <span class=\"code-comment\">// already exists</span>\r\n","                       \r\n","            <span class=\"code-keyword\">var</span> lang = <span class=\"code-string\">\"\"</span>;\r\n","            \r\n","            <span class=\"code-keyword\">for</span> (<span class=\"code-keyword\">var</span> i = <span class=\"code-number\">0</span>; i &lt; el.classList.length; i++) {\r\n","                <span class=\"code-keyword\">var</span> cl = el.classList[i];\r\n","                <span class=\"code-comment\">// class=\"hljs language-csharp\"</span>\r\n","                <span class=\"code-keyword\">if</span> (cl.substr(<span class=\"code-number\">0</span>, <span class=\"code-number\">9</span>) === <span class=\"code-string\">'language-'</span>) {\r\n","                    lang = el.classList[i].replace(<span class=\"code-string\">'language-'</span>, <span class=\"code-string\">''</span>);\r\n","                    <span class=\"code-keyword\">break</span>;\r\n","                }\r\n","                <span class=\"code-comment\">// class=\"hljs lang-cs\"  // docFx</span>\r\n","                <span class=\"code-keyword\">else</span> <span class=\"code-keyword\">if</span> (cl.substr(<span class=\"code-number\">0</span>, <span class=\"code-number\">5</span>) === <span class=\"code-string\">'lang-'</span>) {\r\n","                    lang = el.classList[i].replace(<span class=\"code-string\">'lang-'</span>, <span class=\"code-string\">''</span>);\r\n","                    <span class=\"code-keyword\">break</span>;\r\n","                }\r\n","                <span class=\"code-comment\">// class=\"kotlin hljs\"   (auto detected)</span>\r\n","                <span class=\"code-keyword\">if</span> (!lang) {\r\n","                    <span class=\"code-keyword\">for</span> (<span class=\"code-keyword\">var</span> j = <span class=\"code-number\">0</span>; j &lt; el.classList.length; j++) {\r\n","                        <span class=\"code-keyword\">if</span> (el.classList[j] == <span class=\"code-string\">'hljs'</span>)\r\n","                            <span class=\"code-keyword\">continue</span>;\r\n","                        lang = el.classList[j];\r\n","                        <span class=\"code-keyword\">break</span>;\r\n","                    }\r\n","                }\r\n","            }\r\n","\r\n","            <span class=\"code-keyword\">if</span> (lang)\r\n","                lang = lang.toLowerCase();\r\n","            <span class=\"code-keyword\">else</span>\r\n","                lang = <span class=\"code-string\">\"text\"</span>;\r\n","\r\n","            <span class=\"code-comment\">// Language Name overrides so it displays nicer</span>\r\n","            <span class=\"code-keyword\">if</span> (lang == <span class=\"code-string\">\"ps\"</span>)\r\n","                lang = <span class=\"code-string\">\"powershell\"</span>;\r\n","            <span class=\"code-keyword\">else</span> <span class=\"code-keyword\">if</span> (lang == <span class=\"code-string\">\"cs\"</span>)\r\n","                lang = <span class=\"code-string\">\"csharp\"</span>;\r\n","            <span class=\"code-keyword\">else</span> <span class=\"code-keyword\">if</span> (lang == <span class=\"code-string\">\"js\"</span>)\r\n","                lang = <span class=\"code-string\">\"javascript\"</span>;\r\n","            <span class=\"code-keyword\">else</span> <span class=\"code-keyword\">if</span> (lang == <span class=\"code-string\">\"ts\"</span>)\r\n","                lang = <span class=\"code-string\">\"typescript\"</span>;\r\n","            <span class=\"code-keyword\">else</span> <span class=\"code-keyword\">if</span> (lang == <span class=\"code-string\">\"fox\"</span>)\r\n","                lang = <span class=\"code-string\">\"foxpro\"</span>;\r\n","\r\n","                \r\n","            <span class=\"code-keyword\">var</span> html = hudText.replace(<span class=\"code-string\">\"{{language}}\"</span>, lang)\r\n","                              .replace(<span class=\"code-string\">\"{{copyIconClass}}\"</span>,options.copyIconClass)\r\n","                              .trim();\r\n","\r\n","            <span class=\"code-comment\">// insert the Hud panel</span>\r\n","            <span class=\"code-keyword\">var</span> $newHud = <span class=\"code-built_in\">document</span>.createElement(<span class=\"code-string\">\"div\"</span>);\r\n","            $newHud.innerHTML = html;\r\n","            $newHud = $newHud.querySelector(<span class=\"code-string\">\".code-badge\"</span>);        \r\n","\r\n","            <span class=\"code-comment\">// make &lt;pre&gt; tag position:relative so positioning keeps pinned right</span>\r\n","            <span class=\"code-comment\">// even with scroll bar scrolled</span>\r\n","            <span class=\"code-keyword\">var</span> pre = el.parentElement;            \r\n","            pre.classList.add(<span class=\"code-string\">\"code-badge-pre\"</span>)\r\n","\r\n","            <span class=\"code-keyword\">if</span>(options.copyIconContent)\r\n","              $newHud.querySelector(<span class=\"code-string\">\".code-badge-copy-icon\"</span>).innerText = options.copyIconContent;\r\n","\r\n","            pre.insertBefore($newHud, el);\r\n","        }\r\n","\r\n","        <span class=\"code-keyword\">var</span> $content = <span class=\"code-built_in\">document</span>.querySelector(options.contentSelector);\r\n","\r\n","        <span class=\"code-comment\">// single copy click handler</span>\r\n","        $content.addEventListener(<span class=\"code-string\">\"click\"</span>,\r\n","            <span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\">e</span>) </span>{                               \r\n","                <span class=\"code-keyword\">var</span> $clicked = e.srcElement;\r\n","                <span class=\"code-keyword\">if</span> ($clicked.classList.contains(<span class=\"code-string\">\"code-badge-copy-icon\"</span>)) {\r\n","                    e.preventDefault();\r\n","                    e.cancelBubble = <span class=\"code-literal\">true</span>;\r\n","                    copyCodeToClipboard(e);\r\n","                }\r\n","                <span class=\"code-keyword\">return</span> <span class=\"code-literal\">false</span>;\r\n","            });\r\n","    }\r\n","\r\n","\r\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">copyCodeToClipboard</span>(<span class=\"code-params\">e</span>) </span>{\r\n","        <span class=\"code-comment\">// walk back up to &lt;pre&gt; tag</span>\r\n","        <span class=\"code-keyword\">var</span> $origCode = e.srcElement.parentElement.parentElement.parentElement;\r\n","    \r\n","        <span class=\"code-comment\">// select the &lt;code&gt; tag and grab text</span>\r\n","        <span class=\"code-keyword\">var</span> $code = $origCode.querySelector(<span class=\"code-string\">\"pre&gt;code\"</span>);\r\n","        <span class=\"code-keyword\">var</span> text = $code.textContent || $code.innerText;\r\n","        \r\n","        <span class=\"code-comment\">// Create a textblock and assign the text and add to document</span>\r\n","        <span class=\"code-keyword\">var</span> el = <span class=\"code-built_in\">document</span>.createElement(<span class=\"code-string\">'textarea'</span>);\r\n","        el.value = text.trim();\r\n","        <span class=\"code-built_in\">document</span>.body.appendChild(el);\r\n","        el.style.display = <span class=\"code-string\">\"block\"</span>;\r\n","    \r\n","        <span class=\"code-comment\">// select the entire textblock</span>\r\n","        <span class=\"code-keyword\">if</span> (<span class=\"code-built_in\">window</span>.document.documentMode)\r\n","            el.setSelectionRange(<span class=\"code-number\">0</span>, el.value.length);\r\n","        <span class=\"code-keyword\">else</span>\r\n","            el.select();\r\n","        \r\n","        <span class=\"code-comment\">// copy to clipboard</span>\r\n","        <span class=\"code-built_in\">document</span>.execCommand(<span class=\"code-string\">'copy'</span>);\r\n","        \r\n","        <span class=\"code-comment\">// clean up element</span>\r\n","        <span class=\"code-built_in\">document</span>.body.removeChild(el);\r\n","        \r\n","        <span class=\"code-comment\">// show the check icon (copied) briefly</span>\r\n","        swapIcons($origCode);     \r\n","    }\r\n","\r\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">swapIcons</span>(<span class=\"code-params\">$code</span>) </span>{\r\n","        <span class=\"code-keyword\">var</span> copyIcons = options.copyIconClass.split(<span class=\"code-string\">' '</span>);\r\n","        <span class=\"code-keyword\">var</span> checkIcons = options.checkIconClass.split(<span class=\"code-string\">' '</span>);\r\n","        \r\n","        <span class=\"code-keyword\">var</span> $fa = $code.querySelector(<span class=\"code-string\">\".code-badge-copy-icon\"</span>);\r\n","        $fa.innerText = options.checkIconContent;\r\n","\r\n","        <span class=\"code-keyword\">for</span> (<span class=\"code-keyword\">var</span> i = <span class=\"code-number\">0</span>; i &lt; copyIcons.length; i++)\r\n","            $fa.classList.remove(copyIcons[i]);\r\n","        \r\n","        <span class=\"code-keyword\">for</span> (<span class=\"code-keyword\">var</span> i = <span class=\"code-number\">0</span>; i &lt; checkIcons.length; i++)\r\n","            $fa.classList.add(checkIcons[i]);\r\n","        \r\n","        \r\n","        setTimeout(<span class=\"code-function\"><span class=\"code-keyword\">function</span> (<span class=\"code-params\"></span>) </span>{\r\n","            $fa.innerText = options.copyIconContent;\r\n","\r\n","            <span class=\"code-keyword\">for</span> (<span class=\"code-keyword\">var</span> i = <span class=\"code-number\">0</span>; i &lt; checkIcons.length; i++)\r\n","                $fa.classList.remove(checkIcons[i]);\r\n","            <span class=\"code-keyword\">for</span> (<span class=\"code-keyword\">var</span> i = <span class=\"code-number\">0</span>; i &lt; copyIcons.length; i++)\r\n","                $fa.classList.add(copyIcons[i]);\r\n","        }, <span class=\"code-number\">2000</span>);\r\n","    }\r\n","\r\n","    <span class=\"code-function\"><span class=\"code-keyword\">function</span> <span class=\"code-title\">getTemplate</span>(<span class=\"code-params\"></span>) </span>{\r\n","      <span class=\"code-keyword\">var</span> stringArray =\r\n","      [\r\n","        <span class=\"code-string\">\"&lt;style&gt;\"</span>,\r\n","            <span class=\"code-string\">\"@media print {\"</span>,\r\n","            <span class=\"code-string\">\"   .code-badge { display: none; }\"</span>,\r\n","            <span class=\"code-string\">\"}\"</span>,          \r\n","            <span class=\"code-string\">\"    .code-badge-pre {\"</span>,\r\n","            <span class=\"code-string\">\"        position: relative;\"</span>,\r\n","            <span class=\"code-string\">\"    }\"</span>,\r\n","            <span class=\"code-string\">\"    .code-badge {\"</span>,\r\n","            <span class=\"code-string\">\"        display: flex;\"</span>,\r\n","            <span class=\"code-string\">\"        flex-direction: row;\"</span>,\r\n","            <span class=\"code-string\">\"        white-space: normal;\"</span>,\r\n","            <span class=\"code-string\">\"        background: transparent;\"</span>,\r\n","            <span class=\"code-string\">\"        background: #333;\"</span>,\r\n","            <span class=\"code-string\">\"        color: white;\"</span>,\r\n","            <span class=\"code-string\">\"        font-size: 0.875em;\"</span>,\r\n","            <span class=\"code-string\">\"        opacity: 0.5;\"</span>,\r\n","            <span class=\"code-string\">\"        transition: opacity linear 0.5s;\"</span>,\r\n","            <span class=\"code-string\">\"        border-radius: 0 0 0 7px;\"</span>,\r\n","            <span class=\"code-string\">\"        padding: 5px 8px 5px 8px;\"</span>,\r\n","            <span class=\"code-string\">\"        position: absolute;\"</span>,\r\n","            <span class=\"code-string\">\"        right: 0;\"</span>,\r\n","            <span class=\"code-string\">\"        top: 0;\"</span>,\r\n","            <span class=\"code-string\">\"    }\"</span>,            \r\n","            <span class=\"code-string\">\"    .code-badge.active {\"</span>,\r\n","            <span class=\"code-string\">\"        opacity: 0.8;\"</span>,\r\n","            <span class=\"code-string\">\"    }\"</span>,\r\n","            <span class=\"code-string\">\"\"</span>,\r\n","            <span class=\"code-string\">\"    .code-badge:hover {\"</span>,\r\n","            <span class=\"code-string\">\"        opacity: .95;\"</span>,\r\n","            <span class=\"code-string\">\"    }\"</span>,\r\n","            <span class=\"code-string\">\"\"</span>,\r\n","            <span class=\"code-string\">\"    .code-badge a,\"</span>,\r\n","            <span class=\"code-string\">\"    .code-badge a:hover {\"</span>,\r\n","            <span class=\"code-string\">\"        text-decoration: none;\"</span>,\r\n","            <span class=\"code-string\">\"    }\"</span>,\r\n","            <span class=\"code-string\">\"\"</span>,\r\n","            <span class=\"code-string\">\"    .code-badge-language {\"</span>,\r\n","            <span class=\"code-string\">\"        margin-right: 10px;\"</span>,\r\n","            <span class=\"code-string\">\"        font-weight: 600;\"</span>,\r\n","            <span class=\"code-string\">\"        color: goldenrod;\"</span>,\r\n","            <span class=\"code-string\">\"    }\"</span>,\r\n","            <span class=\"code-string\">\"    .code-badge-copy-icon {\"</span>,\r\n","            <span class=\"code-string\">\"        font-size: 1.2em;\"</span>,\r\n","            <span class=\"code-string\">\"        cursor: pointer;\"</span>,\r\n","            <span class=\"code-string\">\"        padding: 0 7px;\"</span>,\r\n","            <span class=\"code-string\">\"        margin-top:2;\"</span>,\r\n","            <span class=\"code-string\">\"    }\"</span>,\r\n","            <span class=\"code-string\">\"    .fa.text-success:{ color: limegreen !important }\"</span>,\r\n","            <span class=\"code-string\">\"&lt;/style&gt;\"</span>,\r\n","            <span class=\"code-string\">\"&lt;div id=\\\"CodeBadgeTemplate\\\" style=\\\"display:none\\\"&gt;\"</span>,\r\n","            <span class=\"code-string\">\"    &lt;div class=\\\"code-badge\\\"&gt;\"</span>,\r\n","            <span class=\"code-string\">\"        &lt;div class=\\\"code-badge-language\\\" &gt;{{language}}&lt;/div&gt;\"</span>,\r\n","            <span class=\"code-string\">\"        &lt;div  title=\\\"Copy to clipboard\\\"&gt;\"</span>,\r\n","            <span class=\"code-string\">\"            &lt;i class=\\\"{{copyIconClass}} code-badge-copy-icon\\\"&gt;&lt;/i&gt;&lt;/i&gt;&lt;/a&gt;\"</span>,            \r\n","            <span class=\"code-string\">\"        &lt;/div&gt;\"</span>,\r\n","            <span class=\"code-string\">\"     &lt;/div&gt;\"</span>,\r\n","            <span class=\"code-string\">\"&lt;/div&gt;\"</span>\r\n","        ];\r\n","\r\n","        <span class=\"code-keyword\">var</span> t = <span class=\"code-string\">\"\"</span>;\r\n","        <span class=\"code-keyword\">for</span> (<span class=\"code-keyword\">var</span> i = <span class=\"code-number\">0</span>; i &lt; stringArray.length; i++)\r\n","            t += stringArray[i] + <span class=\"code-string\">\"\\n\"</span>;\r\n","\r\n","        <span class=\"code-keyword\">return</span> t;\r\n","    }\r\n","\r\n","    initialize();\r\n","}\r\n","\r\n","\r\n","<span class=\"code-comment\">// global reference Window</span>\r\n","<span class=\"code-built_in\">window</span>.highlightJsBadge = highlightJsBadge;\r\n","\r\n","<span class=\"code-keyword\">if</span> (highlightJsBadgeAutoLoad)\r\n","    highlightJsBadge();\r\n","\r\n","\r\n","}));\r\n","\r\n","\r\n","<span class=\"code-comment\">// You can embed the following into your HTML document</span>\r\n","<span class=\"code-comment\">// to provide your own custom styling.</span>\r\n","\r\n","<span class=\"code-comment\">/*\r\n</span>","<span class=\"code-comment\">&lt;style&gt;\r\n</span>","<span class=\"code-comment\">    \"@media print {\r\n</span>","<span class=\"code-comment\">        .code-badge { display: none; }\r\n</span>","<span class=\"code-comment\">    }\r\n</span>","<span class=\"code-comment\">    .code-badge-pre {\r\n</span>","<span class=\"code-comment\">        position: relative; \r\n</span>","<span class=\"code-comment\">    }\r\n</span>","<span class=\"code-comment\">    .code-badge {\r\n</span>","<span class=\"code-comment\">        display: flex;\r\n</span>","<span class=\"code-comment\">        flex-direction: row;\r\n</span>","<span class=\"code-comment\">        white-space: normal;\r\n</span>","<span class=\"code-comment\">        background: transparent;\r\n</span>","<span class=\"code-comment\">        background: #333;\r\n</span>","<span class=\"code-comment\">        color: white;\r\n</span>","<span class=\"code-comment\">        font-size: 0.875em;\r\n</span>","<span class=\"code-comment\">        opacity: 0.5;\r\n</span>","<span class=\"code-comment\">        border-radius: 0 0 0 7px;\r\n</span>","<span class=\"code-comment\">        padding: 5px 8px 5px 8px;\r\n</span>","<span class=\"code-comment\">        position: absolute;\r\n</span>","<span class=\"code-comment\">        right: 0;\r\n</span>","<span class=\"code-comment\">        top: 0;\r\n</span>","<span class=\"code-comment\">    }\r\n</span>","<span class=\"code-comment\">    .code-badge.active {\r\n</span>","<span class=\"code-comment\">        opacity: 0.8;\r\n</span>","<span class=\"code-comment\">    }\r\n</span>","<span class=\"code-comment\">    .code-badge:hover {\r\n</span>","<span class=\"code-comment\">        opacity: .95;\r\n</span>","<span class=\"code-comment\">    }\r\n</span>","<span class=\"code-comment\">    .code-badge a,\r\n</span>","<span class=\"code-comment\">    .code-badge a:hover {\r\n</span>","<span class=\"code-comment\">        text-decoration: none;\r\n</span>","<span class=\"code-comment\">    }\r\n</span>","<span class=\"code-comment\">\r\n</span>","<span class=\"code-comment\">    .code-badge-language {\r\n</span>","<span class=\"code-comment\">        margin-right: 10px;\r\n</span>","<span class=\"code-comment\">        font-weight: 600;\r\n</span>","<span class=\"code-comment\">        color: goldenrod;\r\n</span>","<span class=\"code-comment\">    }\r\n</span>","<span class=\"code-comment\">    .code-badge-copy-icon {\r\n</span>","<span class=\"code-comment\">        font-size: 1.2em;\r\n</span>","<span class=\"code-comment\">        cursor: pointer;\r\n</span>","<span class=\"code-comment\">        padding: 0 7px;\r\n</span>","<span class=\"code-comment\">        margin-top:2;\r\n</span>","<span class=\"code-comment\">    }\r\n</span>","<span class=\"code-comment\">    .fa.text-success:{ color: limegreen !important}    \r\n</span>","<span class=\"code-comment\">&lt;/style&gt;\r\n</span>","<span class=\"code-comment\">&lt;div id=\"CodeBadgeTemplate\" style=\"display:none\"&gt;\r\n</span>","<span class=\"code-comment\">    &lt;div class=\"code-badge\"&gt;\r\n</span>","<span class=\"code-comment\">        &lt;div class=\"code-badge-language\"&gt;{{language}}&lt;/div&gt;\r\n</span>","<span class=\"code-comment\">        &lt;div title=\"Copy to clipboard\"&gt;\r\n</span>","<span class=\"code-comment\">            &lt;i class=\"{{copyIconClass}} code-badge-copy-icon\"&gt;&lt;/i&gt;\r\n</span>","<span class=\"code-comment\">        &lt;/div&gt;\r\n</span>","<span class=\"code-comment\">     &lt;/div&gt;\r\n</span>","<span class=\"code-comment\">&lt;/div&gt;\r\n</span>","<span class=\"code-comment\">*/</span>\r\n",""]}}}</script></head><body><div id="root"><style data-emotion-css="262b4o">html{box-sizing:border-box;}*,*:before,*:after{box-sizing:inherit;}html,body,#root{height:100%;margin:0;}body{font-family:-apple-system, BlinkMacSystemFont, "Segoe UI", "Roboto", "Oxygen", "Ubuntu", "Cantarell", "Fira Sans", "Droid Sans", "Helvetica Neue", sans-serif;font-size:16px;line-height:1.5;background:white;color:black;}code{font-family:Menlo, Monaco, Lucida Console, Liberation Mono, DejaVu Sans Mono, Bitstream Vera Sans Mono, Courier New, monospace;}th,td{padding:0;}select{font-size:inherit;}#root{display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-flex-direction:column;-ms-flex-direction:column;flex-direction:column;}</style><style data-emotion-css="1r6h1r6">.code-listing{background:#fbfdff;color:#383a42;}.code-comment,.code-quote{color:#a0a1a7;font-style:italic;}.code-doctag,.code-keyword,.code-link,.code-formula{color:#a626a4;}.code-section,.code-name,.code-selector-tag,.code-deletion,.code-subst{color:#e45649;}.code-literal{color:#0184bb;}.code-string,.code-regexp,.code-addition,.code-attribute,.code-meta-string{color:#50a14f;}.code-built_in,.code-class .code-title{color:#c18401;}.code-attr,.code-variable,.code-template-variable,.code-type,.code-selector-class,.code-selector-attr,.code-selector-pseudo,.code-number{color:#986801;}.code-symbol,.code-bullet,.code-meta,.code-selector-id,.code-title{color:#4078f2;}.code-emphasis{font-style:italic;}.code-strong{font-weight:bold;}</style><style data-emotion-css="1c3h18e">.css-1c3h18e{-webkit-flex:1 0 auto;-ms-flex:1 0 auto;flex:1 0 auto;}</style><div class="css-1c3h18e"><style data-emotion-css="1cfuj1t">.css-1cfuj1t{max-width:940px;padding:0 20px;margin:0 auto;}</style><div class="css-1cfuj1t"><style data-emotion-css="xi606m">.css-xi606m{text-align:center;}</style><header class="css-xi606m"><style data-emotion-css="17kjije">.css-17kjije{font-size:3rem;margin-top:2rem;}</style><h1 class="css-17kjije"><style data-emotion-css="1ydg16i">.css-1ydg16i{color:#000;-webkit-text-decoration:none;text-decoration:none;}</style><a href="/" class="css-1ydg16i">UNPKG</a></h1></header><style data-emotion-css="93o42g">.css-93o42g{display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-flex-direction:row;-ms-flex-direction:row;flex-direction:row;-webkit-align-items:center;-webkit-box-align:center;-ms-flex-align:center;align-items:center;}@media (max-width:700px){.css-93o42g{-webkit-flex-direction:column-reverse;-ms-flex-direction:column-reverse;flex-direction:column-reverse;-webkit-align-items:flex-start;-webkit-box-align:flex-start;-ms-flex-align:flex-start;align-items:flex-start;}}</style><header class="css-93o42g"><style data-emotion-css="k4kplh">.css-k4kplh{font-size:1.5rem;font-weight:normal;-webkit-flex:1;-ms-flex:1;flex:1;}</style><h1 class="css-k4kplh"><nav><span><style data-emotion-css="xt128v">.css-xt128v{color:#0076ff;-webkit-text-decoration:none;text-decoration:none;}.css-xt128v:hover{-webkit-text-decoration:underline;text-decoration:underline;}</style><a href="/browse/highlightjs-badge@0.1.6/" class="css-xt128v">highlightjs-badge</a></span><span><style data-emotion-css="lllnmq">.css-lllnmq{padding-left:5px;padding-right:5px;}</style><span class="css-lllnmq">/</span><strong>highlightjs-badge.js</strong></span></nav></h1><style data-emotion-css="1nr3dab">.css-1nr3dab{margin-left:20px;}@media (max-width:700px){.css-1nr3dab{margin-left:0;margin-bottom:0;}}</style><p class="css-1nr3dab"><label>Version:<!-- --> <style data-emotion-css="un3bt6">.css-un3bt6{-webkit-appearance:none;-moz-appearance:none;appearance:none;cursor:pointer;padding:4px 24px 4px 8px;font-weight:600;font-size:0.9em;color:#24292e;border:1px solid rgba(27,31,35,.2);border-radius:3px;background-color:#eff3f6;background-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAKCAYAAAC9vt6cAAAAAXNSR0IArs4c6QAAARFJREFUKBVjZAACNS39RhBNKrh17WI9o4quoT3Dn78HSNUMUs/CzOTI/O7Vi4dCYpJ3/jP+92BkYGAlyiBGhm8MjIxJt65e3MQM0vDu9YvLYmISILYZELOBxHABRkaGr0yMzF23r12YDFIDNgDEePv65SEhEXENBkYGFSAXuyGMjF8Z/jOsvX3tYiFIDwgwQSgIaaijnvj/P8M5IO8HsjiY/f//D4b//88A1SQhywG9jQr09PS4v/1mPAeUUPzP8B8cJowMjL+Bqu6xMQmaXL164AuyDgwDQJLa2qYSP//9vARkCoMVMzK8YeVkNbh+9uxzMB+JwGoASF5Vx0jz/98/18BqmZi171w9D2EjaaYKEwAEK00XQLdJuwAAAABJRU5ErkJggg==);background-position:right 8px center;background-repeat:no-repeat;background-size:auto 25%;}.css-un3bt6:hover{background-color:#e6ebf1;border-color:rgba(27,31,35,.35);}.css-un3bt6:active{background-color:#e9ecef;border-color:rgba(27,31,35,.35);box-shadow:inset 0 0.15em 0.3em rgba(27,31,35,.15);}</style><select name="version" class="css-un3bt6"><option value="0.1.4">0.1.4</option><option value="0.1.5">0.1.5</option><option selected="" value="0.1.6">0.1.6</option></select></label></p></header></div><style data-emotion-css="107j3ms">.css-107j3ms{max-width:940px;padding:0 20px;margin:0 auto;}@media (max-width:700px){.css-107j3ms{padding:0;margin:0;}}</style><div class="css-107j3ms"><style data-emotion-css="q3frg4">.css-q3frg4{border:1px solid #dfe2e5;border-radius:3px;}@media (max-width:700px){.css-q3frg4{border-right-width:0;border-left-width:0;}}</style><div class="css-q3frg4"><style data-emotion-css="10o5omr">.css-10o5omr{padding:10px;background:#f6f8fa;color:#424242;border:1px solid #d1d5da;border-top-left-radius:3px;border-top-right-radius:3px;margin:-1px -1px 0;display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-flex-direction:row;-ms-flex-direction:row;flex-direction:row;-webkit-align-items:center;-webkit-box-align:center;-ms-flex-align:center;align-items:center;-webkit-box-pack:justify;-webkit-justify-content:space-between;-ms-flex-pack:justify;justify-content:space-between;}@media (max-width:700px){.css-10o5omr{padding-right:20px;padding-left:20px;}}</style><div class="css-10o5omr"><span>13.8 kB</span> <span>JavaScript</span> <style data-emotion-css="12cxnkg">.css-12cxnkg{display:inline-block;-webkit-text-decoration:none;text-decoration:none;padding:2px 8px;font-weight:600;font-size:0.9rem;color:#24292e;background-color:#eff3f6;border:1px solid rgba(27,31,35,.2);border-radius:3px;}.css-12cxnkg:hover{background-color:#e6ebf1;border-color:rgba(27,31,35,.35);}.css-12cxnkg:active{background-color:#e9ecef;border-color:rgba(27,31,35,.35);box-shadow:inset 0 0.15em 0.3em rgba(27,31,35,.15);}</style><a title="highlightjs-badge.js" href="/highlightjs-badge@0.1.6/highlightjs-badge.js" class="css-12cxnkg">View Raw</a></div><style data-emotion-css="1i31ihw">.css-1i31ihw{overflow-x:auto;overflow-y:hidden;padding-top:5px;padding-bottom:5px;}</style><div class="code-listing css-1i31ihw"><style data-emotion-css="173nir8">.css-173nir8{border:none;border-collapse:collapse;border-spacing:0;}</style><table class="css-173nir8"><tbody><tr><style data-emotion-css="a4x74f">.css-a4x74f{padding-left:10px;padding-right:10px;color:rgba(27,31,35,.3);text-align:right;vertical-align:top;width:1%;min-width:50px;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;}</style><td id="L1" class="css-a4x74f"><span>1</span></td><style data-emotion-css="1dcdqdg">.css-1dcdqdg{padding-left:10px;padding-right:10px;color:#24292e;white-space:pre;}</style><td id="LC1" class="css-1dcdqdg"><code><span class="code-meta">"use strict"</span>;
</code></td></tr><tr><td id="L2" class="css-a4x74f"><span>2</span></td><td id="LC2" class="css-1dcdqdg"><code><span class="code-comment">/*
</span></code></td></tr><tr><td id="L3" class="css-a4x74f"><span>3</span></td><td id="LC3" class="css-1dcdqdg"><code><span class="code-comment">----------------------------------------
</span></code></td></tr><tr><td id="L4" class="css-a4x74f"><span>4</span></td><td id="LC4" class="css-1dcdqdg"><code><span class="code-comment">highlightJs Badge
</span></code></td></tr><tr><td id="L5" class="css-a4x74f"><span>5</span></td><td id="LC5" class="css-1dcdqdg"><code><span class="code-comment">----------------------------------------
</span></code></td></tr><tr><td id="L6" class="css-a4x74f"><span>6</span></td><td id="LC6" class="css-1dcdqdg"><code><span class="code-comment">
</span></code></td></tr><tr><td id="L7" class="css-a4x74f"><span>7</span></td><td id="LC7" class="css-1dcdqdg"><code><span class="code-comment">A copy code and language display badge
</span></code></td></tr><tr><td id="L8" class="css-a4x74f"><span>8</span></td><td id="LC8" class="css-1dcdqdg"><code><span class="code-comment">for the highlightJs Syntax highlighter.
</span></code></td></tr><tr><td id="L9" class="css-a4x74f"><span>9</span></td><td id="LC9" class="css-1dcdqdg"><code><span class="code-comment">
</span></code></td></tr><tr><td id="L10" class="css-a4x74f"><span>10</span></td><td id="LC10" class="css-1dcdqdg"><code><span class="code-comment">by Rick Strahl, 2019-2020
</span></code></td></tr><tr><td id="L11" class="css-a4x74f"><span>11</span></td><td id="LC11" class="css-1dcdqdg"><code><span class="code-comment">License: MIT
</span></code></td></tr><tr><td id="L12" class="css-a4x74f"><span>12</span></td><td id="LC12" class="css-1dcdqdg"><code><span class="code-comment">
</span></code></td></tr><tr><td id="L13" class="css-a4x74f"><span>13</span></td><td id="LC13" class="css-1dcdqdg"><code><span class="code-comment">Make sure this script is loaded last in your
</span></code></td></tr><tr><td id="L14" class="css-a4x74f"><span>14</span></td><td id="LC14" class="css-1dcdqdg"><code><span class="code-comment">script loading.
</span></code></td></tr><tr><td id="L15" class="css-a4x74f"><span>15</span></td><td id="LC15" class="css-1dcdqdg"><code><span class="code-comment">
</span></code></td></tr><tr><td id="L16" class="css-a4x74f"><span>16</span></td><td id="LC16" class="css-1dcdqdg"><code><span class="code-comment">Usage:
</span></code></td></tr><tr><td id="L17" class="css-a4x74f"><span>17</span></td><td id="LC17" class="css-1dcdqdg"><code><span class="code-comment">------
</span></code></td></tr><tr><td id="L18" class="css-a4x74f"><span>18</span></td><td id="LC18" class="css-1dcdqdg"><code><span class="code-comment">Load `highlightjs-badge.js` after `highlight.js`:
</span></code></td></tr><tr><td id="L19" class="css-a4x74f"><span>19</span></td><td id="LC19" class="css-1dcdqdg"><code><span class="code-comment">
</span></code></td></tr><tr><td id="L20" class="css-a4x74f"><span>20</span></td><td id="LC20" class="css-1dcdqdg"><code><span class="code-comment">```js
</span></code></td></tr><tr><td id="L21" class="css-a4x74f"><span>21</span></td><td id="LC21" class="css-1dcdqdg"><code><span class="code-comment">&lt;link href="highlightjs/styles/vs2015.css" rel="stylesheet"&gt;
</span></code></td></tr><tr><td id="L22" class="css-a4x74f"><span>22</span></td><td id="LC22" class="css-1dcdqdg"><code><span class="code-comment">&lt;script src="highlighjs/highlight.pack.js"&gt;&lt;/script&gt;
</span></code></td></tr><tr><td id="L23" class="css-a4x74f"><span>23</span></td><td id="LC23" class="css-1dcdqdg"><code><span class="code-comment">
</span></code></td></tr><tr><td id="L24" class="css-a4x74f"><span>24</span></td><td id="LC24" class="css-1dcdqdg"><code><span class="code-comment">&lt;script src="highlightjs-badge.js"&gt;&lt;/script&gt;  
</span></code></td></tr><tr><td id="L25" class="css-a4x74f"><span>25</span></td><td id="LC25" class="css-1dcdqdg"><code><span class="code-comment">&lt;script&gt;
</span></code></td></tr><tr><td id="L26" class="css-a4x74f"><span>26</span></td><td id="LC26" class="css-1dcdqdg"><code><span class="code-comment">    setTimeout(function () {
</span></code></td></tr><tr><td id="L27" class="css-a4x74f"><span>27</span></td><td id="LC27" class="css-1dcdqdg"><code><span class="code-comment">        var pres = document.querySelectorAll("pre&gt;code");
</span></code></td></tr><tr><td id="L28" class="css-a4x74f"><span>28</span></td><td id="LC28" class="css-1dcdqdg"><code><span class="code-comment">        for (var i = 0; i &lt; pres.length; i++) {
</span></code></td></tr><tr><td id="L29" class="css-a4x74f"><span>29</span></td><td id="LC29" class="css-1dcdqdg"><code><span class="code-comment">            hljs.highlightBlock(pres[i]);
</span></code></td></tr><tr><td id="L30" class="css-a4x74f"><span>30</span></td><td id="LC30" class="css-1dcdqdg"><code><span class="code-comment">        }
</span></code></td></tr><tr><td id="L31" class="css-a4x74f"><span>31</span></td><td id="LC31" class="css-1dcdqdg"><code><span class="code-comment">        var options = {
</span></code></td></tr><tr><td id="L32" class="css-a4x74f"><span>32</span></td><td id="LC32" class="css-1dcdqdg"><code><span class="code-comment">            contentSelector: "#ArticleBody",
</span></code></td></tr><tr><td id="L33" class="css-a4x74f"><span>33</span></td><td id="LC33" class="css-1dcdqdg"><code><span class="code-comment">            // Delay in ms used for `setTimeout` before badging is applied
</span></code></td></tr><tr><td id="L34" class="css-a4x74f"><span>34</span></td><td id="LC34" class="css-1dcdqdg"><code><span class="code-comment">            // Use if you need to time highlighting and badge application
</span></code></td></tr><tr><td id="L35" class="css-a4x74f"><span>35</span></td><td id="LC35" class="css-1dcdqdg"><code><span class="code-comment">            // since the badges need to be applied afterwards.
</span></code></td></tr><tr><td id="L36" class="css-a4x74f"><span>36</span></td><td id="LC36" class="css-1dcdqdg"><code><span class="code-comment">            // 0 - direct execution (ie. you handle timing
</span></code></td></tr><tr><td id="L37" class="css-a4x74f"><span>37</span></td><td id="LC37" class="css-1dcdqdg"><code><span class="code-comment">            loadDelay:0,
</span></code></td></tr><tr><td id="L38" class="css-a4x74f"><span>38</span></td><td id="LC38" class="css-1dcdqdg"><code><span class="code-comment">
</span></code></td></tr><tr><td id="L39" class="css-a4x74f"><span>39</span></td><td id="LC39" class="css-1dcdqdg"><code><span class="code-comment">            // CSS class(es) used to render the copy icon.
</span></code></td></tr><tr><td id="L40" class="css-a4x74f"><span>40</span></td><td id="LC40" class="css-1dcdqdg"><code><span class="code-comment">            copyIconClass: "fa fa-copy",
</span></code></td></tr><tr><td id="L41" class="css-a4x74f"><span>41</span></td><td id="LC41" class="css-1dcdqdg"><code><span class="code-comment">            // CSS class(es) used to render the done icon.
</span></code></td></tr><tr><td id="L42" class="css-a4x74f"><span>42</span></td><td id="LC42" class="css-1dcdqdg"><code><span class="code-comment">            checkIconClass: "fa fa-check text-success"
</span></code></td></tr><tr><td id="L43" class="css-a4x74f"><span>43</span></td><td id="LC43" class="css-1dcdqdg"><code><span class="code-comment">        };
</span></code></td></tr><tr><td id="L44" class="css-a4x74f"><span>44</span></td><td id="LC44" class="css-1dcdqdg"><code><span class="code-comment">        window.highlightJsBadge(options);
</span></code></td></tr><tr><td id="L45" class="css-a4x74f"><span>45</span></td><td id="LC45" class="css-1dcdqdg"><code><span class="code-comment">    },10);
</span></code></td></tr><tr><td id="L46" class="css-a4x74f"><span>46</span></td><td id="LC46" class="css-1dcdqdg"><code><span class="code-comment">&lt;/script&gt;
</span></code></td></tr><tr><td id="L47" class="css-a4x74f"><span>47</span></td><td id="LC47" class="css-1dcdqdg"><code><span class="code-comment">```
</span></code></td></tr><tr><td id="L48" class="css-a4x74f"><span>48</span></td><td id="LC48" class="css-1dcdqdg"><code><span class="code-comment">
</span></code></td></tr><tr><td id="L49" class="css-a4x74f"><span>49</span></td><td id="LC49" class="css-1dcdqdg"><code><span class="code-comment">The script contains the template and CSS so nothing
</span></code></td></tr><tr><td id="L50" class="css-a4x74f"><span>50</span></td><td id="LC50" class="css-1dcdqdg"><code><span class="code-comment">else is needed to run it.
</span></code></td></tr><tr><td id="L51" class="css-a4x74f"><span>51</span></td><td id="LC51" class="css-1dcdqdg"><code><span class="code-comment">
</span></code></td></tr><tr><td id="L52" class="css-a4x74f"><span>52</span></td><td id="LC52" class="css-1dcdqdg"><code><span class="code-comment">Customization:
</span></code></td></tr><tr><td id="L53" class="css-a4x74f"><span>53</span></td><td id="LC53" class="css-1dcdqdg"><code><span class="code-comment">--------------
</span></code></td></tr><tr><td id="L54" class="css-a4x74f"><span>54</span></td><td id="LC54" class="css-1dcdqdg"><code><span class="code-comment">This code automatically embeds styling and the template.
</span></code></td></tr><tr><td id="L55" class="css-a4x74f"><span>55</span></td><td id="LC55" class="css-1dcdqdg"><code><span class="code-comment">
</span></code></td></tr><tr><td id="L56" class="css-a4x74f"><span>56</span></td><td id="LC56" class="css-1dcdqdg"><code><span class="code-comment">If you want to customize you can either create a template
</span></code></td></tr><tr><td id="L57" class="css-a4x74f"><span>57</span></td><td id="LC57" class="css-1dcdqdg"><code><span class="code-comment">in your HTML **using the code at the end of this file**.
</span></code></td></tr><tr><td id="L58" class="css-a4x74f"><span>58</span></td><td id="LC58" class="css-1dcdqdg"><code><span class="code-comment">
</span></code></td></tr><tr><td id="L59" class="css-a4x74f"><span>59</span></td><td id="LC59" class="css-1dcdqdg"><code><span class="code-comment">Alternately you can customize the `getTemplate()` function
</span></code></td></tr><tr><td id="L60" class="css-a4x74f"><span>60</span></td><td id="LC60" class="css-1dcdqdg"><code><span class="code-comment">that renders the code from a string and keep it self contained
</span></code></td></tr><tr><td id="L61" class="css-a4x74f"><span>61</span></td><td id="LC61" class="css-1dcdqdg"><code><span class="code-comment">within this script.
</span></code></td></tr><tr><td id="L62" class="css-a4x74f"><span>62</span></td><td id="LC62" class="css-1dcdqdg"><code><span class="code-comment">
</span></code></td></tr><tr><td id="L63" class="css-a4x74f"><span>63</span></td><td id="LC63" class="css-1dcdqdg"><code><span class="code-comment">Requirements:
</span></code></td></tr><tr><td id="L64" class="css-a4x74f"><span>64</span></td><td id="LC64" class="css-1dcdqdg"><code><span class="code-comment">-------------
</span></code></td></tr><tr><td id="L65" class="css-a4x74f"><span>65</span></td><td id="LC65" class="css-1dcdqdg"><code><span class="code-comment">Uses some ES6 features so won't work in IE without shims:
</span></code></td></tr><tr><td id="L66" class="css-a4x74f"><span>66</span></td><td id="LC66" class="css-1dcdqdg"><code><span class="code-comment">
</span></code></td></tr><tr><td id="L67" class="css-a4x74f"><span>67</span></td><td id="LC67" class="css-1dcdqdg"><code><span class="code-comment">* Object.assign
</span></code></td></tr><tr><td id="L68" class="css-a4x74f"><span>68</span></td><td id="LC68" class="css-1dcdqdg"><code><span class="code-comment">* String.trim
</span></code></td></tr><tr><td id="L69" class="css-a4x74f"><span>69</span></td><td id="LC69" class="css-1dcdqdg"><code><span class="code-comment">
</span></code></td></tr><tr><td id="L70" class="css-a4x74f"><span>70</span></td><td id="LC70" class="css-1dcdqdg"><code><span class="code-comment">*/</span>
</code></td></tr><tr><td id="L71" class="css-a4x74f"><span>71</span></td><td id="LC71" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L72" class="css-a4x74f"><span>72</span></td><td id="LC72" class="css-1dcdqdg"><code><span class="code-comment">// module header</span>
</code></td></tr><tr><td id="L73" class="css-a4x74f"><span>73</span></td><td id="LC73" class="css-1dcdqdg"><code>(<span class="code-function"><span class="code-keyword">function</span>(<span class="code-params"> global, factory </span>) </span>{
</code></td></tr><tr><td id="L74" class="css-a4x74f"><span>74</span></td><td id="LC74" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L75" class="css-a4x74f"><span>75</span></td><td id="LC75" class="css-1dcdqdg"><code>	<span class="code-keyword">if</span> ( <span class="code-keyword">typeof</span> <span class="code-built_in">module</span> === <span class="code-string">"object"</span> &amp;&amp; <span class="code-keyword">typeof</span> <span class="code-built_in">module</span>.exports === <span class="code-string">"object"</span> ) {
</code></td></tr><tr><td id="L76" class="css-a4x74f"><span>76</span></td><td id="LC76" class="css-1dcdqdg"><code>		<span class="code-comment">// For CommonJS and CommonJS-like environments where a proper `window`</span>
</code></td></tr><tr><td id="L77" class="css-a4x74f"><span>77</span></td><td id="LC77" class="css-1dcdqdg"><code>		<span class="code-comment">// is present, execute the factory		</span>
</code></td></tr><tr><td id="L78" class="css-a4x74f"><span>78</span></td><td id="LC78" class="css-1dcdqdg"><code>		<span class="code-built_in">module</span>.exports = global.document ?
</code></td></tr><tr><td id="L79" class="css-a4x74f"><span>79</span></td><td id="LC79" class="css-1dcdqdg"><code>			factory( global, <span class="code-literal">true</span> ) :
</code></td></tr><tr><td id="L80" class="css-a4x74f"><span>80</span></td><td id="LC80" class="css-1dcdqdg"><code>			<span class="code-function"><span class="code-keyword">function</span>(<span class="code-params"> w </span>) </span>{
</code></td></tr><tr><td id="L81" class="css-a4x74f"><span>81</span></td><td id="LC81" class="css-1dcdqdg"><code>				<span class="code-keyword">if</span> ( !w.document ) {
</code></td></tr><tr><td id="L82" class="css-a4x74f"><span>82</span></td><td id="LC82" class="css-1dcdqdg"><code>					<span class="code-keyword">throw</span> <span class="code-keyword">new</span> <span class="code-built_in">Error</span>( <span class="code-string">"A window with a document is required"</span> );
</code></td></tr><tr><td id="L83" class="css-a4x74f"><span>83</span></td><td id="LC83" class="css-1dcdqdg"><code>				}
</code></td></tr><tr><td id="L84" class="css-a4x74f"><span>84</span></td><td id="LC84" class="css-1dcdqdg"><code>				<span class="code-keyword">return</span> factory( w );
</code></td></tr><tr><td id="L85" class="css-a4x74f"><span>85</span></td><td id="LC85" class="css-1dcdqdg"><code>			};
</code></td></tr><tr><td id="L86" class="css-a4x74f"><span>86</span></td><td id="LC86" class="css-1dcdqdg"><code>	} <span class="code-keyword">else</span> {
</code></td></tr><tr><td id="L87" class="css-a4x74f"><span>87</span></td><td id="LC87" class="css-1dcdqdg"><code>		factory( global );
</code></td></tr><tr><td id="L88" class="css-a4x74f"><span>88</span></td><td id="LC88" class="css-1dcdqdg"><code>	}
</code></td></tr><tr><td id="L89" class="css-a4x74f"><span>89</span></td><td id="LC89" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L90" class="css-a4x74f"><span>90</span></td><td id="LC90" class="css-1dcdqdg"><code><span class="code-comment">// Pass this if window is not defined yet</span>
</code></td></tr><tr><td id="L91" class="css-a4x74f"><span>91</span></td><td id="LC91" class="css-1dcdqdg"><code>}(<span class="code-keyword">typeof</span> <span class="code-built_in">window</span> !== <span class="code-string">"undefined"</span> ? <span class="code-built_in">window</span> : <span class="code-keyword">this</span>, <span class="code-function"><span class="code-keyword">function</span>(<span class="code-params"> window, noGlobal </span>) </span>{
</code></td></tr><tr><td id="L92" class="css-a4x74f"><span>92</span></td><td id="LC92" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L93" class="css-a4x74f"><span>93</span></td><td id="LC93" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L94" class="css-a4x74f"><span>94</span></td><td id="LC94" class="css-1dcdqdg"><code>    
</code></td></tr><tr><td id="L95" class="css-a4x74f"><span>95</span></td><td id="LC95" class="css-1dcdqdg"><code><span class="code-keyword">if</span> (<span class="code-keyword">typeof</span> highlightJsBadgeAutoLoad !== <span class="code-string">'boolean'</span>)
</code></td></tr><tr><td id="L96" class="css-a4x74f"><span>96</span></td><td id="LC96" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> highlightJsBadgeAutoLoad = <span class="code-literal">false</span>;
</code></td></tr><tr><td id="L97" class="css-a4x74f"><span>97</span></td><td id="LC97" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L98" class="css-a4x74f"><span>98</span></td><td id="LC98" class="css-1dcdqdg"><code><span class="code-function"><span class="code-keyword">function</span> <span class="code-title">highlightJsBadge</span>(<span class="code-params">opt</span>) </span>{
</code></td></tr><tr><td id="L99" class="css-a4x74f"><span>99</span></td><td id="LC99" class="css-1dcdqdg"><code>    <span class="code-keyword">var</span> options = {
</code></td></tr><tr><td id="L100" class="css-a4x74f"><span>100</span></td><td id="LC100" class="css-1dcdqdg"><code>        <span class="code-comment">// the selector for the badge template</span>
</code></td></tr><tr><td id="L101" class="css-a4x74f"><span>101</span></td><td id="LC101" class="css-1dcdqdg"><code>        templateSelector: <span class="code-string">"#CodeBadgeTemplate"</span>,
</code></td></tr><tr><td id="L102" class="css-a4x74f"><span>102</span></td><td id="LC102" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L103" class="css-a4x74f"><span>103</span></td><td id="LC103" class="css-1dcdqdg"><code>        <span class="code-comment">// base content selector that is searched for snippets</span>
</code></td></tr><tr><td id="L104" class="css-a4x74f"><span>104</span></td><td id="LC104" class="css-1dcdqdg"><code>        contentSelector: <span class="code-string">"body"</span>,
</code></td></tr><tr><td id="L105" class="css-a4x74f"><span>105</span></td><td id="LC105" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L106" class="css-a4x74f"><span>106</span></td><td id="LC106" class="css-1dcdqdg"><code>        <span class="code-comment">// Delay in ms used for `setTimeout` before badging is applied</span>
</code></td></tr><tr><td id="L107" class="css-a4x74f"><span>107</span></td><td id="LC107" class="css-1dcdqdg"><code>        <span class="code-comment">// Use if you need to time highlighting and badge application</span>
</code></td></tr><tr><td id="L108" class="css-a4x74f"><span>108</span></td><td id="LC108" class="css-1dcdqdg"><code>        <span class="code-comment">// since the badges need to be applied afterwards.</span>
</code></td></tr><tr><td id="L109" class="css-a4x74f"><span>109</span></td><td id="LC109" class="css-1dcdqdg"><code>        <span class="code-comment">// 0 - direct execution (ie. you handle timing</span>
</code></td></tr><tr><td id="L110" class="css-a4x74f"><span>110</span></td><td id="LC110" class="css-1dcdqdg"><code>        loadDelay: <span class="code-number">0</span>,
</code></td></tr><tr><td id="L111" class="css-a4x74f"><span>111</span></td><td id="LC111" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L112" class="css-a4x74f"><span>112</span></td><td id="LC112" class="css-1dcdqdg"><code>        <span class="code-comment">// CSS class(es) used to render the copy icon.</span>
</code></td></tr><tr><td id="L113" class="css-a4x74f"><span>113</span></td><td id="LC113" class="css-1dcdqdg"><code>        copyIconClass: <span class="code-string">"fa fa-copy"</span>,     
</code></td></tr><tr><td id="L114" class="css-a4x74f"><span>114</span></td><td id="LC114" class="css-1dcdqdg"><code>        <span class="code-comment">// optional content for icons class (&lt;i class="fa fa-copy"&gt;&lt;/i&gt; or &lt;i class="material-icons"&gt;file_copy&lt;/i&gt;)</span>
</code></td></tr><tr><td id="L115" class="css-a4x74f"><span>115</span></td><td id="LC115" class="css-1dcdqdg"><code>        copyIconContent: <span class="code-string">""</span>,
</code></td></tr><tr><td id="L116" class="css-a4x74f"><span>116</span></td><td id="LC116" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L117" class="css-a4x74f"><span>117</span></td><td id="LC117" class="css-1dcdqdg"><code>        <span class="code-comment">// CSS class(es) used to render the done icon.</span>
</code></td></tr><tr><td id="L118" class="css-a4x74f"><span>118</span></td><td id="LC118" class="css-1dcdqdg"><code>        checkIconClass: <span class="code-string">"fa fa-check text-success"</span>,
</code></td></tr><tr><td id="L119" class="css-a4x74f"><span>119</span></td><td id="LC119" class="css-1dcdqdg"><code>        checkIconContent: <span class="code-string">""</span>  
</code></td></tr><tr><td id="L120" class="css-a4x74f"><span>120</span></td><td id="LC120" class="css-1dcdqdg"><code>    };
</code></td></tr><tr><td id="L121" class="css-a4x74f"><span>121</span></td><td id="LC121" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L122" class="css-a4x74f"><span>122</span></td><td id="LC122" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">initialize</span>(<span class="code-params">opt</span>) </span>{
</code></td></tr><tr><td id="L123" class="css-a4x74f"><span>123</span></td><td id="LC123" class="css-1dcdqdg"><code>        <span class="code-built_in">Object</span>.assign(options, opt);
</code></td></tr><tr><td id="L124" class="css-a4x74f"><span>124</span></td><td id="LC124" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L125" class="css-a4x74f"><span>125</span></td><td id="LC125" class="css-1dcdqdg"><code>        <span class="code-keyword">if</span> (<span class="code-built_in">document</span>.readyState == <span class="code-string">'loading'</span>)
</code></td></tr><tr><td id="L126" class="css-a4x74f"><span>126</span></td><td id="LC126" class="css-1dcdqdg"><code>            <span class="code-built_in">document</span>.addEventListener(<span class="code-string">"DOMContentLoaded"</span>, load);
</code></td></tr><tr><td id="L127" class="css-a4x74f"><span>127</span></td><td id="LC127" class="css-1dcdqdg"><code>        <span class="code-keyword">else</span>
</code></td></tr><tr><td id="L128" class="css-a4x74f"><span>128</span></td><td id="LC128" class="css-1dcdqdg"><code>            load();
</code></td></tr><tr><td id="L129" class="css-a4x74f"><span>129</span></td><td id="LC129" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L130" class="css-a4x74f"><span>130</span></td><td id="LC130" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L131" class="css-a4x74f"><span>131</span></td><td id="LC131" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L132" class="css-a4x74f"><span>132</span></td><td id="LC132" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">load</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L133" class="css-a4x74f"><span>133</span></td><td id="LC133" class="css-1dcdqdg"><code>        <span class="code-keyword">if</span> (options.loadDelay)
</code></td></tr><tr><td id="L134" class="css-a4x74f"><span>134</span></td><td id="LC134" class="css-1dcdqdg"><code>            setTimeout(addCodeBadge, loadDelay);
</code></td></tr><tr><td id="L135" class="css-a4x74f"><span>135</span></td><td id="LC135" class="css-1dcdqdg"><code>        <span class="code-keyword">else</span>
</code></td></tr><tr><td id="L136" class="css-a4x74f"><span>136</span></td><td id="LC136" class="css-1dcdqdg"><code>            addCodeBadge();
</code></td></tr><tr><td id="L137" class="css-a4x74f"><span>137</span></td><td id="LC137" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L138" class="css-a4x74f"><span>138</span></td><td id="LC138" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L139" class="css-a4x74f"><span>139</span></td><td id="LC139" class="css-1dcdqdg"><code>  <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">addCodeBadge</span>(<span class="code-params"></span>) </span>{      
</code></td></tr><tr><td id="L140" class="css-a4x74f"><span>140</span></td><td id="LC140" class="css-1dcdqdg"><code>        <span class="code-comment">// first make sure the template exists - if not we embed it</span>
</code></td></tr><tr><td id="L141" class="css-a4x74f"><span>141</span></td><td id="LC141" class="css-1dcdqdg"><code>        <span class="code-keyword">if</span> (!<span class="code-built_in">document</span>.querySelector(options.templateSelector)) {
</code></td></tr><tr><td id="L142" class="css-a4x74f"><span>142</span></td><td id="LC142" class="css-1dcdqdg"><code>            <span class="code-keyword">var</span> node = <span class="code-built_in">document</span>.createElement(<span class="code-string">"div"</span>);
</code></td></tr><tr><td id="L143" class="css-a4x74f"><span>143</span></td><td id="LC143" class="css-1dcdqdg"><code>            node.innerHTML = getTemplate();            
</code></td></tr><tr><td id="L144" class="css-a4x74f"><span>144</span></td><td id="LC144" class="css-1dcdqdg"><code>            <span class="code-keyword">var</span> style = node.querySelector(<span class="code-string">"style"</span>);
</code></td></tr><tr><td id="L145" class="css-a4x74f"><span>145</span></td><td id="LC145" class="css-1dcdqdg"><code>            <span class="code-keyword">var</span> template = node.querySelector(options.templateSelector);
</code></td></tr><tr><td id="L146" class="css-a4x74f"><span>146</span></td><td id="LC146" class="css-1dcdqdg"><code>            <span class="code-built_in">document</span>.body.appendChild(style);
</code></td></tr><tr><td id="L147" class="css-a4x74f"><span>147</span></td><td id="LC147" class="css-1dcdqdg"><code>            <span class="code-built_in">document</span>.body.appendChild(template);
</code></td></tr><tr><td id="L148" class="css-a4x74f"><span>148</span></td><td id="LC148" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L149" class="css-a4x74f"><span>149</span></td><td id="LC149" class="css-1dcdqdg"><code>      
</code></td></tr><tr><td id="L150" class="css-a4x74f"><span>150</span></td><td id="LC150" class="css-1dcdqdg"><code>        <span class="code-keyword">var</span> hudText = <span class="code-built_in">document</span>.querySelector(options.templateSelector).innerHTML;
</code></td></tr><tr><td id="L151" class="css-a4x74f"><span>151</span></td><td id="LC151" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L152" class="css-a4x74f"><span>152</span></td><td id="LC152" class="css-1dcdqdg"><code>        <span class="code-keyword">var</span> $codes = <span class="code-built_in">document</span>.querySelectorAll(<span class="code-string">"pre&gt;code.hljs"</span>);        
</code></td></tr><tr><td id="L153" class="css-a4x74f"><span>153</span></td><td id="LC153" class="css-1dcdqdg"><code>        <span class="code-keyword">for</span> (<span class="code-keyword">var</span> index = <span class="code-number">0</span>; index &lt; $codes.length; index++) {
</code></td></tr><tr><td id="L154" class="css-a4x74f"><span>154</span></td><td id="LC154" class="css-1dcdqdg"><code>            <span class="code-keyword">var</span> el = $codes[index];
</code></td></tr><tr><td id="L155" class="css-a4x74f"><span>155</span></td><td id="LC155" class="css-1dcdqdg"><code>            <span class="code-keyword">if</span> (el.querySelector(<span class="code-string">".code-badge"</span>))
</code></td></tr><tr><td id="L156" class="css-a4x74f"><span>156</span></td><td id="LC156" class="css-1dcdqdg"><code>                <span class="code-keyword">continue</span>; <span class="code-comment">// already exists</span>
</code></td></tr><tr><td id="L157" class="css-a4x74f"><span>157</span></td><td id="LC157" class="css-1dcdqdg"><code>                       
</code></td></tr><tr><td id="L158" class="css-a4x74f"><span>158</span></td><td id="LC158" class="css-1dcdqdg"><code>            <span class="code-keyword">var</span> lang = <span class="code-string">""</span>;
</code></td></tr><tr><td id="L159" class="css-a4x74f"><span>159</span></td><td id="LC159" class="css-1dcdqdg"><code>            
</code></td></tr><tr><td id="L160" class="css-a4x74f"><span>160</span></td><td id="LC160" class="css-1dcdqdg"><code>            <span class="code-keyword">for</span> (<span class="code-keyword">var</span> i = <span class="code-number">0</span>; i &lt; el.classList.length; i++) {
</code></td></tr><tr><td id="L161" class="css-a4x74f"><span>161</span></td><td id="LC161" class="css-1dcdqdg"><code>                <span class="code-keyword">var</span> cl = el.classList[i];
</code></td></tr><tr><td id="L162" class="css-a4x74f"><span>162</span></td><td id="LC162" class="css-1dcdqdg"><code>                <span class="code-comment">// class="hljs language-csharp"</span>
</code></td></tr><tr><td id="L163" class="css-a4x74f"><span>163</span></td><td id="LC163" class="css-1dcdqdg"><code>                <span class="code-keyword">if</span> (cl.substr(<span class="code-number">0</span>, <span class="code-number">9</span>) === <span class="code-string">'language-'</span>) {
</code></td></tr><tr><td id="L164" class="css-a4x74f"><span>164</span></td><td id="LC164" class="css-1dcdqdg"><code>                    lang = el.classList[i].replace(<span class="code-string">'language-'</span>, <span class="code-string">''</span>);
</code></td></tr><tr><td id="L165" class="css-a4x74f"><span>165</span></td><td id="LC165" class="css-1dcdqdg"><code>                    <span class="code-keyword">break</span>;
</code></td></tr><tr><td id="L166" class="css-a4x74f"><span>166</span></td><td id="LC166" class="css-1dcdqdg"><code>                }
</code></td></tr><tr><td id="L167" class="css-a4x74f"><span>167</span></td><td id="LC167" class="css-1dcdqdg"><code>                <span class="code-comment">// class="hljs lang-cs"  // docFx</span>
</code></td></tr><tr><td id="L168" class="css-a4x74f"><span>168</span></td><td id="LC168" class="css-1dcdqdg"><code>                <span class="code-keyword">else</span> <span class="code-keyword">if</span> (cl.substr(<span class="code-number">0</span>, <span class="code-number">5</span>) === <span class="code-string">'lang-'</span>) {
</code></td></tr><tr><td id="L169" class="css-a4x74f"><span>169</span></td><td id="LC169" class="css-1dcdqdg"><code>                    lang = el.classList[i].replace(<span class="code-string">'lang-'</span>, <span class="code-string">''</span>);
</code></td></tr><tr><td id="L170" class="css-a4x74f"><span>170</span></td><td id="LC170" class="css-1dcdqdg"><code>                    <span class="code-keyword">break</span>;
</code></td></tr><tr><td id="L171" class="css-a4x74f"><span>171</span></td><td id="LC171" class="css-1dcdqdg"><code>                }
</code></td></tr><tr><td id="L172" class="css-a4x74f"><span>172</span></td><td id="LC172" class="css-1dcdqdg"><code>                <span class="code-comment">// class="kotlin hljs"   (auto detected)</span>
</code></td></tr><tr><td id="L173" class="css-a4x74f"><span>173</span></td><td id="LC173" class="css-1dcdqdg"><code>                <span class="code-keyword">if</span> (!lang) {
</code></td></tr><tr><td id="L174" class="css-a4x74f"><span>174</span></td><td id="LC174" class="css-1dcdqdg"><code>                    <span class="code-keyword">for</span> (<span class="code-keyword">var</span> j = <span class="code-number">0</span>; j &lt; el.classList.length; j++) {
</code></td></tr><tr><td id="L175" class="css-a4x74f"><span>175</span></td><td id="LC175" class="css-1dcdqdg"><code>                        <span class="code-keyword">if</span> (el.classList[j] == <span class="code-string">'hljs'</span>)
</code></td></tr><tr><td id="L176" class="css-a4x74f"><span>176</span></td><td id="LC176" class="css-1dcdqdg"><code>                            <span class="code-keyword">continue</span>;
</code></td></tr><tr><td id="L177" class="css-a4x74f"><span>177</span></td><td id="LC177" class="css-1dcdqdg"><code>                        lang = el.classList[j];
</code></td></tr><tr><td id="L178" class="css-a4x74f"><span>178</span></td><td id="LC178" class="css-1dcdqdg"><code>                        <span class="code-keyword">break</span>;
</code></td></tr><tr><td id="L179" class="css-a4x74f"><span>179</span></td><td id="LC179" class="css-1dcdqdg"><code>                    }
</code></td></tr><tr><td id="L180" class="css-a4x74f"><span>180</span></td><td id="LC180" class="css-1dcdqdg"><code>                }
</code></td></tr><tr><td id="L181" class="css-a4x74f"><span>181</span></td><td id="LC181" class="css-1dcdqdg"><code>            }
</code></td></tr><tr><td id="L182" class="css-a4x74f"><span>182</span></td><td id="LC182" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L183" class="css-a4x74f"><span>183</span></td><td id="LC183" class="css-1dcdqdg"><code>            <span class="code-keyword">if</span> (lang)
</code></td></tr><tr><td id="L184" class="css-a4x74f"><span>184</span></td><td id="LC184" class="css-1dcdqdg"><code>                lang = lang.toLowerCase();
</code></td></tr><tr><td id="L185" class="css-a4x74f"><span>185</span></td><td id="LC185" class="css-1dcdqdg"><code>            <span class="code-keyword">else</span>
</code></td></tr><tr><td id="L186" class="css-a4x74f"><span>186</span></td><td id="LC186" class="css-1dcdqdg"><code>                lang = <span class="code-string">"text"</span>;
</code></td></tr><tr><td id="L187" class="css-a4x74f"><span>187</span></td><td id="LC187" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L188" class="css-a4x74f"><span>188</span></td><td id="LC188" class="css-1dcdqdg"><code>            <span class="code-comment">// Language Name overrides so it displays nicer</span>
</code></td></tr><tr><td id="L189" class="css-a4x74f"><span>189</span></td><td id="LC189" class="css-1dcdqdg"><code>            <span class="code-keyword">if</span> (lang == <span class="code-string">"ps"</span>)
</code></td></tr><tr><td id="L190" class="css-a4x74f"><span>190</span></td><td id="LC190" class="css-1dcdqdg"><code>                lang = <span class="code-string">"powershell"</span>;
</code></td></tr><tr><td id="L191" class="css-a4x74f"><span>191</span></td><td id="LC191" class="css-1dcdqdg"><code>            <span class="code-keyword">else</span> <span class="code-keyword">if</span> (lang == <span class="code-string">"cs"</span>)
</code></td></tr><tr><td id="L192" class="css-a4x74f"><span>192</span></td><td id="LC192" class="css-1dcdqdg"><code>                lang = <span class="code-string">"csharp"</span>;
</code></td></tr><tr><td id="L193" class="css-a4x74f"><span>193</span></td><td id="LC193" class="css-1dcdqdg"><code>            <span class="code-keyword">else</span> <span class="code-keyword">if</span> (lang == <span class="code-string">"js"</span>)
</code></td></tr><tr><td id="L194" class="css-a4x74f"><span>194</span></td><td id="LC194" class="css-1dcdqdg"><code>                lang = <span class="code-string">"javascript"</span>;
</code></td></tr><tr><td id="L195" class="css-a4x74f"><span>195</span></td><td id="LC195" class="css-1dcdqdg"><code>            <span class="code-keyword">else</span> <span class="code-keyword">if</span> (lang == <span class="code-string">"ts"</span>)
</code></td></tr><tr><td id="L196" class="css-a4x74f"><span>196</span></td><td id="LC196" class="css-1dcdqdg"><code>                lang = <span class="code-string">"typescript"</span>;
</code></td></tr><tr><td id="L197" class="css-a4x74f"><span>197</span></td><td id="LC197" class="css-1dcdqdg"><code>            <span class="code-keyword">else</span> <span class="code-keyword">if</span> (lang == <span class="code-string">"fox"</span>)
</code></td></tr><tr><td id="L198" class="css-a4x74f"><span>198</span></td><td id="LC198" class="css-1dcdqdg"><code>                lang = <span class="code-string">"foxpro"</span>;
</code></td></tr><tr><td id="L199" class="css-a4x74f"><span>199</span></td><td id="LC199" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L200" class="css-a4x74f"><span>200</span></td><td id="LC200" class="css-1dcdqdg"><code>                
</code></td></tr><tr><td id="L201" class="css-a4x74f"><span>201</span></td><td id="LC201" class="css-1dcdqdg"><code>            <span class="code-keyword">var</span> html = hudText.replace(<span class="code-string">"{{language}}"</span>, lang)
</code></td></tr><tr><td id="L202" class="css-a4x74f"><span>202</span></td><td id="LC202" class="css-1dcdqdg"><code>                              .replace(<span class="code-string">"{{copyIconClass}}"</span>,options.copyIconClass)
</code></td></tr><tr><td id="L203" class="css-a4x74f"><span>203</span></td><td id="LC203" class="css-1dcdqdg"><code>                              .trim();
</code></td></tr><tr><td id="L204" class="css-a4x74f"><span>204</span></td><td id="LC204" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L205" class="css-a4x74f"><span>205</span></td><td id="LC205" class="css-1dcdqdg"><code>            <span class="code-comment">// insert the Hud panel</span>
</code></td></tr><tr><td id="L206" class="css-a4x74f"><span>206</span></td><td id="LC206" class="css-1dcdqdg"><code>            <span class="code-keyword">var</span> $newHud = <span class="code-built_in">document</span>.createElement(<span class="code-string">"div"</span>);
</code></td></tr><tr><td id="L207" class="css-a4x74f"><span>207</span></td><td id="LC207" class="css-1dcdqdg"><code>            $newHud.innerHTML = html;
</code></td></tr><tr><td id="L208" class="css-a4x74f"><span>208</span></td><td id="LC208" class="css-1dcdqdg"><code>            $newHud = $newHud.querySelector(<span class="code-string">".code-badge"</span>);        
</code></td></tr><tr><td id="L209" class="css-a4x74f"><span>209</span></td><td id="LC209" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L210" class="css-a4x74f"><span>210</span></td><td id="LC210" class="css-1dcdqdg"><code>            <span class="code-comment">// make &lt;pre&gt; tag position:relative so positioning keeps pinned right</span>
</code></td></tr><tr><td id="L211" class="css-a4x74f"><span>211</span></td><td id="LC211" class="css-1dcdqdg"><code>            <span class="code-comment">// even with scroll bar scrolled</span>
</code></td></tr><tr><td id="L212" class="css-a4x74f"><span>212</span></td><td id="LC212" class="css-1dcdqdg"><code>            <span class="code-keyword">var</span> pre = el.parentElement;            
</code></td></tr><tr><td id="L213" class="css-a4x74f"><span>213</span></td><td id="LC213" class="css-1dcdqdg"><code>            pre.classList.add(<span class="code-string">"code-badge-pre"</span>)
</code></td></tr><tr><td id="L214" class="css-a4x74f"><span>214</span></td><td id="LC214" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L215" class="css-a4x74f"><span>215</span></td><td id="LC215" class="css-1dcdqdg"><code>            <span class="code-keyword">if</span>(options.copyIconContent)
</code></td></tr><tr><td id="L216" class="css-a4x74f"><span>216</span></td><td id="LC216" class="css-1dcdqdg"><code>              $newHud.querySelector(<span class="code-string">".code-badge-copy-icon"</span>).innerText = options.copyIconContent;
</code></td></tr><tr><td id="L217" class="css-a4x74f"><span>217</span></td><td id="LC217" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L218" class="css-a4x74f"><span>218</span></td><td id="LC218" class="css-1dcdqdg"><code>            pre.insertBefore($newHud, el);
</code></td></tr><tr><td id="L219" class="css-a4x74f"><span>219</span></td><td id="LC219" class="css-1dcdqdg"><code>        }
</code></td></tr><tr><td id="L220" class="css-a4x74f"><span>220</span></td><td id="LC220" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L221" class="css-a4x74f"><span>221</span></td><td id="LC221" class="css-1dcdqdg"><code>        <span class="code-keyword">var</span> $content = <span class="code-built_in">document</span>.querySelector(options.contentSelector);
</code></td></tr><tr><td id="L222" class="css-a4x74f"><span>222</span></td><td id="LC222" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L223" class="css-a4x74f"><span>223</span></td><td id="LC223" class="css-1dcdqdg"><code>        <span class="code-comment">// single copy click handler</span>
</code></td></tr><tr><td id="L224" class="css-a4x74f"><span>224</span></td><td id="LC224" class="css-1dcdqdg"><code>        $content.addEventListener(<span class="code-string">"click"</span>,
</code></td></tr><tr><td id="L225" class="css-a4x74f"><span>225</span></td><td id="LC225" class="css-1dcdqdg"><code>            <span class="code-function"><span class="code-keyword">function</span> (<span class="code-params">e</span>) </span>{                               
</code></td></tr><tr><td id="L226" class="css-a4x74f"><span>226</span></td><td id="LC226" class="css-1dcdqdg"><code>                <span class="code-keyword">var</span> $clicked = e.srcElement;
</code></td></tr><tr><td id="L227" class="css-a4x74f"><span>227</span></td><td id="LC227" class="css-1dcdqdg"><code>                <span class="code-keyword">if</span> ($clicked.classList.contains(<span class="code-string">"code-badge-copy-icon"</span>)) {
</code></td></tr><tr><td id="L228" class="css-a4x74f"><span>228</span></td><td id="LC228" class="css-1dcdqdg"><code>                    e.preventDefault();
</code></td></tr><tr><td id="L229" class="css-a4x74f"><span>229</span></td><td id="LC229" class="css-1dcdqdg"><code>                    e.cancelBubble = <span class="code-literal">true</span>;
</code></td></tr><tr><td id="L230" class="css-a4x74f"><span>230</span></td><td id="LC230" class="css-1dcdqdg"><code>                    copyCodeToClipboard(e);
</code></td></tr><tr><td id="L231" class="css-a4x74f"><span>231</span></td><td id="LC231" class="css-1dcdqdg"><code>                }
</code></td></tr><tr><td id="L232" class="css-a4x74f"><span>232</span></td><td id="LC232" class="css-1dcdqdg"><code>                <span class="code-keyword">return</span> <span class="code-literal">false</span>;
</code></td></tr><tr><td id="L233" class="css-a4x74f"><span>233</span></td><td id="LC233" class="css-1dcdqdg"><code>            });
</code></td></tr><tr><td id="L234" class="css-a4x74f"><span>234</span></td><td id="LC234" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L235" class="css-a4x74f"><span>235</span></td><td id="LC235" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L236" class="css-a4x74f"><span>236</span></td><td id="LC236" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L237" class="css-a4x74f"><span>237</span></td><td id="LC237" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">copyCodeToClipboard</span>(<span class="code-params">e</span>) </span>{
</code></td></tr><tr><td id="L238" class="css-a4x74f"><span>238</span></td><td id="LC238" class="css-1dcdqdg"><code>        <span class="code-comment">// walk back up to &lt;pre&gt; tag</span>
</code></td></tr><tr><td id="L239" class="css-a4x74f"><span>239</span></td><td id="LC239" class="css-1dcdqdg"><code>        <span class="code-keyword">var</span> $origCode = e.srcElement.parentElement.parentElement.parentElement;
</code></td></tr><tr><td id="L240" class="css-a4x74f"><span>240</span></td><td id="LC240" class="css-1dcdqdg"><code>    
</code></td></tr><tr><td id="L241" class="css-a4x74f"><span>241</span></td><td id="LC241" class="css-1dcdqdg"><code>        <span class="code-comment">// select the &lt;code&gt; tag and grab text</span>
</code></td></tr><tr><td id="L242" class="css-a4x74f"><span>242</span></td><td id="LC242" class="css-1dcdqdg"><code>        <span class="code-keyword">var</span> $code = $origCode.querySelector(<span class="code-string">"pre&gt;code"</span>);
</code></td></tr><tr><td id="L243" class="css-a4x74f"><span>243</span></td><td id="LC243" class="css-1dcdqdg"><code>        <span class="code-keyword">var</span> text = $code.textContent || $code.innerText;
</code></td></tr><tr><td id="L244" class="css-a4x74f"><span>244</span></td><td id="LC244" class="css-1dcdqdg"><code>        
</code></td></tr><tr><td id="L245" class="css-a4x74f"><span>245</span></td><td id="LC245" class="css-1dcdqdg"><code>        <span class="code-comment">// Create a textblock and assign the text and add to document</span>
</code></td></tr><tr><td id="L246" class="css-a4x74f"><span>246</span></td><td id="LC246" class="css-1dcdqdg"><code>        <span class="code-keyword">var</span> el = <span class="code-built_in">document</span>.createElement(<span class="code-string">'textarea'</span>);
</code></td></tr><tr><td id="L247" class="css-a4x74f"><span>247</span></td><td id="LC247" class="css-1dcdqdg"><code>        el.value = text.trim();
</code></td></tr><tr><td id="L248" class="css-a4x74f"><span>248</span></td><td id="LC248" class="css-1dcdqdg"><code>        <span class="code-built_in">document</span>.body.appendChild(el);
</code></td></tr><tr><td id="L249" class="css-a4x74f"><span>249</span></td><td id="LC249" class="css-1dcdqdg"><code>        el.style.display = <span class="code-string">"block"</span>;
</code></td></tr><tr><td id="L250" class="css-a4x74f"><span>250</span></td><td id="LC250" class="css-1dcdqdg"><code>    
</code></td></tr><tr><td id="L251" class="css-a4x74f"><span>251</span></td><td id="LC251" class="css-1dcdqdg"><code>        <span class="code-comment">// select the entire textblock</span>
</code></td></tr><tr><td id="L252" class="css-a4x74f"><span>252</span></td><td id="LC252" class="css-1dcdqdg"><code>        <span class="code-keyword">if</span> (<span class="code-built_in">window</span>.document.documentMode)
</code></td></tr><tr><td id="L253" class="css-a4x74f"><span>253</span></td><td id="LC253" class="css-1dcdqdg"><code>            el.setSelectionRange(<span class="code-number">0</span>, el.value.length);
</code></td></tr><tr><td id="L254" class="css-a4x74f"><span>254</span></td><td id="LC254" class="css-1dcdqdg"><code>        <span class="code-keyword">else</span>
</code></td></tr><tr><td id="L255" class="css-a4x74f"><span>255</span></td><td id="LC255" class="css-1dcdqdg"><code>            el.select();
</code></td></tr><tr><td id="L256" class="css-a4x74f"><span>256</span></td><td id="LC256" class="css-1dcdqdg"><code>        
</code></td></tr><tr><td id="L257" class="css-a4x74f"><span>257</span></td><td id="LC257" class="css-1dcdqdg"><code>        <span class="code-comment">// copy to clipboard</span>
</code></td></tr><tr><td id="L258" class="css-a4x74f"><span>258</span></td><td id="LC258" class="css-1dcdqdg"><code>        <span class="code-built_in">document</span>.execCommand(<span class="code-string">'copy'</span>);
</code></td></tr><tr><td id="L259" class="css-a4x74f"><span>259</span></td><td id="LC259" class="css-1dcdqdg"><code>        
</code></td></tr><tr><td id="L260" class="css-a4x74f"><span>260</span></td><td id="LC260" class="css-1dcdqdg"><code>        <span class="code-comment">// clean up element</span>
</code></td></tr><tr><td id="L261" class="css-a4x74f"><span>261</span></td><td id="LC261" class="css-1dcdqdg"><code>        <span class="code-built_in">document</span>.body.removeChild(el);
</code></td></tr><tr><td id="L262" class="css-a4x74f"><span>262</span></td><td id="LC262" class="css-1dcdqdg"><code>        
</code></td></tr><tr><td id="L263" class="css-a4x74f"><span>263</span></td><td id="LC263" class="css-1dcdqdg"><code>        <span class="code-comment">// show the check icon (copied) briefly</span>
</code></td></tr><tr><td id="L264" class="css-a4x74f"><span>264</span></td><td id="LC264" class="css-1dcdqdg"><code>        swapIcons($origCode);     
</code></td></tr><tr><td id="L265" class="css-a4x74f"><span>265</span></td><td id="LC265" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L266" class="css-a4x74f"><span>266</span></td><td id="LC266" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L267" class="css-a4x74f"><span>267</span></td><td id="LC267" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">swapIcons</span>(<span class="code-params">$code</span>) </span>{
</code></td></tr><tr><td id="L268" class="css-a4x74f"><span>268</span></td><td id="LC268" class="css-1dcdqdg"><code>        <span class="code-keyword">var</span> copyIcons = options.copyIconClass.split(<span class="code-string">' '</span>);
</code></td></tr><tr><td id="L269" class="css-a4x74f"><span>269</span></td><td id="LC269" class="css-1dcdqdg"><code>        <span class="code-keyword">var</span> checkIcons = options.checkIconClass.split(<span class="code-string">' '</span>);
</code></td></tr><tr><td id="L270" class="css-a4x74f"><span>270</span></td><td id="LC270" class="css-1dcdqdg"><code>        
</code></td></tr><tr><td id="L271" class="css-a4x74f"><span>271</span></td><td id="LC271" class="css-1dcdqdg"><code>        <span class="code-keyword">var</span> $fa = $code.querySelector(<span class="code-string">".code-badge-copy-icon"</span>);
</code></td></tr><tr><td id="L272" class="css-a4x74f"><span>272</span></td><td id="LC272" class="css-1dcdqdg"><code>        $fa.innerText = options.checkIconContent;
</code></td></tr><tr><td id="L273" class="css-a4x74f"><span>273</span></td><td id="LC273" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L274" class="css-a4x74f"><span>274</span></td><td id="LC274" class="css-1dcdqdg"><code>        <span class="code-keyword">for</span> (<span class="code-keyword">var</span> i = <span class="code-number">0</span>; i &lt; copyIcons.length; i++)
</code></td></tr><tr><td id="L275" class="css-a4x74f"><span>275</span></td><td id="LC275" class="css-1dcdqdg"><code>            $fa.classList.remove(copyIcons[i]);
</code></td></tr><tr><td id="L276" class="css-a4x74f"><span>276</span></td><td id="LC276" class="css-1dcdqdg"><code>        
</code></td></tr><tr><td id="L277" class="css-a4x74f"><span>277</span></td><td id="LC277" class="css-1dcdqdg"><code>        <span class="code-keyword">for</span> (<span class="code-keyword">var</span> i = <span class="code-number">0</span>; i &lt; checkIcons.length; i++)
</code></td></tr><tr><td id="L278" class="css-a4x74f"><span>278</span></td><td id="LC278" class="css-1dcdqdg"><code>            $fa.classList.add(checkIcons[i]);
</code></td></tr><tr><td id="L279" class="css-a4x74f"><span>279</span></td><td id="LC279" class="css-1dcdqdg"><code>        
</code></td></tr><tr><td id="L280" class="css-a4x74f"><span>280</span></td><td id="LC280" class="css-1dcdqdg"><code>        
</code></td></tr><tr><td id="L281" class="css-a4x74f"><span>281</span></td><td id="LC281" class="css-1dcdqdg"><code>        setTimeout(<span class="code-function"><span class="code-keyword">function</span> (<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L282" class="css-a4x74f"><span>282</span></td><td id="LC282" class="css-1dcdqdg"><code>            $fa.innerText = options.copyIconContent;
</code></td></tr><tr><td id="L283" class="css-a4x74f"><span>283</span></td><td id="LC283" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L284" class="css-a4x74f"><span>284</span></td><td id="LC284" class="css-1dcdqdg"><code>            <span class="code-keyword">for</span> (<span class="code-keyword">var</span> i = <span class="code-number">0</span>; i &lt; checkIcons.length; i++)
</code></td></tr><tr><td id="L285" class="css-a4x74f"><span>285</span></td><td id="LC285" class="css-1dcdqdg"><code>                $fa.classList.remove(checkIcons[i]);
</code></td></tr><tr><td id="L286" class="css-a4x74f"><span>286</span></td><td id="LC286" class="css-1dcdqdg"><code>            <span class="code-keyword">for</span> (<span class="code-keyword">var</span> i = <span class="code-number">0</span>; i &lt; copyIcons.length; i++)
</code></td></tr><tr><td id="L287" class="css-a4x74f"><span>287</span></td><td id="LC287" class="css-1dcdqdg"><code>                $fa.classList.add(copyIcons[i]);
</code></td></tr><tr><td id="L288" class="css-a4x74f"><span>288</span></td><td id="LC288" class="css-1dcdqdg"><code>        }, <span class="code-number">2000</span>);
</code></td></tr><tr><td id="L289" class="css-a4x74f"><span>289</span></td><td id="LC289" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L290" class="css-a4x74f"><span>290</span></td><td id="LC290" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L291" class="css-a4x74f"><span>291</span></td><td id="LC291" class="css-1dcdqdg"><code>    <span class="code-function"><span class="code-keyword">function</span> <span class="code-title">getTemplate</span>(<span class="code-params"></span>) </span>{
</code></td></tr><tr><td id="L292" class="css-a4x74f"><span>292</span></td><td id="LC292" class="css-1dcdqdg"><code>      <span class="code-keyword">var</span> stringArray =
</code></td></tr><tr><td id="L293" class="css-a4x74f"><span>293</span></td><td id="LC293" class="css-1dcdqdg"><code>      [
</code></td></tr><tr><td id="L294" class="css-a4x74f"><span>294</span></td><td id="LC294" class="css-1dcdqdg"><code>        <span class="code-string">"&lt;style&gt;"</span>,
</code></td></tr><tr><td id="L295" class="css-a4x74f"><span>295</span></td><td id="LC295" class="css-1dcdqdg"><code>            <span class="code-string">"@media print {"</span>,
</code></td></tr><tr><td id="L296" class="css-a4x74f"><span>296</span></td><td id="LC296" class="css-1dcdqdg"><code>            <span class="code-string">"   .code-badge { display: none; }"</span>,
</code></td></tr><tr><td id="L297" class="css-a4x74f"><span>297</span></td><td id="LC297" class="css-1dcdqdg"><code>            <span class="code-string">"}"</span>,          
</code></td></tr><tr><td id="L298" class="css-a4x74f"><span>298</span></td><td id="LC298" class="css-1dcdqdg"><code>            <span class="code-string">"    .code-badge-pre {"</span>,
</code></td></tr><tr><td id="L299" class="css-a4x74f"><span>299</span></td><td id="LC299" class="css-1dcdqdg"><code>            <span class="code-string">"        position: relative;"</span>,
</code></td></tr><tr><td id="L300" class="css-a4x74f"><span>300</span></td><td id="LC300" class="css-1dcdqdg"><code>            <span class="code-string">"    }"</span>,
</code></td></tr><tr><td id="L301" class="css-a4x74f"><span>301</span></td><td id="LC301" class="css-1dcdqdg"><code>            <span class="code-string">"    .code-badge {"</span>,
</code></td></tr><tr><td id="L302" class="css-a4x74f"><span>302</span></td><td id="LC302" class="css-1dcdqdg"><code>            <span class="code-string">"        display: flex;"</span>,
</code></td></tr><tr><td id="L303" class="css-a4x74f"><span>303</span></td><td id="LC303" class="css-1dcdqdg"><code>            <span class="code-string">"        flex-direction: row;"</span>,
</code></td></tr><tr><td id="L304" class="css-a4x74f"><span>304</span></td><td id="LC304" class="css-1dcdqdg"><code>            <span class="code-string">"        white-space: normal;"</span>,
</code></td></tr><tr><td id="L305" class="css-a4x74f"><span>305</span></td><td id="LC305" class="css-1dcdqdg"><code>            <span class="code-string">"        background: transparent;"</span>,
</code></td></tr><tr><td id="L306" class="css-a4x74f"><span>306</span></td><td id="LC306" class="css-1dcdqdg"><code>            <span class="code-string">"        background: #333;"</span>,
</code></td></tr><tr><td id="L307" class="css-a4x74f"><span>307</span></td><td id="LC307" class="css-1dcdqdg"><code>            <span class="code-string">"        color: white;"</span>,
</code></td></tr><tr><td id="L308" class="css-a4x74f"><span>308</span></td><td id="LC308" class="css-1dcdqdg"><code>            <span class="code-string">"        font-size: 0.875em;"</span>,
</code></td></tr><tr><td id="L309" class="css-a4x74f"><span>309</span></td><td id="LC309" class="css-1dcdqdg"><code>            <span class="code-string">"        opacity: 0.5;"</span>,
</code></td></tr><tr><td id="L310" class="css-a4x74f"><span>310</span></td><td id="LC310" class="css-1dcdqdg"><code>            <span class="code-string">"        transition: opacity linear 0.5s;"</span>,
</code></td></tr><tr><td id="L311" class="css-a4x74f"><span>311</span></td><td id="LC311" class="css-1dcdqdg"><code>            <span class="code-string">"        border-radius: 0 0 0 7px;"</span>,
</code></td></tr><tr><td id="L312" class="css-a4x74f"><span>312</span></td><td id="LC312" class="css-1dcdqdg"><code>            <span class="code-string">"        padding: 5px 8px 5px 8px;"</span>,
</code></td></tr><tr><td id="L313" class="css-a4x74f"><span>313</span></td><td id="LC313" class="css-1dcdqdg"><code>            <span class="code-string">"        position: absolute;"</span>,
</code></td></tr><tr><td id="L314" class="css-a4x74f"><span>314</span></td><td id="LC314" class="css-1dcdqdg"><code>            <span class="code-string">"        right: 0;"</span>,
</code></td></tr><tr><td id="L315" class="css-a4x74f"><span>315</span></td><td id="LC315" class="css-1dcdqdg"><code>            <span class="code-string">"        top: 0;"</span>,
</code></td></tr><tr><td id="L316" class="css-a4x74f"><span>316</span></td><td id="LC316" class="css-1dcdqdg"><code>            <span class="code-string">"    }"</span>,            
</code></td></tr><tr><td id="L317" class="css-a4x74f"><span>317</span></td><td id="LC317" class="css-1dcdqdg"><code>            <span class="code-string">"    .code-badge.active {"</span>,
</code></td></tr><tr><td id="L318" class="css-a4x74f"><span>318</span></td><td id="LC318" class="css-1dcdqdg"><code>            <span class="code-string">"        opacity: 0.8;"</span>,
</code></td></tr><tr><td id="L319" class="css-a4x74f"><span>319</span></td><td id="LC319" class="css-1dcdqdg"><code>            <span class="code-string">"    }"</span>,
</code></td></tr><tr><td id="L320" class="css-a4x74f"><span>320</span></td><td id="LC320" class="css-1dcdqdg"><code>            <span class="code-string">""</span>,
</code></td></tr><tr><td id="L321" class="css-a4x74f"><span>321</span></td><td id="LC321" class="css-1dcdqdg"><code>            <span class="code-string">"    .code-badge:hover {"</span>,
</code></td></tr><tr><td id="L322" class="css-a4x74f"><span>322</span></td><td id="LC322" class="css-1dcdqdg"><code>            <span class="code-string">"        opacity: .95;"</span>,
</code></td></tr><tr><td id="L323" class="css-a4x74f"><span>323</span></td><td id="LC323" class="css-1dcdqdg"><code>            <span class="code-string">"    }"</span>,
</code></td></tr><tr><td id="L324" class="css-a4x74f"><span>324</span></td><td id="LC324" class="css-1dcdqdg"><code>            <span class="code-string">""</span>,
</code></td></tr><tr><td id="L325" class="css-a4x74f"><span>325</span></td><td id="LC325" class="css-1dcdqdg"><code>            <span class="code-string">"    .code-badge a,"</span>,
</code></td></tr><tr><td id="L326" class="css-a4x74f"><span>326</span></td><td id="LC326" class="css-1dcdqdg"><code>            <span class="code-string">"    .code-badge a:hover {"</span>,
</code></td></tr><tr><td id="L327" class="css-a4x74f"><span>327</span></td><td id="LC327" class="css-1dcdqdg"><code>            <span class="code-string">"        text-decoration: none;"</span>,
</code></td></tr><tr><td id="L328" class="css-a4x74f"><span>328</span></td><td id="LC328" class="css-1dcdqdg"><code>            <span class="code-string">"    }"</span>,
</code></td></tr><tr><td id="L329" class="css-a4x74f"><span>329</span></td><td id="LC329" class="css-1dcdqdg"><code>            <span class="code-string">""</span>,
</code></td></tr><tr><td id="L330" class="css-a4x74f"><span>330</span></td><td id="LC330" class="css-1dcdqdg"><code>            <span class="code-string">"    .code-badge-language {"</span>,
</code></td></tr><tr><td id="L331" class="css-a4x74f"><span>331</span></td><td id="LC331" class="css-1dcdqdg"><code>            <span class="code-string">"        margin-right: 10px;"</span>,
</code></td></tr><tr><td id="L332" class="css-a4x74f"><span>332</span></td><td id="LC332" class="css-1dcdqdg"><code>            <span class="code-string">"        font-weight: 600;"</span>,
</code></td></tr><tr><td id="L333" class="css-a4x74f"><span>333</span></td><td id="LC333" class="css-1dcdqdg"><code>            <span class="code-string">"        color: goldenrod;"</span>,
</code></td></tr><tr><td id="L334" class="css-a4x74f"><span>334</span></td><td id="LC334" class="css-1dcdqdg"><code>            <span class="code-string">"    }"</span>,
</code></td></tr><tr><td id="L335" class="css-a4x74f"><span>335</span></td><td id="LC335" class="css-1dcdqdg"><code>            <span class="code-string">"    .code-badge-copy-icon {"</span>,
</code></td></tr><tr><td id="L336" class="css-a4x74f"><span>336</span></td><td id="LC336" class="css-1dcdqdg"><code>            <span class="code-string">"        font-size: 1.2em;"</span>,
</code></td></tr><tr><td id="L337" class="css-a4x74f"><span>337</span></td><td id="LC337" class="css-1dcdqdg"><code>            <span class="code-string">"        cursor: pointer;"</span>,
</code></td></tr><tr><td id="L338" class="css-a4x74f"><span>338</span></td><td id="LC338" class="css-1dcdqdg"><code>            <span class="code-string">"        padding: 0 7px;"</span>,
</code></td></tr><tr><td id="L339" class="css-a4x74f"><span>339</span></td><td id="LC339" class="css-1dcdqdg"><code>            <span class="code-string">"        margin-top:2;"</span>,
</code></td></tr><tr><td id="L340" class="css-a4x74f"><span>340</span></td><td id="LC340" class="css-1dcdqdg"><code>            <span class="code-string">"    }"</span>,
</code></td></tr><tr><td id="L341" class="css-a4x74f"><span>341</span></td><td id="LC341" class="css-1dcdqdg"><code>            <span class="code-string">"    .fa.text-success:{ color: limegreen !important }"</span>,
</code></td></tr><tr><td id="L342" class="css-a4x74f"><span>342</span></td><td id="LC342" class="css-1dcdqdg"><code>            <span class="code-string">"&lt;/style&gt;"</span>,
</code></td></tr><tr><td id="L343" class="css-a4x74f"><span>343</span></td><td id="LC343" class="css-1dcdqdg"><code>            <span class="code-string">"&lt;div id=\"CodeBadgeTemplate\" style=\"display:none\"&gt;"</span>,
</code></td></tr><tr><td id="L344" class="css-a4x74f"><span>344</span></td><td id="LC344" class="css-1dcdqdg"><code>            <span class="code-string">"    &lt;div class=\"code-badge\"&gt;"</span>,
</code></td></tr><tr><td id="L345" class="css-a4x74f"><span>345</span></td><td id="LC345" class="css-1dcdqdg"><code>            <span class="code-string">"        &lt;div class=\"code-badge-language\" &gt;{{language}}&lt;/div&gt;"</span>,
</code></td></tr><tr><td id="L346" class="css-a4x74f"><span>346</span></td><td id="LC346" class="css-1dcdqdg"><code>            <span class="code-string">"        &lt;div  title=\"Copy to clipboard\"&gt;"</span>,
</code></td></tr><tr><td id="L347" class="css-a4x74f"><span>347</span></td><td id="LC347" class="css-1dcdqdg"><code>            <span class="code-string">"            &lt;i class=\"{{copyIconClass}} code-badge-copy-icon\"&gt;&lt;/i&gt;&lt;/i&gt;&lt;/a&gt;"</span>,            
</code></td></tr><tr><td id="L348" class="css-a4x74f"><span>348</span></td><td id="LC348" class="css-1dcdqdg"><code>            <span class="code-string">"        &lt;/div&gt;"</span>,
</code></td></tr><tr><td id="L349" class="css-a4x74f"><span>349</span></td><td id="LC349" class="css-1dcdqdg"><code>            <span class="code-string">"     &lt;/div&gt;"</span>,
</code></td></tr><tr><td id="L350" class="css-a4x74f"><span>350</span></td><td id="LC350" class="css-1dcdqdg"><code>            <span class="code-string">"&lt;/div&gt;"</span>
</code></td></tr><tr><td id="L351" class="css-a4x74f"><span>351</span></td><td id="LC351" class="css-1dcdqdg"><code>        ];
</code></td></tr><tr><td id="L352" class="css-a4x74f"><span>352</span></td><td id="LC352" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L353" class="css-a4x74f"><span>353</span></td><td id="LC353" class="css-1dcdqdg"><code>        <span class="code-keyword">var</span> t = <span class="code-string">""</span>;
</code></td></tr><tr><td id="L354" class="css-a4x74f"><span>354</span></td><td id="LC354" class="css-1dcdqdg"><code>        <span class="code-keyword">for</span> (<span class="code-keyword">var</span> i = <span class="code-number">0</span>; i &lt; stringArray.length; i++)
</code></td></tr><tr><td id="L355" class="css-a4x74f"><span>355</span></td><td id="LC355" class="css-1dcdqdg"><code>            t += stringArray[i] + <span class="code-string">"\n"</span>;
</code></td></tr><tr><td id="L356" class="css-a4x74f"><span>356</span></td><td id="LC356" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L357" class="css-a4x74f"><span>357</span></td><td id="LC357" class="css-1dcdqdg"><code>        <span class="code-keyword">return</span> t;
</code></td></tr><tr><td id="L358" class="css-a4x74f"><span>358</span></td><td id="LC358" class="css-1dcdqdg"><code>    }
</code></td></tr><tr><td id="L359" class="css-a4x74f"><span>359</span></td><td id="LC359" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L360" class="css-a4x74f"><span>360</span></td><td id="LC360" class="css-1dcdqdg"><code>    initialize();
</code></td></tr><tr><td id="L361" class="css-a4x74f"><span>361</span></td><td id="LC361" class="css-1dcdqdg"><code>}
</code></td></tr><tr><td id="L362" class="css-a4x74f"><span>362</span></td><td id="LC362" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L363" class="css-a4x74f"><span>363</span></td><td id="LC363" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L364" class="css-a4x74f"><span>364</span></td><td id="LC364" class="css-1dcdqdg"><code><span class="code-comment">// global reference Window</span>
</code></td></tr><tr><td id="L365" class="css-a4x74f"><span>365</span></td><td id="LC365" class="css-1dcdqdg"><code><span class="code-built_in">window</span>.highlightJsBadge = highlightJsBadge;
</code></td></tr><tr><td id="L366" class="css-a4x74f"><span>366</span></td><td id="LC366" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L367" class="css-a4x74f"><span>367</span></td><td id="LC367" class="css-1dcdqdg"><code><span class="code-keyword">if</span> (highlightJsBadgeAutoLoad)
</code></td></tr><tr><td id="L368" class="css-a4x74f"><span>368</span></td><td id="LC368" class="css-1dcdqdg"><code>    highlightJsBadge();
</code></td></tr><tr><td id="L369" class="css-a4x74f"><span>369</span></td><td id="LC369" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L370" class="css-a4x74f"><span>370</span></td><td id="LC370" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L371" class="css-a4x74f"><span>371</span></td><td id="LC371" class="css-1dcdqdg"><code>}));
</code></td></tr><tr><td id="L372" class="css-a4x74f"><span>372</span></td><td id="LC372" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L373" class="css-a4x74f"><span>373</span></td><td id="LC373" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L374" class="css-a4x74f"><span>374</span></td><td id="LC374" class="css-1dcdqdg"><code><span class="code-comment">// You can embed the following into your HTML document</span>
</code></td></tr><tr><td id="L375" class="css-a4x74f"><span>375</span></td><td id="LC375" class="css-1dcdqdg"><code><span class="code-comment">// to provide your own custom styling.</span>
</code></td></tr><tr><td id="L376" class="css-a4x74f"><span>376</span></td><td id="LC376" class="css-1dcdqdg"><code>
</code></td></tr><tr><td id="L377" class="css-a4x74f"><span>377</span></td><td id="LC377" class="css-1dcdqdg"><code><span class="code-comment">/*
</span></code></td></tr><tr><td id="L378" class="css-a4x74f"><span>378</span></td><td id="LC378" class="css-1dcdqdg"><code><span class="code-comment">&lt;style&gt;
</span></code></td></tr><tr><td id="L379" class="css-a4x74f"><span>379</span></td><td id="LC379" class="css-1dcdqdg"><code><span class="code-comment">    "@media print {
</span></code></td></tr><tr><td id="L380" class="css-a4x74f"><span>380</span></td><td id="LC380" class="css-1dcdqdg"><code><span class="code-comment">        .code-badge { display: none; }
</span></code></td></tr><tr><td id="L381" class="css-a4x74f"><span>381</span></td><td id="LC381" class="css-1dcdqdg"><code><span class="code-comment">    }
</span></code></td></tr><tr><td id="L382" class="css-a4x74f"><span>382</span></td><td id="LC382" class="css-1dcdqdg"><code><span class="code-comment">    .code-badge-pre {
</span></code></td></tr><tr><td id="L383" class="css-a4x74f"><span>383</span></td><td id="LC383" class="css-1dcdqdg"><code><span class="code-comment">        position: relative; 
</span></code></td></tr><tr><td id="L384" class="css-a4x74f"><span>384</span></td><td id="LC384" class="css-1dcdqdg"><code><span class="code-comment">    }
</span></code></td></tr><tr><td id="L385" class="css-a4x74f"><span>385</span></td><td id="LC385" class="css-1dcdqdg"><code><span class="code-comment">    .code-badge {
</span></code></td></tr><tr><td id="L386" class="css-a4x74f"><span>386</span></td><td id="LC386" class="css-1dcdqdg"><code><span class="code-comment">        display: flex;
</span></code></td></tr><tr><td id="L387" class="css-a4x74f"><span>387</span></td><td id="LC387" class="css-1dcdqdg"><code><span class="code-comment">        flex-direction: row;
</span></code></td></tr><tr><td id="L388" class="css-a4x74f"><span>388</span></td><td id="LC388" class="css-1dcdqdg"><code><span class="code-comment">        white-space: normal;
</span></code></td></tr><tr><td id="L389" class="css-a4x74f"><span>389</span></td><td id="LC389" class="css-1dcdqdg"><code><span class="code-comment">        background: transparent;
</span></code></td></tr><tr><td id="L390" class="css-a4x74f"><span>390</span></td><td id="LC390" class="css-1dcdqdg"><code><span class="code-comment">        background: #333;
</span></code></td></tr><tr><td id="L391" class="css-a4x74f"><span>391</span></td><td id="LC391" class="css-1dcdqdg"><code><span class="code-comment">        color: white;
</span></code></td></tr><tr><td id="L392" class="css-a4x74f"><span>392</span></td><td id="LC392" class="css-1dcdqdg"><code><span class="code-comment">        font-size: 0.875em;
</span></code></td></tr><tr><td id="L393" class="css-a4x74f"><span>393</span></td><td id="LC393" class="css-1dcdqdg"><code><span class="code-comment">        opacity: 0.5;
</span></code></td></tr><tr><td id="L394" class="css-a4x74f"><span>394</span></td><td id="LC394" class="css-1dcdqdg"><code><span class="code-comment">        border-radius: 0 0 0 7px;
</span></code></td></tr><tr><td id="L395" class="css-a4x74f"><span>395</span></td><td id="LC395" class="css-1dcdqdg"><code><span class="code-comment">        padding: 5px 8px 5px 8px;
</span></code></td></tr><tr><td id="L396" class="css-a4x74f"><span>396</span></td><td id="LC396" class="css-1dcdqdg"><code><span class="code-comment">        position: absolute;
</span></code></td></tr><tr><td id="L397" class="css-a4x74f"><span>397</span></td><td id="LC397" class="css-1dcdqdg"><code><span class="code-comment">        right: 0;
</span></code></td></tr><tr><td id="L398" class="css-a4x74f"><span>398</span></td><td id="LC398" class="css-1dcdqdg"><code><span class="code-comment">        top: 0;
</span></code></td></tr><tr><td id="L399" class="css-a4x74f"><span>399</span></td><td id="LC399" class="css-1dcdqdg"><code><span class="code-comment">    }
</span></code></td></tr><tr><td id="L400" class="css-a4x74f"><span>400</span></td><td id="LC400" class="css-1dcdqdg"><code><span class="code-comment">    .code-badge.active {
</span></code></td></tr><tr><td id="L401" class="css-a4x74f"><span>401</span></td><td id="LC401" class="css-1dcdqdg"><code><span class="code-comment">        opacity: 0.8;
</span></code></td></tr><tr><td id="L402" class="css-a4x74f"><span>402</span></td><td id="LC402" class="css-1dcdqdg"><code><span class="code-comment">    }
</span></code></td></tr><tr><td id="L403" class="css-a4x74f"><span>403</span></td><td id="LC403" class="css-1dcdqdg"><code><span class="code-comment">    .code-badge:hover {
</span></code></td></tr><tr><td id="L404" class="css-a4x74f"><span>404</span></td><td id="LC404" class="css-1dcdqdg"><code><span class="code-comment">        opacity: .95;
</span></code></td></tr><tr><td id="L405" class="css-a4x74f"><span>405</span></td><td id="LC405" class="css-1dcdqdg"><code><span class="code-comment">    }
</span></code></td></tr><tr><td id="L406" class="css-a4x74f"><span>406</span></td><td id="LC406" class="css-1dcdqdg"><code><span class="code-comment">    .code-badge a,
</span></code></td></tr><tr><td id="L407" class="css-a4x74f"><span>407</span></td><td id="LC407" class="css-1dcdqdg"><code><span class="code-comment">    .code-badge a:hover {
</span></code></td></tr><tr><td id="L408" class="css-a4x74f"><span>408</span></td><td id="LC408" class="css-1dcdqdg"><code><span class="code-comment">        text-decoration: none;
</span></code></td></tr><tr><td id="L409" class="css-a4x74f"><span>409</span></td><td id="LC409" class="css-1dcdqdg"><code><span class="code-comment">    }
</span></code></td></tr><tr><td id="L410" class="css-a4x74f"><span>410</span></td><td id="LC410" class="css-1dcdqdg"><code><span class="code-comment">
</span></code></td></tr><tr><td id="L411" class="css-a4x74f"><span>411</span></td><td id="LC411" class="css-1dcdqdg"><code><span class="code-comment">    .code-badge-language {
</span></code></td></tr><tr><td id="L412" class="css-a4x74f"><span>412</span></td><td id="LC412" class="css-1dcdqdg"><code><span class="code-comment">        margin-right: 10px;
</span></code></td></tr><tr><td id="L413" class="css-a4x74f"><span>413</span></td><td id="LC413" class="css-1dcdqdg"><code><span class="code-comment">        font-weight: 600;
</span></code></td></tr><tr><td id="L414" class="css-a4x74f"><span>414</span></td><td id="LC414" class="css-1dcdqdg"><code><span class="code-comment">        color: goldenrod;
</span></code></td></tr><tr><td id="L415" class="css-a4x74f"><span>415</span></td><td id="LC415" class="css-1dcdqdg"><code><span class="code-comment">    }
</span></code></td></tr><tr><td id="L416" class="css-a4x74f"><span>416</span></td><td id="LC416" class="css-1dcdqdg"><code><span class="code-comment">    .code-badge-copy-icon {
</span></code></td></tr><tr><td id="L417" class="css-a4x74f"><span>417</span></td><td id="LC417" class="css-1dcdqdg"><code><span class="code-comment">        font-size: 1.2em;
</span></code></td></tr><tr><td id="L418" class="css-a4x74f"><span>418</span></td><td id="LC418" class="css-1dcdqdg"><code><span class="code-comment">        cursor: pointer;
</span></code></td></tr><tr><td id="L419" class="css-a4x74f"><span>419</span></td><td id="LC419" class="css-1dcdqdg"><code><span class="code-comment">        padding: 0 7px;
</span></code></td></tr><tr><td id="L420" class="css-a4x74f"><span>420</span></td><td id="LC420" class="css-1dcdqdg"><code><span class="code-comment">        margin-top:2;
</span></code></td></tr><tr><td id="L421" class="css-a4x74f"><span>421</span></td><td id="LC421" class="css-1dcdqdg"><code><span class="code-comment">    }
</span></code></td></tr><tr><td id="L422" class="css-a4x74f"><span>422</span></td><td id="LC422" class="css-1dcdqdg"><code><span class="code-comment">    .fa.text-success:{ color: limegreen !important}    
</span></code></td></tr><tr><td id="L423" class="css-a4x74f"><span>423</span></td><td id="LC423" class="css-1dcdqdg"><code><span class="code-comment">&lt;/style&gt;
</span></code></td></tr><tr><td id="L424" class="css-a4x74f"><span>424</span></td><td id="LC424" class="css-1dcdqdg"><code><span class="code-comment">&lt;div id="CodeBadgeTemplate" style="display:none"&gt;
</span></code></td></tr><tr><td id="L425" class="css-a4x74f"><span>425</span></td><td id="LC425" class="css-1dcdqdg"><code><span class="code-comment">    &lt;div class="code-badge"&gt;
</span></code></td></tr><tr><td id="L426" class="css-a4x74f"><span>426</span></td><td id="LC426" class="css-1dcdqdg"><code><span class="code-comment">        &lt;div class="code-badge-language"&gt;{{language}}&lt;/div&gt;
</span></code></td></tr><tr><td id="L427" class="css-a4x74f"><span>427</span></td><td id="LC427" class="css-1dcdqdg"><code><span class="code-comment">        &lt;div title="Copy to clipboard"&gt;
</span></code></td></tr><tr><td id="L428" class="css-a4x74f"><span>428</span></td><td id="LC428" class="css-1dcdqdg"><code><span class="code-comment">            &lt;i class="{{copyIconClass}} code-badge-copy-icon"&gt;&lt;/i&gt;
</span></code></td></tr><tr><td id="L429" class="css-a4x74f"><span>429</span></td><td id="LC429" class="css-1dcdqdg"><code><span class="code-comment">        &lt;/div&gt;
</span></code></td></tr><tr><td id="L430" class="css-a4x74f"><span>430</span></td><td id="LC430" class="css-1dcdqdg"><code><span class="code-comment">     &lt;/div&gt;
</span></code></td></tr><tr><td id="L431" class="css-a4x74f"><span>431</span></td><td id="LC431" class="css-1dcdqdg"><code><span class="code-comment">&lt;/div&gt;
</span></code></td></tr><tr><td id="L432" class="css-a4x74f"><span>432</span></td><td id="LC432" class="css-1dcdqdg"><code><span class="code-comment">*/</span>
</code></td></tr></tbody></table></div></div></div></div><style data-emotion-css="1teho9j">.css-1teho9j{margin-top:5rem;background:black;color:#aaa;}</style><footer class="css-1teho9j"><style data-emotion-css="1ui8put">.css-1ui8put{max-width:940px;padding:10px 20px;margin:0 auto;display:-webkit-box;display:-webkit-flex;display:-ms-flexbox;display:flex;-webkit-flex-direction:row;-ms-flex-direction:row;flex-direction:row;-webkit-align-items:center;-webkit-box-align:center;-ms-flex-align:center;align-items:center;-webkit-box-pack:justify;-webkit-justify-content:space-between;-ms-flex-pack:justify;justify-content:space-between;}</style><div class="css-1ui8put"><p>© <!-- -->2020<!-- --> UNPKG</p><style data-emotion-css="la3nd4">.css-la3nd4{font-size:1.5rem;}</style><p class="css-la3nd4"><style data-emotion-css="bogekj">.css-bogekj{color:#aaa;display:inline-block;}.css-bogekj:hover{color:white;}</style><a title="Twitter" href="https://twitter.com/unpkg" class="css-bogekj"><style data-emotion-css="i6dzq1">.css-i6dzq1{vertical-align:text-bottom;}</style><svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 512 512" class="css-i6dzq1" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><path d="M459.37 151.716c.325 4.548.325 9.097.325 13.645 0 138.72-105.583 298.558-298.558 298.558-59.452 0-114.68-17.219-161.137-47.106 8.447.974 16.568 1.299 25.34 1.299 49.055 0 94.213-16.568 130.274-44.832-46.132-.975-84.792-31.188-98.112-72.772 6.498.974 12.995 1.624 19.818 1.624 9.421 0 18.843-1.3 27.614-3.573-48.081-9.747-84.143-51.98-84.143-102.985v-1.299c13.969 7.797 30.214 12.67 47.431 13.319-28.264-18.843-46.781-51.005-46.781-87.391 0-19.492 5.197-37.36 14.294-52.954 51.655 63.675 129.3 105.258 216.365 109.807-1.624-7.797-2.599-15.918-2.599-24.04 0-57.828 46.782-104.934 104.934-104.934 30.213 0 57.502 12.67 76.67 33.137 23.715-4.548 46.456-13.32 66.599-25.34-7.798 24.366-24.366 44.833-46.132 57.827 21.117-2.273 41.584-8.122 60.426-16.243-14.292 20.791-32.161 39.308-52.628 54.253z"></path></svg></a><style data-emotion-css="ap0i2q">.css-ap0i2q{color:#aaa;display:inline-block;margin-left:1rem;}.css-ap0i2q:hover{color:white;}</style><a title="GitHub" href="https://github.com/mjackson/unpkg" class="css-ap0i2q"><svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 496 512" class="css-i6dzq1" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><path d="M165.9 397.4c0 2-2.3 3.6-5.2 3.6-3.3.3-5.6-1.3-5.6-3.6 0-2 2.3-3.6 5.2-3.6 3-.3 5.6 1.3 5.6 3.6zm-31.1-4.5c-.7 2 1.3 4.3 4.3 4.9 2.6 1 5.6 0 6.2-2s-1.3-4.3-4.3-5.2c-2.6-.7-5.5.3-6.2 2.3zm44.2-1.7c-2.9.7-4.9 2.6-4.6 4.9.3 2 2.9 3.3 5.9 2.6 2.9-.7 4.9-2.6 4.6-4.6-.3-1.9-3-3.2-5.9-2.9zM244.8 8C106.1 8 0 113.3 0 252c0 110.9 69.8 205.8 169.5 239.2 12.8 2.3 17.3-5.6 17.3-12.1 0-6.2-.3-40.4-.3-61.4 0 0-70 15-84.7-29.8 0 0-11.4-29.1-27.8-36.6 0 0-22.9-15.7 1.6-15.4 0 0 24.9 2 38.6 25.8 21.9 38.6 58.6 27.5 72.9 20.9 2.3-16 8.8-27.1 16-33.7-55.9-6.2-112.3-14.3-112.3-110.5 0-27.5 7.6-41.3 23.6-58.9-2.6-6.5-11.1-33.3 2.6-67.9 20.9-6.5 69 27 69 27 20-5.6 41.5-8.5 62.8-8.5s42.8 2.9 62.8 8.5c0 0 48.1-33.6 69-27 13.7 34.7 5.2 61.4 2.6 67.9 16 17.7 25.8 31.5 25.8 58.9 0 96.5-58.9 104.2-114.8 110.5 9.2 7.9 17 22.9 17 46.4 0 33.7-.3 75.4-.3 83.6 0 6.5 4.6 14.4 17.3 12.1C428.2 457.8 496 362.9 496 252 496 113.3 383.5 8 244.8 8zM97.2 352.9c-1.3 1-1 3.3.7 5.2 1.6 1.6 3.9 2.3 5.2 1 1.3-1 1-3.3-.7-5.2-1.6-1.6-3.9-2.3-5.2-1zm-10.8-8.1c-.7 1.3.3 2.9 2.3 3.9 1.6 1 3.6.7 4.3-.7.7-1.3-.3-2.9-2.3-3.9-2-.6-3.6-.3-4.3.7zm32.4 35.6c-1.6 1.3-1 4.3 1.3 6.2 2.3 2.3 5.2 2.6 6.5 1 1.3-1.3.7-4.3-1.3-6.2-2.2-2.3-5.2-2.6-6.5-1zm-11.4-14.7c-1.6 1-1.6 3.6 0 5.9 1.6 2.3 4.3 3.3 5.6 2.3 1.6-1.3 1.6-3.9 0-6.2-1.4-2.3-4-3.3-5.6-2z"></path></svg></a></p></div></footer></div><script src="/react@16.8.6/umd/react.production.min.js"></script><script src="/react-dom@16.8.6/umd/react-dom.production.min.js"></script><script src="/@emotion/core@10.0.6/dist/core.umd.min.js"></script><script>'use strict';(function(m,v,c){function w(){w=Object.assign||function(a){for(var b=1;b<arguments.length;b++){var c=arguments[b],f;for(f in c)Object.prototype.hasOwnProperty.call(c,f)&&(a[f]=c[f])}return a};return w.apply(this,arguments)}function I(a,b){if(null==a)return{};var c={},f=Object.keys(a),g;for(g=0;g<f.length;g++){var h=f[g];0<=b.indexOf(h)||(c[h]=a[h])}return c}function J(a,b){b||(b=a.slice(0));a.raw=b;return a}function K(a){return a&&a.__esModule&&Object.prototype.hasOwnProperty.call(a,
"default")?a["default"]:a}function x(a,b){return b={exports:{}},a(b,b.exports),b.exports}function L(){}function M(){}function fa(a){var b=a.children;a=I(a,["children"]);return E.createElement(N.Provider,{children:b,value:a})}function O(a){return a&&a.map(function(a,c){return m.createElement(a.tag,u({key:c},a.attr),O(a.child))})}function y(a){return function(b){return m.createElement(ha,u({attr:u({},a.attr)},b),O(a.child))}}function ha(a){var b=function(b){var c=a.size||b.size||"1em";if(b.className)var d=
b.className;a.className&&(d=(d?d+" ":"")+a.className);var h=a.attr,n=a.title,l=["attr","title"],q={},p;for(p in a)Object.prototype.hasOwnProperty.call(a,p)&&0>l.indexOf(p)&&(q[p]=a[p]);if(null!=a&&"function"===typeof Object.getOwnPropertySymbols){var k=0;for(p=Object.getOwnPropertySymbols(a);k<p.length;k++)0>l.indexOf(p[k])&&(q[p[k]]=a[p[k]])}return m.createElement("svg",u({stroke:"currentColor",fill:"currentColor",strokeWidth:"0"},b.attr,h,q,{className:d,style:u({color:a.color||b.color},b.style,
a.style),height:c,width:c,xmlns:"http://www.w3.org/2000/svg"}),n&&m.createElement("title",null,n),a.children)};return void 0!==P?m.createElement(P.Consumer,null,function(a){return b(a)}):b(Q)}function z(a,b){var d=b.css;b=I(b,["css"]);return c.jsx(a,w({css:w({},d,{verticalAlign:"text-bottom"})},b))}function ia(a){return z(R,a)}function ja(a){return z(S,a)}function ka(a){return z(T,a)}function la(a){return z(U,a)}function ma(a){var b=a.path,d=a.details,f=[];"/"!==b&&f.push(c.jsx("tr",{key:".."},c.jsx("td",
{css:F}),c.jsx("td",{css:t},c.jsx("a",{title:"Parent directory",href:"../",css:G},"..")),c.jsx("td",{css:t}),c.jsx("td",{css:H})));a=Object.keys(d).reduce(function(a,b){var c=a.subdirs,f=a.files;b=d[b];"directory"===b.type?c.push(b):"file"===b.type&&f.push(b);return a},{subdirs:[],files:[]});var g=a.files;a.subdirs.sort(V("path")).forEach(function(a){a=a.path.substr(1<b.length?b.length+1:1);var d=a+"/";f.push(c.jsx("tr",{key:a},c.jsx("td",{css:F},c.jsx(ia,null)),c.jsx("td",{css:t},c.jsx("a",{title:a,
href:d,css:G},a)),c.jsx("td",{css:t},"-"),c.jsx("td",{css:H},"-")))});g.sort(V("path")).forEach(function(a){var d=a.size,g=a.contentType;a=a.path.substr(1<b.length?b.length+1:1);f.push(c.jsx("tr",{key:a},c.jsx("td",{css:F},c.jsx(ja,null)),c.jsx("td",{css:t},c.jsx("a",{title:a,href:a,css:G},a)),c.jsx("td",{css:t},W(d)),c.jsx("td",{css:H},g)))});return c.jsx("div",{css:{border:"1px solid #dfe2e5",borderRadius:3,borderTopWidth:0,"@media (max-width: 700px)":{borderRightWidth:0,borderLeftWidth:0}}},c.jsx("table",
{css:{width:"100%",borderCollapse:"collapse",borderRadius:2,background:"#fff","@media (max-width: 700px)":{"& th + th + th + th, & td + td + td + td":{display:"none"}}}},c.jsx("thead",null,c.jsx("tr",null,c.jsx("th",null,c.jsx(A,null,"Icon")),c.jsx("th",null,c.jsx(A,null,"Name")),c.jsx("th",null,c.jsx(A,null,"Size")),c.jsx("th",null,c.jsx(A,null,"Content Type")))),c.jsx("tbody",null,f)))}function na(a){a=a.split("/");return a[a.length-1]}function oa(a){var b=a.uri;return c.jsx("div",{css:{padding:20,
textAlign:"center"}},c.jsx("img",{alt:na(a.path),src:b}))}function pa(a){a=a.highlights.slice(0);var b=a.length&&""===a[a.length-1];b&&a.pop();return c.jsx("div",{className:"code-listing",css:{overflowX:"auto",overflowY:"hidden",paddingTop:5,paddingBottom:5}},c.jsx("table",{css:{border:"none",borderCollapse:"collapse",borderSpacing:0}},c.jsx("tbody",null,a.map(function(a,b){var d=b+1;return c.jsx("tr",{key:b},c.jsx("td",{id:"L"+d,css:{paddingLeft:10,paddingRight:10,color:"rgba(27,31,35,.3)",textAlign:"right",
verticalAlign:"top",width:"1%",minWidth:50,userSelect:"none"}},c.jsx("span",null,d)),c.jsx("td",{id:"LC"+d,css:{paddingLeft:10,paddingRight:10,color:"#24292e",whiteSpace:"pre"}},c.jsx("code",{dangerouslySetInnerHTML:{__html:a}})))}),!b&&c.jsx("tr",{key:"no-newline"},c.jsx("td",{css:{paddingLeft:10,paddingRight:10,color:"rgba(27,31,35,.3)",textAlign:"right",verticalAlign:"top",width:"1%",minWidth:50,userSelect:"none"}},"\\"),c.jsx("td",{css:{paddingLeft:10,color:"rgba(27,31,35,.3)",userSelect:"none"}},
"No newline at end of file")))))}function qa(){return c.jsx("div",{css:{padding:20}},c.jsx("p",{css:{textAlign:"center"}},"No preview available."))}function ra(a){var b=a.path,d=a.details,f=m.useContext(N);a=f.packageName;f=f.packageVersion;var g=d.highlights,h=d.uri,n=d.language;d=d.size;var l=b.split("/");l=l[l.length-1];return c.jsx("div",{css:{border:"1px solid #dfe2e5",borderRadius:3,"@media (max-width: 700px)":{borderRightWidth:0,borderLeftWidth:0}}},c.jsx("div",{css:{padding:10,background:"#f6f8fa",
color:"#424242",border:"1px solid #d1d5da",borderTopLeftRadius:3,borderTopRightRadius:3,margin:"-1px -1px 0",display:"flex",flexDirection:"row",alignItems:"center",justifyContent:"space-between","@media (max-width: 700px)":{paddingRight:20,paddingLeft:20}}},c.jsx("span",null,W(d))," ",c.jsx("span",null,n)," ",c.jsx("a",{title:l,href:"/"+a+"@"+f+b,css:{display:"inline-block",textDecoration:"none",padding:"2px 8px",fontWeight:600,fontSize:"0.9rem",color:"#24292e",backgroundColor:"#eff3f6",border:"1px solid rgba(27,31,35,.2)",
borderRadius:3,":hover":{backgroundColor:"#e6ebf1",borderColor:"rgba(27,31,35,.35)"},":active":{backgroundColor:"#e9ecef",borderColor:"rgba(27,31,35,.35)",boxShadow:"inset 0 0.15em 0.3em rgba(27,31,35,.15)"}}},"View Raw")),g?c.jsx(pa,{highlights:g}):h?c.jsx(oa,{path:b,uri:h}):c.jsx(qa,null))}function X(){var a=J(["\n  .code-listing {\n    background: #fbfdff;\n    color: #383a42;\n  }\n  .code-comment,\n  .code-quote {\n    color: #a0a1a7;\n    font-style: italic;\n  }\n  .code-doctag,\n  .code-keyword,\n  .code-link,\n  .code-formula {\n    color: #a626a4;\n  }\n  .code-section,\n  .code-name,\n  .code-selector-tag,\n  .code-deletion,\n  .code-subst {\n    color: #e45649;\n  }\n  .code-literal {\n    color: #0184bb;\n  }\n  .code-string,\n  .code-regexp,\n  .code-addition,\n  .code-attribute,\n  .code-meta-string {\n    color: #50a14f;\n  }\n  .code-built_in,\n  .code-class .code-title {\n    color: #c18401;\n  }\n  .code-attr,\n  .code-variable,\n  .code-template-variable,\n  .code-type,\n  .code-selector-class,\n  .code-selector-attr,\n  .code-selector-pseudo,\n  .code-number {\n    color: #986801;\n  }\n  .code-symbol,\n  .code-bullet,\n  .code-meta,\n  .code-selector-id,\n  .code-title {\n    color: #4078f2;\n  }\n  .code-emphasis {\n    font-style: italic;\n  }\n  .code-strong {\n    font-weight: bold;\n  }\n"]);
X=function(){return a};return a}function Y(){var a=J(["\n  html {\n    box-sizing: border-box;\n  }\n  *,\n  *:before,\n  *:after {\n    box-sizing: inherit;\n  }\n\n  html,\n  body,\n  #root {\n    height: 100%;\n    margin: 0;\n  }\n\n  body {\n    ","\n    font-size: 16px;\n    line-height: 1.5;\n    background: white;\n    color: black;\n  }\n\n  code {\n    ","\n  }\n\n  th,\n  td {\n    padding: 0;\n  }\n\n  select {\n    font-size: inherit;\n  }\n\n  #root {\n    display: flex;\n    flex-direction: column;\n  }\n"]);
Y=function(){return a};return a}var E="default"in m?m["default"]:m;v=v&&v.hasOwnProperty("default")?v["default"]:v;var sa="undefined"!==typeof globalThis?globalThis:"undefined"!==typeof window?window:"undefined"!==typeof global?global:"undefined"!==typeof self?self:{},Z=x(function(a,b){function c(a){if("object"===typeof a&&null!==a){var b=a.$$typeof;switch(b){case g:switch(a=a.type,a){case r:case e:case n:case q:case l:case B:return a;default:switch(a=a&&a.$$typeof,a){case k:case C:case p:return a;
default:return b}}case m:case D:case h:return b}}}function f(a){return c(a)===e}Object.defineProperty(b,"__esModule",{value:!0});var g=(a="function"===typeof Symbol&&Symbol.for)?Symbol.for("react.element"):60103,h=a?Symbol.for("react.portal"):60106,n=a?Symbol.for("react.fragment"):60107,l=a?Symbol.for("react.strict_mode"):60108,q=a?Symbol.for("react.profiler"):60114,p=a?Symbol.for("react.provider"):60109,k=a?Symbol.for("react.context"):60110,r=a?Symbol.for("react.async_mode"):60111,e=a?Symbol.for("react.concurrent_mode"):
60111,C=a?Symbol.for("react.forward_ref"):60112,B=a?Symbol.for("react.suspense"):60113,D=a?Symbol.for("react.memo"):60115,m=a?Symbol.for("react.lazy"):60116;b.typeOf=c;b.AsyncMode=r;b.ConcurrentMode=e;b.ContextConsumer=k;b.ContextProvider=p;b.Element=g;b.ForwardRef=C;b.Fragment=n;b.Lazy=m;b.Memo=D;b.Portal=h;b.Profiler=q;b.StrictMode=l;b.Suspense=B;b.isValidElementType=function(a){return"string"===typeof a||"function"===typeof a||a===n||a===e||a===q||a===l||a===B||"object"===typeof a&&null!==a&&(a.$$typeof===
m||a.$$typeof===D||a.$$typeof===p||a.$$typeof===k||a.$$typeof===C)};b.isAsyncMode=function(a){return f(a)||c(a)===r};b.isConcurrentMode=f;b.isContextConsumer=function(a){return c(a)===k};b.isContextProvider=function(a){return c(a)===p};b.isElement=function(a){return"object"===typeof a&&null!==a&&a.$$typeof===g};b.isForwardRef=function(a){return c(a)===C};b.isFragment=function(a){return c(a)===n};b.isLazy=function(a){return c(a)===m};b.isMemo=function(a){return c(a)===D};b.isPortal=function(a){return c(a)===
h};b.isProfiler=function(a){return c(a)===q};b.isStrictMode=function(a){return c(a)===l};b.isSuspense=function(a){return c(a)===B}});K(Z);var ta=x(function(a,b){});K(ta);x(function(a){a.exports=Z});(function(){try{if(!Object.assign)return!1;var a=new String("abc");a[5]="de";if("5"===Object.getOwnPropertyNames(a)[0])return!1;var b={};for(a=0;10>a;a++)b["_"+String.fromCharCode(a)]=a;if("0123456789"!==Object.getOwnPropertyNames(b).map(function(a){return b[a]}).join(""))return!1;var c={};"abcdefghijklmnopqrst".split("").forEach(function(a){c[a]=
a});return"abcdefghijklmnopqrst"!==Object.keys(Object.assign({},c)).join("")?!1:!0}catch(f){return!1}})();Function.call.bind(Object.prototype.hasOwnProperty);M.resetWarningCache=L;var ua=function(){function a(a,b,c,d,l,q){if("SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED"!==q)throw a=Error("Calling PropTypes validators directly is not supported by the `prop-types` package. Use PropTypes.checkPropTypes() to call them. Read more at http://fb.me/use-check-prop-types"),a.name="Invariant Violation",a;}
function b(){return a}a.isRequired=a;var c={array:a,bool:a,func:a,number:a,object:a,string:a,symbol:a,any:a,arrayOf:b,element:a,elementType:a,instanceOf:b,node:a,objectOf:b,oneOf:b,oneOfType:b,shape:b,exact:b,checkPropTypes:M,resetWarningCache:L};return c.PropTypes=c};x(function(a){a.exports=ua()});var N=m.createContext(),va=Object.assign||function(a){for(var b=1;b<arguments.length;b++){var c=arguments[b],f;for(f in c)Object.prototype.hasOwnProperty.call(c,f)&&(a[f]=c[f])}return a},wa={border:0,clip:"rect(0 0 0 0)",
height:"1px",width:"1px",margin:"-1px",padding:0,overflow:"hidden",position:"absolute"},A=function(a){return E.createElement("div",va({style:wa},a))},aa=x(function(a){(function(b,c){a.exports=c()})(sa,function(){function a(a){if(!a)return!0;if(!g(a)||0!==a.length)for(var c in a)if(p.call(a,c))return!1;return!0}function c(a){return"number"===typeof a||"[object Number]"===q.call(a)}function f(a){return"string"===typeof a||"[object String]"===q.call(a)}function g(a){return"object"===typeof a&&"number"===
typeof a.length&&"[object Array]"===q.call(a)}function h(a){var c=parseInt(a);return c.toString()===a?c:a}function n(b,e,d,g){c(e)&&(e=[e]);if(a(e))return b;if(f(e))return n(b,e.split("."),d,g);var r=h(e[0]);if(1===e.length)return e=b[r],void 0!==e&&g||(b[r]=d),e;void 0===b[r]&&(c(r)?b[r]=[]:b[r]={});return n(b[r],e.slice(1),d,g)}function l(b,e){c(e)&&(e=[e]);if(!a(b)){if(a(e))return b;if(f(e))return l(b,e.split("."));var d=h(e[0]),r=b[d];if(1===e.length)void 0!==r&&(g(b)?b.splice(d,1):delete b[d]);
else if(void 0!==b[d])return l(b[d],e.slice(1));return b}}var q=Object.prototype.toString,p=Object.prototype.hasOwnProperty,k={ensureExists:function(a,b,c){return n(a,b,c,!0)},set:function(a,b,c,d){return n(a,b,c,d)},insert:function(a,b,c,d){var e=k.get(a,b);d=~~d;g(e)||(e=[],k.set(a,b,e));e.splice(d,0,c)},empty:function(b,d){if(a(d))return b;if(!a(b)){var e,h;if(!(e=k.get(b,d)))return b;if(f(e))return k.set(b,d,"");if("boolean"===typeof e||"[object Boolean]"===q.call(e))return k.set(b,d,!1);if(c(e))return k.set(b,
d,0);if(g(e))e.length=0;else if("object"===typeof e&&"[object Object]"===q.call(e))for(h in e)p.call(e,h)&&delete e[h];else return k.set(b,d,null)}},push:function(a,b){var c=k.get(a,b);g(c)||(c=[],k.set(a,b,c));c.push.apply(c,Array.prototype.slice.call(arguments,2))},coalesce:function(a,b,c){for(var d,e=0,f=b.length;e<f;e++)if(void 0!==(d=k.get(a,b[e])))return d;return c},get:function(b,d,g){c(d)&&(d=[d]);if(a(d))return b;if(a(b))return g;if(f(d))return k.get(b,d.split("."),g);var e=h(d[0]);return 1===
d.length?void 0===b[e]?g:b[e]:k.get(b[e],d.slice(1),g)},del:function(a,b){return l(a,b)}};return k})});var ba=function(a){return function(b){return typeof b===a}};var xa=function(a,b){var c=1,f=b||function(a,b){return b};"-"===a[0]&&(c=-1,a=a.substr(1));return function(b,d){var g;b=f(a,aa.get(b,a));d=f(a,aa.get(d,a));b<d&&(g=-1);b>d&&(g=1);b===d&&(g=0);return g*c}};var V=function(){var a=Array.prototype.slice.call(arguments),b=a.filter(ba("string")),c=a.filter(ba("function"))[0];return function(a,
d){for(var f=b.length,g=0,l=0;0===g&&l<f;)g=xa(b[l],c)(a,d),l++;return g}};let ca="B kB MB GB TB PB EB ZB YB".split(" "),da=(a,b)=>{let c=a;"string"===typeof b?c=a.toLocaleString(b):!0===b&&(c=a.toLocaleString());return c};var W=(a,b)=>{if(!Number.isFinite(a))throw new TypeError(`Expected a finite number, got ${typeof a}: ${a}`);b=Object.assign({},b);if(b.signed&&0===a)return" 0 B";var c=0>a;let f=c?"-":b.signed?"+":"";c&&(a=-a);if(1>a)return a=da(a,b.locale),f+a+" B";c=Math.min(Math.floor(Math.log10(a)/
3),ca.length-1);a=Number((a/Math.pow(1E3,c)).toPrecision(3));a=da(a,b.locale);return f+a+" "+ca[c]},Q={color:void 0,size:void 0,className:void 0,style:void 0,attr:void 0},P=m.createContext&&m.createContext(Q),u=function(){u=Object.assign||function(a){for(var b,c=1,f=arguments.length;c<f;c++){b=arguments[c];for(var g in b)Object.prototype.hasOwnProperty.call(b,g)&&(a[g]=b[g])}return a};return u.apply(this,arguments)},R=function(a){return y({tag:"svg",attr:{viewBox:"0 0 14 16"},child:[{tag:"path",attr:{fillRule:"evenodd",
d:"M13 4H7V3c0-.66-.31-1-1-1H1c-.55 0-1 .45-1 1v10c0 .55.45 1 1 1h12c.55 0 1-.45 1-1V5c0-.55-.45-1-1-1zM6 4H1V3h5v1z"}}]})(a)};R.displayName="GoFileDirectory";var S=function(a){return y({tag:"svg",attr:{viewBox:"0 0 12 16"},child:[{tag:"path",attr:{fillRule:"evenodd",d:"M6 5H2V4h4v1zM2 8h7V7H2v1zm0 2h7V9H2v1zm0 2h7v-1H2v1zm10-7.5V14c0 .55-.45 1-1 1H1c-.55 0-1-.45-1-1V2c0-.55.45-1 1-1h7.5L12 4.5zM11 5L8 2H1v12h10V5z"}}]})(a)};S.displayName="GoFile";var U=function(a){return y({tag:"svg",attr:{viewBox:"0 0 496 512"},
child:[{tag:"path",attr:{d:"M165.9 397.4c0 2-2.3 3.6-5.2 3.6-3.3.3-5.6-1.3-5.6-3.6 0-2 2.3-3.6 5.2-3.6 3-.3 5.6 1.3 5.6 3.6zm-31.1-4.5c-.7 2 1.3 4.3 4.3 4.9 2.6 1 5.6 0 6.2-2s-1.3-4.3-4.3-5.2c-2.6-.7-5.5.3-6.2 2.3zm44.2-1.7c-2.9.7-4.9 2.6-4.6 4.9.3 2 2.9 3.3 5.9 2.6 2.9-.7 4.9-2.6 4.6-4.6-.3-1.9-3-3.2-5.9-2.9zM244.8 8C106.1 8 0 113.3 0 252c0 110.9 69.8 205.8 169.5 239.2 12.8 2.3 17.3-5.6 17.3-12.1 0-6.2-.3-40.4-.3-61.4 0 0-70 15-84.7-29.8 0 0-11.4-29.1-27.8-36.6 0 0-22.9-15.7 1.6-15.4 0 0 24.9 2 38.6 25.8 21.9 38.6 58.6 27.5 72.9 20.9 2.3-16 8.8-27.1 16-33.7-55.9-6.2-112.3-14.3-112.3-110.5 0-27.5 7.6-41.3 23.6-58.9-2.6-6.5-11.1-33.3 2.6-67.9 20.9-6.5 69 27 69 27 20-5.6 41.5-8.5 62.8-8.5s42.8 2.9 62.8 8.5c0 0 48.1-33.6 69-27 13.7 34.7 5.2 61.4 2.6 67.9 16 17.7 25.8 31.5 25.8 58.9 0 96.5-58.9 104.2-114.8 110.5 9.2 7.9 17 22.9 17 46.4 0 33.7-.3 75.4-.3 83.6 0 6.5 4.6 14.4 17.3 12.1C428.2 457.8 496 362.9 496 252 496 113.3 383.5 8 244.8 8zM97.2 352.9c-1.3 1-1 3.3.7 5.2 1.6 1.6 3.9 2.3 5.2 1 1.3-1 1-3.3-.7-5.2-1.6-1.6-3.9-2.3-5.2-1zm-10.8-8.1c-.7 1.3.3 2.9 2.3 3.9 1.6 1 3.6.7 4.3-.7.7-1.3-.3-2.9-2.3-3.9-2-.6-3.6-.3-4.3.7zm32.4 35.6c-1.6 1.3-1 4.3 1.3 6.2 2.3 2.3 5.2 2.6 6.5 1 1.3-1.3.7-4.3-1.3-6.2-2.2-2.3-5.2-2.6-6.5-1zm-11.4-14.7c-1.6 1-1.6 3.6 0 5.9 1.6 2.3 4.3 3.3 5.6 2.3 1.6-1.3 1.6-3.9 0-6.2-1.4-2.3-4-3.3-5.6-2z"}}]})(a)};
U.displayName="FaGithub";var T=function(a){return y({tag:"svg",attr:{viewBox:"0 0 512 512"},child:[{tag:"path",attr:{d:"M459.37 151.716c.325 4.548.325 9.097.325 13.645 0 138.72-105.583 298.558-298.558 298.558-59.452 0-114.68-17.219-161.137-47.106 8.447.974 16.568 1.299 25.34 1.299 49.055 0 94.213-16.568 130.274-44.832-46.132-.975-84.792-31.188-98.112-72.772 6.498.974 12.995 1.624 19.818 1.624 9.421 0 18.843-1.3 27.614-3.573-48.081-9.747-84.143-51.98-84.143-102.985v-1.299c13.969 7.797 30.214 12.67 47.431 13.319-28.264-18.843-46.781-51.005-46.781-87.391 0-19.492 5.197-37.36 14.294-52.954 51.655 63.675 129.3 105.258 216.365 109.807-1.624-7.797-2.599-15.918-2.599-24.04 0-57.828 46.782-104.934 104.934-104.934 30.213 0 57.502 12.67 76.67 33.137 23.715-4.548 46.456-13.32 66.599-25.34-7.798 24.366-24.366 44.833-46.132 57.827 21.117-2.273 41.584-8.122 60.426-16.243-14.292 20.791-32.161 39.308-52.628 54.253z"}}]})(a)};
T.displayName="FaTwitter";var G={color:"#0076ff",textDecoration:"none",":hover":{textDecoration:"underline"}},t={paddingTop:6,paddingRight:3,paddingBottom:6,paddingLeft:3,borderTop:"1px solid #eaecef"},F=w({},t,{color:"#424242",width:17,paddingRight:2,paddingLeft:10,"@media (max-width: 700px)":{paddingLeft:20}}),H=w({},t,{textAlign:"right",paddingRight:10,"@media (max-width: 700px)":{paddingRight:20}}),ya=c.css(Y(),'\nfont-family: -apple-system,\n  BlinkMacSystemFont,\n  "Segoe UI",\n  "Roboto",\n  "Oxygen",\n  "Ubuntu",\n  "Cantarell",\n  "Fira Sans",\n  "Droid Sans",\n  "Helvetica Neue",\n  sans-serif;\n',
"\nfont-family: Menlo,\n  Monaco,\n  Lucida Console,\n  Liberation Mono,\n  DejaVu Sans Mono,\n  Bitstream Vera Sans Mono,\n  Courier New,\n  monospace;\n"),za=c.css(X()),ea={color:"#0076ff",textDecoration:"none",":hover":{textDecoration:"underline"}};v.hydrate(E.createElement(function(a){var b=a.packageName,d=a.packageVersion,f=a.availableVersions;f=void 0===f?[]:f;var g=a.filename;a=a.target;var h=[];if("/"===g)h.push(b);else{var n="/browse/"+b+"@"+d;h.push(c.jsx("a",{href:n+"/",css:ea},b));g=g.replace(/^\/+/,
"").replace(/\/+$/,"").split("/");var l=g.pop();g.forEach(function(a){n+="/"+a;h.push(c.jsx("a",{href:n+"/",css:ea},a))});h.push(l)}return c.jsx(fa,{packageName:b,packageVersion:d},c.jsx(m.Fragment,null,c.jsx(c.Global,{styles:ya}),c.jsx(c.Global,{styles:za}),c.jsx("div",{css:{flex:"1 0 auto"}},c.jsx("div",{css:{maxWidth:940,padding:"0 20px",margin:"0 auto"}},c.jsx("header",{css:{textAlign:"center"}},c.jsx("h1",{css:{fontSize:"3rem",marginTop:"2rem"}},c.jsx("a",{href:"/",css:{color:"#000",textDecoration:"none"}},
"UNPKG"))),c.jsx("header",{css:{display:"flex",flexDirection:"row",alignItems:"center","@media (max-width: 700px)":{flexDirection:"column-reverse",alignItems:"flex-start"}}},c.jsx("h1",{css:{fontSize:"1.5rem",fontWeight:"normal",flex:1}},c.jsx("nav",null,h.map(function(a,b,d){return c.jsx("span",{key:b},0!==b&&c.jsx("span",{css:{paddingLeft:5,paddingRight:5}},"/"),b===d.length-1?c.jsx("strong",null,a):a)}))),c.jsx("p",{css:{marginLeft:20,"@media (max-width: 700px)":{marginLeft:0,marginBottom:0}}},
c.jsx("label",null,"Version:"," ",c.jsx("select",{name:"version",defaultValue:d,onChange:function(a){window.location.href=window.location.href.replace("@"+d,"@"+a.target.value)},css:{appearance:"none",cursor:"pointer",padding:"4px 24px 4px 8px",fontWeight:600,fontSize:"0.9em",color:"#24292e",border:"1px solid rgba(27,31,35,.2)",borderRadius:3,backgroundColor:"#eff3f6",backgroundImage:"url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAKCAYAAAC9vt6cAAAAAXNSR0IArs4c6QAAARFJREFUKBVjZAACNS39RhBNKrh17WI9o4quoT3Dn78HSNUMUs/CzOTI/O7Vi4dCYpJ3/jP+92BkYGAlyiBGhm8MjIxJt65e3MQM0vDu9YvLYmISILYZELOBxHABRkaGr0yMzF23r12YDFIDNgDEePv65SEhEXENBkYGFSAXuyGMjF8Z/jOsvX3tYiFIDwgwQSgIaaijnvj/P8M5IO8HsjiY/f//D4b//88A1SQhywG9jQr09PS4v/1mPAeUUPzP8B8cJowMjL+Bqu6xMQmaXL164AuyDgwDQJLa2qYSP//9vARkCoMVMzK8YeVkNbh+9uxzMB+JwGoASF5Vx0jz/98/18BqmZi171w9D2EjaaYKEwAEK00XQLdJuwAAAABJRU5ErkJggg==)",
backgroundPosition:"right 8px center",backgroundRepeat:"no-repeat",backgroundSize:"auto 25%",":hover":{backgroundColor:"#e6ebf1",borderColor:"rgba(27,31,35,.35)"},":active":{backgroundColor:"#e9ecef",borderColor:"rgba(27,31,35,.35)",boxShadow:"inset 0 0.15em 0.3em rgba(27,31,35,.15)"}}},f.map(function(a){return c.jsx("option",{key:a,value:a},a)})))))),c.jsx("div",{css:{maxWidth:940,padding:"0 20px",margin:"0 auto","@media (max-width: 700px)":{padding:0,margin:0}}},"directory"===a.type?c.jsx(ma,{path:a.path,
details:a.details}):"file"===a.type?c.jsx(ra,{path:a.path,details:a.details}):null)),c.jsx("footer",{css:{marginTop:"5rem",background:"black",color:"#aaa"}},c.jsx("div",{css:{maxWidth:940,padding:"10px 20px",margin:"0 auto",display:"flex",flexDirection:"row",alignItems:"center",justifyContent:"space-between"}},c.jsx("p",null,"\u00a9 ",(new Date).getFullYear()," UNPKG"),c.jsx("p",{css:{fontSize:"1.5rem"}},c.jsx("a",{title:"Twitter",href:"https://twitter.com/unpkg",css:{color:"#aaa",display:"inline-block",
":hover":{color:"white"}}},c.jsx(ka,null)),c.jsx("a",{title:"GitHub",href:"https://github.com/mjackson/unpkg",css:{color:"#aaa",display:"inline-block",marginLeft:"1rem",":hover":{color:"white"}}},c.jsx(la,null)))))))},window.__DATA__||{}),document.getElementById("root"))})(React,ReactDOM,emotionCore);
</script></body></html>