/*
 Highcharts JS v5.0.8 (2017-03-08)
 Boost module

 (c) 2010-2016 Highsoft AS
 Author: Torstein Honsi

 License: www.highcharts.com/license
*/
(function(H){"object"===typeof module&&module.exports?module.exports=H:H(Highcharts)})(function(H){(function(h){function w(a){return a.series.length>=D(a.options.boost&&a.options.boost.seriesThreshold,10)}function x(a){function c(){var a=Array.prototype.slice.call(arguments),c=-Number.MAX_VALUE;y(a,function(a){if("undefined"!==typeof a&&"undefined"!==typeof a.length&&0<a.length)return c=a.length,!0});return c}return w(a.chart)||c(a.processedXData,a.options.data,a.points)>=(a.options.boostThreshold||
Number.MAX_VALUE)}function H(a){function c(b,c){c=a.createShader("vertex"===c?a.VERTEX_SHADER:a.FRAGMENT_SHADER);a.shaderSource(c,b);a.compileShader(c);return a.getShaderParameter(c,a.COMPILE_STATUS)?c:!1}function d(){function d(b){return a.getUniformLocation(l,b)}var e=c("#version 100\nprecision highp float;\nattribute vec4 aVertexPosition;\nattribute vec4 aColor;\nvarying highp vec2 position;\nvarying highp vec4 vColor;\nuniform mat4 uPMatrix;\nuniform float pSize;\nuniform float translatedThreshold;\nuniform bool hasThreshold;\nuniform bool skipTranslation;\nuniform float xAxisTrans;\nuniform float xAxisMin;\nuniform float xAxisMinPad;\nuniform float xAxisPointRange;\nuniform float xAxisLen;\nuniform bool  xAxisPostTranslate;\nuniform float xAxisOrdinalSlope;\nuniform float xAxisOrdinalOffset;\nuniform float xAxisPos;\nuniform bool  xAxisCVSCoord;\nuniform float yAxisTrans;\nuniform float yAxisMin;\nuniform float yAxisMinPad;\nuniform float yAxisPointRange;\nuniform float yAxisLen;\nuniform bool  yAxisPostTranslate;\nuniform float yAxisOrdinalSlope;\nuniform float yAxisOrdinalOffset;\nuniform float yAxisPos;\nuniform bool  yAxisCVSCoord;\nuniform bool  isBubble;\nuniform bool  bubbleSizeByArea;\nuniform float bubbleZMin;\nuniform float bubbleZMax;\nuniform float bubbleZThreshold;\nuniform float bubbleMinSize;\nuniform float bubbleMaxSize;\nuniform bool  bubbleSizeAbs;\nuniform bool  isInverted;\nfloat bubbleRadius(){\nfloat value \x3d aVertexPosition.w;\nfloat zMax \x3d bubbleZMax;\nfloat zMin \x3d bubbleZMin;\nfloat radius \x3d 0.0;\nfloat pos \x3d 0.0;\nfloat zRange \x3d zMax - zMin;\nif (bubbleSizeAbs){\nvalue \x3d value - bubbleZThreshold;\nzMax \x3d max(zMax - bubbleZThreshold, zMin - bubbleZThreshold);\nzMin \x3d 0.0;\n}\nif (value \x3c zMin){\nradius \x3d bubbleZMin / 2.0 - 1.0;\n} else {\npos \x3d zRange \x3e 0.0 ? (value - zMin) / zRange : 0.5;\nif (bubbleSizeByArea \x26\x26 pos \x3e 0.0){\npos \x3d sqrt(pos);\n}\nradius \x3d ceil(bubbleMinSize + pos * (bubbleMaxSize - bubbleMinSize)) / 2.0;\n}\nreturn radius * 2.0;\n}\nfloat translate(float val,\nfloat pointPlacement,\nfloat localA,\nfloat localMin,\nfloat minPixelPadding,\nfloat pointRange,\nfloat len,\nbool  cvsCoord\n){\nfloat sign \x3d 1.0;\nfloat cvsOffset \x3d 0.0;\nif (cvsCoord) {\nsign *\x3d -1.0;\ncvsOffset \x3d len;\n}\nreturn sign * (val - localMin) * localA + cvsOffset + \n(sign * minPixelPadding);\n}\nfloat xToPixels(float value){\nif (skipTranslation){\nreturn value;// + xAxisPos;\n}\nreturn translate(value, 0.0, xAxisTrans, xAxisMin, xAxisMinPad, xAxisPointRange, xAxisLen, xAxisCVSCoord);// + xAxisPos;\n}\nfloat yToPixels(float value, float checkTreshold){\nfloat v;\nif (skipTranslation){\nv \x3d value;// + yAxisPos;\n} else {\nv \x3d translate(value, 0.0, yAxisTrans, yAxisMin, yAxisMinPad, yAxisPointRange, yAxisLen, yAxisCVSCoord);// + yAxisPos;\n}\nif (checkTreshold \x3e 0.0 \x26\x26 hasThreshold) {\nv \x3d min(v, translatedThreshold);\n}\nreturn v;\n}\nvoid main(void) {\nif (isBubble){\ngl_PointSize \x3d bubbleRadius();\n} else {\ngl_PointSize \x3d pSize;\n}\nvColor \x3d aColor;\nif (isInverted) {\ngl_Position \x3d uPMatrix * vec4(xToPixels(aVertexPosition.y) + yAxisPos, yToPixels(aVertexPosition.x, aVertexPosition.z) + xAxisPos, 0.0, 1.0);\n} else {\ngl_Position \x3d uPMatrix * vec4(xToPixels(aVertexPosition.x) + xAxisPos, yToPixels(aVertexPosition.y, aVertexPosition.z) + yAxisPos, 0.0, 1.0);\n}\n}",
"vertex"),k=c("precision highp float;\nuniform vec4 fillColor;\nvarying highp vec2 position;\nvarying highp vec4 vColor;\nuniform sampler2D uSampler;\nuniform bool isCircle;\nuniform bool hasColor;\nvoid main(void) {\nvec4 col \x3d fillColor;\nif (hasColor) {\ncol \x3d vColor;\n}\nif (isCircle) {\ngl_FragColor \x3d col * texture2D(uSampler, gl_PointCoord.st);\n} else {\ngl_FragColor \x3d col;\n}\n}","fragment");if(!e||!k)return l=!1;l=a.createProgram();a.attachShader(l,e);a.attachShader(l,k);a.linkProgram(l);
a.useProgram(l);a.bindAttribLocation(l,0,"aVertexPosition");h=d("uPMatrix");v=d("pSize");E=d("fillColor");F=d("isBubble");f=d("bubbleSizeAbs");r=d("bubbleSizeByArea");z=d("uSampler");b=d("skipTranslation");n=d("isCircle");g=d("isInverted");return!0}function k(b,c){b=e[b]=e[b]||a.getUniformLocation(l,b);a.uniform1f(b,c)}var e={},l,h,v,E,F,f,r,b,n,g,z;a&&d();return{psUniform:function(){return v},pUniform:function(){return h},fillColorUniform:function(){return E},setBubbleUniforms:function(b,c,d){var e=
b.options,l=Number.MAX_VALUE,h=-Number.MAX_VALUE;"bubble"===b.type&&(l=D(e.zMin,Math.min(l,Math.max(c,!1===e.displayNegative?e.zThreshold:-Number.MAX_VALUE))),h=D(e.zMax,Math.max(h,d)),a.uniform1i(F,1),a.uniform1i(n,1),a.uniform1i(r,"width"!==b.options.sizeBy),a.uniform1i(f,b.options.sizeByAbsoluteValue),k("bubbleZMin",l),k("bubbleZMax",h),k("bubbleZThreshold",b.options.zThreshold),k("bubbleMinSize",b.minPxSize),k("bubbleMaxSize",b.maxPxSize))},bind:function(){a.useProgram(l)},program:function(){return l},
create:d,setUniform:k,setPMatrix:function(b){a.uniformMatrix4fv(h,!1,b)},setColor:function(b){a.uniform4f(E,b[0]/255,b[1]/255,b[2]/255,b[3])},setPointSize:function(b){a.uniform1f(v,b)},setSkipTranslation:function(c){a.uniform1i(b,!0===c?1:0)},setTexture:function(){a.uniform1i(z,0)},setDrawAsCircle:function(b){a.uniform1i(n,b?1:0)},reset:function(){a.uniform1i(F,0);a.uniform1i(n,0)},setInverted:function(b){a.uniform1i(g,b)},destroy:function(){a&&l&&a.deleteProgram(l)}}}function X(a,c,d){var k=!1,e=
!1,l=d||2,h=!1,v=0,g;return{destroy:function(){k&&a.deleteBuffer(k)},bind:function(){if(!k)return!1;a.vertexAttribPointer(e,l,a.FLOAT,!1,0,0)},data:g,build:function(d,f,r){g=d||[];if(!(g&&0!==g.length||h))return k=!1;l=r||l;k&&a.deleteBuffer(k);k=a.createBuffer();a.bindBuffer(a.ARRAY_BUFFER,k);a.bufferData(a.ARRAY_BUFFER,h||new Float32Array(g),a.STATIC_DRAW);e=a.getAttribLocation(c.program(),f);a.enableVertexAttribArray(e);return!0},render:function(c,d,e){var b=h?h.length:g.length;if(!k||!b)return!1;
if(!c||c>b||0>c)c=0;if(!d||d>b)d=b;a.drawArrays(a[(e||"points").toUpperCase()],c/l,(d-c)/l);return!0},allocate:function(a){v=-1;h=new Float32Array(4*a)},push:function(a,c,d,b){h&&(h[++v]=a,h[++v]=c,h[++v]=d,h[++v]=b)}}}function ga(a){function c(a){var b,c;return x(a)?(b=!!a.options.stacking,c=a.xData||a.options.xData||a.processedXData,b=(b?a.data:c||a.options.data).length,"treemap"===a.type?b*=12:"heatmap"===a.type?b*=6:O[a.type]&&(b*=2),b):0}function d(){b.clear(b.COLOR_BUFFER_BIT|b.DEPTH_BUFFER_BIT)}
function k(a,b){function c(a){a&&(b.colorData.push(a[0]),b.colorData.push(a[1]),b.colorData.push(a[2]),b.colorData.push(a[3]))}function d(a,b,d,e,k){c(k);p.usePreallocated?r.push(a,b,d?1:0,e||1):(z.push(a),z.push(b),z.push(d?1:0),z.push(e||1))}function e(a,b,e,k,f){c(f);d(a+e,b);c(f);d(a,b);c(f);d(a,b+k);c(f);d(a,b+k);c(f);d(a+e,b+k);c(f);d(a+e,b)}var k=a.pointArrayMap&&"low,high"===a.pointArrayMap.join(","),B=a.chart,f=a.options,N=!!f.stacking,l=f.data,g=a.xAxis.getExtremes(),v=g.min,n=g.max,g=a.yAxis.getExtremes(),
u=g.min,q=g.max,g=a.xData||f.xData||a.processedXData,w=a.yData||f.yData||a.processedYData,m=a.zData||f.zData||a.processedZData,F=a.yAxis,A=a.xAxis,x=!g||0===g.length,t=a.points||!1,C=!1,E,I,J,G=N?a.data:g||l;f.boostData&&0<f.boostData.length||(a.closestPointRangePx=Number.MAX_VALUE,t&&0<t.length?(b.skipTranslation=!0,b.drawMode="triangles",t[0].node&&t[0].node.levelDynamic&&t.sort(function(a,b){if(a.node){if(a.node.levelDynamic>b.node.levelDynamic)return 1;if(a.node.levelDynamic<b.node.levelDynamic)return-1}return 0}),
y(t,function(b){var c=b.plotY,d;void 0===c||isNaN(c)||null===b.y||(c=b.shapeArgs,d=b.pointAttr&&b.pointAttr[""]||b.series.pointAttribs(b),b=d["stroke-width"],I=h.color(d.fill).rgba,I[0]/=255,I[1]/=255,I[2]/=255,"treemap"===a.type&&(b=b||1,J=h.color(d.stroke).rgba,J[0]/=255,J[1]/=255,J[2]/=255,e(c.x,c.y,c.width,c.height,J),b/=2),e(c.x+b,c.y+b,c.width-2*b,c.height-2*b,I))})):y(G,function(c,e){var f,h,l,g=!1,K=!1,Y=!1,Z=!1,r=O[a.type],t=!1,T=!0;if("undefined"===typeof B.index)return!1;x?(f=c[0],h=c[1],
G[e+1]&&(K=G[e+1][0]),G[e-1]&&(g=G[e-1][0]),3<=c.length&&(l=c[2],c[2]>b.zMax&&(b.zMax=c[2]),c[2]<b.zMin&&(b.zMin=c[2]))):(f=c,h=w[e],G[e+1]&&(K=G[e+1]),G[e-1]&&(g=G[e-1]),m&&m.length&&(l=m[e],m[e]>b.zMax&&(b.zMax=m[e]),m[e]<b.zMin&&(b.zMin=m[e])));K&&K>=v&&K<=n&&(Y=!0);g&&g>=v&&g<=n&&(Z=!0);k?(x&&(h=c.slice(1,3)),h=h[1]):N&&(f=c.x,h=c.stackY);a.requireSorting||(T=h>=u&&h<=q);h&&T&&(f>=v&&f<=n&&(t=!0),t||Y||Z)&&(p.useGPUTranslations||(b.skipTranslation=!0,f=A.toPixels(f,!0),h=F.toPixels(h,!0)),r&&
(E=0,0>h&&(E=h,h=0),p.useGPUTranslations||(E=F.toPixels(E,!0)),d(f,E,0,0,!1)),b.hasMarkers&&!1!==C&&(a.closestPointRangePx=Math.min(a.closestPointRangePx,Math.abs(f-C))),d(f,h,0,"bubble"===a.type?l||1:2,!1),C=f)}))}function e(){u=[];C.data=z=[];w=[]}function l(a){f&&(f.setUniform("xAxisTrans",a.transA),f.setUniform("xAxisMin",a.min),f.setUniform("xAxisMinPad",a.minPixelPadding),f.setUniform("xAxisPointRange",a.pointRange),f.setUniform("xAxisLen",a.len),f.setUniform("xAxisPos",a.pos),f.setUniform("xAxisCVSCoord",
!a.horiz))}function g(a){f&&(f.setUniform("yAxisTrans",a.transA),f.setUniform("yAxisMin",a.min),f.setUniform("yAxisMinPad",a.minPixelPadding),f.setUniform("yAxisPointRange",a.pointRange),f.setUniform("yAxisLen",a.len),f.setUniform("yAxisPos",a.pos),f.setUniform("yAxisCVSCoord",!a.horiz))}function v(a,b){f.setUniform("hasThreshold",a);f.setUniform("translatedThreshold",b)}function q(c){if(c)n=c.chartWidth||800,A=c.chartHeight||400;else return!1;if(!b||!n||!A)return!1;p.timeRendering&&console.time("gl rendering");
f.bind();b.viewport(0,0,n,A);f.setPMatrix([2/n,0,0,0,0,-(2/A),0,0,0,0,-2,0,-1,1,-1,1]);b.lineWidth(p.lineWidth);r.build(C.data,"aVertexPosition",4);r.bind();m&&(b.bindTexture(b.TEXTURE_2D,L),f.setTexture(L));f.setInverted(c.options.chart?c.options.chart.inverted:!1);y(u,function(a,c){var d=a.series.options,e=d.threshold,k=P(e),e=a.series.yAxis.getThreshold(e),K=D(d.marker?d.marker.enabled:null,a.series.xAxis.isRadial?!0:null,a.series.closestPointRangePx>2*((d.marker?d.marker.radius:10)||10)),B=a.series.fillOpacity?
(new aa(a.series.color)).setOpacity(D(d.fillOpacity,.85)).get():a.series.color;r.bind();d.colorByPoint&&(B=a.series.chart.options.colors[c]);B=h.color(B).rgba;p.useAlpha||(B[3]=1);"add"===d.boostBlending?(b.blendFunc(b.SRC_ALPHA,b.ONE),b.blendEquation(b.FUNC_ADD)):"mult"===d.boostBlending?b.blendFunc(b.DST_COLOR,b.ZERO):"darken"===d.boostBlending?(b.blendFunc(b.ONE,b.ONE),b.blendEquation(b.FUNC_MIN)):(b.blendFunc(b.SRC_ALPHA,b.ONE_MINUS_SRC_ALPHA),b.blendEquation(b.FUNC_ADD));f.reset();0<a.colorData.length&&
(f.setUniform("hasColor",1),c=X(b,f),c.build(a.colorData,"aColor",4),c.bind());f.setColor(B);l(a.series.xAxis);g(a.series.yAxis);v(k,e);"points"===a.drawMode&&(d.marker&&d.marker.radius?f.setPointSize(2*d.marker.radius):f.setPointSize(1));f.setSkipTranslation(a.skipTranslation);"bubble"===a.series.type&&f.setBubbleUniforms(a.series,a.zMin,a.zMax);f.setDrawAsCircle(ha[a.series.type]&&m||!1);r.render(a.from,a.to,a.drawMode);a.hasMarkers&&K&&(d.marker&&d.marker.radius?f.setPointSize(2*d.marker.radius):
f.setPointSize(10),f.setDrawAsCircle(!0),r.render(a.from,a.to,"POINTS"))});r.destroy();p.timeRendering&&console.timeEnd("gl rendering");e();a&&a()}function F(a){d();if(a.renderer.forExport)return q(a);t?q(a):setTimeout(function(){F(a)},1)}var f=!1,r=!1,b=!1,n=0,A=0,z=!1,w=!1,m=!1,C={},t=!1,u=[],M=U.createElement("canvas"),Q=M.getContext("2d"),L,O={column:!0,area:!0},ha={scatter:!0,bubble:!0},p={pointSize:1,lineWidth:3,fillColor:"#AA00AA",useAlpha:!0,usePreallocated:!1,useGPUTranslations:!1,timeRendering:!1,
timeSeriesProcessing:!1,timeSetup:!1};return C={allocateBufferForSingleSeries:function(a){var b=0;p.usePreallocated&&(x(a)&&(b=c(a)),r.allocate(b))},pushSeries:function(a){0<u.length&&(u[u.length-1].to=z.length,u[u.length-1].hasMarkers&&(u[u.length-1].markerTo=w.length));p.timeSeriesProcessing&&console.time("building "+a.type+" series");u.push({from:z.length,markerFrom:w.length,colorData:[],series:a,zMin:Number.MAX_VALUE,zMax:-Number.MAX_VALUE,hasMarkers:a.options.marker?!1!==a.options.marker.enabled:
!1,showMarksers:!0,drawMode:{area:"lines",arearange:"lines",areaspline:"line_strip",column:"lines",line:"line_strip",scatter:"points",heatmap:"triangles",treemap:"triangles",bubble:"points"}[a.type]||"line_strip"});k(a,u[u.length-1]);p.timeSeriesProcessing&&console.timeEnd("building "+a.type+" series")},setSize:function(a,b){if(n!==a||b!==b)n=a,A=b,f.bind(),f.setPMatrix([2/n,0,0,0,0,-(2/A),0,0,0,0,-2,0,-1,1,-1,1])},inited:function(){return t},setThreshold:v,init:function(a,c){var d=0,k=["webgl","experimental-webgl",
"moz-webgl","webkit-3d"];t=!1;if(!a)return!1;for(p.timeSetup&&console.time("gl setup");d<k.length&&!(b=a.getContext(k[d]));d++);if(b)c||e();else return!1;b.enable(b.BLEND);b.blendFunc(b.SRC_ALPHA,b.ONE_MINUS_SRC_ALPHA);b.disable(b.DEPTH_TEST);b.depthMask(b.FALSE);f=H(b);r=X(b,f);m=!1;L=b.createTexture();M.width=512;M.height=512;Q.fillStyle="#FFF";Q.beginPath();Q.arc(256,256,256,0,2*Math.PI);Q.fill();try{b.bindTexture(b.TEXTURE_2D,L),b.texImage2D(b.TEXTURE_2D,0,b.RGBA,b.RGBA,b.UNSIGNED_BYTE,M),b.texParameteri(b.TEXTURE_2D,
b.TEXTURE_WRAP_S,b.CLAMP_TO_EDGE),b.texParameteri(b.TEXTURE_2D,b.TEXTURE_WRAP_T,b.CLAMP_TO_EDGE),b.texParameteri(b.TEXTURE_2D,b.TEXTURE_MAG_FILTER,b.LINEAR),b.texParameteri(b.TEXTURE_2D,b.TEXTURE_MIN_FILTER,b.LINEAR_MIPMAP_LINEAR),b.generateMipmap(b.TEXTURE_2D),b.bindTexture(b.TEXTURE_2D,null),m=!0}catch(T){}t=!0;p.timeSetup&&console.timeEnd("gl setup");return!0},render:F,settings:p,valid:function(){return!1!==b},clear:d,flush:e,setXAxis:l,setYAxis:g,data:z,gl:function(){return b},allocateBuffer:function(a){var b=
0;p.usePreallocated&&(y(a.series,function(a){x(a)&&(b+=c(a))}),r.allocate(b))},destroy:function(){r.destroy();f.destroy()},setOptions:function(a){ia(!0,p,a)}}}function ba(a,c){var d=a.chartWidth,k=a.chartHeight,e=a,g=a.seriesGroup||c.group,m=function(a,d,e,f,k,b,h){a.call(c,e,d,f,k,b,h)},e=w(a)?a:c;e.image||(e.canvas=U.createElement("canvas"),e.image=a.renderer.image("",0,0,d,k).add(g),e.boostClipRect=a.renderer.clipRect(a.plotLeft,a.plotTop,a.plotWidth,a.chartHeight),e.image.clip(e.boostClipRect),
e.inverted&&y(["moveTo","lineTo","rect","arc"],function(a){q(!1,a,m)}),e instanceof h.Chart&&(e.markerGroup=e.renderer.g().add(g),e.markerGroup.translateX=c.xAxis.pos,e.markerGroup.translateY=c.yAxis.pos,e.markerGroup.updateTransform()));e.canvas.width=d;e.canvas.height=k;e.image.attr({x:0,y:0,width:d,height:k,style:"pointer-events: none"});e.boostClipRect.attr({x:a.plotLeft,y:a.plotTop,width:a.plotWidth,height:a.chartHeight});e.ogl||(e.ogl=ga(function(){e.image.attr({href:e.canvas.toDataURL("image/png")})}),
e.ogl.init(e.canvas),e.ogl.setOptions(a.options.boost||{}),e instanceof h.Chart&&e.ogl.allocateBuffer(a));e.ogl.setSize(d,k);return e.ogl}function ca(a,c,d){a&&c.image&&c.canvas&&!w(d||c.chart)&&a.render(d||c.chart)}function da(a,c){a&&c.image&&c.canvas&&!w(c.chart)&&a.allocateBufferForSingleSeries(c)}function R(a,c,d,k,e,h){e=e||0;k=k||5E4;for(var g=e+k,l=!0;l&&e<g&&e<a.length;)l=c(a[e],e),++e;l&&(e<a.length?h?R(a,c,d,k,e,h):S.requestAnimationFrame?S.requestAnimationFrame(function(){R(a,c,d,k,e)}):
setTimeout(function(){R(a,c,d,k,e)}):d&&d())}function ja(a){if(!x(this))return a.call(this);if(a=ba(this.chart,this))da(a,this),a.pushSeries(this);ca(a,this)}var S=h.win,U=S.document,ka=function(){},aa=h.Color,m=h.Series,g=h.seriesTypes,y=h.each,ea=h.extend,fa=h.addEvent,la=h.fireEvent,ma=h.grep,P=h.isNumber,ia=h.merge,D=h.pick,q=h.wrap,V=h.getOptions().plotOptions,W;aa.prototype.names={aliceblue:"#f0f8ff",antiquewhite:"#faebd7",aqua:"#00ffff",aquamarine:"#7fffd4",azure:"#f0ffff",beige:"#f5f5dc",
bisque:"#ffe4c4",black:"#000000",blanchedalmond:"#ffebcd",blue:"#0000ff",blueviolet:"#8a2be2",brown:"#a52a2a",burlywood:"#deb887",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",cornflowerblue:"#6495ed",cornsilk:"#fff8dc",crimson:"#dc143c",cyan:"#00ffff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkgray:"#a9a9a9",darkgreen:"#006400",darkkhaki:"#bdb76b",darkmagenta:"#8b008b",darkolivegreen:"#556b2f",darkorange:"#ff8c00",darkorchid:"#9932cc",darkred:"#8b0000",
darksalmon:"#e9967a",darkseagreen:"#8fbc8f",darkslateblue:"#483d8b",darkslategray:"#2f4f4f",darkturquoise:"#00ced1",darkviolet:"#9400d3",deeppink:"#ff1493",deepskyblue:"#00bfff",dimgray:"#696969",dodgerblue:"#1e90ff",feldspar:"#d19275",firebrick:"#b22222",floralwhite:"#fffaf0",forestgreen:"#228b22",fuchsia:"#ff00ff",gainsboro:"#dcdcdc",ghostwhite:"#f8f8ff",gold:"#ffd700",goldenrod:"#daa520",gray:"#808080",green:"#008000",greenyellow:"#adff2f",honeydew:"#f0fff0",hotpink:"#ff69b4",indianred:"#cd5c5c",
indigo:"#4b0082",ivory:"#fffff0",khaki:"#f0e68c",lavender:"#e6e6fa",lavenderblush:"#fff0f5",lawngreen:"#7cfc00",lemonchiffon:"#fffacd",lightblue:"#add8e6",lightcoral:"#f08080",lightcyan:"#e0ffff",lightgoldenrodyellow:"#fafad2",lightgrey:"#d3d3d3",lightgreen:"#90ee90",lightpink:"#ffb6c1",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",lightskyblue:"#87cefa",lightslateblue:"#8470ff",lightslategray:"#778899",lightsteelblue:"#b0c4de",lightyellow:"#ffffe0",lime:"#00ff00",limegreen:"#32cd32",linen:"#faf0e6",
magenta:"#ff00ff",maroon:"#800000",mediumaquamarine:"#66cdaa",mediumblue:"#0000cd",mediumorchid:"#ba55d3",mediumpurple:"#9370d8",mediumseagreen:"#3cb371",mediumslateblue:"#7b68ee",mediumspringgreen:"#00fa9a",mediumturquoise:"#48d1cc",mediumvioletred:"#c71585",midnightblue:"#191970",mintcream:"#f5fffa",mistyrose:"#ffe4e1",moccasin:"#ffe4b5",navajowhite:"#ffdead",navy:"#000080",oldlace:"#fdf5e6",olive:"#808000",olivedrab:"#6b8e23",orange:"#ffa500",orangered:"#ff4500",orchid:"#da70d6",palegoldenrod:"#eee8aa",
palegreen:"#98fb98",paleturquoise:"#afeeee",palevioletred:"#d87093",papayawhip:"#ffefd5",peachpuff:"#ffdab9",peru:"#cd853f",pink:"#ffc0cb",plum:"#dda0dd",powderblue:"#b0e0e6",purple:"#800080",red:"#ff0000",rosybrown:"#bc8f8f",royalblue:"#4169e1",saddlebrown:"#8b4513",salmon:"#fa8072",sandybrown:"#f4a460",seagreen:"#2e8b57",seashell:"#fff5ee",sienna:"#a0522d",silver:"#c0c0c0",skyblue:"#87ceeb",slateblue:"#6a5acd",slategray:"#708090",snow:"#fffafa",springgreen:"#00ff7f",steelblue:"#4682b4",tan:"#d2b48c",
teal:"#008080",thistle:"#d8bfd8",tomato:"#ff6347",turquoise:"#40e0d0",violet:"#ee82ee",violetred:"#d02090",wheat:"#f5deb3",white:"#ffffff",whitesmoke:"#f5f5f5",yellow:"#ffff00",yellowgreen:"#9acd32"};m.prototype.getPoint=function(a){var c=a,d=this.xData||this.options.xData||this.processedXData||!1;!a||a instanceof this.pointClass||(c=(new this.pointClass).init(this,this.options.data[a.i],d?d[a.i]:void 0),c.category=c.x,c.dist=a.dist,c.distX=a.distX,c.plotX=a.plotX,c.plotY=a.plotY,c.index=a.i);return c};
q(m.prototype,"searchPoint",function(a){return this.getPoint(a.apply(this,[].slice.call(arguments,1)))});q(m.prototype,"destroy",function(a){var c=this,d=c.chart;d.markerGroup===c.markerGroup&&(c.markerGroup=null);d.hoverPoints&&(d.hoverPoints=ma(d.hoverPoints,function(a){return a.series===c}));d.hoverPoint&&d.hoverPoint.series===c&&(d.hoverPoint=null);a.call(this)});q(m.prototype,"getExtremes",function(a){if(!x(this)||!this.hasExtremes||!this.hasExtremes())return a.apply(this,Array.prototype.slice.call(arguments,
1))});y("area arearange column line scatter heatmap bubble treemap heatmap".split(" "),function(a){V[a]&&(V[a].boostThreshold=5E3,V[a].boostData=[])});y(["translate","generatePoints","drawTracker","drawPoints","render"],function(a){function c(c){var d=this.options.stacking&&("translate"===a||"generatePoints"===a);if(!x(this)||d||"heatmap"===this.type||"treemap"===this.type)"render"===a&&this.image&&!w(this.chart)&&(this.image.attr({href:""}),this.animate=null),c.call(this);else if(this[a+"Canvas"])this[a+
"Canvas"]()}q(m.prototype,a,c);"translate"===a&&(g.column&&q(g.column.prototype,a,c),g.arearange&&q(g.arearange.prototype,a,c),g.treemap&&q(g.treemap.prototype,a,c))});(function(){var a=0,c,d=["webgl","experimental-webgl","moz-webgl","webkit-3d"],k=!1;if("undefined"!==typeof S.WebGLRenderingContext)for(c=U.createElement("canvas");a<d.length;a++)try{if(k=c.getContext(d[a]),"undefined"!==typeof k&&null!==k)return!0}catch(e){}return!1})()?(q(m.prototype,"processData",function(a){x(this)&&"heatmap"!==
this.type&&"treemap"!==this.type||a.apply(this,Array.prototype.slice.call(arguments,1));this.hasExtremes&&this.hasExtremes(!0)||a.apply(this,Array.prototype.slice.call(arguments,1))}),h.extend(m.prototype,{pointRange:0,directTouch:!1,allowDG:!1,hasExtremes:function(a){var c=this.options,d=this.xAxis&&this.xAxis.options,k=this.yAxis&&this.yAxis.options;return c.data.length>(c.boostThreshold||Number.MAX_VALUE)&&P(k.min)&&P(k.max)&&(!a||P(d.min)&&P(d.max))},destroyGraphics:function(){var a=this,c=this.points,
d,k;if(c)for(k=0;k<c.length;k+=1)(d=c[k])&&d.graphic&&(d.graphic=d.graphic.destroy());y(["graph","area","tracker"],function(c){a[c]&&(a[c]=a[c].destroy())})},renderCanvas:function(){var a=this,c=a.options||{},d=!1,k=a.chart,e=this.xAxis,h=this.yAxis,g=c.xData||a.processedXData,m=c.yData||a.processedYData,q=c.data,d=e.getExtremes(),x=d.min,f=d.max,d=h.getExtremes(),r=d.min,b=d.max,n={},A,z=!!a.sampling,y,H=!1!==c.enableMouseTracking,d=c.threshold,C=h.getThreshold(d);P(d);var t=a.pointArrayMap&&"low,high"===
a.pointArrayMap.join(","),u=!!c.stacking,M=a.cropStart||0,Q=a.requireSorting,L=!g,O,D,p,B,N=function(a,b,c){W=a+","+b;H&&!n[W]&&(n[W]=!0,k.inverted&&(a=e.len-a,b=h.len-b),y.push({clientX:a,plotX:a,plotY:b,i:M+c}))},d=ba(k,a);this.visible?((this.points||this.graph)&&this.destroyGraphics(),w(k)?this.markerGroup=k.markerGroup:this.markerGroup=a.plotGroup("markerGroup","markers",!0,1,k.seriesGroup),y=this.points=[],a.buildKDTree=ka,d&&(da(d,this),d.pushSeries(a),ca(d,this,k)),R(u?a.data:g||q,function(a,
c){var d,g,l,n="undefined"===typeof k.index,q=!0;if(!n&&(L?(d=a[0],g=a[1]):(d=a,g=m[c]),t?(L&&(g=a.slice(1,3)),l=g[0],g=g[1]):u&&(d=a.x,g=a.stackY,l=g-a.y),Q||(q=g>=r&&g<=b),null!==g&&d>=x&&d<=f&&q))if(a=Math.ceil(e.toPixels(d,!0)),z){if(void 0===p||a===A){t||(l=g);if(void 0===B||g>D)D=g,B=c;if(void 0===p||l<O)O=l,p=c}a!==A&&(void 0!==p&&(g=h.toPixels(D,!0),C=h.toPixels(O,!0),N(a,g,B),C!==g&&N(a,C,p)),p=B=void 0,A=a)}else g=Math.ceil(h.toPixels(g,!0)),N(a,g,c);return!n},function(){la(a,"renderedCanvas");
a.directTouch=!1;a.options.stickyTracking=!0;delete a.buildKDTree;a.buildKDTree()},k.renderer.forExport?Number.MAX_VALUE:void 0)):!w(k)&&d&&(d.clear(),this.image.attr({href:""}))}}),y(["heatmap","treemap"],function(a){g[a]&&(q(g[a].prototype,"drawPoints",ja),g[a].prototype.directTouch=!1)}),g.bubble&&(delete g.bubble.prototype.buildKDTree,g.bubble.prototype.directTouch=!1,q(g.bubble.prototype,"markerAttribs",function(a){return x(this)?!1:a.apply(this,[].slice.call(arguments,1))})),g.scatter.prototype.fill=
!0,ea(g.area.prototype,{fill:!0,fillOpacity:!0,sampling:!0}),ea(g.column.prototype,{fill:!0,sampling:!0}),q(m.prototype,"setVisible",function(a,c){a.call(this,c,!1);!1===this.visible&&this.ogl&&this.canvas&&this.image?(this.ogl.clear(),this.image.attr({href:""})):this.chart.redraw()}),h.Chart.prototype.callbacks.push(function(a){fa(a,"predraw",function(){a.canvas&&a.ogl&&w(a)&&a.ogl.allocateBuffer(a)});fa(a,"render",function(){a.ogl&&w(a)&&a.ogl.render(a)})})):"undefined"!==typeof h.initCanvasBoost?
h.initCanvasBoost():h.error(26)})(H)});
