/*! jQuery Timepicker Addon - v1.4.5 - 2014-05-26
* http://trentrichardson.com/examples/timepicker
* Copyright (c) 2014 Trent Richardson; Licensed MIT */

(function($){

/* Afrikaans translation for the jQuery Timepicker Addon */
/* Written by Deon Heyns */
(function($) {
	$.timepicker.regional['af'] = {
		timeOnlyTitle: 'Kies Tyd',
		timeText: 'Tyd ',
		hourText: 'Ure ',
		minuteText: 'Minute',
		secondText: 'Sekondes',
		millisecText: 'Millisekondes',
		microsecText: 'Mikrosekondes',
		timezoneText: 'Tydsone',
		currentText: 'Huidige Tyd',
		closeText: 'Klaar',
		timeFormat: 'HH:mm',
		amNames: ['AM', 'A'],
		pmNames: ['PM', 'P'],
		isRTL: false
	};
	$.timepicker.setDefaults($.timepicker.regional['af']);
})(jQuery);

/* Armenian translation for the jQuery Timepicker Addon */
/* Written by Artavazd Avetisyan artavazda@hotmail.com */
(function($) {
	$.timepicker.regional['am'] = {
		timeOnlyTitle: 'Ընտրեք ժամանակը',
		timeText: 'Ժամանակը',
		hourText: 'Ժամ',
		minuteText: 'Րոպե',
		secondText: 'Վարկյան',
		millisecText: 'Միլիվարկյան',
		microsecText: 'Միկրովարկյան',
		timezoneText: 'Ժամային գոտին',
		currentText: 'Այժմ',
		closeText: 'Փակել',
		timeFormat: 'HH:mm',
		amNames: ['AM', 'A'],
		pmNames: ['PM', 'P'],
		isRTL: false
	};
	$.timepicker.setDefaults($.timepicker.regional['am']);
})(jQuery);

/* Bulgarian translation for the jQuery Timepicker Addon */
/* Written by Plamen Kovandjiev */
(function($) {
	$.timepicker.regional['bg'] = {
		timeOnlyTitle: 'Изберете време',
		timeText: 'Време',
		hourText: 'Час',
		minuteText: 'Минути',
		secondText: 'Секунди',
		millisecText: 'Милисекунди',
		microsecText: 'Микросекунди',
		timezoneText: 'Часови пояс',
		currentText: 'Сега',
		closeText: 'Затвори',
		timeFormat: 'HH:mm',
		amNames: ['AM', 'A'],
		pmNames: ['PM', 'P'],
		isRTL: false
	};
	$.timepicker.setDefaults($.timepicker.regional['bg']);
})(jQuery);
/* Catalan translation for the jQuery Timepicker Addon */
/* Written by Sergi Faber */
(function($) {
	$.timepicker.regional['ca'] = {
		timeOnlyTitle: 'Escollir una hora',
		timeText: 'Hora',
		hourText: 'Hores',
		minuteText: 'Minuts',
		secondText: 'Segons',
		millisecText: 'Milisegons',
		microsecText: 'Microsegons',
		timezoneText: 'Fus horari',
		currentText: 'Ara',
		closeText: 'Tancar',
		timeFormat: 'HH:mm',
		amNames: ['AM', 'A'],
		pmNames: ['PM', 'P'],
		isRTL: false
	};
	$.timepicker.setDefaults($.timepicker.regional['ca']);
})(jQuery);

/* Czech translation for the jQuery Timepicker Addon */
/* Written by Ondřej Vodáček */
(function($) {
	$.timepicker.regional['cs'] = {
		timeOnlyTitle: 'Vyberte čas',
		timeText: 'Čas',
		hourText: 'Hodiny',
		minuteText: 'Minuty',
		secondText: 'Vteřiny',
		millisecText: 'Milisekundy',
		microsecText: 'Mikrosekundy',
		timezoneText: 'Časové pásmo',
		currentText: 'Nyní',
		closeText: 'Zavřít',
		timeFormat: 'HH:mm',
		amNames: ['dop.', 'AM', 'A'],
		pmNames: ['odp.', 'PM', 'P'],
		isRTL: false
	};
	$.timepicker.setDefaults($.timepicker.regional['cs']);
})(jQuery);

/* Danish translation for the jQuery Timepicker Addon */
/* Written by Lars H. Jensen (http://www.larshj.dk) */
(function ($) {
    $.timepicker.regional['da'] = {
        timeOnlyTitle: 'Vælg tid',
        timeText: 'Tid',
        hourText: 'Time',
        minuteText: 'Minut',
        secondText: 'Sekund',
        millisecText: 'Millisekund',
        microsecText: 'Mikrosekund',
        timezoneText: 'Tidszone',
        currentText: 'Nu',
        closeText: 'Luk',
        timeFormat: 'HH:mm',
        amNames: ['am', 'AM', 'A'],
        pmNames: ['pm', 'PM', 'P'],
        isRTL: false
    };
    $.timepicker.setDefaults($.timepicker.regional['da']);
})(jQuery);

/* German translation for the jQuery Timepicker Addon */
/* Written by Marvin */
(function($) {
	$.timepicker.regional['de'] = {
		timeOnlyTitle: 'Zeit wählen',
		timeText: 'Zeit',
		hourText: 'Stunde',
		minuteText: 'Minute',
		secondText: 'Sekunde',
		millisecText: 'Millisekunde',
		microsecText: 'Mikrosekunde',
		timezoneText: 'Zeitzone',
		currentText: 'Jetzt',
		closeText: 'Fertig',
		timeFormat: 'HH:mm',
		amNames: ['vorm.', 'AM', 'A'],
		pmNames: ['nachm.', 'PM', 'P'],
		isRTL: false
	};
	$.timepicker.setDefaults($.timepicker.regional['de']);
})(jQuery);

/* Hellenic translation for the jQuery Timepicker Addon */
/* Written by Christos Pontikis */
(function($) {
	$.timepicker.regional['el'] = {
		timeOnlyTitle: 'Επιλογή ώρας',
		timeText: 'Ώρα',
		hourText: 'Ώρες',
		minuteText: 'Λεπτά',
		secondText: 'Δευτερόλεπτα',
		millisecText: 'μιλιδευτερόλεπτο',
		microsecText: 'Microseconds',
		timezoneText: 'Ζώνη ώρας',
		currentText: 'Τώρα',
		closeText: 'Κλείσιμο',
		timeFormat: 'HH:mm',
		amNames: ['π.μ.', 'AM', 'A'],
		pmNames: ['μ.μ.', 'PM', 'P'],
		isRTL: false
	};
	$.timepicker.setDefaults($.timepicker.regional['el']);
})(jQuery);

/* Spanish translation for the jQuery Timepicker Addon */
/* Written by Ianaré Sévi */
(function($) {
	$.timepicker.regional['es'] = {
		timeOnlyTitle: 'Elegir una hora',
		timeText: 'Hora',
		hourText: 'Horas',
		minuteText: 'Minutos',
		secondText: 'Segundos',
		millisecText: 'Milisegundos',
		microsecText: 'Microsegundos',
		timezoneText: 'Huso horario',
		currentText: 'Ahora',
		closeText: 'Cerrar',
		timeFormat: 'HH:mm',
		amNames: ['a.m.', 'AM', 'A'],
		pmNames: ['p.m.', 'PM', 'P'],
		isRTL: false
	};
	$.timepicker.setDefaults($.timepicker.regional['es']);
})(jQuery);

/* Estonian translation for the jQuery Timepicker Addon */
/* Written by Karl Sutt (karl@sutt.ee) */
(function($) {
	$.timepicker.regional['et'] = {
		timeOnlyTitle: 'Vali aeg',
		timeText: 'Aeg',
		hourText: 'Tund',
		minuteText: 'Minut',
		secondText: 'Sekund',
		millisecText: 'Millisekundis',
		microsecText: 'Mikrosekundis',
		timezoneText: 'Ajavöönd',
		currentText: 'Praegu',
		closeText: 'Valmis',
		timeFormat: 'HH:mm',
		amNames: ['AM', 'A'],
		pmNames: ['PM', 'P'],
		isRTL: false
	};
	$.timepicker.setDefaults($.timepicker.regional['et']);
})(jQuery);

/* Basque trannslation for JQuery Timepicker Addon */
/* Translated by Xabi Fer */
/* Fixed by Asier Iturralde Sarasola - iametza interaktiboa */
(function($) {
	$.timepicker.regional['eu'] = {
		timeOnlyTitle: 'Aukeratu ordua',
		timeText: 'Ordua',
		hourText: 'Orduak',
		minuteText: 'Minutuak',
		secondText: 'Segundoak',
		millisecText: 'Milisegundoak',
		microsecText: 'Mikrosegundoak',
		timezoneText: 'Ordu-eremua',
		currentText: 'Orain',
		closeText: 'Itxi',
		timeFormat: 'HH:mm',
		amNames: ['a.m.', 'AM', 'A'],
		pmNames: ['p.m.', 'PM', 'P'],
		isRTL: false
	};
	$.timepicker.setDefaults($.timepicker.regional['eu']);
})(jQuery);
/* Finnish translation for the jQuery Timepicker Addon */
/* Written by Juga Paazmaya (http://github.com/paazmaya) */
(function($) {
	$.timepicker.regional['fi'] = {
		timeOnlyTitle: 'Valitse aika',
		timeText: 'Aika',
		hourText: 'Tunti',
		minuteText: 'Minuutti',
		secondText: 'Sekunti',
		millisecText: 'Millisekunnin',
		microsecText: 'Mikrosekuntia',
		timezoneText: 'Aikavyöhyke',
		currentText: 'Nyt',
		closeText: 'Sulje',
		timeFormat: 'HH:mm',
		amNames: ['ap.', 'AM', 'A'],
		pmNames: ['ip.', 'PM', 'P'],
		isRTL: false
	};
	$.timepicker.setDefaults($.timepicker.regional['fi']);
})(jQuery);

/* French translation for the jQuery Timepicker Addon */
/* Written by Thomas Lété */
(function($) {
	$.timepicker.regional['fr'] = {
		timeOnlyTitle: 'Choisir une heure',
		timeText: 'Heure',
		hourText: 'Heures',
		minuteText: 'Minutes',
		secondText: 'Secondes',
		millisecText: 'Millisecondes',
		microsecText: 'Microsecondes',
		timezoneText: 'Fuseau horaire',
		currentText: 'Maintenant',
		closeText: 'Terminé',
		timeFormat: 'HH:mm',
		amNames: ['AM', 'A'],
		pmNames: ['PM', 'P'],
		isRTL: false
	};
	$.timepicker.setDefaults($.timepicker.regional['fr']);
})(jQuery);

/* Galician translation for the jQuery Timepicker Addon */
/* Written by David Barral */
(function($) {
	$.timepicker.regional['gl'] = {
		timeOnlyTitle: 'Elixir unha hora',
		timeText: 'Hora',
		hourText: 'Horas',
		minuteText: 'Minutos',
		secondText: 'Segundos',
		millisecText: 'Milisegundos',
		microsecText: 'Microssegundos',
		timezoneText: 'Fuso horario',
		currentText: 'Agora',
		closeText: 'Pechar',
		timeFormat: 'HH:mm',
		amNames: ['a.m.', 'AM', 'A'],
		pmNames: ['p.m.', 'PM', 'P'],
		isRTL: false
	};
	$.timepicker.setDefaults($.timepicker.regional['gl']);
})(jQuery);

/* Hebrew translation for the jQuery Timepicker Addon */
/* Written by Lior Lapid */
(function($) {
	$.timepicker.regional["he"] = {
		timeOnlyTitle: "בחירת זמן",
		timeText: "שעה",
		hourText: "שעות",
		minuteText: "דקות",
		secondText: "שניות",
		millisecText: "אלפית השנייה",
		microsecText: "מיקרו",
		timezoneText: "אזור זמן",
		currentText: "עכשיו",
		closeText:"סגור",
		timeFormat: "HH:mm",
		amNames: ['לפנה"צ', 'AM', 'A'],
		pmNames: ['אחה"צ', 'PM', 'P'],
		isRTL: true
	};
	$.timepicker.setDefaults($.timepicker.regional["he"]);
})(jQuery);

/* Croatian translation for the jQuery Timepicker Addon */
/* Written by Mladen */
(function($) {
	$.timepicker.regional['hr'] = {
		timeOnlyTitle: 'Odaberi vrijeme',
		timeText: 'Vrijeme',
		hourText: 'Sati',
		minuteText: 'Minute',
		secondText: 'Sekunde',
		millisecText: 'Milisekunde',
		microsecText: 'Mikrosekunde',
		timezoneText: 'Vremenska zona',
		currentText: 'Sada',
		closeText: 'Gotovo',
		timeFormat: 'HH:mm',
		amNames: ['a.m.', 'AM', 'A'],
		pmNames: ['p.m.', 'PM', 'P'],
		isRTL: false
	};
	$.timepicker.setDefaults($.timepicker.regional['hr']);
})(jQuery);
/* Hungarian translation for the jQuery Timepicker Addon */
/* Written by Vas Gábor */
(function($) {
	$.timepicker.regional['hu'] = {
		timeOnlyTitle: 'Válasszon időpontot',
		timeText: 'Idő',
		hourText: 'Óra',
		minuteText: 'Perc',
		secondText: 'Másodperc',
		millisecText: 'Milliszekundumos',
		microsecText: 'Ezredmásodperc',
		timezoneText: 'Időzóna',
		currentText: 'Most',
		closeText: 'Kész',
		timeFormat: 'HH:mm',
		amNames: ['de.', 'AM', 'A'],
		pmNames: ['du.', 'PM', 'P'],
		isRTL: false
	};
	$.timepicker.setDefaults($.timepicker.regional['hu']);
})(jQuery);

/* Indonesian translation for the jQuery Timepicker Addon */
/* Written by Nia */
(function($) {
	$.timepicker.regional['id'] = {
		timeOnlyTitle: 'Pilih Waktu',
		timeText: 'Waktu',
		hourText: 'Pukul',
		minuteText: 'Menit',
		secondText: 'Detik',
		millisecText: 'Milidetik',
		microsecText: 'Mikrodetik',
		timezoneText: 'Zona Waktu',
		currentText: 'Sekarang',
		closeText: 'OK',
		timeFormat: 'HH:mm',
		amNames: ['AM', 'A'],
		pmNames: ['PM', 'P'],
		isRTL: false
	};
	$.timepicker.setDefaults($.timepicker.regional['id']);
})(jQuery);

/* Italian translation for the jQuery Timepicker Addon */
/* Written by Marco "logicoder" Del Tongo */
(function($) {
    $.timepicker.regional['it'] = {
        timeOnlyTitle: 'Scegli orario',
        timeText: 'Orario',
        hourText: 'Ora',
        minuteText: 'Minuti',
        secondText: 'Secondi',
        millisecText: 'Millisecondi',
        microsecText: 'Microsecondi',
        timezoneText: 'Fuso orario',
        currentText: 'Adesso',
        closeText: 'Chiudi',
        timeFormat: 'HH:mm',
        amNames: ['m.', 'AM', 'A'],
        pmNames: ['p.', 'PM', 'P'],
        isRTL: false
    };
    $.timepicker.setDefaults($.timepicker.regional['it']);
})(jQuery);

/* Japanese translation for the jQuery Timepicker Addon */
/* Written by Jun Omae */
(function($) {
	$.timepicker.regional['ja'] = {
		timeOnlyTitle: '時間を選択',
		timeText: '時間',
		hourText: '時',
		minuteText: '分',
		secondText: '秒',
		millisecText: 'ミリ秒',
		microsecText: 'マイクロ秒',
		timezoneText: 'タイムゾーン',
		currentText: '現時刻',
		closeText: '閉じる',
		timeFormat: 'HH:mm',
		amNames: ['午前', 'AM', 'A'],
		pmNames: ['午後', 'PM', 'P'],
		isRTL: false
	};
	$.timepicker.setDefaults($.timepicker.regional['ja']);
})(jQuery);

/* Korean translation for the jQuery Timepicker Addon */
/* Written by Genie */
(function($) {
	$.timepicker.regional['ko'] = {
		timeOnlyTitle: '시간 선택',
		timeText: '시간',
		hourText: '시',
		minuteText: '분',
		secondText: '초',
		millisecText: '밀리초',
		microsecText: '마이크로',
		timezoneText: '표준 시간대',
		currentText: '현재 시각',
		closeText: '닫기',
		timeFormat: 'tt h:mm',
		amNames: ['오전', 'AM', 'A'],
		pmNames: ['오후', 'PM', 'P'],
		isRTL: false
	};
	$.timepicker.setDefaults($.timepicker.regional['ko']);
})(jQuery);

/* Lithuanian translation for the jQuery Timepicker Addon */
/* Written by Irmantas Šiupšinskas */
(function($) {
	$.timepicker.regional['lt'] = {
		timeOnlyTitle: 'Pasirinkite laiką',
		timeText: 'Laikas',
		hourText: 'Valandos',
		minuteText: 'Minutės',
		secondText: 'Sekundės',
		millisecText: 'Milisekundės',
		microsecText: 'Mikrosekundės',
		timezoneText: 'Laiko zona',
		currentText: 'Dabar',
		closeText: 'Uždaryti',
		timeFormat: 'HH:mm',
		amNames: ['priešpiet', 'AM', 'A'],
		pmNames: ['popiet', 'PM', 'P'],
		isRTL: false
	};
	$.timepicker.setDefaults($.timepicker.regional['lt']);
})(jQuery);

/* Dutch translation for the jQuery Timepicker Addon */
/* Written by Martijn van der Lee */
(function($) {
	$.timepicker.regional['nl'] = {
		timeOnlyTitle: 'Tijdstip',
		timeText: 'Tijd',
		hourText: 'Uur',
		minuteText: 'Minuut',
		secondText: 'Seconde',
		millisecText: 'Milliseconde',
		microsecText: 'Microseconde',
		timezoneText: 'Tijdzone',
		currentText: 'Vandaag',
		closeText: 'Sluiten',
		timeFormat: 'HH:mm',
		amNames: ['AM', 'A'],
		pmNames: ['PM', 'P'],
		isRTL: false
	};
	$.timepicker.setDefaults($.timepicker.regional['nl']);
})(jQuery);

/* Norwegian translation for the jQuery Timepicker Addon */
/* Written by Morten Hauan (http://hauan.me) */
(function($) {
	$.timepicker.regional['no'] = {
		timeOnlyTitle: 'Velg tid',
		timeText: 'Tid',
		hourText: 'Time',
		minuteText: 'Minutt',
		secondText: 'Sekund',
		millisecText: 'Millisekund',
		microsecText: 'mikrosekund',
		timezoneText: 'Tidssone',
		currentText: 'Nå',
		closeText: 'Lukk',
		timeFormat: 'HH:mm',
		amNames: ['am', 'AM', 'A'],
		pmNames: ['pm', 'PM', 'P'],
		isRTL: false
	};
	$.timepicker.setDefaults($.timepicker.regional['no']);
})(jQuery);

/* Polish translation for the jQuery Timepicker Addon */
/* Written by Michał Pena */
(function($) {
	$.timepicker.regional['pl'] = {
		timeOnlyTitle: 'Wybierz godzinę',
		timeText: 'Czas',
		hourText: 'Godzina',
		minuteText: 'Minuta',
		secondText: 'Sekunda',
		millisecText: 'Milisekunda',
		microsecText: 'Mikrosekunda',
		timezoneText: 'Strefa czasowa',
		currentText: 'Teraz',
		closeText: 'Gotowe',
		timeFormat: 'HH:mm',
		amNames: ['AM', 'A'],
		pmNames: ['PM', 'P'],
		isRTL: false
	};
	$.timepicker.setDefaults($.timepicker.regional['pl']);
})(jQuery);

/* Brazilian Portuguese translation for the jQuery Timepicker Addon */
/* Written by Diogo Damiani (diogodamiani@gmail.com) */
(function ($) {
	$.timepicker.regional['pt-BR'] = {
		timeOnlyTitle: 'Escolha o horário',
		timeText: 'Horário',
		hourText: 'Hora',
		minuteText: 'Minutos',
		secondText: 'Segundos',
		millisecText: 'Milissegundos',
		microsecText: 'Microssegundos',
		timezoneText: 'Fuso horário',
		currentText: 'Agora',
		closeText: 'Fechar',
		timeFormat: 'HH:mm',
		amNames: ['a.m.', 'AM', 'A'],
		pmNames: ['p.m.', 'PM', 'P'],
		isRTL: false
	};
	$.timepicker.setDefaults($.timepicker.regional['pt-BR']);
})(jQuery);

/* Portuguese translation for the jQuery Timepicker Addon */
/* Written by Luan Almeida */
(function($) {
	$.timepicker.regional['pt'] = {
		timeOnlyTitle: 'Escolha uma hora',
		timeText: 'Hora',
		hourText: 'Horas',
		minuteText: 'Minutos',
		secondText: 'Segundos',
		millisecText: 'Milissegundos',
		microsecText: 'Microssegundos',
		timezoneText: 'Fuso horário',
		currentText: 'Agora',
		closeText: 'Fechar',
		timeFormat: 'HH:mm',
		amNames: ['a.m.', 'AM', 'A'],
		pmNames: ['p.m.', 'PM', 'P'],
		isRTL: false
	};
	$.timepicker.setDefaults($.timepicker.regional['pt']);
})(jQuery);

/* Romanian translation for the jQuery Timepicker Addon */
/* Written by Romeo Adrian Cioaba */
(function($) {
	$.timepicker.regional['ro'] = {
		timeOnlyTitle: 'Alegeţi o oră',
		timeText: 'Timp',
		hourText: 'Ore',
		minuteText: 'Minute',
		secondText: 'Secunde',
		millisecText: 'Milisecunde',
		microsecText: 'Microsecunde',
		timezoneText: 'Fus orar',
		currentText: 'Acum',
		closeText: 'Închide',
		timeFormat: 'HH:mm',
		amNames: ['AM', 'A'],
		pmNames: ['PM', 'P'],
		isRTL: false
	};
	$.timepicker.setDefaults($.timepicker.regional['ro']);
})(jQuery);

/* Russian translation for the jQuery Timepicker Addon */
/* Written by Trent Richardson */
(function($) {
	$.timepicker.regional['ru'] = {
		timeOnlyTitle: 'Выберите время',
		timeText: 'Время',
		hourText: 'Часы',
		minuteText: 'Минуты',
		secondText: 'Секунды',
		millisecText: 'Миллисекунды',
		microsecText: 'Микросекунды',
		timezoneText: 'Часовой пояс',
		currentText: 'Сейчас',
		closeText: 'Закрыть',
		timeFormat: 'HH:mm',
		amNames: ['AM', 'A'],
		pmNames: ['PM', 'P'],
		isRTL: false
	};
	$.timepicker.setDefaults($.timepicker.regional['ru']);
})(jQuery);

/* Slovak translation for the jQuery Timepicker Addon */
/* Written by David Vallner */
(function($) {
	$.timepicker.regional['sk'] = {
		timeOnlyTitle: 'Zvoľte čas',
		timeText: 'Čas',
		hourText: 'Hodiny',
		minuteText: 'Minúty',
		secondText: 'Sekundy',
		millisecText: 'Milisekundy',
		microsecText: 'Mikrosekundy',
		timezoneText: 'Časové pásmo',
		currentText: 'Teraz',
		closeText: 'Zavrieť',
		timeFormat: 'H:m',
		amNames: ['dop.', 'AM', 'A'],
		pmNames: ['pop.', 'PM', 'P'],
		isRTL: false
	};
	$.timepicker.setDefaults($.timepicker.regional['sk']);
})(jQuery);

/* Serbian cyrilic translation for the jQuery Timepicker Addon */
/* Written by Vladimir Jelovac */
(function($) {
	$.timepicker.regional['sr-RS'] = {
		timeOnlyTitle: 'Одаберите време',
		timeText: 'Време',
		hourText: 'Сати',
		minuteText: 'Минути',
		secondText: 'Секунде',
		millisecText: 'Милисекунде',
		microsecText: 'Микросекунде',
		timezoneText: 'Временска зона',
		currentText: 'Сада',
		closeText: 'Затвори',
		timeFormat: 'HH:mm',
		amNames: ['AM', 'A'],
		pmNames: ['PM', 'P'],
		isRTL: false
	};
	$.timepicker.setDefaults($.timepicker.regional['sr-RS']);
})(jQuery);

/* Serbian latin translation for the jQuery Timepicker Addon */
/* Written by Vladimir Jelovac */
(function($) {
	$.timepicker.regional['sr-YU'] = {
		timeOnlyTitle: 'Odaberite vreme',
		timeText: 'Vreme',
		hourText: 'Sati',
		minuteText: 'Minuti',
		secondText: 'Sekunde',
		millisecText: 'Milisekunde',
		microsecText: 'Mikrosekunde',
		timezoneText: 'Vremenska zona',
		currentText: 'Sada',
		closeText: 'Zatvori',
		timeFormat: 'HH:mm',
		amNames: ['AM', 'A'],
		pmNames: ['PM', 'P'],
		isRTL: false
	};
	$.timepicker.setDefaults($.timepicker.regional['sr-YU']);
})(jQuery);

/* Swedish translation for the jQuery Timepicker Addon */
/* Written by Nevon */
(function($) {
	$.timepicker.regional['sv'] = {
		timeOnlyTitle: 'Välj en tid',
		timeText: 'Tid',
		hourText: 'Timme',
		minuteText: 'Minut',
		secondText: 'Sekund',
		millisecText: 'Millisekund',
		microsecText: 'Mikrosekund',
		timezoneText: 'Tidszon',
		currentText: 'Nu',
		closeText: 'Stäng',
		timeFormat: 'HH:mm',
		amNames: ['AM', 'A'],
		pmNames: ['PM', 'P'],
		isRTL: false
	};
	$.timepicker.setDefaults($.timepicker.regional['sv']);
})(jQuery);

/* Thai translation for the jQuery Timepicker Addon */
/* Written by Yote Wachirapornpongsa */
(function($) {
	$.timepicker.regional['th'] = {
		timeOnlyTitle: 'เลือกเวลา',
		timeText: 'เวลา ',
		hourText: 'ชั่วโมง ',
		minuteText: 'นาที',
		secondText: 'วินาที',
		millisecText: 'มิลลิวินาที',
		microsecText: 'ไมโคริวินาที',
		timezoneText: 'เขตเวลา',
		currentText: 'เวลาปัจจุบัน',
		closeText: 'ปิด',
		timeFormat: 'hh:mm tt'
	};
	$.timepicker.setDefaults($.timepicker.regional['th']);
})(jQuery);
/* Turkish translation for the jQuery Timepicker Addon */
/* Written by Fehmi Can Saglam, Edited by Goktug Ozturk */
(function($) {
	$.timepicker.regional['tr'] = {
		timeOnlyTitle: 'Zaman Seçiniz',
		timeText: 'Zaman',
		hourText: 'Saat',
		minuteText: 'Dakika',
		secondText: 'Saniye',
		millisecText: 'Milisaniye',
		microsecText: 'Mikrosaniye',
		timezoneText: 'Zaman Dilimi',
		currentText: 'Şu an',
		closeText: 'Tamam',
		timeFormat: 'HH:mm',
		amNames: ['ÖÖ', 'Ö'],
		pmNames: ['ÖS', 'S'],
		isRTL: false
	};
	$.timepicker.setDefaults($.timepicker.regional['tr']);
})(jQuery);

/* Ukrainian translation for the jQuery Timepicker Addon */
/* Written by Sergey Noskov */
(function($) {
	$.timepicker.regional['uk'] = {
		timeOnlyTitle: 'Виберіть час',
		timeText: 'Час',
		hourText: 'Години',
		minuteText: 'Хвилини',
		secondText: 'Секунди',
		millisecText: 'Мілісекунди',
		microsecText: 'Мікросекунди',
		timezoneText: 'Часовий пояс',
		currentText: 'Зараз',
		closeText: 'Закрити',
		timeFormat: 'HH:mm',
		amNames: ['AM', 'A'],
		pmNames: ['PM', 'P'],
		isRTL: false
	};
	$.timepicker.setDefaults($.timepicker.regional['uk']);
})(jQuery);

/* Vietnamese translation for the jQuery Timepicker Addon */
/* Written by Nguyen Dinh Trung */
(function($) {
	$.timepicker.regional['vi'] = {
		timeOnlyTitle: 'Chọn giờ',
		timeText: 'Thời gian',
		hourText: 'Giờ',
		minuteText: 'Phút',
		secondText: 'Giây',
		millisecText: 'Mili giây',
		microsecText: 'Micrô giây',
		timezoneText: 'Múi giờ',
		currentText: 'Hiện thời',
		closeText: 'Đóng',
		timeFormat: 'HH:mm',
		amNames: ['SA', 'S'],
		pmNames: ['CH', 'C'],
		isRTL: false
	};
	$.timepicker.setDefaults($.timepicker.regional['vi']);
})(jQuery);

/* Simplified Chinese translation for the jQuery Timepicker Addon /
/ Written by Will Lu */
(function($) {
	$.timepicker.regional['zh-CN'] = {
		timeOnlyTitle: '选择时间',
		timeText: '时间',
		hourText: '小时',
		minuteText: '分钟',
		secondText: '秒钟',
		millisecText: '毫秒',
		microsecText: '微秒',
		timezoneText: '时区',
		currentText: '现在时间',
		closeText: '关闭',
		timeFormat: 'HH:mm',
		amNames: ['AM', 'A'],
		pmNames: ['PM', 'P'],
		isRTL: false
	};
	$.timepicker.setDefaults($.timepicker.regional['zh-CN']);
})(jQuery);

/* Chinese translation for the jQuery Timepicker Addon */
/* Written by Alang.lin */
(function($) {
	$.timepicker.regional['zh-TW'] = {
		timeOnlyTitle: '選擇時分秒',
		timeText: '時間',
		hourText: '時',
		minuteText: '分',
		secondText: '秒',
		millisecText: '毫秒',
		microsecText: '微秒',
		timezoneText: '時區',
		currentText: '現在時間',
		closeText: '確定',
		timeFormat: 'HH:mm',
		amNames: ['上午', 'AM', 'A'],
		pmNames: ['下午', 'PM', 'P'],
		isRTL: false
	};
	$.timepicker.setDefaults($.timepicker.regional['zh-TW']);
})(jQuery);

})(jQuery);
