﻿/* http://keith-wood.name/svg.html
   SVG plotting extension for jQuery v1.5.0.
   Written by Keith Wood (kbwood{at}iinet.com.au) December 2008.
   Available under the MIT (http://keith-wood.name/licence.html) license. 
   Please attribute the author if you use it. */
(function($){$.svg.addExtension('plot',SVGPlot);function SVGPlot(a){this._wrapper=a;this._drawNow=false;this._title={value:'',offset:25,settings:{textAnchor:'middle'}};this._area=[0.1,0.1,0.8,0.9];this._areaFormat={fill:'none',stroke:'black'};this._gridlines=[];this._equalXY=true;this._functions=[];this._onstatus=null;this._uuid=new Date().getTime();this._plotCont=this._wrapper.svg(0,0,0,0,{class_:'svg-plot'});this.xAxis=new SVGPlotAxis(this);this.xAxis.title('X',20);this.yAxis=new SVGPlotAxis(this);this.yAxis.title('Y',20);this.legend=new SVGPlotLegend(this);this._drawNow=true}$.extend(SVGPlot.prototype,{X:0,Y:1,W:2,H:3,L:0,T:1,R:2,B:3,container:function(a){if(arguments.length===0){return this._plotCont}this._plotCont=a;return this},area:function(a,b,c,d){if(arguments.length===0){return this._area}this._area=($.isArray(a)?a:[a,b,c,d]);this._drawPlot();return this},format:function(a,b,c){if(arguments.length===0){return this._areaFormat}if(typeof b==='object'){c=b;b=null}this._areaFormat=$.extend({fill:a},(b?{stroke:b}:{}),c||{});this._drawPlot();return this},gridlines:function(a,b){if(arguments.length===0){return this._gridlines}this._gridlines=[(typeof a==='string'?{stroke:a}:a),(typeof b==='string'?{stroke:b}:b)];if(this._gridlines[0]==null&&this._gridlines[1]==null){this._gridlines=[]}this._drawPlot();return this},equalXY:function(a){if(arguments.length===0){return this._equalXY}this._equalXY=a;return this},title:function(a,b,c,d){if(arguments.length===0){return this._title}if(typeof b!=='number'){d=c;c=b;b=null}if(typeof c!=='string'){d=c;c=null}this._title={value:a,offset:b||this._title.offset,settings:$.extend({textAnchor:'middle'},(c?{fill:c}:{}),d||{})};this._drawPlot();return this},addFunction:function(a,b,c,d,e,f,g){this._functions.push(new SVGPlotFunction(this,a,b,c,d,e,f,g));this._drawPlot();return this},functions:function(i){return(arguments.length>0?this._functions[i]:null)||this._functions},noDraw:function(){this._drawNow=false;return this},redraw:function(){this._drawNow=true;this._drawPlot();return this},status:function(a){this._onstatus=a;return this},_drawPlot:function(){if(!this._drawNow){return}while(this._plotCont.firstChild){this._plotCont.removeChild(this._plotCont.firstChild)}if(!this._plotCont.parent){this._wrapper._svg.appendChild(this._plotCont)}if(!this._plotCont.width){this._plotCont.setAttribute('width',parseInt(this._plotCont.getAttribute('width'),10)||this._wrapper.width())}else if(this._plotCont.width.baseVal){this._plotCont.width.baseVal.value=this._plotCont.width.baseVal.value||this._wrapper.width()}else{this._plotCont.width=this._plotCont.width||this._wrapper.width()}if(!this._plotCont.height){this._plotCont.setAttribute('height',parseInt(this._plotCont.getAttribute('height'),10)||this._wrapper.height())}else if(this._plotCont.height.baseVal){this._plotCont.height.baseVal.value=this._plotCont.height.baseVal.value||this._wrapper.height()}else{this._plotCont.height=this._plotCont.height||this._wrapper.height()}this._drawChartBackground();var a=this._getDims();var b=this._wrapper.other(this._plotCont,'clipPath',{id:'clip'+this._uuid});this._wrapper.rect(b,a[this.X],a[this.Y],a[this.W],a[this.H]);this._plot=this._wrapper.group(this._plotCont,{class_:'foreground',clipPath:'url(#clip'+this._uuid+')'});this._drawAxis(true);this._drawAxis(false);for(var i=0;i<this._functions.length;i++){this._plotFunction(this._functions[i],i)}this._drawTitle();this._drawLegend()},_getValue:function(a,b){return(!a[b]?parseInt(a.getAttribute(b),10):(a[b].baseVal?a[b].baseVal.value:a[b]))},_getDims:function(a){var b=(a!=null);a=a||this._area;var c=this._getValue(this._plotCont,'width');var d=this._getValue(this._plotCont,'height');var e=(a[this.L]>1?a[this.L]:c*a[this.L]);var f=(a[this.T]>1?a[this.T]:d*a[this.T]);var g=(a[this.R]>1?a[this.R]:c*a[this.R])-e;var h=(a[this.B]>1?a[this.B]:d*a[this.B])-f;if(this._equalXY&&!b){var i=Math.min(g/(this.xAxis._scale.max-this.xAxis._scale.min),h/(this.yAxis._scale.max-this.yAxis._scale.min));g=i*(this.xAxis._scale.max-this.xAxis._scale.min);h=i*(this.yAxis._scale.max-this.yAxis._scale.min)}return[e,f,g,h]},_getScales:function(){var a=this._getDims();return[a[this.W]/(this.xAxis._scale.max-this.xAxis._scale.min),a[this.H]/(this.yAxis._scale.max-this.yAxis._scale.min)]},_drawChartBackground:function(a,b){var c=this._wrapper.group(this._plotCont,{class_:'background'});var d=this._getDims();this._wrapper.rect(c,d[this.X],d[this.Y],d[this.W],d[this.H],this._areaFormat);if(this._gridlines[0]&&this.yAxis._ticks.major&&!b){this._drawGridlines(c,true,this._gridlines[0],d)}if(this._gridlines[1]&&this.xAxis._ticks.major&&!a){this._drawGridlines(c,false,this._gridlines[1],d)}return c},_drawGridlines:function(a,b,c,d){var g=this._wrapper.group(a,c);var e=(b?this.yAxis:this.xAxis);var f=this._getScales();var h=Math.floor(e._scale.min/e._ticks.major)*e._ticks.major;h+=(h<=e._scale.min?e._ticks.major:0);while(h<e._scale.max){var v=(b?e._scale.max-h:h-e._scale.min)*f[b?1:0]+(b?d[this.Y]:d[this.X]);this._wrapper.line(g,(b?d[this.X]:v),(b?v:d[this.Y]),(b?d[this.X]+d[this.W]:v),(b?v:d[this.Y]+d[this.H]));h+=e._ticks.major}},_drawAxis:function(a){var b=(a?'x':'y')+'Axis';var c=(a?this.xAxis:this.yAxis);var d=(a?this.yAxis:this.xAxis);var e=this._getDims();var f=this._getScales();var g=this._wrapper.group(this._plot,$.extend({class_:b},c._lineFormat));var h=this._wrapper.group(this._plot,$.extend({class_:b+'Labels',textAnchor:(a?'middle':'end')},c._labelFormat));var i=(a?d._scale.max:-d._scale.min)*f[a?1:0]+(a?e[this.Y]:e[this.X]);this._wrapper.line(g,(a?e[this.X]:i),(a?i:e[this.Y]),(a?e[this.X]+e[this.W]:i),(a?i:e[this.Y]+e[this.H]));if(c._ticks.major){var j=c._ticks.size;var k=Math.floor(c._scale.min/c._ticks.major)*c._ticks.major;k=(k<c._scale.min?k+c._ticks.major:k);var l=(!c._ticks.minor?c._scale.max+1:Math.floor(c._scale.min/c._ticks.minor)*c._ticks.minor);l=(l<c._scale.min?l+c._ticks.minor:l);var m=[(c._ticks.position==='nw'||c._ticks.position==='both'?-1:0),(c._ticks.position==='se'||c._ticks.position==='both'?+1:0)];while(k<=c._scale.max||l<=c._scale.max){var n=Math.min(k,l);var o=(n===k?j:j/2);var p=(a?n-c._scale.min:c._scale.max-n)*f[a?0:1]+(a?e[this.X]:e[this.Y]);this._wrapper.line(g,(a?p:i+o*m[0]),(a?i+o*m[0]:p),(a?p:i+o*m[1]),(a?i+o*m[1]:p));if(n===k&&n!==0){this._wrapper.text(h,(a?p:i-j),(a?i-j:p),''+n)}k+=(n===k?c._ticks.major:0);l+=(n===l?c._ticks.minor:0)}}if(c._title){if(a){this._wrapper.text(this._plotCont,e[this.X]-c._titleOffset,i,c._title,$.extend({textAnchor:'end'},c._titleFormat||{}))}else{this._wrapper.text(this._plotCont,i,e[this.Y]+e[this.H]+c._titleOffset,c._title,$.extend({textAnchor:'middle'},c._titleFormat||{}))}}},_plotFunction:function(a,b){var c=this._getDims();var d=this._getScales();var e=this._wrapper.createPath();var f=a._range||[this.xAxis._scale.min,this.xAxis._scale.max];var g=(f[1]-f[0])/a._points;var h=true;for(var i=0;i<=a._points;i++){var x=f[0]+i*g;if(x>this.xAxis._scale.max+g){break}if(x<this.xAxis._scale.min-g){continue}var j=(x-this.xAxis._scale.min)*d[0]+c[this.X];var k=c[this.H]-((a._fn(x)-this.yAxis._scale.min)*d[1])+c[this.Y];e[(h?'move':'line')+'To'](j,k);h=false}var p=this._wrapper.path(this._plot,e,$.extend({class_:'fn'+b,fill:'none',stroke:a._stroke,strokeWidth:a._strokeWidth},a._settings||{}));this._showStatus(p,a._name)},_drawTitle:function(){this._wrapper.text(this._plotCont,this._getValue(this._plotCont,'width')/2,this._title.offset,this._title.value,this._title.settings)},_drawLegend:function(){if(!this.legend._show){return}var g=this._wrapper.group(this._plotCont,{class_:'legend'});var a=this._getDims(this.legend._area);this._wrapper.rect(g,a[this.X],a[this.Y],a[this.W],a[this.H],this.legend._bgSettings);var b=a[this.W]>a[this.H];var c=this._functions.length;var d=(b?a[this.W]:a[this.H])/c;var e=a[this.X]+5;var f=a[this.Y]+((b?a[this.H]:d)+this.legend._sampleSize)/2;for(var i=0;i<c;i++){var h=this._functions[i];this._wrapper.rect(g,e+(b?i*d:0),f+(b?0:i*d)-this.legend._sampleSize,this.legend._sampleSize,this.legend._sampleSize,{fill:h._stroke});this._wrapper.text(g,e+(b?i*d:0)+this.legend._sampleSize+5,f+(b?0:i*d),h._name,this.legend._textSettings)}},_showStatus:function(b,c){var d=this._onstatus;if(this._onstatus){$(b).hover(function(a){d.apply(this,[c])},function(){d.apply(this,[''])})}}});function SVGPlotFunction(a,b,c,d,e,f,g,h){if(typeof b!=='string'){h=g;g=f;f=e;e=d;d=c;c=b;b=null}if(!$.isArray(d)){h=g;g=f;f=e;e=d;d=null}if(typeof e!=='number'){h=g;g=f;f=e;e=null}if(typeof f!=='string'){h=g;g=f;f=null}if(typeof g!=='number'){h=g;g=null}this._plot=a;this._name=b||'';this._fn=c||identity;this._range=d;this._points=e||100;this._stroke=f||'black';this._strokeWidth=g||1;this._settings=h||{}}$.extend(SVGPlotFunction.prototype,{name:function(a){if(arguments.length===0){return this._name}this._name=a;this._plot._drawPlot();return this},fn:function(a,b){if(arguments.length===0){return this._fn}if(typeof a==='function'){b=a;a=null}this._name=a||this._name;this._fn=b;this._plot._drawPlot();return this},range:function(a,b){if(arguments.length===0){return this._range}this._range=(a==null?null:[a,b]);this._plot._drawPlot();return this},points:function(a){if(arguments.length===0){return this._points}this._points=a;this._plot._drawPlot();return this},format:function(a,b,c){if(arguments.length===0){return $.extend({stroke:this._stroke,strokeWidth:this._strokeWidth},this._settings)}if(typeof b!=='number'){c=b;b=null}this._stroke=a||this._stroke;this._strokeWidth=b||this._strokeWidth;$.extend(this._settings,c||{});this._plot._drawPlot();return this},end:function(){return this._plot}});function identity(x){return x}function SVGPlotAxis(a,b,c,d,e,f){this._plot=a;this._title=b||'';this._titleFormat={};this._titleOffset=0;this._labelFormat={};this._lineFormat={stroke:'black',strokeWidth:1};this._ticks={major:e||10,minor:f||0,size:10,position:'both'};this._scale={min:c||0,max:d||100};this._crossAt=0}$.extend(SVGPlotAxis.prototype,{scale:function(a,b){if(arguments.length===0){return this._scale}this._scale.min=a;this._scale.max=b;this._plot._drawPlot();return this},ticks:function(a,b,c,d){if(arguments.length===0){return this._ticks}if(typeof c==='string'){d=c;c=null}this._ticks.major=a;this._ticks.minor=b;this._ticks.size=c||this._ticks.size;this._ticks.position=d||this._ticks.position;this._plot._drawPlot();return this},title:function(a,b,c,d){if(arguments.length===0){return{title:this._title,offset:this._titleOffset,format:this._titleFormat}}if(typeof b!=='number'){d=c;c=b;b=null}if(typeof c!=='string'){d=c;c=null}this._title=a;this._titleOffset=(b!=null?b:this._titleOffset);if(c||d){this._titleFormat=$.extend(d||{},(c?{fill:c}:{}))}this._plot._drawPlot();return this},format:function(a,b){if(arguments.length===0){return this._labelFormat}if(typeof a!=='string'){b=a;a=null}this._labelFormat=$.extend(b||{},(a?{fill:a}:{}));this._plot._drawPlot();return this},line:function(a,b,c){if(arguments.length===0){return this._lineFormat}if(typeof b!=='number'){c=b;b=null}$.extend(this._lineFormat,{stroke:a,strokeWidth:b||this._lineFormat.strokeWidth},c||{});this._plot._drawPlot();return this},end:function(){return this._plot}});function SVGPlotLegend(a,b,c){this._plot=a;this._show=true;this._area=[0.9,0.1,1.0,0.9];this._sampleSize=15;this._bgSettings=b||{stroke:'gray'};this._textSettings=c||{}}$.extend(SVGPlotLegend.prototype,{show:function(a){if(arguments.length===0){return this._show}this._show=a;this._plot._drawPlot();return this},area:function(a,b,c,d){if(arguments.length===0){return this._area}this._area=($.isArray(a)?a:[a,b,c,d]);this._plot._drawPlot();return this},settings:function(a,b,c){if(arguments.length===0){return{sampleSize:this._sampleSize,bgSettings:this._bgSettings,textSettings:this._textSettings}}if(typeof a==='object'){c=b;b=a;a=null}this._sampleSize=a||this._sampleSize;this._bgSettings=b;this._textSettings=c||this._textSettings;this._plot._drawPlot();return this},end:function(){return this._plot}})})(jQuery)