
/* Release Date: June-03-2025 
Copyright (c) 2011-2025 jQWidgets. 
License: https://jqwidgets.com/license/ */


/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 675:
/***/ (() => {

/* tslint:disable */
/* eslint-disable */
(function(){
	if (typeof document === 'undefined') { 
		return;
	}

(function ($) {
    $.extend($.jqx._jqxChart.prototype,
        {
            _moduleAnnotations: true,

            _renderAnnotation: function (groupIndex, annotation, rect) {
                var group = this.seriesGroups[groupIndex];

                var renderer = this.renderer;

                if (isNaN(groupIndex))
                    return;

                var x = this._get([this.getXAxisDataPointOffset(annotation.xValue, groupIndex), annotation.x]);
                var y = this._get([this.getValueAxisDataPointOffset(annotation.yValue, groupIndex), annotation.y]);
                var x2 = this._get([this.getXAxisDataPointOffset(annotation.xValue2, groupIndex), annotation.x2]);
                var y2 = this._get([this.getValueAxisDataPointOffset(annotation.yValue2, groupIndex), annotation.y2]);

                if (group.polar || group.spider) {
                    var point = this.getPolarDataPointOffset(annotation.xValue, annotation.yValue, groupIndex);
                    if (point && !isNaN(point.x) && !isNaN(point.y)) {
                        x = point.x;
                        y = point.y;
                    }
                    else {
                        x = annotation.x;
                        y = annotation.y;
                    }
                }

                if (isNaN(y) || isNaN(x))
                    return false;

                if (group.orientation == 'horizontal') {
                    var tmp = x;
                    x = y;
                    y = tmp;

                    tmp = x2;
                    x2 = y2;
                    y2 = tmp;
                }

                if (annotation.offset) {
                    if (!isNaN(annotation.offset.x)) {
                        x += annotation.offset.x;
                        x2 += annotation.offset.x;
                    }

                    if (!isNaN(annotation.offset.y)) {
                        y += annotation.offset.y;
                        y2 += annotation.offset.y;
                    }
                }

                var width = this._get([annotation.width, x2 - x]);
                var height = this._get([annotation.height, y2 - y]);

                if (isNaN(width)) {
                    width = 90;
                    height = 20;
                }

                var shape;
                switch (annotation.type) {
                    case 'rect':
                        shape = renderer.rect(x, y, width, height);
                        break;
                    case 'circle':
                        shape = renderer.rect(x, y, annotation.radius);
                        break;
                    case 'line':
                        shape = renderer.rect(x, y, x2, y2);
                        break;
                    case 'path':
                        shape = renderer.path(annotation.path);
                        break;
                }

                renderer.attr(shape,
                    {
                        fill: annotation.fillColor,
                        stroke: annotation.lineColor,
                        opacity: this._get([annotation.fillOpacity, annotation.opacity]),
                        'stroke-opacity': this._get([annotation.lineOpacity, annotation.opacity]),
                        'stroke-width': annotation.lineWidth,
                        'stroke-dasharray': annotation.dashStyle || 'none',
                    });

                var txtElement;
                if (annotation.text) {
                    var txt = annotation.text;

                    var xOffset = 0,
                        yOffset = 0;

                    if (txt.offset) {
                        if (!isNaN(txt.offset.x))
                            xOffset += txt.offset.x;

                        if (!isNaN(txt.offset.y))
                            yOffset += txt.offset.y;
                    }

                    txtElement = renderer.text(
                        txt.value,
                        x + xOffset,
                        y + yOffset,
                        NaN,
                        NaN,
                        txt.angle,
                        {},
                        txt.clip === true,
                        txt.horizontalAlignment || 'center',
                        txt.verticalAlignment || 'center',
                        txt.rotationPoint || 'centermiddle');

                    renderer.attr(txtElement,
                        {
                            fill: txt.fillColor,
                            stroke: txt.lineColor,
                            'class': txt['class']
                        });
                }

                var events = [
                    'click',
                    'mouseenter',
                    'mouseleave'
                ];

                var self = this;

                for (var i = 0; i < events.length; i++) {
                    var event = this._getEvent(events[i]) || events[i];

                    if (shape)
                        this.renderer.addHandler(shape, event, function () {
                            self._raiseAnnotationEvent(annotation, event);
                        }
                        );

                    if (txtElement)
                        this.renderer.addHandler(txtElement, event, function () {
                            self._raiseAnnotationEvent(annotation, event);
                        }
                        );
                }
            },

            _raiseAnnotationEvent: function (annotation, event) {
                this._raiseEvent('annotation_' + event, { annotation: annotation });
            }


        });
})(jqxBaseFramework);

})();




/***/ }),

/***/ 9815:
/***/ (() => {

/* tslint:disable */
/* eslint-disable */
(function(){
	if (typeof document === 'undefined') { 
		return;
	}

(function ($) {
    $.extend($.jqx._jqxChart.prototype,
    {
        _moduleApi: true,

        getItemsCount: function(groupIndex, serieIndex)
        {
            var g = this.seriesGroups[groupIndex];

            if (!this._isSerieVisible(groupIndex, serieIndex))
                return 0;

            var renderData = this._renderData;
            if (!g || !renderData || renderData.length <= groupIndex)
                return 0;
                
            var serie = g.series[serieIndex];
            if (!serie)
                return 0;

            return renderData[groupIndex].offsets[serieIndex].length;

        },

        getXAxisRect: function(groupIndex)
        {
            var renderData = this._renderData;
            if (!renderData || renderData.length <= groupIndex)
                return undefined;

            if (!renderData[groupIndex].xAxis)
                return undefined;

            return renderData[groupIndex].xAxis.rect;
        },

        getXAxisLabels: function(groupIndex)
        {
            var output = [];

            var renderData = this._renderData;
            if (!renderData || renderData.length <= groupIndex)
                return output;

            renderData = renderData[groupIndex].xAxis;
            if (!renderData)
                return output;

            var group = this.seriesGroups[groupIndex];

            if (group.polar || group.spider)
            {
                for (var i = 0; i < renderData.polarLabels.length; i++)
                {
                    var label = renderData.polarLabels[i];
                    output.push({offset: {x: label.x, y: label.y}, value: label.value});
                }

                return output;
            }

            var xAxis = this._getXAxis(groupIndex);
            var rect = this.getXAxisRect(groupIndex);            
            var swapPosition = xAxis.position == 'top' || xAxis.position == 'right';
            var swapXY = group.orientation == 'horizontal';

            for (var i = 0; i < renderData.data.length; i++)
            {
                if (swapXY)
                    output.push({offset: {x: rect.x + (swapPosition ? 0 : rect.width), y: rect.y + renderData.data.data[i]}, value: renderData.data.xvalues[i]});
                else
                    output.push({offset: {x: rect.x + renderData.data.data[i], y: rect.y + (swapPosition ? rect.height : 0)}, value: renderData.data.xvalues[i]});
            }

            return output;
        },

        getValueAxisRect: function(groupIndex)
        {
            var renderData = this._renderData;
            if (!renderData || renderData.length <= groupIndex)
                return undefined;

            if (!renderData[groupIndex].valueAxis)
                return undefined;

            return renderData[groupIndex].valueAxis.rect;
        },

        getValueAxisLabels: function(groupIndex)
        {
            var output = [];

            var renderData = this._renderData;
            if (!renderData || renderData.length <= groupIndex)
                return output;

            renderData = renderData[groupIndex].valueAxis;
            if (!renderData)
                return output;

            var valueAxis = this._getValueAxis(groupIndex);
            var swapPosition = valueAxis.position == 'top' || valueAxis.position == 'right';

            var group = this.seriesGroups[groupIndex];
            var swapXY = group.orientation == 'horizontal';

            if (group.polar || group.spider)
            {
                for (var i = 0; i < renderData.polarLabels.length; i++)
                {
                    var label = renderData.polarLabels[i];
                    output.push({offset: {x: label.x, y: label.y}, value: label.value});
                }

                return output;
            }

            for (var i = 0; i < renderData.items.length; i++)
            {
                if (swapXY)
                {
                    output.push(
                        {
                            offset: 
                            {
                                x: renderData.itemOffsets[renderData.items[i]].x + renderData.itemWidth/2,
                                y: renderData.rect.y + (swapPosition ? renderData.rect.height : 0)
                            }, 
                            value: renderData.items[i]
                        }
                    );
                }
                else
                {
                    output.push(
                        {
                            offset: 
                            {
                                x: renderData.rect.x + renderData.rect.width, 
                                y: renderData.itemOffsets[renderData.items[i]].y + renderData.itemWidth/2
                            }, 
                            value: renderData.items[i]
                        }
                    );

                }
            }

            return output;
        },


        getPlotAreaRect: function()
        {
            return this._plotRect;
        },

        getRect: function()
        {
            return this._rect;
        },

        showToolTip: function(groupIndex, serieIndex, itemIndex, showDelay, hideDelay)
        {
            var coord = this.getItemCoord(groupIndex, serieIndex, itemIndex);
            if (isNaN(coord.x) || isNaN(coord.y))
                return;

            this._startTooltipTimer(groupIndex, serieIndex, itemIndex, coord.x, coord.y, showDelay, hideDelay);
        },

        hideToolTip: function(hideDelay)
        {
            if (isNaN(hideDelay))
                hideDelay = 0;

            var self = this;
            self._cancelTooltipTimer();

            setTimeout(function() {
                    self._hideToolTip(0);
                }, 
                hideDelay
            );
        },

    });
})(jqxBaseFramework);

})();




/***/ }),

/***/ 7848:
/***/ (() => {

/* tslint:disable */
/* eslint-disable */
(function(){
	if (typeof document === 'undefined') { 
		return;
	}

(function ($) {
    $.jqx.jqxWidget("jqxChart", "", {});

    $.extend($.jqx._jqxChart.prototype,
        {
            defineInstance: function () {

                $.extend(true, this, this._defaultSettings);

                this._createColorsCache();
                return this._defaultSettings;
            },

            _defaultSettings: {
                title: 'Title',
                description: 'Description',
                source: [],
                seriesGroups: [],
                categoryAxis: null,
                xAxis: {},
                valueAxis: null,
                renderEngine: '',
                enableAnimations: true,
                enableAxisTextAnimation: false,
                backgroundImage: '',
                background: '#FFFFFF',
                padding: { left: 5, top: 5, right: 5, bottom: 5 },
                backgroundColor: '#FFFFFF',
                showBorderLine: true,
                borderLineWidth: 1,
                borderLineColor: null,
                borderColor: null,
                titlePadding: { left: 5, top: 5, right: 5, bottom: 10 },
                showLegend: true,
                legendLayout: null,
                enabled: true,
                colorScheme: 'scheme01',
                animationDuration: 500,
                showToolTips: true,
                showToolTipsOnAllSeries: false,
                toolTipShowDelay: 300,
                toolTipDelay: 500,
                toolTipHideDelay: 4000,
                toolTipMoveDuration: 300,
                toolTipFormatFunction: null,
                toolTipAlignment: 'dataPoint',
                localization: null,
                columnSeriesOverlap: false,
                rtl: false,
                legendPosition: null,
                greyScale: false,
                axisPadding: 5,
                enableCrosshairs: false,
                crosshairsColor: '#BCBCBC',
                crosshairsDashStyle: '2,2',
                crosshairsLineWidth: 1.0,
                enableEvents: true,
                _itemsToggleState: [],
                _isToggleRefresh: false,
                _isSelectorRefresh: false,
                _sliders: [],
                _selectorRange: [],
                _rangeSelectorInstances: {},
                _resizeState: {},
                renderer: null,
                _isRangeSelectorInstance: false,
                drawBefore: null,
                draw: null,
                _renderData: {},
                enableSampling: true
            },

            _defaultLineColor: '#BCBCBC',

            _touchEvents: {
                'mousedown': $.jqx.mobile.getTouchEventName('touchstart'),
                'click': $.jqx.mobile.getTouchEventName('touchstart'),
                'mouseup': $.jqx.mobile.getTouchEventName('touchend'),
                'mousemove': $.jqx.mobile.getTouchEventName('touchmove'),
                'mouseenter': 'mouseenter',
                'mouseleave': 'mouseleave'
            },

            _getEvent: function (event) {
                if (this._isTouchDevice) {
                    return this._touchEvents[event];
                } else {
                    return event;
                }
            },

            destroy: function () {
                this.host.remove();
            },

            _jqxPlot: null,

            createInstance: function (args) {
                if (!$.jqx.dataAdapter)
                    throw 'jqxdata.js is not loaded';

                var self = this;
                self._refreshOnDownloadComlete();
                self._isTouchDevice = $.jqx.mobile.isTouchDevice();

                if (!self._jqxPlot)
                    self._jqxPlot = new jqxPlot();

                self.addHandler(self.host, self._getEvent('mousemove'), function (event) {
                    if (self.enabled == false)
                        return;

                    if (!self._isRangeSelectorInstance)
                        self.host.css('cursor', 'default');

                    //event.preventDefault();
                    var x = event.pageX || event.clientX || event.screenX;
                    var y = event.pageY || event.clientY || event.screenY;
                    var pos = self.host.offset();

                    if (self._isTouchDevice) {
                        var cursorPos = $.jqx.position(event);
                        x = cursorPos.left;
                        y = cursorPos.top;
                    }

                    x -= pos.left;
                    y -= pos.top;

                    self.onmousemove(x, y);
                });

                self.addHandler(self.host, self._getEvent('mouseleave'), function (event) {
                    if (self.enabled == false)
                        return;

                    var x = self._mouseX;
                    var y = self._mouseY;

                    var rect = self._plotRect;

                    if (rect && x >= rect.x && x <= rect.x + rect.width && y >= rect.y && y <= rect.y + rect.height)
                        return;

                    self._cancelTooltipTimer();
                    self._hideToolTip(0);
                    self._unselect();
                });

                self.addHandler(self.host, 'click', function (event) {
                    if (self.enabled == false)
                        return;

                    var x = event.pageX || event.clientX || event.screenX;
                    var y = event.pageY || event.clientY || event.screenY;
                    var pos = self.host.offset();

                    if (self._isTouchDevice) {
                        var cursorPos = $.jqx.position(event);
                        x = cursorPos.left;
                        y = cursorPos.top;
                    }

                    x -= pos.left;
                    y -= pos.top;

                    self._mouseX = x;
                    self._mouseY = y;


                    if (!isNaN(self._lastClickTs)) {
                        if ((new Date()).valueOf() - self._lastClickTs < 100)
                            return;
                    }

                    this._hostClickTimer = setTimeout(function () {
                        if (!self._isTouchDevice) {
                            self._cancelTooltipTimer();
                            self._hideToolTip();
                            self._unselect();
                        }

                        if (self._pointMarker && self._pointMarker.element) {
                            var group = self.seriesGroups[self._pointMarker.gidx];
                            var serie = group.series[self._pointMarker.sidx];

                            event.stopImmediatePropagation();
                            self._raiseItemEvent('click', group, serie, self._pointMarker.iidx);
                        }
                    },
                        100);
                });

                var elementStyle = self.element.style;
                if (elementStyle) {
                    var sizeInPercentage = false;
                    if (elementStyle.width != null)
                        sizeInPercentage |= elementStyle.width.toString().indexOf('%') != -1;

                    if (elementStyle.height != null)
                        sizeInPercentage |= elementStyle.height.toString().indexOf('%') != -1;

                    if (sizeInPercentage) {
                        $.jqx.utilities.resize(this.host, function () {
                            if (self.timer)
                                clearTimeout(self.timer);

                            var delay = 1;
                            self.timer = setTimeout(function () {
                                var tmp = self.enableAnimations;
                                self.enableAnimations = false;
                                self.refresh();
                                self.enableAnimations = tmp;
                            }, delay);
                        }, false, true);
                    }
                }
            }, // createInstance

            /** @private */
            _refreshOnDownloadComlete: function () {
                var self = this;
                var source = this.source;
                if (source instanceof $.jqx.dataAdapter) {
                    var adapteroptions = source._options;
                    if (adapteroptions == undefined || (adapteroptions != undefined && !adapteroptions.autoBind)) {
                        source.autoSync = false;
                        source.dataBind();
                    }

                    var elementId = this.element.id;
                    if (source.records.length == 0) {
                        var updateFunc = function () {
                            // sends a callback function to the user. This allows him to add additional initialization logic before the chart is rendered.
                            if (self.ready)
                                self.ready();

                            self.refresh();
                        };

                        source.unbindDownloadComplete(elementId);
                        source.bindDownloadComplete(elementId, updateFunc);
                    }
                    else {
                        // sends a callback function to the user. This allows him to add additional initialization logic before the chart is rendered.
                        if (self.ready)
                            self.ready();
                    }

                    source.unbindBindingUpdate(elementId);
                    source.bindBindingUpdate(elementId, function () {
                        if (self._supressBindingRefresh)
                            return;

                        self.refresh();
                    });
                }
            },

            propertyChangedHandler: function (object, key, oldvalue, value) {
                if (this.isInitialized == undefined || this.isInitialized == false)
                    return;

                if (key == 'source')
                    this._refreshOnDownloadComlete();

                this.refresh();
            },

            /** @private */
            _initRenderer: function (host) {
                if (!$.jqx.createRenderer)
                    throw 'Please include jqxdraw.js';

                return $.jqx.createRenderer(this, host);
            },

            /** @private */
            _internalRefresh: function () {
                var self = this;

                // validate visiblity
                if ($.jqx.isHidden(self.host))
                    return;

                self._stopAnimations();

                if (!self.renderer || (!self._isToggleRefresh && !self._isUpdate)) {
                    self._hideToolTip(0);
                    self._isVML = false;
                    self.host.empty();
                    self._measureDiv = undefined;
                    self._initRenderer(self.host);
                }

                var renderer = self.renderer;
                if (!renderer)
                    return;

                var rect = renderer.getRect();

                self._render({ x: 1, y: 1, width: rect.width, height: rect.height });

                this._raiseEvent('refreshBegin', { instance: this });

                if (renderer instanceof $.jqx.HTML5Renderer)
                    renderer.refresh();

                self._isUpdate = false;

                this._raiseEvent('refreshEnd', { instance: this });
            },

            saveAsPNG: function (filename, exportServer, isUploadOnly) {
                return this._saveAsImage('png', filename, exportServer, isUploadOnly);
            },

            saveAsJPEG: function (filename, exportServer, isUploadOnly) {
                return this._saveAsImage('jpeg', filename, exportServer, isUploadOnly);
            },

            saveAsPDF: function (filename, exportServer, isUploadOnly) {
                return this._saveAsImage('pdf', filename, exportServer, isUploadOnly);
            },

            /** @private */
            _saveAsImage: function (type, fileName, exportServer, isUploadOnly) {
                var hasRangeSelector = false;
                for (var i = 0; i < this.seriesGroups.length && !hasRangeSelector; i++) {
                    var xAxis = this._getXAxis(i);
                    if (xAxis && xAxis.rangeSelector)
                        hasRangeSelector = true;
                }

                return $.jqx._widgetToImage(this, type, fileName, exportServer, isUploadOnly, hasRangeSelector ? this._selectorSaveAsImageCallback : undefined);
            },

            _selectorSaveAsImageCallback: function (instance, canvas) {
                var self = instance;

                for (var i = 0; i < self.seriesGroups.length; i++) {
                    var xAxis = self._getXAxis(i);
                    if (!xAxis || !xAxis.rangeSelector || xAxis.rangeSelector.renderTo)
                        continue;

                    var selectorInstanceRef = self._rangeSelectorInstances[i];
                    if (!selectorInstanceRef)
                        continue;

                    var selectorInstance = selectorInstanceRef.jqxChart('getInstance');
                    var renderEngineSave = selectorInstance.renderEngine;

                    var rect = selectorInstance.renderer.getRect();
                    var selectorCanvas = selectorInstance.renderer.getContainer().find('canvas')[0];

                    var selectorContext = selectorCanvas.getContext('2d');

                    var slider = self._sliders[i];
                    var swapXY = self.seriesGroups[i].orientation == 'horizontal';
                    var widthProp = !swapXY ? 'width' : 'height';
                    var rwidthProp = swapXY ? 'width' : 'height';
                    var posProp = !swapXY ? 'x' : 'y';
                    var rposProp = swapXY ? 'x' : 'y';

                    var selectedRect = {};
                    selectedRect[posProp] = slider.startOffset + slider.rect[posProp];
                    selectedRect[rposProp] = slider.rect[rposProp];
                    selectedRect[widthProp] = slider.endOffset - slider.startOffset;
                    selectedRect[rwidthProp] = slider.rect[rwidthProp];


                    var colorSelectedRange = xAxis.rangeSelector.colorSelectedRange || 'blue';
                    var colorUnselectedRange = xAxis.rangeSelector.colorUnselectedRange || 'white';
                    var colorRangeLineColor = xAxis.rangeSelector.colorRangeLine || 'grey';


                    var elements = [];
                    elements.push(selectorInstance.renderer.rect(selectedRect.x, selectedRect.y, selectedRect.width, selectedRect.height, { fill: colorSelectedRange, opacity: 0.1 }));

                    if (!swapXY) {
                        elements.push(selectorInstance.renderer.line($.jqx._ptrnd(slider.rect.x), $.jqx._ptrnd(slider.rect.y), $.jqx._ptrnd(selectedRect.x), $.jqx._ptrnd(slider.rect.y), { stroke: colorRangeLineColor, opacity: 0.5 }));
                        elements.push(selectorInstance.renderer.line($.jqx._ptrnd(selectedRect.x + selectedRect.width), $.jqx._ptrnd(slider.rect.y), $.jqx._ptrnd(slider.rect.x + slider.rect.width), $.jqx._ptrnd(slider.rect.y), { stroke: colorRangeLineColor, opacity: 0.5 }));

                        elements.push(selectorInstance.renderer.line($.jqx._ptrnd(selectedRect.x), $.jqx._ptrnd(slider.rect.y), $.jqx._ptrnd(selectedRect.x), $.jqx._ptrnd(slider.rect.y + slider.rect.height), { stroke: colorRangeLineColor, opacity: 0.5 }));
                        elements.push(selectorInstance.renderer.line($.jqx._ptrnd(selectedRect.x + selectedRect.width), $.jqx._ptrnd(slider.rect.y), $.jqx._ptrnd(selectedRect.x + selectedRect.width), $.jqx._ptrnd(slider.rect.y + slider.rect.height), { stroke: colorRangeLineColor, opacity: 0.5 }));
                    }
                    else {
                        elements.push(selectorInstance.renderer.line($.jqx._ptrnd(slider.rect.x + slider.rect.width), $.jqx._ptrnd(slider.rect.y), $.jqx._ptrnd(slider.rect.x + slider.rect.width), $.jqx._ptrnd(selectedRect.y), { stroke: colorRangeLineColor, opacity: 0.5 }));
                        elements.push(selectorInstance.renderer.line($.jqx._ptrnd(slider.rect.x + slider.rect.width), $.jqx._ptrnd(selectedRect.y + selectedRect.height), $.jqx._ptrnd(slider.rect.x + slider.rect.width), $.jqx._ptrnd(slider.rect.y + slider.rect.height), { stroke: colorRangeLineColor, opacity: 0.5 }));

                        elements.push(selectorInstance.renderer.line($.jqx._ptrnd(slider.rect.x), $.jqx._ptrnd(selectedRect.y), $.jqx._ptrnd(slider.rect.x + slider.rect.width), $.jqx._ptrnd(selectedRect.y), { stroke: colorRangeLineColor, opacity: 0.5 }));
                        elements.push(selectorInstance.renderer.line($.jqx._ptrnd(slider.rect.x), $.jqx._ptrnd(selectedRect.y + selectedRect.height), $.jqx._ptrnd(slider.rect.x + slider.rect.width), $.jqx._ptrnd(selectedRect.y + selectedRect.height), { stroke: colorRangeLineColor, opacity: 0.5 }));
                    }

                    selectorInstance.renderer.refresh();

                    var imgdata = selectorContext.getImageData(rect.x, rect.y, rect.width, rect.height);

                    var hostContext = canvas.getContext('2d');

                    hostContext.putImageData(
                        imgdata,
                        parseInt(selectorInstanceRef.css('left')),
                        parseInt(selectorInstanceRef.css('top')),
                        1,
                        1,
                        rect.width,
                        rect.height);

                    for (var j = 0; j < elements.length; j++)
                        selectorInstance.renderer.removeElement(elements[j]);

                    selectorInstance.renderer.refresh();

                }

                return true;
            },

            refresh: function () {
                this._internalRefresh();
            },

            update: function () {
                this._isUpdate = true;
                this._internalRefresh();
            },

            /** @private */
            _seriesTypes: [
                'line', 'stackedline', 'stackedline100',
                'spline', 'stackedspline', 'stackedspline100',
                'stepline', 'stackedstepline', 'stackedstepline100',
                'area', 'stackedarea', 'stackedarea100',
                'splinearea', 'stackedsplinearea', 'stackedsplinearea100',
                'steparea', 'stackedsteparea', 'stackedsteparea100',
                'rangearea', 'splinerangearea', 'steprangearea',
                'column', 'stackedcolumn', 'stackedcolumn100', 'rangecolumn',
                'scatter', 'stackedscatter', 'stackedscatter100',
                'bubble', 'stackedbubble', 'stackedbubble100',
                'pie',
                'donut',
                'candlestick',
                'ohlc',
                'waterfall', 'stackedwaterfall'],

            clear: function () {
                var self = this;

                for (var setting in self._defaultSettings)
                    self[setting] = self._defaultSettings[setting];

                self.title = '';
                self.description = '';

                self.refresh();
            },

            _validateSeriesGroups: function () {
                if (!$.isArray(this.seriesGroups))
                    throw 'Invalid property: \'seriesGroups\' property is required and must be a valid array.';
                for (var i = 0; i < this.seriesGroups.length; i++) {
                    var group = this.seriesGroups[i];
                    if (!group.type)
                        throw 'Invalid property: Each series group must have a valid \'type\' property.'

                    if (!$.isArray(group.series))
                        throw 'Invalid property: Each series group must have a \'series\' property which must be a valid array.'
                }
            },

            /** @private */
            _render: function (rect) {
                var self = this;
                var renderer = self.renderer;
                self._validateSeriesGroups();

                self._colorsCache.clear();

                if (!self._isToggleRefresh && self._isUpdate && self._renderData)
                    self._renderDataClone();

                self._renderData = [];

                renderer.clear();
                self._unselect();
                self._hideToolTip(0);

                var bckgImg = self.backgroundImage;
                if (bckgImg == undefined || bckgImg == '')
                    self.host.css({ 'background-image': '' });
                else
                    self.host.css({ 'background-image': (bckgImg.indexOf('(') != -1 ? bckgImg : "url('" + bckgImg + "')") });

                self._rect = rect;

                var padding = self.padding || { left: 5, top: 5, right: 5, bottom: 5 };

                var clipAll = renderer.createClipRect(rect);
                var groupAll = renderer.beginGroup();
                renderer.setClip(groupAll, clipAll);

                var rFill = renderer.rect(rect.x, rect.y, rect.width - 2, rect.height - 2);

                if (bckgImg == undefined || bckgImg == '')
                    renderer.attr(rFill, { fill: self.backgroundColor || self.background || 'white' });
                else
                    renderer.attr(rFill, { fill: 'transparent' });

                if (self.showBorderLine != false) {
                    var borderColor = self.borderLineColor == undefined ? self.borderColor : self.borderLineColor;
                    if (borderColor == undefined)
                        borderColor = self._defaultLineColor;

                    var borderLineWidth = this.borderLineWidth;
                    if (isNaN(borderLineWidth) || borderLineWidth < 0 || borderLineWidth > 10)
                        borderLineWidth = 1;

                    renderer.attr(rFill, { 'stroke-width': borderLineWidth, stroke: borderColor });
                }
                else {
                    if ($.jqx.browser.msie && $.jqx.browser.version < 9) {
                        renderer.attr(rFill, { 'stroke-width': 1, stroke: self.backgroundColor || 'white' });
                    }
                }

                // Invoke user-defined drawing
                if ($.isFunction(self.drawBefore)) {
                    self.drawBefore(renderer, rect);
                }

                var paddedRect = { x: padding.left, y: padding.top, width: rect.width - padding.left - padding.right, height: rect.height - padding.top - padding.bottom };
                self._paddedRect = paddedRect;
                var titlePadding = self.titlePadding || { left: 2, top: 2, right: 2, bottom: 2 };

                var sz;
                if (self.title && self.title.length > 0) {
                    var cssTitle = self.toThemeProperty('jqx-chart-title-text', null);
                    sz = renderer.measureText(self.title, 0, { 'class': cssTitle });
                    renderer.text(self.title, paddedRect.x + titlePadding.left, paddedRect.y + titlePadding.top, paddedRect.width - (titlePadding.left + titlePadding.right), sz.height, 0, { 'class': cssTitle }, true, 'center', 'center');
                    paddedRect.y += sz.height;
                    paddedRect.height -= sz.height;
                }
                if (self.description && self.description.length > 0) {
                    var cssDesc = self.toThemeProperty('jqx-chart-title-description', null);
                    sz = renderer.measureText(self.description, 0, { 'class': cssDesc });
                    renderer.text(self.description, paddedRect.x + titlePadding.left, paddedRect.y + titlePadding.top, paddedRect.width - (titlePadding.left + titlePadding.right), sz.height, 0, { 'class': cssDesc }, true, 'center', 'center');

                    paddedRect.y += sz.height;
                    paddedRect.height -= sz.height;
                }

                if (self.title || self.description) {
                    paddedRect.y += (titlePadding.bottom + titlePadding.top);
                    paddedRect.height -= (titlePadding.bottom + titlePadding.top);
                }

                var plotRect = { x: paddedRect.x, y: paddedRect.y, width: paddedRect.width, height: paddedRect.height };
                self._plotRect = plotRect;

                // build stats
                self._buildStats(plotRect);

                var isPieOnly = self._isPieOnlySeries();

                var seriesGroups = self.seriesGroups;

                // axis validation
                var swap;
                var hashAxis = { xAxis: {}, valueAxis: {} };
                for (var i = 0; i < seriesGroups.length && !isPieOnly; i++) {
                    if (seriesGroups[i].type == 'pie' || seriesGroups[i].type == 'donut')
                        continue;

                    var xAxis = self._getXAxis(i);
                    if (!xAxis)
                        throw 'seriesGroup[' + i + '] is missing xAxis definition';

                    var xAxisId = xAxis == self._getXAxis() ? -1 : i;
                    hashAxis.xAxis[xAxisId] = 0x00;
                }

                var axisPadding = self.axisPadding;
                if (isNaN(axisPadding))
                    axisPadding = 5;

                // get vertical axis width
                var wYAxis = { left: 0, right: 0, leftCount: 0, rightCount: 0 };
                var wYAxisArr = [];

                for (i = 0; i < seriesGroups.length; i++) {
                    var g = seriesGroups[i];
                    if (g.type == 'pie' || g.type == 'donut' || g.spider == true || g.polar == true) {
                        wYAxisArr.push({ width: 0, position: 0, xRel: 0 });
                        continue;
                    }

                    swap = g.orientation == 'horizontal';

                    var xAxis = self._getXAxis(i);
                    var xAxisId = xAxis == self._getXAxis() ? -1 : i;

                    var valueAxis = self._getValueAxis(i);
                    var valueAxisId = valueAxis == self._getValueAxis() ? -1 : i;

                    var w = !swap ? valueAxis.axisSize : xAxis.axisSize;
                    var axisR = { x: 0, y: plotRect.y, width: plotRect.width, height: plotRect.height };
                    var position = swap ? self._getXAxis(i).position : valueAxis.position;

                    if (!w || w == 'auto') {
                        if (swap) {
                            w = this._renderXAxis(i, axisR, true, plotRect).width;
                            if ((hashAxis.xAxis[xAxisId] & 0x01) == 0x01)
                                w = 0;
                            else if (w > 0)
                                hashAxis.xAxis[xAxisId] |= 0x01;
                        }
                        else {
                            w = self._renderValueAxis(i, axisR, true, plotRect).width;
                            if ((hashAxis.valueAxis[valueAxisId] & 0x01) == 0x01)
                                w = 0;
                            else if (w > 0)
                                hashAxis.valueAxis[valueAxisId] |= 0x01;
                        }
                    }

                    if (position != 'left' && self.rtl == true)
                        position = 'right';
                    if (position != 'right')
                        position = 'left';

                    if (wYAxis[position + 'Count'] > 0 && wYAxis[position] > 0 && w > 0)
                        wYAxis[position] += axisPadding;

                    wYAxisArr.push({ width: w, position: position, xRel: wYAxis[position] });
                    wYAxis[position] += w;
                    wYAxis[position + 'Count']++;
                }

                var measureSize = Math.max(1, Math.max(rect.width, rect.height));

                // get horizontal axis height
                var hXAxis = { top: 0, bottom: 0, topCount: 0, bottomCount: 0 };
                var hXAxisArr = [];

                for (i = 0; i < seriesGroups.length; i++) {
                    var g = seriesGroups[i];
                    if (g.type == 'pie' || g.type == 'donut' || g.spider == true || g.polar == true) {
                        hXAxisArr.push({ height: 0, position: 0, yRel: 0 });
                        continue;
                    }

                    swap = g.orientation == 'horizontal';

                    var valueAxis = this._getValueAxis(i);
                    var valueAxisId = valueAxis == self._getValueAxis() ? -1 : i;

                    var xAxis = self._getXAxis(i);
                    var xAxisId = xAxis == self._getXAxis() ? -1 : i;

                    var h = !swap ? xAxis.axisSize : valueAxis.axisSize;
                    var position = swap ? valueAxis.position : xAxis.position;

                    if (!h || h == 'auto') {
                        if (swap) {
                            h = self._renderValueAxis(i, { x: 0, y: 0, width: measureSize, height: 0 }, true, plotRect).height;
                            if ((hashAxis.valueAxis[valueAxisId] & 0x02) == 0x02)
                                h = 0;
                            else if (h > 0)
                                hashAxis.valueAxis[valueAxisId] |= 0x02;
                        }
                        else {
                            h = self._renderXAxis(i, { x: 0, y: 0, width: measureSize, height: 0 }, true).height;
                            if ((hashAxis.xAxis[xAxisId] & 0x02) == 0x02)
                                h = 0;
                            else if (h > 0)
                                hashAxis.xAxis[xAxisId] |= 0x02;
                        }
                    }

                    if (position != 'top')
                        position = 'bottom';

                    if (hXAxis[position + 'Count'] > 0 && hXAxis[position] > 0 && h > 0)
                        hXAxis[position] += axisPadding;

                    hXAxisArr.push({ height: h, position: position, yRel: hXAxis[position] });

                    hXAxis[position] += h;
                    hXAxis[position + 'Count']++;
                }

                self._createAnimationGroup("series");

                var showLegend = (self.showLegend != false);
                var szLegend = !showLegend ? { width: 0, height: 0 } : self._renderLegend(self.legendLayout ? self._rect : paddedRect, true);
                if (this.legendLayout && (!isNaN(this.legendLayout.left) || !isNaN(this.legendLayout.top)))
                    szLegend = { width: 0, height: 0 };

                if (paddedRect.height < hXAxis.top + hXAxis.bottom + szLegend.height || paddedRect.width < wYAxis.left + wYAxis.right) {
                    renderer.endGroup();
                    return;
                }

                plotRect.height -= hXAxis.top + hXAxis.bottom + szLegend.height;

                plotRect.x += wYAxis.left;
                plotRect.width -= wYAxis.left + wYAxis.right;
                plotRect.y += hXAxis.top;

                var xAxisRect = [];

                if (!isPieOnly) {
                    var lineColor = self._getXAxis().tickMarksColor || self._defaultLineColor;

                    for (i = 0; i < seriesGroups.length; i++) {
                        var g = seriesGroups[i];
                        if (g.polar == true || g.spider == true || g.type == 'pie' || g.type == 'donut')
                            continue;

                        swap = g.orientation == 'horizontal';
                        var xAxisId = self._getXAxis(i) == self._getXAxis() ? -1 : i;
                        var valueAxisId = self._getValueAxis(i) == self._getValueAxis() ? -1 : i;

                        var axisR = { x: plotRect.x, y: 0, width: plotRect.width, height: hXAxisArr[i].height };
                        if (hXAxisArr[i].position != 'top')
                            axisR.y = plotRect.y + plotRect.height + hXAxisArr[i].yRel;
                        else
                            axisR.y = plotRect.y - hXAxisArr[i].yRel - hXAxisArr[i].height;

                        if (swap) {
                            if ((hashAxis.valueAxis[valueAxisId] & 0x04) == 0x04)
                                continue;

                            if (!self._isGroupVisible(i))
                                continue;

                            self._renderValueAxis(i, axisR, false, plotRect);

                            hashAxis.valueAxis[valueAxisId] |= 0x04;
                        }
                        else {
                            xAxisRect.push(axisR);

                            if ((hashAxis.xAxis[xAxisId] & 0x04) == 0x04)
                                continue;

                            if (!self._isGroupVisible(i))
                                continue;

                            self._renderXAxis(i, axisR, false, plotRect);
                            hashAxis.xAxis[xAxisId] |= 0x04;
                        }
                    }
                }

                if (showLegend) {
                    var containerRect = self.legendLayout ? self._rect : paddedRect;

                    var x = paddedRect.x + $.jqx._ptrnd((paddedRect.width - szLegend.width) / 2);
                    var y = plotRect.y + plotRect.height + hXAxis.bottom;
                    var w = paddedRect.width;
                    var h = szLegend.height;
                    if (self.legendLayout) {
                        if (!isNaN(self.legendLayout.left))
                            x = self.legendLayout.left;

                        if (!isNaN(self.legendLayout.top))
                            y = self.legendLayout.top;

                        if (!isNaN(self.legendLayout.width))
                            w = self.legendLayout.width;

                        if (!isNaN(self.legendLayout.height))
                            h = self.legendLayout.height;
                    }

                    if (x + w > containerRect.x + containerRect.width)
                        w = containerRect.x + containerRect.width - x;
                    if (y + h > containerRect.y + containerRect.height)
                        h = containerRect.y + containerRect.height - y;

                    self._renderLegend({ x: x, y: y, width: w, height: h });
                }

                self._hasHorizontalLines = false;
                if (!isPieOnly) {
                    for (i = 0; i < seriesGroups.length; i++) {
                        var g = seriesGroups[i];

                        if (g.polar == true || g.spider == true || g.type == 'pie' || g.type == 'donut')
                            continue;

                        swap = seriesGroups[i].orientation == 'horizontal';
                        var axisR = { x: plotRect.x - wYAxisArr[i].xRel - wYAxisArr[i].width, y: plotRect.y, width: wYAxisArr[i].width, height: plotRect.height };
                        if (wYAxisArr[i].position != 'left')
                            axisR.x = plotRect.x + plotRect.width + wYAxisArr[i].xRel;

                        var xAxisId = self._getXAxis(i) == self._getXAxis() ? -1 : i;
                        var valueAxisId = self._getValueAxis(i) == self._getValueAxis() ? -1 : i;

                        if (swap) {
                            xAxisRect.push(axisR);

                            if ((hashAxis.xAxis[xAxisId] & 0x08) == 0x08)
                                continue;

                            if (!self._isGroupVisible(i))
                                continue;

                            self._renderXAxis(i, axisR, false, plotRect);
                            hashAxis.xAxis[xAxisId] |= 0x08;
                        }
                        else {
                            if ((hashAxis.valueAxis[valueAxisId] & 0x08) == 0x08)
                                continue;

                            if (!self._isGroupVisible(i))
                                continue;

                            self._renderValueAxis(i, axisR, false, plotRect);
                            hashAxis.valueAxis[valueAxisId] |= 0x08;
                        }
                    }
                }

                if (plotRect.width <= 0 || plotRect.height <= 0)
                    return;

                self._plotRect = { x: plotRect.x, y: plotRect.y, width: plotRect.width, height: plotRect.height };

                for (i = 0; i < seriesGroups.length; i++) {
                    this._drawPlotAreaLines(i, true, { gridLines: false, tickMarks: false, alternatingBackground: true });
                    this._drawPlotAreaLines(i, false, { gridLines: false, tickMarks: false, alternatingBackground: true });
                }

                for (i = 0; i < seriesGroups.length; i++) {
                    this._drawPlotAreaLines(i, true, { gridLines: true, tickMarks: true, alternatingBackground: false });
                    this._drawPlotAreaLines(i, false, { gridLines: true, tickMarks: true, alternatingBackground: false });
                }

                var hasCustomDraw = false;
                for (i = 0; i < seriesGroups.length && !hasCustomDraw; i++) {
                    var g = seriesGroups[i];
                    if (g.annotations !== undefined ||
                        $.isFunction(g.draw) ||
                        $.isFunction(g.drawBefore)
                    ) {
                        hasCustomDraw = true;
                        break;
                    }
                }

                var gPlot = renderer.beginGroup();

                if (!hasCustomDraw) {
                    var clip = renderer.createClipRect({ x: plotRect.x - 2, y: plotRect.y, width: plotRect.width + 4, height: plotRect.height });
                    renderer.setClip(gPlot, clip);
                }

                for (i = 0; i < seriesGroups.length; i++) {
                    var g = seriesGroups[i];
                    var isValid = false;
                    for (var validtype in self._seriesTypes) {
                        if (self._seriesTypes[validtype] == g.type) {
                            isValid = true;
                            break;
                        }
                    }
                    if (!isValid)
                        throw 'Invalid serie type "' + g.type + '"';

                    // custom drawing before the group
                    if ($.isFunction(g.drawBefore))
                        g.drawBefore(renderer, rect, i, this);

                    // polar series drawing
                    if (g.polar == true || g.spider == true) {
                        if (g.type.indexOf('pie') == -1 && g.type.indexOf('donut') == -1)
                            self._renderSpiderAxis(i, plotRect);
                    }

                    self._renderAxisBands(i, plotRect, true);
                    self._renderAxisBands(i, plotRect, false);
                }

                for (i = 0; i < seriesGroups.length; i++) {
                    var g = seriesGroups[i];

                    if (self._isColumnType(g.type))
                        self._renderColumnSeries(i, plotRect);
                    else if (g.type.indexOf('pie') != -1 || g.type.indexOf('donut') != -1)
                        self._renderPieSeries(i, plotRect);
                    else if (g.type.indexOf('line') != -1 || g.type.indexOf('area') != -1)
                        self._renderLineSeries(i, plotRect);
                    else if (g.type.indexOf('scatter') != -1 || g.type.indexOf('bubble') != -1)
                        self._renderScatterSeries(i, plotRect);
                    else if (g.type.indexOf('candlestick') != -1 || g.type.indexOf('ohlc') != -1)
                        self._renderCandleStickSeries(i, plotRect, g.type.indexOf('ohlc') != -1);

                    if (g.annotations) {
                        if (!this._moduleAnnotations)
                            throw "Please include 'jqxchart.annotations.js'";

                        for (var j = 0; j < g.annotations.length; j++)
                            self._renderAnnotation(i, g.annotations[j], plotRect);
                    }

                    // custom drawing after the group
                    if ($.isFunction(g.draw))
                        self.draw(renderer, rect, i, this);
                }

                renderer.endGroup();

                if (self.enabled == false) {
                    var el = renderer.rect(rect.x, rect.y, rect.width, rect.height);
                    renderer.attr(el, { fill: '#777777', opacity: 0.5, stroke: '#00FFFFFF' });
                }

                // Invoke user-defined drawing
                if ($.isFunction(self.draw)) {
                    self.draw(renderer, rect);
                }

                renderer.endGroup();

                self._startAnimation("series");

                if (self._credits) {
                    self._credits();
                }

                // render range selector
                var hasRangeSelector = false;
                for (var i = 0; i < self.seriesGroups.length && !hasRangeSelector; i++) {
                    var xAxis = self._getXAxis(i);
                    if (xAxis && xAxis.rangeSelector)
                        hasRangeSelector = true;
                }

                if (hasRangeSelector) {
                    if (!this._moduleRangeSelector)
                        throw "Please include 'jqxchart.rangeselector.js'";

                    var isRendered = [];

                    if (!this._isSelectorRefresh) {
                        self.removeHandler($(document), self._getEvent('mousemove'), self._onSliderMouseMove);
                        self.removeHandler($(document), self._getEvent('mousedown'), self._onSliderMouseDown);
                        self.removeHandler($(document), self._getEvent('mouseup'), self._onSliderMouseUp);
                    }

                    if (!self._isSelectorRefresh)
                        self._rangeSelectorInstances = {};

                    for (i = 0; i < self.seriesGroups.length; i++) {
                        var axis = this._getXAxis(i);

                        if (isRendered.indexOf(axis) == -1) {
                            if (this._renderXAxisRangeSelector(i, xAxisRect[i]))
                                isRendered.push(axis);
                        }
                    }
                }
            },

            _credits: function () {
                if ($.jqx["c" + "r" + "e" + "d" + "i" + "t" + "s"] !== "71208878-FCD1-4EC7-9249-BA0F153A5DE8") {
	var self = this;
	var t = String.fromCharCode(119, 119, 119, 46, 106, 113, 119, 105, 100, 103, 101, 116, 115, 46, 99, 111, 109);
	if (!self._isRangeSelectorInstance && location.hostname.indexOf(t.substring(4)) == -1) {
		var renderer = self.renderer;
		var rect = self._rect;
		var params = { 'class': self.toThemeProperty('jqx-chart-legend-text', null), opacity: 0.5 };
		var tsz = renderer.measureText(t, 0, params);
		var txt = renderer.text(t, rect.x + rect.width - tsz.width - 5, rect.y + rect.height - tsz.height - 5, tsz.width, tsz.height, 0, params);
		$(txt).on('click', function () { location.href = 'http://' + t + '/?ref=' + self.widgetName; });
	}
}

            },

            /** @private */
            _isPieOnlySeries: function () {
                var seriesGroups = this.seriesGroups;
                if (seriesGroups.length == 0)
                    return false;

                for (var i = 0; i < seriesGroups.length; i++) {
                    if (seriesGroups[i].type != 'pie' && seriesGroups[i].type != 'donut')
                        return false;
                }

                return true;
            },

            /** @private */
            _renderChartLegend: function (data, rect, isMeasure, isVerticalFlow) {
                var self = this;
                var renderer = self.renderer;

                var r = { x: rect.x, y: rect.y, width: rect.width, height: rect.height };
                var padding = 3;
                if (r.width >= 2 * padding) {
                    r.x += padding;
                    r.width -= 2 * padding;
                }
                if (r.height >= 2 * padding) {
                    r.y += padding;
                    r.height -= 2 * padding;
                }

                var szMeasure = { width: r.width, height: 0 };

                var x = 0, y = 0;
                var rowH = 20;
                var rowW = 0;
                var barSize = 10;
                var space = 10;
                var maxWidth = 0;
                for (var i = 0; i < data.length; i++) {
                    var css = data[i].css;
                    if (!css)
                        css = self.toThemeProperty('jqx-chart-legend-text', null);

                    rowH = 20;
                    var text = data[i].text;
                    var sz = renderer.measureText(text, 0, { 'class': css });

                    if (sz.height > rowH) {
                        rowH = sz.height;
                    }

                    if (sz.width > maxWidth)
                        maxWidth = sz.width;

                    if (isVerticalFlow) {
                        if (i != 0)
                            y += rowH;

                        if (y > r.height) {
                            y = 0;
                            x += maxWidth + 2 * space + barSize;
                            maxWidth = sz.width;
                            szMeasure.width = x + maxWidth;
                        }
                    }
                    else {
                        if (x != 0)
                            x += space;

                        if (x + 2 * barSize + sz.width > r.width && sz.width < r.width) {
                            x = 0;
                            y += rowH;
                            rowH = 20;
                            rowW = r.width;
                            szMeasure.height = y + rowH;
                        }
                    }

                    var wrap = false;
                    if (sz.width > r.width) {
                        wrap = true;
                        var wrapWidth = r.width;
                        var legendInfo = text;
                        var words = legendInfo.split(/\s+/);
                        var textInfo = [];
                        var currentLine = "";
                        for (var iWord = 0; iWord < words.length; iWord++) {
                            var txt = currentLine + ((currentLine.length > 0) ? " " : "") + words[iWord];
                            var textSize = self.renderer.measureText(txt, 0, { 'class': css });

                            if (textSize.width > wrapWidth && txt.length > 0 && currentLine.length > 0) {
                                textInfo.push({ text: currentLine });
                                currentLine = words[iWord];
                            }
                            else
                                currentLine = txt;

                            if (iWord + 1 == words.length)
                                textInfo.push({ text: currentLine });
                        }

                        sz.width = 0;
                        var height = 0;
                        for (var t = 0; t < textInfo.length; t++) {
                            var textItem = textInfo[t].text;
                            var textSize = self.renderer.measureText(textItem, 0, { 'class': css });
                            sz.width = Math.max(sz.width, textSize.width);
                            height += sz.height;
                        }
                        sz.height = height;
                    }

                    var renderInBounds = (x + sz.width < r.width) && (y + sz.height < rect.height);

                    if (self.legendLayout) {
                        var renderInBounds = r.x + x + sz.width < self._rect.x + self._rect.width &&
                            r.y + y + sz.height < self._rect.y + self._rect.height;
                    }

                    if (!isMeasure && renderInBounds
                    ) {
                        var sidx = data[i].seriesIndex;
                        var gidx = data[i].groupIndex;
                        var iidx = data[i].itemIndex;
                        var fillColor = data[i].fillColor;
                        var lineColor = data[i].lineColor;

                        var isVisible = self._isSerieVisible(gidx, sidx, iidx);
                        var g = renderer.beginGroup();
                        var opacity = isVisible ? data[i].opacity : 0.1;
                        if (wrap) {
                            var legendInfo = text;
                            var wrapWidth = r.width;
                            var words = legendInfo.split(/\s+/);
                            var wrapText = "";
                            var dy = 0;
                            var textInfo = [];

                            var currentLine = "";
                            for (var iWord = 0; iWord < words.length; iWord++) {
                                var txt = currentLine + ((currentLine.length > 0) ? " " : "") + words[iWord];
                                var textSize = self.renderer.measureText(txt, 0, { 'class': css });

                                if (textSize.width > wrapWidth && txt.length > 0 && currentLine.length > 0) {
                                    textInfo.push({ text: currentLine, dy: dy });
                                    dy += textSize.height;

                                    currentLine = words[iWord]
                                }
                                else
                                    currentLine = txt;

                                if (iWord + 1 == words.length)
                                    textInfo.push({ text: currentLine, dy: dy });
                            }


                            for (var t = 0; t < textInfo.length; t++) {
                                var textItem = textInfo[t].text;
                                dy = textInfo[t].dy;
                                var textSize = self.renderer.measureText(textItem, 0, { 'class': css });
                                if (isVerticalFlow) {
                                    self.renderer.text(textItem, r.x + x + 1.5 * barSize, r.y + y + dy, sz.width, rowH, 0, { 'class': css }, false, 'left', 'center');
                                }
                                else {
                                    self.renderer.text(textItem, r.x + x + 1.5 * barSize, r.y + y + dy, sz.width, rowH, 0, { 'class': css }, false, 'center', 'center');
                                }
                            }

                            var elem = renderer.rect(r.x + x, r.y + y + barSize / 2 + dy / 2, barSize, barSize);
                            if (isVerticalFlow)
                                y += dy;

                            self.renderer.attr(elem, { fill: fillColor, 'fill-opacity': opacity, stroke: lineColor, 'stroke-width': 1, 'stroke-opacity': data[i].opacity });
                        }
                        else {
                            var elem = renderer.rect(r.x + x, r.y + y + barSize / 2, barSize, barSize);
                            self.renderer.attr(elem, { fill: fillColor, 'fill-opacity': opacity, stroke: lineColor, 'stroke-width': 1, 'stroke-opacity': data[i].opacity });
                            if (isVerticalFlow) {
                                self.renderer.text(text, r.x + x + 1.5 * barSize, r.y + y, sz.width, sz.height + barSize / 2, 0, { 'class': css }, false, 'left', 'center');
                            }
                            else {
                                self.renderer.text(text, r.x + x + 1.5 * barSize, r.y + y, sz.width, rowH, 0, { 'class': css }, false, 'center', 'center');
                            }
                        }
                        self.renderer.endGroup();

                        self._setLegendToggleHandler(gidx, sidx, iidx, g);
                    }

                    if (isVerticalFlow) {
                    }
                    else {
                        x += sz.width + 2 * barSize;
                        if (rowW < x)
                            rowW = x;
                    }
                }

                if (isMeasure) {
                    szMeasure.height = $.jqx._ptrnd(y + rowH + 5);
                    szMeasure.width = $.jqx._ptrnd(rowW);
                    return szMeasure;
                }
            },

            isSerieVisible: function (groupIndex, serieIndex, itemIndex) {
                return this._isSerieVisible(groupIndex, serieIndex, itemIndex);
            },

            /** @private */
            _isSerieVisible: function (groupIndex, serieIndex, itemIndex) {
                while (this._itemsToggleState.length < groupIndex + 1)
                    this._itemsToggleState.push([]);

                var g = this._itemsToggleState[groupIndex];
                while (g.length < serieIndex + 1)
                    g.push(isNaN(itemIndex) ? true : []);

                var s = g[serieIndex];
                if (isNaN(itemIndex))
                    return s;

                if (!$.isArray(s))
                    g[serieIndex] = s = [];

                while (s.length < itemIndex + 1)
                    s.push(true);

                return s[itemIndex];
            },

            isGroupVisible: function (groupIndex) {
                return this._isGroupVisible(groupIndex);
            },

            /** @private */
            _isGroupVisible: function (groupIndex) {
                var isGroupVisible = false;
                var series = this.seriesGroups[groupIndex].series;
                if (!series)
                    return isGroupVisible;

                for (var i = 0; i < series.length; i++) {
                    if (this._isSerieVisible(groupIndex, i)) {
                        isGroupVisible = true;
                        break;
                    }
                }

                return isGroupVisible;
            },

            /** @private */
            _toggleSerie: function (groupIndex, serieIndex, itemIndex, enable) {
                var state = !this._isSerieVisible(groupIndex, serieIndex, itemIndex);
                if (enable != undefined)
                    state = enable;

                var group = this.seriesGroups[groupIndex];
                var serie = group.series[serieIndex];

                this._raiseEvent('toggle', { state: state, seriesGroup: group, serie: serie, elementIndex: itemIndex });

                if (isNaN(itemIndex))
                    this._itemsToggleState[groupIndex][serieIndex] = state;
                else {
                    var s = this._itemsToggleState[groupIndex][serieIndex];

                    if (!$.isArray(s))
                        s = [];

                    while (s.length < itemIndex)
                        s.push(true);

                    s[itemIndex] = state;
                }

                this._isToggleRefresh = true;
                this.update();
                this._isToggleRefresh = false;
            },

            showSerie: function (groupIndex, serieIndex, itemIndex) {
                this._toggleSerie(groupIndex, serieIndex, itemIndex, true);
            },

            hideSerie: function (groupIndex, serieIndex, itemIndex) {
                this._toggleSerie(groupIndex, serieIndex, itemIndex, false);
            },

            /** @private */
            _setLegendToggleHandler: function (groupIndex, serieIndex, itemIndex, element) {
                var g = this.seriesGroups[groupIndex];
                var s = g.series[serieIndex];

                var enableSeriesToggle = s.enableSeriesToggle;
                if (enableSeriesToggle == undefined)
                    enableSeriesToggle = g.enableSeriesToggle != false;

                if (enableSeriesToggle) {
                    var self = this;
                    this.renderer.addHandler(element, 'click', function (e) {
                        //e.preventDefault();

                        self._toggleSerie(groupIndex, serieIndex, itemIndex);
                    });
                }
            },

            /** @private */
            _renderLegend: function (rect, isMeasure) {
                var self = this;
                var legendData = [];

                for (var gidx = 0; gidx < self.seriesGroups.length; gidx++) {
                    var g = self.seriesGroups[gidx];
                    if (g.showLegend == false)
                        continue;

                    for (var sidx = 0; sidx < g.series.length; sidx++) {
                        var s = g.series[sidx];
                        if (s.showLegend == false)
                            continue;

                        var settings = self._getSerieSettings(gidx, sidx);
                        var legendText;

                        if (g.type == 'pie' || g.type == 'donut') {
                            var xAxis = self._getXAxis(gidx);
                            var fs = s.legendFormatSettings || g.legendFormatSettings || xAxis.formatSettings || s.formatSettings || g.formatSettings;
                            var ff = s.legendFormatFunction || g.legendFormatFunction || xAxis.formatFunction || s.formatFunction || g.formatFunction;

                            var dataLength = self._getDataLen(gidx);
                            for (var i = 0; i < dataLength; i++) {
                                legendText = self._getDataValue(i, s.displayText, gidx);
                                legendText = self._formatValue(legendText, fs, ff, gidx, sidx, i);

                                var colors = self._getColors(gidx, sidx, i);

                                legendData.push({ groupIndex: gidx, seriesIndex: sidx, itemIndex: i, text: legendText, css: s.displayTextClass, fillColor: colors.fillColor, lineColor: colors.lineColor, opacity: settings.opacity });
                            }

                            continue;
                        }

                        var fs = s.legendFormatSettings || g.legendFormatSettings;
                        var ff = s.legendFormatFunction || g.legendFormatFunction;

                        legendText = self._formatValue(s.displayText || s.dataField || '', fs, ff, gidx, sidx, NaN);
                        var colors = self._getSeriesColors(gidx, sidx);
                        var fillColor = this._get([s.legendFillColor, s.legendColor, colors.fillColor]);
                        var lineColor = this._get([s.legendLineColor, s.legendColor, colors.lineColor]);

                        legendData.push({ groupIndex: gidx, seriesIndex: sidx, text: legendText, css: s.displayTextClass, fillColor: fillColor, lineColor: lineColor, opacity: settings.opacity });
                    }
                }

                return self._renderChartLegend(legendData, rect, isMeasure, (self.legendLayout && self.legendLayout.flow == 'vertical'));
            },

            _getInterval: function (settings, baseUnitInterval) {
                if (!settings)
                    return baseUnitInterval;

                var unitInterval = this._get([settings.unitInterval, baseUnitInterval]);
                if (!isNaN(settings.step))
                    unitInterval = settings.step * baseUnitInterval;

                return unitInterval;
            },

            _getOffsets: function (key, axis, size, stats, settings, padding, valuesOnTicks, baseUnitInterval, useMidVal) {
                var interval = this._getInterval(settings[key], baseUnitInterval);

                var vals = [];
                if (key == '' || (settings[key].visible && settings[key].visible != 'custom'))
                    vals = this._generateIntervalValues(stats, interval, baseUnitInterval, valuesOnTicks, useMidVal);

                var offs;
                if (key != 'labels') {
                    var xOffsetAdj = valuesOnTicks ? padding.left : 0;
                    if (!valuesOnTicks && baseUnitInterval > 1) {
                        xOffsetAdj = padding.left * (baseUnitInterval + 1);
                    }

                    // special case with a single value
                    if (vals.length == 1)
                        xOffsetAdj *= 2;

                    offs = this._valuesToOffsets(vals, axis, stats, size, padding, false, xOffsetAdj);
                    if (!valuesOnTicks) {
                        var adjust = (padding.left + padding.right) * interval / baseUnitInterval;
                        if (axis.flip)
                            offs.unshift(offs[0] + adjust);
                        else
                            offs.push(offs[offs.length - 1] + adjust);
                    }
                }
                else {
                    var xOffsetAdj = padding.left;

                    // special case with a single value
                    if (vals.length == 1)
                        xOffsetAdj *= 2;

                    offs = this._valuesToOffsets(vals, axis, stats, size, padding, valuesOnTicks, xOffsetAdj);
                }
                var out = this._arraysToObjectsArray([vals, offs], ['value', 'offset']);

                if (axis[key] && axis[key].custom) {
                    var customVals = this._objectsArraysToArray(axis[key].custom, 'value');
                    var customOffs = this._objectsArraysToArray(axis[key].custom, 'offset');
                    var customValsOffs = this._valuesToOffsets(customVals, axis, stats, size, padding, valuesOnTicks, padding.left);
                    for (var i = 0; i < axis[key].custom.length; i++) {
                        out.push({
                            value: customVals[i],
                            offset: isNaN(customOffs[i]) ? customValsOffs[i] : customOffs[i]
                        });
                    }
                }

                return out;
            },

            /** @private */
            _renderXAxis: function (groupIndex, rect, isMeasure, chartRect) {
                var self = this;
                var axis = self._getXAxis(groupIndex);
                var g = self.seriesGroups[groupIndex];
                var swapXY = g.orientation == 'horizontal';
                var szMeasure = { width: 0, height: 0 };
                var settings = self._getAxisSettings(axis);

                if (!axis || !settings.visible || g.type == 'spider')
                    return szMeasure;

                // check if the group has visible series
                if (!self._isGroupVisible(groupIndex) || this._isPieGroup(groupIndex))
                    return szMeasure;

                var valuesOnTicks = self._alignValuesWithTicks(groupIndex);

                while (self._renderData.length < groupIndex + 1)
                    self._renderData.push({});

                // TODO: Update RTL/FLIP flag
                if (self.rtl)
                    axis.flip = true;

                var axisSize = swapXY ? rect.height : rect.width;

                var text = axis.text;

                var offsets = self._calculateXOffsets(groupIndex, axisSize);
                var axisStats = offsets.axisStats;

                var rangeSelector = axis.rangeSelector;
                var selectorSize = 0;
                if (rangeSelector) {
                    if (!this._moduleRangeSelector)
                        throw "Please include 'jqxchart.rangeselector.js'";

                    selectorSize = this._selectorGetSize(axis);
                }

                var isMirror = (swapXY && axis.position == 'right') || (!swapXY && axis.position == 'top');

                if (!isMeasure && rangeSelector) {
                    if (swapXY) {
                        rect.width -= selectorSize;
                        if (axis.position != 'right')
                            rect.x += selectorSize;
                    }
                    else {
                        rect.height -= selectorSize;
                        if (axis.position == 'top')
                            rect.y += selectorSize;
                    }
                }

                var renderData = {
                    rangeLength: offsets.rangeLength,
                    itemWidth: offsets.itemWidth,
                    intervalWidth: offsets.intervalWidth,
                    data: offsets,
                    settings: settings,
                    isMirror: isMirror,
                    rect: rect
                };

                self._renderData[groupIndex].xAxis = renderData;

                var ui = axisStats.interval;
                if (isNaN(ui))
                    return szMeasure;

                if (swapXY) {
                    settings.title.angle -= 90;
                    settings.labels.angle -= 90;
                }

                var gridLinesInterval = this._getInterval(settings.gridLines, ui);
                var tickMarksInterval = this._getInterval(settings.tickMarks, ui);
                var labelsInterval = this._getInterval(settings.labels, ui);

                var labelOffsets;

                var min = axisStats.min;
                var max = axisStats.max;

                var padding = offsets.padding;

                var flip = axis.flip == true || self.rtl;

                var range = { min: min, max: max };
                if (axisStats.logAxis.enabled) {
                    range.min = axisStats.logAxis.minPow;
                    range.max = axisStats.logAxis.maxPow;
                }

                if (axis.type == 'date') {
                    settings.gridLines.offsets = this._generateDTOffsets(min, max, axisSize, padding, gridLinesInterval, ui, axisStats.dateTimeUnit, valuesOnTicks, NaN, false, flip);
                    settings.tickMarks.offsets = this._generateDTOffsets(min, max, axisSize, padding, tickMarksInterval, ui, axisStats.dateTimeUnit, valuesOnTicks, NaN, false, flip);
                    labelOffsets = this._generateDTOffsets(min, max, axisSize, padding, labelsInterval, ui, axisStats.dateTimeUnit, valuesOnTicks, NaN, true, flip);
                }
                else {
                    settings.gridLines.offsets = this._getOffsets('gridLines', axis, axisSize, axisStats, settings, padding, valuesOnTicks, ui);
                    settings.tickMarks.offsets = this._getOffsets('tickMarks', axis, axisSize, axisStats, settings, padding, valuesOnTicks, ui);
                    labelOffsets = this._getOffsets('labels', axis, axisSize, axisStats, settings, padding, valuesOnTicks, ui);
                }

                var widgetRect = self.renderer.getRect();
                var paddingRight = widgetRect.width - rect.x - rect.width;
                var len = self._getDataLen(groupIndex);

                var oldPositions;
                if (self._elementRenderInfo && self._elementRenderInfo.length > groupIndex)
                    oldPositions = self._elementRenderInfo[groupIndex].xAxis;

                var items = [];

                // prepare the axis labels
                var ffn;
                if (settings.labels.formatFunction)
                    ffn = settings.labels.formatFunction;

                var fs;
                if (settings.labels.formatSettings)
                    fs = $.extend({}, settings.labels.formatSettings);

                if (axis.type == 'date') {
                    if (axis.dateFormat && !ffn) {
                        if (fs)
                            fs.dateFormat = fs.dateFormat || axis.dateFormat;
                        else
                            fs = { dateFormat: axis.dateFormat };
                    }
                    else if (!ffn && (!fs || (fs && !fs.dateFormat))) {
                        ffn = this._getDefaultDTFormatFn(axis.baseUnit || 'day');
                    }
                }

                for (var i = 0; i < labelOffsets.length; i++) {
                    var value = labelOffsets[i].value;
                    var x = labelOffsets[i].offset;
                    if (isNaN(x))
                        continue;

                    var idx = undefined;

                    if (axis.type != 'date' && axisStats.useIndeces && axis.dataField) {
                        idx = Math.round(value);
                        value = self._getDataValue(idx, axis.dataField);
                        if (value == undefined)
                            value = '';
                    }

                    var text = self._formatValue(value, fs, ffn, groupIndex, undefined, idx);

                    if (text == undefined || text.toString() == '') {
                        if (isNaN(idx))
                            idx = i;

                        if (idx >= axisStats.filterRange.min && idx <= axisStats.filterRange.max)
                            text = axisStats.useIndeces ? (axisStats.min + idx).toString() : (value == undefined ? '' : value.toString());
                    }

                    var obj = { key: value, text: text, targetX: x, x: x };
                    if (oldPositions && oldPositions.itemOffsets[value]) {
                        obj.x = oldPositions.itemOffsets[value].x;
                        obj.y = oldPositions.itemOffsets[value].y;
                    }

                    items.push(obj);
                }
                ///

                var anim = self._getAnimProps(groupIndex);
                var duration = anim.enabled && items.length < 500 ? anim.duration : 0;
                if (self.enableAxisTextAnimation == false)
                    duration = 0;

                var itemsInfo = { items: items, renderData: renderData };

                var sz = self._renderAxis(swapXY, isMirror, settings, { x: rect.x, y: rect.y, width: rect.width, height: rect.height }, chartRect, ui, false, true /*valuesOnTicks*/, itemsInfo, isMeasure, duration);

                if (swapXY)
                    sz.width += selectorSize;
                else
                    sz.height += selectorSize;

                return sz;
            },

            /** @private */
            _animateAxisText: function (context, percent) {
                var items = context.items;
                var textSettings = context.textSettings;

                for (var i = 0; i < items.length; i++) {
                    var item = items[i];
                    if (!item)
                        continue;

                    if (!item.visible)
                        continue;

                    var x = item.targetX;
                    var y = item.targetY;
                    if (!isNaN(item.x) && !isNaN(item.y)) {
                        x = item.x + (x - item.x) * percent;
                        y = item.y + (y - item.y) * percent;
                    }

                    // TODO: Optimize via text reponsitioning.
                    // Requires SVG & VML text rendering changes
                    if (item.element) {
                        this.renderer.removeElement(item.element);
                        item.element = undefined;
                    }

                    item.element = this.renderer.text(
                        item.text,
                        x,
                        y,
                        item.width,
                        item.height,
                        textSettings.angle,
                        { 'class': textSettings.style },
                        false,
                        textSettings.halign,
                        textSettings.valign,
                        textSettings.textRotationPoint);
                }
            },

            /** @private */
            _getPolarAxisCoords: function (groupIndex, rect) {
                var group = this.seriesGroups[groupIndex];

                var offsetX = rect.x + $.jqx.getNum([group.offsetX, rect.width / 2]);
                var offsetY = rect.y + $.jqx.getNum([group.offsetY, rect.height / 2]);

                var availableSize = Math.min(rect.width, rect.height);

                var radius = group.radius;

                if (this._isPercent(radius))
                    radius = parseFloat(radius) / 100 * availableSize / 2;

                if (isNaN(radius))
                    radius = availableSize / 2 * 0.6;

                var valuesOnTicks = this._alignValuesWithTicks(groupIndex);

                var startAngle = this._get([group.startAngle, group.minAngle, 0]) - 90;

                if (isNaN(startAngle))
                    startAngle = 0;
                else {
                    startAngle = 2 * Math.PI * startAngle / 360;
                }

                var endAngle = this._get([group.endAngle, group.maxAngle, 360]) - 90;

                if (isNaN(endAngle))
                    endAngle = 2 * Math.PI;
                else {
                    endAngle = 2 * Math.PI * endAngle / 360;
                }

                if (startAngle > endAngle) {
                    var swap = startAngle;
                    startAngle = endAngle;
                    endAngle = swap;
                }

                var axisSizeRatio = $.jqx._rnd(Math.abs(startAngle - endAngle) / (Math.PI * 2), 0.001, true);
                var axisSize = Math.PI * 2 * radius * axisSizeRatio;

                var offsets = this._calcGroupOffsets(groupIndex, rect).xoffsets;
                if (!offsets)
                    return;

                var isClosedCircle = !(Math.abs(Math.abs(endAngle - startAngle) - Math.PI * 2) > 0.00001);

                if (group.spider) {
                    var axisStats = this._getXAxisStats(groupIndex, this._getXAxis(groupIndex), axisSize);
                    var interval = axisStats.interval;
                    if (isNaN(interval) || interval == 0)
                        interval = 1;

                    var slices = (axisStats.max - axisStats.min) / interval + (isClosedCircle ? 1 : 0);
                    slices = Math.round(slices);

                    if (slices > 2) {
                        var cos = Math.cos(Math.abs(endAngle - startAngle) / 2 / slices);
                        cos = $.jqx._rnd(cos, 0.01);

                        if (cos == 0)
                            cos = 1
                        var adjRadius = radius / cos;

                        if (adjRadius > radius && valuesOnTicks)
                            radius = adjRadius;
                    }
                }

                radius = $.jqx._ptrnd(radius);
                //  axisSize = $.jqx._ptrnd(Math.PI * 2 * radius * axisSizeRatio);

                return {
                    x: offsetX,
                    y: offsetY,
                    r: radius,
                    adjR: this._get([adjRadius, radius]),
                    itemWidth: offsets.itemWidth,
                    rangeLength: offsets.rangeLength,
                    valuesOnTicks: valuesOnTicks,
                    startAngle: startAngle,
                    endAngle: endAngle,
                    isClosedCircle: isClosedCircle,
                    axisSize: axisSize
                };
            },

            /** @private */
            _toPolarCoord: function (polarAxisCoords, rect, x, y) {
                var axisSizeRatio = Math.abs(polarAxisCoords.startAngle - polarAxisCoords.endAngle) / (Math.PI * 2);

                var angle = (x - rect.x) * 2 * Math.PI * axisSizeRatio / Math.max(1, rect.width) + polarAxisCoords.startAngle;

                var radius = ((rect.height + rect.y) - y) * polarAxisCoords.r / Math.max(1, rect.height);

                var px = polarAxisCoords.x + radius * Math.cos(angle);
                var py = polarAxisCoords.y + radius * Math.sin(angle);

                return { x: $.jqx._ptrnd(px), y: $.jqx._ptrnd(py) };
            },

            /** @private */
            _renderSpiderAxis: function (groupIndex, rect) {
                var self = this;
                var axis = self._getXAxis(groupIndex);
                var axisSettings = this._getAxisSettings(axis);

                if (!axis || !axisSettings.visible)
                    return;

                var group = self.seriesGroups[groupIndex];

                var polarCoords = self._getPolarAxisCoords(groupIndex, rect);
                if (!polarCoords)
                    return;

                var offsetX = $.jqx._ptrnd(polarCoords.x);
                var offsetY = $.jqx._ptrnd(polarCoords.y);
                var radius = polarCoords.adjR;
                var startAngle = polarCoords.startAngle;
                var endAngle = polarCoords.endAngle;

                if (radius < 1)
                    return;

                var axisSizeRatio = $.jqx._rnd(Math.abs(startAngle - endAngle) / (Math.PI * 2), 0.001, true);

                var axisSize = Math.PI * 2 * radius * axisSizeRatio;

                var isClosedCircle = polarCoords.isClosedCircle;

                var offsets = this._renderData[groupIndex].xoffsets;
                if (!offsets.rangeLength)
                    return;

                var ui = offsets.axisStats.interval;
                if (isNaN(ui) || ui < 1)
                    ui = 1;

                var swapXY = group.orientation == 'horizontal';

                var isMirror = (swapXY && axis.position == 'right') || (!swapXY && axis.position == 'top');

                while (self._renderData.length < groupIndex + 1)
                    self._renderData.push({});

                var renderData = {
                    rangeLength: offsets.rangeLength,
                    itemWidth: offsets.itemWidth,
                    data: offsets,
                    rect: rect,
                    settings: axisSettings
                };

                self._renderData[groupIndex].xAxis = renderData;
                self._renderData[groupIndex].polarCoords = polarCoords;

                // dedup identical axis drawing
                var showXAxis = true;
                for (var i = 0; i < groupIndex; i++) {
                    var renderDataCompare = self._renderData[i].xAxis;
                    var polarCoordscompare = self._renderData[i].polarCoords;
                    var xAxisCompare = self._getXAxis(i);

                    var nomatch = false;
                    for (var j in polarCoords)
                        if (polarCoords[j] != polarCoordscompare[j]) {
                            nomatch = true;
                            break;
                        }

                    if (!nomatch || xAxisCompare != axis)
                        showXAxis = false;
                }

                var gridLinesSettings = axisSettings.gridLines;
                var tickMarksSettings = axisSettings.tickMarks;
                var labelsSettings = axisSettings.labels;

                var gridLinesInterval = this._getInterval(gridLinesSettings, ui);
                var tickMarksInterval = this._getInterval(tickMarksSettings, ui);
                var labelsInterval = this._getInterval(labelsSettings, ui);

                var valuesOnTicks = self._alignValuesWithTicks(groupIndex);

                var renderer = self.renderer;

                var labelOffsets;

                var axisStats = offsets.axisStats;

                var min = axisStats.min;
                var max = axisStats.max;

                var padding = this._getPaddingSize(offsets.axisStats, axis, valuesOnTicks, axisSize, true, isClosedCircle, false);

                var flip = axis.flip == true || self.rtl;

                if (axis.type == 'date') {
                    gridLinesSettings.offsets = this._generateDTOffsets(min, max, axisSize, padding, gridLinesInterval, ui, axis.baseUnit, true, 0, false, flip);
                    tickMarksSettings.offsets = this._generateDTOffsets(min, max, axisSize, padding, tickMarksInterval, ui, axis.baseUnit, true, 0, false, flip);
                    labelOffsets = this._generateDTOffsets(min, max, axisSize, padding, labelsInterval, ui, axis.baseUnit, true, 0, true, flip);
                }
                else {
                    axisSettings.gridLines.offsets = this._getOffsets('gridLines', axis, axisSize, axisStats, axisSettings, padding, true, ui);
                    axisSettings.tickMarks.offsets = this._getOffsets('tickMarks', axis, axisSize, axisStats, axisSettings, padding, true, ui);
                    labelOffsets = this._getOffsets('labels', axis, axisSize, axisStats, axisSettings, padding, true, ui);

                }

                var widgetRect = self.renderer.getRect();
                var paddingRight = widgetRect.width - rect.x - rect.width;
                var len = self._getDataLen(groupIndex);

                var oldPositions;
                if (self._elementRenderInfo && self._elementRenderInfo.length > groupIndex)
                    oldPositions = self._elementRenderInfo[groupIndex].xAxis;

                var items = [];

                var dataLen = this._getDataLen(groupIndex);

                for (var i = 0; i < labelOffsets.length; i++) {
                    var x = labelOffsets[i].offset;
                    var value = labelOffsets[i].value;

                    if (axis.type != 'date' && axisStats.useIndeces && axis.dataField) {
                        var idx = Math.round(value);
                        if (idx >= dataLen)
                            continue;

                        value = self._getDataValue(idx, axis.dataField);
                        if (value == undefined)
                            value = '';
                    }
                    var text = self._formatValue(value, labelsSettings.formatSettings, labelsSettings.formatFunction, groupIndex, undefined, idx);
                    if (text == undefined || text.toString() == '')
                        text = axisStats.useIndeces ? (axisStats.min + i).toString() : (value == undefined ? '' : value.toString());

                    var obj = { key: value, text: text, targetX: x, x: x };
                    if (oldPositions && oldPositions.itemOffsets[value]) {
                        obj.x = oldPositions.itemOffsets[value].x;
                        obj.y = oldPositions.itemOffsets[value].y;
                    }

                    items.push(obj);
                }

                var itemsInfo = { items: items, renderData: renderData };

                // draw the spider
                var strokeAttributes = { stroke: gridLinesSettings.color, fill: 'none', 'stroke-width': gridLinesSettings.width, 'stroke-dasharray': gridLinesSettings.dashStyle || '' };

                if (!group.spider) {
                    if (axisSizeRatio == 1)
                        renderer.circle(offsetX, offsetY, radius, strokeAttributes);
                    else {
                        var aStart = -startAngle / Math.PI * 180;
                        var aEnd = -endAngle / Math.PI * 180;

                        this.renderer.pieslice(
                            offsetX,
                            offsetY,
                            0, // innerRadius
                            radius,
                            Math.min(aStart, aEnd),
                            Math.max(aStart, aEnd),
                            undefined,
                            strokeAttributes);
                    }
                }

                var cnt = items.length;
                var aIncrement = 2 * Math.PI / (cnt);
                var aIncrementAdj = startAngle;

                // draw x-axis grid lines
                var ptPrev, ptPrevFirst;
                if (gridLinesSettings.visible && showXAxis) {
                    if (!valuesOnTicks && !isClosedCircle) {
                        gridLinesSettings.offsets.unshift({ offset: -padding.right });
                    }

                    for (var i = 0; i < gridLinesSettings.offsets.length; i++) {
                        var offset = gridLinesSettings.offsets[i].offset;
                        if (!valuesOnTicks) {
                            if (isClosedCircle)
                                offset += padding.right / 2;
                            else
                                offset += padding.right;
                        }

                        var angle = aIncrementAdj + offset * 2 * Math.PI * axisSizeRatio / Math.max(1, axisSize);
                        if (angle - endAngle > 0.01)
                            continue;

                        var px = $.jqx._ptrnd(offsetX + radius * Math.cos(angle));
                        var py = $.jqx._ptrnd(offsetY + radius * Math.sin(angle));

                        renderer.line(offsetX, offsetY, px, py, strokeAttributes);
                    }
                }

                // draw tick marks
                if (tickMarksSettings.visible && showXAxis) {
                    var tickMarkSize = 5;

                    var ticksStrokeAttributes = { stroke: tickMarksSettings.color, fill: 'none', 'stroke-width': tickMarksSettings.width, 'stroke-dasharray': tickMarksSettings.dashStyle || '' };
                    if (!valuesOnTicks && !isClosedCircle) {
                        tickMarksSettings.offsets.unshift({ offset: -padding.right });
                    }

                    for (var i = 0; i < tickMarksSettings.offsets.length; i++) {
                        var offset = tickMarksSettings.offsets[i].offset;
                        if (!valuesOnTicks) {
                            if (isClosedCircle)
                                offset += padding.right / 2;
                            else
                                offset += padding.right;
                        }

                        var angle = aIncrementAdj + offset * 2 * Math.PI * axisSizeRatio / Math.max(1, axisSize);
                        if (angle - endAngle > 0.01)
                            continue;

                        var p1 = { x: offsetX + radius * Math.cos(angle), y: offsetY + radius * Math.sin(angle) };
                        var p2 = { x: offsetX + (radius + tickMarkSize) * Math.cos(angle), y: offsetY + (radius + tickMarkSize) * Math.sin(angle) };
                        renderer.line($.jqx._ptrnd(p1.x), $.jqx._ptrnd(p1.y), $.jqx._ptrnd(p2.x), $.jqx._ptrnd(p2.y), ticksStrokeAttributes);
                    }
                }

                var offsetAngles = [];

                // get spider angles
                if (group.spider) {
                    var spiderOffsets = [];
                    if (axis.type == 'date')
                        spiderOffsets = this._generateDTOffsets(min, max, axisSize, padding, ui, ui, axis.baseUnit, true, 0, false, flip);
                    else {
                        spiderOffsets = this._getOffsets('', axis, axisSize, axisStats, axisSettings, padding, true, ui);
                    }

                    if (!valuesOnTicks && !isClosedCircle)
                        spiderOffsets.unshift({ offset: -padding.right });

                    for (var i = 0; i < spiderOffsets.length; i++) {
                        var offset = spiderOffsets[i].offset;
                        if (!valuesOnTicks) {
                            if (isClosedCircle)
                                offset += padding.right / 2;
                            else
                                offset += padding.right;
                        }

                        var angle = aIncrementAdj + offset * 2 * Math.PI * axisSizeRatio / Math.max(1, axisSize);
                        if (angle - endAngle > 0.01)
                            continue;

                        offsetAngles.push(angle);
                    }

                    renderData.offsetAngles = offsetAngles;
                }

                // draw value axis
                var arrRadius = self._renderSpiderValueAxis(groupIndex, rect, (valuesOnTicks ? polarCoords.adjR : polarCoords.r), offsetAngles);
                if (!arrRadius)
                    arrRadius = [];

                // draw the spider lines
                if (group.spider) {
                    if (!valuesOnTicks) {
                        for (var i = 0; i < arrRadius.length; i++)
                            arrRadius[i] = arrRadius[i] * polarCoords.adjR / polarCoords.r;
                    }
                    arrRadius.push(radius);

                    this._renderSpiderLines(offsetX, offsetY, arrRadius, polarCoords, offsetAngles, strokeAttributes);
                }

                // draw text items
                if (showXAxis && labelsSettings.visible) {
                    renderData.polarLabels = [];

                    for (var i = 0; i < items.length; i++) {
                        var offset = items[i].x;
                        var angle = aIncrementAdj + offset * 2 * Math.PI * axisSizeRatio / Math.max(1, axisSize);

                        angle = (360 - angle / (2 * Math.PI) * 360) % 360;
                        if (angle < 0)
                            angle = 360 + angle;

                        var sz = renderer.measureText(items[i].text, 0, { 'class': axisSettings.labels.style });

                        var labelsRadius = (valuesOnTicks ? polarCoords.adjR : polarCoords.r) + (tickMarksSettings.visible ? 7 : 2);

                        var labels = axisSettings.labels;
                        var labelOffset;

                        if (labels.autoRotate) {
                            var pt1 = $.jqx._ptRotate(offsetX - sz.width / 2, offsetY - labelsRadius - sz.height, offsetX, offsetY, -angle / 180 * Math.PI);
                            var pt2 = $.jqx._ptRotate(offsetX + sz.width / 2, offsetY - labelsRadius, offsetX, offsetY, -angle / 180 * Math.PI);

                            sz.width = Math.abs(pt1.x - pt2.x);
                            sz.height = Math.abs(pt1.y - pt2.y);

                            labelOffset = { x: Math.min(pt1.x, pt2.x), y: Math.min(pt1.y, pt2.y) };
                        }
                        else {
                            labelOffset = this._adjustTextBoxPosition(
                                offsetX,
                                offsetY,
                                sz,
                                labelsRadius,
                                angle,
                                false,
                                false,
                                false
                            );
                        }

                        renderData.polarLabels.push({ x: labelOffset.x, y: labelOffset.y, value: items[i].text });

                        renderer.text(
                            items[i].text,
                            labelOffset.x,
                            labelOffset.y,
                            sz.width,
                            sz.height,
                            labels.autoRotate ? 90 - angle : labels.angle,
                            { 'class': labels.style },
                            false,
                            labels.halign,
                            labels.valign);
                    }
                }
            },

            _renderSpiderLines: function (x, y, arrRadius, polarCoords, offsetAngles, strokeAttributes) {
                var renderer = this.renderer;

                var startAngle = polarCoords.startAngle;
                var endAngle = polarCoords.endAngle;
                var isClosedCircle = polarCoords.isClosedCircle;

                for (var j = 0; j < arrRadius.length; j++) {
                    var radius = arrRadius[j];

                    var ptPrev = undefined, ptFirst = undefined;
                    for (var i = 0; i < offsetAngles.length; i++) {
                        var angle = offsetAngles[i];

                        var px = $.jqx._ptrnd(x + radius * Math.cos(angle));
                        var py = $.jqx._ptrnd(y + radius * Math.sin(angle));

                        if (ptPrev)
                            renderer.line(ptPrev.x, ptPrev.y, px, py, strokeAttributes);

                        ptPrev = { x: px, y: py };
                        if (!ptFirst)
                            ptFirst = { x: px, y: py };
                    }

                    if (ptFirst && isClosedCircle)
                        renderer.line(ptPrev.x, ptPrev.y, ptFirst.x, ptFirst.y, strokeAttributes);
                }
            },

            /** @private */
            _renderSpiderValueAxis: function (groupIndex, rect, radius, offsetAngles) {
                var self = this;
                var group = this.seriesGroups[groupIndex];

                var polarCoords = this._getPolarAxisCoords(groupIndex, rect);
                if (!polarCoords)
                    return;

                var offsetX = $.jqx._ptrnd(polarCoords.x);
                var offsetY = $.jqx._ptrnd(polarCoords.y);
                radius = radius || polarCoords.r;
                var startAngle = polarCoords.startAngle;
                var endAngle = polarCoords.endAngle;

                var axisSizeRatio = $.jqx._rnd(Math.abs(startAngle - endAngle) / (Math.PI * 2), 0.001, true);

                if (radius < 1)
                    return;

                radius = $.jqx._ptrnd(radius);

                var valueAxis = this._getValueAxis(groupIndex);
                var settings = this._getAxisSettings(valueAxis);

                if (!valueAxis || false == settings.visible)
                    return;

                var ui = this._stats.seriesGroups[groupIndex].mu;

                var labelsSettings = settings.labels;

                var valueAxisformatSettings = labelsSettings.formatSettings;
                var isStacked100 = group.type.indexOf("stacked") != -1 && group.type.indexOf("100") != -1;
                if (isStacked100 && !valueAxisformatSettings)
                    valueAxisformatSettings = { sufix: '%' };

                var labelsFrequency = this._get([labelsSettings.step, labelsSettings.unitInterval / ui]);
                if (isNaN(labelsFrequency))
                    labelsFrequency = 1;

                labelsFrequency = Math.max(1, Math.round(labelsFrequency));

                this._calcValueAxisItems(groupIndex, radius, labelsFrequency);

                var gridLines = settings.gridLines;
                var tickMarks = settings.tickMarks;

                var gridLinesInterval = this._getInterval(gridLines, ui);
                var tickMarksInterval = this._getInterval(tickMarks, ui);

                var labels = settings.labels;

                var strokeAttributes = { stroke: gridLines.color, fill: 'none', 'stroke-width': 1, 'stroke-dasharray': gridLines.dashStyle || '' };

                // draw value axis text
                var axisRenderData = this._renderData[groupIndex].valueAxis;
                var items = axisRenderData.items;
                var angle = startAngle;
                if (items.length && settings.line.visible) {
                    if (!isNaN(settings.line.angle)) {
                        angle = 2 * Math.PI * settings.line.angle / 360;
                    }

                    var x2 = offsetX + Math.cos(angle) * radius;
                    var y2 = offsetY + Math.sin(angle) * radius;

                    if (offsetAngles.indexOf(angle) == -1) {
                        var lineAttributes = $.extend({}, strokeAttributes);
                        lineAttributes['stroke-width'] = settings.line.lineWidth;
                        lineAttributes['stroke'] = settings.line.color;
                        lineAttributes['stroke-dasharray'] = settings.line.dashStyle;
                        this.renderer.line(offsetX, offsetY, x2, y2, lineAttributes);
                    }
                }

                items = items.reverse();

                var renderer = this.renderer;

                axisRenderData.polarLabels = [];

                for (var i = 0; i < items.length - 1; i++) {
                    var value = items[i];
                    if (isNaN(value))
                        continue;

                    var text = (labels.formatFunction) ? labels.formatFunction(value) : this._formatNumber(value, valueAxisformatSettings);

                    var sz = renderer.measureText(text, 0, { 'class': labels.style });

                    var x = offsetX + (valueAxis.showTickMarks != false ? 3 : 2);
                    var y = offsetY - axisRenderData.itemWidth * i - sz.height / 2;

                    {
                        var pt1 = $.jqx._ptRotate(x, y, offsetX, offsetY, angle);
                        var pt2 = $.jqx._ptRotate(x + sz.width, y + sz.height, offsetX, offsetY, angle);

                        x = Math.min(pt1.x, pt2.x);
                        y = Math.min(pt1.y, pt2.y);

                        sz.width = Math.abs(pt1.x - pt2.x);
                        sz.height = Math.abs(pt1.y - pt2.y);
                    }

                    x += settings.labels.textOffset.x;
                    y += settings.labels.textOffset.y;

                    axisRenderData.polarLabels.push({ x: x, y: y, value: text });

                    renderer.text(
                        text,
                        x,
                        y,
                        sz.width,
                        sz.height,
                        labels.autoRotate ? (90 + startAngle * 180 / Math.PI) : labels.angle,
                        { 'class': labels.style },
                        false,
                        labels.halign,
                        labels.valign
                        //'top','left'
                    );
                }

                var isLogAxis = valueAxis.logarithmicScale == true;

                var len = isLogAxis ? items.length : axisRenderData.rangeLength;
                var aIncrement = 2 * Math.PI / len;

                /////////////////
                var valuesOnTicks = valueAxis.valuesOnTicks != false;
                var gstat = this._stats.seriesGroups[groupIndex];
                var mu = gstat.mu;

                var logAxis = valueAxis.logarithmicScale == true;
                var logBase = valueAxis.logarithmicScaleBase || 10;
                if (logAxis)
                    mu = 1;

                var axisStats = { min: gstat.min, max: gstat.max, logAxis: { enabled: logAxis == true, base: valueAxis.logarithmicScaleBase, minPow: gstat.minPow, maxPow: gstat.maxPow } };

                // draw value axis grid lines
                if (gridLines.visible || group.spider || valueAxis.alternatingBackgroundColor || valueAxis.alternatingBackgroundColor2) {
                    gridLines.offsets = this._getOffsets('gridLines', valueAxis, radius, axisStats, settings, { left: 0, right: 0 }, valuesOnTicks, mu);
                }

                var arrRadius = [];
                if (gridLines.visible || group.spider) {
                    var strokeAttributes = { stroke: gridLines.color, fill: 'none', 'stroke-width': 1, 'stroke-dasharray': gridLines.dashStyle || '' };
                    for (var i = 0; i < gridLines.offsets.length; i++) {
                        var y = $.jqx._ptrnd(gridLines.offsets[i].offset);
                        if (y == radius)
                            continue;

                        if (group.spider) {
                            arrRadius.push(y);
                            continue;
                        }

                        if (axisSizeRatio != 1) {
                            var aStart = -startAngle / Math.PI * 180;
                            var aEnd = -endAngle / Math.PI * 180;

                            this.renderer.pieslice(
                                offsetX,
                                offsetY,
                                0, // innerRadius
                                y,
                                Math.min(aStart, aEnd),
                                Math.max(aStart, aEnd),
                                undefined,
                                strokeAttributes);
                        }
                        else {
                            renderer.circle(offsetX, offsetY, y, strokeAttributes);
                        }
                    }
                }

                if (!valueAxis.tickMarks || (!valueAxis.tickMarks.visible && !valueAxis.showTickMarks))
                    tickMarks.visible = false;

                // draw value axis tick marks
                if (tickMarks.visible) {
                    tickMarks.offsets = this._getOffsets('tickMarks', valueAxis, radius, axisStats, settings, { left: 0, right: 0 }, valuesOnTicks, mu);

                    var tickMarkSize = tickMarks.size * 2;
                    var strokeAttributes = { stroke: tickMarks.color, fill: 'none', 'stroke-width': 1, 'stroke-dasharray': tickMarks.dashStyle || '' };

                    for (var i = 0; i < tickMarks.offsets.length; i++) {
                        var tickMarkRadius = tickMarks.offsets[i].offset;

                        var pt1 = {
                            x: offsetX + tickMarkRadius * Math.cos(angle) - tickMarkSize / 2 * Math.sin(angle + Math.PI / 2),
                            y: offsetY + tickMarkRadius * Math.sin(angle) - tickMarkSize / 2 * Math.cos(angle + Math.PI / 2)
                        };
                        var pt2 = {
                            x: offsetX + tickMarkRadius * Math.cos(angle) + tickMarkSize / 2 * Math.sin(angle + Math.PI / 2),
                            y: offsetY + tickMarkRadius * Math.sin(angle) + tickMarkSize / 2 * Math.cos(angle + Math.PI / 2)
                        };

                        renderer.line($.jqx._ptrnd(pt1.x), $.jqx._ptrnd(pt1.y), $.jqx._ptrnd(pt2.x), $.jqx._ptrnd(pt2.y), strokeAttributes);
                    }
                }

                return arrRadius;
            },

            /** @private */
            _renderAxis: function (isVertical, isMirror, axisSettings, rect, chartRect, ui, isLogAxis, valuesOnTicks, itemsInfo, isMeasure, animationDuration) {
                if (axisSettings.customDraw && !isMeasure)
                    return { width: NaN, height: NaN };

                var titleSettings = axisSettings.title,
                    textSettings = axisSettings.labels,
                    gridLinesSettings = axisSettings.gridLines,
                    tickMarksSettings = axisSettings.tickMarks,
                    axisPadding = axisSettings.padding;

                var tickMarkSize = tickMarksSettings.visible ? tickMarksSettings.size : 0;
                var padding = 2;

                var szMeasure = { width: 0, height: 0 };
                var szMeasureDesc = { width: 0, height: 0 };

                if (isVertical)
                    szMeasure.height = szMeasureDesc.height = rect.height;
                else
                    szMeasure.width = szMeasureDesc.width = rect.width;

                if (!isMeasure && isMirror) {
                    if (isVertical)
                        rect.x -= rect.width;
                }

                var renderData = itemsInfo.renderData;

                var itemWidth = renderData.itemWidth;

                if (titleSettings.visible && titleSettings.text != undefined && titleSettings != '') {
                    var angle = titleSettings.angle;
                    var sz = this.renderer.measureText(titleSettings.text, angle, { 'class': titleSettings.style });
                    szMeasureDesc.width = sz.width;
                    szMeasureDesc.height = sz.height;

                    if (!isMeasure) {
                        this.renderer.text(
                            titleSettings.text,
                            rect.x + titleSettings.offset.x + (isVertical ? (!isMirror ? padding + axisPadding.left : -axisPadding.right - padding + 2 * rect.width - szMeasureDesc.width) : 0),
                            rect.y + titleSettings.offset.y + (!isVertical ? (!isMirror ? rect.height - padding - szMeasureDesc.height - axisPadding.bottom : axisPadding.top + padding) : 0),
                            isVertical ? szMeasureDesc.width : rect.width,
                            !isVertical ? szMeasureDesc.height : rect.height,
                            angle,
                            { 'class': titleSettings.style },
                            true,
                            titleSettings.halign,
                            titleSettings.valign,
                            titleSettings.rotationPoint);
                    }
                }

                var offset = 0;
                var textXAdjust = valuesOnTicks ? -itemWidth / 2 : 0;

                if (valuesOnTicks && !isVertical) {
                    textSettings.halign = 'center';
                }

                var baseX = rect.x;
                var baseY = rect.y;

                var userOffset = textSettings.textOffset;
                if (userOffset) {
                    if (!isNaN(userOffset.x))
                        baseX += userOffset.x;
                    if (!isNaN(userOffset.y))
                        baseY += userOffset.y;
                }

                if (!isVertical) {
                    baseX += textXAdjust;

                    if (isMirror) {
                        baseY += szMeasureDesc.height > 0 ? szMeasureDesc.height + 3 * padding : 2 * padding;
                        baseY += tickMarkSize - (valuesOnTicks ? tickMarkSize : tickMarkSize / 4);
                    }
                    else {
                        baseY += valuesOnTicks ? tickMarkSize : tickMarkSize / 4;
                    }

                    baseY += axisPadding.top;
                }
                else {
                    baseX += axisPadding.left + padding + (szMeasureDesc.width > 0 ? szMeasureDesc.width + padding : 0) + (isMirror ? rect.width - szMeasureDesc.width : 0);
                    baseY += textXAdjust;
                }

                var h = 0;
                var w = 0;

                var items = itemsInfo.items;

                renderData.itemOffsets = {};

                if (this._isToggleRefresh || !this._isUpdate)
                    animationDuration = 0;

                var canAnimate = false;

                var widthSum = 0;

                for (var i = 0; i < items.length && textSettings.visible; i++, offset += itemWidth) {
                    if (!items[i] || isNaN(itemWidth))
                        continue;

                    var text = items[i].text;
                    if (!isNaN(items[i].targetX))
                        offset = items[i].targetX;

                    var sz = this.renderer.measureText(text, textSettings.angle, { 'class': textSettings.style });
                    if (sz.width > w)
                        w = sz.width;
                    if (sz.height > h)
                        h = sz.height;

                    widthSum += isVertical ? h : w;

                    if (!isMeasure) {
                        if ((isVertical && offset > rect.height + 2) || (!isVertical && offset > rect.width + 2))
                            continue;

                        var x = isVertical ? baseX + (isMirror ? (szMeasureDesc.width == 0 ? tickMarkSize : tickMarkSize - padding) : 0) : baseX + offset;
                        var y = isVertical ? baseY + offset : baseY;

                        renderData.itemOffsets[items[i].key] = { x: x, y: y };

                        if (!canAnimate)
                            if (!isNaN(items[i].x) || !isNaN(items[i].y) && animationDuration)
                                canAnimate = true;

                        items[i].targetX = x;
                        items[i].targetY = y;
                        items[i].width = !isVertical ? itemWidth : rect.width - axisPadding.left - axisPadding.right - 2 * padding - tickMarkSize - ((szMeasureDesc.width > 0) ? szMeasureDesc.width + padding : 0);
                        items[i].height = isVertical ? itemWidth : rect.height - axisPadding.top - axisPadding.bottom - 2 * padding - tickMarkSize - ((szMeasureDesc.height > 0) ? szMeasureDesc.height + padding : 0);
                        items[i].visible = true;
                    }
                }

                renderData.avgWidth = items.length == 0 ? 0 : widthSum / items.length;

                if (!isMeasure) {
                    var ctx = { items: items, textSettings: textSettings };
                    if (isNaN(animationDuration) || !canAnimate)
                        animationDuration = 0;

                    this._animateAxisText(ctx, animationDuration == 0 ? 1 : 0);

                    if (animationDuration != 0) {
                        var self = this;
                        this._enqueueAnimation(
                            "series",
                            undefined,
                            undefined,
                            animationDuration,
                            function (element, ctx, percent) {
                                self._animateAxisText(ctx, percent);
                            },
                            ctx);
                    }
                }

                szMeasure.width += 2 * padding + tickMarkSize + szMeasureDesc.width + w + (isVertical && szMeasureDesc.width > 0 ? padding : 0);
                szMeasure.height += 2 * padding + tickMarkSize + szMeasureDesc.height + h + (!isVertical && szMeasureDesc.height > 0 ? padding : 0);

                if (!isVertical)
                    szMeasure.height += axisPadding.top + axisPadding.bottom;
                else
                    szMeasure.width += axisPadding.left + axisPadding.right;

                var gridLinePts = {};

                if (!isMeasure && axisSettings.line.visible) {
                    var lineAttributes = { stroke: axisSettings.line.color, 'stroke-width': axisSettings.line.width, 'stroke-dasharray': axisSettings.line.dashStyle || '' };

                    if (isVertical) {
                        var x = rect.x + rect.width + (isMirror ? axisPadding.left : -axisPadding.right);
                        x = $.jqx._ptrnd(x);
                        this.renderer.line(x, rect.y, x, rect.y + rect.height, lineAttributes);
                    }
                    else {
                        var y = $.jqx._ptrnd(rect.y + (isMirror ? rect.height - axisPadding.bottom : axisPadding.top));

                        this.renderer.line($.jqx._ptrnd(rect.x), y, $.jqx._ptrnd(rect.x + rect.width + 1), y, lineAttributes);
                    }
                }

                szMeasure.width = $.jqx._rup(szMeasure.width);
                szMeasure.height = $.jqx._rup(szMeasure.height);

                return szMeasure;
            },

            _drawPlotAreaLines: function (groupIndex, isValueAxis, itemsToDraw) {
                var g = this.seriesGroups[groupIndex];
                var swapXY = g.orientation != 'horizontal';

                if (!this._renderData || this._renderData.length <= groupIndex)
                    return;

                var key = isValueAxis ? 'valueAxis' : 'xAxis';

                var renderData = this._renderData[groupIndex][key];
                if (!renderData)
                    return;

                var state = this._renderData.axisDrawState;
                if (!state)
                    state = this._renderData.axisDrawState = {};

                var axisKey = '', axis;

                if (isValueAxis) {
                    axisKey = 'valueAxis_' + ((g.valueAxis) ? groupIndex : '') + (swapXY ? 'swap' : '');
                    axis = this._getValueAxis(groupIndex);
                }
                else {
                    axisKey = 'xAxis_' + ((g.xAxis || g.categoryAxis) ? groupIndex : '') + (swapXY ? 'swap' : '');
                    axis = this._getXAxis(groupIndex);
                }

                if (state[axisKey])
                    state = state[axisKey];
                else
                    state = state[axisKey] = {};

                if (!isValueAxis)
                    swapXY = !swapXY;

                var settings = renderData.settings;
                if (!settings)
                    return;

                if (settings.customDraw)
                    return;

                var gridLinesSettings = settings.gridLines,
                    tickMarksSettings = settings.tickMarks,
                    padding = settings.padding;

                var rect = renderData.rect;
                var chartRect = this._plotRect;

                if (!gridLinesSettings || !tickMarksSettings)
                    return;

                var rndErr = 0.5
                var gridLinePts = {};
                var strokeAttributes = { stroke: gridLinesSettings.color, 'stroke-width': gridLinesSettings.width, 'stroke-dasharray': gridLinesSettings.dashStyle || '' };

                // render grid lines & alternate background colors        
                var startOffset = isValueAxis ? rect.y + rect.height : rect.x;
                var offsets = gridLinesSettings.offsets;

                if (isValueAxis && !axis.flip) {
                    offsets = $.extend([], offsets);
                    offsets = offsets.reverse();
                }

                if (offsets && offsets.length > 0) {
                    var prevOffset = NaN;
                    var lenSave = offsets.length;
                    for (var i = 0; i < offsets.length; i++) {
                        if (swapXY) {
                            var lineOffset = $.jqx._ptrnd(rect.y + offsets[i].offset);
                            if (lineOffset < rect.y - rndErr)
                                lineOffset = $.jqx._ptrnd(rect.y);

                            if (lineOffset > rect.y + rect.height)
                                lineOffset = rect.y + rect.height;
                        }
                        else {
                            lineOffset = $.jqx._ptrnd(rect.x + offsets[i].offset);
                            if (lineOffset > rect.x + rect.width + rndErr)
                                lineOffset = $.jqx._ptrnd(rect.x + rect.width);
                        }

                        if (isNaN(lineOffset))
                            continue;

                        if (!isNaN(prevOffset) && Math.abs(lineOffset - prevOffset) < 2)
                            continue;

                        prevOffset = lineOffset;

                        if (itemsToDraw.gridLines && gridLinesSettings.visible != false && state.gridLines != true) {
                            if (swapXY)
                                this.renderer.line($.jqx._ptrnd(chartRect.x), lineOffset, $.jqx._ptrnd(chartRect.x + chartRect.width), lineOffset, strokeAttributes);
                            else
                                this.renderer.line(lineOffset, $.jqx._ptrnd(chartRect.y), lineOffset, $.jqx._ptrnd(chartRect.y + chartRect.height), strokeAttributes);
                        }

                        gridLinePts[lineOffset] = true;

                        if (itemsToDraw.alternatingBackground && (gridLinesSettings.alternatingBackgroundColor || gridLinesSettings.alternatingBackgroundColor2) && state.alternatingBackground != true) {
                            var fillColor = ((i % 2) == 0) ? gridLinesSettings.alternatingBackgroundColor2 : gridLinesSettings.alternatingBackgroundColor;
                            if (i > 0 && fillColor) {
                                var rectElement;
                                if (swapXY)
                                    rectElement = this.renderer.rect($.jqx._ptrnd(chartRect.x), startOffset, $.jqx._ptrnd(chartRect.width - 1), lineOffset - startOffset, strokeAttributes);
                                else
                                    rectElement = this.renderer.rect(startOffset, $.jqx._ptrnd(chartRect.y), lineOffset - startOffset, $.jqx._ptrnd(chartRect.height), strokeAttributes);

                                this.renderer.attr(rectElement, { 'stroke-width': 0, fill: fillColor, opacity: gridLinesSettings.alternatingBackgroundOpacity || 1 });
                            }
                        }

                        startOffset = lineOffset;
                    } // for
                }

                // render axis tick marks
                var strokeAttributes = { stroke: tickMarksSettings.color, 'stroke-width': tickMarksSettings.width, 'stroke-dasharray': tickMarksSettings.dashStyle || '' };

                if (itemsToDraw.tickMarks && tickMarksSettings.visible && state.tickMarks != true) {
                    var tickMarkSize = tickMarksSettings.size;
                    var offsets = tickMarksSettings.offsets;
                    var prevOffset = NaN;
                    for (var i = 0; i < offsets.length; i++) {
                        if (swapXY) {
                            lineOffset = $.jqx._ptrnd(rect.y + offsets[i].offset);
                            if (lineOffset < rect.y - rndErr)
                                lineOffset = $.jqx._ptrnd(rect.y);

                            if (lineOffset > rect.y + rect.height)
                                lineOffset = rect.y + rect.height;
                        }
                        else {
                            lineOffset = $.jqx._ptrnd(rect.x + offsets[i].offset);
                            if (lineOffset > rect.x + rect.width + rndErr)
                                lineOffset = $.jqx._ptrnd(rect.x + rect.width);
                        }

                        if (isNaN(lineOffset))
                            continue;

                        if (!isNaN(prevOffset) && Math.abs(lineOffset - prevOffset) < 2)
                            continue;

                        if (gridLinePts[lineOffset - 1])
                            lineOffset--;
                        else if (gridLinePts[lineOffset + 1])
                            lineOffset++;

                        if (swapXY) {
                            if (lineOffset > rect.y + rect.height + rndErr)
                                break;
                        }
                        else {
                            if (lineOffset > rect.x + rect.width + rndErr)
                                break;
                        }

                        prevOffset = lineOffset;

                        var tickSize = !renderData.isMirror ? -tickMarkSize : tickMarkSize;
                        if (swapXY) {
                            var x = rect.x + rect.width + (axis.position == 'right' ? padding.left : -padding.right);
                            if (!isValueAxis)
                                x = rect.x + (renderData.isMirror ? padding.left : -padding.right + rect.width);

                            this.renderer.line(x, lineOffset, x + tickSize, lineOffset, strokeAttributes);
                        }
                        else {
                            var y = rect.y + (renderData.isMirror ? rect.height : 0);
                            y += renderData.isMirror ? -padding.bottom : padding.top;

                            y = $.jqx._ptrnd(y);
                            this.renderer.line(lineOffset, y, lineOffset, y - tickSize, strokeAttributes);
                        }
                    }
                }

                state.tickMarks = state.tickMarks || itemsToDraw.tickMarks;
                state.gridLines = state.gridLines || itemsToDraw.gridLines;
                state.alternatingBackground = state.alternatingBackground || itemsToDraw.alternatingBackground;
            },

            /** @private */
            _calcValueAxisItems: function (groupIndex, axisLength, labelsFrequency) {
                var gstat = this._stats.seriesGroups[groupIndex];
                if (!gstat || !gstat.isValid) {
                    return false;
                }

                var g = this.seriesGroups[groupIndex];
                var swapXY = g.orientation == 'horizontal';
                var axis = this._getValueAxis(groupIndex);

                var valuesOnTicks = axis.valuesOnTicks != false;
                var field = axis.dataField;
                var ints = gstat.intervals;
                var unitH = axisLength / ints;

                var min = gstat.min;
                var mu = gstat.mu;

                if (mu === 0.1 && min === 0.9 && axis.minValue === 1) {
                    gstat.min = min = 1;
                }

                var logAxis = axis.logarithmicScale == true;
                var logBase = axis.logarithmicScaleBase || 10;
                var isStacked100 = g.type.indexOf("stacked") != -1 && g.type.indexOf("100") != -1;

                if (logAxis)
                    mu = !isNaN(axis.unitInterval) ? axis.unitInterval : 1;

                if (!valuesOnTicks)
                    ints = Math.max(ints - 1, 1);

                while (this._renderData.length < groupIndex + 1)
                    this._renderData.push({});

                this._renderData[groupIndex].valueAxis = {};
                var renderData = this._renderData[groupIndex].valueAxis;

                renderData.itemWidth = renderData.intervalWidth = unitH;
                renderData.items = [];
                var items = renderData.items;

                for (var i = 0; i <= ints; i++) {
                    var value = 0;
                    if (logAxis) {
                        if (isStacked100)
                            value = gstat.max / Math.pow(logBase, ints - i);
                        else
                            value = min * Math.pow(logBase, i);
                    }
                    else {
                        value = valuesOnTicks ? min + i * mu : min + (i + 0.5) * mu;
                    }

                    if (i % labelsFrequency != 0) {
                        items.push(NaN);
                        continue;
                    }

                    items.push(value);
                }

                renderData.rangeLength = logAxis && !isStacked100 ? gstat.intervals : (gstat.intervals) * mu;

                if (axis.flip != true)
                    items = items.reverse();

                return true;
            },

            _getDecimalPlaces: function (arr, key, limit) {
                var decimalPlaces = 0;
                if (isNaN(limit))
                    limit = 10;

                for (var i = 0; i < arr.length; i++) {
                    var value = key === undefined ? arr[i] : arr[i][key];
                    if (isNaN(value))
                        continue;

                    var valueTxt = value.toString();
                    for (var j = 0; j < valueTxt.length; j++) {
                        if (valueTxt[j] < '0' || valueTxt[j] > '9') {
                            decimalPlaces = valueTxt.length - (j + 1);
                            if (decimalPlaces >= 0)
                                return Math.min(decimalPlaces, limit);
                        }
                    }

                    if (decimalPlaces > 0)
                        value *= Math.pow(10, decimalPlaces);

                    while (Math.round(value) != value && decimalPlaces < limit) {
                        decimalPlaces++;
                        value *= 10;
                    }
                }

                return decimalPlaces;
            },

            /** @private */
            _renderValueAxis: function (groupIndex, rect, isMeasure, chartRect) {
                var g = this.seriesGroups[groupIndex];
                var swapXY = g.orientation == 'horizontal';
                var axis = this._getValueAxis(groupIndex);
                if (!axis)
                    throw 'SeriesGroup ' + groupIndex + ' is missing valueAxis definition';

                var szMeasure = { width: 0, height: 0 };

                if (!this._isGroupVisible(groupIndex) || this._isPieOnlySeries() || g.type == 'spider')
                    return szMeasure;

                var valuesOnTicks = axis.valuesOnTicks != false;
                var gstat = this._stats.seriesGroups[groupIndex];
                var mu = gstat.mu;

                var logAxis = axis.logarithmicScale == true;
                var logBase = axis.logarithmicScaleBase || 10;

                if (logAxis)
                    mu = !isNaN(axis.unitInterval) ? axis.unitInterval : 1;

                if (mu == 0)
                    mu = 1;

                if (isNaN(mu))
                    return szMeasure;

                var axisSettings = this._getAxisSettings(axis);
                var titleSettings = axisSettings.title,
                    labelsSettings = axisSettings.labels;

                var labels = axis.labels || {};
                var halign = this._get([axis.horizontalTextAlignment, labels.horizontalAlignment]);
                if (!halign && labelsSettings.angle == 0)
                    labelsSettings.halign = swapXY ? 'center' : (axis.position == 'right' ? 'left' : 'right');

                var labelsFrequency = this._get([labelsSettings.step, labelsSettings.unitInterval / mu]);
                if (isNaN(labelsFrequency))
                    labelsFrequency = 1;

                labelsFrequency = Math.max(1, Math.round(labelsFrequency));

                if (!this._calcValueAxisItems(groupIndex, (swapXY ? rect.width : rect.height), labelsFrequency) || !axisSettings.visible)
                    return szMeasure;

                if (!swapXY) {
                    titleSettings.angle = (!this.rtl ? -90 : 90);
                    if (titleSettings.rotationPoint == 'centercenter') {
                        if (titleSettings.valign == 'top')
                            titleSettings.rotationPoint = 'rightcenter';
                        else if (titleSettings.valign == 'bottom')
                            titleSettings.rotationPoint = 'leftcenter';
                    }
                }

                var renderData = this._renderData[groupIndex].valueAxis;

                var formatSettings = labelsSettings.formatSettings;

                var isStacked100 = g.type.indexOf("stacked") != -1 && g.type.indexOf("100") != -1;
                if (isStacked100 && !formatSettings)
                    formatSettings = { sufix: '%' };

                if (!labelsSettings.formatFunction && (!formatSettings || !formatSettings.decimalPlaces)) {
                    formatSettings = formatSettings || {};
                    formatSettings.decimalPlaces = this._getDecimalPlaces([gstat.min, gstat.max, mu], undefined, 3);
                }

                var gridLines = axisSettings.gridLines;
                var gridLinesInterval = logAxis ? mu : this._getInterval(gridLines, mu);

                var axisSize = swapXY ? rect.width : rect.height;

                var flip = (axis.flip == true);

                // force verse due to y-axis layout
                axis.flip = !flip;

                var axisStats = { min: gstat.min, max: gstat.max, logAxis: { enabled: logAxis == true, base: logBase, minPow: gstat.minPow, maxPow: gstat.maxPow } };

                if (gridLines.visible || axis.alternatingBackgroundColor || axis.alternatingBackgroundColor2) {
                    gridLines.offsets = this._getOffsets('gridLines', axis, axisSize, axisStats, axisSettings, { left: 0, right: 0 }, valuesOnTicks, mu);
                }

                var tickMarks = axisSettings.tickMarks;
                if (tickMarks.visible) {
                    tickMarks.offsets = this._getOffsets('tickMarks', axis, axisSize, axisStats, axisSettings, { left: 0, right: 0 }, valuesOnTicks, mu);
                }

                var labelOffsets = this._getOffsets('labels', axis, axisSize, axisStats, axisSettings, { left: 0, right: 0 }, valuesOnTicks, mu, !valuesOnTicks);

                // restore original value
                axis.flip = flip;

                var items = [];

                var oldPositions;
                if (this._elementRenderInfo && this._elementRenderInfo.length > groupIndex)
                    oldPositions = this._elementRenderInfo[groupIndex].valueAxis;

                for (var i = 0; i < labelOffsets.length; i++) {
                    var value = labelOffsets[i].value;
                    if (isNaN(labelOffsets[i].offset)) {
                        items.push(undefined);
                        continue;
                    }

                    var text = (labelsSettings.formatFunction) ? labelsSettings.formatFunction(value) : (!isNaN(value)) ? this._formatNumber(value, formatSettings) : value;

                    var obj = { key: value, text: text };
                    if (oldPositions && oldPositions.itemOffsets[value]) {
                        obj.x = oldPositions.itemOffsets[value].x;
                        obj.y = oldPositions.itemOffsets[value].y;
                    }

                    obj.targetX = labelOffsets[i].offset;

                    if (!isNaN(obj.targetX))
                        items.push(obj);
                }

                var isMirror = (swapXY && axis.position == 'top') || (!swapXY && axis.position == 'right') || (!swapXY && this.rtl && axis.position != 'left');

                var itemsInfo = { items: items, renderData: renderData };

                var anim = this._getAnimProps(groupIndex);
                var duration = anim.enabled && items.length < 500 ? anim.duration : 0;
                if (this.enableAxisTextAnimation == false)
                    duration = 0;

                renderData.settings = axisSettings;

                renderData.isMirror = isMirror;
                renderData.rect = rect;

                return this._renderAxis(!swapXY, isMirror, axisSettings, rect, chartRect, mu, logAxis, true, itemsInfo, isMeasure, duration);
            },

            _objectsArraysToArray: function (array, key) {
                var out = [];
                if (!$.isArray(array))
                    return out;

                for (var i = 0; i < array.length; i++)
                    out.push(array[i][key]);

                return out;
            },

            _arraysToObjectsArray: function (arrays, keys) {
                var out = [];
                if (arrays.length != keys.length)
                    return out;

                for (var i = 0; i < arrays.length; i++) {
                    for (var j = 0; j < arrays[i].length; j++) {
                        if (out.length <= j)
                            out.push({});

                        out[j][keys[i]] = arrays[i][j];
                    }
                }

                return out;
            },

            _valuesToOffsets: function (values, axis, stats, size, padding, valuesOnTicks, offsetAdj) {
                var out = [];

                if (!axis || !$.isArray(values))
                    return out;

                var logBase = stats.logAxis.base;
                var type = stats.logAxis.enabled ? 'logarithmic' : 'linear';
                var flip = axis.flip;

                var paddedSize = size;
                var leftPadding = 0, rightPadding = 0;
                if (padding && !isNaN(padding.left)) {
                    leftPadding = padding.left;
                }
                if (padding && !isNaN(padding.right)) {
                    rightPadding = padding.right;
                }

                paddedSize = size - leftPadding - rightPadding;
                size = paddedSize; // TODO: values on ticks is not needed as param

                for (var i = 0; i < values.length; i++) {
                    var x = this._jqxPlot.scale(
                        values[i],
                        {
                            min: stats.min.valueOf(),
                            max: stats.max.valueOf(),
                            type: type,
                            base: logBase
                        },
                        {
                            min: 0,
                            max: valuesOnTicks ? size : paddedSize,
                            flip: flip
                        },
                        {
                            //   'ignore_range': true
                        }
                    );

                    if (!isNaN(x)) {
                        if (!isNaN(offsetAdj))
                            x += offsetAdj;

                        if (x <= size + leftPadding + rightPadding + 1)
                            out.push($.jqx._ptrnd(x));
                        else
                            out.push(NaN);
                    }
                    else
                        out.push(NaN);
                }

                return out;
            },


            _generateIntervalValues: function (axisStats, interval, baseInterval, valuesOnTicks, useMidVal) {
                var intervals = [];

                var min = axisStats.min;
                var max = axisStats.max;

                if (axisStats.logAxis && axisStats.logAxis.enabled) {
                    min = axisStats.logAxis.minPow;
                    max = axisStats.logAxis.maxPow;
                }

                if (min == undefined || max == undefined)
                    return intervals;

                if (min == max) {
                    if (axisStats.logAxis && axisStats.logAxis.enabled)
                        return [Math.pow(axisStats.logAxis.base, min)];
                    else
                        return [min];
                }

                var factor = 1;
                if (baseInterval < 1) {
                    // adjust to bigger number to avoid js rounding issues
                    factor = 1000000;
                    min *= factor;
                    max *= factor;
                    baseInterval *= factor;
                }

                for (var i = min; i <= max; i += baseInterval)
                    intervals.push(i / factor + (useMidVal ? baseInterval / 2 : 0));

                if (interval > baseInterval) {
                    var out = [];
                    var ratio = Math.round(interval / baseInterval);
                    for (var i = 0; i < intervals.length; i++)
                        if ((i % ratio) == 0)
                            out.push(intervals[i]);

                    intervals = out;
                }

                if (axisStats.logAxis && axisStats.logAxis.enabled) {
                    for (var i = 0; i < intervals.length; i++)
                        intervals[i] = Math.pow(axisStats.logAxis.base, intervals[i]);
                }

                return intervals;
            },

            /** @private */
            _generateDTOffsets: function (min, max, axisSize, padding, interval, baseInterval, dateTimeUnit, isTicksMode, tickPadding, isValue, flip) {
                if (!dateTimeUnit)
                    dateTimeUnit = 'day';

                var offsets = [];

                if (min > max)
                    return offsets;

                if (min == max) {
                    if (isValue)
                        offsets.push({ offset: isTicksMode ? axisSize / 2 : padding.left, value: min });
                    else if (isTicksMode)
                        offsets.push({ offset: axisSize / 2, value: min });

                    return offsets;
                }

                var paddedSize = axisSize - padding.left - padding.right;

                var curr = min;
                var initialOffset = padding.left;
                var offset = initialOffset;

                baseInterval = Math.max(baseInterval, 1);
                var realInterval = baseInterval;
                var frac = Math.min(1, baseInterval);

                if (baseInterval > 1 && dateTimeUnit != 'millisecond')
                    baseInterval = 1;

                while ($.jqx._ptrnd(offset) <= $.jqx._ptrnd(padding.left + paddedSize + (isTicksMode ? 0 : padding.right))) {
                    offsets.push({ offset: offset, value: curr });

                    var date = new Date(curr.valueOf());

                    if (dateTimeUnit == 'millisecond')
                        date.setMilliseconds(curr.getMilliseconds() + baseInterval);
                    else if (dateTimeUnit == 'second')
                        date.setSeconds(curr.getSeconds() + baseInterval);
                    else if (dateTimeUnit == 'minute')
                        date.setMinutes(curr.getMinutes() + baseInterval);
                    else if (dateTimeUnit == 'hour') {
                        var before = date.valueOf();
                        date.setHours(curr.getHours() + baseInterval);

                        if (before == date.valueOf()) // DST FF bug
                            date.setHours(curr.getHours() + baseInterval + 1);
                    }
                    else if (dateTimeUnit == 'day')
                        date.setDate(curr.getDate() + baseInterval);
                    else if (dateTimeUnit == 'month')
                        date.setMonth(curr.getMonth() + baseInterval);
                    else if (dateTimeUnit == 'year')
                        date.setFullYear(curr.getFullYear() + baseInterval);

                    curr = date;

                    offset = initialOffset + (curr.valueOf() - min.valueOf()) * frac / (max.valueOf() - min.valueOf()) * paddedSize;
                }

                if (flip) {
                    for (var i = 0; i < offsets.length; i++)
                        offsets[i].offset = axisSize - offsets[i].offset;
                }

                if (realInterval > 1 && dateTimeUnit != 'millisecond') {
                    var out = [];
                    for (var i = 0; i < offsets.length; i += realInterval)
                        out.push({ offset: offsets[i].offset, value: offsets[i].value });

                    offsets = out;
                }

                if (!isTicksMode && !isValue && offsets.length > 1) {
                    var out = [];
                    out.push({ offset: 0, value: undefined });
                    for (var i = 1; i < offsets.length; i++) {
                        out.push({ offset: offsets[i - 1].offset + (offsets[i].offset - offsets[i - 1].offset) / 2, value: undefined });
                    }

                    var len = out.length;
                    if (len > 1)
                        out.push({ offset: out[len - 1].offset + (out[len - 1].offset - out[len - 2].offset) });
                    else
                        out.push({ offset: axisSize, value: undefined });

                    offsets = out;
                }

                if (interval > baseInterval) {
                    var out = [];
                    var ratio = Math.round(interval / realInterval);
                    for (var i = 0; i < offsets.length; i++)
                        if ((i % ratio) == 0)
                            out.push({ offset: offsets[i].offset, value: offsets[i].value });

                    offsets = out;
                }

                return offsets;
            },

            _hasStackValueReversal: function (groupIndex, gbase) {
                var group = this.seriesGroups[groupIndex];
                var isStacked = -1 != group.type.indexOf("stacked");
                if (!isStacked)
                    return false;

                var isWaterfall = -1 != group.type.indexOf("waterfall");

                var len = this._getDataLen(groupIndex);

                var waterfallStackSum = 0;
                var stackIntialized = false;

                var seriesVisibility = [];

                for (var j = 0; j < group.series.length; j++)
                    seriesVisibility[j] = this._isSerieVisible(groupIndex, j);

                for (var i = 0; i < len; i++) {
                    var stackBase = (isWaterfall && i != 0) ? waterfallStackSum : gbase;

                    var pSum = 0, nSum = 0;

                    var isDirectionDown = undefined;
                    if (!isWaterfall)
                        stackIntialized = false;

                    for (var sidx = 0; sidx < group.series.length; sidx++) {
                        if (!seriesVisibility[sidx])
                            continue;

                        var val = this._getDataValueAsNumber(i, group.series[sidx].dataField, groupIndex);
                        if (isNaN(val))
                            continue;

                        if (group.series[sidx].summary) {
                            var summary = this._getDataValue(i, group.series[sidx].summary, groupIndex);
                            if (undefined !== summary)
                                continue;
                        }

                        var currDirectionDown = !stackIntialized ? val < gbase : val < 0;
                        stackIntialized = true;

                        if (isDirectionDown == undefined)
                            isDirectionDown = currDirectionDown;

                        if (currDirectionDown != isDirectionDown)
                            return true;

                        isDirectionDown = currDirectionDown;

                        waterfallStackSum += val;
                    }
                }

                return false;
            },

            _getValueAxis: function (groupIndex) {
                var valueAxis = groupIndex == undefined ? this.valueAxis : this.seriesGroups[groupIndex].valueAxis || this.valueAxis;

                if (!valueAxis)
                    valueAxis = this.valueAxis = {};

                return valueAxis;
            },

            /** @private */
            _buildStats: function (rect) {
                var stat = { seriesGroups: [] };
                this._stats = stat;

                for (var gidx = 0; gidx < this.seriesGroups.length; gidx++) {
                    var group = this.seriesGroups[gidx];
                    stat.seriesGroups[gidx] = {};

                    var xAxis = this._getXAxis(gidx);
                    var valueAxis = this._getValueAxis(gidx);

                    var xAxisStats = this._getXAxisStats(gidx, xAxis, (group.orientation != 'horizontal') ? rect.width : rect.height);

                    var grst = stat.seriesGroups[gidx];
                    grst.isValid = true;

                    var valueAxisSize = (group.orientation == 'horizontal') ? rect.width : rect.height;

                    var logAxis = valueAxis.logarithmicScale == true;
                    var logBase = valueAxis.logarithmicScaleBase;
                    if (isNaN(logBase))
                        logBase = 10;

                    var isStacked = -1 != group.type.indexOf("stacked");
                    var isStacked100 = isStacked && -1 != group.type.indexOf("100");
                    var isRange = -1 != group.type.indexOf("range");
                    var isWaterfall = group.type.indexOf('waterfall') != -1;

                    if (isWaterfall && !this._moduleWaterfall)
                        throw "Please include 'jqxchart.waterfall.js'";

                    if (isStacked100) {
                        grst.psums = [];
                        grst.nsums = [];
                    }

                    var gmin = NaN, gmax = NaN;
                    var gsumP = NaN, gsumN = NaN;
                    var gbase = valueAxis ? valueAxis.baselineValue : NaN;
                    if (isNaN(gbase))
                        gbase = logAxis && !isStacked100 ? 1 : 0;

                    var hasStackValueReversal = false;
                    if (gbase != 0 && isStacked) {
                        hasStackValueReversal = this._hasStackValueReversal(gidx, gbase);
                        if (hasStackValueReversal)
                            gbase = 0;
                    }

                    if (isStacked && isWaterfall)
                        hasStackValueReversal = this._hasStackValueReversal(gidx, gbase);

                    var len = this._getDataLen(gidx);
                    var gMaxRange = 0;
                    var minPercent = NaN;

                    var seriesPrevValue = [];
                    if (isWaterfall) {
                        // init series prev value array for waterfall series               
                        for (var sidx = 0; sidx < group.series.length; sidx++)
                            seriesPrevValue.push(NaN);
                    }

                    var prevValueWaterfall = NaN;

                    for (var i = 0; i < len && grst.isValid; i++) {
                        if (xAxis.rangeSelector) {
                            var xAxisValue = xAxis.dataField ? this._getDataValue(i, xAxis.dataField, gidx) : i;
                            if (xAxisValue && xAxisStats.isDateTime)
                                xAxisValue = this._castAsDate(xAxisValue, xAxis.dateFormat);
                            if (xAxisStats.useIndeces)
                                xAxisValue = i;

                            // skip values outside of xAxis min/max
                            if (xAxisValue && (xAxisValue.valueOf() < xAxisStats.min.valueOf() || xAxisValue.valueOf() > xAxisStats.max.valueOf()))
                                continue;
                        }

                        var min = valueAxis.minValue;
                        var max = valueAxis.maxValue;


                        if (/*hasValueAxis && */valueAxis.baselineValue) {
                            if (isNaN(min))
                                min = gbase;
                            else
                                min = Math.min(gbase, min);

                            if (isNaN(max))
                                max = gbase;
                            else
                                max = Math.max(gbase, max);
                        }

                        var sumP = 0, sumN = 0;

                        for (var sidx = 0; group.series && sidx < group.series.length; sidx++) {
                            if (!this._isSerieVisible(gidx, sidx))
                                continue;

                            var val = NaN, valMax = NaN, valMin = NaN;
                            if (group.type.indexOf('candle') != -1 || group.type.indexOf('ohlc') != -1) {
                                var fields = ['Open', 'Low', 'Close', 'High'];
                                for (var j in fields) {
                                    var valField = this._getDataValueAsNumber(i, group.series[sidx]['dataField' + fields[j]], gidx);
                                    if (isNaN(valField))
                                        continue;

                                    valMin = isNaN(valMax) ? valField : Math.min(valMin, valField);
                                    valMax = isNaN(valMax) ? valField : Math.max(valMax, valField);
                                }
                            }
                            else {
                                if (isRange) {
                                    var valFrom = this._getDataValueAsNumber(i, group.series[sidx].dataFieldFrom, gidx);
                                    var valTo = this._getDataValueAsNumber(i, group.series[sidx].dataFieldTo, gidx);

                                    valMax = Math.max(valFrom, valTo);
                                    valMin = Math.min(valFrom, valTo);
                                }
                                else {
                                    val = this._getDataValueAsNumber(i, group.series[sidx].dataField, gidx);

                                    if (isWaterfall) {
                                        if (this._isSummary(gidx, i)) {
                                            var summary = this._getDataValue(i, group.series[sidx].summary, gidx);
                                            if (summary !== undefined)
                                                continue;
                                        }

                                        if (!isStacked) {
                                            if (isNaN(seriesPrevValue[sidx]))
                                                seriesPrevValue[sidx] = val;
                                            else
                                                val += seriesPrevValue[sidx];

                                            seriesPrevValue[sidx] = val;
                                        }
                                        else {
                                            if (!isNaN(prevValueWaterfall))
                                                val += prevValueWaterfall;

                                            prevValueWaterfall = val;
                                        }
                                    }


                                    if (isNaN(val) || (logAxis && val <= 0))
                                        continue;

                                    valMin = valMax = val;
                                }
                            }


                            if ((isNaN(max) || valMax > max) && ((isNaN(valueAxis.maxValue)) ? true : valMax <= valueAxis.maxValue))
                                max = valMax;

                            if ((isNaN(min) || valMin < min) && ((isNaN(valueAxis.minValue)) ? true : valMin >= valueAxis.minValue))
                                min = valMin;

                            if (!isNaN(val) && isStacked && !isWaterfall) {
                                if (val > gbase)
                                    sumP += val;
                                else if (val < gbase)
                                    sumN += val;
                            }
                        } // for sidx

                        // stacked series fit within min-max settings
                        if (!isStacked100) {// && hasValueAxis) {
                            if (!isNaN(valueAxis.maxValue))
                                sumP = Math.min(valueAxis.maxValue, sumP);
                            if (!isNaN(valueAxis.minValue))
                                sumN = Math.max(valueAxis.minValue, sumN);
                        }

                        if (logAxis && isStacked100) {
                            for (var sidx = 0; sidx < group.series.length; sidx++) {
                                if (!this._isSerieVisible(gidx, sidx)) {
                                    minPercent = 0.01;
                                    continue;
                                }

                                var val = this._getDataValueAsNumber(i, group.series[sidx].dataField, gidx);
                                if (isNaN(val) || val <= 0) {
                                    minPercent = 0.01;
                                    continue;
                                }

                                var p = sumP == 0 ? 0 : val / sumP;
                                if (isNaN(minPercent) || p < minPercent)
                                    minPercent = p;
                            }
                        }

                        var range = sumP - sumN;
                        if (gMaxRange < range)
                            gMaxRange = range;

                        if (isStacked100) {
                            grst.psums[i] = sumP;
                            grst.nsums[i] = sumN;
                        }

                        if (max > gmax || isNaN(gmax))
                            gmax = max;
                        if (min < gmin || isNaN(gmin))
                            gmin = min;

                        if (sumP > gsumP || isNaN(gsumP))
                            gsumP = sumP;
                        if (sumN < gsumN || isNaN(gsumN))
                            gsumN = sumN;
                    } // for i

                    if (isStacked100) {
                        gsumP = gsumP == 0 ? 0 : Math.max(gsumP, -gsumN);
                        gsumN = gsumN == 0 ? 0 : Math.min(gsumN, -gsumP);
                    }

                    if (gmin == gmax) {
                        if (!isNaN(valueAxis.minValue) && isNaN(valueAxis.maxValue)) {
                            gmin = valueAxis.minValue;
                            gmax = logAxis ? gmin * logBase : gmin + 1;
                        }
                        else if (isNaN(valueAxis.minValue) && !isNaN(valueAxis.maxValue)) {
                            gmax = valueAxis.maxValue;
                            gmin = logAxis ? gmax / logBase : gmax - 1;
                        }
                    }

                    if (gmin == gmax) {
                        if (gmin == 0) {
                            gmin = -1;
                            gmax = 1;
                        }
                        else if (gmin < 0)
                            gmax = 0;
                        else {
                            if (!logAxis)
                                gmin = 0;
                            else if (gmin == 1) {
                                gmin = gmin / logBase;
                                gmax = gmax * logBase;
                            }
                        }
                    }

                    var groupContext = {
                        gmin: gmin, gmax: gmax, gsumP: gsumP, gsumN: gsumN, gbase: gbase, isLogAxis: logAxis, logBase: logBase,
                        minPercent: minPercent, gMaxRange: gMaxRange, isStacked: isStacked, isStacked100: isStacked100, isWaterfall: isWaterfall,
                        hasStackValueReversal: hasStackValueReversal, valueAxis: valueAxis, valueAxisSize: valueAxisSize
                    };

                    if (groupContext.isStacked) {
                        if (groupContext.gsumN < 0)
                            groupContext.gmin = Math.min(groupContext.gmin, groupContext.gbase + groupContext.gsumN);

                        if (groupContext.gsumP > 0)
                            groupContext.gmax = Math.max(groupContext.gmax, groupContext.gbase + groupContext.gsumP);
                    }

                    grst.context = groupContext;
                } // for gidx


                this._mergeCommonValueAxisStats();
                for (var i = 0; i < stat.seriesGroups.length; i++) {
                    var grst = stat.seriesGroups[i];
                    if (!grst.isValid)
                        continue;

                    var out = this._calcOutputGroupStats(grst.context);
                    for (var j in out)
                        grst[j] = out[j];

                    delete grst.context;
                }
            },

            _mergeCommonValueAxisStats: function () {
                var common = {};
                for (var i = 0; i < this.seriesGroups.length; i++) {
                    if (!this._isGroupVisible(i))
                        continue

                    if (this.seriesGroups[i].valueAxis)
                        continue;

                    var stats = this._stats.seriesGroups[i].context;
                    common.gbase = stats.gbase;

                    if (isNaN(common.gmin) || stats.gmin < common.gmin)
                        common.gmin = stats.gmin;

                    if (isNaN(common.gmax) || stats.gmax > common.gmax)
                        common.gmax = stats.gmax;

                    if (isNaN(common.gsumP) || stats.gsumP > common.gsumP)
                        common.gsumP = stats.gsumP;

                    if (isNaN(common.gsumN) || stats.gsumN < common.gsumN)
                        common.gsumN = stats.gsumN;

                    if (isNaN(common.logBase) || stats.logBase < common.logBase)
                        common.logBase = stats.logBase;

                    if (isNaN(common.minPercent) || stats.minPercent < common.minPercent)
                        common.minPercent = stats.minPercent;

                    if (common.gsumN > 0)
                        common.gmin = Math.min(common.gmin, common.gbase + common.gsumN);

                    if (common.gsumP > 0)
                        common.gmax = Math.max(common.gmax, common.gbase + common.gsumP);
                }

                for (var i = 0; i < this.seriesGroups.length; i++) {
                    if (this.seriesGroups[i].valueAxis)
                        continue;

                    var ctx = this._stats.seriesGroups[i].context;
                    for (var j in common)
                        ctx[j] = common[j];
                }

            },


            _calcOutputGroupStats: function (context) {
                var gmin = context.gmin,
                    gmax = context.gmax,
                    gsumP = context.gsumP,
                    gsumN = context.gsumN,
                    gbase = context.gbase,
                    logAxis = context.isLogAxis,
                    logBase = context.logBase,
                    minPercent = context.minPercent,
                    gMaxRange = context.gMaxRange,
                    isStacked = context.isStacked,
                    isStacked100 = context.isStacked100,
                    isWaterfall = context.isWaterfall,
                    hasStackValueReversal = context.hasStackValueReversal,
                    valueAxis = context.valueAxis,
                    valueAxisSize = context.valueAxisSize;

                /// interval calculation
                var mu = context.valueAxis.unitInterval;
                if (!mu) {
                    mu = this._calcInterval(
                        gmin,
                        gmax,
                        Math.max(valueAxisSize / 80, 2));
                }

                if (gmin == gmax) {
                    gmin = gbase;
                    gmax = 2 * gmax;
                }

                var intervals = NaN;

                // log axis scale
                var minPow = 0;
                var maxPow = 0;
                if (logAxis) {
                    if (isStacked100) {
                        intervals = 0;
                        var p = 1;
                        minPow = maxPow = $.jqx.log(100, logBase);

                        while (p > minPercent) {
                            p /= logBase;
                            minPow--;
                            intervals++;
                        }

                        gmin = Math.pow(logBase, minPow);

                    }
                    else {
                        if (isStacked && !isWaterfall)
                            gmax = Math.max(gmax, gsumP);

                        maxPow = $.jqx._rnd($.jqx.log(gmax, logBase), 1, true);
                        gmax = Math.pow(logBase, maxPow);

                        minPow = $.jqx._rnd($.jqx.log(gmin, logBase), 1, false);
                        gmin = Math.pow(logBase, minPow);
                    }

                    mu = logBase;
                } // if logAxis

                if (gmin < gsumN)
                    gsumN = gmin;

                if (gmax > gsumP)
                    gsumP = gmax;

                var mn = gmin;
                var mx = gmax;
                if (!logAxis) {
                    if (0 != Math.abs(mx - mn) % mu) {
                        mn = $.jqx._rnd(gmin, mu, false);
                        mx = $.jqx._rnd(gmax, mu, true);
                    }
                }



                if (isStacked100 && mx > 100)
                    mx = 100;

                if (isStacked100 && !logAxis) {
                    mx = (mx > 0) ? 100 : 0;
                    mn = (mn < 0) ? -100 : 0;
                    mu = valueAxis.unitInterval;
                    if (isNaN(mu) || mu <= 0 || mu >= 100)
                        mu = 10;

                    if ((100 % mu) != 0) {
                        // ensure devision without reminder
                        for (; mu >= 1; mu--)
                            if ((100 % mu) == 0)
                                break;
                    }
                }

                if (isNaN(mx) || isNaN(mn) || isNaN(mu))
                    return {};

                if (isNaN(intervals)) {
                    intervals = parseInt(((mx - mn) / (mu == 0 ? 1 : mu)).toFixed());
                }

                if (logAxis && !isStacked100) {
                    intervals = maxPow - minPow;
                    gMaxRange = Math.pow(logBase, intervals);
                }

                if (intervals < 1)
                    return {};

                var result = {
                    min: mn,
                    max: mx,
                    logarithmic: logAxis,
                    logBase: logBase,
                    base: logAxis ? mn : gbase,
                    minPow: minPow,
                    maxPow: maxPow,
                    sumP: gsumP,
                    sumN: gsumN,
                    mu: mu,
                    maxRange: gMaxRange,
                    intervals: intervals,
                    hasStackValueReversal: hasStackValueReversal
                };

                return result;
            },


            /** @private */
            _getDataLen: function (groupIndex) {
                var ds = this.source;
                if (groupIndex != undefined && groupIndex != -1 && this.seriesGroups[groupIndex].source)
                    ds = this.seriesGroups[groupIndex].source;

                if (ds instanceof $.jqx.dataAdapter)
                    ds = ds.records;

                if (ds)
                    return ds.length;

                return 0;
            },

            /** @private */
            _getDataValue: function (index, dataField, groupIndex) {
                var ds = this.source;
                if (groupIndex != undefined && groupIndex != -1)
                    ds = this.seriesGroups[groupIndex].source || ds;

                if (ds instanceof $.jqx.dataAdapter)
                    ds = ds.records;

                if (!ds || index < 0 || index > ds.length - 1)
                    return undefined;

                if ($.isFunction(dataField))
                    return dataField(index, ds);

                return (dataField && dataField != '') ? ds[index][dataField] : ds[index];
            },

            /** @private */
            _getDataValueAsNumber: function (index, dataField, groupIndex) {
                var val = this._getDataValue(index, dataField, groupIndex);
                if (this._isDate(val))
                    return val.valueOf();

                if (typeof (val) != 'number')
                    val = parseFloat(val);
                if (typeof (val) != 'number')
                    val = undefined;

                return val;
            },

            _isPieGroup: function (groupIndex) {
                var group = this.seriesGroups[groupIndex];
                if (!group || !group.type)
                    return false;

                return group.type.indexOf('pie') != -1 || group.type.indexOf('donut') != -1;
            },

            /** @private */
            _renderPieSeries: function (groupIndex, rect) {
                var dataLength = this._getDataLen(groupIndex);
                var group = this.seriesGroups[groupIndex];

                var renderData = this._calcGroupOffsets(groupIndex, rect).offsets;

                for (var sidx = 0; sidx < group.series.length; sidx++) {
                    var s = group.series[sidx];

                    if (s.customDraw)
                        continue;

                    var settings = this._getSerieSettings(groupIndex, sidx);

                    var colorScheme = s.colorScheme || group.colorScheme || this.colorScheme;

                    var anim = this._getAnimProps(groupIndex, sidx);
                    var duration = anim.enabled && dataLength < 5000 && !this._isToggleRefresh && this._isVML != true ? anim.duration : 0;
                    if ($.jqx.mobile.isMobileBrowser() && (this.renderer instanceof $.jqx.HTML5Renderer))
                        duration = 0;

                    var minAngle = this._get([s.minAngle, s.startAngle]);
                    if (isNaN(minAngle) || minAngle < 0 || minAngle > 360)
                        minAngle = 0;
                    var maxAngle = this._get([s.maxAngle, s.endAngle]);
                    if (isNaN(maxAngle) || maxAngle < 0 || maxAngle > 360)
                        maxAngle = 360;

                    var ctx = { rect: rect, minAngle: minAngle, maxAngle: maxAngle, groupIndex: groupIndex, serieIndex: sidx, settings: settings, items: [] };

                    // render
                    for (var i = 0; i < dataLength; i++) {
                        var itemRenderData = renderData[sidx][i];
                        if (!itemRenderData.visible)
                            continue;

                        var from = itemRenderData.fromAngle;
                        var to = Math.round(itemRenderData.toAngle);

                        var pieSliceElement = this.renderer.pieslice(
                            itemRenderData.x,
                            itemRenderData.y,
                            itemRenderData.innerRadius,
                            itemRenderData.outerRadius,
                            from,
                            duration == 0 ? to : from,
                            itemRenderData.centerOffset);

                        this._setRenderInfo(groupIndex, sidx, i, { element: pieSliceElement });

                        var ctxItem = {
                            displayValue: itemRenderData.displayValue,
                            itemIndex: i,
                            visible: itemRenderData.visible,
                            x: itemRenderData.x,
                            y: itemRenderData.y,
                            innerRadius: itemRenderData.innerRadius,
                            outerRadius: itemRenderData.outerRadius,
                            fromAngle: from,
                            toAngle: to,
                            centerOffset: itemRenderData.centerOffset
                        };

                        ctx.items.push(ctxItem);
                    } // for i

                    this._animatePieSlices(ctx, 0);
                    var self = this;
                    this._enqueueAnimation(
                        "series",
                        undefined,
                        undefined,
                        duration,
                        function (element, ctx, percent) {
                            self._animatePieSlices(ctx, percent);
                        },
                        ctx);
                }
            },

            /** @private */
            _sliceSortFunction: function (a, b) {
                return a.fromAngle - b.fromAngle;
            },

            /** @private */
            _animatePieSlices: function (ctx, percent) {
                var renderInfo;
                if (this._elementRenderInfo &&
                    this._elementRenderInfo.length > ctx.groupIndex &&
                    this._elementRenderInfo[ctx.groupIndex].series &&
                    this._elementRenderInfo[ctx.groupIndex].series.length > ctx.serieIndex) {
                    renderInfo = this._elementRenderInfo[ctx.groupIndex].series[ctx.serieIndex];
                }

                var animMaxAngle = 360 * percent;
                var g = this.seriesGroups[ctx.groupIndex];
                var labelsSettings = this._getLabelsSettings(ctx.groupIndex, ctx.serieIndex, NaN);
                var showLabels = labelsSettings.visible;

                var arr = [];
                for (var i = 0; i < ctx.items.length; i++) {
                    var item = ctx.items[i];

                    // render the slice
                    if (!item.visible)
                        continue;

                    var fromAngle = item.fromAngle;
                    var toAngle = item.fromAngle + percent * (item.toAngle - item.fromAngle);

                    if (renderInfo && renderInfo[item.displayValue]) {
                        var oldFromAngle = renderInfo[item.displayValue].fromAngle;
                        var oldToAngle = renderInfo[item.displayValue].toAngle;

                        fromAngle = oldFromAngle + (fromAngle - oldFromAngle) * percent;
                        toAngle = oldToAngle + (toAngle - oldToAngle) * percent;
                    }

                    arr.push({ index: i, from: fromAngle, to: toAngle });
                }

                if (renderInfo)
                    arr.sort(this._sliceSortFunction);

                var prevToAngle = NaN;
                for (var i = 0; i < arr.length; i++) {
                    var item = ctx.items[arr[i].index];

                    var elementRenderInfo = this._getRenderInfo(ctx.groupIndex, ctx.serieIndex, item.itemIndex);

                    var fromAngle = arr[i].from;
                    var toAngle = arr[i].to;

                    if (renderInfo) {
                        if (!isNaN(prevToAngle) && fromAngle > prevToAngle)
                            fromAngle = prevToAngle;

                        prevToAngle = toAngle;
                        if (i == arr.length - 1 && toAngle != arr[0].from)
                            toAngle = ctx.maxAngle + arr[0].from;
                    }

                    var cmd = this.renderer.pieSlicePath(item.x, item.y, item.innerRadius, item.outerRadius, fromAngle, toAngle, item.centerOffset);
                    this.renderer.attr(elementRenderInfo.element, { 'd': cmd });

                    var colors = this._getColors(ctx.groupIndex, ctx.serieIndex, item.itemIndex, 'radialGradient', item.outerRadius);
                    var settings = ctx.settings;

                    elementRenderInfo.colors = colors;
                    elementRenderInfo.settings = settings;

                    this.renderer.attr(
                        elementRenderInfo.element,
                        {
                            fill: colors.fillColor,
                            stroke: colors.lineColor,
                            'stroke-width': settings.stroke,
                            'fill-opacity': settings.opacity,
                            'stroke-opacity': settings.opacity,
                            'stroke-dasharray': 'none' || 0
                        });

                    var s = g.series[ctx.serieIndex];

                    // Label rendering                
                    if (showLabels) {
                        this._showPieLabel(ctx.groupIndex, ctx.serieIndex, item.itemIndex, labelsSettings);
                    }

                    // Install mouse event handlers
                    if (percent == 1.0) {
                        this._installHandlers(elementRenderInfo.element, 'pieslice', ctx.groupIndex, ctx.serieIndex, item.itemIndex);
                    }
                }
            },

            _showPieLabel: function (groupIndex, serieIndex, itemIndex, labelsSettings, radiusAdjustment) {
                var renderInfo = this._renderData[groupIndex].offsets[serieIndex][itemIndex];

                // remove lablel element if exists
                if (renderInfo.elementInfo.labelElement)
                    this.renderer.removeElement(renderInfo.elementInfo.labelElement);

                if (!labelsSettings)
                    labelsSettings = this._getLabelsSettings(groupIndex, serieIndex, NaN);

                if (!labelsSettings.visible)
                    return;

                var angleFrom = renderInfo.fromAngle, angleTo = renderInfo.toAngle;
                var diff = Math.abs(angleFrom - angleTo);
                var lFlag = diff > 180 ? 1 : 0;
                if (diff > 360) {
                    angleFrom = 0;
                    angleTo = 360;
                }

                var radFrom = angleFrom * Math.PI * 2 / 360;
                var radTo = angleTo * Math.PI * 2 / 360;
                var midAngle = diff / 2 + angleFrom;

                midAngle = midAngle % 360;
                var radMid = midAngle * Math.PI * 2 / 360;

                var labelAngleOverride;
                if (labelsSettings.autoRotate == true)
                    labelAngleOverride = midAngle < 90 || midAngle > 270 ? 360 - midAngle : 180 - midAngle;

                var labelLinesEnabled = labelsSettings.linesEnabled;

                // measure
                var sz = this._showLabel(groupIndex, serieIndex, itemIndex, { x: 0, y: 0, width: 0, height: 0 }, 'center', 'center', true, false, false, labelAngleOverride);
                var labelRadius = labelsSettings.radius || renderInfo.outerRadius + Math.max(sz.width, sz.height);
                if (this._isPercent(labelRadius))
                    labelRadius = parseFloat(labelRadius) / 100 * Math.min(this._plotRect.width, this._plotRect.height) / 2;

                labelRadius += renderInfo.centerOffset;

                if (isNaN(radiusAdjustment))
                    radiusAdjustment = 0;

                labelRadius += radiusAdjustment;

                var g = this.seriesGroups[groupIndex];
                var s = g.series[serieIndex];

                var offsetX = $.jqx.getNum([s.offsetX, g.offsetX, this._plotRect.width / 2]);
                var offsetY = $.jqx.getNum([s.offsetY, g.offsetY, this._plotRect.height / 2]);

                var cx = this._plotRect.x + offsetX;
                var cy = this._plotRect.y + offsetY;

                var labelOffset = this._adjustTextBoxPosition(
                    cx,
                    cy,
                    sz,
                    labelRadius,
                    midAngle,
                    renderInfo.outerRadius > labelRadius,
                    labelsSettings.linesAngles != false,
                    labelsSettings.autoRotate == true);

                var renderedRect = {};

                renderInfo.elementInfo.labelElement = this._showLabel(
                    groupIndex,
                    serieIndex,
                    itemIndex,
                    { x: labelOffset.x, y: labelOffset.y, width: sz.width, height: sz.height },
                    'left',
                    'top',
                    false,
                    false,
                    false,
                    labelAngleOverride,
                    renderedRect);

                if (labelRadius > renderInfo.outerRadius + 5 && labelLinesEnabled != false) {
                    var lineSettings = {
                        lineColor: renderInfo.elementInfo.colors.lineColor,
                        stroke: renderInfo.elementInfo.settings.stroke,
                        opacity: renderInfo.elementInfo.settings.opacity,
                        dashStyle: renderInfo.elementInfo.settings.dashStyle
                    };

                    renderInfo.elementInfo.labelArrowPath = this._updateLebelArrowPath(
                        renderInfo.elementInfo.labelArrowPath,
                        cx,
                        cy,
                        labelRadius,
                        renderInfo.outerRadius + radiusAdjustment,
                        radMid,
                        labelsSettings.linesAngles != false,
                        lineSettings,
                        renderedRect);
                }
            },

            _updateLebelArrowPath: function (pathElement, cx, cy, labelRadius, outerRadius, angle, useLineAngles, lineSettings, renderedRect) {
                var x1 = $.jqx._ptrnd(cx + (labelRadius - 0) * Math.cos(angle));
                var y1 = $.jqx._ptrnd(cy - (labelRadius - 0) * Math.sin(angle));
                var x2 = $.jqx._ptrnd(cx + (outerRadius + 2) * Math.cos(angle));
                var y2 = $.jqx._ptrnd(cy - (outerRadius + 2) * Math.sin(angle));

                // sort the points of possible connections to the label rect by distance to center
                var points = [];
                points.push({ x: renderedRect.x + renderedRect.width / 2, y: renderedRect.y });
                points.push({ x: renderedRect.x + renderedRect.width / 2, y: renderedRect.y + renderedRect.height });
                points.push({ x: renderedRect.x, y: renderedRect.y + renderedRect.height / 2 });
                points.push({ x: renderedRect.x + renderedRect.width, y: renderedRect.y + renderedRect.height / 2 });

                if (!useLineAngles) {
                    // include corner points
                    points.push({ x: renderedRect.x, y: renderedRect.y });
                    points.push({ x: renderedRect.x + renderedRect.width, y: renderedRect.y });
                    points.push({ x: renderedRect.x + renderedRect.width, y: renderedRect.y + renderedRect.height });
                    points.push({ x: renderedRect.x, y: renderedRect.y + renderedRect.height });
                }

                points = points.sort(function (a, b) { return $.jqx._ptdist(a.x, a.y, cx, cy) - $.jqx._ptdist(b.x, b.y, cx, cy); });
                points = points.sort(function (a, b) { return (Math.abs(a.x - cx) + Math.abs(a.y - cy)) - (Math.abs(b.x - cx) + Math.abs(b.y - cy)); });

                for (var i = 0; i < points.length; i++) {
                    points[i].x = $.jqx._ptrnd(points[i].x);
                    points[i].y = $.jqx._ptrnd(points[i].y);
                }

                // get the best point of the closest corners
                x1 = points[0].x;
                y1 = points[0].y;

                var path = 'M ' + x1 + ',' + y1 + ' L' + x2 + ',' + y2;
                if (useLineAngles) {
                    path = 'M ' + x1 + ',' + y1 + ' L' + x2 + ',' + y1 + ' L' + x2 + ',' + y2;
                }

                if (pathElement)
                    this.renderer.attr(pathElement, { 'd': path });
                else
                    pathElement = this.renderer.path(path, {});

                this.renderer.attr(
                    pathElement,
                    {
                        fill: 'none',
                        stroke: lineSettings.lineColor,
                        'stroke-width': lineSettings.stroke,
                        'stroke-opacity': lineSettings.opacity,
                        'stroke-dasharray': 'none' || 0
                    });

                return pathElement;
            },

            _adjustTextBoxPosition: function (cx, cy, sz, labelRadius, angle, adjustToCenter, labelLinesAngles, labelsAutoRotate) {
                var angleInRad = angle * Math.PI * 2 / 360;

                var x = $.jqx._ptrnd(cx + labelRadius * Math.cos(angleInRad));
                var y = $.jqx._ptrnd(cy - labelRadius * Math.sin(angleInRad));

                if (labelsAutoRotate) {
                    var w = sz.width;
                    var h = sz.height;

                    var b = Math.atan(h / w) % (Math.PI * 2);
                    var a = angleInRad % (Math.PI * 2);

                    var cX = 0, cY = 0;

                    var radiusCorrection = 0;
                    if (a <= b) {
                        radiusCorrection = w / 2 * Math.cos(angleInRad);
                    }
                    else if (a >= b && a < Math.PI - b) {
                        radiusCorrection = (h / 2) * Math.sin(angleInRad);
                    }
                    else if (a >= Math.PI - b && a < Math.PI + b) {
                        radiusCorrection = w / 2 * Math.cos(angleInRad);
                    }
                    else if (a >= Math.PI + b && a < 2 * Math.PI - b) {
                        radiusCorrection = h / 2 * Math.sin(angleInRad);
                    }
                    else if (a >= 2 * Math.PI - b && a < 2 * Math.PI) {
                        radiusCorrection = w / 2 * Math.cos(angleInRad);
                    }

                    labelRadius += Math.abs(radiusCorrection) + 3;

                    var x = $.jqx._ptrnd(cx + labelRadius * Math.cos(angleInRad));
                    var y = $.jqx._ptrnd(cy - labelRadius * Math.sin(angleInRad));

                    x -= sz.width / 2;
                    y -= sz.height / 2;

                    return { x: x, y: y };
                }

                if (!adjustToCenter) {
                    if (!labelLinesAngles) {
                        //0 -  45 && 315-360: left, middle
                        //45 - 135: center, bottom
                        //135 - 225: right, middle
                        //225 - 315: center, top
                        if (angle >= 0 && angle < 45 || angle >= 315 && angle < 360)
                            y -= sz.height / 2;
                        else if (angle >= 45 && angle < 135) {
                            y -= sz.height;
                            x -= sz.width / 2;
                        }
                        else if (angle >= 135 && angle < 225) {
                            y -= sz.height / 2;
                            x -= sz.width;
                        }
                        else if (angle >= 225 && angle < 315) {
                            x -= sz.width / 2;
                        }
                    }
                    else {
                        //90 -  270: right, middle
                        //0 - 90, 270 - 360: left, middle
                        if (angle >= 90 && angle < 270) {
                            y -= sz.height / 2;
                            x -= sz.width;
                        }
                        else {
                            y -= sz.height / 2;
                        }

                    }
                }
                else {
                    x -= sz.width / 2;
                    y -= sz.height / 2;
                }

                return { x: x, y: y };
            },

            _isColumnType: function (type) {
                return (type.indexOf('column') != -1 || type.indexOf('waterfall') != -1);
            },

            /** @private */
            _getColumnGroupsCount: function (orientation) {
                var cnt = 0;
                orientation = orientation || 'vertical';
                var sg = this.seriesGroups;
                for (var i = 0; i < sg.length; i++) {
                    var groupOrientation = sg[i].orientation || 'vertical';
                    if (this._isColumnType(sg[i].type) && groupOrientation == orientation)
                        cnt++;
                }

                if (this.columnSeriesOverlap)
                    cnt = 1;

                return cnt;
            },

            /** @private */
            _getColumnGroupIndex: function (groupIndex) {
                var idx = 0;
                var orientation = this.seriesGroups[groupIndex].orientation || 'vertical';
                for (var i = 0; i < groupIndex; i++) {
                    var sg = this.seriesGroups[i];
                    var sgOrientation = sg.orientation || 'vertical';
                    if (this._isColumnType(sg.type) && sgOrientation == orientation)
                        idx++;
                }

                return idx;
            },

            _renderAxisBands: function (groupIndex, rect, isXAxis) {
                var axis = isXAxis ? this._getXAxis(groupIndex) : this._getValueAxis(groupIndex);
                var group = this.seriesGroups[groupIndex];
                var bands = isXAxis ? undefined : group.bands;

                if (!bands) {
                    for (var i = 0; i < groupIndex; i++) {
                        var compareAxis = isXAxis ? this._getXAxis(i) : this._getValueAxis(i)
                        if (compareAxis == axis)
                            return; // axis already rendered in earlier group
                    }

                    bands = axis.bands;
                }

                if (!$.isArray(bands))
                    return;

                var gRect = rect;

                var swapXY = group.orientation == 'horizontal';
                if (swapXY)
                    gRect = { x: rect.y, y: rect.x, width: rect.height, height: rect.width };

                this._calcGroupOffsets(groupIndex, gRect);

                for (var i = 0; i < bands.length; i++) {
                    var band = bands[i];

                    var valFrom = this._get([band.minValue, band.from]);
                    var valTo = this._get([band.maxValue, band.to]);

                    var from = isXAxis ? this.getXAxisDataPointOffset(valFrom, groupIndex) : this.getValueAxisDataPointOffset(valFrom, groupIndex);
                    var to = isXAxis ? this.getXAxisDataPointOffset(valTo, groupIndex) : this.getValueAxisDataPointOffset(valTo, groupIndex);

                    if (isNaN(from) || isNaN(to))
                        continue;

                    var diff = Math.abs(from - to);

                    var bandElement;

                    if (group.polar || group.spider) {
                        var renderData = this._renderData[groupIndex];
                        var polarAxisCoords = renderData.polarCoords;

                        if (!isXAxis) {
                            var pt0 = this._toPolarCoord(polarAxisCoords, rect, rect.x, renderData.baseOffset);
                            var pt1 = this._toPolarCoord(polarAxisCoords, rect, rect.x, from);
                            var pt2 = this._toPolarCoord(polarAxisCoords, rect, rect.x, to);

                            var r0 = $.jqx._ptdist(pt0.x, pt0.y, pt1.x, pt1.y);
                            var r1 = $.jqx._ptdist(pt0.x, pt0.y, pt2.x, pt2.y);

                            var startAngle = Math.round(-polarAxisCoords.startAngle * 360 / (2 * Math.PI));
                            var endAngle = Math.round(-polarAxisCoords.endAngle * 360 / (2 * Math.PI));

                            if (startAngle > endAngle) {
                                var tmp = startAngle;
                                startAngle = endAngle;
                                endAngle = tmp;
                            }

                            if (group.spider) {
                                var offsetAngles = renderData.xAxis.offsetAngles;
                                var path = '';
                                var rArr = [r1, r0];

                                var angles = offsetAngles;
                                if (polarAxisCoords.isClosedCircle) {
                                    angles = $.extend([], offsetAngles);
                                    angles.push(angles[0]);
                                }

                                for (var k in rArr) {
                                    for (var j = 0; j < angles.length; j++) {
                                        var idx = k == 0 ? j : offsetAngles.length - j - 1;
                                        var px = polarAxisCoords.x + rArr[k] * Math.cos(angles[idx]);
                                        var py = polarAxisCoords.y + rArr[k] * Math.sin(angles[idx]);

                                        if (path == '')
                                            path += 'M ';
                                        else
                                            path += ' L';

                                        path += $.jqx._ptrnd(px) + ',' + $.jqx._ptrnd(py);
                                    }

                                    if (k == 0) {
                                        var px = polarAxisCoords.x + rArr[1] * Math.cos(angles[idx]);
                                        var py = polarAxisCoords.y + rArr[1] * Math.sin(angles[idx]);

                                        path += ' L' + $.jqx._ptrnd(px) + ',' + $.jqx._ptrnd(py);
                                    }
                                }

                                path += ' Z';

                                bandElement = this.renderer.path(path);
                            }
                            else {
                                bandElement = this.renderer.pieslice(
                                    polarAxisCoords.x,
                                    polarAxisCoords.y,
                                    r0, // innerRadius
                                    r1, // outerRadius
                                    startAngle,
                                    endAngle);
                            }
                        }
                        else {
                            if (group.spider) {
                                var p1 = this.getPolarDataPointOffset(valFrom, this._stats.seriesGroups[groupIndex].max, groupIndex);
                                var p2 = this.getPolarDataPointOffset(valTo, this._stats.seriesGroups[groupIndex].max, groupIndex);

                                var path = 'M ' + polarAxisCoords.x + ',' + polarAxisCoords.y;
                                path += ' L ' + p1.x + ',' + p1.y;
                                path += ' L ' + p2.x + ',' + p2.y;

                                bandElement = this.renderer.path(path);
                            }
                            else {
                                var elementInfo = {};
                                var columnRect = { x: Math.min(from, to), y: rect.y, width: diff, height: rect.height };

                                this._columnAsPieSlice(elementInfo, rect, polarAxisCoords, columnRect);
                                bandElement = elementInfo.element;
                            }
                        }
                    }
                    else {
                        var elRect = { x: Math.min(from, to), y: gRect.y, width: diff, height: gRect.height };
                        if (!isXAxis)
                            elRect = { x: gRect.x, y: Math.min(from, to), width: gRect.width, height: diff };

                        if (swapXY) {
                            var tmp = elRect.x;
                            elRect.x = elRect.y;
                            elRect.y = tmp;

                            tmp = elRect.width;
                            elRect.width = elRect.height;
                            elRect.height = tmp;
                        }

                        if (diff == 0 || diff == 1) {
                            bandElement = this.renderer.line(
                                $.jqx._ptrnd(elRect.x),
                                $.jqx._ptrnd(elRect.y),
                                $.jqx._ptrnd(elRect.x + (swapXY ? 0 : elRect.width)),
                                $.jqx._ptrnd(elRect.y + (swapXY ? elRect.height : 0))
                            );
                        }
                        else
                            bandElement = this.renderer.rect(elRect.x, elRect.y, elRect.width, elRect.height);
                    }

                    var fillColor = band.fillColor || band.color || '#AAAAAA';
                    var lineColor = band.lineColor || fillColor;
                    var lineWidth = band.lineWidth;
                    if (isNaN(lineWidth))
                        lineWidth = 1;

                    var opacity = band.opacity;
                    if (isNaN(opacity) || opacity < 0 || opacity > 1)
                        opacity = 1;

                    this.renderer.attr(bandElement, { fill: fillColor, 'fill-opacity': opacity, stroke: lineColor, 'stroke-opacity': opacity, 'stroke-width': lineWidth, 'stroke-dasharray': band.dashStyle });
                } // for
            },

            _getColumnGroupWidth: function (groupIndex, xoffsets, size) {
                var g = this.seriesGroups[groupIndex];
                var isStacked = g.type.indexOf('stacked') != -1;
                var columnsInGroup = isStacked ? 1 : g.series.length;

                var columnGroupsCount = this._getColumnGroupsCount(g.orientation);
                if (isNaN(columnGroupsCount) || 0 == columnGroupsCount)
                    columnGroupsCount = 1;

                var availableWidth = xoffsets.rangeLength >= 1 ? xoffsets.itemWidth : size * 0.9;

                var minWidth = g.columnsMinWidth;
                if (isNaN(minWidth))
                    minWidth = 1;

                if (!isNaN(g.columnsMaxWidth))
                    minWidth = Math.min(g.columnsMaxWidth, minWidth);

                // not all items will fit so try to maximize available width
                if (minWidth > availableWidth && xoffsets.length > 0)
                    availableWidth = Math.max(availableWidth, size * 0.9 / xoffsets.length);

                // calculate required width for the group
                // for stacked seires it will be at least the minWidth
                var requiredWidth = minWidth;

                // calculate requiredWidth for non-stacked series
                if (!isStacked) {
                    var seriesGap = g.seriesGapPercent;
                    if (isNaN(seriesGap) || seriesGap < 0)
                        seriesGap = 10;

                    seriesGap /= 100;

                    var serieMinWidth = minWidth;
                    serieMinWidth *= (1 + seriesGap);

                    requiredWidth += g.series.length * serieMinWidth;
                }

                var targetWidth = Math.max(availableWidth / columnGroupsCount, requiredWidth);

                return { requiredWidth: requiredWidth, availableWidth: availableWidth, targetWidth: targetWidth };
            },

            _getColumnSerieWidthAndOffset: function (groupIndex, serieIndex) {
                var group = this.seriesGroups[groupIndex];
                var s = group.series[serieIndex];

                var inverse = group.orientation == 'horizontal';

                var rect = this._plotRect;
                if (inverse)
                    rect = { x: rect.y, y: rect.x, width: rect.height, height: rect.width };

                var renderData = this._calcGroupOffsets(groupIndex, rect);
                if (!renderData || renderData.xoffsets.length == 0)
                    return;

                var valuesOnTicks = true;

                var columnGroupsCount = this._getColumnGroupsCount(group.orientation);
                if (group.type == 'candlestick' || group.type == 'ohlc')
                    columnGroupsCount = 1;

                var relativeGroupIndex = this._getColumnGroupIndex(groupIndex);

                var groupWidth = this._getColumnGroupWidth(groupIndex, renderData.xoffsets, inverse ? rect.height : rect.width);

                var intialOffset = 0;
                var itemWidth = groupWidth.targetWidth;

                if (this.columnSeriesOverlap == true || (Math.round(itemWidth) > Math.round(groupWidth.availableWidth / columnGroupsCount))) {
                    columnGroupsCount = 1;
                    relativeGroupIndex = 0;
                }

                if (valuesOnTicks)
                    intialOffset -= (itemWidth * columnGroupsCount) / 2;

                intialOffset += itemWidth * relativeGroupIndex;

                // get columns gap
                var columnGap = group.columnsGapPercent;

                if (columnGap <= 0)
                    columnGap = 0;

                if (isNaN(columnGap) || columnGap >= 100)
                    columnGap = 25;

                columnGap /= 100;

                // get item gap size
                var itemGapWidth = itemWidth * columnGap;

                if (itemGapWidth + groupWidth.requiredWidth > groupWidth.targetWidth)
                    itemGapWidth = Math.max(0, groupWidth.targetWidth - groupWidth.requiredWidth);

                if (Math.round(itemWidth) > Math.round(groupWidth.availableWidth))
                    itemGapWidth = 0;

                itemWidth -= itemGapWidth;

                intialOffset += itemGapWidth / 2;

                // get serie gap
                var seriesGap = group.seriesGapPercent;
                if (isNaN(seriesGap) || seriesGap < 0)
                    seriesGap = 10;

                var isStacked = group.type.indexOf('stacked') != -1;

                // get width per serie
                var serieWidth = itemWidth;
                if (!isStacked)
                    serieWidth /= group.series.length;

                // calculate serie gap
                var serieSpace = this._get([group.seriesGap, (itemWidth * seriesGap / 100) / (group.series.length - 1)]);
                if (group.polar == true || group.spider == true || isStacked || group.series.length <= 1)
                    serieSpace = 0;

                var spacesSum = serieSpace * (group.series.length - 1);
                if (group.series.length > 1 && spacesSum > itemWidth - group.series.length * 1) {
                    spacesSum = itemWidth - group.series.length * 1;
                    serieSpace = spacesSum / Math.max(1, (group.series.length - 1));
                }

                // get columnWidth
                var columnWidth = serieWidth - (spacesSum / group.series.length);

                // adjust for max width
                var columnMaxAdj = 0;

                var columnsMaxWidth = group.columnsMaxWidth;
                if (!isNaN(columnsMaxWidth)) {
                    if (columnWidth > columnsMaxWidth) {
                        columnMaxAdj = columnWidth - columnsMaxWidth;
                        columnWidth = columnsMaxWidth;
                    }
                }

                // final horizontal adjustment
                var columnAdj = columnMaxAdj / 2;

                // get relative serie position
                var seriePos = 0;

                if (!isStacked) {
                    var firstPos = (itemWidth - (columnWidth * group.series.length) - spacesSum) / 2;
                    var spacesBeforeSerie = Math.max(0, serieIndex);
                    seriePos = firstPos + columnWidth * serieIndex + spacesBeforeSerie * serieSpace;
                }
                else {
                    seriePos = columnMaxAdj / 2;
                }

                return { width: columnWidth, offset: intialOffset + seriePos };
            },

            /** @private */
            _renderColumnSeries: function (groupIndex, rect) {
                var group = this.seriesGroups[groupIndex];
                if (!group.series || group.series.length == 0)
                    return;

                var dataLength = this._getDataLen(groupIndex);

                var inverse = group.orientation == 'horizontal';

                var gRect = rect;
                if (inverse)
                    gRect = { x: rect.y, y: rect.x, width: rect.height, height: rect.width };

                var renderData = this._calcGroupOffsets(groupIndex, gRect);
                if (!renderData || renderData.xoffsets.length == 0)
                    return;

                var polarAxisCoords;
                if (group.polar == true || group.spider == true) {
                    polarAxisCoords = this._getPolarAxisCoords(groupIndex, gRect);
                }

                var ctx = { groupIndex: groupIndex, rect: rect, vertical: !inverse, seriesCtx: [], renderData: renderData, polarAxisCoords: polarAxisCoords };
                ctx.columnGroupWidth = this._getColumnGroupWidth(groupIndex, renderData.xoffsets, inverse ? gRect.height : gRect.width);

                var gradientType = this._getGroupGradientType(groupIndex);

                for (var sidx = 0; sidx < group.series.length; sidx++) {
                    var s = group.series[sidx];
                    if (s.customDraw)
                        continue;

                    var dataField = s.dataField;

                    var anim = this._getAnimProps(groupIndex, sidx);
                    var duration = anim.enabled && !this._isToggleRefresh && renderData.xoffsets.length < 100 ? anim.duration : 0;

                    // Calculate horizontal adjustment
                    var columnWidthAndOffset = this._getColumnSerieWidthAndOffset(groupIndex, sidx);

                    var isVisible = this._isSerieVisible(groupIndex, sidx);

                    var serieSettings = this._getSerieSettings(groupIndex, sidx);
                    var serieColors = this._getColors(groupIndex, sidx, NaN, this._getGroupGradientType(groupIndex), 4);

                    var itemsColors = [];
                    if ($.isFunction(s.colorFunction) && !polarAxisCoords) {
                        for (var i = renderData.xoffsets.first; i <= renderData.xoffsets.last; i++)
                            itemsColors.push(this._getColors(groupIndex, sidx, i, gradientType, 4));
                    }

                    var serieCtx = {
                        seriesIndex: sidx,
                        serieColors: serieColors,
                        itemsColors: itemsColors,
                        settings: serieSettings,
                        columnWidth: columnWidthAndOffset.width,
                        xAdjust: columnWidthAndOffset.offset,
                        isVisible: isVisible
                    };

                    ctx.seriesCtx.push(serieCtx);
                }

                this._animColumns(ctx, duration == 0 ? 1 : 0);

                var self = this;
                this._enqueueAnimation(
                    "series",
                    undefined,
                    undefined,
                    duration,
                    function (element, ctx, percent) {
                        self._animColumns(ctx, percent);
                    },
                    ctx);
            },

            _getPercent: function (value, defValue, minValue, maxValue) {
                if (isNaN(value))
                    value = defValue;

                if (!isNaN(minValue) && !isNaN(value) && value < minValue)
                    value = minValue;

                if (!isNaN(maxValue) && !isNaN(value) && value > maxValue)
                    value = maxValue;

                if (isNaN(value))
                    return NaN;

                return value;
            },

            /** @private */
            _getColumnVOffsets: function (renderData, groupIndex, seriesCtx, itemIndex, isStacked, percent) {
                var group = this.seriesGroups[groupIndex];

                var columnsTopWidthPercent = this._getPercent(group.columnsTopWidthPercent, 100, 0, 100);
                var columnsBottomWidthPercent = this._getPercent(group.columnsBottomWidthPercent, 100, 0, 100);

                if (columnsTopWidthPercent == 0 && columnsBottomWidthPercent == 0)
                    columnsBottomWidthPercent = 100;

                var neckHeightPercent = this._getPercent(group.columnsNeckHeightPercent, NaN, 0, 100) / 100;
                var neckWidthPercent = this._getPercent(group.columnsNeckWidthPercent, 100, 0, 100) / 100;

                var offsets = [];

                var prevTo = NaN;
                for (var iSerie = 0; iSerie < seriesCtx.length; iSerie++) {
                    var serieCtx = seriesCtx[iSerie];
                    var sidx = serieCtx.seriesIndex;
                    var s = group.series[sidx];

                    var from = renderData.offsets[sidx][itemIndex].from;
                    var to = renderData.offsets[sidx][itemIndex].to;
                    var xOffset = renderData.xoffsets.data[itemIndex];

                    var itemStartState;

                    var isVisible = serieCtx.isVisible;
                    if (!isVisible)
                        to = from;

                    var elementRenderInfo = this._elementRenderInfo;
                    if (isVisible &&
                        elementRenderInfo &&
                        elementRenderInfo.length > groupIndex &&
                        elementRenderInfo[groupIndex].series.length > sidx
                    ) {
                        var xvalue = renderData.xoffsets.xvalues[itemIndex];
                        itemStartState = elementRenderInfo[groupIndex].series[sidx][xvalue];
                        if (itemStartState && !isNaN(itemStartState.from) && !isNaN(itemStartState.to)) {
                            from = itemStartState.from + (from - itemStartState.from) * percent;
                            to = itemStartState.to + (to - itemStartState.to) * percent;
                            xOffset = itemStartState.xoffset + (xOffset - itemStartState.xoffset) * percent;
                        }
                    }

                    if (!itemStartState)
                        to = from + (to - from) * (isStacked ? 1 : percent);

                    if (isNaN(from))
                        from = isNaN(prevTo) ? renderData.baseOffset : prevTo;

                    if (!isNaN(to) && isStacked)
                        prevTo = to;
                    else
                        prevTo = from;

                    if (isNaN(to))
                        to = from;

                    var item = { from: from, to: to, xOffset: xOffset };
                    if (columnsTopWidthPercent != 100 || columnsBottomWidthPercent != 100) {
                        item.funnel = true;
                        item.toWidthPercent = columnsTopWidthPercent;
                        item.fromWidthPercent = columnsBottomWidthPercent;
                    }

                    offsets.push(item);
                }

                if (isStacked && offsets.length > 1 && !(this._elementRenderInfo && this._elementRenderInfo.length > groupIndex)) {
                    var sumP = 0, sumN = 0, minP = -Infinity, maxP = Infinity, minN = Infinity, maxN = -Infinity;
                    for (var i = 0; i < offsets.length; i++) {
                        var serieCtx = seriesCtx[i];
                        if (serieCtx.isVisible) {
                            if (offsets[i].to >= offsets[i].from) {
                                sumN += offsets[i].to - offsets[i].from;

                                minN = Math.min(minN, offsets[i].from);
                                maxN = Math.max(maxN, offsets[i].to);
                            }
                            else {
                                sumP += offsets[i].from - offsets[i].to;

                                minP = Math.max(minP, offsets[i].from);
                                maxP = Math.min(maxP, offsets[i].to);
                            }
                        }
                    }

                    var sumPSave = sumP;
                    var sumNSave = sumN;

                    sumP *= percent;
                    sumN *= percent;

                    var curP = 0, curN = 0;
                    for (var i = 0; i < offsets.length; i++) {
                        if (offsets[i].to >= offsets[i].from) {
                            var diff = offsets[i].to - offsets[i].from;
                            if (diff + curN > sumN) {
                                diff = Math.max(0, sumN - curN);
                                offsets[i].to = offsets[i].from + diff;
                            }

                            if (columnsTopWidthPercent != 100 || columnsBottomWidthPercent != 100) {
                                offsets[i].funnel = true;

                                if (!isNaN(neckHeightPercent) && sumNSave * neckHeightPercent >= curN)
                                    offsets[i].fromWidthPercent = neckWidthPercent * 100;
                                else
                                    offsets[i].fromWidthPercent = (Math.abs(offsets[i].from - minN) / sumNSave) * (columnsTopWidthPercent - columnsBottomWidthPercent) + columnsBottomWidthPercent;

                                if (!isNaN(neckHeightPercent) && sumNSave * neckHeightPercent >= (0 + (curN + diff)))
                                    offsets[i].toWidthPercent = neckWidthPercent * 100;
                                else
                                    offsets[i].toWidthPercent = (Math.abs(offsets[i].to - minN) / sumNSave) * (columnsTopWidthPercent - columnsBottomWidthPercent) + columnsBottomWidthPercent;
                            }

                            curN += diff;
                        }
                        else {
                            var diff = offsets[i].from - offsets[i].to;
                            if (diff + curP > sumP) {
                                diff = Math.max(0, sumP - curP);
                                offsets[i].to = offsets[i].from - diff;
                            }

                            if (columnsTopWidthPercent != 100 || columnsBottomWidthPercent != 100) {
                                offsets[i].funnel = true;

                                if (!isNaN(neckHeightPercent) && sumPSave * neckHeightPercent >= curP)
                                    offsets[i].fromWidthPercent = neckWidthPercent * 100;
                                else
                                    offsets[i].fromWidthPercent = (Math.abs(offsets[i].from - minP) / sumPSave) * (columnsTopWidthPercent - columnsBottomWidthPercent) + columnsBottomWidthPercent;

                                if (!isNaN(neckHeightPercent) && sumPSave * neckHeightPercent >= (0 + (curP + diff)))
                                    offsets[i].toWidthPercent = neckWidthPercent * 100;
                                else
                                    offsets[i].toWidthPercent = (Math.abs(offsets[i].to - minP) / sumPSave) * (columnsTopWidthPercent - columnsBottomWidthPercent) + columnsBottomWidthPercent;
                            }

                            curP += diff;
                        }
                    }
                }

                return offsets;
            },

            /** @private */
            _columnAsPieSlice: function (elementInfo, plotRect, polarAxisCoords, columnRect) {
                var pointOuter = this._toPolarCoord(polarAxisCoords, plotRect, columnRect.x, columnRect.y);
                var pointInner = this._toPolarCoord(polarAxisCoords, plotRect, columnRect.x, columnRect.y + columnRect.height);

                var innerRadius = $.jqx._ptdist(polarAxisCoords.x, polarAxisCoords.y, pointInner.x, pointInner.y);
                var outerRadius = $.jqx._ptdist(polarAxisCoords.x, polarAxisCoords.y, pointOuter.x, pointOuter.y);
                var width = plotRect.width;

                var angleRange = Math.abs(polarAxisCoords.startAngle - polarAxisCoords.endAngle) * 180 / Math.PI;

                var toAngle = -((columnRect.x - plotRect.x) * angleRange) / width;
                var fromAngle = -((columnRect.x + columnRect.width - plotRect.x) * angleRange) / width;

                var startAngle = polarAxisCoords.startAngle;
                startAngle = 360 * startAngle / (Math.PI * 2);

                toAngle -= startAngle;
                fromAngle -= startAngle;

                if (elementInfo) {
                    if (elementInfo.element != undefined) {
                        var cmd = this.renderer.pieSlicePath(polarAxisCoords.x, polarAxisCoords.y, innerRadius, outerRadius, fromAngle, toAngle, 0);
                        cmd += ' Z';
                        this.renderer.attr(elementInfo.element, { 'd': cmd });
                    }
                    else {
                        elementInfo.element = this.renderer.pieslice(
                            polarAxisCoords.x,
                            polarAxisCoords.y,
                            innerRadius,
                            outerRadius,
                            fromAngle,
                            toAngle,
                            0);
                    }
                }

                return { fromAngle: fromAngle, toAngle: toAngle, innerRadius: innerRadius, outerRadius: outerRadius };
            },

            _setRenderInfo: function (groupIndex, serieIndex, itemIndex, elementInfo) {
                this._renderData[groupIndex].offsets[serieIndex][itemIndex].elementInfo = elementInfo;
            },

            _getRenderInfo: function (groupIndex, serieIndex, itemIndex) {
                return this._renderData[groupIndex].offsets[serieIndex][itemIndex].elementInfo || {};
            },

            /** @private */
            _animColumns: function (context, percent) {
                var self = this;

                var gidx = context.groupIndex;
                var group = this.seriesGroups[gidx];
                var renderData = context.renderData;
                var isWaterfall = group.type.indexOf('waterfall') != -1;
                var xAxis = this._getXAxis(gidx);

                var isStacked = group.type.indexOf('stacked') != -1;

                var polarAxisCoords = context.polarAxisCoords;

                var gradientType = this._getGroupGradientType(gidx);

                var columnWidth = context.columnGroupWidth.targetWidth;

                var firstVisibleSerie = -1;
                for (var j = 0; j < group.series.length; j++) {
                    if (this._isSerieVisible(gidx, j)) {
                        firstVisibleSerie = j;
                        break;
                    }
                }

                var minPos = NaN, maxPos = NaN;
                for (var j = 0; j < context.seriesCtx.length; j++) {
                    var serieCtx = context.seriesCtx[j];
                    if (isNaN(minPos) || minPos > serieCtx.xAdjust)
                        minPos = serieCtx.xAdjust;
                    if (isNaN(maxPos) || maxPos < serieCtx.xAdjust + serieCtx.columnWidth)
                        maxPos = serieCtx.xAdjust + serieCtx.columnWidth;
                }

                var realGroupWidth = Math.abs(maxPos - minPos);
                var gapPercent = this._get([group.columnsGapPercent, 25]) / 100;
                if (isNaN(gapPercent) < 0 || gapPercent >= 1)
                    gapPercent = 0.25;

                var realGroupGapWidth = gapPercent * realGroupWidth;

                var xoffsets = context.renderData.xoffsets;

                var xPrev = -1;

                var yWaterfallPrev = {};

                // skipOverlappingPoints is off by default in column series
                var skipOverlappingPoints = group.skipOverlappingPoints == true;

                for (var i = xoffsets.first; i <= xoffsets.last; i++) {
                    var x = xoffsets.data[i];
                    if (isNaN(x))
                        continue;

                    if (xPrev != -1 && Math.abs(x - xPrev) < (realGroupWidth - 1 + realGroupGapWidth) && skipOverlappingPoints)
                        continue;
                    else
                        xPrev = x;

                    var offsets = this._getColumnVOffsets(renderData, gidx, context.seriesCtx, i, isStacked, percent);

                    var isSummary = false;

                    if (isWaterfall) {
                        for (var iSerie = 0; iSerie < group.series.length; iSerie++) {
                            if (group.series[iSerie].summary && xoffsets.xvalues[i][group.series[iSerie].summary])
                                isSummary = true;
                        }
                    }

                    for (var iSerie = 0; iSerie < context.seriesCtx.length; iSerie++) {
                        var serieCtx = context.seriesCtx[iSerie];
                        var sidx = serieCtx.seriesIndex;
                        var serie = group.series[sidx];

                        var from = offsets[iSerie].from;
                        var to = offsets[iSerie].to;
                        var xOffset = offsets[iSerie].xOffset;

                        var startOffset = (context.vertical ? context.rect.x : context.rect.y) + serieCtx.xAdjust;

                        var settings = serieCtx.settings;
                        var colors = serieCtx.itemsColors.length != 0 ? serieCtx.itemsColors[i - renderData.xoffsets.first] : serieCtx.serieColors;

                        var isVisible = this._isSerieVisible(gidx, sidx);

                        if (!isVisible /*&& !isStacked*/)
                            continue;

                        var x = $.jqx._ptrnd(startOffset + xOffset);

                        var rect = { x: x, width: serieCtx.columnWidth };

                        if (offsets[iSerie].funnel) {
                            rect.fromWidthPercent = offsets[iSerie].fromWidthPercent;
                            rect.toWidthPercent = offsets[iSerie].toWidthPercent;
                        }

                        var isInverseDirection = true;

                        if (context.vertical) {
                            rect.y = from;
                            rect.height = to - from;
                            if (rect.height < 0) {
                                rect.y += rect.height;
                                rect.height = -rect.height;
                                isInverseDirection = false;
                            }
                        }
                        else {
                            rect.x = from < to ? from : to;
                            rect.width = Math.abs(from - to);
                            isInverseDirection = from - to < 0;
                            rect.y = x;
                            rect.height = serieCtx.columnWidth;
                        }

                        var size = from - to;
                        if (isNaN(size))
                            continue;

                        size = Math.abs(size);

                        var pieSliceInfo = undefined;

                        var elementRenderInfo = self._getRenderInfo(gidx, sidx, i);
                        var element = elementRenderInfo.element;
                        var labelElement = elementRenderInfo.labelElement;
                        var isNewElement = element == undefined;

                        if (labelElement) {
                            self.renderer.removeElement(labelElement);
                            labelElement = undefined;
                        }

                        if (!polarAxisCoords) {
                            if (offsets[iSerie].funnel) // funnel or pyramid
                            {
                                var path = this._getTrapezoidPath($.extend({}, rect), context.vertical, isInverseDirection);
                                if (isNewElement)
                                    element = this.renderer.path(path, {});
                                else
                                    this.renderer.attr(element, { d: path });
                            }
                            else { // regular column
                                if (isNewElement) {
                                    element = this.renderer.rect(rect.x, rect.y, context.vertical ? rect.width : 0, context.vertical ? 0 : rect.height);
                                }
                                else {
                                    if (context.vertical == true)
                                        this.renderer.attr(element, { x: rect.x, y: rect.y, height: size });
                                    else
                                        this.renderer.attr(element, { x: rect.x, y: rect.y, width: size });
                                }
                            }
                        }
                        else // column on polar axis
                        {
                            var elementInfo = { element: element };
                            pieSliceInfo = this._columnAsPieSlice(elementInfo, context.rect, polarAxisCoords, rect);
                            element = elementInfo.element;

                            var colors = this._getColors(gidx, sidx, undefined, 'radialGradient', pieSliceInfo.outerRadius);
                        }

                        if (size < 1 && (percent != 1 || polarAxisCoords))
                            this.renderer.attr(element, { display: 'none' });
                        else
                            this.renderer.attr(element, { display: 'block' });

                        if (isNewElement)
                            this.renderer.attr(element, { fill: colors.fillColor, 'fill-opacity': settings.opacity, 'stroke-opacity': settings.opacity, stroke: colors.lineColor, 'stroke-width': settings.stroke, 'stroke-dasharray': settings.dashStyle });

                        if (labelElement)
                            this.renderer.removeElement(labelElement);

                        if (!isVisible || (size == 0 && percent < 1)) {
                            elementRenderInfo = { element: element, labelElement: labelElement };
                            self._setRenderInfo(gidx, sidx, i, elementRenderInfo);
                            continue;
                        }

                        /// Waterfall start
                        if (isWaterfall && this._get([serie.showWaterfallLines, group.showWaterfallLines]) != false) {
                            if (!isStacked || (isStacked && iSerie == firstVisibleSerie)) {
                                var serieKey = isStacked ? -1 : iSerie;
                                if (percent == 1 && !isNaN(renderData.offsets[iSerie][i].from) && !isNaN(renderData.offsets[iSerie][i].to)) {
                                    var prevWFInfo = yWaterfallPrev[serieKey];
                                    if (prevWFInfo != undefined) {

                                        var p1 =
                                        {
                                            x: prevWFInfo.x,
                                            y: $.jqx._ptrnd(prevWFInfo.y)
                                        };

                                        var p2 = {
                                            x: x,
                                            y: p1.y
                                        };

                                        var topWP = group.columnsTopWidthPercent / 100;
                                        if (isNaN(topWP))
                                            topWP = 1;
                                        else if (topWP > 1 || topWP < 0)
                                            topWP = 1;

                                        var bottomWP = group.columnsBottomWidthPercent / 100;
                                        if (isNaN(bottomWP))
                                            bottomWP = 1;
                                        else if (bottomWP > 1 || bottomWP < 0)
                                            bottomWP = 1;

                                        var sz = context.vertical ? rect.width : rect.height;

                                        p1.x = p1.x - sz / 2 + sz / 2 * topWP;

                                        if (isSummary) {
                                            var adj = sz * topWP / 2;
                                            p2.x = p2.x + sz / 2 - (xAxis.flip ? -adj : adj);
                                        }
                                        else {
                                            var adj = sz * bottomWP / 2;
                                            p2.x = p2.x + sz / 2 - (xAxis.flip ? -adj : adj);
                                        }

                                        if (!context.vertical) {
                                            this._swapXY([p1]);
                                            this._swapXY([p2]);
                                        }

                                        this.renderer.line(
                                            p1.x,
                                            p1.y,
                                            p2.x,
                                            p2.y,
                                            {
                                                stroke: prevWFInfo.color,
                                                'stroke-width': settings.stroke,
                                                'stroke-opacity': settings.opacity,
                                                'fill-opacity': settings.opacity,
                                                'stroke-dasharray': settings.dashStyle
                                            }
                                        );
                                    }
                                }
                            }

                            if (percent == 1 && size != 0) {
                                yWaterfallPrev[isStacked ? -1 : iSerie] = { y: to, x: (context.vertical ? rect.x + rect.width : rect.y + rect.height), color: colors.lineColor };
                            }
                        }
                        // Waterfall end

                        if (polarAxisCoords) {
                            var pointOuter = this._toPolarCoord(polarAxisCoords, context.rect, rect.x + rect.width / 2, rect.y);
                            var sz = this._showLabel(gidx, sidx, i, rect, undefined, undefined, true);
                            var labelRadius = pieSliceInfo.outerRadius + 10;

                            var labelOffset = this._adjustTextBoxPosition(
                                polarAxisCoords.x,
                                polarAxisCoords.y,
                                sz,
                                labelRadius,
                                (pieSliceInfo.fromAngle + pieSliceInfo.toAngle) / 2,
                                true,
                                false,
                                false
                            );

                            labelElement = this._showLabel(gidx, sidx, i, { x: labelOffset.x, y: labelOffset.y }, undefined, undefined, false, false, false);
                        }
                        else {
                            labelElement = this._showLabel(gidx, sidx, i, rect, undefined, undefined, false, false, isInverseDirection);
                        }

                        elementRenderInfo = { element: element, labelElement: labelElement };
                        self._setRenderInfo(gidx, sidx, i, elementRenderInfo);

                        if (percent == 1.0) {
                            this._installHandlers(element, 'column', gidx, sidx, i);
                        }
                    }
                }
            },

            _getTrapezoidPath: function (rect, isVertical, isInverseDirection) {
                var path = '';

                var fromP = rect.fromWidthPercent / 100;
                var toP = rect.toWidthPercent / 100;

                if (!isVertical) {
                    var tmp = rect.width;
                    rect.width = rect.height;
                    rect.height = tmp;
                    tmp = rect.x;
                    rect.x = rect.y;
                    rect.y = tmp;
                }

                var x = rect.x + rect.width / 2;

                var points = [
                    { x: x - rect.width * (!isInverseDirection ? fromP : toP) / 2, y: rect.y + rect.height },
                    { x: x - rect.width * (!isInverseDirection ? toP : fromP) / 2, y: rect.y },
                    { x: x + rect.width * (!isInverseDirection ? toP : fromP) / 2, y: rect.y },
                    { x: x + rect.width * (!isInverseDirection ? fromP : toP) / 2, y: rect.y + rect.height }
                ];

                if (!isVertical)
                    this._swapXY(points);

                path += 'M ' + $.jqx._ptrnd(points[0].x) + "," + $.jqx._ptrnd(points[0].y);

                for (var i = 1; i < points.length; i++)
                    path += ' L ' + $.jqx._ptrnd(points[i].x) + ',' + $.jqx._ptrnd(points[i].y);

                path += ' Z';

                return path;
            },

            _swapXY: function (points) {
                for (var i = 0; i < points.length; i++) {
                    var tmp = points[i].x;
                    points[i].x = points[i].y;
                    points[i].y = tmp;
                }
            },

            /** @private */
            _renderCandleStickSeries: function (groupIndex, rect, isOHLC) {
                var self = this;
                var group = self.seriesGroups[groupIndex];
                if (!group.series || group.series.length == 0)
                    return;

                var inverse = group.orientation == 'horizontal';

                var gRect = rect;
                if (inverse)
                    gRect = { x: rect.y, y: rect.x, width: rect.height, height: rect.width };

                var renderData = self._calcGroupOffsets(groupIndex, gRect);

                if (!renderData || renderData.xoffsets.length == 0)
                    return;

                var scaleWidth = gRect.width;

                var polarAxisCoords;
                if (group.polar || group.spider) {
                    polarAxisCoords = self._getPolarAxisCoords(groupIndex, gRect);
                    scaleWidth = 2 * polarAxisCoords.r;
                }

                var valuesOnTicks = self._alignValuesWithTicks(groupIndex);

                var gradientType = self._getGroupGradientType(groupIndex);

                var columnsInfo = [];
                for (var sidx = 0; sidx < group.series.length; sidx++)
                    columnsInfo[sidx] = self._getColumnSerieWidthAndOffset(groupIndex, sidx);

                for (var sidx = 0; sidx < group.series.length; sidx++) {
                    if (!this._isSerieVisible(groupIndex, sidx))
                        continue;

                    var settings = self._getSerieSettings(groupIndex, sidx);

                    var s = group.series[sidx];
                    if (s.customDraw)
                        continue;

                    var colors = $.isFunction(s.colorFunction) ? undefined : self._getColors(groupIndex, sidx, NaN, gradientType);

                    var ctx = {
                        rect: rect,
                        inverse: inverse,
                        groupIndex: groupIndex,
                        seriesIndex: sidx,
                        symbolType: s.symbolType,
                        symbolSize: s.symbolSize,
                        'fill-opacity': settings.opacity,
                        'stroke-opacity': settings.opacity,
                        'stroke-width': settings.stroke,
                        'stroke-dasharray': settings.dashStyle,
                        gradientType: gradientType,
                        colors: colors,
                        renderData: renderData,
                        polarAxisCoords: polarAxisCoords,
                        columnsInfo: columnsInfo,
                        isOHLC: isOHLC,
                        items: [],
                        self: self
                    };

                    var anim = self._getAnimProps(groupIndex, sidx);
                    var duration = anim.enabled && !self._isToggleRefresh && renderData.xoffsets.length < 5000 ? anim.duration : 0;

                    self._animCandleStick(ctx, 0);

                    var elem;
                    self._enqueueAnimation("series", undefined, undefined, duration,
                        function (undefined, context, percent) {
                            self._animCandleStick(context, percent);
                        }, ctx);
                }
            },

            /** @private */
            _animCandleStick: function (ctx, percent) {
                var fields = ['Open', 'Low', 'Close', 'High'];

                var columnWidth = ctx.columnsInfo[ctx.seriesIndex].width;

                var group = ctx.self.seriesGroups[ctx.groupIndex];
                var xoffsets = ctx.renderData.xoffsets;

                var xPrev = -1;

                var xRange = Math.abs(xoffsets.data[xoffsets.last] - xoffsets.data[xoffsets.first]);
                xRange *= percent;

                var minPos = NaN, maxPos = NaN;
                for (var j = 0; j < ctx.columnsInfo.length; j++) {
                    var serieCtx = ctx.columnsInfo[j];
                    if (isNaN(minPos) || minPos > serieCtx.offset)
                        minPos = serieCtx.offset;
                    if (isNaN(maxPos) || maxPos < serieCtx.offset + serieCtx.width)
                        maxPos = serieCtx.offset + serieCtx.width;
                }

                var realGroupWidth = Math.abs(maxPos - minPos);

                // skipOverlappingPoints is on by default in candlestick & OHLC series
                var skipOverlappingPoints = group.skipOverlappingPoints != false;

                for (var i = xoffsets.first; i <= xoffsets.last; i++) {
                    var x = xoffsets.data[i];
                    if (isNaN(x))
                        continue;

                    if (xPrev != -1 && Math.abs(x - xPrev) < realGroupWidth && skipOverlappingPoints)
                        continue;

                    // skip drawing elements outside the anim % range
                    var xDiff = Math.abs(xoffsets.data[i] - xoffsets.data[xoffsets.first]);
                    if (xDiff > xRange)
                        break;

                    xPrev = x;

                    var item = ctx.items[i] = ctx.items[i] || {};

                    for (var j in fields) {
                        var val = ctx.self._getDataValueAsNumber(i, group.series[ctx.seriesIndex]['dataField' + fields[j]], ctx.groupIndex);
                        if (isNaN(val))
                            break;

                        var y = ctx.renderData.offsets[ctx.seriesIndex][i][fields[j]];
                        if (isNaN(y))
                            break;

                        item[fields[j]] = y;
                    }

                    x += ctx.inverse ? ctx.rect.y : ctx.rect.x;

                    if (ctx.polarAxisCoords) {
                        var point = this._toPolarCoord(ctx.polarAxisCoords, this._plotRect, x, y);
                        x = point.x;
                        y = point.y;
                    }

                    x = $.jqx._ptrnd(x);

                    for (var it in fields)
                        item[it] = $.jqx._ptrnd(item[it]);

                    var colors = ctx.colors;
                    if (!colors)
                        colors = ctx.self._getColors(ctx.groupIndex, ctx.seriesIndex, i, ctx.gradientType);

                    if (!ctx.isOHLC) {
                        var lineElement = item.lineElement;

                        if (!lineElement) {
                            lineElement = ctx.inverse ? this.renderer.line(item.Low, x, item.High, x) : this.renderer.line(x, item.Low, x, item.High);
                            this.renderer.attr(lineElement, { fill: colors.fillColor, 'fill-opacity': ctx['fill-opacity'], 'stroke-opacity': ctx['fill-opacity'], stroke: colors.lineColor, 'stroke-width': ctx['stroke-width'], 'stroke-dasharray': ctx['stroke-dasharray'] });
                            item.lineElement = lineElement;
                        }

                        var stickElement = item.stickElement;
                        x -= columnWidth / 2;

                        if (!stickElement) {
                            var fillColor = colors.fillColor;
                            if (item.Close <= item.Open && colors.fillColorAlt)
                                fillColor = colors.fillColorAlt;

                            stickElement = ctx.inverse ?
                                this.renderer.rect(Math.min(item.Open, item.Close), x, Math.abs(item.Close - item.Open), columnWidth) :
                                this.renderer.rect(x, Math.min(item.Open, item.Close), columnWidth, Math.abs(item.Close - item.Open));

                            this.renderer.attr(stickElement, { fill: fillColor, 'fill-opacity': ctx['fill-opacity'], 'stroke-opacity': ctx['fill-opacity'], stroke: colors.lineColor, 'stroke-width': ctx['stroke-width'], 'stroke-dasharray': ctx['stroke-dasharray'] });
                            item.stickElement = stickElement;
                        }

                        if (percent == 1.0)
                            this._installHandlers(stickElement, 'column', ctx.groupIndex, ctx.seriesIndex, i);
                    }
                    else {
                        var path =
                            'M' + x + ',' + item.Low + ' L' + x + ',' + item.High + ' ' +
                            'M' + (x - columnWidth / 2) + ',' + item.Open + ' L' + x + ',' + item.Open + ' ' +
                            'M' + (x + columnWidth / 2) + ',' + item.Close + ' L' + x + ',' + item.Close;

                        if (ctx.inverse) {
                            path =
                                'M' + item.Low + ',' + x + ' L' + item.High + ',' + x + ' ' +
                                'M' + item.Open + ',' + (x - columnWidth / 2) + ' L' + item.Open + ',' + x + ' ' +
                                'M' + item.Close + ',' + x + ' L' + item.Close + ',' + (x + columnWidth / 2);
                        }

                        var lineElement = item.lineElement;

                        if (!lineElement) {
                            lineElement = this.renderer.path(path, {});
                            this.renderer.attr(lineElement, { fill: colors.fillColor, 'fill-opacity': ctx['fill-opacity'], 'stroke-opacity': ctx['fill-opacity'], stroke: colors.lineColor, 'stroke-width': ctx['stroke-width'], 'stroke-dasharray': ctx['stroke-dasharray'] });
                            item.lineElement = lineElement;
                        } /*
                    else {
                        this.renderer.attr(lineElement, { 'd': path });
                    }*/

                        if (percent == 1.0)
                            this._installHandlers(lineElement, 'column', ctx.groupIndex, ctx.seriesIndex, i);
                    }

                } // for
            },


            /** @private */
            _renderScatterSeries: function (groupIndex, rect, valueField) {
                var group = this.seriesGroups[groupIndex];
                if (!group.series || group.series.length == 0)
                    return;

                var isBubble = group.type.indexOf('bubble') != -1;

                var inverse = group.orientation == 'horizontal';

                var gRect = rect;
                if (inverse)
                    gRect = { x: rect.y, y: rect.x, width: rect.height, height: rect.width };

                var renderData = this._calcGroupOffsets(groupIndex, gRect);

                if (!renderData || renderData.xoffsets.length == 0)
                    return;

                var scaleWidth = gRect.width;

                var polarAxisCoords;
                if (group.polar || group.spider) {
                    polarAxisCoords = this._getPolarAxisCoords(groupIndex, gRect);
                    scaleWidth = 2 * polarAxisCoords.r;
                }

                var valuesOnTicks = this._alignValuesWithTicks(groupIndex);

                var gradientType = this._getGroupGradientType(groupIndex);

                if (!valueField)
                    valueField = 'to';

                for (var sidx = 0; sidx < group.series.length; sidx++) {
                    var settings = this._getSerieSettings(groupIndex, sidx);

                    var s = group.series[sidx];
                    if (s.customDraw)
                        continue;

                    var dataField = s.dataField;

                    var hasColorFunction = $.isFunction(s.colorFunction);

                    var colors = this._getColors(groupIndex, sidx, NaN, gradientType);

                    var min = NaN, max = NaN;
                    if (isBubble) {
                        for (var i = renderData.xoffsets.first; i <= renderData.xoffsets.last; i++) {
                            var val = this._getDataValueAsNumber(i, (s.radiusDataField || s.sizeDataField), groupIndex);
                            if (typeof (val) != 'number')
                                throw 'Invalid radiusDataField value at [' + i + ']';

                            if (!isNaN(val)) {
                                if (isNaN(min) || val < min)
                                    min = val;
                                if (isNaN(max) || val > max)
                                    max = val;
                            }
                        }
                    }

                    var minRadius = s.minRadius || s.minSymbolSize;
                    if (isNaN(minRadius))
                        minRadius = scaleWidth / 50;

                    var maxRadius = s.maxRadius || s.maxSymbolSize;
                    if (isNaN(maxRadius))
                        maxRadius = scaleWidth / 25;

                    if (minRadius > maxRadius)
                        maxRadius = minRadius;

                    var radius = s.radius;
                    if (isNaN(radius) && !isNaN(s.symbolSize)) {
                        radius = (s.symbolType == 'circle') ? s.symbolSize / 2 : s.symbolSize;
                    }
                    else
                        radius = 5;

                    var anim = this._getAnimProps(groupIndex, sidx);
                    var duration = anim.enabled && !this._isToggleRefresh && renderData.xoffsets.length < 5000 ? anim.duration : 0;

                    var ctx = {
                        groupIndex: groupIndex,
                        seriesIndex: sidx,
                        symbolType: s.symbolType,
                        symbolSize: s.symbolSize,
                        'fill-opacity': settings.opacity,
                        'stroke-opacity': settings.opacity,
                        'stroke-width': settings.stroke,
                        'stroke-width-symbol': settings.strokeSymbol,
                        'stroke-dasharray': settings.dashStyle,
                        items: [],
                        polarAxisCoords: polarAxisCoords
                    };

                    var ptSave = undefined;

                    for (var i = renderData.xoffsets.first; i <= renderData.xoffsets.last; i++) {
                        var val = this._getDataValueAsNumber(i, dataField, groupIndex);
                        if (typeof (val) != 'number')
                            continue;

                        var x = renderData.xoffsets.data[i];
                        var xvalue = renderData.xoffsets.xvalues[i];
                        var y = renderData.offsets[sidx][i][valueField];

                        if (y < gRect.y || y > gRect.y + gRect.height)
                            continue;

                        if (isNaN(x) || isNaN(y))
                            continue;

                        if (inverse) {
                            var tmp = x;
                            x = y;
                            y = tmp + rect.y;
                        }
                        else {
                            x += rect.x;
                        }

                        if (!hasColorFunction && ptSave && this.enableSampling && $.jqx._ptdist(ptSave.x, ptSave.y, x, y) < 1)
                            continue;

                        ptSave = { x: x, y: y };

                        var r = radius;
                        if (isBubble) {
                            var rval = this._getDataValueAsNumber(i, (s.radiusDataField || s.sizeDataField), groupIndex);
                            if (typeof (rval) != 'number')
                                continue;
                            r = minRadius + (maxRadius - minRadius) * (rval - min) / Math.max(1, max - min);
                            if (isNaN(r))
                                r = minRadius;
                        }

                        renderData.offsets[sidx][i].radius = r;

                        var yOld = NaN, xOld = NaN;
                        var rOld = 0;
                        var elementRenderInfo = this._elementRenderInfo;
                        if (xvalue != undefined &&
                            elementRenderInfo &&
                            elementRenderInfo.length > groupIndex &&
                            elementRenderInfo[groupIndex].series.length > sidx
                        ) {
                            var itemStartState = elementRenderInfo[groupIndex].series[sidx][xvalue];
                            if (itemStartState && !isNaN(itemStartState.to)) {
                                yOld = itemStartState.to;
                                xOld = itemStartState.xoffset;
                                rOld = radius;

                                if (inverse) {
                                    var tmp = xOld;
                                    xOld = yOld;
                                    yOld = tmp + rect.y;
                                }
                                else {
                                    xOld += rect.x;
                                }

                                if (isBubble) {
                                    rOld = minRadius + (maxRadius - minRadius) * (itemStartState.valueRadius - min) / Math.max(1, max - min);
                                    if (isNaN(rOld))
                                        rOld = minRadius;
                                }
                            }
                        }


                        if (hasColorFunction)
                            colors = this._getColors(groupIndex, sidx, i, gradientType);

                        ctx.items.push({
                            from: rOld,
                            to: r,
                            itemIndex: i,
                            fill: colors.fillColor,
                            stroke: colors.lineColor,
                            x: x,
                            y: y,
                            xFrom: xOld,
                            yFrom: yOld
                        });
                    } // i

                    this._animR(ctx, 0);

                    var self = this;
                    var elem;
                    this._enqueueAnimation("series", undefined, undefined, duration,
                        function (undefined, context, percent) {
                            self._animR(context, percent);
                        }, ctx);
                }
            },

            /** @private */
            _animR: function (ctx, percent) {
                var items = ctx.items;

                var symbolType = ctx.symbolType || 'circle';
                var symbolSize = ctx.symbolSize;

                for (var i = 0; i < items.length; i++) {
                    var item = items[i];
                    var x = item.x;
                    var y = item.y;

                    var r = Math.round((item.to - item.from) * percent + item.from);
                    if (!isNaN(item.yFrom))
                        y = item.yFrom + (y - item.yFrom) * percent;
                    if (!isNaN(item.xFrom))
                        x = item.xFrom + (x - item.xFrom) * percent;

                    if (ctx.polarAxisCoords) {
                        var point = this._toPolarCoord(ctx.polarAxisCoords, this._plotRect, x, y);
                        x = point.x;
                        y = point.y;
                    }

                    x = $.jqx._ptrnd(x);
                    y = $.jqx._ptrnd(y);
                    r = $.jqx._ptrnd(r);

                    var elementRenderInfo = this._getRenderInfo(ctx.groupIndex, ctx.seriesIndex, items[i].itemIndex);
                    var element = elementRenderInfo.element;
                    var labelElement = elementRenderInfo.labelElement;

                    if (symbolType == 'circle') {
                        if (!element) {
                            element = this.renderer.circle(x, y, r);
                            this.renderer.attr(element, { fill: item.fill, 'fill-opacity': ctx['fill-opacity'], 'stroke-opacity': ctx['fill-opacity'], stroke: item.stroke, 'stroke-width': ctx['stroke-width'], 'stroke-dasharray': ctx['stroke-dasharray'] });
                        }

                        if (this._isVML) {
                            this.renderer.updateCircle(element, undefined, undefined, r);
                        }
                        else {
                            this.renderer.attr(element, { r: r, cy: y, cx: x });
                        }
                    }
                    else {
                        if (element)
                            this.renderer.removeElement(element);

                        element = this._drawSymbol(
                            symbolType,
                            x,
                            y,
                            item.fill,
                            ctx['fill-opacity'],
                            item.stroke,
                            ctx['stroke-opacity'] || ctx['fill-opacity'],
                            ctx['stroke-width-symbol'],
                            ctx['stroke-dasharray'],
                            symbolSize || r);
                    }

                    if (labelElement)
                        this.renderer.removeElement(labelElement);

                    labelElement = this._showLabel(ctx.groupIndex, ctx.seriesIndex, item.itemIndex, { x: x - r, y: y - r, width: 2 * r, height: 2 * r });

                    if (percent >= 1)
                        this._installHandlers(element, 'circle', ctx.groupIndex, ctx.seriesIndex, item.itemIndex);

                    this._setRenderInfo(ctx.groupIndex, ctx.seriesIndex, items[i].itemIndex, { element: element, labelElement: labelElement });
                }
            },

            _showMultiSeriesToolTip: function (x, y, iidx) {
                var self = this;

                var content = "<div style=\"text-align:left\">";

                var prevXAxisText = '';
                for (var gidx = 0; gidx < self.seriesGroups.length; gidx++) {
                    if (self._isPieGroup(gidx))
                        continue;

                    var xAxis = self._getXAxis(gidx);
                    var yAxis = self._getValueAxis(gidx);

                    var group = self.seriesGroups[gidx];

                    var xAxisSettings = this._getAxisSettings(xAxis);
                    var xAxisFS = xAxisSettings.toolTipFormatSettings;
                    var xAxisFF = xAxisSettings.toolTipFormatFunction;

                    var xAxisValue = self._getDataValue(iidx, xAxis.dataField, gidx);
                    if (xAxis.dataField == undefined || xAxis.dataField == '')
                        xAxisValue = iidx;
                    if (xAxis.type == 'date')
                        xAxisValue = self._castAsDate(xAxisValue, (xAxisFS ? xAxisFS.dateFormat : undefined) || xAxis.dateFormat);


                    if (!xAxisFF && !xAxisFS && xAxis.type == 'date')
                        xAxisFF = this._getDefaultDTFormatFn(xAxis.baseUnit || 'day');

                    var xAxisDisplayText = (xAxis.displayText || xAxis.dataField || '');
                    if (xAxisDisplayText != '')
                        xAxisDisplayText += ': ';

                    var xAxisText = xAxisDisplayText + self._formatValue(xAxisValue, xAxisFS, xAxisFF, gidx, sidx, iidx);

                    if (prevXAxisText != xAxisText) {
                        if (prevXAxisText != '')
                            content += '<br />';
                        content += xAxisText + '<br /><br />';
                        prevXAxisText = xAxisText;
                    }

                    for (var sidx = 0; sidx < group.series.length; sidx++) {
                        var serie = group.series[sidx];

                        if (group.showToolTips == false || serie.showToolTips == false)
                            continue;

                        if (!self._isSerieVisible(gidx, sidx))
                            continue;

                        var valfs = self._get([serie.toolTipFormatSettings, group.toolTipFormatSettings, yAxis.toolTipFormatSettings, self.toolTipFormatSettings]);
                        var valff = self._get([serie.toolTipFormatFunction, group.toolTipFormatFunction, yAxis.toolTipFormatFunction, self.toolTipFormatFunction]);

                        var serieValueText = self._getFormattedValue(gidx, sidx, iidx, valfs, valff);

                        var colors = self._getColors(gidx, sidx, iidx);

                        content += "<span style='color:" + colors.lineColor + ";'>" + serieValueText + '</span><br />\n';

                    }
                }

                var cssToolTip = this._get([self.toolTipClass, this.toThemeProperty('jqx-chart-tooltip-text', null)]);
                var toolTipFill = this._get([self.toolTipBackground, '#FFFFFF']);
                var toolTipStroke = this._get([self.toolTipLineColor, self._defaultLineColor]);
                var toolTipFillOpacity = this._get([self.toolTipOpacity, 1]);


                content += "</div>";

                var coord = this.getItemCoord(self._ttEl.gidx, self._ttEl.sidx, self._ttEl.iidx);

                self._createTooltip(coord, self.seriesGroups[self._ttEl.gidx], content, { css: cssToolTip, fill: toolTipFill, stroke: toolTipStroke, fillOpacity: toolTipFillOpacity, symbolSize: 3 });
            },

            /** @private */
            _showToolTip: function (x, y, gidx, sidx, iidx) {
                var self = this;
                var xAxis = self._getXAxis(gidx);
                var yAxis = self._getValueAxis(gidx);

                if (self._ttEl &&
                    gidx == self._ttEl.gidx &&
                    sidx == self._ttEl.sidx &&
                    iidx == self._ttEl.iidx)
                    return;

                var group = self.seriesGroups[gidx];
                var series = group.series[sidx];

                var enableCrosshairs = self.enableCrosshairs;

                if (self._pointMarker) {
                    // make it relative to the marker instead of cursor
                    x = parseInt(self._pointMarker.x + 5);
                    y = parseInt(self._pointMarker.y - 5);
                }
                else {
                    enableCrosshairs = false;
                }

                var isCrossHairsOnly = enableCrosshairs && self.showToolTips == false;


                x = $.jqx._ptrnd(x);
                y = $.jqx._ptrnd(y);

                var isNew = self._ttEl == undefined;

                if (group.showToolTips == false || series.showToolTips == false)
                    return;

                if (!self._ttEl) {
                    self._ttEl = {};
                }

                self._ttEl.sidx = sidx;
                self._ttEl.gidx = gidx;
                self._ttEl.iidx = iidx;

                var seriesCount = 0;
                for (var i = 0; i < self.seriesGroups.length; i++)
                    for (var j = 0; j < self.seriesGroups[i].series.length; j++)
                        seriesCount++;

                if (self.showToolTipsOnAllSeries &&
                    !self._isPieGroup(gidx) &&
                    seriesCount > 1
                ) {
                    self._showMultiSeriesToolTip(x, y, iidx);
                    return;
                }


                var valfs = self._get([series.toolTipFormatSettings, group.toolTipFormatSettings, yAxis.toolTipFormatSettings, self.toolTipFormatSettings]);
                var valff = self._get([series.toolTipFormatFunction, group.toolTipFormatFunction, yAxis.toolTipFormatFunction, self.toolTipFormatFunction]);

                var colors = self._getColors(gidx, sidx, iidx);

                var xAxisValue = self._getDataValue(iidx, xAxis.dataField, gidx);
                if (xAxis.dataField == undefined || xAxis.dataField == '')
                    xAxisValue = iidx;
                if (xAxis.type == 'date')
                    xAxisValue = self._castAsDate(xAxisValue, (valfs ? valfs.dateFormat : undefined) || xAxis.dateFormat);

                var text = '';

                if ($.isFunction(valff)) {
                    var value = {};
                    var cnt = 0;
                    for (var field in series)
                        if (field.indexOf('dataField') == 0) {
                            value[field.substring(9, field.length).toLowerCase()] = self._getDataValue(iidx, series[field], gidx);
                            cnt++;
                        }

                    if (cnt == 0)
                        value = self._getDataValue(iidx, undefined, gidx);
                    else if (cnt == 1)
                        value = value[''];

                    text = valff(value, iidx, series, group, xAxisValue, xAxis);
                }
                else {
                    text = self._getFormattedValue(gidx, sidx, iidx, valfs, valff);

                    var xAxisSettings = this._getAxisSettings(xAxis);

                    var catfs = xAxisSettings.toolTipFormatSettings;
                    var catff = xAxisSettings.toolTipFormatFunction;

                    if (!catff && !catfs && xAxis.type == 'date')
                        catff = this._getDefaultDTFormatFn(xAxis.baseUnit || 'day');

                    var categoryText = self._formatValue(xAxisValue, catfs, catff, gidx, sidx, iidx);

                    if (!self._isPieGroup(gidx)) {
                        var t = (xAxis.displayText || xAxis.dataField || '');
                        if (t.length > 0)
                            text = t + ': ' + categoryText + '<br>' + text;
                        else
                            text = categoryText + '<br>' + text;
                    }
                    else {
                        xAxisValue = self._getDataValue(iidx, series.displayText || series.dataField, gidx);
                        categoryText = self._formatValue(xAxisValue, catfs, catff, gidx, sidx, iidx);
                        text = categoryText + ': ' + text;
                    }
                }

                var rect = self.renderer.getRect();

                if (enableCrosshairs) {
                    var _x = $.jqx._ptrnd(self._pointMarker.x);
                    var _y = $.jqx._ptrnd(self._pointMarker.y);
                    var color = self.crosshairsColor || self._defaultLineColor;

                    if (group.polar || group.spider) {
                        var polarCoords = this._getPolarAxisCoords(gidx, this._plotRect);

                        var dist = $.jqx._ptdist(_x, _y, polarCoords.x, polarCoords.y);
                        if (dist > polarCoords.r)
                            return;

                        var posAngle = Math.atan2(_y - polarCoords.y, _x - polarCoords.x);
                        var x2 = Math.cos(posAngle) * polarCoords.r + polarCoords.x;
                        var y2 = Math.sin(posAngle) * polarCoords.r + polarCoords.y;

                        if (self._ttEl.vLine)
                            self.renderer.attr(self._ttEl.vLine, { x1: polarCoords.x, y1: polarCoords.y, x2: x2, y2: y2 });
                        else
                            self._ttEl.vLine = self.renderer.line(polarCoords.x, polarCoords.y, x2, y2, { stroke: color, 'stroke-width': self.crosshairsLineWidth || 1.0, 'stroke-dasharray': self.crosshairsDashStyle || '' });
                    }
                    else {
                        if (self._ttEl.vLine && self._ttEl.hLine) {
                            self.renderer.attr(self._ttEl.vLine, { x1: _x, x2: _x });
                            self.renderer.attr(self._ttEl.hLine, { y1: _y, y2: _y });
                        }
                        else {
                            self._ttEl.vLine = self.renderer.line(_x, self._plotRect.y, _x, self._plotRect.y + self._plotRect.height, { stroke: color, 'stroke-width': self.crosshairsLineWidth || 1.0, 'stroke-dasharray': self.crosshairsDashStyle || '' });
                            self._ttEl.hLine = self.renderer.line(self._plotRect.x, _y, self._plotRect.x + self._plotRect.width, _y, { stroke: color, 'stroke-width': self.crosshairsLineWidth || 1.0, 'stroke-dasharray': self.crosshairsDashStyle || '' });
                        }
                    }
                }

                if (!isCrossHairsOnly && self.showToolTips != false) {
                    var cssToolTip = this._get([series.toolTipClass, group.toolTipClass, self.toolTipClass, this.toThemeProperty('jqx-chart-tooltip-text', null)]);
                    var toolTipFill = this._get([series.toolTipBackground, group.toolTipBackground, self.toolTipBackground, '#FFFFFF']);
                    var toolTipStroke = this._get([series.toolTipLineColor, group.toolTipLineColor, self.toolTipLineColor, colors.lineColor]);
                    var toolTipFillOpacity = this._get([series.toolTipOpacity, group.toolTipOpacity, self.toolTipOpacity, 1]);

                    var coord = this.getItemCoord(gidx, sidx, iidx);

                    var symbolSize = 0;

                    if (self._pointMarker && self._pointMarker.element) {
                        symbolSize = series.symbolSizeSelected;
                        if (isNaN(symbolSize))
                            symbolSize = series.symbolSize;
                        if (isNaN(symbolSize) || symbolSize > 50 || symbolSize < 0)
                            symbolSize = group.symbolSize;
                        if (isNaN(symbolSize) || symbolSize > 50 || symbolSize < 0)
                            symbolSize = 8;
                    }

                    self._createTooltip(coord, group, text, { css: cssToolTip, fill: toolTipFill, stroke: toolTipStroke, fillOpacity: toolTipFillOpacity, symbolSize: symbolSize });
                }
            },

            _fitTooltip: function (bounds, elementRect, rect, group, symbolSize) {
                var fitOptions = {};

                var space = 2 + symbolSize / 2;
                var arrowSize = 7;

                //try fit left
                if (elementRect.x - rect.width - arrowSize - space > bounds.x &&
                    elementRect.y + elementRect.height / 2 - rect.height / 2 > bounds.y &&
                    elementRect.y + elementRect.height / 2 + rect.height / 2 < bounds.y + bounds.height) {

                    fitOptions.left = {
                        arrowLocation: 'right',
                        x: elementRect.x - rect.width - arrowSize - space,
                        y: elementRect.y + elementRect.height / 2 - rect.height / 2,
                        width: rect.width + arrowSize,
                        height: rect.height
                    };
                }

                //try fit right
                if (elementRect.x + elementRect.width + rect.width + arrowSize + space < bounds.x + bounds.width &&
                    elementRect.y + elementRect.height / 2 - rect.height / 2 > bounds.y &&
                    elementRect.y + elementRect.height / 2 + rect.height / 2 < bounds.y + bounds.height) {

                    fitOptions.right = {
                        arrowLocation: 'left',
                        x: elementRect.x + elementRect.width + space,
                        y: elementRect.y + elementRect.height / 2 - rect.height / 2,
                        width: rect.width + arrowSize,
                        height: rect.height
                    };
                }

                //try fit top
                if (elementRect.y - rect.height - space - arrowSize > bounds.y &&
                    elementRect.x + elementRect.width / 2 - rect.width / 2 > bounds.x &&
                    elementRect.x + elementRect.width / 2 + rect.width / 2 < bounds.x + bounds.width) {

                    fitOptions.top = {
                        arrowLocation: 'bottom',
                        x: elementRect.x + elementRect.width / 2 - rect.width / 2,
                        y: elementRect.y - rect.height - space - arrowSize,
                        width: rect.width,
                        height: rect.height + arrowSize
                    };
                }

                //try fit bottom
                if (elementRect.y + elementRect.height + rect.height + arrowSize + space < bounds.y + bounds.height &&
                    elementRect.x + elementRect.width / 2 - rect.width / 2 > bounds.x &&
                    elementRect.x + elementRect.width / 2 + rect.width / 2 < bounds.x + bounds.width) {

                    fitOptions.bottom = {
                        arrowLocation: 'top',
                        x: elementRect.x + elementRect.width / 2 - rect.width / 2,
                        y: elementRect.y + elementRect.height + space,
                        width: rect.width,
                        height: rect.height + arrowSize
                    };
                }

                if (elementRect.width > elementRect.height ||
                    ((group.type.indexOf('stackedcolumn') != -1 || group.type.indexOf('stackedwaterfall') != -1) && group.orientation != 'horizontal')

                ) {
                    if (fitOptions.left)
                        return fitOptions.left;
                    if (fitOptions.right)
                        return fitOptions.right;
                }
                else {
                    if (fitOptions.top)
                        return fitOptions.top
                    if (fitOptions.bottom)
                        return fitOptions.bottom
                }

                for (var i in fitOptions) {
                    if (fitOptions[i])
                        return fitOptions[i];
                }

                return { arrowLocation: '' }
            },

            /** @private */
            _createTooltip: function (position, group, content, style) {
                var self = this;

                var groupType = group.type;

                // create tooltip elements
                var isNew = false;

                var divToolTip = self._ttEl.box;
                if (!divToolTip) {
                    isNew = true;

                    divToolTip = self._ttEl.box = document.createElement("div");

                    var baseZIndex = 10000000;

                    divToolTip.style.position = 'absolute';
                    divToolTip.style.cursor = 'default';
                    $(arrowOuterDiv).css({ 'z-index': baseZIndex, 'box-sizing': 'content-box' });
                    $(divToolTip).css({ 'z-index': baseZIndex });
                    $(document.body).append(divToolTip);

                    var arrowOuterDiv = document.createElement("div");
                    arrowOuterDiv.id = 'arrowOuterDiv';
                    arrowOuterDiv.style.width = '0px';
                    arrowOuterDiv.style.height = '0px';
                    arrowOuterDiv.style.position = 'absolute';
                    $(arrowOuterDiv).css({ 'z-index': baseZIndex + 1, 'box-sizing': 'content-box' });

                    var arrowInnerDiv = document.createElement("div");
                    arrowInnerDiv.id = 'arrowInnerDiv';
                    arrowInnerDiv.style.width = '0px';
                    arrowInnerDiv.style.height = '0px';
                    arrowInnerDiv.style.position = 'absolute';

                    var contentDiv = document.createElement("div");
                    contentDiv.id = 'contentDiv';
                    contentDiv.style.position = 'absolute';
                    $(contentDiv).css({ 'box-sizing': 'content-box', outline: 'none', border: '1px solid transparent', padding: '3px', 'text-align': 'center', 'vertical-align': 'middle', margin: '0 0 0 0', cursor: 'default' });

                    $(contentDiv).addClass('jqx-rc-all');
                    $(contentDiv).appendTo($(divToolTip));
                    $(arrowOuterDiv).appendTo($(divToolTip));
                    $(arrowInnerDiv).appendTo($(divToolTip));
                    $(arrowInnerDiv).css({ 'z-index': baseZIndex + 2, 'box-sizing': 'content-box' });

                }

                if (!content || content.length == 0) {
                    $(divToolTip).fadeTo(0, 0);
                    return;
                }

                contentDiv = $(divToolTip).find('#contentDiv')[0];
                arrowOuterDiv = $(divToolTip).find('#arrowOuterDiv')[0];
                arrowInnerDiv = $(divToolTip).find('#arrowInnerDiv')[0];
                arrowInnerDiv.style.opacity = arrowOuterDiv.style.opacity = style.fillOpacity;


                // set styles and content
                contentDiv.style.backgroundColor = style.fill;
                contentDiv.style.borderColor = style.stroke;
                contentDiv.style.opacity = style.fillOpacity;

                var html = "<span class='" + style.css + "'>" + content + "</span>";
                $(contentDiv).html(html);

                var size = this._measureHtml(html, 'jqx-rc-all jqx-button');

                // calculate tooltip positioning and arrow location
                var rect = self._plotRect;

                if (size.width > rect.width || size.height > rect.height)
                    return;

                var totalSize = { width: size.width, height: size.height };

                var arrowLocation = '';
                var space = 5;
                var arrowSize = 7;

                var isColumn = self._isColumnType(groupType);

                var x = Math.max(position.x, rect.x);
                var y = Math.max(position.y, rect.y);

                if (self.toolTipAlignment == 'dataPoint') {
                    if (groupType.indexOf('pie') != -1 || groupType.indexOf('donut') != -1) {
                        var midAngle = (position.fromAngle + position.toAngle) / 2;
                        midAngle = midAngle * (Math.PI / 180);

                        var radius = (!isNaN(position.innerRadius) && position.innerRadius > 0) ? (position.innerRadius + position.outerRadius) / 2 : position.outerRadius * 0.75;

                        x = position.x = position.center.x + Math.cos(midAngle) * radius;
                        y = position.y = position.center.y - Math.sin(midAngle) * radius;
                        position.width = position.height = 1;
                    }
                    else if (isColumn && (group.polar || group.spider)) {
                        position.width = position.height = 1;
                    }

                    var ttFit = this._fitTooltip(this._plotRect, position, totalSize, group, style.symbolSize);
                    if (ttFit.arrowLocation != '') {
                        arrowLocation = ttFit.arrowLocation;
                        x = ttFit.x;
                        y = ttFit.y;
                        totalSize.width = ttFit.width;
                        totalSize.height = ttFit.height;
                    }
                }
                else {
                    arrowLocation = '';
                }

                if (arrowLocation == 'top' || arrowLocation == 'bottom') {
                    totalSize.height += arrowSize;
                    x -= arrowSize / 2;
                    if (arrowLocation == 'bottom')
                        y -= arrowSize;
                }
                else if (arrowLocation == 'left' || arrowLocation == 'right') {
                    totalSize.width += arrowSize;
                    y -= arrowSize / 2;
                    if (arrowLocation == 'right')
                        x -= arrowSize;
                }

                if (x + totalSize.width > rect.x + rect.width) {
                    arrowLocation = '';
                    x = rect.x + rect.width - totalSize.width;
                }

                if (y + totalSize.height > rect.y + rect.height) {
                    arrowLocation = '';
                    y = rect.y + rect.height - totalSize.height;
                }

                // set arrow and content position
                var arrowPosition = { x: 0, y: 0 }, contentPosition = { x: 0, y: 0 };
                $(contentDiv).css({ width: size.width, height: size.height, left: 0, top: 0 });

                arrowOuterDiv.style['margin-top'] = arrowOuterDiv.style['margin-left'] = 0;
                arrowInnerDiv.style['margin-top'] = arrowInnerDiv.style['margin-left'] = 0;
                contentDiv.style['margin-top'] = contentDiv.style['margin-left'] = 0;

                var arrowSizeSolid = arrowSize + 'px solid';
                var arrowSizeSolidTransparent = arrowSize + 'px solid transparent';

                switch (arrowLocation) {
                    case 'left':
                        arrowPosition = { x: 0, y: (size.height - arrowSize) / 2 };
                        contentPosition = { x: arrowSize, y: 0 };
                        contentDiv.style['margin-left'] = arrowSize + 'px';

                        arrowOuterDiv.style['margin-left'] = 0 + 'px';
                        arrowOuterDiv.style['margin-top'] = arrowPosition.y + 'px';

                        arrowOuterDiv.style['border-left'] = '';
                        arrowOuterDiv.style['border-right'] = arrowSizeSolid + ' ' + style.stroke;
                        arrowOuterDiv.style['border-top'] = arrowSizeSolidTransparent;
                        arrowOuterDiv.style['border-bottom'] = arrowSizeSolidTransparent;

                        arrowInnerDiv.style['margin-left'] = 1 + 'px';
                        arrowInnerDiv.style['margin-top'] = arrowPosition.y + 'px';
                        arrowInnerDiv.style['border-left'] = '';
                        arrowInnerDiv.style['border-right'] = arrowSizeSolid + ' ' + style.fill;
                        arrowInnerDiv.style['border-top'] = arrowSizeSolidTransparent;
                        arrowInnerDiv.style['border-bottom'] = arrowSizeSolidTransparent;
                        break;
                    case 'right':
                        arrowPosition = { x: totalSize.width - arrowSize, y: (size.height - arrowSize) / 2 };
                        contentPosition = { x: 0, y: 0 };

                        arrowOuterDiv.style['margin-left'] = arrowPosition.x + 'px';
                        arrowOuterDiv.style['margin-top'] = arrowPosition.y + 'px';

                        arrowOuterDiv.style['border-left'] = arrowSizeSolid + ' ' + style.stroke;
                        arrowOuterDiv.style['border-right'] = '';
                        arrowOuterDiv.style['border-top'] = arrowSizeSolidTransparent;
                        arrowOuterDiv.style['border-bottom'] = arrowSizeSolidTransparent;

                        arrowInnerDiv.style['margin-left'] = arrowPosition.x - 1 + 'px';
                        arrowInnerDiv.style['margin-top'] = arrowPosition.y + 'px';

                        arrowInnerDiv.style['border-left'] = arrowSizeSolid + ' ' + style.fill;
                        arrowInnerDiv.style['border-right'] = '';
                        arrowInnerDiv.style['border-top'] = arrowSizeSolidTransparent;
                        arrowInnerDiv.style['border-bottom'] = arrowSizeSolidTransparent;

                        break;
                    case 'top':
                        arrowPosition = { x: totalSize.width / 2 - arrowSize / 2, y: 0 };
                        contentPosition = { x: 0, y: arrowSize };

                        contentDiv.style['margin-top'] = contentPosition.y + 'px';
                        arrowOuterDiv.style['margin-left'] = arrowPosition.x + 'px';

                        arrowOuterDiv.style['border-top'] = '';
                        arrowOuterDiv.style['border-bottom'] = arrowSizeSolid + ' ' + style.stroke;
                        arrowOuterDiv.style['border-left'] = arrowSizeSolidTransparent;
                        arrowOuterDiv.style['border-right'] = arrowSizeSolidTransparent;

                        arrowInnerDiv.style['margin-left'] = arrowPosition.x + 'px';
                        arrowInnerDiv.style['margin-top'] = 1 + 'px';
                        arrowInnerDiv.style['border-top'] = '';
                        arrowInnerDiv.style['border-bottom'] = arrowSizeSolid + ' ' + style.fill;
                        arrowInnerDiv.style['border-left'] = arrowSizeSolidTransparent;
                        arrowInnerDiv.style['border-right'] = arrowSizeSolidTransparent;
                        break;
                    case 'bottom':
                        arrowPosition = { x: totalSize.width / 2 - arrowSize / 2, y: totalSize.height - arrowSize };
                        contentPosition = { x: 0, y: 0 }

                        arrowOuterDiv.style['margin-left'] = arrowPosition.x + 'px';
                        arrowOuterDiv.style['margin-top'] = arrowPosition.y + 'px';

                        arrowOuterDiv.style['border-top'] = arrowSizeSolid + ' ' + style.stroke;
                        arrowOuterDiv.style['border-bottom'] = '';
                        arrowOuterDiv.style['border-left'] = arrowSizeSolidTransparent;
                        arrowOuterDiv.style['border-right'] = arrowSizeSolidTransparent;

                        arrowInnerDiv.style['margin-left'] = arrowPosition.x + 'px';
                        arrowInnerDiv.style['margin-top'] = arrowPosition.y - 1 + 'px';
                        arrowInnerDiv.style['border-top'] = arrowSizeSolid + ' ' + style.fill;
                        arrowInnerDiv.style['border-bottom'] = '';
                        arrowInnerDiv.style['border-left'] = arrowSizeSolidTransparent;
                        arrowInnerDiv.style['border-right'] = arrowSizeSolidTransparent;

                        break;
                }

                if (arrowLocation == '') {
                    $(arrowOuterDiv).hide();
                    $(arrowInnerDiv).hide();
                }
                else {
                    $(arrowOuterDiv).show();
                    $(arrowInnerDiv).show();
                }

                // update size
                $(divToolTip).css({ width: totalSize.width + 'px', height: totalSize.height + 'px' });

                var hostPosition = self.host.coord();
                if (isNew) {
                    $(divToolTip).fadeOut(0, 0);
                    divToolTip.style.left = x + hostPosition.left + 'px';
                    divToolTip.style.top = y + hostPosition.top + 'px';
                }

                $(divToolTip).clearQueue();
                $(divToolTip).animate({ left: x + hostPosition.left, top: y + hostPosition.top, opacity: 1 }, self.toolTipMoveDuration, 'easeInOutCirc');
                $(divToolTip).fadeTo(400, 1);
            },

            /** @private */
            _measureHtml: function (html, cssClass) {
                var measureDiv = this._measureDiv;

                if (!measureDiv) {
                    this._measureDiv = measureDiv = document.createElement("div");
                    measureDiv.style.position = 'absolute';
                    measureDiv.style.cursor = 'default';
                    measureDiv.style.overflow = 'hidden';
                    measureDiv.style.display = 'none';
                    $(measureDiv).addClass(cssClass);
                    this.host.append(measureDiv);
                }

                $(measureDiv).html(html);
                var sz = { width: $(measureDiv).width() + 2, height: $(measureDiv).height() + 2 };
                if ($.jqx.browser && $.jqx.browser.mozilla) {
                    sz.height += 3;
                }

                return sz;
            },

            /** @private */
            _hideToolTip: function (delay) {
                if (!this._ttEl)
                    return;

                if (this._ttEl.box) {
                    if (delay == 0)
                        $(this._ttEl.box).hide();
                    else
                        $(this._ttEl.box).fadeOut();
                }

                this._hideCrosshairs();

                this._ttEl.gidx = undefined;

            },

            /** @private */
            _hideCrosshairs: function () {
                if (!this._ttEl)
                    return;

                if (this._ttEl.vLine) {
                    this.renderer.removeElement(this._ttEl.vLine);
                    this._ttEl.vLine = undefined;
                }

                if (this._ttEl.hLine) {
                    this.renderer.removeElement(this._ttEl.hLine);
                    this._ttEl.hLine = undefined;
                }
            },

            _get: function (arr) {
                return $.jqx.getByPriority(arr);
            },

            _getAxisSettings: function (axis) {
                if (!axis)
                    return {};

                var self = this;

                // grid lines settings
                var gridLinesProperties = axis.gridLines || {};

                var gridLinesSettings = {
                    visible: this._get([gridLinesProperties.visible, axis.showGridLines, true]),
                    color: self._get([gridLinesProperties.color, axis.gridLinesColor, self._defaultLineColor]),
                    unitInterval: self._get([gridLinesProperties.unitInterval, gridLinesProperties.interval, axis.gridLinesInterval]),
                    step: self._get([gridLinesProperties.step, axis.gridLinesStep]),
                    dashStyle: self._get([gridLinesProperties.dashStyle, axis.gridLinesDashStyle]),
                    width: self._get([gridLinesProperties.lineWidth, 1]),
                    offsets: [],
                    alternatingBackgroundColor: axis.alternatingBackgroundColor,
                    alternatingBackgroundColor2: axis.alternatingBackgroundColor2,
                    alternatingBackgroundOpacity: axis.alternatingBackgroundOpacity
                };

                // tick marks settings
                var tickMarksProperties = axis.tickMarks || {};
                var tickMarksSettings =
                {
                    visible: this._get([tickMarksProperties.visible, axis.showTickMarks, true]),
                    color: self._get([tickMarksProperties.color, axis.tickMarksColor, self._defaultLineColor]),
                    unitInterval: self._get([tickMarksProperties.unitInterval, tickMarksProperties.interval, axis.tickMarksInterval]),
                    step: self._get([tickMarksProperties.step, axis.tickMarksStep]),
                    dashStyle: self._get([tickMarksProperties.dashStyle, axis.tickMarksDashStyle]),
                    width: self._get([tickMarksProperties.lineWidth, 1]),
                    size: self._get([tickMarksProperties.size, 4]),
                    offsets: []
                };

                // title settings
                var titleProperties = axis.title || {};

                var titleSettings =
                {
                    visible: self._get([titleProperties.visible, true]),
                    text: self._get([axis.description, titleProperties.text]),
                    style: self._get([axis.descriptionClass, titleProperties['class'], self.toThemeProperty('jqx-chart-axis-description', null)]),
                    halign: self._get([axis.horizontalDescriptionAlignment, titleProperties.horizontalAlignment, 'center']),
                    valign: self._get([axis.verticalDescriptionAlignment, titleProperties.verticalAlignment, 'center']),
                    angle: 0,
                    rotationPoint: self._get([titleProperties.rotationPoint, 'centercenter']),
                    offset: self._get([titleProperties.offset, { x: 0, y: 0 }])
                };

                var lineProperties = axis.line || {};
                var lineSettings =
                {
                    visible: self._get([lineProperties.visible, true]),
                    color: self._get([lineProperties.color, gridLinesSettings.color, self._defaultLineColor]),
                    dashStyle: self._get([lineProperties.dashStyle, gridLinesSettings.dashStyle, '']),
                    width: self._get([lineProperties.lineWidth, 1]),
                    angle: self._get([lineProperties.angle, NaN])
                };

                var padding = axis.padding || {};

                padding = {
                    left: padding.left || 0,
                    right: padding.right || 0,
                    top: padding.top || 0,
                    bottom: padding.bottom || 0
                };

                var labelsSettings = this._getAxisLabelsSettings(axis);

                var result =
                {
                    visible: this._get([axis.visible, axis.showValueAxis, axis.showXAxis, axis.showCategoryAxis, true]),
                    customDraw: this._get([axis.customDraw, false]),
                    gridLines: gridLinesSettings,
                    tickMarks: tickMarksSettings,
                    line: lineSettings,
                    title: titleSettings,
                    labels: labelsSettings,
                    padding: padding,
                    toolTipFormatFunction: this._get([axis.toolTipFormatFunction, axis.formatFunction, labelsSettings.formatFunction]),
                    toolTipFormatSettings: this._get([axis.toolTipFormatSettings, axis.formatSettings, labelsSettings.formatSettings])
                };

                return result;
            },

            _getAxisLabelsSettings: function (axis) {
                var self = this;

                var labels = axis.labels || {};

                var settings = {
                    visible: self._get([axis.showLabels, labels.visible, true]),
                    unitInterval: self._get([labels.unitInterval, labels.interval, axis.labelsInterval]),
                    step: self._get([labels.step, axis.labelsStep]),
                    angle: self._get([axis.textRotationAngle, labels.angle, 0]),
                    style: self._get([axis['class'], labels['class'], self.toThemeProperty('jqx-chart-axis-text', null)]),
                    halign: self._get([axis.horizontalTextAlignment, labels.horizontalAlignment, 'center']),
                    valign: self._get([axis.verticalTextAlignment, labels.verticalAlignment, 'center']),
                    textRotationPoint: self._get([axis.textRotationPoint, labels.rotationPoint, 'auto']),
                    textOffset: self._get([axis.textOffset, labels.offset, { x: 0, y: 0 }]),
                    autoRotate: self._get([axis.labelsAutoRotate, labels.autoRotate, false]),
                    formatSettings: self._get([axis.formatSettings, labels.formatSettings, undefined]),
                    formatFunction: self._get([axis.formatFunction, labels.formatFunction, undefined])
                };

                return settings;
            },

            _getLabelsSettings: function (gidx, sidx, iidx, options) {
                var g = this.seriesGroups[gidx];
                var s = g.series[sidx];
                var value = isNaN(iidx) ? undefined : this._getDataValue(iidx, s.dataField, gidx);

                var properties = options || [
                    'Visible',
                    'Offset',
                    'Angle',
                    'HorizontalAlignment',
                    'VerticalAlignment',
                    'Class',
                    'BackgroundColor',
                    'BorderColor',
                    'BorderOpacity',
                    'Padding',
                    'Opacity',
                    'BackgroundOpacity',
                    'LinesAngles',
                    'LinesEnabled',
                    'AutoRotate',
                    'Radius'
                ];

                var result = {};
                for (var i = 0; i < properties.length; i++) {
                    var key = properties[i];
                    var name = 'labels' + key;
                    var altName = 'label' + key;
                    var altName2 = key.substring(0, 1).toLowerCase() + key.substring(1);

                    var propValue = undefined;
                    if (g.labels && typeof (g.labels) == 'object')
                        propValue = g.labels[altName2];

                    if (s.labels && typeof (s.labels) == 'object' && undefined != s.labels[altName2])
                        propValue = s.labels[altName2];

                    propValue = this._get([s[name], s[altName], propValue, g[name], g[altName]]);

                    if ($.isFunction(propValue))
                        result[altName2] = propValue(value, iidx, s, g);
                    else
                        result[altName2] = propValue;
                }

                result['class'] = result['class'] || this.toThemeProperty('jqx-chart-label-text', null);

                result['visible'] = this._get([result['visible'], s.showLabels, g.showLabels, s.labels != undefined ? true : undefined, g.labels != undefined ? true : undefined]);

                var paddingValue = result['padding'] || 1;

                result['padding'] = {
                    left: this._get([paddingValue.left, isNaN(paddingValue) ? 1 : paddingValue]),
                    right: this._get([paddingValue.right, isNaN(paddingValue) ? 1 : paddingValue]),
                    top: this._get([paddingValue.top, isNaN(paddingValue) ? 1 : paddingValue]),
                    bottom: this._get([paddingValue.bottom, isNaN(paddingValue) ? 1 : paddingValue])
                }

                return result;
            },

            /** @private */
            _showLabel: function (gidx, sidx, iidx, rect, halign, valign, isMeasure, inverseHAlign, inverseVAlign, labelAngleOverride, renderedRect) {
                var group = this.seriesGroups[gidx];
                var series = group.series[sidx];
                var sz = { width: 0, height: 0 }, szSave;

                if (isNaN(iidx))
                    return;

                var settings = this._getLabelsSettings(gidx, sidx, iidx);

                if (!settings.visible)
                    return isMeasure ? sz : undefined;

                if (rect.width < 0 || rect.height < 0)
                    return isMeasure ? sz : undefined;

                var labelsAngle = settings.angle;
                if (!isNaN(labelAngleOverride))
                    labelsAngle = labelAngleOverride;

                var offset = settings.offset || {};
                var labelOffset = { x: offset.x, y: offset.y };
                if (isNaN(labelOffset.x))
                    labelOffset.x = 0;
                if (isNaN(labelOffset.y))
                    labelOffset.y = 0;

                halign = halign || settings.horizontalAlignment || 'center';
                valign = valign || settings.verticalAlignment || 'center';

                var text = this._getFormattedValue(gidx, sidx, iidx, undefined, undefined, true);

                var w = rect.width;
                var h = rect.height;

                if (inverseHAlign == true && halign != 'center')
                    halign = halign == 'right' ? 'left' : 'right';

                if (inverseVAlign == true && valign != 'center' && valign != 'middle') {
                    valign = valign == 'top' ? 'bottom' : 'top';
                    labelOffset.y *= -1;
                }

                sz = this.renderer.measureText(text, labelsAngle, { 'class': settings['class'] });

                if (isMeasure)
                    return sz;

                var x = 0, y = 0;

                if (w > 0) {
                    if (halign == '' || halign == 'center')
                        x += (w - sz.width) / 2;
                    else if (halign == 'right')
                        x += (w - sz.width);
                }

                if (h > 0) {
                    if (valign == '' || valign == 'center')
                        y += (h - sz.height) / 2;
                    else if (valign == 'bottom')
                        y += (h - sz.height);
                }

                x += rect.x + labelOffset.x;
                y += rect.y + labelOffset.y;

                var plotRect = this._plotRect;

                if (x <= plotRect.x)
                    x = plotRect.x + 2;

                if (y <= plotRect.y)
                    y = plotRect.y + 2;

                var labelSize = { width: Math.max(sz.width, 1), height: Math.max(sz.height, 1) };

                if (y + labelSize.height >= plotRect.y + plotRect.height)
                    y = plotRect.y + plotRect.height - (szSave ? (labelSize.height + szSave.height) / 2 : labelSize.height) - 2;

                if (x + labelSize.width >= plotRect.x + plotRect.width)
                    x = plotRect.x + plotRect.width - labelSize.width - 2;

                var renderGroup;

                var labelsBackground = settings.backgroundColor;
                var labelsBorder = settings.borderColor;

                var padding = settings.padding;
                if (labelsBackground || labelsBorder) {
                    renderGroup = this.renderer.beginGroup();

                    var rect = this.renderer.rect(
                        x - padding.left,
                        y - padding.top,
                        sz.width + padding.left + padding.right,
                        sz.height + padding.bottom + padding.bottom,
                        {
                            fill: labelsBackground || 'transparent',
                            'fill-opacity': settings.backgroundOpacity || 1,
                            stroke: labelsBorder || 'transparent',
                            'stroke-opacity': settings.borderOpacity,
                            'stroke-width': 1
                        }
                    );
                }

                var elemLabel = this.renderer.text(text, x, y, sz.width, sz.height, labelsAngle, { 'class': settings['class'], opacity: settings.opacity || 1 }, false, 'center', 'center');

                if (renderedRect) {
                    // return the renderedRect
                    renderedRect.x = x - padding.left;
                    renderedRect.y = y - padding.top;
                    renderedRect.width = sz.width + padding.left + padding.right;
                    renderedRect.height = sz.height + padding.bottom + padding.bottom;
                }

                if (this._isVML) {
                    this.renderer.removeElement(elemLabel);
                    this.renderer.getContainer()[0].appendChild(elemLabel);
                }

                if (renderGroup)
                    this.renderer.endGroup();

                return renderGroup || elemLabel;
            },

            /** @private */
            _getAnimProps: function (gidx, sidx) {
                var g = this.seriesGroups[gidx];
                var s = !isNaN(sidx) ? g.series[sidx] : undefined;

                var enabled = this.enableAnimations == true;

                if (g.enableAnimations)
                    enabled = g.enableAnimations == true;

                if (s && s.enableAnimations)
                    enabled = s.enableAnimations == true;

                var duration = this.animationDuration;
                if (isNaN(duration))
                    duration = 1000;

                var gd = g.animationDuration;
                if (!isNaN(gd))
                    duration = gd;

                if (s) {
                    var sd = s.animationDuration;
                    if (!isNaN(sd))
                        duration = sd;
                }

                if (duration > 5000)
                    duration = 1000;

                return { enabled: enabled, duration: duration };
            },

            _isColorTransition: function (groupIndex, s, renderData, current) {
                if (current - 1 < renderData.xoffsets.first)
                    return false;

                var currentColor = this._getColors(groupIndex, s, current, this._getGroupGradientType(groupIndex));
                var prevColor = this._getColors(groupIndex, s, current - 1, this._getGroupGradientType(groupIndex));

                return (currentColor.fillColor != prevColor.fillColor);
            },

            /** @private */
            _renderLineSeries: function (groupIndex, rect) {
                var group = this.seriesGroups[groupIndex];
                if (!group.series || group.series.length == 0)
                    return;

                var isArea = group.type.indexOf('area') != -1;
                var isStacked = group.type.indexOf('stacked') != -1;
                var isStacked100 = isStacked && group.type.indexOf('100') != -1;
                var isSpline = group.type.indexOf('spline') != -1;
                var isStep = group.type.indexOf('step') != -1;
                var isRange = group.type.indexOf('range') != -1;
                var isPolar = group.polar == true || group.spider == true;
                if (isPolar)
                    isStep = false;

                if (isStep && isSpline)
                    return;

                var dataLength = this._getDataLen(groupIndex);
                var wPerItem = rect.width / dataLength;

                var swapXY = group.orientation == 'horizontal';
                var flipCategory = this._getXAxis(groupIndex).flip == true;

                var gRect = rect;
                if (swapXY)
                    gRect = { x: rect.y, y: rect.x, width: rect.height, height: rect.width };

                var renderData = this._calcGroupOffsets(groupIndex, gRect);

                if (!renderData || renderData.xoffsets.length == 0)
                    return;

                if (!this._linesRenderInfo)
                    this._linesRenderInfo = {};

                this._linesRenderInfo[groupIndex] = {};

                for (var sidx = group.series.length - 1; sidx >= 0; sidx--) {
                    var serieSettings = this._getSerieSettings(groupIndex, sidx);

                    var serieCtx = {
                        groupIndex: groupIndex,
                        rect: gRect,
                        serieIndex: sidx,
                        swapXY: swapXY,
                        isArea: isArea,
                        isSpline: isSpline,
                        isRange: isRange,
                        isPolar: isPolar,
                        settings: serieSettings,
                        segments: [],
                        pointsLength: 0
                    };

                    var isVisible = this._isSerieVisible(groupIndex, sidx);
                    if (!isVisible) {
                        this._linesRenderInfo[groupIndex][sidx] = serieCtx;
                        continue;
                    }

                    var serie = group.series[sidx];
                    if (serie.customDraw)
                        continue;

                    var hasColorFunction = $.isFunction(serie.colorFunction);

                    var curr = renderData.xoffsets.first;
                    var last = curr;

                    var color = this._getColors(groupIndex, sidx, NaN, this._getGroupGradientType(groupIndex));

                    var colorBreakPoint = false;

                    var continueOnCurr;
                    do {
                        var points = [];
                        var rangeBasePoints = [];
                        var pointsStart = [];

                        var prev = -1;
                        var px = 0, py = 0;
                        var xPrev = NaN;
                        var yPrev = NaN;
                        var pyStart = NaN;

                        if (renderData.xoffsets.length < 1)
                            continue;

                        var anim = this._getAnimProps(groupIndex, sidx);
                        var duration = anim.enabled && !this._isToggleRefresh && renderData.xoffsets.length < 10000 && this._isVML != true ? anim.duration : 0;
                        var first = curr;
                        continueOnCurr = false;

                        var currentColor = this._getColors(groupIndex, sidx, curr, this._getGroupGradientType(groupIndex));
                        var ptSave = undefined;
                        for (var i = curr; i <= renderData.xoffsets.last; i++) {
                            curr = i;

                            var x = renderData.xoffsets.data[i];
                            var xvalue = renderData.xoffsets.xvalues[i];

                            if (isNaN(x))
                                continue;

                            x = Math.max(x, 1);
                            px = x;

                            py = renderData.offsets[sidx][i].to;


                            if (!hasColorFunction && ptSave && this.enableSampling && $.jqx._ptdist(ptSave.x, ptSave.y, px, py) < 1)
                                continue;

                            ptSave = { x: px, y: py };


                            var pyFrom = renderData.offsets[sidx][i].from;
                            if (isNaN(py) || isNaN(pyFrom)) {
                                if (serie.emptyPointsDisplay == 'connect') {
                                    continue;
                                }
                                else if (serie.emptyPointsDisplay == 'zero') {
                                    if (isNaN(py))
                                        py = renderData.baseOffset;
                                    if (isNaN(pyFrom))
                                        pyFrom = renderData.baseOffset;
                                }
                                else {
                                    continueOnCurr = true;
                                    break;
                                }
                            }

                            if (hasColorFunction && this._isColorTransition(groupIndex, sidx, renderData, curr)) {
                                if (points.length > 1) {
                                    curr--;
                                    break;
                                }
                            }

                            var elementRenderInfo = this._elementRenderInfo;
                            if (elementRenderInfo &&
                                elementRenderInfo.length > groupIndex &&
                                elementRenderInfo[groupIndex].series.length > sidx
                            ) {
                                var itemStartState = elementRenderInfo[groupIndex].series[sidx][xvalue];
                                var pyStart = $.jqx._ptrnd(itemStartState ? itemStartState.to : undefined);
                                var pxStart = $.jqx._ptrnd(gRect.x + (itemStartState ? itemStartState.xoffset : undefined));

                                pointsStart.push(swapXY ? { y: pxStart, x: pyStart, index: i } : { x: pxStart, y: pyStart, index: i });
                            }

                            last = i;

                            if (serieSettings.stroke < 2) {
                                if (py - gRect.y <= 1)
                                    py = gRect.y + 1;
                                if (pyFrom - gRect.y <= 1)
                                    pyFrom = gRect.y + 1;
                                if (gRect.y + gRect.height - py <= 1)
                                    py = gRect.y + gRect.height - 1;
                                if (gRect.y + gRect.height - pyFrom <= 1)
                                    pyFrom = gRect.y + gRect.height - 1;
                            }

                            if (!isArea && isStacked100) {
                                if (py <= gRect.y)
                                    py = gRect.y + 1;
                                if (py >= gRect.y + gRect.height)
                                    py = gRect.y + gRect.height - 1;

                                if (pyFrom <= gRect.y)
                                    pyFrom = gRect.y + 1;
                                if (pyFrom >= gRect.y + gRect.height)
                                    pyFrom = gRect.y + gRect.height - 1;
                            }

                            // TODO: validate condition
                            x = Math.max(x, 1);
                            px = x + gRect.x;

                            if (group.skipOverlappingPoints == true && !isNaN(xPrev) && Math.abs(xPrev - px) <= 1)
                                continue;

                            if (isStep && !isNaN(xPrev) && !isNaN(yPrev)) {
                                if (yPrev != py)
                                    points.push(swapXY ? { y: px, x: $.jqx._ptrnd(yPrev) } : { x: px, y: $.jqx._ptrnd(yPrev) });
                            }

                            points.push(swapXY ? { y: px, x: $.jqx._ptrnd(py), index: i } : { x: px, y: $.jqx._ptrnd(py), index: i });
                            rangeBasePoints.push(swapXY ? { y: px, x: $.jqx._ptrnd(pyFrom), index: i } : { x: px, y: $.jqx._ptrnd(pyFrom), index: i });

                            xPrev = px;
                            yPrev = py;
                            if (isNaN(pyStart))
                                pyStart = py;
                        }

                        if (points.length == 0) {
                            curr++;
                            continue;
                        }

                        var lastItemIndex = points[points.length - 1].index;
                        if (hasColorFunction)
                            color = this._getColors(groupIndex, sidx, lastItemIndex, this._getGroupGradientType(groupIndex));

                        var left = gRect.x + renderData.xoffsets.data[first];
                        var right = gRect.x + renderData.xoffsets.data[last];

                        if (isArea && group.alignEndPointsWithIntervals == true) {
                            var sign = flipCategory ? -1 : 1;
                            if (left > gRect.x) {
                                left = gRect.x;
                            }
                            if (right < gRect.x + gRect.width)
                                right = gRect.x + gRect.width;

                            if (flipCategory) {
                                var tmp = left;
                                left = right;
                                right = tmp;
                            }
                        }
                        right = $.jqx._ptrnd(right);
                        left = $.jqx._ptrnd(left);

                        var yBase = renderData.baseOffset;
                        pyStart = $.jqx._ptrnd(pyStart);

                        var pyEnd = $.jqx._ptrnd(py) || yBase;

                        if (isRange) {
                            points = points.concat(rangeBasePoints.reverse());
                        }

                        serieCtx.pointsLength += points.length;

                        var segmentCtx = {
                            lastItemIndex: lastItemIndex,
                            colorSettings: color,
                            pointsArray: points,
                            pointsStart: pointsStart,
                            left: left,
                            right: right,
                            pyStart: pyStart,
                            pyEnd: pyEnd,
                            yBase: yBase,
                            labelElements: [],
                            symbolElements: []
                        };

                        serieCtx.segments.push(segmentCtx);
                    }
                    while (curr < renderData.xoffsets.first + renderData.xoffsets.length - 1 || continueOnCurr);

                    this._linesRenderInfo[groupIndex][sidx] = serieCtx;
                } // for s

                var contexts = this._linesRenderInfo[groupIndex];
                var contextsArr = [];
                for (var i in contexts)
                    contextsArr.push(contexts[i]);

                contextsArr = contextsArr.sort(function (a, b) { return a.serieIndex - b.serieIndex; });

                if (isArea && isStacked)
                    contextsArr.reverse();

                for (var i = 0; i < contextsArr.length; i++) {
                    var serieCtx = contextsArr[i];
                    this._animateLine(serieCtx, duration == 0 ? 1 : 0);

                    var self = this;
                    this._enqueueAnimation(
                        "series",
                        undefined,
                        undefined,
                        duration,
                        function (element, context, percent) {
                            self._animateLine(context, percent);
                        },
                        serieCtx);
                }

            },

            /** @private */
            _animateLine: function (serieCtx, percent) {
                var settings = serieCtx.settings;
                var groupIndex = serieCtx.groupIndex;
                var serieIndex = serieCtx.serieIndex;
                var group = this.seriesGroups[groupIndex];
                var serie = group.series[serieIndex];

                var symbol = this._getSymbol(groupIndex, serieIndex);
                var showLabels = this._getLabelsSettings(groupIndex, serieIndex, NaN, ['Visible']).visible;

                var isClosedPolar = true;
                if (serieCtx.isPolar) {
                    if (!isNaN(group.endAngle) && Math.round(Math.abs((isNaN(group.startAngle) ? 0 : group.startAngle) - group.endAngle)) != 360)
                        isClosedPolar = false;
                }

                if (serie.endPointsConnect == false)
                    isClosedPolar = false;

                var startPoint = 0;
                for (var iSegment = 0; iSegment < serieCtx.segments.length; iSegment++) {
                    var ctx = serieCtx.segments[iSegment];
                    var cmd = this._calculateLine(groupIndex, serieCtx.pointsLength, startPoint, ctx.pointsArray, ctx.pointsStart, ctx.yBase, percent, serieCtx.isArea, serieCtx.swapXY);
                    startPoint += ctx.pointsArray.length;

                    if (cmd == '')
                        continue;

                    var split = cmd.split(' ');
                    var cnt = split.length;

                    var lineCmd = cmd;
                    if (lineCmd != '')
                        lineCmd = this._buildLineCmd(
                            cmd,
                            serieCtx.isRange,
                            ctx.left,
                            ctx.right,
                            ctx.pyStart,
                            ctx.pyEnd,
                            ctx.yBase,
                            serieCtx.isArea,
                            serieCtx.isPolar,
                            isClosedPolar,
                            serieCtx.isSpline,
                            serieCtx.swapXY
                        );
                    else
                        lineCmd = 'M 0 0';

                    var colorSettings = ctx.colorSettings;

                    if (!ctx.pathElement) {
                        ctx.pathElement = this.renderer.path(
                            lineCmd,
                            {
                                'stroke-width': settings.stroke,
                                'stroke': colorSettings.lineColor,
                                'stroke-opacity': settings.opacity,
                                'fill-opacity': settings.opacity,
                                'stroke-dasharray': settings.dashStyle,
                                fill: serieCtx.isArea ? colorSettings.fillColor : 'none'
                            });

                        this._installHandlers(ctx.pathElement, 'path', groupIndex, serieIndex, ctx.lastItemIndex);
                    }
                    else {
                        this.renderer.attr(ctx.pathElement, { 'd': lineCmd });
                    }

                    if (ctx.labelElements) {
                        for (var i = 0; i < ctx.labelElements.length; i++)
                            this.renderer.removeElement(ctx.labelElements[i]);

                        ctx.labelElements = [];
                    }

                    if (ctx.symbolElements) {
                        for (var i = 0; i < ctx.symbolElements.length; i++)
                            this.renderer.removeElement(ctx.symbolElements[i]);

                        ctx.symbolElements = [];
                    }


                    if (ctx.pointsArray.length == split.length) {
                        if (symbol != 'none' || showLabels) {
                            var symbolSize = serie.symbolSize;

                            var gRect = this._plotRect;

                            for (var i = 0; i < split.length; i++) {
                                var point = split[i].split(',');
                                point = { x: parseFloat(point[0]), y: parseFloat(point[1]) };

                                if (point.x < gRect.x || point.x > gRect.x + gRect.width ||
                                    point.y < gRect.y || point.y > gRect.y + gRect.height)
                                    continue;

                                if (symbol != 'none') {
                                    var itemColors = this._getColors(groupIndex, serieIndex, ctx.pointsArray[i].index, this._getGroupGradientType(groupIndex));
                                    var symbolElement = this._drawSymbol(
                                        symbol,
                                        point.x,
                                        point.y,
                                        itemColors.fillColorSymbol,
                                        settings.opacity,
                                        itemColors.lineColorSymbol,
                                        settings.opacity,
                                        settings.strokeSymbol,
                                        undefined,
                                        symbolSize);

                                    ctx.symbolElements.push(symbolElement);
                                }

                                if (showLabels) {
                                    var pointPrev = (i > 0 ? split[i - 1] : split[i]).split(',');
                                    pointPrev = { x: parseFloat(pointPrev[0]), y: parseFloat(pointPrev[1]) };

                                    var pointNext = (i < split.length - 1 ? split[i + 1] : split[i]).split(',');
                                    pointNext = { x: parseFloat(pointNext[0]), y: parseFloat(pointNext[1]) };

                                    point = this._adjustLineLabelPosition(groupIndex, serieIndex, ctx.pointsArray[i].index, point, pointPrev, pointNext);

                                    if (point) {
                                        var labelElement = this._showLabel(groupIndex, serieIndex, ctx.pointsArray[i].index, { x: point.x, y: point.y, width: 0, height: 0 });
                                        ctx.labelElements.push(labelElement);
                                    }
                                }
                            }
                        }
                    }


                    if (percent == 1 && symbol != 'none') {
                        for (var i = 0; i < ctx.symbolElements.length; i++) {
                            if (isNaN(ctx.pointsArray[i].index))
                                continue;
                            this._installHandlers(ctx.symbolElements[i], 'symbol', groupIndex, serieIndex, ctx.pointsArray[i].index);
                        }
                    }
                } // iSegment
            },

            /** @private */
            _adjustLineLabelPosition: function (gidx, sidx, iidx, pt, ptPrev, ptNext) {
                var labelSize = this._showLabel(gidx, sidx, iidx, { width: 0, height: 0 }, '', '', true);
                if (!labelSize)
                    return;

                var ptAdj = { x: pt.x - labelSize.width / 2, y: 0 };

                ptAdj.y = pt.y - 1.5 * labelSize.height;

                return ptAdj;
            },

            /** @private */
            _calculateLine: function (groupIndex, seriePointsLength, startPoint, pointsArray, pointsStartArray, yBase, percent, isArea, swapXY) {
                var g = this.seriesGroups[groupIndex];

                var polarAxisCoords;
                if (g.polar == true || g.spider == true)
                    polarAxisCoords = this._getPolarAxisCoords(groupIndex, this._plotRect);

                var cmd = '';

                var cnt = pointsArray.length;
                if (!isArea && pointsStartArray.length == 0) {
                    var stop = seriePointsLength * percent;
                    cnt = stop - startPoint;
                }

                var baseXSave = NaN;
                for (var i = 0; i < cnt + 1 && i < pointsArray.length; i++) {
                    if (i > 0)
                        cmd += ' ';
                    var y = pointsArray[i].y;
                    var x = pointsArray[i].x;
                    var baseY = !isArea ? y : yBase;
                    var baseX = x;
                    if (pointsStartArray && pointsStartArray.length > i) {
                        baseY = pointsStartArray[i].y;
                        baseX = pointsStartArray[i].x;
                        if (isNaN(baseY) || isNaN(baseX)) {
                            baseY = y;
                            baseX = x;
                        }
                    }

                    baseXSave = baseX;

                    if (cnt <= pointsArray.length && i > 0 && i == cnt) {
                        baseX = pointsArray[i - 1].x;
                        baseY = pointsArray[i - 1].y;
                    }

                    if (swapXY) {
                        x = $.jqx._ptrnd((x - baseY) * (isArea ? percent : 1) + baseY);
                        y = $.jqx._ptrnd(y);
                    }
                    else {
                        x = $.jqx._ptrnd((x - baseX) * percent + baseX);
                        y = $.jqx._ptrnd((y - baseY) * percent + baseY);
                    }

                    if (polarAxisCoords) {
                        var point = this._toPolarCoord(polarAxisCoords, this._plotRect, x, y);
                        x = point.x;
                        y = point.y;
                    }

                    cmd += x + ',' + y;

                    //if (pointsArray.length == 1 && !isArea)
                    //    cmd += ' ' + (x + 2) + ',' + (y + 2);
                }

                return cmd;
            },

            /** @private */
            _buildLineCmd: function (pointsArray, isRange, left, right, pyStart, pyEnd, yBase, isArea, isPolar, isClosedPolar, isSpline, swapXY) {
                var cmd = pointsArray;

                var ptBottomLeft = swapXY ? yBase + ',' + left : left + ',' + yBase;
                var ptBottomRight = swapXY ? yBase + ',' + right : right + ',' + yBase;

                if (isArea && !isPolar && !isRange) {
                    cmd = ptBottomLeft + ' ' + pointsArray + ' ' + ptBottomRight;
                }

                if (isSpline)
                    cmd = this._getBezierPoints(cmd);

                var split = cmd.split(' ');
                if (split.length == 0)
                    return '';

                // handle single point case
                if (split.length == 1) {
                    var points = split[0].split(',');
                    return 'M ' + split[0] + ' L' + (parseFloat(points[0]) + 1) + ',' + (parseFloat(points[1]) + 1);
                }

                var firstPoint = split[0].replace('M', '');

                if (isArea && !isPolar) {
                    if (!isRange) {
                        cmd = 'M ' + ptBottomLeft + ' L ' + firstPoint + ' ' + cmd;
                    }
                    else {
                        cmd = 'M ' + firstPoint + ' L ' + firstPoint + (isSpline ? '' : (' L ' + firstPoint + ' ')) + cmd;
                    }
                }
                else {
                    if (!isSpline)
                        cmd = 'M ' + firstPoint + ' ' + 'L ' + firstPoint + ' ' + cmd;
                }

                if ((isPolar && isClosedPolar) || isRange)
                    cmd += ' Z';

                return cmd;
            },

            /** @private */
            _getSerieSettings: function (groupIndex, seriesIndex) {
                var group = this.seriesGroups[groupIndex];
                var isArea = group.type.indexOf('area') != -1;
                var isLine = group.type.indexOf('line') != -1;

                var serie = group.series[seriesIndex];

                var dashStyle = serie.dashStyle || group.dashStyle || '';

                var opacity = serie.opacity || group.opacity;
                if (isNaN(opacity) || opacity < 0 || opacity > 1)
                    opacity = 1;

                var stroke = serie.lineWidth;
                if (isNaN(stroke) && stroke != 'auto')
                    stroke = group.lineWidth;

                if (stroke == 'auto' || isNaN(stroke) || stroke < 0 || stroke > 15) {
                    if (isArea)
                        stroke = 2;
                    else if (isLine)
                        stroke = 3;
                    else
                        stroke = 1;
                }

                var strokeSymbol = serie.lineWidthSymbol;
                if (isNaN(strokeSymbol))
                    strokeSymbol = 1;

                return { stroke: stroke, strokeSymbol: strokeSymbol, opacity: opacity, dashStyle: dashStyle };
            },

            /** @private */
            _getColors: function (gidx, sidx, iidx, gradientType, gradientStops) {
                var group = this.seriesGroups[gidx];
                var serie = group.series[sidx];

                var useGradient = this._get([serie.useGradientColors, group.useGradientColors, group.useGradient, true]);

                var colors = this._getSeriesColors(gidx, sidx, iidx);

                if (!colors.fillColor) {
                    colors.fillColor = color;
                    colors.fillColorSelected = $.jqx.adjustColor(color, 1.1);
                    colors.fillColorAlt = $.jqx.adjustColor(color, 4.0);
                    colors.fillColorAltSelected = $.jqx.adjustColor(color, 3.0);
                    colors.lineColor = colors.symbolColor = $.jqx.adjustColor(color, 0.9);
                    colors.lineColorSelected = colors.symbolColorSelected = $.jqx.adjustColor(color, 0.9);
                }

                var stops2 = [[0, 1.4], [100, 1]];
                var stops4 = [[0, 1], [25, 1.1], [50, 1.4], [100, 1]];
                var stopsR = [[0, 1.3], [90, 1.2], [100, 1.0]];

                var stops = NaN;
                if (!isNaN(gradientStops)) {
                    stops = gradientStops == 2 ? stops2 : stops4;
                }

                if (useGradient) {
                    var copy = {};
                    for (var i in colors)
                        copy[i] = colors[i];

                    colors = copy;

                    if (gradientType == 'verticalLinearGradient' || gradientType == 'horizontalLinearGradient') {
                        var stopsParam = gradientType == 'verticalLinearGradient' ? stops || stops2 : stops || stops4;
                        var keys = ['fillColor', 'fillColorSelected', 'fillColorAlt', 'fillColorAltSelected'];
                        for (var key in keys) {
                            var color = colors[keys[key]];
                            if (color)
                                colors[keys[key]] = this.renderer._toLinearGradient(color, gradientType == 'verticalLinearGradient', stopsParam);
                        }
                    }
                    else if (gradientType == 'radialGradient') {
                        var params;
                        var stops = stops2;
                        if ((group.type == 'pie' || group.type == 'donut' || group.polar) && iidx != undefined && this._renderData[gidx] && this._renderData[gidx].offsets[sidx]) {
                            params = this._renderData[gidx].offsets[sidx][iidx];
                            stops = stopsR;
                        }

                        colors.fillColor = this.renderer._toRadialGradient(colors.fillColor, stops, params);
                        colors.fillColorSelected = this.renderer._toRadialGradient(colors.fillColorSelected, stops, params);
                    }
                }

                return colors;
            },

            /** @private */
            _installHandlers: function (element, elementType, gidx, sidx, iidx) {
                if (!this.enableEvents)
                    return false;

                var self = this;
                var g = this.seriesGroups[gidx];
                var s = this.seriesGroups[gidx].series[sidx];

                var isLineType = g.type.indexOf('line') != -1 || g.type.indexOf('area') != -1;

                if (!isLineType && !(g.enableSelection == false || s.enableSelection == false)) {
                    this.renderer.addHandler(element, 'mousemove', function (e) {
                        var selected = self._selected;
                        if (selected && selected.isLineType && selected.linesUnselectMode == 'click' && !(selected.group == gidx && selected.series == sidx))
                            return;

                        //e.preventDefault();

                        var x = e.pageX || e.clientX || e.screenX;
                        var y = e.pageY || e.clientY || e.screenY;

                        var pos = self.host.offset();
                        x -= pos.left;
                        y -= pos.top;

                        if (self._mouseX == x && self._mouseY == y)
                            return;

                        if (self._ttEl) {
                            if (self._ttEl.gidx == gidx &&
                                self._ttEl.sidx == sidx &&
                                self._ttEl.iidx == iidx)
                                return;
                        }

                        self._startTooltipTimer(gidx, sidx, iidx);
                    });
                }

                if (!(g.enableSelection == false || s.enableSelection == false)) {
                    this.renderer.addHandler(element, 'mouseover', function (e) {
                        //e.preventDefault();

                        var selected = self._selected;
                        if (selected && selected.isLineType && selected.linesUnselectMode == 'click' && !(selected.group == gidx && selected.series == sidx))
                            return;

                        self._select(element, elementType, gidx, sidx, iidx, iidx);
                    });
                }

                this.renderer.addHandler(element, 'click', function (e) {
                    clearTimeout(self._hostClickTimer);

                    self._lastClickTs = (new Date()).valueOf();

                    if (isLineType && (elementType != 'symbol' && elementType != 'pointMarker'))
                        return;

                    if (self._isColumnType(g.type))
                        self._unselect();

                    if (isNaN(iidx))
                        return;

                    e.stopImmediatePropagation();
                    self._raiseItemEvent('click', g, s, iidx);
                });
            },

            /** @private */
            _getHorizontalOffset: function (gidx, sidx, x, y) {
                var rect = this._plotRect;
                var dataLength = this._getDataLen(gidx);
                if (dataLength == 0)
                    return { index: undefined, value: x };

                var renderData = this._calcGroupOffsets(gidx, this._plotRect);
                if (renderData.xoffsets.length == 0)
                    return { index: undefined, value: undefined };

                var px = x;
                var py = y;

                var g = this.seriesGroups[gidx];

                var polarAxisCoords;
                if (g.polar || g.spider)
                    polarAxisCoords = this._getPolarAxisCoords(gidx, rect);

                var inverse = this._getXAxis(gidx).flip == true;

                var minDist, idx, x1Selected, y1Selected;

                for (var i = renderData.xoffsets.first; i <= renderData.xoffsets.last; i++) {
                    var x1 = renderData.xoffsets.data[i];
                    var y1 = renderData.offsets[sidx][i].to;

                    var dist = 0;

                    if (polarAxisCoords) {
                        var point = this._toPolarCoord(polarAxisCoords, rect, x1 + rect.x, y1);
                        x1 = point.x;
                        y1 = point.y;
                        dist = $.jqx._ptdist(px, py, x1, y1);
                    }
                    else {
                        if (g.orientation == 'horizontal') {
                            x1 += rect.y;
                            var tmp = y1;
                            y1 = x1;
                            x1 = tmp;
                            dist = $.jqx._ptdist(px, py, x1, y1);
                        }
                        else {
                            x1 += rect.x;
                            dist = Math.abs(px - x1);
                        }
                    }

                    if (isNaN(minDist) || minDist > dist) {
                        minDist = dist;
                        idx = i;
                        x1Selected = x1;
                        y1Selected = y1;

                    }
                }

                return { index: idx, value: renderData.xoffsets.data[idx], polarAxisCoords: polarAxisCoords, x: x1Selected, y: y1Selected };
            },

            /** @private */
            onmousemove: function (x, y) {
                if (this._mouseX == x && this._mouseY == y)
                    return;

                this._mouseX = x;
                this._mouseY = y;

                if (!this._selected)
                    return;

                var gidx = this._selected.group;
                var sidx = this._selected.series;
                var g = this.seriesGroups[gidx];
                var s = g.series[sidx];

                var rect = this._plotRect;
                if (this.renderer) {
                    rect = this.renderer.getRect();
                    rect.x += 5;
                    rect.y += 5;
                    rect.width -= 10;
                    rect.height -= 10;
                }

                if (x < rect.x || x > rect.x + rect.width ||
                    y < rect.y || y > rect.y + rect.height) {
                    this._hideToolTip();
                    this._unselect();
                    return;
                }

                var inverse = g.orientation == 'horizontal';

                var rect = this._plotRect;
                if (g.type.indexOf('line') != -1 || g.type.indexOf('area') != -1) {
                    var offset = this._getHorizontalOffset(gidx, this._selected.series, x, y);
                    var i = offset.index;
                    if (i == undefined)
                        return;

                    if (this._selected.item != i) {
                        var segs = this._linesRenderInfo[gidx][sidx].segments;
                        var segId = 0;

                        while (i > segs[segId].lastItemIndex) {
                            segId++;
                            if (segId >= segs.length)
                                return;
                        }


                        var element = segs[segId].pathElement;
                        var iidxBase = segs[segId].lastItemIndex;

                        this._unselect(false);

                        this._select(element, 'path', gidx, sidx, i, iidxBase);
                    }
                    //  else
                    //      return;

                    var symbolType = this._getSymbol(this._selected.group, this._selected.series);
                    if (symbolType == 'none')
                        symbolType = 'circle';

                    var renderData = this._calcGroupOffsets(gidx, rect);
                    var to = renderData.offsets[this._selected.series][i].to;

                    var from = to;
                    if (g.type.indexOf('range') != -1) {
                        from = renderData.offsets[this._selected.series][i].from;
                    }

                    var cmp = inverse ? x : y;
                    if (!isNaN(from) && Math.abs(cmp - from) < Math.abs(cmp - to))
                        y = from;
                    else
                        y = to;

                    if (isNaN(y))
                        return;

                    x = offset.value;

                    if (inverse) {
                        var tmp = x;
                        x = y;
                        y = tmp + rect.y;
                    }
                    else {
                        x += rect.x;
                    }

                    if (offset.polarAxisCoords) {
                        x = offset.x;
                        y = offset.y;
                    }

                    y = $.jqx._ptrnd(y);
                    x = $.jqx._ptrnd(x);

                    if (this._pointMarker && this._pointMarker.element) {
                        this.renderer.removeElement(this._pointMarker.element);
                        this._pointMarker.element = undefined;
                    }

                    if (isNaN(x) || isNaN(y)) {
                        return;
                    }

                    var colors = this._getSeriesColors(gidx, sidx, i);
                    var settings = this._getSerieSettings(gidx, sidx);

                    var symbolSize = s.symbolSizeSelected;
                    if (isNaN(symbolSize))
                        symbolSize = s.symbolSize;
                    if (isNaN(symbolSize) || symbolSize > 50 || symbolSize < 0)
                        symbolSize = g.symbolSize;
                    if (isNaN(symbolSize) || symbolSize > 50 || symbolSize < 0)
                        symbolSize = 8;

                    if (this.showToolTips || this.enableCrosshairs) {
                        this._pointMarker = { type: symbolType, x: x, y: y, gidx: gidx, sidx: sidx, iidx: i };
                        this._pointMarker.element = this._drawSymbol(
                            symbolType,
                            x,
                            y,
                            colors.fillColorSymbolSelected,
                            settings.opacity,
                            colors.lineColorSymbolSelected,
                            settings.opacity,
                            settings.strokeSymbol,
                            settings.dashStyle,
                            symbolSize);

                        this._installHandlers(this._pointMarker.element, 'pointMarker', gidx, sidx, i);
                    }

                    this._startTooltipTimer(gidx, this._selected.series, i);
                }
            },

            /** @private */
            _drawSymbol: function (type, x, y, fillColor, fillOpacity, lineColor, lineOpacity, lineWidth, lineDashArray, size) {
                var element;
                var sz = size || 6;
                var sz2 = sz / 2;
                switch (type) {
                    case 'none':
                        return undefined;
                    case 'circle':
                        element = this.renderer.circle(x, y, sz / 2);
                        break;
                    case 'square':
                        sz = sz - 1; sz2 = sz / 2;
                        element = this.renderer.rect(x - sz2, y - sz2, sz, sz);
                        break;
                    case 'diamond':
                        {
                            var path = 'M ' + (x - sz2) + ',' + (y) + ' L' + (x) + ',' + (y - sz2) + ' L' + (x + sz2) + ',' + (y) + ' L' + (x) + ',' + (y + sz2) + ' Z';
                            element = this.renderer.path(path);
                        } break;
                    case 'triangle_up': case 'triangle':
                        {
                            var path = 'M ' + (x - sz2) + ',' + (y + sz2) + ' L ' + (x + sz2) + ',' + (y + sz2) + ' L ' + (x) + ',' + (y - sz2) + ' Z';
                            element = this.renderer.path(path);
                        } break;
                    case 'triangle_down':
                        {
                            var path = 'M ' + (x - sz2) + ',' + (y - sz2) + ' L ' + (x) + ',' + (y + sz2) + ' L ' + (x + sz2) + ',' + (y - sz2) + ' Z';
                            element = this.renderer.path(path);
                        } break;
                    case 'triangle_left':
                        {
                            var path = 'M ' + (x - sz2) + ',' + (y) + ' L ' + (x + sz2) + ',' + (y + sz2) + ' L ' + (x + sz2) + ',' + (y - sz2) + ' Z';
                            element = this.renderer.path(path);
                        } break;
                    case 'triangle_right':
                        {
                            var path = 'M ' + (x - sz2) + ',' + (y - sz2) + ' L ' + (x - sz2) + ',' + (y + sz2) + ' L ' + (x + sz2) + ',' + (y) + ' Z';
                            element = this.renderer.path(path);
                        } break;
                    default:
                        element = this.renderer.circle(x, y, sz);
                }

                this.renderer.attr(element, { fill: fillColor, 'fill-opacity': fillOpacity, stroke: lineColor, 'stroke-width': lineWidth, 'stroke-opacity': lineOpacity, 'stroke-dasharray': lineDashArray || '' });

                // pass extra parameters required for HTML5 rendering
                if (type != 'circle') {
                    this.renderer.attr(element, { r: sz / 2 });
                    if (type != 'square')
                        this.renderer.attr(element, { x: x, y: y });
                }

                return element;
            },

            /** @private */
            _getSymbol: function (groupIndex, seriesIndex) {
                var symbols = ['circle', 'square', 'diamond', 'triangle_up', 'triangle_down', 'triangle_left', 'triangle_right'];
                var g = this.seriesGroups[groupIndex];
                var s = g.series[seriesIndex];
                var symbolType;
                if (s.symbolType != undefined)
                    symbolType = s.symbolType;
                if (symbolType == undefined)
                    symbolType = g.symbolType;

                if (symbolType == 'default')
                    return symbols[seriesIndex % symbols.length];
                else if (symbolType != undefined)
                    return symbolType;

                return 'none';
            },

            /** @private */
            _startTooltipTimer: function (gidx, sidx, iidx, x, y, showDelay, hideDelay) {
                this._cancelTooltipTimer();
                var self = this;
                var g = self.seriesGroups[gidx];
                var delay = this.toolTipShowDelay || this.toolTipDelay;
                if (isNaN(delay) || delay > 10000 || delay < 0)
                    delay = 500;

                if (this._ttEl || (true == this.enableCrosshairs && false == this.showToolTips))
                    delay = 0;

                if (!isNaN(showDelay))
                    delay = showDelay;

                clearTimeout(this._tttimerHide);

                if (isNaN(x))
                    x = self._mouseX;

                if (isNaN(y))
                    y = self._mouseY - 3;

                if (delay == 0)
                    self._showToolTip(x, y, gidx, sidx, iidx);

                this._tttimer = setTimeout(function () {
                    if (delay != 0)
                        self._showToolTip(x, y, gidx, sidx, iidx);

                    var toolTipHideDelay = self.toolTipHideDelay;
                    if (!isNaN(hideDelay))
                        toolTipHideDelay = hideDelay;

                    if (isNaN(toolTipHideDelay))
                        toolTipHideDelay = 4000;

                    self._tttimerHide = setTimeout(function () {
                        self._hideToolTip();
                        self._unselect();
                    }, toolTipHideDelay);
                }, delay);
            },

            /** @private */
            _cancelTooltipTimer: function () {
                clearTimeout(this._tttimer);
            },

            /** @private */
            _getGroupGradientType: function (gidx) {
                var g = this.seriesGroups[gidx];

                if (g.type.indexOf('area') != -1)
                    return g.orientation == 'horizontal' ? 'horizontalLinearGradient' : 'verticalLinearGradient';
                else if (this._isColumnType(g.type) || g.type.indexOf('candle') != -1) {
                    if (g.polar)
                        return 'radialGradient';
                    return g.orientation == 'horizontal' ? 'verticalLinearGradient' : 'horizontalLinearGradient';
                }
                else if (g.type.indexOf('scatter') != -1 || g.type.indexOf('bubble') != -1 || this._isPieGroup(gidx))
                    return 'radialGradient';

                return undefined;
            },

            /** @private */
            _select: function (element, type, gidx, sidx, iidx, iidxBase) {
                if (this._selected) {
                    if ((this._selected.item != iidx ||
                        this._selected.series != sidx ||
                        this._selected.group != gidx)
                    ) {
                        this._unselect();
                    }
                    else {
                        return;
                    }
                }

                var g = this.seriesGroups[gidx];
                var s = g.series[sidx];

                if (g.enableSelection == false || s.enableSelection == false)
                    return;

                var isLineType = g.type.indexOf('line') != -1 && g.type.indexOf('area') == -1;

                this._selected = { element: element, type: type, group: gidx, series: sidx, item: iidx, iidxBase: iidxBase, isLineType: isLineType, linesUnselectMode: s.linesUnselectMode || g.linesUnselectMode };

                var colors = this._getColors(gidx, sidx, iidxBase || iidx, this._getGroupGradientType(gidx));
                var fillColor = colors.fillColorSelected;
                if (isLineType)
                    fillColor = 'none';

                var settings = this._getSerieSettings(gidx, sidx);

                var lineColorSelected = (type == 'symbol') ? colors.lineColorSymbolSelected : colors.lineColorSelected;
                fillColor = (type == 'symbol') ? colors.fillColorSymbolSelected : fillColor;

                var lineWidth = (type == 'symbol') ? 1 : settings.stroke;

                if (this.renderer.getAttr(element, 'fill') == colors.fillColorAlt)
                    fillColor = colors.fillColorAltSelected;

                this.renderer.attr(element, { 'stroke': lineColorSelected, fill: fillColor, 'stroke-width': lineWidth });

                if (g.type.indexOf('pie') != -1 || g.type.indexOf('donut') != -1) {
                    this._applyPieSelect();
                }

                // raise mouseover event
                this._raiseItemEvent('mouseover', g, s, iidx);
            },

            _applyPieSelect: function () {
                var self = this;

                self._createAnimationGroup("animPieSlice");

                var selected = this._selected;
                if (!selected)
                    return;

                var coord = this.getItemCoord(selected.group, selected.series, selected.item);
                if (!coord)
                    return;

                var element = this._getRenderInfo(selected.group, selected.series, selected.item);
                var ctx = { element: element, coord: coord };

                this._enqueueAnimation(
                    "animPieSlice",
                    undefined,
                    undefined,
                    300,
                    function (element, ctx, percent) {
                        var coord = ctx.coord;
                        var radiusAdj = coord.selectedRadiusChange * percent;
                        var cmd = self.renderer.pieSlicePath(coord.center.x, coord.center.y, coord.innerRadius == 0 ? 0 : (coord.innerRadius + radiusAdj), coord.outerRadius + radiusAdj, coord.fromAngle, coord.toAngle, coord.centerOffset);
                        self.renderer.attr(ctx.element.element, { 'd': cmd });

                        self._showPieLabel(selected.group, selected.series, selected.item, undefined, radiusAdj);
                    },
                    ctx);

                self._startAnimation("animPieSlice");
            },

            _applyPieUnselect: function () {
                this._stopAnimations();

                var selected = this._selected;
                if (!selected)
                    return;

                var coord = this.getItemCoord(selected.group, selected.series, selected.item);
                if (!coord || !coord.center)
                    return;

                var cmd = this.renderer.pieSlicePath(coord.center.x, coord.center.y, coord.innerRadius, coord.outerRadius, coord.fromAngle, coord.toAngle, coord.centerOffset);
                this.renderer.attr(selected.element, { 'd': cmd });

                this._showPieLabel(selected.group, selected.series, selected.item, undefined, 0);
            },

            /** @private */
            _unselect: function () {
                var self = this;

                if (self._selected) {
                    var gidx = self._selected.group;
                    var sidx = self._selected.series;
                    var iidx = self._selected.item;
                    var iidxBase = self._selected.iidxBase;
                    var type = self._selected.type;
                    var g = self.seriesGroups[gidx];
                    var s = g.series[sidx];

                    var isLineType = g.type.indexOf('line') != -1 && g.type.indexOf('area') == -1;

                    var colors = self._getColors(gidx, sidx, iidxBase || iidx, self._getGroupGradientType(gidx));
                    var fillColor = colors.fillColor;
                    if (isLineType)
                        fillColor = 'none';

                    var settings = self._getSerieSettings(gidx, sidx);

                    var lineColor = (type == 'symbol') ? colors.lineColorSymbol : colors.lineColor;
                    fillColor = (type == 'symbol') ? colors.fillColorSymbol : fillColor;

                    if (this.renderer.getAttr(self._selected.element, 'fill') == colors.fillColorAltSelected)
                        fillColor = colors.fillColorAlt;

                    var lineWidth = (type == 'symbol') ? 1 : settings.stroke;

                    self.renderer.attr(self._selected.element, { 'stroke': lineColor, fill: fillColor, 'stroke-width': lineWidth });

                    if (g.type.indexOf('pie') != -1 || g.type.indexOf('donut') != -1) {
                        this._applyPieUnselect();
                    }

                    self._selected = undefined;

                    if (!isNaN(iidx))
                        self._raiseItemEvent('mouseout', g, s, iidx);
                }

                if (self._pointMarker) {
                    if (self._pointMarker.element) {
                        self.renderer.removeElement(self._pointMarker.element);
                        self._pointMarker.element = undefined;
                    }
                    self._pointMarker = undefined;
                    self._hideCrosshairs();
                }
            },

            /** @private */
            _raiseItemEvent: function (event, group, serie, index) {
                var fn = serie[event] || group[event];
                var gidx = 0;
                for (; gidx < this.seriesGroups.length; gidx++)
                    if (this.seriesGroups[gidx] == group)
                        break;
                if (gidx == this.seriesGroups.length)
                    return;

                var args = { event: event, seriesGroup: group, serie: serie, elementIndex: index, elementValue: this._getDataValue(index, serie.dataField, gidx) };
                if (fn && $.isFunction(fn))
                    fn(args);

                this._raiseEvent(event, args);
            },

            _raiseEvent: function (name, args) {
                var event = new $.Event(name);
                event.owner = this;
                args.event = name;
                event.args = args;

                var result = this.host.trigger(event);

                return result;
            },

            /** @private */
            _calcInterval: function (min, max, countHint) {
                var diff = Math.abs(max - min);

                var approx = diff / countHint;

                var up = [1, 2, 3, 4, 5, 10, 15, 20, 25, 50, 100];
                var dw = [0.5, 0.25, 0.125, 0.1];

                var scale = 0.1;
                var arr = up;

                if (approx < 1) {
                    arr = dw;
                    scale = 10;
                }

                var idx = 0;

                do {
                    idx = 0;
                    if (approx >= 1)
                        scale *= 10;
                    else
                        scale /= 10;

                    for (var i = 1; i < arr.length; i++) {
                        if (Math.abs(arr[idx] * scale - approx) > Math.abs(arr[i] * scale - approx))
                            idx = i;
                        else
                            break;
                    }
                }
                while (idx == arr.length - 1);

                return arr[idx] * scale;
            },

            //** @private */
            _renderDataClone: function () {
                if (!this._renderData || this._isToggleRefresh)
                    return;

                var info = this._elementRenderInfo = [];

                if (this._isSelectorRefresh)
                    return;

                for (var groupIndex = 0; groupIndex < this._renderData.length; groupIndex++) {
                    var catField = this._getXAxis(groupIndex).dataField;

                    while (info.length <= groupIndex)
                        info.push({});

                    var groupInfo = info[groupIndex];
                    var data = this._renderData[groupIndex];
                    if (!data.offsets)
                        continue;

                    if (data.valueAxis) {
                        groupInfo.valueAxis = { itemOffsets: {} };
                        for (var key in data.valueAxis.itemOffsets) {
                            groupInfo.valueAxis.itemOffsets[key] = data.valueAxis.itemOffsets[key];
                        }
                    }

                    if (data.xAxis) {
                        groupInfo.xAxis = { itemOffsets: {} };
                        for (var key in data.xAxis.itemOffsets) {
                            groupInfo.xAxis.itemOffsets[key] = data.xAxis.itemOffsets[key];
                        }
                    }

                    groupInfo.series = [];
                    var series = groupInfo.series;

                    var isPieSeries = this._isPieGroup(groupIndex);

                    for (var s = 0; s < data.offsets.length; s++) {
                        series.push({});
                        for (var i = 0; i < data.offsets[s].length; i++)
                            if (!isPieSeries) {
                                series[s][data.xoffsets.xvalues[i]] = { value: data.offsets[s][i].value, /*valueFrom: data.offsets[s][i].valueFrom,*/valueRadius: data.offsets[s][i].valueRadius, xoffset: data.xoffsets.data[i], from: data.offsets[s][i].from, to: data.offsets[s][i].to };
                            }
                            else {
                                var item = data.offsets[s][i];
                                series[s][item.displayValue] = { value: item.value, x: item.x, y: item.y, fromAngle: item.fromAngle, toAngle: item.toAngle };
                            }
                    }
                }
            },

            getPolarDataPointOffset: function (xValue, yValue, groupIndex) {
                var renderData = this._renderData[groupIndex];
                if (!renderData)
                    return { x: NaN, y: NaN };

                var y = this.getValueAxisDataPointOffset(yValue, groupIndex);
                var x = this.getXAxisDataPointOffset(xValue, groupIndex);

                var pt = this._toPolarCoord(renderData.polarCoords, renderData.xAxis.rect, x, y);

                return { x: pt.x, y: pt.y };
            },

            /** @private */
            _getDataPointOffsetDiff: function (value1, value2, baseValue, logBase, scale, yzero, inverse) {
                var offset1 = this._getDataPointOffset(value1, baseValue, logBase, scale, yzero, inverse);
                var offset2 = this._getDataPointOffset(value2, baseValue, logBase, scale, yzero, inverse);

                return Math.abs(offset1 - offset2);
            },

            _getXAxisRenderData: function (groupIndex) {
                if (groupIndex >= this._renderData.length)
                    return;

                var group = this.seriesGroups[groupIndex];

                var renderData = this._renderData[groupIndex].xAxis;
                if (!renderData)
                    return;

                if (group.xAxis == undefined) {
                    // get common xAxis render data (it will be attached to the 1st group)
                    for (var i = 0; i <= groupIndex; i++)
                        if (this.seriesGroups[i].xAxis == undefined)
                            break;

                    renderData = this._renderData[i].xAxis;
                }

                return renderData;
            },

            getXAxisDataPointOffset: function (value, groupIndex) {
                var group = this.seriesGroups[groupIndex]

                if (isNaN(value))
                    return NaN;

                var renderData = this._getXAxisRenderData(groupIndex);
                if (!renderData)
                    return NaN;

                var stats = renderData.data.axisStats;

                var axisMin = stats.min.valueOf();
                var axisMax = stats.max.valueOf();

                var denom = axisMax - axisMin;
                if (denom == 0)
                    denom = 1;

                if (value.valueOf() > axisMax || value.valueOf() < axisMin)
                    return NaN;

                var axis = this._getXAxis(groupIndex);
                var sizeProp = group.orientation == 'horizontal' ? 'height' : 'width';
                var xProp = group.orientation == 'horizontal' ? 'y' : 'x';

                var percent = (value.valueOf() - axisMin) / denom;

                var size = renderData.rect[sizeProp] - renderData.data.padding.left - renderData.data.padding.right;

                if (group.polar || group.spider) {
                    var polarCoords = this._renderData[groupIndex].polarCoords;

                    if (polarCoords.isClosedCircle)
                        size = renderData.data.axisSize;
                }

                return this._plotRect[xProp] + renderData.data.padding.left + size * (axis.flip ? (1 - percent) : percent);
            },


            getValueAxisDataPointOffset: function (value, groupIndex) {
                var valueAxis = this._getValueAxis(groupIndex);
                if (!valueAxis)
                    return NaN;

                var renderData = this._renderData[groupIndex];
                if (!renderData)
                    return NaN;

                var flip = valueAxis.flip == true;
                var logBase = renderData.logBase;
                var scale = renderData.scale;
                var baseValue = renderData.gbase;
                var yzero = renderData.baseOffset;

                return this._getDataPointOffset(value, baseValue, logBase, scale, yzero, flip);
            },

            /** @private */
            _getDataPointOffset: function (value, baseValue, logBase, scale, yzero, inverse) {
                var offset;

                if (isNaN(value))
                    value = baseValue;

                if (!isNaN(logBase)) {
                    offset = ($.jqx.log(value, logBase) - $.jqx.log(baseValue, logBase)) * scale;
                }
                else {
                    offset = (value - baseValue) * scale;
                }

                if (this._isVML) {
                    offset = Math.round(offset);
                }

                if (inverse)
                    offset = yzero + offset;
                else
                    offset = yzero - offset;

                return offset;
            },

            /** @private */
            _calcGroupOffsets: function (groupIndex, rect) {
                var group = this.seriesGroups[groupIndex];

                while (this._renderData.length < groupIndex + 1)
                    this._renderData.push({});

                if (this._renderData[groupIndex] != null && this._renderData[groupIndex].offsets != undefined)
                    return this._renderData[groupIndex];

                if (this._isPieGroup(groupIndex)) {
                    return this._calcPieSeriesGroupOffsets(groupIndex, rect);
                }

                var valueAxis = this._getValueAxis(groupIndex);

                if (!valueAxis || !group.series || group.series.length == 0)
                    return this._renderData[groupIndex];

                var inverse = valueAxis.flip == true;
                var logAxis = valueAxis.logarithmicScale == true;
                var logBase = valueAxis.logarithmicScaleBase || 10;

                var out = [];

                var isStacked = group.type.indexOf("stacked") != -1;
                var isStacked100 = isStacked && group.type.indexOf("100") != -1;
                var isRange = group.type.indexOf("range") != -1;
                var isColumn = this._isColumnType(group.type);
                var isWaterfall = group.type.indexOf('waterfall') != -1;


                var dataLength = this._getDataLen(groupIndex);
                var gbase = group.baselineValue || valueAxis.baselineValue || 0;
                if (isStacked100)
                    gbase = 0;

                var stat = this._stats.seriesGroups[groupIndex];
                if (!stat || !stat.isValid)
                    return;

                var hasValuesOnBothSidesOfBase = stat.hasStackValueReversal;
                if (hasValuesOnBothSidesOfBase)
                    gbase = 0;

                if (isWaterfall && isStacked)
                    if (hasValuesOnBothSidesOfBase) // not supported
                        return;
                    else
                        gbase = stat.base;

                if (gbase > stat.max)
                    gbase = stat.max;
                if (gbase < stat.min)
                    gbase = stat.min;

                var range = (isStacked100 || logAxis) ? stat.maxRange : stat.max - stat.min;

                var min = stat.min;
                var max = stat.max;

                var scale = rect.height / (logAxis ? stat.intervals : range);

                var yzero = 0;
                if (isStacked100) {
                    if (min * max < 0) {
                        range /= 2;
                        yzero = -(range + gbase) * scale;
                    }
                    else {
                        yzero = -gbase * scale;
                    }
                }
                else
                    yzero = -(gbase - min) * scale;

                if (inverse)
                    yzero = rect.y - yzero;
                else
                    yzero += rect.y + rect.height;

                var yPOffset = [];
                var yNOffset = [];
                var yOffsetError = [];

                var pIntervals, nIntervals;
                if (logAxis) {
                    pIntervals = $.jqx.log(max, logBase) - $.jqx.log(gbase, logBase);
                    if (isStacked) // force base value @ min for stacked log series
                    {
                        pIntervals = stat.intervals;
                        gbase = isStacked100 ? 0 : min;
                    }

                    nIntervals = stat.intervals - pIntervals;
                    if (!inverse)
                        yzero = rect.y + pIntervals / stat.intervals * rect.height;
                }

                yzero = $.jqx._ptrnd(yzero);

                var th = (min * max < 0) ? rect.height / 2 : rect.height;

                var logSums = [];

                var stackSums = [];
                var useOffsetBasedStackCalculation = isStacked && (isColumn || logAxis);

                var firstItemRendered = [];

                out = new Array(group.series.length);
                for (var j = 0; j < group.series.length; j++)
                    out[j] = new Array(dataLength);

                for (var i = 0; i < dataLength; i++) {
                    if (!isWaterfall && isStacked)
                        stackSums = [];

                    for (var j = 0; j < group.series.length; j++) {
                        if (!isStacked && logAxis)
                            logSums = [];

                        var serie = group.series[j];

                        var dataField = serie.dataField;
                        var dataFieldFrom = serie.dataFieldFrom;
                        var dataFieldTo = serie.dataFieldTo;
                        var dataFieldRadius = serie.radiusDataField || serie.sizeDataField;

                        out[j][i] = {};

                        var isVisible = this._isSerieVisible(groupIndex, j);

                        if (group.type.indexOf('candle') != -1 || group.type.indexOf('ohlc') != -1) {
                            // handle financial series
                            var fields = ['Open', 'Close', 'High', 'Low'];
                            for (var f in fields) {
                                var field = 'dataField' + fields[f];
                                if (serie[field]) {
                                    out[j][i][fields[f]] = this._getDataPointOffset(
                                        this._getDataValueAsNumber(i, serie[field], groupIndex),
                                        gbase,
                                        logAxis ? logBase : NaN,
                                        scale,
                                        yzero,
                                        inverse);
                                }
                            }

                            continue;
                        }

                        if (isStacked) {
                            while (stackSums.length <= i)
                                stackSums.push(0);
                        }

                        var valFrom = NaN;
                        if (isRange) {
                            valFrom = this._getDataValueAsNumber(i, dataFieldFrom, groupIndex);
                            if (isNaN(valFrom))
                                valFrom = gbase;
                        }

                        var val = NaN;
                        if (isRange)
                            val = this._getDataValueAsNumber(i, dataFieldTo, groupIndex);
                        else
                            val = this._getDataValueAsNumber(i, dataField, groupIndex);

                        var valR = this._getDataValueAsNumber(i, dataFieldRadius, groupIndex);
                        if (isStacked)
                            stackSums[i] += isVisible ? val : 0;

                        if (!isVisible)
                            val = NaN;

                        if (isNaN(val) || (logAxis && val <= 0)) {
                            out[j][i] = { from: undefined, to: undefined };
                            continue;
                        }

                        var yOffset;

                        if (isStacked) {
                            if (useOffsetBasedStackCalculation) {
                                yOffset = (val >= gbase) ? yPOffset : yNOffset;
                            }
                            else
                                val = stackSums[i];
                        }

                        var h = scale * (val - gbase);

                        if (isRange)
                            h = scale * (val - valFrom);

                        if (isStacked && useOffsetBasedStackCalculation) {
                            if (!firstItemRendered[i]) {
                                firstItemRendered[i] = true;
                                h = scale * (val - gbase);
                            }
                            else {
                                h = scale * val;
                            }
                        }

                        if (logAxis) {
                            while (logSums.length <= i)
                                logSums.push({ p: { value: 0, height: 0 }, n: { value: 0, height: 0 } });

                            var base = (isRange || isRange) ? valFrom : gbase;
                            var sums = val > base ? logSums[i].p : logSums[i].n;

                            sums.value += val;

                            if (isStacked100) {
                                val = sums.value / (stat.psums[i] + stat.nsums[i]) * 100;
                                h = ($.jqx.log(val, logBase) - stat.minPow) * scale;
                            }
                            else {
                                h = $.jqx.log(sums.value, logBase) - $.jqx.log(base, logBase);

                                h *= scale;
                            }

                            h -= sums.height;
                            sums.height += h;
                        }

                        var y = yzero;
                        if (isRange) {
                            var yDiff = 0;
                            if (logAxis)
                                yDiff = ($.jqx.log(valFrom, logBase) - $.jqx.log(gbase, logBase)) * scale;
                            else
                                yDiff = (valFrom - gbase) * scale;

                            y += inverse ? yDiff : -yDiff;
                        }

                        if (isStacked) {
                            if (isStacked100 && !logAxis) {
                                var irange = (stat.psums[i] - stat.nsums[i]);

                                if (val > gbase) {
                                    h = (stat.psums[i] / irange) * th;
                                    if (stat.psums[i] != 0)
                                        h *= val / stat.psums[i];
                                }
                                else {
                                    h = (stat.nsums[i] / irange) * th;
                                    if (stat.nsums[i] != 0)
                                        h *= val / stat.nsums[i];
                                }
                            }

                            if (useOffsetBasedStackCalculation) {
                                if (isNaN(yOffset[i]))
                                    yOffset[i] = y;

                                y = yOffset[i];
                            }
                        }

                        if (isNaN(yOffsetError[i]))
                            yOffsetError[i] = 0;

                        var err = yOffsetError[i];

                        h = Math.abs(h);
                        var hSave = h;
                        if (h >= 1) {
                            var h_new = this._isVML ? Math.round(h) : $.jqx._ptrnd(h) - 1;
                            if (Math.abs(h - h_new) > 0.5)
                                h = Math.round(h);
                            else
                                h = h_new;
                        }

                        err += h - hSave;

                        if (!isStacked)
                            err = 0;

                        if (Math.abs(err) > 0.5) {
                            if (err > 0) {
                                h -= 1;
                                err -= 1;
                            }
                            else {
                                h += 1;
                                err += 1;
                            }
                        }

                        yOffsetError[i] = err;

                        // adjust the height to make sure it span the entire height
                        // otherwise there will be a few pixels inaccuracy
                        if (j == group.series.length - 1 && isStacked100) {
                            var sumH = 0;
                            for (var k = 0; k < j; k++)
                                sumH += Math.abs(out[k][i].to - out[k][i].from);
                            sumH += h;
                            if (sumH < th) {
                                if (h > 0.5)
                                    h = $.jqx._ptrnd(h + th - sumH);
                                else {
                                    var k = j - 1;
                                    while (k >= 0) {
                                        var diff = Math.abs(out[k][i].to - out[k][i].from);
                                        if (diff > 1) {
                                            if (out[k][i].from > out[k][i].to) {
                                                out[k][i].from += th - sumH;
                                            }
                                            break;
                                        }
                                        k--;
                                    }
                                }
                            }
                        }

                        if (inverse)
                            h *= -1;

                        var drawOpositeDirection = val < gbase;
                        if (isRange)
                            drawOpositeDirection = valFrom > val;

                        var outVal = isNaN(valFrom) ? val : { from: valFrom, to: val };
                        if (drawOpositeDirection) {
                            if (useOffsetBasedStackCalculation)
                                yOffset[i] += h;
                            out[j][i] = { from: y, to: y + h, value: outVal, valueRadius: valR };
                        }
                        else {
                            if (useOffsetBasedStackCalculation)
                                yOffset[i] -= h;
                            out[j][i] = { from: y, to: y - h, value: outVal, valueRadius: valR };
                        }

                    } // for j
                } // for i

                var renderData = this._renderData[groupIndex];
                renderData.baseOffset = yzero;
                renderData.gbase = gbase;
                renderData.logBase = logAxis ? logBase : NaN;
                renderData.scale = scale;
                renderData.offsets = !isWaterfall ? out : this._applyWaterfall(out, dataLength, groupIndex, yzero, gbase, logAxis ? logBase : NaN, scale, inverse, isStacked);

                renderData.xoffsets = this._calculateXOffsets(groupIndex, rect.width);

                return this._renderData[groupIndex];
            },

            _isPercent: function (value) {
                return (typeof (value) === 'string' && value.length > 0 && value.indexOf('%') == value.length - 1);
            },

            /** @private */
            _calcPieSeriesGroupOffsets: function (groupIndex, rect) {
                var self = this;
                var dataLength = this._getDataLen(groupIndex);
                var group = this.seriesGroups[groupIndex];

                var renderData = this._renderData[groupIndex] = {};
                var out = renderData.offsets = [];

                for (var sidx = 0; sidx < group.series.length; sidx++) {
                    var s = group.series[sidx];
                    var minAngle = this._get([s.minAngle, s.startAngle]);
                    if (isNaN(minAngle) || minAngle < 0 || minAngle > 360)
                        minAngle = 0;
                    var maxAngle = this._get([s.maxAngle, s.endAngle]);
                    if (isNaN(maxAngle) || maxAngle < 0 || maxAngle > 360)
                        maxAngle = 360;

                    var angleRange = maxAngle - minAngle;

                    var initialAngle = s.initialAngle || 0;
                    if (initialAngle < minAngle)
                        initialAngle = minAngle;
                    if (initialAngle > maxAngle)
                        initialAngle = maxAngle;

                    var centerOffset = s.centerOffset || 0;
                    var offsetX = $.jqx.getNum([s.offsetX, group.offsetX, rect.width / 2]);
                    var offsetY = $.jqx.getNum([s.offsetY, group.offsetY, rect.height / 2]);

                    var availableSize = Math.min(rect.width, rect.height) / 2;

                    var currentAngle = initialAngle;

                    // outer radius
                    var radius = s.radius;

                    if (self._isPercent(radius))
                        radius = parseFloat(radius) / 100 * availableSize;

                    if (isNaN(radius))
                        radius = availableSize * 0.4;

                    // inner radius
                    var innerRadius = s.innerRadius;
                    if (self._isPercent(innerRadius))
                        innerRadius = parseFloat(innerRadius) / 100 * availableSize;

                    if (isNaN(innerRadius) || innerRadius >= radius)
                        innerRadius = 0;

                    // selected radius
                    var selectedRadiusChange = s.selectedRadiusChange;
                    if (self._isPercent(selectedRadiusChange))
                        selectedRadiusChange = parseFloat(selectedRadiusChange) / 100 * (radius - innerRadius);

                    if (isNaN(selectedRadiusChange))
                        selectedRadiusChange = 0.1 * (radius - innerRadius);


                    out.push([]);

                    // compute the sum
                    var sumP = 0;
                    var sumN = 0;
                    for (var i = 0; i < dataLength; i++) {
                        var val = this._getDataValueAsNumber(i, s.dataField, groupIndex);
                        if (isNaN(val))
                            continue;

                        if (!this._isSerieVisible(groupIndex, sidx, i) && s.hiddenPointsDisplay != true)
                            continue;

                        if (val > 0)
                            sumP += val;
                        else
                            sumN += val;
                    }

                    var range = sumP - sumN;
                    if (range == 0)
                        range = 1;

                    // render
                    for (var i = 0; i < dataLength; i++) {
                        var val = this._getDataValueAsNumber(i, s.dataField, groupIndex);
                        if (isNaN(val)) {
                            out[sidx].push({});
                            continue;
                        }

                        var displayField = s.displayText || s.displayField;
                        var displayValue = this._getDataValue(i, displayField, groupIndex);
                        if (displayValue == undefined)
                            displayValue = i;

                        var angle = 0;

                        var isVisible = this._isSerieVisible(groupIndex, sidx, i);
                        if (isVisible || s.hiddenPointsDisplay == true) {
                            angle = Math.abs(val) / range * angleRange;
                        }

                        var x = rect.x + offsetX;
                        var y = rect.y + offsetY;

                        var centerOffsetValue = centerOffset;
                        if ($.isFunction(centerOffset)) {
                            centerOffsetValue = centerOffset({ seriesIndex: sidx, seriesGroupIndex: groupIndex, itemIndex: i });
                        }
                        if (isNaN(centerOffsetValue))
                            centerOffsetValue = 0;

                        var sliceRenderData = { key: groupIndex + '_' + sidx + '_' + i, value: val, displayValue: displayValue, x: x, y: y, fromAngle: currentAngle, toAngle: currentAngle + angle, centerOffset: centerOffsetValue, innerRadius: innerRadius, outerRadius: radius, selectedRadiusChange: selectedRadiusChange, visible: isVisible };
                        out[sidx].push(sliceRenderData);

                        currentAngle += angle;
                    }
                }

                return renderData;
            },

            /** @private */
            _isPointSeriesOnly: function () {
                for (var i = 0; i < this.seriesGroups.length; i++) {
                    var g = this.seriesGroups[i];
                    if (g.type.indexOf('line') == -1 && g.type.indexOf('area') == -1 && g.type.indexOf('scatter') == -1 && g.type.indexOf('bubble') == -1)
                        return false;
                }

                return true;
            },

            /** @private */
            _hasColumnSeries: function () {
                var types = ['column', 'ohlc', 'candlestick', 'waterfall'];
                for (var i = 0; i < this.seriesGroups.length; i++) {
                    var g = this.seriesGroups[i];
                    for (var j in types)
                        if (g.type.indexOf(types[j]) != -1)
                            return true;
                }

                return false;
            },

            /** @private */
            _alignValuesWithTicks: function (groupIndex) {
                var psonly = this._isPointSeriesOnly();

                var g = this.seriesGroups[groupIndex];

                // if xAxis
                var xAxis = this._getXAxis(groupIndex);
                var xAxisValuesOnTicks = xAxis.valuesOnTicks == undefined ? psonly : xAxis.valuesOnTicks != false;
                if (xAxis.logarithmicScale)
                    xAxisValuesOnTicks = true;

                if (groupIndex == undefined)
                    return xAxisValuesOnTicks;

                if (g.valuesOnTicks == undefined)
                    return xAxisValuesOnTicks;

                return g.valuesOnTicks;
            },

            _getYearsDiff: function (from, to) {
                return to.getFullYear() - from.getFullYear();
            },

            _getMonthsDiff: function (from, to) {
                return 12 * (to.getFullYear() - from.getFullYear()) + to.getMonth() - from.getMonth();
            },

            _getDateDiff: function (from, to, baseUnit, round) {
                var diff = 0;
                if (baseUnit != 'year' && baseUnit != 'month')
                    diff = to.valueOf() - from.valueOf();

                switch (baseUnit) {
                    case 'year':
                        diff = this._getYearsDiff(from, to);
                        break;
                    case 'month':
                        diff = this._getMonthsDiff(from, to);
                        break;
                    case 'day':
                        diff /= (24 * 3600 * 1000);
                        break;
                    case 'hour':
                        diff /= (3600 * 1000);
                        break;
                    case 'minute':
                        diff /= (60 * 1000);
                        break;
                    case 'second':
                        diff /= (1000);
                        break;
                    case 'millisecond':
                        break;
                }

                if (baseUnit != 'year' && baseUnit != 'month' && round != false)
                    diff = $.jqx._rnd(diff, 1, true);

                return diff;
            },

            _getBestDTUnit: function (min, max, groupIndex, axisSize, targetItemWidth) {
                var dateTimeUnit = 'day';

                var range = max.valueOf() - min.valueOf();
                if (range < 1000)
                    dateTimeUnit = 'second';
                else if (range < 3600000)
                    dateTimeUnit = 'minute';
                else if (range < 86400000)
                    dateTimeUnit = 'hour';
                else if (range < 2592000000)
                    dateTimeUnit = 'day';
                else if (range < 31104000000)
                    dateTimeUnit = 'month';
                else
                    dateTimeUnit = 'year';

                var units = [
                    { key: 'year', cnt: range / (1000 * 60 * 60 * 24 * 365) },
                    { key: 'month', cnt: range / (1000 * 60 * 60 * 24 * 30) },
                    { key: 'day', cnt: range / (1000 * 60 * 60 * 24) },
                    { key: 'hour', cnt: range / (1000 * 60 * 60) },
                    { key: 'minute', cnt: range / (1000 * 60) },
                    { key: 'second', cnt: range / 1000 },
                    { key: 'millisecond', cnt: range }
                ];

                var i = -1;
                for (var j = 0; j < units.length; j++)
                    if (units[j].key == dateTimeUnit) {
                        i = j;
                        break;
                    }

                var bestCnt = -1, bestIndex = -1;
                for (; i < units.length; i++) {
                    if (units[i].cnt / 100 > axisSize)
                        break;
                    var interval = this._estAxisInterval(min, max, groupIndex, axisSize, units[i].key, targetItemWidth);
                    var cnt = this._getDTIntCnt(min, max, interval, units[i].key);
                    if (bestCnt == -1 || bestCnt < cnt) {
                        bestCnt = cnt;
                        bestIndex = i;
                    }
                }

                dateTimeUnit = units[bestIndex].key;

                return dateTimeUnit;
            },

            /** @private */
            _getXAxisStats: function (groupIndex, xAxis, axisSize) {
                var dataLength = this._getDataLen(groupIndex);
                var isDateTime = xAxis.type == 'date' || xAxis.type == 'time';

                if (isDateTime && !this._autoDateFormats) {
                    if (!this._autoDateFormats)
                        this._autoDateFormats = [];

                    var detectedFormat = this._testXAxisDateFormat();
                    if (detectedFormat)
                        this._autoDateFormats.push(detectedFormat);
                }

                var axisMin = isDateTime ? this._castAsDate(xAxis.minValue, xAxis.dateFormat) : this._castAsNumber(xAxis.minValue);
                var axisMax = isDateTime ? this._castAsDate(xAxis.maxValue, xAxis.dateFormat) : this._castAsNumber(xAxis.maxValue);

                if (this._selectorRange && this._selectorRange[groupIndex]) {
                    var rangeMin = this._selectorRange[groupIndex].min;
                    if (!isNaN(rangeMin))
                        axisMin = isDateTime ? this._castAsDate(rangeMin, xAxis.dateFormat) : this._castAsNumber(rangeMin);

                    var rangeMax = this._selectorRange[groupIndex].max;
                    if (!isNaN(rangeMax))
                        axisMax = isDateTime ? this._castAsDate(rangeMax, xAxis.dateFormat) : this._castAsNumber(rangeMax);
                }

                var min = axisMin, max = axisMax;

                var minDS, maxDS;

                var autoDetect = xAxis.type == undefined || xAxis.type == 'auto';

                var useIndeces = (autoDetect || xAxis.type == 'basic');

                var cntDateTime = 0, cntNumber = 0;
                for (var i = 0; i < dataLength && xAxis.dataField; i++) {
                    var value = this._getDataValue(i, xAxis.dataField, groupIndex);
                    value = isDateTime ? this._castAsDate(value, xAxis.dateFormat) : this._castAsNumber(value);

                    if (isNaN(value))
                        continue;

                    if (isDateTime)
                        cntDateTime++;
                    else
                        cntNumber++;

                    if (isNaN(minDS) || value < minDS)
                        minDS = value;

                    if (isNaN(maxDS) || value >= maxDS)
                        maxDS = value;
                }

                if (autoDetect &&
                    ((!isDateTime && cntNumber == dataLength) || (isDateTime && cntDateTime == dataLength))
                ) {
                    useIndeces = false;
                }

                if (useIndeces) {
                    minDS = 0;
                    maxDS = Math.max(0, dataLength - 1);
                }

                // use the data source min/max if not set
                if (isNaN(min))
                    min = minDS;
                if (isNaN(max))
                    max = maxDS;

                // convert to date
                if (isDateTime) {
                    if (!this._isDate(min))
                        min = this._isDate(max) ? max : new Date();

                    if (!this._isDate(max))
                        max = this._isDate(min) ? min : new Date();
                }
                else {
                    if (isNaN(min))
                        min = 0;

                    if (isNaN(max))
                        max = useIndeces ? Math.max(0, dataLength - 1) : min;
                }

                if (minDS == undefined)
                    minDS = min;

                if (maxDS == undefined)
                    maxDS = max;

                // ensure min/max ranges are within the selector ranges
                var rangeSelector = xAxis.rangeSelector;
                if (rangeSelector) {
                    var selectorMin = rangeSelector.minValue || min;
                    if (selectorMin && isDateTime)
                        selectorMin = this._castAsDate(selectorMin, rangeSelector.dateFormat || xAxis.dateFormat);

                    var selectorMax = rangeSelector.maxValue || max;
                    if (selectorMax && isDateTime)
                        selectorMax = this._castAsDate(selectorMax, rangeSelector.dateFormat || xAxis.rangeSelector);

                    if (min < selectorMin)
                        min = selectorMin;

                    if (max < selectorMin)
                        max = selectorMax;

                    if (min > selectorMax)
                        min = selectorMin;

                    if (max > selectorMax)
                        max = selectorMax;
                }

                var interval = xAxis.unitInterval;

                var dateTimeUnit, isTimeUnit;

                if (isDateTime) {
                    dateTimeUnit = xAxis.baseUnit;
                    if (!dateTimeUnit) {
                        dateTimeUnit = this._getBestDTUnit(min, max, groupIndex, axisSize);
                    }

                    isTimeUnit = dateTimeUnit == 'hour' || dateTimeUnit == 'minute' || dateTimeUnit == 'second' || dateTimeUnit == 'millisecond';
                }

                var isLogAxis = xAxis.logarithmicScale == true;
                var logBase = xAxis.logarithmicScaleBase;
                if (isNaN(logBase) || logBase <= 1)
                    logBase = 10;

                var interval = xAxis.unitInterval;
                if (isLogAxis)
                    interval = 1;
                else if (isNaN(interval) || interval <= 0)
                    interval = this._estAxisInterval(min, max, groupIndex, axisSize, dateTimeUnit);

                var filterRange = { min: min, max: max };

                var group = this.seriesGroups[groupIndex];
                if (isLogAxis) {
                    if (!min) {
                        min = 1;
                        if (max && min > max)
                            min = max;
                    }
                    if (!max) {
                        max = min;
                    }

                    filterRange = { min: min, max: max };

                    var minPow = $.jqx._rnd($.jqx.log(min, logBase), 1, false);
                    var maxPow = $.jqx._rnd($.jqx.log(max, logBase), 1, true);

                    max = Math.pow(logBase, maxPow);
                    min = Math.pow(logBase, minPow);
                }
                else if (!isDateTime && (group.polar || group.spider)) { // TODO: evaluate applying to all series
                    min = $.jqx._rnd(min, interval, false);
                    max = $.jqx._rnd(max, interval, true);
                }

                return { min: min, max: max, logAxis: { enabled: isLogAxis, base: logBase, minPow: minPow, maxPow: maxPow }, dsRange: { min: minDS, max: maxDS }, filterRange: filterRange, useIndeces: useIndeces, isDateTime: isDateTime, isTimeUnit: isTimeUnit, dateTimeUnit: dateTimeUnit, interval: interval };
            },

            /** @private */
            _getDefaultDTFormatFn: function (dateTimeUnit) {
                var months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
                var fn;
                if (dateTimeUnit == 'year' || dateTimeUnit == 'month' || dateTimeUnit == 'day') {
                    fn = function (value) {
                        return value.getDate() + "-" + months[value.getMonth()] + "-" + value.getFullYear();
                    };
                }
                else {
                    fn = function (value) {
                        return value.getDate() + "-" + months[value.getMonth()] + "-" + value.getFullYear() + '<br>' + value.getHours() + ':' + value.getMinutes() + ':' + value.getSeconds();
                    };
                }

                return fn;
            },

            /** @private */
            _getDTIntCnt: function (min, max, interval, dateTimeUnit) {

                var cnt = 0;
                var curr = new Date(min);
                var maxDate = new Date(max);
                maxDate = maxDate.valueOf();

                if (interval <= 0)
                    return 1;

                while (curr.valueOf() < maxDate) {
                    if (dateTimeUnit == 'millisecond')
                        curr = new Date(curr.valueOf() + interval);
                    else if (dateTimeUnit == 'second')
                        curr = new Date(curr.valueOf() + interval * 1000);
                    else if (dateTimeUnit == 'minute')
                        curr = new Date(curr.valueOf() + interval * 60000);
                    else if (dateTimeUnit == 'hour') {
                        curr = new Date(curr.valueOf() + interval * 60000 * 24);
                    }
                    else if (dateTimeUnit == 'day')
                        curr.setDate(curr.getDate() + interval);
                    else if (dateTimeUnit == 'month')
                        curr.setMonth(curr.getMonth() + interval);
                    else if (dateTimeUnit == 'year')
                        curr.setFullYear(curr.getFullYear() + interval);

                    cnt++;
                }

                return cnt;
            },

            /** @private */
            _estAxisInterval: function (min, max, groupIndex, axisSize, baseUnit, avgItemWidth) {
                if (isNaN(min) || isNaN(max))
                    return NaN;

                var scale = [1, 2, 5, 10, 15, 20, 50, 100, 200, 500];

                var i = 0;
                var prefCount = axisSize / ((!isNaN(avgItemWidth) && avgItemWidth > 0) ? avgItemWidth : 50);

                if (this._renderData &&
                    this._renderData.length > groupIndex &&
                    this._renderData[groupIndex].xAxis &&
                    !isNaN(this._renderData[groupIndex].xAxis.avgWidth)) {
                    var avgWidth = Math.max(1, this._renderData[groupIndex].xAxis.avgWidth);
                    if (avgWidth != 0 && isNaN(avgItemWidth)) {
                        // use average text size and 90% axis size to account
                        // for padding between text items
                        prefCount = 0.9 * axisSize / avgWidth;
                    }
                }

                if (prefCount <= 1)
                    return Math.abs(max - min);

                var itemsCount = 0;
                while (true) {
                    var intSize = i >= scale.length ? Math.pow(10, 3 + i - scale.length) : scale[i];

                    if (this._isDate(min) && this._isDate(max))
                        itemsCount = this._getDTIntCnt(min, max, intSize, baseUnit);
                    else
                        itemsCount = (max - min) / intSize;

                    if (itemsCount <= prefCount)
                        break;

                    i++;
                }

                var group = this.seriesGroups[groupIndex];
                if (group.spider || group.polar) {
                    if (2 * intSize > max - min)
                        intSize = max - min;
                }

                return intSize;
            },

            /** @private */
            _getPaddingSize: function (axisStats, axis, valuesOnTicks, axisSize, isPolar, isClosedCircle, hasColumnSeries) {
                var min = axisStats.min;
                var max = axisStats.max;

                if (axisStats.logAxis.enabled) {
                    min = axisStats.logAxis.minPow;
                    max = axisStats.logAxis.maxPow;
                }

                var unitInterval = axisStats.interval;
                var dateTimeUnit = axisStats.dateTimeUnit;

                if (isPolar) {
                    var padding = (axisSize / Math.max(1, max - min + unitInterval)) * unitInterval;

                    if (isClosedCircle) {
                        return { left: 0, right: padding };
                    }
                    else {
                        if (valuesOnTicks)
                            return { left: 0, right: 0 };

                        return { left: padding / 2, right: padding / 2 };
                    }
                }


                if (valuesOnTicks && !hasColumnSeries)
                    return { left: 0, right: 0 };

                if (this._isDate(min) && this._isDate(max)) {
                    var itemsCount = this._getDTIntCnt(min, max, Math.min(unitInterval, max - min), dateTimeUnit);
                    var itemWidth = axisSize / Math.max(2, itemsCount);
                    return { left: itemWidth / 2, right: itemWidth / 2 };
                }

                var itemsCount = Math.max(1, max - min);
                if (itemsCount == 1) {
                    var sz = axisSize / 4;
                    return { left: sz, right: sz };
                }

                var itemWidth = axisSize / (itemsCount + 1);

                return { left: itemWidth / 2, right: itemWidth / 2 };
            },

            /** @private */
            _calculateXOffsets: function (groupIndex, axisSize) {
                var g = this.seriesGroups[groupIndex];

                var xAxis = this._getXAxis(groupIndex);
                var xoffsets = [];
                var xvalues = [];
                var dataLength = this._getDataLen(groupIndex);

                var axisStats = this._getXAxisStats(groupIndex, xAxis, axisSize);
                var min = axisStats.min;
                var max = axisStats.max;

                var isDateTime = axisStats.isDateTime;
                var isTimeUnit = axisStats.isTimeUnit;

                var hasColumnSeries = this._hasColumnSeries();

                var isPolar = g.polar || g.spider;
                var startAngle = this._get([g.startAngle, g.minAngle, 0]);
                var endAngle = this._get([g.endAngle, g.maxAngle, 360]);
                var isClosedCircle = isPolar && !(Math.abs(Math.abs(endAngle - startAngle) - 360) > 0.0001);

                var valuesOnTicks = this._alignValuesWithTicks(groupIndex);

                var padding = this._getPaddingSize(axisStats, xAxis, valuesOnTicks, axisSize, isPolar, isClosedCircle, hasColumnSeries);

                var rangeLength = max - min;
                var filterRange = axisStats.filterRange;

                if (rangeLength == 0)
                    rangeLength = 1;

                var plotSize = axisSize - padding.left - padding.right;
                if (isPolar && valuesOnTicks && !isClosedCircle)
                    padding.left = padding.right = 0;

                var first = -1, last = -1;
                for (var i = 0; i < dataLength; i++) {
                    var value = (xAxis.dataField === undefined) ? i : this._getDataValue(i, xAxis.dataField, groupIndex);

                    if (axisStats.useIndeces) {
                        if (i < filterRange.min || i > filterRange.max) {
                            xoffsets.push(NaN);
                            xvalues.push(undefined);
                            continue;
                        }

                        x = padding.left + (i - min) / rangeLength * plotSize;

                        if (axisStats.logAxis.enabled == true) {
                            var logBase = axisStats.logAxis.base;

                            x = this._jqxPlot.scale(
                                value,
                                {
                                    min: min.valueOf(),
                                    max: max.valueOf(),
                                    type: 'logarithmic',
                                    base: logBase
                                },
                                {
                                    min: 0,
                                    max: plotSize,
                                    flip: false
                                }
                            );
                        }

                        xoffsets.push($.jqx._ptrnd(x));
                        xvalues.push(value);

                        if (first == -1)
                            first = i;
                        if (last == -1 || last < i)
                            last = i;
                        continue;
                    }

                    value = isDateTime ? this._castAsDate(value, xAxis.dateFormat) : this._castAsNumber(value);
                    if (isNaN(value) || value < filterRange.min || value > filterRange.max) {
                        xoffsets.push(NaN);
                        xvalues.push(undefined);
                        continue;
                    }

                    var x = 0;
                    if (axisStats.logAxis.enabled == true) {
                        var logBase = axisStats.logAxis.base;

                        x = this._jqxPlot.scale(
                            value,
                            {
                                min: min.valueOf(),
                                max: max.valueOf(),
                                type: 'logarithmic',
                                base: logBase
                            },
                            {
                                min: 0,
                                max: plotSize,
                                flip: false
                            }
                        );
                    }
                    else if (!isDateTime || (isDateTime && isTimeUnit)) {
                        var diffFromMin = value - min;
                        x = (value - min) * plotSize / rangeLength;
                    }
                    else {
                        x = (value.valueOf() - min.valueOf()) / (max.valueOf() - min.valueOf()) * plotSize;
                    }

                    x = $.jqx._ptrnd(padding.left + x);

                    xoffsets.push(x);
                    xvalues.push(value);

                    if (first == -1)
                        first = i;
                    if (last == -1 || last < i)
                        last = i;
                }

                if (xAxis.flip == true) {
                    for (var i = 0; i < xoffsets.length; i++)
                        if (!isNaN(xoffsets[i]))
                            xoffsets[i] = axisSize - xoffsets[i];
                }

                if (isTimeUnit || isDateTime) {
                    rangeLength = this._getDateDiff(min, max, xAxis.baseUnit);
                    rangeLength = $.jqx._rnd(rangeLength, 1, false);
                }

                var itemsCount = Math.max(1, rangeLength);
                var itemWidth = plotSize / itemsCount;

                if (first == last && itemsCount == 1)
                    xoffsets[first] = padding.left + plotSize / 2;

                return {
                    axisStats: axisStats,
                    data: xoffsets,
                    xvalues: xvalues,
                    first: first,
                    last: last,
                    length: last == -1 ? 0 : last - first + 1,
                    itemWidth: itemWidth,
                    intervalWidth: itemWidth * axisStats.interval,
                    rangeLength: rangeLength,
                    useIndeces: axisStats.useIndeces,
                    padding: padding,
                    axisSize: plotSize
                };
            },

            /** @private */
            _getXAxis: function (gidx) {
                if (gidx == undefined || this.seriesGroups.length <= gidx)
                    return this.categoryAxis || this.xAxis;

                return this.seriesGroups[gidx].categoryAxis || this.seriesGroups[gidx].xAxis || this.categoryAxis || this.xAxis;
            },

            /** @private */
            _isGreyScale: function (groupIndex, seriesIndex) {
                var g = this.seriesGroups[groupIndex];
                var s = g.series[seriesIndex];

                if (s.greyScale == true)
                    return true;
                else if (s.greyScale == false)
                    return false;

                if (g.greyScale == true)
                    return true;
                else if (g.greyScale == false)
                    return false;

                return this.greyScale == true;
            },

            /** @private */
            _getSeriesColors: function (groupIndex, seriesIndex, itemIndex) {
                var colors = this._getSeriesColorsInternal(groupIndex, seriesIndex, itemIndex);

                if (this._isGreyScale(groupIndex, seriesIndex)) {
                    for (var i in colors)
                        colors[i] = $.jqx.toGreyScale(colors[i]);
                }

                return colors;
            },

            _getColorFromScheme: function (groupIndex, serieIndex, itemIndex) {
                var color = '#000000';
                var group = this.seriesGroups[groupIndex];
                var serie = group.series[serieIndex];

                if (this._isPieGroup(groupIndex)) {
                    var dataLength = this._getDataLen(groupIndex);
                    color = this._getItemColorFromScheme(serie.colorScheme || group.colorScheme || this.colorScheme, serieIndex * dataLength + itemIndex, groupIndex, serieIndex);
                }
                else {
                    var sidx = 0;
                    for (var i = 0; i <= groupIndex; i++) {
                        for (var j in this.seriesGroups[i].series) {
                            if (i == groupIndex && j == serieIndex)
                                break;
                            else
                                sidx++;
                        }
                    }

                    var colorScheme = this.colorScheme;
                    if (group.colorScheme) {
                        colorScheme = group.colorScheme;
                        var sidex = serieIndex;
                    }

                    if (colorScheme == undefined || colorScheme == '')
                        colorScheme = this.colorSchemes[0].name;

                    if (!colorScheme)
                        return color;

                    for (var i = 0; i < this.colorSchemes.length; i++) {
                        var cs = this.colorSchemes[i];
                        if (cs.name == colorScheme) {
                            while (sidx > cs.colors.length) {
                                sidx -= cs.colors.length;
                                if (++i >= this.colorSchemes.length)
                                    i = 0;
                                cs = this.colorSchemes[i];
                            }

                            color = cs.colors[sidx % cs.colors.length];
                        }
                    }
                } // else

                return color;
            },

            /** @private */
            _createColorsCache: function () {
                this._colorsCache = {
                    get: function (cacheKey) {
                        if (this._store[cacheKey])
                            return this._store[cacheKey];
                    },
                    set: function (cacheKey, color) {
                        if (this._size < 10000) {
                            this._store[cacheKey] = color;
                            this._size++;
                        }
                    },

                    clear: function () {
                        this._store = {};
                        this._size = 0;
                    },

                    _size: 0,
                    _store: {}
                };
            },


            /** @private */
            _getSeriesColorsInternal: function (groupIndex, seriesIndex, itemIndex) {
                var g = this.seriesGroups[groupIndex];
                var s = g.series[seriesIndex];

                if (!$.isFunction(s.colorFunction) && g.type != 'pie' && g.type != 'donut')
                    itemIndex = NaN;

                var cacheKey = groupIndex + "_" + seriesIndex + "_" + (isNaN(itemIndex) ? 'NaN' : itemIndex);

                if (this._colorsCache.get(cacheKey))
                    return this._colorsCache.get(cacheKey);

                var colors =
                {
                    lineColor: '#222222',
                    lineColorSelected: '#151515',
                    lineColorSymbol: '#222222',
                    lineColorSymbolSelected: '#151515',
                    fillColor: '#222222',
                    fillColorSelected: '#333333',
                    fillColorSymbol: '#222222',
                    fillColorSymbolSelected: '#333333',
                    fillColorAlt: '#222222',
                    fillColorAltSelected: '#333333'
                };

                var customColors;
                if ($.isFunction(s.colorFunction)) {
                    var value = !isNaN(itemIndex) ? this._getDataValue(itemIndex, s.dataField, groupIndex) : NaN;
                    if (g.type.indexOf('range') != -1 && !isNaN(itemIndex)) {
                        var valueFrom = this._getDataValue(itemIndex, s.dataFieldFrom, groupIndex);
                        var valueTo = this._getDataValue(itemIndex, s.dataFieldTo, groupIndex);
                        value = { from: valueFrom, to: valueTo };
                    }

                    customColors = s.colorFunction(value, itemIndex, s, g);
                    if (typeof (customColors) == 'object') {
                        for (var key in customColors)
                            colors[key] = customColors[key];
                    }
                    else {
                        colors.fillColor = customColors;
                    }
                }
                else {
                    for (var key in colors) {
                        if (s[key])
                            colors[key] = s[key];
                    }

                    if (!s.fillColor && !s.color) {
                        colors.fillColor = this._getColorFromScheme(groupIndex, seriesIndex, itemIndex);
                    }
                    else {
                        s.fillColor = s.fillColor || s.color;
                    }
                }

                var colorDeriveMap =
                {
                    fillColor: { baseColor: 'fillColor', adjust: 1.0 },
                    fillColorSelected: { baseColor: 'fillColor', adjust: 1.1 },
                    fillColorSymbol: { baseColor: 'fillColor', adjust: 1.0 },
                    fillColorSymbolSelected: { baseColor: 'fillColorSymbol', adjust: 2.0 },
                    fillColorAlt: { baseColor: 'fillColor', adjust: 4.0 },
                    fillColorAltSelected: { baseColor: 'fillColor', adjust: 3.0 },
                    lineColor: { baseColor: 'fillColor', adjust: 0.95 },
                    lineColorSelected: { baseColor: 'lineColor', adjust: 0.95 },
                    lineColorSymbol: { baseColor: 'lineColor', adjust: 1.0 },
                    lineColorSymbolSelected: { baseColor: 'lineColorSelected', adjust: 1.0 }
                };

                // assign colors
                for (var key in colors) {
                    if (typeof (customColors) != 'object' || !customColors[key]) {
                        if (s[key])
                            colors[key] = s[key];
                    }
                }

                // derive colors
                for (var key in colors) {
                    if (typeof (customColors) != 'object' || !customColors[key]) {
                        if (!s[key])
                            colors[key] = $.jqx.adjustColor(colors[colorDeriveMap[key].baseColor], colorDeriveMap[key].adjust);
                    }
                }

                this._colorsCache.set(cacheKey, colors);

                return colors;
            },

            /** @private */
            _getItemColorFromScheme: function (scheme, index, gidx, sidx) {
                if (scheme == undefined || scheme == '')
                    scheme = this.colorSchemes[0].name;

                for (var i = 0; i < this.colorSchemes.length; i++)
                    if (scheme == this.colorSchemes[i].name)
                        break;

                var j = 0;
                while (j <= index) {
                    if (i == this.colorSchemes.length)
                        i = 0;

                    var schLen = this.colorSchemes[i].colors.length;
                    if (j + schLen <= index) {
                        j += schLen;
                        i++;
                    }
                    else {
                        var color = this.colorSchemes[i].colors[index - j];

                        if (this._isGreyScale(gidx, sidx) && color.indexOf('#') == 0)
                            color = $.jqx.toGreyScale(color);

                        return color;
                    }
                }
            },

            getColorScheme: function (scheme) {
                for (var i = 0; i < this.colorSchemes.length; i++) {
                    if (this.colorSchemes[i].name == scheme)
                        return this.colorSchemes[i].colors;
                }

                return undefined;
            },

            addColorScheme: function (scheme, colors) {
                for (var i = 0; i < this.colorSchemes.length; i++) {
                    if (this.colorSchemes[i].name == scheme) {
                        this.colorSchemes[i].colors = colors;
                        return;
                    }
                }

                this.colorSchemes.push({ name: scheme, colors: colors });
            },

            removeColorScheme: function (scheme) {
                for (var i = 0; i < this.colorSchemes.length; i++) {
                    if (this.colorSchemes[i].name == scheme) {
                        this.colorSchemes.splice(i, 1);
                        break;
                    }
                }
            },

            /************* COLOR SCHEMES ************/
            colorSchemes: [
                { name: 'scheme01', colors: ['#307DD7', '#AA4643', '#89A54E', '#71588F', '#4198AF'] },
                { name: 'scheme02', colors: ['#7FD13B', '#EA157A', '#FEB80A', '#00ADDC', '#738AC8'] },
                { name: 'scheme03', colors: ['#E8601A', '#FF9639', '#F5BD6A', '#599994', '#115D6E'] },
                { name: 'scheme04', colors: ['#D02841', '#FF7C41', '#FFC051', '#5B5F4D', '#364651'] },
                { name: 'scheme05', colors: ['#25A0DA', '#309B46', '#8EBC00', '#FF7515', '#FFAE00'] },
                { name: 'scheme06', colors: ['#0A3A4A', '#196674', '#33A6B2', '#9AC836', '#D0E64B'] },
                { name: 'scheme07', colors: ['#CC6B32', '#FFAB48', '#FFE7AD', '#A7C9AE', '#888A63'] },
                { name: 'scheme08', colors: ['#3F3943', '#01A2A6', '#29D9C2', '#BDF271', '#FFFFA6'] },
                { name: 'scheme09', colors: ['#1B2B32', '#37646F', '#A3ABAF', '#E1E7E8', '#B22E2F'] },
                { name: 'scheme10', colors: ['#5A4B53', '#9C3C58', '#DE2B5B', '#D86A41', '#D2A825'] },
                { name: 'scheme11', colors: ['#993144', '#FFA257', '#CCA56A', '#ADA072', '#949681'] },
                { name: 'scheme12', colors: ['#105B63', '#EEEAC5', '#FFD34E', '#DB9E36', '#BD4932'] },
                { name: 'scheme13', colors: ['#BBEBBC', '#F0EE94', '#F5C465', '#FA7642', '#FF1E54'] },
                { name: 'scheme14', colors: ['#60573E', '#F2EEAC', '#BFA575', '#A63841', '#BFB8A3'] },
                { name: 'scheme15', colors: ['#444546', '#FFBB6E', '#F28D00', '#D94F00', '#7F203B'] },
                { name: 'scheme16', colors: ['#583C39', '#674E49', '#948658', '#F0E99A', '#564E49'] },
                { name: 'scheme17', colors: ['#142D58', '#447F6E', '#E1B65B', '#C8782A', '#9E3E17'] },
                { name: 'scheme18', colors: ['#4D2B1F', '#635D61', '#7992A2', '#97BFD5', '#BFDCF5'] },
                { name: 'scheme19', colors: ['#844341', '#D5CC92', '#BBA146', '#897B26', '#55591C'] },
                { name: 'scheme20', colors: ['#56626B', '#6C9380', '#C0CA55', '#F07C6C', '#AD5472'] },
                { name: 'scheme21', colors: ['#96003A', '#FF7347', '#FFBC7B', '#FF4154', '#642223'] },
                { name: 'scheme22', colors: ['#5D7359', '#E0D697', '#D6AA5C', '#8C5430', '#661C0E'] },
                { name: 'scheme23', colors: ['#16193B', '#35478C', '#4E7AC7', '#7FB2F0', '#ADD5F7'] },
                { name: 'scheme24', colors: ['#7B1A25', '#BF5322', '#9DA860', '#CEA457', '#B67818'] },
                { name: 'scheme25', colors: ['#0081DA', '#3AAFFF', '#99C900', '#FFEB3D', '#309B46'] },
                { name: 'scheme26', colors: ['#0069A5', '#0098EE', '#7BD2F6', '#FFB800', '#FF6800'] },
                { name: 'scheme27', colors: ['#FF6800', '#A0A700', '#FF8D00', '#678900', '#0069A5'] }
            ],

            /********** END OF COLOR SCHEMES ********/
            /** @private */
            _formatValue: function (value, formatSettings, formatFunction, groupIndex, serieIndex, itemIndex) {
                if (value == undefined)
                    return '';

                if (this._isObject(value) && !this._isDate(value) && !formatFunction)
                    return '';

                if (formatFunction) {
                    if (!$.isFunction(formatFunction))
                        return value.toString();

                    try {
                        return formatFunction(value, itemIndex, serieIndex, groupIndex);
                    }
                    catch (e) {
                        return e.message;
                    }
                }

                if (this._isNumber(value))
                    return this._formatNumber(value, formatSettings);

                if (this._isDate(value))
                    return this._formatDate(value, formatSettings);

                if (formatSettings) {
                    return (formatSettings.prefix || '') + value.toString() + (formatSettings.sufix || '');
                }

                return value.toString();
            },

            /** @private */
            _getFormattedValue: function (groupIndex, serieIndex, itemIndex, formatSettings, formatFunction, valuesOnly) {
                var g = this.seriesGroups[groupIndex];
                var s = g.series[serieIndex];
                var text = '';

                var fs = formatSettings, fn = formatFunction;
                if (!fn)
                    fn = s.formatFunction || g.formatFunction;
                if (!fs)
                    fs = s.formatSettings || g.formatSettings;

                // series format settings takes priority over group format function;
                if (!s.formatFunction && s.formatSettings)
                    fn = undefined;

                var value = {}, cnt = 0;
                for (var field in s)
                    if (field.indexOf('dataField') == 0) {
                        value[field.substring(9).toLowerCase()] = this._getDataValue(itemIndex, s[field], groupIndex);
                        cnt++;
                    }

                if (cnt == 0)
                    value = this._getDataValue(itemIndex, undefined, groupIndex);

                if (g.type.indexOf('waterfall') != -1 && this._isSummary(groupIndex, itemIndex)) {
                    value = this._renderData[groupIndex].offsets[serieIndex][itemIndex].value;
                    cnt = 0;
                }

                if (fn && $.isFunction(fn)) {
                    try {
                        return fn(cnt == 1 ? value[''] : value, itemIndex, s, g);
                    }
                    catch (e) {
                        return e.message;
                    }
                }

                if (cnt == 1 && this._isPieGroup(groupIndex)) {
                    return this._formatValue(value[''], fs, fn, groupIndex, serieIndex, itemIndex);;
                }

                if (cnt > 0) {
                    var i = 0;
                    for (var field in value) {
                        if (i > 0 && text != '')
                            text += '<br>';

                        var dataField = 'dataField' + (field.length > 0 ? field.substring(0, 1).toUpperCase() + field.substring(1) : '');
                        var displayField = 'displayText' + (field.length > 0 ? field.substring(0, 1).toUpperCase() + field.substring(1) : '');
                        var displayText = s[displayField] || s[dataField];

                        var currValue = value[field];
                        if (undefined != currValue) {
                            currValue = this._formatValue(currValue, fs, fn, groupIndex, serieIndex, itemIndex);
                        }
                        else
                            continue;

                        if (valuesOnly === true)
                            text += currValue;
                        else
                            text += displayText + ': ' + currValue;

                        i++;
                    }
                }
                else {
                    if (undefined != value)
                        text = this._formatValue(value, fs, fn, groupIndex, serieIndex, itemIndex);
                }

                return text || '';
            },

            /** @private */
            _isNumberAsString: function (text) {
                if (typeof (text) != 'string')
                    return false;

                text = $.trim(text);
                for (var i = 0; i < text.length; i++) {
                    var ch = text.charAt(i);
                    if ((ch >= '0' && ch <= '9') || ch == ',' || ch == '.')
                        continue;

                    if (ch == '-' && i == 0)
                        continue;

                    if ((ch == '(' && i == 0) || (ch == ')' && i == text.length - 1))
                        continue;

                    return false;
                }

                return true;
            },

            /** @private */
            _castAsDate: function (value, dateFormat) {
                if (value instanceof Date && !isNaN(value))
                    return value;

                if (typeof (value) == 'string') {
                    var result;

                    if (dateFormat) {
                        result = $.jqx.dataFormat.parsedate(value, dateFormat);
                        if (this._isDate(result))
                            return result;
                    }

                    // try formats detected earlier
                    if (this._autoDateFormats) {
                        for (var i = 0; i < this._autoDateFormats.length; i++) {
                            result = $.jqx.dataFormat.parsedate(value, this._autoDateFormats[i]);
                            if (this._isDate(result))
                                return result;
                        }
                    }

                    // try all formats
                    var detectedFormat = this._detectDateFormat(value);
                    if (detectedFormat) {
                        result = $.jqx.dataFormat.parsedate(value, detectedFormat);
                        if (this._isDate(result)) {
                            this._autoDateFormats.push(detectedFormat);
                            return result;
                        }
                    }

                    // try default conversion
                    result = new Date(value);

                    if (this._isDate(result)) {
                        if (value.indexOf(':') == -1)
                            result.setHours(0, 0, 0, 0);
                    }

                    return result;
                }

                return undefined;
            },

            /** @private */
            _castAsNumber: function (value) {
                if (value instanceof Date && !isNaN(value))
                    return value.valueOf();

                if (typeof (value) == 'string') {
                    if (this._isNumber(value)) {
                        value = parseFloat(value);
                    }
                    else {
                        if (!/[a-zA-Z]/.test(value)) {
                            var date = new Date(value);
                            if (date != undefined)
                                value = date.valueOf();
                        }
                    }
                }

                return value;
            },

            /** @private */
            _isNumber: function (value) {
                if (typeof (value) == 'string') {
                    if (this._isNumberAsString(value))
                        value = parseFloat(value);
                }
                return typeof value === 'number' && isFinite(value);
            },

            /** @private */
            _isDate: function (value) {
                return value instanceof Date && !isNaN(value.getDate());
            },

            /** @private */
            _isBoolean: function (value) {
                return typeof value === 'boolean';
            },

            /** @private */
            _isObject: function (value) {
                return (value && (typeof value === 'object' || $.isFunction(value))) || false;
            },

            /** @private */
            _formatDate: function (value, settings) {
                var result = value.toString();

                if (settings) {
                    if (settings.dateFormat)
                        result = $.jqx.dataFormat.formatDate(value, settings.dateFormat);

                    result = (settings.prefix || '') + result + (settings.sufix || '');
                }

                return result;
            },

            /** @private */
            _formatNumber: function (value, settings) {
                if (!this._isNumber(value))
                    return value;

                settings = settings || {};

                var decimalSeparator = '.';
                var thousandsSeparator = '';

                var self = this;

                if (self.localization) {
                    decimalSeparator = self.localization.decimalSeparator || self.localization.decimalseparator || decimalSeparator;
                    thousandsSeparator = self.localization.thousandsSeparator || self.localization.thousandsseparator || thousandsSeparator;
                }

                if (settings.decimalSeparator)
                    decimalSeparator = settings.decimalSeparator;

                if (settings.thousandsSeparator)
                    thousandsSeparator = settings.thousandsSeparator;

                var prefix = settings.prefix || '';
                var sufix = settings.sufix || '';
                var decimalPlaces = settings.decimalPlaces;
                if (isNaN(decimalPlaces))
                    decimalPlaces = this._getDecimalPlaces([value], undefined, 3);

                var negativeWithBrackets = settings.negativeWithBrackets || false;

                var negative = (value < 0);

                if (negative && negativeWithBrackets)
                    value *= -1;

                var output = value.toString();
                var decimalindex;

                var decimal = Math.pow(10, decimalPlaces);
                output = (Math.round(value * decimal) / decimal).toString();
                if (isNaN(output)) {
                    output = '';
                }

                decimalindex = output.lastIndexOf(".");
                if (decimalPlaces > 0) {
                    if (decimalindex < 0) {
                        output += decimalSeparator;
                        decimalindex = output.length - 1;
                    }
                    else if (decimalSeparator !== ".") {
                        output = output.replace(".", decimalSeparator);
                    }
                    while ((output.length - 1 - decimalindex) < decimalPlaces) {
                        output += "0";
                    }
                }

                decimalindex = output.lastIndexOf(decimalSeparator);
                decimalindex = (decimalindex > -1) ? decimalindex : output.length;
                var newoutput = output.substring(decimalindex);
                var cnt = 0;
                for (var i = decimalindex; i > 0; i--, cnt++) {
                    if ((cnt % 3 === 0) && (i !== decimalindex) && (!negative || (i > 1) || (negative && negativeWithBrackets))) {
                        newoutput = thousandsSeparator + newoutput;
                    }
                    newoutput = output.charAt(i - 1) + newoutput;
                }
                output = newoutput;

                if (negative && negativeWithBrackets)
                    output = '(' + output + ')';

                return prefix + output + sufix;
            },

            /** @private */
            _defaultNumberFormat: { prefix: '', sufix: '', decimalSeparator: '.', thousandsSeparator: ',', decimalPlaces: 2, negativeWithBrackets: false },

            /** @private */
            _calculateControlPoints: function (arr, offset) {
                var x0 = arr[offset],
                    y0 = arr[offset + 1],
                    x1 = arr[offset + 2],
                    y1 = arr[offset + 3],
                    x2 = arr[offset + 4],
                    y2 = arr[offset + 5];

                var tension = 0.4;

                var distP0P1 = Math.sqrt(Math.pow(x1 - x0, 2) + Math.pow(y1 - y0, 2));
                var distP1P2 = Math.sqrt(Math.pow(x2 - x1, 2) + Math.pow(y2 - y1, 2));

                var denom = (distP0P1 + distP1P2);
                if (denom == 0)
                    denom = 1;
                var factorA = tension * distP0P1 / denom;
                var factorB = tension - factorA;

                return [
                    x1 + factorA * (x0 - x2) /* x1 */, y1 + factorA * (y0 - y2) /* y1 */,
                    x1 - factorB * (x0 - x2) /* x2 */, y1 - factorB * (y0 - y2) /* y2 */
                ];
            },

            /** @private */
            _getBezierPoints: function (arr) {
                var result = '';
                var points = [], controlPoints = [];
                var split = arr.split(' ');
                for (var i = 0; i < split.length; i++) {
                    var pt = split[i].split(',');
                    points.push(parseFloat(pt[0]));
                    points.push(parseFloat(pt[1]));
                    if (isNaN(points[points.length - 1]) || isNaN(points[points.length - 2]))
                        continue;
                }

                var len = points.length;
                if (len <= 1)
                    return '';
                else if (len == 2) {
                    result = 'M' + $.jqx._ptrnd(points[0]) + ',' + $.jqx._ptrnd(points[1]) +
                        ' L' + $.jqx._ptrnd(points[0] + 1) + ',' + $.jqx._ptrnd(points[1] + 1) + ' '
                    return result;
                }

                for (var i = 0; i < len - 4; i += 2)
                    controlPoints = controlPoints.concat(this._calculateControlPoints(points, i));

                for (var i = 2; i < len - 5; i += 2) {
                    result += ' C' +
                        $.jqx._ptrnd(controlPoints[2 * i - 2]) + ',' + $.jqx._ptrnd(controlPoints[2 * i - 1]) + ' ' +
                        $.jqx._ptrnd(controlPoints[2 * i]) + ',' + $.jqx._ptrnd(controlPoints[2 * i + 1]) + ' ' +
                        $.jqx._ptrnd(points[i + 2]) + ',' + $.jqx._ptrnd(points[i + 3]) + ' ';
                }

                // check the x & y diff between the 1st and 2nd point and connect with either a line or quadratic curve
                if (len <= 4 || (Math.abs(points[0] - points[2]) < 3 || Math.abs(points[1] - points[3]) < 3) || this._isVML) {
                    result = 'M' + $.jqx._ptrnd(points[0]) + ',' + $.jqx._ptrnd(points[1]) +
                        ' L' + $.jqx._ptrnd(points[2]) + ',' + $.jqx._ptrnd(points[3]) + ' ' + result;
                }
                else {
                    result = 'M' + $.jqx._ptrnd(points[0]) + ',' + $.jqx._ptrnd(points[1]) +
                        ' Q' +
                        $.jqx._ptrnd(controlPoints[0]) + ',' + $.jqx._ptrnd(controlPoints[1]) + ' ' +
                        $.jqx._ptrnd(points[2]) + ',' + $.jqx._ptrnd(points[3]) + ' ' + result;
                }

                // check the x & y diff between the last 2 points and connect with either a line or quadratic curve
                if (len >= 4 && (Math.abs(points[len - 2] - points[len - 4]) < 3 || Math.abs(points[len - 1] - points[len - 3]) < 3 || this._isVML)) {
                    result += ' L' + $.jqx._ptrnd(points[len - 2]) + ',' + $.jqx._ptrnd(points[len - 1]) + ' ';
                }
                else if (len >= 5) {
                    result += ' Q' +
                        $.jqx._ptrnd(controlPoints[len * 2 - 10]) + ',' + $.jqx._ptrnd(controlPoints[len * 2 - 9]) + ' ' +
                        $.jqx._ptrnd(points[len - 2]) + ',' + $.jqx._ptrnd(points[len - 1]) + ' ';
                }

                return result;
            },

            /** @private */
            _animTickInt: 50,

            /** @private */
            _createAnimationGroup: function (groupId) {
                if (!this._animGroups) {
                    this._animGroups = {};
                }

                this._animGroups[groupId] = { animations: [], startTick: NaN };
            },

            /** @private */
            _startAnimation: function (groupId) {
                var d = new Date();
                var currentTick = d.getTime();
                this._animGroups[groupId].startTick = currentTick;
                this._runAnimation();
                this._enableAnimTimer();
            },

            /** @private */
            _enqueueAnimation: function (groupId, element, properties, duration, fn, context, easing) {
                if (duration < 0)
                    duration = 0;

                if (easing == undefined)
                    easing = 'easeInOutSine';

                this._animGroups[groupId].animations.push({ key: element, properties: properties, duration: duration, fn: fn, context: context, easing: easing });
            },

            /** @private */
            _stopAnimations: function () {
                clearTimeout(this._animtimer);
                this._animtimer = undefined;
                this._animGroups = undefined;
            },

            /** @private */
            _enableAnimTimer: function () {
                if (!this._animtimer) {
                    var self = this;
                    this._animtimer = setTimeout(function () { self._runAnimation(); }, this._animTickInt);
                }
            },

            /** @private */
            _runAnimation: function (animationCompleteCallback) {

                if (this._animGroups) {
                    var d = new Date();
                    var currentTick = d.getTime();

                    var animGroupsNewList = {};
                    for (var j in this._animGroups) {
                        var list = this._animGroups[j].animations;
                        var startTick = this._animGroups[j].startTick;

                        var maxDuration = 0;
                        for (var i = 0; i < list.length; i++) {
                            var item = list[i];

                            var tSince = (currentTick - startTick);
                            if (item.duration > maxDuration)
                                maxDuration = item.duration;

                            var percent = item.duration > 0 ? tSince / item.duration : 1;
                            var easePercent = percent;
                            if (item.easing && item.duration != 0)
                                easePercent = $.easing[item.easing](percent, tSince, 0, 1, item.duration);

                            if (percent > 1) {
                                percent = 1;
                                easePercent = 1;
                            }

                            if (item.fn) // custom function
                            {
                                item.fn(item.key, item.context, easePercent);
                                continue;
                            }

                            var params = {};
                            for (var j = 0; j < item.properties.length; j++) {
                                var p = item.properties[j];
                                var val = 0;

                                if (percent == 1) {
                                    val = p.to;
                                }
                                else {
                                    val = easePercent * (p.to - p.from) + p.from;
                                }

                                params[p.key] = val;
                            }
                            this.renderer.attr(item.key, params);
                        } // for i

                        if (startTick + maxDuration > currentTick)
                            animGroupsNewList[j] = ({ startTick: startTick, animations: list });
                    } // for j

                    this._animGroups = animGroupsNewList;

                    if (this.renderer instanceof $.jqx.HTML5Renderer)
                        this.renderer.refresh();
                }

                this._animtimer = null;

                for (var j in this._animGroups) {
                    this._enableAnimTimer();
                    break;
                }
            },

            _fixCoords: function (rect, groupIndex) {
                var swapXY = this.seriesGroups[groupIndex].orientation == 'horizontal';
                if (!swapXY)
                    return rect;

                var tmp = rect.x;
                rect.x = rect.y;
                rect.y = tmp + this._plotRect.y - this._plotRect.x;

                var tmp = rect.width;
                rect.width = rect.height;
                rect.height = tmp;

                return rect;
            },

            getItemCoord: function (groupIndex, serieIndex, itemIndex) {
                var self = this;

                if (self._isPieGroup(groupIndex) &&
                    (
                        !self._isSerieVisible(groupIndex, serieIndex, itemIndex) ||
                        !self._renderData ||
                        self._renderData.length <= groupIndex
                    )
                ) {
                    return { x: NaN, y: NaN };
                }

                if (!self._isSerieVisible(groupIndex, serieIndex) ||
                    !self._renderData ||
                    self._renderData.length <= groupIndex
                ) {
                    return { x: NaN, y: NaN };
                }

                var g = self.seriesGroups[groupIndex]
                var s = g.series[serieIndex];

                var coord = self._getItemCoord(groupIndex, serieIndex, itemIndex);
                if (self._isPieGroup(groupIndex)) {
                    if (isNaN(coord.x) || isNaN(coord.y) || isNaN(coord.fromAngle) || isNaN(coord.toAngle))
                        return { x: NaN, y: NaN };

                    var plotRect = this._plotRect;

                    var fromAngle = coord.fromAngle * (Math.PI / 180);
                    var toAngle = coord.toAngle * (Math.PI / 180);

                    var x1 = plotRect.x + coord.center.x + Math.cos(fromAngle) * coord.outerRadius;
                    var x2 = plotRect.x + coord.center.x + Math.cos(toAngle) * coord.outerRadius;
                    var y1 = plotRect.y + coord.center.y - Math.sin(fromAngle) * coord.outerRadius;
                    var y2 = plotRect.y + coord.center.y - Math.sin(toAngle) * coord.outerRadius;

                    var x = Math.min(x1, x2);
                    var width = Math.abs(x2 - x1);
                    var y = Math.min(y1, y2);
                    var height = Math.abs(y2 - y1);

                    coord =
                    {
                        x: x,
                        y: y,
                        width: width,
                        height: height,
                        center: coord.center,
                        centerOffset: coord.centerOffset,
                        innerRadius: coord.innerRadius,
                        outerRadius: coord.outerRadius,
                        selectedRadiusChange: coord.selectedRadiusChange,
                        fromAngle: coord.fromAngle,
                        toAngle: coord.toAngle
                    };

                    return coord;
                }

                if (g.type.indexOf('column') != -1 || g.type.indexOf('waterfall') != -1) {
                    var offsetAndWidth = this._getColumnSerieWidthAndOffset(groupIndex, serieIndex);
                    coord.height = Math.abs(coord.y.to - coord.y.from);
                    coord.y = Math.min(coord.y.to, coord.y.from);

                    coord.x += offsetAndWidth.offset;
                    coord.width = offsetAndWidth.width;
                }
                else if (g.type.indexOf('ohlc') != -1 || g.type.indexOf('candlestick') != -1) {
                    var offsetAndWidth = this._getColumnSerieWidthAndOffset(groupIndex, serieIndex);
                    var y = coord.y;
                    var minY = Math.min(y.Open, y.Close, y.Low, y.High);
                    var maxY = Math.max(y.Open, y.Close, y.Low, y.High);

                    coord.height = Math.abs(maxY - minY);
                    coord.y = minY

                    coord.x += offsetAndWidth.offset;
                    coord.width = offsetAndWidth.width;
                }
                else if (g.type.indexOf('line') != -1 || g.type.indexOf('area') != -1) {
                    coord.width = coord.height = 0;
                    coord.y = coord.y.to;
                }
                else if (g.type.indexOf('bubble') != -1 || g.type.indexOf('scatter') != -1) {
                    coord.center = { x: coord.x, y: coord.y.to };
                    var radius = coord.y.radius;
                    if (s.symbolType != 'circle' && s.symbolType != undefined)
                        radius /= 2;

                    coord.y = coord.y.to;
                    coord.radius = radius;

                    coord.width = 2 * radius;
                    coord.height = 2 * radius;
                }

                coord = this._fixCoords(coord, groupIndex);

                if (g.polar || g.spider) {
                    var point = this._toPolarCoord(this._renderData[groupIndex].polarCoords, this._plotRect, coord.x, coord.y);
                    coord.x = point.x;
                    coord.y = point.y;
                    if (coord.center) {
                        coord.center = this._toPolarCoord(this._renderData[groupIndex].polarCoords, this._plotRect, coord.center.x, coord.center.y);
                    }
                }

                if (g.type.indexOf('bubble') != -1 || g.type.indexOf('scatter') != -1) {
                    coord.x -= radius;
                    coord.y -= radius;
                }

                return coord;
            },

            _getItemCoord: function (groupIndex, serieIndex, itemIndex) {
                var g = this.seriesGroups[groupIndex],
                    x,
                    y;

                if (!g || !this._renderData)
                    return { x: NaN, y: NaN };

                var serie = g.series[serieIndex];
                if (!serie)
                    return { x: NaN, y: NaN };

                var plotRect = this._plotRect;

                if (this._isPieGroup(groupIndex)) {
                    var slice = this._renderData[groupIndex].offsets[serieIndex][itemIndex];
                    if (!slice)
                        return { x: NaN, y: NaN };

                    var angle = (slice.fromAngle + slice.toAngle) / 2 * (Math.PI / 180);

                    x = plotRect.x + slice.x + Math.cos(angle) * slice.outerRadius;
                    y = plotRect.y + slice.y - Math.sin(angle) * slice.outerRadius;

                    return {
                        x: x,
                        y: y,
                        center: { x: slice.x, y: slice.y },
                        centerOffset: slice.centerOffset,
                        innerRadius: slice.innerRadius,
                        outerRadius: slice.outerRadius,
                        selectedRadiusChange: slice.selectedRadiusChange,
                        fromAngle: slice.fromAngle,
                        toAngle: slice.toAngle
                    };
                }
                else {
                    x = plotRect.x + this._renderData[groupIndex].xoffsets.data[itemIndex];
                    y = this._renderData[groupIndex].offsets[serieIndex][itemIndex];

                    if (isNaN(x) || !y)
                        return { x: NaN, y: NaN };
                }

                var yOut = {};
                for (var i in y) {
                    yOut[i] = y[i];
                }

                return { x: x, y: yOut };
            },

            getXAxisValue: function (offset, groupIndex) {
                var group = this.seriesGroups[groupIndex];
                if (!group)
                    return undefined;

                var xAxis = this._getXAxis(groupIndex);

                var rect = this._plotRect;
                var axisSize = 0;

                var pos = NaN;

                var xAxisStats = this._renderData[0].xoffsets.axisStats;

                var min = 0, max = 0;
                if (group.polar || group.spider) {
                    if (isNaN(offset.x) || isNaN(offset.y))
                        return NaN;

                    var polarCoords = this._getPolarAxisCoords(groupIndex, rect);

                    var dist = $.jqx._ptdist(offset.x, offset.y, polarCoords.x, polarCoords.y);
                    if (dist > polarCoords.r)
                        return NaN;

                    var posAngle = Math.atan2(polarCoords.y - offset.y, offset.x - polarCoords.x);

                    posAngle = Math.PI / 2 - posAngle;
                    if (posAngle < 0)
                        posAngle = 2 * Math.PI + posAngle;

                    pos = posAngle * polarCoords.r;

                    var startAngle = polarCoords.startAngle + Math.PI / 2;
                    var endAngle = polarCoords.endAngle + Math.PI / 2;

                    min = startAngle * polarCoords.r;
                    max = endAngle * polarCoords.r;

                    axisSize = (endAngle - startAngle) * polarCoords.r;

                    var padding = this._getPaddingSize(xAxisStats, xAxis, xAxis.valuesOnTicks, axisSize, true, polarCoords.isClosedCircle, this._hasColumnSeries());

                    if (polarCoords.isClosedCircle) {
                        axisSize -= (padding.left + padding.right);
                        max -= (padding.left + padding.right);
                    }
                    else {
                        if (!xAxis.valuesOnTicks) {
                            min += padding.left;
                            max -= padding.right;
                        }
                    }

                }
                else {
                    if (group.orientation != 'horizontal') {
                        if (offset < rect.x || offset > rect.x + rect.width)
                            return NaN;

                        pos = offset - rect.x;
                        axisSize = rect.width;
                    }
                    else {
                        if (offset < rect.y || offset > rect.y + rect.height)
                            return NaN;

                        pos = offset - rect.y;
                        axisSize = rect.height;
                    }

                    if (this._renderData[groupIndex] && this._renderData[groupIndex].xoffsets) {
                        var padding = this._renderData[groupIndex].xoffsets.padding;
                        axisSize -= (padding.left + padding.right);
                        pos -= padding.left;
                    }

                    max = axisSize;
                }

                var value = this._jqxPlot.scale(
                    pos,
                    {
                        min: min,
                        max: max
                    },
                    {
                        min: xAxisStats.min.valueOf(),
                        max: xAxisStats.max.valueOf(),
                        type: xAxisStats.logAxis.enabled ? 'logarithmic' : 'linear',
                        base: xAxisStats.logAxis.base,
                        flip: xAxis.flip
                    }
                );

                return value;
            },

            getValueAxisValue: function (offset, groupIndex) {
                var group = this.seriesGroups[groupIndex];
                if (!group)
                    return undefined;

                var valueAxis = this._getValueAxis(groupIndex);

                var rect = this._plotRect;
                var axisSize = 0;

                var pos = NaN;

                if (group.polar || group.spider) {
                    if (isNaN(offset.x) || isNaN(offset.y))
                        return NaN;

                    var polarCoords = this._getPolarAxisCoords(groupIndex, rect);
                    pos = $.jqx._ptdist(offset.x, offset.y, polarCoords.x, polarCoords.y);
                    axisSize = polarCoords.r;
                    pos = axisSize - pos;
                }
                else {
                    if (group.orientation == 'horizontal') {
                        if (offset < rect.x || offset > rect.x + rect.width)
                            return NaN;

                        pos = offset - rect.x;

                        axisSize = rect.width;
                    }
                    else {
                        if (offset < rect.y || offset > rect.y + rect.height)
                            return NaN;

                        pos = offset - rect.y;

                        axisSize = rect.height;
                    }
                }

                var gstat = this._stats.seriesGroups[groupIndex];

                var value = this._jqxPlot.scale(
                    pos,
                    {
                        min: 0,
                        max: axisSize
                    },
                    {
                        min: gstat.min.valueOf(),
                        max: gstat.max.valueOf(),
                        type: gstat.logarithmic ? 'logarithmic' : 'linear',
                        base: gstat.logBase,
                        flip: !valueAxis.flip
                    }
                );

                return value;
            },


            _detectDateFormat: function (samples, additionalFormats) {
                var formats = {
                    // en-US
                    // short date pattern
                    en_US_d: "M/d/yyyy",
                    // long date pattern
                    en_US_D: "dddd, MMMM dd, yyyy",
                    // short time pattern
                    en_US_t: "h:mm tt",
                    // long time pattern
                    en_US_T: "h:mm:ss tt",
                    // long date, short time pattern
                    en_US_f: "dddd, MMMM dd, yyyy h:mm tt",
                    // long date, long time pattern
                    en_US_F: "dddd, MMMM dd, yyyy h:mm:ss tt",
                    // month/day pattern
                    en_US_M: "MMMM dd",
                    // month/year pattern
                    en_US_Y: "yyyy MMMM",
                    // S is a sortable format that does not vary by culture
                    en_US_S: "yyyy\u0027-\u0027MM\u0027-\u0027dd\u0027T\u0027HH\u0027:\u0027mm\u0027:\u0027ss",

                    // en-CA
                    en_CA_d: "dd/MM/yyyy",
                    en_CA_D: "MMMM-dd-yy",
                    en_CA_f: "MMMM-dd-yy h:mm tt",
                    en_CA_F: "MMMM-dd-yy h:mm:ss tt",

                    // formatting of dates in MySQL Databases
                    ISO: "yyyy-MM-dd hh:mm:ss",
                    ISO2: "yyyy-MM-dd HH:mm:ss",
                    d1: "dd.MM.yyyy",
                    d2: "dd-MM-yyyy",
                    zone1: "yyyy-MM-ddTHH:mm:ss-HH:mm",
                    zone2: "yyyy-MM-ddTHH:mm:ss+HH:mm",
                    custom: "yyyy-MM-ddTHH:mm:ss.fff",
                    custom2: "yyyy-MM-dd HH:mm:ss.fff",

                    // de-DE
                    de_DE_d: "dd.MM.yyyy",
                    de_DE_D: "dddd, d. MMMM yyyy",
                    de_DE_t: "HH:mm",
                    de_DE_T: "HH:mm:ss",
                    de_DE_f: "dddd, d. MMMM yyyy HH:mm",
                    de_DE_F: "dddd, d. MMMM yyyy HH:mm:ss",
                    de_DE_M: "dd MMMM",
                    de_DE_Y: "MMMM yyyy",

                    // fr-FR
                    fr_FR_d: "dd/MM/yyyy",
                    fr_FR_D: "dddd d MMMM yyyy",
                    fr_FR_t: "HH:mm",
                    fr_FR_T: "HH:mm:ss",
                    fr_FR_f: "dddd d MMMM yyyy HH:mm",
                    fr_FR_F: "dddd d MMMM yyyy HH:mm:ss",
                    fr_FR_M: "d MMMM",
                    fr_FR_Y: "MMMM yyyy",

                    // it-IT
                    it_IT_d: "dd/MM/yyyy",
                    it_IT_D: "dddd d MMMM yyyy",
                    it_IT_t: "HH:mm",
                    it_IT_T: "HH:mm:ss",
                    it_IT_f: "dddd d MMMM yyyy HH:mm",
                    it_IT_F: "dddd d MMMM yyyy HH:mm:ss",
                    it_IT_M: "dd MMMM",
                    it_IT_Y: "MMMM yyyy",

                    // Ru
                    ru_RU_d: "dd.MM.yyyy",
                    ru_RU_D: "d MMMM yyyy '?.'",
                    ru_RU_t: "H:mm",
                    ru_RU_T: "H:mm:ss",
                    ru_RU_f: "d MMMM yyyy '?.' H:mm",
                    ru_RU_F: "d MMMM yyyy '?.' H:mm:ss",
                    ru_RU_Y: "MMMM yyyy",

                    // cs-CZ
                    cs_CZ_d: "d.M.yyyy",
                    cs_CZ_D: "d. MMMM yyyy",
                    cs_CZ_t: "H:mm",
                    cs_CZ_T: "H:mm:ss",
                    cs_CZ_f: "d. MMMM yyyy H:mm",
                    cs_CZ_F: "d. MMMM yyyy H:mm:ss",
                    cs_CZ_M: "dd MMMM",
                    cs_CZ_Y: "MMMM yyyy",

                    // he-IL
                    he_IL_d: "dd MMMM yyyy",
                    he_IL_D: "dddd dd MMMM yyyy",
                    he_IL_t: "HH:mm",
                    he_IL_T: "HH:mm:ss",
                    he_IL_f: "dddd dd MMMM yyyy HH:mm",
                    he_IL_F: "dddd dd MMMM yyyy HH:mm:ss",
                    he_IL_M: "dd MMMM",
                    he_IL_Y: "MMMM yyyy",

                    // hr-HR
                    hr_HR_d: "d.M.yyyy.",
                    hr_HR_D: "d. MMMM yyyy.",
                    hr_HR_t: "H:mm",
                    hr_HR_T: "H:mm:ss",
                    hr_HR_f: "d. MMMM yyyy. H:mm",
                    hr_HR_F: "d. MMMM yyyy. H:mm:ss",
                    hr_HR_M: "d. MMMM",

                    // hu-HU
                    hu_HU_d: "yyyy.MM.dd.",
                    hu_HU_D: "yyyy. MMMM d.",
                    hu_HU_t: "H:mm",
                    hu_HU_T: "H:mm:ss",
                    hu_HU_f: "yyyy. MMMM d. H:mm",
                    hu_HU_F: "yyyy. MMMM d. H:mm:ss",
                    hu_HU_M: "MMMM d.",
                    hu_HU_Y: "yyyy. MMMM",

                    // jp-JP
                    jp_JP_d: "gg y/M/d",
                    jp_JP_D: "gg y'?'M'?'d'?'",
                    jp_JP_t: "H:mm",
                    jp_JP_T: "H:mm:ss",
                    jp_JP_f: "gg y'?'M'?'d'?' H:mm",
                    jp_JP_F: "gg y'?'M'?'d'?' H:mm:ss",
                    jp_JP_M: "M'?'d'?'",
                    jp_JP_Y: "gg y'?'M'?'",

                    // LT
                    lt_LT_d: "yyyy.MM.dd",
                    lt_LT_D: "yyyy 'm.' MMMM d 'd.'",
                    lt_LT_t: "HH:mm",
                    lt_LT_T: "HH:mm:ss",
                    lt_LT_f: "yyyy 'm.' MMMM d 'd.' HH:mm",
                    lt_LT_F: "yyyy 'm.' MMMM d 'd.' HH:mm:ss",
                    lt_LT_M: "MMMM d 'd.'",
                    lt_LT_Y: "yyyy 'm.' MMMM",

                    // sa-IN
                    sa_IN_d: "dd-MM-yyyy",
                    sa_IN_D: "dd MMMM yyyy dddd",
                    sa_IN_t: "HH:mm",
                    sa_IN_T: "HH:mm:ss",
                    sa_IN_f: "dd MMMM yyyy dddd HH:mm",
                    sa_IN_F: "dd MMMM yyyy dddd HH:mm:ss",
                    sa_IN_M: "dd MMMM",

                    // basic
                    basic_y: "yyyy",
                    basic_ym: "yyyy-MM",
                    basic_d: "yyyy-MM-dd",
                    basic_dhm: "yyyy-MM-dd hh:mm",
                    basic_bhms: "yyyy-MM-dd hh:mm:ss",
                    basic2_ym: "MM-yyyy",
                    basic2_d: "MM-dd-yyyy",
                    basic2_dhm: "MM-dd-yyyy hh:mm",
                    basic2_dhms: "MM-dd-yyyy hh:mm:ss",

                    basic3_ym: "yyyy/MM",
                    basic3_d: "yyyy/MM/dd",
                    basic3_dhm: "yyyy/MM/dd hh:mm",
                    basic3_bhms: "yyyy/MM/dd hh:mm:ss",
                    basic4_ym: "MM/yyyy",
                    basic4_d: "MM/dd/yyyy",
                    basic4_dhm: "MM/dd/yyyy hh:mm",
                    basic4_dhms: "MM/dd/yyyy hh:mm:ss"
                };

                if (additionalFormats)
                    formats = $.extend({}, formats, additionalFormats);

                var arr = [];
                if (!$.isArray(samples))
                    arr.push(samples);
                else
                    arr = samples;

                for (var j in formats)
                    formats[j] = { format: formats[j], count: 0 };

                for (var i = 0; i < arr.length; i++) {
                    var value = arr[i];
                    if (value == null || value == undefined)
                        continue;

                    for (var j in formats) {
                        var result = $.jqx.dataFormat.parsedate(value, formats[j].format);
                        if (result != null)
                            formats[j].count++;
                    }
                }

                var best = { key: undefined, count: 0 };
                for (var j in formats) {
                    if (formats[j].count > best.count) {
                        best.key = j;
                        best.count = formats[j].count;
                    }
                }

                return best.key ? formats[best.key].format : '';
            },

            _testXAxisDateFormat: function (groupIndex) {
                var self = this;

                var xAxis = self._getXAxis(groupIndex);
                var dataLength = self._getDataLen(groupIndex);

                var localizationFormats = {};
                if (self.localization && self.localization.patterns) {
                    for (var key in self.localization.patterns)
                        localizationFormats['local_' + key] = self.localization.patterns[key];
                }

                var samples = [];
                for (var i = 0; i < dataLength && i < 10; i++) {
                    var value = self._getDataValue(i, xAxis.dataField, groupIndex);
                    if (value == null || value == undefined)
                        continue;

                    samples.push(value);
                }

                var dateFormat = self._detectDateFormat(samples, localizationFormats);
                return dateFormat;
            }
        });

})(jqxBaseFramework);
})();



/***/ }),

/***/ 2306:
/***/ (() => {

/* tslint:disable */
/* eslint-disable */
(function(){
	if (typeof document === 'undefined') { 
		return;
	}

(function ($) {
    $.extend($.jqx._jqxChart.prototype,
    {
        _moduleRangeSelector: true,

        /**
        * Renders the xAxis range selector
        * @private 
        * @param {number} group index
        * @param {object} bounding rectangle of the xAxis in relative coords
        */
        _renderXAxisRangeSelector: function (groupIndex, rect) {
            var self = this;
            self._isTouchDevice = $.jqx.mobile.isTouchDevice();

            var g = self.seriesGroups[groupIndex];
            var axis = self._getXAxis(groupIndex);
            var rangeSelector = axis ? axis.rangeSelector : undefined;

            if (!self._isSelectorRefresh) {
                var elHost = (rangeSelector && rangeSelector.renderTo) ? rangeSelector.renderTo : self.host;
                elHost.find(".rangeSelector").remove();
            }

            if (!axis || axis.visible == false || g.type == 'spider')
                return false;

            if (!self._isGroupVisible(groupIndex))
                return false;

            if (!rangeSelector)
                return false;

            var swapXY = g.orientation == 'horizontal';
            if (rangeSelector.renderTo)
                swapXY = false;

            if (self.rtl)
                axis.flip = true;

            var axisSize = swapXY ? this.host.height() : this.host.width();
            axisSize -= 4;

            var axisStats = this._getXAxisStats(groupIndex, axis, axisSize);

            var axisPosition = axis.position;
            if (rangeSelector.renderTo && rangeSelector.position)
                axisPosition = rangeSelector.position;

            if (!this._isSelectorRefresh) {
                var renderTo = rangeSelector.renderTo;

                var div = "<div class='rangeSelector jqx-disableselect' style='position: absolute; background-color: transparent;' onselectstart='return false;'></div>";

                var element = $(div).appendTo(renderTo ? renderTo : this.renderer.getContainer());

                if (!renderTo) {
                    var coord = this.host.coord();
                    coord.top = 0;
                    coord.left = 0;
                    var selectorSize = this._selectorGetSize(axis);
                    if (!swapXY) {
                        element.css('left', coord.left + 1);
                        element.css('top', coord.top + rect.y + (axisPosition != 'top' ? rect.height : -selectorSize));
                        element.css('height', selectorSize);
                        element.css('width', axisSize);

                        // rect.width = selectorSize;
                    }
                    else {
                        element.css('left', coord.left + 1 + rect.x + (axisPosition != 'right' ? -selectorSize : rect.width));
                        element.css('top', coord.top);
                        element.css('height', axisSize);
                        element.css('width', selectorSize);

                        rect.height = selectorSize;
                    }
                }
                else {
                    element.css({ width: renderTo.width(), height: renderTo.height() });
                    rect.width = renderTo.width();
                    rect.height = renderTo.height();
                }

                this._refreshSelector(groupIndex, axis, axisStats, element, rect, swapXY);
            }

            this._isSelectorRefresh = false;

            return true;
        },


        _refreshSelector: function (groupIndex, axis, axisStats, renderTo, rect, swapXY) {
            var xAxisSettings = {};
            var selector = axis.rangeSelector;
            var group = this.seriesGroups[groupIndex];

            for (var i in selector)
                xAxisSettings[i] = selector[i];

            delete xAxisSettings.padding;

            var min = xAxisSettings.minValue;
            var max = xAxisSettings.maxValue;

            if (undefined == min)
                min = Math.min(axisStats.min.valueOf(), axisStats.dsRange.min.valueOf());
            if (undefined == max)
                max = Math.max(axisStats.max.valueOf(), axisStats.dsRange.max.valueOf());

            if (this._isDate(axisStats.min))
                min = new Date(min);
            if (this._isDate(axisStats.max))
                max = new Date(max);

            var axisPosition = axis.position;
            if (selector.renderTo && selector.position)
                axisPosition = selector.position;

            xAxisSettings.dataField = axis.dataField;
            delete xAxisSettings.rangeSelector;
            xAxisSettings.type = axis.type;
            xAxisSettings.baseUnit = selector.baseUnit || axis.baseUnit;
            xAxisSettings.minValue = min;
            xAxisSettings.maxValue = max;
            xAxisSettings.flip = axis.flip;
            xAxisSettings.position = axisPosition;

            var defaultPadding = 5;

            var leftPadding = 2,
                rightPadding = 2,
                topPadding = 2,
                bottomPadding = 2;

            if (!selector.renderTo) {
                leftPadding = swapXY ? 0 : rect.x;
                rightPadding = swapXY ? 0 : this._rect.width - rect.x - rect.width;
                topPadding = swapXY ? rect.y : defaultPadding;
                bottomPadding = swapXY ? this._paddedRect.height - this._plotRect.height : defaultPadding;
            }

            var padding = selector.padding;
            if (padding == undefined && !selector.renderTo)
                padding = { left: leftPadding, top: topPadding, right: rightPadding, bottom: bottomPadding };
            else {
                padding = {
                    left: ((padding && padding.left) ? padding.left : leftPadding),
                    top: ((padding && padding.top) ? padding.top : topPadding),
                    right: ((padding && padding.right) ? padding.right : rightPadding),
                    bottom: ((padding && padding.bottom) ? padding.bottom : bottomPadding)
                };
            }

            var dataField = axis.rangeSelector.dataField;
            for (var i = 0; undefined == dataField && i < this.seriesGroups.length; i++) {
                for (var j = 0; undefined == dataField && j < this.seriesGroups[i].series.length; j++)
                    dataField = this.seriesGroups[i].series[j].dataField;
            }

            var rangeSelectorSettings =
            {
                padding: padding,
                _isRangeSelectorInstance: true,
                title: selector.title || '',
                description: selector.description || '',
                titlePadding: selector.titlePadding,
                colorScheme: selector.colorScheme || this.colorScheme,
                backgroundColor: selector.backgroundColor || this.backgroundColor || 'transparent',
                backgroundImage: selector.backgroundImage || '',
                showBorderLine: selector.showBorderLine || (selector.renderTo ? true : false),
                borderLineWidth: selector.borderLineWidth || this.borderLineWidth,
                borderLineColor: selector.borderLineColor || this.borderLineColor,
                rtl: selector.rtl || this.rtl,
                greyScale: selector.greyScale || this.greyScale,
                renderEngine: this.renderEngine,
                showLegend: false,
                enableAnimations: false,
                enableEvents: false,
                showToolTips: false,
                source: this.source,
                xAxis: xAxisSettings,
                seriesGroups:
                [
                    {
                        orientation: swapXY ? 'horizontal' : 'vertical',
                        valueAxis:
                        {
                            visible: false
                            //unitInterval: 10
                        },
                        type: axis.rangeSelector.serieType || 'area',
                        skipOverlappingPoints: $.jqx.getByPriority([axis.rangeSelector.skipOverlappingPoints, true]),
                        columnSeriesOverlap: $.jqx.getByPriority([axis.rangeSelector.columnSeriesOverlap, false]),
                        columnsGapPercent: $.jqx.getByPriority([axis.rangeSelector.columnsGapPercent, 25]),
                        seriesGapPercent: $.jqx.getByPriority([axis.rangeSelector.seriesGapPercent, 25]),
                        series:
                            [
                                { dataField: dataField, opacity: 0.8, lineWidth: 1 }
                            ]
                    }
                ]
            }

            if (axis.rangeSelector.seriesGroups) {
                rangeSelectorSettings.seriesGroups = axis.rangeSelector.seriesGroups;
            }
            if (axis.rangeSelector.valueAxis) {
                rangeSelectorSettings.valueAxis = axis.rangeSelector.valueAxis;
            }

            if (!rangeSelectorSettings.showBorderLine) {
                rangeSelectorSettings.borderLineWidth = 1;
                rangeSelectorSettings.borderLineColor = $.jqx.getByPriority([this.backgroundColor, this.background, '#FFFFFF']);
                rangeSelectorSettings.showBorderLine = true;
            }



            var self = this;

            self._supressBindingRefresh = true;

            renderTo.empty();
            renderTo.jqxChart(rangeSelectorSettings);

            self._rangeSelectorInstances[groupIndex] = renderTo;

            self._supressBindingRefresh = false;

            // disable for main chart when movign over the selector
            renderTo.on(self._getEvent('mousemove'), function () { self._unselect(); self._hideToolTip(); });

            var instance = renderTo.jqxChart('getInstance');
            if (!instance._plotRect)
                return;

            var sliderRect = instance._paddedRect;
            sliderRect.height = instance._plotRect.height;
            if (!swapXY && axisPosition == 'top')
                sliderRect.y += instance._renderData[0].xAxis.rect.height;
            else if (swapXY) {
                var sliderXAxisWidth = instance._renderData[0].xAxis.rect.width;
                sliderRect.width -= sliderXAxisWidth;
                if (axisPosition != 'right')
                    sliderRect.x += sliderXAxisWidth;
            }

            self._createSliderElements(groupIndex, renderTo, sliderRect, selector);

            self.removeHandler($(document), self._getEvent('mousemove') + '.' + this.element.id, self._onSliderMouseMove)
            self.removeHandler($(document), self._getEvent('mousedown'), self._onSliderMouseDown)
            self.removeHandler($(document), self._getEvent('mouseup') + '.' + this.element.id, self._onSliderMouseUp)

            self.addHandler($(document), self._getEvent('mousemove') + '.' + this.element.id, self._onSliderMouseMove, { self: this, groupIndex: groupIndex, renderTo: renderTo, swapXY: swapXY });
            self.addHandler($(renderTo), self._getEvent('mousedown'), this._onSliderMouseDown, { self: this, groupIndex: groupIndex, renderTo: renderTo, swapXY: swapXY });
            self.addHandler($(document), self._getEvent('mouseup') + '.' + this.element.id, self._onSliderMouseUp, { element: this.element.id, self: this, groupIndex: groupIndex, renderTo: renderTo, swapXY: swapXY });
        },

        _createSliderElements: function (groupIndex, renderTo, rect, selectorSettings) {
            renderTo.find('.slider').remove();

            var colorSelectedRange = selectorSettings.selectedRangeColor || 'blue';
            var selectedRangeOpacity = $.jqx.getByPriority([selectorSettings.selectedRangeOpacity, 0.1]);
            var unselectedRangeOpacity = $.jqx.getByPriority([selectorSettings.unselectedRangeOpacity, 0.5]);
            var colorUnselectedRange = selectorSettings.unselectedRangeColor || 'white';
            var colorRangeLineColor = selectorSettings.rangeLineColor || 'grey';

            var div = $("<div class='slider' style='position: absolute;'></div>");
            div.css({ background: colorSelectedRange, opacity: selectedRangeOpacity, left: rect.x, top: rect.y, width: rect.width, height: rect.height });
            div.appendTo(renderTo);

            while (this._sliders.length < groupIndex + 1)
                this._sliders.push({});


            var divAreaDef = "<div class='slider' style='position: absolute;  background: " + colorUnselectedRange + "; opacity: " + unselectedRangeOpacity + ";'></div>";
            var divBorderDef = "<div class='slider' style='position: absolute; background:" + colorRangeLineColor + "; opacity: " + unselectedRangeOpacity + ";'></div>";
            var divBarDef = "<div class='slider jqx-rc-all' style='position: absolute; background: white; border-style: solid; border-width: 1px; border-color: " + colorRangeLineColor + ";'></div>";

            this._sliders[groupIndex] = {
                element: div,
                host: renderTo,
                _sliderInitialAbsoluteRect: { x: div.coord().left, y: div.coord().top, width: rect.width, height: rect.height },
                _hostInitialAbsolutePos: { x: renderTo.coord().left, y: renderTo.coord().top },
                getRect: function () {
                    return {
                        x: this.host.coord().left - this._hostInitialAbsolutePos.x + this._sliderInitialAbsoluteRect.x,
                        y: this.host.coord().top - this._hostInitialAbsolutePos.y + this._sliderInitialAbsoluteRect.y,
                        width: this._sliderInitialAbsoluteRect.width,
                        height: this._sliderInitialAbsoluteRect.height
                    };
                },
                rect: rect,
                left: $(divAreaDef),
                right: $(divAreaDef),
                leftTop: $(divBorderDef),
                rightTop: $(divBorderDef),
                leftBorder: $(divBorderDef),
                leftBar: $(divBarDef),
                rightBorder: $(divBorderDef),
                rightBar: $(divBarDef)
            };

            this._sliders[groupIndex].left.appendTo(renderTo);
            this._sliders[groupIndex].right.appendTo(renderTo);
            this._sliders[groupIndex].leftTop.appendTo(renderTo);
            this._sliders[groupIndex].rightTop.appendTo(renderTo);
            this._sliders[groupIndex].leftBorder.appendTo(renderTo);
            this._sliders[groupIndex].rightBorder.appendTo(renderTo);
            this._sliders[groupIndex].leftBar.appendTo(renderTo);
            this._sliders[groupIndex].rightBar.appendTo(renderTo);

            var renderData = this._renderData[groupIndex].xAxis;
            var stats = renderData.data.axisStats;

            var minValue = stats.min.valueOf();
            var maxValue = stats.max.valueOf();

            var startOffset = this._valueToOffset(groupIndex, minValue);
            var endOffset = this._valueToOffset(groupIndex, maxValue);

            if (startOffset > endOffset) {
                var tmp = endOffset;
                endOffset = startOffset;
                startOffset = tmp;
            }

            if (this.seriesGroups[groupIndex].orientation != 'horizontal')
                div.css({ left: Math.round(rect.x + startOffset), top: rect.y, width: Math.round(endOffset - startOffset), height: rect.height });
            else
                div.css({ top: Math.round(rect.y + startOffset), left: rect.x, height: Math.round(endOffset - startOffset), width: rect.width });

            this._setSliderPositions(groupIndex, startOffset, endOffset);
        },

        _setSliderPositions: function (groupIndex, startOffset, endOffset) {
            var g = this.seriesGroups[groupIndex];
            var axis = this._getXAxis(groupIndex);
            var selector = axis.rangeSelector;

            var swapXY = g.orientation == 'horizontal';
            if (axis.rangeSelector.renderTo)
                swapXY = false;

            var axisPosition = axis.position;
            if (selector.renderTo && selector.position)
                axisPosition = selector.position;

            var invertedAxisPos = (swapXY && axisPosition == 'right') || (!swapXY && axisPosition == 'top');

            var slider = this._sliders[groupIndex];

            var posProp = swapXY ? 'top' : 'left';
            var oPosProp = swapXY ? 'left' : 'top';
            var sizeProp = swapXY ? 'height' : 'width';
            var oSizeProp = swapXY ? 'width' : 'height';
            var rectPosProp = swapXY ? 'y' : 'x';
            var rectOPosProp = swapXY ? 'x' : 'y';

            var rect = slider.rect;

            slider.startOffset = startOffset;
            slider.endOffset = endOffset;

            slider.left.css(posProp, rect[rectPosProp]);
            slider.left.css(oPosProp, rect[rectOPosProp]);
            slider.left.css(sizeProp, startOffset);
            slider.left.css(oSizeProp, rect[oSizeProp]);

            slider.right.css(posProp, rect[rectPosProp] + endOffset);
            slider.right.css(oPosProp, rect[rectOPosProp]);
            slider.right.css(sizeProp, rect[sizeProp] - endOffset + 1);
            slider.right.css(oSizeProp, rect[oSizeProp]);

            slider.leftTop.css(posProp, rect[rectPosProp]);
            slider.leftTop.css(oPosProp, rect[rectOPosProp] + (((swapXY && axisPosition == 'right') || (!swapXY && axisPosition != 'top')) ? 0 : rect[oSizeProp]));
            slider.leftTop.css(sizeProp, startOffset);
            slider.leftTop.css(oSizeProp, 1);

            slider.rightTop.css(posProp, rect[rectPosProp] + endOffset);
            slider.rightTop.css(oPosProp, rect[rectOPosProp] + (((swapXY && axisPosition == 'right') || (!swapXY && axisPosition != 'top')) ? 0 : rect[oSizeProp]));
            slider.rightTop.css(sizeProp, rect[sizeProp] - endOffset + 1);
            slider.rightTop.css(oSizeProp, 1);

            slider.leftBorder.css(posProp, rect[rectPosProp] + startOffset);
            slider.leftBorder.css(oPosProp, rect[rectOPosProp]);
            slider.leftBorder.css(sizeProp, 1);
            slider.leftBorder.css(oSizeProp, rect[oSizeProp]);

            var handleBarSize = rect[oSizeProp] / 4;
            if (handleBarSize > 20)
                handleBarSize = 20;
            if (handleBarSize < 3)
                handleBarSize = 3;

            slider.leftBar.css(posProp, rect[rectPosProp] + startOffset - 3);
            slider.leftBar.css(oPosProp, rect[rectOPosProp] + rect[oSizeProp] / 2 - handleBarSize / 2);
            slider.leftBar.css(sizeProp, 5);
            slider.leftBar.css(oSizeProp, handleBarSize);

            slider.rightBorder.css(posProp, rect[rectPosProp] + endOffset);
            slider.rightBorder.css(oPosProp, rect[rectOPosProp]);
            slider.rightBorder.css(sizeProp, 1);
            slider.rightBorder.css(oSizeProp, rect[oSizeProp]);

            slider.rightBar.css(posProp, rect[rectPosProp] + endOffset - 3);
            slider.rightBar.css(oPosProp, rect[rectOPosProp] + rect[oSizeProp] / 2 - handleBarSize / 2);
            slider.rightBar.css(sizeProp, 5);
            slider.rightBar.css(oSizeProp, handleBarSize);

        },

        _resizeState: {},

        _onSliderMouseDown: function (event) {
            event.stopImmediatePropagation();
            event.stopPropagation();

            var self = event.data.self;
            var slider = self._sliders[event.data.groupIndex];
            if (!slider)
                return;

            if (self._resizeState.state == undefined)
                self._testAndSetReadyResize(event);

            if (self._resizeState.state != 'ready')
                return;

            $.jqx._rangeSelectorTarget = self;
            self._resizeState.state = 'resizing';
        },

        _valueToOffset: function (groupIndex, value) {
            var group = this.seriesGroups[groupIndex];
            var slider = this._sliders[groupIndex];

            var selectorChart = slider.host.jqxChart('getInstance');
            var renderData = selectorChart._renderData[0].xAxis;
            var stats = renderData.data.axisStats;

            var axisMin = stats.min.valueOf();
            var axisMax = stats.max.valueOf();

            var denom = axisMax - axisMin;
            if (denom == 0)
                denom = 1;

            var axis = this._getXAxis(groupIndex);
            var sizeProp = group.orientation == 'horizontal' ? 'height' : 'width';

            var percent = (value.valueOf() - axisMin) / denom;

            return slider.getRect()[sizeProp] * (axis.flip ? (1 - percent) : percent);
        },

        _offsetToValue: function (groupIndex, offset) {
            var slider = this._sliders[groupIndex];

            var group = this.seriesGroups[groupIndex];
            var axis = this._getXAxis(groupIndex);

            var sizeProp = group.orientation == 'horizontal' ? 'height' : 'width';

            var denom = slider.getRect()[sizeProp];
            if (denom == 0)
                denom = 1;
            var percent = offset / denom;

            var selectorChart = slider.host.jqxChart('getInstance');
            var renderData = selectorChart._renderData[0].xAxis;
            var stats = renderData.data.axisStats;

            var axisMin = stats.min.valueOf();
            var axisMax = stats.max.valueOf();

            var value = offset / denom * (axisMax - axisMin) + axisMin;

            if (axis.flip == true) {
                value = axisMax - offset / denom * (axisMax - axisMin);
            }

            if (this._isDate(stats.min) || this._isDate(stats.max)) {
                value = new Date(value);
            }
            else {
                if (axis.dataField == undefined || stats.useIndeces)
                    value = Math.round(value);

                if (value < stats.min)
                    value = stats.min;
                if (value > stats.max)
                    value = stats.max;
            }

            return value;
        },

        _onSliderMouseUp: function (event) {
            var self = $.jqx._rangeSelectorTarget;
            if (!self)
                return;

            var groupIndex = event.data.groupIndex;
            var swapXY = event.data.swapXY;

            var slider = self._sliders[groupIndex];
            if (!slider)
                return;

            if (self._resizeState.state != 'resizing')
                return;

            event.stopImmediatePropagation();
            event.stopPropagation();

            self._resizeState = {};

            // update
            self.host.css('cursor', 'default');

            var leftProp = !swapXY ? 'left' : 'top';
            var widthProp = !swapXY ? 'width' : 'height';
            var posProp = !swapXY ? 'x' : 'y';

            var from = slider.element.coord()[leftProp];
            var to = from + (!swapXY ? slider.element.width() : slider.element.height());

            var fullRect = slider.getRect();

            var minValue = self._offsetToValue(groupIndex, from - fullRect[posProp]);
            var maxValue = self._offsetToValue(groupIndex, to - fullRect[posProp]);

            var selectorChart = slider.host.jqxChart('getInstance');
            var renderData = selectorChart._renderData[0].xAxis;
            var stats = renderData.data.axisStats;

            if (!stats.isTimeUnit && (maxValue.valueOf() - minValue.valueOf()) > 86400000) {
                minValue.setHours(0, 0, 0, 0);
                maxValue.setDate(maxValue.getDate() + 1);
                maxValue.setHours(0, 0, 0, 0);
            }

            var axis = self._getXAxis(groupIndex);
            if (axis.flip) {
                var tmp = minValue;
                minValue = maxValue;
                maxValue = tmp;
            }

            // apply to all groups that share this range selector
            for (var i = 0; i < self.seriesGroups.length; i++) {
                var groupXAxis = self._getXAxis(i);
                if (groupXAxis == axis)
                    self._selectorRange[i] = { min: minValue, max: maxValue };
            }

            self._isSelectorRefresh = true;
            var animSave = self.enableAnimations;

            self._raiseEvent('rangeSelectionChanging', { instance: self, minValue: minValue, maxValue: maxValue });

            self.enableAnimations = false;
            self.update();
            self.enableAnimations = animSave;

            self._raiseEvent('rangeSelectionChanged', { instance: self, minValue: minValue, maxValue: maxValue });
        },

        _onSliderMouseMove: function (event) {
            var self = event.data.self;
            var renderTo = event.data.renderTo;
            var groupIndex = event.data.groupIndex;
            var slider = self._sliders[groupIndex];
            var swapXY = event.data.swapXY;

            if (!slider)
                return;

            var rect = slider.getRect();
            var element = slider.element;

            var position = $.jqx.position(event);
            var coord = element.coord();

            var topProp = swapXY ? 'left' : 'top';
            var leftProp = !swapXY ? 'left' : 'top';
            var heightProp = swapXY ? 'width' : 'height';
            var widthProp = !swapXY ? 'width' : 'height';

            var posProp = !swapXY ? 'x' : 'y';

            if (self._resizeState.state == 'resizing') {
                event.stopImmediatePropagation();
                event.stopPropagation();

                if (self._resizeState.side == 'left') {
                    var diff = Math.round(position[leftProp] - coord[leftProp]);
                    var pos = rect[posProp];
                    if (coord[leftProp] + diff >= pos && coord[leftProp] + diff <= pos + rect[widthProp]) {
                        var left = parseInt(element.css(leftProp));
                        var newSize = Math.max(2, (swapXY ? element.height() : element.width()) - diff);
                        element.css(widthProp, newSize);
                        element.css(leftProp, left + diff);
                    }
                }
                else if (self._resizeState.side == 'right') {
                    var elementSize = swapXY ? element.height() : element.width();
                    var diff = Math.round(position[leftProp] - coord[leftProp] - elementSize);
                    var pos = rect[posProp];
                    if (coord[leftProp] + elementSize + diff >= pos && coord[leftProp] + diff + elementSize <= pos + rect[widthProp]) {
                        var newSize = Math.max(2, elementSize + diff);
                        element.css(widthProp, newSize);
                    }
                }
                else if (self._resizeState.side == 'move') {
                    var elementSize = swapXY ? element.height() : element.width();
                    var left = parseInt(element.css(leftProp));
                    var diff = Math.round(position[leftProp] - self._resizeState.startPos);

                    if (coord[leftProp] + diff >= rect[posProp] &&
                        coord[leftProp] + diff + elementSize <= rect[posProp] + rect[widthProp]
                    ) {
                        self._resizeState.startPos = position[leftProp];
                        element.css(leftProp, left + diff);
                    }
                }

                var startOffset = parseInt(element.css(leftProp)) - slider.rect[posProp];
                var endOffset = startOffset + (swapXY ? element.height() : element.width());
                self._setSliderPositions(groupIndex, startOffset, endOffset);
            }
            else {
                self._testAndSetReadyResize(event);
            }
        },

        _testAndSetReadyResize: function (event) {
            var self = event.data.self;
            var renderTo = event.data.renderTo;
            var groupIndex = event.data.groupIndex;
            var slider = self._sliders[groupIndex];
            var swapXY = event.data.swapXY;

            var rect = slider.getRect();
            var element = slider.element;

            var position = $.jqx.position(event);
            var coord = element.coord();

            var topProp = swapXY ? 'left' : 'top';
            var leftProp = !swapXY ? 'left' : 'top';
            var heightProp = swapXY ? 'width' : 'height';
            var widthProp = !swapXY ? 'width' : 'height';

            var posProp = !swapXY ? 'x' : 'y';

            var diff = self._isTouchDevice ? 30 : 5;

            if (position[topProp] >= coord[topProp] && position[topProp] <= coord[topProp] + rect[heightProp]) {
                if (Math.abs(position[leftProp] - coord[leftProp]) <= diff) {
                    renderTo.css('cursor', swapXY ? 'row-resize' : 'col-resize');
                    self._resizeState = { state: 'ready', side: 'left' };
                }
                else if (Math.abs(position[leftProp] - coord[leftProp] - (!swapXY ? element.width() : element.height())) <= diff) {
                    renderTo.css('cursor', swapXY ? 'row-resize' : 'col-resize');
                    self._resizeState = { state: 'ready', side: 'right' };
                }
                else if (position[leftProp] + diff > coord[leftProp] && position[leftProp] - diff < coord[leftProp] + (!swapXY ? element.width() : element.height())) {
                    renderTo.css('cursor', 'pointer');
                    self._resizeState = { state: 'ready', side: 'move', startPos: position[leftProp] };
                }
                else {
                    renderTo.css('cursor', 'default');
                    self._resizeState = {};
                }
            }
            else {
                renderTo.css('cursor', 'default');
                self._resizeState = {};
            }
        },

        _selectorGetSize: function (axis) {
            if (axis.rangeSelector.renderTo)
                return 0;
            return axis.rangeSelector.size || this._paddedRect.height / 3;
        }

    });

})(jqxBaseFramework);
})();







/***/ }),

/***/ 2462:
/***/ (() => {

/* tslint:disable */
/* eslint-disable */
(function(){
	if (typeof document === 'undefined') { 
		return;
	}

(function ($) {
    $.extend($.jqx._jqxChart.prototype,
    {
        _moduleWaterfall: true,

        _isSummary: function (groupIndex, itemIndex) {
            var group = this.seriesGroups[groupIndex];
            for (var sidx = 0; sidx < group.series.length; sidx++) {
                if (undefined === group.series[sidx].summary)
                    continue;

                var summaryValue = this._getDataValue(itemIndex, group.series[sidx].summary, groupIndex)
                if (undefined !== summaryValue)
                    return true;
            }

            return false;
        },

        _applyWaterfall: function (out, len, groupIndex, yzero, gbase, logBase, scale, inverse, isStacked) {
            var group = this.seriesGroups[groupIndex];

            if (out.length == 0)
                return out;

            var lastTo = yzero;

            // waterfall sums by serie / stack
            var wfSum = {};

            var seriesPrevVisibleIndex = [];

            var isDirectionDown = undefined;

            var seriesVisibility = [];
            for (var j = 0; j < group.series.length; j++)
                seriesVisibility.push(this._isSerieVisible(groupIndex, j));

            // The direction of the first column is relative to the baseline. For all columns after
            // that the direction is based on whether the value is positive or negative
            // For stacked series the key is -1. For non-stacked the serie index
            var firstItemRendered = {};

            for (var i = 0; i < len; i++) {
                var summaryLastTo = yzero;
                var summarySum = 0;
                var isSummaryItem = this._isSummary(groupIndex, i);

                for (var j = 0; j < out.length; j++) {
                    if (!seriesVisibility[j])
                        continue;

                    var refBase = 0;

                    // handle summary items
                    if (isSummaryItem) {
                        refBase = summaryLastTo == yzero ? gbase : 0;

                        out[j][i].value = wfSum[j];
                        out[j][i].summary = true;

                        isDirectionDown = out[j][i].value < refBase;
                        if (inverse)
                            isDirectionDown = !isDirectionDown;

                        var size = 0;
                        if (!isNaN(logBase))
                            size = this._getDataPointOffsetDiff(out[j][i].value + summarySum, summarySum == 0 ? gbase : summarySum, refBase || gbase, logBase, scale, yzero, inverse);
                        else
                            size = this._getDataPointOffsetDiff(out[j][i].value, refBase, refBase, NaN, scale, yzero, inverse);

                        out[j][i].to = summaryLastTo + (isDirectionDown ? size : -size);
                        out[j][i].from = summaryLastTo;

                        if (isStacked) {
                            summarySum += out[j][i].value;
                            summaryLastTo = out[j][i].to;
                        }

                        continue;
                    }
                    // end of summary items

                    var k = isStacked ? -1 : j;

                    if (isNaN(out[j][i].value))
                        continue;

                    if (undefined === firstItemRendered[k]) {
                        refBase = gbase;
                        firstItemRendered[k] = true;
                    }

                    isDirectionDown = out[j][i].value < refBase;
                    if (inverse)
                        isDirectionDown = !isDirectionDown;

                    var y = NaN, size = NaN;

                    if (!isStacked) {
                        y = i == 0 ? yzero : out[j][seriesPrevVisibleIndex[j]].to;
                    }
                    else {
                        y = lastTo;
                    }

                    var size = 0;
                    if (!isNaN(logBase))
                        size = this._getDataPointOffsetDiff(out[j][i].value + (isNaN(wfSum[k]) ? 0 : wfSum[k]), isNaN(wfSum[k]) ? gbase : wfSum[k], refBase || gbase, logBase, scale, y, inverse);
                    else
                        size = this._getDataPointOffsetDiff(out[j][i].value, refBase, refBase, NaN, scale, yzero, inverse);

                    out[j][i].to = lastTo = y + (isDirectionDown ? size : -size);
                    out[j][i].from = y;

                    if (isNaN(wfSum[k]))
                        wfSum[k] = out[j][i].value;
                    else
                        wfSum[k] += out[j][i].value;

                    if (k == -1) {
                        if (isNaN(wfSum[j]))
                            wfSum[j] = out[j][i].value;
                        else
                            wfSum[j] += out[j][i].value;
                    }

                    if (!isStacked)
                        seriesPrevVisibleIndex[j] = i;
                }
            }

            return out;
        }

    });
})(jqxBaseFramework);
})();





/***/ }),

/***/ 5459:
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/* tslint:disable */
/* eslint-disable */
(function(){
	if (typeof document === 'undefined') { 
		return;
	}
		
	var oldBrowser = document.all && !document.addEventListener;
	if (!oldBrowser) {
		(function (window, undefined) {
			var
				rootJQXLite,
				readyList,
				document = window.document,
				location = window.location,
				navigator = window.navigator,
				_JQXLite = window.JQXLite,
				_$ = window.$,

				// Save a reference to some core methods
				core_push = Array.prototype.push,
				core_slice = Array.prototype.slice,
				core_indexOf = Array.prototype.indexOf,
				core_toString = Object.prototype.toString,
				core_hasOwn = Object.prototype.hasOwnProperty,
				core_trim = String.prototype.trim,

				// Define a local copy of JQXLite
				JQXLite = function (selector, context) {
					// The JQXLite object is actually just the init constructor 'enhanced'
					return new JQXLite.fn.init(selector, context, rootJQXLite);
				},

				// Used for matching numbers
				core_pnum = /[\-+]?(?:\d*\.|)\d+(?:[eE][\-+]?\d+|)/.source,

				// Used for detecting and trimming whitespace
				core_rnotwhite = /\S/,
				core_rspace = /\s+/,

				// Make sure we trim BOM and NBSP (here's looking at you, Safari 5.0 and IE)
				rtrim = /^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,

				// A simple way to check for HTML strings
				// Prioritize #id over <tag> to avoid XSS via location.hash (#9521)
				rquickExpr = /^(?:[^#<]*(<[\w\W]+>)[^>]*$|#([\w\-]*)$)/,

				// Match a standalone tag
				rsingleTag = /^<(\w+)\s*\/?>(?:<\/\1>|)$/,

				// JSON RegExp
				rvalidchars = /^[\],:{}\s]*$/,
				rvalidbraces = /(?:^|:|,)(?:\s*\[)+/g,
				rvalidescape = /\\(?:["\\\/bfnrt]|u[\da-fA-F]{4})/g,
				rvalidtokens = /"[^"\\\r\n]*"|true|false|null|-?(?:\d\d*\.|)\d+(?:[eE][\-+]?\d+|)/g,

				// Matches dashed string for camelizing
				rmsPrefix = /^-ms-/,
				rdashAlpha = /-([\da-z])/gi,

				// Used by JQXLite.camelCase as callback to replace()
				fcamelCase = function (all, letter) {
					return (letter + "").toUpperCase();
				},

				// The ready event handler and self cleanup method
				DOMContentLoaded = function () {
					if (document.addEventListener) {
						document.removeEventListener("DOMContentLoaded", DOMContentLoaded, false);
						JQXLite.ready();
					} else if (document.readyState === "complete") {
						// we're here because readyState === "complete" in oldIE
						// which is good enough for us to call the dom ready!
						document.detachEvent("onreadystatechange", DOMContentLoaded);
						JQXLite.ready();
					}
				},

				// [[Class]] -> type pairs
				class2type = {};

			JQXLite.fn = JQXLite.prototype = {
				constructor: JQXLite,
				init: function (selector, context, rootJQXLite) {
					var match, elem, ret, doc;

					// Handle $(""), $(null), $(undefined), $(false)
					if (!selector) {
						return this;
					}

					// Handle $(DOMElement)
					if (selector.nodeType) {
						this.context = this[0] = selector;
						this.length = 1;
						return this;
					}

					// Handle HTML strings
					if (typeof selector === "string") {
						if (selector.charAt(0) === "<" && selector.charAt(selector.length - 1) === ">" && selector.length >= 3) {
							// Assume that strings that start and end with <> are HTML and skip the regex check
							match = [null, selector, null];

						} else {
							match = rquickExpr.exec(selector);
						}

						// Match html or make sure no context is specified for #id
						if (match && (match[1] || !context)) {

							// HANDLE: $(html) -> $(array)
							if (match[1]) {
								context = context instanceof JQXLite ? context[0] : context;
								doc = (context && context.nodeType ? context.ownerDocument || context : document);

								// scripts is true for back-compat
								selector = JQXLite.parseHTML(match[1], doc, true);
								if (rsingleTag.test(match[1]) && JQXLite.isPlainObject(context)) {
									this.attr.call(selector, context, true);
								}

								return JQXLite.merge(this, selector);

								// HANDLE: $(#id)
							} else {
								elem = document.getElementById(match[2]);

								// Check parentNode to catch when Blackberry 4.6 returns
								// nodes that are no longer in the document #6963
								if (elem && elem.parentNode) {
									// Handle the case where IE and Opera return items
									// by name instead of ID
									if (elem.id !== match[2]) {
										return rootJQXLite.find(selector);
									}

									// Otherwise, we inject the element directly into the JQXLite object
									this.length = 1;
									this[0] = elem;
								}

								this.context = document;
								this.selector = selector;
								return this;
							}

							// HANDLE: $(expr, $(...))
						} else if (!context || context.jqx) {
							return (context || rootJQXLite).find(selector);

							// HANDLE: $(expr, context)
							// (which is just equivalent to: $(context).find(expr)
						} else {
							return this.constructor(context).find(selector);
						}

						// HANDLE: $(function)
						// Shortcut for document ready
					} else if (JQXLite.isFunction(selector)) {
						return rootJQXLite.ready(selector);
					}

					if (selector.selector !== undefined) {
						this.selector = selector.selector;
						this.context = selector.context;
					}

					return JQXLite.makeArray(selector, this);
				},

				// Start with an empty selector
				selector: "",

				// The current version of JQXLite being used
				jqx: "4.5.0",

				// The default length of a JQXLite object is 0
				length: 0,

				// The number of elements contained in the matched element set
				size: function () {
					return this.length;
				},

				toArray: function () {
					return core_slice.call(this);
				},

				// Get the Nth element in the matched element set OR
				// Get the whole matched element set as a clean array
				get: function (num) {
					return num == null ?

						// Return a 'clean' array
						this.toArray() :

						// Return just the object
						(num < 0 ? this[this.length + num] : this[num]);
				},

				// Take an array of elements and push it onto the stack
				// (returning the new matched element set)
				pushStack: function (elems, name, selector) {

					// Build a new JQXLite matched element set
					var ret = JQXLite.merge(this.constructor(), elems);

					// Add the old object onto the stack (as a reference)
					ret.prevObject = this;

					ret.context = this.context;

					if (name === "find") {
						ret.selector = this.selector + (this.selector ? " " : "") + selector;
					} else if (name) {
						ret.selector = this.selector + "." + name + "(" + selector + ")";
					}

					// Return the newly-formed element set
					return ret;
				},

				// Execute a callback for every element in the matched set.
				// (You can seed the arguments with an array of args, but this is
				// only used internally.)
				each: function (callback, args) {
					return JQXLite.each(this, callback, args);
				},

				ready: function (fn) {
					// Add the callback
					JQXLite.ready.promise().done(fn);

					return this;
				},

				eq: function (i) {
					i = +i;
					return i === -1 ?
						this.slice(i) :
						this.slice(i, i + 1);
				},

				first: function () {
					return this.eq(0);
				},

				last: function () {
					return this.eq(-1);
				},

				slice: function () {
					return this.pushStack(core_slice.apply(this, arguments),
						"slice", core_slice.call(arguments).join(","));
				},

				map: function (callback) {
					return this.pushStack(JQXLite.map(this, function (elem, i) {
						return callback.call(elem, i, elem);
					}));
				},

				end: function () {
					return this.prevObject || this.constructor(null);
				},

				// For internal use only.
				// Behaves like an Array's method, not like a JQXLite method.
				push: core_push,
				sort: [].sort,
				splice: [].splice
			};

			// Give the init function the JQXLite prototype for later instantiation
			JQXLite.fn.init.prototype = JQXLite.fn;

			JQXLite.extend = JQXLite.fn.extend = function () {
				var options, name, src, copy, copyIsArray, clone,
					target = arguments[0] || {},
					i = 1,
					length = arguments.length,
					deep = false;

				// Handle a deep copy situation
				if (typeof target === "boolean") {
					deep = target;
					target = arguments[1] || {};
					// skip the boolean and the target
					i = 2;
				}

				// Handle case when target is a string or something (possible in deep copy)
				if (typeof target !== "object" && !JQXLite.isFunction(target)) {
					target = {};
				}

				// extend JQXLite itself if only one argument is passed
				if (length === i) {
					target = this;
					--i;
				}

				for (; i < length; i++) {
					// Only deal with non-null/undefined values
					if ((options = arguments[i]) != null) {
						// Extend the base object
						for (name in options) {
							src = target[name];
							copy = options[name];

							// Prevent never-ending loop
							if (target === copy) {
								continue;
							}

							// Recurse if we're merging plain objects or arrays
							if (deep && copy && (JQXLite.isPlainObject(copy) || (copyIsArray = JQXLite.isArray(copy)))) {
								if (copyIsArray) {
									copyIsArray = false;
									clone = src && JQXLite.isArray(src) ? src : [];

								} else {
									clone = src && JQXLite.isPlainObject(src) ? src : {};
								}

								// Never move original objects, clone them
								target[name] = JQXLite.extend(deep, clone, copy);

								// Don't bring in undefined values
							} else if (copy !== undefined) {
								target[name] = copy;
							}
						}
					}
				}

				// Return the modified object
				return target;
			};

			JQXLite.extend({
				noConflict: function (deep) {
					if (window.$ === JQXLite) {
						window.$ = _$;
					}

					if (deep && window.JQXLite === JQXLite) {
						window.JQXLite = _JQXLite;
					}

					return JQXLite;
				},

				// Is the DOM ready to be used? Set to true once it occurs.
				isReady: false,

				// A counter to track how many items to wait for before
				// the ready event fires. See #6781
				readyWait: 1,

				// Hold (or release) the ready event
				holdReady: function (hold) {
					if (hold) {
						JQXLite.readyWait++;
					} else {
						JQXLite.ready(true);
					}
				},

				// Handle when the DOM is ready
				ready: function (wait) {

					// Abort if there are pending holds or we're already ready
					if (wait === true ? --JQXLite.readyWait : JQXLite.isReady) {
						return;
					}

					// Make sure body exists, at least, in case IE gets a little overzealous (ticket #5443).
					if (!document.body) {
						return setTimeout(JQXLite.ready, 1);
					}

					// Remember that the DOM is ready
					JQXLite.isReady = true;

					// If a normal DOM Ready event fired, decrement, and wait if need be
					if (wait !== true && --JQXLite.readyWait > 0) {
						return;
					}

					// If there are functions bound, to execute
					readyList.resolveWith(document, [JQXLite]);

					// Trigger any bound ready events
					if (JQXLite.fn.trigger) {
						JQXLite(document).trigger("ready").off("ready");
					}
				},

				// See test/unit/core.js for details concerning isFunction.
				// Since version 1.3, DOM methods and functions like alert
				// aren't supported. They return false on IE (#2968).
				isFunction: function (obj) {
					return JQXLite.type(obj) === "function";
				},

				isArray: Array.isArray || function (obj) {
					return JQXLite.type(obj) === "array";
				},

				isWindow: function (obj) {
					return obj != null && obj == obj.window;
				},

				isNumeric: function (obj) {
					return !isNaN(parseFloat(obj)) && isFinite(obj);
				},

				type: function (obj) {
					return obj == null ?
						String(obj) :
						class2type[core_toString.call(obj)] || "object";
				},

				isPlainObject: function (obj) {
					// Must be an Object.
					// Because of IE, we also have to check the presence of the constructor property.
					// Make sure that DOM nodes and window objects don't pass through, as well
					if (!obj || JQXLite.type(obj) !== "object" || obj.nodeType || JQXLite.isWindow(obj)) {
						return false;
					}

					try {
						// Not own constructor property must be Object
						if (obj.constructor &&
							!core_hasOwn.call(obj, "constructor") &&
							!core_hasOwn.call(obj.constructor.prototype, "isPrototypeOf")) {
							return false;
						}
					} catch (e) {
						// IE8,9 Will throw exceptions on certain host objects #9897
						return false;
					}

					// Own properties are enumerated firstly, so to speed up,
					// if last one is own, then all properties are own.

					var key;
					for (key in obj) { }

					return key === undefined || core_hasOwn.call(obj, key);
				},

				isEmptyObject: function (obj) {
					var name;
					for (name in obj) {
						return false;
					}
					return true;
				},

				error: function (msg) {
					throw new Error(msg);
				},

				// data: string of html
				// context (optional): If specified, the fragment will be created in this context, defaults to document
				// scripts (optional): If true, will include scripts passed in the html string
				parseHTML: function (data, context, scripts) {
					var parsed;
					if (!data || typeof data !== "string") {
						return null;
					}
					if (typeof context === "boolean") {
						scripts = context;
						context = 0;
					}
					context = context || document;

					// Single tag
					if ((parsed = rsingleTag.exec(data))) {
						return [context.createElement(parsed[1])];
					}

					parsed = JQXLite.buildFragment([data], context, scripts ? null : []);
					return JQXLite.merge([],
						(parsed.cacheable ? JQXLite.clone(parsed.fragment) : parsed.fragment).childNodes);
				},

				parseJSON: function (data) {
					if (!data || typeof data !== "string") {
						return null;
					}

					// Make sure leading/trailing whitespace is removed (IE can't handle it)
					data = JQXLite.trim(data);

					// Attempt to parse using the native JSON parser first
					if (window.JSON && window.JSON.parse) {
						return window.JSON.parse(data);
					}

					// Make sure the incoming data is actual JSON
					// Logic borrowed from http://json.org/json2.js
					if (rvalidchars.test(data.replace(rvalidescape, "@")
						.replace(rvalidtokens, "]")
						.replace(rvalidbraces, ""))) {

						return (new Function("return " + data))();

					}
					JQXLite.error("Invalid JSON: " + data);
				},

				// Cross-browser xml parsing
				parseXML: function (data) {
					var xml, tmp;
					if (!data || typeof data !== "string") {
						return null;
					}
					try {
						if (window.DOMParser) { // Standard
							tmp = new DOMParser();
							xml = tmp.parseFromString(data, "text/xml");
						} else { // IE
							xml = new ActiveXObject("Microsoft.XMLDOM");
							xml.async = "false";
							xml.loadXML(data);
						}
					} catch (e) {
						xml = undefined;
					}
					if (!xml || !xml.documentElement || xml.getElementsByTagName("parsererror").length) {
						JQXLite.error("Invalid XML: " + data);
					}
					return xml;
				},

				noop: function () { },

				// Evaluates a script in a global context
				// Workarounds based on findings by Jim Driscoll
				// http://weblogs.java.net/blog/driscoll/archive/2009/09/08/eval-javascript-global-context
				globalEval: function (data) {
					if (data && core_rnotwhite.test(data)) {
						// We use execScript on Internet Explorer
						// We use an anonymous function so that context is window
						// rather than JQXLite in Firefox
						(window.execScript || function (data) {
							window["eval"].call(window, data);
						})(data);
					}
				},

				// Convert dashed to camelCase; used by the css and data modules
				// Microsoft forgot to hump their vendor prefix (#9572)
				camelCase: function (string) {
					return string.replace(rmsPrefix, "ms-").replace(rdashAlpha, fcamelCase);
				},

				nodeName: function (elem, name) {
					return elem.nodeName && elem.nodeName.toLowerCase() === name.toLowerCase();
				},

				// args is for internal usage only
				each: function (obj, callback, args) {
					var name,
						i = 0,
						length = obj.length,
						isObj = length === undefined || JQXLite.isFunction(obj);

					if (args) {
						if (isObj) {
							for (name in obj) {
								if (callback.apply(obj[name], args) === false) {
									break;
								}
							}
						} else {
							for (; i < length;) {
								if (callback.apply(obj[i++], args) === false) {
									break;
								}
							}
						}

						// A special, fast, case for the most common use of each
					} else {
						if (isObj) {
							for (name in obj) {
								if (callback.call(obj[name], name, obj[name]) === false) {
									break;
								}
							}
						} else {
							for (; i < length;) {
								if (callback.call(obj[i], i, obj[i++]) === false) {
									break;
								}
							}
						}
					}

					return obj;
				},

				// Use native String.trim function wherever possible
				trim: core_trim && !core_trim.call("\uFEFF\xA0") ?
					function (text) {
						return text == null ?
							"" :
							core_trim.call(text);
					} :

					// Otherwise use our own trimming functionality
					function (text) {
						return text == null ?
							"" :
							(text + "").replace(rtrim, "");
					},

				// results is for internal usage only
				makeArray: function (arr, results) {
					var type,
						ret = results || [];

					if (arr != null) {
						// The window, strings (and functions) also have 'length'
						// Tweaked logic slightly to handle Blackberry 4.7 RegExp issues #6930
						type = JQXLite.type(arr);

						if (arr.length == null || type === "string" || type === "function" || type === "regexp" || JQXLite.isWindow(arr)) {
							core_push.call(ret, arr);
						} else {
							JQXLite.merge(ret, arr);
						}
					}

					return ret;
				},

				inArray: function (elem, arr, i) {
					var len;

					if (arr) {
						if (core_indexOf) {
							return core_indexOf.call(arr, elem, i);
						}

						len = arr.length;
						i = i ? i < 0 ? Math.max(0, len + i) : i : 0;

						for (; i < len; i++) {
							// Skip accessing in sparse arrays
							if (i in arr && arr[i] === elem) {
								return i;
							}
						}
					}

					return -1;
				},

				merge: function (first, second) {
					var l = second.length,
						i = first.length,
						j = 0;

					if (typeof l === "number") {
						for (; j < l; j++) {
							first[i++] = second[j];
						}

					} else {
						while (second[j] !== undefined) {
							first[i++] = second[j++];
						}
					}

					first.length = i;

					return first;
				},

				grep: function (elems, callback, inv) {
					var retVal,
						ret = [],
						i = 0,
						length = elems.length;
					inv = !!inv;

					// Go through the array, only saving the items
					// that pass the validator function
					for (; i < length; i++) {
						retVal = !!callback(elems[i], i);
						if (inv !== retVal) {
							ret.push(elems[i]);
						}
					}

					return ret;
				},

				// arg is for internal usage only
				map: function (elems, callback, arg) {
					var value, key,
						ret = [],
						i = 0,
						length = elems.length,
						// jqx objects are treated as arrays
						isArray = elems instanceof JQXLite || length !== undefined && typeof length === "number" && ((length > 0 && elems[0] && elems[length - 1]) || length === 0 || JQXLite.isArray(elems));

					// Go through the array, translating each of the items to their
					if (isArray) {
						for (; i < length; i++) {
							value = callback(elems[i], i, arg);

							if (value != null) {
								ret[ret.length] = value;
							}
						}

						// Go through every key on the object,
					} else {
						for (key in elems) {
							value = callback(elems[key], key, arg);

							if (value != null) {
								ret[ret.length] = value;
							}
						}
					}

					// Flatten any nested arrays
					return ret.concat.apply([], ret);
				},

				// A global GUID counter for objects
				guid: 1,

				// Bind a function to a context, optionally partially applying any
				// arguments.
				proxy: function (fn, context) {
					var tmp, args, proxy;

					if (typeof context === "string") {
						tmp = fn[context];
						context = fn;
						fn = tmp;
					}

					// Quick check to determine if target is callable, in the spec
					// this throws a TypeError, but we will just return undefined.
					if (!JQXLite.isFunction(fn)) {
						return undefined;
					}

					// Simulated bind
					args = core_slice.call(arguments, 2);
					proxy = function () {
						return fn.apply(context, args.concat(core_slice.call(arguments)));
					};

					// Set the guid of unique handler to the same of original handler, so it can be removed
					proxy.guid = fn.guid = fn.guid || JQXLite.guid++;

					return proxy;
				},

				// Multifunctional method to get and set values of a collection
				// The value/s can optionally be executed if it's a function
				access: function (elems, fn, key, value, chainable, emptyGet, pass) {
					var exec,
						bulk = key == null,
						i = 0,
						length = elems.length;

					// Sets many values
					if (key && typeof key === "object") {
						for (i in key) {
							JQXLite.access(elems, fn, i, key[i], 1, emptyGet, value);
						}
						chainable = 1;

						// Sets one value
					} else if (value !== undefined) {
						// Optionally, function values get executed if exec is true
						exec = pass === undefined && JQXLite.isFunction(value);

						if (bulk) {
							// Bulk operations only iterate when executing function values
							if (exec) {
								exec = fn;
								fn = function (elem, key, value) {
									return exec.call(JQXLite(elem), value);
								};

								// Otherwise they run against the entire set
							} else {
								fn.call(elems, value);
								fn = null;
							}
						}

						if (fn) {
							for (; i < length; i++) {
								fn(elems[i], key, exec ? value.call(elems[i], i, fn(elems[i], key)) : value, pass);
							}
						}

						chainable = 1;
					}

					return chainable ?
						elems :

						// Gets
						bulk ?
							fn.call(elems) :
							length ? fn(elems[0], key) : emptyGet;
				},

				now: function () {
					return (new Date()).getTime();
				}
			});

			JQXLite.ready.promise = function (obj) {
				if (!readyList) {

					readyList = JQXLite.Deferred();

					// Catch cases where $(document).ready() is called after the browser event has already occurred.
					// we once tried to use readyState "interactive" here, but it caused issues like the one
					// discovered by ChrisS here: http://bugs.jqx.com/ticket/12282#comment:15
					if (document.readyState === "complete") {
						// Handle it asynchronously to allow scripts the opportunity to delay ready
						setTimeout(JQXLite.ready, 1);

						// Standards-based browsers support DOMContentLoaded
					} else if (document.addEventListener) {
						// Use the handy event callback
						document.addEventListener("DOMContentLoaded", DOMContentLoaded, false);

						// A fallback to window.onload, that will always work
						window.addEventListener("load", JQXLite.ready, false);

						// If IE event model is used
					} else {
						// Ensure firing before onload, maybe late but safe also for iframes
						document.attachEvent("onreadystatechange", DOMContentLoaded);

						// A fallback to window.onload, that will always work
						window.attachEvent("onload", JQXLite.ready);

						// If IE and not a frame
						// continually check to see if the document is ready
						var top = false;

						try {
							top = window.frameElement == null && document.documentElement;
						} catch (e) { }

						if (top && top.doScroll) {
							(function doScrollCheck() {
								if (!JQXLite.isReady) {

									try {
										// Use the trick by Diego Perini
										// http://javascript.nwbox.com/IEContentLoaded/
										top.doScroll("left");
									} catch (e) {
										return setTimeout(doScrollCheck, 50);
									}

									// and execute any waiting functions
									JQXLite.ready();
								}
							})();
						}
					}
				}
				return readyList.promise(obj);
			};

			// Populate the class2type map
			JQXLite.each("Boolean Number String Function Array Date RegExp Object".split(" "), function (i, name) {
				class2type["[object " + name + "]"] = name.toLowerCase();
			});

			// All JQXLite objects should point back to these
			rootJQXLite = JQXLite(document);
			// String to Object options format cache
			var optionsCache = {};

			// Convert String-formatted options into Object-formatted ones and store in cache
			function createOptions(options) {
				var object = optionsCache[options] = {};
				JQXLite.each(options.split(core_rspace), function (_, flag) {
					object[flag] = true;
				});
				return object;
			}

			/*
			 * Create a callback list using the following parameters:
			 *
			 *	options: an optional list of space-separated options that will change how
			 *			the callback list behaves or a more traditional option object
			 *
			 * By default a callback list will act like an event callback list and can be
			 * "fired" multiple times.
			 *
			 * Possible options:
			 *
			 *	once:			will ensure the callback list can only be fired once (like a Deferred)
			 *
			 *	memory:			will keep track of previous values and will call any callback added
			 *					after the list has been fired right away with the latest "memorized"
			 *					values (like a Deferred)
			 *
			 *	unique:			will ensure a callback can only be added once (no duplicate in the list)
			 *
			 *	stopOnFalse:	interrupt callings when a callback returns false
			 *
			 */
			JQXLite.Callbacks = function (options) {

				// Convert options from String-formatted to Object-formatted if needed
				// (we check in cache first)
				options = typeof options === "string" ?
					(optionsCache[options] || createOptions(options)) :
					JQXLite.extend({}, options);

				var // Last fire value (for non-forgettable lists)
					memory,
					// Flag to know if list was already fired
					fired,
					// Flag to know if list is currently firing
					firing,
					// First callback to fire (used internally by add and fireWith)
					firingStart,
					// End of the loop when firing
					firingLength,
					// Index of currently firing callback (modified by remove if needed)
					firingIndex,
					// Actual callback list
					list = [],
					// Stack of fire calls for repeatable lists
					stack = !options.once && [],
					// Fire callbacks
					fire = function (data) {
						memory = options.memory && data;
						fired = true;
						firingIndex = firingStart || 0;
						firingStart = 0;
						firingLength = list.length;
						firing = true;
						for (; list && firingIndex < firingLength; firingIndex++) {
							if (list[firingIndex].apply(data[0], data[1]) === false && options.stopOnFalse) {
								memory = false; // To prevent further calls using add
								break;
							}
						}
						firing = false;
						if (list) {
							if (stack) {
								if (stack.length) {
									fire(stack.shift());
								}
							} else if (memory) {
								list = [];
							} else {
								self.disable();
							}
						}
					},
					// Actual Callbacks object
					self = {
						// Add a callback or a collection of callbacks to the list
						add: function () {
							if (list) {
								// First, we save the current length
								var start = list.length;
								(function add(args) {
									JQXLite.each(args, function (_, arg) {
										var type = JQXLite.type(arg);
										if (type === "function") {
											if (!options.unique || !self.has(arg)) {
												list.push(arg);
											}
										} else if (arg && arg.length && type !== "string") {
											// Inspect recursively
											add(arg);
										}
									});
								})(arguments);
								// Do we need to add the callbacks to the
								// current firing batch?
								if (firing) {
									firingLength = list.length;
									// With memory, if we're not firing then
									// we should call right away
								} else if (memory) {
									firingStart = start;
									fire(memory);
								}
							}
							return this;
						},
						// Remove a callback from the list
						remove: function () {
							if (list) {
								JQXLite.each(arguments, function (_, arg) {
									var index;
									while ((index = JQXLite.inArray(arg, list, index)) > -1) {
										list.splice(index, 1);
										// Handle firing indexes
										if (firing) {
											if (index <= firingLength) {
												firingLength--;
											}
											if (index <= firingIndex) {
												firingIndex--;
											}
										}
									}
								});
							}
							return this;
						},
						// Control if a given callback is in the list
						has: function (fn) {
							return JQXLite.inArray(fn, list) > -1;
						},
						// Remove all callbacks from the list
						empty: function () {
							list = [];
							return this;
						},
						// Have the list do nothing anymore
						disable: function () {
							list = stack = memory = undefined;
							return this;
						},
						// Is it disabled?
						disabled: function () {
							return !list;
						},
						// Lock the list in its current state
						lock: function () {
							stack = undefined;
							if (!memory) {
								self.disable();
							}
							return this;
						},
						// Is it locked?
						locked: function () {
							return !stack;
						},
						// Call all callbacks with the given context and arguments
						fireWith: function (context, args) {
							args = args || [];
							args = [context, args.slice ? args.slice() : args];
							if (list && (!fired || stack)) {
								if (firing) {
									stack.push(args);
								} else {
									fire(args);
								}
							}
							return this;
						},
						// Call all the callbacks with the given arguments
						fire: function () {
							self.fireWith(this, arguments);
							return this;
						},
						// To know if the callbacks have already been called at least once
						fired: function () {
							return !!fired;
						}
					};

				return self;
			};
			JQXLite.extend({

				Deferred: function (func) {
					var tuples = [
						// action, add listener, listener list, final state
						["resolve", "done", JQXLite.Callbacks("once memory"), "resolved"],
						["reject", "fail", JQXLite.Callbacks("once memory"), "rejected"],
						["notify", "progress", JQXLite.Callbacks("memory")]
					],
						state = "pending",
						promise = {
							state: function () {
								return state;
							},
							always: function () {
								deferred.done(arguments).fail(arguments);
								return this;
							},
							then: function ( /* fnDone, fnFail, fnProgress */) {
								var fns = arguments;
								return JQXLite.Deferred(function (newDefer) {
									JQXLite.each(tuples, function (i, tuple) {
										var action = tuple[0],
											fn = fns[i];
										// deferred[ done | fail | progress ] for forwarding actions to newDefer
										deferred[tuple[1]](JQXLite.isFunction(fn) ?
											function () {
												var returned = fn.apply(this, arguments);
												if (returned && JQXLite.isFunction(returned.promise)) {
													returned.promise()
														.done(newDefer.resolve)
														.fail(newDefer.reject)
														.progress(newDefer.notify);
												} else {
													newDefer[action + "With"](this === deferred ? newDefer : this, [returned]);
												}
											} :
											newDefer[action]
										);
									});
									fns = null;
								}).promise();
							},
							// Get a promise for this deferred
							// If obj is provided, the promise aspect is added to the object
							promise: function (obj) {
								return obj != null ? JQXLite.extend(obj, promise) : promise;
							}
						},
						deferred = {};

					// Keep pipe for back-compat
					promise.pipe = promise.then;

					// Add list-specific methods
					JQXLite.each(tuples, function (i, tuple) {
						var list = tuple[2],
							stateString = tuple[3];

						// promise[ done | fail | progress ] = list.add
						promise[tuple[1]] = list.add;

						// Handle state
						if (stateString) {
							list.add(function () {
								// state = [ resolved | rejected ]
								state = stateString;

								// [ reject_list | resolve_list ].disable; progress_list.lock
							}, tuples[i ^ 1][2].disable, tuples[2][2].lock);
						}

						// deferred[ resolve | reject | notify ] = list.fire
						deferred[tuple[0]] = list.fire;
						deferred[tuple[0] + "With"] = list.fireWith;
					});

					// Make the deferred a promise
					promise.promise(deferred);

					// Call given func if any
					if (func) {
						func.call(deferred, deferred);
					}

					// All done!
					return deferred;
				},

				// Deferred helper
				when: function (subordinate /* , ..., subordinateN */) {
					var i = 0,
						resolveValues = core_slice.call(arguments),
						length = resolveValues.length,

						// the count of uncompleted subordinates
						remaining = length !== 1 || (subordinate && JQXLite.isFunction(subordinate.promise)) ? length : 0,

						// the master Deferred. If resolveValues consist of only a single Deferred, just use that.
						deferred = remaining === 1 ? subordinate : JQXLite.Deferred(),

						// Update function for both resolve and progress values
						updateFunc = function (i, contexts, values) {
							return function (value) {
								contexts[i] = this;
								values[i] = arguments.length > 1 ? core_slice.call(arguments) : value;
								if (values === progressValues) {
									deferred.notifyWith(contexts, values);
								} else if (!(--remaining)) {
									deferred.resolveWith(contexts, values);
								}
							};
						},

						progressValues, progressContexts, resolveContexts;

					// add listeners to Deferred subordinates; treat others as resolved
					if (length > 1) {
						progressValues = new Array(length);
						progressContexts = new Array(length);
						resolveContexts = new Array(length);
						for (; i < length; i++) {
							if (resolveValues[i] && JQXLite.isFunction(resolveValues[i].promise)) {
								resolveValues[i].promise()
									.done(updateFunc(i, resolveContexts, resolveValues))
									.fail(deferred.reject)
									.progress(updateFunc(i, progressContexts, progressValues));
							} else {
								--remaining;
							}
						}
					}

					// if we're not waiting on anything, resolve the master
					if (!remaining) {
						deferred.resolveWith(resolveContexts, resolveValues);
					}

					return deferred.promise();
				}
			});
			JQXLite.support = (function () {

				var support,
					all,
					a,
					select,
					opt,
					input,
					fragment,
					eventName,
					i,
					isSupported,
					clickFn,
					div = document.createElement("div");

				// Setup
				div.setAttribute("className", "t");
				div.innerHTML = "  <link/><table></table><a href='/a'>a</a><input type='checkbox'/>";

				// Support tests won't run in some limited or non-browser environments
				all = div.getElementsByTagName("*");
				a = div.getElementsByTagName("a")[0];
				if (!all || !a || !all.length) {
					return {};
				}

				// First batch of tests
				select = document.createElement("select");
				opt = select.appendChild(document.createElement("option"));
				input = div.getElementsByTagName("input")[0];

				a.style.cssText = "top:1px;float:left;opacity:.5";
				support = {
					// IE strips leading whitespace when .innerHTML is used
					leadingWhitespace: (div.firstChild.nodeType === 3),

					// Make sure that tbody elements aren't automatically inserted
					// IE will insert them into empty tables
					tbody: !div.getElementsByTagName("tbody").length,

					// Make sure that link elements get serialized correctly by innerHTML
					// This requires a wrapper element in IE
					htmlSerialize: !!div.getElementsByTagName("link").length,

					// Get the style information from getAttribute
					// (IE uses .cssText instead)
					style: /top/.test(a.getAttribute("style")),

					// Make sure that URLs aren't manipulated
					// (IE normalizes it by default)
					hrefNormalized: (a.getAttribute("href") === "/a"),

					// Make sure that element opacity exists
					// (IE uses filter instead)
					// Use a regex to work around a WebKit issue. See #5145
					opacity: /^0.5/.test(a.style.opacity),

					// Verify style float existence
					// (IE uses styleFloat instead of cssFloat)
					cssFloat: !!a.style.cssFloat,

					// Make sure that if no value is specified for a checkbox
					// that it defaults to "on".
					// (WebKit defaults to "" instead)
					checkOn: (input.value === "on"),

					// Make sure that a selected-by-default option has a working selected property.
					// (WebKit defaults to false instead of true, IE too, if it's in an optgroup)
					optSelected: opt.selected,

					// Test setAttribute on camelCase class. If it works, we need attrFixes when doing get/setAttribute (ie6/7)
					getSetAttribute: div.className !== "t",

					// Tests for enctype support on a form (#6743)
					enctype: !!document.createElement("form").enctype,

					// Makes sure cloning an html5 element does not cause problems
					// Where outerHTML is undefined, this still works
					html5Clone: document.createElement("nav").cloneNode(true).outerHTML !== "<:nav></:nav>",

					// JQXLite.support.boxModel DEPRECATED in 1.8 since we don't support Quirks Mode
					boxModel: (document.compatMode === "CSS1Compat"),

					// Will be defined later
					submitBubbles: true,
					changeBubbles: true,
					focusinBubbles: false,
					deleteExpando: true,
					noCloneEvent: true,
					inlineBlockNeedsLayout: false,
					shrinkWrapBlocks: false,
					reliableMarginRight: true,
					boxSizingReliable: true,
					pixelPosition: false
				};

				// Make sure checked status is properly cloned
				input.checked = true;
				support.noCloneChecked = input.cloneNode(true).checked;

				// Make sure that the options inside disabled selects aren't marked as disabled
				// (WebKit marks them as disabled)
				select.disabled = true;
				support.optDisabled = !opt.disabled;

				// Test to see if it's possible to delete an expando from an element
				// Fails in Internet Explorer
				try {
					delete div.test;
				} catch (e) {
					support.deleteExpando = false;
				}

				if (!div.addEventListener && div.attachEvent && div.fireEvent) {
					div.attachEvent("onclick", clickFn = function () {
						// Cloning a node shouldn't copy over any
						// bound event handlers (IE does this)
						support.noCloneEvent = false;
					});
					div.cloneNode(true).fireEvent("onclick");
					div.detachEvent("onclick", clickFn);
				}

				// Check if a radio maintains its value
				// after being appended to the DOM
				input = document.createElement("input");
				input.value = "t";
				input.setAttribute("type", "radio");
				support.radioValue = input.value === "t";

				input.setAttribute("checked", "checked");

				// #11217 - WebKit loses check when the name is after the checked attribute
				input.setAttribute("name", "t");

				div.appendChild(input);
				fragment = document.createDocumentFragment();
				fragment.appendChild(div.lastChild);

				// WebKit doesn't clone checked state correctly in fragments
				support.checkClone = fragment.cloneNode(true).cloneNode(true).lastChild.checked;

				// Check if a disconnected checkbox will retain its checked
				// value of true after appended to the DOM (IE6/7)
				support.appendChecked = input.checked;

				fragment.removeChild(input);
				fragment.appendChild(div);

				// Technique from Juriy Zaytsev
				// http://perfectionkills.com/detecting-event-support-without-browser-sniffing/
				// We only care about the case where non-standard event systems
				// are used, namely in IE. Short-circuiting here helps us to
				// avoid an eval call (in setAttribute) which can cause CSP
				// to go haywire. See: https://developer.mozilla.org/en/Security/CSP
				if (div.attachEvent) {
					for (i in {
						submit: true,
						change: true,
						focusin: true
					}) {
						eventName = "on" + i;
						isSupported = (eventName in div);
						if (!isSupported) {
							div.setAttribute(eventName, "return;");
							isSupported = (typeof div[eventName] === "function");
						}
						support[i + "Bubbles"] = isSupported;
					}
				}

				// Run tests that need a body at doc ready
				JQXLite(function () {
					var container, div, tds, marginDiv,
						divReset = "padding:0;margin:0;border:0;display:block;overflow:hidden;",
						body = document.getElementsByTagName("body")[0];

					if (!body) {
						// Return for frameset docs that don't have a body
						return;
					}

					container = document.createElement("div");
					container.style.cssText = "visibility:hidden;border:0;width:0;height:0;position:static;top:0;margin-top:1px";
					body.insertBefore(container, body.firstChild);

					// Construct the test element
					div = document.createElement("div");
					container.appendChild(div);

					// Check if table cells still have offsetWidth/Height when they are set
					// to display:none and there are still other visible table cells in a
					// table row; if so, offsetWidth/Height are not reliable for use when
					// determining if an element has been hidden directly using
					// display:none (it is still safe to use offsets if a parent element is
					// hidden; don safety goggles and see bug #4512 for more information).
					// (only IE 8 fails this test)
					div.innerHTML = "<table><tr><td></td><td>t</td></tr></table>";
					tds = div.getElementsByTagName("td");
					tds[0].style.cssText = "padding:0;margin:0;border:0;display:none";
					isSupported = (tds[0].offsetHeight === 0);

					tds[0].style.display = "";
					tds[1].style.display = "none";

					// Check if empty table cells still have offsetWidth/Height
					// (IE <= 8 fail this test)
					support.reliableHiddenOffsets = isSupported && (tds[0].offsetHeight === 0);

					// Check box-sizing and margin behavior
					div.innerHTML = "";
					div.style.cssText = "box-sizing:border-box;-moz-box-sizing:border-box;-webkit-box-sizing:border-box;padding:1px;border:1px;display:block;width:4px;margin-top:1%;position:absolute;top:1%;";
					support.boxSizing = (div.offsetWidth === 4);
					support.doesNotIncludeMarginInBodyOffset = (body.offsetTop !== 1);

					// NOTE: To any future maintainer, we've window.getComputedStyle
					// because jsdom on node.js will break without it.
					if (window.getComputedStyle) {
						support.pixelPosition = (window.getComputedStyle(div, null) || {}).top !== "1%";
						support.boxSizingReliable = (window.getComputedStyle(div, null) || { width: "4px" }).width === "4px";

						// Check if div with explicit width and no margin-right incorrectly
						// gets computed margin-right based on width of container. For more
						// info see bug #3333
						// Fails in WebKit before Feb 2011 nightlies
						// WebKit Bug 13343 - getComputedStyle returns wrong value for margin-right
						marginDiv = document.createElement("div");
						marginDiv.style.cssText = div.style.cssText = divReset;
						marginDiv.style.marginRight = marginDiv.style.width = "0";
						div.style.width = "1px";
						div.appendChild(marginDiv);
						support.reliableMarginRight =
							!parseFloat((window.getComputedStyle(marginDiv, null) || {}).marginRight);
					}

					if (typeof div.style.zoom !== "undefined") {
						// Check if natively block-level elements act like inline-block
						// elements when setting their display to 'inline' and giving
						// them layout
						// (IE < 8 does this)
						div.innerHTML = "";
						div.style.cssText = divReset + "width:1px;padding:1px;display:inline;zoom:1";
						support.inlineBlockNeedsLayout = (div.offsetWidth === 3);

						// Check if elements with layout shrink-wrap their children
						// (IE 6 does this)
						div.style.display = "block";
						div.style.overflow = "visible";
						div.innerHTML = "<div></div>";
						div.firstChild.style.width = "5px";
						support.shrinkWrapBlocks = (div.offsetWidth !== 3);

						container.style.zoom = 1;
					}

					// Null elements to avoid leaks in IE
					body.removeChild(container);
					container = div = tds = marginDiv = null;
				});

				// Null elements to avoid leaks in IE
				fragment.removeChild(div);
				all = a = select = opt = input = fragment = div = null;

				return support;
			})();
			var rbrace = /(?:\{[\s\S]*\}|\[[\s\S]*\])$/,
				rmultiDash = /([A-Z])/g;

			JQXLite.extend({
				cache: {},

				deletedIds: [],

				// Remove at next major release (1.9/2.0)
				uuid: 0,

				// Unique for each copy of JQXLite on the page
				// Non-digits removed to match rinlinejQuery
				expando: "JQXLite" + (JQXLite.fn.jqx + Math.random()).replace(/\D/g, ""),

				// The following elements throw uncatchable exceptions if you
				// attempt to add expando properties to them.
				noData: {
					"embed": true,
					// Ban all objects except for Flash (which handle expandos)
					"object": "clsid:D27CDB6E-AE6D-11cf-96B8-444553540000",
					"applet": true
				},

				hasData: function (elem) {
					elem = elem.nodeType ? JQXLite.cache[elem[JQXLite.expando]] : elem[JQXLite.expando];
					return !!elem && !isEmptyDataObject(elem);
				},

				data: function (elem, name, data, pvt /* Internal Use Only */) {
					if (!JQXLite.acceptData(elem)) {
						return;
					}

					var thisCache, ret,
						internalKey = JQXLite.expando,
						getByName = typeof name === "string",

						// We have to handle DOM nodes and JS objects differently because IE6-7
						// can't GC object references properly across the DOM-JS boundary
						isNode = elem.nodeType,

						// Only DOM nodes need the global JQXLite cache; JS object data is
						// attached directly to the object so GC can occur automatically
						cache = isNode ? JQXLite.cache : elem,

						// Only defining an ID for JS objects if its cache already exists allows
						// the code to shortcut on the same path as a DOM node with no cache
						id = isNode ? elem[internalKey] : elem[internalKey] && internalKey;

					// Avoid doing any more work than we need to when trying to get data on an
					// object that has no data at all
					if ((!id || !cache[id] || (!pvt && !cache[id].data)) && getByName && data === undefined) {
						return;
					}

					if (!id) {
						// Only DOM nodes need a new unique ID for each element since their data
						// ends up in the global cache
						if (isNode) {
							elem[internalKey] = id = JQXLite.deletedIds.pop() || JQXLite.guid++;
						} else {
							id = internalKey;
						}
					}

					if (!cache[id]) {
						cache[id] = {};

						// Avoids exposing JQXLite metadata on plain JS objects when the object
						// is serialized using JSON.stringify
						if (!isNode) {
							cache[id].toJSON = JQXLite.noop;
						}
					}

					// An object can be passed to JQXLite.data instead of a key/value pair; this gets
					// shallow copied over onto the existing cache
					if (typeof name === "object" || typeof name === "function") {
						if (pvt) {
							cache[id] = JQXLite.extend(cache[id], name);
						} else {
							cache[id].data = JQXLite.extend(cache[id].data, name);
						}
					}

					thisCache = cache[id];

					// JQXLite data() is stored in a separate object inside the object's internal data
					// cache in order to avoid key collisions between internal data and user-defined
					// data.
					if (!pvt) {
						if (!thisCache.data) {
							thisCache.data = {};
						}

						thisCache = thisCache.data;
					}

					if (data !== undefined) {
						thisCache[JQXLite.camelCase(name)] = data;
					}

					// Check for both converted-to-camel and non-converted data property names
					// If a data property was specified
					if (getByName) {

						// First Try to find as-is property data
						ret = thisCache[name];

						// Test for null|undefined property data
						if (ret == null) {

							// Try to find the camelCased property
							ret = thisCache[JQXLite.camelCase(name)];
						}
					} else {
						ret = thisCache;
					}

					return ret;
				},

				removeData: function (elem, name, pvt /* Internal Use Only */) {
					if (!JQXLite.acceptData(elem)) {
						return;
					}

					var thisCache, i, l,

						isNode = elem.nodeType,

						// See JQXLite.data for more information
						cache = isNode ? JQXLite.cache : elem,
						id = isNode ? elem[JQXLite.expando] : JQXLite.expando;

					// If there is already no cache entry for this object, there is no
					// purpose in continuing
					if (!cache[id]) {
						return;
					}

					if (name) {

						thisCache = pvt ? cache[id] : cache[id].data;

						if (thisCache) {

							// Support array or space separated string names for data keys
							if (!JQXLite.isArray(name)) {

								// try the string as a key before any manipulation
								if (name in thisCache) {
									name = [name];
								} else {

									// split the camel cased version by spaces unless a key with the spaces exists
									name = JQXLite.camelCase(name);
									if (name in thisCache) {
										name = [name];
									} else {
										name = name.split(" ");
									}
								}
							}

							for (i = 0, l = name.length; i < l; i++) {
								delete thisCache[name[i]];
							}

							// If there is no data left in the cache, we want to continue
							// and let the cache object itself get destroyed
							if (!(pvt ? isEmptyDataObject : JQXLite.isEmptyObject)(thisCache)) {
								return;
							}
						}
					}

					// See JQXLite.data for more information
					if (!pvt) {
						delete cache[id].data;

						// Don't destroy the parent cache unless the internal data object
						// had been the only thing left in it
						if (!isEmptyDataObject(cache[id])) {
							return;
						}
					}

					// Destroy the cache
					if (isNode) {
						JQXLite.cleanData([elem], true);

						// Use delete when supported for expandos or `cache` is not a window per isWindow (#10080)
					} else if (JQXLite.support.deleteExpando || cache != cache.window) {
						delete cache[id];

						// When all else fails, null
					} else {
						cache[id] = null;
					}
				},

				// For internal use only.
				_data: function (elem, name, data) {
					return JQXLite.data(elem, name, data, true);
				},

				// A method for determining if a DOM node can handle the data expando
				acceptData: function (elem) {
					var noData = elem.nodeName && JQXLite.noData[elem.nodeName.toLowerCase()];

					// nodes accept data unless otherwise specified; rejection can be conditional
					return !noData || noData !== true && elem.getAttribute("classid") === noData;
				}
			});

			JQXLite.fn.extend({
				data: function (key, value) {
					var parts, part, attr, name, l,
						elem = this[0],
						i = 0,
						data = null;

					// Gets all values
					if (key === undefined) {
						if (this.length) {
							data = JQXLite.data(elem);

							if (elem.nodeType === 1 && !JQXLite._data(elem, "parsedAttrs")) {
								attr = elem.attributes;
								for (l = attr.length; i < l; i++) {
									name = attr[i].name;

									if (!name.indexOf("data-")) {
										name = JQXLite.camelCase(name.substring(5));

										dataAttr(elem, name, data[name]);
									}
								}
								JQXLite._data(elem, "parsedAttrs", true);
							}
						}

						return data;
					}

					// Sets multiple values
					if (typeof key === "object") {
						return this.each(function () {
							JQXLite.data(this, key);
						});
					}

					parts = key.split(".", 2);
					parts[1] = parts[1] ? "." + parts[1] : "";
					part = parts[1] + "!";

					return JQXLite.access(this, function (value) {

						if (value === undefined) {
							data = this.triggerHandler("getData" + part, [parts[0]]);

							// Try to fetch any internally stored data first
							if (data === undefined && elem) {
								data = JQXLite.data(elem, key);
								data = dataAttr(elem, key, data);
							}

							return data === undefined && parts[1] ?
								this.data(parts[0]) :
								data;
						}

						parts[1] = value;
						this.each(function () {
							var self = JQXLite(this);

							self.triggerHandler("setData" + part, parts);
							JQXLite.data(this, key, value);
							self.triggerHandler("changeData" + part, parts);
						});
					}, null, value, arguments.length > 1, null, false);
				},

				removeData: function (key) {
					return this.each(function () {
						JQXLite.removeData(this, key);
					});
				}
			});

			function dataAttr(elem, key, data) {
				// If nothing was found internally, try to fetch any
				// data from the HTML5 data-* attribute
				if (data === undefined && elem.nodeType === 1) {

					var name = "data-" + key.replace(rmultiDash, "-$1").toLowerCase();

					data = elem.getAttribute(name);

					if (typeof data === "string") {
						try {
							data = data === "true" ? true :
								data === "false" ? false :
									data === "null" ? null :
										// Only convert to a number if it doesn't change the string
										+data + "" === data ? +data :
											rbrace.test(data) ? JQXLite.parseJSON(data) :
												data;
						} catch (e) { }

						// Make sure we set the data so it isn't changed later
						JQXLite.data(elem, key, data);

					} else {
						data = undefined;
					}
				}

				return data;
			}

			// checks a cache object for emptiness
			function isEmptyDataObject(obj) {
				var name;
				for (name in obj) {

					// if the public data object is empty, the private is still empty
					if (name === "data" && JQXLite.isEmptyObject(obj[name])) {
						continue;
					}
					if (name !== "toJSON") {
						return false;
					}
				}

				return true;
			}
			JQXLite.extend({
				queue: function (elem, type, data) {
					var queue;

					if (elem) {
						type = (type || "fx") + "queue";
						queue = JQXLite._data(elem, type);

						// Speed up dequeue by getting out quickly if this is just a lookup
						if (data) {
							if (!queue || JQXLite.isArray(data)) {
								queue = JQXLite._data(elem, type, JQXLite.makeArray(data));
							} else {
								queue.push(data);
							}
						}
						return queue || [];
					}
				},

				dequeue: function (elem, type) {
					type = type || "fx";

					var queue = JQXLite.queue(elem, type),
						startLength = queue.length,
						fn = queue.shift(),
						hooks = JQXLite._queueHooks(elem, type),
						next = function () {
							JQXLite.dequeue(elem, type);
						};

					// If the fx queue is dequeued, always remove the progress sentinel
					if (fn === "inprogress") {
						fn = queue.shift();
						startLength--;
					}

					if (fn) {

						// Add a progress sentinel to prevent the fx queue from being
						// automatically dequeued
						if (type === "fx") {
							queue.unshift("inprogress");
						}

						// clear up the last queue stop function
						delete hooks.stop;
						fn.call(elem, next, hooks);
					}

					if (!startLength && hooks) {
						hooks.empty.fire();
					}
				},

				// not intended for public consumption - generates a queueHooks object, or returns the current one
				_queueHooks: function (elem, type) {
					var key = type + "queueHooks";
					return JQXLite._data(elem, key) || JQXLite._data(elem, key, {
						empty: JQXLite.Callbacks("once memory").add(function () {
							JQXLite.removeData(elem, type + "queue", true);
							JQXLite.removeData(elem, key, true);
						})
					});
				}
			});

			JQXLite.fn.extend({
				queue: function (type, data) {
					var setter = 2;

					if (typeof type !== "string") {
						data = type;
						type = "fx";
						setter--;
					}

					if (arguments.length < setter) {
						return JQXLite.queue(this[0], type);
					}

					return data === undefined ?
						this :
						this.each(function () {
							var queue = JQXLite.queue(this, type, data);

							// ensure a hooks for this queue
							JQXLite._queueHooks(this, type);

							if (type === "fx" && queue[0] !== "inprogress") {
								JQXLite.dequeue(this, type);
							}
						});
				},
				dequeue: function (type) {
					return this.each(function () {
						JQXLite.dequeue(this, type);
					});
				},
				// Based off of the plugin by Clint Helfers, with permission.
				// http://blindsignals.com/index.php/2009/07/jqx-delay/
				delay: function (time, type) {
					time = JQXLite.fx ? JQXLite.fx.speeds[time] || time : time;
					type = type || "fx";

					return this.queue(type, function (next, hooks) {
						var timeout = setTimeout(next, time);
						hooks.stop = function () {
							clearTimeout(timeout);
						};
					});
				},
				clearQueue: function (type) {
					return this.queue(type || "fx", []);
				},
				// Get a promise resolved when queues of a certain type
				// are emptied (fx is the type by default)
				promise: function (type, obj) {
					var tmp,
						count = 1,
						defer = JQXLite.Deferred(),
						elements = this,
						i = this.length,
						resolve = function () {
							if (!(--count)) {
								defer.resolveWith(elements, [elements]);
							}
						};

					if (typeof type !== "string") {
						obj = type;
						type = undefined;
					}
					type = type || "fx";

					while (i--) {
						tmp = JQXLite._data(elements[i], type + "queueHooks");
						if (tmp && tmp.empty) {
							count++;
							tmp.empty.add(resolve);
						}
					}
					resolve();
					return defer.promise(obj);
				}
			});
			var nodeHook, boolHook, fixSpecified,
				rclass = /[\t\r\n]/g,
				rreturn = /\r/g,
				rtype = /^(?:button|input)$/i,
				rfocusable = /^(?:button|input|object|select|textarea)$/i,
				rclickable = /^a(?:rea|)$/i,
				rboolean = /^(?:autofocus|autoplay|async|checked|controls|defer|disabled|hidden|loop|multiple|open|readonly|required|scoped|selected)$/i,
				getSetAttribute = JQXLite.support.getSetAttribute;

			JQXLite.fn.extend({
				attr: function (name, value) {
					return JQXLite.access(this, JQXLite.attr, name, value, arguments.length > 1);
				},

				removeAttr: function (name) {
					return this.each(function () {
						JQXLite.removeAttr(this, name);
					});
				},

				prop: function (name, value) {
					return JQXLite.access(this, JQXLite.prop, name, value, arguments.length > 1);
				},

				removeProp: function (name) {
					name = JQXLite.propFix[name] || name;
					return this.each(function () {
						// try/catch handles cases where IE balks (such as removing a property on window)
						try {
							this[name] = undefined;
							delete this[name];
						} catch (e) { }
					});
				},

				addClass: function (value) {
					var classNames, i, l, elem,
						setClass, c, cl;

					if (JQXLite.isFunction(value)) {
						return this.each(function (j) {
							JQXLite(this).addClass(value.call(this, j, this.className));
						});
					}

					if (value && typeof value === "string") {
						classNames = value.split(core_rspace);

						for (i = 0, l = this.length; i < l; i++) {
							elem = this[i];

							if (elem.nodeType === 1) {
								if (!elem.className && classNames.length === 1) {
									elem.className = value;

								} else {
									setClass = " " + elem.className + " ";

									for (c = 0, cl = classNames.length; c < cl; c++) {
										if (setClass.indexOf(" " + classNames[c] + " ") < 0) {
											setClass += classNames[c] + " ";
										}
									}
									elem.className = JQXLite.trim(setClass);
								}
							}
						}
					}

					return this;
				},

				removeClass: function (value) {
					var removes, className, elem, c, cl, i, l;

					if (JQXLite.isFunction(value)) {
						return this.each(function (j) {
							JQXLite(this).removeClass(value.call(this, j, this.className));
						});
					}
					if ((value && typeof value === "string") || value === undefined) {
						removes = (value || "").split(core_rspace);

						for (i = 0, l = this.length; i < l; i++) {
							elem = this[i];
							if (elem.nodeType === 1 && elem.className) {

								className = (" " + elem.className + " ").replace(rclass, " ");

								// loop over each item in the removal list
								for (c = 0, cl = removes.length; c < cl; c++) {
									// Remove until there is nothing to remove,
									while (className.indexOf(" " + removes[c] + " ") >= 0) {
										className = className.replace(" " + removes[c] + " ", " ");
									}
								}
								elem.className = value ? JQXLite.trim(className) : "";
							}
						}
					}

					return this;
				},

				toggleClass: function (value, stateVal) {
					var type = typeof value,
						isBool = typeof stateVal === "boolean";

					if (JQXLite.isFunction(value)) {
						return this.each(function (i) {
							JQXLite(this).toggleClass(value.call(this, i, this.className, stateVal), stateVal);
						});
					}

					return this.each(function () {
						if (type === "string") {
							// toggle individual class names
							var className,
								i = 0,
								self = JQXLite(this),
								state = stateVal,
								classNames = value.split(core_rspace);

							while ((className = classNames[i++])) {
								// check each className given, space separated list
								state = isBool ? state : !self.hasClass(className);
								self[state ? "addClass" : "removeClass"](className);
							}

						} else if (type === "undefined" || type === "boolean") {
							if (this.className) {
								// store className if set
								JQXLite._data(this, "__className__", this.className);
							}

							// toggle whole className
							this.className = this.className || value === false ? "" : JQXLite._data(this, "__className__") || "";
						}
					});
				},

				hasClass: function (selector) {
					var className = " " + selector + " ",
						i = 0,
						l = this.length;
					for (; i < l; i++) {
						if (this[i].nodeType === 1 && (" " + this[i].className + " ").replace(rclass, " ").indexOf(className) >= 0) {
							return true;
						}
					}

					return false;
				},

				val: function (value) {
					var hooks, ret, isFunction,
						elem = this[0];

					if (!arguments.length) {
						if (elem) {
							hooks = JQXLite.valHooks[elem.type] || JQXLite.valHooks[elem.nodeName.toLowerCase()];

							if (hooks && "get" in hooks && (ret = hooks.get(elem, "value")) !== undefined) {
								return ret;
							}

							ret = elem.value;

							return typeof ret === "string" ?
								// handle most common string cases
								ret.replace(rreturn, "") :
								// handle cases where value is null/undef or number
								ret == null ? "" : ret;
						}

						return;
					}

					isFunction = JQXLite.isFunction(value);

					return this.each(function (i) {
						var val,
							self = JQXLite(this);

						if (this.nodeType !== 1) {
							return;
						}

						if (isFunction) {
							val = value.call(this, i, self.val());
						} else {
							val = value;
						}

						// Treat null/undefined as ""; convert numbers to string
						if (val == null) {
							val = "";
						} else if (typeof val === "number") {
							val += "";
						} else if (JQXLite.isArray(val)) {
							val = JQXLite.map(val, function (value) {
								return value == null ? "" : value + "";
							});
						}

						hooks = JQXLite.valHooks[this.type] || JQXLite.valHooks[this.nodeName.toLowerCase()];

						// If set returns undefined, fall back to normal setting
						if (!hooks || !("set" in hooks) || hooks.set(this, val, "value") === undefined) {
							this.value = val;
						}
					});
				}
			});

			JQXLite.extend({
				valHooks: {
					option: {
						get: function (elem) {
							// attributes.value is undefined in Blackberry 4.7 but
							// uses .value. See #6932
							var val = elem.attributes.value;
							return !val || val.specified ? elem.value : elem.text;
						}
					},
					select: {
						get: function (elem) {
							var value, option,
								options = elem.options,
								index = elem.selectedIndex,
								one = elem.type === "select-one" || index < 0,
								values = one ? null : [],
								max = one ? index + 1 : options.length,
								i = index < 0 ?
									max :
									one ? index : 0;

							// Loop through all the selected options
							for (; i < max; i++) {
								option = options[i];

								// oldIE doesn't update selected after form reset (#2551)
								if ((option.selected || i === index) &&
									// Don't return options that are disabled or in a disabled optgroup
									(JQXLite.support.optDisabled ? !option.disabled : option.getAttribute("disabled") === null) &&
									(!option.parentNode.disabled || !JQXLite.nodeName(option.parentNode, "optgroup"))) {

									// Get the specific value for the option
									value = JQXLite(option).val();

									// We don't need an array for one selects
									if (one) {
										return value;
									}

									// Multi-Selects return an array
									values.push(value);
								}
							}

							return values;
						},

						set: function (elem, value) {
							var values = JQXLite.makeArray(value);

							JQXLite(elem).find("option").each(function () {
								this.selected = JQXLite.inArray(JQXLite(this).val(), values) >= 0;
							});

							if (!values.length) {
								elem.selectedIndex = -1;
							}
							return values;
						}
					}
				},

				// Unused in 1.8, left in so attrFn-stabbers won't die; remove in 1.9
				attrFn: {},

				attr: function (elem, name, value, pass) {
					var ret, hooks, notxml,
						nType = elem.nodeType;

					// don't get/set attributes on text, comment and attribute nodes
					if (!elem || nType === 3 || nType === 8 || nType === 2) {
						return;
					}

					if (pass && JQXLite.isFunction(JQXLite.fn[name])) {
						return JQXLite(elem)[name](value);
					}

					// Fallback to prop when attributes are not supported
					if (typeof elem.getAttribute === "undefined") {
						return JQXLite.prop(elem, name, value);
					}

					notxml = nType !== 1 || !JQXLite.isXMLDoc(elem);

					// All attributes are lowercase
					// Grab necessary hook if one is defined
					if (notxml) {
						name = name.toLowerCase();
						hooks = JQXLite.attrHooks[name] || (rboolean.test(name) ? boolHook : nodeHook);
					}

					if (value !== undefined) {

						if (value === null) {
							JQXLite.removeAttr(elem, name);
							return;

						} else if (hooks && "set" in hooks && notxml && (ret = hooks.set(elem, value, name)) !== undefined) {
							return ret;

						} else {
							elem.setAttribute(name, value + "");
							return value;
						}

					} else if (hooks && "get" in hooks && notxml && (ret = hooks.get(elem, name)) !== null) {
						return ret;

					} else {

						ret = elem.getAttribute(name);

						// Non-existent attributes return null, we normalize to undefined
						return ret === null ?
							undefined :
							ret;
					}
				},

				removeAttr: function (elem, value) {
					var propName, attrNames, name, isBool,
						i = 0;

					if (value && elem.nodeType === 1) {

						attrNames = value.split(core_rspace);

						for (; i < attrNames.length; i++) {
							name = attrNames[i];

							if (name) {
								propName = JQXLite.propFix[name] || name;
								isBool = rboolean.test(name);

								// See #9699 for explanation of this approach (setting first, then removal)
								// Do not do this for boolean attributes (see #10870)
								if (!isBool) {
									JQXLite.attr(elem, name, "");
								}
								elem.removeAttribute(getSetAttribute ? name : propName);

								// Set corresponding property to false for boolean attributes
								if (isBool && propName in elem) {
									elem[propName] = false;
								}
							}
						}
					}
				},

				attrHooks: {
					type: {
						set: function (elem, value) {
							// We can't allow the type property to be changed (since it causes problems in IE)
							if (rtype.test(elem.nodeName) && elem.parentNode) {
								JQXLite.error("type property can't be changed");
							} else if (!JQXLite.support.radioValue && value === "radio" && JQXLite.nodeName(elem, "input")) {
								// Setting the type on a radio button after the value resets the value in IE6-9
								// Reset value to it's default in case type is set after value
								// This is for element creation
								var val = elem.value;
								elem.setAttribute("type", value);
								if (val) {
									elem.value = val;
								}
								return value;
							}
						}
					},
					// Use the value property for back compat
					// Use the nodeHook for button elements in IE6/7 (#1954)
					value: {
						get: function (elem, name) {
							if (nodeHook && JQXLite.nodeName(elem, "button")) {
								return nodeHook.get(elem, name);
							}
							return name in elem ?
								elem.value :
								null;
						},
						set: function (elem, value, name) {
							if (nodeHook && JQXLite.nodeName(elem, "button")) {
								return nodeHook.set(elem, value, name);
							}
							// Does not return so that setAttribute is also used
							elem.value = value;
						}
					}
				},

				propFix: {
					tabindex: "tabIndex",
					readonly: "readOnly",
					"for": "htmlFor",
					"class": "className",
					maxlength: "maxLength",
					cellspacing: "cellSpacing",
					cellpadding: "cellPadding",
					rowspan: "rowSpan",
					colspan: "colSpan",
					usemap: "useMap",
					frameborder: "frameBorder",
					contenteditable: "contentEditable"
				},

				prop: function (elem, name, value) {
					var ret, hooks, notxml,
						nType = elem.nodeType;

					// don't get/set properties on text, comment and attribute nodes
					if (!elem || nType === 3 || nType === 8 || nType === 2) {
						return;
					}

					notxml = nType !== 1 || !JQXLite.isXMLDoc(elem);

					if (notxml) {
						// Fix name and attach hooks
						name = JQXLite.propFix[name] || name;
						hooks = JQXLite.propHooks[name];
					}

					if (value !== undefined) {
						if (hooks && "set" in hooks && (ret = hooks.set(elem, value, name)) !== undefined) {
							return ret;

						} else {
							return (elem[name] = value);
						}

					} else {
						if (hooks && "get" in hooks && (ret = hooks.get(elem, name)) !== null) {
							return ret;

						} else {
							return elem[name];
						}
					}
				},

				propHooks: {
					tabIndex: {
						get: function (elem) {
							// elem.tabIndex doesn't always return the correct value when it hasn't been explicitly set
							// http://fluidproject.org/blog/2008/01/09/getting-setting-and-removing-tabindex-values-with-javascript/
							var attributeNode = elem.getAttributeNode("tabindex");

							return attributeNode && attributeNode.specified ?
								parseInt(attributeNode.value, 10) :
								rfocusable.test(elem.nodeName) || rclickable.test(elem.nodeName) && elem.href ?
									0 :
									undefined;
						}
					}
				}
			});

			// Hook for boolean attributes
			boolHook = {
				get: function (elem, name) {
					// Align boolean attributes with corresponding properties
					// Fall back to attribute presence where some booleans are not supported
					var attrNode,
						property = JQXLite.prop(elem, name);
					return property === true || typeof property !== "boolean" && (attrNode = elem.getAttributeNode(name)) && attrNode.nodeValue !== false ?
						name.toLowerCase() :
						undefined;
				},
				set: function (elem, value, name) {
					var propName;
					if (value === false) {
						// Remove boolean attributes when set to false
						JQXLite.removeAttr(elem, name);
					} else {
						// value is true since we know at this point it's type boolean and not false
						// Set boolean attributes to the same name and set the DOM property
						propName = JQXLite.propFix[name] || name;
						if (propName in elem) {
							// Only set the IDL specifically if it already exists on the element
							elem[propName] = true;
						}

						elem.setAttribute(name, name.toLowerCase());
					}
					return name;
				}
			};

			// IE6/7 call enctype encoding
			if (!JQXLite.support.enctype) {
				JQXLite.propFix.enctype = "encoding";
			}

			var rformElems = /^(?:textarea|input|select)$/i,
				rtypenamespace = /^([^\.]*|)(?:\.(.+)|)$/,
				rhoverHack = /(?:^|\s)hover(\.\S+|)\b/,
				rkeyEvent = /^key/,
				rmouseEvent = /^(?:mouse|contextmenu)|click/,
				rfocusMorph = /^(?:focusinfocus|focusoutblur)$/,
				hoverHack = function (events) {
					return JQXLite.event.special.hover ? events : events.replace(rhoverHack, "mouseenter$1 mouseleave$1");
				};

			/*
			 * Helper functions for managing events -- not part of the public interface.
			 * Props to Dean Edwards' addEvent library for many of the ideas.
			 */
			JQXLite.event = {

				add: function (elem, types, handler, data, selector) {

					var elemData, eventHandle, events,
						t, tns, type, namespaces, handleObj,
						handleObjIn, handlers, special;

					// Don't attach events to noData or text/comment nodes (allow plain objects tho)
					if (elem.nodeType === 3 || elem.nodeType === 8 || !types || !handler || !(elemData = JQXLite._data(elem))) {
						return;
					}

					// Caller can pass in an object of custom data in lieu of the handler
					if (handler.handler) {
						handleObjIn = handler;
						handler = handleObjIn.handler;
						selector = handleObjIn.selector;
					}

					// Make sure that the handler has a unique ID, used to find/remove it later
					if (!handler.guid) {
						handler.guid = JQXLite.guid++;
					}

					// Init the element's event structure and main handler, if this is the first
					events = elemData.events;
					if (!events) {
						elemData.events = events = {};
					}
					eventHandle = elemData.handle;
					if (!eventHandle) {
						elemData.handle = eventHandle = function (e) {
							// Discard the second event of a JQXLite.event.trigger() and
							// when an event is called after a page has unloaded
							return typeof JQXLite !== "undefined" && (!e || JQXLite.event.triggered !== e.type) ?
								JQXLite.event.dispatch.apply(eventHandle.elem, arguments) :
								undefined;
						};
						// Add elem as a property of the handle fn to prevent a memory leak with IE non-native events
						eventHandle.elem = elem;
					}

					// Handle multiple events separated by a space
					// JQXLite(...).bind("mouseover mouseout", fn);
					types = JQXLite.trim(hoverHack(types)).split(" ");
					for (t = 0; t < types.length; t++) {

						tns = rtypenamespace.exec(types[t]) || [];
						type = tns[1];
						namespaces = (tns[2] || "").split(".").sort();

						// If event changes its type, use the special event handlers for the changed type
						special = JQXLite.event.special[type] || {};

						// If selector defined, determine special event api type, otherwise given type
						type = (selector ? special.delegateType : special.bindType) || type;

						// Update special based on newly reset type
						special = JQXLite.event.special[type] || {};

						// handleObj is passed to all event handlers
						handleObj = JQXLite.extend({
							type: type,
							origType: tns[1],
							data: data,
							handler: handler,
							guid: handler.guid,
							selector: selector,
							needsContext: selector && JQXLite.expr.match.needsContext.test(selector),
							namespace: namespaces.join(".")
						}, handleObjIn);

						// Init the event handler queue if we're the first
						handlers = events[type];
						if (!handlers) {
							handlers = events[type] = [];
							handlers.delegateCount = 0;

							// Only use addEventListener/attachEvent if the special events handler returns false
							if (!special.setup || special.setup.call(elem, data, namespaces, eventHandle) === false) {
								// Bind the global event handler to the element
								if (elem.addEventListener) {
									if (data && data.passive !== undefined) {
										elem.addEventListener(type, eventHandle, data);
									}
									else {
										elem.addEventListener(type, eventHandle, false);
									}
								} else if (elem.attachEvent) {
									elem.attachEvent("on" + type, eventHandle);
								}
							}
						}

						if (special.add) {
							special.add.call(elem, handleObj);

							if (!handleObj.handler.guid) {
								handleObj.handler.guid = handler.guid;
							}
						}

						// Add to the element's handler list, delegates in front
						if (selector) {
							handlers.splice(handlers.delegateCount++, 0, handleObj);
						} else {
							handlers.push(handleObj);
						}

						// Keep track of which events have ever been used, for event optimization
						JQXLite.event.global[type] = true;
					}

					// Nullify elem to prevent memory leaks in IE
					elem = null;
				},

				global: {},

				// Detach an event or set of events from an element
				remove: function (elem, types, handler, selector, mappedTypes) {

					var t, tns, type, origType, namespaces, origCount,
						j, events, special, eventType, handleObj,
						elemData = JQXLite.hasData(elem) && JQXLite._data(elem);

					if (!elemData || !(events = elemData.events)) {
						return;
					}

					// Once for each type.namespace in types; type may be omitted
					types = JQXLite.trim(hoverHack(types || "")).split(" ");
					for (t = 0; t < types.length; t++) {
						tns = rtypenamespace.exec(types[t]) || [];
						type = origType = tns[1];
						namespaces = tns[2];

						// Unbind all events (on this namespace, if provided) for the element
						if (!type) {
							for (type in events) {
								JQXLite.event.remove(elem, type + types[t], handler, selector, true);
							}
							continue;
						}

						special = JQXLite.event.special[type] || {};
						type = (selector ? special.delegateType : special.bindType) || type;
						eventType = events[type] || [];
						origCount = eventType.length;
						namespaces = namespaces ? new RegExp("(^|\\.)" + namespaces.split(".").sort().join("\\.(?:.*\\.|)") + "(\\.|$)") : null;

						// Remove matching events
						for (j = 0; j < eventType.length; j++) {
							handleObj = eventType[j];

							if ((mappedTypes || origType === handleObj.origType) &&
								(!handler || handler.guid === handleObj.guid) &&
								(!namespaces || namespaces.test(handleObj.namespace)) &&
								(!selector || selector === handleObj.selector || selector === "**" && handleObj.selector)) {
								eventType.splice(j--, 1);

								if (handleObj.selector) {
									eventType.delegateCount--;
								}
								if (special.remove) {
									special.remove.call(elem, handleObj);
								}
							}
						}

						// Remove generic event handler if we removed something and no more handlers exist
						// (avoids potential for endless recursion during removal of special event handlers)
						if (eventType.length === 0 && origCount !== eventType.length) {
							if (!special.teardown || special.teardown.call(elem, namespaces, elemData.handle) === false) {
								JQXLite.removeEvent(elem, type, elemData.handle);
							}

							delete events[type];
						}
					}

					// Remove the expando if it's no longer used
					if (JQXLite.isEmptyObject(events)) {
						delete elemData.handle;

						// removeData also checks for emptiness and clears the expando if empty
						// so use it instead of delete
						JQXLite.removeData(elem, "events", true);
					}
				},

				// Events that are safe to short-circuit if no handlers are attached.
				// Native DOM events should not be added, they may have inline handlers.
				customEvent: {
					"getData": true,
					"setData": true,
					"changeData": true
				},

				trigger: function (event, data, elem, onlyHandlers) {
					// Don't do events on text and comment nodes
					if (elem && (elem.nodeType === 3 || elem.nodeType === 8)) {
						return;
					}

					// Event object or event type
					var cache, exclusive, i, cur, old, ontype, special, handle, eventPath, bubbleType,
						type = event.type || event,
						namespaces = [];

					// focus/blur morphs to focusin/out; ensure we're not firing them right now
					if (rfocusMorph.test(type + JQXLite.event.triggered)) {
						return;
					}

					if (type.indexOf("!") >= 0) {
						// Exclusive events trigger only for the exact event (no namespaces)
						type = type.slice(0, -1);
						exclusive = true;
					}

					if (type.indexOf(".") >= 0) {
						// Namespaced trigger; create a regexp to match event type in handle()
						namespaces = type.split(".");
						type = namespaces.shift();
						namespaces.sort();
					}

					if ((!elem || JQXLite.event.customEvent[type]) && !JQXLite.event.global[type]) {
						// No JQXLite handlers for this event type, and it can't have inline handlers
						return;
					}

					// Caller can pass in an Event, Object, or just an event type string
					event = typeof event === "object" ?
						// JQXLite.Event object
						event[JQXLite.expando] ? event :
							// Object literal
							new JQXLite.Event(type, event) :
						// Just the event type (string)
						new JQXLite.Event(type);

					event.type = type;
					event.isTrigger = true;
					event.exclusive = exclusive;
					event.namespace = namespaces.join(".");
					event.namespace_re = event.namespace ? new RegExp("(^|\\.)" + namespaces.join("\\.(?:.*\\.|)") + "(\\.|$)") : null;
					ontype = type.indexOf(":") < 0 ? "on" + type : "";

					// Handle a global trigger
					if (!elem) {

						// TODO: Stop taunting the data cache; remove global events and always attach to document
						cache = JQXLite.cache;
						for (i in cache) {
							if (cache[i].events && cache[i].events[type]) {
								JQXLite.event.trigger(event, data, cache[i].handle.elem, true);
							}
						}
						return;
					}

					// Clean up the event in case it is being reused
					event.result = undefined;
					if (!event.target) {
						event.target = elem;
					}

					// Clone any incoming data and prepend the event, creating the handler arg list
					data = data != null ? JQXLite.makeArray(data) : [];
					data.unshift(event);

					// Allow special events to draw outside the lines
					special = JQXLite.event.special[type] || {};
					if (special.trigger && special.trigger.apply(elem, data) === false) {
						return;
					}

					// Determine event propagation path in advance, per W3C events spec (#9951)
					// Bubble up to document, then to window; watch for a global ownerDocument var (#9724)
					eventPath = [[elem, special.bindType || type]];
					if (!onlyHandlers && !special.noBubble && !JQXLite.isWindow(elem)) {

						bubbleType = special.delegateType || type;
						cur = rfocusMorph.test(bubbleType + type) ? elem : elem.parentNode;
						for (old = elem; cur; cur = cur.parentNode) {
							eventPath.push([cur, bubbleType]);
							old = cur;
						}

						// Only add window if we got to document (e.g., not plain obj or detached DOM)
						if (old === (elem.ownerDocument || document)) {
							eventPath.push([old.defaultView || old.parentWindow || window, bubbleType]);
						}
					}

					// Fire handlers on the event path
					for (i = 0; i < eventPath.length && !event.isPropagationStopped(); i++) {

						cur = eventPath[i][0];
						event.type = eventPath[i][1];

						handle = (JQXLite._data(cur, "events") || {})[event.type] && JQXLite._data(cur, "handle");
						if (handle) {
							handle.apply(cur, data);
						}
						// Note that this is a bare JS function and not a JQXLite handler
						handle = ontype && cur[ontype];
						if (handle && JQXLite.acceptData(cur) && handle.apply && handle.apply(cur, data) === false) {
							event.preventDefault();
						}
					}
					event.type = type;

					// If nobody prevented the default action, do it now
					if (!onlyHandlers && !event.isDefaultPrevented()) {

						if ((!special._default || special._default.apply(elem.ownerDocument, data) === false) &&
							!(type === "click" && JQXLite.nodeName(elem, "a")) && JQXLite.acceptData(elem)) {

							// Call a native DOM method on the target with the same name name as the event.
							// Can't use an .isFunction() check here because IE6/7 fails that test.
							// Don't do default actions on window, that's where global variables be (#6170)
							// IE<9 dies on focus/blur to hidden element (#1486)
							if (ontype && elem[type] && ((type !== "focus" && type !== "blur") || event.target.offsetWidth !== 0) && !JQXLite.isWindow(elem)) {

								// Don't re-trigger an onFOO event when we call its FOO() method
								old = elem[ontype];

								if (old) {
									elem[ontype] = null;
								}

								// Prevent re-triggering of the same event, since we already bubbled it above
								JQXLite.event.triggered = type;
								elem[type]();
								JQXLite.event.triggered = undefined;

								if (old) {
									elem[ontype] = old;
								}
							}
						}
					}

					return event.result;
				},

				dispatch: function (event) {

					// Make a writable JQXLite.Event from the native event object
					event = JQXLite.event.fix(event || window.event);

					var i, j, cur, ret, selMatch, matched, matches, handleObj, sel, related,
						handlers = ((JQXLite._data(this, "events") || {})[event.type] || []),
						delegateCount = handlers.delegateCount,
						args = core_slice.call(arguments),
						run_all = !event.exclusive && !event.namespace,
						special = JQXLite.event.special[event.type] || {},
						handlerQueue = [];

					// Use the fix-ed JQXLite.Event rather than the (read-only) native event
					args[0] = event;
					event.delegateTarget = this;

					// Call the preDispatch hook for the mapped type, and let it bail if desired
					if (special.preDispatch && special.preDispatch.call(this, event) === false) {
						return;
					}

					// Determine handlers that should run if there are delegated events
					// Avoid non-left-click bubbling in Firefox (#3861)
					if (delegateCount && !(event.button && event.type === "click")) {

						for (cur = event.target; cur != this; cur = cur.parentNode || this) {

							// Don't process clicks (ONLY) on disabled elements (#6911, #8165, #11382, #11764)
							if (cur.disabled !== true || event.type !== "click") {
								selMatch = {};
								matches = [];
								for (i = 0; i < delegateCount; i++) {
									handleObj = handlers[i];
									sel = handleObj.selector;

									if (selMatch[sel] === undefined) {
										selMatch[sel] = handleObj.needsContext ?
											JQXLite(sel, this).index(cur) >= 0 :
											JQXLite.find(sel, this, null, [cur]).length;
									}
									if (selMatch[sel]) {
										matches.push(handleObj);
									}
								}
								if (matches.length) {
									handlerQueue.push({ elem: cur, matches: matches });
								}
							}
						}
					}

					// Add the remaining (directly-bound) handlers
					if (handlers.length > delegateCount) {
						handlerQueue.push({ elem: this, matches: handlers.slice(delegateCount) });
					}

					// Run delegates first; they may want to stop propagation beneath us
					for (i = 0; i < handlerQueue.length && !event.isPropagationStopped(); i++) {
						matched = handlerQueue[i];
						event.currentTarget = matched.elem;

						for (j = 0; j < matched.matches.length && !event.isImmediatePropagationStopped(); j++) {
							handleObj = matched.matches[j];

							// Triggered event must either 1) be non-exclusive and have no namespace, or
							// 2) have namespace(s) a subset or equal to those in the bound event (both can have no namespace).
							if (run_all || (!event.namespace && !handleObj.namespace) || event.namespace_re && event.namespace_re.test(handleObj.namespace)) {

								event.data = handleObj.data;
								event.handleObj = handleObj;

								ret = ((JQXLite.event.special[handleObj.origType] || {}).handle || handleObj.handler)
									.apply(matched.elem, args);

								if (ret !== undefined) {
									event.result = ret;
									if (ret === false) {
										event.preventDefault();
										event.stopPropagation();
									}
								}
							}
						}
					}

					// Call the postDispatch hook for the mapped type
					if (special.postDispatch) {
						special.postDispatch.call(this, event);
					}

					return event.result;
				},

				// Includes some event props shared by KeyEvent and MouseEvent
				// *** attrChange attrName relatedNode srcElement  are not normalized, non-W3C, deprecated, will be removed in 1.8 ***
				props: "attrChange attrName relatedNode srcElement altKey bubbles cancelable ctrlKey currentTarget eventPhase metaKey relatedTarget shiftKey target timeStamp view which".split(" "),

				fixHooks: {},

				keyHooks: {
					props: "char charCode key keyCode".split(" "),
					filter: function (event, original) {

						// Add which for key events
						if (event.which == null) {
							event.which = original.charCode != null ? original.charCode : original.keyCode;
						}

						return event;
					}
				},

				mouseHooks: {
					props: "button buttons clientX clientY fromElement offsetX offsetY pageX pageY screenX screenY toElement".split(" "),
					filter: function (event, original) {
						var eventDoc, doc, body,
							button = original.button,
							fromElement = original.fromElement;

						// Calculate pageX/Y if missing and clientX/Y available
						if (event.pageX == null && original.clientX != null) {
							eventDoc = event.target.ownerDocument || document;
							doc = eventDoc.documentElement;
							body = eventDoc.body;

							event.pageX = original.clientX + (doc && doc.scrollLeft || body && body.scrollLeft || 0) - (doc && doc.clientLeft || body && body.clientLeft || 0);
							event.pageY = original.clientY + (doc && doc.scrollTop || body && body.scrollTop || 0) - (doc && doc.clientTop || body && body.clientTop || 0);
						}

						// Add relatedTarget, if necessary
						if (!event.relatedTarget && fromElement) {
							event.relatedTarget = fromElement === event.target ? original.toElement : fromElement;
						}

						// Add which for click: 1 === left; 2 === middle; 3 === right
						// Note: button is not normalized, so don't use it
						if (!event.which && button !== undefined) {
							event.which = (button & 1 ? 1 : (button & 2 ? 3 : (button & 4 ? 2 : 0)));
						}

						return event;
					}
				},

				fix: function (event) {
					if (event[JQXLite.expando]) {
						return event;
					}

					// Create a writable copy of the event object and normalize some properties
					var i, prop,
						originalEvent = event,
						fixHook = JQXLite.event.fixHooks[event.type] || {},
						copy = fixHook.props ? this.props.concat(fixHook.props) : this.props;

					event = JQXLite.Event(originalEvent);

					for (i = copy.length; i;) {
						prop = copy[--i];
						event[prop] = originalEvent[prop];
					}

					// Fix target property, if necessary (#1925, IE 6/7/8 & Safari2)
					if (!event.target) {
						event.target = originalEvent.srcElement || document;
					}

					// Target should not be a text node (#504, Safari)
					if (event.target.nodeType === 3) {
						event.target = event.target.parentNode;
					}

					// For mouse/key events, metaKey==false if it's undefined (#3368, #11328; IE6/7/8)
					event.metaKey = !!event.metaKey;

					return fixHook.filter ? fixHook.filter(event, originalEvent) : event;
				},

				special: {
					load: {
						// Prevent triggered image.load events from bubbling to window.load
						noBubble: true
					},

					focus: {
						delegateType: "focusin"
					},
					blur: {
						delegateType: "focusout"
					},

					beforeunload: {
						setup: function (data, namespaces, eventHandle) {
							// We only want to do this special case on windows
							if (JQXLite.isWindow(this)) {
								this.onbeforeunload = eventHandle;
							}
						},

						teardown: function (namespaces, eventHandle) {
							if (this.onbeforeunload === eventHandle) {
								this.onbeforeunload = null;
							}
						}
					}
				},

				simulate: function (type, elem, event, bubble) {
					// Piggyback on a donor event to simulate a different one.
					// Fake originalEvent to avoid donor's stopPropagation, but if the
					// simulated event prevents default then we do the same on the donor.
					var e = JQXLite.extend(
						new JQXLite.Event(),
						event,
						{
							type: type,
							isSimulated: true,
							originalEvent: {}
						}
					);
					if (bubble) {
						JQXLite.event.trigger(e, null, elem);
					} else {
						JQXLite.event.dispatch.call(elem, e);
					}
					if (e.isDefaultPrevented()) {
						event.preventDefault();
					}
				}
			};

			// Some plugins are using, but it's undocumented/deprecated and will be removed.
			// The 1.7 special event interface should provide all the hooks needed now.
			JQXLite.event.handle = JQXLite.event.dispatch;

			JQXLite.removeEvent = document.removeEventListener ?
				function (elem, type, handle) {
					if (elem.removeEventListener) {
						elem.removeEventListener(type, handle, false);
					}
				} :
				function (elem, type, handle) {
					var name = "on" + type;

					if (elem.detachEvent) {

						// #8545, #7054, preventing memory leaks for custom events in IE6-8
						// detachEvent needed property on element, by name of that event, to properly expose it to GC
						if (typeof elem[name] === "undefined") {
							elem[name] = null;
						}

						elem.detachEvent(name, handle);
					}
				};

			JQXLite.Event = function (src, props) {
				// Allow instantiation without the 'new' keyword
				if (!(this instanceof JQXLite.Event)) {
					return new JQXLite.Event(src, props);
				}

				// Event object
				if (src && src.type) {
					this.originalEvent = src;
					this.type = src.type;

					// Events bubbling up the document may have been marked as prevented
					// by a handler lower down the tree; reflect the correct value.
					this.isDefaultPrevented = (src.defaultPrevented || src.returnValue === false ||
						src.getPreventDefault && src.getPreventDefault()) ? returnTrue : returnFalse;

					// Event type
				} else {
					this.type = src;
				}

				// Put explicitly provided properties onto the event object
				if (props) {
					JQXLite.extend(this, props);
				}

				// Create a timestamp if incoming event doesn't have one
				this.timeStamp = src && src.timeStamp || JQXLite.now();

				// Mark it as fixed
				this[JQXLite.expando] = true;
			};

			function returnFalse() {
				return false;
			}
			function returnTrue() {
				return true;
			}

			// JQXLite.Event is based on DOM3 Events as specified by the ECMAScript Language Binding
			// http://www.w3.org/TR/2003/WD-DOM-Level-3-Events-20030331/ecma-script-binding.html
			JQXLite.Event.prototype = {
				preventDefault: function () {
					this.isDefaultPrevented = returnTrue;

					var e = this.originalEvent;
					if (!e) {
						return;
					}

					// if preventDefault exists run it on the original event
					if (e.preventDefault) {
						e.preventDefault();

						// otherwise set the returnValue property of the original event to false (IE)
					} else {
						e.returnValue = false;
					}
				},
				stopPropagation: function () {
					this.isPropagationStopped = returnTrue;

					var e = this.originalEvent;
					if (!e) {
						return;
					}
					// if stopPropagation exists run it on the original event
					if (e.stopPropagation) {
						e.stopPropagation();
					}
					// otherwise set the cancelBubble property of the original event to true (IE)
					e.cancelBubble = true;
				},
				stopImmediatePropagation: function () {
					this.isImmediatePropagationStopped = returnTrue;
					this.stopPropagation();
				},
				isDefaultPrevented: returnFalse,
				isPropagationStopped: returnFalse,
				isImmediatePropagationStopped: returnFalse
			};

			// Create mouseenter/leave events using mouseover/out and event-time checks
			JQXLite.each({
				mouseenter: "mouseover",
				mouseleave: "mouseout"
			}, function (orig, fix) {
				JQXLite.event.special[orig] = {
					delegateType: fix,
					bindType: fix,

					handle: function (event) {
						var ret,
							target = this,
							related = event.relatedTarget,
							handleObj = event.handleObj,
							selector = handleObj.selector;

						// For mousenter/leave call the handler if related is outside the target.
						// NB: No relatedTarget if the mouse left/entered the browser window
						if (!related || (related !== target && !JQXLite.contains(target, related))) {
							event.type = handleObj.origType;
							ret = handleObj.handler.apply(this, arguments);
							event.type = fix;
						}
						return ret;
					}
				};
			});

			JQXLite.fn.extend({

				on: function (types, selector, data, fn, /*INTERNAL*/ one) {
					var origFn, type;

					// Types can be a map of types/handlers
					if (typeof types === "object") {
						// ( types-Object, selector, data )
						if (typeof selector !== "string") { // && selector != null
							// ( types-Object, data )
							data = data || selector;
							selector = undefined;
						}
						for (type in types) {
							this.on(type, selector, data, types[type], one);
						}
						return this;
					}

					if (data == null && fn == null) {
						// ( types, fn )
						fn = selector;
						data = selector = undefined;
					} else if (fn == null) {
						if (typeof selector === "string") {
							// ( types, selector, fn )
							fn = data;
							data = undefined;
						} else {
							// ( types, data, fn )
							fn = data;
							data = selector;
							selector = undefined;
						}
					}
					if (fn === false) {
						fn = returnFalse;
					} else if (!fn) {
						return this;
					}

					if (one === 1) {
						origFn = fn;
						fn = function (event) {
							// Can use an empty set, since event contains the info
							JQXLite().off(event);
							return origFn.apply(this, arguments);
						};
						// Use same guid so caller can remove using origFn
						fn.guid = origFn.guid || (origFn.guid = JQXLite.guid++);
					}
					return this.each(function () {
						JQXLite.event.add(this, types, fn, data, selector);
					});
				},

				off: function (types, selector, fn) {
					var handleObj, type;
					if (types && types.preventDefault && types.handleObj) {
						// ( event )  dispatched JQXLite.Event
						handleObj = types.handleObj;
						JQXLite(types.delegateTarget).off(
							handleObj.namespace ? handleObj.origType + "." + handleObj.namespace : handleObj.origType,
							handleObj.selector,
							handleObj.handler
						);
						return this;
					}
					if (typeof types === "object") {
						// ( types-object [, selector] )
						for (type in types) {
							this.off(type, selector, types[type]);
						}
						return this;
					}
					if (selector === false || typeof selector === "function") {
						// ( types [, fn] )
						fn = selector;
						selector = undefined;
					}
					if (fn === false) {
						fn = returnFalse;
					}
					return this.each(function () {
						JQXLite.event.remove(this, types, fn, selector);
					});
				},

				delegate: function (selector, types, data, fn) {
					return this.on(types, selector, data, fn);
				},
				undelegate: function (selector, types, fn) {
					// ( namespace ) or ( selector, types [, fn] )
					return arguments.length === 1 ? this.off(selector, "**") : this.off(types, selector || "**", fn);
				},

				trigger: function (type, data) {
					return this.each(function () {
						JQXLite.event.trigger(type, data, this);
					});
				},
				triggerHandler: function (type, data) {
					if (this[0]) {
						return JQXLite.event.trigger(type, data, this[0], true);
					}
				},

				toggle: function (fn) {
					// Save reference to arguments for access in closure
					var args = arguments,
						guid = fn.guid || JQXLite.guid++,
						i = 0,
						toggler = function (event) {
							// Figure out which function to execute
							var lastToggle = (JQXLite._data(this, "lastToggle" + fn.guid) || 0) % i;
							JQXLite._data(this, "lastToggle" + fn.guid, lastToggle + 1);

							// Make sure that clicks stop
							event.preventDefault();

							// and execute the function
							return args[lastToggle].apply(this, arguments) || false;
						};

					// link all the functions, so any of them can unbind this click handler
					toggler.guid = guid;
					while (i < args.length) {
						args[i++].guid = guid;
					}

					return this.click(toggler);
				},

				hover: function (fnOver, fnOut) {
					return this.mouseenter(fnOver).mouseleave(fnOut || fnOver);
				}
			});

			JQXLite.each(("blur focus focusin focusout load resize scroll unload click dblclick " +
				"mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave " +
				"change select submit keydown keypress keyup error contextmenu").split(" "), function (i, name) {

					// Handle event binding
					JQXLite.fn[name] = function (data, fn) {
						if (fn == null) {
							fn = data;
							data = null;
						}

						return arguments.length > 0 ?
							this.on(name, null, data, fn) :
							this.trigger(name);
					};

					if (rkeyEvent.test(name)) {
						JQXLite.event.fixHooks[name] = JQXLite.event.keyHooks;
					}

					if (rmouseEvent.test(name)) {
						JQXLite.event.fixHooks[name] = JQXLite.event.mouseHooks;
					}
				});
			/*!
			 * Sizzle CSS Selector Engine
			 * Copyright 2012 JQXLite Foundation and other contributors
			 * Released under the MIT license
			 * http://sizzlejs.com/
			 */
			(function (window, undefined) {

				var cachedruns,
					assertGetIdNotName,
					Expr,
					getText,
					isXML,
					contains,
					compile,
					sortOrder,
					hasDuplicate,
					outermostContext,

					baseHasDuplicate = true,
					strundefined = "undefined",

					expando = ("sizcache" + Math.random()).replace(".", ""),

					Token = String,
					document = window.document,
					docElem = document.documentElement,
					dirruns = 0,
					done = 0,
					pop = [].pop,
					push = [].push,
					slice = [].slice,
					// Use a stripped-down indexOf if a native one is unavailable
					indexOf = [].indexOf || function (elem) {
						var i = 0,
							len = this.length;
						for (; i < len; i++) {
							if (this[i] === elem) {
								return i;
							}
						}
						return -1;
					},

					// Augment a function for special use by Sizzle
					markFunction = function (fn, value) {
						fn[expando] = value == null || value;
						return fn;
					},

					createCache = function () {
						var cache = {},
							keys = [];

						return markFunction(function (key, value) {
							// Only keep the most recent entries
							if (keys.push(key) > Expr.cacheLength) {
								delete cache[keys.shift()];
							}

							// Retrieve with (key + " ") to avoid collision with native Object.prototype properties (see Issue #157)
							return (cache[key + " "] = value);
						}, cache);
					},

					classCache = createCache(),
					tokenCache = createCache(),
					compilerCache = createCache(),

					// Regex

					// Whitespace characters http://www.w3.org/TR/css3-selectors/#whitespace
					whitespace = "[\\x20\\t\\r\\n\\f]",
					// http://www.w3.org/TR/css3-syntax/#characters
					characterEncoding = "(?:\\\\.|[-\\w]|[^\\x00-\\xa0])+",

					// Loosely modeled on CSS identifier characters
					// An unquoted value should be a CSS identifier (http://www.w3.org/TR/css3-selectors/#attribute-selectors)
					// Proper syntax: http://www.w3.org/TR/CSS21/syndata.html#value-def-identifier
					identifier = characterEncoding.replace("w", "w#"),

					// Acceptable operators http://www.w3.org/TR/selectors/#attribute-selectors
					operators = "([*^$|!~]?=)",
					attributes = "\\[" + whitespace + "*(" + characterEncoding + ")" + whitespace +
						"*(?:" + operators + whitespace + "*(?:(['\"])((?:\\\\.|[^\\\\])*?)\\3|(" + identifier + ")|)|)" + whitespace + "*\\]",

					// Prefer arguments not in parens/brackets,
					//   then attribute selectors and non-pseudos (denoted by :),
					//   then anything else
					// These preferences are here to reduce the number of selectors
					//   needing tokenize in the PSEUDO preFilter
					pseudos = ":(" + characterEncoding + ")(?:\\((?:(['\"])((?:\\\\.|[^\\\\])*?)\\2|([^()[\\]]*|(?:(?:" + attributes + ")|[^:]|\\\\.)*|.*))\\)|)",

					// For matchExpr.POS and matchExpr.needsContext
					pos = ":(even|odd|eq|gt|lt|nth|first|last)(?:\\(" + whitespace +
						"*((?:-\\d)?\\d*)" + whitespace + "*\\)|)(?=[^-]|$)",

					// Leading and non-escaped trailing whitespace, capturing some non-whitespace characters preceding the latter
					rtrim = new RegExp("^" + whitespace + "+|((?:^|[^\\\\])(?:\\\\.)*)" + whitespace + "+$", "g"),

					rcomma = new RegExp("^" + whitespace + "*," + whitespace + "*"),
					rcombinators = new RegExp("^" + whitespace + "*([\\x20\\t\\r\\n\\f>+~])" + whitespace + "*"),
					rpseudo = new RegExp(pseudos),

					// Easily-parseable/retrievable ID or TAG or CLASS selectors
					rquickExpr = /^(?:#([\w\-]+)|(\w+)|\.([\w\-]+))$/,

					rnot = /^:not/,
					rsibling = /[\x20\t\r\n\f]*[+~]/,
					rendsWithNot = /:not\($/,

					rheader = /h\d/i,
					rinputs = /input|select|textarea|button/i,

					rbackslash = /\\(?!\\)/g,

					matchExpr = {
						"ID": new RegExp("^#(" + characterEncoding + ")"),
						"CLASS": new RegExp("^\\.(" + characterEncoding + ")"),
						"NAME": new RegExp("^\\[name=['\"]?(" + characterEncoding + ")['\"]?\\]"),
						"TAG": new RegExp("^(" + characterEncoding.replace("w", "w*") + ")"),
						"ATTR": new RegExp("^" + attributes),
						"PSEUDO": new RegExp("^" + pseudos),
						"POS": new RegExp(pos, "i"),
						"CHILD": new RegExp("^:(only|nth|first|last)-child(?:\\(" + whitespace +
							"*(even|odd|(([+-]|)(\\d*)n|)" + whitespace + "*(?:([+-]|)" + whitespace +
							"*(\\d+)|))" + whitespace + "*\\)|)", "i"),
						// For use in libraries implementing .is()
						"needsContext": new RegExp("^" + whitespace + "*[>+~]|" + pos, "i")
					},

					// Support

					// Used for testing something on an element
					assert = function (fn) {
						var div = document.createElement("div");

						try {
							return fn(div);
						} catch (e) {
							return false;
						} finally {
							// release memory in IE
							div = null;
						}
					},

					// Check if getElementsByTagName("*") returns only elements
					assertTagNameNoComments = assert(function (div) {
						div.appendChild(document.createComment(""));
						return !div.getElementsByTagName("*").length;
					}),

					// Check if getAttribute returns normalized href attributes
					assertHrefNotNormalized = assert(function (div) {
						div.innerHTML = "<a href='#'></a>";
						return div.firstChild && typeof div.firstChild.getAttribute !== strundefined &&
							div.firstChild.getAttribute("href") === "#";
					}),

					// Check if attributes should be retrieved by attribute nodes
					assertAttributes = assert(function (div) {
						div.innerHTML = "<select></select>";
						var type = typeof div.lastChild.getAttribute("multiple");
						// IE8 returns a string for some attributes even when not present
						return type !== "boolean" && type !== "string";
					}),

					// Check if getElementsByClassName can be trusted
					assertUsableClassName = assert(function (div) {
						// Opera can't find a second classname (in 9.6)
						div.innerHTML = "<div class='hidden e'></div><div class='hidden'></div>";
						if (!div.getElementsByClassName || !div.getElementsByClassName("e").length) {
							return false;
						}

						// Safari 3.2 caches class attributes and doesn't catch changes
						div.lastChild.className = "e";
						return div.getElementsByClassName("e").length === 2;
					}),

					// Check if getElementById returns elements by name
					// Check if getElementsByName privileges form controls or returns elements by ID
					assertUsableName = assert(function (div) {
						// Inject content
						div.id = expando + 0;
						div.innerHTML = "<a name='" + expando + "'></a><div name='" + expando + "'></div>";
						docElem.insertBefore(div, docElem.firstChild);

						// Test
						var pass = document.getElementsByName &&
							// buggy browsers will return fewer than the correct 2
							document.getElementsByName(expando).length === 2 +
							// buggy browsers will return more than the correct 0
							document.getElementsByName(expando + 0).length;
						assertGetIdNotName = !document.getElementById(expando);

						// Cleanup
						docElem.removeChild(div);

						return pass;
					});

				// If slice is not available, provide a backup
				try {
					slice.call(docElem.childNodes, 0)[0].nodeType;
				} catch (e) {
					slice = function (i) {
						var elem,
							results = [];
						for (; (elem = this[i]); i++) {
							results.push(elem);
						}
						return results;
					};
				}

				function Sizzle(selector, context, results, seed) {
					results = results || [];
					context = context || document;
					var match, elem, xml, m,
						nodeType = context.nodeType;

					if (!selector || typeof selector !== "string") {
						return results;
					}

					if (nodeType !== 1 && nodeType !== 9) {
						return [];
					}

					xml = isXML(context);

					if (!xml && !seed) {
						if ((match = rquickExpr.exec(selector))) {
							// Speed-up: Sizzle("#ID")
							if ((m = match[1])) {
								if (nodeType === 9) {
									elem = context.getElementById(m);
									// Check parentNode to catch when Blackberry 4.6 returns
									// nodes that are no longer in the document #6963
									if (elem && elem.parentNode) {
										// Handle the case where IE, Opera, and Webkit return items
										// by name instead of ID
										if (elem.id === m) {
											results.push(elem);
											return results;
										}
									} else {
										return results;
									}
								} else {
									// Context is not a document
									if (context.ownerDocument && (elem = context.ownerDocument.getElementById(m)) &&
										contains(context, elem) && elem.id === m) {
										results.push(elem);
										return results;
									}
								}

								// Speed-up: Sizzle("TAG")
							} else if (match[2]) {
								push.apply(results, slice.call(context.getElementsByTagName(selector), 0));
								return results;

								// Speed-up: Sizzle(".CLASS")
							} else if ((m = match[3]) && assertUsableClassName && context.getElementsByClassName) {
								push.apply(results, slice.call(context.getElementsByClassName(m), 0));
								return results;
							}
						}
					}

					// All others
					return select(selector.replace(rtrim, "$1"), context, results, seed, xml);
				}

				Sizzle.matches = function (expr, elements) {
					return Sizzle(expr, null, null, elements);
				};

				Sizzle.matchesSelector = function (elem, expr) {
					return Sizzle(expr, null, null, [elem]).length > 0;
				};

				// Returns a function to use in pseudos for input types
				function createInputPseudo(type) {
					return function (elem) {
						var name = elem.nodeName.toLowerCase();
						return name === "input" && elem.type === type;
					};
				}

				// Returns a function to use in pseudos for buttons
				function createButtonPseudo(type) {
					return function (elem) {
						var name = elem.nodeName.toLowerCase();
						return (name === "input" || name === "button") && elem.type === type;
					};
				}

				// Returns a function to use in pseudos for positionals
				function createPositionalPseudo(fn) {
					return markFunction(function (argument) {
						argument = +argument;
						return markFunction(function (seed, matches) {
							var j,
								matchIndexes = fn([], seed.length, argument),
								i = matchIndexes.length;

							// Match elements found at the specified indexes
							while (i--) {
								if (seed[(j = matchIndexes[i])]) {
									seed[j] = !(matches[j] = seed[j]);
								}
							}
						});
					});
				}

				/**
				 * Utility function for retrieving the text value of an array of DOM nodes
				 * @param {Array|Element} elem
				 */
				getText = Sizzle.getText = function (elem) {
					var node,
						ret = "",
						i = 0,
						nodeType = elem.nodeType;

					if (nodeType) {
						if (nodeType === 1 || nodeType === 9 || nodeType === 11) {
							// Use textContent for elements
							// innerText usage removed for consistency of new lines (see #11153)
							if (typeof elem.textContent === "string") {
								return elem.textContent;
							} else {
								// Traverse its children
								for (elem = elem.firstChild; elem; elem = elem.nextSibling) {
									ret += getText(elem);
								}
							}
						} else if (nodeType === 3 || nodeType === 4) {
							return elem.nodeValue;
						}
						// Do not include comment or processing instruction nodes
					} else {

						// If no nodeType, this is expected to be an array
						for (; (node = elem[i]); i++) {
							// Do not traverse comment nodes
							ret += getText(node);
						}
					}
					return ret;
				};

				isXML = Sizzle.isXML = function (elem) {
					// documentElement is verified for cases where it doesn't yet exist
					// (such as loading iframes in IE - #4833)
					var documentElement = elem && (elem.ownerDocument || elem).documentElement;
					return documentElement ? documentElement.nodeName !== "HTML" : false;
				};

				// Element contains another
				contains = Sizzle.contains = docElem.contains ?
					function (a, b) {
						var adown = a.nodeType === 9 ? a.documentElement : a,
							bup = b && b.parentNode;
						return a === bup || !!(bup && bup.nodeType === 1 && adown.contains && adown.contains(bup));
					} :
					docElem.compareDocumentPosition ?
						function (a, b) {
							return b && !!(a.compareDocumentPosition(b) & 16);
						} :
						function (a, b) {
							while ((b = b.parentNode)) {
								if (b === a) {
									return true;
								}
							}
							return false;
						};

				Sizzle.attr = function (elem, name) {
					var val,
						xml = isXML(elem);

					if (!xml) {
						name = name.toLowerCase();
					}
					if ((val = Expr.attrHandle[name])) {
						return val(elem);
					}
					if (xml || assertAttributes) {
						return elem.getAttribute(name);
					}
					val = elem.getAttributeNode(name);
					return val ?
						typeof elem[name] === "boolean" ?
							elem[name] ? name : null :
							val.specified ? val.value : null :
						null;
				};

				Expr = Sizzle.selectors = {

					// Can be adjusted by the user
					cacheLength: 50,

					createPseudo: markFunction,

					match: matchExpr,

					// IE6/7 return a modified href
					attrHandle: assertHrefNotNormalized ?
						{} :
						{
							"href": function (elem) {
								return elem.getAttribute("href", 2);
							},
							"type": function (elem) {
								return elem.getAttribute("type");
							}
						},

					find: {
						"ID": assertGetIdNotName ?
							function (id, context, xml) {
								if (typeof context.getElementById !== strundefined && !xml) {
									var m = context.getElementById(id);
									// Check parentNode to catch when Blackberry 4.6 returns
									// nodes that are no longer in the document #6963
									return m && m.parentNode ? [m] : [];
								}
							} :
							function (id, context, xml) {
								if (typeof context.getElementById !== strundefined && !xml) {
									var m = context.getElementById(id);

									return m ?
										m.id === id || typeof m.getAttributeNode !== strundefined && m.getAttributeNode("id").value === id ?
											[m] :
											undefined :
										[];
								}
							},

						"TAG": assertTagNameNoComments ?
							function (tag, context) {
								if (typeof context.getElementsByTagName !== strundefined) {
									return context.getElementsByTagName(tag);
								}
							} :
							function (tag, context) {
								var results = context.getElementsByTagName(tag);

								// Filter out possible comments
								if (tag === "*") {
									var elem,
										tmp = [],
										i = 0;

									for (; (elem = results[i]); i++) {
										if (elem.nodeType === 1) {
											tmp.push(elem);
										}
									}

									return tmp;
								}
								return results;
							},

						"NAME": assertUsableName && function (tag, context) {
							if (typeof context.getElementsByName !== strundefined) {
								return context.getElementsByName(name);
							}
						},

						"CLASS": assertUsableClassName && function (className, context, xml) {
							if (typeof context.getElementsByClassName !== strundefined && !xml) {
								return context.getElementsByClassName(className);
							}
						}
					},

					relative: {
						">": { dir: "parentNode", first: true },
						" ": { dir: "parentNode" },
						"+": { dir: "previousSibling", first: true },
						"~": { dir: "previousSibling" }
					},

					preFilter: {
						"ATTR": function (match) {
							match[1] = match[1].replace(rbackslash, "");

							// Move the given value to match[3] whether quoted or unquoted
							match[3] = (match[4] || match[5] || "").replace(rbackslash, "");

							if (match[2] === "~=") {
								match[3] = " " + match[3] + " ";
							}

							return match.slice(0, 4);
						},

						"CHILD": function (match) {
							/* matches from matchExpr["CHILD"]
								1 type (only|nth|...)
								2 argument (even|odd|\d*|\d*n([+-]\d+)?|...)
								3 xn-component of xn+y argument ([+-]?\d*n|)
								4 sign of xn-component
								5 x of xn-component
								6 sign of y-component
								7 y of y-component
							*/
							match[1] = match[1].toLowerCase();

							if (match[1] === "nth") {
								// nth-child requires argument
								if (!match[2]) {
									Sizzle.error(match[0]);
								}

								// numeric x and y parameters for Expr.filter.CHILD
								// remember that false/true cast respectively to 0/1
								match[3] = +(match[3] ? match[4] + (match[5] || 1) : 2 * (match[2] === "even" || match[2] === "odd"));
								match[4] = +((match[6] + match[7]) || match[2] === "odd");

								// other types prohibit arguments
							} else if (match[2]) {
								Sizzle.error(match[0]);
							}

							return match;
						},

						"PSEUDO": function (match) {
							var unquoted, excess;
							if (matchExpr["CHILD"].test(match[0])) {
								return null;
							}

							if (match[3]) {
								match[2] = match[3];
							} else if ((unquoted = match[4])) {
								// Only check arguments that contain a pseudo
								if (rpseudo.test(unquoted) &&
									// Get excess from tokenize (recursively)
									(excess = tokenize(unquoted, true)) &&
									// advance to the next closing parenthesis
									(excess = unquoted.indexOf(")", unquoted.length - excess) - unquoted.length)) {

									// excess is a negative index
									unquoted = unquoted.slice(0, excess);
									match[0] = match[0].slice(0, excess);
								}
								match[2] = unquoted;
							}

							// Return only captures needed by the pseudo filter method (type and argument)
							return match.slice(0, 3);
						}
					},

					filter: {
						"ID": assertGetIdNotName ?
							function (id) {
								id = id.replace(rbackslash, "");
								return function (elem) {
									return elem.getAttribute("id") === id;
								};
							} :
							function (id) {
								id = id.replace(rbackslash, "");
								return function (elem) {
									var node = typeof elem.getAttributeNode !== strundefined && elem.getAttributeNode("id");
									return node && node.value === id;
								};
							},

						"TAG": function (nodeName) {
							if (nodeName === "*") {
								return function () { return true; };
							}
							nodeName = nodeName.replace(rbackslash, "").toLowerCase();

							return function (elem) {
								return elem.nodeName && elem.nodeName.toLowerCase() === nodeName;
							};
						},

						"CLASS": function (className) {
							var pattern = classCache[expando][className + " "];

							return pattern ||
								(pattern = new RegExp("(^|" + whitespace + ")" + className + "(" + whitespace + "|$)")) &&
								classCache(className, function (elem) {
									return pattern.test(elem.className || (typeof elem.getAttribute !== strundefined && elem.getAttribute("class")) || "");
								});
						},

						"ATTR": function (name, operator, check) {
							return function (elem, context) {
								var result = Sizzle.attr(elem, name);

								if (result == null) {
									return operator === "!=";
								}
								if (!operator) {
									return true;
								}

								result += "";

								return operator === "=" ? result === check :
									operator === "!=" ? result !== check :
										operator === "^=" ? check && result.indexOf(check) === 0 :
											operator === "*=" ? check && result.indexOf(check) > -1 :
												operator === "$=" ? check && result.substr(result.length - check.length) === check :
													operator === "~=" ? (" " + result + " ").indexOf(check) > -1 :
														operator === "|=" ? result === check || result.substr(0, check.length + 1) === check + "-" :
															false;
							};
						},

						"CHILD": function (type, argument, first, last) {

							if (type === "nth") {
								return function (elem) {
									var node, diff,
										parent = elem.parentNode;

									if (first === 1 && last === 0) {
										return true;
									}

									if (parent) {
										diff = 0;
										for (node = parent.firstChild; node; node = node.nextSibling) {
											if (node.nodeType === 1) {
												diff++;
												if (elem === node) {
													break;
												}
											}
										}
									}

									// Incorporate the offset (or cast to NaN), then check against cycle size
									diff -= last;
									return diff === first || (diff % first === 0 && diff / first >= 0);
								};
							}

							return function (elem) {
								var node = elem;

								switch (type) {
									case "only":
									case "first":
										while ((node = node.previousSibling)) {
											if (node.nodeType === 1) {
												return false;
											}
										}

										if (type === "first") {
											return true;
										}

										node = elem;

									/* falls through */
									case "last":
										while ((node = node.nextSibling)) {
											if (node.nodeType === 1) {
												return false;
											}
										}

										return true;
								}
							};
						},

						"PSEUDO": function (pseudo, argument) {
							// pseudo-class names are case-insensitive
							// http://www.w3.org/TR/selectors/#pseudo-classes
							// Prioritize by case sensitivity in case custom pseudos are added with uppercase letters
							// Remember that setFilters inherits from pseudos
							var args,
								fn = Expr.pseudos[pseudo] || Expr.setFilters[pseudo.toLowerCase()] ||
									Sizzle.error("unsupported pseudo: " + pseudo);

							// The user may use createPseudo to indicate that
							// arguments are needed to create the filter function
							// just as Sizzle does
							if (fn[expando]) {
								return fn(argument);
							}

							// But maintain support for old signatures
							if (fn.length > 1) {
								args = [pseudo, pseudo, "", argument];
								return Expr.setFilters.hasOwnProperty(pseudo.toLowerCase()) ?
									markFunction(function (seed, matches) {
										var idx,
											matched = fn(seed, argument),
											i = matched.length;
										while (i--) {
											idx = indexOf.call(seed, matched[i]);
											seed[idx] = !(matches[idx] = matched[i]);
										}
									}) :
									function (elem) {
										return fn(elem, 0, args);
									};
							}

							return fn;
						}
					},

					pseudos: {
						"not": markFunction(function (selector) {
							// Trim the selector passed to compile
							// to avoid treating leading and trailing
							// spaces as combinators
							var input = [],
								results = [],
								matcher = compile(selector.replace(rtrim, "$1"));

							return matcher[expando] ?
								markFunction(function (seed, matches, context, xml) {
									var elem,
										unmatched = matcher(seed, null, xml, []),
										i = seed.length;

									// Match elements unmatched by `matcher`
									while (i--) {
										if ((elem = unmatched[i])) {
											seed[i] = !(matches[i] = elem);
										}
									}
								}) :
								function (elem, context, xml) {
									input[0] = elem;
									matcher(input, null, xml, results);
									return !results.pop();
								};
						}),

						"has": markFunction(function (selector) {
							return function (elem) {
								return Sizzle(selector, elem).length > 0;
							};
						}),

						"contains": markFunction(function (text) {
							return function (elem) {
								return (elem.textContent || elem.innerText || getText(elem)).indexOf(text) > -1;
							};
						}),

						"enabled": function (elem) {
							return elem.disabled === false;
						},

						"disabled": function (elem) {
							return elem.disabled === true;
						},

						"checked": function (elem) {
							// In CSS3, :checked should return both checked and selected elements
							// http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
							var nodeName = elem.nodeName.toLowerCase();
							return (nodeName === "input" && !!elem.checked) || (nodeName === "option" && !!elem.selected);
						},

						"selected": function (elem) {
							// Accessing this property makes selected-by-default
							// options in Safari work properly
							if (elem.parentNode) {
								elem.parentNode.selectedIndex;
							}

							return elem.selected === true;
						},

						"parent": function (elem) {
							return !Expr.pseudos["empty"](elem);
						},

						"empty": function (elem) {
							// http://www.w3.org/TR/selectors/#empty-pseudo
							// :empty is only affected by element nodes and content nodes(including text(3), cdata(4)),
							//   not comment, processing instructions, or others
							// Thanks to Diego Perini for the nodeName shortcut
							//   Greater than "@" means alpha characters (specifically not starting with "#" or "?")
							var nodeType;
							elem = elem.firstChild;
							while (elem) {
								if (elem.nodeName > "@" || (nodeType = elem.nodeType) === 3 || nodeType === 4) {
									return false;
								}
								elem = elem.nextSibling;
							}
							return true;
						},

						"header": function (elem) {
							return rheader.test(elem.nodeName);
						},

						"text": function (elem) {
							var type, attr;
							// IE6 and 7 will map elem.type to 'text' for new HTML5 types (search, etc)
							// use getAttribute instead to test this case
							return elem.nodeName.toLowerCase() === "input" &&
								(type = elem.type) === "text" &&
								((attr = elem.getAttribute("type")) == null || attr.toLowerCase() === type);
						},

						// Input types
						"radio": createInputPseudo("radio"),
						"checkbox": createInputPseudo("checkbox"),
						"file": createInputPseudo("file"),
						"password": createInputPseudo("password"),
						"image": createInputPseudo("image"),

						"submit": createButtonPseudo("submit"),
						"reset": createButtonPseudo("reset"),

						"button": function (elem) {
							var name = elem.nodeName.toLowerCase();
							return name === "input" && elem.type === "button" || name === "button";
						},

						"input": function (elem) {
							return rinputs.test(elem.nodeName);
						},

						"focus": function (elem) {
							var doc = elem.ownerDocument;
							return elem === doc.activeElement && (!doc.hasFocus || doc.hasFocus()) && !!(elem.type || elem.href || ~elem.tabIndex);
						},

						"active": function (elem) {
							return elem === elem.ownerDocument.activeElement;
						},

						// Positional types
						"first": createPositionalPseudo(function () {
							return [0];
						}),

						"last": createPositionalPseudo(function (matchIndexes, length) {
							return [length - 1];
						}),

						"eq": createPositionalPseudo(function (matchIndexes, length, argument) {
							return [argument < 0 ? argument + length : argument];
						}),

						"even": createPositionalPseudo(function (matchIndexes, length) {
							for (var i = 0; i < length; i += 2) {
								matchIndexes.push(i);
							}
							return matchIndexes;
						}),

						"odd": createPositionalPseudo(function (matchIndexes, length) {
							for (var i = 1; i < length; i += 2) {
								matchIndexes.push(i);
							}
							return matchIndexes;
						}),

						"lt": createPositionalPseudo(function (matchIndexes, length, argument) {
							for (var i = argument < 0 ? argument + length : argument; --i >= 0;) {
								matchIndexes.push(i);
							}
							return matchIndexes;
						}),

						"gt": createPositionalPseudo(function (matchIndexes, length, argument) {
							for (var i = argument < 0 ? argument + length : argument; ++i < length;) {
								matchIndexes.push(i);
							}
							return matchIndexes;
						})
					}
				};

				function siblingCheck(a, b, ret) {
					if (a === b) {
						return ret;
					}

					var cur = a.nextSibling;

					while (cur) {
						if (cur === b) {
							return -1;
						}

						cur = cur.nextSibling;
					}

					return 1;
				}

				sortOrder = docElem.compareDocumentPosition ?
					function (a, b) {
						if (a === b) {
							hasDuplicate = true;
							return 0;
						}

						return (!a.compareDocumentPosition || !b.compareDocumentPosition ?
							a.compareDocumentPosition :
							a.compareDocumentPosition(b) & 4
						) ? -1 : 1;
					} :
					function (a, b) {
						// The nodes are identical, we can exit early
						if (a === b) {
							hasDuplicate = true;
							return 0;

							// Fallback to using sourceIndex (in IE) if it's available on both nodes
						} else if (a.sourceIndex && b.sourceIndex) {
							return a.sourceIndex - b.sourceIndex;
						}

						var al, bl,
							ap = [],
							bp = [],
							aup = a.parentNode,
							bup = b.parentNode,
							cur = aup;

						// If the nodes are siblings (or identical) we can do a quick check
						if (aup === bup) {
							return siblingCheck(a, b);

							// If no parents were found then the nodes are disconnected
						} else if (!aup) {
							return -1;

						} else if (!bup) {
							return 1;
						}

						// Otherwise they're somewhere else in the tree so we need
						// to build up a full list of the parentNodes for comparison
						while (cur) {
							ap.unshift(cur);
							cur = cur.parentNode;
						}

						cur = bup;

						while (cur) {
							bp.unshift(cur);
							cur = cur.parentNode;
						}

						al = ap.length;
						bl = bp.length;

						// Start walking down the tree looking for a discrepancy
						for (var i = 0; i < al && i < bl; i++) {
							if (ap[i] !== bp[i]) {
								return siblingCheck(ap[i], bp[i]);
							}
						}

						// We ended someplace up the tree so do a sibling check
						return i === al ?
							siblingCheck(a, bp[i], -1) :
							siblingCheck(ap[i], b, 1);
					};

				// Always assume the presence of duplicates if sort doesn't
				// pass them to our comparison function (as in Google Chrome).
				[0, 0].sort(sortOrder);
				baseHasDuplicate = !hasDuplicate;

				// Document sorting and removing duplicates
				Sizzle.uniqueSort = function (results) {
					var elem,
						duplicates = [],
						i = 1,
						j = 0;

					hasDuplicate = baseHasDuplicate;
					results.sort(sortOrder);

					if (hasDuplicate) {
						for (; (elem = results[i]); i++) {
							if (elem === results[i - 1]) {
								j = duplicates.push(i);
							}
						}
						while (j--) {
							results.splice(duplicates[j], 1);
						}
					}

					return results;
				};

				Sizzle.error = function (msg) {
					throw new Error("Syntax error, unrecognized expression: " + msg);
				};

				function tokenize(selector, parseOnly) {
					var matched, match, tokens, type,
						soFar, groups, preFilters,
						cached = tokenCache[expando][selector + " "];

					if (cached) {
						return parseOnly ? 0 : cached.slice(0);
					}

					soFar = selector;
					groups = [];
					preFilters = Expr.preFilter;

					while (soFar) {

						// Comma and first run
						if (!matched || (match = rcomma.exec(soFar))) {
							if (match) {
								// Don't consume trailing commas as valid
								soFar = soFar.slice(match[0].length) || soFar;
							}
							groups.push(tokens = []);
						}

						matched = false;

						// Combinators
						if ((match = rcombinators.exec(soFar))) {
							tokens.push(matched = new Token(match.shift()));
							soFar = soFar.slice(matched.length);

							// Cast descendant combinators to space
							matched.type = match[0].replace(rtrim, " ");
						}

						// Filters
						for (type in Expr.filter) {
							if ((match = matchExpr[type].exec(soFar)) && (!preFilters[type] ||
								(match = preFilters[type](match)))) {

								tokens.push(matched = new Token(match.shift()));
								soFar = soFar.slice(matched.length);
								matched.type = type;
								matched.matches = match;
							}
						}

						if (!matched) {
							break;
						}
					}

					// Return the length of the invalid excess
					// if we're just parsing
					// Otherwise, throw an error or return tokens
					return parseOnly ?
						soFar.length :
						soFar ?
							Sizzle.error(selector) :
							// Cache the tokens
							tokenCache(selector, groups).slice(0);
				}

				function addCombinator(matcher, combinator, base) {
					var dir = combinator.dir,
						checkNonElements = base && combinator.dir === "parentNode",
						doneName = done++;

					return combinator.first ?
						// Check against closest ancestor/preceding element
						function (elem, context, xml) {
							while ((elem = elem[dir])) {
								if (checkNonElements || elem.nodeType === 1) {
									return matcher(elem, context, xml);
								}
							}
						} :

						// Check against all ancestor/preceding elements
						function (elem, context, xml) {
							// We can't set arbitrary data on XML nodes, so they don't benefit from dir caching
							if (!xml) {
								var cache,
									dirkey = dirruns + " " + doneName + " ",
									cachedkey = dirkey + cachedruns;
								while ((elem = elem[dir])) {
									if (checkNonElements || elem.nodeType === 1) {
										if ((cache = elem[expando]) === cachedkey) {
											return elem.sizset;
										} else if (typeof cache === "string" && cache.indexOf(dirkey) === 0) {
											if (elem.sizset) {
												return elem;
											}
										} else {
											elem[expando] = cachedkey;
											if (matcher(elem, context, xml)) {
												elem.sizset = true;
												return elem;
											}
											elem.sizset = false;
										}
									}
								}
							} else {
								while ((elem = elem[dir])) {
									if (checkNonElements || elem.nodeType === 1) {
										if (matcher(elem, context, xml)) {
											return elem;
										}
									}
								}
							}
						};
				}

				function elementMatcher(matchers) {
					return matchers.length > 1 ?
						function (elem, context, xml) {
							var i = matchers.length;
							while (i--) {
								if (!matchers[i](elem, context, xml)) {
									return false;
								}
							}
							return true;
						} :
						matchers[0];
				}

				function condense(unmatched, map, filter, context, xml) {
					var elem,
						newUnmatched = [],
						i = 0,
						len = unmatched.length,
						mapped = map != null;

					for (; i < len; i++) {
						if ((elem = unmatched[i])) {
							if (!filter || filter(elem, context, xml)) {
								newUnmatched.push(elem);
								if (mapped) {
									map.push(i);
								}
							}
						}
					}

					return newUnmatched;
				}

				function setMatcher(preFilter, selector, matcher, postFilter, postFinder, postSelector) {
					if (postFilter && !postFilter[expando]) {
						postFilter = setMatcher(postFilter);
					}
					if (postFinder && !postFinder[expando]) {
						postFinder = setMatcher(postFinder, postSelector);
					}
					return markFunction(function (seed, results, context, xml) {
						var temp, i, elem,
							preMap = [],
							postMap = [],
							preexisting = results.length,

							// Get initial elements from seed or context
							elems = seed || multipleContexts(selector || "*", context.nodeType ? [context] : context, []),

							// Prefilter to get matcher input, preserving a map for seed-results synchronization
							matcherIn = preFilter && (seed || !selector) ?
								condense(elems, preMap, preFilter, context, xml) :
								elems,

							matcherOut = matcher ?
								// If we have a postFinder, or filtered seed, or non-seed postFilter or preexisting results,
								postFinder || (seed ? preFilter : preexisting || postFilter) ?

									// ...intermediate processing is necessary
									[] :

									// ...otherwise use results directly
									results :
								matcherIn;

						// Find primary matches
						if (matcher) {
							matcher(matcherIn, matcherOut, context, xml);
						}

						// Apply postFilter
						if (postFilter) {
							temp = condense(matcherOut, postMap);
							postFilter(temp, [], context, xml);

							// Un-match failing elements by moving them back to matcherIn
							i = temp.length;
							while (i--) {
								if ((elem = temp[i])) {
									matcherOut[postMap[i]] = !(matcherIn[postMap[i]] = elem);
								}
							}
						}

						if (seed) {
							if (postFinder || preFilter) {
								if (postFinder) {
									// Get the final matcherOut by condensing this intermediate into postFinder contexts
									temp = [];
									i = matcherOut.length;
									while (i--) {
										if ((elem = matcherOut[i])) {
											// Restore matcherIn since elem is not yet a final match
											temp.push((matcherIn[i] = elem));
										}
									}
									postFinder(null, (matcherOut = []), temp, xml);
								}

								// Move matched elements from seed to results to keep them synchronized
								i = matcherOut.length;
								while (i--) {
									if ((elem = matcherOut[i]) &&
										(temp = postFinder ? indexOf.call(seed, elem) : preMap[i]) > -1) {

										seed[temp] = !(results[temp] = elem);
									}
								}
							}

							// Add elements to results, through postFinder if defined
						} else {
							matcherOut = condense(
								matcherOut === results ?
									matcherOut.splice(preexisting, matcherOut.length) :
									matcherOut
							);
							if (postFinder) {
								postFinder(null, results, matcherOut, xml);
							} else {
								push.apply(results, matcherOut);
							}
						}
					});
				}

				function matcherFromTokens(tokens) {
					var checkContext, matcher, j,
						len = tokens.length,
						leadingRelative = Expr.relative[tokens[0].type],
						implicitRelative = leadingRelative || Expr.relative[" "],
						i = leadingRelative ? 1 : 0,

						// The foundational matcher ensures that elements are reachable from top-level context(s)
						matchContext = addCombinator(function (elem) {
							return elem === checkContext;
						}, implicitRelative, true),
						matchAnyContext = addCombinator(function (elem) {
							return indexOf.call(checkContext, elem) > -1;
						}, implicitRelative, true),
						matchers = [function (elem, context, xml) {
							return (!leadingRelative && (xml || context !== outermostContext)) || (
								(checkContext = context).nodeType ?
									matchContext(elem, context, xml) :
									matchAnyContext(elem, context, xml));
						}];

					for (; i < len; i++) {
						if ((matcher = Expr.relative[tokens[i].type])) {
							matchers = [addCombinator(elementMatcher(matchers), matcher)];
						} else {
							matcher = Expr.filter[tokens[i].type].apply(null, tokens[i].matches);

							// Return special upon seeing a positional matcher
							if (matcher[expando]) {
								// Find the next relative operator (if any) for proper handling
								j = ++i;
								for (; j < len; j++) {
									if (Expr.relative[tokens[j].type]) {
										break;
									}
								}
								return setMatcher(
									i > 1 && elementMatcher(matchers),
									i > 1 && tokens.slice(0, i - 1).join("").replace(rtrim, "$1"),
									matcher,
									i < j && matcherFromTokens(tokens.slice(i, j)),
									j < len && matcherFromTokens((tokens = tokens.slice(j))),
									j < len && tokens.join("")
								);
							}
							matchers.push(matcher);
						}
					}

					return elementMatcher(matchers);
				}

				function matcherFromGroupMatchers(elementMatchers, setMatchers) {
					var bySet = setMatchers.length > 0,
						byElement = elementMatchers.length > 0,
						superMatcher = function (seed, context, xml, results, expandContext) {
							var elem, j, matcher,
								setMatched = [],
								matchedCount = 0,
								i = "0",
								unmatched = seed && [],
								outermost = expandContext != null,
								contextBackup = outermostContext,
								// We must always have either seed elements or context
								elems = seed || byElement && Expr.find["TAG"]("*", expandContext && context.parentNode || context),
								// Nested matchers should use non-integer dirruns
								dirrunsUnique = (dirruns += contextBackup == null ? 1 : Math.E);

							if (outermost) {
								outermostContext = context !== document && context;
								cachedruns = superMatcher.el;
							}

							// Add elements passing elementMatchers directly to results
							for (; (elem = elems[i]) != null; i++) {
								if (byElement && elem) {
									for (j = 0; (matcher = elementMatchers[j]); j++) {
										if (matcher(elem, context, xml)) {
											results.push(elem);
											break;
										}
									}
									if (outermost) {
										dirruns = dirrunsUnique;
										cachedruns = ++superMatcher.el;
									}
								}

								// Track unmatched elements for set filters
								if (bySet) {
									// They will have gone through all possible matchers
									if ((elem = !matcher && elem)) {
										matchedCount--;
									}

									// Lengthen the array for every element, matched or not
									if (seed) {
										unmatched.push(elem);
									}
								}
							}

							// Apply set filters to unmatched elements
							matchedCount += i;
							if (bySet && i !== matchedCount) {
								for (j = 0; (matcher = setMatchers[j]); j++) {
									matcher(unmatched, setMatched, context, xml);
								}

								if (seed) {
									// Reintegrate element matches to eliminate the need for sorting
									if (matchedCount > 0) {
										while (i--) {
											if (!(unmatched[i] || setMatched[i])) {
												setMatched[i] = pop.call(results);
											}
										}
									}

									// Discard index placeholder values to get only actual matches
									setMatched = condense(setMatched);
								}

								// Add matches to results
								push.apply(results, setMatched);

								// Seedless set matches succeeding multiple successful matchers stipulate sorting
								if (outermost && !seed && setMatched.length > 0 &&
									(matchedCount + setMatchers.length) > 1) {

									Sizzle.uniqueSort(results);
								}
							}

							// Override manipulation of globals by nested matchers
							if (outermost) {
								dirruns = dirrunsUnique;
								outermostContext = contextBackup;
							}

							return unmatched;
						};

					superMatcher.el = 0;
					return bySet ?
						markFunction(superMatcher) :
						superMatcher;
				}

				compile = Sizzle.compile = function (selector, group /* Internal Use Only */) {
					var i,
						setMatchers = [],
						elementMatchers = [],
						cached = compilerCache[expando][selector + " "];

					if (!cached) {
						// Generate a function of recursive functions that can be used to check each element
						if (!group) {
							group = tokenize(selector);
						}
						i = group.length;
						while (i--) {
							cached = matcherFromTokens(group[i]);
							if (cached[expando]) {
								setMatchers.push(cached);
							} else {
								elementMatchers.push(cached);
							}
						}

						// Cache the compiled function
						cached = compilerCache(selector, matcherFromGroupMatchers(elementMatchers, setMatchers));
					}
					return cached;
				};

				function multipleContexts(selector, contexts, results) {
					var i = 0,
						len = contexts.length;
					for (; i < len; i++) {
						Sizzle(selector, contexts[i], results);
					}
					return results;
				}

				function select(selector, context, results, seed, xml) {
					var i, tokens, token, type, find,
						match = tokenize(selector),
						j = match.length;

					if (!seed) {
						// Try to minimize operations if there is only one group
						if (match.length === 1) {

							// Take a shortcut and set the context if the root selector is an ID
							tokens = match[0] = match[0].slice(0);
							if (tokens.length > 2 && (token = tokens[0]).type === "ID" &&
								context.nodeType === 9 && !xml &&
								Expr.relative[tokens[1].type]) {

								context = Expr.find["ID"](token.matches[0].replace(rbackslash, ""), context, xml)[0];
								if (!context) {
									return results;
								}

								selector = selector.slice(tokens.shift().length);
							}

							// Fetch a seed set for right-to-left matching
							for (i = matchExpr["POS"].test(selector) ? -1 : tokens.length - 1; i >= 0; i--) {
								token = tokens[i];

								// Abort if we hit a combinator
								if (Expr.relative[(type = token.type)]) {
									break;
								}
								if ((find = Expr.find[type])) {
									// Search, expanding context for leading sibling combinators
									if ((seed = find(
										token.matches[0].replace(rbackslash, ""),
										rsibling.test(tokens[0].type) && context.parentNode || context,
										xml
									))) {

										// If seed is empty or no tokens remain, we can return early
										tokens.splice(i, 1);
										selector = seed.length && tokens.join("");
										if (!selector) {
											push.apply(results, slice.call(seed, 0));
											return results;
										}

										break;
									}
								}
							}
						}
					}

					// Compile and execute a filtering function
					// Provide `match` to avoid retokenization if we modified the selector above
					compile(selector, match)(
						seed,
						context,
						xml,
						results,
						rsibling.test(selector)
					);
					return results;
				}

				if (document.querySelectorAll) {
					(function () {
						var disconnectedMatch,
							oldSelect = select,
							rescape = /'|\\/g,
							rattributeQuotes = /\=[\x20\t\r\n\f]*([^'"\]]*)[\x20\t\r\n\f]*\]/g,

							// qSa(:focus) reports false when true (Chrome 21), no need to also add to buggyMatches since matches checks buggyQSA
							// A support test would require too much code (would include document ready)
							rbuggyQSA = [":focus"],

							// matchesSelector(:active) reports false when true (IE9/Opera 11.5)
							// A support test would require too much code (would include document ready)
							// just skip matchesSelector for :active
							rbuggyMatches = [":active"],
							matches = docElem.matchesSelector ||
								docElem.mozMatchesSelector ||
								docElem.webkitMatchesSelector ||
								docElem.oMatchesSelector ||
								docElem.msMatchesSelector;

						// Build QSA regex
						// Regex strategy adopted from Diego Perini
						assert(function (div) {
							// Select is set to empty string on purpose
							// This is to test IE's treatment of not explictly
							// setting a boolean content attribute,
							// since its presence should be enough
							// http://bugs.jqx.com/ticket/12359
							div.innerHTML = "<select><option selected=''></option></select>";

							// IE8 - Some boolean attributes are not treated correctly
							if (!div.querySelectorAll("[selected]").length) {
								rbuggyQSA.push("\\[" + whitespace + "*(?:checked|disabled|ismap|multiple|readonly|selected|value)");
							}

							// Webkit/Opera - :checked should return selected option elements
							// http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
							// IE8 throws error here (do not put tests after this one)
							if (!div.querySelectorAll(":checked").length) {
								rbuggyQSA.push(":checked");
							}
						});

						assert(function (div) {

							// Opera 10-12/IE9 - ^= $= *= and empty values
							// Should not select anything
							div.innerHTML = "<p test=''></p>";
							if (div.querySelectorAll("[test^='']").length) {
								rbuggyQSA.push("[*^$]=" + whitespace + "*(?:\"\"|'')");
							}

							// FF 3.5 - :enabled/:disabled and hidden elements (hidden elements are still enabled)
							// IE8 throws error here (do not put tests after this one)
							div.innerHTML = "<input type='hidden'/>";
							if (!div.querySelectorAll(":enabled").length) {
								rbuggyQSA.push(":enabled", ":disabled");
							}
						});

						// rbuggyQSA always contains :focus, so no need for a length check
						rbuggyQSA = /* rbuggyQSA.length && */ new RegExp(rbuggyQSA.join("|"));

						select = function (selector, context, results, seed, xml) {
							// Only use querySelectorAll when not filtering,
							// when this is not xml,
							// and when no QSA bugs apply
							if (!seed && !xml && !rbuggyQSA.test(selector)) {
								var groups, i,
									old = true,
									nid = expando,
									newContext = context,
									newSelector = context.nodeType === 9 && selector;

								// qSA works strangely on Element-rooted queries
								// We can work around this by specifying an extra ID on the root
								// and working up from there (Thanks to Andrew Dupont for the technique)
								// IE 8 doesn't work on object elements
								if (context.nodeType === 1 && context.nodeName.toLowerCase() !== "object") {
									groups = tokenize(selector);

									if ((old = context.getAttribute("id"))) {
										nid = old.replace(rescape, "\\$&");
									} else {
										context.setAttribute("id", nid);
									}
									nid = "[id='" + nid + "'] ";

									i = groups.length;
									while (i--) {
										groups[i] = nid + groups[i].join("");
									}
									newContext = rsibling.test(selector) && context.parentNode || context;
									newSelector = groups.join(",");
								}

								if (newSelector) {
									try {
										push.apply(results, slice.call(newContext.querySelectorAll(
											newSelector
										), 0));
										return results;
									} catch (qsaError) {
									} finally {
										if (!old) {
											context.removeAttribute("id");
										}
									}
								}
							}

							return oldSelect(selector, context, results, seed, xml);
						};

						if (matches) {
							assert(function (div) {
								// Check to see if it's possible to do matchesSelector
								// on a disconnected node (IE 9)
								disconnectedMatch = matches.call(div, "div");

								// This should fail with an exception
								// Gecko does not error, returns false instead
								try {
									matches.call(div, "[test!='']:sizzle");
									rbuggyMatches.push("!=", pseudos);
								} catch (e) { }
							});

							// rbuggyMatches always contains :active and :focus, so no need for a length check
							rbuggyMatches = /* rbuggyMatches.length && */ new RegExp(rbuggyMatches.join("|"));

							Sizzle.matchesSelector = function (elem, expr) {
								// Make sure that attribute selectors are quoted
								expr = expr.replace(rattributeQuotes, "='$1']");

								// rbuggyMatches always contains :active, so no need for an existence check
								if (!isXML(elem) && !rbuggyMatches.test(expr) && !rbuggyQSA.test(expr)) {
									try {
										var ret = matches.call(elem, expr);

										// IE 9's matchesSelector returns false on disconnected nodes
										if (ret || disconnectedMatch ||
											// As well, disconnected nodes are said to be in a document
											// fragment in IE 9
											elem.document && elem.document.nodeType !== 11) {
											return ret;
										}
									} catch (e) { }
								}

								return Sizzle(expr, null, null, [elem]).length > 0;
							};
						}
					})();
				}

				// Deprecated
				Expr.pseudos["nth"] = Expr.pseudos["eq"];

				// Back-compat
				function setFilters() { }
				Expr.filters = setFilters.prototype = Expr.pseudos;
				Expr.setFilters = new setFilters();

				// Override sizzle attribute retrieval
				Sizzle.attr = JQXLite.attr;
				JQXLite.find = Sizzle;
				JQXLite.expr = Sizzle.selectors;
				JQXLite.expr[":"] = JQXLite.expr.pseudos;
				JQXLite.unique = Sizzle.uniqueSort;
				JQXLite.text = Sizzle.getText;
				JQXLite.isXMLDoc = Sizzle.isXML;
				JQXLite.contains = Sizzle.contains;


			})(window);
			var runtil = /Until$/,
				rparentsprev = /^(?:parents|prev(?:Until|All))/,
				isSimple = /^.[^:#\[\.,]*$/,
				rneedsContext = JQXLite.expr.match.needsContext,
				// methods guaranteed to produce a unique set when starting from a unique set
				guaranteedUnique = {
					children: true,
					contents: true,
					next: true,
					prev: true
				};

			JQXLite.fn.extend({
				find: function (selector) {
					var i, l, length, n, r, ret,
						self = this;

					if (typeof selector !== "string") {
						return JQXLite(selector).filter(function () {
							for (i = 0, l = self.length; i < l; i++) {
								if (JQXLite.contains(self[i], this)) {
									return true;
								}
							}
						});
					}

					ret = this.pushStack("", "find", selector);

					for (i = 0, l = this.length; i < l; i++) {
						length = ret.length;
						JQXLite.find(selector, this[i], ret);

						if (i > 0) {
							// Make sure that the results are unique
							for (n = length; n < ret.length; n++) {
								for (r = 0; r < length; r++) {
									if (ret[r] === ret[n]) {
										ret.splice(n--, 1);
										break;
									}
								}
							}
						}
					}

					return ret;
				},

				has: function (target) {
					var i,
						targets = JQXLite(target, this),
						len = targets.length;

					return this.filter(function () {
						for (i = 0; i < len; i++) {
							if (JQXLite.contains(this, targets[i])) {
								return true;
							}
						}
					});
				},

				not: function (selector) {
					return this.pushStack(winnow(this, selector, false), "not", selector);
				},

				filter: function (selector) {
					return this.pushStack(winnow(this, selector, true), "filter", selector);
				},

				is: function (selector) {
					return !!selector && (
						typeof selector === "string" ?
							// If this is a positional/relative selector, check membership in the returned set
							// so $("p:first").is("p:last") won't return true for a doc with two "p".
							rneedsContext.test(selector) ?
								JQXLite(selector, this.context).index(this[0]) >= 0 :
								JQXLite.filter(selector, this).length > 0 :
							this.filter(selector).length > 0);
				},

				closest: function (selectors, context) {
					var cur,
						i = 0,
						l = this.length,
						ret = [],
						pos = rneedsContext.test(selectors) || typeof selectors !== "string" ?
							JQXLite(selectors, context || this.context) :
							0;

					for (; i < l; i++) {
						cur = this[i];

						while (cur && cur.ownerDocument && cur !== context && cur.nodeType !== 11) {
							if (pos ? pos.index(cur) > -1 : JQXLite.find.matchesSelector(cur, selectors)) {
								ret.push(cur);
								break;
							}
							cur = cur.parentNode;
						}
					}

					ret = ret.length > 1 ? JQXLite.unique(ret) : ret;

					return this.pushStack(ret, "closest", selectors);
				},

				// Determine the position of an element within
				// the matched set of elements
				index: function (elem) {

					// No argument, return index in parent
					if (!elem) {
						return (this[0] && this[0].parentNode) ? this.prevAll().length : -1;
					}

					// index in selector
					if (typeof elem === "string") {
						return JQXLite.inArray(this[0], JQXLite(elem));
					}

					// Locate the position of the desired element
					return JQXLite.inArray(
						// If it receives a JQXLite object, the first element is used
						elem.jqx ? elem[0] : elem, this);
				},

				add: function (selector, context) {
					var set = typeof selector === "string" ?
						JQXLite(selector, context) :
						JQXLite.makeArray(selector && selector.nodeType ? [selector] : selector),
						all = JQXLite.merge(this.get(), set);

					return this.pushStack(isDisconnected(set[0]) || isDisconnected(all[0]) ?
						all :
						JQXLite.unique(all));
				},

				addBack: function (selector) {
					return this.add(selector == null ?
						this.prevObject : this.prevObject.filter(selector)
					);
				}
			});

			JQXLite.fn.andSelf = JQXLite.fn.addBack;

			// A painfully simple check to see if an element is disconnected
			// from a document (should be improved, where feasible).
			function isDisconnected(node) {
				return !node || !node.parentNode || node.parentNode.nodeType === 11;
			}

			function sibling(cur, dir) {
				do {
					cur = cur[dir];
				} while (cur && cur.nodeType !== 1);

				return cur;
			}

			JQXLite.each({
				parent: function (elem) {
					var parent = elem.parentNode;
					return parent && parent.nodeType !== 11 ? parent : null;
				},
				parents: function (elem) {
					return JQXLite.dir(elem, "parentNode");
				},
				parentsUntil: function (elem, i, until) {
					return JQXLite.dir(elem, "parentNode", until);
				},
				next: function (elem) {
					return sibling(elem, "nextSibling");
				},
				prev: function (elem) {
					return sibling(elem, "previousSibling");
				},
				nextAll: function (elem) {
					return JQXLite.dir(elem, "nextSibling");
				},
				prevAll: function (elem) {
					return JQXLite.dir(elem, "previousSibling");
				},
				nextUntil: function (elem, i, until) {
					return JQXLite.dir(elem, "nextSibling", until);
				},
				prevUntil: function (elem, i, until) {
					return JQXLite.dir(elem, "previousSibling", until);
				},
				siblings: function (elem) {
					return JQXLite.sibling((elem.parentNode || {}).firstChild, elem);
				},
				children: function (elem) {
					return JQXLite.sibling(elem.firstChild);
				},
				contents: function (elem) {
					return JQXLite.nodeName(elem, "iframe") ?
						elem.contentDocument || elem.contentWindow.document :
						JQXLite.merge([], elem.childNodes);
				}
			}, function (name, fn) {
				JQXLite.fn[name] = function (until, selector) {
					var ret = JQXLite.map(this, fn, until);

					if (!runtil.test(name)) {
						selector = until;
					}

					if (selector && typeof selector === "string") {
						ret = JQXLite.filter(selector, ret);
					}

					ret = this.length > 1 && !guaranteedUnique[name] ? JQXLite.unique(ret) : ret;

					if (this.length > 1 && rparentsprev.test(name)) {
						ret = ret.reverse();
					}

					return this.pushStack(ret, name, core_slice.call(arguments).join(","));
				};
			});

			JQXLite.extend({
				filter: function (expr, elems, not) {
					if (not) {
						expr = ":not(" + expr + ")";
					}

					return elems.length === 1 ?
						JQXLite.find.matchesSelector(elems[0], expr) ? [elems[0]] : [] :
						JQXLite.find.matches(expr, elems);
				},

				dir: function (elem, dir, until) {
					var matched = [],
						cur = elem[dir];

					while (cur && cur.nodeType !== 9 && (until === undefined || cur.nodeType !== 1 || !JQXLite(cur).is(until))) {
						if (cur.nodeType === 1) {
							matched.push(cur);
						}
						cur = cur[dir];
					}
					return matched;
				},

				sibling: function (n, elem) {
					var r = [];

					for (; n; n = n.nextSibling) {
						if (n.nodeType === 1 && n !== elem) {
							r.push(n);
						}
					}

					return r;
				}
			});

			// Implement the identical functionality for filter and not
			function winnow(elements, qualifier, keep) {

				// Can't pass null or undefined to indexOf in Firefox 4
				// Set to 0 to skip string check
				qualifier = qualifier || 0;

				if (JQXLite.isFunction(qualifier)) {
					return JQXLite.grep(elements, function (elem, i) {
						var retVal = !!qualifier.call(elem, i, elem);
						return retVal === keep;
					});

				} else if (qualifier.nodeType) {
					return JQXLite.grep(elements, function (elem, i) {
						return (elem === qualifier) === keep;
					});

				} else if (typeof qualifier === "string") {
					var filtered = JQXLite.grep(elements, function (elem) {
						return elem.nodeType === 1;
					});

					if (isSimple.test(qualifier)) {
						return JQXLite.filter(qualifier, filtered, !keep);
					} else {
						qualifier = JQXLite.filter(qualifier, filtered);
					}
				}

				return JQXLite.grep(elements, function (elem, i) {
					return (JQXLite.inArray(elem, qualifier) >= 0) === keep;
				});
			}
			function createSafeFragment(document) {
				var list = nodeNames.split("|"),
					safeFrag = document.createDocumentFragment();

				if (safeFrag.createElement) {
					while (list.length) {
						safeFrag.createElement(
							list.pop()
						);
					}
				}
				return safeFrag;
			}

			var nodeNames = "abbr|article|aside|audio|bdi|canvas|data|datalist|details|figcaption|figure|footer|" +
				"header|hgroup|mark|meter|nav|output|progress|section|summary|time|video",
				rinlinejQuery = / JQXLite\d+="(?:null|\d+)"/g,
				rleadingWhitespace = /^\s+/,
				rxhtmlTag = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\w:]+)[^>]*)\/>/gi,
				rtagName = /<([\w:]+)/,
				rtbody = /<tbody/i,
				rhtml = /<|&#?\w+;/,
				rnoInnerhtml = /<(?:script|style|link)/i,
				rnocache = /<(?:script|object|embed|option|style)/i,
				rnoshimcache = new RegExp("<(?:" + nodeNames + ")[\\s/>]", "i"),
				rcheckableType = /^(?:checkbox|radio)$/,
				// checked="checked" or checked
				rchecked = /checked\s*(?:[^=]|=\s*.checked.)/i,
				rscriptType = /\/(java|ecma)script/i,
				rcleanScript = /^\s*<!(?:\[CDATA\[|\-\-)|[\]\-]{2}>\s*$/g,
				wrapMap = {
					option: [1, "<select multiple='multiple'>", "</select>"],
					legend: [1, "<fieldset>", "</fieldset>"],
					thead: [1, "<table>", "</table>"],
					tr: [2, "<table><tbody>", "</tbody></table>"],
					td: [3, "<table><tbody><tr>", "</tr></tbody></table>"],
					col: [2, "<table><tbody></tbody><colgroup>", "</colgroup></table>"],
					area: [1, "<map>", "</map>"],
					_default: [0, "", ""]
				},
				safeFragment = createSafeFragment(document),
				fragmentDiv = safeFragment.appendChild(document.createElement("div"));

			wrapMap.optgroup = wrapMap.option;
			wrapMap.tbody = wrapMap.tfoot = wrapMap.colgroup = wrapMap.caption = wrapMap.thead;
			wrapMap.th = wrapMap.td;

			// IE6-8 can't serialize link, script, style, or any html5 (NoScope) tags,
			// unless wrapped in a div with non-breaking characters in front of it.
			if (!JQXLite.support.htmlSerialize) {
				wrapMap._default = [1, "X<div>", "</div>"];
			}

			JQXLite.fn.extend({
				text: function (value) {
					return JQXLite.access(this, function (value) {
						return value === undefined ?
							JQXLite.text(this) :
							this.empty().append((this[0] && this[0].ownerDocument || document).createTextNode(value));
					}, null, value, arguments.length);
				},

				wrapAll: function (html) {
					if (JQXLite.isFunction(html)) {
						return this.each(function (i) {
							JQXLite(this).wrapAll(html.call(this, i));
						});
					}

					if (this[0]) {
						// The elements to wrap the target around
						var wrap = JQXLite(html, this[0].ownerDocument).eq(0).clone(true);

						if (this[0].parentNode) {
							wrap.insertBefore(this[0]);
						}

						wrap.map(function () {
							var elem = this;

							while (elem.firstChild && elem.firstChild.nodeType === 1) {
								elem = elem.firstChild;
							}

							return elem;
						}).append(this);
					}

					return this;
				},

				wrapInner: function (html) {
					if (JQXLite.isFunction(html)) {
						return this.each(function (i) {
							JQXLite(this).wrapInner(html.call(this, i));
						});
					}

					return this.each(function () {
						var self = JQXLite(this),
							contents = self.contents();

						if (contents.length) {
							contents.wrapAll(html);

						} else {
							self.append(html);
						}
					});
				},

				wrap: function (html) {
					var isFunction = JQXLite.isFunction(html);

					return this.each(function (i) {
						JQXLite(this).wrapAll(isFunction ? html.call(this, i) : html);
					});
				},

				unwrap: function () {
					return this.parent().each(function () {
						if (!JQXLite.nodeName(this, "body")) {
							JQXLite(this).replaceWith(this.childNodes);
						}
					}).end();
				},

				append: function () {
					return this.domManip(arguments, true, function (elem) {
						if (this.nodeType === 1 || this.nodeType === 11) {
							this.appendChild(elem);
						}
					});
				},

				prepend: function () {
					return this.domManip(arguments, true, function (elem) {
						if (this.nodeType === 1 || this.nodeType === 11) {
							this.insertBefore(elem, this.firstChild);
						}
					});
				},

				before: function () {
					if (!isDisconnected(this[0])) {
						return this.domManip(arguments, false, function (elem) {
							this.parentNode.insertBefore(elem, this);
						});
					}

					if (arguments.length) {
						var set = JQXLite.clean(arguments);
						return this.pushStack(JQXLite.merge(set, this), "before", this.selector);
					}
				},

				after: function () {
					if (!isDisconnected(this[0])) {
						return this.domManip(arguments, false, function (elem) {
							this.parentNode.insertBefore(elem, this.nextSibling);
						});
					}

					if (arguments.length) {
						var set = JQXLite.clean(arguments);
						return this.pushStack(JQXLite.merge(this, set), "after", this.selector);
					}
				},

				// keepData is for internal use only--do not document
				remove: function (selector, keepData) {
					var elem,
						i = 0;

					for (; (elem = this[i]) != null; i++) {
						if (!selector || JQXLite.filter(selector, [elem]).length) {
							if (!keepData && elem.nodeType === 1) {
								JQXLite.cleanData(elem.getElementsByTagName("*"));
								JQXLite.cleanData([elem]);
							}

							if (elem.parentNode) {
								elem.parentNode.removeChild(elem);
							}
						}
					}

					return this;
				},

				empty: function () {
					var elem,
						i = 0;

					for (; (elem = this[i]) != null; i++) {
						// Remove element nodes and prevent memory leaks
						if (elem.nodeType === 1) {
							JQXLite.cleanData(elem.getElementsByTagName("*"));
						}

						// Remove any remaining nodes
						while (elem.firstChild) {
							elem.removeChild(elem.firstChild);
						}
					}

					return this;
				},

				clone: function (dataAndEvents, deepDataAndEvents) {
					dataAndEvents = dataAndEvents == null ? false : dataAndEvents;
					deepDataAndEvents = deepDataAndEvents == null ? dataAndEvents : deepDataAndEvents;

					return this.map(function () {
						return JQXLite.clone(this, dataAndEvents, deepDataAndEvents);
					});
				},

				html: function (value) {
					return JQXLite.access(this, function (value) {
						var elem = this[0] || {},
							i = 0,
							l = this.length;

						if (value === undefined) {
							return elem.nodeType === 1 ?
								elem.innerHTML.replace(rinlinejQuery, "") :
								undefined;
						}

						// See if we can take a shortcut and just use innerHTML
						if (typeof value === "string" && !rnoInnerhtml.test(value) &&
							(JQXLite.support.htmlSerialize || !rnoshimcache.test(value)) &&
							(JQXLite.support.leadingWhitespace || !rleadingWhitespace.test(value)) &&
							!wrapMap[(rtagName.exec(value) || ["", ""])[1].toLowerCase()]) {

							value = value.replace(rxhtmlTag, "<$1></$2>");

							try {
								for (; i < l; i++) {
									// Remove element nodes and prevent memory leaks
									elem = this[i] || {};
									if (elem.nodeType === 1) {
										JQXLite.cleanData(elem.getElementsByTagName("*"));
										elem.innerHTML = value;
									}
								}

								elem = 0;

								// If using innerHTML throws an exception, use the fallback method
							} catch (e) { }
						}

						if (elem) {
							this.empty().append(value);
						}
					}, null, value, arguments.length);
				},

				replaceWith: function (value) {
					if (!isDisconnected(this[0])) {
						// Make sure that the elements are removed from the DOM before they are inserted
						// this can help fix replacing a parent with child elements
						if (JQXLite.isFunction(value)) {
							return this.each(function (i) {
								var self = JQXLite(this), old = self.html();
								self.replaceWith(value.call(this, i, old));
							});
						}

						if (typeof value !== "string") {
							value = JQXLite(value).detach();
						}

						return this.each(function () {
							var next = this.nextSibling,
								parent = this.parentNode;

							JQXLite(this).remove();

							if (next) {
								JQXLite(next).before(value);
							} else {
								JQXLite(parent).append(value);
							}
						});
					}

					return this.length ?
						this.pushStack(JQXLite(JQXLite.isFunction(value) ? value() : value), "replaceWith", value) :
						this;
				},

				detach: function (selector) {
					return this.remove(selector, true);
				},

				domManip: function (args, table, callback) {

					// Flatten any nested arrays
					args = [].concat.apply([], args);

					var results, first, fragment, iNoClone,
						i = 0,
						value = args[0],
						scripts = [],
						l = this.length;

					// We can't cloneNode fragments that contain checked, in WebKit
					if (!JQXLite.support.checkClone && l > 1 && typeof value === "string" && rchecked.test(value)) {
						return this.each(function () {
							JQXLite(this).domManip(args, table, callback);
						});
					}

					if (JQXLite.isFunction(value)) {
						return this.each(function (i) {
							var self = JQXLite(this);
							args[0] = value.call(this, i, table ? self.html() : undefined);
							self.domManip(args, table, callback);
						});
					}

					if (this[0]) {
						results = JQXLite.buildFragment(args, this, scripts);
						fragment = results.fragment;
						first = fragment.firstChild;

						if (fragment.childNodes.length === 1) {
							fragment = first;
						}

						if (first) {
							table = table && JQXLite.nodeName(first, "tr");

							// Use the original fragment for the last item instead of the first because it can end up
							// being emptied incorrectly in certain situations (#8070).
							// Fragments from the fragment cache must always be cloned and never used in place.
							for (iNoClone = results.cacheable || l - 1; i < l; i++) {
								callback.call(
									table && JQXLite.nodeName(this[i], "table") ?
										findOrAppend(this[i], "tbody") :
										this[i],
									i === iNoClone ?
										fragment :
										JQXLite.clone(fragment, true, true)
								);
							}
						}

						// Fix #11809: Avoid leaking memory
						fragment = first = null;

						if (scripts.length) {
							JQXLite.each(scripts, function (i, elem) {
								if (elem.src) {
									if (JQXLite.ajax) {
										JQXLite.ajax({
											url: elem.src,
											type: "GET",
											dataType: "script",
											async: false,
											global: false,
											"throws": true
										});
									} else {
										JQXLite.error("no ajax");
									}
								} else {
									JQXLite.globalEval((elem.text || elem.textContent || elem.innerHTML || "").replace(rcleanScript, ""));
								}

								if (elem.parentNode) {
									elem.parentNode.removeChild(elem);
								}
							});
						}
					}

					return this;
				}
			});

			function findOrAppend(elem, tag) {
				return elem.getElementsByTagName(tag)[0] || elem.appendChild(elem.ownerDocument.createElement(tag));
			}

			function cloneCopyEvent(src, dest) {

				if (dest.nodeType !== 1 || !JQXLite.hasData(src)) {
					return;
				}

				var type, i, l,
					oldData = JQXLite._data(src),
					curData = JQXLite._data(dest, oldData),
					events = oldData.events;

				if (events) {
					delete curData.handle;
					curData.events = {};

					for (type in events) {
						for (i = 0, l = events[type].length; i < l; i++) {
							JQXLite.event.add(dest, type, events[type][i]);
						}
					}
				}

				// make the cloned public data object a copy from the original
				if (curData.data) {
					curData.data = JQXLite.extend({}, curData.data);
				}
			}

			function cloneFixAttributes(src, dest) {
				var nodeName;

				// We do not need to do anything for non-Elements
				if (dest.nodeType !== 1) {
					return;
				}

				// clearAttributes removes the attributes, which we don't want,
				// but also removes the attachEvent events, which we *do* want
				if (dest.clearAttributes) {
					dest.clearAttributes();
				}

				// mergeAttributes, in contrast, only merges back on the
				// original attributes, not the events
				if (dest.mergeAttributes) {
					dest.mergeAttributes(src);
				}

				nodeName = dest.nodeName.toLowerCase();

				if (nodeName === "object") {
					// IE6-10 improperly clones children of object elements using classid.
					// IE10 throws NoModificationAllowedError if parent is null, #12132.
					if (dest.parentNode) {
						dest.outerHTML = src.outerHTML;
					}

					// This path appears unavoidable for IE9. When cloning an object
					// element in IE9, the outerHTML strategy above is not sufficient.
					// If the src has innerHTML and the destination does not,
					// copy the src.innerHTML into the dest.innerHTML. #10324
					if (JQXLite.support.html5Clone && (src.innerHTML && !JQXLite.trim(dest.innerHTML))) {
						dest.innerHTML = src.innerHTML;
					}

				} else if (nodeName === "input" && rcheckableType.test(src.type)) {
					// IE6-8 fails to persist the checked state of a cloned checkbox
					// or radio button. Worse, IE6-7 fail to give the cloned element
					// a checked appearance if the defaultChecked value isn't also set

					dest.defaultChecked = dest.checked = src.checked;

					// IE6-7 get confused and end up setting the value of a cloned
					// checkbox/radio button to an empty string instead of "on"
					if (dest.value !== src.value) {
						dest.value = src.value;
					}

					// IE6-8 fails to return the selected option to the default selected
					// state when cloning options
				} else if (nodeName === "option") {
					dest.selected = src.defaultSelected;

					// IE6-8 fails to set the defaultValue to the correct value when
					// cloning other types of input fields
				} else if (nodeName === "input" || nodeName === "textarea") {
					dest.defaultValue = src.defaultValue;

					// IE blanks contents when cloning scripts
				} else if (nodeName === "script" && dest.text !== src.text) {
					dest.text = src.text;
				}

				// Event data gets referenced instead of copied if the expando
				// gets copied too
				dest.removeAttribute(JQXLite.expando);
			}

			JQXLite.buildFragment = function (args, context, scripts) {
				var fragment, cacheable, cachehit,
					first = args[0];

				// Set context from what may come in as undefined or a JQXLite collection or a node
				// Updated to fix #12266 where accessing context[0] could throw an exception in IE9/10 &
				// also doubles as fix for #8950 where plain objects caused createDocumentFragment exception
				context = context || document;
				context = !context.nodeType && context[0] || context;
				context = context.ownerDocument || context;

				// Only cache "small" (1/2 KB) HTML strings that are associated with the main document
				// Cloning options loses the selected state, so don't cache them
				// IE 6 doesn't like it when you put <object> or <embed> elements in a fragment
				// Also, WebKit does not clone 'checked' attributes on cloneNode, so don't cache
				// Lastly, IE6,7,8 will not correctly reuse cached fragments that were created from unknown elems #10501
				if (args.length === 1 && typeof first === "string" && first.length < 512 && context === document &&
					first.charAt(0) === "<" && !rnocache.test(first) &&
					(JQXLite.support.checkClone || !rchecked.test(first)) &&
					(JQXLite.support.html5Clone || !rnoshimcache.test(first))) {

					// Mark cacheable and look for a hit
					cacheable = true;
					fragment = JQXLite.fragments[first];
					cachehit = fragment !== undefined;
				}

				if (!fragment) {
					fragment = context.createDocumentFragment();
					JQXLite.clean(args, context, fragment, scripts);

					// Update the cache, but only store false
					// unless this is a second parsing of the same content
					if (cacheable) {
						JQXLite.fragments[first] = cachehit && fragment;
					}
				}

				return { fragment: fragment, cacheable: cacheable };
			};

			JQXLite.fragments = {};

			JQXLite.each({
				appendTo: "append",
				prependTo: "prepend",
				insertBefore: "before",
				insertAfter: "after",
				replaceAll: "replaceWith"
			}, function (name, original) {
				JQXLite.fn[name] = function (selector) {
					var elems,
						i = 0,
						ret = [],
						insert = JQXLite(selector),
						l = insert.length,
						parent = this.length === 1 && this[0].parentNode;

					if ((parent == null || parent && parent.nodeType === 11 && parent.childNodes.length === 1) && l === 1) {
						insert[original](this[0]);
						return this;
					} else {
						for (; i < l; i++) {
							elems = (i > 0 ? this.clone(true) : this).get();
							JQXLite(insert[i])[original](elems);
							ret = ret.concat(elems);
						}

						return this.pushStack(ret, name, insert.selector);
					}
				};
			});

			function getAll(elem) {
				if (typeof elem.getElementsByTagName !== "undefined") {
					return elem.getElementsByTagName("*");

				} else if (typeof elem.querySelectorAll !== "undefined") {
					return elem.querySelectorAll("*");

				} else {
					return [];
				}
			}

			// Used in clean, fixes the defaultChecked property
			function fixDefaultChecked(elem) {
				if (rcheckableType.test(elem.type)) {
					elem.defaultChecked = elem.checked;
				}
			}

			JQXLite.extend({
				clone: function (elem, dataAndEvents, deepDataAndEvents) {
					var srcElements,
						destElements,
						i,
						clone;

					if (JQXLite.support.html5Clone || JQXLite.isXMLDoc(elem) || !rnoshimcache.test("<" + elem.nodeName + ">")) {
						clone = elem.cloneNode(true);

						// IE<=8 does not properly clone detached, unknown element nodes
					} else {
						fragmentDiv.innerHTML = elem.outerHTML;
						fragmentDiv.removeChild(clone = fragmentDiv.firstChild);
					}

					if ((!JQXLite.support.noCloneEvent || !JQXLite.support.noCloneChecked) &&
						(elem.nodeType === 1 || elem.nodeType === 11) && !JQXLite.isXMLDoc(elem)) {
						// IE copies events bound via attachEvent when using cloneNode.
						// Calling detachEvent on the clone will also remove the events
						// from the original. In order to get around this, we use some
						// proprietary methods to clear the events. Thanks to MooTools
						// guys for this hotness.

						cloneFixAttributes(elem, clone);

						// Using Sizzle here is crazy slow, so we use getElementsByTagName instead
						srcElements = getAll(elem);
						destElements = getAll(clone);

						// Weird iteration because IE will replace the length property
						// with an element if you are cloning the body and one of the
						// elements on the page has a name or id of "length"
						for (i = 0; srcElements[i]; ++i) {
							// Ensure that the destination node is not null; Fixes #9587
							if (destElements[i]) {
								cloneFixAttributes(srcElements[i], destElements[i]);
							}
						}
					}

					// Copy the events from the original to the clone
					if (dataAndEvents) {
						cloneCopyEvent(elem, clone);

						if (deepDataAndEvents) {
							srcElements = getAll(elem);
							destElements = getAll(clone);

							for (i = 0; srcElements[i]; ++i) {
								cloneCopyEvent(srcElements[i], destElements[i]);
							}
						}
					}

					srcElements = destElements = null;

					// Return the cloned set
					return clone;
				},

				clean: function (elems, context, fragment, scripts) {
					var i, j, elem, tag, wrap, depth, div, hasBody, tbody, len, handleScript, jsTags,
						safe = context === document && safeFragment,
						ret = [];

					// Ensure that context is a document
					if (!context || typeof context.createDocumentFragment === "undefined") {
						context = document;
					}

					// Use the already-created safe fragment if context permits
					for (i = 0; (elem = elems[i]) != null; i++) {
						if (typeof elem === "number") {
							elem += "";
						}

						if (!elem) {
							continue;
						}

						// Convert html string into DOM nodes
						if (typeof elem === "string") {
							if (!rhtml.test(elem)) {
								elem = context.createTextNode(elem);
							} else {
								// Ensure a safe container in which to render the html
								safe = safe || createSafeFragment(context);
								div = context.createElement("div");
								safe.appendChild(div);

								// Fix "XHTML"-style tags in all browsers
								elem = elem.replace(rxhtmlTag, "<$1></$2>");

								// Go to html and back, then peel off extra wrappers
								tag = (rtagName.exec(elem) || ["", ""])[1].toLowerCase();
								wrap = wrapMap[tag] || wrapMap._default;
								depth = wrap[0];
								div.innerHTML = wrap[1] + elem + wrap[2];

								// Move to the right depth
								while (depth--) {
									div = div.lastChild;
								}

								// Remove IE's autoinserted <tbody> from table fragments
								if (!JQXLite.support.tbody) {

									// String was a <table>, *may* have spurious <tbody>
									hasBody = rtbody.test(elem);
									tbody = tag === "table" && !hasBody ?
										div.firstChild && div.firstChild.childNodes :

										// String was a bare <thead> or <tfoot>
										wrap[1] === "<table>" && !hasBody ?
											div.childNodes :
											[];

									for (j = tbody.length - 1; j >= 0; --j) {
										if (JQXLite.nodeName(tbody[j], "tbody") && !tbody[j].childNodes.length) {
											tbody[j].parentNode.removeChild(tbody[j]);
										}
									}
								}

								// IE completely kills leading whitespace when innerHTML is used
								if (!JQXLite.support.leadingWhitespace && rleadingWhitespace.test(elem)) {
									div.insertBefore(context.createTextNode(rleadingWhitespace.exec(elem)[0]), div.firstChild);
								}

								elem = div.childNodes;

								// Take out of fragment container (we need a fresh div each time)
								div.parentNode.removeChild(div);
							}
						}

						if (elem.nodeType) {
							ret.push(elem);
						} else {
							JQXLite.merge(ret, elem);
						}
					}

					// Fix #11356: Clear elements from safeFragment
					if (div) {
						elem = div = safe = null;
					}

					// Reset defaultChecked for any radios and checkboxes
					// about to be appended to the DOM in IE 6/7 (#8060)
					if (!JQXLite.support.appendChecked) {
						for (i = 0; (elem = ret[i]) != null; i++) {
							if (JQXLite.nodeName(elem, "input")) {
								fixDefaultChecked(elem);
							} else if (typeof elem.getElementsByTagName !== "undefined") {
								JQXLite.grep(elem.getElementsByTagName("input"), fixDefaultChecked);
							}
						}
					}

					// Append elements to a provided document fragment
					if (fragment) {
						// Special handling of each script element
						handleScript = function (elem) {
							// Check if we consider it executable
							if (!elem.type || rscriptType.test(elem.type)) {
								// Detach the script and store it in the scripts array (if provided) or the fragment
								// Return truthy to indicate that it has been handled
								return scripts ?
									scripts.push(elem.parentNode ? elem.parentNode.removeChild(elem) : elem) :
									fragment.appendChild(elem);
							}
						};

						for (i = 0; (elem = ret[i]) != null; i++) {
							// Check if we're done after handling an executable script
							if (!(JQXLite.nodeName(elem, "script") && handleScript(elem))) {
								// Append to fragment and handle embedded scripts
								fragment.appendChild(elem);
								if (typeof elem.getElementsByTagName !== "undefined") {
									// handleScript alters the DOM, so use JQXLite.merge to ensure snapshot iteration
									jsTags = JQXLite.grep(JQXLite.merge([], elem.getElementsByTagName("script")), handleScript);

									// Splice the scripts into ret after their former ancestor and advance our index beyond them
									ret.splice.apply(ret, [i + 1, 0].concat(jsTags));
									i += jsTags.length;
								}
							}
						}
					}

					return ret;
				},

				cleanData: function (elems, /* internal */ acceptData) {
					var data, id, elem, type,
						i = 0,
						internalKey = JQXLite.expando,
						cache = JQXLite.cache,
						deleteExpando = JQXLite.support.deleteExpando,
						special = JQXLite.event.special;

					for (; (elem = elems[i]) != null; i++) {

						if (acceptData || JQXLite.acceptData(elem)) {

							id = elem[internalKey];
							data = id && cache[id];

							if (data) {
								if (data.events) {
									for (type in data.events) {
										if (special[type]) {
											JQXLite.event.remove(elem, type);

											// This is a shortcut to avoid JQXLite.event.remove's overhead
										} else {
											JQXLite.removeEvent(elem, type, data.handle);
										}
									}
								}

								// Remove cache only if it was not already removed by JQXLite.event.remove
								if (cache[id]) {

									delete cache[id];

									// IE does not allow us to delete expando properties from nodes,
									// nor does it have a removeAttribute function on Document nodes;
									// we must handle all of these cases
									if (deleteExpando) {
										delete elem[internalKey];

									} else if (elem.removeAttribute) {
										elem.removeAttribute(internalKey);

									} else {
										elem[internalKey] = null;
									}

									JQXLite.deletedIds.push(id);
								}
							}
						}
					}
				}
			});
			// Limit scope pollution from any deprecated API
			(function () {

				var matched, browser;

				// Use of JQXLite.browser is frowned upon.
				// More details: http://api.jqx.com/JQXLite.browser
				// JQXLite.uaMatch maintained for back-compat
				JQXLite.uaMatch = function (ua) {
					ua = ua.toLowerCase();

					var match = /(chrome)[ \/]([\w.]+)/.exec(ua) ||
						/(webkit)[ \/]([\w.]+)/.exec(ua) ||
						/(opera)(?:.*version|)[ \/]([\w.]+)/.exec(ua) ||
						/(msie) ([\w.]+)/.exec(ua) ||
						ua.indexOf("compatible") < 0 && /(mozilla)(?:.*? rv:([\w.]+)|)/.exec(ua) ||
						[];

					return {
						browser: match[1] || "",
						version: match[2] || "0"
					};
				};

				matched = JQXLite.uaMatch(navigator.userAgent);
				browser = {};

				if (matched.browser) {
					browser[matched.browser] = true;
					browser.version = matched.version;
				}

				// Chrome is Webkit, but Webkit is also Safari.
				if (browser.chrome) {
					browser.webkit = true;
				} else if (browser.webkit) {
					browser.safari = true;
				}

				JQXLite.browser = browser;

				JQXLite.sub = function () {
					function jQuerySub(selector, context) {
						return new jQuerySub.fn.init(selector, context);
					}
					JQXLite.extend(true, jQuerySub, this);
					jQuerySub.superclass = this;
					jQuerySub.fn = jQuerySub.prototype = this();
					jQuerySub.fn.constructor = jQuerySub;
					jQuerySub.sub = this.sub;
					jQuerySub.fn.init = function init(selector, context) {
						if (context && context instanceof JQXLite && !(context instanceof jQuerySub)) {
							context = jQuerySub(context);
						}

						return JQXLite.fn.init.call(this, selector, context, rootJQXLiteSub);
					};
					jQuerySub.fn.init.prototype = jQuerySub.fn;
					var rootJQXLiteSub = jQuerySub(document);
					return jQuerySub;
				};

			})();
			var curCSS, iframe, iframeDoc,
				ralpha = /alpha\([^)]*\)/i,
				ropacity = /opacity=([^)]*)/,
				rposition = /^(top|right|bottom|left)$/,
				// swappable if display is none or starts with table except "table", "table-cell", or "table-caption"
				// see here for display values: https://developer.mozilla.org/en-US/docs/CSS/display
				rdisplayswap = /^(none|table(?!-c[ea]).+)/,
				rmargin = /^margin/,
				rnumsplit = new RegExp("^(" + core_pnum + ")(.*)$", "i"),
				rnumnonpx = new RegExp("^(" + core_pnum + ")(?!px)[a-z%]+$", "i"),
				rrelNum = new RegExp("^([-+])=(" + core_pnum + ")", "i"),
				elemdisplay = { BODY: "block" },

				cssShow = { position: "absolute", visibility: "hidden", display: "block" },
				cssNormalTransform = {
					letterSpacing: 0,
					fontWeight: 400
				},

				cssExpand = ["Top", "Right", "Bottom", "Left"],
				cssPrefixes = ["Webkit", "O", "Moz", "ms"],

				eventsToggle = JQXLite.fn.toggle;

			// return a css property mapped to a potentially vendor prefixed property
			function vendorPropName(style, name) {

				// shortcut for names that are not vendor prefixed
				if (name in style) {
					return name;
				}

				// check for vendor prefixed names
				var capName = name.charAt(0).toUpperCase() + name.slice(1),
					origName = name,
					i = cssPrefixes.length;

				while (i--) {
					name = cssPrefixes[i] + capName;
					if (name in style) {
						return name;
					}
				}

				return origName;
			}

			function isHidden(elem, el) {
				elem = el || elem;
				return JQXLite.css(elem, "display") === "none" || !JQXLite.contains(elem.ownerDocument, elem);
			}

			function showHide(elements, show) {
				var elem, display,
					values = [],
					index = 0,
					length = elements.length;

				for (; index < length; index++) {
					elem = elements[index];
					if (!elem.style) {
						continue;
					}
					values[index] = JQXLite._data(elem, "olddisplay");
					if (show) {
						// Reset the inline display of this element to learn if it is
						// being hidden by cascaded rules or not
						if (!values[index] && elem.style.display === "none") {
							elem.style.display = "";
						}

						// Set elements which have been overridden with display: none
						// in a stylesheet to whatever the default browser style is
						// for such an element
						if (elem.style.display === "" && isHidden(elem)) {
							values[index] = JQXLite._data(elem, "olddisplay", css_defaultDisplay(elem.nodeName));
						}
					} else {
						display = curCSS(elem, "display");

						if (!values[index] && display !== "none") {
							JQXLite._data(elem, "olddisplay", display);
						}
					}
				}

				// Set the display of most of the elements in a second loop
				// to avoid the constant reflow
				for (index = 0; index < length; index++) {
					elem = elements[index];
					if (!elem.style) {
						continue;
					}
					if (!show || elem.style.display === "none" || elem.style.display === "") {
						elem.style.display = show ? values[index] || "" : "none";
					}
				}

				return elements;
			}

			JQXLite.fn.extend({
				css: function (name, value) {
					return JQXLite.access(this, function (elem, name, value) {
						return value !== undefined ?
							JQXLite.style(elem, name, value) :
							JQXLite.css(elem, name);
					}, name, value, arguments.length > 1);
				},
				show: function () {
					return showHide(this, true);
				},
				hide: function () {
					return showHide(this);
				},
				toggle: function (state, fn2) {
					var bool = typeof state === "boolean";

					if (JQXLite.isFunction(state) && JQXLite.isFunction(fn2)) {
						return eventsToggle.apply(this, arguments);
					}

					return this.each(function () {
						if (bool ? state : isHidden(this)) {
							JQXLite(this).show();
						} else {
							JQXLite(this).hide();
						}
					});
				}
			});

			JQXLite.extend({
				// Add in style property hooks for overriding the default
				// behavior of getting and setting a style property
				cssHooks: {
					opacity: {
						get: function (elem, computed) {
							if (computed) {
								// We should always get a number back from opacity
								var ret = curCSS(elem, "opacity");
								return ret === "" ? "1" : ret;

							}
						}
					}
				},

				// Exclude the following css properties to add px
				cssNumber: {
					"fillOpacity": true,
					"fontWeight": true,
					"lineHeight": true,
					"opacity": true,
					"orphans": true,
					"widows": true,
					"zIndex": true,
					"zoom": true
				},

				// Add in properties whose names you wish to fix before
				// setting or getting the value
				cssProps: {
					// normalize float css property
					"float": JQXLite.support.cssFloat ? "cssFloat" : "styleFloat"
				},

				// Get and set the style property on a DOM Node
				style: function (elem, name, value, extra) {
					// Don't set styles on text and comment nodes
					if (!elem || elem.nodeType === 3 || elem.nodeType === 8 || !elem.style) {
						return;
					}

					// Make sure that we're working with the right name
					var ret, type, hooks,
						origName = JQXLite.camelCase(name),
						style = elem.style;

					name = JQXLite.cssProps[origName] || (JQXLite.cssProps[origName] = vendorPropName(style, origName));

					// gets hook for the prefixed version
					// followed by the unprefixed version
					hooks = JQXLite.cssHooks[name] || JQXLite.cssHooks[origName];

					// Check if we're setting a value
					if (value !== undefined) {
						type = typeof value;

						// convert relative number strings (+= or -=) to relative numbers. #7345
						if (type === "string" && (ret = rrelNum.exec(value))) {
							value = (ret[1] + 1) * ret[2] + parseFloat(JQXLite.css(elem, name));
							// Fixes bug #9237
							type = "number";
						}

						// Make sure that NaN and null values aren't set. See: #7116
						if (value == null || type === "number" && isNaN(value)) {
							return;
						}

						// If a number was passed in, add 'px' to the (except for certain CSS properties)
						if (type === "number" && !JQXLite.cssNumber[origName]) {
							value += "px";
						}

						// If a hook was provided, use that value, otherwise just set the specified value
						if (!hooks || !("set" in hooks) || (value = hooks.set(elem, value, extra)) !== undefined) {
							// Wrapped to prevent IE from throwing errors when 'invalid' values are provided
							// Fixes bug #5509
							try {
								style[name] = value;
							} catch (e) { }
						}

					} else {
						// If a hook was provided get the non-computed value from there
						if (hooks && "get" in hooks && (ret = hooks.get(elem, false, extra)) !== undefined) {
							return ret;
						}

						// Otherwise just get the value from the style object
						return style[name];
					}
				},

				css: function (elem, name, numeric, extra) {
					var val, num, hooks,
						origName = JQXLite.camelCase(name);

					// Make sure that we're working with the right name
					name = JQXLite.cssProps[origName] || (JQXLite.cssProps[origName] = vendorPropName(elem.style, origName));

					// gets hook for the prefixed version
					// followed by the unprefixed version
					hooks = JQXLite.cssHooks[name] || JQXLite.cssHooks[origName];

					// If a hook was provided get the computed value from there
					if (hooks && "get" in hooks) {
						val = hooks.get(elem, true, extra);
					}

					// Otherwise, if a way to get the computed value exists, use that
					if (val === undefined) {
						val = curCSS(elem, name);
					}

					//convert "normal" to computed value
					if (val === "normal" && name in cssNormalTransform) {
						val = cssNormalTransform[name];
					}

					// Return, converting to number if forced or a qualifier was provided and val looks numeric
					if (numeric || extra !== undefined) {
						num = parseFloat(val);
						return numeric || JQXLite.isNumeric(num) ? num || 0 : val;
					}
					return val;
				},

				// A method for quickly swapping in/out CSS properties to get correct calculations
				swap: function (elem, options, callback) {
					var ret, name,
						old = {};

					// Remember the old values, and insert the new ones
					for (name in options) {
						old[name] = elem.style[name];
						elem.style[name] = options[name];
					}

					ret = callback.call(elem);

					// Revert the old values
					for (name in options) {
						elem.style[name] = old[name];
					}

					return ret;
				}
			});

			// NOTE: To any future maintainer, we've window.getComputedStyle
			// because jsdom on node.js will break without it.
			if (window.getComputedStyle) {
				curCSS = function (elem, name) {
					var ret, width, minWidth, maxWidth,
						computed = window.getComputedStyle(elem, null),
						style = elem.style;

					if (computed) {

						// getPropertyValue is only needed for .css('filter') in IE9, see #12537
						ret = computed.getPropertyValue(name) || computed[name];

						if (ret === "" && !JQXLite.contains(elem.ownerDocument, elem)) {
							ret = JQXLite.style(elem, name);
						}

						// A tribute to the "awesome hack by Dean Edwards"
						// Chrome < 17 and Safari 5.0 uses "computed value" instead of "used value" for margin-right
						// Safari 5.1.7 (at least) returns percentage for a larger set of values, but width seems to be reliably pixels
						// this is against the CSSOM draft spec: http://dev.w3.org/csswg/cssom/#resolved-values
						if (rnumnonpx.test(ret) && rmargin.test(name)) {
							width = style.width;
							minWidth = style.minWidth;
							maxWidth = style.maxWidth;

							style.minWidth = style.maxWidth = style.width = ret;
							ret = computed.width;

							style.width = width;
							style.minWidth = minWidth;
							style.maxWidth = maxWidth;
						}
					}

					return ret;
				};
			} else if (document.documentElement.currentStyle) {
				curCSS = function (elem, name) {
					var left, rsLeft,
						ret = elem.currentStyle && elem.currentStyle[name],
						style = elem.style;

					// Avoid setting ret to empty string here
					// so we don't default to auto
					if (ret == null && style && style[name]) {
						ret = style[name];
					}

					// From the awesome hack by Dean Edwards
					// http://erik.eae.net/archives/2007/07/27/18.54.15/#comment-102291

					// If we're not dealing with a regular pixel number
					// but a number that has a weird ending, we need to convert it to pixels
					// but not position css attributes, as those are proportional to the parent element instead
					// and we can't measure the parent instead because it might trigger a "stacking dolls" problem
					if (rnumnonpx.test(ret) && !rposition.test(name)) {

						// Remember the original values
						left = style.left;
						rsLeft = elem.runtimeStyle && elem.runtimeStyle.left;

						// Put in the new values to get a computed value out
						if (rsLeft) {
							elem.runtimeStyle.left = elem.currentStyle.left;
						}
						style.left = name === "fontSize" ? "1em" : ret;
						ret = style.pixelLeft + "px";

						// Revert the changed values
						style.left = left;
						if (rsLeft) {
							elem.runtimeStyle.left = rsLeft;
						}
					}

					return ret === "" ? "auto" : ret;
				};
			}

			function setPositiveNumber(elem, value, subtract) {
				var matches = rnumsplit.exec(value);
				return matches ?
					Math.max(0, matches[1] - (subtract || 0)) + (matches[2] || "px") :
					value;
			}

			function augmentWidthOrHeight(elem, name, extra, isBorderBox) {
				var i = extra === (isBorderBox ? "border" : "content") ?
					// If we already have the right measurement, avoid augmentation
					4 :
					// Otherwise initialize for horizontal or vertical properties
					name === "width" ? 1 : 0,

					val = 0;

				for (; i < 4; i += 2) {
					// both box models exclude margin, so add it if we want it
					if (extra === "margin") {
						// we use JQXLite.css instead of curCSS here
						// because of the reliableMarginRight CSS hook!
						val += JQXLite.css(elem, extra + cssExpand[i], true);
					}

					// From this point on we use curCSS for maximum performance (relevant in animations)
					if (isBorderBox) {
						// border-box includes padding, so remove it if we want content
						if (extra === "content") {
							val -= parseFloat(curCSS(elem, "padding" + cssExpand[i])) || 0;
						}

						// at this point, extra isn't border nor margin, so remove border
						if (extra !== "margin") {
							val -= parseFloat(curCSS(elem, "border" + cssExpand[i] + "Width")) || 0;
						}
					} else {
						// at this point, extra isn't content, so add padding
						val += parseFloat(curCSS(elem, "padding" + cssExpand[i])) || 0;

						// at this point, extra isn't content nor padding, so add border
						if (extra !== "padding") {
							val += parseFloat(curCSS(elem, "border" + cssExpand[i] + "Width")) || 0;
						}
					}
				}

				return val;
			}

			function getWidthOrHeight(elem, name, extra) {

				// Start with offset property, which is equivalent to the border-box value
				var val = name === "width" ? elem.offsetWidth : elem.offsetHeight,
					valueIsBorderBox = true,
					isBorderBox = JQXLite.support.boxSizing && JQXLite.css(elem, "boxSizing") === "border-box";

				// some non-html elements return undefined for offsetWidth, so check for null/undefined
				// svg - https://bugzilla.mozilla.org/show_bug.cgi?id=649285
				// MathML - https://bugzilla.mozilla.org/show_bug.cgi?id=491668
				if (val <= 0 || val == null) {
					// Fall back to computed then uncomputed css if necessary
					val = curCSS(elem, name);
					if (val < 0 || val == null) {
						val = elem.style[name];
					}

					// Computed unit is not pixels. Stop here and return.
					if (rnumnonpx.test(val)) {
						return val;
					}

					// we need the check for style in case a browser which returns unreliable values
					// for getComputedStyle silently falls back to the reliable elem.style
					valueIsBorderBox = isBorderBox && (JQXLite.support.boxSizingReliable || val === elem.style[name]);

					// Normalize "", auto, and prepare for extra
					val = parseFloat(val) || 0;
				}

				// use the active box-sizing model to add/subtract irrelevant styles
				return (val +
					augmentWidthOrHeight(
						elem,
						name,
						extra || (isBorderBox ? "border" : "content"),
						valueIsBorderBox
					)
				) + "px";
			}


			// Try to determine the default display value of an element
			function css_defaultDisplay(nodeName) {
				if (elemdisplay[nodeName]) {
					return elemdisplay[nodeName];
				}

				var elem = JQXLite("<" + nodeName + ">").appendTo(document.body),
					display = elem.css("display");
				elem.remove();

				// If the simple way fails,
				// get element's real default display by attaching it to a temp iframe
				if (display === "none" || display === "") {
					// Use the already-created iframe if possible
					iframe = document.body.appendChild(
						iframe || JQXLite.extend(document.createElement("iframe"), {
							frameBorder: 0,
							width: 0,
							height: 0
						})
					);

					// Create a cacheable copy of the iframe document on first call.
					// IE and Opera will allow us to reuse the iframeDoc without re-writing the fake HTML
					// document to it; WebKit & Firefox won't allow reusing the iframe document.
					if (!iframeDoc || !iframe.createElement) {
						iframeDoc = (iframe.contentWindow || iframe.contentDocument).document;
						iframeDoc.write("<!doctype html><html><body>");
						iframeDoc.close();
					}

					elem = iframeDoc.body.appendChild(iframeDoc.createElement(nodeName));

					display = curCSS(elem, "display");
					document.body.removeChild(iframe);
				}

				// Store the correct default display
				elemdisplay[nodeName] = display;

				return display;
			}

			JQXLite.each(["height", "width"], function (i, name) {
				JQXLite.cssHooks[name] = {
					get: function (elem, computed, extra) {
						if (computed) {
							// certain elements can have dimension info if we invisibly show them
							// however, it must have a current display style that would benefit from this
							if (elem.offsetWidth === 0 && rdisplayswap.test(curCSS(elem, "display"))) {
								return JQXLite.swap(elem, cssShow, function () {
									return getWidthOrHeight(elem, name, extra);
								});
							} else {
								return getWidthOrHeight(elem, name, extra);
							}
						}
					},

					set: function (elem, value, extra) {
						return setPositiveNumber(elem, value, extra ?
							augmentWidthOrHeight(
								elem,
								name,
								extra,
								JQXLite.support.boxSizing && JQXLite.css(elem, "boxSizing") === "border-box"
							) : 0
						);
					}
				};
			});

			if (!JQXLite.support.opacity) {
				JQXLite.cssHooks.opacity = {
					get: function (elem, computed) {
						// IE uses filters for opacity
						return ropacity.test((computed && elem.currentStyle ? elem.currentStyle.filter : elem.style.filter) || "") ?
							(0.01 * parseFloat(RegExp.$1)) + "" :
							computed ? "1" : "";
					},

					set: function (elem, value) {
						var style = elem.style,
							currentStyle = elem.currentStyle,
							opacity = JQXLite.isNumeric(value) ? "alpha(opacity=" + value * 100 + ")" : "",
							filter = currentStyle && currentStyle.filter || style.filter || "";

						// IE has trouble with opacity if it does not have layout
						// Force it by setting the zoom level
						style.zoom = 1;

						// if setting opacity to 1, and no other filters exist - attempt to remove filter attribute #6652
						if (value >= 1 && JQXLite.trim(filter.replace(ralpha, "")) === "" &&
							style.removeAttribute) {

							// Setting style.filter to null, "" & " " still leave "filter:" in the cssText
							// if "filter:" is present at all, clearType is disabled, we want to avoid this
							// style.removeAttribute is IE Only, but so apparently is this code path...
							style.removeAttribute("filter");

							// if there there is no filter style applied in a css rule, we are done
							if (currentStyle && !currentStyle.filter) {
								return;
							}
						}

						// otherwise, set new filter values
						style.filter = ralpha.test(filter) ?
							filter.replace(ralpha, opacity) :
							filter + " " + opacity;
					}
				};
			}

			// These hooks cannot be added until DOM ready because the support test
			// for it is not run until after DOM ready
			JQXLite(function () {
				if (!JQXLite.support.reliableMarginRight) {
					JQXLite.cssHooks.marginRight = {
						get: function (elem, computed) {
							// WebKit Bug 13343 - getComputedStyle returns wrong value for margin-right
							// Work around by temporarily setting element display to inline-block
							return JQXLite.swap(elem, { "display": "inline-block" }, function () {
								if (computed) {
									return curCSS(elem, "marginRight");
								}
							});
						}
					};
				}

				// Webkit bug: https://bugs.webkit.org/show_bug.cgi?id=29084
				// getComputedStyle returns percent when specified for top/left/bottom/right
				// rather than make the css module depend on the offset module, we just check for it here
				if (!JQXLite.support.pixelPosition && JQXLite.fn.position) {
					JQXLite.each(["top", "left"], function (i, prop) {
						JQXLite.cssHooks[prop] = {
							get: function (elem, computed) {
								if (computed) {
									var ret = curCSS(elem, prop);
									// if curCSS returns percentage, fallback to offset
									return rnumnonpx.test(ret) ? JQXLite(elem).position()[prop] + "px" : ret;
								}
							}
						};
					});
				}

			});

			if (JQXLite.expr && JQXLite.expr.filters) {
				JQXLite.expr.filters.hidden = function (elem) {
					return (elem.offsetWidth === 0 && elem.offsetHeight === 0) || (!JQXLite.support.reliableHiddenOffsets && ((elem.style && elem.style.display) || curCSS(elem, "display")) === "none");
				};

				JQXLite.expr.filters.visible = function (elem) {
					return !JQXLite.expr.filters.hidden(elem);
				};
			}

			// These hooks are used by animate to expand properties
			JQXLite.each({
				margin: "",
				padding: "",
				border: "Width"
			}, function (prefix, suffix) {
				JQXLite.cssHooks[prefix + suffix] = {
					expand: function (value) {
						var i,

							// assumes a single number if not a string
							parts = typeof value === "string" ? value.split(" ") : [value],
							expanded = {};

						for (i = 0; i < 4; i++) {
							expanded[prefix + cssExpand[i] + suffix] =
								parts[i] || parts[i - 2] || parts[0];
						}

						return expanded;
					}
				};

				if (!rmargin.test(prefix)) {
					JQXLite.cssHooks[prefix + suffix].set = setPositiveNumber;
				}
			});
			var r20 = /%20/g,
				rbracket = /\[\]$/,
				rCRLF = /\r?\n/g,
				rinput = /^(?:color|date|datetime|datetime-local|email|hidden|month|number|password|range|search|tel|text|time|url|week)$/i,
				rselectTextarea = /^(?:select|textarea)/i;

			JQXLite.fn.extend({
				serialize: function () {
					return JQXLite.param(this.serializeArray());
				},
				serializeArray: function () {
					return this.map(function () {
						return this.elements ? JQXLite.makeArray(this.elements) : this;
					})
						.filter(function () {
							return this.name && !this.disabled &&
								(this.checked || rselectTextarea.test(this.nodeName) ||
									rinput.test(this.type));
						})
						.map(function (i, elem) {
							var val = JQXLite(this).val();

							return val == null ?
								null :
								JQXLite.isArray(val) ?
									JQXLite.map(val, function (val, i) {
										return { name: elem.name, value: val.replace(rCRLF, "\r\n") };
									}) :
									{ name: elem.name, value: val.replace(rCRLF, "\r\n") };
						}).get();
				}
			});

			//Serialize an array of form elements or a set of
			//key/values into a query string
			JQXLite.param = function (a, traditional) {
				var prefix,
					s = [],
					add = function (key, value) {
						// If value is a function, invoke it and return its value
						value = JQXLite.isFunction(value) ? value() : (value == null ? "" : value);
						s[s.length] = encodeURIComponent(key) + "=" + encodeURIComponent(value);
					};

				// Set traditional to true for JQXLite <= 1.3.2 behavior.
				if (traditional === undefined) {
					traditional = JQXLite.ajaxSettings && JQXLite.ajaxSettings.traditional;
				}

				// If an array was passed in, assume that it is an array of form elements.
				if (JQXLite.isArray(a) || (a.jqx && !JQXLite.isPlainObject(a))) {
					// Serialize the form elements
					JQXLite.each(a, function () {
						add(this.name, this.value);
					});

				} else {
					// If traditional, encode the "old" way (the way 1.3.2 or older
					// did it), otherwise encode params recursively.
					for (prefix in a) {
						buildParams(prefix, a[prefix], traditional, add);
					}
				}

				// Return the resulting serialization
				return s.join("&").replace(r20, "+");
			};

			function buildParams(prefix, obj, traditional, add) {
				var name;

				if (JQXLite.isArray(obj)) {
					// Serialize array item.
					JQXLite.each(obj, function (i, v) {
						if (traditional || rbracket.test(prefix)) {
							// Treat each array item as a scalar.
							add(prefix, v);

						} else {
							// If array item is non-scalar (array or object), encode its
							// numeric index to resolve deserialization ambiguity issues.
							// Note that rack (as of 1.0.0) can't currently deserialize
							// nested arrays properly, and attempting to do so may cause
							// a server error. Possible fixes are to modify rack's
							// deserialization algorithm or to provide an option or flag
							// to force array serialization to be shallow.
							buildParams(prefix + "[" + (typeof v === "object" ? i : "") + "]", v, traditional, add);
						}
					});

				} else if (!traditional && JQXLite.type(obj) === "object") {
					// Serialize object item.
					for (name in obj) {
						buildParams(prefix + "[" + name + "]", obj[name], traditional, add);
					}

				} else {
					// Serialize scalar item.
					add(prefix, obj);
				}
			}


			// Create transport if the browser can provide an xhr
			if (JQXLite.support.ajax) {

				JQXLite.ajaxTransport(function (s) {
					// Cross domain only allowed if supported through XMLHttpRequest
					if (!s.crossDomain || JQXLite.support.cors) {

						var callback;

						return {
							send: function (headers, complete) {

								// Get a new xhr
								var handle, i,
									xhr = s.xhr();

								// Open the socket
								// Passing null username, generates a login popup on Opera (#2865)
								if (s.username) {
									xhr.open(s.type, s.url, s.async, s.username, s.password);
								} else {
									xhr.open(s.type, s.url, s.async);
								}

								// Apply custom fields if provided
								if (s.xhrFields) {
									for (i in s.xhrFields) {
										xhr[i] = s.xhrFields[i];
									}
								}

								// Override mime type if needed
								if (s.mimeType && xhr.overrideMimeType) {
									xhr.overrideMimeType(s.mimeType);
								}

								// X-Requested-With header
								// For cross-domain requests, seeing as conditions for a preflight are
								// akin to a jigsaw puzzle, we simply never set it to be sure.
								// (it can always be set on a per-request basis or even using ajaxSetup)
								// For same-domain requests, won't change header if already provided.
								if (!s.crossDomain && !headers["X-Requested-With"]) {
									headers["X-Requested-With"] = "XMLHttpRequest";
								}

								// Need an extra try/catch for cross domain requests in Firefox 3
								try {
									for (i in headers) {
										xhr.setRequestHeader(i, headers[i]);
									}
								} catch (_) { }

								// Do send the request
								// This may raise an exception which is actually
								// handled in JQXLite.ajax (so no try/catch here)
								xhr.send((s.hasContent && s.data) || null);

								// Listener
								callback = function (_, isAbort) {

									var status,
										statusText,
										responseHeaders,
										responses,
										xml;

									// Firefox throws exceptions when accessing properties
									// of an xhr when a network error occurred
									// http://helpful.knobs-dials.com/index.php/Component_returned_failure_code:_0x80040111_(NS_ERROR_NOT_AVAILABLE)
									try {

										// Was never called and is aborted or complete
										if (callback && (isAbort || xhr.readyState === 4)) {

											// Only called once
											callback = undefined;

											// Do not keep as active anymore
											if (handle) {
												xhr.onreadystatechange = JQXLite.noop;
												if (xhrOnUnloadAbort) {
													delete xhrCallbacks[handle];
												}
											}

											// If it's an abort
											if (isAbort) {
												// Abort it manually if needed
												if (xhr.readyState !== 4) {
													xhr.abort();
												}
											} else {
												status = xhr.status;
												responseHeaders = xhr.getAllResponseHeaders();
												responses = {};
												xml = xhr.responseXML;

												// Construct response list
												if (xml && xml.documentElement /* #4958 */) {
													responses.xml = xml;
												}

												// When requesting binary data, IE6-9 will throw an exception
												// on any attempt to access responseText (#11426)
												try {
													responses.text = xhr.responseText;
												} catch (e) {
												}

												// Firefox throws an exception when accessing
												// statusText for faulty cross-domain requests
												try {
													statusText = xhr.statusText;
												} catch (e) {
													// We normalize with Webkit giving an empty statusText
													statusText = "";
												}

												// Filter status for non standard behaviors

												// If the request is local and we have data: assume a success
												// (success with no data won't get notified, that's the best we
												// can do given current implementations)
												if (!status && s.isLocal && !s.crossDomain) {
													status = responses.text ? 200 : 404;
													// IE - #1450: sometimes returns 1223 when it should be 204
												} else if (status === 1223) {
													status = 204;
												}
											}
										}
									} catch (firefoxAccessException) {
										if (!isAbort) {
											complete(-1, firefoxAccessException);
										}
									}

									// Call complete if needed
									if (responses) {
										complete(status, statusText, responses, responseHeaders);
									}
								};

								if (!s.async) {
									// if we're in sync mode we fire the callback
									callback();
								} else if (xhr.readyState === 4) {
									// (IE6 & IE7) if it's in cache and has been
									// retrieved directly we need to fire the callback
									setTimeout(callback, 0);
								} else {
									handle = ++xhrId;
									if (xhrOnUnloadAbort) {
										// Create the active xhrs callbacks list if needed
										// and attach the unload handler
										if (!xhrCallbacks) {
											xhrCallbacks = {};
											JQXLite(window).unload(xhrOnUnloadAbort);
										}
										// Add to list of active xhrs callbacks
										xhrCallbacks[handle] = callback;
									}
									xhr.onreadystatechange = callback;
								}
							},

							abort: function () {
								if (callback) {
									callback(0, 1);
								}
							}
						};
					}
				});
			}
			var fxNow, timerId,
				rfxtypes = /^(?:toggle|show|hide)$/,
				rfxnum = new RegExp("^(?:([-+])=|)(" + core_pnum + ")([a-z%]*)$", "i"),
				rrun = /queueHooks$/,
				animationPrefilters = [defaultPrefilter],
				tweeners = {
					"*": [function (prop, value) {
						var end, unit,
							tween = this.createTween(prop, value),
							parts = rfxnum.exec(value),
							target = tween.cur(),
							start = +target || 0,
							scale = 1,
							maxIterations = 20;

						if (parts) {
							end = +parts[2];
							unit = parts[3] || (JQXLite.cssNumber[prop] ? "" : "px");

							// We need to compute starting value
							if (unit !== "px" && start) {
								// Iteratively approximate from a nonzero starting point
								// Prefer the current property, because this process will be trivial if it uses the same units
								// Fallback to end or a simple constant
								start = JQXLite.css(tween.elem, prop, true) || end || 1;

								do {
									// If previous iteration zeroed out, double until we get *something*
									// Use a string for doubling factor so we don't accidentally see scale as unchanged below
									scale = scale || ".5";

									// Adjust and apply
									start = start / scale;
									JQXLite.style(tween.elem, prop, start + unit);

									// Update scale, tolerating zero or NaN from tween.cur()
									// And breaking the loop if scale is unchanged or perfect, or if we've just had enough
								} while (scale !== (scale = tween.cur() / target) && scale !== 1 && --maxIterations);
							}

							tween.unit = unit;
							tween.start = start;
							// If a +=/-= token was provided, we're doing a relative animation
							tween.end = parts[1] ? start + (parts[1] + 1) * end : end;
						}
						return tween;
					}]
				};

			// Animations created synchronously will run synchronously
			function createFxNow() {
				setTimeout(function () {
					fxNow = undefined;
				}, 0);
				return (fxNow = JQXLite.now());
			}

			function createTweens(animation, props) {
				JQXLite.each(props, function (prop, value) {
					var collection = (tweeners[prop] || []).concat(tweeners["*"]),
						index = 0,
						length = collection.length;
					for (; index < length; index++) {
						if (collection[index].call(animation, prop, value)) {

							// we're done with this property
							return;
						}
					}
				});
			}

			function Animation(elem, properties, options) {
				var result,
					index = 0,
					tweenerIndex = 0,
					length = animationPrefilters.length,
					deferred = JQXLite.Deferred().always(function () {
						// don't match elem in the :animated selector
						delete tick.elem;
					}),
					tick = function () {
						var currentTime = fxNow || createFxNow(),
							remaining = Math.max(0, animation.startTime + animation.duration - currentTime),
							// archaic crash bug won't allow us to use 1 - ( 0.5 || 0 ) (#12497)
							temp = remaining / animation.duration || 0,
							percent = 1 - temp,
							index = 0,
							length = animation.tweens.length;

						for (; index < length; index++) {
							animation.tweens[index].run(percent);
						}

						deferred.notifyWith(elem, [animation, percent, remaining]);

						if (percent < 1 && length) {
							return remaining;
						} else {
							deferred.resolveWith(elem, [animation]);
							return false;
						}
					},
					animation = deferred.promise({
						elem: elem,
						props: JQXLite.extend({}, properties),
						opts: JQXLite.extend(true, { specialEasing: {} }, options),
						originalProperties: properties,
						originalOptions: options,
						startTime: fxNow || createFxNow(),
						duration: options.duration,
						tweens: [],
						createTween: function (prop, end, easing) {
							var tween = JQXLite.Tween(elem, animation.opts, prop, end,
								animation.opts.specialEasing[prop] || animation.opts.easing);
							animation.tweens.push(tween);
							return tween;
						},
						stop: function (gotoEnd) {
							var index = 0,
								// if we are going to the end, we want to run all the tweens
								// otherwise we skip this part
								length = gotoEnd ? animation.tweens.length : 0;

							for (; index < length; index++) {
								animation.tweens[index].run(1);
							}

							// resolve when we played the last frame
							// otherwise, reject
							if (gotoEnd) {
								deferred.resolveWith(elem, [animation, gotoEnd]);
							} else {
								deferred.rejectWith(elem, [animation, gotoEnd]);
							}
							return this;
						}
					}),
					props = animation.props;

				propFilter(props, animation.opts.specialEasing);

				for (; index < length; index++) {
					result = animationPrefilters[index].call(animation, elem, props, animation.opts);
					if (result) {
						return result;
					}
				}

				createTweens(animation, props);

				if (JQXLite.isFunction(animation.opts.start)) {
					animation.opts.start.call(elem, animation);
				}

				JQXLite.fx.timer(
					JQXLite.extend(tick, {
						anim: animation,
						queue: animation.opts.queue,
						elem: elem
					})
				);

				// attach callbacks from options
				return animation.progress(animation.opts.progress)
					.done(animation.opts.done, animation.opts.complete)
					.fail(animation.opts.fail)
					.always(animation.opts.always);
			}

			function propFilter(props, specialEasing) {
				var index, name, easing, value, hooks;

				// camelCase, specialEasing and expand cssHook pass
				for (index in props) {
					name = JQXLite.camelCase(index);
					easing = specialEasing[name];
					value = props[index];
					if (JQXLite.isArray(value)) {
						easing = value[1];
						value = props[index] = value[0];
					}

					if (index !== name) {
						props[name] = value;
						delete props[index];
					}

					hooks = JQXLite.cssHooks[name];
					if (hooks && "expand" in hooks) {
						value = hooks.expand(value);
						delete props[name];

						// not quite $.extend, this wont overwrite keys already present.
						// also - reusing 'index' from above because we have the correct "name"
						for (index in value) {
							if (!(index in props)) {
								props[index] = value[index];
								specialEasing[index] = easing;
							}
						}
					} else {
						specialEasing[name] = easing;
					}
				}
			}

			JQXLite.Animation = JQXLite.extend(Animation, {

				tweener: function (props, callback) {
					if (JQXLite.isFunction(props)) {
						callback = props;
						props = ["*"];
					} else {
						props = props.split(" ");
					}

					var prop,
						index = 0,
						length = props.length;

					for (; index < length; index++) {
						prop = props[index];
						tweeners[prop] = tweeners[prop] || [];
						tweeners[prop].unshift(callback);
					}
				},

				prefilter: function (callback, prepend) {
					if (prepend) {
						animationPrefilters.unshift(callback);
					} else {
						animationPrefilters.push(callback);
					}
				}
			});

			function defaultPrefilter(elem, props, opts) {
				var index, prop, value, length, dataShow, toggle, tween, hooks, oldfire,
					anim = this,
					style = elem.style,
					orig = {},
					handled = [],
					hidden = elem.nodeType && isHidden(elem);

				// handle queue: false promises
				if (!opts.queue) {
					hooks = JQXLite._queueHooks(elem, "fx");
					if (hooks.unqueued == null) {
						hooks.unqueued = 0;
						oldfire = hooks.empty.fire;
						hooks.empty.fire = function () {
							if (!hooks.unqueued) {
								oldfire();
							}
						};
					}
					hooks.unqueued++;

					anim.always(function () {
						// doing this makes sure that the complete handler will be called
						// before this completes
						anim.always(function () {
							hooks.unqueued--;
							if (!JQXLite.queue(elem, "fx").length) {
								hooks.empty.fire();
							}
						});
					});
				}

				// height/width overflow pass
				if (elem.nodeType === 1 && ("height" in props || "width" in props)) {
					// Make sure that nothing sneaks out
					// Record all 3 overflow attributes because IE does not
					// change the overflow attribute when overflowX and
					// overflowY are set to the same value
					opts.overflow = [style.overflow, style.overflowX, style.overflowY];

					// Set display property to inline-block for height/width
					// animations on inline elements that are having width/height animated
					if (JQXLite.css(elem, "display") === "inline" &&
						JQXLite.css(elem, "float") === "none") {

						// inline-level elements accept inline-block;
						// block-level elements need to be inline with layout
						if (!JQXLite.support.inlineBlockNeedsLayout || css_defaultDisplay(elem.nodeName) === "inline") {
							style.display = "inline-block";

						} else {
							style.zoom = 1;
						}
					}
				}

				if (opts.overflow) {
					style.overflow = "hidden";
					if (!JQXLite.support.shrinkWrapBlocks) {
						anim.done(function () {
							style.overflow = opts.overflow[0];
							style.overflowX = opts.overflow[1];
							style.overflowY = opts.overflow[2];
						});
					}
				}


				// show/hide pass
				for (index in props) {
					value = props[index];
					if (rfxtypes.exec(value)) {
						delete props[index];
						toggle = toggle || value === "toggle";
						if (value === (hidden ? "hide" : "show")) {
							continue;
						}
						handled.push(index);
					}
				}

				length = handled.length;
				if (length) {
					dataShow = JQXLite._data(elem, "fxshow") || JQXLite._data(elem, "fxshow", {});
					if ("hidden" in dataShow) {
						hidden = dataShow.hidden;
					}

					// store state if its toggle - enables .stop().toggle() to "reverse"
					if (toggle) {
						dataShow.hidden = !hidden;
					}
					if (hidden) {
						JQXLite(elem).show();
					} else {
						anim.done(function () {
							JQXLite(elem).hide();
						});
					}
					anim.done(function () {
						var prop;
						JQXLite.removeData(elem, "fxshow", true);
						for (prop in orig) {
							JQXLite.style(elem, prop, orig[prop]);
						}
					});
					for (index = 0; index < length; index++) {
						prop = handled[index];
						tween = anim.createTween(prop, hidden ? dataShow[prop] : 0);
						orig[prop] = dataShow[prop] || JQXLite.style(elem, prop);

						if (!(prop in dataShow)) {
							dataShow[prop] = tween.start;
							if (hidden) {
								tween.end = tween.start;
								tween.start = prop === "width" || prop === "height" ? 1 : 0;
							}
						}
					}
				}
			}

			function Tween(elem, options, prop, end, easing) {
				return new Tween.prototype.init(elem, options, prop, end, easing);
			}
			JQXLite.Tween = Tween;

			Tween.prototype = {
				constructor: Tween,
				init: function (elem, options, prop, end, easing, unit) {
					this.elem = elem;
					this.prop = prop;
					this.easing = easing || "swing";
					this.options = options;
					this.start = this.now = this.cur();
					this.end = end;
					this.unit = unit || (JQXLite.cssNumber[prop] ? "" : "px");
				},
				cur: function () {
					var hooks = Tween.propHooks[this.prop];

					return hooks && hooks.get ?
						hooks.get(this) :
						Tween.propHooks._default.get(this);
				},
				run: function (percent) {
					var eased,
						hooks = Tween.propHooks[this.prop];

					if (this.options.duration) {
						this.pos = eased = JQXLite.easing[this.easing](
							percent, this.options.duration * percent, 0, 1, this.options.duration
						);
					} else {
						this.pos = eased = percent;
					}
					this.now = (this.end - this.start) * eased + this.start;

					if (this.options.step) {
						this.options.step.call(this.elem, this.now, this);
					}

					if (hooks && hooks.set) {
						hooks.set(this);
					} else {
						Tween.propHooks._default.set(this);
					}
					return this;
				}
			};

			Tween.prototype.init.prototype = Tween.prototype;

			Tween.propHooks = {
				_default: {
					get: function (tween) {
						var result;

						if (tween.elem[tween.prop] != null &&
							(!tween.elem.style || tween.elem.style[tween.prop] == null)) {
							return tween.elem[tween.prop];
						}

						// passing any value as a 4th parameter to .css will automatically
						// attempt a parseFloat and fallback to a string if the parse fails
						// so, simple values such as "10px" are parsed to Float.
						// complex values such as "rotate(1rad)" are returned as is.
						result = JQXLite.css(tween.elem, tween.prop, false, "");
						// Empty strings, null, undefined and "auto" are converted to 0.
						return !result || result === "auto" ? 0 : result;
					},
					set: function (tween) {
						// use step hook for back compat - use cssHook if its there - use .style if its
						// available and use plain properties where available
						if (JQXLite.fx.step[tween.prop]) {
							JQXLite.fx.step[tween.prop](tween);
						} else if (tween.elem.style && (tween.elem.style[JQXLite.cssProps[tween.prop]] != null || JQXLite.cssHooks[tween.prop])) {
							JQXLite.style(tween.elem, tween.prop, tween.now + tween.unit);
						} else {
							tween.elem[tween.prop] = tween.now;
						}
					}
				}
			};

			// Remove in 2.0 - this supports IE8's panic based approach
			// to setting things on disconnected nodes

			Tween.propHooks.scrollTop = Tween.propHooks.scrollLeft = {
				set: function (tween) {
					if (tween.elem.nodeType && tween.elem.parentNode) {
						tween.elem[tween.prop] = tween.now;
					}
				}
			};

			JQXLite.each(["toggle", "show", "hide"], function (i, name) {
				var cssFn = JQXLite.fn[name];
				JQXLite.fn[name] = function (speed, easing, callback) {
					return speed == null || typeof speed === "boolean" ||
						// special check for .toggle( handler, handler, ... )
						(!i && JQXLite.isFunction(speed) && JQXLite.isFunction(easing)) ?
						cssFn.apply(this, arguments) :
						this.animate(genFx(name, true), speed, easing, callback);
				};
			});

			JQXLite.fn.extend({
				fadeTo: function (speed, to, easing, callback) {

					// show any hidden elements after setting opacity to 0
					return this.filter(isHidden).css("opacity", 0).show()

						// animate to the value specified
						.end().animate({ opacity: to }, speed, easing, callback);
				},
				animate: function (prop, speed, easing, callback) {
					var empty = JQXLite.isEmptyObject(prop),
						optall = JQXLite.speed(speed, easing, callback),
						doAnimation = function () {
							// Operate on a copy of prop so per-property easing won't be lost
							var anim = Animation(this, JQXLite.extend({}, prop), optall);

							// Empty animations resolve immediately
							if (empty) {
								anim.stop(true);
							}
						};

					return empty || optall.queue === false ?
						this.each(doAnimation) :
						this.queue(optall.queue, doAnimation);
				},
				stop: function (type, clearQueue, gotoEnd) {
					var stopQueue = function (hooks) {
						var stop = hooks.stop;
						delete hooks.stop;
						stop(gotoEnd);
					};

					if (typeof type !== "string") {
						gotoEnd = clearQueue;
						clearQueue = type;
						type = undefined;
					}
					if (clearQueue && type !== false) {
						this.queue(type || "fx", []);
					}

					return this.each(function () {
						var dequeue = true,
							index = type != null && type + "queueHooks",
							timers = JQXLite.timers,
							data = JQXLite._data(this);

						if (index) {
							if (data[index] && data[index].stop) {
								stopQueue(data[index]);
							}
						} else {
							for (index in data) {
								if (data[index] && data[index].stop && rrun.test(index)) {
									stopQueue(data[index]);
								}
							}
						}

						for (index = timers.length; index--;) {
							if (timers[index].elem === this && (type == null || timers[index].queue === type)) {
								timers[index].anim.stop(gotoEnd);
								dequeue = false;
								timers.splice(index, 1);
							}
						}

						// start the next in the queue if the last step wasn't forced
						// timers currently will call their complete callbacks, which will dequeue
						// but only if they were gotoEnd
						if (dequeue || !gotoEnd) {
							JQXLite.dequeue(this, type);
						}
					});
				}
			});

			// Generate parameters to create a standard animation
			function genFx(type, includeWidth) {
				var which,
					attrs = { height: type },
					i = 0;

				// if we include width, step value is 1 to do all cssExpand values,
				// if we don't include width, step value is 2 to skip over Left and Right
				includeWidth = includeWidth ? 1 : 0;
				for (; i < 4; i += 2 - includeWidth) {
					which = cssExpand[i];
					attrs["margin" + which] = attrs["padding" + which] = type;
				}

				if (includeWidth) {
					attrs.opacity = attrs.width = type;
				}

				return attrs;
			}

			// Generate shortcuts for custom animations
			JQXLite.each({
				slideDown: genFx("show"),
				slideUp: genFx("hide"),
				slideToggle: genFx("toggle"),
				fadeIn: { opacity: "show" },
				fadeOut: { opacity: "hide" },
				fadeToggle: { opacity: "toggle" }
			}, function (name, props) {
				JQXLite.fn[name] = function (speed, easing, callback) {
					return this.animate(props, speed, easing, callback);
				};
			});

			JQXLite.speed = function (speed, easing, fn) {
				var opt = speed && typeof speed === "object" ? JQXLite.extend({}, speed) : {
					complete: fn || !fn && easing ||
						JQXLite.isFunction(speed) && speed,
					duration: speed,
					easing: fn && easing || easing && !JQXLite.isFunction(easing) && easing
				};

				opt.duration = JQXLite.fx.off ? 0 : typeof opt.duration === "number" ? opt.duration :
					opt.duration in JQXLite.fx.speeds ? JQXLite.fx.speeds[opt.duration] : JQXLite.fx.speeds._default;

				// normalize opt.queue - true/undefined/null -> "fx"
				if (opt.queue == null || opt.queue === true) {
					opt.queue = "fx";
				}

				// Queueing
				opt.old = opt.complete;

				opt.complete = function () {
					if (JQXLite.isFunction(opt.old)) {
						opt.old.call(this);
					}

					if (opt.queue) {
						JQXLite.dequeue(this, opt.queue);
					}
				};

				return opt;
			};

			JQXLite.easing = {
				linear: function (p) {
					return p;
				},
				swing: function (p) {
					return 0.5 - Math.cos(p * Math.PI) / 2;
				}
			};

			JQXLite.timers = [];
			JQXLite.fx = Tween.prototype.init;
			JQXLite.fx.tick = function () {
				var timer,
					timers = JQXLite.timers,
					i = 0;

				fxNow = JQXLite.now();

				for (; i < timers.length; i++) {
					timer = timers[i];
					// Checks the timer has not already been removed
					if (!timer() && timers[i] === timer) {
						timers.splice(i--, 1);
					}
				}

				if (!timers.length) {
					JQXLite.fx.stop();
				}
				fxNow = undefined;
			};

			JQXLite.fx.timer = function (timer) {
				if (timer() && JQXLite.timers.push(timer) && !timerId) {
					timerId = setInterval(JQXLite.fx.tick, JQXLite.fx.interval);
				}
			};

			JQXLite.fx.interval = 13;

			JQXLite.fx.stop = function () {
				clearInterval(timerId);
				timerId = null;
			};

			JQXLite.fx.speeds = {
				slow: 600,
				fast: 200,
				// Default speed
				_default: 400
			};

			// Back Compat <1.8 extension point
			JQXLite.fx.step = {};

			if (JQXLite.expr && JQXLite.expr.filters) {
				JQXLite.expr.filters.animated = function (elem) {
					return JQXLite.grep(JQXLite.timers, function (fn) {
						return elem === fn.elem;
					}).length;
				};
			}
			var rroot = /^(?:body|html)$/i;

			JQXLite.fn.offset = function (options) {
				if (arguments.length) {
					return options === undefined ?
						this :
						this.each(function (i) {
							JQXLite.offset.setOffset(this, options, i);
						});
				}

				var docElem, body, win, clientTop, clientLeft, scrollTop, scrollLeft,
					box = { top: 0, left: 0 },
					elem = this[0],
					doc = elem && elem.ownerDocument;

				if (!doc) {
					return;
				}

				if ((body = doc.body) === elem) {
					return JQXLite.offset.bodyOffset(elem);
				}

				docElem = doc.documentElement;

				// Make sure it's not a disconnected DOM node
				if (!JQXLite.contains(docElem, elem)) {
					return box;
				}

				// If we don't have gBCR, just use 0,0 rather than error
				// BlackBerry 5, iOS 3 (original iPhone)
				if (typeof elem.getBoundingClientRect !== "undefined") {
					box = elem.getBoundingClientRect();
				}
				win = getWindow(doc);
				clientTop = docElem.clientTop || body.clientTop || 0;
				clientLeft = docElem.clientLeft || body.clientLeft || 0;
				scrollTop = win.pageYOffset || docElem.scrollTop;
				scrollLeft = win.pageXOffset || docElem.scrollLeft;
				return {
					top: box.top + scrollTop - clientTop,
					left: box.left + scrollLeft - clientLeft
				};
			};

			JQXLite.offset = {

				bodyOffset: function (body) {
					var top = body.offsetTop,
						left = body.offsetLeft;

					if (JQXLite.support.doesNotIncludeMarginInBodyOffset) {
						top += parseFloat(JQXLite.css(body, "marginTop")) || 0;
						left += parseFloat(JQXLite.css(body, "marginLeft")) || 0;
					}

					return { top: top, left: left };
				},

				setOffset: function (elem, options, i) {
					var position = JQXLite.css(elem, "position");

					// set position first, in-case top/left are set even on static elem
					if (position === "static") {
						elem.style.position = "relative";
					}

					var curElem = JQXLite(elem),
						curOffset = curElem.offset(),
						curCSSTop = JQXLite.css(elem, "top"),
						curCSSLeft = JQXLite.css(elem, "left"),
						calculatePosition = (position === "absolute" || position === "fixed") && JQXLite.inArray("auto", [curCSSTop, curCSSLeft]) > -1,
						props = {}, curPosition = {}, curTop, curLeft;

					// need to be able to calculate position if either top or left is auto and position is either absolute or fixed
					if (calculatePosition) {
						curPosition = curElem.position();
						curTop = curPosition.top;
						curLeft = curPosition.left;
					} else {
						curTop = parseFloat(curCSSTop) || 0;
						curLeft = parseFloat(curCSSLeft) || 0;
					}

					if (JQXLite.isFunction(options)) {
						options = options.call(elem, i, curOffset);
					}

					if (options.top != null) {
						props.top = (options.top - curOffset.top) + curTop;
					}
					if (options.left != null) {
						props.left = (options.left - curOffset.left) + curLeft;
					}

					if ("using" in options) {
						options.using.call(elem, props);
					} else {
						curElem.css(props);
					}
				}
			};


			JQXLite.fn.extend({
				isRendered: function () {
					var that = this;
					var element = this[0];
					if (element.parentNode == null || (element.offsetWidth === 0 || element.offsetHeight === 0)) {
						return false;
					}

					return true;
				},

				getSizeFromStyle: function () {
					var that = this;
					var width = null;
					var height = null;
					var element = this[0];
					var computedStyle;

					if (element.style.width) {
						width = element.style.width;
					}
					if (element.style.height) {
						height = element.style.height;
					}

					if (window.getComputedStyle) {
						computedStyle = getComputedStyle(element, null);
					}
					else {
						computedStyle = element.currentStyle;
					}

					if (computedStyle) {
						if (computedStyle.width) {
							width = computedStyle.width;
						}
						if (computedStyle.height) {
							height = computedStyle.height;
						}
					}
					if (width === '0px') width = 0;
					if (height === '0px') height = 0;
					if (width === null) width = 0;
					if (height === null) height = 0;

					return { width: width, height: height };
				},

				initAnimate: function () {

				},

				sizeStyleChanged: function (resizeFn) {
					var that = this;

					var watchedElementData;

					var checkForChanges = function (mutations) {
						var data = watchedElementData;
						if (mutations && mutations[0] && mutations[0].attributeName === 'style' && mutations[0].type === 'attributes') {
							if (data.element.offsetWidth !== data.offsetWidth ||
								data.element.offsetHeight !== data.offsetHeight) {
								data.offsetWidth = data.element.offsetWidth;
								data.offsetHeight = data.element.offsetHeight;
								if (that.isRendered()) {
									data.callback();
								}
							}
						}
					}

					watchedElementData = {
						element: that[0],
						offsetWidth: that[0].offsetWidth,
						offsetHeight: that[0].offsetHeight,
						callback: resizeFn
					};

					try {
						if (!that.elementStyleObserver) {
							that.elementStyleObserver = new MutationObserver(checkForChanges);
							that.elementStyleObserver.observe(that[0], {
								attributes: true,
								childList: false,
								characterData: false
							});

						}
					}
					catch (error) { }
				},

				position: function () {
					if (!this[0]) {
						return;
					}

					var elem = this[0],

						// Get *real* offsetParent
						offsetParent = this.offsetParent(),

						// Get correct offsets
						offset = this.offset(),
						parentOffset = rroot.test(offsetParent[0].nodeName) ? { top: 0, left: 0 } : offsetParent.offset();

					// Subtract element margins
					// note: when an element has margin: auto the offsetLeft and marginLeft
					// are the same in Safari causing offset.left to incorrectly be 0
					offset.top -= parseFloat(JQXLite.css(elem, "marginTop")) || 0;
					offset.left -= parseFloat(JQXLite.css(elem, "marginLeft")) || 0;

					// Add offsetParent borders
					parentOffset.top += parseFloat(JQXLite.css(offsetParent[0], "borderTopWidth")) || 0;
					parentOffset.left += parseFloat(JQXLite.css(offsetParent[0], "borderLeftWidth")) || 0;

					// Subtract the two offsets
					return {
						top: offset.top - parentOffset.top,
						left: offset.left - parentOffset.left
					};
				},

				offsetParent: function () {
					return this.map(function () {
						var offsetParent = this.offsetParent || document.body;
						while (offsetParent && (!rroot.test(offsetParent.nodeName) && JQXLite.css(offsetParent, "position") === "static")) {
							offsetParent = offsetParent.offsetParent;
						}
						return offsetParent || document.body;
					});
				}
			});
			// Create scrollLeft and scrollTop methods
			JQXLite.each({ scrollLeft: "pageXOffset", scrollTop: "pageYOffset" }, function (method, prop) {
				var top = /Y/.test(prop);

				JQXLite.fn[method] = function (val) {
					return JQXLite.access(this, function (elem, method, val) {
						var win = getWindow(elem);

						if (val === undefined) {
							return win ? (prop in win) ? win[prop] :
								win.document.documentElement[method] :
								elem[method];
						}

						if (win) {
							win.scrollTo(
								!top ? val : JQXLite(win).scrollLeft(),
								top ? val : JQXLite(win).scrollTop()
							);

						} else {
							elem[method] = val;
						}
					}, method, val, arguments.length, null);
				};
			});

			function getWindow(elem) {
				return JQXLite.isWindow(elem) ?
					elem :
					elem.nodeType === 9 ?
						elem.defaultView || elem.parentWindow :
						false;
			}
			// Create innerHeight, innerWidth, height, width, outerHeight and outerWidth methods
			JQXLite.each({ Height: "height", Width: "width" }, function (name, type) {
				JQXLite.each({ padding: "inner" + name, content: type, "": "outer" + name }, function (defaultExtra, funcName) {
					// margin is only for outerHeight, outerWidth
					JQXLite.fn[funcName] = function (margin, value) {
						var chainable = arguments.length && (defaultExtra || typeof margin !== "boolean"),
							extra = defaultExtra || (margin === true || value === true ? "margin" : "border");

						return JQXLite.access(this, function (elem, type, value) {
							var doc;

							if (JQXLite.isWindow(elem)) {
								// As of 5/8/2012 this will yield incorrect results for Mobile Safari, but there
								// isn't a whole lot we can do. See pull request at this URL for discussion:
								// https://github.com/jqx/jqx/pull/764
								return elem.document.documentElement["client" + name];
							}

							// Get document width or height
							if (elem.nodeType === 9) {
								doc = elem.documentElement;

								// Either scroll[Width/Height] or offset[Width/Height] or client[Width/Height], whichever is greatest
								// unfortunately, this causes bug #3838 in IE6/8 only, but there is currently no good, small way to fix it.
								return Math.max(
									elem.body["scroll" + name], doc["scroll" + name],
									elem.body["offset" + name], doc["offset" + name],
									doc["client" + name]
								);
							}

							return value === undefined ?
								// Get width or height on the element, requesting but not forcing parseFloat
								JQXLite.css(elem, type, value, extra) :

								// Set width or height on the element
								JQXLite.style(elem, type, value, extra);
						}, type, chainable ? margin : undefined, chainable, null);
					};
				});
			});
			// Expose JQXLite to the global object
			window.JQXLite = window.jqxHelper = JQXLite;

			// Expose JQXLite as an AMD module, but only for AMD loaders that
			// understand the issues with loading multiple versions of JQXLite
			// in a page that all might call define(). The loader will indicate
			// they have special allowances for multiple JQXLite versions by
			// specifying define.amd.JQXLite = true. Register as a named module,
			// since JQXLite can be concatenated with other files that may use define,
			// but not use a proper concatenation script that understands anonymous
			// AMD modules. A named AMD is safest and most robust way to register.
			// Lowercase jqx is used because AMD module names are derived from
			// file names, and JQXLite is normally delivered in a lowercase file name.
			// Do this after creating the global so that if an AMD module wants to call
			// noConflict to hide this version of JQXLite, it will work.
			if ( true && __webpack_require__.amdO.JQXLite) {
				!(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = (function () { return JQXLite; }).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
			}

		})(window);
	}

	// jqxHelper
	(function (window) {
		if (window.jqxCore) {
			window.$$ = window.minQuery = window.JQXLite;

			if (!window.$) {
				window.$ = window.minQuery;
			}

			return;
		}

		if (window.jQuery) {
			window.minQuery = window.JQXLite = window.jQuery;
			return;
		}

		if (!window.$) {
			window.$ = window.minQuery = window.JQXLite;
		}
		else {
			window.minQuery = window.JQXLite = window.$;
		}
	})(window);
	// End of jqxHelper

	JQXLite.generateID = function () {
		var S4 = function () {
			return (((1 + Math.random()) * 0x10000) | 0).toString(16).substring(1);
		};

		var id = "";
		do {
			id = "jqx" + S4() + S4() + S4();
		} while ($('#' + id).length > 0);

		return id;
	}

	var jqxBaseFramework = window.jqxBaseFramework = window.minQuery || window.jQuery;

	(function ($) {

		$.jqx = $.jqx || {}
		window.jqx = $.jqx;

		var jqwidgets = {
			createInstance: function (selector, widgetName, params) {
				if (widgetName == 'jqxDataAdapter') {
					var source = params[0];
					var settings = params[1] || {};
					return new $.jqx.dataAdapter(source, settings);
				}

				$(selector)[widgetName](params || {});
				return $(selector)[widgetName]('getInstance');
			}
		};

		window.jqwidgets = jqwidgets;

		$.jqx.define = function (namespace, classname, baseclass) {
			namespace[classname] = function () {
				if (this.baseType) {
					this.base = new namespace[this.baseType]();
					this.base.defineInstance();
				}
				this.defineInstance();
				this.metaInfo();
			}

			namespace[classname].prototype.defineInstance = function () { };
			namespace[classname].prototype.metaInfo = function () { };
			namespace[classname].prototype.base = null;
			namespace[classname].prototype.baseType = undefined;

			if (baseclass && namespace[baseclass])
				namespace[classname].prototype.baseType = baseclass;
		}

		// method call
		$.jqx.invoke = function (object, args) {
			if (args.length == 0)
				return;

			var method = typeof (args) == Array || args.length > 0 ? args[0] : args;
			var methodArg = typeof (args) == Array || args.length > 1 ? Array.prototype.slice.call(args, 1) : $({}).toArray();

			while (object[method] == undefined && object.base != null) {
				if (object[method] != undefined && $.isFunction(object[method]))
					return object[method].apply(object, methodArg);

				if (typeof method == 'string') {
					var methodLowerCase = method.toLowerCase();
					if (object[methodLowerCase] != undefined && $.isFunction(object[methodLowerCase])) {
						return object[methodLowerCase].apply(object, methodArg);
					}
				}
				object = object.base;
			}

			if (object[method] != undefined && $.isFunction(object[method]))
				return object[method].apply(object, methodArg);

			if (typeof method == 'string') {
				var methodLowerCase = method.toLowerCase();
				if (object[methodLowerCase] != undefined && $.isFunction(object[methodLowerCase])) {
					return object[methodLowerCase].apply(object, methodArg);
				}
			}

			return;
		}

		$.jqx.getByPriority = function (arr) {
			var value = undefined;
			for (var i = 0; i < arr.length && value == undefined; i++) {
				if (value == undefined && arr[i] != undefined)
					value = arr[i];
			}

			return value;
		}

		$.jqx.hasProperty = function (obj, property) {
			if (typeof (property) == 'object') {
				for (var prop in property) {
					var o = obj;
					while (o) {
						if (o.hasOwnProperty(prop))
							return true;
						if (o.hasOwnProperty(prop.toLowerCase()))
							return true;
						o = o.base;
					}
					return false;
				}
			}
			else {
				while (obj) {
					if (obj.hasOwnProperty(property))
						return true;
					if (obj.hasOwnProperty(property.toLowerCase()))
						return true;
					obj = obj.base;
				}
			}

			return false;
		}

		$.jqx.hasFunction = function (object, args) {
			if (args.length == 0)
				return false;

			if (object == undefined)
				return false;

			var method = typeof (args) == Array || args.length > 0 ? args[0] : args;
			var methodArg = typeof (args) == Array || args.length > 1 ? Array.prototype.slice.call(args, 1) : {};

			while (object[method] == undefined && object.base != null) {
				if (object[method] && $.isFunction(object[method]))
					return true;

				if (typeof method == 'string') {
					var methodLowerCase = method.toLowerCase();
					if (object[methodLowerCase] && $.isFunction(object[methodLowerCase]))
						return true;
				}
				object = object.base;
			}

			if (object[method] && $.isFunction(object[method]))
				return true;

			if (typeof method == 'string') {
				var methodLowerCase = method.toLowerCase();
				if (object[methodLowerCase] && $.isFunction(object[methodLowerCase]))
					return true;
			}

			return false;
		}

		$.jqx.isPropertySetter = function (obj, args) {
			if (args.length == 1 && typeof (args[0]) == 'object')
				return true;

			if (args.length == 2 &&
				typeof (args[0]) == 'string' &&
				!$.jqx.hasFunction(obj, args)) {
				return true;
			}

			return false;
		}

		$.jqx.validatePropertySetter = function (obj, args, suppressException) {
			if (!$.jqx.propertySetterValidation)
				return true;

			if (args.length == 1 && typeof (args[0]) == 'object') {
				for (var i in args[0]) {
					var o = obj;
					while (!o.hasOwnProperty(i) && o.base)
						o = o.base;

					if (!o || !o.hasOwnProperty(i)) {
						if (!suppressException) {
							var hasLowerCase = o.hasOwnProperty(i.toString().toLowerCase());
							if (!hasLowerCase) {
								throw 'Invalid property: ' + i;
							}
							else return true;
						}
						return false;
					}
				}

				return true;
			}

			if (args.length != 2) {
				if (!suppressException)
					throw 'Invalid property: ' + args.length >= 0 ? args[0] : '';

				return false;
			}

			while (!obj.hasOwnProperty(args[0]) && obj.base)
				obj = obj.base;

			if (!obj || !obj.hasOwnProperty(args[0])) {
				if (!suppressException)
					throw 'Invalid property: ' + args[0];

				return false;
			}

			return true;
		}

		if (!Object.keys) {
			Object.keys = (function () {
				'use strict';
				var hasOwnProperty = Object.prototype.hasOwnProperty,
					hasDontEnumBug = !({ toString: null }).propertyIsEnumerable('toString'),
					dontEnums = [
						'toString',
						'toLocaleString',
						'valueOf',
						'hasOwnProperty',
						'isPrototypeOf',
						'propertyIsEnumerable',
						'constructor'
					],
					dontEnumsLength = dontEnums.length;

				return function (obj) {
					if (typeof obj !== 'object' && (typeof obj !== 'function' || obj === null)) {
						throw new TypeError('Object.keys called on non-object');
					}

					var result = [], prop, i;

					for (prop in obj) {
						if (hasOwnProperty.call(obj, prop)) {
							result.push(prop);
						}
					}

					if (hasDontEnumBug) {
						for (i = 0; i < dontEnumsLength; i++) {
							if (hasOwnProperty.call(obj, dontEnums[i])) {
								result.push(dontEnums[i]);
							}
						}
					}
					return result;
				};
			}());
		}

		$.jqx.set = function (object, args) {
			var newValuesLength = 0;
			if (args.length == 1 && typeof (args[0]) == 'object') {
				if (object.isInitialized && Object.keys && Object.keys(args[0]).length > 1) {
					var element = !object.base ? object.element : object.base.element;
					var initArgs = $.data(element, object.widgetName).initArgs;
					if (initArgs && JSON && JSON.stringify && args[0] && initArgs[0]) {
						try {
							if (JSON.stringify(args[0]) == JSON.stringify(initArgs[0])) {
								var toReturn = true;
								$.each(args[0], function (key, value) {
									if (object[key] != value) {
										toReturn = false;
										return false;
									}
								});
								if (toReturn) {
									return;
								}
							}
						}
						catch (err) {
						}
					}
					object.batchUpdate = args[0];
					var oldValues = {};
					var newValues = {};
					$.each(args[0], function (key, value) {
						var obj = object;
						while (!obj.hasOwnProperty(key) && obj.base != null)
							obj = obj.base;

						if (obj.hasOwnProperty(key)) {
							if (object[key] != value) {
								oldValues[key] = object[key];
								newValues[key] = value;
								newValuesLength++;
							}
						}
						else if (obj.hasOwnProperty(key.toLowerCase())) {
							if (object[key.toLowerCase()] != value) {
								oldValues[key.toLowerCase()] = object[key.toLowerCase()];
								newValues[key.toLowerCase()] = value;
								newValuesLength++;
							}
						}
					});
					if (newValuesLength < 2) {
						object.batchUpdate = null;
					}
				}

				$.each(args[0], function (key, value) {
					var obj = object;
					while (!obj.hasOwnProperty(key) && obj.base != null)
						obj = obj.base;

					if (obj.hasOwnProperty(key)) {
						$.jqx.setvalueraiseevent(obj, key, value);
					}
					else if (obj.hasOwnProperty(key.toLowerCase())) {
						$.jqx.setvalueraiseevent(obj, key.toLowerCase(), value);
					}
					else if ($.jqx.propertySetterValidation)
						throw "jqxCore: invalid property '" + key + "'";
				});

				if (object.batchUpdate != null) {
					object.batchUpdate = null;
					if (object.propertiesChangedHandler && newValuesLength > 1) {
						object.propertiesChangedHandler(object, oldValues, newValues);
					}
				}
			}
			else if (args.length == 2) {
				while (!object.hasOwnProperty(args[0]) && object.base)
					object = object.base;

				if (object.hasOwnProperty(args[0])) {
					$.jqx.setvalueraiseevent(object, args[0], args[1]);
				}
				else if (object.hasOwnProperty(args[0].toLowerCase())) {
					$.jqx.setvalueraiseevent(object, args[0].toLowerCase(), args[1]);
				}
				else if ($.jqx.propertySetterValidation)
					throw "jqxCore: invalid property '" + args[0] + "'";
			}
		}

		$.jqx.setvalueraiseevent = function (object, key, value) {
			var oldVal = object[key];

			object[key] = value;

			if (!object.isInitialized)
				return;

			if (object.propertyChangedHandler != undefined)
				object.propertyChangedHandler(object, key, oldVal, value);

			if (object.propertyChangeMap != undefined && object.propertyChangeMap[key] != undefined)
				object.propertyChangeMap[key](object, key, oldVal, value);
		};

		$.jqx.get = function (object, args) {
			if (args == undefined || args == null)
				return undefined;

			if (object.propertyMap) {
				var newVal = object.propertyMap(args);
				if (newVal != null)
					return newVal;
			}

			if (object.hasOwnProperty(args))
				return object[args];

			if (object.hasOwnProperty(args.toLowerCase()))
				return object[args.toLowerCase()];

			var arg = undefined;
			if (typeof (args) == Array) {
				if (args.length != 1)
					return undefined;
				arg = args[0];
			}
			else if (typeof (args) == 'string')
				arg = args;

			while (!object.hasOwnProperty(arg) && object.base)
				object = object.base;

			if (object)
				return object[arg];

			return undefined;
		}

		$.jqx.serialize = function (obj) {
			var txt = '';
			if ($.isArray(obj)) {
				txt = '['
				for (var i = 0; i < obj.length; i++) {
					if (i > 0)
						txt += ', ';
					txt += $.jqx.serialize(obj[i]);
				}
				txt += ']';
			}
			else if (typeof (obj) == 'object') {
				txt = '{';
				var j = 0;
				for (var i in obj) {
					if (j++ > 0)
						txt += ', ';
					txt += i + ': ' + $.jqx.serialize(obj[i]);
				}
				txt += '}';
			}
			else
				txt = obj.toString();

			return txt;
		}

		$.jqx.propertySetterValidation = true;

		$.jqx.jqxWidgetProxy = function (controlName, element, args) {
			var host = $(element);
			var vars = $.data(element, controlName);
			if (vars == undefined) {
				return undefined;
			}

			var obj = vars.instance;

			if ($.jqx.hasFunction(obj, args))
				return $.jqx.invoke(obj, args);

			if ($.jqx.isPropertySetter(obj, args)) {
				if ($.jqx.validatePropertySetter(obj, args)) {
					$.jqx.set(obj, args);
					return undefined;
				}
			} else {
				if (typeof (args) == 'object' && args.length == 0)
					return;
				else if (typeof (args) == 'object' && args.length == 1 && $.jqx.hasProperty(obj, args[0]))
					return $.jqx.get(obj, args[0]);
				else if (typeof (args) == 'string' && $.jqx.hasProperty(obj, args[0]))
					return $.jqx.get(obj, args);
			}

			throw "jqxCore: Invalid parameter '" + $.jqx.serialize(args) + "' does not exist.";
			//      return undefined;
		}

		$.jqx.applyWidget = function (element, controlName, args, instance) {
			var WinJS = false;
			try {
				WinJS = window.MSApp != undefined;
			}
			catch (e) {
			}

			var host = $(element);
			if (!instance) {
				instance = new $.jqx['_' + controlName]();
			}
			else {
				instance.host = host;
				instance.element = element;
			}
			if (element.id == "") {
				element.id = $.jqx.utilities.createId();
			}

			var vars = { host: host, element: element, instance: instance, initArgs: args };

			instance.widgetName = controlName;
			$.data(element, controlName, vars);
			$.data(element, 'jqxWidget', vars.instance);

			var inits = new Array();
			var instance = vars.instance;
			while (instance) {
				instance.isInitialized = false;
				inits.push(instance);
				instance = instance.base;
			}
			inits.reverse();
			inits[0].theme = $.jqx.theme || '';

			$.jqx.jqxWidgetProxy(controlName, element, args);

			for (var i in inits) {
				instance = inits[i];
				if (i == 0) {
					instance.host = host;
					instance.element = element;
					instance.WinJS = WinJS;
				}
				if (instance != undefined) {
					if (instance.definedInstance) {
						instance.definedInstance();
					}
					if (instance.createInstance != null) {
						if (WinJS) {
							MSApp.execUnsafeLocalFunction(function () {
								instance.createInstance(args);
							});
						}
						else {
							instance.createInstance(args);
						}
					}
				}
			}

			for (var i in inits) {
				if (inits[i] != undefined) {
					inits[i].isInitialized = true;
				}
			}

			if (WinJS) {
				MSApp.execUnsafeLocalFunction(function () {
					vars.instance.refresh(true);
				});
			}
			else {
				vars.instance.refresh(true);
			}

		}

		$.jqx.jqxWidget = function (name, base, params) {

			var WinJS = false;
			try {
				var jqxArgs = Array.prototype.slice.call(params, 0);
			}
			catch (e) {
				var jqxArgs = '';
			}

			try {
				WinJS = window.MSApp != undefined;
			}
			catch (e) {
			}

			var controlName = name;

			var baseControl = '';
			if (base)
				baseControl = '_' + base;
			$.jqx.define($.jqx, '_' + controlName, baseControl);

			var widgets = new Array();

			if (!window[controlName]) {
				var serializeObject = function (data) {
					if (data == null) return "";
					var dataType = $.type(data);
					switch (dataType) {
						case "string":
						case "number":
						case "date":
						case "boolean":
						case "bool":
							if (data === null)
								return "";
							return data.toString()
					}

					var str = "";
					$.each(data, function (index, value) {
						var val = value;
						if (index > 0) str += ', ';
						str += "[";
						var m = 0;

						if ($.type(val) == "object") {
							for (var obj in val) {
								if (m > 0) str += ', ';
								str += '{' + obj + ":" + val[obj] + '}';
								m++;
							}
						}
						else {
							if (m > 0) str += ', ';
							str += '{' + index + ":" + val + '}';
							m++;
						}

						str += "]";
					});
					return str;
				}

				jqwidgets[controlName] = window[controlName] = function (selector, params) {
					var args = [];
					if (!params) {
						params = {};
					}
					args.push(params);

					var uid = selector;
					if ($.type(uid) === "object" && selector[0]) {
						uid = selector[0].id;
						if (uid === "") {
							uid = selector[0].id = $.jqx.utilities.createId();
						}
					} else if ($.type(selector) === "object" && selector && selector.nodeName) {
						uid = selector.id;
						if (uid === "") {
							uid = selector.id = $.jqx.utilities.createId();
						}
					}

					if (window.jqxWidgets && window.jqxWidgets[uid]) {
						if (params) {
							$.each(window.jqxWidgets[uid], function (index) {
								var data = $(this.element).data();
								if (data && data.jqxWidget) {
									$(this.element)[controlName](params);
								}
							});
						}
						if (window.jqxWidgets[uid].length == 1) {
							var data = $(window.jqxWidgets[uid][0].widgetInstance.element).data();
							if (data && data.jqxWidget) {
								return window.jqxWidgets[uid][0];
							}
						}

						var data = $(window.jqxWidgets[uid][0].widgetInstance.element).data();
						if (data && data.jqxWidget) {
							return window.jqxWidgets[uid];
						}
					}

					var elements = $(selector);
					if (elements.length === 0) {
						elements = $("<div></div>");
						if (controlName === "jqxInput" || controlName === "jqxPasswordInput" || controlName === "jqxMaskedInput") {
							elements = $("<input/>");
						}
						if (controlName === "jqxTextArea") {
							elements = $("<textarea></textarea>");
						}
						if (controlName === "jqxButton" || controlName === "jqxRepeatButton" || controlName === "jqxToggleButton") {
							elements = $("<button/>");
						}
						if (controlName === "jqxSplitter") {
							elements = $("<div><div>Panel 1</div><div>Panel 2</div></div>");
						}
						if (controlName === "jqxTabs") {
							elements = $("<div><ul><li>Tab 1</li><li>Tab 2</li></ul><div>Content 1</div><div>Content 2</div></div>");
						}
						if (controlName === "jqxRibbon") {
							elements = $("<div><ul><li>Tab 1</li><li>Tab 2</li></ul><div><div>Content 1</div><div>Content 2</div></div></div>");
						}
						if (controlName === "jqxDocking") {
							elements = $("<div><div><div><div>Title 1</div><div>Content 1</div></div></div></div>");
						}
						if (controlName === "jqxWindow") {
							elements = $("<div><div>Title 1</div><div>Content 1</div></div>");
						}
					}
					var instances = [];


					$.each(elements, function (index) {
						var element = elements[index];
						$.jqx.applyWidget(element, controlName, args, undefined);
						if (!widgets[controlName]) {
							var instance = $.data(element, 'jqxWidget');
							var properties = $.jqx["_" + controlName].prototype.defineInstance();
							var metaInfo = {};

							if ($.jqx["_" + controlName].prototype.metaInfo) {
								metaInfo = $.jqx["_" + controlName].prototype.metaInfo();
							}

							if (controlName == "jqxDockingLayout") {
								properties = $.extend(properties, $.jqx["_jqxLayout"].prototype.defineInstance());
							}
							if (controlName == "jqxToggleButton" || controlName == "jqxRepeatButton") {
								properties = $.extend(properties, $.jqx["_jqxButton"].prototype.defineInstance());
							}
							if (controlName == "jqxTreeGrid") {
								properties = $.extend(properties, $.jqx["_jqxDataTable"].prototype.defineInstance());
							}

							var widgetConstructor = function (element) {
								var instance = $.data(element, 'jqxWidget');
								this.widgetInstance = instance;
								var widget = $.extend(this, instance);
								widget.on = widget.addEventListener = function (eventName, callback) {
									widget.addHandler(!widget.base ? widget.host : widget.base.host, eventName, callback);
								}
								widget.off = widget.removeEventListener = function (eventName) {
									widget.removeHandler(!widget.base ? widget.host : widget.base.host, eventName);
								}

								for (var obj in instance) {
									if ($.type(instance[obj]) == "function") {
										widget[obj] = $.proxy(instance[obj], instance);
									}
								}
								return widget;
							}
							widgets[controlName] = widgetConstructor;

							// widget properties
							$.each(properties, function (property, currentValue) {
								Object.defineProperty(widgetConstructor.prototype, property, {
									get: function () {
										if (this.widgetInstance) {
											return this.widgetInstance[property];
										}
										return currentValue;
									},
									set: function (newValue) {
										if (this.widgetInstance && (this.widgetInstance[property] != newValue || property === "width" || property === "height")) {
											var key1 = this.widgetInstance[property];
											var key2 = newValue;
											var dataType1 = $.type(key1);
											var dataType2 = $.type(key2);
											var differentTypes = false;
											if (dataType1 != dataType2 || property === "source" || property === "width" || property === "height") {
												differentTypes = true;
											}
											if (differentTypes || (serializeObject(key1) != serializeObject(key2))) {
												var settings = {};
												settings[property] = newValue;
												if (this.widgetInstance.host) {
													this.widgetInstance.host[controlName](settings);
												}
												else {
													this.widgetInstance.base.host[controlName](settings);
												}
												this.widgetInstance[property] = newValue;
												if (this.widgetInstance.propertyUpdated) {
													this.widgetInstance.propertyUpdated(property, key1, newValue);
												}
											}
										}
									}
								});
							});
						}
						var instance = new widgets[controlName](element);

						instances.push(instance);
						if (!window.jqxWidgets) {
							window.jqxWidgets = new Array();
						}
						if (!window.jqxWidgets[uid]) {
							window.jqxWidgets[uid] = new Array();
						}
						window.jqxWidgets[uid].push(instance);
					});

					if (instances.length === 1)
						return instances[0];

					return instances;

				}
			}

			$.fn[controlName] = function () {
				var args = Array.prototype.slice.call(arguments, 0);

				if (args.length == 0 || (args.length == 1 && typeof (args[0]) == 'object')) {
					if (this.length == 0) {
						if (this.selector) {
							throw new Error('Invalid Selector - ' + this.selector + '! Please, check whether the used ID or CSS Class name is correct.');
						}
						else {
							throw new Error('Invalid Selector! Please, check whether the used ID or CSS Class name is correct.');
						}
					}

					return this.each(function () {
						var host = $(this);
						var element = this; // element == this == host[0]
						var vars = $.data(element, controlName);

						if (vars == null) {
							$.jqx.applyWidget(element, controlName, args, undefined);
						}
						else {
							$.jqx.jqxWidgetProxy(controlName, this, args);
						}
					}); // each
				}
				else {
					if (this.length == 0) {
						if (this.selector) {
							throw new Error('Invalid Selector - ' + this.selector + '! Please, check whether the used ID or CSS Class name is correct.');
						}
						else {
							throw new Error('Invalid Selector! Please, check whether the used ID or CSS Class name is correct.');
						}
					}

					var returnVal = null;

					var cnt = 0;
					this.each(function () {
						var result = $.jqx.jqxWidgetProxy(controlName, this, args);

						if (cnt == 0) {
							returnVal = result;
							cnt++;
						}
						else {
							if (cnt == 1) {
								var tmp = [];
								tmp.push(returnVal);
								returnVal = tmp;
							}
							returnVal.push(result);
						}
					}); // each
				}

				return returnVal;
			}

			try {
				$.extend($.jqx['_' + controlName].prototype, Array.prototype.slice.call(params, 0)[0]);
			}
			catch (e) {
			}

			$.extend($.jqx['_' + controlName].prototype, {
				toThemeProperty: function (propertyName, override) {
					return $.jqx.toThemeProperty(this, propertyName, override);
				},

				isMaterialized: function () {
					if (!this.theme) {
						return false;
					}

					if (this.theme === "fluent") {
						return true;
					}

					if (this.theme === "light") {
						return true;
					}


					if (this.theme === "dark") {
						return true;
					}

					if (this.theme === "deepblue") {
						return true;
					}

					if (this.theme.indexOf("material") >= 0) {
						return true;
					}
				},

				isModern: function () {
					if (!this.theme) {
						return false;
					}

					if (this.theme.indexOf("light") >= 0) {
						return true;
					}

					if (this.theme === "dark") {
						return true;
					}
				},

				_addBarAndLabel: function (host) {
					var that = this;

					var label = $("<label></label");
					label[0].innerHTML = this.placeHolder;
					label.addClass(that.toThemeProperty('jqx-input-label'));
					host.after(label);
					that.label = label;

					var bar = $("<span></span>");
					host.after(bar);
					bar.addClass(that.toThemeProperty('jqx-input-bar'));
					that.bar = bar;
					that.bar.css('top', this.host.height());
				}
			});

			$.jqx['_' + controlName].prototype.refresh = function () {
				if (this.base)
					this.base.refresh(true);
			}
			$.jqx['_' + controlName].prototype.createInstance = function () {
			}

			$.jqx.isPassiveSupported = function () {
				var that = this;

				if (that.supportsPassive !== undefined) {
					return that.supportsPassive;
				}

				that.supportsPassive = false;
				try {
					var opts = Object.defineProperty({
					}, 'passive', {
						// eslint-disable-next-line getter-return
						get: function () {
							that.supportsPassive = true;
						}
					});
					window.addEventListener('testPassive', null, opts);
					window.removeEventListener('testPassive', null, opts);
				}
				catch (e) {
					//
				}

				return that.supportsPassive;
			}

			$.jqx['_' + controlName].prototype.addEventHandler = function (event, fnHandler) {
				if (this.base) {
					this.base.host.on(event, fnHandler);
				}
				else {
					this.host.on(event, fnHandler);
				}
			}

			$.jqx['_' + controlName].prototype.removeEventHandler = function (event, fnHandler) {
				if (this.base) {
					this.base.host.off(event);
				}
				else {
					this.host.off(event);
				}
			}

			$.jqx['_' + controlName].prototype.applyTo = function (element, args) {
				if (!(args instanceof Array)) {
					var a = [];
					a.push(args);
					args = a;
				}

				$.jqx.applyWidget(element, controlName, args, this);
			}

			$.jqx['_' + controlName].prototype.getInstance = function () {
				return this;
			}
			$.jqx['_' + controlName].prototype.propertyChangeMap = {};

			$.jqx['_' + controlName].prototype.addHandler = function (source, events, func, data) {
				$.jqx.addHandler($(source), events, func, data);
			};

			$.jqx['_' + controlName].prototype.removeHandler = function (source, events, func) {
				$.jqx.removeHandler($(source), events, func);
			};

			$.jqx['_' + controlName].prototype.setOptions = function () {
				if (!this.host || !this.host.length || this.host.length != 1)
					return;

				return $.jqx.jqxWidgetProxy(controlName, this.host[0], arguments);
			};
		} // jqxWidget

		$.jqx.toThemeProperty = function (instance, propertyName, override) {
			if (instance.theme == '')
				return propertyName;

			var split = propertyName.split(' ');
			var result = '';
			for (var i = 0; i < split.length; i++) {
				if (i > 0)
					result += ' ';

				var key = split[i];

				if (override != null && override)
					result += key + '-' + instance.theme;
				else
					result += key + ' ' + key + '-' + instance.theme;
			}

			return result;
		}

		$.jqx.addHandler = function (source, eventsList, func, data) {
			var events = eventsList.split(' ');

			for (var i = 0; i < events.length; i++) {
				var event = events[i];

				if (window.addEventListener && source[0]) {
					switch (event) {
						case 'mousewheel':
							if ($.jqx.browser.mozilla) {
								source[0].addEventListener('DOMMouseScroll', func, $.jqx.isPassiveSupported() ? { passive: false } : false);
							}
							else {
								source[0].addEventListener('mousewheel', func, $.jqx.isPassiveSupported() ? { passive: false } : false);
							}
							continue;
						case 'mousemove':
							if (!data) {
								source[0].addEventListener('mousemove', func, false);
								continue;
							}
							break;
						case 'touchmove':
							if (!data) {
								source[0].addEventListener('touchmove', func, false);
								continue;
							}
							else if (data && data.passive) {
								source[0].addEventListener('touchmove', func, data);
								continue;
							}

							break;
					}
				}

				if (data == undefined || data == null) {
					if (source.on)
						source.on(event, func);
					else
						source.bind(event, func);
				}
				else {
					if (source.on)
						source.on(event, data, func);
					else
						source.bind(event, data, func);
				}
			} // for
		};

		$.jqx.removeHandler = function (source, eventsList, func) {
			if (!eventsList) {
				if (source.off)
					source.off();
				else
					source.unbind();
				return;
			}
			var events = eventsList.split(' ');

			for (var i = 0; i < events.length; i++) {
				var event = events[i];

				if (window.removeEventListener) {
					switch (event) {
						case 'mousewheel':
							if ($.jqx.browser.mozilla) {
								source[0].removeEventListener('DOMMouseScroll', func, false);
							}
							else {
								source[0].removeEventListener('mousewheel', func, false);
							}
							continue;
						case 'mousemove':
							if (func) {
								source[0].removeEventListener('mousemove', func, false);
								continue;
							}
							break;
						case 'touchmove':
							if (func) {
								source[0].removeEventListener('touchmove', func, false);
								continue;
							}
							break;
					}
				}

				if (event == undefined) {
					if (source.off)
						source.off();
					else
						source.unbind();
					continue;
				}

				if (func == undefined) {
					if (source.off)
						source.off(event);
					else
						source.unbind(event);
				}
				else {
					if (source.off)
						source.off(event, func);
					else
						source.unbind(event, func);
				}
			}
		};

		$.jqx.credits = $.jqx.credits || "";
		$.jqx.theme = $.jqx.theme || "";
		$.jqx.scrollAnimation = $.jqx.scrollAnimation || false;
		$.jqx.resizeDelay = $.jqx.resizeDelay || 10;

		$.jqx.ready = function () {
			$(window).trigger('jqxReady');
		}
		$.jqx.init = function () {
			$.each(arguments[0], function (index, value) {
				if (index == "theme") {
					$.jqx.theme = value;
				}
				if (index == "scrollBarSize") {
					$.jqx.utilities.scrollBarSize = value;
				}
				if (index == "touchScrollBarSize") {
					$.jqx.utilities.touchScrollBarSize = value;
				}
				if (index == "scrollBarButtonsVisibility") {
					$.jqx.utilities.scrollBarButtonsVisibility = value;
				}
			});
		}

		// Utilities
		$.jqx.utilities = $.jqx.utilities || {};
		$.extend($.jqx.utilities,
			{
				scrollBarSize: 13,
				touchScrollBarSize: 8,
				scrollBarButtonsVisibility: "visible",
				createId: function () {
					var S4 = function () {
						return (((1 + Math.random()) * 0x10000) | 0).toString(16).substring(1);
					};
					return "jqxWidget" + S4() + S4() + S4();
				},

				setTheme: function (oldTheme, theme, element) {
					if (typeof element === 'undefined') {
						return;
					}

					if (!element[0].className.split) {
						return;
					}

					if (oldTheme === undefined) {
						oldTheme = '';
					}

					if (theme === undefined) {
						theme = '';
					}

					var classNames = element[0].className.split(' '),
						oldClasses = [], newClasses = [],
						children = element.children();
					for (var i = 0; i < classNames.length; i += 1) {
						if (classNames[i].indexOf(oldTheme) >= 0) {
							if (oldTheme.length > 0) {
								oldClasses.push(classNames[i]);
								newClasses.push(classNames[i].replace(oldTheme, theme));
							}
							else {
								newClasses.push(classNames[i].replace("-" + theme, "") + '-' + theme);
							}
						}
					}
					this._removeOldClasses(oldClasses, element);
					this._addNewClasses(newClasses, element);
					for (var i = 0; i < children.length; i += 1) {
						this.setTheme(oldTheme, theme, $(children[i]));
					}
				},

				_removeOldClasses: function (classes, element) {
					for (var i = 0; i < classes.length; i += 1) {
						element.removeClass(classes[i]);
					}
				},

				_addNewClasses: function (classes, element) {
					for (var i = 0; i < classes.length; i += 1) {
						element.addClass(classes[i]);
					}
				},

				getOffset: function (el) {
					var left = $.jqx.mobile.getLeftPos(el[0]);
					var top = $.jqx.mobile.getTopPos(el[0]);
					return { top: top, left: left };
				},

				resize: function (element, callback, destroy, checkForHidden) {
					if (checkForHidden === undefined) {
						checkForHidden = true;
					}

					var index = -1;
					var that = this;
					var getHiddenIndex = function (element) {
						if (!that.hiddenWidgets) {
							return -1;
						}

						var hiddenIndex = -1;
						for (var i = 0; i < that.hiddenWidgets.length; i++) {
							if (element.id) {
								if (that.hiddenWidgets[i].id == element.id) {
									hiddenIndex = i;
									break;
								}
							}
							else {
								if (that.hiddenWidgets[i].id == element[0].id) {
									hiddenIndex = i;
									break;
								}
							}
						}
						return hiddenIndex;
					}


					if (this.resizeHandlers) {
						for (var i = 0; i < this.resizeHandlers.length; i++) {
							if (element.id) {
								if (this.resizeHandlers[i].id == element.id) {
									index = i;
									break;
								}
							}
							else {
								if (this.resizeHandlers[i].id == element[0].id) {
									index = i;
									break;
								}
							}
						}

						if (destroy === true) {
							if (index != -1) {
								this.resizeHandlers.splice(index, 1);
								if (this.watchedElementData && this.watchedElementData.length > 0) {
									this.watchedElementData.splice(index, 1);
								}
							}

							if (this.resizeHandlers.length == 0) {
								var w = $(window);
								if (w.off) {
									w.off('resize.jqx');
									w.off('orientationchange.jqx');
									w.off('orientationchanged.jqx');
								}
								else {
									w.unbind('resize.jqx');
									w.unbind('orientationchange.jqx');
									w.unbind('orientationchanged.jqx');
								}
								this.resizeHandlers = null;
							}
							var hiddenIndex = getHiddenIndex(element);
							if (hiddenIndex != -1 && this.hiddenWidgets) {
								this.hiddenWidgets.splice(hiddenIndex, 1);
							}
							return;
						}
					}
					else if (destroy === true) {
						var hiddenIndex = getHiddenIndex(element);
						if (hiddenIndex != -1 && this.hiddenWidgets) {
							this.hiddenWidgets.splice(hiddenIndex, 1);
						}
						return;
					}
					var that = this;
					var doResize = function (isHidden, type) {
						if (!that.resizeHandlers)
							return;

						var getParentsCount = function (element) {
							var index = -1;
							var parent = element.parentNode;
							while (parent) {
								index++;
								parent = parent.parentNode;
							}
							return index;
						}

						var compare = function (value1, value2) {
							if (!value1.widget || !value2.widget)
								return 0;

							var parents1 = getParentsCount(value1.widget[0]);
							var parents2 = getParentsCount(value2.widget[0]);

							try {
								if (parents1 < parents2) { return -1; }
								if (parents1 > parents2) { return 1; }
							}
							catch (error) {
								var er = error;
							}

							return 0;
						};
						var handleHiddenWidgets = function (delay) {
							if (that.hiddenWidgets.length > 0) {
								that.hiddenWidgets.sort(compare);
								var updateHiddenWidgets = function () {
									var hasHiddenWidget = false;
									var currentHiddenWidgets = new Array();
									for (var p = 0; p < that.hiddenWidgets.length; p++) {
										var handler = that.hiddenWidgets[p];
										if ($.jqx.isHidden(handler.widget)) {
											hasHiddenWidget = true;
											currentHiddenWidgets.push(handler);
										}
										else {
											if (handler.callback) {
												handler.callback(type);
											}
										}
									}
									that.hiddenWidgets = currentHiddenWidgets;
									if (!hasHiddenWidget) {
										clearInterval(that.__resizeInterval);
									}
								}
								if (delay == false) {
									updateHiddenWidgets();
									if (that.__resizeInterval) clearInterval(that.__resizeInterval);
									return;
								}
								if (that.__resizeInterval) clearInterval(that.__resizeInterval);
								that.__resizeInterval = setInterval(function () {
									updateHiddenWidgets();
								}, 100);
							}
						}

						if (that.hiddenWidgets && that.hiddenWidgets.length > 0) {
							handleHiddenWidgets(false);
						}
						that.hiddenWidgets = new Array();
						that.resizeHandlers.sort(compare);
						for (var i = 0; i < that.resizeHandlers.length; i++) {
							var handler = that.resizeHandlers[i];
							var widget = handler.widget;
							var data = handler.data;
							if (!data) continue;
							if (!data.jqxWidget) continue;

							var width = data.jqxWidget.width;
							var height = data.jqxWidget.height;

							if (data.jqxWidget.base) {
								if (width == undefined) {
									width = data.jqxWidget.base.width;
								}
								if (height == undefined) {
									height = data.jqxWidget.base.height;
								}
							}

							if (width === undefined && height === undefined) {
								width = data.jqxWidget.element.style.width;
								height = data.jqxWidget.element.style.height;
							}

							var percentageSize = false;
							if (width != null && width.toString().indexOf("%") != -1) {
								percentageSize = true;
							}

							if (height != null && height.toString().indexOf("%") != -1) {
								percentageSize = true;
							}

							if ($.jqx.isHidden(widget)) {
								if (getHiddenIndex(widget) === -1) {
									if (percentageSize || isHidden === true) {
										if (handler.data.nestedWidget !== true) {
											that.hiddenWidgets.push(handler);
										}
									}
								}
							}
							else if (isHidden === undefined || isHidden !== true) {
								if (percentageSize) {
									handler.callback(type);
									if (that.watchedElementData) {
										for (var m = 0; m < that.watchedElementData.length; m++) {
											if (that.watchedElementData[m].element == data.jqxWidget.element) {
												that.watchedElementData[m].offsetWidth = data.jqxWidget.element.offsetWidth;
												that.watchedElementData[m].offsetHeight = data.jqxWidget.element.offsetHeight;
												break;
											}
										}
									}
									if (that.hiddenWidgets.indexOf(handler) >= 0) {
										that.hiddenWidgets.splice(that.hiddenWidgets.indexOf(handler), 1);
									}
								}
								if (data.jqxWidget.element) {
									var widgetClass = data.jqxWidget.element.className;
									if (widgetClass.indexOf('dropdownlist') >= 0 || widgetClass.indexOf('datetimeinput') >= 0 || widgetClass.indexOf('combobox') >= 0 || widgetClass.indexOf('menu') >= 0) {
										if (data.jqxWidget.isOpened) {
											var opened = data.jqxWidget.isOpened();
											if (opened) {
												if (type && type == "resize" && $.jqx.mobile.isTouchDevice())
													continue;

												data.jqxWidget.close();
											}
										}
									}
								}
							}
						};

						handleHiddenWidgets();
					}

					if (!this.resizeHandlers) {
						this.resizeHandlers = new Array();

						var w = $(window);
						if (w.on) {
							this._resizeTimer = null;
							this._initResize = null;
							w.on('resize.jqx', function (event) {
								if (that._resizeTimer != undefined) {
									clearTimeout(that._resizeTimer);
								}
								if (!that._initResize) {
									that._initResize = true;
									doResize(null, 'resize');
								}
								else {
									that._resizeTimer = setTimeout(function () {
										doResize(null, 'resize');
									}, $.jqx.resizeDelay);
								}
							});
							w.on('orientationchange.jqx', function (event) {
								doResize(null, 'orientationchange');
							});
							w.on('orientationchanged.jqx', function (event) {
								doResize(null, 'orientationchange');
							});
						}
						else {
							w.bind('resize.jqx', function (event) {
								doResize(null, 'orientationchange');
							});
							w.bind('orientationchange.jqx', function (event) {
								doResize(null, 'orientationchange');
							});
							w.bind('orientationchanged.jqx', function (event) {
								doResize(null, 'orientationchange');
							});
						}
					}
					var elementData = element.data();
					if (checkForHidden) {
						if (index === -1) {
							this.resizeHandlers.push({ id: element[0].id, widget: element, callback: callback, data: elementData });
						}
					}
					try {
						var width = elementData.jqxWidget.width;
						var height = elementData.jqxWidget.height;

						if (elementData.jqxWidget.base) {
							if (width == undefined) {
								width = elementData.jqxWidget.base.width;
							}
							if (height == undefined) {
								height = elementData.jqxWidget.base.height;
							}
						}

						if (width === undefined && height === undefined) {
							width = elementData.jqxWidget.element.style.width;
							height = elementData.jqxWidget.element.style.height;
						}

						var percentageSize = false;
						if (width != null && width.toString().indexOf("%") != -1) {
							percentageSize = true;
						}

						if (height != null && height.toString().indexOf("%") != -1) {
							percentageSize = true;
						}
						if (percentageSize) {
							if (!this.watchedElementData) {
								this.watchedElementData = [];
							}
							var that = this;
							var checkForChanges = function (mutations) {
								if (that.watchedElementData.forEach) {
									that.watchedElementData.forEach(function (data) {
										if (data.element.offsetWidth !== data.offsetWidth ||
											data.element.offsetHeight !== data.offsetHeight) {
											data.offsetWidth = data.element.offsetWidth;
											data.offsetHeight = data.element.offsetHeight;
											if (data.timer) {
												clearTimeout(data.timer);
											}
											data.timer = setTimeout(function () {
												if (!$.jqx.isHidden($(data.element))) {
													data.callback();
												}
												else {
													data.timer = setInterval(function () {
														if (!$.jqx.isHidden($(data.element))) {
															clearInterval(data.timer);
															data.callback();
														}
													}, 100);
												}
											});
										}
									});
								}
							};

							that.watchedElementData.push({
								element: element[0],
								offsetWidth: element[0].offsetWidth,
								offsetHeight: element[0].offsetHeight,
								callback: callback
							});
							if (!that.observer) {
								that.observer = new MutationObserver(checkForChanges);
								that.observer.observe(document.body, {
									attributes: true,
									childList: true,
									characterData: true
								});
							}
						}
					}
					catch (er) {
					}
					if ($.jqx.isHidden(element) && checkForHidden === true) {
						doResize(true);
					}
					$.jqx.resize = function () {
						doResize(null, 'resize');
					}
				},

				parseJSON: function (data) {
					if (!data || typeof data !== "string") {
						return null;
					}
					var rvalidchars = /^[\],:{}\s]*$/,
						rvalidbraces = /(?:^|:|,)(?:\s*\[)+/g,
						rvalidescape = /\\(?:["\\\/bfnrt]|u[\da-fA-F]{4})/g,
						rvalidtokens = /"[^"\\\r\n]*"|true|false|null|-?(?:\d\d*\.|)\d+(?:[eE][\-+]?\d+|)/g;

					// Make sure leading/trailing whitespace is removed (IE can't handle it)
					data = $.trim(data);

					// Attempt to parse using the native JSON parser first
					if (window.JSON && window.JSON.parse) {
						return window.JSON.parse(data);
					}

					// Make sure the incoming data is actual JSON
					// Logic borrowed from http://json.org/json2.js
					if (rvalidchars.test(data.replace(rvalidescape, "@")
						.replace(rvalidtokens, "]")
						.replace(rvalidbraces, ""))) {

						return (new Function("return " + data))();

					}
					throw new Error("Invalid JSON: " + data);
				},

				html: function (element, value) {
					if (!$(element).on || !$.access) {
						return $(element).html(value);
					}
					try {	
						return $.access(element, function (value) {
							var elem = element[0] || {},
								i = 0,
								l = element.length;

							if (value === undefined) {
								return elem.nodeType === 1 ?
									elem.innerHTML.replace(rinlinejQuery, "") :
									undefined;
							}

							var rnoInnerhtml = /<(?:script|style|link)/i,
								nodeNames = "abbr|article|aside|audio|bdi|canvas|data|datalist|details|figcaption|figure|footer|" +
									"header|hgroup|mark|meter|nav|output|progress|section|summary|time|video",
								rxhtmlTag = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\w:]+)[^>]*)\/>/gi,
								rtagName = /<([\w:]+)/,
								rnocache = /<(?:script|object|embed|option|style)/i,
								rnoshimcache = new RegExp("<(?:" + nodeNames + ")[\\s/>]", "i"),
								rleadingWhitespace = /^\s+/,
								wrapMap = {
									option: [1, "<select multiple='multiple'>", "</select>"],
									legend: [1, "<fieldset>", "</fieldset>"],
									thead: [1, "<table>", "</table>"],
									tr: [2, "<table><tbody>", "</tbody></table>"],
									td: [3, "<table><tbody><tr>", "</tr></tbody></table>"],
									col: [2, "<table><tbody></tbody><colgroup>", "</colgroup></table>"],
									area: [1, "<map>", "</map>"],
									_default: [0, "", ""]
								};

							if (typeof value === "string" && !rnoInnerhtml.test(value) &&
								($.support.htmlSerialize || !rnoshimcache.test(value)) &&
								($.support.leadingWhitespace || !rleadingWhitespace.test(value)) &&
								!wrapMap[(rtagName.exec(value) || ["", ""])[1].toLowerCase()]) {

								value = value.replace(rxhtmlTag, "<$1></$2>");

								try {
									for (; i < l; i++) {
										elem = this[i] || {};
										if (elem.nodeType === 1) {
											$.cleanData(elem.getElementsByTagName("*"));
											elem.innerHTML = value;
										}
									}

									elem = 0;
								} catch (e) { }
							}

							if (elem) {
								element.empty().append(value);
							}
						}, null, value, arguments.length);
					}
					catch (error) {
						return $(element).html(value);
					}
				},

				hasTransform: function (el) {
					var transform = "";
					transform = el.css('transform');

					if (transform == "" || transform == 'none') {
						transform = el.parents().css('transform');
						if (transform == "" || transform == 'none') {
							var browserInfo = $.jqx.utilities.getBrowser();
							if (browserInfo.browser == 'msie') {
								transform = el.css('-ms-transform');
								if (transform == "" || transform == 'none') {
									transform = el.parents().css('-ms-transform');
								}
							}
							else if (browserInfo.browser == 'chrome') {
								transform = el.css('-webkit-transform');
								if (transform == "" || transform == 'none') {
									transform = el.parents().css('-webkit-transform');
								}
							}
							else if (browserInfo.browser == 'opera') {
								transform = el.css('-o-transform');
								if (transform == "" || transform == 'none') {
									transform = el.parents().css('-o-transform');
								}
							}
							else if (browserInfo.browser == 'mozilla') {
								transform = el.css('-moz-transform');
								if (transform == "" || transform == 'none') {
									transform = el.parents().css('-moz-transform');
								}
							}
						} else {
							return transform != "" && transform != 'none';
						}
					}
					if (transform == "" || transform == 'none') {
						transform = $(document.body).css('transform');
					}
					return transform != "" && transform != 'none' && transform != null;
				},

				getBrowser: function () {
					var ua = navigator.userAgent.toLowerCase();

					var match = /(chrome)[ \/]([\w.]+)/.exec(ua) ||
						/(webkit)[ \/]([\w.]+)/.exec(ua) ||
						/(opera)(?:.*version|)[ \/]([\w.]+)/.exec(ua) ||
						/(msie) ([\w.]+)/.exec(ua) ||
						ua.indexOf("compatible") < 0 && /(mozilla)(?:.*? rv:([\w.]+)|)/.exec(ua) ||
						[];

					var obj = {
						browser: match[1] || "",
						version: match[2] || "0"
					};
					if (ua.indexOf("rv:11.0") >= 0 && ua.indexOf(".net4.0c") >= 0) {
						obj.browser = "msie";
						obj.version = "11";
						match[1] = "msie";
					}
					if (ua.indexOf("edge") >= 0) {
						obj.browser = "msie";
						obj.version = "12";
						match[1] = "msie";
					}
					obj[match[1]] = match[1];
					return obj;
				}
			});
		$.jqx.browser = $.jqx.utilities.getBrowser();
		$.jqx.isHidden = function (element) {
			if (!element || !element[0])
				return false;

			var w = element[0].offsetWidth, h = element[0].offsetHeight;
			if (w === 0 || h === 0)
				return true;
			else {
				return false;
			}
		};

		$.jqx.ariaEnabled = true;
		$.jqx.aria = function (that, property, value) {
			if (!$.jqx.ariaEnabled)
				return;

			if (property == undefined) {
				$.each(that.aria, function (index, value) {
					var attrValue = !that.base ? that.host.attr(index) : that.base.host.attr(index);
					if (attrValue != undefined && !$.isFunction(attrValue)) {
						var newValue = attrValue;
						switch (value.type) {
							case "number":
								newValue = new Number(attrValue);
								if (isNaN(newValue)) newValue = attrValue;
								break;
							case "boolean":
								newValue = attrValue == "true" ? true : false;
								break;
							case "date":
								newValue = new Date(attrValue);
								if (newValue == "Invalid Date" || isNaN(newValue)) newValue = attrValue;
								break;
						}

						that[value.name] = newValue;
					}
					else {
						var attrValue = that[value.name];
						if ($.isFunction(attrValue)) attrValue = that[value.name]();
						if (attrValue == undefined) attrValue = "";
						try {
							!that.base ? that.host.attr(index, attrValue.toString()) : that.base.host.attr(index, attrValue.toString());
						}
						catch (error) {
						}
					}
				});
			}
			else {
				try {
					if (that.host) {
						if (!that.base) {
							if (that.host) {
								if (that.element.setAttribute) {
									that.element.setAttribute(property, value.toString());
								}
								else {
									that.host.attr(property, value.toString());
								}
							}
							else {
								that.attr(property, value.toString());
							}
						}
						else {
							if (that.base.host) {
								that.base.host.attr(property, value.toString());
							}
							else {
								that.attr(property, value.toString());
							}
						}
					}
					else if (that.setAttribute) {
						that.setAttribute(property, value.toString());
					}
				}
				catch (error) {
				}
			}
		};

		if (!Array.prototype.indexOf) {
			Array.prototype.indexOf = function (elt /*, from*/) {
				var len = this.length;

				var from = Number(arguments[1]) || 0;
				from = (from < 0)
					? Math.ceil(from)
					: Math.floor(from);
				if (from < 0)
					from += len;

				for (; from < len; from++) {
					if (from in this &&
						this[from] === elt)
						return from;
				}
				return -1;
			};
		}

		$.jqx.mobile = $.jqx.mobile || {};
		$.jqx.position = function (event) {
			var left = parseInt(event.pageX);
			var top = parseInt(event.pageY);

			if ($.jqx.mobile.isTouchDevice()) {
				var touches = $.jqx.mobile.getTouches(event);
				var touch = touches[0];
				left = parseInt(touch.pageX);
				top = parseInt(touch.pageY);
			}
			return { left: left, top: top }
		}

		$.extend($.jqx.mobile,
			{
				_touchListener: function (e, me) {
					var createTouchEvent = function (name, e) {
						var event = document.createEvent('MouseEvents');

						event.initMouseEvent(
							name,
							e.bubbles,
							e.cancelable,
							e.view,
							e.detail,
							e.screenX,
							e.screenY,
							e.clientX,
							e.clientY,
							e.ctrlKey,
							e.altKey,
							e.shiftKey,
							e.metaKey,
							e.button,
							e.relatedTarget
						);
						event._pageX = e.pageX;
						event._pageY = e.pageY;

						return event;
					}

					var eventMap = { 'mousedown': 'touchstart', 'mouseup': 'touchend', 'mousemove': 'touchmove' };
					var event = createTouchEvent(eventMap[e.type], e);
					e.target.dispatchEvent(event);

					var fn = e.target['on' + eventMap[e.type]];
					if (typeof fn === 'function') fn(e);
				},

				setMobileSimulator: function (element, value) {
					if (this.isTouchDevice()) {
						return;
					}

					this.simulatetouches = true;
					if (value == false) {
						this.simulatetouches = false;
					}

					var eventMap = { 'mousedown': 'touchstart', 'mouseup': 'touchend', 'mousemove': 'touchmove' };

					var self = this;
					if (window.addEventListener) {
						var subscribeToEvents = function () {
							for (var key in eventMap) {
								if (element.addEventListener) {
									element.removeEventListener(key, self._touchListener);
									element.addEventListener(key, self._touchListener, false);
								}

								//  document.removeEventListener(key, self._touchListener);
								//  document.addEventListener(key, self._touchListener, false);
							}
						}

						if ($.jqx.browser.msie) {
							subscribeToEvents();
						}
						else {
							subscribeToEvents();
						}
					}
				},

				isTouchDevice: function () {
					if (this.touchDevice != undefined)
						return this.touchDevice;

					var txt = "Browser CodeName: " + navigator.appCodeName + "";
					txt += "Browser Name: " + navigator.appName + "";
					txt += "Browser Version: " + navigator.appVersion + "";
					txt += "Platform: " + navigator.platform + "";
					txt += "User-agent header: " + navigator.userAgent + "";

					if (navigator.maxTouchPoints > 1) {
						//return true;
					}

					if (txt.indexOf('Android') != -1)
						return true;

					if (txt.indexOf('IEMobile') != -1)
						return true;

					if (txt.indexOf('Windows Phone') != -1)
						return true;

					if (txt.indexOf('WPDesktop') != -1)
						return true;

					if (txt.indexOf('ZuneWP7') != -1)
						return true;

					if (txt.indexOf('BlackBerry') != -1 && txt.indexOf('Mobile Safari') != -1)
						return true;

					if (txt.indexOf('ipod') != -1)
						return true;

					if (txt.indexOf('nokia') != -1 || txt.indexOf('Nokia') != -1)
						return true;

					if (txt.indexOf('Chrome/17') != -1)
						return false;

					if (txt.indexOf('CrOS') != -1)
						return false;

					if (txt.indexOf('Opera') != -1 && txt.indexOf('Mobi') == -1 && txt.indexOf('Mini') == -1 && txt.indexOf('Platform: Win') != -1) {
						return false;
					}

					if (txt.indexOf("HybridDeviceTouch") != -1) {
						return true
					}

					if (txt.indexOf("HybridDeviceMouse") != -1) {
						return false
					}

					if (txt.indexOf('Opera') != -1 && txt.indexOf('Mobi') != -1 && txt.indexOf('Opera Mobi') != -1) {
						return true;
					}

					if (txt.indexOf('Mozilla/5.0 (X11; Linux x86_64)') != -1) {
						return false;
					}

					var deviceTypes = {
						ios: 'i(?:Pad|Phone|Pod)(?:.*)CPU(?: iPhone)? OS ',
						android: '(Android |HTC_|Silk/)',
						blackberry: 'BlackBerry(?:.*)Version\/',
						rimTablet: 'RIM Tablet OS ',
						webos: '(?:webOS|hpwOS)\/',
						bada: 'Bada\/'
					}

					// check for IPad, IPhone, IE and Chrome
					try {
						if (this.touchDevice != undefined)
							return this.touchDevice;

						this.touchDevice = false;
						for (var i in deviceTypes) {
							if (deviceTypes.hasOwnProperty(i)) {
								var prefix = deviceTypes[i];
								var match = txt.match(new RegExp('(?:' + prefix + ')([^\\s;]+)'));
								if (match) {
									if (i.toString() == "blackberry") {
										// handle touches through mouse pointer.
										this.touchDevice = false;
										return false;
									}

									this.touchDevice = true;
									return true;
								}
							}
						}

						var userAgent = navigator.userAgent;
						if (navigator.platform.toLowerCase().indexOf('win') != -1) {
							if (userAgent.indexOf('Windows Phone') >= 0 || userAgent.indexOf('WPDesktop') >= 0 || userAgent.indexOf('IEMobile') >= 0 || userAgent.indexOf('ZuneWP7') >= 0) {
								this.touchDevice = true;
								return true;
							}
							else {
								if (userAgent.indexOf('Touch') >= 0) {
									var supported = ('MSPointerDown' in window) || ('pointerdown' in window);
									if (supported) {
										this.touchDevice = true;
										return true;
									}
									if (userAgent.indexOf('ARM') >= 0) {
										this.touchDevice = true;
										return true;
									}

									this.touchDevice = false;
									return false;
								}
							}
						}

						if (navigator.platform.toLowerCase().indexOf('win') != -1) {
							this.touchDevice = false;
							return false;
						}
						if (('ontouchstart' in window) || window.DocumentTouch && document instanceof DocumentTouch) {
							this.touchDevice = true;
						}
						return this.touchDevice;
					} catch (e) {
						this.touchDevice = false;
						return false;
					}
				},

				getLeftPos: function (inputObj) {
					var returnValue = inputObj.offsetLeft;
					while ((inputObj = inputObj.offsetParent) != null) {
						if (inputObj.tagName != 'HTML') {
							returnValue += inputObj.offsetLeft;
							if (document.all) returnValue += inputObj.clientLeft;
						}
					}
					return returnValue;
				},

				getTopPos: function (inputObj) {
					var returnValue = inputObj.offsetTop;
					var initialOffset = $(inputObj).coord();
					while ((inputObj = inputObj.offsetParent) != null) {
						if (inputObj.tagName != 'HTML') {
							returnValue += (inputObj.offsetTop - inputObj.scrollTop);
							if (document.all) returnValue += inputObj.clientTop;
						}
					}
					var agent = navigator.userAgent.toLowerCase();
					var wp8 = (agent.indexOf('windows phone') != -1 || agent.indexOf('WPDesktop') != -1 || agent.indexOf('ZuneWP7') != -1 || agent.indexOf('msie 9') != -1 || agent.indexOf('msie 11') != -1 || agent.indexOf('msie 10') != -1) && agent.indexOf('touch') != -1;
					if (wp8) {
						return initialOffset.top;
					}

					if (this.isSafariMobileBrowser()) {
						if (this.isSafari4MobileBrowser() && this.isIPadSafariMobileBrowser()) {
							return returnValue;
						}
						if (agent.indexOf('version/7') != -1) {
							return initialOffset.top;
						}
						if (agent.indexOf('version/6') != -1 || agent.indexOf('version/5') != -1) {
							returnValue = returnValue + $(window).scrollTop();
						}
						if (/(Android.*Chrome\/[.0-9]* (!?Mobile))/.exec(navigator.userAgent)) {
							 return returnValue;
					//       return returnValue + $(window).scrollTop();
						}
						if (/(Android.*Chrome\/[.0-9]* Mobile)/.exec(navigator.userAgent)) {
							return returnValue;
					//        return returnValue + $(window).scrollTop();
						}

						return initialOffset.top;
					}

					return returnValue;
				},

				isChromeMobileBrowser: function () {
					var agent = navigator.userAgent.toLowerCase();
					var result = agent.indexOf('android') != -1;
					return result;
				},

				isOperaMiniMobileBrowser: function () {
					var agent = navigator.userAgent.toLowerCase();
					var result = agent.indexOf('opera mini') != -1 || agent.indexOf('opera mobi') != -1;
					return result;
				},

				isOperaMiniBrowser: function () {
					var agent = navigator.userAgent.toLowerCase();
					var result = agent.indexOf('opera mini') != -1;
					return result;
				},

				isNewSafariMobileBrowser: function () {
					var agent = navigator.userAgent.toLowerCase();
					var result = agent.indexOf('ipad') != -1 || agent.indexOf('iphone') != -1 || agent.indexOf('ipod') != -1;
					result = result && (agent.indexOf('version/5') != -1);
					return result;
				},

				isSafari4MobileBrowser: function () {
					var agent = navigator.userAgent.toLowerCase();
					var result = agent.indexOf('ipad') != -1 || agent.indexOf('iphone') != -1 || agent.indexOf('ipod') != -1;
					result = result && (agent.indexOf('version/4') != -1);
					return result;
				},

				isWindowsPhone: function () {
					var agent = navigator.userAgent.toLowerCase();
					var result = (agent.indexOf('windows phone') != -1 || agent.indexOf('WPDesktop') != -1 || agent.indexOf('ZuneWP7') != -1 || agent.indexOf('msie 9') != -1 || agent.indexOf('msie 11') != -1 || agent.indexOf('msie 10') != -1 && agent.indexOf('touch') != -1);
					return result;
				},

				isSafariMobileBrowser: function () {
					var agent = navigator.userAgent.toLowerCase();
					if (/(Android.*Chrome\/[.0-9]* (!?Mobile))/.exec(navigator.userAgent)) {
						return true;
					}
					if (/(Android.*Chrome\/[.0-9]* Mobile)/.exec(navigator.userAgent)) {
						return true;
					}

					var result = agent.indexOf('ipad') != -1 || agent.indexOf('iphone') != -1 || agent.indexOf('ipod') != -1 || agent.indexOf('mobile safari') != -1;
					return result;
				},

				isIPadSafariMobileBrowser: function () {
					var agent = navigator.userAgent.toLowerCase();
					var result = agent.indexOf('ipad') != -1;
					return result;
				},

				isMobileBrowser: function () {
					var agent = navigator.userAgent.toLowerCase();
					var result = agent.indexOf('ipad') != -1 || agent.indexOf('iphone') != -1 || agent.indexOf('android') != -1;
					return result;
				},

				// Get the touch points from this event
				getTouches: function (e) {
					if (e.originalEvent) {
						if (e.originalEvent.touches && e.originalEvent.touches.length) {
							return e.originalEvent.touches;
						} else if (e.originalEvent.changedTouches && e.originalEvent.changedTouches.length) {
							return e.originalEvent.changedTouches;
						}
					}

					if (!e.touches) {
						e.touches = new Array();
						e.touches[0] = e.originalEvent != undefined ? e.originalEvent : e;

						if (e.originalEvent != undefined && e.pageX)
							e.touches[0] = e;
						if (e.type == 'mousemove') e.touches[0] = e;
					}

					return e.touches;
				},

				getTouchEventName: function (name) {
					if (this.isWindowsPhone()) {

						var agent = navigator.userAgent.toLowerCase();
						if (agent.indexOf('windows phone 7') != -1) {
							if (name.toLowerCase().indexOf('start') != -1) return 'MSPointerDown';
							if (name.toLowerCase().indexOf('move') != -1) return 'MSPointerMove';
							if (name.toLowerCase().indexOf('end') != -1) return 'MSPointerUp';
						}
						if (name.toLowerCase().indexOf('start') != -1) return 'pointerdown';
						if (name.toLowerCase().indexOf('move') != -1) return 'pointermove';
						if (name.toLowerCase().indexOf('end') != -1) return 'pointerup';
					}
					else {
						return name;
					}
				},

				// Dispatches a fake mouse event from a touch event
				dispatchMouseEvent: function (name, touch, target) {
					if (this.simulatetouches)
						return;

					var e = document.createEvent('MouseEvent');
					e.initMouseEvent(name, true, true, touch.view, 1, touch.screenX, touch.screenY, touch.clientX, touch.clientY, false, false, false, false, 0, null);
					if (target != null) {
						target.dispatchEvent(e);
					}
				},

				// Find the root node of this target
				getRootNode: function (target) {
					while (target.nodeType !== 1) {
						target = target.parentNode;
					}
					return target;
				},

				setTouchScroll: function (enable, key) {
					if (!this.enableScrolling) this.enableScrolling = [];
					this.enableScrolling[key] = enable;
				},

				touchScroll: function (element, scrollHeight, callback, key, horizontalScroll, verticalScroll) {
					if (element == null)
						return;

					var me = this;
					var scrollY = 0;
					var touchY = 0;
					var movedY = 0;
					var scrollX = 0;
					var touchX = 0;
					var movedX = 0;
					if (!this.scrolling) this.scrolling = [];
					this.scrolling[key] = false;
					var moved = false;
					var $element = $(element);
					var touchTags = ['select', 'input', 'textarea'];
					var touchStart = 0;
					var touchEnd = 0;
					if (!this.enableScrolling) this.enableScrolling = [];
					this.enableScrolling[key] = true;
					var key = key;
					var touchStartName = this.getTouchEventName('touchstart') + ".touchScroll";
					var touchEndName = this.getTouchEventName('touchend') + ".touchScroll";
					var touchMoveName = this.getTouchEventName('touchmove') + ".touchScroll";

					//            horizontalScroll.fadeOut(0);
					//            verticalScroll.fadeOut(0);

					var view, indicator, relative, xframe, xdelta,
						xmax, min, max, offset, reference, pressed, xform,
						jqxAnimations, xjqxAnimations, frame, timestamp, ticker,
						amplitude, target, xtarget, xreference, timeConstant;
					max = scrollHeight;
					var min = 0;
					var offset = 0;
					var xoffset = 0;
					var initialOffset = 0;
					var initialXOffset = 0;
					var xmax = horizontalScroll.jqxScrollBar('max');
					var timeConstant = 325; // ms

					function ypos(e) {
						// touch event
						if (e.targetTouches && (e.targetTouches.length >= 1)) {
							return e.targetTouches[0].clientY;
						}
						else if (e.originalEvent && e.originalEvent.clientY !== undefined) {
							return e.originalEvent.clientY;
						}
						else {
							var touches = me.getTouches(e);
							return touches[0].clientY;
						}

						// mouse event
						//    return e.clientY;
					}

					function xpos(e) {
						// touch event
						if (e.targetTouches && (e.targetTouches.length >= 1)) {
							return e.targetTouches[0].clientX;
						}
						else if (e.originalEvent && e.originalEvent.clientX !== undefined) {
							return e.originalEvent.clientX;
						}
						else {
							var touches = me.getTouches(e);
							return touches[0].clientX;
						}

						// mouse event
						//   return e.clientX;
					}

					var track = function () {
						var now, elapsed, delta, v;

						now = Date.now();
						elapsed = now - timestamp;
						timestamp = now;
						delta = offset - frame;
						var xdelta = xoffset - xframe;
						frame = offset;
						xframe = xoffset;
						pressed = true;
						v = 1000 * delta / (1 + elapsed);
						var xv = 1000 * xdelta / (1 + elapsed);
						jqxAnimations = 0.8 * v + 0.2 * jqxAnimations;
						xjqxAnimations = 0.8 * xv + 0.2 * xjqxAnimations;
					}

					var tapped = false;

					var touchStart = function (event) {
						if (!me.enableScrolling[key])
							return true;

						// Allow certain HTML tags to receive touch events
						if ($.inArray(event.target.tagName.toLowerCase(), touchTags) !== -1) {
							return;
						}
						offset = verticalScroll.jqxScrollBar('value');
						xoffset = horizontalScroll.jqxScrollBar('value');

						var touches = me.getTouches(event);
						var touch = touches[0];
						if (touches.length == 1) {
							me.dispatchMouseEvent('mousedown', touch, me.getRootNode(touch.target));
						}
						xmax = horizontalScroll.jqxScrollBar('max');
						max = verticalScroll.jqxScrollBar('max');
						function tap(e) {
							tapped = false;
							pressed = true;
							reference = ypos(e);
							xreference = xpos(e);
							jqxAnimations = amplitude = xjqxAnimations = 0;
							frame = offset;
							xframe = xoffset;
							timestamp = Date.now();
							clearInterval(ticker);
							ticker = setInterval(track, 100);
							initialOffset = offset;
							initialXOffset = xoffset;

							if (offset > 0 && offset < max && verticalScroll[0].style.visibility != "hidden") {
								//      e.preventDefault();
							}
							//    if (xoffset > 0 && xoffset < xmax && horizontalScroll[0].style.visibility != "hidden") {
							//        e.preventDefault();

							//      e.stopPropagation();
							//   e.stopPropagation();
							// return false;
						}

						tap(event);
						moved = false;
						touchY = touch.pageY;
						touchX = touch.pageX;
						if (me.simulatetouches) {
							if (touch._pageY != undefined) {
								touchY = touch._pageY;
								touchX = touch._pageX;
							}
						}
						me.scrolling[key] = true;
						scrollY = 0;
						scrollX = 0;
						return true;
					}

					if ($element.on) {
						$element.on(touchStartName, touchStart);
					}
					else {
						$element.bind(touchStartName, touchStart);
					}

					var scroll = function (top, event) {
						offset = (top > max) ? max : (top < min) ? min : top;
						callback(null, top, 0, 0, event);

						return (top > max) ? "max" : (top < min) ? "min" : "value";
					}

					var hscroll = function (left, event) {
						xoffset = (left > xmax) ? xmax : (left < min) ? min : left;
						callback(left, null, 0, 0, event);

						return (left > xmax) ? "max" : (left < min) ? "min" : "value";
					}

					function autoScroll() {
						var elapsed, delta;
						if (amplitude) {
							elapsed = Date.now() - timestamp;
							delta = -amplitude * Math.exp(-elapsed / timeConstant);
							if (delta > 0.5 || delta < -0.5) {
								scroll(target + delta);
								requestAnimationFrame(autoScroll);
							} else {
								scroll(target);
								//     verticalScroll.fadeOut('fast');
							}
						}
					}
					function hAutoScroll() {
						var elapsed, delta;
						if (amplitude) {
							elapsed = Date.now() - timestamp;
							delta = -amplitude * Math.exp(-elapsed / timeConstant);
							if (delta > 0.5 || delta < -0.5) {
								hscroll(xtarget + delta);
								requestAnimationFrame(hAutoScroll);
							} else {
								hscroll(xtarget);
								//        horizontalScroll.fadeOut('fast');
							}

						}
					}
					var touchMove = function (event) {
						if (!me.enableScrolling[key])
							return true;

						if (!me.scrolling[key]) {
							return true;
						}

						if (tapped) {
							event.preventDefault();
							event.stopPropagation();
						}

						var touches = me.getTouches(event);
						if (touches.length > 1) {
							return true;
						}

						var pageY = touches[0].pageY;
						var pageX = touches[0].pageX;

						if (me.simulatetouches) {
							if (touches[0]._pageY != undefined) {
								pageY = touches[0]._pageY;
								pageX = touches[0]._pageX;
							}
						}


						var dy = pageY - touchY;
						var dx = pageX - touchX;
						touchEnd = pageY;
						var touchHorizontalEnd = pageX;
						movedY = dy - scrollY;
						movedX = dx - scrollX;
						moved = true;
						scrollY = dy;
						scrollX = dx;

						var hScrollVisible = horizontalScroll != null ? horizontalScroll[0].style.visibility != 'hidden' : true;
						var vScrollVisible = verticalScroll != null ? verticalScroll[0].style.visibility != 'hidden' : true;


						function drag(e) {
							var y, delta, x;
							if (pressed) {
								y = ypos(e);
								x = xpos(e);
								delta = reference - y;
								xdelta = xreference - x;
								var dragged = "value";
								if (delta > 2 || delta < -2) {
									reference = y;
									dragged = scroll(offset + delta, e);
									track();

									if (dragged == "min" && initialOffset === 0) {
										return true;
									}
									if (dragged == "max" && initialOffset === max) {
										return true;
									}

									if (!vScrollVisible) {
										return true;
									}
									e.preventDefault();
									e.stopPropagation();
									tapped = true;

									return false;
								}
								else {
									if (xdelta > 2 || xdelta < -2) {
										xreference = x;
										dragged = hscroll(xoffset + xdelta, e);
										track();

										if (dragged == "min" && initialXOffset === 0) {
											return true;
										}
										if (dragged == "max" && initialXOffset === xmax) {
											return true;
										}

										if (!hScrollVisible) {
											return true;
										}
										tapped = true;
										e.preventDefault();
										e.stopPropagation();
										return false;
									}
								}
								e.preventDefault();
							}
						}

						if (hScrollVisible || vScrollVisible) {
							if ((hScrollVisible) || (vScrollVisible)) {
								drag(event);

								//      callback(-movedX * 1, -movedY * 1, dx, dy, event);
								//event.preventDefault();
								//event.stopPropagation();
								//if (event.preventManipulation) {
								//    event.preventManipulation();
								//}
								//return false;
							}
						}
					}

					if ($element.on) {
						$element.on(touchMoveName, touchMove);
					}
					else $element.bind(touchMoveName, touchMove);



					var touchCancel = function (event) {
						if (!me.enableScrolling[key])
							return true;

						var touch = me.getTouches(event)[0];
						if (!me.scrolling[key]) {
							return true;
						}

						pressed = false;
						clearInterval(ticker);
						if (jqxAnimations > 10 || jqxAnimations < -10) {
							amplitude = 0.8 * jqxAnimations;
							target = Math.round(offset + amplitude);
							timestamp = Date.now();
							requestAnimationFrame(autoScroll);
							//             verticalScroll.fadeIn(100);
						}
						else if (xjqxAnimations > 10 || xjqxAnimations < -10) {
							amplitude = 0.8 * xjqxAnimations;
							xtarget = Math.round(xoffset + amplitude);
							timestamp = Date.now();
							requestAnimationFrame(hAutoScroll);
							//          horizontalScroll.fadeIn(100);
						}
						else {
							//        horizontalScroll.fadeOut(100);
							//        verticalScroll.fadeOut(100);
						}

						me.scrolling[key] = false;
						if (moved) {
							me.dispatchMouseEvent('mouseup', touch, event.target);
						} else {
							var touch = me.getTouches(event)[0],
								t = me.getRootNode(touch.target);

							//        event.preventDefault();
							//         event.stopPropagation();
							// Dispatch fake mouse up and click events if this touch event did not move
							me.dispatchMouseEvent('mouseup', touch, t);
							me.dispatchMouseEvent('click', touch, t);
							return true;
						}
					}

					if (this.simulatetouches) {
						var windowBindFunc = $(window).on != undefined || $(window).bind;
						var windowMouseUp = function (event) {
							try {
								touchCancel(event);
							}
							catch (er) {
							}
							me.scrolling[key] = false;
						};
						$(window).on != undefined ? $(document).on('mouseup.touchScroll', windowMouseUp) : $(document).bind('mouseup.touchScroll', windowMouseUp);

						if (window.frameElement) {
							if (window.top != null) {
								var eventHandle = function (event) {
									try {
										touchCancel(event);
									}
									catch (er) {
									}
									me.scrolling[key] = false;
								};

								if (window.top.document) {
									$(window.top.document).on ? $(window.top.document).on('mouseup', eventHandle) : $(window.top.document).bind('mouseup', eventHandle);
								}
							}
						}

						var docBindFunc = $(document).on != undefined || $(document).bind;
						var touchEndFunc = function (event) {
							if (!me.scrolling[key]) {
								return true;
							}

							me.scrolling[key] = false;
							var touch = me.getTouches(event)[0],
								target = me.getRootNode(touch.target);

							// Dispatch fake mouse up and click events if this touch event did not move
							me.dispatchMouseEvent('mouseup', touch, target);
							me.dispatchMouseEvent('click', touch, target);
						};

						$(document).on != undefined ? $(document).on('touchend', touchEndFunc) : $(document).bind('touchend', touchEndFunc);
					}

					if ($element.on) {
						$element.on('dragstart', function (event) {
							event.preventDefault();
						});
						$element.on('selectstart', function (event) {
							event.preventDefault();
						});
					}
					$element.on ? $element.on(touchEndName + ' touchcancel.touchScroll', touchCancel) : $element.bind(touchEndName + ' touchcancel.touchScroll', touchCancel);
				}

			});

		$.jqx.cookie = $.jqx.cookie || {};
		$.extend($.jqx.cookie,
			{
				cookie: function (key, value, options) {
					// set cookie.
					if (arguments.length > 1 && String(value) !== "[object Object]") {
						options = $.extend({}, options);

						if (value === null || value === undefined) {
							options.expires = -1;
						}

						if (typeof options.expires === 'number') {
							var days = options.expires, t = options.expires = new Date();
							t.setDate(t.getDate() + days);
						}

						value = String(value);

						return (document.cookie = [
							encodeURIComponent(key), '=',
							options.raw ? value : encodeURIComponent(value),
							options.expires ? '; expires=' + options.expires.toUTCString() : '', // use expires attribute, max-age is not supported by IE
							options.path ? '; path=' + options.path : '',
							options.domain ? '; domain=' + options.domain : '',
							options.secure ? '; secure' : ''
						].join(''));
					}
					// get cookie...
					options = value || {};
					var result, decode = options.raw ? function (s) { return s; } : decodeURIComponent;
					return (result = new RegExp('(?:^|; )' + encodeURIComponent(key) + '=([^;]*)').exec(document.cookie)) ? decode(result[1]) : null;
				}
			});

		// stringutilities
		$.jqx.string = $.jqx.string || {};
		$.extend($.jqx.string,
			{
				replace: function (text, stringToFind, stringToReplace) {
					if (stringToFind === stringToReplace) return this;
					var temp = text;
					var index = temp.indexOf(stringToFind);
					while (index != -1) {
						temp = temp.replace(stringToFind, stringToReplace);
						index = temp.indexOf(stringToFind);
					}
					return temp;
				},

				contains: function (fullString, value) {
					if (fullString == null || value == null)
						return false;

					return fullString.indexOf(value) != -1;
				},

				containsIgnoreCase: function (fullString, value) {
					if (fullString == null || value == null)
						return false;

					return fullString.toString().toUpperCase().indexOf(value.toString().toUpperCase()) != -1;
				},

				equals: function (fullString, value) {
					if (fullString == null || value == null)
						return false;

					fullString = this.normalize(fullString);

					if (value.length == fullString.length) {
						return fullString.slice(0, value.length) == value;
					}

					return false;
				},

				equalsIgnoreCase: function (fullString, value) {
					if (fullString == null || value == null)
						return false;

					fullString = this.normalize(fullString);

					if (value.length == fullString.length) {
						return fullString.toUpperCase().slice(0, value.length) == value.toUpperCase();
					}

					return false;
				},

				startsWith: function (fullString, value) {
					if (fullString == null || value == null)
						return false;

					return fullString.slice(0, value.length) == value;
				},

				startsWithIgnoreCase: function (fullString, value) {
					if (fullString == null || value == null)
						return false;

					return fullString.toUpperCase().slice(0, value.length) == value.toUpperCase();
				},

				normalize: function (fullString) {
					if (fullString.charCodeAt(fullString.length - 1) == 65279) {
						fullString = fullString.substring(0, fullString.length - 1);
					}

					return fullString;
				},

				endsWith: function (fullString, value) {
					if (fullString == null || value == null)
						return false;

					fullString = this.normalize(fullString);
					return fullString.slice(-value.length) == value;
				},

				endsWithIgnoreCase: function (fullString, value) {
					if (fullString == null || value == null)
						return false;

					fullString = this.normalize(fullString);

					return fullString.toUpperCase().slice(-value.length) == value.toUpperCase();
				}
			});

		$.extend($.easing, {
			easeOutBack: function (x, t, b, c, d, s) {
				if (s == undefined) s = 1.70158;
				return c * ((t = t / d - 1) * t * ((s + 1) * t + s) + 1) + b;
			},
			easeInQuad: function (x, t, b, c, d) {
				return c * (t /= d) * t + b;
			},
			easeInOutCirc: function (x, t, b, c, d) {
				if ((t /= d / 2) < 1) return -c / 2 * (Math.sqrt(1 - t * t) - 1) + b;
				return c / 2 * (Math.sqrt(1 - (t -= 2) * t) + 1) + b;
			},
			easeInOutSine: function (x, t, b, c, d) {
				return -c / 2 * (Math.cos(Math.PI * t / d) - 1) + b;
			},
			easeInCubic: function (x, t, b, c, d) {
				return c * (t /= d) * t * t + b;
			},
			easeOutCubic: function (x, t, b, c, d) {
				return c * ((t = t / d - 1) * t * t + 1) + b;
			},
			easeInOutCubic: function (x, t, b, c, d) {
				if ((t /= d / 2) < 1) return c / 2 * t * t * t + b;
				return c / 2 * ((t -= 2) * t * t + 2) + b;
			},
			easeInSine: function (x, t, b, c, d) {
				return -c * Math.cos(t / d * (Math.PI / 2)) + c + b;
			},
			easeOutSine: function (x, t, b, c, d) {
				return c * Math.sin(t / d * (Math.PI / 2)) + b;
			},
			easeInOutSine: function (x, t, b, c, d) {
				return -c / 2 * (Math.cos(Math.PI * t / d) - 1) + b;
			}
		});
	})(jqxBaseFramework);

	(function ($) {
		if ($.event && $.event.special) {
			$.extend($.event.special,
				{
					"close": { noBubble: true },
					"open": { noBubble: true },
					"cellclick": { noBubble: true },
					"rowclick": { noBubble: true },
					"tabclick": { noBubble: true },
					"selected": { noBubble: true },
					"expanded": { noBubble: true },
					"collapsed": { noBubble: true },
					"valuechanged": { noBubble: true },
					"expandedItem": { noBubble: true },
					"collapsedItem": { noBubble: true },
					"expandingItem": { noBubble: true },
					"collapsingItem": { noBubble: true }
				});
		}
		if ($.fn.extend) {
			$.fn.extend({
				ischildof: function (filter_string) {
					if (!$(this).parents) {
						var result = filter_string.element.contains(this.element)
						return result;
					}

					var parents = $(this).parents().get();

					for (var j = 0; j < parents.length; j++) {
						if (typeof filter_string != "string") {
							var parent = parents[j];
							if (filter_string !== undefined) {
								if (parent == filter_string[0])
									return true;
							}
						}
						else {
							if (filter_string !== undefined) {
								if ($(parents[j]).is(filter_string)) {
									return true;
								}
							}
						}
					}

					return false;
				}
			});
		}

		$.fn.jqxProxy = function () {
			var widget = $(this).data().jqxWidget;
			var args = Array.prototype.slice.call(arguments, 0);
			var element = widget.element;
			if (!element) element = widget.base.element;
			return $.jqx.jqxWidgetProxy(widget.widgetName, element, args);
		}

		var originalVal = $.originalVal = $.fn.val;
		$.fn.val = function (value) {
			if (typeof value == 'undefined') {
				if ($(this).hasClass('jqx-widget') || $(this).hasClass('jqx-input-group')) {
					var widget = $(this).data().jqxWidget;
					if (widget && widget.val) {
						return widget.val();
					}
				}
				if (this[0] && this[0].tagName.toLowerCase().indexOf('angular') >= 0) {
					var widget = $(this).find('.jqx-widget').data().jqxWidget;
					if (widget && widget.val) {
						return widget.val();
					}

				}
				return originalVal.call(this);
			}
			else {
				if ($(this).hasClass('jqx-widget') || $(this).hasClass('jqx-input-group')) {
					var widget = $(this).data().jqxWidget;
					if (widget && widget.val) {
						if (arguments.length != 2) {
							return widget.val(value);
						}
						else {
							return widget.val(value, arguments[1]);
						}
					}
				}
				if (this[0] && this[0].tagName.toLowerCase().indexOf('angular') >= 0) {
					var widget = $(this).find('.jqx-widget').data().jqxWidget;
					if (widget && widget.val) {
						if (arguments.length != 2) {
							return widget.val(value);
						}
						else {
							return widget.val(value, arguments[1]);
						}
					}

				}

				return originalVal.call(this, value);
			}
		};

		if ($.fn.modal && $.fn.modal.Constructor) {
			$.fn.modal.Constructor.prototype.enforceFocus = function () {
				$(document)
					.off('focusin.bs.modal') // guard against infinite focus loop
					.on('focusin.bs.modal', $.proxy(function (e) {
						if (this.$element[0] !== e.target && !this.$element.has(e.target).length) {
							if ($(e.target).parents().hasClass('jqx-popup'))
								return true;
							this.$element.trigger('focus')
						}
					}, this));
			}
		}

		$.fn.coord = function (options) {
			var docElem, win,
				box = { top: 0, left: 0 },
				elem = this[0],
				doc = elem && elem.ownerDocument;
			if (!doc) {
				return;
			}
			docElem = doc.documentElement;
			if (!$.contains(docElem, elem)) {
				return box;
			}
			if (typeof elem.getBoundingClientRect !== undefined) {
				box = elem.getBoundingClientRect();
			}
			var getWindow = function (elem) {
				return $.isWindow(elem) ?
					elem :
					elem.nodeType === 9 ?
						elem.defaultView || elem.parentWindow :
						false;
			};

			win = getWindow(doc);
			var additionalLeftOffset = 0;
			var additionalTopOffset = 0;
			var agent = navigator.userAgent.toLowerCase();
			var result = agent.indexOf('ipad') != -1 || agent.indexOf('iphone') != -1;
			if (result) {
				// fix for iphone/ipad left offsets.
				additionalLeftOffset = 2;
			}
			if (true == options) {
				if (document.body.style.position != 'static' && document.body.style.position != '') {
					var coords = $(document.body).coord();
					additionalLeftOffset = -coords.left;
					additionalTopOffset = -coords.top;
				}
			}

			return {
				top: additionalTopOffset + box.top + (win.pageYOffset || docElem.scrollTop) - (docElem.clientTop || 0),
				left: additionalLeftOffset + box.left + (win.pageXOffset || docElem.scrollLeft) - (docElem.clientLeft || 0)
			};
		};

		$.jqx.ripplers = [];
		$.jqx.ripple = function (element, hostElement, hostElementType) {
			if (!hostElement) {
				hostElement = element;
			}

			var rippler = $(element);
			var mouseCaptured = false;

			rippler.append("<span class='ink'></span>");
			var ink = rippler.find('.ink');


			var hasRippler = false;

			for (var i = 0; i < $.jqx.ripplers.length; i++) {
				var ripplerItem = $.jqx.ripplers[i];

				if (ripplerItem.element[0] === element[0]) {
					hasRippler = true;
					break;
				}
			}

			if (!hasRippler) {
				$.jqx.ripplers.push({ ink: ink, element: element, hostElement: hostElement, hostElementType: hostElementType });
			}

			if (hostElementType === "checkbox" || hostElementType === "radiobutton") {

				// set .ink diametr
				var d = Math.max(rippler.outerWidth(), rippler.outerHeight());
				ink.css({ height: d, width: d });

				var x = rippler.width() / 2 - ink.width() / 2;
				var y = rippler.height() / 2 - ink.height() / 2;

				// set .ink position and add class .animate
				ink.css({
					top: y + 'px',
					left: x + 'px'
				});
			}

			// Ripple-effect animation
			if ($.jqx.ripplers.length === 1) {
				$(document).on('mouseup', function (e) {
					$.jqx.ripple.mouseCaptured = false;

					for (var i = 0; i < $.jqx.ripplers.length; i++) {
						var rippler = $.jqx.ripplers[i];

						rippler.ink.removeClass('active');
						rippler.element.removeClass('active');

						if (hostElementType !== "checkbox" && hostElementType !== "radiobutton") {
							if (rippler.ink.hasClass('animate')) {
								rippler.ink.removeClass('animate');
							}
						}
					}
				});
			}
			hostElement.off('mousedown.ripple');
			hostElement.on('mousedown.ripple', function (e) {
				var rippler = $(element);

				$.jqx.ripple.mouseCaptured = true;

				setTimeout(function () {
					// create .ink element if it doesn't exist

					if (rippler.find('.ink').length == 0) {
						rippler.append("<span class='ink'></span>");
					}

					var ink = rippler.find('.ink');

					// prevent quick double clicks
					ink.removeClass('animate');


					// set .ink diametr
					if (!ink.height() && !ink.width()) {
						var d = Math.max(rippler.outerWidth(), rippler.outerHeight());
						ink.css({ height: d, width: d });
					}

					if (hostElementType === "checkbox" || hostElementType === "radiobutton") {
						if (hostElementType === "checkbox") {
							if (hostElement.jqxCheckBox('disabled')) {
								return;
							}
						}

						if (hostElementType === "radiobutton") {
							if (hostElement.jqxRadioButton('disabled')) {
								return;
							}
						}

						// get click coordinates
						var x = rippler.width() / 2 - ink.width() / 2;
						var y = rippler.height() / 2 - ink.height() / 2;

						// set .ink position and add class .animate
						ink.css({
							top: y + 'px',
							left: x + 'px'
						}).addClass('animate');

						ink.on('animationend', function () {
							if ($.jqx.ripple.mouseCaptured) {
								ink.removeClass('animate')
								ink.addClass('active')
								element.addClass('active')
							}
						});

						return;
					}

					// get click coordinates
					var x = e.pageX - rippler.offset().left - ink.width() / 2;
					var y = e.pageY - rippler.offset().top - ink.height() / 2;

					// set .ink position and add class .animate
					ink.css({
						top: y + 'px',
						left: x + 'px'
					}).addClass('animate');
				});
			});
		}
	})(jqxBaseFramework);
})();




/***/ }),

/***/ 3907:
/***/ (() => {

﻿/* tslint:disable */
/* eslint-disable */
(function(){
	if (typeof document === 'undefined') { 
		return;
	}

(function ($) {
    var ArrayExporter = (function () {

        var exportModules = {},
            data, dataFields, styles, exporter, stylesArray, hierarchy, exportFormat, filename;

        function exportData(exporter, data, dataFields, styles, hierarchy, exportFormat, filename) {
            var that = this;

            if (!that) {
                that = window.jqx;
            }

            that.hierarchy = hierarchy;
            that.exportFormat = exportFormat;
            that.filename = filename;

            exporter.beginFile(filename);
            exportHeader(exporter);
            exportContent(exporter);
            exporter.endFile(filename);
            return exporter.getFile();
        }

        function exportHeader(exporter) {
            var exportHeaders = true;
            $.each(dataFields, function () {
                if (this.hidden) {
                    exportHeaders = false;
                    return false;
                }
            });

            exporter.beginHeader(exportHeaders);
            var index = 0;
            for (var cellContent in dataFields) {
                if (dataFields[cellContent].columnsDataFields) {
                    cellContent = dataFields[cellContent].columnsDataFields[index].displayfield;
                }
                var style = getHeaderStyle(cellContent, dataFields[cellContent]);
                exporter.appendHeaderCell(dataFields[cellContent], cellContent, style, exportHeaders, index);
                index++;
            }
            exporter.endHeader(exportHeaders);
        }

        function exportContent(exporter) {
            var that = this;

            if (!that) {
                that = window.jqx;
            }

            exporter.beginBody();
            if (that.hierarchy) {
                var exporHierarchy = function (data) {
                    for (var i = 0; i < data.length; i += 1) {
                        if (data[i] !== undefined) {
                            exporter.hierarchy = true;
                            exporter.beginRow(data[i].level);
                            exportRow(exporter, data[i], i, true);
                            if (data[i].records) {
                                exporter.beginRows(data[i].level);
                                exporHierarchy(data[i].records);
                                exporter.endRows(data[i].level);
                            }
                            exporter.endRow(data[i].level);
                        }
                    }
                }
                exporHierarchy(data);
                exporter.endBody();
                return;
            }

            for (var i = 0; i < data.length; i += 1) {
                if (data[i] !== undefined) {
                    exportRow(exporter, data[i], i);
                }
            }
            exporter.endBody();
        }

        function exportRow(exporter, data, rowId, hierarchy) {
            var that = this;

            if (!that) {
                that = window.jqx;
            }

            var style;
            if (hierarchy != true) {
                exporter.beginRow();
            }
            var indx = 0;
            for (var column in dataFields) {
                if (dataFields[column].columnsDataFields) {
                    column = dataFields[column].columnsDataFields[indx].displayfield;
                }

                style = getRowCellStyle(rowId, column);
                if (style) {
                    if (style.level != undefined) {
                        if (style.index - 1 > data.level && style.index - 1 < style.maxLevel) {
                            indx++;
                            continue;
                        }
                    }
                    if (style.maxLevel != undefined) {
                        if (style.index - 1 == style.maxLevel) {
                            style = $.extend({}, style);
                            style.merge = style.maxLevel - data.level - 1;
                        }
                    }
                }
                if (data.level != undefined && data.label != undefined) {
                    if (that.exportFormat === "xml" || that.exportFormat === "json") {
                        var dataGroup = {};
                        dataGroup['text'] = "group";
                        exporter.appendBodyCell(data.label, dataGroup, style, data, indx, "group");
                        break;
                    }
                }

                if (data.hasOwnProperty(column)) {
                    exporter.appendBodyCell(data[column], dataFields[column], style, data, indx);
                }
                else {
                    exporter.appendBodyCell("", dataFields[column], style, data, indx);
                }
                indx++;
            }
            if (hierarchy != true) {
                exporter.endRow();
            }
        }

        function getHeaderStyle(columnName, dataField) {
            if (dataField.style) {
                return styles[dataField.style];
            }

            var rowStyles = getStylesArray();
            if (rowStyles.length > 0) {
                return rowStyles[0].style;
            }
            return null;
        }

        function getStylesArray() {
            if (!stylesArray) {
                stylesArray = new Array();
                $.each(styles, function (index, value) {
                    stylesArray[stylesArray.length] = { name: index, style: value };
                });
            }

            return stylesArray;
        }

        function getRowCellStyle(rowId, column) {
            var dataField = dataFields[column];
            if (dataField) {
                if (dataField.customCellStyles) {
                    var customStyle = dataField.customCellStyles[rowId];
                    if (customStyle) {
                        return styles[customStyle];
                    }
                }

                if (dataField.cellStyle) {
                    if (dataField.cellAltStyle) {
                        var styleId = rowId % 2;
                        if (styleId == 0)
                            return styles[dataField.cellStyle];
                        return styles[dataField.cellAltStyle];
                    }
                    return styles[dataField.cellStyle];
                }
                else {
                    var rowStyles = getStylesArray();
                    if (rowStyles.length > 0) {
                        var styleId = rowId % (rowStyles.length - 1);
                        var style = rowStyles[styleId + 1].style;
                        return style;
                    }
                }
            }
            return null;
        }

        function createHiddenInput(value, name, form) {
            var input = document.createElement('input');
            input.name = name;
            input.value = value;
            input.type = 'hidden';
            form.appendChild(input);
            return input;
        }

        function createHiddenTextArea(value, name, form) {
            var textArea = document.createElement('textarea');
            textArea.name = name;
            textArea.value = value;
            //      textArea.type = 'hidden';
            form.appendChild(textArea);
            return textArea;
        }

        function createForm(filename, format, content, exportServer, charset) {
            var form = document.createElement('form');
            createHiddenInput(filename, 'filename', form);
            createHiddenInput(format, 'format', form);
            createHiddenTextArea(content, 'content', form);
            if (exportServer == undefined || exportServer == '') {
                if (window && window.location.toString().indexOf('jqwidgets.com') >= 0) {
                    exportServer = 'https://jqwidgets.com/export_server/dataexport.php';
                }
                else {
                    exportServer = 'http://jquerygrid.net/export_server/dataexport.php';
                }
            }

            form.action = exportServer;
            form.method = 'post';
            if (charset) {
                form.acceptCharset = charset;
            }

            document.body.appendChild(form);
            return form;
        }

        exporter = function (inputData, inputDataFields, inputStyles, exportServer, hierarchy, exportFormat) {
            if (!(this instanceof ArrayExporter)) {
                return new ArrayExporter(inputData, inputDataFields, inputStyles, hierarchy, exportFormat);
            }
            data = inputData;
            dataFields = inputDataFields;
            styles = inputStyles;

            this.exportTo = function (format, hierarchy, exportFormat, filename) {
                format = format.toString().toLowerCase();
                var module = exportModules[format];
                if (typeof module === 'undefined') {
                    throw 'You can\'t export to ' + format + ' format.';
                }
                if (format === "pdf" && filename == undefined) {
                    var table = this.exportTo(format, hierarchy, format, "pdf");
                    if (!$.jqx.pdfExport) {
                        $.jqx.pdfExport =
                        {
                            orientation: "portrait",
                            paperSize: "a4"
                        }
                    }

                    var doc = new pdfDataExport($.jqx.pdfExport.orientation, 'pt', $.jqx.pdfExport.paperSize);
                    doc.cellInitialize();
                    var headerCells = $(table).find('th');
                    var tableRows = $(table).find('tr');
                    var rows = 0;
                    doc.setFontSize(13 * 72 / 96);
                    var totalWidth = 595;
                    switch ($.jqx.pdfExport.paperSize) {
                        case "legal":
                            var totalWidth = 612;
                            if ($.jqx.pdfExport.orientation !== "portrait") {
                                totalWidth = 1008;
                            }
                            break;
                        case "letter":
                            var totalWidth = 612;
                            if ($.jqx.pdfExport.orientation !== "portrait") {
                                totalWidth = 792;
                            }
                            break;
                        case "a3":
                            var totalWidth = 841;
                            if ($.jqx.pdfExport.orientation !== "portrait") {
                                totalWidth = 1190;
                            }
                            break;
                        case "a4":
                            var totalWidth = 595;
                            if ($.jqx.pdfExport.orientation !== "portrait") {
                                totalWidth = 842;
                            }
                            break;
                        case "a5":
                            var totalWidth = 420;
                            if ($.jqx.pdfExport.orientation !== "portrait") {
                                totalWidth = 595;
                            }
                            break
                    }
                    totalWidth -= 20;
                    var totalColumnsWidth = 0;
                    var columnWidths = [];
                    $.each(headerCells, function (index) {
                        var width = parseInt(this.style.width);
                        if (isNaN(width)) {
                            width = 25;
                        }
                        var widthPoints = width * 72 / 96;
                        columnWidths[index] = widthPoints;
                        totalColumnsWidth += widthPoints;
                    });

                    if (headerCells.length === 0) {
                        $.each(tableRows[0].cells, function (index) {
                            var width = parseInt(this.style.width);
                            if (isNaN(width)) {
                                width = totalWidth / tableRows[0].cells.length;
                            }
                            var widthPoints = width * 72 / 96;
                            columnWidths[index] = widthPoints;
                            totalColumnsWidth += widthPoints;
                        });
                    }

                    if (totalColumnsWidth > totalWidth) {
                        $.each(columnWidths, function (index) {
                            columnWidths[index] = (columnWidths[index] / totalColumnsWidth) * 100;
                            columnWidths[index] = columnWidths[index] * totalWidth / 100;
                        });
                    }

                    $.each(headerCells, function (index) {
                        var widthPoints = columnWidths[index];
                        var heightPoints = 25 * 72 / 96;
                        var textDimension = doc.getTextDimensions($(this).html());
                        var cellText = $(this).html();
                        if (textDimension.w + 3 > widthPoints) {
                            var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                            var newText = splitText[0];
                            if (newText.length > 3) {
                                cellText = newText.substring(0, newText.length - 3) + "...";
                            }
                            else cellText = newText.substring(0, 1) + "...";
                            var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                            var newText = splitText[0];
                            if (newText != cellText) {
                                cellText = newText;
                            }
                        }
                        doc.cell(10, 10, widthPoints, heightPoints, cellText, rows);
                    });

                    rows++;
                    $.each(tableRows, function (index) {
                        if (index === 0) return true;
                        var rowCells = $(this).children();
                        var isTreeGrid = rowCells.length > headerCells.length && headerCells.length > 0;
                        if (isTreeGrid) {
                            var mergeLength = rowCells.length - headerCells.length;
                            var cellText = "";
                            var widthPoints = columnWidths[0];
                            var heightPoints = 25 * 72 / 96;
                            for (var i = 0; i <= mergeLength; i++) {
                                var cellHTML = rowCells[i].innerHTML;
                                if (cellHTML === "+" || cellHTML === "-") cellHTML = cellHTML + " ";
                                if (cellHTML === "&nbsp;") cellHTML = "   ";
                                cellText += cellHTML;
                            }
                            var textDimension = doc.getTextDimensions(cellText);
                            if (textDimension.w + 3 > widthPoints) {
                                var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                                var newText = splitText[0];
                                if (newText.length > 3) {
                                    cellText = newText.substring(0, newText.length - 3) + "...";
                                }
                                else cellText = newText.substring(0, 1) + "...";
                                var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                                var newText = splitText[0];
                                if (newText != cellText) {
                                    cellText = newText;
                                }
                            }

                            doc.cell(10, 10, widthPoints, heightPoints, cellText, rows);
                            for (var i = mergeLength + 1; i < rowCells.length; i++) {
                                var index = i - mergeLength;
                                var widthPoints = columnWidths[index];
                                var heightPoints = 25 * 72 / 96;
                                var cellText = $(rowCells[i]).html();
                                var textDimension = doc.getTextDimensions($(rowCells[i]).html());
                                if (textDimension.w + 3 > widthPoints) {
                                    var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                                    var newText = splitText[0];
                                    if (newText.length > 3) {
                                        cellText = newText.substring(0, newText.length - 3) + "...";
                                    }
                                    else cellText = newText.substring(0, 1) + "...";
                                    var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                                    var newText = splitText[0];
                                    if (newText != cellText) {
                                        cellText = newText;
                                    }
                                }
                                doc.cell(10, 10, widthPoints, heightPoints, cellText, rows);
                            }
                            rows++;
                            return true;
                        }

                        $.each(rowCells, function (index) {
                            var widthPoints = columnWidths[index];
                            var heightPoints = 25 * 72 / 96;
                            var cellText = $(this).html();
                            var textDimension = doc.getTextDimensions($(this).html());
                            if (textDimension.w + 3 > widthPoints) {
                                var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                                var newText = splitText[0];
                                if (newText.length > 3) {
                                    cellText = newText.substring(0, newText.length - 3) + "...";
                                }
                                else cellText = newText.substring(0, 1) + "...";
                                var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                                var newText = splitText[0];
                                if (newText != cellText) {
                                    cellText = newText;
                                }
                            }
                            doc.cell(10, 10, widthPoints, heightPoints, cellText, rows);
                        }
                        );
                        rows++;
                    });
                    if ($.jqx.browser.msie && $.jqx.browser.version < 10) {
                        throw new Error("PDF export requires a browser with HTML5 support");
                        return;
                    }

                    return doc;
                }

                return exportData(module, data, dataFields, styles, hierarchy, exportFormat, filename);
            };

            this.exportToFile = function (format, filename, exportServer, charset, hierarchy) {
                if (format === "pdf") {
                    var table = this.exportTo(format, hierarchy, format, filename);
                    if (!$.jqx.pdfExport) {
                        $.jqx.pdfExport =
                        {
                            orientation: "portrait",
                            paperSize: "a4"
                        }
                    }

                    var doc = new pdfDataExport($.jqx.pdfExport.orientation, 'pt', $.jqx.pdfExport.paperSize);
                    if (charset == "utf-8" || charset == "UTF-8") {
                        doc.setFont("courier", "normal");
                    }

                    doc.cellInitialize();
                    var headerCells = $(table).find('th');
                    var tableRows = $(table).find('tr');
                    var rows = 0;
                    doc.setFontSize(13 * 72 / 96);
                    var totalWidth = 595;
                    switch ($.jqx.pdfExport.paperSize) {
                        case "legal":
                            var totalWidth = 612;
                            if ($.jqx.pdfExport.orientation !== "portrait") {
                                totalWidth = 1008;
                            }
                            break;
                        case "letter":
                            var totalWidth = 612;
                            if ($.jqx.pdfExport.orientation !== "portrait") {
                                totalWidth = 792;
                            }
                            break;
                        case "a3":
                            var totalWidth = 841;
                            if ($.jqx.pdfExport.orientation !== "portrait") {
                                totalWidth = 1190;
                            }
                            break;
                        case "a4":
                            var totalWidth = 595;
                            if ($.jqx.pdfExport.orientation !== "portrait") {
                                totalWidth = 842;
                            }
                            break;
                        case "a5":
                            var totalWidth = 420;
                            if ($.jqx.pdfExport.orientation !== "portrait") {
                                totalWidth = 595;
                            }
                            break
                    }
                    totalWidth -= 20;
                    var totalColumnsWidth = 0;
                    var columnWidths = [];
                    $.each(headerCells, function (index) {
                        var width = parseInt(this.style.width);
                        if (isNaN(width)) {
                            width = 25;
                        }
                        var widthPoints = width * 72 / 96;
                        columnWidths[index] = widthPoints;
                        totalColumnsWidth += widthPoints;
                    });

                    if (headerCells.length === 0) {
                        $.each(tableRows[0].cells, function (index) {
                            var width = parseInt(this.style.width);
                            if (isNaN(width)) {
                                width = totalWidth / tableRows[0].cells.length;
                            }
                            var widthPoints = width * 72 / 96;
                            columnWidths[index] = widthPoints;
                            totalColumnsWidth += widthPoints;
                        });
                    }

                    if (totalColumnsWidth > totalWidth) {
                        $.each(columnWidths, function (index) {
                            columnWidths[index] = (columnWidths[index] / totalColumnsWidth) * 100;
                            columnWidths[index] = columnWidths[index] * totalWidth / 100;
                        });
                    }

                    $.each(headerCells, function (index) {
                        var widthPoints = columnWidths[index];
                        var heightPoints = 25 * 72 / 96;
                        var textDimension = doc.getTextDimensions($(this).html());
                        var cellText = $(this).html();
                        if (textDimension.w + 3 > widthPoints) {
                            var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                            var newText = splitText[0];
                            if (newText.length > 3) {
                                cellText = newText.substring(0, newText.length - 3) + "...";
                            }
                            else cellText = newText.substring(0, 1) + "...";
                            var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                            var newText = splitText[0];
                            if (newText != cellText) {
                                cellText = newText;
                            }
                        }
                        doc.cell(10, 10, widthPoints, heightPoints, cellText, rows);
                    });

                    rows++;
                    $.each(tableRows, function (index) {
                        if (index === 0) return true;
                        var rowCells = $(this).children();
                        var isTreeGrid = rowCells.length > headerCells.length && headerCells.length > 0;
                        if (isTreeGrid) {
                            var mergeLength = rowCells.length - headerCells.length;
                            var cellText = "";
                            var widthPoints = columnWidths[0];
                            var heightPoints = 25 * 72 / 96;
                            for (var i = 0; i <= mergeLength; i++) {
                                var cellHTML = rowCells[i].innerHTML;
                                if (cellHTML === "+" || cellHTML === "-") cellHTML = cellHTML + " ";
                                if (cellHTML === "&nbsp;") cellHTML = "   ";
                                cellText += cellHTML;
                            }
                            var textDimension = doc.getTextDimensions(cellText);
                            if (textDimension.w + 3 > widthPoints) {
                                var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                                var newText = splitText[0];
                                if (newText.length > 3) {
                                    cellText = newText.substring(0, newText.length - 3) + "...";
                                }
                                else cellText = newText.substring(0, 1) + "...";
                                var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                                var newText = splitText[0];
                                if (newText != cellText) {
                                    cellText = newText;
                                }
                            }

                            doc.cell(10, 10, widthPoints, heightPoints, cellText, rows);
                            for (var i = mergeLength + 1; i < rowCells.length; i++) {
                                var index = i - mergeLength;
                                var widthPoints = columnWidths[index];
                                var heightPoints = 25 * 72 / 96;
                                var cellText = $(rowCells[i]).html();
                                if (cellText === "&nbsp;") cellText = "   ";

                                var textDimension = doc.getTextDimensions($(rowCells[i]).html());
                                if (textDimension.w + 3 > widthPoints) {
                                    var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                                    var newText = splitText[0];
                                    if (newText.length > 3) {
                                        cellText = newText.substring(0, newText.length - 3) + "...";
                                    }
                                    else cellText = newText.substring(0, 1) + "...";
                                    var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                                    var newText = splitText[0];
                                    if (newText != cellText) {
                                        cellText = newText;
                                    }
                                }
                                doc.cell(10, 10, widthPoints, heightPoints, cellText, rows);
                            }
                            rows++;
                            return true;
                        }

                        $.each(rowCells, function (index) {
                            var widthPoints = columnWidths[index];
                            var heightPoints = 25 * 72 / 96;
                            var cellText = $(this).html();
                            if (cellText === "&nbsp;") cellText = "   ";

                            var textDimension = doc.getTextDimensions($(this).html());
                            if (textDimension.w + 3 > widthPoints) {
                                var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                                var newText = splitText[0];
                                if (newText.length > 3) {
                                    cellText = newText.substring(0, newText.length - 3) + "...";
                                }
                                else cellText = newText.substring(0, 1) + "...";
                                var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                                var newText = splitText[0];
                                if (newText != cellText) {
                                    cellText = newText;
                                }
                            }
                            doc.cell(10, 10, widthPoints, heightPoints, cellText, rows);
                        }
                        );
                        rows++;
                    });
                    if ($.jqx.browser.msie && $.jqx.browser.version < 10) {
                        throw new Error("PDF export requires a browser with HTML5 support");
                        return;
                    }

                    doc.save(filename + ".pdf");
                    return;
                }

                var content = this.exportTo(format, hierarchy, format, filename),
                    form = createForm(filename, format, content, exportServer, charset);
                form.submit();
                document.body.removeChild(form);
            };

            this.exportToLocalFile = function (format, filename, hierarchy, exportFormat) {
                var content = this.exportTo(format, hierarchy, exportFormat);
                document.location.href = 'data:application/octet-stream;filename=' + filename + ',' + encodeURIComponent(content);
            };

        };

        exporter.extend = function (exportFormat, exporter) {
            if (exporter instanceof $.jqx.dataAdapter.DataExportModuleBase) {
                exportModules[exportFormat] = exporter;
            } else {
                throw 'The module ' + exportFormat + ' is not instance of DataExportModuleBase.';
            }
        };

        return exporter;

    }());

    $.jqx.dataAdapter.ArrayExporter = ArrayExporter;

})(jqxBaseFramework);


(function ($) {

    //Defines common interface for all modules used for exportation
    var DataExportModuleBase = function () {

        this.formatData = function (data, type, formatString, localization) {
            if (type === 'date') {
                var tmpdate = "";
                if (typeof data === 'string') {
                    tmpdate = $.jqx.dataFormat.tryparsedate(data);
                    data = tmpdate;
                }
                if (data === "" || data === null) return "";
                tmpdate = $.jqx.dataFormat.formatdate(data, formatString, localization);
                if ((tmpdate && tmpdate.toString() == "NaN") || tmpdate == null) return "";
                data = tmpdate;
            } else if (type === 'number' || type === 'float' || type === 'int' || type == 'integer') {
                if (data === "" || data === null) return "";

                if (!isNaN(new Number(data))) {
                    var tmpdata = $.jqx.dataFormat.formatnumber(data, formatString, localization);
                    if (tmpdata.toString() == "NaN") return "";
                    else data = tmpdata;
                }
            } else {
                data = data;
            }
            if (data === null) return "";
            return data;
        };

        this.getFormat = function (dataOptions) {
            var formatString = dataOptions ? dataOptions['formatString'] : "";
            var localization = dataOptions ? dataOptions['localization'] : "";
            var dataType = 'string';
            dataType = dataOptions ? dataOptions['type'] : 'string';

            if (dataType == 'number' || dataType == 'float') {
                if (!formatString) formatString = 'f2';
            }
            if (dataType == 'int' || dataType == 'integer') {
                if (!formatString) formatString = 'n0';
            }
            if (dataType == 'date') {
                if (!formatString) formatString = 'd';
            }
            return { type: dataType, formatString: formatString, localization: localization };
        };

        this.beginFile = function () {
            throw 'Not implemented!';
        };

        this.beginHeader = function () {
            throw 'Not implemented!';
        };

        this.appendHeaderCell = function () {
            throw 'Not implemented!';
        };

        this.endHeader = function () {
            throw 'Not implemented!';
        };

        this.beginBody = function () {
            throw 'Not implemented!';
        };

        this.beginRow = function () {
            throw 'Not implemented!';
        };

        this.beginRows = function () {
            throw 'Not implemented!';
        };

        this.endRows = function () {
            throw 'Not implemented!';
        };

        this.appendBodyCell = function () {
            throw 'Not implemented!';
        };

        this.endRow = function () {
            throw 'Not implemented!';
        };

        this.endBody = function () {
            throw 'Not implemented!';
        };

        this.endFile = function () {
            throw 'Not implemented!';
        };

        this.getFile = function () {
            throw 'Not implemented!';
        };
    }

    $.jqx.dataAdapter.DataExportModuleBase = DataExportModuleBase;

})(jqxBaseFramework);

//Extending the exporter with TSV and CSV exporters
(function ($) {

    //Value exporter. This object is common prototype for TSV and CVS.
    var SvExporter = function (inValueSeparator) {

        var file, valueSeparator, hasHeader;
        var rowIndex = 0;
        var me = this;

        this.beginFile = function () {
            file = '';
        };

        this.beginHeader = function () {
        };

        this.appendHeaderCell = function (data, fieldName, style, exportHeader, index) {
            if (style) {
                if (style.level != undefined) {
                    if (index < style.maxLevel) {
                        return;
                    }
                    else if (index === style.maxLevel) {
                        if (exportHeader) {
                            appendCell(data.text);
                        }
                        for (var i = 0; i < style.maxLevel; i++) {
                            appendCell("");
                        }
                        return;
                    }
                }
            }

            hasHeader = exportHeader;
            if (exportHeader) {
                appendCell(data.text);
            }
        };

        this.endHeader = function () {
            this.endRow();
        };

        this.beginBody = function () {
            rowIndex = 0;
        };

        this.beginRow = function () {
            if ((rowIndex > 0) || (rowIndex == 0 && hasHeader)) {
                file += '\n';
            }
            rowIndex++;
        };

        this.appendBodyCell = function (data, dataType, style, row, index) {
            if (style) {
                if (style.maxLevel != undefined) {
                    if (index === style.maxLevel) {
                        appendCell(data, dataType);
                        for (var i = 0; i < style.maxLevel - row.level - 1; i++) {
                            appendCell("", dataType);
                        }
                        return;
                    }
                }
            }
            appendCell(data, dataType);
        };

        this.endRow = function () {
            file = file.substring(0, file.length - 1);
        };

        this.endBody = function () {
        };

        this.endFile = function () {
        };

        this.getFile = function () {
            return file;
        };

        function prepareData(data, dataOptions) {
            if (dataOptions) {
                var format = me.getFormat(dataOptions);
                data = me.formatData(data, format.type, format.formatString, format.localization);
            }
            data = '"' + data + '"';
            return data;
        };

        function appendCell(data, dataOptions) {
            data = prepareData(data, dataOptions);
            file += data + inValueSeparator;
        };

    };

    SvExporter.prototype = new $.jqx.dataAdapter.DataExportModuleBase();

    var CsvExporter = function () { };
    CsvExporter.prototype = new SvExporter(',');

    var TsvExporter = function () { };
    TsvExporter.prototype = new SvExporter('\t');

    $.jqx.dataAdapter.ArrayExporter.extend('csv', new CsvExporter());
    $.jqx.dataAdapter.ArrayExporter.extend('tsv', new TsvExporter());

})(jqxBaseFramework);

//Extending the exporter with HTML exporter
(function ($) {

    var HtmlExporter = function () {
        var isPDF = false;
        var file;
        var hasHeader;
        var rowIndex = 0;

        this.setPDF = function () {
            isPDF = true;
        };

        this.beginFile = function (filename) {
            if (isPDF || filename == undefined) {
                file = '<table style="empty-cells: show;" cellspacing="0" cellpadding="2">';
            }
            else {
                file = '<html>\n\t<head>\n\t\t<title></title>\n' +
					   '\t\t<meta http-equiv=Content-type content=\"text/html; charset=UTF-8\">\n\t</head>\n\t<body>\n' +
					   '\t\t<table style="empty-cells: show;" cellspacing="0" cellpadding="2">';
            }
        };

        this.beginHeader = function () {
            if (isPDF) {
                file += '\n\t<thead><tr>';
            }
            else {
                file += '\n\t\t\t<thead>';
            }
        };

        this.appendHeaderCell = function (data, fieldName, style, exportHeader) {
            hasHeader = exportHeader;
            if (!exportHeader) return;

            if (isPDF) {
                file += '\n\t\t\t\t<th style="' + buildStyle(style) + '">' + data.text + '</th>';
            }
            else {
                if (style.disabled) return;

                if (style.merge) {
                    if (data.width) {
                        file += '\n\t\t\t\t<th colspan=' + (1 + style.merge) + ' style="width: ' + data.width + 'px; ' + buildStyle(style) + '">' + data.text + '</th>';
                    }
                    else {
                        file += '\n\t\t\t\t<th colspan=' + (1 + style.merge) + ' style="' + buildStyle(style) + '">' + data.text + '</th>';
                    }
                }
                else {
                    if (data.width) {
                        file += '\n\t\t\t\t<th style="width: ' + data.width + 'px; ' + buildStyle(style) + '">' + data.text + '</th>';
                    }
                    else {
                        file += '\n\t\t\t\t<th style="' + buildStyle(style) + '">' + data.text + '</th>';
                    }
                }
            }
        };

        this.endHeader = function () {
            if (isPDF) {
                file += '\n\t</tr></thead>';
            }
            else {
                file += '\n\t\t\t</thead>';
            }
        };

        this.beginBody = function () {
            if (isPDF) {
                file += '\n\t<tbody>';
            }
            else {
                file += '\n\t\t\t<tbody>';
            }
            rowIndex = 0;
        };

        this.beginRow = function () {
            if (isPDF) {
                file += '\n\t<tr>';
            }
            else {
                file += '\n\t\t\t\t<tr>';
            }
            rowIndex++;
        };

        this.appendBodyCell = function (data, dataOptions, style) {
            var format = this.getFormat(dataOptions);
            if (data === "") data = "&nbsp;";
            if (isPDF) {
                if (rowIndex == 1 && !hasHeader) {
                    file += '\n\t\t\t\t\t<td style="' + buildStyle(style) + ' border-top-width: 1px;">' + this.formatData(data, format.type, format.formatString, format.localization) + '</td>';
                }
                else {
                    file += '\n\t\t\t\t\t<td style="' + buildStyle(style) + '">' + this.formatData(data, format.type, format.formatString, format.localization) + '</td>';
                }
            }
            else {
                if (style.merge) {
                    if (rowIndex == 1 && !hasHeader) {
                        file += '\n\t\t\t\t\t<td colspan=' + (1 + style.merge) + ' style="' + buildStyle(style) + ' border-top-width: 1px;">' + this.formatData(data, format.type, format.formatString, format.localization) + '</td>';
                    }
                    else {
                        file += '\n\t\t\t\t\t<td colspan=' + (1 + style.merge) + ' style="' + buildStyle(style) + '">' + this.formatData(data, format.type, format.formatString, format.localization) + '</td>';
                    }
                }
                else {
                    if (rowIndex == 1 && !hasHeader) {
                        file += '\n\t\t\t\t\t<td style="' + buildStyle(style) + ' border-top-width: 1px;">' + this.formatData(data, format.type, format.formatString, format.localization) + '</td>';
                    }
                    else {
                        file += '\n\t\t\t\t\t<td style="' + buildStyle(style) + '">' + this.formatData(data, format.type, format.formatString, format.localization) + '</td>';
                    }
                }
            }
        };

        this.endRow = function () {
            if (isPDF) {
                file += '\n\t</tr>';
            }
            else {
                file += '\n\t\t\t\t</tr>';
            }
        };

        this.endBody = function () {
            if (isPDF) {
                file += '\n\t</tbody>';
            }
            else {
                file += '\n\t\t\t</tbody>';
            }
        };

        this.endFile = function (filename) {
            if (isPDF || filename == undefined) {
                file += '\n</table>';
            }
            else {
                file += '\n\t\t</table>\n\t</body>\n</html>\n';
            }
        };

        this.getFile = function () {
            return file;
        };

        function buildStyle(styles) {
            var result = '';
            for (var style in styles) {
                if (styles.hasOwnProperty(style)) {
                    if (isPDF && style == 'font-size') {
                        styles[style] = '100%';
                    }
                    result += style + ':' + styles[style] + ';';
                }
            }
            return result;
        }
    }

    HtmlExporter.prototype = new $.jqx.dataAdapter.DataExportModuleBase();

    var TableExporter = function () { };
    TableExporter.prototype = new HtmlExporter();

    var PDFExporter = function () { };
    PDFExporter.prototype = new HtmlExporter();
    var exporter = new PDFExporter();

    $.jqx.dataAdapter.ArrayExporter.extend('html', new TableExporter());
    $.jqx.dataAdapter.ArrayExporter.extend('pdf', exporter);

})(jqxBaseFramework);

//Exporting to XLS format (MS Office Excel 2003)
(function ($) {

    var ExcelExporter = function () {

        var header, content, headerFields, headerStyles, existingStyles, styleCounter,
            styleBuilder = {

                style: '',

                stylesMap: {
                    'font': {
                        'color': 'Color',
                        'font-family': 'FontName',
                        'font-style': 'Italic',
                        'font-weight': 'Bold'
                    },
                    'interior': {
                        'background-color': 'Color',
                        'background': 'Color'
                    },
                    'alignment': {
                        'left': 'Left',
                        'center': 'Center',
                        'right': 'Right'
                    }
                },

                startStyle: function (styleName) {
                    this.style += '\n\t\t<Style ss:ID="' + styleName + '" ss:Name="' + styleName + '">';
                },

                buildAlignment: function (styles) {
                    if (styles['text-align']) {
                        var alignment = this.stylesMap['alignment'][styles['text-align']];
                        if (!alignment) {
                            alignment = "Left";
                        }
                        var style = '\n\t\t\t<Alignment ss:Vertical="Bottom" ss:Horizontal="' + alignment + '"/>';
                        this.style += style;
                    }
                },

                buildBorder: function (styles) {
                    if (styles['border-color']) {
                        var border = '\n\t\t\t<Borders>';
                        var bottomBorder = '\n\t\t\t\t<Border ss:Position="Bottom" ss:LineStyle="Continuous" ss:Weight="1" ss:Color="' + styles['border-color'] + '"/>';
                        var leftBorder = '\n\t\t\t\t<Border ss:Position="Left" ss:LineStyle="Continuous" ss:Weight="1" ss:Color="' + styles['border-color'] + '"/>';
                        var rightBorder = '\n\t\t\t\t<Border ss:Position="Right" ss:LineStyle="Continuous" ss:Weight="1" ss:Color="' + styles['border-color'] + '"/>';
                        var topBorder = '\n\t\t\t\t<Border ss:Position="Top" ss:LineStyle="Continuous" ss:Weight="1" ss:Color="' + styles['border-color'] + '"/>';

                        border += bottomBorder;
                        border += leftBorder;
                        border += rightBorder;
                        border += topBorder;
                        border += '\n\t\t\t</Borders>';
                        this.style += border;
                    }
                },

                buildFont: function (styles) {
                    var map = this.stylesMap['font'],
                        font = '\n\t\t\t<Font ';
                    for (var prop in map) {
                        if (typeof styles[prop] !== 'undefined') {
                            if (prop === 'font-style' && styles[prop].toString().toLowerCase() === 'italic') {
                                font += 'ss:Italic="1" ';
                            } else if (prop === 'font-weight' && styles[prop].toString().toLowerCase() === 'bold') {
                                font += 'ss:Bold="1" ';
                            } else if (prop === 'color') {
                                font += 'ss:' + map[prop] + '="' + styles[prop] + '" ';
                            }
                        }
                    }
                    font += '/>';
                    this.style += font;
                },

                buildInterior: function (styles) {
                    var map = this.stylesMap['interior'],
                        interior = '\n\t\t\t<Interior ';
                    var hasInterior = false;
                    for (var prop in map) {
                        if (typeof styles[prop] !== 'undefined') {
                            interior += 'ss:' + map[prop] + '="' + styles[prop] + '" ';
                            hasInterior = true;
                        }
                    }
                    if (hasInterior)
                        interior += 'ss:Pattern="Solid"';

                    interior += '/>';
                    this.style += interior;
                },

                buildFormat: function (styles) {
                    if (styles['dataType'] == 'number' || styles['dataType'] == 'float' || styles['dataType'] == 'int' || styles['dataType'] == 'integer') {
                        var formatString = styles['formatString'];
                        if (formatString == "" || formatString.indexOf('n') != -1 || formatString.indexOf('N') != -1) {
                            this.style += '\n\t\t\t<NumberFormat ss:Format="0"/>';
                        }
                        else if (formatString == "f" || formatString == "F" || formatString == "D" || formatString.indexOf('d') != -1) {
                            this.style += '\n\t\t\t<NumberFormat ss:Format="#,##0.00_);[Red]\(#,##0.00\)"/>';
                        }
                        else if (formatString.indexOf('p') != -1 || formatString.indexOf('P') != -1) {
                            this.style += '\n\t\t\t<NumberFormat ss:Format="Percent"/>';
                        }
                        else if (formatString.indexOf('c') != -1 || formatString.indexOf('C') != -1) {
                            if (styles['currencysymbol'] && parseInt(styles['currencysymbol'].charCodeAt(0)) == 8364) {
                                this.style += '\n\t\t\t<NumberFormat ss:Format="Euro Currency"/>';
                            }
                            else {
                                this.style += '\n\t\t\t<NumberFormat ss:Format="Currency"/>';
                            }
                        }
                    }
                    else if (styles['dataType'] == 'date') {
                        this.style += '\n\t\t\t<NumberFormat ss:Format="Short Date"/>';
                    }
                },

                closeStyle: function () {
                    this.style += '\n\t\t</Style>';
                },

                toString: function () {
                    var temp = this.style;
                    this.style = '';
                    return temp;
                }
            };

        this.beginFile = function () {
            existingStyles = {};
            styleCounter = 0;
            header = '<?xml version="1.0"?>' +
                            '\n\t<?mso-application progid="Excel.Sheet"?> ' +
                            '\n\t<Workbook xmlns="urn:schemas-microsoft-com:office:spreadsheet" ' +
                            '\n\txmlns:o="urn:schemas-microsoft-com:office:office" ' +
                            '\n\txmlns:x="urn:schemas-microsoft-com:office:excel" ' +
                            '\n\txmlns:ss="urn:schemas-microsoft-com:office:spreadsheet" ' +
                            '\n\txmlns:html="http://www.w3.org/TR/REC-html40"> ' +
                            '\n\t<DocumentProperties xmlns="urn:schemas-microsoft-com:office:office"> ' +
                            '\n\t<Version>12.00</Version> ' +
                            '\n\t</DocumentProperties> ' +
                            '\n\t<ExcelWorkbook xmlns="urn:schemas-microsoft-com:office:excel"> ' +
                            '\n\t<WindowHeight>8130</WindowHeight> ' +
                            '\n\t<WindowWidth>15135</WindowWidth> ' +
                            '\n\t<WindowTopX>120</WindowTopX> ' +
                            '\n\t<WindowTopY>45</WindowTopY> ' +
                            '\n\t<ProtectStructure>False</ProtectStructure> ' +
                            '\n\t<ProtectWindows>False</ProtectWindows> ' +
                            '\n\t</ExcelWorkbook> ' +
                        '\n\t<Styles>';
        };

        this.beginHeader = function () {
            content = '\n\t<Worksheet ss:Name="Sheet1">\n\t\t<Table>';
            headerFields = [];
            headerStyles = [];
        };

        this.appendHeaderCell = function (data, fieldName, style) {
            var width = data.width != undefined ? data.width : data.text.length * 10;
            content += '\n\t\t\t<Column ss:Width="' + width + '"/>';
            headerFields.push(data);
            headerStyles.push(style);
        };

        this.endHeader = function (exportHeader) {
            if (exportHeader) {
                this.beginRow();
                for (var i = 0; i < headerFields.length; i += 1) {
                    if (headerStyles[i].disabled) continue;
                    appendCell.call(this, headerFields[i]['text'], null, headerStyles[i]);
                }
                this.endRow();
            }
        };

        this.beginBody = function () {
        };

        this.beginRow = function (level) {
            if (level != undefined) {
                content += '\n\t\t\t';
                for (var i = 0; i < level; i++) {
                    content += '\t';
                }
                content += '<Row>';
                return;
            }

            content += '\n\t\t\t<Row>';
        };

        this.beginRows = function (level) {
            content += '\n\t\t\t\t<Rows>';
        };

        this.appendBodyCell = function (data, dataType, style, row) {
            appendCell.call(this, data, dataType, style, row);
        };

        this.endRow = function (level) {
            if (level != undefined) {
                content += '\n\t\t\t';
                for (var i = 0; i < level; i++) {
                    content += '\t';
                }
                content += '</Row>';
                return;
            }

            content += '\n\t\t\t</Row>';
        };

        this.endRows = function (level) {
            if (level != undefined) {
                content += '\n\t\t\t';
                for (var i = 0; i < level; i++) {
                    content += '\t';
                }
                content += '</Rows>';
                return;
            }
        };

        this.endBody = function () {
            content += '\n\t\t</Table>';
        };

        this.endFile = function () {
            content += '\n\t</Worksheet>\n</Workbook>';
            header += '\n\t</Styles>';
        };

        this.getFile = function () {
            return header + content;
        };

        function appendCell(data, dataOptions, style, row) {
            var columnType = "String";

            var format = this.getFormat(dataOptions);

            if (data != null && data.toString().substring(0, 3) == "_AG") {
                data = data.toString().substring(3);
                columnType = "String";
            }
            else {
                if (format.type == 'date') {
                    var date = data;
                    data = this.formatData(data, format.type, format.formatString, format.localization);
                    if (data === null || data === "") {
                        data = "";
                        columnType = "String";
                    }
                    else {
                        data = date.toISOString();
                        columnType = "DateTime";
                    }
                }
                if (format.type == 'string') {
                    if (data === null || data === undefined) {
                        data = "";
                    }
                    else {
                        if (data.toString().indexOf('&') >= 0) {
                            data = data.toString().replace(/&/g, '&amp;');
                        }
                        if (data.toString().indexOf('>') >= 0) {
                            data = data.toString().replace(/>/g, '&gt;');
                        }
                        if (data.toString().indexOf('<') >= 0) {
                            data = data.toString().replace(/</g, '&lt;');
                        }
                        if (data.toString().indexOf('"') >= 0) {
                            data = data.toString().replace(/"/g, '&quot;');
                        }
                        if (data.toString().indexOf("'") >= 0) {
                            data = data.toString().replace(/'/g, '&apos;');
                        }
                    }
                }

                if (style.dataType == 'number' || style.dataType == 'float' || style.dataType == 'int' || style.dataType == 'integer') {
                    columnType = "Number";
                    data = parseFloat(data);
                    if (data === null || isNaN(data) || data === "") {
                        data = "";
                        columnType = "String";
                    }
                    if (data && columnType != "String" && data != "") {
                        if (dataOptions && dataOptions.formatString && dataOptions.formatString.indexOf('p') >= 0) {
                            data = data / 100;
                        }
                    }

                    style.currencysymbol = dataOptions.localization.currencysymbol;
                }
            }

            var styleId = getStyleId(style);
            if (style.merge) {
                content += '\n\t\t\t\t<Cell ss:MergeAcross="' + style.merge + '" ss:StyleID="' + styleId + '"><Data ss:Type="' + columnType + '">' + data + '</Data></Cell>';
            }
            else {
                content += '\n\t\t\t\t<Cell ss:StyleID="' + styleId + '"><Data ss:Type="' + columnType + '">' + data + '</Data></Cell>';
            }
        }

        function generateStyleId() {
            styleCounter += 1;
            return 'xls-style-' + styleCounter;
        }

        function findStyle(style) {
            for (var s in existingStyles) {
                if (isSubset(style, existingStyles[s]) && isSubset(existingStyles[s], style)) {
                    return s;
                }
            }
            return undefined;
        }

        function isSubset(first, second) {
            var subset = true;
            for (var p in first) {
                if (first[p] !== second[p]) {
                    subset = false;
                }
            }
            return subset;
        }

        function appendStyle(id, style) {
            styleBuilder.startStyle(id);
            styleBuilder.buildAlignment(style);
            styleBuilder.buildBorder(style);
            styleBuilder.buildFont(style);
            styleBuilder.buildInterior(style);
            styleBuilder.buildFormat(style);
            styleBuilder.closeStyle();
            header += styleBuilder.toString();
        }

        function getStyleId(style) {
            if (!style) {
                return '';
            }
            var id = findStyle(style);
            if (typeof id === 'undefined') {
                id = generateStyleId();
                existingStyles[id] = style;
                appendStyle(id, style);
            }
            return id;
        }
    }

    ExcelExporter.prototype = new $.jqx.dataAdapter.DataExportModuleBase();
    $.jqx.dataAdapter.ArrayExporter.extend('xls', new ExcelExporter());
})(jqxBaseFramework);

//Exporting to XML
(function ($) {

    var XmlExporter = function () {

        var file, headerFields, index;

        this.beginFile = function () {
            file = '<?xml version="1.0" encoding="UTF-8" ?>';
            file += '\n<table>';
        }

        this.beginHeader = function () {
            headerFields = [];
        }

        this.appendHeaderCell = function (data, fieldName) {
            headerFields.push(fieldName);
        }

        this.endHeader = function () {
        }

        this.beginBody = function (data, dataType) {
        }

        this.beginRow = function (level) {
            var that = this;

            if (!that) {
                that = window.jqx;
            }

            if (level != undefined) {
                if (that.hierarchy) {
                    file += '\n\t';
                    for (var i = 0; i < level; i++) {
                        file += '\t\t';
                    }
                    file += '<row>';
                    index = 0;
                    return;
                }
            }

            file += '\n\t<row>';
            index = 0;
        }

        this.beginRows = function (level) {
            if (level != undefined) {
                file += '\n\t\t';
                for (var i = 0; i < level; i++) {
                    file += '\t\t';
                }
                file += '<rows>';
                index = 0;
                return;
            }
            file += '\n\t\t<rows>';
        }

        this.appendBodyCell = function (data, dataOptions, style, row, indx, group) {
            var that = this;

            if (!that) {
                that = window.jqx;
            }

            var format = this.getFormat(dataOptions);
            data = this.formatData(data, format.type, format.formatString, format.localization);
            if (format.type == "string") {
                if (data.toString().indexOf('&') >= 0) {
                    data = data.toString().replace(/&/g, '&amp;');
                }
                if (data.toString().indexOf('>') >= 0) {
                    data = data.toString().replace(/>/g, '&gt;');
                }
                if (data.toString().indexOf('<') >= 0) {
                    data = data.toString().replace(/</g, '&lt;');
                }
                if (data.toString().indexOf('"') >= 0) {
                    data = data.toString().replace(/"/g, '&quot;');
                }
                if (data.toString().indexOf("'") >= 0) {
                    data = data.toString().replace(/'/g, '&apos;');
                }
            }
            if (row.level != undefined) {
                if (that.hierarchy) {
                    file += '\n\t\t';
                    for (var i = 0; i < row.level; i++) {
                        file += '\t\t';
                    }
                    if (group === undefined) {
                        file += '<' + headerFields[index] + '>' + data + '</' + headerFields[index] + '>';
                    }
                    else {
                        file += '<' + group + '>' + data + '</' + group + '>';
                    }
                }
                else {
                    if (group != undefined) {
                        file += '\n\t\t<' + group + '>' + data + '</' + group + '>';
                    }
                    else {
                        file += '\n\t\t<' + headerFields[index] + '>' + data + '</' + headerFields[index] + '>';
                    }
                }
            }
            else {
                file += '\n\t\t<' + headerFields[index] + '>' + data + '</' + headerFields[index] + '>';
            }
            index++;
        }

        this.endRow = function (level) {
            var that = this;

            if (!that) {
                that = window.jqx;
            }

            if (level != undefined) {
                if (that.hierarchy) {
                    file += '\n\t';
                    for (var i = 0; i < level; i++) {
                        file += '\t\t';
                    }

                    file += '</row>';
                    index = 0;
                    return;
                }
            }
            file += '\n\t</row>';
            index = 0;
        }

        this.endRows = function (level) {
            if (level != undefined) {
                file += '\n\t\t';
                for (var i = 0; i < level; i++) {
                    file += '\t\t';
                }
                file += '</rows>';
                index = 0;
                return;
            }
            file += '\n\t\t</rows>';
        }

        this.endBody = function () {
        }

        this.endFile = function () {
            file += '\n</table>';
        }

        this.getFile = function () {
            return file;
        }
    }

    XmlExporter.prototype = new $.jqx.dataAdapter.DataExportModuleBase();
    $.jqx.dataAdapter.ArrayExporter.extend('xml', new XmlExporter());
})(jqxBaseFramework);


//Exporting to JSON
(function ($) {

    var escapable = /[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,
        meta = {
            '\b': '\\b',
            '\t': '\\t',
            '\n': '\\n',
            '\f': '\\f',
            '\r': '\\r',
            '"': '\\"',
            '\\': '\\\\'
        };

    function quote(string) {
        return '"' + string.replace(escapable, function (a) {
            var c = meta[a];
            return typeof c === 'string' ? c : '\\u' + ('0000' + a.charCodeAt(0).toString(16)).slice(-4);
        }) + '"';
    }

    function formatNumber(n) {
        return n < 10 ? '0' + n : n;
    }

    function stringifyDate(value) {
        var date;
        if (isFinite(value.valueOf())) {
            date = value.getUTCFullYear() + '-' + formatNumber(value.getUTCMonth() + 1) + '-' +
            formatNumber(value.getUTCDate()) + 'T' + formatNumber(value.getUTCHours()) + ':' +
            formatNumber(value.getUTCMinutes()) + ':' + formatNumber(value.getUTCSeconds()) + 'Z"';
        } else {
            date = 'null';
        }
        return date;
    }

    function stringifyArray(value) {
        var len = value.length,
            partial = [],
            i;
        for (i = 0; i < len; i++) {
            partial.push(str(i, value) || 'null');
        }

        return '[' + partial.join(',') + ']';
    }

    function stringifyObject(value) {
        var partial = [],
            i, v;
        for (i in value) {
            if (Object.prototype.hasOwnProperty.call(value, i)) {
                v = str(i, value);
                if (v) {
                    partial.push(quote(i) + ':' + v);
                }
            }
        }
        return '{' + partial.join(',') + '}';
    }

    function stringifyReference(value) {
        switch (Object.prototype.toString.call(value)) {
            case '[object Date]':
                return stringifyDate(value);
            case '[object Array]':
                return stringifyArray(value);
        }
        return stringifyObject(value);
    }

    function stringifyPrimitive(value, type) {
        switch (type) {
            case 'string':
                return quote(value);
            case 'number':
            case 'float':
            case 'integer':
            case 'int':
                return isFinite(value) ? value : 'null';
            case 'boolean':
                return value;
        }
        return 'null';
    }

    function str(key, holder) {
        var value = holder[key], type = typeof value;

        if (value && typeof value === 'object' && typeof value.toJSON === 'function') {
            value = value.toJSON(key);
            type = typeof value;
        }
        if (/(number|float|int|integer|string|boolean)/.test(type) || (!value && type === 'object')) {
            return stringifyPrimitive(value, type);
        } else {
            return stringifyReference(value);
        }
    }

    function stringify(value) {
        if (window.JSON && typeof window.JSON.stringify === 'function') {
            return window.JSON.stringify(value);
        }

        return str("", { "": value });
    }

    var JsonExporter = function () {
        var me = this;
        this.prepareData = function (data, dataOptions) {
            if (dataOptions) {
                var format = me.getFormat(dataOptions);
                data = me.formatData(data, format.type, format.formatString, format.localization);
            }
            return data;
        }

        var file,
            content,
            currentCell,
            cellHierarchy = [],
            level = 0
        ;

        this.beginFile = function () {
            content = [];
        }

        this.beginHeader = function () {
        }

        this.appendHeaderCell = function (data) {
        }

        this.endHeader = function () {
        }

        this.beginBody = function (data, dataType) {
        }

        this.beginRow = function () {
            var that = this;

            if (!that) {
                that = window.jqx;
            }

            if (that.hierarchy || window.jqx.hierarchy) {
                cellHierarchy[level] = {};
            }
            else {
                currentCell = {};
            }
        }

        this.beginRows = function () {
            cellHierarchy[level].rows = [];
            level++;
            cellHierarchy[level] = {};
        }
        this.endRows = function () {
            level--;
        }

        this.appendBodyCell = function (data, dataType) {
            var that = this;

            if (!that) {
                that = window.jqx;
            }


            var text = this.prepareData(data, dataType);
            if (that.hierarchy || window.jqx.hierarchy) {
                cellHierarchy[level][dataType['text']] = text;
            }
            else {
                currentCell[dataType['text']] = text;
            }
        }

        this.endRow = function () {
            var that = this;

            if (!that) {
                that = window.jqx;
            }


            if (that.hierarchy || window.jqx.hierarchy) {
                if (level == 0) {
                    content.push(cellHierarchy[level]);
                }
                else {
                    cellHierarchy[level - 1].rows.push(cellHierarchy[level]);
                }
            }
            else {
                content.push(currentCell);
            }
        }

        this.endBody = function () {
        }

        this.endFile = function () {
            file = stringify(content);
        }

        this.getFile = function () {
            return file;
        }
    }

    JsonExporter.prototype = new $.jqx.dataAdapter.DataExportModuleBase();
    $.jqx.dataAdapter.ArrayExporter.extend('json', new JsonExporter());

})(jqxBaseFramework);


var pdfDataExport = window.jqxPdfDataExport = (function () {
    'use strict';
    if (typeof btoa === 'undefined') {
        window.btoa = function (data) {
            var b64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",
                b64a = b64.split(''),
                o1,
                o2,
                o3,
                h1,
                h2,
                h3,
                h4,
                bits,
                i = 0,
                ac = 0,
                enc = "",
                tmp_arr = [],
                r;

            do {
                o1 = data.charCodeAt(i++);
                o2 = data.charCodeAt(i++);
                o3 = data.charCodeAt(i++);

                bits = o1 << 16 | o2 << 8 | o3;

                h1 = bits >> 18 & 0x3f;
                h2 = bits >> 12 & 0x3f;
                h3 = bits >> 6 & 0x3f;
                h4 = bits & 0x3f;

                tmp_arr[ac++] = b64a[h1] + b64a[h2] + b64a[h3] + b64a[h4];
            } while (i < data.length);

            enc = tmp_arr.join('');
            r = data.length % 3;
            return (r ? enc.slice(0, r - 3) : enc) + '==='.slice(r || 3);
        };
    }

    if (typeof atob === 'undefined') {
        window.atob = function (data) {

            var b64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",
                o1,
                o2,
                o3,
                h1,
                h2,
                h3,
                h4,
                bits,
                i = 0,
                ac = 0,
                dec = "",
                tmp_arr = [];

            if (!data) {
                return data;
            }

            data += '';

            do { // unpack four hexets into three octets using index points in b64
                h1 = b64.indexOf(data.charAt(i++));
                h2 = b64.indexOf(data.charAt(i++));
                h3 = b64.indexOf(data.charAt(i++));
                h4 = b64.indexOf(data.charAt(i++));

                bits = h1 << 18 | h2 << 12 | h3 << 6 | h4;

                o1 = bits >> 16 & 0xff;
                o2 = bits >> 8 & 0xff;
                o3 = bits & 0xff;

                if (h3 === 64) {
                    tmp_arr[ac++] = String.fromCharCode(o1);
                } else if (h4 === 64) {
                    tmp_arr[ac++] = String.fromCharCode(o1, o2);
                } else {
                    tmp_arr[ac++] = String.fromCharCode(o1, o2, o3);
                }
            } while (i < data.length);
            dec = tmp_arr.join('');
            return dec;
        };
    }

    var getObjectLength = typeof Object.keys === 'function' ?
                function (object) {
                    return Object.keys(object).length;
                } :
                function (object) {
                    var i = 0, e;
                    for (e in object) {
                        if (object.hasOwnProperty(e)) {
                            i++;
                        }
                    }
                    return i;
                },

/**
PubSub implementation

@class
@name PubSub
*/
        PubSub = function (context) {
            /*
            @private
            @fieldOf PubSub
            */
            this.topics = {};
            /**
            Stores what will be `this` within the callback functions.

            @private
            @fieldOf PubSub#
            */
            this.context = context;
            /**
            Allows caller to emit an event and pass arguments to event listeners.
            @public
            @function
            @param topic {String} Name of the channel on which to voice this event
            @param args Any number of arguments you want to pass to the listeners of this event.
            @methodOf PubSub#
            @name publish
            */
            this.publish = function (topic, args) {
                if (this.topics[topic]) {
                    var currentTopic = this.topics[topic],
                        toremove = [],
                        fn,
                        i,
                        l,
                        pair,
                        emptyFunc = function () { };
                    args = Array.prototype.slice.call(arguments, 1);
                    for (i = 0, l = currentTopic.length; i < l; i++) {
                        pair = currentTopic[i]; // this is a [function, once_flag] array
                        fn = pair[0];
                        if (pair[1]) { /* 'run once' flag set */
                            pair[0] = emptyFunc;
                            toremove.push(i);
                        }
                        fn.apply(this.context, args);
                    }
                    for (i = 0, l = toremove.length; i < l; i++) {
                        currentTopic.splice(toremove[i], 1);
                    }
                }
            };
            /**
            Allows listener code to subscribe to channel and be called when data is available
            @public
            @function
            @param topic {String} Name of the channel on which to voice this event
            @param callback {Function} Executable (function pointer) that will be ran when event is voiced on this channel.
            @param once {Boolean} (optional. False by default) Flag indicating if the function is to be triggered only once.
            @returns {Object} A token object that cen be used for unsubscribing.
            @methodOf PubSub#
            @name subscribe
            */
            this.subscribe = function (topic, callback, once) {
                if (!this.topics[topic]) {
                    this.topics[topic] = [[callback, once]];
                } else {
                    this.topics[topic].push([callback, once]);
                }
                return {
                    "topic": topic,
                    "callback": callback
                };
            };
            /**
            Allows listener code to unsubscribe from a channel
            @public
            @function
            @param token {Object} A token object that was returned by `subscribe` method
            @methodOf PubSub#
            @name unsubscribe
            */
            this.unsubscribe = function (token) {
                if (this.topics[token.topic]) {
                    var currentTopic = this.topics[token.topic], i, l;

                    for (i = 0, l = currentTopic.length; i < l; i++) {
                        if (currentTopic[i][0] === token.callback) {
                            currentTopic.splice(i, 1);
                        }
                    }
                }
            };
        };


    /**
    @constructor
    @private
    */
    function pdfDataExport(orientation, unit, format, compressPdf) { /** String orientation, String unit, String format, Boolean compressed */

        // Default parameter values
        if (typeof orientation === 'undefined') {
            orientation = 'p';
        } else {
            orientation = orientation.toString().toLowerCase();
        }
        if (typeof unit === 'undefined') { unit = 'mm'; }
        if (typeof format === 'undefined') { format = 'a4'; }
        if (typeof compressPdf === 'undefined' && typeof zpipe === 'undefined') { compressPdf = false; }

        var format_as_string = format.toString().toLowerCase(),
            version = '0.9.0rc2',
            content = [],
            content_length = 0,
            compress = compressPdf,
            pdfVersion = '1.3', // PDF Version
            pageFormats = { // Size in pt of various paper formats
                'a3': [841.89, 1190.55],
                'a4': [595.28, 841.89],
                'a5': [420.94, 595.28],
                'letter': [612, 792],
                'legal': [612, 1008]
            },
            textColor = '0 g',
            drawColor = '0 G',
            page = 0,
            pages = [],
            objectNumber = 2, // 'n' Current object number
            outToPages = false, // switches where out() prints. outToPages true = push to pages obj. outToPages false = doc builder content
            offsets = [], // List of offsets. Activated and reset by buildDocument(). Pupulated by various calls buildDocument makes.
            fonts = {}, // collection of font objects, where key is fontKey - a dynamically created label for a given font.
            fontmap = {}, // mapping structure fontName > fontStyle > font key - performance layer. See addFont()
            activeFontSize = 16,
            activeFontKey, // will be string representing the KEY of the font as combination of fontName + fontStyle
            lineWidth = 0.200025, // 2mm
            pageHeight,
            pageWidth,
            k, // Scale factor
            documentProperties = { 'title': '', 'subject': '', 'author': '', 'keywords': '', 'creator': '' },
            lineCapID = 0,
            lineJoinID = 0,
            API = {},
            events = new PubSub(API),
            tmp,
            plugin,
            /////////////////////
            // Private functions
            /////////////////////
            // simplified (speedier) replacement for sprintf's %.2f conversion
            f2 = function (number) {
                return number.toFixed(2);
            },
            // simplified (speedier) replacement for sprintf's %.3f conversion
            f3 = function (number) {
                return number.toFixed(3);
            },
            // simplified (speedier) replacement for sprintf's %02d
            padd2 = function (number) {
                var n = (number).toFixed(0);
                if (number < 10) {
                    return '0' + n;
                } else {
                    return n;
                }
            },
            // simplified (speedier) replacement for sprintf's %02d
            padd10 = function (number) {
                var n = (number).toFixed(0);
                if (n.length < 10) {
                    return new Array(11 - n.length).join('0') + n;
                } else {
                    return n;
                }
            },
            out = function (string) {
                if (outToPages) { /* set by beginPage */
                    pages[page].push(string);
                } else {
                    content.push(string);
                    content_length += string.length + 1; // +1 is for '\n' that will be used to join contents of content
                }
            },
            newObject = function () {
                // Begin a new object
                objectNumber++;
                offsets[objectNumber] = content_length;
                out(objectNumber + ' 0 obj');
                return objectNumber;
            },
            putStream = function (str) {
                out('stream');
                out(str);
                out('endstream');
            },
            wPt,
            hPt,
            kids,
            i,
            putPages = function () {
                wPt = pageWidth * k;
                hPt = pageHeight * k;

                // outToPages = false as set in endDocument(). out() writes to content.

                var n, p, arr, uint, i, deflater, adler32;
                for (n = 1; n <= page; n++) {
                    newObject();
                    out('<</Type /Page');
                    out('/Parent 1 0 R');
                    out('/Resources 2 0 R');
                    out('/Contents ' + (objectNumber + 1) + ' 0 R>>');
                    out('endobj');

                    // Page content
                    p = pages[n].join('\n');
                    newObject();
                    if (compress) {
                        arr = [];
                        for (i = 0; i < p.length; ++i) {
                            arr[i] = p.charCodeAt(i);
                        }
                        adler32 = adler32cs.from(p);
                        deflater = new Deflater(6);
                        deflater.append(new Uint8Array(arr));
                        p = deflater.flush();
                        arr = [new Uint8Array([120, 156]), new Uint8Array(p),
                               new Uint8Array([adler32 & 0xFF, (adler32 >> 8) & 0xFF, (adler32 >> 16) & 0xFF, (adler32 >> 24) & 0xFF])];
                        p = '';
                        for (i in arr) {
                            if (arr.hasOwnProperty(i)) {
                                p += String.fromCharCode.apply(null, arr[i]);
                            }
                        }
                        out('<</Length ' + p.length + ' /Filter [/FlateDecode]>>');
                    } else {
                        out('<</Length ' + p.length + '>>');
                    }
                    putStream(p);
                    out('endobj');
                }
                offsets[1] = content_length;
                out('1 0 obj');
                out('<</Type /Pages');
                kids = '/Kids [';
                for (i = 0; i < page; i++) {
                    kids += (3 + 2 * i) + ' 0 R ';
                }
                out(kids + ']');
                out('/Count ' + page);
                out('/MediaBox [0 0 ' + f2(wPt) + ' ' + f2(hPt) + ']');
                out('>>');
                out('endobj');
            },
            putFont = function (font) {
                font.objectNumber = newObject();
                out('<</BaseFont/' + font.PostScriptName + '/Type/Font');
                if (typeof font.encoding === 'string') {
                    out('/Encoding/' + font.encoding);
                }
                out('/Subtype/Type1>>');
                out('endobj');
            },
            putFonts = function () {
                var fontKey;
                for (fontKey in fonts) {
                    if (fonts.hasOwnProperty(fontKey)) {
                        putFont(fonts[fontKey]);
                    }
                }
            },
            putXobjectDict = function () {
                // Loop through images, or other data objects
                events.publish('putXobjectDict');
            },
            putResourceDictionary = function () {
                out('/ProcSet [/PDF /Text /ImageB /ImageC /ImageI]');
                out('/Font <<');
                // Do this for each font, the '1' bit is the index of the font
                var fontKey;
                for (fontKey in fonts) {
                    if (fonts.hasOwnProperty(fontKey)) {
                        out('/' + fontKey + ' ' + fonts[fontKey].objectNumber + ' 0 R');
                    }
                }
                out('>>');
                out('/XObject <<');
                putXobjectDict();
                out('>>');
            },
            putResources = function () {
                putFonts();
                events.publish('putResources');
                // Resource dictionary
                offsets[2] = content_length;
                out('2 0 obj');
                out('<<');
                putResourceDictionary();
                out('>>');
                out('endobj');
                events.publish('postPutResources');
            },
            addToFontDictionary = function (fontKey, fontName, fontStyle) {
                // this is mapping structure for quick font key lookup.
                // returns the KEY of the font (ex: "F1") for a given pair of font name and type (ex: "Arial". "Italic")
                var undef;
                if (fontmap[fontName] === undef) {
                    fontmap[fontName] = {}; // fontStyle is a var interpreted and converted to appropriate string. don't wrap in quotes.
                }
                fontmap[fontName][fontStyle] = fontKey;
            },
            /**
            FontObject describes a particular font as member of an instnace of pdfDataExport

            It's a collection of properties like 'id' (to be used in PDF stream),
            'fontName' (font's family name), 'fontStyle' (font's style variant label)

            @class
            @public
            @property id {String} PDF-document-instance-specific label assinged to the font.
            @property PostScriptName {String} PDF specification full name for the font
            @property encoding {Object} Encoding_name-to-Font_metrics_object mapping.
            @name FontObject
            */
            FontObject = {},
            addFont = function (PostScriptName, fontName, fontStyle, encoding) {
                var fontKey = 'F' + (getObjectLength(fonts) + 1).toString(10),
                    // This is FontObject
                    font = fonts[fontKey] = {
                        'id': fontKey,
                        // , 'objectNumber':   will be set by putFont()
                        'PostScriptName': PostScriptName,
                        'fontName': fontName,
                        'fontStyle': fontStyle,
                        'encoding': encoding,
                        'metadata': {}
                    };

                addToFontDictionary(fontKey, fontName, fontStyle);

                events.publish('addFont', font);

                return fontKey;
            },
            addFonts = function () {

                var HELVETICA = "helvetica",
                    TIMES = "times",
                    COURIER = "courier",
                    NORMAL = "normal",
                    BOLD = "bold",
                    ITALIC = "italic",
                    BOLD_ITALIC = "bolditalic",
                    encoding = 'StandardEncoding',
                    standardFonts = [
                        ['Helvetica', HELVETICA, NORMAL],
                        ['Helvetica-Bold', HELVETICA, BOLD],
                        ['Helvetica-Oblique', HELVETICA, ITALIC],
                        ['Helvetica-BoldOblique', HELVETICA, BOLD_ITALIC],
                        ['Courier', COURIER, NORMAL],
                        ['Courier-Bold', COURIER, BOLD],
                        ['Courier-Oblique', COURIER, ITALIC],
                        ['Courier-BoldOblique', COURIER, BOLD_ITALIC],
                        ['Times-Roman', TIMES, NORMAL],
                        ['Times-Bold', TIMES, BOLD],
                        ['Times-Italic', TIMES, ITALIC],
                        ['Times-BoldItalic', TIMES, BOLD_ITALIC]
                    ],
                    i,
                    l,
                    fontKey,
                    parts;
                for (i = 0, l = standardFonts.length; i < l; i++) {
                    var en = encoding;

                    fontKey = addFont(
                        standardFonts[i][0],
                        standardFonts[i][1],
                        standardFonts[i][2],
                        en
                    );

                    // adding aliases for standard fonts, this time matching the capitalization
                    parts = standardFonts[i][0].split('-');
                    addToFontDictionary(fontKey, parts[0], parts[1] || '');
                }

                events.publish('addFonts', { 'fonts': fonts, 'dictionary': fontmap });
            },
            /**

            @public
            @function
            @param text {String}
            @param flags {Object} Encoding flags.
            @returns {String} Encoded string
            */
            to8bitStream = function (text, flags) {

                var i, l, undef, sourceEncoding, encodingBlock, outputEncoding, newtext, isUnicode, ch, bch;

                if (flags === undef) {
                    flags = {};
                }

                sourceEncoding = flags.sourceEncoding ? sourceEncoding : 'Unicode';

                outputEncoding = flags.outputEncoding;

                // This 'encoding' section relies on font metrics format
                // attached to font objects by, among others,
                // "Willow Systems' standard_font_metrics plugin"
                // see pdfDataExport.plugin.standard_font_metrics.js for format
                // of the font.metadata.encoding Object.
                // It should be something like
                //   .encoding = {'codePages':['WinANSI....'], 'WinANSI...':{code:code, ...}}
                //   .widths = {0:width, code:width, ..., 'fof':divisor}
                //   .kerning = {code:{previous_char_code:shift, ..., 'fof':-divisor},...}
                if ((flags.autoencode || outputEncoding) &&
                        fonts[activeFontKey].metadata &&
                        fonts[activeFontKey].metadata[sourceEncoding] &&
                        fonts[activeFontKey].metadata[sourceEncoding].encoding
                        ) {
                    encodingBlock = fonts[activeFontKey].metadata[sourceEncoding].encoding;

                    // each font has default encoding. Some have it clearly defined.
                    if (!outputEncoding && fonts[activeFontKey].encoding) {
                        outputEncoding = fonts[activeFontKey].encoding;
                    }

                    // Hmmm, the above did not work? var's try again, in different place.
                    if (!outputEncoding && encodingBlock.codePages) {
                        outputEncoding = encodingBlock.codePages[0]; // var's say, first one is the default
                    }

                    if (typeof outputEncoding === 'string') {
                        outputEncoding = encodingBlock[outputEncoding];
                    }
                    // we want output encoding to be a JS Object, where
                    // key = sourceEncoding's character code and
                    // value = outputEncoding's character code.
                    if (outputEncoding) {
                        isUnicode = false;
                        newtext = [];
                        for (i = 0, l = text.length; i < l; i++) {
                            ch = outputEncoding[text.charCodeAt(i)];
                            if (ch) {
                                newtext.push(
                                    String.fromCharCode(ch)
                                );
                            } else {
                                newtext.push(
                                    text[i]
                                );
                            }

                            // since we are looping over chars anyway, might as well
                            // check for residual unicodeness
                            if (newtext[i].charCodeAt(0) >> 8) { /* more than 255 */
                                isUnicode = true;
                            }
                        }
                        text = newtext.join('');
                    }
                }

                i = text.length;
                // isUnicode may be set to false above. Hence the triple-equal to undefined
                while (isUnicode === undef && i !== 0) {
                    if (text.charCodeAt(i - 1) >> 8) { /* more than 255 */
                        isUnicode = true;
                    }
                    i--;
                }
                if (!isUnicode) {
                    return text;
                } else {
                    newtext = flags.noBOM ? [] : [254, 255];
                    for (i = 0, l = text.length; i < l; i++) {
                        ch = text.charCodeAt(i);
                        bch = ch >> 8; // divide by 256
                        if (bch >> 8) { /* something left after dividing by 256 second time */
                            throw new Error("Character at position " + i.toString(10) + " of string '" + text + "' exceeds 16bits. Cannot be encoded into UCS-2 BE");
                        }
                        newtext.push(bch);
                        newtext.push(ch - (bch << 8));
                    }
                    return String.fromCharCode.apply(undef, newtext);
                }
            },
            // Replace '/', '(', and ')' with pdf-safe versions
            pdfEscape = function (text, flags) {
                // doing to8bitStream does NOT make this PDF display unicode text. For that
                // we also need to reference a unicode font and embed it - royal pain in the rear.

                // There is still a benefit to to8bitStream - PDF simply cannot handle 16bit chars,
                // which JavaScript Strings are happy to provide. So, while we still cannot display
                // 2-byte characters property, at least CONDITIONALLY converting (entire string containing)
                // 16bit chars to (USC-2-BE) 2-bytes per char + BOM streams we ensure that entire PDF
                // is still parseable.
                // This will allow immediate support for unicode in document properties strings.
                return to8bitStream(text, flags).replace(/\\/g, '\\\\').replace(/\(/g, '\\(').replace(/\)/g, '\\)');
            },
            putInfo = function () {
                out('/Producer (pdfDataExport ' + version + ')');
                if (documentProperties.title) {
                    out('/Title (' + pdfEscape(documentProperties.title) + ')');
                }
                if (documentProperties.subject) {
                    out('/Subject (' + pdfEscape(documentProperties.subject) + ')');
                }
                if (documentProperties.author) {
                    out('/Author (' + pdfEscape(documentProperties.author) + ')');
                }
                if (documentProperties.keywords) {
                    out('/Keywords (' + pdfEscape(documentProperties.keywords) + ')');
                }
                if (documentProperties.creator) {
                    out('/Creator (' + pdfEscape(documentProperties.creator) + ')');
                }
                var created = new Date();
                out('/CreationDate (D:' +
                    [
                        created.getFullYear(),
                        padd2(created.getMonth() + 1),
                        padd2(created.getDate()),
                        padd2(created.getHours()),
                        padd2(created.getMinutes()),
                        padd2(created.getSeconds())
                    ].join('') +
                    ')'
                    );
            },
            putCatalog = function () {
                out('/Type /Catalog');
                out('/Pages 1 0 R');
                // @TODO: Add zoom and layout modes
                out('/OpenAction [3 0 R /FitH null]');
                out('/PageLayout /OneColumn');
                events.publish('putCatalog');
            },
            putTrailer = function () {
                out('/Size ' + (objectNumber + 1));
                out('/Root ' + objectNumber + ' 0 R');
                out('/Info ' + (objectNumber - 1) + ' 0 R');
            },
            beginPage = function () {
                page++;
                // Do dimension stuff
                outToPages = true;
                pages[page] = [];
            },
            _addPage = function () {
                beginPage();
                // Set line width
                out(f2(lineWidth * k) + ' w');
                // Set draw color
                out(drawColor);
                // resurrecting non-default line caps, joins
                if (lineCapID !== 0) {
                    out(lineCapID.toString(10) + ' J');
                }
                if (lineJoinID !== 0) {
                    out(lineJoinID.toString(10) + ' j');
                }
                events.publish('addPage', { 'pageNumber': page });
            },
            /**
            Returns a document-specific font key - a label assigned to a
            font name + font type combination at the time the font was added
            to the font inventory.

            Font key is used as label for the desired font for a block of text
            to be added to the PDF document stream.
            @private
            @function
            @param fontName {String} can be undefined on "falthy" to indicate "use current"
            @param fontStyle {String} can be undefined on "falthy" to indicate "use current"
            @returns {String} Font key.
            */
            getFont = function (fontName, fontStyle) {
                var key, undef;

                if (fontName === undef) {
                    fontName = fonts[activeFontKey].fontName;
                }
                if (fontStyle === undef) {
                    fontStyle = fonts[activeFontKey].fontStyle;
                }

                try {
                    key = fontmap[fontName][fontStyle]; // returns a string like 'F3' - the KEY corresponding tot he font + type combination.
                } catch (e) {
                    key = undef;
                }
                if (!key) {
                    throw new Error("Unable to look up font label for font '" + fontName + "', '" + fontStyle + "'. Refer to getFontList() for available fonts.");
                }

                return key;
            },
            buildDocument = function () {

                outToPages = false; // switches out() to content
                content = [];
                offsets = [];

                // putHeader()
                out('%PDF-' + pdfVersion);

                putPages();

                putResources();

                // Info
                newObject();
                out('<<');
                putInfo();
                out('>>');
                out('endobj');

                // Catalog
                newObject();
                out('<<');
                putCatalog();
                out('>>');
                out('endobj');

                // Cross-ref
                var o = content_length, i;
                out('xref');
                out('0 ' + (objectNumber + 1));
                out('0000000000 65535 f ');
                for (i = 1; i <= objectNumber; i++) {
                    out(padd10(offsets[i]) + ' 00000 n ');
                }
                // Trailer
                out('trailer');
                out('<<');
                putTrailer();
                out('>>');
                out('startxref');
                out(o);
                out('%%EOF');

                outToPages = true;

                return content.join('\n');
            },
            getStyle = function (style) {
                // see Path-Painting Operators of PDF spec
                var op = 'S'; // stroke
                if (style === 'F') {
                    op = 'f'; // fill
                } else if (style === 'FD' || style === 'DF') {
                    op = 'B'; // both
                }
                return op;
            },

            /**
            Generates the PDF document.
            Possible values:
                datauristring (alias dataurlstring) - Data-Url-formatted data returned as string.
                datauri (alias datauri) - Data-Url-formatted data pushed into current window's location (effectively reloading the window with contents of the PDF).

            If `type` argument is undefined, output is raw body of resulting PDF returned as a string.

            @param {String} type A string identifying one of the possible output types.
            @param {Object} options An object providing some additional signalling to PDF generator.
            @function
            @returns {pdfDataExport}
            @methodOf pdfDataExport#
            @name output
            */
            output = function (type, options) {
                var undef, data, length, array, i, blob;
                switch (type) {
                    case undef:
                        return buildDocument();
                    case 'save':
                        if (navigator.getUserMedia) {
                            if (window.URL === undefined) {
                                return API.output('dataurlnewwindow');
                            } else if (window.URL.createObjectURL === undefined) {
                                return API.output('dataurlnewwindow');
                            }
                        }
                        data = buildDocument();

                        // Need to add the file to BlobBuilder as a Uint8Array
                        length = data.length;
                        array = new Uint8Array(new ArrayBuffer(length));

                        for (i = 0; i < length; i++) {
                            array[i] = data.charCodeAt(i);
                        }

                        blob = new Blob([array], { type: "application/pdf" });

                        saveAs(blob, options);
                        break;
                    case 'datauristring':
                    case 'dataurlstring':
                        return 'data:application/pdf;base64,' + btoa(buildDocument());
                    case 'datauri':
                    case 'dataurl':
                        document.location.href = 'data:application/pdf;base64,' + btoa(buildDocument());
                        break;
                    case 'dataurlnewwindow':
                        window.open('data:application/pdf;base64,' + btoa(buildDocument()));
                        break;
                    default:
                        throw new Error('Output type "' + type + '" is not supported.');
                }
                // @TODO: Add different output options
            };

        if (unit === 'pt') {
            k = 1;
        } else if (unit === 'mm') {
            k = 72 / 25.4;
        } else if (unit === 'cm') {
            k = 72 / 2.54;
        } else if (unit === 'in') {
            k = 72;
        } else {
            throw ('Invalid unit: ' + unit);
        }

        // Dimensions are stored as user units and converted to points on output
        if (pageFormats.hasOwnProperty(format_as_string)) {
            pageHeight = pageFormats[format_as_string][1] / k;
            pageWidth = pageFormats[format_as_string][0] / k;
        } else {
            try {
                pageHeight = format[1];
                pageWidth = format[0];
            } catch (err) {
                throw ('Invalid format: ' + format);
            }
        }

        if (orientation === 'p' || orientation === 'portrait') {
            orientation = 'p';
            if (pageWidth > pageHeight) {
                tmp = pageWidth;
                pageWidth = pageHeight;
                pageHeight = tmp;
            }
        } else if (orientation === 'l' || orientation === 'landscape') {
            orientation = 'l';
            if (pageHeight > pageWidth) {
                tmp = pageWidth;
                pageWidth = pageHeight;
                pageHeight = tmp;
            }
        } else {
            throw ('Invalid orientation: ' + orientation);
        }



        //---------------------------------------
        // Public API

        /*
        Object exposing internal API to plugins
        @public
        */
        API.internal = {
            'pdfEscape': pdfEscape,
            'getStyle': getStyle,
            /**
            Returns {FontObject} describing a particular font.
            @public
            @function
            @param fontName {String} (Optional) Font's family name
            @param fontStyle {String} (Optional) Font's style variation name (Example:"Italic")
            @returns {FontObject}
            */
            'getFont': function () { return fonts[getFont.apply(API, arguments)]; },
            'getFontSize': function () { return activeFontSize; },
            'btoa': btoa,
            'write': function (string1, string2, string3, etc) {
                out(
                    arguments.length === 1 ? string1 : Array.prototype.join.call(arguments, ' ')
                );
            },
            'getCoordinateString': function (value) {
                return f2(value * k);
            },
            'getVerticalCoordinateString': function (value) {
                return f2((pageHeight - value) * k);
            },
            'collections': {},
            'newObject': newObject,
            'putStream': putStream,
            'events': events,
            // ratio that you use in multiplication of a given "size" number to arrive to 'point'
            // units of measurement.
            // scaleFactor is set at initialization of the document and calculated against the stated
            // default measurement units for the document.
            // If default is "mm", k is the number that will turn number in 'mm' into 'points' number.
            // through multiplication.
            'scaleFactor': k,
            'pageSize': { 'width': pageWidth, 'height': pageHeight },
            'output': function (type, options) {
                return output(type, options);
            }
        };

        /**
        Adds (and transfers the focus to) new page to the PDF document.
        @function
        @returns {pdfDataExport}

        @methodOf pdfDataExport#
        @name addPage
         */
        API.addPage = function () {
            _addPage();
            return this;
        };

        var padz =
[
   "",
   "0",
   "00",
   "000",
   "0000"
];
        var pdfEscape16 = function (text, flags) {
            var ar = ["FEFF"];
            for (var i = 0, l = text.length, t; i < l; ++i) {
                t = text.charCodeAt(i).toString(16).toUpperCase();
                ar.push(padz[4 - t.length], t);
            }
            return ar.join("");
        };

        API.text16 = function (text, x, y, flags) {
            /**
            * Inserts something like this into PDF
            BT
            /F1 16 Tf % Font name + size
            16 TL % How many units down for next line in multiline text
            0 g % color
            28.35 813.54 Td % position
            (line one) Tj
            T* (line two) Tj
            T* (line three) Tj
            ET
            */

            var undef, _first, _second, _third, newtext, str, i;
            // Pre-August-2012 the order of arguments was function(x, y, text, flags)
            // in effort to make all calls have similar signature like
            // function(data, coordinates... , miscellaneous)
            // this method had its args flipped.
            // code below allows backward compatibility with old arg order.
            if (typeof text === 'number') {
                _first = y;
                _second = text;
                _third = x;

                text = _first;
                x = _second;
                y = _third;
            }

            // If there are any newlines in text, we assume
            // the user wanted to print multiple lines, so break the
            // text up into an array. If the text is already an array,
            // we assume the user knows what they are doing.
            if (typeof text === 'string' && text.match(/[\n\r]/)) {
                text = text.split(/\r\n|\r|\n/g);
            }

            if (typeof flags === 'undefined') {
                flags = { 'noBOM': true, 'autoencode': true };
            } else {

                if (flags.noBOM === undef) {
                    flags.noBOM = true;
                }

                if (flags.autoencode === undef) {
                    flags.autoencode = true;
                }

            }
            flags.autoencode = false;
            if (typeof text === 'string') {
                str = pdfEscape16(text, flags);
            } else if (text instanceof Array) { /* Array */
                // we don't want to destroy original text array, so cloning it
                newtext = text.concat();
                // we do array.join('text that must not be PDFescaped")
                // thus, pdfEscape each component separately
                for (i = newtext.length - 1; i !== -1; i--) {
                    newtext[i] = pdfEscape16(newtext[i], flags);
                }
                str = newtext.join("> Tj\nT* <");
            } else {
                throw new Error('Type of text must be string or Array. "' + text + '" is not recognized.');
            }
            // Using "'" ("go next line and render text" mark) would save space but would complicate our rendering code, templates

            // BT .. ET does NOT have default settings for Tf. You must state that explicitely every time for BT .. ET
            // if you want text transformation matrix (+ multiline) to work reliably (which reads sizes of things from font declarations)
            // Thus, there is NO useful, *reliable* concept of "default" font for a page.
            // The fact that "default" (reuse font used before) font worked before in basic cases is an accident
            // - readers dealing smartly with brokenness of jsPDF's markup.
            out(
                'BT\n/' +
                    activeFontKey + ' ' + activeFontSize + ' Tf\n' + // font face, style, size
                      activeFontSize + ' TL\n' + // line spacing
                     textColor +
                    '\n' + f2(x * k) + ' ' + f2((pageHeight - y) * k) + ' Td\n<' +
                    str +
                    '> Tj\nET'
            );

            return this;
        };
        /**
        Adds text to page. Supports adding multiline text when 'text' argument is an Array of Strings.
        @function
        @param {String|Array} text String or array of strings to be added to the page. Each line is shifted one line down per font, spacing settings declared before this call.
        @param {Number} x Coordinate (in units declared at inception of PDF document) against left edge of the page
        @param {Number} y Coordinate (in units declared at inception of PDF document) against upper edge of the page
        @param {Object} flags Collection of settings signalling how the text must be encoded. Defaults are sane. If you think you want to pass some flags, you likely can read the source.
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name text
         */
        API.text = function (text, x, y, flags) {
            /**
             * Inserts something like this into PDF
                BT
                /F1 16 Tf  % Font name + size
                16 TL % How many units down for next line in multiline text
                0 g % color
                28.35 813.54 Td % position
                (line one) Tj
                T* (line two) Tj
                T* (line three) Tj
                ET
            */

            var undef, _first, _second, _third, newtext, str, i;
            if (typeof text === 'number') {
                _first = y;
                _second = text;
                _third = x;

                text = _first;
                x = _second;
                y = _third;
            }

            if (typeof text === 'string' && text.match(/[\n\r]/)) {
                text = text.split(/\r\n|\r|\n/g);
            }

            if (typeof flags === 'undefined') {
                flags = { 'noBOM': true, 'autoencode': true };
            } else {

                if (flags.noBOM === undef) {
                    flags.noBOM = true;
                }

                if (flags.autoencode === undef) {
                    flags.autoencode = true;
                }

            }

            if (typeof text === 'string') {
                str = pdfEscape(text, flags);
            } else if (text instanceof Array) {  /* Array */
                // we don't want to destroy  original text array, so cloning it
                newtext = text.concat();
                // we do array.join('text that must not be PDFescaped")
                // thus, pdfEscape each component separately
                for (i = newtext.length - 1; i !== -1; i--) {
                    newtext[i] = pdfEscape(newtext[i], flags);
                }
                str = newtext.join(") Tj\nT* (");
            } else {
                throw new Error('Type of text must be string or Array. "' + text + '" is not recognized.');
            }
            out(
             'BT\n/' +
                 activeFontKey + ' ' + activeFontSize + ' Tf\n' + // font face, style, size
                 activeFontSize + ' TL\n' + // line spacing
                 textColor +
                 '\n' + f2(x * k) + ' ' + f2((pageHeight - y) * k) + ' Td\n(' +
                 str +
                 ') Tj\nET'
         );
            return this;
        };

        API.line = function (x1, y1, x2, y2) {
            out(
                f2(x1 * k) + ' ' + f2((pageHeight - y1) * k) + ' m ' +
                    f2(x2 * k) + ' ' + f2((pageHeight - y2) * k) + ' l S'
            );
            return this;
        };

        /**
        Adds series of curves (straight lines or cubic bezier curves) to canvas, starting at `x`, `y` coordinates.
        All data points in `lines` are relative to last line origin.
        `x`, `y` become x1,y1 for first line / curve in the set.
        For lines you only need to specify [x2, y2] - (ending point) vector against x1, y1 starting point.
        For bezier curves you need to specify [x2,y2,x3,y3,x4,y4] - vectors to control points 1, 2, ending point. All vectors are against the start of the curve - x1,y1.

        @example .lines([[2,2],[-2,2],[1,1,2,2,3,3],[2,1]], 212,110, 10) // line, line, bezier curve, line
        @param {Array} lines Array of *vector* shifts as pairs (lines) or sextets (cubic bezier curves).
        @param {Number} x Coordinate (in units declared at inception of PDF document) against left edge of the page
        @param {Number} y Coordinate (in units declared at inception of PDF document) against upper edge of the page
        @param {Number} scale (Defaults to [1.0,1.0]) x,y Scaling factor for all vectors. Elements can be any floating number Sub-one makes drawing smaller. Over-one grows the drawing. Negative flips the direction.
        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name lines
         */
        API.lines = function (lines, x, y, scale, style) {
            var undef, _first, _second, _third, scalex, scaley, i, l, leg, x2, y2, x3, y3, x4, y4;

            // Pre-August-2012 the order of arguments was function(x, y, lines, scale, style)
            // in effort to make all calls have similar signature like
            //   function(content, coordinateX, coordinateY , miscellaneous)
            // this method had its args flipped.
            // code below allows backward compatibility with old arg order.
            if (typeof lines === 'number') {
                _first = y;
                _second = lines;
                _third = x;

                lines = _first;
                x = _second;
                y = _third;
            }

            style = getStyle(style);
            scale = scale === undef ? [1, 1] : scale;

            // starting point
            out(f3(x * k) + ' ' + f3((pageHeight - y) * k) + ' m ');

            scalex = scale[0];
            scaley = scale[1];
            l = lines.length;
            //, x2, y2 // bezier only. In page default measurement "units", *after* scaling
            //, x3, y3 // bezier only. In page default measurement "units", *after* scaling
            // ending point for all, lines and bezier. . In page default measurement "units", *after* scaling
            x4 = x; // last / ending point = starting point for first item.
            y4 = y; // last / ending point = starting point for first item.

            for (i = 0; i < l; i++) {
                leg = lines[i];
                if (leg.length === 2) {
                    // simple line
                    x4 = leg[0] * scalex + x4; // here last x4 was prior ending point
                    y4 = leg[1] * scaley + y4; // here last y4 was prior ending point
                    out(f3(x4 * k) + ' ' + f3((pageHeight - y4) * k) + ' l');
                } else {
                    // bezier curve
                    x2 = leg[0] * scalex + x4; // here last x4 is prior ending point
                    y2 = leg[1] * scaley + y4; // here last y4 is prior ending point
                    x3 = leg[2] * scalex + x4; // here last x4 is prior ending point
                    y3 = leg[3] * scaley + y4; // here last y4 is prior ending point
                    x4 = leg[4] * scalex + x4; // here last x4 was prior ending point
                    y4 = leg[5] * scaley + y4; // here last y4 was prior ending point
                    out(
                        f3(x2 * k) + ' ' +
                            f3((pageHeight - y2) * k) + ' ' +
                            f3(x3 * k) + ' ' +
                            f3((pageHeight - y3) * k) + ' ' +
                            f3(x4 * k) + ' ' +
                            f3((pageHeight - y4) * k) + ' c'
                    );
                }
            }
            // stroking / filling / both the path
            out(style);
            return this;
        };

        /**
        Adds a rectangle to PDF

        @param {Number} x Coordinate (in units declared at inception of PDF document) against left edge of the page
        @param {Number} y Coordinate (in units declared at inception of PDF document) against upper edge of the page
        @param {Number} w Width (in units declared at inception of PDF document)
        @param {Number} h Height (in units declared at inception of PDF document)
        @param {String} style (Defaults to active fill/stroke style) A string signalling if stroke, fill or both are to be applied.
        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name rect
         */
        API.rect = function (x, y, w, h, style) {
            var op = getStyle(style);
            out([
                f2(x * k),
                f2((pageHeight - y) * k),
                f2(w * k),
                f2(-h * k),
                're',
                op
            ].join(' '));
            return this;
        };

        /**
        Adds a triangle to PDF

        @param {Number} x1 Coordinate (in units declared at inception of PDF document) against left edge of the page
        @param {Number} y1 Coordinate (in units declared at inception of PDF document) against upper edge of the page
        @param {Number} x2 Coordinate (in units declared at inception of PDF document) against left edge of the page
        @param {Number} y2 Coordinate (in units declared at inception of PDF document) against upper edge of the page
        @param {Number} x3 Coordinate (in units declared at inception of PDF document) against left edge of the page
        @param {Number} y3 Coordinate (in units declared at inception of PDF document) against upper edge of the page
        @param {String} style (Defaults to active fill/stroke style) A string signalling if stroke, fill or both are to be applied.
        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name triangle
         */
        API.triangle = function (x1, y1, x2, y2, x3, y3, style) {
            this.lines(
                [
                    [x2 - x1, y2 - y1], // vector to point 2
                    [x3 - x2, y3 - y2], // vector to point 3
                    [x1 - x3, y1 - y3] // closing vector back to point 1
                ],
                x1,
                y1, // start of path
                [1, 1],
                style
            );
            return this;
        };

        /**
        Adds a rectangle with rounded corners to PDF

        @param {Number} x Coordinate (in units declared at inception of PDF document) against left edge of the page
        @param {Number} y Coordinate (in units declared at inception of PDF document) against upper edge of the page
        @param {Number} w Width (in units declared at inception of PDF document)
        @param {Number} h Height (in units declared at inception of PDF document)
        @param {Number} rx Radius along x axis (in units declared at inception of PDF document)
        @param {Number} rx Radius along y axis (in units declared at inception of PDF document)
        @param {String} style (Defaults to active fill/stroke style) A string signalling if stroke, fill or both are to be applied.
        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name roundedRect
        */
        API.roundedRect = function (x, y, w, h, rx, ry, style) {
            var MyArc = 4 / 3 * (Math.SQRT2 - 1);
            this.lines(
                [
                    [(w - 2 * rx), 0],
                    [(rx * MyArc), 0, rx, ry - (ry * MyArc), rx, ry],
                    [0, (h - 2 * ry)],
                    [0, (ry * MyArc), -(rx * MyArc), ry, -rx, ry],
                    [(-w + 2 * rx), 0],
                    [-(rx * MyArc), 0, -rx, -(ry * MyArc), -rx, -ry],
                    [0, (-h + 2 * ry)],
                    [0, -(ry * MyArc), (rx * MyArc), -ry, rx, -ry]
                ],
                x + rx,
                y, // start of path
                [1, 1],
                style
            );
            return this;
        };

        /**
        Adds an ellipse to PDF

        @param {Number} x Coordinate (in units declared at inception of PDF document) against left edge of the page
        @param {Number} y Coordinate (in units declared at inception of PDF document) against upper edge of the page
        @param {Number} rx Radius along x axis (in units declared at inception of PDF document)
        @param {Number} rx Radius along y axis (in units declared at inception of PDF document)
        @param {String} style (Defaults to active fill/stroke style) A string signalling if stroke, fill or both are to be applied.
        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name ellipse
         */
        API.ellipse = function (x, y, rx, ry, style) {
            var op = getStyle(style),
                lx = 4 / 3 * (Math.SQRT2 - 1) * rx,
                ly = 4 / 3 * (Math.SQRT2 - 1) * ry;

            out([
                f2((x + rx) * k),
                f2((pageHeight - y) * k),
                'm',
                f2((x + rx) * k),
                f2((pageHeight - (y - ly)) * k),
                f2((x + lx) * k),
                f2((pageHeight - (y - ry)) * k),
                f2(x * k),
                f2((pageHeight - (y - ry)) * k),
                'c'
            ].join(' '));
            out([
                f2((x - lx) * k),
                f2((pageHeight - (y - ry)) * k),
                f2((x - rx) * k),
                f2((pageHeight - (y - ly)) * k),
                f2((x - rx) * k),
                f2((pageHeight - y) * k),
                'c'
            ].join(' '));
            out([
                f2((x - rx) * k),
                f2((pageHeight - (y + ly)) * k),
                f2((x - lx) * k),
                f2((pageHeight - (y + ry)) * k),
                f2(x * k),
                f2((pageHeight - (y + ry)) * k),
                'c'
            ].join(' '));
            out([
                f2((x + lx) * k),
                f2((pageHeight - (y + ry)) * k),
                f2((x + rx) * k),
                f2((pageHeight - (y + ly)) * k),
                f2((x + rx) * k),
                f2((pageHeight - y) * k),
                'c',
                op
            ].join(' '));
            return this;
        };

        /**
        Adds an circle to PDF

        @param {Number} x Coordinate (in units declared at inception of PDF document) against left edge of the page
        @param {Number} y Coordinate (in units declared at inception of PDF document) against upper edge of the page
        @param {Number} r Radius (in units declared at inception of PDF document)
        @param {String} style (Defaults to active fill/stroke style) A string signalling if stroke, fill or both are to be applied.
        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name circle
         */
        API.circle = function (x, y, r, style) {
            return this.ellipse(x, y, r, r, style);
        };

        /**
        Adds a properties to the PDF document

        @param {Object} A property_name-to-property_value object structure.
        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name setProperties
         */
        API.setProperties = function (properties) {
            // copying only those properties we can render.
            var property;
            for (property in documentProperties) {
                if (documentProperties.hasOwnProperty(property) && properties[property]) {
                    documentProperties[property] = properties[property];
                }
            }
            return this;
        };

        /**
        Sets font size for upcoming text elements.

        @param {Number} size Font size in points.
        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name setFontSize
         */
        API.setFontSize = function (size) {
            activeFontSize = size;
            return this;
        };

        /**
        Sets text font face, variant for upcoming text elements.
        See output of pdfDataExport.getFontList() for possible font names, styles.

        @param {String} fontName Font name or family. Example: "times"
        @param {String} fontStyle Font style or variant. Example: "italic"
        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name setFont
         */
        API.setFont = function (fontName, fontStyle) {
            activeFontKey = getFont(fontName, fontStyle);
            // if font is not found, the above line blows up and we never go further
            return this;
        };

        /**
        Switches font style or variant for upcoming text elements,
        while keeping the font face or family same.
        See output of pdfDataExport.getFontList() for possible font names, styles.

        @param {String} style Font style or variant. Example: "italic"
        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name setFontStyle
         */
        API.setFontStyle = API.setFontType = function (style) {
            var undef;
            activeFontKey = getFont(undef, style);
            // if font is not found, the above line blows up and we never go further
            return this;
        };

        /**
        Returns an object - a tree of fontName to fontStyle relationships available to
        active PDF document.

        @public
        @function
        @returns {Object} Like {'times':['normal', 'italic', ... ], 'arial':['normal', 'bold', ... ], ... }
        @methodOf pdfDataExport#
        @name getFontList
        */
        API.getFontList = function () {
            // TODO: iterate over fonts array or return copy of fontmap instead in case more are ever added.
            var list = {},
                fontName,
                fontStyle,
                tmp;

            for (fontName in fontmap) {
                if (fontmap.hasOwnProperty(fontName)) {
                    list[fontName] = tmp = [];
                    for (fontStyle in fontmap[fontName]) {
                        if (fontmap[fontName].hasOwnProperty(fontStyle)) {
                            tmp.push(fontStyle);
                        }
                    }
                }
            }

            return list;
        };

        /**
        Sets line width for upcoming lines.

        @param {Number} width Line width (in units declared at inception of PDF document)
        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name setLineWidth
         */
        API.setLineWidth = function (width) {
            out((width * k).toFixed(2) + ' w');
            return this;
        };

        /**
        Sets the stroke color for upcoming elements.

        Depending on the number of arguments given, Gray, RGB, or CMYK
        color space is implied.

        When only ch1 is given, "Gray" color space is implied and it
        must be a value in the range from 0.00 (solid black) to to 1.00 (white)
        if values are communicated as String types, or in range from 0 (black)
        to 255 (white) if communicated as Number type.
        The RGB-like 0-255 range is provided for backward compatibility.

        When only ch1,ch2,ch3 are given, "RGB" color space is implied and each
        value must be in the range from 0.00 (minimum intensity) to to 1.00
        (max intensity) if values are communicated as String types, or
        from 0 (min intensity) to to 255 (max intensity) if values are communicated
        as Number types.
        The RGB-like 0-255 range is provided for backward compatibility.

        When ch1,ch2,ch3,ch4 are given, "CMYK" color space is implied and each
        value must be a in the range from 0.00 (0% concentration) to to
        1.00 (100% concentration)

        Because JavaScript treats fixed point numbers badly (rounds to
        floating point nearest to binary representation) it is highly advised to
        communicate the fractional numbers as String types, not JavaScript Number type.

        @param {Number|String} ch1 Color channel value
        @param {Number|String} ch2 Color channel value
        @param {Number|String} ch3 Color channel value
        @param {Number|String} ch4 Color channel value

        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name setDrawColor
         */
        API.setDrawColor = function (ch1, ch2, ch3, ch4) {
            var color;
            if (ch2 === undefined || (ch4 === undefined && ch1 === ch2 === ch3)) {
                // Gray color space.
                if (typeof ch1 === 'string') {
                    color = ch1 + ' G';
                } else {
                    color = f2(ch1 / 255) + ' G';
                }
            } else if (ch4 === undefined) {
                // RGB
                if (typeof ch1 === 'string') {
                    color = [ch1, ch2, ch3, 'RG'].join(' ');
                } else {
                    color = [f2(ch1 / 255), f2(ch2 / 255), f2(ch3 / 255), 'RG'].join(' ');
                }
            } else {
                // CMYK
                if (typeof ch1 === 'string') {
                    color = [ch1, ch2, ch3, ch4, 'K'].join(' ');
                } else {
                    color = [f2(ch1), f2(ch2), f2(ch3), f2(ch4), 'K'].join(' ');
                }
            }

            out(color);
            return this;
        };

        /**
        Sets the fill color for upcoming elements.

        Depending on the number of arguments given, Gray, RGB, or CMYK
        color space is implied.

        When only ch1 is given, "Gray" color space is implied and it
        must be a value in the range from 0.00 (solid black) to to 1.00 (white)
        if values are communicated as String types, or in range from 0 (black)
        to 255 (white) if communicated as Number type.
        The RGB-like 0-255 range is provided for backward compatibility.

        When only ch1,ch2,ch3 are given, "RGB" color space is implied and each
        value must be in the range from 0.00 (minimum intensity) to to 1.00
        (max intensity) if values are communicated as String types, or
        from 0 (min intensity) to to 255 (max intensity) if values are communicated
        as Number types.
        The RGB-like 0-255 range is provided for backward compatibility.

        When ch1,ch2,ch3,ch4 are given, "CMYK" color space is implied and each
        value must be a in the range from 0.00 (0% concentration) to to
        1.00 (100% concentration)

        Because JavaScript treats fixed point numbers badly (rounds to
        floating point nearest to binary representation) it is highly advised to
        communicate the fractional numbers as String types, not JavaScript Number type.

        @param {Number|String} ch1 Color channel value
        @param {Number|String} ch2 Color channel value
        @param {Number|String} ch3 Color channel value
        @param {Number|String} ch4 Color channel value

        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name setFillColor
         */
        API.setFillColor = function (ch1, ch2, ch3, ch4) {
            var color;

            if (ch2 === undefined || (ch4 === undefined && ch1 === ch2 === ch3)) {
                // Gray color space.
                if (typeof ch1 === 'string') {
                    color = ch1 + ' g';
                } else {
                    color = f2(ch1 / 255) + ' g';
                }
            } else if (ch4 === undefined) {
                // RGB
                if (typeof ch1 === 'string') {
                    color = [ch1, ch2, ch3, 'rg'].join(' ');
                } else {
                    color = [f2(ch1 / 255), f2(ch2 / 255), f2(ch3 / 255), 'rg'].join(' ');
                }
            } else {
                // CMYK
                if (typeof ch1 === 'string') {
                    color = [ch1, ch2, ch3, ch4, 'k'].join(' ');
                } else {
                    color = [f2(ch1), f2(ch2), f2(ch3), f2(ch4), 'k'].join(' ');
                }
            }

            out(color);
            return this;
        };

        /**
        Sets the text color for upcoming elements.
        If only one, first argument is given,
        treats the value as gray-scale color value.

        @param {Number} r Red channel color value in range 0-255
        @param {Number} g Green channel color value in range 0-255
        @param {Number} b Blue channel color value in range 0-255
        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name setTextColor
        */
        API.setTextColor = function (r, g, b) {
            if ((r === 0 && g === 0 && b === 0) || (typeof g === 'undefined')) {
                textColor = f3(r / 255) + ' g';
            } else {
                textColor = [f3(r / 255), f3(g / 255), f3(b / 255), 'rg'].join(' ');
            }
            return this;
        };

        /**
        Is an Object providing a mapping from human-readable to
        integer flag values designating the varieties of line cap
        and join styles.

        @returns {Object}
        @fieldOf pdfDataExport#
        @name CapJoinStyles
        */
        API.CapJoinStyles = {
            0: 0,
            'butt': 0,
            'but': 0,
            'bevel': 0,
            1: 1,
            'round': 1,
            'rounded': 1,
            'circle': 1,
            2: 2,
            'projecting': 2,
            'project': 2,
            'square': 2,
            'milter': 2
        };

        /**
        Sets the line cap styles
        See {pdfDataExport.CapJoinStyles} for variants

        @param {String|Number} style A string or number identifying the type of line cap
        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name setLineCap
        */
        API.setLineCap = function (style) {
            var id = this.CapJoinStyles[style];
            if (id === undefined) {
                throw new Error("Line cap style of '" + style + "' is not recognized. See or extend .CapJoinStyles property for valid styles");
            }
            lineCapID = id;
            out(id.toString(10) + ' J');

            return this;
        };

        /**
        Sets the line join styles
        See {pdfDataExport.CapJoinStyles} for variants

        @param {String|Number} style A string or number identifying the type of line join
        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name setLineJoin
        */
        API.setLineJoin = function (style) {
            var id = this.CapJoinStyles[style];
            if (id === undefined) {
                throw new Error("Line join style of '" + style + "' is not recognized. See or extend .CapJoinStyles property for valid styles");
            }
            lineJoinID = id;
            out(id.toString(10) + ' j');

            return this;
        };

        // Output is both an internal (for plugins) and external function
        API.output = output;

        /**
         * Saves as PDF document. An alias of pdfDataExport.output('save', 'filename.pdf')
         * @param  {String} filename The filename including extension.
         *
         * @function
         * @returns {pdfDataExport}
         * @methodOf pdfDataExport#
         * @name save
         */
        API.save = function (filename) {
            API.output('save', filename);
        };

        // applying plugins (more methods) ON TOP of built-in API.
        // this is intentional as we allow plugins to override
        // built-ins
        for (plugin in pdfDataExport.API) {
            if (pdfDataExport.API.hasOwnProperty(plugin)) {
                if (plugin === 'events' && pdfDataExport.API.events.length) {
                    (function (events, newEvents) {

                        // pdfDataExport.API.events is a JS Array of Arrays
                        // where each Array is a pair of event name, handler
                        // Events were added by plugins to the pdfDataExport instantiator.
                        // These are always added to the new instance and some ran
                        // during instantiation.

                        var eventname, handler_and_args, i;

                        for (i = newEvents.length - 1; i !== -1; i--) {
                            // subscribe takes 3 args: 'topic', function, runonce_flag
                            // if undefined, runonce is false.
                            // users can attach callback directly,
                            // or they can attach an array with [callback, runonce_flag]
                            // that's what the "apply" magic is for below.
                            eventname = newEvents[i][0];
                            handler_and_args = newEvents[i][1];
                            events.subscribe.apply(
                                events,
                                [eventname].concat(
                                    typeof handler_and_args === 'function' ?
                                            [handler_and_args] :
                                            handler_and_args
                                )
                            );
                        }
                    }(events, pdfDataExport.API.events));
                } else {
                    API[plugin] = pdfDataExport.API[plugin];
                }
            }
        }

        /////////////////////////////////////////
        // continuing initilisation of pdfDataExport Document object
        /////////////////////////////////////////


        // Add the first page automatically
        addFonts();
        activeFontKey = 'F1';
        _addPage();

        events.publish('initialized');

        return API;
    }

    /**
    pdfDataExport.API is a STATIC property of pdfDataExport class.
    pdfDataExport.API is an object you can add methods and properties to.
    The methods / properties you add will show up in new pdfDataExport objects.
    
    One property is prepopulated. It is the 'events' Object. Plugin authors can add topics, callbacks to this object. These will be reassigned to all new instances of pdfDataExport.
    Examples:
        pdfDataExport.API.events['initialized'] = function(){ 'this' is API object }
        pdfDataExport.API.events['addFont'] = function(added_font_object){ 'this' is API object }
    
    @static
    @public
    @memberOf pdfDataExport
    @name API
    
    @example
        pdfDataExport.API.mymethod = function(){
            // 'this' will be ref to internal API object. see pdfDataExport source
            // , so you can refer to built-in methods like so:
            //     this.line(....)
            //     this.text(....)
        }
        var pdfdoc = new pdfDataExport()
        pdfdoc.mymethod() // <- !!!!!!
    */
    pdfDataExport.API = { 'events': [] };

    return pdfDataExport;
}());

(function (pdfDataExportAPI) {
    'use strict';
    /*jslint browser:true */
    /*global document: false, pdfDataExport */

    var maxLn = 0,
        lnP = 0,
        fontName,
        fontSize,
        fontStyle,
        lastCellPos = { x: undefined, y: undefined, w: undefined, h: undefined, ln: undefined },
        pages = 1,
        newPage = false,
        setLastCellPosition = function (x, y, w, h, ln) {
            lastCellPos = { x: x, y: y, w: w, h: h, ln: ln };
        },
        getLastCellPosition = function () {
            return lastCellPos;
        },
        setMaxLn = function (x) {
            maxLn = x;
        },
        getMaxLn = function () {
            return maxLn;
        },
        setLnP = function (x) {
            lnP = x;
        },
        getLnP = function (x) {
            return lnP;
        };

    pdfDataExportAPI.getTextDimensions = function (txt) {
        fontName = this.internal.getFont().fontName;
        fontSize = this.internal.getFontSize();
        fontStyle = this.internal.getFont().fontStyle;

        // 1 pixel = 0.264583 mm and 1 mm = 72/25.4 point
        var px2pt = 0.264583 * 72 / 25.4,
            dimensions,
            text;

        text = document.createElement('font');
        text.id = "pdfDataExportCell";
        text.style.fontStyle = fontStyle;
        text.style.fontName = fontName;
        text.style.fontSize = fontSize + 'pt';
        text.innerHTML = txt;

        document.body.appendChild(text);

        dimensions = { w: (text.offsetWidth + 1) * px2pt, h: (text.offsetHeight + 1) * px2pt };

        document.body.removeChild(text);

        return dimensions;
    };

    pdfDataExportAPI.cellAddPage = function () {
        this.addPage();
        setLastCellPosition(undefined, undefined, undefined, undefined, undefined);
        newPage = true;
        pages += 1;
        setLnP(1);
    };

    pdfDataExportAPI.cellInitialize = function () {
        maxLn = 0;
        lastCellPos = { x: undefined, y: undefined, w: undefined, h: undefined, ln: undefined };
        pages = 1;
        newPage = false;
        setLnP(0);
    };

    pdfDataExportAPI.cell = function (x, y, w, h, txt, ln) {
        this.lnMod = this.lnMod === undefined ? 0 : this.lnMod;
        if (this.printingHeaderRow !== true && this.lnMod !== 0) {
            ln = ln + this.lnMod;
        }

        if ((((ln * h) + y + (h * 2)) / pages) >= this.internal.pageSize.height && pages === 1 && !newPage) {
            this.cellAddPage();

            if (this.printHeaders && this.tableHeaderRow) {
                this.printHeaderRow(ln);
                this.lnMod += 1;
                ln += 1;
            }
            if (getMaxLn() === 0) {
                setMaxLn(Math.round((this.internal.pageSize.height - (h * 2)) / h));
            }
        } else if (newPage && getLastCellPosition().ln !== ln && getLnP() === getMaxLn()) {
            this.cellAddPage();

            if (this.printHeaders && this.tableHeaderRow) {
                this.printHeaderRow(ln);
                this.lnMod += 1;
                ln += 1;
            }
        }

        var curCell = getLastCellPosition(),
            dim = this.getTextDimensions(txt),
            isNewLn = 1;
        if (curCell.x !== undefined && curCell.ln === ln) {
            x = curCell.x + curCell.w;
        }
        if (curCell.y !== undefined && curCell.y === y) {
            y = curCell.y;
        }
        if (curCell.h !== undefined && curCell.h === h) {
            h = curCell.h;
        }
        if (curCell.ln !== undefined && curCell.ln === ln) {
            ln = curCell.ln;
            isNewLn = 0;
        }
        if (newPage) {
            y = h * (getLnP() + isNewLn);
        } else {
            y = (y + (h * Math.abs(getMaxLn() * pages - ln - getMaxLn())));
        }
        this.rect(x, y, w, h);
        var match = /[а-яА-ЯЁё]/.test(txt);
        if (match) {
            this.text16(txt, x + 3, y + h - 3);
        }
        else {
            this.text(txt, x + 3, y + h - 3);
        }
        setLnP(getLnP() + isNewLn);
        setLastCellPosition(x, y, w, h, ln);
        return this;
    };

    /**
     * Return an array containing all of the owned keys of an Object
     * @type {Function}
     * @return {String[]} of Object keys
     */
    pdfDataExportAPI.getKeys = (typeof Object.keys === 'function')
        ? function (object) {
            if (!object) {
                return [];
            }
            return Object.keys(object);
        }
            : function (object) {
                var keys = [],
                    property;

                for (property in object) {
                    if (object.hasOwnProperty(property)) {
                        keys.push(property);
                    }
                }

                return keys;
            };

    /**
     * Return the maximum value from an array
     * @param array
     * @param comparisonFn
     * @returns {*}
     */
    pdfDataExportAPI.arrayMax = function (array, comparisonFn) {
        var max = array[0],
            i,
            ln,
            item;

        for (i = 0, ln = array.length; i < ln; i += 1) {
            item = array[i];

            if (comparisonFn) {
                if (comparisonFn(max, item) === -1) {
                    max = item;
                }
            } else {
                if (item > max) {
                    max = item;
                }
            }
        }

        return max;
    };

    /**
     * Create a table from a set of data.
     * @param {Object[]} data As array of objects containing key-value pairs
     * @param {String[]} [headers] Omit or null to auto-generate headers at a performance cost
     * @param {Object} [config.printHeaders] True to print column headers at the top of every page
     * @param {Object} [config.autoSize] True to dynamically set the column widths to match the widest cell value
     * @param {Object} [config.autoStretch] True to force the table to fit the width of the page
     */
    pdfDataExportAPI.table = function (data, headers, config) {

        var headerNames = [],
            headerPrompts = [],
            header,
            autoSize,
            printHeaders,
            autoStretch,
            i,
            ln,
            columnMatrix = {},
            columnWidths = {},
            columnData,
            column,
            columnMinWidths = [],
            j,
            tableHeaderConfigs = [],
            model,
            jln,
            func;

        /**
         * @property {Number} lnMod
         * Keep track of the current line number modifier used when creating cells
         */
        this.lnMod = 0;

        if (config) {
            autoSize = config.autoSize || false;
            printHeaders = this.printHeaders = config.printHeaders || true;
            autoStretch = config.autoStretch || true;
        }

        if (!data) {
            throw 'No data for PDF table';
        }

        // Set headers
        if (headers === undefined || (headers === null)) {

            // No headers defined so we derive from data
            headerNames = this.getKeys(data[0]);

        } else if (headers[0] && (typeof headers[0] !== 'string')) {

            // Split header configs into names and prompts
            for (i = 0, ln = headers.length; i < ln; i += 1) {
                header = headers[i];
                headerNames.push(header.name);
                headerPrompts.push(header.prompt);
            }

        } else {
            headerNames = headers;
        }

        if (config.autoSize) {

            // Create Columns Matrix

            func = function (rec) {
                return rec[header];
            };

            for (i = 0, ln = headerNames.length; i < ln; i += 1) {
                header = headerNames[i];

                columnMatrix[header] = data.map(
                    func
                );

                // get header width
                columnMinWidths.push(this.getTextDimensions(headerPrompts[i] || header).w);

                column = columnMatrix[header];

                // get cell widths
                for (j = 0, ln = column.length; j < ln; j += 1) {
                    columnData = column[j];

                    columnMinWidths.push(this.getTextDimensions(columnData).w);
                }

                // get final column width
                columnWidths[header] = pdfDataExportAPI.arrayMax(columnMinWidths);
            }
        }

        // -- Construct the table

        if (config.printHeaders) {

            // Construct the header row
            for (i = 0, ln = headerNames.length; i < ln; i += 1) {
                header = headerNames[i];
                tableHeaderConfigs.push([10, 10, columnWidths[header], 25, String(headerPrompts.length ? headerPrompts[i] : header)]);
            }

            // Store the table header config
            this.setTableHeaderRow(tableHeaderConfigs);

            // Print the header for the start of the table
            this.printHeaderRow(1);
        }

        // Construct the data rows
        for (i = 0, ln = data.length; i < ln; i += 1) {
            model = data[i];

            for (j = 0, jln = headerNames.length; j < jln; j += 1) {
                header = headerNames[j];
                this.cell(10, 10, columnWidths[header], 25, String(model[header]), i + 2);
            }
        }

        return this;
    };

    /**
     * Store the config for outputting a table header
     * @param {Object[]} config
     * An array of cell configs that would define a header row: Each config matches the config used by pdfDataExportAPI.cell
     * except the ln parameter is excluded
     */
    pdfDataExportAPI.setTableHeaderRow = function (config) {
        this.tableHeaderRow = config;
    };

    /**
     * Output the store header row
     * @param lineNumber The line number to output the header at
     */
    pdfDataExportAPI.printHeaderRow = function (lineNumber) {
        if (!this.tableHeaderRow) {
            throw 'Property tableHeaderRow does not exist.';
        }

        var tableHeaderCell,
            tmpArray,
            i,
            ln;

        this.printingHeaderRow = true;

        for (i = 0, ln = this.tableHeaderRow.length; i < ln; i += 1) {

            tableHeaderCell = this.tableHeaderRow[i];
            tmpArray = [].concat(tableHeaderCell);

            this.cell.apply(this, tmpArray.concat(lineNumber));
        }

        this.printingHeaderRow = false;
    };

}(pdfDataExport.API));


; (function (API) {
    'use strict'

    /**
    Returns an array of length matching length of the 'word' string, with each
    cell ocupied by the width of the char in that position.
    
    @function
    @param word {String}
    @param widths {Object}
    @param kerning {Object}
    @returns {Array}
    */
    var getCharWidthsArray = API.getCharWidthsArray = function (text, options) {

        if (!options) {
            options = {}
        }

        var widths = options.widths ? options.widths : this.internal.getFont().metadata.Unicode.widths
        , widthsFractionOf = widths.fof ? widths.fof : 1
        , kerning = options.kerning ? options.kerning : this.internal.getFont().metadata.Unicode.kerning
        , kerningFractionOf = kerning.fof ? kerning.fof : 1

        // console.log("widths, kergnings", widths, kerning)

        var i, l
        , char_code
        , char_width
        , prior_char_code = 0 // for kerning
        , default_char_width = widths[0] || widthsFractionOf
        , output = []

        for (i = 0, l = text.length; i < l; i++) {
            char_code = text.charCodeAt(i)
            output.push(
                (widths[char_code] || default_char_width) / widthsFractionOf +
                (kerning[char_code] && kerning[char_code][prior_char_code] || 0) / kerningFractionOf
            )
            prior_char_code = char_code
        }

        return output
    }
    var getArraySum = function (array) {
        var i = array.length
        , output = 0
        while (i) {
            ; i--;
            output += array[i]
        }
        return output
    }
    /**
    Returns a widths of string in a given font, if the font size is set as 1 point.
    
    In other words, this is "proportional" value. For 1 unit of font size, the length
    of the string will be that much.
    
    Multiply by font size to get actual width in *points*
    Then divide by 72 to get inches or divide by (72/25.6) to get 'mm' etc.
    
    @public
    @function
    @param
    @returns {Type}
    */
    var getStringUnitWidth = API.getStringUnitWidth = function (text, options) {
        return getArraySum(getCharWidthsArray.call(this, text, options))
    }

    /** 
    returns array of lines
    */
    var splitLongWord = function (word, widths_array, firstLineMaxLen, maxLen) {
        var answer = []

        // 1st, chop off the piece that can fit on the hanging line.
        var i = 0
        , l = word.length
        , workingLen = 0
        while (i !== l && workingLen + widths_array[i] < firstLineMaxLen) {
            workingLen += widths_array[i]
            ; i++;
        }
        // this is first line.
        answer.push(word.slice(0, i))

        // 2nd. Split the rest in