
/* Release Date: June-03-2025 
Copyright (c) 2011-2025 jQWidgets. 
License: https://jqwidgets.com/license/ */


/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 2497:
/***/ ((module) => {

/* tslint:disable */
/* eslint-disable */
/* tslint:disable */
/* eslint-disable */
(function() {
	if (typeof document === 'undefined') { 
		return;
	}
/*!
 * Globalize
 *
 * http://github.com/jquery/globalize
 *
 * Copyright Software Freedom Conservancy, Inc.
 * Dual licensed under the MIT or GPL Version 2 licenses.
 * http://jquery.org/license
 */

(function( window, undefined ) {
if (document.Globalize) {
    return;
}

var Globalize,
	// private variables
	regexHex,
	regexInfinity,
	regexParseFloat,
	regexTrim,
	// private JavaScript utility functions
	arrayIndexOf,
	endsWith,
	extend,
	isArray,
	isFunction,
	isObject,
	startsWith,
	trim,
	truncate,
	zeroPad,
	// private Globalization utility functions
	appendPreOrPostMatch,
	expandFormat,
	formatDate,
	formatNumber,
	getTokenRegExp,
	getEra,
	getEraYear,
	parseExact,
	parseNegativePattern;

// Global variable (Globalize) or CommonJS module (globalize)
Globalize = function( cultureSelector ) {
	return new Globalize.prototype.init( cultureSelector );
};

if ( true ) {
	// Assume CommonJS
	module.exports = Globalize;
} else {}

Globalize.cultures = {};

Globalize.prototype = {
	constructor: Globalize,
	init: function( cultureSelector ) {
		this.cultures = Globalize.cultures;
		this.cultureSelector = cultureSelector;

		return this;
	}
};
Globalize.prototype.init.prototype = Globalize.prototype;

// 1. When defining a culture, all fields are required except the ones stated as optional.
// 2. Each culture should have a ".calendars" object with at least one calendar named "standard"
//    which serves as the default calendar in use by that culture.
// 3. Each culture should have a ".calendar" object which is the current calendar being used,
//    it may be dynamically changed at any time to one of the calendars in ".calendars".
Globalize.cultures[ "default" ] = {
	// A unique name for the culture in the form <language code>-<country/region code>
	name: "en",
	// the name of the culture in the english language
	englishName: "English",
	// the name of the culture in its own language
	nativeName: "English",
	// whether the culture uses right-to-left text
	isRTL: false,
	// "language" is used for so-called "specific" cultures.
	// For example, the culture "es-CL" means "Spanish, in Chili".
	// It represents the Spanish-speaking culture as it is in Chili,
	// which might have different formatting rules or even translations
	// than Spanish in Spain. A "neutral" culture is one that is not
	// specific to a region. For example, the culture "es" is the generic
	// Spanish culture, which may be a more generalized version of the language
	// that may or may not be what a specific culture expects.
	// For a specific culture like "es-CL", the "language" field refers to the
	// neutral, generic culture information for the language it is using.
	// This is not always a simple matter of the string before the dash.
	// For example, the "zh-Hans" culture is netural (Simplified Chinese).
	// And the "zh-SG" culture is Simplified Chinese in Singapore, whose lanugage
	// field is "zh-CHS", not "zh".
	// This field should be used to navigate from a specific culture to it's
	// more general, neutral culture. If a culture is already as general as it
	// can get, the language may refer to itself.
	language: "en",
	// numberFormat defines general number formatting rules, like the digits in
	// each grouping, the group separator, and how negative numbers are displayed.
	numberFormat: {
		// [negativePattern]
		// Note, numberFormat.pattern has no "positivePattern" unlike percent and currency,
		// but is still defined as an array for consistency with them.
		//   negativePattern: one of "(n)|-n|- n|n-|n -"
		pattern: [ "-n" ],
		// number of decimal places normally shown
		decimals: 2,
		// string that separates number groups, as in 1,000,000
		",": ",",
		// string that separates a number from the fractional portion, as in 1.99
		".": ".",
		// array of numbers indicating the size of each number group.
		// TODO: more detailed description and example
		groupSizes: [ 3 ],
		// symbol used for positive numbers
		"+": "+",
		// symbol used for negative numbers
		"-": "-",
		// symbol used for NaN (Not-A-Number)
		"NaN": "NaN",
		// symbol used for Negative Infinity
		negativeInfinity: "-Infinity",
		// symbol used for Positive Infinity
		positiveInfinity: "Infinity",
		percent: {
			// [negativePattern, positivePattern]
			//   negativePattern: one of "-n %|-n%|-%n|%-n|%n-|n-%|n%-|-% n|n %-|% n-|% -n|n- %"
			//   positivePattern: one of "n %|n%|%n|% n"
			pattern: [ "-n %", "n %" ],
			// number of decimal places normally shown
			decimals: 2,
			// array of numbers indicating the size of each number group.
			// TODO: more detailed description and example
			groupSizes: [ 3 ],
			// string that separates number groups, as in 1,000,000
			",": ",",
			// string that separates a number from the fractional portion, as in 1.99
			".": ".",
			// symbol used to represent a percentage
			symbol: "%"
		},
		currency: {
			// [negativePattern, positivePattern]
			//   negativePattern: one of "($n)|-$n|$-n|$n-|(n$)|-n$|n-$|n$-|-n $|-$ n|n $-|$ n-|$ -n|n- $|($ n)|(n $)"
			//   positivePattern: one of "$n|n$|$ n|n $"
			pattern: [ "($n)", "$n" ],
			// number of decimal places normally shown
			decimals: 2,
			// array of numbers indicating the size of each number group.
			// TODO: more detailed description and example
			groupSizes: [ 3 ],
			// string that separates number groups, as in 1,000,000
			",": ",",
			// string that separates a number from the fractional portion, as in 1.99
			".": ".",
			// symbol used to represent currency
			symbol: "$"
		}
	},
	// calendars defines all the possible calendars used by this culture.
	// There should be at least one defined with name "standard", and is the default
	// calendar used by the culture.
	// A calendar contains information about how dates are formatted, information about
	// the calendar's eras, a standard set of the date formats,
	// translations for day and month names, and if the calendar is not based on the Gregorian
	// calendar, conversion functions to and from the Gregorian calendar.
	calendars: {
		standard: {
			// name that identifies the type of calendar this is
			name: "Gregorian_USEnglish",
			// separator of parts of a date (e.g. "/" in 11/05/1955)
			"/": "/",
			// separator of parts of a time (e.g. ":" in 05:44 PM)
			":": ":",
			// the first day of the week (0 = Sunday, 1 = Monday, etc)
			firstDay: 0,
			days: {
				// full day names
				names: [ "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday" ],
				// abbreviated day names
				namesAbbr: [ "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" ],
				// shortest day names
				namesShort: [ "Su", "Mo", "Tu", "We", "Th", "Fr", "Sa" ]
			},
			months: {
				// full month names (13 months for lunar calendards -- 13th month should be "" if not lunar)
				names: [ "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December", "" ],
				// abbreviated month names
				namesAbbr: [ "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", "" ]
			},
			// AM and PM designators in one of these forms:
			// The usual view, and the upper and lower case versions
			//   [ standard, lowercase, uppercase ]
			// The culture does not use AM or PM (likely all standard date formats use 24 hour time)
			//   null
			AM: [ "AM", "am", "AM" ],
			PM: [ "PM", "pm", "PM" ],
			eras: [
				// eras in reverse chronological order.
				// name: the name of the era in this culture (e.g. A.D., C.E.)
				// start: when the era starts in ticks (gregorian, gmt), null if it is the earliest supported era.
				// offset: offset in years from gregorian calendar
				{
					"name": "A.D.",
					"start": null,
					"offset": 0
				}
			],
			// when a two digit year is given, it will never be parsed as a four digit
			// year greater than this year (in the appropriate era for the culture)
			// Set it as a full year (e.g. 2029) or use an offset format starting from
			// the current year: "+19" would correspond to 2029 if the current year 2010.
			twoDigitYearMax: 2029,
			// set of predefined date and time patterns used by the culture
			// these represent the format someone in this culture would expect
			// to see given the portions of the date that are shown.
			patterns: {
				// short date pattern
				d: "M/d/yyyy",
				// long date pattern
				D: "dddd, MMMM dd, yyyy",
				// short time pattern
				t: "h:mm tt",
				// long time pattern
				T: "h:mm:ss tt",
				// long date, short time pattern
				f: "dddd, MMMM dd, yyyy h:mm tt",
				// long date, long time pattern
				F: "dddd, MMMM dd, yyyy h:mm:ss tt",
				// month/day pattern
				M: "MMMM dd",
				// month/year pattern
				Y: "yyyy MMMM",
				// S is a sortable format that does not vary by culture
				S: "yyyy\u0027-\u0027MM\u0027-\u0027dd\u0027T\u0027HH\u0027:\u0027mm\u0027:\u0027ss"
			}
			// optional fields for each calendar:
			/*
			monthsGenitive:
				Same as months but used when the day preceeds the month.
				Omit if the culture has no genitive distinction in month names.
				For an explaination of genitive months, see http://blogs.msdn.com/michkap/archive/2004/12/25/332259.aspx
			convert:
				Allows for the support of non-gregorian based calendars. This convert object is used to
				to convert a date to and from a gregorian calendar date to handle parsing and formatting.
				The two functions:
					fromGregorian( date )
						Given the date as a parameter, return an array with parts [ year, month, day ]
						corresponding to the non-gregorian based year, month, and day for the calendar.
					toGregorian( year, month, day )
						Given the non-gregorian year, month, and day, return a new Date() object
						set to the corresponding date in the gregorian calendar.
			*/
		}
	},
	// For localized strings
	messages: {}
};

Globalize.cultures[ "default" ].calendar = Globalize.cultures[ "default" ].calendars.standard;

Globalize.cultures.en = Globalize.cultures[ "default" ];

Globalize.cultureSelector = "en";

//
// private variables
//

regexHex = /^0x[a-f0-9]+$/i;
regexInfinity = /^[+\-]?infinity$/i;
regexParseFloat = /^[+\-]?\d*\.?\d*(e[+\-]?\d+)?$/;
regexTrim = /^\s+|\s+$/g;

//
// private JavaScript utility functions
//

arrayIndexOf = function( array, item ) {
	if ( array.indexOf ) {
		return array.indexOf( item );
	}
	for ( var i = 0, length = array.length; i < length; i++ ) {
		if ( array[i] === item ) {
			return i;
		}
	}
	return -1;
};

endsWith = function( value, pattern ) {
	return value.substr( value.length - pattern.length ) === pattern;
};

extend = function() {
	var options, name, src, copy, copyIsArray, clone,
		target = arguments[0] || {},
		i = 1,
		length = arguments.length,
		deep = false;

	// Handle a deep copy situation
	if ( typeof target === "boolean" ) {
		deep = target;
		target = arguments[1] || {};
		// skip the boolean and the target
		i = 2;
	}

	// Handle case when target is a string or something (possible in deep copy)
	if ( typeof target !== "object" && !isFunction(target) ) {
		target = {};
	}

	for ( ; i < length; i++ ) {
		// Only deal with non-null/undefined values
		if ( (options = arguments[ i ]) != null ) {
			// Extend the base object
			for ( name in options ) {
				src = target[ name ];
				copy = options[ name ];

				// Prevent never-ending loop
				if ( target === copy ) {
					continue;
				}

				// Recurse if we're merging plain objects or arrays
				if ( deep && copy && ( isObject(copy) || (copyIsArray = isArray(copy)) ) ) {
					if ( copyIsArray ) {
						copyIsArray = false;
						clone = src && isArray(src) ? src : [];

					} else {
						clone = src && isObject(src) ? src : {};
					}

					// Never move original objects, clone them
					target[ name ] = extend( deep, clone, copy );

				// Don't bring in undefined values
				} else if ( copy !== undefined ) {
					target[ name ] = copy;
				}
			}
		}
	}

	// Return the modified object
	return target;
};

isArray = Array.isArray || function( obj ) {
	return Object.prototype.toString.call( obj ) === "[object Array]";
};

isFunction = function( obj ) {
	return Object.prototype.toString.call( obj ) === "[object Function]";
};

isObject = function( obj ) {
	return Object.prototype.toString.call( obj ) === "[object Object]";
};

startsWith = function( value, pattern ) {
	return value.indexOf( pattern ) === 0;
};

trim = function( value ) {
	return ( value + "" ).replace( regexTrim, "" );
};

truncate = function( value ) {
	if ( isNaN( value ) ) {
		return NaN;
	}
	return Math[ value < 0 ? "ceil" : "floor" ]( value );
};

zeroPad = function( str, count, left ) {
	var l;
	for ( l = str.length; l < count; l += 1 ) {
		str = ( left ? ("0" + str) : (str + "0") );
	}
	return str;
};

//
// private Globalization utility functions
//

appendPreOrPostMatch = function( preMatch, strings ) {
	// appends pre- and post- token match strings while removing escaped characters.
	// Returns a single quote count which is used to determine if the token occurs
	// in a string literal.
	var quoteCount = 0,
		escaped = false;
	for ( var i = 0, il = preMatch.length; i < il; i++ ) {
		var c = preMatch.charAt( i );
		switch ( c ) {
			case "\'":
				if ( escaped ) {
					strings.push( "\'" );
				}
				else {
					quoteCount++;
				}
				escaped = false;
				break;
			case "\\":
				if ( escaped ) {
					strings.push( "\\" );
				}
				escaped = !escaped;
				break;
			default:
				strings.push( c );
				escaped = false;
				break;
		}
	}
	return quoteCount;
};

expandFormat = function( cal, format ) {
	// expands unspecified or single character date formats into the full pattern.
	format = format || "F";
	var pattern,
		patterns = cal.patterns,
		len = format.length;
	if ( len === 1 ) {
		pattern = patterns[ format ];
		if ( !pattern ) {
			throw "Invalid date format string \'" + format + "\'.";
		}
		format = pattern;
	}
	else if ( len === 2 && format.charAt(0) === "%" ) {
		// %X escape format -- intended as a custom format string that is only one character, not a built-in format.
		format = format.charAt( 1 );
	}
	return format;
};

formatDate = function( value, format, culture ) {
	var cal = culture.calendar,
		convert = cal.convert,
		ret;

	if ( !format || !format.length || format === "i" ) {
		if ( culture && culture.name.length ) {
			if ( convert ) {
				// non-gregorian calendar, so we cannot use built-in toLocaleString()
				ret = formatDate( value, cal.patterns.F, culture );
			}
			else {
				var eraDate = new Date( value.getTime() ),
					era = getEra( value, cal.eras );
				eraDate.setFullYear( getEraYear(value, cal, era) );
				ret = eraDate.toLocaleString();
			}
		}
		else {
			ret = value.toString();
		}
		return ret;
	}

	var eras = cal.eras,
		sortable = format === "s";
	format = expandFormat( cal, format );

	// Start with an empty string
	ret = [];
	var hour,
		zeros = [ "0", "00", "000" ],
		foundDay,
		checkedDay,
		dayPartRegExp = /([^d]|^)(d|dd)([^d]|$)/g,
		quoteCount = 0,
		tokenRegExp = getTokenRegExp(),
		converted;

	//function padZeros( num, c ) {
	//	var r, s = num + "";
	//	if ( c > 1 && s.length < c ) {
	//		r = ( zeros[c - 2] + s);
	//		return r.substr( r.length - c, c );
	//	}
	//	else {
	//		r = s;
	//	}
	//	return r;
	//}

	function padZeros(num, c) {
	    if (num < 0) {
	        return "-" + padZeros(-num, c);
	    }
	    var r, s = num + "";
	    if (c > 1 && s.length < c) {
	        r = (zeros[c - 2] + s);
	        return r.substr(r.length - c, c);
	    }
	    else {
	        r = s;
	    }
	    return r;
	}

	function hasDay() {
		if ( foundDay || checkedDay ) {
			return foundDay;
		}
		foundDay = dayPartRegExp.test( format );
		checkedDay = true;
		return foundDay;
	}

	function getPart( date, part ) {
		if ( converted ) {
			return converted[ part ];
		}
		switch ( part ) {
			case 0:
				return date.getFullYear();
			case 1:
				return date.getMonth();
			case 2:
				return date.getDate();
			default:
				throw "Invalid part value " + part;
		}
	}

	if ( !sortable && convert ) {
		converted = convert.fromGregorian( value );
	}

	for ( ; ; ) {
		// Save the current index
		var index = tokenRegExp.lastIndex,
			// Look for the next pattern
			ar = tokenRegExp.exec( format );

		// Append the text before the pattern (or the end of the string if not found)
		var preMatch = format.slice( index, ar ? ar.index : format.length );
		quoteCount += appendPreOrPostMatch( preMatch, ret );

		if ( !ar ) {
			break;
		}

		// do not replace any matches that occur inside a string literal.
		if ( quoteCount % 2 ) {
			ret.push( ar[0] );
			continue;
		}

		var current = ar[ 0 ],
			clength = current.length;

		switch ( current ) {
			case "ddd":
				//Day of the week, as a three-letter abbreviation
			case "dddd":
				// Day of the week, using the full name
				var names = ( clength === 3 ) ? cal.days.namesAbbr : cal.days.names;
				ret.push( names[value.getDay()] );
				break;
			case "d":
				// Day of month, without leading zero for single-digit days
			case "dd":
				// Day of month, with leading zero for single-digit days
				foundDay = true;
				ret.push(
					padZeros( getPart(value, 2), clength )
				);
				break;
			case "MMM":
				// Month, as a three-letter abbreviation
			case "MMMM":
				// Month, using the full name
				var part = getPart( value, 1 );
				ret.push(
					( cal.monthsGenitive && hasDay() ) ?
					( cal.monthsGenitive[ clength === 3 ? "namesAbbr" : "names" ][ part ] ) :
					( cal.months[ clength === 3 ? "namesAbbr" : "names" ][ part ] )
				);
				break;
			case "M":
				// Month, as digits, with no leading zero for single-digit months
			case "MM":
				// Month, as digits, with leading zero for single-digit months
				ret.push(
					padZeros( getPart(value, 1) + 1, clength )
				);
				break;
			case "y":
				// Year, as two digits, but with no leading zero for years less than 10
			case "yy":
				// Year, as two digits, with leading zero for years less than 10
			case "yyyy":
				// Year represented by four full digits
				part = converted ? converted[ 0 ] : getEraYear( value, cal, getEra(value, eras), sortable );
				if ( clength < 4 ) {
					part = part % 100;
				}
				ret.push(
					padZeros( part, clength )
				);
				break;
			case "h":
				// Hours with no leading zero for single-digit hours, using 12-hour clock
			case "hh":
				// Hours with leading zero for single-digit hours, using 12-hour clock
				hour = value.getHours() % 12;
				if ( hour === 0 ) hour = 12;
				ret.push(
					padZeros( hour, clength )
				);
				break;
			case "H":
				// Hours with no leading zero for single-digit hours, using 24-hour clock
			case "HH":
				// Hours with leading zero for single-digit hours, using 24-hour clock
				ret.push(
					padZeros( value.getHours(), clength )
				);
				break;
			case "m":
				// Minutes with no leading zero for single-digit minutes
			case "mm":
				// Minutes with leading zero for single-digit minutes
				ret.push(
					padZeros( value.getMinutes(), clength )
				);
				break;
			case "s":
				// Seconds with no leading zero for single-digit seconds
			case "ss":
				// Seconds with leading zero for single-digit seconds
				ret.push(
					padZeros( value.getSeconds(), clength )
				);
				break;
			case "t":
				// One character am/pm indicator ("a" or "p")
			case "tt":
				// Multicharacter am/pm indicator
				part = value.getHours() < 12 ? ( cal.AM ? cal.AM[0] : " " ) : ( cal.PM ? cal.PM[0] : " " );
				ret.push( clength === 1 ? part.charAt(0) : part );
				break;
			case "f":
				// Deciseconds
			case "ff":
				// Centiseconds
			case "fff":
				// Milliseconds
				ret.push(
					padZeros( value.getMilliseconds(), 3 ).substr( 0, clength )
				);
				break;
			case "z":
				// Time zone offset, no leading zero
			case "zz":
				// Time zone offset with leading zero
				hour = value.getTimezoneOffset() / 60;
				ret.push(
					( hour <= 0 ? "+" : "-" ) + padZeros( Math.floor(Math.abs(hour)), clength )
				);
				break;
			case "zzz":
				// Time zone offset with leading zero
				hour = value.getTimezoneOffset() / 60;
				ret.push(
					( hour <= 0 ? "+" : "-" ) + padZeros( Math.floor(Math.abs(hour)), 2 ) +
					// Hard coded ":" separator, rather than using cal.TimeSeparator
					// Repeated here for consistency, plus ":" was already assumed in date parsing.
					":" + padZeros( Math.abs(value.getTimezoneOffset() % 60), 2 )
				);
				break;
			case "g":
			case "gg":
				if ( cal.eras ) {
					ret.push(
						cal.eras[ getEra(value, eras) ].name
					);
				}
				break;
		case "/":
			ret.push( cal["/"] );
			break;
		default:
			throw "Invalid date format pattern \'" + current + "\'.";
		}
	}
	return ret.join( "" );
};

// formatNumber
(function() {
	var expandNumber;

	expandNumber = function( number, precision, formatInfo ) {
		var groupSizes = formatInfo.groupSizes,
			curSize = groupSizes[ 0 ],
			curGroupIndex = 1,
			factor = Math.pow( 10, precision ),
			rounded = Math.round( number * factor ) / factor;

		if ( !isFinite(rounded) ) {
			rounded = number;
		}
		number = rounded;

		var numberString = number+"",
			right = "",
			split = numberString.split( /e/i ),
			exponent = split.length > 1 ? parseInt( split[1], 10 ) : 0;
		numberString = split[ 0 ];
		split = numberString.split( "." );
		numberString = split[ 0 ];
		right = split.length > 1 ? split[ 1 ] : "";

		var l;
		if ( exponent > 0 ) {
			right = zeroPad( right, exponent, false );
			numberString += right.slice( 0, exponent );
			right = right.substr( exponent );
		}
		else if ( exponent < 0 ) {
			exponent = -exponent;
			numberString = zeroPad( numberString, exponent + 1, true );
			right = numberString.slice( -exponent, numberString.length ) + right;
			numberString = numberString.slice( 0, -exponent );
		}

		if ( precision > 0 ) {
			right = formatInfo[ "." ] +
				( (right.length > precision) ? right.slice(0, precision) : zeroPad(right, precision) );
		}
		else {
			right = "";
		}

		var stringIndex = numberString.length - 1,
			sep = formatInfo[ "," ],
			ret = "";

		while ( stringIndex >= 0 ) {
			if ( curSize === 0 || curSize > stringIndex ) {
				return numberString.slice( 0, stringIndex + 1 ) + ( ret.length ? (sep + ret + right) : right );
			}
			ret = numberString.slice( stringIndex - curSize + 1, stringIndex + 1 ) + ( ret.length ? (sep + ret) : "" );

			stringIndex -= curSize;

			if ( curGroupIndex < groupSizes.length ) {
				curSize = groupSizes[ curGroupIndex ];
				curGroupIndex++;
			}
		}

		return numberString.slice( 0, stringIndex + 1 ) + sep + ret + right;
	};

	formatNumber = function( value, format, culture ) {
		if ( !isFinite(value) ) {
			if ( value === Infinity ) {
				return culture.numberFormat.positiveInfinity;
			}
			if ( value === -Infinity ) {
				return culture.numberFormat.negativeInfinity;
			}
			return culture.numberFormat.NaN;
		}
		if ( !format || format === "i" ) {
			return culture.name.length ? value.toLocaleString() : value.toString();
		}
		format = format || "D";

		var nf = culture.numberFormat,
			number = Math.abs( value ),
			precision = -1,
			pattern;
		if ( format.length > 1 ) precision = parseInt( format.slice(1), 10 );

		var current = format.charAt( 0 ).toUpperCase(),
			formatInfo;

		switch ( current ) {
			case "D":
				pattern = "n";
				number = truncate( number );
				if ( precision !== -1 ) {
					number = zeroPad( "" + number, precision, true );
				}
				if ( value < 0 ) number = "-" + number;
				break;
			case "N":
				formatInfo = nf;
				/* falls through */
			case "C":
				formatInfo = formatInfo || nf.currency;
				/* falls through */
			case "P":
				formatInfo = formatInfo || nf.percent;
				pattern = value < 0 ? formatInfo.pattern[ 0 ] : ( formatInfo.pattern[1] || "n" );
				if ( precision === -1 ) precision = formatInfo.decimals;
				number = expandNumber( number * (current === "P" ? 100 : 1), precision, formatInfo );
				break;
			default:
				throw "Bad number format specifier: " + current;
		}

		var patternParts = /n|\$|-|%/g,
			ret = "";
		for ( ; ; ) {
			var index = patternParts.lastIndex,
				ar = patternParts.exec( pattern );

			ret += pattern.slice( index, ar ? ar.index : pattern.length );

			if ( !ar ) {
				break;
			}

			switch ( ar[0] ) {
				case "n":
					ret += number;
					break;
				case "$":
					ret += nf.currency.symbol;
					break;
				case "-":
					// don't make 0 negative
					if ( /[1-9]/.test(number) ) {
						ret += nf[ "-" ];
					}
					break;
				case "%":
					ret += nf.percent.symbol;
					break;
			}
		}

		return ret;
	};

}());

getTokenRegExp = function() {
	// regular expression for matching date and time tokens in format strings.
	return (/\/|dddd|ddd|dd|d|MMMM|MMM|MM|M|yyyy|yy|y|hh|h|HH|H|mm|m|ss|s|tt|t|fff|ff|f|zzz|zz|z|gg|g/g);
};

getEra = function( date, eras ) {
	if ( !eras ) return 0;
	var start, ticks = date.getTime();
	for ( var i = 0, l = eras.length; i < l; i++ ) {
		start = eras[ i ].start;
		if ( start === null || ticks >= start ) {
			return i;
		}
	}
	return 0;
};

getEraYear = function( date, cal, era, sortable ) {
	var year = date.getFullYear();
	if ( !sortable && cal.eras ) {
		// convert normal gregorian year to era-shifted gregorian
		// year by subtracting the era offset
		year -= cal.eras[ era ].offset;
	}
	return year;
};

// parseExact
(function() {
	var expandYear,
		getDayIndex,
		getMonthIndex,
		getParseRegExp,
		outOfRange,
		toUpper,
		toUpperArray;

	expandYear = function( cal, year ) {
		// expands 2-digit year into 4 digits.
		if ( year < 100 ) {
			var now = new Date(),
				era = getEra( now ),
				curr = getEraYear( now, cal, era ),
				twoDigitYearMax = cal.twoDigitYearMax;
			twoDigitYearMax = typeof twoDigitYearMax === "string" ? new Date().getFullYear() % 100 + parseInt( twoDigitYearMax, 10 ) : twoDigitYearMax;
			year += curr - ( curr % 100 );
			if ( year > twoDigitYearMax ) {
				year -= 100;
			}
		}
		return year;
	};

	getDayIndex = function	( cal, value, abbr ) {
		var ret,
			days = cal.days,
			upperDays = cal._upperDays;
		if ( !upperDays ) {
			cal._upperDays = upperDays = [
				toUpperArray( days.names ),
				toUpperArray( days.namesAbbr ),
				toUpperArray( days.namesShort )
			];
		}
		value = toUpper( value );
		if ( abbr ) {
			ret = arrayIndexOf( upperDays[1], value );
			if ( ret === -1 ) {
				ret = arrayIndexOf( upperDays[2], value );
			}
		}
		else {
			ret = arrayIndexOf( upperDays[0], value );
		}
		return ret;
	};

	getMonthIndex = function( cal, value, abbr ) {
		var months = cal.months,
			monthsGen = cal.monthsGenitive || cal.months,
			upperMonths = cal._upperMonths,
			upperMonthsGen = cal._upperMonthsGen;
		if ( !upperMonths ) {
			cal._upperMonths = upperMonths = [
				toUpperArray( months.names ),
				toUpperArray( months.namesAbbr )
			];
			cal._upperMonthsGen = upperMonthsGen = [
				toUpperArray( monthsGen.names ),
				toUpperArray( monthsGen.namesAbbr )
			];
		}
		value = toUpper( value );
		var i = arrayIndexOf( abbr ? upperMonths[1] : upperMonths[0], value );
		if ( i < 0 ) {
			i = arrayIndexOf( abbr ? upperMonthsGen[1] : upperMonthsGen[0], value );
		}
		return i;
	};

	getParseRegExp = function( cal, format ) {
		// converts a format string into a regular expression with groups that
		// can be used to extract date fields from a date string.
		// check for a cached parse regex.
		var re = cal._parseRegExp;
		if ( !re ) {
			cal._parseRegExp = re = {};
		}
		else {
			var reFormat = re[ format ];
			if ( reFormat ) {
				return reFormat;
			}
		}

		// expand single digit formats, then escape regular expression characters.
		var expFormat = expandFormat( cal, format ).replace( /([\^\$\.\*\+\?\|\[\]\(\)\{\}])/g, "\\\\$1" ),
			regexp = [ "^" ],
			groups = [],
			index = 0,
			quoteCount = 0,
			tokenRegExp = getTokenRegExp(),
			match;

		// iterate through each date token found.
		while ( (match = tokenRegExp.exec(expFormat)) !== null ) {
			var preMatch = expFormat.slice( index, match.index );
			index = tokenRegExp.lastIndex;

			// don't replace any matches that occur inside a string literal.
			quoteCount += appendPreOrPostMatch( preMatch, regexp );
			if ( quoteCount % 2 ) {
				regexp.push( match[0] );
				continue;
			}

			// add a regex group for the token.
			var m = match[ 0 ],
				len = m.length,
				add;
			switch ( m ) {
				case "dddd": case "ddd":
				case "MMMM": case "MMM":
				case "gg": case "g":
					add = "(\\D+)";
					break;
				case "tt": case "t":
					add = "(\\D*)";
					break;
				case "yyyy":
				case "fff":
				case "ff":
				case "f":
					add = "(\\d{" + len + "})";
					break;
				case "dd": case "d":
				case "MM": case "M":
				case "yy": case "y":
				case "HH": case "H":
				case "hh": case "h":
				case "mm": case "m":
				case "ss": case "s":
					add = "(\\d\\d?)";
					break;
				case "zzz":
					add = "([+-]?\\d\\d?:\\d{2})";
					break;
				case "zz": case "z":
					add = "([+-]?\\d\\d?)";
					break;
				case "/":
					add = "(\\/)";
					break;
				default:
					throw "Invalid date format pattern \'" + m + "\'.";
			}
			if ( add ) {
				regexp.push( add );
			}
			groups.push( match[0] );
		}
		appendPreOrPostMatch( expFormat.slice(index), regexp );
		regexp.push( "$" );

		// allow whitespace to differ when matching formats.
		var regexpStr = regexp.join( "" ).replace( /\s+/g, "\\s+" ),
			parseRegExp = { "regExp": regexpStr, "groups": groups };

		// cache the regex for this format.
		return re[ format ] = parseRegExp;
	};

	outOfRange = function( value, low, high ) {
		return value < low || value > high;
	};

	toUpper = function( value ) {
		// "he-IL" has non-breaking space in weekday names.
		return value.split( "\u00A0" ).join( " " ).toUpperCase();
	};

	toUpperArray = function( arr ) {
		var results = [];
		for ( var i = 0, l = arr.length; i < l; i++ ) {
			results[ i ] = toUpper( arr[i] );
		}
		return results;
	};

	parseExact = function( value, format, culture ) {
		// try to parse the date string by matching against the format string
		// while using the specified culture for date field names.
		value = trim( value );
		var cal = culture.calendar,
			// convert date formats into regular expressions with groupings.
			// use the regexp to determine the input format and extract the date fields.
			parseInfo = getParseRegExp( cal, format ),
			match = new RegExp( parseInfo.regExp ).exec( value );
		if ( match === null ) {
			return null;
		}
		// found a date format that matches the input.
		var groups = parseInfo.groups,
			era = null, year = null, month = null, date = null, weekDay = null,
			hour = 0, hourOffset, min = 0, sec = 0, msec = 0, tzMinOffset = null,
			pmHour = false;
		// iterate the format groups to extract and set the date fields.
		for ( var j = 0, jl = groups.length; j < jl; j++ ) {
			var matchGroup = match[ j + 1 ];
			if ( matchGroup ) {
				var current = groups[ j ],
					clength = current.length,
					matchInt = parseInt( matchGroup, 10 );
				switch ( current ) {
					case "dd": case "d":
						// Day of month.
						date = matchInt;
						// check that date is generally in valid range, also checking overflow below.
						if ( outOfRange(date, 1, 31) ) return null;
						break;
					case "MMM": case "MMMM":
						month = getMonthIndex( cal, matchGroup, clength === 3 );
						if ( outOfRange(month, 0, 11) ) return null;
						break;
					case "M": case "MM":
						// Month.
						month = matchInt - 1;
						if ( outOfRange(month, 0, 11) ) return null;
						break;
					case "y": case "yy":
					case "yyyy":
						year = clength < 4 ? expandYear( cal, matchInt ) : matchInt;
						if ( outOfRange(year, 0, 9999) ) return null;
						break;
					case "h": case "hh":
						// Hours (12-hour clock).
						hour = matchInt;
						if ( hour === 12 ) hour = 0;
						if ( outOfRange(hour, 0, 11) ) return null;
						break;
					case "H": case "HH":
						// Hours (24-hour clock).
						hour = matchInt;
						if ( outOfRange(hour, 0, 23) ) return null;
						break;
					case "m": case "mm":
						// Minutes.
						min = matchInt;
						if ( outOfRange(min, 0, 59) ) return null;
						break;
					case "s": case "ss":
						// Seconds.
						sec = matchInt;
						if ( outOfRange(sec, 0, 59) ) return null;
						break;
					case "tt": case "t":
						// AM/PM designator.
						// see if it is standard, upper, or lower case PM. If not, ensure it is at least one of
						// the AM tokens. If not, fail the parse for this format.
						pmHour = cal.PM && ( matchGroup === cal.PM[0] || matchGroup === cal.PM[1] || matchGroup === cal.PM[2] );
						if (
							!pmHour && (
								!cal.AM || ( matchGroup !== cal.AM[0] && matchGroup !== cal.AM[1] && matchGroup !== cal.AM[2] )
							)
						) return null;
						break;
					case "f":
						// Deciseconds.
					case "ff":
						// Centiseconds.
					case "fff":
						// Milliseconds.
						msec = matchInt * Math.pow( 10, 3 - clength );
						if ( outOfRange(msec, 0, 999) ) return null;
						break;
					case "ddd":
						// Day of week.
					case "dddd":
						// Day of week.
						weekDay = getDayIndex( cal, matchGroup, clength === 3 );
						if ( outOfRange(weekDay, 0, 6) ) return null;
						break;
					case "zzz":
						// Time zone offset in +/- hours:min.
						var offsets = matchGroup.split( /:/ );
						if ( offsets.length !== 2 ) return null;
						hourOffset = parseInt( offsets[0], 10 );
						if ( outOfRange(hourOffset, -12, 13) ) return null;
						var minOffset = parseInt( offsets[1], 10 );
						if ( outOfRange(minOffset, 0, 59) ) return null;
						tzMinOffset = ( hourOffset * 60 ) + ( startsWith(matchGroup, "-") ? -minOffset : minOffset );
						break;
					case "z": case "zz":
						// Time zone offset in +/- hours.
						hourOffset = matchInt;
						if ( outOfRange(hourOffset, -12, 13) ) return null;
						tzMinOffset = hourOffset * 60;
						break;
					case "g": case "gg":
						var eraName = matchGroup;
						if ( !eraName || !cal.eras ) return null;
						eraName = trim( eraName.toLowerCase() );
						for ( var i = 0, l = cal.eras.length; i < l; i++ ) {
							if ( eraName === cal.eras[i].name.toLowerCase() ) {
								era = i;
								break;
							}
						}
						// could not find an era with that name
						if ( era === null ) return null;
						break;
				}
			}
		}
		var result = new Date(), defaultYear, convert = cal.convert;
		defaultYear = convert ? convert.fromGregorian( result )[ 0 ] : result.getFullYear();
		if ( year === null ) {
			year = defaultYear;
		}
		else if ( cal.eras ) {
			// year must be shifted to normal gregorian year
			// but not if year was not specified, its already normal gregorian
			// per the main if clause above.
			year += cal.eras[( era || 0 )].offset;
		}
		// set default day and month to 1 and January, so if unspecified, these are the defaults
		// instead of the current day/month.
		if ( month === null ) {
			month = 0;
		}
		if ( date === null ) {
			date = 1;
		}
		// now have year, month, and date, but in the culture's calendar.
		// convert to gregorian if necessary
		if ( convert ) {
			result = convert.toGregorian( year, month, date );
			// conversion failed, must be an invalid match
			if ( result === null ) return null;
		}
		else {
			// have to set year, month and date together to avoid overflow based on current date.
			result.setFullYear( year, month, date );
			// check to see if date overflowed for specified month (only checked 1-31 above).
			if ( result.getDate() !== date ) return null;
			// invalid day of week.
			if ( weekDay !== null && result.getDay() !== weekDay ) {
				return null;
			}
		}
		// if pm designator token was found make sure the hours fit the 24-hour clock.
		if ( pmHour && hour < 12 ) {
			hour += 12;
		}
		result.setHours( hour, min, sec, msec );
		if ( tzMinOffset !== null ) {
			// adjust timezone to utc before applying local offset.
			var adjustedMin = result.getMinutes() - ( tzMinOffset + result.getTimezoneOffset() );
			// Safari limits hours and minutes to the range of -127 to 127.  We need to use setHours
			// to ensure both these fields will not exceed this range.	adjustedMin will range
			// somewhere between -1440 and 1500, so we only need to split this into hours.
			result.setHours( result.getHours() + parseInt(adjustedMin / 60, 10), adjustedMin % 60 );
		}
		return result;
	};
}());

parseNegativePattern = function( value, nf, negativePattern ) {
	var neg = nf[ "-" ],
		pos = nf[ "+" ],
		ret;
	switch ( negativePattern ) {
		case "n -":
			neg = " " + neg;
			pos = " " + pos;
			/* falls through */
		case "n-":
			if ( endsWith(value, neg) ) {
				ret = [ "-", value.substr(0, value.length - neg.length) ];
			}
			else if ( endsWith(value, pos) ) {
				ret = [ "+", value.substr(0, value.length - pos.length) ];
			}
			break;
		case "- n":
			neg += " ";
			pos += " ";
			/* falls through */
		case "-n":
			if ( startsWith(value, neg) ) {
				ret = [ "-", value.substr(neg.length) ];
			}
			else if ( startsWith(value, pos) ) {
				ret = [ "+", value.substr(pos.length) ];
			}
			break;
		case "(n)":
			if ( startsWith(value, "(") && endsWith(value, ")") ) {
				ret = [ "-", value.substr(1, value.length - 2) ];
			}
			break;
	}
	return ret || [ "", value ];
};

//
// public instance functions
//

Globalize.prototype.findClosestCulture = function( cultureSelector ) {
	return Globalize.findClosestCulture.call( this, cultureSelector );
};

Globalize.prototype.format = function( value, format, cultureSelector ) {
	return Globalize.format.call( this, value, format, cultureSelector );
};

Globalize.prototype.localize = function( key, cultureSelector ) {
	return Globalize.localize.call( this, key, cultureSelector );
};

Globalize.prototype.parseInt = function( value, radix, cultureSelector ) {
	return Globalize.parseInt.call( this, value, radix, cultureSelector );
};

Globalize.prototype.parseFloat = function( value, radix, cultureSelector ) {
	return Globalize.parseFloat.call( this, value, radix, cultureSelector );
};

Globalize.prototype.culture = function( cultureSelector ) {
	return Globalize.culture.call( this, cultureSelector );
};

//
// public singleton functions
//

Globalize.addCultureInfo = function( cultureName, baseCultureName, info ) {

	var base = {},
		isNew = false;

	if ( typeof cultureName !== "string" ) {
		// cultureName argument is optional string. If not specified, assume info is first
		// and only argument. Specified info deep-extends current culture.
		info = cultureName;
		cultureName = this.culture().name;
		base = this.cultures[ cultureName ];
	} else if ( typeof baseCultureName !== "string" ) {
		// baseCultureName argument is optional string. If not specified, assume info is second
		// argument. Specified info deep-extends specified culture.
		// If specified culture does not exist, create by deep-extending default
		info = baseCultureName;
		isNew = ( this.cultures[ cultureName ] == null );
		base = this.cultures[ cultureName ] || this.cultures[ "default" ];
	} else {
		// cultureName and baseCultureName specified. Assume a new culture is being created
		// by deep-extending an specified base culture
		isNew = true;
		base = this.cultures[ baseCultureName ];
	}

	this.cultures[ cultureName ] = extend(true, {},
		base,
		info
	);
	// Make the standard calendar the current culture if it's a new culture
	if ( isNew ) {
		this.cultures[ cultureName ].calendar = this.cultures[ cultureName ].calendars.standard;
	}
};

Globalize.findClosestCulture = function( name ) {
	var match;
	if ( !name ) {
		return this.findClosestCulture( this.cultureSelector ) || this.cultures[ "default" ];
	}
	if ( typeof name === "string" ) {
		name = name.split( "," );
	}
	if ( isArray(name) ) {
		var lang,
			cultures = this.cultures,
			list = name,
			i, l = list.length,
			prioritized = [];
		for ( i = 0; i < l; i++ ) {
			name = trim( list[i] );
			var pri, parts = name.split( ";" );
			lang = trim( parts[0] );
			if ( parts.length === 1 ) {
				pri = 1;
			}
			else {
				name = trim( parts[1] );
				if ( name.indexOf("q=") === 0 ) {
					name = name.substr( 2 );
					pri = parseFloat( name );
					pri = isNaN( pri ) ? 0 : pri;
				}
				else {
					pri = 1;
				}
			}
			prioritized.push({ lang: lang, pri: pri });
		}
		prioritized.sort(function( a, b ) {
			if ( a.pri < b.pri ) {
				return 1;
			} else if ( a.pri > b.pri ) {
				return -1;
			}
			return 0;
		});
		// exact match
		for ( i = 0; i < l; i++ ) {
			lang = prioritized[ i ].lang;
			match = cultures[ lang ];
			if ( match ) {
				return match;
			}
		}

		// neutral language match
		for ( i = 0; i < l; i++ ) {
			lang = prioritized[ i ].lang;
			do {
				var index = lang.lastIndexOf( "-" );
				if ( index === -1 ) {
					break;
				}
				// strip off the last part. e.g. en-US => en
				lang = lang.substr( 0, index );
				match = cultures[ lang ];
				if ( match ) {
					return match;
				}
			}
			while ( 1 );
		}

		// last resort: match first culture using that language
		for ( i = 0; i < l; i++ ) {
			lang = prioritized[ i ].lang;
			for ( var cultureKey in cultures ) {
				var culture = cultures[ cultureKey ];
				if ( culture.language == lang ) {
					return culture;
				}
			}
		}
	}
	else if ( typeof name === "object" ) {
		return name;
	}
	return match || null;
};

Globalize.format = function( value, format, cultureSelector ) {
	var culture = this.findClosestCulture( cultureSelector );
	if ( value instanceof Date ) {
		value = formatDate( value, format, culture );
	}
	else if ( typeof value === "number" ) {
		value = formatNumber( value, format, culture );
	}
	return value;
};

Globalize.localize = function( key, cultureSelector ) {
	return this.findClosestCulture( cultureSelector ).messages[ key ] ||
		this.cultures[ "default" ].messages[ key ];
};

Globalize.parseDate = function( value, formats, culture ) {
	culture = this.findClosestCulture( culture );

	var date, prop, patterns;
	if ( formats ) {
		if ( typeof formats === "string" ) {
			formats = [ formats ];
		}
		if ( formats.length ) {
			for ( var i = 0, l = formats.length; i < l; i++ ) {
				var format = formats[ i ];
				if ( format ) {
					date = parseExact( value, format, culture );
					if ( date ) {
						break;
					}
				}
			}
		}
	} else {
		patterns = culture.calendar.patterns;
		for ( prop in patterns ) {
			date = parseExact( value, patterns[prop], culture );
			if ( date ) {
				break;
			}
		}
	}

	return date || null;
};

Globalize.parseInt = function( value, radix, cultureSelector ) {
	return truncate( Globalize.parseFloat(value, radix, cultureSelector) );
};

Globalize.parseFloat = function( value, radix, cultureSelector ) {
	// radix argument is optional
	if ( typeof radix !== "number" ) {
		cultureSelector = radix;
		radix = 10;
	}

	var culture = this.findClosestCulture( cultureSelector );
	var ret = NaN,
		nf = culture.numberFormat;

	if ( value.indexOf(culture.numberFormat.currency.symbol) > -1 ) {
		// remove currency symbol
		value = value.replace( culture.numberFormat.currency.symbol, "" );
		// replace decimal seperator
		value = value.replace( culture.numberFormat.currency["."], culture.numberFormat["."] );
	}

	//Remove percentage character from number string before parsing
	if ( value.indexOf(culture.numberFormat.percent.symbol) > -1){
		value = value.replace( culture.numberFormat.percent.symbol, "" );
	}

	// remove spaces: leading, trailing and between - and number. Used for negative currency pt-BR
	value = value.replace( / /g, "" );

	// allow infinity or hexidecimal
	if ( regexInfinity.test(value) ) {
		ret = parseFloat( value );
	}
	else if ( !radix && regexHex.test(value) ) {
		ret = parseInt( value, 16 );
	}
	else {

		// determine sign and number
		var signInfo = parseNegativePattern( value, nf, nf.pattern[0] ),
			sign = signInfo[ 0 ],
			num = signInfo[ 1 ];

		// #44 - try parsing as "(n)"
		if ( sign === "" && nf.pattern[0] !== "(n)" ) {
			signInfo = parseNegativePattern( value, nf, "(n)" );
			sign = signInfo[ 0 ];
			num = signInfo[ 1 ];
		}

		// try parsing as "-n"
		if ( sign === "" && nf.pattern[0] !== "-n" ) {
			signInfo = parseNegativePattern( value, nf, "-n" );
			sign = signInfo[ 0 ];
			num = signInfo[ 1 ];
		}

		sign = sign || "+";

		// determine exponent and number
		var exponent,
			intAndFraction,
			exponentPos = num.indexOf( "e" );
		if ( exponentPos < 0 ) exponentPos = num.indexOf( "E" );
		if ( exponentPos < 0 ) {
			intAndFraction = num;
			exponent = null;
		}
		else {
			intAndFraction = num.substr( 0, exponentPos );
			exponent = num.substr( exponentPos + 1 );
		}
		// determine decimal position
		var integer,
			fraction,
			decSep = nf[ "." ],
			decimalPos = intAndFraction.indexOf( decSep );
		if ( decimalPos < 0 ) {
			integer = intAndFraction;
			fraction = null;
		}
		else {
			integer = intAndFraction.substr( 0, decimalPos );
			fraction = intAndFraction.substr( decimalPos + decSep.length );
		}
		// handle groups (e.g. 1,000,000)
		var groupSep = nf[ "," ];
		integer = integer.split( groupSep ).join( "" );
		var altGroupSep = groupSep.replace( /\u00A0/g, " " );
		if ( groupSep !== altGroupSep ) {
			integer = integer.split( altGroupSep ).join( "" );
		}
		// build a natively parsable number string
		var p = sign + integer;
		if ( fraction !== null ) {
			p += "." + fraction;
		}
		if ( exponent !== null ) {
			// exponent itself may have a number patternd
			var expSignInfo = parseNegativePattern( exponent, nf, "-n" );
			p += "e" + ( expSignInfo[0] || "+" ) + expSignInfo[ 1 ];
		}
		if ( regexParseFloat.test(p) ) {
			ret = parseFloat( p );
		}
	}
	return ret;
};

Globalize.culture = function( cultureSelector ) {
	// setter
	if ( typeof cultureSelector !== "undefined" ) {
		this.cultureSelector = cultureSelector;
	}
	// getter
	return this.findClosestCulture( cultureSelector ) || this.cultures[ "default" ];
};

document.Globalize = Globalize;
}(this));
})();

/***/ }),

/***/ 7196:
/***/ (() => {

/* tslint:disable */
/* eslint-disable */
(function(){
	if (typeof document === 'undefined') { 
		return;
	}

(function ($) {

    $.jqx.jqxWidget("jqxButtonGroup", "", {});

    $.extend($.jqx._jqxButtonGroup.prototype, {
        defineInstance: function () {
            var settings =
            {
                //Possible values: checkbox, radio, default
                mode: 'default',
                roundedCorners: true,
                disabled: false,
                enableHover: false,
                orientation: 'horizontal',
                width: null,
                height: null,
                _eventsMap: {
                    'mousedown': $.jqx.mobile.getTouchEventName('touchstart'),
                    'mouseup': $.jqx.mobile.getTouchEventName('touchend')
                },
                _events: ['selected', 'unselected', 'buttonclick'],
                _buttonId: {},
                _selected: null,
                _pressed: null,
                rtl: false,
                template: "",
                _baseId: 'group_button',
                aria:
                {
                    "aria-disabled": { name: "disabled", type: "boolean" }
                }
            };
            if (this === $.jqx._jqxButtonGroup.prototype) {
                return settings;
            }
            $.extend(true, this, settings);
            return settings;
        },

        createInstance: function (args) {
            var that = this;
            that._isTouchDevice = $.jqx.mobile.isTouchDevice();
            $.jqx.aria(that);
            that._baseId = that._baseId + that.element.id;
            that.addHandler(that.host, 'selectstart', function (event) {
                if (!that.disabled) {
                    event.preventDefault();
                }
            });
        },

        refresh: function () {
            var that = this;
            if (that.width) {
                if (that.width.toString() && that.width.toString().indexOf('%') >= 0) {
                    that.element.style.width = that.width;
                }
                else {
                    that.host.width(that.width);
                }
            }
            if (that.height) that.host.height(that.height);
            that._refreshButtons();
        },

        render: function () {
            this.refresh();
        },

        resize: function () {
            this.refresh();
        },

        _getEvent: function (event) {
            var that = this;
            if (that._isTouchDevice) {
                var e = that._eventsMap[event] || event;
                e += "." + that.element.id;
                return e;
            }
            event += "." + that.element.id;
            return event;
        },

        _refreshButtons: function () {
            var that = this;
            if (that.lastElement)
                that.lastElement.remove();

            that.lastElement = $("<div style='clear: both;'></div>");
            var children = that.host.children(),
                count = children.length,
                current;

            switch (that.mode) {
                case "radio":
                    that.host.attr('role', 'radiogroup');
                    break;
                case "checkbox":
                case "default":
                    that.host.attr('role', 'group');
                    break;
            }

            var width = new Number(100 / count).toFixed(2);
            for (var i = 0; i < count; i += 1) {
                current = $(children[i]);
                if (that.width) {
                    if (that.orientation === "horizontal") {
                        current.css('width', width + '%');
                        current.css('box-sizing', 'border-box');
                        current.css('-moz-box-sizing', 'border-box');
                        current.css('white-space', 'nowrap');
                        current.css('text-overflow', 'ellipsis');
                        current.css('overflow', 'hidden');
                    }
                    else {
                        current.css('box-sizing', 'border-box');
                        current.css('-moz-box-sizing', 'border-box');
                        current.css('width', '100%');
                    }
                }

                that._refreshButton(current, i, count);
            }
            that.lastElement.appendTo(that.host);
        },

        _refreshButton: function (btn, counter, count) {
            (function (btn) {
                var that = this;
                btn = that._render(btn);
                that._removeStyles(btn);
                that._addStyles(btn, counter, count);
                that._performLayout(btn);
                that._removeButtonListeners(btn);
                that._addButtonListeners(btn);
                that._handleButtonId(btn, counter);

                if (that.mode === "radio") {
                    btn.attr('role', 'radio');
                }
                else {
                    btn.attr('role', 'button');
                }
                btn.attr('disabled', that.disabled);
                if (that.disabled) {
                    btn.addClass(that.toThemeProperty('jqx-fill-state-disabled'));
                }
                else {
                    btn.removeClass(that.toThemeProperty('jqx-fill-state-disabled'));
                }
            }).apply(this, [btn]);
        },

        destroy: function (removeFromDom) {
            var that = this;
            var children = that.host.children(),
            count = children.length,
            current;

            for (var i = 0; i < count; i += 1) {
                current = $(children[i]);
                that._removeStyles(current);
                that._removeButtonListeners(current);
            }

            if (removeFromDom !== false) {
                that.host.remove();
            }
        },

        _render: function (btn) {
            var that = this;
            if (btn[0].tagName.toLowerCase() === 'button') {
                return that._renderFromButton(btn);
            } else {
                return that._renderButton(btn);
            }
        },

        _renderButton: function (btn) {
            var content;
            btn.wrapInner('<div/>');
            return btn;
        },

        _removeStyles: function (btn) {
            var that = this;
            var tp = that.toThemeProperty;
            that.host.removeClass('jqx-widget');
            that.host.removeClass('jqx-rc-all');
            btn.removeClass(tp.call(this, 'jqx-fill-state-normal'));
            btn.removeClass(tp.call(this, 'jqx-group-button-normal'));
            btn.removeClass(tp.call(this, 'jqx-rc-tl'));
            btn.removeClass(tp.call(this, 'jqx-rc-bl'));
            btn.removeClass(tp.call(this, 'jqx-rc-tr'));
            btn.removeClass(tp.call(this, 'jqx-rc-br'));
            btn.css('margin-left', 0);
        },

        _addStyles: function (btn, counter, count) {
            var that = this;
            var tp = this.toThemeProperty;
            that.host.addClass(tp.call(this, 'jqx-widget'));
            that.host.addClass(tp.call(this, 'jqx-rc-all'));
            that.host.addClass(tp.call(this, 'jqx-buttongroup'));
            btn.addClass(tp.call(this, 'jqx-button'));
            btn.addClass(tp.call(this, 'jqx-group-button-normal'));
            btn.addClass(tp.call(this, 'jqx-fill-state-normal'));
            if (that.template) {
                btn.addClass(tp.call(this, 'jqx-' + that.template));
            }
            if (that.roundedCorners) {
                if (counter === 0) {
                    that._addRoundedCorners(btn, true);
                } else if (counter === count - 1) {
                    that._addRoundedCorners(btn, false);
                }
            }
            if (that.orientation === 'horizontal') {
                btn.css('margin-left', -parseInt(btn.css('border-left-width'), 10));
            }
            else {
                btn.css('margin-top', -parseInt(btn.css('border-left-width'), 10));
            }
        },

        _addRoundedCorners: function (button, left) {
            var that = this;
            var tp = that.toThemeProperty;
            if (that.orientation === 'horizontal') {
                if (left) {
                    button.addClass(tp.call(this, 'jqx-rc-tl'));
                    button.addClass(tp.call(this, 'jqx-rc-bl'));
                } else {
                    button.addClass(tp.call(this, 'jqx-rc-tr'));
                    button.addClass(tp.call(this, 'jqx-rc-br'));
                }
            }
            else {
                if (left) {
                    button.addClass(tp.call(this, 'jqx-rc-tl'));
                    button.addClass(tp.call(this, 'jqx-rc-tr'));
                } else {
                    button.addClass(tp.call(this, 'jqx-rc-bl'));
                    button.addClass(tp.call(this, 'jqx-rc-br'));
                }
            }
        },

        _centerContent: function (content, parent) {
            content.css({
                'margin-top': (parent.height() - content.height()) / 2,
                'margin-left': (parent.width() - content.width()) / 2
            });
            return content;
        },

        _renderFromButton: function (btn) {
            var content = btn.val();
            if (content === "") {
                content = btn.html();
            }

            var div;
            var id = btn[0].id;
            btn.wrap('<div/>');
            div = btn.parent();
            div.attr('style', btn.attr('style'));
            btn.remove();
            $.jqx.utilities.html(div, content);
            div[0].id = id;
            return div;
        },

        _performLayout: function (btn) {
            if (this.orientation === 'horizontal') {
                if (this.rtl) {
                    btn.css('float', 'right');
                }
                else {
                    btn.css('float', 'left');
                }
            }
            else {
                btn.css('float', 'none');
            }

            this._centerContent($(btn.children()), btn);
        },

        _mouseEnterHandler: function (e) {
            var self = e.data.self,
                btn = $(e.currentTarget);
            if (self._isDisabled(btn) || !self.enableHover) {
                return;
            }
            var tp = self.toThemeProperty;
            btn.addClass(tp.call(self, 'jqx-group-button-hover'));
            btn.addClass(tp.call(self, 'jqx-fill-state-hover'));
        },

        _mouseLeaveHandler: function (e) {
            var self = e.data.self,
                btn = $(e.currentTarget);
            if (self._isDisabled(btn) || !self.enableHover) {
                return;
            }
            var tp = self.toThemeProperty;
            btn.removeClass(tp.call(self, 'jqx-group-button-hover'));
            btn.removeClass(tp.call(self, 'jqx-fill-state-hover'));
        },

        _mouseDownHandler: function (e) {
            var self = e.data.self,
                btn = $(e.currentTarget);
            if (self._isDisabled(btn)) {
                return;
            }
            self._pressed = btn;
            var tp = self.toThemeProperty;
            btn.addClass(tp.call(self, 'jqx-group-button-pressed'));
            btn.addClass(tp.call(self, 'jqx-fill-state-pressed'));
        },

        _mouseUpHandler: function (e) {
            var self = e.data.self,
                btn = $(e.currentTarget);
            if (self._isDisabled(btn)) {
                return;
            }
            self._handleSelection(btn);
            self._pressed = null;
            btn = self._buttonId[btn[0].id];
            self._raiseEvent(2, { index: btn.num, button: btn.btn });
        },

        _isDisabled: function (btn) {
            if (!btn || !btn[0]) {
                return false;
            }
            return this._buttonId[btn[0].id].disabled;
        },

        _documentUpHandler: function (e) {
            var self = e.data.self,
                pressedButton = self._pressed;
            if (pressedButton && !self._buttonId[pressedButton[0].id].selected) {
                pressedButton.removeClass(self.toThemeProperty('jqx-fill-state-pressed'));
                self._pressed = null;
            }
        },

        _addButtonListeners: function (btn) {
            var that = this;
            var ah = that.addHandler;
            var ge = that._getEvent;

            ah(btn, ge.call(that, 'mouseenter'), that._mouseEnterHandler, { self: that });
            ah(btn, ge.call(that, 'mouseleave'), that._mouseLeaveHandler, { self: that });
            ah(btn, ge.call(that, 'mousedown'), that._mouseDownHandler, { self: that });
            ah(btn, ge.call(that, 'mouseup'), that._mouseUpHandler, { self: that });
            ah($(document), ge.call(that, 'mouseup'), that._documentUpHandler, { self: that });
        },

        _removeButtonListeners: function (btn) {
            var that = this;
            var rh = that.removeHandler;
            var ge = that._getEvent;
            rh(btn, ge.call(that, 'mouseenter'), that._mouseEnterHandler);
            rh(btn, ge.call(that, 'mouseleave'), that._mouseLeaveHandler);
            rh(btn, ge.call(that, 'mousedown'), that._mouseDownHandler);
            rh(btn, ge.call(that, 'mouseup'), that._mouseUpHandler);
            rh($(document), ge.call(that, 'mouseup'), that._documentUpHandler);
        },

        _handleSelection: function (btn) {
            var that = this;
            if (that.mode === 'radio') {
                that._handleRadio(btn);
            } else if (that.mode === 'checkbox') {
                that._handleCheckbox(btn);
            } else {
                that._handleDefault(btn);
            }
        },

        _handleRadio: function (btn) {
            var that = this;
            var selected = that._getSelectedButton();
            if (selected && selected.btn[0].id !== btn[0].id) {
                that._unselectButton(selected.btn, true);
            }
            for (var data in that._buttonId) {
                that._buttonId[data].selected = true;
                that._unselectButton(that._buttonId[data].btn, false);
            }

            that._selectButton(btn, true);
        },

        _handleCheckbox: function (btn) {
            var that = this;
            var btnInfo = that._buttonId[btn[0].id];
            if (btnInfo.selected) {
                that._unselectButton(btnInfo.btn, true);
            } else {
                that._selectButton(btn, true);
            }
        },

        _handleDefault: function (btn) {
            var that = this;
            that._selectButton(btn, false);
            for (var data in that._buttonId) {
                that._buttonId[data].selected = true;
                that._unselectButton(that._buttonId[data].btn, false);
            }
        },

        _getSelectedButton: function () {
            var that = this;
            for (var data in that._buttonId) {
                if (that._buttonId[data].selected) {
                    return that._buttonId[data];
                }
            }
            return null;
        },

        _getSelectedButtons: function () {
            var that = this;
            var selected = [];
            for (var data in that._buttonId) {
                if (that._buttonId[data].selected) {
                    selected.push(that._buttonId[data].num);
                }
            }
            return selected;
        },

        _getButtonByIndex: function (index) {
            var that = this;
            var current;
            for (var data in that._buttonId) {
                if (that._buttonId[data].num === index) {
                    return that._buttonId[data];
                }
            }
            return null;
        },

        _selectButton: function (btn, raiseEvent) {
            var that = this;
            var btnInfo = that._buttonId[btn[0].id];
            if (btnInfo.selected) {
                return;
            }
            var tp = that.toThemeProperty;
            btnInfo.btn.addClass(tp.call(this, 'jqx-group-button-pressed'));
            btnInfo.btn.addClass(tp.call(this, 'jqx-fill-state-pressed'));
            btnInfo.selected = true;
            if (raiseEvent) {
                that._raiseEvent(0, { index: btnInfo.num, button: btnInfo.btn });
            }
            $.jqx.aria(btnInfo.btn, 'aria-checked', true);
        },

        _unselectButton: function (btn, raiseEvent) {
            var that = this;
            var btnInfo = that._buttonId[btn[0].id];
            if (!btnInfo.selected) {
                return;
            }
            var tp = that.toThemeProperty;
            btnInfo.btn.removeClass(tp.call(this, 'jqx-group-button-pressed'));
            btnInfo.btn.removeClass(tp.call(this, 'jqx-fill-state-pressed'));
            btnInfo.selected = false;
            if (raiseEvent) {
                that._raiseEvent(1, { index: btnInfo.num, button: btnInfo.btn });
            }
            $.jqx.aria(btnInfo.btn, 'aria-checked', false);
        },

        setSelection: function (index) {
            var that = this;
            if (index === -1) {
                that.clearSelection();
                return;
            }

            if (that.mode === 'checkbox') {
                if (typeof index === 'number') {
                    that._setSelection(index);
                } else {
                    for (var i = 0; i < index.length; i += 1) {
                        that._setSelection(index[i]);
                    }
                }
            } else if (typeof index === 'number' && that.mode === 'radio') {
                that._setSelection(index);
            }
        },

        _setSelection: function (index) {
            var that = this;
            var btn = that._getButtonByIndex(index);
            if (btn) {
                that._handleSelection(btn.btn);
            }
        },

        getSelection: function () {
            var that = this;
            if (that.mode === 'radio') {
                if (that._getSelectedButton()) {
                    return that._getSelectedButton().num;
                }
            } else if (that.mode === 'checkbox') {
                return that._getSelectedButtons();
            }
            return undefined;
        },

        disable: function () {
            var that = this;
            that.disabled = true;
            var current;
            for (var btn in that._buttonId) {
                current = that._buttonId[btn];
                that.disableAt(current.num);
            }
            $.jqx.aria(that, "aria-disabled", true);
        },

        enable: function () {
            var that = this;
            that.disabled = false;
            var current;
            for (var btn in that._buttonId) {
                current = that._buttonId[btn];
                that.enableAt(current.num);
            }
            $.jqx.aria(that, "aria-disabled", false);
        },

        disableAt: function (index) {
            var that = this;
            var btn = that._getButtonByIndex(index);
            if (!btn.disabled) {
                btn.disabled = true;
                btn.btn.addClass(that.toThemeProperty('jqx-fill-state-disabled'));
            }
        },

        enableAt: function (index) {
            var that = this;
            var btn = that._getButtonByIndex(index);
            if (btn.disabled) {
                btn.disabled = false;
                btn.btn.removeClass(that.toThemeProperty('jqx-fill-state-disabled'));
            }
        },

        _handleButtonId: function (btn, number) {
            var id = btn[0].id,
                btnId = { btn: btn, num: number, selected: false },
                widgetId;
            if (!id) {
                id = this._baseId + btn.index();
            }
            btn[0].id = id;
            this._buttonId[id] = btnId;
            return id;
        },

        _raiseEvent: function (id, data) {
            var event = $.Event(this._events[id]);
            event.args = data;
            return this.host.trigger(event);
        },

        _unselectAll: function () {
            for (var data in this._buttonId) {
                this._unselectButton(this._buttonId[data].btn, false);
            }
        },

        clearSelection: function () {
            this._unselectAll();
        },

        propertyChangedHandler: function (object, key, oldvalue, value) {
            if (key === 'theme' && value !== null) {
                $.jqx.utilities.setTheme(oldvalue, value, object.host);
            }

            if (key === 'rtl') {
                object.refresh();
            }
            if (key === "template") {
                object.refresh();
            }
            if (key === 'mode') {
                object._unselectAll();
                object.refresh();
                return;
            } else if (key === 'disabled') {
                if (value) {
                    object.disable();
                } else {
                    object.enable();
                }
            } else {
                object.refresh();
            }
        }
    });
})(jqxBaseFramework);
})();



/***/ }),

/***/ 7351:
/***/ (() => {

/* tslint:disable */
/* eslint-disable */
(function () {
    if (typeof document === 'undefined') {
        return;
    }

    (function ($) {
        $.jqx.cssroundedcorners = function (value) {
            var cssMap = {
                'all': 'jqx-rc-all',
                'top': 'jqx-rc-t',
                'bottom': 'jqx-rc-b',
                'left': 'jqx-rc-l',
                'right': 'jqx-rc-r',
                'top-right': 'jqx-rc-tr',
                'top-left': 'jqx-rc-tl',
                'bottom-right': 'jqx-rc-br',
                'bottom-left': 'jqx-rc-bl'
            };

            for (var prop in cssMap) {
                if (!cssMap.hasOwnProperty(prop))
                    continue;

                if (value == prop)
                    return cssMap[prop];
            }
        }

        $.jqx.jqxWidget("jqxButton", "", {});

        $.extend($.jqx._jqxButton.prototype, {
            defineInstance: function () {
                var settings = {
                    type: '',
                    cursor: 'arrow',
                    // rounds the button corners.
                    roundedCorners: 'all',
                    // enables / disables the button
                    disabled: false,
                    // sets height to the button.
                    height: null,
                    // sets width to the button.
                    width: null,
                    overrideTheme: false,
                    enableHover: true,
                    enableDefault: true,
                    enablePressed: true,
                    imgPosition: "center",
                    imgSrc: "",
                    imgWidth: 16,
                    imgHeight: 16,
                    value: null,
                    textPosition: "",
                    textImageRelation: "overlay",
                    rtl: false,
                    _ariaDisabled: false,
                    _scrollAreaButton: false,
                    // "primary", "inverse", "danger", "info", "success", "warning", "link"
                    template: "default",
                    aria:
                    {
                        "aria-disabled": { name: "disabled", type: "boolean" }
                    }
                }
                if (this === $.jqx._jqxButton.prototype) {
                    return settings;
                }
                $.extend(true, this, settings);
                return settings;
            },

            _addImage: function (name) {
                var that = this;
                if (that.element.nodeName.toLowerCase() == "input" || that.element.nodeName.toLowerCase() == "button" || that.element.nodeName.toLowerCase() == "div") {
                    if (!that._img) {
                        that.field = that.element;
                        if (that.field.className) {
                            that._className = that.field.className;
                        }

                        var properties = {
                            'title': that.field.title
                        };

                        var value = null;
                        if (that.field.getAttribute('value')) {
                            var value = that.field.getAttribute('value');
                        }
                        else if (that.element.nodeName.toLowerCase() != "input") {
                            var value = that.element.innerHTML;
                        }
                        if (that.value) {
                            value = that.value;
                        }
                        if (that.field.id.length) {
                            properties.id = that.field.id.replace(/[^\w]/g, '_') + "_" + name;
                        }
                        else {
                            properties.id = $.jqx.utilities.createId() + "_" + name;
                        }


                        var wrapper = document.createElement('div');
                        wrapper.id = properties.id;
                        wrapper.title = properties.title;
                        wrapper.style.cssText = that.field.style.cssText;
                        wrapper.style.boxSizing = 'border-box';

                        var img = document.createElement("img");
                        img.setAttribute('src', that.imgSrc);
                        img.setAttribute('width', that.imgWidth);
                        img.setAttribute('height', that.imgHeight);
                        wrapper.appendChild(img);
                        that._img = img;

                        var text = document.createElement('span');
                        if (value) {
                            text.innerHTML = value;
                            that.value = value;
                        }
                        wrapper.appendChild(text);
                        that._text = text;

                        that.field.style.display = "none";
                        if (that.field.parentNode) {
                            that.field.parentNode.insertBefore(wrapper, that.field.nextSibling);
                        }

                        var data = that.host.data();
                        that.host = $(wrapper);
                        that.host.data(data);
                        that.element = wrapper;
                        that.element.id = that.field.id;
                        that.field.id = properties.id;
                        var elementObj = new $(that.element);
                        var fieldObj = new $(that.field);
                        if (that._className) {
                            elementObj.addClass(that._className);
                            fieldObj.removeClass(that._className);
                        }

                        if (that.field.tabIndex) {
                            var tabIndex = that.field.tabIndex;
                            that.field.tabIndex = -1;
                            that.element.tabIndex = tabIndex;
                        }
                    }
                    else {
                        that._img.setAttribute('src', that.imgSrc);
                        that._img.setAttribute('width', that.imgWidth);
                        that._img.setAttribute('height', that.imgHeight);
                        that._text.innerHTML = that.value;
                    }
                    if (!that.imgSrc) {
                        that._img.style.display = "none";
                    }
                    else {
                        that._img.style.display = "inline";
                    }

                    if (!that.value) {
                        that._text.style.display = "none";
                    }
                    else {
                        that._text.style.display = "inline";
                    }

                    that._positionTextAndImage();
                }
            },

            _positionTextAndImage: function () {
                var that = this;
                var width = that.element.offsetWidth;
                var height = that.element.offsetHeight;

                var imgWidth = that.imgWidth;
                var imgHeight = that.imgHeight;
                if (that.imgSrc == "") {
                    imgWidth = 0;
                    imgHeight = 0;
                }

                var textWidth = that._text.offsetWidth;
                var textHeight = that._text.offsetHeight;
                var offset = 4;
                var edgeOffset = 4;
                var factorIncrease = 4;
                var w = 0;
                var h = 0;
                switch (that.textImageRelation) {
                    case "imageBeforeText":
                    case "textBeforeImage":
                        w = imgWidth + textWidth + 2 * factorIncrease + offset + 2 * edgeOffset;
                        h = Math.max(imgHeight, textHeight) + 2 * factorIncrease + offset + 2 * edgeOffset;
                        break;
                    case "imageAboveText":
                    case "textAboveImage":
                        w = Math.max(imgWidth, textWidth) + 2 * factorIncrease;
                        h = imgHeight + textHeight + offset + 2 * factorIncrease + 2 * edgeOffset;
                        break;
                    case "overlay":
                        w = Math.max(imgWidth, textWidth) + 2 * factorIncrease;
                        h = Math.max(imgHeight, textHeight) + 2 * factorIncrease;
                        break;
                }

                if (!that.width) {
                    that.element.style.width = w + "px";
                    width = w;
                }

                if (!that.height) {
                    that.element.style.height = h + "px";
                    height = h;
                }

                that._img.style.position = 'absolute';
                that._text.style.position = 'absolute';
                that.element.style.position = 'relative';
                that.element.style.overflow = 'hidden';

                var textRect = {};
                var imageRect = {};

                var drawElement = function (element, drawArea, pos, w, h) {
                    if (drawArea.width < w) drawArea.width = w;
                    if (drawArea.height < h) drawArea.height = h;

                    switch (pos) {
                        case "left":
                            element.style.left = drawArea.left + "px";
                            element.style.top = drawArea.top + drawArea.height / 2 - h / 2 + "px";;
                            break;
                        case "topLeft":
                            element.style.left = drawArea.left + "px";
                            element.style.top = drawArea.top + "px";
                            break;
                        case "bottomLeft":
                            element.style.left = drawArea.left + "px";
                            element.style.top = drawArea.top + drawArea.height - h + "px";
                            break;
                        default:
                        case "center":
                            element.style.left = drawArea.left + drawArea.width / 2 - w / 2 + "px";
                            element.style.top = drawArea.top + drawArea.height / 2 - h / 2 + "px";
                            break;
                        case "top":
                            element.style.left = drawArea.left + drawArea.width / 2 - w / 2 + "px";
                            element.style.top = drawArea.top + "px";
                            break;
                        case "bottom":
                            element.style.left = drawArea.left + drawArea.width / 2 - w / 2 + "px";
                            element.style.top = drawArea.top + drawArea.height - h + "px";
                            break;
                        case "right":
                            element.style.left = drawArea.left + drawArea.width - w + "px";
                            element.style.top = drawArea.top + drawArea.height / 2 - h / 2 + "px";;
                            break;
                        case "topRight":
                            element.style.left = drawArea.left + drawArea.width - w + "px";
                            element.style.top = drawArea.top + "px";
                            break;
                        case "bottomRight":
                            element.style.left = drawArea.left + drawArea.width - w + "px";
                            element.style.top = drawArea.top + drawArea.height - h + "px";
                            break;
                    }
                }

                var left = 0;
                var top = 0;
                var right = width;
                var bottom = height;
                var middle = (right - left) / 2;
                var center = (bottom - top) / 2;
                var img = that._img;
                var text = that._text;
                var rectHeight = bottom - top;
                var rectWidth = right - left;
                left += edgeOffset;
                top += edgeOffset;
                right = right - edgeOffset - 2;
                rectWidth = rectWidth - 2 * edgeOffset - 2;
                rectHeight = rectHeight - 2 * edgeOffset - 2;

                switch (that.textImageRelation) {
                    case "imageBeforeText":

                        switch (that.imgPosition) {
                            case "left":
                            case "topLeft":
                            case "bottomLeft":
                                imageRect = { left: left, top: top, width: left + imgWidth, height: rectHeight };
                                textRect = { left: left + imgWidth + offset, top: top, width: rectWidth - imgWidth - offset, height: rectHeight };
                                break;
                            case "center":
                            case "top":
                            case "bottom":
                                imageRect = { left: middle - textWidth / 2 - imgWidth / 2 - offset / 2, top: top, width: imgWidth, height: rectHeight };
                                textRect = { left: imageRect.left + imgWidth + offset, top: top, width: right - imageRect.left - imgWidth - offset, height: rectHeight };
                                break;
                            case "right":
                            case "topRight":
                            case "bottomRight":
                                imageRect = { left: right - textWidth - imgWidth - offset, top: top, width: imgWidth, height: rectHeight };
                                textRect = { left: imageRect.left + imgWidth + offset, top: top, width: right - imageRect.left - imgWidth - offset, height: rectHeight };
                                break;

                        }
                        drawElement(img, imageRect, that.imgPosition, imgWidth, imgHeight);
                        drawElement(text, textRect, that.textPosition, textWidth, textHeight);

                        break;
                    case "textBeforeImage":

                        switch (that.textPosition) {
                            case "left":
                            case "topLeft":
                            case "bottomLeft":
                                textRect = { left: left, top: top, width: left + textWidth, height: rectHeight };
                                imageRect = { left: left + textWidth + offset, top: top, width: rectWidth - textWidth - offset, height: rectHeight };
                                break;
                            case "center":
                            case "top":
                            case "bottom":
                                textRect = { left: middle - textWidth / 2 - imgWidth / 2 - offset / 2, top: top, width: textWidth, height: rectHeight };
                                imageRect = { left: textRect.left + textWidth + offset, top: top, width: right - textRect.left - textWidth - offset, height: rectHeight };
                                break;
                            case "right":
                            case "topRight":
                            case "bottomRight":
                                textRect = { left: right - textWidth - imgWidth - offset, top: top, width: textWidth, height: rectHeight };
                                imageRect = { left: textRect.left + textWidth + offset, top: top, width: right - textRect.left - textWidth - offset, height: rectHeight };
                                break;

                        }
                        drawElement(img, imageRect, that.imgPosition, imgWidth, imgHeight);
                        drawElement(text, textRect, that.textPosition, textWidth, textHeight);

                        break;
                    case "imageAboveText":

                        switch (that.imgPosition) {
                            case "topRight":
                            case "top":
                            case "topLeft":
                                imageRect = { left: left, top: top, width: rectWidth, height: imgHeight };
                                textRect = { left: left, top: top + imgHeight + offset, width: rectWidth, height: rectHeight - imgHeight - offset };
                                break;
                            case "left":
                            case "center":
                            case "right":
                                imageRect = { left: left, top: center - imgHeight / 2 - textHeight / 2 - offset / 2, width: rectWidth, height: imgHeight };
                                textRect = { left: left, top: imageRect.top + offset + imgHeight, width: rectWidth, height: rectHeight - imageRect.top - offset - imgHeight };
                                break;
                            case "bottomLeft":
                            case "bottom":
                            case "bottomRight":
                                imageRect = { left: left, top: bottom - imgHeight - textHeight - offset, width: rectWidth, height: imgHeight };
                                textRect = { left: left, top: imageRect.top + offset + imgHeight, width: rectWidth, height: textHeight };
                                break;

                        }
                        drawElement(img, imageRect, that.imgPosition, imgWidth, imgHeight);
                        drawElement(text, textRect, that.textPosition, textWidth, textHeight);
                        break;
                    case "textAboveImage":
                        switch (that.textPosition) {
                            case "topRight":
                            case "top":
                            case "topLeft":
                                textRect = { left: left, top: top, width: rectWidth, height: textHeight };
                                imageRect = { left: left, top: top + textHeight + offset, width: rectWidth, height: rectHeight - textHeight - offset };
                                break;
                            case "left":
                            case "center":
                            case "right":
                                textRect = { left: left, top: center - imgHeight / 2 - textHeight / 2 - offset / 2, width: rectWidth, height: textHeight };
                                imageRect = { left: left, top: textRect.top + offset + textHeight, width: rectWidth, height: rectHeight - textRect.top - offset - textHeight };
                                break;
                            case "bottomLeft":
                            case "bottom":
                            case "bottomRight":
                                textRect = { left: left, top: bottom - imgHeight - textHeight - offset, width: rectWidth, height: textHeight };
                                imageRect = { left: left, top: textRect.top + offset + textHeight, width: rectWidth, height: imgHeight };
                                break;

                        }
                        drawElement(img, imageRect, that.imgPosition, imgWidth, imgHeight);
                        drawElement(text, textRect, that.textPosition, textWidth, textHeight);

                        break;
                    case "overlay":
                    default:
                        textRect = { left: left, top: top, width: rectWidth, height: rectHeight };
                        imageRect = { left: left, top: top, width: rectWidth, height: rectHeight };

                        drawElement(img, imageRect, that.imgPosition, imgWidth, imgHeight);
                        drawElement(text, textRect, that.textPosition, textWidth, textHeight);

                        break;
                }
            },

            createInstance: function (args) {
                var that = this;
                that._setSize();

                var isMaterial = that.isMaterialized();

                that.buttonObj = new $(that.element);

                if (that.imgSrc != "" || that.textPosition != "" || (that.element.value && that.element.value.indexOf("<") >= 0) || that.value != null) {
                    that.refresh();
                    that._addImage("jqxButton");
                    that.buttonObj = new $(that.element);
                }

                if (!that._ariaDisabled) {
                    that.element.setAttribute('role', 'button');
                }
                if (that.type !== '') {
                    that.element.setAttribute('type', that.type);
                }
                if (!that.overrideTheme) {
                    that.buttonObj.addClass(that.toThemeProperty($.jqx.cssroundedcorners(that.roundedCorners)));
                    if (that.enableDefault) {
                        that.buttonObj.addClass(that.toThemeProperty('jqx-button'));
                    }
                    that.buttonObj.addClass(that.toThemeProperty('jqx-widget'));
                }

                that.isTouchDevice = $.jqx.mobile.isTouchDevice();
                if (!that._ariaDisabled) {
                    $.jqx.aria(this);
                }

                if (that.cursor != 'arrow') {
                    if (!that.disabled) {
                        that.element.style.cursor = that.cursor;
                    }
                    else {
                        that.element.style.cursor = "arrow";
                    }
                }

                var eventNames = 'mouseenter mouseleave mousedown focus blur';
                if (that._scrollAreaButton) {
                    var eventNames = 'mousedown';
                }

                if (that.isTouchDevice) {
                    that.addHandler(that.host, $.jqx.mobile.getTouchEventName('touchstart'), function (event) {
                        that.isPressed = true;
                        that.refresh();
                    });
                    that.addHandler($(document), $.jqx.mobile.getTouchEventName('touchend') + "." + that.element.id, function (event) {
                        that.isPressed = false;
                        that.refresh();
                    });
                }

                that.addHandler(that.host, eventNames, function (event) {
                    switch (event.type) {
                        case 'mouseenter':
                            if (!that.isTouchDevice) {
                                if (!that.disabled && that.enableHover) {
                                    that.isMouseOver = true;
                                    that.refresh();
                                }
                            }
                            break;
                        case 'mouseleave':
                            if (!that.isTouchDevice) {
                                if (!that.disabled && that.enableHover) {
                                    that.isMouseOver = false;
                                    that.refresh();
                                }
                            }
                            break;
                        case 'mousedown':
                            if (!that.disabled) {
                                that.isPressed = true;
                                that.refresh();
                            }
                            break;
                        case 'focus':
                            if (!that.disabled) {
                                that.isFocused = true;
                                that.refresh();
                            }
                            break;
                        case 'blur':
                            if (!that.disabled) {
                                that.isFocused = false;
                                that.refresh();
                            }
                            break;
                    }
                });

                that.mouseupfunc = function (event) {
                    if (!that.disabled) {
                        if (that.isPressed || that.isMouseOver) {
                            that.isPressed = false;
                            that.refresh();
                        }
                    }
                }

                that.addHandler(document, 'mouseup.button' + that.element.id, that.mouseupfunc);

                try {
                    if (document.referrer != "" || window.frameElement) {
                        if (window.top != null && window.top != window.that) {
                            var parentLocation = '';
                            if (window.parent && document.referrer) {
                                parentLocation = document.referrer;
                            }

                            if (parentLocation.indexOf(document.location.host) != -1) {
                                if (window.top.document) {
                                    window.top.document.addEventListener('mouseup', that._topDocumentMouseupHandler);
                                }
                            }
                        }
                    }
                }
                catch (error) {
                }

                that.propertyChangeMap['roundedCorners'] = function (instance, key, oldVal, value) {
                    instance.buttonObj.removeClass(instance.toThemeProperty($.jqx.cssroundedcorners(oldVal)));
                    instance.buttonObj.addClass(instance.toThemeProperty($.jqx.cssroundedcorners(value)));
                };
                that.propertyChangeMap['disabled'] = function (instance, key, oldVal, value) {
                    if (oldVal != value) {
                        instance.refresh();
                        instance.element.setAttribute('disabled', value);
                        instance.element.disabled = value;
                        if (!value) {
                            instance.element.style.cursor = instance.cursor;
                        }
                        else {
                            instance.element.style.cursor = 'default';
                        }

                        $.jqx.aria(instance, "aria-disabled", instance.disabled);
                    }
                };
                that.propertyChangeMap['rtl'] = function (instance, key, oldVal, value) {
                    if (oldVal != value) {
                        instance.refresh();
                    }
                };
                that.propertyChangeMap['template'] = function (instance, key, oldVal, value) {
                    if (oldVal != value) {
                        instance.buttonObj.removeClass(instance.toThemeProperty("jqx-" + oldVal));
                        instance.refresh();
                    }
                };
                that.propertyChangeMap['theme'] = function (instance, key, oldVal, value) {
                    instance.buttonObj.removeClass(instance.element);

                    if (oldVal) {
                        instance.buttonObj.removeClass('jqx-button-' + oldVal);
                        instance.buttonObj.removeClass('jqx-widget-' + oldVal);
                        instance.buttonObj.removeClass('jqx-fill-state-normal-' + oldVal);
                        instance.buttonObj.removeClass(instance.toThemeProperty($.jqx.cssroundedcorners(instance.roundedCorners)) + '-' + oldVal);
                    }

                    if (instance.enableDefault) {
                        instance.buttonObj.addClass(instance.toThemeProperty('jqx-button'));
                    }
                    instance.buttonObj.addClass(instance.toThemeProperty('jqx-widget'));
                    if (!instance.overrideTheme) {
                        instance.buttonObj.addClass(instance.toThemeProperty($.jqx.cssroundedcorners(instance.roundedCorners)));
                    }
                    instance._oldCSSCurrent = null;
                    instance.refresh();
                };

                if (that.disabled) {
                    that.element.disabled = true;
                    that.element.setAttribute('disabled', 'true');
                }

                if (that.textPosition) {
                    $.jqx.utilities.resize(this.host, function () {
                        that._positionTextAndImage();
                    });
                }
            }, // createInstance

            resize: function (width, height) {
                this.width = width;
                this.height = height;
                this._setSize();
            },

            val: function (value) {
                var that = this;
                var input = that.host.find('input');
                if (input.length > 0) {
                    if (arguments.length == 0 || typeof (value) == "object") {
                        return input.val();
                    }
                    input.val(value);
                    that.refresh();
                    return input.val();
                }

                if (arguments.length == 0 || typeof (value) == "object") {
                    if (that.element.nodeName.toLowerCase() == "button") {
                        return $(that.element).text();
                    }
                    return that.element.value;
                }

                if (arguments.length > 0 && that._text) {
                    that._text.innerHTML = arguments[0];
                    that.refresh();

                    return;
                }
                else if (arguments.length > 0 && that.element.nodeName === 'DIV') {
                    that.element.innerHTML = arguments[0];
                    that.refresh();
                }

                that.element.value = arguments[0];
                if (that.element.nodeName.toLowerCase() == "button") {
                    $(that.element).html(arguments[0]);
                }

                that.refresh();
            },

            _setSize: function () {
                var that = this;
                var height = that.height;
                var width = that.width;

                if (height) {
                    if (!isNaN(height)) {
                        height = height + "px";
                    }
                    that.element.style.height = height;
                }

                if (width) {
                    if (!isNaN(width)) {
                        width = width + "px";
                    }
                    that.element.style.width = width;
                }
            },

            _removeHandlers: function () {
                var that = this;
                that.removeHandler(that.host, 'selectstart');
                that.removeHandler(that.host, 'click');
                that.removeHandler(that.host, 'focus');
                that.removeHandler(that.host, 'blur');
                that.removeHandler(that.host, 'mouseenter');
                that.removeHandler(that.host, 'mouseleave');
                that.removeHandler(that.host, 'mousedown');
                that.removeHandler($(document), 'mouseup.button' + that.element.id, that.mouseupfunc);
                if (that.isTouchDevice) {
                    that.removeHandler(that.host, $.jqx.mobile.getTouchEventName('touchstart'));
                    that.removeHandler($(document), $.jqx.mobile.getTouchEventName('touchend') + "." + that.element.id);
                }
                that.mouseupfunc = null;
                delete that.mouseupfunc;
            },

            focus: function () {
                this.host.focus();
            },

            destroy: function () {
                var that = this;
                that._removeHandlers();
                var vars = $.data(that.element, "jqxButton");
                if (vars) {
                    delete vars.instance;
                }
                that.host.removeClass();
                that.host.removeData();
                that.host.remove();
                delete that.set;
                delete that.get;
                delete that.call;
                delete that.element;
                delete that.host;
            },

            render: function () {
                this.refresh();
            },

            propertiesChangedHandler: function (object, oldValues, newValues) {
                if (newValues && newValues.width && newValues.height && Object.keys(newValues).length == 2) {
                    object._setSize();
                    object.refresh();
                }
            },

            propertyChangedHandler: function (object, key, oldvalue, value) {
                if (this.isInitialized == undefined || this.isInitialized == false)
                    return;

                if (value == oldvalue) {
                    return;
                }

                if (object.batchUpdate && object.batchUpdate.width && object.batchUpdate.height && Object.keys(object.batchUpdate).length == 2) {
                    return;
                }

                if (key === "type") {
                    object.element.setAttribute('type', value);
                }
                if (key == "textImageRelation" || key == "textPosition" || key == "imgPosition") {
                    if (object._img) {
                        object._positionTextAndImage();
                    }
                    else object._addImage("jqxButton");
                }
                if (key == "imgSrc" || key == "imgWidth" || key == "imgHeight") {
                    object._addImage("jqxButton");
                }

                if (key === "value") {
                    object.val(value);
                }

                if (key == "width" || key == "height") {
                    object._setSize();
                    object.refresh();
                }
            },

            refresh: function () {
                var that = this;
                if (that.overrideTheme)
                    return;

                var cssFocused = that.toThemeProperty('jqx-fill-state-focus');
                var cssDisabled = that.toThemeProperty('jqx-fill-state-disabled');
                var cssNormal = that.toThemeProperty('jqx-fill-state-normal');

                if (!that.enableDefault) {
                    cssNormal = "";
                }

                var cssHover = that.toThemeProperty('jqx-fill-state-hover');
                var cssPressed = that.toThemeProperty('jqx-fill-state-pressed');
                var cssPressedHover = that.toThemeProperty('jqx-fill-state-pressed');
                if (!that.enablePressed) {
                    cssPressed = "";
                }
                var cssCurrent = '';

                if (!that.host) {
                    return;
                }

                that.element.disabled = that.disabled;

                if (that.disabled) {
                    if (that._oldCSSCurrent) {
                        that.buttonObj.removeClass(that._oldCSSCurrent);
                    }
                    cssCurrent = cssNormal + " " + cssDisabled;
                    if (that.template !== "default" && that.template !== "") {
                        cssCurrent += " " + "jqx-" + that.template;
                        if (that.theme != "") {
                            cssCurrent += " " + "jqx-" + that.template + "-" + that.theme;
                        }
                    }
                    that.buttonObj.addClass(cssCurrent);
                    that._oldCSSCurrent = cssCurrent;
                    return;
                }
                else {
                    if (that.isMouseOver && !that.isTouchDevice) {
                        if (that.isPressed)
                            cssCurrent = cssPressedHover;
                        else
                            cssCurrent = cssHover;
                    }
                    else {
                        if (that.isPressed)
                            cssCurrent = cssPressed;
                        else
                            cssCurrent = cssNormal;
                    }
                }

                if (that.isFocused) {
                    cssCurrent += " " + cssFocused;
                }

                if (that.template !== "default" && that.template !== "") {
                    cssCurrent += " " + "jqx-" + that.template;
                    if (that.theme != "") {
                        cssCurrent += " " + "jqx-" + that.template + "-" + that.theme;
                    }
                }

                if (cssCurrent != that._oldCSSCurrent) {
                    if (that._oldCSSCurrent) {
                        that.buttonObj.removeClass(that._oldCSSCurrent);
                    }
                    that.buttonObj.addClass(cssCurrent);
                    that._oldCSSCurrent = cssCurrent;
                }
                if (that.rtl) {
                    that.buttonObj.addClass(that.toThemeProperty('jqx-rtl'));
                    that.element.style.direction = 'rtl';
                }


                if (that.isMaterialized()) {
                    that.host.addClass('buttonRipple');
                }
            }
        });

        //// LinkButton
        $.jqx.jqxWidget("jqxLinkButton", "", {});

        $.extend($.jqx._jqxLinkButton.prototype, {
            defineInstance: function () {
                // enables / disables the button
                this.disabled = false;
                // sets height to the button.
                this.height = null;
                // sets width to the button.
                this.width = null;
                this.rtl = false;
                this.href = null;
            },

            createInstance: function (args) {
                var that = this;
                this.host.onselectstart = function () { return false; };
                this.host.attr('role', 'button');

                var height = this.height || this.element.offsetHeight;
                var width = this.width || this.element.offsetWidth;
                this.href = this.element.getAttribute('href');
                this.target = this.element.getAttribute('target');
                this.content = this.host.text();
                this.element.innerHTML = "";
                var wrapElement = document.createElement('input');
                wrapElement.type = "button";
                wrapElement.className = "jqx-wrapper " + this.toThemeProperty('jqx-reset');

                this._setSize(wrapElement, width, height);

                wrapElement.value = this.content;
                var helper = new $(this.element);
                helper.addClass(this.toThemeProperty('jqx-link'));
                this.element.style.color = 'inherit';
                this.element.appendChild(wrapElement);
                this._setSize(wrapElement, width, height);

                var param = args == undefined ? {} : args[0] || {};
                $(wrapElement).jqxButton(param);
                this.wrapElement = wrapElement;
                if (this.disabled) {
                    this.element.disabled = true;
                }

                this.propertyChangeMap['disabled'] = function (instance, key, oldVal, value) {
                    instance.element.disabled = value;
                    instance.wrapElement.jqxButton({ disabled: value });
                }

                this.addHandler($(wrapElement), 'click', function (event) {
                    if (!this.disabled) {
                        that.onclick(event);
                    }
                    return false;
                });
            },

            _setSize: function (element, width, height) {
                var that = this;

                if (height) {
                    if (!isNaN(height)) {
                        height = height + "px";
                    }
                    element.style.height = height;
                }

                if (width) {
                    if (!isNaN(width)) {
                        width = width + "px";
                    }
                    element.style.width = width;
                }
            },


            onclick: function (event) {
                if (this.target != null) {
                    window.open(this.href, this.target);
                }
                else {
                    window.location = this.href;
                }
            }
        });
        //// End of LinkButton

        //// RepeatButton
        $.jqx.jqxWidget("jqxRepeatButton", "jqxButton", {});

        $.extend($.jqx._jqxRepeatButton.prototype, {
            defineInstance: function () {
                this.delay = 50;
            },

            createInstance: function (args) {
                var that = this;

                var isTouchDevice = $.jqx.mobile.isTouchDevice();

                var up = !isTouchDevice ? 'mouseup.' + this.base.element.id : 'touchend.' + this.base.element.id;
                var down = !isTouchDevice ? 'mousedown.' + this.base.element.id : 'touchstart.' + this.base.element.id;

                this.addHandler($(document), up, function (event) {
                    if (that.timeout != null) {
                        clearTimeout(that.timeout);
                        that.timeout = null;
                        that.refresh();
                    }
                    if (that.timer != undefined) {
                        clearInterval(that.timer);
                        that.timer = null;
                        that.refresh();
                    }
                });

                this.addHandler(this.base.host, down, function (event) {
                    if (that.timer != null) {
                        clearInterval(that.timer);
                    }

                    that.timeout = setTimeout(function () {
                        clearInterval(that.timer);
                        that.timer = setInterval(function (event) { that.ontimer(event); }, that.delay);
                    }, 150);
                });

                this.mousemovefunc = function (event) {
                    if (!isTouchDevice) {
                        if (event.which == 0) {
                            if (that.timer != null) {
                                clearInterval(that.timer);
                                that.timer = null;
                            }
                        }
                    }
                }

                this.addHandler(this.base.host, 'mousemove', this.mousemovefunc);
            },

            destroy: function () {
                var isTouchDevice = $.jqx.mobile.isTouchDevice();
                var up = !isTouchDevice ? 'mouseup.' + this.base.element.id : 'touchend.' + this.base.element.id;
                var down = !isTouchDevice ? 'mousedown.' + this.base.element.id : 'touchstart.' + this.base.element.id;
                this.removeHandler(this.base.host, 'mousemove', this.mousemovefunc);
                this.removeHandler(this.base.host, down);
                this.removeHandler($(document), up);
                this.timer = null;
                delete this.mousemovefunc;
                delete this.timer;
                var vars = $.data(this.base.element, "jqxRepeatButton");
                if (vars) {
                    delete vars.instance;
                }
                $(this.base.element).removeData();
                this.base.destroy();
                delete this.base;

            },

            stop: function () {
                clearInterval(this.timer);
                this.timer = null;
            },

            ontimer: function (event) {
                var event = new $.Event('click');
                if (this.base != null && this.base.host != null) {
                    this.base.host.trigger(event);
                }
            }
        });
        //// End of RepeatButton
        //// ToggleButton
        $.jqx.jqxWidget("jqxToggleButton", "jqxButton", {});

        $.extend($.jqx._jqxToggleButton.prototype, {
            defineInstance: function () {
                this.toggled = false;
                this.uiToggle = true;
                this.aria =
                {
                    "aria-checked": { name: "toggled", type: "boolean" },
                    "aria-disabled": { name: "disabled", type: "boolean" }
                };
            },

            createInstance: function (args) {
                var that = this;
                that.base.overrideTheme = true;
                that.isTouchDevice = $.jqx.mobile.isTouchDevice();
                $.jqx.aria(this);
                that.base.host.attr('role', 'checkbox');

                that.propertyChangeMap['roundedCorners'] = function (instance, key, oldVal, value) {
                    instance.base.buttonObj.removeClass(instance.toThemeProperty($.jqx.cssroundedcorners(oldVal)));
                    instance.base.buttonObj.addClass(instance.toThemeProperty($.jqx.cssroundedcorners(value)));
                };

                that.propertyChangeMap['toggled'] = function (instance, key, oldVal, value) {
                    instance.refresh();
                };
                that.propertyChangeMap['disabled'] = function (instance, key, oldVal, value) {
                    instance.base.disabled = value;
                    instance.refresh();
                };

                that.addHandler(that.base.host, 'click', function (event) {
                    if (!that.base.disabled && that.uiToggle) {
                        that.toggle();
                    }
                });

                if (!that.isTouchDevice) {
                    that.addHandler(that.base.host, 'mouseenter', function (event) {
                        if (!that.base.disabled) {
                            that.refresh();
                        }
                    });

                    that.addHandler(that.base.host, 'mouseleave', function (event) {
                        if (!that.base.disabled) {
                            that.refresh();
                        }
                    });
                }

                that.addHandler(that.base.host, 'mousedown', function (event) {
                    if (!that.base.disabled) {
                        that.refresh();
                    }
                });

                that.addHandler($(document), 'mouseup.togglebutton' + that.base.element.id, function (event) {
                    if (!that.base.disabled) {
                        that.refresh();
                    }
                });
            },

            destroy: function () {
                this._removeHandlers();
                this.base.destroy();
            },

            _removeHandlers: function () {
                this.removeHandler(this.base.host, 'click');
                this.removeHandler(this.base.host, 'mouseenter');
                this.removeHandler(this.base.host, 'mouseleave');
                this.removeHandler(this.base.host, 'mousedown');
                this.removeHandler($(document), 'mouseup.togglebutton' + this.base.element.id);
            },

            toggle: function () {
                this.toggled = !this.toggled;
                this.refresh();
                $.jqx.aria(this, "aria-checked", this.toggled);
            },

            unCheck: function () {
                this.toggled = false;
                this.refresh();
            },

            check: function () {
                this.toggled = true;
                this.refresh();
            },

            refresh: function () {
                var that = this;
                var cssDisabled = that.base.toThemeProperty('jqx-fill-state-disabled');
                var cssNormal = that.base.toThemeProperty('jqx-fill-state-normal');
                if (!that.base.enableDefault) {
                    cssNormal = "";
                }
                var cssHover = that.base.toThemeProperty('jqx-fill-state-hover');
                var cssPressed = that.base.toThemeProperty('jqx-fill-state-pressed');
                var cssPressedHover = that.base.toThemeProperty('jqx-fill-state-pressed');
                var cssCurrent = '';
                that.base.element.disabled = that.base.disabled;

                if (that.base.disabled) {
                    cssCurrent = cssNormal + " " + cssDisabled;
                    that.base.buttonObj.addClass(cssCurrent);
                    return;
                }
                else {
                    if (that.base.isMouseOver && !that.isTouchDevice) {
                        if (that.base.isPressed || that.toggled)
                            cssCurrent = cssPressedHover;
                        else
                            cssCurrent = cssHover;
                    }
                    else {
                        if (that.base.isPressed || that.toggled)
                            cssCurrent = cssPressed;
                        else
                            cssCurrent = cssNormal;
                    }
                }

                if (that.base.template !== "default" && that.base.template !== "") {
                    cssCurrent += " " + "jqx-" + that.base.template;
                    if (that.base.theme != "") {
                        cssCurrent += " " + "jqx-" + that.template + "-" + that.base.theme;
                    }
                }

                if (that.base.buttonObj.hasClass(cssDisabled) && cssDisabled != cssCurrent) {
                    that.base.buttonObj.removeClass(cssDisabled);
                }

                if (that.base.buttonObj.hasClass(cssNormal) && cssNormal != cssCurrent) {
                    that.base.buttonObj.removeClass(cssNormal);
                }

                if (that.base.buttonObj.hasClass(cssHover) && cssHover != cssCurrent) {
                    that.base.buttonObj.removeClass(cssHover);
                }

                if (that.base.buttonObj.hasClass(cssPressed) && cssPressed != cssCurrent) {
                    that.base.buttonObj.removeClass(cssPressed);
                }

                if (that.base.buttonObj.hasClass(cssPressedHover) && cssPressedHover != cssCurrent) {
                    that.base.buttonObj.removeClass(cssPressedHover);
                }

                if (!that.base.buttonObj.hasClass(cssCurrent)) {
                    that.base.buttonObj.addClass(cssCurrent);
                }
            },

            _topDocumentMouseupHandler: function (event) {
                var that = this;
                that.isPressed = false;
                that.refresh();
            }
        });
        //// End of ToggleButton

    })(jqxBaseFramework);
})();



/***/ }),

/***/ 5725:
/***/ (() => {

/* tslint:disable */
/* eslint-disable */
(function () {
    if (typeof document === 'undefined') {
        return;
    }

    (function ($) {

        $.jqx.jqxWidget("jqxCalendar", "", {});

        $.extend($.jqx._jqxCalendar.prototype, {
            defineInstance: function () {
                var settings = {
                    // enables or disables the Calendar control.
                    disabled: false,

                    // restricted dates
                    restrictedDates: new Array(),

                    // not available in this version.
                    multipleMonthRows: 1,

                    // not available in this version.
                    multipleMonthColumns: 1,

                    // Specifies the Calendar's minimum navigation date.
                    minDate: $.jqx._jqxDateTimeInput.getDateTime(new Date()),

                    // Specifies the Calendar's maximum navigation date.
                    maxDate: $.jqx._jqxDateTimeInput.getDateTime(new Date()),

                    min: new Date(1900, 0, 1),
                    max: new Date(2100, 0, 1),

                    navigationDelay: 400,
                    // Type: Number
                    // Default: 1
                    // Gets or sets the navigation step.
                    stepMonths: 1, // Number of months to step back/forward

                    // Type: Number
                    // Default: null
                    // Gets or sets the Calendar's width.
                    width: null,

                    // Type: height
                    // Default: null
                    // Gets or sets the Calendar's height.
                    height: null,

                    // Type: $.jqx._jqxDateTimeInput.getDateTime
                    // Default:  $.jqx._jqxDateTimeInput.getDateTime(new Date()), (Today)
                    // Gets or sets the Calendar's value.
                    value: $.jqx._jqxDateTimeInput.getDateTime(new Date()),

                    // Type: Number.
                    // Default: 0
                    // Gets or sets the first day of the week - Sunday : 0, Monday : 1, Tuesday : 2, Wednesday : 3, Thursday : 4, Friday : 5, Saturday : 6.
                    firstDayOfWeek: 0,

                    // Type: Boolean.
                    // Default: false.
                    // Shows or hides the week numbers.
                    showWeekNumbers: false,

                    // Type: Boolean.
                    // Default: true.
                    // Shows or hides the Day Names.
                    showDayNames: true,

                    // Type: Boolean
                    // Default: false
                    // Enables or disables the weekend highlight option.
                    enableWeekend: false,

                    // Type: Boolean
                    // Default: true
                    // Enables or disables the other month highlight.
                    enableOtherMonthDays: true,

                    // Type: Boolean
                    // Default: true
                    // Shows or hides the other month days.
                    showOtherMonthDays: true,

                    // Gets or sets the row header's width.
                    // Type: Number.
                    rowHeaderWidth: 25,

                    // Default: 20
                    // Gets or sets the column header's height.
                    // Type: Number.
                    columnHeaderHeight: 25,

                    // Default: 28
                    // Gets or sets the title's height.
                    // Type: Number.
                    titleHeight: 30,

                    // Type: String.
                    // Gets or sets the string format of the day names.
                    // Possible values: default, shortest, firstTwoLetters, firstLetter, full
                    dayNameFormat: 'firstTwoLetters',

                    monthNameFormat: 'default',

                    // Type: string.
                    // Represents the title format displayed between the navigation arrow.
                    titleFormat: ["MMMM yyyy", "yyyy", "yyyy", "yyyy"],
                    enableViews: true,
                    // Type: Boolean.
                    // Default: false
                    // Gets or sets the readonly state. In this state the user can navigate through the months, but is not allowed to select.
                    readOnly: false,

                    //Type: string
                    //Default: 'default'
                    //Gets or sets the calendar's culture.
                    culture: "default",

                    // Type: Boolean
                    // Default: true.
                    // Enables or disables the fast navigation when the user holds the mouse pressed over a navigation arrow.
                    enableFastNavigation: true,

                    // Type: Boolean
                    // Default: true
                    // Enables or disables the hover state.
                    enableHover: true,

                    // Type: Boolean
                    // Default: true
                    // When this property is true, click on other month date will automatically navigate to the previous or next month.
                    enableAutoNavigation: true,

                    // Type: Boolean
                    // Default: false
                    // enables or disabled the calendar tooltips.
                    enableTooltips: false,

                    // Type: String
                    // Back Button Text.
                    backText: "Back",
                    // Type: String
                    // Forward Button Text.
                    forwardText: "Forward",

                    // Type: Array
                    // Represents a collection of special calendar days.
                    specialDates: new Array(),
                    keyboardNavigation: true,
                    // Selects a range of dates.
                    selectionMode: 'default',
                    selectableDays: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"],
                    todayString: 'Today',
                    clearString: 'Clear',
                    showFooter: false,
                    selection: { from: null, to: null },
                    canRender: true,
                    _checkForHiddenParent: true,
                    //Type: Number.
                    //Default: 0.
                    //Sets height of the calendar in pixels.
                    height: null,
                    rtl: false,
                    // month, year, decade
                    view: 'month',
                    views: ['month', 'year', 'decade'],
                    changing: null,
                    change: null,
                    localization: {
                        backString: "Back",
                        forwardString: "Forward",
                        todayString: "Today",
                        clearString: "Clear",
                        calendar: {
                            name: "Gregorian_USEnglish",
                            "/": "/",
                            // separator of parts of a time (e.g. ":" in 05:44 PM)
                            ":": ":",
                            // the first day of the week (0 : Sunday, 1 : Monday, etc)
                            firstDay: 0,
                            days: {
                                // full day names
                                names: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"],
                                // abbreviated day names
                                namesAbbr: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
                                // shortest day names
                                namesShort: ["Su", "Mo", "Tu", "We", "Th", "Fr", "Sa"]
                            },
                            months: {
                                // full month names (13 months for lunar calendards -- 13th month should be "" if not lunar)
                                names: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December", ""],
                                // abbreviated month names
                                namesAbbr: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", ""]
                            },
                            // AM and PM designators in one of these forms:
                            // The usual view, and the upper and lower case versions
                            //      [standard,lowercase,uppercase]
                            // The culture does not use AM or PM (likely all standard date formats use 24 hour time)
                            //      null
                            AM: ["AM", "am", "AM"],
                            PM: ["PM", "pm", "PM"],
                            eras: [
                                // eras in reverse chronological order.
                                // name: the name of the era in this culture (e.g. A.D., C.E.)
                                // start: when the era starts in ticks (gregorian, gmt), null if it is the earliest supported era.
                                // offset: offset in years from gregorian calendar
                                { "name": "A.D.", "start": null, "offset": 0 }
                            ],
                            twoDigitYearMax: 2029,
                            patterns: {
                                // short date pattern
                                d: "M/d/yyyy",
                                // long date pattern
                                D: "dddd, MMMM dd, yyyy",
                                // short time pattern
                                t: "h:mm tt",
                                // long time pattern
                                T: "h:mm:ss tt",
                                // long date, short time pattern
                                f: "dddd, MMMM dd, yyyy h:mm tt",
                                // long date, long time pattern
                                F: "dddd, MMMM dd, yyyy h:mm:ss tt",
                                // month/day pattern
                                M: "MMMM dd",
                                // month/year pattern
                                Y: "yyyy MMMM",
                                // S is a sortable format that does not vary by culture
                                S: "yyyy\u0027-\u0027MM\u0027-\u0027dd\u0027T\u0027HH\u0027:\u0027mm\u0027:\u0027ss",
                                // formatting of dates in MySQL DataBases
                                ISO: "yyyy-MM-dd hh:mm:ss"
                            }
                        }
                    },
                    // Calendar events.
                    events:
                        [
                            // occurs when the back button is clicked.
                            'backButtonClick',
                            // occurs when the forward button is clicked.
                            'nextButtonClick',
                            // occurs when the value is changed.
                            'valuechanged',
                            // occurs when the user clicks a cell.
                            'cellMouseDown',
                            // occurs when the user clicks a cell but is still holding the mouse key pressed.
                            'cellMouseUp',
                            // occurs when the user selects a cell.
                            'cellSelected',
                            // occurs when a cell is unselected. For example: user selects a cell and then selects another cell. The first selected cell is unselected.
                            'cellUnselected',
                            // occurs when the date is changed.
                            'change',
                            // occurs when the view is changed.
                            'viewChange'
                        ]
                };
                if (this === $.jqx._jqxCalendar.prototype) {
                    return settings;
                }
                $.extend(true, this, settings);

                this.minDate._setYear(1900);
                this.minDate._setMonth(1);
                this.minDate._setDay(1);
                this.minDate._setHours(0);
                this.minDate._setMinutes(0);
                this.minDate._setSeconds(0);
                this.minDate._setMilliseconds(0);
                this.maxDate._setYear(2100);
                this.maxDate._setMonth(1);
                this.maxDate._setDay(1);
                this.maxDate._setHours(0);
                this.maxDate._setMinutes(0);
                this.maxDate._setSeconds(0);
                this.maxDate._setMilliseconds(0);

                this.value._setHours(0);
                this.value._setMinutes(0);
                this.value._setSeconds(0);
                this.value._setMilliseconds(0);
                return settings;
            },

            _createFromInput: function (name) {
                var that = this;
                if (that.element.nodeName.toLowerCase() == "input") {
                    that.field = that.element;
                    if (that.field.className) {
                        that._className = that.field.className;
                    }

                    var properties = {
                        'title': that.field.title
                    };

                    if (that.field.value) {
                        properties.value = that.field.value;
                    }
                    if (that.field.checked) {
                        properties.checked = true;
                    }
                    if (that.field.id.length) {
                        properties.id = that.field.id.replace(/[^\w]/g, '_') + "_" + name;
                    }
                    else {
                        properties.id = $.jqx.utilities.createId() + "_" + name;
                    }
                    if (that.field.getAttribute('min')) {
                        var min = new Date(that.field.getAttribute('min'));
                        if (min != "Invalid Date") that.min = min;
                    }
                    if (that.field.getAttribute('max')) {
                        var max = new Date(that.field.getAttribute('max'));
                        if (max != "Invalid Date") that.max = max;
                    }
                    var wrapper = $("<div></div>", properties);
                    wrapper[0].style.cssText = that.field.style.cssText;
                    if (!that.width) {
                        that.width = $(that.field).width();
                    }
                    if (!that.height) {
                        that.height = $(that.field).outerHeight();
                    }
                    $(that.field).hide().after(wrapper);
                    var data = that.host.data();
                    that.host = wrapper;
                    that.host.data(data);
                    that.element = wrapper[0];
                    that.element.id = that.field.id;
                    that.field.id = properties.id;
                    if (that._className) {
                        that.host.addClass(that._className);
                        $(that.field).removeClass(that._className);
                    }

                    if (that.field.tabIndex) {
                        var tabIndex = that.field.tabIndex;
                        that.field.tabIndex = -1;
                        that.element.tabIndex = tabIndex;
                    }
                }
            },

            createInstance: function (args) {
                var that = this;
                that._createFromInput("jqxCalendar");

                if (that.isMaterialized()) {
                    var elementStyle = window.getComputedStyle(this.element);
                    var titleHeight = elementStyle.getPropertyValue('--jqx-calendar-title-height');
                    var columnHeaderHeight = elementStyle.getPropertyValue('--jqx-calendar-column-header-height');

                    if (titleHeight) {
                        this.titleHeight = parseInt(titleHeight);
                    }

                    if (columnHeaderHeight) {
                        this.columnHeaderHeight = parseInt(columnHeaderHeight);
                    }

                    if (this.theme === 'fluent') {
                        this.navigationDelay = 0;
                    }

                    setTimeout(function () {
                        that.refreshControl();
                    }, 200)
                }
                this.setCalendarSize();
                if (this.element.id === "") {
                    this.element.id = $.jqx.utilities.createId();
                }
                if ($.type(this.value) == "date") {
                    this.value = $.jqx._jqxDateTimeInput.getDateTime(this.value);
                }

                this.element.innerHTML = "";
                this.host.attr('data-role', 'calendar');
                var id = this.element.id;
                var me = this;
                this.propertyChangeMap['width'] = function (instance, key, oldVal, value) {
                    me.setCalendarSize();
                };

                this.propertyChangeMap['height'] = function (instance, key, oldVal, value) {
                    me.setCalendarSize();
                };

                if ($.global) {
                    $.global.preferCulture(this.culture);
                }

                if (this.culture != 'default') {
                    if ($.global) {
                        $.global.preferCulture(this.culture);
                        this.localization.calendar = $.global.culture.calendar;
                    }
                    else if (window.Globalize) {
                        var culture = window.Globalize.culture(this.culture);
                        this.localization.calendar = culture.calendar;
                    }
                    this.firstDayOfWeek = this.localization.calendar.firstDay;
                }
                if (this.localization.backString != "Back") {
                    this.backText = this.localization.backString;
                }
                if (this.localization.forwardString != "Forward") {
                    this.forwardText = this.localization.forwardString;
                }
                if (this.localization.todayString != "Today" && this.localization.todayString) {
                    this.todayString = this.localization.todayString;
                }
                if (this.localization.clearString != "Clear" && this.localization.clearString) {
                    this.clearString = this.localization.clearString;
                }
                if (this.localization.calendar && this.localization.calendar.firstDay != undefined && this.culture != "default") {
                    this.firstDayOfWeek = this.localization.calendar.firstDay;
                }

                this.setMaxDate(this.max, false);
                this.setMinDate(this.min, false);

                if (!this.host.attr('tabIndex')) {
                    this.host.attr('tabIndex', 0);
                }

                this.host.css('outline', 'none');
                this.host.addClass(this.toThemeProperty("jqx-calendar"));
                this.host.addClass(this.toThemeProperty("jqx-widget"));
                this.host.addClass(this.toThemeProperty("jqx-widget-content"));
                this.host.addClass(this.toThemeProperty("jqx-rc-all"));
                this._addInput();

                if (this.views.indexOf('month') == -1) this.view = "year";
                if (this.views.indexOf('year') == -1 && this.views.indexOf('month') == -1) this.view = "decade";

                this.addHandler(this.host, 'keydown',
                    function (event) {
                        var result = true;
                        if (me.keyboardNavigation) {
                            if (me._handleKey != undefined) {
                                result = me._handleKey(event);
                                if (!result) {
                                    if (event.stopPropagation) event.stopPropagation();
                                    if (event.preventDefault) event.preventDefault();
                                }
                            }
                        }
                        return result;
                    });

                var loaded = false;
                var myCalendar = this;

                var percentageSize = false;

                if (me.width != null && me.width.toString().indexOf("%") != -1) {
                    percentageSize = true;
                }

                if (me.height != null && me.height.toString().indexOf("%") != -1) {
                    percentageSize = true;
                }

                $.jqx.utilities.resize(this.host, function () {
                    var month = myCalendar.host.find("#View" + me.element.id);
                    if (!loaded) {
                        loaded = true;
                        myCalendar.render();
                    }
                    else myCalendar.refreshTitle(month);

                    if (percentageSize) {
                        if (me.refreshTimer) {
                            clearTimeout(me.refreshTimer);
                        }

                        me.refreshTimer = setTimeout(function () {
                            me.refreshControl();
                        }, 1);
                    }
                }, false, this._checkForHiddenParent);

                var calendarID = 'View';
                this.propertyChangeMap['disabled'] = function (instance, key, oldVal, value) {
                    if (value) {
                        instance.host.addClass(me.toThemeProperty('jqx-fill-state-disabled'));
                    }
                    else {
                        instance.host.removeClass(me.toThemeProperty('jqx-fill-state-disabled'));
                    }
                    me.refreshControl();
                }
            },

            _addInput: function () {
                var name = this.host.attr('name');
                this.input = $("<input type='hidden'/>");
                this.host.append(this.input);
                if (name) {
                    this.input.attr('name', name);
                }
                this.input.val(this.getDate().toString());
            },

            setCalendarSize: function () {
                if (this.width != null && this.width.toString().indexOf("px") != -1) {
                    this.host.width(this.width);
                }
                else
                    if (this.width != undefined && !isNaN(this.width)) {
                        this.host.width(this.width);
                    }

                if (this.width != null && this.width.toString().indexOf("%") != -1) {
                    this.host.css('width', this.width);
                }

                if (this.height != null && this.height.toString().indexOf("px") != -1) {
                    this.host.height(this.height);
                }
                else if (this.height != undefined && !isNaN(this.height)) {
                    this.host.height(this.height);
                };

                if (this.height != null && this.height.toString().indexOf("%") != -1) {
                    this.host.css('height', this.height);
                }
            },

            _getYearAndMonthPart: function (date) {
                if (!date) {
                    return new Date(1900, 0, 1);
                }
                var newDate = new Date(date.getFullYear(), date.getMonth(), 1);
                return newDate;
            },

            _handleKey: function (event) {
                if (this.readOnly)
                    return true;

                var key = event.keyCode;
                var me = this;
                var selectedDate = this._getSelectedDate();
                if (selectedDate == undefined) {
                    if (this.view == "month" && (key == 37 || key == 38 || key == 39 || key == 40)) {
                        this.selectedDate = new Date(this.value.year, this.value.month - 1, 1);
                        this._selectDate(this.selectedDate, 'key');
                        selectedDate = this.selectedDate;
                    }
                    else {
                        return true;
                    }
                }

                if (event.altKey) {
                    return true;
                }

                if (this._animating)
                    return false;

                if (this.view != "month" && key == 13) {
                    var cell = this._getSelectedCell();
                    this._setDateAndSwitchViews(cell, event, "keyboard");
                }

                if (this.view == "year") {
                    var month = selectedDate.getMonth();
                    var minDate = this._getYearAndMonthPart(this.getMinDate());
                    var maxDate = this._getYearAndMonthPart(this.getMaxDate());

                    switch (key) {
                        case 37:
                            // previous
                            if (month == 0) {
                                var newDate = new Date(selectedDate.getFullYear() - 1, 11, 1);
                                if (newDate >= minDate) {
                                    this.selectedDate = newDate;
                                    this.navigateBackward();
                                }
                                else if (this.selectedDate != minDate) {
                                    this.selectedDate = minDate;
                                    this.navigateBackward();
                                }
                            }
                            else {
                                var newDate = new Date(selectedDate.getFullYear(), month - 1, 1)
                                if (newDate >= minDate) {
                                    this._selectDate(newDate, 'key');
                                }
                            }
                            return false;
                        case 38:
                            var newDate = new Date(selectedDate.getFullYear(), month - 4, 1);
                            if (newDate < minDate) {
                                newDate = minDate;
                            }

                            if (month - 4 < 0) {
                                this.selectedDate = newDate;
                                this.navigateBackward();
                            }
                            else {
                                this._selectDate(newDate, 'key');
                            }
                            return false;
                        case 40:
                            // down
                            var newDate = new Date(selectedDate.getFullYear(), month + 4, 1);
                            if (newDate > maxDate) {
                                newDate = maxDate;
                            }

                            if (month + 4 > 11) {
                                this.selectedDate = newDate;
                                this.navigateForward();
                            }
                            else {
                                this._selectDate(newDate, 'key');
                            }

                            return false;
                        case 39:
                            if (month == 11) {
                                var newDate = new Date(selectedDate.getFullYear() + 1, 0, 1);
                                if (newDate <= maxDate) {
                                    this.selectedDate = newDate;
                                    this.navigateForward();
                                }
                                else {
                                    if (this.selectedDate != maxDate) {
                                        this.selectedDate = maxDate;
                                        this.navigateForward();
                                    }
                                }
                            }
                            else {
                                var newDate = new Date(selectedDate.getFullYear(), month + 1, 1);
                                if (newDate <= maxDate) {
                                    this._selectDate(newDate, 'key');
                                }
                            }
                            // next
                            return false;
                    }
                    return true;
                }

                if (this.view == "decade") {
                    var startYear = this._renderStartDate.getFullYear();
                    var endYear = this._renderEndDate.getFullYear();
                    var fullYear = selectedDate.getFullYear();
                    var minYear = this.getMinDate().getFullYear();
                    var maxYear = this.getMaxDate().getFullYear();

                    switch (key) {
                        case 37:
                            // previous
                            if (fullYear - 1 >= minYear) {
                                if (fullYear <= startYear) {
                                    this.selectedDate = new Date(fullYear - 1, selectedDate.getMonth(), 1);
                                    this.navigateBackward();
                                }
                                else {
                                    this._selectDate(new Date(fullYear - 1, selectedDate.getMonth(), 1), 'key');
                                }
                            }
                            return false;
                        case 38:
                            // up
                            var newYear = fullYear - 4;
                            if (fullYear - 4 < minYear) newYear = minYear;

                            if (newYear < startYear) {
                                this.selectedDate = new Date(newYear, selectedDate.getMonth(), 1);
                                this.navigateBackward();
                            }
                            else {
                                this._selectDate(new Date(newYear, selectedDate.getMonth(), 1), 'key');
                            }
                            return false;
                        case 40:
                            // down
                            var newYear = fullYear + 4;
                            if (newYear > maxYear) newYear = maxYear;

                            if (newYear > endYear) {
                                this.selectedDate = new Date(newYear, selectedDate.getMonth(), 1);
                                this.navigateForward();
                            }
                            else {
                                this._selectDate(new Date(newYear, selectedDate.getMonth(), 1), 'key');
                            }

                            return false;
                        case 39:
                            // next
                            if (fullYear + 1 <= maxYear) {
                                if (fullYear == endYear) {
                                    this.selectedDate = new Date(fullYear + 1, selectedDate.getMonth(), 1);
                                    this.navigateForward();
                                }
                                else {
                                    this._selectDate(new Date(fullYear + 1, selectedDate.getMonth(), 1), 'key');
                                }
                            }
                            return false;
                    }

                    return true;
                }

                var date = new $.jqx._jqxDateTimeInput.getDateTime(selectedDate);
                var start = this.getViewStart();
                var end = this.getViewEnd();
                var oldDate = date;
                var monthInstance = $.data(this.element, "View" + this.element.id);
                if (monthInstance == undefined || monthInstance == null)
                    return true;

                if (key == 36) {
                    date._setDay(1);
                    if (this._isDisabled(date.dateTime)) {
                        return false;
                    }

                    this._selectDate(date.dateTime, 'key');
                    return false;
                }

                if (key == 35) {
                    var maxDays = this.value._daysInMonth(this.value.year, this.value.month);
                    date._setDay(maxDays);
                    if (this._isDisabled(date.dateTime)) {
                        return false;
                    }

                    this._selectDate(date.dateTime, 'key');
                    return false;
                }

                var step = 1;
                if (event.ctrlKey) step = 12;
                if (key == 34) {
                    var res = this.navigateForward(step);
                    if (res) {
                        date._addMonths(step);
                        if (this._isDisabled(date.dateTime)) {
                            return false;
                        }

                        this._selectDate(date.dateTime, 'key');
                    }
                    return false;
                }

                if (key == 33) {
                    var res = this.navigateBackward(step);
                    if (res) {
                        date._addMonths(-step);
                        if (this._isDisabled(date.dateTime)) {
                            return false;
                        }

                        this._selectDate(date.dateTime, 'key');
                    }
                    return false;
                }

                if (key == 38) {
                    date._addDays(-7);
                    if (date.dateTime < this.getMinDate())
                        return false;

                    if (date.dateTime < start) {
                        var res = this.navigateBackward();
                        if (!res)
                            return false;
                    }
                    if (this._isDisabled(date.dateTime)) {
                        return false;
                    }

                    this._selectDate(date.dateTime, 'key');
                    for (var i = 0; i < monthInstance.cells.length; i++) {
                        var cell = monthInstance.cells[i];
                        var cellDate = cell.getDate();
                        if (cell.isOtherMonth && cell.isSelected && cellDate <= date.dateTime) {
                            this.value.day = cellDate.getDate();
                            this.navigateBackward();
                            this._selectDate(date.dateTime, 'key');
                            break;
                        }
                    }
                    return false;
                }
                else if (key == 40) {
                    date._addDays(7);
                    if (date.dateTime > this.getMaxDate())
                        return false;

                    if (date.dateTime > end) {
                        var res = this.navigateForward();
                        if (!res)
                            return false;
                    }
                    if (this._isDisabled(date.dateTime)) {
                        return false;
                    }

                    this._selectDate(date.dateTime, 'key');
                    for (var i = 0; i < monthInstance.cells.length; i++) {
                        var cell = monthInstance.cells[i];
                        var cellDate = cell.getDate();
                        if (cell.isOtherMonth && cell.isSelected && cellDate >= date.dateTime) {
                            this.value.day = cellDate.getDate();
                            this.navigateForward();
                            this._selectDate(date.dateTime, 'key');
                            break;
                        }
                    }

                    return false;
                }

                if (key == 37) {
                    date._addDays(-1);
                    if (date.dateTime < this.getMinDate()) {
                        return false;
                    }

                    if (date.dateTime < start) {
                        var res = this.navigateBackward();
                        if (!res)
                            return false;
                    }
                    if (this._isDisabled(date.dateTime)) {
                        return false;
                    }

                    this._selectDate(date.dateTime, 'key');
                    for (var i = 0; i < monthInstance.cells.length; i++) {
                        var cell = monthInstance.cells[i];
                        var cellDate = cell.getDate();
                        if (cell.isOtherMonth && cell.isSelected && cellDate <= date.dateTime) {
                            if (date.dateTime < this.getMinDate() || date.dateTime > this.getMaxDate()) {
                                return false;
                            }
                            if (this._isDisabled(date.dateTime)) {
                                return false;
                            }

                            this.navigateBackward();
                            this._selectDate(date.dateTime, 'key');
                            break;
                        }
                    }

                    return false;
                }
                else if (key == 39) {
                    date._addDays(1);
                    if (date.dateTime > this.getMaxDate()) {
                        return false;
                    }

                    if (date.dateTime > end) {
                        var res = this.navigateForward();
                        if (!res)
                            return false;
                    }
                    if (this._isDisabled(date.dateTime)) {
                        return false;
                    }

                    this._selectDate(date.dateTime, 'key');
                    for (var i = 0; i < monthInstance.cells.length; i++) {
                        var cell = monthInstance.cells[i];
                        var cellDate = cell.getDate();
                        if (cell.isOtherMonth && cell.isSelected && cellDate >= date.dateTime) {
                            if (date.dateTime < this.getMinDate() || date.dateTime > this.getMaxDate()) {
                                return false;
                            }

                            this.navigateForward();
                            this._selectDate(date.dateTime, 'key');
                            break;
                        }
                    }
                    return false;
                }

                return true;
            },

            render: function () {
                if (!this.canRender) return;

                this.host.children().remove();
                var month = this._renderSingleCalendar("View" + this.element.id);
                var me = this;
                this.host.append(month);
            },

            // adds a special date to the calendar.
            // @param - Date.
            // @param - css class name(optional).
            // @param - string for the special date's tooltip(optional).
            addSpecialDate: function (date, className, tooltipContent) {
                if (this.multipleMonthRows == 1 && this.multipleMonthColumns == 1) {
                    var specialDatesLength = this.specialDates.length;
                    this.specialDates[specialDatesLength] = { Date: date, Class: className, Tooltip: tooltipContent };

                    this.refreshControl();
                }
            },

            refresh: function (initialRefresh) {
                var that = this;

                this.render();

                setTimeout(function () {
                    that.refreshControl();
                });
            },

            invalidate: function () {
                this.refreshControl();
            },

            refreshControl: function () {
                if (this.multipleMonthRows == 1 && this.multipleMonthColumns == 1) {
                    this.refreshSingleCalendar("View" + this.element.id, null);
                }
            },

            // gets the view's start date.
            getViewStart: function () {
                var visibleDate = this.getVisibleDate();
                var firstDay = this.getFirstDayOfWeek(visibleDate);
                return firstDay.dateTime;
            },

            // gets the view's end date.
            getViewEnd: function () {
                var start = this.getViewStart();
                var end = new $.jqx._jqxDateTimeInput.getDateTime(start);
                end._addDays(41);
                return end.dateTime;
            },

            refreshSingleCalendar: function (calendarID, parent) {
                if (!this.canRender) return;
                var month = this.host.find("#" + calendarID);
                var visibleDate = this.getVisibleDate();
                var firstDay = this.getFirstDayOfWeek(visibleDate);

                this.refreshCalendarCells(month, firstDay, calendarID);
                this.refreshTitle(month);
                this.refreshRowHeader(month, calendarID);
                if (this.selectedDate != undefined) {
                    this._selectDate(this.selectedDate);
                }

                var topPadding = parseInt(this.month.css('padding-top'));
                var h = this.host.height() - 2 * topPadding;

                var contentHeight = h - this.titleHeight - this.columnHeaderHeight;
                if (!this.showDayNames) {
                    contentHeight = this.month.height() - this.titleHeight;
                }
                if (this.showFooter) {
                    contentHeight -= 20;
                }

                var cellsTableElement = month.find("#cellsTable" + calendarID);
                var rowHeaderElement = month.find("#calendarRowHeader" + calendarID);
                cellsTableElement.height(contentHeight);
                rowHeaderElement.height(contentHeight);
            },

            refreshRowHeader: function (month, calendarID) {
                if (!this.showWeekNumbers)
                    return;

                var visibleDate = this.getVisibleDate();
                var firstDay = this.getFirstDayOfWeek(visibleDate);
                var dayOfWeek = firstDay.dayOfWeek;
                var weekOfYear = this.getWeekOfYear(firstDay);
                var newDate = new $.jqx._jqxDateTimeInput.getDateTime(new Date(firstDay.dateTime));
                newDate._addDays(5);
                newDate.dayOfWeek = newDate.dateTime.getDay();
                var newWeekOfYear = this.getWeekOfYear(newDate);

                var rowHeader = this.rowHeader.find('table');

                rowHeader.width(this.rowHeaderWidth);
                //   month.find("#calendarRowHeader" + month[0].id).append(rowHeader);
                var currentDate = firstDay;
                var rowHeaderCells = new Array();

                for (var i = 0; i < 6; i++) {
                    var weekString = weekOfYear.toString();
                    var cell = new $.jqx._jqxCalendar.cell(currentDate.dateTime);
                    var cellID = i + 1 + this.element.id;
                    var cellElement = $(rowHeader[0].rows[i].cells[0]);
                    cell.element = cellElement;
                    cell.row = i;
                    cell.column = 0;
                    var cellContent = cellElement.find("#headerCellContent" + cellID);
                    cellContent.addClass(this.toThemeProperty('jqx-calendar-row-cell'));
                    cellContent[0].innerHTML = weekOfYear;
                    rowHeaderCells[i] = cell;
                    currentDate = new $.jqx._jqxDateTimeInput.getDateTime(new Date(currentDate._addWeeks(1)));
                    weekOfYear = this.getWeekOfYear(currentDate);
                }

                var monthInstance = $.data(this.element, month[0].id);
                monthInstance.rowCells = rowHeaderCells;
                this._refreshOtherMonthRows(monthInstance, calendarID);
            },

            _refreshOtherMonthRows: function (month, calendarID) {
                if (this.showOtherMonthDays)
                    return;

                this._displayLastRow(true, calendarID);
                this._displayFirstRow(true, calendarID);

                var canDisplayFirstRow = false;
                var canDisplayLastRow = false;

                for (var i = 0; i < month.cells.length; i++) {
                    var cell = month.cells[i];
                    if (cell.isVisible && i < 7) {
                        canDisplayFirstRow = true;
                    }
                    else if (cell.isVisible && i >= month.cells.length - 7) {
                        canDisplayLastRow = true;
                    }
                }

                if (!canDisplayFirstRow) {
                    this._displayFirstRow(false, calendarID);
                }

                if (!canDisplayLastRow) {
                    this._displayLastRow(false, calendarID);
                }
            },

            _displayLastRow: function (show, calendarID) {
                var month = this.host.find("#" + calendarID);
                var calendarRowHeader = month.find("#calendarRowHeader" + month[0].id).find('table');
                var lastRow = null;
                if (this.showWeekNumbers) {
                    if (calendarRowHeader[0].cells) {
                        var lastRow = $(calendarRowHeader[0].rows[5]);
                    }
                }
                var lastMonthRow = $(month.find("#cellTable" + month[0].id)[0].rows[5]);
                if (show) {
                    if (this.showWeekNumbers && lastRow) {
                        lastRow.css('display', 'table-row');
                    }
                    lastMonthRow.css('display', 'table-row');
                }
                else {
                    if (this.showWeekNumbers && lastRow) {
                        lastRow.css('display', 'none');
                    }
                    lastMonthRow.css('display', 'none');
                }
            },

            _displayFirstRow: function (show, calendarID) {
                var month = this.host.find("#" + calendarID);
                var calendarRowHeader = month.find("#calendarRowHeader" + month[0].id).find('table');
                var firstRow = null;
                if (this.showWeekNumbers) {
                    if (calendarRowHeader[0].cells) {
                        var firstRow = $(calendarRowHeader[0].rows[0]);
                    }
                }
                var firstMonthRow = $(month.find("#cellTable" + month[0].id)[0].rows[0]);

                if (show) {
                    if (this.showWeekNumbers && firstRow) {
                        firstRow.css('display', 'table-row');
                    }
                    firstMonthRow.css('display', 'table-row');
                }
                else {
                    if (this.showWeekNumbers && firstRow) {
                        firstRow.css('display', 'none');
                    }
                    firstMonthRow.css('display', 'none');
                }
            },

            _renderSingleCalendar: function (calendarID, parent) {
                if (!this.canRender) return;

                var oldMonthElement = this.host.find("#" + calendarID.toString());
                if (oldMonthElement != null) {
                    oldMonthElement.remove();
                }

                var month = $("<div id='" + calendarID.toString() + "'></div>");

                var visibleDate = this.getVisibleDate();
                var firstDay = this.getFirstDayOfWeek(visibleDate);
                var endDay = new $.jqx._jqxDateTimeInput.getDateTime(firstDay.dateTime);
                endDay._addMonths(1);

                var monthInstance = $.jqx._jqxCalendar.monthView(firstDay, endDay, null, null, null, month);

                if (parent == undefined || parent == null) {
                    this.host.append(month);

                    month[0].style.width = "100%";
                    month[0].style.height = "100%";
                }
                else parent.append(month);

                $.data(this.element, calendarID, monthInstance);

                var topPadding = parseInt(month.css('padding-top'));
                var h = this.host.height() - 2 * topPadding;

                var contentHeight = h - this.titleHeight - this.columnHeaderHeight;
                if (!this.showDayNames) {
                    contentHeight = h - this.titleHeight;
                }
                if (this.showFooter) {
                    contentHeight -= 20;
                }

                if (this.rowHeaderWidth < 0) this.rowHeaderWidth = 0;
                if (this.columnHeaderHeight < 0) this.columnHeaderHeight = 0;
                if (this.titleHeight < 0) this.titleHeight = 0;

                var rowHeaderWidth = this.rowHeaderWidth;
                var columnHeaderHeight = this.columnHeaderHeight;

                if (!this.showWeekNumbers) {
                    rowHeaderWidth = 0;
                }

                if (!this.showDayNames) {
                    columnHeaderHeight = 0;
                }


                var title = "<div style='height:" + this.titleHeight + "px;'><table role='grid' style='margin: 0px; width: 100%; height: 100%; border-spacing: 0px;' cellspacing='0' cellpadding='0'><tr role='row' id='calendarTitle' width='100%'>" +
                    "<td role='gridcell' NOWRAP id='leftNavigationArrow'></td>" + "<td aria-live='assertive' aria-atomic='true' role='gridcell' align='center' NOWRAP id='calendarTitleHeader'></td>" + "<td role='gridcell' NOWRAP id='rightNavigationArrow'></td>" +
                    "</tr></table></div>";

                var monthStructure = "<table role='grid' class='" + this.toThemeProperty('jqx-calendar-month') + "' style='margin: 0px; border-spacing: 0px;' cellspacing='0' cellpadding='0'>" +
                    "<tr role='row' id='calendarHeader' height='" + columnHeaderHeight + "'>" +
                    "<td role='gridcell' id='selectCell' width='" + rowHeaderWidth + "'></td>" + "<td role='gridcell' colspan='2' style='border: none; padding-left: 2px; padding-right: 2px' id='calendarColumnHeader'></td>" +
                    "</tr>" +
                    "<tr role='row' id='calendarContent'>" +
                    "<td role='gridcell' id='calendarRowHeader' valign='top' height='" + contentHeight + "' width='" + rowHeaderWidth + "'></td>" + "<td role='gridcell' valign='top' colspan='2' style='padding-left: 2px; padding-right: 2px' id='cellsTable' height='" + contentHeight + "'></td>" +
                    "</tr>" +
                    "</table>"

                var footer = "<div id='footer' style='margin: 0px; display: none; height:" + footerHeight + "px;'><table style='width: 100%; height: 100%; border-spacing: 0px;' cellspacing='0' cellpadding='0'>" +
                    "<tr id='calendarFooter'>" +
                    "<td align='right' id='todayButton'></td>" + "<td align='left' colspan='2' id=doneButton></td>" +
                    "</tr>" + "</table></div>";


                month[0].innerHTML = title + monthStructure + footer;
                this.header = month.find('#calendarHeader');
                this.header[0].id = 'calendarHeader' + calendarID;
                this.header.addClass(this.toThemeProperty('calendar-header'));
                this.columnHeader = month.find('#calendarColumnHeader');
                this.columnHeader[0].id = 'calendarColumnHeader' + calendarID;
                this.table = month.find('#cellsTable');
                this.table[0].id = 'cellsTable' + calendarID;
                this.rowHeader = month.find('#calendarRowHeader');
                this.rowHeader[0].id = 'calendarRowHeader' + calendarID;
                this.selectCell = month.find('#selectCell');
                this.selectCell[0].id = 'selectCell' + calendarID;
                this.title = month.find('#calendarTitle');
                this.title[0].id = 'calendarTitle' + calendarID;
                this.leftButton = month.find('#leftNavigationArrow');
                this.leftButton[0].id = 'leftNavigationArrow' + calendarID;
                this.titleHeader = month.find('#calendarTitleHeader');
                this.titleHeader[0].id = 'calendarTitleHeader' + calendarID;
                this.rightButton = month.find('#rightNavigationArrow');
                this.rightButton[0].id = 'rightNavigationArrow' + calendarID;
                this.footer = month.find('#calendarFooter');
                this._footer = month.find('#footer');
                this._footer[0].id = 'footer' + calendarID
                this.footer[0].id = 'calendarFooter' + calendarID;
                this.todayButton = month.find('#todayButton');
                this.todayButton[0].id = 'todayButton' + calendarID;
                this.doneButton = month.find('#doneButton');
                this.doneButton[0].id = 'doneButton' + calendarID;

                this.title.addClass(this.toThemeProperty('jqx-calendar-title-container'));
                var footerHeight = 20;

                if (this.showFooter) {
                    this._footer.css('display', 'block');
                }

                //  month.find('td').css({ padding: 0, margin: 0, border: 'none' });
                month.find('tr').addClass(this.toThemeProperty('jqx-reset'));
                month.addClass(this.toThemeProperty("jqx-widget-content"));
                month.addClass(this.toThemeProperty("jqx-calendar-month-container"));
                this.month = month;
                this.selectCell.addClass(this.toThemeProperty('jqx-reset'));
                this.selectCell.addClass(this.toThemeProperty('jqx-calendar-top-left-header'));

                if (this.showWeekNumbers) {
                    this._renderRowHeader(month);
                }
                else {
                    this.table[0].colSpan = 3;
                    this.columnHeader[0].colSpan = 3;
                    this.rowHeader.css('display', 'none');
                    this.selectCell.css('display', 'none');
                }

                if (this.showFooter) {
                    this.footer.height(20);
                    var todayLink = $("<a href='javascript:;'>" + this.todayString + "</a>");
                    todayLink.appendTo(this.todayButton);
                    var clearLink = $("<a href='javascript:;'>" + this.clearString + "</a>");
                    clearLink.appendTo(this.doneButton);
                    clearLink.addClass(this.toThemeProperty('jqx-calendar-footer'));
                    todayLink.addClass(this.toThemeProperty('jqx-calendar-footer'));
                    var self = this;

                    var eventName = "mousedown";
                    if ($.jqx.mobile.isTouchDevice()) {
                        eventName = $.jqx.mobile.getTouchEventName('touchstart');
                    }

                    this.addHandler(todayLink, eventName, function () {
                        if (self.today) {
                            self.today();
                        }
                        else {
                            self.setDate(new Date(), 'mouse');
                        }
                        return false;
                    });
                    this.addHandler(clearLink, eventName, function () {
                        if (self.clear) {
                            self.clear();
                        }
                        else {
                            self.setDate(null, 'mouse');
                        }
                        return false;
                    });
                }

                if (this.view != "month") {
                    this.header.hide();
                }

                if (this.showDayNames && this.view == "month") {
                    this.renderColumnHeader(month);
                }

                this.oldView = this.view;
                this.renderCalendarCells(month, firstDay, calendarID)
                if (parent == undefined || parent == null) {
                    this.renderTitle(month);
                }
                this._refreshOtherMonthRows(monthInstance, calendarID);
                month.find('tbody').css({ border: 'none', background: 'transparent' });
                if (this.selectedDate != undefined) {
                    this._selectDate(this.selectedDate);
                }

                var me = this;
                this.addHandler(this.host, 'focus', function () {
                    me.focus();
                });

                return month;
            },

            _getTitleFormat: function () {
                switch (this.view) {
                    case 'month':
                        return this.titleFormat[0];
                    case 'year':
                        return this.titleFormat[1];
                    case 'decade':
                        return this.titleFormat[2];
                    case 'centuries':
                        return this.titleFormat[3];
                }
            },

            renderTitle: function (month) {
                var leftArrow = $("<div role='button' style='float: left;'></div>");
                var rightArrow = $("<div role='button' style='float: right;'></div>");
                var titleElement = this.title;
                titleElement.addClass(this.toThemeProperty("jqx-reset"));
                titleElement.addClass(this.toThemeProperty("jqx-widget-header"));
                titleElement.addClass(this.toThemeProperty("jqx-calendar-title-header"));
                var titleCells = titleElement.find('td');

                if ($.jqx.browser.msie && $.jqx.browser.version < 8) {
                    if (titleCells.css('background-color') != 'transparent') {
                        var bgColor = titleElement.css('background-color');
                        titleCells.css('background-color', bgColor);
                    }
                    if (titleCells.css('background-image') != 'transparent') {
                        var bgImage = titleElement.css('background-image');
                        var bgRepeat = titleElement.css('background-repeat');
                        var bgPosition = titleElement.css('background-position');

                        titleCells.css('background-image', bgImage);
                        titleCells.css('background-repeat', bgRepeat);
                        titleCells.css('background-position', 'left center scroll');
                    }
                }
                else {
                    titleCells.css('background-color', 'transparent');
                }

                if (this.disabled) {
                    titleElement.addClass(this.toThemeProperty("jqx-calendar-title-header-disabled"));
                }

                leftArrow.addClass(this.toThemeProperty("jqx-calendar-title-navigation"));
                leftArrow.addClass(this.toThemeProperty("jqx-icon-arrow-left"));
                leftArrow[0].setAttribute('title', this.backText);
                leftArrow.appendTo(this.leftButton);
                var leftArrowElement = this.leftButton;

                rightArrow.addClass(this.toThemeProperty("jqx-calendar-title-navigation"));
                rightArrow.addClass(this.toThemeProperty("jqx-icon-arrow-right"));
                rightArrow.appendTo(this.rightButton);
                rightArrow[0].setAttribute('title', this.forwardText);
                var rightArrowElement = this.rightButton;

                if (this.enableTooltips) {
                    if ($(leftArrowElement).jqxTooltip) {
                        $(leftArrowElement).jqxTooltip({ name: this.element.id, position: 'mouse', theme: this.theme, content: this.backText });
                        $(rightArrowElement).jqxTooltip({ name: this.element.id, position: 'mouse', theme: this.theme, content: this.forwardText });
                    }
                }

                var titleHeader = this.titleHeader;
                var title = this._format(this.value.dateTime, this._getTitleFormat(), this.culture);
                if (this.view == "decade") {
                    var startText = this._format(this._renderStartDate, this._getTitleFormat(), this.culture);
                    var endText = this._format(this._renderEndDate, this._getTitleFormat(), this.culture);
                    title = startText + " - " + endText;
                }
                else if (this.view == "centuries") {
                    var startText = this._format(this._renderCenturyStartDate, this._getTitleFormat(), this.culture);
                    var endText = this._format(this._renderCenturyEndDate, this._getTitleFormat(), this.culture);
                    title = startText + " - " + endText;
                }

                var titleContent = $("<div style='background: transparent; margin: 0; padding: 0; border: none;'>" + title + "</div>");
                titleHeader.append(titleContent);
                titleContent.addClass(this.toThemeProperty('jqx-calendar-title-content'));

                var arrowWidth = parseInt(leftArrow.width());
                var headerWidth = month.width() - 2 * arrowWidth;
                var newContent = titleHeader.find(".jqx-calendar-title-content").width(headerWidth);

                $.data(leftArrow, 'navigateLeft', this);
                $.data(rightArrow, 'navigateRight', this);
                var isTouchDevice = $.jqx.mobile.isTouchDevice();

                if (!this.disabled) {
                    var me = this;
                    this.addHandler(titleHeader, 'mousedown',
                        function (event) {
                            if (me.enableViews) {
                                if (!me._viewAnimating && !me._animating) {
                                    var oldView = me.view;
                                    me.oldView = oldView;
                                    switch (me.view) {
                                        case 'month':
                                            me.view = "year";
                                            break;
                                        case 'year':
                                            me.view = "decade";
                                            break;
                                    }
                                    if (me.views.indexOf("year") == -1 && me.view == "year") {
                                        me.view = "decade";
                                    }
                                    if (me.views.indexOf("decade") == -1 && me.view == "decade") {
                                        me.view = oldView;
                                    }

                                    if (oldView != me.view) {
                                        var calendarID = "View" + me.element.id;
                                        var month = me.host.find("#" + calendarID);
                                        var visibleDate = me.getVisibleDate();
                                        var firstDay = me.getFirstDayOfWeek(visibleDate);
                                        me.renderCalendarCells(month, firstDay, calendarID, true);
                                        me.refreshTitle(month);
                                        me._raiseEvent('8');
                                    }
                                }
                                return false;
                            }
                        });

                    this.addHandler(leftArrow, 'mousedown',
                        function (event) {
                            if (!me._animating) {
                                $.data(leftArrow, 'navigateLeftRepeat', true);
                                var element = $.data(leftArrow, 'navigateLeft');
                                if (element.enableFastNavigation && !isTouchDevice) {
                                    element.startRepeat(element, leftArrow, true, me.navigationDelay + 200);
                                }
                                element.navigateBackward(me.stepMonths, 'arrow');
                                event.stopPropagation();
                                event.preventDefault();
                                return element._raiseEvent(0, event)
                            }
                            else return false;
                        });

                    this.addHandler(leftArrow, 'mouseup',
                        function (event) {
                            $.data(leftArrow, 'navigateLeftRepeat', false);
                        });

                    this.addHandler(leftArrow, 'mouseleave',
                        function (event) {
                            $.data(leftArrow, 'navigateLeftRepeat', false);
                        });

                    this.addHandler(rightArrow, 'mousedown',
                        function (event) {
                            if (!me._animating) {
                                $.data(rightArrow, 'navigateRightRepeat', true);
                                var element = $.data(rightArrow, 'navigateRight')

                                if (element.enableFastNavigation && !isTouchDevice) {
                                    element.startRepeat(element, rightArrow, false, me.navigationDelay + 200);
                                }
                                element.navigateForward(me.stepMonths, 'arrow');
                                event.stopPropagation();
                                event.preventDefault();
                                return element._raiseEvent(1, event)
                            }
                            else return false;
                        });

                    this.addHandler(rightArrow, 'mouseup',
                        function (event) {
                            $.data(rightArrow, 'navigateRightRepeat', false);
                        });

                    this.addHandler(rightArrow, 'mouseleave',
                        function (event) {
                            $.data(rightArrow, 'navigateRightRepeat', false);
                        });
                }
            },

            refreshTitle: function (month) {
                var title = this._format(this.value.dateTime, this._getTitleFormat(), this.culture);
                if (this.view == "decade") {
                    var startText = this._format(this._renderStartDate, this._getTitleFormat(), this.culture);
                    var endText = this._format(this._renderEndDate, this._getTitleFormat(), this.culture);
                    title = startText + " - " + endText;
                }
                else if (this.view == "centuries") {
                    var startText = this._format(this._renderCenturyStartDate, this._getTitleFormat(), this.culture);
                    var endText = this._format(this._renderCenturyEndDate, this._getTitleFormat(), this.culture);
                    title = startText + " - " + endText;
                }
                var titleHeader = this.titleHeader;
                if (this.titleHeader) {
                    var oldContent = titleHeader.find(".jqx-calendar-title-content");

                    var titleContent = $("<div style='background: transparent; margin: 0; padding: 0; border: none;'>" + title + "</div>");
                    titleHeader.append(titleContent);
                    titleContent.addClass(this.toThemeProperty('jqx-calendar-title-content'));

                    if (oldContent != null) {
                        oldContent.remove();
                    }
                }
            },

            startRepeat: function (element, navigationElement, isLeft, timeout) {
                var timeoutobj = window.setTimeout(function () {
                    var value = $.data(navigationElement, 'navigateLeftRepeat');
                    if (!isLeft) {
                        value = $.data(navigationElement, 'navigateRightRepeat');
                    }

                    if (value) {
                        if (timeout < 25) timeout = 25;

                        if (isLeft) {
                            element.navigateBackward(1, 'arrow');
                            element.startRepeat(element, navigationElement, true, timeout);
                        }
                        else {
                            element.navigateForward(1, 'arrow');
                            timeoutobj = element.startRepeat(element, navigationElement, false, timeout);
                        }
                    }
                    else {
                        window.clearTimeout(timeoutobj);
                        return;
                    }
                }, timeout);
            },

            // navigates (n) month(s) forward.
            // @param - Date
            navigateForward: function (step, type) {
                if (step == undefined || step == null) {
                    step = this.stepMonths;
                }
                var year = this.value.year;
                if (this.view == 'decade') {
                    year = this._renderStartDate.getFullYear() + 12;
                    if (this._renderEndDate.getFullYear() >= this.getMaxDate().getFullYear())
                        return;

                }
                else if (this.view == "year") {
                    year = this.value.year + 1;
                }
                else if (this.view == "centuries") {
                    year = this.value.year + 100;
                }

                if (this.view != "month") {
                    var maxYear = this.getMaxDate().getFullYear();
                    if (maxYear < year || year > maxYear) {
                        year = maxYear;
                    }
                    if (this.value.year == year) {
                        if (this.view === "decade") {
                            if (this.value.year > this._renderEndDate.getFullYear()) {
                                this.value.year = year;
                                this.value.month = 1;
                                this.value.day = 1;
                            }
                            else {
                                return;
                            }
                        }
                        else {
                            return;
                        }
                    }

                    this.value.year = year;
                    this.value.month = 1;
                    this.value.day = 1;
                }

                var day = this.value.day;
                var month = this.value.month;
                if (month + step <= 12) {
                    var maxDays = this.value._daysInMonth(this.value.year, this.value.month + step);
                    if (day > maxDays)
                        day = maxDays;
                }

                if (this.view == "month") {
                    var date = new Date(this.value.year, this.value.month - 1 + step, day);
                    if (type == 'arrow' && this.selectableDays.length == 7 && this.selectionMode != "range") {
                        this.selectedDate = new Date(this.value.year, this.value.month - 1 + step, 1);
                    }
                }
                else {
                    var date = new Date(this.value.year, this.value.month - 1, day)
                }

                return this.navigateTo(date);
            },

            // navigates (n) month(s) back.
            // @param - Number
            navigateBackward: function (step, type) {
                if (step == undefined || step == null) {
                    step = this.stepMonths;
                }

                var year = this.value.year;
                if (this.view == 'decade') {
                    year = this._renderStartDate.getFullYear() - 12;
                }
                else if (this.view == "year") {
                    year = this.value.year - 1;
                }
                else if (this.view == "centuries") {
                    year = this.value.year - 100;
                }

                if (this.view != "month") {
                    var minYear = this.getMinDate().getFullYear();
                    if (year < minYear) year = minYear;
                    if (this.view == "decade") {
                        if (this._renderStartDate) {
                            if (this._renderStartDate.getFullYear() == year) {
                                return;
                            }
                        }
                    }

                    // if (this.value.year == year) return;
                    this.value.year = year;
                    this.value.month = 1;
                    this.value.day = 1;
                }

                var day = this.value.day;
                var month = this.value.month;
                if (month - step >= 1) {
                    var maxDays = this.value._daysInMonth(this.value.year, this.value.month - step);
                    if (day > maxDays)
                        day = maxDays;
                }

                if (this.view == 'month') {
                    var date = new Date(this.value.year, this.value.month - 1 - step, day);
                    if (type == 'arrow' && this.selectableDays.length == 7 && this.selectionMode != "range") {
                        this.selectedDate = new Date(this.value.year, this.value.month - 1 - step, 1);
                    }
                }
                else {
                    var date = new Date(this.value.year, this.value.month - 1, day);
                }

                return this.navigateTo(date);
            },

            _isRestrictedRange: function (from, to) {
                if (from > to)
                    return true;

                var curr = from;
                while (curr.valueOf() <= to.valueOf()) {
                    if (this._isRestrictedDate(curr))
                        return true;

                    curr.setDate(curr.getDate() + 1);
                }

                return false;
            },

            _hasUnrestrictedRanges: function (from, to) {
                if (from > to)
                    return false;

                var curr = from;
                while (curr.valueOf() <= to.valueOf()) {
                    if (!this._isRestrictedDate(curr))
                        return true;

                    curr.setDate(curr.getDate() + 1);
                }

                return false;
            },

            _getNextUnrestrictedDay: function (from, to) {
                if (from > to)
                    return null;

                var curr = from;
                while (curr.valueOf() <= to.valueOf()) {
                    if (!this._isRestrictedDate(curr))
                        return curr;

                    curr.setDate(curr.getDate() + 1);
                }

                return null;
            },

            _isRestrictedDate: function (date) {
                var self = this;
                if (!$.isArray(self.restrictedDates))
                    return false;

                for (var i = 0; i < self.restrictedDates.length; i++) {
                    var dateCompare = self.restrictedDates[i];

                    if (typeof (dateCompare) == 'object' && dateCompare.from != undefined && dateCompare.to != undefined) {
                        var dateCompareFrom = dateCompare.from;
                        var dateCompareTo = dateCompare.to;

                        if (date.valueOf() >= dateCompareFrom.valueOf() && date.valueOf() <= dateCompareTo.valueOf()) {
                            return true;
                        }
                    }
                    else {
                        if (dateCompare.getMonth() == date.getMonth() &&
                            dateCompare.getDate() == date.getDate() &&
                            dateCompare.getFullYear() == date.getFullYear()
                        ) {
                            return true;
                        }
                    }
                }

                return false;
            },

            _isDisabled: function (date) {
                var dayNames = ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
                var day = date.getDay();
                var name = dayNames[day];
                if (this.selectableDays.indexOf(name) == -1)
                    return true;

                if (this._isRestrictedDate(date))
                    return true;

                return false;
            },

            refreshCalendarCells: function (month, firstDay, calendarID) {
                if (this.view == "year" || this.view == "decade" || this.view == 'centuries') {
                    this.refreshViews(month, firstDay, calendarID);
                    return;
                }
                var tableElement = this.table;
                var cellsTable = tableElement.find("#" + 'cellTable' + calendarID.toString());
                var currentDate = firstDay;
                var cells = new Array();
                var k = 0;
                var today = new $.jqx._jqxDateTimeInput.getDateTime(new Date());

                for (var i = 0; i < 6; i++) {
                    for (var j = 0; j < 7; j++) {
                        var cellRowID = i + 1;
                        var r = j;
                        if (this.rtl) r = 6 - r;
                        var cellColumnID = r + 1;
                        var cellID = "#cell" + cellRowID + cellColumnID + this.element.id;
                        var date = new Date(currentDate.dateTime.getFullYear(), currentDate.dateTime.getMonth(), currentDate.dateTime.getDate());
                        var cell = new $.jqx._jqxCalendar.cell(date);
                        var cellElement = $(cellsTable[0].rows[i].cells[cellColumnID - 1]);
                        cellElement[0].id = cellID.substring(1);

                        cell.element = cellElement;
                        cell.row = i;
                        cell.column = j;

                        cell.isVisible = true;
                        cell.isOtherMonth = false;
                        cell.isToday = false;
                        cell.isWeekend = false;
                        cell.isHighlighted = false;
                        cell.isSelected = false;

                        if (currentDate.month != this.value.month) {
                            cell.isOtherMonth = true;
                            cell.isVisible = this.showOtherMonthDays;
                        }

                        if (this._isRestrictedDate(date)) {
                            cell.isRestricted = true;
                            cell.isDisabled = true;
                        }

                        if (!cell.isDisabled) {
                            if (date < this.getMinDate() || date > this.getMaxDate() || this._isDisabled(date)) {
                                cell.isDisabled = true;
                            }
                        }

                        if (currentDate.month == today.month && currentDate.day == today.day && currentDate.year == today.year) {
                            cell.isToday = true;
                        }

                        if (currentDate.isWeekend()) {
                            cell.isWeekend = true;
                        }

                        $.data(this.element, "cellContent" + cellID.substring(1), cell);
                        $.data(this.element, cellID.substring(1), cell);
                        cells[k] = cell;
                        k++;
                        $.jqx.utilities.html(cellElement, currentDate.day);

                        this._applyCellStyle(cell, cellElement, cellElement);

                        currentDate = new $.jqx._jqxDateTimeInput.getDateTime(new Date(currentDate._addDays(1)));
                    }
                }

                var monthInstance = $.data(this.element, month[0].id);
                if (monthInstance != undefined && monthInstance != null) {
                    monthInstance.cells = cells;
                }
                this.renderedCells = cells;
                this._refreshOtherMonthRows(monthInstance, calendarID);
            },

            _getDecadeAndCenturiesData: function () {
                var renderYears = new Array();
                var renderDates = new Array();
                var length = this.getMaxDate().getFullYear() - this.getMinDate().getFullYear();
                if (length < 12) length = 12;
                var minDate = this.getMinDate();
                var maxDate = this.getMaxDate();
                var currentYear = this.value.dateTime.getFullYear();

                if (this.view == "decade") {
                    if (currentYear + 12 > maxDate.getFullYear()) {
                        currentYear = maxDate.getFullYear() - 11;
                    }
                    if (currentYear < minDate.getFullYear()) {
                        currentYear = minDate.getFullYear();
                    }
                    for (var i = 0; i < length; i++) {
                        var date = new Date(minDate.getFullYear() + i, 0, 1);
                        if (minDate.getFullYear() <= currentYear && currentYear <= date.getFullYear()) {
                            var renderStartDate = new Date(date.getFullYear(), date.getMonth(), 1);

                            for (var j = 0; j < 12; j++) {
                                var newDate = new Date(renderStartDate.getFullYear() + j, this.value.dateTime.getMonth(), this.value.dateTime.getDate());
                                var year = newDate.getFullYear();

                                if (minDate.getFullYear() <= year && year <= maxDate.getFullYear()) {
                                    renderYears.push(year);
                                    renderDates.push(newDate);
                                    if (j == 0) {
                                        this._renderStartDate = newDate;
                                    }
                                    this._renderEndDate = newDate;
                                }
                                else {
                                    renderYears.push(year);
                                    renderDates.push(newDate);
                                }

                            }

                            break;
                        }
                    }
                }
                else if (this.view == "centuries") {
                    for (var i = 0; i < length; i += 120) {
                        var date = new Date(minDate.getFullYear() + i + 120, 0, 1);

                        if (minDate.getFullYear() <= currentYear && currentYear <= date.getFullYear()) {
                            var renderStartDate = new Date(date.getFullYear() - 130, date.getMonth(), 1);

                            if (renderStartDate < minDate) {
                                renderStartDate = minDate;
                            }

                            for (var j = 0; j < 12; j++) {
                                var centuriesDate = new Date(renderStartDate.getFullYear() + j * 10, renderStartDate.getMonth(), 1);
                                if (renderStartDate.getFullYear() >= minDate.getFullYear() && centuriesDate.getFullYear() <= maxDate.getFullYear()) {
                                    renderYears.push("<span style='visibility: hidden;'>-</span>" + centuriesDate.getFullYear() + "-" + (centuriesDate.getFullYear() + 9));
                                    renderDates.push(centuriesDate);
                                    if (j == 0) {
                                        this._renderCenturyStartDate = centuriesDate;
                                    }
                                    this._renderCenturyEndDate = new Date(centuriesDate.getFullYear() + 9, 0, 1);
                                }
                            }
                            break;
                        }
                    }
                }
                return { years: renderYears, dates: renderDates };
            },

            refreshViews: function (month, firstDay, calendarID) {
                var me = this;
                var cells = new Array();
                var cellsTable = month.find('#cellTable' + calendarID.toString());

                var data = this._getDecadeAndCenturiesData();
                var renderYears = data.years;
                var renderDates = data.dates;

                var k = 0;
                var minDate = this.getMinDate();
                var maxDate = this.getMaxDate();

                for (var i = 0; i < 3; i++) {
                    for (var j = 0; j < 4; j++) {
                        var cellRowID = i + 1;
                        var r = j;
                        if (this.rtl) r = 3 - r;
                        var cellColumnID = r + 1;
                        var date = new Date(this.value.dateTime);
                        date.setDate(1);
                        date.setMonth(i * 4 + r);
                        var cell = new $.jqx._jqxCalendar.cell(date);
                        var row = cellsTable[0].rows["row" + (1 + i) + this.element.id];
                        var cellElement = $(row.cells[j]);

                        cell.isSelected = false;
                        cell.isVisible = true;
                        cell.element = cellElement;
                        cell.row = i;
                        cell.column = j;
                        cell.index = cells.length;
                        var text = "";
                        if (this.view == "year") {
                            var monthNames = this.localization.calendar.months.names;
                            var monthString = monthNames[i * 4 + r];

                            // Possible values: default, shortest, firstTwoLetters, firstLetter, full
                            switch (this.monthNameFormat) {
                                case 'default':
                                    monthString = this.localization.calendar.months.namesAbbr[i * 4 + r];
                                    break;
                                case 'shortest':
                                    monthString = this.localization.calendar.months.namesShort[i * 4 + r];
                                    break;
                                case 'firstTwoLetters':
                                    monthString = monthString.substring(0, 2);
                                    break;
                                case 'firstLetter':
                                    monthString = monthString.substring(0, 1);
                                    break;
                            }
                            text = monthString;
                        }
                        else if (this.view == "decade" || this.view == "centuries") {
                            text = renderYears[i * 4 + r];
                            if (undefined == text) {
                                text = "<span style='cursor: default; visibility: hidden;'>2013</span>";
                            }
                            cell.setDate(renderDates[i * 4 + r]);
                        }
                        var date = cell.getDate();
                        if (this.view == "year") {
                            if (date.getMonth() == this.getDate().getMonth() && date.getFullYear() == this.getDate().getFullYear()) {
                                cell.isSelected = true;
                            }
                        }
                        else {
                            if (date.getFullYear() == this.getDate().getFullYear()) {
                                cell.isSelected = true;
                            }
                        }

                        if (this.view == "year") {
                            if (this._getYearAndMonthPart(date) < this._getYearAndMonthPart(minDate))
                                cell.isDisabled = true;
                            if (this._getYearAndMonthPart(date) > this._getYearAndMonthPart(maxDate))
                                cell.isDisabled = true;
                        }
                        else {
                            if (date.getFullYear() < minDate.getFullYear())
                                cell.isDisabled = true;
                            if (date.getFullYear() > maxDate.getFullYear())
                                cell.isDisabled = true;
                        }

                        $.jqx.utilities.html(cellElement, text);
                        cells[k] = cell;
                        k++;
                    }
                }
                var monthInstance = $.data(this.element, month[0].id);
                if (monthInstance != undefined && monthInstance != null) {
                    monthInstance.cells = cells;
                }
                this.renderedCells = cells;
                this._applyCellStyles();
            },

            _createViewClone: function () {
                var table = this.host.find('.jqx-calendar-month');
                var viewClone = table.clone();
                viewClone.css('position', 'absolute');
                viewClone.css('top', table.position().top);
                viewClone.width(this.month.width());
                return viewClone;
            },

            _addCellsTable: function (tableElement, cellsTable) {
                var me = this;
                //            cellsTable.find('table').css({ background: 'none', padding: 0, margin: 0, border: 0 });
                //            cellsTable.find('td').css({ padding: 1, margin: 0 });
                //            cellsTable.find('tr').css({ background: 'none', padding: 0, margin: 0, border: 0 });

                var footerHeight = this.showFooter ? 20 : 0;
                if (this.view != "month") {
                    if (this.views.indexOf('month') === -1) {
                        cellsTable.height(this.host.height() - this.titleHeight);
                    }
                    else {
                        cellsTable.height(this.month.height() - this.titleHeight);
                    }
                }
                else {
                    cellsTable.height(this.month.height() - this.titleHeight - this.columnHeaderHeight - footerHeight);
                }

                this._viewAnimating = true;
                var container = this.host.find('.jqx-calendar-month-container');
                container.css('position', 'relative');
                var table = this.host.find('.jqx-calendar-month');
                var viewClone = this._createViewClone();
                container.append(viewClone);
                if (this.view != "month") {
                    this.header.fadeOut(0);
                    if (this.showWeekNumbers) {
                        this.rowHeader.fadeOut(0);
                    }
                    if (this.showFooter) {
                        this._footer.fadeOut(0);
                    }
                }
                else {
                    this.header.fadeIn(this.navigationDelay + 200);
                    if (this.showWeekNumbers) {
                        this.rowHeader.fadeIn(this.navigationDelay + 200);
                    }
                    if (this.showFooter) {
                        this._footer.fadeIn(this.navigationDelay + 200);
                    }
                }

                tableElement.children().remove();
                tableElement.append(cellsTable);

                this._animateViews(viewClone, cellsTable, function () {
                    if (!me.selectedDate && me.selectionMode != "range") {
                        me.selectedDate = me.renderedCells[0].getDate();
                    }
                    try {
                        me.renderedCells[0].element.focus();
                        setTimeout(function () {
                            me.renderedCells[0].element.focus();
                        }, 10);
                    }
                    catch (error) {
                    }

                    me._viewAnimating = false;
                });

                cellsTable.addClass(this.toThemeProperty("jqx-calendar-view"));
            },

            _animateViews: function (view1, view2, callback) {
                var me = this;
                me._viewAnimating = true;

                if (me.oldView == me.view) {
                    view1.remove();
                    view2.fadeOut(0);
                    view2.fadeIn(0);
                    callback();
                    return;
                }

                view1.fadeOut(this.navigationDelay + 100, function () {
                    view1.remove();
                });
                view2.fadeOut(0);
                view2.fadeIn(this.navigationDelay + 200, function () {
                    callback();
                });
            },

            focus: function () {
                if (this.disabled)
                    return;

                try {
                    if (this.renderedCells && this.renderedCells.length > 0) {
                        var me = this;
                        var focusChanged = false;
                        if (!me.selectedDate && me.selectionMode != 'range') {
                            this.setDate(new Date(), 'mouse');
                        }

                        this.element.focus();
                    }
                }
                catch (error) {
                }
            },

            renderViews: function (month, firstDay, calendarID) {
                var me = this;
                var cells = new Array();
                var cellsTable = $("<table role='grid' style='border-color: transparent; width: 100%; height: 100%;' cellspacing='2' cellpadding='0' id=" + 'cellTable' + calendarID.toString() + ">" +
                    "<tr role='row' id='row1" + this.element.id + "'>" +
                    "<td role='gridcell'></td>" + "<td role='gridcell'></td>" + "<td role='gridcell'></td>" + "<td role='gridcell'></td>" +
                    "</tr>" +
                    "<tr role='row' id='row2" + this.element.id + "'>" +
                    "<td role='gridcell'></td>" + "<td role='gridcell'></td>" + "<td role='gridcell'></td>" + "<td role='gridcell'></td>" +
                    "</tr>" +
                    "<tr role='row' id='row3" + this.element.id + "'>" +
                    "<td role='gridcell'></td>" + "<td role='gridcell'></td>" + "<td role='gridcell'></td>" + "<td role='gridcell'></td>" +
                    "</tr>" +
                    "</table>"
                );

                var container = this.host.find('.jqx-calendar-month-container');
                container.css('position', 'relative');
                var tableElement = month.find("#cellsTable" + month[0].id);
                tableElement[0].style.borderColor = "transparent";

                var data = this._getDecadeAndCenturiesData();
                var renderYears = data.years;
                var renderDates = data.dates;
                var k = 0;
                var minDate = this.getMinDate();
                var maxDate = this.getMaxDate();
                var valueDate = new Date(this.value.dateTime);
                valueDate.setDate(1);

                for (var i = 0; i < 3; i++) {
                    for (var j = 0; j < 4; j++) {
                        var cellRowID = i + 1;
                        var r = j;
                        if (this.rtl) r = 3 - r;
                        var cellColumnID = r + 1;
                        var row = cellsTable[0].rows["row" + (1 + i) + this.element.id];
                        var date = new Date(valueDate);
                        date.setMonth(i * 4 + r);
                        var cell = new $.jqx._jqxCalendar.cell(date);
                        var cellElement = $(row.cells[j]);
                        cell.isVisible = true;
                        cell.element = cellElement;
                        cell.row = i;
                        cell.column = j;
                        cell.index = cells.length;
                        cell.isSelected = false;

                        var text = "";
                        if (this.view == "year") {
                            if (date.getMonth() == this.getDate().getMonth() && date.getFullYear() == this.getDate().getFullYear()) {
                                cell.isSelected = true;
                            }
                            var monthNames = this.localization.calendar.months.names;
                            var monthString = monthNames[i * 4 + r];

                            // Possible values: default, shortest, firstTwoLetters, firstLetter, full
                            switch (this.monthNameFormat) {
                                case 'default':
                                    monthString = this.localization.calendar.months.namesAbbr[i * 4 + r];
                                    break;
                                case 'shortest':
                                    monthString = this.localization.calendar.months.namesShort[i * 4 + r];
                                    break;
                                case 'firstTwoLetters':
                                    monthString = monthString.substring(0, 2);
                                    break;
                                case 'firstLetter':
                                    monthString = monthString.substring(0, 1);
                                    break;
                            }
                            text = monthString;
                        }
                        else if (this.view == "decade" || this.view == "centuries") {
                            text = renderYears[i * 4 + r];
                            cell.setDate(renderDates[i * 4 + r]);
                            if (cell.getDate().getFullYear() == this.getDate().getFullYear()) {
                                cell.isSelected = true;
                            }
                            if (undefined == text) {
                                text = "<span style='cursor: default; visibility: hidden;'>2013</span>";
                            }
                        }

                        var date = cell.getDate();
                        if (this.view == "year") {
                            var nextMonth = new Date(date);
                            nextMonth.setDate(1);
                            nextMonth.setHours(0, 0, 0, 0);
                            nextMonth.setMonth(date.getMonth() + 1);
                            nextMonth = new Date(nextMonth.valueOf() - 1);

                            if (this._getYearAndMonthPart(date) < this._getYearAndMonthPart(minDate) ||
                                this._getYearAndMonthPart(date) > this._getYearAndMonthPart(maxDate) ||
                                !this._hasUnrestrictedRanges(date, nextMonth)) {
                                cell.isDisabled = true;
                            }
                        }
                        else {
                            var nextYear = new Date(date);
                            nextYear.setMonth(0);
                            nextYear.setDate(1);
                            nextYear.setHours(0, 0, 0, 0);

                            nextYear.setFullYear(date.getFullYear() + 1);
                            nextYear = new Date(nextYear.valueOf() - 1);

                            if (date.getFullYear() < minDate.getFullYear() ||
                                date.getFullYear() > maxDate.getFullYear() ||
                                !this._hasUnrestrictedRanges(date, nextYear)) {
                                cell.isDisabled = true;
                            }
                        }

                        $.jqx.utilities.html(cellElement, text);
                        cells[k] = cell;
                        k++;
                    }
                }
                $.each(cells, function () {
                    var element = this.element;
                    var cell = this;
                    if (!me.disabled) {
                        me.addHandler(element, 'mousedown',
                            function (event) {
                                me._setDateAndSwitchViews(cell, event, 'mouse');
                            });

                        me.addHandler(element, 'mouseover',
                            function (event) {
                                var renderCell = me.renderedCells[cell.index];
                                if (me.view != 'centuries' && renderCell.element.html().toLowerCase().indexOf('span') != -1) return;

                                renderCell.isHighlighted = true;
                                me._applyCellStyle(renderCell, renderCell.element, renderCell.element);
                            });

                        me.addHandler(element, 'mouseout',
                            function (event) {
                                var renderCell = me.renderedCells[cell.index];
                                if (me.view != 'centuries' && renderCell.element.html().toLowerCase().indexOf('span') != -1) return;

                                renderCell.isHighlighted = false;
                                me._applyCellStyle(renderCell, renderCell.element, renderCell.element);
                            });
                    }
                });

                var monthInstance = $.data(this.element, month[0].id);
                if (monthInstance != undefined && monthInstance != null) {
                    monthInstance.cells = cells;
                }
                this.renderedCells = cells;
                this._addCellsTable(tableElement, cellsTable);
                this._applyCellStyles();
            },

            _setDateAndSwitchViews: function (cell, event, type) {
                if (!this._viewAnimating && !this._animating) {
                    var oldDate = this.getDate();
                    var date = this.renderedCells[cell.index].getDate();
                    var day = this.value.dateTime.getDate();
                    var newDate = new Date(date);
                    if (this.views.indexOf('month') != -1) {
                        newDate.setDate(day);
                    }
                    else {
                        newDate.setDate(1);
                        date.setDate(1);
                    }

                    if (newDate.getMonth() == date.getMonth()) {
                        date = newDate;
                    }

                    var minDate = this.getMinDate();
                    var maxDate = this.getMaxDate();

                    if (this.view == "year") {
                        if (this._getYearAndMonthPart(date) < this._getYearAndMonthPart(minDate))
                            return;
                        if (this._getYearAndMonthPart(date) > this._getYearAndMonthPart(maxDate))
                            return;
                    }
                    else {
                        if (date.getFullYear() < minDate.getFullYear())
                            return;
                        if (date.getFullYear() > maxDate.getFullYear())
                            return;
                    }

                    if (this.selectionMode != "range") {
                        this._selectDate(date, type);
                    }
                    this.oldView = this.view;
                    switch (this.view) {
                        case "year":
                            this.view = 'month';
                            break;
                        case "decade":
                            this.view = 'year';
                            break;
                    }
                    if (this.views.indexOf('month') == -1) this.view = 'year';
                    if (this.views.indexOf('year') == -1) this.view = 'decade';

                    if (this.view == "year") {
                        if (this._getYearAndMonthPart(date) < this._getYearAndMonthPart(minDate))
                            date = minDate;

                        if (this._getYearAndMonthPart(date) > this._getYearAndMonthPart(maxDate))
                            date = maxDate;
                    }
                    else {
                        if (date.getFullYear() < minDate.getFullYear())
                            date = minDate;

                        if (date.getFullYear() > maxDate.getFullYear())
                            date = maxDate;
                    }

                    if (this.changing && (this.selectedDate && (this.selectedDate.getFullYear() != date.getFullYear() || this.selectedDate.getMonth() != date.getMonth() ||
                        this.selectedDate.getDate() != date.getDate()))) {
                        date = this.selectedDate;
                    }

                    this.value._setYear(date.getFullYear());
                    this.value._setDay(date.getDate());
                    this.value._setMonth(date.getMonth() + 1);
                    this.value._setDay(date.getDate());
                    var visibleDate = this.getVisibleDate();
                    var firstDay = this.getFirstDayOfWeek(visibleDate);
                    var calendarID = "View" + this.element.id;
                    this.renderCalendarCells(this.month, firstDay, calendarID, true);
                    this.refreshTitle(this.month);
                    if (this.showWeekNumbers) {
                        this.refreshRowHeader(this.month, calendarID);
                    }
                    if (this.views.length == 3) {
                        if (this.view == "month") {
                            if (this.selectionMode != "range") {
                                this._selectDate(this.selectedDate, 'view');
                            }
                            else {
                                var self = this;
                                $.each(this.renderedCells, function (index) {
                                    var cell = this;
                                    var cellDate = cell.getDate();
                                    var cellElement = $(cell.element);
                                    var cellContent = cellElement;
                                    if (cellElement.length == 0)
                                        return false;
                                    var getDatePart = function (date) {
                                        if (date == null) {
                                            return new Date();
                                        }

                                        var newDate = new Date();
                                        newDate.setHours(0, 0, 0, 0);
                                        newDate.setFullYear(date.getFullYear(), date.getMonth(), date.getDate());
                                        return newDate;
                                    }

                                    if (!cell.isOtherMonth && getDatePart(cellDate).toString() == getDatePart(date).toString()) {
                                        self.value._setMonth(date.getMonth() + 1);
                                        self.value._setDay(date.getDate());
                                        self.value._setYear(date.getFullYear());
                                    }
                                    cell.isSelected = false;
                                    cell.isDisabled = false;

                                    if (getDatePart(cellDate) < getDatePart(self.selection.from) && self._clicks == 1) {
                                        cell.isDisabled = true;
                                    }
                                    if (self.getMaxDate() < cellDate) {
                                        cell.isDisabled = true;
                                    }
                                    if (self.getMinDate() > cellDate) {
                                        cell.isDisabled = true;
                                    }
                                    if (self._isDisabled(cellDate)) {
                                        cell.isDisabled = true;
                                    }

                                    if (!cell.isDisabled) {
                                        if (getDatePart(cellDate) >= getDatePart(self.selection.from) && getDatePart(cellDate) <= getDatePart(self.selection.to)) {
                                            cell.isSelected = true;
                                        }
                                    }
                                });
                                this._applyCellStyles();
                            }
                        }
                    }
                    if (this.view != "month") {
                        if (this.oldView == "year" || (this.views.indexOf("year") == -1 && this.view == "decade")) {
                            if (type != 'keyboard') {
                                this._raiseEvent('3');
                            }
                            this._raiseEvent('5', { selectionType: 'mouse' });
                        }
                    }
                    this._raiseEvent('8');
                }
            },

            renderCalendarCells: function (month, firstDay, calendarID, switchViews) {
                if (this.view == "year" || this.view == "decade" || this.view == 'centuries') {
                    this.renderViews(month, firstDay, calendarID);
                    return;
                }
                var cellsTable = $("<table role='grid' style='width: 100%; height: 100%; border-color: transparent;' cellspacing='2' cellpadding='1' id=" + 'cellTable' + calendarID.toString() + ">" +
                    "<tr role='row'>" +
                    "<td role='gridcell'></td>" + "<td role='gridcell'></td>" + "<td role='gridcell'></td>" + "<td role='gridcell'></td>" + "<td role='gridcell'></td>" + "<td role='gridcell'></td>" + "<td role='gridcell'></td>" +
                    "</tr>" +
                    "<tr role='row'>" +
                    "<td role='gridcell'></td>" + "<td role='gridcell'></td>" + "<td role='gridcell'></td>" + "<td role='gridcell'></td>" + "<td role='gridcell'></td>" + "<td role='gridcell'></td>" + "<td role='gridcell'></td>" +
                    "</tr>" +
                    "<tr role='row'>" +
                    "<td role='gridcell'></td>" + "<td role='gridcell'></td>" + "<td role='gridcell'></td>" + "<td role='gridcell'></td>" + "<td role='gridcell'></td>" + "<td role='gridcell'></td>" + "<td role='gridcell'></td>" +
                    "</tr>" +
                    "<tr role='row'>" +
                    "<td role='gridcell'></td>" + "<td role='gridcell'></td>" + "<td role='gridcell'></td>" + "<td role='gridcell'></td>" + "<td role='gridcell'></td>" + "<td role='gridcell'></td>" + "<td role='gridcell'></td>" +
                    "</tr>" +
                    "<tr role='row'>" +
                    "<td role='gridcell'></td>" + "<td role='gridcell'></td>" + "<td role='gridcell'></td>" + "<td role='gridcell'></td>" + "<td role='gridcell'></td>" + "<td role='gridcell'></td>" + "<td role='gridcell'></td>" +
                    "</tr>" +
                    "<tr role='row'>" +
                    "<td role='gridcell'></td>" + "<td role='gridcell'></td>" + "<td role='gridcell'></td>" + "<td role='gridcell'></td>" + "<td role='gridcell'></td>" + "<td role='gridcell'></td>" + "<td role='gridcell'></td>" +
                    "</tr>" +
                    "</table>"
                );

                var tableElement = this.table;
                tableElement[0].style.borderColor = "transparent";

                if (switchViews == undefined) {
                    var oldCellsTable = tableElement.find("#" + 'cellTable' + calendarID.toString());
                    if (oldCellsTable != null) {
                        oldCellsTable.remove();
                    }

                    tableElement.append(cellsTable);
                }

                var currentDate = firstDay;

                var startRow = this.showDayNames ? 1 : 0;
                var startColumn = this.showWeekNumbers ? 1 : 0;
                var cells = new Array();
                var k = 0;

                var cellWidth = (month.width() - this.rowHeaderWidth - 2) / 7;
                if (!this.showWeekNumbers) {
                    cellWidth = (month.width() - 2) / 7;
                }
                cellWidth = parseInt(cellWidth);
                var today = new $.jqx._jqxDateTimeInput.getDateTime(new Date());

                for (var i = 0; i < 6; i++) {
                    for (var j = 0; j < 7; j++) {
                        var cellRowID = i + 1;
                        var r = j;
                        if (this.rtl) r = 6 - r;
                        var cellColumnID = r + 1;
                        var cellID = "#cell" + cellRowID + cellColumnID + this.element.id;
                        var date = new Date(currentDate.dateTime.getFullYear(), currentDate.dateTime.getMonth(), currentDate.dateTime.getDate());
                        var cell = new $.jqx._jqxCalendar.cell(date);
                        var cellElement = $(cellsTable[0].rows[i].cells[cellColumnID - 1]);
                        cellElement[0].id = cellID.substring(1);

                        cell.isVisible = true;
                        cell.isDisabled = false;
                        if (currentDate.month != this.value.month) {
                            cell.isOtherMonth = true;
                            cell.isVisible = this.showOtherMonthDays;
                        }

                        if (this._isRestrictedDate(date)) {
                            cell.isRestricted = true;
                            cell.isDisabled = true;
                        }

                        if (!cell.isDisabled) {
                            if (date < this.getMinDate() || date > this.getMaxDate() || this._isDisabled(date)) {
                                cell.isDisabled = true;
                            }
                        }

                        if (currentDate.month == today.month && currentDate.day == today.day && currentDate.year == today.year) {
                            cell.isToday = true;
                        }

                        if (currentDate.isWeekend()) {
                            cell.isWeekend = true;
                        }

                        cell.element = cellElement;
                        cell.row = startRow;
                        cell.column = startColumn;
                        $.jqx.utilities.html(cellElement, currentDate.day);

                        currentDate = new $.jqx._jqxDateTimeInput.getDateTime(new Date(currentDate._addDays(1)));

                        $.data(this.element, "cellContent" + cellID.substring(1), cell);
                        $.data(this.element, "" + cellID.substring(1), cell);
                        var me = this;
                        if (me.isMaterialized()) {
                            $(cellElement).addClass('ripple');
                            $.jqx.ripple($(cellElement));
                        }
                        this.addHandler(cellElement, 'mousedown',
                            function (event) {
                                if (!me.readOnly && !me.disabled) {
                                    var content = $(event.target);
                                    var cell = $.data(me.element, content[0].id);

                                    var result = me._raiseEvent(3, event);
                                    if (cell != null && cell != undefined) {
                                        var date = cell.getDate();
                                        if (me.getMinDate() <= date && date <= me.getMaxDate()) {
                                            if (!cell.isDisabled) {
                                                if (cell.isOtherMonth && me.enableAutoNavigation) {
                                                    if (cell.row < 2)
                                                        me.navigateBackward();
                                                    else
                                                        me.navigateForward();
                                                    me._selectDate(cell.getDate(), 'mouse', event.shiftKey);
                                                }
                                                else {
                                                    var oldDate = new Date(me.getDate());
                                                    me._selectDate(cell.getDate(), 'mouse', event.shiftKey);
                                                    me.value._setYear(date.getFullYear());
                                                    me.value._setDay(1);
                                                    me.value._setMonth(date.getMonth() + 1);
                                                    me.value._setDay(date.getDate());
                                                    var table = me.host.find('.jqx-calendar-month');
                                                    table.stop();
                                                    table.css('margin-left', '0px');
                                                    var currentDate = me.getDate();
                                                    me._raiseEvent('2');
                                                    if (cell.isOtherMonth) {
                                                        me._raiseEvent('5', { selectionType: 'mouse' });
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    return false;
                                }
                            });

                        if (!me.disabled) {
                            var highlight = function (event, highlight) {
                                if (!me.readOnly) {
                                    var content = $(event.target);
                                    var cell = $.data(me.element, content[0].id);

                                    if (cell != null && cell != undefined) {
                                        var date = cell.getDate();
                                        if (me.getMinDate() <= date && date <= me.getMaxDate()) {
                                            cell.isHighlighted = highlight;
                                            me._applyCellStyle(cell, cell.element, content);
                                        }
                                    }
                                }
                            }

                            this.addHandler(cellElement, 'mouseenter',
                                function (event) {
                                    highlight(event, true);
                                    return false;
                                });

                            this.addHandler(cellElement, 'mouseleave',
                                function (event) {
                                    highlight(event, false);
                                    return false;
                                });
                        }

                        startColumn++;
                        cells[k] = cell;
                        k++;
                    }
                    startColumn = 0;
                    startRow++;
                }

                var monthInstance = $.data(this.element, month[0].id);
                if (monthInstance != undefined && monthInstance != null) {
                    monthInstance.cells = cells;
                }
                this.renderedCells = cells;
                if (switchViews != undefined) {
                    this._addCellsTable(tableElement, cellsTable);
                }
                this._applyCellStyles();
                this._refreshOtherMonthRows(monthInstance, calendarID);
            },

            // sets the maximum navigation date.
            // @param - Date
            setMaxDate: function (date, refresh) {
                if (date != null && typeof (date) == "string") {
                    date = new Date(date);
                    if (date == "Invalid Date")
                        return;
                }

                this.maxDate = $.jqx._jqxDateTimeInput.getDateTime(date);
                if (refresh !== false)
                    this.render();
            },

            // gets the maximum navigation date.
            getMaxDate: function () {
                if (this.maxDate != null && this.maxDate != undefined) {
                    return this.maxDate.dateTime;
                }

                return null;
            },

            // sets the minimum date.
            // @param - Date
            setMinDate: function (date, refresh) {
                if (date != null && typeof (date) == "string") {
                    date = new Date(date);
                    if (date == "Invalid Date")
                        return;
                }

                this.minDate = $.jqx._jqxDateTimeInput.getDateTime(date);
                if (refresh !== false)
                    this.render();
            },

            // gets the minimum date.
            getMinDate: function () {
                if (this.minDate != null && this.minDate != undefined) {
                    return this.minDate.dateTime;
                }

                return null;
            },


            // sets the calendar's date.
            // @param - Date
            navigateTo: function (date, reason) {
                if (this.view == 'month') {
                    var minDate = this.getMinDate();
                    var maxDate = new Date(this.getMaxDate().getFullYear(), this.getMaxDate().getMonth() + 1, this.getMaxDate().getDate());
                    if ((date < this._getYearAndMonthPart(minDate)) || (date > this._getYearAndMonthPart(maxDate))) {
                        return false;
                    }
                }
                else if (date && (date.getFullYear() < this.getMinDate().getFullYear() || date.getFullYear() > this.getMaxDate().getFullYear())) {
                    return false;
                }

                if (date == null) {
                    return false;
                }

                if (reason == undefined) {
                    var me = this;
                    if (this._animating) {
                        return;
                    }

                    this._animating = true;
                    var container = this.host.find('.jqx-calendar-month-container');
                    var animationContainer = $("<div></div>");

                    animationContainer[0].style.width = "100%";
                    animationContainer[0].style.height = "100%";
                    animationContainer[0].style.overflow = "hidden";
                    animationContainer[0].style.position = "relative";
                    animationContainer[0].style.left = "0px";
                    animationContainer[0].style.top = "-100%";
                    container.append(animationContainer);

                    if (this._viewClone) {
                        this._viewClone.stop();
                        this._viewClone.remove();
                    }
                    if (this._newViewClone) {
                        this._newViewClone.stop();
                        this._newViewClone.remove();
                    }

                    var table = this.host.find('.jqx-calendar-month');
                    table.stop();
                    table.css('margin-left', '0px');

                    var viewClone = table.clone();
                    this._viewClone = viewClone;
                    var value = new Date(this.value.dateTime);
                    this.value._setYear(date.getFullYear());
                    this.value._setDay(date.getDate());
                    this.value._setMonth(date.getMonth() + 1);

                    var topPadding = parseInt(this.month.css('padding-top'));


                    me.refreshControl();
                    animationContainer.css('overflow', 'hidden');
                    container.css('position', 'relative');
                    container.css('overflow', 'hidden');
                    viewClone.css('position', 'absolute');
                    viewClone.css('top', table.position().top - topPadding);

                    animationContainer.append(viewClone);
                    if ($.jqx.browser.msie && $.jqx.browser.version < 8) {
                        this.month.css('position', 'relative');
                        this.month.css('overflow', 'hidden');
                        this.table.css('position', 'relative');
                        this.table.css('overflow', 'hidden');
                    }

                    var width = -this.month.width();
                    if (date < value) {
                        if (this.view == "month" && date.getMonth() != value.getMonth()) {
                            width = this.month.width();
                        }
                        else if (date.getFullYear() != value.getFullYear()) {
                            width = this.month.width();
                        }
                    }

                    viewClone.animate({
                        marginLeft: parseInt(width) + 'px'
                    }, this.navigationDelay, function () {
                        viewClone.remove();
                    });
                    var newViewClone = table.clone();
                    this._newViewClone = newViewClone;
                    newViewClone.css('position', 'absolute');
                    newViewClone.css('top', table.position().top - topPadding);
                    animationContainer.append(newViewClone);
                    newViewClone.css('margin-left', -width);
                    table.css('visibility', 'hidden');
                    newViewClone.animate({
                        marginLeft: '0px'
                    }, this.navigationDelay, function () {
                        newViewClone.remove();
                        table.css('visibility', 'inherit');
                        animationContainer.remove();
                        me._animating = false;
                    });
                }
                else {
                    this.value._setYear(date.getFullYear());
                    this.value._setDay(date.getDate());
                    this.value._setMonth(date.getMonth() + 1);
                    var table = this.host.find('.jqx-calendar-month');
                    table.stop();
                    table.css('margin-left', '0px');

                    this.refreshControl();
                }


                this._raiseEvent('2');
                this._raiseEvent('8');
                return true;
            },

            // sets the calendar's date.
            // @param - Date
            setDate: function (date) {
                if (date != null && typeof (date) == "string") {
                    date = new Date(date);
                }

                if (this.canRender == false) {
                    this.canRender = true;
                    this.render();
                }
                this.navigateTo(date, 'api');
                this._selectDate(date);
                if (this.selectionMode == 'range') {
                    this._selectDate(date, 'mouse');
                }

                return true;
            },

            val: function (value) {
                if (arguments.length != 0) {
                    if (value == null)
                        this.setDate(null);

                    if (value instanceof Date)
                        this.setDate(value);

                    if (typeof (value) == "string") {
                        this.setDate(value);
                    }
                }
                return this.getDate();
            },

            // gets the calendar's date.
            getDate: function () {
                if (this.selectedDate == undefined)
                    return new Date();

                return this.selectedDate;
            },

            getValue: function () {
                if (this.value == undefined)
                    return new Date();

                return this.value.dateTime;
            },

            setRange: function (from, to) {
                if (this.canRender == false) {
                    this.canRender = true;
                    this.render();
                }

                this.navigateTo(from, 'api');
                this._selectDate(from, 'mouse');
                this._selectDate(to, 'mouse');
            },

            getRange: function () {
                return this.selection;
            },

            // selects a date.
            // @param - Date
            _selectDate: function (date, type, shift) {
                if (this.selectionMode == 'none')
                    return;

                if (type == null || type == undefined) type = 'none';
                if (shift == null || shift == undefined) shift = false;

                var monthInstance = $.data(this.element, "View" + this.element.id);
                if (monthInstance == undefined || monthInstance == null)
                    return;

                if (this.changing) {
                    if (date && this.selectedDate) {
                        if (this.selectedDate.getFullYear() != date.getFullYear() || this.selectedDate.getDate() != date.getDate() || this.selectedDate.getMonth() != date.getMonth())
                            var newDate = this.changing(this.selectedDate, date);
                        if (newDate) {
                            date = newDate;
                        }
                    }
                }

                var self = this;
                if (this.input) {
                    if (date != null) {
                        this.input.val(date.toString());
                    }
                    else this.input.val("");
                }
                var oldDate = this.selectedDate;
                this.selectedDate = date;

                if (this.view != "month") {
                    if (oldDate != date) {
                        this._raiseEvent(7, { selectionType: type });
                    }

                    $.each(this.renderedCells, function (index) {
                        var cell = this;
                        var cellDate = cell.getDate();
                        var cellElement = $(cell.element);
                        var cellContent = cellElement.find("#cellContent" + cellElement[0].id);
                        if (date == null) {
                            cell.isSelected = false;
                            cell.isDisabled = false;
                        }
                        else {
                            cell.isSelected = false;
                            if (cellDate) {
                                if ((cellDate.getMonth() == date.getMonth() && self.view == "year" && cellDate.getFullYear() == date.getFullYear()) || (self.view == "decade" && cellDate.getFullYear() == date.getFullYear())) {
                                    cell.isSelected = true;
                                    try {
                                        if (type != "none") {
                                            cell.element.focus();
                                        }
                                    }
                                    catch (error) {
                                    }
                                }
                            }
                        }
                        self._applyCellStyle(cell, cellElement, cellElement);
                    });
                    if (this.change) {
                        this.change(date);
                    }
                    return;
                }

                if (this.view == "month") {
                    if (this.selectionMode == "range" && type == "key") {
                        var visibleDate = this.getVisibleDate();
                        var firstDay = this.getFirstDayOfWeek(visibleDate);
                        this.refreshCalendarCells(this.month, firstDay, "View" + this.element.id);
                    }
                }

                var cellDisabledDefault = false;

                $.each(this.renderedCells, function (index) {
                    var cell = this;
                    var cellDate = cell.getDate();
                    var cellElement = $(cell.element);
                    var cellContent = cellElement;
                    if (cellElement.length == 0)
                        return false;


                    if (date == null) {
                        cell.isSelected = false;
                        cell.isDisabled = false;
                        if (index == 0) {
                            self.selection = { from: null, to: null };
                            self._raiseEvent('2');
                            self._raiseEvent('5', { selectionType: type });
                        }
                    }
                    else {
                        if (self.selectionMode != 'range' || type == 'key') {
                            if (cellDate.getDate() == date.getDate() && cellDate.getMonth() == date.getMonth() && cellDate.getFullYear() == date.getFullYear() && cell.isSelected) {
                                self._applyCellStyle(cell, cellElement, cellContent);
                                self._raiseEvent('5', { selectionType: type });
                                return;
                            }

                            if (cell.isSelected) {
                                self._raiseEvent('6', { selectionType: type });
                            }

                            cell.isSelected = false;
                            if (cellDate.getDate() == date.getDate() && cellDate.getMonth() == date.getMonth() && cellDate.getFullYear() == date.getFullYear()) {
                                cell.isSelected = true;
                                if (index == 0) {
                                    self.selection = { date: date };
                                }
                                try {
                                    if (type != "none") {
                                        cell.element.focus();
                                        self.host.focus();
                                    }
                                }
                                catch (error) {
                                }

                                if (!cell.isOtherMonth) {
                                    self.value._setMonth(date.getMonth() + 1);
                                    self.value._setDay(date.getDate());
                                    self.value._setYear(date.getFullYear());
                                    self._raiseEvent('2');
                                    self._raiseEvent('5', { selectionType: type });
                                }
                            }
                            if (self.selectionMode == 'range') {
                                self._clicks = 0;
                                self.selection = { from: date, to: date };
                            }
                        }
                        else if (self.selectionMode == 'range') {
                            if (type == "view") {
                                cell.isSelected = false;
                                cell.isDisabled = false;
                                if (self.getMaxDate() < cellDate) {
                                    cell.isDisabled = true;
                                }
                                if (self.getMinDate() > cellDate) {
                                    cell.isDisabled = true;
                                }

                                if (self._isRestrictedDate(cellDate)) {
                                    cell.isDisabled = true;
                                    cell.isRestricted = true;
                                }

                                if (!cell.isDisabled && self._isDisabled(cellDate)) {
                                    cell.isDisabled = true;
                                }

                                self._applyCellStyle(cell, cellElement, cellContent);
                                return true;
                            }

                            if (index == 0) {
                                if (type != 'none') {
                                    if (self._clicks == undefined) self._clicks = 0;
                                    self._clicks++;
                                    if (shift) {
                                        self._clicks++;
                                    }

                                    if (self._clicks == 1) {
                                        self.selection = { from: date, to: date };
                                    }
                                    else {
                                        var from = self.selection.from;
                                        var min = from <= date ? from : date;
                                        var max = from <= date ? date : from;
                                        if (min) {
                                            var start = new Date(min.getFullYear(), min.getMonth(), min.getDate());
                                        }
                                        if (max) {
                                            var end = new Date(max.getFullYear(), max.getMonth(), max.getDate(), 23, 59, 59);
                                        }
                                        self.selection = { from: start, to: end };
                                        self._clicks = 0;
                                    }
                                }
                                else {
                                    if (self.selection == null || self.selection.from == null) {
                                        self.selection = { from: date, to: date };
                                        if (self._clicks == undefined) self._clicks = 0;
                                        self._clicks++;
                                        if (self._clicks == 2) self._clicks = 0;
                                    }
                                }
                            }

                            var getDatePart = function (date) {
                                if (date == null) {
                                    return new Date();
                                }

                                var newDate = new Date();
                                newDate.setHours(0, 0, 0, 0);
                                newDate.setFullYear(date.getFullYear(), date.getMonth(), date.getDate());
                                return newDate;
                            }

                            if (!cell.isOtherMonth && getDatePart(cellDate).toString() == getDatePart(date).toString()) {
                                self.value._setMonth(date.getMonth() + 1);
                                self.value._setDay(date.getDate());
                                self.value._setYear(date.getFullYear());
                                self._raiseEvent('2');
                                self._raiseEvent('5', { selectionType: type });
                            }
                            cell.isSelected = false;
                            cell.isDisabled = cellDisabledDefault;

                            if (getDatePart(cellDate) < getDatePart(self.selection.from) && self._clicks == 1) {
                                cell.isDisabled = true;
                            }
                            if (self.getMaxDate() < cellDate) {
                                cell.isDisabled = true;
                            }
                            if (self.getMinDate() > cellDate) {
                                cell.isDisabled = true;
                            }

                            if (self._isRestrictedDate(cellDate)) {
                                cell.isRestricted = true;
                                cell.isDisabled = true;
                            }

                            if (!cell.isDisabled && self._isDisabled(cellDate)) {
                                cell.isDisabled = true;
                            }

                            if (!cell.isDisabled) {
                                if (getDatePart(cellDate) >= getDatePart(self.selection.from) && getDatePart(cellDate) <= getDatePart(self.selection.to)) {
                                    cell.isSelected = true;
                                }
                            }
                            else if (!self.allowRestrictedDaysInRange && getDatePart(cellDate) >= getDatePart(self.selection.from) && self.selection.to == self.selection.from) {
                                // disable all cells after the first non-selectable cell in the sequence
                                cellDisabledDefault = true;
                            }
                        }
                    }

                    self._applyCellStyle(cell, cellElement, cellContent);
                });

                if (self.selectionMode == "range" && self._clicks == 0) {
                    self._raiseEvent(7, { selectionType: type });
                    return;
                }
                else if (self.selectionMode == "range")
                    return;

                if (oldDate != date) {
                    self._raiseEvent(7, { selectionType: type });
                    if (this.change) {
                        this.change(date);
                    }
                }
            },

            // gets the selected date.
            _getSelectedDate: function () {
                var monthInstance = $.data(this.element, "View" + this.element.id);
                if (monthInstance == undefined || monthInstance == null)
                    return;

                if (this.view != "month")
                    return this.selectedDate;

                for (var i = 0; i < monthInstance.cells.length; i++) {
                    var cell = monthInstance.cells[i];
                    var cellDate = cell.getDate();
                    if (cell.isSelected) {
                        return cellDate;
                    }
                }
                if (this.selectedDate) {
                    return this.selectedDate;
                }
            },

            // gets the selected cell.
            _getSelectedCell: function () {
                var monthInstance = $.data(this.element, "View" + this.element.id);
                if (monthInstance == undefined || monthInstance == null)
                    return;

                for (var i = 0; i < monthInstance.cells.length; i++) {
                    var cell = monthInstance.cells[i];
                    var cellDate = cell.getDate();
                    if (cell.isSelected) {
                        return cell;
                    }
                }
            },

            _applyCellStyle: function (cell, cellElement, cellContent) {
                var self = this;
                if (cellContent == null || (cellContent != null && cellContent.length == 0)) {
                    cellContent = cellElement;
                }

                var cssClassName = "";
                cssClassName = this.toThemeProperty("jqx-rc-all");
                cssClassName += " " + this.toThemeProperty("jqx-item");
                if (this.disabled || (cell.isDisabled && !cell.isRestricted)) {
                    cssClassName += " " + this.toThemeProperty("jqx-calendar-cell-disabled");
                    cssClassName += " " + this.toThemeProperty("jqx-fill-state-disabled");
                }

                if (!this.disabled && cell.isRestricted) {
                    cssClassName += " " + this.toThemeProperty("jqx-calendar-cell-restrictedDate");
                }

                if (cell.isOtherMonth && this.enableOtherMonthDays && cell.isVisible) {
                    cssClassName += " " + this.toThemeProperty("jqx-calendar-cell-othermonth");
                }

                if (cell.isWeekend && this.enableWeekend && cell.isVisible && cell.isVisible) {
                    cssClassName += " " + this.toThemeProperty("jqx-calendar-cell-weekend");
                }

                if (this.isMaterialized()) {
                    cssClassName += " ripple";
                }

                if (!cell.isVisible) {
                    cssClassName += " " + this.toThemeProperty("jqx-calendar-cell-hidden");
                }
                else {
                    cssClassName += " " + this.toThemeProperty("jqx-calendar-cell");
                    if (this.view != "month") {
                        if (cellContent.length > 0 && cellContent.html().toLowerCase().indexOf('span') != -1) {
                            cellContent.css('cursor', 'default');
                        }
                    }
                }

                cellContent.removeAttr('aria-selected');
                if (cell.isSelected && cell.isVisible) {
                    cssClassName += " " + this.toThemeProperty("jqx-calendar-cell-selected");
                    cssClassName += " " + this.toThemeProperty("jqx-fill-state-pressed");
                    cellContent.attr('aria-selected', true);
                    this.host.removeAttr("aria-activedescendant").attr("aria-activedescendant", cellContent[0].id);
                    var date = cell.getDate();
                    if (this._isDisabled(date)) {
                        cssClassName += " " + this.toThemeProperty("jqx-calendar-cell-selected-invalid");
                    }
                }

                if (cell.isHighlighted && cell.isVisible && this.enableHover) {
                    if (!cell.isDisabled) {
                        cssClassName += " " + this.toThemeProperty("jqx-calendar-cell-hover");
                        cssClassName += " " + this.toThemeProperty("jqx-fill-state-hover");
                    }
                }

                cssClassName += " " + this.toThemeProperty("jqx-calendar-cell-" + this.view);

                if (cell.isToday && cell.isVisible) {
                    cssClassName += " " + this.toThemeProperty("jqx-calendar-cell-today");
                }
                cellContent[0].className = cssClassName;

                if (this.specialDates.length > 0) {
                    var me = this;
                    $.each(this.specialDates, function () {
                        if (this.Class != undefined && this.Class != null && this.Class != '') {
                            cellContent.removeClass(this.Class);
                        }
                        else {
                            cellContent.removeClass(self.toThemeProperty("jqx-calendar-cell-specialDate"));
                        }

                        var date = cell.getDate();

                        if (date.getFullYear() == this.Date.getFullYear() && date.getMonth() == this.Date.getMonth() && date.getDate() == this.Date.getDate()) {
                            if (cell.tooltip == null && this.Tooltip != null) {
                                cell.tooltip = this.Tooltip;
                                if ($(cellContent).jqxTooltip) {
                                    var className = this.Class;
                                    $(cellContent).jqxTooltip({
                                        value: { cell: cell, specialDate: this.Date },
                                        name: me.element.id, content: this.Tooltip, position: 'mouse', theme: me.theme,
                                        opening: function (tooltip) {
                                            if (cellContent.hasClass(self.toThemeProperty("jqx-calendar-cell-specialDate"))) {
                                                return true;
                                            }
                                            if (cellContent.hasClass(className)) {
                                                return true;
                                            }
                                            return false;
                                        }
                                    });
                                }
                            }

                            cellContent.removeClass(self.toThemeProperty("jqx-calendar-cell-othermonth"));
                            cellContent.removeClass(self.toThemeProperty("jqx-calendar-cell-weekend"));

                            if (this.Class == undefined || this.Class == '') {
                                cellContent.addClass(self.toThemeProperty("jqx-calendar-cell-specialDate"));
                                return false;
                            }
                            else {
                                cellContent.addClass(this.Class);
                                return false;
                            }
                        }
                    }
                    );
                }
            },

            _applyCellStyles: function () {
                var monthInstance = $.data(this.element, "View" + this.element.id);
                if (monthInstance == undefined || monthInstance == null)
                    return;

                for (var i = 0; i < monthInstance.cells.length; i++) {
                    var cell = monthInstance.cells[i];
                    var cellElement = $(cell.element);
                    var cellContent = cellElement.find("#cellContent" + cellElement[0].id);
                    if (cellContent.length == 0) cellContent = cellElement;
                    this._applyCellStyle(cell, cellElement, cellContent);
                }
            },

            // gets the week of year by Date.
            getWeekOfYear: function (date) {
                var dateObj = new Date(date.dateTime);
                var dowOffset = this.firstDayOfWeek; //default dowOffset to zero
                var newYear = new Date(dateObj.getFullYear(), 0, 1);
                var day = newYear.getDay() - dowOffset; //the day of week the year begins on
                day = (day >= 0 ? day : day + 7);
                var daynum = Math.floor((dateObj.getTime() - newYear.getTime() -
                    (dateObj.getTimezoneOffset() - newYear.getTimezoneOffset()) * 60000) / 86400000) + 1;
                var weeknum;
                //if the year starts before the middle of a week
                if (day < 4) {
                    weeknum = Math.floor((daynum + day - 1) / 7) + 1;
                    if (weeknum > 52) {
                        var nYear = new Date(dateObj.getFullYear() + 1, 0, 1);
                        var nday = nYear.getDay() - dowOffset;
                        nday = nday >= 0 ? nday : nday + 7;
                        /*if the next year starts before the middle of
                          the week, it is week #1 of that year*/
                        weeknum = nday < 4 ? 1 : 53;
                    }
                }
                else {
                    weeknum = Math.floor((daynum + day - 1) / 7);
                }
                return weeknum;

                //var dayOfYear = date.dayOfYear(date.dateTime) - 1;
                //var week = date.dayOfWeek - (dayOfYear % 7);
                //var offset = ((week - this.firstDayOfWeek) + 14) % 7;
                //return Math.ceil((((dayOfYear + offset) / 7) + 1));
            },

            renderColumnHeader: function (month) {
                if (!this.showDayNames)
                    return;

                var columnHeader = $("<table role='grid' style='border-spacing: 0px; border-collapse: collapse; width: 100%; height: 100%;' cellspacing='0' cellpadding='1'>" +
                    "<tr role='row'>" +
                    "<td role='gridcell'></td>" + "<td role='gridcell'></td>" + "<td role='gridcell'></td>" + "<td role='gridcell'></td>" + "<td role='gridcell'></td>" + "<td role='gridcell'></td>" + "<td role='gridcell'></td>" +
                    "</tr>" +
                    "</table>"
                );
                columnHeader.find('table').addClass(this.toThemeProperty('jqx-reset'));
                columnHeader.find('tr').addClass(this.toThemeProperty('jqx-reset'));
                columnHeader.find('td').css({ background: 'transparent', padding: 1, margin: 0, border: 'none' });
                columnHeader.addClass(this.toThemeProperty("jqx-reset"));
                columnHeader.addClass(this.toThemeProperty("jqx-widget-content"));
                columnHeader.addClass(this.toThemeProperty("jqx-calendar-column-header"));
                this.columnHeader.append(columnHeader);

                var visibleDate = this.getVisibleDate();
                var firstDay = this.getFirstDayOfWeek(visibleDate);
                var dayOfWeek = firstDay.dayOfWeek;
                var weekOfYear = this.getWeekOfYear(firstDay);

                var day = this.firstDayOfWeek;
                var dayNames = this.localization.calendar.days.names;

                var columnHeaderCells = new Array();
                var currentDate = firstDay;
                var cellWidth = (month.width() - this.rowHeaderWidth - 2) / 7;
                if (!this.showWeekNumbers) {
                    cellWidth = (month.width() - 2) / 7;
                }

                for (var i = 0; i < 7; i++) {
                    var dayString = dayNames[day];
                    if (this.rtl) {
                        dayString = dayNames[6 - day];
                    }

                    // Possible values: default, shortest, firstTwoLetters, firstLetter, full
                    switch (this.dayNameFormat) {
                        case 'default':
                            dayString = this.localization.calendar.days.namesAbbr[day];
                            if (this.rtl) {
                                dayString = this.localization.calendar.days.namesAbbr[6 - day];
                            }
                            break;
                        case 'shortest':
                            dayString = this.localization.calendar.days.namesShort[day];
                            if (this.rtl) {
                                dayString = this.localization.calendar.days.namesShort[6 - day];
                            }
                            break;
                        case 'firstTwoLetters':
                            dayString = dayString.substring(0, 2);
                            break;
                        case 'firstLetter':
                            dayString = dayString.substring(0, 1);
                            break;
                    }

                    var cell = new $.jqx._jqxCalendar.cell(currentDate.dateTime);
                    var r = i + 1;

                    var cellID = r + this.element.id;
                    var cellElement = $(columnHeader[0].rows[0].cells[i]);

                    var oldI = i;

                    if (this.enableTooltips) {
                        if ($(cellElement).jqxTooltip) {
                            $(cellElement).jqxTooltip({
                                name: this.element.id, content: dayNames[day], theme: this.theme, position: 'mouse'
                            });
                        }
                    }

                    if (day >= 6) {
                        day = 0;
                    }
                    else {
                        day++;
                    }

                    i = oldI;
                    cell.element = cellElement;
                    cell.row = 0;
                    cell.column = i + 1;
                    var textWidth = this._textwidth(dayString);
                    var cellContent = "<div style='padding: 0; margin: 0; border: none; background: transparent;' id='columnCell" + cellID + "'>" + dayString + "</div>";
                    cellElement.append(cellContent);
                    cellElement.find("#columnCell" + cellID).addClass(this.toThemeProperty('jqx-calendar-column-cell'));
                    cellElement.width(cellWidth);
                    if (this.disabled) {
                        cellElement.find("#columnCell" + cellID).addClass(this.toThemeProperty('jqx-calendar-column-cell-disabled'));
                    }

                    if (textWidth > 0 && cellWidth > 0) {
                        while (textWidth > cellElement.width()) {
                            if (dayString.length == 0)
                                break;

                            dayString = dayString.substring(0, dayString.length - 1);
                            $.jqx.utilities.html(cellElement.find("#columnCell" + cellID), dayString);
                            textWidth = this._textwidth(dayString);
                        }
                    }

                    columnHeaderCells[i] = cell;
                    currentDate = new $.jqx._jqxDateTimeInput.getDateTime(new Date(currentDate._addDays(1)));
                }

                if (parseInt(this.columnHeader.width()) > parseInt(this.month.width())) {
                    this.columnHeader.width(this.month.width())
                }

                var monthInstance = $.data(this.element, month[0].id);
                monthInstance.columnCells = columnHeaderCells;
            },

            _format: function (date, format, culture) {
                var globalize = false;
                try {
                    if (window.Globalize != undefined) {
                        globalize = true;
                    }
                    else if (document.Globalize) {
                        window.Globalize = document.Globalize;
                        globalize = true;
                    }
                }
                catch (error) {
                    if (document.Globalize) {
                        window.Globalize = document.Globalize;
                        globalize = true;
                    }
                }
                if (document.Globalize) {
                    window.Globalize = document.Globalize;
                    globalize = true;
                }

                if ($.global) {
                    $.global.culture.calendar = this.localization.calendar;
                    return $.global.format(date, format, this.culture);
                }
                else if (globalize) {
                    try {
                        if (window.Globalize.cultures[this.culture]) {
                            window.Globalize.cultures[this.culture].calendar = this.localization.calendar;
                            return window.Globalize.format(date, format, this.culture);
                        }
                        else {
                            return window.Globalize.format(date, format, this.culture);
                        }
                    }
                    catch (error) {
                        return window.Globalize.format(date, format);
                    }
                }
                else if ($.jqx.dataFormat) {
                    return $.jqx.dataFormat.formatdate(date, format, this.localization.calendar);
                }
            },

            _textwidth: function (text) {
                var measureElement = $('<span>' + text + '</span>');
                measureElement.addClass(this.toThemeProperty('jqx-calendar-column-cell'));
                $(this.host).append(measureElement);
                var width = measureElement.width();
                measureElement.remove();
                return width;
            },

            _textheight: function (text) {
                var measureElement = $('<span>' + text + '</span>');
                $(this.host).append(measureElement);
                var height = measureElement.height();
                measureElement.remove();
                return height;
            },

            _renderRowHeader: function (month) {
                var visibleDate = this.getVisibleDate();
                var firstDay = this.getFirstDayOfWeek(visibleDate);
                var dayOfWeek = firstDay.dayOfWeek;
                var weekOfYear = this.getWeekOfYear(firstDay);
                var newDate = new $.jqx._jqxDateTimeInput.getDateTime(new Date(firstDay.dateTime));
                newDate._addDays(5);
                newDate.dayOfWeek = newDate.dateTime.getDay();
                var newWeekOfYear = this.getWeekOfYear(newDate);
                if (53 == weekOfYear && newDate.dateTime.getMonth() == 0)
                    weekOfYear = 1;

                var rowHeader = $("<table style='overflow: hidden; width: 100%; height: 100%;' cellspacing='0' cellpadding='1'>" +
                    "<tr>" +
                    "<td></td>" +
                    "</tr>" +
                    "<tr>" +
                    "<td/>" +
                    "</tr>" +
                    "<tr>" +
                    "<td/>" +
                    "</tr>" +
                    "<tr>" +
                    "<td/>" +
                    "</tr>" +
                    "<tr>" +
                    "<td/>" +
                    "</tr>" +
                    "<tr>" +
                    "<td/>" +
                    "</tr>" +
                    "</table>"
                );

                rowHeader.find('table').addClass(this.toThemeProperty('jqx-reset'));
                rowHeader.find('td').addClass(this.toThemeProperty('jqx-reset'));
                rowHeader.find('tr').addClass(this.toThemeProperty('jqx-reset'));
                rowHeader.addClass(this.toThemeProperty("jqx-calendar-row-header"));
                rowHeader.width(this.rowHeaderWidth);
                this.rowHeader.append(rowHeader);

                var currentDate = firstDay;
                var rowHeaderCells = new Array();

                for (var i = 0; i < 6; i++) {
                    var weekString = weekOfYear.toString();
                    var cell = new $.jqx._jqxCalendar.cell(currentDate.dateTime);
                    var cellID = i + 1 + this.element.id;
                    var cellElement = $(rowHeader[0].rows[i].cells[0]);
                    cell.element = cellElement;
                    cell.row = i;
                    cell.column = 0;
                    var cellContent = "<div style='background: transparent; border: none; padding: 0; margin: 0;' id ='headerCellContent" + cellID + "'>" + weekString + "</div>";
                    cellElement.append(cellContent);
                    cellElement.find("#headerCellContent" + cellID).addClass(this.toThemeProperty('jqx-calendar-row-cell'));
                    rowHeaderCells[i] = cell;
                    currentDate = new $.jqx._jqxDateTimeInput.getDateTime(new Date(currentDate._addWeeks(1)));
                    weekOfYear = this.getWeekOfYear(currentDate);
                }

                var monthInstance = $.data(this.element, month[0].id);
                monthInstance.rowCells = rowHeaderCells;
            },

            // gets the first week day.
            // @param - Date
            getFirstDayOfWeek: function (visibleDate) {
                var date = visibleDate;

                if (this.firstDayOfWeek < 0 || this.firstDayOfWeek > 6)
                    this.firstDayOfWeek = 6;

                var num = date.dayOfWeek - this.firstDayOfWeek;
                if (num <= 0) {
                    num += 7;
                }

                var newDate = $.jqx._jqxDateTimeInput.getDateTime(date._addDays(-num));
                return newDate;
            },

            // gets the visible date in the current month.
            getVisibleDate: function () {
                var visibleDate = new $.jqx._jqxDateTimeInput.getDateTime(new Date(this.value.dateTime));
                if (visibleDate < this.minDate) {
                    visibleDate = this.minDate;
                }

                if (visibleDate > this.maxDate) {
                    this.visibleDate = this.maxDate;
                }

                visibleDate.dateTime.setHours(0);
                var dayInMonth = visibleDate.day;
                var newVisibleDate = $.jqx._jqxDateTimeInput.getDateTime(visibleDate._addDays(-dayInMonth + 1));
                visibleDate = newVisibleDate;
                return visibleDate;
            },

            destroy: function (removeFromDom) {
                $.jqx.utilities.resize(this.host, null, true);
                this.host
                    .removeClass();

                if (removeFromDom != false) {
                    this.host.remove();
                }
            },

            _raiseEvent: function (id, arg) {
                if (arg == undefined)
                    arg = { owner: null };

                var evt = this.events[id];
                var args = arg ? arg : {};

                args.owner = this;
                var event = new $.Event(evt);
                event.owner = this;
                event.args = args;
                if (id == 0 || id == 1 || id == 2 || id == 3 || id == 4 || id == 5 || id == 6 || id == 7 || id == 8) {
                    event.args.date = event.args.selectedDate = this.getDate();
                    event.args.range = this.getRange();
                    var start = this.getViewStart();
                    var end = this.getViewEnd();
                    event.args.view = { from: start, to: end };
                }

                if (id == 7) {
                    var selectionType = args.selectionType;
                    if (!selectionType) selectionType = null;
                    if (selectionType == "key") {
                        selectionType = "keyboard";
                    }
                    if (selectionType == "none") {
                        selectionType = null;
                    }
                    args.type = selectionType;
                }
                var result = this.host.trigger(event);
                if (id == 0 || id == 1) {
                    result = false;
                }

                return result;
            },

            propertyMap: function (key) {
                if (key == "value") {
                    if (this.selectionMode != 'range') {
                        return this.getDate();
                    }
                    else return this.getRange();
                }
                return null;
            },

            _setSize: function () {
                var month = this.host.find("#View" + this.element.id);
                if (month.length > 0) {

                    this.setCalendarSize();

                    month[0].style.height = "100%";
                    month[0].style.width = "100%";
                    /*if (this.height != undefined && !isNaN(this.height)) {
                        month.height(this.height);
                    }
                    else if (this.height != null && this.height.toString().indexOf("px") != -1) {
                        month.height(this.height);
                    }
    
                    if (this.width != undefined && !isNaN(this.width)) {
                        month.width(this.width);
                    }
                    else if (this.width != null && this.width.toString().indexOf("px") != -1) {
                        month.width(this.width);
                    }*/

                    var contentHeight = this.month.height() - this.titleHeight - this.columnHeaderHeight;
                    var calendarID = "View" + this.element.id;
                    month.find('#cellsTable' + calendarID).height(contentHeight);
                    month.find('#calendarRowHeader' + calendarID).height(contentHeight);
                    this.refreshControl();
                }
            },

            resize: function () {
                this._setSize();
            },

            clear: function () {
                if (this.selectionMode == "range") {
                    this._clicks = 1;
                    this.setRange(null, null);
                    this._raiseEvent(7);
                }
                else {
                    this.setDate(null, 'mouse');
                }
                this._clicks = 0;
                this.selection = { from: null, to: null };
            },

            today: function () {
                if (this.selectionMode == 'range') {
                    this.setRange(new Date(), new Date());
                }
                else {
                    this.setDate(new Date(), 'mouse');
                }
            },

            propertiesChangedHandler: function (object, key, value) {
                if (value.width && value.height && Object.keys(value).length == 2) {
                    object._setSize();
                }
            },

            propertyChangedHandler: function (object, key, oldvalue, value) {
                if (this.isInitialized == undefined || this.isInitialized == false)
                    return;

                if (object.batchUpdate && object.batchUpdate.width && object.batchUpdate.height && Object.keys(object.batchUpdate).length == 2) {
                    return;
                }

                if (key == "enableHover")
                    return;
                if (key == "keyboardNavigation")
                    return;

                if (key == 'localization') {
                    if (this.localization) {
                        if (this.localization.backString) {
                            this.backText = this.localization.backString;
                        }
                        if (this.localization.forwardString) {
                            this.forwardText = this.localization.forwardString;
                        }
                        if (this.localization.todayString) {
                            this.todayString = this.localization.todayString;
                        }
                        if (this.localization.clearString) {
                            this.clearString = this.localization.clearString;
                        }
                        this.firstDayOfWeek = this.localization.calendar.firstDay;
                    }
                }

                if (key == 'culture') {
                    try {
                        if ($.global) {
                            $.global.preferCulture(object.culture);
                            object.localization.calendar = $.global.culture.calendar;
                        }
                        else if (window.Globalize) {
                            var culture = window.Globalize.culture(object.culture);
                            object.localization.calendar = culture.calendar;
                        }
                        if (object.localization.calendar && object.localization.calendar.firstDay != undefined && object.culture != "default") {
                            object.firstDayOfWeek = object.localization.calendar.firstDay;
                        }
                    }
                    catch (error) {
                    }
                }
                if (key == "views") {
                    if (object.views.indexOf('month') == -1) object.view = "year";
                    if (object.views.indexOf('year') == -1 && object.views.indexOf('month') == -1) object.view = "decade";
                    object.render();
                    return;
                }

                if (key == "showFooter") {
                    object.render();
                }
                if (key == 'width' || key == 'height') {
                    object._setSize();
                    return;
                }
                else if (key == 'theme') {
                    $.jqx.utilities.setTheme(oldvalue, value, object.host);
                }
                else if (key == "rowHeaderWidth" || key == "showWeekNumbers") {
                    object.render();
                }
                else {
                    object.view = "month";
                    object.render();
                    object.refreshControl();
                }

                if (key === "firstDayOfWeek") {
                    object.refreshControl();

                }
            }
        });
    })(jqxBaseFramework);

    (function ($) {
        $.jqx._jqxCalendar.cell = function (date) {
            var cell =
            {
                dateTime: new $.jqx._jqxDateTimeInput.getDateTime(date),
                _date: date,
                getDate: function () {
                    return this._date;
                },
                setDate: function (date) {
                    this.dateTime = new $.jqx._jqxDateTimeInput.getDateTime(date);
                    this._date = date;
                },
                isToday: false,
                isWeekend: false,
                isOtherMonth: false,
                isVisible: true,
                isSelected: false,
                isHighlighted: false,
                element: null,
                row: -1,
                column: -1,
                tooltip: null
            };

            return cell;
        } // calendar cell

        $.jqx._jqxCalendar.monthView = function (startDate, endDate, cells, rowHeaderCells, columnHeaderCells, element) {
            var month =
            {
                start: startDate,
                end: endDate,
                cells: cells,
                rowCells: rowHeaderCells,
                columnCells: columnHeaderCells,
                element: element
            };

            return month;
        } // calendar month

    })(jqxBaseFramework);
})();



/***/ }),

/***/ 4545:
/***/ (() => {

/* tslint:disable */
/* eslint-disable */
(function(){
	if (typeof document === 'undefined') { 
		return;
	}
(function ($) {

    $.jqx.jqxWidget("jqxCheckBox", "", {});

    $.extend($.jqx._jqxCheckBox.prototype, {
        defineInstance: function () {
            var settings = {
                // Type: Number
                // Default: 250
                // Gets or sets the delay of the fade animation when the CheckBox is going to be opened.
                animationShowDelay: 300,
                // Type: Number
                // Default: 300
                // Gets or sets the delay of the fade animation when the CheckBox is going to be closed. 
                animationHideDelay: 300,
                // Type: Number.
                // Default: null.
                // Sets the width.
                width: null,
                // Type: Number.
                // Default: null.
                // Sets the height.
                height: null,
                // Type: String
                // Default: '16px'
                // Gets or sets the checkbox's size.
                boxSize: '16px',
                // Type: Bool and Null
                // Default: false
                // Gets or sets the ckeck state.
                // Possible Values: true, false and null.
                checked: false,
                // Type: Bool
                // Default: false
                // Gets or sets whether the checkbox has 3 states - checked, unchecked and indeterminate.
                hasThreeStates: false,
                // Type: Bool
                // Default: false
                // Gets whether the CheckBox is disabled.
                disabled: false,
                // Type: Bool
                // Default: true
                // Gets or sets whether the clicks on the container are handled as clicks on the check box.
                enableContainerClick: true,
                // Type: Bool
                // Default: true
                // Gets or sets whether the checkbox is locked. In this mode the user is not allowed to check/uncheck the checkbox.
                locked: false,
                // Type: String
                // Default: ''
                // Gets or sets the group name. When this property is set, the checkboxes in the same group behave as radio buttons.
                groupName: '',
                keyboardCheck: true,
                enableHover: true,
                hasInput: true,
                rtl: false,
                updated: null,
                disabledContainer: false,
                changeType: null,
                _canFocus: true,
                rippleEffect: true,
                aria:
                {
                    "aria-checked": { name: "checked", type: "boolean" },
                    "aria-disabled": { name: "disabled", type: "boolean" }
                },
                // 'checked' is triggered when the checkbox is checked.
                // 'unchecked' is triggered when the checkbox is unchecked.
                // 'indeterminate' is triggered when the checkbox's ckecked property is going to be null.
                // 'change' is triggered when the checkbox's state is changed.
                events:
                    [
                        'checked', 'unchecked', 'indeterminate', 'change'
                    ]
            };
            if (this === $.jqx._jqxCheckBox.prototype) {
                return settings;
            }
            $.extend(true, this, settings);
            return settings;
        },

        createInstance: function (args) {
            var that = this;
            that._createFromInput("CheckBox");
            that.render();
        },

        _createFromInput: function (name) {
            var that = this;
            if (that.element.nodeName.toLowerCase() == "input") {
                that.field = that.element;
                if (that.field.className) {
                    that._className = that.field.className;
                }

                var properties = {
                    'title': that.field.title
                };

                if (that.field.value) {
                    properties.value = that.field.value;
                }
                if (that.field.checked) {
                    properties.checked = true;
                }
                if (that.field.id.length) {
                    properties.id = that.field.id.replace(/[^\w]/g, '_') + "_" + name;
                }
                else {
                    properties.id = $.jqx.utilities.createId() + "_" + name;
                }

                var textField = that.element.nextSibling;
                var hasTextField = false;
                if (textField && (textField.nodeName == "#text" || textField.nodeName == "span")) {
                    hasTextField = true;
                }
                var offsetWidth = 0;
                var wrapper = $("<div></div>", properties);
                if (hasTextField) {
                    wrapper.append(textField);
                    var f = $("<span>" + $(textField).text() + "</span>");
                    f.appendTo($(document.body))
                    offsetWidth += f.width();
                    f.remove();
                }
                wrapper[0].style.cssText = that.field.style.cssText;
                if (!that.width) {
                    that.width = $(that.field).width() + offsetWidth + 10;
                }
                if (!that.height) {
                    that.height = $(that.field).outerHeight() + 10;
                }
                $(that.field).hide().after(wrapper);
                var data = that.host.data();
                that.host = wrapper;
                that.host.data(data);
                that.element = wrapper[0];
                that.element.id = that.field.id;
                that.field.id = properties.id;
                if (that._className) {
                    that.host.addClass(that._className);
                    $(that.field).removeClass(that._className);
                }

                if (that.field.tabIndex) {
                    var tabIndex = that.field.tabIndex;
                    that.field.tabIndex = -1;
                    that.element.tabIndex = tabIndex;
                }
            }
        },

        _addInput: function () {
            if (this.hasInput) {
                if (this.input) this.input.remove();
                var name = this.host.attr('name');
                this.input = $("<input type='hidden'/>");
                this.host.append(this.input);
                if (name) {
                    this.input.attr('name', name);
                }
                this.input.val(this.checked);

                this.host.attr('role', 'checkbox');
                $.jqx.aria(this);
            }
        },

        render: function () {
            this.init = true;
            var me = this;
            this.setSize();
            this.propertyChangeMap['width'] = function (instance, key, oldVal, value) {
                me.setSize();
            };

            this.propertyChangeMap['height'] = function (instance, key, oldVal, value) {
                me.setSize();
            };
            this._removeHandlers();

            if (!this.width) this.host.css('overflow-x', 'visible');
            if (!this.height) this.host.css('overflow-y', 'visible');

            if (this.checkbox) {
                this.checkbox.remove();
                this.checkbox = null;
            }
            if (this.checkMark) {
                this.checkMark.remove();
                this.checkMark = null;
            }
            if (this.box) {
                this.box.remove();
                this.box = null;
            }
            if (this.clear) {
                this.clear.remove();
                this.clear = null;
            }

            if (this.boxSize == null) this.boxSize = 16;
            var boxSize = parseInt(this.boxSize) + 'px';
            var checkSize = "16px";
            var ml = Math.floor((parseInt(this.boxSize) - 16) / 2);
            var mt = ml;
            ml += "px";
            mt += "px";
            if (parseInt(this.boxSize) != 16) {
                this.checkbox = $('<div><div style="width: ' + boxSize + '; height: ' + boxSize + ';"><span style="position: relative; left: ' + ml + '; top: ' + mt + '; width: ' + checkSize + '; height: ' + checkSize + ';"></span></div></div>');
            }
            else {
                this.checkbox = $('<div><div style="width: ' + boxSize + '; height: ' + boxSize + ';"><span style="width: ' + boxSize + '; height: ' + boxSize + ';"></span></div></div>');
            }

            this.host.prepend(this.checkbox);
            if (!this.disabledContainer) {
                if (!this.host.attr('tabIndex')) {
                    this.host.attr('tabIndex', 0);
                }
                this.clear = $('<div style="clear: both;"></div>');
                this.host.append(this.clear);
            }

            this.checkMark = $(this.checkbox[0].firstChild.firstChild);//$(this.checkbox).find('span');
            this.box = this.checkbox;

            this.box.addClass(this.toThemeProperty('jqx-checkbox-default') + " " + this.toThemeProperty('jqx-fill-state-normal') + " " + this.toThemeProperty('jqx-rc-all'));

            if (this.disabled) {
                this.disable();
            }

            if (!this.disabledContainer) {
                this.host.addClass(this.toThemeProperty('jqx-widget'));
                this.host.addClass(this.toThemeProperty('jqx-checkbox'));
            }

            if (this.locked && !this.disabledContainer) {
                this.host.css('cursor', 'auto');
            }

            var checked = this.element.getAttribute('checked');
            if (checked == 'checked' || checked == 'true' || checked == true) {
                this.checked = true;
            }

            this._addInput();
            this._render();
            this._addHandlers();
            this.init = false;
            this._centerBox();

            if (this.isMaterialized()) {
                if (this.rippleEffect) {
                    $(this.checkbox).addClass('ripple');
                    $.jqx.ripple($(this.checkbox), this.host, "checkbox");
                }
            }
        },

        _centerBox: function () {
            if (this.height && this.height.toString().indexOf("%") == -1 && this.box) {
                var hostHeight = parseInt(this.height);
                this.host.css('line-height', hostHeight + "px");
                var top = hostHeight - parseInt(this.boxSize) - 1;
                top /= 2;
                this.box.css('margin-top', parseInt(top));
            }
        },

        refresh: function (initialRefresh) {
            if (!initialRefresh) {
                this.setSize();
                this._render();
            }
        },

        resize: function (width, height) {
            this.width = width;
            this.height = height;
            this.refresh();
        },

        setSize: function () {
            if (this.width != null && this.width.toString().indexOf("px") != -1) {
                this.host.width(this.width);
            }
            else if (this.width != undefined && !isNaN(this.width)) {
                this.host.width(this.width);
            }
            else if (this.width != null && this.width.toString().indexOf("%") != -1) {
                this.element.style.width = this.width;
            }

            if (this.height != null && this.height.toString().indexOf("px") != -1) {
                this.host.height(this.height);
            }
            else if (this.height != undefined && !isNaN(this.height)) {
                this.host.height(this.height);
            }
            else if (this.height != null && this.height.toString().indexOf("%") != -1) {
                this.element.style.height = this.height;
            }
            this._centerBox();
        },

        _addHandlers: function () {
            var me = this;

            var isTouchDevice = $.jqx.mobile.isTouchDevice();
            var eventName = 'mousedown';
            if (isTouchDevice) eventName = $.jqx.mobile.getTouchEventName('touchend');

            this.addHandler(this.box, eventName, function (event) {
                if (!me.disabled && !me.enableContainerClick && !me.locked) {
                    me.changeType = "mouse";
                    me.toggle();
                    if (me.updated) {
                        event.owner = me;
                        me.updated(event, me.checked, me.oldChecked);
                    }
                    if (event.preventDefault) {
                        event.preventDefault();
                    }
                    return false;
                }
            });

            if (!this.disabledContainer) {
                this.addHandler(this.host, 'keydown', function (event) {
                    if (!me.disabled && !me.locked && me.keyboardCheck) {
                        if (event.keyCode == 32) {
                            if (!me._canFocus) {
                                return true;
                            }
                            me.changeType = "keyboard";
                            me.toggle();
                            if (me.updated) {
                                event.owner = me;
                                me.updated(event, me.checked, me.oldChecked);
                            }
                            if (event.preventDefault) {
                                event.preventDefault();
                            }
                            return false;
                        }
                    }
                });

                this.addHandler(this.host, eventName, function (event) {
                    if (!me.disabled && me.enableContainerClick && !me.locked) {
                        me.clickTime = new Date();
                        me.changeType = "mouse";
                        me.toggle();
                        if (event.preventDefault) {
                            event.preventDefault();
                        }
                        if (me._canFocus) {
                            me.focus();
                        }
                        return false;
                    }
                });

                this.addHandler(this.host, 'selectstart', function (event) {
                    if (!me.disabled && me.enableContainerClick) {
                        if (event.preventDefault) {
                            event.preventDefault();
                        }
                        return false;
                    }
                });

                this.addHandler(this.host, 'mouseup', function (event) {
                    if (!me.disabled && me.enableContainerClick) {
                        if (event.preventDefault) {
                            event.preventDefault();
                        }
                    }
                });

                this.addHandler(this.host, 'focus', function (event) {
                    if (!me.disabled && !me.locked) {
                        if (!me._canFocus) {
                            return true;
                        }

                        if (me.enableHover) {
                            me.box.addClass(me.toThemeProperty('jqx-checkbox-hover'));
                        }
                        me.box.addClass(me.toThemeProperty('jqx-fill-state-focus'));
                        if (event.preventDefault) {
                            event.preventDefault();
                        }

                        $(me.checkbox).removeClass('active');
                        if (!me.clickTime || (me.clickTime && (new Date() - me.clickTime > 300))) {
                            $(me.checkbox).addClass('active');
                        }

                        me.hovered = true;
                        return false;
                    }
                });

                this.addHandler(this.host, 'blur', function (event) {
                    $(me.checkbox).removeClass('active');

                    if (!me.disabled && !me.locked) {
                        if (!me._canFocus) {
                            return true;
                        }
                        if (me.enableHover) {
                            me.box.removeClass(me.toThemeProperty('jqx-checkbox-hover'));
                        }
                        me.box.removeClass(me.toThemeProperty('jqx-fill-state-focus'));
                        if (event.preventDefault) {
                            event.preventDefault();
                        }
                        me.hovered = false;
                        return false;
                    }
                });

                this.addHandler(this.host, 'mouseenter', function (event) {
                    if (me.locked) {
                        me.host.css('cursor', 'arrow')
                    }
                    if (me.enableHover) {
                        if (!me.disabled && me.enableContainerClick && !me.locked) {
                            me.box.addClass(me.toThemeProperty('jqx-checkbox-hover'));
                            me.box.addClass(me.toThemeProperty('jqx-fill-state-hover'));
                            if (event.preventDefault) {
                                event.preventDefault();
                            }
                            me.hovered = true;
                            return false;
                        }
                    }
                });

                this.addHandler(this.host, 'mouseleave', function (event) {
                    if (me.enableHover) {
                        if (!me.disabled && me.enableContainerClick && !me.locked) {
                            me.box.removeClass(me.toThemeProperty('jqx-checkbox-hover'));
                            me.box.removeClass(me.toThemeProperty('jqx-fill-state-hover'));
                            if (event.preventDefault) {
                                event.preventDefault();
                            }
                            me.hovered = false;
                            return false;
                        }
                    }
                });

                this.addHandler(this.box, 'mouseenter', function () {
                    if (me.locked) {
                        return;
                    }

                    if (!me.disabled && !me.enableContainerClick) {
                        me.box.addClass(me.toThemeProperty('jqx-checkbox-hover'));
                        me.box.addClass(me.toThemeProperty('jqx-fill-state-hover'));
                    }
                });

                this.addHandler(this.box, 'mouseleave', function () {
                    if (!me.disabled && !me.enableContainerClick) {
                        me.box.removeClass(me.toThemeProperty('jqx-checkbox-hover'));
                        me.box.removeClass(me.toThemeProperty('jqx-fill-state-hover'));
                    }
                });
            }
        },

        focus: function () {
            try {
                this.host.focus();
            }
            catch (error) {
            }
        },

        _removeHandlers: function () {
            var isTouchDevice = $.jqx.mobile.isTouchDevice();
            var eventName = 'mousedown';
            if (isTouchDevice) eventName = 'touchend';

            if (this.box) {
                this.removeHandler(this.box, eventName);
                this.removeHandler(this.box, 'mouseenter');
                this.removeHandler(this.box, 'mouseleave');
            }
            this.removeHandler(this.host, eventName);
            this.removeHandler(this.host, 'mouseup');
            this.removeHandler(this.host, 'selectstart');
            this.removeHandler(this.host, 'mouseenter');
            this.removeHandler(this.host, 'mouseleave');
            this.removeHandler(this.host, 'keydown');
            this.removeHandler(this.host, 'blur');
            this.removeHandler(this.host, 'focus');
        },

        _render: function () {
            if (!this.disabled) {
                if (this.enableContainerClick) {
                    this.host.css('cursor', 'pointer');
                }
                else
                    if (!this.init) {
                        this.host.css('cursor', 'auto');
                    }
            }
            else {
                this.disable();
            }
            if (this.rtl) {
                this.box.addClass(this.toThemeProperty('jqx-checkbox-rtl'));
                this.host.addClass(this.toThemeProperty('jqx-rtl'));
            }

            this.updateStates();
            this.host.attr("checked", this.checked);
        },

        _setState: function (checked, locked) {
            if (this.checked != checked) {
                this.checked = checked;
                if (this.checked) {
                    this.checkMark[0].className = this.toThemeProperty('jqx-checkbox-check-checked');
                }
                else if (this.checked == null) {
                    this.checkMark[0].className = this.toThemeProperty('jqx-checkbox-check-indeterminate');
                }
                else {
                    this.checkMark[0].className = "";
                }
            }
            if (locked === false || locked === true)
                this.locked = locked;

            if (checked) {
                this.element.setAttribute('checked', true);
            }
            else {
                this.element.removeAttribute("checked");
            }
        },

        val: function (value) {
            if (arguments.length == 0 || (value != null && typeof (value) == "object")) {
                return this.checked;
            }

            if (typeof value == "string") {
                if (value == "true") this.check();
                if (value == "false") this.uncheck();
                if (value == "") this.indeterminate();
            }
            else {
                if (value == true) this.check();
                if (value == false) this.uncheck();
                if (value == null) this.indeterminate();
            }
            return this.checked;
        },

        // checks the ckeckbox.
        check: function () {
            this.checked = true;
            var me = this;
            this.checkMark.removeClass();
            this.element.setAttribute('checked', true);

            if ($.jqx.browser.msie || this.animationShowDelay == 0) {
                this.checkMark.addClass(this.toThemeProperty('jqx-checkbox-check-checked'));
            }
            else {
                this.checkMark.addClass(this.toThemeProperty('jqx-checkbox-check-checked'));
                this.checkMark.css('opacity', 0);
                this.checkMark.stop().animate({ opacity: 1 }, this.animationShowDelay, function () {
                });
            }

            if (this.groupName != null && this.groupName.length > 0) {
                var checkboxes = $.find(this.toThemeProperty('.jqx-checkbox', true));
                $.each(checkboxes, function () {
                    var groupName = $(this).jqxCheckBox('groupName');
                    if (groupName == me.groupName && this != me.element) {
                        $(this).jqxCheckBox('uncheck')
                    }
                });
            }

            var changeType = this.changeType;

            this._raiseEvent('0', { checked: true });
            this.changeType = changeType;
            this._raiseEvent('3', { checked: true });
            if (this.input != undefined) {
                this.input.val(this.checked);
                $.jqx.aria(this, "aria-checked", this.checked);
                this.host.attr("checked", this.checked);
            }
        },

        // unchecks the checkbox.
        uncheck: function () {
            this.checked = false;
            var me = this;

            this.element.removeAttribute('checked');

            if ($.jqx.browser.msie || this.animationHideDelay == 0) {
                if (me.checkMark[0].className != "") {
                    me.checkMark[0].className = "";
                }
            }
            else {
                this.checkMark.css('opacity', 1);
                this.checkMark.stop().animate({ opacity: 0 }, this.animationHideDelay, function () {
                    if (me.checkMark[0].className != "") {
                        me.checkMark[0].className = "";
                    }
                });
            }

            var changeType = this.changeType;
            this._raiseEvent('1');
            this.changeType = changeType;
            this._raiseEvent('3', { checked: false });
            if (this.input != undefined) {
                this.input.val(this.checked);
                $.jqx.aria(this, "aria-checked", this.checked);
                this.host.attr("checked", this.checked);
            }
        },

        // sets the indeterminate state.
        indeterminate: function () {
            this.checked = null;
            this.checkMark.removeClass();

            if ($.jqx.browser.msie || this.animationShowDelay == 0) {
                this.checkMark.addClass(this.toThemeProperty('jqx-checkbox-check-indeterminate'));
            }
            else {
                this.checkMark.addClass(this.toThemeProperty('jqx-checkbox-check-indeterminate'));
                this.checkMark.css('opacity', 0);
                this.checkMark.stop().animate({ opacity: 1 }, this.animationShowDelay, function () {
                });
            }

            var changeType = this.changeType;
            this._raiseEvent('2');
            this._raiseEvent('3', { checked: null });
            if (this.input != undefined) {
                this.input.val(this.checked);
                $.jqx.aria(this, "aria-checked", "undefined");
                this.host.attr("checked", "undefined");
            }
        },

        // toggles the check state.
        toggle: function () {
            if (this.disabled)
                return;

            if (this.locked)
                return;

            if (this.groupName != null && this.groupName.length > 0) {
                if (this.checked != true) {
                    this.checked = true;
                    this.updateStates();
                }
                return;
            }

            this.oldChecked = this.checked;
            if (this.checked == true) {
                this.checked = this.hasThreeStates ? null : false;
            }
            else {
                this.checked = this.checked != null;
            }

            this.updateStates();
            if (this.input != undefined) {
                this.input.val(this.checked);
            }
        },

        // updates check states depending on the value of the 'checked' property.
        updateStates: function () {
            if (this.checked) {
                this.check();
            }
            else if (this.checked == false) {
                this.uncheck();
            }
            else if (this.checked == null) {
                this.indeterminate();
            }
        },

        // disables the checkbox.
        disable: function () {
            this.disabled = true;

            if (this.checked == true) {
                this.checkMark.addClass(this.toThemeProperty('jqx-checkbox-check-disabled'));
            }
            else if (this.checked == null) {
                this.checkMark.addClass(this.toThemeProperty('jqx-checkbox-check-indeterminate-disabled'));
            }
            this.box.addClass(this.toThemeProperty('jqx-checkbox-disabled-box'));
            this.host.addClass(this.toThemeProperty('jqx-checkbox-disabled'));
            this.host.addClass(this.toThemeProperty('jqx-fill-state-disabled'));
            this.box.addClass(this.toThemeProperty('jqx-checkbox-disabled'));
            $.jqx.aria(this, "aria-disabled", this.disabled);
        },

        // enables the checkbox.
        enable: function () {
            if (this.checked == true) {
                this.checkMark.removeClass(this.toThemeProperty('jqx-checkbox-check-disabled'));
            }
            else if (this.checked == null) {
                this.checkMark.removeClass(this.toThemeProperty('jqx-checkbox-check-indeterminate-disabled'));
            }
            this.box.removeClass(this.toThemeProperty('jqx-checkbox-disabled-box'));
            this.host.removeClass(this.toThemeProperty('jqx-checkbox-disabled'));
            this.host.removeClass(this.toThemeProperty('jqx-fill-state-disabled'));
            this.box.removeClass(this.toThemeProperty('jqx-checkbox-disabled'));
            this.disabled = false;
            $.jqx.aria(this, "aria-disabled", this.disabled);
        },

        destroy: function () {
            this.host.remove();
        },

        _raiseEvent: function (id, args) {
            if (this.init) return;
            var evt = this.events[id];
            var event = new $.Event(evt);
            event.owner = this;
            if (!args) args = {};
            args.type = this.changeType;
            this.changeType = null;

            event.args = args;

            try {
                var result = this.host.trigger(event);
            }
            catch (error) {

            }

            return result;
        },

        propertiesChangedHandler: function (object, key, value) {
            if (value.width && value.height && Object.keys(value).length == 2) {
                object.setSize();
            }
        },

        propertyChangedHandler: function (object, key, oldvalue, value) {
            if (this.isInitialized == undefined || this.isInitialized == false)
                return;

            if (object.batchUpdate && object.batchUpdate.width && object.batchUpdate.height && Object.keys(object.batchUpdate).length == 2) {
                return;
            }

            if (key == "enableContainerClick" && !object.disabled && !object.locked) {
                if (value) {
                    object.host.css('cursor', 'pointer');
                }
                else object.host.css('cursor', 'auto');
            }

            if (key == "rtl") {
                if (value) {
                    object.box.addClass(object.toThemeProperty('jqx-checkbox-rtl'));
                    object.host.addClass(object.toThemeProperty('jqx-rtl'));
                }
                else {
                    object.box.removeClass(object.toThemeProperty('jqx-checkbox-rtl'));
                    object.host.removeClass(object.toThemeProperty('jqx-rtl'));
                }
            }

            if (key == "boxSize") {
                object.render();
            }

            if (key == 'theme') {
                $.jqx.utilities.setTheme(oldvalue, value, object.host);
            }

            if (key == 'checked') {
                if (value != oldvalue) {
                    switch (value) {
                        case true:
                            object.check();
                            break;
                        case false:
                            object.uncheck();
                            break;
                        case null:
                            object.indeterminate();
                            break;
                    }
                }
            }

            if (key == 'disabled') {
                if (value != oldvalue) {
                    if (value) {
                        object.disable();
                    } else object.enable();
                }
            }
        }
    });
})(jqxBaseFramework);
})();



/***/ }),

/***/ 4720:
/***/ (() => {

/* tslint:disable */
/* eslint-disable */
(function () {
    if (typeof document === 'undefined') {
        return;
    }
    (function ($) {

        $.jqx.jqxWidget("jqxComboBox", "", {});

        $.extend($.jqx._jqxComboBox.prototype, {
            defineInstance: function () {
                var settings = {
                    // enables/disables the combobox.
                    disabled: false,
                    // gets or sets the listbox width.
                    width: 200,
                    // gets or sets the listbox height.
                    height: 25,
                    // Represents the collection of list items.
                    items: new Array(),
                    // Gets or sets the selected index.
                    selectedIndex: -1,
                    selectedItems: new Array(),
                    _selectedItems: new Array(),
                    // data source.
                    source: null,
                    autoItemsHeight: false,
                    // gets or sets the scrollbars size.
                    scrollBarSize: $.jqx.utilities.scrollBarSize,
                    // gets or sets the scrollbars size.
                    arrowSize: 17,
                    // enables/disables the hover state.
                    enableHover: true,
                    // enables/disables the selection.
                    enableSelection: true,
                    // gets the visible items. // this property is internal for the combobox.
                    visualItems: new Array(),
                    // gets the groups. // this property is internal for the combobox.
                    groups: new Array(),
                    // gets or sets whether the items width should be equal to the combobox's width.
                    equalItemsWidth: true,
                    // gets or sets the height of the ListBox Items. When the itemHeight:= - 1, each item's height is equal to its desired height.
                    itemHeight: -1,
                    // represents the combobox's events.
                    visibleItems: new Array(),
                    // emptry group's text.
                    hint: true,
                    emptyGroupText: 'Group',
                    emptyString: "",
                    ready: null,
                    // Type: Number
                    // Default: 100
                    // Showing Popup Animation's delay.
                    openDelay: 250,
                    // Type: Number
                    // Default: 200
                    // Hiding Popup Animation's delay.
                    closeDelay: 300,
                    // default, none
                    // Type: String.
                    // enables or disables the animation.
                    animationType: 'default',
                    // Type: String
                    // Default: auto ( the drop down takes the combobox's width.)
                    // Sets the popup's width.
                    dropDownWidth: 'auto',
                    // Type: String
                    // Default: 200px ( the height is 200px )
                    // Sets the popup's height.
                    dropDownHeight: '200px',
                    // Type: Boolean
                    // Default: false
                    // Sets the popup's height to be equal to the items summary height,
                    autoDropDownHeight: false,
                    // Type: Boolean
                    // Default: false
                    // Enables or disables the browser detection.
                    enableBrowserBoundsDetection: false,
                    dropDownHorizontalAlignment: 'left',
                    dropDownVerticalAlignment: 'bottom',
                    dropDownContainer: "default",
                    // Type: String
                    // Default: startswithignorecase
                    // Possible Values: 'none, 'contains', 'containsignorecase', 'equals', 'equalsignorecase', 'startswithignorecase', 'startswith', 'endswithignorecase', 'endswith'
                    searchMode: 'startswithignorecase',
                    autoComplete: false,
                    remoteAutoComplete: false,
                    remoteAutoCompleteDelay: 500,
                    selectionMode: "default",
                    minLength: 2,
                    displayMember: "",
                    valueMember: "",
                    groupMember: "",
                    searchMember: "",
                    keyboardSelection: true,
                    renderer: null,
                    autoOpen: false,
                    template: "",
                    checkboxes: false,
                    promptText: "",
                    placeHolder: "",
                    rtl: false,
                    listBox: null,
                    validateSelection: null,
                    showCloseButtons: true,
                    renderSelectedItem: null,
                    search: null,
                    popupZIndex: 2000,
                    searchString: null,
                    multiSelect: false,
                    showArrow: true,
                    _disabledItems: new Array(),
                    touchMode: 'auto',
                    autoBind: true,
                    aria:
                    {
                        "aria-disabled": { name: "disabled", type: "boolean" }
                    },
                    events:
                        [
                            // occurs when the combobox is opened.
                            'open',
                            // occurs when the combobox is closed.
                            'close',
                            // occurs when an item is selected.
                            'select',
                            // occurs when an item is unselected.
                            'unselect',
                            // occurs when the selection is changed.
                            'change',
                            // triggered when the user checks or unchecks an item.
                            'checkChange',
                            // triggered when the binding is completed.
                            'bindingComplete',
                            // triggered when a new item is added.
                            'itemAdd',
                            // triggered when a new item is removed.
                            'itemRemove',
                            // triggered when a new item is updated.
                            'itemUpdate'
                        ]
                };
                if (this === $.jqx._jqxComboBox.prototype) {
                    return settings;
                }
                $.extend(true, this, settings);
                return settings;
            },

            createInstance: function (args) {
                var that = this;
                this.host.attr('role', 'combobox');
                this.host.attr('aria-expanded', 'false');
                $.jqx.aria(this, "aria-autocomplete", "both");

                if ($.jqx._jqxListBox == null || $.jqx._jqxListBox == undefined) {
                    throw new Error("jqxComboBox: Missing reference to jqxlistbox.js.");
                }
                $.jqx.aria(this);

                if (that.isMaterialized()) {
                    var elementStyle = window.getComputedStyle(this.element);
                    var animation = elementStyle.getPropertyValue('--jqx-dropdown-animation');
                    var rowHeight = elementStyle.getPropertyValue('--jqx-list-item-height');
                    var arrowSize = elementStyle.getPropertyValue('--jqx-action-button-size');

                    if (arrowSize) {
                        this.arrowSize = parseInt(arrowSize);
                    }
                    else {
                        this.arrowSize = 25;
                    }

                    if (animation && this.animationType == "default") {
                        this.animationType = animation.trim();
                    }

                    if (rowHeight && this.itemHeight === -1) {
                        this.itemHeight = parseInt(rowHeight);
                    }
                }

                // prompt text is deprecated.
                if (this.promptText != "") {
                    this.placeHolder = this.promptText;
                }

                this.render();
            },

            render: function () {
                var that = this;
                var nodeName = that.element.nodeName.toLowerCase();
                if (nodeName == "select" || nodeName == "ul" || nodeName == "ol") {
                    that.field = that.element;
                    if (that.field.className) {
                        that._className = that.field.className;
                    }

                    var properties = {
                        'title': that.field.title
                    };

                    if (that.field.id.length) {
                        properties.id = that.field.id.replace(/[^\w]/g, '_') + "_jqxComboBox";
                    }
                    else {
                        properties.id = $.jqx.utilities.createId() + "_jqxComboBox";
                    }

                    var wrapper = $("<div></div>", properties);
                    if (!that.width) {
                        that.width = $(that.field).width();
                    }
                    if (!that.height) {
                        that.height = $(that.field).outerHeight();
                    }

                    that.element.style.cssText = that.field.style.cssText;
                    $(that.field).hide().after(wrapper);
                    var data = that.host.data();
                    that.host = wrapper;
                    that.host.data(data);
                    that.element = wrapper[0];
                    that.element.id = that.field.id;
                    that.field.id = properties.id;
                    if (that._className) {
                        that.host.addClass(that._className);
                        $(that.field).removeClass(that._className);
                    }

                    if (that.field.tabIndex) {
                        var tabIndex = that.field.tabIndex;
                        that.field.tabIndex = -1;
                        that.element.tabIndex = tabIndex;
                    }
                    if (that.field.innerHTML != "") {
                        var result = $.jqx.parseSourceTag(that.field);
                        that.source = result.items;
                        if (that.selectedIndex == -1)
                            that.selectedIndex = result.index;
                    }
                }
                else {
                    if (that.host.find('li').length > 0 || that.host.find('option').length > 0) {
                        var result = $.jqx.parseSourceTag(that.element);
                        that.source = result.items;
                    }
                }
                that.removeHandlers();
                that.isanimating = false;
                that.id = $.jqx.utilities.createId();
                that.element.innerHTML = "";
                var comboStructure = $("<div style='background-color: transparent; -webkit-appearance: none; outline: none; width:100%; height: 100%; padding: 0px; margin: 0px; border: 0px; position: relative;'>" +
                    "<div id='dropdownlistWrapper' style='padding: 0; margin: 0; border: none; background-color: transparent; float: left; width:100%; height: 100%; position: relative;'>" +
                    "<div id='dropdownlistContent' style='padding: 0; margin: 0; border-top: none; border-bottom: none; float: left; position: absolute;'></div>" +
                    "<div id='dropdownlistArrow' role='button' style='padding: 0; margin: 0; border-left-width: 1px; border-bottom-width: 0px; border-top-width: 0px; border-right-width: 0px; float: right; position: absolute;'></div>" +
                    "</div>" +
                    "</div>");
                that.comboStructure = comboStructure;
                if ($.jqx._jqxListBox == null || $.jqx._jqxListBox == undefined) {
                    throw "jqxComboBox: Missing reference to jqxlistbox.js.";
                }

                that.touch = $.jqx.mobile.isTouchDevice();
                if (that.touchMode === true) {
                    that.touch = true;
                }

                that.host.append(comboStructure);

                that.dropdownlistWrapper = that.host.find('#dropdownlistWrapper');
                that.dropdownlistArrow = that.host.find('#dropdownlistArrow');
                that.dropdownlistContent = that.host.find('#dropdownlistContent');
                that.dropdownlistContent.addClass(that.toThemeProperty('jqx-combobox-content'));
                that.dropdownlistContent.addClass(that.toThemeProperty('jqx-widget-content'));
                that.dropdownlistWrapper[0].id = "dropdownlistWrapper" + that.element.id;
                that.dropdownlistArrow[0].id = "dropdownlistArrow" + that.element.id;
                that.dropdownlistContent[0].id = "dropdownlistContent" + that.element.id;
                if (that.template) {
                    that.dropdownlistArrow.addClass(that.toThemeProperty("jqx-" + that.template + ""));
                }
                that.dropdownlistContent.append($('<input autocomplete="off" autocorrect="off" autocapitalize="off" spellcheck="false" style="box-sizing: border-box; margin: 0; padding: 0; padding-left: 3px; padding-right: 3px; border: 0;" type="textarea"/>'));
                that.input = that.dropdownlistContent.find('input');
                that.input.addClass(that.toThemeProperty('jqx-combobox-input'));
                that.input.addClass(that.toThemeProperty('jqx-widget-content'));
                that.input[0].setAttribute('aria-label', 'input');

                if (that.host.attr('tabindex')) {
                    that.input.attr('tabindex', that.host.attr('tabindex'));
                    that.host.removeAttr('tabindex');
                }


                var label = $("<label></label>");
                if (this.hint) {
                    label[0].innerHTML = this.placeHolder;
                }

                label.addClass(that.toThemeProperty('jqx-input-label'));
                that.dropdownlistWrapper.append(label);
                that.label = label;

                var bar = $("<span></span>");
                that.dropdownlistWrapper.append(bar);
                bar.addClass(that.toThemeProperty('jqx-input-bar'));
                that.bar = bar;

                var that = this;

                if (that.template) {
                    that.bar.addClass(that.toThemeProperty("jqx-" + that.template));
                    that.label.addClass(that.toThemeProperty("jqx-" + that.template));
                }

                that._addInput();
                if (that.rtl) {
                    that.input.css({ direction: "rtl" });
                    that.dropdownlistContent.addClass(that.toThemeProperty('jqx-combobox-content-rtl'));
                }

                try {
                    var listBoxID = 'listBox' + that.id;
                    var oldContainer = $($.find('#' + listBoxID));
                    if (oldContainer.length > 0) {
                        oldContainer.remove();
                    }
                    $.jqx.aria(this, "aria-owns", listBoxID);
                    $.jqx.aria(this, "aria-haspopup", true);
                    if (that.listBoxContainer) that.listBoxContainer.jqxListBox('destroy');
                    if (that.container) that.container.remove();
                    var container = $("<div style='overflow: hidden; border: none; background-color: transparent; position: absolute;' id='listBox" + that.id + "'><div id='innerListBox" + that.id + "'></div></div>");
                    container.hide();
                    if (that.dropDownContainer == "element") {
                        container.appendTo(that.host);
                    }
                    else {
                        container.appendTo(document.body);
                    }
                    container.addClass(that.toThemeProperty('jqx-listbox-container'));

                    that.container = container;
                    that.listBoxContainer = $($.find('#innerListBox' + that.id));

                    var width = that.width;
                    if (that.dropDownWidth != 'auto') {
                        width = that.dropDownWidth;
                    }

                    if (that.dropDownHeight == null) {
                        that.dropDownHeight = 200;
                    }

                    that.container.width(parseInt(width) + 25);
                    that.container.height(parseInt(that.dropDownHeight) + 25);
                    that._ready = false;

                    that.addHandler(that.listBoxContainer, 'bindingComplete', function (event) {
                        if (!that.listBox) {
                            that.listBox = $.data(that.listBoxContainer[0], "jqxListBox").instance;
                        }
                        if (!that._ready) {
                            if (that.ready) {
                                that.ready();
                            }
                            that._ready = true;
                        }
                        that._raiseEvent('6');
                    });
                    that.addHandler(that.listBoxContainer, 'itemAdd', function (event) {
                        that._raiseEvent('7', event.args);
                    });
                    that.addHandler(that.listBoxContainer, 'itemRemove', function (event) {
                        that._raiseEvent('8', event.args);
                    });
                    that.addHandler(that.listBoxContainer, 'itemUpdate', function (event) {
                        that._raiseEvent('9', event.args);
                    });

                    var initializing = true;
                    that.listBoxContainer.jqxListBox({
                        autoItemsHeight: that.autoItemsHeight,
                        _checkForHiddenParent: false, allowDrop: false, allowDrag: false,
                        checkboxes: that.checkboxes, emptyString: that.emptyString, autoBind: !that.remoteAutoComplete && that.autoBind,
                        renderer: that.renderer, rtl: that.rtl, itemHeight: that.itemHeight, selectedIndex: that.selectedIndex, incrementalSearch: false, width: width, scrollBarSize: that.scrollBarSize, autoHeight: that.autoDropDownHeight, height: that.dropDownHeight, groupMember: that.groupMember, searchMember: that.searchMember, displayMember: that.displayMember, valueMember: that.valueMember, source: that.source, theme: that.theme,
                        rendered: function () {
                            that.listBox = $.data(that.listBoxContainer[0], "jqxListBox").instance;
                            if (that.remoteAutoComplete) {
                                if (that.autoDropDownHeight) {
                                    that.container.height(that.listBox.virtualSize.height + 25);
                                    that.listBoxContainer.height(that.listBox.virtualSize.height);
                                    that.listBox._arrange();
                                }
                                else {
                                    that.listBox._arrange();
                                    that.listBox.ensureVisible(0);
                                    that.listBox._renderItems();
                                    that.container.height(that.listBoxContainer.height() + 25);
                                }

                                if (that.searchString != undefined && that.searchString.length >= that.minLength) {
                                    var items = that.listBoxContainer.jqxListBox('items');
                                    if (items) {
                                        if (items.length > 0) {
                                            if (!that.isOpened()) {
                                                that.open();
                                            }
                                        }
                                        else that.close();
                                    } else that.close();
                                }
                                else {
                                    that.close();
                                }
                            }
                            else {
                                that.renderSelection('mouse');
                                if (that.multiSelect) {
                                    that.doMultiSelect(false);
                                }
                            }

                            if (that.rendered) {
                                that.rendered();
                            }
                        }
                    });

                    if (that.dropDownContainer == "element") {
                        that.listBoxContainer.css({ position: 'absolute', top: 0, left: 0 });
                    }
                    else {
                        that.listBoxContainer.css({ position: 'absolute', zIndex: that.popupZIndex, top: 0, left: 0 });
                    }
                    that.listBoxContainer.css('border-top-width', '1px');
                    that.listBoxContainer.addClass(that.toThemeProperty('jqx-popup'));
                    if ($.jqx.browser.msie) {
                        that.listBoxContainer.addClass(that.toThemeProperty('jqx-noshadow'));
                    }
                    if (that.template) {
                        that.listBoxContainer.addClass(that.toThemeProperty("jqx-" + that.template + "-item"));
                    }

                    that.listBox = $.data(that.listBoxContainer[0], "jqxListBox").instance;
                    that.listBox.enableSelection = that.enableSelection;
                    that.listBox.enableHover = that.enableHover;
                    that.listBox.equalItemsWidth = that.equalItemsWidth;
                    that.listBox._arrange();
                    that.addHandler(that.listBoxContainer, 'unselect', function (event) {
                        if (!that.multiSelect) {
                            that._raiseEvent('3', { index: event.args.index, type: event.args.type, item: event.args.item });
                        }
                    });

                    that.addHandler(that.listBoxContainer, 'change', function (event) {
                        if (!that.multiSelect) {
                            that.selectedIndex = that.listBox.selectedIndex;
                            that._raiseEvent('4', { index: event.args.index, type: event.args.type, item: event.args.item });
                        }
                    });

                    if (that.animationType == 'none') {
                        that.container.css('display', 'none');
                    }
                    else {
                        that.container.hide();
                    }
                    initializing = false;
                }
                catch (e) {
                    throw e;
                }


                var that = this;
                that.input.attr('disabled', that.disabled);
                var ie7 = $.jqx.browser.msie && $.jqx.browser.version < 8;
                if (!ie7) {
                    if (that.isMaterialized() && that.hint) {
                        that.label[0].innerHTML = that.placeHolder;
                    }
                    else {
                        that.input.attr('placeholder', that.placeHolder);
                    }
                }

                that.propertyChangeMap['disabled'] = function (instance, key, oldVal, value) {
                    if (value) {
                        instance.host.addClass(that.toThemeProperty('jqx-combobox-state-disabled'));
                        instance.host.addClass(that.toThemeProperty('jqx-fill-state-disabled'));
                        instance.dropdownlistContent.addClass(that.toThemeProperty('jqx-combobox-content-disabled'));
                    }
                    else {
                        instance.host.removeClass(that.toThemeProperty('jqx-combobox-state-disabled'));
                        instance.host.removeClass(that.toThemeProperty('jqx-fill-state-disabled'));
                        instance.dropdownlistContent.removeClass(that.toThemeProperty('jqx-combobox-content-disabled'));
                    }
                    instance.input.attr('disabled', instance.disabled);
                    $.jqx.aria(instance, "aria-disabled", instance.disabled);
                    instance.input.attr('disabled', instance.disabled);
                }

                if (that.disabled) {
                    that.host.addClass(that.toThemeProperty('jqx-combobox-state-disabled'));
                    that.host.addClass(that.toThemeProperty('jqx-fill-state-disabled'));
                    that.dropdownlistContent.addClass(that.toThemeProperty('jqx-combobox-content-disabled'));
                }

                that.host.addClass(that.toThemeProperty('jqx-combobox-state-normal'));
                that.host.addClass(that.toThemeProperty('jqx-combobox'));
                that.host.addClass(that.toThemeProperty('jqx-rc-all'));
                that.host.addClass(that.toThemeProperty('jqx-widget'));
                that.host.addClass(that.toThemeProperty('jqx-widget-content'));
                that.dropdownlistArrowIcon = $("<div></div>");
                if (that.dropDownVerticalAlignment == "top") {
                    that.dropdownlistArrowIcon.addClass(that.toThemeProperty('jqx-icon-arrow-up'));
                }
                else {
                    that.dropdownlistArrowIcon.addClass(that.toThemeProperty('jqx-icon-arrow-down'));
                }
                that.dropdownlistArrowIcon.addClass(that.toThemeProperty('jqx-icon'));
                that.dropdownlistArrow.append(that.dropdownlistArrowIcon);
                that.dropdownlistArrow.addClass(that.toThemeProperty('jqx-combobox-arrow-normal'));
                that.dropdownlistArrow.addClass(that.toThemeProperty('jqx-fill-state-normal'));
                that.dropdownlistArrow[0].setAttribute('aria-label', 'expand');

                if (!that.rtl) {
                    that.dropdownlistArrow.addClass(that.toThemeProperty('jqx-rc-r'));
                }
                else {
                    that.dropdownlistArrow.addClass(that.toThemeProperty('jqx-rc-l'));
                }

                that._setSize();
                that._updateHandlers();

                that.addHandler(that.input, 'paste.textchange', function (event) {
                    if (that._writeTimer) clearTimeout(that._writeTimer);
                    that._writeTimer = setTimeout(function () {
                        that.ctrlKey = false;

                        var foundMatch = that._search(event);
                        if (that.cinput && that.input) {
                            if (!that.displayMember) {
                                that.cinput[0].value = that.input[0].value;
                            }
                            else {
                                that._updateInputSelection();
                            }
                        }
                    }, 50);
                });

                that.addHandler(that.input, 'keyup.textchange', function (event) {
                    if (that._writeTimer) clearTimeout(that._writeTimer);
                    that._writeTimer = setTimeout(function () {
                        var foundMatch = that._search(event);
                        if (that.cinput && that.input) {
                            if (!that.displayMember) {
                                that.cinput[0].value = that.input[0].value;
                            }
                            else {
                                that._updateInputSelection();
                            }
                        }
                    }, 50);
                });

                // fix for IE7
                if ($.jqx.browser.msie && $.jqx.browser.version < 8) {
                    if (that.host.parents('.jqx-window').length > 0) {
                        var zIndex = that.host.parents('.jqx-window').css('z-index');
                        container.css('z-index', zIndex + 10);
                        that.listBoxContainer.css('z-index', zIndex + 10);
                    }
                }

                if (that.checkboxes) {
                    that.input.attr('readonly', true);
                    $.jqx.aria(this, "aria-readonly", true);
                }
                else {
                    $.jqx.aria(this, "aria-readonly", false);
                }
                if (!that.remoteAutoComplete) {
                    that.searchString = "";
                }

                this.bar.css('top', this.host.height());
            },

            _addInput: function () {
                var name = this.host.attr('name');
                this.cinput = $("<input type='hidden'/>");
                this.host.append(this.cinput);
                if (name) {
                    this.cinput.attr('name', name);
                }
            },

            _updateInputSelection: function () {
                if (this.cinput) {
                    var selectedValues = new Array();
                    if (this.selectedIndex == -1) {
                        this.cinput.val("");
                    }
                    else {
                        var selectedItem = this.getSelectedItem();
                        if (selectedItem != null) {
                            this.cinput.val(selectedItem.value);
                            selectedValues.push(selectedItem.value);
                        }
                        else {
                            this.cinput.val(this.dropdownlistContent.text());
                        }
                    }

                    if (this.checkboxes || this.multiSelect) {
                        if (!this.multiSelect) {
                            var items = this.getCheckedItems();
                        }
                        else {
                            var items = this.getSelectedItems();
                        }

                        var str = "";
                        if (items != null) {
                            for (var i = 0; i < items.length; i++) {
                                if (i == items.length - 1) {
                                    str += items[i].value;
                                }
                                else {
                                    str += items[i].value + ",";
                                }
                                selectedValues.push(items[i].value);
                            }
                        }
                        this.cinput.val(str);
                    }
                    if (this.field && this.cinput) {
                        if (this.field.nodeName.toLowerCase() == "select") {
                            $.each(this.field, function (index, value) {
                                $(this).removeAttr('selected');
                                this.selected = selectedValues.indexOf(this.value) >= 0;
                                if (this.selected) {
                                    $(this).attr('selected', true);
                                }
                            });
                        }
                        else {
                            $.each(this.items, function (index, value) {
                                $(this.originalItem.originalItem).removeAttr('data-selected');
                                this.selected = selectedValues.indexOf(this.value) >= 0;
                                if (this.selected) {
                                    $(this.originalItem.originalItem).attr('data-selected', true);
                                }
                            });
                        }
                    }
                }
            },

            _search: function (event) {
                var that = this;

                if (event.keyCode == 9)
                    return;

                if (that.searchMode == 'none' || that.searchMode == null || that.searchMode == 'undefined') {
                    return;
                }

                if (event.keyCode == 16 || event.keyCode == 17 || event.keyCode == 20)
                    return;

                if (that.checkboxes) {
                    return;
                }

                if (that.multiSelect) {
                    var span = $("<span style='visibility: hidden; white-space: nowrap;'>" + document.createTextNode(that.input.val()) + "</span>");
                    span.addClass(that.toThemeProperty('jqx-widget'));
                    $(document.body).append(span);
                    var width = span.width() + 15;
                    span.remove();

                    if (width > that.host.width()) {
                        width = that.host.width();
                    }
                    if (width < 25) {
                        width = 25;
                    }

                    that.input.css('width', width + 'px');
                    if (that.selectedItems.length == 0) {
                        that.input.css('width', '100%');

                        if (!that.isMaterialized()) {
                            that.input.attr('placeholder', that.placeHolder);
                        }
                    }
                    else {
                        if (!that.isMaterialized()) {
                            that.input.attr('placeholder', "");
                        }
                    }

                    var top = parseInt(this._findPos(that.host[0])[1]) + parseInt(that.host.outerHeight()) - 1 + 'px';
                    var isMobileBrowser = false;// $.jqx.mobile.isSafariMobileBrowser() || $.jqx.mobile.isWindowsPhone();
                    if ((isMobileBrowser != null && isMobileBrowser)) {
                        top = $.jqx.mobile.getTopPos(this.element) + parseInt(that.host.outerHeight());
                        if ($('body').css('border-top-width') != '0px') {
                            top = parseInt(top) - this._getBodyOffset().top + 'px';
                        }
                    }

                    that.container.css('top', top);
                    var height = parseInt(that.host.height());
                    that.dropdownlistArrow.height(height);
                }

                if (!that.isanimating) {
                    if (event.altKey && event.keyCode == 38) {
                        that.hideListBox('altKey');
                        return false;
                    }

                    if (event.altKey && event.keyCode == 40) {
                        if (!that.isOpened()) {
                            that.showListBox('altKey');
                        }
                        return false;
                    }
                }

                if (event.keyCode == 37 || event.keyCode == 39)
                    return false;

                if (event.altKey || event.keyCode == 18)
                    return;

                if (event.keyCode >= 33 && event.keyCode <= 40) {
                    return;
                }

                if (event.ctrlKey || that.ctrlKey) {
                    if (event.keyCode != 88 && event.keyCode != 86) {
                        return;
                    }
                }

                var value = that.input.val();
                if (value.length == 0 && !that.autoComplete) {
                    that.listBox.searchString = that.input.val();
                    that.listBox.clearSelection();
                    that.hideListBox('search');
                    that.searchString = that.input.val();
                    return;
                }

                if (that.remoteAutoComplete) {
                    var that = this;
                    var clearListSelection = function () {
                        that.listBox.vScrollInstance.value = 0;
                    }

                    if (value.length >= that.minLength) {
                        if (!event.ctrlKey && !event.altKey) {
                            if (that.searchString != value) {
                                var source = that.listBoxContainer.jqxListBox('source');
                                if (source == null) {
                                    that.listBoxContainer.jqxListBox({ source: that.source });
                                }
                                if (that._searchTimer) {
                                    clearTimeout(that._searchTimer);
                                }
                                if (event.keyCode != 13 && event.keyCode != 27) {
                                    that._searchTimer = setTimeout(function () {
                                        clearListSelection();
                                        if (that.autoDropDownHeight) {
                                            that.listBox.autoHeight = true;
                                        }
                                        that.searchString = that.input.val();
                                        if (that.search != null) {
                                            that.search(that.input.val());
                                        }
                                        else {
                                            throw "'search' function is not defined";
                                        }

                                    }, that.remoteAutoCompleteDelay);
                                }
                            }
                            that.searchString = value;
                        }
                    }
                    else {
                        if (that._searchTimer) clearTimeout(that._searchTimer);
                        clearListSelection();
                        that.searchString = "";
                        that.search("");
                        that.listBoxContainer.jqxListBox({ source: null });
                    }
                    return;
                }

                var that = this;
                if (value === that.searchString) {
                    return;
                }

                if (!(event.keyCode == '27' || event.keyCode == '13')) {
                    var currentValue = that.input[0].value;
                    var matches = that._updateItemsVisibility(value);
                    var matchItems = matches.matchItems;
                    if (that.autoComplete && that.autoItemsHeight) {
                        that.input[0].value = currentValue;
                    }
                    var index = matches.index;
                    if (!that.autoComplete && !that.remoteAutoComplete) {
                        if (!that.multiSelect || (that.multiSelect && index >= 0)) {
                            that.listBox.selectIndex(index);
                            var isInView = that.listBox.isIndexInView(index);
                            if (!isInView) {
                                that.listBox.ensureVisible(index);
                            }
                            else {
                                that.listBox._renderItems();
                            }
                        }
                    }

                    if (that.autoComplete && matchItems.length === 0) {
                        that.hideListBox('search');
                    }
                }

                if (event.keyCode == '13') {
                    var isOpen = that.container.css('display') == 'block';
                    if (isOpen && !that.isanimating) {
                        that.hideListBox('keyboard');
                        that._oldvalue = that.listBox.selectedValue;
                        return;
                    }
                }
                else if (event.keyCode == '27') {
                    var isOpen = that.container.css('display') == 'block';
                    if (isOpen && !that.isanimating) {
                        if (!that.multiSelect) {
                            var item = that.listBox.getVisibleItem(that._oldvalue);
                            if (item) {
                                var that = this;
                                setTimeout(
                                    function () {
                                        if (that.autoComplete) {
                                            that._updateItemsVisibility("");
                                        }
                                        that.listBox.selectIndex(item.index);
                                        that.renderSelection('api');
                                    }, that.closeDelay);
                            }
                            else {
                                that.clearSelection();
                            }
                        }
                        else {
                            that.input.val("");
                            that.listBox.selectedValue = null;
                        }

                        that.hideListBox('keyboard');
                        that.renderSelection('api');
                        event.preventDefault();
                        return false;
                    }
                }
                else {
                    if (!that.isOpened() && !that.opening && !event.ctrlKey) {
                        if (that.listBox.visibleItems && that.listBox.visibleItems.length > 0) {
                            if (that.input.val() != that.searchString && that.searchString != undefined && index != -1) {
                                that.showListBox('search');
                            }
                        }
                    }
                    that.searchString = that.input.val();

                    if (that.searchString == "") {
                        if (!that.listBox.itemsByValue[""]) {
                            index = -1;
                            if (!that.multiSelect) {
                                that.clearSelection();
                            }
                        }
                    }

                    var item = that.listBox.getVisibleItem(index);

                    if (item != undefined) {
                        that._updateInputSelection();
                    }
                }
            },

            val: function (value) {
                if (!this.input) return "";
                var isEmpty = function (obj) {
                    for (var key in obj) {
                        if (obj.hasOwnProperty(key))
                            return false;
                    }

                    if (typeof value == "number")
                        return false;
                    if (typeof value == "date")
                        return false;
                    if (typeof value == "boolean")
                        return false;
                    if (typeof value == "string")
                        return false;

                    return true;
                }

                if (isEmpty(value) || arguments.length == 0) {
                    var item = this.getSelectedItem();
                    if (item) {
                        return item.value;
                    }


                    return this.input.val();
                }
                else {
                    var item = this.getItemByValue(value);
                    if (item != null) {
                        this.selectItem(item);
                    }
                    else {
                        this.input.val(value);
                    }
                    return this.input.val();
                }
            },

            focus: function () {
                var that = this;
                var doFocus = function () {
                    that.input.focus();
                    var val = that.input.val();
                    that._setSelection(0, val.length);
                }
                doFocus();
                setTimeout(function () {
                    doFocus();
                }, 10);
            },

            _setSelection: function (start, end) {
                try {
                    if ('selectionStart' in this.input[0]) {
                        this.input[0].focus();
                        this.input[0].setSelectionRange(start, end);
                    }
                    else {
                        var range = this.input[0].createTextRange();
                        range.collapse(true);
                        range.moveEnd('character', end);
                        range.moveStart('character', start);
                        range.select();
                    }
                }
                catch (error) {
                }
            },

            setContent: function (value) {
                this.input.val(value);
            },

            // get all matches of a searched value.
            _updateItemsVisibility: function (value) {
                var items = this.getItems();
                if (items == undefined) {
                    return { index: -1, matchItem: new Array() }
                }

                var that = this;
                var index = -1;
                var matchItems = new Array();
                var newItemsIndex = 0;

                $.each(items, function (i) {
                    var itemValue = '';
                    if (!this.isGroup) {
                        if (this.searchLabel) {
                            itemValue = this.searchLabel;
                        }
                        else if (this.label) {
                            itemValue = this.label;
                        }
                        else if (this.value) {
                            itemValue = this.value;
                        }
                        else if (this.title) {
                            itemValue = this.title;
                        }
                        else itemValue = 'jqxItem';
                        itemValue = itemValue.toString();
                        var matches = false;
                        switch (that.searchMode) {
                            case 'containsignorecase':
                                matches = $.jqx.string.containsIgnoreCase(itemValue, value);
                                break;
                            case 'contains':
                                matches = $.jqx.string.contains(itemValue, value);
                                break;
                            case 'equals':
                                matches = $.jqx.string.equals(itemValue, value);
                                break;
                            case 'equalsignorecase':
                                matches = $.jqx.string.equalsIgnoreCase(itemValue, value);
                                break;
                            case 'startswith':
                                matches = $.jqx.string.startsWith(itemValue, value);
                                break;
                            case 'startswithignorecase':
                                matches = $.jqx.string.startsWithIgnoreCase(itemValue, value);
                                break;
                            case 'endswith':
                                matches = $.jqx.string.endsWith(itemValue, value);
                                break;
                            case 'endswithignorecase':
                                matches = $.jqx.string.endsWithIgnoreCase(itemValue, value);
                                break;
                        }

                        if (that.autoComplete && !matches) {
                            this.visible = false;
                        }

                        if (matches && that.autoComplete) {
                            matchItems[newItemsIndex++] = this;
                            this.visible = true;
                            index = this.visibleIndex;
                        }

                        if (value == '' && that.autoComplete) {
                            this.visible = true;
                            matches = false;
                        }

                        if (that.multiSelect) {
                            this.disabled = false;
                            if (that.selectedItems.indexOf(this.value) >= 0 || that._disabledItems.indexOf(this.value) >= 0) {
                                this.disabled = true;
                                matches = false;
                            }
                        }

                        if (!that.multiSelect) {
                            if (matches && !that.autoComplete) {
                                index = this.visibleIndex;
                                return false;
                            }
                        }
                        else {
                            if (matches && !that.autoComplete) {
                                if (index === -1) {
                                    index = this.visibleIndex;
                                }
                                return true;
                            }
                        }
                    }
                });
                this.listBox.searchString = value;
                var that = this;
                var selectFirstItem = function () {
                    if (that.multiSelect) return;
                    var nonDisabledIndex = 0;
                    var foundIndex = false;
                    var item = null;
                    for (var indx = 0; indx < that.listBox.items.length; indx++) {
                        that.listBox.selectedIndexes[indx] = -1;
                        if (!that.listBox.items[indx].disabled) {
                            if (foundIndex == false) {
                                item = that.listBox.items[indx];
                                nonDisabledIndex = item.visibleIndex;
                                foundIndex = true;
                            }
                        }
                    }
                    that.listBox.selectedIndex = -1;
                    that.listBox.selectedIndex = nonDisabledIndex;
                    that.listBox.selectedIndexes[nonDisabledIndex] = nonDisabledIndex;
                    if (that.listBox.visibleItems.length > 0) {
                        if (item) {
                            that.listBox.selectedValue = item.value;
                        }
                        else {
                            that.listBox.selectedValue = null;
                        }
                    }
                    else {
                        that.listBox.selectedValue = null;
                    }
                    that.listBox.ensureVisible(0);
                }

                if (!this.autoComplete) {
                    selectFirstItem();
                    return { index: index, matchItems: matchItems };
                }

                this.listBox.renderedVisibleItems = new Array();
                var vScrollValue = this.listBox.vScrollInstance.value;
                this.listBox.vScrollInstance.value = 0;
                this.listBox.visibleItems = new Array();
                this.listBox._renderItems();
                var selectedValue = this.listBox.selectedValue;
                var item = this.listBox.getItemByValue(selectedValue);
                if (!this.multiSelect) {
                    if (item) {
                        if (item.visible) {
                            this.listBox.selectedIndex = item.visibleIndex;
                            for (var indx = 0; indx < this.listBox.items.length; indx++) {
                                this.listBox.selectedIndexes[indx] = -1;
                            }
                            this.listBox.selectedIndexes[item.visibleIndex] = item.visibleIndex;
                        }
                        else {
                            for (var indx = 0; indx < this.listBox.items.length; indx++) {
                                this.listBox.selectedIndexes[indx] = -1;
                            }
                            this.listBox.selectedIndex = -1;
                        }
                    }
                }
                else {
                    selectFirstItem();
                }

                this.listBox._renderItems();
                var height = this.listBox._calculateVirtualSize().height;
                if (height < vScrollValue) {
                    vScrollValue = 0;
                    this.listBox.vScrollInstance.refresh();
                }
                if (this.autoDropDownHeight) {
                    this._disableSelection = true;
                    if (this.listBox.autoHeight != this.autoDropDownHeight) {
                        this.listBoxContainer.jqxListBox({ autoHeight: this.autoDropDownHeight });
                    }
                    this.container.height(height + 25);
                    this.listBox.invalidate();
                    this._disableSelection = false;
                }
                else {
                    if (height < parseInt(this.dropDownHeight)) {
                        var scrollOffset = this.listBox.hScrollBar[0].style.visibility == "hidden" ? 0 : 20;
                        this.listBox.height = scrollOffset + height;
                        this.container.height(height + 25 + scrollOffset);
                        this.listBox.invalidate();
                    }
                    else {
                        this.listBox.height = parseInt(this.dropDownHeight);
                        this.container.height(parseInt(this.dropDownHeight) + 25);
                        this.listBox.invalidate();
                    }
                }

                this.listBox.vScrollInstance.setPosition(vScrollValue);
                return { index: index, matchItems: matchItems };
            },

            // gets all items that match to a search value.
            findItems: function (value) {
                var items = this.getItems();
                var that = this;
                var index = 0;
                var matchItems = new Array();

                $.each(items, function (i) {
                    var itemValue = '';
                    if (!this.isGroup) {
                        if (this.label) {
                            itemValue = this.label;
                        }
                        else if (this.value) {
                            itemValue = this.value;
                        }
                        else if (this.title) {
                            itemValue = this.title;
                        }
                        else itemValue = 'jqxItem';

                        var matches = false;
                        switch (that.searchMode) {
                            case 'containsignorecase':
                                matches = $.jqx.string.containsIgnoreCase(itemValue, value);
                                break;
                            case 'contains':
                                matches = $.jqx.string.contains(itemValue, value);
                                break;
                            case 'equals':
                                matches = $.jqx.string.equals(itemValue, value);
                                break;
                            case 'equalsignorecase':
                                matches = $.jqx.string.equalsIgnoreCase(itemValue, value);
                                break;
                            case 'startswith':
                                matches = $.jqx.string.startsWith(itemValue, value);
                                break;
                            case 'startswithignorecase':
                                matches = $.jqx.string.startsWithIgnoreCase(itemValue, value);
                                break;
                            case 'endswith':
                                matches = $.jqx.string.endsWith(itemValue, value);
                                break;
                            case 'endswithignorecase':
                                matches = $.jqx.string.endsWithIgnoreCase(itemValue, value);
                                break;
                        }

                        if (matches) {
                            matchItems[index++] = this;
                        }
                    }
                });

                return matchItems;
            },

            //[optimize]
            _resetautocomplete: function () {
                $.each(this.listBox.items, function (i) {
                    this.visible = true;
                });
                this.listBox.vScrollInstance.value = 0;
                this.listBox._addItems();
                this.listBox.autoHeight = false;

                this.listBox.height = this.dropDownHeight;
                this.container.height(parseInt(this.dropDownHeight) + 25);
                this.listBoxContainer.height(parseInt(this.dropDownHeight));
                this.listBox._arrange();

                this.listBox._addItems();
                this.listBox._renderItems();
            },

            // gets all items.
            getItems: function () {
                var item = this.listBox.items;
                return item;
            },

            getVisibleItems: function () {
                return this.listBox.getVisibleItems();
            },

            _setSize: function () {
                var computedStyle = window.getComputedStyle(this.element);
                var borderSize = parseInt(computedStyle.borderLeftWidth) * 2;
                var boxSizing = computedStyle.boxSizing;

                if (boxSizing === 'border-box' || isNaN(borderSize)) {
                    borderSize = 0;
                }

                if (this.width != null && this.width.toString().indexOf("px") != -1) {
                    this.element.style.width = parseInt(this.width) - borderSize + 'px';
                }
                else if (this.width != undefined && !isNaN(this.width)) {
                    this.element.style.width = parseInt(this.width) - borderSize + 'px';
                }

                if (this.height != null && this.height.toString().indexOf("px") != -1) {
                    this.element.style.height = parseInt(this.height) - borderSize + 'px';
                }
                else if (this.height != undefined && !isNaN(this.height)) {
                    this.element.style.height = parseInt(this.height) - borderSize + 'px';
                };

                var isPercentage = false;
                if (this.width != null && this.width.toString().indexOf("%") != -1) {
                    isPercentage = true;
                    this.element.style.width = this.width;

                    if (borderSize > 0) {
                        this.host.css('box-sizing', 'border-box');
                    }
                }

                if (this.height != null && this.height.toString().indexOf("%") != -1) {
                    isPercentage = true;
                    this.element.style.height = this.height;
                }

                if (isPercentage) {
                    var that = this;
                    var width = this.host.width();
                    if (this.dropDownWidth != 'auto') {
                        width = this.dropDownWidth;
                    }
                    this.listBoxContainer.jqxListBox({ width: width });
                    this.container.width(parseInt(width) + 25);
                    this._arrange();
                }
                var that = this;

                var resizeFunc = function () {
                    if (that.multiSelect) {
                        that.host.height(that.height);
                    }

                    that._arrange();
                    if (that.multiSelect) {
                        that.host.height('auto');
                    }
                }

                that.oldWidth = that.host.width();
                that.oldHeight = that.host.height();
                $.jqx.utilities.resize(this.host, function () {
                    var w = that.host.width();
                    var h = that.host.height();

                    if (w != that.oldWidth || h != that.oldHeight) {
                        resizeFunc();
                        that.hideListBox('api');
                    }

                    that.oldWidth = w;
                    that.oldHeight = h;
                });
            },

            // returns true when the listbox is opened, otherwise returns false.
            isOpened: function () {
                var that = this;
                var openedListBox = $.data(document.body, "openedCombojqxListBox" + this.element.id);

                if (this.container.css('display') != 'block')
                    return false;

                if (openedListBox != null && openedListBox == that.listBoxContainer) {
                    return true;
                }

                return false;
            },

            _updateHandlers: function () {
                var that = this;
                var hovered = false;
                this.removeHandlers();

                if (this.multiSelect) {
                    this.addHandler(this.dropdownlistContent, 'click', function (event) {
                        if (event.target.href) return false;

                        that.input.focus();
                        setTimeout(function () {
                            that.input.focus();
                        }, 10);
                    });
                    this.addHandler(this.dropdownlistContent, 'focus', function (event) {
                        if (event.target.href) return false;

                        that.input.focus();
                        setTimeout(function () {
                            that.input.focus();
                        }, 10);
                    });
                }

                if (!this.touch) {
                    if (this.host.parents()) {
                        this.addHandler(this.host.parents(), 'scroll.combobox' + this.element.id, function (event) {
                            var opened = that.isOpened();
                            if (opened) {
                                that.close();
                            }
                        });
                    }

                    this.addHandler(this.host, 'mouseenter', function () {
                        if (!that.disabled && that.enableHover) {
                            hovered = true;
                            that.host.addClass(that.toThemeProperty('jqx-combobox-state-hover'));
                            if (that.dropDownVerticalAlignment == "top") {
                                that.dropdownlistArrowIcon.addClass(that.toThemeProperty('jqx-icon-arrow-up'));
                            }
                            else {
                                that.dropdownlistArrowIcon.addClass(that.toThemeProperty('jqx-icon-arrow-down-hover'));
                            }
                            that.dropdownlistArrow.addClass(that.toThemeProperty('jqx-combobox-arrow-hover'));
                            that.dropdownlistArrow.addClass(that.toThemeProperty('jqx-fill-state-hover'));
                        }
                    });
                    this.addHandler(this.host, 'mouseleave', function () {
                        if (!that.disabled && that.enableHover) {
                            that.host.removeClass(that.toThemeProperty('jqx-combobox-state-hover'));
                            that.dropdownlistArrowIcon.removeClass(that.toThemeProperty('jqx-icon-arrow-down-hover'));
                            that.dropdownlistArrowIcon.removeClass(that.toThemeProperty('jqx-icon-arrow-up-hover'));
                            that.dropdownlistArrow.removeClass(that.toThemeProperty('jqx-combobox-arrow-hover'));
                            that.dropdownlistArrow.removeClass(that.toThemeProperty('jqx-fill-state-hover'));
                            hovered = false;
                        }
                    });
                }

                if (that.autoOpen) {
                    this.addHandler(this.host, 'mouseenter', function () {
                        var isOpened = that.isOpened();
                        if (!isOpened && that.autoOpen) {
                            that.open();
                            that.host.focus();
                        }
                    });

                    this.addHandler($(document), 'mousemove.' + that.id, function (event) {
                        var isOpened = that.isOpened();
                        if (isOpened && that.autoOpen) {
                            var offset = that.host.coord();
                            var top = offset.top;
                            var left = offset.left;
                            var popupOffset = that.container.coord();
                            var popupLeft = popupOffset.left;
                            var popupTop = popupOffset.top;

                            var canClose = true;

                            if (event.pageY >= top && event.pageY <= top + that.host.height() + 2) {
                                if (event.pageX >= left && event.pageX < left + that.host.width())
                                    canClose = false;
                            }
                            if (event.pageY >= popupTop && event.pageY <= popupTop + that.container.height() - 20) {
                                if (event.pageX >= popupLeft && event.pageX < popupLeft + that.container.width())
                                    canClose = false;
                            }

                            if (canClose) {
                                that.close();
                            }
                        }
                    });
                }

                var eventName = 'mousedown';
                if (this.touch) eventName = $.jqx.mobile.getTouchEventName('touchstart');

                var dropDownButtonClicked = function (event) {
                    if (!that.disabled) {
                        var isOpen = that.container.css('display') == 'block';
                        if (!that.isanimating) {
                            if (isOpen) {
                                that.hideListBox('api');
                                if (!$.jqx.mobile.isTouchDevice()) {
                                    that.input.focus();
                                    setTimeout(function () {
                                        that.input.focus();
                                    }, 10);
                                }
                                return true;
                            }
                            else {
                                if (that.autoDropDownHeight) {
                                    that.container.height(that.listBoxContainer.height() + 25);
                                    var autoheight = that.listBoxContainer.jqxListBox('autoHeight');
                                    if (!autoheight) {
                                        that.listBoxContainer.jqxListBox({ autoHeight: that.autoDropDownHeight })
                                        that.listBox._arrange();
                                        that.listBox.ensureVisible(0);
                                        that.listBox._renderItems();
                                        that.container.height(that.listBoxContainer.height() + 25);
                                    }
                                }
                                that.showListBox('api');
                                if (!$.jqx.mobile.isTouchDevice()) {
                                    setTimeout(function () {
                                        that.input.focus();
                                    }, 10);
                                }
                                else {
                                    return true;
                                }
                            }
                        }
                    }
                }

                this.addHandler(this.dropdownlistArrow, eventName,
                    function (event) {
                        dropDownButtonClicked(event);
                        //       return false;
                    });
                this.addHandler(this.dropdownlistArrowIcon, eventName,
                    function (event) {

                        //   dropDownButtonClicked(event);
                        //     return false;
                    });

                this.addHandler(this.host, 'focus', function () {
                    that.focus();
                });

                this.addHandler(this.input, 'focus', function (event) {
                    that.focused = true;
                    that.host.addClass(that.toThemeProperty('jqx-combobox-state-focus'));
                    that.host.addClass(that.toThemeProperty('jqx-fill-state-focus'));
                    that.bar.addClass('focused');
                    that.label.addClass('focused');

                    that.dropdownlistContent.addClass(that.toThemeProperty('jqx-combobox-content-focus'));
                    if (event.stopPropagation) {
                        event.stopPropagation();
                    }

                });
                this.addHandler(this.input, 'blur', function () {
                    that.focused = false;
                    that.bar.removeClass('focused');
                    that.label.removeClass('focused');

                    if (!that.isOpened() && !that.opening) {
                        if (that.selectionMode == "dropDownList") {
                            that._selectOldValue();
                        }

                        that.host.removeClass(that.toThemeProperty('jqx-combobox-state-focus'));
                        that.host.removeClass(that.toThemeProperty('jqx-fill-state-focus'));
                        that.dropdownlistContent.removeClass(that.toThemeProperty('jqx-combobox-content-focus'));
                    }
                    if (that._searchTimer) clearTimeout(that._searchTimer);
                });
                this.addHandler($(document), 'mousedown.' + this.id, that.closeOpenedListBox, { that: this, listbox: this.listBox, id: this.id });
                if (this.touch) {
                    this.addHandler($(document), $.jqx.mobile.getTouchEventName('touchstart') + '.' + this.id, that.closeOpenedListBox, { that: this, listbox: this.listBox, id: this.id });
                }

                this.addHandler(this.host, 'keydown', function (event) {
                    var isOpen = that.container.css('display') == 'block';
                    that.ctrlKey = event.ctrlKey;
                    if (that.host.css('display') == 'none') {
                        return true;
                    }

                    if (event.keyCode == '13' || event.keyCode == '9') {
                        if (isOpen && !that.isanimating) {
                            if (that.listBox.selectedIndex != -1) {
                                that.renderSelection('mouse');
                                var index = that.listBox.selectedIndex;
                                var item = that.listBox.getVisibleItem(index);
                                if (item) {
                                    that.listBox.selectedValue = item.value;
                                }
                                that._setSelection(that.input.val().length, that.input.val().length);
                                that.hideListBox('keyboard');
                            }
                            if (event.keyCode == '13') {
                                that._oldvalue = that.listBox.selectedValue;
                            }
                            if (!that.keyboardSelection) {
                                that._raiseEvent('2', { index: that.selectedIndex, type: 'keyboard', item: that.getItem(that.selectedIndex) });
                            }

                            if (event.keyCode == '9') return true;
                            return false;
                        }
                    }

                    if (event.keyCode == 115) {
                        if (!that.isanimating) {
                            if (!that.isOpened()) {
                                that.showListBox('keyboard');
                            }
                            else if (that.isOpened()) {
                                that.hideListBox('keyboard');
                            }
                        }
                        return false;
                    }

                    if (event.altKey) {
                        if (that.host.css('display') == 'block') {
                            if (!that.isanimating) {
                                if (event.keyCode == 38) {
                                    if (that.isOpened()) {
                                        that.hideListBox('altKey');
                                    }
                                }
                                else if (event.keyCode == 40) {
                                    if (!that.isOpened()) {
                                        that.showListBox('altKey');
                                    }
                                }
                            }
                        }
                    }

                    if (event.keyCode == '27' || event.keyCode == '9') {
                        if (that.isOpened() && !that.isanimating) {

                            if (event.keyCode == '27') {
                                if (!that.multiSelect) {
                                    var item = that.listBox.getItemByValue(that._oldvalue);
                                    if (item) {
                                        setTimeout(
                                            function () {
                                                if (that.autoComplete) {
                                                    that._updateItemsVisibility("");
                                                }
                                                that.listBox.selectIndex(item.index);
                                                that.renderSelection('api');
                                            }, that.closeDelay);
                                    }
                                    else {
                                        that.clearSelection();
                                    }
                                }
                                else {
                                    that.listBox.selectedValue = null;
                                    that.input.val("");
                                }
                            }
                            that.hideListBox('keyboard');


                            if (event.keyCode == '9')
                                return true;

                            that.renderSelection('api');
                            event.preventDefault();

                            return false;
                        }
                    }

                    var key = event.keyCode;

                    if (isOpen && !that.disabled && key != 8) {
                        return that.listBox._handleKeyDown(event);
                    }
                    else if (!that.disabled && !isOpen) {
                        var key = event.keyCode;
                        // arrow keys.
                        if (key == 33 || key == 34 || key == 35 || key == 36 || key == 38 || key == 40) {
                            return that.listBox._handleKeyDown(event);
                        }
                    }
                    if (key === 8 && that.multiSelect) {
                        if (that.input.val().length === 0) {
                            var lastItem = that.selectedItems[that.selectedItems.length - 1];
                            that.selectedItems.pop();
                            that._selectedItems.pop();
                            if (lastItem) {
                                that._raiseEvent('3', { index: lastItem.index, type: 'keyboard', item: lastItem });
                                that._raiseEvent('4', { index: lastItem.index, type: 'keyboard', item: lastItem });
                            }

                            that.listBox.selectedValue = null;
                            that.doMultiSelect();
                            return false;
                        }
                    }


                    if (that.isMaterialized() && that.hint) {
                        setTimeout(function () {
                            if (that.input[0].value.length === 0) {
                                that.element.removeAttribute('hint');
                                that.label[0].innerHTML = that.placeHolder;
                            }
                            else if (that.hint) {
                                that.element.setAttribute('hint', true);
                            }
                        });
                    }
                });

                this.addHandler(this.listBoxContainer, 'checkChange', function (event) {
                    that.renderSelection('mouse');
                    that._updateInputSelection();
                    that._raiseEvent(5, { label: event.args.label, value: event.args.value, checked: event.args.checked, item: event.args.item });
                });

                this.addHandler(this.listBoxContainer, 'select', function (event) {
                    if (!that.disabled) {
                        if (event.args.type != 'keyboard' || that.keyboardSelection) {
                            that.renderSelection(event.args.type);
                            if (!that.multiSelect) {
                                that._raiseEvent('2', { index: event.args.index, type: event.args.type, item: event.args.item });
                            }
                            if (event.args.type == 'mouse') {
                                that._oldvalue = that.listBox.selectedValue;

                                if (!that.checkboxes) {
                                    that.hideListBox('mouse');
                                    if (!that.touch) {
                                        that.input.focus();
                                    }
                                    else {
                                        return false;
                                    }
                                }
                            }
                        }
                    }
                });
                if (this.listBox != null && this.listBox.content != null) {
                    this.addHandler(this.listBox.content, 'click', function (event) {
                        if (!that.disabled) {
                            if (that.listBox.itemswrapper) {
                                if (event.target === that.listBox.itemswrapper[0])
                                    return true;
                            }

                            if (event.target && event.target.className) {
                                if (event.target.className.indexOf('jqx-fill-state-disabled') >= 0) {
                                    return true;
                                }
                            }

                            that.renderSelection('mouse');
                            that._oldvalue = that.listBox.selectedValue;
                            if (!that.touch && !that.ishiding) {
                                if (!that.checkboxes) {
                                    that.hideListBox('mouse');
                                    that.input.focus();
                                }
                            }
                            if (that.touch === true) {
                                if (!that.checkboxes) {
                                    that.hideListBox('mouse');
                                }
                            }
                        }
                    });
                }
            },

            _selectOldValue: function () {
                var that = this;
                if (that.listBox.selectedIndex == -1) {
                    if (!that.multiSelect) {
                        var item = that.listBox.getItemByValue(that._oldvalue);
                        if (item) {
                            setTimeout(
                                function () {
                                    if (that.autoComplete) {
                                        that._updateItemsVisibility("");
                                    }
                                    that.listBox.selectIndex(item.index);
                                    that.renderSelection('api');
                                }, that.closeDelay);
                        }
                        else {
                            that.clearSelection();
                            that.listBox.selectIndex(0);
                            that.renderSelection('api');
                        }
                    }
                    else {
                        that.listBox.selectedValue = null;
                        that.input.val("");
                    }
                }
                else {
                    that.renderSelection('api');
                }
            },

            removeHandlers: function () {
                var that = this;
                if (this.dropdownlistWrapper != null) {
                    this.removeHandler(this.dropdownlistWrapper, 'mousedown');
                }

                if (this.dropdownlistContent) {
                    this.removeHandler(this.dropdownlistContent, 'click');
                    this.removeHandler(this.dropdownlistContent, 'focus');
                }
                this.removeHandler(this.host, 'keydown');
                this.removeHandler(this.host, 'focus');
                if (this.input != null) {
                    this.removeHandler(this.input, 'focus');
                    this.removeHandler(this.input, 'blur');
                }
                this.removeHandler(this.host, 'mouseenter');
                this.removeHandler(this.host, 'mouseleave');
                this.removeHandler($(document), 'mousemove.' + that.id);
                if (this.listBoxContainer) {
                    this.removeHandler(this.listBoxContainer, 'checkChange');
                    this.removeHandler(this.listBoxContainer, 'select');
                }
                if (this.host.parents()) {
                    this.removeHandler(this.host.parents(), 'scroll.combobox' + this.element.id);
                }
                if (this.dropdownlistArrowIcon && this.dropdownlistArrow) {
                    var eventName = 'mousedown';
                    if (this.touch) eventName = $.jqx.mobile.getTouchEventName('touchstart');
                    this.removeHandler(this.dropdownlistArrowIcon, eventName);
                    this.removeHandler(this.dropdownlistArrow, eventName);
                }
            },

            // gets an item by index.
            getItem: function (index) {
                var item = this.listBox.getItem(index);
                return item;
            },

            getItemByValue: function (value) {
                var item = this.listBox.getItemByValue(value);
                return item;
            },

            getVisibleItem: function (index) {
                var item = this.listBox.getVisibleItem(index);
                return item;
            },

            // renders the selection.
            renderSelection: function (type) {
                if (type == undefined || type == 'none') {
                    return;
                }

                if (this._disableSelection === true)
                    return;

                if (this.listBox == null)
                    return;

                if (this.multiSelect) {
                    return;
                }
                var item = this.listBox.visibleItems[this.listBox.selectedIndex];

                if (this.autoComplete && !this.checkboxes) {
                    if (this.listBox.selectedValue !== undefined) {
                        var item = this.getItemByValue(this.listBox.selectedValue);
                    }
                }

                if (this.checkboxes) {
                    var checkedItems = this.getCheckedItems();
                    if (checkedItems != null && checkedItems.length > 0) {
                        item = checkedItems[0];
                    }
                    else item = null;
                }

                if (this.hint) {
                    this.label[0].innerHTML = this.placeHolder;
                }

                if (item != null) {
                    if (this.hint) {
                        this.element.setAttribute('hint', true);
                    }
                }
                else {
                    this.element.removeAttribute('hint');
                }

                this.bar.css('top', this.host.height());

                if (item == null) {
                    var ie7 = $.jqx.browser.msie && $.jqx.browser.version < 8;
                    this.input.val("");
                    this.input.attr('value', '');
                    if (!ie7) {
                        if (this.isMaterialized()) {
                            this.label[0].innerHTML = this.placeHolder;
                            this.input.removeAttr('placeholder');
                        }
                        else {
                            this.input.attr('placeholder', this.placeHolder);
                        }
                    }
                    this._updateInputSelection();
                    return;
                }

                this.selectedIndex = this.listBox.selectedIndex;
                var spanElement = $('<span></span>');

                if (item.label != undefined && item.label != null && item.label.toString().length > 0) {
                    $.jqx.utilities.html(spanElement, item.label);
                }
                else if (item.value != undefined && item.value != null && item.value.toString().length > 0) {
                    $.jqx.utilities.html(spanElement, item.value);
                }
                else if (item.title != undefined && item.title != null && item.title.toString().length > 0) {
                    $.jqx.utilities.html(spanElement, item.title);
                }
                else {
                    $.jqx.utilities.html(spanElement, this.emptyString);
                }
                var spanHeight = spanElement.outerHeight();
                if (this.checkboxes) {
                    var items = this.getCheckedItems();
                    var str = "";
                    for (var i = 0; i < items.length; i++) {
                        if (i == items.length - 1) {
                            str += items[i].label;
                        }
                        else {
                            str += items[i].label + ", ";
                        }
                    }
                    this.input.val(str);
                }
                else {
                    this.input.val(spanElement.text());
                }
                spanElement.remove();
                this._updateInputSelection();
                if (this.renderSelectedItem) {
                    var result = this.renderSelectedItem(this.listBox.selectedIndex, item);
                    if (result != undefined) {
                        this.input[0].value = result;
                    }
                }
                this.input.attr('value', this.input.val());
                if (this.listBox && this.listBox._activeElement) {
                    $.jqx.aria(this, "aria-activedescendant", this.listBox._activeElement.id);
                }
            },

            dataBind: function () {
                this.listBoxContainer.jqxListBox({ source: this.source });
                this.renderSelection('mouse');
                if (this.source == null) {
                    this.clearSelection();
                }
            },

            clear: function () {
                this.listBoxContainer.jqxListBox({ source: null });
                this.clearSelection();
            },

            // clears the selection.
            clearSelection: function (render) {
                this.selectedIndex = -1;
                this.listBox.clearSelection();
                this.input.val("");
                if (this.multiSelect) {
                    this.listBox.selectedValue = "";
                    this.selectedItems = new Array();
                    this._selectedItems = new Array();
                    this.doMultiSelect(false);
                }
            },

            // unselects an item at specific index.
            // @param Number
            unselectIndex: function (index, render) {
                if (isNaN(index))
                    return;

                if (this.autoComplete) {
                    this._updateItemsVisibility("");
                }

                this.listBox.unselectIndex(index, render);
                this.renderSelection('mouse');
                if (this.multiSelect) {
                    if (index >= 0) {
                        var multiItem = this.getItem(index);

                        var indx = this.selectedItems.indexOf(multiItem.value);
                        if (indx >= 0) {
                            if (multiItem.value === this.listBox.selectedValue) {
                                this.listBox.selectedValue = null;
                            }

                            this.selectedItems.splice(indx, 1);
                            this._selectedItems.splice(indx, 1);
                        }
                    }
                    this.doMultiSelect(false);
                }
            },

            // selects an item at specific index.
            // @param Number
            selectIndex: function (index, ensureVisible, render, forceSelect) {
                if (this.autoComplete) {
                    this._updateItemsVisibility("");
                }

                this.listBox.selectIndex(index, ensureVisible, render, forceSelect);
                this.renderSelection('mouse');
                this.selectedIndex = index;
                if (this.multiSelect) {
                    this.doMultiSelect();
                }
            },

            selectItem: function (item) {
                if (this.autoComplete) {
                    this._updateItemsVisibility("");
                }

                if (this.listBox != undefined) {
                    this.listBox.selectedIndex = -1;
                    this.listBox.selectItem(item);
                    this.selectedIndex = this.listBox.selectedIndex;
                    this.renderSelection('mouse');
                    if (this.multiSelect) {
                        this.doMultiSelect(false);
                    }
                }
            },

            unselectItem: function (item) {
                if (this.autoComplete) {
                    this._updateItemsVisibility("");
                }

                if (this.listBox != undefined) {
                    this.listBox.unselectItem(item);
                    this.renderSelection('mouse');
                    if (this.multiSelect) {
                        var multiItem = this.getItemByValue(item);
                        if (multiItem) {
                            var index = this.selectedItems.indexOf(multiItem.value);
                            if (index >= 0) {
                                if (multiItem.value === this.listBox.selectedValue) {
                                    this.listBox.selectedValue = null;
                                }

                                this.selectedItems.splice(index, 1);
                                this._selectedItems.splice(index, 1);
                            }
                        }

                        this.doMultiSelect(false);
                    }
                }
            },

            checkItem: function (item) {
                if (this.autoComplete) {
                    this._updateItemsVisibility("");
                }

                if (this.listBox != undefined) {
                    this.listBox.checkItem(item);
                }
            },

            uncheckItem: function (item) {
                if (this.autoComplete) {
                    this._updateItemsVisibility("");
                }

                if (this.listBox != undefined) {
                    this.listBox.uncheckItem(item);
                }
            },

            indeterminateItem: function (item) {
                if (this.autoComplete) {
                    this._updateItemsVisibility("");
                }

                if (this.listBox != undefined) {
                    this.listBox.indeterminateItem(item);
                }
            },

            getSelectedValue: function () {
                return this.listBox.selectedValue;
            },

            // gets the selected index.
            getSelectedIndex: function () {
                if (!this.multiSelect) {
                    return this.listBox.selectedIndex;
                }
                else {
                    if (this.remoteAutoComplete && this.multiSelect && this._selectedItems.length > 0)
                        return this.getSelectedItems()[0].index;

                    if (this._selectedItems && this._selectedItems.length > 0) {
                        return this.getSelectedItems()[0].index;
                    }
                }
            },

            // gets the selected item.
            getSelectedItem: function () {
                if (!this.multiSelect) {
                    return this.getVisibleItem(this.listBox.selectedIndex);
                }
                else {
                    if (this.remoteAutoComplete && this.multiSelect && this._selectedItems.length > 0)
                        return this.getSelectedItems()[0];

                    if (this._selectedItems && this._selectedItems.length > 0) {
                        return this.getSelectedItems()[0];
                    }
                    return null;
                }
            },

            // gets the selected items when multiselect is enabled.
            getSelectedItems: function () {
                if (this.remoteAutoComplete && this.multiSelect)
                    return this._selectedItems;

                var array = new Array();
                var that = this;
                $.each(this.selectedItems, function () {
                    var item = that.getItemByValue(this);
                    if (item) {
                        array.push(item);
                    }
                    else {
                        var item = that._selectedItems[this];
                        if (item) {
                            array.push(item);
                        }
                    }
                });
                return array;
            },

            getCheckedItems: function () {
                return this.listBox.getCheckedItems();
            },

            checkIndex: function (index) {
                this.listBox.checkIndex(index);
            },

            uncheckIndex: function (index) {
                this.listBox.uncheckIndex(index);
            },

            indeterminateIndex: function (index) {
                this.listBox.indeterminateIndex(index);
            },
            checkAll: function () {
                this.listBox.checkAll();
                this.renderSelection("mouse");
            },

            uncheckAll: function () {
                this.listBox.uncheckAll();
                this.renderSelection("mouse");
            },

            insertAt: function (item, index) {
                if (item == null)
                    return false;

                return this.listBox.insertAt(item, index);
            },

            addItem: function (item) {
                return this.listBox.addItem(item);
            },

            removeAt: function (index) {
                var result = this.listBox.removeAt(index);
                this.renderSelection('mouse');
                return result;
            },

            removeItem: function (item) {
                var result = this.listBox.removeItem(item);
                this.renderSelection('mouse');
                return result;
            },

            updateItem: function (item, oldItem) {
                var result = this.listBox.updateItem(item, oldItem);
                this.renderSelection('mouse');
                return result;
            },

            updateAt: function (item, index) {
                var result = this.listBox.updateAt(item, index);
                this.renderSelection('mouse');
                return result;
            },

            ensureVisible: function (index) {
                return this.listBox.ensureVisible(index);
            },

            disableAt: function (index) {
                var item = this.getVisibleItem(index);
                if (item) {
                    this._disabledItems.push(item.value);
                }
                return this.listBox.disableAt(index);
            },

            enableAt: function (index) {
                var item = this.getVisibleItem(index);
                if (item) {
                    this._disabledItems.splice(this._disabledItems.indexOf(item.value), 1);
                }
                return this.listBox.enableAt(index);
            },

            disableItem: function (item) {
                var item = this.getVisibleItem(item);
                if (item) {
                    this._disabledItems.push(item.value);
                }
                return this.listBox.disableItem(item);
            },

            enableItem: function (item) {
                var item = this.getVisibleItem(item);
                if (item) {
                    this._disabledItems.splice(this._disabledItems.indexOf(item.value), 1);
                }
                return this.listBox.enableItem(item);
            },

            _findPos: function (obj) {
                while (obj && (obj.type == 'hidden' || obj.nodeType != 1 || $.expr.filters.hidden(obj))) {
                    obj = obj['nextSibling'];
                }
                if (obj) {
                    var position = $(obj).coord(true);
                    return [position.left, position.top];
                }
            },

            testOffset: function (element, offset, inputHeight) {
                var dpWidth = element.outerWidth();
                var dpHeight = element.outerHeight();
                var viewWidth = $(window).width() + $(window).scrollLeft();
                var viewHeight = $(window).height() + $(window).scrollTop();

                if (offset.left + dpWidth > viewWidth) {
                    if (dpWidth > this.host.width()) {
                        var hostLeft = this.host.coord().left;
                        var hOffset = dpWidth - this.host.width();
                        offset.left = hostLeft - hOffset + 2;
                    }
                }
                if (offset.left < 0) {
                    offset.left = parseInt(this.host.coord().left) + 'px'
                }

                offset.top -= Math.min(offset.top, (offset.top + dpHeight > viewHeight && viewHeight > dpHeight) ?
                    Math.abs(dpHeight + inputHeight + 23) : 0);

                return offset;
            },

            open: function () {
                if (!this.isOpened() && !this.opening) {
                    this.showListBox('api');
                }
            },

            close: function () {
                if (this.isOpened()) {
                    this.hideListBox('api');
                }
            },

            _getBodyOffset: function () {
                var top = 0;
                var left = 0;
                if ($('body').css('border-top-width') != '0px') {
                    top = parseInt($('body').css('border-top-width'));
                    if (isNaN(top)) top = 0;
                }
                if ($('body').css('border-left-width') != '0px') {
                    left = parseInt($('body').css('border-left-width'));
                    if (isNaN(left)) left = 0;
                }
                return { left: left, top: top };
            },

            // shows the listbox.
            showListBox: function (mode) {
                if (this.listBox.items && this.listBox.items.length == 0)
                    return;

                if (mode == "search" && !this.autoComplete && !this.remoteAutoComplete) {
                    if (this.autoDropDownHeight) {
                        this.container.height(this.listBoxContainer.height() + 25);
                    }
                }
                this.element.setAttribute('opened', true);

                if (this.autoComplete || this.multiSelect && !this.remoteAutoComplete) {
                    if (mode != 'search') {
                        this._updateItemsVisibility("");

                        if (this.multiSelect) {
                            var visibleItems = this.getVisibleItems();
                            for (var i = 0; i < visibleItems.length; i++) {
                                if (!visibleItems[i].disabled) {
                                    this.ensureVisible(i);
                                    break;
                                }
                            }
                        }
                    }
                }
                if (this.remoteAutoComplete) {
                    this.listBox.clearSelection();
                }

                if (mode != 'search') {
                    this._oldvalue = this.listBox.selectedValue;
                }

                $.jqx.aria(this, "aria-expanded", true);

                if (this.dropDownWidth == 'auto' && this.width != null && this.width.indexOf && this.width.indexOf('%') != -1) {
                    if (this.listBox.host.width() != this.host.width()) {
                        var width = this.element.offsetWidth;
                        this.listBoxContainer.jqxListBox({ width: width });
                        this.listBoxContainer[0].style.width = width + "px";
                        this.container.width(parseInt(width) + 25);
                    }
                }
                if (this.dropDownWidth == 'auto' && this.host.css('border-left-width') === "0px") {
                    var width = this.element.offsetWidth;
                    this.listBoxContainer.jqxListBox({ width: width + 1 });
                    this.container.width(parseInt(width) + 25);
                }


                var that = this;
                var listBox = this.listBoxContainer;
                var listBoxInstance = this.listBox;
                var scrollPosition = $(window).scrollTop();
                var scrollLeftPosition = $(window).scrollLeft();
                var top = parseInt(this._findPos(this.host[0])[1]) + parseInt(this.host.outerHeight()) - 1 + 'px';
                var left, leftPos = parseInt(Math.round(this.host.coord(true).left));
                left = leftPos + 'px';
                if (this.dropDownContainer === 'element') {
                    top = parseInt(this.host.outerHeight()) - 1 + 'px';
                    left = 0;
                }
                var isMobileBrowser = $.jqx.mobile.isSafariMobileBrowser() || $.jqx.mobile.isWindowsPhone();
                this.ishiding = false;

                var hasTransform = $.jqx.utilities.hasTransform(this.host);

                if (hasTransform || (isMobileBrowser != null && isMobileBrowser)) {
                    left = $.jqx.mobile.getLeftPos(this.element);
                    top = $.jqx.mobile.getTopPos(this.element) + parseInt(this.host.outerHeight());
                    if ($('body').css('border-top-width') != '0px') {
                        top = parseInt(top) - this._getBodyOffset().top + 'px';
                    }
                    if ($('body').css('border-left-width') != '0px') {
                        left = parseInt(left) - this._getBodyOffset().left + 'px';
                    }
                }

                this.host.addClass(this.toThemeProperty('jqx-combobox-state-selected'));
                if (this.dropDownVerticalAlignment == "top") {
                    this.dropdownlistArrowIcon.addClass(this.toThemeProperty('jqx-icon-arrow-up-selected'));
                }
                else {
                    this.dropdownlistArrowIcon.addClass(this.toThemeProperty('jqx-icon-arrow-down-selected'));
                }
                this.dropdownlistArrow.addClass(this.toThemeProperty('jqx-combobox-arrow-selected'));
                this.dropdownlistArrow.addClass(this.toThemeProperty('jqx-fill-state-pressed'));
                this.host.addClass(this.toThemeProperty('jqx-combobox-state-focus'));
                this.host.addClass(this.toThemeProperty('jqx-fill-state-focus'));
                this.dropdownlistContent.addClass(this.toThemeProperty('jqx-combobox-content-focus'));

                this.container.css('left', left);
                this.container.css('top', top);
                listBoxInstance._arrange();

                var closeAfterSelection = true;

                var positionChanged = false;

                if (this.dropDownHorizontalAlignment == 'right' || this.rtl) {
                    var containerWidth = this.container.outerWidth();
                    var containerLeftOffset = Math.abs(containerWidth - this.host.width());

                    if (containerWidth > this.host.width()) {
                        this.container.css('left', 25 + parseInt(Math.round(leftPos)) - containerLeftOffset + "px");
                    }
                    else this.container.css('left', 25 + parseInt(Math.round(leftPos)) + containerLeftOffset + "px");
                }

                if (this.dropDownVerticalAlignment == "top") {
                    var dpHeight = listBox.height();
                    positionChanged = true;

                    listBox.css('top', 23);
                    listBox.addClass(this.toThemeProperty('jqx-popup-up'));
                    var inputHeight = parseInt(this.host.outerHeight());
                    var t = parseInt(top) - Math.abs(dpHeight + inputHeight + 23);

                    this.container.css('top', t);
                }

                if (this.enableBrowserBoundsDetection) {
                    var newOffset = this.testOffset(listBox, { left: parseInt(this.container.css('left')), top: parseInt(top) }, parseInt(this.host.outerHeight()));
                    if (parseInt(this.container.css('top')) != newOffset.top) {
                        positionChanged = true;
                        listBox.css('top', 23);
                        listBox.addClass(this.toThemeProperty('jqx-popup-up'));
                    }
                    else listBox.css('top', 0);

                    this.container.css('top', newOffset.top);
                    this.container.css('top', newOffset.top);
                    if (parseInt(this.container.css('left')) != newOffset.left) {
                        this.container.css('left', newOffset.left);
                    }
                }

                if (this.animationType == 'none' || this.animationType === 'transform') {
                    this.container.css('display', 'block');
                    $.data(document.body, "openedCombojqxListBoxParent", that);
                    $.data(document.body, "openedCombojqxListBox" + that.element.id, listBox);
                    listBox.css('margin-top', 0);
                    listBox.css('opacity', 1);
                }
                else {
                    this.container.css('display', 'block');
                    var height = listBox.outerHeight();
                    listBox.stop();
                    if (this.animationType == 'fade') {
                        listBox.css('margin-top', 0);
                        listBox.css('opacity', 0);
                        listBox.animate({ 'opacity': 1 }, this.openDelay, function () {
                            that.isanimating = false;
                            that.opening = false;
                            $.data(document.body, "openedCombojqxListBoxParent", that);
                            $.data(document.body, "openedCombojqxListBox" + that.element.id, listBox);
                        });
                    }
                    else {
                        listBox.css('opacity', 1);
                        if (positionChanged) {
                            listBox.css('margin-top', height);
                        }
                        else {
                            listBox.css('margin-top', -height);
                        }
                        this.isanimating = true;
                        this.opening = true;
                        listBox.animate({ 'margin-top': 0 }, this.openDelay, function () {
                            that.isanimating = false;
                            that.opening = false;
                            $.data(document.body, "openedCombojqxListBoxParent", that);
                            $.data(document.body, "openedCombojqxListBox" + that.element.id, listBox);
                        });
                    }
                }
                listBoxInstance._renderItems();
                if (!positionChanged) {
                    this.host.addClass(this.toThemeProperty('jqx-rc-b-expanded'));
                    listBox.addClass(this.toThemeProperty('jqx-rc-t-expanded'));
                    this.dropdownlistArrow.addClass(this.toThemeProperty('jqx-rc-b-expanded'));
                }
                else {
                    this.host.addClass(this.toThemeProperty('jqx-rc-t-expanded'));
                    listBox.addClass(this.toThemeProperty('jqx-rc-b-expanded'));
                    this.dropdownlistArrow.addClass(this.toThemeProperty('jqx-rc-t-expanded'));
                }
                listBox.addClass(this.toThemeProperty('jqx-fill-state-focus'));

                this._raiseEvent('0', listBoxInstance);
                listBox.addClass(this.toThemeProperty('jqx-popup-show'));
            },

            doMultiSelect: function (setFocus) {
                if (this.checkboxes) {
                    this.multiSelect = false;
                }

                var that = this;
                if (!this.multiSelect) {
                    var buttons = that.dropdownlistContent.find('.jqx-button');
                    var eventName = 'mousedown';
                    if (this.touch) {
                        eventName = $.jqx.mobile.getTouchEventName('touchstart');
                    }
                    this.removeHandler(buttons, eventName);
                    this.removeHandler(buttons.find('.jqx-icon-close'), eventName);
                    buttons.remove();
                    var items = this.listBox.items;
                    if (!items) return;
                    for (var i = 0; i < items.length; i++) {
                        items[i].disabled = false;
                    }
                    this.listBox._renderItems();

                    this.selectedItems = new Array();
                    this._selectedItems = new Array();
                    return;
                }

                if (this.validateSelection) {
                    var result = this.validateSelection(this.listBox.selectedValue);
                    if (!result) {
                        return;
                    }
                }

                var oldItems = this.selectedItems;
                if (this.listBox.selectedValue) {
                    if (this.selectedItems.indexOf(this.listBox.selectedValue) === -1) {
                        var item = this.getItemByValue(this.listBox.selectedValue);
                        if (item && item.visible) {
                            this.selectedItems.push(this.listBox.selectedValue);
                            this._selectedItems.push(item);
                            this._raiseEvent('2', { index: item.index, item: item });
                            this._raiseEvent('4', { index: item.index, item: item });
                        }
                    }
                    this.listBox.selectedIndex = -1;
                }

                var items = this.listBox.items;
                if (!items) return;
                for (var i = 0; i < items.length; i++) {
                    items[i].disabled = false;
                    if (this.selectedItems.indexOf(items[i].value) >= 0 || this._disabledItems.indexOf(this.value) >= 0) {
                        items[i].disabled = true;
                    }
                }
                this.listBox._renderItems();

                this.searchString = "";
                this.input.val("");
                var items = "";
                var eventName = 'mousedown';

                var buttons = that.dropdownlistContent.find('.jqx-button');
                if (this.touch) {
                    eventName = $.jqx.mobile.getTouchEventName('touchstart');
                }
                this.removeHandler(buttons, eventName);
                this.removeHandler(buttons.find('.jqx-icon-close'), eventName);
                buttons.remove();

                that.input.detach();
                if (this.selectedItems.length > 0) {
                    that.input.css('width', '25px');
                    if (this.isMaterialized() && that.hint) {
                        that.label[0].innerHTML = this.placeHolder;
                    }
                    else {
                        that.input.attr('placeholder', "");
                    }
                }
                else {
                    that.input.css('width', '100%');
                    if (that.isMaterialized() && that.hint) {
                        that.label[0].innerHTML = this.placeHolder;
                    }
                    else {
                        that.input.attr('placeholder', this.placeHolder);
                    }
                }

                if (that.isMaterialized()) {
                    if (that.hint) {
                        setTimeout(function () {
                            if (that.selectedItems.length === 0) {
                                that.element.removeAttribute('hint');
                                that.label[0].innerHTML = that.placeHolder;
                            }
                            else {
                                if (that.hint) {
                                    that.element.setAttribute('hint', true);
                                }
                            }
                        });
                    }
                }

                $.each(this.selectedItems, function (index) {
                    var item = that.getItemByValue(this);
                    if (!item || that.remoteAutoComplete) {
                        item = that._selectedItems[index];
                    }

                    var group = $('<div style="overflow: hidden; float: left;"></div>');
                    group.addClass(that.toThemeProperty('jqx-button'));
                    group.addClass(that.toThemeProperty('jqx-combobox-multi-item'));
                    group.addClass(that.toThemeProperty('jqx-fill-state-normal'));
                    group.addClass(that.toThemeProperty('jqx-rc-all'));
                    if (item) {
                        var text = item.label;
                        if (that.renderSelectedItem) {
                            var result = that.renderSelectedItem(index, item);
                            if (result) text = result;
                        }

                        if (group[0].innerHTML == '') {
                            group[0].innerHTML = '<a data-value="' + item.value + '" style="float: left;" href="#">' + text + '</a>';
                        }
                        if (that.rtl) {
                            group[0].innerHTML = '<a data-value="' + item.value + '" style="float: right;" href="#">' + text + '</a>';
                        }
                        var fl = !that.rtl ? 'right' : 'left';

                        if (that.showCloseButtons) {
                            var closebutton = '<div style="position: relative; overflow: hidden; float: ' + fl + '; min-height: 16px; min-width: 18px;"><div style="position: absolute; left: 100%; top: 50%; margin-left: -18px; margin-top: -7px; float: none; width: 16px; height: 16px;" class="' + that.toThemeProperty('jqx-icon-close') + '"></div></div>';
                            if ($.jqx.browser.msie && $.jqx.browser.version < 8) {
                                closebutton = '<div style="position: relative; overflow: hidden; float: left; min-height: 16px; min-width: 18px;"><div style="position: absolute; left: 100%; top: 50%; margin-left: -18px; margin-top: -7px; float: none; width: 16px; height: 16px;" class="' + that.toThemeProperty('jqx-icon-close') + '"></div></div>';
                            }
                            if (that.rtl) {
                                var closebutton = '<div style="position: relative; overflow: hidden; float: ' + fl + '; min-height: 16px; min-width: 18px;"><div style="position: absolute; left: 0px; top: 50%; margin-top: -7px; float: none; width: 16px; height: 16px;" class="' + that.toThemeProperty('jqx-icon-close') + '"></div></div>';
                                if ($.jqx.browser.msie && $.jqx.browser.version < 8) {
                                    closebutton = '<div style="position: relative; overflow: hidden; float: left; min-height: 16px; min-width: 18px;"><div style="position: absolute; left: 0px; top: 50%; margin-top: -7px; float: none; width: 16px; height: 16px;" class="' + that.toThemeProperty('jqx-icon-close') + '"></div></div>';
                                }
                            }

                            group[0].innerHTML += closebutton;
                        }
                    }
                    else {
                        if (group[0].innerHTML == '') {
                            group[0].innerHTML = '<a href="#"></a>';
                        }
                    }
                    that.dropdownlistContent.append(group);
                });
                that.dropdownlistContent.append(that.input);
                that.input.val("");
                if (setFocus !== false) {
                    that.input.focus();
                    setTimeout(function () {
                        that.input.focus();
                    }, 10);
                }
                var buttons = that.dropdownlistContent.find('.jqx-button');

                if (this.touchMode === true) eventName = "mousedown";
                this.addHandler(buttons, eventName, function (event) {
                    if (event.target.className.indexOf('jqx-icon-close') >= 0)
                        return true;

                    if (that.disabled) {
                        return true;
                    }

                    var text = $(event.target).attr('data-value');
                    var item = that.getItemByValue(text);
                    if (item) {
                        that.listBox.selectedValue = null;
                        that.listBox.clearSelection();
                    }
                    that.listBox.scrollTo(0, 0);
                    that.open();
                    if (event.preventDefault) {
                        event.preventDefault();
                    }
                    if (event.stopPropagation) {
                        event.stopPropagation();
                    }
                    return false;
                });
                this.addHandler(buttons.find('.jqx-icon-close'), eventName, function (event) {
                    if (that.disabled) {
                        return;
                    }

                    var text = $(event.target).parent().parent().find('a').attr('data-value');
                    var item = that.getItemByValue(text);
                    if (item || (that.remoteAutoComplete && !item && that.selectedItems.indexOf(text) >= 0)) {
                        that.listBox.selectedValue = null;
                        var index = that.selectedItems.indexOf(text);
                        var indx = item && item.index >= 0 ? item.index : index;
                        if (index >= 0) {
                            that.selectedItems.splice(index, 1);
                            var selectedItem = that._selectedItems[index];
                            if (!selectedItem) {
                                selectedItem = item;
                            }
                            that._selectedItems.splice(index, 1);

                            that._raiseEvent('3', { index: indx, type: 'mouse', item: selectedItem });
                            that._raiseEvent('4', { index: indx, type: 'mouse', item: selectedItem });
                            that.doMultiSelect();
                        }
                        else {
                            for (var i = 0; i < that.selectedItems.length; i++) {
                                var selectedItem = that.selectedItems[i];
                                if (selectedItem == text) {
                                    that.selectedItems.splice(i, 1);
                                    that._selectedItems.splice(i, 1);
                                    that._raiseEvent('3', { index: indx, type: 'mouse', item: item });
                                    that._raiseEvent('4', { index: indx, type: 'mouse', item: item });
                                    that.doMultiSelect();
                                    break;
                                }
                            }
                        }
                    }
                });

                if (this.isMaterialized()) {
                    this.host.height(this.dropdownlistContent.height());
                }

                this.bar.css('top', this.host.height());
                that.dropdownlistArrow.height(this.host.height());
                that._updateInputSelection();
            },

            // hides the listbox.
            hideListBox: function (mode) {
                var listBox = this.listBoxContainer;
                var listBoxInstance = this.listBox;
                var container = this.container;
                if (this.container[0].style.display == 'none')
                    return;

                this.element.setAttribute('opened', false);

                $.jqx.aria(this, "aria-expanded", false);

                if (mode == "keyboard" || mode == "mouse") {
                    this.listBox.searchString = "";
                }
                listBox.removeClass('jqx-popup-show');

                if (mode == "keyboard" || mode == "mouse" && this.multiSelect) {
                    this.doMultiSelect();
                }

                var that = this;
                $.data(document.body, "openedCombojqxListBox" + this.element.id, null);
                if (this.animationType == 'none') {
                    this.opening = false;
                    this.container.css('display', 'none');
                }
                else if (this.animationType === 'transform') {
                    setTimeout(function () {
                        container.css('display', 'none');
                    }, this.closeDelay);
                }
                else {
                    if (!this.ishiding) {
                        var height = listBox.outerHeight();
                        listBox.css('margin-top', 0);
                        listBox.stop();
                        this.opening = false;
                        this.isanimating = true;
                        var animationValue = -height;
                        if (parseInt(this.container.coord().top) < parseInt(this.host.coord().top)) {
                            animationValue = height;
                        }
                        if (this.animationType == 'fade') {
                            listBox.css({ 'opacity': 1 });
                            listBox.animate({ 'opacity': 0 }, this.closeDelay, function () {
                                that.isanimating = false;
                                container.css('display', 'none');
                                that.ishiding = false;
                            });
                        }
                        else {
                            listBox.animate({ 'margin-top': animationValue }, this.closeDelay, function () {
                                that.isanimating = false;
                                container.css('display', 'none'); that.ishiding = false;
                            });
                        }
                    }
                }

                this.ishiding = true;
                this.host.removeClass(this.toThemeProperty('jqx-combobox-state-selected'));
                this.dropdownlistArrowIcon.removeClass(this.toThemeProperty('jqx-icon-arrow-down-selected'));
                this.dropdownlistArrowIcon.removeClass(this.toThemeProperty('jqx-icon-arrow-up-selected'));
                this.dropdownlistArrow.removeClass(this.toThemeProperty('jqx-combobox-arrow-selected'));
                this.dropdownlistArrow.removeClass(this.toThemeProperty('jqx-fill-state-pressed'));
                if (!this.focused) {
                    this.host.removeClass(this.toThemeProperty('jqx-combobox-state-focus'));
                    this.host.removeClass(this.toThemeProperty('jqx-fill-state-focus'));
                    this.dropdownlistContent.removeClass(this.toThemeProperty('jqx-combobox-content-focus'));
                }
                this.host.removeClass(this.toThemeProperty('jqx-rc-b-expanded'));
                listBox.removeClass(this.toThemeProperty('jqx-rc-t-expanded'));
                this.host.removeClass(this.toThemeProperty('jqx-rc-t-expanded'));
                listBox.removeClass(this.toThemeProperty('jqx-rc-b-expanded'));
                listBox.removeClass(this.toThemeProperty('jqx-fill-state-focus'));
                this.dropdownlistArrow.removeClass(this.toThemeProperty('jqx-rc-t-expanded'));
                this.dropdownlistArrow.removeClass(this.toThemeProperty('jqx-rc-b-expanded'));

                this._raiseEvent('1', listBoxInstance);
            },

            /* Close popup if clicked elsewhere. */
            closeOpenedListBox: function (event) {
                var that = event.data.that;
                var $target = $(event.target);
                var openedListBox = event.data.listbox;
                if (openedListBox == null)
                    return true;

                if ($(event.target).ischildof(that.host)) {
                    return;
                }

                var dropdownlistInstance = that;

                var isListBox = false;
                $.each($target.parents(), function () {
                    if (this.className != 'undefined') {
                        if (this.className.indexOf) {
                            if (this.className.indexOf('jqx-listbox') != -1) {
                                isListBox = true;
                                return false;
                            }
                            if (this.className.indexOf('jqx-combobox') != -1) {
                                if (that.element.id == this.id) {
                                    isListBox = true;
                                }
                                return false;
                            }
                        }
                    }
                });

                if (openedListBox != null && !isListBox) {
                    if (that.isOpened()) {
                        that.hideListBox('api');
                        that.input.blur();
                    }
                }

                return true;
            },

            loadFromSelect: function (id) {
                this.listBox.loadFromSelect(id);
                this.clearSelection();
            },

            refresh: function (initialRefresh) {
                this._setSize();
                this._arrange();
                if (this.listBox) {
                    this.renderSelection();
                }
            },

            resize: function () {
                this._setSize();
                this._arrange();
            },

            _arrange: function () {
                var width = parseInt(this.host.width());
                var height = parseInt(this.host.height());

                var arrowHeight = this.arrowSize;
                var arrowWidth = this.arrowSize;

                var rightOffset = 1;
                if (!this.showArrow) {
                    arrowWidth = 0;
                    arrowHeight = 0;
                    this.dropdownlistArrow.hide();
                    rightOffset = 0;
                    this.host.css('cursor', 'arrow');
                    if (this.theme === "fluent") {
                        rightOffset = 1;
                    }
                }
                else {
                    if (this.dropdownlistArrow[0].style.display === "none") {
                        this.dropdownlistArrow.show();
                    }
                }
                var contentWidth = width - arrowWidth - 1 * rightOffset;
                if (contentWidth > 0) {
                    this.dropdownlistContent[0].style.width = contentWidth + 'px';
                }
                if (this.rtl) {
                    this.dropdownlistContent[0].style.width = (-1 + contentWidth + 'px');
                }

                this.dropdownlistContent[0].style.height = height + 'px';
                this.dropdownlistContent[0].style.left = '0px';
                this.dropdownlistContent[0].style.top = '0px';
                this.dropdownlistArrow[0].style.width = arrowWidth + 'px';
                this.dropdownlistArrow[0].style.height = height + 'px';
                this.dropdownlistArrow[0].style.left = 1 + contentWidth + 'px';

                this.input[0].style.width = '100%';

                if (!this.multiSelect) {
                    this.input.height(height);
                }

                var inputHeight = this.input.height();
                if (inputHeight == 0) {
                    inputHeight = parseInt(this.input.css('font-size')) + 3;
                }

                if (this.input[0].className.indexOf('jqx-rc-all') == -1) {
                    this.input.addClass(this.toThemeProperty('jqx-rc-all'));
                }

                var top = parseInt(height) / 2 - parseInt(inputHeight) / 2;
                if (top > 0) {
                    //      this.input[0].style.marginTop = parseInt(top) + "px";
                }

                if (this.rtl) {
                    this.dropdownlistArrow.css('left', '0px');
                    this.dropdownlistContent.css('left', this.dropdownlistArrow.width());
                    if ($.jqx.browser.msie && $.jqx.browser.version <= 8) {
                        this.dropdownlistContent.css('left', 1 + this.dropdownlistArrow.width());
                    }
                }
                if (this.multiSelect) {
                    this.input.css('float', 'left');
                    this.input.width(25);
                    this.dropdownlistWrapper.parent().css('height', 'auto');
                    this.dropdownlistContent.css('height', 'auto');
                    this.dropdownlistWrapper.css('height', 'auto');
                    this.dropdownlistContent.css('position', 'relative');
                    this.dropdownlistContent.css('cursor', 'text');
                    this.host.css('height', 'auto');
                    this.host.css('min-height', this.height);
                    this.dropdownlistContent.css('min-height', this.height);
                    var height = parseInt(this.host.height());
                    this.dropdownlistArrow.height(height);
                    var initialHeight = parseInt(this.host.css('min-height'));
                    var top = parseInt(initialHeight) / 2 - parseInt(inputHeight) / 2;
                    if (top > 0) {
                        this.input.css('margin-top', top);
                    }


                    if (this.isMaterialized()) {
                        this.host.height(this.dropdownlistContent.height());
                    }

                    this.bar.css('top', this.host.height());
                    this.dropdownlistArrow.height(this.host.height());
                }
            },

            destroy: function () {
                if (this.source && this.source.unbindBindingUpdate) {
                    this.source.unbindBindingUpdate(this.element.id);
                    this.source.unbindBindingUpdate(this.listBoxContainer[0].id);
                    this.source.unbindDownloadComplete(this.element.id);
                    this.source.unbindDownloadComplete(this.listBoxContainer[0].id);
                }
                $.jqx.utilities.resize(this.host, null, true);
                this.removeHandler(this.listBoxContainer, 'select');
                this.removeHandler(this.listBoxContainer, 'unselect');
                this.removeHandler(this.listBoxContainer, 'change');
                this.removeHandler(this.listBoxContainer, 'bindingComplete');
                this.removeHandler(this.dropdownlistWrapper, 'selectstart');
                this.removeHandler(this.dropdownlistWrapper, 'mousedown');
                this.removeHandler(this.host, 'keydown');
                this.removeHandler(this.listBoxContainer, 'select');
                this.removeHandler(this.listBox.content, 'click');
                this.removeHandlers();
                this.removeHandler(this.input, 'keyup.textchange');

                this.listBoxContainer.jqxListBox('destroy');
                this.listBoxContainer.remove();
                this.host.removeClass();
                this.removeHandler($(document), 'mousedown.' + this.id, this.closeOpenedListBox);
                if (this.touch) {
                    this.removeHandler($(document), $.jqx.mobile.getTouchEventName('touchstart') + '.' + this.id);
                }
                this.cinput.remove();
                delete this.cinput;
                this.dropdownlistArrow.remove();
                delete this.dropdownlistArrow;
                this.dropdownlistArrowIcon.remove();
                delete this.dropdownlistArrowIcon;
                delete this.dropdownlistWrapper;
                delete this.listBoxContainer;
                delete this.input;
                delete this.dropdownlistContent;
                delete this.comboStructure;
                this.container.remove();
                delete this.listBox;
                delete this.container;
                var vars = $.data(this.element, "jqxComboBox");
                if (vars) {
                    delete vars.instance;
                }
                this.host.removeData();
                this.host.remove();
                delete this.host;
                delete this.set;
                delete this.get;
                delete this.call;
                delete this.element;
            },

            //[optimize]
            _raiseEvent: function (id, arg) {
                if (arg == undefined)
                    arg = { owner: null };

                var evt = this.events[id];
                var args = arg;
                args.owner = this;

                var event = new $.Event(evt);
                event.owner = this;
                if (id == 2 || id == 3 || id == 4 || id == 5 || id == 6 || id == 7 || id == 8 || id == 9) {
                    event.args = arg;
                }

                var result = this.host.trigger(event);
                return result;
            },

            propertiesChangedHandler: function (object, key, value) {
                if (value.width && value.height && Object.keys(value).length == 2) {
                    object._setSize();
                    if (key == 'width') {
                        if (object.dropDownWidth == 'auto') {
                            var width = object.host.width();
                            object.listBoxContainer.jqxListBox({ width: width });
                            object.container.width(parseInt(width) + 25);
                        }
                    }
                    object._arrange();
                    object.close();
                }
            },

            propertyChangedHandler: function (object, key, oldvalue, value) {
                if (object.isInitialized == undefined || object.isInitialized == false)
                    return;

                if (object.batchUpdate && object.batchUpdate.width && object.batchUpdate.height && Object.keys(object.batchUpdate).length == 2) {
                    return;
                }

                if (key == "template") {
                    object.listBoxContainer.removeClass(object.toThemeProperty("jqx-" + oldvalue + "-item"));
                    object.listBoxContainer.addClass(object.toThemeProperty("jqx-" + object.template + "-item"));
                    object.dropDownListArrow.removeClass(object.toThemeProperty("jqx-" + oldvalue + ""));
                    object.dropDownListArrow.addClass(object.toThemeProperty("jqx-" + object.template + ""));

                    var that = this;

                    that.bar.removeClass(that.toThemeProperty("jqx-" + oldvalue));
                    that.label.removeClass(that.toThemeProperty("jqx-" + oldvalue));
                    that.bar.addClass(that.toThemeProperty("jqx-" + that.template));
                    that.label.addClass(that.toThemeProperty("jqx-" + that.template));

                }

                if (key == "dropDownVerticalAlignment") {
                    object.close();
                    object.dropdownlistArrowIcon.removeClass(object.toThemeProperty('jqx-icon-arrow-up'));
                    object.dropdownlistArrowIcon.removeClass(object.toThemeProperty('jqx-icon-arrow-down'));
                    if (object.dropDownVerticalAlignment == "top") {
                        object.dropdownlistArrowIcon.addClass(object.toThemeProperty('jqx-icon-arrow-up'));
                    }
                    else {
                        object.dropdownlistArrowIcon.addClass(object.toThemeProperty('jqx-icon-arrow-down'));
                    }
                    object.listBoxContainer.css('top', 0);
                    object.listBoxContainer.removeClass(this.toThemeProperty('jqx-popup-up'));
                }

                if (key == "autoItemsHeight") {
                    object.listBoxContainer.jqxListBox({ autoItemsHeight: value });
                }

                if (key == "itemHeight") {
                    object.listBoxContainer.jqxListBox({ itemHeight: value });
                }

                if (key == "renderSelectedItem") {
                    object.renderSelection('mouse');
                }

                if (key == "renderer") {
                    object.listBoxContainer.jqxListBox({ renderer: value });
                }

                if (key == "enableSelection") {
                    object.listBoxContainer.jqxListBox({ enableSelection: value });
                }
                if (key == "enableHover") {
                    object.listBoxContainer.jqxListBox({ enableHover: value });
                }

                if (key === "touchMode") {
                    object.listBoxContainer.jqxListBox({ touchMode: value });
                    object.touch = $.jqx.mobile.isTouchDevice();
                    if (object.touchMode === true) {
                        object.touch = true;
                    }
                    object._updateHandlers();
                }

                if (key == "multiSelect") {
                    if (value) {
                        object.doMultiSelect(false);
                    }
                    else {
                        var items = object.listBox.items;
                        var selectedIndex = -1;
                        for (var i = 0; i < items.length; i++) {
                            items[i].disabled = false;
                            if (object.selectedItems.indexOf(items[i].value) >= 0 || object._disabledItems.indexOf(object.value) >= 0) {
                                items[i].disabled = true;
                                selectedIndex = items[i].index;
                            }
                        }
                        object.doMultiSelect(false);
                        object.listBox._renderItems();
                        if (!items) return;
                        object.listBox.selectedIndex = selectedIndex;
                        object.renderSelection('mouse');
                        object.dropdownlistWrapper.parent().css('height', '100%');
                        object.dropdownlistContent.css('height', '100');
                        object.dropdownlistWrapper.css('height', '100');
                        object.dropdownlistContent.css('position', 'relative');
                        object.host.css('min-height', null);
                        object._setSize();
                        object._arrange();
                    }
                }

                if (key == "showArrow") {
                    object._arrange();
                    if (object.multiSelect) {
                        object.doMultiSelect(false);
                    }
                }

                if (key == "placeHolder") {
                    if (object.isMaterialized()) {
                        object.label.innerHTML = object.placeHolder;
                    }
                    else {
                        object.input.attr('placeholder', object.placeHolder);
                    }
                }

                if (key == 'popupZIndex') {
                    object.listBoxContainer.css({ zIndex: object.popupZIndex });
                }

                if (key == 'promptText') {
                    object.placeHolder = value;
                }

                if (key == 'autoOpen') {
                    object._updateHandlers();
                }

                if (key == 'renderer') {
                    object.listBox.renderer = object.renderer;
                }
                if (key == 'itemHeight') {
                    object.listBox.itemHeight = value;
                }

                if (key == 'source') {
                    object.input.val("");
                    object.listBoxContainer.jqxListBox({ source: object.source });
                    object.renderSelection('mouse');
                    if (object.source == null) {
                        object.clearSelection();
                    }
                    if (object.multiSelect) {
                        object.selectedItems = new Array();
                        object._selectedItems = new Array();
                        object.doMultiSelect(false);
                    }
                }
                if (key == "rtl") {
                    if (value) {
                        object.dropdownlistArrow.css('float', 'left');
                        object.dropdownlistContent.css('float', 'right');
                    }
                    else {
                        object.dropdownlistArrow.css('float', 'right');
                        object.dropdownlistContent.css('float', 'left');
                    }
                    object.listBoxContainer.jqxListBox({ rtl: object.rtl });
                }
                if (key == "displayMember" || key == "valueMember") {
                    object.listBoxContainer.jqxListBox({ displayMember: object.displayMember, valueMember: object.valueMember });
                    object.renderSelection('mouse');
                }

                if (key == "autoDropDownHeight") {
                    object.listBoxContainer.jqxListBox({ autoHeight: object.autoDropDownHeight });
                    if (object.autoDropDownHeight) {
                        object.container.height(object.listBoxContainer.height() + 25);
                    }
                    else {
                        object.listBoxContainer.jqxListBox({ height: object.dropDownHeight });
                        object.container.height(parseInt(object.dropDownHeight) + 25);
                    }

                    object.listBox._arrange();
                    object.listBox._updatescrollbars();
                }

                if (key == "dropDownHeight") {
                    if (!object.autoDropDownHeight) {
                        object.listBoxContainer.jqxListBox({ height: object.dropDownHeight });
                        object.container.height(parseInt(object.dropDownHeight) + 25);
                    }
                }

                if (key == "dropDownWidth" || key == "scrollBarSize") {
                    var width = object.width;
                    if (object.dropDownWidth != 'auto') {
                        width = object.dropDownWidth;
                    }

                    object.listBoxContainer.jqxListBox({ width: width, scrollBarSize: object.scrollBarSize });
                    object.container.width(parseInt(width) + 25);
                }

                if (key == 'autoComplete') {
                    object._resetautocomplete();
                }

                if (key == "checkboxes") {
                    object.listBoxContainer.jqxListBox({ checkboxes: object.checkboxes });
                    if (object.checkboxes) {
                        object.input.attr('readonly', true);
                        $.jqx.aria(object, "aria-readonly", true);
                    }
                    else {
                        $.jqx.aria(object, "aria-readonly", false);
                    }
                }

                if (key == 'theme' && value != null) {
                    object.listBoxContainer.jqxListBox({ theme: value });
                    object.listBoxContainer.addClass(object.toThemeProperty('jqx-popup'));
                    if ($.jqx.browser.msie) {
                        object.listBoxContainer.addClass(object.toThemeProperty('jqx-noshadow'));
                    }
                    $.jqx.utilities.setTheme(oldvalue, value, object.host);
                }

                if (key == 'rtl') {
                    object.render();
                    object.refresh();
                }

                if (key == 'width' || key == 'height') {
                    object._setSize();
                    if (key == 'width') {
                        if (object.dropDownWidth == 'auto') {
                            var width = object.host.width();
                            object.listBoxContainer.jqxListBox({ width: width });
                            object.container.width(parseInt(width) + 25);
                        }
                    }
                    object._arrange();
                    object.close();
                }

                if (key == 'selectedIndex') {
                    object.listBox.selectIndex(value);
                    object.renderSelection('mouse');
                }
            }
        });
    })(jqxBaseFramework);
})();



/***/ }),

/***/ 5459:
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/* tslint:disable */
/* eslint-disable */
(function(){
	if (typeof document === 'undefined') { 
		return;
	}
		
	var oldBrowser = document.all && !document.addEventListener;
	if (!oldBrowser) {
		(function (window, undefined) {
			var
				rootJQXLite,
				readyList,
				document = window.document,
				location = window.location,
				navigator = window.navigator,
				_JQXLite = window.JQXLite,
				_$ = window.$,

				// Save a reference to some core methods
				core_push = Array.prototype.push,
				core_slice = Array.prototype.slice,
				core_indexOf = Array.prototype.indexOf,
				core_toString = Object.prototype.toString,
				core_hasOwn = Object.prototype.hasOwnProperty,
				core_trim = String.prototype.trim,

				// Define a local copy of JQXLite
				JQXLite = function (selector, context) {
					// The JQXLite object is actually just the init constructor 'enhanced'
					return new JQXLite.fn.init(selector, context, rootJQXLite);
				},

				// Used for matching numbers
				core_pnum = /[\-+]?(?:\d*\.|)\d+(?:[eE][\-+]?\d+|)/.source,

				// Used for detecting and trimming whitespace
				core_rnotwhite = /\S/,
				core_rspace = /\s+/,

				// Make sure we trim BOM and NBSP (here's looking at you, Safari 5.0 and IE)
				rtrim = /^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,

				// A simple way to check for HTML strings
				// Prioritize #id over <tag> to avoid XSS via location.hash (#9521)
				rquickExpr = /^(?:[^#<]*(<[\w\W]+>)[^>]*$|#([\w\-]*)$)/,

				// Match a standalone tag
				rsingleTag = /^<(\w+)\s*\/?>(?:<\/\1>|)$/,

				// JSON RegExp
				rvalidchars = /^[\],:{}\s]*$/,
				rvalidbraces = /(?:^|:|,)(?:\s*\[)+/g,
				rvalidescape = /\\(?:["\\\/bfnrt]|u[\da-fA-F]{4})/g,
				rvalidtokens = /"[^"\\\r\n]*"|true|false|null|-?(?:\d\d*\.|)\d+(?:[eE][\-+]?\d+|)/g,

				// Matches dashed string for camelizing
				rmsPrefix = /^-ms-/,
				rdashAlpha = /-([\da-z])/gi,

				// Used by JQXLite.camelCase as callback to replace()
				fcamelCase = function (all, letter) {
					return (letter + "").toUpperCase();
				},

				// The ready event handler and self cleanup method
				DOMContentLoaded = function () {
					if (document.addEventListener) {
						document.removeEventListener("DOMContentLoaded", DOMContentLoaded, false);
						JQXLite.ready();
					} else if (document.readyState === "complete") {
						// we're here because readyState === "complete" in oldIE
						// which is good enough for us to call the dom ready!
						document.detachEvent("onreadystatechange", DOMContentLoaded);
						JQXLite.ready();
					}
				},

				// [[Class]] -> type pairs
				class2type = {};

			JQXLite.fn = JQXLite.prototype = {
				constructor: JQXLite,
				init: function (selector, context, rootJQXLite) {
					var match, elem, ret, doc;

					// Handle $(""), $(null), $(undefined), $(false)
					if (!selector) {
						return this;
					}

					// Handle $(DOMElement)
					if (selector.nodeType) {
						this.context = this[0] = selector;
						this.length = 1;
						return this;
					}

					// Handle HTML strings
					if (typeof selector === "string") {
						if (selector.charAt(0) === "<" && selector.charAt(selector.length - 1) === ">" && selector.length >= 3) {
							// Assume that strings that start and end with <> are HTML and skip the regex check
							match = [null, selector, null];

						} else {
							match = rquickExpr.exec(selector);
						}

						// Match html or make sure no context is specified for #id
						if (match && (match[1] || !context)) {

							// HANDLE: $(html) -> $(array)
							if (match[1]) {
								context = context instanceof JQXLite ? context[0] : context;
								doc = (context && context.nodeType ? context.ownerDocument || context : document);

								// scripts is true for back-compat
								selector = JQXLite.parseHTML(match[1], doc, true);
								if (rsingleTag.test(match[1]) && JQXLite.isPlainObject(context)) {
									this.attr.call(selector, context, true);
								}

								return JQXLite.merge(this, selector);

								// HANDLE: $(#id)
							} else {
								elem = document.getElementById(match[2]);

								// Check parentNode to catch when Blackberry 4.6 returns
								// nodes that are no longer in the document #6963
								if (elem && elem.parentNode) {
									// Handle the case where IE and Opera return items
									// by name instead of ID
									if (elem.id !== match[2]) {
										return rootJQXLite.find(selector);
									}

									// Otherwise, we inject the element directly into the JQXLite object
									this.length = 1;
									this[0] = elem;
								}

								this.context = document;
								this.selector = selector;
								return this;
							}

							// HANDLE: $(expr, $(...))
						} else if (!context || context.jqx) {
							return (context || rootJQXLite).find(selector);

							// HANDLE: $(expr, context)
							// (which is just equivalent to: $(context).find(expr)
						} else {
							return this.constructor(context).find(selector);
						}

						// HANDLE: $(function)
						// Shortcut for document ready
					} else if (JQXLite.isFunction(selector)) {
						return rootJQXLite.ready(selector);
					}

					if (selector.selector !== undefined) {
						this.selector = selector.selector;
						this.context = selector.context;
					}

					return JQXLite.makeArray(selector, this);
				},

				// Start with an empty selector
				selector: "",

				// The current version of JQXLite being used
				jqx: "4.5.0",

				// The default length of a JQXLite object is 0
				length: 0,

				// The number of elements contained in the matched element set
				size: function () {
					return this.length;
				},

				toArray: function () {
					return core_slice.call(this);
				},

				// Get the Nth element in the matched element set OR
				// Get the whole matched element set as a clean array
				get: function (num) {
					return num == null ?

						// Return a 'clean' array
						this.toArray() :

						// Return just the object
						(num < 0 ? this[this.length + num] : this[num]);
				},

				// Take an array of elements and push it onto the stack
				// (returning the new matched element set)
				pushStack: function (elems, name, selector) {

					// Build a new JQXLite matched element set
					var ret = JQXLite.merge(this.constructor(), elems);

					// Add the old object onto the stack (as a reference)
					ret.prevObject = this;

					ret.context = this.context;

					if (name === "find") {
						ret.selector = this.selector + (this.selector ? " " : "") + selector;
					} else if (name) {
						ret.selector = this.selector + "." + name + "(" + selector + ")";
					}

					// Return the newly-formed element set
					return ret;
				},

				// Execute a callback for every element in the matched set.
				// (You can seed the arguments with an array of args, but this is
				// only used internally.)
				each: function (callback, args) {
					return JQXLite.each(this, callback, args);
				},

				ready: function (fn) {
					// Add the callback
					JQXLite.ready.promise().done(fn);

					return this;
				},

				eq: function (i) {
					i = +i;
					return i === -1 ?
						this.slice(i) :
						this.slice(i, i + 1);
				},

				first: function () {
					return this.eq(0);
				},

				last: function () {
					return this.eq(-1);
				},

				slice: function () {
					return this.pushStack(core_slice.apply(this, arguments),
						"slice", core_slice.call(arguments).join(","));
				},

				map: function (callback) {
					return this.pushStack(JQXLite.map(this, function (elem, i) {
						return callback.call(elem, i, elem);
					}));
				},

				end: function () {
					return this.prevObject || this.constructor(null);
				},

				// For internal use only.
				// Behaves like an Array's method, not like a JQXLite method.
				push: core_push,
				sort: [].sort,
				splice: [].splice
			};

			// Give the init function the JQXLite prototype for later instantiation
			JQXLite.fn.init.prototype = JQXLite.fn;

			JQXLite.extend = JQXLite.fn.extend = function () {
				var options, name, src, copy, copyIsArray, clone,
					target = arguments[0] || {},
					i = 1,
					length = arguments.length,
					deep = false;

				// Handle a deep copy situation
				if (typeof target === "boolean") {
					deep = target;
					target = arguments[1] || {};
					// skip the boolean and the target
					i = 2;
				}

				// Handle case when target is a string or something (possible in deep copy)
				if (typeof target !== "object" && !JQXLite.isFunction(target)) {
					target = {};
				}

				// extend JQXLite itself if only one argument is passed
				if (length === i) {
					target = this;
					--i;
				}

				for (; i < length; i++) {
					// Only deal with non-null/undefined values
					if ((options = arguments[i]) != null) {
						// Extend the base object
						for (name in options) {
							src = target[name];
							copy = options[name];

							// Prevent never-ending loop
							if (target === copy) {
								continue;
							}

							// Recurse if we're merging plain objects or arrays
							if (deep && copy && (JQXLite.isPlainObject(copy) || (copyIsArray = JQXLite.isArray(copy)))) {
								if (copyIsArray) {
									copyIsArray = false;
									clone = src && JQXLite.isArray(src) ? src : [];

								} else {
									clone = src && JQXLite.isPlainObject(src) ? src : {};
								}

								// Never move original objects, clone them
								target[name] = JQXLite.extend(deep, clone, copy);

								// Don't bring in undefined values
							} else if (copy !== undefined) {
								target[name] = copy;
							}
						}
					}
				}

				// Return the modified object
				return target;
			};

			JQXLite.extend({
				noConflict: function (deep) {
					if (window.$ === JQXLite) {
						window.$ = _$;
					}

					if (deep && window.JQXLite === JQXLite) {
						window.JQXLite = _JQXLite;
					}

					return JQXLite;
				},

				// Is the DOM ready to be used? Set to true once it occurs.
				isReady: false,

				// A counter to track how many items to wait for before
				// the ready event fires. See #6781
				readyWait: 1,

				// Hold (or release) the ready event
				holdReady: function (hold) {
					if (hold) {
						JQXLite.readyWait++;
					} else {
						JQXLite.ready(true);
					}
				},

				// Handle when the DOM is ready
				ready: function (wait) {

					// Abort if there are pending holds or we're already ready
					if (wait === true ? --JQXLite.readyWait : JQXLite.isReady) {
						return;
					}

					// Make sure body exists, at least, in case IE gets a little overzealous (ticket #5443).
					if (!document.body) {
						return setTimeout(JQXLite.ready, 1);
					}

					// Remember that the DOM is ready
					JQXLite.isReady = true;

					// If a normal DOM Ready event fired, decrement, and wait if need be
					if (wait !== true && --JQXLite.readyWait > 0) {
						return;
					}

					// If there are functions bound, to execute
					readyList.resolveWith(document, [JQXLite]);

					// Trigger any bound ready events
					if (JQXLite.fn.trigger) {
						JQXLite(document).trigger("ready").off("ready");
					}
				},

				// See test/unit/core.js for details concerning isFunction.
				// Since version 1.3, DOM methods and functions like alert
				// aren't supported. They return false on IE (#2968).
				isFunction: function (obj) {
					return JQXLite.type(obj) === "function";
				},

				isArray: Array.isArray || function (obj) {
					return JQXLite.type(obj) === "array";
				},

				isWindow: function (obj) {
					return obj != null && obj == obj.window;
				},

				isNumeric: function (obj) {
					return !isNaN(parseFloat(obj)) && isFinite(obj);
				},

				type: function (obj) {
					return obj == null ?
						String(obj) :
						class2type[core_toString.call(obj)] || "object";
				},

				isPlainObject: function (obj) {
					// Must be an Object.
					// Because of IE, we also have to check the presence of the constructor property.
					// Make sure that DOM nodes and window objects don't pass through, as well
					if (!obj || JQXLite.type(obj) !== "object" || obj.nodeType || JQXLite.isWindow(obj)) {
						return false;
					}

					try {
						// Not own constructor property must be Object
						if (obj.constructor &&
							!core_hasOwn.call(obj, "constructor") &&
							!core_hasOwn.call(obj.constructor.prototype, "isPrototypeOf")) {
							return false;
						}
					} catch (e) {
						// IE8,9 Will throw exceptions on certain host objects #9897
						return false;
					}

					// Own properties are enumerated firstly, so to speed up,
					// if last one is own, then all properties are own.

					var key;
					for (key in obj) { }

					return key === undefined || core_hasOwn.call(obj, key);
				},

				isEmptyObject: function (obj) {
					var name;
					for (name in obj) {
						return false;
					}
					return true;
				},

				error: function (msg) {
					throw new Error(msg);
				},

				// data: string of html
				// context (optional): If specified, the fragment will be created in this context, defaults to document
				// scripts (optional): If true, will include scripts passed in the html string
				parseHTML: function (data, context, scripts) {
					var parsed;
					if (!data || typeof data !== "string") {
						return null;
					}
					if (typeof context === "boolean") {
						scripts = context;
						context = 0;
					}
					context = context || document;

					// Single tag
					if ((parsed = rsingleTag.exec(data))) {
						return [context.createElement(parsed[1])];
					}

					parsed = JQXLite.buildFragment([data], context, scripts ? null : []);
					return JQXLite.merge([],
						(parsed.cacheable ? JQXLite.clone(parsed.fragment) : parsed.fragment).childNodes);
				},

				parseJSON: function (data) {
					if (!data || typeof data !== "string") {
						return null;
					}

					// Make sure leading/trailing whitespace is removed (IE can't handle it)
					data = JQXLite.trim(data);

					// Attempt to parse using the native JSON parser first
					if (window.JSON && window.JSON.parse) {
						return window.JSON.parse(data);
					}

					// Make sure the incoming data is actual JSON
					// Logic borrowed from http://json.org/json2.js
					if (rvalidchars.test(data.replace(rvalidescape, "@")
						.replace(rvalidtokens, "]")
						.replace(rvalidbraces, ""))) {

						return (new Function("return " + data))();

					}
					JQXLite.error("Invalid JSON: " + data);
				},

				// Cross-browser xml parsing
				parseXML: function (data) {
					var xml, tmp;
					if (!data || typeof data !== "string") {
						return null;
					}
					try {
						if (window.DOMParser) { // Standard
							tmp = new DOMParser();
							xml = tmp.parseFromString(data, "text/xml");
						} else { // IE
							xml = new ActiveXObject("Microsoft.XMLDOM");
							xml.async = "false";
							xml.loadXML(data);
						}
					} catch (e) {
						xml = undefined;
					}
					if (!xml || !xml.documentElement || xml.getElementsByTagName("parsererror").length) {
						JQXLite.error("Invalid XML: " + data);
					}
					return xml;
				},

				noop: function () { },

				// Evaluates a script in a global context
				// Workarounds based on findings by Jim Driscoll
				// http://weblogs.java.net/blog/driscoll/archive/2009/09/08/eval-javascript-global-context
				globalEval: function (data) {
					if (data && core_rnotwhite.test(data)) {
						// We use execScript on Internet Explorer
						// We use an anonymous function so that context is window
						// rather than JQXLite in Firefox
						(window.execScript || function (data) {
							window["eval"].call(window, data);
						})(data);
					}
				},

				// Convert dashed to camelCase; used by the css and data modules
				// Microsoft forgot to hump their vendor prefix (#9572)
				camelCase: function (string) {
					return string.replace(rmsPrefix, "ms-").replace(rdashAlpha, fcamelCase);
				},

				nodeName: function (elem, name) {
					return elem.nodeName && elem.nodeName.toLowerCase() === name.toLowerCase();
				},

				// args is for internal usage only
				each: function (obj, callback, args) {
					var name,
						i = 0,
						length = obj.length,
						isObj = length === undefined || JQXLite.isFunction(obj);

					if (args) {
						if (isObj) {
							for (name in obj) {
								if (callback.apply(obj[name], args) === false) {
									break;
								}
							}
						} else {
							for (; i < length;) {
								if (callback.apply(obj[i++], args) === false) {
									break;
								}
							}
						}

						// A special, fast, case for the most common use of each
					} else {
						if (isObj) {
							for (name in obj) {
								if (callback.call(obj[name], name, obj[name]) === false) {
									break;
								}
							}
						} else {
							for (; i < length;) {
								if (callback.call(obj[i], i, obj[i++]) === false) {
									break;
								}
							}
						}
					}

					return obj;
				},

				// Use native String.trim function wherever possible
				trim: core_trim && !core_trim.call("\uFEFF\xA0") ?
					function (text) {
						return text == null ?
							"" :
							core_trim.call(text);
					} :

					// Otherwise use our own trimming functionality
					function (text) {
						return text == null ?
							"" :
							(text + "").replace(rtrim, "");
					},

				// results is for internal usage only
				makeArray: function (arr, results) {
					var type,
						ret = results || [];

					if (arr != null) {
						// The window, strings (and functions) also have 'length'
						// Tweaked logic slightly to handle Blackberry 4.7 RegExp issues #6930
						type = JQXLite.type(arr);

						if (arr.length == null || type === "string" || type === "function" || type === "regexp" || JQXLite.isWindow(arr)) {
							core_push.call(ret, arr);
						} else {
							JQXLite.merge(ret, arr);
						}
					}

					return ret;
				},

				inArray: function (elem, arr, i) {
					var len;

					if (arr) {
						if (core_indexOf) {
							return core_indexOf.call(arr, elem, i);
						}

						len = arr.length;
						i = i ? i < 0 ? Math.max(0, len + i) : i : 0;

						for (; i < len; i++) {
							// Skip accessing in sparse arrays
							if (i in arr && arr[i] === elem) {
								return i;
							}
						}
					}

					return -1;
				},

				merge: function (first, second) {
					var l = second.length,
						i = first.length,
						j = 0;

					if (typeof l === "number") {
						for (; j < l; j++) {
							first[i++] = second[j];
						}

					} else {
						while (second[j] !== undefined) {
							first[i++] = second[j++];
						}
					}

					first.length = i;

					return first;
				},

				grep: function (elems, callback, inv) {
					var retVal,
						ret = [],
						i = 0,
						length = elems.length;
					inv = !!inv;

					// Go through the array, only saving the items
					// that pass the validator function
					for (; i < length; i++) {
						retVal = !!callback(elems[i], i);
						if (inv !== retVal) {
							ret.push(elems[i]);
						}
					}

					return ret;
				},

				// arg is for internal usage only
				map: function (elems, callback, arg) {
					var value, key,
						ret = [],
						i = 0,
						length = elems.length,
						// jqx objects are treated as arrays
						isArray = elems instanceof JQXLite || length !== undefined && typeof length === "number" && ((length > 0 && elems[0] && elems[length - 1]) || length === 0 || JQXLite.isArray(elems));

					// Go through the array, translating each of the items to their
					if (isArray) {
						for (; i < length; i++) {
							value = callback(elems[i], i, arg);

							if (value != null) {
								ret[ret.length] = value;
							}
						}

						// Go through every key on the object,
					} else {
						for (key in elems) {
							value = callback(elems[key], key, arg);

							if (value != null) {
								ret[ret.length] = value;
							}
						}
					}

					// Flatten any nested arrays
					return ret.concat.apply([], ret);
				},

				// A global GUID counter for objects
				guid: 1,

				// Bind a function to a context, optionally partially applying any
				// arguments.
				proxy: function (fn, context) {
					var tmp, args, proxy;

					if (typeof context === "string") {
						tmp = fn[context];
						context = fn;
						fn = tmp;
					}

					// Quick check to determine if target is callable, in the spec
					// this throws a TypeError, but we will just return undefined.
					if (!JQXLite.isFunction(fn)) {
						return undefined;
					}

					// Simulated bind
					args = core_slice.call(arguments, 2);
					proxy = function () {
						return fn.apply(context, args.concat(core_slice.call(arguments)));
					};

					// Set the guid of unique handler to the same of original handler, so it can be removed
					proxy.guid = fn.guid = fn.guid || JQXLite.guid++;

					return proxy;
				},

				// Multifunctional method to get and set values of a collection
				// The value/s can optionally be executed if it's a function
				access: function (elems, fn, key, value, chainable, emptyGet, pass) {
					var exec,
						bulk = key == null,
						i = 0,
						length = elems.length;

					// Sets many values
					if (key && typeof key === "object") {
						for (i in key) {
							JQXLite.access(elems, fn, i, key[i], 1, emptyGet, value);
						}
						chainable = 1;

						// Sets one value
					} else if (value !== undefined) {
						// Optionally, function values get executed if exec is true
						exec = pass === undefined && JQXLite.isFunction(value);

						if (bulk) {
							// Bulk operations only iterate when executing function values
							if (exec) {
								exec = fn;
								fn = function (elem, key, value) {
									return exec.call(JQXLite(elem), value);
								};

								// Otherwise they run against the entire set
							} else {
								fn.call(elems, value);
								fn = null;
							}
						}

						if (fn) {
							for (; i < length; i++) {
								fn(elems[i], key, exec ? value.call(elems[i], i, fn(elems[i], key)) : value, pass);
							}
						}

						chainable = 1;
					}

					return chainable ?
						elems :

						// Gets
						bulk ?
							fn.call(elems) :
							length ? fn(elems[0], key) : emptyGet;
				},

				now: function () {
					return (new Date()).getTime();
				}
			});

			JQXLite.ready.promise = function (obj) {
				if (!readyList) {

					readyList = JQXLite.Deferred();

					// Catch cases where $(document).ready() is called after the browser event has already occurred.
					// we once tried to use readyState "interactive" here, but it caused issues like the one
					// discovered by ChrisS here: http://bugs.jqx.com/ticket/12282#comment:15
					if (document.readyState === "complete") {
						// Handle it asynchronously to allow scripts the opportunity to delay ready
						setTimeout(JQXLite.ready, 1);

						// Standards-based browsers support DOMContentLoaded
					} else if (document.addEventListener) {
						// Use the handy event callback
						document.addEventListener("DOMContentLoaded", DOMContentLoaded, false);

						// A fallback to window.onload, that will always work
						window.addEventListener("load", JQXLite.ready, false);

						// If IE event model is used
					} else {
						// Ensure firing before onload, maybe late but safe also for iframes
						document.attachEvent("onreadystatechange", DOMContentLoaded);

						// A fallback to window.onload, that will always work
						window.attachEvent("onload", JQXLite.ready);

						// If IE and not a frame
						// continually check to see if the document is ready
						var top = false;

						try {
							top = window.frameElement == null && document.documentElement;
						} catch (e) { }

						if (top && top.doScroll) {
							(function doScrollCheck() {
								if (!JQXLite.isReady) {

									try {
										// Use the trick by Diego Perini
										// http://javascript.nwbox.com/IEContentLoaded/
										top.doScroll("left");
									} catch (e) {
										return setTimeout(doScrollCheck, 50);
									}

									// and execute any waiting functions
									JQXLite.ready();
								}
							})();
						}
					}
				}
				return readyList.promise(obj);
			};

			// Populate the class2type map
			JQXLite.each("Boolean Number String Function Array Date RegExp Object".split(" "), function (i, name) {
				class2type["[object " + name + "]"] = name.toLowerCase();
			});

			// All JQXLite objects should point back to these
			rootJQXLite = JQXLite(document);
			// String to Object options format cache
			var optionsCache = {};

			// Convert String-formatted options into Object-formatted ones and store in cache
			function createOptions(options) {
				var object = optionsCache[options] = {};
				JQXLite.each(options.split(core_rspace), function (_, flag) {
					object[flag] = true;
				});
				return object;
			}

			/*
			 * Create a callback list using the following parameters:
			 *
			 *	options: an optional list of space-separated options that will change how
			 *			the callback list behaves or a more traditional option object
			 *
			 * By default a callback list will act like an event callback list and can be
			 * "fired" multiple times.
			 *
			 * Possible options:
			 *
			 *	once:			will ensure the callback list can only be fired once (like a Deferred)
			 *
			 *	memory:			will keep track of previous values and will call any callback added
			 *					after the list has been fired right away with the latest "memorized"
			 *					values (like a Deferred)
			 *
			 *	unique:			will ensure a callback can only be added once (no duplicate in the list)
			 *
			 *	stopOnFalse:	interrupt callings when a callback returns false
			 *
			 */
			JQXLite.Callbacks = function (options) {

				// Convert options from String-formatted to Object-formatted if needed
				// (we check in cache first)
				options = typeof options === "string" ?
					(optionsCache[options] || createOptions(options)) :
					JQXLite.extend({}, options);

				var // Last fire value (for non-forgettable lists)
					memory,
					// Flag to know if list was already fired
					fired,
					// Flag to know if list is currently firing
					firing,
					// First callback to fire (used internally by add and fireWith)
					firingStart,
					// End of the loop when firing
					firingLength,
					// Index of currently firing callback (modified by remove if needed)
					firingIndex,
					// Actual callback list
					list = [],
					// Stack of fire calls for repeatable lists
					stack = !options.once && [],
					// Fire callbacks
					fire = function (data) {
						memory = options.memory && data;
						fired = true;
						firingIndex = firingStart || 0;
						firingStart = 0;
						firingLength = list.length;
						firing = true;
						for (; list && firingIndex < firingLength; firingIndex++) {
							if (list[firingIndex].apply(data[0], data[1]) === false && options.stopOnFalse) {
								memory = false; // To prevent further calls using add
								break;
							}
						}
						firing = false;
						if (list) {
							if (stack) {
								if (stack.length) {
									fire(stack.shift());
								}
							} else if (memory) {
								list = [];
							} else {
								self.disable();
							}
						}
					},
					// Actual Callbacks object
					self = {
						// Add a callback or a collection of callbacks to the list
						add: function () {
							if (list) {
								// First, we save the current length
								var start = list.length;
								(function add(args) {
									JQXLite.each(args, function (_, arg) {
										var type = JQXLite.type(arg);
										if (type === "function") {
											if (!options.unique || !self.has(arg)) {
												list.push(arg);
											}
										} else if (arg && arg.length && type !== "string") {
											// Inspect recursively
											add(arg);
										}
									});
								})(arguments);
								// Do we need to add the callbacks to the
								// current firing batch?
								if (firing) {
									firingLength = list.length;
									// With memory, if we're not firing then
									// we should call right away
								} else if (memory) {
									firingStart = start;
									fire(memory);
								}
							}
							return this;
						},
						// Remove a callback from the list
						remove: function () {
							if (list) {
								JQXLite.each(arguments, function (_, arg) {
									var index;
									while ((index = JQXLite.inArray(arg, list, index)) > -1) {
										list.splice(index, 1);
										// Handle firing indexes
										if (firing) {
											if (index <= firingLength) {
												firingLength--;
											}
											if (index <= firingIndex) {
												firingIndex--;
											}
										}
									}
								});
							}
							return this;
						},
						// Control if a given callback is in the list
						has: function (fn) {
							return JQXLite.inArray(fn, list) > -1;
						},
						// Remove all callbacks from the list
						empty: function () {
							list = [];
							return this;
						},
						// Have the list do nothing anymore
						disable: function () {
							list = stack = memory = undefined;
							return this;
						},
						// Is it disabled?
						disabled: function () {
							return !list;
						},
						// Lock the list in its current state
						lock: function () {
							stack = undefined;
							if (!memory) {
								self.disable();
							}
							return this;
						},
						// Is it locked?
						locked: function () {
							return !stack;
						},
						// Call all callbacks with the given context and arguments
						fireWith: function (context, args) {
							args = args || [];
							args = [context, args.slice ? args.slice() : args];
							if (list && (!fired || stack)) {
								if (firing) {
									stack.push(args);
								} else {
									fire(args);
								}
							}
							return this;
						},
						// Call all the callbacks with the given arguments
						fire: function () {
							self.fireWith(this, arguments);
							return this;
						},
						// To know if the callbacks have already been called at least once
						fired: function () {
							return !!fired;
						}
					};

				return self;
			};
			JQXLite.extend({

				Deferred: function (func) {
					var tuples = [
						// action, add listener, listener list, final state
						["resolve", "done", JQXLite.Callbacks("once memory"), "resolved"],
						["reject", "fail", JQXLite.Callbacks("once memory"), "rejected"],
						["notify", "progress", JQXLite.Callbacks("memory")]
					],
						state = "pending",
						promise = {
							state: function () {
								return state;
							},
							always: function () {
								deferred.done(arguments).fail(arguments);
								return this;
							},
							then: function ( /* fnDone, fnFail, fnProgress */) {
								var fns = arguments;
								return JQXLite.Deferred(function (newDefer) {
									JQXLite.each(tuples, function (i, tuple) {
										var action = tuple[0],
											fn = fns[i];
										// deferred[ done | fail | progress ] for forwarding actions to newDefer
										deferred[tuple[1]](JQXLite.isFunction(fn) ?
											function () {
												var returned = fn.apply(this, arguments);
												if (returned && JQXLite.isFunction(returned.promise)) {
													returned.promise()
														.done(newDefer.resolve)
														.fail(newDefer.reject)
														.progress(newDefer.notify);
												} else {
													newDefer[action + "With"](this === deferred ? newDefer : this, [returned]);
												}
											} :
											newDefer[action]
										);
									});
									fns = null;
								}).promise();
							},
							// Get a promise for this deferred
							// If obj is provided, the promise aspect is added to the object
							promise: function (obj) {
								return obj != null ? JQXLite.extend(obj, promise) : promise;
							}
						},
						deferred = {};

					// Keep pipe for back-compat
					promise.pipe = promise.then;

					// Add list-specific methods
					JQXLite.each(tuples, function (i, tuple) {
						var list = tuple[2],
							stateString = tuple[3];

						// promise[ done | fail | progress ] = list.add
						promise[tuple[1]] = list.add;

						// Handle state
						if (stateString) {
							list.add(function () {
								// state = [ resolved | rejected ]
								state = stateString;

								// [ reject_list | resolve_list ].disable; progress_list.lock
							}, tuples[i ^ 1][2].disable, tuples[2][2].lock);
						}

						// deferred[ resolve | reject | notify ] = list.fire
						deferred[tuple[0]] = list.fire;
						deferred[tuple[0] + "With"] = list.fireWith;
					});

					// Make the deferred a promise
					promise.promise(deferred);

					// Call given func if any
					if (func) {
						func.call(deferred, deferred);
					}

					// All done!
					return deferred;
				},

				// Deferred helper
				when: function (subordinate /* , ..., subordinateN */) {
					var i = 0,
						resolveValues = core_slice.call(arguments),
						length = resolveValues.length,

						// the count of uncompleted subordinates
						remaining = length !== 1 || (subordinate && JQXLite.isFunction(subordinate.promise)) ? length : 0,

						// the master Deferred. If resolveValues consist of only a single Deferred, just use that.
						deferred = remaining === 1 ? subordinate : JQXLite.Deferred(),

						// Update function for both resolve and progress values
						updateFunc = function (i, contexts, values) {
							return function (value) {
								contexts[i] = this;
								values[i] = arguments.length > 1 ? core_slice.call(arguments) : value;
								if (values === progressValues) {
									deferred.notifyWith(contexts, values);
								} else if (!(--remaining)) {
									deferred.resolveWith(contexts, values);
								}
							};
						},

						progressValues, progressContexts, resolveContexts;

					// add listeners to Deferred subordinates; treat others as resolved
					if (length > 1) {
						progressValues = new Array(length);
						progressContexts = new Array(length);
						resolveContexts = new Array(length);
						for (; i < length; i++) {
							if (resolveValues[i] && JQXLite.isFunction(resolveValues[i].promise)) {
								resolveValues[i].promise()
									.done(updateFunc(i, resolveContexts, resolveValues))
									.fail(deferred.reject)
									.progress(updateFunc(i, progressContexts, progressValues));
							} else {
								--remaining;
							}
						}
					}

					// if we're not waiting on anything, resolve the master
					if (!remaining) {
						deferred.resolveWith(resolveContexts, resolveValues);
					}

					return deferred.promise();
				}
			});
			JQXLite.support = (function () {

				var support,
					all,
					a,
					select,
					opt,
					input,
					fragment,
					eventName,
					i,
					isSupported,
					clickFn,
					div = document.createElement("div");

				// Setup
				div.setAttribute("className", "t");
				div.innerHTML = "  <link/><table></table><a href='/a'>a</a><input type='checkbox'/>";

				// Support tests won't run in some limited or non-browser environments
				all = div.getElementsByTagName("*");
				a = div.getElementsByTagName("a")[0];
				if (!all || !a || !all.length) {
					return {};
				}

				// First batch of tests
				select = document.createElement("select");
				opt = select.appendChild(document.createElement("option"));
				input = div.getElementsByTagName("input")[0];

				a.style.cssText = "top:1px;float:left;opacity:.5";
				support = {
					// IE strips leading whitespace when .innerHTML is used
					leadingWhitespace: (div.firstChild.nodeType === 3),

					// Make sure that tbody elements aren't automatically inserted
					// IE will insert them into empty tables
					tbody: !div.getElementsByTagName("tbody").length,

					// Make sure that link elements get serialized correctly by innerHTML
					// This requires a wrapper element in IE
					htmlSerialize: !!div.getElementsByTagName("link").length,

					// Get the style information from getAttribute
					// (IE uses .cssText instead)
					style: /top/.test(a.getAttribute("style")),

					// Make sure that URLs aren't manipulated
					// (IE normalizes it by default)
					hrefNormalized: (a.getAttribute("href") === "/a"),

					// Make sure that element opacity exists
					// (IE uses filter instead)
					// Use a regex to work around a WebKit issue. See #5145
					opacity: /^0.5/.test(a.style.opacity),

					// Verify style float existence
					// (IE uses styleFloat instead of cssFloat)
					cssFloat: !!a.style.cssFloat,

					// Make sure that if no value is specified for a checkbox
					// that it defaults to "on".
					// (WebKit defaults to "" instead)
					checkOn: (input.value === "on"),

					// Make sure that a selected-by-default option has a working selected property.
					// (WebKit defaults to false instead of true, IE too, if it's in an optgroup)
					optSelected: opt.selected,

					// Test setAttribute on camelCase class. If it works, we need attrFixes when doing get/setAttribute (ie6/7)
					getSetAttribute: div.className !== "t",

					// Tests for enctype support on a form (#6743)
					enctype: !!document.createElement("form").enctype,

					// Makes sure cloning an html5 element does not cause problems
					// Where outerHTML is undefined, this still works
					html5Clone: document.createElement("nav").cloneNode(true).outerHTML !== "<:nav></:nav>",

					// JQXLite.support.boxModel DEPRECATED in 1.8 since we don't support Quirks Mode
					boxModel: (document.compatMode === "CSS1Compat"),

					// Will be defined later
					submitBubbles: true,
					changeBubbles: true,
					focusinBubbles: false,
					deleteExpando: true,
					noCloneEvent: true,
					inlineBlockNeedsLayout: false,
					shrinkWrapBlocks: false,
					reliableMarginRight: true,
					boxSizingReliable: true,
					pixelPosition: false
				};

				// Make sure checked status is properly cloned
				input.checked = true;
				support.noCloneChecked = input.cloneNode(true).checked;

				// Make sure that the options inside disabled selects aren't marked as disabled
				// (WebKit marks them as disabled)
				select.disabled = true;
				support.optDisabled = !opt.disabled;

				// Test to see if it's possible to delete an expando from an element
				// Fails in Internet Explorer
				try {
					delete div.test;
				} catch (e) {
					support.deleteExpando = false;
				}

				if (!div.addEventListener && div.attachEvent && div.fireEvent) {
					div.attachEvent("onclick", clickFn = function () {
						// Cloning a node shouldn't copy over any
						// bound event handlers (IE does this)
						support.noCloneEvent = false;
					});
					div.cloneNode(true).fireEvent("onclick");
					div.detachEvent("onclick", clickFn);
				}

				// Check if a radio maintains its value
				// after being appended to the DOM
				input = document.createElement("input");
				input.value = "t";
				input.setAttribute("type", "radio");
				support.radioValue = input.value === "t";

				input.setAttribute("checked", "checked");

				// #11217 - WebKit loses check when the name is after the checked attribute
				input.setAttribute("name", "t");

				div.appendChild(input);
				fragment = document.createDocumentFragment();
				fragment.appendChild(div.lastChild);

				// WebKit doesn't clone checked state correctly in fragments
				support.checkClone = fragment.cloneNode(true).cloneNode(true).lastChild.checked;

				// Check if a disconnected checkbox will retain its checked
				// value of true after appended to the DOM (IE6/7)
				support.appendChecked = input.checked;

				fragment.removeChild(input);
				fragment.appendChild(div);

				// Technique from Juriy Zaytsev
				// http://perfectionkills.com/detecting-event-support-without-browser-sniffing/
				// We only care about the case where non-standard event systems
				// are used, namely in IE. Short-circuiting here helps us to
				// avoid an eval call (in setAttribute) which can cause CSP
				// to go haywire. See: https://developer.mozilla.org/en/Security/CSP
				if (div.attachEvent) {
					for (i in {
						submit: true,
						change: true,
						focusin: true
					}) {
						eventName = "on" + i;
						isSupported = (eventName in div);
						if (!isSupported) {
							div.setAttribute(eventName, "return;");
							isSupported = (typeof div[eventName] === "function");
						}
						support[i + "Bubbles"] = isSupported;
					}
				}

				// Run tests that need a body at doc ready
				JQXLite(function () {
					var container, div, tds, marginDiv,
						divReset = "padding:0;margin:0;border:0;display:block;overflow:hidden;",
						body = document.getElementsByTagName("body")[0];

					if (!body) {
						// Return for frameset docs that don't have a body
						return;
					}

					container = document.createElement("div");
					container.style.cssText = "visibility:hidden;border:0;width:0;height:0;position:static;top:0;margin-top:1px";
					body.insertBefore(container, body.firstChild);

					// Construct the test element
					div = document.createElement("div");
					container.appendChild(div);

					// Check if table cells still have offsetWidth/Height when they are set
					// to display:none and there are still other visible table cells in a
					// table row; if so, offsetWidth/Height are not reliable for use when
					// determining if an element has been hidden directly using
					// display:none (it is still safe to use offsets if a parent element is
					// hidden; don safety goggles and see bug #4512 for more information).
					// (only IE 8 fails this test)
					div.innerHTML = "<table><tr><td></td><td>t</td></tr></table>";
					tds = div.getElementsByTagName("td");
					tds[0].style.cssText = "padding:0;margin:0;border:0;display:none";
					isSupported = (tds[0].offsetHeight === 0);

					tds[0].style.display = "";
					tds[1].style.display = "none";

					// Check if empty table cells still have offsetWidth/Height
					// (IE <= 8 fail this test)
					support.reliableHiddenOffsets = isSupported && (tds[0].offsetHeight === 0);

					// Check box-sizing and margin behavior
					div.innerHTML = "";
					div.style.cssText = "box-sizing:border-box;-moz-box-sizing:border-box;-webkit-box-sizing:border-box;padding:1px;border:1px;display:block;width:4px;margin-top:1%;position:absolute;top:1%;";
					support.boxSizing = (div.offsetWidth === 4);
					support.doesNotIncludeMarginInBodyOffset = (body.offsetTop !== 1);

					// NOTE: To any future maintainer, we've window.getComputedStyle
					// because jsdom on node.js will break without it.
					if (window.getComputedStyle) {
						support.pixelPosition = (window.getComputedStyle(div, null) || {}).top !== "1%";
						support.boxSizingReliable = (window.getComputedStyle(div, null) || { width: "4px" }).width === "4px";

						// Check if div with explicit width and no margin-right incorrectly
						// gets computed margin-right based on width of container. For more
						// info see bug #3333
						// Fails in WebKit before Feb 2011 nightlies
						// WebKit Bug 13343 - getComputedStyle returns wrong value for margin-right
						marginDiv = document.createElement("div");
						marginDiv.style.cssText = div.style.cssText = divReset;
						marginDiv.style.marginRight = marginDiv.style.width = "0";
						div.style.width = "1px";
						div.appendChild(marginDiv);
						support.reliableMarginRight =
							!parseFloat((window.getComputedStyle(marginDiv, null) || {}).marginRight);
					}

					if (typeof div.style.zoom !== "undefined") {
						// Check if natively block-level elements act like inline-block
						// elements when setting their display to 'inline' and giving
						// them layout
						// (IE < 8 does this)
						div.innerHTML = "";
						div.style.cssText = divReset + "width:1px;padding:1px;display:inline;zoom:1";
						support.inlineBlockNeedsLayout = (div.offsetWidth === 3);

						// Check if elements with layout shrink-wrap their children
						// (IE 6 does this)
						div.style.display = "block";
						div.style.overflow = "visible";
						div.innerHTML = "<div></div>";
						div.firstChild.style.width = "5px";
						support.shrinkWrapBlocks = (div.offsetWidth !== 3);

						container.style.zoom = 1;
					}

					// Null elements to avoid leaks in IE
					body.removeChild(container);
					container = div = tds = marginDiv = null;
				});

				// Null elements to avoid leaks in IE
				fragment.removeChild(div);
				all = a = select = opt = input = fragment = div = null;

				return support;
			})();
			var rbrace = /(?:\{[\s\S]*\}|\[[\s\S]*\])$/,
				rmultiDash = /([A-Z])/g;

			JQXLite.extend({
				cache: {},

				deletedIds: [],

				// Remove at next major release (1.9/2.0)
				uuid: 0,

				// Unique for each copy of JQXLite on the page
				// Non-digits removed to match rinlinejQuery
				expando: "JQXLite" + (JQXLite.fn.jqx + Math.random()).replace(/\D/g, ""),

				// The following elements throw uncatchable exceptions if you
				// attempt to add expando properties to them.
				noData: {
					"embed": true,
					// Ban all objects except for Flash (which handle expandos)
					"object": "clsid:D27CDB6E-AE6D-11cf-96B8-444553540000",
					"applet": true
				},

				hasData: function (elem) {
					elem = elem.nodeType ? JQXLite.cache[elem[JQXLite.expando]] : elem[JQXLite.expando];
					return !!elem && !isEmptyDataObject(elem);
				},

				data: function (elem, name, data, pvt /* Internal Use Only */) {
					if (!JQXLite.acceptData(elem)) {
						return;
					}

					var thisCache, ret,
						internalKey = JQXLite.expando,
						getByName = typeof name === "string",

						// We have to handle DOM nodes and JS objects differently because IE6-7
						// can't GC object references properly across the DOM-JS boundary
						isNode = elem.nodeType,

						// Only DOM nodes need the global JQXLite cache; JS object data is
						// attached directly to the object so GC can occur automatically
						cache = isNode ? JQXLite.cache : elem,

						// Only defining an ID for JS objects if its cache already exists allows
						// the code to shortcut on the same path as a DOM node with no cache
						id = isNode ? elem[internalKey] : elem[internalKey] && internalKey;

					// Avoid doing any more work than we need to when trying to get data on an
					// object that has no data at all
					if ((!id || !cache[id] || (!pvt && !cache[id].data)) && getByName && data === undefined) {
						return;
					}

					if (!id) {
						// Only DOM nodes need a new unique ID for each element since their data
						// ends up in the global cache
						if (isNode) {
							elem[internalKey] = id = JQXLite.deletedIds.pop() || JQXLite.guid++;
						} else {
							id = internalKey;
						}
					}

					if (!cache[id]) {
						cache[id] = {};

						// Avoids exposing JQXLite metadata on plain JS objects when the object
						// is serialized using JSON.stringify
						if (!isNode) {
							cache[id].toJSON = JQXLite.noop;
						}
					}

					// An object can be passed to JQXLite.data instead of a key/value pair; this gets
					// shallow copied over onto the existing cache
					if (typeof name === "object" || typeof name === "function") {
						if (pvt) {
							cache[id] = JQXLite.extend(cache[id], name);
						} else {
							cache[id].data = JQXLite.extend(cache[id].data, name);
						}
					}

					thisCache = cache[id];

					// JQXLite data() is stored in a separate object inside the object's internal data
					// cache in order to avoid key collisions between internal data and user-defined
					// data.
					if (!pvt) {
						if (!thisCache.data) {
							thisCache.data = {};
						}

						thisCache = thisCache.data;
					}

					if (data !== undefined) {
						thisCache[JQXLite.camelCase(name)] = data;
					}

					// Check for both converted-to-camel and non-converted data property names
					// If a data property was specified
					if (getByName) {

						// First Try to find as-is property data
						ret = thisCache[name];

						// Test for null|undefined property data
						if (ret == null) {

							// Try to find the camelCased property
							ret = thisCache[JQXLite.camelCase(name)];
						}
					} else {
						ret = thisCache;
					}

					return ret;
				},

				removeData: function (elem, name, pvt /* Internal Use Only */) {
					if (!JQXLite.acceptData(elem)) {
						return;
					}

					var thisCache, i, l,

						isNode = elem.nodeType,

						// See JQXLite.data for more information
						cache = isNode ? JQXLite.cache : elem,
						id = isNode ? elem[JQXLite.expando] : JQXLite.expando;

					// If there is already no cache entry for this object, there is no
					// purpose in continuing
					if (!cache[id]) {
						return;
					}

					if (name) {

						thisCache = pvt ? cache[id] : cache[id].data;

						if (thisCache) {

							// Support array or space separated string names for data keys
							if (!JQXLite.isArray(name)) {

								// try the string as a key before any manipulation
								if (name in thisCache) {
									name = [name];
								} else {

									// split the camel cased version by spaces unless a key with the spaces exists
									name = JQXLite.camelCase(name);
									if (name in thisCache) {
										name = [name];
									} else {
										name = name.split(" ");
									}
								}
							}

							for (i = 0, l = name.length; i < l; i++) {
								delete thisCache[name[i]];
							}

							// If there is no data left in the cache, we want to continue
							// and let the cache object itself get destroyed
							if (!(pvt ? isEmptyDataObject : JQXLite.isEmptyObject)(thisCache)) {
								return;
							}
						}
					}

					// See JQXLite.data for more information
					if (!pvt) {
						delete cache[id].data;

						// Don't destroy the parent cache unless the internal data object
						// had been the only thing left in it
						if (!isEmptyDataObject(cache[id])) {
							return;
						}
					}

					// Destroy the cache
					if (isNode) {
						JQXLite.cleanData([elem], true);

						// Use delete when supported for expandos or `cache` is not a window per isWindow (#10080)
					} else if (JQXLite.support.deleteExpando || cache != cache.window) {
						delete cache[id];

						// When all else fails, null
					} else {
						cache[id] = null;
					}
				},

				// For internal use only.
				_data: function (elem, name, data) {
					return JQXLite.data(elem, name, data, true);
				},

				// A method for determining if a DOM node can handle the data expando
				acceptData: function (elem) {
					var noData = elem.nodeName && JQXLite.noData[elem.nodeName.toLowerCase()];

					// nodes accept data unless otherwise specified; rejection can be conditional
					return !noData || noData !== true && elem.getAttribute("classid") === noData;
				}
			});

			JQXLite.fn.extend({
				data: function (key, value) {
					var parts, part, attr, name, l,
						elem = this[0],
						i = 0,
						data = null;

					// Gets all values
					if (key === undefined) {
						if (this.length) {
							data = JQXLite.data(elem);

							if (elem.nodeType === 1 && !JQXLite._data(elem, "parsedAttrs")) {
								attr = elem.attributes;
								for (l = attr.length; i < l; i++) {
									name = attr[i].name;

									if (!name.indexOf("data-")) {
										name = JQXLite.camelCase(name.substring(5));

										dataAttr(elem, name, data[name]);
									}
								}
								JQXLite._data(elem, "parsedAttrs", true);
							}
						}

						return data;
					}

					// Sets multiple values
					if (typeof key === "object") {
						return this.each(function () {
							JQXLite.data(this, key);
						});
					}

					parts = key.split(".", 2);
					parts[1] = parts[1] ? "." + parts[1] : "";
					part = parts[1] + "!";

					return JQXLite.access(this, function (value) {

						if (value === undefined) {
							data = this.triggerHandler("getData" + part, [parts[0]]);

							// Try to fetch any internally stored data first
							if (data === undefined && elem) {
								data = JQXLite.data(elem, key);
								data = dataAttr(elem, key, data);
							}

							return data === undefined && parts[1] ?
								this.data(parts[0]) :
								data;
						}

						parts[1] = value;
						this.each(function () {
							var self = JQXLite(this);

							self.triggerHandler("setData" + part, parts);
							JQXLite.data(this, key, value);
							self.triggerHandler("changeData" + part, parts);
						});
					}, null, value, arguments.length > 1, null, false);
				},

				removeData: function (key) {
					return this.each(function () {
						JQXLite.removeData(this, key);
					});
				}
			});

			function dataAttr(elem, key, data) {
				// If nothing was found internally, try to fetch any
				// data from the HTML5 data-* attribute
				if (data === undefined && elem.nodeType === 1) {

					var name = "data-" + key.replace(rmultiDash, "-$1").toLowerCase();

					data = elem.getAttribute(name);

					if (typeof data === "string") {
						try {
							data = data === "true" ? true :
								data === "false" ? false :
									data === "null" ? null :
										// Only convert to a number if it doesn't change the string
										+data + "" === data ? +data :
											rbrace.test(data) ? JQXLite.parseJSON(data) :
												data;
						} catch (e) { }

						// Make sure we set the data so it isn't changed later
						JQXLite.data(elem, key, data);

					} else {
						data = undefined;
					}
				}

				return data;
			}

			// checks a cache object for emptiness
			function isEmptyDataObject(obj) {
				var name;
				for (name in obj) {

					// if the public data object is empty, the private is still empty
					if (name === "data" && JQXLite.isEmptyObject(obj[name])) {
						continue;
					}
					if (name !== "toJSON") {
						return false;
					}
				}

				return true;
			}
			JQXLite.extend({
				queue: function (elem, type, data) {
					var queue;

					if (elem) {
						type = (type || "fx") + "queue";
						queue = JQXLite._data(elem, type);

						// Speed up dequeue by getting out quickly if this is just a lookup
						if (data) {
							if (!queue || JQXLite.isArray(data)) {
								queue = JQXLite._data(elem, type, JQXLite.makeArray(data));
							} else {
								queue.push(data);
							}
						}
						return queue || [];
					}
				},

				dequeue: function (elem, type) {
					type = type || "fx";

					var queue = JQXLite.queue(elem, type),
						startLength = queue.length,
						fn = queue.shift(),
						hooks = JQXLite._queueHooks(elem, type),
						next = function () {
							JQXLite.dequeue(elem, type);
						};

					// If the fx queue is dequeued, always remove the progress sentinel
					if (fn === "inprogress") {
						fn = queue.shift();
						startLength--;
					}

					if (fn) {

						// Add a progress sentinel to prevent the fx queue from being
						// automatically dequeued
						if (type === "fx") {
							queue.unshift("inprogress");
						}

						// clear up the last queue stop function
						delete hooks.stop;
						fn.call(elem, next, hooks);
					}

					if (!startLength && hooks) {
						hooks.empty.fire();
					}
				},

				// not intended for public consumption - generates a queueHooks object, or returns the current one
				_queueHooks: function (elem, type) {
					var key = type + "queueHooks";
					return JQXLite._data(elem, key) || JQXLite._data(elem, key, {
						empty: JQXLite.Callbacks("once memory").add(function () {
							JQXLite.removeData(elem, type + "queue", true);
							JQXLite.removeData(elem, key, true);
						})
					});
				}
			});

			JQXLite.fn.extend({
				queue: function (type, data) {
					var setter = 2;

					if (typeof type !== "string") {
						data = type;
						type = "fx";
						setter--;
					}

					if (arguments.length < setter) {
						return JQXLite.queue(this[0], type);
					}

					return data === undefined ?
						this :
						this.each(function () {
							var queue = JQXLite.queue(this, type, data);

							// ensure a hooks for this queue
							JQXLite._queueHooks(this, type);

							if (type === "fx" && queue[0] !== "inprogress") {
								JQXLite.dequeue(this, type);
							}
						});
				},
				dequeue: function (type) {
					return this.each(function () {
						JQXLite.dequeue(this, type);
					});
				},
				// Based off of the plugin by Clint Helfers, with permission.
				// http://blindsignals.com/index.php/2009/07/jqx-delay/
				delay: function (time, type) {
					time = JQXLite.fx ? JQXLite.fx.speeds[time] || time : time;
					type = type || "fx";

					return this.queue(type, function (next, hooks) {
						var timeout = setTimeout(next, time);
						hooks.stop = function () {
							clearTimeout(timeout);
						};
					});
				},
				clearQueue: function (type) {
					return this.queue(type || "fx", []);
				},
				// Get a promise resolved when queues of a certain type
				// are emptied (fx is the type by default)
				promise: function (type, obj) {
					var tmp,
						count = 1,
						defer = JQXLite.Deferred(),
						elements = this,
						i = this.length,
						resolve = function () {
							if (!(--count)) {
								defer.resolveWith(elements, [elements]);
							}
						};

					if (typeof type !== "string") {
						obj = type;
						type = undefined;
					}
					type = type || "fx";

					while (i--) {
						tmp = JQXLite._data(elements[i], type + "queueHooks");
						if (tmp && tmp.empty) {
							count++;
							tmp.empty.add(resolve);
						}
					}
					resolve();
					return defer.promise(obj);
				}
			});
			var nodeHook, boolHook, fixSpecified,
				rclass = /[\t\r\n]/g,
				rreturn = /\r/g,
				rtype = /^(?:button|input)$/i,
				rfocusable = /^(?:button|input|object|select|textarea)$/i,
				rclickable = /^a(?:rea|)$/i,
				rboolean = /^(?:autofocus|autoplay|async|checked|controls|defer|disabled|hidden|loop|multiple|open|readonly|required|scoped|selected)$/i,
				getSetAttribute = JQXLite.support.getSetAttribute;

			JQXLite.fn.extend({
				attr: function (name, value) {
					return JQXLite.access(this, JQXLite.attr, name, value, arguments.length > 1);
				},

				removeAttr: function (name) {
					return this.each(function () {
						JQXLite.removeAttr(this, name);
					});
				},

				prop: function (name, value) {
					return JQXLite.access(this, JQXLite.prop, name, value, arguments.length > 1);
				},

				removeProp: function (name) {
					name = JQXLite.propFix[name] || name;
					return this.each(function () {
						// try/catch handles cases where IE balks (such as removing a property on window)
						try {
							this[name] = undefined;
							delete this[name];
						} catch (e) { }
					});
				},

				addClass: function (value) {
					var classNames, i, l, elem,
						setClass, c, cl;

					if (JQXLite.isFunction(value)) {
						return this.each(function (j) {
							JQXLite(this).addClass(value.call(this, j, this.className));
						});
					}

					if (value && typeof value === "string") {
						classNames = value.split(core_rspace);

						for (i = 0, l = this.length; i < l; i++) {
							elem = this[i];

							if (elem.nodeType === 1) {
								if (!elem.className && classNames.length === 1) {
									elem.className = value;

								} else {
									setClass = " " + elem.className + " ";

									for (c = 0, cl = classNames.length; c < cl; c++) {
										if (setClass.indexOf(" " + classNames[c] + " ") < 0) {
											setClass += classNames[c] + " ";
										}
									}
									elem.className = JQXLite.trim(setClass);
								}
							}
						}
					}

					return this;
				},

				removeClass: function (value) {
					var removes, className, elem, c, cl, i, l;

					if (JQXLite.isFunction(value)) {
						return this.each(function (j) {
							JQXLite(this).removeClass(value.call(this, j, this.className));
						});
					}
					if ((value && typeof value === "string") || value === undefined) {
						removes = (value || "").split(core_rspace);

						for (i = 0, l = this.length; i < l; i++) {
							elem = this[i];
							if (elem.nodeType === 1 && elem.className) {

								className = (" " + elem.className + " ").replace(rclass, " ");

								// loop over each item in the removal list
								for (c = 0, cl = removes.length; c < cl; c++) {
									// Remove until there is nothing to remove,
									while (className.indexOf(" " + removes[c] + " ") >= 0) {
										className = className.replace(" " + removes[c] + " ", " ");
									}
								}
								elem.className = value ? JQXLite.trim(className) : "";
							}
						}
					}

					return this;
				},

				toggleClass: function (value, stateVal) {
					var type = typeof value,
						isBool = typeof stateVal === "boolean";

					if (JQXLite.isFunction(value)) {
						return this.each(function (i) {
							JQXLite(this).toggleClass(value.call(this, i, this.className, stateVal), stateVal);
						});
					}

					return this.each(function () {
						if (type === "string") {
							// toggle individual class names
							var className,
								i = 0,
								self = JQXLite(this),
								state = stateVal,
								classNames = value.split(core_rspace);

							while ((className = classNames[i++])) {
								// check each className given, space separated list
								state = isBool ? state : !self.hasClass(className);
								self[state ? "addClass" : "removeClass"](className);
							}

						} else if (type === "undefined" || type === "boolean") {
							if (this.className) {
								// store className if set
								JQXLite._data(this, "__className__", this.className);
							}

							// toggle whole className
							this.className = this.className || value === false ? "" : JQXLite._data(this, "__className__") || "";
						}
					});
				},

				hasClass: function (selector) {
					var className = " " + selector + " ",
						i = 0,
						l = this.length;
					for (; i < l; i++) {
						if (this[i].nodeType === 1 && (" " + this[i].className + " ").replace(rclass, " ").indexOf(className) >= 0) {
							return true;
						}
					}

					return false;
				},

				val: function (value) {
					var hooks, ret, isFunction,
						elem = this[0];

					if (!arguments.length) {
						if (elem) {
							hooks = JQXLite.valHooks[elem.type] || JQXLite.valHooks[elem.nodeName.toLowerCase()];

							if (hooks && "get" in hooks && (ret = hooks.get(elem, "value")) !== undefined) {
								return ret;
							}

							ret = elem.value;

							return typeof ret === "string" ?
								// handle most common string cases
								ret.replace(rreturn, "") :
								// handle cases where value is null/undef or number
								ret == null ? "" : ret;
						}

						return;
					}

					isFunction = JQXLite.isFunction(value);

					return this.each(function (i) {
						var val,
							self = JQXLite(this);

						if (this.nodeType !== 1) {
							return;
						}

						if (isFunction) {
							val = value.call(this, i, self.val());
						} else {
							val = value;
						}

						// Treat null/undefined as ""; convert numbers to string
						if (val == null) {
							val = "";
						} else if (typeof val === "number") {
							val += "";
						} else if (JQXLite.isArray(val)) {
							val = JQXLite.map(val, function (value) {
								return value == null ? "" : value + "";
							});
						}

						hooks = JQXLite.valHooks[this.type] || JQXLite.valHooks[this.nodeName.toLowerCase()];

						// If set returns undefined, fall back to normal setting
						if (!hooks || !("set" in hooks) || hooks.set(this, val, "value") === undefined) {
							this.value = val;
						}
					});
				}
			});

			JQXLite.extend({
				valHooks: {
					option: {
						get: function (elem) {
							// attributes.value is undefined in Blackberry 4.7 but
							// uses .value. See #6932
							var val = elem.attributes.value;
							return !val || val.specified ? elem.value : elem.text;
						}
					},
					select: {
						get: function (elem) {
							var value, option,
								options = elem.options,
								index = elem.selectedIndex,
								one = elem.type === "select-one" || index < 0,
								values = one ? null : [],
								max = one ? index + 1 : options.length,
								i = index < 0 ?
									max :
									one ? index : 0;

							// Loop through all the selected options
							for (; i < max; i++) {
								option = options[i];

								// oldIE doesn't update selected after form reset (#2551)
								if ((option.selected || i === index) &&
									// Don't return options that are disabled or in a disabled optgroup
									(JQXLite.support.optDisabled ? !option.disabled : option.getAttribute("disabled") === null) &&
									(!option.parentNode.disabled || !JQXLite.nodeName(option.parentNode, "optgroup"))) {

									// Get the specific value for the option
									value = JQXLite(option).val();

									// We don't need an array for one selects
									if (one) {
										return value;
									}

									// Multi-Selects return an array
									values.push(value);
								}
							}

							return values;
						},

						set: function (elem, value) {
							var values = JQXLite.makeArray(value);

							JQXLite(elem).find("option").each(function () {
								this.selected = JQXLite.inArray(JQXLite(this).val(), values) >= 0;
							});

							if (!values.length) {
								elem.selectedIndex = -1;
							}
							return values;
						}
					}
				},

				// Unused in 1.8, left in so attrFn-stabbers won't die; remove in 1.9
				attrFn: {},

				attr: function (elem, name, value, pass) {
					var ret, hooks, notxml,
						nType = elem.nodeType;

					// don't get/set attributes on text, comment and attribute nodes
					if (!elem || nType === 3 || nType === 8 || nType === 2) {
						return;
					}

					if (pass && JQXLite.isFunction(JQXLite.fn[name])) {
						return JQXLite(elem)[name](value);
					}

					// Fallback to prop when attributes are not supported
					if (typeof elem.getAttribute === "undefined") {
						return JQXLite.prop(elem, name, value);
					}

					notxml = nType !== 1 || !JQXLite.isXMLDoc(elem);

					// All attributes are lowercase
					// Grab necessary hook if one is defined
					if (notxml) {
						name = name.toLowerCase();
						hooks = JQXLite.attrHooks[name] || (rboolean.test(name) ? boolHook : nodeHook);
					}

					if (value !== undefined) {

						if (value === null) {
							JQXLite.removeAttr(elem, name);
							return;

						} else if (hooks && "set" in hooks && notxml && (ret = hooks.set(elem, value, name)) !== undefined) {
							return ret;

						} else {
							elem.setAttribute(name, value + "");
							return value;
						}

					} else if (hooks && "get" in hooks && notxml && (ret = hooks.get(elem, name)) !== null) {
						return ret;

					} else {

						ret = elem.getAttribute(name);

						// Non-existent attributes return null, we normalize to undefined
						return ret === null ?
							undefined :
							ret;
					}
				},

				removeAttr: function (elem, value) {
					var propName, attrNames, name, isBool,
						i = 0;

					if (value && elem.nodeType === 1) {

						attrNames = value.split(core_rspace);

						for (; i < attrNames.length; i++) {
							name = attrNames[i];

							if (name) {
								propName = JQXLite.propFix[name] || name;
								isBool = rboolean.test(name);

								// See #9699 for explanation of this approach (setting first, then removal)
								// Do not do this for boolean attributes (see #10870)
								if (!isBool) {
									JQXLite.attr(elem, name, "");
								}
								elem.removeAttribute(getSetAttribute ? name : propName);

								// Set corresponding property to false for boolean attributes
								if (isBool && propName in elem) {
									elem[propName] = false;
								}
							}
						}
					}
				},

				attrHooks: {
					type: {
						set: function (elem, value) {
							// We can't allow the type property to be changed (since it causes problems in IE)
							if (rtype.test(elem.nodeName) && elem.parentNode) {
								JQXLite.error("type property can't be changed");
							} else if (!JQXLite.support.radioValue && value === "radio" && JQXLite.nodeName(elem, "input")) {
								// Setting the type on a radio button after the value resets the value in IE6-9
								// Reset value to it's default in case type is set after value
								// This is for element creation
								var val = elem.value;
								elem.setAttribute("type", value);
								if (val) {
									elem.value = val;
								}
								return value;
							}
						}
					},
					// Use the value property for back compat
					// Use the nodeHook for button elements in IE6/7 (#1954)
					value: {
						get: function (elem, name) {
							if (nodeHook && JQXLite.nodeName(elem, "button")) {
								return nodeHook.get(elem, name);
							}
							return name in elem ?
								elem.value :
								null;
						},
						set: function (elem, value, name) {
							if (nodeHook && JQXLite.nodeName(elem, "button")) {
								return nodeHook.set(elem, value, name);
							}
							// Does not return so that setAttribute is also used
							elem.value = value;
						}
					}
				},

				propFix: {
					tabindex: "tabIndex",
					readonly: "readOnly",
					"for": "htmlFor",
					"class": "className",
					maxlength: "maxLength",
					cellspacing: "cellSpacing",
					cellpadding: "cellPadding",
					rowspan: "rowSpan",
					colspan: "colSpan",
					usemap: "useMap",
					frameborder: "frameBorder",
					contenteditable: "contentEditable"
				},

				prop: function (elem, name, value) {
					var ret, hooks, notxml,
						nType = elem.nodeType;

					// don't get/set properties on text, comment and attribute nodes
					if (!elem || nType === 3 || nType === 8 || nType === 2) {
						return;
					}

					notxml = nType !== 1 || !JQXLite.isXMLDoc(elem);

					if (notxml) {
						// Fix name and attach hooks
						name = JQXLite.propFix[name] || name;
						hooks = JQXLite.propHooks[name];
					}

					if (value !== undefined) {
						if (hooks && "set" in hooks && (ret = hooks.set(elem, value, name)) !== undefined) {
							return ret;

						} else {
							return (elem[name] = value);
						}

					} else {
						if (hooks && "get" in hooks && (ret = hooks.get(elem, name)) !== null) {
							return ret;

						} else {
							return elem[name];
						}
					}
				},

				propHooks: {
					tabIndex: {
						get: function (elem) {
							// elem.tabIndex doesn't always return the correct value when it hasn't been explicitly set
							// http://fluidproject.org/blog/2008/01/09/getting-setting-and-removing-tabindex-values-with-javascript/
							var attributeNode = elem.getAttributeNode("tabindex");

							return attributeNode && attributeNode.specified ?
								parseInt(attributeNode.value, 10) :
								rfocusable.test(elem.nodeName) || rclickable.test(elem.nodeName) && elem.href ?
									0 :
									undefined;
						}
					}
				}
			});

			// Hook for boolean attributes
			boolHook = {
				get: function (elem, name) {
					// Align boolean attributes with corresponding properties
					// Fall back to attribute presence where some booleans are not supported
					var attrNode,
						property = JQXLite.prop(elem, name);
					return property === true || typeof property !== "boolean" && (attrNode = elem.getAttributeNode(name)) && attrNode.nodeValue !== false ?
						name.toLowerCase() :
						undefined;
				},
				set: function (elem, value, name) {
					var propName;
					if (value === false) {
						// Remove boolean attributes when set to false
						JQXLite.removeAttr(elem, name);
					} else {
						// value is true since we know at this point it's type boolean and not false
						// Set boolean attributes to the same name and set the DOM property
						propName = JQXLite.propFix[name] || name;
						if (propName in elem) {
							// Only set the IDL specifically if it already exists on the element
							elem[propName] = true;
						}

						elem.setAttribute(name, name.toLowerCase());
					}
					return name;
				}
			};

			// IE6/7 call enctype encoding
			if (!JQXLite.support.enctype) {
				JQXLite.propFix.enctype = "encoding";
			}

			var rformElems = /^(?:textarea|input|select)$/i,
				rtypenamespace = /^([^\.]*|)(?:\.(.+)|)$/,
				rhoverHack = /(?:^|\s)hover(\.\S+|)\b/,
				rkeyEvent = /^key/,
				rmouseEvent = /^(?:mouse|contextmenu)|click/,
				rfocusMorph = /^(?:focusinfocus|focusoutblur)$/,
				hoverHack = function (events) {
					return JQXLite.event.special.hover ? events : events.replace(rhoverHack, "mouseenter$1 mouseleave$1");
				};

			/*
			 * Helper functions for managing events -- not part of the public interface.
			 * Props to Dean Edwards' addEvent library for many of the ideas.
			 */
			JQXLite.event = {

				add: function (elem, types, handler, data, selector) {

					var elemData, eventHandle, events,
						t, tns, type, namespaces, handleObj,
						handleObjIn, handlers, special;

					// Don't attach events to noData or text/comment nodes (allow plain objects tho)
					if (elem.nodeType === 3 || elem.nodeType === 8 || !types || !handler || !(elemData = JQXLite._data(elem))) {
						return;
					}

					// Caller can pass in an object of custom data in lieu of the handler
					if (handler.handler) {
						handleObjIn = handler;
						handler = handleObjIn.handler;
						selector = handleObjIn.selector;
					}

					// Make sure that the handler has a unique ID, used to find/remove it later
					if (!handler.guid) {
						handler.guid = JQXLite.guid++;
					}

					// Init the element's event structure and main handler, if this is the first
					events = elemData.events;
					if (!events) {
						elemData.events = events = {};
					}
					eventHandle = elemData.handle;
					if (!eventHandle) {
						elemData.handle = eventHandle = function (e) {
							// Discard the second event of a JQXLite.event.trigger() and
							// when an event is called after a page has unloaded
							return typeof JQXLite !== "undefined" && (!e || JQXLite.event.triggered !== e.type) ?
								JQXLite.event.dispatch.apply(eventHandle.elem, arguments) :
								undefined;
						};
						// Add elem as a property of the handle fn to prevent a memory leak with IE non-native events
						eventHandle.elem = elem;
					}

					// Handle multiple events separated by a space
					// JQXLite(...).bind("mouseover mouseout", fn);
					types = JQXLite.trim(hoverHack(types)).split(" ");
					for (t = 0; t < types.length; t++) {

						tns = rtypenamespace.exec(types[t]) || [];
						type = tns[1];
						namespaces = (tns[2] || "").split(".").sort();

						// If event changes its type, use the special event handlers for the changed type
						special = JQXLite.event.special[type] || {};

						// If selector defined, determine special event api type, otherwise given type
						type = (selector ? special.delegateType : special.bindType) || type;

						// Update special based on newly reset type
						special = JQXLite.event.special[type] || {};

						// handleObj is passed to all event handlers
						handleObj = JQXLite.extend({
							type: type,
							origType: tns[1],
							data: data,
							handler: handler,
							guid: handler.guid,
							selector: selector,
							needsContext: selector && JQXLite.expr.match.needsContext.test(selector),
							namespace: namespaces.join(".")
						}, handleObjIn);

						// Init the event handler queue if we're the first
						handlers = events[type];
						if (!handlers) {
							handlers = events[type] = [];
							handlers.delegateCount = 0;

							// Only use addEventListener/attachEvent if the special events handler returns false
							if (!special.setup || special.setup.call(elem, data, namespaces, eventHandle) === false) {
								// Bind the global event handler to the element
								if (elem.addEventListener) {
									if (data && data.passive !== undefined) {
										elem.addEventListener(type, eventHandle, data);
									}
									else {
										elem.addEventListener(type, eventHandle, false);
									}
								} else if (elem.attachEvent) {
									elem.attachEvent("on" + type, eventHandle);
								}
							}
						}

						if (special.add) {
							special.add.call(elem, handleObj);

							if (!handleObj.handler.guid) {
								handleObj.handler.guid = handler.guid;
							}
						}

						// Add to the element's handler list, delegates in front
						if (selector) {
							handlers.splice(handlers.delegateCount++, 0, handleObj);
						} else {
							handlers.push(handleObj);
						}

						// Keep track of which events have ever been used, for event optimization
						JQXLite.event.global[type] = true;
					}

					// Nullify elem to prevent memory leaks in IE
					elem = null;
				},

				global: {},

				// Detach an event or set of events from an element
				remove: function (elem, types, handler, selector, mappedTypes) {

					var t, tns, type, origType, namespaces, origCount,
						j, events, special, eventType, handleObj,
						elemData = JQXLite.hasData(elem) && JQXLite._data(elem);

					if (!elemData || !(events = elemData.events)) {
						return;
					}

					// Once for each type.namespace in types; type may be omitted
					types = JQXLite.trim(hoverHack(types || "")).split(" ");
					for (t = 0; t < types.length; t++) {
						tns = rtypenamespace.exec(types[t]) || [];
						type = origType = tns[1];
						namespaces = tns[2];

						// Unbind all events (on this namespace, if provided) for the element
						if (!type) {
							for (type in events) {
								JQXLite.event.remove(elem, type + types[t], handler, selector, true);
							}
							continue;
						}

						special = JQXLite.event.special[type] || {};
						type = (selector ? special.delegateType : special.bindType) || type;
						eventType = events[type] || [];
						origCount = eventType.length;
						namespaces = namespaces ? new RegExp("(^|\\.)" + namespaces.split(".").sort().join("\\.(?:.*\\.|)") + "(\\.|$)") : null;

						// Remove matching events
						for (j = 0; j < eventType.length; j++) {
							handleObj = eventType[j];

							if ((mappedTypes || origType === handleObj.origType) &&
								(!handler || handler.guid === handleObj.guid) &&
								(!namespaces || namespaces.test(handleObj.namespace)) &&
								(!selector || selector === handleObj.selector || selector === "**" && handleObj.selector)) {
								eventType.splice(j--, 1);

								if (handleObj.selector) {
									eventType.delegateCount--;
								}
								if (special.remove) {
									special.remove.call(elem, handleObj);
								}
							}
						}

						// Remove generic event handler if we removed something and no more handlers exist
						// (avoids potential for endless recursion during removal of special event handlers)
						if (eventType.length === 0 && origCount !== eventType.length) {
							if (!special.teardown || special.teardown.call(elem, namespaces, elemData.handle) === false) {
								JQXLite.removeEvent(elem, type, elemData.handle);
							}

							delete events[type];
						}
					}

					// Remove the expando if it's no longer used
					if (JQXLite.isEmptyObject(events)) {
						delete elemData.handle;

						// removeData also checks for emptiness and clears the expando if empty
						// so use it instead of delete
						JQXLite.removeData(elem, "events", true);
					}
				},

				// Events that are safe to short-circuit if no handlers are attached.
				// Native DOM events should not be added, they may have inline handlers.
				customEvent: {
					"getData": true,
					"setData": true,
					"changeData": true
				},

				trigger: function (event, data, elem, onlyHandlers) {
					// Don't do events on text and comment nodes
					if (elem && (elem.nodeType === 3 || elem.nodeType === 8)) {
						return;
					}

					// Event object or event type
					var cache, exclusive, i, cur, old, ontype, special, handle, eventPath, bubbleType,
						type = event.type || event,
						namespaces = [];

					// focus/blur morphs to focusin/out; ensure we're not firing them right now
					if (rfocusMorph.test(type + JQXLite.event.triggered)) {
						return;
					}

					if (type.indexOf("!") >= 0) {
						// Exclusive events trigger only for the exact event (no namespaces)
						type = type.slice(0, -1);
						exclusive = true;
					}

					if (type.indexOf(".") >= 0) {
						// Namespaced trigger; create a regexp to match event type in handle()
						namespaces = type.split(".");
						type = namespaces.shift();
						namespaces.sort();
					}

					if ((!elem || JQXLite.event.customEvent[type]) && !JQXLite.event.global[type]) {
						// No JQXLite handlers for this event type, and it can't have inline handlers
						return;
					}

					// Caller can pass in an Event, Object, or just an event type string
					event = typeof event === "object" ?
						// JQXLite.Event object
						event[JQXLite.expando] ? event :
							// Object literal
							new JQXLite.Event(type, event) :
						// Just the event type (string)
						new JQXLite.Event(type);

					event.type = type;
					event.isTrigger = true;
					event.exclusive = exclusive;
					event.namespace = namespaces.join(".");
					event.namespace_re = event.namespace ? new RegExp("(^|\\.)" + namespaces.join("\\.(?:.*\\.|)") + "(\\.|$)") : null;
					ontype = type.indexOf(":") < 0 ? "on" + type : "";

					// Handle a global trigger
					if (!elem) {

						// TODO: Stop taunting the data cache; remove global events and always attach to document
						cache = JQXLite.cache;
						for (i in cache) {
							if (cache[i].events && cache[i].events[type]) {
								JQXLite.event.trigger(event, data, cache[i].handle.elem, true);
							}
						}
						return;
					}

					// Clean up the event in case it is being reused
					event.result = undefined;
					if (!event.target) {
						event.target = elem;
					}

					// Clone any incoming data and prepend the event, creating the handler arg list
					data = data != null ? JQXLite.makeArray(data) : [];
					data.unshift(event);

					// Allow special events to draw outside the lines
					special = JQXLite.event.special[type] || {};
					if (special.trigger && special.trigger.apply(elem, data) === false) {
						return;
					}

					// Determine event propagation path in advance, per W3C events spec (#9951)
					// Bubble up to document, then to window; watch for a global ownerDocument var (#9724)
					eventPath = [[elem, special.bindType || type]];
					if (!onlyHandlers && !special.noBubble && !JQXLite.isWindow(elem)) {

						bubbleType = special.delegateType || type;
						cur = rfocusMorph.test(bubbleType + type) ? elem : elem.parentNode;
						for (old = elem; cur; cur = cur.parentNode) {
							eventPath.push([cur, bubbleType]);
							old = cur;
						}

						// Only add window if we got to document (e.g., not plain obj or detached DOM)
						if (old === (elem.ownerDocument || document)) {
							eventPath.push([old.defaultView || old.parentWindow || window, bubbleType]);
						}
					}

					// Fire handlers on the event path
					for (i = 0; i < eventPath.length && !event.isPropagationStopped(); i++) {

						cur = eventPath[i][0];
						event.type = eventPath[i][1];

						handle = (JQXLite._data(cur, "events") || {})[event.type] && JQXLite._data(cur, "handle");
						if (handle) {
							handle.apply(cur, data);
						}
						// Note that this is a bare JS function and not a JQXLite handler
						handle = ontype && cur[ontype];
						if (handle && JQXLite.acceptData(cur) && handle.apply && handle.apply(cur, data) === false) {
							event.preventDefault();
						}
					}
					event.type = type;

					// If nobody prevented the default action, do it now
					if (!onlyHandlers && !event.isDefaultPrevented()) {

						if ((!special._default || special._default.apply(elem.ownerDocument, data) === false) &&
							!(type === "click" && JQXLite.nodeName(elem, "a")) && JQXLite.acceptData(elem)) {

							// Call a native DOM method on the target with the same name name as the event.
							// Can't use an .isFunction() check here because IE6/7 fails that test.
							// Don't do default actions on window, that's where global variables be (#6170)
							// IE<9 dies on focus/blur to hidden element (#1486)
							if (ontype && elem[type] && ((type !== "focus" && type !== "blur") || event.target.offsetWidth !== 0) && !JQXLite.isWindow(elem)) {

								// Don't re-trigger an onFOO event when we call its FOO() method
								old = elem[ontype];

								if (old) {
									elem[ontype] = null;
								}

								// Prevent re-triggering of the same event, since we already bubbled it above
								JQXLite.event.triggered = type;
								elem[type]();
								JQXLite.event.triggered = undefined;

								if (old) {
									elem[ontype] = old;
								}
							}
						}
					}

					return event.result;
				},

				dispatch: function (event) {

					// Make a writable JQXLite.Event from the native event object
					event = JQXLite.event.fix(event || window.event);

					var i, j, cur, ret, selMatch, matched, matches, handleObj, sel, related,
						handlers = ((JQXLite._data(this, "events") || {})[event.type] || []),
						delegateCount = handlers.delegateCount,
						args = core_slice.call(arguments),
						run_all = !event.exclusive && !event.namespace,
						special = JQXLite.event.special[event.type] || {},
						handlerQueue = [];

					// Use the fix-ed JQXLite.Event rather than the (read-only) native event
					args[0] = event;
					event.delegateTarget = this;

					// Call the preDispatch hook for the mapped type, and let it bail if desired
					if (special.preDispatch && special.preDispatch.call(this, event) === false) {
						return;
					}

					// Determine handlers that should run if there are delegated events
					// Avoid non-left-click bubbling in Firefox (#3861)
					if (delegateCount && !(event.button && event.type === "click")) {

						for (cur = event.target; cur != this; cur = cur.parentNode || this) {

							// Don't process clicks (ONLY) on disabled elements (#6911, #8165, #11382, #11764)
							if (cur.disabled !== true || event.type !== "click") {
								selMatch = {};
								matches = [];
								for (i = 0; i < delegateCount; i++) {
									handleObj = handlers[i];
									sel = handleObj.selector;

									if (selMatch[sel] === undefined) {
										selMatch[sel] = handleObj.needsContext ?
											JQXLite(sel, this).index(cur) >= 0 :
											JQXLite.find(sel, this, null, [cur]).length;
									}
									if (selMatch[sel]) {
										matches.push(handleObj);
									}
								}
								if (matches.length) {
									handlerQueue.push({ elem: cur, matches: matches });
								}
							}
						}
					}

					// Add the remaining (directly-bound) handlers
					if (handlers.length > delegateCount) {
						handlerQueue.push({ elem: this, matches: handlers.slice(delegateCount) });
					}

					// Run delegates first; they may want to stop propagation beneath us
					for (i = 0; i < handlerQueue.length && !event.isPropagationStopped(); i++) {
						matched = handlerQueue[i];
						event.currentTarget = matched.elem;

						for (j = 0; j < matched.matches.length && !event.isImmediatePropagationStopped(); j++) {
							handleObj = matched.matches[j];

							// Triggered event must either 1) be non-exclusive and have no namespace, or
							// 2) have namespace(s) a subset or equal to those in the bound event (both can have no namespace).
							if (run_all || (!event.namespace && !handleObj.namespace) || event.namespace_re && event.namespace_re.test(handleObj.namespace)) {

								event.data = handleObj.data;
								event.handleObj = handleObj;

								ret = ((JQXLite.event.special[handleObj.origType] || {}).handle || handleObj.handler)
									.apply(matched.elem, args);

								if (ret !== undefined) {
									event.result = ret;
									if (ret === false) {
										event.preventDefault();
										event.stopPropagation();
									}
								}
							}
						}
					}

					// Call the postDispatch hook for the mapped type
					if (special.postDispatch) {
						special.postDispatch.call(this, event);
					}

					return event.result;
				},

				// Includes some event props shared by KeyEvent and MouseEvent
				// *** attrChange attrName relatedNode srcElement  are not normalized, non-W3C, deprecated, will be removed in 1.8 ***
				props: "attrChange attrName relatedNode srcElement altKey bubbles cancelable ctrlKey currentTarget eventPhase metaKey relatedTarget shiftKey target timeStamp view which".split(" "),

				fixHooks: {},

				keyHooks: {
					props: "char charCode key keyCode".split(" "),
					filter: function (event, original) {

						// Add which for key events
						if (event.which == null) {
							event.which = original.charCode != null ? original.charCode : original.keyCode;
						}

						return event;
					}
				},

				mouseHooks: {
					props: "button buttons clientX clientY fromElement offsetX offsetY pageX pageY screenX screenY toElement".split(" "),
					filter: function (event, original) {
						var eventDoc, doc, body,
							button = original.button,
							fromElement = original.fromElement;

						// Calculate pageX/Y if missing and clientX/Y available
						if (event.pageX == null && original.clientX != null) {
							eventDoc = event.target.ownerDocument || document;
							doc = eventDoc.documentElement;
							body = eventDoc.body;

							event.pageX = original.clientX + (doc && doc.scrollLeft || body && body.scrollLeft || 0) - (doc && doc.clientLeft || body && body.clientLeft || 0);
							event.pageY = original.clientY + (doc && doc.scrollTop || body && body.scrollTop || 0) - (doc && doc.clientTop || body && body.clientTop || 0);
						}

						// Add relatedTarget, if necessary
						if (!event.relatedTarget && fromElement) {
							event.relatedTarget = fromElement === event.target ? original.toElement : fromElement;
						}

						// Add which for click: 1 === left; 2 === middle; 3 === right
						// Note: button is not normalized, so don't use it
						if (!event.which && button !== undefined) {
							event.which = (button & 1 ? 1 : (button & 2 ? 3 : (button & 4 ? 2 : 0)));
						}

						return event;
					}
				},

				fix: function (event) {
					if (event[JQXLite.expando]) {
						return event;
					}

					// Create a writable copy of the event object and normalize some properties
					var i, prop,
						originalEvent = event,
						fixHook = JQXLite.event.fixHooks[event.type] || {},
						copy = fixHook.props ? this.props.concat(fixHook.props) : this.props;

					event = JQXLite.Event(originalEvent);

					for (i = copy.length; i;) {
						prop = copy[--i];
						event[prop] = originalEvent[prop];
					}

					// Fix target property, if necessary (#1925, IE 6/7/8 & Safari2)
					if (!event.target) {
						event.target = originalEvent.srcElement || document;
					}

					// Target should not be a text node (#504, Safari)
					if (event.target.nodeType === 3) {
						event.target = event.target.parentNode;
					}

					// For mouse/key events, metaKey==false if it's undefined (#3368, #11328; IE6/7/8)
					event.metaKey = !!event.metaKey;

					return fixHook.filter ? fixHook.filter(event, originalEvent) : event;
				},

				special: {
					load: {
						// Prevent triggered image.load events from bubbling to window.load
						noBubble: true
					},

					focus: {
						delegateType: "focusin"
					},
					blur: {
						delegateType: "focusout"
					},

					beforeunload: {
						setup: function (data, namespaces, eventHandle) {
							// We only want to do this special case on windows
							if (JQXLite.isWindow(this)) {
								this.onbeforeunload = eventHandle;
							}
						},

						teardown: function (namespaces, eventHandle) {
							if (this.onbeforeunload === eventHandle) {
								this.onbeforeunload = null;
							}
						}
					}
				},

				simulate: function (type, elem, event, bubble) {
					// Piggyback on a donor event to simulate a different one.
					// Fake originalEvent to avoid donor's stopPropagation, but if the
					// simulated event prevents default then we do the same on the donor.
					var e = JQXLite.extend(
						new JQXLite.Event(),
						event,
						{
							type: type,
							isSimulated: true,
							originalEvent: {}
						}
					);
					if (bubble) {
						JQXLite.event.trigger(e, null, elem);
					} else {
						JQXLite.event.dispatch.call(elem, e);
					}
					if (e.isDefaultPrevented()) {
						event.preventDefault();
					}
				}
			};

			// Some plugins are using, but it's undocumented/deprecated and will be removed.
			// The 1.7 special event interface should provide all the hooks needed now.
			JQXLite.event.handle = JQXLite.event.dispatch;

			JQXLite.removeEvent = document.removeEventListener ?
				function (elem, type, handle) {
					if (elem.removeEventListener) {
						elem.removeEventListener(type, handle, false);
					}
				} :
				function (elem, type, handle) {
					var name = "on" + type;

					if (elem.detachEvent) {

						// #8545, #7054, preventing memory leaks for custom events in IE6-8
						// detachEvent needed property on element, by name of that event, to properly expose it to GC
						if (typeof elem[name] === "undefined") {
							elem[name] = null;
						}

						elem.detachEvent(name, handle);
					}
				};

			JQXLite.Event = function (src, props) {
				// Allow instantiation without the 'new' keyword
				if (!(this instanceof JQXLite.Event)) {
					return new JQXLite.Event(src, props);
				}

				// Event object
				if (src && src.type) {
					this.originalEvent = src;
					this.type = src.type;

					// Events bubbling up the document may have been marked as prevented
					// by a handler lower down the tree; reflect the correct value.
					this.isDefaultPrevented = (src.defaultPrevented || src.returnValue === false ||
						src.getPreventDefault && src.getPreventDefault()) ? returnTrue : returnFalse;

					// Event type
				} else {
					this.type = src;
				}

				// Put explicitly provided properties onto the event object
				if (props) {
					JQXLite.extend(this, props);
				}

				// Create a timestamp if incoming event doesn't have one
				this.timeStamp = src && src.timeStamp || JQXLite.now();

				// Mark it as fixed
				this[JQXLite.expando] = true;
			};

			function returnFalse() {
				return false;
			}
			function returnTrue() {
				return true;
			}

			// JQXLite.Event is based on DOM3 Events as specified by the ECMAScript Language Binding
			// http://www.w3.org/TR/2003/WD-DOM-Level-3-Events-20030331/ecma-script-binding.html
			JQXLite.Event.prototype = {
				preventDefault: function () {
					this.isDefaultPrevented = returnTrue;

					var e = this.originalEvent;
					if (!e) {
						return;
					}

					// if preventDefault exists run it on the original event
					if (e.preventDefault) {
						e.preventDefault();

						// otherwise set the returnValue property of the original event to false (IE)
					} else {
						e.returnValue = false;
					}
				},
				stopPropagation: function () {
					this.isPropagationStopped = returnTrue;

					var e = this.originalEvent;
					if (!e) {
						return;
					}
					// if stopPropagation exists run it on the original event
					if (e.stopPropagation) {
						e.stopPropagation();
					}
					// otherwise set the cancelBubble property of the original event to true (IE)
					e.cancelBubble = true;
				},
				stopImmediatePropagation: function () {
					this.isImmediatePropagationStopped = returnTrue;
					this.stopPropagation();
				},
				isDefaultPrevented: returnFalse,
				isPropagationStopped: returnFalse,
				isImmediatePropagationStopped: returnFalse
			};

			// Create mouseenter/leave events using mouseover/out and event-time checks
			JQXLite.each({
				mouseenter: "mouseover",
				mouseleave: "mouseout"
			}, function (orig, fix) {
				JQXLite.event.special[orig] = {
					delegateType: fix,
					bindType: fix,

					handle: function (event) {
						var ret,
							target = this,
							related = event.relatedTarget,
							handleObj = event.handleObj,
							selector = handleObj.selector;

						// For mousenter/leave call the handler if related is outside the target.
						// NB: No relatedTarget if the mouse left/entered the browser window
						if (!related || (related !== target && !JQXLite.contains(target, related))) {
							event.type = handleObj.origType;
							ret = handleObj.handler.apply(this, arguments);
							event.type = fix;
						}
						return ret;
					}
				};
			});

			JQXLite.fn.extend({

				on: function (types, selector, data, fn, /*INTERNAL*/ one) {
					var origFn, type;

					// Types can be a map of types/handlers
					if (typeof types === "object") {
						// ( types-Object, selector, data )
						if (typeof selector !== "string") { // && selector != null
							// ( types-Object, data )
							data = data || selector;
							selector = undefined;
						}
						for (type in types) {
							this.on(type, selector, data, types[type], one);
						}
						return this;
					}

					if (data == null && fn == null) {
						// ( types, fn )
						fn = selector;
						data = selector = undefined;
					} else if (fn == null) {
						if (typeof selector === "string") {
							// ( types, selector, fn )
							fn = data;
							data = undefined;
						} else {
							// ( types, data, fn )
							fn = data;
							data = selector;
							selector = undefined;
						}
					}
					if (fn === false) {
						fn = returnFalse;
					} else if (!fn) {
						return this;
					}

					if (one === 1) {
						origFn = fn;
						fn = function (event) {
							// Can use an empty set, since event contains the info
							JQXLite().off(event);
							return origFn.apply(this, arguments);
						};
						// Use same guid so caller can remove using origFn
						fn.guid = origFn.guid || (origFn.guid = JQXLite.guid++);
					}
					return this.each(function () {
						JQXLite.event.add(this, types, fn, data, selector);
					});
				},

				off: function (types, selector, fn) {
					var handleObj, type;
					if (types && types.preventDefault && types.handleObj) {
						// ( event )  dispatched JQXLite.Event
						handleObj = types.handleObj;
						JQXLite(types.delegateTarget).off(
							handleObj.namespace ? handleObj.origType + "." + handleObj.namespace : handleObj.origType,
							handleObj.selector,
							handleObj.handler
						);
						return this;
					}
					if (typeof types === "object") {
						// ( types-object [, selector] )
						for (type in types) {
							this.off(type, selector, types[type]);
						}
						return this;
					}
					if (selector === false || typeof selector === "function") {
						// ( types [, fn] )
						fn = selector;
						selector = undefined;
					}
					if (fn === false) {
						fn = returnFalse;
					}
					return this.each(function () {
						JQXLite.event.remove(this, types, fn, selector);
					});
				},

				delegate: function (selector, types, data, fn) {
					return this.on(types, selector, data, fn);
				},
				undelegate: function (selector, types, fn) {
					// ( namespace ) or ( selector, types [, fn] )
					return arguments.length === 1 ? this.off(selector, "**") : this.off(types, selector || "**", fn);
				},

				trigger: function (type, data) {
					return this.each(function () {
						JQXLite.event.trigger(type, data, this);
					});
				},
				triggerHandler: function (type, data) {
					if (this[0]) {
						return JQXLite.event.trigger(type, data, this[0], true);
					}
				},

				toggle: function (fn) {
					// Save reference to arguments for access in closure
					var args = arguments,
						guid = fn.guid || JQXLite.guid++,
						i = 0,
						toggler = function (event) {
							// Figure out which function to execute
							var lastToggle = (JQXLite._data(this, "lastToggle" + fn.guid) || 0) % i;
							JQXLite._data(this, "lastToggle" + fn.guid, lastToggle + 1);

							// Make sure that clicks stop
							event.preventDefault();

							// and execute the function
							return args[lastToggle].apply(this, arguments) || false;
						};

					// link all the functions, so any of them can unbind this click handler
					toggler.guid = guid;
					while (i < args.length) {
						args[i++].guid = guid;
					}

					return this.click(toggler);
				},

				hover: function (fnOver, fnOut) {
					return this.mouseenter(fnOver).mouseleave(fnOut || fnOver);
				}
			});

			JQXLite.each(("blur focus focusin focusout load resize scroll unload click dblclick " +
				"mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave " +
				"change select submit keydown keypress keyup error contextmenu").split(" "), function (i, name) {

					// Handle event binding
					JQXLite.fn[name] = function (data, fn) {
						if (fn == null) {
							fn = data;
							data = null;
						}

						return arguments.length > 0 ?
							this.on(name, null, data, fn) :
							this.trigger(name);
					};

					if (rkeyEvent.test(name)) {
						JQXLite.event.fixHooks[name] = JQXLite.event.keyHooks;
					}

					if (rmouseEvent.test(name)) {
						JQXLite.event.fixHooks[name] = JQXLite.event.mouseHooks;
					}
				});
			/*!
			 * Sizzle CSS Selector Engine
			 * Copyright 2012 JQXLite Foundation and other contributors
			 * Released under the MIT license
			 * http://sizzlejs.com/
			 */
			(function (window, undefined) {

				var cachedruns,
					assertGetIdNotName,
					Expr,
					getText,
					isXML,
					contains,
					compile,
					sortOrder,
					hasDuplicate,
					outermostContext,

					baseHasDuplicate = true,
					strundefined = "undefined",

					expando = ("sizcache" + Math.random()).replace(".", ""),

					Token = String,
					document = window.document,
					docElem = document.documentElement,
					dirruns = 0,
					done = 0,
					pop = [].pop,
					push = [].push,
					slice = [].slice,
					// Use a stripped-down indexOf if a native one is unavailable
					indexOf = [].indexOf || function (elem) {
						var i = 0,
							len = this.length;
						for (; i < len; i++) {
							if (this[i] === elem) {
								return i;
							}
						}
						return -1;
					},

					// Augment a function for special use by Sizzle
					markFunction = function (fn, value) {
						fn[expando] = value == null || value;
						return fn;
					},

					createCache = function () {
						var cache = {},
							keys = [];

						return markFunction(function (key, value) {
							// Only keep the most recent entries
							if (keys.push(key) > Expr.cacheLength) {
								delete cache[keys.shift()];
							}

							// Retrieve with (key + " ") to avoid collision with native Object.prototype properties (see Issue #157)
							return (cache[key + " "] = value);
						}, cache);
					},

					classCache = createCache(),
					tokenCache = createCache(),
					compilerCache = createCache(),

					// Regex

					// Whitespace characters http://www.w3.org/TR/css3-selectors/#whitespace
					whitespace = "[\\x20\\t\\r\\n\\f]",
					// http://www.w3.org/TR/css3-syntax/#characters
					characterEncoding = "(?:\\\\.|[-\\w]|[^\\x00-\\xa0])+",

					// Loosely modeled on CSS identifier characters
					// An unquoted value should be a CSS identifier (http://www.w3.org/TR/css3-selectors/#attribute-selectors)
					// Proper syntax: http://www.w3.org/TR/CSS21/syndata.html#value-def-identifier
					identifier = characterEncoding.replace("w", "w#"),

					// Acceptable operators http://www.w3.org/TR/selectors/#attribute-selectors
					operators = "([*^$|!~]?=)",
					attributes = "\\[" + whitespace + "*(" + characterEncoding + ")" + whitespace +
						"*(?:" + operators + whitespace + "*(?:(['\"])((?:\\\\.|[^\\\\])*?)\\3|(" + identifier + ")|)|)" + whitespace + "*\\]",

					// Prefer arguments not in parens/brackets,
					//   then attribute selectors and non-pseudos (denoted by :),
					//   then anything else
					// These preferences are here to reduce the number of selectors
					//   needing tokenize in the PSEUDO preFilter
					pseudos = ":(" + characterEncoding + ")(?:\\((?:(['\"])((?:\\\\.|[^\\\\])*?)\\2|([^()[\\]]*|(?:(?:" + attributes + ")|[^:]|\\\\.)*|.*))\\)|)",

					// For matchExpr.POS and matchExpr.needsContext
					pos = ":(even|odd|eq|gt|lt|nth|first|last)(?:\\(" + whitespace +
						"*((?:-\\d)?\\d*)" + whitespace + "*\\)|)(?=[^-]|$)",

					// Leading and non-escaped trailing whitespace, capturing some non-whitespace characters preceding the latter
					rtrim = new RegExp("^" + whitespace + "+|((?:^|[^\\\\])(?:\\\\.)*)" + whitespace + "+$", "g"),

					rcomma = new RegExp("^" + whitespace + "*," + whitespace + "*"),
					rcombinators = new RegExp("^" + whitespace + "*([\\x20\\t\\r\\n\\f>+~])" + whitespace + "*"),
					rpseudo = new RegExp(pseudos),

					// Easily-parseable/retrievable ID or TAG or CLASS selectors
					rquickExpr = /^(?:#([\w\-]+)|(\w+)|\.([\w\-]+))$/,

					rnot = /^:not/,
					rsibling = /[\x20\t\r\n\f]*[+~]/,
					rendsWithNot = /:not\($/,

					rheader = /h\d/i,
					rinputs = /input|select|textarea|button/i,

					rbackslash = /\\(?!\\)/g,

					matchExpr = {
						"ID": new RegExp("^#(" + characterEncoding + ")"),
						"CLASS": new RegExp("^\\.(" + characterEncoding + ")"),
						"NAME": new RegExp("^\\[name=['\"]?(" + characterEncoding + ")['\"]?\\]"),
						"TAG": new RegExp("^(" + characterEncoding.replace("w", "w*") + ")"),
						"ATTR": new RegExp("^" + attributes),
						"PSEUDO": new RegExp("^" + pseudos),
						"POS": new RegExp(pos, "i"),
						"CHILD": new RegExp("^:(only|nth|first|last)-child(?:\\(" + whitespace +
							"*(even|odd|(([+-]|)(\\d*)n|)" + whitespace + "*(?:([+-]|)" + whitespace +
							"*(\\d+)|))" + whitespace + "*\\)|)", "i"),
						// For use in libraries implementing .is()
						"needsContext": new RegExp("^" + whitespace + "*[>+~]|" + pos, "i")
					},

					// Support

					// Used for testing something on an element
					assert = function (fn) {
						var div = document.createElement("div");

						try {
							return fn(div);
						} catch (e) {
							return false;
						} finally {
							// release memory in IE
							div = null;
						}
					},

					// Check if getElementsByTagName("*") returns only elements
					assertTagNameNoComments = assert(function (div) {
						div.appendChild(document.createComment(""));
						return !div.getElementsByTagName("*").length;
					}),

					// Check if getAttribute returns normalized href attributes
					assertHrefNotNormalized = assert(function (div) {
						div.innerHTML = "<a href='#'></a>";
						return div.firstChild && typeof div.firstChild.getAttribute !== strundefined &&
							div.firstChild.getAttribute("href") === "#";
					}),

					// Check if attributes should be retrieved by attribute nodes
					assertAttributes = assert(function (div) {
						div.innerHTML = "<select></select>";
						var type = typeof div.lastChild.getAttribute("multiple");
						// IE8 returns a string for some attributes even when not present
						return type !== "boolean" && type !== "string";
					}),

					// Check if getElementsByClassName can be trusted
					assertUsableClassName = assert(function (div) {
						// Opera can't find a second classname (in 9.6)
						div.innerHTML = "<div class='hidden e'></div><div class='hidden'></div>";
						if (!div.getElementsByClassName || !div.getElementsByClassName("e").length) {
							return false;
						}

						// Safari 3.2 caches class attributes and doesn't catch changes
						div.lastChild.className = "e";
						return div.getElementsByClassName("e").length === 2;
					}),

					// Check if getElementById returns elements by name
					// Check if getElementsByName privileges form controls or returns elements by ID
					assertUsableName = assert(function (div) {
						// Inject content
						div.id = expando + 0;
						div.innerHTML = "<a name='" + expando + "'></a><div name='" + expando + "'></div>";
						docElem.insertBefore(div, docElem.firstChild);

						// Test
						var pass = document.getElementsByName &&
							// buggy browsers will return fewer than the correct 2
							document.getElementsByName(expando).length === 2 +
							// buggy browsers will return more than the correct 0
							document.getElementsByName(expando + 0).length;
						assertGetIdNotName = !document.getElementById(expando);

						// Cleanup
						docElem.removeChild(div);

						return pass;
					});

				// If slice is not available, provide a backup
				try {
					slice.call(docElem.childNodes, 0)[0].nodeType;
				} catch (e) {
					slice = function (i) {
						var elem,
							results = [];
						for (; (elem = this[i]); i++) {
							results.push(elem);
						}
						return results;
					};
				}

				function Sizzle(selector, context, results, seed) {
					results = results || [];
					context = context || document;
					var match, elem, xml, m,
						nodeType = context.nodeType;

					if (!selector || typeof selector !== "string") {
						return results;
					}

					if (nodeType !== 1 && nodeType !== 9) {
						return [];
					}

					xml = isXML(context);

					if (!xml && !seed) {
						if ((match = rquickExpr.exec(selector))) {
							// Speed-up: Sizzle("#ID")
							if ((m = match[1])) {
								if (nodeType === 9) {
									elem = context.getElementById(m);
									// Check parentNode to catch when Blackberry 4.6 returns
									// nodes that are no longer in the document #6963
									if (elem && elem.parentNode) {
										// Handle the case where IE, Opera, and Webkit return items
										// by name instead of ID
										if (elem.id === m) {
											results.push(elem);
											return results;
										}
									} else {
										return results;
									}
								} else {
									// Context is not a document
									if (context.ownerDocument && (elem = context.ownerDocument.getElementById(m)) &&
										contains(context, elem) && elem.id === m) {
										results.push(elem);
										return results;
									}
								}

								// Speed-up: Sizzle("TAG")
							} else if (match[2]) {
								push.apply(results, slice.call(context.getElementsByTagName(selector), 0));
								return results;

								// Speed-up: Sizzle(".CLASS")
							} else if ((m = match[3]) && assertUsableClassName && context.getElementsByClassName) {
								push.apply(results, slice.call(context.getElementsByClassName(m), 0));
								return results;
							}
						}
					}

					// All others
					return select(selector.replace(rtrim, "$1"), context, results, seed, xml);
				}

				Sizzle.matches = function (expr, elements) {
					return Sizzle(expr, null, null, elements);
				};

				Sizzle.matchesSelector = function (elem, expr) {
					return Sizzle(expr, null, null, [elem]).length > 0;
				};

				// Returns a function to use in pseudos for input types
				function createInputPseudo(type) {
					return function (elem) {
						var name = elem.nodeName.toLowerCase();
						return name === "input" && elem.type === type;
					};
				}

				// Returns a function to use in pseudos for buttons
				function createButtonPseudo(type) {
					return function (elem) {
						var name = elem.nodeName.toLowerCase();
						return (name === "input" || name === "button") && elem.type === type;
					};
				}

				// Returns a function to use in pseudos for positionals
				function createPositionalPseudo(fn) {
					return markFunction(function (argument) {
						argument = +argument;
						return markFunction(function (seed, matches) {
							var j,
								matchIndexes = fn([], seed.length, argument),
								i = matchIndexes.length;

							// Match elements found at the specified indexes
							while (i--) {
								if (seed[(j = matchIndexes[i])]) {
									seed[j] = !(matches[j] = seed[j]);
								}
							}
						});
					});
				}

				/**
				 * Utility function for retrieving the text value of an array of DOM nodes
				 * @param {Array|Element} elem
				 */
				getText = Sizzle.getText = function (elem) {
					var node,
						ret = "",
						i = 0,
						nodeType = elem.nodeType;

					if (nodeType) {
						if (nodeType === 1 || nodeType === 9 || nodeType === 11) {
							// Use textContent for elements
							// innerText usage removed for consistency of new lines (see #11153)
							if (typeof elem.textContent === "string") {
								return elem.textContent;
							} else {
								// Traverse its children
								for (elem = elem.firstChild; elem; elem = elem.nextSibling) {
									ret += getText(elem);
								}
							}
						} else if (nodeType === 3 || nodeType === 4) {
							return elem.nodeValue;
						}
						// Do not include comment or processing instruction nodes
					} else {

						// If no nodeType, this is expected to be an array
						for (; (node = elem[i]); i++) {
							// Do not traverse comment nodes
							ret += getText(node);
						}
					}
					return ret;
				};

				isXML = Sizzle.isXML = function (elem) {
					// documentElement is verified for cases where it doesn't yet exist
					// (such as loading iframes in IE - #4833)
					var documentElement = elem && (elem.ownerDocument || elem).documentElement;
					return documentElement ? documentElement.nodeName !== "HTML" : false;
				};

				// Element contains another
				contains = Sizzle.contains = docElem.contains ?
					function (a, b) {
						var adown = a.nodeType === 9 ? a.documentElement : a,
							bup = b && b.parentNode;
						return a === bup || !!(bup && bup.nodeType === 1 && adown.contains && adown.contains(bup));
					} :
					docElem.compareDocumentPosition ?
						function (a, b) {
							return b && !!(a.compareDocumentPosition(b) & 16);
						} :
						function (a, b) {
							while ((b = b.parentNode)) {
								if (b === a) {
									return true;
								}
							}
							return false;
						};

				Sizzle.attr = function (elem, name) {
					var val,
						xml = isXML(elem);

					if (!xml) {
						name = name.toLowerCase();
					}
					if ((val = Expr.attrHandle[name])) {
						return val(elem);
					}
					if (xml || assertAttributes) {
						return elem.getAttribute(name);
					}
					val = elem.getAttributeNode(name);
					return val ?
						typeof elem[name] === "boolean" ?
							elem[name] ? name : null :
							val.specified ? val.value : null :
						null;
				};

				Expr = Sizzle.selectors = {

					// Can be adjusted by the user
					cacheLength: 50,

					createPseudo: markFunction,

					match: matchExpr,

					// IE6/7 return a modified href
					attrHandle: assertHrefNotNormalized ?
						{} :
						{
							"href": function (elem) {
								return elem.getAttribute("href", 2);
							},
							"type": function (elem) {
								return elem.getAttribute("type");
							}
						},

					find: {
						"ID": assertGetIdNotName ?
							function (id, context, xml) {
								if (typeof context.getElementById !== strundefined && !xml) {
									var m = context.getElementById(id);
									// Check parentNode to catch when Blackberry 4.6 returns
									// nodes that are no longer in the document #6963
									return m && m.parentNode ? [m] : [];
								}
							} :
							function (id, context, xml) {
								if (typeof context.getElementById !== strundefined && !xml) {
									var m = context.getElementById(id);

									return m ?
										m.id === id || typeof m.getAttributeNode !== strundefined && m.getAttributeNode("id").value === id ?
											[m] :
											undefined :
										[];
								}
							},

						"TAG": assertTagNameNoComments ?
							function (tag, context) {
								if (typeof context.getElementsByTagName !== strundefined) {
									return context.getElementsByTagName(tag);
								}
							} :
							function (tag, context) {
								var results = context.getElementsByTagName(tag);

								// Filter out possible comments
								if (tag === "*") {
									var elem,
										tmp = [],
										i = 0;

									for (; (elem = results[i]); i++) {
										if (elem.nodeType === 1) {
											tmp.push(elem);
										}
									}

									return tmp;
								}
								return results;
							},

						"NAME": assertUsableName && function (tag, context) {
							if (typeof context.getElementsByName !== strundefined) {
								return context.getElementsByName(name);
							}
						},

						"CLASS": assertUsableClassName && function (className, context, xml) {
							if (typeof context.getElementsByClassName !== strundefined && !xml) {
								return context.getElementsByClassName(className);
							}
						}
					},

					relative: {
						">": { dir: "parentNode", first: true },
						" ": { dir: "parentNode" },
						"+": { dir: "previousSibling", first: true },
						"~": { dir: "previousSibling" }
					},

					preFilter: {
						"ATTR": function (match) {
							match[1] = match[1].replace(rbackslash, "");

							// Move the given value to match[3] whether quoted or unquoted
							match[3] = (match[4] || match[5] || "").replace(rbackslash, "");

							if (match[2] === "~=") {
								match[3] = " " + match[3] + " ";
							}

							return match.slice(0, 4);
						},

						"CHILD": function (match) {
							/* matches from matchExpr["CHILD"]
								1 type (only|nth|...)
								2 argument (even|odd|\d*|\d*n([+-]\d+)?|...)
								3 xn-component of xn+y argument ([+-]?\d*n|)
								4 sign of xn-component
								5 x of xn-component
								6 sign of y-component
								7 y of y-component
							*/
							match[1] = match[1].toLowerCase();

							if (match[1] === "nth") {
								// nth-child requires argument
								if (!match[2]) {
									Sizzle.error(match[0]);
								}

								// numeric x and y parameters for Expr.filter.CHILD
								// remember that false/true cast respectively to 0/1
								match[3] = +(match[3] ? match[4] + (match[5] || 1) : 2 * (match[2] === "even" || match[2] === "odd"));
								match[4] = +((match[6] + match[7]) || match[2] === "odd");

								// other types prohibit arguments
							} else if (match[2]) {
								Sizzle.error(match[0]);
							}

							return match;
						},

						"PSEUDO": function (match) {
							var unquoted, excess;
							if (matchExpr["CHILD"].test(match[0])) {
								return null;
							}

							if (match[3]) {
								match[2] = match[3];
							} else if ((unquoted = match[4])) {
								// Only check arguments that contain a pseudo
								if (rpseudo.test(unquoted) &&
									// Get excess from tokenize (recursively)
									(excess = tokenize(unquoted, true)) &&
									// advance to the next closing parenthesis
									(excess = unquoted.indexOf(")", unquoted.length - excess) - unquoted.length)) {

									// excess is a negative index
									unquoted = unquoted.slice(0, excess);
									match[0] = match[0].slice(0, excess);
								}
								match[2] = unquoted;
							}

							// Return only captures needed by the pseudo filter method (type and argument)
							return match.slice(0, 3);
						}
					},

					filter: {
						"ID": assertGetIdNotName ?
							function (id) {
								id = id.replace(rbackslash, "");
								return function (elem) {
									return elem.getAttribute("id") === id;
								};
							} :
							function (id) {
								id = id.replace(rbackslash, "");
								return function (elem) {
									var node = typeof elem.getAttributeNode !== strundefined && elem.getAttributeNode("id");
									return node && node.value === id;
								};
							},

						"TAG": function (nodeName) {
							if (nodeName === "*") {
								return function () { return true; };
							}
							nodeName = nodeName.replace(rbackslash, "").toLowerCase();

							return function (elem) {
								return elem.nodeName && elem.nodeName.toLowerCase() === nodeName;
							};
						},

						"CLASS": function (className) {
							var pattern = classCache[expando][className + " "];

							return pattern ||
								(pattern = new RegExp("(^|" + whitespace + ")" + className + "(" + whitespace + "|$)")) &&
								classCache(className, function (elem) {
									return pattern.test(elem.className || (typeof elem.getAttribute !== strundefined && elem.getAttribute("class")) || "");
								});
						},

						"ATTR": function (name, operator, check) {
							return function (elem, context) {
								var result = Sizzle.attr(elem, name);

								if (result == null) {
									return operator === "!=";
								}
								if (!operator) {
									return true;
								}

								result += "";

								return operator === "=" ? result === check :
									operator === "!=" ? result !== check :
										operator === "^=" ? check && result.indexOf(check) === 0 :
											operator === "*=" ? check && result.indexOf(check) > -1 :
												operator === "$=" ? check && result.substr(result.length - check.length) === check :
													operator === "~=" ? (" " + result + " ").indexOf(check) > -1 :
														operator === "|=" ? result === check || result.substr(0, check.length + 1) === check + "-" :
															false;
							};
						},

						"CHILD": function (type, argument, first, last) {

							if (type === "nth") {
								return function (elem) {
									var node, diff,
										parent = elem.parentNode;

									if (first === 1 && last === 0) {
										return true;
									}

									if (parent) {
										diff = 0;
										for (node = parent.firstChild; node; node = node.nextSibling) {
											if (node.nodeType === 1) {
												diff++;
												if (elem === node) {
													break;
												}
											}
										}
									}

									// Incorporate the offset (or cast to NaN), then check against cycle size
									diff -= last;
									return diff === first || (diff % first === 0 && diff / first >= 0);
								};
							}

							return function (elem) {
								var node = elem;

								switch (type) {
									case "only":
									case "first":
										while ((node = node.previousSibling)) {
											if (node.nodeType === 1) {
												return false;
											}
										}

										if (type === "first") {
											return true;
										}

										node = elem;

									/* falls through */
									case "last":
										while ((node = node.nextSibling)) {
											if (node.nodeType === 1) {
												return false;
											}
										}

										return true;
								}
							};
						},

						"PSEUDO": function (pseudo, argument) {
							// pseudo-class names are case-insensitive
							// http://www.w3.org/TR/selectors/#pseudo-classes
							// Prioritize by case sensitivity in case custom pseudos are added with uppercase letters
							// Remember that setFilters inherits from pseudos
							var args,
								fn = Expr.pseudos[pseudo] || Expr.setFilters[pseudo.toLowerCase()] ||
									Sizzle.error("unsupported pseudo: " + pseudo);

							// The user may use createPseudo to indicate that
							// arguments are needed to create the filter function
							// just as Sizzle does
							if (fn[expando]) {
								return fn(argument);
							}

							// But maintain support for old signatures
							if (fn.length > 1) {
								args = [pseudo, pseudo, "", argument];
								return Expr.setFilters.hasOwnProperty(pseudo.toLowerCase()) ?
									markFunction(function (seed, matches) {
										var idx,
											matched = fn(seed, argument),
											i = matched.length;
										while (i--) {
											idx = indexOf.call(seed, matched[i]);
											seed[idx] = !(matches[idx] = matched[i]);
										}
									}) :
									function (elem) {
										return fn(elem, 0, args);
									};
							}

							return fn;
						}
					},

					pseudos: {
						"not": markFunction(function (selector) {
							// Trim the selector passed to compile
							// to avoid treating leading and trailing
							// spaces as combinators
							var input = [],
								results = [],
								matcher = compile(selector.replace(rtrim, "$1"));

							return matcher[expando] ?
								markFunction(function (seed, matches, context, xml) {
									var elem,
										unmatched = matcher(seed, null, xml, []),
										i = seed.length;

									// Match elements unmatched by `matcher`
									while (i--) {
										if ((elem = unmatched[i])) {
											seed[i] = !(matches[i] = elem);
										}
									}
								}) :
								function (elem, context, xml) {
									input[0] = elem;
									matcher(input, null, xml, results);
									return !results.pop();
								};
						}),

						"has": markFunction(function (selector) {
							return function (elem) {
								return Sizzle(selector, elem).length > 0;
							};
						}),

						"contains": markFunction(function (text) {
							return function (elem) {
								return (elem.textContent || elem.innerText || getText(elem)).indexOf(text) > -1;
							};
						}),

						"enabled": function (elem) {
							return elem.disabled === false;
						},

						"disabled": function (elem) {
							return elem.disabled === true;
						},

						"checked": function (elem) {
							// In CSS3, :checked should return both checked and selected elements
							// http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
							var nodeName = elem.nodeName.toLowerCase();
							return (nodeName === "input" && !!elem.checked) || (nodeName === "option" && !!elem.selected);
						},

						"selected": function (elem) {
							// Accessing this property makes selected-by-default
							// options in Safari work properly
							if (elem.parentNode) {
								elem.parentNode.selectedIndex;
							}

							return elem.selected === true;
						},

						"parent": function (elem) {
							return !Expr.pseudos["empty"](elem);
						},

						"empty": function (elem) {
							// http://www.w3.org/TR/selectors/#empty-pseudo
							// :empty is only affected by element nodes and content nodes(including text(3), cdata(4)),
							//   not comment, processing instructions, or others
							// Thanks to Diego Perini for the nodeName shortcut
							//   Greater than "@" means alpha characters (specifically not starting with "#" or "?")
							var nodeType;
							elem = elem.firstChild;
							while (elem) {
								if (elem.nodeName > "@" || (nodeType = elem.nodeType) === 3 || nodeType === 4) {
									return false;
								}
								elem = elem.nextSibling;
							}
							return true;
						},

						"header": function (elem) {
							return rheader.test(elem.nodeName);
						},

						"text": function (elem) {
							var type, attr;
							// IE6 and 7 will map elem.type to 'text' for new HTML5 types (search, etc)
							// use getAttribute instead to test this case
							return elem.nodeName.toLowerCase() === "input" &&
								(type = elem.type) === "text" &&
								((attr = elem.getAttribute("type")) == null || attr.toLowerCase() === type);
						},

						// Input types
						"radio": createInputPseudo("radio"),
						"checkbox": createInputPseudo("checkbox"),
						"file": createInputPseudo("file"),
						"password": createInputPseudo("password"),
						"image": createInputPseudo("image"),

						"submit": createButtonPseudo("submit"),
						"reset": createButtonPseudo("reset"),

						"button": function (elem) {
							var name = elem.nodeName.toLowerCase();
							return name === "input" && elem.type === "button" || name === "button";
						},

						"input": function (elem) {
							return rinputs.test(elem.nodeName);
						},

						"focus": function (elem) {
							var doc = elem.ownerDocument;
							return elem === doc.activeElement && (!doc.hasFocus || doc.hasFocus()) && !!(elem.type || elem.href || ~elem.tabIndex);
						},

						"active": function (elem) {
							return elem === elem.ownerDocument.activeElement;
						},

						// Positional types
						"first": createPositionalPseudo(function () {
							return [0];
						}),

						"last": createPositionalPseudo(function (matchIndexes, length) {
							return [length - 1];
						}),

						"eq": createPositionalPseudo(function (matchIndexes, length, argument) {
							return [argument < 0 ? argument + length : argument];
						}),

						"even": createPositionalPseudo(function (matchIndexes, length) {
							for (var i = 0; i < length; i += 2) {
								matchIndexes.push(i);
							}
							return matchIndexes;
						}),

						"odd": createPositionalPseudo(function (matchIndexes, length) {
							for (var i = 1; i < length; i += 2) {
								matchIndexes.push(i);
							}
							return matchIndexes;
						}),

						"lt": createPositionalPseudo(function (matchIndexes, length, argument) {
							for (var i = argument < 0 ? argument + length : argument; --i >= 0;) {
								matchIndexes.push(i);
							}
							return matchIndexes;
						}),

						"gt": createPositionalPseudo(function (matchIndexes, length, argument) {
							for (var i = argument < 0 ? argument + length : argument; ++i < length;) {
								matchIndexes.push(i);
							}
							return matchIndexes;
						})
					}
				};

				function siblingCheck(a, b, ret) {
					if (a === b) {
						return ret;
					}

					var cur = a.nextSibling;

					while (cur) {
						if (cur === b) {
							return -1;
						}

						cur = cur.nextSibling;
					}

					return 1;
				}

				sortOrder = docElem.compareDocumentPosition ?
					function (a, b) {
						if (a === b) {
							hasDuplicate = true;
							return 0;
						}

						return (!a.compareDocumentPosition || !b.compareDocumentPosition ?
							a.compareDocumentPosition :
							a.compareDocumentPosition(b) & 4
						) ? -1 : 1;
					} :
					function (a, b) {
						// The nodes are identical, we can exit early
						if (a === b) {
							hasDuplicate = true;
							return 0;

							// Fallback to using sourceIndex (in IE) if it's available on both nodes
						} else if (a.sourceIndex && b.sourceIndex) {
							return a.sourceIndex - b.sourceIndex;
						}

						var al, bl,
							ap = [],
							bp = [],
							aup = a.parentNode,
							bup = b.parentNode,
							cur = aup;

						// If the nodes are siblings (or identical) we can do a quick check
						if (aup === bup) {
							return siblingCheck(a, b);

							// If no parents were found then the nodes are disconnected
						} else if (!aup) {
							return -1;

						} else if (!bup) {
							return 1;
						}

						// Otherwise they're somewhere else in the tree so we need
						// to build up a full list of the parentNodes for comparison
						while (cur) {
							ap.unshift(cur);
							cur = cur.parentNode;
						}

						cur = bup;

						while (cur) {
							bp.unshift(cur);
							cur = cur.parentNode;
						}

						al = ap.length;
						bl = bp.length;

						// Start walking down the tree looking for a discrepancy
						for (var i = 0; i < al && i < bl; i++) {
							if (ap[i] !== bp[i]) {
								return siblingCheck(ap[i], bp[i]);
							}
						}

						// We ended someplace up the tree so do a sibling check
						return i === al ?
							siblingCheck(a, bp[i], -1) :
							siblingCheck(ap[i], b, 1);
					};

				// Always assume the presence of duplicates if sort doesn't
				// pass them to our comparison function (as in Google Chrome).
				[0, 0].sort(sortOrder);
				baseHasDuplicate = !hasDuplicate;

				// Document sorting and removing duplicates
				Sizzle.uniqueSort = function (results) {
					var elem,
						duplicates = [],
						i = 1,
						j = 0;

					hasDuplicate = baseHasDuplicate;
					results.sort(sortOrder);

					if (hasDuplicate) {
						for (; (elem = results[i]); i++) {
							if (elem === results[i - 1]) {
								j = duplicates.push(i);
							}
						}
						while (j--) {
							results.splice(duplicates[j], 1);
						}
					}

					return results;
				};

				Sizzle.error = function (msg) {
					throw new Error("Syntax error, unrecognized expression: " + msg);
				};

				function tokenize(selector, parseOnly) {
					var matched, match, tokens, type,
						soFar, groups, preFilters,
						cached = tokenCache[expando][selector + " "];

					if (cached) {
						return parseOnly ? 0 : cached.slice(0);
					}

					soFar = selector;
					groups = [];
					preFilters = Expr.preFilter;

					while (soFar) {

						// Comma and first run
						if (!matched || (match = rcomma.exec(soFar))) {
							if (match) {
								// Don't consume trailing commas as valid
								soFar = soFar.slice(match[0].length) || soFar;
							}
							groups.push(tokens = []);
						}

						matched = false;

						// Combinators
						if ((match = rcombinators.exec(soFar))) {
							tokens.push(matched = new Token(match.shift()));
							soFar = soFar.slice(matched.length);

							// Cast descendant combinators to space
							matched.type = match[0].replace(rtrim, " ");
						}

						// Filters
						for (type in Expr.filter) {
							if ((match = matchExpr[type].exec(soFar)) && (!preFilters[type] ||
								(match = preFilters[type](match)))) {

								tokens.push(matched = new Token(match.shift()));
								soFar = soFar.slice(matched.length);
								matched.type = type;
								matched.matches = match;
							}
						}

						if (!matched) {
							break;
						}
					}

					// Return the length of the invalid excess
					// if we're just parsing
					// Otherwise, throw an error or return tokens
					return parseOnly ?
						soFar.length :
						soFar ?
							Sizzle.error(selector) :
							// Cache the tokens
							tokenCache(selector, groups).slice(0);
				}

				function addCombinator(matcher, combinator, base) {
					var dir = combinator.dir,
						checkNonElements = base && combinator.dir === "parentNode",
						doneName = done++;

					return combinator.first ?
						// Check against closest ancestor/preceding element
						function (elem, context, xml) {
							while ((elem = elem[dir])) {
								if (checkNonElements || elem.nodeType === 1) {
									return matcher(elem, context, xml);
								}
							}
						} :

						// Check against all ancestor/preceding elements
						function (elem, context, xml) {
							// We can't set arbitrary data on XML nodes, so they don't benefit from dir caching
							if (!xml) {
								var cache,
									dirkey = dirruns + " " + doneName + " ",
									cachedkey = dirkey + cachedruns;
								while ((elem = elem[dir])) {
									if (checkNonElements || elem.nodeType === 1) {
										if ((cache = elem[expando]) === cachedkey) {
											return elem.sizset;
										} else if (typeof cache === "string" && cache.indexOf(dirkey) === 0) {
											if (elem.sizset) {
												return elem;
											}
										} else {
											elem[expando] = cachedkey;
											if (matcher(elem, context, xml)) {
												elem.sizset = true;
												return elem;
											}
											elem.sizset = false;
										}
									}
								}
							} else {
								while ((elem = elem[dir])) {
									if (checkNonElements || elem.nodeType === 1) {
										if (matcher(elem, context, xml)) {
											return elem;
										}
									}
								}
							}
						};
				}

				function elementMatcher(matchers) {
					return matchers.length > 1 ?
						function (elem, context, xml) {
							var i = matchers.length;
							while (i--) {
								if (!matchers[i](elem, context, xml)) {
									return false;
								}
							}
							return true;
						} :
						matchers[0];
				}

				function condense(unmatched, map, filter, context, xml) {
					var elem,
						newUnmatched = [],
						i = 0,
						len = unmatched.length,
						mapped = map != null;

					for (; i < len; i++) {
						if ((elem = unmatched[i])) {
							if (!filter || filter(elem, context, xml)) {
								newUnmatched.push(elem);
								if (mapped) {
									map.push(i);
								}
							}
						}
					}

					return newUnmatched;
				}

				function setMatcher(preFilter, selector, matcher, postFilter, postFinder, postSelector) {
					if (postFilter && !postFilter[expando]) {
						postFilter = setMatcher(postFilter);
					}
					if (postFinder && !postFinder[expando]) {
						postFinder = setMatcher(postFinder, postSelector);
					}
					return markFunction(function (seed, results, context, xml) {
						var temp, i, elem,
							preMap = [],
							postMap = [],
							preexisting = results.length,

							// Get initial elements from seed or context
							elems = seed || multipleContexts(selector || "*", context.nodeType ? [context] : context, []),

							// Prefilter to get matcher input, preserving a map for seed-results synchronization
							matcherIn = preFilter && (seed || !selector) ?
								condense(elems, preMap, preFilter, context, xml) :
								elems,

							matcherOut = matcher ?
								// If we have a postFinder, or filtered seed, or non-seed postFilter or preexisting results,
								postFinder || (seed ? preFilter : preexisting || postFilter) ?

									// ...intermediate processing is necessary
									[] :

									// ...otherwise use results directly
									results :
								matcherIn;

						// Find primary matches
						if (matcher) {
							matcher(matcherIn, matcherOut, context, xml);
						}

						// Apply postFilter
						if (postFilter) {
							temp = condense(matcherOut, postMap);
							postFilter(temp, [], context, xml);

							// Un-match failing elements by moving them back to matcherIn
							i = temp.length;
							while (i--) {
								if ((elem = temp[i])) {
									matcherOut[postMap[i]] = !(matcherIn[postMap[i]] = elem);
								}
							}
						}

						if (seed) {
							if (postFinder || preFilter) {
								if (postFinder) {
									// Get the final matcherOut by condensing this intermediate into postFinder contexts
									temp = [];
									i = matcherOut.length;
									while (i--) {
										if ((elem = matcherOut[i])) {
											// Restore matcherIn since elem is not yet a final match
											temp.push((matcherIn[i] = elem));
										}
									}
									postFinder(null, (matcherOut = []), temp, xml);
								}

								// Move matched elements from seed to results to keep them synchronized
								i = matcherOut.length;
								while (i--) {
									if ((elem = matcherOut[i]) &&
										(temp = postFinder ? indexOf.call(seed, elem) : preMap[i]) > -1) {

										seed[temp] = !(results[temp] = elem);
									}
								}
							}

							// Add elements to results, through postFinder if defined
						} else {
							matcherOut = condense(
								matcherOut === results ?
									matcherOut.splice(preexisting, matcherOut.length) :
									matcherOut
							);
							if (postFinder) {
								postFinder(null, results, matcherOut, xml);
							} else {
								push.apply(results, matcherOut);
							}
						}
					});
				}

				function matcherFromTokens(tokens) {
					var checkContext, matcher, j,
						len = tokens.length,
						leadingRelative = Expr.relative[tokens[0].type],
						implicitRelative = leadingRelative || Expr.relative[" "],
						i = leadingRelative ? 1 : 0,

						// The foundational matcher ensures that elements are reachable from top-level context(s)
						matchContext = addCombinator(function (elem) {
							return elem === checkContext;
						}, implicitRelative, true),
						matchAnyContext = addCombinator(function (elem) {
							return indexOf.call(checkContext, elem) > -1;
						}, implicitRelative, true),
						matchers = [function (elem, context, xml) {
							return (!leadingRelative && (xml || context !== outermostContext)) || (
								(checkContext = context).nodeType ?
									matchContext(elem, context, xml) :
									matchAnyContext(elem, context, xml));
						}];

					for (; i < len; i++) {
						if ((matcher = Expr.relative[tokens[i].type])) {
							matchers = [addCombinator(elementMatcher(matchers), matcher)];
						} else {
							matcher = Expr.filter[tokens[i].type].apply(null, tokens[i].matches);

							// Return special upon seeing a positional matcher
							if (matcher[expando]) {
								// Find the next relative operator (if any) for proper handling
								j = ++i;
								for (; j < len; j++) {
									if (Expr.relative[tokens[j].type]) {
										break;
									}
								}
								return setMatcher(
									i > 1 && elementMatcher(matchers),
									i > 1 && tokens.slice(0, i - 1).join("").replace(rtrim, "$1"),
									matcher,
									i < j && matcherFromTokens(tokens.slice(i, j)),
									j < len && matcherFromTokens((tokens = tokens.slice(j))),
									j < len && tokens.join("")
								);
							}
							matchers.push(matcher);
						}
					}

					return elementMatcher(matchers);
				}

				function matcherFromGroupMatchers(elementMatchers, setMatchers) {
					var bySet = setMatchers.length > 0,
						byElement = elementMatchers.length > 0,
						superMatcher = function (seed, context, xml, results, expandContext) {
							var elem, j, matcher,
								setMatched = [],
								matchedCount = 0,
								i = "0",
								unmatched = seed && [],
								outermost = expandContext != null,
								contextBackup = outermostContext,
								// We must always have either seed elements or context
								elems = seed || byElement && Expr.find["TAG"]("*", expandContext && context.parentNode || context),
								// Nested matchers should use non-integer dirruns
								dirrunsUnique = (dirruns += contextBackup == null ? 1 : Math.E);

							if (outermost) {
								outermostContext = context !== document && context;
								cachedruns = superMatcher.el;
							}

							// Add elements passing elementMatchers directly to results
							for (; (elem = elems[i]) != null; i++) {
								if (byElement && elem) {
									for (j = 0; (matcher = elementMatchers[j]); j++) {
										if (matcher(elem, context, xml)) {
											results.push(elem);
											break;
										}
									}
									if (outermost) {
										dirruns = dirrunsUnique;
										cachedruns = ++superMatcher.el;
									}
								}

								// Track unmatched elements for set filters
								if (bySet) {
									// They will have gone through all possible matchers
									if ((elem = !matcher && elem)) {
										matchedCount--;
									}

									// Lengthen the array for every element, matched or not
									if (seed) {
										unmatched.push(elem);
									}
								}
							}

							// Apply set filters to unmatched elements
							matchedCount += i;
							if (bySet && i !== matchedCount) {
								for (j = 0; (matcher = setMatchers[j]); j++) {
									matcher(unmatched, setMatched, context, xml);
								}

								if (seed) {
									// Reintegrate element matches to eliminate the need for sorting
									if (matchedCount > 0) {
										while (i--) {
											if (!(unmatched[i] || setMatched[i])) {
												setMatched[i] = pop.call(results);
											}
										}
									}

									// Discard index placeholder values to get only actual matches
									setMatched = condense(setMatched);
								}

								// Add matches to results
								push.apply(results, setMatched);

								// Seedless set matches succeeding multiple successful matchers stipulate sorting
								if (outermost && !seed && setMatched.length > 0 &&
									(matchedCount + setMatchers.length) > 1) {

									Sizzle.uniqueSort(results);
								}
							}

							// Override manipulation of globals by nested matchers
							if (outermost) {
								dirruns = dirrunsUnique;
								outermostContext = contextBackup;
							}

							return unmatched;
						};

					superMatcher.el = 0;
					return bySet ?
						markFunction(superMatcher) :
						superMatcher;
				}

				compile = Sizzle.compile = function (selector, group /* Internal Use Only */) {
					var i,
						setMatchers = [],
						elementMatchers = [],
						cached = compilerCache[expando][selector + " "];

					if (!cached) {
						// Generate a function of recursive functions that can be used to check each element
						if (!group) {
							group = tokenize(selector);
						}
						i = group.length;
						while (i--) {
							cached = matcherFromTokens(group[i]);
							if (cached[expando]) {
								setMatchers.push(cached);
							} else {
								elementMatchers.push(cached);
							}
						}

						// Cache the compiled function
						cached = compilerCache(selector, matcherFromGroupMatchers(elementMatchers, setMatchers));
					}
					return cached;
				};

				function multipleContexts(selector, contexts, results) {
					var i = 0,
						len = contexts.length;
					for (; i < len; i++) {
						Sizzle(selector, contexts[i], results);
					}
					return results;
				}

				function select(selector, context, results, seed, xml) {
					var i, tokens, token, type, find,
						match = tokenize(selector),
						j = match.length;

					if (!seed) {
						// Try to minimize operations if there is only one group
						if (match.length === 1) {

							// Take a shortcut and set the context if the root selector is an ID
							tokens = match[0] = match[0].slice(0);
							if (tokens.length > 2 && (token = tokens[0]).type === "ID" &&
								context.nodeType === 9 && !xml &&
								Expr.relative[tokens[1].type]) {

								context = Expr.find["ID"](token.matches[0].replace(rbackslash, ""), context, xml)[0];
								if (!context) {
									return results;
								}

								selector = selector.slice(tokens.shift().length);
							}

							// Fetch a seed set for right-to-left matching
							for (i = matchExpr["POS"].test(selector) ? -1 : tokens.length - 1; i >= 0; i--) {
								token = tokens[i];

								// Abort if we hit a combinator
								if (Expr.relative[(type = token.type)]) {
									break;
								}
								if ((find = Expr.find[type])) {
									// Search, expanding context for leading sibling combinators
									if ((seed = find(
										token.matches[0].replace(rbackslash, ""),
										rsibling.test(tokens[0].type) && context.parentNode || context,
										xml
									))) {

										// If seed is empty or no tokens remain, we can return early
										tokens.splice(i, 1);
										selector = seed.length && tokens.join("");
										if (!selector) {
											push.apply(results, slice.call(seed, 0));
											return results;
										}

										break;
									}
								}
							}
						}
					}

					// Compile and execute a filtering function
					// Provide `match` to avoid retokenization if we modified the selector above
					compile(selector, match)(
						seed,
						context,
						xml,
						results,
						rsibling.test(selector)
					);
					return results;
				}

				if (document.querySelectorAll) {
					(function () {
						var disconnectedMatch,
							oldSelect = select,
							rescape = /'|\\/g,
							rattributeQuotes = /\=[\x20\t\r\n\f]*([^'"\]]*)[\x20\t\r\n\f]*\]/g,

							// qSa(:focus) reports false when true (Chrome 21), no need to also add to buggyMatches since matches checks buggyQSA
							// A support test would require too much code (would include document ready)
							rbuggyQSA = [":focus"],

							// matchesSelector(:active) reports false when true (IE9/Opera 11.5)
							// A support test would require too much code (would include document ready)
							// just skip matchesSelector for :active
							rbuggyMatches = [":active"],
							matches = docElem.matchesSelector ||
								docElem.mozMatchesSelector ||
								docElem.webkitMatchesSelector ||
								docElem.oMatchesSelector ||
								docElem.msMatchesSelector;

						// Build QSA regex
						// Regex strategy adopted from Diego Perini
						assert(function (div) {
							// Select is set to empty string on purpose
							// This is to test IE's treatment of not explictly
							// setting a boolean content attribute,
							// since its presence should be enough
							// http://bugs.jqx.com/ticket/12359
							div.innerHTML = "<select><option selected=''></option></select>";

							// IE8 - Some boolean attributes are not treated correctly
							if (!div.querySelectorAll("[selected]").length) {
								rbuggyQSA.push("\\[" + whitespace + "*(?:checked|disabled|ismap|multiple|readonly|selected|value)");
							}

							// Webkit/Opera - :checked should return selected option elements
							// http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
							// IE8 throws error here (do not put tests after this one)
							if (!div.querySelectorAll(":checked").length) {
								rbuggyQSA.push(":checked");
							}
						});

						assert(function (div) {

							// Opera 10-12/IE9 - ^= $= *= and empty values
							// Should not select anything
							div.innerHTML = "<p test=''></p>";
							if (div.querySelectorAll("[test^='']").length) {
								rbuggyQSA.push("[*^$]=" + whitespace + "*(?:\"\"|'')");
							}

							// FF 3.5 - :enabled/:disabled and hidden elements (hidden elements are still enabled)
							// IE8 throws error here (do not put tests after this one)
							div.innerHTML = "<input type='hidden'/>";
							if (!div.querySelectorAll(":enabled").length) {
								rbuggyQSA.push(":enabled", ":disabled");
							}
						});

						// rbuggyQSA always contains :focus, so no need for a length check
						rbuggyQSA = /* rbuggyQSA.length && */ new RegExp(rbuggyQSA.join("|"));

						select = function (selector, context, results, seed, xml) {
							// Only use querySelectorAll when not filtering,
							// when this is not xml,
							// and when no QSA bugs apply
							if (!seed && !xml && !rbuggyQSA.test(selector)) {
								var groups, i,
									old = true,
									nid = expando,
									newContext = context,
									newSelector = context.nodeType === 9 && selector;

								// qSA works strangely on Element-rooted queries
								// We can work around this by specifying an extra ID on the root
								// and working up from there (Thanks to Andrew Dupont for the technique)
								// IE 8 doesn't work on object elements
								if (context.nodeType === 1 && context.nodeName.toLowerCase() !== "object") {
									groups = tokenize(selector);

									if ((old = context.getAttribute("id"))) {
										nid = old.replace(rescape, "\\$&");
									} else {
										context.setAttribute("id", nid);
									}
									nid = "[id='" + nid + "'] ";

									i = groups.length;
									while (i--) {
										groups[i] = nid + groups[i].join("");
									}
									newContext = rsibling.test(selector) && context.parentNode || context;
									newSelector = groups.join(",");
								}

								if (newSelector) {
									try {
										push.apply(results, slice.call(newContext.querySelectorAll(
											newSelector
										), 0));
										return results;
									} catch (qsaError) {
									} finally {
										if (!old) {
											context.removeAttribute("id");
										}
									}
								}
							}

							return oldSelect(selector, context, results, seed, xml);
						};

						if (matches) {
							assert(function (div) {
								// Check to see if it's possible to do matchesSelector
								// on a disconnected node (IE 9)
								disconnectedMatch = matches.call(div, "div");

								// This should fail with an exception
								// Gecko does not error, returns false instead
								try {
									matches.call(div, "[test!='']:sizzle");
									rbuggyMatches.push("!=", pseudos);
								} catch (e) { }
							});

							// rbuggyMatches always contains :active and :focus, so no need for a length check
							rbuggyMatches = /* rbuggyMatches.length && */ new RegExp(rbuggyMatches.join("|"));

							Sizzle.matchesSelector = function (elem, expr) {
								// Make sure that attribute selectors are quoted
								expr = expr.replace(rattributeQuotes, "='$1']");

								// rbuggyMatches always contains :active, so no need for an existence check
								if (!isXML(elem) && !rbuggyMatches.test(expr) && !rbuggyQSA.test(expr)) {
									try {
										var ret = matches.call(elem, expr);

										// IE 9's matchesSelector returns false on disconnected nodes
										if (ret || disconnectedMatch ||
											// As well, disconnected nodes are said to be in a document
											// fragment in IE 9
											elem.document && elem.document.nodeType !== 11) {
											return ret;
										}
									} catch (e) { }
								}

								return Sizzle(expr, null, null, [elem]).length > 0;
							};
						}
					})();
				}

				// Deprecated
				Expr.pseudos["nth"] = Expr.pseudos["eq"];

				// Back-compat
				function setFilters() { }
				Expr.filters = setFilters.prototype = Expr.pseudos;
				Expr.setFilters = new setFilters();

				// Override sizzle attribute retrieval
				Sizzle.attr = JQXLite.attr;
				JQXLite.find = Sizzle;
				JQXLite.expr = Sizzle.selectors;
				JQXLite.expr[":"] = JQXLite.expr.pseudos;
				JQXLite.unique = Sizzle.uniqueSort;
				JQXLite.text = Sizzle.getText;
				JQXLite.isXMLDoc = Sizzle.isXML;
				JQXLite.contains = Sizzle.contains;


			})(window);
			var runtil = /Until$/,
				rparentsprev = /^(?:parents|prev(?:Until|All))/,
				isSimple = /^.[^:#\[\.,]*$/,
				rneedsContext = JQXLite.expr.match.needsContext,
				// methods guaranteed to produce a unique set when starting from a unique set
				guaranteedUnique = {
					children: true,
					contents: true,
					next: true,
					prev: true
				};

			JQXLite.fn.extend({
				find: function (selector) {
					var i, l, length, n, r, ret,
						self = this;

					if (typeof selector !== "string") {
						return JQXLite(selector).filter(function () {
							for (i = 0, l = self.length; i < l; i++) {
								if (JQXLite.contains(self[i], this)) {
									return true;
								}
							}
						});
					}

					ret = this.pushStack("", "find", selector);

					for (i = 0, l = this.length; i < l; i++) {
						length = ret.length;
						JQXLite.find(selector, this[i], ret);

						if (i > 0) {
							// Make sure that the results are unique
							for (n = length; n < ret.length; n++) {
								for (r = 0; r < length; r++) {
									if (ret[r] === ret[n]) {
										ret.splice(n--, 1);
										break;
									}
								}
							}
						}
					}

					return ret;
				},

				has: function (target) {
					var i,
						targets = JQXLite(target, this),
						len = targets.length;

					return this.filter(function () {
						for (i = 0; i < len; i++) {
							if (JQXLite.contains(this, targets[i])) {
								return true;
							}
						}
					});
				},

				not: function (selector) {
					return this.pushStack(winnow(this, selector, false), "not", selector);
				},

				filter: function (selector) {
					return this.pushStack(winnow(this, selector, true), "filter", selector);
				},

				is: function (selector) {
					return !!selector && (
						typeof selector === "string" ?
							// If this is a positional/relative selector, check membership in the returned set
							// so $("p:first").is("p:last") won't return true for a doc with two "p".
							rneedsContext.test(selector) ?
								JQXLite(selector, this.context).index(this[0]) >= 0 :
								JQXLite.filter(selector, this).length > 0 :
							this.filter(selector).length > 0);
				},

				closest: function (selectors, context) {
					var cur,
						i = 0,
						l = this.length,
						ret = [],
						pos = rneedsContext.test(selectors) || typeof selectors !== "string" ?
							JQXLite(selectors, context || this.context) :
							0;

					for (; i < l; i++) {
						cur = this[i];

						while (cur && cur.ownerDocument && cur !== context && cur.nodeType !== 11) {
							if (pos ? pos.index(cur) > -1 : JQXLite.find.matchesSelector(cur, selectors)) {
								ret.push(cur);
								break;
							}
							cur = cur.parentNode;
						}
					}

					ret = ret.length > 1 ? JQXLite.unique(ret) : ret;

					return this.pushStack(ret, "closest", selectors);
				},

				// Determine the position of an element within
				// the matched set of elements
				index: function (elem) {

					// No argument, return index in parent
					if (!elem) {
						return (this[0] && this[0].parentNode) ? this.prevAll().length : -1;
					}

					// index in selector
					if (typeof elem === "string") {
						return JQXLite.inArray(this[0], JQXLite(elem));
					}

					// Locate the position of the desired element
					return JQXLite.inArray(
						// If it receives a JQXLite object, the first element is used
						elem.jqx ? elem[0] : elem, this);
				},

				add: function (selector, context) {
					var set = typeof selector === "string" ?
						JQXLite(selector, context) :
						JQXLite.makeArray(selector && selector.nodeType ? [selector] : selector),
						all = JQXLite.merge(this.get(), set);

					return this.pushStack(isDisconnected(set[0]) || isDisconnected(all[0]) ?
						all :
						JQXLite.unique(all));
				},

				addBack: function (selector) {
					return this.add(selector == null ?
						this.prevObject : this.prevObject.filter(selector)
					);
				}
			});

			JQXLite.fn.andSelf = JQXLite.fn.addBack;

			// A painfully simple check to see if an element is disconnected
			// from a document (should be improved, where feasible).
			function isDisconnected(node) {
				return !node || !node.parentNode || node.parentNode.nodeType === 11;
			}

			function sibling(cur, dir) {
				do {
					cur = cur[dir];
				} while (cur && cur.nodeType !== 1);

				return cur;
			}

			JQXLite.each({
				parent: function (elem) {
					var parent = elem.parentNode;
					return parent && parent.nodeType !== 11 ? parent : null;
				},
				parents: function (elem) {
					return JQXLite.dir(elem, "parentNode");
				},
				parentsUntil: function (elem, i, until) {
					return JQXLite.dir(elem, "parentNode", until);
				},
				next: function (elem) {
					return sibling(elem, "nextSibling");
				},
				prev: function (elem) {
					return sibling(elem, "previousSibling");
				},
				nextAll: function (elem) {
					return JQXLite.dir(elem, "nextSibling");
				},
				prevAll: function (elem) {
					return JQXLite.dir(elem, "previousSibling");
				},
				nextUntil: function (elem, i, until) {
					return JQXLite.dir(elem, "nextSibling", until);
				},
				prevUntil: function (elem, i, until) {
					return JQXLite.dir(elem, "previousSibling", until);
				},
				siblings: function (elem) {
					return JQXLite.sibling((elem.parentNode || {}).firstChild, elem);
				},
				children: function (elem) {
					return JQXLite.sibling(elem.firstChild);
				},
				contents: function (elem) {
					return JQXLite.nodeName(elem, "iframe") ?
						elem.contentDocument || elem.contentWindow.document :
						JQXLite.merge([], elem.childNodes);
				}
			}, function (name, fn) {
				JQXLite.fn[name] = function (until, selector) {
					var ret = JQXLite.map(this, fn, until);

					if (!runtil.test(name)) {
						selector = until;
					}

					if (selector && typeof selector === "string") {
						ret = JQXLite.filter(selector, ret);
					}

					ret = this.length > 1 && !guaranteedUnique[name] ? JQXLite.unique(ret) : ret;

					if (this.length > 1 && rparentsprev.test(name)) {
						ret = ret.reverse();
					}

					return this.pushStack(ret, name, core_slice.call(arguments).join(","));
				};
			});

			JQXLite.extend({
				filter: function (expr, elems, not) {
					if (not) {
						expr = ":not(" + expr + ")";
					}

					return elems.length === 1 ?
						JQXLite.find.matchesSelector(elems[0], expr) ? [elems[0]] : [] :
						JQXLite.find.matches(expr, elems);
				},

				dir: function (elem, dir, until) {
					var matched = [],
						cur = elem[dir];

					while (cur && cur.nodeType !== 9 && (until === undefined || cur.nodeType !== 1 || !JQXLite(cur).is(until))) {
						if (cur.nodeType === 1) {
							matched.push(cur);
						}
						cur = cur[dir];
					}
					return matched;
				},

				sibling: function (n, elem) {
					var r = [];

					for (; n; n = n.nextSibling) {
						if (n.nodeType === 1 && n !== elem) {
							r.push(n);
						}
					}

					return r;
				}
			});

			// Implement the identical functionality for filter and not
			function winnow(elements, qualifier, keep) {

				// Can't pass null or undefined to indexOf in Firefox 4
				// Set to 0 to skip string check
				qualifier = qualifier || 0;

				if (JQXLite.isFunction(qualifier)) {
					return JQXLite.grep(elements, function (elem, i) {
						var retVal = !!qualifier.call(elem, i, elem);
						return retVal === keep;
					});

				} else if (qualifier.nodeType) {
					return JQXLite.grep(elements, function (elem, i) {
						return (elem === qualifier) === keep;
					});

				} else if (typeof qualifier === "string") {
					var filtered = JQXLite.grep(elements, function (elem) {
						return elem.nodeType === 1;
					});

					if (isSimple.test(qualifier)) {
						return JQXLite.filter(qualifier, filtered, !keep);
					} else {
						qualifier = JQXLite.filter(qualifier, filtered);
					}
				}

				return JQXLite.grep(elements, function (elem, i) {
					return (JQXLite.inArray(elem, qualifier) >= 0) === keep;
				});
			}
			function createSafeFragment(document) {
				var list = nodeNames.split("|"),
					safeFrag = document.createDocumentFragment();

				if (safeFrag.createElement) {
					while (list.length) {
						safeFrag.createElement(
							list.pop()
						);
					}
				}
				return safeFrag;
			}

			var nodeNames = "abbr|article|aside|audio|bdi|canvas|data|datalist|details|figcaption|figure|footer|" +
				"header|hgroup|mark|meter|nav|output|progress|section|summary|time|video",
				rinlinejQuery = / JQXLite\d+="(?:null|\d+)"/g,
				rleadingWhitespace = /^\s+/,
				rxhtmlTag = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\w:]+)[^>]*)\/>/gi,
				rtagName = /<([\w:]+)/,
				rtbody = /<tbody/i,
				rhtml = /<|&#?\w+;/,
				rnoInnerhtml = /<(?:script|style|link)/i,
				rnocache = /<(?:script|object|embed|option|style)/i,
				rnoshimcache = new RegExp("<(?:" + nodeNames + ")[\\s/>]", "i"),
				rcheckableType = /^(?:checkbox|radio)$/,
				// checked="checked" or checked
				rchecked = /checked\s*(?:[^=]|=\s*.checked.)/i,
				rscriptType = /\/(java|ecma)script/i,
				rcleanScript = /^\s*<!(?:\[CDATA\[|\-\-)|[\]\-]{2}>\s*$/g,
				wrapMap = {
					option: [1, "<select multiple='multiple'>", "</select>"],
					legend: [1, "<fieldset>", "</fieldset>"],
					thead: [1, "<table>", "</table>"],
					tr: [2, "<table><tbody>", "</tbody></table>"],
					td: [3, "<table><tbody><tr>", "</tr></tbody></table>"],
					col: [2, "<table><tbody></tbody><colgroup>", "</colgroup></table>"],
					area: [1, "<map>", "</map>"],
					_default: [0, "", ""]
				},
				safeFragment = createSafeFragment(document),
				fragmentDiv = safeFragment.appendChild(document.createElement("div"));

			wrapMap.optgroup = wrapMap.option;
			wrapMap.tbody = wrapMap.tfoot = wrapMap.colgroup = wrapMap.caption = wrapMap.thead;
			wrapMap.th = wrapMap.td;

			// IE6-8 can't serialize link, script, style, or any html5 (NoScope) tags,
			// unless wrapped in a div with non-breaking characters in front of it.
			if (!JQXLite.support.htmlSerialize) {
				wrapMap._default = [1, "X<div>", "</div>"];
			}

			JQXLite.fn.extend({
				text: function (value) {
					return JQXLite.access(this, function (value) {
						return value === undefined ?
							JQXLite.text(this) :
							this.empty().append((this[0] && this[0].ownerDocument || document).createTextNode(value));
					}, null, value, arguments.length);
				},

				wrapAll: function (html) {
					if (JQXLite.isFunction(html)) {
						return this.each(function (i) {
							JQXLite(this).wrapAll(html.call(this, i));
						});
					}

					if (this[0]) {
						// The elements to wrap the target around
						var wrap = JQXLite(html, this[0].ownerDocument).eq(0).clone(true);

						if (this[0].parentNode) {
							wrap.insertBefore(this[0]);
						}

						wrap.map(function () {
							var elem = this;

							while (elem.firstChild && elem.firstChild.nodeType === 1) {
								elem = elem.firstChild;
							}

							return elem;
						}).append(this);
					}

					return this;
				},

				wrapInner: function (html) {
					if (JQXLite.isFunction(html)) {
						return this.each(function (i) {
							JQXLite(this).wrapInner(html.call(this, i));
						});
					}

					return this.each(function () {
						var self = JQXLite(this),
							contents = self.contents();

						if (contents.length) {
							contents.wrapAll(html);

						} else {
							self.append(html);
						}
					});
				},

				wrap: function (html) {
					var isFunction = JQXLite.isFunction(html);

					return this.each(function (i) {
						JQXLite(this).wrapAll(isFunction ? html.call(this, i) : html);
					});
				},

				unwrap: function () {
					return this.parent().each(function () {
						if (!JQXLite.nodeName(this, "body")) {
							JQXLite(this).replaceWith(this.childNodes);
						}
					}).end();
				},

				append: function () {
					return this.domManip(arguments, true, function (elem) {
						if (this.nodeType === 1 || this.nodeType === 11) {
							this.appendChild(elem);
						}
					});
				},

				prepend: function () {
					return this.domManip(arguments, true, function (elem) {
						if (this.nodeType === 1 || this.nodeType === 11) {
							this.insertBefore(elem, this.firstChild);
						}
					});
				},

				before: function () {
					if (!isDisconnected(this[0])) {
						return this.domManip(arguments, false, function (elem) {
							this.parentNode.insertBefore(elem, this);
						});
					}

					if (arguments.length) {
						var set = JQXLite.clean(arguments);
						return this.pushStack(JQXLite.merge(set, this), "before", this.selector);
					}
				},

				after: function () {
					if (!isDisconnected(this[0])) {
						return this.domManip(arguments, false, function (elem) {
							this.parentNode.insertBefore(elem, this.nextSibling);
						});
					}

					if (arguments.length) {
						var set = JQXLite.clean(arguments);
						return this.pushStack(JQXLite.merge(this, set), "after", this.selector);
					}
				},

				// keepData is for internal use only--do not document
				remove: function (selector, keepData) {
					var elem,
						i = 0;

					for (; (elem = this[i]) != null; i++) {
						if (!selector || JQXLite.filter(selector, [elem]).length) {
							if (!keepData && elem.nodeType === 1) {
								JQXLite.cleanData(elem.getElementsByTagName("*"));
								JQXLite.cleanData([elem]);
							}

							if (elem.parentNode) {
								elem.parentNode.removeChild(elem);
							}
						}
					}

					return this;
				},

				empty: function () {
					var elem,
						i = 0;

					for (; (elem = this[i]) != null; i++) {
						// Remove element nodes and prevent memory leaks
						if (elem.nodeType === 1) {
							JQXLite.cleanData(elem.getElementsByTagName("*"));
						}

						// Remove any remaining nodes
						while (elem.firstChild) {
							elem.removeChild(elem.firstChild);
						}
					}

					return this;
				},

				clone: function (dataAndEvents, deepDataAndEvents) {
					dataAndEvents = dataAndEvents == null ? false : dataAndEvents;
					deepDataAndEvents = deepDataAndEvents == null ? dataAndEvents : deepDataAndEvents;

					return this.map(function () {
						return JQXLite.clone(this, dataAndEvents, deepDataAndEvents);
					});
				},

				html: function (value) {
					return JQXLite.access(this, function (value) {
						var elem = this[0] || {},
							i = 0,
							l = this.length;

						if (value === undefined) {
							return elem.nodeType === 1 ?
								elem.innerHTML.replace(rinlinejQuery, "") :
								undefined;
						}

						// See if we can take a shortcut and just use innerHTML
						if (typeof value === "string" && !rnoInnerhtml.test(value) &&
							(JQXLite.support.htmlSerialize || !rnoshimcache.test(value)) &&
							(JQXLite.support.leadingWhitespace || !rleadingWhitespace.test(value)) &&
							!wrapMap[(rtagName.exec(value) || ["", ""])[1].toLowerCase()]) {

							value = value.replace(rxhtmlTag, "<$1></$2>");

							try {
								for (; i < l; i++) {
									// Remove element nodes and prevent memory leaks
									elem = this[i] || {};
									if (elem.nodeType === 1) {
										JQXLite.cleanData(elem.getElementsByTagName("*"));
										elem.innerHTML = value;
									}
								}

								elem = 0;

								// If using innerHTML throws an exception, use the fallback method
							} catch (e) { }
						}

						if (elem) {
							this.empty().append(value);
						}
					}, null, value, arguments.length);
				},

				replaceWith: function (value) {
					if (!isDisconnected(this[0])) {
						// Make sure that the elements are removed from the DOM before they are inserted
						// this can help fix replacing a parent with child elements
						if (JQXLite.isFunction(value)) {
							return this.each(function (i) {
								var self = JQXLite(this), old = self.html();
								self.replaceWith(value.call(this, i, old));
							});
						}

						if (typeof value !== "string") {
							value = JQXLite(value).detach();
						}

						return this.each(function () {
							var next = this.nextSibling,
								parent = this.parentNode;

							JQXLite(this).remove();

							if (next) {
								JQXLite(next).before(value);
							} else {
								JQXLite(parent).append(value);
							}
						});
					}

					return this.length ?
						this.pushStack(JQXLite(JQXLite.isFunction(value) ? value() : value), "replaceWith", value) :
						this;
				},

				detach: function (selector) {
					return this.remove(selector, true);
				},

				domManip: function (args, table, callback) {

					// Flatten any nested arrays
					args = [].concat.apply([], args);

					var results, first, fragment, iNoClone,
						i = 0,
						value = args[0],
						scripts = [],
						l = this.length;

					// We can't cloneNode fragments that contain checked, in WebKit
					if (!JQXLite.support.checkClone && l > 1 && typeof value === "string" && rchecked.test(value)) {
						return this.each(function () {
							JQXLite(this).domManip(args, table, callback);
						});
					}

					if (JQXLite.isFunction(value)) {
						return this.each(function (i) {
							var self = JQXLite(this);
							args[0] = value.call(this, i, table ? self.html() : undefined);
							self.domManip(args, table, callback);
						});
					}

					if (this[0]) {
						results = JQXLite.buildFragment(args, this, scripts);
						fragment = results.fragment;
						first = fragment.firstChild;

						if (fragment.childNodes.length === 1) {
							fragment = first;
						}

						if (first) {
							table = table && JQXLite.nodeName(first, "tr");

							// Use the original fragment for the last item instead of the first because it can end up
							// being emptied incorrectly in certain situations (#8070).
							// Fragments from the fragment cache must always be cloned and never used in place.
							for (iNoClone = results.cacheable || l - 1; i < l; i++) {
								callback.call(
									table && JQXLite.nodeName(this[i], "table") ?
										findOrAppend(this[i], "tbody") :
										this[i],
									i === iNoClone ?
										fragment :
										JQXLite.clone(fragment, true, true)
								);
							}
						}

						// Fix #11809: Avoid leaking memory
						fragment = first = null;

						if (scripts.length) {
							JQXLite.each(scripts, function (i, elem) {
								if (elem.src) {
									if (JQXLite.ajax) {
										JQXLite.ajax({
											url: elem.src,
											type: "GET",
											dataType: "script",
											async: false,
											global: false,
											"throws": true
										});
									} else {
										JQXLite.error("no ajax");
									}
								} else {
									JQXLite.globalEval((elem.text || elem.textContent || elem.innerHTML || "").replace(rcleanScript, ""));
								}

								if (elem.parentNode) {
									elem.parentNode.removeChild(elem);
								}
							});
						}
					}

					return this;
				}
			});

			function findOrAppend(elem, tag) {
				return elem.getElementsByTagName(tag)[0] || elem.appendChild(elem.ownerDocument.createElement(tag));
			}

			function cloneCopyEvent(src, dest) {

				if (dest.nodeType !== 1 || !JQXLite.hasData(src)) {
					return;
				}

				var type, i, l,
					oldData = JQXLite._data(src),
					curData = JQXLite._data(dest, oldData),
					events = oldData.events;

				if (events) {
					delete curData.handle;
					curData.events = {};

					for (type in events) {
						for (i = 0, l = events[type].length; i < l; i++) {
							JQXLite.event.add(dest, type, events[type][i]);
						}
					}
				}

				// make the cloned public data object a copy from the original
				if (curData.data) {
					curData.data = JQXLite.extend({}, curData.data);
				}
			}

			function cloneFixAttributes(src, dest) {
				var nodeName;

				// We do not need to do anything for non-Elements
				if (dest.nodeType !== 1) {
					return;
				}

				// clearAttributes removes the attributes, which we don't want,
				// but also removes the attachEvent events, which we *do* want
				if (dest.clearAttributes) {
					dest.clearAttributes();
				}

				// mergeAttributes, in contrast, only merges back on the
				// original attributes, not the events
				if (dest.mergeAttributes) {
					dest.mergeAttributes(src);
				}

				nodeName = dest.nodeName.toLowerCase();

				if (nodeName === "object") {
					// IE6-10 improperly clones children of object elements using classid.
					// IE10 throws NoModificationAllowedError if parent is null, #12132.
					if (dest.parentNode) {
						dest.outerHTML = src.outerHTML;
					}

					// This path appears unavoidable for IE9. When cloning an object
					// element in IE9, the outerHTML strategy above is not sufficient.
					// If the src has innerHTML and the destination does not,
					// copy the src.innerHTML into the dest.innerHTML. #10324
					if (JQXLite.support.html5Clone && (src.innerHTML && !JQXLite.trim(dest.innerHTML))) {
						dest.innerHTML = src.innerHTML;
					}

				} else if (nodeName === "input" && rcheckableType.test(src.type)) {
					// IE6-8 fails to persist the checked state of a cloned checkbox
					// or radio button. Worse, IE6-7 fail to give the cloned element
					// a checked appearance if the defaultChecked value isn't also set

					dest.defaultChecked = dest.checked = src.checked;

					// IE6-7 get confused and end up setting the value of a cloned
					// checkbox/radio button to an empty string instead of "on"
					if (dest.value !== src.value) {
						dest.value = src.value;
					}

					// IE6-8 fails to return the selected option to the default selected
					// state when cloning options
				} else if (nodeName === "option") {
					dest.selected = src.defaultSelected;

					// IE6-8 fails to set the defaultValue to the correct value when
					// cloning other types of input fields
				} else if (nodeName === "input" || nodeName === "textarea") {
					dest.defaultValue = src.defaultValue;

					// IE blanks contents when cloning scripts
				} else if (nodeName === "script" && dest.text !== src.text) {
					dest.text = src.text;
				}

				// Event data gets referenced instead of copied if the expando
				// gets copied too
				dest.removeAttribute(JQXLite.expando);
			}

			JQXLite.buildFragment = function (args, context, scripts) {
				var fragment, cacheable, cachehit,
					first = args[0];

				// Set context from what may come in as undefined or a JQXLite collection or a node
				// Updated to fix #12266 where accessing context[0] could throw an exception in IE9/10 &
				// also doubles as fix for #8950 where plain objects caused createDocumentFragment exception
				context = context || document;
				context = !context.nodeType && context[0] || context;
				context = context.ownerDocument || context;

				// Only cache "small" (1/2 KB) HTML strings that are associated with the main document
				// Cloning options loses the selected state, so don't cache them
				// IE 6 doesn't like it when you put <object> or <embed> elements in a fragment
				// Also, WebKit does not clone 'checked' attributes on cloneNode, so don't cache
				// Lastly, IE6,7,8 will not correctly reuse cached fragments that were created from unknown elems #10501
				if (args.length === 1 && typeof first === "string" && first.length < 512 && context === document &&
					first.charAt(0) === "<" && !rnocache.test(first) &&
					(JQXLite.support.checkClone || !rchecked.test(first)) &&
					(JQXLite.support.html5Clone || !rnoshimcache.test(first))) {

					// Mark cacheable and look for a hit
					cacheable = true;
					fragment = JQXLite.fragments[first];
					cachehit = fragment !== undefined;
				}

				if (!fragment) {
					fragment = context.createDocumentFragment();
					JQXLite.clean(args, context, fragment, scripts);

					// Update the cache, but only store false
					// unless this is a second parsing of the same content
					if (cacheable) {
						JQXLite.fragments[first] = cachehit && fragment;
					}
				}

				return { fragment: fragment, cacheable: cacheable };
			};

			JQXLite.fragments = {};

			JQXLite.each({
				appendTo: "append",
				prependTo: "prepend",
				insertBefore: "before",
				insertAfter: "after",
				replaceAll: "replaceWith"
			}, function (name, original) {
				JQXLite.fn[name] = function (selector) {
					var elems,
						i = 0,
						ret = [],
						insert = JQXLite(selector),
						l = insert.length,
						parent = this.length === 1 && this[0].parentNode;

					if ((parent == null || parent && parent.nodeType === 11 && parent.childNodes.length === 1) && l === 1) {
						insert[original](this[0]);
						return this;
					} else {
						for (; i < l; i++) {
							elems = (i > 0 ? this.clone(true) : this).get();
							JQXLite(insert[i])[original](elems);
							ret = ret.concat(elems);
						}

						return this.pushStack(ret, name, insert.selector);
					}
				};
			});

			function getAll(elem) {
				if (typeof elem.getElementsByTagName !== "undefined") {
					return elem.getElementsByTagName("*");

				} else if (typeof elem.querySelectorAll !== "undefined") {
					return elem.querySelectorAll("*");

				} else {
					return [];
				}
			}

			// Used in clean, fixes the defaultChecked property
			function fixDefaultChecked(elem) {
				if (rcheckableType.test(elem.type)) {
					elem.defaultChecked = elem.checked;
				}
			}

			JQXLite.extend({
				clone: function (elem, dataAndEvents, deepDataAndEvents) {
					var srcElements,
						destElements,
						i,
						clone;

					if (JQXLite.support.html5Clone || JQXLite.isXMLDoc(elem) || !rnoshimcache.test("<" + elem.nodeName + ">")) {
						clone = elem.cloneNode(true);

						// IE<=8 does not properly clone detached, unknown element nodes
					} else {
						fragmentDiv.innerHTML = elem.outerHTML;
						fragmentDiv.removeChild(clone = fragmentDiv.firstChild);
					}

					if ((!JQXLite.support.noCloneEvent || !JQXLite.support.noCloneChecked) &&
						(elem.nodeType === 1 || elem.nodeType === 11) && !JQXLite.isXMLDoc(elem)) {
						// IE copies events bound via attachEvent when using cloneNode.
						// Calling detachEvent on the clone will also remove the events
						// from the original. In order to get around this, we use some
						// proprietary methods to clear the events. Thanks to MooTools
						// guys for this hotness.

						cloneFixAttributes(elem, clone);

						// Using Sizzle here is crazy slow, so we use getElementsByTagName instead
						srcElements = getAll(elem);
						destElements = getAll(clone);

						// Weird iteration because IE will replace the length property
						// with an element if you are cloning the body and one of the
						// elements on the page has a name or id of "length"
						for (i = 0; srcElements[i]; ++i) {
							// Ensure that the destination node is not null; Fixes #9587
							if (destElements[i]) {
								cloneFixAttributes(srcElements[i], destElements[i]);
							}
						}
					}

					// Copy the events from the original to the clone
					if (dataAndEvents) {
						cloneCopyEvent(elem, clone);

						if (deepDataAndEvents) {
							srcElements = getAll(elem);
							destElements = getAll(clone);

							for (i = 0; srcElements[i]; ++i) {
								cloneCopyEvent(srcElements[i], destElements[i]);
							}
						}
					}

					srcElements = destElements = null;

					// Return the cloned set
					return clone;
				},

				clean: function (elems, context, fragment, scripts) {
					var i, j, elem, tag, wrap, depth, div, hasBody, tbody, len, handleScript, jsTags,
						safe = context === document && safeFragment,
						ret = [];

					// Ensure that context is a document
					if (!context || typeof context.createDocumentFragment === "undefined") {
						context = document;
					}

					// Use the already-created safe fragment if context permits
					for (i = 0; (elem = elems[i]) != null; i++) {
						if (typeof elem === "number") {
							elem += "";
						}

						if (!elem) {
							continue;
						}

						// Convert html string into DOM nodes
						if (typeof elem === "string") {
							if (!rhtml.test(elem)) {
								elem = context.createTextNode(elem);
							} else {
								// Ensure a safe container in which to render the html
								safe = safe || createSafeFragment(context);
								div = context.createElement("div");
								safe.appendChild(div);

								// Fix "XHTML"-style tags in all browsers
								elem = elem.replace(rxhtmlTag, "<$1></$2>");

								// Go to html and back, then peel off extra wrappers
								tag = (rtagName.exec(elem) || ["", ""])[1].toLowerCase();
								wrap = wrapMap[tag] || wrapMap._default;
								depth = wrap[0];
								div.innerHTML = wrap[1] + elem + wrap[2];

								// Move to the right depth
								while (depth--) {
									div = div.lastChild;
								}

								// Remove IE's autoinserted <tbody> from table fragments
								if (!JQXLite.support.tbody) {

									// String was a <table>, *may* have spurious <tbody>
									hasBody = rtbody.test(elem);
									tbody = tag === "table" && !hasBody ?
										div.firstChild && div.firstChild.childNodes :

										// String was a bare <thead> or <tfoot>
										wrap[1] === "<table>" && !hasBody ?
											div.childNodes :
											[];

									for (j = tbody.length - 1; j >= 0; --j) {
										if (JQXLite.nodeName(tbody[j], "tbody") && !tbody[j].childNodes.length) {
											tbody[j].parentNode.removeChild(tbody[j]);
										}
									}
								}

								// IE completely kills leading whitespace when innerHTML is used
								if (!JQXLite.support.leadingWhitespace && rleadingWhitespace.test(elem)) {
									div.insertBefore(context.createTextNode(rleadingWhitespace.exec(elem)[0]), div.firstChild);
								}

								elem = div.childNodes;

								// Take out of fragment container (we need a fresh div each time)
								div.parentNode.removeChild(div);
							}
						}

						if (elem.nodeType) {
							ret.push(elem);
						} else {
							JQXLite.merge(ret, elem);
						}
					}

					// Fix #11356: Clear elements from safeFragment
					if (div) {
						elem = div = safe = null;
					}

					// Reset defaultChecked for any radios and checkboxes
					// about to be appended to the DOM in IE 6/7 (#8060)
					if (!JQXLite.support.appendChecked) {
						for (i = 0; (elem = ret[i]) != null; i++) {
							if (JQXLite.nodeName(elem, "input")) {
								fixDefaultChecked(elem);
							} else if (typeof elem.getElementsByTagName !== "undefined") {
								JQXLite.grep(elem.getElementsByTagName("input"), fixDefaultChecked);
							}
						}
					}

					// Append elements to a provided document fragment
					if (fragment) {
						// Special handling of each script element
						handleScript = function (elem) {
							// Check if we consider it executable
							if (!elem.type || rscriptType.test(elem.type)) {
								// Detach the script and store it in the scripts array (if provided) or the fragment
								// Return truthy to indicate that it has been handled
								return scripts ?
									scripts.push(elem.parentNode ? elem.parentNode.removeChild(elem) : elem) :
									fragment.appendChild(elem);
							}
						};

						for (i = 0; (elem = ret[i]) != null; i++) {
							// Check if we're done after handling an executable script
							if (!(JQXLite.nodeName(elem, "script") && handleScript(elem))) {
								// Append to fragment and handle embedded scripts
								fragment.appendChild(elem);
								if (typeof elem.getElementsByTagName !== "undefined") {
									// handleScript alters the DOM, so use JQXLite.merge to ensure snapshot iteration
									jsTags = JQXLite.grep(JQXLite.merge([], elem.getElementsByTagName("script")), handleScript);

									// Splice the scripts into ret after their former ancestor and advance our index beyond them
									ret.splice.apply(ret, [i + 1, 0].concat(jsTags));
									i += jsTags.length;
								}
							}
						}
					}

					return ret;
				},

				cleanData: function (elems, /* internal */ acceptData) {
					var data, id, elem, type,
						i = 0,
						internalKey = JQXLite.expando,
						cache = JQXLite.cache,
						deleteExpando = JQXLite.support.deleteExpando,
						special = JQXLite.event.special;

					for (; (elem = elems[i]) != null; i++) {

						if (acceptData || JQXLite.acceptData(elem)) {

							id = elem[internalKey];
							data = id && cache[id];

							if (data) {
								if (data.events) {
									for (type in data.events) {
										if (special[type]) {
											JQXLite.event.remove(elem, type);

											// This is a shortcut to avoid JQXLite.event.remove's overhead
										} else {
											JQXLite.removeEvent(elem, type, data.handle);
										}
									}
								}

								// Remove cache only if it was not already removed by JQXLite.event.remove
								if (cache[id]) {

									delete cache[id];

									// IE does not allow us to delete expando properties from nodes,
									// nor does it have a removeAttribute function on Document nodes;
									// we must handle all of these cases
									if (deleteExpando) {
										delete elem[internalKey];

									} else if (elem.removeAttribute) {
										elem.removeAttribute(internalKey);

									} else {
										elem[internalKey] = null;
									}

									JQXLite.deletedIds.push(id);
								}
							}
						}
					}
				}
			});
			// Limit scope pollution from any deprecated API
			(function () {

				var matched, browser;

				// Use of JQXLite.browser is frowned upon.
				// More details: http://api.jqx.com/JQXLite.browser
				// JQXLite.uaMatch maintained for back-compat
				JQXLite.uaMatch = function (ua) {
					ua = ua.toLowerCase();

					var match = /(chrome)[ \/]([\w.]+)/.exec(ua) ||
						/(webkit)[ \/]([\w.]+)/.exec(ua) ||
						/(opera)(?:.*version|)[ \/]([\w.]+)/.exec(ua) ||
						/(msie) ([\w.]+)/.exec(ua) ||
						ua.indexOf("compatible") < 0 && /(mozilla)(?:.*? rv:([\w.]+)|)/.exec(ua) ||
						[];

					return {
						browser: match[1] || "",
						version: match[2] || "0"
					};
				};

				matched = JQXLite.uaMatch(navigator.userAgent);
				browser = {};

				if (matched.browser) {
					browser[matched.browser] = true;
					browser.version = matched.version;
				}

				// Chrome is Webkit, but Webkit is also Safari.
				if (browser.chrome) {
					browser.webkit = true;
				} else if (browser.webkit) {
					browser.safari = true;
				}

				JQXLite.browser = browser;

				JQXLite.sub = function () {
					function jQuerySub(selector, context) {
						return new jQuerySub.fn.init(selector, context);
					}
					JQXLite.extend(true, jQuerySub, this);
					jQuerySub.superclass = this;
					jQuerySub.fn = jQuerySub.prototype = this();
					jQuerySub.fn.constructor = jQuerySub;
					jQuerySub.sub = this.sub;
					jQuerySub.fn.init = function init(selector, context) {
						if (context && context instanceof JQXLite && !(context instanceof jQuerySub)) {
							context = jQuerySub(context);
						}

						return JQXLite.fn.init.call(this, selector, context, rootJQXLiteSub);
					};
					jQuerySub.fn.init.prototype = jQuerySub.fn;
					var rootJQXLiteSub = jQuerySub(document);
					return jQuerySub;
				};

			})();
			var curCSS, iframe, iframeDoc,
				ralpha = /alpha\([^)]*\)/i,
				ropacity = /opacity=([^)]*)/,
				rposition = /^(top|right|bottom|left)$/,
				// swappable if display is none or starts with table except "table", "table-cell", or "table-caption"
				// see here for display values: https://developer.mozilla.org/en-US/docs/CSS/display
				rdisplayswap = /^(none|table(?!-c[ea]).+)/,
				rmargin = /^margin/,
				rnumsplit = new RegExp("^(" + core_pnum + ")(.*)$", "i"),
				rnumnonpx = new RegExp("^(" + core_pnum + ")(?!px)[a-z%]+$", "i"),
				rrelNum = new RegExp("^([-+])=(" + core_pnum + ")", "i"),
				elemdisplay = { BODY: "block" },

				cssShow = { position: "absolute", visibility: "hidden", display: "block" },
				cssNormalTransform = {
					letterSpacing: 0,
					fontWeight: 400
				},

				cssExpand = ["Top", "Right", "Bottom", "Left"],
				cssPrefixes = ["Webkit", "O", "Moz", "ms"],

				eventsToggle = JQXLite.fn.toggle;

			// return a css property mapped to a potentially vendor prefixed property
			function vendorPropName(style, name) {

				// shortcut for names that are not vendor prefixed
				if (name in style) {
					return name;
				}

				// check for vendor prefixed names
				var capName = name.charAt(0).toUpperCase() + name.slice(1),
					origName = name,
					i = cssPrefixes.length;

				while (i--) {
					name = cssPrefixes[i] + capName;
					if (name in style) {
						return name;
					}
				}

				return origName;
			}

			function isHidden(elem, el) {
				elem = el || elem;
				return JQXLite.css(elem, "display") === "none" || !JQXLite.contains(elem.ownerDocument, elem);
			}

			function showHide(elements, show) {
				var elem, display,
					values = [],
					index = 0,
					length = elements.length;

				for (; index < length; index++) {
					elem = elements[index];
					if (!elem.style) {
						continue;
					}
					values[index] = JQXLite._data(elem, "olddisplay");
					if (show) {
						// Reset the inline display of this element to learn if it is
						// being hidden by cascaded rules or not
						if (!values[index] && elem.style.display === "none") {
							elem.style.display = "";
						}

						// Set elements which have been overridden with display: none
						// in a stylesheet to whatever the default browser style is
						// for such an element
						if (elem.style.display === "" && isHidden(elem)) {
							values[index] = JQXLite._data(elem, "olddisplay", css_defaultDisplay(elem.nodeName));
						}
					} else {
						display = curCSS(elem, "display");

						if (!values[index] && display !== "none") {
							JQXLite._data(elem, "olddisplay", display);
						}
					}
				}

				// Set the display of most of the elements in a second loop
				// to avoid the constant reflow
				for (index = 0; index < length; index++) {
					elem = elements[index];
					if (!elem.style) {
						continue;
					}
					if (!show || elem.style.display === "none" || elem.style.display === "") {
						elem.style.display = show ? values[index] || "" : "none";
					}
				}

				return elements;
			}

			JQXLite.fn.extend({
				css: function (name, value) {
					return JQXLite.access(this, function (elem, name, value) {
						return value !== undefined ?
							JQXLite.style(elem, name, value) :
							JQXLite.css(elem, name);
					}, name, value, arguments.length > 1);
				},
				show: function () {
					return showHide(this, true);
				},
				hide: function () {
					return showHide(this);
				},
				toggle: function (state, fn2) {
					var bool = typeof state === "boolean";

					if (JQXLite.isFunction(state) && JQXLite.isFunction(fn2)) {
						return eventsToggle.apply(this, arguments);
					}

					return this.each(function () {
						if (bool ? state : isHidden(this)) {
							JQXLite(this).show();
						} else {
							JQXLite(this).hide();
						}
					});
				}
			});

			JQXLite.extend({
				// Add in style property hooks for overriding the default
				// behavior of getting and setting a style property
				cssHooks: {
					opacity: {
						get: function (elem, computed) {
							if (computed) {
								// We should always get a number back from opacity
								var ret = curCSS(elem, "opacity");
								return ret === "" ? "1" : ret;

							}
						}
					}
				},

				// Exclude the following css properties to add px
				cssNumber: {
					"fillOpacity": true,
					"fontWeight": true,
					"lineHeight": true,
					"opacity": true,
					"orphans": true,
					"widows": true,
					"zIndex": true,
					"zoom": true
				},

				// Add in properties whose names you wish to fix before
				// setting or getting the value
				cssProps: {
					// normalize float css property
					"float": JQXLite.support.cssFloat ? "cssFloat" : "styleFloat"
				},

				// Get and set the style property on a DOM Node
				style: function (elem, name, value, extra) {
					// Don't set styles on text and comment nodes
					if (!elem || elem.nodeType === 3 || elem.nodeType === 8 || !elem.style) {
						return;
					}

					// Make sure that we're working with the right name
					var ret, type, hooks,
						origName = JQXLite.camelCase(name),
						style = elem.style;

					name = JQXLite.cssProps[origName] || (JQXLite.cssProps[origName] = vendorPropName(style, origName));

					// gets hook for the prefixed version
					// followed by the unprefixed version
					hooks = JQXLite.cssHooks[name] || JQXLite.cssHooks[origName];

					// Check if we're setting a value
					if (value !== undefined) {
						type = typeof value;

						// convert relative number strings (+= or -=) to relative numbers. #7345
						if (type === "string" && (ret = rrelNum.exec(value))) {
							value = (ret[1] + 1) * ret[2] + parseFloat(JQXLite.css(elem, name));
							// Fixes bug #9237
							type = "number";
						}

						// Make sure that NaN and null values aren't set. See: #7116
						if (value == null || type === "number" && isNaN(value)) {
							return;
						}

						// If a number was passed in, add 'px' to the (except for certain CSS properties)
						if (type === "number" && !JQXLite.cssNumber[origName]) {
							value += "px";
						}

						// If a hook was provided, use that value, otherwise just set the specified value
						if (!hooks || !("set" in hooks) || (value = hooks.set(elem, value, extra)) !== undefined) {
							// Wrapped to prevent IE from throwing errors when 'invalid' values are provided
							// Fixes bug #5509
							try {
								style[name] = value;
							} catch (e) { }
						}

					} else {
						// If a hook was provided get the non-computed value from there
						if (hooks && "get" in hooks && (ret = hooks.get(elem, false, extra)) !== undefined) {
							return ret;
						}

						// Otherwise just get the value from the style object
						return style[name];
					}
				},

				css: function (elem, name, numeric, extra) {
					var val, num, hooks,
						origName = JQXLite.camelCase(name);

					// Make sure that we're working with the right name
					name = JQXLite.cssProps[origName] || (JQXLite.cssProps[origName] = vendorPropName(elem.style, origName));

					// gets hook for the prefixed version
					// followed by the unprefixed version
					hooks = JQXLite.cssHooks[name] || JQXLite.cssHooks[origName];

					// If a hook was provided get the computed value from there
					if (hooks && "get" in hooks) {
						val = hooks.get(elem, true, extra);
					}

					// Otherwise, if a way to get the computed value exists, use that
					if (val === undefined) {
						val = curCSS(elem, name);
					}

					//convert "normal" to computed value
					if (val === "normal" && name in cssNormalTransform) {
						val = cssNormalTransform[name];
					}

					// Return, converting to number if forced or a qualifier was provided and val looks numeric
					if (numeric || extra !== undefined) {
						num = parseFloat(val);
						return numeric || JQXLite.isNumeric(num) ? num || 0 : val;
					}
					return val;
				},

				// A method for quickly swapping in/out CSS properties to get correct calculations
				swap: function (elem, options, callback) {
					var ret, name,
						old = {};

					// Remember the old values, and insert the new ones
					for (name in options) {
						old[name] = elem.style[name];
						elem.style[name] = options[name];
					}

					ret = callback.call(elem);

					// Revert the old values
					for (name in options) {
						elem.style[name] = old[name];
					}

					return ret;
				}
			});

			// NOTE: To any future maintainer, we've window.getComputedStyle
			// because jsdom on node.js will break without it.
			if (window.getComputedStyle) {
				curCSS = function (elem, name) {
					var ret, width, minWidth, maxWidth,
						computed = window.getComputedStyle(elem, null),
						style = elem.style;

					if (computed) {

						// getPropertyValue is only needed for .css('filter') in IE9, see #12537
						ret = computed.getPropertyValue(name) || computed[name];

						if (ret === "" && !JQXLite.contains(elem.ownerDocument, elem)) {
							ret = JQXLite.style(elem, name);
						}

						// A tribute to the "awesome hack by Dean Edwards"
						// Chrome < 17 and Safari 5.0 uses "computed value" instead of "used value" for margin-right
						// Safari 5.1.7 (at least) returns percentage for a larger set of values, but width seems to be reliably pixels
						// this is against the CSSOM draft spec: http://dev.w3.org/csswg/cssom/#resolved-values
						if (rnumnonpx.test(ret) && rmargin.test(name)) {
							width = style.width;
							minWidth = style.minWidth;
							maxWidth = style.maxWidth;

							style.minWidth = style.maxWidth = style.width = ret;
							ret = computed.width;

							style.width = width;
							style.minWidth = minWidth;
							style.maxWidth = maxWidth;
						}
					}

					return ret;
				};
			} else if (document.documentElement.currentStyle) {
				curCSS = function (elem, name) {
					var left, rsLeft,
						ret = elem.currentStyle && elem.currentStyle[name],
						style = elem.style;

					// Avoid setting ret to empty string here
					// so we don't default to auto
					if (ret == null && style && style[name]) {
						ret = style[name];
					}

					// From the awesome hack by Dean Edwards
					// http://erik.eae.net/archives/2007/07/27/18.54.15/#comment-102291

					// If we're not dealing with a regular pixel number
					// but a number that has a weird ending, we need to convert it to pixels
					// but not position css attributes, as those are proportional to the parent element instead
					// and we can't measure the parent instead because it might trigger a "stacking dolls" problem
					if (rnumnonpx.test(ret) && !rposition.test(name)) {

						// Remember the original values
						left = style.left;
						rsLeft = elem.runtimeStyle && elem.runtimeStyle.left;

						// Put in the new values to get a computed value out
						if (rsLeft) {
							elem.runtimeStyle.left = elem.currentStyle.left;
						}
						style.left = name === "fontSize" ? "1em" : ret;
						ret = style.pixelLeft + "px";

						// Revert the changed values
						style.left = left;
						if (rsLeft) {
							elem.runtimeStyle.left = rsLeft;
						}
					}

					return ret === "" ? "auto" : ret;
				};
			}

			function setPositiveNumber(elem, value, subtract) {
				var matches = rnumsplit.exec(value);
				return matches ?
					Math.max(0, matches[1] - (subtract || 0)) + (matches[2] || "px") :
					value;
			}

			function augmentWidthOrHeight(elem, name, extra, isBorderBox) {
				var i = extra === (isBorderBox ? "border" : "content") ?
					// If we already have the right measurement, avoid augmentation
					4 :
					// Otherwise initialize for horizontal or vertical properties
					name === "width" ? 1 : 0,

					val = 0;

				for (; i < 4; i += 2) {
					// both box models exclude margin, so add it if we want it
					if (extra === "margin") {
						// we use JQXLite.css instead of curCSS here
						// because of the reliableMarginRight CSS hook!
						val += JQXLite.css(elem, extra + cssExpand[i], true);
					}

					// From this point on we use curCSS for maximum performance (relevant in animations)
					if (isBorderBox) {
						// border-box includes padding, so remove it if we want content
						if (extra === "content") {
							val -= parseFloat(curCSS(elem, "padding" + cssExpand[i])) || 0;
						}

						// at this point, extra isn't border nor margin, so remove border
						if (extra !== "margin") {
							val -= parseFloat(curCSS(elem, "border" + cssExpand[i] + "Width")) || 0;
						}
					} else {
						// at this point, extra isn't content, so add padding
						val += parseFloat(curCSS(elem, "padding" + cssExpand[i])) || 0;

						// at this point, extra isn't content nor padding, so add border
						if (extra !== "padding") {
							val += parseFloat(curCSS(elem, "border" + cssExpand[i] + "Width")) || 0;
						}
					}
				}

				return val;
			}

			function getWidthOrHeight(elem, name, extra) {

				// Start with offset property, which is equivalent to the border-box value
				var val = name === "width" ? elem.offsetWidth : elem.offsetHeight,
					valueIsBorderBox = true,
					isBorderBox = JQXLite.support.boxSizing && JQXLite.css(elem, "boxSizing") === "border-box";

				// some non-html elements return undefined for offsetWidth, so check for null/undefined
				// svg - https://bugzilla.mozilla.org/show_bug.cgi?id=649285
				// MathML - https://bugzilla.mozilla.org/show_bug.cgi?id=491668
				if (val <= 0 || val == null) {
					// Fall back to computed then uncomputed css if necessary
					val = curCSS(elem, name);
					if (val < 0 || val == null) {
						val = elem.style[name];
					}

					// Computed unit is not pixels. Stop here and return.
					if (rnumnonpx.test(val)) {
						return val;
					}

					// we need the check for style in case a browser which returns unreliable values
					// for getComputedStyle silently falls back to the reliable elem.style
					valueIsBorderBox = isBorderBox && (JQXLite.support.boxSizingReliable || val === elem.style[name]);

					// Normalize "", auto, and prepare for extra
					val = parseFloat(val) || 0;
				}

				// use the active box-sizing model to add/subtract irrelevant styles
				return (val +
					augmentWidthOrHeight(
						elem,
						name,
						extra || (isBorderBox ? "border" : "content"),
						valueIsBorderBox
					)
				) + "px";
			}


			// Try to determine the default display value of an element
			function css_defaultDisplay(nodeName) {
				if (elemdisplay[nodeName]) {
					return elemdisplay[nodeName];
				}

				var elem = JQXLite("<" + nodeName + ">").appendTo(document.body),
					display = elem.css("display");
				elem.remove();

				// If the simple way fails,
				// get element's real default display by attaching it to a temp iframe
				if (display === "none" || display === "") {
					// Use the already-created iframe if possible
					iframe = document.body.appendChild(
						iframe || JQXLite.extend(document.createElement("iframe"), {
							frameBorder: 0,
							width: 0,
							height: 0
						})
					);

					// Create a cacheable copy of the iframe document on first call.
					// IE and Opera will allow us to reuse the iframeDoc without re-writing the fake HTML
					// document to it; WebKit & Firefox won't allow reusing the iframe document.
					if (!iframeDoc || !iframe.createElement) {
						iframeDoc = (iframe.contentWindow || iframe.contentDocument).document;
						iframeDoc.write("<!doctype html><html><body>");
						iframeDoc.close();
					}

					elem = iframeDoc.body.appendChild(iframeDoc.createElement(nodeName));

					display = curCSS(elem, "display");
					document.body.removeChild(iframe);
				}

				// Store the correct default display
				elemdisplay[nodeName] = display;

				return display;
			}

			JQXLite.each(["height", "width"], function (i, name) {
				JQXLite.cssHooks[name] = {
					get: function (elem, computed, extra) {
						if (computed) {
							// certain elements can have dimension info if we invisibly show them
							// however, it must have a current display style that would benefit from this
							if (elem.offsetWidth === 0 && rdisplayswap.test(curCSS(elem, "display"))) {
								return JQXLite.swap(elem, cssShow, function () {
									return getWidthOrHeight(elem, name, extra);
								});
							} else {
								return getWidthOrHeight(elem, name, extra);
							}
						}
					},

					set: function (elem, value, extra) {
						return setPositiveNumber(elem, value, extra ?
							augmentWidthOrHeight(
								elem,
								name,
								extra,
								JQXLite.support.boxSizing && JQXLite.css(elem, "boxSizing") === "border-box"
							) : 0
						);
					}
				};
			});

			if (!JQXLite.support.opacity) {
				JQXLite.cssHooks.opacity = {
					get: function (elem, computed) {
						// IE uses filters for opacity
						return ropacity.test((computed && elem.currentStyle ? elem.currentStyle.filter : elem.style.filter) || "") ?
							(0.01 * parseFloat(RegExp.$1)) + "" :
							computed ? "1" : "";
					},

					set: function (elem, value) {
						var style = elem.style,
							currentStyle = elem.currentStyle,
							opacity = JQXLite.isNumeric(value) ? "alpha(opacity=" + value * 100 + ")" : "",
							filter = currentStyle && currentStyle.filter || style.filter || "";

						// IE has trouble with opacity if it does not have layout
						// Force it by setting the zoom level
						style.zoom = 1;

						// if setting opacity to 1, and no other filters exist - attempt to remove filter attribute #6652
						if (value >= 1 && JQXLite.trim(filter.replace(ralpha, "")) === "" &&
							style.removeAttribute) {

							// Setting style.filter to null, "" & " " still leave "filter:" in the cssText
							// if "filter:" is present at all, clearType is disabled, we want to avoid this
							// style.removeAttribute is IE Only, but so apparently is this code path...
							style.removeAttribute("filter");

							// if there there is no filter style applied in a css rule, we are done
							if (currentStyle && !currentStyle.filter) {
								return;
							}
						}

						// otherwise, set new filter values
						style.filter = ralpha.test(filter) ?
							filter.replace(ralpha, opacity) :
							filter + " " + opacity;
					}
				};
			}

			// These hooks cannot be added until DOM ready because the support test
			// for it is not run until after DOM ready
			JQXLite(function () {
				if (!JQXLite.support.reliableMarginRight) {
					JQXLite.cssHooks.marginRight = {
						get: function (elem, computed) {
							// WebKit Bug 13343 - getComputedStyle returns wrong value for margin-right
							// Work around by temporarily setting element display to inline-block
							return JQXLite.swap(elem, { "display": "inline-block" }, function () {
								if (computed) {
									return curCSS(elem, "marginRight");
								}
							});
						}
					};
				}

				// Webkit bug: https://bugs.webkit.org/show_bug.cgi?id=29084
				// getComputedStyle returns percent when specified for top/left/bottom/right
				// rather than make the css module depend on the offset module, we just check for it here
				if (!JQXLite.support.pixelPosition && JQXLite.fn.position) {
					JQXLite.each(["top", "left"], function (i, prop) {
						JQXLite.cssHooks[prop] = {
							get: function (elem, computed) {
								if (computed) {
									var ret = curCSS(elem, prop);
									// if curCSS returns percentage, fallback to offset
									return rnumnonpx.test(ret) ? JQXLite(elem).position()[prop] + "px" : ret;
								}
							}
						};
					});
				}

			});

			if (JQXLite.expr && JQXLite.expr.filters) {
				JQXLite.expr.filters.hidden = function (elem) {
					return (elem.offsetWidth === 0 && elem.offsetHeight === 0) || (!JQXLite.support.reliableHiddenOffsets && ((elem.style && elem.style.display) || curCSS(elem, "display")) === "none");
				};

				JQXLite.expr.filters.visible = function (elem) {
					return !JQXLite.expr.filters.hidden(elem);
				};
			}

			// These hooks are used by animate to expand properties
			JQXLite.each({
				margin: "",
				padding: "",
				border: "Width"
			}, function (prefix, suffix) {
				JQXLite.cssHooks[prefix + suffix] = {
					expand: function (value) {
						var i,

							// assumes a single number if not a string
							parts = typeof value === "string" ? value.split(" ") : [value],
							expanded = {};

						for (i = 0; i < 4; i++) {
							expanded[prefix + cssExpand[i] + suffix] =
								parts[i] || parts[i - 2] || parts[0];
						}

						return expanded;
					}
				};

				if (!rmargin.test(prefix)) {
					JQXLite.cssHooks[prefix + suffix].set = setPositiveNumber;
				}
			});
			var r20 = /%20/g,
				rbracket = /\[\]$/,
				rCRLF = /\r?\n/g,
				rinput = /^(?:color|date|datetime|datetime-local|email|hidden|month|number|password|range|search|tel|text|time|url|week)$/i,
				rselectTextarea = /^(?:select|textarea)/i;

			JQXLite.fn.extend({
				serialize: function () {
					return JQXLite.param(this.serializeArray());
				},
				serializeArray: function () {
					return this.map(function () {
						return this.elements ? JQXLite.makeArray(this.elements) : this;
					})
						.filter(function () {
							return this.name && !this.disabled &&
								(this.checked || rselectTextarea.test(this.nodeName) ||
									rinput.test(this.type));
						})
						.map(function (i, elem) {
							var val = JQXLite(this).val();

							return val == null ?
								null :
								JQXLite.isArray(val) ?
									JQXLite.map(val, function (val, i) {
										return { name: elem.name, value: val.replace(rCRLF, "\r\n") };
									}) :
									{ name: elem.name, value: val.replace(rCRLF, "\r\n") };
						}).get();
				}
			});

			//Serialize an array of form elements or a set of
			//key/values into a query string
			JQXLite.param = function (a, traditional) {
				var prefix,
					s = [],
					add = function (key, value) {
						// If value is a function, invoke it and return its value
						value = JQXLite.isFunction(value) ? value() : (value == null ? "" : value);
						s[s.length] = encodeURIComponent(key) + "=" + encodeURIComponent(value);
					};

				// Set traditional to true for JQXLite <= 1.3.2 behavior.
				if (traditional === undefined) {
					traditional = JQXLite.ajaxSettings && JQXLite.ajaxSettings.traditional;
				}

				// If an array was passed in, assume that it is an array of form elements.
				if (JQXLite.isArray(a) || (a.jqx && !JQXLite.isPlainObject(a))) {
					// Serialize the form elements
					JQXLite.each(a, function () {
						add(this.name, this.value);
					});

				} else {
					// If traditional, encode the "old" way (the way 1.3.2 or older
					// did it), otherwise encode params recursively.
					for (prefix in a) {
						buildParams(prefix, a[prefix], traditional, add);
					}
				}

				// Return the resulting serialization
				return s.join("&").replace(r20, "+");
			};

			function buildParams(prefix, obj, traditional, add) {
				var name;

				if (JQXLite.isArray(obj)) {
					// Serialize array item.
					JQXLite.each(obj, function (i, v) {
						if (traditional || rbracket.test(prefix)) {
							// Treat each array item as a scalar.
							add(prefix, v);

						} else {
							// If array item is non-scalar (array or object), encode its
							// numeric index to resolve deserialization ambiguity issues.
							// Note that rack (as of 1.0.0) can't currently deserialize
							// nested arrays properly, and attempting to do so may cause
							// a server error. Possible fixes are to modify rack's
							// deserialization algorithm or to provide an option or flag
							// to force array serialization to be shallow.
							buildParams(prefix + "[" + (typeof v === "object" ? i : "") + "]", v, traditional, add);
						}
					});

				} else if (!traditional && JQXLite.type(obj) === "object") {
					// Serialize object item.
					for (name in obj) {
						buildParams(prefix + "[" + name + "]", obj[name], traditional, add);
					}

				} else {
					// Serialize scalar item.
					add(prefix, obj);
				}
			}


			// Create transport if the browser can provide an xhr
			if (JQXLite.support.ajax) {

				JQXLite.ajaxTransport(function (s) {
					// Cross domain only allowed if supported through XMLHttpRequest
					if (!s.crossDomain || JQXLite.support.cors) {

						var callback;

						return {
							send: function (headers, complete) {

								// Get a new xhr
								var handle, i,
									xhr = s.xhr();

								// Open the socket
								// Passing null username, generates a login popup on Opera (#2865)
								if (s.username) {
									xhr.open(s.type, s.url, s.async, s.username, s.password);
								} else {
									xhr.open(s.type, s.url, s.async);
								}

								// Apply custom fields if provided
								if (s.xhrFields) {
									for (i in s.xhrFields) {
										xhr[i] = s.xhrFields[i];
									}
								}

								// Override mime type if needed
								if (s.mimeType && xhr.overrideMimeType) {
									xhr.overrideMimeType(s.mimeType);
								}

								// X-Requested-With header
								// For cross-domain requests, seeing as conditions for a preflight are
								// akin to a jigsaw puzzle, we simply never set it to be sure.
								// (it can always be set on a per-request basis or even using ajaxSetup)
								// For same-domain requests, won't change header if already provided.
								if (!s.crossDomain && !headers["X-Requested-With"]) {
									headers["X-Requested-With"] = "XMLHttpRequest";
								}

								// Need an extra try/catch for cross domain requests in Firefox 3
								try {
									for (i in headers) {
										xhr.setRequestHeader(i, headers[i]);
									}
								} catch (_) { }

								// Do send the request
								// This may raise an exception which is actually
								// handled in JQXLite.ajax (so no try/catch here)
								xhr.send((s.hasContent && s.data) || null);

								// Listener
								callback = function (_, isAbort) {

									var status,
										statusText,
										responseHeaders,
										responses,
										xml;

									// Firefox throws exceptions when accessing properties
									// of an xhr when a network error occurred
									// http://helpful.knobs-dials.com/index.php/Component_returned_failure_code:_0x80040111_(NS_ERROR_NOT_AVAILABLE)
									try {

										// Was never called and is aborted or complete
										if (callback && (isAbort || xhr.readyState === 4)) {

											// Only called once
											callback = undefined;

											// Do not keep as active anymore
											if (handle) {
												xhr.onreadystatechange = JQXLite.noop;
												if (xhrOnUnloadAbort) {
													delete xhrCallbacks[handle];
												}
											}

											// If it's an abort
											if (isAbort) {
												// Abort it manually if needed
												if (xhr.readyState !== 4) {
													xhr.abort();
												}
											} else {
												status = xhr.status;
												responseHeaders = xhr.getAllResponseHeaders();
												responses = {};
												xml = xhr.responseXML;

												// Construct response list
												if (xml && xml.documentElement /* #4958 */) {
													responses.xml = xml;
												}

												// When requesting binary data, IE6-9 will throw an exception
												// on any attempt to access responseText (#11426)
												try {
													responses.text = xhr.responseText;
												} catch (e) {
												}

												// Firefox throws an exception when accessing
												// statusText for faulty cross-domain requests
												try {
													statusText = xhr.statusText;
												} catch (e) {
													// We normalize with Webkit giving an empty statusText
													statusText = "";
												}

												// Filter status for non standard behaviors

												// If the request is local and we have data: assume a success
												// (success with no data won't get notified, that's the best we
												// can do given current implementations)
												if (!status && s.isLocal && !s.crossDomain) {
													status = responses.text ? 200 : 404;
													// IE - #1450: sometimes returns 1223 when it should be 204
												} else if (status === 1223) {
													status = 204;
												}
											}
										}
									} catch (firefoxAccessException) {
										if (!isAbort) {
											complete(-1, firefoxAccessException);
										}
									}

									// Call complete if needed
									if (responses) {
										complete(status, statusText, responses, responseHeaders);
									}
								};

								if (!s.async) {
									// if we're in sync mode we fire the callback
									callback();
								} else if (xhr.readyState === 4) {
									// (IE6 & IE7) if it's in cache and has been
									// retrieved directly we need to fire the callback
									setTimeout(callback, 0);
								} else {
									handle = ++xhrId;
									if (xhrOnUnloadAbort) {
										// Create the active xhrs callbacks list if needed
										// and attach the unload handler
										if (!xhrCallbacks) {
											xhrCallbacks = {};
											JQXLite(window).unload(xhrOnUnloadAbort);
										}
										// Add to list of active xhrs callbacks
										xhrCallbacks[handle] = callback;
									}
									xhr.onreadystatechange = callback;
								}
							},

							abort: function () {
								if (callback) {
									callback(0, 1);
								}
							}
						};
					}
				});
			}
			var fxNow, timerId,
				rfxtypes = /^(?:toggle|show|hide)$/,
				rfxnum = new RegExp("^(?:([-+])=|)(" + core_pnum + ")([a-z%]*)$", "i"),
				rrun = /queueHooks$/,
				animationPrefilters = [defaultPrefilter],
				tweeners = {
					"*": [function (prop, value) {
						var end, unit,
							tween = this.createTween(prop, value),
							parts = rfxnum.exec(value),
							target = tween.cur(),
							start = +target || 0,
							scale = 1,
							maxIterations = 20;

						if (parts) {
							end = +parts[2];
							unit = parts[3] || (JQXLite.cssNumber[prop] ? "" : "px");

							// We need to compute starting value
							if (unit !== "px" && start) {
								// Iteratively approximate from a nonzero starting point
								// Prefer the current property, because this process will be trivial if it uses the same units
								// Fallback to end or a simple constant
								start = JQXLite.css(tween.elem, prop, true) || end || 1;

								do {
									// If previous iteration zeroed out, double until we get *something*
									// Use a string for doubling factor so we don't accidentally see scale as unchanged below
									scale = scale || ".5";

									// Adjust and apply
									start = start / scale;
									JQXLite.style(tween.elem, prop, start + unit);

									// Update scale, tolerating zero or NaN from tween.cur()
									// And breaking the loop if scale is unchanged or perfect, or if we've just had enough
								} while (scale !== (scale = tween.cur() / target) && scale !== 1 && --maxIterations);
							}

							tween.unit = unit;
							tween.start = start;
							// If a +=/-= token was provided, we're doing a relative animation
							tween.end = parts[1] ? start + (parts[1] + 1) * end : end;
						}
						return tween;
					}]
				};

			// Animations created synchronously will run synchronously
			function createFxNow() {
				setTimeout(function () {
					fxNow = undefined;
				}, 0);
				return (fxNow = JQXLite.now());
			}

			function createTweens(animation, props) {
				JQXLite.each(props, function (prop, value) {
					var collection = (tweeners[prop] || []).concat(tweeners["*"]),
						index = 0,
						length = collection.length;
					for (; index < length; index++) {
						if (collection[index].call(animation, prop, value)) {

							// we're done with this property
							return;
						}
					}
				});
			}

			function Animation(elem, properties, options) {
				var result,
					index = 0,
					tweenerIndex = 0,
					length = animationPrefilters.length,
					deferred = JQXLite.Deferred().always(function () {
						// don't match elem in the :animated selector
						delete tick.elem;
					}),
					tick = function () {
						var currentTime = fxNow || createFxNow(),
							remaining = Math.max(0, animation.startTime + animation.duration - currentTime),
							// archaic crash bug won't allow us to use 1 - ( 0.5 || 0 ) (#12497)
							temp = remaining / animation.duration || 0,
							percent = 1 - temp,
							index = 0,
							length = animation.tweens.length;

						for (; index < length; index++) {
							animation.tweens[index].run(percent);
						}

						deferred.notifyWith(elem, [animation, percent, remaining]);

						if (percent < 1 && length) {
							return remaining;
						} else {
							deferred.resolveWith(elem, [animation]);
							return false;
						}
					},
					animation = deferred.promise({
						elem: elem,
						props: JQXLite.extend({}, properties),
						opts: JQXLite.extend(true, { specialEasing: {} }, options),
						originalProperties: properties,
						originalOptions: options,
						startTime: fxNow || createFxNow(),
						duration: options.duration,
						tweens: [],
						createTween: function (prop, end, easing) {
							var tween = JQXLite.Tween(elem, animation.opts, prop, end,
								animation.opts.specialEasing[prop] || animation.opts.easing);
							animation.tweens.push(tween);
							return tween;
						},
						stop: function (gotoEnd) {
							var index = 0,
								// if we are going to the end, we want to run all the tweens
								// otherwise we skip this part
								length = gotoEnd ? animation.tweens.length : 0;

							for (; index < length; index++) {
								animation.tweens[index].run(1);
							}

							// resolve when we played the last frame
							// otherwise, reject
							if (gotoEnd) {
								deferred.resolveWith(elem, [animation, gotoEnd]);
							} else {
								deferred.rejectWith(elem, [animation, gotoEnd]);
							}
							return this;
						}
					}),
					props = animation.props;

				propFilter(props, animation.opts.specialEasing);

				for (; index < length; index++) {
					result = animationPrefilters[index].call(animation, elem, props, animation.opts);
					if (result) {
						return result;
					}
				}

				createTweens(animation, props);

				if (JQXLite.isFunction(animation.opts.start)) {
					animation.opts.start.call(elem, animation);
				}

				JQXLite.fx.timer(
					JQXLite.extend(tick, {
						anim: animation,
						queue: animation.opts.queue,
						elem: elem
					})
				);

				// attach callbacks from options
				return animation.progress(animation.opts.progress)
					.done(animation.opts.done, animation.opts.complete)
					.fail(animation.opts.fail)
					.always(animation.opts.always);
			}

			function propFilter(props, specialEasing) {
				var index, name, easing, value, hooks;

				// camelCase, specialEasing and expand cssHook pass
				for (index in props) {
					name = JQXLite.camelCase(index);
					easing = specialEasing[name];
					value = props[index];
					if (JQXLite.isArray(value)) {
						easing = value[1];
						value = props[index] = value[0];
					}

					if (index !== name) {
						props[name] = value;
						delete props[index];
					}

					hooks = JQXLite.cssHooks[name];
					if (hooks && "expand" in hooks) {
						value = hooks.expand(value);
						delete props[name];

						// not quite $.extend, this wont overwrite keys already present.
						// also - reusing 'index' from above because we have the correct "name"
						for (index in value) {
							if (!(index in props)) {
								props[index] = value[index];
								specialEasing[index] = easing;
							}
						}
					} else {
						specialEasing[name] = easing;
					}
				}
			}

			JQXLite.Animation = JQXLite.extend(Animation, {

				tweener: function (props, callback) {
					if (JQXLite.isFunction(props)) {
						callback = props;
						props = ["*"];
					} else {
						props = props.split(" ");
					}

					var prop,
						index = 0,
						length = props.length;

					for (; index < length; index++) {
						prop = props[index];
						tweeners[prop] = tweeners[prop] || [];
						tweeners[prop].unshift(callback);
					}
				},

				prefilter: function (callback, prepend) {
					if (prepend) {
						animationPrefilters.unshift(callback);
					} else {
						animationPrefilters.push(callback);
					}
				}
			});

			function defaultPrefilter(elem, props, opts) {
				var index, prop, value, length, dataShow, toggle, tween, hooks, oldfire,
					anim = this,
					style = elem.style,
					orig = {},
					handled = [],
					hidden = elem.nodeType && isHidden(elem);

				// handle queue: false promises
				if (!opts.queue) {
					hooks = JQXLite._queueHooks(elem, "fx");
					if (hooks.unqueued == null) {
						hooks.unqueued = 0;
						oldfire = hooks.empty.fire;
						hooks.empty.fire = function () {
							if (!hooks.unqueued) {
								oldfire();
							}
						};
					}
					hooks.unqueued++;

					anim.always(function () {
						// doing this makes sure that the complete handler will be called
						// before this completes
						anim.always(function () {
							hooks.unqueued--;
							if (!JQXLite.queue(elem, "fx").length) {
								hooks.empty.fire();
							}
						});
					});
				}

				// height/width overflow pass
				if (elem.nodeType === 1 && ("height" in props || "width" in props)) {
					// Make sure that nothing sneaks out
					// Record all 3 overflow attributes because IE does not
					// change the overflow attribute when overflowX and
					// overflowY are set to the same value
					opts.overflow = [style.overflow, style.overflowX, style.overflowY];

					// Set display property to inline-block for height/width
					// animations on inline elements that are having width/height animated
					if (JQXLite.css(elem, "display") === "inline" &&
						JQXLite.css(elem, "float") === "none") {

						// inline-level elements accept inline-block;
						// block-level elements need to be inline with layout
						if (!JQXLite.support.inlineBlockNeedsLayout || css_defaultDisplay(elem.nodeName) === "inline") {
							style.display = "inline-block";

						} else {
							style.zoom = 1;
						}
					}
				}

				if (opts.overflow) {
					style.overflow = "hidden";
					if (!JQXLite.support.shrinkWrapBlocks) {
						anim.done(function () {
							style.overflow = opts.overflow[0];
							style.overflowX = opts.overflow[1];
							style.overflowY = opts.overflow[2];
						});
					}
				}


				// show/hide pass
				for (index in props) {
					value = props[index];
					if (rfxtypes.exec(value)) {
						delete props[index];
						toggle = toggle || value === "toggle";
						if (value === (hidden ? "hide" : "show")) {
							continue;
						}
						handled.push(index);
					}
				}

				length = handled.length;
				if (length) {
					dataShow = JQXLite._data(elem, "fxshow") || JQXLite._data(elem, "fxshow", {});
					if ("hidden" in dataShow) {
						hidden = dataShow.hidden;
					}

					// store state if its toggle - enables .stop().toggle() to "reverse"
					if (toggle) {
						dataShow.hidden = !hidden;
					}
					if (hidden) {
						JQXLite(elem).show();
					} else {
						anim.done(function () {
							JQXLite(elem).hide();
						});
					}
					anim.done(function () {
						var prop;
						JQXLite.removeData(elem, "fxshow", true);
						for (prop in orig) {
							JQXLite.style(elem, prop, orig[prop]);
						}
					});
					for (index = 0; index < length; index++) {
						prop = handled[index];
						tween = anim.createTween(prop, hidden ? dataShow[prop] : 0);
						orig[prop] = dataShow[prop] || JQXLite.style(elem, prop);

						if (!(prop in dataShow)) {
							dataShow[prop] = tween.start;
							if (hidden) {
								tween.end = tween.start;
								tween.start = prop === "width" || prop === "height" ? 1 : 0;
							}
						}
					}
				}
			}

			function Tween(elem, options, prop, end, easing) {
				return new Tween.prototype.init(elem, options, prop, end, easing);
			}
			JQXLite.Tween = Tween;

			Tween.prototype = {
				constructor: Tween,
				init: function (elem, options, prop, end, easing, unit) {
					this.elem = elem;
					this.prop = prop;
					this.easing = easing || "swing";
					this.options = options;
					this.start = this.now = this.cur();
					this.end = end;
					this.unit = unit || (JQXLite.cssNumber[prop] ? "" : "px");
				},
				cur: function () {
					var hooks = Tween.propHooks[this.prop];

					return hooks && hooks.get ?
						hooks.get(this) :
						Tween.propHooks._default.get(this);
				},
				run: function (percent) {
					var eased,
						hooks = Tween.propHooks[this.prop];

					if (this.options.duration) {
						this.pos = eased = JQXLite.easing[this.easing](
							percent, this.options.duration * percent, 0, 1, this.options.duration
						);
					} else {
						this.pos = eased = percent;
					}
					this.now = (this.end - this.start) * eased + this.start;

					if (this.options.step) {
						this.options.step.call(this.elem, this.now, this);
					}

					if (hooks && hooks.set) {
						hooks.set(this);
					} else {
						Tween.propHooks._default.set(this);
					}
					return this;
				}
			};

			Tween.prototype.init.prototype = Tween.prototype;

			Tween.propHooks = {
				_default: {
					get: function (tween) {
						var result;

						if (tween.elem[tween.prop] != null &&
							(!tween.elem.style || tween.elem.style[tween.prop] == null)) {
							return tween.elem[tween.prop];
						}

						// passing any value as a 4th parameter to .css will automatically
						// attempt a parseFloat and fallback to a string if the parse fails
						// so, simple values such as "10px" are parsed to Float.
						// complex values such as "rotate(1rad)" are returned as is.
						result = JQXLite.css(tween.elem, tween.prop, false, "");
						// Empty strings, null, undefined and "auto" are converted to 0.
						return !result || result === "auto" ? 0 : result;
					},
					set: function (tween) {
						// use step hook for back compat - use cssHook if its there - use .style if its
						// available and use plain properties where available
						if (JQXLite.fx.step[tween.prop]) {
							JQXLite.fx.step[tween.prop](tween);
						} else if (tween.elem.style && (tween.elem.style[JQXLite.cssProps[tween.prop]] != null || JQXLite.cssHooks[tween.prop])) {
							JQXLite.style(tween.elem, tween.prop, tween.now + tween.unit);
						} else {
							tween.elem[tween.prop] = tween.now;
						}
					}
				}
			};

			// Remove in 2.0 - this supports IE8's panic based approach
			// to setting things on disconnected nodes

			Tween.propHooks.scrollTop = Tween.propHooks.scrollLeft = {
				set: function (tween) {
					if (tween.elem.nodeType && tween.elem.parentNode) {
						tween.elem[tween.prop] = tween.now;
					}
				}
			};

			JQXLite.each(["toggle", "show", "hide"], function (i, name) {
				var cssFn = JQXLite.fn[name];
				JQXLite.fn[name] = function (speed, easing, callback) {
					return speed == null || typeof speed === "boolean" ||
						// special check for .toggle( handler, handler, ... )
						(!i && JQXLite.isFunction(speed) && JQXLite.isFunction(easing)) ?
						cssFn.apply(this, arguments) :
						this.animate(genFx(name, true), speed, easing, callback);
				};
			});

			JQXLite.fn.extend({
				fadeTo: function (speed, to, easing, callback) {

					// show any hidden elements after setting opacity to 0
					return this.filter(isHidden).css("opacity", 0).show()

						// animate to the value specified
						.end().animate({ opacity: to }, speed, easing, callback);
				},
				animate: function (prop, speed, easing, callback) {
					var empty = JQXLite.isEmptyObject(prop),
						optall = JQXLite.speed(speed, easing, callback),
						doAnimation = function () {
							// Operate on a copy of prop so per-property easing won't be lost
							var anim = Animation(this, JQXLite.extend({}, prop), optall);

							// Empty animations resolve immediately
							if (empty) {
								anim.stop(true);
							}
						};

					return empty || optall.queue === false ?
						this.each(doAnimation) :
						this.queue(optall.queue, doAnimation);
				},
				stop: function (type, clearQueue, gotoEnd) {
					var stopQueue = function (hooks) {
						var stop = hooks.stop;
						delete hooks.stop;
						stop(gotoEnd);
					};

					if (typeof type !== "string") {
						gotoEnd = clearQueue;
						clearQueue = type;
						type = undefined;
					}
					if (clearQueue && type !== false) {
						this.queue(type || "fx", []);
					}

					return this.each(function () {
						var dequeue = true,
							index = type != null && type + "queueHooks",
							timers = JQXLite.timers,
							data = JQXLite._data(this);

						if (index) {
							if (data[index] && data[index].stop) {
								stopQueue(data[index]);
							}
						} else {
							for (index in data) {
								if (data[index] && data[index].stop && rrun.test(index)) {
									stopQueue(data[index]);
								}
							}
						}

						for (index = timers.length; index--;) {
							if (timers[index].elem === this && (type == null || timers[index].queue === type)) {
								timers[index].anim.stop(gotoEnd);
								dequeue = false;
								timers.splice(index, 1);
							}
						}

						// start the next in the queue if the last step wasn't forced
						// timers currently will call their complete callbacks, which will dequeue
						// but only if they were gotoEnd
						if (dequeue || !gotoEnd) {
							JQXLite.dequeue(this, type);
						}
					});
				}
			});

			// Generate parameters to create a standard animation
			function genFx(type, includeWidth) {
				var which,
					attrs = { height: type },
					i = 0;

				// if we include width, step value is 1 to do all cssExpand values,
				// if we don't include width, step value is 2 to skip over Left and Right
				includeWidth = includeWidth ? 1 : 0;
				for (; i < 4; i += 2 - includeWidth) {
					which = cssExpand[i];
					attrs["margin" + which] = attrs["padding" + which] = type;
				}

				if (includeWidth) {
					attrs.opacity = attrs.width = type;
				}

				return attrs;
			}

			// Generate shortcuts for custom animations
			JQXLite.each({
				slideDown: genFx("show"),
				slideUp: genFx("hide"),
				slideToggle: genFx("toggle"),
				fadeIn: { opacity: "show" },
				fadeOut: { opacity: "hide" },
				fadeToggle: { opacity: "toggle" }
			}, function (name, props) {
				JQXLite.fn[name] = function (speed, easing, callback) {
					return this.animate(props, speed, easing, callback);
				};
			});

			JQXLite.speed = function (speed, easing, fn) {
				var opt = speed && typeof speed === "object" ? JQXLite.extend({}, speed) : {
					complete: fn || !fn && easing ||
						JQXLite.isFunction(speed) && speed,
					duration: speed,
					easing: fn && easing || easing && !JQXLite.isFunction(easing) && easing
				};

				opt.duration = JQXLite.fx.off ? 0 : typeof opt.duration === "number" ? opt.duration :
					opt.duration in JQXLite.fx.speeds ? JQXLite.fx.speeds[opt.duration] : JQXLite.fx.speeds._default;

				// normalize opt.queue - true/undefined/null -> "fx"
				if (opt.queue == null || opt.queue === true) {
					opt.queue = "fx";
				}

				// Queueing
				opt.old = opt.complete;

				opt.complete = function () {
					if (JQXLite.isFunction(opt.old)) {
						opt.old.call(this);
					}

					if (opt.queue) {
						JQXLite.dequeue(this, opt.queue);
					}
				};

				return opt;
			};

			JQXLite.easing = {
				linear: function (p) {
					return p;
				},
				swing: function (p) {
					return 0.5 - Math.cos(p * Math.PI) / 2;
				}
			};

			JQXLite.timers = [];
			JQXLite.fx = Tween.prototype.init;
			JQXLite.fx.tick = function () {
				var timer,
					timers = JQXLite.timers,
					i = 0;

				fxNow = JQXLite.now();

				for (; i < timers.length; i++) {
					timer = timers[i];
					// Checks the timer has not already been removed
					if (!timer() && timers[i] === timer) {
						timers.splice(i--, 1);
					}
				}

				if (!timers.length) {
					JQXLite.fx.stop();
				}
				fxNow = undefined;
			};

			JQXLite.fx.timer = function (timer) {
				if (timer() && JQXLite.timers.push(timer) && !timerId) {
					timerId = setInterval(JQXLite.fx.tick, JQXLite.fx.interval);
				}
			};

			JQXLite.fx.interval = 13;

			JQXLite.fx.stop = function () {
				clearInterval(timerId);
				timerId = null;
			};

			JQXLite.fx.speeds = {
				slow: 600,
				fast: 200,
				// Default speed
				_default: 400
			};

			// Back Compat <1.8 extension point
			JQXLite.fx.step = {};

			if (JQXLite.expr && JQXLite.expr.filters) {
				JQXLite.expr.filters.animated = function (elem) {
					return JQXLite.grep(JQXLite.timers, function (fn) {
						return elem === fn.elem;
					}).length;
				};
			}
			var rroot = /^(?:body|html)$/i;

			JQXLite.fn.offset = function (options) {
				if (arguments.length) {
					return options === undefined ?
						this :
						this.each(function (i) {
							JQXLite.offset.setOffset(this, options, i);
						});
				}

				var docElem, body, win, clientTop, clientLeft, scrollTop, scrollLeft,
					box = { top: 0, left: 0 },
					elem = this[0],
					doc = elem && elem.ownerDocument;

				if (!doc) {
					return;
				}

				if ((body = doc.body) === elem) {
					return JQXLite.offset.bodyOffset(elem);
				}

				docElem = doc.documentElement;

				// Make sure it's not a disconnected DOM node
				if (!JQXLite.contains(docElem, elem)) {
					return box;
				}

				// If we don't have gBCR, just use 0,0 rather than error
				// BlackBerry 5, iOS 3 (original iPhone)
				if (typeof elem.getBoundingClientRect !== "undefined") {
					box = elem.getBoundingClientRect();
				}
				win = getWindow(doc);
				clientTop = docElem.clientTop || body.clientTop || 0;
				clientLeft = docElem.clientLeft || body.clientLeft || 0;
				scrollTop = win.pageYOffset || docElem.scrollTop;
				scrollLeft = win.pageXOffset || docElem.scrollLeft;
				return {
					top: box.top + scrollTop - clientTop,
					left: box.left + scrollLeft - clientLeft
				};
			};

			JQXLite.offset = {

				bodyOffset: function (body) {
					var top = body.offsetTop,
						left = body.offsetLeft;

					if (JQXLite.support.doesNotIncludeMarginInBodyOffset) {
						top += parseFloat(JQXLite.css(body, "marginTop")) || 0;
						left += parseFloat(JQXLite.css(body, "marginLeft")) || 0;
					}

					return { top: top, left: left };
				},

				setOffset: function (elem, options, i) {
					var position = JQXLite.css(elem, "position");

					// set position first, in-case top/left are set even on static elem
					if (position === "static") {
						elem.style.position = "relative";
					}

					var curElem = JQXLite(elem),
						curOffset = curElem.offset(),
						curCSSTop = JQXLite.css(elem, "top"),
						curCSSLeft = JQXLite.css(elem, "left"),
						calculatePosition = (position === "absolute" || position === "fixed") && JQXLite.inArray("auto", [curCSSTop, curCSSLeft]) > -1,
						props = {}, curPosition = {}, curTop, curLeft;

					// need to be able to calculate position if either top or left is auto and position is either absolute or fixed
					if (calculatePosition) {
						curPosition = curElem.position();
						curTop = curPosition.top;
						curLeft = curPosition.left;
					} else {
						curTop = parseFloat(curCSSTop) || 0;
						curLeft = parseFloat(curCSSLeft) || 0;
					}

					if (JQXLite.isFunction(options)) {
						options = options.call(elem, i, curOffset);
					}

					if (options.top != null) {
						props.top = (options.top - curOffset.top) + curTop;
					}
					if (options.left != null) {
						props.left = (options.left - curOffset.left) + curLeft;
					}

					if ("using" in options) {
						options.using.call(elem, props);
					} else {
						curElem.css(props);
					}
				}
			};


			JQXLite.fn.extend({
				isRendered: function () {
					var that = this;
					var element = this[0];
					if (element.parentNode == null || (element.offsetWidth === 0 || element.offsetHeight === 0)) {
						return false;
					}

					return true;
				},

				getSizeFromStyle: function () {
					var that = this;
					var width = null;
					var height = null;
					var element = this[0];
					var computedStyle;

					if (element.style.width) {
						width = element.style.width;
					}
					if (element.style.height) {
						height = element.style.height;
					}

					if (window.getComputedStyle) {
						computedStyle = getComputedStyle(element, null);
					}
					else {
						computedStyle = element.currentStyle;
					}

					if (computedStyle) {
						if (computedStyle.width) {
							width = computedStyle.width;
						}
						if (computedStyle.height) {
							height = computedStyle.height;
						}
					}
					if (width === '0px') width = 0;
					if (height === '0px') height = 0;
					if (width === null) width = 0;
					if (height === null) height = 0;

					return { width: width, height: height };
				},

				initAnimate: function () {

				},

				sizeStyleChanged: function (resizeFn) {
					var that = this;

					var watchedElementData;

					var checkForChanges = function (mutations) {
						var data = watchedElementData;
						if (mutations && mutations[0] && mutations[0].attributeName === 'style' && mutations[0].type === 'attributes') {
							if (data.element.offsetWidth !== data.offsetWidth ||
								data.element.offsetHeight !== data.offsetHeight) {
								data.offsetWidth = data.element.offsetWidth;
								data.offsetHeight = data.element.offsetHeight;
								if (that.isRendered()) {
									data.callback();
								}
							}
						}
					}

					watchedElementData = {
						element: that[0],
						offsetWidth: that[0].offsetWidth,
						offsetHeight: that[0].offsetHeight,
						callback: resizeFn
					};

					try {
						if (!that.elementStyleObserver) {
							that.elementStyleObserver = new MutationObserver(checkForChanges);
							that.elementStyleObserver.observe(that[0], {
								attributes: true,
								childList: false,
								characterData: false
							});

						}
					}
					catch (error) { }
				},

				position: function () {
					if (!this[0]) {
						return;
					}

					var elem = this[0],

						// Get *real* offsetParent
						offsetParent = this.offsetParent(),

						// Get correct offsets
						offset = this.offset(),
						parentOffset = rroot.test(offsetParent[0].nodeName) ? { top: 0, left: 0 } : offsetParent.offset();

					// Subtract element margins
					// note: when an element has margin: auto the offsetLeft and marginLeft
					// are the same in Safari causing offset.left to incorrectly be 0
					offset.top -= parseFloat(JQXLite.css(elem, "marginTop")) || 0;
					offset.left -= parseFloat(JQXLite.css(elem, "marginLeft")) || 0;

					// Add offsetParent borders
					parentOffset.top += parseFloat(JQXLite.css(offsetParent[0], "borderTopWidth")) || 0;
					parentOffset.left += parseFloat(JQXLite.css(offsetParent[0], "borderLeftWidth")) || 0;

					// Subtract the two offsets
					return {
						top: offset.top - parentOffset.top,
						left: offset.left - parentOffset.left
					};
				},

				offsetParent: function () {
					return this.map(function () {
						var offsetParent = this.offsetParent || document.body;
						while (offsetParent && (!rroot.test(offsetParent.nodeName) && JQXLite.css(offsetParent, "position") === "static")) {
							offsetParent = offsetParent.offsetParent;
						}
						return offsetParent || document.body;
					});
				}
			});
			// Create scrollLeft and scrollTop methods
			JQXLite.each({ scrollLeft: "pageXOffset", scrollTop: "pageYOffset" }, function (method, prop) {
				var top = /Y/.test(prop);

				JQXLite.fn[method] = function (val) {
					return JQXLite.access(this, function (elem, method, val) {
						var win = getWindow(elem);

						if (val === undefined) {
							return win ? (prop in win) ? win[prop] :
								win.document.documentElement[method] :
								elem[method];
						}

						if (win) {
							win.scrollTo(
								!top ? val : JQXLite(win).scrollLeft(),
								top ? val : JQXLite(win).scrollTop()
							);

						} else {
							elem[method] = val;
						}
					}, method, val, arguments.length, null);
				};
			});

			function getWindow(elem) {
				return JQXLite.isWindow(elem) ?
					elem :
					elem.nodeType === 9 ?
						elem.defaultView || elem.parentWindow :
						false;
			}
			// Create innerHeight, innerWidth, height, width, outerHeight and outerWidth methods
			JQXLite.each({ Height: "height", Width: "width" }, function (name, type) {
				JQXLite.each({ padding: "inner" + name, content: type, "": "outer" + name }, function (defaultExtra, funcName) {
					// margin is only for outerHeight, outerWidth
					JQXLite.fn[funcName] = function (margin, value) {
						var chainable = arguments.length && (defaultExtra || typeof margin !== "boolean"),
							extra = defaultExtra || (margin === true || value === true ? "margin" : "border");

						return JQXLite.access(this, function (elem, type, value) {
							var doc;

							if (JQXLite.isWindow(elem)) {
								// As of 5/8/2012 this will yield incorrect results for Mobile Safari, but there
								// isn't a whole lot we can do. See pull request at this URL for discussion:
								// https://github.com/jqx/jqx/pull/764
								return elem.document.documentElement["client" + name];
							}

							// Get document width or height
							if (elem.nodeType === 9) {
								doc = elem.documentElement;

								// Either scroll[Width/Height] or offset[Width/Height] or client[Width/Height], whichever is greatest
								// unfortunately, this causes bug #3838 in IE6/8 only, but there is currently no good, small way to fix it.
								return Math.max(
									elem.body["scroll" + name], doc["scroll" + name],
									elem.body["offset" + name], doc["offset" + name],
									doc["client" + name]
								);
							}

							return value === undefined ?
								// Get width or height on the element, requesting but not forcing parseFloat
								JQXLite.css(elem, type, value, extra) :

								// Set width or height on the element
								JQXLite.style(elem, type, value, extra);
						}, type, chainable ? margin : undefined, chainable, null);
					};
				});
			});
			// Expose JQXLite to the global object
			window.JQXLite = window.jqxHelper = JQXLite;

			// Expose JQXLite as an AMD module, but only for AMD loaders that
			// understand the issues with loading multiple versions of JQXLite
			// in a page that all might call define(). The loader will indicate
			// they have special allowances for multiple JQXLite versions by
			// specifying define.amd.JQXLite = true. Register as a named module,
			// since JQXLite can be concatenated with other files that may use define,
			// but not use a proper concatenation script that understands anonymous
			// AMD modules. A named AMD is safest and most robust way to register.
			// Lowercase jqx is used because AMD module names are derived from
			// file names, and JQXLite is normally delivered in a lowercase file name.
			// Do this after creating the global so that if an AMD module wants to call
			// noConflict to hide this version of JQXLite, it will work.
			if ( true && __webpack_require__.amdO.JQXLite) {
				!(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = (function () { return JQXLite; }).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
			}

		})(window);
	}

	// jqxHelper
	(function (window) {
		if (window.jqxCore) {
			window.$$ = window.minQuery = window.JQXLite;

			if (!window.$) {
				window.$ = window.minQuery;
			}

			return;
		}

		if (window.jQuery) {
			window.minQuery = window.JQXLite = window.jQuery;
			return;
		}

		if (!window.$) {
			window.$ = window.minQuery = window.JQXLite;
		}
		else {
			window.minQuery = window.JQXLite = window.$;
		}
	})(window);
	// End of jqxHelper

	JQXLite.generateID = function () {
		var S4 = function () {
			return (((1 + Math.random()) * 0x10000) | 0).toString(16).substring(1);
		};

		var id = "";
		do {
			id = "jqx" + S4() + S4() + S4();
		} while ($('#' + id).length > 0);

		return id;
	}

	var jqxBaseFramework = window.jqxBaseFramework = window.minQuery || window.jQuery;

	(function ($) {

		$.jqx = $.jqx || {}
		window.jqx = $.jqx;

		var jqwidgets = {
			createInstance: function (selector, widgetName, params) {
				if (widgetName == 'jqxDataAdapter') {
					var source = params[0];
					var settings = params[1] || {};
					return new $.jqx.dataAdapter(source, settings);
				}

				$(selector)[widgetName](params || {});
				return $(selector)[widgetName]('getInstance');
			}
		};

		window.jqwidgets = jqwidgets;

		$.jqx.define = function (namespace, classname, baseclass) {
			namespace[classname] = function () {
				if (this.baseType) {
					this.base = new namespace[this.baseType]();
					this.base.defineInstance();
				}
				this.defineInstance();
				this.metaInfo();
			}

			namespace[classname].prototype.defineInstance = function () { };
			namespace[classname].prototype.metaInfo = function () { };
			namespace[classname].prototype.base = null;
			namespace[classname].prototype.baseType = undefined;

			if (baseclass && namespace[baseclass])
				namespace[classname].prototype.baseType = baseclass;
		}

		// method call
		$.jqx.invoke = function (object, args) {
			if (args.length == 0)
				return;

			var method = typeof (args) == Array || args.length > 0 ? args[0] : args;
			var methodArg = typeof (args) == Array || args.length > 1 ? Array.prototype.slice.call(args, 1) : $({}).toArray();

			while (object[method] == undefined && object.base != null) {
				if (object[method] != undefined && $.isFunction(object[method]))
					return object[method].apply(object, methodArg);

				if (typeof method == 'string') {
					var methodLowerCase = method.toLowerCase();
					if (object[methodLowerCase] != undefined && $.isFunction(object[methodLowerCase])) {
						return object[methodLowerCase].apply(object, methodArg);
					}
				}
				object = object.base;
			}

			if (object[method] != undefined && $.isFunction(object[method]))
				return object[method].apply(object, methodArg);

			if (typeof method == 'string') {
				var methodLowerCase = method.toLowerCase();
				if (object[methodLowerCase] != undefined && $.isFunction(object[methodLowerCase])) {
					return object[methodLowerCase].apply(object, methodArg);
				}
			}

			return;
		}

		$.jqx.getByPriority = function (arr) {
			var value = undefined;
			for (var i = 0; i < arr.length && value == undefined; i++) {
				if (value == undefined && arr[i] != undefined)
					value = arr[i];
			}

			return value;
		}

		$.jqx.hasProperty = function (obj, property) {
			if (typeof (property) == 'object') {
				for (var prop in property) {
					var o = obj;
					while (o) {
						if (o.hasOwnProperty(prop))
							return true;
						if (o.hasOwnProperty(prop.toLowerCase()))
							return true;
						o = o.base;
					}
					return false;
				}
			}
			else {
				while (obj) {
					if (obj.hasOwnProperty(property))
						return true;
					if (obj.hasOwnProperty(property.toLowerCase()))
						return true;
					obj = obj.base;
				}
			}

			return false;
		}

		$.jqx.hasFunction = function (object, args) {
			if (args.length == 0)
				return false;

			if (object == undefined)
				return false;

			var method = typeof (args) == Array || args.length > 0 ? args[0] : args;
			var methodArg = typeof (args) == Array || args.length > 1 ? Array.prototype.slice.call(args, 1) : {};

			while (object[method] == undefined && object.base != null) {
				if (object[method] && $.isFunction(object[method]))
					return true;

				if (typeof method == 'string') {
					var methodLowerCase = method.toLowerCase();
					if (object[methodLowerCase] && $.isFunction(object[methodLowerCase]))
						return true;
				}
				object = object.base;
			}

			if (object[method] && $.isFunction(object[method]))
				return true;

			if (typeof method == 'string') {
				var methodLowerCase = method.toLowerCase();
				if (object[methodLowerCase] && $.isFunction(object[methodLowerCase]))
					return true;
			}

			return false;
		}

		$.jqx.isPropertySetter = function (obj, args) {
			if (args.length == 1 && typeof (args[0]) == 'object')
				return true;

			if (args.length == 2 &&
				typeof (args[0]) == 'string' &&
				!$.jqx.hasFunction(obj, args)) {
				return true;
			}

			return false;
		}

		$.jqx.validatePropertySetter = function (obj, args, suppressException) {
			if (!$.jqx.propertySetterValidation)
				return true;

			if (args.length == 1 && typeof (args[0]) == 'object') {
				for (var i in args[0]) {
					var o = obj;
					while (!o.hasOwnProperty(i) && o.base)
						o = o.base;

					if (!o || !o.hasOwnProperty(i)) {
						if (!suppressException) {
							var hasLowerCase = o.hasOwnProperty(i.toString().toLowerCase());
							if (!hasLowerCase) {
								throw 'Invalid property: ' + i;
							}
							else return true;
						}
						return false;
					}
				}

				return true;
			}

			if (args.length != 2) {
				if (!suppressException)
					throw 'Invalid property: ' + args.length >= 0 ? args[0] : '';

				return false;
			}

			while (!obj.hasOwnProperty(args[0]) && obj.base)
				obj = obj.base;

			if (!obj || !obj.hasOwnProperty(args[0])) {
				if (!suppressException)
					throw 'Invalid property: ' + args[0];

				return false;
			}

			return true;
		}

		if (!Object.keys) {
			Object.keys = (function () {
				'use strict';
				var hasOwnProperty = Object.prototype.hasOwnProperty,
					hasDontEnumBug = !({ toString: null }).propertyIsEnumerable('toString'),
					dontEnums = [
						'toString',
						'toLocaleString',
						'valueOf',
						'hasOwnProperty',
						'isPrototypeOf',
						'propertyIsEnumerable',
						'constructor'
					],
					dontEnumsLength = dontEnums.length;

				return function (obj) {
					if (typeof obj !== 'object' && (typeof obj !== 'function' || obj === null)) {
						throw new TypeError('Object.keys called on non-object');
					}

					var result = [], prop, i;

					for (prop in obj) {
						if (hasOwnProperty.call(obj, prop)) {
							result.push(prop);
						}
					}

					if (hasDontEnumBug) {
						for (i = 0; i < dontEnumsLength; i++) {
							if (hasOwnProperty.call(obj, dontEnums[i])) {
								result.push(dontEnums[i]);
							}
						}
					}
					return result;
				};
			}());
		}

		$.jqx.set = function (object, args) {
			var newValuesLength = 0;
			if (args.length == 1 && typeof (args[0]) == 'object') {
				if (object.isInitialized && Object.keys && Object.keys(args[0]).length > 1) {
					var element = !object.base ? object.element : object.base.element;
					var initArgs = $.data(element, object.widgetName).initArgs;
					if (initArgs && JSON && JSON.stringify && args[0] && initArgs[0]) {
						try {
							if (JSON.stringify(args[0]) == JSON.stringify(initArgs[0])) {
								var toReturn = true;
								$.each(args[0], function (key, value) {
									if (object[key] != value) {
										toReturn = false;
										return false;
									}
								});
								if (toReturn) {
									return;
								}
							}
						}
						catch (err) {
						}
					}
					object.batchUpdate = args[0];
					var oldValues = {};
					var newValues = {};
					$.each(args[0], function (key, value) {
						var obj = object;
						while (!obj.hasOwnProperty(key) && obj.base != null)
							obj = obj.base;

						if (obj.hasOwnProperty(key)) {
							if (object[key] != value) {
								oldValues[key] = object[key];
								newValues[key] = value;
								newValuesLength++;
							}
						}
						else if (obj.hasOwnProperty(key.toLowerCase())) {
							if (object[key.toLowerCase()] != value) {
								oldValues[key.toLowerCase()] = object[key.toLowerCase()];
								newValues[key.toLowerCase()] = value;
								newValuesLength++;
							}
						}
					});
					if (newValuesLength < 2) {
						object.batchUpdate = null;
					}
				}

				$.each(args[0], function (key, value) {
					var obj = object;
					while (!obj.hasOwnProperty(key) && obj.base != null)
						obj = obj.base;

					if (obj.hasOwnProperty(key)) {
						$.jqx.setvalueraiseevent(obj, key, value);
					}
					else if (obj.hasOwnProperty(key.toLowerCase())) {
						$.jqx.setvalueraiseevent(obj, key.toLowerCase(), value);
					}
					else if ($.jqx.propertySetterValidation)
						throw "jqxCore: invalid property '" + key + "'";
				});

				if (object.batchUpdate != null) {
					object.batchUpdate = null;
					if (object.propertiesChangedHandler && newValuesLength > 1) {
						object.propertiesChangedHandler(object, oldValues, newValues);
					}
				}
			}
			else if (args.length == 2) {
				while (!object.hasOwnProperty(args[0]) && object.base)
					object = object.base;

				if (object.hasOwnProperty(args[0])) {
					$.jqx.setvalueraiseevent(object, args[0], args[1]);
				}
				else if (object.hasOwnProperty(args[0].toLowerCase())) {
					$.jqx.setvalueraiseevent(object, args[0].toLowerCase(), args[1]);
				}
				else if ($.jqx.propertySetterValidation)
					throw "jqxCore: invalid property '" + args[0] + "'";
			}
		}

		$.jqx.setvalueraiseevent = function (object, key, value) {
			var oldVal = object[key];

			object[key] = value;

			if (!object.isInitialized)
				return;

			if (object.propertyChangedHandler != undefined)
				object.propertyChangedHandler(object, key, oldVal, value);

			if (object.propertyChangeMap != undefined && object.propertyChangeMap[key] != undefined)
				object.propertyChangeMap[key](object, key, oldVal, value);
		};

		$.jqx.get = function (object, args) {
			if (args == undefined || args == null)
				return undefined;

			if (object.propertyMap) {
				var newVal = object.propertyMap(args);
				if (newVal != null)
					return newVal;
			}

			if (object.hasOwnProperty(args))
				return object[args];

			if (object.hasOwnProperty(args.toLowerCase()))
				return object[args.toLowerCase()];

			var arg = undefined;
			if (typeof (args) == Array) {
				if (args.length != 1)
					return undefined;
				arg = args[0];
			}
			else if (typeof (args) == 'string')
				arg = args;

			while (!object.hasOwnProperty(arg) && object.base)
				object = object.base;

			if (object)
				return object[arg];

			return undefined;
		}

		$.jqx.serialize = function (obj) {
			var txt = '';
			if ($.isArray(obj)) {
				txt = '['
				for (var i = 0; i < obj.length; i++) {
					if (i > 0)
						txt += ', ';
					txt += $.jqx.serialize(obj[i]);
				}
				txt += ']';
			}
			else if (typeof (obj) == 'object') {
				txt = '{';
				var j = 0;
				for (var i in obj) {
					if (j++ > 0)
						txt += ', ';
					txt += i + ': ' + $.jqx.serialize(obj[i]);
				}
				txt += '}';
			}
			else
				txt = obj.toString();

			return txt;
		}

		$.jqx.propertySetterValidation = true;

		$.jqx.jqxWidgetProxy = function (controlName, element, args) {
			var host = $(element);
			var vars = $.data(element, controlName);
			if (vars == undefined) {
				return undefined;
			}

			var obj = vars.instance;

			if ($.jqx.hasFunction(obj, args))
				return $.jqx.invoke(obj, args);

			if ($.jqx.isPropertySetter(obj, args)) {
				if ($.jqx.validatePropertySetter(obj, args)) {
					$.jqx.set(obj, args);
					return undefined;
				}
			} else {
				if (typeof (args) == 'object' && args.length == 0)
					return;
				else if (typeof (args) == 'object' && args.length == 1 && $.jqx.hasProperty(obj, args[0]))
					return $.jqx.get(obj, args[0]);
				else if (typeof (args) == 'string' && $.jqx.hasProperty(obj, args[0]))
					return $.jqx.get(obj, args);
			}

			throw "jqxCore: Invalid parameter '" + $.jqx.serialize(args) + "' does not exist.";
			//      return undefined;
		}

		$.jqx.applyWidget = function (element, controlName, args, instance) {
			var WinJS = false;
			try {
				WinJS = window.MSApp != undefined;
			}
			catch (e) {
			}

			var host = $(element);
			if (!instance) {
				instance = new $.jqx['_' + controlName]();
			}
			else {
				instance.host = host;
				instance.element = element;
			}
			if (element.id == "") {
				element.id = $.jqx.utilities.createId();
			}

			var vars = { host: host, element: element, instance: instance, initArgs: args };

			instance.widgetName = controlName;
			$.data(element, controlName, vars);
			$.data(element, 'jqxWidget', vars.instance);

			var inits = new Array();
			var instance = vars.instance;
			while (instance) {
				instance.isInitialized = false;
				inits.push(instance);
				instance = instance.base;
			}
			inits.reverse();
			inits[0].theme = $.jqx.theme || '';

			$.jqx.jqxWidgetProxy(controlName, element, args);

			for (var i in inits) {
				instance = inits[i];
				if (i == 0) {
					instance.host = host;
					instance.element = element;
					instance.WinJS = WinJS;
				}
				if (instance != undefined) {
					if (instance.definedInstance) {
						instance.definedInstance();
					}
					if (instance.createInstance != null) {
						if (WinJS) {
							MSApp.execUnsafeLocalFunction(function () {
								instance.createInstance(args);
							});
						}
						else {
							instance.createInstance(args);
						}
					}
				}
			}

			for (var i in inits) {
				if (inits[i] != undefined) {
					inits[i].isInitialized = true;
				}
			}

			if (WinJS) {
				MSApp.execUnsafeLocalFunction(function () {
					vars.instance.refresh(true);
				});
			}
			else {
				vars.instance.refresh(true);
			}

		}

		$.jqx.jqxWidget = function (name, base, params) {

			var WinJS = false;
			try {
				var jqxArgs = Array.prototype.slice.call(params, 0);
			}
			catch (e) {
				var jqxArgs = '';
			}

			try {
				WinJS = window.MSApp != undefined;
			}
			catch (e) {
			}

			var controlName = name;

			var baseControl = '';
			if (base)
				baseControl = '_' + base;
			$.jqx.define($.jqx, '_' + controlName, baseControl);

			var widgets = new Array();

			if (!window[controlName]) {
				var serializeObject = function (data) {
					if (data == null) return "";
					var dataType = $.type(data);
					switch (dataType) {
						case "string":
						case "number":
						case "date":
						case "boolean":
						case "bool":
							if (data === null)
								return "";
							return data.toString()
					}

					var str = "";
					$.each(data, function (index, value) {
						var val = value;
						if (index > 0) str += ', ';
						str += "[";
						var m = 0;

						if ($.type(val) == "object") {
							for (var obj in val) {
								if (m > 0) str += ', ';
								str += '{' + obj + ":" + val[obj] + '}';
								m++;
							}
						}
						else {
							if (m > 0) str += ', ';
							str += '{' + index + ":" + val + '}';
							m++;
						}

						str += "]";
					});
					return str;
				}

				jqwidgets[controlName] = window[controlName] = function (selector, params) {
					var args = [];
					if (!params) {
						params = {};
					}
					args.push(params);

					var uid = selector;
					if ($.type(uid) === "object" && selector[0]) {
						uid = selector[0].id;
						if (uid === "") {
							uid = selector[0].id = $.jqx.utilities.createId();
						}
					} else if ($.type(selector) === "object" && selector && selector.nodeName) {
						uid = selector.id;
						if (uid === "") {
							uid = selector.id = $.jqx.utilities.createId();
						}
					}

					if (window.jqxWidgets && window.jqxWidgets[uid]) {
						if (params) {
							$.each(window.jqxWidgets[uid], function (index) {
								var data = $(this.element).data();
								if (data && data.jqxWidget) {
									$(this.element)[controlName](params);
								}
							});
						}
						if (window.jqxWidgets[uid].length == 1) {
							var data = $(window.jqxWidgets[uid][0].widgetInstance.element).data();
							if (data && data.jqxWidget) {
								return window.jqxWidgets[uid][0];
							}
						}

						var data = $(window.jqxWidgets[uid][0].widgetInstance.element).data();
						if (data && data.jqxWidget) {
							return window.jqxWidgets[uid];
						}
					}

					var elements = $(selector);
					if (elements.length === 0) {
						elements = $("<div></div>");
						if (controlName === "jqxInput" || controlName === "jqxPasswordInput" || controlName === "jqxMaskedInput") {
							elements = $("<input/>");
						}
						if (controlName === "jqxTextArea") {
							elements = $("<textarea></textarea>");
						}
						if (controlName === "jqxButton" || controlName === "jqxRepeatButton" || controlName === "jqxToggleButton") {
							elements = $("<button/>");
						}
						if (controlName === "jqxSplitter") {
							elements = $("<div><div>Panel 1</div><div>Panel 2</div></div>");
						}
						if (controlName === "jqxTabs") {
							elements = $("<div><ul><li>Tab 1</li><li>Tab 2</li></ul><div>Content 1</div><div>Content 2</div></div>");
						}
						if (controlName === "jqxRibbon") {
							elements = $("<div><ul><li>Tab 1</li><li>Tab 2</li></ul><div><div>Content 1</div><div>Content 2</div></div></div>");
						}
						if (controlName === "jqxDocking") {
							elements = $("<div><div><div><div>Title 1</div><div>Content 1</div></div></div></div>");
						}
						if (controlName === "jqxWindow") {
							elements = $("<div><div>Title 1</div><div>Content 1</div></div>");
						}
					}
					var instances = [];


					$.each(elements, function (index) {
						var element = elements[index];
						$.jqx.applyWidget(element, controlName, args, undefined);
						if (!widgets[controlName]) {
							var instance = $.data(element, 'jqxWidget');
							var properties = $.jqx["_" + controlName].prototype.defineInstance();
							var metaInfo = {};

							if ($.jqx["_" + controlName].prototype.metaInfo) {
								metaInfo = $.jqx["_" + controlName].prototype.metaInfo();
							}

							if (controlName == "jqxDockingLayout") {
								properties = $.extend(properties, $.jqx["_jqxLayout"].prototype.defineInstance());
							}
							if (controlName == "jqxToggleButton" || controlName == "jqxRepeatButton") {
								properties = $.extend(properties, $.jqx["_jqxButton"].prototype.defineInstance());
							}
							if (controlName == "jqxTreeGrid") {
								properties = $.extend(properties, $.jqx["_jqxDataTable"].prototype.defineInstance());
							}

							var widgetConstructor = function (element) {
								var instance = $.data(element, 'jqxWidget');
								this.widgetInstance = instance;
								var widget = $.extend(this, instance);
								widget.on = widget.addEventListener = function (eventName, callback) {
									widget.addHandler(!widget.base ? widget.host : widget.base.host, eventName, callback);
								}
								widget.off = widget.removeEventListener = function (eventName) {
									widget.removeHandler(!widget.base ? widget.host : widget.base.host, eventName);
								}

								for (var obj in instance) {
									if ($.type(instance[obj]) == "function") {
										widget[obj] = $.proxy(instance[obj], instance);
									}
								}
								return widget;
							}
							widgets[controlName] = widgetConstructor;

							// widget properties
							$.each(properties, function (property, currentValue) {
								Object.defineProperty(widgetConstructor.prototype, property, {
									get: function () {
										if (this.widgetInstance) {
											return this.widgetInstance[property];
										}
										return currentValue;
									},
									set: function (newValue) {
										if (this.widgetInstance && (this.widgetInstance[property] != newValue || property === "width" || property === "height")) {
											var key1 = this.widgetInstance[property];
											var key2 = newValue;
											var dataType1 = $.type(key1);
											var dataType2 = $.type(key2);
											var differentTypes = false;
											if (dataType1 != dataType2 || property === "source" || property === "width" || property === "height") {
												differentTypes = true;
											}
											if (differentTypes || (serializeObject(key1) != serializeObject(key2))) {
												var settings = {};
												settings[property] = newValue;
												if (this.widgetInstance.host) {
													this.widgetInstance.host[controlName](settings);
												}
												else {
													this.widgetInstance.base.host[controlName](settings);
												}
												this.widgetInstance[property] = newValue;
												if (this.widgetInstance.propertyUpdated) {
													this.widgetInstance.propertyUpdated(property, key1, newValue);
												}
											}
										}
									}
								});
							});
						}
						var instance = new widgets[controlName](element);

						instances.push(instance);
						if (!window.jqxWidgets) {
							window.jqxWidgets = new Array();
						}
						if (!window.jqxWidgets[uid]) {
							window.jqxWidgets[uid] = new Array();
						}
						window.jqxWidgets[uid].push(instance);
					});

					if (instances.length === 1)
						return instances[0];

					return instances;

				}
			}

			$.fn[controlName] = function () {
				var args = Array.prototype.slice.call(arguments, 0);

				if (args.length == 0 || (args.length == 1 && typeof (args[0]) == 'object')) {
					if (this.length == 0) {
						if (this.selector) {
							throw new Error('Invalid Selector - ' + this.selector + '! Please, check whether the used ID or CSS Class name is correct.');
						}
						else {
							throw new Error('Invalid Selector! Please, check whether the used ID or CSS Class name is correct.');
						}
					}

					return this.each(function () {
						var host = $(this);
						var element = this; // element == this == host[0]
						var vars = $.data(element, controlName);

						if (vars == null) {
							$.jqx.applyWidget(element, controlName, args, undefined);
						}
						else {
							$.jqx.jqxWidgetProxy(controlName, this, args);
						}
					}); // each
				}
				else {
					if (this.length == 0) {
						if (this.selector) {
							throw new Error('Invalid Selector - ' + this.selector + '! Please, check whether the used ID or CSS Class name is correct.');
						}
						else {
							throw new Error('Invalid Selector! Please, check whether the used ID or CSS Class name is correct.');
						}
					}

					var returnVal = null;

					var cnt = 0;
					this.each(function () {
						var result = $.jqx.jqxWidgetProxy(controlName, this, args);

						if (cnt == 0) {
							returnVal = result;
							cnt++;
						}
						else {
							if (cnt == 1) {
								var tmp = [];
								tmp.push(returnVal);
								returnVal = tmp;
							}
							returnVal.push(result);
						}
					}); // each
				}

				return returnVal;
			}

			try {
				$.extend($.jqx['_' + controlName].prototype, Array.prototype.slice.call(params, 0)[0]);
			}
			catch (e) {
			}

			$.extend($.jqx['_' + controlName].prototype, {
				toThemeProperty: function (propertyName, override) {
					return $.jqx.toThemeProperty(this, propertyName, override);
				},

				isMaterialized: function () {
					if (!this.theme) {
						return false;
					}

					if (this.theme === "fluent") {
						return true;
					}

					if (this.theme === "light") {
						return true;
					}


					if (this.theme === "dark") {
						return true;
					}

					if (this.theme === "deepblue") {
						return true;
					}

					if (this.theme.indexOf("material") >= 0) {
						return true;
					}
				},

				isModern: function () {
					if (!this.theme) {
						return false;
					}

					if (this.theme.indexOf("light") >= 0) {
						return true;
					}

					if (this.theme === "dark") {
						return true;
					}
				},

				_addBarAndLabel: function (host) {
					var that = this;

					var label = $("<label></label");
					label[0].innerHTML = this.placeHolder;
					label.addClass(that.toThemeProperty('jqx-input-label'));
					host.after(label);
					that.label = label;

					var bar = $("<span></span>");
					host.after(bar);
					bar.addClass(that.toThemeProperty('jqx-input-bar'));
					that.bar = bar;
					that.bar.css('top', this.host.height());
				}
			});

			$.jqx['_' + controlName].prototype.refresh = function () {
				if (this.base)
					this.base.refresh(true);
			}
			$.jqx['_' + controlName].prototype.createInstance = function () {
			}

			$.jqx.isPassiveSupported = function () {
				var that = this;

				if (that.supportsPassive !== undefined) {
					return that.supportsPassive;
				}

				that.supportsPassive = false;
				try {
					var opts = Object.defineProperty({
					}, 'passive', {
						// eslint-disable-next-line getter-return
						get: function () {
							that.supportsPassive = true;
						}
					});
					window.addEventListener('testPassive', null, opts);
					window.removeEventListener('testPassive', null, opts);
				}
				catch (e) {
					//
				}

				return that.supportsPassive;
			}

			$.jqx['_' + controlName].prototype.addEventHandler = function (event, fnHandler) {
				if (this.base) {
					this.base.host.on(event, fnHandler);
				}
				else {
					this.host.on(event, fnHandler);
				}
			}

			$.jqx['_' + controlName].prototype.removeEventHandler = function (event, fnHandler) {
				if (this.base) {
					this.base.host.off(event);
				}
				else {
					this.host.off(event);
				}
			}

			$.jqx['_' + controlName].prototype.applyTo = function (element, args) {
				if (!(args instanceof Array)) {
					var a = [];
					a.push(args);
					args = a;
				}

				$.jqx.applyWidget(element, controlName, args, this);
			}

			$.jqx['_' + controlName].prototype.getInstance = function () {
				return this;
			}
			$.jqx['_' + controlName].prototype.propertyChangeMap = {};

			$.jqx['_' + controlName].prototype.addHandler = function (source, events, func, data) {
				$.jqx.addHandler($(source), events, func, data);
			};

			$.jqx['_' + controlName].prototype.removeHandler = function (source, events, func) {
				$.jqx.removeHandler($(source), events, func);
			};

			$.jqx['_' + controlName].prototype.setOptions = function () {
				if (!this.host || !this.host.length || this.host.length != 1)
					return;

				return $.jqx.jqxWidgetProxy(controlName, this.host[0], arguments);
			};
		} // jqxWidget

		$.jqx.toThemeProperty = function (instance, propertyName, override) {
			if (instance.theme == '')
				return propertyName;

			var split = propertyName.split(' ');
			var result = '';
			for (var i = 0; i < split.length; i++) {
				if (i > 0)
					result += ' ';

				var key = split[i];

				if (override != null && override)
					result += key + '-' + instance.theme;
				else
					result += key + ' ' + key + '-' + instance.theme;
			}

			return result;
		}

		$.jqx.addHandler = function (source, eventsList, func, data) {
			var events = eventsList.split(' ');

			for (var i = 0; i < events.length; i++) {
				var event = events[i];

				if (window.addEventListener && source[0]) {
					switch (event) {
						case 'mousewheel':
							if ($.jqx.browser.mozilla) {
								source[0].addEventListener('DOMMouseScroll', func, $.jqx.isPassiveSupported() ? { passive: false } : false);
							}
							else {
								source[0].addEventListener('mousewheel', func, $.jqx.isPassiveSupported() ? { passive: false } : false);
							}
							continue;
						case 'mousemove':
							if (!data) {
								source[0].addEventListener('mousemove', func, false);
								continue;
							}
							break;
						case 'touchmove':
							if (!data) {
								source[0].addEventListener('touchmove', func, false);
								continue;
							}
							else if (data && data.passive) {
								source[0].addEventListener('touchmove', func, data);
								continue;
							}

							break;
					}
				}

				if (data == undefined || data == null) {
					if (source.on)
						source.on(event, func);
					else
						source.bind(event, func);
				}
				else {
					if (source.on)
						source.on(event, data, func);
					else
						source.bind(event, data, func);
				}
			} // for
		};

		$.jqx.removeHandler = function (source, eventsList, func) {
			if (!eventsList) {
				if (source.off)
					source.off();
				else
					source.unbind();
				return;
			}
			var events = eventsList.split(' ');

			for (var i = 0; i < events.length; i++) {
				var event = events[i];

				if (window.removeEventListener) {
					switch (event) {
						case 'mousewheel':
							if ($.jqx.browser.mozilla) {
								source[0].removeEventListener('DOMMouseScroll', func, false);
							}
							else {
								source[0].removeEventListener('mousewheel', func, false);
							}
							continue;
						case 'mousemove':
							if (func) {
								source[0].removeEventListener('mousemove', func, false);
								continue;
							}
							break;
						case 'touchmove':
							if (func) {
								source[0].removeEventListener('touchmove', func, false);
								continue;
							}
							break;
					}
				}

				if (event == undefined) {
					if (source.off)
						source.off();
					else
						source.unbind();
					continue;
				}

				if (func == undefined) {
					if (source.off)
						source.off(event);
					else
						source.unbind(event);
				}
				else {
					if (source.off)
						source.off(event, func);
					else
						source.unbind(event, func);
				}
			}
		};

		$.jqx.credits = $.jqx.credits || "";
		$.jqx.theme = $.jqx.theme || "";
		$.jqx.scrollAnimation = $.jqx.scrollAnimation || false;
		$.jqx.resizeDelay = $.jqx.resizeDelay || 10;

		$.jqx.ready = function () {
			$(window).trigger('jqxReady');
		}
		$.jqx.init = function () {
			$.each(arguments[0], function (index, value) {
				if (index == "theme") {
					$.jqx.theme = value;
				}
				if (index == "scrollBarSize") {
					$.jqx.utilities.scrollBarSize = value;
				}
				if (index == "touchScrollBarSize") {
					$.jqx.utilities.touchScrollBarSize = value;
				}
				if (index == "scrollBarButtonsVisibility") {
					$.jqx.utilities.scrollBarButtonsVisibility = value;
				}
			});
		}

		// Utilities
		$.jqx.utilities = $.jqx.utilities || {};
		$.extend($.jqx.utilities,
			{
				scrollBarSize: 13,
				touchScrollBarSize: 8,
				scrollBarButtonsVisibility: "visible",
				createId: function () {
					var S4 = function () {
						return (((1 + Math.random()) * 0x10000) | 0).toString(16).substring(1);
					};
					return "jqxWidget" + S4() + S4() + S4();
				},

				setTheme: function (oldTheme, theme, element) {
					if (typeof element === 'undefined') {
						return;
					}

					if (!element[0].className.split) {
						return;
					}

					if (oldTheme === undefined) {
						oldTheme = '';
					}

					if (theme === undefined) {
						theme = '';
					}

					var classNames = element[0].className.split(' '),
						oldClasses = [], newClasses = [],
						children = element.children();
					for (var i = 0; i < classNames.length; i += 1) {
						if (classNames[i].indexOf(oldTheme) >= 0) {
							if (oldTheme.length > 0) {
								oldClasses.push(classNames[i]);
								newClasses.push(classNames[i].replace(oldTheme, theme));
							}
							else {
								newClasses.push(classNames[i].replace("-" + theme, "") + '-' + theme);
							}
						}
					}
					this._removeOldClasses(oldClasses, element);
					this._addNewClasses(newClasses, element);
					for (var i = 0; i < children.length; i += 1) {
						this.setTheme(oldTheme, theme, $(children[i]));
					}
				},

				_removeOldClasses: function (classes, element) {
					for (var i = 0; i < classes.length; i += 1) {
						element.removeClass(classes[i]);
					}
				},

				_addNewClasses: function (classes, element) {
					for (var i = 0; i < classes.length; i += 1) {
						element.addClass(classes[i]);
					}
				},

				getOffset: function (el) {
					var left = $.jqx.mobile.getLeftPos(el[0]);
					var top = $.jqx.mobile.getTopPos(el[0]);
					return { top: top, left: left };
				},

				resize: function (element, callback, destroy, checkForHidden) {
					if (checkForHidden === undefined) {
						checkForHidden = true;
					}

					var index = -1;
					var that = this;
					var getHiddenIndex = function (element) {
						if (!that.hiddenWidgets) {
							return -1;
						}

						var hiddenIndex = -1;
						for (var i = 0; i < that.hiddenWidgets.length; i++) {
							if (element.id) {
								if (that.hiddenWidgets[i].id == element.id) {
									hiddenIndex = i;
									break;
								}
							}
							else {
								if (that.hiddenWidgets[i].id == element[0].id) {
									hiddenIndex = i;
									break;
								}
							}
						}
						return hiddenIndex;
					}


					if (this.resizeHandlers) {
						for (var i = 0; i < this.resizeHandlers.length; i++) {
							if (element.id) {
								if (this.resizeHandlers[i].id == element.id) {
									index = i;
									break;
								}
							}
							else {
								if (this.resizeHandlers[i].id == element[0].id) {
									index = i;
									break;
								}
							}
						}

						if (destroy === true) {
							if (index != -1) {
								this.resizeHandlers.splice(index, 1);
								if (this.watchedElementData && this.watchedElementData.length > 0) {
									this.watchedElementData.splice(index, 1);
								}
							}

							if (this.resizeHandlers.length == 0) {
								var w = $(window);
								if (w.off) {
									w.off('resize.jqx');
									w.off('orientationchange.jqx');
									w.off('orientationchanged.jqx');
								}
								else {
									w.unbind('resize.jqx');
									w.unbind('orientationchange.jqx');
									w.unbind('orientationchanged.jqx');
								}
								this.resizeHandlers = null;
							}
							var hiddenIndex = getHiddenIndex(element);
							if (hiddenIndex != -1 && this.hiddenWidgets) {
								this.hiddenWidgets.splice(hiddenIndex, 1);
							}
							return;
						}
					}
					else if (destroy === true) {
						var hiddenIndex = getHiddenIndex(element);
						if (hiddenIndex != -1 && this.hiddenWidgets) {
							this.hiddenWidgets.splice(hiddenIndex, 1);
						}
						return;
					}
					var that = this;
					var doResize = function (isHidden, type) {
						if (!that.resizeHandlers)
							return;

						var getParentsCount = function (element) {
							var index = -1;
							var parent = element.parentNode;
							while (parent) {
								index++;
								parent = parent.parentNode;
							}
							return index;
						}

						var compare = function (value1, value2) {
							if (!value1.widget || !value2.widget)
								return 0;

							var parents1 = getParentsCount(value1.widget[0]);
							var parents2 = getParentsCount(value2.widget[0]);

							try {
								if (parents1 < parents2) { return -1; }
								if (parents1 > parents2) { return 1; }
							}
							catch (error) {
								var er = error;
							}

							return 0;
						};
						var handleHiddenWidgets = function (delay) {
							if (that.hiddenWidgets.length > 0) {
								that.hiddenWidgets.sort(compare);
								var updateHiddenWidgets = function () {
									var hasHiddenWidget = false;
									var currentHiddenWidgets = new Array();
									for (var p = 0; p < that.hiddenWidgets.length; p++) {
										var handler = that.hiddenWidgets[p];
										if ($.jqx.isHidden(handler.widget)) {
											hasHiddenWidget = true;
											currentHiddenWidgets.push(handler);
										}
										else {
											if (handler.callback) {
												handler.callback(type);
											}
										}
									}
									that.hiddenWidgets = currentHiddenWidgets;
									if (!hasHiddenWidget) {
										clearInterval(that.__resizeInterval);
									}
								}
								if (delay == false) {
									updateHiddenWidgets();
									if (that.__resizeInterval) clearInterval(that.__resizeInterval);
									return;
								}
								if (that.__resizeInterval) clearInterval(that.__resizeInterval);
								that.__resizeInterval = setInterval(function () {
									updateHiddenWidgets();
								}, 100);
							}
						}

						if (that.hiddenWidgets && that.hiddenWidgets.length > 0) {
							handleHiddenWidgets(false);
						}
						that.hiddenWidgets = new Array();
						that.resizeHandlers.sort(compare);
						for (var i = 0; i < that.resizeHandlers.length; i++) {
							var handler = that.resizeHandlers[i];
							var widget = handler.widget;
							var data = handler.data;
							if (!data) continue;
							if (!data.jqxWidget) continue;

							var width = data.jqxWidget.width;
							var height = data.jqxWidget.height;

							if (data.jqxWidget.base) {
								if (width == undefined) {
									width = data.jqxWidget.base.width;
								}
								if (height == undefined) {
									height = data.jqxWidget.base.height;
								}
							}

							if (width === undefined && height === undefined) {
								width = data.jqxWidget.element.style.width;
								height = data.jqxWidget.element.style.height;
							}

							var percentageSize = false;
							if (width != null && width.toString().indexOf("%") != -1) {
								percentageSize = true;
							}

							if (height != null && height.toString().indexOf("%") != -1) {
								percentageSize = true;
							}

							if ($.jqx.isHidden(widget)) {
								if (getHiddenIndex(widget) === -1) {
									if (percentageSize || isHidden === true) {
										if (handler.data.nestedWidget !== true) {
											that.hiddenWidgets.push(handler);
										}
									}
								}
							}
							else if (isHidden === undefined || isHidden !== true) {
								if (percentageSize) {
									handler.callback(type);
									if (that.watchedElementData) {
										for (var m = 0; m < that.watchedElementData.length; m++) {
											if (that.watchedElementData[m].element == data.jqxWidget.element) {
												that.watchedElementData[m].offsetWidth = data.jqxWidget.element.offsetWidth;
												that.watchedElementData[m].offsetHeight = data.jqxWidget.element.offsetHeight;
												break;
											}
										}
									}
									if (that.hiddenWidgets.indexOf(handler) >= 0) {
										that.hiddenWidgets.splice(that.hiddenWidgets.indexOf(handler), 1);
									}
								}
								if (data.jqxWidget.element) {
									var widgetClass = data.jqxWidget.element.className;
									if (widgetClass.indexOf('dropdownlist') >= 0 || widgetClass.indexOf('datetimeinput') >= 0 || widgetClass.indexOf('combobox') >= 0 || widgetClass.indexOf('menu') >= 0) {
										if (data.jqxWidget.isOpened) {
											var opened = data.jqxWidget.isOpened();
											if (opened) {
												if (type && type == "resize" && $.jqx.mobile.isTouchDevice())
													continue;

												data.jqxWidget.close();
											}
										}
									}
								}
							}
						};

						handleHiddenWidgets();
					}

					if (!this.resizeHandlers) {
						this.resizeHandlers = new Array();

						var w = $(window);
						if (w.on) {
							this._resizeTimer = null;
							this._initResize = null;
							w.on('resize.jqx', function (event) {
								if (that._resizeTimer != undefined) {
									clearTimeout(that._resizeTimer);
								}
								if (!that._initResize) {
									that._initResize = true;
									doResize(null, 'resize');
								}
								else {
									that._resizeTimer = setTimeout(function () {
										doResize(null, 'resize');
									}, $.jqx.resizeDelay);
								}
							});
							w.on('orientationchange.jqx', function (event) {
								doResize(null, 'orientationchange');
							});
							w.on('orientationchanged.jqx', function (event) {
								doResize(null, 'orientationchange');
							});
						}
						else {
							w.bind('resize.jqx', function (event) {
								doResize(null, 'orientationchange');
							});
							w.bind('orientationchange.jqx', function (event) {
								doResize(null, 'orientationchange');
							});
							w.bind('orientationchanged.jqx', function (event) {
								doResize(null, 'orientationchange');
							});
						}
					}
					var elementData = element.data();
					if (checkForHidden) {
						if (index === -1) {
							this.resizeHandlers.push({ id: element[0].id, widget: element, callback: callback, data: elementData });
						}
					}
					try {
						var width = elementData.jqxWidget.width;
						var height = elementData.jqxWidget.height;

						if (elementData.jqxWidget.base) {
							if (width == undefined) {
								width = elementData.jqxWidget.base.width;
							}
							if (height == undefined) {
								height = elementData.jqxWidget.base.height;
							}
						}

						if (width === undefined && height === undefined) {
							width = elementData.jqxWidget.element.style.width;
							height = elementData.jqxWidget.element.style.height;
						}

						var percentageSize = false;
						if (width != null && width.toString().indexOf("%") != -1) {
							percentageSize = true;
						}

						if (height != null && height.toString().indexOf("%") != -1) {
							percentageSize = true;
						}
						if (percentageSize) {
							if (!this.watchedElementData) {
								this.watchedElementData = [];
							}
							var that = this;
							var checkForChanges = function (mutations) {
								if (that.watchedElementData.forEach) {
									that.watchedElementData.forEach(function (data) {
										if (data.element.offsetWidth !== data.offsetWidth ||
											data.element.offsetHeight !== data.offsetHeight) {
											data.offsetWidth = data.element.offsetWidth;
											data.offsetHeight = data.element.offsetHeight;
											if (data.timer) {
												clearTimeout(data.timer);
											}
											data.timer = setTimeout(function () {
												if (!$.jqx.isHidden($(data.element))) {
													data.callback();
												}
												else {
													data.timer = setInterval(function () {
														if (!$.jqx.isHidden($(data.element))) {
															clearInterval(data.timer);
															data.callback();
														}
													}, 100);
												}
											});
										}
									});
								}
							};

							that.watchedElementData.push({
								element: element[0],
								offsetWidth: element[0].offsetWidth,
								offsetHeight: element[0].offsetHeight,
								callback: callback
							});
							if (!that.observer) {
								that.observer = new MutationObserver(checkForChanges);
								that.observer.observe(document.body, {
									attributes: true,
									childList: true,
									characterData: true
								});
							}
						}
					}
					catch (er) {
					}
					if ($.jqx.isHidden(element) && checkForHidden === true) {
						doResize(true);
					}
					$.jqx.resize = function () {
						doResize(null, 'resize');
					}
				},

				parseJSON: function (data) {
					if (!data || typeof data !== "string") {
						return null;
					}
					var rvalidchars = /^[\],:{}\s]*$/,
						rvalidbraces = /(?:^|:|,)(?:\s*\[)+/g,
						rvalidescape = /\\(?:["\\\/bfnrt]|u[\da-fA-F]{4})/g,
						rvalidtokens = /"[^"\\\r\n]*"|true|false|null|-?(?:\d\d*\.|)\d+(?:[eE][\-+]?\d+|)/g;

					// Make sure leading/trailing whitespace is removed (IE can't handle it)
					data = $.trim(data);

					// Attempt to parse using the native JSON parser first
					if (window.JSON && window.JSON.parse) {
						return window.JSON.parse(data);
					}

					// Make sure the incoming data is actual JSON
					// Logic borrowed from http://json.org/json2.js
					if (rvalidchars.test(data.replace(rvalidescape, "@")
						.replace(rvalidtokens, "]")
						.replace(rvalidbraces, ""))) {

						return (new Function("return " + data))();

					}
					throw new Error("Invalid JSON: " + data);
				},

				html: function (element, value) {
					if (!$(element).on || !$.access) {
						return $(element).html(value);
					}
					try {	
						return $.access(element, function (value) {
							var elem = element[0] || {},
								i = 0,
								l = element.length;

							if (value === undefined) {
								return elem.nodeType === 1 ?
									elem.innerHTML.replace(rinlinejQuery, "") :
									undefined;
							}

							var rnoInnerhtml = /<(?:script|style|link)/i,
								nodeNames = "abbr|article|aside|audio|bdi|canvas|data|datalist|details|figcaption|figure|footer|" +
									"header|hgroup|mark|meter|nav|output|progress|section|summary|time|video",
								rxhtmlTag = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\w:]+)[^>]*)\/>/gi,
								rtagName = /<([\w:]+)/,
								rnocache = /<(?:script|object|embed|option|style)/i,
								rnoshimcache = new RegExp("<(?:" + nodeNames + ")[\\s/>]", "i"),
								rleadingWhitespace = /^\s+/,
								wrapMap = {
									option: [1, "<select multiple='multiple'>", "</select>"],
									legend: [1, "<fieldset>", "</fieldset>"],
									thead: [1, "<table>", "</table>"],
									tr: [2, "<table><tbody>", "</tbody></table>"],
									td: [3, "<table><tbody><tr>", "</tr></tbody></table>"],
									col: [2, "<table><tbody></tbody><colgroup>", "</colgroup></table>"],
									area: [1, "<map>", "</map>"],
									_default: [0, "", ""]
								};

							if (typeof value === "string" && !rnoInnerhtml.test(value) &&
								($.support.htmlSerialize || !rnoshimcache.test(value)) &&
								($.support.leadingWhitespace || !rleadingWhitespace.test(value)) &&
								!wrapMap[(rtagName.exec(value) || ["", ""])[1].toLowerCase()]) {

								value = value.replace(rxhtmlTag, "<$1></$2>");

								try {
									for (; i < l; i++) {
										elem = this[i] || {};
										if (elem.nodeType === 1) {
											$.cleanData(elem.getElementsByTagName("*"));
											elem.innerHTML = value;
										}
									}

									elem = 0;
								} catch (e) { }
							}

							if (elem) {
								element.empty().append(value);
							}
						}, null, value, arguments.length);
					}
					catch (error) {
						return $(element).html(value);
					}
				},

				hasTransform: function (el) {
					var transform = "";
					transform = el.css('transform');

					if (transform == "" || transform == 'none') {
						transform = el.parents().css('transform');
						if (transform == "" || transform == 'none') {
							var browserInfo = $.jqx.utilities.getBrowser();
							if (browserInfo.browser == 'msie') {
								transform = el.css('-ms-transform');
								if (transform == "" || transform == 'none') {
									transform = el.parents().css('-ms-transform');
								}
							}
							else if (browserInfo.browser == 'chrome') {
								transform = el.css('-webkit-transform');
								if (transform == "" || transform == 'none') {
									transform = el.parents().css('-webkit-transform');
								}
							}
							else if (browserInfo.browser == 'opera') {
								transform = el.css('-o-transform');
								if (transform == "" || transform == 'none') {
									transform = el.parents().css('-o-transform');
								}
							}
							else if (browserInfo.browser == 'mozilla') {
								transform = el.css('-moz-transform');
								if (transform == "" || transform == 'none') {
									transform = el.parents().css('-moz-transform');
								}
							}
						} else {
							return transform != "" && transform != 'none';
						}
					}
					if (transform == "" || transform == 'none') {
						transform = $(document.body).css('transform');
					}
					return transform != "" && transform != 'none' && transform != null;
				},

				getBrowser: function () {
					var ua = navigator.userAgent.toLowerCase();

					var match = /(chrome)[ \/]([\w.]+)/.exec(ua) ||
						/(webkit)[ \/]([\w.]+)/.exec(ua) ||
						/(opera)(?:.*version|)[ \/]([\w.]+)/.exec(ua) ||
						/(msie) ([\w.]+)/.exec(ua) ||
						ua.indexOf("compatible") < 0 && /(mozilla)(?:.*? rv:([\w.]+)|)/.exec(ua) ||
						[];

					var obj = {
						browser: match[1] || "",
						version: match[2] || "0"
					};
					if (ua.indexOf("rv:11.0") >= 0 && ua.indexOf(".net4.0c") >= 0) {
						obj.browser = "msie";
						obj.version = "11";
						match[1] = "msie";
					}
					if (ua.indexOf("edge") >= 0) {
						obj.browser = "msie";
						obj.version = "12";
						match[1] = "msie";
					}
					obj[match[1]] = match[1];
					return obj;
				}
			});
		$.jqx.browser = $.jqx.utilities.getBrowser();
		$.jqx.isHidden = function (element) {
			if (!element || !element[0])
				return false;

			var w = element[0].offsetWidth, h = element[0].offsetHeight;
			if (w === 0 || h === 0)
				return true;
			else {
				return false;
			}
		};

		$.jqx.ariaEnabled = true;
		$.jqx.aria = function (that, property, value) {
			if (!$.jqx.ariaEnabled)
				return;

			if (property == undefined) {
				$.each(that.aria, function (index, value) {
					var attrValue = !that.base ? that.host.attr(index) : that.base.host.attr(index);
					if (attrValue != undefined && !$.isFunction(attrValue)) {
						var newValue = attrValue;
						switch (value.type) {
							case "number":
								newValue = new Number(attrValue);
								if (isNaN(newValue)) newValue = attrValue;
								break;
							case "boolean":
								newValue = attrValue == "true" ? true : false;
								break;
							case "date":
								newValue = new Date(attrValue);
								if (newValue == "Invalid Date" || isNaN(newValue)) newValue = attrValue;
								break;
						}

						that[value.name] = newValue;
					}
					else {
						var attrValue = that[value.name];
						if ($.isFunction(attrValue)) attrValue = that[value.name]();
						if (attrValue == undefined) attrValue = "";
						try {
							!that.base ? that.host.attr(index, attrValue.toString()) : that.base.host.attr(index, attrValue.toString());
						}
						catch (error) {
						}
					}
				});
			}
			else {
				try {
					if (that.host) {
						if (!that.base) {
							if (that.host) {
								if (that.element.setAttribute) {
									that.element.setAttribute(property, value.toString());
								}
								else {
									that.host.attr(property, value.toString());
								}
							}
							else {
								that.attr(property, value.toString());
							}
						}
						else {
							if (that.base.host) {
								that.base.host.attr(property, value.toString());
							}
							else {
								that.attr(property, value.toString());
							}
						}
					}
					else if (that.setAttribute) {
						that.setAttribute(property, value.toString());
					}
				}
				catch (error) {
				}
			}
		};

		if (!Array.prototype.indexOf) {
			Array.prototype.indexOf = function (elt /*, from*/) {
				var len = this.length;

				var from = Number(arguments[1]) || 0;
				from = (from < 0)
					? Math.ceil(from)
					: Math.floor(from);
				if (from < 0)
					from += len;

				for (; from < len; from++) {
					if (from in this &&
						this[from] === elt)
						return from;
				}
				return -1;
			};
		}

		$.jqx.mobile = $.jqx.mobile || {};
		$.jqx.position = function (event) {
			var left = parseInt(event.pageX);
			var top = parseInt(event.pageY);

			if ($.jqx.mobile.isTouchDevice()) {
				var touches = $.jqx.mobile.getTouches(event);
				var touch = touches[0];
				left = parseInt(touch.pageX);
				top = parseInt(touch.pageY);
			}
			return { left: left, top: top }
		}

		$.extend($.jqx.mobile,
			{
				_touchListener: function (e, me) {
					var createTouchEvent = function (name, e) {
						var event = document.createEvent('MouseEvents');

						event.initMouseEvent(
							name,
							e.bubbles,
							e.cancelable,
							e.view,
							e.detail,
							e.screenX,
							e.screenY,
							e.clientX,
							e.clientY,
							e.ctrlKey,
							e.altKey,
							e.shiftKey,
							e.metaKey,
							e.button,
							e.relatedTarget
						);
						event._pageX = e.pageX;
						event._pageY = e.pageY;

						return event;
					}

					var eventMap = { 'mousedown': 'touchstart', 'mouseup': 'touchend', 'mousemove': 'touchmove' };
					var event = createTouchEvent(eventMap[e.type], e);
					e.target.dispatchEvent(event);

					var fn = e.target['on' + eventMap[e.type]];
					if (typeof fn === 'function') fn(e);
				},

				setMobileSimulator: function (element, value) {
					if (this.isTouchDevice()) {
						return;
					}

					this.simulatetouches = true;
					if (value == false) {
						this.simulatetouches = false;
					}

					var eventMap = { 'mousedown': 'touchstart', 'mouseup': 'touchend', 'mousemove': 'touchmove' };

					var self = this;
					if (window.addEventListener) {
						var subscribeToEvents = function () {
							for (var key in eventMap) {
								if (element.addEventListener) {
									element.removeEventListener(key, self._touchListener);
									element.addEventListener(key, self._touchListener, false);
								}

								//  document.removeEventListener(key, self._touchListener);
								//  document.addEventListener(key, self._touchListener, false);
							}
						}

						if ($.jqx.browser.msie) {
							subscribeToEvents();
						}
						else {
							subscribeToEvents();
						}
					}
				},

				isTouchDevice: function () {
					if (this.touchDevice != undefined)
						return this.touchDevice;

					var txt = "Browser CodeName: " + navigator.appCodeName + "";
					txt += "Browser Name: " + navigator.appName + "";
					txt += "Browser Version: " + navigator.appVersion + "";
					txt += "Platform: " + navigator.platform + "";
					txt += "User-agent header: " + navigator.userAgent + "";

					if (navigator.maxTouchPoints > 1) {
						//return true;
					}

					if (txt.indexOf('Android') != -1)
						return true;

					if (txt.indexOf('IEMobile') != -1)
						return true;

					if (txt.indexOf('Windows Phone') != -1)
						return true;

					if (txt.indexOf('WPDesktop') != -1)
						return true;

					if (txt.indexOf('ZuneWP7') != -1)
						return true;

					if (txt.indexOf('BlackBerry') != -1 && txt.indexOf('Mobile Safari') != -1)
						return true;

					if (txt.indexOf('ipod') != -1)
						return true;

					if (txt.indexOf('nokia') != -1 || txt.indexOf('Nokia') != -1)
						return true;

					if (txt.indexOf('Chrome/17') != -1)
						return false;

					if (txt.indexOf('CrOS') != -1)
						return false;

					if (txt.indexOf('Opera') != -1 && txt.indexOf('Mobi') == -1 && txt.indexOf('Mini') == -1 && txt.indexOf('Platform: Win') != -1) {
						return false;
					}

					if (txt.indexOf("HybridDeviceTouch") != -1) {
						return true
					}

					if (txt.indexOf("HybridDeviceMouse") != -1) {
						return false
					}

					if (txt.indexOf('Opera') != -1 && txt.indexOf('Mobi') != -1 && txt.indexOf('Opera Mobi') != -1) {
						return true;
					}

					if (txt.indexOf('Mozilla/5.0 (X11; Linux x86_64)') != -1) {
						return false;
					}

					var deviceTypes = {
						ios: 'i(?:Pad|Phone|Pod)(?:.*)CPU(?: iPhone)? OS ',
						android: '(Android |HTC_|Silk/)',
						blackberry: 'BlackBerry(?:.*)Version\/',
						rimTablet: 'RIM Tablet OS ',
						webos: '(?:webOS|hpwOS)\/',
						bada: 'Bada\/'
					}

					// check for IPad, IPhone, IE and Chrome
					try {
						if (this.touchDevice != undefined)
							return this.touchDevice;

						this.touchDevice = false;
						for (var i in deviceTypes) {
							if (deviceTypes.hasOwnProperty(i)) {
								var prefix = deviceTypes[i];
								var match = txt.match(new RegExp('(?:' + prefix + ')([^\\s;]+)'));
								if (match) {
									if (i.toString() == "blackberry") {
										// handle touches through mouse pointer.
										this.touchDevice = false;
										return false;
									}

									this.touchDevice = true;
									return true;
								}
							}
						}

						var userAgent = navigator.userAgent;
						if (navigator.platform.toLowerCase().indexOf('win') != -1) {
							if (userAgent.indexOf('Windows Phone') >= 0 || userAgent.indexOf('WPDesktop') >= 0 || userAgent.indexOf('IEMobile') >= 0 || userAgent.indexOf('ZuneWP7') >= 0) {
								this.touchDevice = true;
								return true;
							}
							else {
								if (userAgent.indexOf('Touch') >= 0) {
									var supported = ('MSPointerDown' in window) || ('pointerdown' in window);
									if (supported) {
										this.touchDevice = true;
										return true;
									}
									if (userAgent.indexOf('ARM') >= 0) {
										this.touchDevice = true;
										return true;
									}

									this.touchDevice = false;
									return false;
								}
							}
						}

						if (navigator.platform.toLowerCase().indexOf('win') != -1) {
							this.touchDevice = false;
							return false;
						}
						if (('ontouchstart' in window) || window.DocumentTouch && document instanceof DocumentTouch) {
							this.touchDevice = true;
						}
						return this.touchDevice;
					} catch (e) {
						this.touchDevice = false;
						return false;
					}
				},

				getLeftPos: function (inputObj) {
					var returnValue = inputObj.offsetLeft;
					while ((inputObj = inputObj.offsetParent) != null) {
						if (inputObj.tagName != 'HTML') {
							returnValue += inputObj.offsetLeft;
							if (document.all) returnValue += inputObj.clientLeft;
						}
					}
					return returnValue;
				},

				getTopPos: function (inputObj) {
					var returnValue = inputObj.offsetTop;
					var initialOffset = $(inputObj).coord();
					while ((inputObj = inputObj.offsetParent) != null) {
						if (inputObj.tagName != 'HTML') {
							returnValue += (inputObj.offsetTop - inputObj.scrollTop);
							if (document.all) returnValue += inputObj.clientTop;
						}
					}
					var agent = navigator.userAgent.toLowerCase();
					var wp8 = (agent.indexOf('windows phone') != -1 || agent.indexOf('WPDesktop') != -1 || agent.indexOf('ZuneWP7') != -1 || agent.indexOf('msie 9') != -1 || agent.indexOf('msie 11') != -1 || agent.indexOf('msie 10') != -1) && agent.indexOf('touch') != -1;
					if (wp8) {
						return initialOffset.top;
					}

					if (this.isSafariMobileBrowser()) {
						if (this.isSafari4MobileBrowser() && this.isIPadSafariMobileBrowser()) {
							return returnValue;
						}
						if (agent.indexOf('version/7') != -1) {
							return initialOffset.top;
						}
						if (agent.indexOf('version/6') != -1 || agent.indexOf('version/5') != -1) {
							returnValue = returnValue + $(window).scrollTop();
						}
						if (/(Android.*Chrome\/[.0-9]* (!?Mobile))/.exec(navigator.userAgent)) {
							 return returnValue;
					//       return returnValue + $(window).scrollTop();
						}
						if (/(Android.*Chrome\/[.0-9]* Mobile)/.exec(navigator.userAgent)) {
							return returnValue;
					//        return returnValue + $(window).scrollTop();
						}

						return initialOffset.top;
					}

					return returnValue;
				},

				isChromeMobileBrowser: function () {
					var agent = navigator.userAgent.toLowerCase();
					var result = agent.indexOf('android') != -1;
					return result;
				},

				isOperaMiniMobileBrowser: function () {
					var agent = navigator.userAgent.toLowerCase();
					var result = agent.indexOf('opera mini') != -1 || agent.indexOf('opera mobi') != -1;
					return result;
				},

				isOperaMiniBrowser: function () {
					var agent = navigator.userAgent.toLowerCase();
					var result = agent.indexOf('opera mini') != -1;
					return result;
				},

				isNewSafariMobileBrowser: function () {
					var agent = navigator.userAgent.toLowerCase();
					var result = agent.indexOf('ipad') != -1 || agent.indexOf('iphone') != -1 || agent.indexOf('ipod') != -1;
					result = result && (agent.indexOf('version/5') != -1);
					return result;
				},

				isSafari4MobileBrowser: function () {
					var agent = navigator.userAgent.toLowerCase();
					var result = agent.indexOf('ipad') != -1 || agent.indexOf('iphone') != -1 || agent.indexOf('ipod') != -1;
					result = result && (agent.indexOf('version/4') != -1);
					return result;
				},

				isWindowsPhone: function () {
					var agent = navigator.userAgent.toLowerCase();
					var result = (agent.indexOf('windows phone') != -1 || agent.indexOf('WPDesktop') != -1 || agent.indexOf('ZuneWP7') != -1 || agent.indexOf('msie 9') != -1 || agent.indexOf('msie 11') != -1 || agent.indexOf('msie 10') != -1 && agent.indexOf('touch') != -1);
					return result;
				},

				isSafariMobileBrowser: function () {
					var agent = navigator.userAgent.toLowerCase();
					if (/(Android.*Chrome\/[.0-9]* (!?Mobile))/.exec(navigator.userAgent)) {
						return true;
					}
					if (/(Android.*Chrome\/[.0-9]* Mobile)/.exec(navigator.userAgent)) {
						return true;
					}

					var result = agent.indexOf('ipad') != -1 || agent.indexOf('iphone') != -1 || agent.indexOf('ipod') != -1 || agent.indexOf('mobile safari') != -1;
					return result;
				},

				isIPadSafariMobileBrowser: function () {
					var agent = navigator.userAgent.toLowerCase();
					var result = agent.indexOf('ipad') != -1;
					return result;
				},

				isMobileBrowser: function () {
					var agent = navigator.userAgent.toLowerCase();
					var result = agent.indexOf('ipad') != -1 || agent.indexOf('iphone') != -1 || agent.indexOf('android') != -1;
					return result;
				},

				// Get the touch points from this event
				getTouches: function (e) {
					if (e.originalEvent) {
						if (e.originalEvent.touches && e.originalEvent.touches.length) {
							return e.originalEvent.touches;
						} else if (e.originalEvent.changedTouches && e.originalEvent.changedTouches.length) {
							return e.originalEvent.changedTouches;
						}
					}

					if (!e.touches) {
						e.touches = new Array();
						e.touches[0] = e.originalEvent != undefined ? e.originalEvent : e;

						if (e.originalEvent != undefined && e.pageX)
							e.touches[0] = e;
						if (e.type == 'mousemove') e.touches[0] = e;
					}

					return e.touches;
				},

				getTouchEventName: function (name) {
					if (this.isWindowsPhone()) {

						var agent = navigator.userAgent.toLowerCase();
						if (agent.indexOf('windows phone 7') != -1) {
							if (name.toLowerCase().indexOf('start') != -1) return 'MSPointerDown';
							if (name.toLowerCase().indexOf('move') != -1) return 'MSPointerMove';
							if (name.toLowerCase().indexOf('end') != -1) return 'MSPointerUp';
						}
						if (name.toLowerCase().indexOf('start') != -1) return 'pointerdown';
						if (name.toLowerCase().indexOf('move') != -1) return 'pointermove';
						if (name.toLowerCase().indexOf('end') != -1) return 'pointerup';
					}
					else {
						return name;
					}
				},

				// Dispatches a fake mouse event from a touch event
				dispatchMouseEvent: function (name, touch, target) {
					if (this.simulatetouches)
						return;

					var e = document.createEvent('MouseEvent');
					e.initMouseEvent(name, true, true, touch.view, 1, touch.screenX, touch.screenY, touch.clientX, touch.clientY, false, false, false, false, 0, null);
					if (target != null) {
						target.dispatchEvent(e);
					}
				},

				// Find the root node of this target
				getRootNode: function (target) {
					while (target.nodeType !== 1) {
						target = target.parentNode;
					}
					return target;
				},

				setTouchScroll: function (enable, key) {
					if (!this.enableScrolling) this.enableScrolling = [];
					this.enableScrolling[key] = enable;
				},

				touchScroll: function (element, scrollHeight, callback, key, horizontalScroll, verticalScroll) {
					if (element == null)
						return;

					var me = this;
					var scrollY = 0;
					var touchY = 0;
					var movedY = 0;
					var scrollX = 0;
					var touchX = 0;
					var movedX = 0;
					if (!this.scrolling) this.scrolling = [];
					this.scrolling[key] = false;
					var moved = false;
					var $element = $(element);
					var touchTags = ['select', 'input', 'textarea'];
					var touchStart = 0;
					var touchEnd = 0;
					if (!this.enableScrolling) this.enableScrolling = [];
					this.enableScrolling[key] = true;
					var key = key;
					var touchStartName = this.getTouchEventName('touchstart') + ".touchScroll";
					var touchEndName = this.getTouchEventName('touchend') + ".touchScroll";
					var touchMoveName = this.getTouchEventName('touchmove') + ".touchScroll";

					//            horizontalScroll.fadeOut(0);
					//            verticalScroll.fadeOut(0);

					var view, indicator, relative, xframe, xdelta,
						xmax, min, max, offset, reference, pressed, xform,
						jqxAnimations, xjqxAnimations, frame, timestamp, ticker,
						amplitude, target, xtarget, xreference, timeConstant;
					max = scrollHeight;
					var min = 0;
					var offset = 0;
					var xoffset = 0;
					var initialOffset = 0;
					var initialXOffset = 0;
					var xmax = horizontalScroll.jqxScrollBar('max');
					var timeConstant = 325; // ms

					function ypos(e) {
						// touch event
						if (e.targetTouches && (e.targetTouches.length >= 1)) {
							return e.targetTouches[0].clientY;
						}
						else if (e.originalEvent && e.originalEvent.clientY !== undefined) {
							return e.originalEvent.clientY;
						}
						else {
							var touches = me.getTouches(e);
							return touches[0].clientY;
						}

						// mouse event
						//    return e.clientY;
					}

					function xpos(e) {
						// touch event
						if (e.targetTouches && (e.targetTouches.length >= 1)) {
							return e.targetTouches[0].clientX;
						}
						else if (e.originalEvent && e.originalEvent.clientX !== undefined) {
							return e.originalEvent.clientX;
						}
						else {
							var touches = me.getTouches(e);
							return touches[0].clientX;
						}

						// mouse event
						//   return e.clientX;
					}

					var track = function () {
						var now, elapsed, delta, v;

						now = Date.now();
						elapsed = now - timestamp;
						timestamp = now;
						delta = offset - frame;
						var xdelta = xoffset - xframe;
						frame = offset;
						xframe = xoffset;
						pressed = true;
						v = 1000 * delta / (1 + elapsed);
						var xv = 1000 * xdelta / (1 + elapsed);
						jqxAnimations = 0.8 * v + 0.2 * jqxAnimations;
						xjqxAnimations = 0.8 * xv + 0.2 * xjqxAnimations;
					}

					var tapped = false;

					var touchStart = function (event) {
						if (!me.enableScrolling[key])
							return true;

						// Allow certain HTML tags to receive touch events
						if ($.inArray(event.target.tagName.toLowerCase(), touchTags) !== -1) {
							return;
						}
						offset = verticalScroll.jqxScrollBar('value');
						xoffset = horizontalScroll.jqxScrollBar('value');

						var touches = me.getTouches(event);
						var touch = touches[0];
						if (touches.length == 1) {
							me.dispatchMouseEvent('mousedown', touch, me.getRootNode(touch.target));
						}
						xmax = horizontalScroll.jqxScrollBar('max');
						max = verticalScroll.jqxScrollBar('max');
						function tap(e) {
							tapped = false;
							pressed = true;
							reference = ypos(e);
							xreference = xpos(e);
							jqxAnimations = amplitude = xjqxAnimations = 0;
							frame = offset;
							xframe = xoffset;
							timestamp = Date.now();
							clearInterval(ticker);
							ticker = setInterval(track, 100);
							initialOffset = offset;
							initialXOffset = xoffset;

							if (offset > 0 && offset < max && verticalScroll[0].style.visibility != "hidden") {
								//      e.preventDefault();
							}
							//    if (xoffset > 0 && xoffset < xmax && horizontalScroll[0].style.visibility != "hidden") {
							//        e.preventDefault();

							//      e.stopPropagation();
							//   e.stopPropagation();
							// return false;
						}

						tap(event);
						moved = false;
						touchY = touch.pageY;
						touchX = touch.pageX;
						if (me.simulatetouches) {
							if (touch._pageY != undefined) {
								touchY = touch._pageY;
								touchX = touch._pageX;
							}
						}
						me.scrolling[key] = true;
						scrollY = 0;
						scrollX = 0;
						return true;
					}

					if ($element.on) {
						$element.on(touchStartName, touchStart);
					}
					else {
						$element.bind(touchStartName, touchStart);
					}

					var scroll = function (top, event) {
						offset = (top > max) ? max : (top < min) ? min : top;
						callback(null, top, 0, 0, event);

						return (top > max) ? "max" : (top < min) ? "min" : "value";
					}

					var hscroll = function (left, event) {
						xoffset = (left > xmax) ? xmax : (left < min) ? min : left;
						callback(left, null, 0, 0, event);

						return (left > xmax) ? "max" : (left < min) ? "min" : "value";
					}

					function autoScroll() {
						var elapsed, delta;
						if (amplitude) {
							elapsed = Date.now() - timestamp;
							delta = -amplitude * Math.exp(-elapsed / timeConstant);
							if (delta > 0.5 || delta < -0.5) {
								scroll(target + delta);
								requestAnimationFrame(autoScroll);
							} else {
								scroll(target);
								//     verticalScroll.fadeOut('fast');
							}
						}
					}
					function hAutoScroll() {
						var elapsed, delta;
						if (amplitude) {
							elapsed = Date.now() - timestamp;
							delta = -amplitude * Math.exp(-elapsed / timeConstant);
							if (delta > 0.5 || delta < -0.5) {
								hscroll(xtarget + delta);
								requestAnimationFrame(hAutoScroll);
							} else {
								hscroll(xtarget);
								//        horizontalScroll.fadeOut('fast');
							}

						}
					}
					var touchMove = function (event) {
						if (!me.enableScrolling[key])
							return true;

						if (!me.scrolling[key]) {
							return true;
						}

						if (tapped) {
							event.preventDefault();
							event.stopPropagation();
						}

						var touches = me.getTouches(event);
						if (touches.length > 1) {
							return true;
						}

						var pageY = touches[0].pageY;
						var pageX = touches[0].pageX;

						if (me.simulatetouches) {
							if (touches[0]._pageY != undefined) {
								pageY = touches[0]._pageY;
								pageX = touches[0]._pageX;
							}
						}


						var dy = pageY - touchY;
						var dx = pageX - touchX;
						touchEnd = pageY;
						var touchHorizontalEnd = pageX;
						movedY = dy - scrollY;
						movedX = dx - scrollX;
						moved = true;
						scrollY = dy;
						scrollX = dx;

						var hScrollVisible = horizontalScroll != null ? horizontalScroll[0].style.visibility != 'hidden' : true;
						var vScrollVisible = verticalScroll != null ? verticalScroll[0].style.visibility != 'hidden' : true;


						function drag(e) {
							var y, delta, x;
							if (pressed) {
								y = ypos(e);
								x = xpos(e);
								delta = reference - y;
								xdelta = xreference - x;
								var dragged = "value";
								if (delta > 2 || delta < -2) {
									reference = y;
									dragged = scroll(offset + delta, e);
									track();

									if (dragged == "min" && initialOffset === 0) {
										return true;
									}
									if (dragged == "max" && initialOffset === max) {
										return true;
									}

									if (!vScrollVisible) {
										return true;
									}
									e.preventDefault();
									e.stopPropagation();
									tapped = true;

									return false;
								}
								else {
									if (xdelta > 2 || xdelta < -2) {
										xreference = x;
										dragged = hscroll(xoffset + xdelta, e);
										track();

										if (dragged == "min" && initialXOffset === 0) {
											return true;
										}
										if (dragged == "max" && initialXOffset === xmax) {
											return true;
										}

										if (!hScrollVisible) {
											return true;
										}
										tapped = true;
										e.preventDefault();
										e.stopPropagation();
										return false;
									}
								}
								e.preventDefault();
							}
						}

						if (hScrollVisible || vScrollVisible) {
							if ((hScrollVisible) || (vScrollVisible)) {
								drag(event);

								//      callback(-movedX * 1, -movedY * 1, dx, dy, event);
								//event.preventDefault();
								//event.stopPropagation();
								//if (event.preventManipulation) {
								//    event.preventManipulation();
								//}
								//return false;
							}
						}
					}

					if ($element.on) {
						$element.on(touchMoveName, touchMove);
					}
					else $element.bind(touchMoveName, touchMove);



					var touchCancel = function (event) {
						if (!me.enableScrolling[key])
							return true;

						var touch = me.getTouches(event)[0];
						if (!me.scrolling[key]) {
							return true;
						}

						pressed = false;
						clearInterval(ticker);
						if (jqxAnimations > 10 || jqxAnimations < -10) {
							amplitude = 0.8 * jqxAnimations;
							target = Math.round(offset + amplitude);
							timestamp = Date.now();
							requestAnimationFrame(autoScroll);
							//             verticalScroll.fadeIn(100);
						}
						else if (xjqxAnimations > 10 || xjqxAnimations < -10) {
							amplitude = 0.8 * xjqxAnimations;
							xtarget = Math.round(xoffset + amplitude);
							timestamp = Date.now();
							requestAnimationFrame(hAutoScroll);
							//          horizontalScroll.fadeIn(100);
						}
						else {
							//        horizontalScroll.fadeOut(100);
							//        verticalScroll.fadeOut(100);
						}

						me.scrolling[key] = false;
						if (moved) {
							me.dispatchMouseEvent('mouseup', touch, event.target);
						} else {
							var touch = me.getTouches(event)[0],
								t = me.getRootNode(touch.target);

							//        event.preventDefault();
							//         event.stopPropagation();
							// Dispatch fake mouse up and click events if this touch event did not move
							me.dispatchMouseEvent('mouseup', touch, t);
							me.dispatchMouseEvent('click', touch, t);
							return true;
						}
					}

					if (this.simulatetouches) {
						var windowBindFunc = $(window).on != undefined || $(window).bind;
						var windowMouseUp = function (event) {
							try {
								touchCancel(event);
							}
							catch (er) {
							}
							me.scrolling[key] = false;
						};
						$(window).on != undefined ? $(document).on('mouseup.touchScroll', windowMouseUp) : $(document).bind('mouseup.touchScroll', windowMouseUp);

						if (window.frameElement) {
							if (window.top != null) {
								var eventHandle = function (event) {
									try {
										touchCancel(event);
									}
									catch (er) {
									}
									me.scrolling[key] = false;
								};

								if (window.top.document) {
									$(window.top.document).on ? $(window.top.document).on('mouseup', eventHandle) : $(window.top.document).bind('mouseup', eventHandle);
								}
							}
						}

						var docBindFunc = $(document).on != undefined || $(document).bind;
						var touchEndFunc = function (event) {
							if (!me.scrolling[key]) {
								return true;
							}

							me.scrolling[key] = false;
							var touch = me.getTouches(event)[0],
								target = me.getRootNode(touch.target);

							// Dispatch fake mouse up and click events if this touch event did not move
							me.dispatchMouseEvent('mouseup', touch, target);
							me.dispatchMouseEvent('click', touch, target);
						};

						$(document).on != undefined ? $(document).on('touchend', touchEndFunc) : $(document).bind('touchend', touchEndFunc);
					}

					if ($element.on) {
						$element.on('dragstart', function (event) {
							event.preventDefault();
						});
						$element.on('selectstart', function (event) {
							event.preventDefault();
						});
					}
					$element.on ? $element.on(touchEndName + ' touchcancel.touchScroll', touchCancel) : $element.bind(touchEndName + ' touchcancel.touchScroll', touchCancel);
				}

			});

		$.jqx.cookie = $.jqx.cookie || {};
		$.extend($.jqx.cookie,
			{
				cookie: function (key, value, options) {
					// set cookie.
					if (arguments.length > 1 && String(value) !== "[object Object]") {
						options = $.extend({}, options);

						if (value === null || value === undefined) {
							options.expires = -1;
						}

						if (typeof options.expires === 'number') {
							var days = options.expires, t = options.expires = new Date();
							t.setDate(t.getDate() + days);
						}

						value = String(value);

						return (document.cookie = [
							encodeURIComponent(key), '=',
							options.raw ? value : encodeURIComponent(value),
							options.expires ? '; expires=' + options.expires.toUTCString() : '', // use expires attribute, max-age is not supported by IE
							options.path ? '; path=' + options.path : '',
							options.domain ? '; domain=' + options.domain : '',
							options.secure ? '; secure' : ''
						].join(''));
					}
					// get cookie...
					options = value || {};
					var result, decode = options.raw ? function (s) { return s; } : decodeURIComponent;
					return (result = new RegExp('(?:^|; )' + encodeURIComponent(key) + '=([^;]*)').exec(document.cookie)) ? decode(result[1]) : null;
				}
			});

		// stringutilities
		$.jqx.string = $.jqx.string || {};
		$.extend($.jqx.string,
			{
				replace: function (text, stringToFind, stringToReplace) {
					if (stringToFind === stringToReplace) return this;
					var temp = text;
					var index = temp.indexOf(stringToFind);
					while (index != -1) {
						temp = temp.replace(stringToFind, stringToReplace);
						index = temp.indexOf(stringToFind);
					}
					return temp;
				},

				contains: function (fullString, value) {
					if (fullString == null || value == null)
						return false;

					return fullString.indexOf(value) != -1;
				},

				containsIgnoreCase: function (fullString, value) {
					if (fullString == null || value == null)
						return false;

					return fullString.toString().toUpperCase().indexOf(value.toString().toUpperCase()) != -1;
				},

				equals: function (fullString, value) {
					if (fullString == null || value == null)
						return false;

					fullString = this.normalize(fullString);

					if (value.length == fullString.length) {
						return fullString.slice(0, value.length) == value;
					}

					return false;
				},

				equalsIgnoreCase: function (fullString, value) {
					if (fullString == null || value == null)
						return false;

					fullString = this.normalize(fullString);

					if (value.length == fullString.length) {
						return fullString.toUpperCase().slice(0, value.length) == value.toUpperCase();
					}

					return false;
				},

				startsWith: function (fullString, value) {
					if (fullString == null || value == null)
						return false;

					return fullString.slice(0, value.length) == value;
				},

				startsWithIgnoreCase: function (fullString, value) {
					if (fullString == null || value == null)
						return false;

					return fullString.toUpperCase().slice(0, value.length) == value.toUpperCase();
				},

				normalize: function (fullString) {
					if (fullString.charCodeAt(fullString.length - 1) == 65279) {
						fullString = fullString.substring(0, fullString.length - 1);
					}

					return fullString;
				},

				endsWith: function (fullString, value) {
					if (fullString == null || value == null)
						return false;

					fullString = this.normalize(fullString);
					return fullString.slice(-value.length) == value;
				},

				endsWithIgnoreCase: function (fullString, value) {
					if (fullString == null || value == null)
						return false;

					fullString = this.normalize(fullString);

					return fullString.toUpperCase().slice(-value.length) == value.toUpperCase();
				}
			});

		$.extend($.easing, {
			easeOutBack: function (x, t, b, c, d, s) {
				if (s == undefined) s = 1.70158;
				return c * ((t = t / d - 1) * t * ((s + 1) * t + s) + 1) + b;
			},
			easeInQuad: function (x, t, b, c, d) {
				return c * (t /= d) * t + b;
			},
			easeInOutCirc: function (x, t, b, c, d) {
				if ((t /= d / 2) < 1) return -c / 2 * (Math.sqrt(1 - t * t) - 1) + b;
				return c / 2 * (Math.sqrt(1 - (t -= 2) * t) + 1) + b;
			},
			easeInOutSine: function (x, t, b, c, d) {
				return -c / 2 * (Math.cos(Math.PI * t / d) - 1) + b;
			},
			easeInCubic: function (x, t, b, c, d) {
				return c * (t /= d) * t * t + b;
			},
			easeOutCubic: function (x, t, b, c, d) {
				return c * ((t = t / d - 1) * t * t + 1) + b;
			},
			easeInOutCubic: function (x, t, b, c, d) {
				if ((t /= d / 2) < 1) return c / 2 * t * t * t + b;
				return c / 2 * ((t -= 2) * t * t + 2) + b;
			},
			easeInSine: function (x, t, b, c, d) {
				return -c * Math.cos(t / d * (Math.PI / 2)) + c + b;
			},
			easeOutSine: function (x, t, b, c, d) {
				return c * Math.sin(t / d * (Math.PI / 2)) + b;
			},
			easeInOutSine: function (x, t, b, c, d) {
				return -c / 2 * (Math.cos(Math.PI * t / d) - 1) + b;
			}
		});
	})(jqxBaseFramework);

	(function ($) {
		if ($.event && $.event.special) {
			$.extend($.event.special,
				{
					"close": { noBubble: true },
					"open": { noBubble: true },
					"cellclick": { noBubble: true },
					"rowclick": { noBubble: true },
					"tabclick": { noBubble: true },
					"selected": { noBubble: true },
					"expanded": { noBubble: true },
					"collapsed": { noBubble: true },
					"valuechanged": { noBubble: true },
					"expandedItem": { noBubble: true },
					"collapsedItem": { noBubble: true },
					"expandingItem": { noBubble: true },
					"collapsingItem": { noBubble: true }
				});
		}
		if ($.fn.extend) {
			$.fn.extend({
				ischildof: function (filter_string) {
					if (!$(this).parents) {
						var result = filter_string.element.contains(this.element)
						return result;
					}

					var parents = $(this).parents().get();

					for (var j = 0; j < parents.length; j++) {
						if (typeof filter_string != "string") {
							var parent = parents[j];
							if (filter_string !== undefined) {
								if (parent == filter_string[0])
									return true;
							}
						}
						else {
							if (filter_string !== undefined) {
								if ($(parents[j]).is(filter_string)) {
									return true;
								}
							}
						}
					}

					return false;
				}
			});
		}

		$.fn.jqxProxy = function () {
			var widget = $(this).data().jqxWidget;
			var args = Array.prototype.slice.call(arguments, 0);
			var element = widget.element;
			if (!element) element = widget.base.element;
			return $.jqx.jqxWidgetProxy(widget.widgetName, element, args);
		}

		var originalVal = $.originalVal = $.fn.val;
		$.fn.val = function (value) {
			if (typeof value == 'undefined') {
				if ($(this).hasClass('jqx-widget') || $(this).hasClass('jqx-input-group')) {
					var widget = $(this).data().jqxWidget;
					if (widget && widget.val) {
						return widget.val();
					}
				}
				if (this[0] && this[0].tagName.toLowerCase().indexOf('angular') >= 0) {
					var widget = $(this).find('.jqx-widget').data().jqxWidget;
					if (widget && widget.val) {
						return widget.val();
					}

				}
				return originalVal.call(this);
			}
			else {
				if ($(this).hasClass('jqx-widget') || $(this).hasClass('jqx-input-group')) {
					var widget = $(this).data().jqxWidget;
					if (widget && widget.val) {
						if (arguments.length != 2) {
							return widget.val(value);
						}
						else {
							return widget.val(value, arguments[1]);
						}
					}
				}
				if (this[0] && this[0].tagName.toLowerCase().indexOf('angular') >= 0) {
					var widget = $(this).find('.jqx-widget').data().jqxWidget;
					if (widget && widget.val) {
						if (arguments.length != 2) {
							return widget.val(value);
						}
						else {
							return widget.val(value, arguments[1]);
						}
					}

				}

				return originalVal.call(this, value);
			}
		};

		if ($.fn.modal && $.fn.modal.Constructor) {
			$.fn.modal.Constructor.prototype.enforceFocus = function () {
				$(document)
					.off('focusin.bs.modal') // guard against infinite focus loop
					.on('focusin.bs.modal', $.proxy(function (e) {
						if (this.$element[0] !== e.target && !this.$element.has(e.target).length) {
							if ($(e.target).parents().hasClass('jqx-popup'))
								return true;
							this.$element.trigger('focus')
						}
					}, this));
			}
		}

		$.fn.coord = function (options) {
			var docElem, win,
				box = { top: 0, left: 0 },
				elem = this[0],
				doc = elem && elem.ownerDocument;
			if (!doc) {
				return;
			}
			docElem = doc.documentElement;
			if (!$.contains(docElem, elem)) {
				return box;
			}
			if (typeof elem.getBoundingClientRect !== undefined) {
				box = elem.getBoundingClientRect();
			}
			var getWindow = function (elem) {
				return $.isWindow(elem) ?
					elem :
					elem.nodeType === 9 ?
						elem.defaultView || elem.parentWindow :
						false;
			};

			win = getWindow(doc);
			var additionalLeftOffset = 0;
			var additionalTopOffset = 0;
			var agent = navigator.userAgent.toLowerCase();
			var result = agent.indexOf('ipad') != -1 || agent.indexOf('iphone') != -1;
			if (result) {
				// fix for iphone/ipad left offsets.
				additionalLeftOffset = 2;
			}
			if (true == options) {
				if (document.body.style.position != 'static' && document.body.style.position != '') {
					var coords = $(document.body).coord();
					additionalLeftOffset = -coords.left;
					additionalTopOffset = -coords.top;
				}
			}

			return {
				top: additionalTopOffset + box.top + (win.pageYOffset || docElem.scrollTop) - (docElem.clientTop || 0),
				left: additionalLeftOffset + box.left + (win.pageXOffset || docElem.scrollLeft) - (docElem.clientLeft || 0)
			};
		};

		$.jqx.ripplers = [];
		$.jqx.ripple = function (element, hostElement, hostElementType) {
			if (!hostElement) {
				hostElement = element;
			}

			var rippler = $(element);
			var mouseCaptured = false;

			rippler.append("<span class='ink'></span>");
			var ink = rippler.find('.ink');


			var hasRippler = false;

			for (var i = 0; i < $.jqx.ripplers.length; i++) {
				var ripplerItem = $.jqx.ripplers[i];

				if (ripplerItem.element[0] === element[0]) {
					hasRippler = true;
					break;
				}
			}

			if (!hasRippler) {
				$.jqx.ripplers.push({ ink: ink, element: element, hostElement: hostElement, hostElementType: hostElementType });
			}

			if (hostElementType === "checkbox" || hostElementType === "radiobutton") {

				// set .ink diametr
				var d = Math.max(rippler.outerWidth(), rippler.outerHeight());
				ink.css({ height: d, width: d });

				var x = rippler.width() / 2 - ink.width() / 2;
				var y = rippler.height() / 2 - ink.height() / 2;

				// set .ink position and add class .animate
				ink.css({
					top: y + 'px',
					left: x + 'px'
				});
			}

			// Ripple-effect animation
			if ($.jqx.ripplers.length === 1) {
				$(document).on('mouseup', function (e) {
					$.jqx.ripple.mouseCaptured = false;

					for (var i = 0; i < $.jqx.ripplers.length; i++) {
						var rippler = $.jqx.ripplers[i];

						rippler.ink.removeClass('active');
						rippler.element.removeClass('active');

						if (hostElementType !== "checkbox" && hostElementType !== "radiobutton") {
							if (rippler.ink.hasClass('animate')) {
								rippler.ink.removeClass('animate');
							}
						}
					}
				});
			}
			hostElement.off('mousedown.ripple');
			hostElement.on('mousedown.ripple', function (e) {
				var rippler = $(element);

				$.jqx.ripple.mouseCaptured = true;

				setTimeout(function () {
					// create .ink element if it doesn't exist

					if (rippler.find('.ink').length == 0) {
						rippler.append("<span class='ink'></span>");
					}

					var ink = rippler.find('.ink');

					// prevent quick double clicks
					ink.removeClass('animate');


					// set .ink diametr
					if (!ink.height() && !ink.width()) {
						var d = Math.max(rippler.outerWidth(), rippler.outerHeight());
						ink.css({ height: d, width: d });
					}

					if (hostElementType === "checkbox" || hostElementType === "radiobutton") {
						if (hostElementType === "checkbox") {
							if (hostElement.jqxCheckBox('disabled')) {
								return;
							}
						}

						if (hostElementType === "radiobutton") {
							if (hostElement.jqxRadioButton('disabled')) {
								return;
							}
						}

						// get click coordinates
						var x = rippler.width() / 2 - ink.width() / 2;
						var y = rippler.height() / 2 - ink.height() / 2;

						// set .ink position and add class .animate
						ink.css({
							top: y + 'px',
							left: x + 'px'
						}).addClass('animate');

						ink.on('animationend', function () {
							if ($.jqx.ripple.mouseCaptured) {
								ink.removeClass('animate')
								ink.addClass('active')
								element.addClass('active')
							}
						});

						return;
					}

					// get click coordinates
					var x = e.pageX - rippler.offset().left - ink.width() / 2;
					var y = e.pageY - rippler.offset().top - ink.height() / 2;

					// set .ink position and add class .animate
					ink.css({
						top: y + 'px',
						left: x + 'px'
					}).addClass('animate');
				});
			});
		}
	})(jqxBaseFramework);
})();




/***/ }),

/***/ 3907:
/***/ (() => {

﻿/* tslint:disable */
/* eslint-disable */
(function(){
	if (typeof document === 'undefined') { 
		return;
	}

(function ($) {
    var ArrayExporter = (function () {

        var exportModules = {},
            data, dataFields, styles, exporter, stylesArray, hierarchy, exportFormat, filename;

        function exportData(exporter, data, dataFields, styles, hierarchy, exportFormat, filename) {
            var that = this;

            if (!that) {
                that = window.jqx;
            }

            that.hierarchy = hierarchy;
            that.exportFormat = exportFormat;
            that.filename = filename;

            exporter.beginFile(filename);
            exportHeader(exporter);
            exportContent(exporter);
            exporter.endFile(filename);
            return exporter.getFile();
        }

        function exportHeader(exporter) {
            var exportHeaders = true;
            $.each(dataFields, function () {
                if (this.hidden) {
                    exportHeaders = false;
                    return false;
                }
            });

            exporter.beginHeader(exportHeaders);
            var index = 0;
            for (var cellContent in dataFields) {
                if (dataFields[cellContent].columnsDataFields) {
                    cellContent = dataFields[cellContent].columnsDataFields[index].displayfield;
                }
                var style = getHeaderStyle(cellContent, dataFields[cellContent]);
                exporter.appendHeaderCell(dataFields[cellContent], cellContent, style, exportHeaders, index);
                index++;
            }
            exporter.endHeader(exportHeaders);
        }

        function exportContent(exporter) {
            var that = this;

            if (!that) {
                that = window.jqx;
            }

            exporter.beginBody();
            if (that.hierarchy) {
                var exporHierarchy = function (data) {
                    for (var i = 0; i < data.length; i += 1) {
                        if (data[i] !== undefined) {
                            exporter.hierarchy = true;
                            exporter.beginRow(data[i].level);
                            exportRow(exporter, data[i], i, true);
                            if (data[i].records) {
                                exporter.beginRows(data[i].level);
                                exporHierarchy(data[i].records);
                                exporter.endRows(data[i].level);
                            }
                            exporter.endRow(data[i].level);
                        }
                    }
                }
                exporHierarchy(data);
                exporter.endBody();
                return;
            }

            for (var i = 0; i < data.length; i += 1) {
                if (data[i] !== undefined) {
                    exportRow(exporter, data[i], i);
                }
            }
            exporter.endBody();
        }

        function exportRow(exporter, data, rowId, hierarchy) {
            var that = this;

            if (!that) {
                that = window.jqx;
            }

            var style;
            if (hierarchy != true) {
                exporter.beginRow();
            }
            var indx = 0;
            for (var column in dataFields) {
                if (dataFields[column].columnsDataFields) {
                    column = dataFields[column].columnsDataFields[indx].displayfield;
                }

                style = getRowCellStyle(rowId, column);
                if (style) {
                    if (style.level != undefined) {
                        if (style.index - 1 > data.level && style.index - 1 < style.maxLevel) {
                            indx++;
                            continue;
                        }
                    }
                    if (style.maxLevel != undefined) {
                        if (style.index - 1 == style.maxLevel) {
                            style = $.extend({}, style);
                            style.merge = style.maxLevel - data.level - 1;
                        }
                    }
                }
                if (data.level != undefined && data.label != undefined) {
                    if (that.exportFormat === "xml" || that.exportFormat === "json") {
                        var dataGroup = {};
                        dataGroup['text'] = "group";
                        exporter.appendBodyCell(data.label, dataGroup, style, data, indx, "group");
                        break;
                    }
                }

                if (data.hasOwnProperty(column)) {
                    exporter.appendBodyCell(data[column], dataFields[column], style, data, indx);
                }
                else {
                    exporter.appendBodyCell("", dataFields[column], style, data, indx);
                }
                indx++;
            }
            if (hierarchy != true) {
                exporter.endRow();
            }
        }

        function getHeaderStyle(columnName, dataField) {
            if (dataField.style) {
                return styles[dataField.style];
            }

            var rowStyles = getStylesArray();
            if (rowStyles.length > 0) {
                return rowStyles[0].style;
            }
            return null;
        }

        function getStylesArray() {
            if (!stylesArray) {
                stylesArray = new Array();
                $.each(styles, function (index, value) {
                    stylesArray[stylesArray.length] = { name: index, style: value };
                });
            }

            return stylesArray;
        }

        function getRowCellStyle(rowId, column) {
            var dataField = dataFields[column];
            if (dataField) {
                if (dataField.customCellStyles) {
                    var customStyle = dataField.customCellStyles[rowId];
                    if (customStyle) {
                        return styles[customStyle];
                    }
                }

                if (dataField.cellStyle) {
                    if (dataField.cellAltStyle) {
                        var styleId = rowId % 2;
                        if (styleId == 0)
                            return styles[dataField.cellStyle];
                        return styles[dataField.cellAltStyle];
                    }
                    return styles[dataField.cellStyle];
                }
                else {
                    var rowStyles = getStylesArray();
                    if (rowStyles.length > 0) {
                        var styleId = rowId % (rowStyles.length - 1);
                        var style = rowStyles[styleId + 1].style;
                        return style;
                    }
                }
            }
            return null;
        }

        function createHiddenInput(value, name, form) {
            var input = document.createElement('input');
            input.name = name;
            input.value = value;
            input.type = 'hidden';
            form.appendChild(input);
            return input;
        }

        function createHiddenTextArea(value, name, form) {
            var textArea = document.createElement('textarea');
            textArea.name = name;
            textArea.value = value;
            //      textArea.type = 'hidden';
            form.appendChild(textArea);
            return textArea;
        }

        function createForm(filename, format, content, exportServer, charset) {
            var form = document.createElement('form');
            createHiddenInput(filename, 'filename', form);
            createHiddenInput(format, 'format', form);
            createHiddenTextArea(content, 'content', form);
            if (exportServer == undefined || exportServer == '') {
                if (window && window.location.toString().indexOf('jqwidgets.com') >= 0) {
                    exportServer = 'https://jqwidgets.com/export_server/dataexport.php';
                }
                else {
                    exportServer = 'http://jquerygrid.net/export_server/dataexport.php';
                }
            }

            form.action = exportServer;
            form.method = 'post';
            if (charset) {
                form.acceptCharset = charset;
            }

            document.body.appendChild(form);
            return form;
        }

        exporter = function (inputData, inputDataFields, inputStyles, exportServer, hierarchy, exportFormat) {
            if (!(this instanceof ArrayExporter)) {
                return new ArrayExporter(inputData, inputDataFields, inputStyles, hierarchy, exportFormat);
            }
            data = inputData;
            dataFields = inputDataFields;
            styles = inputStyles;

            this.exportTo = function (format, hierarchy, exportFormat, filename) {
                format = format.toString().toLowerCase();
                var module = exportModules[format];
                if (typeof module === 'undefined') {
                    throw 'You can\'t export to ' + format + ' format.';
                }
                if (format === "pdf" && filename == undefined) {
                    var table = this.exportTo(format, hierarchy, format, "pdf");
                    if (!$.jqx.pdfExport) {
                        $.jqx.pdfExport =
                        {
                            orientation: "portrait",
                            paperSize: "a4"
                        }
                    }

                    var doc = new pdfDataExport($.jqx.pdfExport.orientation, 'pt', $.jqx.pdfExport.paperSize);
                    doc.cellInitialize();
                    var headerCells = $(table).find('th');
                    var tableRows = $(table).find('tr');
                    var rows = 0;
                    doc.setFontSize(13 * 72 / 96);
                    var totalWidth = 595;
                    switch ($.jqx.pdfExport.paperSize) {
                        case "legal":
                            var totalWidth = 612;
                            if ($.jqx.pdfExport.orientation !== "portrait") {
                                totalWidth = 1008;
                            }
                            break;
                        case "letter":
                            var totalWidth = 612;
                            if ($.jqx.pdfExport.orientation !== "portrait") {
                                totalWidth = 792;
                            }
                            break;
                        case "a3":
                            var totalWidth = 841;
                            if ($.jqx.pdfExport.orientation !== "portrait") {
                                totalWidth = 1190;
                            }
                            break;
                        case "a4":
                            var totalWidth = 595;
                            if ($.jqx.pdfExport.orientation !== "portrait") {
                                totalWidth = 842;
                            }
                            break;
                        case "a5":
                            var totalWidth = 420;
                            if ($.jqx.pdfExport.orientation !== "portrait") {
                                totalWidth = 595;
                            }
                            break
                    }
                    totalWidth -= 20;
                    var totalColumnsWidth = 0;
                    var columnWidths = [];
                    $.each(headerCells, function (index) {
                        var width = parseInt(this.style.width);
                        if (isNaN(width)) {
                            width = 25;
                        }
                        var widthPoints = width * 72 / 96;
                        columnWidths[index] = widthPoints;
                        totalColumnsWidth += widthPoints;
                    });

                    if (headerCells.length === 0) {
                        $.each(tableRows[0].cells, function (index) {
                            var width = parseInt(this.style.width);
                            if (isNaN(width)) {
                                width = totalWidth / tableRows[0].cells.length;
                            }
                            var widthPoints = width * 72 / 96;
                            columnWidths[index] = widthPoints;
                            totalColumnsWidth += widthPoints;
                        });
                    }

                    if (totalColumnsWidth > totalWidth) {
                        $.each(columnWidths, function (index) {
                            columnWidths[index] = (columnWidths[index] / totalColumnsWidth) * 100;
                            columnWidths[index] = columnWidths[index] * totalWidth / 100;
                        });
                    }

                    $.each(headerCells, function (index) {
                        var widthPoints = columnWidths[index];
                        var heightPoints = 25 * 72 / 96;
                        var textDimension = doc.getTextDimensions($(this).html());
                        var cellText = $(this).html();
                        if (textDimension.w + 3 > widthPoints) {
                            var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                            var newText = splitText[0];
                            if (newText.length > 3) {
                                cellText = newText.substring(0, newText.length - 3) + "...";
                            }
                            else cellText = newText.substring(0, 1) + "...";
                            var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                            var newText = splitText[0];
                            if (newText != cellText) {
                                cellText = newText;
                            }
                        }
                        doc.cell(10, 10, widthPoints, heightPoints, cellText, rows);
                    });

                    rows++;
                    $.each(tableRows, function (index) {
                        if (index === 0) return true;
                        var rowCells = $(this).children();
                        var isTreeGrid = rowCells.length > headerCells.length && headerCells.length > 0;
                        if (isTreeGrid) {
                            var mergeLength = rowCells.length - headerCells.length;
                            var cellText = "";
                            var widthPoints = columnWidths[0];
                            var heightPoints = 25 * 72 / 96;
                            for (var i = 0; i <= mergeLength; i++) {
                                var cellHTML = rowCells[i].innerHTML;
                                if (cellHTML === "+" || cellHTML === "-") cellHTML = cellHTML + " ";
                                if (cellHTML === "&nbsp;") cellHTML = "   ";
                                cellText += cellHTML;
                            }
                            var textDimension = doc.getTextDimensions(cellText);
                            if (textDimension.w + 3 > widthPoints) {
                                var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                                var newText = splitText[0];
                                if (newText.length > 3) {
                                    cellText = newText.substring(0, newText.length - 3) + "...";
                                }
                                else cellText = newText.substring(0, 1) + "...";
                                var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                                var newText = splitText[0];
                                if (newText != cellText) {
                                    cellText = newText;
                                }
                            }

                            doc.cell(10, 10, widthPoints, heightPoints, cellText, rows);
                            for (var i = mergeLength + 1; i < rowCells.length; i++) {
                                var index = i - mergeLength;
                                var widthPoints = columnWidths[index];
                                var heightPoints = 25 * 72 / 96;
                                var cellText = $(rowCells[i]).html();
                                var textDimension = doc.getTextDimensions($(rowCells[i]).html());
                                if (textDimension.w + 3 > widthPoints) {
                                    var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                                    var newText = splitText[0];
                                    if (newText.length > 3) {
                                        cellText = newText.substring(0, newText.length - 3) + "...";
                                    }
                                    else cellText = newText.substring(0, 1) + "...";
                                    var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                                    var newText = splitText[0];
                                    if (newText != cellText) {
                                        cellText = newText;
                                    }
                                }
                                doc.cell(10, 10, widthPoints, heightPoints, cellText, rows);
                            }
                            rows++;
                            return true;
                        }

                        $.each(rowCells, function (index) {
                            var widthPoints = columnWidths[index];
                            var heightPoints = 25 * 72 / 96;
                            var cellText = $(this).html();
                            var textDimension = doc.getTextDimensions($(this).html());
                            if (textDimension.w + 3 > widthPoints) {
                                var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                                var newText = splitText[0];
                                if (newText.length > 3) {
                                    cellText = newText.substring(0, newText.length - 3) + "...";
                                }
                                else cellText = newText.substring(0, 1) + "...";
                                var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                                var newText = splitText[0];
                                if (newText != cellText) {
                                    cellText = newText;
                                }
                            }
                            doc.cell(10, 10, widthPoints, heightPoints, cellText, rows);
                        }
                        );
                        rows++;
                    });
                    if ($.jqx.browser.msie && $.jqx.browser.version < 10) {
                        throw new Error("PDF export requires a browser with HTML5 support");
                        return;
                    }

                    return doc;
                }

                return exportData(module, data, dataFields, styles, hierarchy, exportFormat, filename);
            };

            this.exportToFile = function (format, filename, exportServer, charset, hierarchy) {
                if (format === "pdf") {
                    var table = this.exportTo(format, hierarchy, format, filename);
                    if (!$.jqx.pdfExport) {
                        $.jqx.pdfExport =
                        {
                            orientation: "portrait",
                            paperSize: "a4"
                        }
                    }

                    var doc = new pdfDataExport($.jqx.pdfExport.orientation, 'pt', $.jqx.pdfExport.paperSize);
                    if (charset == "utf-8" || charset == "UTF-8") {
                        doc.setFont("courier", "normal");
                    }

                    doc.cellInitialize();
                    var headerCells = $(table).find('th');
                    var tableRows = $(table).find('tr');
                    var rows = 0;
                    doc.setFontSize(13 * 72 / 96);
                    var totalWidth = 595;
                    switch ($.jqx.pdfExport.paperSize) {
                        case "legal":
                            var totalWidth = 612;
                            if ($.jqx.pdfExport.orientation !== "portrait") {
                                totalWidth = 1008;
                            }
                            break;
                        case "letter":
                            var totalWidth = 612;
                            if ($.jqx.pdfExport.orientation !== "portrait") {
                                totalWidth = 792;
                            }
                            break;
                        case "a3":
                            var totalWidth = 841;
                            if ($.jqx.pdfExport.orientation !== "portrait") {
                                totalWidth = 1190;
                            }
                            break;
                        case "a4":
                            var totalWidth = 595;
                            if ($.jqx.pdfExport.orientation !== "portrait") {
                                totalWidth = 842;
                            }
                            break;
                        case "a5":
                            var totalWidth = 420;
                            if ($.jqx.pdfExport.orientation !== "portrait") {
                                totalWidth = 595;
                            }
                            break
                    }
                    totalWidth -= 20;
                    var totalColumnsWidth = 0;
                    var columnWidths = [];
                    $.each(headerCells, function (index) {
                        var width = parseInt(this.style.width);
                        if (isNaN(width)) {
                            width = 25;
                        }
                        var widthPoints = width * 72 / 96;
                        columnWidths[index] = widthPoints;
                        totalColumnsWidth += widthPoints;
                    });

                    if (headerCells.length === 0) {
                        $.each(tableRows[0].cells, function (index) {
                            var width = parseInt(this.style.width);
                            if (isNaN(width)) {
                                width = totalWidth / tableRows[0].cells.length;
                            }
                            var widthPoints = width * 72 / 96;
                            columnWidths[index] = widthPoints;
                            totalColumnsWidth += widthPoints;
                        });
                    }

                    if (totalColumnsWidth > totalWidth) {
                        $.each(columnWidths, function (index) {
                            columnWidths[index] = (columnWidths[index] / totalColumnsWidth) * 100;
                            columnWidths[index] = columnWidths[index] * totalWidth / 100;
                        });
                    }

                    $.each(headerCells, function (index) {
                        var widthPoints = columnWidths[index];
                        var heightPoints = 25 * 72 / 96;
                        var textDimension = doc.getTextDimensions($(this).html());
                        var cellText = $(this).html();
                        if (textDimension.w + 3 > widthPoints) {
                            var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                            var newText = splitText[0];
                            if (newText.length > 3) {
                                cellText = newText.substring(0, newText.length - 3) + "...";
                            }
                            else cellText = newText.substring(0, 1) + "...";
                            var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                            var newText = splitText[0];
                            if (newText != cellText) {
                                cellText = newText;
                            }
                        }
                        doc.cell(10, 10, widthPoints, heightPoints, cellText, rows);
                    });

                    rows++;
                    $.each(tableRows, function (index) {
                        if (index === 0) return true;
                        var rowCells = $(this).children();
                        var isTreeGrid = rowCells.length > headerCells.length && headerCells.length > 0;
                        if (isTreeGrid) {
                            var mergeLength = rowCells.length - headerCells.length;
                            var cellText = "";
                            var widthPoints = columnWidths[0];
                            var heightPoints = 25 * 72 / 96;
                            for (var i = 0; i <= mergeLength; i++) {
                                var cellHTML = rowCells[i].innerHTML;
                                if (cellHTML === "+" || cellHTML === "-") cellHTML = cellHTML + " ";
                                if (cellHTML === "&nbsp;") cellHTML = "   ";
                                cellText += cellHTML;
                            }
                            var textDimension = doc.getTextDimensions(cellText);
                            if (textDimension.w + 3 > widthPoints) {
                                var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                                var newText = splitText[0];
                                if (newText.length > 3) {
                                    cellText = newText.substring(0, newText.length - 3) + "...";
                                }
                                else cellText = newText.substring(0, 1) + "...";
                                var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                                var newText = splitText[0];
                                if (newText != cellText) {
                                    cellText = newText;
                                }
                            }

                            doc.cell(10, 10, widthPoints, heightPoints, cellText, rows);
                            for (var i = mergeLength + 1; i < rowCells.length; i++) {
                                var index = i - mergeLength;
                                var widthPoints = columnWidths[index];
                                var heightPoints = 25 * 72 / 96;
                                var cellText = $(rowCells[i]).html();
                                if (cellText === "&nbsp;") cellText = "   ";

                                var textDimension = doc.getTextDimensions($(rowCells[i]).html());
                                if (textDimension.w + 3 > widthPoints) {
                                    var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                                    var newText = splitText[0];
                                    if (newText.length > 3) {
                                        cellText = newText.substring(0, newText.length - 3) + "...";
                                    }
                                    else cellText = newText.substring(0, 1) + "...";
                                    var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                                    var newText = splitText[0];
                                    if (newText != cellText) {
                                        cellText = newText;
                                    }
                                }
                                doc.cell(10, 10, widthPoints, heightPoints, cellText, rows);
                            }
                            rows++;
                            return true;
                        }

                        $.each(rowCells, function (index) {
                            var widthPoints = columnWidths[index];
                            var heightPoints = 25 * 72 / 96;
                            var cellText = $(this).html();
                            if (cellText === "&nbsp;") cellText = "   ";

                            var textDimension = doc.getTextDimensions($(this).html());
                            if (textDimension.w + 3 > widthPoints) {
                                var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                                var newText = splitText[0];
                                if (newText.length > 3) {
                                    cellText = newText.substring(0, newText.length - 3) + "...";
                                }
                                else cellText = newText.substring(0, 1) + "...";
                                var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                                var newText = splitText[0];
                                if (newText != cellText) {
                                    cellText = newText;
                                }
                            }
                            doc.cell(10, 10, widthPoints, heightPoints, cellText, rows);
                        }
                        );
                        rows++;
                    });
                    if ($.jqx.browser.msie && $.jqx.browser.version < 10) {
                        throw new Error("PDF export requires a browser with HTML5 support");
                        return;
                    }

                    doc.save(filename + ".pdf");
                    return;
                }

                var content = this.exportTo(format, hierarchy, format, filename),
                    form = createForm(filename, format, content, exportServer, charset);
                form.submit();
                document.body.removeChild(form);
            };

            this.exportToLocalFile = function (format, filename, hierarchy, exportFormat) {
                var content = this.exportTo(format, hierarchy, exportFormat);
                document.location.href = 'data:application/octet-stream;filename=' + filename + ',' + encodeURIComponent(content);
            };

        };

        exporter.extend = function (exportFormat, exporter) {
            if (exporter instanceof $.jqx.dataAdapter.DataExportModuleBase) {
                exportModules[exportFormat] = exporter;
            } else {
                throw 'The module ' + exportFormat + ' is not instance of DataExportModuleBase.';
            }
        };

        return exporter;

    }());

    $.jqx.dataAdapter.ArrayExporter = ArrayExporter;

})(jqxBaseFramework);


(function ($) {

    //Defines common interface for all modules used for exportation
    var DataExportModuleBase = function () {

        this.formatData = function (data, type, formatString, localization) {
            if (type === 'date') {
                var tmpdate = "";
                if (typeof data === 'string') {
                    tmpdate = $.jqx.dataFormat.tryparsedate(data);
                    data = tmpdate;
                }
                if (data === "" || data === null) return "";
                tmpdate = $.jqx.dataFormat.formatdate(data, formatString, localization);
                if ((tmpdate && tmpdate.toString() == "NaN") || tmpdate == null) return "";
                data = tmpdate;
            } else if (type === 'number' || type === 'float' || type === 'int' || type == 'integer') {
                if (data === "" || data === null) return "";

                if (!isNaN(new Number(data))) {
                    var tmpdata = $.jqx.dataFormat.formatnumber(data, formatString, localization);
                    if (tmpdata.toString() == "NaN") return "";
                    else data = tmpdata;
                }
            } else {
                data = data;
            }
            if (data === null) return "";
            return data;
        };

        this.getFormat = function (dataOptions) {
            var formatString = dataOptions ? dataOptions['formatString'] : "";
            var localization = dataOptions ? dataOptions['localization'] : "";
            var dataType = 'string';
            dataType = dataOptions ? dataOptions['type'] : 'string';

            if (dataType == 'number' || dataType == 'float') {
                if (!formatString) formatString = 'f2';
            }
            if (dataType == 'int' || dataType == 'integer') {
                if (!formatString) formatString = 'n0';
            }
            if (dataType == 'date') {
                if (!formatString) formatString = 'd';
            }
            return { type: dataType, formatString: formatString, localization: localization };
        };

        this.beginFile = function () {
            throw 'Not implemented!';
        };

        this.beginHeader = function () {
            throw 'Not implemented!';
        };

        this.appendHeaderCell = function () {
            throw 'Not implemented!';
        };

        this.endHeader = function () {
            throw 'Not implemented!';
        };

        this.beginBody = function () {
            throw 'Not implemented!';
        };

        this.beginRow = function () {
            throw 'Not implemented!';
        };

        this.beginRows = function () {
            throw 'Not implemented!';
        };

        this.endRows = function () {
            throw 'Not implemented!';
        };

        this.appendBodyCell = function () {
            throw 'Not implemented!';
        };

        this.endRow = function () {
            throw 'Not implemented!';
        };

        this.endBody = function () {
            throw 'Not implemented!';
        };

        this.endFile = function () {
            throw 'Not implemented!';
        };

        this.getFile = function () {
            throw 'Not implemented!';
        };
    }

    $.jqx.dataAdapter.DataExportModuleBase = DataExportModuleBase;

})(jqxBaseFramework);

//Extending the exporter with TSV and CSV exporters
(function ($) {

    //Value exporter. This object is common prototype for TSV and CVS.
    var SvExporter = function (inValueSeparator) {

        var file, valueSeparator, hasHeader;
        var rowIndex = 0;
        var me = this;

        this.beginFile = function () {
            file = '';
        };

        this.beginHeader = function () {
        };

        this.appendHeaderCell = function (data, fieldName, style, exportHeader, index) {
            if (style) {
                if (style.level != undefined) {
                    if (index < style.maxLevel) {
                        return;
                    }
                    else if (index === style.maxLevel) {
                        if (exportHeader) {
                            appendCell(data.text);
                        }
                        for (var i = 0; i < style.maxLevel; i++) {
                            appendCell("");
                        }
                        return;
                    }
                }
            }

            hasHeader = exportHeader;
            if (exportHeader) {
                appendCell(data.text);
            }
        };

        this.endHeader = function () {
            this.endRow();
        };

        this.beginBody = function () {
            rowIndex = 0;
        };

        this.beginRow = function () {
            if ((rowIndex > 0) || (rowIndex == 0 && hasHeader)) {
                file += '\n';
            }
            rowIndex++;
        };

        this.appendBodyCell = function (data, dataType, style, row, index) {
            if (style) {
                if (style.maxLevel != undefined) {
                    if (index === style.maxLevel) {
                        appendCell(data, dataType);
                        for (var i = 0; i < style.maxLevel - row.level - 1; i++) {
                            appendCell("", dataType);
                        }
                        return;
                    }
                }
            }
            appendCell(data, dataType);
        };

        this.endRow = function () {
            file = file.substring(0, file.length - 1);
        };

        this.endBody = function () {
        };

        this.endFile = function () {
        };

        this.getFile = function () {
            return file;
        };

        function prepareData(data, dataOptions) {
            if (dataOptions) {
                var format = me.getFormat(dataOptions);
                data = me.formatData(data, format.type, format.formatString, format.localization);
            }
            data = '"' + data + '"';
            return data;
        };

        function appendCell(data, dataOptions) {
            data = prepareData(data, dataOptions);
            file += data + inValueSeparator;
        };

    };

    SvExporter.prototype = new $.jqx.dataAdapter.DataExportModuleBase();

    var CsvExporter = function () { };
    CsvExporter.prototype = new SvExporter(',');

    var TsvExporter = function () { };
    TsvExporter.prototype = new SvExporter('\t');

    $.jqx.dataAdapter.ArrayExporter.extend('csv', new CsvExporter());
    $.jqx.dataAdapter.ArrayExporter.extend('tsv', new TsvExporter());

})(jqxBaseFramework);

//Extending the exporter with HTML exporter
(function ($) {

    var HtmlExporter = function () {
        var isPDF = false;
        var file;
        var hasHeader;
        var rowIndex = 0;

        this.setPDF = function () {
            isPDF = true;
        };

        this.beginFile = function (filename) {
            if (isPDF || filename == undefined) {
                file = '<table style="empty-cells: show;" cellspacing="0" cellpadding="2">';
            }
            else {
                file = '<html>\n\t<head>\n\t\t<title></title>\n' +
					   '\t\t<meta http-equiv=Content-type content=\"text/html; charset=UTF-8\">\n\t</head>\n\t<body>\n' +
					   '\t\t<table style="empty-cells: show;" cellspacing="0" cellpadding="2">';
            }
        };

        this.beginHeader = function () {
            if (isPDF) {
                file += '\n\t<thead><tr>';
            }
            else {
                file += '\n\t\t\t<thead>';
            }
        };

        this.appendHeaderCell = function (data, fieldName, style, exportHeader) {
            hasHeader = exportHeader;
            if (!exportHeader) return;

            if (isPDF) {
                file += '\n\t\t\t\t<th style="' + buildStyle(style) + '">' + data.text + '</th>';
            }
            else {
                if (style.disabled) return;

                if (style.merge) {
                    if (data.width) {
                        file += '\n\t\t\t\t<th colspan=' + (1 + style.merge) + ' style="width: ' + data.width + 'px; ' + buildStyle(style) + '">' + data.text + '</th>';
                    }
                    else {
                        file += '\n\t\t\t\t<th colspan=' + (1 + style.merge) + ' style="' + buildStyle(style) + '">' + data.text + '</th>';
                    }
                }
                else {
                    if (data.width) {
                        file += '\n\t\t\t\t<th style="width: ' + data.width + 'px; ' + buildStyle(style) + '">' + data.text + '</th>';
                    }
                    else {
                        file += '\n\t\t\t\t<th style="' + buildStyle(style) + '">' + data.text + '</th>';
                    }
                }
            }
        };

        this.endHeader = function () {
            if (isPDF) {
                file += '\n\t</tr></thead>';
            }
            else {
                file += '\n\t\t\t</thead>';
            }
        };

        this.beginBody = function () {
            if (isPDF) {
                file += '\n\t<tbody>';
            }
            else {
                file += '\n\t\t\t<tbody>';
            }
            rowIndex = 0;
        };

        this.beginRow = function () {
            if (isPDF) {
                file += '\n\t<tr>';
            }
            else {
                file += '\n\t\t\t\t<tr>';
            }
            rowIndex++;
        };

        this.appendBodyCell = function (data, dataOptions, style) {
            var format = this.getFormat(dataOptions);
            if (data === "") data = "&nbsp;";
            if (isPDF) {
                if (rowIndex == 1 && !hasHeader) {
                    file += '\n\t\t\t\t\t<td style="' + buildStyle(style) + ' border-top-width: 1px;">' + this.formatData(data, format.type, format.formatString, format.localization) + '</td>';
                }
                else {
                    file += '\n\t\t\t\t\t<td style="' + buildStyle(style) + '">' + this.formatData(data, format.type, format.formatString, format.localization) + '</td>';
                }
            }
            else {
                if (style.merge) {
                    if (rowIndex == 1 && !hasHeader) {
                        file += '\n\t\t\t\t\t<td colspan=' + (1 + style.merge) + ' style="' + buildStyle(style) + ' border-top-width: 1px;">' + this.formatData(data, format.type, format.formatString, format.localization) + '</td>';
                    }
                    else {
                        file += '\n\t\t\t\t\t<td colspan=' + (1 + style.merge) + ' style="' + buildStyle(style) + '">' + this.formatData(data, format.type, format.formatString, format.localization) + '</td>';
                    }
                }
                else {
                    if (rowIndex == 1 && !hasHeader) {
                        file += '\n\t\t\t\t\t<td style="' + buildStyle(style) + ' border-top-width: 1px;">' + this.formatData(data, format.type, format.formatString, format.localization) + '</td>';
                    }
                    else {
                        file += '\n\t\t\t\t\t<td style="' + buildStyle(style) + '">' + this.formatData(data, format.type, format.formatString, format.localization) + '</td>';
                    }
                }
            }
        };

        this.endRow = function () {
            if (isPDF) {
                file += '\n\t</tr>';
            }
            else {
                file += '\n\t\t\t\t</tr>';
            }
        };

        this.endBody = function () {
            if (isPDF) {
                file += '\n\t</tbody>';
            }
            else {
                file += '\n\t\t\t</tbody>';
            }
        };

        this.endFile = function (filename) {
            if (isPDF || filename == undefined) {
                file += '\n</table>';
            }
            else {
                file += '\n\t\t</table>\n\t</body>\n</html>\n';
            }
        };

        this.getFile = function () {
            return file;
        };

        function buildStyle(styles) {
            var result = '';
            for (var style in styles) {
                if (styles.hasOwnProperty(style)) {
                    if (isPDF && style == 'font-size') {
                        styles[style] = '100%';
                    }
                    result += style + ':' + styles[style] + ';';
                }
            }
            return result;
        }
    }

    HtmlExporter.prototype = new $.jqx.dataAdapter.DataExportModuleBase();

    var TableExporter = function () { };
    TableExporter.prototype = new HtmlExporter();

    var PDFExporter = function () { };
    PDFExporter.prototype = new HtmlExporter();
    var exporter = new PDFExporter();

    $.jqx.dataAdapter.ArrayExporter.extend('html', new TableExporter());
    $.jqx.dataAdapter.ArrayExporter.extend('pdf', exporter);

})(jqxBaseFramework);

//Exporting to XLS format (MS Office Excel 2003)
(function ($) {

    var ExcelExporter = function () {

        var header, content, headerFields, headerStyles, existingStyles, styleCounter,
            styleBuilder = {

                style: '',

                stylesMap: {
                    'font': {
                        'color': 'Color',
                        'font-family': 'FontName',
                        'font-style': 'Italic',
                        'font-weight': 'Bold'
                    },
                    'interior': {
                        'background-color': 'Color',
                        'background': 'Color'
                    },
                    'alignment': {
                        'left': 'Left',
                        'center': 'Center',
                        'right': 'Right'
                    }
                },

                startStyle: function (styleName) {
                    this.style += '\n\t\t<Style ss:ID="' + styleName + '" ss:Name="' + styleName + '">';
                },

                buildAlignment: function (styles) {
                    if (styles['text-align']) {
                        var alignment = this.stylesMap['alignment'][styles['text-align']];
                        if (!alignment) {
                            alignment = "Left";
                        }
                        var style = '\n\t\t\t<Alignment ss:Vertical="Bottom" ss:Horizontal="' + alignment + '"/>';
                        this.style += style;
                    }
                },

                buildBorder: function (styles) {
                    if (styles['border-color']) {
                        var border = '\n\t\t\t<Borders>';
                        var bottomBorder = '\n\t\t\t\t<Border ss:Position="Bottom" ss:LineStyle="Continuous" ss:Weight="1" ss:Color="' + styles['border-color'] + '"/>';
                        var leftBorder = '\n\t\t\t\t<Border ss:Position="Left" ss:LineStyle="Continuous" ss:Weight="1" ss:Color="' + styles['border-color'] + '"/>';
                        var rightBorder = '\n\t\t\t\t<Border ss:Position="Right" ss:LineStyle="Continuous" ss:Weight="1" ss:Color="' + styles['border-color'] + '"/>';
                        var topBorder = '\n\t\t\t\t<Border ss:Position="Top" ss:LineStyle="Continuous" ss:Weight="1" ss:Color="' + styles['border-color'] + '"/>';

                        border += bottomBorder;
                        border += leftBorder;
                        border += rightBorder;
                        border += topBorder;
                        border += '\n\t\t\t</Borders>';
                        this.style += border;
                    }
                },

                buildFont: function (styles) {
                    var map = this.stylesMap['font'],
                        font = '\n\t\t\t<Font ';
                    for (var prop in map) {
                        if (typeof styles[prop] !== 'undefined') {
                            if (prop === 'font-style' && styles[prop].toString().toLowerCase() === 'italic') {
                                font += 'ss:Italic="1" ';
                            } else if (prop === 'font-weight' && styles[prop].toString().toLowerCase() === 'bold') {
                                font += 'ss:Bold="1" ';
                            } else if (prop === 'color') {
                                font += 'ss:' + map[prop] + '="' + styles[prop] + '" ';
                            }
                        }
                    }
                    font += '/>';
                    this.style += font;
                },

                buildInterior: function (styles) {
                    var map = this.stylesMap['interior'],
                        interior = '\n\t\t\t<Interior ';
                    var hasInterior = false;
                    for (var prop in map) {
                        if (typeof styles[prop] !== 'undefined') {
                            interior += 'ss:' + map[prop] + '="' + styles[prop] + '" ';
                            hasInterior = true;
                        }
                    }
                    if (hasInterior)
                        interior += 'ss:Pattern="Solid"';

                    interior += '/>';
                    this.style += interior;
                },

                buildFormat: function (styles) {
                    if (styles['dataType'] == 'number' || styles['dataType'] == 'float' || styles['dataType'] == 'int' || styles['dataType'] == 'integer') {
                        var formatString = styles['formatString'];
                        if (formatString == "" || formatString.indexOf('n') != -1 || formatString.indexOf('N') != -1) {
                            this.style += '\n\t\t\t<NumberFormat ss:Format="0"/>';
                        }
                        else if (formatString == "f" || formatString == "F" || formatString == "D" || formatString.indexOf('d') != -1) {
                            this.style += '\n\t\t\t<NumberFormat ss:Format="#,##0.00_);[Red]\(#,##0.00\)"/>';
                        }
                        else if (formatString.indexOf('p') != -1 || formatString.indexOf('P') != -1) {
                            this.style += '\n\t\t\t<NumberFormat ss:Format="Percent"/>';
                        }
                        else if (formatString.indexOf('c') != -1 || formatString.indexOf('C') != -1) {
                            if (styles['currencysymbol'] && parseInt(styles['currencysymbol'].charCodeAt(0)) == 8364) {
                                this.style += '\n\t\t\t<NumberFormat ss:Format="Euro Currency"/>';
                            }
                            else {
                                this.style += '\n\t\t\t<NumberFormat ss:Format="Currency"/>';
                            }
                        }
                    }
                    else if (styles['dataType'] == 'date') {
                        this.style += '\n\t\t\t<NumberFormat ss:Format="Short Date"/>';
                    }
                },

                closeStyle: function () {
                    this.style += '\n\t\t</Style>';
                },

                toString: function () {
                    var temp = this.style;
                    this.style = '';
                    return temp;
                }
            };

        this.beginFile = function () {
            existingStyles = {};
            styleCounter = 0;
            header = '<?xml version="1.0"?>' +
                            '\n\t<?mso-application progid="Excel.Sheet"?> ' +
                            '\n\t<Workbook xmlns="urn:schemas-microsoft-com:office:spreadsheet" ' +
                            '\n\txmlns:o="urn:schemas-microsoft-com:office:office" ' +
                            '\n\txmlns:x="urn:schemas-microsoft-com:office:excel" ' +
                            '\n\txmlns:ss="urn:schemas-microsoft-com:office:spreadsheet" ' +
                            '\n\txmlns:html="http://www.w3.org/TR/REC-html40"> ' +
                            '\n\t<DocumentProperties xmlns="urn:schemas-microsoft-com:office:office"> ' +
                            '\n\t<Version>12.00</Version> ' +
                            '\n\t</DocumentProperties> ' +
                            '\n\t<ExcelWorkbook xmlns="urn:schemas-microsoft-com:office:excel"> ' +
                            '\n\t<WindowHeight>8130</WindowHeight> ' +
                            '\n\t<WindowWidth>15135</WindowWidth> ' +
                            '\n\t<WindowTopX>120</WindowTopX> ' +
                            '\n\t<WindowTopY>45</WindowTopY> ' +
                            '\n\t<ProtectStructure>False</ProtectStructure> ' +
                            '\n\t<ProtectWindows>False</ProtectWindows> ' +
                            '\n\t</ExcelWorkbook> ' +
                        '\n\t<Styles>';
        };

        this.beginHeader = function () {
            content = '\n\t<Worksheet ss:Name="Sheet1">\n\t\t<Table>';
            headerFields = [];
            headerStyles = [];
        };

        this.appendHeaderCell = function (data, fieldName, style) {
            var width = data.width != undefined ? data.width : data.text.length * 10;
            content += '\n\t\t\t<Column ss:Width="' + width + '"/>';
            headerFields.push(data);
            headerStyles.push(style);
        };

        this.endHeader = function (exportHeader) {
            if (exportHeader) {
                this.beginRow();
                for (var i = 0; i < headerFields.length; i += 1) {
                    if (headerStyles[i].disabled) continue;
                    appendCell.call(this, headerFields[i]['text'], null, headerStyles[i]);
                }
                this.endRow();
            }
        };

        this.beginBody = function () {
        };

        this.beginRow = function (level) {
            if (level != undefined) {
                content += '\n\t\t\t';
                for (var i = 0; i < level; i++) {
                    content += '\t';
                }
                content += '<Row>';
                return;
            }

            content += '\n\t\t\t<Row>';
        };

        this.beginRows = function (level) {
            content += '\n\t\t\t\t<Rows>';
        };

        this.appendBodyCell = function (data, dataType, style, row) {
            appendCell.call(this, data, dataType, style, row);
        };

        this.endRow = function (level) {
            if (level != undefined) {
                content += '\n\t\t\t';
                for (var i = 0; i < level; i++) {
                    content += '\t';
                }
                content += '</Row>';
                return;
            }

            content += '\n\t\t\t</Row>';
        };

        this.endRows = function (level) {
            if (level != undefined) {
                content += '\n\t\t\t';
                for (var i = 0; i < level; i++) {
                    content += '\t';
                }
                content += '</Rows>';
                return;
            }
        };

        this.endBody = function () {
            content += '\n\t\t</Table>';
        };

        this.endFile = function () {
            content += '\n\t</Worksheet>\n</Workbook>';
            header += '\n\t</Styles>';
        };

        this.getFile = function () {
            return header + content;
        };

        function appendCell(data, dataOptions, style, row) {
            var columnType = "String";

            var format = this.getFormat(dataOptions);

            if (data != null && data.toString().substring(0, 3) == "_AG") {
                data = data.toString().substring(3);
                columnType = "String";
            }
            else {
                if (format.type == 'date') {
                    var date = data;
                    data = this.formatData(data, format.type, format.formatString, format.localization);
                    if (data === null || data === "") {
                        data = "";
                        columnType = "String";
                    }
                    else {
                        data = date.toISOString();
                        columnType = "DateTime";
                    }
                }
                if (format.type == 'string') {
                    if (data === null || data === undefined) {
                        data = "";
                    }
                    else {
                        if (data.toString().indexOf('&') >= 0) {
                            data = data.toString().replace(/&/g, '&amp;');
                        }
                        if (data.toString().indexOf('>') >= 0) {
                            data = data.toString().replace(/>/g, '&gt;');
                        }
                        if (data.toString().indexOf('<') >= 0) {
                            data = data.toString().replace(/</g, '&lt;');
                        }
                        if (data.toString().indexOf('"') >= 0) {
                            data = data.toString().replace(/"/g, '&quot;');
                        }
                        if (data.toString().indexOf("'") >= 0) {
                            data = data.toString().replace(/'/g, '&apos;');
                        }
                    }
                }

                if (style.dataType == 'number' || style.dataType == 'float' || style.dataType == 'int' || style.dataType == 'integer') {
                    columnType = "Number";
                    data = parseFloat(data);
                    if (data === null || isNaN(data) || data === "") {
                        data = "";
                        columnType = "String";
                    }
                    if (data && columnType != "String" && data != "") {
                        if (dataOptions && dataOptions.formatString && dataOptions.formatString.indexOf('p') >= 0) {
                            data = data / 100;
                        }
                    }

                    style.currencysymbol = dataOptions.localization.currencysymbol;
                }
            }

            var styleId = getStyleId(style);
            if (style.merge) {
                content += '\n\t\t\t\t<Cell ss:MergeAcross="' + style.merge + '" ss:StyleID="' + styleId + '"><Data ss:Type="' + columnType + '">' + data + '</Data></Cell>';
            }
            else {
                content += '\n\t\t\t\t<Cell ss:StyleID="' + styleId + '"><Data ss:Type="' + columnType + '">' + data + '</Data></Cell>';
            }
        }

        function generateStyleId() {
            styleCounter += 1;
            return 'xls-style-' + styleCounter;
        }

        function findStyle(style) {
            for (var s in existingStyles) {
                if (isSubset(style, existingStyles[s]) && isSubset(existingStyles[s], style)) {
                    return s;
                }
            }
            return undefined;
        }

        function isSubset(first, second) {
            var subset = true;
            for (var p in first) {
                if (first[p] !== second[p]) {
                    subset = false;
                }
            }
            return subset;
        }

        function appendStyle(id, style) {
            styleBuilder.startStyle(id);
            styleBuilder.buildAlignment(style);
            styleBuilder.buildBorder(style);
            styleBuilder.buildFont(style);
            styleBuilder.buildInterior(style);
            styleBuilder.buildFormat(style);
            styleBuilder.closeStyle();
            header += styleBuilder.toString();
        }

        function getStyleId(style) {
            if (!style) {
                return '';
            }
            var id = findStyle(style);
            if (typeof id === 'undefined') {
                id = generateStyleId();
                existingStyles[id] = style;
                appendStyle(id, style);
            }
            return id;
        }
    }

    ExcelExporter.prototype = new $.jqx.dataAdapter.DataExportModuleBase();
    $.jqx.dataAdapter.ArrayExporter.extend('xls', new ExcelExporter());
})(jqxBaseFramework);

//Exporting to XML
(function ($) {

    var XmlExporter = function () {

        var file, headerFields, index;

        this.beginFile = function () {
            file = '<?xml version="1.0" encoding="UTF-8" ?>';
            file += '\n<table>';
        }

        this.beginHeader = function () {
            headerFields = [];
        }

        this.appendHeaderCell = function (data, fieldName) {
            headerFields.push(fieldName);
        }

        this.endHeader = function () {
        }

        this.beginBody = function (data, dataType) {
        }

        this.beginRow = function (level) {
            var that = this;

            if (!that) {
                that = window.jqx;
            }

            if (level != undefined) {
                if (that.hierarchy) {
                    file += '\n\t';
                    for (var i = 0; i < level; i++) {
                        file += '\t\t';
                    }
                    file += '<row>';
                    index = 0;
                    return;
                }
            }

            file += '\n\t<row>';
            index = 0;
        }

        this.beginRows = function (level) {
            if (level != undefined) {
                file += '\n\t\t';
                for (var i = 0; i < level; i++) {
                    file += '\t\t';
                }
                file += '<rows>';
                index = 0;
                return;
            }
            file += '\n\t\t<rows>';
        }

        this.appendBodyCell = function (data, dataOptions, style, row, indx, group) {
            var that = this;

            if (!that) {
                that = window.jqx;
            }

            var format = this.getFormat(dataOptions);
            data = this.formatData(data, format.type, format.formatString, format.localization);
            if (format.type == "string") {
                if (data.toString().indexOf('&') >= 0) {
                    data = data.toString().replace(/&/g, '&amp;');
                }
                if (data.toString().indexOf('>') >= 0) {
                    data = data.toString().replace(/>/g, '&gt;');
                }
                if (data.toString().indexOf('<') >= 0) {
                    data = data.toString().replace(/</g, '&lt;');
                }
                if (data.toString().indexOf('"') >= 0) {
                    data = data.toString().replace(/"/g, '&quot;');
                }
                if (data.toString().indexOf("'") >= 0) {
                    data = data.toString().replace(/'/g, '&apos;');
                }
            }
            if (row.level != undefined) {
                if (that.hierarchy) {
                    file += '\n\t\t';
                    for (var i = 0; i < row.level; i++) {
                        file += '\t\t';
                    }
                    if (group === undefined) {
                        file += '<' + headerFields[index] + '>' + data + '</' + headerFields[index] + '>';
                    }
                    else {
                        file += '<' + group + '>' + data + '</' + group + '>';
                    }
                }
                else {
                    if (group != undefined) {
                        file += '\n\t\t<' + group + '>' + data + '</' + group + '>';
                    }
                    else {
                        file += '\n\t\t<' + headerFields[index] + '>' + data + '</' + headerFields[index] + '>';
                    }
                }
            }
            else {
                file += '\n\t\t<' + headerFields[index] + '>' + data + '</' + headerFields[index] + '>';
            }
            index++;
        }

        this.endRow = function (level) {
            var that = this;

            if (!that) {
                that = window.jqx;
            }

            if (level != undefined) {
                if (that.hierarchy) {
                    file += '\n\t';
                    for (var i = 0; i < level; i++) {
                        file += '\t\t';
                    }

                    file += '</row>';
                    index = 0;
                    return;
                }
            }
            file += '\n\t</row>';
            index = 0;
        }

        this.endRows = function (level) {
            if (level != undefined) {
                file += '\n\t\t';
                for (var i = 0; i < level; i++) {
                    file += '\t\t';
                }
                file += '</rows>';
                index = 0;
                return;
            }
            file += '\n\t\t</rows>';
        }

        this.endBody = function () {
        }

        this.endFile = function () {
            file += '\n</table>';
        }

        this.getFile = function () {
            return file;
        }
    }

    XmlExporter.prototype = new $.jqx.dataAdapter.DataExportModuleBase();
    $.jqx.dataAdapter.ArrayExporter.extend('xml', new XmlExporter());
})(jqxBaseFramework);


//Exporting to JSON
(function ($) {

    var escapable = /[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,
        meta = {
            '\b': '\\b',
            '\t': '\\t',
            '\n': '\\n',
            '\f': '\\f',
            '\r': '\\r',
            '"': '\\"',
            '\\': '\\\\'
        };

    function quote(string) {
        return '"' + string.replace(escapable, function (a) {
            var c = meta[a];
            return typeof c === 'string' ? c : '\\u' + ('0000' + a.charCodeAt(0).toString(16)).slice(-4);
        }) + '"';
    }

    function formatNumber(n) {
        return n < 10 ? '0' + n : n;
    }

    function stringifyDate(value) {
        var date;
        if (isFinite(value.valueOf())) {
            date = value.getUTCFullYear() + '-' + formatNumber(value.getUTCMonth() + 1) + '-' +
            formatNumber(value.getUTCDate()) + 'T' + formatNumber(value.getUTCHours()) + ':' +
            formatNumber(value.getUTCMinutes()) + ':' + formatNumber(value.getUTCSeconds()) + 'Z"';
        } else {
            date = 'null';
        }
        return date;
    }

    function stringifyArray(value) {
        var len = value.length,
            partial = [],
            i;
        for (i = 0; i < len; i++) {
            partial.push(str(i, value) || 'null');
        }

        return '[' + partial.join(',') + ']';
    }

    function stringifyObject(value) {
        var partial = [],
            i, v;
        for (i in value) {
            if (Object.prototype.hasOwnProperty.call(value, i)) {
                v = str(i, value);
                if (v) {
                    partial.push(quote(i) + ':' + v);
                }
            }
        }
        return '{' + partial.join(',') + '}';
    }

    function stringifyReference(value) {
        switch (Object.prototype.toString.call(value)) {
            case '[object Date]':
                return stringifyDate(value);
            case '[object Array]':
                return stringifyArray(value);
        }
        return stringifyObject(value);
    }

    function stringifyPrimitive(value, type) {
        switch (type) {
            case 'string':
                return quote(value);
            case 'number':
            case 'float':
            case 'integer':
            case 'int':
                return isFinite(value) ? value : 'null';
            case 'boolean':
                return value;
        }
        return 'null';
    }

    function str(key, holder) {
        var value = holder[key], type = typeof value;

        if (value && typeof value === 'object' && typeof value.toJSON === 'function') {
            value = value.toJSON(key);
            type = typeof value;
        }
        if (/(number|float|int|integer|string|boolean)/.test(type) || (!value && type === 'object')) {
            return stringifyPrimitive(value, type);
        } else {
            return stringifyReference(value);
        }
    }

    function stringify(value) {
        if (window.JSON && typeof window.JSON.stringify === 'function') {
            return window.JSON.stringify(value);
        }

        return str("", { "": value });
    }

    var JsonExporter = function () {
        var me = this;
        this.prepareData = function (data, dataOptions) {
            if (dataOptions) {
                var format = me.getFormat(dataOptions);
                data = me.formatData(data, format.type, format.formatString, format.localization);
            }
            return data;
        }

        var file,
            content,
            currentCell,
            cellHierarchy = [],
            level = 0
        ;

        this.beginFile = function () {
            content = [];
        }

        this.beginHeader = function () {
        }

        this.appendHeaderCell = function (data) {
        }

        this.endHeader = function () {
        }

        this.beginBody = function (data, dataType) {
        }

        this.beginRow = function () {
            var that = this;

            if (!that) {
                that = window.jqx;
            }

            if (that.hierarchy || window.jqx.hierarchy) {
                cellHierarchy[level] = {};
            }
            else {
                currentCell = {};
            }
        }

        this.beginRows = function () {
            cellHierarchy[level].rows = [];
            level++;
            cellHierarchy[level] = {};
        }
        this.endRows = function () {
            level--;
        }

        this.appendBodyCell = function (data, dataType) {
            var that = this;

            if (!that) {
                that = window.jqx;
            }


            var text = this.prepareData(data, dataType);
            if (that.hierarchy || window.jqx.hierarchy) {
                cellHierarchy[level][dataType['text']] = text;
            }
            else {
                currentCell[dataType['text']] = text;
            }
        }

        this.endRow = function () {
            var that = this;

            if (!that) {
                that = window.jqx;
            }


            if (that.hierarchy || window.jqx.hierarchy) {
                if (level == 0) {
                    content.push(cellHierarchy[level]);
                }
                else {
                    cellHierarchy[level - 1].rows.push(cellHierarchy[level]);
                }
            }
            else {
                content.push(currentCell);
            }
        }

        this.endBody = function () {
        }

        this.endFile = function () {
            file = stringify(content);
        }

        this.getFile = function () {
            return file;
        }
    }

    JsonExporter.prototype = new $.jqx.dataAdapter.DataExportModuleBase();
    $.jqx.dataAdapter.ArrayExporter.extend('json', new JsonExporter());

})(jqxBaseFramework);


var pdfDataExport = window.jqxPdfDataExport = (function () {
    'use strict';
    if (typeof btoa === 'undefined') {
        window.btoa = function (data) {
            var b64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",
                b64a = b64.split(''),
                o1,
                o2,
                o3,
                h1,
                h2,
                h3,
                h4,
                bits,
                i = 0,
                ac = 0,
                enc = "",
                tmp_arr = [],
                r;

            do {
                o1 = data.charCodeAt(i++);
                o2 = data.charCodeAt(i++);
                o3 = data.charCodeAt(i++);

                bits = o1 << 16 | o2 << 8 | o3;

                h1 = bits >> 18 & 0x3f;
                h2 = bits >> 12 & 0x3f;
                h3 = bits >> 6 & 0x3f;
                h4 = bits & 0x3f;

                tmp_arr[ac++] = b64a[h1] + b64a[h2] + b64a[h3] + b64a[h4];
            } while (i < data.length);

            enc = tmp_arr.join('');
            r = data.length % 3;
            return (r ? enc.slice(0, r - 3) : enc) + '==='.slice(r || 3);
        };
    }

    if (typeof atob === 'undefined') {
        window.atob = function (data) {

            var b64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",
                o1,
                o2,
                o3,
                h1,
                h2,
                h3,
                h4,
                bits,
                i = 0,
                ac = 0,
                dec = "",
                tmp_arr = [];

            if (!data) {
                return data;
            }

            data += '';

            do { // unpack four hexets into three octets using index points in b64
                h1 = b64.indexOf(data.charAt(i++));
                h2 = b64.indexOf(data.charAt(i++));
                h3 = b64.indexOf(data.charAt(i++));
                h4 = b64.indexOf(data.charAt(i++));

                bits = h1 << 18 | h2 << 12 | h3 << 6 | h4;

                o1 = bits >> 16 & 0xff;
                o2 = bits >> 8 & 0xff;
                o3 = bits & 0xff;

                if (h3 === 64) {
                    tmp_arr[ac++] = String.fromCharCode(o1);
                } else if (h4 === 64) {
                    tmp_arr[ac++] = String.fromCharCode(o1, o2);
                } else {
                    tmp_arr[ac++] = String.fromCharCode(o1, o2, o3);
                }
            } while (i < data.length);
            dec = tmp_arr.join('');
            return dec;
        };
    }

    var getObjectLength = typeof Object.keys === 'function' ?
                function (object) {
                    return Object.keys(object).length;
                } :
                function (object) {
                    var i = 0, e;
                    for (e in object) {
                        if (object.hasOwnProperty(e)) {
                            i++;
                        }
                    }
                    return i;
                },

/**
PubSub implementation

@class
@name PubSub
*/
        PubSub = function (context) {
            /*
            @private
            @fieldOf PubSub
            */
            this.topics = {};
            /**
            Stores what will be `this` within the callback functions.

            @private
            @fieldOf PubSub#
            */
            this.context = context;
            /**
            Allows caller to emit an event and pass arguments to event listeners.
            @public
            @function
            @param topic {String} Name of the channel on which to voice this event
            @param args Any number of arguments you want to pass to the listeners of this event.
            @methodOf PubSub#
            @name publish
            */
            this.publish = function (topic, args) {
                if (this.topics[topic]) {
                    var currentTopic = this.topics[topic],
                        toremove = [],
                        fn,
                        i,
                        l,
                        pair,
                        emptyFunc = function () { };
                    args = Array.prototype.slice.call(arguments, 1);
                    for (i = 0, l = currentTopic.length; i < l; i++) {
                        pair = currentTopic[i]; // this is a [function, once_flag] array
                        fn = pair[0];
                        if (pair[1]) { /* 'run once' flag set */
                            pair[0] = emptyFunc;
                            toremove.push(i);
                        }
                        fn.apply(this.context, args);
                    }
                    for (i = 0, l = toremove.length; i < l; i++) {
                        currentTopic.splice(toremove[i], 1);
                    }
                }
            };
            /**
            Allows listener code to subscribe to channel and be called when data is available
            @public
            @function
            @param topic {String} Name of the channel on which to voice this event
            @param callback {Function} Executable (function pointer) that will be ran when event is voiced on this channel.
            @param once {Boolean} (optional. False by default) Flag indicating if the function is to be triggered only once.
            @returns {Object} A token object that cen be used for unsubscribing.
            @methodOf PubSub#
            @name subscribe
            */
            this.subscribe = function (topic, callback, once) {
                if (!this.topics[topic]) {
                    this.topics[topic] = [[callback, once]];
                } else {
                    this.topics[topic].push([callback, once]);
                }
                return {
                    "topic": topic,
                    "callback": callback
                };
            };
            /**
            Allows listener code to unsubscribe from a channel
            @public
            @function
            @param token {Object} A token object that was returned by `subscribe` method
            @methodOf PubSub#
            @name unsubscribe
            */
            this.unsubscribe = function (token) {
                if (this.topics[token.topic]) {
                    var currentTopic = this.topics[token.topic], i, l;

                    for (i = 0, l = currentTopic.length; i < l; i++) {
                        if (currentTopic[i][0] === token.callback) {
                            currentTopic.splice(i, 1);
                        }
                    }
                }
            };
        };


    /**
    @constructor
    @private
    */
    function pdfDataExport(orientation, unit, format, compressPdf) { /** String orientation, String unit, String format, Boolean compressed */

        // Default parameter values
        if (typeof orientation === 'undefined') {
            orientation = 'p';
        } else {
            orientation = orientation.toString().toLowerCase();
        }
        if (typeof unit === 'undefined') { unit = 'mm'; }
        if (typeof format === 'undefined') { format = 'a4'; }
        if (typeof compressPdf === 'undefined' && typeof zpipe === 'undefined') { compressPdf = false; }

        var format_as_string = format.toString().toLowerCase(),
            version = '0.9.0rc2',
            content = [],
            content_length = 0,
            compress = compressPdf,
            pdfVersion = '1.3', // PDF Version
            pageFormats = { // Size in pt of various paper formats
                'a3': [841.89, 1190.55],
                'a4': [595.28, 841.89],
                'a5': [420.94, 595.28],
                'letter': [612, 792],
                'legal': [612, 1008]
            },
            textColor = '0 g',
            drawColor = '0 G',
            page = 0,
            pages = [],
            objectNumber = 2, // 'n' Current object number
            outToPages = false, // switches where out() prints. outToPages true = push to pages obj. outToPages false = doc builder content
            offsets = [], // List of offsets. Activated and reset by buildDocument(). Pupulated by various calls buildDocument makes.
            fonts = {}, // collection of font objects, where key is fontKey - a dynamically created label for a given font.
            fontmap = {}, // mapping structure fontName > fontStyle > font key - performance layer. See addFont()
            activeFontSize = 16,
            activeFontKey, // will be string representing the KEY of the font as combination of fontName + fontStyle
            lineWidth = 0.200025, // 2mm
            pageHeight,
            pageWidth,
            k, // Scale factor
            documentProperties = { 'title': '', 'subject': '', 'author': '', 'keywords': '', 'creator': '' },
            lineCapID = 0,
            lineJoinID = 0,
            API = {},
            events = new PubSub(API),
            tmp,
            plugin,
            /////////////////////
            // Private functions
            /////////////////////
            // simplified (speedier) replacement for sprintf's %.2f conversion
            f2 = function (number) {
                return number.toFixed(2);
            },
            // simplified (speedier) replacement for sprintf's %.3f conversion
            f3 = function (number) {
                return number.toFixed(3);
            },
            // simplified (speedier) replacement for sprintf's %02d
            padd2 = function (number) {
                var n = (number).toFixed(0);
                if (number < 10) {
                    return '0' + n;
                } else {
                    return n;
                }
            },
            // simplified (speedier) replacement for sprintf's %02d
            padd10 = function (number) {
                var n = (number).toFixed(0);
                if (n.length < 10) {
                    return new Array(11 - n.length).join('0') + n;
                } else {
                    return n;
                }
            },
            out = function (string) {
                if (outToPages) { /* set by beginPage */
                    pages[page].push(string);
                } else {
                    content.push(string);
                    content_length += string.length + 1; // +1 is for '\n' that will be used to join contents of content
                }
            },
            newObject = function () {
                // Begin a new object
                objectNumber++;
                offsets[objectNumber] = content_length;
                out(objectNumber + ' 0 obj');
                return objectNumber;
            },
            putStream = function (str) {
                out('stream');
                out(str);
                out('endstream');
            },
            wPt,
            hPt,
            kids,
            i,
            putPages = function () {
                wPt = pageWidth * k;
                hPt = pageHeight * k;

                // outToPages = false as set in endDocument(). out() writes to content.

                var n, p, arr, uint, i, deflater, adler32;
                for (n = 1; n <= page; n++) {
                    newObject();
                    out('<</Type /Page');
                    out('/Parent 1 0 R');
                    out('/Resources 2 0 R');
                    out('/Contents ' + (objectNumber + 1) + ' 0 R>>');
                    out('endobj');

                    // Page content
                    p = pages[n].join('\n');
                    newObject();
                    if (compress) {
                        arr = [];
                        for (i = 0; i < p.length; ++i) {
                            arr[i] = p.charCodeAt(i);
                        }
                        adler32 = adler32cs.from(p);
                        deflater = new Deflater(6);
                        deflater.append(new Uint8Array(arr));
                        p = deflater.flush();
                        arr = [new Uint8Array([120, 156]), new Uint8Array(p),
                               new Uint8Array([adler32 & 0xFF, (adler32 >> 8) & 0xFF, (adler32 >> 16) & 0xFF, (adler32 >> 24) & 0xFF])];
                        p = '';
                        for (i in arr) {
                            if (arr.hasOwnProperty(i)) {
                                p += String.fromCharCode.apply(null, arr[i]);
                            }
                        }
                        out('<</Length ' + p.length + ' /Filter [/FlateDecode]>>');
                    } else {
                        out('<</Length ' + p.length + '>>');
                    }
                    putStream(p);
                    out('endobj');
                }
                offsets[1] = content_length;
                out('1 0 obj');
                out('<</Type /Pages');
                kids = '/Kids [';
                for (i = 0; i < page; i++) {
                    kids += (3 + 2 * i) + ' 0 R ';
                }
                out(kids + ']');
                out('/Count ' + page);
                out('/MediaBox [0 0 ' + f2(wPt) + ' ' + f2(hPt) + ']');
                out('>>');
                out('endobj');
            },
            putFont = function (font) {
                font.objectNumber = newObject();
                out('<</BaseFont/' + font.PostScriptName + '/Type/Font');
                if (typeof font.encoding === 'string') {
                    out('/Encoding/' + font.encoding);
                }
                out('/Subtype/Type1>>');
                out('endobj');
            },
            putFonts = function () {
                var fontKey;
                for (fontKey in fonts) {
                    if (fonts.hasOwnProperty(fontKey)) {
                        putFont(fonts[fontKey]);
                    }
                }
            },
            putXobjectDict = function () {
                // Loop through images, or other data objects
                events.publish('putXobjectDict');
            },
            putResourceDictionary = function () {
                out('/ProcSet [/PDF /Text /ImageB /ImageC /ImageI]');
                out('/Font <<');
                // Do this for each font, the '1' bit is the index of the font
                var fontKey;
                for (fontKey in fonts) {
                    if (fonts.hasOwnProperty(fontKey)) {
                        out('/' + fontKey + ' ' + fonts[fontKey].objectNumber + ' 0 R');
                    }
                }
                out('>>');
                out('/XObject <<');
                putXobjectDict();
                out('>>');
            },
            putResources = function () {
                putFonts();
                events.publish('putResources');
                // Resource dictionary
                offsets[2] = content_length;
                out('2 0 obj');
                out('<<');
                putResourceDictionary();
                out('>>');
                out('endobj');
                events.publish('postPutResources');
            },
            addToFontDictionary = function (fontKey, fontName, fontStyle) {
                // this is mapping structure for quick font key lookup.
                // returns the KEY of the font (ex: "F1") for a given pair of font name and type (ex: "Arial". "Italic")
                var undef;
                if (fontmap[fontName] === undef) {
                    fontmap[fontName] = {}; // fontStyle is a var interpreted and converted to appropriate string. don't wrap in quotes.
                }
                fontmap[fontName][fontStyle] = fontKey;
            },
            /**
            FontObject describes a particular font as member of an instnace of pdfDataExport

            It's a collection of properties like 'id' (to be used in PDF stream),
            'fontName' (font's family name), 'fontStyle' (font's style variant label)

            @class
            @public
            @property id {String} PDF-document-instance-specific label assinged to the font.
            @property PostScriptName {String} PDF specification full name for the font
            @property encoding {Object} Encoding_name-to-Font_metrics_object mapping.
            @name FontObject
            */
            FontObject = {},
            addFont = function (PostScriptName, fontName, fontStyle, encoding) {
                var fontKey = 'F' + (getObjectLength(fonts) + 1).toString(10),
                    // This is FontObject
                    font = fonts[fontKey] = {
                        'id': fontKey,
                        // , 'objectNumber':   will be set by putFont()
                        'PostScriptName': PostScriptName,
                        'fontName': fontName,
                        'fontStyle': fontStyle,
                        'encoding': encoding,
                        'metadata': {}
                    };

                addToFontDictionary(fontKey, fontName, fontStyle);

                events.publish('addFont', font);

                return fontKey;
            },
            addFonts = function () {

                var HELVETICA = "helvetica",
                    TIMES = "times",
                    COURIER = "courier",
                    NORMAL = "normal",
                    BOLD = "bold",
                    ITALIC = "italic",
                    BOLD_ITALIC = "bolditalic",
                    encoding = 'StandardEncoding',
                    standardFonts = [
                        ['Helvetica', HELVETICA, NORMAL],
                        ['Helvetica-Bold', HELVETICA, BOLD],
                        ['Helvetica-Oblique', HELVETICA, ITALIC],
                        ['Helvetica-BoldOblique', HELVETICA, BOLD_ITALIC],
                        ['Courier', COURIER, NORMAL],
                        ['Courier-Bold', COURIER, BOLD],
                        ['Courier-Oblique', COURIER, ITALIC],
                        ['Courier-BoldOblique', COURIER, BOLD_ITALIC],
                        ['Times-Roman', TIMES, NORMAL],
                        ['Times-Bold', TIMES, BOLD],
                        ['Times-Italic', TIMES, ITALIC],
                        ['Times-BoldItalic', TIMES, BOLD_ITALIC]
                    ],
                    i,
                    l,
                    fontKey,
                    parts;
                for (i = 0, l = standardFonts.length; i < l; i++) {
                    var en = encoding;

                    fontKey = addFont(
                        standardFonts[i][0],
                        standardFonts[i][1],
                        standardFonts[i][2],
                        en
                    );

                    // adding aliases for standard fonts, this time matching the capitalization
                    parts = standardFonts[i][0].split('-');
                    addToFontDictionary(fontKey, parts[0], parts[1] || '');
                }

                events.publish('addFonts', { 'fonts': fonts, 'dictionary': fontmap });
            },
            /**

            @public
            @function
            @param text {String}
            @param flags {Object} Encoding flags.
            @returns {String} Encoded string
            */
            to8bitStream = function (text, flags) {

                var i, l, undef, sourceEncoding, encodingBlock, outputEncoding, newtext, isUnicode, ch, bch;

                if (flags === undef) {
                    flags = {};
                }

                sourceEncoding = flags.sourceEncoding ? sourceEncoding : 'Unicode';

                outputEncoding = flags.outputEncoding;

                // This 'encoding' section relies on font metrics format
                // attached to font objects by, among others,
                // "Willow Systems' standard_font_metrics plugin"
                // see pdfDataExport.plugin.standard_font_metrics.js for format
                // of the font.metadata.encoding Object.
                // It should be something like
                //   .encoding = {'codePages':['WinANSI....'], 'WinANSI...':{code:code, ...}}
                //   .widths = {0:width, code:width, ..., 'fof':divisor}
                //   .kerning = {code:{previous_char_code:shift, ..., 'fof':-divisor},...}
                if ((flags.autoencode || outputEncoding) &&
                        fonts[activeFontKey].metadata &&
                        fonts[activeFontKey].metadata[sourceEncoding] &&
                        fonts[activeFontKey].metadata[sourceEncoding].encoding
                        ) {
                    encodingBlock = fonts[activeFontKey].metadata[sourceEncoding].encoding;

                    // each font has default encoding. Some have it clearly defined.
                    if (!outputEncoding && fonts[activeFontKey].encoding) {
                        outputEncoding = fonts[activeFontKey].encoding;
                    }

                    // Hmmm, the above did not work? var's try again, in different place.
                    if (!outputEncoding && encodingBlock.codePages) {
                        outputEncoding = encodingBlock.codePages[0]; // var's say, first one is the default
                    }

                    if (typeof outputEncoding === 'string') {
                        outputEncoding = encodingBlock[outputEncoding];
                    }
                    // we want output encoding to be a JS Object, where
                    // key = sourceEncoding's character code and
                    // value = outputEncoding's character code.
                    if (outputEncoding) {
                        isUnicode = false;
                        newtext = [];
                        for (i = 0, l = text.length; i < l; i++) {
                            ch = outputEncoding[text.charCodeAt(i)];
                            if (ch) {
                                newtext.push(
                                    String.fromCharCode(ch)
                                );
                            } else {
                                newtext.push(
                                    text[i]
                                );
                            }

                            // since we are looping over chars anyway, might as well
                            // check for residual unicodeness
                            if (newtext[i].charCodeAt(0) >> 8) { /* more than 255 */
                                isUnicode = true;
                            }
                        }
                        text = newtext.join('');
                    }
                }

                i = text.length;
                // isUnicode may be set to false above. Hence the triple-equal to undefined
                while (isUnicode === undef && i !== 0) {
                    if (text.charCodeAt(i - 1) >> 8) { /* more than 255 */
                        isUnicode = true;
                    }
                    i--;
                }
                if (!isUnicode) {
                    return text;
                } else {
                    newtext = flags.noBOM ? [] : [254, 255];
                    for (i = 0, l = text.length; i < l; i++) {
                        ch = text.charCodeAt(i);
                        bch = ch >> 8; // divide by 256
                        if (bch >> 8) { /* something left after dividing by 256 second time */
                            throw new Error("Character at position " + i.toString(10) + " of string '" + text + "' exceeds 16bits. Cannot be encoded into UCS-2 BE");
                        }
                        newtext.push(bch);
                        newtext.push(ch - (bch << 8));
                    }
                    return String.fromCharCode.apply(undef, newtext);
                }
            },
            // Replace '/', '(', and ')' with pdf-safe versions
            pdfEscape = function (text, flags) {
                // doing to8bitStream does NOT make this PDF display unicode text. For that
                // we also need to reference a unicode font and embed it - royal pain in the rear.

                // There is still a benefit to to8bitStream - PDF simply cannot handle 16bit chars,
                // which JavaScript Strings are happy to provide. So, while we still cannot display
                // 2-byte characters property, at least CONDITIONALLY converting (entire string containing)
                // 16bit chars to (USC-2-BE) 2-bytes per char + BOM streams we ensure that entire PDF
                // is still parseable.
                // This will allow immediate support for unicode in document properties strings.
                return to8bitStream(text, flags).replace(/\\/g, '\\\\').replace(/\(/g, '\\(').replace(/\)/g, '\\)');
            },
            putInfo = function () {
                out('/Producer (pdfDataExport ' + version + ')');
                if (documentProperties.title) {
                    out('/Title (' + pdfEscape(documentProperties.title) + ')');
                }
                if (documentProperties.subject) {
                    out('/Subject (' + pdfEscape(documentProperties.subject) + ')');
                }
                if (documentProperties.author) {
                    out('/Author (' + pdfEscape(documentProperties.author) + ')');
                }
                if (documentProperties.keywords) {
                    out('/Keywords (' + pdfEscape(documentProperties.keywords) + ')');
                }
                if (documentProperties.creator) {
                    out('/Creator (' + pdfEscape(documentProperties.creator) + ')');
                }
                var created = new Date();
                out('/CreationDate (D:' +
                    [
                        created.getFullYear(),
                        padd2(created.getMonth() + 1),
                        padd2(created.getDate()),
                        padd2(created.getHours()),
                        padd2(created.getMinutes()),
                        padd2(created.getSeconds())
                    ].join('') +
                    ')'
                    );
            },
            putCatalog = function () {
                out('/Type /Catalog');
                out('/Pages 1 0 R');
                // @TODO: Add zoom and layout modes
                out('/OpenAction [3 0 R /FitH null]');
                out('/PageLayout /OneColumn');
                events.publish('putCatalog');
            },
            putTrailer = function () {
                out('/Size ' + (objectNumber + 1));
                out('/Root ' + objectNumber + ' 0 R');
                out('/Info ' + (objectNumber - 1) + ' 0 R');
            },
            beginPage = function () {
                page++;
                // Do dimension stuff
                outToPages = true;
                pages[page] = [];
            },
            _addPage = function () {
                beginPage();
                // Set line width
                out(f2(lineWidth * k) + ' w');
                // Set draw color
                out(drawColor);
                // resurrecting non-default line caps, joins
                if (lineCapID !== 0) {
                    out(lineCapID.toString(10) + ' J');
                }
                if (lineJoinID !== 0) {
                    out(lineJoinID.toString(10) + ' j');
                }
                events.publish('addPage', { 'pageNumber': page });
            },
            /**
            Returns a document-specific font key - a label assigned to a
            font name + font type combination at the time the font was added
            to the font inventory.

            Font key is used as label for the desired font for a block of text
            to be added to the PDF document stream.
            @private
            @function
            @param fontName {String} can be undefined on "falthy" to indicate "use current"
            @param fontStyle {String} can be undefined on "falthy" to indicate "use current"
            @returns {String} Font key.
            */
            getFont = function (fontName, fontStyle) {
                var key, undef;

                if (fontName === undef) {
                    fontName = fonts[activeFontKey].fontName;
                }
                if (fontStyle === undef) {
                    fontStyle = fonts[activeFontKey].fontStyle;
                }

                try {
                    key = fontmap[fontName][fontStyle]; // returns a string like 'F3' - the KEY corresponding tot he font + type combination.
                } catch (e) {
                    key = undef;
                }
                if (!key) {
                    throw new Error("Unable to look up font label for font '" + fontName + "', '" + fontStyle + "'. Refer to getFontList() for available fonts.");
                }

                return key;
            },
            buildDocument = function () {

                outToPages = false; // switches out() to content
                content = [];
                offsets = [];

                // putHeader()
                out('%PDF-' + pdfVersion);

                putPages();

                putResources();

                // Info
                newObject();
                out('<<');
                putInfo();
                out('>>');
                out('endobj');

                // Catalog
                newObject();
                out('<<');
                putCatalog();
                out('>>');
                out('endobj');

                // Cross-ref
                var o = content_length, i;
                out('xref');
                out('0 ' + (objectNumber + 1));
                out('0000000000 65535 f ');
                for (i = 1; i <= objectNumber; i++) {
                    out(padd10(offsets[i]) + ' 00000 n ');
                }
                // Trailer
                out('trailer');
                out('<<');
                putTrailer();
                out('>>');
                out('startxref');
                out(o);
                out('%%EOF');

                outToPages = true;

                return content.join('\n');
            },
            getStyle = function (style) {
                // see Path-Painting Operators of PDF spec
                var op = 'S'; // stroke
                if (style === 'F') {
                    op = 'f'; // fill
                } else if (style === 'FD' || style === 'DF') {
                    op = 'B'; // both
                }
                return op;
            },

            /**
            Generates the PDF document.
            Possible values:
                datauristring (alias dataurlstring) - Data-Url-formatted data returned as string.
                datauri (alias datauri) - Data-Url-formatted data pushed into current window's location (effectively reloading the window with contents of the PDF).

            If `type` argument is undefined, output is raw body of resulting PDF returned as a string.

            @param {String} type A string identifying one of the possible output types.
            @param {Object} options An object providing some additional signalling to PDF generator.
            @function
            @returns {pdfDataExport}
            @methodOf pdfDataExport#
            @name output
            */
            output = function (type, options) {
                var undef, data, length, array, i, blob;
                switch (type) {
                    case undef:
                        return buildDocument();
                    case 'save':
                        if (navigator.getUserMedia) {
                            if (window.URL === undefined) {
                                return API.output('dataurlnewwindow');
                            } else if (window.URL.createObjectURL === undefined) {
                                return API.output('dataurlnewwindow');
                            }
                        }
                        data = buildDocument();

                        // Need to add the file to BlobBuilder as a Uint8Array
                        length = data.length;
                        array = new Uint8Array(new ArrayBuffer(length));

                        for (i = 0; i < length; i++) {
                            array[i] = data.charCodeAt(i);
                        }

                        blob = new Blob([array], { type: "application/pdf" });

                        saveAs(blob, options);
                        break;
                    case 'datauristring':
                    case 'dataurlstring':
                        return 'data:application/pdf;base64,' + btoa(buildDocument());
                    case 'datauri':
                    case 'dataurl':
                        document.location.href = 'data:application/pdf;base64,' + btoa(buildDocument());
                        break;
                    case 'dataurlnewwindow':
                        window.open('data:application/pdf;base64,' + btoa(buildDocument()));
                        break;
                    default:
                        throw new Error('Output type "' + type + '" is not supported.');
                }
                // @TODO: Add different output options
            };

        if (unit === 'pt') {
            k = 1;
        } else if (unit === 'mm') {
            k = 72 / 25.4;
        } else if (unit === 'cm') {
            k = 72 / 2.54;
        } else if (unit === 'in') {
            k = 72;
        } else {
            throw ('Invalid unit: ' + unit);
        }

        // Dimensions are stored as user units and converted to points on output
        if (pageFormats.hasOwnProperty(format_as_string)) {
            pageHeight = pageFormats[format_as_string][1] / k;
            pageWidth = pageFormats[format_as_string][0] / k;
        } else {
            try {
                pageHeight = format[1];
                pageWidth = format[0];
            } catch (err) {
                throw ('Invalid format: ' + format);
            }
        }

        if (orientation === 'p' || orientation === 'portrait') {
            orientation = 'p';
            if (pageWidth > pageHeight) {
                tmp = pageWidth;
                pageWidth = pageHeight;
                pageHeight = tmp;
            }
        } else if (orientation === 'l' || orientation === 'landscape') {
            orientation = 'l';
            if (pageHeight > pageWidth) {
                tmp = pageWidth;
                pageWidth = pageHeight;
                pageHeight = tmp;
            }
        } else {
            throw ('Invalid orientation: ' + orientation);
        }



        //---------------------------------------
        // Public API

        /*
        Object exposing internal API to plugins
        @public
        */
        API.internal = {
            'pdfEscape': pdfEscape,
            'getStyle': getStyle,
            /**
            Returns {FontObject} describing a particular font.
            @public
            @function
            @param fontName {String} (Optional) Font's family name
            @param fontStyle {String} (Optional) Font's style variation name (Example:"Italic")
            @returns {FontObject}
            */
            'getFont': function () { return fonts[getFont.apply(API, arguments)]; },
            'getFontSize': function () { return activeFontSize; },
            'btoa': btoa,
            'write': function (string1, string2, string3, etc) {
                out(
                    arguments.length === 1 ? string1 : Array.prototype.join.call(arguments, ' ')
                );
            },
            'getCoordinateString': function (value) {
                return f2(value * k);
            },
            'getVerticalCoordinateString': function (value) {
                return f2((pageHeight - value) * k);
            },
            'collections': {},
            'newObject': newObject,
            'putStream': putStream,
            'events': events,
            // ratio that you use in multiplication of a given "size" number to arrive to 'point'
            // units of measurement.
            // scaleFactor is set at initialization of the document and calculated against the stated
            // default measurement units for the document.
            // If default is "mm", k is the number that will turn number in 'mm' into 'points' number.
            // through multiplication.
            'scaleFactor': k,
            'pageSize': { 'width': pageWidth, 'height': pageHeight },
            'output': function (type, options) {
                return output(type, options);
            }
        };

        /**
        Adds (and transfers the focus to) new page to the PDF document.
        @function
        @returns {pdfDataExport}

        @methodOf pdfDataExport#
        @name addPage
         */
        API.addPage = function () {
            _addPage();
            return this;
        };

        var padz =
[
   "",
   "0",
   "00",
   "000",
   "0000"
];
        var pdfEscape16 = function (text, flags) {
            var ar = ["FEFF"];
            for (var i = 0, l = text.length, t; i < l; ++i) {
                t = text.charCodeAt(i).toString(16).toUpperCase();
                ar.push(padz[4 - t.length], t);
            }
            return ar.join("");
        };

        API.text16 = function (text, x, y, flags) {
            /**
            * Inserts something like this into PDF
            BT
            /F1 16 Tf % Font name + size
            16 TL % How many units down for next line in multiline text
            0 g % color
            28.35 813.54 Td % position
            (line one) Tj
            T* (line two) Tj
            T* (line three) Tj
            ET
            */

            var undef, _first, _second, _third, newtext, str, i;
            // Pre-August-2012 the order of arguments was function(x, y, text, flags)
            // in effort to make all calls have similar signature like
            // function(data, coordinates... , miscellaneous)
            // this method had its args flipped.
            // code below allows backward compatibility with old arg order.
            if (typeof text === 'number') {
                _first = y;
                _second = text;
                _third = x;

                text = _first;
                x = _second;
                y = _third;
            }

            // If there are any newlines in text, we assume
            // the user wanted to print multiple lines, so break the
            // text up into an array. If the text is already an array,
            // we assume the user knows what they are doing.
            if (typeof text === 'string' && text.match(/[\n\r]/)) {
                text = text.split(/\r\n|\r|\n/g);
            }

            if (typeof flags === 'undefined') {
                flags = { 'noBOM': true, 'autoencode': true };
            } else {

                if (flags.noBOM === undef) {
                    flags.noBOM = true;
                }

                if (flags.autoencode === undef) {
                    flags.autoencode = true;
                }

            }
            flags.autoencode = false;
            if (typeof text === 'string') {
                str = pdfEscape16(text, flags);
            } else if (text instanceof Array) { /* Array */
                // we don't want to destroy original text array, so cloning it
                newtext = text.concat();
                // we do array.join('text that must not be PDFescaped")
                // thus, pdfEscape each component separately
                for (i = newtext.length - 1; i !== -1; i--) {
                    newtext[i] = pdfEscape16(newtext[i], flags);
                }
                str = newtext.join("> Tj\nT* <");
            } else {
                throw new Error('Type of text must be string or Array. "' + text + '" is not recognized.');
            }
            // Using "'" ("go next line and render text" mark) would save space but would complicate our rendering code, templates

            // BT .. ET does NOT have default settings for Tf. You must state that explicitely every time for BT .. ET
            // if you want text transformation matrix (+ multiline) to work reliably (which reads sizes of things from font declarations)
            // Thus, there is NO useful, *reliable* concept of "default" font for a page.
            // The fact that "default" (reuse font used before) font worked before in basic cases is an accident
            // - readers dealing smartly with brokenness of jsPDF's markup.
            out(
                'BT\n/' +
                    activeFontKey + ' ' + activeFontSize + ' Tf\n' + // font face, style, size
                      activeFontSize + ' TL\n' + // line spacing
                     textColor +
                    '\n' + f2(x * k) + ' ' + f2((pageHeight - y) * k) + ' Td\n<' +
                    str +
                    '> Tj\nET'
            );

            return this;
        };
        /**
        Adds text to page. Supports adding multiline text when 'text' argument is an Array of Strings.
        @function
        @param {String|Array} text String or array of strings to be added to the page. Each line is shifted one line down per font, spacing settings declared before this call.
        @param {Number} x Coordinate (in units declared at inception of PDF document) against left edge of the page
        @param {Number} y Coordinate (in units declared at inception of PDF document) against upper edge of the page
        @param {Object} flags Collection of settings signalling how the text must be encoded. Defaults are sane. If you think you want to pass some flags, you likely can read the source.
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name text
         */
        API.text = function (text, x, y, flags) {
            /**
             * Inserts something like this into PDF
                BT
                /F1 16 Tf  % Font name + size
                16 TL % How many units down for next line in multiline text
                0 g % color
                28.35 813.54 Td % position
                (line one) Tj
                T* (line two) Tj
                T* (line three) Tj
                ET
            */

            var undef, _first, _second, _third, newtext, str, i;
            if (typeof text === 'number') {
                _first = y;
                _second = text;
                _third = x;

                text = _first;
                x = _second;
                y = _third;
            }

            if (typeof text === 'string' && text.match(/[\n\r]/)) {
                text = text.split(/\r\n|\r|\n/g);
            }

            if (typeof flags === 'undefined') {
                flags = { 'noBOM': true, 'autoencode': true };
            } else {

                if (flags.noBOM === undef) {
                    flags.noBOM = true;
                }

                if (flags.autoencode === undef) {
                    flags.autoencode = true;
                }

            }

            if (typeof text === 'string') {
                str = pdfEscape(text, flags);
            } else if (text instanceof Array) {  /* Array */
                // we don't want to destroy  original text array, so cloning it
                newtext = text.concat();
                // we do array.join('text that must not be PDFescaped")
                // thus, pdfEscape each component separately
                for (i = newtext.length - 1; i !== -1; i--) {
                    newtext[i] = pdfEscape(newtext[i], flags);
                }
                str = newtext.join(") Tj\nT* (");
            } else {
                throw new Error('Type of text must be string or Array. "' + text + '" is not recognized.');
            }
            out(
             'BT\n/' +
                 activeFontKey + ' ' + activeFontSize + ' Tf\n' + // font face, style, size
                 activeFontSize + ' TL\n' + // line spacing
                 textColor +
                 '\n' + f2(x * k) + ' ' + f2((pageHeight - y) * k) + ' Td\n(' +
                 str +
                 ') Tj\nET'
         );
            return this;
        };

        API.line = function (x1, y1, x2, y2) {
            out(
                f2(x1 * k) + ' ' + f2((pageHeight - y1) * k) + ' m ' +
                    f2(x2 * k) + ' ' + f2((pageHeight - y2) * k) + ' l S'
            );
            return this;
        };

        /**
        Adds series of curves (straight lines or cubic bezier curves) to canvas, starting at `x`, `y` coordinates.
        All data points in `lines` are relative to last line origin.
        `x`, `y` become x1,y1 for first line / curve in the set.
        For lines you only need to specify [x2, y2] - (ending point) vector against x1, y1 starting point.
        For bezier curves you need to specify [x2,y2,x3,y3,x4,y4] - vectors to control points 1, 2, ending point. All vectors are against the start of the curve - x1,y1.

        @example .lines([[2,2],[-2,2],[1,1,2,2,3,3],[2,1]], 212,110, 10) // line, line, bezier curve, line
        @param {Array} lines Array of *vector* shifts as pairs (lines) or sextets (cubic bezier curves).
        @param {Number} x Coordinate (in units declared at inception of PDF document) against left edge of the page
        @param {Number} y Coordinate (in units declared at inception of PDF document) against upper edge of the page
        @param {Number} scale (Defaults to [1.0,1.0]) x,y Scaling factor for all vectors. Elements can be any floating number Sub-one makes drawing smaller. Over-one grows the drawing. Negative flips the direction.
        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name lines
         */
        API.lines = function (lines, x, y, scale, style) {
            var undef, _first, _second, _third, scalex, scaley, i, l, leg, x2, y2, x3, y3, x4, y4;

            // Pre-August-2012 the order of arguments was function(x, y, lines, scale, style)
            // in effort to make all calls have similar signature like
            //   function(content, coordinateX, coordinateY , miscellaneous)
            // this method had its args flipped.
            // code below allows backward compatibility with old arg order.
            if (typeof lines === 'number') {
                _first = y;
                _second = lines;
                _third = x;

                lines = _first;
                x = _second;
                y = _third;
            }

            style = getStyle(style);
            scale = scale === undef ? [1, 1] : scale;

            // starting point
            out(f3(x * k) + ' ' + f3((pageHeight - y) * k) + ' m ');

            scalex = scale[0];
            scaley = scale[1];
            l = lines.length;
            //, x2, y2 // bezier only. In page default measurement "units", *after* scaling
            //, x3, y3 // bezier only. In page default measurement "units", *after* scaling
            // ending point for all, lines and bezier. . In page default measurement "units", *after* scaling
            x4 = x; // last / ending point = starting point for first item.
            y4 = y; // last / ending point = starting point for first item.

            for (i = 0; i < l; i++) {
                leg = lines[i];
                if (leg.length === 2) {
                    // simple line
                    x4 = leg[0] * scalex + x4; // here last x4 was prior ending point
                    y4 = leg[1] * scaley + y4; // here last y4 was prior ending point
                    out(f3(x4 * k) + ' ' + f3((pageHeight - y4) * k) + ' l');
                } else {
                    // bezier curve
                    x2 = leg[0] * scalex + x4; // here last x4 is prior ending point
                    y2 = leg[1] * scaley + y4; // here last y4 is prior ending point
                    x3 = leg[2] * scalex + x4; // here last x4 is prior ending point
                    y3 = leg[3] * scaley + y4; // here last y4 is prior ending point
                    x4 = leg[4] * scalex + x4; // here last x4 was prior ending point
                    y4 = leg[5] * scaley + y4; // here last y4 was prior ending point
                    out(
                        f3(x2 * k) + ' ' +
                            f3((pageHeight - y2) * k) + ' ' +
                            f3(x3 * k) + ' ' +
                            f3((pageHeight - y3) * k) + ' ' +
                            f3(x4 * k) + ' ' +
                            f3((pageHeight - y4) * k) + ' c'
                    );
                }
            }
            // stroking / filling / both the path
            out(style);
            return this;
        };

        /**
        Adds a rectangle to PDF

        @param {Number} x Coordinate (in units declared at inception of PDF document) against left edge of the page
        @param {Number} y Coordinate (in units declared at inception of PDF document) against upper edge of the page
        @param {Number} w Width (in units declared at inception of PDF document)
        @param {Number} h Height (in units declared at inception of PDF document)
        @param {String} style (Defaults to active fill/stroke style) A string signalling if stroke, fill or both are to be applied.
        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name rect
         */
        API.rect = function (x, y, w, h, style) {
            var op = getStyle(style);
            out([
                f2(x * k),
                f2((pageHeight - y) * k),
                f2(w * k),
                f2(-h * k),
                're',
                op
            ].join(' '));
            return this;
        };

        /**
        Adds a triangle to PDF

        @param {Number} x1 Coordinate (in units declared at inception of PDF document) against left edge of the page
        @param {Number} y1 Coordinate (in units declared at inception of PDF document) against upper edge of the page
        @param {Number} x2 Coordinate (in units declared at inception of PDF document) against left edge of the page
        @param {Number} y2 Coordinate (in units declared at inception of PDF document) against upper edge of the page
        @param {Number} x3 Coordinate (in units declared at inception of PDF document) against left edge of the page
        @param {Number} y3 Coordinate (in units declared at inception of PDF document) against upper edge of the page
        @param {String} style (Defaults to active fill/stroke style) A string signalling if stroke, fill or both are to be applied.
        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name triangle
         */
        API.triangle = function (x1, y1, x2, y2, x3, y3, style) {
            this.lines(
                [
                    [x2 - x1, y2 - y1], // vector to point 2
                    [x3 - x2, y3 - y2], // vector to point 3
                    [x1 - x3, y1 - y3] // closing vector back to point 1
                ],
                x1,
                y1, // start of path
                [1, 1],
                style
            );
            return this;
        };

        /**
        Adds a rectangle with rounded corners to PDF

        @param {Number} x Coordinate (in units declared at inception of PDF document) against left edge of the page
        @param {Number} y Coordinate (in units declared at inception of PDF document) against upper edge of the page
        @param {Number} w Width (in units declared at inception of PDF document)
        @param {Number} h Height (in units declared at inception of PDF document)
        @param {Number} rx Radius along x axis (in units declared at inception of PDF document)
        @param {Number} rx Radius along y axis (in units declared at inception of PDF document)
        @param {String} style (Defaults to active fill/stroke style) A string signalling if stroke, fill or both are to be applied.
        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name roundedRect
        */
        API.roundedRect = function (x, y, w, h, rx, ry, style) {
            var MyArc = 4 / 3 * (Math.SQRT2 - 1);
            this.lines(
                [
                    [(w - 2 * rx), 0],
                    [(rx * MyArc), 0, rx, ry - (ry * MyArc), rx, ry],
                    [0, (h - 2 * ry)],
                    [0, (ry * MyArc), -(rx * MyArc), ry, -rx, ry],
                    [(-w + 2 * rx), 0],
                    [-(rx * MyArc), 0, -rx, -(ry * MyArc), -rx, -ry],
                    [0, (-h + 2 * ry)],
                    [0, -(ry * MyArc), (rx * MyArc), -ry, rx, -ry]
                ],
                x + rx,
                y, // start of path
                [1, 1],
                style
            );
            return this;
        };

        /**
        Adds an ellipse to PDF

        @param {Number} x Coordinate (in units declared at inception of PDF document) against left edge of the page
        @param {Number} y Coordinate (in units declared at inception of PDF document) against upper edge of the page
        @param {Number} rx Radius along x axis (in units declared at inception of PDF document)
        @param {Number} rx Radius along y axis (in units declared at inception of PDF document)
        @param {String} style (Defaults to active fill/stroke style) A string signalling if stroke, fill or both are to be applied.
        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name ellipse
         */
        API.ellipse = function (x, y, rx, ry, style) {
            var op = getStyle(style),
                lx = 4 / 3 * (Math.SQRT2 - 1) * rx,
                ly = 4 / 3 * (Math.SQRT2 - 1) * ry;

            out([
                f2((x + rx) * k),
                f2((pageHeight - y) * k),
                'm',
                f2((x + rx) * k),
                f2((pageHeight - (y - ly)) * k),
                f2((x + lx) * k),
                f2((pageHeight - (y - ry)) * k),
                f2(x * k),
                f2((pageHeight - (y - ry)) * k),
                'c'
            ].join(' '));
            out([
                f2((x - lx) * k),
                f2((pageHeight - (y - ry)) * k),
                f2((x - rx) * k),
                f2((pageHeight - (y - ly)) * k),
                f2((x - rx) * k),
                f2((pageHeight - y) * k),
                'c'
            ].join(' '));
            out([
                f2((x - rx) * k),
                f2((pageHeight - (y + ly)) * k),
                f2((x - lx) * k),
                f2((pageHeight - (y + ry)) * k),
                f2(x * k),
                f2((pageHeight - (y + ry)) * k),
                'c'
            ].join(' '));
            out([
                f2((x + lx) * k),
                f2((pageHeight - (y + ry)) * k),
                f2((x + rx) * k),
                f2((pageHeight - (y + ly)) * k),
                f2((x + rx) * k),
                f2((pageHeight - y) * k),
                'c',
                op
            ].join(' '));
            return this;
        };

        /**
        Adds an circle to PDF

        @param {Number} x Coordinate (in units declared at inception of PDF document) against left edge of the page
        @param {Number} y Coordinate (in units declared at inception of PDF document) against upper edge of the page
        @param {Number} r Radius (in units declared at inception of PDF document)
        @param {String} style (Defaults to active fill/stroke style) A string signalling if stroke, fill or both are to be applied.
        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name circle
         */
        API.circle = function (x, y, r, style) {
            return this.ellipse(x, y, r, r, style);
        };

        /**
        Adds a properties to the PDF document

        @param {Object} A property_name-to-property_value object structure.
        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name setProperties
         */
        API.setProperties = function (properties) {
            // copying only those properties we can render.
            var property;
            for (property in documentProperties) {
                if (documentProperties.hasOwnProperty(property) && properties[property]) {
                    documentProperties[property] = properties[property];
                }
            }
            return this;
        };

        /**
        Sets font size for upcoming text elements.

        @param {Number} size Font size in points.
        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name setFontSize
         */
        API.setFontSize = function (size) {
            activeFontSize = size;
            return this;
        };

        /**
        Sets text font face, variant for upcoming text elements.
        See output of pdfDataExport.getFontList() for possible font names, styles.

        @param {String} fontName Font name or family. Example: "times"
        @param {String} fontStyle Font style or variant. Example: "italic"
        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name setFont
         */
        API.setFont = function (fontName, fontStyle) {
            activeFontKey = getFont(fontName, fontStyle);
            // if font is not found, the above line blows up and we never go further
            return this;
        };

        /**
        Switches font style or variant for upcoming text elements,
        while keeping the font face or family same.
        See output of pdfDataExport.getFontList() for possible font names, styles.

        @param {String} style Font style or variant. Example: "italic"
        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name setFontStyle
         */
        API.setFontStyle = API.setFontType = function (style) {
            var undef;
            activeFontKey = getFont(undef, style);
            // if font is not found, the above line blows up and we never go further
            return this;
        };

        /**
        Returns an object - a tree of fontName to fontStyle relationships available to
        active PDF document.

        @public
        @function
        @returns {Object} Like {'times':['normal', 'italic', ... ], 'arial':['normal', 'bold', ... ], ... }
        @methodOf pdfDataExport#
        @name getFontList
        */
        API.getFontList = function () {
            // TODO: iterate over fonts array or return copy of fontmap instead in case more are ever added.
            var list = {},
                fontName,
                fontStyle,
                tmp;

            for (fontName in fontmap) {
                if (fontmap.hasOwnProperty(fontName)) {
                    list[fontName] = tmp = [];
                    for (fontStyle in fontmap[fontName]) {
                        if (fontmap[fontName].hasOwnProperty(fontStyle)) {
                            tmp.push(fontStyle);
                        }
                    }
                }
            }

            return list;
        };

        /**
        Sets line width for upcoming lines.

        @param {Number} width Line width (in units declared at inception of PDF document)
        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name setLineWidth
         */
        API.setLineWidth = function (width) {
            out((width * k).toFixed(2) + ' w');
            return this;
        };

        /**
        Sets the stroke color for upcoming elements.

        Depending on the number of arguments given, Gray, RGB, or CMYK
        color space is implied.

        When only ch1 is given, "Gray" color space is implied and it
        must be a value in the range from 0.00 (solid black) to to 1.00 (white)
        if values are communicated as String types, or in range from 0 (black)
        to 255 (white) if communicated as Number type.
        The RGB-like 0-255 range is provided for backward compatibility.

        When only ch1,ch2,ch3 are given, "RGB" color space is implied and each
        value must be in the range from 0.00 (minimum intensity) to to 1.00
        (max intensity) if values are communicated as String types, or
        from 0 (min intensity) to to 255 (max intensity) if values are communicated
        as Number types.
        The RGB-like 0-255 range is provided for backward compatibility.

        When ch1,ch2,ch3,ch4 are given, "CMYK" color space is implied and each
        value must be a in the range from 0.00 (0% concentration) to to
        1.00 (100% concentration)

        Because JavaScript treats fixed point numbers badly (rounds to
        floating point nearest to binary representation) it is highly advised to
        communicate the fractional numbers as String types, not JavaScript Number type.

        @param {Number|String} ch1 Color channel value
        @param {Number|String} ch2 Color channel value
        @param {Number|String} ch3 Color channel value
        @param {Number|String} ch4 Color channel value

        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name setDrawColor
         */
        API.setDrawColor = function (ch1, ch2, ch3, ch4) {
            var color;
            if (ch2 === undefined || (ch4 === undefined && ch1 === ch2 === ch3)) {
                // Gray color space.
                if (typeof ch1 === 'string') {
                    color = ch1 + ' G';
                } else {
                    color = f2(ch1 / 255) + ' G';
                }
            } else if (ch4 === undefined) {
                // RGB
                if (typeof ch1 === 'string') {
                    color = [ch1, ch2, ch3, 'RG'].join(' ');
                } else {
                    color = [f2(ch1 / 255), f2(ch2 / 255), f2(ch3 / 255), 'RG'].join(' ');
                }
            } else {
                // CMYK
                if (typeof ch1 === 'string') {
                    color = [ch1, ch2, ch3, ch4, 'K'].join(' ');
                } else {
                    color = [f2(ch1), f2(ch2), f2(ch3), f2(ch4), 'K'].join(' ');
                }
            }

            out(color);
            return this;
        };

        /**
        Sets the fill color for upcoming elements.

        Depending on the number of arguments given, Gray, RGB, or CMYK
        color space is implied.

        When only ch1 is given, "Gray" color space is implied and it
        must be a value in the range from 0.00 (solid black) to to 1.00 (white)
        if values are communicated as String types, or in range from 0 (black)
        to 255 (white) if communicated as Number type.
        The RGB-like 0-255 range is provided for backward compatibility.

        When only ch1,ch2,ch3 are given, "RGB" color space is implied and each
        value must be in the range from 0.00 (minimum intensity) to to 1.00
        (max intensity) if values are communicated as String types, or
        from 0 (min intensity) to to 255 (max intensity) if values are communicated
        as Number types.
        The RGB-like 0-255 range is provided for backward compatibility.

        When ch1,ch2,ch3,ch4 are given, "CMYK" color space is implied and each
        value must be a in the range from 0.00 (0% concentration) to to
        1.00 (100% concentration)

        Because JavaScript treats fixed point numbers badly (rounds to
        floating point nearest to binary representation) it is highly advised to
        communicate the fractional numbers as String types, not JavaScript Number type.

        @param {Number|String} ch1 Color channel value
        @param {Number|String} ch2 Color channel value
        @param {Number|String} ch3 Color channel value
        @param {Number|String} ch4 Color channel value

        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name setFillColor
         */
        API.setFillColor = function (ch1, ch2, ch3, ch4) {
            var color;

            if (ch2 === undefined || (ch4 === undefined && ch1 === ch2 === ch3)) {
                // Gray color space.
                if (typeof ch1 === 'string') {
                    color = ch1 + ' g';
                } else {
                    color = f2(ch1 / 255) + ' g';
                }
            } else if (ch4 === undefined) {
                // RGB
                if (typeof ch1 === 'string') {
                    color = [ch1, ch2, ch3, 'rg'].join(' ');
                } else {
                    color = [f2(ch1 / 255), f2(ch2 / 255), f2(ch3 / 255), 'rg'].join(' ');
                }
            } else {
                // CMYK
                if (typeof ch1 === 'string') {
                    color = [ch1, ch2, ch3, ch4, 'k'].join(' ');
                } else {
                    color = [f2(ch1), f2(ch2), f2(ch3), f2(ch4), 'k'].join(' ');
                }
            }

            out(color);
            return this;
        };

        /**
        Sets the text color for upcoming elements.
        If only one, first argument is given,
        treats the value as gray-scale color value.

        @param {Number} r Red channel color value in range 0-255
        @param {Number} g Green channel color value in range 0-255
        @param {Number} b Blue channel color value in range 0-255
        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name setTextColor
        */
        API.setTextColor = function (r, g, b) {
            if ((r === 0 && g === 0 && b === 0) || (typeof g === 'undefined')) {
                textColor = f3(r / 255) + ' g';
            } else {
                textColor = [f3(r / 255), f3(g / 255), f3(b / 255), 'rg'].join(' ');
            }
            return this;
        };

        /**
        Is an Object providing a mapping from human-readable to
        integer flag values designating the varieties of line cap
        and join styles.

        @returns {Object}
        @fieldOf pdfDataExport#
        @name CapJoinStyles
        */
        API.CapJoinStyles = {
            0: 0,
            'butt': 0,
            'but': 0,
            'bevel': 0,
            1: 1,
            'round': 1,
            'rounded': 1,
            'circle': 1,
            2: 2,
            'projecting': 2,
            'project': 2,
            'square': 2,
            'milter': 2
        };

        /**
        Sets the line cap styles
        See {pdfDataExport.CapJoinStyles} for variants

        @param {String|Number} style A string or number identifying the type of line cap
        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name setLineCap
        */
        API.setLineCap = function (style) {
            var id = this.CapJoinStyles[style];
            if (id === undefined) {
                throw new Error("Line cap style of '" + style + "' is not recognized. See or extend .CapJoinStyles property for valid styles");
            }
            lineCapID = id;
            out(id.toString(10) + ' J');

            return this;
        };

        /**
        Sets the line join styles
        See {pdfDataExport.CapJoinStyles} for variants

        @param {String|Number} style A string or number identifying the type of line join
        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name setLineJoin
        */
        API.setLineJoin = function (style) {
            var id = this.CapJoinStyles[style];
            if (id === undefined) {
                throw new Error("Line join style of '" + style + "' is not recognized. See or extend .CapJoinStyles property for valid styles");
            }
            lineJoinID = id;
            out(id.toString(10) + ' j');

            return this;
        };

        // Output is both an internal (for plugins) and external function
        API.output = output;

        /**
         * Saves as PDF document. An alias of pdfDataExport.output('save', 'filename.pdf')
         * @param  {String} filename The filename including extension.
         *
         * @function
         * @returns {pdfDataExport}
         * @methodOf pdfDataExport#
         * @name save
         */
        API.save = function (filename) {
            API.output('save', filename);
        };

        // applying plugins (more methods) ON TOP of built-in API.
        // this is intentional as we allow plugins to override
        // built-ins
        for (plugin in pdfDataExport.API) {
            if (pdfDataExport.API.hasOwnProperty(plugin)) {
                if (plugin === 'events' && pdfDataExport.API.events.length) {
                    (function (events, newEvents) {

                        // pdfDataExport.API.events is a JS Array of Arrays
                        // where each Array is a pair of event name, handler
                        // Events were added by plugins to the pdfDataExport instantiator.
                        // These are always added to the new instance and some ran
                        // during instantiation.

                        var eventname, handler_and_args, i;

                        for (i = newEvents.length - 1; i !== -1; i--) {
                            // subscribe takes 3 args: 'topic', function, runonce_flag
                            // if undefined, runonce is false.
                            // users can attach callback directly,
                            // or they can attach an array with [callback, runonce_flag]
                            // that's what the "apply" magic is for below.
                            eventname = newEvents[i][0];
                            handler_and_args = newEvents[i][1];
                            events.subscribe.apply(
                                events,
                                [eventname].concat(
                                    typeof handler_and_args === 'function' ?
                                            [handler_and_args] :
                                            handler_and_args
                                )
                            );
                        }
                    }(events, pdfDataExport.API.events));
                } else {
                    API[plugin] = pdfDataExport.API[plugin];
                }
            }
        }

        /////////////////////////////////////////
        // continuing initilisation of pdfDataExport Document object
        /////////////////////////////////////////


        // Add the first page automatically
        addFonts();
        activeFontKey = 'F1';
        _addPage();

        events.publish('initialized');

        return API;
    }

    /**
    pdfDataExport.API is a STATIC property of pdfDataExport class.
    pdfDataExport.API is an object you can add methods and properties to.
    The methods / properties you add will show up in new pdfDataExport objects.
    
    One property is prepopulated. It is the 'events' Object. Plugin authors can add topics, callbacks to this object. These will be reassigned to all new instances of pdfDataExport.
    Examples:
        pdfDataExport.API.events['initialized'] = function(){ 'this' is API object }
        pdfDataExport.API.events['addFont'] = function(added_font_object){ 'this' is API object }
    
    @static
    @public
    @memberOf pdfDataExport
    @name API
    
    @example
        pdfDataExport.API.mymethod = function(){
            // 'this' will be ref to internal API object. see pdfDataExport source
            // , so you can refer to built-in methods like so:
            //     this.line(....)
            //     this.text(....)
        }
        var pdfdoc = new pdfDataExport()
        pdfdoc.mymethod() // <- !!!!!!
    */
    pdfDataExport.API = { 'events': [] };

    return pdfDataExport;
}());

(function (pdfDataExportAPI) {
    'use strict';
    /*jslint browser:true */
    /*global document: false, pdfDataExport */

    var maxLn = 0,
        lnP = 0,
        fontName,
        fontSize,
        fontStyle,
        lastCellPos = { x: undefined, y: undefined, w: undefined, h: undefined, ln: undefined },
        pages = 1,
        newPage = false,
        setLastCellPosition = function (x, y, w, h, ln) {
            lastCellPos = { x: x, y: y, w: w, h: h, ln: ln };
        },
        getLastCellPosition = function () {
            return lastCellPos;
        },
        setMaxLn = function (x) {
            maxLn = x;
        },
        getMaxLn = function () {
            return maxLn;
        },
        setLnP = function (x) {
            lnP = x;
        },
        getLnP = function (x) {
            return lnP;
        };

    pdfDataExportAPI.getTextDimensions = function (txt) {
        fontName = this.internal.getFont().fontName;
        fontSize = this.internal.getFontSize();
        fontStyle = this.internal.getFont().fontStyle;

        // 1 pixel = 0.264583 mm and 1 mm = 72/25.4 point
        var px2pt = 0.264583 * 72 / 25.4,
            dimensions,
            text;

        text = document.createElement('font');
        text.id = "pdfDataExportCell";
        text.style.fontStyle = fontStyle;
        text.style.fontName = fontName;
        text.style.fontSize = fontSize + 'pt';
        text.innerHTML = txt;

        document.body.appendChild(text);

        dimensions = { w: (text.offsetWidth + 1) * px2pt, h: (text.offsetHeight + 1) * px2pt };

        document.body.removeChild(text);

        return dimensions;
    };

    pdfDataExportAPI.cellAddPage = function () {
        this.addPage();
        setLastCellPosition(undefined, undefined, undefined, undefined, undefined);
        newPage = true;
        pages += 1;
        setLnP(1);
    };

    pdfDataExportAPI.cellInitialize = function () {
        maxLn = 0;
        lastCellPos = { x: undefined, y: undefined, w: undefined, h: undefined, ln: undefined };
        pages = 1;
        newPage = false;
        setLnP(0);
    };

    pdfDataExportAPI.cell = function (x, y, w, h, txt, ln) {
        this.lnMod = this.lnMod === undefined ? 0 : this.lnMod;
        if (this.printingHeaderRow !== true && this.lnMod !== 0) {
            ln = ln + this.lnMod;
        }

        if ((((ln * h) + y + (h * 2)) / pages) >= this.internal.pageSize.height && pages === 1 && !newPage) {
            this.cellAddPage();

            if (this.printHeaders && this.tableHeaderRow) {
                this.printHeaderRow(ln);
                this.lnMod += 1;
                ln += 1;
            }
            if (getMaxLn() === 0) {
                setMaxLn(Math.round((this.internal.pageSize.height - (h * 2)) / h));
            }
        } else if (newPage && getLastCellPosition().ln !== ln && getLnP() === getMaxLn()) {
            this.cellAddPage();

            if (this.printHeaders && this.tableHeaderRow) {
                this.printHeaderRow(ln);
                this.lnMod += 1;
                ln += 1;
            }
        }

        var curCell = getLastCellPosition(),
            dim = this.getTextDimensions(txt),
            isNewLn = 1;
        if (curCell.x !== undefined && curCell.ln === ln) {
            x = curCell.x + curCell.w;
        }
        if (curCell.y !== undefined && curCell.y === y) {
            y = curCell.y;
        }
        if (curCell.h !== undefined && curCell.h === h) {
            h = curCell.h;
        }
        if (curCell.ln !== undefined && curCell.ln === ln) {
            ln = curCell.ln;
            isNewLn = 0;
        }
        if (newPage) {
            y = h * (getLnP() + isNewLn);
        } else {
            y = (y + (h * Math.abs(getMaxLn() * pages - ln - getMaxLn())));
        }
        this.rect(x, y, w, h);
        var match = /[а-яА-ЯЁё]/.test(txt);
        if (match) {
            this.text16(txt, x + 3, y + h - 3);
        }
        else {
            this.text(txt, x + 3, y + h - 3);
        }
        setLnP(getLnP() + isNewLn);
        setLastCellPosition(x, y, w, h, ln);
        return this;
    };

    /**
     * Return an array containing all of the owned keys of an Object
     * @type {Function}
     * @return {String[]} of Object keys
     */
    pdfDataExportAPI.getKeys = (typeof Object.keys === 'function')
        ? function (object) {
            if (!object) {
                return [];
            }
            return Object.keys(object);
        }
            : function (object) {
                var keys = [],
                    property;

                for (property in object) {
                    if (object.hasOwnProperty(property)) {
                        keys.push(property);
                    }
                }

                return keys;
            };

    /**
     * Return the maximum value from an array
     * @param array
     * @param comparisonFn
     * @returns {*}
     */
    pdfDataExportAPI.arrayMax = function (array, comparisonFn) {
        var max = array[0],
            i,
            ln,
            item;

        for (i = 0, ln = array.length; i < ln; i += 1) {
            item = array[i];

            if (comparisonFn) {
                if (comparisonFn(max, item) === -1) {
                    max = item;
                }
            } else {
                if (item > max) {
                    max = item;
                }
            }
        }

        return max;
    };

    /**
     * Create a table from a set of data.
     * @param {Object[]} data As array of objects containing key-value pairs
     * @param {String[]} [headers] Omit or null to auto-generate headers at a performance cost
     * @param {Object} [config.printHeaders] True to print column headers at the top of every page
     * @param {Object} [config.autoSize] True to dynamically set the column widths to match the widest cell value
     * @param {Object} [config.autoStretch] True to force the table to fit the width of the page
     */
    pdfDataExportAPI.table = function (data, headers, config) {

        var headerNames = [],
            headerPrompts = [],
            header,
            autoSize,
            printHeaders,
            autoStretch,
            i,
            ln,
            columnMatrix = {},
            columnWidths = {},
            columnData,
            column,
            columnMinWidths = [],
            j,
            tableHeaderConfigs = [],
            model,
            jln,
            func;

        /**
         * @property {Number} lnMod
         * Keep track of the current line number modifier used when creating cells
         */
        this.lnMod = 0;

        if (config) {
            autoSize = config.autoSize || false;
            printHeaders = this.printHeaders = config.printHeaders || true;
            autoStretch = config.autoStretch || true;
        }

        if (!data) {
            throw 'No data for PDF table';
        }

        // Set headers
        if (headers === undefined || (headers === null)) {

            // No headers defined so we derive from data
            headerNames = this.getKeys(data[0]);

        } else if (headers[0] && (typeof headers[0] !== 'string')) {

            // Split header configs into names and prompts
            for (i = 0, ln = headers.length; i < ln; i += 1) {
                header = headers[i];
                headerNames.push(header.name);
                headerPrompts.push(header.prompt);
            }

        } else {
            headerNames = headers;
        }

        if (config.autoSize) {

            // Create Columns Matrix

            func = function (rec) {
                return rec[header];
            };

            for (i = 0, ln = headerNames.length; i < ln; i += 1) {
                header = headerNames[i];

                columnMatrix[header] = data.map(
                    func
                );

                // get header width
                columnMinWidths.push(this.getTextDimensions(headerPrompts[i] || header).w);

                column = columnMatrix[header];

                // get cell widths
                for (j = 0, ln = column.length; j < ln; j += 1) {
                    columnData = column[j];

                    columnMinWidths.push(this.getTextDimensions(columnData).w);
                }

                // get final column width
                columnWidths[header] = pdfDataExportAPI.arrayMax(columnMinWidths);
            }
        }

        // -- Construct the table

        if (config.printHeaders) {

            // Construct the header row
            for (i = 0, ln = headerNames.length; i < ln; i += 1) {
                header = headerNames[i];
                tableHeaderConfigs.push([10, 10, columnWidths[header], 25, String(headerPrompts.length ? headerPrompts[i] : header)]);
            }

            // Store the table header config
            this.setTableHeaderRow(tableHeaderConfigs);

            // Print the header for the start of the table
            this.printHeaderRow(1);
        }

        // Construct the data rows
        for (i = 0, ln = data.length; i < ln; i += 1) {
            model = data[i];

            for (j = 0, jln = headerNames.length; j < jln; j += 1) {
                header = headerNames[j];
                this.cell(10, 10, columnWidths[header], 25, String(model[header]), i + 2);
            }
        }

        return this;
    };

    /**
     * Store the config for outputting a table header
     * @param {Object[]} config
     * An array of cell configs that would define a header row: Each config matches the config used by pdfDataExportAPI.cell
     * except the ln parameter is excluded
     */
    pdfDataExportAPI.setTableHeaderRow = function (config) {
        this.tableHeaderRow = config;
    };

    /**
     * Output the store header row
     * @param lineNumber The line number to output the header at
     */
    pdfDataExportAPI.printHeaderRow = function (lineNumber) {
        if (!this.tableHeaderRow) {
            throw 'Property tableHeaderRow does not exist.';
        }

        var tableHeaderCell,
            tmpArray,
            i,
            ln;

        this.printingHeaderRow = true;

        for (i = 0, ln = this.tableHeaderRow.length; i < ln; i += 1) {

            tableHeaderCell = this.tableHeaderRow[i];
            tmpArray = [].concat(tableHeaderCell);

            this.cell.apply(this, tmpArray.concat(lineNumber));
        }

        this.printingHeaderRow = false;
    };

}(pdfDataExport.API));


; (function (API) {
    'use strict'

    /**
    Returns an array of length matching length of the 'word' string, with each
    cell ocupied by the width of the char in that position.
    
    @function
    @param word {String}
    @param widths {Object}
    @param kerning {Object}
    @returns {Array}
    */
    var getCharWidthsArray = API.getCharWidthsArray = function (text, options) {

        if (!options) {
            options = {}
        }

        var widths = options.widths ? options.widths : this.internal.getFont().metadata.Unicode.widths
        , widthsFractionOf = widths.fof ? widths.fof : 1
        , kerning = options.kerning ? options.kerning : this.internal.getFont().metadata.Unicode.kerning
        , kerningFractionOf = kerning.fof ? kerning.fof : 1

        // console.log("widths, kergnings", widths, kerning)

        var i, l
        , char_code
        , char_width
        , prior_char_code = 0 // for kerning
        , default_char_width = widths[0] || widthsFractionOf
        , output = []

        for (i = 0, l = text.length; i < l; i++) {
            char_code = text.charCodeAt(i)
            output.push(
                (widths[char_code] || default_char_width) / widthsFractionOf +
                (kerning[char_code] && kerning[char_code][prior_char_code] || 0) / kerningFractionOf
            )
            prior_char_code = char_code
        }

        return output
    }
    var getArraySum = function (array) {
        var i = array.length
        , output = 0
        while (i) {
            ; i--;
            output += array[i]
        }
        return output
    }
    /**
    Returns a widths of string in a given font, if the font size is set as 1 point.
    
    In other words, this is "proportional" value. For 1 unit of font size, the length
    of the string will be that much.
    
    Multiply by font size to get actual width in *points*
    Then divide by 72 to get inches or divide by (72/25.6) to get 'mm' etc.
    
    @public
    @function
    @param
    @returns {Type}
    */
    var getStringUnitWidth = API.getStringUnitWidth = function (text, options) {
        return getArraySum(getCharWidthsArray.call(this, text, options))
    }

    /** 
    returns array of lines
    */
    var splitLongWord = function (word, widths_array, firstLineMaxLen, maxLen) {
        var answer = []

        // 1st, chop off the piece that can fit on the hanging line.
        var i = 0
        , l = word.length
        , workingLen = 0
        while (i !== l && workingLen + widths_array[i] < firstLineMaxLen) {
            workingLen += widths_array[i]
            ; i++;
        }
        // this is first line.
        answer.push(word.slice(0, i))

        // 2nd. Split the rest into maxLen pieces.
        var startOfLine = i
        workingLen = 0
        while (i !== l) {
            if (workingLen + widths_array[i] > maxLen) {
                answer.push(word.slice(startOfLine, i))
                workingLen = 0
                startOfLine = i
            }
            workingLen += widths_array[i]
            ; i++;
        }
        if (startOfLine !== i) {
            answer.push(word.slice(startOfLine, i))
        }

        return answer
    }

    // Note, all sizing inputs for this function must be in "font measurement units"
    // By default, for PDF, it's "point".
    var splitParagraphIntoLines = function (text, maxlen, options) {
        // at this time works only on Western scripts, ones with space char
        // separating the words. Feel free to expand.

        if (!options) {
            options = {}
        }

        var spaceCharWidth = getCharWidthsArray(' ', options)[0]

        var words = text.split(' ')

        var line = []
        , lines = [line]
        , line_length = options.textIndent || 0
        , separator_length = 0
        , current_word_length = 0
        , word
        , widths_array

        var i, l, tmp
        for (i = 0, l = words.length; i < l; i++) {
            word = words[i]
            widths_array = getCharWidthsArray(word, options)
            current_word_length = getArraySum(widths_array)

            if (line_length + separator_length + current_word_length > maxlen) {
                if (current_word_length > maxlen) {
                    // this happens when you have space-less long URLs for example.
                    // we just chop these to size. We do NOT insert hiphens
                    tmp = splitLongWord(word, widths_array, maxlen - (line_length + separator_length), maxlen)
                    // first line we add to existing line object
                    line.push(tmp.shift()) // it's ok to have extra space indicator there
                    // last line we make into new line object
                    line = [tmp.pop()]
                    // lines in the middle we apped to lines object as whole lines
                    while (tmp.length) {
                        lines.push([tmp.shift()]) // single fragment occupies whole line
                    }
                    current_word_length = getArraySum(widths_array.slice(word.length - line[0].length))
                } else {
                    // just put it on a new line
                    line = [word]
                }

                // now we attach new line to lines
                lines.push(line)

                line_length = current_word_length
                separator_length = spaceCharWidth

            } else {
                line.push(word)

                line_length += separator_length + current_word_length
                separator_length = spaceCharWidth
            }
        }

        var output = []
        for (i = 0, l = lines.length; i < l; i++) {
            output.push(lines[i].join(' '))
        }
        return output

    }

    /**
    Splits a given string into an array of strings. Uses 'size' value
    (in measurement units declared as default for the pdfDataExport instance)
    and the font's "widths" and "Kerning" tables, where availabe, to
    determine display length of a given string for a given font.
    
    We use character's 100% of unit size (height) as width when Width
    table or other default width is not available.
    
    @public
    @function
    @param text {String} Unencoded, regular JavaScript (Unicode, UTF-16 / UCS-2) string.
    @param size {Number} Nominal number, measured in units default to this instance of pdfDataExport.
    @param options {Object} Optional flags needed for chopper to do the right thing.
    @returns {Array} with strings chopped to size.
    */
    API.splitTextToSize = function (text, maxlen, options) {
        'use strict'

        if (!options) {
            options = {}
        }

        var fsize = options.fontSize || this.internal.getFontSize()
        , newOptions = (function (options) {
            var widths = { 0: 1 }
            , kerning = {}

            if (!options.widths || !options.kerning) {
                var f = this.internal.getFont(options.fontName, options.fontStyle)
                , encoding = 'Unicode'
                // NOT UTF8, NOT UTF16BE/LE, NOT UCS2BE/LE
                // Actual JavaScript-native String's 16bit char codes used.
                // no multi-byte logic here

                if (f.metadata[encoding]) {
                    return {
                        widths: f.metadata[encoding].widths || widths
                        , kerning: f.metadata[encoding].kerning || kerning
                    }
                }
            } else {
                return {
                    widths: options.widths
                    , kerning: options.kerning
                }
            }

            // then use default values
            return {
                widths: widths
                , kerning: kerning
            }
        }).call(this, options)

        // first we split on end-of-line chars
        var paragraphs
        if (text.match(/[\n\r]/)) {
            paragraphs = text.split(/\r\n|\r|\n/g)
        } else {
            paragraphs = [text]
        }

        // now we convert size (max length of line) into "font size units"
        // at present time, the "font size unit" is always 'point'
        // 'proportional' means, "in proportion to font size"
        var fontUnit_maxLen = 1.0 * this.internal.scaleFactor * maxlen / fsize
        // at this time, fsize is always in "points" regardless of the default measurement unit of the doc.
        // this may change in the future?
        // until then, proportional_maxlen is likely to be in 'points'

        // If first line is to be indented (shorter or longer) than maxLen 
        // we indicate that by using CSS-style "text-indent" option.
        // here it's in font units too (which is likely 'points')
        // it can be negative (which makes the first line longer than maxLen)
        newOptions.textIndent = options.textIndent ?
            options.textIndent * 1.0 * this.internal.scaleFactor / fsize :
            0

        var i, l
        , output = []
        for (i = 0, l = paragraphs.length; i < l; i++) {
            output = output.concat(
                splitParagraphIntoLines(
                    paragraphs[i]
                    , fontUnit_maxLen
                    , newOptions
                )
            )
        }

        return output
    }

})(pdfDataExport.API);


; (function (pdfDataExportAPI) {
    'use strict'

    var namespace = 'addImage_'

    var getJpegSize = function (imgData) {
        'use strict'
        var width, height;
        // Verify we have a valid jpeg header 0xff,0xd8,0xff,0xe0,?,?,'J','F','I','F',0x00
        if (!imgData.charCodeAt(0) === 0xff ||
            !imgData.charCodeAt(1) === 0xd8 ||
            !imgData.charCodeAt(2) === 0xff ||
            !imgData.charCodeAt(3) === 0xe0 ||
            !imgData.charCodeAt(6) === 'J'.charCodeAt(0) ||
            !imgData.charCodeAt(7) === 'F'.charCodeAt(0) ||
            !imgData.charCodeAt(8) === 'I'.charCodeAt(0) ||
            !imgData.charCodeAt(9) === 'F'.charCodeAt(0) ||
            !imgData.charCodeAt(10) === 0x00) {
            throw new Error('getJpegSize requires a binary jpeg file')
        }
        var blockLength = imgData.charCodeAt(4) * 256 + imgData.charCodeAt(5);
        var i = 4, len = imgData.length;
        while (i < len) {
            i += blockLength;
            if (imgData.charCodeAt(i) !== 0xff) {
                throw new Error('getJpegSize could not find the size of the image');
            }
            if (imgData.charCodeAt(i + 1) === 0xc0) {
                height = imgData.charCodeAt(i + 5) * 256 + imgData.charCodeAt(i + 6);
                width = imgData.charCodeAt(i + 7) * 256 + imgData.charCodeAt(i + 8);
                return [width, height];
            } else {
                i += 2;
                blockLength = imgData.charCodeAt(i) * 256 + imgData.charCodeAt(i + 1)
            }
        }
    }
    // Image functionality ported from pdf.js
    , putImage = function (img) {
        var objectNumber = this.internal.newObject()
        , out = this.internal.write
        , putStream = this.internal.putStream

        img['n'] = objectNumber

        out('<</Type /XObject')
        out('/Subtype /Image')
        out('/Width ' + img['w'])
        out('/Height ' + img['h'])
        if (img['cs'] === 'Indexed') {
            out('/ColorSpace [/Indexed /DeviceRGB '
                    + (img['pal'].length / 3 - 1) + ' ' + (objectNumber + 1)
                    + ' 0 R]');
        } else {
            out('/ColorSpace /' + img['cs']);
            if (img['cs'] === 'DeviceCMYK') {
                out('/Decode [1 0 1 0 1 0 1 0]');
            }
        }
        out('/BitsPerComponent ' + img['bpc']);
        if ('f' in img) {
            out('/Filter /' + img['f']);
        }
        if ('dp' in img) {
            out('/DecodeParms <<' + img['dp'] + '>>');
        }
        if ('trns' in img && img['trns'].constructor == Array) {
            var trns = '';
            for (var i = 0; i < img['trns'].length; i++) {
                trns += (img[trns][i] + ' ' + img['trns'][i] + ' ');
                out('/Mask [' + trns + ']');
            }
        }
        if ('smask' in img) {
            out('/SMask ' + (objectNumber + 1) + ' 0 R');
        }
        out('/Length ' + img['data'].length + '>>');

        putStream(img['data']);

        out('endobj');
    }
    , putResourcesCallback = function () {
        var images = this.internal.collections[namespace + 'images']
        for (var i in images) {
            putImage.call(this, images[i])
        }
    }
    , putXObjectsDictCallback = function () {
        var images = this.internal.collections[namespace + 'images']
        , out = this.internal.write
        , image
        for (var i in images) {
            image = images[i]
            out(
                '/I' + image['i']
                , image['n']
                , '0'
                , 'R'
            )
        }
    }

    pdfDataExportAPI.addImage = function (imageData, format, x, y, w, h) {
        'use strict'
        if (typeof imageData === 'object' && imageData.nodeType === 1) {
            var canvas = document.createElement('canvas');
            canvas.width = imageData.clientWidth;
            canvas.height = imageData.clientHeight;

            var ctx = canvas.getContext('2d');
            if (!ctx) {
                throw ('addImage requires canvas to be supported by browser.');
            }
            ctx.drawImage(imageData, 0, 0, canvas.width, canvas.height);
            imageData = canvas.toDataURL('image/jpeg');
            format = "JPEG";
        }
        if (format.toUpperCase() !== 'JPEG') {
            throw new Error('addImage currently only supports format \'JPEG\', not \'' + format + '\'');
        }

        var imageIndex
        , images = this.internal.collections[namespace + 'images']
        , coord = this.internal.getCoordinateString
        , vcoord = this.internal.getVerticalCoordinateString;

        // Detect if the imageData is raw binary or Data URL
        if (imageData.substring(0, 23) === 'data:image/jpeg;base64,') {
            imageData = atob(imageData.replace('data:image/jpeg;base64,', ''));
        }

        if (images) {
            // this is NOT the first time this method is ran on this instance of pdfDataExport object.
            imageIndex = Object.keys ?
            Object.keys(images).length :
            (function (o) {
                var i = 0
                for (var e in o) { if (o.hasOwnProperty(e)) { i++ } }
                return i
            })(images)
        } else {
            // this is the first time this method is ran on this instance of pdfDataExport object.
            imageIndex = 0
            this.internal.collections[namespace + 'images'] = images = {}
            this.internal.events.subscribe('putResources', putResourcesCallback)
            this.internal.events.subscribe('putXobjectDict', putXObjectsDictCallback)
        }

        var dims = getJpegSize(imageData);
        var info = {
            w: dims[0],
            h: dims[1],
            cs: 'DeviceRGB',
            bpc: 8,
            f: 'DCTDecode',
            i: imageIndex,
            data: imageData
            // n: objectNumber will be added by putImage code

        };
        images[imageIndex] = info
        if (!w && !h) {
            w = -96;
            h = -96;
        }
        if (w < 0) {
            w = (-1) * info['w'] * 72 / w / this.internal.scaleFactor;
        }
        if (h < 0) {
            h = (-1) * info['h'] * 72 / h / this.internal.scaleFactor;
        }
        if (w === 0) {
            w = h * info['w'] / info['h'];
        }
        if (h === 0) {
            h = w * info['h'] / info['w'];
        }

        this.internal.write(
            'q'
            , coord(w)
            , '0 0'
            , coord(h) // TODO: check if this should be shifted by vcoord
            , coord(x)
            , vcoord(y + h)
            , 'cm /I' + info['i']
            , 'Do Q'
        )

        return this
    }
})(pdfDataExport.API)

; (function (API) {
    'use strict'

    /**
    Uncompresses data compressed into custom, base16-like format. 
    @public
    @function
    @param
    @returns {Type}
    */
    var uncompress = function (data) {

        var decoded = '0123456789abcdef'
        , encoded = 'klmnopqrstuvwxyz'
        , mapping = {}

        for (var i = 0; i < encoded.length; i++) {
            mapping[encoded[i]] = decoded[i]
        }

        var undef
        , output = {}
        , sign = 1
        , stringparts // undef. will be [] in string mode

        , activeobject = output
        , parentchain = []
        , parent_key_pair
        , keyparts = ''
        , valueparts = ''
        , key // undef. will be Truthy when Key is resolved.
        , datalen = data.length - 1 // stripping ending }
        , ch

        i = 1 // stripping starting {

        while (i != datalen) {
            // - { } ' are special.

            ch = data[i]
            i += 1

            if (ch == "'") {
                if (stringparts) {
                    // end of string mode
                    key = stringparts.join('')
                    stringparts = undef
                } else {
                    // start of string mode
                    stringparts = []
                }
            } else if (stringparts) {
                stringparts.push(ch)
            } else if (ch == '{') {
                // start of object
                parentchain.push([activeobject, key])
                activeobject = {}
                key = undef
            } else if (ch == '}') {
                // end of object
                parent_key_pair = parentchain.pop()
                parent_key_pair[0][parent_key_pair[1]] = activeobject
                key = undef
                activeobject = parent_key_pair[0]
            } else if (ch == '-') {
                sign = -1
            } else {
                // must be number
                if (key === undef) {
                    if (mapping.hasOwnProperty(ch)) {
                        keyparts += mapping[ch]
                        key = parseInt(keyparts, 16) * sign
                        sign = +1
                        keyparts = ''
                    } else {
                        keyparts += ch
                    }
                } else {
                    if (mapping.hasOwnProperty(ch)) {
                        valueparts += mapping[ch]
                        activeobject[key] = parseInt(valueparts, 16) * sign
                        sign = +1
                        key = undef
                        valueparts = ''
                    } else {
                        valueparts += ch
                    }
                }
            }
        } // end while

        return output
    }

    // encoding = 'Unicode' 
    // NOT UTF8, NOT UTF16BE/LE, NOT UCS2BE/LE. NO clever BOM behavior
    // Actual 16bit char codes used.
    // no multi-byte logic here

    // Unicode characters to WinAnsiEncoding:
    // {402: 131, 8211: 150, 8212: 151, 8216: 145, 8217: 146, 8218: 130, 8220: 147, 8221: 148, 8222: 132, 8224: 134, 8225: 135, 8226: 149, 8230: 133, 8364: 128, 8240:137, 8249: 139, 8250: 155, 710: 136, 8482: 153, 338: 140, 339: 156, 732: 152, 352: 138, 353: 154, 376: 159, 381: 142, 382: 158}
    // as you can see, all Unicode chars are outside of 0-255 range. No char code conflicts.
    // this means that you can give Win cp1252 encoded strings to pdfDataExport for rendering directly
    // as well as give strings with some (supported by these fonts) Unicode characters and 
    // these will be mapped to win cp1252 
    // for example, you can send char code (cp1252) 0x80 or (unicode) 0x20AC, getting "Euro" glyph displayed in both cases.

    var encodingBlock = {
        'codePages': ['WinAnsiEncoding']
        , 'WinAnsiEncoding': uncompress("{19m8n201n9q201o9r201s9l201t9m201u8m201w9n201x9o201y8o202k8q202l8r202m9p202q8p20aw8k203k8t203t8v203u9v2cq8s212m9t15m8w15n9w2dw9s16k8u16l9u17s9z17x8y17y9y}")
    }
    , encodings = {
        'Unicode': {
            'Courier': encodingBlock
            , 'Courier-Bold': encodingBlock
            , 'Courier-BoldOblique': encodingBlock
            , 'Courier-Oblique': encodingBlock
            , 'Helvetica': encodingBlock
            , 'Helvetica-Bold': encodingBlock
            , 'Helvetica-BoldOblique': encodingBlock
            , 'Helvetica-Oblique': encodingBlock
            , 'Times-Roman': encodingBlock
            , 'Times-Bold': encodingBlock
            , 'Times-BoldItalic': encodingBlock
            , 'Times-Italic': encodingBlock
            //	, 'Symbol'
            //	, 'ZapfDingbats'
        }
    }

    , fontMetrics = {
        'Unicode': {
            // all sizing numbers are n/fontMetricsFractionOf = one font size unit
            // this means that if fontMetricsFractionOf = 1000, and letter A's width is 476, it's
            // width is 476/1000 or 47.6% of its height (regardless of font size)
            // At this time this value applies to "widths" and "kerning" numbers.

            // char code 0 represents "default" (average) width - use it for chars missing in this table.
            // key 'fof' represents the "fontMetricsFractionOf" value

            'Courier-Oblique': uncompress("{'widths'{k3w'fof'6o}'kerning'{'fof'-6o}}")
            , 'Times-BoldItalic': uncompress("{'widths'{k3o2q4ycx2r201n3m201o6o201s2l201t2l201u2l201w3m201x3m201y3m2k1t2l2r202m2n2n3m2o3m2p5n202q6o2r1w2s2l2t2l2u3m2v3t2w1t2x2l2y1t2z1w3k3m3l3m3m3m3n3m3o3m3p3m3q3m3r3m3s3m203t2l203u2l3v2l3w3t3x3t3y3t3z3m4k5n4l4m4m4m4n4m4o4s4p4m4q4m4r4s4s4y4t2r4u3m4v4m4w3x4x5t4y4s4z4s5k3x5l4s5m4m5n3r5o3x5p4s5q4m5r5t5s4m5t3x5u3x5v2l5w1w5x2l5y3t5z3m6k2l6l3m6m3m6n2w6o3m6p2w6q2l6r3m6s3r6t1w6u1w6v3m6w1w6x4y6y3r6z3m7k3m7l3m7m2r7n2r7o1w7p3r7q2w7r4m7s3m7t2w7u2r7v2n7w1q7x2n7y3t202l3mcl4mal2ram3man3mao3map3mar3mas2lat4uau1uav3maw3way4uaz2lbk2sbl3t'fof'6obo2lbp3tbq3mbr1tbs2lbu1ybv3mbz3mck4m202k3mcm4mcn4mco4mcp4mcq5ycr4mcs4mct4mcu4mcv4mcw2r2m3rcy2rcz2rdl4sdm4sdn4sdo4sdp4sdq4sds4sdt4sdu4sdv4sdw4sdz3mek3mel3mem3men3meo3mep3meq4ser2wes2wet2weu2wev2wew1wex1wey1wez1wfl3rfm3mfn3mfo3mfp3mfq3mfr3tfs3mft3rfu3rfv3rfw3rfz2w203k6o212m6o2dw2l2cq2l3t3m3u2l17s3x19m3m}'kerning'{cl{4qu5kt5qt5rs17ss5ts}201s{201ss}201t{cks4lscmscnscoscpscls2wu2yu201ts}201x{2wu2yu}2k{201ts}2w{4qx5kx5ou5qx5rs17su5tu}2x{17su5tu5ou}2y{4qx5kx5ou5qx5rs17ss5ts}'fof'-6ofn{17sw5tw5ou5qw5rs}7t{cksclscmscnscoscps4ls}3u{17su5tu5os5qs}3v{17su5tu5os5qs}7p{17su5tu}ck{4qu5kt5qt5rs17ss5ts}4l{4qu5kt5qt5rs17ss5ts}cm{4qu5kt5qt5rs17ss5ts}cn{4qu5kt5qt5rs17ss5ts}co{4qu5kt5qt5rs17ss5ts}cp{4qu5kt5qt5rs17ss5ts}6l{4qu5ou5qw5rt17su5tu}5q{ckuclucmucnucoucpu4lu}5r{ckuclucmucnucoucpu4lu}7q{cksclscmscnscoscps4ls}6p{4qu5ou5qw5rt17sw5tw}ek{4qu5ou5qw5rt17su5tu}el{4qu5ou5qw5rt17su5tu}em{4qu5ou5qw5rt17su5tu}en{4qu5ou5qw5rt17su5tu}eo{4qu5ou5qw5rt17su5tu}ep{4qu5ou5qw5rt17su5tu}es{17ss5ts5qs4qu}et{4qu5ou5qw5rt17sw5tw}eu{4qu5ou5qw5rt17ss5ts}ev{17ss5ts5qs4qu}6z{17sw5tw5ou5qw5rs}fm{17sw5tw5ou5qw5rs}7n{201ts}fo{17sw5tw5ou5qw5rs}fp{17sw5tw5ou5qw5rs}fq{17sw5tw5ou5qw5rs}7r{cksclscmscnscoscps4ls}fs{17sw5tw5ou5qw5rs}ft{17su5tu}fu{17su5tu}fv{17su5tu}fw{17su5tu}fz{cksclscmscnscoscps4ls}}}")
            , 'Helvetica-Bold': uncompress("{'widths'{k3s2q4scx1w201n3r201o6o201s1w201t1w201u1w201w3m201x3m201y3m2k1w2l2l202m2n2n3r2o3r2p5t202q6o2r1s2s2l2t2l2u2r2v3u2w1w2x2l2y1w2z1w3k3r3l3r3m3r3n3r3o3r3p3r3q3r3r3r3s3r203t2l203u2l3v2l3w3u3x3u3y3u3z3x4k6l4l4s4m4s4n4s4o4s4p4m4q3x4r4y4s4s4t1w4u3r4v4s4w3x4x5n4y4s4z4y5k4m5l4y5m4s5n4m5o3x5p4s5q4m5r5y5s4m5t4m5u3x5v2l5w1w5x2l5y3u5z3r6k2l6l3r6m3x6n3r6o3x6p3r6q2l6r3x6s3x6t1w6u1w6v3r6w1w6x5t6y3x6z3x7k3x7l3x7m2r7n3r7o2l7p3x7q3r7r4y7s3r7t3r7u3m7v2r7w1w7x2r7y3u202l3rcl4sal2lam3ran3rao3rap3rar3ras2lat4tau2pav3raw3uay4taz2lbk2sbl3u'fof'6obo2lbp3xbq3rbr1wbs2lbu2obv3rbz3xck4s202k3rcm4scn4sco4scp4scq6ocr4scs4mct4mcu4mcv4mcw1w2m2zcy1wcz1wdl4sdm4ydn4ydo4ydp4ydq4yds4ydt4sdu4sdv4sdw4sdz3xek3rel3rem3ren3reo3rep3req5ter3res3ret3reu3rev3rew1wex1wey1wez1wfl3xfm3xfn3xfo3xfp3xfq3xfr3ufs3xft3xfu3xfv3xfw3xfz3r203k6o212m6o2dw2l2cq2l3t3r3u2l17s4m19m3r}'kerning'{cl{4qs5ku5ot5qs17sv5tv}201t{2ww4wy2yw}201w{2ks}201x{2ww4wy2yw}2k{201ts201xs}2w{7qs4qu5kw5os5qw5rs17su5tu7tsfzs}2x{5ow5qs}2y{7qs4qu5kw5os5qw5rs17su5tu7tsfzs}'fof'-6o7p{17su5tu5ot}ck{4qs5ku5ot5qs17sv5tv}4l{4qs5ku5ot5qs17sv5tv}cm{4qs5ku5ot5qs17sv5tv}cn{4qs5ku5ot5qs17sv5tv}co{4qs5ku5ot5qs17sv5tv}cp{4qs5ku5ot5qs17sv5tv}6l{17st5tt5os}17s{2kwclvcmvcnvcovcpv4lv4wwckv}5o{2kucltcmtcntcotcpt4lt4wtckt}5q{2ksclscmscnscoscps4ls4wvcks}5r{2ks4ws}5t{2kwclvcmvcnvcovcpv4lv4wwckv}eo{17st5tt5os}fu{17su5tu5ot}6p{17ss5ts}ek{17st5tt5os}el{17st5tt5os}em{17st5tt5os}en{17st5tt5os}6o{201ts}ep{17st5tt5os}es{17ss5ts}et{17ss5ts}eu{17ss5ts}ev{17ss5ts}6z{17su5tu5os5qt}fm{17su5tu5os5qt}fn{17su5tu5os5qt}fo{17su5tu5os5qt}fp{17su5tu5os5qt}fq{17su5tu5os5qt}fs{17su5tu5os5qt}ft{17su5tu5ot}7m{5os}fv{17su5tu5ot}fw{17su5tu5ot}}}")
            , 'Courier': uncompress("{'widths'{k3w'fof'6o}'kerning'{'fof'-6o}}")
            , 'Courier-BoldOblique': uncompress("{'widths'{k3w'fof'6o}'kerning'{'fof'-6o}}")
            , 'Times-Bold': uncompress("{'widths'{k3q2q5ncx2r201n3m201o6o201s2l201t2l201u2l201w3m201x3m201y3m2k1t2l2l202m2n2n3m2o3m2p6o202q6o2r1w2s2l2t2l2u3m2v3t2w1t2x2l2y1t2z1w3k3m3l3m3m3m3n3m3o3m3p3m3q3m3r3m3s3m203t2l203u2l3v2l3w3t3x3t3y3t3z3m4k5x4l4s4m4m4n4s4o4s4p4m4q3x4r4y4s4y4t2r4u3m4v4y4w4m4x5y4y4s4z4y5k3x5l4y5m4s5n3r5o4m5p4s5q4s5r6o5s4s5t4s5u4m5v2l5w1w5x2l5y3u5z3m6k2l6l3m6m3r6n2w6o3r6p2w6q2l6r3m6s3r6t1w6u2l6v3r6w1w6x5n6y3r6z3m7k3r7l3r7m2w7n2r7o2l7p3r7q3m7r4s7s3m7t3m7u2w7v2r7w1q7x2r7y3o202l3mcl4sal2lam3man3mao3map3mar3mas2lat4uau1yav3maw3tay4uaz2lbk2sbl3t'fof'6obo2lbp3rbr1tbs2lbu2lbv3mbz3mck4s202k3mcm4scn4sco4scp4scq6ocr4scs4mct4mcu4mcv4mcw2r2m3rcy2rcz2rdl4sdm4ydn4ydo4ydp4ydq4yds4ydt4sdu4sdv4sdw4sdz3rek3mel3mem3men3meo3mep3meq4ser2wes2wet2weu2wev2wew1wex1wey1wez1wfl3rfm3mfn3mfo3mfp3mfq3mfr3tfs3mft3rfu3rfv3rfw3rfz3m203k6o212m6o2dw2l2cq2l3t3m3u2l17s4s19m3m}'kerning'{cl{4qt5ks5ot5qy5rw17sv5tv}201t{cks4lscmscnscoscpscls4wv}2k{201ts}2w{4qu5ku7mu5os5qx5ru17su5tu}2x{17su5tu5ou5qs}2y{4qv5kv7mu5ot5qz5ru17su5tu}'fof'-6o7t{cksclscmscnscoscps4ls}3u{17su5tu5os5qu}3v{17su5tu5os5qu}fu{17su5tu5ou5qu}7p{17su5tu5ou5qu}ck{4qt5ks5ot5qy5rw17sv5tv}4l{4qt5ks5ot5qy5rw17sv5tv}cm{4qt5ks5ot5qy5rw17sv5tv}cn{4qt5ks5ot5qy5rw17sv5tv}co{4qt5ks5ot5qy5rw17sv5tv}cp{4qt5ks5ot5qy5rw17sv5tv}6l{17st5tt5ou5qu}17s{ckuclucmucnucoucpu4lu4wu}5o{ckuclucmucnucoucpu4lu4wu}5q{ckzclzcmzcnzcozcpz4lz4wu}5r{ckxclxcmxcnxcoxcpx4lx4wu}5t{ckuclucmucnucoucpu4lu4wu}7q{ckuclucmucnucoucpu4lu}6p{17sw5tw5ou5qu}ek{17st5tt5qu}el{17st5tt5ou5qu}em{17st5tt5qu}en{17st5tt5qu}eo{17st5tt5qu}ep{17st5tt5ou5qu}es{17ss5ts5qu}et{17sw5tw5ou5qu}eu{17sw5tw5ou5qu}ev{17ss5ts5qu}6z{17sw5tw5ou5qu5rs}fm{17sw5tw5ou5qu5rs}fn{17sw5tw5ou5qu5rs}fo{17sw5tw5ou5qu5rs}fp{17sw5tw5ou5qu5rs}fq{17sw5tw5ou5qu5rs}7r{cktcltcmtcntcotcpt4lt5os}fs{17sw5tw5ou5qu5rs}ft{17su5tu5ou5qu}7m{5os}fv{17su5tu5ou5qu}fw{17su5tu5ou5qu}fz{cksclscmscnscoscps4ls}}}")
            //, 'Symbol': uncompress("{'widths'{k3uaw4r19m3m2k1t2l2l202m2y2n3m2p5n202q6o3k3m2s2l2t2l2v3r2w1t3m3m2y1t2z1wbk2sbl3r'fof'6o3n3m3o3m3p3m3q3m3r3m3s3m3t3m3u1w3v1w3w3r3x3r3y3r3z2wbp3t3l3m5v2l5x2l5z3m2q4yfr3r7v3k7w1o7x3k}'kerning'{'fof'-6o}}")
            , 'Helvetica': uncompress("{'widths'{k3p2q4mcx1w201n3r201o6o201s1q201t1q201u1q201w2l201x2l201y2l2k1w2l1w202m2n2n3r2o3r2p5t202q6o2r1n2s2l2t2l2u2r2v3u2w1w2x2l2y1w2z1w3k3r3l3r3m3r3n3r3o3r3p3r3q3r3r3r3s3r203t2l203u2l3v1w3w3u3x3u3y3u3z3r4k6p4l4m4m4m4n4s4o4s4p4m4q3x4r4y4s4s4t1w4u3m4v4m4w3r4x5n4y4s4z4y5k4m5l4y5m4s5n4m5o3x5p4s5q4m5r5y5s4m5t4m5u3x5v1w5w1w5x1w5y2z5z3r6k2l6l3r6m3r6n3m6o3r6p3r6q1w6r3r6s3r6t1q6u1q6v3m6w1q6x5n6y3r6z3r7k3r7l3r7m2l7n3m7o1w7p3r7q3m7r4s7s3m7t3m7u3m7v2l7w1u7x2l7y3u202l3rcl4mal2lam3ran3rao3rap3rar3ras2lat4tau2pav3raw3uay4taz2lbk2sbl3u'fof'6obo2lbp3rbr1wbs2lbu2obv3rbz3xck4m202k3rcm4mcn4mco4mcp4mcq6ocr4scs4mct4mcu4mcv4mcw1w2m2ncy1wcz1wdl4sdm4ydn4ydo4ydp4ydq4yds4ydt4sdu4sdv4sdw4sdz3xek3rel3rem3ren3reo3rep3req5ter3mes3ret3reu3rev3rew1wex1wey1wez1wfl3rfm3rfn3rfo3rfp3rfq3rfr3ufs3xft3rfu3rfv3rfw3rfz3m203k6o212m6o2dw2l2cq2l3t3r3u1w17s4m19m3r}'kerning'{5q{4wv}cl{4qs5kw5ow5qs17sv5tv}201t{2wu4w1k2yu}201x{2wu4wy2yu}17s{2ktclucmucnu4otcpu4lu4wycoucku}2w{7qs4qz5k1m17sy5ow5qx5rsfsu5ty7tufzu}2x{17sy5ty5oy5qs}2y{7qs4qz5k1m17sy5ow5qx5rsfsu5ty7tufzu}'fof'-6o7p{17sv5tv5ow}ck{4qs5kw5ow5qs17sv5tv}4l{4qs5kw5ow5qs17sv5tv}cm{4qs5kw5ow5qs17sv5tv}cn{4qs5kw5ow5qs17sv5tv}co{4qs5kw5ow5qs17sv5tv}cp{4qs5kw5ow5qs17sv5tv}6l{17sy5ty5ow}do{17st5tt}4z{17st5tt}7s{fst}dm{17st5tt}dn{17st5tt}5o{ckwclwcmwcnwcowcpw4lw4wv}dp{17st5tt}dq{17st5tt}7t{5ow}ds{17st5tt}5t{2ktclucmucnu4otcpu4lu4wycoucku}fu{17sv5tv5ow}6p{17sy5ty5ow5qs}ek{17sy5ty5ow}el{17sy5ty5ow}em{17sy5ty5ow}en{5ty}eo{17sy5ty5ow}ep{17sy5ty5ow}es{17sy5ty5qs}et{17sy5ty5ow5qs}eu{17sy5ty5ow5qs}ev{17sy5ty5ow5qs}6z{17sy5ty5ow5qs}fm{17sy5ty5ow5qs}fn{17sy5ty5ow5qs}fo{17sy5ty5ow5qs}fp{17sy5ty5qs}fq{17sy5ty5ow5qs}7r{5ow}fs{17sy5ty5ow5qs}ft{17sv5tv5ow}7m{5ow}fv{17sv5tv5ow}fw{17sv5tv5ow}}}")
            , 'Helvetica-BoldOblique': uncompress("{'widths'{k3s2q4scx1w201n3r201o6o201s1w201t1w201u1w201w3m201x3m201y3m2k1w2l2l202m2n2n3r2o3r2p5t202q6o2r1s2s2l2t2l2u2r2v3u2w1w2x2l2y1w2z1w3k3r3l3r3m3r3n3r3o3r3p3r3q3r3r3r3s3r203t2l203u2l3v2l3w3u3x3u3y3u3z3x4k6l4l4s4m4s4n4s4o4s4p4m4q3x4r4y4s4s4t1w4u3r4v4s4w3x4x5n4y4s4z4y5k4m5l4y5m4s5n4m5o3x5p4s5q4m5r5y5s4m5t4m5u3x5v2l5w1w5x2l5y3u5z3r6k2l6l3r6m3x6n3r6o3x6p3r6q2l6r3x6s3x6t1w6u1w6v3r6w1w6x5t6y3x6z3x7k3x7l3x7m2r7n3r7o2l7p3x7q3r7r4y7s3r7t3r7u3m7v2r7w1w7x2r7y3u202l3rcl4sal2lam3ran3rao3rap3rar3ras2lat4tau2pav3raw3uay4taz2lbk2sbl3u'fof'6obo2lbp3xbq3rbr1wbs2lbu2obv3rbz3xck4s202k3rcm4scn4sco4scp4scq6ocr4scs4mct4mcu4mcv4mcw1w2m2zcy1wcz1wdl4sdm4ydn4ydo4ydp4ydq4yds4ydt4sdu4sdv4sdw4sdz3xek3rel3rem3ren3reo3rep3req5ter3res3ret3reu3rev3rew1wex1wey1wez1wfl3xfm3xfn3xfo3xfp3xfq3xfr3ufs3xft3xfu3xfv3xfw3xfz3r203k6o212m6o2dw2l2cq2l3t3r3u2l17s4m19m3r}'kerning'{cl{4qs5ku5ot5qs17sv5tv}201t{2ww4wy2yw}201w{2ks}201x{2ww4wy2yw}2k{201ts201xs}2w{7qs4qu5kw5os5qw5rs17su5tu7tsfzs}2x{5ow5qs}2y{7qs4qu5kw5os5qw5rs17su5tu7tsfzs}'fof'-6o7p{17su5tu5ot}ck{4qs5ku5ot5qs17sv5tv}4l{4qs5ku5ot5qs17sv5tv}cm{4qs5ku5ot5qs17sv5tv}cn{4qs5ku5ot5qs17sv5tv}co{4qs5ku5ot5qs17sv5tv}cp{4qs5ku5ot5qs17sv5tv}6l{17st5tt5os}17s{2kwclvcmvcnvcovcpv4lv4wwckv}5o{2kucltcmtcntcotcpt4lt4wtckt}5q{2ksclscmscnscoscps4ls4wvcks}5r{2ks4ws}5t{2kwclvcmvcnvcovcpv4lv4wwckv}eo{17st5tt5os}fu{17su5tu5ot}6p{17ss5ts}ek{17st5tt5os}el{17st5tt5os}em{17st5tt5os}en{17st5tt5os}6o{201ts}ep{17st5tt5os}es{17ss5ts}et{17ss5ts}eu{17ss5ts}ev{17ss5ts}6z{17su5tu5os5qt}fm{17su5tu5os5qt}fn{17su5tu5os5qt}fo{17su5tu5os5qt}fp{17su5tu5os5qt}fq{17su5tu5os5qt}fs{17su5tu5os5qt}ft{17su5tu5ot}7m{5os}fv{17su5tu5ot}fw{17su5tu5ot}}}")
            //, 'ZapfDingbats': uncompress("{'widths'{k4u2k1w'fof'6o}'kerning'{'fof'-6o}}")
            , 'Courier-Bold': uncompress("{'widths'{k3w'fof'6o}'kerning'{'fof'-6o}}")
            , 'Times-Italic': uncompress("{'widths'{k3n2q4ycx2l201n3m201o5t201s2l201t2l201u2l201w3r201x3r201y3r2k1t2l2l202m2n2n3m2o3m2p5n202q5t2r1p2s2l2t2l2u3m2v4n2w1t2x2l2y1t2z1w3k3m3l3m3m3m3n3m3o3m3p3m3q3m3r3m3s3m203t2l203u2l3v2l3w4n3x4n3y4n3z3m4k5w4l3x4m3x4n4m4o4s4p3x4q3x4r4s4s4s4t2l4u2w4v4m4w3r4x5n4y4m4z4s5k3x5l4s5m3x5n3m5o3r5p4s5q3x5r5n5s3x5t3r5u3r5v2r5w1w5x2r5y2u5z3m6k2l6l3m6m3m6n2w6o3m6p2w6q1w6r3m6s3m6t1w6u1w6v2w6w1w6x4s6y3m6z3m7k3m7l3m7m2r7n2r7o1w7p3m7q2w7r4m7s2w7t2w7u2r7v2s7w1v7x2s7y3q202l3mcl3xal2ram3man3mao3map3mar3mas2lat4wau1vav3maw4nay4waz2lbk2sbl4n'fof'6obo2lbp3mbq3obr1tbs2lbu1zbv3mbz3mck3x202k3mcm3xcn3xco3xcp3xcq5tcr4mcs3xct3xcu3xcv3xcw2l2m2ucy2lcz2ldl4mdm4sdn4sdo4sdp4sdq4sds4sdt4sdu4sdv4sdw4sdz3mek3mel3mem3men3meo3mep3meq4mer2wes2wet2weu2wev2wew1wex1wey1wez1wfl3mfm3mfn3mfo3mfp3mfq3mfr4nfs3mft3mfu3mfv3mfw3mfz2w203k6o212m6m2dw2l2cq2l3t3m3u2l17s3r19m3m}'kerning'{cl{5kt4qw}201s{201sw}201t{201tw2wy2yy6q-t}201x{2wy2yy}2k{201tw}2w{7qs4qy7rs5ky7mw5os5qx5ru17su5tu}2x{17ss5ts5os}2y{7qs4qy7rs5ky7mw5os5qx5ru17su5tu}'fof'-6o6t{17ss5ts5qs}7t{5os}3v{5qs}7p{17su5tu5qs}ck{5kt4qw}4l{5kt4qw}cm{5kt4qw}cn{5kt4qw}co{5kt4qw}cp{5kt4qw}6l{4qs5ks5ou5qw5ru17su5tu}17s{2ks}5q{ckvclvcmvcnvcovcpv4lv}5r{ckuclucmucnucoucpu4lu}5t{2ks}6p{4qs5ks5ou5qw5ru17su5tu}ek{4qs5ks5ou5qw5ru17su5tu}el{4qs5ks5ou5qw5ru17su5tu}em{4qs5ks5ou5qw5ru17su5tu}en{4qs5ks5ou5qw5ru17su5tu}eo{4qs5ks5ou5qw5ru17su5tu}ep{4qs5ks5ou5qw5ru17su5tu}es{5ks5qs4qs}et{4qs5ks5ou5qw5ru17su5tu}eu{4qs5ks5qw5ru17su5tu}ev{5ks5qs4qs}ex{17ss5ts5qs}6z{4qv5ks5ou5qw5ru17su5tu}fm{4qv5ks5ou5qw5ru17su5tu}fn{4qv5ks5ou5qw5ru17su5tu}fo{4qv5ks5ou5qw5ru17su5tu}fp{4qv5ks5ou5qw5ru17su5tu}fq{4qv5ks5ou5qw5ru17su5tu}7r{5os}fs{4qv5ks5ou5qw5ru17su5tu}ft{17su5tu5qs}fu{17su5tu5qs}fv{17su5tu5qs}fw{17su5tu5qs}}}")
            , 'Times-Roman': uncompress("{'widths'{k3n2q4ycx2l201n3m201o6o201s2l201t2l201u2l201w2w201x2w201y2w2k1t2l2l202m2n2n3m2o3m2p5n202q6o2r1m2s2l2t2l2u3m2v3s2w1t2x2l2y1t2z1w3k3m3l3m3m3m3n3m3o3m3p3m3q3m3r3m3s3m203t2l203u2l3v1w3w3s3x3s3y3s3z2w4k5w4l4s4m4m4n4m4o4s4p3x4q3r4r4s4s4s4t2l4u2r4v4s4w3x4x5t4y4s4z4s5k3r5l4s5m4m5n3r5o3x5p4s5q4s5r5y5s4s5t4s5u3x5v2l5w1w5x2l5y2z5z3m6k2l6l2w6m3m6n2w6o3m6p2w6q2l6r3m6s3m6t1w6u1w6v3m6w1w6x4y6y3m6z3m7k3m7l3m7m2l7n2r7o1w7p3m7q3m7r4s7s3m7t3m7u2w7v3k7w1o7x3k7y3q202l3mcl4sal2lam3man3mao3map3mar3mas2lat4wau1vav3maw3say4waz2lbk2sbl3s'fof'6obo2lbp3mbq2xbr1tbs2lbu1zbv3mbz2wck4s202k3mcm4scn4sco4scp4scq5tcr4mcs3xct3xcu3xcv3xcw2l2m2tcy2lcz2ldl4sdm4sdn4sdo4sdp4sdq4sds4sdt4sdu4sdv4sdw4sdz3mek2wel2wem2wen2weo2wep2weq4mer2wes2wet2weu2wev2wew1wex1wey1wez1wfl3mfm3mfn3mfo3mfp3mfq3mfr3sfs3mft3mfu3mfv3mfw3mfz3m203k6o212m6m2dw2l2cq2l3t3m3u1w17s4s19m3m}'kerning'{cl{4qs5ku17sw5ou5qy5rw201ss5tw201ws}201s{201ss}201t{ckw4lwcmwcnwcowcpwclw4wu201ts}2k{201ts}2w{4qs5kw5os5qx5ru17sx5tx}2x{17sw5tw5ou5qu}2y{4qs5kw5os5qx5ru17sx5tx}'fof'-6o7t{ckuclucmucnucoucpu4lu5os5rs}3u{17su5tu5qs}3v{17su5tu5qs}7p{17sw5tw5qs}ck{4qs5ku17sw5ou5qy5rw201ss5tw201ws}4l{4qs5ku17sw5ou5qy5rw201ss5tw201ws}cm{4qs5ku17sw5ou5qy5rw201ss5tw201ws}cn{4qs5ku17sw5ou5qy5rw201ss5tw201ws}co{4qs5ku17sw5ou5qy5rw201ss5tw201ws}cp{4qs5ku17sw5ou5qy5rw201ss5tw201ws}6l{17su5tu5os5qw5rs}17s{2ktclvcmvcnvcovcpv4lv4wuckv}5o{ckwclwcmwcnwcowcpw4lw4wu}5q{ckyclycmycnycoycpy4ly4wu5ms}5r{cktcltcmtcntcotcpt4lt4ws}5t{2ktclvcmvcnvcovcpv4lv4wuckv}7q{cksclscmscnscoscps4ls}6p{17su5tu5qw5rs}ek{5qs5rs}el{17su5tu5os5qw5rs}em{17su5tu5os5qs5rs}en{17su5qs5rs}eo{5qs5rs}ep{17su5tu5os5qw5rs}es{5qs}et{17su5tu5qw5rs}eu{17su5tu5qs5rs}ev{5qs}6z{17sv5tv5os5qx5rs}fm{5os5qt5rs}fn{17sv5tv5os5qx5rs}fo{17sv5tv5os5qx5rs}fp{5os5qt5rs}fq{5os5qt5rs}7r{ckuclucmucnucoucpu4lu5os}fs{17sv5tv5os5qx5rs}ft{17ss5ts5qs}fu{17sw5tw5qs}fv{17sw5tw5qs}fw{17ss5ts5qs}fz{ckuclucmucnucoucpu4lu5os5rs}}}")
            , 'Helvetica-Oblique': uncompress("{'widths'{k3p2q4mcx1w201n3r201o6o201s1q201t1q201u1q201w2l201x2l201y2l2k1w2l1w202m2n2n3r2o3r2p5t202q6o2r1n2s2l2t2l2u2r2v3u2w1w2x2l2y1w2z1w3k3r3l3r3m3r3n3r3o3r3p3r3q3r3r3r3s3r203t2l203u2l3v1w3w3u3x3u3y3u3z3r4k6p4l4m4m4m4n4s4o4s4p4m4q3x4r4y4s4s4t1w4u3m4v4m4w3r4x5n4y4s4z4y5k4m5l4y5m4s5n4m5o3x5p4s5q4m5r5y5s4m5t4m5u3x5v1w5w1w5x1w5y2z5z3r6k2l6l3r6m3r6n3m6o3r6