
/* Release Date: June-03-2025 
Copyright (c) 2011-2025 jQWidgets. 
License: https://jqwidgets.com/license/ */


/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 7196:
/***/ (() => {

/* tslint:disable */
/* eslint-disable */
(function(){
	if (typeof document === 'undefined') { 
		return;
	}

(function ($) {

    $.jqx.jqxWidget("jqxButtonGroup", "", {});

    $.extend($.jqx._jqxButtonGroup.prototype, {
        defineInstance: function () {
            var settings =
            {
                //Possible values: checkbox, radio, default
                mode: 'default',
                roundedCorners: true,
                disabled: false,
                enableHover: false,
                orientation: 'horizontal',
                width: null,
                height: null,
                _eventsMap: {
                    'mousedown': $.jqx.mobile.getTouchEventName('touchstart'),
                    'mouseup': $.jqx.mobile.getTouchEventName('touchend')
                },
                _events: ['selected', 'unselected', 'buttonclick'],
                _buttonId: {},
                _selected: null,
                _pressed: null,
                rtl: false,
                template: "",
                _baseId: 'group_button',
                aria:
                {
                    "aria-disabled": { name: "disabled", type: "boolean" }
                }
            };
            if (this === $.jqx._jqxButtonGroup.prototype) {
                return settings;
            }
            $.extend(true, this, settings);
            return settings;
        },

        createInstance: function (args) {
            var that = this;
            that._isTouchDevice = $.jqx.mobile.isTouchDevice();
            $.jqx.aria(that);
            that._baseId = that._baseId + that.element.id;
            that.addHandler(that.host, 'selectstart', function (event) {
                if (!that.disabled) {
                    event.preventDefault();
                }
            });
        },

        refresh: function () {
            var that = this;
            if (that.width) {
                if (that.width.toString() && that.width.toString().indexOf('%') >= 0) {
                    that.element.style.width = that.width;
                }
                else {
                    that.host.width(that.width);
                }
            }
            if (that.height) that.host.height(that.height);
            that._refreshButtons();
        },

        render: function () {
            this.refresh();
        },

        resize: function () {
            this.refresh();
        },

        _getEvent: function (event) {
            var that = this;
            if (that._isTouchDevice) {
                var e = that._eventsMap[event] || event;
                e += "." + that.element.id;
                return e;
            }
            event += "." + that.element.id;
            return event;
        },

        _refreshButtons: function () {
            var that = this;
            if (that.lastElement)
                that.lastElement.remove();

            that.lastElement = $("<div style='clear: both;'></div>");
            var children = that.host.children(),
                count = children.length,
                current;

            switch (that.mode) {
                case "radio":
                    that.host.attr('role', 'radiogroup');
                    break;
                case "checkbox":
                case "default":
                    that.host.attr('role', 'group');
                    break;
            }

            var width = new Number(100 / count).toFixed(2);
            for (var i = 0; i < count; i += 1) {
                current = $(children[i]);
                if (that.width) {
                    if (that.orientation === "horizontal") {
                        current.css('width', width + '%');
                        current.css('box-sizing', 'border-box');
                        current.css('-moz-box-sizing', 'border-box');
                        current.css('white-space', 'nowrap');
                        current.css('text-overflow', 'ellipsis');
                        current.css('overflow', 'hidden');
                    }
                    else {
                        current.css('box-sizing', 'border-box');
                        current.css('-moz-box-sizing', 'border-box');
                        current.css('width', '100%');
                    }
                }

                that._refreshButton(current, i, count);
            }
            that.lastElement.appendTo(that.host);
        },

        _refreshButton: function (btn, counter, count) {
            (function (btn) {
                var that = this;
                btn = that._render(btn);
                that._removeStyles(btn);
                that._addStyles(btn, counter, count);
                that._performLayout(btn);
                that._removeButtonListeners(btn);
                that._addButtonListeners(btn);
                that._handleButtonId(btn, counter);

                if (that.mode === "radio") {
                    btn.attr('role', 'radio');
                }
                else {
                    btn.attr('role', 'button');
                }
                btn.attr('disabled', that.disabled);
                if (that.disabled) {
                    btn.addClass(that.toThemeProperty('jqx-fill-state-disabled'));
                }
                else {
                    btn.removeClass(that.toThemeProperty('jqx-fill-state-disabled'));
                }
            }).apply(this, [btn]);
        },

        destroy: function (removeFromDom) {
            var that = this;
            var children = that.host.children(),
            count = children.length,
            current;

            for (var i = 0; i < count; i += 1) {
                current = $(children[i]);
                that._removeStyles(current);
                that._removeButtonListeners(current);
            }

            if (removeFromDom !== false) {
                that.host.remove();
            }
        },

        _render: function (btn) {
            var that = this;
            if (btn[0].tagName.toLowerCase() === 'button') {
                return that._renderFromButton(btn);
            } else {
                return that._renderButton(btn);
            }
        },

        _renderButton: function (btn) {
            var content;
            btn.wrapInner('<div/>');
            return btn;
        },

        _removeStyles: function (btn) {
            var that = this;
            var tp = that.toThemeProperty;
            that.host.removeClass('jqx-widget');
            that.host.removeClass('jqx-rc-all');
            btn.removeClass(tp.call(this, 'jqx-fill-state-normal'));
            btn.removeClass(tp.call(this, 'jqx-group-button-normal'));
            btn.removeClass(tp.call(this, 'jqx-rc-tl'));
            btn.removeClass(tp.call(this, 'jqx-rc-bl'));
            btn.removeClass(tp.call(this, 'jqx-rc-tr'));
            btn.removeClass(tp.call(this, 'jqx-rc-br'));
            btn.css('margin-left', 0);
        },

        _addStyles: function (btn, counter, count) {
            var that = this;
            var tp = this.toThemeProperty;
            that.host.addClass(tp.call(this, 'jqx-widget'));
            that.host.addClass(tp.call(this, 'jqx-rc-all'));
            that.host.addClass(tp.call(this, 'jqx-buttongroup'));
            btn.addClass(tp.call(this, 'jqx-button'));
            btn.addClass(tp.call(this, 'jqx-group-button-normal'));
            btn.addClass(tp.call(this, 'jqx-fill-state-normal'));
            if (that.template) {
                btn.addClass(tp.call(this, 'jqx-' + that.template));
            }
            if (that.roundedCorners) {
                if (counter === 0) {
                    that._addRoundedCorners(btn, true);
                } else if (counter === count - 1) {
                    that._addRoundedCorners(btn, false);
                }
            }
            if (that.orientation === 'horizontal') {
                btn.css('margin-left', -parseInt(btn.css('border-left-width'), 10));
            }
            else {
                btn.css('margin-top', -parseInt(btn.css('border-left-width'), 10));
            }
        },

        _addRoundedCorners: function (button, left) {
            var that = this;
            var tp = that.toThemeProperty;
            if (that.orientation === 'horizontal') {
                if (left) {
                    button.addClass(tp.call(this, 'jqx-rc-tl'));
                    button.addClass(tp.call(this, 'jqx-rc-bl'));
                } else {
                    button.addClass(tp.call(this, 'jqx-rc-tr'));
                    button.addClass(tp.call(this, 'jqx-rc-br'));
                }
            }
            else {
                if (left) {
                    button.addClass(tp.call(this, 'jqx-rc-tl'));
                    button.addClass(tp.call(this, 'jqx-rc-tr'));
                } else {
                    button.addClass(tp.call(this, 'jqx-rc-bl'));
                    button.addClass(tp.call(this, 'jqx-rc-br'));
                }
            }
        },

        _centerContent: function (content, parent) {
            content.css({
                'margin-top': (parent.height() - content.height()) / 2,
                'margin-left': (parent.width() - content.width()) / 2
            });
            return content;
        },

        _renderFromButton: function (btn) {
            var content = btn.val();
            if (content === "") {
                content = btn.html();
            }

            var div;
            var id = btn[0].id;
            btn.wrap('<div/>');
            div = btn.parent();
            div.attr('style', btn.attr('style'));
            btn.remove();
            $.jqx.utilities.html(div, content);
            div[0].id = id;
            return div;
        },

        _performLayout: function (btn) {
            if (this.orientation === 'horizontal') {
                if (this.rtl) {
                    btn.css('float', 'right');
                }
                else {
                    btn.css('float', 'left');
                }
            }
            else {
                btn.css('float', 'none');
            }

            this._centerContent($(btn.children()), btn);
        },

        _mouseEnterHandler: function (e) {
            var self = e.data.self,
                btn = $(e.currentTarget);
            if (self._isDisabled(btn) || !self.enableHover) {
                return;
            }
            var tp = self.toThemeProperty;
            btn.addClass(tp.call(self, 'jqx-group-button-hover'));
            btn.addClass(tp.call(self, 'jqx-fill-state-hover'));
        },

        _mouseLeaveHandler: function (e) {
            var self = e.data.self,
                btn = $(e.currentTarget);
            if (self._isDisabled(btn) || !self.enableHover) {
                return;
            }
            var tp = self.toThemeProperty;
            btn.removeClass(tp.call(self, 'jqx-group-button-hover'));
            btn.removeClass(tp.call(self, 'jqx-fill-state-hover'));
        },

        _mouseDownHandler: function (e) {
            var self = e.data.self,
                btn = $(e.currentTarget);
            if (self._isDisabled(btn)) {
                return;
            }
            self._pressed = btn;
            var tp = self.toThemeProperty;
            btn.addClass(tp.call(self, 'jqx-group-button-pressed'));
            btn.addClass(tp.call(self, 'jqx-fill-state-pressed'));
        },

        _mouseUpHandler: function (e) {
            var self = e.data.self,
                btn = $(e.currentTarget);
            if (self._isDisabled(btn)) {
                return;
            }
            self._handleSelection(btn);
            self._pressed = null;
            btn = self._buttonId[btn[0].id];
            self._raiseEvent(2, { index: btn.num, button: btn.btn });
        },

        _isDisabled: function (btn) {
            if (!btn || !btn[0]) {
                return false;
            }
            return this._buttonId[btn[0].id].disabled;
        },

        _documentUpHandler: function (e) {
            var self = e.data.self,
                pressedButton = self._pressed;
            if (pressedButton && !self._buttonId[pressedButton[0].id].selected) {
                pressedButton.removeClass(self.toThemeProperty('jqx-fill-state-pressed'));
                self._pressed = null;
            }
        },

        _addButtonListeners: function (btn) {
            var that = this;
            var ah = that.addHandler;
            var ge = that._getEvent;

            ah(btn, ge.call(that, 'mouseenter'), that._mouseEnterHandler, { self: that });
            ah(btn, ge.call(that, 'mouseleave'), that._mouseLeaveHandler, { self: that });
            ah(btn, ge.call(that, 'mousedown'), that._mouseDownHandler, { self: that });
            ah(btn, ge.call(that, 'mouseup'), that._mouseUpHandler, { self: that });
            ah($(document), ge.call(that, 'mouseup'), that._documentUpHandler, { self: that });
        },

        _removeButtonListeners: function (btn) {
            var that = this;
            var rh = that.removeHandler;
            var ge = that._getEvent;
            rh(btn, ge.call(that, 'mouseenter'), that._mouseEnterHandler);
            rh(btn, ge.call(that, 'mouseleave'), that._mouseLeaveHandler);
            rh(btn, ge.call(that, 'mousedown'), that._mouseDownHandler);
            rh(btn, ge.call(that, 'mouseup'), that._mouseUpHandler);
            rh($(document), ge.call(that, 'mouseup'), that._documentUpHandler);
        },

        _handleSelection: function (btn) {
            var that = this;
            if (that.mode === 'radio') {
                that._handleRadio(btn);
            } else if (that.mode === 'checkbox') {
                that._handleCheckbox(btn);
            } else {
                that._handleDefault(btn);
            }
        },

        _handleRadio: function (btn) {
            var that = this;
            var selected = that._getSelectedButton();
            if (selected && selected.btn[0].id !== btn[0].id) {
                that._unselectButton(selected.btn, true);
            }
            for (var data in that._buttonId) {
                that._buttonId[data].selected = true;
                that._unselectButton(that._buttonId[data].btn, false);
            }

            that._selectButton(btn, true);
        },

        _handleCheckbox: function (btn) {
            var that = this;
            var btnInfo = that._buttonId[btn[0].id];
            if (btnInfo.selected) {
                that._unselectButton(btnInfo.btn, true);
            } else {
                that._selectButton(btn, true);
            }
        },

        _handleDefault: function (btn) {
            var that = this;
            that._selectButton(btn, false);
            for (var data in that._buttonId) {
                that._buttonId[data].selected = true;
                that._unselectButton(that._buttonId[data].btn, false);
            }
        },

        _getSelectedButton: function () {
            var that = this;
            for (var data in that._buttonId) {
                if (that._buttonId[data].selected) {
                    return that._buttonId[data];
                }
            }
            return null;
        },

        _getSelectedButtons: function () {
            var that = this;
            var selected = [];
            for (var data in that._buttonId) {
                if (that._buttonId[data].selected) {
                    selected.push(that._buttonId[data].num);
                }
            }
            return selected;
        },

        _getButtonByIndex: function (index) {
            var that = this;
            var current;
            for (var data in that._buttonId) {
                if (that._buttonId[data].num === index) {
                    return that._buttonId[data];
                }
            }
            return null;
        },

        _selectButton: function (btn, raiseEvent) {
            var that = this;
            var btnInfo = that._buttonId[btn[0].id];
            if (btnInfo.selected) {
                return;
            }
            var tp = that.toThemeProperty;
            btnInfo.btn.addClass(tp.call(this, 'jqx-group-button-pressed'));
            btnInfo.btn.addClass(tp.call(this, 'jqx-fill-state-pressed'));
            btnInfo.selected = true;
            if (raiseEvent) {
                that._raiseEvent(0, { index: btnInfo.num, button: btnInfo.btn });
            }
            $.jqx.aria(btnInfo.btn, 'aria-checked', true);
        },

        _unselectButton: function (btn, raiseEvent) {
            var that = this;
            var btnInfo = that._buttonId[btn[0].id];
            if (!btnInfo.selected) {
                return;
            }
            var tp = that.toThemeProperty;
            btnInfo.btn.removeClass(tp.call(this, 'jqx-group-button-pressed'));
            btnInfo.btn.removeClass(tp.call(this, 'jqx-fill-state-pressed'));
            btnInfo.selected = false;
            if (raiseEvent) {
                that._raiseEvent(1, { index: btnInfo.num, button: btnInfo.btn });
            }
            $.jqx.aria(btnInfo.btn, 'aria-checked', false);
        },

        setSelection: function (index) {
            var that = this;
            if (index === -1) {
                that.clearSelection();
                return;
            }

            if (that.mode === 'checkbox') {
                if (typeof index === 'number') {
                    that._setSelection(index);
                } else {
                    for (var i = 0; i < index.length; i += 1) {
                        that._setSelection(index[i]);
                    }
                }
            } else if (typeof index === 'number' && that.mode === 'radio') {
                that._setSelection(index);
            }
        },

        _setSelection: function (index) {
            var that = this;
            var btn = that._getButtonByIndex(index);
            if (btn) {
                that._handleSelection(btn.btn);
            }
        },

        getSelection: function () {
            var that = this;
            if (that.mode === 'radio') {
                if (that._getSelectedButton()) {
                    return that._getSelectedButton().num;
                }
            } else if (that.mode === 'checkbox') {
                return that._getSelectedButtons();
            }
            return undefined;
        },

        disable: function () {
            var that = this;
            that.disabled = true;
            var current;
            for (var btn in that._buttonId) {
                current = that._buttonId[btn];
                that.disableAt(current.num);
            }
            $.jqx.aria(that, "aria-disabled", true);
        },

        enable: function () {
            var that = this;
            that.disabled = false;
            var current;
            for (var btn in that._buttonId) {
                current = that._buttonId[btn];
                that.enableAt(current.num);
            }
            $.jqx.aria(that, "aria-disabled", false);
        },

        disableAt: function (index) {
            var that = this;
            var btn = that._getButtonByIndex(index);
            if (!btn.disabled) {
                btn.disabled = true;
                btn.btn.addClass(that.toThemeProperty('jqx-fill-state-disabled'));
            }
        },

        enableAt: function (index) {
            var that = this;
            var btn = that._getButtonByIndex(index);
            if (btn.disabled) {
                btn.disabled = false;
                btn.btn.removeClass(that.toThemeProperty('jqx-fill-state-disabled'));
            }
        },

        _handleButtonId: function (btn, number) {
            var id = btn[0].id,
                btnId = { btn: btn, num: number, selected: false },
                widgetId;
            if (!id) {
                id = this._baseId + btn.index();
            }
            btn[0].id = id;
            this._buttonId[id] = btnId;
            return id;
        },

        _raiseEvent: function (id, data) {
            var event = $.Event(this._events[id]);
            event.args = data;
            return this.host.trigger(event);
        },

        _unselectAll: function () {
            for (var data in this._buttonId) {
                this._unselectButton(this._buttonId[data].btn, false);
            }
        },

        clearSelection: function () {
            this._unselectAll();
        },

        propertyChangedHandler: function (object, key, oldvalue, value) {
            if (key === 'theme' && value !== null) {
                $.jqx.utilities.setTheme(oldvalue, value, object.host);
            }

            if (key === 'rtl') {
                object.refresh();
            }
            if (key === "template") {
                object.refresh();
            }
            if (key === 'mode') {
                object._unselectAll();
                object.refresh();
                return;
            } else if (key === 'disabled') {
                if (value) {
                    object.disable();
                } else {
                    object.enable();
                }
            } else {
                object.refresh();
            }
        }
    });
})(jqxBaseFramework);
})();



/***/ }),

/***/ 7351:
/***/ (() => {

/* tslint:disable */
/* eslint-disable */
(function () {
    if (typeof document === 'undefined') {
        return;
    }

    (function ($) {
        $.jqx.cssroundedcorners = function (value) {
            var cssMap = {
                'all': 'jqx-rc-all',
                'top': 'jqx-rc-t',
                'bottom': 'jqx-rc-b',
                'left': 'jqx-rc-l',
                'right': 'jqx-rc-r',
                'top-right': 'jqx-rc-tr',
                'top-left': 'jqx-rc-tl',
                'bottom-right': 'jqx-rc-br',
                'bottom-left': 'jqx-rc-bl'
            };

            for (var prop in cssMap) {
                if (!cssMap.hasOwnProperty(prop))
                    continue;

                if (value == prop)
                    return cssMap[prop];
            }
        }

        $.jqx.jqxWidget("jqxButton", "", {});

        $.extend($.jqx._jqxButton.prototype, {
            defineInstance: function () {
                var settings = {
                    type: '',
                    cursor: 'arrow',
                    // rounds the button corners.
                    roundedCorners: 'all',
                    // enables / disables the button
                    disabled: false,
                    // sets height to the button.
                    height: null,
                    // sets width to the button.
                    width: null,
                    overrideTheme: false,
                    enableHover: true,
                    enableDefault: true,
                    enablePressed: true,
                    imgPosition: "center",
                    imgSrc: "",
                    imgWidth: 16,
                    imgHeight: 16,
                    value: null,
                    textPosition: "",
                    textImageRelation: "overlay",
                    rtl: false,
                    _ariaDisabled: false,
                    _scrollAreaButton: false,
                    // "primary", "inverse", "danger", "info", "success", "warning", "link"
                    template: "default",
                    aria:
                    {
                        "aria-disabled": { name: "disabled", type: "boolean" }
                    }
                }
                if (this === $.jqx._jqxButton.prototype) {
                    return settings;
                }
                $.extend(true, this, settings);
                return settings;
            },

            _addImage: function (name) {
                var that = this;
                if (that.element.nodeName.toLowerCase() == "input" || that.element.nodeName.toLowerCase() == "button" || that.element.nodeName.toLowerCase() == "div") {
                    if (!that._img) {
                        that.field = that.element;
                        if (that.field.className) {
                            that._className = that.field.className;
                        }

                        var properties = {
                            'title': that.field.title
                        };

                        var value = null;
                        if (that.field.getAttribute('value')) {
                            var value = that.field.getAttribute('value');
                        }
                        else if (that.element.nodeName.toLowerCase() != "input") {
                            var value = that.element.innerHTML;
                        }
                        if (that.value) {
                            value = that.value;
                        }
                        if (that.field.id.length) {
                            properties.id = that.field.id.replace(/[^\w]/g, '_') + "_" + name;
                        }
                        else {
                            properties.id = $.jqx.utilities.createId() + "_" + name;
                        }


                        var wrapper = document.createElement('div');
                        wrapper.id = properties.id;
                        wrapper.title = properties.title;
                        wrapper.style.cssText = that.field.style.cssText;
                        wrapper.style.boxSizing = 'border-box';

                        var img = document.createElement("img");
                        img.setAttribute('src', that.imgSrc);
                        img.setAttribute('width', that.imgWidth);
                        img.setAttribute('height', that.imgHeight);
                        wrapper.appendChild(img);
                        that._img = img;

                        var text = document.createElement('span');
                        if (value) {
                            text.innerHTML = value;
                            that.value = value;
                        }
                        wrapper.appendChild(text);
                        that._text = text;

                        that.field.style.display = "none";
                        if (that.field.parentNode) {
                            that.field.parentNode.insertBefore(wrapper, that.field.nextSibling);
                        }

                        var data = that.host.data();
                        that.host = $(wrapper);
                        that.host.data(data);
                        that.element = wrapper;
                        that.element.id = that.field.id;
                        that.field.id = properties.id;
                        var elementObj = new $(that.element);
                        var fieldObj = new $(that.field);
                        if (that._className) {
                            elementObj.addClass(that._className);
                            fieldObj.removeClass(that._className);
                        }

                        if (that.field.tabIndex) {
                            var tabIndex = that.field.tabIndex;
                            that.field.tabIndex = -1;
                            that.element.tabIndex = tabIndex;
                        }
                    }
                    else {
                        that._img.setAttribute('src', that.imgSrc);
                        that._img.setAttribute('width', that.imgWidth);
                        that._img.setAttribute('height', that.imgHeight);
                        that._text.innerHTML = that.value;
                    }
                    if (!that.imgSrc) {
                        that._img.style.display = "none";
                    }
                    else {
                        that._img.style.display = "inline";
                    }

                    if (!that.value) {
                        that._text.style.display = "none";
                    }
                    else {
                        that._text.style.display = "inline";
                    }

                    that._positionTextAndImage();
                }
            },

            _positionTextAndImage: function () {
                var that = this;
                var width = that.element.offsetWidth;
                var height = that.element.offsetHeight;

                var imgWidth = that.imgWidth;
                var imgHeight = that.imgHeight;
                if (that.imgSrc == "") {
                    imgWidth = 0;
                    imgHeight = 0;
                }

                var textWidth = that._text.offsetWidth;
                var textHeight = that._text.offsetHeight;
                var offset = 4;
                var edgeOffset = 4;
                var factorIncrease = 4;
                var w = 0;
                var h = 0;
                switch (that.textImageRelation) {
                    case "imageBeforeText":
                    case "textBeforeImage":
                        w = imgWidth + textWidth + 2 * factorIncrease + offset + 2 * edgeOffset;
                        h = Math.max(imgHeight, textHeight) + 2 * factorIncrease + offset + 2 * edgeOffset;
                        break;
                    case "imageAboveText":
                    case "textAboveImage":
                        w = Math.max(imgWidth, textWidth) + 2 * factorIncrease;
                        h = imgHeight + textHeight + offset + 2 * factorIncrease + 2 * edgeOffset;
                        break;
                    case "overlay":
                        w = Math.max(imgWidth, textWidth) + 2 * factorIncrease;
                        h = Math.max(imgHeight, textHeight) + 2 * factorIncrease;
                        break;
                }

                if (!that.width) {
                    that.element.style.width = w + "px";
                    width = w;
                }

                if (!that.height) {
                    that.element.style.height = h + "px";
                    height = h;
                }

                that._img.style.position = 'absolute';
                that._text.style.position = 'absolute';
                that.element.style.position = 'relative';
                that.element.style.overflow = 'hidden';

                var textRect = {};
                var imageRect = {};

                var drawElement = function (element, drawArea, pos, w, h) {
                    if (drawArea.width < w) drawArea.width = w;
                    if (drawArea.height < h) drawArea.height = h;

                    switch (pos) {
                        case "left":
                            element.style.left = drawArea.left + "px";
                            element.style.top = drawArea.top + drawArea.height / 2 - h / 2 + "px";;
                            break;
                        case "topLeft":
                            element.style.left = drawArea.left + "px";
                            element.style.top = drawArea.top + "px";
                            break;
                        case "bottomLeft":
                            element.style.left = drawArea.left + "px";
                            element.style.top = drawArea.top + drawArea.height - h + "px";
                            break;
                        default:
                        case "center":
                            element.style.left = drawArea.left + drawArea.width / 2 - w / 2 + "px";
                            element.style.top = drawArea.top + drawArea.height / 2 - h / 2 + "px";
                            break;
                        case "top":
                            element.style.left = drawArea.left + drawArea.width / 2 - w / 2 + "px";
                            element.style.top = drawArea.top + "px";
                            break;
                        case "bottom":
                            element.style.left = drawArea.left + drawArea.width / 2 - w / 2 + "px";
                            element.style.top = drawArea.top + drawArea.height - h + "px";
                            break;
                        case "right":
                            element.style.left = drawArea.left + drawArea.width - w + "px";
                            element.style.top = drawArea.top + drawArea.height / 2 - h / 2 + "px";;
                            break;
                        case "topRight":
                            element.style.left = drawArea.left + drawArea.width - w + "px";
                            element.style.top = drawArea.top + "px";
                            break;
                        case "bottomRight":
                            element.style.left = drawArea.left + drawArea.width - w + "px";
                            element.style.top = drawArea.top + drawArea.height - h + "px";
                            break;
                    }
                }

                var left = 0;
                var top = 0;
                var right = width;
                var bottom = height;
                var middle = (right - left) / 2;
                var center = (bottom - top) / 2;
                var img = that._img;
                var text = that._text;
                var rectHeight = bottom - top;
                var rectWidth = right - left;
                left += edgeOffset;
                top += edgeOffset;
                right = right - edgeOffset - 2;
                rectWidth = rectWidth - 2 * edgeOffset - 2;
                rectHeight = rectHeight - 2 * edgeOffset - 2;

                switch (that.textImageRelation) {
                    case "imageBeforeText":

                        switch (that.imgPosition) {
                            case "left":
                            case "topLeft":
                            case "bottomLeft":
                                imageRect = { left: left, top: top, width: left + imgWidth, height: rectHeight };
                                textRect = { left: left + imgWidth + offset, top: top, width: rectWidth - imgWidth - offset, height: rectHeight };
                                break;
                            case "center":
                            case "top":
                            case "bottom":
                                imageRect = { left: middle - textWidth / 2 - imgWidth / 2 - offset / 2, top: top, width: imgWidth, height: rectHeight };
                                textRect = { left: imageRect.left + imgWidth + offset, top: top, width: right - imageRect.left - imgWidth - offset, height: rectHeight };
                                break;
                            case "right":
                            case "topRight":
                            case "bottomRight":
                                imageRect = { left: right - textWidth - imgWidth - offset, top: top, width: imgWidth, height: rectHeight };
                                textRect = { left: imageRect.left + imgWidth + offset, top: top, width: right - imageRect.left - imgWidth - offset, height: rectHeight };
                                break;

                        }
                        drawElement(img, imageRect, that.imgPosition, imgWidth, imgHeight);
                        drawElement(text, textRect, that.textPosition, textWidth, textHeight);

                        break;
                    case "textBeforeImage":

                        switch (that.textPosition) {
                            case "left":
                            case "topLeft":
                            case "bottomLeft":
                                textRect = { left: left, top: top, width: left + textWidth, height: rectHeight };
                                imageRect = { left: left + textWidth + offset, top: top, width: rectWidth - textWidth - offset, height: rectHeight };
                                break;
                            case "center":
                            case "top":
                            case "bottom":
                                textRect = { left: middle - textWidth / 2 - imgWidth / 2 - offset / 2, top: top, width: textWidth, height: rectHeight };
                                imageRect = { left: textRect.left + textWidth + offset, top: top, width: right - textRect.left - textWidth - offset, height: rectHeight };
                                break;
                            case "right":
                            case "topRight":
                            case "bottomRight":
                                textRect = { left: right - textWidth - imgWidth - offset, top: top, width: textWidth, height: rectHeight };
                                imageRect = { left: textRect.left + textWidth + offset, top: top, width: right - textRect.left - textWidth - offset, height: rectHeight };
                                break;

                        }
                        drawElement(img, imageRect, that.imgPosition, imgWidth, imgHeight);
                        drawElement(text, textRect, that.textPosition, textWidth, textHeight);

                        break;
                    case "imageAboveText":

                        switch (that.imgPosition) {
                            case "topRight":
                            case "top":
                            case "topLeft":
                                imageRect = { left: left, top: top, width: rectWidth, height: imgHeight };
                                textRect = { left: left, top: top + imgHeight + offset, width: rectWidth, height: rectHeight - imgHeight - offset };
                                break;
                            case "left":
                            case "center":
                            case "right":
                                imageRect = { left: left, top: center - imgHeight / 2 - textHeight / 2 - offset / 2, width: rectWidth, height: imgHeight };
                                textRect = { left: left, top: imageRect.top + offset + imgHeight, width: rectWidth, height: rectHeight - imageRect.top - offset - imgHeight };
                                break;
                            case "bottomLeft":
                            case "bottom":
                            case "bottomRight":
                                imageRect = { left: left, top: bottom - imgHeight - textHeight - offset, width: rectWidth, height: imgHeight };
                                textRect = { left: left, top: imageRect.top + offset + imgHeight, width: rectWidth, height: textHeight };
                                break;

                        }
                        drawElement(img, imageRect, that.imgPosition, imgWidth, imgHeight);
                        drawElement(text, textRect, that.textPosition, textWidth, textHeight);
                        break;
                    case "textAboveImage":
                        switch (that.textPosition) {
                            case "topRight":
                            case "top":
                            case "topLeft":
                                textRect = { left: left, top: top, width: rectWidth, height: textHeight };
                                imageRect = { left: left, top: top + textHeight + offset, width: rectWidth, height: rectHeight - textHeight - offset };
                                break;
                            case "left":
                            case "center":
                            case "right":
                                textRect = { left: left, top: center - imgHeight / 2 - textHeight / 2 - offset / 2, width: rectWidth, height: textHeight };
                                imageRect = { left: left, top: textRect.top + offset + textHeight, width: rectWidth, height: rectHeight - textRect.top - offset - textHeight };
                                break;
                            case "bottomLeft":
                            case "bottom":
                            case "bottomRight":
                                textRect = { left: left, top: bottom - imgHeight - textHeight - offset, width: rectWidth, height: textHeight };
                                imageRect = { left: left, top: textRect.top + offset + textHeight, width: rectWidth, height: imgHeight };
                                break;

                        }
                        drawElement(img, imageRect, that.imgPosition, imgWidth, imgHeight);
                        drawElement(text, textRect, that.textPosition, textWidth, textHeight);

                        break;
                    case "overlay":
                    default:
                        textRect = { left: left, top: top, width: rectWidth, height: rectHeight };
                        imageRect = { left: left, top: top, width: rectWidth, height: rectHeight };

                        drawElement(img, imageRect, that.imgPosition, imgWidth, imgHeight);
                        drawElement(text, textRect, that.textPosition, textWidth, textHeight);

                        break;
                }
            },

            createInstance: function (args) {
                var that = this;
                that._setSize();

                var isMaterial = that.isMaterialized();

                that.buttonObj = new $(that.element);

                if (that.imgSrc != "" || that.textPosition != "" || (that.element.value && that.element.value.indexOf("<") >= 0) || that.value != null) {
                    that.refresh();
                    that._addImage("jqxButton");
                    that.buttonObj = new $(that.element);
                }

                if (!that._ariaDisabled) {
                    that.element.setAttribute('role', 'button');
                }
                if (that.type !== '') {
                    that.element.setAttribute('type', that.type);
                }
                if (!that.overrideTheme) {
                    that.buttonObj.addClass(that.toThemeProperty($.jqx.cssroundedcorners(that.roundedCorners)));
                    if (that.enableDefault) {
                        that.buttonObj.addClass(that.toThemeProperty('jqx-button'));
                    }
                    that.buttonObj.addClass(that.toThemeProperty('jqx-widget'));
                }

                that.isTouchDevice = $.jqx.mobile.isTouchDevice();
                if (!that._ariaDisabled) {
                    $.jqx.aria(this);
                }

                if (that.cursor != 'arrow') {
                    if (!that.disabled) {
                        that.element.style.cursor = that.cursor;
                    }
                    else {
                        that.element.style.cursor = "arrow";
                    }
                }

                var eventNames = 'mouseenter mouseleave mousedown focus blur';
                if (that._scrollAreaButton) {
                    var eventNames = 'mousedown';
                }

                if (that.isTouchDevice) {
                    that.addHandler(that.host, $.jqx.mobile.getTouchEventName('touchstart'), function (event) {
                        that.isPressed = true;
                        that.refresh();
                    });
                    that.addHandler($(document), $.jqx.mobile.getTouchEventName('touchend') + "." + that.element.id, function (event) {
                        that.isPressed = false;
                        that.refresh();
                    });
                }

                that.addHandler(that.host, eventNames, function (event) {
                    switch (event.type) {
                        case 'mouseenter':
                            if (!that.isTouchDevice) {
                                if (!that.disabled && that.enableHover) {
                                    that.isMouseOver = true;
                                    that.refresh();
                                }
                            }
                            break;
                        case 'mouseleave':
                            if (!that.isTouchDevice) {
                                if (!that.disabled && that.enableHover) {
                                    that.isMouseOver = false;
                                    that.refresh();
                                }
                            }
                            break;
                        case 'mousedown':
                            if (!that.disabled) {
                                that.isPressed = true;
                                that.refresh();
                            }
                            break;
                        case 'focus':
                            if (!that.disabled) {
                                that.isFocused = true;
                                that.refresh();
                            }
                            break;
                        case 'blur':
                            if (!that.disabled) {
                                that.isFocused = false;
                                that.refresh();
                            }
                            break;
                    }
                });

                that.mouseupfunc = function (event) {
                    if (!that.disabled) {
                        if (that.isPressed || that.isMouseOver) {
                            that.isPressed = false;
                            that.refresh();
                        }
                    }
                }

                that.addHandler(document, 'mouseup.button' + that.element.id, that.mouseupfunc);

                try {
                    if (document.referrer != "" || window.frameElement) {
                        if (window.top != null && window.top != window.that) {
                            var parentLocation = '';
                            if (window.parent && document.referrer) {
                                parentLocation = document.referrer;
                            }

                            if (parentLocation.indexOf(document.location.host) != -1) {
                                if (window.top.document) {
                                    window.top.document.addEventListener('mouseup', that._topDocumentMouseupHandler);
                                }
                            }
                        }
                    }
                }
                catch (error) {
                }

                that.propertyChangeMap['roundedCorners'] = function (instance, key, oldVal, value) {
                    instance.buttonObj.removeClass(instance.toThemeProperty($.jqx.cssroundedcorners(oldVal)));
                    instance.buttonObj.addClass(instance.toThemeProperty($.jqx.cssroundedcorners(value)));
                };
                that.propertyChangeMap['disabled'] = function (instance, key, oldVal, value) {
                    if (oldVal != value) {
                        instance.refresh();
                        instance.element.setAttribute('disabled', value);
                        instance.element.disabled = value;
                        if (!value) {
                            instance.element.style.cursor = instance.cursor;
                        }
                        else {
                            instance.element.style.cursor = 'default';
                        }

                        $.jqx.aria(instance, "aria-disabled", instance.disabled);
                    }
                };
                that.propertyChangeMap['rtl'] = function (instance, key, oldVal, value) {
                    if (oldVal != value) {
                        instance.refresh();
                    }
                };
                that.propertyChangeMap['template'] = function (instance, key, oldVal, value) {
                    if (oldVal != value) {
                        instance.buttonObj.removeClass(instance.toThemeProperty("jqx-" + oldVal));
                        instance.refresh();
                    }
                };
                that.propertyChangeMap['theme'] = function (instance, key, oldVal, value) {
                    instance.buttonObj.removeClass(instance.element);

                    if (oldVal) {
                        instance.buttonObj.removeClass('jqx-button-' + oldVal);
                        instance.buttonObj.removeClass('jqx-widget-' + oldVal);
                        instance.buttonObj.removeClass('jqx-fill-state-normal-' + oldVal);
                        instance.buttonObj.removeClass(instance.toThemeProperty($.jqx.cssroundedcorners(instance.roundedCorners)) + '-' + oldVal);
                    }

                    if (instance.enableDefault) {
                        instance.buttonObj.addClass(instance.toThemeProperty('jqx-button'));
                    }
                    instance.buttonObj.addClass(instance.toThemeProperty('jqx-widget'));
                    if (!instance.overrideTheme) {
                        instance.buttonObj.addClass(instance.toThemeProperty($.jqx.cssroundedcorners(instance.roundedCorners)));
                    }
                    instance._oldCSSCurrent = null;
                    instance.refresh();
                };

                if (that.disabled) {
                    that.element.disabled = true;
                    that.element.setAttribute('disabled', 'true');
                }

                if (that.textPosition) {
                    $.jqx.utilities.resize(this.host, function () {
                        that._positionTextAndImage();
                    });
                }
            }, // createInstance

            resize: function (width, height) {
                this.width = width;
                this.height = height;
                this._setSize();
            },

            val: function (value) {
                var that = this;
                var input = that.host.find('input');
                if (input.length > 0) {
                    if (arguments.length == 0 || typeof (value) == "object") {
                        return input.val();
                    }
                    input.val(value);
                    that.refresh();
                    return input.val();
                }

                if (arguments.length == 0 || typeof (value) == "object") {
                    if (that.element.nodeName.toLowerCase() == "button") {
                        return $(that.element).text();
                    }
                    return that.element.value;
                }

                if (arguments.length > 0 && that._text) {
                    that._text.innerHTML = arguments[0];
                    that.refresh();

                    return;
                }
                else if (arguments.length > 0 && that.element.nodeName === 'DIV') {
                    that.element.innerHTML = arguments[0];
                    that.refresh();
                }

                that.element.value = arguments[0];
                if (that.element.nodeName.toLowerCase() == "button") {
                    $(that.element).html(arguments[0]);
                }

                that.refresh();
            },

            _setSize: function () {
                var that = this;
                var height = that.height;
                var width = that.width;

                if (height) {
                    if (!isNaN(height)) {
                        height = height + "px";
                    }
                    that.element.style.height = height;
                }

                if (width) {
                    if (!isNaN(width)) {
                        width = width + "px";
                    }
                    that.element.style.width = width;
                }
            },

            _removeHandlers: function () {
                var that = this;
                that.removeHandler(that.host, 'selectstart');
                that.removeHandler(that.host, 'click');
                that.removeHandler(that.host, 'focus');
                that.removeHandler(that.host, 'blur');
                that.removeHandler(that.host, 'mouseenter');
                that.removeHandler(that.host, 'mouseleave');
                that.removeHandler(that.host, 'mousedown');
                that.removeHandler($(document), 'mouseup.button' + that.element.id, that.mouseupfunc);
                if (that.isTouchDevice) {
                    that.removeHandler(that.host, $.jqx.mobile.getTouchEventName('touchstart'));
                    that.removeHandler($(document), $.jqx.mobile.getTouchEventName('touchend') + "." + that.element.id);
                }
                that.mouseupfunc = null;
                delete that.mouseupfunc;
            },

            focus: function () {
                this.host.focus();
            },

            destroy: function () {
                var that = this;
                that._removeHandlers();
                var vars = $.data(that.element, "jqxButton");
                if (vars) {
                    delete vars.instance;
                }
                that.host.removeClass();
                that.host.removeData();
                that.host.remove();
                delete that.set;
                delete that.get;
                delete that.call;
                delete that.element;
                delete that.host;
            },

            render: function () {
                this.refresh();
            },

            propertiesChangedHandler: function (object, oldValues, newValues) {
                if (newValues && newValues.width && newValues.height && Object.keys(newValues).length == 2) {
                    object._setSize();
                    object.refresh();
                }
            },

            propertyChangedHandler: function (object, key, oldvalue, value) {
                if (this.isInitialized == undefined || this.isInitialized == false)
                    return;

                if (value == oldvalue) {
                    return;
                }

                if (object.batchUpdate && object.batchUpdate.width && object.batchUpdate.height && Object.keys(object.batchUpdate).length == 2) {
                    return;
                }

                if (key === "type") {
                    object.element.setAttribute('type', value);
                }
                if (key == "textImageRelation" || key == "textPosition" || key == "imgPosition") {
                    if (object._img) {
                        object._positionTextAndImage();
                    }
                    else object._addImage("jqxButton");
                }
                if (key == "imgSrc" || key == "imgWidth" || key == "imgHeight") {
                    object._addImage("jqxButton");
                }

                if (key === "value") {
                    object.val(value);
                }

                if (key == "width" || key == "height") {
                    object._setSize();
                    object.refresh();
                }
            },

            refresh: function () {
                var that = this;
                if (that.overrideTheme)
                    return;

                var cssFocused = that.toThemeProperty('jqx-fill-state-focus');
                var cssDisabled = that.toThemeProperty('jqx-fill-state-disabled');
                var cssNormal = that.toThemeProperty('jqx-fill-state-normal');

                if (!that.enableDefault) {
                    cssNormal = "";
                }

                var cssHover = that.toThemeProperty('jqx-fill-state-hover');
                var cssPressed = that.toThemeProperty('jqx-fill-state-pressed');
                var cssPressedHover = that.toThemeProperty('jqx-fill-state-pressed');
                if (!that.enablePressed) {
                    cssPressed = "";
                }
                var cssCurrent = '';

                if (!that.host) {
                    return;
                }

                that.element.disabled = that.disabled;

                if (that.disabled) {
                    if (that._oldCSSCurrent) {
                        that.buttonObj.removeClass(that._oldCSSCurrent);
                    }
                    cssCurrent = cssNormal + " " + cssDisabled;
                    if (that.template !== "default" && that.template !== "") {
                        cssCurrent += " " + "jqx-" + that.template;
                        if (that.theme != "") {
                            cssCurrent += " " + "jqx-" + that.template + "-" + that.theme;
                        }
                    }
                    that.buttonObj.addClass(cssCurrent);
                    that._oldCSSCurrent = cssCurrent;
                    return;
                }
                else {
                    if (that.isMouseOver && !that.isTouchDevice) {
                        if (that.isPressed)
                            cssCurrent = cssPressedHover;
                        else
                            cssCurrent = cssHover;
                    }
                    else {
                        if (that.isPressed)
                            cssCurrent = cssPressed;
                        else
                            cssCurrent = cssNormal;
                    }
                }

                if (that.isFocused) {
                    cssCurrent += " " + cssFocused;
                }

                if (that.template !== "default" && that.template !== "") {
                    cssCurrent += " " + "jqx-" + that.template;
                    if (that.theme != "") {
                        cssCurrent += " " + "jqx-" + that.template + "-" + that.theme;
                    }
                }

                if (cssCurrent != that._oldCSSCurrent) {
                    if (that._oldCSSCurrent) {
                        that.buttonObj.removeClass(that._oldCSSCurrent);
                    }
                    that.buttonObj.addClass(cssCurrent);
                    that._oldCSSCurrent = cssCurrent;
                }
                if (that.rtl) {
                    that.buttonObj.addClass(that.toThemeProperty('jqx-rtl'));
                    that.element.style.direction = 'rtl';
                }


                if (that.isMaterialized()) {
                    that.host.addClass('buttonRipple');
                }
            }
        });

        //// LinkButton
        $.jqx.jqxWidget("jqxLinkButton", "", {});

        $.extend($.jqx._jqxLinkButton.prototype, {
            defineInstance: function () {
                // enables / disables the button
                this.disabled = false;
                // sets height to the button.
                this.height = null;
                // sets width to the button.
                this.width = null;
                this.rtl = false;
                this.href = null;
            },

            createInstance: function (args) {
                var that = this;
                this.host.onselectstart = function () { return false; };
                this.host.attr('role', 'button');

                var height = this.height || this.element.offsetHeight;
                var width = this.width || this.element.offsetWidth;
                this.href = this.element.getAttribute('href');
                this.target = this.element.getAttribute('target');
                this.content = this.host.text();
                this.element.innerHTML = "";
                var wrapElement = document.createElement('input');
                wrapElement.type = "button";
                wrapElement.className = "jqx-wrapper " + this.toThemeProperty('jqx-reset');

                this._setSize(wrapElement, width, height);

                wrapElement.value = this.content;
                var helper = new $(this.element);
                helper.addClass(this.toThemeProperty('jqx-link'));
                this.element.style.color = 'inherit';
                this.element.appendChild(wrapElement);
                this._setSize(wrapElement, width, height);

                var param = args == undefined ? {} : args[0] || {};
                $(wrapElement).jqxButton(param);
                this.wrapElement = wrapElement;
                if (this.disabled) {
                    this.element.disabled = true;
                }

                this.propertyChangeMap['disabled'] = function (instance, key, oldVal, value) {
                    instance.element.disabled = value;
                    instance.wrapElement.jqxButton({ disabled: value });
                }

                this.addHandler($(wrapElement), 'click', function (event) {
                    if (!this.disabled) {
                        that.onclick(event);
                    }
                    return false;
                });
            },

            _setSize: function (element, width, height) {
                var that = this;

                if (height) {
                    if (!isNaN(height)) {
                        height = height + "px";
                    }
                    element.style.height = height;
                }

                if (width) {
                    if (!isNaN(width)) {
                        width = width + "px";
                    }
                    element.style.width = width;
                }
            },


            onclick: function (event) {
                if (this.target != null) {
                    window.open(this.href, this.target);
                }
                else {
                    window.location = this.href;
                }
            }
        });
        //// End of LinkButton

        //// RepeatButton
        $.jqx.jqxWidget("jqxRepeatButton", "jqxButton", {});

        $.extend($.jqx._jqxRepeatButton.prototype, {
            defineInstance: function () {
                this.delay = 50;
            },

            createInstance: function (args) {
                var that = this;

                var isTouchDevice = $.jqx.mobile.isTouchDevice();

                var up = !isTouchDevice ? 'mouseup.' + this.base.element.id : 'touchend.' + this.base.element.id;
                var down = !isTouchDevice ? 'mousedown.' + this.base.element.id : 'touchstart.' + this.base.element.id;

                this.addHandler($(document), up, function (event) {
                    if (that.timeout != null) {
                        clearTimeout(that.timeout);
                        that.timeout = null;
                        that.refresh();
                    }
                    if (that.timer != undefined) {
                        clearInterval(that.timer);
                        that.timer = null;
                        that.refresh();
                    }
                });

                this.addHandler(this.base.host, down, function (event) {
                    if (that.timer != null) {
                        clearInterval(that.timer);
                    }

                    that.timeout = setTimeout(function () {
                        clearInterval(that.timer);
                        that.timer = setInterval(function (event) { that.ontimer(event); }, that.delay);
                    }, 150);
                });

                this.mousemovefunc = function (event) {
                    if (!isTouchDevice) {
                        if (event.which == 0) {
                            if (that.timer != null) {
                                clearInterval(that.timer);
                                that.timer = null;
                            }
                        }
                    }
                }

                this.addHandler(this.base.host, 'mousemove', this.mousemovefunc);
            },

            destroy: function () {
                var isTouchDevice = $.jqx.mobile.isTouchDevice();
                var up = !isTouchDevice ? 'mouseup.' + this.base.element.id : 'touchend.' + this.base.element.id;
                var down = !isTouchDevice ? 'mousedown.' + this.base.element.id : 'touchstart.' + this.base.element.id;
                this.removeHandler(this.base.host, 'mousemove', this.mousemovefunc);
                this.removeHandler(this.base.host, down);
                this.removeHandler($(document), up);
                this.timer = null;
                delete this.mousemovefunc;
                delete this.timer;
                var vars = $.data(this.base.element, "jqxRepeatButton");
                if (vars) {
                    delete vars.instance;
                }
                $(this.base.element).removeData();
                this.base.destroy();
                delete this.base;

            },

            stop: function () {
                clearInterval(this.timer);
                this.timer = null;
            },

            ontimer: function (event) {
                var event = new $.Event('click');
                if (this.base != null && this.base.host != null) {
                    this.base.host.trigger(event);
                }
            }
        });
        //// End of RepeatButton
        //// ToggleButton
        $.jqx.jqxWidget("jqxToggleButton", "jqxButton", {});

        $.extend($.jqx._jqxToggleButton.prototype, {
            defineInstance: function () {
                this.toggled = false;
                this.uiToggle = true;
                this.aria =
                {
                    "aria-checked": { name: "toggled", type: "boolean" },
                    "aria-disabled": { name: "disabled", type: "boolean" }
                };
            },

            createInstance: function (args) {
                var that = this;
                that.base.overrideTheme = true;
                that.isTouchDevice = $.jqx.mobile.isTouchDevice();
                $.jqx.aria(this);
                that.base.host.attr('role', 'checkbox');

                that.propertyChangeMap['roundedCorners'] = function (instance, key, oldVal, value) {
                    instance.base.buttonObj.removeClass(instance.toThemeProperty($.jqx.cssroundedcorners(oldVal)));
                    instance.base.buttonObj.addClass(instance.toThemeProperty($.jqx.cssroundedcorners(value)));
                };

                that.propertyChangeMap['toggled'] = function (instance, key, oldVal, value) {
                    instance.refresh();
                };
                that.propertyChangeMap['disabled'] = function (instance, key, oldVal, value) {
                    instance.base.disabled = value;
                    instance.refresh();
                };

                that.addHandler(that.base.host, 'click', function (event) {
                    if (!that.base.disabled && that.uiToggle) {
                        that.toggle();
                    }
                });

                if (!that.isTouchDevice) {
                    that.addHandler(that.base.host, 'mouseenter', function (event) {
                        if (!that.base.disabled) {
                            that.refresh();
                        }
                    });

                    that.addHandler(that.base.host, 'mouseleave', function (event) {
                        if (!that.base.disabled) {
                            that.refresh();
                        }
                    });
                }

                that.addHandler(that.base.host, 'mousedown', function (event) {
                    if (!that.base.disabled) {
                        that.refresh();
                    }
                });

                that.addHandler($(document), 'mouseup.togglebutton' + that.base.element.id, function (event) {
                    if (!that.base.disabled) {
                        that.refresh();
                    }
                });
            },

            destroy: function () {
                this._removeHandlers();
                this.base.destroy();
            },

            _removeHandlers: function () {
                this.removeHandler(this.base.host, 'click');
                this.removeHandler(this.base.host, 'mouseenter');
                this.removeHandler(this.base.host, 'mouseleave');
                this.removeHandler(this.base.host, 'mousedown');
                this.removeHandler($(document), 'mouseup.togglebutton' + this.base.element.id);
            },

            toggle: function () {
                this.toggled = !this.toggled;
                this.refresh();
                $.jqx.aria(this, "aria-checked", this.toggled);
            },

            unCheck: function () {
                this.toggled = false;
                this.refresh();
            },

            check: function () {
                this.toggled = true;
                this.refresh();
            },

            refresh: function () {
                var that = this;
                var cssDisabled = that.base.toThemeProperty('jqx-fill-state-disabled');
                var cssNormal = that.base.toThemeProperty('jqx-fill-state-normal');
                if (!that.base.enableDefault) {
                    cssNormal = "";
                }
                var cssHover = that.base.toThemeProperty('jqx-fill-state-hover');
                var cssPressed = that.base.toThemeProperty('jqx-fill-state-pressed');
                var cssPressedHover = that.base.toThemeProperty('jqx-fill-state-pressed');
                var cssCurrent = '';
                that.base.element.disabled = that.base.disabled;

                if (that.base.disabled) {
                    cssCurrent = cssNormal + " " + cssDisabled;
                    that.base.buttonObj.addClass(cssCurrent);
                    return;
                }
                else {
                    if (that.base.isMouseOver && !that.isTouchDevice) {
                        if (that.base.isPressed || that.toggled)
                            cssCurrent = cssPressedHover;
                        else
                            cssCurrent = cssHover;
                    }
                    else {
                        if (that.base.isPressed || that.toggled)
                            cssCurrent = cssPressed;
                        else
                            cssCurrent = cssNormal;
                    }
                }

                if (that.base.template !== "default" && that.base.template !== "") {
                    cssCurrent += " " + "jqx-" + that.base.template;
                    if (that.base.theme != "") {
                        cssCurrent += " " + "jqx-" + that.template + "-" + that.base.theme;
                    }
                }

                if (that.base.buttonObj.hasClass(cssDisabled) && cssDisabled != cssCurrent) {
                    that.base.buttonObj.removeClass(cssDisabled);
                }

                if (that.base.buttonObj.hasClass(cssNormal) && cssNormal != cssCurrent) {
                    that.base.buttonObj.removeClass(cssNormal);
                }

                if (that.base.buttonObj.hasClass(cssHover) && cssHover != cssCurrent) {
                    that.base.buttonObj.removeClass(cssHover);
                }

                if (that.base.buttonObj.hasClass(cssPressed) && cssPressed != cssCurrent) {
                    that.base.buttonObj.removeClass(cssPressed);
                }

                if (that.base.buttonObj.hasClass(cssPressedHover) && cssPressedHover != cssCurrent) {
                    that.base.buttonObj.removeClass(cssPressedHover);
                }

                if (!that.base.buttonObj.hasClass(cssCurrent)) {
                    that.base.buttonObj.addClass(cssCurrent);
                }
            },

            _topDocumentMouseupHandler: function (event) {
                var that = this;
                that.isPressed = false;
                that.refresh();
            }
        });
        //// End of ToggleButton

    })(jqxBaseFramework);
})();



/***/ }),

/***/ 5459:
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/* tslint:disable */
/* eslint-disable */
(function(){
	if (typeof document === 'undefined') { 
		return;
	}
		
	var oldBrowser = document.all && !document.addEventListener;
	if (!oldBrowser) {
		(function (window, undefined) {
			var
				rootJQXLite,
				readyList,
				document = window.document,
				location = window.location,
				navigator = window.navigator,
				_JQXLite = window.JQXLite,
				_$ = window.$,

				// Save a reference to some core methods
				core_push = Array.prototype.push,
				core_slice = Array.prototype.slice,
				core_indexOf = Array.prototype.indexOf,
				core_toString = Object.prototype.toString,
				core_hasOwn = Object.prototype.hasOwnProperty,
				core_trim = String.prototype.trim,

				// Define a local copy of JQXLite
				JQXLite = function (selector, context) {
					// The JQXLite object is actually just the init constructor 'enhanced'
					return new JQXLite.fn.init(selector, context, rootJQXLite);
				},

				// Used for matching numbers
				core_pnum = /[\-+]?(?:\d*\.|)\d+(?:[eE][\-+]?\d+|)/.source,

				// Used for detecting and trimming whitespace
				core_rnotwhite = /\S/,
				core_rspace = /\s+/,

				// Make sure we trim BOM and NBSP (here's looking at you, Safari 5.0 and IE)
				rtrim = /^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,

				// A simple way to check for HTML strings
				// Prioritize #id over <tag> to avoid XSS via location.hash (#9521)
				rquickExpr = /^(?:[^#<]*(<[\w\W]+>)[^>]*$|#([\w\-]*)$)/,

				// Match a standalone tag
				rsingleTag = /^<(\w+)\s*\/?>(?:<\/\1>|)$/,

				// JSON RegExp
				rvalidchars = /^[\],:{}\s]*$/,
				rvalidbraces = /(?:^|:|,)(?:\s*\[)+/g,
				rvalidescape = /\\(?:["\\\/bfnrt]|u[\da-fA-F]{4})/g,
				rvalidtokens = /"[^"\\\r\n]*"|true|false|null|-?(?:\d\d*\.|)\d+(?:[eE][\-+]?\d+|)/g,

				// Matches dashed string for camelizing
				rmsPrefix = /^-ms-/,
				rdashAlpha = /-([\da-z])/gi,

				// Used by JQXLite.camelCase as callback to replace()
				fcamelCase = function (all, letter) {
					return (letter + "").toUpperCase();
				},

				// The ready event handler and self cleanup method
				DOMContentLoaded = function () {
					if (document.addEventListener) {
						document.removeEventListener("DOMContentLoaded", DOMContentLoaded, false);
						JQXLite.ready();
					} else if (document.readyState === "complete") {
						// we're here because readyState === "complete" in oldIE
						// which is good enough for us to call the dom ready!
						document.detachEvent("onreadystatechange", DOMContentLoaded);
						JQXLite.ready();
					}
				},

				// [[Class]] -> type pairs
				class2type = {};

			JQXLite.fn = JQXLite.prototype = {
				constructor: JQXLite,
				init: function (selector, context, rootJQXLite) {
					var match, elem, ret, doc;

					// Handle $(""), $(null), $(undefined), $(false)
					if (!selector) {
						return this;
					}

					// Handle $(DOMElement)
					if (selector.nodeType) {
						this.context = this[0] = selector;
						this.length = 1;
						return this;
					}

					// Handle HTML strings
					if (typeof selector === "string") {
						if (selector.charAt(0) === "<" && selector.charAt(selector.length - 1) === ">" && selector.length >= 3) {
							// Assume that strings that start and end with <> are HTML and skip the regex check
							match = [null, selector, null];

						} else {
							match = rquickExpr.exec(selector);
						}

						// Match html or make sure no context is specified for #id
						if (match && (match[1] || !context)) {

							// HANDLE: $(html) -> $(array)
							if (match[1]) {
								context = context instanceof JQXLite ? context[0] : context;
								doc = (context && context.nodeType ? context.ownerDocument || context : document);

								// scripts is true for back-compat
								selector = JQXLite.parseHTML(match[1], doc, true);
								if (rsingleTag.test(match[1]) && JQXLite.isPlainObject(context)) {
									this.attr.call(selector, context, true);
								}

								return JQXLite.merge(this, selector);

								// HANDLE: $(#id)
							} else {
								elem = document.getElementById(match[2]);

								// Check parentNode to catch when Blackberry 4.6 returns
								// nodes that are no longer in the document #6963
								if (elem && elem.parentNode) {
									// Handle the case where IE and Opera return items
									// by name instead of ID
									if (elem.id !== match[2]) {
										return rootJQXLite.find(selector);
									}

									// Otherwise, we inject the element directly into the JQXLite object
									this.length = 1;
									this[0] = elem;
								}

								this.context = document;
								this.selector = selector;
								return this;
							}

							// HANDLE: $(expr, $(...))
						} else if (!context || context.jqx) {
							return (context || rootJQXLite).find(selector);

							// HANDLE: $(expr, context)
							// (which is just equivalent to: $(context).find(expr)
						} else {
							return this.constructor(context).find(selector);
						}

						// HANDLE: $(function)
						// Shortcut for document ready
					} else if (JQXLite.isFunction(selector)) {
						return rootJQXLite.ready(selector);
					}

					if (selector.selector !== undefined) {
						this.selector = selector.selector;
						this.context = selector.context;
					}

					return JQXLite.makeArray(selector, this);
				},

				// Start with an empty selector
				selector: "",

				// The current version of JQXLite being used
				jqx: "4.5.0",

				// The default length of a JQXLite object is 0
				length: 0,

				// The number of elements contained in the matched element set
				size: function () {
					return this.length;
				},

				toArray: function () {
					return core_slice.call(this);
				},

				// Get the Nth element in the matched element set OR
				// Get the whole matched element set as a clean array
				get: function (num) {
					return num == null ?

						// Return a 'clean' array
						this.toArray() :

						// Return just the object
						(num < 0 ? this[this.length + num] : this[num]);
				},

				// Take an array of elements and push it onto the stack
				// (returning the new matched element set)
				pushStack: function (elems, name, selector) {

					// Build a new JQXLite matched element set
					var ret = JQXLite.merge(this.constructor(), elems);

					// Add the old object onto the stack (as a reference)
					ret.prevObject = this;

					ret.context = this.context;

					if (name === "find") {
						ret.selector = this.selector + (this.selector ? " " : "") + selector;
					} else if (name) {
						ret.selector = this.selector + "." + name + "(" + selector + ")";
					}

					// Return the newly-formed element set
					return ret;
				},

				// Execute a callback for every element in the matched set.
				// (You can seed the arguments with an array of args, but this is
				// only used internally.)
				each: function (callback, args) {
					return JQXLite.each(this, callback, args);
				},

				ready: function (fn) {
					// Add the callback
					JQXLite.ready.promise().done(fn);

					return this;
				},

				eq: function (i) {
					i = +i;
					return i === -1 ?
						this.slice(i) :
						this.slice(i, i + 1);
				},

				first: function () {
					return this.eq(0);
				},

				last: function () {
					return this.eq(-1);
				},

				slice: function () {
					return this.pushStack(core_slice.apply(this, arguments),
						"slice", core_slice.call(arguments).join(","));
				},

				map: function (callback) {
					return this.pushStack(JQXLite.map(this, function (elem, i) {
						return callback.call(elem, i, elem);
					}));
				},

				end: function () {
					return this.prevObject || this.constructor(null);
				},

				// For internal use only.
				// Behaves like an Array's method, not like a JQXLite method.
				push: core_push,
				sort: [].sort,
				splice: [].splice
			};

			// Give the init function the JQXLite prototype for later instantiation
			JQXLite.fn.init.prototype = JQXLite.fn;

			JQXLite.extend = JQXLite.fn.extend = function () {
				var options, name, src, copy, copyIsArray, clone,
					target = arguments[0] || {},
					i = 1,
					length = arguments.length,
					deep = false;

				// Handle a deep copy situation
				if (typeof target === "boolean") {
					deep = target;
					target = arguments[1] || {};
					// skip the boolean and the target
					i = 2;
				}

				// Handle case when target is a string or something (possible in deep copy)
				if (typeof target !== "object" && !JQXLite.isFunction(target)) {
					target = {};
				}

				// extend JQXLite itself if only one argument is passed
				if (length === i) {
					target = this;
					--i;
				}

				for (; i < length; i++) {
					// Only deal with non-null/undefined values
					if ((options = arguments[i]) != null) {
						// Extend the base object
						for (name in options) {
							src = target[name];
							copy = options[name];

							// Prevent never-ending loop
							if (target === copy) {
								continue;
							}

							// Recurse if we're merging plain objects or arrays
							if (deep && copy && (JQXLite.isPlainObject(copy) || (copyIsArray = JQXLite.isArray(copy)))) {
								if (copyIsArray) {
									copyIsArray = false;
									clone = src && JQXLite.isArray(src) ? src : [];

								} else {
									clone = src && JQXLite.isPlainObject(src) ? src : {};
								}

								// Never move original objects, clone them
								target[name] = JQXLite.extend(deep, clone, copy);

								// Don't bring in undefined values
							} else if (copy !== undefined) {
								target[name] = copy;
							}
						}
					}
				}

				// Return the modified object
				return target;
			};

			JQXLite.extend({
				noConflict: function (deep) {
					if (window.$ === JQXLite) {
						window.$ = _$;
					}

					if (deep && window.JQXLite === JQXLite) {
						window.JQXLite = _JQXLite;
					}

					return JQXLite;
				},

				// Is the DOM ready to be used? Set to true once it occurs.
				isReady: false,

				// A counter to track how many items to wait for before
				// the ready event fires. See #6781
				readyWait: 1,

				// Hold (or release) the ready event
				holdReady: function (hold) {
					if (hold) {
						JQXLite.readyWait++;
					} else {
						JQXLite.ready(true);
					}
				},

				// Handle when the DOM is ready
				ready: function (wait) {

					// Abort if there are pending holds or we're already ready
					if (wait === true ? --JQXLite.readyWait : JQXLite.isReady) {
						return;
					}

					// Make sure body exists, at least, in case IE gets a little overzealous (ticket #5443).
					if (!document.body) {
						return setTimeout(JQXLite.ready, 1);
					}

					// Remember that the DOM is ready
					JQXLite.isReady = true;

					// If a normal DOM Ready event fired, decrement, and wait if need be
					if (wait !== true && --JQXLite.readyWait > 0) {
						return;
					}

					// If there are functions bound, to execute
					readyList.resolveWith(document, [JQXLite]);

					// Trigger any bound ready events
					if (JQXLite.fn.trigger) {
						JQXLite(document).trigger("ready").off("ready");
					}
				},

				// See test/unit/core.js for details concerning isFunction.
				// Since version 1.3, DOM methods and functions like alert
				// aren't supported. They return false on IE (#2968).
				isFunction: function (obj) {
					return JQXLite.type(obj) === "function";
				},

				isArray: Array.isArray || function (obj) {
					return JQXLite.type(obj) === "array";
				},

				isWindow: function (obj) {
					return obj != null && obj == obj.window;
				},

				isNumeric: function (obj) {
					return !isNaN(parseFloat(obj)) && isFinite(obj);
				},

				type: function (obj) {
					return obj == null ?
						String(obj) :
						class2type[core_toString.call(obj)] || "object";
				},

				isPlainObject: function (obj) {
					// Must be an Object.
					// Because of IE, we also have to check the presence of the constructor property.
					// Make sure that DOM nodes and window objects don't pass through, as well
					if (!obj || JQXLite.type(obj) !== "object" || obj.nodeType || JQXLite.isWindow(obj)) {
						return false;
					}

					try {
						// Not own constructor property must be Object
						if (obj.constructor &&
							!core_hasOwn.call(obj, "constructor") &&
							!core_hasOwn.call(obj.constructor.prototype, "isPrototypeOf")) {
							return false;
						}
					} catch (e) {
						// IE8,9 Will throw exceptions on certain host objects #9897
						return false;
					}

					// Own properties are enumerated firstly, so to speed up,
					// if last one is own, then all properties are own.

					var key;
					for (key in obj) { }

					return key === undefined || core_hasOwn.call(obj, key);
				},

				isEmptyObject: function (obj) {
					var name;
					for (name in obj) {
						return false;
					}
					return true;
				},

				error: function (msg) {
					throw new Error(msg);
				},

				// data: string of html
				// context (optional): If specified, the fragment will be created in this context, defaults to document
				// scripts (optional): If true, will include scripts passed in the html string
				parseHTML: function (data, context, scripts) {
					var parsed;
					if (!data || typeof data !== "string") {
						return null;
					}
					if (typeof context === "boolean") {
						scripts = context;
						context = 0;
					}
					context = context || document;

					// Single tag
					if ((parsed = rsingleTag.exec(data))) {
						return [context.createElement(parsed[1])];
					}

					parsed = JQXLite.buildFragment([data], context, scripts ? null : []);
					return JQXLite.merge([],
						(parsed.cacheable ? JQXLite.clone(parsed.fragment) : parsed.fragment).childNodes);
				},

				parseJSON: function (data) {
					if (!data || typeof data !== "string") {
						return null;
					}

					// Make sure leading/trailing whitespace is removed (IE can't handle it)
					data = JQXLite.trim(data);

					// Attempt to parse using the native JSON parser first
					if (window.JSON && window.JSON.parse) {
						return window.JSON.parse(data);
					}

					// Make sure the incoming data is actual JSON
					// Logic borrowed from http://json.org/json2.js
					if (rvalidchars.test(data.replace(rvalidescape, "@")
						.replace(rvalidtokens, "]")
						.replace(rvalidbraces, ""))) {

						return (new Function("return " + data))();

					}
					JQXLite.error("Invalid JSON: " + data);
				},

				// Cross-browser xml parsing
				parseXML: function (data) {
					var xml, tmp;
					if (!data || typeof data !== "string") {
						return null;
					}
					try {
						if (window.DOMParser) { // Standard
							tmp = new DOMParser();
							xml = tmp.parseFromString(data, "text/xml");
						} else { // IE
							xml = new ActiveXObject("Microsoft.XMLDOM");
							xml.async = "false";
							xml.loadXML(data);
						}
					} catch (e) {
						xml = undefined;
					}
					if (!xml || !xml.documentElement || xml.getElementsByTagName("parsererror").length) {
						JQXLite.error("Invalid XML: " + data);
					}
					return xml;
				},

				noop: function () { },

				// Evaluates a script in a global context
				// Workarounds based on findings by Jim Driscoll
				// http://weblogs.java.net/blog/driscoll/archive/2009/09/08/eval-javascript-global-context
				globalEval: function (data) {
					if (data && core_rnotwhite.test(data)) {
						// We use execScript on Internet Explorer
						// We use an anonymous function so that context is window
						// rather than JQXLite in Firefox
						(window.execScript || function (data) {
							window["eval"].call(window, data);
						})(data);
					}
				},

				// Convert dashed to camelCase; used by the css and data modules
				// Microsoft forgot to hump their vendor prefix (#9572)
				camelCase: function (string) {
					return string.replace(rmsPrefix, "ms-").replace(rdashAlpha, fcamelCase);
				},

				nodeName: function (elem, name) {
					return elem.nodeName && elem.nodeName.toLowerCase() === name.toLowerCase();
				},

				// args is for internal usage only
				each: function (obj, callback, args) {
					var name,
						i = 0,
						length = obj.length,
						isObj = length === undefined || JQXLite.isFunction(obj);

					if (args) {
						if (isObj) {
							for (name in obj) {
								if (callback.apply(obj[name], args) === false) {
									break;
								}
							}
						} else {
							for (; i < length;) {
								if (callback.apply(obj[i++], args) === false) {
									break;
								}
							}
						}

						// A special, fast, case for the most common use of each
					} else {
						if (isObj) {
							for (name in obj) {
								if (callback.call(obj[name], name, obj[name]) === false) {
									break;
								}
							}
						} else {
							for (; i < length;) {
								if (callback.call(obj[i], i, obj[i++]) === false) {
									break;
								}
							}
						}
					}

					return obj;
				},

				// Use native String.trim function wherever possible
				trim: core_trim && !core_trim.call("\uFEFF\xA0") ?
					function (text) {
						return text == null ?
							"" :
							core_trim.call(text);
					} :

					// Otherwise use our own trimming functionality
					function (text) {
						return text == null ?
							"" :
							(text + "").replace(rtrim, "");
					},

				// results is for internal usage only
				makeArray: function (arr, results) {
					var type,
						ret = results || [];

					if (arr != null) {
						// The window, strings (and functions) also have 'length'
						// Tweaked logic slightly to handle Blackberry 4.7 RegExp issues #6930
						type = JQXLite.type(arr);

						if (arr.length == null || type === "string" || type === "function" || type === "regexp" || JQXLite.isWindow(arr)) {
							core_push.call(ret, arr);
						} else {
							JQXLite.merge(ret, arr);
						}
					}

					return ret;
				},

				inArray: function (elem, arr, i) {
					var len;

					if (arr) {
						if (core_indexOf) {
							return core_indexOf.call(arr, elem, i);
						}

						len = arr.length;
						i = i ? i < 0 ? Math.max(0, len + i) : i : 0;

						for (; i < len; i++) {
							// Skip accessing in sparse arrays
							if (i in arr && arr[i] === elem) {
								return i;
							}
						}
					}

					return -1;
				},

				merge: function (first, second) {
					var l = second.length,
						i = first.length,
						j = 0;

					if (typeof l === "number") {
						for (; j < l; j++) {
							first[i++] = second[j];
						}

					} else {
						while (second[j] !== undefined) {
							first[i++] = second[j++];
						}
					}

					first.length = i;

					return first;
				},

				grep: function (elems, callback, inv) {
					var retVal,
						ret = [],
						i = 0,
						length = elems.length;
					inv = !!inv;

					// Go through the array, only saving the items
					// that pass the validator function
					for (; i < length; i++) {
						retVal = !!callback(elems[i], i);
						if (inv !== retVal) {
							ret.push(elems[i]);
						}
					}

					return ret;
				},

				// arg is for internal usage only
				map: function (elems, callback, arg) {
					var value, key,
						ret = [],
						i = 0,
						length = elems.length,
						// jqx objects are treated as arrays
						isArray = elems instanceof JQXLite || length !== undefined && typeof length === "number" && ((length > 0 && elems[0] && elems[length - 1]) || length === 0 || JQXLite.isArray(elems));

					// Go through the array, translating each of the items to their
					if (isArray) {
						for (; i < length; i++) {
							value = callback(elems[i], i, arg);

							if (value != null) {
								ret[ret.length] = value;
							}
						}

						// Go through every key on the object,
					} else {
						for (key in elems) {
							value = callback(elems[key], key, arg);

							if (value != null) {
								ret[ret.length] = value;
							}
						}
					}

					// Flatten any nested arrays
					return ret.concat.apply([], ret);
				},

				// A global GUID counter for objects
				guid: 1,

				// Bind a function to a context, optionally partially applying any
				// arguments.
				proxy: function (fn, context) {
					var tmp, args, proxy;

					if (typeof context === "string") {
						tmp = fn[context];
						context = fn;
						fn = tmp;
					}

					// Quick check to determine if target is callable, in the spec
					// this throws a TypeError, but we will just return undefined.
					if (!JQXLite.isFunction(fn)) {
						return undefined;
					}

					// Simulated bind
					args = core_slice.call(arguments, 2);
					proxy = function () {
						return fn.apply(context, args.concat(core_slice.call(arguments)));
					};

					// Set the guid of unique handler to the same of original handler, so it can be removed
					proxy.guid = fn.guid = fn.guid || JQXLite.guid++;

					return proxy;
				},

				// Multifunctional method to get and set values of a collection
				// The value/s can optionally be executed if it's a function
				access: function (elems, fn, key, value, chainable, emptyGet, pass) {
					var exec,
						bulk = key == null,
						i = 0,
						length = elems.length;

					// Sets many values
					if (key && typeof key === "object") {
						for (i in key) {
							JQXLite.access(elems, fn, i, key[i], 1, emptyGet, value);
						}
						chainable = 1;

						// Sets one value
					} else if (value !== undefined) {
						// Optionally, function values get executed if exec is true
						exec = pass === undefined && JQXLite.isFunction(value);

						if (bulk) {
							// Bulk operations only iterate when executing function values
							if (exec) {
								exec = fn;
								fn = function (elem, key, value) {
									return exec.call(JQXLite(elem), value);
								};

								// Otherwise they run against the entire set
							} else {
								fn.call(elems, value);
								fn = null;
							}
						}

						if (fn) {
							for (; i < length; i++) {
								fn(elems[i], key, exec ? value.call(elems[i], i, fn(elems[i], key)) : value, pass);
							}
						}

						chainable = 1;
					}

					return chainable ?
						elems :

						// Gets
						bulk ?
							fn.call(elems) :
							length ? fn(elems[0], key) : emptyGet;
				},

				now: function () {
					return (new Date()).getTime();
				}
			});

			JQXLite.ready.promise = function (obj) {
				if (!readyList) {

					readyList = JQXLite.Deferred();

					// Catch cases where $(document).ready() is called after the browser event has already occurred.
					// we once tried to use readyState "interactive" here, but it caused issues like the one
					// discovered by ChrisS here: http://bugs.jqx.com/ticket/12282#comment:15
					if (document.readyState === "complete") {
						// Handle it asynchronously to allow scripts the opportunity to delay ready
						setTimeout(JQXLite.ready, 1);

						// Standards-based browsers support DOMContentLoaded
					} else if (document.addEventListener) {
						// Use the handy event callback
						document.addEventListener("DOMContentLoaded", DOMContentLoaded, false);

						// A fallback to window.onload, that will always work
						window.addEventListener("load", JQXLite.ready, false);

						// If IE event model is used
					} else {
						// Ensure firing before onload, maybe late but safe also for iframes
						document.attachEvent("onreadystatechange", DOMContentLoaded);

						// A fallback to window.onload, that will always work
						window.attachEvent("onload", JQXLite.ready);

						// If IE and not a frame
						// continually check to see if the document is ready
						var top = false;

						try {
							top = window.frameElement == null && document.documentElement;
						} catch (e) { }

						if (top && top.doScroll) {
							(function doScrollCheck() {
								if (!JQXLite.isReady) {

									try {
										// Use the trick by Diego Perini
										// http://javascript.nwbox.com/IEContentLoaded/
										top.doScroll("left");
									} catch (e) {
										return setTimeout(doScrollCheck, 50);
									}

									// and execute any waiting functions
									JQXLite.ready();
								}
							})();
						}
					}
				}
				return readyList.promise(obj);
			};

			// Populate the class2type map
			JQXLite.each("Boolean Number String Function Array Date RegExp Object".split(" "), function (i, name) {
				class2type["[object " + name + "]"] = name.toLowerCase();
			});

			// All JQXLite objects should point back to these
			rootJQXLite = JQXLite(document);
			// String to Object options format cache
			var optionsCache = {};

			// Convert String-formatted options into Object-formatted ones and store in cache
			function createOptions(options) {
				var object = optionsCache[options] = {};
				JQXLite.each(options.split(core_rspace), function (_, flag) {
					object[flag] = true;
				});
				return object;
			}

			/*
			 * Create a callback list using the following parameters:
			 *
			 *	options: an optional list of space-separated options that will change how
			 *			the callback list behaves or a more traditional option object
			 *
			 * By default a callback list will act like an event callback list and can be
			 * "fired" multiple times.
			 *
			 * Possible options:
			 *
			 *	once:			will ensure the callback list can only be fired once (like a Deferred)
			 *
			 *	memory:			will keep track of previous values and will call any callback added
			 *					after the list has been fired right away with the latest "memorized"
			 *					values (like a Deferred)
			 *
			 *	unique:			will ensure a callback can only be added once (no duplicate in the list)
			 *
			 *	stopOnFalse:	interrupt callings when a callback returns false
			 *
			 */
			JQXLite.Callbacks = function (options) {

				// Convert options from String-formatted to Object-formatted if needed
				// (we check in cache first)
				options = typeof options === "string" ?
					(optionsCache[options] || createOptions(options)) :
					JQXLite.extend({}, options);

				var // Last fire value (for non-forgettable lists)
					memory,
					// Flag to know if list was already fired
					fired,
					// Flag to know if list is currently firing
					firing,
					// First callback to fire (used internally by add and fireWith)
					firingStart,
					// End of the loop when firing
					firingLength,
					// Index of currently firing callback (modified by remove if needed)
					firingIndex,
					// Actual callback list
					list = [],
					// Stack of fire calls for repeatable lists
					stack = !options.once && [],
					// Fire callbacks
					fire = function (data) {
						memory = options.memory && data;
						fired = true;
						firingIndex = firingStart || 0;
						firingStart = 0;
						firingLength = list.length;
						firing = true;
						for (; list && firingIndex < firingLength; firingIndex++) {
							if (list[firingIndex].apply(data[0], data[1]) === false && options.stopOnFalse) {
								memory = false; // To prevent further calls using add
								break;
							}
						}
						firing = false;
						if (list) {
							if (stack) {
								if (stack.length) {
									fire(stack.shift());
								}
							} else if (memory) {
								list = [];
							} else {
								self.disable();
							}
						}
					},
					// Actual Callbacks object
					self = {
						// Add a callback or a collection of callbacks to the list
						add: function () {
							if (list) {
								// First, we save the current length
								var start = list.length;
								(function add(args) {
									JQXLite.each(args, function (_, arg) {
										var type = JQXLite.type(arg);
										if (type === "function") {
											if (!options.unique || !self.has(arg)) {
												list.push(arg);
											}
										} else if (arg && arg.length && type !== "string") {
											// Inspect recursively
											add(arg);
										}
									});
								})(arguments);
								// Do we need to add the callbacks to the
								// current firing batch?
								if (firing) {
									firingLength = list.length;
									// With memory, if we're not firing then
									// we should call right away
								} else if (memory) {
									firingStart = start;
									fire(memory);
								}
							}
							return this;
						},
						// Remove a callback from the list
						remove: function () {
							if (list) {
								JQXLite.each(arguments, function (_, arg) {
									var index;
									while ((index = JQXLite.inArray(arg, list, index)) > -1) {
										list.splice(index, 1);
										// Handle firing indexes
										if (firing) {
											if (index <= firingLength) {
												firingLength--;
											}
											if (index <= firingIndex) {
												firingIndex--;
											}
										}
									}
								});
							}
							return this;
						},
						// Control if a given callback is in the list
						has: function (fn) {
							return JQXLite.inArray(fn, list) > -1;
						},
						// Remove all callbacks from the list
						empty: function () {
							list = [];
							return this;
						},
						// Have the list do nothing anymore
						disable: function () {
							list = stack = memory = undefined;
							return this;
						},
						// Is it disabled?
						disabled: function () {
							return !list;
						},
						// Lock the list in its current state
						lock: function () {
							stack = undefined;
							if (!memory) {
								self.disable();
							}
							return this;
						},
						// Is it locked?
						locked: function () {
							return !stack;
						},
						// Call all callbacks with the given context and arguments
						fireWith: function (context, args) {
							args = args || [];
							args = [context, args.slice ? args.slice() : args];
							if (list && (!fired || stack)) {
								if (firing) {
									stack.push(args);
								} else {
									fire(args);
								}
							}
							return this;
						},
						// Call all the callbacks with the given arguments
						fire: function () {
							self.fireWith(this, arguments);
							return this;
						},
						// To know if the callbacks have already been called at least once
						fired: function () {
							return !!fired;
						}
					};

				return self;
			};
			JQXLite.extend({

				Deferred: function (func) {
					var tuples = [
						// action, add listener, listener list, final state
						["resolve", "done", JQXLite.Callbacks("once memory"), "resolved"],
						["reject", "fail", JQXLite.Callbacks("once memory"), "rejected"],
						["notify", "progress", JQXLite.Callbacks("memory")]
					],
						state = "pending",
						promise = {
							state: function () {
								return state;
							},
							always: function () {
								deferred.done(arguments).fail(arguments);
								return this;
							},
							then: function ( /* fnDone, fnFail, fnProgress */) {
								var fns = arguments;
								return JQXLite.Deferred(function (newDefer) {
									JQXLite.each(tuples, function (i, tuple) {
										var action = tuple[0],
											fn = fns[i];
										// deferred[ done | fail | progress ] for forwarding actions to newDefer
										deferred[tuple[1]](JQXLite.isFunction(fn) ?
											function () {
												var returned = fn.apply(this, arguments);
												if (returned && JQXLite.isFunction(returned.promise)) {
													returned.promise()
														.done(newDefer.resolve)
														.fail(newDefer.reject)
														.progress(newDefer.notify);
												} else {
													newDefer[action + "With"](this === deferred ? newDefer : this, [returned]);
												}
											} :
											newDefer[action]
										);
									});
									fns = null;
								}).promise();
							},
							// Get a promise for this deferred
							// If obj is provided, the promise aspect is added to the object
							promise: function (obj) {
								return obj != null ? JQXLite.extend(obj, promise) : promise;
							}
						},
						deferred = {};

					// Keep pipe for back-compat
					promise.pipe = promise.then;

					// Add list-specific methods
					JQXLite.each(tuples, function (i, tuple) {
						var list = tuple[2],
							stateString = tuple[3];

						// promise[ done | fail | progress ] = list.add
						promise[tuple[1]] = list.add;

						// Handle state
						if (stateString) {
							list.add(function () {
								// state = [ resolved | rejected ]
								state = stateString;

								// [ reject_list | resolve_list ].disable; progress_list.lock
							}, tuples[i ^ 1][2].disable, tuples[2][2].lock);
						}

						// deferred[ resolve | reject | notify ] = list.fire
						deferred[tuple[0]] = list.fire;
						deferred[tuple[0] + "With"] = list.fireWith;
					});

					// Make the deferred a promise
					promise.promise(deferred);

					// Call given func if any
					if (func) {
						func.call(deferred, deferred);
					}

					// All done!
					return deferred;
				},

				// Deferred helper
				when: function (subordinate /* , ..., subordinateN */) {
					var i = 0,
						resolveValues = core_slice.call(arguments),
						length = resolveValues.length,

						// the count of uncompleted subordinates
						remaining = length !== 1 || (subordinate && JQXLite.isFunction(subordinate.promise)) ? length : 0,

						// the master Deferred. If resolveValues consist of only a single Deferred, just use that.
						deferred = remaining === 1 ? subordinate : JQXLite.Deferred(),

						// Update function for both resolve and progress values
						updateFunc = function (i, contexts, values) {
							return function (value) {
								contexts[i] = this;
								values[i] = arguments.length > 1 ? core_slice.call(arguments) : value;
								if (values === progressValues) {
									deferred.notifyWith(contexts, values);
								} else if (!(--remaining)) {
									deferred.resolveWith(contexts, values);
								}
							};
						},

						progressValues, progressContexts, resolveContexts;

					// add listeners to Deferred subordinates; treat others as resolved
					if (length > 1) {
						progressValues = new Array(length);
						progressContexts = new Array(length);
						resolveContexts = new Array(length);
						for (; i < length; i++) {
							if (resolveValues[i] && JQXLite.isFunction(resolveValues[i].promise)) {
								resolveValues[i].promise()
									.done(updateFunc(i, resolveContexts, resolveValues))
									.fail(deferred.reject)
									.progress(updateFunc(i, progressContexts, progressValues));
							} else {
								--remaining;
							}
						}
					}

					// if we're not waiting on anything, resolve the master
					if (!remaining) {
						deferred.resolveWith(resolveContexts, resolveValues);
					}

					return deferred.promise();
				}
			});
			JQXLite.support = (function () {

				var support,
					all,
					a,
					select,
					opt,
					input,
					fragment,
					eventName,
					i,
					isSupported,
					clickFn,
					div = document.createElement("div");

				// Setup
				div.setAttribute("className", "t");
				div.innerHTML = "  <link/><table></table><a href='/a'>a</a><input type='checkbox'/>";

				// Support tests won't run in some limited or non-browser environments
				all = div.getElementsByTagName("*");
				a = div.getElementsByTagName("a")[0];
				if (!all || !a || !all.length) {
					return {};
				}

				// First batch of tests
				select = document.createElement("select");
				opt = select.appendChild(document.createElement("option"));
				input = div.getElementsByTagName("input")[0];

				a.style.cssText = "top:1px;float:left;opacity:.5";
				support = {
					// IE strips leading whitespace when .innerHTML is used
					leadingWhitespace: (div.firstChild.nodeType === 3),

					// Make sure that tbody elements aren't automatically inserted
					// IE will insert them into empty tables
					tbody: !div.getElementsByTagName("tbody").length,

					// Make sure that link elements get serialized correctly by innerHTML
					// This requires a wrapper element in IE
					htmlSerialize: !!div.getElementsByTagName("link").length,

					// Get the style information from getAttribute
					// (IE uses .cssText instead)
					style: /top/.test(a.getAttribute("style")),

					// Make sure that URLs aren't manipulated
					// (IE normalizes it by default)
					hrefNormalized: (a.getAttribute("href") === "/a"),

					// Make sure that element opacity exists
					// (IE uses filter instead)
					// Use a regex to work around a WebKit issue. See #5145
					opacity: /^0.5/.test(a.style.opacity),

					// Verify style float existence
					// (IE uses styleFloat instead of cssFloat)
					cssFloat: !!a.style.cssFloat,

					// Make sure that if no value is specified for a checkbox
					// that it defaults to "on".
					// (WebKit defaults to "" instead)
					checkOn: (input.value === "on"),

					// Make sure that a selected-by-default option has a working selected property.
					// (WebKit defaults to false instead of true, IE too, if it's in an optgroup)
					optSelected: opt.selected,

					// Test setAttribute on camelCase class. If it works, we need attrFixes when doing get/setAttribute (ie6/7)
					getSetAttribute: div.className !== "t",

					// Tests for enctype support on a form (#6743)
					enctype: !!document.createElement("form").enctype,

					// Makes sure cloning an html5 element does not cause problems
					// Where outerHTML is undefined, this still works
					html5Clone: document.createElement("nav").cloneNode(true).outerHTML !== "<:nav></:nav>",

					// JQXLite.support.boxModel DEPRECATED in 1.8 since we don't support Quirks Mode
					boxModel: (document.compatMode === "CSS1Compat"),

					// Will be defined later
					submitBubbles: true,
					changeBubbles: true,
					focusinBubbles: false,
					deleteExpando: true,
					noCloneEvent: true,
					inlineBlockNeedsLayout: false,
					shrinkWrapBlocks: false,
					reliableMarginRight: true,
					boxSizingReliable: true,
					pixelPosition: false
				};

				// Make sure checked status is properly cloned
				input.checked = true;
				support.noCloneChecked = input.cloneNode(true).checked;

				// Make sure that the options inside disabled selects aren't marked as disabled
				// (WebKit marks them as disabled)
				select.disabled = true;
				support.optDisabled = !opt.disabled;

				// Test to see if it's possible to delete an expando from an element
				// Fails in Internet Explorer
				try {
					delete div.test;
				} catch (e) {
					support.deleteExpando = false;
				}

				if (!div.addEventListener && div.attachEvent && div.fireEvent) {
					div.attachEvent("onclick", clickFn = function () {
						// Cloning a node shouldn't copy over any
						// bound event handlers (IE does this)
						support.noCloneEvent = false;
					});
					div.cloneNode(true).fireEvent("onclick");
					div.detachEvent("onclick", clickFn);
				}

				// Check if a radio maintains its value
				// after being appended to the DOM
				input = document.createElement("input");
				input.value = "t";
				input.setAttribute("type", "radio");
				support.radioValue = input.value === "t";

				input.setAttribute("checked", "checked");

				// #11217 - WebKit loses check when the name is after the checked attribute
				input.setAttribute("name", "t");

				div.appendChild(input);
				fragment = document.createDocumentFragment();
				fragment.appendChild(div.lastChild);

				// WebKit doesn't clone checked state correctly in fragments
				support.checkClone = fragment.cloneNode(true).cloneNode(true).lastChild.checked;

				// Check if a disconnected checkbox will retain its checked
				// value of true after appended to the DOM (IE6/7)
				support.appendChecked = input.checked;

				fragment.removeChild(input);
				fragment.appendChild(div);

				// Technique from Juriy Zaytsev
				// http://perfectionkills.com/detecting-event-support-without-browser-sniffing/
				// We only care about the case where non-standard event systems
				// are used, namely in IE. Short-circuiting here helps us to
				// avoid an eval call (in setAttribute) which can cause CSP
				// to go haywire. See: https://developer.mozilla.org/en/Security/CSP
				if (div.attachEvent) {
					for (i in {
						submit: true,
						change: true,
						focusin: true
					}) {
						eventName = "on" + i;
						isSupported = (eventName in div);
						if (!isSupported) {
							div.setAttribute(eventName, "return;");
							isSupported = (typeof div[eventName] === "function");
						}
						support[i + "Bubbles"] = isSupported;
					}
				}

				// Run tests that need a body at doc ready
				JQXLite(function () {
					var container, div, tds, marginDiv,
						divReset = "padding:0;margin:0;border:0;display:block;overflow:hidden;",
						body = document.getElementsByTagName("body")[0];

					if (!body) {
						// Return for frameset docs that don't have a body
						return;
					}

					container = document.createElement("div");
					container.style.cssText = "visibility:hidden;border:0;width:0;height:0;position:static;top:0;margin-top:1px";
					body.insertBefore(container, body.firstChild);

					// Construct the test element
					div = document.createElement("div");
					container.appendChild(div);

					// Check if table cells still have offsetWidth/Height when they are set
					// to display:none and there are still other visible table cells in a
					// table row; if so, offsetWidth/Height are not reliable for use when
					// determining if an element has been hidden directly using
					// display:none (it is still safe to use offsets if a parent element is
					// hidden; don safety goggles and see bug #4512 for more information).
					// (only IE 8 fails this test)
					div.innerHTML = "<table><tr><td></td><td>t</td></tr></table>";
					tds = div.getElementsByTagName("td");
					tds[0].style.cssText = "padding:0;margin:0;border:0;display:none";
					isSupported = (tds[0].offsetHeight === 0);

					tds[0].style.display = "";
					tds[1].style.display = "none";

					// Check if empty table cells still have offsetWidth/Height
					// (IE <= 8 fail this test)
					support.reliableHiddenOffsets = isSupported && (tds[0].offsetHeight === 0);

					// Check box-sizing and margin behavior
					div.innerHTML = "";
					div.style.cssText = "box-sizing:border-box;-moz-box-sizing:border-box;-webkit-box-sizing:border-box;padding:1px;border:1px;display:block;width:4px;margin-top:1%;position:absolute;top:1%;";
					support.boxSizing = (div.offsetWidth === 4);
					support.doesNotIncludeMarginInBodyOffset = (body.offsetTop !== 1);

					// NOTE: To any future maintainer, we've window.getComputedStyle
					// because jsdom on node.js will break without it.
					if (window.getComputedStyle) {
						support.pixelPosition = (window.getComputedStyle(div, null) || {}).top !== "1%";
						support.boxSizingReliable = (window.getComputedStyle(div, null) || { width: "4px" }).width === "4px";

						// Check if div with explicit width and no margin-right incorrectly
						// gets computed margin-right based on width of container. For more
						// info see bug #3333
						// Fails in WebKit before Feb 2011 nightlies
						// WebKit Bug 13343 - getComputedStyle returns wrong value for margin-right
						marginDiv = document.createElement("div");
						marginDiv.style.cssText = div.style.cssText = divReset;
						marginDiv.style.marginRight = marginDiv.style.width = "0";
						div.style.width = "1px";
						div.appendChild(marginDiv);
						support.reliableMarginRight =
							!parseFloat((window.getComputedStyle(marginDiv, null) || {}).marginRight);
					}

					if (typeof div.style.zoom !== "undefined") {
						// Check if natively block-level elements act like inline-block
						// elements when setting their display to 'inline' and giving
						// them layout
						// (IE < 8 does this)
						div.innerHTML = "";
						div.style.cssText = divReset + "width:1px;padding:1px;display:inline;zoom:1";
						support.inlineBlockNeedsLayout = (div.offsetWidth === 3);

						// Check if elements with layout shrink-wrap their children
						// (IE 6 does this)
						div.style.display = "block";
						div.style.overflow = "visible";
						div.innerHTML = "<div></div>";
						div.firstChild.style.width = "5px";
						support.shrinkWrapBlocks = (div.offsetWidth !== 3);

						container.style.zoom = 1;
					}

					// Null elements to avoid leaks in IE
					body.removeChild(container);
					container = div = tds = marginDiv = null;
				});

				// Null elements to avoid leaks in IE
				fragment.removeChild(div);
				all = a = select = opt = input = fragment = div = null;

				return support;
			})();
			var rbrace = /(?:\{[\s\S]*\}|\[[\s\S]*\])$/,
				rmultiDash = /([A-Z])/g;

			JQXLite.extend({
				cache: {},

				deletedIds: [],

				// Remove at next major release (1.9/2.0)
				uuid: 0,

				// Unique for each copy of JQXLite on the page
				// Non-digits removed to match rinlinejQuery
				expando: "JQXLite" + (JQXLite.fn.jqx + Math.random()).replace(/\D/g, ""),

				// The following elements throw uncatchable exceptions if you
				// attempt to add expando properties to them.
				noData: {
					"embed": true,
					// Ban all objects except for Flash (which handle expandos)
					"object": "clsid:D27CDB6E-AE6D-11cf-96B8-444553540000",
					"applet": true
				},

				hasData: function (elem) {
					elem = elem.nodeType ? JQXLite.cache[elem[JQXLite.expando]] : elem[JQXLite.expando];
					return !!elem && !isEmptyDataObject(elem);
				},

				data: function (elem, name, data, pvt /* Internal Use Only */) {
					if (!JQXLite.acceptData(elem)) {
						return;
					}

					var thisCache, ret,
						internalKey = JQXLite.expando,
						getByName = typeof name === "string",

						// We have to handle DOM nodes and JS objects differently because IE6-7
						// can't GC object references properly across the DOM-JS boundary
						isNode = elem.nodeType,

						// Only DOM nodes need the global JQXLite cache; JS object data is
						// attached directly to the object so GC can occur automatically
						cache = isNode ? JQXLite.cache : elem,

						// Only defining an ID for JS objects if its cache already exists allows
						// the code to shortcut on the same path as a DOM node with no cache
						id = isNode ? elem[internalKey] : elem[internalKey] && internalKey;

					// Avoid doing any more work than we need to when trying to get data on an
					// object that has no data at all
					if ((!id || !cache[id] || (!pvt && !cache[id].data)) && getByName && data === undefined) {
						return;
					}

					if (!id) {
						// Only DOM nodes need a new unique ID for each element since their data
						// ends up in the global cache
						if (isNode) {
							elem[internalKey] = id = JQXLite.deletedIds.pop() || JQXLite.guid++;
						} else {
							id = internalKey;
						}
					}

					if (!cache[id]) {
						cache[id] = {};

						// Avoids exposing JQXLite metadata on plain JS objects when the object
						// is serialized using JSON.stringify
						if (!isNode) {
							cache[id].toJSON = JQXLite.noop;
						}
					}

					// An object can be passed to JQXLite.data instead of a key/value pair; this gets
					// shallow copied over onto the existing cache
					if (typeof name === "object" || typeof name === "function") {
						if (pvt) {
							cache[id] = JQXLite.extend(cache[id], name);
						} else {
							cache[id].data = JQXLite.extend(cache[id].data, name);
						}
					}

					thisCache = cache[id];

					// JQXLite data() is stored in a separate object inside the object's internal data
					// cache in order to avoid key collisions between internal data and user-defined
					// data.
					if (!pvt) {
						if (!thisCache.data) {
							thisCache.data = {};
						}

						thisCache = thisCache.data;
					}

					if (data !== undefined) {
						thisCache[JQXLite.camelCase(name)] = data;
					}

					// Check for both converted-to-camel and non-converted data property names
					// If a data property was specified
					if (getByName) {

						// First Try to find as-is property data
						ret = thisCache[name];

						// Test for null|undefined property data
						if (ret == null) {

							// Try to find the camelCased property
							ret = thisCache[JQXLite.camelCase(name)];
						}
					} else {
						ret = thisCache;
					}

					return ret;
				},

				removeData: function (elem, name, pvt /* Internal Use Only */) {
					if (!JQXLite.acceptData(elem)) {
						return;
					}

					var thisCache, i, l,

						isNode = elem.nodeType,

						// See JQXLite.data for more information
						cache = isNode ? JQXLite.cache : elem,
						id = isNode ? elem[JQXLite.expando] : JQXLite.expando;

					// If there is already no cache entry for this object, there is no
					// purpose in continuing
					if (!cache[id]) {
						return;
					}

					if (name) {

						thisCache = pvt ? cache[id] : cache[id].data;

						if (thisCache) {

							// Support array or space separated string names for data keys
							if (!JQXLite.isArray(name)) {

								// try the string as a key before any manipulation
								if (name in thisCache) {
									name = [name];
								} else {

									// split the camel cased version by spaces unless a key with the spaces exists
									name = JQXLite.camelCase(name);
									if (name in thisCache) {
										name = [name];
									} else {
										name = name.split(" ");
									}
								}
							}

							for (i = 0, l = name.length; i < l; i++) {
								delete thisCache[name[i]];
							}

							// If there is no data left in the cache, we want to continue
							// and let the cache object itself get destroyed
							if (!(pvt ? isEmptyDataObject : JQXLite.isEmptyObject)(thisCache)) {
								return;
							}
						}
					}

					// See JQXLite.data for more information
					if (!pvt) {
						delete cache[id].data;

						// Don't destroy the parent cache unless the internal data object
						// had been the only thing left in it
						if (!isEmptyDataObject(cache[id])) {
							return;
						}
					}

					// Destroy the cache
					if (isNode) {
						JQXLite.cleanData([elem], true);

						// Use delete when supported for expandos or `cache` is not a window per isWindow (#10080)
					} else if (JQXLite.support.deleteExpando || cache != cache.window) {
						delete cache[id];

						// When all else fails, null
					} else {
						cache[id] = null;
					}
				},

				// For internal use only.
				_data: function (elem, name, data) {
					return JQXLite.data(elem, name, data, true);
				},

				// A method for determining if a DOM node can handle the data expando
				acceptData: function (elem) {
					var noData = elem.nodeName && JQXLite.noData[elem.nodeName.toLowerCase()];

					// nodes accept data unless otherwise specified; rejection can be conditional
					return !noData || noData !== true && elem.getAttribute("classid") === noData;
				}
			});

			JQXLite.fn.extend({
				data: function (key, value) {
					var parts, part, attr, name, l,
						elem = this[0],
						i = 0,
						data = null;

					// Gets all values
					if (key === undefined) {
						if (this.length) {
							data = JQXLite.data(elem);

							if (elem.nodeType === 1 && !JQXLite._data(elem, "parsedAttrs")) {
								attr = elem.attributes;
								for (l = attr.length; i < l; i++) {
									name = attr[i].name;

									if (!name.indexOf("data-")) {
										name = JQXLite.camelCase(name.substring(5));

										dataAttr(elem, name, data[name]);
									}
								}
								JQXLite._data(elem, "parsedAttrs", true);
							}
						}

						return data;
					}

					// Sets multiple values
					if (typeof key === "object") {
						return this.each(function () {
							JQXLite.data(this, key);
						});
					}

					parts = key.split(".", 2);
					parts[1] = parts[1] ? "." + parts[1] : "";
					part = parts[1] + "!";

					return JQXLite.access(this, function (value) {

						if (value === undefined) {
							data = this.triggerHandler("getData" + part, [parts[0]]);

							// Try to fetch any internally stored data first
							if (data === undefined && elem) {
								data = JQXLite.data(elem, key);
								data = dataAttr(elem, key, data);
							}

							return data === undefined && parts[1] ?
								this.data(parts[0]) :
								data;
						}

						parts[1] = value;
						this.each(function () {
							var self = JQXLite(this);

							self.triggerHandler("setData" + part, parts);
							JQXLite.data(this, key, value);
							self.triggerHandler("changeData" + part, parts);
						});
					}, null, value, arguments.length > 1, null, false);
				},

				removeData: function (key) {
					return this.each(function () {
						JQXLite.removeData(this, key);
					});
				}
			});

			function dataAttr(elem, key, data) {
				// If nothing was found internally, try to fetch any
				// data from the HTML5 data-* attribute
				if (data === undefined && elem.nodeType === 1) {

					var name = "data-" + key.replace(rmultiDash, "-$1").toLowerCase();

					data = elem.getAttribute(name);

					if (typeof data === "string") {
						try {
							data = data === "true" ? true :
								data === "false" ? false :
									data === "null" ? null :
										// Only convert to a number if it doesn't change the string
										+data + "" === data ? +data :
											rbrace.test(data) ? JQXLite.parseJSON(data) :
												data;
						} catch (e) { }

						// Make sure we set the data so it isn't changed later
						JQXLite.data(elem, key, data);

					} else {
						data = undefined;
					}
				}

				return data;
			}

			// checks a cache object for emptiness
			function isEmptyDataObject(obj) {
				var name;
				for (name in obj) {

					// if the public data object is empty, the private is still empty
					if (name === "data" && JQXLite.isEmptyObject(obj[name])) {
						continue;
					}
					if (name !== "toJSON") {
						return false;
					}
				}

				return true;
			}
			JQXLite.extend({
				queue: function (elem, type, data) {
					var queue;

					if (elem) {
						type = (type || "fx") + "queue";
						queue = JQXLite._data(elem, type);

						// Speed up dequeue by getting out quickly if this is just a lookup
						if (data) {
							if (!queue || JQXLite.isArray(data)) {
								queue = JQXLite._data(elem, type, JQXLite.makeArray(data));
							} else {
								queue.push(data);
							}
						}
						return queue || [];
					}
				},

				dequeue: function (elem, type) {
					type = type || "fx";

					var queue = JQXLite.queue(elem, type),
						startLength = queue.length,
						fn = queue.shift(),
						hooks = JQXLite._queueHooks(elem, type),
						next = function () {
							JQXLite.dequeue(elem, type);
						};

					// If the fx queue is dequeued, always remove the progress sentinel
					if (fn === "inprogress") {
						fn = queue.shift();
						startLength--;
					}

					if (fn) {

						// Add a progress sentinel to prevent the fx queue from being
						// automatically dequeued
						if (type === "fx") {
							queue.unshift("inprogress");
						}

						// clear up the last queue stop function
						delete hooks.stop;
						fn.call(elem, next, hooks);
					}

					if (!startLength && hooks) {
						hooks.empty.fire();
					}
				},

				// not intended for public consumption - generates a queueHooks object, or returns the current one
				_queueHooks: function (elem, type) {
					var key = type + "queueHooks";
					return JQXLite._data(elem, key) || JQXLite._data(elem, key, {
						empty: JQXLite.Callbacks("once memory").add(function () {
							JQXLite.removeData(elem, type + "queue", true);
							JQXLite.removeData(elem, key, true);
						})
					});
				}
			});

			JQXLite.fn.extend({
				queue: function (type, data) {
					var setter = 2;

					if (typeof type !== "string") {
						data = type;
						type = "fx";
						setter--;
					}

					if (arguments.length < setter) {
						return JQXLite.queue(this[0], type);
					}

					return data === undefined ?
						this :
						this.each(function () {
							var queue = JQXLite.queue(this, type, data);

							// ensure a hooks for this queue
							JQXLite._queueHooks(this, type);

							if (type === "fx" && queue[0] !== "inprogress") {
								JQXLite.dequeue(this, type);
							}
						});
				},
				dequeue: function (type) {
					return this.each(function () {
						JQXLite.dequeue(this, type);
					});
				},
				// Based off of the plugin by Clint Helfers, with permission.
				// http://blindsignals.com/index.php/2009/07/jqx-delay/
				delay: function (time, type) {
					time = JQXLite.fx ? JQXLite.fx.speeds[time] || time : time;
					type = type || "fx";

					return this.queue(type, function (next, hooks) {
						var timeout = setTimeout(next, time);
						hooks.stop = function () {
							clearTimeout(timeout);
						};
					});
				},
				clearQueue: function (type) {
					return this.queue(type || "fx", []);
				},
				// Get a promise resolved when queues of a certain type
				// are emptied (fx is the type by default)
				promise: function (type, obj) {
					var tmp,
						count = 1,
						defer = JQXLite.Deferred(),
						elements = this,
						i = this.length,
						resolve = function () {
							if (!(--count)) {
								defer.resolveWith(elements, [elements]);
							}
						};

					if (typeof type !== "string") {
						obj = type;
						type = undefined;
					}
					type = type || "fx";

					while (i--) {
						tmp = JQXLite._data(elements[i], type + "queueHooks");
						if (tmp && tmp.empty) {
							count++;
							tmp.empty.add(resolve);
						}
					}
					resolve();
					return defer.promise(obj);
				}
			});
			var nodeHook, boolHook, fixSpecified,
				rclass = /[\t\r\n]/g,
				rreturn = /\r/g,
				rtype = /^(?:button|input)$/i,
				rfocusable = /^(?:button|input|object|select|textarea)$/i,
				rclickable = /^a(?:rea|)$/i,
				rboolean = /^(?:autofocus|autoplay|async|checked|controls|defer|disabled|hidden|loop|multiple|open|readonly|required|scoped|selected)$/i,
				getSetAttribute = JQXLite.support.getSetAttribute;

			JQXLite.fn.extend({
				attr: function (name, value) {
					return JQXLite.access(this, JQXLite.attr, name, value, arguments.length > 1);
				},

				removeAttr: function (name) {
					return this.each(function () {
						JQXLite.removeAttr(this, name);
					});
				},

				prop: function (name, value) {
					return JQXLite.access(this, JQXLite.prop, name, value, arguments.length > 1);
				},

				removeProp: function (name) {
					name = JQXLite.propFix[name] || name;
					return this.each(function () {
						// try/catch handles cases where IE balks (such as removing a property on window)
						try {
							this[name] = undefined;
							delete this[name];
						} catch (e) { }
					});
				},

				addClass: function (value) {
					var classNames, i, l, elem,
						setClass, c, cl;

					if (JQXLite.isFunction(value)) {
						return this.each(function (j) {
							JQXLite(this).addClass(value.call(this, j, this.className));
						});
					}

					if (value && typeof value === "string") {
						classNames = value.split(core_rspace);

						for (i = 0, l = this.length; i < l; i++) {
							elem = this[i];

							if (elem.nodeType === 1) {
								if (!elem.className && classNames.length === 1) {
									elem.className = value;

								} else {
									setClass = " " + elem.className + " ";

									for (c = 0, cl = classNames.length; c < cl; c++) {
										if (setClass.indexOf(" " + classNames[c] + " ") < 0) {
											setClass += classNames[c] + " ";
										}
									}
									elem.className = JQXLite.trim(setClass);
								}
							}
						}
					}

					return this;
				},

				removeClass: function (value) {
					var removes, className, elem, c, cl, i, l;

					if (JQXLite.isFunction(value)) {
						return this.each(function (j) {
							JQXLite(this).removeClass(value.call(this, j, this.className));
						});
					}
					if ((value && typeof value === "string") || value === undefined) {
						removes = (value || "").split(core_rspace);

						for (i = 0, l = this.length; i < l; i++) {
							elem = this[i];
							if (elem.nodeType === 1 && elem.className) {

								className = (" " + elem.className + " ").replace(rclass, " ");

								// loop over each item in the removal list
								for (c = 0, cl = removes.length; c < cl; c++) {
									// Remove until there is nothing to remove,
									while (className.indexOf(" " + removes[c] + " ") >= 0) {
										className = className.replace(" " + removes[c] + " ", " ");
									}
								}
								elem.className = value ? JQXLite.trim(className) : "";
							}
						}
					}

					return this;
				},

				toggleClass: function (value, stateVal) {
					var type = typeof value,
						isBool = typeof stateVal === "boolean";

					if (JQXLite.isFunction(value)) {
						return this.each(function (i) {
							JQXLite(this).toggleClass(value.call(this, i, this.className, stateVal), stateVal);
						});
					}

					return this.each(function () {
						if (type === "string") {
							// toggle individual class names
							var className,
								i = 0,
								self = JQXLite(this),
								state = stateVal,
								classNames = value.split(core_rspace);

							while ((className = classNames[i++])) {
								// check each className given, space separated list
								state = isBool ? state : !self.hasClass(className);
								self[state ? "addClass" : "removeClass"](className);
							}

						} else if (type === "undefined" || type === "boolean") {
							if (this.className) {
								// store className if set
								JQXLite._data(this, "__className__", this.className);
							}

							// toggle whole className
							this.className = this.className || value === false ? "" : JQXLite._data(this, "__className__") || "";
						}
					});
				},

				hasClass: function (selector) {
					var className = " " + selector + " ",
						i = 0,
						l = this.length;
					for (; i < l; i++) {
						if (this[i].nodeType === 1 && (" " + this[i].className + " ").replace(rclass, " ").indexOf(className) >= 0) {
							return true;
						}
					}

					return false;
				},

				val: function (value) {
					var hooks, ret, isFunction,
						elem = this[0];

					if (!arguments.length) {
						if (elem) {
							hooks = JQXLite.valHooks[elem.type] || JQXLite.valHooks[elem.nodeName.toLowerCase()];

							if (hooks && "get" in hooks && (ret = hooks.get(elem, "value")) !== undefined) {
								return ret;
							}

							ret = elem.value;

							return typeof ret === "string" ?
								// handle most common string cases
								ret.replace(rreturn, "") :
								// handle cases where value is null/undef or number
								ret == null ? "" : ret;
						}

						return;
					}

					isFunction = JQXLite.isFunction(value);

					return this.each(function (i) {
						var val,
							self = JQXLite(this);

						if (this.nodeType !== 1) {
							return;
						}

						if (isFunction) {
							val = value.call(this, i, self.val());
						} else {
							val = value;
						}

						// Treat null/undefined as ""; convert numbers to string
						if (val == null) {
							val = "";
						} else if (typeof val === "number") {
							val += "";
						} else if (JQXLite.isArray(val)) {
							val = JQXLite.map(val, function (value) {
								return value == null ? "" : value + "";
							});
						}

						hooks = JQXLite.valHooks[this.type] || JQXLite.valHooks[this.nodeName.toLowerCase()];

						// If set returns undefined, fall back to normal setting
						if (!hooks || !("set" in hooks) || hooks.set(this, val, "value") === undefined) {
							this.value = val;
						}
					});
				}
			});

			JQXLite.extend({
				valHooks: {
					option: {
						get: function (elem) {
							// attributes.value is undefined in Blackberry 4.7 but
							// uses .value. See #6932
							var val = elem.attributes.value;
							return !val || val.specified ? elem.value : elem.text;
						}
					},
					select: {
						get: function (elem) {
							var value, option,
								options = elem.options,
								index = elem.selectedIndex,
								one = elem.type === "select-one" || index < 0,
								values = one ? null : [],
								max = one ? index + 1 : options.length,
								i = index < 0 ?
									max :
									one ? index : 0;

							// Loop through all the selected options
							for (; i < max; i++) {
								option = options[i];

								// oldIE doesn't update selected after form reset (#2551)
								if ((option.selected || i === index) &&
									// Don't return options that are disabled or in a disabled optgroup
									(JQXLite.support.optDisabled ? !option.disabled : option.getAttribute("disabled") === null) &&
									(!option.parentNode.disabled || !JQXLite.nodeName(option.parentNode, "optgroup"))) {

									// Get the specific value for the option
									value = JQXLite(option).val();

									// We don't need an array for one selects
									if (one) {
										return value;
									}

									// Multi-Selects return an array
									values.push(value);
								}
							}

							return values;
						},

						set: function (elem, value) {
							var values = JQXLite.makeArray(value);

							JQXLite(elem).find("option").each(function () {
								this.selected = JQXLite.inArray(JQXLite(this).val(), values) >= 0;
							});

							if (!values.length) {
								elem.selectedIndex = -1;
							}
							return values;
						}
					}
				},

				// Unused in 1.8, left in so attrFn-stabbers won't die; remove in 1.9
				attrFn: {},

				attr: function (elem, name, value, pass) {
					var ret, hooks, notxml,
						nType = elem.nodeType;

					// don't get/set attributes on text, comment and attribute nodes
					if (!elem || nType === 3 || nType === 8 || nType === 2) {
						return;
					}

					if (pass && JQXLite.isFunction(JQXLite.fn[name])) {
						return JQXLite(elem)[name](value);
					}

					// Fallback to prop when attributes are not supported
					if (typeof elem.getAttribute === "undefined") {
						return JQXLite.prop(elem, name, value);
					}

					notxml = nType !== 1 || !JQXLite.isXMLDoc(elem);

					// All attributes are lowercase
					// Grab necessary hook if one is defined
					if (notxml) {
						name = name.toLowerCase();
						hooks = JQXLite.attrHooks[name] || (rboolean.test(name) ? boolHook : nodeHook);
					}

					if (value !== undefined) {

						if (value === null) {
							JQXLite.removeAttr(elem, name);
							return;

						} else if (hooks && "set" in hooks && notxml && (ret = hooks.set(elem, value, name)) !== undefined) {
							return ret;

						} else {
							elem.setAttribute(name, value + "");
							return value;
						}

					} else if (hooks && "get" in hooks && notxml && (ret = hooks.get(elem, name)) !== null) {
						return ret;

					} else {

						ret = elem.getAttribute(name);

						// Non-existent attributes return null, we normalize to undefined
						return ret === null ?
							undefined :
							ret;
					}
				},

				removeAttr: function (elem, value) {
					var propName, attrNames, name, isBool,
						i = 0;

					if (value && elem.nodeType === 1) {

						attrNames = value.split(core_rspace);

						for (; i < attrNames.length; i++) {
							name = attrNames[i];

							if (name) {
								propName = JQXLite.propFix[name] || name;
								isBool = rboolean.test(name);

								// See #9699 for explanation of this approach (setting first, then removal)
								// Do not do this for boolean attributes (see #10870)
								if (!isBool) {
									JQXLite.attr(elem, name, "");
								}
								elem.removeAttribute(getSetAttribute ? name : propName);

								// Set corresponding property to false for boolean attributes
								if (isBool && propName in elem) {
									elem[propName] = false;
								}
							}
						}
					}
				},

				attrHooks: {
					type: {
						set: function (elem, value) {
							// We can't allow the type property to be changed (since it causes problems in IE)
							if (rtype.test(elem.nodeName) && elem.parentNode) {
								JQXLite.error("type property can't be changed");
							} else if (!JQXLite.support.radioValue && value === "radio" && JQXLite.nodeName(elem, "input")) {
								// Setting the type on a radio button after the value resets the value in IE6-9
								// Reset value to it's default in case type is set after value
								// This is for element creation
								var val = elem.value;
								elem.setAttribute("type", value);
								if (val) {
									elem.value = val;
								}
								return value;
							}
						}
					},
					// Use the value property for back compat
					// Use the nodeHook for button elements in IE6/7 (#1954)
					value: {
						get: function (elem, name) {
							if (nodeHook && JQXLite.nodeName(elem, "button")) {
								return nodeHook.get(elem, name);
							}
							return name in elem ?
								elem.value :
								null;
						},
						set: function (elem, value, name) {
							if (nodeHook && JQXLite.nodeName(elem, "button")) {
								return nodeHook.set(elem, value, name);
							}
							// Does not return so that setAttribute is also used
							elem.value = value;
						}
					}
				},

				propFix: {
					tabindex: "tabIndex",
					readonly: "readOnly",
					"for": "htmlFor",
					"class": "className",
					maxlength: "maxLength",
					cellspacing: "cellSpacing",
					cellpadding: "cellPadding",
					rowspan: "rowSpan",
					colspan: "colSpan",
					usemap: "useMap",
					frameborder: "frameBorder",
					contenteditable: "contentEditable"
				},

				prop: function (elem, name, value) {
					var ret, hooks, notxml,
						nType = elem.nodeType;

					// don't get/set properties on text, comment and attribute nodes
					if (!elem || nType === 3 || nType === 8 || nType === 2) {
						return;
					}

					notxml = nType !== 1 || !JQXLite.isXMLDoc(elem);

					if (notxml) {
						// Fix name and attach hooks
						name = JQXLite.propFix[name] || name;
						hooks = JQXLite.propHooks[name];
					}

					if (value !== undefined) {
						if (hooks && "set" in hooks && (ret = hooks.set(elem, value, name)) !== undefined) {
							return ret;

						} else {
							return (elem[name] = value);
						}

					} else {
						if (hooks && "get" in hooks && (ret = hooks.get(elem, name)) !== null) {
							return ret;

						} else {
							return elem[name];
						}
					}
				},

				propHooks: {
					tabIndex: {
						get: function (elem) {
							// elem.tabIndex doesn't always return the correct value when it hasn't been explicitly set
							// http://fluidproject.org/blog/2008/01/09/getting-setting-and-removing-tabindex-values-with-javascript/
							var attributeNode = elem.getAttributeNode("tabindex");

							return attributeNode && attributeNode.specified ?
								parseInt(attributeNode.value, 10) :
								rfocusable.test(elem.nodeName) || rclickable.test(elem.nodeName) && elem.href ?
									0 :
									undefined;
						}
					}
				}
			});

			// Hook for boolean attributes
			boolHook = {
				get: function (elem, name) {
					// Align boolean attributes with corresponding properties
					// Fall back to attribute presence where some booleans are not supported
					var attrNode,
						property = JQXLite.prop(elem, name);
					return property === true || typeof property !== "boolean" && (attrNode = elem.getAttributeNode(name)) && attrNode.nodeValue !== false ?
						name.toLowerCase() :
						undefined;
				},
				set: function (elem, value, name) {
					var propName;
					if (value === false) {
						// Remove boolean attributes when set to false
						JQXLite.removeAttr(elem, name);
					} else {
						// value is true since we know at this point it's type boolean and not false
						// Set boolean attributes to the same name and set the DOM property
						propName = JQXLite.propFix[name] || name;
						if (propName in elem) {
							// Only set the IDL specifically if it already exists on the element
							elem[propName] = true;
						}

						elem.setAttribute(name, name.toLowerCase());
					}
					return name;
				}
			};

			// IE6/7 call enctype encoding
			if (!JQXLite.support.enctype) {
				JQXLite.propFix.enctype = "encoding";
			}

			var rformElems = /^(?:textarea|input|select)$/i,
				rtypenamespace = /^([^\.]*|)(?:\.(.+)|)$/,
				rhoverHack = /(?:^|\s)hover(\.\S+|)\b/,
				rkeyEvent = /^key/,
				rmouseEvent = /^(?:mouse|contextmenu)|click/,
				rfocusMorph = /^(?:focusinfocus|focusoutblur)$/,
				hoverHack = function (events) {
					return JQXLite.event.special.hover ? events : events.replace(rhoverHack, "mouseenter$1 mouseleave$1");
				};

			/*
			 * Helper functions for managing events -- not part of the public interface.
			 * Props to Dean Edwards' addEvent library for many of the ideas.
			 */
			JQXLite.event = {

				add: function (elem, types, handler, data, selector) {

					var elemData, eventHandle, events,
						t, tns, type, namespaces, handleObj,
						handleObjIn, handlers, special;

					// Don't attach events to noData or text/comment nodes (allow plain objects tho)
					if (elem.nodeType === 3 || elem.nodeType === 8 || !types || !handler || !(elemData = JQXLite._data(elem))) {
						return;
					}

					// Caller can pass in an object of custom data in lieu of the handler
					if (handler.handler) {
						handleObjIn = handler;
						handler = handleObjIn.handler;
						selector = handleObjIn.selector;
					}

					// Make sure that the handler has a unique ID, used to find/remove it later
					if (!handler.guid) {
						handler.guid = JQXLite.guid++;
					}

					// Init the element's event structure and main handler, if this is the first
					events = elemData.events;
					if (!events) {
						elemData.events = events = {};
					}
					eventHandle = elemData.handle;
					if (!eventHandle) {
						elemData.handle = eventHandle = function (e) {
							// Discard the second event of a JQXLite.event.trigger() and
							// when an event is called after a page has unloaded
							return typeof JQXLite !== "undefined" && (!e || JQXLite.event.triggered !== e.type) ?
								JQXLite.event.dispatch.apply(eventHandle.elem, arguments) :
								undefined;
						};
						// Add elem as a property of the handle fn to prevent a memory leak with IE non-native events
						eventHandle.elem = elem;
					}

					// Handle multiple events separated by a space
					// JQXLite(...).bind("mouseover mouseout", fn);
					types = JQXLite.trim(hoverHack(types)).split(" ");
					for (t = 0; t < types.length; t++) {

						tns = rtypenamespace.exec(types[t]) || [];
						type = tns[1];
						namespaces = (tns[2] || "").split(".").sort();

						// If event changes its type, use the special event handlers for the changed type
						special = JQXLite.event.special[type] || {};

						// If selector defined, determine special event api type, otherwise given type
						type = (selector ? special.delegateType : special.bindType) || type;

						// Update special based on newly reset type
						special = JQXLite.event.special[type] || {};

						// handleObj is passed to all event handlers
						handleObj = JQXLite.extend({
							type: type,
							origType: tns[1],
							data: data,
							handler: handler,
							guid: handler.guid,
							selector: selector,
							needsContext: selector && JQXLite.expr.match.needsContext.test(selector),
							namespace: namespaces.join(".")
						}, handleObjIn);

						// Init the event handler queue if we're the first
						handlers = events[type];
						if (!handlers) {
							handlers = events[type] = [];
							handlers.delegateCount = 0;

							// Only use addEventListener/attachEvent if the special events handler returns false
							if (!special.setup || special.setup.call(elem, data, namespaces, eventHandle) === false) {
								// Bind the global event handler to the element
								if (elem.addEventListener) {
									if (data && data.passive !== undefined) {
										elem.addEventListener(type, eventHandle, data);
									}
									else {
										elem.addEventListener(type, eventHandle, false);
									}
								} else if (elem.attachEvent) {
									elem.attachEvent("on" + type, eventHandle);
								}
							}
						}

						if (special.add) {
							special.add.call(elem, handleObj);

							if (!handleObj.handler.guid) {
								handleObj.handler.guid = handler.guid;
							}
						}

						// Add to the element's handler list, delegates in front
						if (selector) {
							handlers.splice(handlers.delegateCount++, 0, handleObj);
						} else {
							handlers.push(handleObj);
						}

						// Keep track of which events have ever been used, for event optimization
						JQXLite.event.global[type] = true;
					}

					// Nullify elem to prevent memory leaks in IE
					elem = null;
				},

				global: {},

				// Detach an event or set of events from an element
				remove: function (elem, types, handler, selector, mappedTypes) {

					var t, tns, type, origType, namespaces, origCount,
						j, events, special, eventType, handleObj,
						elemData = JQXLite.hasData(elem) && JQXLite._data(elem);

					if (!elemData || !(events = elemData.events)) {
						return;
					}

					// Once for each type.namespace in types; type may be omitted
					types = JQXLite.trim(hoverHack(types || "")).split(" ");
					for (t = 0; t < types.length; t++) {
						tns = rtypenamespace.exec(types[t]) || [];
						type = origType = tns[1];
						namespaces = tns[2];

						// Unbind all events (on this namespace, if provided) for the element
						if (!type) {
							for (type in events) {
								JQXLite.event.remove(elem, type + types[t], handler, selector, true);
							}
							continue;
						}

						special = JQXLite.event.special[type] || {};
						type = (selector ? special.delegateType : special.bindType) || type;
						eventType = events[type] || [];
						origCount = eventType.length;
						namespaces = namespaces ? new RegExp("(^|\\.)" + namespaces.split(".").sort().join("\\.(?:.*\\.|)") + "(\\.|$)") : null;

						// Remove matching events
						for (j = 0; j < eventType.length; j++) {
							handleObj = eventType[j];

							if ((mappedTypes || origType === handleObj.origType) &&
								(!handler || handler.guid === handleObj.guid) &&
								(!namespaces || namespaces.test(handleObj.namespace)) &&
								(!selector || selector === handleObj.selector || selector === "**" && handleObj.selector)) {
								eventType.splice(j--, 1);

								if (handleObj.selector) {
									eventType.delegateCount--;
								}
								if (special.remove) {
									special.remove.call(elem, handleObj);
								}
							}
						}

						// Remove generic event handler if we removed something and no more handlers exist
						// (avoids potential for endless recursion during removal of special event handlers)
						if (eventType.length === 0 && origCount !== eventType.length) {
							if (!special.teardown || special.teardown.call(elem, namespaces, elemData.handle) === false) {
								JQXLite.removeEvent(elem, type, elemData.handle);
							}

							delete events[type];
						}
					}

					// Remove the expando if it's no longer used
					if (JQXLite.isEmptyObject(events)) {
						delete elemData.handle;

						// removeData also checks for emptiness and clears the expando if empty
						// so use it instead of delete
						JQXLite.removeData(elem, "events", true);
					}
				},

				// Events that are safe to short-circuit if no handlers are attached.
				// Native DOM events should not be added, they may have inline handlers.
				customEvent: {
					"getData": true,
					"setData": true,
					"changeData": true
				},

				trigger: function (event, data, elem, onlyHandlers) {
					// Don't do events on text and comment nodes
					if (elem && (elem.nodeType === 3 || elem.nodeType === 8)) {
						return;
					}

					// Event object or event type
					var cache, exclusive, i, cur, old, ontype, special, handle, eventPath, bubbleType,
						type = event.type || event,
						namespaces = [];

					// focus/blur morphs to focusin/out; ensure we're not firing them right now
					if (rfocusMorph.test(type + JQXLite.event.triggered)) {
						return;
					}

					if (type.indexOf("!") >= 0) {
						// Exclusive events trigger only for the exact event (no namespaces)
						type = type.slice(0, -1);
						exclusive = true;
					}

					if (type.indexOf(".") >= 0) {
						// Namespaced trigger; create a regexp to match event type in handle()
						namespaces = type.split(".");
						type = namespaces.shift();
						namespaces.sort();
					}

					if ((!elem || JQXLite.event.customEvent[type]) && !JQXLite.event.global[type]) {
						// No JQXLite handlers for this event type, and it can't have inline handlers
						return;
					}

					// Caller can pass in an Event, Object, or just an event type string
					event = typeof event === "object" ?
						// JQXLite.Event object
						event[JQXLite.expando] ? event :
							// Object literal
							new JQXLite.Event(type, event) :
						// Just the event type (string)
						new JQXLite.Event(type);

					event.type = type;
					event.isTrigger = true;
					event.exclusive = exclusive;
					event.namespace = namespaces.join(".");
					event.namespace_re = event.namespace ? new RegExp("(^|\\.)" + namespaces.join("\\.(?:.*\\.|)") + "(\\.|$)") : null;
					ontype = type.indexOf(":") < 0 ? "on" + type : "";

					// Handle a global trigger
					if (!elem) {

						// TODO: Stop taunting the data cache; remove global events and always attach to document
						cache = JQXLite.cache;
						for (i in cache) {
							if (cache[i].events && cache[i].events[type]) {
								JQXLite.event.trigger(event, data, cache[i].handle.elem, true);
							}
						}
						return;
					}

					// Clean up the event in case it is being reused
					event.result = undefined;
					if (!event.target) {
						event.target = elem;
					}

					// Clone any incoming data and prepend the event, creating the handler arg list
					data = data != null ? JQXLite.makeArray(data) : [];
					data.unshift(event);

					// Allow special events to draw outside the lines
					special = JQXLite.event.special[type] || {};
					if (special.trigger && special.trigger.apply(elem, data) === false) {
						return;
					}

					// Determine event propagation path in advance, per W3C events spec (#9951)
					// Bubble up to document, then to window; watch for a global ownerDocument var (#9724)
					eventPath = [[elem, special.bindType || type]];
					if (!onlyHandlers && !special.noBubble && !JQXLite.isWindow(elem)) {

						bubbleType = special.delegateType || type;
						cur = rfocusMorph.test(bubbleType + type) ? elem : elem.parentNode;
						for (old = elem; cur; cur = cur.parentNode) {
							eventPath.push([cur, bubbleType]);
							old = cur;
						}

						// Only add window if we got to document (e.g., not plain obj or detached DOM)
						if (old === (elem.ownerDocument || document)) {
							eventPath.push([old.defaultView || old.parentWindow || window, bubbleType]);
						}
					}

					// Fire handlers on the event path
					for (i = 0; i < eventPath.length && !event.isPropagationStopped(); i++) {

						cur = eventPath[i][0];
						event.type = eventPath[i][1];

						handle = (JQXLite._data(cur, "events") || {})[event.type] && JQXLite._data(cur, "handle");
						if (handle) {
							handle.apply(cur, data);
						}
						// Note that this is a bare JS function and not a JQXLite handler
						handle = ontype && cur[ontype];
						if (handle && JQXLite.acceptData(cur) && handle.apply && handle.apply(cur, data) === false) {
							event.preventDefault();
						}
					}
					event.type = type;

					// If nobody prevented the default action, do it now
					if (!onlyHandlers && !event.isDefaultPrevented()) {

						if ((!special._default || special._default.apply(elem.ownerDocument, data) === false) &&
							!(type === "click" && JQXLite.nodeName(elem, "a")) && JQXLite.acceptData(elem)) {

							// Call a native DOM method on the target with the same name name as the event.
							// Can't use an .isFunction() check here because IE6/7 fails that test.
							// Don't do default actions on window, that's where global variables be (#6170)
							// IE<9 dies on focus/blur to hidden element (#1486)
							if (ontype && elem[type] && ((type !== "focus" && type !== "blur") || event.target.offsetWidth !== 0) && !JQXLite.isWindow(elem)) {

								// Don't re-trigger an onFOO event when we call its FOO() method
								old = elem[ontype];

								if (old) {
									elem[ontype] = null;
								}

								// Prevent re-triggering of the same event, since we already bubbled it above
								JQXLite.event.triggered = type;
								elem[type]();
								JQXLite.event.triggered = undefined;

								if (old) {
									elem[ontype] = old;
								}
							}
						}
					}

					return event.result;
				},

				dispatch: function (event) {

					// Make a writable JQXLite.Event from the native event object
					event = JQXLite.event.fix(event || window.event);

					var i, j, cur, ret, selMatch, matched, matches, handleObj, sel, related,
						handlers = ((JQXLite._data(this, "events") || {})[event.type] || []),
						delegateCount = handlers.delegateCount,
						args = core_slice.call(arguments),
						run_all = !event.exclusive && !event.namespace,
						special = JQXLite.event.special[event.type] || {},
						handlerQueue = [];

					// Use the fix-ed JQXLite.Event rather than the (read-only) native event
					args[0] = event;
					event.delegateTarget = this;

					// Call the preDispatch hook for the mapped type, and let it bail if desired
					if (special.preDispatch && special.preDispatch.call(this, event) === false) {
						return;
					}

					// Determine handlers that should run if there are delegated events
					// Avoid non-left-click bubbling in Firefox (#3861)
					if (delegateCount && !(event.button && event.type === "click")) {

						for (cur = event.target; cur != this; cur = cur.parentNode || this) {

							// Don't process clicks (ONLY) on disabled elements (#6911, #8165, #11382, #11764)
							if (cur.disabled !== true || event.type !== "click") {
								selMatch = {};
								matches = [];
								for (i = 0; i < delegateCount; i++) {
									handleObj = handlers[i];
									sel = handleObj.selector;

									if (selMatch[sel] === undefined) {
										selMatch[sel] = handleObj.needsContext ?
											JQXLite(sel, this).index(cur) >= 0 :
											JQXLite.find(sel, this, null, [cur]).length;
									}
									if (selMatch[sel]) {
										matches.push(handleObj);
									}
								}
								if (matches.length) {
									handlerQueue.push({ elem: cur, matches: matches });
								}
							}
						}
					}

					// Add the remaining (directly-bound) handlers
					if (handlers.length > delegateCount) {
						handlerQueue.push({ elem: this, matches: handlers.slice(delegateCount) });
					}

					// Run delegates first; they may want to stop propagation beneath us
					for (i = 0; i < handlerQueue.length && !event.isPropagationStopped(); i++) {
						matched = handlerQueue[i];
						event.currentTarget = matched.elem;

						for (j = 0; j < matched.matches.length && !event.isImmediatePropagationStopped(); j++) {
							handleObj = matched.matches[j];

							// Triggered event must either 1) be non-exclusive and have no namespace, or
							// 2) have namespace(s) a subset or equal to those in the bound event (both can have no namespace).
							if (run_all || (!event.namespace && !handleObj.namespace) || event.namespace_re && event.namespace_re.test(handleObj.namespace)) {

								event.data = handleObj.data;
								event.handleObj = handleObj;

								ret = ((JQXLite.event.special[handleObj.origType] || {}).handle || handleObj.handler)
									.apply(matched.elem, args);

								if (ret !== undefined) {
									event.result = ret;
									if (ret === false) {
										event.preventDefault();
										event.stopPropagation();
									}
								}
							}
						}
					}

					// Call the postDispatch hook for the mapped type
					if (special.postDispatch) {
						special.postDispatch.call(this, event);
					}

					return event.result;
				},

				// Includes some event props shared by KeyEvent and MouseEvent
				// *** attrChange attrName relatedNode srcElement  are not normalized, non-W3C, deprecated, will be removed in 1.8 ***
				props: "attrChange attrName relatedNode srcElement altKey bubbles cancelable ctrlKey currentTarget eventPhase metaKey relatedTarget shiftKey target timeStamp view which".split(" "),

				fixHooks: {},

				keyHooks: {
					props: "char charCode key keyCode".split(" "),
					filter: function (event, original) {

						// Add which for key events
						if (event.which == null) {
							event.which = original.charCode != null ? original.charCode : original.keyCode;
						}

						return event;
					}
				},

				mouseHooks: {
					props: "button buttons clientX clientY fromElement offsetX offsetY pageX pageY screenX screenY toElement".split(" "),
					filter: function (event, original) {
						var eventDoc, doc, body,
							button = original.button,
							fromElement = original.fromElement;

						// Calculate pageX/Y if missing and clientX/Y available
						if (event.pageX == null && original.clientX != null) {
							eventDoc = event.target.ownerDocument || document;
							doc = eventDoc.documentElement;
							body = eventDoc.body;

							event.pageX = original.clientX + (doc && doc.scrollLeft || body && body.scrollLeft || 0) - (doc && doc.clientLeft || body && body.clientLeft || 0);
							event.pageY = original.clientY + (doc && doc.scrollTop || body && body.scrollTop || 0) - (doc && doc.clientTop || body && body.clientTop || 0);
						}

						// Add relatedTarget, if necessary
						if (!event.relatedTarget && fromElement) {
							event.relatedTarget = fromElement === event.target ? original.toElement : fromElement;
						}

						// Add which for click: 1 === left; 2 === middle; 3 === right
						// Note: button is not normalized, so don't use it
						if (!event.which && button !== undefined) {
							event.which = (button & 1 ? 1 : (button & 2 ? 3 : (button & 4 ? 2 : 0)));
						}

						return event;
					}
				},

				fix: function (event) {
					if (event[JQXLite.expando]) {
						return event;
					}

					// Create a writable copy of the event object and normalize some properties
					var i, prop,
						originalEvent = event,
						fixHook = JQXLite.event.fixHooks[event.type] || {},
						copy = fixHook.props ? this.props.concat(fixHook.props) : this.props;

					event = JQXLite.Event(originalEvent);

					for (i = copy.length; i;) {
						prop = copy[--i];
						event[prop] = originalEvent[prop];
					}

					// Fix target property, if necessary (#1925, IE 6/7/8 & Safari2)
					if (!event.target) {
						event.target = originalEvent.srcElement || document;
					}

					// Target should not be a text node (#504, Safari)
					if (event.target.nodeType === 3) {
						event.target = event.target.parentNode;
					}

					// For mouse/key events, metaKey==false if it's undefined (#3368, #11328; IE6/7/8)
					event.metaKey = !!event.metaKey;

					return fixHook.filter ? fixHook.filter(event, originalEvent) : event;
				},

				special: {
					load: {
						// Prevent triggered image.load events from bubbling to window.load
						noBubble: true
					},

					focus: {
						delegateType: "focusin"
					},
					blur: {
						delegateType: "focusout"
					},

					beforeunload: {
						setup: function (data, namespaces, eventHandle) {
							// We only want to do this special case on windows
							if (JQXLite.isWindow(this)) {
								this.onbeforeunload = eventHandle;
							}
						},

						teardown: function (namespaces, eventHandle) {
							if (this.onbeforeunload === eventHandle) {
								this.onbeforeunload = null;
							}
						}
					}
				},

				simulate: function (type, elem, event, bubble) {
					// Piggyback on a donor event to simulate a different one.
					// Fake originalEvent to avoid donor's stopPropagation, but if the
					// simulated event prevents default then we do the same on the donor.
					var e = JQXLite.extend(
						new JQXLite.Event(),
						event,
						{
							type: type,
							isSimulated: true,
							originalEvent: {}
						}
					);
					if (bubble) {
						JQXLite.event.trigger(e, null, elem);
					} else {
						JQXLite.event.dispatch.call(elem, e);
					}
					if (e.isDefaultPrevented()) {
						event.preventDefault();
					}
				}
			};

			// Some plugins are using, but it's undocumented/deprecated and will be removed.
			// The 1.7 special event interface should provide all the hooks needed now.
			JQXLite.event.handle = JQXLite.event.dispatch;

			JQXLite.removeEvent = document.removeEventListener ?
				function (elem, type, handle) {
					if (elem.removeEventListener) {
						elem.removeEventListener(type, handle, false);
					}
				} :
				function (elem, type, handle) {
					var name = "on" + type;

					if (elem.detachEvent) {

						// #8545, #7054, preventing memory leaks for custom events in IE6-8
						// detachEvent needed property on element, by name of that event, to properly expose it to GC
						if (typeof elem[name] === "undefined") {
							elem[name] = null;
						}

						elem.detachEvent(name, handle);
					}
				};

			JQXLite.Event = function (src, props) {
				// Allow instantiation without the 'new' keyword
				if (!(this instanceof JQXLite.Event)) {
					return new JQXLite.Event(src, props);
				}

				// Event object
				if (src && src.type) {
					this.originalEvent = src;
					this.type = src.type;

					// Events bubbling up the document may have been marked as prevented
					// by a handler lower down the tree; reflect the correct value.
					this.isDefaultPrevented = (src.defaultPrevented || src.returnValue === false ||
						src.getPreventDefault && src.getPreventDefault()) ? returnTrue : returnFalse;

					// Event type
				} else {
					this.type = src;
				}

				// Put explicitly provided properties onto the event object
				if (props) {
					JQXLite.extend(this, props);
				}

				// Create a timestamp if incoming event doesn't have one
				this.timeStamp = src && src.timeStamp || JQXLite.now();

				// Mark it as fixed
				this[JQXLite.expando] = true;
			};

			function returnFalse() {
				return false;
			}
			function returnTrue() {
				return true;
			}

			// JQXLite.Event is based on DOM3 Events as specified by the ECMAScript Language Binding
			// http://www.w3.org/TR/2003/WD-DOM-Level-3-Events-20030331/ecma-script-binding.html
			JQXLite.Event.prototype = {
				preventDefault: function () {
					this.isDefaultPrevented = returnTrue;

					var e = this.originalEvent;
					if (!e) {
						return;
					}

					// if preventDefault exists run it on the original event
					if (e.preventDefault) {
						e.preventDefault();

						// otherwise set the returnValue property of the original event to false (IE)
					} else {
						e.returnValue = false;
					}
				},
				stopPropagation: function () {
					this.isPropagationStopped = returnTrue;

					var e = this.originalEvent;
					if (!e) {
						return;
					}
					// if stopPropagation exists run it on the original event
					if (e.stopPropagation) {
						e.stopPropagation();
					}
					// otherwise set the cancelBubble property of the original event to true (IE)
					e.cancelBubble = true;
				},
				stopImmediatePropagation: function () {
					this.isImmediatePropagationStopped = returnTrue;
					this.stopPropagation();
				},
				isDefaultPrevented: returnFalse,
				isPropagationStopped: returnFalse,
				isImmediatePropagationStopped: returnFalse
			};

			// Create mouseenter/leave events using mouseover/out and event-time checks
			JQXLite.each({
				mouseenter: "mouseover",
				mouseleave: "mouseout"
			}, function (orig, fix) {
				JQXLite.event.special[orig] = {
					delegateType: fix,
					bindType: fix,

					handle: function (event) {
						var ret,
							target = this,
							related = event.relatedTarget,
							handleObj = event.handleObj,
							selector = handleObj.selector;

						// For mousenter/leave call the handler if related is outside the target.
						// NB: No relatedTarget if the mouse left/entered the browser window
						if (!related || (related !== target && !JQXLite.contains(target, related))) {
							event.type = handleObj.origType;
							ret = handleObj.handler.apply(this, arguments);
							event.type = fix;
						}
						return ret;
					}
				};
			});

			JQXLite.fn.extend({

				on: function (types, selector, data, fn, /*INTERNAL*/ one) {
					var origFn, type;

					// Types can be a map of types/handlers
					if (typeof types === "object") {
						// ( types-Object, selector, data )
						if (typeof selector !== "string") { // && selector != null
							// ( types-Object, data )
							data = data || selector;
							selector = undefined;
						}
						for (type in types) {
							this.on(type, selector, data, types[type], one);
						}
						return this;
					}

					if (data == null && fn == null) {
						// ( types, fn )
						fn = selector;
						data = selector = undefined;
					} else if (fn == null) {
						if (typeof selector === "string") {
							// ( types, selector, fn )
							fn = data;
							data = undefined;
						} else {
							// ( types, data, fn )
							fn = data;
							data = selector;
							selector = undefined;
						}
					}
					if (fn === false) {
						fn = returnFalse;
					} else if (!fn) {
						return this;
					}

					if (one === 1) {
						origFn = fn;
						fn = function (event) {
							// Can use an empty set, since event contains the info
							JQXLite().off(event);
							return origFn.apply(this, arguments);
						};
						// Use same guid so caller can remove using origFn
						fn.guid = origFn.guid || (origFn.guid = JQXLite.guid++);
					}
					return this.each(function () {
						JQXLite.event.add(this, types, fn, data, selector);
					});
				},

				off: function (types, selector, fn) {
					var handleObj, type;
					if (types && types.preventDefault && types.handleObj) {
						// ( event )  dispatched JQXLite.Event
						handleObj = types.handleObj;
						JQXLite(types.delegateTarget).off(
							handleObj.namespace ? handleObj.origType + "." + handleObj.namespace : handleObj.origType,
							handleObj.selector,
							handleObj.handler
						);
						return this;
					}
					if (typeof types === "object") {
						// ( types-object [, selector] )
						for (type in types) {
							this.off(type, selector, types[type]);
						}
						return this;
					}
					if (selector === false || typeof selector === "function") {
						// ( types [, fn] )
						fn = selector;
						selector = undefined;
					}
					if (fn === false) {
						fn = returnFalse;
					}
					return this.each(function () {
						JQXLite.event.remove(this, types, fn, selector);
					});
				},

				delegate: function (selector, types, data, fn) {
					return this.on(types, selector, data, fn);
				},
				undelegate: function (selector, types, fn) {
					// ( namespace ) or ( selector, types [, fn] )
					return arguments.length === 1 ? this.off(selector, "**") : this.off(types, selector || "**", fn);
				},

				trigger: function (type, data) {
					return this.each(function () {
						JQXLite.event.trigger(type, data, this);
					});
				},
				triggerHandler: function (type, data) {
					if (this[0]) {
						return JQXLite.event.trigger(type, data, this[0], true);
					}
				},

				toggle: function (fn) {
					// Save reference to arguments for access in closure
					var args = arguments,
						guid = fn.guid || JQXLite.guid++,
						i = 0,
						toggler = function (event) {
							// Figure out which function to execute
							var lastToggle = (JQXLite._data(this, "lastToggle" + fn.guid) || 0) % i;
							JQXLite._data(this, "lastToggle" + fn.guid, lastToggle + 1);

							// Make sure that clicks stop
							event.preventDefault();

							// and execute the function
							return args[lastToggle].apply(this, arguments) || false;
						};

					// link all the functions, so any of them can unbind this click handler
					toggler.guid = guid;
					while (i < args.length) {
						args[i++].guid = guid;
					}

					return this.click(toggler);
				},

				hover: function (fnOver, fnOut) {
					return this.mouseenter(fnOver).mouseleave(fnOut || fnOver);
				}
			});

			JQXLite.each(("blur focus focusin focusout load resize scroll unload click dblclick " +
				"mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave " +
				"change select submit keydown keypress keyup error contextmenu").split(" "), function (i, name) {

					// Handle event binding
					JQXLite.fn[name] = function (data, fn) {
						if (fn == null) {
							fn = data;
							data = null;
						}

						return arguments.length > 0 ?
							this.on(name, null, data, fn) :
							this.trigger(name);
					};

					if (rkeyEvent.test(name)) {
						JQXLite.event.fixHooks[name] = JQXLite.event.keyHooks;
					}

					if (rmouseEvent.test(name)) {
						JQXLite.event.fixHooks[name] = JQXLite.event.mouseHooks;
					}
				});
			/*!
			 * Sizzle CSS Selector Engine
			 * Copyright 2012 JQXLite Foundation and other contributors
			 * Released under the MIT license
			 * http://sizzlejs.com/
			 */
			(function (window, undefined) {

				var cachedruns,
					assertGetIdNotName,
					Expr,
					getText,
					isXML,
					contains,
					compile,
					sortOrder,
					hasDuplicate,
					outermostContext,

					baseHasDuplicate = true,
					strundefined = "undefined",

					expando = ("sizcache" + Math.random()).replace(".", ""),

					Token = String,
					document = window.document,
					docElem = document.documentElement,
					dirruns = 0,
					done = 0,
					pop = [].pop,
					push = [].push,
					slice = [].slice,
					// Use a stripped-down indexOf if a native one is unavailable
					indexOf = [].indexOf || function (elem) {
						var i = 0,
							len = this.length;
						for (; i < len; i++) {
							if (this[i] === elem) {
								return i;
							}
						}
						return -1;
					},

					// Augment a function for special use by Sizzle
					markFunction = function (fn, value) {
						fn[expando] = value == null || value;
						return fn;
					},

					createCache = function () {
						var cache = {},
							keys = [];

						return markFunction(function (key, value) {
							// Only keep the most recent entries
							if (keys.push(key) > Expr.cacheLength) {
								delete cache[keys.shift()];
							}

							// Retrieve with (key + " ") to avoid collision with native Object.prototype properties (see Issue #157)
							return (cache[key + " "] = value);
						}, cache);
					},

					classCache = createCache(),
					tokenCache = createCache(),
					compilerCache = createCache(),

					// Regex

					// Whitespace characters http://www.w3.org/TR/css3-selectors/#whitespace
					whitespace = "[\\x20\\t\\r\\n\\f]",
					// http://www.w3.org/TR/css3-syntax/#characters
					characterEncoding = "(?:\\\\.|[-\\w]|[^\\x00-\\xa0])+",

					// Loosely modeled on CSS identifier characters
					// An unquoted value should be a CSS identifier (http://www.w3.org/TR/css3-selectors/#attribute-selectors)
					// Proper syntax: http://www.w3.org/TR/CSS21/syndata.html#value-def-identifier
					identifier = characterEncoding.replace("w", "w#"),

					// Acceptable operators http://www.w3.org/TR/selectors/#attribute-selectors
					operators = "([*^$|!~]?=)",
					attributes = "\\[" + whitespace + "*(" + characterEncoding + ")" + whitespace +
						"*(?:" + operators + whitespace + "*(?:(['\"])((?:\\\\.|[^\\\\])*?)\\3|(" + identifier + ")|)|)" + whitespace + "*\\]",

					// Prefer arguments not in parens/brackets,
					//   then attribute selectors and non-pseudos (denoted by :),
					//   then anything else
					// These preferences are here to reduce the number of selectors
					//   needing tokenize in the PSEUDO preFilter
					pseudos = ":(" + characterEncoding + ")(?:\\((?:(['\"])((?:\\\\.|[^\\\\])*?)\\2|([^()[\\]]*|(?:(?:" + attributes + ")|[^:]|\\\\.)*|.*))\\)|)",

					// For matchExpr.POS and matchExpr.needsContext
					pos = ":(even|odd|eq|gt|lt|nth|first|last)(?:\\(" + whitespace +
						"*((?:-\\d)?\\d*)" + whitespace + "*\\)|)(?=[^-]|$)",

					// Leading and non-escaped trailing whitespace, capturing some non-whitespace characters preceding the latter
					rtrim = new RegExp("^" + whitespace + "+|((?:^|[^\\\\])(?:\\\\.)*)" + whitespace + "+$", "g"),

					rcomma = new RegExp("^" + whitespace + "*," + whitespace + "*"),
					rcombinators = new RegExp("^" + whitespace + "*([\\x20\\t\\r\\n\\f>+~])" + whitespace + "*"),
					rpseudo = new RegExp(pseudos),

					// Easily-parseable/retrievable ID or TAG or CLASS selectors
					rquickExpr = /^(?:#([\w\-]+)|(\w+)|\.([\w\-]+))$/,

					rnot = /^:not/,
					rsibling = /[\x20\t\r\n\f]*[+~]/,
					rendsWithNot = /:not\($/,

					rheader = /h\d/i,
					rinputs = /input|select|textarea|button/i,

					rbackslash = /\\(?!\\)/g,

					matchExpr = {
						"ID": new RegExp("^#(" + characterEncoding + ")"),
						"CLASS": new RegExp("^\\.(" + characterEncoding + ")"),
						"NAME": new RegExp("^\\[name=['\"]?(" + characterEncoding + ")['\"]?\\]"),
						"TAG": new RegExp("^(" + characterEncoding.replace("w", "w*") + ")"),
						"ATTR": new RegExp("^" + attributes),
						"PSEUDO": new RegExp("^" + pseudos),
						"POS": new RegExp(pos, "i"),
						"CHILD": new RegExp("^:(only|nth|first|last)-child(?:\\(" + whitespace +
							"*(even|odd|(([+-]|)(\\d*)n|)" + whitespace + "*(?:([+-]|)" + whitespace +
							"*(\\d+)|))" + whitespace + "*\\)|)", "i"),
						// For use in libraries implementing .is()
						"needsContext": new RegExp("^" + whitespace + "*[>+~]|" + pos, "i")
					},

					// Support

					// Used for testing something on an element
					assert = function (fn) {
						var div = document.createElement("div");

						try {
							return fn(div);
						} catch (e) {
							return false;
						} finally {
							// release memory in IE
							div = null;
						}
					},

					// Check if getElementsByTagName("*") returns only elements
					assertTagNameNoComments = assert(function (div) {
						div.appendChild(document.createComment(""));
						return !div.getElementsByTagName("*").length;
					}),

					// Check if getAttribute returns normalized href attributes
					assertHrefNotNormalized = assert(function (div) {
						div.innerHTML = "<a href='#'></a>";
						return div.firstChild && typeof div.firstChild.getAttribute !== strundefined &&
							div.firstChild.getAttribute("href") === "#";
					}),

					// Check if attributes should be retrieved by attribute nodes
					assertAttributes = assert(function (div) {
						div.innerHTML = "<select></select>";
						var type = typeof div.lastChild.getAttribute("multiple");
						// IE8 returns a string for some attributes even when not present
						return type !== "boolean" && type !== "string";
					}),

					// Check if getElementsByClassName can be trusted
					assertUsableClassName = assert(function (div) {
						// Opera can't find a second classname (in 9.6)
						div.innerHTML = "<div class='hidden e'></div><div class='hidden'></div>";
						if (!div.getElementsByClassName || !div.getElementsByClassName("e").length) {
							return false;
						}

						// Safari 3.2 caches class attributes and doesn't catch changes
						div.lastChild.className = "e";
						return div.getElementsByClassName("e").length === 2;
					}),

					// Check if getElementById returns elements by name
					// Check if getElementsByName privileges form controls or returns elements by ID
					assertUsableName = assert(function (div) {
						// Inject content
						div.id = expando + 0;
						div.innerHTML = "<a name='" + expando + "'></a><div name='" + expando + "'></div>";
						docElem.insertBefore(div, docElem.firstChild);

						// Test
						var pass = document.getElementsByName &&
							// buggy browsers will return fewer than the correct 2
							document.getElementsByName(expando).length === 2 +
							// buggy browsers will return more than the correct 0
							document.getElementsByName(expando + 0).length;
						assertGetIdNotName = !document.getElementById(expando);

						// Cleanup
						docElem.removeChild(div);

						return pass;
					});

				// If slice is not available, provide a backup
				try {
					slice.call(docElem.childNodes, 0)[0].nodeType;
				} catch (e) {
					slice = function (i) {
						var elem,
							results = [];
						for (; (elem = this[i]); i++) {
							results.push(elem);
						}
						return results;
					};
				}

				function Sizzle(selector, context, results, seed) {
					results = results || [];
					context = context || document;
					var match, elem, xml, m,
						nodeType = context.nodeType;

					if (!selector || typeof selector !== "string") {
						return results;
					}

					if (nodeType !== 1 && nodeType !== 9) {
						return [];
					}

					xml = isXML(context);

					if (!xml && !seed) {
						if ((match = rquickExpr.exec(selector))) {
							// Speed-up: Sizzle("#ID")
							if ((m = match[1])) {
								if (nodeType === 9) {
									elem = context.getElementById(m);
									// Check parentNode to catch when Blackberry 4.6 returns
									// nodes that are no longer in the document #6963
									if (elem && elem.parentNode) {
										// Handle the case where IE, Opera, and Webkit return items
										// by name instead of ID
										if (elem.id === m) {
											results.push(elem);
											return results;
										}
									} else {
										return results;
									}
								} else {
									// Context is not a document
									if (context.ownerDocument && (elem = context.ownerDocument.getElementById(m)) &&
										contains(context, elem) && elem.id === m) {
										results.push(elem);
										return results;
									}
								}

								// Speed-up: Sizzle("TAG")
							} else if (match[2]) {
								push.apply(results, slice.call(context.getElementsByTagName(selector), 0));
								return results;

								// Speed-up: Sizzle(".CLASS")
							} else if ((m = match[3]) && assertUsableClassName && context.getElementsByClassName) {
								push.apply(results, slice.call(context.getElementsByClassName(m), 0));
								return results;
							}
						}
					}

					// All others
					return select(selector.replace(rtrim, "$1"), context, results, seed, xml);
				}

				Sizzle.matches = function (expr, elements) {
					return Sizzle(expr, null, null, elements);
				};

				Sizzle.matchesSelector = function (elem, expr) {
					return Sizzle(expr, null, null, [elem]).length > 0;
				};

				// Returns a function to use in pseudos for input types
				function createInputPseudo(type) {
					return function (elem) {
						var name = elem.nodeName.toLowerCase();
						return name === "input" && elem.type === type;
					};
				}

				// Returns a function to use in pseudos for buttons
				function createButtonPseudo(type) {
					return function (elem) {
						var name = elem.nodeName.toLowerCase();
						return (name === "input" || name === "button") && elem.type === type;
					};
				}

				// Returns a function to use in pseudos for positionals
				function createPositionalPseudo(fn) {
					return markFunction(function (argument) {
						argument = +argument;
						return markFunction(function (seed, matches) {
							var j,
								matchIndexes = fn([], seed.length, argument),
								i = matchIndexes.length;

							// Match elements found at the specified indexes
							while (i--) {
								if (seed[(j = matchIndexes[i])]) {
									seed[j] = !(matches[j] = seed[j]);
								}
							}
						});
					});
				}

				/**
				 * Utility function for retrieving the text value of an array of DOM nodes
				 * @param {Array|Element} elem
				 */
				getText = Sizzle.getText = function (elem) {
					var node,
						ret = "",
						i = 0,
						nodeType = elem.nodeType;

					if (nodeType) {
						if (nodeType === 1 || nodeType === 9 || nodeType === 11) {
							// Use textContent for elements
							// innerText usage removed for consistency of new lines (see #11153)
							if (typeof elem.textContent === "string") {
								return elem.textContent;
							} else {
								// Traverse its children
								for (elem = elem.firstChild; elem; elem = elem.nextSibling) {
									ret += getText(elem);
								}
							}
						} else if (nodeType === 3 || nodeType === 4) {
							return elem.nodeValue;
						}
						// Do not include comment or processing instruction nodes
					} else {

						// If no nodeType, this is expected to be an array
						for (; (node = elem[i]); i++) {
							// Do not traverse comment nodes
							ret += getText(node);
						}
					}
					return ret;
				};

				isXML = Sizzle.isXML = function (elem) {
					// documentElement is verified for cases where it doesn't yet exist
					// (such as loading iframes in IE - #4833)
					var documentElement = elem && (elem.ownerDocument || elem).documentElement;
					return documentElement ? documentElement.nodeName !== "HTML" : false;
				};

				// Element contains another
				contains = Sizzle.contains = docElem.contains ?
					function (a, b) {
						var adown = a.nodeType === 9 ? a.documentElement : a,
							bup = b && b.parentNode;
						return a === bup || !!(bup && bup.nodeType === 1 && adown.contains && adown.contains(bup));
					} :
					docElem.compareDocumentPosition ?
						function (a, b) {
							return b && !!(a.compareDocumentPosition(b) & 16);
						} :
						function (a, b) {
							while ((b = b.parentNode)) {
								if (b === a) {
									return true;
								}
							}
							return false;
						};

				Sizzle.attr = function (elem, name) {
					var val,
						xml = isXML(elem);

					if (!xml) {
						name = name.toLowerCase();
					}
					if ((val = Expr.attrHandle[name])) {
						return val(elem);
					}
					if (xml || assertAttributes) {
						return elem.getAttribute(name);
					}
					val = elem.getAttributeNode(name);
					return val ?
						typeof elem[name] === "boolean" ?
							elem[name] ? name : null :
							val.specified ? val.value : null :
						null;
				};

				Expr = Sizzle.selectors = {

					// Can be adjusted by the user
					cacheLength: 50,

					createPseudo: markFunction,

					match: matchExpr,

					// IE6/7 return a modified href
					attrHandle: assertHrefNotNormalized ?
						{} :
						{
							"href": function (elem) {
								return elem.getAttribute("href", 2);
							},
							"type": function (elem) {
								return elem.getAttribute("type");
							}
						},

					find: {
						"ID": assertGetIdNotName ?
							function (id, context, xml) {
								if (typeof context.getElementById !== strundefined && !xml) {
									var m = context.getElementById(id);
									// Check parentNode to catch when Blackberry 4.6 returns
									// nodes that are no longer in the document #6963
									return m && m.parentNode ? [m] : [];
								}
							} :
							function (id, context, xml) {
								if (typeof context.getElementById !== strundefined && !xml) {
									var m = context.getElementById(id);

									return m ?
										m.id === id || typeof m.getAttributeNode !== strundefined && m.getAttributeNode("id").value === id ?
											[m] :
											undefined :
										[];
								}
							},

						"TAG": assertTagNameNoComments ?
							function (tag, context) {
								if (typeof context.getElementsByTagName !== strundefined) {
									return context.getElementsByTagName(tag);
								}
							} :
							function (tag, context) {
								var results = context.getElementsByTagName(tag);

								// Filter out possible comments
								if (tag === "*") {
									var elem,
										tmp = [],
										i = 0;

									for (; (elem = results[i]); i++) {
										if (elem.nodeType === 1) {
											tmp.push(elem);
										}
									}

									return tmp;
								}
								return results;
							},

						"NAME": assertUsableName && function (tag, context) {
							if (typeof context.getElementsByName !== strundefined) {
								return context.getElementsByName(name);
							}
						},

						"CLASS": assertUsableClassName && function (className, context, xml) {
							if (typeof context.getElementsByClassName !== strundefined && !xml) {
								return context.getElementsByClassName(className);
							}
						}
					},

					relative: {
						">": { dir: "parentNode", first: true },
						" ": { dir: "parentNode" },
						"+": { dir: "previousSibling", first: true },
						"~": { dir: "previousSibling" }
					},

					preFilter: {
						"ATTR": function (match) {
							match[1] = match[1].replace(rbackslash, "");

							// Move the given value to match[3] whether quoted or unquoted
							match[3] = (match[4] || match[5] || "").replace(rbackslash, "");

							if (match[2] === "~=") {
								match[3] = " " + match[3] + " ";
							}

							return match.slice(0, 4);
						},

						"CHILD": function (match) {
							/* matches from matchExpr["CHILD"]
								1 type (only|nth|...)
								2 argument (even|odd|\d*|\d*n([+-]\d+)?|...)
								3 xn-component of xn+y argument ([+-]?\d*n|)
								4 sign of xn-component
								5 x of xn-component
								6 sign of y-component
								7 y of y-component
							*/
							match[1] = match[1].toLowerCase();

							if (match[1] === "nth") {
								// nth-child requires argument
								if (!match[2]) {
									Sizzle.error(match[0]);
								}

								// numeric x and y parameters for Expr.filter.CHILD
								// remember that false/true cast respectively to 0/1
								match[3] = +(match[3] ? match[4] + (match[5] || 1) : 2 * (match[2] === "even" || match[2] === "odd"));
								match[4] = +((match[6] + match[7]) || match[2] === "odd");

								// other types prohibit arguments
							} else if (match[2]) {
								Sizzle.error(match[0]);
							}

							return match;
						},

						"PSEUDO": function (match) {
							var unquoted, excess;
							if (matchExpr["CHILD"].test(match[0])) {
								return null;
							}

							if (match[3]) {
								match[2] = match[3];
							} else if ((unquoted = match[4])) {
								// Only check arguments that contain a pseudo
								if (rpseudo.test(unquoted) &&
									// Get excess from tokenize (recursively)
									(excess = tokenize(unquoted, true)) &&
									// advance to the next closing parenthesis
									(excess = unquoted.indexOf(")", unquoted.length - excess) - unquoted.length)) {

									// excess is a negative index
									unquoted = unquoted.slice(0, excess);
									match[0] = match[0].slice(0, excess);
								}
								match[2] = unquoted;
							}

							// Return only captures needed by the pseudo filter method (type and argument)
							return match.slice(0, 3);
						}
					},

					filter: {
						"ID": assertGetIdNotName ?
							function (id) {
								id = id.replace(rbackslash, "");
								return function (elem) {
									return elem.getAttribute("id") === id;
								};
							} :
							function (id) {
								id = id.replace(rbackslash, "");
								return function (elem) {
									var node = typeof elem.getAttributeNode !== strundefined && elem.getAttributeNode("id");
									return node && node.value === id;
								};
							},

						"TAG": function (nodeName) {
							if (nodeName === "*") {
								return function () { return true; };
							}
							nodeName = nodeName.replace(rbackslash, "").toLowerCase();

							return function (elem) {
								return elem.nodeName && elem.nodeName.toLowerCase() === nodeName;
							};
						},

						"CLASS": function (className) {
							var pattern = classCache[expando][className + " "];

							return pattern ||
								(pattern = new RegExp("(^|" + whitespace + ")" + className + "(" + whitespace + "|$)")) &&
								classCache(className, function (elem) {
									return pattern.test(elem.className || (typeof elem.getAttribute !== strundefined && elem.getAttribute("class")) || "");
								});
						},

						"ATTR": function (name, operator, check) {
							return function (elem, context) {
								var result = Sizzle.attr(elem, name);

								if (result == null) {
									return operator === "!=";
								}
								if (!operator) {
									return true;
								}

								result += "";

								return operator === "=" ? result === check :
									operator === "!=" ? result !== check :
										operator === "^=" ? check && result.indexOf(check) === 0 :
											operator === "*=" ? check && result.indexOf(check) > -1 :
												operator === "$=" ? check && result.substr(result.length - check.length) === check :
													operator === "~=" ? (" " + result + " ").indexOf(check) > -1 :
														operator === "|=" ? result === check || result.substr(0, check.length + 1) === check + "-" :
															false;
							};
						},

						"CHILD": function (type, argument, first, last) {

							if (type === "nth") {
								return function (elem) {
									var node, diff,
										parent = elem.parentNode;

									if (first === 1 && last === 0) {
										return true;
									}

									if (parent) {
										diff = 0;
										for (node = parent.firstChild; node; node = node.nextSibling) {
											if (node.nodeType === 1) {
												diff++;
												if (elem === node) {
													break;
												}
											}
										}
									}

									// Incorporate the offset (or cast to NaN), then check against cycle size
									diff -= last;
									return diff === first || (diff % first === 0 && diff / first >= 0);
								};
							}

							return function (elem) {
								var node = elem;

								switch (type) {
									case "only":
									case "first":
										while ((node = node.previousSibling)) {
											if (node.nodeType === 1) {
												return false;
											}
										}

										if (type === "first") {
											return true;
										}

										node = elem;

									/* falls through */
									case "last":
										while ((node = node.nextSibling)) {
											if (node.nodeType === 1) {
												return false;
											}
										}

										return true;
								}
							};
						},

						"PSEUDO": function (pseudo, argument) {
							// pseudo-class names are case-insensitive
							// http://www.w3.org/TR/selectors/#pseudo-classes
							// Prioritize by case sensitivity in case custom pseudos are added with uppercase letters
							// Remember that setFilters inherits from pseudos
							var args,
								fn = Expr.pseudos[pseudo] || Expr.setFilters[pseudo.toLowerCase()] ||
									Sizzle.error("unsupported pseudo: " + pseudo);

							// The user may use createPseudo to indicate that
							// arguments are needed to create the filter function
							// just as Sizzle does
							if (fn[expando]) {
								return fn(argument);
							}

							// But maintain support for old signatures
							if (fn.length > 1) {
								args = [pseudo, pseudo, "", argument];
								return Expr.setFilters.hasOwnProperty(pseudo.toLowerCase()) ?
									markFunction(function (seed, matches) {
										var idx,
											matched = fn(seed, argument),
											i = matched.length;
										while (i--) {
											idx = indexOf.call(seed, matched[i]);
											seed[idx] = !(matches[idx] = matched[i]);
										}
									}) :
									function (elem) {
										return fn(elem, 0, args);
									};
							}

							return fn;
						}
					},

					pseudos: {
						"not": markFunction(function (selector) {
							// Trim the selector passed to compile
							// to avoid treating leading and trailing
							// spaces as combinators
							var input = [],
								results = [],
								matcher = compile(selector.replace(rtrim, "$1"));

							return matcher[expando] ?
								markFunction(function (seed, matches, context, xml) {
									var elem,
										unmatched = matcher(seed, null, xml, []),
										i = seed.length;

									// Match elements unmatched by `matcher`
									while (i--) {
										if ((elem = unmatched[i])) {
											seed[i] = !(matches[i] = elem);
										}
									}
								}) :
								function (elem, context, xml) {
									input[0] = elem;
									matcher(input, null, xml, results);
									return !results.pop();
								};
						}),

						"has": markFunction(function (selector) {
							return function (elem) {
								return Sizzle(selector, elem).length > 0;
							};
						}),

						"contains": markFunction(function (text) {
							return function (elem) {
								return (elem.textContent || elem.innerText || getText(elem)).indexOf(text) > -1;
							};
						}),

						"enabled": function (elem) {
							return elem.disabled === false;
						},

						"disabled": function (elem) {
							return elem.disabled === true;
						},

						"checked": function (elem) {
							// In CSS3, :checked should return both checked and selected elements
							// http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
							var nodeName = elem.nodeName.toLowerCase();
							return (nodeName === "input" && !!elem.checked) || (nodeName === "option" && !!elem.selected);
						},

						"selected": function (elem) {
							// Accessing this property makes selected-by-default
							// options in Safari work properly
							if (elem.parentNode) {
								elem.parentNode.selectedIndex;
							}

							return elem.selected === true;
						},

						"parent": function (elem) {
							return !Expr.pseudos["empty"](elem);
						},

						"empty": function (elem) {
							// http://www.w3.org/TR/selectors/#empty-pseudo
							// :empty is only affected by element nodes and content nodes(including text(3), cdata(4)),
							//   not comment, processing instructions, or others
							// Thanks to Diego Perini for the nodeName shortcut
							//   Greater than "@" means alpha characters (specifically not starting with "#" or "?")
							var nodeType;
							elem = elem.firstChild;
							while (elem) {
								if (elem.nodeName > "@" || (nodeType = elem.nodeType) === 3 || nodeType === 4) {
									return false;
								}
								elem = elem.nextSibling;
							}
							return true;
						},

						"header": function (elem) {
							return rheader.test(elem.nodeName);
						},

						"text": function (elem) {
							var type, attr;
							// IE6 and 7 will map elem.type to 'text' for new HTML5 types (search, etc)
							// use getAttribute instead to test this case
							return elem.nodeName.toLowerCase() === "input" &&
								(type = elem.type) === "text" &&
								((attr = elem.getAttribute("type")) == null || attr.toLowerCase() === type);
						},

						// Input types
						"radio": createInputPseudo("radio"),
						"checkbox": createInputPseudo("checkbox"),
						"file": createInputPseudo("file"),
						"password": createInputPseudo("password"),
						"image": createInputPseudo("image"),

						"submit": createButtonPseudo("submit"),
						"reset": createButtonPseudo("reset"),

						"button": function (elem) {
							var name = elem.nodeName.toLowerCase();
							return name === "input" && elem.type === "button" || name === "button";
						},

						"input": function (elem) {
							return rinputs.test(elem.nodeName);
						},

						"focus": function (elem) {
							var doc = elem.ownerDocument;
							return elem === doc.activeElement && (!doc.hasFocus || doc.hasFocus()) && !!(elem.type || elem.href || ~elem.tabIndex);
						},

						"active": function (elem) {
							return elem === elem.ownerDocument.activeElement;
						},

						// Positional types
						"first": createPositionalPseudo(function () {
							return [0];
						}),

						"last": createPositionalPseudo(function (matchIndexes, length) {
							return [length - 1];
						}),

						"eq": createPositionalPseudo(function (matchIndexes, length, argument) {
							return [argument < 0 ? argument + length : argument];
						}),

						"even": createPositionalPseudo(function (matchIndexes, length) {
							for (var i = 0; i < length; i += 2) {
								matchIndexes.push(i);
							}
							return matchIndexes;
						}),

						"odd": createPositionalPseudo(function (matchIndexes, length) {
							for (var i = 1; i < length; i += 2) {
								matchIndexes.push(i);
							}
							return matchIndexes;
						}),

						"lt": createPositionalPseudo(function (matchIndexes, length, argument) {
							for (var i = argument < 0 ? argument + length : argument; --i >= 0;) {
								matchIndexes.push(i);
							}
							return matchIndexes;
						}),

						"gt": createPositionalPseudo(function (matchIndexes, length, argument) {
							for (var i = argument < 0 ? argument + length : argument; ++i < length;) {
								matchIndexes.push(i);
							}
							return matchIndexes;
						})
					}
				};

				function siblingCheck(a, b, ret) {
					if (a === b) {
						return ret;
					}

					var cur = a.nextSibling;

					while (cur) {
						if (cur === b) {
							return -1;
						}

						cur = cur.nextSibling;
					}

					return 1;
				}

				sortOrder = docElem.compareDocumentPosition ?
					function (a, b) {
						if (a === b) {
							hasDuplicate = true;
							return 0;
						}

						return (!a.compareDocumentPosition || !b.compareDocumentPosition ?
							a.compareDocumentPosition :
							a.compareDocumentPosition(b) & 4
						) ? -1 : 1;
					} :
					function (a, b) {
						// The nodes are identical, we can exit early
						if (a === b) {
							hasDuplicate = true;
							return 0;

							// Fallback to using sourceIndex (in IE) if it's available on both nodes
						} else if (a.sourceIndex && b.sourceIndex) {
							return a.sourceIndex - b.sourceIndex;
						}

						var al, bl,
							ap = [],
							bp = [],
							aup = a.parentNode,
							bup = b.parentNode,
							cur = aup;

						// If the nodes are siblings (or identical) we can do a quick check
						if (aup === bup) {
							return siblingCheck(a, b);

							// If no parents were found then the nodes are disconnected
						} else if (!aup) {
							return -1;

						} else if (!bup) {
							return 1;
						}

						// Otherwise they're somewhere else in the tree so we need
						// to build up a full list of the parentNodes for comparison
						while (cur) {
							ap.unshift(cur);
							cur = cur.parentNode;
						}

						cur = bup;

						while (cur) {
							bp.unshift(cur);
							cur = cur.parentNode;
						}

						al = ap.length;
						bl = bp.length;

						// Start walking down the tree looking for a discrepancy
						for (var i = 0; i < al && i < bl; i++) {
							if (ap[i] !== bp[i]) {
								return siblingCheck(ap[i], bp[i]);
							}
						}

						// We ended someplace up the tree so do a sibling check
						return i === al ?
							siblingCheck(a, bp[i], -1) :
							siblingCheck(ap[i], b, 1);
					};

				// Always assume the presence of duplicates if sort doesn't
				// pass them to our comparison function (as in Google Chrome).
				[0, 0].sort(sortOrder);
				baseHasDuplicate = !hasDuplicate;

				// Document sorting and removing duplicates
				Sizzle.uniqueSort = function (results) {
					var elem,
						duplicates = [],
						i = 1,
						j = 0;

					hasDuplicate = baseHasDuplicate;
					results.sort(sortOrder);

					if (hasDuplicate) {
						for (; (elem = results[i]); i++) {
							if (elem === results[i - 1]) {
								j = duplicates.push(i);
							}
						}
						while (j--) {
							results.splice(duplicates[j], 1);
						}
					}

					return results;
				};

				Sizzle.error = function (msg) {
					throw new Error("Syntax error, unrecognized expression: " + msg);
				};

				function tokenize(selector, parseOnly) {
					var matched, match, tokens, type,
						soFar, groups, preFilters,
						cached = tokenCache[expando][selector + " "];

					if (cached) {
						return parseOnly ? 0 : cached.slice(0);
					}

					soFar = selector;
					groups = [];
					preFilters = Expr.preFilter;

					while (soFar) {

						// Comma and first run
						if (!matched || (match = rcomma.exec(soFar))) {
							if (match) {
								// Don't consume trailing commas as valid
								soFar = soFar.slice(match[0].length) || soFar;
							}
							groups.push(tokens = []);
						}

						matched = false;

						// Combinators
						if ((match = rcombinators.exec(soFar))) {
							tokens.push(matched = new Token(match.shift()));
							soFar = soFar.slice(matched.length);

							// Cast descendant combinators to space
							matched.type = match[0].replace(rtrim, " ");
						}

						// Filters
						for (type in Expr.filter) {
							if ((match = matchExpr[type].exec(soFar)) && (!preFilters[type] ||
								(match = preFilters[type](match)))) {

								tokens.push(matched = new Token(match.shift()));
								soFar = soFar.slice(matched.length);
								matched.type = type;
								matched.matches = match;
							}
						}

						if (!matched) {
							break;
						}
					}

					// Return the length of the invalid excess
					// if we're just parsing
					// Otherwise, throw an error or return tokens
					return parseOnly ?
						soFar.length :
						soFar ?
							Sizzle.error(selector) :
							// Cache the tokens
							tokenCache(selector, groups).slice(0);
				}

				function addCombinator(matcher, combinator, base) {
					var dir = combinator.dir,
						checkNonElements = base && combinator.dir === "parentNode",
						doneName = done++;

					return combinator.first ?
						// Check against closest ancestor/preceding element
						function (elem, context, xml) {
							while ((elem = elem[dir])) {
								if (checkNonElements || elem.nodeType === 1) {
									return matcher(elem, context, xml);
								}
							}
						} :

						// Check against all ancestor/preceding elements
						function (elem, context, xml) {
							// We can't set arbitrary data on XML nodes, so they don't benefit from dir caching
							if (!xml) {
								var cache,
									dirkey = dirruns + " " + doneName + " ",
									cachedkey = dirkey + cachedruns;
								while ((elem = elem[dir])) {
									if (checkNonElements || elem.nodeType === 1) {
										if ((cache = elem[expando]) === cachedkey) {
											return elem.sizset;
										} else if (typeof cache === "string" && cache.indexOf(dirkey) === 0) {
											if (elem.sizset) {
												return elem;
											}
										} else {
											elem[expando] = cachedkey;
											if (matcher(elem, context, xml)) {
												elem.sizset = true;
												return elem;
											}
											elem.sizset = false;
										}
									}
								}
							} else {
								while ((elem = elem[dir])) {
									if (checkNonElements || elem.nodeType === 1) {
										if (matcher(elem, context, xml)) {
											return elem;
										}
									}
								}
							}
						};
				}

				function elementMatcher(matchers) {
					return matchers.length > 1 ?
						function (elem, context, xml) {
							var i = matchers.length;
							while (i--) {
								if (!matchers[i](elem, context, xml)) {
									return false;
								}
							}
							return true;
						} :
						matchers[0];
				}

				function condense(unmatched, map, filter, context, xml) {
					var elem,
						newUnmatched = [],
						i = 0,
						len = unmatched.length,
						mapped = map != null;

					for (; i < len; i++) {
						if ((elem = unmatched[i])) {
							if (!filter || filter(elem, context, xml)) {
								newUnmatched.push(elem);
								if (mapped) {
									map.push(i);
								}
							}
						}
					}

					return newUnmatched;
				}

				function setMatcher(preFilter, selector, matcher, postFilter, postFinder, postSelector) {
					if (postFilter && !postFilter[expando]) {
						postFilter = setMatcher(postFilter);
					}
					if (postFinder && !postFinder[expando]) {
						postFinder = setMatcher(postFinder, postSelector);
					}
					return markFunction(function (seed, results, context, xml) {
						var temp, i, elem,
							preMap = [],
							postMap = [],
							preexisting = results.length,

							// Get initial elements from seed or context
							elems = seed || multipleContexts(selector || "*", context.nodeType ? [context] : context, []),

							// Prefilter to get matcher input, preserving a map for seed-results synchronization
							matcherIn = preFilter && (seed || !selector) ?
								condense(elems, preMap, preFilter, context, xml) :
								elems,

							matcherOut = matcher ?
								// If we have a postFinder, or filtered seed, or non-seed postFilter or preexisting results,
								postFinder || (seed ? preFilter : preexisting || postFilter) ?

									// ...intermediate processing is necessary
									[] :

									// ...otherwise use results directly
									results :
								matcherIn;

						// Find primary matches
						if (matcher) {
							matcher(matcherIn, matcherOut, context, xml);
						}

						// Apply postFilter
						if (postFilter) {
							temp = condense(matcherOut, postMap);
							postFilter(temp, [], context, xml);

							// Un-match failing elements by moving them back to matcherIn
							i = temp.length;
							while (i--) {
								if ((elem = temp[i])) {
									matcherOut[postMap[i]] = !(matcherIn[postMap[i]] = elem);
								}
							}
						}

						if (seed) {
							if (postFinder || preFilter) {
								if (postFinder) {
									// Get the final matcherOut by condensing this intermediate into postFinder contexts
									temp = [];
									i = matcherOut.length;
									while (i--) {
										if ((elem = matcherOut[i])) {
											// Restore matcherIn since elem is not yet a final match
											temp.push((matcherIn[i] = elem));
										}
									}
									postFinder(null, (matcherOut = []), temp, xml);
								}

								// Move matched elements from seed to results to keep them synchronized
								i = matcherOut.length;
								while (i--) {
									if ((elem = matcherOut[i]) &&
										(temp = postFinder ? indexOf.call(seed, elem) : preMap[i]) > -1) {

										seed[temp] = !(results[temp] = elem);
									}
								}
							}

							// Add elements to results, through postFinder if defined
						} else {
							matcherOut = condense(
								matcherOut === results ?
									matcherOut.splice(preexisting, matcherOut.length) :
									matcherOut
							);
							if (postFinder) {
								postFinder(null, results, matcherOut, xml);
							} else {
								push.apply(results, matcherOut);
							}
						}
					});
				}

				function matcherFromTokens(tokens) {
					var checkContext, matcher, j,
						len = tokens.length,
						leadingRelative = Expr.relative[tokens[0].type],
						implicitRelative = leadingRelative || Expr.relative[" "],
						i = leadingRelative ? 1 : 0,

						// The foundational matcher ensures that elements are reachable from top-level context(s)
						matchContext = addCombinator(function (elem) {
							return elem === checkContext;
						}, implicitRelative, true),
						matchAnyContext = addCombinator(function (elem) {
							return indexOf.call(checkContext, elem) > -1;
						}, implicitRelative, true),
						matchers = [function (elem, context, xml) {
							return (!leadingRelative && (xml || context !== outermostContext)) || (
								(checkContext = context).nodeType ?
									matchContext(elem, context, xml) :
									matchAnyContext(elem, context, xml));
						}];

					for (; i < len; i++) {
						if ((matcher = Expr.relative[tokens[i].type])) {
							matchers = [addCombinator(elementMatcher(matchers), matcher)];
						} else {
							matcher = Expr.filter[tokens[i].type].apply(null, tokens[i].matches);

							// Return special upon seeing a positional matcher
							if (matcher[expando]) {
								// Find the next relative operator (if any) for proper handling
								j = ++i;
								for (; j < len; j++) {
									if (Expr.relative[tokens[j].type]) {
										break;
									}
								}
								return setMatcher(
									i > 1 && elementMatcher(matchers),
									i > 1 && tokens.slice(0, i - 1).join("").replace(rtrim, "$1"),
									matcher,
									i < j && matcherFromTokens(tokens.slice(i, j)),
									j < len && matcherFromTokens((tokens = tokens.slice(j))),
									j < len && tokens.join("")
								);
							}
							matchers.push(matcher);
						}
					}

					return elementMatcher(matchers);
				}

				function matcherFromGroupMatchers(elementMatchers, setMatchers) {
					var bySet = setMatchers.length > 0,
						byElement = elementMatchers.length > 0,
						superMatcher = function (seed, context, xml, results, expandContext) {
							var elem, j, matcher,
								setMatched = [],
								matchedCount = 0,
								i = "0",
								unmatched = seed && [],
								outermost = expandContext != null,
								contextBackup = outermostContext,
								// We must always have either seed elements or context
								elems = seed || byElement && Expr.find["TAG"]("*", expandContext && context.parentNode || context),
								// Nested matchers should use non-integer dirruns
								dirrunsUnique = (dirruns += contextBackup == null ? 1 : Math.E);

							if (outermost) {
								outermostContext = context !== document && context;
								cachedruns = superMatcher.el;
							}

							// Add elements passing elementMatchers directly to results
							for (; (elem = elems[i]) != null; i++) {
								if (byElement && elem) {
									for (j = 0; (matcher = elementMatchers[j]); j++) {
										if (matcher(elem, context, xml)) {
											results.push(elem);
											break;
										}
									}
									if (outermost) {
										dirruns = dirrunsUnique;
										cachedruns = ++superMatcher.el;
									}
								}

								// Track unmatched elements for set filters
								if (bySet) {
									// They will have gone through all possible matchers
									if ((elem = !matcher && elem)) {
										matchedCount--;
									}

									// Lengthen the array for every element, matched or not
									if (seed) {
										unmatched.push(elem);
									}
								}
							}

							// Apply set filters to unmatched elements
							matchedCount += i;
							if (bySet && i !== matchedCount) {
								for (j = 0; (matcher = setMatchers[j]); j++) {
									matcher(unmatched, setMatched, context, xml);
								}

								if (seed) {
									// Reintegrate element matches to eliminate the need for sorting
									if (matchedCount > 0) {
										while (i--) {
											if (!(unmatched[i] || setMatched[i])) {
												setMatched[i] = pop.call(results);
											}
										}
									}

									// Discard index placeholder values to get only actual matches
									setMatched = condense(setMatched);
								}

								// Add matches to results
								push.apply(results, setMatched);

								// Seedless set matches succeeding multiple successful matchers stipulate sorting
								if (outermost && !seed && setMatched.length > 0 &&
									(matchedCount + setMatchers.length) > 1) {

									Sizzle.uniqueSort(results);
								}
							}

							// Override manipulation of globals by nested matchers
							if (outermost) {
								dirruns = dirrunsUnique;
								outermostContext = contextBackup;
							}

							return unmatched;
						};

					superMatcher.el = 0;
					return bySet ?
						markFunction(superMatcher) :
						superMatcher;
				}

				compile = Sizzle.compile = function (selector, group /* Internal Use Only */) {
					var i,
						setMatchers = [],
						elementMatchers = [],
						cached = compilerCache[expando][selector + " "];

					if (!cached) {
						// Generate a function of recursive functions that can be used to check each element
						if (!group) {
							group = tokenize(selector);
						}
						i = group.length;
						while (i--) {
							cached = matcherFromTokens(group[i]);
							if (cached[expando]) {
								setMatchers.push(cached);
							} else {
								elementMatchers.push(cached);
							}
						}

						// Cache the compiled function
						cached = compilerCache(selector, matcherFromGroupMatchers(elementMatchers, setMatchers));
					}
					return cached;
				};

				function multipleContexts(selector, contexts, results) {
					var i = 0,
						len = contexts.length;
					for (; i < len; i++) {
						Sizzle(selector, contexts[i], results);
					}
					return results;
				}

				function select(selector, context, results, seed, xml) {
					var i, tokens, token, type, find,
						match = tokenize(selector),
						j = match.length;

					if (!seed) {
						// Try to minimize operations if there is only one group
						if (match.length === 1) {

							// Take a shortcut and set the context if the root selector is an ID
							tokens = match[0] = match[0].slice(0);
							if (tokens.length > 2 && (token = tokens[0]).type === "ID" &&
								context.nodeType === 9 && !xml &&
								Expr.relative[tokens[1].type]) {

								context = Expr.find["ID"](token.matches[0].replace(rbackslash, ""), context, xml)[0];
								if (!context) {
									return results;
								}

								selector = selector.slice(tokens.shift().length);
							}

							// Fetch a seed set for right-to-left matching
							for (i = matchExpr["POS"].test(selector) ? -1 : tokens.length - 1; i >= 0; i--) {
								token = tokens[i];

								// Abort if we hit a combinator
								if (Expr.relative[(type = token.type)]) {
									break;
								}
								if ((find = Expr.find[type])) {
									// Search, expanding context for leading sibling combinators
									if ((seed = find(
										token.matches[0].replace(rbackslash, ""),
										rsibling.test(tokens[0].type) && context.parentNode || context,
										xml
									))) {

										// If seed is empty or no tokens remain, we can return early
										tokens.splice(i, 1);
										selector = seed.length && tokens.join("");
										if (!selector) {
											push.apply(results, slice.call(seed, 0));
											return results;
										}

										break;
									}
								}
							}
						}
					}

					// Compile and execute a filtering function
					// Provide `match` to avoid retokenization if we modified the selector above
					compile(selector, match)(
						seed,
						context,
						xml,
						results,
						rsibling.test(selector)
					);
					return results;
				}

				if (document.querySelectorAll) {
					(function () {
						var disconnectedMatch,
							oldSelect = select,
							rescape = /'|\\/g,
							rattributeQuotes = /\=[\x20\t\r\n\f]*([^'"\]]*)[\x20\t\r\n\f]*\]/g,

							// qSa(:focus) reports false when true (Chrome 21), no need to also add to buggyMatches since matches checks buggyQSA
							// A support test would require too much code (would include document ready)
							rbuggyQSA = [":focus"],

							// matchesSelector(:active) reports false when true (IE9/Opera 11.5)
							// A support test would require too much code (would include document ready)
							// just skip matchesSelector for :active
							rbuggyMatches = [":active"],
							matches = docElem.matchesSelector ||
								docElem.mozMatchesSelector ||
								docElem.webkitMatchesSelector ||
								docElem.oMatchesSelector ||
								docElem.msMatchesSelector;

						// Build QSA regex
						// Regex strategy adopted from Diego Perini
						assert(function (div) {
							// Select is set to empty string on purpose
							// This is to test IE's treatment of not explictly
							// setting a boolean content attribute,
							// since its presence should be enough
							// http://bugs.jqx.com/ticket/12359
							div.innerHTML = "<select><option selected=''></option></select>";

							// IE8 - Some boolean attributes are not treated correctly
							if (!div.querySelectorAll("[selected]").length) {
								rbuggyQSA.push("\\[" + whitespace + "*(?:checked|disabled|ismap|multiple|readonly|selected|value)");
							}

							// Webkit/Opera - :checked should return selected option elements
							// http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
							// IE8 throws error here (do not put tests after this one)
							if (!div.querySelectorAll(":checked").length) {
								rbuggyQSA.push(":checked");
							}
						});

						assert(function (div) {

							// Opera 10-12/IE9 - ^= $= *= and empty values
							// Should not select anything
							div.innerHTML = "<p test=''></p>";
							if (div.querySelectorAll("[test^='']").length) {
								rbuggyQSA.push("[*^$]=" + whitespace + "*(?:\"\"|'')");
							}

							// FF 3.5 - :enabled/:disabled and hidden elements (hidden elements are still enabled)
							// IE8 throws error here (do not put tests after this one)
							div.innerHTML = "<input type='hidden'/>";
							if (!div.querySelectorAll(":enabled").length) {
								rbuggyQSA.push(":enabled", ":disabled");
							}
						});

						// rbuggyQSA always contains :focus, so no need for a length check
						rbuggyQSA = /* rbuggyQSA.length && */ new RegExp(rbuggyQSA.join("|"));

						select = function (selector, context, results, seed, xml) {
							// Only use querySelectorAll when not filtering,
							// when this is not xml,
							// and when no QSA bugs apply
							if (!seed && !xml && !rbuggyQSA.test(selector)) {
								var groups, i,
									old = true,
									nid = expando,
									newContext = context,
									newSelector = context.nodeType === 9 && selector;

								// qSA works strangely on Element-rooted queries
								// We can work around this by specifying an extra ID on the root
								// and working up from there (Thanks to Andrew Dupont for the technique)
								// IE 8 doesn't work on object elements
								if (context.nodeType === 1 && context.nodeName.toLowerCase() !== "object") {
									groups = tokenize(selector);

									if ((old = context.getAttribute("id"))) {
										nid = old.replace(rescape, "\\$&");
									} else {
										context.setAttribute("id", nid);
									}
									nid = "[id='" + nid + "'] ";

									i = groups.length;
									while (i--) {
										groups[i] = nid + groups[i].join("");
									}
									newContext = rsibling.test(selector) && context.parentNode || context;
									newSelector = groups.join(",");
								}

								if (newSelector) {
									try {
										push.apply(results, slice.call(newContext.querySelectorAll(
											newSelector
										), 0));
										return results;
									} catch (qsaError) {
									} finally {
										if (!old) {
											context.removeAttribute("id");
										}
									}
								}
							}

							return oldSelect(selector, context, results, seed, xml);
						};

						if (matches) {
							assert(function (div) {
								// Check to see if it's possible to do matchesSelector
								// on a disconnected node (IE 9)
								disconnectedMatch = matches.call(div, "div");

								// This should fail with an exception
								// Gecko does not error, returns false instead
								try {
									matches.call(div, "[test!='']:sizzle");
									rbuggyMatches.push("!=", pseudos);
								} catch (e) { }
							});

							// rbuggyMatches always contains :active and :focus, so no need for a length check
							rbuggyMatches = /* rbuggyMatches.length && */ new RegExp(rbuggyMatches.join("|"));

							Sizzle.matchesSelector = function (elem, expr) {
								// Make sure that attribute selectors are quoted
								expr = expr.replace(rattributeQuotes, "='$1']");

								// rbuggyMatches always contains :active, so no need for an existence check
								if (!isXML(elem) && !rbuggyMatches.test(expr) && !rbuggyQSA.test(expr)) {
									try {
										var ret = matches.call(elem, expr);

										// IE 9's matchesSelector returns false on disconnected nodes
										if (ret || disconnectedMatch ||
											// As well, disconnected nodes are said to be in a document
											// fragment in IE 9
											elem.document && elem.document.nodeType !== 11) {
											return ret;
										}
									} catch (e) { }
								}

								return Sizzle(expr, null, null, [elem]).length > 0;
							};
						}
					})();
				}

				// Deprecated
				Expr.pseudos["nth"] = Expr.pseudos["eq"];

				// Back-compat
				function setFilters() { }
				Expr.filters = setFilters.prototype = Expr.pseudos;
				Expr.setFilters = new setFilters();

				// Override sizzle attribute retrieval
				Sizzle.attr = JQXLite.attr;
				JQXLite.find = Sizzle;
				JQXLite.expr = Sizzle.selectors;
				JQXLite.expr[":"] = JQXLite.expr.pseudos;
				JQXLite.unique = Sizzle.uniqueSort;
				JQXLite.text = Sizzle.getText;
				JQXLite.isXMLDoc = Sizzle.isXML;
				JQXLite.contains = Sizzle.contains;


			})(window);
			var runtil = /Until$/,
				rparentsprev = /^(?:parents|prev(?:Until|All))/,
				isSimple = /^.[^:#\[\.,]*$/,
				rneedsContext = JQXLite.expr.match.needsContext,
				// methods guaranteed to produce a unique set when starting from a unique set
				guaranteedUnique = {
					children: true,
					contents: true,
					next: true,
					prev: true
				};

			JQXLite.fn.extend({
				find: function (selector) {
					var i, l, length, n, r, ret,
						self = this;

					if (typeof selector !== "string") {
						return JQXLite(selector).filter(function () {
							for (i = 0, l = self.length; i < l; i++) {
								if (JQXLite.contains(self[i], this)) {
									return true;
								}
							}
						});
					}

					ret = this.pushStack("", "find", selector);

					for (i = 0, l = this.length; i < l; i++) {
						length = ret.length;
						JQXLite.find(selector, this[i], ret);

						if (i > 0) {
							// Make sure that the results are unique
							for (n = length; n < ret.length; n++) {
								for (r = 0; r < length; r++) {
									if (ret[r] === ret[n]) {
										ret.splice(n--, 1);
										break;
									}
								}
							}
						}
					}

					return ret;
				},

				has: function (target) {
					var i,
						targets = JQXLite(target, this),
						len = targets.length;

					return this.filter(function () {
						for (i = 0; i < len; i++) {
							if (JQXLite.contains(this, targets[i])) {
								return true;
							}
						}
					});
				},

				not: function (selector) {
					return this.pushStack(winnow(this, selector, false), "not", selector);
				},

				filter: function (selector) {
					return this.pushStack(winnow(this, selector, true), "filter", selector);
				},

				is: function (selector) {
					return !!selector && (
						typeof selector === "string" ?
							// If this is a positional/relative selector, check membership in the returned set
							// so $("p:first").is("p:last") won't return true for a doc with two "p".
							rneedsContext.test(selector) ?
								JQXLite(selector, this.context).index(this[0]) >= 0 :
								JQXLite.filter(selector, this).length > 0 :
							this.filter(selector).length > 0);
				},

				closest: function (selectors, context) {
					var cur,
						i = 0,
						l = this.length,
						ret = [],
						pos = rneedsContext.test(selectors) || typeof selectors !== "string" ?
							JQXLite(selectors, context || this.context) :
							0;

					for (; i < l; i++) {
						cur = this[i];

						while (cur && cur.ownerDocument && cur !== context && cur.nodeType !== 11) {
							if (pos ? pos.index(cur) > -1 : JQXLite.find.matchesSelector(cur, selectors)) {
								ret.push(cur);
								break;
							}
							cur = cur.parentNode;
						}
					}

					ret = ret.length > 1 ? JQXLite.unique(ret) : ret;

					return this.pushStack(ret, "closest", selectors);
				},

				// Determine the position of an element within
				// the matched set of elements
				index: function (elem) {

					// No argument, return index in parent
					if (!elem) {
						return (this[0] && this[0].parentNode) ? this.prevAll().length : -1;
					}

					// index in selector
					if (typeof elem === "string") {
						return JQXLite.inArray(this[0], JQXLite(elem));
					}

					// Locate the position of the desired element
					return JQXLite.inArray(
						// If it receives a JQXLite object, the first element is used
						elem.jqx ? elem[0] : elem, this);
				},

				add: function (selector, context) {
					var set = typeof selector === "string" ?
						JQXLite(selector, context) :
						JQXLite.makeArray(selector && selector.nodeType ? [selector] : selector),
						all = JQXLite.merge(this.get(), set);

					return this.pushStack(isDisconnected(set[0]) || isDisconnected(all[0]) ?
						all :
						JQXLite.unique(all));
				},

				addBack: function (selector) {
					return this.add(selector == null ?
						this.prevObject : this.prevObject.filter(selector)
					);
				}
			});

			JQXLite.fn.andSelf = JQXLite.fn.addBack;

			// A painfully simple check to see if an element is disconnected
			// from a document (should be improved, where feasible).
			function isDisconnected(node) {
				return !node || !node.parentNode || node.parentNode.nodeType === 11;
			}

			function sibling(cur, dir) {
				do {
					cur = cur[dir];
				} while (cur && cur.nodeType !== 1);

				return cur;
			}

			JQXLite.each({
				parent: function (elem) {
					var parent = elem.parentNode;
					return parent && parent.nodeType !== 11 ? parent : null;
				},
				parents: function (elem) {
					return JQXLite.dir(elem, "parentNode");
				},
				parentsUntil: function (elem, i, until) {
					return JQXLite.dir(elem, "parentNode", until);
				},
				next: function (elem) {
					return sibling(elem, "nextSibling");
				},
				prev: function (elem) {
					return sibling(elem, "previousSibling");
				},
				nextAll: function (elem) {
					return JQXLite.dir(elem, "nextSibling");
				},
				prevAll: function (elem) {
					return JQXLite.dir(elem, "previousSibling");
				},
				nextUntil: function (elem, i, until) {
					return JQXLite.dir(elem, "nextSibling", until);
				},
				prevUntil: function (elem, i, until) {
					return JQXLite.dir(elem, "previousSibling", until);
				},
				siblings: function (elem) {
					return JQXLite.sibling((elem.parentNode || {}).firstChild, elem);
				},
				children: function (elem) {
					return JQXLite.sibling(elem.firstChild);
				},
				contents: function (elem) {
					return JQXLite.nodeName(elem, "iframe") ?
						elem.contentDocument || elem.contentWindow.document :
						JQXLite.merge([], elem.childNodes);
				}
			}, function (name, fn) {
				JQXLite.fn[name] = function (until, selector) {
					var ret = JQXLite.map(this, fn, until);

					if (!runtil.test(name)) {
						selector = until;
					}

					if (selector && typeof selector === "string") {
						ret = JQXLite.filter(selector, ret);
					}

					ret = this.length > 1 && !guaranteedUnique[name] ? JQXLite.unique(ret) : ret;

					if (this.length > 1 && rparentsprev.test(name)) {
						ret = ret.reverse();
					}

					return this.pushStack(ret, name, core_slice.call(arguments).join(","));
				};
			});

			JQXLite.extend({
				filter: function (expr, elems, not) {
					if (not) {
						expr = ":not(" + expr + ")";
					}

					return elems.length === 1 ?
						JQXLite.find.matchesSelector(elems[0], expr) ? [elems[0]] : [] :
						JQXLite.find.matches(expr, elems);
				},

				dir: function (elem, dir, until) {
					var matched = [],
						cur = elem[dir];

					while (cur && cur.nodeType !== 9 && (until === undefined || cur.nodeType !== 1 || !JQXLite(cur).is(until))) {
						if (cur.nodeType === 1) {
							matched.push(cur);
						}
						cur = cur[dir];
					}
					return matched;
				},

				sibling: function (n, elem) {
					var r = [];

					for (; n; n = n.nextSibling) {
						if (n.nodeType === 1 && n !== elem) {
							r.push(n);
						}
					}

					return r;
				}
			});

			// Implement the identical functionality for filter and not
			function winnow(elements, qualifier, keep) {

				// Can't pass null or undefined to indexOf in Firefox 4
				// Set to 0 to skip string check
				qualifier = qualifier || 0;

				if (JQXLite.isFunction(qualifier)) {
					return JQXLite.grep(elements, function (elem, i) {
						var retVal = !!qualifier.call(elem, i, elem);
						return retVal === keep;
					});

				} else if (qualifier.nodeType) {
					return JQXLite.grep(elements, function (elem, i) {
						return (elem === qualifier) === keep;
					});

				} else if (typeof qualifier === "string") {
					var filtered = JQXLite.grep(elements, function (elem) {
						return elem.nodeType === 1;
					});

					if (isSimple.test(qualifier)) {
						return JQXLite.filter(qualifier, filtered, !keep);
					} else {
						qualifier = JQXLite.filter(qualifier, filtered);
					}
				}

				return JQXLite.grep(elements, function (elem, i) {
					return (JQXLite.inArray(elem, qualifier) >= 0) === keep;
				});
			}
			function createSafeFragment(document) {
				var list = nodeNames.split("|"),
					safeFrag = document.createDocumentFragment();

				if (safeFrag.createElement) {
					while (list.length) {
						safeFrag.createElement(
							list.pop()
						);
					}
				}
				return safeFrag;
			}

			var nodeNames = "abbr|article|aside|audio|bdi|canvas|data|datalist|details|figcaption|figure|footer|" +
				"header|hgroup|mark|meter|nav|output|progress|section|summary|time|video",
				rinlinejQuery = / JQXLite\d+="(?:null|\d+)"/g,
				rleadingWhitespace = /^\s+/,
				rxhtmlTag = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\w:]+)[^>]*)\/>/gi,
				rtagName = /<([\w:]+)/,
				rtbody = /<tbody/i,
				rhtml = /<|&#?\w+;/,
				rnoInnerhtml = /<(?:script|style|link)/i,
				rnocache = /<(?:script|object|embed|option|style)/i,
				rnoshimcache = new RegExp("<(?:" + nodeNames + ")[\\s/>]", "i"),
				rcheckableType = /^(?:checkbox|radio)$/,
				// checked="checked" or checked
				rchecked = /checked\s*(?:[^=]|=\s*.checked.)/i,
				rscriptType = /\/(java|ecma)script/i,
				rcleanScript = /^\s*<!(?:\[CDATA\[|\-\-)|[\]\-]{2}>\s*$/g,
				wrapMap = {
					option: [1, "<select multiple='multiple'>", "</select>"],
					legend: [1, "<fieldset>", "</fieldset>"],
					thead: [1, "<table>", "</table>"],
					tr: [2, "<table><tbody>", "</tbody></table>"],
					td: [3, "<table><tbody><tr>", "</tr></tbody></table>"],
					col: [2, "<table><tbody></tbody><colgroup>", "</colgroup></table>"],
					area: [1, "<map>", "</map>"],
					_default: [0, "", ""]
				},
				safeFragment = createSafeFragment(document),
				fragmentDiv = safeFragment.appendChild(document.createElement("div"));

			wrapMap.optgroup = wrapMap.option;
			wrapMap.tbody = wrapMap.tfoot = wrapMap.colgroup = wrapMap.caption = wrapMap.thead;
			wrapMap.th = wrapMap.td;

			// IE6-8 can't serialize link, script, style, or any html5 (NoScope) tags,
			// unless wrapped in a div with non-breaking characters in front of it.
			if (!JQXLite.support.htmlSerialize) {
				wrapMap._default = [1, "X<div>", "</div>"];
			}

			JQXLite.fn.extend({
				text: function (value) {
					return JQXLite.access(this, function (value) {
						return value === undefined ?
							JQXLite.text(this) :
							this.empty().append((this[0] && this[0].ownerDocument || document).createTextNode(value));
					}, null, value, arguments.length);
				},

				wrapAll: function (html) {
					if (JQXLite.isFunction(html)) {
						return this.each(function (i) {
							JQXLite(this).wrapAll(html.call(this, i));
						});
					}

					if (this[0]) {
						// The elements to wrap the target around
						var wrap = JQXLite(html, this[0].ownerDocument).eq(0).clone(true);

						if (this[0].parentNode) {
							wrap.insertBefore(this[0]);
						}

						wrap.map(function () {
							var elem = this;

							while (elem.firstChild && elem.firstChild.nodeType === 1) {
								elem = elem.firstChild;
							}

							return elem;
						}).append(this);
					}

					return this;
				},

				wrapInner: function (html) {
					if (JQXLite.isFunction(html)) {
						return this.each(function (i) {
							JQXLite(this).wrapInner(html.call(this, i));
						});
					}

					return this.each(function () {
						var self = JQXLite(this),
							contents = self.contents();

						if (contents.length) {
							contents.wrapAll(html);

						} else {
							self.append(html);
						}
					});
				},

				wrap: function (html) {
					var isFunction = JQXLite.isFunction(html);

					return this.each(function (i) {
						JQXLite(this).wrapAll(isFunction ? html.call(this, i) : html);
					});
				},

				unwrap: function () {
					return this.parent().each(function () {
						if (!JQXLite.nodeName(this, "body")) {
							JQXLite(this).replaceWith(this.childNodes);
						}
					}).end();
				},

				append: function () {
					return this.domManip(arguments, true, function (elem) {
						if (this.nodeType === 1 || this.nodeType === 11) {
							this.appendChild(elem);
						}
					});
				},

				prepend: function () {
					return this.domManip(arguments, true, function (elem) {
						if (this.nodeType === 1 || this.nodeType === 11) {
							this.insertBefore(elem, this.firstChild);
						}
					});
				},

				before: function () {
					if (!isDisconnected(this[0])) {
						return this.domManip(arguments, false, function (elem) {
							this.parentNode.insertBefore(elem, this);
						});
					}

					if (arguments.length) {
						var set = JQXLite.clean(arguments);
						return this.pushStack(JQXLite.merge(set, this), "before", this.selector);
					}
				},

				after: function () {
					if (!isDisconnected(this[0])) {
						return this.domManip(arguments, false, function (elem) {
							this.parentNode.insertBefore(elem, this.nextSibling);
						});
					}

					if (arguments.length) {
						var set = JQXLite.clean(arguments);
						return this.pushStack(JQXLite.merge(this, set), "after", this.selector);
					}
				},

				// keepData is for internal use only--do not document
				remove: function (selector, keepData) {
					var elem,
						i = 0;

					for (; (elem = this[i]) != null; i++) {
						if (!selector || JQXLite.filter(selector, [elem]).length) {
							if (!keepData && elem.nodeType === 1) {
								JQXLite.cleanData(elem.getElementsByTagName("*"));
								JQXLite.cleanData([elem]);
							}

							if (elem.parentNode) {
								elem.parentNode.removeChild(elem);
							}
						}
					}

					return this;
				},

				empty: function () {
					var elem,
						i = 0;

					for (; (elem = this[i]) != null; i++) {
						// Remove element nodes and prevent memory leaks
						if (elem.nodeType === 1) {
							JQXLite.cleanData(elem.getElementsByTagName("*"));
						}

						// Remove any remaining nodes
						while (elem.firstChild) {
							elem.removeChild(elem.firstChild);
						}
					}

					return this;
				},

				clone: function (dataAndEvents, deepDataAndEvents) {
					dataAndEvents = dataAndEvents == null ? false : dataAndEvents;
					deepDataAndEvents = deepDataAndEvents == null ? dataAndEvents : deepDataAndEvents;

					return this.map(function () {
						return JQXLite.clone(this, dataAndEvents, deepDataAndEvents);
					});
				},

				html: function (value) {
					return JQXLite.access(this, function (value) {
						var elem = this[0] || {},
							i = 0,
							l = this.length;

						if (value === undefined) {
							return elem.nodeType === 1 ?
								elem.innerHTML.replace(rinlinejQuery, "") :
								undefined;
						}

						// See if we can take a shortcut and just use innerHTML
						if (typeof value === "string" && !rnoInnerhtml.test(value) &&
							(JQXLite.support.htmlSerialize || !rnoshimcache.test(value)) &&
							(JQXLite.support.leadingWhitespace || !rleadingWhitespace.test(value)) &&
							!wrapMap[(rtagName.exec(value) || ["", ""])[1].toLowerCase()]) {

							value = value.replace(rxhtmlTag, "<$1></$2>");

							try {
								for (; i < l; i++) {
									// Remove element nodes and prevent memory leaks
									elem = this[i] || {};
									if (elem.nodeType === 1) {
										JQXLite.cleanData(elem.getElementsByTagName("*"));
										elem.innerHTML = value;
									}
								}

								elem = 0;

								// If using innerHTML throws an exception, use the fallback method
							} catch (e) { }
						}

						if (elem) {
							this.empty().append(value);
						}
					}, null, value, arguments.length);
				},

				replaceWith: function (value) {
					if (!isDisconnected(this[0])) {
						// Make sure that the elements are removed from the DOM before they are inserted
						// this can help fix replacing a parent with child elements
						if (JQXLite.isFunction(value)) {
							return this.each(function (i) {
								var self = JQXLite(this), old = self.html();
								self.replaceWith(value.call(this, i, old));
							});
						}

						if (typeof value !== "string") {
							value = JQXLite(value).detach();
						}

						return this.each(function () {
							var next = this.nextSibling,
								parent = this.parentNode;

							JQXLite(this).remove();

							if (next) {
								JQXLite(next).before(value);
							} else {
								JQXLite(parent).append(value);
							}
						});
					}

					return this.length ?
						this.pushStack(JQXLite(JQXLite.isFunction(value) ? value() : value), "replaceWith", value) :
						this;
				},

				detach: function (selector) {
					return this.remove(selector, true);
				},

				domManip: function (args, table, callback) {

					// Flatten any nested arrays
					args = [].concat.apply([], args);

					var results, first, fragment, iNoClone,
						i = 0,
						value = args[0],
						scripts = [],
						l = this.length;

					// We can't cloneNode fragments that contain checked, in WebKit
					if (!JQXLite.support.checkClone && l > 1 && typeof value === "string" && rchecked.test(value)) {
						return this.each(function () {
							JQXLite(this).domManip(args, table, callback);
						});
					}

					if (JQXLite.isFunction(value)) {
						return this.each(function (i) {
							var self = JQXLite(this);
							args[0] = value.call(this, i, table ? self.html() : undefined);
							self.domManip(args, table, callback);
						});
					}

					if (this[0]) {
						results = JQXLite.buildFragment(args, this, scripts);
						fragment = results.fragment;
						first = fragment.firstChild;

						if (fragment.childNodes.length === 1) {
							fragment = first;
						}

						if (first) {
							table = table && JQXLite.nodeName(first, "tr");

							// Use the original fragment for the last item instead of the first because it can end up
							// being emptied incorrectly in certain situations (#8070).
							// Fragments from the fragment cache must always be cloned and never used in place.
							for (iNoClone = results.cacheable || l - 1; i < l; i++) {
								callback.call(
									table && JQXLite.nodeName(this[i], "table") ?
										findOrAppend(this[i], "tbody") :
										this[i],
									i === iNoClone ?
										fragment :
										JQXLite.clone(fragment, true, true)
								);
							}
						}

						// Fix #11809: Avoid leaking memory
						fragment = first = null;

						if (scripts.length) {
							JQXLite.each(scripts, function (i, elem) {
								if (elem.src) {
									if (JQXLite.ajax) {
										JQXLite.ajax({
											url: elem.src,
											type: "GET",
											dataType: "script",
											async: false,
											global: false,
											"throws": true
										});
									} else {
										JQXLite.error("no ajax");
									}
								} else {
									JQXLite.globalEval((elem.text || elem.textContent || elem.innerHTML || "").replace(rcleanScript, ""));
								}

								if (elem.parentNode) {
									elem.parentNode.removeChild(elem);
								}
							});
						}
					}

					return this;
				}
			});

			function findOrAppend(elem, tag) {
				return elem.getElementsByTagName(tag)[0] || elem.appendChild(elem.ownerDocument.createElement(tag));
			}

			function cloneCopyEvent(src, dest) {

				if (dest.nodeType !== 1 || !JQXLite.hasData(src)) {
					return;
				}

				var type, i, l,
					oldData = JQXLite._data(src),
					curData = JQXLite._data(dest, oldData),
					events = oldData.events;

				if (events) {
					delete curData.handle;
					curData.events = {};

					for (type in events) {
						for (i = 0, l = events[type].length; i < l; i++) {
							JQXLite.event.add(dest, type, events[type][i]);
						}
					}
				}

				// make the cloned public data object a copy from the original
				if (curData.data) {
					curData.data = JQXLite.extend({}, curData.data);
				}
			}

			function cloneFixAttributes(src, dest) {
				var nodeName;

				// We do not need to do anything for non-Elements
				if (dest.nodeType !== 1) {
					return;
				}

				// clearAttributes removes the attributes, which we don't want,
				// but also removes the attachEvent events, which we *do* want
				if (dest.clearAttributes) {
					dest.clearAttributes();
				}

				// mergeAttributes, in contrast, only merges back on the
				// original attributes, not the events
				if (dest.mergeAttributes) {
					dest.mergeAttributes(src);
				}

				nodeName = dest.nodeName.toLowerCase();

				if (nodeName === "object") {
					// IE6-10 improperly clones children of object elements using classid.
					// IE10 throws NoModificationAllowedError if parent is null, #12132.
					if (dest.parentNode) {
						dest.outerHTML = src.outerHTML;
					}

					// This path appears unavoidable for IE9. When cloning an object
					// element in IE9, the outerHTML strategy above is not sufficient.
					// If the src has innerHTML and the destination does not,
					// copy the src.innerHTML into the dest.innerHTML. #10324
					if (JQXLite.support.html5Clone && (src.innerHTML && !JQXLite.trim(dest.innerHTML))) {
						dest.innerHTML = src.innerHTML;
					}

				} else if (nodeName === "input" && rcheckableType.test(src.type)) {
					// IE6-8 fails to persist the checked state of a cloned checkbox
					// or radio button. Worse, IE6-7 fail to give the cloned element
					// a checked appearance if the defaultChecked value isn't also set

					dest.defaultChecked = dest.checked = src.checked;

					// IE6-7 get confused and end up setting the value of a cloned
					// checkbox/radio button to an empty string instead of "on"
					if (dest.value !== src.value) {
						dest.value = src.value;
					}

					// IE6-8 fails to return the selected option to the default selected
					// state when cloning options
				} else if (nodeName === "option") {
					dest.selected = src.defaultSelected;

					// IE6-8 fails to set the defaultValue to the correct value when
					// cloning other types of input fields
				} else if (nodeName === "input" || nodeName === "textarea") {
					dest.defaultValue = src.defaultValue;

					// IE blanks contents when cloning scripts
				} else if (nodeName === "script" && dest.text !== src.text) {
					dest.text = src.text;
				}

				// Event data gets referenced instead of copied if the expando
				// gets copied too
				dest.removeAttribute(JQXLite.expando);
			}

			JQXLite.buildFragment = function (args, context, scripts) {
				var fragment, cacheable, cachehit,
					first = args[0];

				// Set context from what may come in as undefined or a JQXLite collection or a node
				// Updated to fix #12266 where accessing context[0] could throw an exception in IE9/10 &
				// also doubles as fix for #8950 where plain objects caused createDocumentFragment exception
				context = context || document;
				context = !context.nodeType && context[0] || context;
				context = context.ownerDocument || context;

				// Only cache "small" (1/2 KB) HTML strings that are associated with the main document
				// Cloning options loses the selected state, so don't cache them
				// IE 6 doesn't like it when you put <object> or <embed> elements in a fragment
				// Also, WebKit does not clone 'checked' attributes on cloneNode, so don't cache
				// Lastly, IE6,7,8 will not correctly reuse cached fragments that were created from unknown elems #10501
				if (args.length === 1 && typeof first === "string" && first.length < 512 && context === document &&
					first.charAt(0) === "<" && !rnocache.test(first) &&
					(JQXLite.support.checkClone || !rchecked.test(first)) &&
					(JQXLite.support.html5Clone || !rnoshimcache.test(first))) {

					// Mark cacheable and look for a hit
					cacheable = true;
					fragment = JQXLite.fragments[first];
					cachehit = fragment !== undefined;
				}

				if (!fragment) {
					fragment = context.createDocumentFragment();
					JQXLite.clean(args, context, fragment, scripts);

					// Update the cache, but only store false
					// unless this is a second parsing of the same content
					if (cacheable) {
						JQXLite.fragments[first] = cachehit && fragment;
					}
				}

				return { fragment: fragment, cacheable: cacheable };
			};

			JQXLite.fragments = {};

			JQXLite.each({
				appendTo: "append",
				prependTo: "prepend",
				insertBefore: "before",
				insertAfter: "after",
				replaceAll: "replaceWith"
			}, function (name, original) {
				JQXLite.fn[name] = function (selector) {
					var elems,
						i = 0,
						ret = [],
						insert = JQXLite(selector),
						l = insert.length,
						parent = this.length === 1 && this[0].parentNode;

					if ((parent == null || parent && parent.nodeType === 11 && parent.childNodes.length === 1) && l === 1) {
						insert[original](this[0]);
						return this;
					} else {
						for (; i < l; i++) {
							elems = (i > 0 ? this.clone(true) : this).get();
							JQXLite(insert[i])[original](elems);
							ret = ret.concat(elems);
						}

						return this.pushStack(ret, name, insert.selector);
					}
				};
			});

			function getAll(elem) {
				if (typeof elem.getElementsByTagName !== "undefined") {
					return elem.getElementsByTagName("*");

				} else if (typeof elem.querySelectorAll !== "undefined") {
					return elem.querySelectorAll("*");

				} else {
					return [];
				}
			}

			// Used in clean, fixes the defaultChecked property
			function fixDefaultChecked(elem) {
				if (rcheckableType.test(elem.type)) {
					elem.defaultChecked = elem.checked;
				}
			}

			JQXLite.extend({
				clone: function (elem, dataAndEvents, deepDataAndEvents) {
					var srcElements,
						destElements,
						i,
						clone;

					if (JQXLite.support.html5Clone || JQXLite.isXMLDoc(elem) || !rnoshimcache.test("<" + elem.nodeName + ">")) {
						clone = elem.cloneNode(true);

						// IE<=8 does not properly clone detached, unknown element nodes
					} else {
						fragmentDiv.innerHTML = elem.outerHTML;
						fragmentDiv.removeChild(clone = fragmentDiv.firstChild);
					}

					if ((!JQXLite.support.noCloneEvent || !JQXLite.support.noCloneChecked) &&
						(elem.nodeType === 1 || elem.nodeType === 11) && !JQXLite.isXMLDoc(elem)) {
						// IE copies events bound via attachEvent when using cloneNode.
						// Calling detachEvent on the clone will also remove the events
						// from the original. In order to get around this, we use some
						// proprietary methods to clear the events. Thanks to MooTools
						// guys for this hotness.

						cloneFixAttributes(elem, clone);

						// Using Sizzle here is crazy slow, so we use getElementsByTagName instead
						srcElements = getAll(elem);
						destElements = getAll(clone);

						// Weird iteration because IE will replace the length property
						// with an element if you are cloning the body and one of the
						// elements on the page has a name or id of "length"
						for (i = 0; srcElements[i]; ++i) {
							// Ensure that the destination node is not null; Fixes #9587
							if (destElements[i]) {
								cloneFixAttributes(srcElements[i], destElements[i]);
							}
						}
					}

					// Copy the events from the original to the clone
					if (dataAndEvents) {
						cloneCopyEvent(elem, clone);

						if (deepDataAndEvents) {
							srcElements = getAll(elem);
							destElements = getAll(clone);

							for (i = 0; srcElements[i]; ++i) {
								cloneCopyEvent(srcElements[i], destElements[i]);
							}
						}
					}

					srcElements = destElements = null;

					// Return the cloned set
					return clone;
				},

				clean: function (elems, context, fragment, scripts) {
					var i, j, elem, tag, wrap, depth, div, hasBody, tbody, len, handleScript, jsTags,
						safe = context === document && safeFragment,
						ret = [];

					// Ensure that context is a document
					if (!context || typeof context.createDocumentFragment === "undefined") {
						context = document;
					}

					// Use the already-created safe fragment if context permits
					for (i = 0; (elem = elems[i]) != null; i++) {
						if (typeof elem === "number") {
							elem += "";
						}

						if (!elem) {
							continue;
						}

						// Convert html string into DOM nodes
						if (typeof elem === "string") {
							if (!rhtml.test(elem)) {
								elem = context.createTextNode(elem);
							} else {
								// Ensure a safe container in which to render the html
								safe = safe || createSafeFragment(context);
								div = context.createElement("div");
								safe.appendChild(div);

								// Fix "XHTML"-style tags in all browsers
								elem = elem.replace(rxhtmlTag, "<$1></$2>");

								// Go to html and back, then peel off extra wrappers
								tag = (rtagName.exec(elem) || ["", ""])[1].toLowerCase();
								wrap = wrapMap[tag] || wrapMap._default;
								depth = wrap[0];
								div.innerHTML = wrap[1] + elem + wrap[2];

								// Move to the right depth
								while (depth--) {
									div = div.lastChild;
								}

								// Remove IE's autoinserted <tbody> from table fragments
								if (!JQXLite.support.tbody) {

									// String was a <table>, *may* have spurious <tbody>
									hasBody = rtbody.test(elem);
									tbody = tag === "table" && !hasBody ?
										div.firstChild && div.firstChild.childNodes :

										// String was a bare <thead> or <tfoot>
										wrap[1] === "<table>" && !hasBody ?
											div.childNodes :
											[];

									for (j = tbody.length - 1; j >= 0; --j) {
										if (JQXLite.nodeName(tbody[j], "tbody") && !tbody[j].childNodes.length) {
											tbody[j].parentNode.removeChild(tbody[j]);
										}
									}
								}

								// IE completely kills leading whitespace when innerHTML is used
								if (!JQXLite.support.leadingWhitespace && rleadingWhitespace.test(elem)) {
									div.insertBefore(context.createTextNode(rleadingWhitespace.exec(elem)[0]), div.firstChild);
								}

								elem = div.childNodes;

								// Take out of fragment container (we need a fresh div each time)
								div.parentNode.removeChild(div);
							}
						}

						if (elem.nodeType) {
							ret.push(elem);
						} else {
							JQXLite.merge(ret, elem);
						}
					}

					// Fix #11356: Clear elements from safeFragment
					if (div) {
						elem = div = safe = null;
					}

					// Reset defaultChecked for any radios and checkboxes
					// about to be appended to the DOM in IE 6/7 (#8060)
					if (!JQXLite.support.appendChecked) {
						for (i = 0; (elem = ret[i]) != null; i++) {
							if (JQXLite.nodeName(elem, "input")) {
								fixDefaultChecked(elem);
							} else if (typeof elem.getElementsByTagName !== "undefined") {
								JQXLite.grep(elem.getElementsByTagName("input"), fixDefaultChecked);
							}
						}
					}

					// Append elements to a provided document fragment
					if (fragment) {
						// Special handling of each script element
						handleScript = function (elem) {
							// Check if we consider it executable
							if (!elem.type || rscriptType.test(elem.type)) {
								// Detach the script and store it in the scripts array (if provided) or the fragment
								// Return truthy to indicate that it has been handled
								return scripts ?
									scripts.push(elem.parentNode ? elem.parentNode.removeChild(elem) : elem) :
									fragment.appendChild(elem);
							}
						};

						for (i = 0; (elem = ret[i]) != null; i++) {
							// Check if we're done after handling an executable script
							if (!(JQXLite.nodeName(elem, "script") && handleScript(elem))) {
								// Append to fragment and handle embedded scripts
								fragment.appendChild(elem);
								if (typeof elem.getElementsByTagName !== "undefined") {
									// handleScript alters the DOM, so use JQXLite.merge to ensure snapshot iteration
									jsTags = JQXLite.grep(JQXLite.merge([], elem.getElementsByTagName("script")), handleScript);

									// Splice the scripts into ret after their former ancestor and advance our index beyond them
									ret.splice.apply(ret, [i + 1, 0].concat(jsTags));
									i += jsTags.length;
								}
							}
						}
					}

					return ret;
				},

				cleanData: function (elems, /* internal */ acceptData) {
					var data, id, elem, type,
						i = 0,
						internalKey = JQXLite.expando,
						cache = JQXLite.cache,
						deleteExpando = JQXLite.support.deleteExpando,
						special = JQXLite.event.special;

					for (; (elem = elems[i]) != null; i++) {

						if (acceptData || JQXLite.acceptData(elem)) {

							id = elem[internalKey];
							data = id && cache[id];

							if (data) {
								if (data.events) {
									for (type in data.events) {
										if (special[type]) {
											JQXLite.event.remove(elem, type);

											// This is a shortcut to avoid JQXLite.event.remove's overhead
										} else {
											JQXLite.removeEvent(elem, type, data.handle);
										}
									}
								}

								// Remove cache only if it was not already removed by JQXLite.event.remove
								if (cache[id]) {

									delete cache[id];

									// IE does not allow us to delete expando properties from nodes,
									// nor does it have a removeAttribute function on Document nodes;
									// we must handle all of these cases
									if (deleteExpando) {
										delete elem[internalKey];

									} else if (elem.removeAttribute) {
										elem.removeAttribute(internalKey);

									} else {
										elem[internalKey] = null;
									}

									JQXLite.deletedIds.push(id);
								}
							}
						}
					}
				}
			});
			// Limit scope pollution from any deprecated API
			(function () {

				var matched, browser;

				// Use of JQXLite.browser is frowned upon.
				// More details: http://api.jqx.com/JQXLite.browser
				// JQXLite.uaMatch maintained for back-compat
				JQXLite.uaMatch = function (ua) {
					ua = ua.toLowerCase();

					var match = /(chrome)[ \/]([\w.]+)/.exec(ua) ||
						/(webkit)[ \/]([\w.]+)/.exec(ua) ||
						/(opera)(?:.*version|)[ \/]([\w.]+)/.exec(ua) ||
						/(msie) ([\w.]+)/.exec(ua) ||
						ua.indexOf("compatible") < 0 && /(mozilla)(?:.*? rv:([\w.]+)|)/.exec(ua) ||
						[];

					return {
						browser: match[1] || "",
						version: match[2] || "0"
					};
				};

				matched = JQXLite.uaMatch(navigator.userAgent);
				browser = {};

				if (matched.browser) {
					browser[matched.browser] = true;
					browser.version = matched.version;
				}

				// Chrome is Webkit, but Webkit is also Safari.
				if (browser.chrome) {
					browser.webkit = true;
				} else if (browser.webkit) {
					browser.safari = true;
				}

				JQXLite.browser = browser;

				JQXLite.sub = function () {
					function jQuerySub(selector, context) {
						return new jQuerySub.fn.init(selector, context);
					}
					JQXLite.extend(true, jQuerySub, this);
					jQuerySub.superclass = this;
					jQuerySub.fn = jQuerySub.prototype = this();
					jQuerySub.fn.constructor = jQuerySub;
					jQuerySub.sub = this.sub;
					jQuerySub.fn.init = function init(selector, context) {
						if (context && context instanceof JQXLite && !(context instanceof jQuerySub)) {
							context = jQuerySub(context);
						}

						return JQXLite.fn.init.call(this, selector, context, rootJQXLiteSub);
					};
					jQuerySub.fn.init.prototype = jQuerySub.fn;
					var rootJQXLiteSub = jQuerySub(document);
					return jQuerySub;
				};

			})();
			var curCSS, iframe, iframeDoc,
				ralpha = /alpha\([^)]*\)/i,
				ropacity = /opacity=([^)]*)/,
				rposition = /^(top|right|bottom|left)$/,
				// swappable if display is none or starts with table except "table", "table-cell", or "table-caption"
				// see here for display values: https://developer.mozilla.org/en-US/docs/CSS/display
				rdisplayswap = /^(none|table(?!-c[ea]).+)/,
				rmargin = /^margin/,
				rnumsplit = new RegExp("^(" + core_pnum + ")(.*)$", "i"),
				rnumnonpx = new RegExp("^(" + core_pnum + ")(?!px)[a-z%]+$", "i"),
				rrelNum = new RegExp("^([-+])=(" + core_pnum + ")", "i"),
				elemdisplay = { BODY: "block" },

				cssShow = { position: "absolute", visibility: "hidden", display: "block" },
				cssNormalTransform = {
					letterSpacing: 0,
					fontWeight: 400
				},

				cssExpand = ["Top", "Right", "Bottom", "Left"],
				cssPrefixes = ["Webkit", "O", "Moz", "ms"],

				eventsToggle = JQXLite.fn.toggle;

			// return a css property mapped to a potentially vendor prefixed property
			function vendorPropName(style, name) {

				// shortcut for names that are not vendor prefixed
				if (name in style) {
					return name;
				}

				// check for vendor prefixed names
				var capName = name.charAt(0).toUpperCase() + name.slice(1),
					origName = name,
					i = cssPrefixes.length;

				while (i--) {
					name = cssPrefixes[i] + capName;
					if (name in style) {
						return name;
					}
				}

				return origName;
			}

			function isHidden(elem, el) {
				elem = el || elem;
				return JQXLite.css(elem, "display") === "none" || !JQXLite.contains(elem.ownerDocument, elem);
			}

			function showHide(elements, show) {
				var elem, display,
					values = [],
					index = 0,
					length = elements.length;

				for (; index < length; index++) {
					elem = elements[index];
					if (!elem.style) {
						continue;
					}
					values[index] = JQXLite._data(elem, "olddisplay");
					if (show) {
						// Reset the inline display of this element to learn if it is
						// being hidden by cascaded rules or not
						if (!values[index] && elem.style.display === "none") {
							elem.style.display = "";
						}

						// Set elements which have been overridden with display: none
						// in a stylesheet to whatever the default browser style is
						// for such an element
						if (elem.style.display === "" && isHidden(elem)) {
							values[index] = JQXLite._data(elem, "olddisplay", css_defaultDisplay(elem.nodeName));
						}
					} else {
						display = curCSS(elem, "display");

						if (!values[index] && display !== "none") {
							JQXLite._data(elem, "olddisplay", display);
						}
					}
				}

				// Set the display of most of the elements in a second loop
				// to avoid the constant reflow
				for (index = 0; index < length; index++) {
					elem = elements[index];
					if (!elem.style) {
						continue;
					}
					if (!show || elem.style.display === "none" || elem.style.display === "") {
						elem.style.display = show ? values[index] || "" : "none";
					}
				}

				return elements;
			}

			JQXLite.fn.extend({
				css: function (name, value) {
					return JQXLite.access(this, function (elem, name, value) {
						return value !== undefined ?
							JQXLite.style(elem, name, value) :
							JQXLite.css(elem, name);
					}, name, value, arguments.length > 1);
				},
				show: function () {
					return showHide(this, true);
				},
				hide: function () {
					return showHide(this);
				},
				toggle: function (state, fn2) {
					var bool = typeof state === "boolean";

					if (JQXLite.isFunction(state) && JQXLite.isFunction(fn2)) {
						return eventsToggle.apply(this, arguments);
					}

					return this.each(function () {
						if (bool ? state : isHidden(this)) {
							JQXLite(this).show();
						} else {
							JQXLite(this).hide();
						}
					});
				}
			});

			JQXLite.extend({
				// Add in style property hooks for overriding the default
				// behavior of getting and setting a style property
				cssHooks: {
					opacity: {
						get: function (elem, computed) {
							if (computed) {
								// We should always get a number back from opacity
								var ret = curCSS(elem, "opacity");
								return ret === "" ? "1" : ret;

							}
						}
					}
				},

				// Exclude the following css properties to add px
				cssNumber: {
					"fillOpacity": true,
					"fontWeight": true,
					"lineHeight": true,
					"opacity": true,
					"orphans": true,
					"widows": true,
					"zIndex": true,
					"zoom": true
				},

				// Add in properties whose names you wish to fix before
				// setting or getting the value
				cssProps: {
					// normalize float css property
					"float": JQXLite.support.cssFloat ? "cssFloat" : "styleFloat"
				},

				// Get and set the style property on a DOM Node
				style: function (elem, name, value, extra) {
					// Don't set styles on text and comment nodes
					if (!elem || elem.nodeType === 3 || elem.nodeType === 8 || !elem.style) {
						return;
					}

					// Make sure that we're working with the right name
					var ret, type, hooks,
						origName = JQXLite.camelCase(name),
						style = elem.style;

					name = JQXLite.cssProps[origName] || (JQXLite.cssProps[origName] = vendorPropName(style, origName));

					// gets hook for the prefixed version
					// followed by the unprefixed version
					hooks = JQXLite.cssHooks[name] || JQXLite.cssHooks[origName];

					// Check if we're setting a value
					if (value !== undefined) {
						type = typeof value;

						// convert relative number strings (+= or -=) to relative numbers. #7345
						if (type === "string" && (ret = rrelNum.exec(value))) {
							value = (ret[1] + 1) * ret[2] + parseFloat(JQXLite.css(elem, name));
							// Fixes bug #9237
							type = "number";
						}

						// Make sure that NaN and null values aren't set. See: #7116
						if (value == null || type === "number" && isNaN(value)) {
							return;
						}

						// If a number was passed in, add 'px' to the (except for certain CSS properties)
						if (type === "number" && !JQXLite.cssNumber[origName]) {
							value += "px";
						}

						// If a hook was provided, use that value, otherwise just set the specified value
						if (!hooks || !("set" in hooks) || (value = hooks.set(elem, value, extra)) !== undefined) {
							// Wrapped to prevent IE from throwing errors when 'invalid' values are provided
							// Fixes bug #5509
							try {
								style[name] = value;
							} catch (e) { }
						}

					} else {
						// If a hook was provided get the non-computed value from there
						if (hooks && "get" in hooks && (ret = hooks.get(elem, false, extra)) !== undefined) {
							return ret;
						}

						// Otherwise just get the value from the style object
						return style[name];
					}
				},

				css: function (elem, name, numeric, extra) {
					var val, num, hooks,
						origName = JQXLite.camelCase(name);

					// Make sure that we're working with the right name
					name = JQXLite.cssProps[origName] || (JQXLite.cssProps[origName] = vendorPropName(elem.style, origName));

					// gets hook for the prefixed version
					// followed by the unprefixed version
					hooks = JQXLite.cssHooks[name] || JQXLite.cssHooks[origName];

					// If a hook was provided get the computed value from there
					if (hooks && "get" in hooks) {
						val = hooks.get(elem, true, extra);
					}

					// Otherwise, if a way to get the computed value exists, use that
					if (val === undefined) {
						val = curCSS(elem, name);
					}

					//convert "normal" to computed value
					if (val === "normal" && name in cssNormalTransform) {
						val = cssNormalTransform[name];
					}

					// Return, converting to number if forced or a qualifier was provided and val looks numeric
					if (numeric || extra !== undefined) {
						num = parseFloat(val);
						return numeric || JQXLite.isNumeric(num) ? num || 0 : val;
					}
					return val;
				},

				// A method for quickly swapping in/out CSS properties to get correct calculations
				swap: function (elem, options, callback) {
					var ret, name,
						old = {};

					// Remember the old values, and insert the new ones
					for (name in options) {
						old[name] = elem.style[name];
						elem.style[name] = options[name];
					}

					ret = callback.call(elem);

					// Revert the old values
					for (name in options) {
						elem.style[name] = old[name];
					}

					return ret;
				}
			});

			// NOTE: To any future maintainer, we've window.getComputedStyle
			// because jsdom on node.js will break without it.
			if (window.getComputedStyle) {
				curCSS = function (elem, name) {
					var ret, width, minWidth, maxWidth,
						computed = window.getComputedStyle(elem, null),
						style = elem.style;

					if (computed) {

						// getPropertyValue is only needed for .css('filter') in IE9, see #12537
						ret = computed.getPropertyValue(name) || computed[name];

						if (ret === "" && !JQXLite.contains(elem.ownerDocument, elem)) {
							ret = JQXLite.style(elem, name);
						}

						// A tribute to the "awesome hack by Dean Edwards"
						// Chrome < 17 and Safari 5.0 uses "computed value" instead of "used value" for margin-right
						// Safari 5.1.7 (at least) returns percentage for a larger set of values, but width seems to be reliably pixels
						// this is against the CSSOM draft spec: http://dev.w3.org/csswg/cssom/#resolved-values
						if (rnumnonpx.test(ret) && rmargin.test(name)) {
							width = style.width;
							minWidth = style.minWidth;
							maxWidth = style.maxWidth;

							style.minWidth = style.maxWidth = style.width = ret;
							ret = computed.width;

							style.width = width;
							style.minWidth = minWidth;
							style.maxWidth = maxWidth;
						}
					}

					return ret;
				};
			} else if (document.documentElement.currentStyle) {
				curCSS = function (elem, name) {
					var left, rsLeft,
						ret = elem.currentStyle && elem.currentStyle[name],
						style = elem.style;

					// Avoid setting ret to empty string here
					// so we don't default to auto
					if (ret == null && style && style[name]) {
						ret = style[name];
					}

					// From the awesome hack by Dean Edwards
					// http://erik.eae.net/archives/2007/07/27/18.54.15/#comment-102291

					// If we're not dealing with a regular pixel number
					// but a number that has a weird ending, we need to convert it to pixels
					// but not position css attributes, as those are proportional to the parent element instead
					// and we can't measure the parent instead because it might trigger a "stacking dolls" problem
					if (rnumnonpx.test(ret) && !rposition.test(name)) {

						// Remember the original values
						left = style.left;
						rsLeft = elem.runtimeStyle && elem.runtimeStyle.left;

						// Put in the new values to get a computed value out
						if (rsLeft) {
							elem.runtimeStyle.left = elem.currentStyle.left;
						}
						style.left = name === "fontSize" ? "1em" : ret;
						ret = style.pixelLeft + "px";

						// Revert the changed values
						style.left = left;
						if (rsLeft) {
							elem.runtimeStyle.left = rsLeft;
						}
					}

					return ret === "" ? "auto" : ret;
				};
			}

			function setPositiveNumber(elem, value, subtract) {
				var matches = rnumsplit.exec(value);
				return matches ?
					Math.max(0, matches[1] - (subtract || 0)) + (matches[2] || "px") :
					value;
			}

			function augmentWidthOrHeight(elem, name, extra, isBorderBox) {
				var i = extra === (isBorderBox ? "border" : "content") ?
					// If we already have the right measurement, avoid augmentation
					4 :
					// Otherwise initialize for horizontal or vertical properties
					name === "width" ? 1 : 0,

					val = 0;

				for (; i < 4; i += 2) {
					// both box models exclude margin, so add it if we want it
					if (extra === "margin") {
						// we use JQXLite.css instead of curCSS here
						// because of the reliableMarginRight CSS hook!
						val += JQXLite.css(elem, extra + cssExpand[i], true);
					}

					// From this point on we use curCSS for maximum performance (relevant in animations)
					if (isBorderBox) {
						// border-box includes padding, so remove it if we want content
						if (extra === "content") {
							val -= parseFloat(curCSS(elem, "padding" + cssExpand[i])) || 0;
						}

						// at this point, extra isn't border nor margin, so remove border
						if (extra !== "margin") {
							val -= parseFloat(curCSS(elem, "border" + cssExpand[i] + "Width")) || 0;
						}
					} else {
						// at this point, extra isn't content, so add padding
						val += parseFloat(curCSS(elem, "padding" + cssExpand[i])) || 0;

						// at this point, extra isn't content nor padding, so add border
						if (extra !== "padding") {
							val += parseFloat(curCSS(elem, "border" + cssExpand[i] + "Width")) || 0;
						}
					}
				}

				return val;
			}

			function getWidthOrHeight(elem, name, extra) {

				// Start with offset property, which is equivalent to the border-box value
				var val = name === "width" ? elem.offsetWidth : elem.offsetHeight,
					valueIsBorderBox = true,
					isBorderBox = JQXLite.support.boxSizing && JQXLite.css(elem, "boxSizing") === "border-box";

				// some non-html elements return undefined for offsetWidth, so check for null/undefined
				// svg - https://bugzilla.mozilla.org/show_bug.cgi?id=649285
				// MathML - https://bugzilla.mozilla.org/show_bug.cgi?id=491668
				if (val <= 0 || val == null) {
					// Fall back to computed then uncomputed css if necessary
					val = curCSS(elem, name);
					if (val < 0 || val == null) {
						val = elem.style[name];
					}

					// Computed unit is not pixels. Stop here and return.
					if (rnumnonpx.test(val)) {
						return val;
					}

					// we need the check for style in case a browser which returns unreliable values
					// for getComputedStyle silently falls back to the reliable elem.style
					valueIsBorderBox = isBorderBox && (JQXLite.support.boxSizingReliable || val === elem.style[name]);

					// Normalize "", auto, and prepare for extra
					val = parseFloat(val) || 0;
				}

				// use the active box-sizing model to add/subtract irrelevant styles
				return (val +
					augmentWidthOrHeight(
						elem,
						name,
						extra || (isBorderBox ? "border" : "content"),
						valueIsBorderBox
					)
				) + "px";
			}


			// Try to determine the default display value of an element
			function css_defaultDisplay(nodeName) {
				if (elemdisplay[nodeName]) {
					return elemdisplay[nodeName];
				}

				var elem = JQXLite("<" + nodeName + ">").appendTo(document.body),
					display = elem.css("display");
				elem.remove();

				// If the simple way fails,
				// get element's real default display by attaching it to a temp iframe
				if (display === "none" || display === "") {
					// Use the already-created iframe if possible
					iframe = document.body.appendChild(
						iframe || JQXLite.extend(document.createElement("iframe"), {
							frameBorder: 0,
							width: 0,
							height: 0
						})
					);

					// Create a cacheable copy of the iframe document on first call.
					// IE and Opera will allow us to reuse the iframeDoc without re-writing the fake HTML
					// document to it; WebKit & Firefox won't allow reusing the iframe document.
					if (!iframeDoc || !iframe.createElement) {
						iframeDoc = (iframe.contentWindow || iframe.contentDocument).document;
						iframeDoc.write("<!doctype html><html><body>");
						iframeDoc.close();
					}

					elem = iframeDoc.body.appendChild(iframeDoc.createElement(nodeName));

					display = curCSS(elem, "display");
					document.body.removeChild(iframe);
				}

				// Store the correct default display
				elemdisplay[nodeName] = display;

				return display;
			}

			JQXLite.each(["height", "width"], function (i, name) {
				JQXLite.cssHooks[name] = {
					get: function (elem, computed, extra) {
						if (computed) {
							// certain elements can have dimension info if we invisibly show them
							// however, it must have a current display style that would benefit from this
							if (elem.offsetWidth === 0 && rdisplayswap.test(curCSS(elem, "display"))) {
								return JQXLite.swap(elem, cssShow, function () {
									return getWidthOrHeight(elem, name, extra);
								});
							} else {
								return getWidthOrHeight(elem, name, extra);
							}
						}
					},

					set: function (elem, value, extra) {
						return setPositiveNumber(elem, value, extra ?
							augmentWidthOrHeight(
								elem,
								name,
								extra,
								JQXLite.support.boxSizing && JQXLite.css(elem, "boxSizing") === "border-box"
							) : 0
						);
					}
				};
			});

			if (!JQXLite.support.opacity) {
				JQXLite.cssHooks.opacity = {
					get: function (elem, computed) {
						// IE uses filters for opacity
						return ropacity.test((computed && elem.currentStyle ? elem.currentStyle.filter : elem.style.filter) || "") ?
							(0.01 * parseFloat(RegExp.$1)) + "" :
							computed ? "1" : "";
					},

					set: function (elem, value) {
						var style = elem.style,
							currentStyle = elem.currentStyle,
							opacity = JQXLite.isNumeric(value) ? "alpha(opacity=" + value * 100 + ")" : "",
							filter = currentStyle && currentStyle.filter || style.filter || "";

						// IE has trouble with opacity if it does not have layout
						// Force it by setting the zoom level
						style.zoom = 1;

						// if setting opacity to 1, and no other filters exist - attempt to remove filter attribute #6652
						if (value >= 1 && JQXLite.trim(filter.replace(ralpha, "")) === "" &&
							style.removeAttribute) {

							// Setting style.filter to null, "" & " " still leave "filter:" in the cssText
							// if "filter:" is present at all, clearType is disabled, we want to avoid this
							// style.removeAttribute is IE Only, but so apparently is this code path...
							style.removeAttribute("filter");

							// if there there is no filter style applied in a css rule, we are done
							if (currentStyle && !currentStyle.filter) {
								return;
							}
						}

						// otherwise, set new filter values
						style.filter = ralpha.test(filter) ?
							filter.replace(ralpha, opacity) :
							filter + " " + opacity;
					}
				};
			}

			// These hooks cannot be added until DOM ready because the support test
			// for it is not run until after DOM ready
			JQXLite(function () {
				if (!JQXLite.support.reliableMarginRight) {
					JQXLite.cssHooks.marginRight = {
						get: function (elem, computed) {
							// WebKit Bug 13343 - getComputedStyle returns wrong value for margin-right
							// Work around by temporarily setting element display to inline-block
							return JQXLite.swap(elem, { "display": "inline-block" }, function () {
								if (computed) {
									return curCSS(elem, "marginRight");
								}
							});
						}
					};
				}

				// Webkit bug: https://bugs.webkit.org/show_bug.cgi?id=29084
				// getComputedStyle returns percent when specified for top/left/bottom/right
				// rather than make the css module depend on the offset module, we just check for it here
				if (!JQXLite.support.pixelPosition && JQXLite.fn.position) {
					JQXLite.each(["top", "left"], function (i, prop) {
						JQXLite.cssHooks[prop] = {
							get: function (elem, computed) {
								if (computed) {
									var ret = curCSS(elem, prop);
									// if curCSS returns percentage, fallback to offset
									return rnumnonpx.test(ret) ? JQXLite(elem).position()[prop] + "px" : ret;
								}
							}
						};
					});
				}

			});

			if (JQXLite.expr && JQXLite.expr.filters) {
				JQXLite.expr.filters.hidden = function (elem) {
					return (elem.offsetWidth === 0 && elem.offsetHeight === 0) || (!JQXLite.support.reliableHiddenOffsets && ((elem.style && elem.style.display) || curCSS(elem, "display")) === "none");
				};

				JQXLite.expr.filters.visible = function (elem) {
					return !JQXLite.expr.filters.hidden(elem);
				};
			}

			// These hooks are used by animate to expand properties
			JQXLite.each({
				margin: "",
				padding: "",
				border: "Width"
			}, function (prefix, suffix) {
				JQXLite.cssHooks[prefix + suffix] = {
					expand: function (value) {
						var i,

							// assumes a single number if not a string
							parts = typeof value === "string" ? value.split(" ") : [value],
							expanded = {};

						for (i = 0; i < 4; i++) {
							expanded[prefix + cssExpand[i] + suffix] =
								parts[i] || parts[i - 2] || parts[0];
						}

						return expanded;
					}
				};

				if (!rmargin.test(prefix)) {
					JQXLite.cssHooks[prefix + suffix].set = setPositiveNumber;
				}
			});
			var r20 = /%20/g,
				rbracket = /\[\]$/,
				rCRLF = /\r?\n/g,
				rinput = /^(?:color|date|datetime|datetime-local|email|hidden|month|number|password|range|search|tel|text|time|url|week)$/i,
				rselectTextarea = /^(?:select|textarea)/i;

			JQXLite.fn.extend({
				serialize: function () {
					return JQXLite.param(this.serializeArray());
				},
				serializeArray: function () {
					return this.map(function () {
						return this.elements ? JQXLite.makeArray(this.elements) : this;
					})
						.filter(function () {
							return this.name && !this.disabled &&
								(this.checked || rselectTextarea.test(this.nodeName) ||
									rinput.test(this.type));
						})
						.map(function (i, elem) {
							var val = JQXLite(this).val();

							return val == null ?
								null :
								JQXLite.isArray(val) ?
									JQXLite.map(val, function (val, i) {
										return { name: elem.name, value: val.replace(rCRLF, "\r\n") };
									}) :
									{ name: elem.name, value: val.replace(rCRLF, "\r\n") };
						}).get();
				}
			});

			//Serialize an array of form elements or a set of
			//key/values into a query string
			JQXLite.param = function (a, traditional) {
				var prefix,
					s = [],
					add = function (key, value) {
						// If value is a function, invoke it and return its value
						value = JQXLite.isFunction(value) ? value() : (value == null ? "" : value);
						s[s.length] = encodeURIComponent(key) + "=" + encodeURIComponent(value);
					};

				// Set traditional to true for JQXLite <= 1.3.2 behavior.
				if (traditional === undefined) {
					traditional = JQXLite.ajaxSettings && JQXLite.ajaxSettings.traditional;
				}

				// If an array was passed in, assume that it is an array of form elements.
				if (JQXLite.isArray(a) || (a.jqx && !JQXLite.isPlainObject(a))) {
					// Serialize the form elements
					JQXLite.each(a, function () {
						add(this.name, this.value);
					});

				} else {
					// If traditional, encode the "old" way (the way 1.3.2 or older
					// did it), otherwise encode params recursively.
					for (prefix in a) {
						buildParams(prefix, a[prefix], traditional, add);
					}
				}

				// Return the resulting serialization
				return s.join("&").replace(r20, "+");
			};

			function buildParams(prefix, obj, traditional, add) {
				var name;

				if (JQXLite.isArray(obj)) {
					// Serialize array item.
					JQXLite.each(obj, function (i, v) {
						if (traditional || rbracket.test(prefix)) {
							// Treat each array item as a scalar.
							add(prefix, v);

						} else {
							// If array item is non-scalar (array or object), encode its
							// numeric index to resolve deserialization ambiguity issues.
							// Note that rack (as of 1.0.0) can't currently deserialize
							// nested arrays properly, and attempting to do so may cause
							// a server error. Possible fixes are to modify rack's
							// deserialization algorithm or to provide an option or flag
							// to force array serialization to be shallow.
							buildParams(prefix + "[" + (typeof v === "object" ? i : "") + "]", v, traditional, add);
						}
					});

				} else if (!traditional && JQXLite.type(obj) === "object") {
					// Serialize object item.
					for (name in obj) {
						buildParams(prefix + "[" + name + "]", obj[name], traditional, add);
					}

				} else {
					// Serialize scalar item.
					add(prefix, obj);
				}
			}


			// Create transport if the browser can provide an xhr
			if (JQXLite.support.ajax) {

				JQXLite.ajaxTransport(function (s) {
					// Cross domain only allowed if supported through XMLHttpRequest
					if (!s.crossDomain || JQXLite.support.cors) {

						var callback;

						return {
							send: function (headers, complete) {

								// Get a new xhr
								var handle, i,
									xhr = s.xhr();

								// Open the socket
								// Passing null username, generates a login popup on Opera (#2865)
								if (s.username) {
									xhr.open(s.type, s.url, s.async, s.username, s.password);
								} else {
									xhr.open(s.type, s.url, s.async);
								}

								// Apply custom fields if provided
								if (s.xhrFields) {
									for (i in s.xhrFields) {
										xhr[i] = s.xhrFields[i];
									}
								}

								// Override mime type if needed
								if (s.mimeType && xhr.overrideMimeType) {
									xhr.overrideMimeType(s.mimeType);
								}

								// X-Requested-With header
								// For cross-domain requests, seeing as conditions for a preflight are
								// akin to a jigsaw puzzle, we simply never set it to be sure.
								// (it can always be set on a per-request basis or even using ajaxSetup)
								// For same-domain requests, won't change header if already provided.
								if (!s.crossDomain && !headers["X-Requested-With"]) {
									headers["X-Requested-With"] = "XMLHttpRequest";
								}

								// Need an extra try/catch for cross domain requests in Firefox 3
								try {
									for (i in headers) {
										xhr.setRequestHeader(i, headers[i]);
									}
								} catch (_) { }

								// Do send the request
								// This may raise an exception which is actually
								// handled in JQXLite.ajax (so no try/catch here)
								xhr.send((s.hasContent && s.data) || null);

								// Listener
								callback = function (_, isAbort) {

									var status,
										statusText,
										responseHeaders,
										responses,
										xml;

									// Firefox throws exceptions when accessing properties
									// of an xhr when a network error occurred
									// http://helpful.knobs-dials.com/index.php/Component_returned_failure_code:_0x80040111_(NS_ERROR_NOT_AVAILABLE)
									try {

										// Was never called and is aborted or complete
										if (callback && (isAbort || xhr.readyState === 4)) {

											// Only called once
											callback = undefined;

											// Do not keep as active anymore
											if (handle) {
												xhr.onreadystatechange = JQXLite.noop;
												if (xhrOnUnloadAbort) {
													delete xhrCallbacks[handle];
												}
											}

											// If it's an abort
											if (isAbort) {
												// Abort it manually if needed
												if (xhr.readyState !== 4) {
													xhr.abort();
												}
											} else {
												status = xhr.status;
												responseHeaders = xhr.getAllResponseHeaders();
												responses = {};
												xml = xhr.responseXML;

												// Construct response list
												if (xml && xml.documentElement /* #4958 */) {
													responses.xml = xml;
												}

												// When requesting binary data, IE6-9 will throw an exception
												// on any attempt to access responseText (#11426)
												try {
													responses.text = xhr.responseText;
												} catch (e) {
												}

												// Firefox throws an exception when accessing
												// statusText for faulty cross-domain requests
												try {
													statusText = xhr.statusText;
												} catch (e) {
													// We normalize with Webkit giving an empty statusText
													statusText = "";
												}

												// Filter status for non standard behaviors

												// If the request is local and we have data: assume a success
												// (success with no data won't get notified, that's the best we
												// can do given current implementations)
												if (!status && s.isLocal && !s.crossDomain) {
													status = responses.text ? 200 : 404;
													// IE - #1450: sometimes returns 1223 when it should be 204
												} else if (status === 1223) {
													status = 204;
												}
											}
										}
									} catch (firefoxAccessException) {
										if (!isAbort) {
											complete(-1, firefoxAccessException);
										}
									}

									// Call complete if needed
									if (responses) {
										complete(status, statusText, responses, responseHeaders);
									}
								};

								if (!s.async) {
									// if we're in sync mode we fire the callback
									callback();
								} else if (xhr.readyState === 4) {
									// (IE6 & IE7) if it's in cache and has been
									// retrieved directly we need to fire the callback
									setTimeout(callback, 0);
								} else {
									handle = ++xhrId;
									if (xhrOnUnloadAbort) {
										// Create the active xhrs callbacks list if needed
										// and attach the unload handler
										if (!xhrCallbacks) {
											xhrCallbacks = {};
											JQXLite(window).unload(xhrOnUnloadAbort);
										}
										// Add to list of active xhrs callbacks
										xhrCallbacks[handle] = callback;
									}
									xhr.onreadystatechange = callback;
								}
							},

							abort: function () {
								if (callback) {
									callback(0, 1);
								}
							}
						};
					}
				});
			}
			var fxNow, timerId,
				rfxtypes = /^(?:toggle|show|hide)$/,
				rfxnum = new RegExp("^(?:([-+])=|)(" + core_pnum + ")([a-z%]*)$", "i"),
				rrun = /queueHooks$/,
				animationPrefilters = [defaultPrefilter],
				tweeners = {
					"*": [function (prop, value) {
						var end, unit,
							tween = this.createTween(prop, value),
							parts = rfxnum.exec(value),
							target = tween.cur(),
							start = +target || 0,
							scale = 1,
							maxIterations = 20;

						if (parts) {
							end = +parts[2];
							unit = parts[3] || (JQXLite.cssNumber[prop] ? "" : "px");

							// We need to compute starting value
							if (unit !== "px" && start) {
								// Iteratively approximate from a nonzero starting point
								// Prefer the current property, because this process will be trivial if it uses the same units
								// Fallback to end or a simple constant
								start = JQXLite.css(tween.elem, prop, true) || end || 1;

								do {
									// If previous iteration zeroed out, double until we get *something*
									// Use a string for doubling factor so we don't accidentally see scale as unchanged below
									scale = scale || ".5";

									// Adjust and apply
									start = start / scale;
									JQXLite.style(tween.elem, prop, start + unit);

									// Update scale, tolerating zero or NaN from tween.cur()
									// And breaking the loop if scale is unchanged or perfect, or if we've just had enough
								} while (scale !== (scale = tween.cur() / target) && scale !== 1 && --maxIterations);
							}

							tween.unit = unit;
							tween.start = start;
							// If a +=/-= token was provided, we're doing a relative animation
							tween.end = parts[1] ? start + (parts[1] + 1) * end : end;
						}
						return tween;
					}]
				};

			// Animations created synchronously will run synchronously
			function createFxNow() {
				setTimeout(function () {
					fxNow = undefined;
				}, 0);
				return (fxNow = JQXLite.now());
			}

			function createTweens(animation, props) {
				JQXLite.each(props, function (prop, value) {
					var collection = (tweeners[prop] || []).concat(tweeners["*"]),
						index = 0,
						length = collection.length;
					for (; index < length; index++) {
						if (collection[index].call(animation, prop, value)) {

							// we're done with this property
							return;
						}
					}
				});
			}

			function Animation(elem, properties, options) {
				var result,
					index = 0,
					tweenerIndex = 0,
					length = animationPrefilters.length,
					deferred = JQXLite.Deferred().always(function () {
						// don't match elem in the :animated selector
						delete tick.elem;
					}),
					tick = function () {
						var currentTime = fxNow || createFxNow(),
							remaining = Math.max(0, animation.startTime + animation.duration - currentTime),
							// archaic crash bug won't allow us to use 1 - ( 0.5 || 0 ) (#12497)
							temp = remaining / animation.duration || 0,
							percent = 1 - temp,
							index = 0,
							length = animation.tweens.length;

						for (; index < length; index++) {
							animation.tweens[index].run(percent);
						}

						deferred.notifyWith(elem, [animation, percent, remaining]);

						if (percent < 1 && length) {
							return remaining;
						} else {
							deferred.resolveWith(elem, [animation]);
							return false;
						}
					},
					animation = deferred.promise({
						elem: elem,
						props: JQXLite.extend({}, properties),
						opts: JQXLite.extend(true, { specialEasing: {} }, options),
						originalProperties: properties,
						originalOptions: options,
						startTime: fxNow || createFxNow(),
						duration: options.duration,
						tweens: [],
						createTween: function (prop, end, easing) {
							var tween = JQXLite.Tween(elem, animation.opts, prop, end,
								animation.opts.specialEasing[prop] || animation.opts.easing);
							animation.tweens.push(tween);
							return tween;
						},
						stop: function (gotoEnd) {
							var index = 0,
								// if we are going to the end, we want to run all the tweens
								// otherwise we skip this part
								length = gotoEnd ? animation.tweens.length : 0;

							for (; index < length; index++) {
								animation.tweens[index].run(1);
							}

							// resolve when we played the last frame
							// otherwise, reject
							if (gotoEnd) {
								deferred.resolveWith(elem, [animation, gotoEnd]);
							} else {
								deferred.rejectWith(elem, [animation, gotoEnd]);
							}
							return this;
						}
					}),
					props = animation.props;

				propFilter(props, animation.opts.specialEasing);

				for (; index < length; index++) {
					result = animationPrefilters[index].call(animation, elem, props, animation.opts);
					if (result) {
						return result;
					}
				}

				createTweens(animation, props);

				if (JQXLite.isFunction(animation.opts.start)) {
					animation.opts.start.call(elem, animation);
				}

				JQXLite.fx.timer(
					JQXLite.extend(tick, {
						anim: animation,
						queue: animation.opts.queue,
						elem: elem
					})
				);

				// attach callbacks from options
				return animation.progress(animation.opts.progress)
					.done(animation.opts.done, animation.opts.complete)
					.fail(animation.opts.fail)
					.always(animation.opts.always);
			}

			function propFilter(props, specialEasing) {
				var index, name, easing, value, hooks;

				// camelCase, specialEasing and expand cssHook pass
				for (index in props) {
					name = JQXLite.camelCase(index);
					easing = specialEasing[name];
					value = props[index];
					if (JQXLite.isArray(value)) {
						easing = value[1];
						value = props[index] = value[0];
					}

					if (index !== name) {
						props[name] = value;
						delete props[index];
					}

					hooks = JQXLite.cssHooks[name];
					if (hooks && "expand" in hooks) {
						value = hooks.expand(value);
						delete props[name];

						// not quite $.extend, this wont overwrite keys already present.
						// also - reusing 'index' from above because we have the correct "name"
						for (index in value) {
							if (!(index in props)) {
								props[index] = value[index];
								specialEasing[index] = easing;
							}
						}
					} else {
						specialEasing[name] = easing;
					}
				}
			}

			JQXLite.Animation = JQXLite.extend(Animation, {

				tweener: function (props, callback) {
					if (JQXLite.isFunction(props)) {
						callback = props;
						props = ["*"];
					} else {
						props = props.split(" ");
					}

					var prop,
						index = 0,
						length = props.length;

					for (; index < length; index++) {
						prop = props[index];
						tweeners[prop] = tweeners[prop] || [];
						tweeners[prop].unshift(callback);
					}
				},

				prefilter: function (callback, prepend) {
					if (prepend) {
						animationPrefilters.unshift(callback);
					} else {
						animationPrefilters.push(callback);
					}
				}
			});

			function defaultPrefilter(elem, props, opts) {
				var index, prop, value, length, dataShow, toggle, tween, hooks, oldfire,
					anim = this,
					style = elem.style,
					orig = {},
					handled = [],
					hidden = elem.nodeType && isHidden(elem);

				// handle queue: false promises
				if (!opts.queue) {
					hooks = JQXLite._queueHooks(elem, "fx");
					if (hooks.unqueued == null) {
						hooks.unqueued = 0;
						oldfire = hooks.empty.fire;
						hooks.empty.fire = function () {
							if (!hooks.unqueued) {
								oldfire();
							}
						};
					}
					hooks.unqueued++;

					anim.always(function () {
						// doing this makes sure that the complete handler will be called
						// before this completes
						anim.always(function () {
							hooks.unqueued--;
							if (!JQXLite.queue(elem, "fx").length) {
								hooks.empty.fire();
							}
						});
					});
				}

				// height/width overflow pass
				if (elem.nodeType === 1 && ("height" in props || "width" in props)) {
					// Make sure that nothing sneaks out
					// Record all 3 overflow attributes because IE does not
					// change the overflow attribute when overflowX and
					// overflowY are set to the same value
					opts.overflow = [style.overflow, style.overflowX, style.overflowY];

					// Set display property to inline-block for height/width
					// animations on inline elements that are having width/height animated
					if (JQXLite.css(elem, "display") === "inline" &&
						JQXLite.css(elem, "float") === "none") {

						// inline-level elements accept inline-block;
						// block-level elements need to be inline with layout
						if (!JQXLite.support.inlineBlockNeedsLayout || css_defaultDisplay(elem.nodeName) === "inline") {
							style.display = "inline-block";

						} else {
							style.zoom = 1;
						}
					}
				}

				if (opts.overflow) {
					style.overflow = "hidden";
					if (!JQXLite.support.shrinkWrapBlocks) {
						anim.done(function () {
							style.overflow = opts.overflow[0];
							style.overflowX = opts.overflow[1];
							style.overflowY = opts.overflow[2];
						});
					}
				}


				// show/hide pass
				for (index in props) {
					value = props[index];
					if (rfxtypes.exec(value)) {
						delete props[index];
						toggle = toggle || value === "toggle";
						if (value === (hidden ? "hide" : "show")) {
							continue;
						}
						handled.push(index);
					}
				}

				length = handled.length;
				if (length) {
					dataShow = JQXLite._data(elem, "fxshow") || JQXLite._data(elem, "fxshow", {});
					if ("hidden" in dataShow) {
						hidden = dataShow.hidden;
					}

					// store state if its toggle - enables .stop().toggle() to "reverse"
					if (toggle) {
						dataShow.hidden = !hidden;
					}
					if (hidden) {
						JQXLite(elem).show();
					} else {
						anim.done(function () {
							JQXLite(elem).hide();
						});
					}
					anim.done(function () {
						var prop;
						JQXLite.removeData(elem, "fxshow", true);
						for (prop in orig) {
							JQXLite.style(elem, prop, orig[prop]);
						}
					});
					for (index = 0; index < length; index++) {
						prop = handled[index];
						tween = anim.createTween(prop, hidden ? dataShow[prop] : 0);
						orig[prop] = dataShow[prop] || JQXLite.style(elem, prop);

						if (!(prop in dataShow)) {
							dataShow[prop] = tween.start;
							if (hidden) {
								tween.end = tween.start;
								tween.start = prop === "width" || prop === "height" ? 1 : 0;
							}
						}
					}
				}
			}

			function Tween(elem, options, prop, end, easing) {
				return new Tween.prototype.init(elem, options, prop, end, easing);
			}
			JQXLite.Tween = Tween;

			Tween.prototype = {
				constructor: Tween,
				init: function (elem, options, prop, end, easing, unit) {
					this.elem = elem;
					this.prop = prop;
					this.easing = easing || "swing";
					this.options = options;
					this.start = this.now = this.cur();
					this.end = end;
					this.unit = unit || (JQXLite.cssNumber[prop] ? "" : "px");
				},
				cur: function () {
					var hooks = Tween.propHooks[this.prop];

					return hooks && hooks.get ?
						hooks.get(this) :
						Tween.propHooks._default.get(this);
				},
				run: function (percent) {
					var eased,
						hooks = Tween.propHooks[this.prop];

					if (this.options.duration) {
						this.pos = eased = JQXLite.easing[this.easing](
							percent, this.options.duration * percent, 0, 1, this.options.duration
						);
					} else {
						this.pos = eased = percent;
					}
					this.now = (this.end - this.start) * eased + this.start;

					if (this.options.step) {
						this.options.step.call(this.elem, this.now, this);
					}

					if (hooks && hooks.set) {
						hooks.set(this);
					} else {
						Tween.propHooks._default.set(this);
					}
					return this;
				}
			};

			Tween.prototype.init.prototype = Tween.prototype;

			Tween.propHooks = {
				_default: {
					get: function (tween) {
						var result;

						if (tween.elem[tween.prop] != null &&
							(!tween.elem.style || tween.elem.style[tween.prop] == null)) {
							return tween.elem[tween.prop];
						}

						// passing any value as a 4th parameter to .css will automatically
						// attempt a parseFloat and fallback to a string if the parse fails
						// so, simple values such as "10px" are parsed to Float.
						// complex values such as "rotate(1rad)" are returned as is.
						result = JQXLite.css(tween.elem, tween.prop, false, "");
						// Empty strings, null, undefined and "auto" are converted to 0.
						return !result || result === "auto" ? 0 : result;
					},
					set: function (tween) {
						// use step hook for back compat - use cssHook if its there - use .style if its
						// available and use plain properties where available
						if (JQXLite.fx.step[tween.prop]) {
							JQXLite.fx.step[tween.prop](tween);
						} else if (tween.elem.style && (tween.elem.style[JQXLite.cssProps[tween.prop]] != null || JQXLite.cssHooks[tween.prop])) {
							JQXLite.style(tween.elem, tween.prop, tween.now + tween.unit);
						} else {
							tween.elem[tween.prop] = tween.now;
						}
					}
				}
			};

			// Remove in 2.0 - this supports IE8's panic based approach
			// to setting things on disconnected nodes

			Tween.propHooks.scrollTop = Tween.propHooks.scrollLeft = {
				set: function (tween) {
					if (tween.elem.nodeType && tween.elem.parentNode) {
						tween.elem[tween.prop] = tween.now;
					}
				}
			};

			JQXLite.each(["toggle", "show", "hide"], function (i, name) {
				var cssFn = JQXLite.fn[name];
				JQXLite.fn[name] = function (speed, easing, callback) {
					return speed == null || typeof speed === "boolean" ||
						// special check for .toggle( handler, handler, ... )
						(!i && JQXLite.isFunction(speed) && JQXLite.isFunction(easing)) ?
						cssFn.apply(this, arguments) :
						this.animate(genFx(name, true), speed, easing, callback);
				};
			});

			JQXLite.fn.extend({
				fadeTo: function (speed, to, easing, callback) {

					// show any hidden elements after setting opacity to 0
					return this.filter(isHidden).css("opacity", 0).show()

						// animate to the value specified
						.end().animate({ opacity: to }, speed, easing, callback);
				},
				animate: function (prop, speed, easing, callback) {
					var empty = JQXLite.isEmptyObject(prop),
						optall = JQXLite.speed(speed, easing, callback),
						doAnimation = function () {
							// Operate on a copy of prop so per-property easing won't be lost
							var anim = Animation(this, JQXLite.extend({}, prop), optall);

							// Empty animations resolve immediately
							if (empty) {
								anim.stop(true);
							}
						};

					return empty || optall.queue === false ?
						this.each(doAnimation) :
						this.queue(optall.queue, doAnimation);
				},
				stop: function (type, clearQueue, gotoEnd) {
					var stopQueue = function (hooks) {
						var stop = hooks.stop;
						delete hooks.stop;
						stop(gotoEnd);
					};

					if (typeof type !== "string") {
						gotoEnd = clearQueue;
						clearQueue = type;
						type = undefined;
					}
					if (clearQueue && type !== false) {
						this.queue(type || "fx", []);
					}

					return this.each(function () {
						var dequeue = true,
							index = type != null && type + "queueHooks",
							timers = JQXLite.timers,
							data = JQXLite._data(this);

						if (index) {
							if (data[index] && data[index].stop) {
								stopQueue(data[index]);
							}
						} else {
							for (index in data) {
								if (data[index] && data[index].stop && rrun.test(index)) {
									stopQueue(data[index]);
								}
							}
						}

						for (index = timers.length; index--;) {
							if (timers[index].elem === this && (type == null || timers[index].queue === type)) {
								timers[index].anim.stop(gotoEnd);
								dequeue = false;
								timers.splice(index, 1);
							}
						}

						// start the next in the queue if the last step wasn't forced
						// timers currently will call their complete callbacks, which will dequeue
						// but only if they were gotoEnd
						if (dequeue || !gotoEnd) {
							JQXLite.dequeue(this, type);
						}
					});
				}
			});

			// Generate parameters to create a standard animation
			function genFx(type, includeWidth) {
				var which,
					attrs = { height: type },
					i = 0;

				// if we include width, step value is 1 to do all cssExpand values,
				// if we don't include width, step value is 2 to skip over Left and Right
				includeWidth = includeWidth ? 1 : 0;
				for (; i < 4; i += 2 - includeWidth) {
					which = cssExpand[i];
					attrs["margin" + which] = attrs["padding" + which] = type;
				}

				if (includeWidth) {
					attrs.opacity = attrs.width = type;
				}

				return attrs;
			}

			// Generate shortcuts for custom animations
			JQXLite.each({
				slideDown: genFx("show"),
				slideUp: genFx("hide"),
				slideToggle: genFx("toggle"),
				fadeIn: { opacity: "show" },
				fadeOut: { opacity: "hide" },
				fadeToggle: { opacity: "toggle" }
			}, function (name, props) {
				JQXLite.fn[name] = function (speed, easing, callback) {
					return this.animate(props, speed, easing, callback);
				};
			});

			JQXLite.speed = function (speed, easing, fn) {
				var opt = speed && typeof speed === "object" ? JQXLite.extend({}, speed) : {
					complete: fn || !fn && easing ||
						JQXLite.isFunction(speed) && speed,
					duration: speed,
					easing: fn && easing || easing && !JQXLite.isFunction(easing) && easing
				};

				opt.duration = JQXLite.fx.off ? 0 : typeof opt.duration === "number" ? opt.duration :
					opt.duration in JQXLite.fx.speeds ? JQXLite.fx.speeds[opt.duration] : JQXLite.fx.speeds._default;

				// normalize opt.queue - true/undefined/null -> "fx"
				if (opt.queue == null || opt.queue === true) {
					opt.queue = "fx";
				}

				// Queueing
				opt.old = opt.complete;

				opt.complete = function () {
					if (JQXLite.isFunction(opt.old)) {
						opt.old.call(this);
					}

					if (opt.queue) {
						JQXLite.dequeue(this, opt.queue);
					}
				};

				return opt;
			};

			JQXLite.easing = {
				linear: function (p) {
					return p;
				},
				swing: function (p) {
					return 0.5 - Math.cos(p * Math.PI) / 2;
				}
			};

			JQXLite.timers = [];
			JQXLite.fx = Tween.prototype.init;
			JQXLite.fx.tick = function () {
				var timer,
					timers = JQXLite.timers,
					i = 0;

				fxNow = JQXLite.now();

				for (; i < timers.length; i++) {
					timer = timers[i];
					// Checks the timer has not already been removed
					if (!timer() && timers[i] === timer) {
						timers.splice(i--, 1);
					}
				}

				if (!timers.length) {
					JQXLite.fx.stop();
				}
				fxNow = undefined;
			};

			JQXLite.fx.timer = function (timer) {
				if (timer() && JQXLite.timers.push(timer) && !timerId) {
					timerId = setInterval(JQXLite.fx.tick, JQXLite.fx.interval);
				}
			};

			JQXLite.fx.interval = 13;

			JQXLite.fx.stop = function () {
				clearInterval(timerId);
				timerId = null;
			};

			JQXLite.fx.speeds = {
				slow: 600,
				fast: 200,
				// Default speed
				_default: 400
			};

			// Back Compat <1.8 extension point
			JQXLite.fx.step = {};

			if (JQXLite.expr && JQXLite.expr.filters) {
				JQXLite.expr.filters.animated = function (elem) {
					return JQXLite.grep(JQXLite.timers, function (fn) {
						return elem === fn.elem;
					}).length;
				};
			}
			var rroot = /^(?:body|html)$/i;

			JQXLite.fn.offset = function (options) {
				if (arguments.length) {
					return options === undefined ?
						this :
						this.each(function (i) {
							JQXLite.offset.setOffset(this, options, i);
						});
				}

				var docElem, body, win, clientTop, clientLeft, scrollTop, scrollLeft,
					box = { top: 0, left: 0 },
					elem = this[0],
					doc = elem && elem.ownerDocument;

				if (!doc) {
					return;
				}

				if ((body = doc.body) === elem) {
					return JQXLite.offset.bodyOffset(elem);
				}

				docElem = doc.documentElement;

				// Make sure it's not a disconnected DOM node
				if (!JQXLite.contains(docElem, elem)) {
					return box;
				}

				// If we don't have gBCR, just use 0,0 rather than error
				// BlackBerry 5, iOS 3 (original iPhone)
				if (typeof elem.getBoundingClientRect !== "undefined") {
					box = elem.getBoundingClientRect();
				}
				win = getWindow(doc);
				clientTop = docElem.clientTop || body.clientTop || 0;
				clientLeft = docElem.clientLeft || body.clientLeft || 0;
				scrollTop = win.pageYOffset || docElem.scrollTop;
				scrollLeft = win.pageXOffset || docElem.scrollLeft;
				return {
					top: box.top + scrollTop - clientTop,
					left: box.left + scrollLeft - clientLeft
				};
			};

			JQXLite.offset = {

				bodyOffset: function (body) {
					var top = body.offsetTop,
						left = body.offsetLeft;

					if (JQXLite.support.doesNotIncludeMarginInBodyOffset) {
						top += parseFloat(JQXLite.css(body, "marginTop")) || 0;
						left += parseFloat(JQXLite.css(body, "marginLeft")) || 0;
					}

					return { top: top, left: left };
				},

				setOffset: function (elem, options, i) {
					var position = JQXLite.css(elem, "position");

					// set position first, in-case top/left are set even on static elem
					if (position === "static") {
						elem.style.position = "relative";
					}

					var curElem = JQXLite(elem),
						curOffset = curElem.offset(),
						curCSSTop = JQXLite.css(elem, "top"),
						curCSSLeft = JQXLite.css(elem, "left"),
						calculatePosition = (position === "absolute" || position === "fixed") && JQXLite.inArray("auto", [curCSSTop, curCSSLeft]) > -1,
						props = {}, curPosition = {}, curTop, curLeft;

					// need to be able to calculate position if either top or left is auto and position is either absolute or fixed
					if (calculatePosition) {
						curPosition = curElem.position();
						curTop = curPosition.top;
						curLeft = curPosition.left;
					} else {
						curTop = parseFloat(curCSSTop) || 0;
						curLeft = parseFloat(curCSSLeft) || 0;
					}

					if (JQXLite.isFunction(options)) {
						options = options.call(elem, i, curOffset);
					}

					if (options.top != null) {
						props.top = (options.top - curOffset.top) + curTop;
					}
					if (options.left != null) {
						props.left = (options.left - curOffset.left) + curLeft;
					}

					if ("using" in options) {
						options.using.call(elem, props);
					} else {
						curElem.css(props);
					}
				}
			};


			JQXLite.fn.extend({
				isRendered: function () {
					var that = this;
					var element = this[0];
					if (element.parentNode == null || (element.offsetWidth === 0 || element.offsetHeight === 0)) {
						return false;
					}

					return true;
				},

				getSizeFromStyle: function () {
					var that = this;
					var width = null;
					var height = null;
					var element = this[0];
					var computedStyle;

					if (element.style.width) {
						width = element.style.width;
					}
					if (element.style.height) {
						height = element.style.height;
					}

					if (window.getComputedStyle) {
						computedStyle = getComputedStyle(element, null);
					}
					else {
						computedStyle = element.currentStyle;
					}

					if (computedStyle) {
						if (computedStyle.width) {
							width = computedStyle.width;
						}
						if (computedStyle.height) {
							height = computedStyle.height;
						}
					}
					if (width === '0px') width = 0;
					if (height === '0px') height = 0;
					if (width === null) width = 0;
					if (height === null) height = 0;

					return { width: width, height: height };
				},

				initAnimate: function () {

				},

				sizeStyleChanged: function (resizeFn) {
					var that = this;

					var watchedElementData;

					var checkForChanges = function (mutations) {
						var data = watchedElementData;
						if (mutations && mutations[0] && mutations[0].attributeName === 'style' && mutations[0].type === 'attributes') {
							if (data.element.offsetWidth !== data.offsetWidth ||
								data.element.offsetHeight !== data.offsetHeight) {
								data.offsetWidth = data.element.offsetWidth;
								data.offsetHeight = data.element.offsetHeight;
								if (that.isRendered()) {
									data.callback();
								}
							}
						}
					}

					watchedElementData = {
						element: that[0],
						offsetWidth: that[0].offsetWidth,
						offsetHeight: that[0].offsetHeight,
						callback: resizeFn
					};

					try {
						if (!that.elementStyleObserver) {
							that.elementStyleObserver = new MutationObserver(checkForChanges);
							that.elementStyleObserver.observe(that[0], {
								attributes: true,
								childList: false,
								characterData: false
							});

						}
					}
					catch (error) { }
				},

				position: function () {
					if (!this[0]) {
						return;
					}

					var elem = this[0],

						// Get *real* offsetParent
						offsetParent = this.offsetParent(),

						// Get correct offsets
						offset = this.offset(),
						parentOffset = rroot.test(offsetParent[0].nodeName) ? { top: 0, left: 0 } : offsetParent.offset();

					// Subtract element margins
					// note: when an element has margin: auto the offsetLeft and marginLeft
					// are the same in Safari causing offset.left to incorrectly be 0
					offset.top -= parseFloat(JQXLite.css(elem, "marginTop")) || 0;
					offset.left -= parseFloat(JQXLite.css(elem, "marginLeft")) || 0;

					// Add offsetParent borders
					parentOffset.top += parseFloat(JQXLite.css(offsetParent[0], "borderTopWidth")) || 0;
					parentOffset.left += parseFloat(JQXLite.css(offsetParent[0], "borderLeftWidth")) || 0;

					// Subtract the two offsets
					return {
						top: offset.top - parentOffset.top,
						left: offset.left - parentOffset.left
					};
				},

				offsetParent: function () {
					return this.map(function () {
						var offsetParent = this.offsetParent || document.body;
						while (offsetParent && (!rroot.test(offsetParent.nodeName) && JQXLite.css(offsetParent, "position") === "static")) {
							offsetParent = offsetParent.offsetParent;
						}
						return offsetParent || document.body;
					});
				}
			});
			// Create scrollLeft and scrollTop methods
			JQXLite.each({ scrollLeft: "pageXOffset", scrollTop: "pageYOffset" }, function (method, prop) {
				var top = /Y/.test(prop);

				JQXLite.fn[method] = function (val) {
					return JQXLite.access(this, function (elem, method, val) {
						var win = getWindow(elem);

						if (val === undefined) {
							return win ? (prop in win) ? win[prop] :
								win.document.documentElement[method] :
								elem[method];
						}

						if (win) {
							win.scrollTo(
								!top ? val : JQXLite(win).scrollLeft(),
								top ? val : JQXLite(win).scrollTop()
							);

						} else {
							elem[method] = val;
						}
					}, method, val, arguments.length, null);
				};
			});

			function getWindow(elem) {
				return JQXLite.isWindow(elem) ?
					elem :
					elem.nodeType === 9 ?
						elem.defaultView || elem.parentWindow :
						false;
			}
			// Create innerHeight, innerWidth, height, width, outerHeight and outerWidth methods
			JQXLite.each({ Height: "height", Width: "width" }, function (name, type) {
				JQXLite.each({ padding: "inner" + name, content: type, "": "outer" + name }, function (defaultExtra, funcName) {
					// margin is only for outerHeight, outerWidth
					JQXLite.fn[funcName] = function (margin, value) {
						var chainable = arguments.length && (defaultExtra || typeof margin !== "boolean"),
							extra = defaultExtra || (margin === true || value === true ? "margin" : "border");

						return JQXLite.access(this, function (elem, type, value) {
							var doc;

							if (JQXLite.isWindow(elem)) {
								// As of 5/8/2012 this will yield incorrect results for Mobile Safari, but there
								// isn't a whole lot we can do. See pull request at this URL for discussion:
								// https://github.com/jqx/jqx/pull/764
								return elem.document.documentElement["client" + name];
							}

							// Get document width or height
							if (elem.nodeType === 9) {
								doc = elem.documentElement;

								// Either scroll[Width/Height] or offset[Width/Height] or client[Width/Height], whichever is greatest
								// unfortunately, this causes bug #3838 in IE6/8 only, but there is currently no good, small way to fix it.
								return Math.max(
									elem.body["scroll" + name], doc["scroll" + name],
									elem.body["offset" + name], doc["offset" + name],
									doc["client" + name]
								);
							}

							return value === undefined ?
								// Get width or height on the element, requesting but not forcing parseFloat
								JQXLite.css(elem, type, value, extra) :

								// Set width or height on the element
								JQXLite.style(elem, type, value, extra);
						}, type, chainable ? margin : undefined, chainable, null);
					};
				});
			});
			// Expose JQXLite to the global object
			window.JQXLite = window.jqxHelper = JQXLite;

			// Expose JQXLite as an AMD module, but only for AMD loaders that
			// understand the issues with loading multiple versions of JQXLite
			// in a page that all might call define(). The loader will indicate
			// they have special allowances for multiple JQXLite versions by
			// specifying define.amd.JQXLite = true. Register as a named module,
			// since JQXLite can be concatenated with other files that may use define,
			// but not use a proper concatenation script that understands anonymous
			// AMD modules. A named AMD is safest and most robust way to register.
			// Lowercase jqx is used because AMD module names are derived from
			// file names, and JQXLite is normally delivered in a lowercase file name.
			// Do this after creating the global so that if an AMD module wants to call
			// noConflict to hide this version of JQXLite, it will work.
			if ( true && __webpack_require__.amdO.JQXLite) {
				!(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = (function () { return JQXLite; }).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
			}

		})(window);
	}

	// jqxHelper
	(function (window) {
		if (window.jqxCore) {
			window.$$ = window.minQuery = window.JQXLite;

			if (!window.$) {
				window.$ = window.minQuery;
			}

			return;
		}

		if (window.jQuery) {
			window.minQuery = window.JQXLite = window.jQuery;
			return;
		}

		if (!window.$) {
			window.$ = window.minQuery = window.JQXLite;
		}
		else {
			window.minQuery = window.JQXLite = window.$;
		}
	})(window);
	// End of jqxHelper

	JQXLite.generateID = function () {
		var S4 = function () {
			return (((1 + Math.random()) * 0x10000) | 0).toString(16).substring(1);
		};

		var id = "";
		do {
			id = "jqx" + S4() + S4() + S4();
		} while ($('#' + id).length > 0);

		return id;
	}

	var jqxBaseFramework = window.jqxBaseFramework = window.minQuery || window.jQuery;

	(function ($) {

		$.jqx = $.jqx || {}
		window.jqx = $.jqx;

		var jqwidgets = {
			createInstance: function (selector, widgetName, params) {
				if (widgetName == 'jqxDataAdapter') {
					var source = params[0];
					var settings = params[1] || {};
					return new $.jqx.dataAdapter(source, settings);
				}

				$(selector)[widgetName](params || {});
				return $(selector)[widgetName]('getInstance');
			}
		};

		window.jqwidgets = jqwidgets;

		$.jqx.define = function (namespace, classname, baseclass) {
			namespace[classname] = function () {
				if (this.baseType) {
					this.base = new namespace[this.baseType]();
					this.base.defineInstance();
				}
				this.defineInstance();
				this.metaInfo();
			}

			namespace[classname].prototype.defineInstance = function () { };
			namespace[classname].prototype.metaInfo = function () { };
			namespace[classname].prototype.base = null;
			namespace[classname].prototype.baseType = undefined;

			if (baseclass && namespace[baseclass])
				namespace[classname].prototype.baseType = baseclass;
		}

		// method call
		$.jqx.invoke = function (object, args) {
			if (args.length == 0)
				return;

			var method = typeof (args) == Array || args.length > 0 ? args[0] : args;
			var methodArg = typeof (args) == Array || args.length > 1 ? Array.prototype.slice.call(args, 1) : $({}).toArray();

			while (object[method] == undefined && object.base != null) {
				if (object[method] != undefined && $.isFunction(object[method]))
					return object[method].apply(object, methodArg);

				if (typeof method == 'string') {
					var methodLowerCase = method.toLowerCase();
					if (object[methodLowerCase] != undefined && $.isFunction(object[methodLowerCase])) {
						return object[methodLowerCase].apply(object, methodArg);
					}
				}
				object = object.base;
			}

			if (object[method] != undefined && $.isFunction(object[method]))
				return object[method].apply(object, methodArg);

			if (typeof method == 'string') {
				var methodLowerCase = method.toLowerCase();
				if (object[methodLowerCase] != undefined && $.isFunction(object[methodLowerCase])) {
					return object[methodLowerCase].apply(object, methodArg);
				}
			}

			return;
		}

		$.jqx.getByPriority = function (arr) {
			var value = undefined;
			for (var i = 0; i < arr.length && value == undefined; i++) {
				if (value == undefined && arr[i] != undefined)
					value = arr[i];
			}

			return value;
		}

		$.jqx.hasProperty = function (obj, property) {
			if (typeof (property) == 'object') {
				for (var prop in property) {
					var o = obj;
					while (o) {
						if (o.hasOwnProperty(prop))
							return true;
						if (o.hasOwnProperty(prop.toLowerCase()))
							return true;
						o = o.base;
					}
					return false;
				}
			}
			else {
				while (obj) {
					if (obj.hasOwnProperty(property))
						return true;
					if (obj.hasOwnProperty(property.toLowerCase()))
						return true;
					obj = obj.base;
				}
			}

			return false;
		}

		$.jqx.hasFunction = function (object, args) {
			if (args.length == 0)
				return false;

			if (object == undefined)
				return false;

			var method = typeof (args) == Array || args.length > 0 ? args[0] : args;
			var methodArg = typeof (args) == Array || args.length > 1 ? Array.prototype.slice.call(args, 1) : {};

			while (object[method] == undefined && object.base != null) {
				if (object[method] && $.isFunction(object[method]))
					return true;

				if (typeof method == 'string') {
					var methodLowerCase = method.toLowerCase();
					if (object[methodLowerCase] && $.isFunction(object[methodLowerCase]))
						return true;
				}
				object = object.base;
			}

			if (object[method] && $.isFunction(object[method]))
				return true;

			if (typeof method == 'string') {
				var methodLowerCase = method.toLowerCase();
				if (object[methodLowerCase] && $.isFunction(object[methodLowerCase]))
					return true;
			}

			return false;
		}

		$.jqx.isPropertySetter = function (obj, args) {
			if (args.length == 1 && typeof (args[0]) == 'object')
				return true;

			if (args.length == 2 &&
				typeof (args[0]) == 'string' &&
				!$.jqx.hasFunction(obj, args)) {
				return true;
			}

			return false;
		}

		$.jqx.validatePropertySetter = function (obj, args, suppressException) {
			if (!$.jqx.propertySetterValidation)
				return true;

			if (args.length == 1 && typeof (args[0]) == 'object') {
				for (var i in args[0]) {
					var o = obj;
					while (!o.hasOwnProperty(i) && o.base)
						o = o.base;

					if (!o || !o.hasOwnProperty(i)) {
						if (!suppressException) {
							var hasLowerCase = o.hasOwnProperty(i.toString().toLowerCase());
							if (!hasLowerCase) {
								throw 'Invalid property: ' + i;
							}
							else return true;
						}
						return false;
					}
				}

				return true;
			}

			if (args.length != 2) {
				if (!suppressException)
					throw 'Invalid property: ' + args.length >= 0 ? args[0] : '';

				return false;
			}

			while (!obj.hasOwnProperty(args[0]) && obj.base)
				obj = obj.base;

			if (!obj || !obj.hasOwnProperty(args[0])) {
				if (!suppressException)
					throw 'Invalid property: ' + args[0];

				return false;
			}

			return true;
		}

		if (!Object.keys) {
			Object.keys = (function () {
				'use strict';
				var hasOwnProperty = Object.prototype.hasOwnProperty,
					hasDontEnumBug = !({ toString: null }).propertyIsEnumerable('toString'),
					dontEnums = [
						'toString',
						'toLocaleString',
						'valueOf',
						'hasOwnProperty',
						'isPrototypeOf',
						'propertyIsEnumerable',
						'constructor'
					],
					dontEnumsLength = dontEnums.length;

				return function (obj) {
					if (typeof obj !== 'object' && (typeof obj !== 'function' || obj === null)) {
						throw new TypeError('Object.keys called on non-object');
					}

					var result = [], prop, i;

					for (prop in obj) {
						if (hasOwnProperty.call(obj, prop)) {
							result.push(prop);
						}
					}

					if (hasDontEnumBug) {
						for (i = 0; i < dontEnumsLength; i++) {
							if (hasOwnProperty.call(obj, dontEnums[i])) {
								result.push(dontEnums[i]);
							}
						}
					}
					return result;
				};
			}());
		}

		$.jqx.set = function (object, args) {
			var newValuesLength = 0;
			if (args.length == 1 && typeof (args[0]) == 'object') {
				if (object.isInitialized && Object.keys && Object.keys(args[0]).length > 1) {
					var element = !object.base ? object.element : object.base.element;
					var initArgs = $.data(element, object.widgetName).initArgs;
					if (initArgs && JSON && JSON.stringify && args[0] && initArgs[0]) {
						try {
							if (JSON.stringify(args[0]) == JSON.stringify(initArgs[0])) {
								var toReturn = true;
								$.each(args[0], function (key, value) {
									if (object[key] != value) {
										toReturn = false;
										return false;
									}
								});
								if (toReturn) {
									return;
								}
							}
						}
						catch (err) {
						}
					}
					object.batchUpdate = args[0];
					var oldValues = {};
					var newValues = {};
					$.each(args[0], function (key, value) {
						var obj = object;
						while (!obj.hasOwnProperty(key) && obj.base != null)
							obj = obj.base;

						if (obj.hasOwnProperty(key)) {
							if (object[key] != value) {
								oldValues[key] = object[key];
								newValues[key] = value;
								newValuesLength++;
							}
						}
						else if (obj.hasOwnProperty(key.toLowerCase())) {
							if (object[key.toLowerCase()] != value) {
								oldValues[key.toLowerCase()] = object[key.toLowerCase()];
								newValues[key.toLowerCase()] = value;
								newValuesLength++;
							}
						}
					});
					if (newValuesLength < 2) {
						object.batchUpdate = null;
					}
				}

				$.each(args[0], function (key, value) {
					var obj = object;
					while (!obj.hasOwnProperty(key) && obj.base != null)
						obj = obj.base;

					if (obj.hasOwnProperty(key)) {
						$.jqx.setvalueraiseevent(obj, key, value);
					}
					else if (obj.hasOwnProperty(key.toLowerCase())) {
						$.jqx.setvalueraiseevent(obj, key.toLowerCase(), value);
					}
					else if ($.jqx.propertySetterValidation)
						throw "jqxCore: invalid property '" + key + "'";
				});

				if (object.batchUpdate != null) {
					object.batchUpdate = null;
					if (object.propertiesChangedHandler && newValuesLength > 1) {
						object.propertiesChangedHandler(object, oldValues, newValues);
					}
				}
			}
			else if (args.length == 2) {
				while (!object.hasOwnProperty(args[0]) && object.base)
					object = object.base;

				if (object.hasOwnProperty(args[0])) {
					$.jqx.setvalueraiseevent(object, args[0], args[1]);
				}
				else if (object.hasOwnProperty(args[0].toLowerCase())) {
					$.jqx.setvalueraiseevent(object, args[0].toLowerCase(), args[1]);
				}
				else if ($.jqx.propertySetterValidation)
					throw "jqxCore: invalid property '" + args[0] + "'";
			}
		}

		$.jqx.setvalueraiseevent = function (object, key, value) {
			var oldVal = object[key];

			object[key] = value;

			if (!object.isInitialized)
				return;

			if (object.propertyChangedHandler != undefined)
				object.propertyChangedHandler(object, key, oldVal, value);

			if (object.propertyChangeMap != undefined && object.propertyChangeMap[key] != undefined)
				object.propertyChangeMap[key](object, key, oldVal, value);
		};

		$.jqx.get = function (object, args) {
			if (args == undefined || args == null)
				return undefined;

			if (object.propertyMap) {
				var newVal = object.propertyMap(args);
				if (newVal != null)
					return newVal;
			}

			if (object.hasOwnProperty(args))
				return object[args];

			if (object.hasOwnProperty(args.toLowerCase()))
				return object[args.toLowerCase()];

			var arg = undefined;
			if (typeof (args) == Array) {
				if (args.length != 1)
					return undefined;
				arg = args[0];
			}
			else if (typeof (args) == 'string')
				arg = args;

			while (!object.hasOwnProperty(arg) && object.base)
				object = object.base;

			if (object)
				return object[arg];

			return undefined;
		}

		$.jqx.serialize = function (obj) {
			var txt = '';
			if ($.isArray(obj)) {
				txt = '['
				for (var i = 0; i < obj.length; i++) {
					if (i > 0)
						txt += ', ';
					txt += $.jqx.serialize(obj[i]);
				}
				txt += ']';
			}
			else if (typeof (obj) == 'object') {
				txt = '{';
				var j = 0;
				for (var i in obj) {
					if (j++ > 0)
						txt += ', ';
					txt += i + ': ' + $.jqx.serialize(obj[i]);
				}
				txt += '}';
			}
			else
				txt = obj.toString();

			return txt;
		}

		$.jqx.propertySetterValidation = true;

		$.jqx.jqxWidgetProxy = function (controlName, element, args) {
			var host = $(element);
			var vars = $.data(element, controlName);
			if (vars == undefined) {
				return undefined;
			}

			var obj = vars.instance;

			if ($.jqx.hasFunction(obj, args))
				return $.jqx.invoke(obj, args);

			if ($.jqx.isPropertySetter(obj, args)) {
				if ($.jqx.validatePropertySetter(obj, args)) {
					$.jqx.set(obj, args);
					return undefined;
				}
			} else {
				if (typeof (args) == 'object' && args.length == 0)
					return;
				else if (typeof (args) == 'object' && args.length == 1 && $.jqx.hasProperty(obj, args[0]))
					return $.jqx.get(obj, args[0]);
				else if (typeof (args) == 'string' && $.jqx.hasProperty(obj, args[0]))
					return $.jqx.get(obj, args);
			}

			throw "jqxCore: Invalid parameter '" + $.jqx.serialize(args) + "' does not exist.";
			//      return undefined;
		}

		$.jqx.applyWidget = function (element, controlName, args, instance) {
			var WinJS = false;
			try {
				WinJS = window.MSApp != undefined;
			}
			catch (e) {
			}

			var host = $(element);
			if (!instance) {
				instance = new $.jqx['_' + controlName]();
			}
			else {
				instance.host = host;
				instance.element = element;
			}
			if (element.id == "") {
				element.id = $.jqx.utilities.createId();
			}

			var vars = { host: host, element: element, instance: instance, initArgs: args };

			instance.widgetName = controlName;
			$.data(element, controlName, vars);
			$.data(element, 'jqxWidget', vars.instance);

			var inits = new Array();
			var instance = vars.instance;
			while (instance) {
				instance.isInitialized = false;
				inits.push(instance);
				instance = instance.base;
			}
			inits.reverse();
			inits[0].theme = $.jqx.theme || '';

			$.jqx.jqxWidgetProxy(controlName, element, args);

			for (var i in inits) {
				instance = inits[i];
				if (i == 0) {
					instance.host = host;
					instance.element = element;
					instance.WinJS = WinJS;
				}
				if (instance != undefined) {
					if (instance.definedInstance) {
						instance.definedInstance();
					}
					if (instance.createInstance != null) {
						if (WinJS) {
							MSApp.execUnsafeLocalFunction(function () {
								instance.createInstance(args);
							});
						}
						else {
							instance.createInstance(args);
						}
					}
				}
			}

			for (var i in inits) {
				if (inits[i] != undefined) {
					inits[i].isInitialized = true;
				}
			}

			if (WinJS) {
				MSApp.execUnsafeLocalFunction(function () {
					vars.instance.refresh(true);
				});
			}
			else {
				vars.instance.refresh(true);
			}

		}

		$.jqx.jqxWidget = function (name, base, params) {

			var WinJS = false;
			try {
				var jqxArgs = Array.prototype.slice.call(params, 0);
			}
			catch (e) {
				var jqxArgs = '';
			}

			try {
				WinJS = window.MSApp != undefined;
			}
			catch (e) {
			}

			var controlName = name;

			var baseControl = '';
			if (base)
				baseControl = '_' + base;
			$.jqx.define($.jqx, '_' + controlName, baseControl);

			var widgets = new Array();

			if (!window[controlName]) {
				var serializeObject = function (data) {
					if (data == null) return "";
					var dataType = $.type(data);
					switch (dataType) {
						case "string":
						case "number":
						case "date":
						case "boolean":
						case "bool":
							if (data === null)
								return "";
							return data.toString()
					}

					var str = "";
					$.each(data, function (index, value) {
						var val = value;
						if (index > 0) str += ', ';
						str += "[";
						var m = 0;

						if ($.type(val) == "object") {
							for (var obj in val) {
								if (m > 0) str += ', ';
								str += '{' + obj + ":" + val[obj] + '}';
								m++;
							}
						}
						else {
							if (m > 0) str += ', ';
							str += '{' + index + ":" + val + '}';
							m++;
						}

						str += "]";
					});
					return str;
				}

				jqwidgets[controlName] = window[controlName] = function (selector, params) {
					var args = [];
					if (!params) {
						params = {};
					}
					args.push(params);

					var uid = selector;
					if ($.type(uid) === "object" && selector[0]) {
						uid = selector[0].id;
						if (uid === "") {
							uid = selector[0].id = $.jqx.utilities.createId();
						}
					} else if ($.type(selector) === "object" && selector && selector.nodeName) {
						uid = selector.id;
						if (uid === "") {
							uid = selector.id = $.jqx.utilities.createId();
						}
					}

					if (window.jqxWidgets && window.jqxWidgets[uid]) {
						if (params) {
							$.each(window.jqxWidgets[uid], function (index) {
								var data = $(this.element).data();
								if (data && data.jqxWidget) {
									$(this.element)[controlName](params);
								}
							});
						}
						if (window.jqxWidgets[uid].length == 1) {
							var data = $(window.jqxWidgets[uid][0].widgetInstance.element).data();
							if (data && data.jqxWidget) {
								return window.jqxWidgets[uid][0];
							}
						}

						var data = $(window.jqxWidgets[uid][0].widgetInstance.element).data();
						if (data && data.jqxWidget) {
							return window.jqxWidgets[uid];
						}
					}

					var elements = $(selector);
					if (elements.length === 0) {
						elements = $("<div></div>");
						if (controlName === "jqxInput" || controlName === "jqxPasswordInput" || controlName === "jqxMaskedInput") {
							elements = $("<input/>");
						}
						if (controlName === "jqxTextArea") {
							elements = $("<textarea></textarea>");
						}
						if (controlName === "jqxButton" || controlName === "jqxRepeatButton" || controlName === "jqxToggleButton") {
							elements = $("<button/>");
						}
						if (controlName === "jqxSplitter") {
							elements = $("<div><div>Panel 1</div><div>Panel 2</div></div>");
						}
						if (controlName === "jqxTabs") {
							elements = $("<div><ul><li>Tab 1</li><li>Tab 2</li></ul><div>Content 1</div><div>Content 2</div></div>");
						}
						if (controlName === "jqxRibbon") {
							elements = $("<div><ul><li>Tab 1</li><li>Tab 2</li></ul><div><div>Content 1</div><div>Content 2</div></div></div>");
						}
						if (controlName === "jqxDocking") {
							elements = $("<div><div><div><div>Title 1</div><div>Content 1</div></div></div></div>");
						}
						if (controlName === "jqxWindow") {
							elements = $("<div><div>Title 1</div><div>Content 1</div></div>");
						}
					}
					var instances = [];


					$.each(elements, function (index) {
						var element = elements[index];
						$.jqx.applyWidget(element, controlName, args, undefined);
						if (!widgets[controlName]) {
							var instance = $.data(element, 'jqxWidget');
							var properties = $.jqx["_" + controlName].prototype.defineInstance();
							var metaInfo = {};

							if ($.jqx["_" + controlName].prototype.metaInfo) {
								metaInfo = $.jqx["_" + controlName].prototype.metaInfo();
							}

							if (controlName == "jqxDockingLayout") {
								properties = $.extend(properties, $.jqx["_jqxLayout"].prototype.defineInstance());
							}
							if (controlName == "jqxToggleButton" || controlName == "jqxRepeatButton") {
								properties = $.extend(properties, $.jqx["_jqxButton"].prototype.defineInstance());
							}
							if (controlName == "jqxTreeGrid") {
								properties = $.extend(properties, $.jqx["_jqxDataTable"].prototype.defineInstance());
							}

							var widgetConstructor = function (element) {
								var instance = $.data(element, 'jqxWidget');
								this.widgetInstance = instance;
								var widget = $.extend(this, instance);
								widget.on = widget.addEventListener = function (eventName, callback) {
									widget.addHandler(!widget.base ? widget.host : widget.base.host, eventName, callback);
								}
								widget.off = widget.removeEventListener = function (eventName) {
									widget.removeHandler(!widget.base ? widget.host : widget.base.host, eventName);
								}

								for (var obj in instance) {
									if ($.type(instance[obj]) == "function") {
										widget[obj] = $.proxy(instance[obj], instance);
									}
								}
								return widget;
							}
							widgets[controlName] = widgetConstructor;

							// widget properties
							$.each(properties, function (property, currentValue) {
								Object.defineProperty(widgetConstructor.prototype, property, {
									get: function () {
										if (this.widgetInstance) {
											return this.widgetInstance[property];
										}
										return currentValue;
									},
									set: function (newValue) {
										if (this.widgetInstance && (this.widgetInstance[property] != newValue || property === "width" || property === "height")) {
											var key1 = this.widgetInstance[property];
											var key2 = newValue;
											var dataType1 = $.type(key1);
											var dataType2 = $.type(key2);
											var differentTypes = false;
											if (dataType1 != dataType2 || property === "source" || property === "width" || property === "height") {
												differentTypes = true;
											}
											if (differentTypes || (serializeObject(key1) != serializeObject(key2))) {
												var settings = {};
												settings[property] = newValue;
												if (this.widgetInstance.host) {
													this.widgetInstance.host[controlName](settings);
												}
												else {
													this.widgetInstance.base.host[controlName](settings);
												}
												this.widgetInstance[property] = newValue;
												if (this.widgetInstance.propertyUpdated) {
													this.widgetInstance.propertyUpdated(property, key1, newValue);
												}
											}
										}
									}
								});
							});
						}
						var instance = new widgets[controlName](element);

						instances.push(instance);
						if (!window.jqxWidgets) {
							window.jqxWidgets = new Array();
						}
						if (!window.jqxWidgets[uid]) {
							window.jqxWidgets[uid] = new Array();
						}
						window.jqxWidgets[uid].push(instance);
					});

					if (instances.length === 1)
						return instances[0];

					return instances;

				}
			}

			$.fn[controlName] = function () {
				var args = Array.prototype.slice.call(arguments, 0);

				if (args.length == 0 || (args.length == 1 && typeof (args[0]) == 'object')) {
					if (this.length == 0) {
						if (this.selector) {
							throw new Error('Invalid Selector - ' + this.selector + '! Please, check whether the used ID or CSS Class name is correct.');
						}
						else {
							throw new Error('Invalid Selector! Please, check whether the used ID or CSS Class name is correct.');
						}
					}

					return this.each(function () {
						var host = $(this);
						var element = this; // element == this == host[0]
						var vars = $.data(element, controlName);

						if (vars == null) {
							$.jqx.applyWidget(element, controlName, args, undefined);
						}
						else {
							$.jqx.jqxWidgetProxy(controlName, this, args);
						}
					}); // each
				}
				else {
					if (this.length == 0) {
						if (this.selector) {
							throw new Error('Invalid Selector - ' + this.selector + '! Please, check whether the used ID or CSS Class name is correct.');
						}
						else {
							throw new Error('Invalid Selector! Please, check whether the used ID or CSS Class name is correct.');
						}
					}

					var returnVal = null;

					var cnt = 0;
					this.each(function () {
						var result = $.jqx.jqxWidgetProxy(controlName, this, args);

						if (cnt == 0) {
							returnVal = result;
							cnt++;
						}
						else {
							if (cnt == 1) {
								var tmp = [];
								tmp.push(returnVal);
								returnVal = tmp;
							}
							returnVal.push(result);
						}
					}); // each
				}

				return returnVal;
			}

			try {
				$.extend($.jqx['_' + controlName].prototype, Array.prototype.slice.call(params, 0)[0]);
			}
			catch (e) {
			}

			$.extend($.jqx['_' + controlName].prototype, {
				toThemeProperty: function (propertyName, override) {
					return $.jqx.toThemeProperty(this, propertyName, override);
				},

				isMaterialized: function () {
					if (!this.theme) {
						return false;
					}

					if (this.theme === "fluent") {
						return true;
					}

					if (this.theme === "light") {
						return true;
					}


					if (this.theme === "dark") {
						return true;
					}

					if (this.theme === "deepblue") {
						return true;
					}

					if (this.theme.indexOf("material") >= 0) {
						return true;
					}
				},

				isModern: function () {
					if (!this.theme) {
						return false;
					}

					if (this.theme.indexOf("light") >= 0) {
						return true;
					}

					if (this.theme === "dark") {
						return true;
					}
				},

				_addBarAndLabel: function (host) {
					var that = this;

					var label = $("<label></label");
					label[0].innerHTML = this.placeHolder;
					label.addClass(that.toThemeProperty('jqx-input-label'));
					host.after(label);
					that.label = label;

					var bar = $("<span></span>");
					host.after(bar);
					bar.addClass(that.toThemeProperty('jqx-input-bar'));
					that.bar = bar;
					that.bar.css('top', this.host.height());
				}
			});

			$.jqx['_' + controlName].prototype.refresh = function () {
				if (this.base)
					this.base.refresh(true);
			}
			$.jqx['_' + controlName].prototype.createInstance = function () {
			}

			$.jqx.isPassiveSupported = function () {
				var that = this;

				if (that.supportsPassive !== undefined) {
					return that.supportsPassive;
				}

				that.supportsPassive = false;
				try {
					var opts = Object.defineProperty({
					}, 'passive', {
						// eslint-disable-next-line getter-return
						get: function () {
							that.supportsPassive = true;
						}
					});
					window.addEventListener('testPassive', null, opts);
					window.removeEventListener('testPassive', null, opts);
				}
				catch (e) {
					//
				}

				return that.supportsPassive;
			}

			$.jqx['_' + controlName].prototype.addEventHandler = function (event, fnHandler) {
				if (this.base) {
					this.base.host.on(event, fnHandler);
				}
				else {
					this.host.on(event, fnHandler);
				}
			}

			$.jqx['_' + controlName].prototype.removeEventHandler = function (event, fnHandler) {
				if (this.base) {
					this.base.host.off(event);
				}
				else {
					this.host.off(event);
				}
			}

			$.jqx['_' + controlName].prototype.applyTo = function (element, args) {
				if (!(args instanceof Array)) {
					var a = [];
					a.push(args);
					args = a;
				}

				$.jqx.applyWidget(element, controlName, args, this);
			}

			$.jqx['_' + controlName].prototype.getInstance = function () {
				return this;
			}
			$.jqx['_' + controlName].prototype.propertyChangeMap = {};

			$.jqx['_' + controlName].prototype.addHandler = function (source, events, func, data) {
				$.jqx.addHandler($(source), events, func, data);
			};

			$.jqx['_' + controlName].prototype.removeHandler = function (source, events, func) {
				$.jqx.removeHandler($(source), events, func);
			};

			$.jqx['_' + controlName].prototype.setOptions = function () {
				if (!this.host || !this.host.length || this.host.length != 1)
					return;

				return $.jqx.jqxWidgetProxy(controlName, this.host[0], arguments);
			};
		} // jqxWidget

		$.jqx.toThemeProperty = function (instance, propertyName, override) {
			if (instance.theme == '')
				return propertyName;

			var split = propertyName.split(' ');
			var result = '';
			for (var i = 0; i < split.length; i++) {
				if (i > 0)
					result += ' ';

				var key = split[i];

				if (override != null && override)
					result += key + '-' + instance.theme;
				else
					result += key + ' ' + key + '-' + instance.theme;
			}

			return result;
		}

		$.jqx.addHandler = function (source, eventsList, func, data) {
			var events = eventsList.split(' ');

			for (var i = 0; i < events.length; i++) {
				var event = events[i];

				if (window.addEventListener && source[0]) {
					switch (event) {
						case 'mousewheel':
							if ($.jqx.browser.mozilla) {
								source[0].addEventListener('DOMMouseScroll', func, $.jqx.isPassiveSupported() ? { passive: false } : false);
							}
							else {
								source[0].addEventListener('mousewheel', func, $.jqx.isPassiveSupported() ? { passive: false } : false);
							}
							continue;
						case 'mousemove':
							if (!data) {
								source[0].addEventListener('mousemove', func, false);
								continue;
							}
							break;
						case 'touchmove':
							if (!data) {
								source[0].addEventListener('touchmove', func, false);
								continue;
							}
							else if (data && data.passive) {
								source[0].addEventListener('touchmove', func, data);
								continue;
							}

							break;
					}
				}

				if (data == undefined || data == null) {
					if (source.on)
						source.on(event, func);
					else
						source.bind(event, func);
				}
				else {
					if (source.on)
						source.on(event, data, func);
					else
						source.bind(event, data, func);
				}
			} // for
		};

		$.jqx.removeHandler = function (source, eventsList, func) {
			if (!eventsList) {
				if (source.off)
					source.off();
				else
					source.unbind();
				return;
			}
			var events = eventsList.split(' ');

			for (var i = 0; i < events.length; i++) {
				var event = events[i];

				if (window.removeEventListener) {
					switch (event) {
						case 'mousewheel':
							if ($.jqx.browser.mozilla) {
								source[0].removeEventListener('DOMMouseScroll', func, false);
							}
							else {
								source[0].removeEventListener('mousewheel', func, false);
							}
							continue;
						case 'mousemove':
							if (func) {
								source[0].removeEventListener('mousemove', func, false);
								continue;
							}
							break;
						case 'touchmove':
							if (func) {
								source[0].removeEventListener('touchmove', func, false);
								continue;
							}
							break;
					}
				}

				if (event == undefined) {
					if (source.off)
						source.off();
					else
						source.unbind();
					continue;
				}

				if (func == undefined) {
					if (source.off)
						source.off(event);
					else
						source.unbind(event);
				}
				else {
					if (source.off)
						source.off(event, func);
					else
						source.unbind(event, func);
				}
			}
		};

		$.jqx.credits = $.jqx.credits || "";
		$.jqx.theme = $.jqx.theme || "";
		$.jqx.scrollAnimation = $.jqx.scrollAnimation || false;
		$.jqx.resizeDelay = $.jqx.resizeDelay || 10;

		$.jqx.ready = function () {
			$(window).trigger('jqxReady');
		}
		$.jqx.init = function () {
			$.each(arguments[0], function (index, value) {
				if (index == "theme") {
					$.jqx.theme = value;
				}
				if (index == "scrollBarSize") {
					$.jqx.utilities.scrollBarSize = value;
				}
				if (index == "touchScrollBarSize") {
					$.jqx.utilities.touchScrollBarSize = value;
				}
				if (index == "scrollBarButtonsVisibility") {
					$.jqx.utilities.scrollBarButtonsVisibility = value;
				}
			});
		}

		// Utilities
		$.jqx.utilities = $.jqx.utilities || {};
		$.extend($.jqx.utilities,
			{
				scrollBarSize: 13,
				touchScrollBarSize: 8,
				scrollBarButtonsVisibility: "visible",
				createId: function () {
					var S4 = function () {
						return (((1 + Math.random()) * 0x10000) | 0).toString(16).substring(1);
					};
					return "jqxWidget" + S4() + S4() + S4();
				},

				setTheme: function (oldTheme, theme, element) {
					if (typeof element === 'undefined') {
						return;
					}

					if (!element[0].className.split) {
						return;
					}

					if (oldTheme === undefined) {
						oldTheme = '';
					}

					if (theme === undefined) {
						theme = '';
					}

					var classNames = element[0].className.split(' '),
						oldClasses = [], newClasses = [],
						children = element.children();
					for (var i = 0; i < classNames.length; i += 1) {
						if (classNames[i].indexOf(oldTheme) >= 0) {
							if (oldTheme.length > 0) {
								oldClasses.push(classNames[i]);
								newClasses.push(classNames[i].replace(oldTheme, theme));
							}
							else {
								newClasses.push(classNames[i].replace("-" + theme, "") + '-' + theme);
							}
						}
					}
					this._removeOldClasses(oldClasses, element);
					this._addNewClasses(newClasses, element);
					for (var i = 0; i < children.length; i += 1) {
						this.setTheme(oldTheme, theme, $(children[i]));
					}
				},

				_removeOldClasses: function (classes, element) {
					for (var i = 0; i < classes.length; i += 1) {
						element.removeClass(classes[i]);
					}
				},

				_addNewClasses: function (classes, element) {
					for (var i = 0; i < classes.length; i += 1) {
						element.addClass(classes[i]);
					}
				},

				getOffset: function (el) {
					var left = $.jqx.mobile.getLeftPos(el[0]);
					var top = $.jqx.mobile.getTopPos(el[0]);
					return { top: top, left: left };
				},

				resize: function (element, callback, destroy, checkForHidden) {
					if (checkForHidden === undefined) {
						checkForHidden = true;
					}

					var index = -1;
					var that = this;
					var getHiddenIndex = function (element) {
						if (!that.hiddenWidgets) {
							return -1;
						}

						var hiddenIndex = -1;
						for (var i = 0; i < that.hiddenWidgets.length; i++) {
							if (element.id) {
								if (that.hiddenWidgets[i].id == element.id) {
									hiddenIndex = i;
									break;
								}
							}
							else {
								if (that.hiddenWidgets[i].id == element[0].id) {
									hiddenIndex = i;
									break;
								}
							}
						}
						return hiddenIndex;
					}


					if (this.resizeHandlers) {
						for (var i = 0; i < this.resizeHandlers.length; i++) {
							if (element.id) {
								if (this.resizeHandlers[i].id == element.id) {
									index = i;
									break;
								}
							}
							else {
								if (this.resizeHandlers[i].id == element[0].id) {
									index = i;
									break;
								}
							}
						}

						if (destroy === true) {
							if (index != -1) {
								this.resizeHandlers.splice(index, 1);
								if (this.watchedElementData && this.watchedElementData.length > 0) {
									this.watchedElementData.splice(index, 1);
								}
							}

							if (this.resizeHandlers.length == 0) {
								var w = $(window);
								if (w.off) {
									w.off('resize.jqx');
									w.off('orientationchange.jqx');
									w.off('orientationchanged.jqx');
								}
								else {
									w.unbind('resize.jqx');
									w.unbind('orientationchange.jqx');
									w.unbind('orientationchanged.jqx');
								}
								this.resizeHandlers = null;
							}
							var hiddenIndex = getHiddenIndex(element);
							if (hiddenIndex != -1 && this.hiddenWidgets) {
								this.hiddenWidgets.splice(hiddenIndex, 1);
							}
							return;
						}
					}
					else if (destroy === true) {
						var hiddenIndex = getHiddenIndex(element);
						if (hiddenIndex != -1 && this.hiddenWidgets) {
							this.hiddenWidgets.splice(hiddenIndex, 1);
						}
						return;
					}
					var that = this;
					var doResize = function (isHidden, type) {
						if (!that.resizeHandlers)
							return;

						var getParentsCount = function (element) {
							var index = -1;
							var parent = element.parentNode;
							while (parent) {
								index++;
								parent = parent.parentNode;
							}
							return index;
						}

						var compare = function (value1, value2) {
							if (!value1.widget || !value2.widget)
								return 0;

							var parents1 = getParentsCount(value1.widget[0]);
							var parents2 = getParentsCount(value2.widget[0]);

							try {
								if (parents1 < parents2) { return -1; }
								if (parents1 > parents2) { return 1; }
							}
							catch (error) {
								var er = error;
							}

							return 0;
						};
						var handleHiddenWidgets = function (delay) {
							if (that.hiddenWidgets.length > 0) {
								that.hiddenWidgets.sort(compare);
								var updateHiddenWidgets = function () {
									var hasHiddenWidget = false;
									var currentHiddenWidgets = new Array();
									for (var p = 0; p < that.hiddenWidgets.length; p++) {
										var handler = that.hiddenWidgets[p];
										if ($.jqx.isHidden(handler.widget)) {
											hasHiddenWidget = true;
											currentHiddenWidgets.push(handler);
										}
										else {
											if (handler.callback) {
												handler.callback(type);
											}
										}
									}
									that.hiddenWidgets = currentHiddenWidgets;
									if (!hasHiddenWidget) {
										clearInterval(that.__resizeInterval);
									}
								}
								if (delay == false) {
									updateHiddenWidgets();
									if (that.__resizeInterval) clearInterval(that.__resizeInterval);
									return;
								}
								if (that.__resizeInterval) clearInterval(that.__resizeInterval);
								that.__resizeInterval = setInterval(function () {
									updateHiddenWidgets();
								}, 100);
							}
						}

						if (that.hiddenWidgets && that.hiddenWidgets.length > 0) {
							handleHiddenWidgets(false);
						}
						that.hiddenWidgets = new Array();
						that.resizeHandlers.sort(compare);
						for (var i = 0; i < that.resizeHandlers.length; i++) {
							var handler = that.resizeHandlers[i];
							var widget = handler.widget;
							var data = handler.data;
							if (!data) continue;
							if (!data.jqxWidget) continue;

							var width = data.jqxWidget.width;
							var height = data.jqxWidget.height;

							if (data.jqxWidget.base) {
								if (width == undefined) {
									width = data.jqxWidget.base.width;
								}
								if (height == undefined) {
									height = data.jqxWidget.base.height;
								}
							}

							if (width === undefined && height === undefined) {
								width = data.jqxWidget.element.style.width;
								height = data.jqxWidget.element.style.height;
							}

							var percentageSize = false;
							if (width != null && width.toString().indexOf("%") != -1) {
								percentageSize = true;
							}

							if (height != null && height.toString().indexOf("%") != -1) {
								percentageSize = true;
							}

							if ($.jqx.isHidden(widget)) {
								if (getHiddenIndex(widget) === -1) {
									if (percentageSize || isHidden === true) {
										if (handler.data.nestedWidget !== true) {
											that.hiddenWidgets.push(handler);
										}
									}
								}
							}
							else if (isHidden === undefined || isHidden !== true) {
								if (percentageSize) {
									handler.callback(type);
									if (that.watchedElementData) {
										for (var m = 0; m < that.watchedElementData.length; m++) {
											if (that.watchedElementData[m].element == data.jqxWidget.element) {
												that.watchedElementData[m].offsetWidth = data.jqxWidget.element.offsetWidth;
												that.watchedElementData[m].offsetHeight = data.jqxWidget.element.offsetHeight;
												break;
											}
										}
									}
									if (that.hiddenWidgets.indexOf(handler) >= 0) {
										that.hiddenWidgets.splice(that.hiddenWidgets.indexOf(handler), 1);
									}
								}
								if (data.jqxWidget.element) {
									var widgetClass = data.jqxWidget.element.className;
									if (widgetClass.indexOf('dropdownlist') >= 0 || widgetClass.indexOf('datetimeinput') >= 0 || widgetClass.indexOf('combobox') >= 0 || widgetClass.indexOf('menu') >= 0) {
										if (data.jqxWidget.isOpened) {
											var opened = data.jqxWidget.isOpened();
											if (opened) {
												if (type && type == "resize" && $.jqx.mobile.isTouchDevice())
													continue;

												data.jqxWidget.close();
											}
										}
									}
								}
							}
						};

						handleHiddenWidgets();
					}

					if (!this.resizeHandlers) {
						this.resizeHandlers = new Array();

						var w = $(window);
						if (w.on) {
							this._resizeTimer = null;
							this._initResize = null;
							w.on('resize.jqx', function (event) {
								if (that._resizeTimer != undefined) {
									clearTimeout(that._resizeTimer);
								}
								if (!that._initResize) {
									that._initResize = true;
									doResize(null, 'resize');
								}
								else {
									that._resizeTimer = setTimeout(function () {
										doResize(null, 'resize');
									}, $.jqx.resizeDelay);
								}
							});
							w.on('orientationchange.jqx', function (event) {
								doResize(null, 'orientationchange');
							});
							w.on('orientationchanged.jqx', function (event) {
								doResize(null, 'orientationchange');
							});
						}
						else {
							w.bind('resize.jqx', function (event) {
								doResize(null, 'orientationchange');
							});
							w.bind('orientationchange.jqx', function (event) {
								doResize(null, 'orientationchange');
							});
							w.bind('orientationchanged.jqx', function (event) {
								doResize(null, 'orientationchange');
							});
						}
					}
					var elementData = element.data();
					if (checkForHidden) {
						if (index === -1) {
							this.resizeHandlers.push({ id: element[0].id, widget: element, callback: callback, data: elementData });
						}
					}
					try {
						var width = elementData.jqxWidget.width;
						var height = elementData.jqxWidget.height;

						if (elementData.jqxWidget.base) {
							if (width == undefined) {
								width = elementData.jqxWidget.base.width;
							}
							if (height == undefined) {
								height = elementData.jqxWidget.base.height;
							}
						}

						if (width === undefined && height === undefined) {
							width = elementData.jqxWidget.element.style.width;
							height = elementData.jqxWidget.element.style.height;
						}

						var percentageSize = false;
						if (width != null && width.toString().indexOf("%") != -1) {
							percentageSize = true;
						}

						if (height != null && height.toString().indexOf("%") != -1) {
							percentageSize = true;
						}
						if (percentageSize) {
							if (!this.watchedElementData) {
								this.watchedElementData = [];
							}
							var that = this;
							var checkForChanges = function (mutations) {
								if (that.watchedElementData.forEach) {
									that.watchedElementData.forEach(function (data) {
										if (data.element.offsetWidth !== data.offsetWidth ||
											data.element.offsetHeight !== data.offsetHeight) {
											data.offsetWidth = data.element.offsetWidth;
											data.offsetHeight = data.element.offsetHeight;
											if (data.timer) {
												clearTimeout(data.timer);
											}
											data.timer = setTimeout(function () {
												if (!$.jqx.isHidden($(data.element))) {
													data.callback();
												}
												else {
													data.timer = setInterval(function () {
														if (!$.jqx.isHidden($(data.element))) {
															clearInterval(data.timer);
															data.callback();
														}
													}, 100);
												}
											});
										}
									});
								}
							};

							that.watchedElementData.push({
								element: element[0],
								offsetWidth: element[0].offsetWidth,
								offsetHeight: element[0].offsetHeight,
								callback: callback
							});
							if (!that.observer) {
								that.observer = new MutationObserver(checkForChanges);
								that.observer.observe(document.body, {
									attributes: true,
									childList: true,
									characterData: true
								});
							}
						}
					}
					catch (er) {
					}
					if ($.jqx.isHidden(element) && checkForHidden === true) {
						doResize(true);
					}
					$.jqx.resize = function () {
						doResize(null, 'resize');
					}
				},

				parseJSON: function (data) {
					if (!data || typeof data !== "string") {
						return null;
					}
					var rvalidchars = /^[\],:{}\s]*$/,
						rvalidbraces = /(?:^|:|,)(?:\s*\[)+/g,
						rvalidescape = /\\(?:["\\\/bfnrt]|u[\da-fA-F]{4})/g,
						rvalidtokens = /"[^"\\\r\n]*"|true|false|null|-?(?:\d\d*\.|)\d+(?:[eE][\-+]?\d+|)/g;

					// Make sure leading/trailing whitespace is removed (IE can't handle it)
					data = $.trim(data);

					// Attempt to parse using the native JSON parser first
					if (window.JSON && window.JSON.parse) {
						return window.JSON.parse(data);
					}

					// Make sure the incoming data is actual JSON
					// Logic borrowed from http://json.org/json2.js
					if (rvalidchars.test(data.replace(rvalidescape, "@")
						.replace(rvalidtokens, "]")
						.replace(rvalidbraces, ""))) {

						return (new Function("return " + data))();

					}
					throw new Error("Invalid JSON: " + data);
				},

				html: function (element, value) {
					if (!$(element).on || !$.access) {
						return $(element).html(value);
					}
					try {	
						return $.access(element, function (value) {
							var elem = element[0] || {},
								i = 0,
								l = element.length;

							if (value === undefined) {
								return elem.nodeType === 1 ?
									elem.innerHTML.replace(rinlinejQuery, "") :
									undefined;
							}

							var rnoInnerhtml = /<(?:script|style|link)/i,
								nodeNames = "abbr|article|aside|audio|bdi|canvas|data|datalist|details|figcaption|figure|footer|" +
									"header|hgroup|mark|meter|nav|output|progress|section|summary|time|video",
								rxhtmlTag = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\w:]+)[^>]*)\/>/gi,
								rtagName = /<([\w:]+)/,
								rnocache = /<(?:script|object|embed|option|style)/i,
								rnoshimcache = new RegExp("<(?:" + nodeNames + ")[\\s/>]", "i"),
								rleadingWhitespace = /^\s+/,
								wrapMap = {
									option: [1, "<select multiple='multiple'>", "</select>"],
									legend: [1, "<fieldset>", "</fieldset>"],
									thead: [1, "<table>", "</table>"],
									tr: [2, "<table><tbody>", "</tbody></table>"],
									td: [3, "<table><tbody><tr>", "</tr></tbody></table>"],
									col: [2, "<table><tbody></tbody><colgroup>", "</colgroup></table>"],
									area: [1, "<map>", "</map>"],
									_default: [0, "", ""]
								};

							if (typeof value === "string" && !rnoInnerhtml.test(value) &&
								($.support.htmlSerialize || !rnoshimcache.test(value)) &&
								($.support.leadingWhitespace || !rleadingWhitespace.test(value)) &&
								!wrapMap[(rtagName.exec(value) || ["", ""])[1].toLowerCase()]) {

								value = value.replace(rxhtmlTag, "<$1></$2>");

								try {
									for (; i < l; i++) {
										elem = this[i] || {};
										if (elem.nodeType === 1) {
											$.cleanData(elem.getElementsByTagName("*"));
											elem.innerHTML = value;
										}
									}

									elem = 0;
								} catch (e) { }
							}

							if (elem) {
								element.empty().append(value);
							}
						}, null, value, arguments.length);
					}
					catch (error) {
						return $(element).html(value);
					}
				},

				hasTransform: function (el) {
					var transform = "";
					transform = el.css('transform');

					if (transform == "" || transform == 'none') {
						transform = el.parents().css('transform');
						if (transform == "" || transform == 'none') {
							var browserInfo = $.jqx.utilities.getBrowser();
							if (browserInfo.browser == 'msie') {
								transform = el.css('-ms-transform');
								if (transform == "" || transform == 'none') {
									transform = el.parents().css('-ms-transform');
								}
							}
							else if (browserInfo.browser == 'chrome') {
								transform = el.css('-webkit-transform');
								if (transform == "" || transform == 'none') {
									transform = el.parents().css('-webkit-transform');
								}
							}
							else if (browserInfo.browser == 'opera') {
								transform = el.css('-o-transform');
								if (transform == "" || transform == 'none') {
									transform = el.parents().css('-o-transform');
								}
							}
							else if (browserInfo.browser == 'mozilla') {
								transform = el.css('-moz-transform');
								if (transform == "" || transform == 'none') {
									transform = el.parents().css('-moz-transform');
								}
							}
						} else {
							return transform != "" && transform != 'none';
						}
					}
					if (transform == "" || transform == 'none') {
						transform = $(document.body).css('transform');
					}
					return transform != "" && transform != 'none' && transform != null;
				},

				getBrowser: function () {
					var ua = navigator.userAgent.toLowerCase();

					var match = /(chrome)[ \/]([\w.]+)/.exec(ua) ||
						/(webkit)[ \/]([\w.]+)/.exec(ua) ||
						/(opera)(?:.*version|)[ \/]([\w.]+)/.exec(ua) ||
						/(msie) ([\w.]+)/.exec(ua) ||
						ua.indexOf("compatible") < 0 && /(mozilla)(?:.*? rv:([\w.]+)|)/.exec(ua) ||
						[];

					var obj = {
						browser: match[1] || "",
						version: match[2] || "0"
					};
					if (ua.indexOf("rv:11.0") >= 0 && ua.indexOf(".net4.0c") >= 0) {
						obj.browser = "msie";
						obj.version = "11";
						match[1] = "msie";
					}
					if (ua.indexOf("edge") >= 0) {
						obj.browser = "msie";
						obj.version = "12";
						match[1] = "msie";
					}
					obj[match[1]] = match[1];
					return obj;
				}
			});
		$.jqx.browser = $.jqx.utilities.getBrowser();
		$.jqx.isHidden = function (element) {
			if (!element || !element[0])
				return false;

			var w = element[0].offsetWidth, h = element[0].offsetHeight;
			if (w === 0 || h === 0)
				return true;
			else {
				return false;
			}
		};

		$.jqx.ariaEnabled = true;
		$.jqx.aria = function (that, property, value) {
			if (!$.jqx.ariaEnabled)
				return;

			if (property == undefined) {
				$.each(that.aria, function (index, value) {
					var attrValue = !that.base ? that.host.attr(index) : that.base.host.attr(index);
					if (attrValue != undefined && !$.isFunction(attrValue)) {
						var newValue = attrValue;
						switch (value.type) {
							case "number":
								newValue = new Number(attrValue);
								if (isNaN(newValue)) newValue = attrValue;
								break;
							case "boolean":
								newValue = attrValue == "true" ? true : false;
								break;
							case "date":
								newValue = new Date(attrValue);
								if (newValue == "Invalid Date" || isNaN(newValue)) newValue = attrValue;
								break;
						}

						that[value.name] = newValue;
					}
					else {
						var attrValue = that[value.name];
						if ($.isFunction(attrValue)) attrValue = that[value.name]();
						if (attrValue == undefined) attrValue = "";
						try {
							!that.base ? that.host.attr(index, attrValue.toString()) : that.base.host.attr(index, attrValue.toString());
						}
						catch (error) {
						}
					}
				});
			}
			else {
				try {
					if (that.host) {
						if (!that.base) {
							if (that.host) {
								if (that.element.setAttribute) {
									that.element.setAttribute(property, value.toString());
								}
								else {
									that.host.attr(property, value.toString());
								}
							}
							else {
								that.attr(property, value.toString());
							}
						}
						else {
							if (that.base.host) {
								that.base.host.attr(property, value.toString());
							}
							else {
								that.attr(property, value.toString());
							}
						}
					}
					else if (that.setAttribute) {
						that.setAttribute(property, value.toString());
					}
				}
				catch (error) {
				}
			}
		};

		if (!Array.prototype.indexOf) {
			Array.prototype.indexOf = function (elt /*, from*/) {
				var len = this.length;

				var from = Number(arguments[1]) || 0;
				from = (from < 0)
					? Math.ceil(from)
					: Math.floor(from);
				if (from < 0)
					from += len;

				for (; from < len; from++) {
					if (from in this &&
						this[from] === elt)
						return from;
				}
				return -1;
			};
		}

		$.jqx.mobile = $.jqx.mobile || {};
		$.jqx.position = function (event) {
			var left = parseInt(event.pageX);
			var top = parseInt(event.pageY);

			if ($.jqx.mobile.isTouchDevice()) {
				var touches = $.jqx.mobile.getTouches(event);
				var touch = touches[0];
				left = parseInt(touch.pageX);
				top = parseInt(touch.pageY);
			}
			return { left: left, top: top }
		}

		$.extend($.jqx.mobile,
			{
				_touchListener: function (e, me) {
					var createTouchEvent = function (name, e) {
						var event = document.createEvent('MouseEvents');

						event.initMouseEvent(
							name,
							e.bubbles,
							e.cancelable,
							e.view,
							e.detail,
							e.screenX,
							e.screenY,
							e.clientX,
							e.clientY,
							e.ctrlKey,
							e.altKey,
							e.shiftKey,
							e.metaKey,
							e.button,
							e.relatedTarget
						);
						event._pageX = e.pageX;
						event._pageY = e.pageY;

						return event;
					}

					var eventMap = { 'mousedown': 'touchstart', 'mouseup': 'touchend', 'mousemove': 'touchmove' };
					var event = createTouchEvent(eventMap[e.type], e);
					e.target.dispatchEvent(event);

					var fn = e.target['on' + eventMap[e.type]];
					if (typeof fn === 'function') fn(e);
				},

				setMobileSimulator: function (element, value) {
					if (this.isTouchDevice()) {
						return;
					}

					this.simulatetouches = true;
					if (value == false) {
						this.simulatetouches = false;
					}

					var eventMap = { 'mousedown': 'touchstart', 'mouseup': 'touchend', 'mousemove': 'touchmove' };

					var self = this;
					if (window.addEventListener) {
						var subscribeToEvents = function () {
							for (var key in eventMap) {
								if (element.addEventListener) {
									element.removeEventListener(key, self._touchListener);
									element.addEventListener(key, self._touchListener, false);
								}

								//  document.removeEventListener(key, self._touchListener);
								//  document.addEventListener(key, self._touchListener, false);
							}
						}

						if ($.jqx.browser.msie) {
							subscribeToEvents();
						}
						else {
							subscribeToEvents();
						}
					}
				},

				isTouchDevice: function () {
					if (this.touchDevice != undefined)
						return this.touchDevice;

					var txt = "Browser CodeName: " + navigator.appCodeName + "";
					txt += "Browser Name: " + navigator.appName + "";
					txt += "Browser Version: " + navigator.appVersion + "";
					txt += "Platform: " + navigator.platform + "";
					txt += "User-agent header: " + navigator.userAgent + "";

					if (navigator.maxTouchPoints > 1) {
						//return true;
					}

					if (txt.indexOf('Android') != -1)
						return true;

					if (txt.indexOf('IEMobile') != -1)
						return true;

					if (txt.indexOf('Windows Phone') != -1)
						return true;

					if (txt.indexOf('WPDesktop') != -1)
						return true;

					if (txt.indexOf('ZuneWP7') != -1)
						return true;

					if (txt.indexOf('BlackBerry') != -1 && txt.indexOf('Mobile Safari') != -1)
						return true;

					if (txt.indexOf('ipod') != -1)
						return true;

					if (txt.indexOf('nokia') != -1 || txt.indexOf('Nokia') != -1)
						return true;

					if (txt.indexOf('Chrome/17') != -1)
						return false;

					if (txt.indexOf('CrOS') != -1)
						return false;

					if (txt.indexOf('Opera') != -1 && txt.indexOf('Mobi') == -1 && txt.indexOf('Mini') == -1 && txt.indexOf('Platform: Win') != -1) {
						return false;
					}

					if (txt.indexOf("HybridDeviceTouch") != -1) {
						return true
					}

					if (txt.indexOf("HybridDeviceMouse") != -1) {
						return false
					}

					if (txt.indexOf('Opera') != -1 && txt.indexOf('Mobi') != -1 && txt.indexOf('Opera Mobi') != -1) {
						return true;
					}

					if (txt.indexOf('Mozilla/5.0 (X11; Linux x86_64)') != -1) {
						return false;
					}

					var deviceTypes = {
						ios: 'i(?:Pad|Phone|Pod)(?:.*)CPU(?: iPhone)? OS ',
						android: '(Android |HTC_|Silk/)',
						blackberry: 'BlackBerry(?:.*)Version\/',
						rimTablet: 'RIM Tablet OS ',
						webos: '(?:webOS|hpwOS)\/',
						bada: 'Bada\/'
					}

					// check for IPad, IPhone, IE and Chrome
					try {
						if (this.touchDevice != undefined)
							return this.touchDevice;

						this.touchDevice = false;
						for (var i in deviceTypes) {
							if (deviceTypes.hasOwnProperty(i)) {
								var prefix = deviceTypes[i];
								var match = txt.match(new RegExp('(?:' + prefix + ')([^\\s;]+)'));
								if (match) {
									if (i.toString() == "blackberry") {
										// handle touches through mouse pointer.
										this.touchDevice = false;
										return false;
									}

									this.touchDevice = true;
									return true;
								}
							}
						}

						var userAgent = navigator.userAgent;
						if (navigator.platform.toLowerCase().indexOf('win') != -1) {
							if (userAgent.indexOf('Windows Phone') >= 0 || userAgent.indexOf('WPDesktop') >= 0 || userAgent.indexOf('IEMobile') >= 0 || userAgent.indexOf('ZuneWP7') >= 0) {
								this.touchDevice = true;
								return true;
							}
							else {
								if (userAgent.indexOf('Touch') >= 0) {
									var supported = ('MSPointerDown' in window) || ('pointerdown' in window);
									if (supported) {
										this.touchDevice = true;
										return true;
									}
									if (userAgent.indexOf('ARM') >= 0) {
										this.touchDevice = true;
										return true;
									}

									this.touchDevice = false;
									return false;
								}
							}
						}

						if (navigator.platform.toLowerCase().indexOf('win') != -1) {
							this.touchDevice = false;
							return false;
						}
						if (('ontouchstart' in window) || window.DocumentTouch && document instanceof DocumentTouch) {
							this.touchDevice = true;
						}
						return this.touchDevice;
					} catch (e) {
						this.touchDevice = false;
						return false;
					}
				},

				getLeftPos: function (inputObj) {
					var returnValue = inputObj.offsetLeft;
					while ((inputObj = inputObj.offsetParent) != null) {
						if (inputObj.tagName != 'HTML') {
							returnValue += inputObj.offsetLeft;
							if (document.all) returnValue += inputObj.clientLeft;
						}
					}
					return returnValue;
				},

				getTopPos: function (inputObj) {
					var returnValue = inputObj.offsetTop;
					var initialOffset = $(inputObj).coord();
					while ((inputObj = inputObj.offsetParent) != null) {
						if (inputObj.tagName != 'HTML') {
							returnValue += (inputObj.offsetTop - inputObj.scrollTop);
							if (document.all) returnValue += inputObj.clientTop;
						}
					}
					var agent = navigator.userAgent.toLowerCase();
					var wp8 = (agent.indexOf('windows phone') != -1 || agent.indexOf('WPDesktop') != -1 || agent.indexOf('ZuneWP7') != -1 || agent.indexOf('msie 9') != -1 || agent.indexOf('msie 11') != -1 || agent.indexOf('msie 10') != -1) && agent.indexOf('touch') != -1;
					if (wp8) {
						return initialOffset.top;
					}

					if (this.isSafariMobileBrowser()) {
						if (this.isSafari4MobileBrowser() && this.isIPadSafariMobileBrowser()) {
							return returnValue;
						}
						if (agent.indexOf('version/7') != -1) {
							return initialOffset.top;
						}
						if (agent.indexOf('version/6') != -1 || agent.indexOf('version/5') != -1) {
							returnValue = returnValue + $(window).scrollTop();
						}
						if (/(Android.*Chrome\/[.0-9]* (!?Mobile))/.exec(navigator.userAgent)) {
							 return returnValue;
					//       return returnValue + $(window).scrollTop();
						}
						if (/(Android.*Chrome\/[.0-9]* Mobile)/.exec(navigator.userAgent)) {
							return returnValue;
					//        return returnValue + $(window).scrollTop();
						}

						return initialOffset.top;
					}

					return returnValue;
				},

				isChromeMobileBrowser: function () {
					var agent = navigator.userAgent.toLowerCase();
					var result = agent.indexOf('android') != -1;
					return result;
				},

				isOperaMiniMobileBrowser: function () {
					var agent = navigator.userAgent.toLowerCase();
					var result = agent.indexOf('opera mini') != -1 || agent.indexOf('opera mobi') != -1;
					return result;
				},

				isOperaMiniBrowser: function () {
					var agent = navigator.userAgent.toLowerCase();
					var result = agent.indexOf('opera mini') != -1;
					return result;
				},

				isNewSafariMobileBrowser: function () {
					var agent = navigator.userAgent.toLowerCase();
					var result = agent.indexOf('ipad') != -1 || agent.indexOf('iphone') != -1 || agent.indexOf('ipod') != -1;
					result = result && (agent.indexOf('version/5') != -1);
					return result;
				},

				isSafari4MobileBrowser: function () {
					var agent = navigator.userAgent.toLowerCase();
					var result = agent.indexOf('ipad') != -1 || agent.indexOf('iphone') != -1 || agent.indexOf('ipod') != -1;
					result = result && (agent.indexOf('version/4') != -1);
					return result;
				},

				isWindowsPhone: function () {
					var agent = navigator.userAgent.toLowerCase();
					var result = (agent.indexOf('windows phone') != -1 || agent.indexOf('WPDesktop') != -1 || agent.indexOf('ZuneWP7') != -1 || agent.indexOf('msie 9') != -1 || agent.indexOf('msie 11') != -1 || agent.indexOf('msie 10') != -1 && agent.indexOf('touch') != -1);
					return result;
				},

				isSafariMobileBrowser: function () {
					var agent = navigator.userAgent.toLowerCase();
					if (/(Android.*Chrome\/[.0-9]* (!?Mobile))/.exec(navigator.userAgent)) {
						return true;
					}
					if (/(Android.*Chrome\/[.0-9]* Mobile)/.exec(navigator.userAgent)) {
						return true;
					}

					var result = agent.indexOf('ipad') != -1 || agent.indexOf('iphone') != -1 || agent.indexOf('ipod') != -1 || agent.indexOf('mobile safari') != -1;
					return result;
				},

				isIPadSafariMobileBrowser: function () {
					var agent = navigator.userAgent.toLowerCase();
					var result = agent.indexOf('ipad') != -1;
					return result;
				},

				isMobileBrowser: function () {
					var agent = navigator.userAgent.toLowerCase();
					var result = agent.indexOf('ipad') != -1 || agent.indexOf('iphone') != -1 || agent.indexOf('android') != -1;
					return result;
				},

				// Get the touch points from this event
				getTouches: function (e) {
					if (e.originalEvent) {
						if (e.originalEvent.touches && e.originalEvent.touches.length) {
							return e.originalEvent.touches;
						} else if (e.originalEvent.changedTouches && e.originalEvent.changedTouches.length) {
							return e.originalEvent.changedTouches;
						}
					}

					if (!e.touches) {
						e.touches = new Array();
						e.touches[0] = e.originalEvent != undefined ? e.originalEvent : e;

						if (e.originalEvent != undefined && e.pageX)
							e.touches[0] = e;
						if (e.type == 'mousemove') e.touches[0] = e;
					}

					return e.touches;
				},

				getTouchEventName: function (name) {
					if (this.isWindowsPhone()) {

						var agent = navigator.userAgent.toLowerCase();
						if (agent.indexOf('windows phone 7') != -1) {
							if (name.toLowerCase().indexOf('start') != -1) return 'MSPointerDown';
							if (name.toLowerCase().indexOf('move') != -1) return 'MSPointerMove';
							if (name.toLowerCase().indexOf('end') != -1) return 'MSPointerUp';
						}
						if (name.toLowerCase().indexOf('start') != -1) return 'pointerdown';
						if (name.toLowerCase().indexOf('move') != -1) return 'pointermove';
						if (name.toLowerCase().indexOf('end') != -1) return 'pointerup';
					}
					else {
						return name;
					}
				},

				// Dispatches a fake mouse event from a touch event
				dispatchMouseEvent: function (name, touch, target) {
					if (this.simulatetouches)
						return;

					var e = document.createEvent('MouseEvent');
					e.initMouseEvent(name, true, true, touch.view, 1, touch.screenX, touch.screenY, touch.clientX, touch.clientY, false, false, false, false, 0, null);
					if (target != null) {
						target.dispatchEvent(e);
					}
				},

				// Find the root node of this target
				getRootNode: function (target) {
					while (target.nodeType !== 1) {
						target = target.parentNode;
					}
					return target;
				},

				setTouchScroll: function (enable, key) {
					if (!this.enableScrolling) this.enableScrolling = [];
					this.enableScrolling[key] = enable;
				},

				touchScroll: function (element, scrollHeight, callback, key, horizontalScroll, verticalScroll) {
					if (element == null)
						return;

					var me = this;
					var scrollY = 0;
					var touchY = 0;
					var movedY = 0;
					var scrollX = 0;
					var touchX = 0;
					var movedX = 0;
					if (!this.scrolling) this.scrolling = [];
					this.scrolling[key] = false;
					var moved = false;
					var $element = $(element);
					var touchTags = ['select', 'input', 'textarea'];
					var touchStart = 0;
					var touchEnd = 0;
					if (!this.enableScrolling) this.enableScrolling = [];
					this.enableScrolling[key] = true;
					var key = key;
					var touchStartName = this.getTouchEventName('touchstart') + ".touchScroll";
					var touchEndName = this.getTouchEventName('touchend') + ".touchScroll";
					var touchMoveName = this.getTouchEventName('touchmove') + ".touchScroll";

					//            horizontalScroll.fadeOut(0);
					//            verticalScroll.fadeOut(0);

					var view, indicator, relative, xframe, xdelta,
						xmax, min, max, offset, reference, pressed, xform,
						jqxAnimations, xjqxAnimations, frame, timestamp, ticker,
						amplitude, target, xtarget, xreference, timeConstant;
					max = scrollHeight;
					var min = 0;
					var offset = 0;
					var xoffset = 0;
					var initialOffset = 0;
					var initialXOffset = 0;
					var xmax = horizontalScroll.jqxScrollBar('max');
					var timeConstant = 325; // ms

					function ypos(e) {
						// touch event
						if (e.targetTouches && (e.targetTouches.length >= 1)) {
							return e.targetTouches[0].clientY;
						}
						else if (e.originalEvent && e.originalEvent.clientY !== undefined) {
							return e.originalEvent.clientY;
						}
						else {
							var touches = me.getTouches(e);
							return touches[0].clientY;
						}

						// mouse event
						//    return e.clientY;
					}

					function xpos(e) {
						// touch event
						if (e.targetTouches && (e.targetTouches.length >= 1)) {
							return e.targetTouches[0].clientX;
						}
						else if (e.originalEvent && e.originalEvent.clientX !== undefined) {
							return e.originalEvent.clientX;
						}
						else {
							var touches = me.getTouches(e);
							return touches[0].clientX;
						}

						// mouse event
						//   return e.clientX;
					}

					var track = function () {
						var now, elapsed, delta, v;

						now = Date.now();
						elapsed = now - timestamp;
						timestamp = now;
						delta = offset - frame;
						var xdelta = xoffset - xframe;
						frame = offset;
						xframe = xoffset;
						pressed = true;
						v = 1000 * delta / (1 + elapsed);
						var xv = 1000 * xdelta / (1 + elapsed);
						jqxAnimations = 0.8 * v + 0.2 * jqxAnimations;
						xjqxAnimations = 0.8 * xv + 0.2 * xjqxAnimations;
					}

					var tapped = false;

					var touchStart = function (event) {
						if (!me.enableScrolling[key])
							return true;

						// Allow certain HTML tags to receive touch events
						if ($.inArray(event.target.tagName.toLowerCase(), touchTags) !== -1) {
							return;
						}
						offset = verticalScroll.jqxScrollBar('value');
						xoffset = horizontalScroll.jqxScrollBar('value');

						var touches = me.getTouches(event);
						var touch = touches[0];
						if (touches.length == 1) {
							me.dispatchMouseEvent('mousedown', touch, me.getRootNode(touch.target));
						}
						xmax = horizontalScroll.jqxScrollBar('max');
						max = verticalScroll.jqxScrollBar('max');
						function tap(e) {
							tapped = false;
							pressed = true;
							reference = ypos(e);
							xreference = xpos(e);
							jqxAnimations = amplitude = xjqxAnimations = 0;
							frame = offset;
							xframe = xoffset;
							timestamp = Date.now();
							clearInterval(ticker);
							ticker = setInterval(track, 100);
							initialOffset = offset;
							initialXOffset = xoffset;

							if (offset > 0 && offset < max && verticalScroll[0].style.visibility != "hidden") {
								//      e.preventDefault();
							}
							//    if (xoffset > 0 && xoffset < xmax && horizontalScroll[0].style.visibility != "hidden") {
							//        e.preventDefault();

							//      e.stopPropagation();
							//   e.stopPropagation();
							// return false;
						}

						tap(event);
						moved = false;
						touchY = touch.pageY;
						touchX = touch.pageX;
						if (me.simulatetouches) {
							if (touch._pageY != undefined) {
								touchY = touch._pageY;
								touchX = touch._pageX;
							}
						}
						me.scrolling[key] = true;
						scrollY = 0;
						scrollX = 0;
						return true;
					}

					if ($element.on) {
						$element.on(touchStartName, touchStart);
					}
					else {
						$element.bind(touchStartName, touchStart);
					}

					var scroll = function (top, event) {
						offset = (top > max) ? max : (top < min) ? min : top;
						callback(null, top, 0, 0, event);

						return (top > max) ? "max" : (top < min) ? "min" : "value";
					}

					var hscroll = function (left, event) {
						xoffset = (left > xmax) ? xmax : (left < min) ? min : left;
						callback(left, null, 0, 0, event);

						return (left > xmax) ? "max" : (left < min) ? "min" : "value";
					}

					function autoScroll() {
						var elapsed, delta;
						if (amplitude) {
							elapsed = Date.now() - timestamp;
							delta = -amplitude * Math.exp(-elapsed / timeConstant);
							if (delta > 0.5 || delta < -0.5) {
								scroll(target + delta);
								requestAnimationFrame(autoScroll);
							} else {
								scroll(target);
								//     verticalScroll.fadeOut('fast');
							}
						}
					}
					function hAutoScroll() {
						var elapsed, delta;
						if (amplitude) {
							elapsed = Date.now() - timestamp;
							delta = -amplitude * Math.exp(-elapsed / timeConstant);
							if (delta > 0.5 || delta < -0.5) {
								hscroll(xtarget + delta);
								requestAnimationFrame(hAutoScroll);
							} else {
								hscroll(xtarget);
								//        horizontalScroll.fadeOut('fast');
							}

						}
					}
					var touchMove = function (event) {
						if (!me.enableScrolling[key])
							return true;

						if (!me.scrolling[key]) {
							return true;
						}

						if (tapped) {
							event.preventDefault();
							event.stopPropagation();
						}

						var touches = me.getTouches(event);
						if (touches.length > 1) {
							return true;
						}

						var pageY = touches[0].pageY;
						var pageX = touches[0].pageX;

						if (me.simulatetouches) {
							if (touches[0]._pageY != undefined) {
								pageY = touches[0]._pageY;
								pageX = touches[0]._pageX;
							}
						}


						var dy = pageY - touchY;
						var dx = pageX - touchX;
						touchEnd = pageY;
						var touchHorizontalEnd = pageX;
						movedY = dy - scrollY;
						movedX = dx - scrollX;
						moved = true;
						scrollY = dy;
						scrollX = dx;

						var hScrollVisible = horizontalScroll != null ? horizontalScroll[0].style.visibility != 'hidden' : true;
						var vScrollVisible = verticalScroll != null ? verticalScroll[0].style.visibility != 'hidden' : true;


						function drag(e) {
							var y, delta, x;
							if (pressed) {
								y = ypos(e);
								x = xpos(e);
								delta = reference - y;
								xdelta = xreference - x;
								var dragged = "value";
								if (delta > 2 || delta < -2) {
									reference = y;
									dragged = scroll(offset + delta, e);
									track();

									if (dragged == "min" && initialOffset === 0) {
										return true;
									}
									if (dragged == "max" && initialOffset === max) {
										return true;
									}

									if (!vScrollVisible) {
										return true;
									}
									e.preventDefault();
									e.stopPropagation();
									tapped = true;

									return false;
								}
								else {
									if (xdelta > 2 || xdelta < -2) {
										xreference = x;
										dragged = hscroll(xoffset + xdelta, e);
										track();

										if (dragged == "min" && initialXOffset === 0) {
											return true;
										}
										if (dragged == "max" && initialXOffset === xmax) {
											return true;
										}

										if (!hScrollVisible) {
											return true;
										}
										tapped = true;
										e.preventDefault();
										e.stopPropagation();
										return false;
									}
								}
								e.preventDefault();
							}
						}

						if (hScrollVisible || vScrollVisible) {
							if ((hScrollVisible) || (vScrollVisible)) {
								drag(event);

								//      callback(-movedX * 1, -movedY * 1, dx, dy, event);
								//event.preventDefault();
								//event.stopPropagation();
								//if (event.preventManipulation) {
								//    event.preventManipulation();
								//}
								//return false;
							}
						}
					}

					if ($element.on) {
						$element.on(touchMoveName, touchMove);
					}
					else $element.bind(touchMoveName, touchMove);



					var touchCancel = function (event) {
						if (!me.enableScrolling[key])
							return true;

						var touch = me.getTouches(event)[0];
						if (!me.scrolling[key]) {
							return true;
						}

						pressed = false;
						clearInterval(ticker);
						if (jqxAnimations > 10 || jqxAnimations < -10) {
							amplitude = 0.8 * jqxAnimations;
							target = Math.round(offset + amplitude);
							timestamp = Date.now();
							requestAnimationFrame(autoScroll);
							//             verticalScroll.fadeIn(100);
						}
						else if (xjqxAnimations > 10 || xjqxAnimations < -10) {
							amplitude = 0.8 * xjqxAnimations;
							xtarget = Math.round(xoffset + amplitude);
							timestamp = Date.now();
							requestAnimationFrame(hAutoScroll);
							//          horizontalScroll.fadeIn(100);
						}
						else {
							//        horizontalScroll.fadeOut(100);
							//        verticalScroll.fadeOut(100);
						}

						me.scrolling[key] = false;
						if (moved) {
							me.dispatchMouseEvent('mouseup', touch, event.target);
						} else {
							var touch = me.getTouches(event)[0],
								t = me.getRootNode(touch.target);

							//        event.preventDefault();
							//         event.stopPropagation();
							// Dispatch fake mouse up and click events if this touch event did not move
							me.dispatchMouseEvent('mouseup', touch, t);
							me.dispatchMouseEvent('click', touch, t);
							return true;
						}
					}

					if (this.simulatetouches) {
						var windowBindFunc = $(window).on != undefined || $(window).bind;
						var windowMouseUp = function (event) {
							try {
								touchCancel(event);
							}
							catch (er) {
							}
							me.scrolling[key] = false;
						};
						$(window).on != undefined ? $(document).on('mouseup.touchScroll', windowMouseUp) : $(document).bind('mouseup.touchScroll', windowMouseUp);

						if (window.frameElement) {
							if (window.top != null) {
								var eventHandle = function (event) {
									try {
										touchCancel(event);
									}
									catch (er) {
									}
									me.scrolling[key] = false;
								};

								if (window.top.document) {
									$(window.top.document).on ? $(window.top.document).on('mouseup', eventHandle) : $(window.top.document).bind('mouseup', eventHandle);
								}
							}
						}

						var docBindFunc = $(document).on != undefined || $(document).bind;
						var touchEndFunc = function (event) {
							if (!me.scrolling[key]) {
								return true;
							}

							me.scrolling[key] = false;
							var touch = me.getTouches(event)[0],
								target = me.getRootNode(touch.target);

							// Dispatch fake mouse up and click events if this touch event did not move
							me.dispatchMouseEvent('mouseup', touch, target);
							me.dispatchMouseEvent('click', touch, target);
						};

						$(document).on != undefined ? $(document).on('touchend', touchEndFunc) : $(document).bind('touchend', touchEndFunc);
					}

					if ($element.on) {
						$element.on('dragstart', function (event) {
							event.preventDefault();
						});
						$element.on('selectstart', function (event) {
							event.preventDefault();
						});
					}
					$element.on ? $element.on(touchEndName + ' touchcancel.touchScroll', touchCancel) : $element.bind(touchEndName + ' touchcancel.touchScroll', touchCancel);
				}

			});

		$.jqx.cookie = $.jqx.cookie || {};
		$.extend($.jqx.cookie,
			{
				cookie: function (key, value, options) {
					// set cookie.
					if (arguments.length > 1 && String(value) !== "[object Object]") {
						options = $.extend({}, options);

						if (value === null || value === undefined) {
							options.expires = -1;
						}

						if (typeof options.expires === 'number') {
							var days = options.expires, t = options.expires = new Date();
							t.setDate(t.getDate() + days);
						}

						value = String(value);

						return (document.cookie = [
							encodeURIComponent(key), '=',
							options.raw ? value : encodeURIComponent(value),
							options.expires ? '; expires=' + options.expires.toUTCString() : '', // use expires attribute, max-age is not supported by IE
							options.path ? '; path=' + options.path : '',
							options.domain ? '; domain=' + options.domain : '',
							options.secure ? '; secure' : ''
						].join(''));
					}
					// get cookie...
					options = value || {};
					var result, decode = options.raw ? function (s) { return s; } : decodeURIComponent;
					return (result = new RegExp('(?:^|; )' + encodeURIComponent(key) + '=([^;]*)').exec(document.cookie)) ? decode(result[1]) : null;
				}
			});

		// stringutilities
		$.jqx.string = $.jqx.string || {};
		$.extend($.jqx.string,
			{
				replace: function (text, stringToFind, stringToReplace) {
					if (stringToFind === stringToReplace) return this;
					var temp = text;
					var index = temp.indexOf(stringToFind);
					while (index != -1) {
						temp = temp.replace(stringToFind, stringToReplace);
						index = temp.indexOf(stringToFind);
					}
					return temp;
				},

				contains: function (fullString, value) {
					if (fullString == null || value == null)
						return false;

					return fullString.indexOf(value) != -1;
				},

				containsIgnoreCase: function (fullString, value) {
					if (fullString == null || value == null)
						return false;

					return fullString.toString().toUpperCase().indexOf(value.toString().toUpperCase()) != -1;
				},

				equals: function (fullString, value) {
					if (fullString == null || value == null)
						return false;

					fullString = this.normalize(fullString);

					if (value.length == fullString.length) {
						return fullString.slice(0, value.length) == value;
					}

					return false;
				},

				equalsIgnoreCase: function (fullString, value) {
					if (fullString == null || value == null)
						return false;

					fullString = this.normalize(fullString);

					if (value.length == fullString.length) {
						return fullString.toUpperCase().slice(0, value.length) == value.toUpperCase();
					}

					return false;
				},

				startsWith: function (fullString, value) {
					if (fullString == null || value == null)
						return false;

					return fullString.slice(0, value.length) == value;
				},

				startsWithIgnoreCase: function (fullString, value) {
					if (fullString == null || value == null)
						return false;

					return fullString.toUpperCase().slice(0, value.length) == value.toUpperCase();
				},

				normalize: function (fullString) {
					if (fullString.charCodeAt(fullString.length - 1) == 65279) {
						fullString = fullString.substring(0, fullString.length - 1);
					}

					return fullString;
				},

				endsWith: function (fullString, value) {
					if (fullString == null || value == null)
						return false;

					fullString = this.normalize(fullString);
					return fullString.slice(-value.length) == value;
				},

				endsWithIgnoreCase: function (fullString, value) {
					if (fullString == null || value == null)
						return false;

					fullString = this.normalize(fullString);

					return fullString.toUpperCase().slice(-value.length) == value.toUpperCase();
				}
			});

		$.extend($.easing, {
			easeOutBack: function (x, t, b, c, d, s) {
				if (s == undefined) s = 1.70158;
				return c * ((t = t / d - 1) * t * ((s + 1) * t + s) + 1) + b;
			},
			easeInQuad: function (x, t, b, c, d) {
				return c * (t /= d) * t + b;
			},
			easeInOutCirc: function (x, t, b, c, d) {
				if ((t /= d / 2) < 1) return -c / 2 * (Math.sqrt(1 - t * t) - 1) + b;
				return c / 2 * (Math.sqrt(1 - (t -= 2) * t) + 1) + b;
			},
			easeInOutSine: function (x, t, b, c, d) {
				return -c / 2 * (Math.cos(Math.PI * t / d) - 1) + b;
			},
			easeInCubic: function (x, t, b, c, d) {
				return c * (t /= d) * t * t + b;
			},
			easeOutCubic: function (x, t, b, c, d) {
				return c * ((t = t / d - 1) * t * t + 1) + b;
			},
			easeInOutCubic: function (x, t, b, c, d) {
				if ((t /= d / 2) < 1) return c / 2 * t * t * t + b;
				return c / 2 * ((t -= 2) * t * t + 2) + b;
			},
			easeInSine: function (x, t, b, c, d) {
				return -c * Math.cos(t / d * (Math.PI / 2)) + c + b;
			},
			easeOutSine: function (x, t, b, c, d) {
				return c * Math.sin(t / d * (Math.PI / 2)) + b;
			},
			easeInOutSine: function (x, t, b, c, d) {
				return -c / 2 * (Math.cos(Math.PI * t / d) - 1) + b;
			}
		});
	})(jqxBaseFramework);

	(function ($) {
		if ($.event && $.event.special) {
			$.extend($.event.special,
				{
					"close": { noBubble: true },
					"open": { noBubble: true },
					"cellclick": { noBubble: true },
					"rowclick": { noBubble: true },
					"tabclick": { noBubble: true },
					"selected": { noBubble: true },
					"expanded": { noBubble: true },
					"collapsed": { noBubble: true },
					"valuechanged": { noBubble: true },
					"expandedItem": { noBubble: true },
					"collapsedItem": { noBubble: true },
					"expandingItem": { noBubble: true },
					"collapsingItem": { noBubble: true }
				});
		}
		if ($.fn.extend) {
			$.fn.extend({
				ischildof: function (filter_string) {
					if (!$(this).parents) {
						var result = filter_string.element.contains(this.element)
						return result;
					}

					var parents = $(this).parents().get();

					for (var j = 0; j < parents.length; j++) {
						if (typeof filter_string != "string") {
							var parent = parents[j];
							if (filter_string !== undefined) {
								if (parent == filter_string[0])
									return true;
							}
						}
						else {
							if (filter_string !== undefined) {
								if ($(parents[j]).is(filter_string)) {
									return true;
								}
							}
						}
					}

					return false;
				}
			});
		}

		$.fn.jqxProxy = function () {
			var widget = $(this).data().jqxWidget;
			var args = Array.prototype.slice.call(arguments, 0);
			var element = widget.element;
			if (!element) element = widget.base.element;
			return $.jqx.jqxWidgetProxy(widget.widgetName, element, args);
		}

		var originalVal = $.originalVal = $.fn.val;
		$.fn.val = function (value) {
			if (typeof value == 'undefined') {
				if ($(this).hasClass('jqx-widget') || $(this).hasClass('jqx-input-group')) {
					var widget = $(this).data().jqxWidget;
					if (widget && widget.val) {
						return widget.val();
					}
				}
				if (this[0] && this[0].tagName.toLowerCase().indexOf('angular') >= 0) {
					var widget = $(this).find('.jqx-widget').data().jqxWidget;
					if (widget && widget.val) {
						return widget.val();
					}

				}
				return originalVal.call(this);
			}
			else {
				if ($(this).hasClass('jqx-widget') || $(this).hasClass('jqx-input-group')) {
					var widget = $(this).data().jqxWidget;
					if (widget && widget.val) {
						if (arguments.length != 2) {
							return widget.val(value);
						}
						else {
							return widget.val(value, arguments[1]);
						}
					}
				}
				if (this[0] && this[0].tagName.toLowerCase().indexOf('angular') >= 0) {
					var widget = $(this).find('.jqx-widget').data().jqxWidget;
					if (widget && widget.val) {
						if (arguments.length != 2) {
							return widget.val(value);
						}
						else {
							return widget.val(value, arguments[1]);
						}
					}

				}

				return originalVal.call(this, value);
			}
		};

		if ($.fn.modal && $.fn.modal.Constructor) {
			$.fn.modal.Constructor.prototype.enforceFocus = function () {
				$(document)
					.off('focusin.bs.modal') // guard against infinite focus loop
					.on('focusin.bs.modal', $.proxy(function (e) {
						if (this.$element[0] !== e.target && !this.$element.has(e.target).length) {
							if ($(e.target).parents().hasClass('jqx-popup'))
								return true;
							this.$element.trigger('focus')
						}
					}, this));
			}
		}

		$.fn.coord = function (options) {
			var docElem, win,
				box = { top: 0, left: 0 },
				elem = this[0],
				doc = elem && elem.ownerDocument;
			if (!doc) {
				return;
			}
			docElem = doc.documentElement;
			if (!$.contains(docElem, elem)) {
				return box;
			}
			if (typeof elem.getBoundingClientRect !== undefined) {
				box = elem.getBoundingClientRect();
			}
			var getWindow = function (elem) {
				return $.isWindow(elem) ?
					elem :
					elem.nodeType === 9 ?
						elem.defaultView || elem.parentWindow :
						false;
			};

			win = getWindow(doc);
			var additionalLeftOffset = 0;
			var additionalTopOffset = 0;
			var agent = navigator.userAgent.toLowerCase();
			var result = agent.indexOf('ipad') != -1 || agent.indexOf('iphone') != -1;
			if (result) {
				// fix for iphone/ipad left offsets.
				additionalLeftOffset = 2;
			}
			if (true == options) {
				if (document.body.style.position != 'static' && document.body.style.position != '') {
					var coords = $(document.body).coord();
					additionalLeftOffset = -coords.left;
					additionalTopOffset = -coords.top;
				}
			}

			return {
				top: additionalTopOffset + box.top + (win.pageYOffset || docElem.scrollTop) - (docElem.clientTop || 0),
				left: additionalLeftOffset + box.left + (win.pageXOffset || docElem.scrollLeft) - (docElem.clientLeft || 0)
			};
		};

		$.jqx.ripplers = [];
		$.jqx.ripple = function (element, hostElement, hostElementType) {
			if (!hostElement) {
				hostElement = element;
			}

			var rippler = $(element);
			var mouseCaptured = false;

			rippler.append("<span class='ink'></span>");
			var ink = rippler.find('.ink');


			var hasRippler = false;

			for (var i = 0; i < $.jqx.ripplers.length; i++) {
				var ripplerItem = $.jqx.ripplers[i];

				if (ripplerItem.element[0] === element[0]) {
					hasRippler = true;
					break;
				}
			}

			if (!hasRippler) {
				$.jqx.ripplers.push({ ink: ink, element: element, hostElement: hostElement, hostElementType: hostElementType });
			}

			if (hostElementType === "checkbox" || hostElementType === "radiobutton") {

				// set .ink diametr
				var d = Math.max(rippler.outerWidth(), rippler.outerHeight());
				ink.css({ height: d, width: d });

				var x = rippler.width() / 2 - ink.width() / 2;
				var y = rippler.height() / 2 - ink.height() / 2;

				// set .ink position and add class .animate
				ink.css({
					top: y + 'px',
					left: x + 'px'
				});
			}

			// Ripple-effect animation
			if ($.jqx.ripplers.length === 1) {
				$(document).on('mouseup', function (e) {
					$.jqx.ripple.mouseCaptured = false;

					for (var i = 0; i < $.jqx.ripplers.length; i++) {
						var rippler = $.jqx.ripplers[i];

						rippler.ink.removeClass('active');
						rippler.element.removeClass('active');

						if (hostElementType !== "checkbox" && hostElementType !== "radiobutton") {
							if (rippler.ink.hasClass('animate')) {
								rippler.ink.removeClass('animate');
							}
						}
					}
				});
			}
			hostElement.off('mousedown.ripple');
			hostElement.on('mousedown.ripple', function (e) {
				var rippler = $(element);

				$.jqx.ripple.mouseCaptured = true;

				setTimeout(function () {
					// create .ink element if it doesn't exist

					if (rippler.find('.ink').length == 0) {
						rippler.append("<span class='ink'></span>");
					}

					var ink = rippler.find('.ink');

					// prevent quick double clicks
					ink.removeClass('animate');


					// set .ink diametr
					if (!ink.height() && !ink.width()) {
						var d = Math.max(rippler.outerWidth(), rippler.outerHeight());
						ink.css({ height: d, width: d });
					}

					if (hostElementType === "checkbox" || hostElementType === "radiobutton") {
						if (hostElementType === "checkbox") {
							if (hostElement.jqxCheckBox('disabled')) {
								return;
							}
						}

						if (hostElementType === "radiobutton") {
							if (hostElement.jqxRadioButton('disabled')) {
								return;
							}
						}

						// get click coordinates
						var x = rippler.width() / 2 - ink.width() / 2;
						var y = rippler.height() / 2 - ink.height() / 2;

						// set .ink position and add class .animate
						ink.css({
							top: y + 'px',
							left: x + 'px'
						}).addClass('animate');

						ink.on('animationend', function () {
							if ($.jqx.ripple.mouseCaptured) {
								ink.removeClass('animate')
								ink.addClass('active')
								element.addClass('active')
							}
						});

						return;
					}

					// get click coordinates
					var x = e.pageX - rippler.offset().left - ink.width() / 2;
					var y = e.pageY - rippler.offset().top - ink.height() / 2;

					// set .ink position and add class .animate
					ink.css({
						top: y + 'px',
						left: x + 'px'
					}).addClass('animate');
				});
			});
		}
	})(jqxBaseFramework);
})();




/***/ }),

/***/ 3907:
/***/ (() => {

﻿/* tslint:disable */
/* eslint-disable */
(function(){
	if (typeof document === 'undefined') { 
		return;
	}

(function ($) {
    var ArrayExporter = (function () {

        var exportModules = {},
            data, dataFields, styles, exporter, stylesArray, hierarchy, exportFormat, filename;

        function exportData(exporter, data, dataFields, styles, hierarchy, exportFormat, filename) {
            var that = this;

            if (!that) {
                that = window.jqx;
            }

            that.hierarchy = hierarchy;
            that.exportFormat = exportFormat;
            that.filename = filename;

            exporter.beginFile(filename);
            exportHeader(exporter);
            exportContent(exporter);
            exporter.endFile(filename);
            return exporter.getFile();
        }

        function exportHeader(exporter) {
            var exportHeaders = true;
            $.each(dataFields, function () {
                if (this.hidden) {
                    exportHeaders = false;
                    return false;
                }
            });

            exporter.beginHeader(exportHeaders);
            var index = 0;
            for (var cellContent in dataFields) {
                if (dataFields[cellContent].columnsDataFields) {
                    cellContent = dataFields[cellContent].columnsDataFields[index].displayfield;
                }
                var style = getHeaderStyle(cellContent, dataFields[cellContent]);
                exporter.appendHeaderCell(dataFields[cellContent], cellContent, style, exportHeaders, index);
                index++;
            }
            exporter.endHeader(exportHeaders);
        }

        function exportContent(exporter) {
            var that = this;

            if (!that) {
                that = window.jqx;
            }

            exporter.beginBody();
            if (that.hierarchy) {
                var exporHierarchy = function (data) {
                    for (var i = 0; i < data.length; i += 1) {
                        if (data[i] !== undefined) {
                            exporter.hierarchy = true;
                            exporter.beginRow(data[i].level);
                            exportRow(exporter, data[i], i, true);
                            if (data[i].records) {
                                exporter.beginRows(data[i].level);
                                exporHierarchy(data[i].records);
                                exporter.endRows(data[i].level);
                            }
                            exporter.endRow(data[i].level);
                        }
                    }
                }
                exporHierarchy(data);
                exporter.endBody();
                return;
            }

            for (var i = 0; i < data.length; i += 1) {
                if (data[i] !== undefined) {
                    exportRow(exporter, data[i], i);
                }
            }
            exporter.endBody();
        }

        function exportRow(exporter, data, rowId, hierarchy) {
            var that = this;

            if (!that) {
                that = window.jqx;
            }

            var style;
            if (hierarchy != true) {
                exporter.beginRow();
            }
            var indx = 0;
            for (var column in dataFields) {
                if (dataFields[column].columnsDataFields) {
                    column = dataFields[column].columnsDataFields[indx].displayfield;
                }

                style = getRowCellStyle(rowId, column);
                if (style) {
                    if (style.level != undefined) {
                        if (style.index - 1 > data.level && style.index - 1 < style.maxLevel) {
                            indx++;
                            continue;
                        }
                    }
                    if (style.maxLevel != undefined) {
                        if (style.index - 1 == style.maxLevel) {
                            style = $.extend({}, style);
                            style.merge = style.maxLevel - data.level - 1;
                        }
                    }
                }
                if (data.level != undefined && data.label != undefined) {
                    if (that.exportFormat === "xml" || that.exportFormat === "json") {
                        var dataGroup = {};
                        dataGroup['text'] = "group";
                        exporter.appendBodyCell(data.label, dataGroup, style, data, indx, "group");
                        break;
                    }
                }

                if (data.hasOwnProperty(column)) {
                    exporter.appendBodyCell(data[column], dataFields[column], style, data, indx);
                }
                else {
                    exporter.appendBodyCell("", dataFields[column], style, data, indx);
                }
                indx++;
            }
            if (hierarchy != true) {
                exporter.endRow();
            }
        }

        function getHeaderStyle(columnName, dataField) {
            if (dataField.style) {
                return styles[dataField.style];
            }

            var rowStyles = getStylesArray();
            if (rowStyles.length > 0) {
                return rowStyles[0].style;
            }
            return null;
        }

        function getStylesArray() {
            if (!stylesArray) {
                stylesArray = new Array();
                $.each(styles, function (index, value) {
                    stylesArray[stylesArray.length] = { name: index, style: value };
                });
            }

            return stylesArray;
        }

        function getRowCellStyle(rowId, column) {
            var dataField = dataFields[column];
            if (dataField) {
                if (dataField.customCellStyles) {
                    var customStyle = dataField.customCellStyles[rowId];
                    if (customStyle) {
                        return styles[customStyle];
                    }
                }

                if (dataField.cellStyle) {
                    if (dataField.cellAltStyle) {
                        var styleId = rowId % 2;
                        if (styleId == 0)
                            return styles[dataField.cellStyle];
                        return styles[dataField.cellAltStyle];
                    }
                    return styles[dataField.cellStyle];
                }
                else {
                    var rowStyles = getStylesArray();
                    if (rowStyles.length > 0) {
                        var styleId = rowId % (rowStyles.length - 1);
                        var style = rowStyles[styleId + 1].style;
                        return style;
                    }
                }
            }
            return null;
        }

        function createHiddenInput(value, name, form) {
            var input = document.createElement('input');
            input.name = name;
            input.value = value;
            input.type = 'hidden';
            form.appendChild(input);
            return input;
        }

        function createHiddenTextArea(value, name, form) {
            var textArea = document.createElement('textarea');
            textArea.name = name;
            textArea.value = value;
            //      textArea.type = 'hidden';
            form.appendChild(textArea);
            return textArea;
        }

        function createForm(filename, format, content, exportServer, charset) {
            var form = document.createElement('form');
            createHiddenInput(filename, 'filename', form);
            createHiddenInput(format, 'format', form);
            createHiddenTextArea(content, 'content', form);
            if (exportServer == undefined || exportServer == '') {
                if (window && window.location.toString().indexOf('jqwidgets.com') >= 0) {
                    exportServer = 'https://jqwidgets.com/export_server/dataexport.php';
                }
                else {
                    exportServer = 'http://jquerygrid.net/export_server/dataexport.php';
                }
            }

            form.action = exportServer;
            form.method = 'post';
            if (charset) {
                form.acceptCharset = charset;
            }

            document.body.appendChild(form);
            return form;
        }

        exporter = function (inputData, inputDataFields, inputStyles, exportServer, hierarchy, exportFormat) {
            if (!(this instanceof ArrayExporter)) {
                return new ArrayExporter(inputData, inputDataFields, inputStyles, hierarchy, exportFormat);
            }
            data = inputData;
            dataFields = inputDataFields;
            styles = inputStyles;

            this.exportTo = function (format, hierarchy, exportFormat, filename) {
                format = format.toString().toLowerCase();
                var module = exportModules[format];
                if (typeof module === 'undefined') {
                    throw 'You can\'t export to ' + format + ' format.';
                }
                if (format === "pdf" && filename == undefined) {
                    var table = this.exportTo(format, hierarchy, format, "pdf");
                    if (!$.jqx.pdfExport) {
                        $.jqx.pdfExport =
                        {
                            orientation: "portrait",
                            paperSize: "a4"
                        }
                    }

                    var doc = new pdfDataExport($.jqx.pdfExport.orientation, 'pt', $.jqx.pdfExport.paperSize);
                    doc.cellInitialize();
                    var headerCells = $(table).find('th');
                    var tableRows = $(table).find('tr');
                    var rows = 0;
                    doc.setFontSize(13 * 72 / 96);
                    var totalWidth = 595;
                    switch ($.jqx.pdfExport.paperSize) {
                        case "legal":
                            var totalWidth = 612;
                            if ($.jqx.pdfExport.orientation !== "portrait") {
                                totalWidth = 1008;
                            }
                            break;
                        case "letter":
                            var totalWidth = 612;
                            if ($.jqx.pdfExport.orientation !== "portrait") {
                                totalWidth = 792;
                            }
                            break;
                        case "a3":
                            var totalWidth = 841;
                            if ($.jqx.pdfExport.orientation !== "portrait") {
                                totalWidth = 1190;
                            }
                            break;
                        case "a4":
                            var totalWidth = 595;
                            if ($.jqx.pdfExport.orientation !== "portrait") {
                                totalWidth = 842;
                            }
                            break;
                        case "a5":
                            var totalWidth = 420;
                            if ($.jqx.pdfExport.orientation !== "portrait") {
                                totalWidth = 595;
                            }
                            break
                    }
                    totalWidth -= 20;
                    var totalColumnsWidth = 0;
                    var columnWidths = [];
                    $.each(headerCells, function (index) {
                        var width = parseInt(this.style.width);
                        if (isNaN(width)) {
                            width = 25;
                        }
                        var widthPoints = width * 72 / 96;
                        columnWidths[index] = widthPoints;
                        totalColumnsWidth += widthPoints;
                    });

                    if (headerCells.length === 0) {
                        $.each(tableRows[0].cells, function (index) {
                            var width = parseInt(this.style.width);
                            if (isNaN(width)) {
                                width = totalWidth / tableRows[0].cells.length;
                            }
                            var widthPoints = width * 72 / 96;
                            columnWidths[index] = widthPoints;
                            totalColumnsWidth += widthPoints;
                        });
                    }

                    if (totalColumnsWidth > totalWidth) {
                        $.each(columnWidths, function (index) {
                            columnWidths[index] = (columnWidths[index] / totalColumnsWidth) * 100;
                            columnWidths[index] = columnWidths[index] * totalWidth / 100;
                        });
                    }

                    $.each(headerCells, function (index) {
                        var widthPoints = columnWidths[index];
                        var heightPoints = 25 * 72 / 96;
                        var textDimension = doc.getTextDimensions($(this).html());
                        var cellText = $(this).html();
                        if (textDimension.w + 3 > widthPoints) {
                            var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                            var newText = splitText[0];
                            if (newText.length > 3) {
                                cellText = newText.substring(0, newText.length - 3) + "...";
                            }
                            else cellText = newText.substring(0, 1) + "...";
                            var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                            var newText = splitText[0];
                            if (newText != cellText) {
                                cellText = newText;
                            }
                        }
                        doc.cell(10, 10, widthPoints, heightPoints, cellText, rows);
                    });

                    rows++;
                    $.each(tableRows, function (index) {
                        if (index === 0) return true;
                        var rowCells = $(this).children();
                        var isTreeGrid = rowCells.length > headerCells.length && headerCells.length > 0;
                        if (isTreeGrid) {
                            var mergeLength = rowCells.length - headerCells.length;
                            var cellText = "";
                            var widthPoints = columnWidths[0];
                            var heightPoints = 25 * 72 / 96;
                            for (var i = 0; i <= mergeLength; i++) {
                                var cellHTML = rowCells[i].innerHTML;
                                if (cellHTML === "+" || cellHTML === "-") cellHTML = cellHTML + " ";
                                if (cellHTML === "&nbsp;") cellHTML = "   ";
                                cellText += cellHTML;
                            }
                            var textDimension = doc.getTextDimensions(cellText);
                            if (textDimension.w + 3 > widthPoints) {
                                var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                                var newText = splitText[0];
                                if (newText.length > 3) {
                                    cellText = newText.substring(0, newText.length - 3) + "...";
                                }
                                else cellText = newText.substring(0, 1) + "...";
                                var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                                var newText = splitText[0];
                                if (newText != cellText) {
                                    cellText = newText;
                                }
                            }

                            doc.cell(10, 10, widthPoints, heightPoints, cellText, rows);
                            for (var i = mergeLength + 1; i < rowCells.length; i++) {
                                var index = i - mergeLength;
                                var widthPoints = columnWidths[index];
                                var heightPoints = 25 * 72 / 96;
                                var cellText = $(rowCells[i]).html();
                                var textDimension = doc.getTextDimensions($(rowCells[i]).html());
                                if (textDimension.w + 3 > widthPoints) {
                                    var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                                    var newText = splitText[0];
                                    if (newText.length > 3) {
                                        cellText = newText.substring(0, newText.length - 3) + "...";
                                    }
                                    else cellText = newText.substring(0, 1) + "...";
                                    var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                                    var newText = splitText[0];
                                    if (newText != cellText) {
                                        cellText = newText;
                                    }
                                }
                                doc.cell(10, 10, widthPoints, heightPoints, cellText, rows);
                            }
                            rows++;
                            return true;
                        }

                        $.each(rowCells, function (index) {
                            var widthPoints = columnWidths[index];
                            var heightPoints = 25 * 72 / 96;
                            var cellText = $(this).html();
                            var textDimension = doc.getTextDimensions($(this).html());
                            if (textDimension.w + 3 > widthPoints) {
                                var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                                var newText = splitText[0];
                                if (newText.length > 3) {
                                    cellText = newText.substring(0, newText.length - 3) + "...";
                                }
                                else cellText = newText.substring(0, 1) + "...";
                                var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                                var newText = splitText[0];
                                if (newText != cellText) {
                                    cellText = newText;
                                }
                            }
                            doc.cell(10, 10, widthPoints, heightPoints, cellText, rows);
                        }
                        );
                        rows++;
                    });
                    if ($.jqx.browser.msie && $.jqx.browser.version < 10) {
                        throw new Error("PDF export requires a browser with HTML5 support");
                        return;
                    }

                    return doc;
                }

                return exportData(module, data, dataFields, styles, hierarchy, exportFormat, filename);
            };

            this.exportToFile = function (format, filename, exportServer, charset, hierarchy) {
                if (format === "pdf") {
                    var table = this.exportTo(format, hierarchy, format, filename);
                    if (!$.jqx.pdfExport) {
                        $.jqx.pdfExport =
                        {
                            orientation: "portrait",
                            paperSize: "a4"
                        }
                    }

                    var doc = new pdfDataExport($.jqx.pdfExport.orientation, 'pt', $.jqx.pdfExport.paperSize);
                    if (charset == "utf-8" || charset == "UTF-8") {
                        doc.setFont("courier", "normal");
                    }

                    doc.cellInitialize();
                    var headerCells = $(table).find('th');
                    var tableRows = $(table).find('tr');
                    var rows = 0;
                    doc.setFontSize(13 * 72 / 96);
                    var totalWidth = 595;
                    switch ($.jqx.pdfExport.paperSize) {
                        case "legal":
                            var totalWidth = 612;
                            if ($.jqx.pdfExport.orientation !== "portrait") {
                                totalWidth = 1008;
                            }
                            break;
                        case "letter":
                            var totalWidth = 612;
                            if ($.jqx.pdfExport.orientation !== "portrait") {
                                totalWidth = 792;
                            }
                            break;
                        case "a3":
                            var totalWidth = 841;
                            if ($.jqx.pdfExport.orientation !== "portrait") {
                                totalWidth = 1190;
                            }
                            break;
                        case "a4":
                            var totalWidth = 595;
                            if ($.jqx.pdfExport.orientation !== "portrait") {
                                totalWidth = 842;
                            }
                            break;
                        case "a5":
                            var totalWidth = 420;
                            if ($.jqx.pdfExport.orientation !== "portrait") {
                                totalWidth = 595;
                            }
                            break
                    }
                    totalWidth -= 20;
                    var totalColumnsWidth = 0;
                    var columnWidths = [];
                    $.each(headerCells, function (index) {
                        var width = parseInt(this.style.width);
                        if (isNaN(width)) {
                            width = 25;
                        }
                        var widthPoints = width * 72 / 96;
                        columnWidths[index] = widthPoints;
                        totalColumnsWidth += widthPoints;
                    });

                    if (headerCells.length === 0) {
                        $.each(tableRows[0].cells, function (index) {
                            var width = parseInt(this.style.width);
                            if (isNaN(width)) {
                                width = totalWidth / tableRows[0].cells.length;
                            }
                            var widthPoints = width * 72 / 96;
                            columnWidths[index] = widthPoints;
                            totalColumnsWidth += widthPoints;
                        });
                    }

                    if (totalColumnsWidth > totalWidth) {
                        $.each(columnWidths, function (index) {
                            columnWidths[index] = (columnWidths[index] / totalColumnsWidth) * 100;
                            columnWidths[index] = columnWidths[index] * totalWidth / 100;
                        });
                    }

                    $.each(headerCells, function (index) {
                        var widthPoints = columnWidths[index];
                        var heightPoints = 25 * 72 / 96;
                        var textDimension = doc.getTextDimensions($(this).html());
                        var cellText = $(this).html();
                        if (textDimension.w + 3 > widthPoints) {
                            var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                            var newText = splitText[0];
                            if (newText.length > 3) {
                                cellText = newText.substring(0, newText.length - 3) + "...";
                            }
                            else cellText = newText.substring(0, 1) + "...";
                            var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                            var newText = splitText[0];
                            if (newText != cellText) {
                                cellText = newText;
                            }
                        }
                        doc.cell(10, 10, widthPoints, heightPoints, cellText, rows);
                    });

                    rows++;
                    $.each(tableRows, function (index) {
                        if (index === 0) return true;
                        var rowCells = $(this).children();
                        var isTreeGrid = rowCells.length > headerCells.length && headerCells.length > 0;
                        if (isTreeGrid) {
                            var mergeLength = rowCells.length - headerCells.length;
                            var cellText = "";
                            var widthPoints = columnWidths[0];
                            var heightPoints = 25 * 72 / 96;
                            for (var i = 0; i <= mergeLength; i++) {
                                var cellHTML = rowCells[i].innerHTML;
                                if (cellHTML === "+" || cellHTML === "-") cellHTML = cellHTML + " ";
                                if (cellHTML === "&nbsp;") cellHTML = "   ";
                                cellText += cellHTML;
                            }
                            var textDimension = doc.getTextDimensions(cellText);
                            if (textDimension.w + 3 > widthPoints) {
                                var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                                var newText = splitText[0];
                                if (newText.length > 3) {
                                    cellText = newText.substring(0, newText.length - 3) + "...";
                                }
                                else cellText = newText.substring(0, 1) + "...";
                                var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                                var newText = splitText[0];
                                if (newText != cellText) {
                                    cellText = newText;
                                }
                            }

                            doc.cell(10, 10, widthPoints, heightPoints, cellText, rows);
                            for (var i = mergeLength + 1; i < rowCells.length; i++) {
                                var index = i - mergeLength;
                                var widthPoints = columnWidths[index];
                                var heightPoints = 25 * 72 / 96;
                                var cellText = $(rowCells[i]).html();
                                if (cellText === "&nbsp;") cellText = "   ";

                                var textDimension = doc.getTextDimensions($(rowCells[i]).html());
                                if (textDimension.w + 3 > widthPoints) {
                                    var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                                    var newText = splitText[0];
                                    if (newText.length > 3) {
                                        cellText = newText.substring(0, newText.length - 3) + "...";
                                    }
                                    else cellText = newText.substring(0, 1) + "...";
                                    var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                                    var newText = splitText[0];
                                    if (newText != cellText) {
                                        cellText = newText;
                                    }
                                }
                                doc.cell(10, 10, widthPoints, heightPoints, cellText, rows);
                            }
                            rows++;
                            return true;
                        }

                        $.each(rowCells, function (index) {
                            var widthPoints = columnWidths[index];
                            var heightPoints = 25 * 72 / 96;
                            var cellText = $(this).html();
                            if (cellText === "&nbsp;") cellText = "   ";

                            var textDimension = doc.getTextDimensions($(this).html());
                            if (textDimension.w + 3 > widthPoints) {
                                var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                                var newText = splitText[0];
                                if (newText.length > 3) {
                                    cellText = newText.substring(0, newText.length - 3) + "...";
                                }
                                else cellText = newText.substring(0, 1) + "...";
                                var splitText = doc.splitTextToSize(cellText, widthPoints - 3);
                                var newText = splitText[0];
                                if (newText != cellText) {
                                    cellText = newText;
                                }
                            }
                            doc.cell(10, 10, widthPoints, heightPoints, cellText, rows);
                        }
                        );
                        rows++;
                    });
                    if ($.jqx.browser.msie && $.jqx.browser.version < 10) {
                        throw new Error("PDF export requires a browser with HTML5 support");
                        return;
                    }

                    doc.save(filename + ".pdf");
                    return;
                }

                var content = this.exportTo(format, hierarchy, format, filename),
                    form = createForm(filename, format, content, exportServer, charset);
                form.submit();
                document.body.removeChild(form);
            };

            this.exportToLocalFile = function (format, filename, hierarchy, exportFormat) {
                var content = this.exportTo(format, hierarchy, exportFormat);
                document.location.href = 'data:application/octet-stream;filename=' + filename + ',' + encodeURIComponent(content);
            };

        };

        exporter.extend = function (exportFormat, exporter) {
            if (exporter instanceof $.jqx.dataAdapter.DataExportModuleBase) {
                exportModules[exportFormat] = exporter;
            } else {
                throw 'The module ' + exportFormat + ' is not instance of DataExportModuleBase.';
            }
        };

        return exporter;

    }());

    $.jqx.dataAdapter.ArrayExporter = ArrayExporter;

})(jqxBaseFramework);


(function ($) {

    //Defines common interface for all modules used for exportation
    var DataExportModuleBase = function () {

        this.formatData = function (data, type, formatString, localization) {
            if (type === 'date') {
                var tmpdate = "";
                if (typeof data === 'string') {
                    tmpdate = $.jqx.dataFormat.tryparsedate(data);
                    data = tmpdate;
                }
                if (data === "" || data === null) return "";
                tmpdate = $.jqx.dataFormat.formatdate(data, formatString, localization);
                if ((tmpdate && tmpdate.toString() == "NaN") || tmpdate == null) return "";
                data = tmpdate;
            } else if (type === 'number' || type === 'float' || type === 'int' || type == 'integer') {
                if (data === "" || data === null) return "";

                if (!isNaN(new Number(data))) {
                    var tmpdata = $.jqx.dataFormat.formatnumber(data, formatString, localization);
                    if (tmpdata.toString() == "NaN") return "";
                    else data = tmpdata;
                }
            } else {
                data = data;
            }
            if (data === null) return "";
            return data;
        };

        this.getFormat = function (dataOptions) {
            var formatString = dataOptions ? dataOptions['formatString'] : "";
            var localization = dataOptions ? dataOptions['localization'] : "";
            var dataType = 'string';
            dataType = dataOptions ? dataOptions['type'] : 'string';

            if (dataType == 'number' || dataType == 'float') {
                if (!formatString) formatString = 'f2';
            }
            if (dataType == 'int' || dataType == 'integer') {
                if (!formatString) formatString = 'n0';
            }
            if (dataType == 'date') {
                if (!formatString) formatString = 'd';
            }
            return { type: dataType, formatString: formatString, localization: localization };
        };

        this.beginFile = function () {
            throw 'Not implemented!';
        };

        this.beginHeader = function () {
            throw 'Not implemented!';
        };

        this.appendHeaderCell = function () {
            throw 'Not implemented!';
        };

        this.endHeader = function () {
            throw 'Not implemented!';
        };

        this.beginBody = function () {
            throw 'Not implemented!';
        };

        this.beginRow = function () {
            throw 'Not implemented!';
        };

        this.beginRows = function () {
            throw 'Not implemented!';
        };

        this.endRows = function () {
            throw 'Not implemented!';
        };

        this.appendBodyCell = function () {
            throw 'Not implemented!';
        };

        this.endRow = function () {
            throw 'Not implemented!';
        };

        this.endBody = function () {
            throw 'Not implemented!';
        };

        this.endFile = function () {
            throw 'Not implemented!';
        };

        this.getFile = function () {
            throw 'Not implemented!';
        };
    }

    $.jqx.dataAdapter.DataExportModuleBase = DataExportModuleBase;

})(jqxBaseFramework);

//Extending the exporter with TSV and CSV exporters
(function ($) {

    //Value exporter. This object is common prototype for TSV and CVS.
    var SvExporter = function (inValueSeparator) {

        var file, valueSeparator, hasHeader;
        var rowIndex = 0;
        var me = this;

        this.beginFile = function () {
            file = '';
        };

        this.beginHeader = function () {
        };

        this.appendHeaderCell = function (data, fieldName, style, exportHeader, index) {
            if (style) {
                if (style.level != undefined) {
                    if (index < style.maxLevel) {
                        return;
                    }
                    else if (index === style.maxLevel) {
                        if (exportHeader) {
                            appendCell(data.text);
                        }
                        for (var i = 0; i < style.maxLevel; i++) {
                            appendCell("");
                        }
                        return;
                    }
                }
            }

            hasHeader = exportHeader;
            if (exportHeader) {
                appendCell(data.text);
            }
        };

        this.endHeader = function () {
            this.endRow();
        };

        this.beginBody = function () {
            rowIndex = 0;
        };

        this.beginRow = function () {
            if ((rowIndex > 0) || (rowIndex == 0 && hasHeader)) {
                file += '\n';
            }
            rowIndex++;
        };

        this.appendBodyCell = function (data, dataType, style, row, index) {
            if (style) {
                if (style.maxLevel != undefined) {
                    if (index === style.maxLevel) {
                        appendCell(data, dataType);
                        for (var i = 0; i < style.maxLevel - row.level - 1; i++) {
                            appendCell("", dataType);
                        }
                        return;
                    }
                }
            }
            appendCell(data, dataType);
        };

        this.endRow = function () {
            file = file.substring(0, file.length - 1);
        };

        this.endBody = function () {
        };

        this.endFile = function () {
        };

        this.getFile = function () {
            return file;
        };

        function prepareData(data, dataOptions) {
            if (dataOptions) {
                var format = me.getFormat(dataOptions);
                data = me.formatData(data, format.type, format.formatString, format.localization);
            }
            data = '"' + data + '"';
            return data;
        };

        function appendCell(data, dataOptions) {
            data = prepareData(data, dataOptions);
            file += data + inValueSeparator;
        };

    };

    SvExporter.prototype = new $.jqx.dataAdapter.DataExportModuleBase();

    var CsvExporter = function () { };
    CsvExporter.prototype = new SvExporter(',');

    var TsvExporter = function () { };
    TsvExporter.prototype = new SvExporter('\t');

    $.jqx.dataAdapter.ArrayExporter.extend('csv', new CsvExporter());
    $.jqx.dataAdapter.ArrayExporter.extend('tsv', new TsvExporter());

})(jqxBaseFramework);

//Extending the exporter with HTML exporter
(function ($) {

    var HtmlExporter = function () {
        var isPDF = false;
        var file;
        var hasHeader;
        var rowIndex = 0;

        this.setPDF = function () {
            isPDF = true;
        };

        this.beginFile = function (filename) {
            if (isPDF || filename == undefined) {
                file = '<table style="empty-cells: show;" cellspacing="0" cellpadding="2">';
            }
            else {
                file = '<html>\n\t<head>\n\t\t<title></title>\n' +
					   '\t\t<meta http-equiv=Content-type content=\"text/html; charset=UTF-8\">\n\t</head>\n\t<body>\n' +
					   '\t\t<table style="empty-cells: show;" cellspacing="0" cellpadding="2">';
            }
        };

        this.beginHeader = function () {
            if (isPDF) {
                file += '\n\t<thead><tr>';
            }
            else {
                file += '\n\t\t\t<thead>';
            }
        };

        this.appendHeaderCell = function (data, fieldName, style, exportHeader) {
            hasHeader = exportHeader;
            if (!exportHeader) return;

            if (isPDF) {
                file += '\n\t\t\t\t<th style="' + buildStyle(style) + '">' + data.text + '</th>';
            }
            else {
                if (style.disabled) return;

                if (style.merge) {
                    if (data.width) {
                        file += '\n\t\t\t\t<th colspan=' + (1 + style.merge) + ' style="width: ' + data.width + 'px; ' + buildStyle(style) + '">' + data.text + '</th>';
                    }
                    else {
                        file += '\n\t\t\t\t<th colspan=' + (1 + style.merge) + ' style="' + buildStyle(style) + '">' + data.text + '</th>';
                    }
                }
                else {
                    if (data.width) {
                        file += '\n\t\t\t\t<th style="width: ' + data.width + 'px; ' + buildStyle(style) + '">' + data.text + '</th>';
                    }
                    else {
                        file += '\n\t\t\t\t<th style="' + buildStyle(style) + '">' + data.text + '</th>';
                    }
                }
            }
        };

        this.endHeader = function () {
            if (isPDF) {
                file += '\n\t</tr></thead>';
            }
            else {
                file += '\n\t\t\t</thead>';
            }
        };

        this.beginBody = function () {
            if (isPDF) {
                file += '\n\t<tbody>';
            }
            else {
                file += '\n\t\t\t<tbody>';
            }
            rowIndex = 0;
        };

        this.beginRow = function () {
            if (isPDF) {
                file += '\n\t<tr>';
            }
            else {
                file += '\n\t\t\t\t<tr>';
            }
            rowIndex++;
        };

        this.appendBodyCell = function (data, dataOptions, style) {
            var format = this.getFormat(dataOptions);
            if (data === "") data = "&nbsp;";
            if (isPDF) {
                if (rowIndex == 1 && !hasHeader) {
                    file += '\n\t\t\t\t\t<td style="' + buildStyle(style) + ' border-top-width: 1px;">' + this.formatData(data, format.type, format.formatString, format.localization) + '</td>';
                }
                else {
                    file += '\n\t\t\t\t\t<td style="' + buildStyle(style) + '">' + this.formatData(data, format.type, format.formatString, format.localization) + '</td>';
                }
            }
            else {
                if (style.merge) {
                    if (rowIndex == 1 && !hasHeader) {
                        file += '\n\t\t\t\t\t<td colspan=' + (1 + style.merge) + ' style="' + buildStyle(style) + ' border-top-width: 1px;">' + this.formatData(data, format.type, format.formatString, format.localization) + '</td>';
                    }
                    else {
                        file += '\n\t\t\t\t\t<td colspan=' + (1 + style.merge) + ' style="' + buildStyle(style) + '">' + this.formatData(data, format.type, format.formatString, format.localization) + '</td>';
                    }
                }
                else {
                    if (rowIndex == 1 && !hasHeader) {
                        file += '\n\t\t\t\t\t<td style="' + buildStyle(style) + ' border-top-width: 1px;">' + this.formatData(data, format.type, format.formatString, format.localization) + '</td>';
                    }
                    else {
                        file += '\n\t\t\t\t\t<td style="' + buildStyle(style) + '">' + this.formatData(data, format.type, format.formatString, format.localization) + '</td>';
                    }
                }
            }
        };

        this.endRow = function () {
            if (isPDF) {
                file += '\n\t</tr>';
            }
            else {
                file += '\n\t\t\t\t</tr>';
            }
        };

        this.endBody = function () {
            if (isPDF) {
                file += '\n\t</tbody>';
            }
            else {
                file += '\n\t\t\t</tbody>';
            }
        };

        this.endFile = function (filename) {
            if (isPDF || filename == undefined) {
                file += '\n</table>';
            }
            else {
                file += '\n\t\t</table>\n\t</body>\n</html>\n';
            }
        };

        this.getFile = function () {
            return file;
        };

        function buildStyle(styles) {
            var result = '';
            for (var style in styles) {
                if (styles.hasOwnProperty(style)) {
                    if (isPDF && style == 'font-size') {
                        styles[style] = '100%';
                    }
                    result += style + ':' + styles[style] + ';';
                }
            }
            return result;
        }
    }

    HtmlExporter.prototype = new $.jqx.dataAdapter.DataExportModuleBase();

    var TableExporter = function () { };
    TableExporter.prototype = new HtmlExporter();

    var PDFExporter = function () { };
    PDFExporter.prototype = new HtmlExporter();
    var exporter = new PDFExporter();

    $.jqx.dataAdapter.ArrayExporter.extend('html', new TableExporter());
    $.jqx.dataAdapter.ArrayExporter.extend('pdf', exporter);

})(jqxBaseFramework);

//Exporting to XLS format (MS Office Excel 2003)
(function ($) {

    var ExcelExporter = function () {

        var header, content, headerFields, headerStyles, existingStyles, styleCounter,
            styleBuilder = {

                style: '',

                stylesMap: {
                    'font': {
                        'color': 'Color',
                        'font-family': 'FontName',
                        'font-style': 'Italic',
                        'font-weight': 'Bold'
                    },
                    'interior': {
                        'background-color': 'Color',
                        'background': 'Color'
                    },
                    'alignment': {
                        'left': 'Left',
                        'center': 'Center',
                        'right': 'Right'
                    }
                },

                startStyle: function (styleName) {
                    this.style += '\n\t\t<Style ss:ID="' + styleName + '" ss:Name="' + styleName + '">';
                },

                buildAlignment: function (styles) {
                    if (styles['text-align']) {
                        var alignment = this.stylesMap['alignment'][styles['text-align']];
                        if (!alignment) {
                            alignment = "Left";
                        }
                        var style = '\n\t\t\t<Alignment ss:Vertical="Bottom" ss:Horizontal="' + alignment + '"/>';
                        this.style += style;
                    }
                },

                buildBorder: function (styles) {
                    if (styles['border-color']) {
                        var border = '\n\t\t\t<Borders>';
                        var bottomBorder = '\n\t\t\t\t<Border ss:Position="Bottom" ss:LineStyle="Continuous" ss:Weight="1" ss:Color="' + styles['border-color'] + '"/>';
                        var leftBorder = '\n\t\t\t\t<Border ss:Position="Left" ss:LineStyle="Continuous" ss:Weight="1" ss:Color="' + styles['border-color'] + '"/>';
                        var rightBorder = '\n\t\t\t\t<Border ss:Position="Right" ss:LineStyle="Continuous" ss:Weight="1" ss:Color="' + styles['border-color'] + '"/>';
                        var topBorder = '\n\t\t\t\t<Border ss:Position="Top" ss:LineStyle="Continuous" ss:Weight="1" ss:Color="' + styles['border-color'] + '"/>';

                        border += bottomBorder;
                        border += leftBorder;
                        border += rightBorder;
                        border += topBorder;
                        border += '\n\t\t\t</Borders>';
                        this.style += border;
                    }
                },

                buildFont: function (styles) {
                    var map = this.stylesMap['font'],
                        font = '\n\t\t\t<Font ';
                    for (var prop in map) {
                        if (typeof styles[prop] !== 'undefined') {
                            if (prop === 'font-style' && styles[prop].toString().toLowerCase() === 'italic') {
                                font += 'ss:Italic="1" ';
                            } else if (prop === 'font-weight' && styles[prop].toString().toLowerCase() === 'bold') {
                                font += 'ss:Bold="1" ';
                            } else if (prop === 'color') {
                                font += 'ss:' + map[prop] + '="' + styles[prop] + '" ';
                            }
                        }
                    }
                    font += '/>';
                    this.style += font;
                },

                buildInterior: function (styles) {
                    var map = this.stylesMap['interior'],
                        interior = '\n\t\t\t<Interior ';
                    var hasInterior = false;
                    for (var prop in map) {
                        if (typeof styles[prop] !== 'undefined') {
                            interior += 'ss:' + map[prop] + '="' + styles[prop] + '" ';
                            hasInterior = true;
                        }
                    }
                    if (hasInterior)
                        interior += 'ss:Pattern="Solid"';

                    interior += '/>';
                    this.style += interior;
                },

                buildFormat: function (styles) {
                    if (styles['dataType'] == 'number' || styles['dataType'] == 'float' || styles['dataType'] == 'int' || styles['dataType'] == 'integer') {
                        var formatString = styles['formatString'];
                        if (formatString == "" || formatString.indexOf('n') != -1 || formatString.indexOf('N') != -1) {
                            this.style += '\n\t\t\t<NumberFormat ss:Format="0"/>';
                        }
                        else if (formatString == "f" || formatString == "F" || formatString == "D" || formatString.indexOf('d') != -1) {
                            this.style += '\n\t\t\t<NumberFormat ss:Format="#,##0.00_);[Red]\(#,##0.00\)"/>';
                        }
                        else if (formatString.indexOf('p') != -1 || formatString.indexOf('P') != -1) {
                            this.style += '\n\t\t\t<NumberFormat ss:Format="Percent"/>';
                        }
                        else if (formatString.indexOf('c') != -1 || formatString.indexOf('C') != -1) {
                            if (styles['currencysymbol'] && parseInt(styles['currencysymbol'].charCodeAt(0)) == 8364) {
                                this.style += '\n\t\t\t<NumberFormat ss:Format="Euro Currency"/>';
                            }
                            else {
                                this.style += '\n\t\t\t<NumberFormat ss:Format="Currency"/>';
                            }
                        }
                    }
                    else if (styles['dataType'] == 'date') {
                        this.style += '\n\t\t\t<NumberFormat ss:Format="Short Date"/>';
                    }
                },

                closeStyle: function () {
                    this.style += '\n\t\t</Style>';
                },

                toString: function () {
                    var temp = this.style;
                    this.style = '';
                    return temp;
                }
            };

        this.beginFile = function () {
            existingStyles = {};
            styleCounter = 0;
            header = '<?xml version="1.0"?>' +
                            '\n\t<?mso-application progid="Excel.Sheet"?> ' +
                            '\n\t<Workbook xmlns="urn:schemas-microsoft-com:office:spreadsheet" ' +
                            '\n\txmlns:o="urn:schemas-microsoft-com:office:office" ' +
                            '\n\txmlns:x="urn:schemas-microsoft-com:office:excel" ' +
                            '\n\txmlns:ss="urn:schemas-microsoft-com:office:spreadsheet" ' +
                            '\n\txmlns:html="http://www.w3.org/TR/REC-html40"> ' +
                            '\n\t<DocumentProperties xmlns="urn:schemas-microsoft-com:office:office"> ' +
                            '\n\t<Version>12.00</Version> ' +
                            '\n\t</DocumentProperties> ' +
                            '\n\t<ExcelWorkbook xmlns="urn:schemas-microsoft-com:office:excel"> ' +
                            '\n\t<WindowHeight>8130</WindowHeight> ' +
                            '\n\t<WindowWidth>15135</WindowWidth> ' +
                            '\n\t<WindowTopX>120</WindowTopX> ' +
                            '\n\t<WindowTopY>45</WindowTopY> ' +
                            '\n\t<ProtectStructure>False</ProtectStructure> ' +
                            '\n\t<ProtectWindows>False</ProtectWindows> ' +
                            '\n\t</ExcelWorkbook> ' +
                        '\n\t<Styles>';
        };

        this.beginHeader = function () {
            content = '\n\t<Worksheet ss:Name="Sheet1">\n\t\t<Table>';
            headerFields = [];
            headerStyles = [];
        };

        this.appendHeaderCell = function (data, fieldName, style) {
            var width = data.width != undefined ? data.width : data.text.length * 10;
            content += '\n\t\t\t<Column ss:Width="' + width + '"/>';
            headerFields.push(data);
            headerStyles.push(style);
        };

        this.endHeader = function (exportHeader) {
            if (exportHeader) {
                this.beginRow();
                for (var i = 0; i < headerFields.length; i += 1) {
                    if (headerStyles[i].disabled) continue;
                    appendCell.call(this, headerFields[i]['text'], null, headerStyles[i]);
                }
                this.endRow();
            }
        };

        this.beginBody = function () {
        };

        this.beginRow = function (level) {
            if (level != undefined) {
                content += '\n\t\t\t';
                for (var i = 0; i < level; i++) {
                    content += '\t';
                }
                content += '<Row>';
                return;
            }

            content += '\n\t\t\t<Row>';
        };

        this.beginRows = function (level) {
            content += '\n\t\t\t\t<Rows>';
        };

        this.appendBodyCell = function (data, dataType, style, row) {
            appendCell.call(this, data, dataType, style, row);
        };

        this.endRow = function (level) {
            if (level != undefined) {
                content += '\n\t\t\t';
                for (var i = 0; i < level; i++) {
                    content += '\t';
                }
                content += '</Row>';
                return;
            }

            content += '\n\t\t\t</Row>';
        };

        this.endRows = function (level) {
            if (level != undefined) {
                content += '\n\t\t\t';
                for (var i = 0; i < level; i++) {
                    content += '\t';
                }
                content += '</Rows>';
                return;
            }
        };

        this.endBody = function () {
            content += '\n\t\t</Table>';
        };

        this.endFile = function () {
            content += '\n\t</Worksheet>\n</Workbook>';
            header += '\n\t</Styles>';
        };

        this.getFile = function () {
            return header + content;
        };

        function appendCell(data, dataOptions, style, row) {
            var columnType = "String";

            var format = this.getFormat(dataOptions);

            if (data != null && data.toString().substring(0, 3) == "_AG") {
                data = data.toString().substring(3);
                columnType = "String";
            }
            else {
                if (format.type == 'date') {
                    var date = data;
                    data = this.formatData(data, format.type, format.formatString, format.localization);
                    if (data === null || data === "") {
                        data = "";
                        columnType = "String";
                    }
                    else {
                        data = date.toISOString();
                        columnType = "DateTime";
                    }
                }
                if (format.type == 'string') {
                    if (data === null || data === undefined) {
                        data = "";
                    }
                    else {
                        if (data.toString().indexOf('&') >= 0) {
                            data = data.toString().replace(/&/g, '&amp;');
                        }
                        if (data.toString().indexOf('>') >= 0) {
                            data = data.toString().replace(/>/g, '&gt;');
                        }
                        if (data.toString().indexOf('<') >= 0) {
                            data = data.toString().replace(/</g, '&lt;');
                        }
                        if (data.toString().indexOf('"') >= 0) {
                            data = data.toString().replace(/"/g, '&quot;');
                        }
                        if (data.toString().indexOf("'") >= 0) {
                            data = data.toString().replace(/'/g, '&apos;');
                        }
                    }
                }

                if (style.dataType == 'number' || style.dataType == 'float' || style.dataType == 'int' || style.dataType == 'integer') {
                    columnType = "Number";
                    data = parseFloat(data);
                    if (data === null || isNaN(data) || data === "") {
                        data = "";
                        columnType = "String";
                    }
                    if (data && columnType != "String" && data != "") {
                        if (dataOptions && dataOptions.formatString && dataOptions.formatString.indexOf('p') >= 0) {
                            data = data / 100;
                        }
                    }

                    style.currencysymbol = dataOptions.localization.currencysymbol;
                }
            }

            var styleId = getStyleId(style);
            if (style.merge) {
                content += '\n\t\t\t\t<Cell ss:MergeAcross="' + style.merge + '" ss:StyleID="' + styleId + '"><Data ss:Type="' + columnType + '">' + data + '</Data></Cell>';
            }
            else {
                content += '\n\t\t\t\t<Cell ss:StyleID="' + styleId + '"><Data ss:Type="' + columnType + '">' + data + '</Data></Cell>';
            }
        }

        function generateStyleId() {
            styleCounter += 1;
            return 'xls-style-' + styleCounter;
        }

        function findStyle(style) {
            for (var s in existingStyles) {
                if (isSubset(style, existingStyles[s]) && isSubset(existingStyles[s], style)) {
                    return s;
                }
            }
            return undefined;
        }

        function isSubset(first, second) {
            var subset = true;
            for (var p in first) {
                if (first[p] !== second[p]) {
                    subset = false;
                }
            }
            return subset;
        }

        function appendStyle(id, style) {
            styleBuilder.startStyle(id);
            styleBuilder.buildAlignment(style);
            styleBuilder.buildBorder(style);
            styleBuilder.buildFont(style);
            styleBuilder.buildInterior(style);
            styleBuilder.buildFormat(style);
            styleBuilder.closeStyle();
            header += styleBuilder.toString();
        }

        function getStyleId(style) {
            if (!style) {
                return '';
            }
            var id = findStyle(style);
            if (typeof id === 'undefined') {
                id = generateStyleId();
                existingStyles[id] = style;
                appendStyle(id, style);
            }
            return id;
        }
    }

    ExcelExporter.prototype = new $.jqx.dataAdapter.DataExportModuleBase();
    $.jqx.dataAdapter.ArrayExporter.extend('xls', new ExcelExporter());
})(jqxBaseFramework);

//Exporting to XML
(function ($) {

    var XmlExporter = function () {

        var file, headerFields, index;

        this.beginFile = function () {
            file = '<?xml version="1.0" encoding="UTF-8" ?>';
            file += '\n<table>';
        }

        this.beginHeader = function () {
            headerFields = [];
        }

        this.appendHeaderCell = function (data, fieldName) {
            headerFields.push(fieldName);
        }

        this.endHeader = function () {
        }

        this.beginBody = function (data, dataType) {
        }

        this.beginRow = function (level) {
            var that = this;

            if (!that) {
                that = window.jqx;
            }

            if (level != undefined) {
                if (that.hierarchy) {
                    file += '\n\t';
                    for (var i = 0; i < level; i++) {
                        file += '\t\t';
                    }
                    file += '<row>';
                    index = 0;
                    return;
                }
            }

            file += '\n\t<row>';
            index = 0;
        }

        this.beginRows = function (level) {
            if (level != undefined) {
                file += '\n\t\t';
                for (var i = 0; i < level; i++) {
                    file += '\t\t';
                }
                file += '<rows>';
                index = 0;
                return;
            }
            file += '\n\t\t<rows>';
        }

        this.appendBodyCell = function (data, dataOptions, style, row, indx, group) {
            var that = this;

            if (!that) {
                that = window.jqx;
            }

            var format = this.getFormat(dataOptions);
            data = this.formatData(data, format.type, format.formatString, format.localization);
            if (format.type == "string") {
                if (data.toString().indexOf('&') >= 0) {
                    data = data.toString().replace(/&/g, '&amp;');
                }
                if (data.toString().indexOf('>') >= 0) {
                    data = data.toString().replace(/>/g, '&gt;');
                }
                if (data.toString().indexOf('<') >= 0) {
                    data = data.toString().replace(/</g, '&lt;');
                }
                if (data.toString().indexOf('"') >= 0) {
                    data = data.toString().replace(/"/g, '&quot;');
                }
                if (data.toString().indexOf("'") >= 0) {
                    data = data.toString().replace(/'/g, '&apos;');
                }
            }
            if (row.level != undefined) {
                if (that.hierarchy) {
                    file += '\n\t\t';
                    for (var i = 0; i < row.level; i++) {
                        file += '\t\t';
                    }
                    if (group === undefined) {
                        file += '<' + headerFields[index] + '>' + data + '</' + headerFields[index] + '>';
                    }
                    else {
                        file += '<' + group + '>' + data + '</' + group + '>';
                    }
                }
                else {
                    if (group != undefined) {
                        file += '\n\t\t<' + group + '>' + data + '</' + group + '>';
                    }
                    else {
                        file += '\n\t\t<' + headerFields[index] + '>' + data + '</' + headerFields[index] + '>';
                    }
                }
            }
            else {
                file += '\n\t\t<' + headerFields[index] + '>' + data + '</' + headerFields[index] + '>';
            }
            index++;
        }

        this.endRow = function (level) {
            var that = this;

            if (!that) {
                that = window.jqx;
            }

            if (level != undefined) {
                if (that.hierarchy) {
                    file += '\n\t';
                    for (var i = 0; i < level; i++) {
                        file += '\t\t';
                    }

                    file += '</row>';
                    index = 0;
                    return;
                }
            }
            file += '\n\t</row>';
            index = 0;
        }

        this.endRows = function (level) {
            if (level != undefined) {
                file += '\n\t\t';
                for (var i = 0; i < level; i++) {
                    file += '\t\t';
                }
                file += '</rows>';
                index = 0;
                return;
            }
            file += '\n\t\t</rows>';
        }

        this.endBody = function () {
        }

        this.endFile = function () {
            file += '\n</table>';
        }

        this.getFile = function () {
            return file;
        }
    }

    XmlExporter.prototype = new $.jqx.dataAdapter.DataExportModuleBase();
    $.jqx.dataAdapter.ArrayExporter.extend('xml', new XmlExporter());
})(jqxBaseFramework);


//Exporting to JSON
(function ($) {

    var escapable = /[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,
        meta = {
            '\b': '\\b',
            '\t': '\\t',
            '\n': '\\n',
            '\f': '\\f',
            '\r': '\\r',
            '"': '\\"',
            '\\': '\\\\'
        };

    function quote(string) {
        return '"' + string.replace(escapable, function (a) {
            var c = meta[a];
            return typeof c === 'string' ? c : '\\u' + ('0000' + a.charCodeAt(0).toString(16)).slice(-4);
        }) + '"';
    }

    function formatNumber(n) {
        return n < 10 ? '0' + n : n;
    }

    function stringifyDate(value) {
        var date;
        if (isFinite(value.valueOf())) {
            date = value.getUTCFullYear() + '-' + formatNumber(value.getUTCMonth() + 1) + '-' +
            formatNumber(value.getUTCDate()) + 'T' + formatNumber(value.getUTCHours()) + ':' +
            formatNumber(value.getUTCMinutes()) + ':' + formatNumber(value.getUTCSeconds()) + 'Z"';
        } else {
            date = 'null';
        }
        return date;
    }

    function stringifyArray(value) {
        var len = value.length,
            partial = [],
            i;
        for (i = 0; i < len; i++) {
            partial.push(str(i, value) || 'null');
        }

        return '[' + partial.join(',') + ']';
    }

    function stringifyObject(value) {
        var partial = [],
            i, v;
        for (i in value) {
            if (Object.prototype.hasOwnProperty.call(value, i)) {
                v = str(i, value);
                if (v) {
                    partial.push(quote(i) + ':' + v);
                }
            }
        }
        return '{' + partial.join(',') + '}';
    }

    function stringifyReference(value) {
        switch (Object.prototype.toString.call(value)) {
            case '[object Date]':
                return stringifyDate(value);
            case '[object Array]':
                return stringifyArray(value);
        }
        return stringifyObject(value);
    }

    function stringifyPrimitive(value, type) {
        switch (type) {
            case 'string':
                return quote(value);
            case 'number':
            case 'float':
            case 'integer':
            case 'int':
                return isFinite(value) ? value : 'null';
            case 'boolean':
                return value;
        }
        return 'null';
    }

    function str(key, holder) {
        var value = holder[key], type = typeof value;

        if (value && typeof value === 'object' && typeof value.toJSON === 'function') {
            value = value.toJSON(key);
            type = typeof value;
        }
        if (/(number|float|int|integer|string|boolean)/.test(type) || (!value && type === 'object')) {
            return stringifyPrimitive(value, type);
        } else {
            return stringifyReference(value);
        }
    }

    function stringify(value) {
        if (window.JSON && typeof window.JSON.stringify === 'function') {
            return window.JSON.stringify(value);
        }

        return str("", { "": value });
    }

    var JsonExporter = function () {
        var me = this;
        this.prepareData = function (data, dataOptions) {
            if (dataOptions) {
                var format = me.getFormat(dataOptions);
                data = me.formatData(data, format.type, format.formatString, format.localization);
            }
            return data;
        }

        var file,
            content,
            currentCell,
            cellHierarchy = [],
            level = 0
        ;

        this.beginFile = function () {
            content = [];
        }

        this.beginHeader = function () {
        }

        this.appendHeaderCell = function (data) {
        }

        this.endHeader = function () {
        }

        this.beginBody = function (data, dataType) {
        }

        this.beginRow = function () {
            var that = this;

            if (!that) {
                that = window.jqx;
            }

            if (that.hierarchy || window.jqx.hierarchy) {
                cellHierarchy[level] = {};
            }
            else {
                currentCell = {};
            }
        }

        this.beginRows = function () {
            cellHierarchy[level].rows = [];
            level++;
            cellHierarchy[level] = {};
        }
        this.endRows = function () {
            level--;
        }

        this.appendBodyCell = function (data, dataType) {
            var that = this;

            if (!that) {
                that = window.jqx;
            }


            var text = this.prepareData(data, dataType);
            if (that.hierarchy || window.jqx.hierarchy) {
                cellHierarchy[level][dataType['text']] = text;
            }
            else {
                currentCell[dataType['text']] = text;
            }
        }

        this.endRow = function () {
            var that = this;

            if (!that) {
                that = window.jqx;
            }


            if (that.hierarchy || window.jqx.hierarchy) {
                if (level == 0) {
                    content.push(cellHierarchy[level]);
                }
                else {
                    cellHierarchy[level - 1].rows.push(cellHierarchy[level]);
                }
            }
            else {
                content.push(currentCell);
            }
        }

        this.endBody = function () {
        }

        this.endFile = function () {
            file = stringify(content);
        }

        this.getFile = function () {
            return file;
        }
    }

    JsonExporter.prototype = new $.jqx.dataAdapter.DataExportModuleBase();
    $.jqx.dataAdapter.ArrayExporter.extend('json', new JsonExporter());

})(jqxBaseFramework);


var pdfDataExport = window.jqxPdfDataExport = (function () {
    'use strict';
    if (typeof btoa === 'undefined') {
        window.btoa = function (data) {
            var b64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",
                b64a = b64.split(''),
                o1,
                o2,
                o3,
                h1,
                h2,
                h3,
                h4,
                bits,
                i = 0,
                ac = 0,
                enc = "",
                tmp_arr = [],
                r;

            do {
                o1 = data.charCodeAt(i++);
                o2 = data.charCodeAt(i++);
                o3 = data.charCodeAt(i++);

                bits = o1 << 16 | o2 << 8 | o3;

                h1 = bits >> 18 & 0x3f;
                h2 = bits >> 12 & 0x3f;
                h3 = bits >> 6 & 0x3f;
                h4 = bits & 0x3f;

                tmp_arr[ac++] = b64a[h1] + b64a[h2] + b64a[h3] + b64a[h4];
            } while (i < data.length);

            enc = tmp_arr.join('');
            r = data.length % 3;
            return (r ? enc.slice(0, r - 3) : enc) + '==='.slice(r || 3);
        };
    }

    if (typeof atob === 'undefined') {
        window.atob = function (data) {

            var b64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",
                o1,
                o2,
                o3,
                h1,
                h2,
                h3,
                h4,
                bits,
                i = 0,
                ac = 0,
                dec = "",
                tmp_arr = [];

            if (!data) {
                return data;
            }

            data += '';

            do { // unpack four hexets into three octets using index points in b64
                h1 = b64.indexOf(data.charAt(i++));
                h2 = b64.indexOf(data.charAt(i++));
                h3 = b64.indexOf(data.charAt(i++));
                h4 = b64.indexOf(data.charAt(i++));

                bits = h1 << 18 | h2 << 12 | h3 << 6 | h4;

                o1 = bits >> 16 & 0xff;
                o2 = bits >> 8 & 0xff;
                o3 = bits & 0xff;

                if (h3 === 64) {
                    tmp_arr[ac++] = String.fromCharCode(o1);
                } else if (h4 === 64) {
                    tmp_arr[ac++] = String.fromCharCode(o1, o2);
                } else {
                    tmp_arr[ac++] = String.fromCharCode(o1, o2, o3);
                }
            } while (i < data.length);
            dec = tmp_arr.join('');
            return dec;
        };
    }

    var getObjectLength = typeof Object.keys === 'function' ?
                function (object) {
                    return Object.keys(object).length;
                } :
                function (object) {
                    var i = 0, e;
                    for (e in object) {
                        if (object.hasOwnProperty(e)) {
                            i++;
                        }
                    }
                    return i;
                },

/**
PubSub implementation

@class
@name PubSub
*/
        PubSub = function (context) {
            /*
            @private
            @fieldOf PubSub
            */
            this.topics = {};
            /**
            Stores what will be `this` within the callback functions.

            @private
            @fieldOf PubSub#
            */
            this.context = context;
            /**
            Allows caller to emit an event and pass arguments to event listeners.
            @public
            @function
            @param topic {String} Name of the channel on which to voice this event
            @param args Any number of arguments you want to pass to the listeners of this event.
            @methodOf PubSub#
            @name publish
            */
            this.publish = function (topic, args) {
                if (this.topics[topic]) {
                    var currentTopic = this.topics[topic],
                        toremove = [],
                        fn,
                        i,
                        l,
                        pair,
                        emptyFunc = function () { };
                    args = Array.prototype.slice.call(arguments, 1);
                    for (i = 0, l = currentTopic.length; i < l; i++) {
                        pair = currentTopic[i]; // this is a [function, once_flag] array
                        fn = pair[0];
                        if (pair[1]) { /* 'run once' flag set */
                            pair[0] = emptyFunc;
                            toremove.push(i);
                        }
                        fn.apply(this.context, args);
                    }
                    for (i = 0, l = toremove.length; i < l; i++) {
                        currentTopic.splice(toremove[i], 1);
                    }
                }
            };
            /**
            Allows listener code to subscribe to channel and be called when data is available
            @public
            @function
            @param topic {String} Name of the channel on which to voice this event
            @param callback {Function} Executable (function pointer) that will be ran when event is voiced on this channel.
            @param once {Boolean} (optional. False by default) Flag indicating if the function is to be triggered only once.
            @returns {Object} A token object that cen be used for unsubscribing.
            @methodOf PubSub#
            @name subscribe
            */
            this.subscribe = function (topic, callback, once) {
                if (!this.topics[topic]) {
                    this.topics[topic] = [[callback, once]];
                } else {
                    this.topics[topic].push([callback, once]);
                }
                return {
                    "topic": topic,
                    "callback": callback
                };
            };
            /**
            Allows listener code to unsubscribe from a channel
            @public
            @function
            @param token {Object} A token object that was returned by `subscribe` method
            @methodOf PubSub#
            @name unsubscribe
            */
            this.unsubscribe = function (token) {
                if (this.topics[token.topic]) {
                    var currentTopic = this.topics[token.topic], i, l;

                    for (i = 0, l = currentTopic.length; i < l; i++) {
                        if (currentTopic[i][0] === token.callback) {
                            currentTopic.splice(i, 1);
                        }
                    }
                }
            };
        };


    /**
    @constructor
    @private
    */
    function pdfDataExport(orientation, unit, format, compressPdf) { /** String orientation, String unit, String format, Boolean compressed */

        // Default parameter values
        if (typeof orientation === 'undefined') {
            orientation = 'p';
        } else {
            orientation = orientation.toString().toLowerCase();
        }
        if (typeof unit === 'undefined') { unit = 'mm'; }
        if (typeof format === 'undefined') { format = 'a4'; }
        if (typeof compressPdf === 'undefined' && typeof zpipe === 'undefined') { compressPdf = false; }

        var format_as_string = format.toString().toLowerCase(),
            version = '0.9.0rc2',
            content = [],
            content_length = 0,
            compress = compressPdf,
            pdfVersion = '1.3', // PDF Version
            pageFormats = { // Size in pt of various paper formats
                'a3': [841.89, 1190.55],
                'a4': [595.28, 841.89],
                'a5': [420.94, 595.28],
                'letter': [612, 792],
                'legal': [612, 1008]
            },
            textColor = '0 g',
            drawColor = '0 G',
            page = 0,
            pages = [],
            objectNumber = 2, // 'n' Current object number
            outToPages = false, // switches where out() prints. outToPages true = push to pages obj. outToPages false = doc builder content
            offsets = [], // List of offsets. Activated and reset by buildDocument(). Pupulated by various calls buildDocument makes.
            fonts = {}, // collection of font objects, where key is fontKey - a dynamically created label for a given font.
            fontmap = {}, // mapping structure fontName > fontStyle > font key - performance layer. See addFont()
            activeFontSize = 16,
            activeFontKey, // will be string representing the KEY of the font as combination of fontName + fontStyle
            lineWidth = 0.200025, // 2mm
            pageHeight,
            pageWidth,
            k, // Scale factor
            documentProperties = { 'title': '', 'subject': '', 'author': '', 'keywords': '', 'creator': '' },
            lineCapID = 0,
            lineJoinID = 0,
            API = {},
            events = new PubSub(API),
            tmp,
            plugin,
            /////////////////////
            // Private functions
            /////////////////////
            // simplified (speedier) replacement for sprintf's %.2f conversion
            f2 = function (number) {
                return number.toFixed(2);
            },
            // simplified (speedier) replacement for sprintf's %.3f conversion
            f3 = function (number) {
                return number.toFixed(3);
            },
            // simplified (speedier) replacement for sprintf's %02d
            padd2 = function (number) {
                var n = (number).toFixed(0);
                if (number < 10) {
                    return '0' + n;
                } else {
                    return n;
                }
            },
            // simplified (speedier) replacement for sprintf's %02d
            padd10 = function (number) {
                var n = (number).toFixed(0);
                if (n.length < 10) {
                    return new Array(11 - n.length).join('0') + n;
                } else {
                    return n;
                }
            },
            out = function (string) {
                if (outToPages) { /* set by beginPage */
                    pages[page].push(string);
                } else {
                    content.push(string);
                    content_length += string.length + 1; // +1 is for '\n' that will be used to join contents of content
                }
            },
            newObject = function () {
                // Begin a new object
                objectNumber++;
                offsets[objectNumber] = content_length;
                out(objectNumber + ' 0 obj');
                return objectNumber;
            },
            putStream = function (str) {
                out('stream');
                out(str);
                out('endstream');
            },
            wPt,
            hPt,
            kids,
            i,
            putPages = function () {
                wPt = pageWidth * k;
                hPt = pageHeight * k;

                // outToPages = false as set in endDocument(). out() writes to content.

                var n, p, arr, uint, i, deflater, adler32;
                for (n = 1; n <= page; n++) {
                    newObject();
                    out('<</Type /Page');
                    out('/Parent 1 0 R');
                    out('/Resources 2 0 R');
                    out('/Contents ' + (objectNumber + 1) + ' 0 R>>');
                    out('endobj');

                    // Page content
                    p = pages[n].join('\n');
                    newObject();
                    if (compress) {
                        arr = [];
                        for (i = 0; i < p.length; ++i) {
                            arr[i] = p.charCodeAt(i);
                        }
                        adler32 = adler32cs.from(p);
                        deflater = new Deflater(6);
                        deflater.append(new Uint8Array(arr));
                        p = deflater.flush();
                        arr = [new Uint8Array([120, 156]), new Uint8Array(p),
                               new Uint8Array([adler32 & 0xFF, (adler32 >> 8) & 0xFF, (adler32 >> 16) & 0xFF, (adler32 >> 24) & 0xFF])];
                        p = '';
                        for (i in arr) {
                            if (arr.hasOwnProperty(i)) {
                                p += String.fromCharCode.apply(null, arr[i]);
                            }
                        }
                        out('<</Length ' + p.length + ' /Filter [/FlateDecode]>>');
                    } else {
                        out('<</Length ' + p.length + '>>');
                    }
                    putStream(p);
                    out('endobj');
                }
                offsets[1] = content_length;
                out('1 0 obj');
                out('<</Type /Pages');
                kids = '/Kids [';
                for (i = 0; i < page; i++) {
                    kids += (3 + 2 * i) + ' 0 R ';
                }
                out(kids + ']');
                out('/Count ' + page);
                out('/MediaBox [0 0 ' + f2(wPt) + ' ' + f2(hPt) + ']');
                out('>>');
                out('endobj');
            },
            putFont = function (font) {
                font.objectNumber = newObject();
                out('<</BaseFont/' + font.PostScriptName + '/Type/Font');
                if (typeof font.encoding === 'string') {
                    out('/Encoding/' + font.encoding);
                }
                out('/Subtype/Type1>>');
                out('endobj');
            },
            putFonts = function () {
                var fontKey;
                for (fontKey in fonts) {
                    if (fonts.hasOwnProperty(fontKey)) {
                        putFont(fonts[fontKey]);
                    }
                }
            },
            putXobjectDict = function () {
                // Loop through images, or other data objects
                events.publish('putXobjectDict');
            },
            putResourceDictionary = function () {
                out('/ProcSet [/PDF /Text /ImageB /ImageC /ImageI]');
                out('/Font <<');
                // Do this for each font, the '1' bit is the index of the font
                var fontKey;
                for (fontKey in fonts) {
                    if (fonts.hasOwnProperty(fontKey)) {
                        out('/' + fontKey + ' ' + fonts[fontKey].objectNumber + ' 0 R');
                    }
                }
                out('>>');
                out('/XObject <<');
                putXobjectDict();
                out('>>');
            },
            putResources = function () {
                putFonts();
                events.publish('putResources');
                // Resource dictionary
                offsets[2] = content_length;
                out('2 0 obj');
                out('<<');
                putResourceDictionary();
                out('>>');
                out('endobj');
                events.publish('postPutResources');
            },
            addToFontDictionary = function (fontKey, fontName, fontStyle) {
                // this is mapping structure for quick font key lookup.
                // returns the KEY of the font (ex: "F1") for a given pair of font name and type (ex: "Arial". "Italic")
                var undef;
                if (fontmap[fontName] === undef) {
                    fontmap[fontName] = {}; // fontStyle is a var interpreted and converted to appropriate string. don't wrap in quotes.
                }
                fontmap[fontName][fontStyle] = fontKey;
            },
            /**
            FontObject describes a particular font as member of an instnace of pdfDataExport

            It's a collection of properties like 'id' (to be used in PDF stream),
            'fontName' (font's family name), 'fontStyle' (font's style variant label)

            @class
            @public
            @property id {String} PDF-document-instance-specific label assinged to the font.
            @property PostScriptName {String} PDF specification full name for the font
            @property encoding {Object} Encoding_name-to-Font_metrics_object mapping.
            @name FontObject
            */
            FontObject = {},
            addFont = function (PostScriptName, fontName, fontStyle, encoding) {
                var fontKey = 'F' + (getObjectLength(fonts) + 1).toString(10),
                    // This is FontObject
                    font = fonts[fontKey] = {
                        'id': fontKey,
                        // , 'objectNumber':   will be set by putFont()
                        'PostScriptName': PostScriptName,
                        'fontName': fontName,
                        'fontStyle': fontStyle,
                        'encoding': encoding,
                        'metadata': {}
                    };

                addToFontDictionary(fontKey, fontName, fontStyle);

                events.publish('addFont', font);

                return fontKey;
            },
            addFonts = function () {

                var HELVETICA = "helvetica",
                    TIMES = "times",
                    COURIER = "courier",
                    NORMAL = "normal",
                    BOLD = "bold",
                    ITALIC = "italic",
                    BOLD_ITALIC = "bolditalic",
                    encoding = 'StandardEncoding',
                    standardFonts = [
                        ['Helvetica', HELVETICA, NORMAL],
                        ['Helvetica-Bold', HELVETICA, BOLD],
                        ['Helvetica-Oblique', HELVETICA, ITALIC],
                        ['Helvetica-BoldOblique', HELVETICA, BOLD_ITALIC],
                        ['Courier', COURIER, NORMAL],
                        ['Courier-Bold', COURIER, BOLD],
                        ['Courier-Oblique', COURIER, ITALIC],
                        ['Courier-BoldOblique', COURIER, BOLD_ITALIC],
                        ['Times-Roman', TIMES, NORMAL],
                        ['Times-Bold', TIMES, BOLD],
                        ['Times-Italic', TIMES, ITALIC],
                        ['Times-BoldItalic', TIMES, BOLD_ITALIC]
                    ],
                    i,
                    l,
                    fontKey,
                    parts;
                for (i = 0, l = standardFonts.length; i < l; i++) {
                    var en = encoding;

                    fontKey = addFont(
                        standardFonts[i][0],
                        standardFonts[i][1],
                        standardFonts[i][2],
                        en
                    );

                    // adding aliases for standard fonts, this time matching the capitalization
                    parts = standardFonts[i][0].split('-');
                    addToFontDictionary(fontKey, parts[0], parts[1] || '');
                }

                events.publish('addFonts', { 'fonts': fonts, 'dictionary': fontmap });
            },
            /**

            @public
            @function
            @param text {String}
            @param flags {Object} Encoding flags.
            @returns {String} Encoded string
            */
            to8bitStream = function (text, flags) {

                var i, l, undef, sourceEncoding, encodingBlock, outputEncoding, newtext, isUnicode, ch, bch;

                if (flags === undef) {
                    flags = {};
                }

                sourceEncoding = flags.sourceEncoding ? sourceEncoding : 'Unicode';

                outputEncoding = flags.outputEncoding;

                // This 'encoding' section relies on font metrics format
                // attached to font objects by, among others,
                // "Willow Systems' standard_font_metrics plugin"
                // see pdfDataExport.plugin.standard_font_metrics.js for format
                // of the font.metadata.encoding Object.
                // It should be something like
                //   .encoding = {'codePages':['WinANSI....'], 'WinANSI...':{code:code, ...}}
                //   .widths = {0:width, code:width, ..., 'fof':divisor}
                //   .kerning = {code:{previous_char_code:shift, ..., 'fof':-divisor},...}
                if ((flags.autoencode || outputEncoding) &&
                        fonts[activeFontKey].metadata &&
                        fonts[activeFontKey].metadata[sourceEncoding] &&
                        fonts[activeFontKey].metadata[sourceEncoding].encoding
                        ) {
                    encodingBlock = fonts[activeFontKey].metadata[sourceEncoding].encoding;

                    // each font has default encoding. Some have it clearly defined.
                    if (!outputEncoding && fonts[activeFontKey].encoding) {
                        outputEncoding = fonts[activeFontKey].encoding;
                    }

                    // Hmmm, the above did not work? var's try again, in different place.
                    if (!outputEncoding && encodingBlock.codePages) {
                        outputEncoding = encodingBlock.codePages[0]; // var's say, first one is the default
                    }

                    if (typeof outputEncoding === 'string') {
                        outputEncoding = encodingBlock[outputEncoding];
                    }
                    // we want output encoding to be a JS Object, where
                    // key = sourceEncoding's character code and
                    // value = outputEncoding's character code.
                    if (outputEncoding) {
                        isUnicode = false;
                        newtext = [];
                        for (i = 0, l = text.length; i < l; i++) {
                            ch = outputEncoding[text.charCodeAt(i)];
                            if (ch) {
                                newtext.push(
                                    String.fromCharCode(ch)
                                );
                            } else {
                                newtext.push(
                                    text[i]
                                );
                            }

                            // since we are looping over chars anyway, might as well
                            // check for residual unicodeness
                            if (newtext[i].charCodeAt(0) >> 8) { /* more than 255 */
                                isUnicode = true;
                            }
                        }
                        text = newtext.join('');
                    }
                }

                i = text.length;
                // isUnicode may be set to false above. Hence the triple-equal to undefined
                while (isUnicode === undef && i !== 0) {
                    if (text.charCodeAt(i - 1) >> 8) { /* more than 255 */
                        isUnicode = true;
                    }
                    i--;
                }
                if (!isUnicode) {
                    return text;
                } else {
                    newtext = flags.noBOM ? [] : [254, 255];
                    for (i = 0, l = text.length; i < l; i++) {
                        ch = text.charCodeAt(i);
                        bch = ch >> 8; // divide by 256
                        if (bch >> 8) { /* something left after dividing by 256 second time */
                            throw new Error("Character at position " + i.toString(10) + " of string '" + text + "' exceeds 16bits. Cannot be encoded into UCS-2 BE");
                        }
                        newtext.push(bch);
                        newtext.push(ch - (bch << 8));
                    }
                    return String.fromCharCode.apply(undef, newtext);
                }
            },
            // Replace '/', '(', and ')' with pdf-safe versions
            pdfEscape = function (text, flags) {
                // doing to8bitStream does NOT make this PDF display unicode text. For that
                // we also need to reference a unicode font and embed it - royal pain in the rear.

                // There is still a benefit to to8bitStream - PDF simply cannot handle 16bit chars,
                // which JavaScript Strings are happy to provide. So, while we still cannot display
                // 2-byte characters property, at least CONDITIONALLY converting (entire string containing)
                // 16bit chars to (USC-2-BE) 2-bytes per char + BOM streams we ensure that entire PDF
                // is still parseable.
                // This will allow immediate support for unicode in document properties strings.
                return to8bitStream(text, flags).replace(/\\/g, '\\\\').replace(/\(/g, '\\(').replace(/\)/g, '\\)');
            },
            putInfo = function () {
                out('/Producer (pdfDataExport ' + version + ')');
                if (documentProperties.title) {
                    out('/Title (' + pdfEscape(documentProperties.title) + ')');
                }
                if (documentProperties.subject) {
                    out('/Subject (' + pdfEscape(documentProperties.subject) + ')');
                }
                if (documentProperties.author) {
                    out('/Author (' + pdfEscape(documentProperties.author) + ')');
                }
                if (documentProperties.keywords) {
                    out('/Keywords (' + pdfEscape(documentProperties.keywords) + ')');
                }
                if (documentProperties.creator) {
                    out('/Creator (' + pdfEscape(documentProperties.creator) + ')');
                }
                var created = new Date();
                out('/CreationDate (D:' +
                    [
                        created.getFullYear(),
                        padd2(created.getMonth() + 1),
                        padd2(created.getDate()),
                        padd2(created.getHours()),
                        padd2(created.getMinutes()),
                        padd2(created.getSeconds())
                    ].join('') +
                    ')'
                    );
            },
            putCatalog = function () {
                out('/Type /Catalog');
                out('/Pages 1 0 R');
                // @TODO: Add zoom and layout modes
                out('/OpenAction [3 0 R /FitH null]');
                out('/PageLayout /OneColumn');
                events.publish('putCatalog');
            },
            putTrailer = function () {
                out('/Size ' + (objectNumber + 1));
                out('/Root ' + objectNumber + ' 0 R');
                out('/Info ' + (objectNumber - 1) + ' 0 R');
            },
            beginPage = function () {
                page++;
                // Do dimension stuff
                outToPages = true;
                pages[page] = [];
            },
            _addPage = function () {
                beginPage();
                // Set line width
                out(f2(lineWidth * k) + ' w');
                // Set draw color
                out(drawColor);
                // resurrecting non-default line caps, joins
                if (lineCapID !== 0) {
                    out(lineCapID.toString(10) + ' J');
                }
                if (lineJoinID !== 0) {
                    out(lineJoinID.toString(10) + ' j');
                }
                events.publish('addPage', { 'pageNumber': page });
            },
            /**
            Returns a document-specific font key - a label assigned to a
            font name + font type combination at the time the font was added
            to the font inventory.

            Font key is used as label for the desired font for a block of text
            to be added to the PDF document stream.
            @private
            @function
            @param fontName {String} can be undefined on "falthy" to indicate "use current"
            @param fontStyle {String} can be undefined on "falthy" to indicate "use current"
            @returns {String} Font key.
            */
            getFont = function (fontName, fontStyle) {
                var key, undef;

                if (fontName === undef) {
                    fontName = fonts[activeFontKey].fontName;
                }
                if (fontStyle === undef) {
                    fontStyle = fonts[activeFontKey].fontStyle;
                }

                try {
                    key = fontmap[fontName][fontStyle]; // returns a string like 'F3' - the KEY corresponding tot he font + type combination.
                } catch (e) {
                    key = undef;
                }
                if (!key) {
                    throw new Error("Unable to look up font label for font '" + fontName + "', '" + fontStyle + "'. Refer to getFontList() for available fonts.");
                }

                return key;
            },
            buildDocument = function () {

                outToPages = false; // switches out() to content
                content = [];
                offsets = [];

                // putHeader()
                out('%PDF-' + pdfVersion);

                putPages();

                putResources();

                // Info
                newObject();
                out('<<');
                putInfo();
                out('>>');
                out('endobj');

                // Catalog
                newObject();
                out('<<');
                putCatalog();
                out('>>');
                out('endobj');

                // Cross-ref
                var o = content_length, i;
                out('xref');
                out('0 ' + (objectNumber + 1));
                out('0000000000 65535 f ');
                for (i = 1; i <= objectNumber; i++) {
                    out(padd10(offsets[i]) + ' 00000 n ');
                }
                // Trailer
                out('trailer');
                out('<<');
                putTrailer();
                out('>>');
                out('startxref');
                out(o);
                out('%%EOF');

                outToPages = true;

                return content.join('\n');
            },
            getStyle = function (style) {
                // see Path-Painting Operators of PDF spec
                var op = 'S'; // stroke
                if (style === 'F') {
                    op = 'f'; // fill
                } else if (style === 'FD' || style === 'DF') {
                    op = 'B'; // both
                }
                return op;
            },

            /**
            Generates the PDF document.
            Possible values:
                datauristring (alias dataurlstring) - Data-Url-formatted data returned as string.
                datauri (alias datauri) - Data-Url-formatted data pushed into current window's location (effectively reloading the window with contents of the PDF).

            If `type` argument is undefined, output is raw body of resulting PDF returned as a string.

            @param {String} type A string identifying one of the possible output types.
            @param {Object} options An object providing some additional signalling to PDF generator.
            @function
            @returns {pdfDataExport}
            @methodOf pdfDataExport#
            @name output
            */
            output = function (type, options) {
                var undef, data, length, array, i, blob;
                switch (type) {
                    case undef:
                        return buildDocument();
                    case 'save':
                        if (navigator.getUserMedia) {
                            if (window.URL === undefined) {
                                return API.output('dataurlnewwindow');
                            } else if (window.URL.createObjectURL === undefined) {
                                return API.output('dataurlnewwindow');
                            }
                        }
                        data = buildDocument();

                        // Need to add the file to BlobBuilder as a Uint8Array
                        length = data.length;
                        array = new Uint8Array(new ArrayBuffer(length));

                        for (i = 0; i < length; i++) {
                            array[i] = data.charCodeAt(i);
                        }

                        blob = new Blob([array], { type: "application/pdf" });

                        saveAs(blob, options);
                        break;
                    case 'datauristring':
                    case 'dataurlstring':
                        return 'data:application/pdf;base64,' + btoa(buildDocument());
                    case 'datauri':
                    case 'dataurl':
                        document.location.href = 'data:application/pdf;base64,' + btoa(buildDocument());
                        break;
                    case 'dataurlnewwindow':
                        window.open('data:application/pdf;base64,' + btoa(buildDocument()));
                        break;
                    default:
                        throw new Error('Output type "' + type + '" is not supported.');
                }
                // @TODO: Add different output options
            };

        if (unit === 'pt') {
            k = 1;
        } else if (unit === 'mm') {
            k = 72 / 25.4;
        } else if (unit === 'cm') {
            k = 72 / 2.54;
        } else if (unit === 'in') {
            k = 72;
        } else {
            throw ('Invalid unit: ' + unit);
        }

        // Dimensions are stored as user units and converted to points on output
        if (pageFormats.hasOwnProperty(format_as_string)) {
            pageHeight = pageFormats[format_as_string][1] / k;
            pageWidth = pageFormats[format_as_string][0] / k;
        } else {
            try {
                pageHeight = format[1];
                pageWidth = format[0];
            } catch (err) {
                throw ('Invalid format: ' + format);
            }
        }

        if (orientation === 'p' || orientation === 'portrait') {
            orientation = 'p';
            if (pageWidth > pageHeight) {
                tmp = pageWidth;
                pageWidth = pageHeight;
                pageHeight = tmp;
            }
        } else if (orientation === 'l' || orientation === 'landscape') {
            orientation = 'l';
            if (pageHeight > pageWidth) {
                tmp = pageWidth;
                pageWidth = pageHeight;
                pageHeight = tmp;
            }
        } else {
            throw ('Invalid orientation: ' + orientation);
        }



        //---------------------------------------
        // Public API

        /*
        Object exposing internal API to plugins
        @public
        */
        API.internal = {
            'pdfEscape': pdfEscape,
            'getStyle': getStyle,
            /**
            Returns {FontObject} describing a particular font.
            @public
            @function
            @param fontName {String} (Optional) Font's family name
            @param fontStyle {String} (Optional) Font's style variation name (Example:"Italic")
            @returns {FontObject}
            */
            'getFont': function () { return fonts[getFont.apply(API, arguments)]; },
            'getFontSize': function () { return activeFontSize; },
            'btoa': btoa,
            'write': function (string1, string2, string3, etc) {
                out(
                    arguments.length === 1 ? string1 : Array.prototype.join.call(arguments, ' ')
                );
            },
            'getCoordinateString': function (value) {
                return f2(value * k);
            },
            'getVerticalCoordinateString': function (value) {
                return f2((pageHeight - value) * k);
            },
            'collections': {},
            'newObject': newObject,
            'putStream': putStream,
            'events': events,
            // ratio that you use in multiplication of a given "size" number to arrive to 'point'
            // units of measurement.
            // scaleFactor is set at initialization of the document and calculated against the stated
            // default measurement units for the document.
            // If default is "mm", k is the number that will turn number in 'mm' into 'points' number.
            // through multiplication.
            'scaleFactor': k,
            'pageSize': { 'width': pageWidth, 'height': pageHeight },
            'output': function (type, options) {
                return output(type, options);
            }
        };

        /**
        Adds (and transfers the focus to) new page to the PDF document.
        @function
        @returns {pdfDataExport}

        @methodOf pdfDataExport#
        @name addPage
         */
        API.addPage = function () {
            _addPage();
            return this;
        };

        var padz =
[
   "",
   "0",
   "00",
   "000",
   "0000"
];
        var pdfEscape16 = function (text, flags) {
            var ar = ["FEFF"];
            for (var i = 0, l = text.length, t; i < l; ++i) {
                t = text.charCodeAt(i).toString(16).toUpperCase();
                ar.push(padz[4 - t.length], t);
            }
            return ar.join("");
        };

        API.text16 = function (text, x, y, flags) {
            /**
            * Inserts something like this into PDF
            BT
            /F1 16 Tf % Font name + size
            16 TL % How many units down for next line in multiline text
            0 g % color
            28.35 813.54 Td % position
            (line one) Tj
            T* (line two) Tj
            T* (line three) Tj
            ET
            */

            var undef, _first, _second, _third, newtext, str, i;
            // Pre-August-2012 the order of arguments was function(x, y, text, flags)
            // in effort to make all calls have similar signature like
            // function(data, coordinates... , miscellaneous)
            // this method had its args flipped.
            // code below allows backward compatibility with old arg order.
            if (typeof text === 'number') {
                _first = y;
                _second = text;
                _third = x;

                text = _first;
                x = _second;
                y = _third;
            }

            // If there are any newlines in text, we assume
            // the user wanted to print multiple lines, so break the
            // text up into an array. If the text is already an array,
            // we assume the user knows what they are doing.
            if (typeof text === 'string' && text.match(/[\n\r]/)) {
                text = text.split(/\r\n|\r|\n/g);
            }

            if (typeof flags === 'undefined') {
                flags = { 'noBOM': true, 'autoencode': true };
            } else {

                if (flags.noBOM === undef) {
                    flags.noBOM = true;
                }

                if (flags.autoencode === undef) {
                    flags.autoencode = true;
                }

            }
            flags.autoencode = false;
            if (typeof text === 'string') {
                str = pdfEscape16(text, flags);
            } else if (text instanceof Array) { /* Array */
                // we don't want to destroy original text array, so cloning it
                newtext = text.concat();
                // we do array.join('text that must not be PDFescaped")
                // thus, pdfEscape each component separately
                for (i = newtext.length - 1; i !== -1; i--) {
                    newtext[i] = pdfEscape16(newtext[i], flags);
                }
                str = newtext.join("> Tj\nT* <");
            } else {
                throw new Error('Type of text must be string or Array. "' + text + '" is not recognized.');
            }
            // Using "'" ("go next line and render text" mark) would save space but would complicate our rendering code, templates

            // BT .. ET does NOT have default settings for Tf. You must state that explicitely every time for BT .. ET
            // if you want text transformation matrix (+ multiline) to work reliably (which reads sizes of things from font declarations)
            // Thus, there is NO useful, *reliable* concept of "default" font for a page.
            // The fact that "default" (reuse font used before) font worked before in basic cases is an accident
            // - readers dealing smartly with brokenness of jsPDF's markup.
            out(
                'BT\n/' +
                    activeFontKey + ' ' + activeFontSize + ' Tf\n' + // font face, style, size
                      activeFontSize + ' TL\n' + // line spacing
                     textColor +
                    '\n' + f2(x * k) + ' ' + f2((pageHeight - y) * k) + ' Td\n<' +
                    str +
                    '> Tj\nET'
            );

            return this;
        };
        /**
        Adds text to page. Supports adding multiline text when 'text' argument is an Array of Strings.
        @function
        @param {String|Array} text String or array of strings to be added to the page. Each line is shifted one line down per font, spacing settings declared before this call.
        @param {Number} x Coordinate (in units declared at inception of PDF document) against left edge of the page
        @param {Number} y Coordinate (in units declared at inception of PDF document) against upper edge of the page
        @param {Object} flags Collection of settings signalling how the text must be encoded. Defaults are sane. If you think you want to pass some flags, you likely can read the source.
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name text
         */
        API.text = function (text, x, y, flags) {
            /**
             * Inserts something like this into PDF
                BT
                /F1 16 Tf  % Font name + size
                16 TL % How many units down for next line in multiline text
                0 g % color
                28.35 813.54 Td % position
                (line one) Tj
                T* (line two) Tj
                T* (line three) Tj
                ET
            */

            var undef, _first, _second, _third, newtext, str, i;
            if (typeof text === 'number') {
                _first = y;
                _second = text;
                _third = x;

                text = _first;
                x = _second;
                y = _third;
            }

            if (typeof text === 'string' && text.match(/[\n\r]/)) {
                text = text.split(/\r\n|\r|\n/g);
            }

            if (typeof flags === 'undefined') {
                flags = { 'noBOM': true, 'autoencode': true };
            } else {

                if (flags.noBOM === undef) {
                    flags.noBOM = true;
                }

                if (flags.autoencode === undef) {
                    flags.autoencode = true;
                }

            }

            if (typeof text === 'string') {
                str = pdfEscape(text, flags);
            } else if (text instanceof Array) {  /* Array */
                // we don't want to destroy  original text array, so cloning it
                newtext = text.concat();
                // we do array.join('text that must not be PDFescaped")
                // thus, pdfEscape each component separately
                for (i = newtext.length - 1; i !== -1; i--) {
                    newtext[i] = pdfEscape(newtext[i], flags);
                }
                str = newtext.join(") Tj\nT* (");
            } else {
                throw new Error('Type of text must be string or Array. "' + text + '" is not recognized.');
            }
            out(
             'BT\n/' +
                 activeFontKey + ' ' + activeFontSize + ' Tf\n' + // font face, style, size
                 activeFontSize + ' TL\n' + // line spacing
                 textColor +
                 '\n' + f2(x * k) + ' ' + f2((pageHeight - y) * k) + ' Td\n(' +
                 str +
                 ') Tj\nET'
         );
            return this;
        };

        API.line = function (x1, y1, x2, y2) {
            out(
                f2(x1 * k) + ' ' + f2((pageHeight - y1) * k) + ' m ' +
                    f2(x2 * k) + ' ' + f2((pageHeight - y2) * k) + ' l S'
            );
            return this;
        };

        /**
        Adds series of curves (straight lines or cubic bezier curves) to canvas, starting at `x`, `y` coordinates.
        All data points in `lines` are relative to last line origin.
        `x`, `y` become x1,y1 for first line / curve in the set.
        For lines you only need to specify [x2, y2] - (ending point) vector against x1, y1 starting point.
        For bezier curves you need to specify [x2,y2,x3,y3,x4,y4] - vectors to control points 1, 2, ending point. All vectors are against the start of the curve - x1,y1.

        @example .lines([[2,2],[-2,2],[1,1,2,2,3,3],[2,1]], 212,110, 10) // line, line, bezier curve, line
        @param {Array} lines Array of *vector* shifts as pairs (lines) or sextets (cubic bezier curves).
        @param {Number} x Coordinate (in units declared at inception of PDF document) against left edge of the page
        @param {Number} y Coordinate (in units declared at inception of PDF document) against upper edge of the page
        @param {Number} scale (Defaults to [1.0,1.0]) x,y Scaling factor for all vectors. Elements can be any floating number Sub-one makes drawing smaller. Over-one grows the drawing. Negative flips the direction.
        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name lines
         */
        API.lines = function (lines, x, y, scale, style) {
            var undef, _first, _second, _third, scalex, scaley, i, l, leg, x2, y2, x3, y3, x4, y4;

            // Pre-August-2012 the order of arguments was function(x, y, lines, scale, style)
            // in effort to make all calls have similar signature like
            //   function(content, coordinateX, coordinateY , miscellaneous)
            // this method had its args flipped.
            // code below allows backward compatibility with old arg order.
            if (typeof lines === 'number') {
                _first = y;
                _second = lines;
                _third = x;

                lines = _first;
                x = _second;
                y = _third;
            }

            style = getStyle(style);
            scale = scale === undef ? [1, 1] : scale;

            // starting point
            out(f3(x * k) + ' ' + f3((pageHeight - y) * k) + ' m ');

            scalex = scale[0];
            scaley = scale[1];
            l = lines.length;
            //, x2, y2 // bezier only. In page default measurement "units", *after* scaling
            //, x3, y3 // bezier only. In page default measurement "units", *after* scaling
            // ending point for all, lines and bezier. . In page default measurement "units", *after* scaling
            x4 = x; // last / ending point = starting point for first item.
            y4 = y; // last / ending point = starting point for first item.

            for (i = 0; i < l; i++) {
                leg = lines[i];
                if (leg.length === 2) {
                    // simple line
                    x4 = leg[0] * scalex + x4; // here last x4 was prior ending point
                    y4 = leg[1] * scaley + y4; // here last y4 was prior ending point
                    out(f3(x4 * k) + ' ' + f3((pageHeight - y4) * k) + ' l');
                } else {
                    // bezier curve
                    x2 = leg[0] * scalex + x4; // here last x4 is prior ending point
                    y2 = leg[1] * scaley + y4; // here last y4 is prior ending point
                    x3 = leg[2] * scalex + x4; // here last x4 is prior ending point
                    y3 = leg[3] * scaley + y4; // here last y4 is prior ending point
                    x4 = leg[4] * scalex + x4; // here last x4 was prior ending point
                    y4 = leg[5] * scaley + y4; // here last y4 was prior ending point
                    out(
                        f3(x2 * k) + ' ' +
                            f3((pageHeight - y2) * k) + ' ' +
                            f3(x3 * k) + ' ' +
                            f3((pageHeight - y3) * k) + ' ' +
                            f3(x4 * k) + ' ' +
                            f3((pageHeight - y4) * k) + ' c'
                    );
                }
            }
            // stroking / filling / both the path
            out(style);
            return this;
        };

        /**
        Adds a rectangle to PDF

        @param {Number} x Coordinate (in units declared at inception of PDF document) against left edge of the page
        @param {Number} y Coordinate (in units declared at inception of PDF document) against upper edge of the page
        @param {Number} w Width (in units declared at inception of PDF document)
        @param {Number} h Height (in units declared at inception of PDF document)
        @param {String} style (Defaults to active fill/stroke style) A string signalling if stroke, fill or both are to be applied.
        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name rect
         */
        API.rect = function (x, y, w, h, style) {
            var op = getStyle(style);
            out([
                f2(x * k),
                f2((pageHeight - y) * k),
                f2(w * k),
                f2(-h * k),
                're',
                op
            ].join(' '));
            return this;
        };

        /**
        Adds a triangle to PDF

        @param {Number} x1 Coordinate (in units declared at inception of PDF document) against left edge of the page
        @param {Number} y1 Coordinate (in units declared at inception of PDF document) against upper edge of the page
        @param {Number} x2 Coordinate (in units declared at inception of PDF document) against left edge of the page
        @param {Number} y2 Coordinate (in units declared at inception of PDF document) against upper edge of the page
        @param {Number} x3 Coordinate (in units declared at inception of PDF document) against left edge of the page
        @param {Number} y3 Coordinate (in units declared at inception of PDF document) against upper edge of the page
        @param {String} style (Defaults to active fill/stroke style) A string signalling if stroke, fill or both are to be applied.
        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name triangle
         */
        API.triangle = function (x1, y1, x2, y2, x3, y3, style) {
            this.lines(
                [
                    [x2 - x1, y2 - y1], // vector to point 2
                    [x3 - x2, y3 - y2], // vector to point 3
                    [x1 - x3, y1 - y3] // closing vector back to point 1
                ],
                x1,
                y1, // start of path
                [1, 1],
                style
            );
            return this;
        };

        /**
        Adds a rectangle with rounded corners to PDF

        @param {Number} x Coordinate (in units declared at inception of PDF document) against left edge of the page
        @param {Number} y Coordinate (in units declared at inception of PDF document) against upper edge of the page
        @param {Number} w Width (in units declared at inception of PDF document)
        @param {Number} h Height (in units declared at inception of PDF document)
        @param {Number} rx Radius along x axis (in units declared at inception of PDF document)
        @param {Number} rx Radius along y axis (in units declared at inception of PDF document)
        @param {String} style (Defaults to active fill/stroke style) A string signalling if stroke, fill or both are to be applied.
        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name roundedRect
        */
        API.roundedRect = function (x, y, w, h, rx, ry, style) {
            var MyArc = 4 / 3 * (Math.SQRT2 - 1);
            this.lines(
                [
                    [(w - 2 * rx), 0],
                    [(rx * MyArc), 0, rx, ry - (ry * MyArc), rx, ry],
                    [0, (h - 2 * ry)],
                    [0, (ry * MyArc), -(rx * MyArc), ry, -rx, ry],
                    [(-w + 2 * rx), 0],
                    [-(rx * MyArc), 0, -rx, -(ry * MyArc), -rx, -ry],
                    [0, (-h + 2 * ry)],
                    [0, -(ry * MyArc), (rx * MyArc), -ry, rx, -ry]
                ],
                x + rx,
                y, // start of path
                [1, 1],
                style
            );
            return this;
        };

        /**
        Adds an ellipse to PDF

        @param {Number} x Coordinate (in units declared at inception of PDF document) against left edge of the page
        @param {Number} y Coordinate (in units declared at inception of PDF document) against upper edge of the page
        @param {Number} rx Radius along x axis (in units declared at inception of PDF document)
        @param {Number} rx Radius along y axis (in units declared at inception of PDF document)
        @param {String} style (Defaults to active fill/stroke style) A string signalling if stroke, fill or both are to be applied.
        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name ellipse
         */
        API.ellipse = function (x, y, rx, ry, style) {
            var op = getStyle(style),
                lx = 4 / 3 * (Math.SQRT2 - 1) * rx,
                ly = 4 / 3 * (Math.SQRT2 - 1) * ry;

            out([
                f2((x + rx) * k),
                f2((pageHeight - y) * k),
                'm',
                f2((x + rx) * k),
                f2((pageHeight - (y - ly)) * k),
                f2((x + lx) * k),
                f2((pageHeight - (y - ry)) * k),
                f2(x * k),
                f2((pageHeight - (y - ry)) * k),
                'c'
            ].join(' '));
            out([
                f2((x - lx) * k),
                f2((pageHeight - (y - ry)) * k),
                f2((x - rx) * k),
                f2((pageHeight - (y - ly)) * k),
                f2((x - rx) * k),
                f2((pageHeight - y) * k),
                'c'
            ].join(' '));
            out([
                f2((x - rx) * k),
                f2((pageHeight - (y + ly)) * k),
                f2((x - lx) * k),
                f2((pageHeight - (y + ry)) * k),
                f2(x * k),
                f2((pageHeight - (y + ry)) * k),
                'c'
            ].join(' '));
            out([
                f2((x + lx) * k),
                f2((pageHeight - (y + ry)) * k),
                f2((x + rx) * k),
                f2((pageHeight - (y + ly)) * k),
                f2((x + rx) * k),
                f2((pageHeight - y) * k),
                'c',
                op
            ].join(' '));
            return this;
        };

        /**
        Adds an circle to PDF

        @param {Number} x Coordinate (in units declared at inception of PDF document) against left edge of the page
        @param {Number} y Coordinate (in units declared at inception of PDF document) against upper edge of the page
        @param {Number} r Radius (in units declared at inception of PDF document)
        @param {String} style (Defaults to active fill/stroke style) A string signalling if stroke, fill or both are to be applied.
        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name circle
         */
        API.circle = function (x, y, r, style) {
            return this.ellipse(x, y, r, r, style);
        };

        /**
        Adds a properties to the PDF document

        @param {Object} A property_name-to-property_value object structure.
        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name setProperties
         */
        API.setProperties = function (properties) {
            // copying only those properties we can render.
            var property;
            for (property in documentProperties) {
                if (documentProperties.hasOwnProperty(property) && properties[property]) {
                    documentProperties[property] = properties[property];
                }
            }
            return this;
        };

        /**
        Sets font size for upcoming text elements.

        @param {Number} size Font size in points.
        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name setFontSize
         */
        API.setFontSize = function (size) {
            activeFontSize = size;
            return this;
        };

        /**
        Sets text font face, variant for upcoming text elements.
        See output of pdfDataExport.getFontList() for possible font names, styles.

        @param {String} fontName Font name or family. Example: "times"
        @param {String} fontStyle Font style or variant. Example: "italic"
        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name setFont
         */
        API.setFont = function (fontName, fontStyle) {
            activeFontKey = getFont(fontName, fontStyle);
            // if font is not found, the above line blows up and we never go further
            return this;
        };

        /**
        Switches font style or variant for upcoming text elements,
        while keeping the font face or family same.
        See output of pdfDataExport.getFontList() for possible font names, styles.

        @param {String} style Font style or variant. Example: "italic"
        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name setFontStyle
         */
        API.setFontStyle = API.setFontType = function (style) {
            var undef;
            activeFontKey = getFont(undef, style);
            // if font is not found, the above line blows up and we never go further
            return this;
        };

        /**
        Returns an object - a tree of fontName to fontStyle relationships available to
        active PDF document.

        @public
        @function
        @returns {Object} Like {'times':['normal', 'italic', ... ], 'arial':['normal', 'bold', ... ], ... }
        @methodOf pdfDataExport#
        @name getFontList
        */
        API.getFontList = function () {
            // TODO: iterate over fonts array or return copy of fontmap instead in case more are ever added.
            var list = {},
                fontName,
                fontStyle,
                tmp;

            for (fontName in fontmap) {
                if (fontmap.hasOwnProperty(fontName)) {
                    list[fontName] = tmp = [];
                    for (fontStyle in fontmap[fontName]) {
                        if (fontmap[fontName].hasOwnProperty(fontStyle)) {
                            tmp.push(fontStyle);
                        }
                    }
                }
            }

            return list;
        };

        /**
        Sets line width for upcoming lines.

        @param {Number} width Line width (in units declared at inception of PDF document)
        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name setLineWidth
         */
        API.setLineWidth = function (width) {
            out((width * k).toFixed(2) + ' w');
            return this;
        };

        /**
        Sets the stroke color for upcoming elements.

        Depending on the number of arguments given, Gray, RGB, or CMYK
        color space is implied.

        When only ch1 is given, "Gray" color space is implied and it
        must be a value in the range from 0.00 (solid black) to to 1.00 (white)
        if values are communicated as String types, or in range from 0 (black)
        to 255 (white) if communicated as Number type.
        The RGB-like 0-255 range is provided for backward compatibility.

        When only ch1,ch2,ch3 are given, "RGB" color space is implied and each
        value must be in the range from 0.00 (minimum intensity) to to 1.00
        (max intensity) if values are communicated as String types, or
        from 0 (min intensity) to to 255 (max intensity) if values are communicated
        as Number types.
        The RGB-like 0-255 range is provided for backward compatibility.

        When ch1,ch2,ch3,ch4 are given, "CMYK" color space is implied and each
        value must be a in the range from 0.00 (0% concentration) to to
        1.00 (100% concentration)

        Because JavaScript treats fixed point numbers badly (rounds to
        floating point nearest to binary representation) it is highly advised to
        communicate the fractional numbers as String types, not JavaScript Number type.

        @param {Number|String} ch1 Color channel value
        @param {Number|String} ch2 Color channel value
        @param {Number|String} ch3 Color channel value
        @param {Number|String} ch4 Color channel value

        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name setDrawColor
         */
        API.setDrawColor = function (ch1, ch2, ch3, ch4) {
            var color;
            if (ch2 === undefined || (ch4 === undefined && ch1 === ch2 === ch3)) {
                // Gray color space.
                if (typeof ch1 === 'string') {
                    color = ch1 + ' G';
                } else {
                    color = f2(ch1 / 255) + ' G';
                }
            } else if (ch4 === undefined) {
                // RGB
                if (typeof ch1 === 'string') {
                    color = [ch1, ch2, ch3, 'RG'].join(' ');
                } else {
                    color = [f2(ch1 / 255), f2(ch2 / 255), f2(ch3 / 255), 'RG'].join(' ');
                }
            } else {
                // CMYK
                if (typeof ch1 === 'string') {
                    color = [ch1, ch2, ch3, ch4, 'K'].join(' ');
                } else {
                    color = [f2(ch1), f2(ch2), f2(ch3), f2(ch4), 'K'].join(' ');
                }
            }

            out(color);
            return this;
        };

        /**
        Sets the fill color for upcoming elements.

        Depending on the number of arguments given, Gray, RGB, or CMYK
        color space is implied.

        When only ch1 is given, "Gray" color space is implied and it
        must be a value in the range from 0.00 (solid black) to to 1.00 (white)
        if values are communicated as String types, or in range from 0 (black)
        to 255 (white) if communicated as Number type.
        The RGB-like 0-255 range is provided for backward compatibility.

        When only ch1,ch2,ch3 are given, "RGB" color space is implied and each
        value must be in the range from 0.00 (minimum intensity) to to 1.00
        (max intensity) if values are communicated as String types, or
        from 0 (min intensity) to to 255 (max intensity) if values are communicated
        as Number types.
        The RGB-like 0-255 range is provided for backward compatibility.

        When ch1,ch2,ch3,ch4 are given, "CMYK" color space is implied and each
        value must be a in the range from 0.00 (0% concentration) to to
        1.00 (100% concentration)

        Because JavaScript treats fixed point numbers badly (rounds to
        floating point nearest to binary representation) it is highly advised to
        communicate the fractional numbers as String types, not JavaScript Number type.

        @param {Number|String} ch1 Color channel value
        @param {Number|String} ch2 Color channel value
        @param {Number|String} ch3 Color channel value
        @param {Number|String} ch4 Color channel value

        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name setFillColor
         */
        API.setFillColor = function (ch1, ch2, ch3, ch4) {
            var color;

            if (ch2 === undefined || (ch4 === undefined && ch1 === ch2 === ch3)) {
                // Gray color space.
                if (typeof ch1 === 'string') {
                    color = ch1 + ' g';
                } else {
                    color = f2(ch1 / 255) + ' g';
                }
            } else if (ch4 === undefined) {
                // RGB
                if (typeof ch1 === 'string') {
                    color = [ch1, ch2, ch3, 'rg'].join(' ');
                } else {
                    color = [f2(ch1 / 255), f2(ch2 / 255), f2(ch3 / 255), 'rg'].join(' ');
                }
            } else {
                // CMYK
                if (typeof ch1 === 'string') {
                    color = [ch1, ch2, ch3, ch4, 'k'].join(' ');
                } else {
                    color = [f2(ch1), f2(ch2), f2(ch3), f2(ch4), 'k'].join(' ');
                }
            }

            out(color);
            return this;
        };

        /**
        Sets the text color for upcoming elements.
        If only one, first argument is given,
        treats the value as gray-scale color value.

        @param {Number} r Red channel color value in range 0-255
        @param {Number} g Green channel color value in range 0-255
        @param {Number} b Blue channel color value in range 0-255
        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name setTextColor
        */
        API.setTextColor = function (r, g, b) {
            if ((r === 0 && g === 0 && b === 0) || (typeof g === 'undefined')) {
                textColor = f3(r / 255) + ' g';
            } else {
                textColor = [f3(r / 255), f3(g / 255), f3(b / 255), 'rg'].join(' ');
            }
            return this;
        };

        /**
        Is an Object providing a mapping from human-readable to
        integer flag values designating the varieties of line cap
        and join styles.

        @returns {Object}
        @fieldOf pdfDataExport#
        @name CapJoinStyles
        */
        API.CapJoinStyles = {
            0: 0,
            'butt': 0,
            'but': 0,
            'bevel': 0,
            1: 1,
            'round': 1,
            'rounded': 1,
            'circle': 1,
            2: 2,
            'projecting': 2,
            'project': 2,
            'square': 2,
            'milter': 2
        };

        /**
        Sets the line cap styles
        See {pdfDataExport.CapJoinStyles} for variants

        @param {String|Number} style A string or number identifying the type of line cap
        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name setLineCap
        */
        API.setLineCap = function (style) {
            var id = this.CapJoinStyles[style];
            if (id === undefined) {
                throw new Error("Line cap style of '" + style + "' is not recognized. See or extend .CapJoinStyles property for valid styles");
            }
            lineCapID = id;
            out(id.toString(10) + ' J');

            return this;
        };

        /**
        Sets the line join styles
        See {pdfDataExport.CapJoinStyles} for variants

        @param {String|Number} style A string or number identifying the type of line join
        @function
        @returns {pdfDataExport}
        @methodOf pdfDataExport#
        @name setLineJoin
        */
        API.setLineJoin = function (style) {
            var id = this.CapJoinStyles[style];
            if (id === undefined) {
                throw new Error("Line join style of '" + style + "' is not recognized. See or extend .CapJoinStyles property for valid styles");
            }
            lineJoinID = id;
            out(id.toString(10) + ' j');

            return this;
        };

        // Output is both an internal (for plugins) and external function
        API.output = output;

        /**
         * Saves as PDF document. An alias of pdfDataExport.output('save', 'filename.pdf')
         * @param  {String} filename The filename including extension.
         *
         * @function
         * @returns {pdfDataExport}
         * @methodOf pdfDataExport#
         * @name save
         */
        API.save = function (filename) {
            API.output('save', filename);
        };

        // applying plugins (more methods) ON TOP of built-in API.
        // this is intentional as we allow plugins to override
        // built-ins
        for (plugin in pdfDataExport.API) {
            if (pdfDataExport.API.hasOwnProperty(plugin)) {
                if (plugin === 'events' && pdfDataExport.API.events.length) {
                    (function (events, newEvents) {

                        // pdfDataExport.API.events is a JS Array of Arrays
                        // where each Array is a pair of event name, handler
                        // Events were added by plugins to the pdfDataExport instantiator.
                        // These are always added to the new instance and some ran
                        // during instantiation.

                        var eventname, handler_and_args, i;

                        for (i = newEvents.length - 1; i !== -1; i--) {
                            // subscribe takes 3 args: 'topic', function, runonce_flag
                            // if undefined, runonce is false.
                            // users can attach callback directly,
                            // or they can attach an array with [callback, runonce_flag]
                            // that's what the "apply" magic is for below.
                            eventname = newEvents[i][0];
                            handler_and_args = newEvents[i][1];
                            events.subscribe.apply(
                                events,
                                [eventname].concat(
                                    typeof handler_and_args === 'function' ?
                                            [handler_and_args] :
                                            handler_and_args
                                )
                            );
                        }
                    }(events, pdfDataExport.API.events));
                } else {
                    API[plugin] = pdfDataExport.API[plugin];
                }
            }
        }

        /////////////////////////////////////////
        // continuing initilisation of pdfDataExport Document object
        /////////////////////////////////////////


        // Add the first page automatically
        addFonts();
        activeFontKey = 'F1';
        _addPage();

        events.publish('initialized');

        return API;
    }

    /**
    pdfDataExport.API is a STATIC property of pdfDataExport class.
    pdfDataExport.API is an object you can add methods and properties to.
    The methods / properties you add will show up in new pdfDataExport objects.
    
    One property is prepopulated. It is the 'events' Object. Plugin authors can add topics, callbacks to this object. These will be reassigned to all new instances of pdfDataExport.
    Examples:
        pdfDataExport.API.events['initialized'] = function(){ 'this' is API object }
        pdfDataExport.API.events['addFont'] = function(added_font_object){ 'this' is API object }
    
    @static
    @public
    @memberOf pdfDataExport
    @name API
    
    @example
        pdfDataExport.API.mymethod = function(){
            // 'this' will be ref to internal API object. see pdfDataExport source
            // , so you can refer to built-in methods like so:
            //     this.line(....)
            //     this.text(....)
        }
        var pdfdoc = new pdfDataExport()
        pdfdoc.mymethod() // <- !!!!!!
    */
    pdfDataExport.API = { 'events': [] };

    return pdfDataExport;
}());

(function (pdfDataExportAPI) {
    'use strict';
    /*jslint browser:true */
    /*global document: false, pdfDataExport */

    var maxLn = 0,
        lnP = 0,
        fontName,
        fontSize,
        fontStyle,
        lastCellPos = { x: undefined, y: undefined, w: undefined, h: undefined, ln: undefined },
        pages = 1,
        newPage = false,
        setLastCellPosition = function (x, y, w, h, ln) {
            lastCellPos = { x: x, y: y, w: w, h: h, ln: ln };
        },
        getLastCellPosition = function () {
            return lastCellPos;
        },
        setMaxLn = function (x) {
            maxLn = x;
        },
        getMaxLn = function () {
            return maxLn;
        },
        setLnP = function (x) {
            lnP = x;
        },
        getLnP = function (x) {
            return lnP;
        };

    pdfDataExportAPI.getTextDimensions = function (txt) {
        fontName = this.internal.getFont().fontName;
        fontSize = this.internal.getFontSize();
        fontStyle = this.internal.getFont().fontStyle;

        // 1 pixel = 0.264583 mm and 1 mm = 72/25.4 point
        var px2pt = 0.264583 * 72 / 25.4,
            dimensions,
            text;

        text = document.createElement('font');
        text.id = "pdfDataExportCell";
        text.style.fontStyle = fontStyle;
        text.style.fontName = fontName;
        text.style.fontSize = fontSize + 'pt';
        text.innerHTML = txt;

        document.body.appendChild(text);

        dimensions = { w: (text.offsetWidth + 1) * px2pt, h: (text.offsetHeight + 1) * px2pt };

        document.body.removeChild(text);

        return dimensions;
    };

    pdfDataExportAPI.cellAddPage = function () {
        this.addPage();
        setLastCellPosition(undefined, undefined, undefined, undefined, undefined);
        newPage = true;
        pages += 1;
        setLnP(1);
    };

    pdfDataExportAPI.cellInitialize = function () {
        maxLn = 0;
        lastCellPos = { x: undefined, y: undefined, w: undefined, h: undefined, ln: undefined };
        pages = 1;
        newPage = false;
        setLnP(0);
    };

    pdfDataExportAPI.cell = function (x, y, w, h, txt, ln) {
        this.lnMod = this.lnMod === undefined ? 0 : this.lnMod;
        if (this.printingHeaderRow !== true && this.lnMod !== 0) {
            ln = ln + this.lnMod;
        }

        if ((((ln * h) + y + (h * 2)) / pages) >= this.internal.pageSize.height && pages === 1 && !newPage) {
            this.cellAddPage();

            if (this.printHeaders && this.tableHeaderRow) {
                this.printHeaderRow(ln);
                this.lnMod += 1;
                ln += 1;
            }
            if (getMaxLn() === 0) {
                setMaxLn(Math.round((this.internal.pageSize.height - (h * 2)) / h));
            }
        } else if (newPage && getLastCellPosition().ln !== ln && getLnP() === getMaxLn()) {
            this.cellAddPage();

            if (this.printHeaders && this.tableHeaderRow) {
                this.printHeaderRow(ln);
                this.lnMod += 1;
                ln += 1;
            }
        }

        var curCell = getLastCellPosition(),
            dim = this.getTextDimensions(txt),
            isNewLn = 1;
        if (curCell.x !== undefined && curCell.ln === ln) {
            x = curCell.x + curCell.w;
        }
        if (curCell.y !== undefined && curCell.y === y) {
            y = curCell.y;
        }
        if (curCell.h !== undefined && curCell.h === h) {
            h = curCell.h;
        }
        if (curCell.ln !== undefined && curCell.ln === ln) {
            ln = curCell.ln;
            isNewLn = 0;
        }
        if (newPage) {
            y = h * (getLnP() + isNewLn);
        } else {
            y = (y + (h * Math.abs(getMaxLn() * pages - ln - getMaxLn())));
        }
        this.rect(x, y, w, h);
        var match = /[а-яА-ЯЁё]/.test(txt);
        if (match) {
            this.text16(txt, x + 3, y + h - 3);
        }
        else {
            this.text(txt, x + 3, y + h - 3);
        }
        setLnP(getLnP() + isNewLn);
        setLastCellPosition(x, y, w, h, ln);
        return this;
    };

    /**
     * Return an array containing all of the owned keys of an Object
     * @type {Function}
     * @return {String[]} of Object keys
     */
    pdfDataExportAPI.getKeys = (typeof Object.keys === 'function')
        ? function (object) {
            if (!object) {
                return [];
            }
            return Object.keys(object);
        }
            : function (object) {
                var keys = [],
                    property;

                for (property in object) {
                    if (object.hasOwnProperty(property)) {
                        keys.push(property);
                    }
                }

                return keys;
            };

    /**
     * Return the maximum value from an array
     * @param array
     * @param comparisonFn
     * @returns {*}
     */
    pdfDataExportAPI.arrayMax = function (array, comparisonFn) {
        var max = array[0],
            i,
            ln,
            item;

        for (i = 0, ln = array.length; i < ln; i += 1) {
            item = array[i];

            if (comparisonFn) {
                if (comparisonFn(max, item) === -1) {
                    max = item;
                }
            } else {
                if (item > max) {
                    max = item;
                }
            }
        }

        return max;
    };

    /**
     * Create a table from a set of data.
     * @param {Object[]} data As array of objects containing key-value pairs
     * @param {String[]} [headers] Omit or null to auto-generate headers at a performance cost
     * @param {Object} [config.printHeaders] True to print column headers at the top of every page
     * @param {Object} [config.autoSize] True to dynamically set the column widths to match the widest cell value
     * @param {Object} [config.autoStretch] True to force the table to fit the width of the page
     */
    pdfDataExportAPI.table = function (data, headers, config) {

        var headerNames = [],
            headerPrompts = [],
            header,
            autoSize,
            printHeaders,
            autoStretch,
            i,
            ln,
            columnMatrix = {},
            columnWidths = {},
            columnData,
            column,
            columnMinWidths = [],
            j,
            tableHeaderConfigs = [],
            model,
            jln,
            func;

        /**
         * @property {Number} lnMod
         * Keep track of the current line number modifier used when creating cells
         */
        this.lnMod = 0;

        if (config) {
            autoSize = config.autoSize || false;
            printHeaders = this.printHeaders = config.printHeaders || true;
            autoStretch = config.autoStretch || true;
        }

        if (!data) {
            throw 'No data for PDF table';
        }

        // Set headers
        if (headers === undefined || (headers === null)) {

            // No headers defined so we derive from data
            headerNames = this.getKeys(data[0]);

        } else if (headers[0] && (typeof headers[0] !== 'string')) {

            // Split header configs into names and prompts
            for (i = 0, ln = headers.length; i < ln; i += 1) {
                header = headers[i];
                headerNames.push(header.name);
                headerPrompts.push(header.prompt);
            }

        } else {
            headerNames = headers;
        }

        if (config.autoSize) {

            // Create Columns Matrix

            func = function (rec) {
                return rec[header];
            };

            for (i = 0, ln = headerNames.length; i < ln; i += 1) {
                header = headerNames[i];

                columnMatrix[header] = data.map(
                    func
                );

                // get header width
                columnMinWidths.push(this.getTextDimensions(headerPrompts[i] || header).w);

                column = columnMatrix[header];

                // get cell widths
                for (j = 0, ln = column.length; j < ln; j += 1) {
                    columnData = column[j];

                    columnMinWidths.push(this.getTextDimensions(columnData).w);
                }

                // get final column width
                columnWidths[header] = pdfDataExportAPI.arrayMax(columnMinWidths);
            }
        }

        // -- Construct the table

        if (config.printHeaders) {

            // Construct the header row
            for (i = 0, ln = headerNames.length; i < ln; i += 1) {
                header = headerNames[i];
                tableHeaderConfigs.push([10, 10, columnWidths[header], 25, String(headerPrompts.length ? headerPrompts[i] : header)]);
            }

            // Store the table header config
            this.setTableHeaderRow(tableHeaderConfigs);

            // Print the header for the start of the table
            this.printHeaderRow(1);
        }

        // Construct the data rows
        for (i = 0, ln = data.length; i < ln; i += 1) {
            model = data[i];

            for (j = 0, jln = headerNames.length; j < jln; j += 1) {
                header = headerNames[j];
                this.cell(10, 10, columnWidths[header], 25, String(model[header]), i + 2);
            }
        }

        return this;
    };

    /**
     * Store the config for outputting a table header
     * @param {Object[]} config
     * An array of cell configs that would define a header row: Each config matches the config used by pdfDataExportAPI.cell
     * except the ln parameter is excluded
     */
    pdfDataExportAPI.setTableHeaderRow = function (config) {
        this.tableHeaderRow = config;
    };

    /**
     * Output the store header row
     * @param lineNumber The line number to output the header at
     */
    pdfDataExportAPI.printHeaderRow = function (lineNumber) {
        if (!this.tableHeaderRow) {
            throw 'Property tableHeaderRow does not exist.';
        }

        var tableHeaderCell,
            tmpArray,
            i,
            ln;

        this.printingHeaderRow = true;

        for (i = 0, ln = this.tableHeaderRow.length; i < ln; i += 1) {

            tableHeaderCell = this.tableHeaderRow[i];
            tmpArray = [].concat(tableHeaderCell);

            this.cell.apply(this, tmpArray.concat(lineNumber));
        }

        this.printingHeaderRow = false;
    };

}(pdfDataExport.API));


; (function (API) {
    'use strict'

    /**
    Returns an array of length matching length of the 'word' string, with each
    cell ocupied by the width of the char in that position.
    
    @function
    @param word {String}
    @param widths {Object}
    @param kerning {Object}
    @returns {Array}
    */
    var getCharWidthsArray = API.getCharWidthsArray = function (text, options) {

        if (!options) {
            options = {}
        }

        var widths = options.widths ? options.widths : this.internal.getFont().metadata.Unicode.widths
        , widthsFractionOf = widths.fof ? widths.fof : 1
        , kerning = options.kerning ? options.kerning : this.internal.getFont().metadata.Unicode.kerning
        , kerningFractionOf = kerning.fof ? kerning.fof : 1

        // console.log("widths, kergnings", widths, kerning)

        var i, l
        , char_code
        , char_width
        , prior_char_code = 0 // for kerning
        , default_char_width = widths[0] || widthsFractionOf
        , output = []

        for (i = 0, l = text.length; i < l; i++) {
            char_code = text.charCodeAt(i)
            output.push(
                (widths[char_code] || default_char_width) / widthsFractionOf +
                (kerning[char_code] && kerning[char_code][prior_char_code] || 0) / kerningFractionOf
            )
            prior_char_code = char_code
        }

        return output
    }
    var getArraySum = function (array) {
        var i = array.length
        , output = 0
        while (i) {
            ; i--;
            output += array[i]
        }
        return output
    }
    /**
    Returns a widths of string in a given font, if the font size is set as 1 point.
    
    In other words, this is "proportional" value. For 1 unit of font size, the length
    of the string will be that much.
    
    Multiply by font size to get actual width in *points*
    Then divide by 72 to get inches or divide by (72/25.6) to get 'mm' etc.
    
    @public
    @function
    @param
    @returns {Type}
    */
    var getStringUnitWidth = API.getStringUnitWidth = function (text, options) {
        return getArraySum(getCharWidthsArray.call(this, text, options))
    }

    /** 
    returns array of lines
    */
    var splitLongWord = function (word, widths_array, firstLineMaxLen, maxLen) {
        var answer = []

        // 1st, chop off the piece that can fit on the hanging line.
        var i = 0
        , l = word.length
        , workingLen = 0
        while (i !== l && workingLen + widths_array[i] < firstLineMaxLen) {
            workingLen += widths_array[i]
            ; i++;
        }
        // this is first line.
        answer.push(word.slice(0, i))

        // 2nd. Split the rest into maxLen pieces.
        var startOfLine = i
        workingLen = 0
        while (i !== l) {
            if (workingLen + widths_array[i] > maxLen) {
                answer.push(word.slice(startOfLine, i))
                workingLen = 0
                startOfLine = i
            }
            workingLen += widths_array[i]
            ; i++;
        }
        if (startOfLine !== i) {
            answer.push(word.slice(startOfLine, i))
        }

        return answer
    }

    // Note, all sizing inputs for this function must be in "font measurement units"
    // By default, for PDF, it's "point".
    var splitParagraphIntoLines = function (text, maxlen, options) {
        // at this time works only on Western scripts, ones with space char
        // separating the words. Feel free to expand.

        if (!options) {
            options = {}
        }

        var spaceCharWidth = getCharWidthsArray(' ', options)[0]

        var words = text.split(' ')

        var line = []
        , lines = [line]
        , line_length = options.textIndent || 0
        , separator_length = 0
        , current_word_length = 0
        , word
        , widths_array

        var i, l, tmp
        for (i = 0, l = words.length; i < l; i++) {
            word = words[i]
            widths_array = getCharWidthsArray(word, options)
            current_word_length = getArraySum(widths_array)

            if (line_length + separator_length + current_word_length > maxlen) {
                if (current_word_length > maxlen) {
                    // this happens when you have space-less long URLs for example.
                    // we just chop these to size. We do NOT insert hiphens
                    tmp = splitLongWord(word, widths_array, maxlen - (line_length + separator_length), maxlen)
                    // first line we add to existing line object
                    line.push(tmp.shift()) // it's ok to have extra space indicator there
                    // last line we make into new line object
                    line = [tmp.pop()]
                    // lines in the middle we apped to lines object as whole lines
                    while (tmp.length) {
                        lines.push([tmp.shift()]) // single fragment occupies whole line
                    }
                    current_word_length = getArraySum(widths_array.slice(word.length - line[0].length))
                } else {
                    // just put it on a new line
                    line = [word]
                }

                // now we attach new line to lines
                lines.push(line)

                line_length = current_word_length
                separator_length = spaceCharWidth

            } else {
                line.push(word)

                line_length += separator_length + current_word_length
                separator_length = spaceCharWidth
            }
        }

        var output = []
        for (i = 0, l = lines.length; i < l; i++) {
            output.push(lines[i].join(' '))
        }
        return output

    }

    /**
    Splits a given string into an array of strings. Uses 'size' value
    (in measurement units declared as default for the pdfDataExport instance)
    and the font's "widths" and "Kerning" tables, where availabe, to
    determine display length of a given string for a given font.
    
    We use character's 100% of unit size (height) as width when Width
    table or other default width is not available.
    
    @public
    @function
    @param text {String} Unencoded, regular JavaScript (Unicode, UTF-16 / UCS-2) string.
    @param size {Number} Nominal number, measured in units default to this instance of pdfDataExport.
    @param options {Object} Optional flags needed for chopper to do the right thing.
    @returns {Array} with strings chopped to size.
    */
    API.splitTextToSize = function (text, maxlen, options) {
        'use strict'

        if (!options) {
            options = {}
        }

        var fsize = options.fontSize || this.internal.getFontSize()
        , newOptions = (function (options) {
            var widths = { 0: 1 }
            , kerning = {}

            if (!options.widths || !options.kerning) {
                var f = this.internal.getFont(options.fontName, options.fontStyle)
                , encoding = 'Unicode'
                // NOT UTF8, NOT UTF16BE/LE, NOT UCS2BE/LE
                // Actual JavaScript-native String's 16bit char codes used.
                // no multi-byte logic here

                if (f.metadata[encoding]) {
                    return {
                        widths: f.metadata[encoding].widths || widths
                        , kerning: f.metadata[encoding].kerning || kerning
                    }
                }
            } else {
                return {
                    widths: options.widths
                    , kerning: options.kerning
                }
            }

            // then use default values
            return {
                widths: widths
                , kerning: kerning
            }
        }).call(this, options)

        // first we split on end-of-line chars
        var paragraphs
        if (text.match(/[\n\r]/)) {
            paragraphs = text.split(/\r\n|\r|\n/g)
        } else {
            paragraphs = [text]
        }

        // now we convert size (max length of line) into "font size units"
        // at present time, the "font size unit" is always 'point'
        // 'proportional' means, "in proportion to font size"
        var fontUnit_maxLen = 1.0 * this.internal.scaleFactor * maxlen / fsize
        // at this time, fsize is always in "points" regardless of the default measurement unit of the doc.
        // this may change in the future?
        // until then, proportional_maxlen is likely to be in 'points'

        // If first line is to be indented (shorter or longer) than maxLen 
        // we indicate that by using CSS-style "text-indent" option.
        // here it's in font units too (which is likely 'points')
        // it can be negative (which makes the first line longer than maxLen)
        newOptions.textIndent = options.textIndent ?
            options.textIndent * 1.0 * this.internal.scaleFactor / fsize :
            0

        var i, l
        , output = []
        for (i = 0, l = paragraphs.length; i < l; i++) {
            output = output.concat(
                splitParagraphIntoLines(
                    paragraphs[i]
                    , fontUnit_maxLen
                    , newOptions
                )
            )
        }

        return output
    }

})(pdfDataExport.API);


; (function (pdfDataExportAPI) {
    'use strict'

    var namespace = 'addImage_'

    var getJpegSize = function (imgData) {
        'use strict'
        var width, height;
        // Verify we have a valid jpeg header 0xff,0xd8,0xff,0xe0,?,?,'J','F','I','F',0x00
        if (!imgData.charCodeAt(0) === 0xff ||
            !imgData.charCodeAt(1) === 0xd8 ||
            !imgData.charCodeAt(2) === 0xff ||
            !imgData.charCodeAt(3) === 0xe0 ||
            !imgData.charCodeAt(6) === 'J'.charCodeAt(0) ||
            !imgData.charCodeAt(7) === 'F'.charCodeAt(0) ||
            !imgData.charCodeAt(8) === 'I'.charCodeAt(0) ||
            !imgData.charCodeAt(9) === 'F'.charCodeAt(0) ||
            !imgData.charCodeAt(10) === 0x00) {
            throw new Error('getJpegSize requires a binary jpeg file')
        }
        var blockLength = imgData.charCodeAt(4) * 256 + imgData.charCodeAt(5);
        var i = 4, len = imgData.length;
        while (i < len) {
            i += blockLength;
            if (imgData.charCodeAt(i) !== 0xff) {
                throw new Error('getJpegSize could not find the size of the image');
            }
            if (imgData.charCodeAt(i + 1) === 0xc0) {
                height = imgData.charCodeAt(i + 5) * 256 + imgData.charCodeAt(i + 6);
                width = imgData.charCodeAt(i + 7) * 256 + imgData.charCodeAt(i + 8);
                return [width, height];
            } else {
                i += 2;
                blockLength = imgData.charCodeAt(i) * 256 + imgData.charCodeAt(i + 1)
            }
        }
    }
    // Image functionality ported from pdf.js
    , putImage = function (img) {
        var objectNumber = this.internal.newObject()
        , out = this.internal.write
        , putStream = this.internal.putStream

        img['n'] = objectNumber

        out('<</Type /XObject')
        out('/Subtype /Image')
        out('/Width ' + img['w'])
        out('/Height ' + img['h'])
        if (img['cs'] === 'Indexed') {
            out('/ColorSpace [/Indexed /DeviceRGB '
                    + (img['pal'].length / 3 - 1) + ' ' + (objectNumber + 1)
                    + ' 0 R]');
        } else {
            out('/ColorSpace /' + img['cs']);
            if (img['cs'] === 'DeviceCMYK') {
                out('/Decode [1 0 1 0 1 0 1 0]');
            }
        }
        out('/BitsPerComponent ' + img['bpc']);
        if ('f' in img) {
            out('/Filter /' + img['f']);
        }
        if ('dp' in img) {
            out('/DecodeParms <<' + img['dp'] + '>>');
        }
        if ('trns' in img && img['trns'].constructor == Array) {
            var trns = '';
            for (var i = 0; i < img['trns'].length; i++) {
                trns += (img[trns][i] + ' ' + img['trns'][i] + ' ');
                out('/Mask [' + trns + ']');
            }
        }
        if ('smask' in img) {
            out('/SMask ' + (objectNumber + 1) + ' 0 R');
        }
        out('/Length ' + img['data'].length + '>>');

        putStream(img['data']);

        out('endobj');
    }
    , putResourcesCallback = function () {
        var images = this.internal.collections[namespace + 'images']
        for (var i in images) {
            putImage.call(this, images[i])
        }
    }
    , putXObjectsDictCallback = function () {
        var images = this.internal.collections[namespace + 'images']
        , out = this.internal.write
        , image
        for (var i in images) {
            image = images[i]
            out(
                '/I' + image['i']
                , image['n']
                , '0'
                , 'R'
            )
        }
    }

    pdfDataExportAPI.addImage = function (imageData, format, x, y, w, h) {
        'use strict'
        if (typeof imageData === 'object' && imageData.nodeType === 1) {
            var canvas = document.createElement('canvas');
            canvas.width = imageData.clientWidth;
            canvas.height = imageData.clientHeight;

            var ctx = canvas.getContext('2d');
            if (!ctx) {
                throw ('addImage requires canvas to be supported by browser.');
            }
            ctx.drawImage(imageData, 0, 0, canvas.width, canvas.height);
            imageData = canvas.toDataURL('image/jpeg');
            format = "JPEG";
        }
        if (format.toUpperCase() !== 'JPEG') {
            throw new Error('addImage currently only supports format \'JPEG\', not \'' + format + '\'');
        }

        var imageIndex
        , images = this.internal.collections[namespace + 'images']
        , coord = this.internal.getCoordinateString
        , vcoord = this.internal.getVerticalCoordinateString;

        // Detect if the imageData is raw binary or Data URL
        if (imageData.substring(0, 23) === 'data:image/jpeg;base64,') {
            imageData = atob(imageData.replace('data:image/jpeg;base64,', ''));
        }

        if (images) {
            // this is NOT the first time this method is ran on this instance of pdfDataExport object.
            imageIndex = Object.keys ?
            Object.keys(images).length :
            (function (o) {
                var i = 0
                for (var e in o) { if (o.hasOwnProperty(e)) { i++ } }
                return i
            })(images)
        } else {
            // this is the first time this method is ran on this instance of pdfDataExport object.
            imageIndex = 0
            this.internal.collections[namespace + 'images'] = images = {}
            this.internal.events.subscribe('putResources', putResourcesCallback)
            this.internal.events.subscribe('putXobjectDict', putXObjectsDictCallback)
        }

        var dims = getJpegSize(imageData);
        var info = {
            w: dims[0],
            h: dims[1],
            cs: 'DeviceRGB',
            bpc: 8,
            f: 'DCTDecode',
            i: imageIndex,
            data: imageData
            // n: objectNumber will be added by putImage code

        };
        images[imageIndex] = info
        if (!w && !h) {
            w = -96;
            h = -96;
        }
        if (w < 0) {
            w = (-1) * info['w'] * 72 / w / this.internal.scaleFactor;
        }
        if (h < 0) {
            h = (-1) * info['h'] * 72 / h / this.internal.scaleFactor;
        }
        if (w === 0) {
            w = h * info['w'] / info['h'];
        }
        if (h === 0) {
            h = w * info['h'] / info['w'];
        }

        this.internal.write(
            'q'
            , coord(w)
            , '0 0'
            , coord(h) // TODO: check if this should be shifted by vcoord
            , coord(x)
            , vcoord(y + h)
            , 'cm /I' + info['i']
            , 'Do Q'
        )

        return this
    }
})(pdfDataExport.API)

; (function (API) {
    'use strict'

    /**
    Uncompresses data compressed into custom, base16-like format. 
    @public
    @function
    @param
    @returns {Type}
    */
    var uncompress = function (data) {

        var decoded = '0123456789abcdef'
        , encoded = 'klmnopqrstuvwxyz'
        , mapping = {}

        for (var i = 0; i < encoded.length; i++) {
            mapping[encoded[i]] = decoded[i]
        }

        var undef
        , output = {}
        , sign = 1
        , stringparts // undef. will be [] in string mode

        , activeobject = output
        , parentchain = []
        , parent_key_pair
        , keyparts = ''
        , valueparts = ''
        , key // undef. will be Truthy when Key is resolved.
        , datalen = data.length - 1 // stripping ending }
        , ch

        i = 1 // stripping starting {

        while (i != datalen) {
            // - { } ' are special.

            ch = data[i]
            i += 1

            if (ch == "'") {
                if (stringparts) {
                    // end of string mode
                    key = stringparts.join('')
                    stringparts = undef
                } else {
                    // start of string mode
                    stringparts = []
                }
            } else if (stringparts) {
                stringparts.push(ch)
            } else if (ch == '{') {
                // start of object
                parentchain.push([activeobject, key])
                activeobject = {}
                key = undef
            } else if (ch == '}') {
                // end of object
                parent_key_pair = parentchain.pop()
                parent_key_pair[0][parent_key_pair[1]] = activeobject
                key = undef
                activeobject = parent_key_pair[0]
            } else if (ch == '-') {
                sign = -1
            } else {
                // must be number
                if (key === undef) {
                    if (mapping.hasOwnProperty(ch)) {
                        keyparts += mapping[ch]
                        key = parseInt(keyparts, 16) * sign
                        sign = +1
                        keyparts = ''
                    } else {
                        keyparts += ch
                    }
                } else {
                    if (mapping.hasOwnProperty(ch)) {
                        valueparts += mapping[ch]
                        activeobject[key] = parseInt(valueparts, 16) * sign
                        sign = +1
                        key = undef
                        valueparts = ''
                    } else {
                        valueparts += ch
                    }
                }
            }
        } // end while

        return output
    }

    // encoding = 'Unicode' 
    // NOT UTF8, NOT UTF16BE/LE, NOT UCS2BE/LE. NO clever BOM behavior
    // Actual 16bit char codes used.
    // no multi-byte logic here

    // Unicode characters to WinAnsiEncoding:
    // {402: 131, 8211: 150, 8212: 151, 8216: 145, 8217: 146, 8218: 130, 8220: 147, 8221: 148, 8222: 132, 8224: 134, 8225: 135, 8226: 149, 8230: 133, 8364: 128, 8240:137, 8249: 139, 8250: 155, 710: 136, 8482: 153, 338: 140, 339: 156, 732: 152, 352: 138, 353: 154, 376: 159, 381: 142, 382: 158}
    // as you can see, all Unicode chars are outside of 0-255 range. No char code conflicts.
    // this means that you can give Win cp1252 encoded strings to pdfDataExport for rendering directly
    // as well as give strings with some (supported by these fonts) Unicode characters and 
    // these will be mapped to win cp1252 
    // for example, you can send char code (cp1252) 0x80 or (unicode) 0x20AC, getting "Euro" glyph displayed in both cases.

    var encodingBlock = {
        'codePages': ['WinAnsiEncoding']
        , 'WinAnsiEncoding': uncompress("{19m8n201n9q201o9r201s9l201t9m201u8m201w9n201x9o201y8o202k8q202l8r202m9p202q8p20aw8k203k8t203t8v203u9v2cq8s212m9t15m8w15n9w2dw9s16k8u16l9u17s9z17x8y17y9y}")
    }
    , encodings = {
        'Unicode': {
            'Courier': encodingBlock
            , 'Courier-Bold': encodingBlock
            , 'Courier-BoldOblique': encodingBlock
            , 'Courier-Oblique': encodingBlock
            , 'Helvetica': encodingBlock
            , 'Helvetica-Bold': encodingBlock
            , 'Helvetica-BoldOblique': encodingBlock
            , 'Helvetica-Oblique': encodingBlock
            , 'Times-Roman': encodingBlock
            , 'Times-Bold': encodingBlock
            , 'Times-BoldItalic': encodingBlock
            , 'Times-Italic': encodingBlock
            //	, 'Symbol'
            //	, 'ZapfDingbats'
        }
    }

    , fontMetrics = {
        'Unicode': {
            // all sizing numbers are n/fontMetricsFractionOf = one font size unit
            // this means that if fontMetricsFractionOf = 1000, and letter A's width is 476, it's
            // width is 476/1000 or 47.6% of its height (regardless of font size)
            // At this time this value applies to "widths" and "kerning" numbers.

            // char code 0 represents "default" (average) width - use it for chars missing in this table.
            // key 'fof' represents the "fontMetricsFractionOf" value

            'Courier-Oblique': uncompress("{'widths'{k3w'fof'6o}'kerning'{'fof'-6o}}")
            , 'Times-BoldItalic': uncompress("{'widths'{k3o2q4ycx2r201n3m201o6o201s2l201t2l201u2l201w3m201x3m201y3m2k1t2l2r202m2n2n3m2o3m2p5n202q6o2r1w2s2l2t2l2u3m2v3t2w1t2x2l2y1t2z1w3k3m3l3m3m3m3n3m3o3m3p3m3q3m3r3m3s3m203t2l203u2l3v2l3w3t3x3t3y3t3z3m4k5n4l4m4m4m4n4m4o4s4p4m4q4m4r4s4s4y4t2r4u3m4v4m4w3x4x5t4y4s4z4s5k3x5l4s5m4m5n3r5o3x5p4s5q4m5r5t5s4m5t3x5u3x5v2l5w1w5x2l5y3t5z3m6k2l6l3m6m3m6n2w6o3m6p2w6q2l6r3m6s3r6t1w6u1w6v3m6w1w6x4y6y3r6z3m7k3m7l3m7m2r7n2r7o1w7p3r7q2w7r4m7s3m7t2w7u2r7v2n7w1q7x2n7y3t202l3mcl4mal2ram3man3mao3map3mar3mas2lat4uau1uav3maw3way4uaz2lbk2sbl3t'fof'6obo2lbp3tbq3mbr1tbs2lbu1ybv3mbz3mck4m202k3mcm4mcn4mco4mcp4mcq5ycr4mcs4mct4mcu4mcv4mcw2r2m3rcy2rcz2rdl4sdm4sdn4sdo4sdp4sdq4sds4sdt4sdu4sdv4sdw4sdz3mek3mel3mem3men3meo3mep3meq4ser2wes2wet2weu2wev2wew1wex1wey1wez1wfl3rfm3mfn3mfo3mfp3mfq3mfr3tfs3mft3rfu3rfv3rfw3rfz2w203k6o212m6o2dw2l2cq2l3t3m3u2l17s3x19m3m}'kerning'{cl{4qu5kt5qt5rs17ss5ts}201s{201ss}201t{cks4lscmscnscoscpscls2wu2yu201ts}201x{2wu2yu}2k{201ts}2w{4qx5kx5ou5qx5rs17su5tu}2x{17su5tu5ou}2y{4qx5kx5ou5qx5rs17ss5ts}'fof'-6ofn{17sw5tw5ou5qw5rs}7t{cksclscmscnscoscps4ls}3u{17su5tu5os5qs}3v{17su5tu5os5qs}7p{17su5tu}ck{4qu5kt5qt5rs17ss5ts}4l{4qu5kt5qt5rs17ss5ts}cm{4qu5kt5qt5rs17ss5ts}cn{4qu5kt5qt5rs17ss5ts}co{4qu5kt5qt5rs17ss5ts}cp{4qu5kt5qt5rs17ss5ts}6l{4qu5ou5qw5rt17su5tu}5q{ckuclucmucnucoucpu4lu}5r{ckuclucmucnucoucpu4lu}7q{cksclscmscnscoscps4ls}6p{4qu5ou5qw5rt17sw5tw}ek{4qu5ou5qw5rt17su5tu}el{4qu5ou5qw5rt17su5tu}em{4qu5ou5qw5rt17su5tu}en{4qu5ou5qw5rt17su5tu}eo{4qu5ou5qw5rt17su5tu}ep{4qu5ou5qw5rt17su5tu}es{17ss5ts5qs4qu}et{4qu5ou5qw5rt17sw5tw}eu{4qu5ou5qw5rt17ss5ts}ev{17ss5ts5qs4qu}6z{17sw5tw5ou5qw5rs}fm{17sw5tw5ou5qw5rs}7n{201ts}fo{17sw5tw5ou5qw5rs}fp{17sw5tw5ou5qw5rs}fq{17sw5tw5ou5qw5rs}7r{cksclscmscnscoscps4ls}fs{17sw5tw5ou5qw5rs}ft{17su5tu}fu{17su5tu}fv{17su5tu}fw{17su5tu}fz{cksclscmscnscoscps4ls}}}")
            , 'Helvetica-Bold': uncompress("{'widths'{k3s2q4scx1w201n3r201o6o201s1w201t1w201u1w201w3m201x3m201y3m2k1w2l2l202m2n2n3r2o3r2p5t202q6o2r1s2s2l2t2l2u2r2v3u2w1w2x2l2y1w2z1w3k3r3l3r3m3r3n3r3o3r3p3r3q3r3r3r3s3r203t2l203u2l3v2l3w3u3x3u3y3u3z3x4k6l4l4s4m4s4n4s4o4s4p4m4q3x4r4y4s4s4t1w4u3r4v4s4w3x4x5n4y4s4z4y5k4m5l4y5m4s5n4m5o3x5p4s5q4m5r5y5s4m5t4m5u3x5v2l5w1w5x2l5y3u5z3r6k2l6l3r6m3x6n3r6o3x6p3r6q2l6r3x6s3x6t1w6u1w6v3r6w1w6x5t6y3x6z3x7k3x7l3x7m2r7n3r7o2l7p3x7q3r7r4y7s3r7t3r7u3m7v2r7w1w7x2r7y3u202l3rcl4sal2lam3ran3rao3rap3rar3ras2lat4tau2pav3raw3uay4taz2lbk2sbl3u'fof'6obo2lbp3xbq3rbr1wbs2lbu2obv3rbz3xck4s202k3rcm4scn4sco4scp4scq6ocr4scs4mct4mcu4mcv4mcw1w2m2zcy1wcz1wdl4sdm4ydn4ydo4ydp4ydq4yds4ydt4sdu4sdv4sdw4sdz3xek3rel3rem3ren3reo3rep3req5ter3res3ret3reu3rev3rew1wex1wey1wez1wfl3xfm3xfn3xfo3xfp3xfq3xfr3ufs3xft3xfu3xfv3xfw3xfz3r203k6o212m6o2dw2l2cq2l3t3r3u2l17s4m19m3r}'kerning'{cl{4qs5ku5ot5qs17sv5tv}201t{2ww4wy2yw}201w{2ks}201x{2ww4wy2yw}2k{201ts201xs}2w{7qs4qu5kw5os5qw5rs17su5tu7tsfzs}2x{5ow5qs}2y{7qs4qu5kw5os5qw5rs17su5tu7tsfzs}'fof'-6o7p{17su5tu5ot}ck{4qs5ku5ot5qs17sv5tv}4l{4qs5ku5ot5qs17sv5tv}cm{4qs5ku5ot5qs17sv5tv}cn{4qs5ku5ot5qs17sv5tv}co{4qs5ku5ot5qs17sv5tv}cp{4qs5ku5ot5qs17sv5tv}6l{17st5tt5os}17s{2kwclvcmvcnvcovcpv4lv4wwckv}5o{2kucltcmtcntcotcpt4lt4wtckt}5q{2ksclscmscnscoscps4ls4wvcks}5r{2ks4ws}5t{2kwclvcmvcnvcovcpv4lv4wwckv}eo{17st5tt5os}fu{17su5tu5ot}6p{17ss5ts}ek{17st5tt5os}el{17st5tt5os}em{17st5tt5os}en{17st5tt5os}6o{201ts}ep{17st5tt5os}es{17ss5ts}et{17ss5ts}eu{17ss5ts}ev{17ss5ts}6z{17su5tu5os5qt}fm{17su5tu5os5qt}fn{17su5tu5os5qt}fo{17su5tu5os5qt}fp{17su5tu5os5qt}fq{17su5tu5os5qt}fs{17su5tu5os5qt}ft{17su5tu5ot}7m{5os}fv{17su5tu5ot}fw{17su5tu5ot}}}")
            , 'Courier': uncompress("{'widths'{k3w'fof'6o}'kerning'{'fof'-6o}}")
            , 'Courier-BoldOblique': uncompress("{'widths'{k3w'fof'6o}'kerning'{'fof'-6o}}")
            , 'Times-Bold': uncompress("{'widths'{k3q2q5ncx2r201n3m201o6o201s2l201t2l201u2l201w3m201x3m201y3m2k1t2l2l202m2n2n3m2o3m2p6o202q6o2r1w2s2l2t2l2u3m2v3t2w1t2x2l2y1t2z1w3k3m3l3m3m3m3n3m3o3m3p3m3q3m3r3m3s3m203t2l203u2l3v2l3w3t3x3t3y3t3z3m4k5x4l4s4m4m4n4s4o4s4p4m4q3x4r4y4s4y4t2r4u3m4v4y4w4m4x5y4y4s4z4y5k3x5l4y5m4s5n3r5o4m5p4s5q4s5r6o5s4s5t4s5u4m5v2l5w1w5x2l5y3u5z3m6k2l6l3m6m3r6n2w6o3r6p2w6q2l6r3m6s3r6t1w6u2l6v3r6w1w6x5n6y3r6z3m7k3r7l3r7m2w7n2r7o2l7p3r7q3m7r4s7s3m7t3m7u2w7v2r7w1q7x2r7y3o202l3mcl4sal2lam3man3mao3map3mar3mas2lat4uau1yav3maw3tay4uaz2lbk2sbl3t'fof'6obo2lbp3rbr1tbs2lbu2lbv3mbz3mck4s202k3mcm4scn4sco4scp4scq6ocr4scs4mct4mcu4mcv4mcw2r2m3rcy2rcz2rdl4sdm4ydn4ydo4ydp4ydq4yds4ydt4sdu4sdv4sdw4sdz3rek3mel3mem3men3meo3mep3meq4ser2wes2wet2weu2wev2wew1wex1wey1wez1wfl3rfm3mfn3mfo3mfp3mfq3mfr3tfs3mft3rfu3rfv3rfw3rfz3m203k6o212m6o2dw2l2cq2l3t3m3u2l17s4s19m3m}'kerning'{cl{4qt5ks5ot5qy5rw17sv5tv}201t{cks4lscmscnscoscpscls4wv}2k{201ts}2w{4qu5ku7mu5os5qx5ru17su5tu}2x{17su5tu5ou5qs}2y{4qv5kv7mu5ot5qz5ru17su5tu}'fof'-6o7t{cksclscmscnscoscps4ls}3u{17su5tu5os5qu}3v{17su5tu5os5qu}fu{17su5tu5ou5qu}7p{17su5tu5ou5qu}ck{4qt5ks5ot5qy5rw17sv5tv}4l{4qt5ks5ot5qy5rw17sv5tv}cm{4qt5ks5ot5qy5rw17sv5tv}cn{4qt5ks5ot5qy5rw17sv5tv}co{4qt5ks5ot5qy5rw17sv5tv}cp{4qt5ks5ot5qy5rw17sv5tv}6l{17st5tt5ou5qu}17s{ckuclucmucnucoucpu4lu4wu}5o{ckuclucmucnucoucpu4lu4wu}5q{ckzclzcmzcnzcozcpz4lz4wu}5r{ckxclxcmxcnxcoxcpx4lx4wu}5t{ckuclucmucnucoucpu4lu4wu}7q{ckuclucmucnucoucpu4lu}6p{17sw5tw5ou5qu}ek{17st5tt5qu}el{17st5tt5ou5qu}em{17st5tt5qu}en{17st5tt5qu}eo{17st5tt5qu}ep{17st5tt5ou5qu}es{17ss5ts5qu}et{17sw5tw5ou5qu}eu{17sw5tw5ou5qu}ev{17ss5ts5qu}6z{17sw5tw5ou5qu5rs}fm{17sw5tw5ou5qu5rs}fn{17sw5tw5ou5qu5rs}fo{17sw5tw5ou5qu5rs}fp{17sw5tw5ou5qu5rs}fq{17sw5tw5ou5qu5rs}7r{cktcltcmtcntcotcpt4lt5os}fs{17sw5tw5ou5qu5rs}ft{17su5tu5ou5qu}7m{5os}fv{17su5tu5ou5qu}fw{17su5tu5ou5qu}fz{cksclscmscnscoscps4ls}}}")
            //, 'Symbol': uncompress("{'widths'{k3uaw4r19m3m2k1t2l2l202m2y2n3m2p5n202q6o3k3m2s2l2t2l2v3r2w1t3m3m2y1t2z1wbk2sbl3r'fof'6o3n3m3o3m3p3m3q3m3r3m3s3m3t3m3u1w3v1w3w3r3x3r3y3r3z2wbp3t3l3m5v2l5x2l5z3m2q4yfr3r7v3k7w1o7x3k}'kerning'{'fof'-6o}}")
            , 'Helvetica': uncompress("{'widths'{k3p2q4mcx1w201n3r201o6o201s1q201t1q201u1q201w2l201x2l201y2l2k1w2l1w202m2n2n3r2o3r2p5t202q6o2r1n2s2l2t2l2u2r2v3u2w1w2x2l2y1w2z1w3k3r3l3r3m3r3n3r3o3r3p3r3q3r3r3r3s3r203t2l203u2l3v1w3w3u3x3u3y3u3z3r4k6p4l4m4m4m4n4s4o4s4p4m4q3x4r4y4s4s4t1w4u3m4v4m4w3r4x5n4y4s4z4y5k4m5l4y5m4s5n4m5o3x5p4s5q4m5r5y5s4m5t4m5u3x5v1w5w1w5x1w5y2z5z3r6k2l6l3r6m3r6n3m6o3r6p3r6q1w6r3r6s3r6t1q6u1q6v3m6w1q6x5n6y3r6z3r7k3r7l3r7m2l7n3m7o1w7p3r7q3m7r4s7s3m7t3m7u3m7v2l7w1u7x2l7y3u202l3rcl4mal2lam3ran3rao3rap3rar3ras2lat4tau2pav3raw3uay4taz2lbk2sbl3u'fof'6obo2lbp3rbr1wbs2lbu2obv3rbz3xck4m202k3rcm4mcn4mco4mcp4mcq6ocr4scs4mct4mcu4mcv4mcw1w2m2ncy1wcz1wdl4sdm4ydn4ydo4ydp4ydq4yds4ydt4sdu4sdv4sdw4sdz3xek3rel3rem3ren3reo3rep3req5ter3mes3ret3reu3rev3rew1wex1wey1wez1wfl3rfm3rfn3rfo3rfp3rfq3rfr3ufs3xft3rfu3rfv3rfw3rfz3m203k6o212m6o2dw2l2cq2l3t3r3u1w17s4m19m3r}'kerning'{5q{4wv}cl{4qs5kw5ow5qs17sv5tv}201t{2wu4w1k2yu}201x{2wu4wy2yu}17s{2ktclucmucnu4otcpu4lu4wycoucku}2w{7qs4qz5k1m17sy5ow5qx5rsfsu5ty7tufzu}2x{17sy5ty5oy5qs}2y{7qs4qz5k1m17sy5ow5qx5rsfsu5ty7tufzu}'fof'-6o7p{17sv5tv5ow}ck{4qs5kw5ow5qs17sv5tv}4l{4qs5kw5ow5qs17sv5tv}cm{4qs5kw5ow5qs17sv5tv}cn{4qs5kw5ow5qs17sv5tv}co{4qs5kw5ow5qs17sv5tv}cp{4qs5kw5ow5qs17sv5tv}6l{17sy5ty5ow}do{17st5tt}4z{17st5tt}7s{fst}dm{17st5tt}dn{17st5tt}5o{ckwclwcmwcnwcowcpw4lw4wv}dp{17st5tt}dq{17st5tt}7t{5ow}ds{17st5tt}5t{2ktclucmucnu4otcpu4lu4wycoucku}fu{17sv5tv5ow}6p{17sy5ty5ow5qs}ek{17sy5ty5ow}el{17sy5ty5ow}em{17sy5ty5ow}en{5ty}eo{17sy5ty5ow}ep{17sy5ty5ow}es{17sy5ty5qs}et{17sy5ty5ow5qs}eu{17sy5ty5ow5qs}ev{17sy5ty5ow5qs}6z{17sy5ty5ow5qs}fm{17sy5ty5ow5qs}fn{17sy5ty5ow5qs}fo{17sy5ty5ow5qs}fp{17sy5ty5qs}fq{17sy5ty5ow5qs}7r{5ow}fs{17sy5ty5ow5qs}ft{17sv5tv5ow}7m{5ow}fv{17sv5tv5ow}fw{17sv5tv5ow}}}")
            , 'Helvetica-BoldOblique': uncompress("{'widths'{k3s2q4scx1w201n3r201o6o201s1w201t1w201u1w201w3m201x3m201y3m2k1w2l2l202m2n2n3r2o3r2p5t202q6o2r1s2s2l2t2l2u2r2v3u2w1w2x2l2y1w2z1w3k3r3l3r3m3r3n3r3o3r3p3r3q3r3r3r3s3r203t2l203u2l3v2l3w3u3x3u3y3u3z3x4k6l4l4s4m4s4n4s4o4s4p4m4q3x4r4y4s4s4t1w4u3r4v4s4w3x4x5n4y4s4z4y5k4m5l4y5m4s5n4m5o3x5p4s5q4m5r5y5s4m5t4m5u3x5v2l5w1w5x2l5y3u5z3r6k2l6l3r6m3x6n3r6o3x6p3r6q2l6r3x6s3x6t1w6u1w6v3r6w1w6x5t6y3x6z3x7k3x7l3x7m2r7n3r7o2l7p3x7q3r7r4y7s3r7t3r7u3m7v2r7w1w7x2r7y3u202l3rcl4sal2lam3ran3rao3rap3rar3ras2lat4tau2pav3raw3uay4taz2lbk2sbl3u'fof'6obo2lbp3xbq3rbr1wbs2lbu2obv3rbz3xck4s202k3rcm4scn4sco4scp4scq6ocr4scs4mct4mcu4mcv4mcw1w2m2zcy1wcz1wdl4sdm4ydn4ydo4ydp4ydq4yds4ydt4sdu4sdv4sdw4sdz3xek3rel3rem3ren3reo3rep3req5ter3res3ret3reu3rev3rew1wex1wey1wez1wfl3xfm3xfn3xfo3xfp3xfq3xfr3ufs3xft3xfu3xfv3xfw3xfz3r203k6o212m6o2dw2l2cq2l3t3r3u2l17s4m19m3r}'kerning'{cl{4qs5ku5ot5qs17sv5tv}201t{2ww4wy2yw}201w{2ks}201x{2ww4wy2yw}2k{201ts201xs}2w{7qs4qu5kw5os5qw5rs17su5tu7tsfzs}2x{5ow5qs}2y{7qs4qu5kw5os5qw5rs17su5tu7tsfzs}'fof'-6o7p{17su5tu5ot}ck{4qs5ku5ot5qs17sv5tv}4l{4qs5ku5ot5qs17sv5tv}cm{4qs5ku5ot5qs17sv5tv}cn{4qs5ku5ot5qs17sv5tv}co{4qs5ku5ot5qs17sv5tv}cp{4qs5ku5ot5qs17sv5tv}6l{17st5tt5os}17s{2kwclvcmvcnvcovcpv4lv4wwckv}5o{2kucltcmtcntcotcpt4lt4wtckt}5q{2ksclscmscnscoscps4ls4wvcks}5r{2ks4ws}5t{2kwclvcmvcnvcovcpv4lv4wwckv}eo{17st5tt5os}fu{17su5tu5ot}6p{17ss5ts}ek{17st5tt5os}el{17st5tt5os}em{17st5tt5os}en{17st5tt5os}6o{201ts}ep{17st5tt5os}es{17ss5ts}et{17ss5ts}eu{17ss5ts}ev{17ss5ts}6z{17su5tu5os5qt}fm{17su5tu5os5qt}fn{17su5tu5os5qt}fo{17su5tu5os5qt}fp{17su5tu5os5qt}fq{17su5tu5os5qt}fs{17su5tu5os5qt}ft{17su5tu5ot}7m{5os}fv{17su5tu5ot}fw{17su5tu5ot}}}")
            //, 'ZapfDingbats': uncompress("{'widths'{k4u2k1w'fof'6o}'kerning'{'fof'-6o}}")
            , 'Courier-Bold': uncompress("{'widths'{k3w'fof'6o}'kerning'{'fof'-6o}}")
            , 'Times-Italic': uncompress("{'widths'{k3n2q4ycx2l201n3m201o5t201s2l201t2l201u2l201w3r201x3r201y3r2k1t2l2l202m2n2n3m2o3m2p5n202q5t2r1p2s2l2t2l2u3m2v4n2w1t2x2l2y1t2z1w3k3m3l3m3m3m3n3m3o3m3p3m3q3m3r3m3s3m203t2l203u2l3v2l3w4n3x4n3y4n3z3m4k5w4l3x4m3x4n4m4o4s4p3x4q3x4r4s4s4s4t2l4u2w4v4m4w3r4x5n4y4m4z4s5k3x5l4s5m3x5n3m5o3r5p4s5q3x5r5n5s3x5t3r5u3r5v2r5w1w5x2r5y2u5z3m6k2l6l3m6m3m6n2w6o3m6p2w6q1w6r3m6s3m6t1w6u1w6v2w6w1w6x4s6y3m6z3m7k3m7l3m7m2r7n2r7o1w7p3m7q2w7r4m7s2w7t2w7u2r7v2s7w1v7x2s7y3q202l3mcl3xal2ram3man3mao3map3mar3mas2lat4wau1vav3maw4nay4waz2lbk2sbl4n'fof'6obo2lbp3mbq3obr1tbs2lbu1zbv3mbz3mck3x202k3mcm3xcn3xco3xcp3xcq5tcr4mcs3xct3xcu3xcv3xcw2l2m2ucy2lcz2ldl4mdm4sdn4sdo4sdp4sdq4sds4sdt4sdu4sdv4sdw4sdz3mek3mel3mem3men3meo3mep3meq4mer2wes2wet2weu2wev2wew1wex1wey1wez1wfl3mfm3mfn3mfo3mfp3mfq3mfr4nfs3mft3mfu3mfv3mfw3mfz2w203k6o212m6m2dw2l2cq2l3t3m3u2l17s3r19m3m}'kerning'{cl{5kt4qw}201s{201sw}201t{201tw2wy2yy6q-t}201x{2wy2yy}2k{201tw}2w{7qs4qy7rs5ky7mw5os5qx5ru17su5tu}2x{17ss5ts5os}2y{7qs4qy7rs5ky7mw5os5qx5ru17su5tu}'fof'-6o6t{17ss5ts5qs}7t{5os}3v{5qs}7p{17su5tu5qs}ck{5kt4qw}4l{5kt4qw}cm{5kt4qw}cn{5kt4qw}co{5kt4qw}cp{5kt4qw}6l{4qs5ks5ou5qw5ru17su5tu}17s{2ks}5q{ckvclvcmvcnvcovcpv4lv}5r{ckuclucmucnucoucpu4lu}5t{2ks}6p{4qs5ks5ou5qw5ru17su5tu}ek{4qs5ks5ou5qw5ru17su5tu}el{4qs5ks5ou5qw5ru17su5tu}em{4qs5ks5ou5qw5ru17su5tu}en{4qs5ks5ou5qw5ru17su5tu}eo{4qs5ks5ou5qw5ru17su5tu}ep{4qs5ks5ou5qw5ru17su5tu}es{5ks5qs4qs}et{4qs5ks5ou5qw5ru17su5tu}eu{4qs5ks5qw5ru17su5tu}ev{5ks5qs4qs}ex{17ss5ts5qs}6z{4qv5ks5ou5qw5ru17su5tu}fm{4qv5ks5ou5qw5ru17su5tu}fn{4qv5ks5ou5qw5ru17su5tu}fo{4qv5ks5ou5qw5ru17su5tu}fp{4qv5ks5ou5qw5ru17su5tu}fq{4qv5ks5ou5qw5ru17su5tu}7r{5os}fs{4qv5ks5ou5qw5ru17su5tu}ft{17su5tu5qs}fu{17su5tu5qs}fv{17su5tu5qs}fw{17su5tu5qs}}}")
            , 'Times-Roman': uncompress("{'widths'{k3n2q4ycx2l201n3m201o6o201s2l201t2l201u2l201w2w201x2w201y2w2k1t2l2l202m2n2n3m2o3m2p5n202q6o2r1m2s2l2t2l2u3m2v3s2w1t2x2l2y1t2z1w3k3m3l3m3m3m3n3m3o3m3p3m3q3m3r3m3s3m203t2l203u2l3v1w3w3s3x3s3y3s3z2w4k5w4l4s4m4m4n4m4o4s4p3x4q3r4r4s4s4s4t2l4u2r4v4s4w3x4x5t4y4s4z4s5k3r5l4s5m4m5n3r5o3x5p4s5q4s5r5y5s4s5t4s5u3x5v2l5w1w5x2l5y2z5z3m6k2l6l2w6m3m6n2w6o3m6p2w6q2l6r3m6s3m6t1w6u1w6v3m6w1w6x4y6y3m6z3m7k3m7l3m7m2l7n2r7o1w7p3m7q3m7r4s7s3m7t3m7u2w7v3k7w1o7x3k7y3q202l3mcl4sal2lam3man3mao3map3mar3mas2lat4wau1vav3maw3say4waz2lbk2sbl3s'fof'6obo2lbp3mbq2xbr1tbs2lbu1zbv3mbz2wck4s202k3mcm4scn4sco4scp4scq5tcr4mcs3xct3xcu3xcv3xcw2l2m2tcy2lcz2ldl4sdm4sdn4sdo4sdp4sdq4sds4sdt4sdu4sdv4sdw4sdz3mek2wel2wem2wen2weo2wep2weq4mer2wes2wet2weu2wev2wew1wex1wey1wez1wfl3mfm3mfn3mfo3mfp3mfq3mfr3sfs3mft3mfu3mfv3mfw3mfz3m203k6o212m6m2dw2l2cq2l3t3m3u1w17s4s19m3m}'kerning'{cl{4qs5ku17sw5ou5qy5rw201ss5tw201ws}201s{201ss}201t{ckw4lwcmwcnwcowcpwclw4wu201ts}2k{201ts}2w{4qs5kw5os5qx5ru17sx5tx}2x{17sw5tw5ou5qu}2y{4qs5kw5os5qx5ru17sx5tx}'fof'-6o7t{ckuclucmucnucoucpu4lu5os5rs}3u{17su5tu5qs}3v{17su5tu5qs}7p{17sw5tw5qs}ck{4qs5ku17sw5ou5qy5rw201ss5tw201ws}4l{4qs5ku17sw5ou5qy5rw201ss5tw201ws}cm{4qs5ku17sw5ou5qy5rw201ss5tw201ws}cn{4qs5ku17sw5ou5qy5rw201ss5tw201ws}co{4qs5ku17sw5ou5qy5rw201ss5tw201ws}cp{4qs5ku17sw5ou5qy5rw201ss5tw201ws}6l{17su5tu5os5qw5rs}17s{2ktclvcmvcnvcovcpv4lv4wuckv}5o{ckwclwcmwcnwcowcpw4lw4wu}5q{ckyclycmycnycoycpy4ly4wu5ms}5r{cktcltcmtcntcotcpt4lt4ws}5t{2ktclvcmvcnvcovcpv4lv4wuckv}7q{cksclscmscnscoscps4ls}6p{17su5tu5qw5rs}ek{5qs5rs}el{17su5tu5os5qw5rs}em{17su5tu5os5qs5rs}en{17su5qs5rs}eo{5qs5rs}ep{17su5tu5os5qw5rs}es{5qs}et{17su5tu5qw5rs}eu{17su5tu5qs5rs}ev{5qs}6z{17sv5tv5os5qx5rs}fm{5os5qt5rs}fn{17sv5tv5os5qx5rs}fo{17sv5tv5os5qx5rs}fp{5os5qt5rs}fq{5os5qt5rs}7r{ckuclucmucnucoucpu4lu5os}fs{17sv5tv5os5qx5rs}ft{17ss5ts5qs}fu{17sw5tw5qs}fv{17sw5tw5qs}fw{17ss5ts5qs}fz{ckuclucmucnucoucpu4lu5os5rs}}}")
            , 'Helvetica-Oblique': uncompress("{'widths'{k3p2q4mcx1w201n3r201o6o201s1q201t1q201u1q201w2l201x2l201y2l2k1w2l1w202m2n2n3r2o3r2p5t202q6o2r1n2s2l2t2l2u2r2v3u2w1w2x2l2y1w2z1w3k3r3l3r3m3r3n3r3o3r3p3r3q3r3r3r3s3r203t2l203u2l3v1w3w3u3x3u3y3u3z3r4k6p4l4m4m4m4n4s4o4s4p4m4q3x4r4y4s4s4t1w4u3m4v4m4w3r4x5n4y4s4z4y5k4m5l4y5m4s5n4m5o3x5p4s5q4m5r5y5s4m5t4m5u3x5v1w5w1w5x1w5y2z5z3r6k2l6l3r6m3r6n3m6o3r6p3r6q1w6r3r6s3r6t1q6u1q6v3m6w1q6x5n6y3r6z3r7k3r7l3r7m2l7n3m7o1w7p3r7q3m7r4s7s3m7t3m7u3m7v2l7w1u7x2l7y3u202l3rcl4mal2lam3ran3rao3rap3rar3ras2lat4tau2pav3raw3uay4taz2lbk2sbl3u'fof'6obo2lbp3rbr1wbs2lbu2obv3rbz3xck4m202k3rcm4mcn4mco4mcp4mcq6ocr4scs4mct4mcu4mcv4mcw1w2m2ncy1wcz1wdl4sdm4ydn4ydo4ydp4ydq4yds4ydt4sdu4sdv4sdw4sdz3xek3rel3rem3ren3reo3rep3req5ter3mes3ret3reu3rev3rew1wex1wey1wez1wfl3rfm3rfn3rfo3rfp3rfq3rfr3ufs3xft3rfu3rfv3rfw3rfz3m203k6o212m6o2dw2l2cq2l3t3r3u1w17s4m19m3r}'kerning'{5q{4wv}cl{4qs5kw5ow5qs17sv5tv}201t{2wu4w1k2yu}201x{2wu4wy2yu}17s{2ktclucmucnu4otcpu4lu4wycoucku}2w{7qs4qz5k1m17sy5ow5qx5rsfsu5ty7tufzu}2x{17sy5ty5oy5qs}2y{7qs4qz5k1m17sy5ow5qx5rsfsu5ty7tufzu}'fof'-6o7p{17sv5tv5ow}ck{4qs5kw5ow5qs17sv5tv}4l{4qs5kw5ow5qs17sv5tv}cm{4qs5kw5ow5qs17sv5tv}cn{4qs5kw5ow5qs17sv5tv}co{4qs5kw5ow5qs17sv5tv}cp{4qs5kw5ow5qs17sv5tv}6l{17sy5ty5ow}do{17st5tt}4z{17st5tt}7s{fst}dm{17st5tt}dn{17st5tt}5o{ckwclwcmwcnwcowcpw4lw4wv}dp{17st5tt}dq{17st5tt}7t{5ow}ds{17st5tt}5t{2ktclucmucnu4otcpu4lu4wycoucku}fu{17sv5tv5ow}6p{17sy5ty5ow5qs}ek{17sy5ty5ow}el{17sy5ty5ow}em{17sy5ty5ow}en{5ty}eo{17sy5ty5ow}ep{17sy5ty5ow}es{17sy5ty5qs}et{17sy5ty5ow5qs}eu{17sy5ty5ow5qs}ev{17sy5ty5ow5qs}6z{17sy5ty5ow5qs}fm{17sy5ty5ow5qs}fn{17sy5ty5ow5qs}fo{17sy5ty5ow5qs}fp{17sy5ty5qs}fq{17sy5ty5ow5qs}7r{5ow}fs{17sy5ty5ow5qs}ft{17sv5tv5ow}7m{5ow}fv{17sv5tv5ow}fw{17sv5tv5ow}}}")
        }
    };

    /*
    This event handler is fired when a new pdfDataExport object is initialized
    This event handler appends metrics data to standard fonts within
    that pdfDataExport instance. The metrics are mapped over Unicode character
    codes, NOT CIDs or other codes matching the StandardEncoding table of the
    standard PDF fonts.
    Future:
    Also included is the encoding maping table, converting Unicode (UCS-2, UTF-16)
    char codes to StandardEncoding character codes. The encoding table is to be used
    somewhere around "pdfEscape" call.
    */

    API.events.push([
        'addFonts'
        , function (fontManagementObjects) {
            // fontManagementObjects is {
            //	'fonts':font_ID-keyed hash of font objects
            //	, 'dictionary': lookup object, linking ["FontFamily"]['Style'] to font ID
            //}
            var font
            , fontID
            , metrics
            , unicode_section
            , encoding = 'Unicode'
            , encodingBlock

            for (fontID in fontManagementObjects.fonts) {
                if (fontManagementObjects.fonts.hasOwnProperty(fontID)) {
                    font = fontManagementObjects.fonts[fontID]

                    // // we only ship 'Unicode' mappings and metrics. No need for loop.
                    // // still, leaving this for the future.

                    // for (encoding in fontMetrics){
                    // 	if (fontMetrics.hasOwnProperty(encoding)) {

                    metrics = fontMetrics[encoding][font.PostScriptName]
                    if (metrics) {
                        if (font.metadata[encoding]) {
                            unicode_section = font.metadata[encoding]
                        } else {
                            unicode_section = font.metadata[encoding] = {}
                        }

                        unicode_section.widths = metrics.widths
                        unicode_section.kerning = metrics.kerning
                    }
                    // 	}
                    // }
                    // for (encoding in encodings){
                    // 	if (encodings.hasOwnProperty(encoding)) {
                    encodingBlock = encodings[encoding][font.PostScriptName]
                    if (encodingBlock) {
                        if (font.metadata[encoding]) {
                            unicode_section = font.metadata[encoding]
                        } else {
                            unicode_section = font.metadata[encoding] = {}
                        }

                        unicode_section.encoding = encodingBlock
                        if (encodingBlock.codePages && encodingBlock.codePages.length) {
                            font.encoding = encodingBlock.codePages[0]
                        }
                    }
                    // 	}
                    // }
                }
            }
        }
    ]) // end of adding event handler

})(pdfDataExport.API);


/*global self */
/*jslint bitwise: true, regexp: true, confusion: true, es5: true, vars: true, white: true,
  plusplus: true */


var saveAs = window.jqxSaveAs = saveAs
  || (navigator.msSaveBlob && navigator.msSaveBlob.bind(navigator))
  || (function (view) {
      "use strict";
      var
            doc = view.document
            // only get URL when necessary in case BlobBuilder.js hasn't overridden it yet
          , get_URL = function () {
              return view.URL || view.webkitURL || view;
          }
          , URL = view.URL || view.webkitURL || view
           , save_link = $("<a></a>")[0]
      //   , save_link = doc.createElementNS("http://www.w3.org/1999/xhtml", "a")
          , can_use_save_link = "download" in save_link
          , click = function (node) {
              var event = doc.createEvent("MouseEvents");
              event.initMouseEvent(
                  "click", true, false, view, 0, 0, 0, 0, 0
                  , false, false, false, false, 0, null
              );
              return node.dispatchEvent(event); // false if event was cancelled
          }
          , webkit_req_fs = view.webkitRequestFileSystem
          , req_fs = view.requestFileSystem || webkit_req_fs || view.mozRequestFileSystem
          , throw_outside = function (ex) {
              (view.setImmediate || view.setTimeout)(function () {
                  throw ex;
              }, 0);
          }
          , force_saveable_type = "application/octet-stream"
          , fs_min_size = 0
          , deletion_queue = []
          , process_deletion_queue = function () {
              var i = deletion_queue.length;
              while (i--) {
                  var file = deletion_queue[i];
                  if (typeof file === "string") { // file is an object URL
                      URL.revokeObjectURL(file);
                  } else { // file is a File
                      file.remove();
                  }
              }
              deletion_queue.length = 0; // clear queue
          }
          , dispatch = function (filesaver, event_types, event) {
              event_types = [].concat(event_types);
              var i = event_types.length;
              while (i--) {
                  var listener = filesaver["on" + event_types[i]];
                  if (typeof listener === "function") {
                      try {
                          listener.call(filesaver, event || filesaver);
                      } catch (ex) {
                          throw_outside(ex);
                      }
                  }
              }
          }
          , FileSaver = function (blob, name) {
              // First try a.download, then web filesystem, then object URLs
              var
                    filesaver = this
                  , type = blob.type
                  , blob_changed = false
                  , object_url
                  , target_view
                  , get_object_url = function () {
                      var object_url = get_URL().createObjectURL(blob);
                      deletion_queue.push(object_url);
                      return object_url;
                  }
                  , dispatch_all = function () {
                      dispatch(filesaver, "writestart progress write writeend".split(" "));
                  }
                  // on any filesys errors revert to saving with object URLs
                  , fs_error = function () {
                      // don't create more object URLs than needed
                      if (blob_changed || !object_url) {
                          object_url = get_object_url(blob);
                      }
                      if (target_view) {
                          target_view.location.href = object_url;
                      }
                      filesaver.readyState = filesaver.DONE;
                      dispatch_all();
                  }
                  , abortable = function (func) {
                      return function () {
                          if (filesaver.readyState !== filesaver.DONE) {
                              return func.apply(this, arguments);
                          }
                      };
                  }
                  , create_if_not_found = { create: true, exclusive: false }
                  , slice
              ;
              filesaver.readyState = filesaver.INIT;
              if (!name) {
                  name = "download";
              }
              if (can_use_save_link) {
                  object_url = get_object_url(blob);
                  save_link.href = object_url;
                  save_link.download = name;
                  if (click(save_link)) {
                      filesaver.readyState = filesaver.DONE;
                      dispatch_all();
                      return;
                  }
              }
              // Object and web filesystem URLs have a problem saving in Google Chrome when
              // viewed in a tab, so I force save with application/octet-stream
              // http://code.google.com/p/chromium/issues/detail?id=91158
              if (view.chrome && type && type !== force_saveable_type) {
                  slice = blob.slice || blob.webkitSlice;
                  blob = slice.call(blob, 0, blob.size, force_saveable_type);
                  blob_changed = true;
              }
              // Since I can't be sure that the guessed media type will trigger a download
              // in WebKit, I append .download to the filename.
              // https://bugs.webkit.org/show_bug.cgi?id=65440
              if (webkit_req_fs && name !== "download") {
                  name += ".download";
              }
              if (type === force_saveable_type || webkit_req_fs) {
                  target_view = view;
              } else {
                  target_view = view.open();
              }
              if (!req_fs) {
                  fs_error();
                  return;
              }
              fs_min_size += blob.size;
              req_fs(view.TEMPORARY, fs_min_size, abortable(function (fs) {
                  fs.root.getDirectory("saved", create_if_not_found, abortable(function (dir) {
                      var save = function () {
                          dir.getFile(name, create_if_not_found, abortable(function (file) {
                              file.createWriter(abortable(function (writer) {
                                  writer.onwriteend = function (event) {
                                      target_view.location.href = file.toURL();
                                      deletion_queue.push(file);
                                      filesaver.readyState = filesaver.DONE;
                                      dispatch(filesaver, "writeend", event);
                                  };
                                  writer.onerror = function () {
                                      var error = writer.error;
                                      if (error.code !== error.ABORT_ERR) {
                                          fs_error();
                                      }
                                  };
                                  "writestart progress write abort".split(" ").forEach(function (event) {
                                      writer["on" + event] = filesaver["on" + event];
                                  });
                                  writer.write(blob);
                                  filesaver.abort = function () {
                                      writer.abort();
                                      filesaver.readyState = filesaver.DONE;
                                  };
                                  filesaver.readyState = filesaver.WRITING;
                              }), fs_error);
                          }), fs_error);
                      };
                      dir.getFile(name, { create: false }, abortable(function (file) {
                          // delete file if it already exists
                          file.remove();
                          save();
                      }), abortable(function (ex) {
                          if (ex.code === ex.NOT_FOUND_ERR) {
                              save();
                          } else {
                              fs_error();
                          }
                      }));
                  }), fs_error);
              }), fs_error);
          }
          , FS_proto = FileSaver.prototype
          , saveAs = function (blob, name) {
              return new FileSaver(blob, name);
          }
      ;
      FS_proto.abort = function () {
          var filesaver = this;
          filesaver.readyState = filesaver.DONE;
          dispatch(filesaver, "abort");
      };
      FS_proto.readyState = FS_proto.INIT = 0;
      FS_proto.WRITING = 1;
      FS_proto.DONE = 2;

      FS_proto.error =
      FS_proto.onwritestart =
      FS_proto.onprogress =
      FS_proto.onwrite =
      FS_proto.onabort =
      FS_proto.onerror =
      FS_proto.onwriteend =
          null;

      if (view.addEventListener) {
          view.addEventListener("unload", process_deletion_queue, false);
      }
      return saveAs;
  }(self));


; (function (API) {
    'use strict'

    var name = 'pdfDataExport IE Below 9 Shim plugin';
    // Shim in IE6-9 support
    API.output = function (type, options) {

        // If not IE then return early
        return this.internal.output(type, options);

        var filename = 'Output.pdf';
        switch (type) {
            case 'datauristring':
            case 'dataurlstring':
            case 'datauri':
            case 'dataurl':
            case 'dataurlnewwindow':
                if (console)
                    console.log(name + ': Data URIs are not supported on IE6-9.');
                break;
            case 'save':
                filename = options;
                break;
        }

        // @TODO: IE shim 


    };



})(pdfDataExport.API)
})();



/***/ }),

/***/ 4198:
/***/ (() => {

﻿/* tslint:disable */
/* eslint-disable */
(function(){
	if (typeof document === 'undefined') { 
		return;
	}

( function ( $ ) {

    if ( !Array.prototype.find ) {
        Object.defineProperty( Array.prototype, 'find', {
            value: function ( predicate ) {
                // 1. Let O be ? ToObject(this value).
                if ( this == null ) {
                    throw TypeError( '"this" is null or not defined' );
                }

                var o = Object( this );

                // 2. Let len be ? ToLength(? Get(O, "length")).
                var len = o.length >>> 0;

                // 3. If IsCallable(predicate) is false, throw a TypeError exception.
                if ( typeof predicate !== 'function' ) {
                    throw TypeError( 'predicate must be a function' );
                }

                // 4. If thisArg was supplied, let T be thisArg; else let T be undefined.
                var thisArg = arguments[ 1 ];

                // 5. Let k be 0.
                var k = 0;

                // 6. Repeat, while k < len
                while ( k < len ) {
                    // a. Let Pk be ! ToString(k).
                    // b. Let kValue be ? Get(O, Pk).
                    // c. Let testResult be ToBoolean(? Call(predicate, T, « kValue, k, O »)).
                    // d. If testResult is true, return kValue.
                    var kValue = o[ k ];
                    if ( predicate.call( thisArg, kValue, k, o ) ) {
                        return kValue;
                    }
                    // e. Increase k by 1.
                    k++;
                }

                // 7. Return undefined.
                return undefined;
            },
            configurable: true,
            writable: true
        } );
    }

    $.jqx.observableArray = function ( items, observeFunction ) {
        if ( typeof ( items ) == 'string' ) {
            items = $.parseJSON( items );
        }

        if ( !Object.defineProperty ||
            !( function () { try { Object.defineProperty( {}, 'x', {} ); return true; } catch ( e ) { return false; } }() ) ) {
            var orig = Object.defineProperty;
            Object.defineProperty = function ( o, prop, desc ) {
                // In IE8 try built-in implementation for defining properties on DOM prototypes.
                if ( orig ) { try { return orig( o, prop, desc ); } catch ( e ) { } }

                if ( o !== Object( o ) ) { throw TypeError( "Object.defineProperty called on non-object" ); }
                if ( Object.prototype.__defineGetter__ && ( 'get' in desc ) ) {
                    Object.prototype.__defineGetter__.call( o, prop, desc.get );
                }
                if ( Object.prototype.__defineSetter__ && ( 'set' in desc ) ) {
                    Object.prototype.__defineSetter__.call( o, prop, desc.set );
                }
                if ( 'value' in desc ) {
                    o[ prop ] = desc.value;
                }
                else if ( !o[ prop ] ) {
                    o[ prop ] = desc;
                }

                return o;
            };
        }

        if ( !Array.prototype.forEach ) {
            Array.prototype.forEach = function ( fun /*, thisp */ ) {
                if ( this === void 0 || this === null ) { throw TypeError(); }

                var t = Object( this );
                var len = t.length >>> 0;
                if ( typeof fun !== "function" ) { throw TypeError(); }

                var thisp = arguments[ 1 ], i;
                for ( i = 0; i < len; i++ ) {
                    if ( i in t ) {
                        fun.call( thisp, t[ i ], i, t );
                    }
                }
            };
        }

        if ( typeof Object.getOwnPropertyNames !== "function" ) {
            Object.getOwnPropertyNames = function ( o ) {
                if ( o !== Object( o ) ) { throw TypeError( "Object.getOwnPropertyNames called on non-object" ); }
                var props = [], p;
                for ( p in o ) {
                    if ( Object.prototype.hasOwnProperty.call( o, p ) ) {
                        props.push( p );
                    }
                }
                return props;
            };
        }

        var that = this, notifier, array = [];
        that.notifier = null;
        that.name = "observableArray";
        that.observing = true;
        that.changes = new Array();

        var observeFunction = observeFunction;
        that.observe = function () {
            that.observing = true;
            if ( arguments.length == 1 ) {
                observeFunction = arguments[ 0 ];
            }
        }

        that.unobserve = function () {
            that.observing = false;
        }

        that.toArray = function () {
            return array.slice( 0 );
        }

        that.toJSON = function ( keys, subArray ) {
            var value = array;
            if ( subArray ) {
                value = subArray;
            }
            var escapable = /[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,
                meta = {
                    '\b': '\\b',
                    '\t': '\\t',
                    '\n': '\\n',
                    '\f': '\\f',
                    '\r': '\\r',
                    '"': '\\"',
                    '\\': '\\\\'
                };

            function quote( string ) {
                return '"' + string.replace( escapable, function ( a ) {
                    var c = meta[ a ];
                    return typeof c === 'string' ? c : '\\u' + ( '0000' + a.charCodeAt( 0 ).toString( 16 ) ).slice( -4 );
                } ) + '"';
            }

            function formatNumber( n ) {
                return n < 10 ? '0' + n : n;
            }

            function stringifyDate( value ) {
                var date;
                if ( isFinite( value.valueOf() ) ) {
                    date = value.getUTCFullYear() + '-' + formatNumber( value.getUTCMonth() + 1 ) + '-' +
                        formatNumber( value.getUTCDate() ) + 'T' + formatNumber( value.getUTCHours() ) + ':' +
                        formatNumber( value.getUTCMinutes() ) + ':' + formatNumber( value.getUTCSeconds() ) + 'Z"';
                } else {
                    date = 'null';
                }
                return date;
            }

            function stringifyArray( value ) {
                var len = value.length,
                    partial = [],
                    i;
                for ( i = 0; i < len; i++ ) {
                    partial.push( str( i, value ) || 'null' );
                }

                return '[' + partial.join( ',' ) + ']';
            }

            function stringifyObject( value ) {
                var partial = [],
                    i, v;
                for ( i in value ) {
                    if ( Object.prototype.hasOwnProperty.call( value, i ) ) {
                        if ( i != "" && keys && keys.indexOf( i ) === -1 ) {
                            continue;
                        }

                        v = str( i, value );
                        if ( v ) {
                            partial.push( quote( i ) + ':' + v );
                        }
                    }
                }
                return '{' + partial.join( ',' ) + '}';
            }

            function stringifyReference( value ) {
                switch ( Object.prototype.toString.call( value ) ) {
                    case '[object Date]':
                        return stringifyDate( value );
                    case '[object Array]':
                        return stringifyArray( value );
                }
                return stringifyObject( value );
            }

            function stringifyPrimitive( value, type ) {
                switch ( type ) {
                    case 'string':
                        return quote( value );
                    case 'number':
                    case 'float':
                    case 'integer':
                    case 'int':
                        return isFinite( value ) ? value : 'null';
                    case 'boolean':
                        return value;
                }
                return 'null';
            }

            function str( key, holder ) {
                var value = holder[ key ], type = typeof value;

                if ( value && typeof value === 'object' && typeof value.toJSON === 'function' ) {
                    value = value.toJSON( key );
                    type = typeof value;
                }
                if ( /(number|float|int|integer|string|boolean)/.test( type ) || ( !value && type === 'object' ) ) {
                    return stringifyPrimitive( value, type );
                } else {
                    return stringifyReference( value );
                }
            }
            if ( !keys && window.JSON && typeof window.JSON.stringify === 'function' ) {
                return window.JSON.stringify( value );
            }

            return str( "", { "": value } );
        }

        that.defineIndexProperty = function ( index ) {
            if ( !( index in that ) ) {
                var defineProperty = function ( obj, property, path, context ) {
                    var newValue = obj[ property ];
                    var oldValue = newValue;
                    var getter = function () {
                        return oldValue;
                    }
                    var setter = function ( val ) {
                        newValue = val;
                        if ( oldValue !== newValue ) {
                            var oldValueArg = oldValue;
                            oldValue = newValue;
                            if ( typeof notifier === "function" ) {
                                var index = array.indexOf( context );

                                var propertyPath = "";
                                var getPath = function ( obj, path ) {
                                    Object.getOwnPropertyNames( obj ).forEach( function ( name ) {
                                        var type = $.type( obj[ name ] );
                                        if ( type == "array" || type == "object" ) {
                                            getPath( obj[ name ], path + "." + name );
                                        }
                                        else if ( property === name ) {
                                            propertyPath = path + "." + name;
                                        }
                                    } );
                                }
                                getPath( context, index );

                                notifier( { object: that, type: 'update', path: propertyPath, index: index, name: property, newValue: newValue, oldValue: oldValueArg } );
                            }
                        }
                        oldValue = newValue;
                        return newValue;
                    }
                    if ( obj[ property ] != undefined && property != "length" ) {
                        if ( Object.defineProperty )
                            Object.defineProperty( obj, property, {
                                get: getter,
                                set: setter
                            } );
                        else if ( Object.prototype.__defineGetter__ && Object.prototype.__defineSetter__ ) {
                            Object.prototype.__defineGetter__.call( obj, property, getter );
                            Object.prototype.__defineSetter__.call( obj, property, setter );
                        }
                    }
                }

                var defineProperties = function ( obj, path, context ) {
                    var type = $.type( obj );
                    if ( /(number|float|int|integer|string|boolean)/.test( type ) ) {
                        return;
                    }

                    if ( obj === undefined ) {
                        return;
                    }

                    Object.getOwnPropertyNames( obj ).forEach( function ( name ) {
                        var type = $.type( obj[ name ] );
                        if ( type == "array" || type == "object" ) {
                            defineProperty( obj, name, path + "." + name, context );
                            defineProperties( obj[ name ], path + "." + name, context );
                        }
                        else {
                            defineProperty( obj, name, path + "." + name, context );
                        }
                    } );
                }

                Object.defineProperty( that, index, {
                    configurable: true,
                    enumerable: true,
                    get: function () {
                        return array[ index ];
                    },
                    set: function ( newValue ) {
                        var oldValue = array[ index ];
                        if ( that.toJSON( null, oldValue ) != that.toJSON( null, newValue ) ) {
                            array[ index ] = newValue;
                            if ( typeof notifier === "function" ) {
                                notifier( { object: that, type: 'update', path: index.toString(), index: index, name: "index", newValue: newValue, oldValue: oldValue } );
                            }
                            defineProperties( newValue, index, newValue );
                        }
                    }
                } );
                defineProperties( that[ index ], index, that[ index ] );
            }
        }

        that.push = function () {
            var index;
            for ( var i = 0, ln = arguments.length; i < ln; i++ ) {
                index = array.length;
                array.push( arguments[ i ] );
                that.defineIndexProperty( index );
                if ( typeof notifier === "function" ) {
                    notifier( { object: that, type: 'add', name: "length", index: index, newValue: array.length, oldValue: index } );
                }
            }
            return array.length;
        };

        that.pop = function () {
            if ( ~array.length ) {
                var index = array.length - 1,
                    item = array.pop();
                delete that[ index ];
                if ( typeof notifier === "function" ) {
                    notifier( { object: that, type: 'delete', name: "length", index: index, newValue: array.length, oldValue: index } );
                }
                return item;
            }
        };

        that.unshift = function () {
            var index = array.length;
            for ( var i = 0, ln = arguments.length; i < ln; i++ ) {
                array.splice( i, 0, arguments[ i ] );
                that.defineIndexProperty( array.length - 1 );
            }
            if ( typeof notifier === "function" ) {
                notifier( { object: that, type: 'add', index: 0, name: "length", newValue: array.length, oldValue: index } );
            }
            return array.length;
        };

        that.shift = function () {
            var index = array.length;
            if ( ~array.length ) {
                var item = array.shift();
                array.length === 0 && delete that[ index ];
                if ( typeof notifier === "function" ) {
                    notifier( { object: that, type: 'delete', index: index, name: "length", newValue: array.length, oldValue: index } );
                }
                return item;
            }
        };

        that.slice = function ( start, end, observeFunction ) {
            var newArray = array.slice( start, end );
            var observableArray = new $.jqx.observableArray( newArray, observeFunction );
            return observableArray;
        }

        that.splice = function ( index, howMany, observeFunction ) {
            var removed = [],
                item,
                pos;

            index = !~index ? array.length - index : index;

            howMany = ( howMany == null ? array.length - index : howMany ) || 0;

            while ( howMany-- ) {
                item = array.splice( index, 1 )[ 0 ];
                removed.push( item );
                delete that[ array.length ];
                if ( typeof notifier === "function" ) {
                    notifier( { object: that, type: 'delete', index: index, name: "length", newValue: -1, oldValue: index } );
                }
            }

            for ( var i = 2, ln = arguments.length; i < ln; i++ ) {
                array.splice( index, 0, arguments[ i ] );
                this.defineIndexProperty( array.length - 1 );
                if ( typeof notifier === "function" ) {
                    notifier( { object: that, type: 'add', index: index, name: "length", newValue: array.length - 1, oldValue: index } );
                }
                index++;
            }

            var observableArray = new $.jqx.observableArray( removed, observeFunction );
            return observableArray;
        };

        Object.defineProperty( that, "length", {
            configurable: false,
            enumerable: true,
            get: function () {
                return array.length;
            },
            set: function ( value ) {
                var n = Number( value );
                if ( n % 1 === 0 && n >= 0 ) {
                    if ( n < array.length ) {
                        that.splice( n );
                    } else if ( n > array.length ) {
                        that.push.apply( that, new Array( n - array.length ) );
                    }
                } else {
                    throw new RangeError( "Invalid array length" );
                }
                return value;
            }
        } );

        $.jqx.observableArray.prototype.fromArray = function ( array, observeFunction ) {
            var observableArray = new $.jqx.observableArray( array, observeFunction );
            return observableArray;
        }

        $.jqx.observableArray.prototype.clone = function () {
            var observableArray = new $.jqx.observableArray( array, observeFunction );
            observableArray.observing = that.observing;
            observableArray.changes = that.changes;
            observableArray.notifier = that.notifier;
            return observableArray;
        }

        that.remove = function ( index ) {
            if ( index < 0 || index >= that.length ) {
                throw new Error( 'Invalid index : ' + index );
            }
            if ( that.hasOwnProperty( index ) ) {
                var oldValue = that[ index ];
                that[ index ] = undefined;
                array[ index ] = undefined;
                if ( typeof notifier === "function" ) {
                    notifier( { object: that, type: 'delete', index: index, name: "index", newValue: undefined, oldValue: oldValue } );
                }
                return true;
            }
            return false;
        };

        that.concat = function ( args, observeFunction ) {
            var newArray = array.concat( args );
            var observableArray = new $.jqx.observableArray( newArray, observeFunction );
            return observableArray;
        };

        Object.getOwnPropertyNames( Array.prototype ).forEach( function ( name ) {
            if ( !( name in that ) ) {
                var fn = function () {
                    var tmp = that.observing;
                    that.observing = false;
                    var arrayFn = array[ name ];
                    var result = arrayFn.apply( array, arguments );
                    that.observing = tmp;
                    return result;
                }
                Object.defineProperty( that, name, {
                    configurable: false,
                    enumerable: true,
                    writeable: false,
                    value: fn
                } );
            }
        } );


        that.set = function ( index, value ) {
            if ( $.type( index ) == "string" && index.split( "." ).length > 1 ) {
                var items = index.split( "." );
                var obj = that;
                for ( var i = 0; i < items.length; i++ ) {
                    if ( i === 0 ) {
                        if ( items[ i ] >= that.length ) {
                            throw new Error( "Invalid Index: " + index );
                        }
                    }
                    if ( i < items.length - 1 ) {
                        obj = obj[ items[ i ] ];
                    }
                    else {
                        obj[ items[ i ] ] = value;
                    }
                }
                return true;
            }
            if ( index >= that.length ) {
                that.push( value );
            }
            else {
                that[ index ] = value;
            }
            return true;
        }

        that.get = function ( index ) {
            return that[ index ];
        }

        if ( items instanceof Array ) {
            that.push.apply( that, items );
        }

        notifier = function () {
            if ( !that.observing ) {
                return;
            }

            if ( arguments && arguments[ 0 ] ) {
                that.changes.push( arguments[ 0 ] );
            }

            if ( observeFunction ) {
                observeFunction.apply( that, arguments );
            }
            if ( that.notifier ) {
                that.notifier.apply( that, arguments );
            }
        }

        return that;
    }

    $.jqx.formatDate = function ( value, format, calendar ) {
        var result = $.jqx.dataFormat.formatdate( value, format, calendar );
        return result;
    }

    $.jqx.formatNumber = function ( value, format, calendar ) {
        var result = $.jqx.dataFormat.formatnumber( value, format, calendar );
        return result;
    }

    $.jqx.dataAdapter = function ( source, options ) {
        if ( source != undefined ) {
            if ( source.dataFields !== undefined ) {
                source.datafields = source.dataFields;
            }
            if ( source.dataType !== undefined ) {
                source.datatype = source.dataType;
            }
            if ( source.localData !== undefined ) {
                source.localdata = source.localData;
            }
            if ( source.sortColumn !== undefined ) {
                source.sortcolumn = source.sortColumn;
            }
            if ( source.sortDirection !== undefined ) {
                source.sortdirection = source.sortDirection;
            }
            if ( source.sortColumns !== undefined ) {
                source.sortcolumns = source.sortColumns;
            }
            if ( source.sortDirections !== undefined ) {
                source.sortdirections = source.sortDirections;
            }
            if ( source.sortOrder !== undefined ) {
                source.sortdirection = source.sortOrder;
            }
            if ( source.formatData !== undefined ) {
                source.formatdata = source.formatData;
            }
            if ( source.processData !== undefined ) {
                source.processdata = source.processData;
            }
            if ( source.pageSize !== undefined ) {
                source.pagesize = source.pageSize;
            }
            if ( source.pageNum !== undefined ) {
                source.pagenum = source.pageNum;
            }
            if ( source.updateRow !== undefined ) {
                source.updaterow = source.updateRow;
            }
            if ( source.addRow !== undefined ) {
                source.addrow = source.addRow;
            }
            if ( source.deleteRow !== undefined ) {
                source.deleterow = source.deleteRow;
            }
            if ( source.contentType !== undefined ) {
                source.contenttype = source.contentType;
            }
            if ( source.totalRecords != undefined ) {
                source.totalrecords = source.totalRecords;
            }
            if ( source.loadError != undefined ) {
                source.loadError = source.loadError;
            }
            if ( source.sortComparer != undefined ) {
                source.sortcomparer = source.sortComparer;
            }
        }

        this._source = source;
        this._options = options || {};
        if ( source.beforeLoadComplete != undefined ) {
            this._options.beforeLoadComplete = this._source.beforeLoadComplete;
        }
        if ( source.downloadComplete != undefined ) {
            this._options.downloadComplete = this._source.downloadComplete;
        }
        if ( source.loadComplete != undefined ) {
            this._options.loadComplete = this._source.loadComplete;
        }
        if ( source.autoBind != undefined ) {
            this._options.downloadComplete = this._source.autoBind;
        }
        if ( source.formatData != undefined ) {
            this._options.formatData = this._source.formatData;
        }
        if ( source.loadError != undefined ) {
            this._options.loadError = this._source.loadError;
        }
        if ( source.beforeSend != undefined ) {
            this._options.beforeSend = this._source.beforeSend;
        }
        if ( source.contentType != undefined ) {
            this._options.contentType = this._source.contentType;
        }
        if ( source.async != undefined ) {
            this._options.async = this._source.async;
        }
        if ( source.loadServerData != undefined ) {
            this._options.loadServerData = this._source.loadServerData;
        }
        if ( source.uniqueDataFields != undefined ) {
            this._options.uniqueDataFields = this._source.uniqueDataFields;
        }

        this.records = new Array();
        this._downloadComplete = new Array();
        this._bindingUpdate = new Array();

        if ( source != undefined && source.localdata != null && typeof source.localdata == "function" ) {
            var localData = source.localdata();
            if ( localData != null ) {
                source._localdata = source.localdata;
                var me = this;
                if ( source._localdata.subscribe ) {
                    me._oldlocaldata = [];
                    source._localdata.subscribe( function ( value ) {
                        var deepClone = function ( objThing ) {
                            if ( $.isArray( objThing ) ) {
                                return $.makeArray( deepClone( $( objThing ) ) );
                            }
                            return $.extend( true, {}, objThing );
                        };
                        if ( me.suspendKO == false || me.suspendKO == undefined || me._oldlocaldata.length == 0 ) {
                            me._oldlocaldata = deepClone( value );
                        }
                    }, source._localdata, 'beforeChange' );

                    source._localdata.subscribe( function ( value ) {
                        if ( me.suspendKO == false || me.suspendKO == undefined ) {
                            var changeType = "";
                            me._oldrecords = me.records;
                            if ( me._oldlocaldata.length == 0 ) {
                                source.localdata = source._localdata();
                            }

                            if ( me._oldlocaldata.length == 0 ) {
                                changeType = 'change';
                            }
                            else {
                                if ( value ) {
                                    if ( me._oldlocaldata.length == value.length ) {
                                        changeType = 'update';
                                    }
                                    if ( me._oldlocaldata.length > value.length ) {
                                        changeType = 'remove';
                                    }
                                    if ( me._oldlocaldata.length < value.length ) {
                                        changeType = 'add';
                                    }
                                }
                            }
                            me.dataBind( null, changeType );
                        }
                    }, source._localdata, 'change' );

                    me._knockoutdatasource = true;
                }

                source.localdata = localData;
            }
        }
        if ( this._options.autoBind == true ) {
            this.dataBind();
        }
    }

    $.jqx.dataAdapter.prototype = {
        getrecords: function () {
            return this.records;
        },

        beginUpdate: function () {
            this.isUpdating = true;
        },

        endUpdate: function ( refresh ) {
            this.isUpdating = false;
            if ( refresh != false ) {
                if ( this._changedrecords && this._changedrecords.length > 0 ) {
                    this.callBindingUpdate( "update" );
                    this._changedrecords = [];
                }
                else {
                    this.dataBind( null, "" );
                }
            }
        },

        formatDate: function ( value, format, calendar ) {
            var result = $.jqx.dataFormat.formatdate( value, format, calendar );
            return result;
        },

        formatNumber: function ( value, format, calendar ) {
            var result = $.jqx.dataFormat.formatnumber( value, format, calendar );
            return result;
        },

        dataBind: function ( objectuniqueId, collectionChanged ) {
            if ( this.isUpdating == true )
                return;

            var source = this._source;
            if ( !source )
                return;

            if ( source.generatedfields ) {
                source.datafields = null;
                source.generatedfields = null;
            }

            $.jqx.dataFormat.datescache = new Array();
            if ( source.dataFields != null ) {
                source.datafields = source.dataFields;
            }

            if ( source.recordstartindex == undefined ) {
                source.recordstartindex = 0;
            }
            if ( source.recordendindex == undefined ) {
                source.recordendindex = 0;
            }
            if ( source.loadallrecords == undefined ) {
                source.loadallrecords = true;
            }
            if ( source.root == undefined ) source.root = '';
            if ( source.record == undefined ) source.record = '';

            if ( source.sort != undefined ) {
                this.sort = source.sort;
            }

            if ( source.filter != undefined ) {
                this.filter = source.filter;
            }
            else this.filter = null;

            if ( source.sortcolumn != undefined ) {
                this.sortcolumn = source.sortcolumn;
            }

            if ( source.sortdirection != undefined ) {
                this.sortdirection = source.sortdirection;
            }
            if ( source.sortcolumns != undefined ) {
                this.sortcolumns = source.sortcolumns;
            }

            if ( source.sortdirections != undefined ) {
                this.sortdirections = source.sortdirections;
            }

            if ( source.sortcomparer != undefined ) {
                this.sortcomparer = source.sortcomparer;
            }

            this.records = new Array();
            var options = this._options || {};
            this.virtualmode = options.virtualmode != undefined ? options.virtualmode : false;
            this.totalrecords = options.totalrecords != undefined ? options.totalrecords : 0;
            this.pageable = options.pageable != undefined ? options.pageable : false;
            this.pagesize = options.pagesize != undefined ? options.pagesize : 0;
            this.pagenum = options.pagenum != undefined ? options.pagenum : 0;
            this.cachedrecords = options.cachedrecords != undefined ? options.cachedrecords : new Array();
            this.originaldata = new Array();
            this.recordids = new Array();
            this.updaterow = options.updaterow != undefined ? options.updaterow : null;
            this.addrow = options.addrow != undefined ? options.addrow : null;
            this.deleterow = options.deleterow != undefined ? options.deleterow : null;
            this.cache = options.cache != undefined ? options.cache : false;
            this.unboundmode = false;
            if ( source.formatdata != undefined ) {
                options.formatData = source.formatdata;
            }
            if ( source.data != undefined ) {
                if ( options.data == undefined ) {
                    options.data = {};
                }
                $.extend( options.data, source.data );
            }

            if ( source.mapChar != undefined ) {
                source.mapchar = source.mapChar;
            }

            if ( source.mapchar != undefined ) {
                this.mapChar = source.mapchar ? source.mapchar : '>';
            }
            else {
                this.mapChar = options.mapChar ? options.mapChar : '>';
            }

            if ( options.unboundmode || source.unboundmode ) {
                this.unboundmode = options.unboundmode || source.unboundmode;
            }

            if ( source.cache != undefined ) {
                this.cache = source.cache;
            }

            if ( this.koSubscriptions ) {
                for ( var subscription = 0; subscription < this.koSubscriptions.length; subscription++ ) {
                    this.koSubscriptions[ subscription ].dispose();
                }
            }
            this.koSubscriptions = new Array();

            if ( this.pagenum < 0 ) {
                this.pagenum = 0;
            }

            var me = this;

            var datatype = source.datatype;

            if ( source.datatype === 'csv' || source.datatype === 'tab' || source.datatype === 'tsv' || source.datatype == 'text' )
                datatype = 'text';

            var async = options.async != undefined ? options.async : true;

            if ( source.async != undefined ) {
                async = source.async;
            }

            if ( datatype === "xlsx" && source.url ) {
                source.localdata = [];
                datatype = "array";
                if ( window.jqxDataSource ) {
                    var data = new window.jqxDataSource( {
                        dataSource: source.url,
                        async: false,
                        dataFields: source.datafields
                    } );
                    data.notify( function () {
                        source.url = null;
                        source.localdata = data.boundSource;
                        source.datatype = "array";
                        me.dataBind();
                    } );
                }
            }

            switch ( datatype ) {
                case "local":
                case "array":
                case "observablearray":
                case "observableArray":
                default:
                    if ( source.localdata == undefined && source.length ) {
                        source.localdata = new Array();
                        for ( var i = 0; i < source.length; i++ ) {
                            source.localdata[ source.localdata.length ] = source[ i ];
                            source[ i ].uid = i;
                        }
                    }
                    if ( source.beforeprocessing && $.isFunction( source.beforeprocessing ) ) {
                        source.beforeprocessing( source.localdata );
                    }

                    var length = source.localdata.length;
                    this.totalrecords = this.virtualmode ? ( source.totalrecords || length ) : length;

                    if ( this.unboundmode ) {
                        this.totalrecords = this.unboundmode ? ( source.totalrecords || length ) : length;
                        var datafieldslength = source.datafields ? source.datafields.length : 0;
                        if ( datafieldslength > 0 ) {
                            for ( var i = 0; i < this.totalrecords; i++ ) {
                                var record = {};
                                for ( var j = 0; j < datafieldslength; j++ ) {
                                    record[ source.datafields[ j ].name ] = "";
                                }
                                record.uid = i;
                                source.localdata[ source.localdata.length ] = record;
                            }
                        }
                    }

                    if ( this.totalrecords == undefined ) {
                        this.totalrecords = 0;
                    }

                    var datafieldslength = source.datafields ? source.datafields.length : 0;
                    var getrecord = function ( record, datafieldslength ) {
                        var datarow = {};
                        for ( var j = 0; j < datafieldslength; j++ ) {
                            var datafield = source.datafields ? source.datafields[ j ] : {};
                            var value = '';
                            if ( undefined == datafield || datafield == null ) {
                                continue;
                            }

                            if ( datafield.map ) {
                                if ( $.isFunction( datafield.map ) ) {
                                    value = datafield.map( record );
                                }
                                else {
                                    var splitMap = datafield.map.split( me.mapChar );
                                    if ( splitMap.length > 0 ) {
                                        var datarecord = record;
                                        for ( var p = 0; p < splitMap.length; p++ ) {
                                            if ( !datarecord ) continue;
                                            datarecord = datarecord[ splitMap[ p ] ];
                                        }
                                        value = datarecord;
                                    }
                                    else {
                                        value = record[ datafield.map ];
                                    }
                                }

                                if ( value != undefined && value != null ) {
                                    value = value.toString();
                                }
                                else {
                                    if ( value == undefined && value != null ) {
                                        value = '';
                                    }
                                }
                            }
                            var isEmptyString = false;
                            // searches by both selectors when necessary.
                            if ( value == '' ) {
                                isEmptyString = true;
                                value = record[ datafield.name ];
                                if ( value != undefined && value != null ) {
                                    if ( source._localdata && value.subscribe ) {
                                        value = value();
                                    }
                                    else {
                                        if ( datafield.type != "array" ) {
                                            if ( datafield.type === 'date' ) {
                                                if ( value && value instanceof Date ) {
                                                    value = value;
                                                }
                                            }
                                            else {
                                                value = value.toString();
                                            }
                                        }
                                    }
                                }
                            }
                            if ( value == "[object Object]" && datafield.map && isEmptyString ) {
                                value = '';
                            }

                            value = me.getvaluebytype( value, datafield );
                            if ( datafield.displayname != undefined ) {
                                datarow[ datafield.displayname ] = value;
                            }
                            else {
                                datarow[ datafield.name ] = value;
                            }
                        }
                        return datarow;
                    }

                    if ( source._localdata ) {
                        this._changedrecords = [];
                        this.records = new Array();
                        var localdata = source._localdata();

                        $.each( localdata, function ( i, value ) {
                            if ( typeof value === 'string' ) {
                                me.records.push( value );
                            }
                            else {
                                var record = {};
                                var _koindex = 0;
                                var dataObject = this;
                                $.each( this, function ( obj, objvalue ) {
                                    var map = null;
                                    var type = 'string';
                                    var dataFieldName = obj;
                                    if ( datafieldslength > 0 ) {
                                        var hasField = false;
                                        var hasMap = false;
                                        for ( var j = 0; j < datafieldslength; j++ ) {
                                            var datafield = source.datafields[ j ];
                                            if ( datafield != undefined && ( datafield.name == obj ) ) {
                                                hasField = true;
                                                map = datafield.map;
                                                type = datafield.type;
                                                dataFieldName = datafield.name;
                                                break;
                                            }
                                            else if ( datafield != undefined && datafield.map && ( datafield.map.indexOf( obj ) >= 0 ) ) {
                                                hasField = true;
                                                map = datafield.map;
                                                type = datafield.type;
                                                dataFieldName = datafield.name;
                                                hasMap = true;
                                                var value = dataObject[ obj ];
                                                if ( map != null ) {
                                                    var splitMap = map.split( me.mapChar );
                                                    if ( splitMap.length > 0 ) {
                                                        var datarecord = dataObject;
                                                        for ( var p = 0; p < splitMap.length; p++ ) {
                                                            datarecord = datarecord[ splitMap[ p ] ];
                                                        }
                                                        value = datarecord;
                                                    }
                                                    else {
                                                        value = dataObject[ map ];
                                                    }
                                                }

                                                if ( type != 'string' ) {
                                                    value = me.getvaluebytype( value, { type: type } );
                                                }
                                                record[ dataFieldName ] = value;
                                                if ( record[ dataFieldName ] != undefined ) {
                                                    _koindex += record[ dataFieldName ].toString().length + record[ dataFieldName ].toString().substr( 0, 1 );
                                                }
                                            }
                                        }
                                        if ( !hasField ) return true;
                                        if ( hasMap ) return true;
                                    }

                                    var isFunction = $.isFunction( dataObject[ obj ] );
                                    if ( isFunction ) {
                                        var value = dataObject[ obj ]();
                                        if ( type != 'string' ) {
                                            value = me.getvaluebytype( value, { type: type } );
                                        }
                                        record[ obj ] = value;
                                        if ( dataObject[ obj ].subscribe ) {
                                            var recordindex = i;
                                            me.koSubscriptions[ me.koSubscriptions.length ] = dataObject[ obj ].subscribe( function ( value ) {
                                                var _changeindex = recordindex;
                                                record[ obj ] = value;
                                                var changedRecord = { index: _changeindex, oldrecord: record, record: record };
                                                me._changedrecords.push( changedRecord );
                                                if ( me.isUpdating )
                                                    return;

                                                me.callBindingUpdate( "update" );
                                                me._changedrecords = [];
                                                return false;
                                            } );
                                        }
                                    }
                                    else {
                                        var value = dataObject[ obj ];
                                        if ( map != null ) {
                                            var splitMap = map.split( me.mapChar );
                                            if ( splitMap.length > 0 ) {
                                                var datarecord = dataObject;
                                                for ( var p = 0; p < splitMap.length; p++ ) {
                                                    datarecord = datarecord[ splitMap[ p ] ];
                                                }
                                                value = datarecord;
                                            }
                                            else {
                                                value = dataObject[ map ];
                                            }
                                        }

                                        if ( type != 'string' ) {
                                            value = me.getvaluebytype( value, { type: type } );
                                        }
                                        record[ dataFieldName ] = value;
                                        if ( record[ dataFieldName ] != undefined ) {
                                            _koindex += record[ dataFieldName ].toString().length + record[ dataFieldName ].toString().substr( 0, 1 );
                                        }
                                    }
                                } );

                                var recordid = me.getid( source.id, dataObject, i );
                                record.uid = recordid;
                                me.records.push( record );

                                record._koindex = _koindex;
                                if ( me._oldrecords ) {
                                    var _changeindex = me.records.length - 1;
                                    if ( collectionChanged == 'update' ) {
                                        if ( me._oldrecords[ _changeindex ]._koindex != _koindex ) {
                                            var changedRecord = { index: _changeindex, oldrecord: me._oldrecords[ _changeindex ], record: record };
                                            me._changedrecords.push( changedRecord );
                                        }
                                    }
                                }
                            }
                        } );
                        if ( collectionChanged == 'add' ) {
                            var length = me.records.length;
                            for ( var i = 0; i < length; i++ ) {
                                var record = me.records[ i ];
                                var hasOldRecord = false;
                                for ( var p = 0; p < me._oldrecords.length; p++ ) {
                                    if ( me._oldrecords[ p ]._koindex === record._koindex ) {
                                        hasOldRecord = true;
                                        break;
                                    }
                                }
                                if ( !hasOldRecord ) {
                                    me._changedrecords.push( { index: i, oldrecord: null, record: record, position: ( i != 0 ? "last" : "first" ) } );
                                }
                            }
                        }
                        else if ( collectionChanged == 'remove' ) {
                            var length = me._oldrecords.length;
                            for ( var i = 0; i < length; i++ ) {
                                var oldrecord = me._oldrecords[ i ];
                                if ( !me.records[ i ] ) {
                                    me._changedrecords.push( { index: i, oldrecord: oldrecord, record: null } );
                                }
                                else {
                                    if ( me.records[ i ]._koindex != oldrecord._koindex ) {
                                        me._changedrecords.push( { index: i, oldrecord: oldrecord, record: null } );
                                    }
                                }
                            }
                        }
                    }
                    else {
                        if ( !$.isArray( source.localdata ) ) {
                            this.records = new Array();
                            var fields = 0;
                            var generatedfields = new Array();
                            $.each( source.localdata, function ( i ) {
                                var recordid = me.getid( source.id, this, i );
                                if ( datafieldslength == 0 ) {
                                    if ( !( typeof this === "string" || this instanceof String ) ) {
                                        for ( var obj in this ) {
                                            fields++;
                                            var valueType = $.type( this[ obj ] );

                                            generatedfields.push( { name: obj, type: valueType } );
                                        }
                                        datafieldslength = fields;
                                        source.datafields = generatedfields;
                                        source.generatedfields = generatedfields;
                                    }
                                }
                                if ( datafieldslength > 0 ) {
                                    var record = this;
                                    var datarow = getrecord( record, datafieldslength );
                                    datarow.uid = recordid;
                                    me.records[ me.records.length ] = datarow;
                                }
                                else {
                                    this.uid = recordid;
                                    me.records[ me.records.length ] = this;
                                }
                            } );
                        }
                        else {
                            if ( datafieldslength == 0 ) {
                                var fields = 0;
                                var generatedfields = new Array();

                                $.each( source.localdata, function ( i, value ) {
                                    //      var record = $.extend({}, this);
                                    var record = new Object( this );
                                    if ( typeof value === "string" ) {
                                        me.records = source.localdata;
                                        return false;
                                    }
                                    else {
                                        var recordid = me.getid( source.id, record, i );
                                        if ( typeof ( recordid ) === "object" ) {
                                            recordid = i;
                                        }
                                        record.uid = recordid;
                                        if ( i == 0 ) {
                                            for ( var obj in this ) {
                                                fields++;
                                                var valueType = $.type( this[ obj ] );

                                                generatedfields.push( { name: obj, type: valueType } );
                                            }
                                            datafieldslength = fields;
                                            source.datafields = generatedfields;
                                            source.generatedfields = generatedfields;
                                        }
                                        if ( datafieldslength > 0 ) {
                                            var datarow = getrecord( record, datafieldslength );
                                            datarow.uid = recordid;
                                            me.records[ me.records.length ] = datarow;
                                        }
                                        else {
                                            me.records[ me.records.length ] = record;
                                        }
                                    }
                                } );
                            }
                            else {
                                $.each( source.localdata, function ( i ) {
                                    var record = this;
                                    var datarow = getrecord( record, datafieldslength );
                                    var recordid = me.getid( source.id, datarow, i );
                                    if ( typeof ( recordid ) === "object" ) {
                                        recordid = i;
                                    }
                                    //      var record = $.extend({}, datarow);
                                    var record = new Object( datarow );
                                    record.uid = recordid;
                                    me.records[ me.records.length ] = record;
                                } );
                            }
                        }
                    }

                    this.originaldata = source.localdata;
                    this.cachedrecords = this.records;
                    this.addForeignValues( source );
                    if ( options.uniqueDataFields ) {
                        var uniquerecords = this.getUniqueRecords( this.records, options.uniqueDataFields );
                        this.records = uniquerecords;
                        this.cachedrecords = uniquerecords;
                    }

                    if ( options.beforeLoadComplete ) {
                        var newRecords = options.beforeLoadComplete( me.records, this.originaldata );
                        if ( newRecords != undefined ) {
                            me.records = newRecords;
                            me.cachedrecords = newRecords;
                        }
                    }

                    if ( options.autoSort && options.autoSortField ) {
                        var tmpToString = Object.prototype.toString;
                        Object.prototype.toString = ( typeof field == "function" ) ? field : function () { return this[ options.autoSortField ] };
                        me.records.sort( function ( value1, value2 ) {
                            if ( value1 === undefined ) { value1 = null; }
                            if ( value2 === undefined ) { value2 = null; }
                            if ( value1 === null && value2 === null ) {
                                return 0;
                            }
                            if ( value1 === null && value2 !== null ) {
                                return 1;
                            }
                            if ( value1 !== null && value2 === null ) {
                                return -1;
                            }

                            value1 = value1.toString();
                            value2 = value2.toString();
                            if ( value1 === null && value2 === null ) {
                                return 0;
                            }
                            if ( value1 === null && value2 !== null ) {
                                return 1;
                            }
                            if ( value1 !== null && value2 === null ) {
                                return -1;
                            }
                            if ( $.jqx.dataFormat.isNumber( value1 ) && $.jqx.dataFormat.isNumber( value2 ) ) {
                                if ( value1 < value2 ) { return -1; }
                                if ( value1 > value2 ) { return 1; }
                                return 0;
                            }
                            else if ( $.jqx.dataFormat.isDate( value1 ) && $.jqx.dataFormat.isDate( value2 ) ) {
                                if ( value1 < value2 ) { return -1; }
                                if ( value1 > value2 ) { return 1; }
                                return 0;
                            }
                            else if ( !$.jqx.dataFormat.isNumber( value1 ) && !$.jqx.dataFormat.isNumber( value2 ) ) {
                                value1 = String( value1 ).toLowerCase();
                                value2 = String( value2 ).toLowerCase();
                            }

                            try {
                                if ( value1 < value2 ) { return -1; }
                                if ( value1 > value2 ) { return 1; }
                            }
                            catch ( error ) {
                                var er = error;
                            }

                            return 0;
                        } );
                        Object.prototype.toString = tmpToString;
                    }

                    me.loadedData = source.localdata;
                    me.buildHierarchy();

                    if ( $.isFunction( options.loadComplete ) ) {
                        options.loadComplete( source.localdata, me.records );
                    }
                    break;
                case "json":
                case "jsonp":
                case "xml":
                case "xhtml":
                case "script":
                case "text":
                case "ics":
                    {
                        if ( source.localdata != null && !source.url ) {
                            if ( $.isFunction( source.beforeprocessing ) ) {
                                source.beforeprocessing( source.localdata );
                            }
                            if ( source.datatype === "xml" ) {
                                me.loadxml( source.localdata, source.localdata, source );
                            }
                            else if ( datatype === "text" ) {
                                me.loadtext( source.localdata, source );
                            }
                            else if ( datatype === "ics" ) {
                                me.loadics( source.localdata, source );
                            }
                            else {
                                me.loadjson( source.localdata, source.localdata, source );
                            }
                            me.addForeignValues( source );
                            if ( options.uniqueDataFields ) {
                                var uniquerecords = me.getUniqueRecords( me.records, options.uniqueDataFields );
                                me.records = uniquerecords;
                                me.cachedrecords = uniquerecords;
                            }

                            if ( options.beforeLoadComplete ) {
                                var newRecords = options.beforeLoadComplete( me.records, this.originaldata );
                                if ( newRecords != undefined ) {
                                    me.records = newRecords;
                                    me.cachedrecords = newRecords;
                                }
                            }

                            me.loadedData = source.localdata;
                            me.buildHierarchy.call( me );
                            if ( $.isFunction( options.loadComplete ) ) {
                                options.loadComplete( source.localdata, me.records );
                            }
                            me.callBindingUpdate( collectionChanged );
                            return;
                        }

                        var postdata = options.data != undefined ? options.data : {};
                        // call the source object's processdata function.
                        if ( source.processdata ) {
                            source.processdata( postdata );
                        }
                        // call the adapter's process data function.
                        if ( $.isFunction( options.processData ) ) {
                            options.processData( postdata );
                        }

                        // call the adapter's format data function.
                        if ( $.isFunction( options.formatData ) ) {
                            var newpostdata = options.formatData( postdata );
                            if ( newpostdata != undefined ) {
                                postdata = newpostdata;
                            }
                        }

                        var contentType = 'application/x-www-form-urlencoded';
                        if ( options.contentType ) {
                            contentType = options.contentType;
                        }

                        var type = "GET";
                        if ( source.type ) {
                            type = source.type;
                        }

                        if ( options.type ) {
                            type = options.type;
                        }

                        var dataType = datatype;
                        if ( datatype == "ics" ) dataType = "text";
                        if ( source.url && source.url.length > 0 ) {
                            if ( $.isFunction( options.loadServerData ) ) {
                                me._requestData( postdata, source, options );
                            }
                            else {
                                this.xhr = $.jqx.data.ajax( {
                                    dataType: dataType,
                                    cache: this.cache,
                                    type: type,
                                    url: source.url,
                                    async: async,
                                    timeout: source.timeout,
                                    contentType: contentType,
                                    data: postdata,
                                    success: function ( data, status, xhr ) {
                                        if ( $.isFunction( source.beforeprocessing ) ) {
                                            var tmpdata = source.beforeprocessing( data, status, xhr );
                                            if ( tmpdata != undefined ) {
                                                data = tmpdata;
                                            }
                                        }
                                        if ( $.isFunction( options.downloadComplete ) ) {
                                            var tmpdata = options.downloadComplete( data, status, xhr );
                                            if ( tmpdata != undefined ) {
                                                data = tmpdata;
                                            }
                                        }

                                        if ( data == null ) {
                                            me.records = new Array();
                                            me.cachedrecords = new Array();
                                            me.originaldata = new Array();

                                            me.callDownloadComplete();
                                            if ( $.isFunction( options.loadComplete ) ) {
                                                options.loadComplete( new Array() );
                                            }
                                            return;
                                        }

                                        var records = data;
                                        if ( data.records ) {
                                            records = data.records;
                                        }

                                        if ( data.totalrecords != undefined ) {
                                            source.totalrecords = data.totalrecords;
                                        }
                                        else if ( data.totalRecords != undefined ) {
                                            source.totalrecords = data.totalRecords;
                                        }

                                        if ( source.datatype === "xml" ) {
                                            me.loadxml( null, records, source );
                                        }
                                        else if ( datatype === "text" ) {
                                            me.loadtext( records, source );
                                        }
                                        else if ( datatype === "ics" ) {
                                            me.loadics( records, source );
                                        }
                                        else {
                                            me.loadjson( null, records, source );
                                        }

                                        // add foreign values.
                                        me.addForeignValues( source );

                                        if ( options.uniqueDataFields ) {
                                            var uniquerecords = me.getUniqueRecords( me.records, options.uniqueDataFields );
                                            me.records = uniquerecords;
                                            me.cachedrecords = uniquerecords;
                                        }

                                        if ( options.beforeLoadComplete ) {
                                            var newRecords = options.beforeLoadComplete( me.records, data );
                                            if ( newRecords != undefined ) {
                                                me.records = newRecords;
                                                me.cachedrecords = newRecords;
                                            }
                                        }

                                        me.loadedData = data;
                                        me.buildHierarchy.call( me );

                                        me.callDownloadComplete();
                                        if ( $.isFunction( options.loadComplete ) ) {
                                            options.loadComplete( data, status, xhr, me.records );
                                        }
                                    },
                                    error: function ( xhr, status, error ) {
                                        if ( $.isFunction( source.loaderror ) ) { source.loaderror( xhr, status, error ); }
                                        if ( $.isFunction( options.loadError ) ) { options.loadError( xhr, status, error ); }
                                        xhr = null;
                                        me.callDownloadComplete();
                                    },
                                    beforeSend: function ( xhr, settings ) {
                                        if ( $.isFunction( options.beforeSend ) ) { options.beforeSend( xhr, settings ); }
                                        if ( $.isFunction( source.beforesend ) ) { source.beforesend( xhr, settings ); }
                                    }
                                } );
                            }
                        }
                        else {
                            me.buildHierarchy( new Array() );
                            me.callDownloadComplete();
                            if ( $.isFunction( options.loadComplete ) ) {
                                if ( !data ) {
                                    var data = {};
                                }
                                options.loadComplete( data );
                            }
                        }
                    }
                    break;
            }
            this.callBindingUpdate( collectionChanged );
        },

        buildHierarchy: function ( dataRecords ) {
            var source = this._source;
            var hierarchy = new Array();
            if ( !source.datafields ) {
                return;
            }

            if ( source.hierarchy && !source.hierarchy.reservedNames ) {
                source.hierarchy.reservedNames = {
                    leaf: "leaf",
                    parent: "parent",
                    expanded: "expanded",
                    checked: "checked",
                    selected: "selected",
                    level: "level",
                    icon: "icon",
                    data: "data"
                }
            }
            else {
                if ( source.hierarchy ) {
                    var names = source.hierarchy.reservedNames;
                    if ( !names.leaf ) names.leaf = "leaf";
                    if ( !names.parent ) names.parent = "parent";
                    if ( !names.expanded ) names.expanded = "expanded";
                    if ( !names.checked ) names.checked = "checked";
                    if ( !names.selected ) names.selected = "selected";
                    if ( !names.level ) names.level = "level";
                    if ( !names.data ) names.data = "data";
                }
            }

            if ( !source.hierarchy ) {
                return;
            }

            var that = this;
            var names = source.hierarchy.reservedNames;
            if ( source.hierarchy.root ) {
                if ( source.dataType == "xml" ) {
                    var hierarchy = this.getRecordsHierarchy( 'uid', 'parentuid', 'records', null, dataRecords );
                    this.hierarchy = hierarchy;
                    return hierarchy;
                }
                else {
                    this.hierarchy = this.records;
                    var root = source.hierarchy.root;
                    for ( var i = 0; i < this.records.length; i++ ) {
                        var record = this.records[ i ];
                        if ( !record ) {
                            continue;
                        }

                        var addRecords = function ( record ) {
                            if ( source.hierarchy.record ) {
                                record.records = record[ root ][ source.hierarchy.record ];
                            }
                            else {
                                var splitMap = root.split( that.mapChar );
                                var records = null;
                                if ( splitMap.length > 1 ) {
                                    var d = record;
                                    for ( var p = 0; p < splitMap.length; p++ ) {
                                        if ( d != undefined ) {
                                            d = d[ splitMap[ p ] ];
                                        }
                                    }
                                    records = d;
                                }
                                else records = record[ root ];
                                record.records = records;
                            }
                            if ( record.records == null || ( record.records && record.records.length == 0 ) ) {
                                record[ names.leaf ] = true;
                            }
                        }
                        addRecords( record );
                        record[ names.level ] = 0;
                        var recordid = this.getid( source.id, record, i );
                        record.uid = recordid;
                        record[ names.parent ] = null;
                        record[ names.data ] = record;
                        if ( record[ names.expanded ] === undefined ) {
                            record[ names.expanded ] = false;
                        }
                        var drillThrough = function ( parent, records ) {
                            if ( !records ) {
                                parent.records = new Array();
                                return;
                            }

                            for ( var i = 0; i < records.length; i++ ) {
                                var record = records[ i ];
                                if ( !record ) {
                                    continue;
                                }

                                addRecords( record );
                                record[ names.level ] = parent[ names.level ] + 1;
                                record[ names.parent ] = parent;
                                record[ names.data ] = record;
                                var recordid = that.getid( source.id, record, i );
                                if ( recordid == i && source.id == null ) {
                                    record.uid = parent.uid + "_" + recordid;
                                }
                                else {
                                    record.uid = recordid;
                                }

                                if ( record[ names.expanded ] === undefined ) {
                                    record[ names.expanded ] = false;
                                }
                                drillThrough( record, record.records );
                            }
                        }
                        drillThrough( record, record.records );
                    }
                }
                return this.hierarchy;
            }

            if ( source.hierarchy.keyDataField && source.hierarchy.parentDataField ) {
                var hierarchy = this.getRecordsHierarchy( source.hierarchy.keyDataField.name, source.hierarchy.parentDataField.name, 'records', null, dataRecords );
                this.hierarchy = hierarchy;
                return hierarchy;
            }

            if ( source.hierarchy.groupingDataFields ) {
                var groups = new Array();
                for ( var i = 0; i < source.hierarchy.groupingDataFields.length; i++ ) {
                    groups.push( source.hierarchy.groupingDataFields[ i ].name );
                }

                var hierarchy = this.getGroupedRecords( groups, 'records', 'label', null, 'data', null, 'parent', dataRecords );
                this.hierarchy = hierarchy;
                return hierarchy;
            }
        },

        addRecord: function ( record, position, parentID, virtualMode ) {
            var that = this;
            var reservedNames = function () {
                return {
                    leaf: "leaf",
                    parent: "parent",
                    expanded: "expanded",
                    checked: "checked",
                    selected: "selected",
                    level: "level",
                    icon: "icon",
                    data: "data"
                }
            }
            if ( record != undefined ) {
                if ( parentID != undefined ) {
                    if ( this.hierarchy.length > 0 ) {
                        var traverse = function ( records ) {
                            if ( records ) {
                                for ( var i = 0; i < records.length; i++ ) {
                                    var r = records[ i ];
                                    if ( r.uid == parentID ) {
                                        var names = ( that._source && that._source.hierarchy ) ? that._source.hierarchy.reservedNames : null;
                                        if ( names == null ) names = reservedNames();

                                        record[ names.parent ] = r;
                                        record[ names.level ] = r[ names.level ] + 1;

                                        if ( !r.records ) {
                                            r.records = new Array();
                                            r[ names.leaf ] = false;
                                        }
                                        else {
                                            r[ names.leaf ] = false;
                                        }

                                        if ( position == 'last' ) {
                                            r.records.push( record );
                                        }
                                        else if ( typeof position === 'number' && isFinite( position ) ) {
                                            r.records.splice( position, 0, record );
                                        }
                                        else {
                                            r.records.splice( 0, 0, record );
                                        }
                                        return true;
                                    }
                                    if ( r.records ) {
                                        traverse( r.records );
                                    }
                                }
                            }
                        }
                        traverse( this.hierarchy );
                    }
                }
                else {
                    if ( this.hierarchy && this.hierarchy.length >= 0 && ( this._source.hierarchy || virtualMode ) ) {
                        var names = ( that._source && that._source.hierarchy ) ? that._source.hierarchy.reservedNames : null;
                        if ( names == null ) names = reservedNames();

                        record[ names.level ] = 0;

                        if ( position == 'last' ) {
                            this.hierarchy.push( record );
                        }
                        else if ( typeof position === 'number' && isFinite( position ) ) {
                            this.hierarchy.splice( position, 0, record );
                        }
                        else {
                            this.hierarchy.splice( 0, 0, record );
                        }
                    }
                    else {
                        if ( position == 'last' ) {
                            this.records.push( record );
                        }
                        else if ( typeof position === 'number' && isFinite( position ) ) {
                            this.records.splice( position, 0, record );
                        }
                        else {
                            this.records.splice( 0, 0, record );
                        }
                    }
                    return true;
                }
            }
            return false;
        },

        deleteRecord: function ( uid ) {
            var that = this;
            if ( this.hierarchy.length > 0 ) {
                var traverse = function ( records ) {
                    if ( records ) {
                        for ( var i = 0; i < records.length; i++ ) {
                            var r = records[ i ];
                            if ( r.uid == uid ) {
                                records.splice( i, 1 );
                                if ( that.recordids[ uid ] ) {
                                    delete that.recordids[ uid ];
                                }

                                var removeChildren = function ( children ) {
                                    for ( var x = 0; x < children.length; x++ ) {
                                        var uid = children[ x ].uid;
                                        for ( var j = 0; j < that.records.length; j++ ) {
                                            var r = that.records[ j ];
                                            if ( r.uid == uid ) {
                                                that.records.splice( j, 1 );
                                                break;
                                            }
                                        }
                                        if ( children[ x ].records ) {
                                            removeChildren( children[ x ].records );
                                        }
                                    }
                                }
                                if ( r.records ) {
                                    removeChildren( r.records );
                                }
                                for ( var j = 0; j < that.records.length; j++ ) {
                                    var r = that.records[ j ];
                                    if ( r.uid == uid ) {
                                        that.records.splice( j, 1 );
                                        break;
                                    }
                                }
                                return true;
                            }
                            if ( r.records ) {
                                traverse( r.records );
                            }
                        }
                    }
                }
                traverse( this.hierarchy );
            }
            else {
                for ( var i = 0; i < this.records.length; i++ ) {
                    var r = this.records[ i ];
                    if ( r.uid == uid ) {
                        this.records.splice( i, 1 );
                        return true;
                    }
                }
            }
            return false;
        },

        addForeignValues: function ( source ) {
            var me = this;
            var datafieldslength = source.datafields ? source.datafields.length : 0;
            for ( var j = 0; j < datafieldslength; j++ ) {
                var datafield = source.datafields[ j ];
                if ( datafield != undefined ) {
                    if ( datafield.values != undefined ) {
                        if ( datafield.value == undefined ) datafield.value = datafield.name;
                        if ( datafield.values[ 'value' ] == undefined ) {
                            datafield.values[ 'value' ] = datafield.value;
                        }

                        var matchedIDs = new Array();
                        var start, end;
                        if ( me.pageable && me.virtualmode ) {
                            start = me.pagenum * me.pagesize;
                            end = start + me.pagesize;
                            if ( end > me.totalrecords ) {
                                end = me.totalrecords;
                            }
                        }
                        else if ( me.virtualmode ) {
                            start = source.recordstartindex;
                            end = source.recordendindex;
                            if ( end > me.totalrecords ) {
                                end = me.totalrecords;
                            }
                        }
                        else {
                            start = 0;
                            end = me.records.length;
                        }

                        for ( var i = start; i < end; i++ ) {
                            var record = me.records[ i ];
                            var name = datafield.name;
                            var value = record[ datafield.value ];

                            if ( matchedIDs[ value ] != undefined ) {
                                record[ name ] = matchedIDs[ value ];
                            }
                            else {
                                for ( var p = 0; p < datafield[ 'values' ].source.length; p++ ) {
                                    var sourcerecord = datafield.values.source[ p ];
                                    var sourcevalue = sourcerecord[ datafield.values[ 'value' ] ];
                                    if ( sourcevalue == undefined ) {
                                        sourcevalue = sourcerecord.uid;
                                    }
                                    if ( sourcevalue == value ) {
                                        var label = sourcerecord[ datafield.values[ 'name' ] ];
                                        record[ name ] = label;
                                        matchedIDs[ value ] = label;
                                        break;
                                    }
                                }
                            }
                        }
                    }
                    else if ( datafield.value != undefined ) {
                        for ( var i = 0; i < me.records.length; i++ ) {
                            var record = me.records[ i ];
                            record[ datafield.name ] = record[ datafield.value ];
                        }
                    }
                }
            }
        },

        abort: function () {
            if ( this.xhr && this.xhr.readyState != 4 ) {
                this.xhr.abort();
                this.callDownloadComplete();
            }
        },

        _requestData: function ( postdata, source, options ) {
            var me = this;
            var success = function ( requestedData ) {
                if ( requestedData.totalrecords ) {
                    source.totalrecords = requestedData.totalrecords;
                    me.totalrecords = requestedData.totalrecords;
                }
                if ( requestedData.records ) {
                    me.records = requestedData.records;
                    me.cachedrecords = requestedData.records;
                }
                // add foreign values.
                me.addForeignValues( source );

                if ( options.uniqueDataFields ) {
                    var uniquerecords = me.getUniqueRecords( me.records, options.uniqueDataFields );
                    me.records = uniquerecords;
                    me.cachedrecords = uniquerecords;
                }

                if ( options.beforeLoadComplete ) {
                    var newRecords = options.beforeLoadComplete( me.records, requestedData );
                    if ( newRecords != undefined ) {
                        me.records = newRecords;
                        me.cachedrecords = newRecords;
                    }
                }
                for ( var i = 0; i < me.records.length; i++ ) {
                    var record = me.records[ i ];
                    if ( undefined == record ) {
                        continue;
                    }

                    if ( undefined == record.uid ) {
                        record.uid = me.getid( source.id, record, i );
                    }
                }

                me.buildHierarchy.call( me );
                if ( $.isFunction( options.loadComplete ) ) {
                    options.loadComplete( requestedData );
                }
                me.callDownloadComplete();
            }
            options.loadServerData( postdata, source, success );
        },

        getUniqueRecords: function ( records, dataFields ) {
            if ( records && dataFields ) {
                var length = records.length;
                var datafieldslength = dataFields.length;

                var uniqueRecords = new Array();
                var lookupkeys = new Array();
                // loop through all records.
                for ( var urec = 0; urec < length; urec++ ) {
                    var datarow = records[ urec ];
                    var lookupkey = "";
                    if ( datarow == undefined )
                        continue;
                    // build lookup key from the datafield values.
                    for ( var datafieldindex = 0; datafieldindex < datafieldslength; datafieldindex++ ) {
                        var datafield = dataFields[ datafieldindex ];
                        if ( datarow[ datafield ] !== undefined ) {
                            lookupkey += datarow[ datafield ] + "_";
                        }
                    }
                    // add the unique record.
                    if ( !lookupkeys[ lookupkey ] && lookupkey ) {
                        uniqueRecords[ uniqueRecords.length ] = datarow;
                    }
                    // add the lookup key.
                    lookupkeys[ lookupkey ] = true;
                }
            }

            return uniqueRecords;
        },

        getAggregatedData: function ( aggregates, calendar, records, level ) {
            var dataRecords = records;
            if ( !dataRecords ) {
                dataRecords = this.records;
            }
            var data = {};
            var dataValuesByAggregate = new Array();
            var length = dataRecords.length;
            if ( length == 0 ) return;
            if ( length == undefined ) return;
            for ( var i = 0; i < length; i++ ) {
                var record = dataRecords[ i ];
                for ( var j = 0; j < aggregates.length; j++ ) {
                    var aggregate = aggregates[ j ];
                    var value = record[ aggregate.name ];
                    //            if (value === null) continue;
                    if ( aggregate.aggregates ) {
                        data[ aggregate.name ] = data[ aggregate.name ] || {};
                        dataValuesByAggregate[ aggregate.name ] = dataValuesByAggregate[ aggregate.name ] || 0;
                        dataValuesByAggregate[ aggregate.name ]++;
                        var _customCalcFunc = function ( aggObject ) {
                            for ( var obj in aggObject ) {
                                var oldValue = data[ aggregate.name ][ obj ];
                                if ( oldValue == null ) {
                                    data[ aggregate.name ][ obj ] = 0;
                                    oldValue = 0;
                                }
                                if ( $.isFunction( aggObject[ obj ] ) ) {
                                    oldValue = aggObject[ obj ]( oldValue, value, aggregate.name, record, level );
                                }
                                data[ aggregate.name ][ obj ] = oldValue;
                            }
                        }

                        var canParse = parseFloat( value );
                        if ( isNaN( canParse ) ) canParse = false; else canParse = true;
                        if ( canParse )
                            value = parseFloat( value );

                        if ( typeof value === 'number' && isFinite( value ) ) {
                            $.each( aggregate.aggregates, function () {
                                var oldValue = data[ aggregate.name ][ this ];
                                if ( oldValue == null ) {
                                    oldValue = 0;
                                    if ( this == 'min' ) oldValue = 9999999999999;
                                    if ( this == 'max' ) oldValue = -9999999999999;
                                }
                                if ( this == 'sum' || this == 'avg' || this == 'stdev'
                                    || this == 'stdevp' || this == 'var' || this == 'varp' ) {
                                    oldValue += parseFloat( value );
                                }
                                else if ( this == 'product' ) {
                                    if ( i == 0 )
                                        oldValue = parseFloat( value );
                                    else
                                        oldValue *= parseFloat( value );
                                }
                                else if ( this == 'min' ) {
                                    oldValue = Math.min( oldValue, parseFloat( value ) );
                                }
                                else if ( this == 'max' ) {
                                    oldValue = Math.max( oldValue, parseFloat( value ) );
                                }
                                else if ( this == 'count' ) {
                                    oldValue++;
                                }
                                else if ( typeof ( this ) == 'object' ) {
                                    _customCalcFunc( this );
                                    return;
                                }
                                data[ aggregate.name ][ this ] = oldValue;
                            } );
                        }
                        else {
                            $.each( aggregate.aggregates, function () {
                                if ( this == 'min' || this == 'max' || this == 'count' || this == 'product' || this == 'sum'
                                    || this == 'avg' || this == 'stdev'
                                    || this == 'stdevp' || this == 'var' || this == 'varp' ) {
                                    if ( value === null ) return true;

                                    var oldValue = data[ aggregate.name ][ this ];
                                    if ( oldValue == null ) {
                                        oldValue = 0;
                                    }
                                    data[ aggregate.name ][ this ] = oldValue;
                                    return true;
                                }

                                if ( typeof ( this ) == 'object' ) {
                                    _customCalcFunc( this );
                                }
                            } );
                        }
                    }
                }
            }

            for ( var j = 0; j < aggregates.length; j++ ) {
                var aggregate = aggregates[ j ];
                if ( !data[ aggregate.name ] ) {
                    data[ aggregate.name ] = {};
                    $.each( aggregate.aggregates, function ( index ) {
                        data[ aggregate.name ][ this ] = 0;
                    } );
                }

                if ( data[ aggregate.name ][ 'avg' ] != undefined ) {
                    var value = data[ aggregate.name ][ 'avg' ];
                    var dataValues = dataValuesByAggregate[ aggregate.name ];
                    if ( dataValues === 0 || dataValues == undefined ) {
                        data[ aggregate.name ][ 'avg' ] = 0;
                    }
                    else {
                        data[ aggregate.name ][ 'avg' ] = value / dataValues;
                    }
                }
                else if ( data[ aggregate.name ][ 'count' ] != undefined ) {
                    data[ aggregate.name ][ 'count' ] = length;
                }

                // stdev, stdevp, var, varp.
                // stdev - Standard deviation on a sample.
                // varp - Variance on an entire population.
                // var - Variance on a sample.
                if ( data[ aggregate.name ][ 'stdev' ] || data[ aggregate.name ][ 'stdevp' ]
                    || data[ aggregate.name ][ 'var' ] || data[ aggregate.name ][ 'varp' ] ) {
                    $.each( aggregate.aggregates, function ( index ) {
                        if ( this == 'stdev' || this == 'var' || this == 'varp' || this == 'stdevp' ) {
                            var value = data[ aggregate.name ][ this ];
                            var count = length;
                            var average = ( value / length );
                            var sumSq = 0.0;
                            for ( var i = 0; i < length; i++ ) {
                                var record = dataRecords[ i ];
                                var recordvalue = record[ aggregate.name ];
                                sumSq += ( recordvalue - average ) * ( recordvalue - average );
                            }

                            var denominator = ( this == 'stdevp' || this == 'varp' ) ? count : count - 1;
                            if ( denominator == 0 )
                                denominator = 1;

                            if ( this == 'var' || this == 'varp' ) {
                                data[ aggregate.name ][ this ] = sumSq / denominator;
                            }
                            else if ( this == 'stdevp' || this == 'stdev' ) {
                                data[ aggregate.name ][ this ] = Math.sqrt( sumSq / denominator );
                            }
                        }
                    } );
                }

                if ( aggregate.formatStrings ) {
                    $.each( aggregate.aggregates, function ( index ) {
                        var formatString = aggregate.formatStrings[ index ];
                        if ( formatString ) {
                            if ( this == 'min' || this == 'max' || this == 'count' || this == 'product' || this == 'sum'
                                || this == 'avg' || this == 'stdev'
                                || this == 'stdevp' || this == 'var' || this == 'varp' ) {
                                var value = data[ aggregate.name ][ this ];
                                data[ aggregate.name ][ this ] = $.jqx.dataFormat.formatnumber( value, formatString, calendar );
                            }
                            else if ( typeof this == 'object' ) {
                                for ( var obj in this ) {
                                    var value = data[ aggregate.name ][ obj ];
                                    data[ aggregate.name ][ obj ] = $.jqx.dataFormat.formatnumber( value, formatString, calendar );
                                }
                            }
                        }
                    } );
                }
            }
            return data;
        },

        bindDownloadComplete: function ( id, func ) {
            this._downloadComplete[ this._downloadComplete.length ] = { id: id, func: func };

        },

        unbindDownloadComplete: function ( id ) {
            for ( var i = 0; i < this._downloadComplete.length; i++ ) {
                if ( this._downloadComplete[ i ].id == id ) {
                    this._downloadComplete[ i ].func = null;
                    this._downloadComplete.splice( i, 1 );
                    break;
                }
            }
        },

        callDownloadComplete: function () {
            for ( var complete = 0; complete < this._downloadComplete.length; complete++ ) {
                var downloadComplete = this._downloadComplete[ complete ];
                if ( downloadComplete.func != null ) {
                    downloadComplete.func();
                }
            }
        },

        setSource: function ( source ) {
            this._source = source;
        },

        generatekey: function () {
            var S4 = function () {
                return ( ( ( 1 + Math.random() ) * 0x10000 ) | 0 ).toString( 16 ).substring( 1 );
            };
            return ( S4() + S4() + "-" + S4() + "-" + S4() + "-" + S4() + "-" + S4() + S4() + S4() );
        },

        getGroupedRecords: function ( groups, collectionName, groupName, mappingFields, recordName, valueName, parentName, data, startIndex ) {
            var visualRows = 0;
            var self = this;
            if ( !startIndex ) startIndex = 0;
            var groupHashCodes = new Array();
            for ( var iGroupColumn = 0; iGroupColumn < groups.length; iGroupColumn++ ) {
                groupHashCodes[ iGroupColumn ] = self.generatekey();
            }

            if ( !collectionName ) {
                collectionName = 'items';
            }

            if ( !groupName ) {
                groupName = 'group';
            }

            if ( !recordName ) {
                recordName = 'record';
            }

            if ( !parentName ) {
                parentName = 'parentItem';
            }

            if ( undefined === valueName ) {
                valueName = 'value';
            }

            var grouprecords = new Array();
            var grouprecordsindex = 0;
            var hashRowGroups = new Array();
            var groupslength = groups.length;
            var groupsHierarchy = new Array();
            if ( !data ) {
                var data = this.records;
            }

            var dataLength = data.length;

            var itemByRecord = function ( record ) {
                var itemObj = record;
                if ( mappingFields ) {
                    $.each( mappingFields, function () {
                        if ( this.name && this.map ) {
                            itemObj[ this.map ] = itemObj[ this.name ];
                        }
                    } );
                }

                return itemObj;
            }

            for ( var obj = 0; obj < dataLength; obj++ ) {
                var item = itemByRecord( data[ obj ] );
                var id = item[ self.uniqueId ];
                var itemKeysHierarchy = new Array();
                var keys = 0;
                for ( iGroupColumn = 0; iGroupColumn < groupslength; iGroupColumn++ ) {
                    var group = groups[ iGroupColumn ];
                    var value = item[ group ];

                    if ( null == value )
                        continue;

                    itemKeysHierarchy[ keys++ ] = { value: value, hash: groupHashCodes[ iGroupColumn ] };
                }

                if ( itemKeysHierarchy.length != groupslength )
                    break;

                var parentItem = null;

                var lookupKey = "";
                var iLevel = -1;
                for ( var q = 0; q < itemKeysHierarchy.length; q++ ) {
                    iLevel++;
                    var itemKey = itemKeysHierarchy[ q ].value;
                    var columnHash = itemKeysHierarchy[ q ].hash;
                    lookupKey = lookupKey + "_" + columnHash + "_" + itemKey;
                    if ( hashRowGroups[ lookupKey ] != undefined && hashRowGroups[ lookupKey ] != null ) {
                        parentItem = hashRowGroups[ lookupKey ];
                        continue;
                    }
                    if ( parentItem == null ) {
                        parentItem = { level: 0 };
                        parentItem[ parentName ] = null;
                        parentItem[ groupName ] = itemKey;
                        parentItem[ recordName ] = item;
                        if ( item.expanded !== undefined ) {
                            parentItem.expanded = item.expanded;
                        }
                        else {
                            parentItem.expanded = false;
                        }

                        if ( valueName ) {
                            parentItem[ valueName ] = item[ valueName ];
                        }
                        parentItem[ collectionName ] = new Array();
                        var uid = grouprecords.length + startIndex;
                        if ( !this._source.id || typeof item.uid === "number" || isFinite( item.uid ) ) {
                            uid = "Row" + uid;
                        }
                        parentItem.uid = uid;
                        grouprecords[ grouprecordsindex++ ] = parentItem;
                    }
                    else {
                        var subItem = { level: parentItem.level + 1 };
                        subItem[ parentName ] = parentItem;
                        subItem[ groupName ] = itemKey;
                        subItem[ collectionName ] = new Array();
                        subItem[ recordName ] = item;
                        if ( item.expanded !== undefined ) {
                            subItem.expanded = item.expanded;
                        }
                        else {
                            subItem.expanded = false;
                        }

                        if ( valueName ) {
                            subItem[ valueName ] = item[ valueName ];
                        }
                        subItem.uid = parentItem.uid + "_" + parentItem[ collectionName ].length;
                        parentItem[ collectionName ][ parentItem[ collectionName ].length ] = subItem;
                        parentItem = subItem;
                    }

                    hashRowGroups[ lookupKey ] = parentItem;
                }

                if ( item ) {
                    item.leaf = true;
                }

                if ( parentItem != null ) {
                    if ( this._source.id == null ) {
                        if ( undefined == item.uid ) {
                            item.uid = parentItem.uid + "_" + parentItem[ collectionName ].length;
                        }
                        else {
                            if ( item.uid.toString().indexOf( parentItem.uid ) == -1 ) {
                                item.uid = parentItem.uid + "_" + item.uid;
                            }
                        }
                    }
                    item[ parentName ] = parentItem;
                    item.level = parentItem.level + 1;
                    parentItem[ collectionName ][ parentItem[ collectionName ].length ] = item;
                }
                else {
                    if ( undefined == item.uid ) {
                        item.uid = this.generatekey();
                    }
                }
            }
            return grouprecords;
        },

        getRecordsHierarchy: function ( fieldName, parentFieldName, collectionName, mappingFields, dataRecords ) {
            var recordsHierarchy = new Array();
            var flatData = this.records;
            if ( dataRecords ) {
                flatData = dataRecords;
            }

            if ( this.records.length == 0 )
                return null;

            var subItemsName = collectionName != null ? collectionName : "items";
            var items = [];
            var data = flatData;
            var dataLength = data.length;
            var names = ( this._source && this._source.hierarchy ) ? this._source.hierarchy.reservedNames : null;

            var itemByRecord = function ( record ) {
                var itemObj = record;
                if ( mappingFields ) {
                    $.each( mappingFields, function () {
                        if ( this.name && this.map ) {
                            itemObj[ this.map ] = itemObj[ this.name ];
                        }
                    } );
                }

                return itemObj;
            }

            // build hierarchical source.
            for ( var i = 0; i < dataLength; i++ ) {
                var item = $.extend( {}, data[ i ] );
                var parentid = item[ parentFieldName ];
                var id = item[ fieldName ];
                items[ id ] = { parentid: parentid, item: item };
            }

            for ( var i = 0; i < dataLength; i++ ) {
                var item = $.extend( {}, data[ i ] );
                var parentid = item[ parentFieldName ];
                var id = item[ fieldName ];

                if ( items[ parentid ] != undefined ) {
                    var item = { parentid: parentid, item: items[ id ].item };
                    var parentItem = items[ parentid ].item;
                    if ( !parentItem[ subItemsName ] ) {
                        parentItem[ subItemsName ] = [];
                    }
                    var length = parentItem[ subItemsName ].length;
                    var record = item.item;

                    if ( !names ) {
                        if ( record.parent == undefined ) {
                            record.parent = parentItem;
                        }
                    }
                    else {
                        if ( record[ names.parent ] == undefined ) {
                            record[ names.parent ] = parentItem;
                        }
                    }

                    var itemObj = itemByRecord( record );
                    parentItem[ subItemsName ][ length ] = itemObj;
                    items[ parentid ].item = parentItem;
                    items[ id ] = item;
                }
                else {
                    var record = items[ id ].item;
                    if ( !names ) {
                        if ( record.parent == undefined ) {
                            record.parent = null;
                        }
                    }
                    else {
                        if ( record[ names.parent ] == undefined ) {
                            record[ names.parent ] = null;
                        }
                    }

                    var itemObj = itemByRecord( record );
                    if ( !names ) {
                        itemObj.level = 0;
                    }
                    else {
                        itemObj[ names.level ] = 0;
                    }

                    recordsHierarchy[ recordsHierarchy.length ] = itemObj;
                }
            }
            if ( recordsHierarchy.length != 0 ) {
                var updateLevels = function ( level, records ) {
                    for ( var i = 0; i < records.length; i++ ) {
                        if ( !names ) {
                            records[ i ].level = level;
                        }
                        else {
                            records[ i ][ names.level ] = level;
                        }

                        var subRecords = records[ i ][ subItemsName ];
                        if ( subRecords ) {
                            if ( subRecords.length > 0 ) {
                                updateLevels( level + 1, subRecords );
                            }
                            else {
                                if ( !names ) {
                                    records[ i ].leaf = true;
                                }
                                else {
                                    records[ i ][ names.leaf ] = true;
                                }
                            }
                        }
                        else {
                            if ( !names ) {
                                records[ i ].leaf = true;
                            }
                            else {
                                records[ i ][ names.leaf ] = true;
                            }
                        }
                    }
                };
                updateLevels( 0, recordsHierarchy );
            }
            return recordsHierarchy;
        },

        bindBindingUpdate: function ( id, func ) {
            this._bindingUpdate[ this._bindingUpdate.length ] = { id: id, func: func };

        },

        unbindBindingUpdate: function ( id ) {
            for ( var i = 0; i < this._bindingUpdate.length; i++ ) {
                if ( this._bindingUpdate[ i ].id == id ) {
                    this._bindingUpdate[ i ].func = null;
                    this._bindingUpdate.splice( i, 1 );
                    break;
                }
            }
        },

        callBindingUpdate: function ( collectionChanged ) {
            for ( var update = 0; update < this._bindingUpdate.length; update++ ) {
                var bindingUpdate = this._bindingUpdate[ update ];
                if ( bindingUpdate.func != null ) {
                    bindingUpdate.func( collectionChanged );
                }
            }
        },

        getid: function ( id, record, index ) {
            if ( id != null && id.name != undefined ) {
                if ( id.name ) {
                    var result = $( record ).attr( id.name );
                    if ( result != null && result.toString().length > 0 ) {
                        return result;
                    }
                    else if ( id.map ) {
                        try {
                            var result = $( record ).attr( id.map );
                            if ( result != null && result.toString().length > 0 ) {
                                return result;
                            }
                            else if ( $( id.map, record ).length > 0 ) {
                                return $( id.map, record ).text();
                            }
                            else if ( $( id.name, record ).length > 0 ) {
                                return $( id.name, record ).text();
                            }
                        }
                        catch ( error ) {
                            return index;
                        }
                    }
                    return;
                }
            }

            if ( $( id, record ).length > 0 ) {
                return $( id, record ).text();
            }

            if ( id ) {
                if ( id.toString().length > 0 ) {
                    var result = $( record ).attr( id );
                    if ( result != null && result.toString().length > 0 ) {
                        return $.trim( result ).split( " " ).join( "" ).replace( /([ #;?%&,.+*~\':"!^$[\]()=>|\/\\@])/g, '' );
                    }
                    else {
                        var splitMap = id.split( this.mapChar );
                        if ( splitMap.length > 1 ) {
                            var d = record;
                            for ( var p = 0; p < splitMap.length; p++ ) {
                                if ( d != undefined ) {
                                    d = d[ splitMap[ p ] ];
                                }
                            }
                            if ( d != undefined ) {
                                return d;
                            }
                        }
                        else {
                            if ( record[ id ] != undefined ) {
                                return record[ id ];
                            }
                        }
                    }
                }
            }

            return index;
        },

        loadjson: function ( jsondata, data, source ) {
            if ( typeof ( jsondata ) == 'string' ) {
                jsondata = $.parseJSON( jsondata );
            }

            if ( source.root == undefined ) source.root = '';
            if ( source.record == undefined ) source.record = '';

            var jsondata = jsondata || data;
            if ( !jsondata ) {
                jsondata = [];
            }

            var me = this;
            if ( source.root != '' ) {
                var splitMap = source.root.split( me.mapChar );
                if ( splitMap.length > 1 ) {
                    var d = jsondata;
                    for ( var p = 0; p < splitMap.length; p++ ) {
                        if ( d != undefined ) {
                            d = d[ splitMap[ p ] ];
                        }
                    }
                    jsondata = d;
                }
                else {
                    if ( jsondata[ source.root ] !== undefined ) {
                        jsondata = jsondata[ source.root ];
                    }
                    else if ( jsondata[ 0 ] && jsondata[ 0 ][ source.root ] !== undefined ) {
                        jsondata = jsondata[ 0 ][ source.root ];
                    }
                    else {
                        $.each( jsondata, function ( i ) {
                            var root = this;
                            if ( this == source.root ) {
                                jsondata = this;
                                return false;
                            }
                            else if ( this[ source.root ] != undefined ) {
                                jsondata = this[ source.root ];
                            }
                        } );
                    }

                    if ( !jsondata ) {
                        var splitMap = source.root.split( me.mapChar );
                        if ( splitMap.length > 0 ) {
                            var d = jsondata;
                            for ( var p = 0; p < splitMap.length; p++ ) {
                                if ( d != undefined ) {
                                    d = d[ splitMap[ p ] ];
                                }
                            }
                            jsondata = d;
                        }
                    }
                }
            }
            else {
                if ( !jsondata.length ) {
                    for ( var obj in jsondata ) {
                        if ( $.isArray( jsondata[ obj ] ) ) {
                            jsondata = jsondata[ obj ];
                            break;
                        }
                    }
                }
            }

            if ( jsondata != null && jsondata.length == undefined ) {
                jsondata = $.makeArray( jsondata );
            }

            if ( jsondata == null || jsondata == undefined || jsondata == "undefined" || jsondata.length == undefined ) {
                throw new Error( 'jqxDataAdapter: JSON Parse error! Invalid JSON. Please, check your JSON or your jqxDataAdapter initialization!' );
                return;
            }

            if ( jsondata.length == 0 ) {
                this.totalrecords = 0;
                return;
            }

            var length = jsondata.length;
            this.totalrecords = this.virtualmode ? ( source.totalrecords || length ) : length;
            this.records = new Array();
            this.originaldata = new Array();

            var records = this.records;
            var recordsstartindex = !this.pageable ? source.recordstartindex : this.pagesize * this.pagenum;

            this.recordids = new Array();

            if ( source.loadallrecords ) {
                recordsstartindex = 0;
                length = this.totalrecords;
            }

            var dataoffset = 0;
            if ( this.virtualmode ) {
                recordsstartindex = !this.pageable ? source.recordstartindex : this.pagesize * this.pagenum;
                dataoffset = recordsstartindex;
                recordsstartindex = 0;
                length = this.totalrecords;
            }

            var datafieldslength = source.datafields ? source.datafields.length : 0;
            // auto-generate data columns
            if ( datafieldslength == 0 ) {
                var firstrecord = jsondata[ 0 ];
                var datafields = new Array();
                for ( var obj in firstrecord ) {
                    var field = obj;
                    datafields[ datafields.length ] = { name: field };
                }
                source.datafields = datafields;
                source.generatedfields = source.datafields;
                datafieldslength = datafields.length;
            }

            var index = recordsstartindex;
            for ( var i = recordsstartindex; i < length; i++ ) {
                var record = jsondata[ i ];

                if ( record == undefined )
                    break;

                if ( source.record && source.record != '' ) {
                    record = record[ source.record ];
                    if ( record == undefined )
                        continue;
                }

                var recordid = this.getid( source.id, record, i );
                if ( typeof ( recordid ) === "object" ) {
                    recordid = i;
                }

                if ( !this.recordids[ recordid ] ) {
                    this.recordids[ recordid ] = record;
                    var datarow = {};

                    for ( var j = 0; j < datafieldslength; j++ ) {
                        var datafield = source.datafields[ j ];
                        var value = '';
                        if ( undefined == datafield || datafield == null ) {
                            continue;
                        }

                        if ( datafield.map ) {
                            if ( $.isFunction( datafield.map ) ) {
                                value = datafield.map( record );
                            }
                            else {
                                var splitMap = datafield.map.split( me.mapChar );
                                if ( splitMap.length > 0 ) {
                                    var datarecord = record;
                                    for ( var p = 0; p < splitMap.length; p++ ) {
                                        if ( datarecord != undefined ) {
                                            datarecord = datarecord[ splitMap[ p ] ];
                                        }
                                    }
                                    value = datarecord;
                                }
                                else {
                                    value = record[ datafield.map ];
                                }
                            }

                            if ( value != undefined && value != null ) {
                                value = this.getvaluebytype( value, datafield );
                            }
                            else if ( value == undefined && value != null ) {
                                value = '';
                            }
                        }

                        // searches by both selectors when necessary.
                        if ( value == '' && !datafield.map ) {
                            value = record[ datafield.name ];
                            if ( value == undefined && value != null ) {
                                value = '';
                            }
                            // the datafield.value allows you to load values like: "Nombre":{"#text":"FASE 1"}, where the datafield is Nombre, the value is object.
                            // If the datafield.value is "#text", the value that will be loaded will be "FASE 1".
                            if ( datafield.value != undefined ) {
                                if ( value != undefined ) {
                                    var tmpvalue = value[ datafield.value ];
                                    if ( tmpvalue != undefined ) {
                                        value = tmpvalue;
                                    }
                                }
                            }
                        }

                        value = this.getvaluebytype( value, datafield );
                        if ( datafield.displayname != undefined ) {
                            datarow[ datafield.displayname ] = value;
                        }
                        else {
                            datarow[ datafield.name ] = value;
                        }

                        if ( datafield.type === "array" ) {
                            var updateValues = function ( records ) {
                                if ( !records ) return;
                                for ( var t = 0; t < records.length; t++ ) {
                                    var record = records[ t ];
                                    if ( !record ) {
                                        continue;
                                    }

                                    for ( var c = 0; c < datafieldslength; c++ ) {
                                        var datafield = source.datafields[ c ];
                                        var value = '';
                                        if ( undefined == datafield || datafield == null ) {
                                            continue;
                                        }

                                        if ( datafield.map ) {
                                            if ( $.isFunction( datafield.map ) ) {
                                                value = datafield.map( record );
                                            }
                                            else {
                                                var splitMap = datafield.map.split( me.mapChar );
                                                if ( splitMap.length > 0 ) {
                                                    var datarecord = record;
                                                    for ( var p = 0; p < splitMap.length; p++ ) {
                                                        if ( datarecord != undefined ) {
                                                            datarecord = datarecord[ splitMap[ p ] ];
                                                        }
                                                    }
                                                    value = datarecord;
                                                }
                                                else {
                                                    value = record[ datafield.map ];
                                                }
                                            }

                                            if ( value != undefined && value != null ) {
                                                value = this.getvaluebytype( value, datafield );
                                            }
                                            else if ( value == undefined && value != null ) {
                                                value = '';
                                            }
                                        }

                                        // searches by both selectors when necessary.
                                        if ( value == '' && !datafield.map ) {
                                            value = record[ datafield.name ];
                                            if ( value == undefined && value != null ) {
                                                value = '';
                                            }
                                            // the datafield.value allows you to load values like: "Nombre":{"#text":"FASE 1"}, where the datafield is Nombre, the value is object.
                                            // If the datafield.value is "#text", the value that will be loaded will be "FASE 1".
                                            if ( datafield.value != undefined ) {
                                                if ( value != undefined ) {
                                                    var tmpvalue = value[ datafield.value ];
                                                    if ( tmpvalue != undefined ) {
                                                        value = tmpvalue;
                                                    }
                                                }
                                            }
                                        }

                                        value = this.getvaluebytype( value, datafield );
                                        if ( datafield.displayname != undefined ) {
                                            record[ datafield.displayname ] = value;
                                        }
                                        else {
                                            record[ datafield.name ] = value;
                                        }
                                        if ( datafield.type === "array" ) {
                                            updateValues.call( this, value );
                                        }
                                    }
                                }
                            }
                            updateValues.call( this, value );
                        }
                    }

                    if ( source.recordendindex <= 0 || recordsstartindex < source.recordendindex ) {
                        //      records[dataoffset + index] = $.extend({}, datarow);
                        records[ dataoffset + index ] = new Object( datarow );
                        records[ dataoffset + index ].uid = recordid;

                        this.originaldata[ dataoffset + index ] = new Object( records[ i ] );

                        //     this.originaldata[dataoffset + index] = $.extend({}, records[i]);
                        index++;
                    }
                }
            }
            this.records = records;
            this.cachedrecords = this.records;
        },

        loadxml: function ( xmldata, data, source ) {
            if ( typeof ( xmldata ) == 'string' ) {
                xmldata = data = $( $.parseXML( xmldata ) );
                xmldata = null;
            }

            if ( source.root == undefined ) source.root = '';
            if ( source.record == undefined ) source.record = '';


            var xmldata;

            if ( $.jqx.browser.msie && data ) {
                if ( data.xml != undefined ) {
                    xmldata = $( source.root + " " + source.record, $.parseXML( data.xml ) );
                }
                else {
                    xmldata = xmldata || $( source.root + " " + source.record, data );
                }
            }
            else xmldata = xmldata || $( source.root + " " + source.record, data );

            if ( !xmldata ) {
                xmldata = [];
            }

            var length = xmldata.length;
            if ( xmldata.length == 0 ) {
                return;
            }

            this.totalrecords = this.virtualmode ? ( source.totalrecords || length ) : length;
            this.records = new Array();
            this.originaldata = new Array();

            var records = this.records;
            var recordsstartindex = !this.pageable ? source.recordstartindex : this.pagesize * this.pagenum;

            this.recordids = new Array();

            if ( source.loadallrecords ) {
                recordsstartindex = 0;
                length = this.totalrecords;
            }

            var dataoffset = 0;
            if ( this.virtualmode ) {
                recordsstartindex = !this.pageable ? source.recordstartindex : this.pagesize * this.pagenum;
                dataoffset = recordsstartindex;
                recordsstartindex = 0;
                length = this.totalrecords;
            }

            var datafieldslength = source.datafields ? source.datafields.length : 0;
            // auto-generate data columns
            if ( datafieldslength == 0 ) {
                var firstrecord = xmldata[ 0 ];
                var datafields = new Array();
                for ( var obj in firstrecord ) {
                    var field = obj;
                    datafields[ datafields.length ] = { name: field };
                }
                source.datafields = datafields;
                source.generatedfields = source.datafields;

                datafieldslength = datafields.length;
            }

            var p = recordsstartindex;
            var hasArray = false;
            for ( var i = recordsstartindex; i < length; i++ ) {
                var record = xmldata[ i ];
                if ( record == undefined )
                    break;

                var recordid = this.getid( source.id, record, i );
                if ( !this.recordids[ recordid ] ) {
                    this.recordids[ recordid ] = record;
                    var datarow = {};

                    var multiLevel = false;
                    if ( source.hierarchy && source.hierarchy.root ) {
                        multiLevel = true;
                    }

                    for ( var j = 0; j < datafieldslength; j++ ) {
                        var datafield = source.datafields[ j ];
                        var value = '';
                        if ( undefined == datafield || datafield == null ) {
                            continue;
                        }

                        if ( datafield.map ) {
                            if ( $.isFunction( datafield.map ) ) {
                                value = datafield.map( record );
                            }
                            else {
                                var attributeStartIndex = datafield.map.indexOf( '[' );
                                if ( attributeStartIndex < 0 ) {
                                    value = $( datafield.map, record );
                                    if ( value.length == 1 ) value = value.text();
                                    else {
                                        hasArray = true;
                                        var subArray = new Array();
                                        for ( var f = 0; f < value.length; f++ ) {
                                            subArray.push( $( value[ f ] ).text() );
                                        }
                                        value = subArray;
                                        if ( multiLevel && subArray.length > 0 ) {
                                            value = subArray[ 0 ];
                                        }
                                    }
                                }
                                else {
                                    var submap = datafield.map.substring( 0, attributeStartIndex - 1 );
                                    var attributeEndIndex = datafield.map.indexOf( ']' );
                                    var attribute = datafield.map.substring( attributeStartIndex + 1, attributeEndIndex );
                                    value = $( submap, record ).attr( attribute );
                                    if ( value == undefined ) {
                                        value = $( record ).attr( attribute );
                                    }

                                    if ( value == undefined ) value = '';
                                }
                                if ( value == '' ) {
                                    value = $( record ).attr( datafield.map );
                                    if ( value == undefined ) value = '';
                                }
                            }
                        }
                        // searches by both selectors when necessary.
                        if ( value == '' ) {
                            value = $( datafield.name, record );
                            if ( value.length == 1 ) value = value.text();
                            else {
                                var subArray = new Array();
                                for ( var f = 0; f < value.length; f++ ) {
                                    subArray.push( $( value[ f ] ).text() );
                                }
                                value = subArray;
                                if ( multiLevel && subArray.length > 0 ) {
                                    value = subArray[ 0 ];
                                }
                            }

                            if ( value == '' ) {
                                value = $( record ).attr( datafield.name );
                                if ( value == undefined ) value = '';
                            }
                            if ( value == '' ) {
                                if ( record.nodeName && record.nodeName == datafield.name && record.firstChild ) {
                                    value = $( record.firstChild ).text();
                                }
                            }
                        }

                        var originalvalue = value;
                        value = this.getvaluebytype( value, datafield );
                        if ( datafield.displayname != undefined ) {
                            datarow[ datafield.displayname ] = value;
                        }
                        else {
                            datarow[ datafield.name ] = value;
                        }
                    }
                    if ( source.recordendindex <= 0 || recordsstartindex < source.recordendindex ) {
                        records[ dataoffset + p ] = $.extend( {}, datarow );
                        records[ dataoffset + p ].uid = recordid;

                        this.originaldata[ dataoffset + p ] = $.extend( {}, records[ i ] );
                        p++;
                    }
                }
            }

            if ( source.hierarchy && source.hierarchy.root ) {
                for ( var i = recordsstartindex; i < length; i++ ) {
                    var record = xmldata[ i ];
                    var dataRecord = records[ i ];

                    if ( $( record ).parent().length > 0 ) {
                        var recordid = this.getid( source.id, $( record ).parents( source.hierarchy.record + ":first" ) );
                        dataRecord.parentuid = recordid;
                    }
                    else {
                        dataRecord.parentuid = null;
                    }
                }
            }

            this.records = records;
            this.cachedrecords = this.records;
        },

        loadics: function ( data, source ) {
            if ( data == null ) {
                return;
            }

            var rowDelimiter = source.rowDelimiter || this.rowDelimiter || '\n';
            var rows = data.split( rowDelimiter );
            var length = rows.length;
            var rowsWithNewRowDelimiter = data.split( '\r' );
            if ( length == 1 && rowsWithNewRowDelimiter.length > 1 ) {
                rows = rowsWithNewRowDelimiter;
                length = rows.length;
            }
            this.records = new Array();
            this.originaldata = new Array();

            var records = this.records;
            this.recordids = new Array();

            var dataoffset = 0;

            var stringToDate = function ( until ) {
                var re = /^(\d{4})(\d{2})(\d{2})(T(\d{2})(\d{2})(\d{2})Z)?$/;
                var bits = re.exec( until );
                if ( !bits ) {
                    throw new Error( 'Invalid UNTIL value: ' + until )
                }
                return new Date(
                    Date.UTC( bits[ 1 ],
                        bits[ 2 ] - 1,
                        bits[ 3 ],
                        bits[ 5 ] || 0,
                        bits[ 6 ] || 0,
                        bits[ 7 ] || 0
                    ) );
            }

            for ( var i = 0; i < length; i++ ) {
                var record = rows[ i ];
                if ( record == "BEGIN:VEVENT" ) {
                    var appointment = {};
                    continue;
                }

                if ( record.indexOf( "SUMMARY" ) >= 0 ) {
                    appointment.SUMMARY = record.substring( record.indexOf( "SUMMARY" ) + 8 );
                    continue;
                }
                if ( record.indexOf( "LOCATION" ) >= 0 ) {
                    appointment.LOCATION = record.substring( record.indexOf( "LOCATION" ) + 9 );
                    continue;
                }
                if ( record.indexOf( "DESCRIPTION" ) >= 0 ) {
                    appointment.DESCRIPTION = record.substring( record.indexOf( "DESCRIPTION" ) + 12 );
                    continue;
                }
                if ( record.indexOf( "RRULE" ) >= 0 ) {
                    appointment.RRULE = record.substring( record.indexOf( "RRULE" ) + 6 );
                    continue;
                }
                if ( record.indexOf( "EXDATE" ) >= 0 ) {
                    var exDate = record.substring( record.indexOf( "EXDATE" ) + 7 );
                    appointment.EXDATE = exDate;
                    continue;
                }
                if ( record.indexOf( "DTEND" ) >= 0 ) {
                    appointment.DTEND = stringToDate( record.substring( record.indexOf( "DTEND" ) + 6 ) );
                    continue;
                }
                if ( record.indexOf( "DTSTART" ) >= 0 ) {
                    appointment.DTSTART = stringToDate( record.substring( record.indexOf( "DTSTART" ) + 8 ) );
                    continue;
                }
                if ( record.indexOf( "UID" ) >= 0 ) {
                    appointment.uid = appointment.UID = record.substring( record.indexOf( "UID" ) + 4 );
                    continue;
                }
                if ( record.indexOf( "STATUS" ) >= 0 ) {
                    appointment.STATUS = record.substring( record.indexOf( "STATUS" ) + 7 );
                    continue;
                }
                if ( record == "END:VEVENT" ) {
                    records.push( appointment );
                    continue;
                }
            }
            this.records = records;
            this.cachedrecords = this.records;
        },

        loadtext: function ( data, source ) {
            if ( data == null ) {
                return;
            }

            var rowDelimiter = source.rowDelimiter || this.rowDelimiter || '\n';
            var rows = data.split( rowDelimiter );
            var length = rows.length;
            var rowsWithNewRowDelimiter = data.split( '\r' );
            if ( length == 1 && rowsWithNewRowDelimiter.length > 1 ) {
                rows = rowsWithNewRowDelimiter;
                length = rows.length;
            }
            this.totalrecords = this.virtualmode ? ( source.totalrecords || length ) : length;
            this.records = new Array();
            this.originaldata = new Array();

            var records = this.records;
            var recordsstartindex = !this.pageable ? source.recordstartindex : this.pagesize * this.pagenum;

            this.recordids = new Array();

            if ( source.loadallrecords ) {
                recordsstartindex = 0;
                length = this.totalrecords;
            }

            var dataoffset = 0;
            if ( this.virtualmode ) {
                recordsstartindex = !this.pageable ? source.recordstartindex : this.pagesize * this.pagenum;
                dataoffset = recordsstartindex;
                recordsstartindex = 0;
                length = this.totalrecords;
            }

            var datafieldslength = source.datafields.length;
            var columnDelimiter = source.columnDelimiter || this.columnDelimiter;
            if ( !columnDelimiter )
                columnDelimiter = ( source.datatype === 'tab' || source.datatype === 'tsv' ) ? '\t' : ',';

            for ( var i = recordsstartindex; i < length; i++ ) {
                var record = rows[ i ];
                var recordid = null;
                if ( !this.recordids[ recordid ] ) {
                    if ( source.id == null ) {
                        recordid = i;
                        this.recordids[ recordid ] = record;
                    }

                    var datarow = {};
                    var columns = rows[ i ].split( columnDelimiter );

                    for ( var j = 0; j < datafieldslength; j++ ) {
                        if ( j >= columns.length )
                            continue;
                        var datafield = source.datafields[ j ];

                        var value = columns[ j ];
                        if ( datafield.map && $.isFunction( datafield.map ) ) {
                            value = datafield.map( record );
                        }

                        if ( datafield.type ) {
                            value = this.getvaluebytype( value, datafield );
                        }

                        var key = datafield.map || datafield.name || j.toString();
                        datarow[ key ] = value;
                        if ( source.id != null ) {
                            if ( source.id === datafield.name ) {
                                recordid = value;
                                this.recordids[ recordid ] = record;
                            }
                        }
                    }
                    if ( recordid == null ) {
                        recordid = i;
                    }

                    records[ dataoffset + i ] = $.extend( {}, datarow );
                    records[ dataoffset + i ].uid = recordid;

                    this.originaldata[ dataoffset + i ] = $.extend( {}, records[ i ] );
                }
            }
            this.records = records;
            this.cachedrecords = this.records;
        },

        getvaluebytype: function ( value, datafield ) {
            var originalvalue = value;
            if ( value == null ) return value;
            if ( $.isArray( value ) && datafield.type != "array" ) {
                for ( var t = 0; t < value.length; t++ ) {
                    value[ t ] = this.getvaluebytype( value[ t ], datafield );
                }
                return value;
            }

            if ( datafield.type == 'date' ) {
                if ( value == "NaN" ) {
                    value = "";
                }
                else {
                    if ( value && value instanceof Date ) {
                        return value;
                    }

                    var tmpvalue = new Date( value );

                    if ( typeof value == 'string' ) {
                        if ( datafield.format ) {
                            var newtmpvalue = $.jqx.dataFormat.parsedate( value, datafield.format );
                            if ( newtmpvalue != null ) {
                                tmpvalue = newtmpvalue;
                            }
                        }
                    }

                    if ( tmpvalue.toString() == 'NaN' || tmpvalue.toString() == "Invalid Date" ) {
                        if ( $.jqx.dataFormat ) {
                            value = $.jqx.dataFormat.tryparsedate( value );
                        }
                        else value = tmpvalue;
                    }
                    else {
                        value = tmpvalue;
                    }

                    if ( value == null ) {
                        value = originalvalue;
                    }
                }
            }
            else if ( datafield.type == 'float' || datafield.type == 'number' || datafield.type == 'decimal' ) {
                if ( value == "NaN" ) value = "";
                else {
                    var value = parseFloat( value );
                    if ( isNaN( value ) ) {
                        value = originalvalue;
                    }
                }
            }
            else if ( datafield.type == 'int' || datafield.type == 'integer' ) {
                var value = parseInt( value );
                if ( isNaN( value ) ) {
                    value = originalvalue;
                }
            }
            else if ( datafield.type == 'bool' || datafield.type == 'boolean' ) {
                if ( value != null ) {
                    if ( value.toLowerCase != undefined ) {
                        if ( value.toLowerCase() == 'false' ) {
                            value = false;
                        }
                        else if ( value.toLowerCase() == 'true' ) {
                            value = true;
                        }
                    }
                }

                if ( value == 1 ) {
                    value = true;
                }
                else if ( value == 0 && value !== "" ) {
                    value = false;
                }
                else value = '';
            }

            return value;
        }
    }

    $.jqx.dataFormat = {};

    $.extend( $.jqx.dataFormat, {
        regexTrim: /^\s+|\s+$/g,
        regexInfinity: /^[+-]?infinity$/i,
        regexHex: /^0x[a-f0-9]+$/i,
        regexParseFloat: /^[+-]?\d*\.?\d*(e[+-]?\d+)?$/,
        toString: Object.prototype.toString,

        isBoolean: function ( value ) {
            return typeof value === 'boolean';
        },

        isObject: function ( value ) {
            return ( value && ( typeof value === 'object' || $.isFunction( value ) ) ) || false;
        },

        isDate: function ( value ) {
            return value instanceof Date;
        },

        arrayIndexOf: function ( array, item ) {
            if ( array.indexOf ) {
                return array.indexOf( item );
            }
            for ( var i = 0, length = array.length; i < length; i++ ) {
                if ( array[ i ] === item ) {
                    return i;
                }
            }
            return -1;
        },

        isString: function ( value ) {
            return typeof value === 'string';
        },

        isNumber: function ( value ) {
            return typeof value === 'number' && isFinite( value );
        },

        isNull: function ( value ) {
            return value === null;
        },

        isUndefined: function ( value ) {
            return typeof value === 'undefined';
        },

        isValue: function ( value ) {
            return ( this.isObject( value ) || this.isString( value ) || this.isNumber( value ) || this.isBoolean( value ) );
        },

        isEmpty: function ( value ) {
            if ( !this.isString( value ) && this.isValue( value ) ) {
                return false;
            } else if ( !this.isValue( value ) ) {
                return true;
            }
            value = $.trim( value ).replace( /\&nbsp\;/ig, '' ).replace( /\&#160\;/ig, '' );
            return value === "";
        },

        startsWith: function ( value, pattern ) {
            return value.indexOf( pattern ) === 0;
        },

        endsWith: function ( value, pattern ) {
            return value.substr( value.length - pattern.length ) === pattern;
        },

        trim: function ( value ) {
            return ( value + "" ).replace( this.regexTrim, "" );
        },

        isArray: function ( obj ) {
            return this.toString.call( obj ) === "[object Array]";
        },

        defaultcalendar: function () {
            var calendar = {
                // separator of parts of a date (e.g. '/' in 11/05/1955)
                '/': "/",
                // separator of parts of a time (e.g. ':' in 05:44 PM)
                ':': ":",
                // the first day of the week (0 = Sunday, 1 = Monday, etc)
                firstDay: 0,
                days: {
                    // full day names
                    names: [ "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday" ],
                    // abbreviated day names
                    namesAbbr: [ "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" ],
                    // shortest day names
                    namesShort: [ "Su", "Mo", "Tu", "We", "Th", "Fr", "Sa" ]
                },
                months: {
                    // full month names (13 months for lunar calendards -- 13th month should be "" if not lunar)
                    names: [ "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December", "" ],
                    // abbreviated month names
                    namesAbbr: [ "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", "" ]
                },
                // AM and PM designators in one of these forms:
                // The usual view, and the upper and lower case versions
                //      [standard,lowercase,uppercase]
                // The culture does not use AM or PM (likely all standard date formats use 24 hour time)
                //      null
                AM: [ "AM", "am", "AM" ],
                PM: [ "PM", "pm", "PM" ],
                eras: [
                    // eras in reverse chronological order.
                    // name: the name of the era in this culture (e.g. A.D., C.E.)
                    // start: when the era starts in ticks (gregorian, gmt), null if it is the earliest supported era.
                    // offset: offset in years from gregorian calendar
                    { "name": "A.D.", "start": null, "offset": 0 }
                ],
                twoDigitYearMax: 2029,
                patterns: {
                    // short date pattern
                    d: "M/d/yyyy",
                    // long date pattern
                    D: "dddd, MMMM dd, yyyy",
                    // short time pattern
                    t: "h:mm tt",
                    // long time pattern
                    T: "h:mm:ss tt",
                    // long date, short time pattern
                    f: "dddd, MMMM dd, yyyy h:mm tt",
                    // long date, long time pattern
                    F: "dddd, MMMM dd, yyyy h:mm:ss tt",
                    // month/day pattern
                    M: "MMMM dd",
                    // month/year pattern
                    Y: "yyyy MMMM",
                    // S is a sortable format that does not vary by culture
                    S: "yyyy\u0027-\u0027MM\u0027-\u0027dd\u0027T\u0027HH\u0027:\u0027mm\u0027:\u0027ss",
                    // formatting of dates in MySQL DataBases
                    ISO: "yyyy-MM-dd hh:mm:ss",
                    ISO2: "yyyy-MM-dd HH:mm:ss",
                    d1: "dd.MM.yyyy",
                    d2: "dd-MM-yyyy",
                    d3: "MM-dd-yyyy",
                    zone1: "yyyy-MM-ddTHH:mm:ss-HH:mm",
                    zone2: "yyyy-MM-ddTHH:mm:ss+HH:mm",
                    custom: "yyyy-MM-ddTHH:mm:ss.fff",
                    custom2: "yyyy-MM-dd HH:mm:ss.fff"
                },
                percentsymbol: "%",
                currencysymbol: "$",
                currencysymbolposition: "before",
                decimalseparator: '.',
                thousandsseparator: ','
            }
            return calendar;
        },

        expandFormat: function ( calendar, format ) {
            // expands unspecified or single character date formats into the full pattern.
            format = format || "F";
            var pattern,
                patterns = calendar.patterns,
                len = format.length;
            if ( len === 1 ) {
                pattern = patterns[ format ];
                if ( !pattern ) {
                    throw "Invalid date format string '" + format + "'.";
                }
                format = pattern;
            }
            else if ( len === 2 && format.charAt( 0 ) === "%" ) {
                // %X escape format -- intended as a custom format string that is only one character, not a built-in format.
                format = format.charAt( 1 );
            }
            return format;
        },

        getEra: function ( date, eras ) {
            if ( !eras ) return 0;
            if ( typeof date === 'string' ) {
                return 0;
            }

            var start, ticks = date.getTime();
            for ( var i = 0, l = eras.length; i < l; i++ ) {
                start = eras[ i ].start;
                if ( start === null || ticks >= start ) {
                    return i;
                }
            }
            return 0;
        },

        toUpper: function ( value ) {
            // 'he-IL' has non-breaking space in weekday names.
            return value.split( "\u00A0" ).join( ' ' ).toUpperCase();
        },

        toUpperArray: function ( arr ) {
            var results = [];
            for ( var i = 0, l = arr.length; i < l; i++ ) {
                results[ i ] = this.toUpper( arr[ i ] );
            }
            return results;
        },

        getEraYear: function ( date, cal, era, sortable ) {
            var year = date.getFullYear();
            if ( !sortable && cal.eras ) {
                // convert normal gregorian year to era-shifted gregorian
                // year by subtracting the era offset
                year -= cal.eras[ era ].offset;
            }
            return year;
        },

        toUpper: function ( value ) {
            if ( value ) {
                return value.toUpperCase();
            }
            return "";
        },

        getDayIndex: function ( cal, value, abbr ) {
            var ret,
                days = cal.days,
                upperDays = cal._upperDays;
            if ( !upperDays ) {
                cal._upperDays = upperDays = [
                    this.toUpperArray( days.names ),
                    this.toUpperArray( days.namesAbbr ),
                    this.toUpperArray( days.namesShort )
                ];
            }
            value = value.toUpperCase();
            if ( abbr ) {
                ret = this.arrayIndexOf( upperDays[ 1 ], value );
                if ( ret === -1 ) {
                    ret = this.arrayIndexOf( upperDays[ 2 ], value );
                }
            }
            else {
                ret = this.arrayIndexOf( upperDays[ 0 ], value );
            }
            return ret;
        },

        getMonthIndex: function ( cal, value, abbr ) {
            var months = cal.months,
                monthsGen = cal.monthsGenitive || cal.months,
                upperMonths = cal._upperMonths,
                upperMonthsGen = cal._upperMonthsGen;
            if ( !upperMonths ) {
                cal._upperMonths = upperMonths = [
                    this.toUpperArray( months.names ),
                    this.toUpperArray( months.namesAbbr )
                ];
                cal._upperMonthsGen = upperMonthsGen = [
                    this.toUpperArray( monthsGen.names ),
                    this.toUpperArray( monthsGen.namesAbbr )
                ];
            }
            value = this.toUpper( value );
            var i = this.arrayIndexOf( abbr ? upperMonths[ 1 ] : upperMonths[ 0 ], value );
            if ( i < 0 ) {
                i = this.arrayIndexOf( abbr ? upperMonthsGen[ 1 ] : upperMonthsGen[ 0 ], value );
            }
            return i;
        },

        appendPreOrPostMatch: function ( preMatch, strings ) {
            // appends pre- and post- token match strings while removing escaped characters.
            // Returns a single quote count which is used to determine if the token occurs
            // in a string literal.
            var quoteCount = 0,
                escaped = false;
            for ( var i = 0, il = preMatch.length; i < il; i++ ) {
                var c = preMatch.charAt( i );
                switch ( c ) {
                    case '\'':
                        if ( escaped ) {
                            strings.push( "'" );
                        }
                        else {
                            quoteCount++;
                        }
                        escaped = false;
                        break;
                    case '\\':
                        if ( escaped ) {
                            strings.push( "\\" );
                        }
                        escaped = !escaped;
                        break;
                    default:
                        strings.push( c );
                        escaped = false;
                        break;
                }
            }
            return quoteCount;
        },

        getTokenRegExp: function () {
            // regular expression for matching date and time tokens in format strings.
            return /\/|dddd|ddd|dd|d|MMMM|MMM|MM|M|yyyy|yy|y|hh|h|HH|H|mm|m|ss|s|tt|t|fff|ff|f|zzz|zz|z|gg|g/g;
        },

        formatlink: function ( value, format ) {
            var target = '';
            if ( format && format.target ) { target = 'target=' + format.target; }
            if ( target != '' ) {
                return "<a " + target + " href=\"" + value + "\">" + value + "</a>";
            }
            return "<a href=\"" + value + "\">" + value + "</a>";
        },

        formatemail: function ( value ) {
            return "<a href=\"mailto:" + value + "\">" + value + "</a>";
        },

        formatNumber: function ( value, format, calendar ) {
            return this.formatnumber( value, format, calendar );
        },

        formatnumber: function ( value, format, calendar ) {
            if ( calendar == undefined || calendar == null || calendar == "" ) {
                calendar = this.defaultcalendar();
            }

            if ( format === "" || format === null ) {
                return value;
            }

            if ( !this.isNumber( value ) ) {
                value *= 1;
            }
            var precision;
            if ( format.length > 1 ) precision = parseInt( format.slice( 1 ), 10 );

            var options = {}
            var current = format.charAt( 0 ).toUpperCase();

            options.thousandsSeparator = calendar.thousandsseparator;
            options.decimalSeparator = calendar.decimalseparator;
            switch ( current ) {
                case "D":
                case "d":
                case "F":
                case "f":
                    options.decimalPlaces = precision;
                    break;
                case "N":
                case "n":
                    options.decimalPlaces = 0;
                    break;
                case "C":
                case "c":
                    options.decimalPlaces = precision;
                    if ( calendar.currencysymbolposition == "before" ) {
                        options.prefix = calendar.currencysymbol;
                    }
                    else {
                        options.suffix = calendar.currencysymbol;
                    }
                    break;
                case "P":
                case "p":
                    options.suffix = calendar.percentsymbol;
                    options.decimalPlaces = precision;
                    break;
                default:
                    throw "Bad number format specifier: " + current;
            }

            if ( this.isNumber( value ) ) {
                var negative = ( value < 0 );
                var output = value + "";
                var decimalseparator = ( options.decimalSeparator ) ? options.decimalSeparator : ".";
                var decimalindex;
                if ( this.isNumber( options.decimalPlaces ) ) {
                    // Round to the correct decimal place
                    var decimalplaces = options.decimalPlaces;
                    var decimal = Math.pow( 10, decimalplaces );
                    output = ( value * decimal ).toFixed( 0 ) / decimal + "";
                    decimalindex = output.lastIndexOf( "." );
                    if ( decimalplaces > 0 ) {
                        // Add the decimal separator
                        if ( decimalindex < 0 ) {
                            output += decimalseparator;
                            decimalindex = output.length - 1;
                        }
                        // Replace the "."
                        else if ( decimalseparator !== "." ) {
                            output = output.replace( ".", decimalseparator );
                        }
                        // Add missing zeros
                        while ( ( output.length - 1 - decimalindex ) < decimalplaces ) {
                            output += "0";
                        }
                    }
                }
                else {
                    var output = value + "";
                    decimalindex = output.lastIndexOf( "." );
                    if ( decimalindex > 0 && decimalplaces == undefined ) {
                        // Replace the "."
                        if ( decimalseparator !== "." ) {
                            output = output.replace( ".", decimalseparator );
                        }
                    }
                }

                if ( options.thousandsSeparator ) {
                    var groupseparator = options.thousandsSeparator;
                    decimalindex = output.lastIndexOf( decimalseparator );
                    decimalindex = ( decimalindex > -1 ) ? decimalindex : output.length;
                    var newoutput = output.substring( decimalindex );
                    var nCount = -1;
                    for ( var i = decimalindex; i > 0; i-- ) {
                        nCount++;
                        if ( ( nCount % 3 === 0 ) && ( i !== decimalindex ) && ( !negative || ( i > 1 ) ) ) {
                            newoutput = groupseparator + newoutput;
                        }
                        newoutput = output.charAt( i - 1 ) + newoutput;
                    }
                    output = newoutput;
                }
                // Prepend prefix
                output = ( options.prefix ) ? options.prefix + output : output;
                // Append suffix
                output = ( options.suffix ) ? output + options.suffix : output;
                return output;

            } else {
                return value;
            }
        },

        tryparsedate: function ( value, calendar ) {
            if ( calendar == undefined || calendar == null ) {
                calendar = this.defaultcalendar();
            }
            var me = this;
            if ( value == "" )
                return null;

            if ( value != null && !value.substring ) {
                value = value.toString();
            }

            if ( value != null && value.substring( 0, 6 ) == "/Date(" ) {
                var jsonDateRE = /^\/Date\((-?\d+)(\+|-)?(\d+)?\)\/$/;

                var date = new Date( +value.replace( /\/Date\((\d+)\)\//, '$1' ) );
                if ( date == "Invalid Date" ) {
                    var m = value.match( /^\/Date\((\d+)([-+]\d\d)(\d\d)\)\/$/ );
                    var date = null;
                    if ( m )
                        date = new Date( 1 * m[ 1 ] + 3600000 * m[ 2 ] + 60000 * m[ 3 ] );
                }
                if ( date == null || date == "Invalid Date" || isNaN( date ) ) {
                    var arr = jsonDateRE.exec( value );
                    if ( arr ) {
                        // 0 - complete results; 1 - ticks; 2 - sign; 3 - minutes
                        var result = new Date( parseInt( arr[ 1 ] ) );
                        if ( arr[ 2 ] ) {
                            var mins = parseInt( arr[ 3 ] );
                            if ( arr[ 2 ] === "-" ) {
                                mins = -mins;
                            }
                            var current = result.getUTCMinutes();
                            result.setUTCMinutes( current - mins );
                        }
                        if ( !isNaN( result.valueOf() ) ) {
                            return result;
                        }
                    }
                }

                return date;
            }

            var patterns = calendar.patterns;
            for ( var prop in patterns ) {
                date = me.parsedate( value, patterns[ prop ], calendar );
                if ( date ) {
                    if ( prop == "ISO" ) {
                        var tmpDate = me.parsedate( value, patterns[ "ISO2" ], calendar );
                        if ( tmpDate ) return tmpDate;
                    }
                    return date;
                }
            }

            if ( value != null ) {
                var tmpDate = null;
                var dateParts = [ ':', '/', '-' ];
                var canParse = true;
                for ( var part = 0; part < dateParts.length; part++ ) {
                    if ( value.indexOf( dateParts[ part ] ) != -1 ) {
                        canParse = false;
                    }
                }

                if ( canParse ) {
                    var number = new Number( value );
                    if ( !isNaN( number ) ) {
                        return new Date( number );
                    }
                }
            }

            if ( $.type( value ) === "string" ) {
                var that = me;
                value = that.trim( value );
                var splitParts = [ ':', '/', '-', ' ', ',' ];
                var replaceAll = function ( find, replace, str ) {
                    return str.replace( new RegExp( find, 'g' ), replace );
                }
                value = replaceAll( ', ', ',', value );
                var timePart = "";
                var datePart = value;
                if ( value.indexOf( ":" ) >= 0 ) {
                    timePart = value.substring( value.indexOf( ":" ) - 2 );
                    timePart = that.trim( timePart );
                    datePart = value.substring( 0, value.indexOf( ":" ) - 2 );
                }
                else if ( value.toUpperCase().indexOf( "AM" ) >= 0 ) {
                    timePart = value.substring( value.toUpperCase().indexOf( "AM" ) - 2 );
                    timePart = that.trim( timePart );
                    datePart = value.substring( 0, value.toUpperCase().indexOf( "AM" ) - 2 );
                }
                else if ( value.toUpperCase().indexOf( "PM" ) >= 0 ) {
                    timePart = value.substring( value.toUpperCase().indexOf( "PM" ) - 2 );
                    timePart = that.trim( timePart );
                    datePart = value.substring( 0, value.toUpperCase().indexOf( "PM" ) - 2 );
                }
                var parseDate = new Date();
                var parsed = false;
                if ( datePart ) {
                    for ( var i = 0; i < splitParts.length; i++ ) {
                        if ( datePart.indexOf( splitParts[ i ] ) >= 0 ) {
                            dateParts = datePart.split( splitParts[ i ] );
                            break;
                        }
                    }

                    var days = new Array();
                    var months = new Array();
                    var years = new Array();
                    var dayPart = null;
                    var monthPart = null;
                    for ( var i = 0; i < dateParts.length; i++ ) {
                        var part = dateParts[ i ];
                        var isDay = that.parsedate( part, "d", calendar ) || that.parsedate( part, "dd", calendar ) || that.parsedate( part, "ddd", calendar ) || that.parsedate( part, "dddd", calendar );
                        if ( isDay ) {
                            if ( part.length <= 2 ) {
                                dayPart = i;
                                days.push( isDay.getDate() );
                                break
                            }
                        }
                    }
                    for ( var i = 0; i < dateParts.length; i++ ) {
                        var part = dateParts[ i ];
                        var isMonth = that.parsedate( part, "M", calendar ) || that.parsedate( part, "MM", calendar ) || that.parsedate( part, "MMM", calendar ) || that.parsedate( part, "MMMM", calendar );
                        if ( isMonth ) {
                            if ( dayPart != undefined && dayPart == i )
                                continue;

                            months.push( isMonth.getMonth() );

                            if ( part.length > 2 ) {
                                monthPart = i;
                                break;
                            }
                        }
                    }
                    for ( var i = 0; i < dateParts.length; i++ ) {
                        var part = dateParts[ i ];
                        var isYear = that.parsedate( part, "yyyy", calendar );
                        if ( isYear ) {
                            if ( dayPart != undefined && dayPart == i )
                                continue;

                            if ( monthPart != undefined && monthPart == i )
                                continue;

                            years.push( isYear.getFullYear() );
                        }
                    }
                    var dates = new Array();
                    for ( var d = 0; d < days.length; d++ ) {
                        for ( var m = 0; m < months.length; m++ ) {
                            for ( var y = 0; y < years.length; y++ ) {
                                var result = new Date( years[ y ], months[ m ], days[ d ] );
                                if ( years[ y ] < 1970 )
                                    result.setFullYear( years[ y ] );
                                if ( result.getTime() != NaN ) {
                                    dates.push( result );
                                }
                            }
                        }
                    }
                    if ( dates.length > 0 ) {
                        parseDate = dates[ 0 ];
                        parsed = true;
                    }
                }
                if ( timePart ) {
                    var timeParts = timePart.indexOf( ":" ) >= 0 ? timePart.split( ':' ) : timePart;
                    var parsedTime = that.parsedate( timePart, "h:mm tt", calendar ) || that.parsedate( timePart, "h:mm:ss tt", calendar ) || that.parsedate( timePart, "HH:mm:ss.fff", calendar ) || that.parsedate( timePart, "HH:mm:ss.ff", calendar ) || that.parsedate( timePart, "HH:mm:ss.tttt", calendar ) || that.parsedate( timePart, "HH:mm:ss", calendar ) || that.parsedate( timePart, "HH:mm", calendar ) || that.parsedate( timePart, "HH", calendar );

                    var hour = 0, minute = 0, second = 0, milisecond = 0;
                    if ( parsedTime && parsedTime.getTime() != NaN ) {
                        hour = parsedTime.getHours();
                        minute = parsedTime.getMinutes();
                        second = parsedTime.getSeconds();
                        milisecond = parsedTime.getMilliseconds();
                    }
                    else {
                        if ( timeParts.length == 1 ) {
                            hour = parseInt( timeParts[ 0 ] );
                        }
                        if ( timeParts.length == 2 ) {
                            hour = parseInt( timeParts[ 0 ] );
                            minute = parseInt( timeParts[ 1 ] );
                        }
                        if ( timeParts.length == 3 ) {
                            hour = parseInt( timeParts[ 0 ] );
                            minute = parseInt( timeParts[ 1 ] );
                            if ( timeParts[ 2 ].indexOf( "." ) >= 0 ) {
                                second = parseInt( timeParts[ 2 ].toString().split( "." )[ 0 ] );
                                milisecond = parseInt( timeParts[ 2 ].toString().split( "." )[ 1 ] );
                            }
                            else {
                                second = parseInt( timeParts[ 2 ] );
                            }
                        }
                        if ( timeParts.length == 4 ) {
                            hour = parseInt( timeParts[ 0 ] );
                            minute = parseInt( timeParts[ 1 ] );
                            second = parseInt( timeParts[ 2 ] );
                            milisecond = parseInt( timeParts[ 3 ] );
                        }
                    }
                    if ( parseDate && !isNaN( hour ) && !isNaN( minute ) && !isNaN( second ) && !isNaN( milisecond ) ) {
                        parseDate.setHours( hour, minute, second, milisecond );
                        parsed = true;
                    }
                }
                if ( parsed ) {
                    return parseDate;
                }
            }

            return null;
        },

        getparseregexp: function ( cal, format ) {
            // converts a format string into a regular expression with groups that
            // can be used to extract date fields from a date string.
            // check for a cached parse regex.
            var re = cal._parseRegExp;
            if ( !re ) {
                cal._parseRegExp = re = {};
            }
            else {
                var reFormat = re[ format ];
                if ( reFormat ) {
                    return reFormat;
                }
            }

            // expand single digit formats, then escape regular expression characters.
            var expFormat = this.expandFormat( cal, format ).replace( /([\^\$\.\*\+\?\|\[\]\(\)\{\}])/g, "\\\\$1" ),
                regexp = [ "^" ],
                groups = [],
                index = 0,
                quoteCount = 0,
                tokenRegExp = this.getTokenRegExp(),
                match;

            // iterate through each date token found.
            while ( ( match = tokenRegExp.exec( expFormat ) ) !== null ) {
                var preMatch = expFormat.slice( index, match.index );
                index = tokenRegExp.lastIndex;

                // don't replace any matches that occur inside a string literal.
                quoteCount += this.appendPreOrPostMatch( preMatch, regexp );
                if ( quoteCount % 2 ) {
                    regexp.push( match[ 0 ] );
                    continue;
                }

                // add a regex group for the token.
                var m = match[ 0 ],
                    len = m.length,
                    add;
                switch ( m ) {
                    case 'dddd': case 'ddd':
                    case 'MMMM': case 'MMM':
                    case 'gg': case 'g':
                        add = "(\\D+)";
                        break;
                    case 'tt': case 't':
                        add = "(\\D*)";
                        break;
                    case 'yyyy':
                    case 'fff':
                    case 'ff':
                    case 'f':
                        add = "(\\d{" + len + "})";
                        break;
                    case 'dd': case 'd':
                    case 'MM': case 'M':
                    case 'yy': case 'y':
                    case 'HH': case 'H':
                    case 'hh': case 'h':
                    case 'mm': case 'm':
                    case 'ss': case 's':
                        add = "(\\d\\d?)";
                        break;
                    case 'zzz':
                        add = "([+-]?\\d\\d?:\\d{2})";
                        break;
                    case 'zz': case 'z':
                        add = "([+-]?\\d\\d?)";
                        break;
                    case '/':
                        add = "(\\" + cal[ "/" ] + ")";
                        break;
                    default:
                        throw "Invalid date format pattern '" + m + "'.";
                        break;
                }
                if ( add ) {
                    regexp.push( add );
                }
                groups.push( match[ 0 ] );
            }
            this.appendPreOrPostMatch( expFormat.slice( index ), regexp );
            regexp.push( "$" );

            // allow whitespace to differ when matching formats.
            var regexpStr = regexp.join( '' ).replace( /\s+/g, "\\s+" ),
                parseRegExp = { 'regExp': regexpStr, 'groups': groups };

            // cache the regex for this format.
            return re[ format ] = parseRegExp;
        },

        outOfRange: function ( value, low, high ) {
            return value < low || value > high;
        },

        expandYear: function ( cal, year ) {
            // expands 2-digit year into 4 digits.
            var now = new Date(),
                era = this.getEra( now );
            if ( year < 100 ) {
                var twoDigitYearMax = cal.twoDigitYearMax;
                twoDigitYearMax = typeof twoDigitYearMax === 'string' ? new Date().getFullYear() % 100 + parseInt( twoDigitYearMax, 10 ) : twoDigitYearMax;
                var curr = this.getEraYear( now, cal, era );
                year += curr - ( curr % 100 );
                if ( year > twoDigitYearMax ) {
                    year -= 100;
                }
            }
            return year;
        },

        parsedate: function ( value, format, calendar ) {
            if ( calendar == undefined || calendar == null ) {
                calendar = this.defaultcalendar();
            }
            // try to parse the date string by matching against the format string
            // while using the specified culture for date field names.
            value = this.trim( value );
            var cal = calendar,
                // convert date formats into regular expressions with groupings.
                // use the regexp to determine the input format and extract the date fields.
                parseInfo = this.getparseregexp( cal, format ),
                match = new RegExp( parseInfo.regExp ).exec( value );
            if ( match === null ) {
                return null;
            }
            // found a date format that matches the input.
            var groups = parseInfo.groups,
                era = null, year = null, month = null, date = null, weekDay = null,
                hour = 0, hourOffset, min = 0, sec = 0, msec = 0, tzMinOffset = null,
                pmHour = false;
            // iterate the format groups to extract and set the date fields.
            for ( var j = 0, jl = groups.length; j < jl; j++ ) {
                var matchGroup = match[ j + 1 ];
                if ( matchGroup ) {
                    var current = groups[ j ],
                        clength = current.length,
                        matchInt = parseInt( matchGroup, 10 );
                    switch ( current ) {
                        case 'dd': case 'd':
                            // Day of month.
                            date = matchInt;
                            // check that date is generally in valid range, also checking overflow below.
                            if ( this.outOfRange( date, 1, 31 ) ) return null;
                            break;
                        case 'MMM':
                        case 'MMMM':
                            month = this.getMonthIndex( cal, matchGroup, clength === 3 );
                            if ( this.outOfRange( month, 0, 11 ) ) return null;
                            break;
                        case 'M': case 'MM':
                            // Month.
                            month = matchInt - 1;
                            if ( this.outOfRange( month, 0, 11 ) ) return null;
                            break;
                        case 'y': case 'yy':
                        case 'yyyy':
                            year = clength < 4 ? this.expandYear( cal, matchInt ) : matchInt;
                            if ( this.outOfRange( year, 0, 9999 ) ) return null;
                            break;
                        case 'h': case 'hh':
                            // Hours (12-hour clock).
                            hour = matchInt;
                            if ( hour === 12 ) hour = 0;
                            if ( this.outOfRange( hour, 0, 11 ) ) return null;
                            break;
                        case 'H': case 'HH':
                            // Hours (24-hour clock).
                            hour = matchInt;
                            if ( this.outOfRange( hour, 0, 23 ) ) return null;
                            break;
                        case 'm': case 'mm':
                            // Minutes.
                            min = matchInt;
                            if ( this.outOfRange( min, 0, 59 ) ) return null;
                            break;
                        case 's': case 'ss':
                            // Seconds.
                            sec = matchInt;
                            if ( this.outOfRange( sec, 0, 59 ) ) return null;
                            break;
                        case 'tt': case 't':
                            // AM/PM designator.
                            // see if it is standard, upper, or lower case PM. If not, ensure it is at least one of
                            // the AM tokens. If not, fail the parse for this format.
                            pmHour = cal.PM && ( matchGroup === cal.PM[ 0 ] || matchGroup === cal.PM[ 1 ] || matchGroup === cal.PM[ 2 ] );
                            if ( !pmHour && ( !cal.AM || ( matchGroup !== cal.AM[ 0 ] && matchGroup !== cal.AM[ 1 ] && matchGroup !== cal.AM[ 2 ] ) ) ) return null;
                            break;
                        case 'f':
                        // Deciseconds.
                        case 'ff':
                        // Centiseconds.
                        case 'fff':
                            // Milliseconds.
                            msec = matchInt * Math.pow( 10, 3 - clength );
                            if ( this.outOfRange( msec, 0, 999 ) ) return null;
                            break;
                        case 'ddd':
                        // Day of week.
                        case 'dddd':
                            // Day of week.
                            weekDay = this.getDayIndex( cal, matchGroup, clength === 3 );
                            if ( this.outOfRange( weekDay, 0, 6 ) ) return null;
                            break;
                        case 'zzz':
                            // Time zone offset in +/- hours:min.
                            var offsets = matchGroup.split( /:/ );
                            if ( offsets.length !== 2 ) return null;
                            hourOffset = parseInt( offsets[ 0 ], 10 );
                            if ( this.outOfRange( hourOffset, -12, 13 ) ) return null;
                            var minOffset = parseInt( offsets[ 1 ], 10 );
                            if ( this.outOfRange( minOffset, 0, 59 ) ) return null;
                            tzMinOffset = ( hourOffset * 60 ) + ( this.startsWith( matchGroup, '-' ) ? -minOffset : minOffset );
                            break;
                        case 'z': case 'zz':
                            // Time zone offset in +/- hours.
                            hourOffset = matchInt;
                            if ( this.outOfRange( hourOffset, -12, 13 ) ) return null;
                            tzMinOffset = hourOffset * 60;
                            break;
                        case 'g': case 'gg':
                            var eraName = matchGroup;
                            if ( !eraName || !cal.eras ) return null;
                            eraName = this.trim( eraName.toLowerCase() );
                            for ( var i = 0, l = cal.eras.length; i < l; i++ ) {
                                if ( eraName === cal.eras[ i ].name.toLowerCase() ) {
                                    era = i;
                                    break;
                                }
                            }
                            // could not find an era with that name
                            if ( era === null ) return null;
                            break;
                    }
                }
            }
            var result = new Date(), defaultYear, convert = cal.convert;
            defaultYear = result.getFullYear();
            if ( year === null ) {
                year = defaultYear;
            }
            else if ( cal.eras ) {
                // year must be shifted to normal gregorian year
                // but not if year was not specified, its already normal gregorian
                // per the main if clause above.
                year += cal.eras[ ( era || 0 ) ].offset;
            }
            // set default day and month to 1 and January, so if unspecified, these are the defaults
            // instead of the current day/month.
            if ( month === null ) {
                month = 0;
            }
            if ( date === null ) {
                date = 1;
            }
            // now have year, month, and date, but in the culture's calendar.
            // convert to gregorian if necessary
            if ( convert ) {
                result = convert.toGregorian( year, month, date );
                // conversion failed, must be an invalid match
                if ( result === null ) return null;
            }
            else {
                // have to set year, month and date together to avoid overflow based on current date.
                result.setFullYear( year, month, date );
                // check to see if date overflowed for specified month (only checked 1-31 above).
                if ( result.getDate() !== date ) return null;
                // invalid day of week.
                if ( weekDay !== null && result.getDay() !== weekDay ) {
                    return null;
                }
            }
            // if pm designator token was found make sure the hours fit the 24-hour clock.
            if ( pmHour && hour < 12 ) {
                hour += 12;
            }
            result.setHours( hour, min, sec, msec );
            if ( tzMinOffset !== null ) {
                // adjust timezone to utc before applying local offset.
                var adjustedMin = result.getMinutes() - ( tzMinOffset + result.getTimezoneOffset() );
                // Safari limits hours and minutes to the range of -127 to 127.  We need to use setHours
                // to ensure both these fields will not exceed this range.  adjustedMin will range
                // somewhere between -1440 and 1500, so we only need to split this into hours.
                result.setHours( result.getHours() + parseInt( adjustedMin / 60, 10 ), adjustedMin % 60 );
            }
            return result;
        },

        cleardatescache: function () {
            this.datescache = new Array();
        },

        formatDate: function ( value, format, calendar ) {
            return this.formatdate( value, format, calendar );
        },

        formatdate: function ( value, format, calendar ) {
            if ( calendar == undefined || calendar == null ) {
                calendar = this.defaultcalendar();
            }

            if ( typeof value === 'string' ) {
                return value;
            }

            var lookupkey = value.toString() + "_" + format;
            if ( this.datescache && this.datescache[ lookupkey ] ) {
                if ( format.indexOf( 'f' ) == -1 ) {
                    return this.datescache[ lookupkey ];
                }
            }

            if ( !format || !format.length || format === 'i' ) {
                var ret;
                ret = this.formatDate( value, calendar.patterns.F, calendar );
                return ret;
            }

            var eras = calendar.eras,
                sortable = format === "s";
            format = this.expandFormat( calendar, format );

            // Start with an empty string
            ret = [];
            var hour,
                zeros = [ '0', '00', '000' ],
                foundDay,
                checkedDay,
                dayPartRegExp = /([^d]|^)(d|dd)([^d]|$)/g,
                quoteCount = 0,
                tokenRegExp = this.getTokenRegExp(),
                converted;

            function padZeros( num, c ) {
                var r, s = num + '';
                if ( c > 1 && s.length < c ) {
                    r = ( zeros[ c - 2 ] + s );
                    return r.substr( r.length - c, c );
                }
                else {
                    r = s;
                }
                return r;
            }

            function hasDay() {
                if ( foundDay || checkedDay ) {
                    return foundDay;
                }
                foundDay = dayPartRegExp.test( format );
                checkedDay = true;
                return foundDay;
            }

            function getPart( date, part ) {
                if ( converted ) {
                    return converted[ part ];
                }
                if ( date.getMonth != undefined ) {
                    switch ( part ) {
                        case 0: return date.getFullYear();
                        case 1: return date.getMonth();
                        case 2: return date.getDate();
                    }
                }
            }

            for ( ; ; ) {
                // Save the current index
                var index = tokenRegExp.lastIndex,
                    // Look for the next pattern
                    ar = tokenRegExp.exec( format );

                // Append the text before the pattern (or the end of the string if not found)
                var preMatch = format.slice( index, ar ? ar.index : format.length );
                quoteCount += this.appendPreOrPostMatch( preMatch, ret );

                if ( !ar ) {
                    break;
                }

                // do not replace any matches that occur inside a string literal.
                if ( quoteCount % 2 ) {
                    ret.push( ar[ 0 ] );
                    continue;
                }

                var current = ar[ 0 ],
                    clength = current.length;

                switch ( current ) {
                    case "ddd":
                    //Day of the week, as a three-letter abbreviation
                    case "dddd":
                        // Day of the week, using the full name
                        var names = ( clength === 3 ) ? calendar.days.namesAbbr : calendar.days.names;
                        ret.push( names[ value.getDay() ] );
                        break;
                    case "d":
                    // Day of month, without leading zero for single-digit days
                    case "dd":
                        // Day of month, with leading zero for single-digit days
                        foundDay = true;
                        ret.push( padZeros( getPart( value, 2 ), clength ) );
                        break;
                    case "MMM":
                    // Month, as a three-letter abbreviation
                    case "MMMM":
                        // Month, using the full name
                        var part = getPart( value, 1 );
                        ret.push( calendar.months[ clength === 3 ? "namesAbbr" : "names" ][ part ] );
                        break;
                    case "M":
                    // Month, as digits, with no leading zero for single-digit months
                    case "MM":
                        // Month, as digits, with leading zero for single-digit months
                        ret.push( padZeros( getPart( value, 1 ) + 1, clength ) );
                        break;
                    case "y":
                    // Year, as two digits, but with no leading zero for years less than 10
                    case "yy":
                    // Year, as two digits, with leading zero for years less than 10
                    case "yyyy":
                        // Year represented by four full digits
                        part = this.getEraYear( value, calendar, this.getEra( value, eras ), sortable );
                        if ( clength < 4 ) {
                            part = part % 100;
                        }
                        ret.push( padZeros( part, clength ) );
                        break;
                    case "h":
                    // Hours with no leading zero for single-digit hours, using 12-hour clock
                    case "hh":
                        // Hours with leading zero for single-digit hours, using 12-hour clock
                        hour = value.getHours() % 12;
                        if ( hour === 0 ) hour = 12;
                        ret.push( padZeros( hour, clength ) );
                        break;
                    case "H":
                    // Hours with no leading zero for single-digit hours, using 24-hour clock
                    case "HH":
                        // Hours with leading zero for single-digit hours, using 24-hour clock
                        ret.push( padZeros( value.getHours(), clength ) );
                        break;
                    case "m":
                    // Minutes with no leading zero  for single-digit minutes
                    case "mm":
                        // Minutes with leading zero  for single-digit minutes
                        ret.push( padZeros( value.getMinutes(), clength ) );
                        break;
                    case "s":
                    // Seconds with no leading zero for single-digit seconds
                    case "ss":
                        // Seconds with leading zero for single-digit seconds
                        ret.push( padZeros( value.getSeconds(), clength ) );
                        break;
                    case "t":
                    // One character am/pm indicator ("a" or "p")
                    case "tt":
                        // Multicharacter am/pm indicator
                        part = value.getHours() < 12 ? ( calendar.AM ? calendar.AM[ 0 ] : " " ) : ( calendar.PM ? calendar.PM[ 0 ] : " " );
                        ret.push( clength === 1 ? part.charAt( 0 ) : part );
                        break;
                    case "f":
                    // Deciseconds
                    case "ff":
                    // Centiseconds
                    case "fff":
                        // Milliseconds
                        ret.push( padZeros( value.getMilliseconds(), 3 ).substr( 0, clength ) );
                        break;
                    case "z":
                    // Time zone offset, no leading zero
                    case "zz":
                        // Time zone offset with leading zero
                        hour = value.getTimezoneOffset() / 60;
                        ret.push( ( hour <= 0 ? '+' : '-' ) + padZeros( Math.floor( Math.abs( hour ) ), clength ) );
                        break;
                    case "zzz":
                        // Time zone offset with leading zero
                        hour = value.getTimezoneOffset() / 60;
                        ret.push( ( hour <= 0 ? '+' : '-' ) + padZeros( Math.floor( Math.abs( hour ) ), 2 ) +
                            // Hard coded ":" separator, rather than using calendar.TimeSeparator
                            // Repeated here for consistency, plus ":" was already assumed in date parsing.
                            ":" + padZeros( Math.abs( value.getTimezoneOffset() % 60 ), 2 ) );
                        break;
                    case "g":
                    case "gg":
                        if ( calendar.eras ) {
                            ret.push( calendar.eras[ this.getEra( value, eras ) ].name );
                        }
                        break;
                    case "/":
                        ret.push( calendar[ "/" ] );
                        break;
                    default:
                        throw "Invalid date format pattern '" + current + "'.";
                        break;
                }
            }

            var result = ret.join( '' );

            if ( !this.datescache ) {
                this.datescache = new Array();
            }

            this.datescache[ lookupkey ] = result;
            return result;
        }
    } );

    // AJAX
    $.jqx.data = {};
    var
        ajaxLocParts,
        ajaxLocation,

        rhash = /#.*$/,
        rheaders = /^(.*?):[ \t]*([^\r\n]*)\r?$/mg,
        rlocalProtocol = /^(?:about|app|app\-storage|.+\-extension|file|res|widget):$/,
        rnoContent = /^(?:GET|HEAD)$/,
        rprotocol = /^\/\//,
        rquery = /\?/,
        rscript = /<script\b[^<]*(?:(?!<\/script>)<[^<]*)*<\/script>/gi,
        rts = /([?&])_=[^&]*/,
        rurl = /^([\w\+\.\-]+:)(?:\/\/([^\/?#:]*)(?::(\d+)|)|)/,
        core_rspace = /\s+/,
        _load = $.fn.load,
        prefilters = {},
        transports = {},
        allTypes = [ "*/" ] + [ "*" ];

    try {
        ajaxLocation = location.href;
    } catch ( e ) {
        ajaxLocation = document.createElement( "a" );
        ajaxLocation.href = "";
        ajaxLocation = ajaxLocation.href;
    }

    ajaxLocParts = rurl.exec( ajaxLocation.toLowerCase() ) || [];

    function addToPrefiltersOrTransports( structure ) {

        return function ( dataTypeExpression, func ) {

            if ( typeof dataTypeExpression !== "string" ) {
                func = dataTypeExpression;
                dataTypeExpression = "*";
            }

            var dataType, list, placeBefore,
                dataTypes = dataTypeExpression.toLowerCase().split( core_rspace ),
                i = 0,
                length = dataTypes.length;

            if ( $.isFunction( func ) ) {
                for ( ; i < length; i++ ) {
                    dataType = dataTypes[ i ];
                    placeBefore = /^\+/.test( dataType );
                    if ( placeBefore ) {
                        dataType = dataType.substr( 1 ) || "*";
                    }
                    list = structure[ dataType ] = structure[ dataType ] || [];
                    list[ placeBefore ? "unshift" : "push" ]( func );
                }
            }
        };
    }

    function inspectPrefiltersOrTransports( structure, options, originalOptions, jqXHR,
        dataType /* internal */, inspected /* internal */ ) {

        dataType = dataType || options.dataTypes[ 0 ];
        inspected = inspected || {};

        inspected[ dataType ] = true;

        var selection,
            list = structure[ dataType ],
            i = 0,
            length = list ? list.length : 0,
            executeOnly = ( structure === prefilters );

        for ( ; i < length && ( executeOnly || !selection ); i++ ) {
            selection = list[ i ]( options, originalOptions, jqXHR );
            if ( typeof selection === "string" ) {
                if ( !executeOnly || inspected[ selection ] ) {
                    selection = undefined;
                } else {
                    options.dataTypes.unshift( selection );
                    selection = inspectPrefiltersOrTransports(
                        structure, options, originalOptions, jqXHR, selection, inspected );
                }
            }
        }
        if ( ( executeOnly || !selection ) && !inspected[ "*" ] ) {
            selection = inspectPrefiltersOrTransports(
                structure, options, originalOptions, jqXHR, "*", inspected );
        }
        return selection;
    }

    function ajaxExtend( target, src ) {
        var key, deep,
            flatOptions = $.jqx.data.ajaxSettings.flatOptions || {};
        for ( key in src ) {
            if ( src[ key ] !== undefined ) {
                ( flatOptions[ key ] ? target : ( deep || ( deep = {} ) ) )[ key ] = src[ key ];
            }
        }
        if ( deep ) {
            $.extend( true, target, deep );
        }
    }

    $.extend( $.jqx.data, {
        ajaxSetup: function ( target, settings ) {
            if ( settings ) {
                ajaxExtend( target, $.jqx.data.ajaxSettings );
            } else {
                settings = target;
                target = $.jqx.data.ajaxSettings;
            }
            ajaxExtend( target, settings );
            return target;
        },

        ajaxSettings: {
            url: ajaxLocation,
            isLocal: rlocalProtocol.test( ajaxLocParts[ 1 ] ),
            global: true,
            type: "GET",
            contentType: "application/x-www-form-urlencoded; charset=UTF-8",
            processData: true,
            async: true,

            accepts: {
                xml: "application/xml, text/xml",
                html: "text/html",
                text: "text/plain",
                json: "application/json, text/javascript",
                "*": allTypes
            },

            contents: {
                xml: /xml/,
                html: /html/,
                json: /json/
            },

            responseFields: {
                xml: "responseXML",
                text: "responseText"
            },

            converters: {
                "* text": window.String,
                "text html": true,
                "text json": $.parseJSON,
                "text xml": $.parseXML
            },

            flatOptions: {
                context: true,
                url: true
            }
        },

        ajaxPrefilter: addToPrefiltersOrTransports( prefilters ),
        ajaxTransport: addToPrefiltersOrTransports( transports ),

        ajax: function ( url, options ) {

            if ( typeof url === "object" ) {
                options = url;
                url = undefined;
            }

            options = options || {};

            var ifModifiedKey,
                responseHeadersString,
                responseHeaders,
                transport,
                timeoutTimer,
                parts,
                fireGlobals,
                i,
                s = $.jqx.data.ajaxSetup( {}, options ),
                callbackContext = s.context || s,
                globalEventContext = callbackContext !== s &&
                    ( callbackContext.nodeType || callbackContext instanceof $ ) ?
                    $( callbackContext ) : $.event,
                deferred = $.Deferred(),
                completeDeferred = $.Callbacks( "once memory" ),
                statusCode = s.statusCode || {},
                requestHeaders = {},
                requestHeadersNames = {},
                state = 0,
                strAbort = "canceled",
                jqXHR = {
                    readyState: 0,
                    setRequestHeader: function ( name, value ) {
                        if ( !state ) {
                            var lname = name.toLowerCase();
                            name = requestHeadersNames[ lname ] = requestHeadersNames[ lname ] || name;
                            requestHeaders[ name ] = value;
                        }
                        return this;
                    },
                    getAllResponseHeaders: function () {
                        return state === 2 ? responseHeadersString : null;
                    },
                    getResponseHeader: function ( key ) {
                        var match;
                        if ( state === 2 ) {
                            if ( !responseHeaders ) {
                                responseHeaders = {};
                                while ( ( match = rheaders.exec( responseHeadersString ) ) ) {
                                    responseHeaders[ match[ 1 ].toLowerCase() ] = match[ 2 ];
                                }
                            }
                            match = responseHeaders[ key.toLowerCase() ];
                        }
                        return match === undefined ? null : match;
                    },

                    overrideMimeType: function ( type ) {
                        if ( !state ) {
                            s.mimeType = type;
                        }
                        return this;
                    },

                    abort: function ( statusText ) {
                        statusText = statusText || strAbort;
                        if ( transport ) {
                            transport.abort( statusText );
                        }
                        done( 0, statusText );
                        return this;
                    }
                };

            function done( status, nativeStatusText, responses, headers ) {
                var isSuccess, success, error, response, modified,
                    statusText = nativeStatusText;

                if ( state === 2 ) {
                    return;
                }

                state = 2;
                if ( timeoutTimer ) {
                    clearTimeout( timeoutTimer );
                }

                transport = undefined;
                responseHeadersString = headers || "";
                jqXHR.readyState = status > 0 ? 4 : 0;

                if ( responses ) {
                    response = ajaxHandleResponses( s, jqXHR, responses );
                }

                if ( status >= 200 && status < 300 || status === 304 ) {

                    if ( s.ifModified ) {

                        modified = jqXHR.getResponseHeader( "Last-Modified" );
                        if ( modified ) {
                            $.lastModified[ ifModifiedKey ] = modified;
                        }
                        modified = jqXHR.getResponseHeader( "Etag" );
                        if ( modified ) {
                            $.etag[ ifModifiedKey ] = modified;
                        }
                    }

                    if ( status === 304 ) {
                        statusText = "notmodified";
                        isSuccess = true;
                    } else {

                        isSuccess = ajaxConvert( s, response );
                        statusText = isSuccess.state;
                        success = isSuccess.data;
                        error = isSuccess.error;
                        isSuccess = !error;
                    }
                } else {
                    error = statusText;
                    if ( !statusText || status ) {
                        statusText = "error";
                        if ( status < 0 ) {
                            status = 0;
                        }
                    }
                }

                jqXHR.status = status;
                jqXHR.statusText = ( nativeStatusText || statusText ) + "";

                if ( isSuccess ) {
                    deferred.resolveWith( callbackContext, [ success, statusText, jqXHR ] );
                } else {
                    deferred.rejectWith( callbackContext, [ jqXHR, statusText, error ] );
                }

                jqXHR.statusCode( statusCode );
                statusCode = undefined;

                if ( fireGlobals ) {
                    globalEventContext.trigger( "ajax" + ( isSuccess ? "Success" : "Error" ),
                        [ jqXHR, s, isSuccess ? success : error ] );
                }

                completeDeferred.fireWith( callbackContext, [ jqXHR, statusText ] );

                if ( fireGlobals ) {
                    globalEventContext.trigger( "ajaxComplete", [ jqXHR, s ] );
                    if ( !( --$.active ) ) {
                        $.event.trigger( "ajaxStop" );
                    }
                }
            }

            deferred.promise( jqXHR );
            jqXHR.success = jqXHR.done;
            jqXHR.error = jqXHR.fail;
            jqXHR.complete = completeDeferred.add;

            jqXHR.statusCode = function ( map ) {
                if ( map ) {
                    var tmp;
                    if ( state < 2 ) {
                        for ( tmp in map ) {
                            statusCode[ tmp ] = [ statusCode[ tmp ], map[ tmp ] ];
                        }
                    } else {
                        tmp = map[ jqXHR.status ];
                        jqXHR.always( tmp );
                    }
                }
                return this;
            };

            s.url = ( ( url || s.url ) + "" ).replace( rhash, "" ).replace( rprotocol, ajaxLocParts[ 1 ] + "//" );
            s.dataTypes = $.trim( s.dataType || "*" ).toLowerCase().split( core_rspace );

            if ( s.crossDomain == null ) {
                parts = rurl.exec( s.url.toLowerCase() );
                s.crossDomain = !!( parts &&
                    ( parts[ 1 ] !== ajaxLocParts[ 1 ] || parts[ 2 ] !== ajaxLocParts[ 2 ] ||
                        ( parts[ 3 ] || ( parts[ 1 ] === "http:" ? 80 : 443 ) ) !=
                        ( ajaxLocParts[ 3 ] || ( ajaxLocParts[ 1 ] === "http:" ? 80 : 443 ) ) )
                );
            }

            if ( s.data && s.processData && typeof s.data !== "string" ) {
                s.data = $.param( s.data, s.traditional );
            }

            inspectPrefiltersOrTransports( prefilters, s, options, jqXHR );

            if ( state === 2 ) {
                return jqXHR;
            }

            fireGlobals = s.global;
            s.type = s.type.toUpperCase();
            s.hasContent = !rnoContent.test( s.type );

            if ( fireGlobals && $.active++ === 0 ) {
                $.event.trigger( "ajaxStart" );
            }

            if ( !s.hasContent ) {
                if ( s.data ) {
                    s.url += ( rquery.test( s.url ) ? "&" : "?" ) + s.data;
                    delete s.data;
                }

                ifModifiedKey = s.url;

                if ( s.cache === false ) {

                    var ts = ( new Date() ).getTime(),
                        ret = s.url.replace( rts, "$1_=" + ts );

                    s.url = ret + ( ( ret === s.url ) ? ( rquery.test( s.url ) ? "&" : "?" ) + "_=" + ts : "" );
                }
            }

            if ( s.data && s.hasContent && s.contentType !== false || options.contentType ) {
                jqXHR.setRequestHeader( "Content-Type", s.contentType );
            }

            if ( s.ifModified ) {
                ifModifiedKey = ifModifiedKey || s.url;
                if ( $.lastModified[ ifModifiedKey ] ) {
                    jqXHR.setRequestHeader( "If-Modified-Since", $.lastModified[ ifModifiedKey ] );
                }
                if ( $.etag[ ifModifiedKey ] ) {
                    jqXHR.setRequestHeader( "If-None-Match", $.etag[ ifModifiedKey ] );
                }
            }

            jqXHR.setRequestHeader(
                "Accept",
                s.dataTypes[ 0 ] && s.accepts[ s.dataTypes[ 0 ] ] ?
                    s.accepts[ s.dataTypes[ 0 ] ] + ( s.dataTypes[ 0 ] !== "*" ? ", " + allTypes + "; q=0.01" : "" ) :
                    s.accepts[ "*" ]
            );

            for ( i in s.headers ) {
                jqXHR.setRequestHeader( i, s.headers[ i ] );
            }

            if ( s.beforeSend && ( s.beforeSend.call( callbackContext, jqXHR, s ) === false || state === 2 ) ) {
                return jqXHR.abort();

            }

            strAbort = "abort";

            for ( i in { success: 1, error: 1, complete: 1 } ) {
                jqXHR[ i ]( s[ i ] );
            }

            transport = inspectPrefiltersOrTransports( transports, s, options, jqXHR );

            if ( !transport ) {
                done( -1, "No Transport" );
            } else {
                jqXHR.readyState = 1;
                if ( fireGlobals ) {
                    globalEventContext.trigger( "ajaxSend", [ jqXHR, s ] );
                }
                if ( s.async && s.timeout > 0 ) {
                    timeoutTimer = setTimeout( function () {
                        jqXHR.abort( "timeout" );
                    }, s.timeout );
                }

                try {
                    state = 1;
                    transport.send( requestHeaders, done );
                } catch ( e ) {
                    if ( state < 2 ) {
                        done( -1, e );
                    } else {
                        throw e;
                    }
                }
            }

            return jqXHR;
        },

        active: 0,

        lastModified: {},
        etag: {}

    } );

    function ajaxHandleResponses( s, jqXHR, responses ) {

        var ct, type, finalDataType, firstDataType,
            contents = s.contents,
            dataTypes = s.dataTypes,
            responseFields = s.responseFields;

        for ( type in responseFields ) {
            if ( type in responses ) {
                jqXHR[ responseFields[ type ] ] = responses[ type ];
            }
        }

        while ( dataTypes[ 0 ] === "*" ) {
            dataTypes.shift();
            if ( ct === undefined ) {
                ct = s.mimeType || jqXHR.getResponseHeader( "content-type" );
            }
        }

        if ( ct ) {
            for ( type in contents ) {
                if ( contents[ type ] && contents[ type ].test( ct ) ) {
                    dataTypes.unshift( type );
                    break;
                }
            }
        }

        if ( dataTypes[ 0 ] in responses ) {
            finalDataType = dataTypes[ 0 ];
        } else {
            for ( type in responses ) {
                if ( !dataTypes[ 0 ] || s.converters[ type + " " + dataTypes[ 0 ] ] ) {
                    finalDataType = type;
                    break;
                }
                if ( !firstDataType ) {
                    firstDataType = type;
                }
            }
            finalDataType = finalDataType || firstDataType;
        }

        if ( finalDataType ) {
            if ( finalDataType !== dataTypes[ 0 ] ) {
                dataTypes.unshift( finalDataType );
            }
            return responses[ finalDataType ];
        }
    }

    function ajaxConvert( s, response ) {
        var conv, conv2, current, tmp,
            dataTypes = s.dataTypes.slice(),
            prev = dataTypes[ 0 ],
            converters = {},
            i = 0;

        if ( s.dataFilter ) {
            response = s.dataFilter( response, s.dataType );
        }

        if ( dataTypes[ 1 ] ) {
            for ( conv in s.converters ) {
                converters[ conv.toLowerCase() ] = s.converters[ conv ];
            }
        }

        for ( ; ( current = dataTypes[ ++i ] ); ) {
            if ( current !== "*" ) {
                if ( prev !== "*" && prev !== current ) {
                    conv = converters[ prev + " " + current ] || converters[ "* " + current ];

                    if ( !conv ) {
                        for ( conv2 in converters ) {
                            tmp = conv2.split( " " );
                            if ( tmp[ 1 ] === current ) {
                                conv = converters[ prev + " " + tmp[ 0 ] ] ||
                                    converters[ "* " + tmp[ 0 ] ];
                                if ( conv ) {
                                    if ( conv === true ) {
                                        conv = converters[ conv2 ];

                                    } else if ( converters[ conv2 ] !== true ) {
                                        current = tmp[ 0 ];
                                        dataTypes.splice( i--, 0, current );
                                    }

                                    break;
                                }
                            }
                        }
                    }

                    if ( conv !== true ) {
                        if ( conv && s[ "throws" ] ) {
                            response = conv( response );
                        } else {
                            try {
                                response = conv( response );
                            } catch ( e ) {
                                return { state: "parsererror", error: conv ? e : "No conversion from " + prev + " to " + current };
                            }
                        }
                    }
                }

                prev = current;
            }
        }

        return { state: "success", data: response };
    }
    var oldCallbacks = [],
        rquestion = /\?/,
        rjsonp = /(=)\?(?=&|$)|\?\?/,
        nonce = ( new Date() ).getTime();

    $.jqx.data.ajaxSetup( {
        jsonp: "callback",
        jsonpCallback: function () {
            var callback = oldCallbacks.pop() || ( $.expando + "_" + ( nonce++ ) );
            this[ callback ] = true;
            return callback;
        }
    } );

    $.jqx.data.ajaxPrefilter( "json jsonp", function ( s, originalSettings, jqXHR ) {

        var callbackName, overwritten, responseContainer,
            data = s.data,
            url = s.url,
            hasCallback = s.jsonp !== false,
            replaceInUrl = hasCallback && rjsonp.test( url ),
            replaceInData = hasCallback && !replaceInUrl && typeof data === "string" &&
                !( s.contentType || "" ).indexOf( "application/x-www-form-urlencoded" ) &&
                rjsonp.test( data );

        if ( s.dataTypes[ 0 ] === "jsonp" || replaceInUrl || replaceInData ) {

            callbackName = s.jsonpCallback = $.isFunction( s.jsonpCallback ) ?
                s.jsonpCallback() :
                s.jsonpCallback;
            overwritten = window[ callbackName ];

            if ( replaceInUrl ) {
                s.url = url.replace( rjsonp, "$1" + callbackName );
            } else if ( replaceInData ) {
                s.data = data.replace( rjsonp, "$1" + callbackName );
            } else if ( hasCallback ) {
                s.url += ( rquestion.test( url ) ? "&" : "?" ) + s.jsonp + "=" + callbackName;
            }

            s.converters[ "script json" ] = function () {
                if ( !responseContainer ) {
                    $.error( callbackName + " was not called" );
                }
                return responseContainer[ 0 ];
            };

            s.dataTypes[ 0 ] = "json";

            window[ callbackName ] = function () {
                responseContainer = arguments;
            };

            jqXHR.always( function () {
                window[ callbackName ] = overwritten;
                if ( s[ callbackName ] ) {
                    s.jsonpCallback = originalSettings.jsonpCallback;

                    oldCallbacks.push( callbackName );
                }

                if ( responseContainer && $.isFunction( overwritten ) ) {
                    overwritten( responseContainer[ 0 ] );
                }

                responseContainer = overwritten = undefined;
            } );

            return "script";
        }
    } );

    $.jqx.data.ajaxSetup( {
        accepts: {
            script: "text/javascript, application/javascript, application/ecmascript, application/x-ecmascript"
        },
        contents: {
            script: /javascript|ecmascript/
        },
        converters: {
            "text script": function ( text ) {
                $.globalEval( text );
                return text;
            }
        }
    } );

    $.jqx.data.ajaxPrefilter( "script", function ( s ) {
        if ( s.cache === undefined ) {
            s.cache = false;
        }
        if ( s.crossDomain ) {
            s.type = "GET";
            s.global = false;
        }
    } );

    $.jqx.data.ajaxTransport( "script", function ( s ) {
        if ( s.crossDomain ) {
            var script,
                head = document.head || document.getElementsByTagName( "head" )[ 0 ] || document.documentElement;

            return {

                send: function ( _, callback ) {

                    script = document.createElement( "script" );

                    script.async = "async";

                    if ( s.scriptCharset ) {
                        script.charset = s.scriptCharset;
                    }

                    script.src = s.url;

                    script.onload = script.onreadystatechange = function ( _, isAbort ) {

                        if ( isAbort || !script.readyState || /loaded|complete/.test( script.readyState ) ) {

                            script.onload = script.onreadystatechange = null;

                            if ( head && script.parentNode ) {
                                head.removeChild( script );
                            }

                            script = undefined;

                            if ( !isAbort ) {
                                callback( 200, "success" );
                            }
                        }
                    };
                    head.insertBefore( script, head.firstChild );
                },

                abort: function () {
                    if ( script ) {
                        script.onload( 0, 1 );
                    }
                }
            };
        }
    } );
    var xhrCallbacks,
        xhrOnUnloadAbort = window.ActiveXObject ? function () {
            for ( var key in xhrCallbacks ) {
                xhrCallbacks[ key ]( 0, 1 );
            }
        } : false,
        xhrId = 0;

    function createStandardXHR() {
        try {
            return new window.XMLHttpRequest();
        } catch ( e ) { }
    }

    function createActiveXHR() {
        try {
            return new window.ActiveXObject( "Microsoft.XMLHTTP" );
        } catch ( e ) { }
    }

    $.jqx.data.ajaxSettings.xhr = window.ActiveXObject ?
        function () {
            return !this.isLocal && createStandardXHR() || createActiveXHR();
        } :
        createStandardXHR;

    ( function ( xhr ) {
        $.extend( $.support, {
            ajax: !!xhr,
            cors: !!xhr && ( "withCredentials" in xhr )
        } );
    } )( $.jqx.data.ajaxSettings.xhr() );

    if ( !$.support ) $.support = { ajax: true };
    if ( $.support.ajax ) {

        $.jqx.data.ajaxTransport( function ( s ) {
            if ( !s.crossDomain || $.support.cors ) {

                var callback;

                return {
                    send: function ( headers, complete ) {

                        var handle, i,
                            xhr = s.xhr();

                        if ( s.username ) {
                            xhr.open( s.type, s.url, s.async, s.username, s.password );
                        } else {
                            xhr.open( s.type, s.url, s.async );
                        }

                        if ( s.xhrFields ) {
                            for ( i in s.xhrFields ) {
                                xhr[ i ] = s.xhrFields[ i ];
                            }
                        }

                        if ( s.mimeType && xhr.overrideMimeType ) {
                            xhr.overrideMimeType( s.mimeType );
                        }


                        if ( !s.crossDomain && !headers[ "X-Requested-With" ] ) {
                            headers[ "X-Requested-With" ] = "XMLHttpRequest";
                        }

                        try {
                            for ( i in headers ) {
                                xhr.setRequestHeader( i, headers[ i ] );
                            }
                        } catch ( _ ) { }

                        xhr.send( ( s.hasContent && s.data ) || null );

                        callback = function ( _, isAbort ) {

                            var status,
                                statusText,
                                responseHeaders,
                                responses,
                                xml;
                            try {

                                if ( callback && ( isAbort || xhr.readyState === 4 ) ) {
                                    callback = undefined;
                                    if ( handle ) {
                                        xhr.onreadystatechange = function () { };
                                        if ( xhrOnUnloadAbort ) {
                                            delete xhrCallbacks[ handle ];
                                        }
                                    }

                                    if ( isAbort ) {
                                        if ( xhr.readyState !== 4 ) {
                                            xhr.abort();
                                        }
                                    } else {
                                        status = xhr.status;
                                        responseHeaders = xhr.getAllResponseHeaders();
                                        responses = {};
                                        xml = xhr.responseXML;

                                        if ( xml && xml.documentElement /* #4958 */ ) {
                                            responses.xml = xml;
                                        }

                                        try {
                                            responses.text = xhr.responseText;
                                        } catch ( e ) {
                                        }

                                        try {
                                            statusText = xhr.statusText;
                                        } catch ( e ) {
                                            statusText = "";
                                        }

                                        if ( !status && s.isLocal && !s.crossDomain ) {
                                            status = responses.text ? 200 : 404;
                                        } else if ( status === 1223 ) {
                                            status = 204;
                                        }
                                    }
                                }
                            } catch ( firefoxAccessException ) {
                                if ( !isAbort ) {
                                    complete( -1, firefoxAccessException );
                                }
                            }

                            if ( responses ) {
                                complete( status, statusText, responses, responseHeaders );
                            }
                        };

                        if ( !s.async ) {
                            callback();
                        } else if ( xhr.readyState === 4 ) {
                            setTimeout( callback, 0 );
                        } else {
                            handle = ++xhrId;
                            if ( xhrOnUnloadAbort ) {
                                if ( !xhrCallbacks ) {
                                    xhrCallbacks = {};
                                    $( window ).unload( xhrOnUnloadAbort );
                                }
                                xhrCallbacks[ handle ] = callback;
                            }
                            xhr.onreadystatechange = callback;
                        }
                    },

                    abort: function () {
                        if ( callback ) {
                            callback( 0, 1 );
                        }
                    }
                };
            }
        } );
    }
    $.jqx.filter = function () {
        this.operator = 'and';
        var and_operator = 0;
        var or_operator = 1;
        var stringcomparisonoperators = [ 'EMPTY', 'NOT_EMPTY', 'CONTAINS', 'CONTAINS_CASE_SENSITIVE',
            'DOES_NOT_CONTAIN', 'DOES_NOT_CONTAIN_CASE_SENSITIVE', 'STARTS_WITH', 'STARTS_WITH_CASE_SENSITIVE',
            'ENDS_WITH', 'ENDS_WITH_CASE_SENSITIVE', 'EQUAL', 'EQUAL_CASE_SENSITIVE', 'NULL', 'NOT_NULL' ];
        var numericcomparisonoperators = [ 'EQUAL', 'NOT_EQUAL', 'LESS_THAN', 'LESS_THAN_OR_EQUAL', 'GREATER_THAN', 'GREATER_THAN_OR_EQUAL', 'NULL', 'NOT_NULL' ];
        var datecomparisonoperators = [ 'EQUAL', 'NOT_EQUAL', 'LESS_THAN', 'LESS_THAN_OR_EQUAL', 'GREATER_THAN', 'GREATER_THAN_OR_EQUAL', 'NULL', 'NOT_NULL' ];
        var booleancomparisonoperators = [ 'EQUAL', 'NOT_EQUAL' ];

        var filters = new Array();
        var comparisonoperators = new Array();

        this.evaluate = function ( value ) {
            var result = true;
            for ( var i = 0; i < filters.length; i++ ) {
                var currentResult = filters[ i ].evaluate( value );
                if ( i == 0 ) {
                    result = currentResult;
                }
                else {
                    if ( comparisonoperators[ i ] == or_operator || comparisonoperators[ i ] == "or" )
                        result = result || currentResult;
                    else
                        result = result && currentResult;
                }
            }

            return result;
        }

        this.getfilterscount = function () {
            return filters.length;
        }

        this.setoperatorsbyfiltertype = function ( type, array ) {
            switch ( type ) {
                case "numericfilter":
                    numericcomparisonoperators = array;
                    break;
                case "stringfilter":
                    stringcomparisonoperators = array;
                    break;
                case "datefilter":
                    datecomparisonoperators = array;
                    break;
                case "booleanfilter":
                    booleancomparisonoperators = array;
                    break;
            }
        }

        this.getoperatorsbyfiltertype = function ( type ) {
            var array = new Array();
            switch ( type ) {
                case "numericfilter":
                    array = numericcomparisonoperators.slice( 0 );
                    break;
                case "stringfilter":
                    array = stringcomparisonoperators.slice( 0 );
                    break;
                case "datefilter":
                    array = datecomparisonoperators.slice( 0 );
                    break;
                case "booleanfilter":
                    array = booleancomparisonoperators.slice( 0 );
                    break;
            }
            return array;
        }

        var generatefilterkey = function () {
            var S4 = function () {
                return ( ( ( 1 + Math.random() ) * 0x10000 ) | 0 ).toString( 16 ).substring( 1 );
            };
            return ( S4() + "-" + S4() + "-" + S4() );
        }

        this.createfilter = function ( filtertype, filtervalue, filtercomparisonoperator, customfilter, formatstring, localization ) {
            if ( filtertype == null || filtertype == undefined )
                return null;

            switch ( filtertype ) {
                case 'numericfilter':
                    return new numericfilter( filtervalue, filtercomparisonoperator.toUpperCase() );
                case 'stringfilter':
                    return new stringfilter( filtervalue, filtercomparisonoperator.toUpperCase() );
                case 'datefilter':
                    return new datefilter( filtervalue, filtercomparisonoperator.toUpperCase(), formatstring, localization );
                case 'booleanfilter':
                    return new booleanfilter( filtervalue, filtercomparisonoperator.toUpperCase() );
                case 'custom':
                    return new filter( filtervalue, filtercomparisonoperator.toUpperCase(), customfilter );
            }

            throw new Error( "jqxGrid: There is no such filter type. The available filter types are: 'numericfilter', 'stringfilter', 'datefilter' and 'booleanfilter'" );
            return null;
        }

        this.getfilters = function () {
            var filtersarray = new Array();
            for ( var i = 0; i < filters.length; i++ ) {
                var filter = { value: filters[ i ].filtervalue, condition: filters[ i ].comparisonoperator, operator: comparisonoperators[ i ], type: filters[ i ].type };
                if ( filters[ i ].data ) {
                    filter.id = filters[ i ].data;
                }
                filtersarray[ i ] = filter;
            }
            return filtersarray;
        }

        this.addfilter = function ( comparisonoperator, filter ) {
            filters[ filters.length ] = filter;
            filter.key = generatefilterkey();
            comparisonoperators[ comparisonoperators.length ] = comparisonoperator;
        }

        this.removefilter = function ( filter ) {
            for ( var i = 0; i < filters.length; i++ ) {
                if ( filters[ i ].key == filter.key ) {
                    filters.splice( i, 1 );
                    comparisonoperators.splice( i, 1 );
                    break;
                }
            }
        }

        this.getoperatorat = function ( index ) {
            if ( index == undefined || index == null )
                return null;

            if ( index < 0 || index > filters.length )
                return null;

            return comparisonoperators[ index ];
        }

        this.setoperatorat = function ( index, comparisonoperator ) {
            if ( index == undefined || index == null )
                return null;

            if ( index < 0 || index > filters.length )
                return null;

            comparisonoperators[ comparisonoperator ] = comparisonoperator;
        }

        this.getfilterat = function ( index ) {
            if ( index == undefined || index == null )
                return null;

            if ( index < 0 || index > filters.length )
                return null;

            return filters[ index ];
        }

        this.setfilterat = function ( index, filter ) {
            if ( index == undefined || index == null )
                return null;

            if ( index < 0 || index > filters.length )
                return null;

            filter.key = generatefilterkey();
            filters[ index ] = filter;
        }

        this.clear = function () {
            filters = new Array();
            comparisonoperators = new Array();
        }

        var stringfilter = function ( filtervalue, comparisonoperator ) {
            this.filtervalue = filtervalue;
            this.comparisonoperator = comparisonoperator;
            this.type = 'stringfilter';
            this.evaluate = function ( value ) {
                var filtervalue = this.filtervalue;
                var comparisonoperator = this.comparisonoperator;
                if ( value == null || value == undefined || value == "" ) {
                    if ( comparisonoperator == 'NULL' )
                        return true;

                    if ( comparisonoperator == 'NOT_NULL' )
                        return false;

                    if ( comparisonoperator == "EQUAL" && value == filtervalue ) {
                        return true;
                    }

                    if ( comparisonoperator == "NOT_EQUAL" && value != filtervalue ) {
                        return true;
                    }

                    if ( comparisonoperator != 'EMPTY' )
                        return false;
                    else if ( value == "" )
                        return true;
                }

                var val = "";
                try {
                    val = value.toString();
                }
                catch ( error ) {
                    return true;
                }

                var compare = function ( val, filtervalue ) {
                    switch ( comparisonoperator ) {
                        case 'EQUAL':
                            return $.jqx.string.equalsIgnoreCase( val, filtervalue );
                        case 'EQUAL_CASE_SENSITIVE':
                            return $.jqx.string.equals( val, filtervalue );
                        case 'NOT_EQUAL':
                            return !$.jqx.string.equalsIgnoreCase( val, filtervalue );
                        case 'NOT_EQUAL_CASE_SENSITIVE':
                            return !$.jqx.string.equals( val, filtervalue );
                        case 'CONTAINS':
                            return $.jqx.string.containsIgnoreCase( val, filtervalue );
                        case 'CONTAINS_CASE_SENSITIVE':
                            return $.jqx.string.contains( val, filtervalue );
                        case 'DOES_NOT_CONTAIN':
                            return !$.jqx.string.containsIgnoreCase( val, filtervalue );
                        case 'DOES_NOT_CONTAIN_CASE_SENSITIVE':
                            return !$.jqx.string.contains( val, filtervalue );
                        case 'EMPTY':
                            return val == '';
                        case 'NOT_EMPTY':
                            return val != '';
                        case 'NOT_NULL':
                            return val != null;
                        case 'STARTS_WITH':
                            return $.jqx.string.startsWithIgnoreCase( val, filtervalue );
                        case 'ENDS_WITH':
                            return $.jqx.string.endsWithIgnoreCase( val, filtervalue );
                        case 'ENDS_WITH_CASE_SENSITIVE':
                            return $.jqx.string.endsWith( val, filtervalue );
                        case 'STARTS_WITH_CASE_SENSITIVE':
                            return $.jqx.string.startsWith( val, filtervalue );
                        default:
                            return false;
                    }
                }

                var filterValues = new Array();
                if ( filtervalue && filtervalue.indexO && comparisonoperator !== 'NOT_EQUAL' ) {
                    if ( filtervalue.indexOf( "|" ) >= 0 || filtervalue.indexOf( " AND " ) >= 0 || filtervalue.indexOf( " OR " ) >= 0 || filtervalue.indexOf( " and " ) >= 0 || filtervalue.indexOf( " or " ) >= 0 ) {
                        var result = compare( val, filtervalue );
                        if ( result ) {
                            return result;
                        }

                        var andFilters = filtervalue.indexOf( " AND " ) >= 0 ? filtervalue.split( " AND " ) : new Array();
                        var orFilters = filtervalue.indexOf( " OR " ) >= 0 ? filtervalue.split( " OR " ) : new Array();
                        var andLowerCaseFilters = filtervalue.indexOf( " and " ) >= 0 ? filtervalue.split( " and " ) : new Array();
                        var orLowerCaseFilters = filtervalue.indexOf( " or " ) >= 0 ? filtervalue.split( " or " ) : new Array();
                        var delimiterFilters = filtervalue.indexOf( "|" ) >= 0 ? filtervalue.split( "|" ) : new Array();
                        if ( delimiterFilters.length > 0 ) {
                            for ( var i = 0; i < delimiterFilters.length; i++ ) {
                                delimiterFilters[ i ] = $.trim( delimiterFilters[ i ] );
                            }
                        }
                        var commaFilters = filtervalue.indexOf( " " ) >= 0 ? filtervalue.split( " " ) : new Array();
                        if ( commaFilters.length > 0 ) {
                            for ( var i = 0; i < commaFilters.length; i++ ) {
                                commaFilters[ i ] = $.trim( commaFilters[ i ] );
                            }
                        }

                        andFilters = andFilters.concat( commaFilters );
                        andFilters = andFilters.concat( andLowerCaseFilters );
                        orFilters = orFilters.concat( delimiterFilters );
                        orFilters = orFilters.concat( orLowerCaseFilters );

                        if ( andFilters.length > 0 ) {
                            for ( var i = 0; i < andFilters.length; i++ ) {
                                if ( !andFilters[ i ].indexOf( " OR " ) >= 0 ) {
                                    filterValues.push( andFilters[ i ] );
                                }
                            }
                        }
                        if ( orFilters.length > 0 ) {
                            for ( var i = 0; i < orFilters.length; i++ ) {
                                if ( !orFilters[ i ].indexOf( " AND " ) >= 0 ) {
                                    filterValues.push( orFilters[ i ] );
                                }
                            }
                        }

                        var filterresult = undefined;
                        for ( var j = 0; j < filterValues.length; j++ ) {
                            var value = filterValues[ j ];
                            var result = compare( val, value );
                            var filteroperator = j < andFilters.length ? "and" : "or";
                            if ( filterresult == undefined ) {
                                filterresult = result;
                            }
                            else {
                                if ( filteroperator == 'or' ) {
                                    filterresult = filterresult || result;
                                }
                                else {
                                    filterresult = filterresult && result;
                                }
                            }
                        }
                        return filterresult;
                    }
                }

                return compare( val, filtervalue );
            }
        }

        var booleanfilter = function ( filtervalue, comparisonoperator ) {
            this.filtervalue = filtervalue;
            this.comparisonoperator = comparisonoperator;
            this.type = 'booleanfilter';
            this.evaluate = function ( value ) {
                var filtervalue = this.filtervalue;
                var comparisonoperator = this.comparisonoperator;
                if ( value == null || value == undefined ) {
                    if ( comparisonoperator == 'NULL' )
                        return true;

                    return false;
                }

                var val = value;

                switch ( comparisonoperator ) {
                    case 'EQUAL':
                        return val == filtervalue || val.toString() == filtervalue.toString();
                    case 'NOT_EQUAL':
                        return val != filtervalue && val.toString() != filtervalue.toString();
                    default:
                        return false;
                }
            }
        }

        var numericfilter = function ( filtervalue, comparisonoperator ) {
            this.filtervalue = filtervalue;
            this.comparisonoperator = comparisonoperator;
            this.type = 'numericfilter';
            this.evaluate = function ( value ) {
                var filtervalue = this.filtervalue;
                var comparisonoperator = this.comparisonoperator;
                if ( value === null || value === undefined || value === "" ) {
                    if ( comparisonoperator == 'NOT_NULL' )
                        return false;

                    if ( comparisonoperator == 'NULL' )
                        return true;
                    else {
                        switch ( comparisonoperator ) {
                            case 'EQUAL':
                                return value == filtervalue;
                            case 'NOT_EQUAL':
                                return value != filtervalue;
                        }
                        return false;
                    }
                }
                else {
                    if ( comparisonoperator == 'NULL' )
                        return false;

                    if ( comparisonoperator == 'NOT_NULL' )
                        return true;
                }

                var val = value;

                try {
                    val = parseFloat( val );
                }
                catch ( error ) {
                    if ( value.toString() != "" )
                        return false;
                }

                var compare = function ( val, filtervalue ) {
                    switch ( comparisonoperator ) {
                        case 'EQUAL':
                            return val == filtervalue;
                        case 'NOT_EQUAL':
                            return val != filtervalue;
                        case 'GREATER_THAN':
                            return val > filtervalue;
                        case 'GREATER_THAN_OR_EQUAL':
                            return val >= filtervalue;
                        case 'LESS_THAN':
                            return val < filtervalue;
                        case 'LESS_THAN_OR_EQUAL':
                            return val <= filtervalue;
                        case 'STARTS_WITH':
                            return $.jqx.string.startsWithIgnoreCase( val.toString(), filtervalue.toString() );
                        case 'ENDS_WITH':
                            return $.jqx.string.endsWithIgnoreCase( val.toString(), filtervalue.toString() );
                        case 'ENDS_WITH_CASE_SENSITIVE':
                            return $.jqx.string.endsWith( val.toString(), filtervalue.toString() );
                        case 'STARTS_WITH_CASE_SENSITIVE':
                            return $.jqx.string.startsWith( val.toString(), filtervalue.toString() );
                        case 'CONTAINS':
                            return $.jqx.string.containsIgnoreCase( val.toString(), filtervalue.toString() );
                        case 'CONTAINS_CASE_SENSITIVE':
                            return $.jqx.string.contains( val.toString(), filtervalue.toString() );
                        case 'DOES_NOT_CONTAIN':
                            return !$.jqx.string.containsIgnoreCase( val.toString(), filtervalue.toString() );
                        case 'DOES_NOT_CONTAIN_CASE_SENSITIVE':
                            return !$.jqx.string.contains( val.toString(), filtervalue.toString() );
                        default:
                            return true;
                    }
                }

                var filterValues = new Array();

                if ( filtervalue && filtervalue.indexOf )
                    filtervalue = filtervalue.replace( '$', '' );

                if ( filtervalue && filtervalue.indexOf && ( filtervalue.indexOf( "|" ) >= 0 || filtervalue.indexOf( " AND " ) >= 0 || filtervalue.indexOf( " OR " ) >= 0 || filtervalue.indexOf( " and " ) >= 0 || filtervalue.indexOf( " or " ) >= 0 ) ) {
                    var result = compare( val, filtervalue );
                    if ( result ) {
                        return result;
                    }
                    filtervalue = filtervalue.toString();
                    var andFilters = filtervalue.indexOf( " AND " ) >= 0 ? filtervalue.split( " AND " ) : new Array();
                    var orFilters = filtervalue.indexOf( " OR " ) >= 0 ? filtervalue.split( " OR " ) : new Array();
                    var andLowerCaseFilters = filtervalue.indexOf( " and " ) >= 0 ? filtervalue.split( " and " ) : new Array();
                    var orLowerCaseFilters = filtervalue.indexOf( " or " ) >= 0 ? filtervalue.split( " or " ) : new Array();
                    andFilters = andFilters.concat( andLowerCaseFilters );
                    orFilters = orFilters.concat( orLowerCaseFilters );
                    var delimiterFilters = filtervalue.indexOf( "|" ) >= 0 ? filtervalue.split( "|" ) : new Array();
                    if ( delimiterFilters.length > 0 ) {
                        for ( var i = 0; i < delimiterFilters.length; i++ ) {
                            delimiterFilters[ i ] = $.trim( delimiterFilters[ i ] );
                        }
                    }
                    orFilters = orFilters.concat( delimiterFilters );

                    if ( andFilters.length > 0 ) {
                        for ( var i = 0; i < andFilters.length; i++ ) {
                            if ( !andFilters[ i ].indexOf( " OR " ) >= 0 ) {
                                filterValues.push( andFilters[ i ] );
                            }
                        }
                    }
                    if ( orFilters.length > 0 ) {
                        for ( var i = 0; i < orFilters.length; i++ ) {
                            if ( !orFilters[ i ].indexOf( " AND " ) >= 0 ) {
                                filterValues.push( orFilters[ i ] );
                            }
                        }
                    }

                    var filterresult = undefined;
                    for ( var j = 0; j < filterValues.length; j++ ) {
                        var value = filterValues[ j ];

                        if ( value && value.indexOf && value.indexOf( ".." ) >= 0 ) {
                            var values = value.toString().split( ".." );
                            if ( values.length == 2 ) {
                                result = val >= values[ 0 ] && val <= values[ 1 ];
                            }
                        }
                        else {
                            var result = compare( val, value );
                        }
                        var filteroperator = j < andFilters.length ? "and" : "or";
                        if ( filterresult == undefined ) {
                            filterresult = result;
                        }
                        else {
                            if ( filteroperator == 'or' ) {
                                filterresult = filterresult || result;
                            }
                            else {
                                filterresult = filterresult && result;
                            }
                        }
                    }
                    return filterresult;
                }
                if ( filtervalue && filtervalue.indexOf && filtervalue.indexOf( ".." ) >= 0 ) {
                    filterValues = filtervalue.toString().split( ".." );
                    if ( filterValues.length == 2 ) {
                        return val >= filterValues[ 0 ] && val <= filterValues[ 1 ];
                    }
                }
                return compare( val, filtervalue );
            }
        }

        var datefilter = function ( filtervalue, comparisonoperator, formatstring, localization ) {
            this.filtervalue = filtervalue;
            this.type = 'datefilter';
            var that = this;
            if ( formatstring != undefined && localization != undefined ) {
                var parsedDate = $.jqx.dataFormat.parsedate( filtervalue, formatstring, localization );
                if ( parsedDate != null ) {
                    this.filterdate = parsedDate;
                }
                else {
                    var result = $.jqx.dataFormat.tryparsedate( filtervalue, localization );
                    if ( result != null ) this.filterdate = result;
                }

            }
            else {
                var tmpvalue = new Date( filtervalue );
                if ( tmpvalue.toString() == 'NaN' || tmpvalue.toString() == "Invalid Date" ) {
                    this.filterdate = $.jqx.dataFormat.tryparsedate( filtervalue );
                }
                else {
                    this.filterdate = tmpvalue;
                }
            }
            if ( !this.filterdate ) {
                var tmpvalue = new Date( filtervalue );
                if ( tmpvalue.toString() == 'NaN' || tmpvalue.toString() == "Invalid Date" ) {
                    this.filterdate = $.jqx.dataFormat.tryparsedate( filtervalue );
                }
                else {
                    this.filterdate = tmpvalue;
                }
            }

            this.comparisonoperator = comparisonoperator;
            this.evaluate = function ( value ) {
                var filtervalue = this.filtervalue;
                var comparisonoperator = this.comparisonoperator;
                if ( value == null || value == undefined || value == "" ) {
                    if ( comparisonoperator == 'NOT_NULL' )
                        return false;

                    if ( comparisonoperator == 'NULL' )
                        return true;
                    else {
                        switch ( comparisonoperator ) {
                            case 'EQUAL':
                                return value == filtervalue;
                            case 'NOT_EQUAL':
                                return value != filtervalue;
                        }
                        return false;
                    }
                }
                else {
                    if ( comparisonoperator == 'NULL' )
                        return false;

                    if ( comparisonoperator == 'NOT_NULL' )
                        return true;
                }

                var val = new Date();
                val.setFullYear( 1900, 0, 1 );
                val.setHours( 12, 0, 0, 0 );
                try {
                    var tmpvalue = new Date( value );

                    if ( tmpvalue.toString() == 'NaN' || tmpvalue.toString() == "Invalid Date" ) {
                        value = $.jqx.dataFormat.tryparsedate( value );
                    }
                    else {
                        value = tmpvalue;
                    }

                    val = value;

                    var compareTimePart = false;
                    if ( formatstring != undefined && localization != undefined ) {
                        if ( formatstring.indexOf( 't' ) >= 0 || formatstring.indexOf( 'T' ) >= 0 || formatstring.indexOf( ':' ) >= 0 || formatstring.indexOf( 'f' ) >= 0 ) {
                            compareTimePart = true;
                            if ( filtervalue && filtervalue.toString().indexOf( ':' ) == -1 ) {
                                var result = $.jqx.dataFormat.tryparsedate( filtervalue.toString() + ":00", localization );
                                if ( result != null ) that.filterdate = result;
                            }
                        }
                    }
                    if ( formatstring != undefined ) {
                        if ( formatstring.indexOf( 'hh' ) >= 0 || formatstring.indexOf( 't' ) >= 0 ) {
                            compareTimePart = true;
                        }
                    }

                    if ( !compareTimePart ) {
                        val.setHours( 0 );
                        val.setMinutes( 0 );
                        val.setSeconds( 0 );
                    }
                }
                catch ( error ) {
                    if ( value && value.toString() != "" )
                        return false;
					
					return false;
                }

                if ( that.filterdate != null ) {
                    filtervalue = that.filterdate;
                }
                else {
                    if ( filtervalue && filtervalue.indexOf ) {
                        if ( filtervalue.indexOf( ':' ) != -1 || !isNaN( parseInt( filtervalue ) ) ) {
                            var tmpFilter = new Date( val );
                            tmpFilter.setHours( 12, 0, 0, 0 );
                            var timeStrings = filtervalue.split( ':' );
                            for ( var i = 0; i < timeStrings.length; i++ ) {
                                if ( i == 0 ) {
                                    tmpFilter.setHours( timeStrings[ i ] );
                                }
                                if ( i == 1 ) {
                                    tmpFilter.setMinutes( timeStrings[ i ] );
                                }
                                if ( i == 2 ) {
                                    tmpFilter.setSeconds( timeStrings[ i ] );
                                }
                            }
                            filtervalue = tmpFilter;
                        }
                    }
                }
                if ( compareTimePart ) {
                    if ( filtervalue && filtervalue.setFullYear ) {
                        if ( val && val.getFullYear ) {
                            if ( formatstring.indexOf( 'd' ) == -1 && formatstring.indexOf( 'M' ) == -1 && formatstring.indexOf( 'y' ) == -1 ) {
                                filtervalue.setFullYear( val.getFullYear(), val.getMonth(), val.getDate() );
                            }
                        }
                    }
                }


                var compare = function ( val, filtervalue ) {
                    if ( val == null ) val = "";
                    switch ( comparisonoperator ) {
                        case 'EQUAL':
                            return val.toString() == filtervalue.toString();
                        case 'NOT_EQUAL':
                            return val.toString() != filtervalue.toString();
                        case 'GREATER_THAN':
                            return val > filtervalue;
                        case 'GREATER_THAN_OR_EQUAL':
                            return val >= filtervalue;
                        case 'LESS_THAN':
                            return val < filtervalue;
                        case 'LESS_THAN_OR_EQUAL':
                            return val <= filtervalue;
                        case 'STARTS_WITH':
                            return $.jqx.string.startsWithIgnoreCase( val.toString(), filtervalue.toString() );
                        case 'ENDS_WITH':
                            return $.jqx.string.endsWithIgnoreCase( val.toString(), filtervalue.toString() );
                        case 'ENDS_WITH_CASE_SENSITIVE':
                            return $.jqx.string.endsWith( val.toString(), filtervalue.toString() );
                        case 'STARTS_WITH_CASE_SENSITIVE':
                            return $.jqx.string.startsWith( val.toString(), filtervalue.toString() );
                        case 'CONTAINS':
                            return $.jqx.string.containsIgnoreCase( val.toString(), filtervalue.toString() );
                        case 'CONTAINS_CASE_SENSITIVE':
                            return $.jqx.string.contains( val.toString(), filtervalue.toString() );
                        case 'DOES_NOT_CONTAIN':
                            return !$.jqx.string.containsIgnoreCase( val.toString(), filtervalue.toString() );
                        case 'DOES_NOT_CONTAIN_CASE_SENSITIVE':
                            return !$.jqx.string.contains( val.toString(), filtervalue.toString() );
                        default:
                            return true;
                    }
                }
                var filterValues = new Array();
                if ( filtervalue && filtervalue.indexOf )
                    if ( filtervalue.indexOf( "|" ) >= 0 || filtervalue.indexOf( " AND " ) >= 0 || filtervalue.indexOf( " OR " ) >= 0 || filtervalue.indexOf( " and " ) >= 0 || filtervalue.indexOf( " or " ) >= 0 ) {
                        var result = compare( val, filtervalue );
                        if ( result ) {
                            return result;
                        }
                        var andFilters = filtervalue.indexOf( " AND " ) >= 0 ? filtervalue.split( " AND " ) : new Array();
                        var orFilters = filtervalue.indexOf( " OR " ) >= 0 ? filtervalue.split( " OR " ) : new Array();
                        var andLowerCaseFilters = filtervalue.indexOf( " and " ) >= 0 ? filtervalue.split( " and " ) : new Array();
                        var orLowerCaseFilters = filtervalue.indexOf( " or " ) >= 0 ? filtervalue.split( " or " ) : new Array();
                        andFilters = andFilters.concat( andLowerCaseFilters );
                        orFilters = orFilters.concat( orLowerCaseFilters );
                        var delimiterFilters = filtervalue.indexOf( "|" ) >= 0 ? filtervalue.split( "|" ) : new Array();
                        if ( delimiterFilters.length > 0 ) {
                            for ( var i = 0; i < delimiterFilters.length; i++ ) {
                                delimiterFilters[ i ] = $.trim( delimiterFilters[ i ] );
                            }
                        }
                        orFilters = orFilters.concat( delimiterFilters );

                        if ( andFilters.length > 0 ) {
                            for ( var i = 0; i < andFilters.length; i++ ) {
                                if ( !andFilters[ i ].indexOf( " OR " ) >= 0 ) {
                                    filterValues.push( andFilters[ i ] );
                                }
                            }
                        }
                        if ( orFilters.length > 0 ) {
                            for ( var i = 0; i < orFilters.length; i++ ) {
                                if ( !orFilters[ i ].indexOf( " AND " ) >= 0 ) {
                                    filterValues.push( orFilters[ i ] );
                                }
                            }
                        }

                        var filterresult = undefined;
                        for ( var j = 0; j < filterValues.length; j++ ) {
                            var value = filterValues[ j ];
                            if ( value && value.indexOf && value.indexOf( ".." ) >= 0 ) {
                                var values = value.toString().split( ".." );
                                if ( values.length == 2 ) {
                                    result = val >= values[ 0 ] && val <= values[ 1 ];
                                }
                            }
                            else {
                                var result = compare( val, value );
                            }
                            var filteroperator = j < andFilters.length ? "and" : "or";
                            if ( filterresult == undefined ) {
                                filterresult = result;
                            }
                            else {
                                if ( filteroperator == 'or' ) {
                                    filterresult = filterresult || result;
                                }
                                else {
                                    filterresult = filterresult && result;
                                }
                            }
                        }
                        return filterresult;
                    }
                if ( filtervalue && filtervalue.indexOf && filtervalue.indexOf( ".." ) >= 0 ) {
                    filterValues = filtervalue.toString().split( ".." );
                    if ( filterValues.length == 2 ) {
                        return val >= filterValues[ 0 ] && val <= filterValues[ 1 ];
                    }
                }
                return compare( val, filtervalue );
            }
        }

        var filter = function ( filtervalue, comparisonoperator, customfilter ) {
            this.filtervalue = filtervalue;
            this.comparisonoperator = comparisonoperator;
            this.evaluate = function ( value, comparisonoperator ) {
                return customfilter( this.filtervalue, value, this.comparisonoperator );
            }
        }
    }
} )( jqxBaseFramework );
})();



/***/ }),

/***/ 714:
/***/ (() => {

﻿/* tslint:disable */
/* eslint-disable */
(function () {
    if (typeof document === 'undefined') {
        return;
    }

    (function ($) {
        window.jqxToDash = function (value) {
            return value.split(/(?=[A-Z])/).join('-').toLowerCase();
        }

        var LINE_SEPARATOR2 = "\r\n";
        function returnAttributeIfPopulated(key, value, booleanTransformer) {
            if (!value && value !== "" && value !== 0) {
                return "";
            }
            let xmlValue = value;
            if (typeof value === "boolean") {
                if (booleanTransformer) {
                    xmlValue = booleanTransformer(value);
                }
            }
            return ` ${key}="${xmlValue}"`;
        }

        var XmlFactory = class {
            static createHeader(headerElement = {}) {
                const headerStart = "<?";
                const headerEnd = "?>";
                const keys = ["version"];
                if (!headerElement.version) {
                    headerElement.version = "1.0";
                }
                if (headerElement.encoding) {
                    keys.push("encoding");
                }
                if (headerElement.standalone) {
                    keys.push("standalone");
                }
                const att = keys.map((key) => `${key}="${headerElement[key]}"`).join(" ");
                return `${headerStart}xml ${att} ${headerEnd}`;
            }
            static createXml(xmlElement, booleanTransformer) {
                let props = "";
                if (xmlElement.properties) {
                    if (xmlElement.properties.prefixedAttributes) {
                        xmlElement.properties.prefixedAttributes.forEach((prefixedSet) => {
                            Object.keys(prefixedSet.map).forEach((key) => {
                                props += returnAttributeIfPopulated(
                                    prefixedSet.prefix + key,
                                    prefixedSet.map[key],
                                    booleanTransformer
                                );
                            });
                        });
                    }
                    if (xmlElement.properties.rawMap) {
                        Object.keys(xmlElement.properties.rawMap).forEach((key) => {
                            props += returnAttributeIfPopulated(key, xmlElement.properties.rawMap[key], booleanTransformer);
                        });
                    }
                }
                let result = "<" + xmlElement.name + props;
                if (!xmlElement.children && xmlElement.textNode == null) {
                    return result + "/>" + LINE_SEPARATOR2;
                }
                if (xmlElement.textNode != null) {
                    return result + ">" + xmlElement.textNode + "</" + xmlElement.name + ">" + LINE_SEPARATOR2;
                }
                result += ">" + LINE_SEPARATOR2;
                if (xmlElement.children) {
                    xmlElement.children.forEach((it) => {
                        result += this.createXml(it, booleanTransformer);
                    });
                }
                return result + "</" + xmlElement.name + ">" + LINE_SEPARATOR2;
            }
        };

        class DataExporter {
            constructor(exportDetails, groupBy, filterBy, conditionalFormatting) {
                const that = this;

                if (!exportDetails) {
                    exportDetails = {};
                }

                /*
                 * "style" object definition (all properties are optional):
                 *
                 * «any valid CSS property» - applied to whole table
                 * header (Object)
                 *      «any valid CSS property» - applied to header cells
                 *      «any column name» (Object)
                 *          «any valid CSS property» - applied to particular column header cell
                 * columns (Object)
                 *      «any valid CSS property» - applied to column cells
                 *      «any column name» (Object)
                 *          «any valid CSS property» - applied to the cells of particular column
                 *          format - applicable to numeric and date columns
                 *          «n» (Object), where «n» is a row index (related to use of "ConditionalFormatting" object)
                 *              background
                 *              border
                 *              color
                 * rows (Object)
                 *      «any valid CSS property» - applied to rows
                 *      alternationCount
                 *      alternationStart
                 *      alternationEnd
                 *      alternationIndex«n»Color, where «n» is an integer
                 *      alternationIndex«n»BorderColor, where «n» is an integer
                 *      alternationIndex«n»BackgroundColor, where «n» is an integer
                 *      «n» (Object), where «n» is a row index
                 *          «any valid CSS property» - applied to particular row
                 */
                that.style = exportDetails.style;

                that.header = exportDetails.header;
                that.exportHeader = exportDetails.exportHeader !== undefined ? exportDetails.exportHeader : true;
                that.hierarchical = exportDetails.hierarchical;
                that.expandChar = exportDetails.expandChar || '+';
                that.collapseChar = exportDetails.collapseChar || '-';
                that.pageOrientation = exportDetails.pageOrientation;
                that.allowNull = exportDetails.allowNull || false;
                that.spreadsheets = exportDetails.spreadsheets || null;

                that._media = [];

                if (!that.hierarchical && groupBy && groupBy.length > 0) {
                    that.groupBy = groupBy;
                }
                else {
                    that.mergedCells = exportDetails.mergedCells;
                }

                if (!that.groupBy && filterBy && Object.keys(filterBy).length > 0) {
                    that.filterBy = filterBy;
                }

                if (conditionalFormatting) {
                    that.conditionalFormatting = conditionalFormatting;
                }

                that.timeBetween1900And1970 = new Date(1970, 0, 1, 0, 0, 0).getTime() - new Date(1900, 0, 1, 0, 0, 0).getTime();
            }

            /**
             * Generates and downloads a file.
             */
            downloadFile(data, type, fileName) {
                let file;

                if (!fileName) {
                    return data;
                }

                if (data instanceof Blob) {
                    file = data;
                }
                else {
                    file = new Blob([data], { type: type });
                }

                if (window.navigator.msSaveOrOpenBlob) { // Edge
                    window.navigator.msSaveOrOpenBlob(file, fileName);
                }
                else { // Chrome, Firefox, Safari
                    const a = document.createElement('a'),
                        url = URL.createObjectURL(file);

                    a.href = url;
                    a.download = fileName;
                    a.style.position = 'absolute';
                    a.style.visibility = 'hidden';

                    document.body.appendChild(a);

                    a.click();

                    setTimeout(function () {
                        document.body.removeChild(a);
                        window.URL.revokeObjectURL(url);
                    }, 100);
                }
            }

            /**
             * Exports data.
             */
            exportData(data, format, fileName, callback) {
                const that = this;

                that.actualHierarchy = that.hierarchical;
                format = format.toLowerCase();

                if (that.exportHeader) {
                    if (that.header) {
                        data = data.slice(0);

                        if (data.length === 0) {
                            that.actualHierarchy = false;
                        }

                        that.processComplexHeader(that.header, data, format);
                    }
                    else if (data.length === 1) {
                        that.actualHierarchy = false;
                    }
                }

                if (data.length === 0) {
                    // eslint-disable-next-line
                    console.warn('No data to export.');
                    return;
                }

                if (format === 'xlsx') {
                    that.xlsxStartIndex = that.complexHeader ? that.complexHeader.length : +that.exportHeader;

                    const offset = that.headerContent ? that.headerContent.length : 0;
                    that.xlsxStartIndex = that.xlsxStartIndex + offset;
                }

                if (that.actualHierarchy) {
                    data = that.processHierarchicalData(data, format);
                }

                that.getDatafields(data);

                if (fileName && fileName.slice(fileName.length - format.length - 1, fileName.length) !== '.' + format) {
                    fileName += '.' + format;
                }

                let output = null;
                switch (format) {
                    case 'csv':
                        output = that.exportToCSVAndTSV(data, { delimiter: ', ', MIME: 'text/csv;charset=utf-8;', toRemove: 2 }, fileName);
                        break;
                    case 'html':
                        output = that.exportToHTML(data, fileName);
                        break;
                    case 'jpeg':
                    case 'png':
                        that.exportToImage(data, fileName, format, callback);
                        break;
                    case 'json':
                        output = that.exportToJSON(data, fileName);
                        break;
                    case 'pdf':
                        output = that.exportToPDF(data, fileName);
                        break;
                    case 'tsv':
                        output = that.exportToCSVAndTSV(data, { delimiter: '\t', MIME: 'text/tab-separated-values', toRemove: 1 }, fileName);
                        break;
                    case 'xlsx':
                        output = that.exportToXLSX(data, fileName, callback);
                        break;
                    case 'xml':
                        output = that.exportToXML(data, fileName);
                        break;
                    case 'md':
                        output = that.exportToMD(data, fileName);
                        break;
                }

                if (callback && output) {
                    callback(output);
                }

                delete that.complexHeader;

                return output;
            }

            /**
             * Exports to CSV and TSV.
             */
            exportToCSVAndTSV(data, formatOptions, fileName) {
                const that = this,
                    datafields = that.datafields;
                let stringResult = '';

                for (let i = 0; i < data.length; i++) {
                    const currentRecord = data[i];
                    let stringifiedCurrentRecord = '';

                    for (let j = 0; j < datafields.length; j++) {
                        if (that.actualHierarchy && j === 0) {
                            stringifiedCurrentRecord += ('""' + formatOptions.delimiter).repeat(currentRecord._level - 1) +
                                '"' + currentRecord[datafields[j]] + '"' + formatOptions.delimiter +
                                ('""' + formatOptions.delimiter).repeat(that.maxLevel - currentRecord._level);
                            continue;
                        }

                        stringifiedCurrentRecord += '"' + currentRecord[datafields[j]] + '"' + formatOptions.delimiter;
                    }

                    stringifiedCurrentRecord = stringifiedCurrentRecord.slice(0, stringifiedCurrentRecord.length - formatOptions.toRemove) + '\n';
                    stringResult += stringifiedCurrentRecord;
                }

                if (!fileName) {
                    return stringResult;
                }

                const bom = '\uFEFF';
                const csvContent = bom + stringResult;
                return this.downloadFile(csvContent, formatOptions.MIME, fileName);
            }

            /**
             * Exports to HTML.
             */
            exportToHTML(data, fileName) {
                const that = this,
                    datafields = that.datafields,
                    style = that.style;
                let header = '',
                    startIndex = 0,
                    html2canvas = '';

                data = that.processGroupingInformation(data);
                that.data = data;

                if (that.exportHeader) {
                    header = that.getHTMLHeader(datafields, data);
                    startIndex = 1;
                }

                if (arguments[2]) {
                    const scripts = Array.from(document.getElementsByTagName('script')),
                        html2canvasScript = scripts.find(script => script.src.indexOf('html2canvas') !== -1);
                    html2canvas = `<script type="text/javascript" src="${html2canvasScript.src}"></script>`;
                }

                let htmlContent = `<!DOCTYPE html>
    <html>
    <head>
        <meta charset="UTF-8">
        <style type="text/css">
    ${that.getRowStyle()}${that.getColumnStyle()}
        </style>${html2canvas}${that.toggleableFunctionality()}
    </head>
    <body>
        <table${that.getTableStyle()}>${header}
            <tbody>\n`;

                const mergedMainCells = {},
                    mergedSecondaryCells = {},
                    groupsHandled = [];

                that.getMergedCellsInfo(mergedMainCells, mergedSecondaryCells);

                mainLoop:
                for (let i = startIndex; i < data.length; i++) {
                    const currentRecord = data[i],
                        row = i - startIndex;
                    let n = that.getAlternationIndex(row, ' rowN'),
                        toCollapse = '',
                        level = '',
                        groupId = '',
                        outlineLevel = 0;

                    if (that.actualHierarchy) {
                        if (currentRecord._collapsed) {
                            toCollapse = ' collapsed';
                        }

                        level = ` level="${currentRecord._level}"`;
                    }
                    else if (that.groupBy) {
                        for (let k = 0; k < that.groupBy.length; k++) {
                            const datafield = that.groupBy[k],
                                currentGroup = currentRecord[datafield],
                                currentGroupLabel = that.groups[datafield][currentGroup];

                            groupId += currentGroup;

                            if (groupsHandled.indexOf(groupId) === -1) {
                                htmlContent += `            <tr class="row">
                    <td class="column group" style="padding-left: ${outlineLevel * 25}px;" colspan="${that.datafields.length}">${currentGroupLabel}</td>
                </tr>`;
                                groupsHandled.push(groupId);
                                i--;
                                continue mainLoop;
                            }

                            outlineLevel++;
                        }
                    }

                    let currentContent = `            <tr class="row row${row}${n}${toCollapse}"${level}`;

                    if (!fileName) {
                        currentContent += ' style="page-break-inside: avoid;"'
                    }

                    currentContent += '>\n';

                    for (let j = 0; j < datafields.length; j++) {
                        const cellCode = j + ',' + (row);
                        let colspan = 1, rowspan = 1;

                        if (mergedMainCells[cellCode]) {
                            colspan = mergedMainCells[cellCode].colspan;
                            rowspan = mergedMainCells[cellCode].rowspan;
                        }
                        else if (mergedSecondaryCells[cellCode]) {
                            continue;
                        }

                        const datafield = datafields[j];
                        let value = currentRecord[datafield],
                            indent = '';

                        if (that.actualHierarchy && j === 0) {
                            let sign = '';

                            if (currentRecord._expanded) {
                                sign = that.collapseChar;
                            }
                            else if (currentRecord._expanded === false) {
                                sign = that.expandChar;
                            }

                            indent = `<div class="toggle-element" style="margin-left: ${25 * (currentRecord._level - 1) + 5}px;" expanded>${sign}</div>`;
                        }

                        value = that.getFormattedValue(value, datafield);

                        if (typeof value === 'string' && (value.indexOf('base64') >= 0 || value.indexOf('.svg') >= 0 || value.indexOf('.png') >= 0 || value.indexOf('.jpeg') >= 0)) {
                            value = `<img height="30" src="${value}"/>`;
                        }

                        let css = '';

                        if (style && style.columns && style.columns[datafield] && style.columns[datafield][row]) {
                            const uniqueStyle = style.columns[datafield][row];

                            css += `border-color: ${uniqueStyle.border}; background-color: ${uniqueStyle.background}; color: ${uniqueStyle.color};"`;
                        }

                        if (j === 0 && outlineLevel > 1) {
                            css += `padding-left: ${(outlineLevel - 1) * 25}px;"`;
                        }

                        if (css) {
                            css = ` style="${css}"`;
                        }

                        currentContent += `                <td class="column column${datafield}"${css} colspan="${colspan}" rowspan="${rowspan}">${indent + value}</td>\n`;
                    }

                    htmlContent += currentContent + '            </tr>\n';
                }

                htmlContent += `        </tbody>
        </table>
    </body>
    </html>`;

                if (arguments[2]) {
                    return htmlContent;
                }

                return this.downloadFile(htmlContent, 'text/html', fileName);
            }

            /**
             * Exports to an image (PNG/JPEG).
             */
            exportToImage(data, fileName, fileExtension, callback) {
                const that = this;

                try {
                    html2canvas;
                }
                catch (error) {
                    throw new Error('jqx-grid: Missing reference to \'html2canvas.min.js\'.');
                }

                let imageData = null;

                const htmlContent = that.exportToHTML(data, fileName, true),
                    iframe = document.createElement('iframe');

                iframe.style.position = 'absolute';
                iframe.style.top = 0;
                iframe.style.left = 0;
                iframe.style.border = 'none';
                iframe.style.width = '100%';
                iframe.style.height = '100%';
                iframe.style.opacity = 0;
                iframe.style.pointerEvents = 'none';

                document.body.appendChild(iframe);

                iframe.contentDocument.write(htmlContent);

                function checkIframePopulated() {
                    if (!iframe.contentDocument.body || !iframe.contentDocument.body.firstElementChild) {
                        requestAnimationFrame(checkIframePopulated);
                    }
                    else {
                        iframe.contentWindow.html2canvas(iframe.contentDocument.body.firstElementChild).then(canvas => {
                            const draw = new JQX.Utilities.Draw(document.createElement('div'));

                            imageData = canvas.toDataURL('image/png');

                            if (callback) {
                                callback(imageData);
                            }
                            else {
                                document.body.appendChild(canvas);
                                draw.exportImage(undefined, canvas, fileExtension, fileName);
                            }

                            iframe.remove();
                            canvas.remove();
                        });
                    }
                }

                checkIframePopulated();

                return imageData;
            }

            /**
             * Gets merged cells information (for use in HTML and PDF export).
             */
            getMergedCellsInfo(mergedMainCells, mergedSecondaryCells, mapping) {
                const that = this;

                if (!that.mergedCells) {
                    return;
                }

                const multipleTables = mapping && mapping[that.datafields.length - 1] !== 0;

                that.mergedCellsPDF = that.mergedCells.slice(0);

                for (let i = 0; i < that.mergedCellsPDF.length; i++) {
                    const cellDefinition = that.mergedCellsPDF[i];
                    let colspan = cellDefinition.colspan,
                        rowspan = cellDefinition.rowspan;

                    if (rowspan < 2 && colspan < 2) {
                        continue;
                    }

                    const row = cellDefinition.cell[1];
                    let col = cellDefinition.cell[0];

                    if (multipleTables && colspan > 1) {
                        const startTable = mapping[col],
                            endTable = mapping[col + colspan - 1],
                            splitCells = [];

                        if (endTable > startTable) {
                            let currentTable = startTable,
                                currentColumn = col,
                                overal = 0;

                            mainLoop:
                            for (let i = startTable; i <= endTable; i++) {
                                let start = currentColumn,
                                    span = 0;

                                while (mapping[currentColumn] === currentTable) {
                                    currentColumn++;
                                    overal++;
                                    span++;

                                    if (overal === colspan) {
                                        splitCells.push({ start: start, span: span });
                                        break mainLoop;
                                    }
                                }

                                splitCells.push({ start: start, span: span });
                                currentTable = mapping[currentColumn];
                            }

                            colspan = splitCells[0].span;

                            for (let i = 1; i < splitCells.length; i++) {
                                that.mergedCellsPDF.push({ cell: [splitCells[i].start, row], colspan: splitCells[i].span, rowspan: rowspan, originalCell: col });
                            }
                        }
                    }

                    for (let j = col; j < col + colspan; j++) {
                        for (let k = row; k < row + rowspan; k++) {
                            const code = j + ',' + k;

                            if (j === col && k === row) {
                                mergedMainCells[code] = { colspan: colspan, rowspan: rowspan, originalCell: cellDefinition.originalCell };
                                continue;
                            }

                            mergedSecondaryCells[code] = true;
                        }
                    }
                }
            }

            /**
             * Gets alternation index.
             */
            getAlternationIndex(row, prefix) {
                const that = this;

                if (!that.style) {
                    return '';
                }

                const rowsDefinition = that.style.rows,
                    alternationCount = rowsDefinition && rowsDefinition.alternationCount;

                if (alternationCount &&
                    (((rowsDefinition.alternationStart === undefined || row >= rowsDefinition.alternationStart) &&
                        (rowsDefinition.alternationEnd === undefined || row <= rowsDefinition.alternationEnd)) ||
                        rowsDefinition.alternationStart === rowsDefinition.alternationEnd)) {
                    return prefix + (row % rowsDefinition.alternationCount);
                }

                return '';
            }

            /**
             * Gets formatted numeric or date value (for use in HTML and PDF export).
             */
            getFormattedValue(value, datafield) {
                const that = this,
                    style = that.style;

                if (value === null) {
                    return that.allowNull ? 'null' : '';
                }

                if (datafield && style && style.columns &&
                    style.columns[datafield] && style.columns[datafield].format) {
                    if (typeof value === 'number') {
                        return that.formatNumber(value, style.columns[datafield].format);
                    }
                    else if (value instanceof Date) {
                        return that.formatDate(value, style.columns[datafield].format);
                    }
                }
                else if (value instanceof Date) {
                    return that.formatDate(value, 'd');
                }

                return value;
            }

            /**
             * Exports to JSON.
             */
            exportToJSON(data, fileName) {
                return this.downloadFile(JSON.stringify(data, this.datafields.concat('rows')), 'application/json', fileName);
            }

            /**
             * Export to Markdown(MD)
             * @param {string} data - the data to export
             * @param {string} fileName - the name of the file
             * @returns 
             */
            exportToMD(data, fileName) {
                const that = this,
                    dataFields = that.datafields;
                let text = '';


                for (let i = 0, max = data.length; i < max; i += 1) {
                    for (let j = 0, max = dataFields.length; j < max; j += 1) {
                        const dataField = data[i][dataFields[j]];

                        if (typeof dataField === 'string') {
                            text += dataField;
                        }
                    }
                }

                return that.downloadFile(text, 'application/text', fileName);
            }

            /**
             * Exports to PDF.
             */
            exportToPDF(data, fileName) {
                try {
                    pdfMake;
                }
                catch (error) {
                    throw new Error('Missing reference to \'pdfmake.min.js\'.');
                }

                const that = this,
                    datafields = that.datafields,
                    startIndex = +that.exportHeader,
                    groupsHandled = [],
                    mergedMainCells = {},
                    mergedSecondaryCells = {},
                    mapping = {},
                    headerRows = startIndex ? that.complexHeader ? that.complexHeader.length : 1 : 0,
                    docDefinition = {
                        pageOrientation: that.pageOrientation || 'portrait'
                    };
                let header = [], content = [], tables;

                function createTableRow() {
                    let tableRow = [];

                    for (let i = 0; i < tables.length; i++) {
                        tableRow.push([]);
                    }

                    return tableRow;
                }

                data = that.processGroupingInformation(data);
                that.data = data;
                that.headerRows = headerRows;
                that.getPDFStyle();

                const styleInfo = that.styleInfo;

                tables = styleInfo ? that.wrapPDFColumns(docDefinition, mapping) : [{ body: header, datafields: datafields }];

                if (startIndex) {
                    header = that.getPDFHeader(datafields, tables, mapping);
                }

                that.getMergedCellsInfo(mergedMainCells, mergedSecondaryCells, mapping);

                mainLoop:
                for (let i = startIndex; i < data.length; i++) {
                    const currentRecord = data[i];
                    let groupId = '',
                        outlineLevel = 0;

                    if (that.groupBy) {
                        for (let k = 0; k < that.groupBy.length; k++) {
                            const datafield = that.groupBy[k],
                                currentGroup = currentRecord[datafield],
                                currentGroupLabel = that.groups[datafield][currentGroup];

                            groupId += currentGroup;

                            if (groupsHandled.indexOf(groupId) === -1) {
                                that.createGroupHeaderRow(tables, { text: currentGroupLabel, style: ['row', 'cell', 'group'], marginLeft: outlineLevel * 7.5 });
                                groupsHandled.push(groupId);
                                i--;
                                continue mainLoop;
                            }

                            outlineLevel++;
                        }
                    }

                    const tableRow = createTableRow(),
                        row = i - startIndex;
                    let n = that.getAlternationIndex(row, '');

                    for (let j = 0; j < datafields.length; j++) {
                        const datafield = datafields[j],
                            entry = { style: ['row', 'row' + row, 'cell', 'cell' + datafield] },
                            tableIndex = mapping[j] || 0;

                        if (n !== undefined) {
                            entry.style.splice(1, 0, 'rowN' + n);
                        }

                        if (that.mergedCellsPDF) {
                            const cellCode = j + ',' + row,
                                mergeInfo = mergedMainCells[cellCode];

                            if (mergeInfo) {
                                entry.colSpan = mergeInfo.colspan;
                                entry.rowSpan = mergeInfo.rowspan;

                                if (mergeInfo.originalCell !== undefined) {
                                    entry.text = '';
                                    entry.style[entry.style.length - 1] = 'cell' + datafields[mergeInfo.originalCell];
                                    tableRow[tableIndex].push(entry);
                                    continue;
                                }
                            }
                            else if (mergedSecondaryCells[cellCode]) {
                                tableRow[tableIndex].push({});
                                continue;
                            }
                        }

                        const value = that.getFormattedValue(currentRecord[datafield], datafield);

                        entry.text = value.toString();
                        that.getUniqueStylePDF(entry, datafield, row);
                        that.setIndentation(entry, { j: j, currentRecord: currentRecord, value: value, outlineLevel: outlineLevel });
                        tableRow[tableIndex].push(entry);
                    }

                    for (let k = 0; k < tables.length; k++) {
                        tables[k].body.push(tableRow[k]);
                    }
                }

                if (styleInfo) {
                    for (let i = 0; i < tables.length; i++) {
                        const body = tables[i].body;

                        for (let j = headerRows - 1; j >= 0; j--) {
                            body.unshift(header[i][j]);
                        }

                        content.push({
                            table: {
                                headerRows: headerRows,
                                widths: tables[i].widths,
                                heights: function (row) {
                                    if (styleInfo.heights[row]) {
                                        return styleInfo.heights[row];
                                    }

                                    if (styleInfo.defaultHeight) {
                                        return styleInfo.defaultHeight;
                                    }
                                },
                                body: body
                            },
                            pageBreak: 'after'
                        });
                    }

                    delete content[tables.length - 1].pageBreak;
                    docDefinition.styles = styleInfo.styles;
                }
                else {
                    const body = tables[0].body;

                    for (let j = headerRows - 1; j >= 0; j--) {
                        body.unshift(header[0][j]);
                    }

                    content = [{ table: { headerRows: headerRows, body: body } }];
                    docDefinition.styles = { header: { bold: true }, group: { bold: true } };
                }

                docDefinition.content = content;

                if (!fileName) {
                    const output = pdfMake.createPdf(docDefinition);

                    delete that.mergedCellsPDF;
                    delete that.styleInfo;

                    return output;
                }
                pdfMake.createPdf(docDefinition).download(fileName);

                delete that.mergedCellsPDF;
                delete that.styleInfo;
            }

            /**
             * Gets the header content when exporting to PDF.
             */
            getPDFStyle() {
                const that = this,
                    style = that.style;

                if (!style) {
                    return '';
                }

                const sampleRecord = that.data[0],
                    headerDefinition = style.header,
                    columnsDefinition = style.columns,
                    rowsDefinition = style.rows,
                    styleInfo = {
                        heights: [],
                        widths: Array(that.datafields.length).fill('*'),
                        styles: {
                            header: {},
                            row: {},
                            cell: {},
                            group: { fillColor: '#FFFFFF', color: '#000000', bold: true }
                        }
                    };

                that.styleInfo = styleInfo;

                function processStyleDefinition(definition, type) {
                    if (!definition) {
                        return;
                    }

                    for (let prop in definition) {
                        if (!Object.prototype.hasOwnProperty.call(definition, prop)) {
                            continue;
                        }

                        if (sampleRecord[prop] === undefined) {
                            if (prop === 'height' && type === 'header') {
                                for (let i = 0; i < that.headerRows; i++) {
                                    styleInfo.heights[i] = (parseInt(definition[prop], 10) / that.headerRows) / 1.4;
                                }
                            }
                            else {
                                that.storePDFStyle({ prop: prop, value: definition[prop], toUpdate: type });
                            }
                        }
                        else {
                            for (let columnProp in definition[prop]) {
                                if (!isNaN(columnProp) || !Object.prototype.hasOwnProperty.call(definition[prop], columnProp)) {
                                    continue;
                                }

                                const value = definition[prop][columnProp],
                                    index = that.datafields.indexOf(prop);

                                if (columnProp === 'width' && styleInfo.widths[index] === '*') {
                                    styleInfo.widths[index] = value;
                                }
                                else {
                                    that.storePDFStyle({ prop: columnProp, value: value, toUpdate: type + prop });
                                }
                            }
                        }
                    }
                }

                processStyleDefinition(headerDefinition, 'header');
                processStyleDefinition(columnsDefinition, 'cell');

                if (!rowsDefinition) {
                    return;
                }

                for (let prop in rowsDefinition) {
                    if (!Object.prototype.hasOwnProperty.call(rowsDefinition, prop) || prop.indexOf('alt') !== -1) {
                        continue;
                    }

                    const value = rowsDefinition[prop];

                    if (!isNaN(prop)) {
                        for (let rowProp in value) {
                            if (Object.prototype.hasOwnProperty.call(value, rowProp)) {
                                if (rowProp === 'height') {
                                    styleInfo.heights[parseFloat(prop) + that.headerRows] = parseFloat(value[rowProp]) / 1.4;
                                }
                                else {
                                    that.storePDFStyle({ prop: rowProp, value: value[rowProp], toUpdate: 'row' + prop });
                                }
                            }
                        }

                        continue;
                    }

                    if (prop === 'height') {
                        styleInfo.defaultHeight = parseFloat(value) / 1.4;
                    }
                    else {
                        that.storePDFStyle({ prop: prop, value: value, toUpdate: 'row' });
                    }
                }

                if (!rowsDefinition.alternationCount) {
                    return;
                }

                for (let i = 0; i < rowsDefinition.alternationCount; i++) {
                    const styleN = {};

                    if (rowsDefinition[`alternationIndex${i}Color`]) {
                        styleN.color = rowsDefinition[`alternationIndex${i}Color`];
                    }

                    if (rowsDefinition[`alternationIndex${i}BackgroundColor`]) {
                        styleN.fillColor = rowsDefinition[`alternationIndex${i}BackgroundColor`];
                    }

                    styleInfo.styles['rowN' + i] = styleN;
                }
            }

            /**
             * Stores style in object to be applied to generated PDF.
             */
            storePDFStyle(details) {
                const that = this;
                let objectToUpdate = that.styleInfo.styles[details.toUpdate];

                if (!objectToUpdate) {
                    objectToUpdate = {};
                    that.styleInfo.styles[details.toUpdate] = objectToUpdate;
                }

                let value = details.value;

                switch (details.prop) {
                    case 'backgroundColor':
                        objectToUpdate.fillColor = value;
                        break;
                    case 'color':
                        objectToUpdate.color = value;
                        break;
                    case 'fontSize':
                        objectToUpdate.fontSize = parseFloat(value);
                        break;
                    case 'fontStyle':
                        if (value === 'italic') {
                            objectToUpdate.italics = true;
                        }

                        break;
                    case 'fontWeight':
                        if (value === 'bold') {
                            objectToUpdate.bold = true;
                        }

                        break;
                    case 'textAlign':
                        objectToUpdate.alignment = value;
                        break;
                }
            }

            /**
             * Enables column wrapping when exporting to PDF.
             */
            wrapPDFColumns(docDefinition, mapping) {
                const that = this,
                    styleInfo = this.styleInfo,
                    maxPerPage = docDefinition.pageOrientation === 'portrait' ? 655 : 1155, // maximum of 655px (portrait) or 1155px (landscape) per A4 page
                    tables = [];
                let currentPage = 0;

                for (let i = 0; i < styleInfo.widths.length; i++) {
                    let currentWidth = styleInfo.widths[i],
                        numericWidth;

                    if (currentWidth === '*') {
                        numericWidth = maxPerPage / 6;
                    }
                    else if (typeof currentWidth === 'string' && currentWidth.indexOf('%') !== -1) {
                        numericWidth = Math.min(maxPerPage, Math.floor((parseFloat(currentWidth) / 100) * maxPerPage));

                        if (numericWidth === maxPerPage) {
                            currentWidth = '*';
                        }
                    }
                    else {
                        currentWidth = parseFloat(currentWidth);

                        if (currentWidth >= maxPerPage) {
                            numericWidth = maxPerPage
                            currentWidth = '*';
                        }
                        else {
                            numericWidth = currentWidth;
                            currentWidth /= 1.4;
                        }
                    }

                    if (tables[currentPage] === undefined) {
                        const body = [];

                        tables[currentPage] = {
                            body: body,
                            width: numericWidth,
                            widths: [currentWidth],
                            datafields: [that.datafields[i]]
                        };
                        mapping[i] = currentPage;
                        continue;
                    }

                    const table = tables[currentPage];

                    if (table.width + numericWidth > maxPerPage) {
                        currentPage++;
                        i--;
                        continue;
                    }

                    mapping[i] = currentPage;
                    table.width += numericWidth;
                    table.widths.push(currentWidth);
                    table.datafields.push(that.datafields[i]);
                }

                return tables;
            }

            /**
             * Gets the header content when exporting to PDF.
             */
            getPDFHeader(datafields, tables, mapping) {
                const that = this,
                    headerArray = [],
                    headerRows = that.headerRows,
                    headers = [],
                    headerDataFields = [];
                let result = [],
                    headerStructure, headerDataFieldStructure;

                if (that.complexHeader) {
                    headerStructure = that.complexHeader;
                    headerDataFieldStructure = that.complexDataFieldsHeader;
                }
                else {
                    headerStructure = [Object.values(that.data[0])];
                    headerDataFieldStructure = headerStructure;
                }

                for (let i = 0; i < headerRows; i++) {
                    const row = headerStructure[i],
                        rowDataField = headerDataFieldStructure[i];

                    for (let k = 0; k < row.length; k++) {
                        let tableIndex = mapping[k] || 0;

                        if (!headers[tableIndex]) {
                            headers[tableIndex] = [];
                            headerDataFields[tableIndex] = [];
                        }

                        if (!headers[tableIndex][i]) {
                            headers[tableIndex][i] = [];
                            headerDataFields[tableIndex][i] = [];
                        }

                        headers[tableIndex][i].push(row[k]);
                        headerDataFields[tableIndex][i].push(rowDataField[k]);
                    }
                }

                function processHeader(header, headerDataField, result, table) {
                    for (let j = 0; j < headerRows; j++) {
                        const row = header[j],
                            rowDataField = headerDataField[j];
                        const tableRow = [];

                        for (let k = 0; k < row.length; k++) {
                            const currentDataField = rowDataField[k];
                            let colspan = 1, rowspan = 1;

                            if ((rowDataField[k - 1] && rowDataField[k - 1] === currentDataField) ||
                                (headerDataField[j - 1] && (headerDataField[j - 1][k] === currentDataField))) {
                                tableRow.push({});
                                continue;
                            }

                            let iterator = k + 1;

                            while (rowDataField[iterator] && rowDataField[iterator] === rowDataField[iterator - 1]) {
                                colspan++;
                                iterator++;
                            }

                            iterator = j + 1;

                            while (headerDataField[iterator] && headerDataField[iterator][k] === currentDataField) {
                                rowspan++;
                                iterator++;
                            }

                            const datafield = j === headerRows - 1 || rowspan + j === headerRows ?
                                table.datafields[k] : null,
                                entry = {
                                    text: row[k], colSpan: colspan, rowSpan: rowspan
                                };

                            if (!datafield) {
                                entry.alignment = 'center';
                                entry.style = 'header';
                            }
                            else {
                                entry.style = ['header', 'header' + datafield];
                            }

                            tableRow.push(entry);
                        }

                        result.push(tableRow);
                    }
                }

                for (let i = 0; i < tables.length; i++) {
                    result = [];
                    processHeader(headers[i], headerDataFields[i], result, tables[i]);
                    headerArray.push(result);
                }

                return headerArray;
            }

            /**
             * Creates group header rows when exporting to PDF.
             */
            createGroupHeaderRow(tables, entryTemplate) {
                for (let i = 0; i < tables.length; i++) {
                    const entry = Object.assign({}, entryTemplate),
                        colspan = tables[i].datafields.length,
                        tableRow = [entry];

                    entry.colSpan = colspan;
                    tableRow.length = colspan;
                    tableRow.fill({}, 1, colspan - 1);

                    tables[i].body.push(tableRow);
                }
            }

            /**
             * Gets unique cell style when exporting to PDF.
             */
            getUniqueStylePDF(entry, datafield, row) {
                const style = this.style;

                function toHex(background) {
                    const parts = /rgba\((\d+),(\d+),(\d+)\,(\d*.\d+|\d+)\)/gi.exec(background.replace(/\s/g, ''));

                    if (parts === null) {
                        return background;
                    }

                    const r = parseFloat(parts[1]).toString(16).toUpperCase(),
                        g = parseFloat(parts[2]).toString(16).toUpperCase(),
                        b = parseFloat(parts[3]).toString(16).toUpperCase();

                    return '#' + ('0').repeat(2 - r.length) + r +
                        ('0').repeat(2 - g.length) + g +
                        ('0').repeat(2 - b.length) + b;
                }

                if (!style || !style.columns || !style.columns[datafield]) {
                    return;
                }

                const uniqueStyle = style.columns[datafield][row];

                if (!uniqueStyle) {
                    return;
                }

                entry.fillColor = toHex(uniqueStyle.background);
                entry.color = uniqueStyle.color.toLowerCase();
            }

            /**
             * Sets the indentation of a PDF cell.
             */
            setIndentation(entry, details) {
                if (details.j !== 0) {
                    return;
                }

                const that = this;

                if (that.actualHierarchy) {
                    const currentRecord = details.currentRecord;

                    if (currentRecord._expanded !== undefined) {
                        entry.marginLeft = 25 * (currentRecord._level - 1);
                        entry.text = that.collapseChar + ' ' + details.value;
                    }
                    else {
                        entry.marginLeft = 25 * (currentRecord._level - 1) + 6;
                    }
                }
                else if (details.outlineLevel > 1) {
                    entry.marginLeft = (details.outlineLevel - 1) * 7.5;
                }
            }

            addBodyImageToMap(image, rowIndex, col, columnsToExport) {
                const sheetIndex = 1;
                const { row, column } = image.position || {};
                const calculatedImage = image;
                if (columnsToExport) {
                    if (rowIndex !== null && col !== null && (!row || !column)) {
                        if (!image.position) {
                            image.position = {};
                        }
                        image.position = Object.assign({}, image.position, {
                            row: rowIndex,
                            column: columnsToExport.indexOf(col) + 1
                        });
                    }
                    calculatedImage.totalWidth = calculatedImage.width;
                    calculatedImage.totalHeight = calculatedImage.height;
                }
                this.buildImageMap({ imageToAdd: calculatedImage, idx: sheetIndex });
                let worksheetImageIdMap = this.worksheetImageIds.get(sheetIndex);
                if (!worksheetImageIdMap) {
                    worksheetImageIdMap = new Map();
                    this.worksheetImageIds.set(sheetIndex, worksheetImageIdMap);
                }
                const sheetImages = this.worksheetImages.get(sheetIndex);
                if (!sheetImages) {
                    this.worksheetImages.set(sheetIndex, [calculatedImage]);
                } else {
                    sheetImages.push(calculatedImage);
                }
                if (!worksheetImageIdMap.get(image.id)) {
                    worksheetImageIdMap.set(image.id, { index: worksheetImageIdMap.size, type: image.imageType });
                }
            }
            buildImageMap(params) {
                const { imageToAdd, idx } = params;
                const mappedImagesToSheet = this.images.get(imageToAdd.id);
                if (mappedImagesToSheet) {
                    const currentSheetImages = mappedImagesToSheet.find((currentImage) => currentImage.sheetId === idx);
                    if (currentSheetImages) {
                        currentSheetImages.image.push(imageToAdd);
                    } else {
                        mappedImagesToSheet.push({
                            sheetId: idx,
                            image: [imageToAdd]
                        });
                    }
                } else {
                    this.images.set(imageToAdd.id, [{ sheetId: idx, image: [imageToAdd] }]);
                    this.workbookImageIds.set(imageToAdd.id, { type: imageToAdd.imageType, index: this.workbookImageIds.size });
                }
            }

            createXmlPart(body, skipHeader) {
                const header = XmlFactory.createHeader({
                    encoding: "UTF-8",
                    standalone: "yes"
                });
                const xmlBody = XmlFactory.createXml(body);
                if (skipHeader) {
                    return xmlBody;
                }
                return `${header}${xmlBody}`;
            }

            generateWorksheetImages(zip, xl, data) {
                const that = this;

                this.images = new Map();
                this.worksheetImages = new Map();
                this.worksheetHeaderFooterImages = new Map();
                this.workbookImageIds = new Map();
                this.worksheetImageIds = new Map();
                let drawingIndex = 0;
                let imgCounter = 0;
                let imgIndex = 0;
                if (that.addImageToCell) {
                    let offset = that.headerContent ? that.headerContent.length : 0;
                    if (that.complexHeader) {
                        offset += that.complexHeader.length - 1;
                    }

                    for (let i = 1 + offset; i < data.length; i++) {
                        const row = data[i];
                        for (let j = 0; j < that.datafields.length; j++) {
                            const dataField = that.datafields[j];
                            let value = row[dataField];

                            if (value && Array.isArray(value)) {
                                for (let m = 0; m < value.length; m++) {
                                    const addedImage = that.addImageToCell(i + imgIndex++, dataField, value[m], value, row, m);
                                    if (addedImage) {
                                        row[dataField] = '';
                                        this.addBodyImageToMap(
                                            addedImage.image,
                                            1 + i,
                                            dataField,
                                            that.datafields
                                        );
                                    }
                                }
                                continue;
                            }

                            const addedImage = that.addImageToCell(i + imgIndex++, dataField, value, value, row, 0);
                            if (addedImage) {
                                row[dataField] = '';
                                if (addedImage.value && addedImage.value !== value) {
                                    row[dataField] = addedImage.value;
                                }
                                this.addBodyImageToMap(
                                    addedImage.image,
                                    1 + i,
                                    dataField,
                                    that.datafields
                                );
                            }
                        }
                    }

                    if (that.headerContent) {
                        for (let m = 0; m < that.headerContent.length; m++) {
                            const row = data[m];
                            for (let j = 0; j < that.datafields.length; j++) {
                                const dataField = that.datafields[j];
                                const value = row[dataField];

                                const addedImage = that.addImageToCell(m + 1, dataField, value, value, row, 0);
                                if (addedImage) {
                                    row[dataField] = '';
                                    this.addBodyImageToMap(
                                        addedImage.image,
                                        1 + m,
                                        dataField,
                                        that.datafields
                                    );
                                }
                            }
                        }
                    }

                    this.images.forEach((value) => {
                        const firstImage = value[0].image[0];
                        const { base64, imageType } = firstImage;
                        const ext = imageType === 'jpg' ? 'jpeg' : imageType;
                        // Function to convert a base64 string to a Blob
                        const base64ToBlob = (base64, mimeType) => {
                            if (!base64) {
                                base64 = '';
                            }
                            const byteCharacters = atob(base64);
                            const byteNumbers = new Array(byteCharacters.length);
                            for (let i = 0; i < byteCharacters.length; i++) {
                                byteNumbers[i] = byteCharacters.charCodeAt(i);
                            }
                            const byteArray = new Uint8Array(byteNumbers);
                            return new Blob([byteArray], { type: mimeType });
                        }

                        let imageBlob;
                        // Convert the Base64 string to a PNG Blob
                        if (base64 && Array.isArray(base64)) {
                            imageBlob = base64ToBlob(base64[0].split(',')[1], 'image/' + ext);
                        }
                        else {
                            imageBlob = base64ToBlob(base64.split(',')[1], 'image/' + ext);
                        }

                        zip.file(`xl/media/image${++imgCounter}.${ext}`, imageBlob, true);
                    });
                }

                let imageRelationCounter = 0;

                var INCH_TO_EMU = 9525;

                var pixelsToEMU = (value) => {
                    return Math.ceil(value * INCH_TO_EMU);
                };

                var getImageBoxSize = (image) => {
                    image.fitCell = !!image.fitCell || !image.width || !image.height;
                    const { position = {}, fitCell, width = 0, height = 0, totalHeight, totalWidth } = image;
                    const { offsetX = 0, offsetY = 0, row = 1, rowSpan = 1, column = 1, colSpan = 1 } = position;
                    return {
                        from: {
                            row: row - 1,
                            col: column - 1,
                            offsetX: pixelsToEMU(offsetX),
                            offsetY: pixelsToEMU(offsetY)
                        },
                        to: {
                            row: row - 1 + (fitCell ? 1 : rowSpan - 1),
                            col: column - 1 + (fitCell ? 1 : colSpan - 1),
                            offsetX: pixelsToEMU(width + offsetX),
                            offsetY: pixelsToEMU(height + offsetY)
                        },
                        height: pixelsToEMU(totalHeight || height),
                        width: pixelsToEMU(totalWidth || width)
                    };
                };
                var getPicture = (image, currentIndex, worksheetImageIndex, imageBoxSize) => {
                    return {
                        name: "xdr:pic",
                        children: [
                            getNvPicPr(image, currentIndex + 1),
                            getBlipFill(image, worksheetImageIndex + 1),
                            getSpPr(image, imageBoxSize)
                        ]
                    };
                };


                var getBlipFill = (image, index) => {
                    let blipChildren;
                    if (image.transparency) {
                        const transparency = Math.min(Math.max(image.transparency, 0), 100);
                        blipChildren = [
                            {
                                name: "a:alphaModFix",
                                properties: {
                                    rawMap: {
                                        amt: 1e5 - Math.round(transparency * 1e3)
                                    }
                                }
                            }
                        ];
                    }
                    if (image.recolor) {
                        if (!blipChildren) {
                            blipChildren = [];
                        }
                        switch (image.recolor.toLocaleLowerCase()) {
                            case "grayscale":
                                blipChildren.push({ name: "a:grayscl" });
                                break;
                            case "sepia":
                                blipChildren.push(getDuoTone({ color: "black" }, { color: "D9C3A5", tint: 50, saturation: 180 }));
                                break;
                            case "washout":
                                blipChildren.push({
                                    name: "a:lum",
                                    properties: {
                                        rawMap: {
                                            bright: "70000",
                                            contrast: "-70000"
                                        }
                                    }
                                });
                                break;
                            default:
                        }
                    }
                    return {
                        name: "xdr:blipFill",
                        children: [
                            {
                                name: "a:blip",
                                properties: {
                                    rawMap: {
                                        cstate: "print",
                                        "r:embed": `rId${index}`,
                                        "xmlns:r": "http://schemas.openxmlformats.org/officeDocument/2006/relationships"
                                    }
                                },
                                children: blipChildren
                            },
                            {
                                name: "a:stretch",
                                children: [
                                    {
                                        name: "a:fillRect"
                                    }
                                ]
                            }
                        ]
                    };
                };
                var getSpPr = (image, imageBoxSize) => {
                    const xfrm = {
                        name: "a:xfrm",
                        children: [
                            {
                                name: "a:off",
                                properties: {
                                    rawMap: {
                                        x: 0,
                                        y: 0
                                    }
                                }
                            },
                            {
                                name: "a:ext",
                                properties: {
                                    rawMap: {
                                        cx: imageBoxSize.width,
                                        cy: imageBoxSize.height
                                    }
                                }
                            }
                        ]
                    };
                    if (image.rotation) {
                        const rotation = image.rotation;
                        xfrm.properties = {
                            rawMap: {
                                rot: Math.min(Math.max(rotation, 0), 360) * 6e4
                            }
                        };
                    }
                    const prstGeom = {
                        name: "a:prstGeom",
                        properties: {
                            rawMap: {
                                prst: "rect"
                            }
                        },
                        children: [{ name: "a:avLst" }]
                    };
                    const ret = {
                        name: "xdr:spPr",
                        children: [xfrm, prstGeom]
                    };
                    return ret;
                };

                var getExt = (image) => {
                    const children = [
                        {
                            name: "a:ext",
                            properties: {
                                rawMap: {
                                    uri: "{FF2B5EF4-FFF2-40B4-BE49-F238E27FC236}"
                                }
                            },
                            children: [
                                {
                                    name: "a16:creationId",
                                    properties: {
                                        rawMap: {
                                            id: "{822E6D20-D7BC-2841-A643-D49A6EF008A2}",
                                            "xmlns:a16": "http://schemas.microsoft.com/office/drawing/2014/main"
                                        }
                                    }
                                }
                            ]
                        }
                    ];
                    const recolor = image.recolor && image.recolor.toLowerCase();
                    switch (recolor) {
                        case "grayscale":
                        case "sepia":
                        case "washout":
                            children.push({
                                name: "a:ext",
                                properties: {
                                    rawMap: {
                                        uri: "{C183D7F6-B498-43B3-948B-1728B52AA6E4}"
                                    }
                                },
                                children: [
                                    {
                                        name: "adec:decorative",
                                        properties: {
                                            rawMap: {
                                                val: "0",
                                                "xmlns:adec": "http://schemas.microsoft.com/office/drawing/2017/decorative"
                                            }
                                        }
                                    }
                                ]
                            });
                    }
                    return {
                        name: "a:extLst",
                        children
                    };
                };

                var getNvPicPr = (image, index) => ({
                    name: "xdr:nvPicPr",
                    children: [
                        {
                            name: "xdr:cNvPr",
                            properties: {
                                rawMap: {
                                    id: index,
                                    name: image.id,
                                    descr: image.altText != null ? image.altText : void 0
                                }
                            },
                            children: [getExt(image)]
                        },
                        {
                            name: "xdr:cNvPicPr",
                            properties: {
                                rawMap: {
                                    preferRelativeResize: "0"
                                }
                            },
                            children: [
                                {
                                    name: "a:picLocks"
                                }
                            ]
                        }
                    ]
                });

                var getAnchor = (name, imageAnchor) => ({
                    name: `xdr:${name}`,
                    children: [
                        {
                            name: "xdr:col",
                            textNode: imageAnchor.col.toString()
                        },
                        {
                            name: "xdr:colOff",
                            textNode: imageAnchor.offsetX.toString()
                        },
                        {
                            name: "xdr:row",
                            textNode: imageAnchor.row.toString()
                        },
                        {
                            name: "xdr:rowOff",
                            textNode: imageAnchor.offsetY.toString()
                        }
                    ]
                });

                var drawingFactory = {
                    getTemplate(config) {
                        const { sheetIndex } = config;
                        const sheetImages = that.worksheetImages.get(sheetIndex);
                        const sheetImageIds = that.worksheetImageIds.get(sheetIndex);
                        const children = sheetImages.map((image, idx) => {
                            const boxSize = getImageBoxSize(image);
                            return {
                                name: "xdr:twoCellAnchor",
                                properties: {
                                    rawMap: {
                                        editAs: "absolute"
                                    }
                                },
                                children: [
                                    getAnchor("from", boxSize.from),
                                    getAnchor("to", boxSize.to),
                                    getPicture(image, idx, sheetImageIds.get(image.id).index, boxSize),
                                    { name: "xdr:clientData" }
                                ]
                            };
                        });
                        return {
                            name: "xdr:wsDr",
                            properties: {
                                rawMap: {
                                    "xmlns:xdr": "http://schemas.openxmlformats.org/drawingml/2006/spreadsheetDrawing",
                                    "xmlns:a": "http://schemas.openxmlformats.org/drawingml/2006/main",
                                }
                            },
                            children
                        };
                    }
                };

                const createDrawing = (sheetIndex) => {
                    return this.createXmlPart(drawingFactory.getTemplate({ sheetIndex }));
                }
                // enterprise-modules/excel-export/src/excelExport/files/ooxml/relationship.ts
                var relationshipFactory = {
                    getTemplate(config) {
                        const { Id, Type, Target } = config;
                        return {
                            name: "Relationship",
                            properties: {
                                rawMap: {
                                    Id,
                                    Type,
                                    Target
                                }
                            }
                        };
                    }
                };
                var relationship_default = relationshipFactory;

                // enterprise-modules/excel-export/src/excelExport/files/ooxml/relationships.ts
                var relationshipsFactory = {
                    getTemplate(c) {
                        const children = c.map((relationship) => relationship_default.getTemplate(relationship));
                        return {
                            name: "Relationships",
                            properties: {
                                rawMap: {
                                    xmlns: "http://schemas.openxmlformats.org/package/2006/relationships"
                                }
                            },
                            children
                        };
                    }
                };
                var relationships_default = relationshipsFactory;

                const createDrawingRel = (sheetIndex) => {
                    const worksheetImageIds = this.worksheetImageIds.get(sheetIndex) || [];
                    const XMLArr = [];
                    for (const [key, value] of worksheetImageIds) {
                        XMLArr.push({
                            Id: `rId${value.index + 1}`,
                            Type: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/image",
                            Target: `../media/image${this.workbookImageIds.get(key).index + 1}.${value.type}`
                        });
                    }
                    return this.createXmlPart(relationshipsFactory.getTemplate(XMLArr));
                }

                var createExcelXmlDrawings = (sheetIndex, drawingIndex) => {
                    const drawingFolder = 'xl/drawings';
                    const drawingFileName = `${drawingFolder}/drawing${drawingIndex + 1}.xml`;
                    const relFileName = `${drawingFolder}/_rels/drawing${drawingIndex + 1}.xml.rels`;
                    zip.file(relFileName, createDrawingRel(sheetIndex));
                    zip.file(drawingFileName, createDrawing(sheetIndex));
                };

                for (let i = 1; i < data.length; i++) {
                    const hasImages = this.worksheetImages.has(i);
                    if (hasImages) {
                        createExcelXmlDrawings(i, imageRelationCounter);
                        drawingIndex = imageRelationCounter;
                        imageRelationCounter++;
                    }
                }

                const createRelationships = ({
                    drawingIndex,
                    tableIndex
                } = {}) => {
                    if (drawingIndex === void 0 && tableIndex === void 0) {
                        return '';
                    }
                    const config = [];

                    if (drawingIndex !== null && imgCounter > 0) {
                        config.push({
                            Id: `rId${config.length + 1}`,
                            Type: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/drawing",
                            Target: `../drawings/drawing${drawingIndex + 1}.xml`
                        });
                    }
                    if (tableIndex !== null) {
                        config.push({
                            Id: `rId${config.length + 1}`,
                            Type: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/table",
                            Target: `../tables/table1.xml`
                        });
                    }
                    const rs = relationships_default.getTemplate(config);
                    return this.createXmlPart(rs);
                }

                var tableIndex = this.exportAsTable ? 1 : 0;
                const worksheetRelFile = `xl/worksheets/_rels/sheet1.xml.rels`;
                zip.file(
                    worksheetRelFile,
                    createRelationships({
                        tableIndex,
                        drawingIndex
                    })
                );
            }
            /**
             * Exports to XLSX.
             */
            exportToXLSX(data, fileName, callback) {
                try {
                    JSZip;
                }
                catch (error) {
                    throw new Error('Missing reference to \'jszip.min.js\'.');
                }

                const that = this;
                let style = that.style;

                data = that.processGroupingInformation(data, true);
                that.data = data;
                that.getColumnsArray();

                that.complexHeaderMergedCells = [];

                if (that.complexHeaderMergeInfo) {
                    for (let cell in that.complexHeaderMergeInfo) {
                        if (Object.prototype.hasOwnProperty.call(that.complexHeaderMergeInfo, cell)) {
                            const currentEntry = that.complexHeaderMergeInfo[cell];

                            if (currentEntry.from[0] === currentEntry.to[0] &&
                                currentEntry.from[1] === currentEntry.to[1]) {
                                continue;
                            }

                            that.complexHeaderMergedCells.push({
                                from: that.columnsArray[currentEntry.from[1]] + (currentEntry.from[0] + 1),
                                to: that.columnsArray[currentEntry.to[1]] + (currentEntry.to[0] + 1)
                            });
                        }
                    }
                }

                that.getConditionalFormatting();

                if (!style) {
                    style = that.generateDefaultStyle(data);
                }

                // eslint-disable-next-line
                const zip = new JSZip(),
                    _rels = zip.folder('_rels'),
                    docProps = zip.folder('docProps'),
                    xl = zip.folder('xl');

                if (that.headerContent) {
                    const rows = that.headerContent;
                    const customRows = [];
                    for (let i = 0; i < rows.length; i++) {
                        const row = rows[i];
                        const cells = row.cells;
                        let customRow = {};
                        for (let j = 0; j < that.datafields.length; j++) {
                            const dataField = that.datafields[j];
                            if (cells[dataField]) {
                                customRow[dataField] = cells[dataField];
                            }
                            else {
                                customRow[dataField] = null;
                            }
                        }
                        customRows.push(customRow);
                    }
                    data = [...customRows, ...data];
                }

                if (that.footerContent) {
                    const rows = that.footerContent;
                    const customRows = [];
                    for (let i = 0; i < rows.length; i++) {
                        const row = rows[i];
                        const cells = row.cells;
                        let customRow = {};
                        for (let j = 0; j < that.datafields.length; j++) {
                            const dataField = that.datafields[j];
                            if (cells[dataField]) {
                                customRow[dataField] = cells[dataField];
                            }
                            else {
                                customRow[dataField] = null;
                            }
                        }
                        customRows.push(customRow);
                    }
                    data = [...data, ...customRows];
                }

                this.generateWorksheetImages(zip, xl, data);

                const sharedStrings = that.generateSharedStrings(data),
                    sharedStringsCollection = sharedStrings.collection,
                    sharedStringsXML = sharedStrings.xml,
                    stylesXML = that.generateStyles(style),
                    sheet1XML = that.groupBy ? that.generateSheet1WithGrouping(data, sharedStringsCollection) :
                        that.generateSheet1(data, sharedStringsCollection, that.datafields, that.columnsArray),
                    auxiliaryFiles = that.generateAuxiliaryFiles();


                let hasImages = false;
                const worksheetImages = this.worksheetImages.get(1);
                if (worksheetImages && worksheetImages.length) {
                    hasImages = true;
                }

                const xl_rels = xl.folder('_rels'),
                    theme = xl.folder('theme'),
                    worksheets = xl.folder('worksheets');

                if (hasImages) {
                    const media = xl.folder('media'),
                        drawings = xl.folder('drawings'),
                        drawingsRels = xl.folder('drawings/_rels');
                }

                _rels.file('.rels', auxiliaryFiles._relsRels);
                docProps.file('app.xml', auxiliaryFiles.docPropsAppXml);
                docProps.file('core.xml', auxiliaryFiles.docPropsCoreXml);
                xl_rels.file('workbook.xml.rels', auxiliaryFiles.xl_relsWorkbookXmlRels);
                theme.file('theme1.xml', auxiliaryFiles.xlThemeTheme1Xml);
                worksheets.file('sheet1.xml', sheet1XML);
                xl.file('sharedStrings.xml', sharedStringsXML);
                xl.file('styles.xml', stylesXML);
                xl.file('workbook.xml', auxiliaryFiles.xlWorkbookXml);
                zip.file('[Content_Types].xml', auxiliaryFiles.Content_TypesXml);


                if (this.spreadsheets) {
                    let sheetIndex = 2;
                    for (let s = 0; s < this.spreadsheets.length; s++) {
                        const sheet = this.spreadsheets[s];
                        const dataFields = sheet.dataFields;
                        let data = [...sheet.dataSource];

                        let header = [];
                        for (let i = 0; i < sheet.columns.length; i++) {
                            const column = sheet.columns[i];
                            if (typeof column === 'string') {
                                header[column] = column;
                            }
                            else {
                                header[column.dataField] = column.label || column.text;
                            }
                        }
                        data.splice(0, 0, header);
                        const sheet1XML = that.generateSheet1(data, sharedStringsCollection, dataFields, that.getColumnsArrayFromDataFields(dataFields), sheetIndex);
                        worksheets.file('sheet' + sheetIndex++ + '.xml', sheet1XML);
                    }
                }

                if (this.exportAsTable) {
                    const columnNames = Object.values(that.data[0]);

                    const createGUID = () => {
                        function part() {
                            return Math.floor((1 + Math.random()) * 0x10000)
                                .toString(16)
                                .substring(1);
                        }

                        return part() + part() + '-' + part() + '-' + part() + '-' + part() + '-' + part() + part() + part();
                    }

                    const dimensionEnd = (that.groupBy && that.groupBy.length) ? that.groupDimensionEnd : that.columnsArray[that.columnsArray.length - 1] + (data.length - 1);

                    let table = `<table xmlns="http://schemas.openxmlformats.org/spreadsheetml/2006/main" xmlns:mc="http://schemas.openxmlformats.org/markup-compatibility/2006" xmlns:xr="http://schemas.microsoft.com/office/spreadsheetml/2014/revision" xmlns:xr3="http://schemas.microsoft.com/office/spreadsheetml/2016/revision3" mc:Ignorable="xr xr3" id="1" name="Table1" displayName="Table1" ref="A${this.xlsxStartIndex}:${dimensionEnd}" totalsRowShown="0">
    <autoFilter ref="A${this.xlsxStartIndex}:${dimensionEnd}">`;
                    for (let i = 0; i < columnNames.length; i++) {
                        table += `<filterColumn colId="${i}" hiddenButton="0"/>
    `;
                    }
                    table += '</autoFilter>';
                    let tableColumns = `
    <tableColumns count="${columnNames.length}">`;

                    for (let i = 0; i < columnNames.length; i++) {
                        const column = columnNames[i];

                        tableColumns += `<tableColumn id="${i + 1}" name="${column}" dataCellStyle="Normal"/>
    `;
                    }
                    tableColumns += `
    </tableColumns>`;

                    table += tableColumns;
                    table += `
        <tableStyleInfo name="TableStyleLight1" showFirstColumn="0" showLastColumn="0" showRowStripes="1" showColumnStripes="0"/>
    </table>`;


                    const tables = xl.folder('tables');
                    tables.file('table1.xml', table);
                }

                zip.generateAsync({
                    type: 'blob',
                    mimeType:
                        'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                })
                    .then(function (content) {
                        if (!fileName && callback) {
                            callback(content);
                        }
                        return that.downloadFile(content, 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', fileName);
                    });

                delete that.conditionalFormattingXLSX;
                delete that.complexHeaderMergeInfo;
                delete that.defaultRowHeight;
                delete that.rowHeight;
            }

            /**
             * Processes grouping information.
             */
            processGroupingInformation(data, xlsx) {
                const that = this;

                if (!that.groupBy) {
                    return data;
                }

                let header;

                data = data.slice(0);

                if (that.exportHeader) {
                    if (xlsx && that.complexHeader) {
                        header = data.slice(0, that.complexHeader.length);
                        data.splice(0, that.complexHeader.length);
                    }
                    else {
                        header = [data[0]];
                        data.splice(0, 1);
                    }
                }

                if (data.length > 1) {
                    const getCompareFunction = function (a, knownDataType) {
                        // gets data type of column (not necessary if the Grid provides this information)
                        const dataType = knownDataType || typeof a;
                        let compareFunction;

                        switch (dataType) {
                            case 'string':
                                compareFunction = new Intl.Collator().compare;
                                break;
                            case 'number':
                                compareFunction = function (a, b) {
                                    return a - b;
                                };
                                break;
                            case 'boolean':
                            case 'bool':
                                compareFunction = function (a, b) {
                                    if (a === b) {
                                        return 0;
                                    }
                                    else if (a === false) {
                                        return -1;
                                    }
                                    else {
                                        return 1;
                                    }
                                };
                                break;
                            case 'date':
                            case 'time':
                            case 'dateTime':
                                if (a instanceof Date) {
                                    compareFunction = function (a, b) {
                                        return a.getTime() - b.getTime();
                                    };
                                }

                                break;
                            case 'object':
                                if (a instanceof Date) {
                                    compareFunction = function (a, b) {
                                        return a.getTime() - b.getTime();
                                    };
                                }


                                break;
                        }

                        return compareFunction;
                    }

                    const sortByMultipleColumns = function (dataSource, sortColumns, directions, customSortingCallback) {
                        if (!dataSource || !(Array.isArray(dataSource)) || dataSource.length === 0 ||
                            !sortColumns || Array.isArray(sortColumns) && sortColumns.length === 0) {
                            return;
                        }

                        if (typeof sortColumns === 'string') {
                            sortColumns = [sortColumns];
                        }

                        const directionCoefficients = [],
                            compareFunctions = [];

                        if (directions === undefined) {
                            directions = [];
                        }

                        for (let i = 0; i < sortColumns.length; i++) {
                            if (directions[i] === undefined || directions[i] === 'asc' || directions[i] === 'ascending') {
                                directionCoefficients[i] = 1;
                            }
                            else {
                                directionCoefficients[i] = -1;
                            }

                            compareFunctions[i] = getCompareFunction(dataSource[0][sortColumns[i]]);
                        }

                        if (customSortingCallback) {
                            customSortingCallback(dataSource, sortColumns, directions, compareFunctions);
                            return;
                        }

                        dataSource.sort(function (a, b) {
                            for (let i = 0; i < sortColumns.length; i++) {
                                const result = compareFunctions[i](a[sortColumns[i]], b[sortColumns[i]]);

                                if (result === 0) {
                                    if (sortColumns[i + 1]) {
                                        continue;
                                    }
                                    else if (a._index !== undefined) {
                                        // makes sorting stable
                                        return (a._index - b._index) * directionCoefficients[i];
                                    }

                                    return 0;
                                }

                                return result * directionCoefficients[i];
                            }
                        });
                    }

                    sortByMultipleColumns(data, that.groupBy);
                }

                if (header) {
                    data = header.concat(data);
                }

                that.getGroupLabels(data);

                return data;
            }

            /**
             * Exports to XML.
             */
            exportToXML(data, fileName) {
                const datafields = this.datafields.slice(0);
                let xmlContent = '<?xml version="1.0" encoding="UTF-8" ?>\n<table>\n';

                if (datafields.indexOf('rows') === -1) {
                    datafields.push('rows');
                }

                function recursion(records, indent) {
                    let content = '';

                    for (let i = 0; i < records.length; i++) {
                        const currentRecord = records[i];

                        content += indent + '<row>\n';

                        for (let j = 0; j < datafields.length; j++) {
                            const datafield = datafields[j];

                            if (datafield === 'rows') {
                                if (!currentRecord.rows) {
                                    continue;
                                }

                                content += `${indent}    <rows>\n${recursion(currentRecord.rows, indent + '        ')}${indent}    </rows>\n`;
                                continue;
                            }

                            content += indent + `    <${datafield}>${currentRecord[datafield]}</${datafield}>\n`;
                        }

                        content += indent + '</row>\n';
                    }

                    return content;
                }

                xmlContent += recursion(data, '    ') + '</table>';

                if (!fileName) {
                    return xmlContent;
                }

                return this.downloadFile(xmlContent, 'application/xml', fileName);
            }

            /**
             * Formats a date.
             */
            formatDate(value, format) {
                return value;
            }

            /**
             * Formats a number.
             */
            formatNumber(value, format) {
                return value;
            }

            /**
             * Generates auxiliary files necessary for XLSX.
             */
            generateAuxiliaryFiles() {
                // _rels\.rels
                const _relsRels = `<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
    <Relationships xmlns="http://schemas.openxmlformats.org/package/2006/relationships"><Relationship Id="rId3" Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/extended-properties" Target="docProps/app.xml"/><Relationship Id="rId2" Type="http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties" Target="docProps/core.xml"/><Relationship Id="rId1" Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument" Target="xl/workbook.xml"/></Relationships>`;

                // docProps\app.xml
                const docPropsAppXml = `<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
    <Properties xmlns="http://schemas.openxmlformats.org/officeDocument/2006/extended-properties" xmlns:vt="http://schemas.openxmlformats.org/officeDocument/2006/docPropsVTypes"><Application>Microsoft Excel</Application><DocSecurity>0</DocSecurity><ScaleCrop>false</ScaleCrop><HeadingPairs><vt:vector size="2" baseType="variant"><vt:variant><vt:lpstr>Worksheets</vt:lpstr></vt:variant><vt:variant><vt:i4>1</vt:i4></vt:variant></vt:vector></HeadingPairs><TitlesOfParts><vt:vector size="1" baseType="lpstr"><vt:lpstr>Sheet1</vt:lpstr></vt:vector></TitlesOfParts><Company></Company><LinksUpToDate>false</LinksUpToDate><SharedDoc>false</SharedDoc><HyperlinksChanged>false</HyperlinksChanged><AppVersion>16.0300</AppVersion></Properties>`;

                // docProps\core.xml
                const now = new Date().toISOString(),
                    docPropsCoreXml = `<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
    <cp:coreProperties xmlns:cp="http://schemas.openxmlformats.org/package/2006/metadata/core-properties" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:dcterms="http://purl.org/dc/terms/" xmlns:dcmitype="http://purl.org/dc/dcmitype/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"><dc:creator>Smart HTML Elements</dc:creator><cp:lastModifiedBy>Smart HTML Elements</cp:lastModifiedBy><dcterms:created xsi:type="dcterms:W3CDTF">${now}</dcterms:created><dcterms:modified xsi:type="dcterms:W3CDTF">${now}</dcterms:modified></cp:coreProperties>`;

                // xl\_rels\workbook.xml.rels
                let relationShips = `<Relationship Id="rId1" Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/worksheet" Target="worksheets/sheet1.xml"/>`;
                let relationShipId = 1;
                if (this.spreadsheets) {
                    for (let s = 0; s < this.spreadsheets.length; s++) {
                        const sheetId = 2 + s;
                        relationShipId++;
                        relationShips += `<Relationship Id="rId${sheetId}" Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/worksheet" Target="worksheets/sheet${sheetId}.xml"/>`;
                    }
                }

                const xl_relsWorkbookXmlRels = `<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
    <Relationships xmlns="http://schemas.openxmlformats.org/package/2006/relationships">${relationShips}<Relationship Id="rId${++relationShipId}" Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/theme" Target="theme/theme1.xml"/><Relationship Id="rId${++relationShipId}" Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles" Target="styles.xml"/><Relationship Id="rId${++relationShipId}" Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/sharedStrings" Target="sharedStrings.xml"/></Relationships>`;

                // xl\theme\theme1.xml
                const xlThemeTheme1Xml = `<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
    <a:theme xmlns:a="http://schemas.openxmlformats.org/drawingml/2006/main" name="Office Theme"><a:themeElements><a:clrScheme name="Office"><a:dk1><a:sysClr val="windowText" lastClr="000000"/></a:dk1><a:lt1><a:sysClr val="window" lastClr="FFFFFF"/></a:lt1><a:dk2><a:srgbClr val="44546A"/></a:dk2><a:lt2><a:srgbClr val="E7E6E6"/></a:lt2><a:accent1><a:srgbClr val="4472C4"/></a:accent1><a:accent2><a:srgbClr val="ED7D31"/></a:accent2><a:accent3><a:srgbClr val="A5A5A5"/></a:accent3><a:accent4><a:srgbClr val="FFC000"/></a:accent4><a:accent5><a:srgbClr val="5B9BD5"/></a:accent5><a:accent6><a:srgbClr val="70AD47"/></a:accent6><a:hlink><a:srgbClr val="0563C1"/></a:hlink><a:folHlink><a:srgbClr val="954F72"/></a:folHlink></a:clrScheme><a:fontScheme name="Office"><a:majorFont><a:latin typeface="Calibri Light" panose="020F0302020204030204"/><a:ea typeface=""/><a:cs typeface=""/><a:font script="Jpan" typeface="游ゴシック Light"/><a:font script="Hang" typeface="맑은 고딕"/><a:font script="Hans" typeface="等线 Light"/><a:font script="Hant" typeface="新細明體"/><a:font script="Arab" typeface="Times New Roman"/><a:font script="Hebr" typeface="Times New Roman"/><a:font script="Thai" typeface="Tahoma"/><a:font script="Ethi" typeface="Nyala"/><a:font script="Beng" typeface="Vrinda"/><a:font script="Gujr" typeface="Shruti"/><a:font script="Khmr" typeface="MoolBoran"/><a:font script="Knda" typeface="Tunga"/><a:font script="Guru" typeface="Raavi"/><a:font script="Cans" typeface="Euphemia"/><a:font script="Cher" typeface="Plantagenet Cherokee"/><a:font script="Yiii" typeface="Microsoft Yi Baiti"/><a:font script="Tibt" typeface="Microsoft Himalaya"/><a:font script="Thaa" typeface="MV Boli"/><a:font script="Deva" typeface="Mangal"/><a:font script="Telu" typeface="Gautami"/><a:font script="Taml" typeface="Latha"/><a:font script="Syrc" typeface="Estrangelo Edessa"/><a:font script="Orya" typeface="Kalinga"/><a:font script="Mlym" typeface="Kartika"/><a:font script="Laoo" typeface="DokChampa"/><a:font script="Sinh" typeface="Iskoola Pota"/><a:font script="Mong" typeface="Mongolian Baiti"/><a:font script="Viet" typeface="Times New Roman"/><a:font script="Uigh" typeface="Microsoft Uighur"/><a:font script="Geor" typeface="Sylfaen"/><a:font script="Armn" typeface="Arial"/><a:font script="Bugi" typeface="Leelawadee UI"/><a:font script="Bopo" typeface="Microsoft JhengHei"/><a:font script="Java" typeface="Javanese Text"/><a:font script="Lisu" typeface="Segoe UI"/><a:font script="Mymr" typeface="Myanmar Text"/><a:font script="Nkoo" typeface="Ebrima"/><a:font script="Olck" typeface="Nirmala UI"/><a:font script="Osma" typeface="Ebrima"/><a:font script="Phag" typeface="Phagspa"/><a:font script="Syrn" typeface="Estrangelo Edessa"/><a:font script="Syrj" typeface="Estrangelo Edessa"/><a:font script="Syre" typeface="Estrangelo Edessa"/><a:font script="Sora" typeface="Nirmala UI"/><a:font script="Tale" typeface="Microsoft Tai Le"/><a:font script="Talu" typeface="Microsoft New Tai Lue"/><a:font script="Tfng" typeface="Ebrima"/></a:majorFont><a:minorFont><a:latin typeface="Calibri" panose="020F0502020204030204"/><a:ea typeface=""/><a:cs typeface=""/><a:font script="Jpan" typeface="游ゴシック"/><a:font script="Hang" typeface="맑은 고딕"/><a:font script="Hans" typeface="等线"/><a:font script="Hant" typeface="新細明體"/><a:font script="Arab" typeface="Arial"/><a:font script="Hebr" typeface="Arial"/><a:font script="Thai" typeface="Tahoma"/><a:font script="Ethi" typeface="Nyala"/><a:font script="Beng" typeface="Vrinda"/><a:font script="Gujr" typeface="Shruti"/><a:font script="Khmr" typeface="DaunPenh"/><a:font script="Knda" typeface="Tunga"/><a:font script="Guru" typeface="Raavi"/><a:font script="Cans" typeface="Euphemia"/><a:font script="Cher" typeface="Plantagenet Cherokee"/><a:font script="Yiii" typeface="Microsoft Yi Baiti"/><a:font script="Tibt" typeface="Microsoft Himalaya"/><a:font script="Thaa" typeface="MV Boli"/><a:font script="Deva" typeface="Mangal"/><a:font script="Telu" typeface="Gautami"/><a:font script="Taml" typeface="Latha"/><a:font script="Syrc" typeface="Estrangelo Edessa"/><a:font script="Orya" typeface="Kalinga"/><a:font script="Mlym" typeface="Kartika"/><a:font script="Laoo" typeface="DokChampa"/><a:font script="Sinh" typeface="Iskoola Pota"/><a:font script="Mong" typeface="Mongolian Baiti"/><a:font script="Viet" typeface="Arial"/><a:font script="Uigh" typeface="Microsoft Uighur"/><a:font script="Geor" typeface="Sylfaen"/><a:font script="Armn" typeface="Arial"/><a:font script="Bugi" typeface="Leelawadee UI"/><a:font script="Bopo" typeface="Microsoft JhengHei"/><a:font script="Java" typeface="Javanese Text"/><a:font script="Lisu" typeface="Segoe UI"/><a:font script="Mymr" typeface="Myanmar Text"/><a:font script="Nkoo" typeface="Ebrima"/><a:font script="Olck" typeface="Nirmala UI"/><a:font script="Osma" typeface="Ebrima"/><a:font script="Phag" typeface="Phagspa"/><a:font script="Syrn" typeface="Estrangelo Edessa"/><a:font script="Syrj" typeface="Estrangelo Edessa"/><a:font script="Syre" typeface="Estrangelo Edessa"/><a:font script="Sora" typeface="Nirmala UI"/><a:font script="Tale" typeface="Microsoft Tai Le"/><a:font script="Talu" typeface="Microsoft New Tai Lue"/><a:font script="Tfng" typeface="Ebrima"/></a:minorFont></a:fontScheme><a:fmtScheme name="Office"><a:fillStyleLst><a:solidFill><a:schemeClr val="phClr"/></a:solidFill><a:gradFill rotWithShape="1"><a:gsLst><a:gs pos="0"><a:schemeClr val="phClr"><a:lumMod val="110000"/><a:satMod val="105000"/><a:tint val="67000"/></a:schemeClr></a:gs><a:gs pos="50000"><a:schemeClr val="phClr"><a:lumMod val="105000"/><a:satMod val="103000"/><a:tint val="73000"/></a:schemeClr></a:gs><a:gs pos="100000"><a:schemeClr val="phClr"><a:lumMod val="105000"/><a:satMod val="109000"/><a:tint val="81000"/></a:schemeClr></a:gs></a:gsLst><a:lin ang="5400000" scaled="0"/></a:gradFill><a:gradFill rotWithShape="1"><a:gsLst><a:gs pos="0"><a:schemeClr val="phClr"><a:satMod val="103000"/><a:lumMod val="102000"/><a:tint val="94000"/></a:schemeClr></a:gs><a:gs pos="50000"><a:schemeClr val="phClr"><a:satMod val="110000"/><a:lumMod val="100000"/><a:shade val="100000"/></a:schemeClr></a:gs><a:gs pos="100000"><a:schemeClr val="phClr"><a:lumMod val="99000"/><a:satMod val="120000"/><a:shade val="78000"/></a:schemeClr></a:gs></a:gsLst><a:lin ang="5400000" scaled="0"/></a:gradFill></a:fillStyleLst><a:lnStyleLst><a:ln w="6350" cap="flat" cmpd="sng" algn="ctr"><a:solidFill><a:schemeClr val="phClr"/></a:solidFill><a:prstDash val="solid"/><a:miter lim="800000"/></a:ln><a:ln w="12700" cap="flat" cmpd="sng" algn="ctr"><a:solidFill><a:schemeClr val="phClr"/></a:solidFill><a:prstDash val="solid"/><a:miter lim="800000"/></a:ln><a:ln w="19050" cap="flat" cmpd="sng" algn="ctr"><a:solidFill><a:schemeClr val="phClr"/></a:solidFill><a:prstDash val="solid"/><a:miter lim="800000"/></a:ln></a:lnStyleLst><a:effectStyleLst><a:effectStyle><a:effectLst/></a:effectStyle><a:effectStyle><a:effectLst/></a:effectStyle><a:effectStyle><a:effectLst><a:outerShdw blurRad="57150" dist="19050" dir="5400000" algn="ctr" rotWithShape="0"><a:srgbClr val="000000"><a:alpha val="63000"/></a:srgbClr></a:outerShdw></a:effectLst></a:effectStyle></a:effectStyleLst><a:bgFillStyleLst><a:solidFill><a:schemeClr val="phClr"/></a:solidFill><a:solidFill><a:schemeClr val="phClr"><a:tint val="95000"/><a:satMod val="170000"/></a:schemeClr></a:solidFill><a:gradFill rotWithShape="1"><a:gsLst><a:gs pos="0"><a:schemeClr val="phClr"><a:tint val="93000"/><a:satMod val="150000"/><a:shade val="98000"/><a:lumMod val="102000"/></a:schemeClr></a:gs><a:gs pos="50000"><a:schemeClr val="phClr"><a:tint val="98000"/><a:satMod val="130000"/><a:shade val="90000"/><a:lumMod val="103000"/></a:schemeClr></a:gs><a:gs pos="100000"><a:schemeClr val="phClr"><a:shade val="63000"/><a:satMod val="120000"/></a:schemeClr></a:gs></a:gsLst><a:lin ang="5400000" scaled="0"/></a:gradFill></a:bgFillStyleLst></a:fmtScheme></a:themeElements><a:objectDefaults/><a:extraClrSchemeLst/><a:extLst><a:ext uri="{05A4C25C-085E-4340-85A3-A5531E510DB2}"><thm15:themeFamily xmlns:thm15="http://schemas.microsoft.com/office/thememl/2012/main" name="Office Theme" id="{62F939B6-93AF-4DB8-9C6B-D6C7DFDC589F}" vid="{4A3C46E8-61CC-4603-A589-7422A47A8E4A}"/></a:ext></a:extLst></a:theme>`;

                // xl\workbook.xml
                let sheets = '<sheet name="Sheet1" sheetId="1" r:id="rId1"/>';
                if (this.spreadsheets) {
                    for (let s = 0; s < this.spreadsheets.length; s++) {
                        const sheetId = 2 + s;
                        const sheet = this.spreadsheets[s];
                        sheets += `<sheet name="${sheet.label}" sheetId="${sheetId}" r:id="rId${sheetId}"/>`;
                    }
                }

                const xlWorkbookXml = `<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
    <workbook xmlns="http://schemas.openxmlformats.org/spreadsheetml/2006/main" xmlns:r="http://schemas.openxmlformats.org/officeDocument/2006/relationships" xmlns:mc="http://schemas.openxmlformats.org/markup-compatibility/2006" mc:Ignorable="x15 xr xr6 xr10 xr2" xmlns:x15="http://schemas.microsoft.com/office/spreadsheetml/2010/11/main" xmlns:xr="http://schemas.microsoft.com/office/spreadsheetml/2014/revision" xmlns:xr6="http://schemas.microsoft.com/office/spreadsheetml/2016/revision6" xmlns:xr10="http://schemas.microsoft.com/office/spreadsheetml/2016/revision10" xmlns:xr2="http://schemas.microsoft.com/office/spreadsheetml/2015/revision2"><fileVersion appName="xl" lastEdited="7" lowestEdited="7" rupBuild="20325"/><workbookPr defaultThemeVersion="166925"/><mc:AlternateContent xmlns:mc="http://schemas.openxmlformats.org/markup-compatibility/2006"><mc:Choice Requires="x15"><x15ac:absPath url="C:\Users\jqwidgets\Desktop\" xmlns:x15ac="http://schemas.microsoft.com/office/spreadsheetml/2010/11/ac"/></mc:Choice></mc:AlternateContent><xr:revisionPtr revIDLastSave="0" documentId="13_ncr:1_{0DEDCB6D-5403-4CD8-AAA5-59B6D238A8B6}" xr6:coauthVersionLast="34" xr6:coauthVersionMax="34" xr10:uidLastSave="{00000000-0000-0000-0000-000000000000}"/><bookViews><workbookView xWindow="0" yWindow="0" windowWidth="19200" windowHeight="6950" xr2:uid="{0CB664E6-3800-4A88-B158-B46A682E7484}"/></bookViews><sheets>${sheets}</sheets><calcPr calcId="179021"/><extLst><ext uri="{140A7094-0E35-4892-8432-C4D2E57EDEB5}" xmlns:x15="http://schemas.microsoft.com/office/spreadsheetml/2010/11/main"><x15:workbookPr chartTrackingRefBase="1"/></ext></extLst></workbook>`;

                const worksheetImages = this.worksheetImages.get(1);
                let drawings = '';
                if (worksheetImages && worksheetImages.length) {
                    drawings = '<Override PartName="/xl/drawings/drawing1.xml" ContentType="application/vnd.openxmlformats-officedocument.drawing+xml"/>';
                }

                let tables = '';
                if (this.exportAsTable) {
                    tables = '<Override PartName="/xl/tables/table1.xml" ContentType="application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml"/>';
                }

                // [Content_Types].xml
                let sheetOverrides = `<Override PartName = "/xl/worksheets/sheet1.xml" ContentType = "application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml" />`;
                if (this.spreadsheets) {
                    for (let i = 0; i < this.spreadsheets.length; i++) {
                        sheetOverrides += `<Override PartName = "/xl/worksheets/sheet${i + 2}.xml" ContentType = "application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml" />`;
                    }
                }
                const Content_TypesXml = `<?xml version="1.0" encoding="UTF-8" standalone="yes"?><Types xmlns="http://schemas.openxmlformats.org/package/2006/content-types"><Default Extension="bin" ContentType="application/vnd.openxmlformats-officedocument.spreadsheetml.printerSettings"/><Default Extension="jpeg" ContentType="image/jpeg"/><Default Extension="png" ContentType="image/png"/><Default Extension="svg" ContentType="image/svg"/><Default Extension="rels" ContentType="application/vnd.openxmlformats-package.relationships+xml"/><Default Extension="xml" ContentType="application/xml"/><Override PartName="/xl/workbook.xml" ContentType="application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml"/>${sheetOverrides}<Override PartName="/xl/theme/theme1.xml" ContentType="application/vnd.openxmlformats-officedocument.theme+xml"/><Override PartName="/xl/styles.xml" ContentType="application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml"/><Override PartName="/xl/sharedStrings.xml" ContentType="application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml"/>${tables}${drawings}<Override PartName="/docProps/core.xml" ContentType="application/vnd.openxmlformats-package.core-properties+xml"/><Override PartName="/docProps/app.xml" ContentType="application/vnd.openxmlformats-officedocument.extended-properties+xml"/></Types>`;

                return {
                    _relsRels: _relsRels,
                    docPropsAppXml: docPropsAppXml,
                    docPropsCoreXml: docPropsCoreXml,
                    xl_relsWorkbookXmlRels: xl_relsWorkbookXmlRels,
                    xlThemeTheme1Xml: xlThemeTheme1Xml,
                    xlWorkbookXml: xlWorkbookXml,
                    Content_TypesXml: Content_TypesXml
                };
            }

            /**
             * Generates default style object (for use in XLSX export).
             */
            generateDefaultStyle(data) {
                const that = this,
                    defaultStyle = {},
                    datafields = that.datafields,
                    firstRecord = that.complexHeader ? data[that.complexHeader.length] : data[+that.exportHeader];

                if (!firstRecord) {
                    return defaultStyle;
                }

                for (let i = 0; i < datafields.length; i++) {
                    const sampleValue = firstRecord[datafields[i]];

                    if (sampleValue instanceof Date) {
                        if (!defaultStyle.columns) {
                            defaultStyle.columns = [];
                        }

                        defaultStyle.columns[datafields[i]] = { format: 'd' };
                    }
                }

                return defaultStyle;
            }

            /**
             * Generates group row.
             */
            generateGroupRow(details) {
                const rowNumber = details.rowNumber,
                    from = 'A' + rowNumber,
                    recordXML = `        <row r="${rowNumber}" outlineLevel="${details.outlineLevel}" spans="1:${details.numberOfColumns}"${this.getCustomRowHeight(rowNumber - 1)} x14ac:dyDescent="0.45">
                <c r="${from}" t="s" s="0">
                    <v>${details.sharedStringIndex}</v>
                </c>
            </row>\n`;

                details.mergedCells.push({ from: from, to: this.columnsArray[details.numberOfColumns - 1] + rowNumber });

                return recordXML;
            }

            /**
             * Generates sharedStrings.xml.
             */
            generateSharedStrings(data) {
                const that = this,
                    datafields = that.datafields,
                    collection = [];
                let xml = '',
                    count = 0,
                    uniqueCount = 0;

                function addSharedString(currentValue) {
                    count++;

                    if (collection.indexOf(currentValue) === -1) {
                        uniqueCount++;
                        collection.push(currentValue);

                        currentValue = currentValue.replace(/&(?!amp;)/g, '&amp;');
                        currentValue = currentValue.replace(/'/g, '&apos;');
                        currentValue = currentValue.replace(/"/g, '&quot;');
                        currentValue = currentValue.replace(/>/g, '&gt;');
                        currentValue = currentValue.replace(/</g, '&lt;');

                        xml += `<si><t>${currentValue}</t></si>`;
                    }
                }

                const addSharedStrings = (data, datafields) => {
                    for (let i = 0; i < data.length; i++) {
                        const currentRecord = data[i];

                        for (let j = 0; j < datafields.length; j++) {
                            let currentValue = currentRecord[datafields[j]];

                            if (currentValue === null && !that.allowNull) {
                                currentValue = '';
                            }

                            if (typeof currentValue !== 'string') {
                                continue;
                            }

                            addSharedString(currentValue);
                        }
                    }
                }

                addSharedStrings(data, datafields);

                if (that.spreadsheets) {
                    for (let i = 0; i < that.spreadsheets.length; i++) {
                        const sheet = that.spreadsheets[i];
                        const datafields = sheet.dataFields;
                        let data = [...sheet.dataSource];

                        let header = [];
                        for (let i = 0; i < sheet.columns.length; i++) {
                            const column = sheet.columns[i];
                            if (typeof column === 'string') {
                                header[column] = column;
                            }
                            else {
                                header[column.dataField] = column.label;
                            }
                        }
                        data.splice(0, 0, header);
                        addSharedStrings(data, datafields);
                    }

                }

                if (that.groupLabels) {
                    for (let i = 0; i < that.groupLabels.length; i++) {
                        addSharedString(that.groupLabels[i]);
                    }
                }

                xml = `<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
    <sst xmlns="http://schemas.openxmlformats.org/spreadsheetml/2006/main" count="${count}" uniqueCount="${uniqueCount}">${xml}</sst>`;

                return { collection: collection, xml: xml };
            }


            /**
             * Generates sheet1.xml.
             */
            generateSheet1(data, sharedStrings, datafields, columnsArray, sheetIndex) {
                const that = this,
                    numberOfColumns = columnsArray.length,
                    numberOfRows = data.length,
                    dimensionEnd = columnsArray[numberOfColumns - 1] + numberOfRows,
                    autoFilter = that.getFilters(),
                    mergedCells = [].concat(that.complexHeaderMergedCells);
                let rIdCounter = 0;

                const addDrawingRel = (currentSheet2) => {
                    let xmlContent = '';

                    const worksheetImages = this.worksheetImages.get(currentSheet2);
                    if (worksheetImages && worksheetImages.length) {
                        xmlContent += `<drawing r:id="rId${++rIdCounter}"/>`;
                    }
                    return xmlContent;
                };
  