/**
 * Copyright 2014 Facebook, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var KEYWORDS = [
  'break', 'do', 'in', 'typeof', 'case', 'else', 'instanceof', 'var', 'catch',
  'export', 'new', 'void', 'class', 'extends', 'return', 'while', 'const',
  'finally', 'super', 'with', 'continue', 'for', 'switch', 'yield', 'debugger',
  'function', 'this', 'default', 'if', 'throw', 'delete', 'import', 'try'
];

var FUTURE_RESERVED_WORDS = [
  'enum', 'await', 'implements', 'package', 'protected', 'static', 'interface',
  'private', 'public'
];

var LITERALS = [
  'null',
  'true',
  'false'
];

// https://people.mozilla.org/~jorendorff/es6-draft.html#sec-reserved-words
var RESERVED_WORDS = [].concat(
  KEYWORDS,
  FUTURE_RESERVED_WORDS,
  LITERALS
);

var reservedWordsMap = {};
RESERVED_WORDS.forEach(function(k) {
    reservedWordsMap[k] = true;
});

exports.isReservedWord = function(word) {
  return !!reservedWordsMap[word];
};
