// Cache system is a bit outdated and could do with work

module.exports = function(window, options, logger) {
    var cache = null;
    if (options.env !== 'development') {
        try {
            cache = (typeof(window.localStorage) === 'undefined') ? null : window.localStorage;
        } catch (_) {}
    }
    return {
        setCSS: function(path, lastModified, styles) {
            if (cache) {
                logger.info('saving ' + path+ ' to cache.');
                try {
                    cache.setItem(path, styles);
                    cache.setItem(path + ':timestamp', lastModified);
                } catch(e) {
                    //TODO - could do with adding more robust error handling
                    logger.error('failed to save');
                }
            }
        },
        getCSS: function(path, webInfo) {
            var css       = cache && cache.getItem(path),
                timestamp = cache && cache.getItem(path + ':timestamp');

            if (timestamp && webInfo.lastModified &&
                (new Date(webInfo.lastModified).valueOf() ===
                    new Date(timestamp).valueOf())) {
                // Use local copy
                return css;
            }
        }
    };
};
