Ext.data.JsonP.Sm_log_AppenderBase({"tagname":"class","name":"Sm.log.AppenderBase","extends":"Ext.Base","mixins":[],"alternateClassNames":[],"aliases":{},"singleton":false,"requires":[],"uses":["Sm.log.TemplateLayout","Sm.log.util.Assert","Sm.log.util.Debug"],"enum":null,"override":null,"inheritable":null,"inheritdoc":null,"meta":{"abstract":true},"private":null,"id":"class-Sm.log.AppenderBase","code_type":"ext_define","members":{"cfg":[{"name":"htmlEncodedLogEventProperties","tagname":"cfg","owner":"Sm.log.AppenderBase","meta":{},"id":"cfg-htmlEncodedLogEventProperties"}],"property":[],"method":[{"name":"constructor","tagname":"method","owner":"Sm.log.AppenderBase","meta":{"protected":true},"id":"method-constructor"},{"name":"doLog","tagname":"method","owner":"Sm.log.AppenderBase","meta":{"protected":true,"abstract":true},"id":"method-doLog"},{"name":"formatLogAsText","tagname":"method","owner":"Sm.log.AppenderBase","meta":{},"id":"method-formatLogAsText"},{"name":"getHtmlEncodedLogEventProperties","tagname":"method","owner":"Sm.log.AppenderBase","meta":{},"id":"method-getHtmlEncodedLogEventProperties"},{"name":"getLayout","tagname":"method","owner":"Sm.log.AppenderBase","meta":{},"id":"method-getLayout"},{"name":"getState","tagname":"method","owner":"Sm.log.AppenderBase","meta":{},"id":"method-getState"},{"name":"htmlEncodeStringValues","tagname":"method","owner":"Sm.log.AppenderBase","meta":{"private":true},"id":"method-htmlEncodeStringValues"},{"name":"isLogging","tagname":"method","owner":"Sm.log.AppenderBase","meta":{},"id":"method-isLogging"},{"name":"isStopped","tagname":"method","owner":"Sm.log.AppenderBase","meta":{},"id":"method-isStopped"},{"name":"log","tagname":"method","owner":"Sm.log.AppenderBase","meta":{"private":true},"id":"method-log"},{"name":"setHtmlEncodedLogEventProperties","tagname":"method","owner":"Sm.log.AppenderBase","meta":{},"id":"method-setHtmlEncodedLogEventProperties"},{"name":"setInitialState","tagname":"method","owner":"Sm.log.AppenderBase","meta":{"private":true},"id":"method-setInitialState"},{"name":"setLayout","tagname":"method","owner":"Sm.log.AppenderBase","meta":{},"id":"method-setLayout"},{"name":"startLogging","tagname":"method","owner":"Sm.log.AppenderBase","meta":{},"id":"method-startLogging"},{"name":"stopLogging","tagname":"method","owner":"Sm.log.AppenderBase","meta":{},"id":"method-stopLogging"},{"name":"supportsBuffering","tagname":"method","owner":"Sm.log.AppenderBase","meta":{},"id":"method-supportsBuffering"}],"event":[],"css_var":[],"css_mixin":[]},"linenr":29,"files":[{"filename":"AppenderBase.js","href":"AppenderBase.html#Sm-log-AppenderBase"}],"html_meta":{"abstract":null},"statics":{"cfg":[],"property":[{"name":"BUFFERING","tagname":"property","owner":"Sm.log.AppenderBase","meta":{"readonly":true,"static":true},"id":"static-property-BUFFERING"},{"name":"LOGGING","tagname":"property","owner":"Sm.log.AppenderBase","meta":{"readonly":true,"static":true},"id":"static-property-LOGGING"},{"name":"STOPPED","tagname":"property","owner":"Sm.log.AppenderBase","meta":{"readonly":true,"static":true},"id":"static-property-STOPPED"}],"method":[],"event":[],"css_var":[],"css_mixin":[]},"component":false,"superclasses":["Ext.Base"],"subclasses":["Sm.log.ExtLogAppender","Sm.log.LogViewerAppender","Sm.log.direct.DirectAppender","Sm.log.remote.RemoteAppender"],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'>Ext.Base<div class='subclass '><strong>Sm.log.AppenderBase</strong></div></div><h4>Subclasses</h4><div class='dependency'><a href='#!/api/Sm.log.ExtLogAppender' rel='Sm.log.ExtLogAppender' class='docClass'>Sm.log.ExtLogAppender</a></div><div class='dependency'><a href='#!/api/Sm.log.LogViewerAppender' rel='Sm.log.LogViewerAppender' class='docClass'>Sm.log.LogViewerAppender</a></div><div class='dependency'><a href='#!/api/Sm.log.direct.DirectAppender' rel='Sm.log.direct.DirectAppender' class='docClass'>Sm.log.direct.DirectAppender</a></div><div class='dependency'><a href='#!/api/Sm.log.remote.RemoteAppender' rel='Sm.log.remote.RemoteAppender' class='docClass'>Sm.log.remote.RemoteAppender</a></div><h4>Uses</h4><div class='dependency'><a href='#!/api/Sm.log.TemplateLayout' rel='Sm.log.TemplateLayout' class='docClass'>Sm.log.TemplateLayout</a></div><div class='dependency'><a href='#!/api/Sm.log.util.Assert' rel='Sm.log.util.Assert' class='docClass'>Sm.log.util.Assert</a></div><div class='dependency'><a href='#!/api/Sm.log.util.Debug' rel='Sm.log.util.Debug' class='docClass'>Sm.log.util.Debug</a></div><h4>Files</h4><div class='dependency'><a href='source/AppenderBase.html#Sm-log-AppenderBase' target='_blank'>AppenderBase.js</a></div></pre><div class='doc-contents'><p>Base class for appenders.</p>\n\n<p>An appender outputs logging information somewhere: a window, the browser\nconsole, even a remote system that knows how to process it.</p>\n\n<p>The predefined <a href=\"#!/api/Sm.log.ExtLogAppender\" rel=\"Sm.log.ExtLogAppender\" class=\"docClass\">Sm.log.ExtLogAppender</a> outputs log information\nto the browser console, whereas <a href=\"#!/api/Sm.log.LogViewerAppender\" rel=\"Sm.log.LogViewerAppender\" class=\"docClass\">Sm.log.LogViewerAppender</a>\noutputs logs to a built-in window.</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-htmlEncodedLogEventProperties' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.AppenderBase'>Sm.log.AppenderBase</span><br/><a href='source/AppenderBase.html#Sm-log-AppenderBase-cfg-htmlEncodedLogEventProperties' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.AppenderBase-cfg-htmlEncodedLogEventProperties' class='name expandable'>htmlEncodedLogEventProperties</a><span> : Array</span></div><div class='description'><div class='short'>A list with the EventLogging properties for which to call\nExt.util.Format.htmlEncode before logging them. ...</div><div class='long'><p>A list with the EventLogging properties for which to call\nExt.util.Format.htmlEncode before logging them.</p>\n\n<p>This is important if the output will go to html, you\nare using special html characters, and you want these\ncharacters to be shown as-is.</p>\n<p>Defaults to: <code>[]</code></p></div></div></div></div></div><div class='members-section'><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static Properties</h3><div id='static-property-BUFFERING' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.AppenderBase'>Sm.log.AppenderBase</span><br/><a href='source/AppenderBase.html#Sm-log-AppenderBase-static-property-BUFFERING' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.AppenderBase-static-property-BUFFERING' class='name expandable'>BUFFERING</a><span> : String</span><strong class='readonly signature' >readonly</strong><strong class='static signature' >static</strong></div><div class='description'><div class='short'>In this state the appender keeps buffering logs. ...</div><div class='long'><p>In this state the appender keeps buffering logs.</p>\n\n<p>Logs will not be lost, they will sent to its destination\nwhen the appender state changes to LOGGING.</p>\n<p>Defaults to: <code>'Buffering'</code></p></div></div></div><div id='static-property-LOGGING' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.AppenderBase'>Sm.log.AppenderBase</span><br/><a href='source/AppenderBase.html#Sm-log-AppenderBase-static-property-LOGGING' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.AppenderBase-static-property-LOGGING' class='name expandable'>LOGGING</a><span> : String</span><strong class='readonly signature' >readonly</strong><strong class='static signature' >static</strong></div><div class='description'><div class='short'>In this state the appender outputs logs as they arrive. ...</div><div class='long'><p>In this state the appender outputs logs as they arrive.</p>\n<p>Defaults to: <code>'Logging'</code></p></div></div></div><div id='static-property-STOPPED' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.AppenderBase'>Sm.log.AppenderBase</span><br/><a href='source/AppenderBase.html#Sm-log-AppenderBase-static-property-STOPPED' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.AppenderBase-static-property-STOPPED' class='name expandable'>STOPPED</a><span> : String</span><strong class='readonly signature' >readonly</strong><strong class='static signature' >static</strong></div><div class='description'><div class='short'>In this state the appender ignores all logs\nit receives. ...</div><div class='long'><p>In this state the appender ignores all logs\nit receives. Incoming logs are lost.</p>\n<p>Defaults to: <code>'Stopped'</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-constructor' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.AppenderBase'>Sm.log.AppenderBase</span><br/><a href='source/AppenderBase.html#Sm-log-AppenderBase-method-constructor' target='_blank' class='view-source'>view source</a></div><strong class='new-keyword'>new</strong><a href='#!/api/Sm.log.AppenderBase-method-constructor' class='name expandable'>Sm.log.AppenderBase</a>( <span class='pre'>cfg</span> ) : <a href=\"#!/api/Sm.log.AppenderBase\" rel=\"Sm.log.AppenderBase\" class=\"docClass\">Sm.log.AppenderBase</a><strong class='protected signature' >protected</strong></div><div class='description'><div class='short'>Call this in the derived classes. ...</div><div class='long'><p>Call this in the derived classes.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cfg</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Sm.log.AppenderBase\" rel=\"Sm.log.AppenderBase\" class=\"docClass\">Sm.log.AppenderBase</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-doLog' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.AppenderBase'>Sm.log.AppenderBase</span><br/><a href='source/AppenderBase.html#Sm-log-AppenderBase-method-doLog' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.AppenderBase-method-doLog' class='name expandable'>doLog</a>( <span class='pre'>logEvent</span> ) : void<strong class='abstract signature' >abstract</strong><strong class='protected signature' >protected</strong></div><div class='description'><div class='short'>Writes the log data ...</div><div class='long'><p>Writes the log data</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>logEvent</span> : <a href=\"#!/api/Sm.log.LoggingEvent\" rel=\"Sm.log.LoggingEvent\" class=\"docClass\">Sm.log.LoggingEvent</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-formatLogAsText' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.AppenderBase'>Sm.log.AppenderBase</span><br/><a href='source/AppenderBase.html#Sm-log-AppenderBase-method-formatLogAsText' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.AppenderBase-method-formatLogAsText' class='name expandable'>formatLogAsText</a>( <span class='pre'>logEvent</span> ) : String</div><div class='description'><div class='short'>Returns a formatted string representing the log information. ...</div><div class='long'><p>Returns a formatted string representing the log information.</p>\n\n<p>This is used in most cases for appenders that log to line-oriented\ndevices, such as the browser console.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>logEvent</span> : <a href=\"#!/api/Sm.log.LoggingEvent\" rel=\"Sm.log.LoggingEvent\" class=\"docClass\">Sm.log.LoggingEvent</a><div class='sub-desc'><p>A copy of the data to log.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>A text corresponding to the log data.</p>\n</div></li></ul></div></div></div><div id='method-getHtmlEncodedLogEventProperties' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.AppenderBase'>Sm.log.AppenderBase</span><br/><a href='source/AppenderBase.html#Sm-log-AppenderBase-cfg-htmlEncodedLogEventProperties' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.AppenderBase-method-getHtmlEncodedLogEventProperties' class='name expandable'>getHtmlEncodedLogEventProperties</a>( <span class='pre'></span> ) : Array</div><div class='description'><div class='short'>Returns the value of htmlEncodedLogEventProperties. ...</div><div class='long'><p>Returns the value of <a href=\"#!/api/Sm.log.AppenderBase-cfg-htmlEncodedLogEventProperties\" rel=\"Sm.log.AppenderBase-cfg-htmlEncodedLogEventProperties\" class=\"docClass\">htmlEncodedLogEventProperties</a>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Array</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getLayout' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.AppenderBase'>Sm.log.AppenderBase</span><br/><a href='source/AppenderBase.html#Sm-log-AppenderBase-method-getLayout' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.AppenderBase-method-getLayout' class='name expandable'>getLayout</a>( <span class='pre'></span> ) : <a href=\"#!/api/Sm.log.LayoutBase\" rel=\"Sm.log.LayoutBase\" class=\"docClass\">Sm.log.LayoutBase</a></div><div class='description'><div class='short'>Returns the layout for this logger. ...</div><div class='long'><p>Returns the layout for this logger.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Sm.log.LayoutBase\" rel=\"Sm.log.LayoutBase\" class=\"docClass\">Sm.log.LayoutBase</a></span><div class='sub-desc'><p>The layout for this logger.</p>\n</div></li></ul></div></div></div><div id='method-getState' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.AppenderBase'>Sm.log.AppenderBase</span><br/><a href='source/AppenderBase.html#Sm-log-AppenderBase-method-getState' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.AppenderBase-method-getState' class='name expandable'>getState</a>( <span class='pre'></span> ) : String</div><div class='description'><div class='short'>Returns the appender state. ...</div><div class='long'><p>Returns the appender state.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>The appender state</p>\n</div></li></ul></div></div></div><div id='method-htmlEncodeStringValues' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.AppenderBase'>Sm.log.AppenderBase</span><br/><a href='source/AppenderBase.html#Sm-log-AppenderBase-method-htmlEncodeStringValues' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.AppenderBase-method-htmlEncodeStringValues' class='name expandable'>htmlEncodeStringValues</a>( <span class='pre'>logEvent</span> ) : void<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Performs encoding of log entry properties that should be html encoded. ...</div><div class='long'><p>Performs encoding of log entry properties that should be html encoded.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>logEvent</span> : <a href=\"#!/api/Sm.log.LoggingEvent\" rel=\"Sm.log.LoggingEvent\" class=\"docClass\">Sm.log.LoggingEvent</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isLogging' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.AppenderBase'>Sm.log.AppenderBase</span><br/><a href='source/AppenderBase.html#Sm-log-AppenderBase-method-isLogging' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.AppenderBase-method-isLogging' class='name expandable'>isLogging</a>( <span class='pre'></span> ) : Boolean</div><div class='description'><div class='short'>Returns true if the appender is in the logging state. ...</div><div class='long'><p>Returns true if the appender is in the logging state.</p>\n\n<p>In this state, all logs sent to the appender are logged.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isStopped' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.AppenderBase'>Sm.log.AppenderBase</span><br/><a href='source/AppenderBase.html#Sm-log-AppenderBase-method-isStopped' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.AppenderBase-method-isStopped' class='name expandable'>isStopped</a>( <span class='pre'></span> ) : Boolean</div><div class='description'><div class='short'>Returns true if the appender is stopped. ...</div><div class='long'><p>Returns true if the appender is stopped.</p>\n\n<p>An stopped appender ignores all logs sent to it.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-log' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.AppenderBase'>Sm.log.AppenderBase</span><br/><a href='source/AppenderBase.html#Sm-log-AppenderBase-method-log' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.AppenderBase-method-log' class='name expandable'>log</a>( <span class='pre'>logEvent</span> ) : void<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Outputs the log to its destination. ...</div><div class='long'><p>Outputs the log to its destination.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>logEvent</span> : <a href=\"#!/api/Sm.log.LoggingEvent\" rel=\"Sm.log.LoggingEvent\" class=\"docClass\">Sm.log.LoggingEvent</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setHtmlEncodedLogEventProperties' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.AppenderBase'>Sm.log.AppenderBase</span><br/><a href='source/AppenderBase.html#Sm-log-AppenderBase-cfg-htmlEncodedLogEventProperties' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.AppenderBase-method-setHtmlEncodedLogEventProperties' class='name expandable'>setHtmlEncodedLogEventProperties</a>( <span class='pre'>htmlEncodedLogEventProperties</span> )</div><div class='description'><div class='short'>Sets the value of htmlEncodedLogEventProperties. ...</div><div class='long'><p>Sets the value of <a href=\"#!/api/Sm.log.AppenderBase-cfg-htmlEncodedLogEventProperties\" rel=\"Sm.log.AppenderBase-cfg-htmlEncodedLogEventProperties\" class=\"docClass\">htmlEncodedLogEventProperties</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>htmlEncodedLogEventProperties</span> : Array<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setInitialState' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.AppenderBase'>Sm.log.AppenderBase</span><br/><a href='source/AppenderBase.html#Sm-log-AppenderBase-method-setInitialState' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.AppenderBase-method-setInitialState' class='name expandable'>setInitialState</a>( <span class='pre'></span> ) : void<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Initializes the appender state to whatever is appropriate fro this\nappender. ...</div><div class='long'><p>Initializes the appender state to whatever is appropriate fro this\nappender.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setLayout' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.AppenderBase'>Sm.log.AppenderBase</span><br/><a href='source/AppenderBase.html#Sm-log-AppenderBase-method-setLayout' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.AppenderBase-method-setLayout' class='name expandable'>setLayout</a>( <span class='pre'>layout</span> ) : void</div><div class='description'><div class='short'>Sets the layout for this logger. ...</div><div class='long'><p>Sets the layout for this logger.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>layout</span> : <a href=\"#!/api/Sm.log.LayoutBase\" rel=\"Sm.log.LayoutBase\" class=\"docClass\">Sm.log.LayoutBase</a><div class='sub-desc'><p>The layout.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-startLogging' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.AppenderBase'>Sm.log.AppenderBase</span><br/><a href='source/AppenderBase.html#Sm-log-AppenderBase-method-startLogging' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.AppenderBase-method-startLogging' class='name expandable'>startLogging</a>( <span class='pre'></span> ) : void</div><div class='description'><div class='short'>Sets the appender in the loggins state. ...</div><div class='long'><p>Sets the appender in the loggins state.</p>\n\n<p>All logs sent to the appender from now on will be logged.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-stopLogging' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.AppenderBase'>Sm.log.AppenderBase</span><br/><a href='source/AppenderBase.html#Sm-log-AppenderBase-method-stopLogging' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.AppenderBase-method-stopLogging' class='name expandable'>stopLogging</a>( <span class='pre'></span> ) : void</div><div class='description'><div class='short'>Stops the appender. ...</div><div class='long'><p>Stops the appender.</p>\n\n<p>The appender will ignore all logs sent to it while stopped.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-supportsBuffering' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.AppenderBase'>Sm.log.AppenderBase</span><br/><a href='source/AppenderBase.html#Sm-log-AppenderBase-method-supportsBuffering' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.AppenderBase-method-supportsBuffering' class='name expandable'>supportsBuffering</a>( <span class='pre'></span> ) : Boolean</div><div class='description'><div class='short'>Returns true if the appender support buffering. ...</div><div class='long'><p>Returns true if the appender support buffering.</p>\n\n<p>While buffering, all logs sent to an appender are stored, but not\nsent to the output destination until the appender passes to the\nlogging state.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div></div></div></div></div>"});