Ext.data.JsonP.Sm_log_LayoutBase({"tagname":"class","name":"Sm.log.LayoutBase","extends":"Ext.Base","mixins":[],"alternateClassNames":[],"aliases":{},"singleton":false,"requires":[],"uses":["Ext.Date","Ext.JSON","Sm.log.util.Assert","Sm.log.util.Debug"],"enum":null,"override":null,"inheritable":null,"inheritdoc":null,"meta":{"abstract":true},"private":null,"id":"class-Sm.log.LayoutBase","code_type":"ext_define","members":{"cfg":[{"name":"exportFormattedLoggedObject","tagname":"cfg","owner":"Sm.log.LayoutBase","meta":{},"id":"cfg-exportFormattedLoggedObject"},{"name":"formatIndentLoggedObject","tagname":"cfg","owner":"Sm.log.LayoutBase","meta":{},"id":"cfg-formatIndentLoggedObject"},{"name":"highlightLoggedObject","tagname":"cfg","owner":"Sm.log.LayoutBase","meta":{},"id":"cfg-highlightLoggedObject"},{"name":"multilineLoggedObject","tagname":"cfg","owner":"Sm.log.LayoutBase","meta":{},"id":"cfg-multilineLoggedObject"},{"name":"timeFormat","tagname":"cfg","owner":"Sm.log.LayoutBase","meta":{},"id":"cfg-timeFormat"}],"property":[{"name":"jsonCls","tagname":"property","owner":"Sm.log.LayoutBase","meta":{"private":true},"id":"property-jsonCls"}],"method":[{"name":"constructor","tagname":"method","owner":"Sm.log.LayoutBase","meta":{"protected":true},"id":"method-constructor"},{"name":"","tagname":"method","owner":"Sm.log.LayoutBase","meta":{"protected":true},"id":"method-"},{"name":"appendFormattedData","tagname":"method","owner":"Sm.log.LayoutBase","meta":{"protected":true},"id":"method-appendFormattedData"},{"name":"formatLogAsText","tagname":"method","owner":"Sm.log.LayoutBase","meta":{"protected":true,"abstract":true},"id":"method-formatLogAsText"},{"name":"formatLoggedObject","tagname":"method","owner":"Sm.log.LayoutBase","meta":{"protected":true},"id":"method-formatLoggedObject"},{"name":"formatMessage","tagname":"method","owner":"Sm.log.LayoutBase","meta":{"protected":true},"id":"method-formatMessage"},{"name":"formatTime","tagname":"method","owner":"Sm.log.LayoutBase","meta":{"protected":true},"id":"method-formatTime"},{"name":"getExportFormattedLoggedObject","tagname":"method","owner":"Sm.log.LayoutBase","meta":{},"id":"method-getExportFormattedLoggedObject"},{"name":"getFormatIndentLoggedObject","tagname":"method","owner":"Sm.log.LayoutBase","meta":{},"id":"method-getFormatIndentLoggedObject"},{"name":"getHighlightLoggedObject","tagname":"method","owner":"Sm.log.LayoutBase","meta":{},"id":"method-getHighlightLoggedObject"},{"name":"getMultilineLoggedObject","tagname":"method","owner":"Sm.log.LayoutBase","meta":{},"id":"method-getMultilineLoggedObject"},{"name":"getTimeFormat","tagname":"method","owner":"Sm.log.LayoutBase","meta":{},"id":"method-getTimeFormat"},{"name":"jsonLikeFormat","tagname":"method","owner":"Sm.log.LayoutBase","meta":{"protected":true},"id":"method-jsonLikeFormat"},{"name":"jsonSyntaxHighlight","tagname":"method","owner":"Sm.log.LayoutBase","meta":{"private":true},"id":"method-jsonSyntaxHighlight"},{"name":"multiFormat","tagname":"method","owner":"Sm.log.LayoutBase","meta":{"protected":true},"id":"method-multiFormat"},{"name":"setExportFormattedLoggedObject","tagname":"method","owner":"Sm.log.LayoutBase","meta":{},"id":"method-setExportFormattedLoggedObject"},{"name":"setFormatIndentLoggedObject","tagname":"method","owner":"Sm.log.LayoutBase","meta":{},"id":"method-setFormatIndentLoggedObject"},{"name":"setHighlightLoggedObject","tagname":"method","owner":"Sm.log.LayoutBase","meta":{},"id":"method-setHighlightLoggedObject"},{"name":"setMultilineLoggedObject","tagname":"method","owner":"Sm.log.LayoutBase","meta":{},"id":"method-setMultilineLoggedObject"},{"name":"setTimeFormat","tagname":"method","owner":"Sm.log.LayoutBase","meta":{},"id":"method-setTimeFormat"},{"name":"simpleFormat","tagname":"method","owner":"Sm.log.LayoutBase","meta":{"protected":true},"id":"method-simpleFormat"}],"event":[],"css_var":[],"css_mixin":[]},"linenr":31,"files":[{"filename":"LayoutBase.js","href":"LayoutBase.html#Sm-log-LayoutBase"}],"html_meta":{"abstract":null},"statics":{"cfg":[],"property":[],"method":[],"event":[],"css_var":[],"css_mixin":[]},"component":false,"superclasses":["Ext.Base"],"subclasses":["Sm.log.TemplateLayout"],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'>Ext.Base<div class='subclass '><strong>Sm.log.LayoutBase</strong></div></div><h4>Subclasses</h4><div class='dependency'><a href='#!/api/Sm.log.TemplateLayout' rel='Sm.log.TemplateLayout' class='docClass'>Sm.log.TemplateLayout</a></div><h4>Uses</h4><div class='dependency'>Ext.Date</div><div class='dependency'>Ext.JSON</div><div class='dependency'><a href='#!/api/Sm.log.util.Assert' rel='Sm.log.util.Assert' class='docClass'>Sm.log.util.Assert</a></div><div class='dependency'><a href='#!/api/Sm.log.util.Debug' rel='Sm.log.util.Debug' class='docClass'>Sm.log.util.Debug</a></div><h4>Files</h4><div class='dependency'><a href='source/LayoutBase.html#Sm-log-LayoutBase' target='_blank'>LayoutBase.js</a></div></pre><div class='doc-contents'><p>Base class for all layouts.</p>\n\n<p>A layout is in charge of formatting and augmenting the log data so that\nit can be consumed by an appender.</p>\n\n<p>It knows about formatting the log time, obtaining an string that\nrepresents all information in the log, adding special entries to a\nlogging event, nicely formatting a logged object, etc.</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-exportFormattedLoggedObject' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.LayoutBase'>Sm.log.LayoutBase</span><br/><a href='source/LayoutBase.html#Sm-log-LayoutBase-cfg-exportFormattedLoggedObject' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.LayoutBase-cfg-exportFormattedLoggedObject' class='name expandable'>exportFormattedLoggedObject</a><span> : Boolean</span></div><div class='description'><div class='short'>If set to true, the logged object will be output. ...</div><div class='long'><p>If set to true, the logged object will be output.</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-formatIndentLoggedObject' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.LayoutBase'>Sm.log.LayoutBase</span><br/><a href='source/LayoutBase.html#Sm-log-LayoutBase-cfg-formatIndentLoggedObject' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.LayoutBase-cfg-formatIndentLoggedObject' class='name expandable'>formatIndentLoggedObject</a><span> : Number</span></div><div class='description'><div class='short'>Desired indentation used to format the logged object. ...</div><div class='long'><p>Desired indentation used to format the logged object.</p>\n\n<p>It might be ignored if the JSON formatter does not support\nindenting.</p>\n<p>Defaults to: <code>3</code></p></div></div></div><div id='cfg-highlightLoggedObject' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.LayoutBase'>Sm.log.LayoutBase</span><br/><a href='source/LayoutBase.html#Sm-log-LayoutBase-cfg-highlightLoggedObject' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.LayoutBase-cfg-highlightLoggedObject' class='name expandable'>highlightLoggedObject</a><span> : Boolean</span></div><div class='description'><div class='short'>If set to true, an attempt will be made to highlight the logged\nobject JSON-formatted. ...</div><div class='long'><p>If set to true, an attempt will be made to highlight the logged\nobject JSON-formatted.</p>\n\n<p>It might be ignored if the JSON formatter does not support\nhighlighting.</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-multilineLoggedObject' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.LayoutBase'>Sm.log.LayoutBase</span><br/><a href='source/LayoutBase.html#Sm-log-LayoutBase-cfg-multilineLoggedObject' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.LayoutBase-cfg-multilineLoggedObject' class='name expandable'>multilineLoggedObject</a><span> : Boolean</span></div><div class='description'><div class='short'>If set to true, an attempt will be made to format the logged\nobject as a multiple line string. ...</div><div class='long'><p>If set to true, an attempt will be made to format the logged\nobject as a multiple line string.</p>\n\n<p>It might be ignored if the JSON formatter does not support\nmultiple line formatting.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-timeFormat' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.LayoutBase'>Sm.log.LayoutBase</span><br/><a href='source/LayoutBase.html#Sm-log-LayoutBase-cfg-timeFormat' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.LayoutBase-cfg-timeFormat' class='name expandable'>timeFormat</a><span> : String</span></div><div class='description'><div class='short'>The format string used to format log time. ...</div><div class='long'><p>The format string used to format log time.</p>\n\n<p>See Ext.Date.format for information about this format string.</p>\n<p>Defaults to: <code>&quot;Y-m-d H:i:s.u&quot;</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-jsonCls' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.LayoutBase'>Sm.log.LayoutBase</span><br/><a href='source/LayoutBase.html#Sm-log-LayoutBase-property-jsonCls' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.LayoutBase-property-jsonCls' class='name expandable'>jsonCls</a><span> : Object</span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>CSS styles used to highight logged object as JSON. ...</div><div class='long'><p>CSS styles used to highight logged object as JSON.</p>\n<p>Defaults to: <code>{key: 'sm-log-json-key', string: 'sm-log-json-string', number: 'sm-log-json-number', bool: 'sm-log-json-boolean', nul: 'sm-log-json-null'}</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-constructor' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.LayoutBase'>Sm.log.LayoutBase</span><br/><a href='source/LayoutBase.html#Sm-log-LayoutBase-method-constructor' target='_blank' class='view-source'>view source</a></div><strong class='new-keyword'>new</strong><a href='#!/api/Sm.log.LayoutBase-method-constructor' class='name expandable'>Sm.log.LayoutBase</a>( <span class='pre'>cfg</span> ) : <a href=\"#!/api/Sm.log.LayoutBase\" rel=\"Sm.log.LayoutBase\" class=\"docClass\">Sm.log.LayoutBase</a><strong class='protected signature' >protected</strong></div><div class='description'><div class='short'>Call this method from derived classes. ...</div><div class='long'><p>Call this method from derived classes.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cfg</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Sm.log.LayoutBase\" rel=\"Sm.log.LayoutBase\" class=\"docClass\">Sm.log.LayoutBase</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.LayoutBase'>Sm.log.LayoutBase</span><br/><a href='source/LayoutBase.html#Sm-log-LayoutBase-method-' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.LayoutBase-method-' class='name expandable'></a>( <span class='pre'>json, jsonCls</span> ) : String<strong class='protected signature' >protected</strong></div><div class='description'><div class='short'>Highlights and makes more readable a JSON string corresponding\nto a logged object. ...</div><div class='long'><p>Highlights and makes more readable a JSON string corresponding\nto a logged object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>json</span> : String<div class='sub-desc'><p>The json string corresponding to the logged object.</p>\n</div></li><li><span class='pre'>jsonCls</span> : Object<div class='sub-desc'><p>CSS classes used for highlighting.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>A string representing the highlighted logged object.</p>\n</div></li></ul></div></div></div><div id='method-appendFormattedData' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.LayoutBase'>Sm.log.LayoutBase</span><br/><a href='source/LayoutBase.html#Sm-log-LayoutBase-method-appendFormattedData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.LayoutBase-method-appendFormattedData' class='name expandable'>appendFormattedData</a>( <span class='pre'>logEvent</span> ) : void<strong class='protected signature' >protected</strong></div><div class='description'><div class='short'>Appends extra formatted data to the original log event. ...</div><div class='long'><p>Appends extra formatted data to the original log event.</p>\n\n<p>By default, it provides formattedTime and formattedMessage\nvalues, as well as a formattedLogObject if the appender is\nconfigured to log the loggedObject too.</p>\n\n<p>Derived classes might want to add data for the output destination\nto handle. For example, an output window might want to provide\na version of a formatted logged object that will be shown in a\nsingle line, and another one formatted in multiple line,\nto be shown in an expanded view.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>logEvent</span> : <a href=\"#!/api/Sm.log.LoggingEvent\" rel=\"Sm.log.LoggingEvent\" class=\"docClass\">Sm.log.LoggingEvent</a><div class='sub-desc'><p>The original log data.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-formatLogAsText' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.LayoutBase'>Sm.log.LayoutBase</span><br/><a href='source/LayoutBase.html#Sm-log-LayoutBase-method-formatLogAsText' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.LayoutBase-method-formatLogAsText' class='name expandable'>formatLogAsText</a>( <span class='pre'>logEvent</span> )<strong class='abstract signature' >abstract</strong><strong class='protected signature' >protected</strong></div><div class='description'><div class='short'>Returns a text corresponding to the log. ...</div><div class='long'><p>Returns a text corresponding to the log.</p>\n\n<p>This is useful in scenarios in which the log is written in a\nsingle line, such as the browser console.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>logEvent</span> : <a href=\"#!/api/Sm.log.LoggingEvent\" rel=\"Sm.log.LoggingEvent\" class=\"docClass\">Sm.log.LoggingEvent</a><div class='sub-desc'><p>The log information.</p>\n</div></li></ul></div></div></div><div id='method-formatLoggedObject' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.LayoutBase'>Sm.log.LayoutBase</span><br/><a href='source/LayoutBase.html#Sm-log-LayoutBase-method-formatLoggedObject' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.LayoutBase-method-formatLoggedObject' class='name expandable'>formatLoggedObject</a>( <span class='pre'>logEvent</span> ) : Object<strong class='protected signature' >protected</strong></div><div class='description'><div class='short'>Returns a formatted text corresponding to the logged object. ...</div><div class='long'><p>Returns a formatted text corresponding to the logged object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>logEvent</span> : <a href=\"#!/api/Sm.log.LoggingEvent\" rel=\"Sm.log.LoggingEvent\" class=\"docClass\">Sm.log.LoggingEvent</a><div class='sub-desc'><p>The log data.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>The formatted text corresponding to the logged object.</p>\n</div></li></ul></div></div></div><div id='method-formatMessage' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.LayoutBase'>Sm.log.LayoutBase</span><br/><a href='source/LayoutBase.html#Sm-log-LayoutBase-method-formatMessage' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.LayoutBase-method-formatMessage' class='name expandable'>formatMessage</a>( <span class='pre'>logEvent</span> ) : Object<strong class='protected signature' >protected</strong></div><div class='description'><div class='short'>Formats the log message. ...</div><div class='long'><p>Formats the log message.</p>\n\n<p>This will use the extra formatting information provided in the log\nmethod call to return a formatted message. Take a look at this <a href=\"http://code.google.com/p/log4js-ext/wiki/LoggingFormatting\">wiki\nentry</a>\nfor examples on supported formatting.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>logEvent</span> : <a href=\"#!/api/Sm.log.LoggingEvent\" rel=\"Sm.log.LoggingEvent\" class=\"docClass\">Sm.log.LoggingEvent</a><div class='sub-desc'><p>The log data.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-formatTime' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.LayoutBase'>Sm.log.LayoutBase</span><br/><a href='source/LayoutBase.html#Sm-log-LayoutBase-method-formatTime' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.LayoutBase-method-formatTime' class='name expandable'>formatTime</a>( <span class='pre'>logEvent</span> ) : Object<strong class='protected signature' >protected</strong></div><div class='description'><div class='short'>Formats the log time. ...</div><div class='long'><p>Formats the log time.</p>\n\n<p>If there is no timeFormat, calls toString.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>logEvent</span> : <a href=\"#!/api/Sm.log.LoggingEvent\" rel=\"Sm.log.LoggingEvent\" class=\"docClass\">Sm.log.LoggingEvent</a><div class='sub-desc'><p>The log data.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getExportFormattedLoggedObject' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.LayoutBase'>Sm.log.LayoutBase</span><br/><a href='source/LayoutBase.html#Sm-log-LayoutBase-cfg-exportFormattedLoggedObject' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.LayoutBase-method-getExportFormattedLoggedObject' class='name expandable'>getExportFormattedLoggedObject</a>( <span class='pre'></span> ) : Boolean</div><div class='description'><div class='short'>Returns the value of exportFormattedLoggedObject. ...</div><div class='long'><p>Returns the value of <a href=\"#!/api/Sm.log.LayoutBase-cfg-exportFormattedLoggedObject\" rel=\"Sm.log.LayoutBase-cfg-exportFormattedLoggedObject\" class=\"docClass\">exportFormattedLoggedObject</a>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getFormatIndentLoggedObject' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.LayoutBase'>Sm.log.LayoutBase</span><br/><a href='source/LayoutBase.html#Sm-log-LayoutBase-cfg-formatIndentLoggedObject' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.LayoutBase-method-getFormatIndentLoggedObject' class='name expandable'>getFormatIndentLoggedObject</a>( <span class='pre'></span> ) : Number</div><div class='description'><div class='short'>Returns the value of formatIndentLoggedObject. ...</div><div class='long'><p>Returns the value of <a href=\"#!/api/Sm.log.LayoutBase-cfg-formatIndentLoggedObject\" rel=\"Sm.log.LayoutBase-cfg-formatIndentLoggedObject\" class=\"docClass\">formatIndentLoggedObject</a>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Number</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getHighlightLoggedObject' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.LayoutBase'>Sm.log.LayoutBase</span><br/><a href='source/LayoutBase.html#Sm-log-LayoutBase-cfg-highlightLoggedObject' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.LayoutBase-method-getHighlightLoggedObject' class='name expandable'>getHighlightLoggedObject</a>( <span class='pre'></span> ) : Boolean</div><div class='description'><div class='short'>Returns the value of highlightLoggedObject. ...</div><div class='long'><p>Returns the value of <a href=\"#!/api/Sm.log.LayoutBase-cfg-highlightLoggedObject\" rel=\"Sm.log.LayoutBase-cfg-highlightLoggedObject\" class=\"docClass\">highlightLoggedObject</a>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getMultilineLoggedObject' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.LayoutBase'>Sm.log.LayoutBase</span><br/><a href='source/LayoutBase.html#Sm-log-LayoutBase-cfg-multilineLoggedObject' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.LayoutBase-method-getMultilineLoggedObject' class='name expandable'>getMultilineLoggedObject</a>( <span class='pre'></span> ) : Boolean</div><div class='description'><div class='short'>Returns the value of multilineLoggedObject. ...</div><div class='long'><p>Returns the value of <a href=\"#!/api/Sm.log.LayoutBase-cfg-multilineLoggedObject\" rel=\"Sm.log.LayoutBase-cfg-multilineLoggedObject\" class=\"docClass\">multilineLoggedObject</a>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getTimeFormat' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.LayoutBase'>Sm.log.LayoutBase</span><br/><a href='source/LayoutBase.html#Sm-log-LayoutBase-cfg-timeFormat' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.LayoutBase-method-getTimeFormat' class='name expandable'>getTimeFormat</a>( <span class='pre'></span> ) : String</div><div class='description'><div class='short'>Returns the value of timeFormat. ...</div><div class='long'><p>Returns the value of <a href=\"#!/api/Sm.log.LayoutBase-cfg-timeFormat\" rel=\"Sm.log.LayoutBase-cfg-timeFormat\" class=\"docClass\">timeFormat</a>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-jsonLikeFormat' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.LayoutBase'>Sm.log.LayoutBase</span><br/><a href='source/LayoutBase.html#Sm-log-LayoutBase-method-jsonLikeFormat' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.LayoutBase-method-jsonLikeFormat' class='name expandable'>jsonLikeFormat</a>( <span class='pre'>obj, highlight, multiline, indent</span> ) : String<strong class='protected signature' >protected</strong></div><div class='description'><div class='short'>Returns a JSON string correponding to an object. ...</div><div class='long'><p>Returns a JSON string correponding to an object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>obj</span> : Object<div class='sub-desc'><p>The object to format.</p>\n</div></li><li><span class='pre'>highlight</span> : Boolean<div class='sub-desc'><p>If true, attempts to provide</p>\n\n<pre><code>             highlighting (html)\n</code></pre>\n</div></li><li><span class='pre'>multiline</span> : Boolean<div class='sub-desc'><p>Use multiple text lines?</p>\n</div></li><li><span class='pre'>indent</span> : Number<div class='sub-desc'><p>Indentation level (spaces)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>A formatted JSON string representing an object.</p>\n</div></li></ul></div></div></div><div id='method-jsonSyntaxHighlight' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.LayoutBase'>Sm.log.LayoutBase</span><br/><a href='source/LayoutBase.html#Sm-log-LayoutBase-method-jsonSyntaxHighlight' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.LayoutBase-method-jsonSyntaxHighlight' class='name expandable'>jsonSyntaxHighlight</a>( <span class='pre'>json, jsonCls</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Obtained from http://jsfiddle.net/KJQ9K/ : many thanks!! ...</div><div class='long'><p>Obtained from http://jsfiddle.net/KJQ9K/ : many thanks!!</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>json</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>jsonCls</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-multiFormat' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.LayoutBase'>Sm.log.LayoutBase</span><br/><a href='source/LayoutBase.html#Sm-log-LayoutBase-method-multiFormat' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.LayoutBase-method-multiFormat' class='name expandable'>multiFormat</a>( <span class='pre'>str, formatParams</span> ) : String<strong class='protected signature' >protected</strong></div><div class='description'><div class='short'>Formats a string depending on the format parameters a-la\nExt.Template. ...</div><div class='long'><p>Formats a string depending on the format parameters a-la\nExt.Template.</p>\n\n<p>It is a poor man's version of Ext.Template.apply(..) that is not very\nefficient <em>but</em> can cope with values not being present without\nreturning an empty string, unlike Ext.Template</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>str</span> : String<div class='sub-desc'><p>The string to format.</p>\n</div></li><li><span class='pre'>formatParams</span> : Array<div class='sub-desc'><p>Formatting parameters</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>The formatted string.</p>\n</div></li></ul></div></div></div><div id='method-setExportFormattedLoggedObject' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.LayoutBase'>Sm.log.LayoutBase</span><br/><a href='source/LayoutBase.html#Sm-log-LayoutBase-cfg-exportFormattedLoggedObject' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.LayoutBase-method-setExportFormattedLoggedObject' class='name expandable'>setExportFormattedLoggedObject</a>( <span class='pre'>exportFormattedLoggedObject</span> )</div><div class='description'><div class='short'>Sets the value of exportFormattedLoggedObject. ...</div><div class='long'><p>Sets the value of <a href=\"#!/api/Sm.log.LayoutBase-cfg-exportFormattedLoggedObject\" rel=\"Sm.log.LayoutBase-cfg-exportFormattedLoggedObject\" class=\"docClass\">exportFormattedLoggedObject</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>exportFormattedLoggedObject</span> : Boolean<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setFormatIndentLoggedObject' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.LayoutBase'>Sm.log.LayoutBase</span><br/><a href='source/LayoutBase.html#Sm-log-LayoutBase-cfg-formatIndentLoggedObject' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.LayoutBase-method-setFormatIndentLoggedObject' class='name expandable'>setFormatIndentLoggedObject</a>( <span class='pre'>formatIndentLoggedObject</span> )</div><div class='description'><div class='short'>Sets the value of formatIndentLoggedObject. ...</div><div class='long'><p>Sets the value of <a href=\"#!/api/Sm.log.LayoutBase-cfg-formatIndentLoggedObject\" rel=\"Sm.log.LayoutBase-cfg-formatIndentLoggedObject\" class=\"docClass\">formatIndentLoggedObject</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>formatIndentLoggedObject</span> : Number<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setHighlightLoggedObject' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.LayoutBase'>Sm.log.LayoutBase</span><br/><a href='source/LayoutBase.html#Sm-log-LayoutBase-cfg-highlightLoggedObject' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.LayoutBase-method-setHighlightLoggedObject' class='name expandable'>setHighlightLoggedObject</a>( <span class='pre'>highlightLoggedObject</span> )</div><div class='description'><div class='short'>Sets the value of highlightLoggedObject. ...</div><div class='long'><p>Sets the value of <a href=\"#!/api/Sm.log.LayoutBase-cfg-highlightLoggedObject\" rel=\"Sm.log.LayoutBase-cfg-highlightLoggedObject\" class=\"docClass\">highlightLoggedObject</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>highlightLoggedObject</span> : Boolean<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setMultilineLoggedObject' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.LayoutBase'>Sm.log.LayoutBase</span><br/><a href='source/LayoutBase.html#Sm-log-LayoutBase-cfg-multilineLoggedObject' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.LayoutBase-method-setMultilineLoggedObject' class='name expandable'>setMultilineLoggedObject</a>( <span class='pre'>multilineLoggedObject</span> )</div><div class='description'><div class='short'>Sets the value of multilineLoggedObject. ...</div><div class='long'><p>Sets the value of <a href=\"#!/api/Sm.log.LayoutBase-cfg-multilineLoggedObject\" rel=\"Sm.log.LayoutBase-cfg-multilineLoggedObject\" class=\"docClass\">multilineLoggedObject</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>multilineLoggedObject</span> : Boolean<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setTimeFormat' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.LayoutBase'>Sm.log.LayoutBase</span><br/><a href='source/LayoutBase.html#Sm-log-LayoutBase-cfg-timeFormat' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.LayoutBase-method-setTimeFormat' class='name expandable'>setTimeFormat</a>( <span class='pre'>timeFormat</span> )</div><div class='description'><div class='short'>Sets the value of timeFormat. ...</div><div class='long'><p>Sets the value of <a href=\"#!/api/Sm.log.LayoutBase-cfg-timeFormat\" rel=\"Sm.log.LayoutBase-cfg-timeFormat\" class=\"docClass\">timeFormat</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>timeFormat</span> : String<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-simpleFormat' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.LayoutBase'>Sm.log.LayoutBase</span><br/><a href='source/LayoutBase.html#Sm-log-LayoutBase-method-simpleFormat' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.LayoutBase-method-simpleFormat' class='name expandable'>simpleFormat</a>( <span class='pre'>str, formatParams</span> ) : String<strong class='protected signature' >protected</strong></div><div class='description'><div class='short'>Format a string using the format parameters, a-la Ext.String.format. ...</div><div class='long'><p>Format a string using the format parameters, a-la Ext.String.format.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>str</span> : String<div class='sub-desc'><p>The string to format.</p>\n</div></li><li><span class='pre'>formatParams</span> : Array<div class='sub-desc'><p>Formatting parameters</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>The formatted String</p>\n</div></li></ul></div></div></div></div></div></div></div>"});