Ext.data.JsonP.Sm_log_Level({"tagname":"class","name":"Sm.log.Level","extends":"Ext.Base","mixins":[],"alternateClassNames":[],"aliases":{},"singleton":false,"requires":[],"uses":["Sm.log.util.Assert","Sm.log.util.Debug"],"enum":null,"override":null,"inheritable":null,"inheritdoc":null,"meta":{},"private":null,"id":"class-Sm.log.Level","code_type":"ext_define","members":{"cfg":[{"name":"level","tagname":"cfg","owner":"Sm.log.Level","meta":{"readonly":true,"required":true},"id":"cfg-level"},{"name":"name","tagname":"cfg","owner":"Sm.log.Level","meta":{"readonly":true,"required":true},"id":"cfg-name"}],"property":[],"method":[{"name":"constructor","tagname":"method","owner":"Sm.log.Level","meta":{"private":true},"id":"method-constructor"},{"name":"getName","tagname":"method","owner":"Sm.log.Level","meta":{"readonly":true},"id":"method-getName"},{"name":"le","tagname":"method","owner":"Sm.log.Level","meta":{},"id":"method-le"},{"name":"setLevel","tagname":"method","owner":"Sm.log.Level","meta":{"readonly":true},"id":"method-setLevel"},{"name":"setName","tagname":"method","owner":"Sm.log.Level","meta":{"readonly":true},"id":"method-setName"}],"event":[],"css_var":[],"css_mixin":[]},"linenr":29,"files":[{"filename":"Level.js","href":"Level.html#Sm-log-Level"}],"html_meta":{},"statics":{"cfg":[],"property":[{"name":"ALL","tagname":"property","owner":"Sm.log.Level","meta":{"readonly":true,"static":true},"id":"property-ALL"},{"name":"DEBUG","tagname":"property","owner":"Sm.log.Level","meta":{"readonly":true,"static":true},"id":"property-DEBUG"},{"name":"ERROR","tagname":"property","owner":"Sm.log.Level","meta":{"readonly":true,"static":true},"id":"property-ERROR"},{"name":"FATAL","tagname":"property","owner":"Sm.log.Level","meta":{"readonly":true,"static":true},"id":"property-FATAL"},{"name":"INFO","tagname":"property","owner":"Sm.log.Level","meta":{"readonly":true,"static":true},"id":"property-INFO"},{"name":"NONE","tagname":"property","owner":"Sm.log.Level","meta":{"readonly":true,"static":true},"id":"property-NONE"},{"name":"TRACE","tagname":"property","owner":"Sm.log.Level","meta":{"readonly":true,"static":true},"id":"property-TRACE"},{"name":"WARN","tagname":"property","owner":"Sm.log.Level","meta":{"readonly":true,"static":true},"id":"property-WARN"}],"method":[{"name":"getLevel","tagname":"method","owner":"Sm.log.Level","meta":{"static":true},"id":"method-getLevel"},{"name":"getLevelLevel","tagname":"method","owner":"Sm.log.Level","meta":{"static":true},"id":"method-getLevelLevel"},{"name":"initStatics","tagname":"method","owner":"Sm.log.Level","meta":{"private":true,"static":true},"id":"method-initStatics"}],"event":[],"css_var":[],"css_mixin":[]},"component":false,"superclasses":["Ext.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'>Ext.Base<div class='subclass '><strong>Sm.log.Level</strong></div></div><h4>Uses</h4><div class='dependency'><a href='#!/api/Sm.log.util.Assert' rel='Sm.log.util.Assert' class='docClass'>Sm.log.util.Assert</a></div><div class='dependency'><a href='#!/api/Sm.log.util.Debug' rel='Sm.log.util.Debug' class='docClass'>Sm.log.util.Debug</a></div><h4>Files</h4><div class='dependency'><a href='source/Level.html#Sm-log-Level' target='_blank'>Level.js</a></div></pre><div class='doc-contents'><p>The level is the importance or priority of a certain logging operation.</p>\n\n<p>Predefined levels are FATAL, ERROR, WARN, INFO, DEBUG, and TRACE.</p>\n\n<p>NONE and ALL are useful to control logging, but they can't be used\nin a logging operation, as they make no sense in that context.</p>\n</div><div class='members'><div class='members-section'><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Required Config options</h3><div id='cfg-level' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Level'>Sm.log.Level</span><br/><a href='source/Level.html#Sm-log-Level-cfg-level' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Level-cfg-level' class='name expandable'>level</a><span> : Number</span><strong class='readonly signature' >readonly</strong><strong class='required signature' >required</strong></div><div class='description'><div class='short'>The level value. ...</div><div class='long'><p>The level value.</p>\n<p>Defaults to: <code>value provided in constructor</code></p></div></div></div><div id='cfg-name' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Level'>Sm.log.Level</span><br/><a href='source/Level.html#Sm-log-Level-cfg-name' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Level-cfg-name' class='name expandable'>name</a><span> : String</span><strong class='readonly signature' >readonly</strong><strong class='required signature' >required</strong></div><div class='description'><div class='short'>The level name. ...</div><div class='long'><p>The level name.</p>\n<p>Defaults to: <code>value provided in constructor</code></p></div></div></div></div></div><div class='members-section'><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static Properties</h3><div id='property-ALL' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Level'>Sm.log.Level</span><br/><a href='source/Level.html#Sm-log-Level-property-ALL' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Level-property-ALL' class='name expandable'>ALL</a><span> : <a href=\"#!/api/Sm.log.Level\" rel=\"Sm.log.Level\" class=\"docClass\">Sm.log.Level</a></span><strong class='readonly signature' >readonly</strong><strong class='static signature' >static</strong></div><div class='description'><div class='short'>Represents 'all level', useful in some contexts to\nspecify that alls levels should be logged. ...</div><div class='long'><p>Represents 'all level', useful in some contexts to\nspecify that alls levels should be logged.</p>\n\n<p>Do not use as a log operation level.</p>\n</div></div></div><div id='property-DEBUG' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Level'>Sm.log.Level</span><br/><a href='source/Level.html#Sm-log-Level-property-DEBUG' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Level-property-DEBUG' class='name expandable'>DEBUG</a><span> : <a href=\"#!/api/Sm.log.Level\" rel=\"Sm.log.Level\" class=\"docClass\">Sm.log.Level</a></span><strong class='readonly signature' >readonly</strong><strong class='static signature' >static</strong></div><div class='description'><div class='short'>Represents a debug log. ...</div><div class='long'><p>Represents a debug log.</p>\n\n<p>We will probably be interested in debug logs only while debugging.</p>\n</div></div></div><div id='property-ERROR' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Level'>Sm.log.Level</span><br/><a href='source/Level.html#Sm-log-Level-property-ERROR' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Level-property-ERROR' class='name expandable'>ERROR</a><span> : <a href=\"#!/api/Sm.log.Level\" rel=\"Sm.log.Level\" class=\"docClass\">Sm.log.Level</a></span><strong class='readonly signature' >readonly</strong><strong class='static signature' >static</strong></div><div class='description'><div class='short'>Represents an error. ...</div><div class='long'><p>Represents an error.</p>\n\n<p>The diference between error and fatal error depends on the\ncontext, and might or might not exist in some contexts. How to\ninterpret that depends on the context, and has to be defined\nby the application</p>\n</div></div></div><div id='property-FATAL' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Level'>Sm.log.Level</span><br/><a href='source/Level.html#Sm-log-Level-property-FATAL' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Level-property-FATAL' class='name expandable'>FATAL</a><span> : <a href=\"#!/api/Sm.log.Level\" rel=\"Sm.log.Level\" class=\"docClass\">Sm.log.Level</a></span><strong class='readonly signature' >readonly</strong><strong class='static signature' >static</strong></div><div class='description'><div class='short'>Represents a fatal error. ...</div><div class='long'><p>Represents a fatal error.</p>\n\n<p>The diference between error and fatal error depends on the\ncontext, and might or might not exist in some contexts. How to\ninterpret that depends on the context, and has to be defined\nby the application</p>\n</div></div></div><div id='property-INFO' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Level'>Sm.log.Level</span><br/><a href='source/Level.html#Sm-log-Level-property-INFO' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Level-property-INFO' class='name not-expandable'>INFO</a><span> : <a href=\"#!/api/Sm.log.Level\" rel=\"Sm.log.Level\" class=\"docClass\">Sm.log.Level</a></span><strong class='readonly signature' >readonly</strong><strong class='static signature' >static</strong></div><div class='description'><div class='short'><p>Represents an informative log.</p>\n</div><div class='long'><p>Represents an informative log.</p>\n</div></div></div><div id='property-NONE' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Level'>Sm.log.Level</span><br/><a href='source/Level.html#Sm-log-Level-property-NONE' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Level-property-NONE' class='name expandable'>NONE</a><span> : <a href=\"#!/api/Sm.log.Level\" rel=\"Sm.log.Level\" class=\"docClass\">Sm.log.Level</a></span><strong class='readonly signature' >readonly</strong><strong class='static signature' >static</strong></div><div class='description'><div class='short'>Represents 'no level', useful in some contexts to\nspecify that no level should be logged. ...</div><div class='long'><p>Represents 'no level', useful in some contexts to\nspecify that no level should be logged.</p>\n\n<p>Do not use as a log operation level.</p>\n</div></div></div><div id='property-TRACE' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Level'>Sm.log.Level</span><br/><a href='source/Level.html#Sm-log-Level-property-TRACE' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Level-property-TRACE' class='name expandable'>TRACE</a><span> : <a href=\"#!/api/Sm.log.Level\" rel=\"Sm.log.Level\" class=\"docClass\">Sm.log.Level</a></span><strong class='readonly signature' >readonly</strong><strong class='static signature' >static</strong></div><div class='description'><div class='short'>Represents a low level debug log. ...</div><div class='long'><p>Represents a low level debug log.</p>\n\n<p>We will probably be interested in trace logs only while heavily\ndebugging.</p>\n</div></div></div><div id='property-WARN' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Level'>Sm.log.Level</span><br/><a href='source/Level.html#Sm-log-Level-property-WARN' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Level-property-WARN' class='name not-expandable'>WARN</a><span> : <a href=\"#!/api/Sm.log.Level\" rel=\"Sm.log.Level\" class=\"docClass\">Sm.log.Level</a></span><strong class='readonly signature' >readonly</strong><strong class='static signature' >static</strong></div><div class='description'><div class='short'><p>Represents a warning.</p>\n</div><div class='long'><p>Represents a warning.</p>\n</div></div></div></div></div><div class='members-section'><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance Methods</h3><div id='method-constructor' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Level'>Sm.log.Level</span><br/><a href='source/Level.html#Sm-log-Level-method-constructor' target='_blank' class='view-source'>view source</a></div><strong class='new-keyword'>new</strong><a href='#!/api/Sm.log.Level-method-constructor' class='name expandable'>Sm.log.Level</a>( <span class='pre'>cfg</span> ) : <a href=\"#!/api/Sm.log.Level\" rel=\"Sm.log.Level\" class=\"docClass\">Sm.log.Level</a><strong class='private signature' >private</strong></div><div class='description'><div class='short'>Creates a new level. ...</div><div class='long'><p>Creates a new level.</p>\n\n<p>You should not create your own levels. The library has not been created\nwith the idea of allowing user defined levels. Therefore, it might or\nmight not work if you do so.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cfg</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Sm.log.Level\" rel=\"Sm.log.Level\" class=\"docClass\">Sm.log.Level</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Level'>Sm.log.Level</span><br/><a href='source/Level.html#Sm-log-Level-cfg-name' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Level-method-getName' class='name expandable'>getName</a>( <span class='pre'></span> ) : String<strong class='readonly signature' >readonly</strong></div><div class='description'><div class='short'>Returns the value of name. ...</div><div class='long'><p>Returns the value of <a href=\"#!/api/Sm.log.Level-cfg-name\" rel=\"Sm.log.Level-cfg-name\" class=\"docClass\">name</a>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-le' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Level'>Sm.log.Level</span><br/><a href='source/Level.html#Sm-log-Level-method-le' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Level-method-le' class='name expandable'>le</a>( <span class='pre'>level</span> ) : Boolean</div><div class='description'><div class='short'>Compares two levels, return true if this ones is lesser or equal\nthan the one received by the function. ...</div><div class='long'><p>Compares two levels, return true if this ones is lesser or equal\nthan the one received by the function.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>level</span> : <a href=\"#!/api/Sm.log.Level\" rel=\"Sm.log.Level\" class=\"docClass\">Sm.log.Level</a><div class='sub-desc'><p>The level to compare with this level.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setLevel' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Level'>Sm.log.Level</span><br/><a href='source/Level.html#Sm-log-Level-cfg-level' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Level-method-setLevel' class='name expandable'>setLevel</a>( <span class='pre'>level</span> )<strong class='readonly signature' >readonly</strong></div><div class='description'><div class='short'>Sets the value of level. ...</div><div class='long'><p>Sets the value of <a href=\"#!/api/Sm.log.Level-cfg-level\" rel=\"Sm.log.Level-cfg-level\" class=\"docClass\">level</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>level</span> : Number<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Level'>Sm.log.Level</span><br/><a href='source/Level.html#Sm-log-Level-cfg-name' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Level-method-setName' class='name expandable'>setName</a>( <span class='pre'>name</span> )<strong class='readonly signature' >readonly</strong></div><div class='description'><div class='short'>Sets the value of name. ...</div><div class='long'><p>Sets the value of <a href=\"#!/api/Sm.log.Level-cfg-name\" rel=\"Sm.log.Level-cfg-name\" class=\"docClass\">name</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : String<div class='sub-desc'>\n</div></li></ul></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static Methods</h3><div id='method-getLevel' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Level'>Sm.log.Level</span><br/><a href='source/Level.html#Sm-log-Level-method-getLevel' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Level-method-getLevel' class='name expandable'>getLevel</a>( <span class='pre'>levelName</span> ) : <a href=\"#!/api/Sm.log.Level\" rel=\"Sm.log.Level\" class=\"docClass\">Sm.log.Level</a><strong class='static signature' >static</strong></div><div class='description'><div class='short'>Returns a level, given its name. ...</div><div class='long'><p>Returns a level, given its name.</p>\n\n<p>This can be very useful to get a level given a user-specified\ntext via a combo, etc.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>levelName</span> : String<div class='sub-desc'><p>The level name.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Sm.log.Level\" rel=\"Sm.log.Level\" class=\"docClass\">Sm.log.Level</a></span><div class='sub-desc'><p>The level with the specified name.</p>\n</div></li></ul></div></div></div><div id='method-getLevelLevel' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Level'>Sm.log.Level</span><br/><a href='source/Level.html#Sm-log-Level-method-getLevelLevel' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Level-method-getLevelLevel' class='name expandable'>getLevelLevel</a>( <span class='pre'>levelName</span> ) : Number<strong class='static signature' >static</strong></div><div class='description'><div class='short'>Returns a level's level, given the level name. ...</div><div class='long'><p>Returns a level's level, given the level name.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>levelName</span> : String<div class='sub-desc'><p>The level name.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Number</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initStatics' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Level'>Sm.log.Level</span><br/><a href='source/Level.html#Sm-log-Level-method-initStatics' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Level-method-initStatics' class='name expandable'>initStatics</a>( <span class='pre'></span> ) : void<strong class='private signature' >private</strong><strong class='static signature' >static</strong></div><div class='description'><div class='short'>Initializes logging levels. ...</div><div class='long'><p>Initializes logging levels.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div></div></div></div></div>"});