Ext.data.JsonP.Sm_log_LogViewerAppender({"tagname":"class","name":"Sm.log.LogViewerAppender","extends":"Sm.log.AppenderBase","mixins":[],"alternateClassNames":[],"aliases":{},"singleton":false,"requires":[],"uses":["Sm.log.util.Assert"],"enum":null,"override":null,"inheritable":null,"inheritdoc":null,"meta":{},"private":null,"id":"class-Sm.log.LogViewerAppender","code_type":"ext_define","members":{"cfg":[{"name":"htmlEncodedLogEventProperties","tagname":"cfg","owner":"Sm.log.AppenderBase","meta":{},"id":"cfg-htmlEncodedLogEventProperties"}],"property":[],"method":[{"name":"constructor","tagname":"method","owner":"Sm.log.LogViewerAppender","meta":{},"id":"method-constructor"},{"name":"attachViewer","tagname":"method","owner":"Sm.log.LogViewerAppender","meta":{"private":true},"id":"method-attachViewer"},{"name":"canLog","tagname":"method","owner":"Sm.log.LogViewerAppender","meta":{},"id":"method-canLog"},{"name":"clearBuffer","tagname":"method","owner":"Sm.log.LogViewerAppender","meta":{},"id":"method-clearBuffer"},{"name":"detachViewer","tagname":"method","owner":"Sm.log.LogViewerAppender","meta":{"private":true},"id":"method-detachViewer"},{"name":"doLog","tagname":"method","owner":"Sm.log.LogViewerAppender","meta":{"protected":true},"id":"method-doLog"},{"name":"doPhysicalLog","tagname":"method","owner":"Sm.log.LogViewerAppender","meta":{"private":true},"id":"method-doPhysicalLog"},{"name":"formatLogAsText","tagname":"method","owner":"Sm.log.AppenderBase","meta":{},"id":"method-formatLogAsText"},{"name":"getHtmlEncodedLogEventProperties","tagname":"method","owner":"Sm.log.AppenderBase","meta":{},"id":"method-getHtmlEncodedLogEventProperties"},{"name":"getLayout","tagname":"method","owner":"Sm.log.AppenderBase","meta":{},"id":"method-getLayout"},{"name":"getState","tagname":"method","owner":"Sm.log.AppenderBase","meta":{},"id":"method-getState"},{"name":"htmlEncodeStringValues","tagname":"method","owner":"Sm.log.AppenderBase","meta":{"private":true},"id":"method-htmlEncodeStringValues"},{"name":"isBuffering","tagname":"method","owner":"Sm.log.LogViewerAppender","meta":{},"id":"method-isBuffering"},{"name":"isLogging","tagname":"method","owner":"Sm.log.AppenderBase","meta":{},"id":"method-isLogging"},{"name":"isStopped","tagname":"method","owner":"Sm.log.AppenderBase","meta":{},"id":"method-isStopped"},{"name":"log","tagname":"method","owner":"Sm.log.AppenderBase","meta":{"private":true},"id":"method-log"},{"name":"setHtmlEncodedLogEventProperties","tagname":"method","owner":"Sm.log.AppenderBase","meta":{},"id":"method-setHtmlEncodedLogEventProperties"},{"name":"setInitialState","tagname":"method","owner":"Sm.log.LogViewerAppender","meta":{"protected":true},"id":"method-setInitialState"},{"name":"setLayout","tagname":"method","owner":"Sm.log.AppenderBase","meta":{},"id":"method-setLayout"},{"name":"startBuffering","tagname":"method","owner":"Sm.log.LogViewerAppender","meta":{},"id":"method-startBuffering"},{"name":"startLogging","tagname":"method","owner":"Sm.log.LogViewerAppender","meta":{},"id":"method-startLogging"},{"name":"stopLogging","tagname":"method","owner":"Sm.log.LogViewerAppender","meta":{},"id":"method-stopLogging"},{"name":"supportsBuffering","tagname":"method","owner":"Sm.log.LogViewerAppender","meta":{},"id":"method-supportsBuffering"}],"event":[],"css_var":[],"css_mixin":[]},"linenr":31,"files":[{"filename":"LogViewerAppender.js","href":"LogViewerAppender.html#Sm-log-LogViewerAppender"}],"html_meta":{},"statics":{"cfg":[],"property":[],"method":[],"event":[],"css_var":[],"css_mixin":[]},"component":false,"superclasses":["Ext.Base","Sm.log.AppenderBase"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'>Ext.Base<div class='subclass '><a href='#!/api/Sm.log.AppenderBase' rel='Sm.log.AppenderBase' class='docClass'>Sm.log.AppenderBase</a><div class='subclass '><strong>Sm.log.LogViewerAppender</strong></div></div></div><h4>Uses</h4><div class='dependency'><a href='#!/api/Sm.log.util.Assert' rel='Sm.log.util.Assert' class='docClass'>Sm.log.util.Assert</a></div><h4>Files</h4><div class='dependency'><a href='source/LogViewerAppender.html#Sm-log-LogViewerAppender' target='_blank'>LogViewerAppender.js</a></div></pre><div class='doc-contents'><p>An appender that knows how to output data to the built-in log viewer\nwindow (see <a href=\"#!/api/Sm.log.LogViewerWindow\" rel=\"Sm.log.LogViewerWindow\" class=\"docClass\">Sm.log.LogViewerWindow</a>).</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-htmlEncodedLogEventProperties' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Sm.log.AppenderBase' rel='Sm.log.AppenderBase' class='defined-in docClass'>Sm.log.AppenderBase</a><br/><a href='source/AppenderBase.html#Sm-log-AppenderBase-cfg-htmlEncodedLogEventProperties' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.AppenderBase-cfg-htmlEncodedLogEventProperties' class='name expandable'>htmlEncodedLogEventProperties</a><span> : Array</span></div><div class='description'><div class='short'>A list with the EventLogging properties for which to call\nExt.util.Format.htmlEncode before logging them. ...</div><div class='long'><p>A list with the EventLogging properties for which to call\nExt.util.Format.htmlEncode before logging them.</p>\n\n<p>This is important if the output will go to html, you\nare using special html characters, and you want these\ncharacters to be shown as-is.</p>\n<p>Defaults to: <code>[]</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-constructor' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.LogViewerAppender'>Sm.log.LogViewerAppender</span><br/><a href='source/LogViewerAppender.html#Sm-log-LogViewerAppender-method-constructor' target='_blank' class='view-source'>view source</a></div><strong class='new-keyword'>new</strong><a href='#!/api/Sm.log.LogViewerAppender-method-constructor' class='name expandable'>Sm.log.LogViewerAppender</a>( <span class='pre'>cfg</span> ) : <a href=\"#!/api/Sm.log.LogViewerAppender\" rel=\"Sm.log.LogViewerAppender\" class=\"docClass\">Sm.log.LogViewerAppender</a></div><div class='description'><div class='short'>Creates a new log viewer appender. ...</div><div class='long'><p>Creates a new log viewer appender.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cfg</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Sm.log.LogViewerAppender\" rel=\"Sm.log.LogViewerAppender\" class=\"docClass\">Sm.log.LogViewerAppender</a></span><div class='sub-desc'>\n</div></li></ul><p>Overrides: <a href='#!/api/Sm.log.AppenderBase-method-constructor' rel='Sm.log.AppenderBase-method-constructor' class='docClass'>Sm.log.AppenderBase.constructor</a></p></div></div></div><div id='method-attachViewer' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.LogViewerAppender'>Sm.log.LogViewerAppender</span><br/><a href='source/LogViewerAppender.html#Sm-log-LogViewerAppender-method-attachViewer' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.LogViewerAppender-method-attachViewer' class='name expandable'>attachViewer</a>( <span class='pre'>viewer</span> ) : void<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Attaches the appender to a viewer. ...</div><div class='long'><p>Attaches the appender to a viewer.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>viewer</span> : <a href=\"#!/api/Sm.log.LogViewerWindow\" rel=\"Sm.log.LogViewerWindow\" class=\"docClass\">Sm.log.LogViewerWindow</a><div class='sub-desc'><p>The viewer to which to attach this appender.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-canLog' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.LogViewerAppender'>Sm.log.LogViewerAppender</span><br/><a href='source/LogViewerAppender.html#Sm-log-LogViewerAppender-method-canLog' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.LogViewerAppender-method-canLog' class='name expandable'>canLog</a>( <span class='pre'></span> ) : Boolean</div><div class='description'><div class='short'>Returns true if we can log. ...</div><div class='long'><p>Returns true if we can log.</p>\n\n<p>Note that we might not be able to log directly when the viewer\nwindow is not available, for example.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-clearBuffer' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.LogViewerAppender'>Sm.log.LogViewerAppender</span><br/><a href='source/LogViewerAppender.html#Sm-log-LogViewerAppender-method-clearBuffer' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.LogViewerAppender-method-clearBuffer' class='name expandable'>clearBuffer</a>( <span class='pre'></span> ) : void</div><div class='description'><div class='short'>Clears the buffered logs. ...</div><div class='long'><p>Clears the buffered logs.</p>\n\n<p>The buffered log are lost.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-detachViewer' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.LogViewerAppender'>Sm.log.LogViewerAppender</span><br/><a href='source/LogViewerAppender.html#Sm-log-LogViewerAppender-method-detachViewer' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.LogViewerAppender-method-detachViewer' class='name expandable'>detachViewer</a>( <span class='pre'></span> ) : void<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Detaches the appender from this viewer. ...</div><div class='long'><p>Detaches the appender from this viewer.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-doLog' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.LogViewerAppender'>Sm.log.LogViewerAppender</span><br/><a href='source/LogViewerAppender.html#Sm-log-LogViewerAppender-method-doLog' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.LogViewerAppender-method-doLog' class='name expandable'>doLog</a>( <span class='pre'>logEvent</span> ) : void<strong class='protected signature' >protected</strong></div><div class='description'><div class='short'>Writes the log data ...</div><div class='long'><p>Writes the log data</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>logEvent</span> : <a href=\"#!/api/Sm.log.LoggingEvent\" rel=\"Sm.log.LoggingEvent\" class=\"docClass\">Sm.log.LoggingEvent</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul><p>Overrides: <a href='#!/api/Sm.log.AppenderBase-method-doLog' rel='Sm.log.AppenderBase-method-doLog' class='docClass'>Sm.log.AppenderBase.doLog</a></p></div></div></div><div id='method-doPhysicalLog' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.LogViewerAppender'>Sm.log.LogViewerAppender</span><br/><a href='source/LogViewerAppender.html#Sm-log-LogViewerAppender-method-doPhysicalLog' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.LogViewerAppender-method-doPhysicalLog' class='name expandable'>doPhysicalLog</a>( <span class='pre'>logEvents</span> ) : void<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Performs outputs of an array of log events. ...</div><div class='long'><p>Performs outputs of an array of log events.</p>\n\n<p>Using an array can help with performance, as it allows to\nsend a handful of buffered logs in a single step.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>logEvents</span> : Array<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-formatLogAsText' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Sm.log.AppenderBase' rel='Sm.log.AppenderBase' class='defined-in docClass'>Sm.log.AppenderBase</a><br/><a href='source/AppenderBase.html#Sm-log-AppenderBase-method-formatLogAsText' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.AppenderBase-method-formatLogAsText' class='name expandable'>formatLogAsText</a>( <span class='pre'>logEvent</span> ) : String</div><div class='description'><div class='short'>Returns a formatted string representing the log information. ...</div><div class='long'><p>Returns a formatted string representing the log information.</p>\n\n<p>This is used in most cases for appenders that log to line-oriented\ndevices, such as the browser console.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>logEvent</span> : <a href=\"#!/api/Sm.log.LoggingEvent\" rel=\"Sm.log.LoggingEvent\" class=\"docClass\">Sm.log.LoggingEvent</a><div class='sub-desc'><p>A copy of the data to log.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>A text corresponding to the log data.</p>\n</div></li></ul></div></div></div><div id='method-getHtmlEncodedLogEventProperties' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Sm.log.AppenderBase' rel='Sm.log.AppenderBase' class='defined-in docClass'>Sm.log.AppenderBase</a><br/><a href='source/AppenderBase.html#Sm-log-AppenderBase-cfg-htmlEncodedLogEventProperties' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.AppenderBase-method-getHtmlEncodedLogEventProperties' class='name expandable'>getHtmlEncodedLogEventProperties</a>( <span class='pre'></span> ) : Array</div><div class='description'><div class='short'>Returns the value of htmlEncodedLogEventProperties. ...</div><div class='long'><p>Returns the value of <a href=\"#!/api/Sm.log.AppenderBase-cfg-htmlEncodedLogEventProperties\" rel=\"Sm.log.AppenderBase-cfg-htmlEncodedLogEventProperties\" class=\"docClass\">htmlEncodedLogEventProperties</a>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Array</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getLayout' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Sm.log.AppenderBase' rel='Sm.log.AppenderBase' class='defined-in docClass'>Sm.log.AppenderBase</a><br/><a href='source/AppenderBase.html#Sm-log-AppenderBase-method-getLayout' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.AppenderBase-method-getLayout' class='name expandable'>getLayout</a>( <span class='pre'></span> ) : <a href=\"#!/api/Sm.log.LayoutBase\" rel=\"Sm.log.LayoutBase\" class=\"docClass\">Sm.log.LayoutBase</a></div><div class='description'><div class='short'>Returns the layout for this logger. ...</div><div class='long'><p>Returns the layout for this logger.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Sm.log.LayoutBase\" rel=\"Sm.log.LayoutBase\" class=\"docClass\">Sm.log.LayoutBase</a></span><div class='sub-desc'><p>The layout for this logger.</p>\n</div></li></ul></div></div></div><div id='method-getState' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Sm.log.AppenderBase' rel='Sm.log.AppenderBase' class='defined-in docClass'>Sm.log.AppenderBase</a><br/><a href='source/AppenderBase.html#Sm-log-AppenderBase-method-getState' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.AppenderBase-method-getState' class='name expandable'>getState</a>( <span class='pre'></span> ) : String</div><div class='description'><div class='short'>Returns the appender state. ...</div><div class='long'><p>Returns the appender state.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>The appender state</p>\n</div></li></ul></div></div></div><div id='method-htmlEncodeStringValues' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Sm.log.AppenderBase' rel='Sm.log.AppenderBase' class='defined-in docClass'>Sm.log.AppenderBase</a><br/><a href='source/AppenderBase.html#Sm-log-AppenderBase-method-htmlEncodeStringValues' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.AppenderBase-method-htmlEncodeStringValues' class='name expandable'>htmlEncodeStringValues</a>( <span class='pre'>logEvent</span> ) : void<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Performs encoding of log entry properties that should be html encoded. ...</div><div class='long'><p>Performs encoding of log entry properties that should be html encoded.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>logEvent</span> : <a href=\"#!/api/Sm.log.LoggingEvent\" rel=\"Sm.log.LoggingEvent\" class=\"docClass\">Sm.log.LoggingEvent</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isBuffering' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.LogViewerAppender'>Sm.log.LogViewerAppender</span><br/><a href='source/LogViewerAppender.html#Sm-log-LogViewerAppender-method-isBuffering' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.LogViewerAppender-method-isBuffering' class='name expandable'>isBuffering</a>( <span class='pre'></span> ) : Boolean</div><div class='description'><div class='short'>Returns true if the viewer is buffering logs. ...</div><div class='long'><p>Returns true if the viewer is buffering logs.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>true if the viewer is buffering logs.</p>\n</div></li></ul></div></div></div><div id='method-isLogging' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Sm.log.AppenderBase' rel='Sm.log.AppenderBase' class='defined-in docClass'>Sm.log.AppenderBase</a><br/><a href='source/AppenderBase.html#Sm-log-AppenderBase-method-isLogging' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.AppenderBase-method-isLogging' class='name expandable'>isLogging</a>( <span class='pre'></span> ) : Boolean</div><div class='description'><div class='short'>Returns true if the appender is in the logging state. ...</div><div class='long'><p>Returns true if the appender is in the logging state.</p>\n\n<p>In this state, all logs sent to the appender are logged.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isStopped' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Sm.log.AppenderBase' rel='Sm.log.AppenderBase' class='defined-in docClass'>Sm.log.AppenderBase</a><br/><a href='source/AppenderBase.html#Sm-log-AppenderBase-method-isStopped' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.AppenderBase-method-isStopped' class='name expandable'>isStopped</a>( <span class='pre'></span> ) : Boolean</div><div class='description'><div class='short'>Returns true if the appender is stopped. ...</div><div class='long'><p>Returns true if the appender is stopped.</p>\n\n<p>An stopped appender ignores all logs sent to it.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-log' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Sm.log.AppenderBase' rel='Sm.log.AppenderBase' class='defined-in docClass'>Sm.log.AppenderBase</a><br/><a href='source/AppenderBase.html#Sm-log-AppenderBase-method-log' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.AppenderBase-method-log' class='name expandable'>log</a>( <span class='pre'>logEvent</span> ) : void<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Outputs the log to its destination. ...</div><div class='long'><p>Outputs the log to its destination.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>logEvent</span> : <a href=\"#!/api/Sm.log.LoggingEvent\" rel=\"Sm.log.LoggingEvent\" class=\"docClass\">Sm.log.LoggingEvent</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setHtmlEncodedLogEventProperties' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Sm.log.AppenderBase' rel='Sm.log.AppenderBase' class='defined-in docClass'>Sm.log.AppenderBase</a><br/><a href='source/AppenderBase.html#Sm-log-AppenderBase-cfg-htmlEncodedLogEventProperties' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.AppenderBase-method-setHtmlEncodedLogEventProperties' class='name expandable'>setHtmlEncodedLogEventProperties</a>( <span class='pre'>htmlEncodedLogEventProperties</span> )</div><div class='description'><div class='short'>Sets the value of htmlEncodedLogEventProperties. ...</div><div class='long'><p>Sets the value of <a href=\"#!/api/Sm.log.AppenderBase-cfg-htmlEncodedLogEventProperties\" rel=\"Sm.log.AppenderBase-cfg-htmlEncodedLogEventProperties\" class=\"docClass\">htmlEncodedLogEventProperties</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>htmlEncodedLogEventProperties</span> : Array<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setInitialState' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.LogViewerAppender'>Sm.log.LogViewerAppender</span><br/><a href='source/LogViewerAppender.html#Sm-log-LogViewerAppender-method-setInitialState' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.LogViewerAppender-method-setInitialState' class='name expandable'>setInitialState</a>( <span class='pre'></span> ) : void<strong class='protected signature' >protected</strong></div><div class='description'><div class='short'>Initializes the appender state to whatever is appropriate fro this\nappender. ...</div><div class='long'><p>Initializes the appender state to whatever is appropriate fro this\nappender.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul><p>Overrides: <a href='#!/api/Sm.log.AppenderBase-method-setInitialState' rel='Sm.log.AppenderBase-method-setInitialState' class='docClass'>Sm.log.AppenderBase.setInitialState</a></p></div></div></div><div id='method-setLayout' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Sm.log.AppenderBase' rel='Sm.log.AppenderBase' class='defined-in docClass'>Sm.log.AppenderBase</a><br/><a href='source/AppenderBase.html#Sm-log-AppenderBase-method-setLayout' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.AppenderBase-method-setLayout' class='name expandable'>setLayout</a>( <span class='pre'>layout</span> ) : void</div><div class='description'><div class='short'>Sets the layout for this logger. ...</div><div class='long'><p>Sets the layout for this logger.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>layout</span> : <a href=\"#!/api/Sm.log.LayoutBase\" rel=\"Sm.log.LayoutBase\" class=\"docClass\">Sm.log.LayoutBase</a><div class='sub-desc'><p>The layout.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-startBuffering' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.LogViewerAppender'>Sm.log.LogViewerAppender</span><br/><a href='source/LogViewerAppender.html#Sm-log-LogViewerAppender-method-startBuffering' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.LogViewerAppender-method-startBuffering' class='name expandable'>startBuffering</a>( <span class='pre'></span> ) : void</div><div class='description'><div class='short'>Starts buffering logs. ...</div><div class='long'><p>Starts buffering logs.</p>\n\n<p>While buffering, logs are not sent to the viewer window automatically,\nbut rather they are kept apart until we change the status to logging.\nThen, all buffered logs will be sent to the window.</p>\n\n<p>This is useful in cases where the viewer window should not be updated\nto avoid interference while debugging, or where the window simply does\nnot exist but we want to register such log nevertheless.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-startLogging' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.LogViewerAppender'>Sm.log.LogViewerAppender</span><br/><a href='source/LogViewerAppender.html#Sm-log-LogViewerAppender-method-startLogging' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.LogViewerAppender-method-startLogging' class='name expandable'>startLogging</a>( <span class='pre'></span> ) : void</div><div class='description'><div class='short'>Sets the appender in the loggins state. ...</div><div class='long'><p>Sets the appender in the loggins state.</p>\n\n<p>All logs sent to the appender from now on will be logged.\nBesides, if there were some buffered logs, they will be immediately\nsent to the log viewer window, if any.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul><p>Overrides: <a href='#!/api/Sm.log.AppenderBase-method-startLogging' rel='Sm.log.AppenderBase-method-startLogging' class='docClass'>Sm.log.AppenderBase.startLogging</a></p></div></div></div><div id='method-stopLogging' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.LogViewerAppender'>Sm.log.LogViewerAppender</span><br/><a href='source/LogViewerAppender.html#Sm-log-LogViewerAppender-method-stopLogging' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.LogViewerAppender-method-stopLogging' class='name expandable'>stopLogging</a>( <span class='pre'></span> ) : void</div><div class='description'><div class='short'>Stops the appender. ...</div><div class='long'><p>Stops the appender.</p>\n\n<p>The appender will ignore all logs sent to it while stopped.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul><p>Overrides: <a href='#!/api/Sm.log.AppenderBase-method-stopLogging' rel='Sm.log.AppenderBase-method-stopLogging' class='docClass'>Sm.log.AppenderBase.stopLogging</a></p></div></div></div><div id='method-supportsBuffering' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.LogViewerAppender'>Sm.log.LogViewerAppender</span><br/><a href='source/LogViewerAppender.html#Sm-log-LogViewerAppender-method-supportsBuffering' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.LogViewerAppender-method-supportsBuffering' class='name expandable'>supportsBuffering</a>( <span class='pre'></span> ) : Boolean</div><div class='description'><div class='short'>Returns true, as this appender supports log buffering. ...</div><div class='long'><p>Returns true, as this appender supports log buffering.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>true, as this appender supports log buffering.</p>\n</div></li></ul><p>Overrides: <a href='#!/api/Sm.log.AppenderBase-method-supportsBuffering' rel='Sm.log.AppenderBase-method-supportsBuffering' class='docClass'>Sm.log.AppenderBase.supportsBuffering</a></p></div></div></div></div></div></div></div>"});