Ext.data.JsonP.Sm_log_Logger({"tagname":"class","name":"Sm.log.Logger","extends":"Ext.Base","mixins":[],"alternateClassNames":[],"aliases":{},"singleton":false,"requires":[],"uses":["Ext.Array","Sm.log.ExtLogAppender","Sm.log.Level","Sm.log.LoggingEvent","Sm.log.util.Assert"],"enum":null,"override":null,"inheritable":null,"inheritdoc":null,"meta":{},"private":null,"id":"class-Sm.log.Logger","code_type":"ext_define","members":{"cfg":[{"name":"additivity","tagname":"cfg","owner":"Sm.log.Logger","meta":{},"id":"cfg-additivity"},{"name":"appenders","tagname":"cfg","owner":"Sm.log.Logger","meta":{},"id":"cfg-appenders"},{"name":"category","tagname":"cfg","owner":"Sm.log.Logger","meta":{"readonly":true,"required":true},"id":"cfg-category"},{"name":"enabled","tagname":"cfg","owner":"Sm.log.Logger","meta":{},"id":"cfg-enabled"},{"name":"level","tagname":"cfg","owner":"Sm.log.Logger","meta":{},"id":"cfg-level"}],"property":[],"method":[{"name":"constructor","tagname":"method","owner":"Sm.log.Logger","meta":{"private":true},"id":"method-constructor"},{"name":"addAppender","tagname":"method","owner":"Sm.log.Logger","meta":{},"id":"method-addAppender"},{"name":"debug","tagname":"method","owner":"Sm.log.Logger","meta":{},"id":"method-debug"},{"name":"doLog","tagname":"method","owner":"Sm.log.Logger","meta":{"private":true},"id":"method-doLog"},{"name":"error","tagname":"method","owner":"Sm.log.Logger","meta":{},"id":"method-error"},{"name":"fatal","tagname":"method","owner":"Sm.log.Logger","meta":{},"id":"method-fatal"},{"name":"getAdditivity","tagname":"method","owner":"Sm.log.Logger","meta":{},"id":"method-getAdditivity"},{"name":"getAppenders","tagname":"method","owner":"Sm.log.Logger","meta":{},"id":"method-getAppenders"},{"name":"getCategory","tagname":"method","owner":"Sm.log.Logger","meta":{"readonly":true},"id":"method-getCategory"},{"name":"getEffectiveAppenders","tagname":"method","owner":"Sm.log.Logger","meta":{},"id":"method-getEffectiveAppenders"},{"name":"getEffectiveEnabled","tagname":"method","owner":"Sm.log.Logger","meta":{},"id":"method-getEffectiveEnabled"},{"name":"getEffectiveLevel","tagname":"method","owner":"Sm.log.Logger","meta":{},"id":"method-getEffectiveLevel"},{"name":"getEnabled","tagname":"method","owner":"Sm.log.Logger","meta":{},"id":"method-getEnabled"},{"name":"getLevel","tagname":"method","owner":"Sm.log.Logger","meta":{},"id":"method-getLevel"},{"name":"info","tagname":"method","owner":"Sm.log.Logger","meta":{},"id":"method-info"},{"name":"isDebugEnabled","tagname":"method","owner":"Sm.log.Logger","meta":{},"id":"method-isDebugEnabled"},{"name":"isErrorEnabled","tagname":"method","owner":"Sm.log.Logger","meta":{},"id":"method-isErrorEnabled"},{"name":"isFatalEnabled","tagname":"method","owner":"Sm.log.Logger","meta":{},"id":"method-isFatalEnabled"},{"name":"isInfoEnabled","tagname":"method","owner":"Sm.log.Logger","meta":{},"id":"method-isInfoEnabled"},{"name":"isLevelEnabled","tagname":"method","owner":"Sm.log.Logger","meta":{},"id":"method-isLevelEnabled"},{"name":"isTraceEnabled","tagname":"method","owner":"Sm.log.Logger","meta":{},"id":"method-isTraceEnabled"},{"name":"isWarnEnabled","tagname":"method","owner":"Sm.log.Logger","meta":{},"id":"method-isWarnEnabled"},{"name":"log","tagname":"method","owner":"Sm.log.Logger","meta":{},"id":"method-log"},{"name":"removeAllAppenders","tagname":"method","owner":"Sm.log.Logger","meta":{},"id":"method-removeAllAppenders"},{"name":"removeAppender","tagname":"method","owner":"Sm.log.Logger","meta":{},"id":"method-removeAppender"},{"name":"setAdditivity","tagname":"method","owner":"Sm.log.Logger","meta":{},"id":"method-setAdditivity"},{"name":"setAppenders","tagname":"method","owner":"Sm.log.Logger","meta":{"private":true},"id":"method-setAppenders"},{"name":"setCategory","tagname":"method","owner":"Sm.log.Logger","meta":{"private":true},"id":"method-setCategory"},{"name":"setEnabled","tagname":"method","owner":"Sm.log.Logger","meta":{},"id":"method-setEnabled"},{"name":"setLevel","tagname":"method","owner":"Sm.log.Logger","meta":{},"id":"method-setLevel"},{"name":"trace","tagname":"method","owner":"Sm.log.Logger","meta":{},"id":"method-trace"},{"name":"warn","tagname":"method","owner":"Sm.log.Logger","meta":{},"id":"method-warn"}],"event":[],"css_var":[],"css_mixin":[]},"linenr":29,"files":[{"filename":"Logger.js","href":"Logger.html#Sm-log-Logger"}],"html_meta":{},"statics":{"cfg":[],"property":[{"name":"enabled","tagname":"property","owner":"Sm.log.Logger","meta":{"static":true},"id":"static-property-enabled"}],"method":[{"name":"getLogger","tagname":"method","owner":"Sm.log.Logger","meta":{"static":true},"id":"static-method-getLogger"},{"name":"getRoot","tagname":"method","owner":"Sm.log.Logger","meta":{"static":true},"id":"static-method-getRoot"}],"event":[],"css_var":[],"css_mixin":[]},"component":false,"superclasses":["Ext.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'>Ext.Base<div class='subclass '><strong>Sm.log.Logger</strong></div></div><h4>Uses</h4><div class='dependency'>Ext.Array</div><div class='dependency'><a href='#!/api/Sm.log.ExtLogAppender' rel='Sm.log.ExtLogAppender' class='docClass'>Sm.log.ExtLogAppender</a></div><div class='dependency'><a href='#!/api/Sm.log.Level' rel='Sm.log.Level' class='docClass'>Sm.log.Level</a></div><div class='dependency'><a href='#!/api/Sm.log.LoggingEvent' rel='Sm.log.LoggingEvent' class='docClass'>Sm.log.LoggingEvent</a></div><div class='dependency'><a href='#!/api/Sm.log.util.Assert' rel='Sm.log.util.Assert' class='docClass'>Sm.log.util.Assert</a></div><h4>Files</h4><div class='dependency'><a href='source/Logger.html#Sm-log-Logger' target='_blank'>Logger.js</a></div></pre><div class='doc-contents'><p>A logger performs logging using the error, info, debug and other\nfunctions.</p>\n\n<p>Logged data is handled by the logger appenders\n(see <a href=\"#!/api/Sm.log.AppenderBase\" rel=\"Sm.log.AppenderBase\" class=\"docClass\">Sm.log.AppenderBase</a>),\nor its parent's appenders,\nthat send it somewhere: the console, a window, etc.</p>\n\n<p>An appender will need to format data, and it will use its\nlayout (see <a href=\"#!/api/Sm.log.LayoutBase\" rel=\"Sm.log.LayoutBase\" class=\"docClass\">Sm.log.LayoutBase</a>) for that purpose.</p>\n</div><div class='members'><div class='members-section'><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Required Config options</h3><div id='cfg-category' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Logger'>Sm.log.Logger</span><br/><a href='source/Logger.html#Sm-log-Logger-cfg-category' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Logger-cfg-category' class='name expandable'>category</a><span> : String</span><strong class='readonly signature' >readonly</strong><strong class='required signature' >required</strong></div><div class='description'><div class='short'>The logger's category. ...</div><div class='long'><p>The logger's category.</p>\n\n<p>This can be considered the logger name, too.</p>\n<p>Defaults to: <code>assigned in constructor</code></p></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Optional Config options</h3><div id='cfg-additivity' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Logger'>Sm.log.Logger</span><br/><a href='source/Logger.html#Sm-log-Logger-cfg-additivity' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Logger-cfg-additivity' class='name expandable'>additivity</a><span> : Boolean</span></div><div class='description'><div class='short'>If true, this logger will log to its appenders plus its parent\nappenders. ...</div><div class='long'><p>If true, this logger will log to its appenders plus its parent\nappenders.</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-appenders' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Logger'>Sm.log.Logger</span><br/><a href='source/Logger.html#Sm-log-Logger-cfg-appenders' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Logger-cfg-appenders' class='name expandable'>appenders</a><span> : Array</span></div><div class='description'><div class='short'>The appenders to which this logger outputs directly. ...</div><div class='long'><p>The appenders to which this logger outputs directly.</p>\n\n<p>See <a href=\"#!/api/Sm.log.Logger-method-getEffectiveAppenders\" rel=\"Sm.log.Logger-method-getEffectiveAppenders\" class=\"docClass\">getEffectiveAppenders</a> for additional information.</p>\n<p>Defaults to: <code>[]</code></p></div></div></div><div id='cfg-enabled' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Logger'>Sm.log.Logger</span><br/><a href='source/Logger.html#Sm-log-Logger-cfg-enabled' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Logger-cfg-enabled' class='name expandable'>enabled</a><span> : Boolean</span></div><div class='description'><div class='short'>If set to false, disables all logging. ...</div><div class='long'><p>If set to false, disables all logging.</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-level' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Logger'>Sm.log.Logger</span><br/><a href='source/Logger.html#Sm-log-Logger-cfg-level' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Logger-cfg-level' class='name expandable'>level</a><span> : <a href=\"#!/api/Sm.log.Level\" rel=\"Sm.log.Level\" class=\"docClass\">Sm.log.Level</a></span></div><div class='description'><div class='short'>The level for this logger, or null. ...</div><div class='long'><p>The level for this logger, or null.</p>\n\n<p>Logs with a level lesser than this level will be ignored.\nSee <a href=\"#!/api/Sm.log.Logger-method-getEffectiveLevel\" rel=\"Sm.log.Logger-method-getEffectiveLevel\" class=\"docClass\">getEffectiveLevel</a> for additional information.</p>\n</div></div></div></div></div><div class='members-section'><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static Properties</h3><div id='static-property-enabled' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Logger'>Sm.log.Logger</span><br/><a href='source/Logger.html#Sm-log-Logger-static-property-enabled' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Logger-static-property-enabled' class='name expandable'>enabled</a><span> : Boolean</span><strong class='static signature' >static</strong></div><div class='description'><div class='short'>If false, no logger will output to its appenders, independently\nof the logger enabled state. ...</div><div class='long'><p>If false, no logger will output to its appenders, independently\nof the logger enabled state.</p>\n<p>Defaults to: <code>true</code></p></div></div></div></div></div><div class='members-section'><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance Methods</h3><div id='method-constructor' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Logger'>Sm.log.Logger</span><br/><a href='source/Logger.html#Sm-log-Logger-method-constructor' target='_blank' class='view-source'>view source</a></div><strong class='new-keyword'>new</strong><a href='#!/api/Sm.log.Logger-method-constructor' class='name expandable'>Sm.log.Logger</a>( <span class='pre'>cfg</span> ) : <a href=\"#!/api/Sm.log.Logger\" rel=\"Sm.log.Logger\" class=\"docClass\">Sm.log.Logger</a><strong class='private signature' >private</strong></div><div class='description'><div class='short'>Do not use this: use getLogger instead. ...</div><div class='long'><p>Do not use this: use <a href=\"#!/api/Sm.log.Logger-static-method-getLogger\" rel=\"Sm.log.Logger-static-method-getLogger\" class=\"docClass\">getLogger</a> instead.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cfg</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Sm.log.Logger\" rel=\"Sm.log.Logger\" class=\"docClass\">Sm.log.Logger</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-addAppender' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Logger'>Sm.log.Logger</span><br/><a href='source/Logger.html#Sm-log-Logger-method-addAppender' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Logger-method-addAppender' class='name expandable'>addAppender</a>( <span class='pre'>appender</span> ) : void</div><div class='description'><div class='short'>Adds a new appender to this logger. ...</div><div class='long'><p>Adds a new appender to this logger.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>appender</span> : <a href=\"#!/api/Sm.log.AppenderBase\" rel=\"Sm.log.AppenderBase\" class=\"docClass\">Sm.log.AppenderBase</a><div class='sub-desc'><p>The appender to add to this logger.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-debug' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Logger'>Sm.log.Logger</span><br/><a href='source/Logger.html#Sm-log-Logger-method-debug' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Logger-method-debug' class='name expandable'>debug</a>( <span class='pre'>messageArgs</span> ) : void</div><div class='description'><div class='short'>Logs data with a DEBUG level. ...</div><div class='long'><p>Logs data with a DEBUG level.</p>\n\n<p>Arguments for this function are variable, and it is possible to\nlog a simple message, perform advanced formatting or even log objects.\nCheck this\n<a href=\"http://http://code.google.com/p/log4js-ext/wiki/LoggingFormatting\">link</a>\nfor examples on how to use this function.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>messageArgs</span> : Object<div class='sub-desc'><p>The arguments for the logging operation.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-doLog' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Logger'>Sm.log.Logger</span><br/><a href='source/Logger.html#Sm-log-Logger-method-doLog' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Logger-method-doLog' class='name expandable'>doLog</a>( <span class='pre'>level, args</span> ) : void<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Performs the real log. ...</div><div class='long'><p>Performs the real log.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>level</span> : <a href=\"#!/api/Sm.log.Level\" rel=\"Sm.log.Level\" class=\"docClass\">Sm.log.Level</a><div class='sub-desc'><p>The log level.</p>\n</div></li><li><span class='pre'>args</span> : Object<div class='sub-desc'><p>The log arguments.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-error' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Logger'>Sm.log.Logger</span><br/><a href='source/Logger.html#Sm-log-Logger-method-error' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Logger-method-error' class='name expandable'>error</a>( <span class='pre'>messageArgs</span> ) : void</div><div class='description'><div class='short'>Logs data with an ERROR level. ...</div><div class='long'><p>Logs data with an ERROR level.</p>\n\n<p>Arguments for this function are variable, and it is possible to\nlog a simple message, perform advanced formatting or even log objects.\nCheck this\n<a href=\"http://http://code.google.com/p/log4js-ext/wiki/LoggingFormatting\">link</a>\nfor examples on how to use this function.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>messageArgs</span> : Object<div class='sub-desc'><p>The arguments for the logging operation.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-fatal' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Logger'>Sm.log.Logger</span><br/><a href='source/Logger.html#Sm-log-Logger-method-fatal' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Logger-method-fatal' class='name expandable'>fatal</a>( <span class='pre'>messageArgs</span> ) : void</div><div class='description'><div class='short'>Logs data with a FATAL level. ...</div><div class='long'><p>Logs data with a FATAL level.</p>\n\n<p>Arguments for this function are variable, and it is possible to\nlog a simple message, perform advanced formatting or even log objects.\nCheck this\n<a href=\"http://http://code.google.com/p/log4js-ext/wiki/LoggingFormatting\">link</a>\nfor examples on how to use this function.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>messageArgs</span> : Object<div class='sub-desc'><p>The arguments for the logging operation.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getAdditivity' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Logger'>Sm.log.Logger</span><br/><a href='source/Logger.html#Sm-log-Logger-cfg-additivity' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Logger-method-getAdditivity' class='name expandable'>getAdditivity</a>( <span class='pre'></span> ) : Boolean</div><div class='description'><div class='short'>Returns the value of additivity. ...</div><div class='long'><p>Returns the value of <a href=\"#!/api/Sm.log.Logger-cfg-additivity\" rel=\"Sm.log.Logger-cfg-additivity\" class=\"docClass\">additivity</a>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getAppenders' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Logger'>Sm.log.Logger</span><br/><a href='source/Logger.html#Sm-log-Logger-cfg-appenders' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Logger-method-getAppenders' class='name expandable'>getAppenders</a>( <span class='pre'></span> ) : Array</div><div class='description'><div class='short'>Returns the value of appenders. ...</div><div class='long'><p>Returns the value of <a href=\"#!/api/Sm.log.Logger-cfg-appenders\" rel=\"Sm.log.Logger-cfg-appenders\" class=\"docClass\">appenders</a>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Array</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getCategory' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Logger'>Sm.log.Logger</span><br/><a href='source/Logger.html#Sm-log-Logger-cfg-category' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Logger-method-getCategory' class='name expandable'>getCategory</a>( <span class='pre'></span> ) : String<strong class='readonly signature' >readonly</strong></div><div class='description'><div class='short'>Returns the value of category. ...</div><div class='long'><p>Returns the value of <a href=\"#!/api/Sm.log.Logger-cfg-category\" rel=\"Sm.log.Logger-cfg-category\" class=\"docClass\">category</a>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getEffectiveAppenders' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Logger'>Sm.log.Logger</span><br/><a href='source/Logger.html#Sm-log-Logger-method-getEffectiveAppenders' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Logger-method-getEffectiveAppenders' class='name expandable'>getEffectiveAppenders</a>( <span class='pre'></span> ) : Array</div><div class='description'><div class='short'>Returns all appenders to which this logger should log. ...</div><div class='long'><p>Returns all appenders to which this logger should log.</p>\n\n<p> This includes its own appenders, and, if additivity is true,\n its parent logger appenders -which in turn might contribute\n its own parent appenders if its additivity is set to true.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Array</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getEffectiveEnabled' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Logger'>Sm.log.Logger</span><br/><a href='source/Logger.html#Sm-log-Logger-method-getEffectiveEnabled' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Logger-method-getEffectiveEnabled' class='name expandable'>getEffectiveEnabled</a>( <span class='pre'></span> ) : Boolean</div><div class='description'><div class='short'>Returns the effective enabled state, taking into account\nboth this logger enabled property and the static enabled pro...</div><div class='long'><p>Returns the effective enabled state, taking into account\nboth this logger enabled property and the static enabled property.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getEffectiveLevel' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Logger'>Sm.log.Logger</span><br/><a href='source/Logger.html#Sm-log-Logger-method-getEffectiveLevel' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Logger-method-getEffectiveLevel' class='name expandable'>getEffectiveLevel</a>( <span class='pre'></span> ) : <a href=\"#!/api/Sm.log.Level\" rel=\"Sm.log.Level\" class=\"docClass\">Sm.log.Level</a></div><div class='description'><div class='short'>Returns the effective level for this logger. ...</div><div class='long'><p>Returns the effective level for this logger.</p>\n\n<p>If a level has been set by calling <a href=\"#!/api/Sm.log.Logger-method-setLevel\" rel=\"Sm.log.Logger-method-setLevel\" class=\"docClass\">setLevel</a>, then that will\nbe the effective level. Else, the parent effective level will be used.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Sm.log.Level\" rel=\"Sm.log.Level\" class=\"docClass\">Sm.log.Level</a></span><div class='sub-desc'><p>The effective level.</p>\n</div></li></ul></div></div></div><div id='method-getEnabled' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Logger'>Sm.log.Logger</span><br/><a href='source/Logger.html#Sm-log-Logger-cfg-enabled' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Logger-method-getEnabled' class='name expandable'>getEnabled</a>( <span class='pre'></span> ) : Boolean</div><div class='description'><div class='short'>Returns the value of enabled. ...</div><div class='long'><p>Returns the value of <a href=\"#!/api/Sm.log.Logger-cfg-enabled\" rel=\"Sm.log.Logger-cfg-enabled\" class=\"docClass\">enabled</a>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getLevel' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Logger'>Sm.log.Logger</span><br/><a href='source/Logger.html#Sm-log-Logger-cfg-level' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Logger-method-getLevel' class='name expandable'>getLevel</a>( <span class='pre'></span> ) : <a href=\"#!/api/Sm.log.Level\" rel=\"Sm.log.Level\" class=\"docClass\">Sm.log.Level</a></div><div class='description'><div class='short'>Returns the value of level. ...</div><div class='long'><p>Returns the value of <a href=\"#!/api/Sm.log.Logger-cfg-level\" rel=\"Sm.log.Logger-cfg-level\" class=\"docClass\">level</a>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Sm.log.Level\" rel=\"Sm.log.Level\" class=\"docClass\">Sm.log.Level</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-info' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Logger'>Sm.log.Logger</span><br/><a href='source/Logger.html#Sm-log-Logger-method-info' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Logger-method-info' class='name expandable'>info</a>( <span class='pre'>messageArgs</span> ) : void</div><div class='description'><div class='short'>Logs data with an INFO level. ...</div><div class='long'><p>Logs data with an INFO level.</p>\n\n<p>Arguments for this function are variable, and it is possible to\nlog a simple message, perform advanced formatting or even log objects.\nCheck this\n<a href=\"http://http://code.google.com/p/log4js-ext/wiki/LoggingFormatting\">link</a>\nfor examples on how to use this function.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>messageArgs</span> : Object<div class='sub-desc'><p>The arguments for the logging operation.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isDebugEnabled' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Logger'>Sm.log.Logger</span><br/><a href='source/Logger.html#Sm-log-Logger-method-isDebugEnabled' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Logger-method-isDebugEnabled' class='name expandable'>isDebugEnabled</a>( <span class='pre'></span> ) : Boolean</div><div class='description'><div class='short'>Returns true if this logger will perform logs with the DEBUG level. ...</div><div class='long'><p>Returns true if this logger will perform logs with the DEBUG level.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>true if this logger will perform logs with the DEBUG level.</p>\n</div></li></ul></div></div></div><div id='method-isErrorEnabled' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Logger'>Sm.log.Logger</span><br/><a href='source/Logger.html#Sm-log-Logger-method-isErrorEnabled' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Logger-method-isErrorEnabled' class='name expandable'>isErrorEnabled</a>( <span class='pre'></span> ) : Boolean</div><div class='description'><div class='short'>Returns true if this logger will perform logs with the ERROR level. ...</div><div class='long'><p>Returns true if this logger will perform logs with the ERROR level.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>true if this logger will perform logs with the ERROR level.</p>\n</div></li></ul></div></div></div><div id='method-isFatalEnabled' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Logger'>Sm.log.Logger</span><br/><a href='source/Logger.html#Sm-log-Logger-method-isFatalEnabled' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Logger-method-isFatalEnabled' class='name expandable'>isFatalEnabled</a>( <span class='pre'></span> ) : Boolean</div><div class='description'><div class='short'>Returns true if this logger will perform logs with the FATAL level. ...</div><div class='long'><p>Returns true if this logger will perform logs with the FATAL level.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>true if this logger will perform logs with the FATAL level.</p>\n</div></li></ul></div></div></div><div id='method-isInfoEnabled' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Logger'>Sm.log.Logger</span><br/><a href='source/Logger.html#Sm-log-Logger-method-isInfoEnabled' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Logger-method-isInfoEnabled' class='name expandable'>isInfoEnabled</a>( <span class='pre'></span> ) : Boolean</div><div class='description'><div class='short'>Returns true if this logger will perform logs with the INFO level. ...</div><div class='long'><p>Returns true if this logger will perform logs with the INFO level.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>true if this logger will perform logs with the INFO level.</p>\n</div></li></ul></div></div></div><div id='method-isLevelEnabled' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Logger'>Sm.log.Logger</span><br/><a href='source/Logger.html#Sm-log-Logger-method-isLevelEnabled' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Logger-method-isLevelEnabled' class='name expandable'>isLevelEnabled</a>( <span class='pre'>level</span> ) : Boolean</div><div class='description'><div class='short'>Returns true if this logger will perform logs with the specified level. ...</div><div class='long'><p>Returns true if this logger will perform logs with the specified level.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>level</span> : <a href=\"#!/api/Sm.log.Level\" rel=\"Sm.log.Level\" class=\"docClass\">Sm.log.Level</a><div class='sub-desc'><p>The log level.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>true if this logger will perform logs with the specified level.</p>\n</div></li></ul></div></div></div><div id='method-isTraceEnabled' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Logger'>Sm.log.Logger</span><br/><a href='source/Logger.html#Sm-log-Logger-method-isTraceEnabled' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Logger-method-isTraceEnabled' class='name expandable'>isTraceEnabled</a>( <span class='pre'></span> ) : Boolean</div><div class='description'><div class='short'>Returns true if this logger will perform logs with the TRACE level. ...</div><div class='long'><p>Returns true if this logger will perform logs with the TRACE level.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>true if this logger will perform logs with the TRACE level.</p>\n</div></li></ul></div></div></div><div id='method-isWarnEnabled' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Logger'>Sm.log.Logger</span><br/><a href='source/Logger.html#Sm-log-Logger-method-isWarnEnabled' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Logger-method-isWarnEnabled' class='name expandable'>isWarnEnabled</a>( <span class='pre'></span> ) : Boolean</div><div class='description'><div class='short'>Returns true if this logger will perform logs with the WARN level. ...</div><div class='long'><p>Returns true if this logger will perform logs with the WARN level.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>true if this logger will perform logs with the WARN level.</p>\n</div></li></ul></div></div></div><div id='method-log' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Logger'>Sm.log.Logger</span><br/><a href='source/Logger.html#Sm-log-Logger-method-log' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Logger-method-log' class='name expandable'>log</a>( <span class='pre'>level, messageArgs</span> ) : void</div><div class='description'><div class='short'>Logs data with the specified level. ...</div><div class='long'><p>Logs data with the specified level.</p>\n\n<p>Arguments for this function are variable, and it is possible to\nlog a simple message, perform advanced formatting or even log objects.\nCheck this\n<a href=\"http://http://code.google.com/p/log4js-ext/wiki/LoggingFormatting\">link</a>\nfor examples on how to use this function.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>level</span> : Object<div class='sub-desc'><p>The log level.</p>\n</div></li><li><span class='pre'>messageArgs</span> : Object<div class='sub-desc'><p>The arguments for the logging operation.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-removeAllAppenders' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Logger'>Sm.log.Logger</span><br/><a href='source/Logger.html#Sm-log-Logger-method-removeAllAppenders' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Logger-method-removeAllAppenders' class='name expandable'>removeAllAppenders</a>( <span class='pre'></span> ) : void</div><div class='description'><div class='short'>Removes all appenders from this logger ...</div><div class='long'><p>Removes all appenders from this logger</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-removeAppender' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Logger'>Sm.log.Logger</span><br/><a href='source/Logger.html#Sm-log-Logger-method-removeAppender' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Logger-method-removeAppender' class='name expandable'>removeAppender</a>( <span class='pre'>appender</span> ) : void</div><div class='description'><div class='short'>Removes an appender from this logger. ...</div><div class='long'><p>Removes an appender from this logger.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>appender</span> : <a href=\"#!/api/Sm.log.AppenderBase\" rel=\"Sm.log.AppenderBase\" class=\"docClass\">Sm.log.AppenderBase</a><div class='sub-desc'><p>The appender to remove.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setAdditivity' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Logger'>Sm.log.Logger</span><br/><a href='source/Logger.html#Sm-log-Logger-cfg-additivity' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Logger-method-setAdditivity' class='name expandable'>setAdditivity</a>( <span class='pre'>additivity</span> )</div><div class='description'><div class='short'>Sets the value of additivity. ...</div><div class='long'><p>Sets the value of <a href=\"#!/api/Sm.log.Logger-cfg-additivity\" rel=\"Sm.log.Logger-cfg-additivity\" class=\"docClass\">additivity</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>additivity</span> : Boolean<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setAppenders' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Logger'>Sm.log.Logger</span><br/><a href='source/Logger.html#Sm-log-Logger-method-setAppenders' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Logger-method-setAppenders' class='name expandable'>setAppenders</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-setCategory' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Logger'>Sm.log.Logger</span><br/><a href='source/Logger.html#Sm-log-Logger-method-setCategory' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Logger-method-setCategory' class='name expandable'>setCategory</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-setEnabled' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Logger'>Sm.log.Logger</span><br/><a href='source/Logger.html#Sm-log-Logger-cfg-enabled' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Logger-method-setEnabled' class='name expandable'>setEnabled</a>( <span class='pre'>enabled</span> )</div><div class='description'><div class='short'>Sets the value of enabled. ...</div><div class='long'><p>Sets the value of <a href=\"#!/api/Sm.log.Logger-cfg-enabled\" rel=\"Sm.log.Logger-cfg-enabled\" class=\"docClass\">enabled</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>enabled</span> : Boolean<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setLevel' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Logger'>Sm.log.Logger</span><br/><a href='source/Logger.html#Sm-log-Logger-cfg-level' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Logger-method-setLevel' class='name expandable'>setLevel</a>( <span class='pre'>level</span> )</div><div class='description'><div class='short'>Sets the value of level. ...</div><div class='long'><p>Sets the value of <a href=\"#!/api/Sm.log.Logger-cfg-level\" rel=\"Sm.log.Logger-cfg-level\" class=\"docClass\">level</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>level</span> : <a href=\"#!/api/Sm.log.Level\" rel=\"Sm.log.Level\" class=\"docClass\">Sm.log.Level</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-trace' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Logger'>Sm.log.Logger</span><br/><a href='source/Logger.html#Sm-log-Logger-method-trace' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Logger-method-trace' class='name expandable'>trace</a>( <span class='pre'>messageArgs</span> ) : void</div><div class='description'><div class='short'>Logs data with a TRACE level. ...</div><div class='long'><p>Logs data with a TRACE level.</p>\n\n<p>Arguments for this function are variable, and it is possible to\nlog a simple message, perform advanced formatting or even log objects.\nCheck this\n<a href=\"http://http://code.google.com/p/log4js-ext/wiki/LoggingFormatting\">link</a>\nfor examples on how to use this function.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>messageArgs</span> : Object<div class='sub-desc'><p>The arguments for the logging operation.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-warn' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Logger'>Sm.log.Logger</span><br/><a href='source/Logger.html#Sm-log-Logger-method-warn' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Logger-method-warn' class='name expandable'>warn</a>( <span class='pre'>messageArgs</span> ) : void</div><div class='description'><div class='short'>Logs data with a WARN level. ...</div><div class='long'><p>Logs data with a WARN level.</p>\n\n<p>Arguments for this function are variable, and it is possible to\nlog a simple message, perform advanced formatting or even log objects.\nCheck this\n<a href=\"http://http://code.google.com/p/log4js-ext/wiki/LoggingFormatting\">link</a>\nfor examples on how to use this function.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>messageArgs</span> : Object<div class='sub-desc'><p>The arguments for the logging operation.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static Methods</h3><div id='static-method-getLogger' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Logger'>Sm.log.Logger</span><br/><a href='source/Logger.html#Sm-log-Logger-static-method-getLogger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Logger-static-method-getLogger' class='name expandable'>getLogger</a>( <span class='pre'>category</span> ) : <a href=\"#!/api/Sm.log.Logger\" rel=\"Sm.log.Logger\" class=\"docClass\">Sm.log.Logger</a><strong class='static signature' >static</strong></div><div class='description'><div class='short'>Returns a logger for the specified category. ...</div><div class='long'><p>Returns a logger for the specified category.</p>\n\n<p>If there is no such logger, it is created. You should never\ninstantiate loggers with the logger constructor, but rather you\nshould use this function for that purpose.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>category</span> : String<div class='sub-desc'><p>The category for which to get the logger.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Sm.log.Logger\" rel=\"Sm.log.Logger\" class=\"docClass\">Sm.log.Logger</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='static-method-getRoot' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Sm.log.Logger'>Sm.log.Logger</span><br/><a href='source/Logger.html#Sm-log-Logger-static-method-getRoot' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Sm.log.Logger-static-method-getRoot' class='name expandable'>getRoot</a>( <span class='pre'></span> ) : <a href=\"#!/api/Sm.log.Logger\" rel=\"Sm.log.Logger\" class=\"docClass\">Sm.log.Logger</a><strong class='static signature' >static</strong></div><div class='description'><div class='short'>Returns the root logger, the logger that is the parent of all\nother loggers in the application. ...</div><div class='long'><p>Returns the root logger, the logger that is the parent of all\nother loggers in the application.</p>\n\n<p>By default, the root logger uses the <a href=\"#!/api/Sm.log.ExtLogAppender\" rel=\"Sm.log.ExtLogAppender\" class=\"docClass\">Sm.log.ExtLogAppender</a>\nto output logs.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Sm.log.Logger\" rel=\"Sm.log.Logger\" class=\"docClass\">Sm.log.Logger</a></span><div class='sub-desc'><p>The root logger.</p>\n</div></li></ul></div></div></div></div></div></div></div>"});