(function(){Ext.define("Sm.log.AppenderBase",{uses:["Sm.log.util.Debug","Sm.log.util.Assert","Sm.log.TemplateLayout"],statics:{STOPPED:"Stopped",BUFFERING:"Buffering",LOGGING:"Logging"},config:{htmlEncodedLogEventProperties:[]},doLog:function(a){Sm.log.util.Debug.abort("You must implement this method in derived classes")},htmlEncodeStringValues:function(b){var a=this,c;Ext.Object.each(b,function(d,e){if(Ext.isString(e)){if(Ext.Array.indexOf(a.getHtmlEncodedLogEventProperties(),d)>=0){c=Ext.util.Format.htmlEncode(e);b[d]=c}}})},log:function(a){if(!this.isStopped()){this.getLayout().appendFormattedData(a);if(this.getHtmlEncodedLogEventProperties().length>0){this.htmlEncodeStringValues(a)}this.doLog(a)}},getLayout:function(){if(!this.layout){this.layout=Sm.log.TemplateLayout.getDefaultLayout()}return this.layout},setLayout:function(a){this.layout=a},constructor:function(a){this.initConfig(a);this.setInitialState()},setInitialState:function(){this.startLogging()},getState:function(){return this.state},isStopped:function(){return this.state===Sm.log.AppenderBase.STOPPED},stopLogging:function(){this.state=Sm.log.AppenderBase.STOPPED},isLogging:function(){return this.state===Sm.log.AppenderBase.LOGGING},startLogging:function(){this.state=Sm.log.AppenderBase.LOGGING},supportsBuffering:function(){return false},formatLogAsText:function(a){return this.getLayout().formatLogAsText(a)}})}());(function(){Ext.define("Sm.log.ExtLogAppender",{extend:"Sm.log.AppenderBase",singleton:true,uses:["Sm.log.util.Assert","Sm.log.Level"],doLog:function(f){var e=null,d,b,c=f.loggedObject,a;d=this.formatLogAsText(f);a=[d];if(c){a.push(c)}Sm.log.util.Assert.assert(f);switch(f.level){case Sm.log.Level.NONE.getName():case Sm.log.Level.ALL.getName():Sm.log.util.Debug.abort("We should never arrive here");break;case Sm.log.Level.FATAL.getName():case Sm.log.Level.ERROR.getName():if(window.console&&console.error&&Ext.isFunction(console.error)){console.error.apply(console,a);return}e="error";break;case Sm.log.Level.WARN.getName():if(window.console&&console.warn&&Ext.isFunction(console.warn)){console.warn.apply(console,a);return}e="warn";break;case Sm.log.Level.INFO.getName():if(window.console&&console.info&&Ext.isFunction(console.info)){console.info.apply(console,a);return}e="info";break;default:if(window.console&&console.log&&Ext.isFunction(console.log)){console.log.apply(console,a);return}e="log";break}b={msg:d,level:e};if(c){b.dump=c}Ext.log(b)}})}());(function(){Ext.define("Sm.log.LayoutBase",{uses:["Ext.Date","Ext.JSON","Sm.log.util.Debug","Sm.log.util.Assert"],config:{timeFormat:"Y-m-d H:i:s.u",highlightLoggedObject:true,multilineLoggedObject:false,exportFormattedLoggedObject:true,formatIndentLoggedObject:3},appendFormattedData:function(a){var b;a.formattedTime=this.formatTime(a);a.formattedMessage=this.formatMessage(a);if(this.getExportFormattedLoggedObject()){if(a.hasLoggedObject){a.formattedLoggedObject=this.formatLoggedObject(a)}else{a.formattedLoggedObject=""}}},formatLogAsText:function(a){Sm.log.util.Debug.abort("You must use an appender that knows how to format a log event as a text")},formatTime:function(a){var b=a.time;if(this.getTimeFormat()){return Ext.Date.format(b,this.getTimeFormat())}return b.toString()},formatMessage:function(g){var f=g.message,e=g.formatParams,a,b,d,c;if(e){Sm.log.util.Assert.assert(e.length>0);a=Ext.isObject(e[0]);if(!a){f=this.simpleFormat(f,e)}else{f=this.multiFormat(f,e)}}else{f=f.toString()}return f},formatLoggedObject:function(a){if(a.hasOwnProperty("loggedObject")){return this.jsonLikeFormat(a.loggedObject,this.getHighlightLoggedObject(),this.getMultilineLoggedObject())}return""},jsonCls:{key:"sm-log-json-key",string:"sm-log-json-string",number:"sm-log-json-number",bool:"sm-log-json-boolean",nul:"sm-log-json-null"},jsonSyntaxHighlight:function(b,a){var c;if(b===undefined){return'<span class="'+this.jsonCls.nul+'">undefined</span>'}c=/("(\\u[a-zA-Z0-9]{4}|\\[^u]|[^\\"])*"(\s*:)?|\b(true|false|null)\b|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?)/g;return b.replace(c,function(g){var f=a.number,h=false,e=false,d;if(/^"/.test(g)){if(/:$/.test(g)){f=a.key;h=true}else{f=a.string;e=true}}else{if(/true|false/.test(g)){f=a.bool}else{if(/null/.test(g)){f=a.nul}}}if(h){g=g.slice(1,g.length-2)+": "}if(e){g="'"+g.slice(1,g.length-1)+"'"}d='<span class="'+f+'">'+g+"</span>";return d})},jsonLikeFormat:function(f,c,b,a){var e;try{e=JSON.stringify(f,undefined,a||this.getFormatIndentLoggedObject())}catch(d){e=Ext.JSON.encode(f)}if(c){if(e!==undefined){e=e.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;");if(b){e=e.replace(/ /g,"&nbsp;");e=e.replace(/(\r\n|\n|\r)/gm,"<br>")}}e=this.jsonSyntaxHighlight(e,this.jsonCls)}else{if(e===undefined){return"undefined"}}return e},multiFormat:function(e,d){var c,b=e,a;a=function(f,g){b=b.replace("{"+f+"}",g.toString())};for(c=0;c<d.length;c=c+1){Ext.Object.each(d[c],a)}return b},simpleFormat:function(e,d){var c,b=e,a;for(c=0;c<d.length;c=c+1){b=b.replace("{"+c+"}",d[c])}return b},constructor:function(a){this.initConfig(a)}})}());(function(){Ext.define("Sm.log.Level",{uses:["Sm.log.util.Debug","Sm.log.util.Assert"],statics:{initStatics:function(){this.NONE=Ext.create("Sm.log.Level",{name:"NONE",level:Math.pow(2,31)-1});this.FATAL=Ext.create("Sm.log.Level",{name:"FATAL",level:600});this.ERROR=Ext.create("Sm.log.Level",{name:"ERROR",level:500});this.WARN=Ext.create("Sm.log.Level",{name:"WARN",level:400});this.INFO=Ext.create("Sm.log.Level",{name:"INFO",level:300});this.DEBUG=Ext.create("Sm.log.Level",{name:"DEBUG",level:200});this.TRACE=Ext.create("Sm.log.Level",{name:"TRACE",level:100});this.ALL=Ext.create("Sm.log.Level",{name:"ALL",level:0})},getLevel:function(a){switch(a.toUpperCase()){case this.ALL.getName():return this.ALL;case this.NONE.getName():return this.NONE;case this.FATAL.getName():return this.FATAL;case this.ERROR.getName():return this.ERROR;case this.WARN.getName():return this.WARN;case this.INFO.getName():return this.INFO;case this.DEBUG.getName():return this.DEBUG;case this.TRACE.getName():return this.TRACE;default:return null}},getLevelLevel:function(a){switch(a.toUpperCase()){case this.ALL.getName():return this.ALL.getLevel();case this.NONE.getName():return this.NONE.getLevel();case this.FATAL.getName():return this.FATAL.getLevel();case this.ERROR.getName():return this.ERROR.getLevel();case this.WARN.getName():return this.WARN.getLevel();case this.INFO.getName():return this.INFO.getLevel();case this.DEBUG.getName():return this.DEBUG.getLevel();case this.TRACE.getName():return this.TRACE.getLevel();default:Sm.log.util.Debug.abort("This code should never execute");return}},NONE:undefined,FATAL:undefined,ERROR:undefined,WARN:undefined,INFO:undefined,DEBUG:undefined,TRACE:undefined,ALL:undefined},config:{name:"",level:0},constructor:function(a){this.initConfig(a)},le:function(a){return this.getLevel()<=a.getLevel()}},function(){this.initStatics()})}());(function(){Ext.define("Sm.log.LogViewerAppender",{extend:"Sm.log.AppenderBase",uses:["Sm.log.util.Assert"],attachViewer:function(a){Sm.log.util.Assert.assert(a);Sm.log.util.Assert.assert(!this.viewer);this.viewer=a},detachViewer:function(){Sm.log.util.Assert.assert(this.viewer);if(this.isLogging()){this.startBuffering()}this.viewer=null},startBuffering:function(){this.state=Sm.log.AppenderBase.BUFFERING},isBuffering:function(){return this.state===Sm.log.AppenderBase.BUFFERING},clearBuffer:function(){this.buffer=[]},canLog:function(){return this.viewer},startLogging:function(){Sm.log.util.Assert.assert(this.canLog());if(this.buffer.length>0){this.doPhysicalLog(this.buffer);this.clearBuffer()}this.callParent(arguments)},stopLogging:function(){this.callParent(arguments);this.clearBuffer()},supportsBuffering:function(){return true},setInitialState:function(){this.startBuffering()},constructor:function(a){this.callParent(arguments);this.setHtmlEncodedLogEventProperties(["message","ndc","formattedMessage"]);this.clearBuffer()},doLog:function(b){var a=5;b.formattedMultilineLoggedObject="";if(b.hasLoggedObject){b.formattedMultilineLoggedObject=this.getLayout().jsonLikeFormat(b.loggedObject,true,true,a)}b.formattedMultilineMessage=b.formattedMessage.replace(/(\r\n|\n|\r)/gm,"<br>");if(this.isBuffering()){this.buffer.push(b)}else{this.doPhysicalLog([b])}},doPhysicalLog:function(a){Sm.log.util.Assert.assert(this.viewer);this.viewer.appendLoggingEvents(a)}})}());(function(){Ext.data.Types.LOGLEVEL={convert:function(a,b){return a},sortType:function(a){return Sm.log.Level.getLevelLevel(a)},type:"LOGLEVEL"};Ext.define("Sm.log.viewer.LoggingEvent",{extend:"Ext.data.Model",fields:[{name:"hasLoggedObject"},{name:"formattedTime"},{name:"level",type:Ext.data.Types.LOGLEVEL},{name:"category"},{name:"formattedMessage"},{name:"formattedLoggedObject"},{name:"ndc"},{name:"formattedMultilineMessage"},{name:"formattedMultilineLoggedObject"}]});Ext.define("Sm.log.viewer.Level",{extend:"Ext.data.Model",fields:[{name:"level",type:"int"},{name:"name",type:"string"},{name:"iconClass",type:"string"}]});Ext.define("Sm.log.LogViewerWindow",{extend:"Ext.window.Window",uses:["Ext.ux.grid.plugin.RowExpander","Ext.ux.LiveSearchGridPanelEx","Ext.String","Ext.Array","Ext.form.Panel","Ext.grid.Panel","Ext.data.ArrayStore","Ext.ux.statusbar.StatusBar","Sm.log.Level","Sm.log.LogViewerAppender"],layout:"border",title:"Log viewer",resizable:true,itemId:"windowCId",iconCls:"sm-log-viewer-icon",maximizable:true,width:950,height:400,formPadding:5,config:{liveSearchEnabled:true},gridCfg:{xtype:"grid",itemId:"gridCId",region:"center",border:false,autoScroll:true,multiSelect:false,disableSelection:false,loadMask:true,viewConfig:{emptyText:"No logs",stripeRows:false},columns:[{dataIndex:"formattedTime",text:"Time",width:140},{dataIndex:"level",text:'<span data-qtip="Priority">P.</span>',width:30,renderer:function(b){var a,c;b=b.toLowerCase();a='<div  data-qtip="'+Ext.String.capitalize(b)+'" class="sm-log-level-'+b+'-icon" >&nbsp;</div>';return a}},{dataIndex:"category",text:"Category",width:150},{dataIndex:"ndc",text:"NDC",width:50},{dataIndex:"formattedMessage",text:"Message",width:300},{dataIndex:"hasLoggedObject",text:'<span data-qtip="Is there an attached logged object?">LO?</span>',width:30,renderer:function(b){var a=" ";if(b){a='<div  data-qtip="There is a logged object attached to this log entry" class="sm-log-has-logged-object-true" >&nbsp;</div>'}return a}},{dataIndex:"formattedLoggedObject",text:"Logged Object",width:500}],plugins:[{pluginId:"rowExpanderPId",ptype:"dvp_rowexpander",rowBodyTpl:['<p><b>Time</b>: {formattedTime}<b>&nbsp;&nbsp;&nbsp;&nbsp;Priority</b>: {level} <b>&nbsp;&nbsp;&nbsp;&nbsp;Category</b>: {category} <b>&nbsp;&nbsp;&nbsp;&nbsp;NDC</b>: {ndc}<br><b>Message</b>: <tpl if="formattedMultilineMessage != formattedMessage"><br></tpl>{formattedMultilineMessage}<tpl if="hasLoggedObject"><br><b>Logged Object</b>:<br><p>{formattedMultilineLoggedObject}</p></tpl></p>']}]},formCfg:{region:"north",split:true,autoScroll:true,itemId:"formCId",xtype:"form",layout:"column",border:false,fieldDefaults:{selectOnFocus:true,msgTarget:"side",autoFitErrors:true,labelAlign:"right",validateOnChange:true,fieldLabel:"&nbsp;"},items:[{xtype:"combo",name:"filteringLevel",itemId:"filteringLevelCId",valueField:"level",displayField:"name",width:125,labelWidth:45,fieldLabel:"Priority",allowBlank:false,autoSelect:true,forceSelection:true,editable:false,typeAhead:false,listConfig:{getInnerTpl:function(){var a='<div class="{iconClass}">{name}</div>';return a}},listeners:{change:{fn:function(){var a=this.up(".window");if(this.isValid()){a.applyFilter()}}}}},{xtype:"textfield",name:"filteringCategory",labelWidth:60,width:170,fieldLabel:"Category",vtype:"emptyOrLengthGreaterThan1",listeners:{change:{fn:function(){var a=this.up(".window");if(this.isValid()){a.applyFilter()}}}}},{xtype:"textfield",name:"filteringFormattedMessage",labelWidth:60,width:170,fieldLabel:"Message",vtype:"emptyOrLengthGreaterThan1",listeners:{change:{fn:function(){var a=this.up(".window");if(this.isValid()){a.applyFilter()}}}}},{xtype:"textfield",name:"filteringNdc",labelWidth:30,width:130,fieldLabel:"NDC",vtype:"emptyOrLengthGreaterThan1",listeners:{change:{fn:function(){var a=this.up(".window");if(this.isValid()){a.applyFilter()}}}}},{xtype:"textfield",name:"filteringFormattedLoggedObject",labelWidth:90,width:190,fieldLabel:"Logged object",vtype:"emptyOrLengthGreaterThan1",listeners:{change:{fn:function(){var a=this.up(".window");if(this.isValid()){a.applyFilter()}}}}}]},listeners:{destroy:function(){this.detachLogAppender(true)}},items:[],doDelayedFilter:function(){var a=this;a.store.clearFilter(true);a.store.filterBy(function(c){var b;b=a.filterByLevel(c)&&a.filterByCategory(c)&&a.filterByMessage(c)&&a.filterByNdc(c)&&a.filterByLoggedObject(c);return b});a.lastFilterTime=new Date()},applyFilter:function(){var d=this,c=new Date(),b,e=1000,a=150;d.lastFilterTime=d.lastFilterTime||new Date();b=c.getTime()-d.lastFilterTime.getTime();d.doDelayedFilter()},filterByLevel:function(c){var b=this,e,a,d;if(!b.filteringLevel||!b.filteringLevel.rendered){return true}e=b.filteringLevel.getValue();d=c.get("level");Sm.log.util.Assert.assert(d);a=Sm.log.Level.getLevelLevel(d);return a>=e},filterByStringFieldWithText:function(h,a,g,d,c){var e,f,b,i;e=this.form.findField(g);Sm.log.util.Assert.assert(e);f=e.getValue();if(f===""){return true}b=h.get(a);Sm.log.util.Assert.assert(Ext.isString(b));if(b===""&&d){return true}Sm.log.util.Assert.assert(b||b==="");if(!c){b=b.toUpperCase();f=f.toUpperCase()}i=b.indexOf(f)>=0;return i},filterByCategory:function(a){return this.filterByStringFieldWithText(a,"category","filteringCategory")},filterByMessage:function(a){return this.filterByStringFieldWithText(a,"formattedMessage","filteringFormattedMessage")},filterByNdc:function(a){return this.filterByStringFieldWithText(a,"ndc","filteringNdc")},filterByLoggedObject:function(a){return this.filterByStringFieldWithText(a,"formattedLoggedObject","filteringFormattedLoggedObject")},initComponent:function(b){var e=this,a,c,g,d,f;Ext.form.field.VTypes.emptyOrLengthGreaterThan1=function(h){if(!h){return false}Sm.log.util.Assert.assert(Ext.isString(h));return h.length>1};Ext.form.field.VTypes.emptyOrLengthGreaterThan1Text="Must be empty or have more than one character";e.store=Ext.create("Ext.data.ArrayStore",{model:"Sm.log.viewer.LoggingEvent",sorters:[{property:"formattedTime",direction:"DESC"}]});this.applyFilter();e.gridCfg.store=e.store;e.gridCfg.searchOnCriteriaChange=true;Ext.Array.forEach(e.gridCfg.columns,function(h){h.style={fontWeight:"bold"}});if(this.liveSearchEnabled){e.gridCfg.bbar=e.gridCfg.bbar||{};e.gridCfg.bbar.items=e.gridCfg.items||[];d=e.gridCfg.bbar}else{d={xtype:"statusbar",dock:"bottom",items:[]};e.gridCfg.dockedItems=[d]}Ext.Array.push(d.items,[{xtype:"button",text:"Clear logs",tooltip:"Clears current logs as well as buffered logs",handler:function(){var h=this.up(".window");h.clearLog()}},{xtype:"button",itemId:"stateCId",tooltip:"Sets state to Logging/Buffering logs/Stopped",menu:{items:[{text:"Log",iconCls:"sm-log-state-logging",tooltip:"Starts/restarts logging<p/>&nbsp;<p/>Shows incoming logs as they arrive: when set, will show all buffered logs that were pending",handler:function(){var h=this.up(".window");h.startLogging()}},{text:"Buffer new logs",tooltip:"Buffers incoming logs<p/>&nbsp;<p/>Buffered logs will be added to the window when logging state is set to logging again: they will not be lost.<p/>&nbsp;<p/>This might be useful to avoid interferences during debug due to the logging window being updated during logging.",iconCls:"sm-log-state-buffering",handler:function(){var h=this.up(".window");h.bufferLogging()}},{text:"Stop logging",tooltip:"Stops logging: incoming will be lost",iconCls:"sm-log-state-stopped",handler:function(){var h=this.up(".window");h.stopLogging()}}]}}]);if(this.getLiveSearchEnabled()){e.grid=Ext.create("Ext.ux.LiveSearchGridPanelEx",e.gridCfg);e.grid.hasRowExpanderPlugin=e.grid.getPlugin("rowExpanderPId")}else{e.grid=Ext.create("Ext.grid.Panel",e.gridCfg)}f=e.formPadding;e.formCfg.bodyPadding=f+", "+f+", 0, 0";e.formCfg.defaults=e.formCfg.defaults||{};e.formCfg.defaults.style={marginBottom:" "+f+"px",marginLeft:" "+f+"px"};g=e.formCfg.items[0];Sm.log.util.Assert.assert(g.name==="filteringLevel");g.value=Sm.log.Level.TRACE.getLevel();e.items=[e.formCfg,e.grid];e.callParent(arguments);e.grid=e.down("#gridCId");Sm.log.util.Assert.assert(e.grid);e.formPanel=e.down("#formCId");Sm.log.util.Assert.assert(e.formPanel);e.form=e.formPanel.getForm();Sm.log.util.Assert.assert(e.form);e.stateButton=e.down("#stateCId");Sm.log.util.Assert.assert(e.stateButton);e.filteringLevel=e.down("#filteringLevelCId");Sm.log.util.Assert.assert(e.filteringLevel);a=function(j){var i=j.name,h="sm-log-level-"+i.toLowerCase()+"-icon";return[j.getLevel(),j.getName(),h]};c=[a(Sm.log.Level.FATAL),a(Sm.log.Level.ERROR),a(Sm.log.Level.WARN),a(Sm.log.Level.INFO),a(Sm.log.Level.DEBUG),a(Sm.log.Level.TRACE)];e.filteringLevel.bindStore(Ext.create("Ext.data.ArrayStore",{model:"Sm.log.viewer.Level",autoLoad:true,data:c}));e.filteringLevel.setValue(Sm.log.Level.TRACE.getLevel());e.on("activate",function(){this.focustLastLogIfSortedByTime()},e,{single:true});e.on("boxready",this.boxreadyInitialization,e)},boxreadyInitialization:function(){var a=this;if(!this.getAppender()){this.appender=new Sm.log.LogViewerAppender()}this.attachLogAppender(this.getAppender());a.setTitle('<a data-qtip="Click to visit log4js-ext website" style="text-decoration: none" target="_new"href="http://code.google.com/p/log4js-ext/"><span class="sm-log-viewer-title-1">log4js</span><span class="sm-log-viewer-title-2">-ext</span></a>')},startLogging:function(){var a=this;Sm.log.util.Assert.assert(a.appender);if(a.appender.canLog()){this.updateState("Set logging state","Logging","sm-log-state-logging");a.appender.startLogging();return true}return false},stopLogging:function(){var a=this;Sm.log.util.Assert.assert(a.appender);this.updateState("Set logging state","Stopped","sm-log-state-stopped");a.appender.stopLogging()},bufferLogging:function(){var a=this;Sm.log.util.Assert.assert(a.appender);this.updateState("Set logging state","Buffering","sm-log-state-buffering");a.appender.startBuffering()},setNoAppenderAttachedState:function(){var a=this;Sm.log.util.Assert.assert(!this.getAppender());this.updateState("Logging state: no appender attached","No appender attached","sm-log-state-no-appender-attached",true)},updateState:function(f,d,a,b){var c=this,e;b=b||false;this.stateButton.setText(f);this.stateButton.setDisabled(b);this.stateButton.setIconCls(a)},clearLog:function(){var a=this;a.store.removeAll();if(this.getAppender()){this.getAppender().clearBuffer()}},getAppender:function(){return this.appender},attachLogAppender:function(a){var b=this;if(!a){this.detachLogAppender(false)}else{b.appender=a;b.appender.attachViewer(b);if(b.appender.canLog()){b.startLogging()}else{b.bufferLogging()}}},detachLogAppender:function(a){if(this.appender){this.appender.detachViewer();this.appender=null;if(!a){this.setNoAppenderAttachedState()}}},doDelayedAppend:function(){var b=this,c,a;for(a=0;a<this.delayedLogs.length;a=a+1){c=this.delayedLogs[a];b.store.add(new Sm.log.viewer.LoggingEvent(c))}this.delayedLogs=[];b.applyFilter();this.focustLastLogIfSortedByTime()},appendLoggingEvents:function(b){var a=this,c=50;this.delayedLogs=(this.delayedLogs||[]).concat(b);if(!a.applyLogTask){a.applyLogTask=new Ext.util.DelayedTask(function(){a.doDelayedAppend()})}a.applyLogTask.delay(c)},focustLastLogIfSortedByTime:function(){var c=this,f,e,b,a=null,d,g;if(c.store.getCount()===0){return}d=c.store.sorters;if(d.getCount()===0){return}g=d.getAt(0);if(g.property!=="formattedTime"){return}if(g.direction.toUpperCase()==="DESC"){f=0}else{f=c.store.getCount()-1}e=c.grid.getView();b=e.getSelectionModel().getSelection();Sm.log.util.Assert.assert(b.length<=1);if(b.length>0){a=b[0]}e.focusRow(f);if(!a){e.getSelectionModel().select(f)}}})}());(function(){Ext.define("Sm.log.Logger",{uses:["Ext.Array","Sm.log.Level","Sm.log.LoggingEvent","Sm.log.ExtLogAppender","Sm.log.util.Assert"],config:{category:"",level:null,enabled:true,appenders:[],additivity:true},statics:{enabled:true,getRoot:function(){if(this.PRIVATE_root===undefined){this.PRIVATE_root=Ext.create("Sm.log.Logger",{category:"",level:Sm.log.Level.TRACE});this.PRIVATE_root.addAppender(Sm.log.ExtLogAppender)}return this.PRIVATE_root},getLogger:function(d){Sm.log.util.Assert.assert(d!==undefined);if(!Ext.isString(d)){if(d.$isClass){d=d.getName()}else{if(d.self){d=d.self.geName()}else{d=d.toString()}}}if(d===""){return this.getRoot()}var e=d.split("."),a="",c=this.getRoot(),b;Ext.Array.forEach(e,function(f){Sm.log.util.Assert.assert(f);a=a+f;b=f+"$SmLgr";if(!c[b]){c[b]=new Sm.log.Logger({category:a});c[b].parentLogger=c}c=c[b];Sm.log.util.Assert.assert(!Ext.isFunction(c));a=a+"."});return c}},getEffectiveEnabled:function(){return this.getEnabled()&&this.self.enabled},getEffectiveAppenders:function(){var b=[],a=this.getAppenders();if(a&&a.length>0){b=b.concat(a)}if(this.parentLogger&&this.getAdditivity()){b=b.concat(this.parentLogger.getEffectiveAppenders())}return b},addAppender:function(a){this.getAppenders().push(a)},removeAppender:function(a){Ext.Array.remove(this.getAppenders(),a)},removeAllAppenders:function(){this.setAppenders([])},getEffectiveLevel:function(){if(!this.getLevel()){return this.parentLogger.getEffectiveLevel()}return this.getLevel()},log:function(d,a){var b=[],c;for(c=1;c<arguments.length;c=c+1){b.push(arguments[c])}this.doLog(d,b)},fatal:function(a){this.doLog(Sm.log.Level.FATAL,arguments)},error:function(a){this.doLog(Sm.log.Level.ERROR,arguments)},warn:function(a){this.doLog(Sm.log.Level.WARN,arguments)},info:function(){this.doLog(Sm.log.Level.INFO,arguments)},debug:function(a){this.doLog(Sm.log.Level.DEBUG,arguments)},trace:function(a){this.doLog(Sm.log.Level.TRACE,arguments)},isLevelEnabled:function(a){return this.getEffectiveLevel().le(a)},isFatalEnabled:function(){return this.isLevelEnabled(Sm.log.Level.FATAL)},isErrorEnabled:function(){return this.isLevelEnabled(Sm.log.Level.ERROR)},isWarnEnabled:function(){return this.isLevelEnabled(Sm.log.Level.WARN)},isInfoEnabled:function(){return this.isLevelEnabled(Sm.log.Level.INFO)},isDebugEnabled:function(){return this.isLevelEnabled(Sm.log.Level.DEBUG)},isTraceEnabled:function(){return this.isLevelEnabled(Sm.log.Level.TRACE)},doLog:function(f,b){var d,e,a,c;Sm.log.util.Assert.assert(f);Sm.log.util.Assert.assert(b);Sm.log.util.Assert.assert(b.length>=1);if(!this.getEffectiveEnabled()){return}if(this.isLevelEnabled(f)){a={};a.level=f;a.message=b[0];a.time=new Date();a.category=this.getCategory();if(b.length>1){a.formatParams=[];for(c=1;c<b.length;c=c+1){a.formatParams.push(b[c])}}Ext.Array.forEach(this.getEffectiveAppenders(),function(g){d=Ext.create("Sm.log.LoggingEvent",a);g.log(d)})}},constructor:function(a){Sm.log.util.Assert.assert(a);Sm.log.util.Assert.assert(a.category===""||a.category);this.initConfig(a);this.setAppenders([])}})}());(function(){Ext.define("Sm.log.LoggingEvent",{uses:["Sm.log.util.Assert","Sm.log.NDC"],category:"",time:null,level:null,message:"",ndc:undefined,loggedObject:undefined,formatParams:undefined,hasLoggedObject:false,levelLevel:undefined,formattedMessage:undefined,formattedTime:undefined,formattedLoggedObject:undefined,handleMessage:function(){if(Ext.isObject(this.message)||Ext.isArray(this.message)){if(this.message.hasOwnProperty("loggedObject")){this.loggedObject=this.message.loggedObject;this.message=this.message.message||this.message.msg||this.message.toString()}else{this.loggedObject=this.message;this.message=" "}this.hasLoggedObject=true}else{this.hasLoggedObject=false}},constructor:function(a){Sm.log.util.Assert.assert(a);Sm.log.util.Assert.assert(a.time);Sm.log.util.Assert.assert(a.message!==undefined);Sm.log.util.Assert.assert(a.category);Sm.log.util.Assert.assert(a.level);Ext.apply(this,a);this.level=a.level.getName();this.levelLevel=a.level.getLevel();this.ndc=Sm.log.NDC.getNDCString()||"";this.handleMessage(this.message)}})}());(function(){Ext.define("Sm.log.NDC",{singleton:true,uses:["Sm.log.util.Assert"],config:{stack:[]},push:function(a){this.stack.push(a)},pop:function(){this.getStack().pop()},getNDCString:function(){return this.getStack().join(".")},clear:function(){this.setStack([])}})}());(function(){Ext.define("Sm.log.TemplateLayout",{extend:"Sm.log.LayoutBase",uses:["Sm.log.util.Assert"],formatLogAsText:function(a){return this.applyTemplate(a)},setTemplate:function(a){Sm.log.util.Assert.assert(a);this.template=new Ext.Template(a);this.template.compile()},applyTemplate:function(a){return this.template.apply(a)},constructor:function(a){Sm.log.util.Assert.assert(a);Sm.log.util.Assert.assert(a.template);this.callParent(arguments);this.setTemplate(a.template)},statics:{getDefaultLayout:function(){if(!this.defaultLayoutF){this.defaultLayoutF=new Sm.log.TemplateLayout({template:"{formattedTime} {level} {ndc} {category}: {formattedMessage}"})}return this.defaultLayoutF}}})}());(function(){Ext.define("Sm.log.direct.DirectAppender",{extend:"Sm.log.AppenderBase",config:{loggingAction:null},statics:{ensureStandardProviderRegistered:function(){var a=Sm.log.direct.DirectAppender,b;if(!a.remotingApiRegistered){b=Ext.Direct.addProvider(Sm.log.direct.impl.REMOTING_API);b.maxRetries=0;b.timeout=15000}a.remotingApiRegistered=true},getLog4jAppender:function(){var a=Sm.log.direct.DirectAppender;a.ensureStandardProviderRegistered();if(!a.log4jAppender){a.log4jAppender=new Sm.log.direct.DirectAppender({loggingAction:Sm.log.direct.impl.DjnLog4jLogger})}return a.log4jAppender},getSlf4jAppender:function(){var a=Sm.log.direct.DirectAppender;Sm.log.direct.DirectAppender.ensureStandardProviderRegistered();if(!a.slf4jAppender){a.slf4jAppender=new Sm.log.direct.DirectAppender({loggingAction:Sm.log.direct.impl.DjnSlf4jLogger})}return a.slf4jAppender},getApacheCommonsLoggingAppender:function(){var a=Sm.log.direct.DirectAppender;Sm.log.direct.DirectAppender.ensureStandardProviderRegistered();if(!a.apacheCommonsLoggingAppender){a.apacheCommonsLoggingAppender=new Sm.log.direct.DirectAppender({loggingAction:Sm.log.direct.impl.DjnApacheCommonsLogger})}return a.apacheCommonsLoggingAppender}},constructor:function(a){this.callParent(arguments);Sm.log.util.Assert.assert(a.loggingAction);this.setLayout(new Sm.log.LayoutBase());this.getLayout().highlightLoggedObject=false},doLog:function(a){a.timeMillis=a.time.getTime();delete a.time;delete a.message;delete a.formatParams;delete a.loggedObject;delete a.levelLevel;this.getLoggingAction().log(a,{success:function(b,c){Sm.log.util.Assert.assert(b===true)},failure:function(b,c){Sm.log.util.Debug.abort()}})}})}());(function(){Ext.define("Sm.log.remote.RemoteAppender",{extend:"Sm.log.AppenderBase",uses:["Sm.log.util.Debug","Sm.log.util.Assert"],config:{loggerName:null,url:null},statics:{createLog4jAppender:function(a){Sm.log.util.Assert.assert(a);return new Sm.log.remote.RemoteAppender({loggerName:"log4j",url:a})},createSlf4jAppender:function(a){Sm.log.util.Assert.assert(a);return new Sm.log.remote.RemoteAppender({loggerName:"slf4j",url:a})},createApacheCommonsLoggingAppender:function(a){Sm.log.util.Assert.assert(a);return new Sm.log.remote.RemoteAppender({loggerName:"apacheCommons",url:a})}},constructor:function(a){this.callParent(arguments);Sm.log.util.Assert.assert(a);Sm.log.util.Assert.assert(a.loggerName);this.setLayout(new Sm.log.LayoutBase());this.getLayout().highlightLoggedObject=false},doLog:function(a){var b;a.timeMillis=a.time.getTime();delete a.time;delete a.message;delete a.formatParams;delete a.loggedObject;delete a.levelLevel;a.logger=this.getLoggerName();b=a;Ext.Ajax.request({url:this.getUrl(),method:"POST",params:b,success:function(c,d){Sm.log.util.Assert.assert(c.responseText==="true")},failure:function(c,d){Sm.log.util.Debug.abort()}})}})}());(function(){Ext.define("Sm.log.util.Assert",{uses:["Sm.log.util.Debug"],singleton:true,ON:true,assert:function(b,c){if(Sm.log.util.Assert.ON!==true){return}var a;if(!b){a="AssertionError";if(c){a+=": "+c}console.log(a);Sm.log.util.Debug.abort(a)}}})}());(function(){Ext.define("Sm.log.util.Debug",{singleton:true,ON:false,abort:function(a){var b="ABORT";if(a){b+=": "+a}console.log(b);this.abortAndAttemptToAwakeDebuggerIfPresent()},abortWhenCalled:function(a){return function(){Sm.log.util.Debug.abort(a)}}})}());Ext.define("Ext.ux.LiveSearchGridPanelEx",{extend:"Ext.grid.Panel",requires:["Ext.toolbar.TextItem","Ext.form.field.Checkbox","Ext.form.field.Text","Ext.ux.statusbar.StatusBar"],searchValue:null,indexes:[],currentIndex:null,searchRegExp:null,caseSensitive:false,regExpMode:false,matchCls:"x-livesearch-match",defaultStatusText:"Nothing Found",initComponent:function(){var a=this;a.tbar=["Search",{xtype:"textfield",name:"searchField",hideLabel:true,width:200,enableKeyEvents:true,listeners:{change:{fn:a.onTextFieldChange,scope:this,buffer:600},specialKey:function(c,b){if(b.getKey()===b.ENTER){a.onTextFieldChange()}}}},{xtype:"button",iconCls:"sm-livesearch-prev",tooltip:"Find Previous Row",handler:a.onPreviousClick,scope:a},{xtype:"button",iconCls:"sm-livesearch-next",tooltip:"Find Next Row",handler:a.onNextClick,scope:a},"-",{xtype:"checkbox",hideLabel:true,margin:"0 0 0 4px",handler:a.regExpToggle,scope:a},"Regular expression",{xtype:"checkbox",hideLabel:true,margin:"0 0 0 4px",handler:a.caseSensitiveToggle,scope:a},"Case sensitive"];Ext.apply(a.bbar,{xtype:"statusbar",defaultText:a.defaultStatusText,name:"searchStatusBar"});a.callParent(arguments)},afterRender:function(){var a=this;a.callParent(arguments);a.textField=a.down("textfield[name=searchField]");a.statusBar=a.down("statusbar[name=searchStatusBar]")},tagsRe:/<[^>]*>/gm,tagsProtect:"\x0f",regExpProtect:/\\|\/|\+|\\|\.|\[|\]|\{|\}|\?|\$|\*|\^|\|/gm,getSearchValue:function(){var b=this,c=b.textField.getValue();if(c===""){return null}if(!b.regExpMode){c=c.replace(b.regExpProtect,function(d){return"\\"+d})}else{try{new RegExp(c)}catch(a){b.statusBar.setStatus({text:a.message,iconCls:"x-status-error"});return null}if(c==="^"||c==="$"){return null}}return c},onTextFieldChange:function(){var b=this,a;records=b.store.getCount();if(records>150){a="Searching among "+b.getStore().getCount()+" records.</p>Please, wait..."}if(a){Ext.getBody().mask(a,"x-mask-loading")}Ext.defer(function(){b.onTextFieldChange2();if(a){Ext.getBody().unmask()}},50)},onTextFieldChange2:function(){var b=this,a=0;b.view.refresh();b.statusBar.setStatus({text:b.defaultStatusText,iconCls:""});b.searchValue=b.getSearchValue();b.indexes=[];b.currentIndex=null;if(b.searchValue!==null){b.searchRegExp=new RegExp(b.searchValue,"g"+(b.caseSensitive?"":"i"));var c=b.getPlugin("");b.store.each(function(f,e){var j=Ext.fly(b.view.getNode(e)).down("td"),d,i,h;if(b.hasRowExpanderPlugin){j=j.down("td")}while(j){d=j.down(".x-grid-cell-inner");if(b.hasRowExpanderPlugin&&!d){d=j.down(".x-grid-rowbody")}i=d.dom.innerHTML.match(b.tagsRe);h=d.dom.innerHTML.replace(b.tagsRe,b.tagsProtect);h=h.replace(b.searchRegExp,function(k){a+=1;if(Ext.Array.indexOf(b.indexes,e)===-1){b.indexes.push(e)}if(b.currentIndex===null){b.currentIndex=e}return'<span class="'+b.matchCls+'">'+k+"</span>"});Ext.each(i,function(k){h=h.replace(b.tagsProtect,k)});d.dom.innerHTML=h;if(b.hasRowExpanderPlugin&&!j.next()){var g=j;g=g.up("tr").next();if(g){g=g.down("td")}if(g){j=g;continue}}j=j.next()}},b);if(b.currentIndex!==null){b.getSelectionModel().select(b.currentIndex);b.statusBar.setStatus({text:a+" matche(s) found.",iconCls:"x-status-valid"})}}if(b.currentIndex===null){b.getSelectionModel().deselectAll()}b.textField.focus()},onPreviousClick:function(){var b=this,a;if((a=Ext.Array.indexOf(b.indexes,b.currentIndex))!==-1){b.currentIndex=b.indexes[a-1]||b.indexes[b.indexes.length-1];b.getSelectionModel().select(b.currentIndex)}},onNextClick:function(){var b=this,a;if((a=Ext.Array.indexOf(b.indexes,b.currentIndex))!==-1){b.currentIndex=b.indexes[a+1]||b.indexes[0];b.getSelectionModel().select(b.currentIndex)}},caseSensitiveToggle:function(b,a){this.caseSensitive=a;this.onTextFieldChange()},regExpToggle:function(b,a){this.regExpMode=a;this.onTextFieldChange()}});Ext.define("Ext.ux.grid.plugin.RowExpander",{alias:"plugin.dvp_rowexpander",extend:"Ext.ux.RowExpander",collapseAllCls:"rowexpand-collapse-all",collapseAllTip:"Collapse all rows",expandAllCls:"rowexpand-expand-all",expandAllTip:"Expand all rows",headerCls:"rowexpand-header",constructor:function(){var a=this;a.callParent(arguments);a.toggleAllState=false},init:function(b){var c=this,a;c.callParent(arguments);a=b.headerCt.getComponent(0);a.on("headerclick",c.onHeaderClick,c);a.on("render",c.onHeaderRender,c)},getHeaderConfig:function(){var b=this,a=b.callParent(arguments);Ext.apply(a,{cls:(a.cls||"")+" "+b.headerCls});return a},collapseAll:function(){this.toggleAll(false)},expandAll:function(){this.toggleAll(true)},onHeaderClick:function(b,a){var d=this,c=a.textEl;if(d.toggleAllState){d.collapseAll();c.replaceCls(d.collapseAllCls,d.expandAllCls)}else{d.expandAll();c.replaceCls(d.expandAllCls,d.collapseAllCls)}d.toggleAllState=!d.toggleAllState},onHeaderRender:function(a){a.textEl.addCls(this.expandAllCls)},toggleAll:function(c){var e=this,g=e.getCmp().getStore(),f=g.data.items,d=0,b=f.length,a;for(;d<b;d++){a=f[d];if(e.recordsExpanded[a.internalId]!==c){e.toggleRow(d)}}}});