/*
 * Copyright © 2012, 2013 Pedro Agullo Soliveres.
 * 
 * This file is part of Log4js-ext.
 *
 * Log4js-ext is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License.
 *
 * Commercial use is permitted to the extent that the code/component(s)
 * do NOT become part of another Open Source or Commercially developed
 * licensed development library or toolkit without explicit permission.
 *
 * Log4js-ext is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Log4js-ext.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * This software uses the ExtJs library (http://extjs.com), which is 
 * distributed under the GPL v3 license (see http://extjs.com/license).
 */

/*global TestCase: true, 
  assertTrue: true, assertEquals: true, assertNotNull: true */
(function() {
   "use strict"; //$NON-NLS-1$
   
   /*jslint newcap : false */
   TestCase("LogViewerAppenderJtdTest", {
      createFakeLog : function (cfg) {
         var result, fakeLog;
         
         fakeLog= {
            message : 'Msg',
            time : new Date( 2000, 1, 30),
            category : 'X.Y.Z',
            level : Sm.log.Level.INFO, 
            levelLevel : Sm.log.Level.INFO.getLevel()
         };
         Ext.apply( fakeLog, cfg);
         result = new Sm.log.LoggingEvent(fakeLog);
         return result;
      },
      
      createFakeViewer : function() {
         var buffered = [];
         
         return {
           detachLogAppender : function(appender) {
              appender.detachViewer(this);
           },
            
           attachLogAppender : function(appender ) {
              appender.attachViewer(this);
           },
            
           popBuffered : function () {
              var result = buffered;
              buffered = [];
              return result;
           },
           
           bufferedCount : function () {
              return buffered.length;
           },
           
           appendLoggingEvents : function( logs ) {
              buffered = Ext.clone(logs);
           }
         };
      },
      
      testBuffering : function () {
         var appender, logger, le, viewer; 
         appender = new Sm.log.LogViewerAppender();
         viewer = this.createFakeViewer();
         viewer.attachLogAppender(appender);
         
         appender.startBuffering();
         appender.log( this.createFakeLog() );
         appender.log( this.createFakeLog() );
         assertEquals( 0, viewer.bufferedCount());
         appender.startLogging();
         assertEquals( 2, viewer.popBuffered().length);

         // When start/restart logging, logs sent while stopping are lost
         appender.startLogging();
         appender.log( this.createFakeLog() );
         assertEquals( 1, viewer.popBuffered().length);
         
         // When we stop logging, buffered logs are lost
         appender.startBuffering();
         appender.log( this.createFakeLog() );
         appender.log( this.createFakeLog() );
         appender.stopLogging();
         appender.startLogging();
         assertEquals( 0, viewer.popBuffered().length);
      },
      
      testBufferedLogsWrittenInRightOrder : function () {
         var appender, logger, le, viewer, buffered; 
         appender = new Sm.log.LogViewerAppender();
         viewer = this.createFakeViewer();
         viewer.attachLogAppender(appender);
         
         appender.startBuffering();
         appender.log( this.createFakeLog({message:"1"}) );
         appender.log( this.createFakeLog({message:"2"}) );

         appender.startLogging();
         buffered = viewer.popBuffered();
         assertEquals( "1", buffered[0].message);
         assertEquals( "2", buffered[1].message);
      },
      
      testDetachStartsBuffering : function () {
         var appender, logger, le, viewer, buffered; 
         appender = new Sm.log.LogViewerAppender();
         viewer = this.createFakeViewer();
         viewer.attachLogAppender(appender);         
         appender.startBuffering();
         
         viewer.detachLogAppender(appender);
         assertTrue( appender.isBuffering() );
         
         appender.log( this.createFakeLog() );
         appender.log( this.createFakeLog() );
         viewer = this.createFakeViewer();
         viewer.attachLogAppender(appender);         
         appender.startLogging();
         assertEquals( 2, viewer.bufferedCount() );
      }
      
   });

}());