/*
 * Copyright © 2012, 2013 Pedro Agullo Soliveres.
 * 
 * This file is part of Log4js-ext.
 *
 * Log4js-ext is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License.
 *
 * Commercial use is permitted to the extent that the code/component(s)
 * do NOT become part of another Open Source or Commercially developed
 * licensed development library or toolkit without explicit permission.
 *
 * Log4js-ext is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Log4js-ext.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * This software uses the ExtJs library (http://extjs.com), which is 
 * distributed under the GPL v3 license (see http://extjs.com/license).
 */

/*jslint strict:false */

(function() {
   // "use strict"; //$NON-NLS-1$

   /**
    * A layout that formats log data using an Extjs template.
    */
   Ext.define('Sm.log.TemplateLayout', { //$NON-NLS-1$
      extend : 'Sm.log.LayoutBase',
      
      uses : ['Sm.log.util.Assert'],

      /**
       * @protected
       * 
       * Returns a text representing a whole log entry.
       * 
       * Very useful for line-oriented output, like a browser console window.
       * 
       * @param {Sm.log.LoggingEvent} logEvent The log data.
       * @returns {String} A text representing a whole log entry.
       */
      formatLogAsText : function(logEvent) {
         // We can do as we want here, because we've been handed a personal
         // copy of logEvent
         return this.applyTemplate(logEvent);
      },

      /** 
       * Sets the template text for the underling Ext template.
       * 
       * @param {String} templateText
       * 
       * @returns {void}
       */
      setTemplate : function(templateText) {
         Sm.log.util.Assert.assert( templateText );
         
        this.template = new Ext.Template( templateText );
        this.template.compile();
      },
      
      /**
       * @protected
       * 
       * Returns the text generated by applying the template to a log entry.
       * 
       * @param {Sm.log.LoggingEvent} logCopy The log data.
       * @returns void
       */
      applyTemplate : function(log) {
         return this.template.apply(log);
      },

      /**
       * Create a new template layout.
       * 
       * @param cfg
       */
      constructor : function(cfg) {
         Sm.log.util.Assert.assert(cfg);
         Sm.log.util.Assert.assert(cfg.template);
         this.callParent(arguments);
         
         this.setTemplate(cfg.template);
      },
      
      statics : {
         /**
          * @static
          * 
          * Returns the default template layout, used by default by
          * all appenders.
          * 
          * @returns {Sm.log.TemplateLayout}
          */
         getDefaultLayout : function() {
            if( !this.defaultLayoutF) {
               this.defaultLayoutF = new Sm.log.TemplateLayout(
                  {template: 
                   '{formattedTime} {level} {ndc} ' +
                   '{category}: {formattedMessage}'} );               
            }
            return this.defaultLayoutF;
         }
      }

   });
}());