/**
 * math.js
 * https://github.com/josdejong/mathjs
 *
 * Math.js is an extensive math library for JavaScript and Node.js,
 * It features real and complex numbers, units, matrices, a large set of
 * mathematical functions, and a flexible expression parser.
 *
 * @version 2.0.1
 * @date    2015-07-29
 *
 * @license
 * Copyright (C) 2013-2015 Jos de Jong <wjosdejong@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define(factory);
	else if(typeof exports === 'object')
		exports["math"] = factory();
	else
		root["math"] = factory();
})(this, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};

/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {

/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;

/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};

/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);

/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;

/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}


/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;

/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;

/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";

/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ function(module, exports, __webpack_require__) {

	var core = __webpack_require__(1);

	/**
	 * math.js factory function. Creates a new instance of math.js
	 *
	 * @param {Object} [config] Available configuration options:
	 *                            {number} epsilon
	 *                              Minimum relative difference between two
	 *                              compared values, used by all comparison functions.
	 *                            {string} matrix
	 *                              A string 'matrix' (default) or 'array'.
	 *                            {string} number
	 *                              A string 'number' (default), 'bignumber', or
	 *                              'fraction'
	 *                            {number} precision
	 *                              The number of significant digits for BigNumbers.
	 *                              Not applicable for Numbers.
	 *                            {boolean} predictable
	 *                              Predictable output type of functions. When true,
	 *                              output type depends only on the input types. When
	 *                              false (default), output type can vary depending
	 *                              on input values. For example `math.sqrt(-2)`
	 *                              returns `NaN` when predictable is false, and
	 *                              returns `complex('2i')` when true.
	 */
	function create (config) {
	  // create a new math.js instance
	  var math = core.create(config);
	  math.create = create;

	  // import data types, functions, constants, expression parser, etc.
	  math.import(__webpack_require__(13));

	  return math;
	}

	// return a new instance of math.js
	module.exports = create();


/***/ },
/* 1 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__(2);

/***/ },
/* 2 */
/***/ function(module, exports, __webpack_require__) {

	var isFactory = __webpack_require__(5).isFactory;
	var deepExtend = __webpack_require__(5).deepExtend;
	var typedFactory = __webpack_require__(6);
	var emitter = __webpack_require__(3);

	var importFactory = __webpack_require__(10);
	var configFactory = __webpack_require__(12);

	/**
	 * Math.js core. Creates a new, empty math.js instance
	 * @param {Object} [options] Available options:
	 *                            {number} epsilon
	 *                              Minimum relative difference between two
	 *                              compared values, used by all comparison functions.
	 *                            {string} matrix
	 *                              A string 'matrix' (default) or 'array'.
	 *                            {string} number
	 *                              A string 'number' (default), 'bignumber', or 'fraction'
	 *                            {number} precision
	 *                              The number of significant digits for BigNumbers.
	 *                              Not applicable for Numbers.
	 *                            {boolean} predictable
	 *                              Predictable output type of functions. When true,
	 *                              output type depends only on the input types. When
	 *                              false (default), output type can vary depending
	 *                              on input values. For example `math.sqrt(-2)`
	 *                              returns `NaN` when predictable is false, and
	 *                              returns `complex('2i')` when true.
	 * @returns {Object} Returns a bare-bone math.js instance containing
	 *                   functions:
	 *                   - `import` to add new functions
	 *                   - `config` to change configuration
	 *                   - `on`, `off`, `once`, `emit` for events
	 */
	exports.create = function create (options) {
	  // simple test for ES5 support
	  if (typeof Object.create !== 'function') {
	    throw new Error('ES5 not supported by this JavaScript engine. ' +
	    'Please load the es5-shim and es5-sham library for compatibility.');
	  }

	  // cached factories and instances
	  var factories = [];
	  var instances = [];

	  // create a namespace for the mathjs instance, and attach emitter functions
	  var math = emitter.mixin({});
	  math.type = {};
	  math.expression = {
	    transform: Object.create(math)
	  };

	  // create a new typed instance
	  math.typed = typedFactory.create(math.type);

	  // create configuration options. These are private
	  var _config = {
	    // minimum relative difference between two compared values,
	    // used by all comparison functions
	    epsilon: 1e-14,

	    // type of default matrix output. Choose 'matrix' (default) or 'array'
	    matrix: 'matrix',

	    // type of default number output. Choose 'number' (default) or 'bignumber'
	    number: 'number',

	    // number of significant digits in BigNumbers
	    precision: 64,

	    // predictable output type of functions. When true, output type depends only
	    // on the input types. When false (default), output type can vary depending
	    // on input values. For example `math.sqrt(-2)` returns `NaN` when
	    // predictable is false, and returns `complex('2i')` when true.
	    predictable: false
	  };

	  if (options) {
	    // merge options
	    deepExtend(_config, options);
	  }

	  /**
	   * Load a function or data type from a factory.
	   * If the function or data type already exists, the existing instance is
	   * returned.
	   * @param {{type: string, name: string, factory: Function}} factory
	   * @returns {*}
	   */
	  function load (factory) {
	    if (!isFactory(factory)) {
	      throw new Error('Factory object with properties `type`, `name`, and `factory` expected');
	    }

	    var index = factories.indexOf(factory);
	    var instance;
	    if (index === -1) {
	      // doesn't yet exist
	      if (factory.math === true) {
	        // pass with math namespace
	        instance = factory.factory(math.type, _config, load, math.typed, math);
	      }
	      else {
	        instance = factory.factory(math.type, _config, load, math.typed);
	      }

	      // append to the cache
	      factories.push(factory);
	      instances.push(instance);
	    }
	    else {
	      // already existing function, return the cached instance
	      instance = instances[index];
	    }

	    return instance;
	  }

	  // load the import and config functions
	  math['import'] = load(importFactory);
	  math['config'] = load(configFactory);

	  return math;
	};


/***/ },
/* 3 */
/***/ function(module, exports, __webpack_require__) {

	var Emitter = __webpack_require__(4);

	/**
	 * Extend given object with emitter functions `on`, `off`, `once`, `emit`
	 * @param {Object} obj
	 * @return {Object} obj
	 */
	exports.mixin = function (obj) {
	  // create event emitter
	  var emitter = new Emitter();

	  // bind methods to obj (we don't want to expose the emitter.e Array...)
	  obj.on   = emitter.on.bind(emitter);
	  obj.off  = emitter.off.bind(emitter);
	  obj.once = emitter.once.bind(emitter);
	  obj.emit = emitter.emit.bind(emitter);

	  return obj;
	};


/***/ },
/* 4 */
/***/ function(module, exports) {

	function E () {
		// Keep this empty so it's easier to inherit from
	  // (via https://github.com/lipsmack from https://github.com/scottcorgan/tiny-emitter/issues/3)
	}

	E.prototype = {
		on: function (name, callback, ctx) {
	    var e = this.e || (this.e = {});
	    
	    (e[name] || (e[name] = [])).push({
	      fn: callback,
	      ctx: ctx
	    });
	    
	    return this;
	  },

	  once: function (name, callback, ctx) {
	    var self = this;
	    var fn = function () {
	      self.off(name, fn);
	      callback.apply(ctx, arguments);
	    };
	    
	    return this.on(name, fn, ctx);
	  },

	  emit: function (name) {
	    var data = [].slice.call(arguments, 1);
	    var evtArr = ((this.e || (this.e = {}))[name] || []).slice();
	    var i = 0;
	    var len = evtArr.length;
	    
	    for (i; i < len; i++) {
	      evtArr[i].fn.apply(evtArr[i].ctx, data);
	    }
	    
	    return this;
	  },

	  off: function (name, callback) {
	    var e = this.e || (this.e = {});
	    var evts = e[name];
	    var liveEvents = [];
	    
	    if (evts && callback) {
	      for (var i = 0, len = evts.length; i < len; i++) {
	        if (evts[i].fn !== callback) liveEvents.push(evts[i]);
	      }
	    }
	    
	    // Remove event from queue to prevent memory leak
	    // Suggested by https://github.com/lazd
	    // Ref: https://github.com/scottcorgan/tiny-emitter/commit/c6ebfaa9bc973b33d110a84a307742b7cf94c953#commitcomment-5024910

	    (liveEvents.length) 
	      ? e[name] = liveEvents
	      : delete e[name];
	    
	    return this;
	  }
	};

	module.exports = E;


/***/ },
/* 5 */
/***/ function(module, exports) {

	'use strict';

	/**
	 * Clone an object
	 *
	 *     clone(x)
	 *
	 * Can clone any primitive type, array, and object.
	 * If x has a function clone, this function will be invoked to clone the object.
	 *
	 * @param {*} x
	 * @return {*} clone
	 */
	exports.clone = function clone(x) {
	  var type = typeof x;

	  // immutable primitive types
	  if (type === 'number' || type === 'string' || type === 'boolean' ||
	      x === null || x === undefined) {
	    return x;
	  }

	  // use clone function of the object when available
	  if (typeof x.clone === 'function') {
	    return x.clone();
	  }

	  // array
	  if (Array.isArray(x)) {
	    return x.map(function (value) {
	      return clone(value);
	    });
	  }

	  if (x instanceof Number)    return new Number(x.valueOf());
	  if (x instanceof String)    return new String(x.valueOf());
	  if (x instanceof Boolean)   return new Boolean(x.valueOf());
	  if (x instanceof Date)      return new Date(x.valueOf());
	  if (x && x.isBigNumber === true) return x; // bignumbers are immutable
	  if (x instanceof RegExp)  throw new TypeError('Cannot clone ' + x);  // TODO: clone a RegExp

	  // object
	  var m = {};
	  for (var key in x) {
	    if (x.hasOwnProperty(key)) {
	      m[key] = clone(x[key]);
	    }
	  }
	  return m;
	};

	/**
	 * Extend object a with the properties of object b
	 * @param {Object} a
	 * @param {Object} b
	 * @return {Object} a
	 */
	exports.extend = function(a, b) {
	  for (var prop in b) {
	    if (b.hasOwnProperty(prop)) {
	      a[prop] = b[prop];
	    }
	  }
	  return a;
	};

	/**
	 * Deep extend an object a with the properties of object b
	 * @param {Object} a
	 * @param {Object} b
	 * @returns {Object}
	 */
	exports.deepExtend = function deepExtend (a, b) {
	  // TODO: add support for Arrays to deepExtend
	  if (Array.isArray(b)) {
	    throw new TypeError('Arrays are not supported by deepExtend');
	  }

	  for (var prop in b) {
	    if (b.hasOwnProperty(prop)) {
	      if (b[prop] && b[prop].constructor === Object) {
	        if (a[prop] === undefined) {
	          a[prop] = {};
	        }
	        if (a[prop].constructor === Object) {
	          deepExtend(a[prop], b[prop]);
	        }
	        else {
	          a[prop] = b[prop];
	        }
	      } else if (Array.isArray(b[prop])) {
	        throw new TypeError('Arrays are not supported by deepExtend');
	      } else {
	        a[prop] = b[prop];
	      }
	    }
	  }
	  return a;
	};

	/**
	 * Deep test equality of all fields in two pairs of arrays or objects.
	 * @param {Array | Object} a
	 * @param {Array | Object} b
	 * @returns {boolean}
	 */
	exports.deepEqual = function deepEqual (a, b) {
	  var prop, i, len;
	  if (Array.isArray(a)) {
	    if (!Array.isArray(b)) {
	      return false;
	    }

	    if (a.length != b.length) {
	      return false;
	    }

	    for (i = 0, len = a.length; i < len; i++) {
	      if (!exports.deepEqual(a[i], b[i])) {
	        return false;
	      }
	    }
	    return true;
	  }
	  else if (a instanceof Object) {
	    if (Array.isArray(b) || !(b instanceof Object)) {
	      return false;
	    }

	    for (prop in a) {
	      //noinspection JSUnfilteredForInLoop
	      if (!exports.deepEqual(a[prop], b[prop])) {
	        return false;
	      }
	    }
	    for (prop in b) {
	      //noinspection JSUnfilteredForInLoop
	      if (!exports.deepEqual(a[prop], b[prop])) {
	        return false;
	      }
	    }
	    return true;
	  }
	  else {
	    return (typeof a === typeof b) && (a == b);
	  }
	};

	/**
	 * Test whether the current JavaScript engine supports Object.defineProperty
	 * @returns {boolean} returns true if supported
	 */
	exports.canDefineProperty = function () {
	  // test needed for broken IE8 implementation
	  try {
	    if (Object.defineProperty) {
	      Object.defineProperty({}, 'x', {});
	      return true;
	    }
	  } catch (e) {}

	  return false;
	};

	/**
	 * Attach a lazy loading property to a constant.
	 * The given function `fn` is called once when the property is first requested.
	 * On older browsers (<IE8), the function will fall back to direct evaluation
	 * of the properties value.
	 * @param {Object} object   Object where to add the property
	 * @param {string} prop     Property name
	 * @param {Function} fn     Function returning the property value. Called
	 *                          without arguments.
	 */
	exports.lazy = function (object, prop, fn) {
	  if (exports.canDefineProperty()) {
	    var _uninitialized = true;
	    var _value;
	    Object.defineProperty(object, prop, {
	      get: function () {
	        if (_uninitialized) {
	          _value = fn();
	          _uninitialized = false;
	        }
	        return _value;
	      },

	      set: function (value) {
	        _value = value;
	        _uninitialized = false;
	      },

	      configurable: true,
	      enumerable: true
	    });
	  }
	  else {
	    // fall back to immediate evaluation
	    object[prop] = fn();
	  }
	};

	/**
	 * Traverse a path into an object.
	 * When a namespace is missing, it will be created
	 * @param {Object} object
	 * @param {string} path   A dot separated string like 'name.space'
	 * @return {Object} Returns the object at the end of the path
	 */
	exports.traverse = function(object, path) {
	  var obj = object;

	  if (path) {
	    var names = path.split('.');
	    for (var i = 0; i < names.length; i++) {
	      var name = names[i];
	      if (!(name in obj)) {
	        obj[name] = {};
	      }
	      obj = obj[name];
	    }
	  }

	  return obj;
	};

	/**
	 * Test whether an object is a factory. a factory has fields:
	 *
	 * - factory: function (type: Object, config: Object, load: function, typed: function [, math: Object])   (required)
	 * - name: string (optional)
	 * - path: string    A dot separated path (optional)
	 * - math: boolean   If true (false by default), the math namespace is passed
	 *                   as fifth argument of the factory function
	 *
	 * @param {*} object
	 * @returns {boolean}
	 */
	exports.isFactory = function (object) {
	  return object && typeof object.factory === 'function';
	};


/***/ },
/* 6 */
/***/ function(module, exports, __webpack_require__) {

	var typedFunction = __webpack_require__(7);
	var digits = __webpack_require__(8).digits;

	// returns a new instance of typed-function
	var createTyped = function () {
	  // initially, return the original instance of typed-function
	  // consecutively, return a new instance from typed.create.
	  createTyped = typedFunction.create;
	  return typedFunction;
	};

	/**
	 * Factory function for creating a new typed instance
	 * @param {Object} type   Object with data types like Complex and BigNumber
	 * @returns {Function}
	 */
	exports.create = function create(type) {
	  // TODO: typed-function must be able to silently ignore signatures with unknown data types

	  // get a new instance of typed-function
	  var typed = createTyped();

	  // define all types. The order of the types determines in which order function
	  // arguments are type-checked (so for performance it's important to put the
	  // most used types first).
	  typed.types = [
	    { name: 'number',               test: function (x) { return typeof x === 'number'; } },
	    { name: 'Complex',              test: function (x) { return x && x.isComplex; } },
	    { name: 'BigNumber',            test: function (x) { return x && x.isBigNumber; } },
	    { name: 'Fraction',             test: function (x) { return x && x.isFraction; } },
	    { name: 'Unit',                 test: function (x) { return x && x.isUnit; } },
	    { name: 'string',               test: function (x) { return typeof x === 'string'; } },
	    { name: 'Array',                test: Array.isArray },
	    { name: 'Matrix',               test: function (x) { return x && x.isMatrix; } },
	    { name: 'DenseMatrix',          test: function (x) { return x && x.isDenseMatrix; } },
	    { name: 'SparseMatrix',         test: function (x) { return x && x.isSparseMatrix; } },
	    { name: 'ImmutableDenseMatrix', test: function (x) { return x && x.isImmutableDenseMatrix; } },
	    { name: 'Range',                test: function (x) { return x && x.isRange; } },
	    { name: 'Index',                test: function (x) { return x && x.isIndex; } },
	    { name: 'boolean',              test: function (x) { return typeof x === 'boolean'; } },
	    { name: 'ResultSet',            test: function (x) { return x && x.isResultSet; } },
	    { name: 'Help',                 test: function (x) { return x && x.isHelp; } },
	    { name: 'function',             test: function (x) { return typeof x === 'function';} },
	    { name: 'Date',                 test: function (x) { return x instanceof Date; } },
	    { name: 'RegExp',               test: function (x) { return x instanceof RegExp; } },
	    { name: 'Object',               test: function (x) { return typeof x === 'object'; } },
	    { name: 'null',                 test: function (x) { return x === null; } },
	    { name: 'undefined',            test: function (x) { return x === undefined; } }
	  ];

	  // TODO: add conversion from BigNumber to number?
	  typed.conversions = [
	    {
	      from: 'number',
	      to: 'BigNumber',
	      convert: function (x) {
	        // note: conversion from number to BigNumber can fail if x has >15 digits
	        if (digits(x) > 15) {
	          throw new TypeError('Cannot implicitly convert a number with >15 significant digits to BigNumber ' +
	          '(value: ' + x + '). ' +
	          'Use function bignumber(x) to convert to BigNumber.');
	        }
	        return new type.BigNumber(x);
	      }
	    }, {
	      from: 'number',
	      to: 'Complex',
	      convert: function (x) {
	        return new type.Complex(x, 0);
	      }
	    }, {
	      from: 'number',
	      to: 'string',
	      convert: function (x) {
	        return x + '';
	      }
	    }, {
	      from: 'BigNumber',
	      to: 'Complex',
	      convert: function (x) {
	        return new type.Complex(x.toNumber(), 0);
	      }
	    }, {
	      from: 'number',
	      to: 'Fraction',
	      convert: function (x) {
	        if (digits(x) > 15) {
	          throw new TypeError('Cannot implicitly convert a number with >15 significant digits to Fraction ' +
	              '(value: ' + x + '). ' +
	              'Use function fraction(x) to convert to Fraction.');
	        }
	        return new type.Fraction(x);
	      }
	    }, {
	      from: 'string',
	      to: 'number',
	      convert: function (x) {
	        var n = Number(x);
	        if (isNaN(n)) {
	          throw new Error('Cannot convert "' + x + '" to a number');
	        }
	        return n;
	      }
	    }, {
	      from: 'boolean',
	      to: 'number',
	      convert: function (x) {
	        return +x;
	      }
	    }, {
	      from: 'boolean',
	      to: 'BigNumber',
	      convert: function (x) {
	        return new type.BigNumber(+x);
	      }
	    }, {
	      from: 'boolean',
	      to: 'string',
	      convert: function (x) {
	        return +x;
	      }
	    }, {
	      from: 'null',
	      to: 'number',
	      convert: function () {
	        return 0;
	      }
	    }, {
	      from: 'null',
	      to: 'string',
	      convert: function () {
	        return 'null';
	      }
	    }, {
	      from: 'null',
	      to: 'BigNumber',
	      convert: function () {
	        return new type.BigNumber(0);
	      }
	    }, {
	      from: 'Array',
	      to: 'Matrix',
	      convert: function (array) {
	        // TODO: how to decide on the right type of matrix to create?
	        return new type.DenseMatrix(array);
	      }
	    }, {
	      from: 'Matrix',
	      to: 'Array',
	      convert: function (matrix) {
	        return matrix.valueOf();
	      }
	    }
	  ];

	  return typed;
	};


/***/ },
/* 7 */
/***/ function(module, exports, __webpack_require__) {

	var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/**
	 * typed-function
	 *
	 * Type checking for JavaScript functions
	 *
	 * https://github.com/josdejong/typed-function
	 */
	'use strict';

	(function (factory) {
	  if (true) {
	    // AMD. Register as an anonymous module.
	    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory), __WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ? (__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__), __WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	  } else if (typeof exports === 'object') {
	    // OldNode. Does not work with strict CommonJS, but
	    // only CommonJS-like environments that support module.exports,
	    // like OldNode.
	    module.exports = factory();
	  } else {
	    // Browser globals (root is window)
	    window.typed = factory();
	  }
	}(function () {
	  // factory function to create a new instance of typed-function
	  // TODO: allow passing configuration, types, tests via the factory function
	  function create() {
	    /**
	     * Get a type test function for a specific data type
	     * @param {string} name                   Name of a data type like 'number' or 'string'
	     * @returns {Function(obj: *) : boolean}  Returns a type testing function.
	     *                                        Throws an error for an unknown type.
	     */
	    function getTypeTest(name) {
	      var test;
	      for (var i = 0; i < typed.types.length; i++) {
	        var entry = typed.types[i];
	        if (entry.name === name) {
	          test = entry.test;
	          break;
	        }
	      }

	      if (!test) {
	        var hint;
	        for (i = 0; i < typed.types.length; i++) {
	          entry = typed.types[i];
	          if (entry.name.toLowerCase() == name.toLowerCase()) {
	            hint = entry.name;
	            break;
	          }
	        }

	        throw new Error('Unknown type "' + name + '"' +
	            (hint ? ('. Did you mean "' + hint + '"?') : ''));
	      }
	      return test;
	    }

	    /**
	     * Retrieve the function name from a set of functions, and check
	     * whether the name of all functions match (if given)
	     * @param {Array.<function>} fns
	     */
	    function getName (fns) {
	      var name = '';

	      for (var i = 0; i < fns.length; i++) {
	        var fn = fns[i];

	        // merge function name
	        if (fn.name != '') {
	          if (name == '') {
	            name = fn.name;
	          }
	          else if (name != fn.name) {
	            var err = new Error('Function names do not match (expected: ' + name + ', actual: ' + fn.name + ')');
	            err.data = {
	              actual: fn.name,
	              expected: name
	            };
	            throw err;
	          }
	        }
	      }

	      return name;
	    }

	    /**
	     * Create an ArgumentsError. Creates messages like:
	     *
	     *   Unexpected type of argument (expected: ..., actual: ..., index: ...)
	     *   Too few arguments (expected: ..., index: ...)
	     *   Too many arguments (expected: ..., actual: ...)
	     *
	     * @param {String} fn         Function name
	     * @param {number} argCount   Number of arguments
	     * @param {Number} index      Current argument index
	     * @param {*} actual          Current argument
	     * @param {string} [expected] An optional, comma separated string with
	     *                            expected types on given index
	     * @extends Error
	     */
	    function createError(fn, argCount, index, actual, expected) {
	      var actualType = getTypeOf(actual);
	      var _expected = expected ? expected.split(',') : null;
	      var _fn = (fn || 'unnamed');
	      var anyType = _expected && contains(_expected, 'any');
	      var message;
	      var data = {
	        fn: fn,
	        index: index,
	        actual: actual,
	        expected: _expected
	      };

	      if (_expected) {
	        if (argCount > index && !anyType) {
	          // unexpected type
	          message = 'Unexpected type of argument in function ' + _fn +
	              ' (expected: ' + _expected.join(' or ') + ', actual: ' + actualType + ', index: ' + index + ')';
	        }
	        else {
	          // too few arguments
	          message = 'Too few arguments in function ' + _fn +
	              ' (expected: ' + _expected.join(' or ') + ', index: ' + index + ')';
	        }
	      }
	      else {
	        // too many arguments
	        message = 'Too many arguments in function ' + _fn +
	            ' (expected: ' + index + ', actual: ' + argCount + ')'
	      }

	      var err = new TypeError(message);
	      err.data = data;
	      return err;
	    }

	    /**
	     * Collection with function references (local shortcuts to functions)
	     * @constructor
	     * @param {string} [name='refs']  Optional name for the refs, used to generate
	     *                                JavaScript code
	     */
	    function Refs(name) {
	      this.name = name || 'refs';
	      this.categories = {};
	    }

	    /**
	     * Add a function reference.
	     * @param {Function} fn
	     * @param {string} [category='fn']    A function category, like 'fn' or 'signature'
	     * @returns {string} Returns the function name, for example 'fn0' or 'signature2'
	     */
	    Refs.prototype.add = function (fn, category) {
	      var cat = category || 'fn';
	      if (!this.categories[cat]) this.categories[cat] = [];

	      var index = this.categories[cat].indexOf(fn);
	      if (index == -1) {
	        index = this.categories[cat].length;
	        this.categories[cat].push(fn);
	      }

	      return cat + index;
	    };

	    /**
	     * Create code lines for all function references
	     * @returns {string} Returns the code containing all function references
	     */
	    Refs.prototype.toCode = function () {
	      var code = [];
	      var path = this.name + '.categories';
	      var categories = this.categories;

	      for (var cat in categories) {
	        if (categories.hasOwnProperty(cat)) {
	          var category = categories[cat];

	          for (var i = 0; i < category.length; i++) {
	            code.push('var ' + cat + i + ' = ' + path + '[\'' + cat + '\'][' + i + '];');
	          }
	        }
	      }

	      return code.join('\n');
	    };

	    /**
	     * A function parameter
	     * @param {string | string[] | Param} types    A parameter type like 'string',
	     *                                             'number | boolean'
	     * @param {boolean} [varArgs=false]            Variable arguments if true
	     * @constructor
	     */
	    function Param(types, varArgs) {
	      // parse the types, can be a string with types separated by pipe characters |
	      if (typeof types === 'string') {
	        // parse variable arguments operator (ellipses '...number')
	        var _types = types.trim();
	        var _varArgs = _types.substr(0, 3) === '...';
	        if (_varArgs) {
	          _types = _types.substr(3);
	        }
	        if (_types === '') {
	          this.types = ['any'];
	        }
	        else {
	          this.types = _types.split('|');
	          for (var i = 0; i < this.types.length; i++) {
	            this.types[i] = this.types[i].trim();
	          }
	        }
	      }
	      else if (Array.isArray(types)) {
	        this.types = types;
	      }
	      else if (types instanceof Param) {
	        return types.clone();
	      }
	      else {
	        throw new Error('String or Array expected');
	      }

	      // can hold a type to which to convert when handling this parameter
	      this.conversions = [];
	      // TODO: implement better API for conversions, be able to add conversions via constructor (support a new type Object?)

	      // variable arguments
	      this.varArgs = _varArgs || varArgs || false;

	      // check for any type arguments
	      this.anyType = this.types.indexOf('any') !== -1;
	    }

	    /**
	     * Order Params
	     * any type ('any') will be ordered last, and object as second last (as other
	     * types may be an object as well, like Array).
	     *
	     * @param {Param} a
	     * @param {Param} b
	     * @returns {number} Returns 1 if a > b, -1 if a < b, and else 0.
	     */
	    Param.compare = function (a, b) {
	      // TODO: simplify parameter comparison, it's a mess
	      if (a.anyType) return 1;
	      if (b.anyType) return -1;

	      if (contains(a.types, 'Object')) return 1;
	      if (contains(b.types, 'Object')) return -1;

	      if (a.hasConversions()) {
	        if (b.hasConversions()) {
	          var i, ac, bc;

	          for (i = 0; i < a.conversions.length; i++) {
	            if (a.conversions[i] !== undefined) {
	              ac = a.conversions[i];
	              break;
	            }
	          }

	          for (i = 0; i < b.conversions.length; i++) {
	            if (b.conversions[i] !== undefined) {
	              bc = b.conversions[i];
	              break;
	            }
	          }

	          return typed.conversions.indexOf(ac) - typed.conversions.indexOf(bc);
	        }
	        else {
	          return 1;
	        }
	      }
	      else {
	        if (b.hasConversions()) {
	          return -1;
	        }
	        else {
	          // both params have no conversions
	          var ai, bi;

	          for (i = 0; i < typed.types.length; i++) {
	            if (typed.types[i].name === a.types[0]) {
	              ai = i;
	              break;
	            }
	          }

	          for (i = 0; i < typed.types.length; i++) {
	            if (typed.types[i].name === b.types[0]) {
	              bi = i;
	              break;
	            }
	          }

	          return ai - bi;
	        }
	      }
	    };

	    /**
	     * Test whether this parameters types overlap an other parameters types.
	     * @param {Param} other
	     * @return {boolean} Returns true when there are conflicting types
	     */
	    Param.prototype.overlapping = function (other) {
	      for (var i = 0; i < this.types.length; i++) {
	        if (contains(other.types, this.types[i])) {
	          return true;
	        }
	      }
	      return false;
	    };

	    /**
	     * Create a clone of this param
	     * @returns {Param} Returns a cloned version of this param
	     */
	    Param.prototype.clone = function () {
	      var param = new Param(this.types.slice(), this.varArgs);
	      param.conversions = this.conversions.slice();
	      return param;
	    };

	    /**
	     * Test whether this parameter contains conversions
	     * @returns {boolean} Returns true if the parameter contains one or
	     *                    multiple conversions.
	     */
	    Param.prototype.hasConversions = function () {
	      return this.conversions.length > 0;
	    };

	    /**
	     * Tests whether this parameters contains any of the provided types
	     * @param {Object} types  A Map with types, like {'number': true}
	     * @returns {boolean}     Returns true when the parameter contains any
	     *                        of the provided types
	     */
	    Param.prototype.contains = function (types) {
	      for (var i = 0; i < this.types.length; i++) {
	        if (types[this.types[i]]) {
	          return true;
	        }
	      }
	      return false;
	    };

	    /**
	     * Return a string representation of this params types, like 'string' or
	     * 'number | boolean' or '...number'
	     * @param {boolean} [toConversion]   If true, the returned types string
	     *                                   contains the types where the parameter
	     *                                   will convert to. If false (default)
	     *                                   the "from" types are returned
	     * @returns {string}
	     */
	    Param.prototype.toString = function (toConversion) {
	      var types = [];
	      var keys = {};

	      for (var i = 0; i < this.types.length; i++) {
	        var conversion = this.conversions[i];
	        var type = toConversion && conversion ? conversion.to : this.types[i];
	        if (!(type in keys)) {
	          keys[type] = true;
	          types.push(type);
	        }
	      }

	      return (this.varArgs ? '...' : '') + types.join('|');
	    };

	    /**
	     * A function signature
	     * @param {string | string[] | Param[]} params
	     *                         Array with the type(s) of each parameter,
	     *                         or a comma separated string with types
	     * @param {Function} fn    The actual function
	     * @constructor
	     */
	    function Signature(params, fn) {
	      var _params;
	      if (typeof params === 'string') {
	        _params = (params !== '') ? params.split(',') : [];
	      }
	      else if (Array.isArray(params)) {
	        _params = params;
	      }
	      else {
	        throw new Error('string or Array expected');
	      }

	      this.params = new Array(_params.length);
	      for (var i = 0; i < _params.length; i++) {
	        var param = new Param(_params[i]);
	        this.params[i] = param;
	        if (i === _params.length - 1) {
	          // the last argument
	          this.varArgs = param.varArgs;
	        }
	        else {
	          // non-last argument
	          if (param.varArgs) {
	            throw new SyntaxError('Unexpected variable arguments operator "..."');
	          }
	        }
	      }

	      this.fn = fn;
	    }

	    /**
	     * Create a clone of this signature
	     * @returns {Signature} Returns a cloned version of this signature
	     */
	    Signature.prototype.clone = function () {
	      return new Signature(this.params.slice(), this.fn);
	    };

	    /**
	     * Expand a signature: split params with union types in separate signatures
	     * For example split a Signature "string | number" into two signatures.
	     * @return {Signature[]} Returns an array with signatures (at least one)
	     */
	    Signature.prototype.expand = function () {
	      var signatures = [];

	      function recurse(signature, path) {
	        if (path.length < signature.params.length) {
	          var i, newParam, conversion;

	          var param = signature.params[path.length];
	          if (param.varArgs) {
	            // a variable argument. do not split the types in the parameter
	            newParam = param.clone();

	            // add conversions to the parameter
	            // recurse for all conversions
	            for (i = 0; i < typed.conversions.length; i++) {
	              conversion = typed.conversions[i];
	              if (!contains(param.types, conversion.from) && contains(param.types, conversion.to)) {
	                var j = newParam.types.length;
	                newParam.types[j] = conversion.from;
	                newParam.conversions[j] = conversion;
	              }
	            }

	            recurse(signature, path.concat(newParam));
	          }
	          else {
	            // split each type in the parameter
	            for (i = 0; i < param.types.length; i++) {
	              recurse(signature, path.concat(new Param(param.types[i])));
	            }

	            // recurse for all conversions
	            for (i = 0; i < typed.conversions.length; i++) {
	              conversion = typed.conversions[i];
	              if (!contains(param.types, conversion.from) && contains(param.types, conversion.to)) {
	                newParam = new Param(conversion.from);
	                newParam.conversions[0] = conversion;
	                recurse(signature, path.concat(newParam));
	              }
	            }
	          }
	        }
	        else {
	          signatures.push(new Signature(path, signature.fn));
	        }
	      }

	      recurse(this, []);

	      return signatures;
	    };

	    /**
	     * Compare two signatures.
	     *
	     * When two params are equal and contain conversions, they will be sorted
	     * by lowest index of the first conversions.
	     *
	     * @param {Signature} a
	     * @param {Signature} b
	     * @returns {number} Returns 1 if a > b, -1 if a < b, and else 0.
	     */
	    Signature.compare = function (a, b) {
	      if (a.params.length > b.params.length) return 1;
	      if (a.params.length < b.params.length) return -1;

	      // count the number of conversions
	      var i;
	      var len = a.params.length; // a and b have equal amount of params
	      var ac = 0;
	      var bc = 0;
	      for (i = 0; i < len; i++) {
	        if (a.params[i].hasConversions()) ac++;
	        if (b.params[i].hasConversions()) bc++;
	      }

	      if (ac > bc) return 1;
	      if (ac < bc) return -1;

	      // compare the order per parameter
	      for (i = 0; i < a.params.length; i++) {
	        var cmp = Param.compare(a.params[i], b.params[i]);
	        if (cmp !== 0) {
	          return cmp;
	        }
	      }

	      return 0;
	    };

	    /**
	     * Test whether any of the signatures parameters has conversions
	     * @return {boolean} Returns true when any of the parameters contains
	     *                   conversions.
	     */
	    Signature.prototype.hasConversions = function () {
	      for (var i = 0; i < this.params.length; i++) {
	        if (this.params[i].hasConversions()) {
	          return true;
	        }
	      }
	      return false;
	    };

	    /**
	     * Test whether this signature should be ignored.
	     * Checks whether any of the parameters contains a type listed in
	     * typed.ignore
	     * @return {boolean} Returns true when the signature should be ignored
	     */
	    Signature.prototype.ignore = function () {
	      // create a map with ignored types
	      var types = {};
	      for (var i = 0; i < typed.ignore.length; i++) {
	        types[typed.ignore[i]] = true;
	      }

	      // test whether any of the parameters contains this type
	      for (i = 0; i < this.params.length; i++) {
	        if (this.params[i].contains(types)) {
	          return true;
	        }
	      }

	      return false;
	    };

	    /**
	     * Generate the code to invoke this signature
	     * @param {Refs} refs
	     * @param {string} prefix
	     * @returns {string} Returns code
	     */
	    Signature.prototype.toCode = function (refs, prefix) {
	      var code = [];

	      var args = new Array(this.params.length);
	      for (var i = 0; i < this.params.length; i++) {
	        var param = this.params[i];
	        var conversion = param.conversions[0];
	        if (param.varArgs) {
	          args[i] = 'varArgs';
	        }
	        else if (conversion) {
	          args[i] = refs.add(conversion.convert, 'convert') + '(arg' + i + ')';
	        }
	        else {
	          args[i] = 'arg' + i;
	        }
	      }

	      var ref = this.fn ? refs.add(this.fn, 'signature') : undefined;
	      if (ref) {
	        return prefix + 'return ' + ref + '(' + args.join(', ') + '); // signature: ' + this.params.join(', ');
	      }

	      return code.join('\n');
	    };

	    /**
	     * Return a string representation of the signature
	     * @returns {string}
	     */
	    Signature.prototype.toString = function () {
	      return this.params.join(', ');
	    };

	    /**
	     * A group of signatures with the same parameter on given index
	     * @param {Param[]} path
	     * @param {Signature} [signature]
	     * @param {Node[]} childs
	     * @constructor
	     */
	    function Node(path, signature, childs) {
	      this.path = path || [];
	      this.param = path[path.length - 1] || null;
	      this.signature = signature || null;
	      this.childs = childs || [];
	    }

	    /**
	     * Generate code for this group of signatures
	     * @param {Refs} refs
	     * @param {string} prefix
	     * @param {Node | undefined} [anyType]  Sibling of this node with any type parameter
	     * @returns {string} Returns the code as string
	     */
	    Node.prototype.toCode = function (refs, prefix, anyType) {
	      // TODO: split this function in multiple functions, it's too large
	      var code = [];

	      if (this.param) {
	        var index = this.path.length - 1;
	        var conversion = this.param.conversions[0];
	        var comment = '// type: ' + (conversion ?
	                (conversion.from + ' (convert to ' + conversion.to + ')') :
	                this.param);

	        // non-root node (path is non-empty)
	        if (this.param.varArgs) {
	          if (this.param.anyType) {
	            // variable arguments with any type
	            code.push(prefix + 'if (arguments.length > ' + index + ') {');
	            code.push(prefix + '  var varArgs = [];');
	            code.push(prefix + '  for (var i = ' + index + '; i < arguments.length; i++) {');
	            code.push(prefix + '    varArgs.push(arguments[i]);');
	            code.push(prefix + '  }');
	            code.push(this.signature.toCode(refs, prefix + '  '));
	            code.push(prefix + '}');
	          }
	          else {
	            // variable arguments with a fixed type
	            var getTests = function (types, arg) {
	              var tests = [];
	              for (var i = 0; i < types.length; i++) {
	                tests[i] = refs.add(getTypeTest(types[i]), 'test') + '(' + arg + ')';
	              }
	              return tests.join(' || ');
	            }.bind(this);

	            var allTypes = this.param.types;
	            var exactTypes = [];
	            for (var i = 0; i < allTypes.length; i++) {
	              if (this.param.conversions[i] === undefined) {
	                exactTypes.push(allTypes[i]);
	              }
	            }

	            code.push(prefix + 'if (' + getTests(allTypes, 'arg' + index) + ') { ' + comment);
	            code.push(prefix + '  var varArgs = [arg' + index + '];');
	            code.push(prefix + '  for (var i = ' + (index + 1) + '; i < arguments.length; i++) {');
	            code.push(prefix + '    if (' + getTests(exactTypes, 'arguments[i]') + ') {');
	            code.push(prefix + '      varArgs.push(arguments[i]);');

	            for (var i = 0; i < allTypes.length; i++) {
	              var conversion_i = this.param.conversions[i];
	              if (conversion_i) {
	                var test = refs.add(getTypeTest(allTypes[i]), 'test');
	                var convert = refs.add(conversion_i.convert, 'convert');
	                code.push(prefix + '    }');
	                code.push(prefix + '    else if (' + test + '(arguments[i])) {');
	                code.push(prefix + '      varArgs.push(' + convert + '(arguments[i]));');
	              }
	            }
	            code.push(prefix + '    } else {');
	            code.push(prefix + '      throw createError(name, arguments.length, i, arguments[i], \'' + exactTypes.join(',') + '\');');
	            code.push(prefix + '    }');
	            code.push(prefix + '  }');
	            code.push(this.signature.toCode(refs, prefix + '  '));
	            code.push(prefix + '}');
	          }
	        }
	        else {
	          if (this.param.anyType) {
	            // any type
	            code.push(prefix + '// type: any');
	            code.push(this._innerCode(refs, prefix, anyType));
	          }
	          else {
	            // regular type
	            var type = this.param.types[0];
	            var test = type !== 'any' ? refs.add(getTypeTest(type), 'test') : null;

	            code.push(prefix + 'if (' + test + '(arg' + index + ')) { ' + comment);
	            code.push(this._innerCode(refs, prefix + '  ', anyType));
	            code.push(prefix + '}');
	          }
	        }
	      }
	      else {
	        // root node (path is empty)
	        code.push(this._innerCode(refs, prefix, anyType));
	      }

	      return code.join('\n');
	    };

	    /**
	     * Generate inner code for this group of signatures.
	     * This is a helper function of Node.prototype.toCode
	     * @param {Refs} refs
	     * @param {string} prefix
	     * @param {Node | undefined} [anyType]  Sibling of this node with any type parameter
	     * @returns {string} Returns the inner code as string
	     * @private
	     */
	    Node.prototype._innerCode = function (refs, prefix, anyType) {
	      var code = [];
	      var i;

	      if (this.signature) {
	        code.push(prefix + 'if (arguments.length === ' + this.path.length + ') {');
	        code.push(this.signature.toCode(refs, prefix + '  '));
	        code.push(prefix + '}');
	      }

	      var nextAnyType;
	      for (i = 0; i < this.childs.length; i++) {
	        if (this.childs[i].param.anyType) {
	          nextAnyType = this.childs[i];
	          break;
	        }
	      }

	      for (i = 0; i < this.childs.length; i++) {
	        code.push(this.childs[i].toCode(refs, prefix, nextAnyType));
	      }

	      if (anyType && !this.param.anyType) {
	        code.push(anyType.toCode(refs, prefix, nextAnyType));
	      }

	      var exceptions = this._exceptions(refs, prefix);
	      if (exceptions) {
	        code.push(exceptions);
	      }

	      return code.join('\n');
	    };

	    /**
	     * Generate code to throw exceptions
	     * @param {Refs} refs
	     * @param {string} prefix
	     * @returns {string} Returns the inner code as string
	     * @private
	     */
	    Node.prototype._exceptions = function (refs, prefix) {
	      var index = this.path.length;

	      if (this.childs.length === 0) {
	        // TODO: can this condition be simplified? (we have a fall-through here)
	        return [
	          prefix + 'if (arguments.length > ' + index + ') {',
	          prefix + '  throw createError(name, arguments.length, ' + index + ', arguments[' + index + ']);',
	          prefix + '}'
	        ].join('\n');
	      }
	      else {
	        var keys = {};
	        var types = [];

	        for (var i = 0; i < this.childs.length; i++) {
	          var node = this.childs[i];
	          if (node.param) {
	            for (var j = 0; j < node.param.types.length; j++) {
	              var type = node.param.types[j];
	              if (!(type in keys) && !node.param.conversions[j]) {
	                keys[type] = true;
	                types.push(type);
	              }
	            }
	          }
	        }

	        return prefix + 'throw createError(name, arguments.length, ' + index + ', arguments[' + index + '], \'' + types.join(',') + '\');';
	      }
	    };

	    /**
	     * Split all raw signatures into an array with expanded Signatures
	     * @param {Object.<string, Function>} rawSignatures
	     * @return {Signature[]} Returns an array with expanded signatures
	     */
	    function parseSignatures(rawSignatures) {
	      // FIXME: need to have deterministic ordering of signatures, do not create via object
	      var signature;
	      var keys = {};
	      var signatures = [];
	      var i;

	      for (var types in rawSignatures) {
	        if (rawSignatures.hasOwnProperty(types)) {
	          var fn = rawSignatures[types];
	          signature = new Signature(types, fn);

	          if (signature.ignore()) {
	            continue;
	          }

	          var expanded = signature.expand();

	          for (i = 0; i < expanded.length; i++) {
	            var signature_i = expanded[i];
	            var key = signature_i.toString();
	            var existing = keys[key];
	            if (!existing) {
	              keys[key] = signature_i;
	            }
	            else {
	              var cmp = Signature.compare(signature_i, existing);
	              if (cmp < 0) {
	                // override if sorted first
	                keys[key] = signature_i;
	              }
	              else if (cmp === 0) {
	                throw new Error('Signature "' + key + '" is defined twice');
	              }
	              // else: just ignore
	            }
	          }
	        }
	      }

	      // convert from map to array
	      for (key in keys) {
	        if (keys.hasOwnProperty(key)) {
	          signatures.push(keys[key]);
	        }
	      }

	      // order the signatures
	      signatures.sort(function (a, b) {
	        return Signature.compare(a, b);
	      });

	      // filter redundant conversions from signatures with varArgs
	      // TODO: simplify this loop or move it to a separate function
	      for (i = 0; i < signatures.length; i++) {
	        signature = signatures[i];

	        if (signature.varArgs) {
	          var index = signature.params.length - 1;
	          var param = signature.params[index];

	          var t = 0;
	          while (t < param.types.length) {
	            if (param.conversions[t]) {
	              var type = param.types[t];

	              for (var j = 0; j < signatures.length; j++) {
	                var other = signatures[j];
	                var p = other.params[index];

	                if (other !== signature &&
	                    p &&
	                    contains(p.types, type) && !p.conversions[index]) {
	                  // this (conversion) type already exists, remove it
	                  param.types.splice(t, 1);
	                  param.conversions.splice(t, 1);
	                  t--;
	                  break;
	                }
	              }
	            }
	            t++;
	          }
	        }
	      }

	      return signatures;
	    }

	    /**
	     * create a map with normalized signatures as key and the function as value
	     * @param {Signature[]} signatures   An array with split signatures
	     * @return {Object.<string, Function>} Returns a map with normalized
	     *                                     signatures as key, and the function
	     *                                     as value.
	     */
	    function mapSignatures(signatures) {
	      var normalized = {};

	      for (var i = 0; i < signatures.length; i++) {
	        var signature = signatures[i];
	        if (signature.fn && !signature.hasConversions()) {
	          var params = signature.params.join(',');
	          normalized[params] = signature.fn;
	        }
	      }

	      return normalized;
	    }

	    /**
	     * Parse signatures recursively in a node tree.
	     * @param {Signature[]} signatures  Array with expanded signatures
	     * @param {Param[]} path            Traversed path of parameter types
	     * @return {Node}                   Returns a node tree
	     */
	    function parseTree(signatures, path) {
	      var i, signature;
	      var index = path.length;
	      var nodeSignature;

	      var filtered = [];
	      for (i = 0; i < signatures.length; i++) {
	        signature = signatures[i];

	        // filter the first signature with the correct number of params
	        if (signature.params.length === index && !nodeSignature) {
	          nodeSignature = signature;
	        }

	        if (signature.params[index] != undefined) {
	          filtered.push(signature);
	        }
	      }

	      // sort the filtered signatures by param
	      filtered.sort(function (a, b) {
	        return Param.compare(a.params[index], b.params[index]);
	      });

	      // recurse over the signatures
	      var entries = [];
	      for (i = 0; i < filtered.length; i++) {
	        signature = filtered[i];
	        // group signatures with the same param at current index
	        var param = signature.params[index];

	        // TODO: replace the next filter loop
	        var existing = entries.filter(function (entry) {
	          return entry.param.overlapping(param);
	        })[0];

	        //var existing;
	        //for (var j = 0; j < entries.length; j++) {
	        //  if (entries[j].param.overlapping(param)) {
	        //    existing = entries[j];
	        //    break;
	        //  }
	        //}

	        if (existing) {
	          if (existing.param.varArgs) {
	            throw new Error('Conflicting types "' + existing.param + '" and "' + param + '"');
	          }
	          existing.signatures.push(signature);
	        }
	        else {
	          entries.push({
	            param: param,
	            signatures: [signature]
	          });
	        }
	      }

	      // parse the childs
	      var childs = new Array(entries.length);
	      for (i = 0; i < entries.length; i++) {
	        var entry = entries[i];
	        childs[i] = parseTree(entry.signatures, path.concat(entry.param))
	      }

	      return new Node(path, nodeSignature, childs);
	    }

	    /**
	     * Generate an array like ['arg0', 'arg1', 'arg2']
	     * @param {number} count Number of arguments to generate
	     * @returns {Array} Returns an array with argument names
	     */
	    function getArgs(count) {
	      // create an array with all argument names
	      var args = [];
	      for (var i = 0; i < count; i++) {
	        args[i] = 'arg' + i;
	      }

	      return args;
	    }

	    /**
	     * Compose a function from sub-functions each handling a single type signature.
	     * Signatures:
	     *   typed(signature: string, fn: function)
	     *   typed(name: string, signature: string, fn: function)
	     *   typed(signatures: Object.<string, function>)
	     *   typed(name: string, signatures: Object.<string, function>)
	     *
	     * @param {string | null} name
	     * @param {Object.<string, Function>} signatures
	     * @return {Function} Returns the typed function
	     * @private
	     */
	    function _typed(name, signatures) {
	      var refs = new Refs();

	      // parse signatures, expand them
	      var _signatures = parseSignatures(signatures);
	      if (_signatures.length == 0) {
	        throw new Error('No signatures provided');
	      }

	      // parse signatures into a node tree
	      var node = parseTree(_signatures, []);

	      //var util = require('util');
	      //console.log('ROOT');
	      //console.log(util.inspect(node, { depth: null }));

	      // generate code for the typed function
	      var code = [];
	      var _name = name || '';
	      var _args = getArgs(maxParams(_signatures));
	      code.push('function ' + _name + '(' + _args.join(', ') + ') {');
	      code.push('  "use strict";');
	      code.push('  var name = \'' + _name + '\';');
	      code.push(node.toCode(refs, '  '));
	      code.push('}');

	      // generate body for the factory function
	      var body = [
	        refs.toCode(),
	        'return ' + code.join('\n')
	      ].join('\n');

	      // evaluate the JavaScript code and attach function references
	      var factory = (new Function(refs.name, 'createError', body));
	      var fn = factory(refs, createError);

	      //console.log('FN\n' + fn.toString()); // TODO: cleanup

	      // attach the signatures with sub-functions to the constructed function
	      fn.signatures = mapSignatures(_signatures);

	      return fn;
	    }

	    /**
	     * Calculate the maximum number of parameters in givens signatures
	     * @param {Signature[]} signatures
	     * @returns {number} The maximum number of parameters
	     */
	    function maxParams(signatures) {
	      var max = 0;

	      for (var i = 0; i < signatures.length; i++) {
	        var len = signatures[i].params.length;
	        if (len > max) {
	          max = len;
	        }
	      }

	      return max;
	    }

	    /**
	     * Get the type of a value
	     * @param {*} x
	     * @returns {string} Returns a string with the type of value
	     */
	    function getTypeOf(x) {
	      var obj;

	      for (var i = 0; i < typed.types.length; i++) {
	        var entry = typed.types[i];

	        if (entry.name === 'Object') {
	          // Array and Date are also Object, so test for Object afterwards
	          obj = entry;
	        }
	        else {
	          if (entry.test(x)) return entry.name;
	        }
	      }

	      // at last, test whether an object
	      if (obj && obj.test(x)) return obj.name;

	      return 'unknown';
	    }

	    /**
	     * Test whether an array contains some entry
	     * @param {Array} array
	     * @param {*} entry
	     * @return {boolean} Returns true if array contains entry, false if not.
	     */
	    function contains(array, entry) {
	      return array.indexOf(entry) !== -1;
	    }

	    // data type tests
	    var types = [
	      { name: 'number',    test: function (x) { return typeof x === 'number' } },
	      { name: 'string',    test: function (x) { return typeof x === 'string' } },
	      { name: 'boolean',   test: function (x) { return typeof x === 'boolean' } },
	      { name: 'Function',  test: function (x) { return typeof x === 'function'} },
	      { name: 'Array',     test: Array.isArray },
	      { name: 'Date',      test: function (x) { return x instanceof Date } },
	      { name: 'RegExp',    test: function (x) { return x instanceof RegExp } },
	      { name: 'Object',    test: function (x) { return typeof x === 'object' } },
	      { name: 'null',      test: function (x) { return x === null } },
	      { name: 'undefined', test: function (x) { return x === undefined } }
	    ];

	    // configuration
	    var config = {};

	    // type conversions. Order is important
	    var conversions = [];

	    // types to be ignored
	    var ignore = [];

	    // temporary object for holding types and conversions, for constructing
	    // the `typed` function itself
	    // TODO: find a more elegant solution for this
	    var typed = {
	      config: config,
	      types: types,
	      conversions: conversions,
	      ignore: ignore
	    };

	    /**
	     * Construct the typed function itself with various signatures
	     *
	     * Signatures:
	     *
	     *   typed(signatures: Object.<string, function>)
	     *   typed(name: string, signatures: Object.<string, function>)
	     */
	    typed = _typed('typed', {
	      'Object': function (signatures) {
	        var fns = [];
	        for (var signature in signatures) {
	          if (signatures.hasOwnProperty(signature)) {
	            fns.push(signatures[signature]);
	          }
	        }
	        var name = getName(fns);

	        return _typed(name, signatures);
	      },
	      'string, Object': _typed,
	      // TODO: add a signature 'Array.<function>'
	      '...Function': function (fns) {
	        var err;
	        var name = getName(fns);
	        var signatures = {};

	        for (var i = 0; i < fns.length; i++) {
	          var fn = fns[i];

	          // test whether this is a typed-function
	          if (!(typeof fn.signatures === 'object')) {
	            err = new TypeError('Function is no typed-function (index: ' + i + ')');
	            err.data = {index: i};
	            throw err;
	          }

	          // merge the signatures
	          for (var signature in fn.signatures) {
	            if (fn.signatures.hasOwnProperty(signature)) {
	              if (signatures.hasOwnProperty(signature)) {
	                if (fn.signatures[signature] !== signatures[signature]) {
	                  err = new Error('Signature "' + signature + '" is defined twice');
	                  err.data = {signature: signature};
	                  throw err;
	                }
	                // else: both signatures point to the same function, that's fine
	              }
	              else {
	                signatures[signature] = fn.signatures[signature];
	              }
	            }
	          }
	        }

	        return _typed(name, signatures);
	      }
	    });

	    /**
	     * Find a specific signature from a (composed) typed function, for
	     * example:
	     *
	     *   typed.find(fn, ['number', 'string'])
	     *   typed.find(fn, 'number, string')
	     *
	     * Function find only only works for exact matches.
	     *
	     * @param {Function} fn                   A typed-function
	     * @param {string | string[]} signature   Signature to be found, can be
	     *                                        an array or a comma separated string.
	     * @return {Function}                     Returns the matching signature, or
	     *                                        throws an errror when no signature
	     *                                        is found.
	     */
	    function find (fn, signature) {
	      if (!fn.signatures) {
	        throw new TypeError('Function is no typed-function');
	      }

	      // normalize input
	      var arr;
	      if (typeof signature === 'string') {
	        arr = signature.split(',');
	        for (var i = 0; i < arr.length; i++) {
	          arr[i] = arr[i].trim();
	        }
	      }
	      else if (Array.isArray(signature)) {
	        arr = signature;
	      }
	      else {
	        throw new TypeError('String array or a comma separated string expected');
	      }

	      var str = arr.join(',');

	      // find an exact match
	      var match = fn.signatures[str];
	      if (match) {
	        return match;
	      }

	      // TODO: extend find to match non-exact signatures

	      throw new TypeError('Signature not found (signature: ' + (fn.name || 'unnamed') + '(' + arr.join(', ') + '))');
	    }

	    /**
	     * Convert a given value to another data type.
	     * @param {*} value
	     * @param {string} type
	     */
	    function convert (value, type) {
	      var from = getTypeOf(value);
	      
	      // check conversion is needed
	      if (type === from) {
	        return value;
	      }

	      for (var i = 0; i < typed.conversions.length; i++) {
	        var conversion = typed.conversions[i];
	        if (conversion.from === from && conversion.to === type) {
	          return conversion.convert(value);
	        }
	      }

	      throw new Error('Cannot convert from ' + from + ' to ' + type);
	    }

	    // attach types and conversions to the final `typed` function
	    typed.config = config;
	    typed.types = types;
	    typed.conversions = conversions;
	    typed.ignore = ignore;
	    typed.create = create;
	    typed.find = find;
	    typed.convert = convert;

	    // add a type
	    typed.addType = function (type) {
	      if (!type || typeof type.name !== 'string' || typeof type.test !== 'function') {
	        throw new TypeError('Object with properties {name: string, test: function} expected');
	      }

	      typed.types.push(type);
	    };

	    // add a conversion
	    typed.addConversion = function (conversion) {
	      if (!conversion
	          || typeof conversion.from !== 'string'
	          || typeof conversion.to !== 'string'
	          || typeof conversion.convert !== 'function') {
	        throw new TypeError('Object with properties {from: string, to: string, convert: function} expected');
	      }

	      typed.conversions.push(conversion);
	    };

	    return typed;
	  }

	  return create();
	}));


/***/ },
/* 8 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var NumberFormatter = __webpack_require__(9);

	/**
	 * Test whether value is a number
	 * @param {*} value
	 * @return {boolean} isNumber
	 */
	exports.isNumber = function(value) {
	  return typeof value === 'number';
	};

	/**
	 * Check if a number is integer
	 * @param {number | boolean} value
	 * @return {boolean} isInteger
	 */
	exports.isInteger = function(value) {
	  return isFinite(value)
	      ? (value == Math.round(value))
	      : false;
	  // Note: we use ==, not ===, as we can have Booleans as well
	};

	/**
	 * Calculate the sign of a number
	 * @param {number} x
	 * @returns {*}
	 */
	exports.sign = function(x) {
	  if (x > 0) {
	    return 1;
	  }
	  else if (x < 0) {
	    return -1;
	  }
	  else {
	    return 0;
	  }
	};

	/**
	 * Convert a number to a formatted string representation.
	 *
	 * Syntax:
	 *
	 *    format(value)
	 *    format(value, options)
	 *    format(value, precision)
	 *    format(value, fn)
	 *
	 * Where:
	 *
	 *    {number} value   The value to be formatted
	 *    {Object} options An object with formatting options. Available options:
	 *                     {string} notation
	 *                         Number notation. Choose from:
	 *                         'fixed'          Always use regular number notation.
	 *                                          For example '123.40' and '14000000'
	 *                         'exponential'    Always use exponential notation.
	 *                                          For example '1.234e+2' and '1.4e+7'
	 *                         'auto' (default) Regular number notation for numbers
	 *                                          having an absolute value between
	 *                                          `lower` and `upper` bounds, and uses
	 *                                          exponential notation elsewhere.
	 *                                          Lower bound is included, upper bound
	 *                                          is excluded.
	 *                                          For example '123.4' and '1.4e7'.
	 *                     {number} precision   A number between 0 and 16 to round
	 *                                          the digits of the number.
	 *                                          In case of notations 'exponential' and
	 *                                          'auto', `precision` defines the total
	 *                                          number of significant digits returned
	 *                                          and is undefined by default.
	 *                                          In case of notation 'fixed',
	 *                                          `precision` defines the number of
	 *                                          significant digits after the decimal
	 *                                          point, and is 0 by default.
	 *                     {Object} exponential An object containing two parameters,
	 *                                          {number} lower and {number} upper,
	 *                                          used by notation 'auto' to determine
	 *                                          when to return exponential notation.
	 *                                          Default values are `lower=1e-3` and
	 *                                          `upper=1e5`.
	 *                                          Only applicable for notation `auto`.
	 *    {Function} fn    A custom formatting function. Can be used to override the
	 *                     built-in notations. Function `fn` is called with `value` as
	 *                     parameter and must return a string. Is useful for example to
	 *                     format all values inside a matrix in a particular way.
	 *
	 * Examples:
	 *
	 *    format(6.4);                                        // '6.4'
	 *    format(1240000);                                    // '1.24e6'
	 *    format(1/3);                                        // '0.3333333333333333'
	 *    format(1/3, 3);                                     // '0.333'
	 *    format(21385, 2);                                   // '21000'
	 *    format(12.071, {notation: 'fixed'});                // '12'
	 *    format(2.3,    {notation: 'fixed', precision: 2});  // '2.30'
	 *    format(52.8,   {notation: 'exponential'});          // '5.28e+1'
	 *
	 * @param {number} value
	 * @param {Object | Function | number} [options]
	 * @return {string} str The formatted value
	 */
	exports.format = function(value, options) {
	  if (typeof options === 'function') {
	    // handle format(value, fn)
	    return options(value);
	  }

	  // handle special cases
	  if (value === Infinity) {
	    return 'Infinity';
	  }
	  else if (value === -Infinity) {
	    return '-Infinity';
	  }
	  else if (isNaN(value)) {
	    return 'NaN';
	  }

	  // default values for options
	  var notation = 'auto';
	  var precision = undefined;

	  if (options) {
	    // determine notation from options
	    if (options.notation) {
	      notation = options.notation;
	    }

	    // determine precision from options
	    if (exports.isNumber(options)) {
	      precision = options;
	    }
	    else if (options.precision) {
	      precision = options.precision;
	    }
	  }

	  // handle the various notations
	  switch (notation) {
	    case 'fixed':
	      return exports.toFixed(value, precision);

	    case 'exponential':
	      return exports.toExponential(value, precision);

	    case 'auto':
	      return exports
	          .toPrecision(value, precision, options && options.exponential)

	          // remove trailing zeros after the decimal point
	          .replace(/((\.\d*?)(0+))($|e)/, function () {
	            var digits = arguments[2];
	            var e = arguments[4];
	            return (digits !== '.') ? digits + e : e;
	          });

	    default:
	      throw new Error('Unknown notation "' + notation + '". ' +
	          'Choose "auto", "exponential", or "fixed".');
	  }
	};

	/**
	 * Format a number in exponential notation. Like '1.23e+5', '2.3e+0', '3.500e-3'
	 * @param {number} value
	 * @param {number} [precision]  Number of digits in formatted output.
	 *                              If not provided, the maximum available digits
	 *                              is used.
	 * @returns {string} str
	 */
	exports.toExponential = function(value, precision) {
	  return new NumberFormatter(value).toExponential(precision);
	};

	/**
	 * Format a number with fixed notation.
	 * @param {number} value
	 * @param {number} [precision=0]        Optional number of decimals after the
	 *                                      decimal point. Zero by default.
	 */
	exports.toFixed = function(value, precision) {
	  return new NumberFormatter(value).toFixed(precision);
	};

	/**
	 * Format a number with a certain precision
	 * @param {number} value
	 * @param {number} [precision=undefined] Optional number of digits.
	 * @param {{lower: number, upper: number}} [options]  By default:
	 *                                                    lower = 1e-3 (excl)
	 *                                                    upper = 1e+5 (incl)
	 * @return {string}
	 */
	exports.toPrecision = function(value, precision, options) {
	  return new NumberFormatter(value).toPrecision(precision, options);
	};

	/**
	 * Count the number of significant digits of a number.
	 *
	 * For example:
	 *   2.34 returns 3
	 *   0.0034 returns 2
	 *   120.5e+30 returns 4
	 *
	 * @param {number} value
	 * @return {number} digits   Number of significant digits
	 */
	exports.digits = function(value) {
	  return value
	      .toExponential()
	      .replace(/e.*$/, '')          // remove exponential notation
	      .replace( /^0\.?0*|\./, '')   // remove decimal point and leading zeros
	      .length
	};

	/**
	 * Minimum number added to one that makes the result different than one
	 */
	exports.DBL_EPSILON = Number.EPSILON || 2.2204460492503130808472633361816E-16;

	/**
	 * Compares two floating point numbers.
	 * @param {number} x          First value to compare
	 * @param {number} y          Second value to compare
	 * @param {number} [epsilon]  The maximum relative difference between x and y
	 *                            If epsilon is undefined or null, the function will
	 *                            test whether x and y are exactly equal.
	 * @return {boolean} whether the two numbers are equal
	*/
	exports.nearlyEqual = function(x, y, epsilon) {
	  // if epsilon is null or undefined, test whether x and y are exactly equal
	  if (epsilon == null) return x == y;

	  // use "==" operator, handles infinities
	  if (x == y) return true;

	  // NaN
	  if (isNaN(x) || isNaN(y)) return false;

	  // at this point x and y should be finite
	  if(isFinite(x) && isFinite(y)) {
	    // check numbers are very close, needed when comparing numbers near zero
	    var diff = Math.abs(x - y);
	    if (diff < exports.DBL_EPSILON) {
	      return true;
	    }
	    else {
	      // use relative error
	      return diff <= Math.max(Math.abs(x), Math.abs(y)) * epsilon;
	    }
	  }

	  // Infinite and Number or negative Infinite and positive Infinite cases
	  return false;
	};


/***/ },
/* 9 */
/***/ function(module, exports) {

	'use strict';

	/**
	 * Format a number using methods toPrecision, toFixed, toExponential.
	 * @param {number | string} value
	 * @constructor
	 */
	function NumberFormatter (value) {
	  // parse the input value
	  var match = String(value).toLowerCase().match(/^0*?(-?)(\d+\.?\d*)(e([+-]?\d+))?$/);
	  if (!match) {
	    throw new SyntaxError('Invalid number');
	  }

	  var sign         = match[1];
	  var coefficients = match[2];
	  var exponent     = parseFloat(match[4] || '0');

	  var dot = coefficients.indexOf('.');
	  exponent += (dot !== -1) ? (dot - 1) : (coefficients.length - 1);

	  this.sign = sign;
	  this.coefficients = coefficients
	      .replace('.', '')  // remove the dot (must be removed before removing leading zeros)
	      .replace(/^0*/, function (zeros) {
	        // remove leading zeros, add their count to the exponent
	        exponent -= zeros.length;
	        return '';
	      })
	      .replace(/0*$/, '') // remove trailing zeros
	      .split('')
	      .map(function (d) {
	        return parseInt(d);
	      });

	  if (this.coefficients.length === 0) {
	    this.coefficients.push(0);
	    exponent++;
	  }

	  this.exponent = exponent;
	}

	/**
	 * Format a number with fixed notation.
	 * @param {number} [precision=0]        Optional number of decimals after the
	 *                                      decimal point. Zero by default.
	 */
	NumberFormatter.prototype.toFixed = function (precision) {
	  var rounded = this.roundDigits(this.exponent + 1 + (precision || 0));
	  var c = rounded.coefficients;
	  var p = rounded.exponent + 1; // exponent may have changed

	  // append zeros if needed
	  var pp = p + (precision || 0);
	  if (c.length < pp) {
	    c = c.concat(zeros(pp - c.length));
	  }

	  // prepend zeros if needed
	  if (p < 0) {
	    c = zeros(-p + 1).concat(c);
	    p = 1;
	  }

	  // insert a dot if needed
	  if (precision) {
	    c.splice(p, 0, (p === 0) ? '0.' : '.');
	  }

	  return this.sign + c.join('');
	};

	/**
	 * Format a number in exponential notation. Like '1.23e+5', '2.3e+0', '3.500e-3'
	 * @param {number} [precision]  Number of digits in formatted output.
	 *                              If not provided, the maximum available digits
	 *                              is used.
	 */
	NumberFormatter.prototype.toExponential = function (precision) {
	  // round if needed, else create a clone
	  var rounded = precision ? this.roundDigits(precision) : this.clone();
	  var c = rounded.coefficients;
	  var e = rounded.exponent;

	  // append zeros if needed
	  if (c.length < precision) {
	    c = c.concat(zeros(precision - c.length));
	  }

	  // format as `C.CCCe+EEE` or `C.CCCe-EEE`
	  var first = c.shift();
	  return this.sign + first + (c.length > 0 ? ('.' + c.join('')) : '') +
	      'e' + (e >= 0 ? '+' : '') + e;
	};

	/**
	 * Format a number with a certain precision
	 * @param {number} [precision=undefined] Optional number of digits.
	 * @param {{lower: number | undefined, upper: number | undefined}} [options]
	 *                                       By default:
	 *                                         lower = 1e-3 (excl)
	 *                                         upper = 1e+5 (incl)
	 * @return {string}
	 */
	NumberFormatter.prototype.toPrecision = function(precision, options) {
	  // determine lower and upper bound for exponential notation.
	  var lower = (options && options.lower !== undefined) ? options.lower : 1e-3;
	  var upper = (options && options.upper !== undefined) ? options.upper : 1e+5;

	  var abs = Math.abs(Math.pow(10, this.exponent));
	  if (abs < lower || abs >= upper) {
	    // exponential notation
	    return this.toExponential(precision);
	  }
	  else {
	    var rounded = precision ? this.roundDigits(precision) : this.clone();
	    var c = rounded.coefficients;
	    var e = rounded.exponent;

	    // append trailing zeros
	    if (c.length < precision) {
	      c = c.concat(zeros(precision - c.length));
	    }

	    // append trailing zeros
	    // TODO: simplify the next statement
	    c = c.concat(zeros(e - c.length + 1 +
	        (c.length < precision ? precision - c.length : 0)));

	    // prepend zeros
	    c = zeros(-e).concat(c);

	    var dot = e > 0 ? e : 0;
	    if (dot < c.length - 1) {
	      c.splice(dot + 1, 0, '.');
	    }

	    return this.sign + c.join('');
	  }
	};

	/**
	 * Crete a clone of the NumberFormatter
	 * @return {NumberFormatter} Returns a clone of the NumberFormatter
	 */
	NumberFormatter.prototype.clone = function () {
	  var clone = new NumberFormatter('0');
	  clone.sign = this.sign;
	  clone.coefficients = this.coefficients.slice(0);
	  clone.exponent = this.exponent;
	  return clone;
	};

	/**
	 * Round the number of digits of a number *
	 * @param {number} precision  A positive integer
	 * @return {NumberFormatter}  Returns a new NumberFormatter with the rounded
	 *                            digits
	 */
	NumberFormatter.prototype.roundDigits = function (precision) {
	  var rounded = this.clone();
	  var c = rounded.coefficients;

	  // prepend zeros if needed
	  while (precision <= 0) {
	    c.unshift(0);
	    rounded.exponent++;
	    precision++;
	  }

	  if (c.length > precision) {
	    var removed = c.splice(precision);

	    if (removed[0] >= 5) {
	      var i = precision - 1;
	      c[i]++;
	      while (c[i] === 10) {
	        c.pop();
	        if (i === 0) {
	          c.unshift(0);
	          rounded.exponent++;
	          i++;
	        }
	        i--;
	        c[i]++;
	      }
	    }
	  }

	  return rounded;
	};

	/**
	 * Create an array filled with zeros.
	 * @param {number} length
	 * @return {Array}
	 */
	function zeros(length) {
	  var arr = [];
	  for (var i = 0; i < length; i++) {
	    arr.push(0);
	  }
	  return arr;
	}

	module.exports = NumberFormatter;


/***/ },
/* 10 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var lazy = __webpack_require__(5).lazy;
	var isFactory = __webpack_require__(5).isFactory;
	var traverse = __webpack_require__(5).traverse;
	var extend = __webpack_require__(5).extend;
	var ArgumentsError = __webpack_require__(11);

	function factory (type, config, load, typed, math) {
	  /**
	   * Import functions from an object or a module
	   *
	   * Syntax:
	   *
	   *    math.import(object)
	   *    math.import(object, options)
	   *
	   * Where:
	   *
	   * - `object: Object`
	   *   An object with functions to be imported.
	   * - `options: Object` An object with import options. Available options:
	   *   - `override: boolean`
	   *     If true, existing functions will be overwritten. False by default.
	   *   - `silent: boolean`
	   *     If true, the function will not throw errors on duplicates or invalid
	   *     types. False by default.
	   *   - `wrap: boolean`
	   *     If true, the functions will be wrapped in a wrapper function
	   *     which converts data types like Matrix to primitive data types like Array.
	   *     The wrapper is needed when extending math.js with libraries which do not
	   *     support these data type. False by default.
	   *
	   * Examples:
	   *
	   *    // define new functions and variables
	   *    math.import({
	   *      myvalue: 42,
	   *      hello: function (name) {
	   *        return 'hello, ' + name + '!';
	   *      }
	   *    });
	   *
	   *    // use the imported function and variable
	   *    math.myvalue * 2;               // 84
	   *    math.hello('user');             // 'hello, user!'
	   *
	   *    // import the npm module 'numbers'
	   *    // (must be installed first with `npm install numbers`)
	   *    math.import(require('numbers'), {wrap: true});
	   *
	   *    math.fibonacci(7); // returns 13
	   *
	   * @param {Object | Array} object   Object with functions to be imported.
	   * @param {Object} [options]        Import options.
	   */
	  function math_import(object, options) {
	    var num = arguments.length;
	    if (num != 1 && num != 2) {
	      throw new ArgumentsError('import', num, 1, 2);
	    }

	    if (!options) {
	      options = {};
	    }

	    if (isFactory(object)) {
	      _importFactory(object, options);
	    }
	    else if (Array.isArray(object)) {
	      object.forEach(function (entry) {
	        math_import(entry, options);
	      });
	    }
	    else if (typeof object === 'object') {
	      // a map with functions
	      for (var name in object) {
	        if (object.hasOwnProperty(name)) {
	          var value = object[name];
	          if (isSupportedType(value)) {
	            _import(name, value, options);
	          }
	          else if (isFactory(object)) {
	            _importFactory(object, options);
	          }
	          else {
	            math_import(value, options);
	          }
	        }
	      }
	    }
	    else {
	      if (!options.silent) {
	        throw new TypeError('Factory, Object, or Array expected');
	      }
	    }
	  }

	  /**
	   * Add a property to the math namespace and create a chain proxy for it.
	   * @param {string} name
	   * @param {*} value
	   * @param {Object} options  See import for a description of the options
	   * @private
	   */
	  function _import(name, value, options) {
	    if (options.wrap && typeof value === 'function') {
	      // create a wrapper around the function
	      value = _wrap(value);
	    }

	    if (isTypedFunction(math[name]) && isTypedFunction(value)) {
	      // merge two typed functions
	      if (options.override) {
	        value = typed(extend({}, math[name].signatures, value.signatures));
	      }
	      else {
	        value = typed(math[name], value);
	      }

	      math[name] = value;
	      _importTransform(name, value);
	      math.emit('import', name, function resolver() {
	        return value;
	      });
	      return;
	    }

	    if (math[name] === undefined || options.override) {
	      math[name] = value;
	      _importTransform(name, value);
	      math.emit('import', name, function resolver() {
	        return value;
	      });
	      return;
	    }

	    if (!options.silent) {
	      throw new Error('Cannot import "' + name + '": already exists');
	    }
	  }

	  function _importTransform (name, value) {
	    if (value && typeof value.transform === 'function') {
	      math.expression.transform[name] = value.transform;
	    }
	  }

	  /**
	   * Create a wrapper a round an function which converts the arguments
	   * to their primitive values (like convert a Matrix to Array)
	   * @param {Function} fn
	   * @return {Function} Returns the wrapped function
	   * @private
	   */
	  function _wrap (fn) {
	    var wrapper = function wrapper () {
	      var args = [];
	      for (var i = 0, len = arguments.length; i < len; i++) {
	        var arg = arguments[i];
	        args[i] = arg && arg.valueOf();
	      }
	      return fn.apply(math, args);
	    };

	    if (fn.transform) {
	      wrapper.transform = fn.transform;
	    }

	    return wrapper;
	  }

	  /**
	   * Import an instance of a factory into math.js
	   * @param {{factory: Function, name: string, path: string, math: boolean}} factory
	   * @param {Object} options  See import for a description of the options
	   * @private
	   */
	  function _importFactory(factory, options) {
	    if (typeof factory.name === 'string') {
	      var name = factory.name;
	      var namespace = factory.path ? traverse(math, factory.path) : math;
	      var existing = namespace.hasOwnProperty(name) ? namespace[name] : undefined;

	      var resolver = function () {
	        var instance = load(factory);

	        if (isTypedFunction(existing) && isTypedFunction(instance)) {
	          // merge two typed functions
	          if (options.override) {
	            instance = typed(extend({}, existing.signatures, instance.signatures));
	          }
	          else {
	            instance = typed(existing, instance);
	          }

	          return instance;
	        }

	        if (existing === undefined || options.override) {
	          return instance;
	        }

	        if (!options.silent) {
	          throw new Error('Cannot import "' + name + '": already exists');
	        }
	      };

	      if (factory.lazy !== false) {
	        lazy(namespace, name, resolver);
	      }
	      else {
	        namespace[name] = resolver();
	      }

	      math.emit('import', name, resolver, factory.path);
	    }
	    else {
	      // unnamed factory.
	      // no lazy loading
	      load(factory);
	    }
	  }

	  /**
	   * Check whether given object is a type which can be imported
	   * @param {Function | number | string | boolean | null | Unit | Complex} object
	   * @return {boolean}
	   * @private
	   */
	  function isSupportedType(object) {
	    return typeof object == 'function'
	        || typeof object === 'number'
	        || typeof object === 'string'
	        || typeof object === 'boolean'
	        || object === null
	        || (object && object.isUnit === true)
	        || (object && object.isComplex === true)
	  }

	  /**
	   * Test whether a given thing is a typed-function
	   * @param {*} fn
	   * @return {boolean} Returns true when `fn` is a typed-function
	   */
	  function isTypedFunction (fn) {
	    return typeof fn === 'function' && typeof fn.signatures === 'object';
	  }

	  return math_import;
	}

	exports.math = true; // request access to the math namespace as 5th argument of the factory function
	exports.name = 'import';
	exports.factory = factory;
	exports.lazy = true;


/***/ },
/* 11 */
/***/ function(module, exports) {

	'use strict';

	/**
	 * Create a syntax error with the message:
	 *     'Wrong number of arguments in function <fn> (<count> provided, <min>-<max> expected)'
	 * @param {string} fn     Function name
	 * @param {number} count  Actual argument count
	 * @param {number} min    Minimum required argument count
	 * @param {number} [max]  Maximum required argument count
	 * @extends Error
	 */
	function ArgumentsError(fn, count, min, max) {
	  if (!(this instanceof ArgumentsError)) {
	    throw new SyntaxError('Constructor must be called with the new operator');
	  }

	  this.fn = fn;
	  this.count = count;
	  this.min = min;
	  this.max = max;

	  this.message = 'Wrong number of arguments in function ' + fn +
	      ' (' + count + ' provided, ' +
	      min + ((max != undefined) ? ('-' + max) : '') + ' expected)';

	  this.stack = (new Error()).stack;
	}

	ArgumentsError.prototype = new Error();
	ArgumentsError.prototype.constructor = Error;
	ArgumentsError.prototype.name = 'ArgumentsError';
	ArgumentsError.prototype.isArgumentsError = true;

	module.exports = ArgumentsError;


/***/ },
/* 12 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var object = __webpack_require__(5);

	function factory (type, config, load, typed, math) {
	  /**
	   * Set configuration options for math.js, and get current options.
	   * Will emit a 'config' event, with arguments (curr, prev).
	   * @param {Object} [options] Available options:
	   *                            {number} epsilon
	   *                              Minimum relative difference between two
	   *                              compared values, used by all comparison functions.
	   *                            {string} matrix
	   *                              A string 'matrix' (default) or 'array'.
	   *                            {string} number
	   *                              A string 'number' (default) or 'bignumber'
	   *                            {number} precision
	   *                              The number of significant digits for BigNumbers.
	   *                              Not applicable for Numbers.
	   *                            {string} parenthesis
	   *                              How to display parentheses in LaTeX and string
	   *                              output.
	   * @return {Object} Returns the current configuration
	   */
	  return function _config(options) {
	    if (options) {
	      var prev = object.clone(config);

	      // merge options
	      object.deepExtend(config, options);

	      var curr = object.clone(config);

	      // emit 'config' event
	      math.emit('config', curr, prev);

	      return curr;
	    }
	    else {
	      return object.clone(config);
	    }
	  };
	}

	exports.name = 'config';
	exports.math = true; // request the math namespace as fifth argument
	exports.factory = factory;


/***/ },
/* 13 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = [
	  __webpack_require__(241),        // data types (Matrix, Complex, Unit, ...)
	  __webpack_require__(277),   // constants
	  __webpack_require__(279),  // expression parsing
	  __webpack_require__(14),    // functions
	  __webpack_require__(482),        // serialization utility (math.json.reviver)
	  __webpack_require__(484)        // errors
	];


/***/ },
/* 14 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = [
	  __webpack_require__(61),
	  __webpack_require__(91),
	  __webpack_require__(120),
	  __webpack_require__(136),
	  __webpack_require__(148),
	  __webpack_require__(153),
	  __webpack_require__(155),
	  __webpack_require__(15),
	  __webpack_require__(160),
	  __webpack_require__(169),
	  __webpack_require__(175),
	  __webpack_require__(187),
	  __webpack_require__(228),
	  __webpack_require__(230)
	];


/***/ },
/* 15 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = [
	  __webpack_require__(16),
	  __webpack_require__(24),
	  __webpack_require__(43),
	  __webpack_require__(46),
	  __webpack_require__(47),
	  __webpack_require__(48),
	  __webpack_require__(49),
	  __webpack_require__(50),
	  __webpack_require__(52),
	  __webpack_require__(53),
	  __webpack_require__(54),
	  __webpack_require__(55),
	  __webpack_require__(56),
	  __webpack_require__(57),
	  __webpack_require__(58),
	  __webpack_require__(59),
	  __webpack_require__(60)
	];


/***/ },
/* 16 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var clone = __webpack_require__(5).clone;
	var isInteger = __webpack_require__(8).isInteger;
	var array = __webpack_require__(18);
	var IndexError = __webpack_require__(17);
	var DimensionError = __webpack_require__(22);

	function factory (type, config, load, typed) {
	  var matrix = load(__webpack_require__(23));

	  /**
	   * Concatenate two or more matrices.
	   *
	   * Syntax:
	   *
	   *     math.concat(A, B, C, ...)
	   *     math.concat(A, B, C, ..., dim)
	   *
	   * Where:
	   *
	   * - `dim: number` is a zero-based dimension over which to concatenate the matrices.
	   *   By default the last dimension of the matrices.
	   *
	   * Examples:
	   *
	   *    var A = [[1, 2], [5, 6]];
	   *    var B = [[3, 4], [7, 8]];
	   *
	   *    math.concat(A, B);                  // returns [[1, 2, 3, 4], [5, 6, 7, 8]]
	   *    math.concat(A, B, 0);               // returns [[1, 2], [5, 6], [3, 4], [7, 8]]
	   *    math.concat('hello', ' ', 'world'); // returns 'hello world'
	   *
	   * See also:
	   *
	   *    size, squeeze, subset, transpose
	   *
	   * @param {... Array | Matrix} args     Two or more matrices
	   * @return {Array | Matrix} Concatenated matrix
	   */
	  var concat = typed('concat', {
	    // TODO: change signature to '...Array | Matrix, dim?' when supported
	    '...Array | Matrix | number | BigNumber': function (args) {
	      var i;
	      var len = args.length;
	      var dim = -1;  // zero-based dimension
	      var prevDim;
	      var asMatrix = false;
	      var matrices = [];  // contains multi dimensional arrays

	      for (i = 0; i < len; i++) {
	        var arg = args[i];

	        // test whether we need to return a Matrix (if not we return an Array)
	        if (arg && arg.isMatrix === true) {
	          asMatrix = true;
	        }

	        if (typeof arg === 'number' || (arg && arg.isBigNumber === true)) {
	          if (i !== len - 1) {
	            throw new Error('Dimension must be specified as last argument');
	          }

	          // last argument contains the dimension on which to concatenate
	          prevDim = dim;
	          dim = arg.valueOf(); // change BigNumber to number

	          if (!isInteger(dim)) {
	            throw new TypeError('Integer number expected for dimension');
	          }

	          if (dim < 0) {
	            // TODO: would be more clear when throwing a DimensionError here
	            throw new IndexError(dim);
	          }
	          if (i > 0 && dim > prevDim) {
	            // TODO: would be more clear when throwing a DimensionError here
	            throw new IndexError(dim, prevDim + 1);
	          }
	        }
	        else {
	          // this is a matrix or array
	          var m = clone(arg).valueOf();
	          var size = array.size(m);
	          matrices[i] = m;
	          prevDim = dim;
	          dim = size.length - 1;

	          // verify whether each of the matrices has the same number of dimensions
	          if (i > 0 && dim != prevDim) {
	            throw new DimensionError(prevDim + 1, dim + 1);
	          }
	        }
	      }

	      if (matrices.length == 0) {
	        throw new SyntaxError('At least one matrix expected');
	      }

	      var res = matrices.shift();
	      while (matrices.length) {
	        res = _concat(res, matrices.shift(), dim, 0);
	      }

	      return asMatrix ? matrix(res) : res;
	    },

	    '...string': function (args) {
	      return args.join('');
	    }
	  });

	  concat.toTex = '\\mathrm{${name}}\\left(${args}\\right)';

	  return concat;
	}

	/**
	 * Recursively concatenate two matrices.
	 * The contents of the matrices is not cloned.
	 * @param {Array} a             Multi dimensional array
	 * @param {Array} b             Multi dimensional array
	 * @param {number} concatDim    The dimension on which to concatenate (zero-based)
	 * @param {number} dim          The current dim (zero-based)
	 * @return {Array} c            The concatenated matrix
	 * @private
	 */
	function _concat(a, b, concatDim, dim) {
	  if (dim < concatDim) {
	    // recurse into next dimension
	    if (a.length != b.length) {
	      throw new DimensionError(a.length, b.length);
	    }

	    var c = [];
	    for (var i = 0; i < a.length; i++) {
	      c[i] = _concat(a[i], b[i], concatDim, dim + 1);
	    }
	    return c;
	  }
	  else {
	    // concatenate this dimension
	    return a.concat(b);
	  }
	}

	exports.name = 'concat';
	exports.factory = factory;


/***/ },
/* 17 */
/***/ function(module, exports) {

	'use strict';

	/**
	 * Create a range error with the message:
	 *     'Index out of range (index < min)'
	 *     'Index out of range (index < max)'
	 *
	 * @param {number} index     The actual index
	 * @param {number} [min=0]   Minimum index (included)
	 * @param {number} [max]     Maximum index (excluded)
	 * @extends RangeError
	 */
	function IndexError(index, min, max) {
	  if (!(this instanceof IndexError)) {
	    throw new SyntaxError('Constructor must be called with the new operator');
	  }

	  this.index = index;
	  if (arguments.length < 3) {
	    this.min = 0;
	    this.max = min;
	  }
	  else {
	    this.min = min;
	    this.max = max;
	  }

	  if (this.min !== undefined && this.index < this.min) {
	    this.message = 'Index out of range (' + this.index + ' < ' + this.min + ')';
	  }
	  else if (this.max !== undefined && this.index >= this.max) {
	    this.message = 'Index out of range (' + this.index + ' > ' + (this.max - 1) + ')';
	  }
	  else {
	    this.message = 'Index out of range (' + this.index + ')';
	  }

	  this.stack = (new Error()).stack;
	}

	IndexError.prototype = new RangeError();
	IndexError.prototype.constructor = RangeError;
	IndexError.prototype.name = 'IndexError';
	IndexError.prototype.isIndexError = true;

	module.exports = IndexError;


/***/ },
/* 18 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var number = __webpack_require__(8);
	var string = __webpack_require__(20);
	var object = __webpack_require__(5);
	var types = __webpack_require__(19);

	var DimensionError = __webpack_require__(22);
	var IndexError = __webpack_require__(17);

	/**
	 * Calculate the size of a multi dimensional array.
	 * This function checks the size of the first entry, it does not validate
	 * whether all dimensions match. (use function `validate` for that)
	 * @param {Array} x
	 * @Return {Number[]} size
	 */
	exports.size = function (x) {
	  var s = [];

	  while (Array.isArray(x)) {
	    s.push(x.length);
	    x = x[0];
	  }

	  return s;
	};

	/**
	 * Recursively validate whether each element in a multi dimensional array
	 * has a size corresponding to the provided size array.
	 * @param {Array} array    Array to be validated
	 * @param {number[]} size  Array with the size of each dimension
	 * @param {number} dim   Current dimension
	 * @throws DimensionError
	 * @private
	 */
	function _validate(array, size, dim) {
	  var i;
	  var len = array.length;

	  if (len != size[dim]) {
	    throw new DimensionError(len, size[dim]);
	  }

	  if (dim < size.length - 1) {
	    // recursively validate each child array
	    var dimNext = dim + 1;
	    for (i = 0; i < len; i++) {
	      var child = array[i];
	      if (!Array.isArray(child)) {
	        throw new DimensionError(size.length - 1, size.length, '<');
	      }
	      _validate(array[i], size, dimNext);
	    }
	  }
	  else {
	    // last dimension. none of the childs may be an array
	    for (i = 0; i < len; i++) {
	      if (Array.isArray(array[i])) {
	        throw new DimensionError(size.length + 1, size.length, '>');
	      }
	    }
	  }
	}

	/**
	 * Validate whether each element in a multi dimensional array has
	 * a size corresponding to the provided size array.
	 * @param {Array} array    Array to be validated
	 * @param {number[]} size  Array with the size of each dimension
	 * @throws DimensionError
	 */
	exports.validate = function(array, size) {
	  var isScalar = (size.length == 0);
	  if (isScalar) {
	    // scalar
	    if (Array.isArray(array)) {
	      throw new DimensionError(array.length, 0);
	    }
	  }
	  else {
	    // array
	    _validate(array, size, 0);
	  }
	};

	/**
	 * Test whether index is an integer number with index >= 0 and index < length
	 * @param {number} index    Zero-based index
	 * @param {number} [length] Length of the array
	 */
	exports.validateIndex = function(index, length) {
	  if (!number.isNumber(index) || !number.isInteger(index)) {
	    throw new TypeError('Index must be an integer (value: ' + index + ')');
	  }
	  if (index < 0) {
	    throw new IndexError(index);
	  }
	  if (length !== undefined && index >= length) {
	    throw new IndexError(index, length);
	  }
	};

	// a constant used to specify an undefined defaultValue
	exports.UNINITIALIZED = {};

	/**
	 * Resize a multi dimensional array. The resized array is returned.
	 * @param {Array} array         Array to be resized
	 * @param {Array.<number>} size Array with the size of each dimension
	 * @param {*} [defaultValue=0]  Value to be filled in in new entries,
	 *                              zero by default. To leave new entries undefined,
	 *                              specify array.UNINITIALIZED as defaultValue
	 * @return {Array} array         The resized array
	 */
	exports.resize = function(array, size, defaultValue) {
	  // TODO: add support for scalars, having size=[] ?

	  // check the type of the arguments
	  if (!Array.isArray(array) || !Array.isArray(size)) {
	    throw new TypeError('Array expected');
	  }
	  if (size.length === 0) {
	    throw new Error('Resizing to scalar is not supported');
	  }

	  // check whether size contains positive integers
	  size.forEach(function (value) {
	    if (!number.isNumber(value) || !number.isInteger(value) || value < 0) {
	      throw new TypeError('Invalid size, must contain positive integers ' +
	          '(size: ' + string.format(size) + ')');
	    }
	  });

	  // recursively resize the array
	  var _defaultValue = (defaultValue !== undefined) ? defaultValue : 0;
	  _resize(array, size, 0, _defaultValue);

	  return array;
	};

	/**
	 * Recursively resize a multi dimensional array
	 * @param {Array} array         Array to be resized
	 * @param {number[]} size       Array with the size of each dimension
	 * @param {number} dim          Current dimension
	 * @param {*} [defaultValue]    Value to be filled in in new entries,
	 *                              undefined by default.
	 * @private
	 */
	function _resize (array, size, dim, defaultValue) {
	  var i;
	  var elem;
	  var oldLen = array.length;
	  var newLen = size[dim];
	  var minLen = Math.min(oldLen, newLen);

	  // apply new length
	  array.length = newLen;

	  if (dim < size.length - 1) {
	    // non-last dimension
	    var dimNext = dim + 1;

	    // resize existing child arrays
	    for (i = 0; i < minLen; i++) {
	      // resize child array
	      elem = array[i];
	      if (!Array.isArray(elem)) {
	        elem = [elem]; // add a dimension
	        array[i] = elem;
	      }
	      _resize(elem, size, dimNext, defaultValue);
	    }

	    // create new child arrays
	    for (i = minLen; i < newLen; i++) {
	      // get child array
	      elem = [];
	      array[i] = elem;

	      // resize new child array
	      _resize(elem, size, dimNext, defaultValue);
	    }
	  }
	  else {
	    // last dimension

	    // remove dimensions of existing values
	    for (i = 0; i < minLen; i++) {
	      while (Array.isArray(array[i])) {
	        array[i] = array[i][0];
	      }
	    }

	    if(defaultValue !== exports.UNINITIALIZED) {
	      // fill new elements with the default value
	      for (i = minLen; i < newLen; i++) {
	        array[i] = object.clone(defaultValue);
	      }
	    }
	  }
	}

	/**
	 * Squeeze a multi dimensional array
	 * @param {Array} array
	 * @param {Array} [size]
	 * @returns {Array} returns the array itself
	 */
	exports.squeeze = function(array, size) {
	  var s = size || exports.size(array);

	  // squeeze outer dimensions
	  while (Array.isArray(array) && array.length === 1) {
	    array = array[0];
	    s.shift();
	  }

	  // find the first dimension to be squeezed
	  var dims = s.length;
	  while (s[dims - 1] === 1) {
	    dims--;
	  }

	  // squeeze inner dimensions
	  if (dims < s.length) {
	    array = _squeeze(array, dims, 0);
	    s.length = dims;
	  }

	  return array;
	};

	/**
	 * Recursively squeeze a multi dimensional array
	 * @param {Array} array
	 * @param {number} dims Required number of dimensions
	 * @param {number} dim  Current dimension
	 * @returns {Array | *} Returns the squeezed array
	 * @private
	 */
	function _squeeze (array, dims, dim) {
	  var i, ii;

	  if (dim < dims) {
	    var next = dim + 1;
	    for (i = 0, ii = array.length; i < ii; i++) {
	      array[i] = _squeeze(array[i], dims, next);
	    }
	  }
	  else {
	    while (Array.isArray(array)) {
	      array = array[0];
	    }
	  }

	  return array;
	}

	/**
	 * Unsqueeze a multi dimensional array: add dimensions when missing
	 * @param {Array} array
	 * @param {number} dims     Desired number of dimensions of the array
	 * @param {number} [outer]  Number of outer dimensions to be added
	 * @param {Array} [size]    Current size of array
	 * @returns {Array} returns the array itself
	 * @private
	 */
	exports.unsqueeze = function(array, dims, outer, size) {
	  var s = size || exports.size(array);

	  // unsqueeze outer dimensions
	  if (outer) {
	    for (var i = 0; i < outer; i++) {
	      array = [array];
	      s.unshift(1);
	    }
	  }

	  // unsqueeze inner dimensions
	  array = _unsqueeze(array, dims, 0);
	  while (s.length < dims) {
	    s.push(1);
	  }

	  return array;
	};

	/**
	 * Recursively unsqueeze a multi dimensional array
	 * @param {Array} array
	 * @param {number} dims Required number of dimensions
	 * @param {number} dim  Current dimension
	 * @returns {Array | *} Returns the squeezed array
	 * @private
	 */
	function _unsqueeze (array, dims, dim) {
	  var i, ii;

	  if (Array.isArray(array)) {
	    var next = dim + 1;
	    for (i = 0, ii = array.length; i < ii; i++) {
	      array[i] = _unsqueeze(array[i], dims, next);
	    }
	  }
	  else {
	    for (var d = dim; d < dims; d++) {
	      array = [array];
	    }
	  }

	  return array;
	}
	/**
	 * Flatten a multi dimensional array, put all elements in a one dimensional
	 * array
	 * @param {Array} array   A multi dimensional array
	 * @return {Array}        The flattened array (1 dimensional)
	 */
	exports.flatten = function(array) {
	  if (!Array.isArray(array)) {
	    //if not an array, return as is
	    return array;
	  }
	  var flat = [];

	  array.forEach(function callback(value) {
	    if (Array.isArray(value)) {
	      value.forEach(callback);  //traverse through sub-arrays recursively
	    }
	    else {
	      flat.push(value);
	    }
	  });

	  return flat;
	};

	/**
	 * Test whether an object is an array
	 * @param {*} value
	 * @return {boolean} isArray
	 */
	exports.isArray = Array.isArray;


/***/ },
/* 19 */
/***/ function(module, exports) {

	'use strict';

	/**
	 * Determine the type of a variable
	 *
	 *     type(x)
	 *
	 * The following types are recognized:
	 *
	 *     'undefined'
	 *     'null'
	 *     'boolean'
	 *     'number'
	 *     'string'
	 *     'Array'
	 *     'Function'
	 *     'Date'
	 *     'RegExp'
	 *     'Object'
	 *
	 * @param {*} x
	 * @return {string} Returns the name of the type. Primitive types are lower case,
	 *                  non-primitive types are upper-camel-case.
	 *                  For example 'number', 'string', 'Array', 'Date'.
	 */
	exports.type = function(x) {
	  var type = typeof x;

	  if (type === 'object') {
	    if (x === null)           return 'null';
	    if (x instanceof Boolean) return 'boolean';
	    if (x instanceof Number)  return 'number';
	    if (x instanceof String)  return 'string';
	    if (Array.isArray(x))     return 'Array';
	    if (x instanceof Date)    return 'Date';
	    if (x instanceof RegExp)  return 'RegExp';

	    return 'Object';
	  }

	  if (type === 'function')    return 'Function';

	  return type;
	};


/***/ },
/* 20 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var formatNumber = __webpack_require__(8).format;
	var formatBigNumber = __webpack_require__(21).format;

	/**
	 * Test whether value is a string
	 * @param {*} value
	 * @return {boolean} isString
	 */
	exports.isString = function(value) {
	  return typeof value === 'string';
	};

	/**
	 * Check if a text ends with a certain string.
	 * @param {string} text
	 * @param {string} search
	 */
	exports.endsWith = function(text, search) {
	  var start = text.length - search.length;
	  var end = text.length;
	  return (text.substring(start, end) === search);
	};

	/**
	 * Format a value of any type into a string.
	 *
	 * Usage:
	 *     math.format(value)
	 *     math.format(value, precision)
	 *
	 * If value is a function, the returned string is 'function' unless the function
	 * has a property `description`, in that case this properties value is returned.
	 *
	 * Example usage:
	 *     math.format(2/7);                // '0.2857142857142857'
	 *     math.format(math.pi, 3);         // '3.14'
	 *     math.format(new Complex(2, 3));  // '2 + 3i'
	 *     math.format('hello');            // '"hello"'
	 *
	 * @param {*} value             Value to be stringified
	 * @param {Object | number | Function} [options]  Formatting options. See
	 *                                                lib/utils/number:format for a
	 *                                                description of the available
	 *                                                options.
	 * @return {string} str
	 */
	exports.format = function(value, options) {
	  if (typeof value === 'number') {
	    return formatNumber(value, options);
	  }

	  if (value && value.isBigNumber === true) {
	    return formatBigNumber(value, options);
	  }

	  if (value && value.isFraction === true) {
	    if (!options || options.fraction !== 'decimal') {
	      // output as ratio, like '1/3'
	      return (value.s * value.n) + '/' + value.d;
	    }
	    else {
	      // output as decimal, like '0.(3)'
	      return value.toString();
	    }
	  }

	  if (Array.isArray(value)) {
	    return formatArray(value, options);
	  }

	  if (exports.isString(value)) {
	    return '"' + value + '"';
	  }

	  if (typeof value === 'function') {
	    return value.syntax ? value.syntax + '' : 'function';
	  }

	  if (typeof value === 'object') {
	    if (typeof value.format === 'function') {
	      return value.format(options);
	    }
	    else {
	      return value.toString();
	    }
	  }

	  return String(value);
	};

	/**
	 * Recursively format an n-dimensional matrix
	 * Example output: "[[1, 2], [3, 4]]"
	 * @param {Array} array
	 * @param {Object | number | Function} [options]  Formatting options. See
	 *                                                lib/utils/number:format for a
	 *                                                description of the available
	 *                                                options.
	 * @returns {string} str
	 */
	function formatArray (array, options) {
	  if (Array.isArray(array)) {
	    var str = '[';
	    var len = array.length;
	    for (var i = 0; i < len; i++) {
	      if (i != 0) {
	        str += ', ';
	      }
	      str += formatArray(array[i], options);
	    }
	    str += ']';
	    return str;
	  }
	  else {
	    return exports.format(array, options);
	  }
	}


/***/ },
/* 21 */
/***/ function(module, exports) {

	/**
	 * Convert a BigNumber to a formatted string representation.
	 *
	 * Syntax:
	 *
	 *    format(value)
	 *    format(value, options)
	 *    format(value, precision)
	 *    format(value, fn)
	 *
	 * Where:
	 *
	 *    {number} value   The value to be formatted
	 *    {Object} options An object with formatting options. Available options:
	 *                     {string} notation
	 *                         Number notation. Choose from:
	 *                         'fixed'          Always use regular number notation.
	 *                                          For example '123.40' and '14000000'
	 *                         'exponential'    Always use exponential notation.
	 *                                          For example '1.234e+2' and '1.4e+7'
	 *                         'auto' (default) Regular number notation for numbers
	 *                                          having an absolute value between
	 *                                          `lower` and `upper` bounds, and uses
	 *                                          exponential notation elsewhere.
	 *                                          Lower bound is included, upper bound
	 *                                          is excluded.
	 *                                          For example '123.4' and '1.4e7'.
	 *                     {number} precision   A number between 0 and 16 to round
	 *                                          the digits of the number.
	 *                                          In case of notations 'exponential' and
	 *                                          'auto', `precision` defines the total
	 *                                          number of significant digits returned
	 *                                          and is undefined by default.
	 *                                          In case of notation 'fixed',
	 *                                          `precision` defines the number of
	 *                                          significant digits after the decimal
	 *                                          point, and is 0 by default.
	 *                     {Object} exponential An object containing two parameters,
	 *                                          {number} lower and {number} upper,
	 *                                          used by notation 'auto' to determine
	 *                                          when to return exponential notation.
	 *                                          Default values are `lower=1e-3` and
	 *                                          `upper=1e5`.
	 *                                          Only applicable for notation `auto`.
	 *    {Function} fn    A custom formatting function. Can be used to override the
	 *                     built-in notations. Function `fn` is called with `value` as
	 *                     parameter and must return a string. Is useful for example to
	 *                     format all values inside a matrix in a particular way.
	 *
	 * Examples:
	 *
	 *    format(6.4);                                        // '6.4'
	 *    format(1240000);                                    // '1.24e6'
	 *    format(1/3);                                        // '0.3333333333333333'
	 *    format(1/3, 3);                                     // '0.333'
	 *    format(21385, 2);                                   // '21000'
	 *    format(12.071, {notation: 'fixed'});                // '12'
	 *    format(2.3,    {notation: 'fixed', precision: 2});  // '2.30'
	 *    format(52.8,   {notation: 'exponential'});          // '5.28e+1'
	 *
	 * @param {BigNumber} value
	 * @param {Object | Function | number} [options]
	 * @return {string} str The formatted value
	 */
	exports.format = function (value, options) {
	  if (typeof options === 'function') {
	    // handle format(value, fn)
	    return options(value);
	  }

	  // handle special cases
	  if (!value.isFinite()) {
	    return value.isNaN() ? 'NaN' : (value.gt(0) ? 'Infinity' : '-Infinity');
	  }

	  // default values for options
	  var notation = 'auto';
	  var precision = undefined;

	  if (options !== undefined) {
	    // determine notation from options
	    if (options.notation) {
	      notation = options.notation;
	    }

	    // determine precision from options
	    if (typeof options === 'number') {
	      precision = options;
	    }
	    else if (options.precision) {
	      precision = options.precision;
	    }
	  }

	  // handle the various notations
	  switch (notation) {
	    case 'fixed':
	      return exports.toFixed(value, precision);

	    case 'exponential':
	      return exports.toExponential(value, precision);

	    case 'auto':
	      // determine lower and upper bound for exponential notation.
	      // TODO: implement support for upper and lower to be BigNumbers themselves
	      var lower = 1e-3;
	      var upper = 1e5;
	      if (options && options.exponential) {
	        if (options.exponential.lower !== undefined) {
	          lower = options.exponential.lower;
	        }
	        if (options.exponential.upper !== undefined) {
	          upper = options.exponential.upper;
	        }
	      }

	      // adjust the configuration of the BigNumber constructor (yeah, this is quite tricky...)
	      var oldConfig = {
	        toExpNeg: value.constructor.toExpNeg,
	        toExpPos: value.constructor.toExpPos
	      };

	      value.constructor.config({
	        toExpNeg: Math.round(Math.log(lower) / Math.LN10),
	        toExpPos: Math.round(Math.log(upper) / Math.LN10)
	      });

	      // handle special case zero
	      if (value.isZero()) return '0';

	      // determine whether or not to output exponential notation
	      var str;
	      var abs = value.abs();
	      if (abs.gte(lower) && abs.lt(upper)) {
	        // normal number notation
	        str = value.toSignificantDigits(precision).toFixed();
	      }
	      else {
	        // exponential notation
	        str = exports.toExponential(value, precision);
	      }

	      // remove trailing zeros after the decimal point
	      return str.replace(/((\.\d*?)(0+))($|e)/, function () {
	        var digits = arguments[2];
	        var e = arguments[4];
	        return (digits !== '.') ? digits + e : e;
	      });

	    default:
	      throw new Error('Unknown notation "' + notation + '". ' +
	          'Choose "auto", "exponential", or "fixed".');
	  }
	};

	/**
	 * Format a number in exponential notation. Like '1.23e+5', '2.3e+0', '3.500e-3'
	 * @param {BigNumber} value
	 * @param {number} [precision]  Number of digits in formatted output.
	 *                              If not provided, the maximum available digits
	 *                              is used.
	 * @returns {string} str
	 */
	exports.toExponential = function (value, precision) {
	  if (precision !== undefined) {
	    return value.toExponential(precision - 1); // Note the offset of one
	  }
	  else {
	    return value.toExponential();
	  }
	};

	/**
	 * Format a number with fixed notation.
	 * @param {BigNumber} value
	 * @param {number} [precision=0]        Optional number of decimals after the
	 *                                      decimal point. Zero by default.
	 */
	exports.toFixed = function (value, precision) {
	  return value.toFixed(precision || 0);
	  // Note: the (precision || 0) is needed as the toFixed of BigNumber has an
	  // undefined default precision instead of 0.
	}


/***/ },
/* 22 */
/***/ function(module, exports) {

	'use strict';

	/**
	 * Create a range error with the message:
	 *     'Dimension mismatch (<actual size> != <expected size>)'
	 * @param {number | number[]} actual        The actual size
	 * @param {number | number[]} expected      The expected size
	 * @param {string} [relation='!=']          Optional relation between actual
	 *                                          and expected size: '!=', '<', etc.
	 * @extends RangeError
	 */
	function DimensionError(actual, expected, relation) {
	  if (!(this instanceof DimensionError)) {
	    throw new SyntaxError('Constructor must be called with the new operator');
	  }

	  this.actual   = actual;
	  this.expected = expected;
	  this.relation = relation;

	  this.message = 'Dimension mismatch (' +
	      (Array.isArray(actual) ? ('[' + actual.join(', ') + ']') : actual) +
	      ' ' + (this.relation || '!=') + ' ' +
	      (Array.isArray(expected) ? ('[' + expected.join(', ') + ']') : expected) +
	      ')';

	  this.stack = (new Error()).stack;
	}

	DimensionError.prototype = new RangeError();
	DimensionError.prototype.constructor = RangeError;
	DimensionError.prototype.name = 'DimensionError';
	DimensionError.prototype.isDimensionError = true;

	module.exports = DimensionError;


/***/ },
/* 23 */
/***/ function(module, exports) {

	'use strict';

	function factory (type, config, load, typed) {
	  /**
	   * Create a Matrix. The function creates a new `math.type.Matrix` object from
	   * an `Array`. A Matrix has utility functions to manipulate the data in the
	   * matrix, like getting the size and getting or setting values in the matrix.
	   * Supported storage formats are 'dense' and 'sparse'.
	   *
	   * Syntax:
	   *
	   *    math.matrix()                         // creates an empty matrix using default storage format (dense).
	   *    math.matrix(data)                     // creates a matrix with initial data using default storage format (dense).
	   *    math.matrix('dense')                  // creates an empty matrix using the given storage format.
	   *    math.matrix(data, 'dense')            // creates a matrix with initial data using the given storage format.
	   *    math.matrix(data, 'sparse')           // creates a sparse matrix with initial data.
	   *    math.matrix(data, 'sparse', 'number') // creates a sparse matrix with initial data, number data type.
	   *
	   * Examples:
	   *
	   *    var m = math.matrix([[1, 2], [3, 4]]);
	   *    m.size();                        // Array [2, 2]
	   *    m.resize([3, 2], 5);
	   *    m.valueOf();                     // Array [[1, 2], [3, 4], [5, 5]]
	   *    m.get([1, 0])                    // number 3
	   *
	   * See also:
	   *
	   *    bignumber, boolean, complex, index, number, string, unit, sparse
	   *
	   * @param {Array | Matrix} [data]    A multi dimensional array
	   * @param {string} [format]          The Matrix storage format
	   *
	   * @return {Matrix} The created matrix
	   */
	  var matrix = typed('matrix', {
	    '': function () {
	      return _create([]);
	    },

	    'string': function (format) {
	      return _create([], format);
	    },
	    
	    'string, string': function (format, datatype) {
	      return _create([], format, datatype);
	    },

	    'Array': function (data) {
	      return _create(data);
	    },
	      
	    'Matrix': function (data) {
	      return _create(data, data.storage());
	    },
	    
	    'Array | Matrix, string': _create,
	    
	    'Array | Matrix, string, string': _create
	  });

	  matrix.toTex = {
	    0: '\\begin{bmatrix}\\end{bmatrix}',
	    1: '\\left(${args[0]}\\right)',
	    2: '\\left(${args[0]}\\right)'
	  };

	  return matrix;

	  /**
	   * Create a new Matrix with given storage format
	   * @param {Array} data
	   * @param {string} [format]
	   * @param {string} [datatype]
	   * @returns {Matrix} Returns a new Matrix
	   * @private
	   */
	  function _create(data, format, datatype) {
	    // get storage format constructor
	    var M = type.Matrix.storage(format || 'default');

	    // create instance
	    return new M(data, datatype);
	  }
	}

	exports.name = 'matrix';
	exports.factory = factory;


/***/ },
/* 24 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var size = __webpack_require__(18).size;

	function factory (type, config, load, typed) {
	  var matrix   = load(__webpack_require__(23));
	  var subtract = load(__webpack_require__(25));
	  var multiply = load(__webpack_require__(40));

	  /**
	   * Calculate the cross product for two vectors in three dimensional space.
	   * The cross product of `A = [a1, a2, a3]` and `B =[b1, b2, b3]` is defined
	   * as:
	   *
	   *    cross(A, B) = [
	   *      a2 * b3 - a3 * b2,
	   *      a3 * b1 - a1 * b3,
	   *      a1 * b2 - a2 * b1
	   *    ]
	   *
	   * Syntax:
	   *
	   *    math.cross(x, y)
	   *
	   * Examples:
	   *
	   *    math.cross([1, 1, 0],  [0, 1, 1]);  // Returns [1, -1, 1]
	   *    math.cross([3, -3, 1], [4, 9, 2]);  // Returns [-15, -2, 39]
	   *    math.cross([2, 3, 4],  [5, 6, 7]);  // Returns [-3, 6, -3]
	   *
	   * See also:
	   *
	   *    dot, multiply
	   *
	   * @param  {Array | Matrix} x   First vector
	   * @param  {Array | Matrix} y   Second vector
	   * @return {Array | Matrix}     Returns the cross product of `x` and `y`
	   */
	  var cross = typed('cross', {
	    'Matrix, Matrix': function (x, y) {
	      return matrix(_cross(x.toArray(), y.toArray()));
	    },

	    'Matrix, Array': function (x, y) {
	      return matrix(_cross(x.toArray(), y));
	    },

	    'Array, Matrix': function (x, y) {
	      return matrix(_cross(x, y.toArray()));
	    },

	    'Array, Array': _cross
	  });

	  cross.toTex = '\\left(${args[0]}\\right)\\times\\left(${args[1]}\\right)';

	  return cross;

	  /**
	   * Calculate the cross product for two arrays
	   * @param {Array} x  First vector
	   * @param {Array} y  Second vector
	   * @returns {Array} Returns the cross product of x and y
	   * @private
	   */
	  function _cross(x, y) {
	    var xSize= size(x);
	    var ySize = size(y);

	    if (xSize.length != 1 || ySize.length != 1 || xSize[0] != 3 || ySize[0] != 3) {
	      throw new RangeError('Vectors with length 3 expected ' +
	      '(Size A = [' + xSize.join(', ') + '], B = [' + ySize.join(', ') + '])');
	    }

	    return [
	      subtract(multiply(x[1], y[2]), multiply(x[2], y[1])),
	      subtract(multiply(x[2], y[0]), multiply(x[0], y[2])),
	      subtract(multiply(x[0], y[1]), multiply(x[1], y[0]))
	    ];
	  }
	}

	exports.name = 'cross';
	exports.factory = factory;


/***/ },
/* 25 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var DimensionError = __webpack_require__(22);

	function factory (type, config, load, typed) {
	  var latex = __webpack_require__(26);

	  var matrix = load(__webpack_require__(23));
	  var addScalar = load(__webpack_require__(27));
	  var unaryMinus = load(__webpack_require__(28));

	  var algorithm01 = load(__webpack_require__(30));
	  var algorithm03 = load(__webpack_require__(31));
	  var algorithm05 = load(__webpack_require__(32));
	  var algorithm10 = load(__webpack_require__(34));
	  var algorithm13 = load(__webpack_require__(35));
	  var algorithm14 = load(__webpack_require__(39));

	  /**
	   * Subtract two values, `x - y`.
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.subtract(x, y)
	   *
	   * Examples:
	   *
	   *    math.subtract(5.3, 2);        // returns number 3.3
	   *
	   *    var a = math.complex(2, 3);
	   *    var b = math.complex(4, 1);
	   *    math.subtract(a, b);          // returns Complex -2 + 2i
	   *
	   *    math.subtract([5, 7, 4], 4);  // returns Array [1, 3, 0]
	   *
	   *    var c = math.unit('2.1 km');
	   *    var d = math.unit('500m');
	   *    math.subtract(c, d);          // returns Unit 1.6 km
	   *
	   * See also:
	   *
	   *    add
	   *
	   * @param  {number | BigNumber | Fraction | Complex | Unit | Array | Matrix} x
	   *            Initial value
	   * @param  {number | BigNumber | Fraction | Complex | Unit | Array | Matrix} y
	   *            Value to subtract from `x`
	   * @return {number | BigNumber | Fraction | Complex | Unit | Array | Matrix}
	   *            Subtraction of `x` and `y`
	   */
	  var subtract = typed('subtract', {

	    'number, number': function (x, y) {
	      return x - y;
	    },

	    'Complex, Complex': function (x, y) {
	      return new type.Complex (
	          x.re - y.re,
	          x.im - y.im
	      );
	    },

	    'BigNumber, BigNumber': function (x, y) {
	      return x.minus(y);
	    },

	    'Fraction, Fraction': function (x, y) {
	      return x.sub(y);
	    },

	    'Unit, Unit': function (x, y) {
	      if (x.value == null) {
	        throw new Error('Parameter x contains a unit with undefined value');
	      }

	      if (y.value == null) {
	        throw new Error('Parameter y contains a unit with undefined value');
	      }

	      if (!x.equalBase(y)) {
	        throw new Error('Units do not match');
	      }

	      var res = x.clone();
	      res.value -= y.value;
	      res.fixPrefix = false;

	      return res;
	    },
	    
	    'Matrix, Matrix': function (x, y) {
	      // matrix sizes
	      var xsize = x.size();
	      var ysize = y.size();

	      // check dimensions
	      if (xsize.length !== ysize.length)
	        throw new DimensionError(xsize.length, ysize.length);

	      // result
	      var c;

	      // process matrix storage
	      switch (x.storage()) {
	        case 'sparse':
	          switch (y.storage()) {
	            case 'sparse':
	              // sparse - sparse
	              c = algorithm05(x, y, subtract);
	              break;
	            default:
	              // sparse - dense
	              c = algorithm03(y, x, subtract, true);
	              break;
	          }
	          break;
	        default:
	          switch (y.storage()) {
	            case 'sparse':
	              // dense - sparse
	              c = algorithm01(x, y, subtract, false);
	              break;
	            default:
	              // dense - dense
	              c = algorithm13(x, y, subtract);
	              break;
	          }
	          break;
	      }
	      return c;
	    },
	    
	    'Array, Array': function (x, y) {
	      // use matrix implementation
	      return subtract(matrix(x), matrix(y)).valueOf();
	    },

	    'Array, Matrix': function (x, y) {
	      // use matrix implementation
	      return subtract(matrix(x), y);
	    },

	    'Matrix, Array': function (x, y) {
	      // use matrix implementation
	      return subtract(x, matrix(y));
	    },
	    
	    'Matrix, any': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (x.storage()) {
	        case 'sparse':
	          // algorithm 7 is faster than 9 since it calls f() for nonzero items only!
	          c = algorithm10(x, unaryMinus(y), addScalar);
	          break;
	        default:
	          c = algorithm14(x, y, subtract);
	          break;
	      }
	      return c;
	    },

	    'any, Matrix': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (y.storage()) {
	        case 'sparse':
	          c = algorithm10(y, x, subtract, true);
	          break;
	        default:
	          c = algorithm14(y, x, subtract, true);
	          break;
	      }
	      return c;
	    },

	    'Array, any': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(x), y, subtract, false).valueOf();
	    },

	    'any, Array': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(y), x, subtract, true).valueOf();
	    }
	  });

	  subtract.toTex = '\\left(${args[0]}' + latex.operators['subtract'] + '${args[1]}\\right)';

	  return subtract;
	}

	exports.name = 'subtract';
	exports.factory = factory;


/***/ },
/* 26 */
/***/ function(module, exports) {

	'use strict';

	exports.symbols = {
	  // GREEK LETTERS
	  Alpha: 'A',     alpha: '\\alpha',
	  Beta: 'B',      beta: '\\beta',
	  Gamma: '\\Gamma',    gamma: '\\gamma',
	  Delta: '\\Delta',    delta: '\\delta',
	  Epsilon: 'E',   epsilon: '\\epsilon',  varepsilon: '\\varepsilon',
	  Zeta: 'Z',      zeta: '\\zeta',
	  Eta: 'H',       eta: '\\eta',
	  Theta: '\\Theta',    theta: '\\theta',    vartheta: '\\vartheta',
	  Iota: 'I',      iota: '\\iota',
	  Kappa: 'K',     kappa: '\\kappa',    varkappa: '\\varkappa',
	  Lambda: '\\Lambda',   lambda: '\\lambda',
	  Mu: 'M',        mu: '\\mu',
	  Nu: 'N',        nu: '\\nu',
	  Xi: '\\Xi',       xi: '\\xi',
	  Omicron: 'O',   omicron: 'o',
	  Pi: '\\Pi',       pi: '\\pi',       varpi: '\\varpi',
	  Rho: 'P',       rho: '\\rho',      varrho: '\\varrho',
	  Sigma: '\\Sigma',    sigma: '\\sigma',    varsigma: '\\varsigma',
	  Tau: 'T',       tau: '\\tau',
	  Upsilon: '\\Upsilon',  upsilon: '\\upsilon',
	  Phi: '\\Phi',      phi: '\\phi',      varphi: '\\varphi',
	  Chi: 'X',       chi: '\\chi',
	  Psi: '\\Psi',      psi: '\\psi',
	  Omega: '\\Omega',    omega: '\\omega',
	  //logic
	  'true': '\\mathrm{True}',
	  'false': '\\mathrm{False}',
	  //other
	  i: 'i', //TODO use \i ??
	  inf: '\\infty',
	  Inf: '\\infty',
	  infinity: '\\infty',
	  Infinity: '\\infty',
	  oo: '\\infty',
	  lim: '\\lim',
	  'undefined': '\\mathbf{?}'
	};

	exports.operators = {
	  'transpose': '^\\top',
	  'factorial': '!',
	  'pow': '^',
	  'dotPow': '.^\\wedge', //TODO find ideal solution
	  'unaryPlus': '+',
	  'unaryMinus': '-',
	  'bitNot': '~', //TODO find ideal solution
	  'not': '\\neg',
	  'multiply': '\\cdot',
	  'divide': '\\frac', //TODO how to handle that properly?
	  'dotMultiply': '.\\cdot', //TODO find ideal solution
	  'dotDivide': '.:', //TODO find ideal solution
	  'mod': '\\mod',
	  'add': '+',
	  'subtract': '-',
	  'to': '\\rightarrow',
	  'leftShift': '<<',
	  'rightArithShift': '>>',
	  'rightLogShift': '>>>',
	  'equal': '=',
	  'unequal': '\\neq',
	  'smaller': '<',
	  'larger': '>',
	  'smallerEq': '\\leq',
	  'largerEq': '\\geq',
	  'bitAnd': '\\&',
	  'bitXor': '\\underline{|}',
	  'bitOr': '|',
	  'and': '\\wedge',
	  'xor': '\\veebar',
	  'or': '\\vee'
	};

	exports.defaultTemplate = '\\mathrm{${name}}\\left(${args}\\right)';

	var units = {
	  deg: '^\\circ'
	};

	//@param {string} name
	//@param {boolean} isUnit
	exports.toSymbol = function (name, isUnit) {
	  isUnit = typeof isUnit === 'undefined' ? false : isUnit;
	  if (isUnit) {
	    if (units.hasOwnProperty(name)) {
	      return units[name];
	    }
	    return '\\mathrm{' + name + '}';
	  }

	  if (exports.symbols.hasOwnProperty(name)) {
	    return exports.symbols[name];
	  }
	  else if (name.indexOf('_') !== -1) {
	    //symbol with index (eg. alpha_1)
	    var index = name.indexOf('_');
	    return exports.toSymbol(name.substring(0, index)) + '_{'
	      + exports.toSymbol(name.substring(index + 1)) + '}';
	  }
	  return name;
	};


/***/ },
/* 27 */
/***/ function(module, exports) {

	'use strict';

	function factory(type, config, load, typed) {

	  /**
	   * Add two scalar values, `x + y`.
	   * This function is meant for internal use: it is used by the public function
	   * `add`
	   *
	   * This function does not support collections (Array or Matrix), and does
	   * not validate the number of of inputs.
	   *
	   * @param  {number | BigNumber | Fraction | Complex | Unit} x   First value to add
	   * @param  {number | BigNumber | Fraction | Complex} y          Second value to add
	   * @return {number | BigNumber | Fraction | Complex | Unit}                      Sum of `x` and `y`
	   * @private
	   */
	  return typed('add', {

	    'number, number': function (x, y) {
	      return x + y;
	    },

	    'Complex, Complex': function (x, y) {
	      return new type.Complex(
	        x.re + y.re,
	        x.im + y.im
	      );
	    },

	    'BigNumber, BigNumber': function (x, y) {
	      return x.plus(y);
	    },

	    'Fraction, Fraction': function (x, y) {
	      return x.add(y);
	    },

	    'Unit, Unit': function (x, y) {
	      if (x.value == null) throw new Error('Parameter x contains a unit with undefined value');
	      if (y.value == null) throw new Error('Parameter y contains a unit with undefined value');
	      if (!x.equalBase(y)) throw new Error('Units do not match');

	      var res = x.clone();
	      res.value += y.value;
	      res.fixPrefix = false;
	      return res;
	    }
	  });
	}

	exports.factory = factory;


/***/ },
/* 28 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);

	function factory (type, config, load, typed) {
	  var latex = __webpack_require__(26);

	  /**
	   * Inverse the sign of a value, apply a unary minus operation.
	   *
	   * For matrices, the function is evaluated element wise. Boolean values and
	   * strings will be converted to a number. For complex numbers, both real and
	   * complex value are inverted.
	   *
	   * Syntax:
	   *
	   *    math.unaryMinus(x)
	   *
	   * Examples:
	   *
	   *    math.unaryMinus(3.5);      // returns -3.5
	   *    math.unaryMinus(-4.2);     // returns 4.2
	   *
	   * See also:
	   *
	   *    add, subtract, unaryPlus
	   *
	   * @param  {number | BigNumber | Fraction | Complex | Unit | Array | Matrix} x Number to be inverted.
	   * @return {number | BigNumber | Fraction | Complex | Unit | Array | Matrix} Returns the value with inverted sign.
	   */
	  var unaryMinus = typed('unaryMinus', {
	    'number': function (x) {
	      return -x;
	    },

	    'Complex': function (x) {
	      return new type.Complex(-x.re, -x.im);
	    },

	    'BigNumber': function (x) {
	      return x.neg();
	    },

	    'Fraction': function (x) {
	      var tmp = x.clone();
	      tmp.s = -tmp.s;
	      return tmp;
	    },

	    'Unit': function (x) {
	      var res = x.clone();
	      res.value = -x.value;
	      return res;
	    },

	    'Array | Matrix': function (x) {
	      // deep map collection, skip zeros since unaryMinus(0) = 0
	      return deepMap(x, unaryMinus, true);
	    }

	    // TODO: add support for string
	  });

	  unaryMinus.toTex = latex.operators['unaryMinus'] + '\\left(${args[0]}\\right)';

	  return unaryMinus;
	}

	exports.name = 'unaryMinus';
	exports.factory = factory;


/***/ },
/* 29 */
/***/ function(module, exports) {

	'use strict';

	/**
	 * Execute the callback function element wise for each element in array and any
	 * nested array
	 * Returns an array with the results
	 * @param {Array | Matrix} array
	 * @param {Function} callback   The callback is called with two parameters:
	 *                              value1 and value2, which contain the current
	 *                              element of both arrays.
	 * @param {boolean} [skipZeros] Invoke callback function for non-zero values only.
	 *
	 * @return {Array | Matrix} res
	 */
	module.exports = function deepMap(array, callback, skipZeros) {
	  if (array && (typeof array.map === 'function')) {
	    // TODO: replace array.map with a for loop to improve performance
	    return array.map(function (x) {
	      return deepMap(x, callback, skipZeros);
	    });
	  }
	  else {
	    return callback(array);
	  }
	};


/***/ },
/* 30 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var DimensionError = __webpack_require__(22);

	function factory (type, config, load, typed) {

	  var DenseMatrix = type.DenseMatrix;

	  /**
	   * Iterates over SparseMatrix nonzero items and invokes the callback function f(Dij, Sij). 
	   * Callback function invoked NNZ times (number of nonzero items in SparseMatrix).
	   *
	   *
	   *          ┌  f(Dij, Sij)  ; S(i,j) !== 0
	   * C(i,j) = ┤
	   *          └  Dij          ; otherwise
	   *
	   *
	   * @param {Matrix}   denseMatrix       The DenseMatrix instance (D)
	   * @param {Matrix}   sparseMatrix      The SparseMatrix instance (S)
	   * @param {Function} callback          The f(Dij,Sij) operation to invoke, where Dij = DenseMatrix(i,j) and Sij = SparseMatrix(i,j)
	   * @param {boolean}  inverse           A true value indicates callback should be invoked f(Sij,Dij)
	   *
	   * @return {Matrix}                    DenseMatrix (C)
	   *
	   * see https://github.com/josdejong/mathjs/pull/346#issuecomment-97477571
	   */
	  var algorithm01 = function (denseMatrix, sparseMatrix, callback, inverse) {
	    // dense matrix arrays
	    var adata = denseMatrix._data;
	    var asize = denseMatrix._size;
	    var adt = denseMatrix._datatype;
	    // sparse matrix arrays
	    var bvalues = sparseMatrix._values;
	    var bindex = sparseMatrix._index;
	    var bptr = sparseMatrix._ptr;
	    var bsize = sparseMatrix._size;
	    var bdt = sparseMatrix._datatype;

	    // validate dimensions
	    if (asize.length !== bsize.length)
	      throw new DimensionError(asize.length, bsize.length);

	    // check rows & columns
	    if (asize[0] !== bsize[0] || asize[1] !== bsize[1])
	      throw new RangeError('Dimension mismatch. Matrix A (' + asize + ') must match Matrix B (' + bsize + ')');

	    // sparse matrix cannot be a Pattern matrix
	    if (!bvalues)
	      throw new Error('Cannot perform operation on Dense Matrix and Pattern Sparse Matrix');

	    // rows & columns
	    var rows = asize[0];
	    var columns = asize[1];

	    // process data types
	    var dt = typeof adt === 'string' && adt === bdt ? adt : undefined;
	    // callback function
	    var cf = dt ? typed.find(callback, [dt, dt]) : callback;

	    // vars
	    var i, j;
	    
	    // result (DenseMatrix)
	    var cdata = [];
	    // initialize c
	    for (i = 0; i < rows; i++)
	      cdata[i] = [];      
	    
	    // workspace
	    var x = [];
	    // marks indicating we have a value in x for a given column
	    var w = [];

	    // loop columns in b
	    for (j = 0; j < columns; j++) {
	      // column mark
	      var mark = j + 1;
	      // values in column j
	      for (var k0 = bptr[j], k1 = bptr[j + 1], k = k0; k < k1; k++) {
	        // row
	        i = bindex[k];
	        // update workspace
	        x[i] = inverse ? cf(bvalues[k], adata[i][j]) : cf(adata[i][j], bvalues[k]);
	        // mark i as updated
	        w[i] = mark;
	      }
	      // loop rows
	      for (i = 0; i < rows; i++) {
	        // check row is in workspace
	        if (w[i] === mark) {
	          // c[i][j] was already calculated
	          cdata[i][j] = x[i];
	        }
	        else {
	          // item does not exist in S
	          cdata[i][j] = adata[i][j];
	        }
	      }
	    }

	    // return dense matrix
	    return new DenseMatrix({
	      data: cdata,
	      size: [rows, columns],
	      datatype: dt
	    });
	  };
	  
	  return algorithm01;
	}

	exports.name = 'algorithm01';
	exports.factory = factory;


/***/ },
/* 31 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var DimensionError = __webpack_require__(22);

	function factory (type, config, load, typed) {

	  var DenseMatrix = type.DenseMatrix;

	  /**
	   * Iterates over SparseMatrix items and invokes the callback function f(Dij, Sij).
	   * Callback function invoked M*N times.
	   *
	   *
	   *          ┌  f(Dij, Sij)  ; S(i,j) !== 0
	   * C(i,j) = ┤
	   *          └  f(Dij, 0)    ; otherwise
	   *
	   *
	   * @param {Matrix}   denseMatrix       The DenseMatrix instance (D)
	   * @param {Matrix}   sparseMatrix      The SparseMatrix instance (C)
	   * @param {Function} callback          The f(Dij,Sij) operation to invoke, where Dij = DenseMatrix(i,j) and Sij = SparseMatrix(i,j)
	   * @param {boolean}  inverse           A true value indicates callback should be invoked f(Sij,Dij)
	   *
	   * @return {Matrix}                    DenseMatrix (C)
	   *
	   * see https://github.com/josdejong/mathjs/pull/346#issuecomment-97477571
	   */
	  var algorithm03 = function (denseMatrix, sparseMatrix, callback, inverse) {
	    // dense matrix arrays
	    var adata = denseMatrix._data;
	    var asize = denseMatrix._size;
	    var adt = denseMatrix._datatype;
	    // sparse matrix arrays
	    var bvalues = sparseMatrix._values;
	    var bindex = sparseMatrix._index;
	    var bptr = sparseMatrix._ptr;
	    var bsize = sparseMatrix._size;
	    var bdt = sparseMatrix._datatype;

	    // validate dimensions
	    if (asize.length !== bsize.length)
	      throw new DimensionError(asize.length, bsize.length);

	    // check rows & columns
	    if (asize[0] !== bsize[0] || asize[1] !== bsize[1])
	      throw new RangeError('Dimension mismatch. Matrix A (' + asize + ') must match Matrix B (' + bsize + ')');

	    // sparse matrix cannot be a Pattern matrix
	    if (!bvalues)
	      throw new Error('Cannot perform operation on Dense Matrix and Pattern Sparse Matrix');

	    // rows & columns
	    var rows = asize[0];
	    var columns = asize[1];

	    // datatype
	    var dt;
	    // zero value
	    var zero = 0;
	    // callback signature to use
	    var cf = callback;

	    // process data types
	    if (typeof adt === 'string' && adt === bdt) {
	      // datatype
	      dt = adt;
	      // convert 0 to the same datatype
	      zero = typed.convert(0, dt);
	      // callback
	      cf = typed.find(callback, [dt, dt]);
	    }

	    // result (DenseMatrix)
	    var cdata = [];

	    // initialize dense matrix
	    for (var z = 0; z < rows; z++) {
	      // initialize row
	      cdata[z] = [];
	    }

	    // workspace
	    var x = [];
	    // marks indicating we have a value in x for a given column
	    var w = [];

	    // loop columns in b
	    for (var j = 0; j < columns; j++) {
	      // column mark
	      var mark = j + 1;
	      // values in column j
	      for (var k0 = bptr[j], k1 = bptr[j + 1], k = k0; k < k1; k++) {
	        // row
	        var i = bindex[k];
	        // update workspace
	        x[i] = inverse ? cf(bvalues[k], adata[i][j]) : cf(adata[i][j], bvalues[k]);
	        w[i] = mark;
	      }
	      // process workspace
	      for (var y = 0; y < rows; y++) {
	        // check we have a calculated value for current row
	        if (w[y] === mark) {
	          // use calculated value
	          cdata[y][j] = x[y];
	        }
	        else {
	          // calculate value
	          cdata[y][j] = inverse ? cf(zero, adata[y][j]) : cf(adata[y][j], zero);
	        }
	      }
	    }

	    // return dense matrix
	    return new DenseMatrix({
	      data: cdata,
	      size: [rows, columns],
	      datatype: dt
	    });
	  };
	  
	  return algorithm03;
	}

	exports.name = 'algorithm03';
	exports.factory = factory;


/***/ },
/* 32 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var DimensionError = __webpack_require__(22);

	function factory (type, config, load, typed) {

	  var equalScalar = load(__webpack_require__(33));
	  
	  var SparseMatrix = type.SparseMatrix;

	  /**
	   * Iterates over SparseMatrix A and SparseMatrix B nonzero items and invokes the callback function f(Aij, Bij). 
	   * Callback function invoked MAX(NNZA, NNZB) times
	   *
	   *
	   *          ┌  f(Aij, Bij)  ; A(i,j) !== 0 || B(i,j) !== 0
	   * C(i,j) = ┤  
	   *          └  0            ; otherwise
	   *
	   *
	   * @param {Matrix}   a                 The SparseMatrix instance (A)
	   * @param {Matrix}   b                 The SparseMatrix instance (B)
	   * @param {Function} callback          The f(Aij,Bij) operation to invoke
	   *
	   * @return {Matrix}                    SparseMatrix (C)
	   *
	   * see https://github.com/josdejong/mathjs/pull/346#issuecomment-97620294
	   */
	  var algorithm05 = function (a, b, callback) {
	    // sparse matrix arrays
	    var avalues = a._values;
	    var aindex = a._index;
	    var aptr = a._ptr;
	    var asize = a._size;
	    var adt = a._datatype;
	    // sparse matrix arrays
	    var bvalues = b._values;
	    var bindex = b._index;
	    var bptr = b._ptr;
	    var bsize = b._size;
	    var bdt = b._datatype;

	    // validate dimensions
	    if (asize.length !== bsize.length)
	      throw new DimensionError(asize.length, bsize.length);

	    // check rows & columns
	    if (asize[0] !== bsize[0] || asize[1] !== bsize[1])
	      throw new RangeError('Dimension mismatch. Matrix A (' + asize + ') must match Matrix B (' + bsize + ')');

	    // rows & columns
	    var rows = asize[0];
	    var columns = asize[1];

	    // datatype
	    var dt;
	    // equal signature to use
	    var eq = equalScalar;
	    // zero value
	    var zero = 0;
	    // callback signature to use
	    var cf = callback;

	    // process data types
	    if (typeof adt === 'string' && adt === bdt) {
	      // datatype
	      dt = adt;
	      // find signature that matches (dt, dt)
	      eq = typed.find(equalScalar, [dt, dt]);
	      // convert 0 to the same datatype
	      zero = typed.convert(0, dt);
	      // callback
	      cf = typed.find(callback, [dt, dt]);
	    }

	    // result arrays
	    var cvalues = avalues && bvalues ? [] : undefined;
	    var cindex = [];
	    var cptr = [];
	    // matrix
	    var c = new SparseMatrix({
	      values: cvalues,
	      index: cindex,
	      ptr: cptr,
	      size: [rows, columns],
	      datatype: dt
	    });

	    // workspaces
	    var xa = cvalues ? [] : undefined;
	    var xb = cvalues ? [] : undefined;
	    // marks indicating we have a value in x for a given column
	    var wa = [];
	    var wb = [];

	    // vars
	    var i, j, k, k1;
	    
	    // loop columns
	    for (j = 0; j < columns; j++) {
	      // update cptr
	      cptr[j] = cindex.length;
	      // columns mark
	      var mark = j + 1;
	      // loop values A(:,j)
	      for (k = aptr[j], k1 = aptr[j + 1]; k < k1; k++) {
	        // row
	        i = aindex[k];
	        // push index
	        cindex.push(i);
	        // update workspace
	        wa[i] = mark;
	        // check we need to process values
	        if (xa)
	          xa[i] = avalues[k];
	      }
	      // loop values B(:,j)
	      for (k = bptr[j], k1 = bptr[j + 1]; k < k1; k++) {
	        // row
	        i = bindex[k];
	        // check row existed in A
	        if (wa[i] !== mark) {
	          // push index
	          cindex.push(i);
	        }
	        // update workspace
	        wb[i] = mark;
	        // check we need to process values
	        if (xb)
	          xb[i] = bvalues[k];
	      }
	      // check we need to process values (non pattern matrix)
	      if (cvalues) {
	        // initialize first index in j
	        k = cptr[j];
	        // loop index in j
	        while (k < cindex.length) {
	          // row
	          i = cindex[k];
	          // marks
	          var wai = wa[i];
	          var wbi = wb[i];
	          // check Aij or Bij are nonzero
	          if (wai === mark || wbi === mark) {
	            // matrix values @ i,j
	            var va = wai === mark ? xa[i] : zero;
	            var vb = wbi === mark ? xb[i] : zero;
	            // Cij
	            var vc = cf(va, vb);
	            // check for zero
	            if (!eq(vc, zero)) {
	              // push value
	              cvalues.push(vc);
	              // increment pointer
	              k++;
	            }
	            else {
	              // remove value @ i, do not increment pointer
	              cindex.splice(k, 1);
	            }
	          }
	        }
	      }
	    }
	    // update cptr
	    cptr[columns] = cindex.length;

	    // return sparse matrix
	    return c;
	  };

	  return algorithm05;
	}

	exports.name = 'algorithm05';
	exports.factory = factory;


/***/ },
/* 33 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var nearlyEqual = __webpack_require__(8).nearlyEqual;

	function factory (type, config, load, typed) {
	  
	  /**
	   * Test whether two values are equal.
	   *
	   * @param  {number | BigNumber | Fraction | boolean | Complex | Unit} x   First value to compare
	   * @param  {number | BigNumber | Fraction | boolean | Complex} y          Second value to compare
	   * @return {boolean}                                                  Returns true when the compared values are equal, else returns false
	   * @private
	   */
	  var equalScalar = typed('equalScalar', {

	    'boolean, boolean': function (x, y) {
	      return x === y;
	    },

	    'number, number': function (x, y) {
	      return x === y || nearlyEqual(x, y, config.epsilon);
	    },

	    'BigNumber, BigNumber': function (x, y) {
	      return x.eq(y);
	    },

	    'Fraction, Fraction': function (x, y) {
	      return x.equals(y);
	    },

	    'Complex, Complex': function (x, y) {
	      return (x.re === y.re || nearlyEqual(x.re, y.re, config.epsilon)) &&
	        (x.im === y.im || nearlyEqual(x.im, y.im, config.epsilon));
	    },

	    'Unit, Unit': function (x, y) {
	      if (!x.equalBase(y)) {
	        throw new Error('Cannot compare units with different base');
	      }
	      return x.value === y.value || nearlyEqual(x.value, y.value, config.epsilon);
	    },

	    'string, string': function (x, y) {
	      return x === y;
	    }
	  });
	  
	  return equalScalar;
	}

	exports.factory = factory;


/***/ },
/* 34 */
/***/ function(module, exports) {

	'use strict';

	function factory (type, config, load, typed) {

	  var DenseMatrix = type.DenseMatrix;

	  /**
	   * Iterates over SparseMatrix S nonzero items and invokes the callback function f(Sij, b). 
	   * Callback function invoked NZ times (number of nonzero items in S).
	   *
	   *
	   *          ┌  f(Sij, b)  ; S(i,j) !== 0
	   * C(i,j) = ┤  
	   *          └  b          ; otherwise
	   *
	   *
	   * @param {Matrix}   s                 The SparseMatrix instance (S)
	   * @param {Scalar}   b                 The Scalar value
	   * @param {Function} callback          The f(Aij,b) operation to invoke
	   * @param {boolean}  inverse           A true value indicates callback should be invoked f(b,Sij)
	   *
	   * @return {Matrix}                    DenseMatrix (C)
	   *
	   * https://github.com/josdejong/mathjs/pull/346#issuecomment-97626813
	   */
	  var algorithm10 = function (s, b, callback, inverse) {
	    // sparse matrix arrays
	    var avalues = s._values;
	    var aindex = s._index;
	    var aptr = s._ptr;
	    var asize = s._size;
	    var adt = s._datatype;

	    // sparse matrix cannot be a Pattern matrix
	    if (!avalues)
	      throw new Error('Cannot perform operation on Pattern Sparse Matrix and Scalar value');

	    // rows & columns
	    var rows = asize[0];
	    var columns = asize[1];

	    // datatype
	    var dt;
	    // callback signature to use
	    var cf = callback;

	    // process data types
	    if (typeof adt === 'string') {
	      // datatype
	      dt = adt;
	      // convert b to the same datatype
	      b = typed.convert(b, dt);
	      // callback
	      cf = typed.find(callback, [dt, dt]);
	    }

	    // result arrays
	    var cdata = [];
	    // matrix
	    var c = new DenseMatrix({
	      data: cdata,
	      size: [rows, columns],
	      datatype: dt
	    });

	    // workspaces
	    var x = [];
	    // marks indicating we have a value in x for a given column
	    var w = [];

	    // loop columns
	    for (var j = 0; j < columns; j++) {
	      // columns mark
	      var mark = j + 1;
	      // values in j
	      for (var k0 = aptr[j], k1 = aptr[j + 1], k = k0; k < k1; k++) {
	        // row
	        var r = aindex[k];
	        // update workspace
	        x[r] = avalues[k];
	        w[r] = mark;
	      }
	      // loop rows
	      for (var i = 0; i < rows; i++) {
	        // initialize C on first column
	        if (j === 0) {
	          // create row array
	          cdata[i] = [];
	        }
	        // check sparse matrix has a value @ i,j
	        if (w[i] === mark) {
	          // invoke callback, update C
	          cdata[i][j] = inverse ? cf(b, x[i]) : cf(x[i], b);
	        }
	        else {
	          // dense matrix value @ i, j
	          cdata[i][j] = b;
	        }
	      }
	    }

	    // return sparse matrix
	    return c;
	  };

	  return algorithm10;
	}

	exports.name = 'algorithm10';
	exports.factory = factory;


/***/ },
/* 35 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var util = __webpack_require__(36);
	var DimensionError = __webpack_require__(22);

	var string = util.string,
	    isString = string.isString;

	function factory (type, config, load, typed) {

	  var DenseMatrix = type.DenseMatrix;

	  /**
	   * Iterates over DenseMatrix items and invokes the callback function f(Aij..z, Bij..z). 
	   * Callback function invoked MxN times.
	   *
	   * C(i,j,...z) = f(Aij..z, Bij..z)
	   *
	   * @param {Matrix}   a                 The DenseMatrix instance (A)
	   * @param {Matrix}   b                 The DenseMatrix instance (B)
	   * @param {Function} callback          The f(Aij..z,Bij..z) operation to invoke
	   *
	   * @return {Matrix}                    DenseMatrix (C)
	   *
	   * https://github.com/josdejong/mathjs/pull/346#issuecomment-97658658
	   */
	  var algorithm13 = function (a, b, callback) {
	    // a arrays
	    var adata = a._data;
	    var asize = a._size;
	    var adt = a._datatype;
	    // b arrays
	    var bdata = b._data;
	    var bsize = b._size;
	    var bdt = b._datatype;
	    // c arrays
	    var csize = [];

	    // validate dimensions
	    if (asize.length !== bsize.length)
	      throw new DimensionError(asize.length, bsize.length);

	    // validate each one of the dimension sizes
	    for (var s = 0; s < asize.length; s++) {
	      // must match
	      if (asize[s] !== bsize[s])
	        throw new RangeError('Dimension mismatch. Matrix A (' + asize + ') must match Matrix B (' + bsize + ')');
	      // update dimension in c
	      csize[s] = asize[s];
	    }

	    // datatype
	    var dt;
	    // callback signature to use
	    var cf = callback;

	    // process data types
	    if (typeof adt === 'string' && adt === bdt) {
	      // datatype
	      dt = adt;
	      // convert b to the same datatype
	      b = typed.convert(b, dt);
	      // callback
	      cf = typed.find(callback, [dt, dt]);
	    }

	    // populate cdata, iterate through dimensions
	    var cdata = csize.length > 0 ? _iterate(cf, 0, csize, csize[0], adata, bdata) : [];
	    
	    // c matrix
	    return new DenseMatrix({
	      data: cdata,
	      size: csize,
	      datatype: dt
	    });
	  };
	  
	  // recursive function
	  var _iterate = function (f, level, s, n, av, bv) {
	    // initialize array for this level
	    var cv = [];
	    // check we reach the last level
	    if (level === s.length - 1) {
	      // loop arrays in last level
	      for (var i = 0; i < n; i++) {
	        // invoke callback and store value
	        cv[i] = f(av[i], bv[i]);
	      }
	    }
	    else {
	      // iterate current level
	      for (var j = 0; j < n; j++) {
	        // iterate next level
	        cv[j] = _iterate(f, level + 1, s, s[level + 1], av[j], bv[j]);
	      }
	    }
	    return cv;
	  };
	  
	  return algorithm13;
	}

	exports.name = 'algorithm13';
	exports.factory = factory;


/***/ },
/* 36 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	exports.array = __webpack_require__(18);
	exports['boolean'] = __webpack_require__(37);
	exports['function'] = __webpack_require__(38);
	exports.number = __webpack_require__(8);
	exports.object = __webpack_require__(5);
	exports.string = __webpack_require__(20);
	exports.types = __webpack_require__(19);
	exports.emitter = __webpack_require__(3);


/***/ },
/* 37 */
/***/ function(module, exports) {

	'use strict';

	/**
	 * Test whether value is a boolean
	 * @param {*} value
	 * @return {boolean} isBoolean
	 */
	exports.isBoolean = function(value) {
	  return typeof value == 'boolean';
	};


/***/ },
/* 38 */
/***/ function(module, exports) {

	// function utils

	/*
	 * Memoize a given function by caching the computed result.
	 * The cache of a memoized function can be cleared by deleting the `cache`
	 * property of the function.
	 *
	 * @param {function} fn                     The function to be memoized.
	 *                                          Must be a pure function.
	 * @param {function(args: Array)} [hasher]  A custom hash builder.
	 *                                          Is JSON.stringify by default.
	 * @return {function}                       Returns the memoized function
	 */
	exports.memoize = function(fn, hasher) {
	  return function memoize() {
	    if (typeof memoize.cache !== 'object') {
	      memoize.cache = {};
	    }

	    var args = [];
	    for (var i = 0; i < arguments.length; i++) {
	      args[i] = arguments[i];
	    }

	    var hash = hasher ? hasher(args) : JSON.stringify(args);
	    if (!(hash in memoize.cache)) {
	      return memoize.cache[hash] = fn.apply(fn, args);
	    }
	    return memoize.cache[hash];
	  };
	};


/***/ },
/* 39 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var clone = __webpack_require__(5).clone;

	function factory (type, config, load, typed) {

	  var DenseMatrix = type.DenseMatrix;

	  /**
	   * Iterates over DenseMatrix items and invokes the callback function f(Aij..z, b). 
	   * Callback function invoked MxN times.
	   *
	   * C(i,j,...z) = f(Aij..z, b)
	   *
	   * @param {Matrix}   a                 The DenseMatrix instance (A)
	   * @param {Scalar}   b                 The Scalar value
	   * @param {Function} callback          The f(Aij..z,b) operation to invoke
	   * @param {boolean}  inverse           A true value indicates callback should be invoked f(b,Aij..z)
	   *
	   * @return {Matrix}                    DenseMatrix (C)
	   *
	   * https://github.com/josdejong/mathjs/pull/346#issuecomment-97659042
	   */
	  var algorithm14 = function (a, b, callback, inverse) {
	    // a arrays
	    var adata = a._data;
	    var asize = a._size;
	    var adt = a._datatype;
	    
	    // datatype
	    var dt;
	    // callback signature to use
	    var cf = callback;

	    // process data types
	    if (typeof adt === 'string') {
	      // datatype
	      dt = adt;
	      // convert b to the same datatype
	      b = typed.convert(b, dt);
	      // callback
	      cf = typed.find(callback, [dt, dt]);
	    }
	    
	    // populate cdata, iterate through dimensions
	    var cdata = asize.length > 0 ? _iterate(cf, 0, asize, asize[0], adata, b, inverse) : [];

	    // c matrix
	    return new DenseMatrix({
	      data: cdata,
	      size: clone(asize),
	      datatype: dt
	    });
	  };
	  
	  // recursive function
	  var _iterate = function (f, level, s, n, av, bv, inverse) {
	    // initialize array for this level
	    var cv = [];
	    // check we reach the last level
	    if (level === s.length - 1) {
	      // loop arrays in last level
	      for (var i = 0; i < n; i++) {
	        // invoke callback and store value
	        cv[i] = inverse ? f(bv, av[i]) : f(av[i], bv);
	      }
	    }
	    else {
	      // iterate current level
	      for (var j = 0; j < n; j++) {
	        // iterate next level
	        cv[j] = _iterate(f, level + 1, s, s[level + 1], av[j], bv, inverse);
	      }
	    }
	    return cv;
	  };

	  return algorithm14;
	}

	exports.name = 'algorithm14';
	exports.factory = factory;


/***/ },
/* 40 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var extend = __webpack_require__(5).extend;
	var array = __webpack_require__(18);

	function factory (type, config, load, typed) {
	  var latex = __webpack_require__(26);

	  var matrix = load(__webpack_require__(23));
	  var addScalar = load(__webpack_require__(27));
	  var multiplyScalar = load(__webpack_require__(41));
	  var equalScalar = load(__webpack_require__(33));

	  var algorithm11 = load(__webpack_require__(42));
	  var algorithm14 = load(__webpack_require__(39));
	  
	  var DenseMatrix = type.DenseMatrix;
	  var SparseMatrix = type.SparseMatrix;

	  /**
	   * Multiply two values, `x * y`. The result is squeezed.
	   * For matrices, the matrix product is calculated.
	   *
	   * Syntax:
	   *
	   *    math.multiply(x, y)
	   *
	   * Examples:
	   *
	   *    math.multiply(4, 5.2);        // returns number 20.8
	   *
	   *    var a = math.complex(2, 3);
	   *    var b = math.complex(4, 1);
	   *    math.multiply(a, b);          // returns Complex 5 + 14i
	   *
	   *    var c = [[1, 2], [4, 3]];
	   *    var d = [[1, 2, 3], [3, -4, 7]];
	   *    math.multiply(c, d);          // returns Array [[7, -6, 17], [13, -4, 33]]
	   *
	   *    var e = math.unit('2.1 km');
	   *    math.multiply(3, e);          // returns Unit 6.3 km
	   *
	   * See also:
	   *
	   *    divide
	   *
	   * @param  {number | BigNumber | Fraction | Complex | Unit | Array | Matrix} x First value to multiply
	   * @param  {number | BigNumber | Fraction | Complex | Unit | Array | Matrix} y Second value to multiply
	   * @return {number | BigNumber | Fraction | Complex | Unit | Array | Matrix} Multiplication of `x` and `y`
	   */
	  var multiply = typed('multiply', extend({
	    // we extend the signatures of multiplyScalar with signatures dealing with matrices

	    'Array, Array': function (x, y) {
	      // check dimensions
	      _validateMatrixDimensions(array.size(x), array.size(y));

	      // use dense matrix implementation
	      var m = multiply(matrix(x), matrix(y));
	      // return array or scalar
	      return (m && m.isMatrix === true) ? m.valueOf() : m;
	    },

	    'Matrix, Matrix': function (x, y) {
	      // dimensions
	      var xsize = x.size();
	      var ysize = y.size();

	      // check dimensions
	      _validateMatrixDimensions(xsize, ysize);

	      // process dimensions
	      if (xsize.length === 1) {
	        // process y dimensions
	        if (ysize.length === 1) {
	          // Vector * Vector
	          return _multiplyVectorVector(x, y, xsize[0]);
	        }
	        // Vector * Matrix
	        return _multiplyVectorMatrix(x, y);
	      }
	      // process y dimensions
	      if (ysize.length === 1) {
	        // Matrix * Vector
	        return _multiplyMatrixVector(x, y);
	      }
	      // Matrix * Matrix
	      return _multiplyMatrixMatrix(x, y);
	    },

	    'Matrix, Array': function (x, y) {
	      // use Matrix * Matrix implementation
	      return multiply(x, matrix(y));
	    },

	    'Array, Matrix': function (x, y) {
	      // use Matrix * Matrix implementation
	      return multiply(matrix(x, y.storage()), y);
	    },

	    'Matrix, any': function (x, y) {
	      // result
	      var c;
	      
	      // process storage format
	      switch (x.storage()) {
	        case 'sparse':
	          c = algorithm11(x, y, multiplyScalar, false);
	          break;
	        case 'dense':
	          c = algorithm14(x, y, multiplyScalar, false);
	          break;
	      }
	      return c;
	    },

	    'any, Matrix': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (y.storage()) {
	        case 'sparse':
	          c = algorithm11(y, x, multiplyScalar, true);
	          break;
	        case 'dense':
	          c = algorithm14(y, x, multiplyScalar, true);
	          break;
	      }
	      return c;
	    },

	    'Array, any': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(x), y, multiplyScalar, false).valueOf();
	    },

	    'any, Array': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(y), x, multiplyScalar, true).valueOf();
	    }
	  }, multiplyScalar.signatures));

	  var _validateMatrixDimensions = function (size1, size2) {
	    // check left operand dimensions
	    switch (size1.length) {
	      case 1:
	        // check size2
	        switch (size2.length) {
	          case 1:
	            // Vector x Vector
	            if (size1[0] !== size2[0]) {
	              // throw error
	              throw new RangeError('Dimension mismatch in multiplication. Vectors must have the same length');
	            }
	            break;
	          case 2:
	            // Vector x Matrix
	            if (size1[0] !== size2[0]) {
	              // throw error
	              throw new RangeError('Dimension mismatch in multiplication. Vector length (' + size1[0] + ') must match Matrix rows (' + size2[0] + ')');
	            }
	            break;
	          default:
	            throw new Error('Can only multiply a 1 or 2 dimensional matrix (Matrix B has ' + size2.length + ' dimensions)');
	        }
	        break;
	      case 2:
	        // check size2
	        switch (size2.length) {
	          case 1:
	            // Matrix x Vector
	            if (size1[1] !== size2[0]) {
	              // throw error
	              throw new RangeError('Dimension mismatch in multiplication. Matrix columns (' + size1[1] + ') must match Vector length (' + size2[0] + ')');
	            }
	            break;
	          case 2:
	            // Matrix x Matrix
	            if (size1[1] !== size2[0]) {
	              // throw error
	              throw new RangeError('Dimension mismatch in multiplication. Matrix A columns (' + size1[1] + ') must match Matrix B rows (' + size2[0] + ')');
	            }
	            break;
	          default:
	            throw new Error('Can only multiply a 1 or 2 dimensional matrix (Matrix B has ' + size2.length + ' dimensions)');
	        }
	        break;
	      default:
	        throw new Error('Can only multiply a 1 or 2 dimensional matrix (Matrix A has ' + size1.length + ' dimensions)');
	    }
	  };

	  /**
	   * C = A * B
	   *
	   * @param {Matrix} a            Dense Vector   (N)
	   * @param {Matrix} b            Dense Vector   (N)
	   *
	   * @return {number}             Scalar value
	   */
	  var _multiplyVectorVector = function (a, b, n) {
	    // check empty vector
	    if (n === 0)
	      throw new Error('Cannot multiply two empty vectors');

	    // a dense
	    var adata = a._data;
	    var adt = a._datatype;
	    // b dense
	    var bdata = b._data;
	    var bdt = b._datatype;

	    // datatype
	    var dt;
	    // addScalar signature to use
	    var af = addScalar;
	    // multiplyScalar signature to use
	    var mf = multiplyScalar;

	    // process data types
	    if (adt && bdt && adt === bdt && typeof adt === 'string') {
	      // datatype
	      dt = adt;
	      // find signatures that matches (dt, dt)
	      af = typed.find(addScalar, [dt, dt]);
	      mf = typed.find(multiplyScalar, [dt, dt]);
	    }
	    
	    // result (do not initialize it with zero)
	    var c = mf(adata[0], bdata[0]);
	    // loop data
	    for (var i = 1; i < n; i++) {
	      // multiply and accumulate
	      c = af(c, mf(adata[i], bdata[i]));
	    }
	    return c;
	  };

	  /**
	   * C = A * B
	   *
	   * @param {Matrix} a            Dense Vector   (M)
	   * @param {Matrix} b            Matrix         (MxN)
	   *
	   * @return {Matrix}             Dense Vector   (N)
	   */
	  var _multiplyVectorMatrix = function (a, b) {
	    // process storage
	    switch (b.storage()) {
	      case 'dense':
	        return _multiplyVectorDenseMatrix(a, b);
	    }
	    throw new Error('Not implemented');
	  };

	  /**
	   * C = A * B
	   *
	   * @param {Matrix} a            Dense Vector   (M)
	   * @param {Matrix} b            Dense Matrix   (MxN)
	   *
	   * @return {Matrix}             Dense Vector   (N)
	   */
	  var _multiplyVectorDenseMatrix = function (a, b) {
	    // a dense
	    var adata = a._data;
	    var asize = a._size;
	    var adt = a._datatype;
	    // b dense
	    var bdata = b._data;
	    var bsize = b._size;
	    var bdt = b._datatype;
	    // rows & columns
	    var alength = asize[0];
	    var bcolumns = bsize[1];

	    // datatype
	    var dt;
	    // addScalar signature to use
	    var af = addScalar;
	    // multiplyScalar signature to use
	    var mf = multiplyScalar;

	    // process data types
	    if (adt && bdt && adt === bdt && typeof adt === 'string') {
	      // datatype
	      dt = adt;
	      // find signatures that matches (dt, dt)
	      af = typed.find(addScalar, [dt, dt]);
	      mf = typed.find(multiplyScalar, [dt, dt]);
	    }

	    // result
	    var c = [];

	    // loop matrix columns
	    for (var j = 0; j < bcolumns; j++) {
	      // sum (do not initialize it with zero)
	      var sum = mf(adata[0], bdata[0][j]);      
	      // loop vector
	      for (var i = 1; i < alength; i++) {
	        // multiply & accumulate
	        sum = af(sum, mf(adata[i], bdata[i][j]));
	      }
	      c[j] = sum;
	    }

	    // check we need to squeeze the result into a scalar
	    if (bcolumns === 1)
	      return c[0];

	    // return matrix
	    return new DenseMatrix({
	      data: c,
	      size: [bcolumns],
	      datatype: dt
	    });
	  };

	  /**
	   * C = A * B
	   *
	   * @param {Matrix} a            Matrix         (MxN)
	   * @param {Matrix} b            Dense Vector   (N)
	   *
	   * @return {Matrix}             Dense Vector   (M)
	   */
	  var _multiplyMatrixVector = function (a, b) {
	    // process storage
	    switch (a.storage()) {
	      case 'dense':
	        return _multiplyDenseMatrixVector(a, b);
	      case 'sparse':
	        return _multiplySparseMatrixVector(a, b);
	    }
	  };

	  /**
	   * C = A * B
	   *
	   * @param {Matrix} a            Matrix         (MxN)
	   * @param {Matrix} b            Matrix         (NxC)
	   *
	   * @return {Matrix}             Matrix         (MxC)
	   */
	  var _multiplyMatrixMatrix = function (a, b) {
	    // process storage
	    switch (a.storage()) {
	      case 'dense':
	        // process storage
	        switch (b.storage()) {
	          case 'dense':
	            return _multiplyDenseMatrixDenseMatrix(a, b);
	          case 'sparse':
	            return _multiplyDenseMatrixSparseMatrix(a, b);
	        }
	        break;
	      case 'sparse':
	        // process storage
	        switch (b.storage()) {
	          case 'dense':
	            return _multiplySparseMatrixDenseMatrix(a, b);
	          case 'sparse':
	            return _multiplySparseMatrixSparseMatrix(a, b);
	        }
	        break;
	    }
	  };

	  /**
	   * C = A * B
	   *
	   * @param {Matrix} a            DenseMatrix  (MxN)
	   * @param {Matrix} b            Dense Vector (N)
	   *
	   * @return {Matrix}             Dense Vector (M) 
	   */ 
	  var _multiplyDenseMatrixVector = function (a, b) {
	    // a dense
	    var adata = a._data;
	    var asize = a._size;
	    var adt = a._datatype;
	    // b dense
	    var bdata = b._data;
	    var bdt = b._datatype;
	    // rows & columns
	    var arows = asize[0];
	    var acolumns = asize[1];

	    // datatype
	    var dt;
	    // addScalar signature to use
	    var af = addScalar;
	    // multiplyScalar signature to use
	    var mf = multiplyScalar;

	    // process data types
	    if (adt && bdt && adt === bdt && typeof adt === 'string') {
	      // datatype
	      dt = adt;
	      // find signatures that matches (dt, dt)
	      af = typed.find(addScalar, [dt, dt]);
	      mf = typed.find(multiplyScalar, [dt, dt]);
	    }

	    // result
	    var c = [];

	    // loop matrix a rows
	    for (var i = 0; i < arows; i++) {
	      // current row
	      var row = adata[i];
	      // sum (do not initialize it with zero)
	      var sum = mf(row[0], bdata[0]);
	      // loop matrix a columns
	      for (var j = 1; j < acolumns; j++) {
	        // multiply & accumulate
	        sum = af(sum, mf(row[j], bdata[j]));
	      }
	      c[i] = sum;
	    }
	    // check we need to squeeze the result into a scalar
	    if (arows === 1)
	      return c[0];

	    // return matrix
	    return new DenseMatrix({
	      data: c,
	      size: [arows],
	      datatype: dt
	    });
	  };

	  /**
	   * C = A * B
	   *
	   * @param {Matrix} a            DenseMatrix    (MxN)
	   * @param {Matrix} b            DenseMatrix    (NxC)
	   *
	   * @return {Matrix}             DenseMatrix    (MxC)
	   */
	  var _multiplyDenseMatrixDenseMatrix = function (a, b) {
	    // a dense
	    var adata = a._data;
	    var asize = a._size;
	    var adt = a._datatype;
	    // b dense
	    var bdata = b._data;
	    var bsize = b._size;
	    var bdt = b._datatype;
	    // rows & columns
	    var arows = asize[0];
	    var acolumns = asize[1];
	    var bcolumns = bsize[1];

	    // datatype
	    var dt;
	    // addScalar signature to use
	    var af = addScalar;
	    // multiplyScalar signature to use
	    var mf = multiplyScalar;

	    // process data types
	    if (adt && bdt && adt === bdt && typeof adt === 'string') {
	      // datatype
	      dt = adt;
	      // find signatures that matches (dt, dt)
	      af = typed.find(addScalar, [dt, dt]);
	      mf = typed.find(multiplyScalar, [dt, dt]);
	    }
	    
	    // result
	    var c = [];

	    // loop matrix a rows
	    for (var i = 0; i < arows; i++) {
	      // current row
	      var row = adata[i];
	      // initialize row array
	      c[i] = [];
	      // loop matrix b columns
	      for (var j = 0; j < bcolumns; j++) {
	        // sum (avoid initializing sum to zero)
	        var sum = mf(row[0], bdata[0][j]);
	        // loop matrix a columns
	        for (var x = 1; x < acolumns; x++) {
	          // multiply & accumulate
	          sum = af(sum, mf(row[x], bdata[x][j]));
	        }
	        c[i][j] = sum;
	      }
	    }
	    // check we need to squeeze the result into a scalar
	    if (arows === 1 && bcolumns === 1)
	      return c[0][0];

	    // return matrix
	    return new DenseMatrix({
	      data: c,
	      size: [arows, bcolumns],
	      datatype: dt
	    });
	  };

	  /**
	   * C = A * B
	   *
	   * @param {Matrix} a            DenseMatrix    (MxN)
	   * @param {Matrix} b            SparseMatrix   (NxC)
	   *
	   * @return {Matrix}             SparseMatrix   (MxC)
	   */
	  var _multiplyDenseMatrixSparseMatrix = function (a, b) {
	    // a dense
	    var adata = a._data;
	    var asize = a._size;
	    var adt = a._datatype;
	    // b sparse
	    var bvalues = b._values;
	    var bindex = b._index;
	    var bptr = b._ptr;
	    var bsize = b._size;
	    var bdt = b._datatype;
	    // validate b matrix
	    if (!bvalues)
	      throw new Error('Cannot multiply Dense Matrix times Pattern only Matrix');
	    // rows & columns
	    var arows = asize[0];
	    var bcolumns = bsize[1];
	    
	    // datatype
	    var dt;
	    // addScalar signature to use
	    var af = addScalar;
	    // multiplyScalar signature to use
	    var mf = multiplyScalar;
	    // equalScalar signature to use
	    var eq = equalScalar;
	    // zero value
	    var zero = 0;

	    // process data types
	    if (adt && bdt && adt === bdt && typeof adt === 'string') {
	      // datatype
	      dt = adt;
	      // find signatures that matches (dt, dt)
	      af = typed.find(addScalar, [dt, dt]);
	      mf = typed.find(multiplyScalar, [dt, dt]);
	      eq = typed.find(equalScalar, [dt, dt]);
	      // convert 0 to the same datatype
	      zero = typed.convert(0, dt);
	    }

	    // result
	    var cvalues = [];
	    var cindex = [];
	    var cptr = [];
	    // c matrix
	    var c = new SparseMatrix({
	      values : cvalues,
	      index: cindex,
	      ptr: cptr,
	      size: [arows, bcolumns],
	      datatype: dt
	    });

	    // loop b columns
	    for (var jb = 0; jb < bcolumns; jb++) {
	      // update ptr
	      cptr[jb] = cindex.length;
	      // indeces in column jb
	      var kb0 = bptr[jb];
	      var kb1 = bptr[jb + 1];
	      // do not process column jb if no data exists
	      if (kb1 > kb0) {
	        // last row mark processed
	        var last = 0;
	        // loop a rows
	        for (var i = 0; i < arows; i++) {
	          // column mark
	          var mark = i + 1;
	          // C[i, jb]
	          var cij;
	          // values in b column j
	          for (var kb = kb0; kb < kb1; kb++) {
	            // row
	            var ib = bindex[kb];
	            // check value has been initialized
	            if (last !== mark) {
	              // first value in column jb
	              cij = mf(adata[i][ib], bvalues[kb]);
	              // update mark
	              last = mark;
	            }
	            else {
	              // accumulate value
	              cij = af(cij, mf(adata[i][ib], bvalues[kb]));
	            }
	          }
	          // check column has been processed and value != 0
	          if (last === mark && !eq(cij, zero)) {
	            // push row & value
	            cindex.push(i);
	            cvalues.push(cij);
	          }
	        }
	      }
	    }
	    // update ptr
	    cptr[bcolumns] = cindex.length;

	    // check we need to squeeze the result into a scalar
	    if (arows === 1 && bcolumns === 1)
	      return cvalues.length === 1 ? cvalues[0] : 0;

	    // return sparse matrix
	    return c;
	  };

	  /**
	   * C = A * B
	   *
	   * @param {Matrix} a            SparseMatrix    (MxN)
	   * @param {Matrix} b            Dense Vector (N)
	   *
	   * @return {Matrix}             SparseMatrix    (M, 1) 
	   */
	  var _multiplySparseMatrixVector = function (a, b) {
	    // a sparse
	    var avalues = a._values;
	    var aindex = a._index;
	    var aptr = a._ptr;
	    var adt = a._datatype;
	    // validate a matrix
	    if (!avalues)
	      throw new Error('Cannot multiply Pattern only Matrix times Dense Matrix');
	    // b dense
	    var bdata = b._data;
	    var bdt = b._datatype;
	    // rows & columns
	    var arows = a._size[0];
	    var brows = b._size[0];
	    // result
	    var cvalues = [];
	    var cindex = [];
	    var cptr = [];
	    
	    // datatype
	    var dt;
	    // addScalar signature to use
	    var af = addScalar;
	    // multiplyScalar signature to use
	    var mf = multiplyScalar;
	    // equalScalar signature to use
	    var eq = equalScalar;
	    // zero value
	    var zero = 0;

	    // process data types
	    if (adt && bdt && adt === bdt && typeof adt === 'string') {
	      // datatype
	      dt = adt;
	      // find signatures that matches (dt, dt)
	      af = typed.find(addScalar, [dt, dt]);
	      mf = typed.find(multiplyScalar, [dt, dt]);
	      eq = typed.find(equalScalar, [dt, dt]);
	      // convert 0 to the same datatype
	      zero = typed.convert(0, dt);
	    }

	    // workspace
	    var x = [];
	    // vector with marks indicating a value x[i] exists in a given column
	    var w = [];

	    // update ptr
	    cptr[0] = 0;
	    // rows in b
	    for (var ib = 0; ib < brows; ib++) {
	      // b[ib]
	      var vbi = bdata[ib];
	      // check b[ib] != 0, avoid loops
	      if (!eq(vbi, zero)) {
	        // A values & index in ib column
	        for (var ka0 = aptr[ib], ka1 = aptr[ib + 1], ka = ka0; ka < ka1; ka++) {
	          // a row
	          var ia = aindex[ka];
	          // check value exists in current j
	          if (!w[ia]) {
	            // ia is new entry in j
	            w[ia] = true;
	            // add i to pattern of C
	            cindex.push(ia);
	            // x(ia) = A
	            x[ia] = mf(vbi, avalues[ka]);
	          }
	          else {
	            // i exists in C already
	            x[ia] = af(x[ia], mf(vbi, avalues[ka]));
	          }
	        }
	      }
	    }
	    // copy values from x to column jb of c
	    for (var p1 = cindex.length, p = 0; p < p1; p++) {
	      // row
	      var ic = cindex[p];
	      // copy value
	      cvalues[p] = x[ic];
	    }
	    // update ptr
	    cptr[1] = cindex.length;

	    // check we need to squeeze the result into a scalar
	    if (arows === 1)
	      return cvalues.length === 1 ? cvalues[0] : 0;

	    // return sparse matrix
	    return new SparseMatrix({
	      values : cvalues,
	      index: cindex,
	      ptr: cptr,
	      size: [arows, 1],
	      datatype: dt
	    });
	  };

	  /**
	   * C = A * B
	   *
	   * @param {Matrix} a            SparseMatrix      (MxN)
	   * @param {Matrix} b            DenseMatrix       (NxC)
	   *
	   * @return {Matrix}             SparseMatrix      (MxC)
	   */
	  var _multiplySparseMatrixDenseMatrix = function (a, b) {
	    // a sparse
	    var avalues = a._values;
	    var aindex = a._index;
	    var aptr = a._ptr;
	    var adt = a._datatype;
	    // validate a matrix
	    if (!avalues)
	      throw new Error('Cannot multiply Pattern only Matrix times Dense Matrix');
	    // b dense
	    var bdata = b._data;
	    var bdt = b._datatype;
	    // rows & columns
	    var arows = a._size[0];
	    var brows = b._size[0];
	    var bcolumns = b._size[1];

	    // datatype
	    var dt;
	    // addScalar signature to use
	    var af = addScalar;
	    // multiplyScalar signature to use
	    var mf = multiplyScalar;
	    // equalScalar signature to use
	    var eq = equalScalar;
	    // zero value
	    var zero = 0;

	    // process data types
	    if (adt && bdt && adt === bdt && typeof adt === 'string') {
	      // datatype
	      dt = adt;
	      // find signatures that matches (dt, dt)
	      af = typed.find(addScalar, [dt, dt]);
	      mf = typed.find(multiplyScalar, [dt, dt]);
	      eq = typed.find(equalScalar, [dt, dt]);
	      // convert 0 to the same datatype
	      zero = typed.convert(0, dt);
	    }

	    // result
	    var cvalues = [];
	    var cindex = [];
	    var cptr = [];
	    // c matrix
	    var c = new SparseMatrix({
	      values : cvalues,
	      index: cindex,
	      ptr: cptr,
	      size: [arows, bcolumns],
	      datatype: dt
	    });

	    // workspace
	    var x = [];
	    // vector with marks indicating a value x[i] exists in a given column
	    var w = [];

	    // loop b columns
	    for (var jb = 0; jb < bcolumns; jb++) {
	      // update ptr
	      cptr[jb] = cindex.length;
	      // mark in workspace for current column
	      var mark = jb + 1;
	      // rows in jb
	      for (var ib = 0; ib < brows; ib++) {
	        // b[ib, jb]
	        var vbij = bdata[ib][jb];
	        // check b[ib, jb] != 0, avoid loops
	        if (!eq(vbij, zero)) {
	          // A values & index in ib column
	          for (var ka0 = aptr[ib], ka1 = aptr[ib + 1], ka = ka0; ka < ka1; ka++) {
	            // a row
	            var ia = aindex[ka];
	            // check value exists in current j
	            if (w[ia] !== mark) {
	              // ia is new entry in j
	              w[ia] = mark;
	              // add i to pattern of C
	              cindex.push(ia);
	              // x(ia) = A
	              x[ia] = mf(vbij, avalues[ka]);
	            }
	            else {
	              // i exists in C already
	              x[ia] = af(x[ia], mf(vbij, avalues[ka]));
	            }
	          }
	        }
	      }
	      // copy values from x to column jb of c
	      for (var p0 = cptr[jb], p1 = cindex.length, p = p0; p < p1; p++) {
	        // row
	        var ic = cindex[p];
	        // copy value
	        cvalues[p] = x[ic];
	      }
	    }
	    // update ptr
	    cptr[bcolumns] = cindex.length;

	    // check we need to squeeze the result into a scalar
	    if (arows === 1 && bcolumns === 1)
	      return cvalues.length === 1 ? cvalues[0] : 0;

	    // return sparse matrix
	    return c;
	  };

	  /**
	   * C = A * B
	   *
	   * @param {Matrix} a            SparseMatrix      (MxN)
	   * @param {Matrix} b            SparseMatrix      (NxC)
	   *
	   * @return {Matrix}             SparseMatrix      (MxC)
	   */
	  var _multiplySparseMatrixSparseMatrix = function (a, b) {
	    // a sparse
	    var avalues = a._values;
	    var aindex = a._index;
	    var aptr = a._ptr;
	    var adt = a._datatype;
	    // b sparse
	    var bvalues = b._values;
	    var bindex = b._index;
	    var bptr = b._ptr;
	    var bdt = b._datatype;
	    
	    // rows & columns
	    var arows = a._size[0];
	    var bcolumns = b._size[1];
	    // flag indicating both matrices (a & b) contain data
	    var values = avalues && bvalues;

	    // datatype
	    var dt;
	    // addScalar signature to use
	    var af = addScalar;
	    // multiplyScalar signature to use
	    var mf = multiplyScalar;

	    // process data types
	    if (adt && bdt && adt === bdt && typeof adt === 'string') {
	      // datatype
	      dt = adt;
	      // find signatures that matches (dt, dt)
	      af = typed.find(addScalar, [dt, dt]);
	      mf = typed.find(multiplyScalar, [dt, dt]);
	    }
	    
	    // result
	    var cvalues = values ? [] : undefined;
	    var cindex = [];
	    var cptr = [];
	    // c matrix
	    var c = new SparseMatrix({
	      values : cvalues,
	      index: cindex,
	      ptr: cptr,
	      size: [arows, bcolumns],
	      datatype: dt
	    });

	    // workspace
	    var x = values ? [] : undefined;
	    // vector with marks indicating a value x[i] exists in a given column
	    var w = [];
	    // variables
	    var ka, ka0, ka1, kb, kb0, kb1, ia, ib;
	    // loop b columns
	    for (var jb = 0; jb < bcolumns; jb++) {
	      // update ptr
	      cptr[jb] = cindex.length;
	      // mark in workspace for current column
	      var mark = jb + 1;
	      // B values & index in j
	      for (kb0 = bptr[jb], kb1 = bptr[jb + 1], kb = kb0; kb < kb1; kb++) {
	        // b row
	        ib = bindex[kb];
	        // check we need to process values
	        if (values) {
	          // loop values in a[:,ib]
	          for (ka0 = aptr[ib], ka1 = aptr[ib + 1], ka = ka0; ka < ka1; ka++) {
	            // row
	            ia = aindex[ka];
	            // check value exists in current j
	            if (w[ia] !== mark) {
	              // ia is new entry in j
	              w[ia] = mark;
	              // add i to pattern of C
	              cindex.push(ia);
	              // x(ia) = A
	              x[ia] = mf(bvalues[kb], avalues[ka]);
	            }
	            else {
	              // i exists in C already
	              x[ia] = af(x[ia], mf(bvalues[kb], avalues[ka]));
	            }
	          }
	        }
	        else {
	          // loop values in a[:,ib]
	          for (ka0 = aptr[ib], ka1 = aptr[ib + 1], ka = ka0; ka < ka1; ka++) {
	            // row
	            ia = aindex[ka];
	            // check value exists in current j
	            if (w[ia] !== mark) {
	              // ia is new entry in j
	              w[ia] = mark;
	              // add i to pattern of C
	              cindex.push(ia);
	            }
	          }
	        }
	      }
	      // check we need to process matrix values (pattern matrix)
	      if (values) {
	        // copy values from x to column jb of c
	        for (var p0 = cptr[jb], p1 = cindex.length, p = p0; p < p1; p++) {
	          // row
	          var ic = cindex[p];
	          // copy value
	          cvalues[p] = x[ic];
	        }
	      }
	    }
	    // update ptr
	    cptr[bcolumns] = cindex.length;

	    // check we need to squeeze the result into a scalar
	    if (arows === 1 && bcolumns === 1 && values)
	      return cvalues.length === 1 ? cvalues[0] : 0;

	    // return sparse matrix
	    return c;
	  };

	  multiply.toTex = '\\left(${args[0]}' + latex.operators['multiply'] + '${args[1]}\\right)';

	  return multiply;
	}

	exports.name = 'multiply';
	exports.factory = factory;


/***/ },
/* 41 */
/***/ function(module, exports) {

	'use strict';

	function factory(type, config, load, typed) {
	  
	  /**
	   * Multiply two scalar values, `x * y`.
	   * This function is meant for internal use: it is used by the public function
	   * `multiply`
	   *
	   * This function does not support collections (Array or Matrix), and does
	   * not validate the number of of inputs.
	   *
	   * @param  {number | BigNumber | Fraction | Complex | Unit} x   First value to multiply
	   * @param  {number | BigNumber | Fraction | Complex} y          Second value to multiply
	   * @return {number | BigNumber | Fraction | Complex | Unit}                      Multiplication of `x` and `y`
	   * @private
	   */
	  var multiplyScalar = typed('multiplyScalar', {

	    'number, number': function (x, y) {
	      return x * y;
	    },

	    'Complex, Complex': function (x, y) {
	      return new type.Complex(
	        x.re * y.re - x.im * y.im,
	        x.re * y.im + x.im * y.re
	      );
	    },

	    'BigNumber, BigNumber': function (x, y) {
	      return x.times(y);
	    },

	    'Fraction, Fraction': function (x, y) {
	      return x.mul(y);
	    },

	    'number, Unit': function (x, y) {
	      var res = y.clone();
	      res.value = (res.value === null) ? res._normalize(x) : (res.value * x);
	      return res;
	    },

	    'Unit, number': function (x, y) {
	      var res = x.clone();
	      res.value = (res.value === null) ? res._normalize(y) : (res.value * y);
	      return res;
	    }
	  });

	  return multiplyScalar;
	}

	exports.factory = factory;


/***/ },
/* 42 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	function factory (type, config, load, typed) {

	  var equalScalar = load(__webpack_require__(33));

	  var SparseMatrix = type.SparseMatrix;

	  /**
	   * Iterates over SparseMatrix S nonzero items and invokes the callback function f(Sij, b). 
	   * Callback function invoked NZ times (number of nonzero items in S).
	   *
	   *
	   *          ┌  f(Sij, b)  ; S(i,j) !== 0
	   * C(i,j) = ┤  
	   *          └  0          ; otherwise
	   *
	   *
	   * @param {Matrix}   s                 The SparseMatrix instance (S)
	   * @param {Scalar}   b                 The Scalar value
	   * @param {Function} callback          The f(Aij,b) operation to invoke
	   * @param {boolean}  inverse           A true value indicates callback should be invoked f(b,Sij)
	   *
	   * @return {Matrix}                    SparseMatrix (C)
	   *
	   * https://github.com/josdejong/mathjs/pull/346#issuecomment-97626813
	   */
	  var algorithm11 = function (s, b, callback, inverse) {
	    // sparse matrix arrays
	    var avalues = s._values;
	    var aindex = s._index;
	    var aptr = s._ptr;
	    var asize = s._size;
	    var adt = s._datatype;

	    // sparse matrix cannot be a Pattern matrix
	    if (!avalues)
	      throw new Error('Cannot perform operation on Pattern Sparse Matrix and Scalar value');

	    // rows & columns
	    var rows = asize[0];
	    var columns = asize[1];

	    // datatype
	    var dt;
	    // equal signature to use
	    var eq = equalScalar;
	    // zero value
	    var zero = 0;
	    // callback signature to use
	    var cf = callback;

	    // process data types
	    if (typeof adt === 'string') {
	      // datatype
	      dt = adt;
	      // find signature that matches (dt, dt)
	      eq = typed.find(equalScalar, [dt, dt]);
	      // convert 0 to the same datatype
	      zero = typed.convert(0, dt);
	      // convert b to the same datatype
	      b = typed.convert(b, dt);
	      // callback
	      cf = typed.find(callback, [dt, dt]);
	    }

	    // result arrays
	    var cvalues = [];
	    var cindex = [];
	    var cptr = [];
	    // matrix
	    var c = new SparseMatrix({
	      values: cvalues,
	      index: cindex,
	      ptr: cptr,
	      size: [rows, columns],
	      datatype: dt
	    });

	    // loop columns
	    for (var j = 0; j < columns; j++) {
	      // initialize ptr
	      cptr[j] = cindex.length;
	      // values in j
	      for (var k0 = aptr[j], k1 = aptr[j + 1], k = k0; k < k1; k++) {
	        // row
	        var i = aindex[k];
	        // invoke callback
	        var v = inverse ? cf(b, avalues[k]) : cf(avalues[k], b);
	        // check value is zero
	        if (!eq(v, zero)) {
	          // push index & value
	          cindex.push(i);
	          cvalues.push(v);
	        }
	      }
	    }
	    // update ptr
	    cptr[columns] = cindex.length;

	    // return sparse matrix
	    return c;
	  };

	  return algorithm11;
	}

	exports.name = 'algorithm11';
	exports.factory = factory;


/***/ },
/* 43 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var util = __webpack_require__(36);
	var object = util.object;
	var string = util.string;

	function factory (type, config, load, typed) {
	  var matrix = load(__webpack_require__(23));
	  var add = load(__webpack_require__(44));
	  var subtract = load(__webpack_require__(25));
	  var multiply = load(__webpack_require__(40));
	  var unaryMinus = load(__webpack_require__(28));

	  /**
	   * Calculate the determinant of a matrix.
	   *
	   * Syntax:
	   *
	   *    math.det(x)
	   *
	   * Examples:
	   *
	   *    math.det([[1, 2], [3, 4]]); // returns -2
	   *
	   *    var A = [
	   *      [-2, 2, 3],
	   *      [-1, 1, 3],
	   *      [2, 0, -1]
	   *    ]
	   *    math.det(A); // returns 6
	   *
	   * See also:
	   *
	   *    inv
	   *
	   * @param {Array | Matrix} x  A matrix
	   * @return {number} The determinant of `x`
	   */
	  var det = typed('det', {
	    'any': function (x) {
	      return object.clone(x);
	    },

	    'Array | Matrix': function det (x) {
	      var size;
	      if (x && x.isMatrix === true) {
	        size = x.size();
	      }
	      else if (Array.isArray(x)) {
	        x = matrix(x);
	        size = x.size();
	      }
	      else {
	        // a scalar
	        size = [];
	      }

	      switch (size.length) {
	        case 0:
	          // scalar
	          return object.clone(x);

	        case 1:
	          // vector
	          if (size[0] == 1) {
	            return object.clone(x.valueOf()[0]);
	          }
	          else {
	            throw new RangeError('Matrix must be square ' +
	            '(size: ' + string.format(size) + ')');
	          }

	        case 2:
	          // two dimensional array
	          var rows = size[0];
	          var cols = size[1];
	          if (rows == cols) {
	            return _det(x.clone().valueOf(), rows, cols);
	          }
	          else {
	            throw new RangeError('Matrix must be square ' +
	            '(size: ' + string.format(size) + ')');
	          }

	        default:
	          // multi dimensional array
	          throw new RangeError('Matrix must be two dimensional ' +
	          '(size: ' + string.format(size) + ')');
	      }
	    }
	  });

	  det.toTex = '\\det\\left(${args[0]}\\right)';

	  return det;

	  /**
	   * Calculate the determinant of a matrix
	   * @param {Array[]} matrix  A square, two dimensional matrix
	   * @param {number} rows     Number of rows of the matrix (zero-based)
	   * @param {number} cols     Number of columns of the matrix (zero-based)
	   * @returns {number} det
	   * @private
	   */
	  function _det (matrix, rows, cols) {
	    if (rows == 1) {
	      // this is a 1 x 1 matrix
	      return object.clone(matrix[0][0]);
	    }
	    else if (rows == 2) {
	      // this is a 2 x 2 matrix
	      // the determinant of [a11,a12;a21,a22] is det = a11*a22-a21*a12
	      return subtract(
	          multiply(matrix[0][0], matrix[1][1]),
	          multiply(matrix[1][0], matrix[0][1])
	      );
	    }
	    else {
	      // this is an n x n matrix
	      var compute_mu = function (matrix) {
	        var i, j;

	        // Compute the matrix with zero lower triangle, same upper triangle,
	        // and diagonals given by the negated sum of the below diagonal
	        // elements.
	        var mu = new Array(matrix.length);
	        var sum = 0;
	        for (i = 1; i < matrix.length; i++) {
	          sum = add(sum, matrix[i][i]);
	        }

	        for (i = 0; i < matrix.length; i++) {
	          mu[i] = new Array(matrix.length);
	          mu[i][i] = unaryMinus(sum);

	          for (j = 0; j < i; j++) {
	            mu[i][j] = 0; // TODO: make bignumber 0 in case of bignumber computation
	          }

	          for (j = i + 1; j < matrix.length; j++) {
	            mu[i][j] = matrix[i][j];
	          }

	          if (i+1 < matrix.length) {
	            sum = subtract(sum, matrix[i + 1][i + 1]);
	          }
	        }

	        return mu;
	      };

	      var fa = matrix;
	      for (var i = 0; i < rows - 1; i++) {
	        fa = multiply(compute_mu(fa), matrix);
	      }

	      if (rows % 2 == 0) {
	        return unaryMinus(fa[0][0]);
	      } else {
	        return fa[0][0];
	      }
	    }
	  }
	}

	exports.name = 'det';
	exports.factory = factory;



/***/ },
/* 44 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var extend = __webpack_require__(5).extend;

	function factory (type, config, load, typed) {

	  var matrix = load(__webpack_require__(23));
	  var addScalar = load(__webpack_require__(27));
	  var latex = __webpack_require__(26);
	  
	  var algorithm01 = load(__webpack_require__(30));
	  var algorithm04 = load(__webpack_require__(45));
	  var algorithm10 = load(__webpack_require__(34));
	  var algorithm13 = load(__webpack_require__(35));
	  var algorithm14 = load(__webpack_require__(39));

	  /**
	   * Add two values, `x + y`.
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.add(x, y)
	   *
	   * Examples:
	   *
	   *    math.add(2, 3);               // returns number 5
	   *
	   *    var a = math.complex(2, 3);
	   *    var b = math.complex(-4, 1);
	   *    math.add(a, b);               // returns Complex -2 + 4i
	   *
	   *    math.add([1, 2, 3], 4);       // returns Array [5, 6, 7]
	   *
	   *    var c = math.unit('5 cm');
	   *    var d = math.unit('2.1 mm');
	   *    math.add(c, d);               // returns Unit 52.1 mm
	   *
	   *    math.add("2.3", "4");         // returns number 6.3
	   *
	   * See also:
	   *
	   *    subtract
	   *
	   * @param  {number | BigNumber | Fraction | Complex | Unit | Array | Matrix} x First value to add
	   * @param  {number | BigNumber | Fraction | Complex | Unit | Array | Matrix} y Second value to add
	   * @return {number | BigNumber | Fraction | Complex | Unit | Array | Matrix} Sum of `x` and `y`
	   */
	  var add = typed('add', extend({
	    // we extend the signatures of addScalar with signatures dealing with matrices

	    'Matrix, Matrix': function (x, y) {
	      // result
	      var c;
	      
	      // process matrix storage
	      switch (x.storage()) {
	        case 'sparse':
	          switch (y.storage()) {
	            case 'sparse':
	              // sparse + sparse
	              c = algorithm04(x, y, addScalar);
	              break;
	            default:
	              // sparse + dense
	              c = algorithm01(y, x, addScalar, true);
	              break;
	          }
	          break;
	        default:
	          switch (y.storage()) {
	            case 'sparse':
	              // dense + sparse
	              c = algorithm01(x, y, addScalar, false);
	              break;
	            default:
	              // dense + dense
	              c = algorithm13(x, y, addScalar);
	              break;
	          }
	          break;
	      }
	      return c;
	    },
	    
	    'Array, Array': function (x, y) {
	      // use matrix implementation
	      return add(matrix(x), matrix(y)).valueOf();
	    },
	    
	    'Array, Matrix': function (x, y) {
	      // use matrix implementation
	      return add(matrix(x), y);
	    },
	    
	    'Matrix, Array': function (x, y) {
	      // use matrix implementation
	      return add(x, matrix(y));
	    },
	    
	    'Matrix, any': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (x.storage()) {
	        case 'sparse':
	          c = algorithm10(x, y, addScalar, false);
	          break;
	        default:
	          c = algorithm14(x, y, addScalar, false);
	          break;
	      }
	      return c;
	    },
	    
	    'any, Matrix': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (y.storage()) {
	        case 'sparse':
	          c = algorithm10(y, x, addScalar, true);
	          break;
	        default:
	          c = algorithm14(y, x, addScalar, true);
	          break;
	      }
	      return c;
	    },
	    
	    'Array, any': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(x), y, addScalar, false).valueOf();
	    },

	    'any, Array': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(y), x, addScalar, true).valueOf();
	    }
	  }, addScalar.signatures));

	  add.toTex = '\\left(${args[0]}' + latex.operators['add'] + '${args[1]}\\right)';
	  
	  return add;
	}

	exports.name = 'add';
	exports.factory = factory;


/***/ },
/* 45 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var DimensionError = __webpack_require__(22);

	function factory (type, config, load, typed) {

	  var equalScalar = load(__webpack_require__(33));

	  var SparseMatrix = type.SparseMatrix;

	  /**
	   * Iterates over SparseMatrix A and SparseMatrix B nonzero items and invokes the callback function f(Aij, Bij). 
	   * Callback function invoked MAX(NNZA, NNZB) times
	   *
	   *
	   *          ┌  f(Aij, Bij)  ; A(i,j) !== 0 && B(i,j) !== 0
	   * C(i,j) = ┤  A(i,j)       ; A(i,j) !== 0
	   *          └  B(i,j)       ; B(i,j) !== 0
	   *
	   *
	   * @param {Matrix}   a                 The SparseMatrix instance (A)
	   * @param {Matrix}   b                 The SparseMatrix instance (B)
	   * @param {Function} callback          The f(Aij,Bij) operation to invoke
	   *
	   * @return {Matrix}                    SparseMatrix (C)
	   *
	   * see https://github.com/josdejong/mathjs/pull/346#issuecomment-97620294
	   */
	  var algorithm04 = function (a, b, callback) {
	    // sparse matrix arrays
	    var avalues = a._values;
	    var aindex = a._index;
	    var aptr = a._ptr;
	    var asize = a._size;
	    var adt = a._datatype;
	    // sparse matrix arrays
	    var bvalues = b._values;
	    var bindex = b._index;
	    var bptr = b._ptr;
	    var bsize = b._size;
	    var bdt = b._datatype;

	    // validate dimensions
	    if (asize.length !== bsize.length)
	      throw new DimensionError(asize.length, bsize.length);

	    // check rows & columns
	    if (asize[0] !== bsize[0] || asize[1] !== bsize[1])
	      throw new RangeError('Dimension mismatch. Matrix A (' + asize + ') must match Matrix B (' + bsize + ')');

	    // rows & columns
	    var rows = asize[0];
	    var columns = asize[1];

	    // datatype
	    var dt;
	    // equal signature to use
	    var eq = equalScalar;
	    // zero value
	    var zero = 0;
	    // callback signature to use
	    var cf = callback;

	    // process data types
	    if (typeof adt === 'string' && adt === bdt) {
	      // datatype
	      dt = adt;
	      // find signature that matches (dt, dt)
	      eq = typed.find(equalScalar, [dt, dt]);
	      // convert 0 to the same datatype
	      zero = typed.convert(0, dt);
	      // callback
	      cf = typed.find(callback, [dt, dt]);
	    }

	    // result arrays
	    var cvalues = avalues && bvalues ? [] : undefined;
	    var cindex = [];
	    var cptr = [];
	    // matrix
	    var c = new SparseMatrix({
	      values: cvalues,
	      index: cindex,
	      ptr: cptr,
	      size: [rows, columns],
	      datatype: dt
	    });

	    // workspace
	    var xa = avalues && bvalues ? [] : undefined;
	    var xb = avalues && bvalues ? [] : undefined;
	    // marks indicating we have a value in x for a given column
	    var wa = [];
	    var wb = [];

	    // vars 
	    var i, j, k, k0, k1;
	    
	    // loop columns
	    for (j = 0; j < columns; j++) {
	      // update cptr
	      cptr[j] = cindex.length;
	      // columns mark
	      var mark = j + 1;
	      // loop A(:,j)
	      for (k0 = aptr[j], k1 = aptr[j + 1], k = k0; k < k1; k++) {
	        // row
	        i = aindex[k];
	        // update c
	        cindex.push(i);
	        // update workspace
	        wa[i] = mark;
	        // check we need to process values
	        if (xa)
	          xa[i] = avalues[k];
	      }
	      // loop B(:,j)
	      for (k0 = bptr[j], k1 = bptr[j + 1], k = k0; k < k1; k++) {
	        // row
	        i = bindex[k];
	        // check row exists in A
	        if (wa[i] === mark) {
	          // update record in xa @ i
	          if (xa) {
	            // invoke callback
	            var v = cf(xa[i], bvalues[k]);
	            // check for zero
	            if (!eq(v, zero)) {
	              // update workspace
	              xa[i] = v;              
	            }
	            else {
	              // remove mark (index will be removed later)
	              wa[i] = null;
	            }
	          }
	        }
	        else {
	          // update c
	          cindex.push(i);
	          // update workspace
	          wb[i] = mark;
	          // check we need to process values
	          if (xb)
	            xb[i] = bvalues[k];
	        }
	      }
	      // check we need to process values (non pattern matrix)
	      if (xa && xb) {
	        // initialize first index in j
	        k = cptr[j];
	        // loop index in j
	        while (k < cindex.length) {
	          // row
	          i = cindex[k];
	          // check workspace has value @ i
	          if (wa[i] === mark) {
	            // push value (Aij != 0 || (Aij != 0 && Bij != 0))
	            cvalues[k] = xa[i];
	            // increment pointer
	            k++;
	          }
	          else if (wb[i] === mark) {
	            // push value (bij != 0)
	            cvalues[k] = xb[i];
	            // increment pointer
	            k++;
	          }
	          else {
	            // remove index @ k
	            cindex.splice(k, 1);
	          }
	        }
	      }
	    }
	    // update cptr
	    cptr[columns] = cindex.length;

	    // return sparse matrix
	    return c;
	  };
	  
	  return algorithm04;
	}

	exports.name = 'algorithm04';
	exports.factory = factory;


/***/ },
/* 46 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var array     = __webpack_require__(18);
	var clone     = __webpack_require__(5).clone;
	var isInteger = __webpack_require__(8).isInteger;

	function factory (type, config, load, typed) {

	  var matrix = load(__webpack_require__(23));
	  
	  /**
	   * Create a diagonal matrix or retrieve the diagonal of a matrix
	   *
	   * When `x` is a vector, a matrix with vector `x` on the diagonal will be returned.
	   * When `x` is a two dimensional matrix, the matrixes `k`th diagonal will be returned as vector.
	   * When k is positive, the values are placed on the super diagonal.
	   * When k is negative, the values are placed on the sub diagonal.
	   *
	   * Syntax:
	   *
	   *     math.diag(X)
	   *     math.diag(X, format)
	   *     math.diag(X, k)
	   *     math.diag(X, k, format)
	   *
	   * Examples:
	   *
	   *     // create a diagonal matrix
	   *     math.diag([1, 2, 3]);      // returns [[1, 0, 0], [0, 2, 0], [0, 0, 3]]
	   *     math.diag([1, 2, 3], 1);   // returns [[0, 1, 0, 0], [0, 0, 2, 0], [0, 0, 0, 3]]
	   *     math.diag([1, 2, 3], -1);  // returns [[0, 0, 0], [1, 0, 0], [0, 2, 0], [0, 0, 3]]
	   *
	   *    // retrieve the diagonal from a matrix
	   *    var a = [[1, 2, 3], [4, 5, 6], [7, 8, 9]];
	   *    math.diag(a);   // returns [1, 5, 9]
	   *
	   * See also:
	   *
	   *     ones, zeros, eye
	   *
	   * @param {Matrix | Array} x          A two dimensional matrix or a vector
	   * @param {number | BigNumber} [k=0]  The diagonal where the vector will be filled
	   *                                    in or retrieved.
	   * @param {string} [format='dense']   The matrix storage format.
	   *
	   * @returns {Matrix | Array} Diagonal matrix from input vector, or diagonal from input matrix.
	   */
	  var diag = typed('diag', {
	    // FIXME: simplify this huge amount of signatures as soon as typed-function supports optional arguments

	    'Array': function (x) {
	      return _diag(x, 0, array.size(x), null);
	    },

	    'Array, number': function (x, k) {
	      return _diag(x, k, array.size(x), null);
	    },
	    
	    'Array, BigNumber': function (x, k) {
	      return _diag(x, k.toNumber(), array.size(x), null);
	    },

	    'Array, string': function (x, format) {
	      return _diag(x, 0, array.size(x), format);
	    },

	    'Array, number, string': function (x, k, format) {
	      return _diag(x, k, array.size(x), format);
	    },

	    'Array, BigNumber, string': function (x, k, format) {
	      return _diag(x, k.toNumber(), array.size(x), format);
	    },

	    'Matrix': function (x) {
	      return _diag(x, 0, x.size(), x.storage());
	    },

	    'Matrix, number': function (x, k) {
	      return _diag(x, k, x.size(), x.storage());
	    },

	    'Matrix, BigNumber': function (x, k) {
	      return _diag(x, k.toNumber(), x.size(), x.storage());
	    },

	    'Matrix, string': function (x, format) {
	      return _diag(x, 0, x.size(), format);
	    },

	    'Matrix, number, string': function (x, k, format) {
	      return _diag(x, k, x.size(), format);
	    },

	    'Matrix, BigNumber, string': function (x, k, format) {
	      return _diag(x, k.toNumber(), x.size(), format);
	    }
	  });

	  diag.toTex = '\\mathrm{${name}}\\left(${args}\\right)';

	  return diag;

	  /**
	   * Creeate diagonal matrix from a vector or vice versa
	   * @param {Array | Matrix} x
	   * @param {number} k
	   * @param {string} format Storage format for matrix. If null,
	   *                          an Array is returned
	   * @returns {Array | Matrix}
	   * @private
	   */
	  function _diag (x, k, size, format) {
	    if (!isInteger(k)) {
	      throw new TypeError ('Second parameter in function diag must be an integer');
	    }
	    
	    var kSuper = k > 0 ? k : 0;
	    var kSub = k < 0 ? -k : 0;

	    // check dimensions
	    switch (size.length) {
	      case 1:
	        return _createDiagonalMatrix(x, k, format, size[0], kSub, kSuper);
	      case 2:
	        return _getDiagonal(x, k, format, size, kSub, kSuper);
	    }
	    throw new RangeError('Matrix for function diag must be 2 dimensional');
	  }
	  
	  function _createDiagonalMatrix(x, k, format, l, kSub, kSuper) {
	    // matrix size
	    var ms = [l + kSub, l + kSuper];
	    // get matrix constructor
	    var F = type.Matrix.storage(format || 'dense');
	    // create diagonal matrix
	    var m = F.diagonal(ms, x, k);
	    // check we need to return a matrix
	    return format !== null ? m : m.valueOf();
	  }
	  
	  function _getDiagonal(x, k, format, s, kSub, kSuper) {
	    // check x is a Matrix
	    if (x && x.isMatrix === true) {
	      // get diagonal matrix
	      var dm = x.diagonal(k);
	      // check we need to return a matrix
	      if (format !== null) {
	        // check we need to change matrix format
	        if (format !== dm.storage())
	          return matrix(dm, format);
	        return dm;
	      }
	      return dm.valueOf();
	    }
	    // vector size
	    var n = Math.min(s[0] - kSub, s[1] - kSuper);
	    // diagonal values
	    var vector = [];
	    // loop diagonal
	    for (var i = 0; i < n; i++) {
	      vector[i] = clone(x[i + kSub][i + kSuper]);
	    }
	    // check we need to return a matrix
	    return format !== null ? matrix(vector) : vector;
	  }
	}

	exports.name = 'diag';
	exports.factory = factory;


/***/ },
/* 47 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var size = __webpack_require__(18).size;

	function factory (type, config, load, typed) {
	  var add      = load(__webpack_require__(44));
	  var multiply = load(__webpack_require__(40));

	  /**
	   * Calculate the dot product of two vectors. The dot product of
	   * `A = [a1, a2, a3, ..., an]` and `B = [b1, b2, b3, ..., bn]` is defined as:
	   *
	   *    dot(A, B) = a1 * b1 + a2 * b2 + a3 * b3 + ... + an * bn
	   *
	   * Syntax:
	   *
	   *    math.dot(x, y)
	   *
	   * Examples:
	   *
	   *    math.dot([2, 4, 1], [2, 2, 3]);       // returns number 15
	   *    math.multiply([2, 4, 1], [2, 2, 3]);  // returns number 15
	   *
	   * See also:
	   *
	   *    multiply, cross
	   *
	   * @param  {Array | Matrix} x     First vector
	   * @param  {Array | Matrix} y     Second vector
	   * @return {number}               Returns the dot product of `x` and `y`
	   */
	  var dot = typed('dot', {
	    'Matrix, Matrix': function (x, y) {
	      return _dot(x.toArray(), y.toArray());
	    },

	    'Matrix, Array': function (x, y) {
	      return _dot(x.toArray(), y);
	    },

	    'Array, Matrix': function (x, y) {
	      return _dot(x, y.toArray());
	    },

	    'Array, Array': _dot
	  });
	  
	  dot.toTex = '\\left(${args[0]}\\cdot${args[1]}\\right)';

	  return dot;

	  /**
	   * Calculate the dot product for two arrays
	   * @param {Array} x  First vector
	   * @param {Array} y  Second vector
	   * @returns {number} Returns the dot product of x and y
	   * @private
	   */
	  // TODO: double code with math.multiply
	  function _dot(x, y) {
	    var xSize= size(x);
	    var ySize = size(y);
	    var len = xSize[0];

	    if (xSize.length !== 1 || ySize.length !== 1) throw new RangeError('Vector expected'); // TODO: better error message
	    if (xSize[0] != ySize[0]) throw new RangeError('Vectors must have equal length (' + xSize[0] + ' != ' + ySize[0] + ')');
	    if (len == 0) throw new RangeError('Cannot calculate the dot product of empty vectors');

	    var prod = 0;
	    for (var i = 0; i < len; i++) {
	      prod = add(prod, multiply(x[i], y[i]));
	    }

	    return prod;
	  }
	}

	exports.name = 'dot';
	exports.factory = factory;


/***/ },
/* 48 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var array = __webpack_require__(18);
	var isInteger = __webpack_require__(8).isInteger;

	function factory (type, config, load, typed) {
	  
	  var matrix = load(__webpack_require__(23));
	  
	  /**
	   * Create a 2-dimensional identity matrix with size m x n or n x n.
	   * The matrix has ones on the diagonal and zeros elsewhere.
	   *
	   * Syntax:
	   *
	   *    math.eye(n)
	   *    math.eye(n, format)
	   *    math.eye(m, n)
	   *    math.eye(m, n, format)
	   *    math.eye([m, n])
	   *    math.eye([m, n], format)
	   *
	   * Examples:
	   *
	   *    math.eye(3);                    // returns [[1, 0, 0], [0, 1, 0], [0, 0, 1]]
	   *    math.eye(3, 2);                 // returns [[1, 0], [0, 1], [0, 0]]
	   *
	   *    var A = [[1, 2, 3], [4, 5, 6]];
	   *    math.eye(math.size(b));         // returns [[1, 0, 0], [0, 1, 0]]
	   *
	   * See also:
	   *
	   *    diag, ones, zeros, size, range
	   *
	   * @param {...number | Matrix | Array} size   The size for the matrix
	   * @param {string} [format]                   The Matrix storage format
	   *
	   * @return {Matrix | Array | number} A matrix with ones on the diagonal.
	   */
	  var eye = typed('eye', {
	    '': function () {
	      return (config.matrix === 'matrix') ? matrix([]) : [];
	    },

	    'string': function (format) {
	      return matrix(format);
	    },

	    'number | BigNumber': function (rows) {
	      return _eye(rows, rows, config.matrix === 'matrix' ? 'default' : undefined);
	    },
	    
	    'number | BigNumber, string': function (rows, format) {
	      return _eye(rows, rows, format);
	    },

	    'number | BigNumber, number | BigNumber': function (rows, cols) {
	      return _eye(rows, cols, config.matrix === 'matrix' ? 'default' : undefined);
	    },
	    
	    'number | BigNumber, number | BigNumber, string': function (rows, cols, format) {
	      return _eye(rows, cols, format);
	    },

	    'Array':  function (size) {
	      return _eyeVector(size);
	    },
	    
	    'Array, string':  function (size, format) {
	      return _eyeVector(size, format);
	    },

	    'Matrix': function (size) {
	      return _eyeVector(size.valueOf(), size.storage());
	    },
	    
	    'Matrix, string': function (size, format) {
	      return _eyeVector(size.valueOf(), format);
	    }
	  });

	  eye.toTex = '\\mathrm{${name}}\\left(${args}\\right)';

	  return eye;

	  function _eyeVector (size, format) {
	    switch (size.length) {
	      case 0: return format ? matrix(format) : [];
	      case 1: return _eye(size[0], size[0], format);
	      case 2: return _eye(size[0], size[1], format);
	      default: throw new Error('Vector containing two values expected');
	    }
	  }

	  /**
	   * Create an identity matrix
	   * @param {number | BigNumber} rows
	   * @param {number | BigNumber} cols
	   * @param {string} [format]
	   * @returns {Matrix}
	   * @private
	   */
	  function _eye (rows, cols, format) {
	    // BigNumber constructor with the right precision
	    var Big = (rows && rows.isBigNumber === true)
	        ? type.BigNumber
	        : (cols && cols.isBigNumber === true)
	            ? type.BigNumber
	            : null;

	    if (rows && rows.isBigNumber === true) rows = rows.toNumber();
	    if (cols && cols.isBigNumber === true) cols = cols.toNumber();

	    if (!isInteger(rows) || rows < 1) {
	      throw new Error('Parameters in function eye must be positive integers');
	    }
	    if (!isInteger(cols) || cols < 1) {
	      throw new Error('Parameters in function eye must be positive integers');
	    }
	    
	    var one = Big ? new type.BigNumber(1) : 1;
	    var defaultValue = Big ? new Big(0) : 0;
	    var size = [rows, cols];
	    
	    // check we need to return a matrix
	    if (format) {
	      // get matrix storage constructor
	      var F = type.Matrix.storage(format);
	      // create diagonal matrix (use optimized implementation for storage format)
	      return F.diagonal(size, one, 0, defaultValue);
	    }
	    
	    // create and resize array
	    var res = array.resize([], size, defaultValue);
	    // fill in ones on the diagonal
	    var minimum = rows < cols ? rows : cols;
	    // fill diagonal
	    for (var d = 0; d < minimum; d++) {
	      res[d][d] = one;
	    }
	    return res;
	  }
	}

	exports.name = 'eye';
	exports.factory = factory;


/***/ },
/* 49 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var clone = __webpack_require__(5).clone;
	var _flatten = __webpack_require__(18).flatten;

	function factory (type, config, load, typed) {
	  var matrix = load(__webpack_require__(23));

	  /**
	   * Flatten a multi dimensional matrix into a single dimensional matrix.
	   *
	   * Syntax:
	   *
	   *    math.flatten(x)
	   *
	   * Examples:
	   *
	   *    math.flatten([[1,2], [3,4]]);   // returns [1, 2, 3, 4]
	   *
	   * See also:
	   *
	   *    concat, resize, size, squeeze
	   *
	   * @param {Matrix | Array} x   Matrix to be flattened
	   * @return {Matrix | Array} Returns the flattened matrix
	   */
	  var flatten = typed('flatten', {
	    'Array': function (x) {
	      return _flatten(clone(x));
	    },

	    'Matrix': function (x) {
	      var flat = _flatten(clone(x.toArray()));
	      // TODO: return the same matrix type as x
	      return matrix(flat);
	    }
	  });

	  flatten.toTex = '\\mathrm{${name}}\\left(${args}\\right)';

	  return flatten;
	}

	exports.name = 'flatten';
	exports.factory = factory;


/***/ },
/* 50 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var util = __webpack_require__(36);

	function factory (type, config, load, typed) {
	  var matrix       = load(__webpack_require__(23));
	  var divideScalar = load(__webpack_require__(51));
	  var addScalar    = load(__webpack_require__(27));
	  var multiply     = load(__webpack_require__(40));
	  var unaryMinus   = load(__webpack_require__(28));
	  var det          = load(__webpack_require__(43));
	  var eye          = load(__webpack_require__(48));

	  /**
	   * Calculate the inverse of a square matrix.
	   *
	   * Syntax:
	   *
	   *     math.inv(x)
	   *
	   * Examples:
	   *
	   *     math.inv([[1, 2], [3, 4]]);  // returns [[-2, 1], [1.5, -0.5]]
	   *     math.inv(4);                 // returns 0.25
	   *     1 / 4;                       // returns 0.25
	   *
	   * See also:
	   *
	   *     det, transpose
	   *
	   * @param {number | Complex | Array | Matrix} x     Matrix to be inversed
	   * @return {number | Complex | Array | Matrix} The inverse of `x`.
	   */
	  var inv = typed('inv', {
	    'Array | Matrix': function (x) {
	      var size = (x.isMatrix === true) ? x.size() : util.array.size(x);
	      switch (size.length) {
	        case 1:
	          // vector
	          if (size[0] == 1) {
	            if (x.isMatrix === true) {
	              return matrix([
	                divideScalar(1, x.valueOf()[0])
	              ]);
	            }
	            else {
	              return [
	                divideScalar(1, x[0])
	              ];
	            }
	          }
	          else {
	            throw new RangeError('Matrix must be square ' +
	            '(size: ' + util.string.format(size) + ')');
	          }

	        case 2:
	          // two dimensional array
	          var rows = size[0];
	          var cols = size[1];
	          if (rows == cols) {
	            if (x.isMatrix === true) {
	              return matrix(
	                  _inv(x.valueOf(), rows, cols),
	                  x.storage()
	              );
	            }
	            else {
	              // return an Array
	              return _inv(x, rows, cols);
	            }
	          }
	          else {
	            throw new RangeError('Matrix must be square ' +
	            '(size: ' + util.string.format(size) + ')');
	          }

	        default:
	          // multi dimensional array
	          throw new RangeError('Matrix must be two dimensional ' +
	          '(size: ' + util.string.format(size) + ')');
	      }
	    },

	    'any': function (x) {
	      // scalar
	      return divideScalar(1, x); // FIXME: create a BigNumber one when configured for bignumbers
	    }
	  });

	  /**
	   * Calculate the inverse of a square matrix
	   * @param {Array[]} mat     A square matrix
	   * @param {number} rows     Number of rows
	   * @param {number} cols     Number of columns, must equal rows
	   * @return {Array[]} inv    Inverse matrix
	   * @private
	   */
	  function _inv (mat, rows, cols){
	    var r, s, f, value, temp;

	    if (rows == 1) {
	      // this is a 1 x 1 matrix
	      value = mat[0][0];
	      if (value == 0) {
	        throw Error('Cannot calculate inverse, determinant is zero');
	      }
	      return [[
	        divideScalar(1, value)
	      ]];
	    }
	    else if (rows == 2) {
	      // this is a 2 x 2 matrix
	      var d = det(mat);
	      if (d == 0) {
	        throw Error('Cannot calculate inverse, determinant is zero');
	      }
	      return [
	        [
	          divideScalar(mat[1][1], d),
	          divideScalar(unaryMinus(mat[0][1]), d)
	        ],
	        [
	          divideScalar(unaryMinus(mat[1][0]), d),
	          divideScalar(mat[0][0], d)
	        ]
	      ];
	    }
	    else {
	      // this is a matrix of 3 x 3 or larger
	      // calculate inverse using gauss-jordan elimination
	      //      http://en.wikipedia.org/wiki/Gaussian_elimination
	      //      http://mathworld.wolfram.com/MatrixInverse.html
	      //      http://math.uww.edu/~mcfarlat/inverse.htm

	      // make a copy of the matrix (only the arrays, not of the elements)
	      var A = mat.concat();
	      for (r = 0; r < rows; r++) {
	        A[r] = A[r].concat();
	      }

	      // create an identity matrix which in the end will contain the
	      // matrix inverse
	      var B = eye(rows).valueOf();

	      // loop over all columns, and perform row reductions
	      for (var c = 0; c < cols; c++) {
	        // element Acc should be non zero. if not, swap content
	        // with one of the lower rows
	        r = c;
	        while (r < rows && A[r][c] == 0) {
	          r++;
	        }
	        if (r == rows || A[r][c] == 0) {
	          // TODO: in case of zero det, just return a matrix wih Infinity values? (like octave)
	          throw Error('Cannot calculate inverse, determinant is zero');
	        }
	        if (r != c) {
	          temp = A[c]; A[c] = A[r]; A[r] = temp;
	          temp = B[c]; B[c] = B[r]; B[r] = temp;
	        }

	        // eliminate non-zero values on the other rows at column c
	        var Ac = A[c],
	            Bc = B[c];
	        for (r = 0; r < rows; r++) {
	          var Ar = A[r],
	              Br = B[r];
	          if(r != c) {
	            // eliminate value at column c and row r
	            if (Ar[c] != 0) {
	              f = divideScalar(unaryMinus(Ar[c]), Ac[c]);

	              // add (f * row c) to row r to eliminate the value
	              // at column c
	              for (s = c; s < cols; s++) {
	                Ar[s] = addScalar(Ar[s], multiply(f, Ac[s]));
	              }
	              for (s = 0; s < cols; s++) {
	                Br[s] = addScalar(Br[s],  multiply(f, Bc[s]));
	              }
	            }
	          }
	          else {
	            // normalize value at Acc to 1,
	            // divide each value on row r with the value at Acc
	            f = Ac[c];
	            for (s = c; s < cols; s++) {
	              Ar[s] = divideScalar(Ar[s], f);
	            }
	            for (s = 0; s < cols; s++) {
	              Br[s] = divideScalar(Br[s], f);
	            }
	          }
	        }
	      }
	      return B;
	    }
	  }

	  inv.toTex = '\\left(${args[0]}\\right)^{-1}';

	  return inv;
	}

	exports.name = 'inv';
	exports.factory = factory;


/***/ },
/* 51 */
/***/ function(module, exports) {

	'use strict';

	function factory(type, config, load, typed) {
	  /**
	   * Divide two scalar values, `x / y`.
	   * This function is meant for internal use: it is used by the public functions
	   * `divide` and `inv`.
	   *
	   * This function does not support collections (Array or Matrix), and does
	   * not validate the number of of inputs.
	   *
	   * @param  {number | BigNumber | Fraction | Complex | Unit} x   Numerator
	   * @param  {number | BigNumber | Fraction | Complex} y          Denominator
	   * @return {number | BigNumber | Fraction | Complex | Unit}                      Quotient, `x / y`
	   * @private
	   */
	  var divideScalar = typed('divide', {
	    'number, number': function (x, y) {
	      return x / y;
	    },

	    'Complex, Complex': _divideComplex,

	    'BigNumber, BigNumber': function (x, y) {
	      return x.div(y);
	    },

	    'Fraction, Fraction': function (x, y) {
	      return x.div(y);
	    },

	    'Unit, number': function (x, y) {
	      var res = x.clone();
	      res.value = ((res.value === null) ? res._normalize(1) : res.value) / y;
	      return res;
	    }
	  });

	  /**
	   * Divide two complex numbers. x / y or divide(x, y)
	   * @param {Complex} x
	   * @param {Complex} y
	   * @return {Complex} res
	   * @private
	   */
	  function _divideComplex (x, y) {
	    var den = y.re * y.re + y.im * y.im;
	    if (den != 0) {
	      return new type.Complex(
	          (x.re * y.re + x.im * y.im) / den,
	          (x.im * y.re - x.re * y.im) / den
	      );
	    }
	    else {
	      // both y.re and y.im are zero
	      return new type.Complex(
	          (x.re != 0) ? (x.re / 0) : 0,
	          (x.im != 0) ? (x.im / 0) : 0
	      );
	    }
	  }

	  return divideScalar;
	}

	exports.factory = factory;


/***/ },
/* 52 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var isInteger = __webpack_require__(8).isInteger;
	var resize = __webpack_require__(18).resize;

	function factory (type, config, load, typed) {
	  var matrix = load(__webpack_require__(23));

	  /**
	   * Create a matrix filled with ones. The created matrix can have one or
	   * multiple dimensions.
	   *
	   * Syntax:
	   *
	   *    math.ones(m)
	   *    math.ones(m, format)
	   *    math.ones(m, n)
	   *    math.ones(m, n, format)
	   *    math.ones([m, n])
	   *    math.ones([m, n], format)
	   *    math.ones([m, n, p, ...])
	   *    math.ones([m, n, p, ...], format)
	   *
	   * Examples:
	   *
	   *    math.ones(3);                   // returns [1, 1, 1]
	   *    math.ones(3, 2);                // returns [[1, 1], [1, 1], [1, 1]]
	   *    math.ones(3, 2, 'dense');       // returns Dense Matrix [[1, 1], [1, 1], [1, 1]]
	   *
	   *    var A = [[1, 2, 3], [4, 5, 6]];
	   *    math.ones(math.size(A));       // returns [[1, 1, 1], [1, 1, 1]]
	   *
	   * See also:
	   *
	   *    zeros, eye, size, range
	   *
	   * @param {...number | Array} size    The size of each dimension of the matrix
	   * @param {string} [format]           The Matrix storage format
	   *
	   * @return {Array | Matrix | number}  A matrix filled with ones
	   */
	  var ones = typed('ones', {
	    '': function () {
	      return (config.matrix === 'array')
	          ? _ones([])
	          : _ones([], 'default');
	    },

	    // math.ones(m, n, p, ..., format)
	    // TODO: more accurate signature '...number | BigNumber, string' as soon as typed-function supports this
	    '...number | BigNumber | string': function (size) {
	      var last = size[size.length - 1];
	      if (typeof last === 'string') {
	        var format = size.pop();
	        return _ones(size, format);
	      }
	      else if (config.matrix === 'array') {
	        return _ones(size);
	      }
	      else {
	        return _ones(size, 'default');
	      }
	    },

	    'Array': _ones,

	    'Matrix': function (size) {
	      var format = size.storage();
	      return _ones(size.valueOf(), format);
	    },

	    'Array | Matrix, string': function (size, format) {
	      return _ones (size.valueOf(), format);
	    }
	  });

	  ones.toTex = '\\mathrm{${name}}\\left(${args}\\right)';

	  return ones;

	  /**
	   * Create an Array or Matrix with ones
	   * @param {Array} size
	   * @param {string} [format='default']
	   * @return {Array | Matrix}
	   * @private
	   */
	  function _ones(size, format) {
	    var hasBigNumbers = _normalize(size);
	    var defaultValue = hasBigNumbers ? new type.BigNumber(1) : 1;
	    _validate(size);

	    if (format) {
	      // return a matrix
	      var m = matrix(format);
	      if (size.length > 0) {
	        return m.resize(size, defaultValue);
	      }
	      return m;
	    }
	    else {
	      // return an Array
	      var arr = [];
	      if (size.length > 0) {
	        return resize(arr, size, defaultValue);
	      }
	      return arr;
	    }
	  }

	  // replace BigNumbers with numbers, returns true if size contained BigNumbers
	  function _normalize(size) {
	    var hasBigNumbers = false;
	    size.forEach(function (value, index, arr) {
	      if (value && value.isBigNumber === true) {
	        hasBigNumbers = true;
	        arr[index] = value.toNumber();
	      }
	    });
	    return hasBigNumbers;
	  }

	  // validate arguments
	  function _validate (size) {
	    size.forEach(function (value) {
	      if (typeof value !== 'number' || !isInteger(value) || value < 0) {
	        throw new Error('Parameters in function ones must be positive integers');
	      }
	    });
	  }
	}

	exports.name = 'ones';
	exports.factory = factory;


/***/ },
/* 53 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	function factory (type, config, load, typed) {
	  var matrix = load(__webpack_require__(23));

	  var ZERO = new type.BigNumber(0);
	  var ONE = new type.BigNumber(1);

	  /**
	   * Create an array from a range.
	   * By default, the range end is excluded. This can be customized by providing
	   * an extra parameter `includeEnd`.
	   *
	   * Syntax:
	   *
	   *     math.range(str [, includeEnd])               // Create a range from a string,
	   *                                                  // where the string contains the
	   *                                                  // start, optional step, and end,
	   *                                                  // separated by a colon.
	   *     math.range(start, end [, includeEnd])        // Create a range with start and
	   *                                                  // end and a step size of 1.
	   *     math.range(start, end, step [, includeEnd])  // Create a range with start, step,
	   *                                                  // and end.
	   *
	   * Where:
	   *
	   * - `str: string`
	   *   A string 'start:end' or 'start:step:end'
	   * - `start: {number | BigNumber}`
	   *   Start of the range
	   * - `end: number | BigNumber`
	   *   End of the range, excluded by default, included when parameter includeEnd=true
	   * - `step: number | BigNumber`
	   *   Step size. Default value is 1.
	   * - `includeEnd: boolean`
	   *   Option to specify whether to include the end or not. False by default.
	   *
	   * Examples:
	   *
	   *     math.range(2, 6);        // [2, 3, 4, 5]
	   *     math.range(2, -3, -1);   // [2, 1, 0, -1, -2]
	   *     math.range('2:1:6');     // [2, 3, 4, 5]
	   *     math.range(2, 6, true);  // [2, 3, 4, 5, 6]
	   *
	   * See also:
	   *
	   *     ones, zeros, size, subset
	   *
	   * @param {*} args   Parameters describing the ranges `start`, `end`, and optional `step`.
	   * @return {Array | Matrix} range
	   */
	  var range = typed('range', {
	    // TODO: simplify signatures when typed-function supports default values and optional arguments

	    // TODO: a number or boolean should not be converted to string here
	    'string': _strRange,
	    'string, boolean': _strRange,

	    'number, number':  function (start, end) {
	      return _out(_rangeEx(start, end, 1));
	    },
	    'number, number, number': function (start, end, step) {
	      return _out(_rangeEx(start, end, step));
	    },
	    'number, number, boolean': function (start, end, includeEnd) {
	      return includeEnd
	          ? _out(_rangeInc(start, end, 1))
	          : _out(_rangeEx(start, end, 1));
	    },
	    'number, number, number, boolean': function (start, end, step, includeEnd) {
	      return includeEnd
	          ? _out(_rangeInc(start, end, step))
	          : _out(_rangeEx(start, end, step));
	    },

	    'BigNumber, BigNumber':  function (start, end) {
	      return _out(_bigRangeEx(start, end, ONE));
	    },
	    'BigNumber, BigNumber, BigNumber': function (start, end, step) {
	      return _out(_bigRangeEx(start, end, step));
	    },
	    'BigNumber, BigNumber, boolean': function (start, end, includeEnd) {
	      return includeEnd
	          ? _out(_bigRangeInc(start, end, ONE))
	          : _out(_bigRangeEx(start, end, ONE));
	    },
	    'BigNumber, BigNumber, BigNumber, boolean': function (start, end, step, includeEnd) {
	      return includeEnd
	          ? _out(_bigRangeInc(start, end, step))
	          : _out(_bigRangeEx(start, end, step));
	    }

	  });

	  range.toTex = '\\mathrm{${name}}\\left(${args}\\right)';

	  return range;

	  function _out(arr) {
	    return config.matrix === 'array' ? arr : matrix(arr);
	  }

	  function _strRange (str, includeEnd) {
	    var r = _parse(str);
	    if (!r){
	      throw new SyntaxError('String "' + str + '" is no valid range');
	    }

	    var fn;
	    if (config.number === 'bignumber') {
	      fn = includeEnd ? _bigRangeInc : _bigRangeEx;
	      return _out(fn(
	          new type.BigNumber(r.start),
	          new type.BigNumber(r.end),
	          new type.BigNumber(r.step)));
	    }
	    else {
	      fn = includeEnd ? _rangeInc : _rangeEx;
	      return _out(fn(r.start, r.end, r.step));
	    }
	  }

	  /**
	   * Create a range with numbers. End is excluded
	   * @param {number} start
	   * @param {number} end
	   * @param {number} step
	   * @returns {Array} range
	   * @private
	   */
	  function _rangeEx (start, end, step) {
	    var array = [],
	        x = start;
	    if (step > 0) {
	      while (x < end) {
	        array.push(x);
	        x += step;
	      }
	    }
	    else if (step < 0) {
	      while (x > end) {
	        array.push(x);
	        x += step;
	      }
	    }

	    return array;
	  }

	  /**
	   * Create a range with numbers. End is included
	   * @param {number} start
	   * @param {number} end
	   * @param {number} step
	   * @returns {Array} range
	   * @private
	   */
	  function _rangeInc (start, end, step) {
	    var array = [],
	        x = start;
	    if (step > 0) {
	      while (x <= end) {
	        array.push(x);
	        x += step;
	      }
	    }
	    else if (step < 0) {
	      while (x >= end) {
	        array.push(x);
	        x += step;
	      }
	    }

	    return array;
	  }

	  /**
	   * Create a range with big numbers. End is excluded
	   * @param {BigNumber} start
	   * @param {BigNumber} end
	   * @param {BigNumber} step
	   * @returns {Array} range
	   * @private
	   */
	  function _bigRangeEx (start, end, step) {
	    var array = [],
	        x = start;
	    if (step.gt(ZERO)) {
	      while (x.lt(end)) {
	        array.push(x);
	        x = x.plus(step);
	      }
	    }
	    else if (step.lt(ZERO)) {
	      while (x.gt(end)) {
	        array.push(x);
	        x = x.plus(step);
	      }
	    }

	    return array;
	  }

	  /**
	   * Create a range with big numbers. End is included
	   * @param {BigNumber} start
	   * @param {BigNumber} end
	   * @param {BigNumber} step
	   * @returns {Array} range
	   * @private
	   */
	  function _bigRangeInc (start, end, step) {
	    var array = [],
	        x = start;
	    if (step.gt(ZERO)) {
	      while (x.lte(end)) {
	        array.push(x);
	        x = x.plus(step);
	      }
	    }
	    else if (step.lt(ZERO)) {
	      while (x.gte(end)) {
	        array.push(x);
	        x = x.plus(step);
	      }
	    }

	    return array;
	  }

	  /**
	   * Parse a string into a range,
	   * The string contains the start, optional step, and end, separated by a colon.
	   * If the string does not contain a valid range, null is returned.
	   * For example str='0:2:11'.
	   * @param {string} str
	   * @return {{start: number, end: number, step: number} | null} range Object containing properties start, end, step
	   * @private
	   */
	  function _parse (str) {
	    var args = str.split(':');

	    // number
	    var nums = args.map(function (arg) {
	      // use Number and not parseFloat as Number returns NaN on invalid garbage in the string
	      return Number(arg);
	    });

	    var invalid = nums.some(function (num) {
	      return isNaN(num);
	    });
	    if(invalid) {
	      return null;
	    }

	    switch (nums.length) {
	      case 2:
	        return {
	          start: nums[0],
	          end: nums[1],
	          step: 1
	        };

	      case 3:
	        return {
	          start: nums[0],
	          end: nums[2],
	          step: nums[1]
	        };

	      default:
	        return null;
	    }
	  }

	}

	exports.name = 'range';
	exports.factory = factory;


/***/ },
/* 54 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var DimensionError = __webpack_require__(22);
	var ArgumentsError = __webpack_require__(11);

	var isInteger = __webpack_require__(8).isInteger;
	var format = __webpack_require__(20).format;
	var clone = __webpack_require__(5).clone;
	var array = __webpack_require__(18);

	function factory (type, config, load, typed) {
	  var matrix = load(__webpack_require__(23));

	  /**
	   * Resize a matrix
	   *
	   * Syntax:
	   *
	   *     math.resize(x, size)
	   *     math.resize(x, size, defaultValue)
	   *
	   * Examples:
	   *
	   *     math.resize([1, 2, 3, 4, 5], [3]); // returns Array  [1, 2, 3]
	   *     math.resize([1, 2, 3], [5], 0);    // returns Array  [1, 2, 3, 0, 0]
	   *     math.resize(2, [2, 3], 0);         // returns Matrix [[2, 0, 0], [0, 0, 0]]
	   *     math.resize("hello", [8], "!");    // returns string 'hello!!!'
	   *
	   * See also:
	   *
	   *     size, squeeze, subset
	   *
	   * @param {Array | Matrix | *} x             Matrix to be resized
	   * @param {Array | Matrix} size              One dimensional array with numbers
	   * @param {number | string} [defaultValue=0] Zero by default, except in
	   *                                           case of a string, in that case
	   *                                           defaultValue = ' '
	   * @return {* | Array | Matrix} A resized clone of matrix `x`
	   */
	  // TODO: rework resize to a typed-function
	  var resize = function resize (x, size, defaultValue) {
	    if (arguments.length != 2 && arguments.length != 3) {
	      throw new ArgumentsError('resize', arguments.length, 2, 3);
	    }

	    if (size && size.isMatrix === true) {
	      size = size.valueOf(); // get Array
	    }

	    if (size.length && size[0] && size[0].isBigNumber === true) {
	      // convert bignumbers to numbers
	      size = size.map(function (value) {
	        return (value && value.isBigNumber === true) ? value.toNumber() : value;
	      });
	    }
	    
	    // check x is a Matrix
	    if (x && x.isMatrix === true) {
	      // use optimized matrix implementation, return copy
	      return x.resize(size, defaultValue, true);
	    }
	    
	    if (typeof x === 'string') {
	      // resize string
	      return _resizeString(x, size, defaultValue);
	    }
	    
	    // check result should be a matrix
	    var asMatrix = Array.isArray(x) ? false : (config.matrix !== 'array');

	    if (size.length == 0) {
	      // output a scalar
	      while (Array.isArray(x)) {
	        x = x[0];
	      }

	      return clone(x);
	    }
	    else {
	      // output an array/matrix
	      if (!Array.isArray(x)) {
	        x = [x];
	      }
	      x = clone(x);

	      var res = array.resize(x, size, defaultValue);
	      return asMatrix ? matrix(res) : res;
	    }
	  };

	  resize.toTex = '\\mathrm{${name}}\\left(${args}\\right)';

	  return resize;

	  /**
	   * Resize a string
	   * @param {string} str
	   * @param {number[]} size
	   * @param {string} [defaultChar=' ']
	   * @private
	   */
	  function _resizeString(str, size, defaultChar) {
	    if (defaultChar !== undefined) {
	      if (typeof defaultChar !== 'string' || defaultChar.length !== 1) {
	        throw new TypeError('Single character expected as defaultValue');
	      }
	    }
	    else {
	      defaultChar = ' ';
	    }

	    if (size.length !== 1) {
	      throw new DimensionError(size.length, 1);
	    }
	    var len = size[0];
	    if (typeof len !== 'number' || !isInteger(len)) {
	      throw new TypeError('Invalid size, must contain positive integers ' +
	          '(size: ' + format(size) + ')');
	    }

	    if (str.length > len) {
	      return str.substring(0, len);
	    }
	    else if (str.length < len) {
	      var res = str;
	      for (var i = 0, ii = len - str.length; i < ii; i++) {
	        res += defaultChar;
	      }
	      return res;
	    }
	    else {
	      return str;
	    }
	  }
	}

	exports.name = 'resize';
	exports.factory = factory;


/***/ },
/* 55 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var array = __webpack_require__(18);

	function factory (type, config, load, typed) {
	  var matrix = load(__webpack_require__(23));

	  /**
	   * Calculate the size of a matrix or scalar.
	   *
	   * Syntax:
	   *
	   *     math.size(x)
	   *
	   * Examples:
	   *
	   *     math.size(2.3);                  // returns []
	   *     math.size('hello world');        // returns [11]
	   *
	   *     var A = [[1, 2, 3], [4, 5, 6]];
	   *     math.size(A);                    // returns [2, 3]
	   *     math.size(math.range(1,6));      // returns [5]
	   *
	   * See also:
	   *
	   *     resize, squeeze, subset
	   *
	   * @param {boolean | number | Complex | Unit | string | Array | Matrix} x  A matrix
	   * @return {Array | Matrix} A vector with size of `x`.
	   */
	  var size = typed('size', {
	    'Matrix': function (x) {
	      // TODO: return the same matrix type as the input
	      return matrix(x.size());
	    },

	    'Array': array.size,

	    'string': function (x) {
	      return (config.matrix === 'array') ? [x.length] : matrix([x.length]);
	    },

	    'number | Complex | BigNumber | Unit | boolean | null': function (x) {
	      // scalar
	      return (config.matrix === 'array') ? [] : matrix([]);
	    }
	  });

	  size.toTex = '\\mathrm{${name}}\\left(${args}\\right)';

	  return size;
	}

	exports.name = 'size';
	exports.factory = factory;


/***/ },
/* 56 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var object = __webpack_require__(5);
	var array = __webpack_require__(18);

	function factory (type, config, load, typed) {
	  var matrix = load(__webpack_require__(23));

	  /**
	   * Squeeze a matrix, remove inner and outer singleton dimensions from a matrix.
	   *
	   * Syntax:
	   *
	   *     math.squeeze(x)
	   *
	   * Examples:
	   *
	   *     math.squeeze([3]);           // returns 3
	   *     math.squeeze([[3]]);         // returns 3
	   *
	   *     var A = math.zeros(3, 1);    // returns [[0], [0], [0]] (size 3x1)
	   *     math.squeeze(A);             // returns [0, 0, 0] (size 3)
	   *
	   *     var B = math.zeros(1, 3);    // returns [[0, 0, 0]] (size 1x3)
	   *     math.squeeze(B);             // returns [0, 0, 0] (size 3)
	   *
	   *     // only inner and outer dimensions are removed
	   *     var C = math.zeros(2, 1, 3); // returns [[[0, 0, 0]], [[0, 0, 0]]] (size 2x1x3)
	   *     math.squeeze(C);             // returns [[[0, 0, 0]], [[0, 0, 0]]] (size 2x1x3)
	   *
	   * See also:
	   *
	   *     subset
	   *
	   * @param {Matrix | Array} x      Matrix to be squeezed
	   * @return {Matrix | Array} Squeezed matrix
	   */
	  var squeeze = typed('squeeze', {
	    'Array': function (x) {
	      return array.squeeze(object.clone(x));
	    },

	    'Matrix': function (x) {
	      var res = array.squeeze(x.toArray());
	      // FIXME: return the same type of matrix as the input
	      return Array.isArray(res) ? matrix(res) : res;
	    },

	    'any': function (x) {
	      // scalar
	      return object.clone(x);
	    }
	  });

	  squeeze.toTex = '\\mathrm{${name}}\\left(${args}\\right)';

	  return squeeze;
	}

	exports.name = 'squeeze';
	exports.factory = factory;


/***/ },
/* 57 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var clone = __webpack_require__(5).clone;
	var validateIndex = __webpack_require__(18).validateIndex;
	var DimensionError = __webpack_require__(22);

	function factory (type, config, load, typed) {
	  var matrix = load(__webpack_require__(23));

	  /**
	   * Get or set a subset of a matrix or string.
	   *
	   * Syntax:
	   *     math.subset(value, index)                                // retrieve a subset
	   *     math.subset(value, index, replacement [, defaultValue])  // replace a subset
	   *
	   * Examples:
	   *
	   *     // get a subset
	   *     var d = [[1, 2], [3, 4]];
	   *     math.subset(d, math.index(1, 0));        // returns 3
	   *     math.subset(d, math.index([0, 2], 1));   // returns [[2], [4]]
	   *
	   *     // replace a subset
	   *     var e = [];
	   *     var f = math.subset(e, math.index(0, [0, 2]), [5, 6]);  // f = [[5, 6]]
	   *     var g = math.subset(f, math.index(1, 1), 7, 0);         // g = [[5, 6], [0, 7]]
	   *
	   * See also:
	   *
	   *     size, resize, squeeze, index
	   *
	   * @param {Array | Matrix | string} matrix  An array, matrix, or string
	   * @param {Index} index                     An index containing ranges for each
	   *                                          dimension
	   * @param {*} [replacement]                 An array, matrix, or scalar.
	   *                                          If provided, the subset is replaced with replacement.
	   *                                          If not provided, the subset is returned
	   * @param {*} [defaultValue=undefined]      Default value, filled in on new entries when
	   *                                          the matrix is resized. If not provided,
	   *                                          math.matrix elements will be left undefined.
	   * @return {Array | Matrix | string} Either the retrieved subset or the updated matrix.
	   */
	  var subset = typed('subset', {
	    // get subset
	    'Array, Index': function (value, index) {
	      var m = matrix(value);
	      var subset = m.subset(index);       // returns a Matrix
	      return subset && subset.valueOf();  // return an Array (like the input)
	    },

	    'Matrix, Index': function (value, index) {
	      return value.subset(index);
	    },

	    'string, Index': _getSubstring,

	    // set subset
	    'Array, Index, any': function (value, index, replacement) {
	      return matrix(clone(value))
	          .subset(index, replacement, undefined)
	          .valueOf();
	    },

	    'Array, Index, any, any': function (value, index, replacement, defaultValue) {
	      return matrix(clone(value))
	          .subset(index, replacement, defaultValue)
	          .valueOf();
	    },

	    'Matrix, Index, any': function (value, index, replacement) {
	      return value.clone().subset(index, replacement);
	    },

	    'Matrix, Index, any, any': function (value, index, replacement, defaultValue) {
	      return value.clone().subset(index, replacement, defaultValue);
	    },

	    'string, Index, string': _setSubstring,
	    'string, Index, string, string': _setSubstring
	  });

	  subset.toTex = '\\mathrm{${name}}\\left(${args}\\right)';

	  return subset;

	  /**
	   * Retrieve a subset of a string
	   * @param {string} str            string from which to get a substring
	   * @param {Index} index           An index containing ranges for each dimension
	   * @returns {string} substring
	   * @private
	   */
	  function _getSubstring(str, index) {
	    if (!index || index.isIndex !== true) {
	      // TODO: better error message
	      throw new TypeError('Index expected');
	    }
	    if (index.size().length != 1) {
	      throw new DimensionError(index.size().length, 1);
	    }

	    // validate whether the range is out of range
	    var strLen = str.length;
	    validateIndex(index.min()[0], strLen);
	    validateIndex(index.max()[0], strLen);

	    var range = index.dimension(0);

	    var substr = '';
	    range.forEach(function (v) {
	      substr += str.charAt(v);
	    });

	    return substr;
	  }

	  /**
	   * Replace a substring in a string
	   * @param {string} str            string to be replaced
	   * @param {Index} index           An index containing ranges for each dimension
	   * @param {string} replacement    Replacement string
	   * @param {string} [defaultValue] Default value to be uses when resizing
	   *                                the string. is ' ' by default
	   * @returns {string} result
	   * @private
	   */
	  function _setSubstring(str, index, replacement, defaultValue) {
	    if (!index || index.isIndex !== true) {
	      // TODO: better error message
	      throw new TypeError('Index expected');
	    }
	    if (index.size().length != 1) {
	      throw new DimensionError(index.size().length, 1);
	    }
	    if (defaultValue !== undefined) {
	      if (typeof defaultValue !== 'string' || defaultValue.length !== 1) {
	        throw new TypeError('Single character expected as defaultValue');
	      }
	    }
	    else {
	      defaultValue = ' ';
	    }

	    var range = index.dimension(0);
	    var len = range.size()[0];

	    if (len != replacement.length) {
	      throw new DimensionError(range.size()[0], replacement.length);
	    }

	    // validate whether the range is out of range
	    var strLen = str.length;
	    validateIndex(index.min()[0]);
	    validateIndex(index.max()[0]);

	    // copy the string into an array with characters
	    var chars = [];
	    for (var i = 0; i < strLen; i++) {
	      chars[i] = str.charAt(i);
	    }

	    range.forEach(function (v, i) {
	      chars[v] = replacement.charAt(i[0]);
	    });

	    // initialize undefined characters with a space
	    if (chars.length > strLen) {
	      for (i = strLen - 1, len = chars.length; i < len; i++) {
	        if (!chars[i]) {
	          chars[i] = defaultValue;
	        }
	      }
	    }

	    return chars.join('');
	  }
	}

	exports.name = 'subset';
	exports.factory = factory;


/***/ },
/* 58 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var clone = __webpack_require__(5).clone;
	var format = __webpack_require__(20).format;

	function factory (type, config, load, typed) {
	  
	  var matrix = load(__webpack_require__(23));
	  var add = load(__webpack_require__(44));

	  /**
	   * Calculate the trace of a matrix: the sum of the elements on the main
	   * diagonal of a square matrix.
	   *
	   * Syntax:
	   *
	   *    math.trace(x)
	   *
	   * Examples:
	   *
	   *    math.trace([[1, 2], [3, 4]]); // returns 5
	   *
	   *    var A = [
	   *      [1, 2, 3],
	   *      [-1, 2, 3],
	   *      [2, 0, 3]
	   *    ]
	   *    math.trace(A); // returns 6
	   *
	   * See also:
	   *
	   *    diag
	   *
	   * @param {Array | Matrix} x  A matrix
	   *
	   * @return {number} The trace of `x`
	   */
	  var trace = typed('trace', {
	    
	    'Array': function (x) {
	      // use dense matrix implementation
	      return trace(matrix(x));
	    },

	    'Matrix': function (x) {
	      // result
	      var c;
	      // process storage format
	      switch (x.storage()) {
	        case 'dense':
	          c = _denseTrace(x);
	          break;
	        case 'sparse':
	          c = _sparseTrace(x);
	          break;
	      }
	      return c;
	    },
	    
	    'any': clone
	  });
	  
	  var _denseTrace = function (m) {
	    // matrix size & data
	    var size = m._size;
	    var data = m._data;
	    
	    // process dimensions
	    switch (size.length) {
	      case 1:
	        // vector
	        if (size[0] == 1) {
	          // return data[0]
	          return clone(data[0]);
	        }
	        throw new RangeError('Matrix must be square (size: ' + format(size) + ')');
	      case 2:
	        // two dimensional
	        var rows = size[0];
	        var cols = size[1];
	        if (rows === cols) {
	          // calulate sum
	          var sum = 0;
	          // loop diagonal
	          for (var i = 0; i < rows; i++)
	            sum = add(sum, data[i][i]);
	          // return trace
	          return sum;
	        }
	        throw new RangeError('Matrix must be square (size: ' + format(size) + ')');        
	      default:
	        // multi dimensional
	        throw new RangeError('Matrix must be two dimensional (size: ' + format(size) + ')');
	    }
	  };
	  
	  var _sparseTrace = function (m) {
	    // matrix arrays
	    var values = m._values;
	    var index = m._index;
	    var ptr = m._ptr;
	    var size = m._size;
	    // check dimensions
	    var rows = size[0];
	    var columns = size[1];
	    // matrix must be square
	    if (rows === columns) {
	      // calulate sum
	      var sum = 0;
	      // check we have data (avoid looping columns)
	      if (values.length > 0) {
	        // loop columns
	        for (var j = 0; j < columns; j++) {
	          // k0 <= k < k1 where k0 = _ptr[j] && k1 = _ptr[j+1]
	          var k0 = ptr[j];
	          var k1 = ptr[j + 1];
	          // loop k within [k0, k1[
	          for (var k = k0; k < k1; k++) {
	            // row index
	            var i = index[k];
	            // check row
	            if (i === j) {
	              // accumulate value
	              sum = add(sum, values[k]);
	              // exit loop
	              break;
	            }
	            if (i > j) {
	              // exit loop, no value on the diagonal for column j
	              break;
	            }
	          }
	        }
	      }
	      // return trace
	      return sum;
	    }
	    throw new RangeError('Matrix must be square (size: ' + format(size) + ')');   
	  };

	  trace.toTex = '\\mathrm{tr}\\left(${args[0]}\\right)';
	  
	  return trace;
	}

	exports.name = 'trace';
	exports.factory = factory;


/***/ },
/* 59 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var clone = __webpack_require__(5).clone;
	var format = __webpack_require__(20).format;

	function factory (type, config, load, typed) {
	  var latex = __webpack_require__(26);

	  var matrix = load(__webpack_require__(23));

	  var DenseMatrix = type.DenseMatrix,
	      SparseMatrix = type.SparseMatrix;

	  /**
	   * Transpose a matrix. All values of the matrix are reflected over its
	   * main diagonal. Only two dimensional matrices are supported.
	   *
	   * Syntax:
	   *
	   *     math.transpose(x)
	   *
	   * Examples:
	   *
	   *     var A = [[1, 2, 3], [4, 5, 6]];
	   *     math.transpose(A);               // returns [[1, 4], [2, 5], [3, 6]]
	   *
	   * See also:
	   *
	   *     diag, inv, subset, squeeze
	   *
	   * @param {Array | Matrix} x  Matrix to be transposed
	   * @return {Array | Matrix}   The transposed matrix
	   */
	  var transpose = typed('transpose', {

	    'Array': function (x) {
	      // use dense matrix implementation
	      return transpose(matrix(x)).valueOf();
	    },

	    'Matrix': function (x) {
	      // matrix size
	      var size = x.size();

	      // result
	      var c;
	      
	      // process dimensions
	      switch (size.length) {
	        case 1:
	          // vector
	          c = x.clone();
	          break;

	        case 2:
	          // rows and columns
	          var rows = size[0];
	          var columns = size[1];

	          // check columns
	          if (columns === 0) {
	            // throw exception
	            throw new RangeError('Cannot transpose a 2D matrix with no columns (size: ' + format(size) + ')');
	          }

	          // process storage format
	          switch (x.storage()) {
	            case 'dense':
	              c = _denseTranspose(x, rows, columns);
	              break;
	            case 'sparse':
	              c = _sparseTranspose(x, rows, columns);
	              break;
	          }
	          break;
	          
	        default:
	          // multi dimensional
	          throw new RangeError('Matrix must be a vector or two dimensional (size: ' + format(this._size) + ')');
	      }
	      return c;
	    },

	    // scalars
	    'any': function (x) {
	      return clone(x);
	    }
	  });

	  var _denseTranspose = function (m, rows, columns) {
	    // matrix array
	    var data = m._data;
	    // transposed matrix data
	    var transposed = [];
	    var transposedRow;
	    // loop columns
	    for (var j = 0; j < columns; j++) {
	      // initialize row
	      transposedRow = transposed[j] = [];
	      // loop rows
	      for (var i = 0; i < rows; i++) {
	        // set data
	        transposedRow[i] = clone(data[i][j]);
	      }
	    }
	    // return matrix
	    return new DenseMatrix({
	      data: transposed,
	      size: [columns, rows],
	      datatype: m._datatype
	    });
	  };

	  var _sparseTranspose = function (m, rows, columns) {
	    // matrix arrays
	    var values = m._values;
	    var index = m._index;
	    var ptr = m._ptr;
	    // result matrices
	    var cvalues = values ? [] : undefined;
	    var cindex = [];
	    var cptr = [];
	    // row counts
	    var w = [];
	    for (var x = 0; x < rows; x++)
	      w[x] = 0;
	    // vars
	    var p, l, j;
	    // loop values in matrix
	    for (p = 0, l = index.length; p < l; p++) {
	      // number of values in row
	      w[index[p]]++;
	    }
	    // cumulative sum
	    var sum = 0;
	    // initialize cptr with the cummulative sum of row counts
	    for (var i = 0; i < rows; i++) {
	      // update cptr
	      cptr.push(sum);
	      // update sum
	      sum += w[i];
	      // update w
	      w[i] = cptr[i];
	    }
	    // update cptr
	    cptr.push(sum);
	    // loop columns
	    for (j = 0; j < columns; j++) {
	      // values & index in column
	      for (var k0 = ptr[j], k1 = ptr[j + 1], k = k0; k < k1; k++) {
	        // C values & index
	        var q = w[index[k]]++;
	        // C[j, i] = A[i, j]
	        cindex[q] = j;
	        // check we need to process values (pattern matrix)
	        if (values)
	          cvalues[q] = clone(values[k]);
	      }
	    }
	    // return matrix
	    return new SparseMatrix({
	      values: cvalues,
	      index: cindex,
	      ptr: cptr,
	      size: [columns, rows],
	      datatype: m._datatype
	    });
	  };

	  transpose.toTex = '\\left(${args[0]}\\right)' + latex.operators['transpose'];

	  return transpose;
	}

	exports.name = 'transpose';
	exports.factory = factory;


/***/ },
/* 60 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var isInteger = __webpack_require__(8).isInteger;
	var resize = __webpack_require__(18).resize;

	function factory (type, config, load, typed) {
	  var matrix = load(__webpack_require__(23));

	  /**
	   * Create a matrix filled with zeros. The created matrix can have one or
	   * multiple dimensions.
	   *
	   * Syntax:
	   *
	   *    math.zeros(m)
	   *    math.zeros(m, format)
	   *    math.zeros(m, n)
	   *    math.zeros(m, n, format)
	   *    math.zeros([m, n])
	   *    math.zeros([m, n], format)
	   *
	   * Examples:
	   *
	   *    math.zeros(3);                  // returns [0, 0, 0]
	   *    math.zeros(3, 2);               // returns [[0, 0], [0, 0], [0, 0]]
	   *    math.zeros(3, 'dense');         // returns [0, 0, 0]
	   *
	   *    var A = [[1, 2, 3], [4, 5, 6]];
	   *    math.zeros(math.size(A));       // returns [[0, 0, 0], [0, 0, 0]]
	   *
	   * See also:
	   *
	   *    ones, eye, size, range
	   *
	   * @param {...number | Array} size    The size of each dimension of the matrix
	   * @param {string} [format]           The Matrix storage format
	   *
	   * @return {Array | Matrix}           A matrix filled with zeros
	   */
	  var zeros = typed('zeros', {
	    '': function () {
	      return (config.matrix === 'array')
	          ? _zeros([])
	          : _zeros([], 'default');
	    },

	    // math.zeros(m, n, p, ..., format)
	    // TODO: more accurate signature '...number | BigNumber, string' as soon as typed-function supports this
	    '...number | BigNumber | string': function (size) {
	      var last = size[size.length - 1];
	      if (typeof last === 'string') {
	        var format = size.pop();
	        return _zeros(size, format);
	      }
	      else if (config.matrix === 'array') {
	        return _zeros(size);
	      }
	      else {
	        return _zeros(size, 'default');
	      }
	    },

	    'Array': _zeros,

	    'Matrix': function (size) {
	      var format = size.storage();
	      return _zeros(size.valueOf(), format);
	    },

	    'Array | Matrix, string': function (size, format) {
	      return _zeros (size.valueOf(), format);
	    }
	  });

	  zeros.toTex = '\\mathrm{${name}}\\left(${args}\\right)';

	  return zeros;

	  /**
	   * Create an Array or Matrix with zeros
	   * @param {Array} size
	   * @param {string} [format='default']
	   * @return {Array | Matrix}
	   * @private
	   */
	  function _zeros(size, format) {
	    var hasBigNumbers = _normalize(size);
	    var defaultValue = hasBigNumbers ? new type.BigNumber(0) : 0;
	    _validate(size);

	    if (format) {
	      // return a matrix
	      var m = matrix(format);
	      if (size.length > 0) {
	        return m.resize(size, defaultValue);
	      }
	      return m;
	    }
	    else {
	      // return an Array
	      var arr = [];
	      if (size.length > 0) {
	        return resize(arr, size, defaultValue);
	      }
	      return arr;
	    }
	  }

	  // replace BigNumbers with numbers, returns true if size contained BigNumbers
	  function _normalize(size) {
	    var hasBigNumbers = false;
	    size.forEach(function (value, index, arr) {
	      if (value && value.isBigNumber === true) {
	        hasBigNumbers = true;
	        arr[index] = value.toNumber();
	      }
	    });
	    return hasBigNumbers;
	  }

	  // validate arguments
	  function _validate (size) {
	    size.forEach(function (value) {
	      if (typeof value !== 'number' || !isInteger(value) || value < 0) {
	        throw new Error('Parameters in function zeros must be positive integers');
	      }
	    });
	  }
	}

	// TODO: zeros contains almost the same code as ones. Reuse this?

	exports.name = 'zeros';
	exports.factory = factory;


/***/ },
/* 61 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = [
	  // decomposition
	  __webpack_require__(62),
	  __webpack_require__(67),

	  // solver
	  __webpack_require__(86),
	  __webpack_require__(88),
	  __webpack_require__(90)
	];


/***/ },
/* 62 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var util = __webpack_require__(36);

	var object = util.object;

	function factory (type, config, load, typed) {

	  var matrix = load(__webpack_require__(23));
	  var abs = load(__webpack_require__(63));
	  var addScalar = load(__webpack_require__(27));
	  var divideScalar = load(__webpack_require__(51));
	  var multiplyScalar = load(__webpack_require__(41));
	  var subtract = load(__webpack_require__(25));
	  var larger = load(__webpack_require__(64));
	  var equalScalar = load(__webpack_require__(33));
	  var unaryMinus = load(__webpack_require__(28));
	  
	  var SparseMatrix = type.SparseMatrix;
	  var DenseMatrix = type.DenseMatrix;
	  var Spa = type.Spa;
	  
	  /**
	   * Calculate the Matrix LU decomposition with partial pivoting. Matrix `A` is decomposed in two matrices (`L`, `U`) and a
	   * row permutation vector `p` where `A[p,:] = L * U`
	   *
	   * Syntax:
	   *
	   *    math.lup(A);
	   *
	   * Example:
	   *
	   *    var m = [[2, 1], [1, 4]];
	   *    var r = math.lup();
	   *    // r = {
	   *    //   L: [[1, 0], [0.5, 1]],
	   *    //   U: [[2, 1], [0, 3.5]],
	   *    //   P: [0, 1]
	   *    // }
	   *
	   * See also:
	   *
	   *    slu, lsolve, lusolve, usolve
	   *
	   * @param {Matrix | Array} A    A two dimensional matrix or array for which to get the LUP decomposition.
	   *
	   * @return {Array<Matrix>}      The lower triangular matrix, the upper triangular matrix and the permutation matrix.
	   */
	  var lup = typed('lup', {

	    'DenseMatrix': function (m) {
	      return _denseLUP(m);
	    },
	    
	    'SparseMatrix': function (m) {
	      return _sparseLUP(m);
	    },

	    'Array': function (a) {
	      // create dense matrix from array
	      var m = matrix(a);
	      // lup, use matrix implementation
	      var r = _denseLUP(m);
	      // result
	      return {
	        L: r.L.valueOf(),
	        U: r.U.valueOf(),
	        p: r.p
	      };
	    }
	  });

	  var _denseLUP = function (m) {
	    // rows & columns
	    var rows = m._size[0];
	    var columns = m._size[1];
	    // minimum rows and columns
	    var n = Math.min(rows, columns);
	    // matrix array, clone original data
	    var data = object.clone(m._data);
	    // l matrix arrays
	    var ldata = [];
	    var lsize = [rows, n];
	    // u matrix arrays
	    var udata = [];
	    var usize = [n, columns];
	    // vars
	    var i, j, k;
	    // permutation vector    
	    var p = [];
	    for (i = 0; i < rows; i++)
	      p[i] = i;    
	    // loop columns
	    for (j = 0; j < columns; j++) {
	      // skip first column in upper triangular matrix
	      if (j > 0) {
	        // loop rows
	        for (i = 0; i < rows; i++) {
	          // min i,j
	          var min = Math.min(i, j);
	          // v[i, j]
	          var s = 0;
	          // loop up to min
	          for (k = 0; k < min; k++) {
	            // s = l[i, k] - data[k, j]
	            s = addScalar(s, multiplyScalar(data[i][k], data[k][j]));
	          }
	          data[i][j] = subtract(data[i][j], s);
	        }
	      }      
	      // row with larger value in cvector, row >= j
	      var pi = j;
	      var pabsv = 0;
	      var vjj = 0;
	      // loop rows
	      for (i = j; i < rows; i++) {
	        // data @ i, j
	        var v = data[i][j];
	        // absolute value
	        var absv = abs(v);
	        // value is greater than pivote value
	        if (larger(absv, pabsv)) {
	          // store row
	          pi = i;
	          // update max value
	          pabsv = absv;
	          // value @ [j, j]
	          vjj = v;
	        }
	      }
	      // swap rows (j <-> pi)
	      if (j !== pi) {
	        // swap values j <-> pi in p
	        p[j] = [p[pi], p[pi] = p[j]][0];
	        // swap j <-> pi in data
	        DenseMatrix._swapRows(j, pi, data);
	      }
	      // check column is in lower triangular matrix
	      if (j < rows) {
	        // loop rows (lower triangular matrix)
	        for (i = j + 1; i < rows; i++) {
	          // value @ i, j
	          var vij = data[i][j];
	          if (!equalScalar(vij, 0)) {
	            // update data
	            data[i][j] = divideScalar(data[i][j], vjj);
	          }
	        }
	      }
	    }
	    // loop columns
	    for (j = 0; j < columns; j++) {
	      // loop rows
	      for (i = 0; i < rows; i++) {
	        // initialize row in arrays
	        if (j === 0) {
	          // check row exists in upper triangular matrix
	          if (i < columns) {
	            // U
	            udata[i] = [];
	          }
	          // L
	          ldata[i] = [];
	        }
	        // check we are in the upper triangular matrix
	        if (i < j) {
	          // check row exists in upper triangular matrix
	          if (i < columns) {
	            // U
	            udata[i][j] = data[i][j];
	          }
	          // check column exists in lower triangular matrix
	          if (j < rows) {
	            // L
	            ldata[i][j] = 0;
	          }
	          continue;
	        }
	        // diagonal value
	        if (i === j) {
	          // check row exists in upper triangular matrix
	          if (i < columns) {
	            // U
	            udata[i][j] = data[i][j];
	          }
	          // check column exists in lower triangular matrix
	          if (j < rows) {
	            // L
	            ldata[i][j] = 1;
	          }
	          continue;
	        }
	        // check row exists in upper triangular matrix
	        if (i < columns) {
	          // U
	          udata[i][j] = 0;
	        }
	        // check column exists in lower triangular matrix
	        if (j < rows) {
	          // L
	          ldata[i][j] = data[i][j];
	        }
	      }
	    }
	    // l matrix
	    var l =  new DenseMatrix({
	      data: ldata,
	      size: lsize
	    });
	    // u matrix
	    var u =  new DenseMatrix({
	      data: udata,
	      size: usize
	    });    
	    // return matrices
	    return { 
	      L: l, 
	      U: u, 
	      p: p, 
	      toString: function () {
	        return 'L: ' + this.L.toString() + '\nU: ' + this.U.toString() + '\nP: ' + this.p;
	      }
	    };
	  };
	  
	  var _sparseLUP = function (m) {
	    // rows & columns
	    var rows = m._size[0];
	    var columns = m._size[1];
	    // minimum rows and columns
	    var n = Math.min(rows, columns);
	    // matrix arrays (will not be modified, thanks to permutation vector)
	    var values = m._values;
	    var index = m._index;
	    var ptr = m._ptr;
	    // l matrix arrays
	    var lvalues = [];
	    var lindex = [];
	    var lptr = [];
	    var lsize = [rows, n];
	    // u matrix arrays
	    var uvalues = [];
	    var uindex = [];
	    var uptr = [];
	    var usize = [n, columns];
	    // vars
	    var i, j, k;
	    // permutation vectors, (current index -> original index) and (original index -> current index)
	    var pv_co = [];
	    var pv_oc = [];
	    for (i = 0; i < rows; i++) {
	      pv_co[i] = i;
	      pv_oc[i] = i;
	    }
	    // swap indices in permutation vectors (condition x < y)!
	    var swapIndeces = function (x, y) {      
	      // find pv indeces getting data from x and y
	      var kx = pv_oc[x];
	      var ky = pv_oc[y];
	      // update permutation vector current -> original
	      pv_co[kx] = y;
	      pv_co[ky] = x;
	      // update permutation vector original -> current
	      pv_oc[x] = ky;
	      pv_oc[y] = kx;
	    };
	    // loop columns
	    for (j = 0; j < columns; j++) {
	      // sparse accumulator
	      var spa = new Spa();            
	      // check lower triangular matrix has a value @ column j
	      if (j < rows) {
	        // update ptr
	        lptr.push(lvalues.length);
	        // first value in j column for lower triangular matrix
	        lvalues.push(1);
	        lindex.push(j);
	      }
	      // update ptr
	      uptr.push(uvalues.length);
	      // k0 <= k < k1 where k0 = _ptr[j] && k1 = _ptr[j+1]
	      var k0 = ptr[j];
	      var k1 = ptr[j + 1];
	      // copy column j into sparse accumulator
	      for (k = k0; k < k1; k++) {
	        // row
	        i = index[k];
	        // copy column values into sparse accumulator (use permutation vector)
	        spa.set(pv_co[i], values[k]);
	      }
	      // skip first column in upper triangular matrix
	      if (j > 0) {
	        // loop rows in column j (above diagonal)
	        spa.forEach(0, j - 1, function (k, vkj) {
	          // loop rows in column k (L)
	          SparseMatrix._forEachRow(k, lvalues, lindex, lptr, function (i, vik) {
	            // check row is below k
	            if (i > k) {
	              // update spa value
	              spa.accumulate(i, unaryMinus(multiplyScalar(vik, vkj)));
	            }
	          });
	        });        
	      }
	      // row with larger value in spa, row >= j
	      var pi = j;
	      var vjj = spa.get(j);
	      var pabsv = abs(vjj);      
	      // loop values in spa (order by row, below diagonal)
	      spa.forEach(j + 1, rows - 1, function (x, v) {
	        // absolute value
	        var absv = abs(v);
	        // value is greater than pivote value
	        if (larger(absv, pabsv)) {
	          // store row
	          pi = x;
	          // update max value
	          pabsv = absv;
	          // value @ [j, j]
	          vjj = v;
	        }
	      });
	      // swap rows (j <-> pi)
	      if (j !== pi) {
	        // swap values j <-> pi in L
	        SparseMatrix._swapRows(j, pi, lsize[1], lvalues, lindex, lptr);
	        // swap values j <-> pi in U
	        SparseMatrix._swapRows(j, pi, usize[1], uvalues, uindex, uptr);
	        // swap values in spa
	        spa.swap(j, pi);
	        // update permutation vector (swap values @ j, pi)
	        swapIndeces(j, pi);
	      }
	      // loop values in spa (order by row)
	      spa.forEach(0, rows - 1, function (x, v) {
	        // check we are above diagonal
	        if (x <= j) {
	          // update upper triangular matrix
	          uvalues.push(v);
	          uindex.push(x);
	        }
	        else {
	          // update value
	          v = divideScalar(v, vjj);
	          // check value is non zero
	          if (!equalScalar(v, 0)) {
	            // update lower triangular matrix
	            lvalues.push(v);
	            lindex.push(x);
	          }
	        }
	      });
	    }
	    // update ptrs
	    uptr.push(uvalues.length);
	    lptr.push(lvalues.length);

	    // return matrices
	    return {
	      L: new SparseMatrix({
	        values: lvalues,
	        index: lindex,
	        ptr: lptr,
	        size: lsize
	      }), 
	      U: new SparseMatrix({
	        values: uvalues,
	        index: uindex,
	        ptr: uptr,
	        size: usize
	      }),
	      p: pv_oc,
	      toString: function () {
	        return 'L: ' + this.L.toString() + '\nU: ' + this.U.toString() + '\nP: ' + this.p;
	      }
	    };
	  };
	  
	  return lup;
	}

	exports.name = 'lup';
	exports.factory = factory;


/***/ },
/* 63 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);

	function factory (type, config, load, typed) {
	  /**
	   * Calculate the absolute value of a number. For matrices, the function is
	   * evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.abs(x)
	   *
	   * Examples:
	   *
	   *    math.abs(3.5);                // returns number 3.5
	   *    math.abs(-4.2);               // returns number 4.2
	   *
	   *    math.abs([3, -5, -1, 0, 2]);  // returns Array [3, 5, 1, 0, 2]
	   *
	   * See also:
	   *
	   *    sign
	   *
	   * @param  {number | BigNumber | Fraction | Complex | Array | Matrix} x
	   *            A number or matrix for which to get the absolute value
	   * @return {number | BigNumber | Fraction | Complex | Array | Matrix}
	   *            Absolute value of `x`
	   */
	  var abs = typed('abs', {
	    'number': Math.abs,

	    'Complex': function (x) {
	      var re = Math.abs(x.re);
	      var im = Math.abs(x.im);
	      if (re < 1000 && im < 1000) {
	        return Math.sqrt(re * re + im * im);
	      }
	      else {
	        // prevent overflow for large numbers
	        if (re >= im) {
	          var i = im / re;
	          return re * Math.sqrt(1 + i * i);
	        }
	        else {
	          var j = re / im;
	          return im * Math.sqrt(1 + j * j);
	        }
	      }
	    },

	    'BigNumber': function (x) {
	      return x.abs();
	    },

	    'Fraction': function (x) {
	      return x.abs();
	    },

	    'Array | Matrix': function (x) {
	      // deep map collection, skip zeros since abs(0) = 0
	      return deepMap(x, abs, true);
	    }
	  });

	  abs.toTex = '\\left|${args[0]}\\right|';

	  return abs;
	}

	exports.name = 'abs';
	exports.factory = factory;


/***/ },
/* 64 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var nearlyEqual = __webpack_require__(8).nearlyEqual;

	function factory (type, config, load, typed) {
	  
	  var matrix = load(__webpack_require__(23));

	  var algorithm03 = load(__webpack_require__(31));
	  var algorithm07 = load(__webpack_require__(66));
	  var algorithm12 = load(__webpack_require__(65));
	  var algorithm13 = load(__webpack_require__(35));
	  var algorithm14 = load(__webpack_require__(39));

	  var latex = __webpack_require__(26);

	  /**
	   * Test whether value x is larger than y.
	   *
	   * The function returns true when x is larger than y and the relative
	   * difference between x and y is larger than the configured epsilon. The
	   * function cannot be used to compare values smaller than approximately 2.22e-16.
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.larger(x, y)
	   *
	   * Examples:
	   *
	   *    math.larger(2, 3);             // returns false
	   *    math.larger(5, 2 + 2);         // returns true
	   *
	   *    var a = math.unit('5 cm');
	   *    var b = math.unit('2 inch');
	   *    math.larger(a, b);             // returns false
	   *
	   * See also:
	   *
	   *    equal, unequal, smaller, smallerEq, largerEq, compare
	   *
	   * @param  {number | BigNumber | Fraction | boolean | Unit | string | Array | Matrix} x First value to compare
	   * @param  {number | BigNumber | Fraction | boolean | Unit | string | Array | Matrix} y Second value to compare
	   * @return {boolean | Array | Matrix} Returns true when the x is larger than y, else returns false
	   */
	  var larger = typed('larger', {

	    'boolean, boolean': function (x, y) {
	      return x > y;
	    },

	    'number, number': function (x, y) {
	      return x > y && !nearlyEqual(x, y, config.epsilon);
	    },

	    'BigNumber, BigNumber': function (x, y) {
	      return x.gt(y);
	    },

	    'Fraction, Fraction': function (x, y) {
	      return x.compare(y) === 1;
	    },

	    'Complex, Complex': function () {
	      throw new TypeError('No ordering relation is defined for complex numbers');
	    },

	    'Unit, Unit': function (x, y) {
	      if (!x.equalBase(y)) {
	        throw new Error('Cannot compare units with different base');
	      }
	      return x.value > y.value && !nearlyEqual(x.value, y.value, config.epsilon);
	    },

	    'string, string': function (x, y) {
	      return x > y;
	    },

	    'Matrix, Matrix': function (x, y) {
	      // result
	      var c;

	      // process matrix storage
	      switch (x.storage()) {
	        case 'sparse':
	          switch (y.storage()) {
	            case 'sparse':
	              // sparse + sparse
	              c = algorithm07(x, y, larger);
	              break;
	            default:
	              // sparse + dense
	              c = algorithm03(y, x, larger, true);
	              break;
	          }
	          break;
	        default:
	          switch (y.storage()) {
	            case 'sparse':
	              // dense + sparse
	              c = algorithm03(x, y, larger, false);
	              break;
	            default:
	              // dense + dense
	              c = algorithm13(x, y, larger);
	              break;
	          }
	          break;
	      }
	      return c;
	    },

	    'Array, Array': function (x, y) {
	      // use matrix implementation
	      return larger(matrix(x), matrix(y)).valueOf();
	    },

	    'Array, Matrix': function (x, y) {
	      // use matrix implementation
	      return larger(matrix(x), y);
	    },

	    'Matrix, Array': function (x, y) {
	      // use matrix implementation
	      return larger(x, matrix(y));
	    },

	    'Matrix, any': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (x.storage()) {
	        case 'sparse':
	          c = algorithm12(x, y, larger, false);
	          break;
	        default:
	          c = algorithm14(x, y, larger, false);
	          break;
	      }
	      return c;
	    },

	    'any, Matrix': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (y.storage()) {
	        case 'sparse':
	          c = algorithm12(y, x, larger, true);
	          break;
	        default:
	          c = algorithm14(y, x, larger, true);
	          break;
	      }
	      return c;
	    },

	    'Array, any': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(x), y, larger, false).valueOf();
	    },

	    'any, Array': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(y), x, larger, true).valueOf();
	    }
	  });

	  larger.toTex = '\\left(${args[0]}' + latex.operators['larger'] + '${args[1]}\\right)';

	  return larger;
	}

	exports.name = 'larger';
	exports.factory = factory;


/***/ },
/* 65 */
/***/ function(module, exports) {

	'use strict';

	function factory (type, config, load, typed) {

	  var DenseMatrix = type.DenseMatrix;

	  /**
	   * Iterates over SparseMatrix S nonzero items and invokes the callback function f(Sij, b). 
	   * Callback function invoked MxN times.
	   *
	   *
	   *          ┌  f(Sij, b)  ; S(i,j) !== 0
	   * C(i,j) = ┤  
	   *          └  f(0, b)    ; otherwise
	   *
	   *
	   * @param {Matrix}   s                 The SparseMatrix instance (S)
	   * @param {Scalar}   b                 The Scalar value
	   * @param {Function} callback          The f(Aij,b) operation to invoke
	   * @param {boolean}  inverse           A true value indicates callback should be invoked f(b,Sij)
	   *
	   * @return {Matrix}                    DenseMatrix (C)
	   *
	   * https://github.com/josdejong/mathjs/pull/346#issuecomment-97626813
	   */
	  var algorithm12 = function (s, b, callback, inverse) {
	    // sparse matrix arrays
	    var avalues = s._values;
	    var aindex = s._index;
	    var aptr = s._ptr;
	    var asize = s._size;
	    var adt = s._datatype;

	    // sparse matrix cannot be a Pattern matrix
	    if (!avalues)
	      throw new Error('Cannot perform operation on Pattern Sparse Matrix and Scalar value');

	    // rows & columns
	    var rows = asize[0];
	    var columns = asize[1];

	    // datatype
	    var dt;
	    // callback signature to use
	    var cf = callback;

	    // process data types
	    if (typeof adt === 'string') {
	      // datatype
	      dt = adt;
	      // convert b to the same datatype
	      b = typed.convert(b, dt);
	      // callback
	      cf = typed.find(callback, [dt, dt]);
	    }
	    
	    // result arrays
	    var cdata = [];
	    // matrix
	    var c = new DenseMatrix({
	      data: cdata,
	      size: [rows, columns],
	      datatype: dt
	    });

	    // workspaces
	    var x = [];
	    // marks indicating we have a value in x for a given column
	    var w = [];

	    // loop columns
	    for (var j = 0; j < columns; j++) {
	      // columns mark
	      var mark = j + 1;
	      // values in j
	      for (var k0 = aptr[j], k1 = aptr[j + 1], k = k0; k < k1; k++) {
	        // row
	        var r = aindex[k];
	        // update workspace
	        x[r] = avalues[k];
	        w[r] = mark;
	      }
	      // loop rows
	      for (var i = 0; i < rows; i++) {
	        // initialize C on first column
	        if (j === 0) {
	          // create row array
	          cdata[i] = [];
	        }
	        // check sparse matrix has a value @ i,j
	        if (w[i] === mark) {
	          // invoke callback, update C
	          cdata[i][j] = inverse ? cf(b, x[i]) : cf(x[i], b);
	        }
	        else {
	          // dense matrix value @ i, j
	          cdata[i][j] = inverse ? cf(b, 0) : cf(0, b);
	        }
	      }
	    }

	    // return sparse matrix
	    return c;
	  };
	  
	  return algorithm12;
	}

	exports.name = 'algorithm12';
	exports.factory = factory;


/***/ },
/* 66 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var DimensionError = __webpack_require__(22);

	function factory (type, config, load, typed) {

	  var DenseMatrix = type.DenseMatrix;

	  /**
	   * Iterates over SparseMatrix A and SparseMatrix B items (zero and nonzero) and invokes the callback function f(Aij, Bij). 
	   * Callback function invoked MxN times.
	   *
	   * C(i,j) = f(Aij, Bij)
	   *
	   * @param {Matrix}   a                 The SparseMatrix instance (A)
	   * @param {Matrix}   b                 The SparseMatrix instance (B)
	   * @param {Function} callback          The f(Aij,Bij) operation to invoke
	   *
	   * @return {Matrix}                    DenseMatrix (C)
	   *
	   * see https://github.com/josdejong/mathjs/pull/346#issuecomment-97620294
	   */
	  var algorithm07 = function (a, b, callback) {
	    // sparse matrix arrays
	    var asize = a._size;
	    var adt = a._datatype;
	    // sparse matrix arrays
	    var bsize = b._size;
	    var bdt = b._datatype;

	    // validate dimensions
	    if (asize.length !== bsize.length)
	      throw new DimensionError(asize.length, bsize.length);

	    // check rows & columns
	    if (asize[0] !== bsize[0] || asize[1] !== bsize[1])
	      throw new RangeError('Dimension mismatch. Matrix A (' + asize + ') must match Matrix B (' + bsize + ')');

	    // rows & columns
	    var rows = asize[0];
	    var columns = asize[1];

	    // datatype
	    var dt;
	    // zero value
	    var zero = 0;
	    // callback signature to use
	    var cf = callback;

	    // process data types
	    if (typeof adt === 'string' && adt === bdt) {
	      // datatype
	      dt = adt;
	      // convert 0 to the same datatype
	      zero = typed.convert(0, dt);
	      // callback
	      cf = typed.find(callback, [dt, dt]);
	    }

	    // vars
	    var i, j;
	    
	    // result arrays
	    var cdata = [];
	    // initialize c
	    for (i = 0; i < rows; i++)
	      cdata[i] = [];

	    // matrix
	    var c = new DenseMatrix({
	      data: cdata,
	      size: [rows, columns],
	      datatype: dt
	    });

	    // workspaces
	    var xa = [];
	    var xb = [];
	    // marks indicating we have a value in x for a given column
	    var wa = [];
	    var wb = [];

	    // loop columns
	    for (j = 0; j < columns; j++) {
	      // columns mark
	      var mark = j + 1;
	      // scatter the values of A(:,j) into workspace
	      _scatter(a, j, wa, xa, mark);
	      // scatter the values of B(:,j) into workspace
	      _scatter(b, j, wb, xb, mark);
	      // loop rows
	      for (i = 0; i < rows; i++) {
	        // matrix values @ i,j
	        var va = wa[i] === mark ? xa[i] : zero;
	        var vb = wb[i] === mark ? xb[i] : zero;
	        // invoke callback
	        cdata[i][j] = cf(va, vb);
	      }          
	    }

	    // return sparse matrix
	    return c;
	  };
	  
	  var _scatter = function (m, j, w, x, mark) {
	    // a arrays
	    var values = m._values;
	    var index = m._index;
	    var ptr = m._ptr;
	    // loop values in column j
	    for (var k = ptr[j], k1 = ptr[j + 1]; k < k1; k++) {
	      // row
	      var i = index[k];
	      // update workspace
	      w[i] = mark;
	      x[i] = values[k];
	    }
	  };
	  
	  return algorithm07;
	}

	exports.name = 'algorithm07';
	exports.factory = factory;


/***/ },
/* 67 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var util = __webpack_require__(36);

	var number = util.number,
	    
	    isInteger = number.isInteger;

	function factory (type, config, load, typed) {

	  var cs_sqr = load(__webpack_require__(68));
	  var cs_lu = load(__webpack_require__(78));

	  /**
	   * Calculate the Sparse Matrix LU decomposition with full pivoting. Sparse Matrix `A` is decomposed in two matrices (`L`, `U`) and two permutation vectors (`pinv`, `q`) where
	   *
	   * `P * A * Q = L * U`
	   *
	   * Syntax:
	   *
	   *    math.slu(A, order, threshold);
	   *
	   * See also:
	   *
	   *    lup, lsolve, usolve, lusolve
	   *
	   * @param {SparseMatrix} A              A two dimensional sparse matrix for which to get the LU decomposition.
	   * @param {Number}       order          The Symbolic Ordering and Analysis order:
	   *                                       0 - Natural ordering, no permutation vector q is returned
	   *                                       1 - Matrix must be square, symbolic ordering and analisis is performed on M = A + A'
	   *                                       2 - Symbolic ordering and analisis is performed on M = A' * A. Dense columns from A' are dropped, A recreated from A'. 
	   *                                           This is appropriatefor LU factorization of unsymmetric matrices.
	   *                                       3 - Symbolic ordering and analisis is performed on M = A' * A. This is best used for LU factorization is matrix M has no dense rows.
	   *                                           A dense row is a row with more than 10*sqr(columns) entries.
	   * @param {Number}       threshold       Partial pivoting threshold (1 for partial pivoting)
	   *
	   * @return {Object} The lower triangular matrix, the upper triangular matrix and the permutation vectors.
	   */
	  var slu = typed('slu', {

	    'SparseMatrix, number, number': function (a, order, threshold) {
	      // verify order
	      if (!isInteger(order) || order < 0 || order > 3)
	        throw new Error('Symbolic Ordering and Analysis order must be an integer number in the interval [0, 3]');
	      // verify threshold
	      if (threshold < 0 || threshold > 1)
	        throw new Error('Partial pivoting threshold must be a number from 0 to 1');
	      
	      // perform symbolic ordering and analysis
	      var s = cs_sqr(order, a, false);
	      
	      // perform lu decomposition
	      var f = cs_lu(a, s, threshold);
	      
	      // return decomposition
	      return {
	        L: f.L,
	        U: f.U,
	        p: f.pinv,
	        q: s.q,
	        toString: function () {
	          return 'L: ' + this.L.toString() + '\nU: ' + this.U.toString() + '\np: ' + this.p.toString() + (this.q ? '\nq: ' + this.q.toString() : '') + '\n';
	        }
	      };
	    }
	  });

	  return slu;
	}

	exports.name = 'slu';
	exports.factory = factory;


/***/ },
/* 68 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	function factory (type, config, load) {

	  var cs_amd = load(__webpack_require__(69));
	  var cs_permute = load(__webpack_require__(73));
	  var cs_etree = load(__webpack_require__(74));
	  var cs_post = load(__webpack_require__(75));
	  var cs_counts = load(__webpack_require__(76));

	  /**
	   * Symbolic ordering and analysis for QR and LU decompositions.
	   *
	   * @param {Number}  order           The ordering strategy (see cs_amd for more details)
	   * @param {Matrix}  a               The A matrix
	   * @param {boolean} qr              Symbolic ordering and analysis for QR decomposition (true) or
	   *                                  symbolic ordering and analysis for LU decomposition (false)
	   *
	   * @return {Object}                 The Symbolic ordering and analysis for matrix A
	   *
	   * Reference: http://faculty.cse.tamu.edu/davis/publications.html
	   */
	  var cs_sqr = function (order, a, qr) {
	    // a arrays
	    var aptr = a._ptr;
	    var asize = a._size;
	    // columns
	    var n = asize[1];
	    // vars
	    var k;
	    // symbolic analysis result
	    var s = {};    
	    // fill-reducing ordering
	    s.q = cs_amd(order, a);
	    // validate results
	    if (order && !s.q) 
	      return null;
	    // QR symbolic analysis
	    if (qr) {
	      // apply permutations if needed
	      var c = order ? cs_permute(a, null, s.q, 0) : a;
	      // etree of C'*C, where C=A(:,q)
	      s.parent = cs_etree(c, 1);
	      // post order elimination tree
	      var post = cs_post (s.parent, n);
	      // col counts chol(C'*C)
	      s.cp = cs_counts(c, s.parent, post, 1);
	      // check we have everything needed to calculate number of nonzero elements
	      if (c && s.parent && s.cp && _vcount(c, s)) {
	        // calculate number of nonzero elements
	        for (s.unz = 0, k = 0; k < n; k++) 
	          s.unz += s.cp[k];
	      }
	    }
	    else {
	      // for LU factorization only, guess nnz(L) and nnz(U)
	      s.unz = 4 * (aptr[n]) + n;
	      s.lnz = s.unz;
	    }
	    // return result S
	    return s;
	  };
	  
	  /**
	   * Compute nnz(V) = s.lnz, s.pinv, s.leftmost, s.m2 from A and s.parent
	   */
	  var _vcount = function (a, s) {
	    // a arrays
	    var aptr = a._ptr;
	    var aindex = a._index;
	    var asize = a._size;
	    // rows & columns
	    var m = asize[0];
	    var n = asize[1];
	    // initialize s arrays
	    s.pinv = []; // (m + n);
	    s.leftmost = []; // (m);
	    // vars
	    var parent = s.parent;
	    var pinv = s.pinv;
	    var leftmost = s.leftmost;
	    // workspace, next: first m entries, head: next n entries, tail: next n entries, nque: next n entries
	    var w = []; // (m + 3 * n);
	    var next = 0;
	    var head = m;
	    var tail = m + n;
	    var nque = m + 2 * n;
	    // vars
	    var i, k, p, p0, p1;
	    // initialize w
	    for (k = 0; k < n; k++) {
	      // queue k is empty
	      w[head + k] = -1;
	      w[tail + k] = -1;
	      w[nque + k] = 0;
	    }
	    // initialize row arrays
	    for (i = 0; i < m; i++) 
	      leftmost[i] = -1;
	    // loop columns backwards    
	    for (k = n - 1; k >= 0; k--) {
	      // values & index for column k
	      for (p0 = aptr[k], p1 = aptr[k + 1], p = p0; p < p1; p++) {
	        // leftmost[i] = min(find(A(i,:)))
	        leftmost[aindex[p]] = k;
	      }
	    }
	    // scan rows in reverse order
	    for (i = m - 1; i >= 0; i--) {
	      // row i is not yet ordered
	      pinv[i] = -1;
	      k = leftmost[i];
	      // check row i is empty
	      if (k == -1) 
	        continue;
	      // first row in queue k
	      if (w[nque + k]++ === 0) 
	        w[tail + k] = i;
	      // put i at head of queue k
	      w[next + i] = w[head + k];
	      w[head + k] = i;
	    }
	    s.lnz = 0;
	    s.m2 = m;
	    // find row permutation and nnz(V)
	    for (k = 0; k < n; k++) {
	      // remove row i from queue k
	      i = w[head + k];
	      // count V(k,k) as nonzero
	      s.lnz++;
	      // add a fictitious row
	      if (i < 0) 
	        i = s.m2++;
	      // associate row i with V(:,k)
	      pinv[i] = k;
	      // skip if V(k+1:m,k) is empty
	      if (--nque[k] <= 0) 
	        continue;
	      // nque[k] is nnz (V(k+1:m,k))
	      s.lnz += w[nque + k];
	      // move all rows to parent of k
	      var pa = parent[k];
	      if (pa != -1) {
	        if (w[nque + pa] === 0) 
	          w[tail + pa] = w[tail + k];
	        w[next + w[tail + k]] = w[head + pa];
	        w[head + pa] = w[next + i];
	        w[nque + pa] += w[nque + k];
	      }
	    }
	    for (i = 0; i < m; i++) {
	      if (pinv[i] < 0) 
	        pinv[i] = k++;
	    }
	    return true;
	  };

	  return cs_sqr;
	}

	exports.name = 'cs_sqr';
	exports.path = 'sparse';
	exports.factory = factory;


/***/ },
/* 69 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	function factory (type, config, load) {

	  var cs_flip = load(__webpack_require__(70));
	  var cs_fkeep = load(__webpack_require__(71));
	  var cs_tdfs = load(__webpack_require__(72));
	  
	  var add       = load(__webpack_require__(44));
	  var multiply  = load(__webpack_require__(40));
	  var transpose = load(__webpack_require__(59));

	  /**
	   * Approximate minimum degree ordering. The minimum degree algorithm is a widely used 
	   * heuristic for finding a permutation P so that P*A*P' has fewer nonzeros in its factorization
	   * than A. It is a gready method that selects the sparsest pivot row and column during the course
	   * of a right looking sparse Cholesky factorization.
	   *
	   * Reference: http://faculty.cse.tamu.edu/davis/publications.html
	   *
	   * @param {Number} order    0: Natural, 1: Cholesky, 2: LU, 3: QR
	   * @param {Matrix} m        Sparse Matrix
	   *
	   * Reference: http://faculty.cse.tamu.edu/davis/publications.html
	   */
	  var cs_amd = function (order, a) {
	    // check input parameters
	    if (!a || order <= 0 || order > 3)
	      return null;
	    // a matrix arrays
	    var asize = a._size;
	    // rows and columns
	    var m = asize[0];
	    var n = asize[1];    
	    // initialize vars
	    var lemax = 0;
	    // dense threshold
	    var dense = Math.max(16, 10 * Math.sqrt(n));
	    dense = Math.min(n - 2, dense);
	    // create target matrix C
	    var cm = _createTargetMatrix(order, a, m, n, dense);
	    // drop diagonal entries
	    cs_fkeep(cm, _diag, null);
	    // C matrix arrays
	    var cindex = cm._index;
	    var cptr = cm._ptr;

	    // number of nonzero elements in C
	    var cnz = cptr[n];
	    
	    // allocate result (n+1)
	    var P = [];
	    
	    // create workspace (8 * (n + 1))
	    var W = [];
	    var len = 0; // first n + 1 entries
	    var nv = n + 1; // next n + 1 entries
	    var next = 2 * (n + 1); // next n + 1 entries
	    var head = 3 * (n + 1);  // next n + 1 entries
	    var elen = 4 * (n + 1);  // next n + 1 entries
	    var degree = 5 * (n + 1);  // next n + 1 entries
	    var w = 6 * (n + 1);  // next n + 1 entries
	    var hhead = 7 * (n + 1);  // last n + 1 entries    

	    // use P as workspace for last
	    var last = P;
	    
	    // initialize quotient graph
	    var mark = _initializeQuotientGraph(n, cptr, W, len, head, last, next, hhead, nv, w, elen, degree);
	    
	    // initialize degree lists
	    var nel = _initializeDegreeLists(n, cptr, W, degree, elen, w, dense, nv, head, last, next);
	    
	    // minimum degree node
	    var mindeg = 0;
	    
	    // vars
	    var i, j, k, k1, k2, e, pj, ln, nvi, pk, eln, p1, p2, pn, h, d;
	    
	    // while (selecting pivots) do
	    while (nel < n) {
	      // select node of minimum approximate degree. amd() is now ready to start eliminating the graph. It first
	      // finds a node k of minimum degree and removes it from its degree list. The variable nel keeps track of thow
	      // many nodes have been eliminated.
	      for (k = -1; mindeg < n && (k = W[head + mindeg]) == -1; mindeg++);      
	      if (W[next + k] != -1) 
	        last[W[next + k]] = -1;
	      // remove k from degree list
	      W[head + mindeg] = W[next + k];
	      // elenk = |Ek|
	      var elenk = W[elen + k];
	      // # of nodes k represents
	      var nvk = W[nv + k];
	      // W[nv + k] nodes of A eliminated
	      nel += nvk;

	      // Construct a new element. The new element Lk is constructed in place if |Ek| = 0. nv[i] is 
	      // negated for all nodes i in Lk to flag them as members of this set. Each node i is removed from the
	      // degree lists. All elements e in Ek are absorved into element k.
	      var dk = 0;
	      // flag k as in Lk
	      W[nv + k] = -nvk;
	      var p = cptr[k];
	      // do in place if W[elen + k] == 0
	      var pk1 = (elenk === 0) ? p : cnz;
	      var pk2 = pk1;
	      for (k1 = 1; k1 <= elenk + 1; k1++) {
	        if (k1 > elenk) {
	          // search the nodes in k
	          e = k;
	          // list of nodes starts at cindex[pj]
	          pj = p;
	          // length of list of nodes in k
	          ln = W[len + k] - elenk;
	        }
	        else {
	          // search the nodes in e
	          e = cindex[p++];
	          pj = cptr[e];
	          // length of list of nodes in e
	          ln = W[len + e];
	        }
	        for (k2 = 1; k2 <= ln; k2++) {
	          i = cindex[pj++];
	          // check  node i dead, or seen
	          if ((nvi = W[nv + i]) <= 0) 
	            continue;
	          // W[degree + Lk] += size of node i
	          dk += nvi;
	          // negate W[nv + i] to denote i in Lk
	          W[nv + i] = -nvi;
	          // place i in Lk
	          cindex[pk2++] = i;
	          if (W[next + i] != -1) 
	            last[W[next + i]] = last[i];
	          // check we need to remove i from degree list
	          if (last[i] != -1) 
	            W[next + last[i]] = W[next + i];
	          else
	            W[head + W[degree + i]] = W[next + i];
	        }
	        if (e != k) {
	          // absorb e into k
	          cptr[e] = cs_flip(k);
	          // e is now a dead element
	          W[w + e] = 0;
	        }
	      }
	      // cindex[cnz...nzmax] is free
	      if (elenk !== 0) 
	        cnz = pk2;
	      // external degree of k - |Lk\i|
	      W[degree + k] = dk;
	      // element k is in cindex[pk1..pk2-1]
	      cptr[k] = pk1;
	      W[len + k] = pk2 - pk1;
	      // k is now an element
	      W[elen + k] = -2;
	            
	      // Find set differences. The scan1 function now computes the set differences |Le \ Lk| for all elements e. At the start of the
	      // scan, no entry in the w array is greater than or equal to mark.
	      
	      // clear w if necessary
	      mark = _wclear(mark, lemax, w, n);
	      // scan 1: find |Le\Lk|
	      for (pk = pk1; pk < pk2; pk++) {
	        i = cindex[pk];
	        // check if W[elen + i] empty, skip it
	        if ((eln = W[elen + i]) <= 0) 
	          continue;
	        // W[nv + i] was negated
	        nvi = -W[nv + i];
	        var wnvi = mark - nvi;
	        // scan Ei
	        for (p = cptr[i], p1 = cptr[i] + eln - 1; p <= p1; p++) {
	          e = cindex[p];
	          if (W[w + e] >= mark) {
	            // decrement |Le\Lk|
	            W[w + e] -= nvi;
	          }
	          else if (W[w + e] !== 0) {
	            // ensure e is a live element, 1st time e seen in scan 1
	            W[w + e] = W[degree + e] + wnvi;
	          }
	        }
	      }
	      
	      // degree update
	      // The second pass computes the approximate degree di, prunes the sets Ei and Ai, and computes a hash
	      // function h(i) for all nodes in Lk.
	      
	      // scan2: degree update
	      for (pk = pk1; pk < pk2; pk++) {
	        // consider node i in Lk
	        i = cindex[pk];
	        p1 = cptr[i];
	        p2 = p1 + W[elen + i] - 1;
	        pn = p1;
	        // scan Ei
	        for (h = 0, d = 0, p = p1; p <= p2; p++) {
	          e = cindex[p];
	          // check e is an unabsorbed element
	          if (W[w + e] !== 0) {
	            // dext = |Le\Lk|
	            var dext = W[w + e] - mark;
	            if (dext > 0) {
	              // sum up the set differences
	              d += dext;
	              // keep e in Ei
	              cindex[pn++] = e;
	              // compute the hash of node i
	              h += e;
	            }
	            else {
	              // aggressive absorb. e->k
	              cptr[e] = cs_flip(k);
	              // e is a dead element
	              W[w + e] = 0;
	            }
	          }
	        }
	        // W[elen + i] = |Ei|
	        W[elen + i] = pn - p1 + 1;
	        var p3 = pn;
	        var p4 = p1 + W[len + i];
	        // prune edges in Ai
	        for (p = p2 + 1; p < p4; p++) {
	          j = cindex[p];
	          // check node j dead or in Lk
	          var nvj = W[nv + j];
	          if (nvj <= 0) 
	            continue;
	          // degree(i) += |j|
	          d += nvj;
	          // place j in node list of i
	          cindex[pn++] = j;
	          // compute hash for node i
	          h += j;
	        }
	        // check for mass elimination
	        if (d === 0) {
	          // absorb i into k
	          cptr[i] = cs_flip(k);
	          nvi = -W[nv + i];
	          // |Lk| -= |i|
	          dk -= nvi;
	          // |k| += W[nv + i]
	          nvk += nvi;
	          nel += nvi;
	          W[nv + i] = 0;
	          // node i is dead
	          W[elen + i] = -1;
	        }
	        else {
	          // update degree(i)
	          W[degree + i] = Math.min(W[degree + i], d);
	          // move first node to end
	          cindex[pn] = cindex[p3];
	          // move 1st el. to end of Ei
	          cindex[p3] = cindex[p1];
	          // add k as 1st element in of Ei
	          cindex[p1] = k;
	          // new len of adj. list of node i
	          W[len + i] = pn - p1 + 1;
	          // finalize hash of i
	          h = (h < 0 ? -h : h) % n;
	          // place i in hash bucket
	          W[next + i] = W[hhead + h];
	          W[hhead + h] = i;
	          // save hash of i in last[i]
	          last[i] = h;
	        }
	      }
	      // finalize |Lk|
	      W[degree + k] = dk;
	      lemax = Math.max(lemax, dk);
	      // clear w
	      mark = _wclear(mark + lemax, lemax, w, n);
	      
	      // Supernode detection. Supernode detection relies on the hash function h(i) computed for each node i.
	      // If two nodes have identical adjacency lists, their hash functions wil be identical.
	      for (pk = pk1; pk < pk2; pk++) {
	        i = cindex[pk];
	        // check i is dead, skip it
	        if (W[nv + i] >= 0) 
	          continue;
	        // scan hash bucket of node i
	        h = last[i];
	        i = W[hhead + h];
	        // hash bucket will be empty
	        W[hhead + h] = -1;
	        for (; i != -1 && W[next + i] != -1; i = W[next + i], mark++) {
	          ln = W[len + i];
	          eln = W[elen + i];
	          for (p = cptr[i] + 1; p <= cptr[i] + ln - 1; p++) 
	            W[w + cindex[p]] = mark;
	          var jlast = i;
	          // compare i with all j
	          for (j = W[next + i]; j != -1; ) {
	            var ok = W[len + j] === ln && W[elen + j] === eln;
	            for (p = cptr[j] + 1; ok && p <= cptr[j] + ln - 1; p++) {
	              // compare i and j
	              if (W[w + cindex[p]] != mark) 
	                ok = 0;
	            }
	            // check i and j are identical
	            if (ok) {
	              // absorb j into i
	              cptr[j] = cs_flip(i);
	              W[nv + i] += W[nv + j];
	              W[nv + j] = 0;
	              // node j is dead
	              W[elen + j] = -1;
	              // delete j from hash bucket
	              j = W[next + j];
	              W[next + jlast] = j;
	            }
	            else {
	              // j and i are different
	              jlast = j;
	              j = W[next + j];
	            }
	          }
	        }
	      }
	      
	      // Finalize new element. The elimination of node k is nearly complete. All nodes i in Lk are scanned one last time.
	      // Node i is removed from Lk if it is dead. The flagged status of nv[i] is cleared.
	      for (p = pk1, pk = pk1; pk < pk2; pk++) {
	        i = cindex[pk];
	        // check  i is dead, skip it
	        if ((nvi = -W[nv + i]) <= 0) 
	          continue;
	        // restore W[nv + i]
	        W[nv + i] = nvi;
	        // compute external degree(i)
	        d = W[degree + i] + dk - nvi;
	        d = Math.min(d, n - nel - nvi);
	        if (W[head + d] != -1) 
	          last[W[head + d]] = i;
	        // put i back in degree list
	        W[next + i] = W[head + d];
	        last[i] = -1;
	        W[head + d] = i;
	        // find new minimum degree
	        mindeg = Math.min(mindeg, d);
	        W[degree + i] = d;
	        // place i in Lk
	        cindex[p++] = i;
	      }
	      // # nodes absorbed into k
	      W[nv + k] = nvk;
	      // length of adj list of element k
	      if ((W[len + k] = p - pk1) === 0) {
	        // k is a root of the tree
	        cptr[k] = -1;
	        // k is now a dead element
	        W[w + k] = 0;
	      }
	      if (elenk !== 0) {
	        // free unused space in Lk
	        cnz = p;
	      }
	    }
	    
	    // Postordering. The elimination is complete, but no permutation has been computed. All that is left 
	    // of the graph is the assembly tree (ptr) and a set of dead nodes and elements (i is a dead node if
	    // nv[i] is zero and a dead element if nv[i] > 0). It is from this information only that the final permutation
	    // is computed. The tree is restored by unflipping all of ptr.
	    
	    // fix assembly tree
	    for (i = 0; i < n; i++) 
	      cptr[i] = cs_flip(cptr[i]);
	    for (j = 0; j <= n; j++) 
	      W[head + j] = -1;
	    // place unordered nodes in lists
	    for (j = n; j >= 0; j--) {
	      // skip if j is an element
	      if (W[nv + j] > 0)
	        continue;
	      // place j in list of its parent
	      W[next + j] = W[head + cptr[j]];
	      W[head + cptr[j]] = j;
	    }
	    // place elements in lists
	    for (e = n; e >= 0; e--) {
	      // skip unless e is an element
	      if (W[nv + e] <= 0)
	        continue;
	      if (cptr[e] != -1) {
	        // place e in list of its parent
	        W[next + e] = W[head + cptr[e]];
	        W[head + cptr[e]] = e;
	      }
	    }
	    // postorder the assembly tree
	    for (k = 0, i = 0; i <= n; i++) {
	      if (cptr[i] == -1) 
	        k = cs_tdfs(i, k, W, head, next, P, w);
	    }
	    // remove last item in array
	    P.splice(P.length - 1, 1);
	    // return P
	    return P;
	  };
	  
	  /**
	   * Creates the matrix that will be used by the approximate minimum degree ordering algorithm. The function accepts the matrix M as input and returns a permutation
	   * vector P. The amd algorithm operates on a symmetrix matrix, so one of three symmetric matrices is formed.
	   *
	   * Order: 0
	   *   A natural ordering P=null matrix is returned.
	   *
	   * Order: 1
	   *   Matrix must be square. This is appropriate for a Cholesky or LU factorization.
	   *   P = M + M'
	   *
	   * Order: 2
	   *   Dense columns from M' are dropped, M recreated from M'. This is appropriatefor LU factorization of unsymmetric matrices.
	   *   P = M' * M
	   * 
	   * Order: 3
	   *   This is best used for QR factorization or LU factorization is matrix M has no dense rows. A dense row is a row with more than 10*sqr(columns) entries.
	   *   P = M' * M
	   */
	  var _createTargetMatrix = function (order, a, m, n, dense) {
	    // compute A'
	    var at = transpose(a);

	    // check order = 1, matrix must be square
	    if (order === 1 && n === m) {
	      // C = A + A'
	      return add(a, at);
	    }
	    
	    // check order = 2, drop dense columns from M'
	    if (order == 2) {
	      // transpose arrays
	      var tindex = at._index;
	      var tptr = at._ptr;
	      // new column index
	      var p2 = 0;
	      // loop A' columns (rows)
	      for (var j = 0; j < m; j++) {
	        // column j of AT starts here
	        var p = tptr[j];
	        // new column j starts here
	        tptr[j] = p2;
	        // skip dense col j
	        if (tptr[j + 1] - p > dense) 
	          continue;
	        // map rows in column j of A
	        for (var p1 = tptr[j + 1]; p < p1; p++) 
	          tindex[p2++] = tindex[p];
	      }
	      // finalize AT
	      tptr[m] = p2;
	      // recreate A from new transpose matrix
	      a = transpose(at);
	      // use A' * A
	      return multiply(at, a);
	    }
	    
	    // use A' * A, square or rectangular matrix
	    return multiply(at, a);
	  };

	  /**
	   * Initialize quotient graph. There are four kind of nodes and elements that must be represented:
	   *
	   *  - A live node is a node i (or a supernode) that has not been selected as a pivot nad has not been merged into another supernode.
	   *  - A dead node i is one that has been removed from the graph, having been absorved into r = flip(ptr[i]).
	   *  - A live element e is one that is in the graph, having been formed when node e was selected as the pivot.
	   *  - A dead element e is one that has benn absorved into a subsequent element s = flip(ptr[e]).
	   */
	  var _initializeQuotientGraph = function (n, cptr, W, len, head, last, next, hhead, nv, w, elen, degree) {
	    // Initialize quotient graph
	    for (var k = 0; k < n; k++) 
	      W[len + k] = cptr[k + 1] - cptr[k];
	    W[len + n] = 0;
	    // initialize workspace
	    for (var i = 0; i <= n; i++) {
	      // degree list i is empty
	      W[head + i] = -1;
	      last[i] = -1;
	      W[next + i] = -1;
	      // hash list i is empty
	      W[hhead + i] = -1;
	      // node i is just one node
	      W[nv + i] = 1;
	      // node i is alive
	      W[w + i] = 1;
	      // Ek of node i is empty
	      W[elen + i] = 0;
	      // degree of node i
	      W[degree + i] = W[len + i];
	    }
	    // clear w
	    var mark = _wclear(0, 0, w, n);
	    // n is a dead element
	    W[elen + n] = -2;
	    // n is a root of assembly tree
	    cptr[n] = -1;
	    // n is a dead element
	    W[w + n] = 0;
	    // return mark
	    return mark;
	  };

	  /**
	   * Initialize degree lists. Each node is placed in its degree lists. Nodes of zero degree are eliminated immediately. Nodes with 
	   * degree >= dense are alsol eliminated and merged into a placeholder node n, a dead element. Thes nodes will appera last in the
	   * output permutation p.
	   */
	  var _initializeDegreeLists = function (n, cptr, W, degree, elen, w, dense, nv, head, last, next) {
	    // result
	    var nel = 0;
	    // loop columns
	    for (var i = 0; i < n; i++) {
	      // degree @ i
	      var d = W[degree + i];
	      // check node i is empty
	      if (d === 0) {
	        // element i is dead
	        W[elen + i] = -2;
	        nel++;
	        // i is a root of assembly tree
	        cptr[i] = -1;
	        W[w + i] = 0;
	      }
	      else if (d > dense) {
	        // absorb i into element n
	        W[nv + i] = 0;
	        // node i is dead
	        W[elen + i] = -1;
	        nel++;
	        cptr[i] = cs_flip(n);
	        W[nv + n]++;
	      }
	      else {
	        var h = W[head + d];
	        if (h != -1)
	          last[h] = i;
	        // put node i in degree list d
	        W[next + i] = W[head + d];
	        W[head + d] = i;
	      }
	    }
	    return nel;
	  };

	  var _wclear = function(mark, lemax, w, n) {
	    if (mark < 2 || (mark + lemax < 0)) {
	      for (var k = 0; k < n; k++) {
	        if (w[k] !== 0)
	          w[k] = 1;
	      }
	      mark = 2 ;
	    }
	    // at this point, w [0..n-1] < mark holds
	    return mark;
	  };
	  
	  var _diag = function (i, j) { 
	    return i != j;
	  };
	  
	  return cs_amd;
	}

	exports.name = 'cs_amd';
	exports.path = 'sparse';
	exports.factory = factory;


/***/ },
/* 70 */
/***/ function(module, exports) {

	'use strict';

	function factory () {

	  /**
	   * This function "flips" its input about the integer -1.
	   *
	   * @param {Number}  i               The value to flip
	   *
	   * Reference: http://faculty.cse.tamu.edu/davis/publications.html
	   */
	  var cs_flip = function (i) {
	    // flip the value
	    return -i - 2;
	  };

	  return cs_flip;
	}

	exports.name = 'cs_flip';
	exports.path = 'sparse';
	exports.factory = factory;


/***/ },
/* 71 */
/***/ function(module, exports) {

	'use strict';

	function factory () {

	  /**
	   * Keeps entries in the matrix when the callback function returns true, removes the entry otherwise
	   *
	   * @param {Matrix}   a              The sparse matrix
	   * @param {function} callback       The callback function, function will be invoked with the following args:
	   *                                    - The entry row
	   *                                    - The entry column
	   *                                    - The entry value
	   *                                    - The state parameter
	   * @param {any}      other          The state
	   *
	   * @return                          The number of nonzero elements in the matrix
	   *
	   * Reference: http://faculty.cse.tamu.edu/davis/publications.html
	   */
	  var cs_fkeep = function (a, callback, other) {
	    // a arrays
	    var avalues = a._values;
	    var aindex = a._index;
	    var aptr = a._ptr;
	    var asize = a._size;
	    // columns
	    var n = asize[1];
	    // nonzero items
	    var nz = 0;
	    // loop columns
	    for (var j = 0; j < n; j++) {
	      // get current location of col j
	      var p = aptr[j];
	      // record new location of col j
	      aptr[j] = nz;
	      for (; p < aptr[j+1]; p++) {
	        // check we need to keep this item
	        if (callback(aindex[p], j, avalues ? avalues[p] : 1, other)) {
	          // keep A(i,j)
	          aindex[nz] = aindex[p];
	          // check we need to process values (pattern only)
	          if (avalues) 
	            avalues[nz] = avalues[p];
	          // increment nonzero items
	          nz++;
	        }
	      }
	    }
	    // finalize A
	    aptr[n] = nz;
	    // trim arrays
	    aindex.splice(nz, aindex.length - nz);
	    // check we need to process values (pattern only)
	    if (avalues)
	      avalues.splice(nz, avalues.length - nz);    
	    // return number of nonzero items
	    return (nz);
	  };
	  
	  return cs_fkeep;
	}

	exports.name = 'cs_fkeep';
	exports.path = 'sparse';
	exports.factory = factory;


/***/ },
/* 72 */
/***/ function(module, exports) {

	'use strict';

	function factory () {

	  /**
	   * Depth-first search and postorder of a tree rooted at node j
	   *
	   * @param {Number}  j               The tree node
	   * @param {Number}  k               
	   * @param {Array}   w               The workspace array
	   * @param {Number}  head            The index offset within the workspace for the head array
	   * @param {Number}  next            The index offset within the workspace for the next array
	   * @param {Array}   post            The post ordering array
	   * @param {Number}  stack           The index offset within the workspace for the stack array
	   *
	   * Reference: http://faculty.cse.tamu.edu/davis/publications.html
	   */
	  var cs_tdfs = function (j, k, w, head, next, post, stack) {
	    // variables
	    var top = 0;
	    // place j on the stack
	    w[stack] = j;
	    // while (stack is not empty) 
	    while (top >= 0) {
	      // p = top of stack
	      var p = w[stack + top];
	      // i = youngest child of p
	      var i = w[head + p];
	      if (i == -1) {
	        // p has no unordered children left
	        top--;
	        // node p is the kth postordered node
	        post[k++] = p;
	      }
	      else {
	        // remove i from children of p
	        w[head + p] = w[next + i];
	        // increment top
	        ++top;
	        // start dfs on child node i
	        w[stack + top] = i;
	      }
	    }
	    return k;
	  };

	  return cs_tdfs;
	}

	exports.name = 'cs_tdfs';
	exports.path = 'sparse';
	exports.factory = factory;


/***/ },
/* 73 */
/***/ function(module, exports) {

	'use strict';

	function factory (type) {

	  var SparseMatrix = type.SparseMatrix;

	  /**
	   * Permutes a sparse matrix C = P * A * Q
	   *
	   * @param {Matrix}  a               The Matrix A
	   * @param {Array}   pinv            The row permutation vector
	   * @param {Array}   q               The column permutation vector
	   * @param {boolean} values          Create a pattern matrix (false), values and pattern otherwise
	   *
	   * @return {Matrix}                 C = P * A * Q, null on error
	   *
	   * Reference: http://faculty.cse.tamu.edu/davis/publications.html
	   */
	  var cs_permute = function (a, pinv, q, values) {
	    // a arrays
	    var avalues = a._values;
	    var aindex = a._index;
	    var aptr = a._ptr;
	    var asize = a._size;
	    var adt = a._datatype;
	    // rows & columns
	    var m = asize[0];
	    var n = asize[1];
	    // c arrays
	    var cvalues = values && a._values ? [] : null;
	    var cindex = []; // (aptr[n]);
	    var cptr = []; // (n + 1);
	    // initialize vars
	    var nz = 0;
	    // loop columns    
	    for (var k = 0; k < n; k++) {
	      // column k of C is column q[k] of A
	      cptr[k] = nz;
	      // apply column permutation
	      var j = q ? (q[k]) : k;
	      // loop values in column j of A
	      for (var t0 = aptr[j], t1 = aptr[j + 1], t = t0; t < t1; t++) {
	        // row i of A is row pinv[i] of C
	        var r = pinv ? pinv[aindex[t]] : aindex[t];
	        // index
	        cindex[nz] = r;
	        // check we need to populate values
	        if (cvalues) 
	          cvalues[nz] = avalues[t];
	        // increment number of nonzero elements
	        nz++;
	      }
	    }
	    // finalize the last column of C
	    cptr[n] = nz;
	    // return C matrix
	    return new SparseMatrix({
	      values: cvalues,
	      index: cindex,
	      ptr: cptr,
	      size: [m, n],
	      datatype: adt
	    });
	  };

	  return cs_permute;
	}

	exports.name = 'cs_permute';
	exports.path = 'sparse';
	exports.factory = factory;


/***/ },
/* 74 */
/***/ function(module, exports) {

	'use strict';

	function factory () {

	  /**
	   * Computes the elimination tree of Matrix A (using triu(A)) or the 
	   * elimination tree of A'A without forming A'A.
	   *
	   * @param {Matrix}  a               The A Matrix
	   * @param {boolean} ata             A value of true the function computes the etree of A'A
	   *
	   * Reference: http://faculty.cse.tamu.edu/davis/publications.html
	   */
	  var cs_etree = function (a, ata) {
	    // check inputs
	    if (!a)
	      return null;
	    // a arrays
	    var aindex = a._index;
	    var aptr = a._ptr;
	    var asize = a._size;
	    // rows & columns
	    var m = asize[0];
	    var n = asize[1];
	    
	    // allocate result
	    var parent = []; // (n)
	    
	    // allocate workspace
	    var w = []; // (n + (ata ? m : 0))
	    var ancestor = 0; // first n entries in w
	    var prev = n; // last m entries (ata = true)
	    
	    var i, inext;
	    
	    // check we are calculating A'A
	    if (ata) {
	      // initialize workspace
	      for (i = 0; i < m; i++) 
	        w[prev + i] = -1;
	    }
	    // loop columns
	    for (var k = 0; k < n; k++) {
	      // node k has no parent yet
	      parent[k] = -1;
	      // nor does k have an ancestor
	      w[ancestor + k] = -1;
	      // values in column k
	      for (var p0 = aptr[k], p1 = aptr[k + 1], p = p0; p < p1; p++) {
	        // row
	        var r = aindex[p];
	        // node
	        i = ata ? (w[prev + r]) : r;
	        // traverse from i to k 
	        for (; i != -1 && i < k; i = inext) {
	          // inext = ancestor of i
	          inext = w[ancestor + i];
	          // path compression
	          w[ancestor + i] = k;
	          // check no anc., parent is k
	          if (inext == -1) 
	            parent[i] = k;
	        }
	        if (ata) 
	          w[prev + r] = k;
	      }
	    }
	    return parent;
	  };

	  return cs_etree;
	}

	exports.name = 'cs_etree';
	exports.path = 'sparse';
	exports.factory = factory;


/***/ },
/* 75 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	function factory (type, config, load) {

	  var cs_tdfs = load(__webpack_require__(72));

	  /**
	   * Post order a tree of forest
	   *
	   * @param {Array}   parent          The tree or forest
	   * @param {Number}  n               Number of columns
	   *
	   * Reference: http://faculty.cse.tamu.edu/davis/publications.html
	   */
	  var cs_post = function (parent, n) {
	    // check inputs
	    if (!parent) 
	      return null;
	    // vars 
	    var k = 0;
	    var j;
	    // allocate result
	    var post = []; // (n);
	    // workspace, head: first n entries, next: next n entries, stack: last n entries
	    var w = []; // (3 * n);
	    var head = 0; 
	    var next = n; 
	    var stack = 2 * n;
	    // initialize workspace
	    for (j = 0; j < n; j++) {
	      // empty linked lists
	      w[head + j] = -1;
	    }
	    // traverse nodes in reverse order
	    for (j = n-1; j >= 0; j--) {
	      // check j is a root
	      if (parent[j] == -1) 
	        continue;
	      // add j to list of its parent
	      w[next + j] = w[head + parent[j]];
	      w[head + parent[j]] = j;
	    }
	    // loop nodes
	    for (j = 0; j < n; j++) {
	      // skip j if it is not a root
	      if (parent[j] != -1) 
	        continue;
	      // depth-first search
	      k = cs_tdfs(j, k, w, head, next, post, stack);
	    }
	    return post;
	  };

	  return cs_post;
	}

	exports.name = 'cs_post';
	exports.path = 'sparse';
	exports.factory = factory;


/***/ },
/* 76 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	function factory (type, config, load) {

	  var transpose = load(__webpack_require__(59));
	  
	  var cs_leaf = load(__webpack_require__(77));

	  /**
	   * Computes the column counts using the upper triangular part of A.
	   * It transposes A internally, none of the input parameters are modified.
	   *
	   * @param {Matrix} a           The sparse matrix A
	   *
	   * @param {Matrix} ata         Count the columns of A'A instead
	   *
	   * @return                     An array of size n of the column counts or null on error
	   *
	   * Reference: http://faculty.cse.tamu.edu/davis/publications.html
	   */
	  var cs_counts = function (a, parent, post, ata) {
	    // check inputs
	    if (!a || !parent || !post) 
	      return null;
	    // a matrix arrays
	    var asize = a._size;
	    // rows and columns
	    var m = asize[0];
	    var n = asize[1];   
	    // variables
	    var i, j, k,  J,  p, p0, p1;
	    
	    // workspace size
	    var s = 4 * n + (ata ? (n + m + 1) : 0);
	    // allocate workspace
	    var w = []; // (s)
	    var ancestor = 0; // first n entries
	    var maxfirst = n; // next n entries
	    var prevleaf = 2 * n; // next n entries
	    var first = 3 * n; // next n entries
	    var head = 4 * n; // next n + 1 entries (used when ata is true)
	    var next = 5 * n + 1; // last entries in workspace
	    // clear workspace w[0..s-1]
	    for (k = 0; k < s; k++) 
	      w[k] = -1;
	    
	    // allocate result
	    var colcount = []; // (n);
	    
	    // AT = A'
	    var at = transpose(a);
	    // at arrays
	    var tindex = at._index;
	    var tptr = at._ptr;

	    // find w[first + j]
	    for (k = 0; k < n; k++) {
	      j = post[k];
	      // colcount[j]=1 if j is a leaf
	      colcount[j] = (w[first + j] == -1) ? 1 : 0;
	      for (; j != -1 && w[first + j] == -1; j = parent[j]) 
	        w[first + j] = k;
	    }

	    // initialize ata if needed
	    if (ata) {
	      // invert post
	      for (k = 0; k < n; k++) 
	        w[post[k]] = k;
	      // loop rows (columns in AT)
	      for (i = 0; i < m; i++) {
	        // values in column i of AT
	        for (k = n, p0 = tptr[i], p1 = tptr[i + 1], p = p0; p < p1; p++) 
	          k = Math.min(k, w[tindex[p]]);
	        // place row i in linked list k
	        w[next + i] = w[head + k];
	        w[head + k] = i;
	      }
	    }
	    
	    // each node in its own set
	    for (i = 0; i < n; i++) 
	      w[ancestor + i] = i;
	    
	    for (k = 0; k < n; k++) {
	      // j is the kth node in postordered etree
	      j = post[k];
	      // check j is not a root
	      if (parent[j] != -1) 
	        colcount[parent[j]]--;
	      
	      // J=j for LL'=A case
	      for (J = (ata ? w[head + k] : j); J != -1; J = (ata ? w[next + J] : -1)) {
	        for (p = tptr[J]; p < tptr[J+1]; p++) {
	          i = tindex[p];
	          var r = cs_leaf(i, j, w, first, maxfirst, prevleaf, ancestor);
	          // check A(i,j) is in skeleton
	          if (r.jleaf >= 1) 
	            colcount[j]++;
	          // check account for overlap in q
	          if (r.jleaf == 2) 
	            colcount[r.q]--;
	        }
	      }
	      if (parent[j] != -1) 
	        w[ancestor + j] = parent[j];
	    }
	    // sum up colcount's of each child
	    for (j = 0; j < n; j++) {
	      if (parent[j] != -1) 
	        colcount[parent[j]] += colcount[j];
	    }
	    return colcount;
	  };

	  return cs_counts;
	}

	exports.name = 'cs_counts';
	exports.path = 'sparse';
	exports.factory = factory;


/***/ },
/* 77 */
/***/ function(module, exports) {

	'use strict';

	function factory () {

	  /**
	   * This function determines if j is a leaf of the ith row subtree.
	   * Consider A(i,j), node j in ith row subtree and return lca(jprev,j)
	   *
	   * @param {Number}  i               The ith row subtree
	   * @param {Number}  j               The node to test
	   * @param {Array}   w               The workspace array
	   * @param {Number}  first           The index offset within the workspace for the first array
	   * @param {Number}  maxfirst        The index offset within the workspace for the maxfirst array
	   * @param {Number}  prevleaf        The index offset within the workspace for the prevleaf array
	   * @param {Number}  ancestor        The index offset within the workspace for the ancestor array
	   *
	   * @return {Object}
	   *
	   * Reference: http://faculty.cse.tamu.edu/davis/publications.html
	   */
	  var cs_leaf = function (i, j, w, first, maxfirst, prevleaf, ancestor) {
	    
	    var s, sparent, jprev;
	    
	    // our result
	    var jleaf = 0;
	    var q;
	    
	    // check j is a leaf
	    if (i <= j || w[first + j] <= w[maxfirst + i]) 
	      return (-1);
	    // update max first[j] seen so far
	    w[maxfirst + i] = w[first + j];
	    // jprev = previous leaf of ith subtree
	    jprev = w[prevleaf + i];
	    w[prevleaf + i] = j;
	    
	    // check j is first or subsequent leaf
	    if (jprev === -1) {
	      // 1st leaf, q = root of ith subtree
	      jleaf = 1;
	      q = i;
	    }
	    else {
	      // update jleaf
	      jleaf = 2;
	      // q = least common ancester (jprev,j)
	      for (q = jprev; q != w[ancestor + q]; q = w[ancestor + q]);
	      for (s = jprev; s != q; s = sparent) {
	        // path compression
	        sparent = w[ancestor + s];
	        w[ancestor + s] = q;
	      }      
	    }
	    return {
	      jleaf: jleaf,
	      q: q
	    };
	  };

	  return cs_leaf;
	}

	exports.name = 'cs_leaf';
	exports.path = 'sparse';
	exports.factory = factory;


/***/ },
/* 78 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	function factory (type, config, load) {

	  var abs = load(__webpack_require__(63));
	  var divideScalar = load(__webpack_require__(51));
	  var multiply = load(__webpack_require__(40));
	  
	  var larger = load(__webpack_require__(64));
	  var largerEq = load(__webpack_require__(79));
	  
	  var cs_spsolve = load(__webpack_require__(80));

	  var SparseMatrix = type.SparseMatrix;

	  /**
	   * Computes the numeric LU factorization of the sparse matrix A. Implements a Left-looking LU factorization
	   * algorithm that computes L and U one column at a tume. At the kth step, it access columns 1 to k-1 of L 
	   * and column k of A. Given the fill-reducing column ordering q (see parameter s) computes L, U and pinv so
	   * L * U = A(p, q), where p is the inverse of pinv.
	   *
	   * @param {Matrix}  m               The A Matrix to factorize
	   * @param {Object}  s               The symbolic analysis from cs_sqr(). Provides the fill-reducing 
	   *                                  column ordering q
	   * @param {Number}  tol             Partial pivoting threshold (1 for partial pivoting)
	   *
	   * @return {Number}                 The numeric LU factorization of A or null
	   *
	   * Reference: http://faculty.cse.tamu.edu/davis/publications.html
	   */
	  var cs_lu = function (m, s, tol) {
	    // validate input
	    if (!m)
	      return null;
	    // m arrays
	    var size = m._size;
	    // columns
	    var n = size[1];
	    // symbolic analysis result
	    var q;
	    var lnz = 100;
	    var unz = 100;
	    // update symbolic analysis parameters
	    if (s) {
	      q = s.q;
	      lnz = s.lnz || lnz;
	      unz = s.unz || unz;
	    }
	    // L arrays
	    var lvalues = []; // (lnz)
	    var lindex = []; // (lnz);
	    var lptr = []; // (n + 1);
	    // L
	    var L = new SparseMatrix({
	      values: lvalues,
	      index: lindex,
	      ptr: lptr,
	      size: [n, n]
	    });
	    // U arrays
	    var uvalues = []; // (unz);
	    var uindex = []; // (unz);
	    var uptr = []; // (n + 1);
	    // U
	    var U = new SparseMatrix({
	      values: uvalues,
	      index: uindex,
	      ptr: uptr,
	      size: [n, n]
	    });
	    // inverse of permutation vector
	    var pinv = []; // (n);
	    // vars 
	    var i, p;
	    // allocate arrays
	    var x = []; // (n);
	    var xi = []; // (2 * n);
	    // initialize variables
	    for (i = 0; i < n; i++) {
	      // clear workspace
	      x[i] = 0;
	      // no rows pivotal yet
	      pinv[i] = -1;
	      // no cols of L yet
	      lptr[i + 1] = 0;
	    }
	    // reset number of nonzero elements in L and U
	    lnz = 0;
	    unz = 0;
	    // compute L(:,k) and U(:,k)
	    for (var k = 0; k < n; k++) {
	      // update ptr
	      lptr[k] = lnz;
	      uptr[k] = unz;
	      // apply column permutations if needed
	      var col = q ? q[k] : k;
	      // solve triangular system, x = L\A(:,col)
	      var top = cs_spsolve(L, m, col, xi, x, pinv, 1);
	      // find pivot
	      var ipiv = -1;
	      var a = -1;
	      // loop xi[] from top -> n
	      for (p = top; p < n; p++) {
	        // x[i] is nonzero
	        i = xi[p];
	        // check row i is not yet pivotal
	        if (pinv[i] < 0) {
	          // absolute value of x[i]          
	          var xabs = abs(x[i]);
	          // check absoulte value is greater than pivot value
	          if (larger(xabs, a)) {
	            // largest pivot candidate so far
	            a = xabs;
	            ipiv = i;
	          }
	        }
	        else {
	          // x(i) is the entry U(pinv[i],k)
	          uindex[unz] = pinv[i];
	          uvalues[unz++] = x[i];
	        }
	      }
	      // validate we found a valid pivot
	      if (ipiv == -1 || a <= 0) 
	        return null;
	      // update actual pivot column, give preference to diagonal value
	      if (pinv[col] < 0 && largerEq(abs(x[col]), multiply(a, tol)))
	        ipiv = col;
	      // the chosen pivot
	      var pivot = x[ipiv];
	      // last entry in U(:,k) is U(k,k)
	      uindex[unz] = k;
	      uvalues[unz++] = pivot;
	      // ipiv is the kth pivot row
	      pinv[ipiv] = k;
	      // first entry in L(:,k) is L(k,k) = 1
	      lindex[lnz] = ipiv;
	      lvalues[lnz++] = 1;
	      // L(k+1:n,k) = x / pivot      
	      for (p = top; p < n; p++) {
	        // row
	        i = xi[p];
	        // check x(i) is an entry in L(:,k)
	        if (pinv[i] < 0) {
	          // save unpermuted row in L
	          lindex[lnz] = i;
	          // scale pivot column
	          lvalues[lnz++] = divideScalar(x[i], pivot);
	        }
	        // x[0..n-1] = 0 for next k
	        x[i] = 0;
	      }
	    }
	    // update ptr
	    lptr[n] = lnz;
	    uptr[n] = unz;
	    // fix row indices of L for final pinv
	    for (p = 0; p < lnz; p++) 
	      lindex[p] = pinv[lindex[p]];
	    // trim arrays
	    lvalues.splice(lnz, lvalues.length - lnz);
	    lindex.splice(lnz, lindex.length - lnz);
	    uvalues.splice(unz, uvalues.length - unz);
	    uindex.splice(unz, uindex.length - unz);    
	    // return LU factor
	    return {
	      L: L,
	      U: U,
	      pinv: pinv
	    };
	  };

	  return cs_lu;
	}

	exports.name = 'cs_lu';
	exports.path = 'sparse';
	exports.factory = factory;


/***/ },
/* 79 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var nearlyEqual = __webpack_require__(8).nearlyEqual;

	function factory (type, config, load, typed) {
	  
	  var matrix = load(__webpack_require__(23));

	  var algorithm03 = load(__webpack_require__(31));
	  var algorithm07 = load(__webpack_require__(66));
	  var algorithm12 = load(__webpack_require__(65));
	  var algorithm13 = load(__webpack_require__(35));
	  var algorithm14 = load(__webpack_require__(39));

	  var latex = __webpack_require__(26);

	  /**
	   * Test whether value x is larger or equal to y.
	   *
	   * The function returns true when x is larger than y or the relative
	   * difference between x and y is smaller than the configured epsilon. The
	   * function cannot be used to compare values smaller than approximately 2.22e-16.
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.largerEq(x, y)
	   *
	   * Examples:
	   *
	   *    math.larger(2, 1 + 1);         // returns false
	   *    math.largerEq(2, 1 + 1);       // returns true
	   *
	   * See also:
	   *
	   *    equal, unequal, smaller, smallerEq, larger, compare
	   *
	   * @param  {number | BigNumber | Fraction | boolean | Unit | string | Array | Matrix} x First value to compare
	   * @param  {number | BigNumber | Fraction | boolean | Unit | string | Array | Matrix} y Second value to compare
	   * @return {boolean | Array | Matrix} Returns true when the x is larger or equal to y, else returns false
	   */
	  var largerEq = typed('largerEq', {

	    'boolean, boolean': function (x, y) {
	      return x >= y;
	    },

	    'number, number': function (x, y) {
	      return x >= y || nearlyEqual(x, y, config.epsilon);
	    },

	    'BigNumber, BigNumber': function (x, y) {
	      return x.gte(y);
	    },

	    'Fraction, Fraction': function (x, y) {
	      return x.compare(y) !== -1;
	    },

	    'Complex, Complex': function () {
	      throw new TypeError('No ordering relation is defined for complex numbers');
	    },

	    'Unit, Unit': function (x, y) {
	      if (!x.equalBase(y)) {
	        throw new Error('Cannot compare units with different base');
	      }
	      return x.value >= y.value || nearlyEqual(x.value, y.value, config.epsilon);
	    },

	    'string, string': function (x, y) {
	      return x >= y;
	    },

	    'Matrix, Matrix': function (x, y) {
	      // result
	      var c;

	      // process matrix storage
	      switch (x.storage()) {
	        case 'sparse':
	          switch (y.storage()) {
	            case 'sparse':
	              // sparse + sparse
	              c = algorithm07(x, y, largerEq);
	              break;
	            default:
	              // sparse + dense
	              c = algorithm03(y, x, largerEq, true);
	              break;
	          }
	          break;
	        default:
	          switch (y.storage()) {
	            case 'sparse':
	              // dense + sparse
	              c = algorithm03(x, y, largerEq, false);
	              break;
	            default:
	              // dense + dense
	              c = algorithm13(x, y, largerEq);
	              break;
	          }
	          break;
	      }
	      return c;
	    },

	    'Array, Array': function (x, y) {
	      // use matrix implementation
	      return largerEq(matrix(x), matrix(y)).valueOf();
	    },

	    'Array, Matrix': function (x, y) {
	      // use matrix implementation
	      return largerEq(matrix(x), y);
	    },

	    'Matrix, Array': function (x, y) {
	      // use matrix implementation
	      return largerEq(x, matrix(y));
	    },

	    'Matrix, any': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (x.storage()) {
	        case 'sparse':
	          c = algorithm12(x, y, largerEq, false);
	          break;
	        default:
	          c = algorithm14(x, y, largerEq, false);
	          break;
	      }
	      return c;
	    },

	    'any, Matrix': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (y.storage()) {
	        case 'sparse':
	          c = algorithm12(y, x, largerEq, true);
	          break;
	        default:
	          c = algorithm14(y, x, largerEq, true);
	          break;
	      }
	      return c;
	    },

	    'Array, any': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(x), y, largerEq, false).valueOf();
	    },

	    'any, Array': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(y), x, largerEq, true).valueOf();
	    }
	  });

	  largerEq.toTex = '\\left(${args[0]}' + latex.operators['largerEq'] + '${args[1]}\\right)';

	  return largerEq;
	}

	exports.name = 'largerEq';
	exports.factory = factory;


/***/ },
/* 80 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	function factory (type, config, load) {

	  var divideScalar = load(__webpack_require__(51));
	  var multiply = load(__webpack_require__(40));
	  var subtract = load(__webpack_require__(25));

	  var cs_reach = load(__webpack_require__(81));

	  /**
	   * The function cs_spsolve() computes the solution to G * x = bk, where bk is the
	   * kth column of B. When lo is true, the function assumes G = L is lower triangular with the
	   * diagonal entry as the first entry in each column. When lo is true, the function assumes G = U 
	   * is upper triangular with the diagonal entry as the last entry in each column.
	   *
	   * @param {Matrix}  g               The G matrix
	   * @param {Matrix}  b               The B matrix
	   * @param {Number}  k               The kth column in B
	   * @param {Array}   xi              The nonzero pattern xi[top] .. xi[n - 1], an array of size = 2 * n
	   *                                  The first n entries is the nonzero pattern, the last n entries is the stack
	   * @param {Array}   x               The soluton to the linear system G * x = b
	   * @param {Array}   pinv            The inverse row permutation vector, must be null for L * x = b
	   * @param {boolean} lo              The lower (true) upper triangular (false) flag
	   *
	   * @return {Number}                 The index for the nonzero pattern
	   *
	   * Reference: http://faculty.cse.tamu.edu/davis/publications.html
	   */
	  var cs_spsolve = function (g, b, k, xi, x, pinv, lo) {
	    // g arrays
	    var gvalues = g._values;
	    var gindex = g._index;
	    var gptr = g._ptr;
	    var gsize = g._size;
	    // columns
	    var n = gsize[1];
	    // b arrays
	    var bvalues = b._values;
	    var bindex = b._index;
	    var bptr = b._ptr;
	    // vars
	    var p, p0, p1, q;
	    // xi[top..n-1] = cs_reach(B(:,k))
	    var top = cs_reach(g, b, k, xi, pinv);
	    // clear x
	    for (p = top; p < n; p++) 
	      x[xi[p]] = 0;
	    // scatter b
	    for (p0 = bptr[k], p1 = bptr[k + 1], p = p0; p < p1; p++) 
	      x[bindex[p]] = bvalues[p];
	    // loop columns
	    for (var px = top; px < n; px++) {
	      // x array index for px
	      var j = xi[px];
	      // apply permutation vector (U x = b), j maps to column J of G
	      var J = pinv ? pinv[j] : j;
	      // check column J is empty
	      if (J < 0)
	        continue;
	      // column value indeces in G, p0 <= p < p1
	      p0 = gptr[J];
	      p1 = gptr[J + 1];
	      // x(j) /= G(j,j)
	      x[j] = divideScalar(x[j], gvalues[lo ? p0 : (p1 - 1)]);
	      // first entry L(j,j)
	      p = lo ? (p0 + 1) : p0;
	      q = lo ? (p1) : (p1 - 1);
	      // loop
	      for ( ; p < q ; p++) {
	        // row
	        var i = gindex[p];
	        // x(i) -= G(i,j) * x(j)
	        x[i] = subtract(x[i], multiply(gvalues[p], x[j]));
	      }
	    }
	    // return top of stack
	    return top;
	  };
	  
	  return cs_spsolve;
	}

	exports.name = 'cs_spsolve';
	exports.path = 'sparse';
	exports.factory = factory;


/***/ },
/* 81 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	function factory (type, config, load) {

	  var cs_dfs = load(__webpack_require__(82));
	  var cs_marked = load(__webpack_require__(83));
	  var cs_mark = load(__webpack_require__(84));

	  /**
	   * The cs_reach function computes X = Reach(B), where B is the nonzero pattern of the n-by-1 
	   * sparse column of vector b. The function returns the set of nodes reachable from any node in B. The
	   * nonzero pattern xi of the solution x to the sparse linear system Lx=b is given by X=Reach(B).
	   *
	   * @param {Matrix}  g               The G matrix
	   * @param {Matrix}  b               The B matrix
	   * @param {Number}  k               The kth column in B
	   * @param {Array}   xi              The nonzero pattern xi[top] .. xi[n - 1], an array of size = 2 * n
	   *                                  The first n entries is the nonzero pattern, the last n entries is the stack
	   * @param {Array}   pinv            The inverse row permutation vector
	   *
	   * @return {Number}                 The index for the nonzero pattern
	   *
	   * Reference: http://faculty.cse.tamu.edu/davis/publications.html
	   */
	  var cs_reach = function (g, b, k, xi, pinv) {
	    // g arrays
	    var gptr = g._ptr;
	    var gsize = g._size;
	    // b arrays
	    var bindex = b._index;
	    var bptr = b._ptr;
	    // columns
	    var n = gsize[1];
	    // vars
	    var p, p0, p1;
	    // initialize top
	    var top = n;
	    // loop column indeces in B
	    for (p0 = bptr[k], p1 = bptr[k + 1], p = p0; p < p1; p++) {
	      // node i
	      var i = bindex[p];
	      // check node i is marked
	      if (!cs_marked(gptr, i)) {
	        // start a dfs at unmarked node i
	        top = cs_dfs(i, g, top, xi, pinv);
	      }
	    }
	    // loop columns from top -> n - 1
	    for (p = top; p < n; p++) {
	      // restore G
	      cs_mark(gptr, xi[p]);
	    }
	    return top;
	  };

	  return cs_reach;
	}

	exports.name = 'cs_reach';
	exports.path = 'sparse';
	exports.factory = factory;


/***/ },
/* 82 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	function factory (type, config, load) {

	  var cs_marked = load(__webpack_require__(83));
	  var cs_mark   = load(__webpack_require__(84));
	  var cs_unflip = load(__webpack_require__(85));

	  /**
	   * Depth-first search computes the nonzero pattern xi of the directed graph G (Matrix) starting
	   * at nodes in B (see cs_reach()).
	   *
	   * @param {Number}  j               The starting node for the DFS algorithm
	   * @param {Matrix}  g               The G matrix to search, ptr array modified, then restored
	   * @param {Number}  top             Start index in stack xi[top..n-1]
	   * @param {Number}  k               The kth column in B
	   * @param {Array}   xi              The nonzero pattern xi[top] .. xi[n - 1], an array of size = 2 * n
	   *                                  The first n entries is the nonzero pattern, the last n entries is the stack
	   * @param {Array}   pinv            The inverse row permutation vector, must be null for L * x = b
	   *
	   * @return {Number}                 New value of top
	   *
	   * Reference: http://faculty.cse.tamu.edu/davis/publications.html
	   */
	  var cs_dfs = function (j, g, top, xi, pinv) {
	    // g arrays
	    var index = g._index;
	    var ptr = g._ptr;
	    var size = g._size;
	    // columns
	    var n = size[1];
	    // vars
	    var i, p, p2;
	    // initialize head
	    var head = 0;
	    // initialize the recursion stack
	    xi[0] = j;
	    // loop
	    while (head >= 0) {
	      // get j from the top of the recursion stack
	      j = xi[head];
	      // apply permutation vector
	      var jnew = pinv ? pinv[j] : j;
	      // check node j is marked
	      if (!cs_marked(ptr, j)) {
	        // mark node j as visited
	        cs_mark(ptr, j);
	        // update stack (last n entries in xi)
	        xi[n + head] = jnew < 0 ? 0 : cs_unflip(ptr[jnew]);
	      }
	      // node j done if no unvisited neighbors
	      var done = 1;
	      // examine all neighbors of j, stack (last n entries in xi)
	      for (p = xi[n + head], p2 = jnew < 0 ? 0 : cs_unflip(ptr[jnew+1]); p < p2; p++) {
	        // consider neighbor node i
	        i = index[p];
	        // check we have visited node i, skip it
	        if (cs_marked(ptr, i)) 
	          continue;
	        // pause depth-first search of node j, update stack (last n entries in xi)
	        xi[n + head] = p;
	        // start dfs at node i
	        xi[++head] = i;
	        // node j is not done
	        done = 0;
	        // break, to start dfs(i)
	        break;
	      }
	      // check depth-first search at node j is done
	      if (done) {
	        // remove j from the recursion stack
	        head--;
	        // and place in the output stack
	        xi[--top] = j;
	      }
	    }
	    return top;    
	  };

	  return cs_dfs;
	}

	exports.name = 'cs_dfs';
	exports.path = 'sparse';
	exports.factory = factory;


/***/ },
/* 83 */
/***/ function(module, exports) {

	'use strict';

	function factory () {

	  /**
	   * Checks if the node at w[j] is marked
	   *
	   * @param {Array}   w               The array
	   * @param {Number}  j               The array index
	   *
	   * Reference: http://faculty.cse.tamu.edu/davis/publications.html
	   */
	  var cs_marked = function (w, j) {
	    // check node is marked
	    return w[j] < 0;
	  };

	  return cs_marked;
	}

	exports.name = 'cs_marked';
	exports.path = 'sparse';
	exports.factory = factory;


/***/ },
/* 84 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	function factory (type, config, load) {

	  var cs_flip = load(__webpack_require__(70));

	  /**
	   * Marks the node at w[j]
	   *
	   * @param {Array}   w               The array
	   * @param {Number}  j               The array index
	   *
	   * Reference: http://faculty.cse.tamu.edu/davis/publications.html
	   */
	  var cs_mark = function (w, j) {
	    // mark w[j]
	    w[j] = cs_flip(w [j]);
	  };

	  return cs_mark;
	}

	exports.name = 'cs_mark';
	exports.path = 'sparse';
	exports.factory = factory;


/***/ },
/* 85 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	function factory (type, config, load) {

	  var cs_flip = load(__webpack_require__(70));
	  
	  /**
	   * Flips the value if it is negative of returns the same value otherwise.
	   *
	   * @param {Number}  i               The value to flip
	   *
	   * Reference: http://faculty.cse.tamu.edu/davis/publications.html
	   */
	  var cs_unflip = function (i) {
	    // flip the value if it is negative
	    return i < 0 ? cs_flip(i) : i;
	  };

	  return cs_unflip;
	}

	exports.name = 'cs_unflip';
	exports.path = 'sparse';
	exports.factory = factory;


/***/ },
/* 86 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	function factory (type, config, load, typed) {

	  var matrix = load(__webpack_require__(23));
	  var divideScalar = load(__webpack_require__(51));
	  var multiplyScalar = load(__webpack_require__(41));
	  var subtract = load(__webpack_require__(25));
	  var equalScalar = load(__webpack_require__(33));

	  var solveValidation = load(__webpack_require__(87));

	  var DenseMatrix = type.DenseMatrix;

	  /** 
	   * Solves the linear equation system by forwards substitution. Matrix must be a lower triangular matrix.
	   *
	   * `L * x = b`
	   *
	   * Syntax:
	   *
	   *    math.lsolve(L, b);
	   *
	   * Examples:
	   *
	   *    var a = [[-2, 3], [2, 1]];
	   *    var b = [11, 9];
	   *    var x = lsolve(a, b);  // [[-5.5], [20]]
	   *
	   * See also:
	   *
	   *    lup, slu, usolve, lusolve
	   *
	   * @param {Matrix, Array} L       A N x N matrix or array (L)
	   * @param {Matrix, Array} b       A column vector with the b values
	   *
	   * @return {DenseMatrix | Array}  A column vector with the linear system solution (x)
	   */
	  var lsolve = typed('lsolve', {

	    'SparseMatrix, Array | Matrix': function (m, b) {
	      // process matrix
	      return _sparseForwardSubstitution(m, b);
	    },
	    
	    'DenseMatrix, Array | Matrix': function (m, b) {
	      // process matrix
	      return _denseForwardSubstitution(m, b);
	    },
	    
	    'Array, Array | Matrix': function (a, b) {
	      // create dense matrix from array
	      var m = matrix(a);
	      // use matrix implementation
	      var r = _denseForwardSubstitution(m, b);
	      // result
	      return r.valueOf();
	    }
	  });

	  var _denseForwardSubstitution = function (m, b) {
	    // validate matrix and vector, return copy of column vector b
	    b = solveValidation(m, b, true);
	    // column vector data
	    var bdata = b._data;
	    // rows & columns
	    var rows = m._size[0];
	    var columns = m._size[1];
	    // result
	    var x = [];
	    // data
	    var data = m._data;
	    // forward solve m * x = b, loop columns
	    for (var j = 0; j < columns; j++) {
	      // b[j]
	      var bj = bdata[j][0] || 0;
	      // x[j]
	      var xj;
	      // forward substitution (outer product) avoids inner looping when bj == 0
	      if (!equalScalar(bj, 0)) {
	        // value @ [j, j]
	        var vjj = data[j][j];
	        // check vjj
	        if (equalScalar(vjj, 0)) {
	          // system cannot be solved
	          throw new Error('Linear system cannot be solved since matrix is singular');
	        }
	        // calculate xj
	        xj = divideScalar(bj, vjj);
	        // loop rows
	        for (var i = j + 1; i < rows; i++) {
	          // update copy of b
	          bdata[i] = [subtract(bdata[i][0] || 0, multiplyScalar(xj, data[i][j]))];
	        }
	      }
	      else {
	        // zero @ j
	        xj = 0;
	      }
	      // update x
	      x[j] = [xj];
	    }
	    // return vector
	    return new DenseMatrix({
	      data: x,
	      size: [rows, 1]
	    });
	  };

	  var _sparseForwardSubstitution = function (m, b) {
	    // validate matrix and vector, return copy of column vector b
	    b = solveValidation(m, b, true);
	    // column vector data
	    var bdata = b._data;
	    // rows & columns
	    var rows = m._size[0];
	    var columns = m._size[1];
	    // matrix arrays
	    var values = m._values;
	    var index = m._index;
	    var ptr = m._ptr;
	    // vars
	    var i, k;
	    // result
	    var x = [];
	    // forward solve m * x = b, loop columns
	    for (var j = 0; j < columns; j++) {
	      // b[j]
	      var bj = bdata[j][0] || 0;
	      // forward substitution (outer product) avoids inner looping when bj == 0
	      if (!equalScalar(bj, 0)) {
	        // value @ [j, j]
	        var vjj = 0;
	        // last index in column
	        var l = ptr[j + 1];
	        // values in column, find value @ [j, j]
	        for (k = ptr[j]; k < l; k++) {
	          // row
	          i = index[k];
	          // check row (do not exist when i > j, rows are not sorted!)
	          if (i === j) {
	            // update vjj
	            vjj = values[k];
	            // exit loop
	            break;
	          }
	        }
	        // at this point we must have a value @ [j, j]
	        if (equalScalar(vjj, 0)) {
	          // system cannot be solved, there is no value @ [j, j]
	          throw new Error('Linear system cannot be solved since matrix is singular');
	        }
	        // calculate xj
	        var xj = divideScalar(bj, vjj);
	        // values in column, continue from last loop
	        for (; k < l; k++) {
	          // row
	          i = index[k];
	          // update copy of b
	          bdata[i] = [subtract(bdata[i][0] || 0, multiplyScalar(xj, values[k]))];
	        }
	        // update x
	        x[j] = [xj];
	      }
	      else {
	        // update x
	        x[j] = [0];
	      }
	    }
	    // return vector
	    return new DenseMatrix({
	      data: x,
	      size: [rows, 1]
	    });
	  };

	  return lsolve;
	}

	exports.name = 'lsolve';
	exports.factory = factory;


/***/ },
/* 87 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var util = __webpack_require__(36);

	var string = util.string;
	var array = util.array;

	var isArray = Array.isArray;

	function factory (type) {
	  
	  var DenseMatrix = type.DenseMatrix;

	  /**
	   * Validates matrix and column vector b for backward/forward substitution algorithms.
	   *
	   * @param {Matrix} m            An N x N matrix
	   * @param {Array | Matrix} b    A column vector
	   * @param {Boolean} copy        Return a copy of vector b
	   *
	   * @return {DenseMatrix}        Dense column vector b
	   */
	  var solveValidation = function (m, b, copy) {
	    // matrix size
	    var size = m.size();
	    // validate matrix dimensions
	    if (size.length !== 2)
	      throw new RangeError('Matrix must be two dimensional (size: ' + string.format(size) + ')');
	    // rows & columns
	    var rows = size[0];
	    var columns = size[1];    
	    // validate rows & columns
	    if (rows !== columns) 
	      throw new RangeError('Matrix must be square (size: ' + string.format(size) + ')');
	    // vars
	    var data, i, bdata;
	    // check b is matrix
	    if (b && b.isMatrix === true) {
	      // matrix size
	      var msize = b.size();
	      // vector
	      if (msize.length === 1) {
	        // check vector length
	        if (msize[0] !== rows)
	          throw new RangeError('Dimension mismatch. Matrix columns must match vector length.');
	        // create data array
	        data = [];
	        // matrix data (DenseMatrix)
	        bdata = b._data;
	        // loop b data
	        for (i = 0; i < rows; i++) {
	          // row array
	          data[i] = [bdata[i]];
	        }
	        // return Dense Matrix
	        return new DenseMatrix({
	          data: data,
	          size: [rows, 1],
	          datatype: b._datatype
	        });
	      }
	      // two dimensions
	      if (msize.length === 2) {
	        // array must be a column vector
	        if (msize[0] !== rows || msize[1] !== 1)
	          throw new RangeError('Dimension mismatch. Matrix columns must match vector length.');
	        // check matrix type
	        if (b.isDenseMatrix === true) {
	          // check a copy is needed
	          if (copy) {
	            // create data array
	            data = [];
	            // matrix data (DenseMatrix)
	            bdata = b._data;
	            // loop b data
	            for (i = 0; i < rows; i++) {
	              // row array
	              data[i] = [bdata[i][0]];
	            }
	            // return Dense Matrix
	            return new DenseMatrix({
	              data: data,
	              size: [rows, 1],
	              datatype: b._datatype
	            });
	          }
	          // b is already a column vector
	          return b;
	        }
	        // create data array
	        data = [];
	        for (i = 0; i < rows; i++)
	          data[i] = [0];
	        // sparse matrix arrays
	        var values = b._values;
	        var index = b._index;
	        var ptr = b._ptr;
	        // loop values in column 0
	        for (var k1 = ptr[1], k = ptr[0]; k < k1; k++) {
	          // row
	          i = index[k];
	          // add to data
	          data[i][0] = values[k]; 
	        }
	        // return Dense Matrix
	        return new DenseMatrix({
	          data: data,
	          size: [rows, 1],
	          datatype: b._datatype
	        });
	      }
	      // throw error
	      throw new RangeError('Dimension mismatch. Matrix columns must match vector length.');
	    }
	    // check b is array
	    if (isArray(b)) {
	      // size
	      var asize = array.size(b);
	      // check matrix dimensions, vector
	      if (asize.length === 1) {
	        // check vector length
	        if (asize[0] !== rows)
	          throw new RangeError('Dimension mismatch. Matrix columns must match vector length.');        
	        // create data array
	        data = [];
	        // loop b
	        for (i = 0; i < rows; i++) {
	          // row array
	          data[i] = [b[i]];
	        }
	        // return Dense Matrix
	        return new DenseMatrix({
	          data: data,
	          size: [rows, 1]
	        });
	      }
	      if (asize.length === 2) {
	        // array must be a column vector
	        if (asize[0] !== rows || asize[1] !== 1)
	          throw new RangeError('Dimension mismatch. Matrix columns must match vector length.');
	        // create data array
	        data = [];
	        // loop b data
	        for (i = 0; i < rows; i++) {
	          // row array
	          data[i] = [b[i][0]];
	        }
	        // return Dense Matrix
	        return new DenseMatrix({
	          data: data,
	          size: [rows, 1]
	        });
	      }
	      // throw error
	      throw new RangeError('Dimension mismatch. Matrix columns must match vector length.');      
	    }
	  };
	  
	  return solveValidation;
	}

	exports.factory = factory;

/***/ },
/* 88 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var isArray = Array.isArray;

	function factory (type, config, load, typed) {
	  
	  var matrix = load(__webpack_require__(23));
	  var lup = load(__webpack_require__(62));
	  var slu = load(__webpack_require__(67));
	  var cs_ipvec = load(__webpack_require__(89));

	  var solveValidation = load(__webpack_require__(87));

	  var usolve = load(__webpack_require__(90));
	  var lsolve = load(__webpack_require__(86));

	  /**
	   * Solves the linear system `A * x = b` where `A` is an [n x n] matrix and `b` is a [n] column vector.
	   *
	   * Syntax:
	   *
	   *    math.lusolve(A, b)     // returns column vector with the solution to the linear system A * x = b
	   *    math.lusolve(lup, b)   // returns column vector with the solution to the linear system A * x = b, lup = math.lup(A)
	   *
	   * Examples:
	   *
	   *    var m = [[1, 0, 0, 0], [0, 2, 0, 0], [0, 0, 3, 0], [0, 0, 0, 4]];
	   *
	   *    var x = math.lusolve(m, [-1, -1, -1, -1]);        // x = [[-1], [-0.5], [-1/3], [-0.25]]
	   *
	   *    var f = math.lup(m);
	   *    var x1 = math.lusolve(f, [-1, -1, -1, -1]);       // x1 = [[-1], [-0.5], [-1/3], [-0.25]]
	   *    var x2 = math.lusolve(f, [1, 2, 1, -1]);          // x2 = [[1], [1], [1/3], [-0.25]]
	   *
	   *    var a = [[-2, 3], [2, 1]];
	   *    var b = [11, 9];
	   *    var x = lusolve(a, b);  // [[-5.5], [20]]
	   *
	   * See also:
	   *
	   *    lup, slu, lsolve, usolve
	   *
	   * @param {Matrix | Array | Object} A      Invertible Matrix or the Matrix LU decomposition
	   * @param {Matrix | Array} b               Column Vector
	   * @param {number} [order]                 The Symbolic Ordering and Analysis order, see slu for details. Matrix must be a SparseMatrix
	   * @param {Number} [threshold]             Partial pivoting threshold (1 for partial pivoting), see slu for details. Matrix must be a SparseMatrix.
	   *
	   * @return {DenseMatrix | Array}           Column vector with the solution to the linear system A * x = b
	   */
	  var lusolve = typed('lusolve', {
	    
	    'Array, Array | Matrix': function (a, b) {
	      // convert a to matrix
	      a = matrix(a);
	      // matrix lup decomposition
	      var d = lup(a);
	      // solve
	      var x = _lusolve(d.L, d.U, d.p, null, b);
	      // convert result to array
	      return x.valueOf();
	    },
	    
	    'DenseMatrix, Array | Matrix': function (a, b) {
	      // matrix lup decomposition
	      var d = lup(a);
	      // solve
	      return _lusolve(d.L, d.U, d.p, null, b);
	    },
	    
	    'SparseMatrix, Array | Matrix': function (a, b) {
	      // matrix lup decomposition
	      var d = lup(a);
	      // solve
	      return _lusolve(d.L, d.U, d.p, null, b);
	    },
	    
	    'SparseMatrix, Array | Matrix, number, number': function (a, b, order, threshold) {
	      // matrix lu decomposition
	      var d = slu(a, order, threshold);
	      // solve
	      return _lusolve(d.L, d.U, d.p, d.q, b);
	    },

	    'Object, Array | Matrix': function (d, b) {
	      // solve
	      return _lusolve(d.L, d.U, d.p, d.q, b);
	    }
	  });
	  
	  var _toMatrix = function (a) {
	    // check it is a matrix
	    if (a && a.isMatrix === true)
	      return a;
	    // check array
	    if (isArray(a))
	      return matrix(a);
	    // throw
	    throw new TypeError('Invalid Matrix LU decomposition');
	  };
	  
	  var _lusolve = function (l, u, p, q, b) {
	    // verify L, U, P
	    l = _toMatrix(l);
	    u = _toMatrix(u);
	    // validate matrix and vector
	    b = solveValidation(l, b, false);
	    // apply row permutations if needed (b is a DenseMatrix)
	    if (p)
	      b._data = cs_ipvec(p, b._data);
	    // use forward substitution to resolve L * y = b
	    var y = lsolve(l, b);
	    // use backward substitution to resolve U * x = y
	    var x = usolve(u, y);
	    // apply column permutations if needed (x is a DenseMatrix)
	    if (q)
	      x._data = cs_ipvec(q, x._data);
	    // return solution
	    return x;
	  };

	  return lusolve;
	}

	exports.name = 'lusolve';
	exports.factory = factory;


/***/ },
/* 89 */
/***/ function(module, exports) {

	'use strict';

	function factory () {

	  /**
	   * Permutes a vector; x = P'b. In MATLAB notation, x(p)=b.
	   *
	   * @param {Array} p           The permutation vector of length n. null value denotes identity
	   * @param {Array} b           The input vector
	   *
	   * @return {Array}            The output vector x = P'b
	   */
	  var cs_ipvec = function (p, b, n) {
	    // vars 
	    var k;
	    var n = p.length;
	    var x = [];
	    // check permutation vector was provided, p = null denotes identity
	    if (p) {
	      // loop vector
	      for (k = 0; k < n; k++) {
	        // apply permutation
	        x[p[k]] = b[k];
	      }
	    }
	    else {
	      // loop vector
	      for (k = 0; k < n; k++) {
	        // x[i] = b[i]
	        x[k] = b[k];
	      }
	    }
	    return x;
	  };

	  return cs_ipvec;
	}

	exports.name = 'cs_ipvec';
	exports.path = 'sparse';
	exports.factory = factory;


/***/ },
/* 90 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	function factory (type, config, load, typed) {

	  var matrix = load(__webpack_require__(23));
	  var divideScalar = load(__webpack_require__(51));
	  var multiplyScalar = load(__webpack_require__(41));
	  var subtract = load(__webpack_require__(25));
	  var equalScalar = load(__webpack_require__(33));

	  var solveValidation = load(__webpack_require__(87));
	  
	  var DenseMatrix = type.DenseMatrix;

	  /**
	   * Solves the linear equation system by backward substitution. Matrix must be an upper triangular matrix.
	   *
	   * `U * x = b`
	   *
	   * Syntax:
	   *
	   *    math.usolve(U, b);
	   *
	   * Examples:
	   *
	   *    var a = [[-2, 3], [2, 1]];
	   *    var b = [11, 9];
	   *    var x = usolve(a, b);  // [[8], [9]]
	   *
	   * See also:
	   *
	   *    lup, slu, usolve, lusolve
	   *
	   * @param {Matrix, Array} U       A N x N matrix or array (U)
	   * @param {Matrix, Array} b       A column vector with the b values
	   *
	   * @return {DenseMatrix | Array}  A column vector with the linear system solution (x)
	   */
	  var usolve = typed('usolve', {
	    
	    'SparseMatrix, Array | Matrix': function (m, b) {
	      // process matrix
	      return _sparseBackwardSubstitution(m, b);
	    },

	    'DenseMatrix, Array | Matrix': function (m, b) {
	      // process matrix
	      return _denseBackwardSubstitution(m, b);
	    },

	    'Array, Array | Matrix': function (a, b) {
	      // create dense matrix from array
	      var m = matrix(a);
	      // use matrix implementation
	      var r = _denseBackwardSubstitution(m, b);
	      // result
	      return r.valueOf();
	    }
	  });

	  var _denseBackwardSubstitution = function (m, b) {
	    // validate matrix and vector, return copy of column vector b
	    b = solveValidation(m, b, true);
	    // column vector data
	    var bdata = b._data;
	    // rows & columns
	    var rows = m._size[0];
	    var columns = m._size[1];
	    // result
	    var x = [];
	    // arrays
	    var data = m._data;
	    // backward solve m * x = b, loop columns (backwards)
	    for (var j = columns - 1; j >= 0 ; j--) {
	      // b[j]
	      var bj = bdata[j][0] || 0;
	      // x[j]
	      var xj;
	      // backward substitution (outer product) avoids inner looping when bj == 0
	      if (!equalScalar(bj, 0)) {
	        // value @ [j, j]
	        var vjj = data[j][j];
	        // check vjj
	        if (equalScalar(vjj, 0)) {
	          // system cannot be solved
	          throw new Error('Linear system cannot be solved since matrix is singular');
	        }
	        // calculate xj
	        xj = divideScalar(bj, vjj);        
	        // loop rows
	        for (var i = j - 1; i >= 0; i--) {
	          // update copy of b
	          bdata[i] = [subtract(bdata[i][0] || 0, multiplyScalar(xj, data[i][j]))];
	        }
	      }
	      else {
	        // zero value @ j
	        xj = 0;
	      }
	      // update x
	      x[j] = [xj];
	    }
	    // return column vector
	    return new DenseMatrix({
	      data: x,
	      size: [rows, 1]
	    });
	  };
	  
	  var _sparseBackwardSubstitution = function (m, b) {
	    // validate matrix and vector, return copy of column vector b
	    b = solveValidation(m, b, true);
	    // column vector data
	    var bdata = b._data;
	    // rows & columns
	    var rows = m._size[0];
	    var columns = m._size[1];
	    // matrix arrays
	    var values = m._values;
	    var index = m._index;
	    var ptr = m._ptr;
	    // vars
	    var i, k;
	    // result
	    var x = [];
	    // backward solve m * x = b, loop columns (backwards)
	    for (var j = columns - 1; j >= 0 ; j--) {
	      // b[j]
	      var bj = bdata[j][0] || 0;
	      // backward substitution (outer product) avoids inner looping when bj == 0
	      if (!equalScalar(bj, 0)) {
	        // value @ [j, j]
	        var vjj = 0;
	        // first & last indeces in column
	        var f = ptr[j];
	        var l = ptr[j + 1];
	        // values in column, find value @ [j, j], loop backwards
	        for (k = l - 1; k >= f; k--) {
	          // row
	          i = index[k];
	          // check row
	          if (i === j) {
	            // update vjj
	            vjj = values[k];
	          }
	          else if (i < j) {
	            // exit loop
	            break;
	          }
	        }
	        // at this point we must have a value @ [j, j]
	        if (equalScalar(vjj, 0)) {
	          // system cannot be solved, there is no value @ [j, j]
	          throw new Error('Linear system cannot be solved since matrix is singular');
	        }
	        // calculate xj
	        var xj = divideScalar(bj, vjj);
	        // values in column, continue from last loop
	        for (; k >= f; k--) {
	          // row
	          i = index[k];
	          // update copy of b
	          bdata[i] = [subtract(bdata[i][0], multiplyScalar(xj, values[k]))];
	        }
	        // update x
	        x[j] = [xj];
	      }
	      else {
	        // update x
	        x[j] = [0];
	      }
	    }
	    // return vector
	    return new DenseMatrix({
	      data: x,
	      size: [rows, 1]
	    });
	  };
	  
	  return usolve;
	}

	exports.name = 'usolve';
	exports.factory = factory;


/***/ },
/* 91 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = [
	  __webpack_require__(63),
	  __webpack_require__(44),
	  __webpack_require__(27),
	  __webpack_require__(92),
	  __webpack_require__(93),
	  __webpack_require__(94),
	  __webpack_require__(95),
	  __webpack_require__(97),
	  __webpack_require__(99),
	  __webpack_require__(101),
	  __webpack_require__(103),
	  __webpack_require__(104),
	  __webpack_require__(105),
	  __webpack_require__(106),
	  __webpack_require__(102),
	  __webpack_require__(109),
	  __webpack_require__(110),
	  __webpack_require__(40),
	  __webpack_require__(111),
	  __webpack_require__(114),
	  __webpack_require__(100),
	  __webpack_require__(115),
	  __webpack_require__(116),
	  __webpack_require__(112),
	  __webpack_require__(117),
	  __webpack_require__(25),
	  __webpack_require__(28),
	  __webpack_require__(118),
	  __webpack_require__(119)
	];


/***/ },
/* 92 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);

	function factory (type, config, load, typed) {
	  /**
	   * Round a value towards plus infinity
	   * If `x` is complex, both real and imaginary part are rounded towards plus infinity.
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.ceil(x)
	   *
	   * Examples:
	   *
	   *    math.ceil(3.2);               // returns number 4
	   *    math.ceil(3.8);               // returns number 4
	   *    math.ceil(-4.2);              // returns number -4
	   *    math.ceil(-4.7);              // returns number -4
	   *
	   *    var c = math.complex(3.2, -2.7);
	   *    math.ceil(c);                 // returns Complex 4 - 2i
	   *
	   *    math.ceil([3.2, 3.8, -4.7]);  // returns Array [4, 4, -4]
	   *
	   * See also:
	   *
	   *    floor, fix, round
	   *
	   * @param  {number | BigNumber | Fraction | Complex | Array | Matrix} x  Number to be rounded
	   * @return {number | BigNumber | Fraction | Complex | Array | Matrix} Rounded value
	   */
	  var ceil = typed('ceil', {
	    'number': Math.ceil,

	    'Complex': function (x) {
	      return new type.Complex(
	          Math.ceil(x.re),
	          Math.ceil(x.im)
	      );
	    },

	    'BigNumber': function (x) {
	      return x.ceil();
	    },

	    'Fraction': function (x) {
	      return x.ceil();
	    },

	    'Array | Matrix': function (x) {
	      // deep map collection, skip zeros since ceil(0) = 0
	      return deepMap(x, ceil, true);
	    }
	  });

	  ceil.toTex = '\\left\\lceil${args[0]}\\right\\rceil';

	  return ceil;
	}

	exports.name = 'ceil';
	exports.factory = factory;


/***/ },
/* 93 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);

	function factory (type, config, load, typed) {
	  var complexMultiply = typed.find(load(__webpack_require__(41)), ['Complex,Complex']);

	  /**
	   * Compute the cube of a value, `x * x * x`.
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.cube(x)
	   *
	   * Examples:
	   *
	   *    math.cube(2);            // returns number 8
	   *    math.pow(2, 3);          // returns number 8
	   *    math.cube(4);            // returns number 64
	   *    4 * 4 * 4;               // returns number 64
	   *
	   *    math.cube([1, 2, 3, 4]); // returns Array [1, 8, 27, 64]
	   *
	   * See also:
	   *
	   *    multiply, square, pow
	   *
	   * @param  {number | BigNumber | Fraction | Complex | Array | Matrix} x  Number for which to calculate the cube
	   * @return {number | BigNumber | Fraction | Complex | Array | Matrix} Cube of x
	   */
	  var cube = typed('cube', {
	    'number': function (x) {
	      return x * x * x;
	    },

	    'Complex': function (x) {
	      return complexMultiply(complexMultiply(x, x), x);
	    },

	    'BigNumber': function (x) {
	      return x.times(x).times(x);
	    },

	    'Fraction': function (x) {
	      return x.mul(x).mul(x);
	    },

	    'Array | Matrix': function (x) {
	      // deep map collection, skip zeros since cube(0) = 0
	      return deepMap(x, cube, true);
	    }
	  });

	  cube.toTex = '\\left(${args[0]}\\right)^3';

	  return cube;
	}

	exports.name = 'cube';
	exports.factory = factory;


/***/ },
/* 94 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var extend = __webpack_require__(5).extend;

	function factory (type, config, load, typed) {

	  var divideScalar = load(__webpack_require__(51));
	  var multiply     = load(__webpack_require__(40));
	  var inv          = load(__webpack_require__(50));
	  var matrix       = load(__webpack_require__(23));

	  var algorithm11 = load(__webpack_require__(42));
	  var algorithm14 = load(__webpack_require__(39));
	  
	  /**
	   * Divide two values, `x / y`.
	   * To divide matrices, `x` is multiplied with the inverse of `y`: `x * inv(y)`.
	   *
	   * Syntax:
	   *
	   *    math.divide(x, y)
	   *
	   * Examples:
	   *
	   *    math.divide(2, 3);            // returns number 0.6666666666666666
	   *
	   *    var a = math.complex(5, 14);
	   *    var b = math.complex(4, 1);
	   *    math.divide(a, b);            // returns Complex 2 + 3i
	   *
	   *    var c = [[7, -6], [13, -4]];
	   *    var d = [[1, 2], [4, 3]];
	   *    math.divide(c, d);            // returns Array [[-9, 4], [-11, 6]]
	   *
	   *    var e = math.unit('18 km');
	   *    math.divide(e, 4.5);          // returns Unit 4 km
	   *
	   * See also:
	   *
	   *    multiply
	   *
	   * @param  {number | BigNumber | Fraction | Complex | Unit | Array | Matrix} x   Numerator
	   * @param  {number | BigNumber | Fraction | Complex | Array | Matrix} y          Denominator
	   * @return {number | BigNumber | Fraction | Complex | Unit | Array | Matrix}                      Quotient, `x / y`
	   */
	  var divide = typed('divide', extend({
	    // we extend the signatures of divideScalar with signatures dealing with matrices

	    'Array | Matrix, Array | Matrix': function (x, y) {
	      // TODO: implement matrix right division using pseudo inverse
	      // http://www.mathworks.nl/help/matlab/ref/mrdivide.html
	      // http://www.gnu.org/software/octave/doc/interpreter/Arithmetic-Ops.html
	      // http://stackoverflow.com/questions/12263932/how-does-gnu-octave-matrix-division-work-getting-unexpected-behaviour
	      return multiply(x, inv(y));
	    },

	    'Matrix, any': function (x, y) {
	      // result
	      var c;

	      // process storage format
	      switch (x.storage()) {
	        case 'sparse':
	          c = algorithm11(x, y, divideScalar, false);
	          break;
	        case 'dense':
	          c = algorithm14(x, y, divideScalar, false);
	          break;
	      }
	      return c;
	    },
	    
	    'Array, any': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(x), y, divideScalar, false).valueOf();
	    },

	    'any, Array | Matrix': function (x, y) {
	      return multiply(x, inv(y));
	    }
	  }, divideScalar.signatures));

	  divide.toTex = '\\frac{${args[0]}}{${args[1]}}';

	  return divide;
	}

	exports.name = 'divide';
	exports.factory = factory;


/***/ },
/* 95 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	function factory (type, config, load, typed) {

	  var matrix = load(__webpack_require__(23));
	  var divideScalar = load(__webpack_require__(51));
	  var latex = __webpack_require__(26);
	  
	  var algorithm02 = load(__webpack_require__(96));
	  var algorithm03 = load(__webpack_require__(31));
	  var algorithm07 = load(__webpack_require__(66));
	  var algorithm11 = load(__webpack_require__(42));
	  var algorithm12 = load(__webpack_require__(65));
	  var algorithm13 = load(__webpack_require__(35));
	  var algorithm14 = load(__webpack_require__(39));

	  /**
	   * Divide two matrices element wise. The function accepts both matrices and
	   * scalar values.
	   *
	   * Syntax:
	   *
	   *    math.dotDivide(x, y)
	   *
	   * Examples:
	   *
	   *    math.dotDivide(2, 4);   // returns 0.5
	   *
	   *    a = [[9, 5], [6, 1]];
	   *    b = [[3, 2], [5, 2]];
	   *
	   *    math.dotDivide(a, b);   // returns [[3, 2.5], [1.2, 0.5]]
	   *    math.divide(a, b);      // returns [[1.75, 0.75], [-1.75, 2.25]]
	   *
	   * See also:
	   *
	   *    divide, multiply, dotMultiply
	   *
	   * @param  {number | BigNumber | Fraction | Complex | Unit | Array | Matrix} x Numerator
	   * @param  {number | BigNumber | Fraction | Complex | Unit | Array | Matrix} y Denominator
	   * @return {number | BigNumber | Fraction | Complex | Unit | Array | Matrix}                    Quotient, `x ./ y`
	   */
	  var dotDivide = typed('dotDivide', {
	    
	    'any, any': divideScalar,
	    
	    'Matrix, Matrix': function (x, y) {
	      // result
	      var c;

	      // process matrix storage
	      switch (x.storage()) {
	        case 'sparse':
	          switch (y.storage()) {
	            case 'sparse':
	              // sparse ./ sparse
	              c = algorithm07(x, y, divideScalar, false);
	              break;
	            default:
	              // sparse ./ dense
	              c = algorithm02(y, x, divideScalar, true);
	              break;
	          }
	          break;
	        default:
	          switch (y.storage()) {
	            case 'sparse':
	              // dense ./ sparse
	              c = algorithm03(x, y, divideScalar, false);
	              break;
	            default:
	              // dense ./ dense
	              c = algorithm13(x, y, divideScalar);
	              break;
	          }
	          break;
	      }
	      return c;
	    },

	    'Array, Array': function (x, y) {
	      // use matrix implementation
	      return dotDivide(matrix(x), matrix(y)).valueOf();
	    },

	    'Array, Matrix': function (x, y) {
	      // use matrix implementation
	      return dotDivide(matrix(x), y);
	    },

	    'Matrix, Array': function (x, y) {
	      // use matrix implementation
	      return dotDivide(x, matrix(y));
	    },

	    'Matrix, any': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (x.storage()) {
	        case 'sparse':
	          c = algorithm11(x, y, divideScalar, false);
	          break;
	        default:
	          c = algorithm14(x, y, divideScalar, false);
	          break;
	      }
	      return c;
	    },

	    'any, Matrix': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (y.storage()) {
	        case 'sparse':
	          c = algorithm12(y, x, divideScalar, true);
	          break;
	        default:
	          c = algorithm14(y, x, divideScalar, true);
	          break;
	      }
	      return c;
	    },

	    'Array, any': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(x), y, divideScalar, false).valueOf();
	    },

	    'any, Array': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(y), x, divideScalar, true).valueOf();
	    }
	  });

	  dotDivide.toTex = '\\left(${args[0]}' + latex.operators['dotDivide'] + '${args[1]}\\right)';
	  
	  return dotDivide;
	}

	exports.name = 'dotDivide';
	exports.factory = factory;


/***/ },
/* 96 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var DimensionError = __webpack_require__(22);

	function factory (type, config, load, typed) {

	  var equalScalar = load(__webpack_require__(33));

	  var SparseMatrix = type.SparseMatrix;

	  /**
	   * Iterates over SparseMatrix nonzero items and invokes the callback function f(Dij, Sij). 
	   * Callback function invoked NNZ times (number of nonzero items in SparseMatrix).
	   *
	   *
	   *          ┌  f(Dij, Sij)  ; S(i,j) !== 0
	   * C(i,j) = ┤
	   *          └  0            ; otherwise
	   *
	   *
	   * @param {Matrix}   denseMatrix       The DenseMatrix instance (D)
	   * @param {Matrix}   sparseMatrix      The SparseMatrix instance (S)
	   * @param {Function} callback          The f(Dij,Sij) operation to invoke, where Dij = DenseMatrix(i,j) and Sij = SparseMatrix(i,j)
	   * @param {boolean}  inverse           A true value indicates callback should be invoked f(Sij,Dij)
	   *
	   * @return {Matrix}                    SparseMatrix (C)
	   *
	   * see https://github.com/josdejong/mathjs/pull/346#issuecomment-97477571
	   */
	  var algorithm02 = function (denseMatrix, sparseMatrix, callback, inverse) {
	    // dense matrix arrays
	    var adata = denseMatrix._data;
	    var asize = denseMatrix._size;
	    var adt = denseMatrix._datatype;
	    // sparse matrix arrays
	    var bvalues = sparseMatrix._values;
	    var bindex = sparseMatrix._index;
	    var bptr = sparseMatrix._ptr;
	    var bsize = sparseMatrix._size;
	    var bdt = sparseMatrix._datatype;

	    // validate dimensions
	    if (asize.length !== bsize.length)
	      throw new DimensionError(asize.length, bsize.length);

	    // check rows & columns
	    if (asize[0] !== bsize[0] || asize[1] !== bsize[1])
	      throw new RangeError('Dimension mismatch. Matrix A (' + asize + ') must match Matrix B (' + bsize + ')');

	    // sparse matrix cannot be a Pattern matrix
	    if (!bvalues)
	      throw new Error('Cannot perform operation on Dense Matrix and Pattern Sparse Matrix');

	    // rows & columns
	    var rows = asize[0];
	    var columns = asize[1];
	    
	    // datatype
	    var dt;
	    // equal signature to use
	    var eq = equalScalar;
	    // zero value
	    var zero = 0;
	    // callback signature to use
	    var cf = callback;

	    // process data types
	    if (typeof adt === 'string' && adt === bdt) {
	      // datatype
	      dt = adt;
	      // find signature that matches (dt, dt)
	      eq = typed.find(equalScalar, [dt, dt]);
	      // convert 0 to the same datatype
	      zero = typed.convert(0, dt);
	      // callback
	      cf = typed.find(callback, [dt, dt]);
	    }

	    // result (SparseMatrix)
	    var cvalues = [];
	    var cindex = [];
	    var cptr = [];

	    // loop columns in b
	    for (var j = 0; j < columns; j++) {
	      // update cptr
	      cptr[j] = cindex.length;
	      // values in column j
	      for (var k0 = bptr[j], k1 = bptr[j + 1], k = k0; k < k1; k++) {
	        // row
	        var i = bindex[k];
	        // update C(i,j)
	        var cij = inverse ? cf(bvalues[k], adata[i][j]) : cf(adata[i][j], bvalues[k]);
	        // check for nonzero
	        if (!eq(cij, zero)) {
	          // push i & v
	          cindex.push(i);
	          cvalues.push(cij);
	        }
	      }
	    }
	    // update cptr
	    cptr[columns] = cindex.length;

	    // return sparse matrix
	    return new SparseMatrix({
	      values: cvalues,
	      index: cindex,
	      ptr: cptr,
	      size: [rows, columns],
	      datatype: dt
	    });
	  };
	  
	  return algorithm02;
	}

	exports.name = 'algorithm02';
	exports.factory = factory;


/***/ },
/* 97 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	function factory (type, config, load, typed) {

	  var matrix = load(__webpack_require__(23));
	  var multiplyScalar = load(__webpack_require__(41));
	  var latex = __webpack_require__(26);

	  var algorithm02 = load(__webpack_require__(96));
	  var algorithm09 = load(__webpack_require__(98));
	  var algorithm11 = load(__webpack_require__(42));
	  var algorithm13 = load(__webpack_require__(35));
	  var algorithm14 = load(__webpack_require__(39));

	  /**
	   * Multiply two matrices element wise. The function accepts both matrices and
	   * scalar values.
	   *
	   * Syntax:
	   *
	   *    math.dotMultiply(x, y)
	   *
	   * Examples:
	   *
	   *    math.dotMultiply(2, 4); // returns 8
	   *
	   *    a = [[9, 5], [6, 1]];
	   *    b = [[3, 2], [5, 2]];
	   *
	   *    math.dotMultiply(a, b); // returns [[27, 10], [30, 2]]
	   *    math.multiply(a, b);    // returns [[52, 28], [23, 14]]
	   *
	   * See also:
	   *
	   *    multiply, divide, dotDivide
	   *
	   * @param  {number | BigNumber | Fraction | Complex | Unit | Array | Matrix} x Left hand value
	   * @param  {number | BigNumber | Fraction | Complex | Unit | Array | Matrix} y Right hand value
	   * @return {number | BigNumber | Fraction | Complex | Unit | Array | Matrix}                    Multiplication of `x` and `y`
	   */
	  var dotMultiply = typed('dotMultiply', {
	    
	    'any, any': multiplyScalar,
	    
	    'Matrix, Matrix': function (x, y) {
	      // result
	      var c;

	      // process matrix storage
	      switch (x.storage()) {
	        case 'sparse':
	          switch (y.storage()) {
	            case 'sparse':
	              // sparse .* sparse
	              c = algorithm09(x, y, multiplyScalar, false);
	              break;
	            default:
	              // sparse .* dense
	              c = algorithm02(y, x, multiplyScalar, true);
	              break;
	          }
	          break;
	        default:
	          switch (y.storage()) {
	            case 'sparse':
	              // dense .* sparse
	              c = algorithm02(x, y, multiplyScalar, false);
	              break;
	            default:
	              // dense .* dense
	              c = algorithm13(x, y, multiplyScalar);
	              break;
	          }
	          break;
	      }
	      return c;
	    },
	    
	    'Array, Array': function (x, y) {
	      // use matrix implementation
	      return dotMultiply(matrix(x), matrix(y)).valueOf();
	    },
	    
	    'Array, Matrix': function (x, y) {
	      // use matrix implementation
	      return dotMultiply(matrix(x), y);
	    },

	    'Matrix, Array': function (x, y) {
	      // use matrix implementation
	      return dotMultiply(x, matrix(y));
	    },

	    'Matrix, any': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (x.storage()) {
	        case 'sparse':
	          c = algorithm11(x, y, multiplyScalar, false);
	          break;
	        default:
	          c = algorithm14(x, y, multiplyScalar, false);
	          break;
	      }
	      return c;
	    },

	    'any, Matrix': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (y.storage()) {
	        case 'sparse':
	          c = algorithm11(y, x, multiplyScalar, true);
	          break;
	        default:
	          c = algorithm14(y, x, multiplyScalar, true);
	          break;
	      }
	      return c;
	    },

	    'Array, any': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(x), y, multiplyScalar, false).valueOf();
	    },

	    'any, Array': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(y), x, multiplyScalar, true).valueOf();
	    }
	  });

	  dotMultiply.toTex = '\\left(${args[0]}' + latex.operators['dotMultiply'] + '${args[1]}\\right)';
	  
	  return dotMultiply;
	}

	exports.name = 'dotMultiply';
	exports.factory = factory;


/***/ },
/* 98 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var DimensionError = __webpack_require__(22);

	function factory (type, config, load, typed) {

	  var equalScalar = load(__webpack_require__(33));

	  var SparseMatrix = type.SparseMatrix;

	  /**
	   * Iterates over SparseMatrix A and invokes the callback function f(Aij, Bij). 
	   * Callback function invoked NZA times, number of nonzero elements in A.
	   *
	   *
	   *          ┌  f(Aij, Bij)  ; A(i,j) !== 0
	   * C(i,j) = ┤  
	   *          └  0            ; otherwise
	   *
	   *
	   * @param {Matrix}   a                 The SparseMatrix instance (A)
	   * @param {Matrix}   b                 The SparseMatrix instance (B)
	   * @param {Function} callback          The f(Aij,Bij) operation to invoke
	   *
	   * @return {Matrix}                    SparseMatrix (C)
	   *
	   * see https://github.com/josdejong/mathjs/pull/346#issuecomment-97620294
	   */
	  var algorithm09 = function (a, b, callback) {
	    // sparse matrix arrays
	    var avalues = a._values;
	    var aindex = a._index;
	    var aptr = a._ptr;
	    var asize = a._size;
	    var adt = a._datatype;
	    // sparse matrix arrays
	    var bvalues = b._values;
	    var bindex = b._index;
	    var bptr = b._ptr;
	    var bsize = b._size;
	    var bdt = b._datatype;

	    // validate dimensions
	    if (asize.length !== bsize.length)
	      throw new DimensionError(asize.length, bsize.length);

	    // check rows & columns
	    if (asize[0] !== bsize[0] || asize[1] !== bsize[1])
	      throw new RangeError('Dimension mismatch. Matrix A (' + asize + ') must match Matrix B (' + bsize + ')');

	    // rows & columns
	    var rows = asize[0];
	    var columns = asize[1];

	    // datatype
	    var dt;
	    // equal signature to use
	    var eq = equalScalar;
	    // zero value
	    var zero = 0;
	    // callback signature to use
	    var cf = callback;

	    // process data types
	    if (typeof adt === 'string' && adt === bdt) {
	      // datatype
	      dt = adt;
	      // find signature that matches (dt, dt)
	      eq = typed.find(equalScalar, [dt, dt]);
	      // convert 0 to the same datatype
	      zero = typed.convert(0, dt);
	      // callback
	      cf = typed.find(callback, [dt, dt]);
	    }

	    // result arrays
	    var cvalues = avalues && bvalues ? [] : undefined;
	    var cindex = [];
	    var cptr = [];
	    // matrix
	    var c = new SparseMatrix({
	      values: cvalues,
	      index: cindex,
	      ptr: cptr,
	      size: [rows, columns],
	      datatype: dt
	    });

	    // workspaces
	    var x = cvalues ? [] : undefined;
	    // marks indicating we have a value in x for a given column
	    var w = [];

	    // vars
	    var i, j, k, k0, k1;
	    
	    // loop columns
	    for (j = 0; j < columns; j++) {
	      // update cptr
	      cptr[j] = cindex.length;
	      // column mark
	      var mark = j + 1;
	      // check we need to process values
	      if (x) {
	        // loop B(:,j)
	        for (k0 = bptr[j], k1 = bptr[j + 1], k = k0; k < k1; k++) {
	          // row
	          i = bindex[k];
	          // update workspace
	          w[i] = mark;
	          x[i] = bvalues[k];
	        }
	      }
	      // loop A(:,j)
	      for (k0 = aptr[j], k1 = aptr[j + 1], k = k0; k < k1; k++) {
	        // row
	        i = aindex[k];
	        // check we need to process values
	        if (x) {
	          // b value @ i,j
	          var vb = w[i] === mark ? x[i] : zero;
	          // invoke f
	          var vc = cf(avalues[k], vb);
	          // check zero value
	          if (!eq(vc, zero)) {
	            // push index
	            cindex.push(i);
	            // push value
	            cvalues.push(vc);
	          }
	        }
	        else {
	          // push index
	          cindex.push(i);
	        }
	      }
	    }
	    // update cptr
	    cptr[columns] = cindex.length;

	    // return sparse matrix
	    return c;
	  };

	  return algorithm09;
	}

	exports.name = 'algorithm09';
	exports.factory = factory;


/***/ },
/* 99 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	function factory (type, config, load, typed) {

	  var matrix = load(__webpack_require__(23));
	  var pow = load(__webpack_require__(100));
	  var latex = __webpack_require__(26);

	  var algorithm03 = load(__webpack_require__(31));
	  var algorithm07 = load(__webpack_require__(66));
	  var algorithm11 = load(__webpack_require__(42));
	  var algorithm12 = load(__webpack_require__(65));
	  var algorithm13 = load(__webpack_require__(35));
	  var algorithm14 = load(__webpack_require__(39));

	  /**
	   * Calculates the power of x to y element wise.
	   *
	   * Syntax:
	   *
	   *    math.dotPow(x, y)
	   *
	   * Examples:
	   *
	   *    math.dotPow(2, 3);            // returns number 8
	   *
	   *    var a = [[1, 2], [4, 3]];
	   *    math.dotPow(a, 2);            // returns Array [[1, 4], [16, 9]]
	   *    math.pow(a, 2);               // returns Array [[9, 8], [16, 17]]
	   *
	   * See also:
	   *
	   *    pow, sqrt, multiply
	   *
	   * @param  {number | BigNumber | Complex | Unit | Array | Matrix} x  The base
	   * @param  {number | BigNumber | Complex | Unit | Array | Matrix} y  The exponent
	   * @return {number | BigNumber | Complex | Unit | Array | Matrix}                     The value of `x` to the power `y`
	   */
	  var dotPow = typed('dotPow', {
	    
	    'any, any': pow,
	    
	    'Matrix, Matrix': function (x, y) {
	      // result
	      var c;

	      // process matrix storage
	      switch (x.storage()) {
	        case 'sparse':
	          switch (y.storage()) {
	            case 'sparse':
	              // sparse .^ sparse
	              c = algorithm07(x, y, pow, false);
	              break;
	            default:
	              // sparse .^ dense
	              c = algorithm03(y, x, pow, true);
	              break;
	          }
	          break;
	        default:
	          switch (y.storage()) {
	            case 'sparse':
	              // dense .^ sparse
	              c = algorithm03(x, y, pow, false);
	              break;
	            default:
	              // dense .^ dense
	              c = algorithm13(x, y, pow);
	              break;
	          }
	          break;
	      }
	      return c;
	    },

	    'Array, Array': function (x, y) {
	      // use matrix implementation
	      return dotPow(matrix(x), matrix(y)).valueOf();
	    },

	    'Array, Matrix': function (x, y) {
	      // use matrix implementation
	      return dotPow(matrix(x), y);
	    },

	    'Matrix, Array': function (x, y) {
	      // use matrix implementation
	      return dotPow(x, matrix(y));
	    },

	    'Matrix, any': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (x.storage()) {
	        case 'sparse':
	          c = algorithm11(x, y, dotPow, false);
	          break;
	        default:
	          c = algorithm14(x, y, dotPow, false);
	          break;
	      }
	      return c;
	    },

	    'any, Matrix': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (y.storage()) {
	        case 'sparse':
	          c = algorithm12(y, x, dotPow, true);
	          break;
	        default:
	          c = algorithm14(y, x, dotPow, true);
	          break;
	      }
	      return c;
	    },

	    'Array, any': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(x), y, dotPow, false).valueOf();
	    },

	    'any, Array': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(y), x, dotPow, true).valueOf();
	    }
	  });

	  dotPow.toTex = '\\left(${args[0]}' + latex.operators['dotPow'] + '${args[1]}\\right)';
	  
	  return dotPow;
	}

	exports.name = 'dotPow';
	exports.factory = factory;


/***/ },
/* 100 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var isInteger = __webpack_require__(8).isInteger;
	var size = __webpack_require__(18).size;

	function factory (type, config, load, typed) {
	  var latex = __webpack_require__(26);
	  var exp = load(__webpack_require__(101));
	  var eye = load(__webpack_require__(48));
	  var log = load(__webpack_require__(102));
	  var multiply = load(__webpack_require__(40));
	  var matrix = load(__webpack_require__(23));

	  /**
	   * Calculates the power of x to y, `x ^ y`.
	   * Matrix exponentiation is supported for square matrices `x`, and positive
	   * integer exponents `y`.
	   *
	   * Syntax:
	   *
	   *    math.pow(x, y)
	   *
	   * Examples:
	   *
	   *    math.pow(2, 3);               // returns number 8
	   *
	   *    var a = math.complex(2, 3);
	   *    math.pow(a, 2)                // returns Complex -5 + 12i
	   *
	   *    var b = [[1, 2], [4, 3]];
	   *    math.pow(b, 2);               // returns Array [[9, 8], [16, 17]]
	   *
	   * See also:
	   *
	   *    multiply, sqrt
	   *
	   * @param  {number | BigNumber | Complex | Array | Matrix} x  The base
	   * @param  {number | BigNumber | Complex} y                   The exponent
	   * @return {number | BigNumber | Complex | Array | Matrix} The value of `x` to the power `y`
	   */
	  var pow = typed('pow', {
	    'number, number': _pow,

	    'Complex, Complex': _powComplex,

	    'BigNumber, BigNumber': function (x, y) {
	      if (y.isInteger() || x >= 0 || config.predictable) {
	        return x.pow(y);
	      }
	      else {
	        return _powComplex(new type.Complex(x.toNumber(), 0), new type.Complex(y.toNumber(), 0));
	      }
	    },

	    'Fraction, Fraction': function (x, y) {
	      if (y.d !== 1) {
	        if (config.predictable) {
	          throw new Error('Function pow does not support non-integer exponents for fractions.');
	        }
	        else {
	          return _pow(x.valueOf(), y.valueOf());
	        }
	      }
	      else {
	        return x.pow(y);
	     }
	    },

	    'Array, number': _powArray,

	    'Array, BigNumber': function (x, y) {
	      return _powArray(x, y.toNumber());
	    },

	    'Matrix, number': _powMatrix,

	    'Matrix, BigNumber': function (x, y) {
	      return _powMatrix(x, y.toNumber());
	    }
	  });

	  /**
	   * Calculates the power of x to y, x^y, for two numbers.
	   * @param {number} x
	   * @param {number} y
	   * @return {number | Complex} res
	   * @private
	   */
	  function _pow(x, y) {
	    if (isInteger(y) || x >= 0 || config.predictable) {
	      return Math.pow(x, y);
	    }
	    else {
	      return _powComplex(new type.Complex(x, 0), new type.Complex(y, 0));
	    }
	  }

	  /**
	   * Calculates the power of x to y, x^y, for two complex numbers.
	   * @param {Complex} x
	   * @param {Complex} y
	   * @return {Complex} res
	   * @private
	   */
	  function _powComplex (x, y) {
	    // complex computation
	    // x^y = exp(log(x)*y) = exp((abs(x)+i*arg(x))*y)
	    // TODO: we can optimize this as we know x and y are Complex
	    //   expComplex      = exp.signatures['Complex,Complex']
	    //   multiplyComplex = multiply.signatures['Complex,Complex']
	    //   logComplex      = log.signatures['Complex,Complex']
	    //   return expComplex(multiplyComplex(logComplex(x), y));
	    return exp(multiply(log(x), y));
	  }

	  /**
	   * Calculate the power of a 2d array
	   * @param {Array} x     must be a 2 dimensional, square matrix
	   * @param {number} y    a positive, integer value
	   * @returns {Array}
	   * @private
	   */
	  function _powArray(x, y) {
	    if (!isInteger(y) || y < 0) {
	      throw new TypeError('For A^b, b must be a positive integer (value is ' + y + ')');
	    }
	    // verify that A is a 2 dimensional square matrix
	    var s = size(x);
	    if (s.length != 2) {
	      throw new Error('For A^b, A must be 2 dimensional (A has ' + s.length + ' dimensions)');
	    }
	    if (s[0] != s[1]) {
	      throw new Error('For A^b, A must be square (size is ' + s[0] + 'x' + s[1] + ')');
	    }

	    var res = eye(s[0]).valueOf();
	    var px = x;
	    while (y >= 1) {
	      if ((y & 1) == 1) {
	        res = multiply(px, res);
	      }
	      y >>= 1;
	      px = multiply(px, px);
	    }
	    return res;
	  }

	  /**
	   * Calculate the power of a 2d matrix
	   * @param {Matrix} x     must be a 2 dimensional, square matrix
	   * @param {number} y    a positive, integer value
	   * @returns {Matrix}
	   * @private
	   */
	  function _powMatrix (x, y) {
	    return matrix(_powArray(x.valueOf(), y));
	  }

	  pow.toTex = '\\left(${args[0]}\\right)' + latex.operators['pow'] + '{${args[1]}}';

	  return pow;
	}

	exports.name = 'pow';
	exports.factory = factory;


/***/ },
/* 101 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);

	function factory (type, config, load, typed) {
	  /**
	   * Calculate the exponent of a value.
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.exp(x)
	   *
	   * Examples:
	   *
	   *    math.exp(2);                  // returns number 7.3890560989306495
	   *    math.pow(math.e, 2);          // returns number 7.3890560989306495
	   *    math.log(math.exp(2));        // returns number 2
	   *
	   *    math.exp([1, 2, 3]);
	   *    // returns Array [
	   *    //   2.718281828459045,
	   *    //   7.3890560989306495,
	   *    //   20.085536923187668
	   *    // ]
	   *
	   * See also:
	   *
	   *    log, pow
	   *
	   * @param {number | BigNumber | Complex | Array | Matrix} x  A number or matrix to exponentiate
	   * @return {number | BigNumber | Complex | Array | Matrix} Exponent of `x`
	   */
	  var exp = typed('exp', {
	    'number': Math.exp,

	    'Complex': function (x) {
	      var r = Math.exp(x.re);
	      return new type.Complex(
	          r * Math.cos(x.im),
	          r * Math.sin(x.im)
	      );
	    },

	    'BigNumber': function (x) {
	      return x.exp();
	    },

	    'Array | Matrix': function (x) {
	      // TODO: exp(sparse) should return a dense matrix since exp(0)==1
	      return deepMap(x, exp);
	    }
	  });

	  exp.toTex = '\\exp\\left(${args[0]}\\right)';

	  return exp;
	}

	exports.name = 'exp';
	exports.factory = factory;


/***/ },
/* 102 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);

	function factory (type, config, load, typed) {
	  var divideScalar = load(__webpack_require__(51));

	  /**
	   * Calculate the logarithm of a value.
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.log(x)
	   *    math.log(x, base)
	   *
	   * Examples:
	   *
	   *    math.log(3.5);                  // returns 1.252762968495368
	   *    math.exp(math.log(2.4));        // returns 2.4
	   *
	   *    math.pow(10, 4);                // returns 10000
	   *    math.log(10000, 10);            // returns 4
	   *    math.log(10000) / math.log(10); // returns 4
	   *
	   *    math.log(1024, 2);              // returns 10
	   *    math.pow(2, 10);                // returns 1024
	   *
	   * See also:
	   *
	   *    exp, log10
	   *
	   * @param {number | BigNumber | Complex | Array | Matrix} x
	   *            Value for which to calculate the logarithm.
	   * @param {number | BigNumber | Complex} [base=e]
	   *            Optional base for the logarithm. If not provided, the natural
	   *            logarithm of `x` is calculated.
	   * @return {number | BigNumber | Complex | Array | Matrix}
	   *            Returns the logarithm of `x`
	   */
	  var log = typed('log', {
	    'number': _logNumber,

	    'Complex': _logComplex,

	    'BigNumber': function (x) {
	      if (!x.isNegative() || config.predictable) {
	        return x.ln();
	      }
	      else {
	        // downgrade to number, return Complex valued result
	        return _logComplex(new type.Complex(x.toNumber(), 0));
	      }
	    },

	    'Array | Matrix': function (x) {
	      return deepMap(x, log);
	    },

	    'any, any': function (x, base) {
	      // calculate logarithm for a specified base, log(x, base)
	      return divideScalar(log(x), log(base));
	    }
	  });

	  /**
	   * Calculate the natural logarithm of a number
	   * @param {number} x
	   * @returns {number | Complex}
	   * @private
	   */
	  function _logNumber(x) {
	    if (x >= 0 || config.predictable) {
	      return Math.log(x);
	    }
	    else {
	      // negative value -> complex value computation
	      return log(new type.Complex(x, 0));
	    }
	  }

	  /**
	   * Calculate the natural logarithm of a complex number
	   * @param {Complex} x
	   * @returns {Complex}
	   * @private
	   */
	  function _logComplex(x) {
	    return new type.Complex (
	        Math.log(Math.sqrt(x.re * x.re + x.im * x.im)),
	        Math.atan2(x.im, x.re)
	    );
	  }

	  log.toTex = {
	    1: '\\ln\\left(${args[0]}\\right)',
	    2: '\\log_{${args[1]}}\\left(${args[0]}\\right)'
	  };

	  return log;
	}

	exports.name = 'log';
	exports.factory = factory;


/***/ },
/* 103 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);

	function factory (type, config, load, typed) {
	  /**
	   * Round a value towards zero.
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.fix(x)
	   *
	   * Examples:
	   *
	   *    math.fix(3.2);                // returns number 3
	   *    math.fix(3.8);                // returns number 3
	   *    math.fix(-4.2);               // returns number -4
	   *    math.fix(-4.7);               // returns number -4
	   *
	   *    var c = math.complex(3.2, -2.7);
	   *    math.fix(c);                  // returns Complex 3 - 2i
	   *
	   *    math.fix([3.2, 3.8, -4.7]);   // returns Array [3, 3, -4]
	   *
	   * See also:
	   *
	   *    ceil, floor, round
	   *
	   * @param {number | BigNumber | Fraction | Complex | Array | Matrix} x Number to be rounded
	   * @return {number | BigNumber | Fraction | Complex | Array | Matrix}            Rounded value
	   */
	  var fix = typed('fix', {
	    'number': function (x) {
	      return (x > 0) ? Math.floor(x) : Math.ceil(x);
	    },

	    'Complex': function (x) {
	      return new type.Complex(
	          (x.re > 0) ? Math.floor(x.re) : Math.ceil(x.re),
	          (x.im > 0) ? Math.floor(x.im) : Math.ceil(x.im)
	      );
	    },

	    'BigNumber': function (x) {
	      return x.isNegative() ? x.ceil() : x.floor();
	    },

	    'Fraction': function (x) {
	      return x.s < 0 ? x.ceil() : x.floor();
	    },

	    'Array | Matrix': function (x) {
	      // deep map collection, skip zeros since fix(0) = 0
	      return deepMap(x, fix, true);
	    }
	  });

	  fix.toTex = '\\mathrm{${name}}\\left(${args}\\right)';

	  return fix;
	}

	exports.name = 'fix';
	exports.factory = factory;


/***/ },
/* 104 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);

	function factory (type, config, load, typed) {
	  /**
	   * Round a value towards minus infinity.
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.floor(x)
	   *
	   * Examples:
	   *
	   *    math.floor(3.2);              // returns number 3
	   *    math.floor(3.8);              // returns number 3
	   *    math.floor(-4.2);             // returns number -5
	   *    math.floor(-4.7);             // returns number -5
	   *
	   *    var c = math.complex(3.2, -2.7);
	   *    math.floor(c);                // returns Complex 3 - 3i
	   *
	   *    math.floor([3.2, 3.8, -4.7]); // returns Array [3, 3, -5]
	   *
	   * See also:
	   *
	   *    ceil, fix, round
	   *
	   * @param  {number | BigNumber | Fraction | Complex | Array | Matrix} x  Number to be rounded
	   * @return {number | BigNumber | Fraction | Complex | Array | Matrix} Rounded value
	   */
	  var floor = typed('floor', {
	    'number': Math.floor,

	    'Complex': function (x) {
	      return new type.Complex(
	          Math.floor(x.re),
	          Math.floor(x.im)
	      );
	    },

	    'BigNumber': function (x) {
	      return x.floor();
	    },

	    'Fraction': function (x) {
	      return x.floor();
	    },

	    'Array | Matrix': function (x) {
	      // deep map collection, skip zeros since floor(0) = 0
	      return deepMap(x, floor, true);
	    }
	  });

	  floor.toTex = '\\left\\lfloor${args[0]}\\right\\rfloor';

	  return floor;
	}

	exports.name = 'floor';
	exports.factory = factory;


/***/ },
/* 105 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var isInteger = __webpack_require__(8).isInteger;

	function factory (type, config, load, typed) {

	  var matrix = load(__webpack_require__(23));

	  var algorithm01 = load(__webpack_require__(30));
	  var algorithm04 = load(__webpack_require__(45));
	  var algorithm10 = load(__webpack_require__(34));
	  var algorithm13 = load(__webpack_require__(35));
	  var algorithm14 = load(__webpack_require__(39));

	  /**
	   * Calculate the greatest common divisor for two or more values or arrays.
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.gcd(a, b)
	   *    math.gcd(a, b, c, ...)
	   *
	   * Examples:
	   *
	   *    math.gcd(8, 12);              // returns 4
	   *    math.gcd(-4, 6);              // returns 2
	   *    math.gcd(25, 15, -10);        // returns 5
	   *
	   *    math.gcd([8, -4], [12, 6]);   // returns [4, 2]
	   *
	   * See also:
	   *
	   *    lcm, xgcd
	   *
	   * @param {... number | BigNumber | Fraction | Array | Matrix} args  Two or more integer numbers
	   * @return {number | BigNumber | Fraction | Array | Matrix}                           The greatest common divisor
	   */
	  var gcd = typed('gcd', {

	    'number, number': _gcd,

	    'BigNumber, BigNumber': _gcdBigNumber,

	    'Fraction, Fraction': function (x, y) {
	      return x.gcd(y);
	    },

	    'Matrix, Matrix': function (x, y) {
	      // result
	      var c;

	      // process matrix storage
	      switch (x.storage()) {
	        case 'sparse':
	          switch (y.storage()) {
	            case 'sparse':
	              // sparse + sparse
	              c = algorithm04(x, y, gcd);
	              break;
	            default:
	              // sparse + dense
	              c = algorithm01(y, x, gcd, true);
	              break;
	          }
	          break;
	        default:
	          switch (y.storage()) {
	            case 'sparse':
	              // dense + sparse
	              c = algorithm01(x, y, gcd, false);
	              break;
	            default:
	              // dense + dense
	              c = algorithm13(x, y, gcd);
	              break;
	          }
	          break;
	      }
	      return c;
	    },

	    'Array, Array': function (x, y) {
	      // use matrix implementation
	      return gcd(matrix(x), matrix(y)).valueOf();
	    },

	    'Array, Matrix': function (x, y) {
	      // use matrix implementation
	      return gcd(matrix(x), y);
	    },

	    'Matrix, Array': function (x, y) {
	      // use matrix implementation
	      return gcd(x, matrix(y));
	    },
	    
	    'Matrix, number | BigNumber': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (x.storage()) {
	        case 'sparse':
	          c = algorithm10(x, y, gcd, false);
	          break;
	        default:
	          c = algorithm14(x, y, gcd, false);
	          break;
	      }
	      return c;
	    },

	    'number | BigNumber, Matrix': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (y.storage()) {
	        case 'sparse':
	          c = algorithm10(y, x, gcd, true);
	          break;
	        default:
	          c = algorithm14(y, x, gcd, true);
	          break;
	      }
	      return c;
	    },

	    'Array, number | BigNumber': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(x), y, gcd, false).valueOf();
	    },

	    'number | BigNumber, Array': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(y), x, gcd, true).valueOf();
	    },

	    // TODO: need a smarter notation here
	    'Array | Matrix | number | BigNumber, Array | Matrix | number | BigNumber, ...Array | Matrix | number | BigNumber': function (a, b, args) {
	      var res = gcd(a, b);
	      for (var i = 0; i < args.length; i++) {
	        res = gcd(res, args[i]);
	      }
	      return res;
	    }
	  });

	  gcd.toTex = '\\gcd\\left(${args}\\right)';

	  return gcd;

	  /**
	   * Calculate gcd for BigNumbers
	   * @param {BigNumber} a
	   * @param {BigNumber} b
	   * @returns {BigNumber} Returns greatest common denominator of a and b
	   * @private
	   */
	  function _gcdBigNumber(a, b) {
	    if (!a.isInt() || !b.isInt()) {
	      throw new Error('Parameters in function gcd must be integer numbers');
	    }

	    // http://en.wikipedia.org/wiki/Euclidean_algorithm
	    var zero = new type.BigNumber(0);
	    while (!b.isZero()) {
	      var r = a.mod(b);
	      a = b;
	      b = r;
	    }
	    return a.lt(zero) ? a.neg() : a;
	  }
	}

	/**
	 * Calculate gcd for numbers
	 * @param {number} a
	 * @param {number} b
	 * @returns {number} Returns the greatest common denominator of a and b
	 * @private
	 */
	function _gcd(a, b) {
	  if (!isInteger(a) || !isInteger(b)) {
	    throw new Error('Parameters in function gcd must be integer numbers');
	  }

	  // http://en.wikipedia.org/wiki/Euclidean_algorithm
	  var r;
	  while (b != 0) {
	    r = a % b;
	    a = b;
	    b = r;
	  }
	  return (a < 0) ? -a : a;
	}

	exports.name = 'gcd';
	exports.factory = factory;


/***/ },
/* 106 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var isInteger = __webpack_require__(8).isInteger;

	function factory (type, config, load, typed) {
	  
	  var matrix = load(__webpack_require__(23));

	  var algorithm02 = load(__webpack_require__(96));
	  var algorithm06 = load(__webpack_require__(107));
	  var algorithm11 = load(__webpack_require__(42));
	  var algorithm13 = load(__webpack_require__(35));
	  var algorithm14 = load(__webpack_require__(39));

	  /**
	   * Calculate the least common multiple for two or more values or arrays.
	   *
	   * lcm is defined as:
	   *
	   *     lcm(a, b) = abs(a * b) / gcd(a, b)
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.lcm(a, b)
	   *    math.lcm(a, b, c, ...)
	   *
	   * Examples:
	   *
	   *    math.lcm(4, 6);               // returns 12
	   *    math.lcm(6, 21);              // returns 42
	   *    math.lcm(6, 21, 5);           // returns 210
	   *
	   *    math.lcm([4, 6], [6, 21]);    // returns [12, 42]
	   *
	   * See also:
	   *
	   *    gcd, xgcd
	   *
	   * @param {... number | BigNumber | Array | Matrix} args  Two or more integer numbers
	   * @return {number | BigNumber | Array | Matrix}                           The least common multiple
	   */
	  var lcm = typed('lcm', {
	    'number, number': _lcm,

	    'BigNumber, BigNumber': _lcmBigNumber,

	    // TODO: implement support for Fraction

	    'Matrix, Matrix': function (x, y) {
	      // result
	      var c;

	      // process matrix storage
	      switch (x.storage()) {
	        case 'sparse':
	          switch (y.storage()) {
	            case 'sparse':
	              // sparse + sparse
	              c = algorithm06(x, y, lcm);
	              break;
	            default:
	              // sparse + dense
	              c = algorithm02(y, x, lcm, true);
	              break;
	          }
	          break;
	        default:
	          switch (y.storage()) {
	            case 'sparse':
	              // dense + sparse
	              c = algorithm02(x, y, lcm, false);
	              break;
	            default:
	              // dense + dense
	              c = algorithm13(x, y, lcm);
	              break;
	          }
	          break;
	      }
	      return c;
	    },

	    'Array, Array': function (x, y) {
	      // use matrix implementation
	      return lcm(matrix(x), matrix(y)).valueOf();
	    },

	    'Array, Matrix': function (x, y) {
	      // use matrix implementation
	      return lcm(matrix(x), y);
	    },

	    'Matrix, Array': function (x, y) {
	      // use matrix implementation
	      return lcm(x, matrix(y));
	    },

	    'Matrix, number | BigNumber': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (x.storage()) {
	        case 'sparse':
	          c = algorithm11(x, y, lcm, false);
	          break;
	        default:
	          c = algorithm14(x, y, lcm, false);
	          break;
	      }
	      return c;
	    },

	    'number | BigNumber, Matrix': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (y.storage()) {
	        case 'sparse':
	          c = algorithm11(y, x, lcm, true);
	          break;
	        default:
	          c = algorithm14(y, x, lcm, true);
	          break;
	      }
	      return c;
	    },

	    'Array, number | BigNumber': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(x), y, lcm, false).valueOf();
	    },

	    'number | BigNumber, Array': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(y), x, lcm, true).valueOf();
	    },

	    // TODO: need a smarter notation here
	    'Array | Matrix | number | BigNumber, Array | Matrix | number | BigNumber, ...Array | Matrix | number | BigNumber': function (a, b, args) {
	      var res = lcm(a, b);
	      for (var i = 0; i < args.length; i++) {
	        res = lcm(res, args[i]);
	      }
	      return res;
	    }
	  });

	  lcm.toTex = '\\mathrm{${name}}\\left(${args}\\right)';

	  return lcm;

	  /**
	   * Calculate lcm for two BigNumbers
	   * @param {BigNumber} a
	   * @param {BigNumber} b
	   * @returns {BigNumber} Returns the least common multiple of a and b
	   * @private
	   */
	  function _lcmBigNumber(a, b) {
	    if (!a.isInt() || !b.isInt()) {
	      throw new Error('Parameters in function lcm must be integer numbers');
	    }

	    if (a.isZero() || b.isZero()) {
	      return new type.BigNumber(0);
	    }

	    // http://en.wikipedia.org/wiki/Euclidean_algorithm
	    // evaluate lcm here inline to reduce overhead
	    var prod = a.times(b);
	    while (!b.isZero()) {
	      var t = b;
	      b = a.mod(t);
	      a = t;
	    }
	    return prod.div(a).abs();
	  }
	}

	/**
	 * Calculate lcm for two numbers
	 * @param {number} a
	 * @param {number} b
	 * @returns {number} Returns the least common multiple of a and b
	 * @private
	 */
	function _lcm (a, b) {
	  if (!isInteger(a) || !isInteger(b)) {
	    throw new Error('Parameters in function lcm must be integer numbers');
	  }

	  if (a == 0 || b == 0) {
	    return 0;
	  }

	  // http://en.wikipedia.org/wiki/Euclidean_algorithm
	  // evaluate lcm here inline to reduce overhead
	  var t;
	  var prod = a * b;
	  while (b != 0) {
	    t = b;
	    b = a % t;
	    a = t;
	  }
	  return Math.abs(prod / a);
	}

	exports.name = 'lcm';
	exports.factory = factory;


/***/ },
/* 107 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var scatter = __webpack_require__(108);
	var DimensionError = __webpack_require__(22);

	function factory (type, config, load, typed) {

	  var equalScalar = load(__webpack_require__(33));

	  var SparseMatrix = type.SparseMatrix;

	  /**
	   * Iterates over SparseMatrix A and SparseMatrix B nonzero items and invokes the callback function f(Aij, Bij). 
	   * Callback function invoked (Anz U Bnz) times, where Anz and Bnz are the nonzero elements in both matrices.
	   *
	   *
	   *          ┌  f(Aij, Bij)  ; A(i,j) !== 0 && B(i,j) !== 0
	   * C(i,j) = ┤  
	   *          └  0            ; otherwise
	   *
	   *
	   * @param {Matrix}   a                 The SparseMatrix instance (A)
	   * @param {Matrix}   b                 The SparseMatrix instance (B)
	   * @param {Function} callback          The f(Aij,Bij) operation to invoke
	   *
	   * @return {Matrix}                    SparseMatrix (C)
	   *
	   * see https://github.com/josdejong/mathjs/pull/346#issuecomment-97620294
	   */
	  var algorithm06 = function (a, b, callback) {
	    // sparse matrix arrays
	    var avalues = a._values;
	    var asize = a._size;
	    var adt = a._datatype;
	    // sparse matrix arrays
	    var bvalues = b._values;
	    var bsize = b._size;
	    var bdt = b._datatype;

	    // validate dimensions
	    if (asize.length !== bsize.length)
	      throw new DimensionError(asize.length, bsize.length);

	    // check rows & columns
	    if (asize[0] !== bsize[0] || asize[1] !== bsize[1])
	      throw new RangeError('Dimension mismatch. Matrix A (' + asize + ') must match Matrix B (' + bsize + ')');

	    // rows & columns
	    var rows = asize[0];
	    var columns = asize[1];

	    // datatype
	    var dt;
	    // equal signature to use
	    var eq = equalScalar;
	    // zero value
	    var zero = 0;
	    // callback signature to use
	    var cf = callback;

	    // process data types
	    if (typeof adt === 'string' && adt === bdt) {
	      // datatype
	      dt = adt;
	      // find signature that matches (dt, dt)
	      eq = typed.find(equalScalar, [dt, dt]);
	      // convert 0 to the same datatype
	      zero = typed.convert(0, dt);
	      // callback
	      cf = typed.find(callback, [dt, dt]);
	    }

	    // result arrays
	    var cvalues = avalues && bvalues ? [] : undefined;
	    var cindex = [];
	    var cptr = [];
	    // matrix
	    var c = new SparseMatrix({
	      values: cvalues,
	      index: cindex,
	      ptr: cptr,
	      size: [rows, columns],
	      datatype: dt
	    });

	    // workspaces
	    var x = cvalues ? [] : undefined;
	    // marks indicating we have a value in x for a given column
	    var w = [];
	    // marks indicating value in a given row has been updated
	    var u = [];

	    // loop columns
	    for (var j = 0; j < columns; j++) {
	      // update cptr
	      cptr[j] = cindex.length;
	      // columns mark
	      var mark = j + 1;
	      // scatter the values of A(:,j) into workspace
	      scatter(a, j, w, x, u, mark, c, cf);
	      // scatter the values of B(:,j) into workspace
	      scatter(b, j, w, x, u, mark, c, cf);
	      // check we need to process values (non pattern matrix)
	      if (x) {
	        // initialize first index in j
	        var k = cptr[j];
	        // loop index in j
	        while (k < cindex.length) {
	          // row
	          var i = cindex[k];
	          // check function was invoked on current row (Aij !=0 && Bij != 0)
	          if (u[i] === mark) {
	            // value @ i
	            var v = x[i];
	            // check for zero value
	            if (!eq(v, zero)) {
	              // push value
	              cvalues.push(v);
	              // increment pointer
	              k++;
	            }
	            else {
	              // remove value @ i, do not increment pointer
	              cindex.splice(k, 1);
	            }
	          }
	          else {
	            // remove value @ i, do not increment pointer
	            cindex.splice(k, 1);
	          }
	        }
	      }
	      else {
	        // initialize first index in j
	        var p = cptr[j];
	        // loop index in j
	        while (p < cindex.length) {
	          // row
	          var r = cindex[p];
	          // check function was invoked on current row (Aij !=0 && Bij != 0)
	          if (u[r] !== mark) {
	            // remove value @ i, do not increment pointer
	            cindex.splice(p, 1);
	          }
	          else {
	            // increment pointer
	            p++;
	          }
	        }
	      }
	    }
	    // update cptr
	    cptr[columns] = cindex.length;

	    // return sparse matrix
	    return c;
	  };
	  
	  return algorithm06;
	}

	exports.name = 'algorithm06';
	exports.factory = factory;


/***/ },
/* 108 */
/***/ function(module, exports) {

	'use strict';

	module.exports = function scatter(a, j, w, x, u, mark, c, f, inverse, update, value) {
	  // a arrays
	  var avalues = a._values;
	  var aindex = a._index;
	  var aptr = a._ptr;
	  // c arrays
	  var cindex = c._index;

	  // vars
	  var k, k0, k1, i;

	  // check we need to process values (pattern matrix)
	  if (x) {
	    // values in j
	    for (k0 = aptr[j], k1 = aptr[j + 1], k = k0; k < k1; k++) {
	      // row
	      i = aindex[k];
	      // check value exists in current j
	      if (w[i] !== mark) {
	        // i is new entry in j
	        w[i] = mark;
	        // add i to pattern of C
	        cindex.push(i);
	        // x(i) = A, check we need to call function this time
	        if (update) {
	          // copy value to workspace calling callback function
	          x[i] = inverse ? f(avalues[k], value) : f(value, avalues[k]);
	          // function was called on current row
	          u[i] = mark;
	        }
	        else {
	          // copy value to workspace
	          x[i] = avalues[k];
	        }
	      }
	      else {
	        // i exists in C already
	        x[i] = inverse ? f(avalues[k], x[i]) : f(x[i], avalues[k]);
	        // function was called on current row
	        u[i] = mark;
	      }
	    }
	  }
	  else {
	    // values in j
	    for (k0 = aptr[j], k1 = aptr[j + 1], k = k0; k < k1; k++) {
	      // row
	      i = aindex[k];
	      // check value exists in current j
	      if (w[i] !== mark) {
	        // i is new entry in j
	        w[i] = mark;
	        // add i to pattern of C
	        cindex.push(i);
	      }
	      else {
	        // indicate function was called on current row
	        u[i] = mark;
	      }
	    }
	  }
	};


/***/ },
/* 109 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);

	function factory (type, config, load, typed) {
	  /**
	   * Calculate the 10-base of a value. This is the same as calculating `log(x, 10)`.
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.log10(x)
	   *
	   * Examples:
	   *
	   *    math.log10(0.00001);            // returns -5
	   *    math.log10(10000);              // returns 4
	   *    math.log(10000) / math.log(10); // returns 4
	   *    math.pow(10, 4);                // returns 10000
	   *
	   * See also:
	   *
	   *    exp, log
	   *
	   * @param {number | BigNumber | Complex | Array | Matrix} x
	   *            Value for which to calculate the logarithm.
	   * @return {number | BigNumber | Complex | Array | Matrix}
	   *            Returns the 10-base logarithm of `x`
	   */
	  var log10 = typed('log10', {
	    'number': function (x) {
	      if (x >= 0 || config.predictable) {
	        return Math.log(x) / Math.LN10;
	      }
	      else {
	        // negative value -> complex value computation
	        return log10(new type.Complex(x, 0));
	      }
	    },

	    'Complex': _log10Complex,

	    'BigNumber': function (x) {
	      if (!x.isNegative() || config.predictable) {
	        return x.log();
	      }
	      else {
	        // downgrade to number, return Complex valued result
	        return _log10Complex(new type.Complex(x.toNumber(), 0));
	      }
	    },

	    'Array | Matrix': function (x) {
	      return deepMap(x, log10);
	    }
	  });

	  log10.toTex = '\\log_{10}\\left(${args[0]}\\right)';

	  return log10;

	  /**
	   * Calculate log10 for a complex value
	   * @param {Complex} x
	   * @returns {Complex}
	   * @private
	   */
	  function _log10Complex(x) {
	    return new type.Complex (
	        Math.log(Math.sqrt(x.re * x.re + x.im * x.im)) / Math.LN10,
	        Math.atan2(x.im, x.re) / Math.LN10
	    );
	  }
	}

	exports.name = 'log10';
	exports.factory = factory;



/***/ },
/* 110 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	function factory (type, config, load, typed) {

	  var matrix = load(__webpack_require__(23));
	  var latex = __webpack_require__(26);

	  var algorithm02 = load(__webpack_require__(96));
	  var algorithm03 = load(__webpack_require__(31));
	  var algorithm05 = load(__webpack_require__(32));
	  var algorithm11 = load(__webpack_require__(42));
	  var algorithm12 = load(__webpack_require__(65));
	  var algorithm13 = load(__webpack_require__(35));
	  var algorithm14 = load(__webpack_require__(39));
	  
	  /**
	   * Calculates the modulus, the remainder of an integer division.
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * The modulus is defined as:
	   *
	   *     x - y * floor(x / y)
	   *
	   * See http://en.wikipedia.org/wiki/Modulo_operation.
	   *
	   * Syntax:
	   *
	   *    math.mod(x, y)
	   *
	   * Examples:
	   *
	   *    math.mod(8, 3);                // returns 2
	   *    math.mod(11, 2);               // returns 1
	   *
	   *    function isOdd(x) {
	   *      return math.mod(x, 2) != 0;
	   *    }
	   *
	   *    isOdd(2);                      // returns false
	   *    isOdd(3);                      // returns true
	   *
	   * See also:
	   *
	   *    divide
	   *
	   * @param  {number | BigNumber | Fraction | Array | Matrix} x Dividend
	   * @param  {number | BigNumber | Fraction | Array | Matrix} y Divisor
	   * @return {number | BigNumber | Fraction | Array | Matrix} Returns the remainder of `x` divided by `y`.
	   */
	  var mod = typed('mod', {

	    'number, number': _mod,

	    'BigNumber, BigNumber': function (x, y) {
	      return y.isZero() ? x : x.mod(y);
	    },

	    'Fraction, Fraction': function (x, y) {
	      return x.mod(y);
	    },

	    'Matrix, Matrix': function (x, y) {
	      // result
	      var c;

	      // process matrix storage
	      switch (x.storage()) {
	        case 'sparse':
	          switch (y.storage()) {
	            case 'sparse':
	              // mod(sparse, sparse)
	              c = algorithm05(x, y, mod, false);
	              break;
	            default:
	              // mod(sparse, dense)
	              c = algorithm02(y, x, mod, true);
	              break;
	          }
	          break;
	        default:
	          switch (y.storage()) {
	            case 'sparse':
	              // mod(dense, sparse)
	              c = algorithm03(x, y, mod, false);
	              break;
	            default:
	              // mod(dense, dense)
	              c = algorithm13(x, y, mod);
	              break;
	          }
	          break;
	      }
	      return c;
	    },
	    
	    'Array, Array': function (x, y) {
	      // use matrix implementation
	      return mod(matrix(x), matrix(y)).valueOf();
	    },

	    'Array, Matrix': function (x, y) {
	      // use matrix implementation
	      return mod(matrix(x), y);
	    },

	    'Matrix, Array': function (x, y) {
	      // use matrix implementation
	      return mod(x, matrix(y));
	    },

	    'Matrix, any': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (x.storage()) {
	        case 'sparse':
	          c = algorithm11(x, y, mod, false);
	          break;
	        default:
	          c = algorithm14(x, y, mod, false);
	          break;
	      }
	      return c;
	    },

	    'any, Matrix': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (y.storage()) {
	        case 'sparse':
	          c = algorithm12(y, x, mod, true);
	          break;
	        default:
	          c = algorithm14(y, x, mod, true);
	          break;
	      }
	      return c;
	    },

	    'Array, any': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(x), y, mod, false).valueOf();
	    },

	    'any, Array': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(y), x, mod, true).valueOf();
	    }
	  });

	  mod.toTex = '\\left(${args[0]}' + latex.operators['mod'] + '${args[1]}\\right)';

	  return mod;

	  /**
	   * Calculate the modulus of two numbers
	   * @param {number} x
	   * @param {number} y
	   * @returns {number} res
	   * @private
	   */
	  function _mod(x, y) {
	    if (y > 0) {
	      // We don't use JavaScript's % operator here as this doesn't work
	      // correctly for x < 0 and x == 0
	      // see http://en.wikipedia.org/wiki/Modulo_operation
	      return x - y * Math.floor(x / y);
	    }
	    else if (y === 0) {
	      return x;
	    }
	    else { // y < 0
	      // TODO: implement mod for a negative divisor
	      throw new Error('Cannot calculate mod for a negative divisor');
	    }
	  }
	}

	exports.name = 'mod';
	exports.factory = factory;


/***/ },
/* 111 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	function factory (type, config, load, typed) {
	  
	  var abs         = load(__webpack_require__(63));
	  var add         = load(__webpack_require__(44));
	  var pow         = load(__webpack_require__(100));
	  var sqrt        = load(__webpack_require__(112));
	  var multiply    = load(__webpack_require__(40));
	  var equalScalar = load(__webpack_require__(33));
	  var larger      = load(__webpack_require__(64));
	  var smaller     = load(__webpack_require__(113));
	  var matrix      = load(__webpack_require__(23));
	  var trace       = load(__webpack_require__(58));
	  var transpose   = load(__webpack_require__(59));
	  
	  var complexAbs = typed.find(abs, ['Complex']);

	  /**
	   * Calculate the norm of a number, vector or matrix.
	   *
	   * The second parameter p is optional. If not provided, it defaults to 2.
	   *
	   * Syntax:
	   *
	   *    math.norm(x)
	   *    math.norm(x, p)
	   *
	   * Examples:
	   *
	   *    math.abs(-3.5);                         // returns 3.5
	   *    math.norm(-3.5);                        // returns 3.5
	   *
	   *    math.norm(math.complex(3, -4));         // returns 5
	   *
	   *    math.norm([1, 2, -3], Infinity);        // returns 3
	   *    math.norm([1, 2, -3], -Infinity);       // returns 1
	   *
	   *    math.norm([3, 4], 2);                   // returns 5
	   *
	   *    math.norm([[1, 2], [3, 4]], 1)          // returns 6
	   *    math.norm([[1, 2], [3, 4]], 'inf');     // returns 7
	   *    math.norm([[1, 2], [3, 4]], 'fro');     // returns 5.477225575051661
	   *
	   * See also:
	   *
	   *    abs
	   *
	   * @param  {number | BigNumber | Complex | Array | Matrix} x
	   *            Value for which to calculate the norm
	   * @param  {number | BigNumber | string} [p=2]
	   *            Vector space.
	   *            Supported numbers include Infinity and -Infinity.
	   *            Supported strings are: 'inf', '-inf', and 'fro' (The Frobenius norm)
	   * @return {number | BigNumber} the p-norm
	   */
	  var norm = typed('norm', {
	    'number': Math.abs,

	    'Complex': complexAbs,

	    'BigNumber': function (x) {
	      // norm(x) = abs(x)
	      return x.abs();
	    },
	    
	    'boolean | null' : function (x) {
	      // norm(x) = abs(x)
	      return Math.abs(x);
	    },

	    'Array': function (x) {
	      return _norm(matrix(x), 2);
	    },
	    
	    'Matrix': function (x) {
	      return _norm(x, 2);
	    },

	    'number | Complex | BigNumber | boolean | null, number | BigNumber | string': function (x) {
	      // ignore second parameter, TODO: remove the option of second parameter for these types
	      return norm(x);
	    },

	    'Array, number | BigNumber | string': function (x, p) {
	      return _norm(matrix(x), p);
	    },
	    
	    'Matrix, number | BigNumber | string': function (x, p) {
	      return _norm(x, p);
	    }
	  });

	  /**
	   * Calculate the norm for an array
	   * @param {Array} x
	   * @param {number | string} p
	   * @returns {number} Returns the norm
	   * @private
	   */
	  function _norm (x, p) {
	    // size
	    var sizeX = x.size();
	    
	    // check if it is a vector
	    if (sizeX.length == 1) {
	      // check p
	      if (p === Number.POSITIVE_INFINITY || p === 'inf') {
	        // norm(x, Infinity) = max(abs(x))
	        var pinf = 0;
	        // skip zeros since abs(0) == 0
	        x.forEach(
	          function (value) {
	            var v = abs(value);
	            if (larger(v, pinf))
	              pinf = v;
	          },
	          true);
	        return pinf;
	      }
	      if (p === Number.NEGATIVE_INFINITY || p === '-inf') {
	        // norm(x, -Infinity) = min(abs(x))
	        var ninf;
	        // skip zeros since abs(0) == 0
	        x.forEach(
	          function (value) {
	            var v = abs(value);
	            if (!ninf || smaller(v, ninf))
	              ninf = v;
	          },
	          true);
	        return ninf || 0;
	      }
	      if (p === 'fro') {
	        return _norm(x, 2);
	      }
	      if (typeof p === 'number' && !isNaN(p)) {
	        // check p != 0
	        if (!equalScalar(p, 0)) {
	          // norm(x, p) = sum(abs(xi) ^ p) ^ 1/p
	          var n = 0;
	          // skip zeros since abs(0) == 0
	          x.forEach(
	            function (value) {
	              n = add(pow(abs(value), p), n);
	            },
	            true);
	          return pow(n, 1 / p);
	        }
	        return Number.POSITIVE_INFINITY;
	      }
	      // invalid parameter value
	      throw new Error('Unsupported parameter value');
	    }
	    // MxN matrix
	    if (sizeX.length == 2) {
	      // check p
	      if (p === 1) {
	        // norm(x) = the largest column sum
	        var c = [];
	        // result
	        var maxc = 0;
	        // skip zeros since abs(0) == 0
	        x.forEach(
	          function (value, index) {
	            var j = index[1];
	            var cj = add(c[j] || 0, abs(value));
	            if (larger(cj, maxc))
	              maxc = cj;
	            c[j] = cj;
	          },
	          true);
	        return maxc;
	      }
	      if (p === Number.POSITIVE_INFINITY || p === 'inf') {
	        // norm(x) = the largest row sum
	        var r = [];
	        // result
	        var maxr = 0;
	        // skip zeros since abs(0) == 0
	        x.forEach(
	          function (value, index) {
	            var i = index[0];
	            var ri = add(r[i] || 0, abs(value));
	            if (larger(ri, maxr))
	              maxr = ri;
	            r[i] = ri;
	          },
	          true);
	        return maxr;
	      }
	      if (p === 'fro') {
	        // norm(x) = sqrt(sum(diag(x'x)))
	        return sqrt(trace(multiply(transpose(x), x)));
	      }
	      if (p === 2) {
	        // not implemented
	        throw new Error('Unsupported parameter value, missing implementation of matrix singular value decomposition');
	      }
	      // invalid parameter value
	      throw new Error('Unsupported parameter value');
	    }
	  }

	  norm.toTex = {
	    1: '\\left\\|${args[0]}\\right\\|',
	    2: '\\mathrm{${name}}\\left(${args}\\right)'
	  };

	  return norm;
	}

	exports.name = 'norm';
	exports.factory = factory;


/***/ },
/* 112 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);

	function factory (type, config, load, typed) {
	  /**
	   * Calculate the square root of a value.
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.sqrt(x)
	   *
	   * Examples:
	   *
	   *    math.sqrt(25);                // returns 5
	   *    math.square(5);               // returns 25
	   *    math.sqrt(-4);                // returns Complex -2i
	   *
	   * See also:
	   *
	   *    square, multiply
	   *
	   * @param {number | BigNumber | Complex | Array | Matrix} x
	   *            Value for which to calculate the square root.
	   * @return {number | BigNumber | Complex | Array | Matrix}
	   *            Returns the square root of `x`
	   */
	  var sqrt = typed('sqrt', {
	    'number': _sqrtNumber,

	    'Complex': _sqrtComplex,

	    'BigNumber': function (x) {
	      if (!x.isNegative() || config.predictable) {
	        return x.sqrt();
	      }
	      else {
	        // negative value -> downgrade to number to do complex value computation
	        return _sqrtNumber(x.toNumber());
	      }
	    },

	    'Array | Matrix': function (x) {
	      // deep map collection, skip zeros since sqrt(0) = 0
	      return deepMap(x, sqrt, true);
	    }
	  });

	  /**
	   * Calculate sqrt for a number
	   * @param {number} x
	   * @returns {number | Complex} Returns the square root of x
	   * @private
	   */
	  function _sqrtNumber(x) {
	    if (x >= 0 || config.predictable) {
	      return Math.sqrt(x);
	    }
	    else {
	      return _sqrtComplex(new type.Complex(x, 0));
	    }
	  }

	  /**
	   * Calculate sqrt for a complex number
	   * @param {Complex} x
	   * @returns {Complex} Returns the square root of x
	   * @private
	   */
	  function _sqrtComplex(x) {
	    var r = Math.sqrt(x.re * x.re + x.im * x.im);

	    var re, im;

	    if (x.re >= 0) {
	      re = 0.5 * Math.sqrt(2.0 * (r + x.re));
	    }
	    else {
	      re = Math.abs(x.im) / Math.sqrt(2 * (r - x.re));
	    }

	    if (x.re <= 0) {
	      im = 0.5 * Math.sqrt(2.0 * (r - x.re));
	    }
	    else {
	      im = Math.abs(x.im) / Math.sqrt(2 * (r + x.re));
	    }

	    if (x.im >= 0) {
	      return new type.Complex(re, im);
	    }
	    else {
	      return new type.Complex(re, -im);
	    }
	  }

	  sqrt.toTex = '\\sqrt{${args[0]}}';

	  return sqrt;
	}

	exports.name = 'sqrt';
	exports.factory = factory;


/***/ },
/* 113 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var nearlyEqual = __webpack_require__(8).nearlyEqual;

	function factory (type, config, load, typed) {

	  var matrix = load(__webpack_require__(23));

	  var algorithm03 = load(__webpack_require__(31));
	  var algorithm07 = load(__webpack_require__(66));
	  var algorithm12 = load(__webpack_require__(65));
	  var algorithm13 = load(__webpack_require__(35));
	  var algorithm14 = load(__webpack_require__(39));

	  var latex = __webpack_require__(26);

	  /**
	   * Test whether value x is smaller than y.
	   *
	   * The function returns true when x is smaller than y and the relative
	   * difference between x and y is smaller than the configured epsilon. The
	   * function cannot be used to compare values smaller than approximately 2.22e-16.
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.smaller(x, y)
	   *
	   * Examples:
	   *
	   *    math.smaller(2, 3);            // returns true
	   *    math.smaller(5, 2 * 2);        // returns false
	   *
	   *    var a = math.unit('5 cm');
	   *    var b = math.unit('2 inch');
	   *    math.smaller(a, b);            // returns true
	   *
	   * See also:
	   *
	   *    equal, unequal, smallerEq, smaller, smallerEq, compare
	   *
	   * @param  {number | BigNumber | Fraction | boolean | Unit | string | Array | Matrix} x First value to compare
	   * @param  {number | BigNumber | Fraction | boolean | Unit | string | Array | Matrix} y Second value to compare
	   * @return {boolean | Array | Matrix} Returns true when the x is smaller than y, else returns false
	   */
	  var smaller = typed('smaller', {

	    'boolean, boolean': function (x, y) {
	      return x < y;
	    },

	    'number, number': function (x, y) {
	      return x < y && !nearlyEqual(x, y, config.epsilon);
	    },

	    'BigNumber, BigNumber': function (x, y) {
	      return x.lt(y);
	    },

	    'Fraction, Fraction': function (x, y) {
	      return x.compare(y) === -1;
	    },

	    'Complex, Complex': function (x, y) {
	      throw new TypeError('No ordering relation is defined for complex numbers');
	    },

	    'Unit, Unit': function (x, y) {
	      if (!x.equalBase(y)) {
	        throw new Error('Cannot compare units with different base');
	      }
	      return x.value < y.value && !nearlyEqual(x.value, y.value, config.epsilon);
	    },

	    'string, string': function (x, y) {
	      return x < y;
	    },

	    'Matrix, Matrix': function (x, y) {
	      // result
	      var c;

	      // process matrix storage
	      switch (x.storage()) {
	        case 'sparse':
	          switch (y.storage()) {
	            case 'sparse':
	              // sparse + sparse
	              c = algorithm07(x, y, smaller);
	              break;
	            default:
	              // sparse + dense
	              c = algorithm03(y, x, smaller, true);
	              break;
	          }
	          break;
	        default:
	          switch (y.storage()) {
	            case 'sparse':
	              // dense + sparse
	              c = algorithm03(x, y, smaller, false);
	              break;
	            default:
	              // dense + dense
	              c = algorithm13(x, y, smaller);
	              break;
	          }
	          break;
	      }
	      return c;
	    },

	    'Array, Array': function (x, y) {
	      // use matrix implementation
	      return smaller(matrix(x), matrix(y)).valueOf();
	    },

	    'Array, Matrix': function (x, y) {
	      // use matrix implementation
	      return smaller(matrix(x), y);
	    },

	    'Matrix, Array': function (x, y) {
	      // use matrix implementation
	      return smaller(x, matrix(y));
	    },

	    'Matrix, any': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (x.storage()) {
	        case 'sparse':
	          c = algorithm12(x, y, smaller, false);
	          break;
	        default:
	          c = algorithm14(x, y, smaller, false);
	          break;
	      }
	      return c;
	    },

	    'any, Matrix': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (y.storage()) {
	        case 'sparse':
	          c = algorithm12(y, x, smaller, true);
	          break;
	        default:
	          c = algorithm14(y, x, smaller, true);
	          break;
	      }
	      return c;
	    },

	    'Array, any': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(x), y, smaller, false).valueOf();
	    },

	    'any, Array': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(y), x, smaller, true).valueOf();
	    }
	  });

	  smaller.toTex = '\\left(${args[0]}' + latex.operators['smaller'] + '${args[1]}\\right)';

	  return smaller;
	}

	exports.name = 'smaller';
	exports.factory = factory;


/***/ },
/* 114 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	function factory (type, config, load, typed) {

	  var matrix = load(__webpack_require__(23));

	  var algorithm01 = load(__webpack_require__(30));
	  var algorithm02 = load(__webpack_require__(96));
	  var algorithm06 = load(__webpack_require__(107));
	  var algorithm11 = load(__webpack_require__(42));
	  var algorithm13 = load(__webpack_require__(35));
	  var algorithm14 = load(__webpack_require__(39));

	  /**
	   * Calculate the nth root of a value.
	   * The principal nth root of a positive real number A, is the positive real
	   * solution of the equation
	   *
	   *     x^root = A
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *     math.nthRoot(a)
	   *     math.nthRoot(a, root)
	   *
	   * Examples:
	   *
	   *     math.nthRoot(9, 2);    // returns 3, as 3^2 == 9
	   *     math.sqrt(9);          // returns 3, as 3^2 == 9
	   *     math.nthRoot(64, 3);   // returns 4, as 4^3 == 64
	   *
	   * See also:
	   *
	   *     sqrt, pow
	   *
	   * @param {number | BigNumber | Array | Matrix | Complex} a
	   *              Value for which to calculate the nth root
	   * @param {number | BigNumber} [root=2]    The root.
	   * @return {number | Complex | Array | Matrix} Returns the nth root of `a`
	   */
	  var nthRoot = typed('nthRoot', {
	    
	    'number': function (x) {
	      return _nthRoot(x, 2);
	    },
	    'number, number': _nthRoot,

	    'BigNumber': function (x) {
	      return _bigNthRoot(x, new type.BigNumber(2));
	    },
	    'Complex' : function(x) {
	      return _nthComplexRoot(x, 2);
	    }, 
	    'Complex, number' : _nthComplexRoot,
	    'BigNumber, BigNumber': _bigNthRoot,

	    'Array | Matrix': function (x) {
	      return nthRoot(x, 2);
	    },
	    
	    'Matrix, Matrix': function (x, y) {
	      // result
	      var c;

	      // process matrix storage
	      switch (x.storage()) {
	        case 'sparse':
	          switch (y.storage()) {
	            case 'sparse':
	              // density must be one (no zeros in matrix)
	              if (y.density() === 1) {
	                // sparse + sparse
	                c = algorithm06(x, y, nthRoot);
	              }
	              else {
	                // throw exception
	                throw new Error('Root must be non-zero');
	              }
	              break;
	            default:
	              // sparse + dense
	              c = algorithm02(y, x, nthRoot, true);
	              break;
	          }
	          break;
	        default:
	          switch (y.storage()) {
	            case 'sparse':
	              // density must be one (no zeros in matrix)
	              if (y.density() === 1) {
	                // dense + sparse
	                c = algorithm01(x, y, nthRoot, false);
	              }
	              else {
	                // throw exception
	                throw new Error('Root must be non-zero');
	              }
	              break;
	            default:
	              // dense + dense
	              c = algorithm13(x, y, nthRoot);
	              break;
	          }
	          break;
	      }
	      return c;
	    },

	    'Array, Array': function (x, y) {
	      // use matrix implementation
	      return nthRoot(matrix(x), matrix(y)).valueOf();
	    },

	    'Array, Matrix': function (x, y) {
	      // use matrix implementation
	      return nthRoot(matrix(x), y);
	    },

	    'Matrix, Array': function (x, y) {
	      // use matrix implementation
	      return nthRoot(x, matrix(y));
	    },
	    
	    'Matrix, number | BigNumber': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (x.storage()) {
	        case 'sparse':
	          c = algorithm11(x, y, nthRoot, false);
	          break;
	        default:
	          c = algorithm14(x, y, nthRoot, false);
	          break;
	      }
	      return c;
	    },

	    'number | BigNumber, Matrix': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (y.storage()) {
	        case 'sparse':
	          // density must be one (no zeros in matrix)
	          if (y.density() === 1) {
	            // sparse - scalar
	            c = algorithm11(y, x, nthRoot, true);
	          }
	          else {
	            // throw exception
	            throw new Error('Root must be non-zero');
	          }
	          break;
	        default:
	          c = algorithm14(y, x, nthRoot, true);
	          break;
	      }
	      return c;
	    },

	    'Array, number | BigNumber': function (x, y) {
	      // use matrix implementation
	      return nthRoot(matrix(x), y).valueOf();
	    },

	    'number | BigNumber, Array': function (x, y) {
	      // use matrix implementation
	      return nthRoot(x, matrix(y)).valueOf();
	    }
	  });

	  nthRoot.toTex = '\\sqrt[${args[1]}]{${args[0]}}';

	  return nthRoot;

	  /**
	   * Calculate the nth root of a for BigNumbers, solve x^root == a
	   * http://rosettacode.org/wiki/Nth_root#JavaScript
	   * @param {BigNumber} a
	   * @param {BigNumber} root
	   * @private
	   */
	  function _bigNthRoot(a, root) {
	    var zero = new type.BigNumber(0);
	    var one = new type.BigNumber(1);
	    var inv = root.isNegative();
	    if (inv) root = root.negated();

	    if (root.isZero()) throw new Error('Root must be non-zero');
	    if (a.isNegative() && !root.abs().mod(2).equals(1)) throw new Error('Root must be odd when a is negative.');

	    // edge cases zero and infinity
	    if (a.isZero()) return zero;
	    if (!a.isFinite())
	    {
	      return inv ? zero : a;
	    }

	    var x = one; // Initial guess
	    var i = 0;
	    var iMax = 10000;
	    do {
	      var xPrev = x;
	      var delta = a.div(x.pow(root.minus(1))).minus(x).div(root);
	      x = x.plus(delta);
	      i++;
	    }
	    while (!x.equals(xPrev) && i < iMax);

	    if (!x.equals(xPrev)) {
	      throw new Error('Function nthRoot failed to converge');
	    }

	    return inv ? one.div(x) : x;
	  }
	}

	/**
	 * Calculate the nth root of a, solve x^root == a
	 * http://rosettacode.org/wiki/Nth_root#JavaScript
	 * @param {number} a
	 * @param {number} root
	 * @private
	 */
	function _nthRoot(a, root) {
	  var inv = root < 0;
	  if (inv) root = -root;

	  if (root === 0) throw new Error('Root must be non-zero');
	  if (a < 0 && (Math.abs(root) % 2 != 1)) throw new Error('Root must be odd when a is negative.');

	  // edge cases zero and infinity
	  if (a == 0) return 0;
	  if (!Number.isFinite(a)) {
	    return inv ? 0 : a;
	  }

	  var x = 1; // Initial guess
	  var xPrev = 1;
	  var i = 0;
	  var iMax = 10000;
	  do {
	    var delta = (a / Math.pow(x, root - 1) - x) / root;
	    xPrev = x;
	    x = x + delta;
	    i++;
	  }
	  while (xPrev !== x && i < iMax);

	  if (xPrev !== x) {
	    throw new Error('Function nthRoot failed to converge');
	  }

	  return inv ? 1 / x : x;
	}

	/**
	 * Calculate the nth root of a Complex Number a using De Moviers Theorem.
	 * @param  {Complex} a
	 * @param  {number} root
	 * @return {Array} array or n Complex Roots in Polar Form.
	 */
	function _nthComplexRoot(a, root) {
	  if (root < 0) throw new Error('Root must be greater than zero');
	  if (root === 0) throw new Error('Root must be non-zero');
	  if (root % 1 !== 0) throw new Error('Root must be an integer');  
	  var polar = a.toPolar();
	  var roots = [];
	  var r = Math.pow(polar.r, 1/root);
	  for(var k = 0; k < root; k++) {
	    roots.push({r: r, phi: (polar.phi + 2 * Math.PI * k)/root});
	  }
	  return roots;
	}

	exports.name = 'nthRoot';
	exports.factory = factory;


/***/ },
/* 115 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var isInteger = __webpack_require__(8).isInteger;
	var toFixed = __webpack_require__(8).toFixed;
	var deepMap = __webpack_require__(29);

	var NO_INT = 'Number of decimals in function round must be an integer';

	function factory (type, config, load, typed) {
	  var matrix = load(__webpack_require__(23));
	  var equalScalar = load(__webpack_require__(33));
	  var zeros = load(__webpack_require__(60));

	  var algorithm11 = load(__webpack_require__(42));
	  var algorithm12 = load(__webpack_require__(65));
	  var algorithm14 = load(__webpack_require__(39));
	  
	  /**
	   * Round a value towards the nearest integer.
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.round(x)
	   *    math.round(x, n)
	   *
	   * Examples:
	   *
	   *    math.round(3.2);              // returns number 3
	   *    math.round(3.8);              // returns number 4
	   *    math.round(-4.2);             // returns number -4
	   *    math.round(-4.7);             // returns number -5
	   *    math.round(math.pi, 3);       // returns number 3.142
	   *    math.round(123.45678, 2);     // returns number 123.46
	   *
	   *    var c = math.complex(3.2, -2.7);
	   *    math.round(c);                // returns Complex 3 - 3i
	   *
	   *    math.round([3.2, 3.8, -4.7]); // returns Array [3, 4, -5]
	   *
	   * See also:
	   *
	   *    ceil, fix, floor
	   *
	   * @param  {number | BigNumber | Fraction | Complex | Array | Matrix} x  Number to be rounded
	   * @param  {number | BigNumber | Array} [n=0]                            Number of decimals
	   * @return {number | BigNumber | Fraction | Complex | Array | Matrix} Rounded value
	   */
	  var round = typed('round', {

	    'number': Math.round,

	    'number, number': function (x, n) {
	      if (!isInteger(n))   {throw new TypeError(NO_INT);}
	      if (n < 0 || n > 15) {throw new Error('Number of decimals in function round must be in te range of 0-15');}

	      return _round(x, n);
	    },

	    'Complex': function (x) {
	      return new type.Complex (
	          Math.round(x.re),
	          Math.round(x.im)
	      );
	    },

	    'Complex, number': function (x, n) {
	      return new type.Complex (
	          _round(x.re, n),
	          _round(x.im, n)
	      );
	    },

	    'Complex, BigNumber': function (x, n) {
	      if (!n.isInteger()) {throw new TypeError(NO_INT);}

	      var _n = n.toNumber();
	      return new type.Complex (
	          _round(x.re, _n),
	          _round(x.im, _n)
	      );
	    },

	    'number, BigNumber': function (x, n) {
	      if (!n.isInteger()) {throw new TypeError(NO_INT);}

	      return new type.BigNumber(x).toDecimalPlaces(n.toNumber());
	    },

	    'BigNumber': function (x) {
	      return x.toDecimalPlaces(0);
	    },

	    'BigNumber, BigNumber': function (x, n) {
	      if (!n.isInteger()) {throw new TypeError(NO_INT);}

	      return x.toDecimalPlaces(n.toNumber());
	    },

	    'Fraction': function (x) {
	      return x.round();
	    },
	    // TODO: add support for math.round(Fraction, Fraction | number)

	    'Array | Matrix': function (x) {
	      // deep map collection, skip zeros since round(0) = 0
	      return deepMap(x, round, true);
	    },

	    'Matrix, number | BigNumber': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (x.storage()) {
	        case 'sparse':
	          c = algorithm11(x, y, round, false);
	          break;
	        default:
	          c = algorithm14(x, y, round, false);
	          break;
	      }
	      return c;
	    },

	    'number | Complex | BigNumber, Matrix': function (x, y) {
	      // check scalar is zero
	      if (!equalScalar(x, 0)) {
	        // result
	        var c;
	        // check storage format
	        switch (y.storage()) {
	          case 'sparse':
	            c = algorithm12(y, x, round, true);
	            break;
	          default:
	            c = algorithm14(y, x, round, true);
	            break;
	        }
	        return c;
	      }
	      // do not execute algorithm, result will be a zero matrix
	      return zeros(y.size(), y.storage());
	    },

	    'Array, number | BigNumber': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(x), y, round, false).valueOf();
	    },

	    'number | Complex | BigNumber, Array': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(y), x, round, true).valueOf();
	    }
	  });

	  round.toTex = {
	    1: '\\left\\lfloor${args[0]}\\right\\rceil',
	    2: '\\mathrm{${name}}\\left(${args}\\right)'
	  };

	  return round;
	}

	/**
	 * round a number to the given number of decimals, or to zero if decimals is
	 * not provided
	 * @param {number} value
	 * @param {number} decimals       number of decimals, between 0 and 15 (0 by default)
	 * @return {number} roundedValue
	 * @private
	 */
	function _round (value, decimals) {
	  return parseFloat(toFixed(value, decimals));
	}

	exports.name = 'round';
	exports.factory = factory;


/***/ },
/* 116 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var number = __webpack_require__(8);
	var deepMap = __webpack_require__(29);

	function factory (type, config, load, typed) {
	  /**
	   * Compute the sign of a value. The sign of a value x is:
	   *
	   * -  1 when x > 1
	   * - -1 when x < 0
	   * -  0 when x == 0
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.sign(x)
	   *
	   * Examples:
	   *
	   *    math.sign(3.5);               // returns 1
	   *    math.sign(-4.2);              // returns -1
	   *    math.sign(0);                 // returns 0
	   *
	   *    math.sign([3, 5, -2, 0, 2]);  // returns [1, 1, -1, 0, 1]
	   *
	   * See also:
	   *
	   *    abs
	   *
	   * @param  {number | BigNumber | Fraction | Complex | Array | Matrix} x
	   *            The number for which to determine the sign
	   * @return {number | BigNumber | Fraction | Complex | Array | Matrix}e
	   *            The sign of `x`
	   */
	  var sign = typed('sign', {
	    'number': number.sign,

	    'Complex': function (x) {
	      var abs = Math.sqrt(x.re * x.re + x.im * x.im);
	      return new type.Complex(x.re / abs, x.im / abs);
	    },

	    'BigNumber': function (x) {
	      return new type.BigNumber(x.cmp(0));
	    },

	    'Fraction': function (x) {
	      return new type.Fraction(x.s);
	    },

	    'Array | Matrix': function (x) {
	      // deep map collection, skip zeros since sign(0) = 0
	      return deepMap(x, sign, true);
	    }
	  });

	  sign.toTex = '\\mathrm{${name}}\\left(${args}\\right)';

	  return sign;
	}

	exports.name = 'sign';
	exports.factory = factory;



/***/ },
/* 117 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);

	function factory (type, config, load, typed) {
	  /**
	   * Compute the square of a value, `x * x`.
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.square(x)
	   *
	   * Examples:
	   *
	   *    math.square(2);           // returns number 4
	   *    math.square(3);           // returns number 9
	   *    math.pow(3, 2);           // returns number 9
	   *    math.multiply(3, 3);      // returns number 9
	   *
	   *    math.square([1, 2, 3, 4]);  // returns Array [1, 4, 9, 16]
	   *
	   * See also:
	   *
	   *    multiply, cube, sqrt, pow
	   *
	   * @param  {number | BigNumber | Fraction | Complex | Array | Matrix} x
	   *            Number for which to calculate the square
	   * @return {number | BigNumber | Fraction | Complex | Array | Matrix}
	   *            Squared value
	   */
	  var square = typed('square', {
	    'number': function (x) {
	      return x * x;
	    },

	    'Complex': function (x) {
	      return new type.Complex(
	          x.re * x.re - x.im * x.im,
	          x.re * x.im + x.im * x.re
	      );
	    },

	    'BigNumber': function (x) {
	      return x.times(x);
	    },

	    'Fraction': function (x) {
	      return x.clone().mul(x);
	    },

	    'Array | Matrix': function (x) {
	      // deep map collection, skip zeros since square(0) = 0
	      return deepMap(x, square, true);
	    }
	  });

	  square.toTex = '\\left(${args[0]}\\right)^2';

	  return square;
	}

	exports.name = 'square';
	exports.factory = factory;


/***/ },
/* 118 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);

	function factory (type, config, load, typed) {
	  var latex = __webpack_require__(26);

	  /**
	   * Unary plus operation.
	   * Boolean values and strings will be converted to a number, numeric values will be returned as is.
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.unaryPlus(x)
	   *
	   * Examples:
	   *
	   *    math.unaryPlus(3.5);      // returns 3.5
	   *    math.unaryPlus(1);     // returns 1
	   *
	   * See also:
	   *
	   *    unaryMinus, add, subtract
	   *
	   * @param  {number | BigNumber | Fraction | string | Complex | Unit | Array | Matrix} x
	   *            Input value
	   * @return {number | BigNumber | Fraction | Complex | Unit | Array | Matrix}
	   *            Returns the input value when numeric, converts to a number when input is non-numeric.
	   */
	  var unaryPlus = typed('unaryPlus', {
	    'number': function (x) {
	      return x;
	    },

	    'Complex': function (x) {
	      return x.clone();
	    },

	    'BigNumber': function (x) {
	      return x; // bignumbers are immutable
	    },

	    'Fraction': function (x) {
	      return x; // fractions are immutable
	    },

	    'Unit': function (x) {
	      return x.clone();
	    },

	    'Array | Matrix': function (x) {
	      // deep map collection, skip zeros since unaryPlus(0) = 0
	      return deepMap(x, unaryPlus, true);
	    },

	    'boolean | string | null': function (x) {
	      // convert to a number or bignumber
	      return (config.number == 'bignumber') ? new type.BigNumber(+x): +x;
	    }
	  });

	  unaryPlus.toTex = latex.operators['unaryPlus'] + '\\left(${args[0]}\\right)'

	  return unaryPlus;
	}

	exports.name = 'unaryPlus';
	exports.factory = factory;


/***/ },
/* 119 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var isInteger = __webpack_require__(8).isInteger;

	function factory (type, config, load, typed) {
	  var matrix = load(__webpack_require__(23));

	  /**
	   * Calculate the extended greatest common divisor for two values.
	   * See http://en.wikipedia.org/wiki/Extended_Euclidean_algorithm.
	   *
	   * Syntax:
	   *
	   *    math.xgcd(a, b)
	   *
	   * Examples:
	   *
	   *    math.xgcd(8, 12);             // returns [4, -1, 1]
	   *    math.gcd(8, 12);              // returns 4
	   *    math.xgcd(36163, 21199);      // returns [1247, -7, 12]
	   *
	   * See also:
	   *
	   *    gcd, lcm
	   *
	   * @param {number | BigNumber} a  An integer number
	   * @param {number | BigNumber} b  An integer number
	   * @return {Array}              Returns an array containing 3 integers `[div, m, n]`
	   *                              where `div = gcd(a, b)` and `a*m + b*n = div`
	   */
	  var xgcd = typed('xgcd', {
	    'number, number': _xgcd,
	    'BigNumber, BigNumber': _xgcdBigNumber
	    // TODO: implement support for Fraction
	  });

	  xgcd.toTex = '\\mathrm{${name}}\\left(${args}\\right)';

	  return xgcd;

	  /**
	   * Calculate xgcd for two numbers
	   * @param {number} a
	   * @param {number} b
	   * @return {number} result
	   * @private
	   */
	  function _xgcd (a, b) {
	    // source: http://en.wikipedia.org/wiki/Extended_Euclidean_algorithm
	    var t, // used to swap two variables
	        q, // quotient
	        r, // remainder
	        x = 0, lastx = 1,
	        y = 1, lasty = 0;

	    if (!isInteger(a) || !isInteger(b)) {
	      throw new Error('Parameters in function xgcd must be integer numbers');
	    }

	    while (b) {
	      q = Math.floor(a / b);
	      r = a % b;

	      t = x;
	      x = lastx - q * x;
	      lastx = t;

	      t = y;
	      y = lasty - q * y;
	      lasty = t;

	      a = b;
	      b = r;
	    }

	    var res;
	    if (a < 0) {
	      res = [-a, -lastx, -lasty];
	    }
	    else {
	      res = [a, a ? lastx : 0, lasty];
	    }
	    return (config.matrix === 'array') ? res : matrix(res);
	  }

	  /**
	   * Calculate xgcd for two BigNumbers
	   * @param {BigNumber} a
	   * @param {BigNumber} b
	   * @return {BigNumber[]} result
	   * @private
	   */
	  function _xgcdBigNumber(a, b) {
	    // source: http://en.wikipedia.org/wiki/Extended_Euclidean_algorithm
	    var t, // used to swap two variables
	        q, // quotient
	        r, // remainder
	        zero = new type.BigNumber(0),
	        x = new type.BigNumber(0), lastx = new type.BigNumber(1),
	        y = new type.BigNumber(1), lasty = new type.BigNumber(0);

	    if (!a.isInt() || !b.isInt()) {
	      throw new Error('Parameters in function xgcd must be integer numbers');
	    }

	    while (!b.isZero()) {
	      q = a.div(b).floor();
	      r = a.mod(b);

	      t = x;
	      x = lastx.minus(q.times(x));
	      lastx = t;

	      t = y;
	      y = lasty.minus(q.times(y));
	      lasty = t;

	      a = b;
	      b = r;
	    }

	    var res;
	    if (a.lt(zero)) {
	      res = [a.neg(), lastx.neg(), lasty.neg()];
	    }
	    else {
	      res = [a, !a.isZero() ? lastx : 0, lasty];
	    }
	    return (config.matrix === 'array') ? res : matrix(res);
	  }
	}

	exports.name = 'xgcd';
	exports.factory = factory;


/***/ },
/* 120 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = [
	  __webpack_require__(121),
	  __webpack_require__(125),
	  __webpack_require__(126),
	  __webpack_require__(128),
	  __webpack_require__(130),
	  __webpack_require__(133),
	  __webpack_require__(135)
	];


/***/ },
/* 121 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var isInteger = __webpack_require__(8).isInteger;
	var bigBitAnd = __webpack_require__(122);

	function factory (type, config, load, typed) {
	  var latex = __webpack_require__(26);

	  var matrix = load(__webpack_require__(23));

	  var algorithm02 = load(__webpack_require__(96));
	  var algorithm06 = load(__webpack_require__(107));
	  var algorithm11 = load(__webpack_require__(42));
	  var algorithm13 = load(__webpack_require__(35));
	  var algorithm14 = load(__webpack_require__(39));
	  
	  /**
	   * Bitwise AND two values, `x & y`.
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.bitAnd(x, y)
	   *
	   * Examples:
	   *
	   *    math.bitAnd(53, 131);               // returns number 1
	   *
	   *    math.bitAnd([1, 12, 31], 42);       // returns Array [0, 8, 10]
	   *
	   * See also:
	   *
	   *    bitNot, bitOr, bitXor, leftShift, rightArithShift, rightLogShift
	   *
	   * @param  {number | BigNumber | Array | Matrix} x First value to and
	   * @param  {number | BigNumber | Array | Matrix} y Second value to and
	   * @return {number | BigNumber | Array | Matrix} AND of `x` and `y`
	   */
	  var bitAnd = typed('bitAnd', {

	    'number, number': function (x, y) {
	      if (!isInteger(x) || !isInteger(y)) {
	        throw new Error('Integers expected in function bitAnd');
	      }

	      return x & y;
	    },

	    'BigNumber, BigNumber': bigBitAnd,

	    'Matrix, Matrix': function (x, y) {
	      // result
	      var c;

	      // process matrix storage
	      switch (x.storage()) {
	        case 'sparse':
	          switch (y.storage()) {
	            case 'sparse':
	              // sparse & sparse
	              c = algorithm06(x, y, bitAnd, false);
	              break;
	            default:
	              // sparse & dense
	              c = algorithm02(y, x, bitAnd, true);
	              break;
	          }
	          break;
	        default:
	          switch (y.storage()) {
	            case 'sparse':
	              // dense & sparse
	              c = algorithm02(x, y, bitAnd, false);
	              break;
	            default:
	              // dense & dense
	              c = algorithm13(x, y, bitAnd);
	              break;
	          }
	          break;
	      }
	      return c;
	    },
	    
	    'Array, Array': function (x, y) {
	      // use matrix implementation
	      return bitAnd(matrix(x), matrix(y)).valueOf();
	    },

	    'Array, Matrix': function (x, y) {
	      // use matrix implementation
	      return bitAnd(matrix(x), y);
	    },

	    'Matrix, Array': function (x, y) {
	      // use matrix implementation
	      return bitAnd(x, matrix(y));
	    },
	    
	    'Matrix, any': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (x.storage()) {
	        case 'sparse':
	          c = algorithm11(x, y, bitAnd, false);
	          break;
	        default:
	          c = algorithm14(x, y, bitAnd, false);
	          break;
	      }
	      return c;
	    },

	    'any, Matrix': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (y.storage()) {
	        case 'sparse':
	          c = algorithm11(y, x, bitAnd, true);
	          break;
	        default:
	          c = algorithm14(y, x, bitAnd, true);
	          break;
	      }
	      return c;
	    },

	    'Array, any': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(x), y, bitAnd, false).valueOf();
	    },

	    'any, Array': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(y), x, bitAnd, true).valueOf();
	    }
	  });

	  bitAnd.toTex = '\\left(${args[0]}' + latex.operators['bitAnd'] + '${args[1]}\\right)';

	  return bitAnd;
	}

	exports.name = 'bitAnd';
	exports.factory = factory;


/***/ },
/* 122 */
/***/ function(module, exports, __webpack_require__) {

	var bitwise = __webpack_require__(123);

	/**
	 * Bitwise and for Bignumbers
	 *
	 * Special Cases:
	 *   N &  n =  N
	 *   n &  0 =  0
	 *   n & -1 =  n
	 *   n &  n =  n
	 *   I &  I =  I
	 *  -I & -I = -I
	 *   I & -I =  0
	 *   I &  n =  n
	 *   I & -n =  I
	 *  -I &  n =  0
	 *  -I & -n = -I
	 *
	 * @param {BigNumber} x
	 * @param {BigNumber} y
	 * @return {BigNumber} Result of `x` & `y`, is fully precise
	 * @private
	 */
	module.exports = function bitAnd(x, y) {
	  if ((x.isFinite() && !x.isInteger()) || (y.isFinite() && !y.isInteger())) {
	    throw new Error('Integers expected in function bitAnd');
	  }

	  var BigNumber = x.constructor;
	  if (x.isNaN() || y.isNaN()) {
	    return new BigNumber(NaN);
	  }

	  if (x.isZero() || y.eq(-1) || x.eq(y)) {
	    return x;
	  }
	  if (y.isZero() || x.eq(-1)) {
	    return y;
	  }

	  if (!x.isFinite() || !y.isFinite()) {
	    if (!x.isFinite() && !y.isFinite()) {
	      if (x.isNegative() == y.isNegative()) {
	        return x;
	      }
	      return new BigNumber(0);
	    }
	    if (!x.isFinite()) {
	      if (y.isNegative()) {
	        return x;
	      }
	      if (x.isNegative()) {
	        return new BigNumber(0);
	      }
	      return y;
	    }
	    if (!y.isFinite()) {
	      if (x.isNegative()) {
	        return y;
	      }
	      if (y.isNegative()) {
	        return new BigNumber(0);
	      }
	      return x;
	    }
	  }
	  return bitwise(x, y, function (a, b) { return a & b });
	};


/***/ },
/* 123 */
/***/ function(module, exports, __webpack_require__) {

	var bitNot = __webpack_require__(124);

	/**
	 * Applies bitwise function to numbers
	 * @param {BigNumber} x
	 * @param {BigNumber} y
	 * @param {function (a, b)} func
	 * @return {BigNumber}
	 */
	module.exports = function bitwise(x, y, func) {
	  var BigNumber = x.constructor;

	  var xBits, yBits;
	  var xSign = +(x.s < 0);
	  var ySign = +(y.s < 0);
	  if (xSign) {
	    xBits = decCoefficientToBinaryString(bitNot(x));
	    for (var i = 0; i < xBits.length; ++i) {
	      xBits[i] ^= 1;
	    }
	  } else {
	    xBits = decCoefficientToBinaryString(x);
	  }
	  if (ySign) {
	    yBits = decCoefficientToBinaryString(bitNot(y));
	    for (var i = 0; i < yBits.length; ++i) {
	      yBits[i] ^= 1;
	    }
	  } else {
	    yBits = decCoefficientToBinaryString(y);
	  }

	  var minBits, maxBits, minSign;
	  if (xBits.length <= yBits.length) {
	    minBits = xBits;
	    maxBits = yBits;
	    minSign = xSign;
	  } else {
	    minBits = yBits;
	    maxBits = xBits;
	    minSign = ySign;
	  }

	  var shortLen = minBits.length;
	  var longLen = maxBits.length;
	  var expFuncVal = func(xSign, ySign) ^ 1;
	  var outVal = new BigNumber(expFuncVal ^ 1);
	  var twoPower = BigNumber.ONE;
	  var two = new BigNumber(2);

	  var prevPrec = BigNumber.precision;
	  BigNumber.config({precision: 1E9});

	  while (shortLen > 0) {
	    if (func(minBits[--shortLen], maxBits[--longLen]) == expFuncVal) {
	      outVal = outVal.plus(twoPower);
	    }
	    twoPower = twoPower.times(two);
	  }
	  while (longLen > 0) {
	    if (func(minSign, maxBits[--longLen]) == expFuncVal) {
	      outVal = outVal.plus(twoPower);
	    }
	    twoPower = twoPower.times(two);
	  }

	  BigNumber.config({precision: prevPrec});

	  if (expFuncVal == 0) {
	    outVal.s = -outVal.s;
	  }
	  return outVal;
	};

	/* Extracted from decimal.js, and edited to specialize. */
	function decCoefficientToBinaryString (x) {
	  // Convert to string
	  var a = x.c;
	  var r = a[0] + '';

	  for (var i = 1; i < a.length; ++i) {
	    var s = a[i] + '';
	    for (var z = 7 - s.length; z--; ) {
	      s = '0' + s;
	    }

	    r += s;
	  }

	  var j;
	  for (j = r.length - 1; r.charAt(j) == '0'; --j);

	  var xe = x.e;
	  var str = r.slice(0, j + 1 || 1);
	  var strL = str.length;
	  if (xe > 0) {
	    if (++xe > strL) {
	      // Append zeros.
	      for (xe -= strL; xe--; str += '0');
	    } else if (xe < strL) {
	      str = str.slice(0, xe) + '.' + str.slice(xe);
	    }
	  }

	  // Convert from base 10 (decimal) to base 2
	  var arr = [0];
	  for (var i = 0; i < str.length; ) {
	    for (var arrL = arr.length; arrL--; arr[arrL] *= 10);

	    arr[0] += str.charAt(i++) << 0;  // convert to int
	    for (var j = 0; j < arr.length; ++j) {
	      if (arr[j] > 1) {
	        if (arr[j + 1] == null) {
	          arr[j + 1] = 0;
	        }

	        arr[j + 1] += arr[j] >> 1;
	        arr[j] &= 1;
	      }
	    }
	  }

	  return arr.reverse();
	}


/***/ },
/* 124 */
/***/ function(module, exports) {

	/**
	 * Bitwise not
	 * @param {BigNumber} value
	 * @return {BigNumber} Result of ~`x`, fully precise
	 *
	 */
	module.exports = function bitNot (x) {
	  if (x.isFinite() && !x.isInteger()) {
	    throw new Error('Integer expected in function bitNot');
	  }

	  var BigNumber = x.constructor;
	  var prevPrec = BigNumber.precision;
	  BigNumber.config({precision: 1E9});

	  var x = x.plus(BigNumber.ONE);
	  x.s = -x.s || null;

	  BigNumber.config({precision: prevPrec});
	  return x;
	};


/***/ },
/* 125 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);
	var bigBitNot = __webpack_require__(124);
	var isInteger = __webpack_require__(8).isInteger;

	function factory (type, config, load, typed) {
	  var latex = __webpack_require__(26);

	  /**
	   * Bitwise NOT value, `~x`.
	   * For matrices, the function is evaluated element wise.
	   * For units, the function is evaluated on the best prefix base.
	   *
	   * Syntax:
	   *
	   *    math.bitNot(x)
	   *
	   * Examples:
	   *
	   *    math.bitNot(1);               // returns number -2
	   *
	   *    math.bitNot([2, -3, 4]);      // returns Array [-3, 2, 5]
	   *
	   * See also:
	   *
	   *    bitAnd, bitOr, bitXor, leftShift, rightArithShift, rightLogShift
	   *
	   * @param  {number | BigNumber | Array | Matrix} x Value to not
	   * @return {number | BigNumber | Array | Matrix} NOT of `x`
	   */
	  var bitNot = typed('bitNot', {
	    'number': function (x) {
	      if (!isInteger(x)) {
	        throw new Error('Integer expected in function bitNot');
	      }

	      return ~x;
	    },

	    'BigNumber': bigBitNot,

	    'Array | Matrix': function (x) {
	      return deepMap(x, bitNot);
	    }
	  });

	  bitNot.toTex = latex.operators['bitNot'] + '\\left(${args[0]}\\right)';

	  return bitNot;
	}

	exports.name = 'bitNot';
	exports.factory = factory;


/***/ },
/* 126 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var isInteger = __webpack_require__(8).isInteger;
	var bigBitOr = __webpack_require__(127);

	function factory (type, config, load, typed) {
	  var latex = __webpack_require__(26);

	  var matrix = load(__webpack_require__(23));

	  var algorithm01 = load(__webpack_require__(30));
	  var algorithm04 = load(__webpack_require__(45));
	  var algorithm10 = load(__webpack_require__(34));
	  var algorithm13 = load(__webpack_require__(35));
	  var algorithm14 = load(__webpack_require__(39));
	  
	  /**
	   * Bitwise OR two values, `x | y`.
	   * For matrices, the function is evaluated element wise.
	   * For units, the function is evaluated on the lowest print base.
	   *
	   * Syntax:
	   *
	   *    math.bitOr(x, y)
	   *
	   * Examples:
	   *
	   *    math.bitOr(1, 2);               // returns number 3
	   *
	   *    math.bitOr([1, 2, 3], 4);       // returns Array [5, 6, 7]
	   *
	   * See also:
	   *
	   *    bitAnd, bitNot, bitXor, leftShift, rightArithShift, rightLogShift
	   *
	   * @param  {number | BigNumber | Array | Matrix} x First value to or
	   * @param  {number | BigNumber | Array | Matrix} y Second value to or
	   * @return {number | BigNumber | Array | Matrix} OR of `x` and `y`
	   */
	  var bitOr = typed('bitOr', {

	    'number, number': function (x, y) {
	      if (!isInteger(x) || !isInteger(y)) {
	        throw new Error('Integers expected in function bitOr');
	      }

	      return x | y;
	    },

	    'BigNumber, BigNumber': bigBitOr,

	    'Matrix, Matrix': function (x, y) {
	      // result
	      var c;

	      // process matrix storage
	      switch (x.storage()) {
	        case 'sparse':
	          switch (y.storage()) {
	            case 'sparse':
	              // sparse + sparse
	              c = algorithm04(x, y, bitOr);
	              break;
	            default:
	              // sparse + dense
	              c = algorithm01(y, x, bitOr, true);
	              break;
	          }
	          break;
	        default:
	          switch (y.storage()) {
	            case 'sparse':
	              // dense + sparse
	              c = algorithm01(x, y, bitOr, false);
	              break;
	            default:
	              c = algorithm13(x, y, bitOr);
	              break;
	          }
	          break;
	      }
	      return c;
	    },

	    'Array, Array': function (x, y) {
	      // use matrix implementation
	      return bitOr(matrix(x), matrix(y)).valueOf();
	    },

	    'Array, Matrix': function (x, y) {
	      // use matrix implementation
	      return bitOr(matrix(x), y);
	    },

	    'Matrix, Array': function (x, y) {
	      // use matrix implementation
	      return bitOr(x, matrix(y));
	    },

	    'Matrix, any': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (x.storage()) {
	        case 'sparse':
	          c = algorithm10(x, y, bitOr, false);
	          break;
	        default:
	          c = algorithm14(x, y, bitOr, false);
	          break;
	      }
	      return c;
	    },

	    'any, Matrix': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (y.storage()) {
	        case 'sparse':
	          c = algorithm10(y, x, bitOr, true);
	          break;
	        default:
	          c = algorithm14(y, x, bitOr, true);
	          break;
	      }
	      return c;
	    },

	    'Array, any': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(x), y, bitOr, false).valueOf();
	    },

	    'any, Array': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(y), x, bitOr, true).valueOf();
	    }
	  });

	  bitOr.toTex = '\\left(${args[0]}' + latex.operators['bitOr'] + '${args[1]}\\right)';

	  return bitOr;
	}

	exports.name = 'bitOr';
	exports.factory = factory;


/***/ },
/* 127 */
/***/ function(module, exports, __webpack_require__) {

	var bitwise = __webpack_require__(123);

	/**
	 * Bitwise OR for BigNumbers
	 *
	 * Special Cases:
	 *   N |  n =  N
	 *   n |  0 =  n
	 *   n | -1 = -1
	 *   n |  n =  n
	 *   I |  I =  I
	 *  -I | -I = -I
	 *   I | -n = -1
	 *   I | -I = -1
	 *   I |  n =  I
	 *  -I |  n = -I
	 *  -I | -n = -n
	 *
	 * @param {BigNumber} x
	 * @param {BigNumber} y
	 * @return {BigNumber} Result of `x` | `y`, fully precise
	 */
	module.exports = function bitOr (x, y) {
	  if ((x.isFinite() && !x.isInteger()) || (y.isFinite() && !y.isInteger())) {
	    throw new Error('Integers expected in function bitOr');
	  }

	  var BigNumber = x.constructor;
	  if (x.isNaN() || y.isNaN()) {
	    return new BigNumber(NaN);
	  }

	  var negOne = new BigNumber(-1);
	  if (x.isZero() || y.eq(negOne) || x.eq(y)) {
	    return y;
	  }
	  if (y.isZero() || x.eq(negOne)) {
	    return x;
	  }

	  if (!x.isFinite() || !y.isFinite()) {
	    if ((!x.isFinite() && !x.isNegative() && y.isNegative()) ||
	        (x.isNegative() && !y.isNegative() && !y.isFinite())) {
	      return negOne;
	    }
	    if (x.isNegative() && y.isNegative()) {
	      return x.isFinite() ? x : y;
	    }
	    return x.isFinite() ? y : x;
	  }

	  return bitwise(x, y, function (a, b) { return a | b });
	};


/***/ },
/* 128 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var isInteger = __webpack_require__(8).isInteger;
	var bigBitXor = __webpack_require__(129);

	function factory (type, config, load, typed) {
	  var latex = __webpack_require__(26);

	  var matrix = load(__webpack_require__(23));

	  var algorithm03 = load(__webpack_require__(31));
	  var algorithm07 = load(__webpack_require__(66));
	  var algorithm12 = load(__webpack_require__(65));
	  var algorithm13 = load(__webpack_require__(35));
	  var algorithm14 = load(__webpack_require__(39));

	  /**
	   * Bitwise XOR two values, `x ^ y`.
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.bitXor(x, y)
	   *
	   * Examples:
	   *
	   *    math.bitXor(1, 2);               // returns number 3
	   *
	   *    math.bitXor([2, 3, 4], 4);       // returns Array [6, 7, 0]
	   *
	   * See also:
	   *
	   *    bitAnd, bitNot, bitOr, leftShift, rightArithShift, rightLogShift
	   *
	   * @param  {number | BigNumber | Array | Matrix} x First value to xor
	   * @param  {number | BigNumber | Array | Matrix} y Second value to xor
	   * @return {number | BigNumber | Array | Matrix} XOR of `x` and `y`
	   */
	  var bitXor = typed('bitXor', {

	    'number, number': function (x, y) {
	      if (!isInteger(x) || !isInteger(y)) {
	        throw new Error('Integers expected in function bitXor');
	      }

	      return x ^ y;
	    },

	    'BigNumber, BigNumber': bigBitXor,

	    'Matrix, Matrix': function (x, y) {
	      // result
	      var c;

	      // process matrix storage
	      switch (x.storage()) {
	        case 'sparse':
	          switch (y.storage()) {
	            case 'sparse':
	              // sparse + sparse
	              c = algorithm07(x, y, bitXor);
	              break;
	            default:
	              // sparse + dense
	              c = algorithm03(y, x, bitXor, true);
	              break;
	          }
	          break;
	        default:
	          switch (y.storage()) {
	            case 'sparse':
	              // dense + sparse
	              c = algorithm03(x, y, bitXor, false);
	              break;
	            default:
	              // dense + dense
	              c = algorithm13(x, y, bitXor);
	              break;
	          }
	          break;
	      }
	      return c;
	    },

	    'Array, Array': function (x, y) {
	      // use matrix implementation
	      return bitXor(matrix(x), matrix(y)).valueOf();
	    },

	    'Array, Matrix': function (x, y) {
	      // use matrix implementation
	      return bitXor(matrix(x), y);
	    },

	    'Matrix, Array': function (x, y) {
	      // use matrix implementation
	      return bitXor(x, matrix(y));
	    },

	    'Matrix, any': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (x.storage()) {
	        case 'sparse':
	          c = algorithm12(x, y, bitXor, false);
	          break;
	        default:
	          c = algorithm14(x, y, bitXor, false);
	          break;
	      }
	      return c;
	    },

	    'any, Matrix': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (y.storage()) {
	        case 'sparse':
	          c = algorithm12(y, x, bitXor, true);
	          break;
	        default:
	          c = algorithm14(y, x, bitXor, true);
	          break;
	      }
	      return c;
	    },

	    'Array, any': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(x), y, bitXor, false).valueOf();
	    },

	    'any, Array': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(y), x, bitXor, true).valueOf();
	    }
	  });

	  bitXor.toTex = '\\left(${args[0]}' + latex.operators['bitXor'] + '${args[1]}\\right)';

	  return bitXor;
	}

	exports.name = 'bitXor';
	exports.factory = factory;


/***/ },
/* 129 */
/***/ function(module, exports, __webpack_require__) {

	var bitwise = __webpack_require__(123);
	var bitNot = __webpack_require__(124);

	/**
	 * Bitwise XOR for BigNumbers
	 *
	 * Special Cases:
	 *   N ^  n =  N
	 *   n ^  0 =  n
	 *   n ^  n =  0
	 *   n ^ -1 = ~n
	 *   I ^  n =  I
	 *   I ^ -n = -I
	 *   I ^ -I = -1
	 *  -I ^  n = -I
	 *  -I ^ -n =  I
	 *
	 * @param {BigNumber} x
	 * @param {BigNumber} y
	 * @return {BigNumber} Result of `x` ^ `y`, fully precise
	 *
	 */
	module.exports = function bitXor(x, y) {
	  if ((x.isFinite() && !x.isInteger()) || (y.isFinite() && !y.isInteger())) {
	    throw new Error('Integers expected in function bitXor');
	  }

	  var BigNumber = x.constructor;
	  if (x.isNaN() || y.isNaN()) {
	    return new BigNumber(NaN);
	  }
	  if (x.isZero()) {
	    return y;
	  }
	  if (y.isZero()) {
	    return x;
	  }

	  if (x.eq(y)) {
	    return new BigNumber(0);
	  }

	  var negOne = new BigNumber(-1);
	  if (x.eq(negOne)) {
	    return bitNot(y);
	  }
	  if (y.eq(negOne)) {
	    return bitNot(x);
	  }

	  if (!x.isFinite() || !y.isFinite()) {
	    if (!x.isFinite() && !y.isFinite()) {
	      return negOne;
	    }
	    return new BigNumber(x.isNegative() == y.isNegative()
	        ?  Infinity
	        : -Infinity);
	  }
	  return bitwise(x, y, function (a, b) { return a ^ b });
	};


/***/ },
/* 130 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var isInteger = __webpack_require__(8).isInteger;
	var bigLeftShift = __webpack_require__(131);

	function factory (type, config, load, typed) {
	  var latex = __webpack_require__(26);

	  var matrix = load(__webpack_require__(23));
	  var equalScalar = load(__webpack_require__(33));
	  var zeros = load(__webpack_require__(60));

	  var algorithm01 = load(__webpack_require__(30));
	  var algorithm02 = load(__webpack_require__(96));
	  var algorithm08 = load(__webpack_require__(132));
	  var algorithm10 = load(__webpack_require__(34));
	  var algorithm11 = load(__webpack_require__(42));
	  var algorithm13 = load(__webpack_require__(35));
	  var algorithm14 = load(__webpack_require__(39));

	  /**
	   * Bitwise left logical shift of a value x by y number of bits, `x << y`.
	   * For matrices, the function is evaluated element wise.
	   * For units, the function is evaluated on the best prefix base.
	   *
	   * Syntax:
	   *
	   *    math.leftShift(x, y)
	   *
	   * Examples:
	   *
	   *    math.leftShift(1, 2);               // returns number 4
	   *
	   *    math.leftShift([1, 2, 3], 4);       // returns Array [16, 32, 64]
	   *
	   * See also:
	   *
	   *    leftShift, bitNot, bitOr, bitXor, rightArithShift, rightLogShift
	   *
	   * @param  {number | BigNumber | Array | Matrix} x Value to be shifted
	   * @param  {number | BigNumber} y Amount of shifts
	   * @return {number | BigNumber | Array | Matrix} `x` shifted left `y` times
	   */
	  var leftShift = typed('leftShift', {
	    
	    'number, number': function (x, y) {
	      if (!isInteger(x) || !isInteger(y)) {
	        throw new Error('Integers expected in function leftShift');
	      }

	      return x << y;
	    },

	    'BigNumber, BigNumber': bigLeftShift,

	    'Matrix, Matrix': function (x, y) {
	      // result
	      var c;

	      // process matrix storage
	      switch (x.storage()) {
	        case 'sparse':
	          switch (y.storage()) {
	            case 'sparse':
	              // sparse & sparse
	              c = algorithm08(x, y, leftShift, false);
	              break;
	            default:
	              // sparse & dense
	              c = algorithm02(y, x, leftShift, true);
	              break;
	          }
	          break;
	        default:
	          switch (y.storage()) {
	            case 'sparse':
	              // dense & sparse
	              c = algorithm01(x, y, leftShift, false);
	              break;
	            default:
	              // dense & dense
	              c = algorithm13(x, y, leftShift);
	              break;
	          }
	          break;
	      }
	      return c;
	    },

	    'Array, Array': function (x, y) {
	      // use matrix implementation
	      return leftShift(matrix(x), matrix(y)).valueOf();
	    },

	    'Array, Matrix': function (x, y) {
	      // use matrix implementation
	      return leftShift(matrix(x), y);
	    },

	    'Matrix, Array': function (x, y) {
	      // use matrix implementation
	      return leftShift(x, matrix(y));
	    },

	    'Matrix, number | BigNumber': function (x, y) {
	      // check scalar
	      if (!equalScalar(y, 0)) {
	        // result
	        var c;
	        // check storage format
	        switch (x.storage()) {
	          case 'sparse':
	            c = algorithm11(x, y, leftShift, false);
	            break;
	          default:
	            c = algorithm14(x, y, leftShift, false);
	            break;
	        }
	        return c;
	      }
	      return x.clone();
	    },

	    'number | BigNumber, Matrix': function (x, y) {
	      // check scalar
	      if (!equalScalar(x, 0)) {
	        // result
	        var c;
	        // check storage format
	        switch (y.storage()) {
	          case 'sparse':
	            c = algorithm10(y, x, leftShift, true);
	            break;
	          default:
	            c = algorithm14(y, x, leftShift, true);
	            break;
	        }
	        return c;
	      }
	      return zeros(y.size(), y.storage());
	    },

	    'Array, number | BigNumber': function (x, y) {
	      // use matrix implementation
	      return leftShift(matrix(x), y).valueOf();
	    },

	    'number | BigNumber, Array': function (x, y) {
	      // use matrix implementation
	      return leftShift(x, matrix(y)).valueOf();
	    }
	  });

	  leftShift.toTex = '\\left(${args[0]}' + latex.operators['leftShift'] + '${args[1]}\\right)';

	  return leftShift;
	}

	exports.name = 'leftShift';
	exports.factory = factory;


/***/ },
/* 131 */
/***/ function(module, exports) {

	
	/**
	 * Bitwise left shift
	 *
	 * Special Cases:
	 *  n << -n = N
	 *  n <<  N = N
	 *  N <<  n = N
	 *  n <<  0 = n
	 *  0 <<  n = 0
	 *  I <<  I = N
	 *  I <<  n = I
	 *  n <<  I = I
	 *
	 * @param {BigNumber} x
	 * @param {BigNumber} y
	 * @return {BigNumber} Result of `x` << `y`
	 *
	 */
	module.exports = function leftShift (x, y) {
	  if ((x.isFinite() && !x.isInteger()) || (y.isFinite() && !y.isInteger())) {
	    throw new Error('Integers expected in function leftShift');
	  }

	  var BigNumber = x.constructor;
	  if (x.isNaN() || y.isNaN() || (y.isNegative() && !y.isZero())) {
	    return new BigNumber(NaN);
	  }
	  if (x.isZero() || y.isZero()) {
	    return x;
	  }
	  if (!x.isFinite() && !y.isFinite()) {
	    return new BigNumber(NaN);
	  }

	  // Math.pow(2, y) is fully precise for y < 55, and fast
	  if (y.lt(55)) {
	    return x.times(Math.pow(2, y.toNumber()) + '');
	  }
	  return x.times(new BigNumber(2).pow(y));
	};


/***/ },
/* 132 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var DimensionError = __webpack_require__(22);

	function factory (type, config, load, typed) {

	  var equalScalar = load(__webpack_require__(33));

	  var SparseMatrix = type.SparseMatrix;

	  /**
	   * Iterates over SparseMatrix A and SparseMatrix B nonzero items and invokes the callback function f(Aij, Bij). 
	   * Callback function invoked MAX(NNZA, NNZB) times
	   *
	   *
	   *          ┌  f(Aij, Bij)  ; A(i,j) !== 0 && B(i,j) !== 0
	   * C(i,j) = ┤  A(i,j)       ; A(i,j) !== 0
	   *          └  0            ; otherwise
	   *
	   *
	   * @param {Matrix}   a                 The SparseMatrix instance (A)
	   * @param {Matrix}   b                 The SparseMatrix instance (B)
	   * @param {Function} callback          The f(Aij,Bij) operation to invoke
	   *
	   * @return {Matrix}                    SparseMatrix (C)
	   *
	   * see https://github.com/josdejong/mathjs/pull/346#issuecomment-97620294
	   */
	  var algorithm08 = function (a, b, callback) {
	    // sparse matrix arrays
	    var avalues = a._values;
	    var aindex = a._index;
	    var aptr = a._ptr;
	    var asize = a._size;
	    var adt = a._datatype;
	    // sparse matrix arrays
	    var bvalues = b._values;
	    var bindex = b._index;
	    var bptr = b._ptr;
	    var bsize = b._size;
	    var bdt = b._datatype;

	    // validate dimensions
	    if (asize.length !== bsize.length)
	      throw new DimensionError(asize.length, bsize.length);

	    // check rows & columns
	    if (asize[0] !== bsize[0] || asize[1] !== bsize[1])
	      throw new RangeError('Dimension mismatch. Matrix A (' + asize + ') must match Matrix B (' + bsize + ')');

	    // sparse matrix cannot be a Pattern matrix
	    if (!avalues || !bvalues)
	      throw new Error('Cannot perform operation on Pattern Sparse Matrices');

	    // rows & columns
	    var rows = asize[0];
	    var columns = asize[1];

	    // datatype
	    var dt;
	    // equal signature to use
	    var eq = equalScalar;
	    // zero value
	    var zero = 0;
	    // callback signature to use
	    var cf = callback;

	    // process data types
	    if (typeof adt === 'string' && adt === bdt) {
	      // datatype
	      dt = adt;
	      // find signature that matches (dt, dt)
	      eq = typed.find(equalScalar, [dt, dt]);
	      // convert 0 to the same datatype
	      zero = typed.convert(0, dt);
	      // callback
	      cf = typed.find(callback, [dt, dt]);
	    }

	    // result arrays
	    var cvalues = [];
	    var cindex = [];
	    var cptr = [];
	    // matrix
	    var c = new SparseMatrix({
	      values: cvalues,
	      index: cindex,
	      ptr: cptr,
	      size: [rows, columns],
	      datatype: dt
	    });

	    // workspace
	    var x = [];
	    // marks indicating we have a value in x for a given column
	    var w = [];

	    // vars
	    var k, k0, k1, i;

	    // loop columns
	    for (var j = 0; j < columns; j++) {
	      // update cptr
	      cptr[j] = cindex.length;
	      // columns mark
	      var mark = j + 1;
	      // loop values in a
	      for (k0 = aptr[j], k1 = aptr[j + 1], k = k0; k < k1; k++) {
	        // row
	        i = aindex[k];
	        // mark workspace
	        w[i] = mark;
	        // set value
	        x[i] = avalues[k];
	        // add index
	        cindex.push(i);
	      }
	      // loop values in b
	      for (k0 = bptr[j], k1 = bptr[j + 1], k = k0; k < k1; k++) {
	        // row
	        i = bindex[k];
	        // check value exists in workspace
	        if (w[i] === mark) {
	          // evaluate callback
	          x[i] = cf(x[i], bvalues[k]);
	        }
	      }
	      // initialize first index in j
	      k = cptr[j];
	      // loop index in j
	      while (k < cindex.length) {
	        // row
	        i = cindex[k];
	        // value @ i
	        var v = x[i];
	        // check for zero value
	        if (!eq(v, zero)) {
	          // push value
	          cvalues.push(v);
	          // increment pointer
	          k++;
	        }
	        else {
	          // remove value @ i, do not increment pointer
	          cindex.splice(k, 1);
	        }
	      }      
	    }
	    // update cptr
	    cptr[columns] = cindex.length;

	    // return sparse matrix
	    return c;
	  };

	  return algorithm08;
	}

	exports.name = 'algorithm08';
	exports.factory = factory;


/***/ },
/* 133 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var isInteger = __webpack_require__(8).isInteger;
	var bigRightArithShift = __webpack_require__(134);

	function factory (type, config, load, typed) {
	  var latex = __webpack_require__(26);
	  
	  var matrix = load(__webpack_require__(23));
	  var equalScalar = load(__webpack_require__(33));
	  var zeros = load(__webpack_require__(60));

	  var algorithm01 = load(__webpack_require__(30));
	  var algorithm02 = load(__webpack_require__(96));
	  var algorithm08 = load(__webpack_require__(132));
	  var algorithm10 = load(__webpack_require__(34));
	  var algorithm11 = load(__webpack_require__(42));
	  var algorithm13 = load(__webpack_require__(35));
	  var algorithm14 = load(__webpack_require__(39));

	  /**
	   * Bitwise right arithmetic shift of a value x by y number of bits, `x >> y`.
	   * For matrices, the function is evaluated element wise.
	   * For units, the function is evaluated on the best prefix base.
	   *
	   * Syntax:
	   *
	   *    math.rightArithShift(x, y)
	   *
	   * Examples:
	   *
	   *    math.rightArithShift(4, 2);               // returns number 1
	   *
	   *    math.rightArithShift([16, -32, 64], 4);   // returns Array [1, -2, 3]
	   *
	   * See also:
	   *
	   *    bitAnd, bitNot, bitOr, bitXor, rightArithShift, rightLogShift
	   *
	   * @param  {number | BigNumber | Array | Matrix} x Value to be shifted
	   * @param  {number | BigNumber} y Amount of shifts
	   * @return {number | BigNumber | Array | Matrix} `x` sign-filled shifted right `y` times
	   */
	  var rightArithShift = typed('rightArithShift', {

	    'number, number': function (x, y) {
	      if (!isInteger(x) || !isInteger(y)) {
	        throw new Error('Integers expected in function rightArithShift');
	      }

	      return x >> y;
	    },

	    'BigNumber, BigNumber': bigRightArithShift,

	    'Matrix, Matrix': function (x, y) {
	      // result
	      var c;

	      // process matrix storage
	      switch (x.storage()) {
	        case 'sparse':
	          switch (y.storage()) {
	            case 'sparse':
	              // sparse & sparse
	              c = algorithm08(x, y, rightArithShift, false);
	              break;
	            default:
	              // sparse & dense
	              c = algorithm02(y, x, rightArithShift, true);
	              break;
	          }
	          break;
	        default:
	          switch (y.storage()) {
	            case 'sparse':
	              // dense & sparse
	              c = algorithm01(x, y, rightArithShift, false);
	              break;
	            default:
	              // dense & dense
	              c = algorithm13(x, y, rightArithShift);
	              break;
	          }
	          break;
	      }
	      return c;
	    },

	    'Array, Array': function (x, y) {
	      // use matrix implementation
	      return rightArithShift(matrix(x), matrix(y)).valueOf();
	    },

	    'Array, Matrix': function (x, y) {
	      // use matrix implementation
	      return rightArithShift(matrix(x), y);
	    },

	    'Matrix, Array': function (x, y) {
	      // use matrix implementation
	      return rightArithShift(x, matrix(y));
	    },

	    'Matrix, number | BigNumber': function (x, y) {
	      // check scalar
	      if (!equalScalar(y, 0)) {
	        // result
	        var c;
	        // check storage format
	        switch (x.storage()) {
	          case 'sparse':
	            c = algorithm11(x, y, rightArithShift, false);
	            break;
	          default:
	            c = algorithm14(x, y, rightArithShift, false);
	            break;
	        }
	        return c;
	      }
	      return x.clone();
	    },

	    'number | BigNumber, Matrix': function (x, y) {
	      // check scalar
	      if (!equalScalar(x, 0)) {
	        // result
	        var c;
	        // check storage format
	        switch (y.storage()) {
	          case 'sparse':
	            c = algorithm10(y, x, rightArithShift, true);
	            break;
	          default:
	            c = algorithm14(y, x, rightArithShift, true);
	            break;
	        }
	        return c;
	      }
	      return zeros(y.size(), y.storage());
	    },

	    'Array, number | BigNumber': function (x, y) {
	      // use matrix implementation
	      return rightArithShift(matrix(x), y).valueOf();
	    },

	    'number | BigNumber, Array': function (x, y) {
	      // use matrix implementation
	      return rightArithShift(x, matrix(y)).valueOf();
	    }
	  });

	  rightArithShift.toTex = '\\left(${args[0]}' + latex.operators['rightArithShift'] + '${args[1]}\\right)';

	  return rightArithShift;
	}

	exports.name = 'rightArithShift';
	exports.factory = factory;


/***/ },
/* 134 */
/***/ function(module, exports) {

	/*
	 * Special Cases:
	 *   n >> -n =  N
	 *   n >>  N =  N
	 *   N >>  n =  N
	 *   I >>  I =  N
	 *   n >>  0 =  n
	 *   I >>  n =  I
	 *  -I >>  n = -I
	 *  -I >>  I = -I
	 *   n >>  I =  I
	 *  -n >>  I = -1
	 *   0 >>  n =  0
	 *
	 * @param {BigNumber} value
	 * @param {BigNumber} value
	 * @return {BigNumber} Result of `x` >> `y`
	 *
	 */
	module.exports = function rightArithShift (x, y) {
	  if ((x.isFinite() && !x.isInteger()) || (y.isFinite() && !y.isInteger())) {
	    throw new Error('Integers expected in function rightArithShift');
	  }

	  var BigNumber = x.constructor;
	  if (x.isNaN() || y.isNaN() || (y.isNegative() && !y.isZero())) {
	    return new BigNumber(NaN);
	  }
	  if (x.isZero() || y.isZero()) {
	    return x;
	  }
	  if (!y.isFinite()) {
	    if (x.isNegative()) {
	      return new BigNumber(-1);
	    }
	    if (!x.isFinite()) {
	      return new BigNumber(NaN);
	    }
	    return new BigNumber(0);
	  }

	  // Math.pow(2, y) is fully precise for y < 55, and fast
	  if (y.lt(55)) {
	    return x.div(Math.pow(2, y.toNumber()) + '').floor();
	  }
	  return x.div(new BigNumber(2).pow(y)).floor();
	};


/***/ },
/* 135 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var isInteger = __webpack_require__(8).isInteger;

	function factory (type, config, load, typed) {
	  var latex = __webpack_require__(26);

	  var matrix = load(__webpack_require__(23));
	  var equalScalar = load(__webpack_require__(33));
	  var zeros = load(__webpack_require__(60));

	  var algorithm01 = load(__webpack_require__(30));
	  var algorithm02 = load(__webpack_require__(96));
	  var algorithm08 = load(__webpack_require__(132));
	  var algorithm10 = load(__webpack_require__(34));
	  var algorithm11 = load(__webpack_require__(42));
	  var algorithm13 = load(__webpack_require__(35));
	  var algorithm14 = load(__webpack_require__(39));
	  
	  /**
	   * Bitwise right logical shift of value x by y number of bits, `x >>> y`.
	   * For matrices, the function is evaluated element wise.
	   * For units, the function is evaluated on the best prefix base.
	   *
	   * Syntax:
	   *
	   *    math.rightLogShift(x, y)
	   *
	   * Examples:
	   *
	   *    math.rightLogShift(4, 2);               // returns number 1
	   *
	   *    math.rightLogShift([16, -32, 64], 4);   // returns Array [1, 2, 3]
	   *
	   * See also:
	   *
	   *    bitAnd, bitNot, bitOr, bitXor, leftShift, rightLogShift
	   *
	   * @param  {number | Array | Matrix} x Value to be shifted
	   * @param  {number} y Amount of shifts
	   * @return {number | Array | Matrix} `x` zero-filled shifted right `y` times
	   */

	  var rightLogShift = typed('rightLogShift', {

	    'number, number': function (x, y) {
	      if (!isInteger(x) || !isInteger(y)) {
	        throw new Error('Integers expected in function rightLogShift');
	      }

	      return x >>> y;
	    },

	    // 'BigNumber, BigNumber': ..., // TODO: implement BigNumber support for rightLogShift

	    'Matrix, Matrix': function (x, y) {
	      // result
	      var c;

	      // process matrix storage
	      switch (x.storage()) {
	        case 'sparse':
	          switch (y.storage()) {
	            case 'sparse':
	              // sparse & sparse
	              c = algorithm08(x, y, rightLogShift, false);
	              break;
	            default:
	              // sparse & dense
	              c = algorithm02(y, x, rightLogShift, true);
	              break;
	          }
	          break;
	        default:
	          switch (y.storage()) {
	            case 'sparse':
	              // dense & sparse
	              c = algorithm01(x, y, rightLogShift, false);
	              break;
	            default:
	              // dense & dense
	              c = algorithm13(x, y, rightLogShift);
	              break;
	          }
	          break;
	      }
	      return c;
	    },

	    'Array, Array': function (x, y) {
	      // use matrix implementation
	      return rightLogShift(matrix(x), matrix(y)).valueOf();
	    },

	    'Array, Matrix': function (x, y) {
	      // use matrix implementation
	      return rightLogShift(matrix(x), y);
	    },

	    'Matrix, Array': function (x, y) {
	      // use matrix implementation
	      return rightLogShift(x, matrix(y));
	    },

	    'Matrix, number | BigNumber': function (x, y) {
	      // check scalar
	      if (!equalScalar(y, 0)) {
	        // result
	        var c;
	        // check storage format
	        switch (x.storage()) {
	          case 'sparse':
	            c = algorithm11(x, y, rightLogShift, false);
	            break;
	          default:
	            c = algorithm14(x, y, rightLogShift, false);
	            break;
	        }
	        return c;
	      }
	      return x.clone();
	    },

	    'number | BigNumber, Matrix': function (x, y) {
	      // check scalar
	      if (!equalScalar(x, 0)) {
	        // result
	        var c;
	        // check storage format
	        switch (y.storage()) {
	          case 'sparse':
	            c = algorithm10(y, x, rightLogShift, true);
	            break;
	          default:
	            c = algorithm14(y, x, rightLogShift, true);
	            break;
	        }
	        return c;
	      }
	      return zeros(y.size(), y.storage());
	    },

	    'Array, number | BigNumber': function (x, y) {
	      // use matrix implementation
	      return rightLogShift(matrix(x), y).valueOf();
	    },

	    'number | BigNumber, Array': function (x, y) {
	      // use matrix implementation
	      return rightLogShift(x, matrix(y)).valueOf();
	    }
	  });

	  rightLogShift.toTex = '\\left(${args[0]}' + latex.operators['rightLogShift'] + '${args[1]}\\right)';

	  return rightLogShift;
	}

	exports.name = 'rightLogShift';
	exports.factory = factory;


/***/ },
/* 136 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = [
	  __webpack_require__(137),
	  __webpack_require__(146),
	  __webpack_require__(138)
	];


/***/ },
/* 137 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	function factory (type, config, load, typed) {
	  var add = load(__webpack_require__(44));
	  var stirlingS2 = load(__webpack_require__(138));
	  var isNegative = load(__webpack_require__(144));
	  var isInteger = load(__webpack_require__(145));

	  /**
	   * The Bell Numbers count the number of partitions of a set. A partition is a pairwise disjoint subset of S whose union is S.
	   * bellNumbers only takes integer arguments.
	   * The following condition must be enforced: n >= 0
	   *
	   * Syntax:
	   *
	   *   math.bellNumbers(n)
	   *
	   * Examples:
	   *
	   *    math.bellNumbers(3); // returns 5;
	   *    math.bellNumbers(8); // returns 4140;
	   *
	   * See also:
	   *
	   *    stirlingS2
	   *
	   * @param {Number | BigNumber} n    Total number of objects in the set
	   * @return {Number | BigNumber}     B(n)
	   */
	  var bellNumbers = typed('bellNumbers', {
	    'number | BigNumber': function (n) {

	      if (!isInteger(n) || isNegative(n)) {
	        throw new TypeError('Non-negative integer value expected in function bellNumbers');
	      }

	      // Sum (k=0, n) S(n,k).
	      var result = 0;
	      for(var i = 0; i <= n; i++) {
	        result = add(result, stirlingS2(n, i));
	      }

	      return result;
	    }
	  });

	  bellNumbers.toTex = '\\mathrm{B}_{${args[0]}}';

	  return bellNumbers;
	}

	exports.name = 'bellNumbers';
	exports.factory = factory;


/***/ },
/* 138 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	function factory (type, config, load, typed) {
	  var add = load(__webpack_require__(44));
	  var subtract = load(__webpack_require__(25));
	  var multiply = load(__webpack_require__(40));
	  var divide = load(__webpack_require__(94));
	  var pow = load(__webpack_require__(100));
	  var factorial = load(__webpack_require__(139));
	  var combinations = load(__webpack_require__(143));
	  var isNegative = load(__webpack_require__(144));
	  var isInteger = load(__webpack_require__(145));
	  var larger = load(__webpack_require__(64));

	  /**
	   * The Stirling numbers of the second kind, counts the number of ways to partition
	   * a set of n labelled objects into k nonempty unlabelled subsets.
	   * stirlingS2 only takes integer arguments.
	   * The following condition must be enforced: k <= n.
	   *
	   *  If n = k or k = 1, then s(n,k) = 1
	   *
	   * Syntax:
	   *
	   *   math.stirlingS2(n, k)
	   *
	   * Examples:
	   *
	   *    math.stirlingS2(5, 3); //returns 25
	   *
	   * See also:
	   *
	   *    Bell numbers
	   *
	   * @param {Number | BigNumber} n    Total number of objects in the set
	   * @param {Number | BigNumber} k    Number of objects in the subset
	   * @return {Number | BigNumber}     S(n,k)
	   */
	  var stirlingS2 = typed('stirlingS2', {
	    'number | BigNumber, number | BigNumber': function (n, k) {
	      if (!isInteger(n) || isNegative(n) || !isInteger(k) || isNegative(k)) {
	        throw new TypeError('Non-negative integer value expected in function stirlingS2');
	      }
	      else if (larger(k, n)) {
	        throw new TypeError('k must be less than or equal to n in function stirlingS2');
	      }

	      // 1/k! Sum(i=0 -> k) [(-1)^(k-i)*C(k,j)* i^n]
	      var kFactorial = factorial(k);
	      var result = 0;
	      for(var i = 0; i <= k; i++) {
	        var negativeOne = pow(-1, subtract(k,i));
	        var kChooseI = combinations(k,i);
	        var iPower = pow(i,n);

	        result = add(result, multiply(multiply(kChooseI, iPower), negativeOne));
	      }

	      return divide(result, kFactorial);
	    }
	  });

	  stirlingS2.toTex = '\\mathrm{S}\\left(${args[0]},${args[1]}\\right)';

	  return stirlingS2;
	}

	exports.name = 'stirlingS2';
	exports.factory = factory;


/***/ },
/* 139 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);
	var constants = __webpack_require__(140);

	function factory (type, config, load, typed) {
	  var gamma = load(__webpack_require__(142));
	  var latex = __webpack_require__(26);

	  /**
	   * Compute the factorial of a value
	   *
	   * Factorial only supports an integer value as argument.
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.factorial(n)
	   *
	   * Examples:
	   *
	   *    math.factorial(5);    // returns 120
	   *    math.factorial(3);    // returns 6
	   *
	   * See also:
	   *
	   *    combinations, gamma, permutations
	   *
	   * @param {number | BigNumber | Array | Matrix} n   An integer number
	   * @return {number | BigNumber | Array | Matrix}    The factorial of `n`
	   */
	  var factorial = typed('factorial', {
	    'number': function (n) {
	      if (n === Number.POSITIVE_INFINITY) {
	       return Math.sqrt(2 * Math.PI);
	      }

	      return gamma(n + 1);
	    },

	    'BigNumber': function (n) {
	      if (!n.isFinite() && !n.isNegative()) {
	        return constants.tau(type.BigNumber).sqrt();
	      }

	      return gamma(n.plus(1));
	    },

	    'Array | Matrix': function (n) {
	      return deepMap(n, factorial);
	    }
	  });

	  factorial.toTex = '\\left(${args[0]}\\right)' + latex.operators['factorial'];

	  return factorial;
	}

	exports.name = 'factorial';
	exports.factory = factory;


/***/ },
/* 140 */
/***/ function(module, exports, __webpack_require__) {

	var memoize = __webpack_require__(38).memoize;
	var atan = __webpack_require__(141);

	/**
	 * Calculate BigNumber e
	 * @param {function} BigNumber   BigNumber constructor
	 * @returns {BigNumber} Returns e
	 */
	exports.e = memoize(function (BigNumber) {
	  return new BigNumber(1).exp();
	}, hasher);

	/**
	 * Calculate BigNumber golden ratio, phi = (1+sqrt(5))/2
	 * @param {function} BigNumber   BigNumber constructor
	 * @returns {BigNumber} Returns phi
	 */
	exports.phi = memoize(function (BigNumber) {
	  return new BigNumber(1).plus(new BigNumber(5).sqrt()).div(2);
	}, hasher);

	/**
	 * Calculate BigNumber pi.
	 *
	 * Uses Machin's formula: pi / 4 = 4 * arctan(1 / 5) - arctan(1 / 239)
	 * http://milan.milanovic.org/math/english/pi/machin.html
	 * @param {function} BigNumber   BigNumber constructor
	 * @returns {BigNumber} Returns pi
	 */
	exports.pi = memoize(function (BigNumber) {
	  // we calculate pi with a few decimal places extra to prevent round off issues
	  var Big = BigNumber.constructor({precision: BigNumber.precision + 4});
	  var pi4th = new Big(4).times(atan(new Big(1).div(5)))
	      .minus(atan(new Big(1).div(239)));

	  // the final pi has the requested number of decimals
	  return new BigNumber(4).times(pi4th);
	}, hasher);

	/**
	 * Calculate BigNumber tau, tau = 2 * pi
	 * @param {function} BigNumber   BigNumber constructor
	 * @returns {BigNumber} Returns tau
	 */
	exports.tau = memoize(function (BigNumber) {
	  // we calculate pi at a slightly higher precision than configured to prevent round off errors
	  // when multiplying by two in the end

	  var pi = exports.pi(BigNumber.constructor({precision: BigNumber.precision + 2}));

	  return new BigNumber(2).times(pi);
	}, hasher);

	/**
	 * Create a hash for a BigNumber constructor function. The created has is
	 * the configured precision
	 * @param {Array} args         Supposed to contain a single entry with
	 *                             a BigNumber constructor
	 * @return {number} precision
	 * @private
	 */
	function hasher (args) {
	  return args[0].precision;
	}


/***/ },
/* 141 */
/***/ function(module, exports) {

	/**
	 * Calculate the arc tangent of x using a Taylor expansion
	 *
	 * arctan(x) = x - x^3/3 + x^5/5 - x^7/7 + x^9/9 - ...
	 *           = x - x^2*x^1/3 + x^2*x^3/5 - x^2*x^5/7 + x^2*x^7/9 - ...
	 *
	 * @param {BigNumber} x
	 * @returns {BigNumber} arc tangent of x
	 */
	module.exports = function atan(x) {
	  var y = x;
	  var yPrev = NaN;
	  var x2 = x.times(x);
	  var num = x;
	  var add = true;

	  for (var k = 3; !y.equals(yPrev); k += 2) {
	    num = num.times(x2);

	    yPrev = y;
	    add = !add;
	    y = (add) ? y.plus(num.div(k)) : y.minus(num.div(k));
	  }

	  return y;
	};


/***/ },
/* 142 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);
	var isInteger = __webpack_require__(8).isInteger;

	function factory (type, config, load, typed) {
	  var multiply = load(__webpack_require__(40));
	  var pow = load(__webpack_require__(100));

	  /**
	   * Compute the gamma function of a value using Lanczos approximation for
	   * small values, and an extended Stirling approximation for large values.
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.gamma(n)
	   *
	   * Examples:
	   *
	   *    math.gamma(5);       // returns 24
	   *    math.gamma(-0.5);    // returns -3.5449077018110335
	   *    math.gamma(math.i);  // returns -0.15494982830180973 - 0.49801566811835596i
	   *
	   * See also:
	   *
	   *    combinations, factorial, permutations
	   *
	   * @param {number | Array | Matrix} n   A real or complex number
	   * @return {number | Array | Matrix}    The gamma of `n`
	   */
	  var gamma = typed('gamma', {
	    'number': function (n) {
	      var t, x;

	      if (isInteger(n)) {
	        if (n <= 0) {
	          return isFinite(n) ? Infinity : NaN;
	        }

	        if (n > 171) {
	          return Infinity;                  // Will overflow
	        }

	        var value = n - 2;
	        var res = n - 1;
	        while (value > 1) {
	          res *= value;
	          value--;
	        }

	        if (res == 0) {
	          res = 1;                          // 0! is per definition 1
	        }

	        return res;
	      }

	      if (n < 0.5) {
	        return Math.PI / (Math.sin(Math.PI * n) * gamma(1-n));
	      }

	      if (n >= 171.35) {
	        return Infinity;                    // will overflow
	      }

	      if (n > 85.0) {                       // Extended Stirling Approx
	        var twoN = n*n;
	        var threeN = twoN*n;
	        var fourN = threeN*n;
	        var fiveN = fourN*n;
	        return Math.sqrt(2*Math.PI/n) * Math.pow((n/Math.E), n) *
	            (1 + 1/(12*n) + 1/(288*twoN) - 139/(51840*threeN) -
	            571/(2488320*fourN) + 163879/(209018880*fiveN) +
	            5246819/(75246796800*fiveN*n));
	      }

	      --n;
	      x = p[0];
	      for (var i = 1; i < p.length; ++i) {
	        x += p[i] / (n+i);
	      }

	      t = n + g + 0.5;
	      return Math.sqrt(2*Math.PI) * Math.pow(t, n+0.5) * Math.exp(-t) * x;
	    },

	    'Complex': function (n) {
	      var t, x;

	      if (n.im == 0) {
	        return gamma(n.re);
	      }

	      n = new type.Complex(n.re - 1, n.im);
	      x = new type.Complex(p[0], 0);
	      for (var i = 1; i < p.length; ++i) {
	        var real = n.re + i;                // x += p[i]/(n+i)
	        var den = real*real + n.im*n.im;
	        if (den != 0) {
	          x.re += p[i] * real / den;
	          x.im += -(p[i] * n.im) / den;
	        } else {
	          x.re = p[i] < 0
	              ? -Infinity
	              :  Infinity;
	        }
	      }

	      t = new type.Complex(n.re + g + 0.5, n.im);
	      var twoPiSqrt = Math.sqrt(2*Math.PI);

	      n.re += 0.5;
	      var result = pow(t, n);
	      if (result.im == 0) {                 // sqrt(2*PI)*result
	        result.re *= twoPiSqrt;
	      } else if (result.re == 0) {
	        result.im *= twoPiSqrt;
	      } else {
	        result.re *= twoPiSqrt;
	        result.im *= twoPiSqrt;
	      }

	      var r = Math.exp(-t.re);              // exp(-t)
	      t.re = r * Math.cos(-t.im);
	      t.im = r * Math.sin(-t.im);

	      return multiply(multiply(result, t), x);
	    },

	    'BigNumber': function (n) {
	      if (n.isInteger()) {
	        return (n.isNegative() || n.isZero())
	            ? new type.BigNumber(Infinity)
	            : bigFactorial(n.minus(1));
	      }

	      if (!n.isFinite()) {
	        return new type.BigNumber(n.isNegative() ? NaN : Infinity);
	      }

	      throw new Error('Integer BigNumber expected');
	    },

	    'Array | Matrix': function (n) {
	      return deepMap(n, gamma);
	    }
	  });

	  /**
	   * Calculate factorial for a BigNumber
	   * @param {BigNumber} n
	   * @returns {BigNumber} Returns the factorial of n
	   */
	  function bigFactorial(n) {
	    var value, res, preciseFacs;

	    var num = n.toNumber();   // should definitely be below Number.MAX_VALUE
	    if (num < smallBigFacs.length) {
	      return new type.BigNumber(smallBigFacs[num]).toSD(config.precision);
	    }

	    // be wary of round-off errors
	    var precision = config.precision + (Math.log(num) | 0);
	    var Big = type.BigNumber.constructor({precision: precision});

	    // adjust n do align with the precision specific tables
	    num -= smallBigFacs.length;
	    if (preciseFacs = bigBigFacs[precision]) {
	      if (preciseFacs[num]) {
	        return new type.BigNumber(preciseFacs[num].toPrecision(config.precision));
	      }
	      res = preciseFacs[preciseFacs.length-1];
	    } else {
	      preciseFacs = bigBigFacs[precision] = [];
	      res = new Big(smallBigFacs[smallBigFacs.length-1])
	          .toSD(precision);
	    }

	    var one = new Big(1);
	    value = new Big(preciseFacs.length + smallBigFacs.length);
	    for (var i = preciseFacs.length; i < num; ++i) {
	      preciseFacs[i] = res = res.times(value);
	      value = value.plus(one);
	    }

	    preciseFacs[num] = res.times(value);
	    return new type.BigNumber(preciseFacs[num].toPrecision(config.precision));
	  }

	  gamma.toTex = '\\Gamma\\left(${args[0]}\\right)';

	  return gamma;
	}

	// TODO: comment on the variables g and p

	var g = 4.7421875;

	var p = [
	  0.99999999999999709182,
	  57.156235665862923517,
	  -59.597960355475491248,
	  14.136097974741747174,
	  -0.49191381609762019978,
	  0.33994649984811888699e-4,
	  0.46523628927048575665e-4,
	  -0.98374475304879564677e-4,
	  0.15808870322491248884e-3,
	  -0.21026444172410488319e-3,
	  0.21743961811521264320e-3,
	  -0.16431810653676389022e-3,
	  0.84418223983852743293e-4,
	  -0.26190838401581408670e-4,
	  0.36899182659531622704e-5
	];

	// 21! >= values for each precision
	var bigBigFacs = [];

	// 0-20! values
	var smallBigFacs = [
	  1,
	  1,
	  2,
	  6,
	  24,
	  120,
	  720,
	  5040,
	  40320,
	  362880,
	  3628800,
	  39916800,
	  479001600,
	  6227020800,
	  87178291200,
	  1307674368000,
	  20922789888000,
	  355687428096000,
	  6402373705728000,
	  121645100408832000,
	  2432902008176640000
	];

	exports.name = 'gamma';
	exports.factory = factory;


/***/ },
/* 143 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var isInteger = __webpack_require__(8).isInteger;

	function factory (type, config, load, typed) {
	  /**
	   * Compute the number of ways of picking `k` unordered outcomes from `n`
	   * possibilities.
	   *
	   * Combinations only takes integer arguments.
	   * The following condition must be enforced: k <= n.
	   *
	   * Syntax:
	   *
	   *     math.combinations(n, k)
	   *
	   * Examples:
	   *
	   *    math.combinations(7, 5); // returns 21
	   *
	   * See also:
	   *
	   *    permutations, factorial
	   *
	   * @param {number | BigNumber} n    Total number of objects in the set
	   * @param {number | BigNumber} k    Number of objects in the subset
	   * @return {number | BigNumber}     Number of possible combinations.
	   */
	  var combinations = typed('combinations', {
	    'number, number': function (n, k) {
	      var max, result, i;

	      if (!isInteger(n) || n < 0) {
	        throw new TypeError('Positive integer value expected in function combinations');
	      }
	      if (k > n) {
	        throw new TypeError('k must be less than or equal to n');
	      }

	      max = Math.max(k, n - k);
	      result = 1;
	      for (i = 1; i <= n - max; i++) {
	        result = result * (max + i) / i;
	      }

	      return result;
	    },

	    'BigNumber, BigNumber': function (n, k) {
	      var max, result, i, ii;
	      var one = new type.BigNumber(1);

	      if (!isPositiveInteger(n) || !isPositiveInteger(k)) {
	        throw new TypeError('Positive integer value expected in function combinations');
	      }
	      if (k.gt(n)) {
	        throw new TypeError('k must be less than n in function combinations');
	      }

	      max = n.minus(k);
	      if (k.lt(max)) max = k;
	      result = one;
	      for (i = one, ii = n.minus(max); i.lte(ii); i = i.plus(1)) {
	        result = result.times(max.plus(i)).dividedBy(i);
	      }

	      return result;
	    }

	    // TODO: implement support for collection in combinations
	  });

	  combinations.toTex = '\\binom{${args[0]}}{${args[1]}}';

	  return combinations;
	}

	/**
	 * Test whether BigNumber n is a positive integer
	 * @param {BigNumber} n
	 * @returns {boolean} isPositiveInteger
	 */
	function isPositiveInteger(n) {
	  return n.isInteger() && n.gte(0);
	}

	exports.name = 'combinations';
	exports.factory = factory;


/***/ },
/* 144 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);
	var number = __webpack_require__(8);

	function factory (type, config, load, typed) {
	  /**
	   * Test whether a value is negative: smaller than zero.
	   * The function supports types `number`, `BigNumber`, `Fraction`, and `Unit`.
	   *
	   * The function is evaluated element-wise in case of Array or Matrix input.
	   *
	   * Syntax:
	   *
	   *     math.isNegative(x)
	   *
	   * Examples:
	   *
	   *    math.isNegative(3);                     // returns false
	   *    math.isNegative(-2);                    // returns true
	   *    math.isNegative(0);                     // returns false
	   *    math.isNegative(-0);                    // returns false
	   *    math.isNegative(math.bignumber(2));     // returns false
	   *    math.isNegative(math.fraction(-2, 5));  // returns true
	   *    math.isNegative('-2');                  // returns true
	   *    math.isNegative([2, 0, -3]');           // returns [false, false, true]
	   *
	   * See also:
	   *
	   *    isNumeric, isPositive, isZero, isInteger
	   *
	   * @param {number | BigNumber | Fraction | Unit | Array | Matrix} x  Value to be tested
	   * @return {boolean}  Returns true when `x` is larger than zero.
	   *                    Throws an error in case of an unknown data type.
	   */
	  var isNegative = typed('isNegative', {
	    'number': function (x) {
	      return x < 0;
	    },

	    'BigNumber': function (x) {
	      return x.isNeg() && !x.isZero() && !x.isNaN();
	    },

	    'Fraction': function (x) {
	      return x.s < 0 && x.n > 0;
	    },

	    'Unit': function (x) {
	      return x.value < 0;
	    },

	    'Array | Matrix': function (x) {
	      return deepMap(x, isNegative);
	    }
	  });

	  return isNegative;
	}

	exports.name = 'isNegative';
	exports.factory = factory;


/***/ },
/* 145 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);
	var number = __webpack_require__(8);

	function factory (type, config, load, typed) {
	  /**
	   * Test whether a value is an integer number.
	   * The function supports `number`, `BigNumber`, and `Fraction`.
	   *
	   * The function is evaluated element-wise in case of Array or Matrix input.
	   *
	   * Syntax:
	   *
	   *     math.isInteger(x)
	   *
	   * Examples:
	   *
	   *    math.isInteger(2);                     // returns true
	   *    math.isInteger(0);                     // returns true
	   *    math.isInteger(0.5);                   // returns false
	   *    math.isInteger(math.bignumber(500));   // returns true
	   *    math.isInteger(math.fraction(4));      // returns true
	   *    math.isInteger('3');                   // returns true
	   *    math.isInteger([3, 0.5, -2]);          // returns [true, false, true]
	   *    math.isInteger(math.complex('2 - 4i'); // throws an error
	   *
	   * See also:
	   *
	   *    isNumeric, isPositive, isNegative, isZero
	   *
	   * @param {number | BigNumber | Fraction | Array | Matrix} x   Value to be tested
	   * @return {boolean}  Returns true when `x` contains a numeric, integer value.
	   *                    Throws an error in case of an unknown data type.
	   */
	  var isInteger = typed('isInteger', {
	    'number': number.isInteger, // TODO: what to do with isInteger(add(0.1, 0.2))  ?

	    'BigNumber': function (x) {
	      return x.isInt();
	    },

	    'Fraction': function (x) {
	      return x.d === 1 && isFinite(x.n);
	    },

	    'Array | Matrix': function (x) {
	      return deepMap(x, isInteger);
	    }
	  });

	  return isInteger;
	}

	exports.name = 'isInteger';
	exports.factory = factory;


/***/ },
/* 146 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	function factory (type, config, load, typed) {
	  var combinations = load(__webpack_require__(143));
	  var add = load(__webpack_require__(27));
	  var isPositive = load(__webpack_require__(147));
	  var isInteger = load(__webpack_require__(145));
	  var larger = load(__webpack_require__(64));

	  /**
	   * The composition counts of n into k parts.
	   *
	   * composition only takes integer arguments.
	   * The following condition must be enforced: k <= n.
	   *
	   * Syntax:
	   *
	   *   math.composition(n, k)
	   *
	   * Examples:
	   *
	   *    math.composition(5, 3); // returns 6
	   *
	   * See also:
	   *
	   *    combinations
	   *
	   * @param {Number | BigNumber} n    Total number of objects in the set
	   * @param {Number | BigNumber} k    Number of objects in the subset
	   * @return {Number | BigNumber}     Returns the composition counts of n into k parts.
	   */
	  var composition =  typed('composition', {
	    'number | BigNumber, number | BigNumber': function (n, k) {
	      if (!isInteger(n) || !isPositive(n) || !isInteger(k) || !isPositive(k)) {
	        throw new TypeError('Positive integer value expected in function composition');
	      }
	      else if (larger(k, n)) {
	        throw new TypeError('k must be less than or equal to n in function composition');
	      }

	      return combinations(add(n, -1), add(k, -1));
	    }
	  });

	  composition.toTex = '\\mathrm{${name}}\\left(${args}\\right)';

	  return composition;
	}

	exports.name = 'composition';
	exports.factory = factory;


/***/ },
/* 147 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);
	var number = __webpack_require__(8);

	function factory (type, config, load, typed) {
	  /**
	   * Test whether a value is positive: larger than zero.
	   * The function supports types `number`, `BigNumber`, `Fraction`, and `Unit`.
	   *
	   * The function is evaluated element-wise in case of Array or Matrix input.
	   *
	   * Syntax:
	   *
	   *     math.isPositive(x)
	   *
	   * Examples:
	   *
	   *    math.isPositive(3);                     // returns true
	   *    math.isPositive(-2);                    // returns false
	   *    math.isPositive(0);                     // returns false
	   *    math.isPositive(-0);                    // returns false
	   *    math.isPositive(0.5);                   // returns true
	   *    math.isPositive(math.bignumber(2));     // returns true
	   *    math.isPositive(math.fraction(-2, 5));  // returns false
	   *    math.isPositive(math.fraction(1,3));    // returns false
	   *    math.isPositive('2');                   // returns true
	   *    math.isPositive([2, 0, -3]');           // returns [true, false, false]
	   *
	   * See also:
	   *
	   *    isNumeric, isZero, isNegative, isInteger
	   *
	   * @param {number | BigNumber | Fraction | Unit | Array | Matrix} x  Value to be tested
	   * @return {boolean}  Returns true when `x` is larger than zero.
	   *                    Throws an error in case of an unknown data type.
	   */
	  var isPositive = typed('isPositive', {
	    'number': function (x) {
	      return x > 0;
	    },

	    'BigNumber': function (x) {
	      return !x.isNeg() && !x.isZero() && !x.isNaN();
	    },

	    'Fraction': function (x) {
	      return x.s > 0 && x.n > 0;
	    },

	    'Unit': function (x) {
	      return x.value > 0;
	    },

	    'Array | Matrix': function (x) {
	      return deepMap(x, isPositive);
	    }
	  });

	  return isPositive;
	}

	exports.name = 'isPositive';
	exports.factory = factory;


/***/ },
/* 148 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = [
	  __webpack_require__(149),
	  __webpack_require__(150),
	  __webpack_require__(151),
	  __webpack_require__(152)
	];


/***/ },
/* 149 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);

	function factory (type, config, load, typed) {
	  /**
	   * Compute the argument of a complex value.
	   * For a complex number `a + bi`, the argument is computed as `atan2(b, a)`.
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.arg(x)
	   *
	   * Examples:
	   *
	   *    var a = math.complex(2, 2);
	   *    math.arg(a) / math.pi;          // returns number 0.25
	   *
	   *    var b = math.complex('2 + 3i');
	   *    math.arg(b);                    // returns number 0.982793723247329
	   *    math.atan2(3, 2);               // returns number 0.982793723247329
	   *
	   * See also:
	   *
	   *    re, im, conj, abs
	   *
	   * @param {number | Complex | Array | Matrix} x
	   *            A complex number or array with complex numbers
	   * @return {number | Array | Matrix} The argument of x
	   */
	  var arg = typed('arg', {
	    'number': function (x) {
	      return Math.atan2(0, x);
	    },

	    'Complex': function (x) {
	      return Math.atan2(x.im, x.re);
	    },

	    // TODO: implement BigNumber support for function arg

	    'Array | Matrix': function (x) {
	      return deepMap(x, arg);
	    }
	  });

	  arg.toTex = '\\arg\\left(${args[0]}\\right)';

	  return arg;
	}

	exports.name = 'arg';
	exports.factory = factory;


/***/ },
/* 150 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);

	function factory (type, config, load, typed) {
	  /**
	   * Compute the complex conjugate of a complex value.
	   * If `x = a+bi`, the complex conjugate of `x` is `a - bi`.
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.conj(x)
	   *
	   * Examples:
	   *
	   *    math.conj(math.complex('2 + 3i'));  // returns Complex 2 - 3i
	   *    math.conj(math.complex('2 - 3i'));  // returns Complex 2 + 3i
	   *    math.conj(math.complex('-5.2i'));  // returns Complex 5.2i
	   *
	   * See also:
	   *
	   *    re, im, arg, abs
	   *
	   * @param {number | BigNumber | Complex | Array | Matrix} x
	   *            A complex number or array with complex numbers
	   * @return {number | BigNumber | Complex | Array | Matrix}
	   *            The complex conjugate of x
	   */
	  var conj = typed('conj', {
	    'number': function (x) {
	      return x;
	    },

	    'BigNumber': function (x) {
	      return x;
	    },

	    'Complex': function (x) {
	      return new type.Complex(x.re, -x.im);
	    },

	    'Array | Matrix': function (x) {
	      return deepMap(x, conj);
	    }
	  });

	  conj.toTex = '\\left(${args[0]}\\right)^*';

	  return conj;
	}

	exports.name = 'conj';
	exports.factory = factory;


/***/ },
/* 151 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);

	function factory (type, config, load, typed) {
	  /**
	   * Get the imaginary part of a complex number.
	   * For a complex number `a + bi`, the function returns `b`.
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.im(x)
	   *
	   * Examples:
	   *
	   *    var a = math.complex(2, 3);
	   *    math.re(a);                     // returns number 2
	   *    math.im(a);                     // returns number 3
	   *
	   *    math.re(math.complex('-5.2i')); // returns number -5.2
	   *    math.re(math.complex(2.4));     // returns number 0
	   *
	   * See also:
	   *
	   *    re, conj, abs, arg
	   *
	   * @param {number | BigNumber | Complex | Array | Matrix} x
	   *            A complex number or array with complex numbers
	   * @return {number | BigNumber | Array | Matrix} The imaginary part of x
	   */
	  var im = typed('im', {
	    'number': function (x) {
	      return 0;
	    },

	    'BigNumber': function (x) {
	      return new type.BigNumber(0);
	    },

	    'Complex': function (x) {
	      return x.im;
	    },

	    'Array | Matrix': function (x) {
	      return deepMap(x, im);
	    }
	  });

	  im.toTex = '\\Im\\left\\lbrace${args[0]}\\right\\rbrace';

	  return im;
	}

	exports.name = 'im';
	exports.factory = factory;


/***/ },
/* 152 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);

	function factory (type, config, load, typed) {
	  /**
	   * Get the real part of a complex number.
	   * For a complex number `a + bi`, the function returns `a`.
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.re(x)
	   *
	   * Examples:
	   *
	   *    var a = math.complex(2, 3);
	   *    math.re(a);                     // returns number 2
	   *    math.im(a);                     // returns number 3
	   *
	   *    math.re(math.complex('-5.2i')); // returns number 0
	   *    math.re(math.complex(2.4));     // returns number 2.4
	   *
	   * See also:
	   *
	   *    im, conj, abs, arg
	   *
	   * @param {number | BigNumber | Complex | Array | Matrix} x
	   *            A complex number or array with complex numbers
	   * @return {number | BigNumber | Array | Matrix} The real part of x
	   */
	  var re = typed('re', {
	    'number': function (x) {
	      return x;
	    },

	    'BigNumber': function (x) {
	      return x;
	    },

	    'Complex': function (x) {
	      return x.re;
	    },

	    'Array | Matrix': function (x) {
	      return deepMap(x, re);
	    }
	  });

	  re.toTex = '\\Re\\left\\lbrace${args[0]}\\right\\rbrace';

	  return re;
	}

	exports.name = 're';
	exports.factory = factory;


/***/ },
/* 153 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = [
	  __webpack_require__(154)
	];


/***/ },
/* 154 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	function factory (type, config, load, typed) {
	  var matrix = load(__webpack_require__(23));

	  /**
	   * Calculates the point of intersection of two lines in two or three dimensions
	   * and of a line and a plane in three dimensions. The inputs are in the form of
	   * arrays or 1 dimensional matrices. The line intersection functions return null
	   * if the lines do not meet.
	   *
	   * Note: Fill the plane coefficients as `x + y + z = c` and not as `x + y + z + c = 0`.
	   *
	   * Syntax:
	   *
	   *    math.intersect(endPoint1Line1, endPoint2Line1, endPoint1Line2, endPoint2Line2)
	   *    math.intersect(endPoint1, endPoint2, planeCoefficients)
	   *
	   * Examples:
	   *
	   *    math.intersect([0, 0], [10, 10], [10, 0], [0, 10]);              // Returns [5, 5]
	   *    math.intersect([0, 0, 0], [10, 10, 0], [10, 0, 0], [0, 10, 0]);  // Returns [5, 5, 0]
	   *    math.intersect([1, 0, 1],  [4, -2, 2], [1, 1, 1, 6]);            // Returns [7, -4, 3]
	   *
	   * @param  {Array | Matrix} w   Co-ordinates of first end-point of first line
	   * @param  {Array | Matrix} x   Co-ordinates of second end-point of first line
	   * @param  {Array | Matrix} y   Co-ordinates of first end-point of second line
	   *                              OR Co-efficients of the plane's equation
	   * @param  {Array | Matrix} z   Co-ordinates of second end-point of second line
	   *                              OR null if the calculation is for line and plane
	   * @return {Array}              Returns the point of intersection of lines/lines-planes
	   */
	  var intersect = typed('intersect', {
	    'Array, Array, Array': function (x, y, plane) {
	      if (!_3d(x)) { throw new TypeError('Array with 3 numbers expected for first argument'); }
	      if (!_3d(y)) { throw new TypeError('Array with 3 numbers expected for second argument'); }
	      if (!_4d(plane)) { throw new TypeError('Array with 4 numbers expected as third argument'); }

	      return _intersectLinePlane(x[0], x[1], x[2], y[0], y[1], y[2], plane[0], plane[1], plane[2], plane[3]);
	    },

	    'Array, Array, Array, Array': function (w, x, y, z) {
	      if (w.length === 2) {
	        if (!_2d(w)) { throw new TypeError('Array with 2 numbers expected for first argument'); }
	        if (!_2d(x)) { throw new TypeError('Array with 2 numbers expected for second argument'); }
	        if (!_2d(y)) { throw new TypeError('Array with 2 numbers expected for third argument'); }
	        if (!_2d(z)) { throw new TypeError('Array with 2 numbers expected for fourth argument'); }

	        return _intersect2d(w[0], w[1], x[0], x[1], y[0], y[1], z[0], z[1]);
	      }
	      else if (w.length === 3) {
	        if (!_3d(w)) { throw new TypeError('Array with 3 numbers expected for first argument'); }
	        if (!_3d(x)) { throw new TypeError('Array with 3 numbers expected for second argument'); }
	        if (!_3d(y)) { throw new TypeError('Array with 3 numbers expected for third argument'); }
	        if (!_3d(z)) { throw new TypeError('Array with 3 numbers expected for fourth argument'); }

	        return _intersect3d(w[0], w[1], w[2], x[0], x[1], x[2], y[0], y[1], y[2], z[0], z[1], z[2]);
	      }
	      else {
	        throw new TypeError('Arrays with two or thee dimensional points expected');
	      }
	    },

	    'Matrix, Matrix, Matrix': function (x, y, plane) {
	      return matrix(intersect(x.valueOf(), y.valueOf(), plane.valueOf()));
	    },

	    'Matrix, Matrix, Matrix, Matrix': function (w, x, y, z) {
	      // TODO: output matrix type should match input matrix type
	      return matrix(intersect(w.valueOf(), x.valueOf(), y.valueOf(), z.valueOf()));
	    }
	  });

	  return intersect;
	}

	function _2d(x) {
	  return x.length === 2 && typeof x[0] === 'number' && typeof x[1] === 'number';
	}

	function _3d(x) {
	  return x.length === 3 && typeof x[0] === 'number' && typeof x[1] === 'number' && typeof x[2] === 'number';
	}

	function _4d(x) {
	  return x.length === 4 && typeof x[0] === 'number' && typeof x[1] === 'number' && typeof x[2] === 'number' && typeof x[3] === 'number';
	}

	function _intersect2d(x1, y1, x2, y2, x3, y3, x4, y4){
	  var d1343 = (x1 - x3)*(x4 - x3) + (y1 - y3)*(y4 - y3);
	  var d4321 = (x4 - x3)*(x2 - x1) + (y4 - y3)*(y2 - y1);
	  var d1321 = (x1 - x3)*(x2 - x1) + (y1 - y3)*(y2 - y1);
	  var d4343 = (x4 - x3)*(x4 - x3) + (y4 - y3)*(y4 - y3);
	  var d2121 = (x2 - x1)*(x2 - x1) + (y2 - y1)*(y2 - y1);
	  var ta = ( d1343*d4321 - d1321*d4343 ) / ( d2121*d4343 - d4321*d4321 );
	  var tb = ( d1343 + ta * d4321 ) / (d4343);

	  var pax = x1 + ta * (x2 - x1);
	  var pay = y1 + ta * (y2 - y1);
	  var pbx = x3 + tb * (x4 - x3);
	  var pby = y3 + tb * (y4 - y3);
	  if (pax === pbx && pay === pby){
	    return [pax, pay];
	  }
	  else{
	    return null;
	  }
	}

	function _intersect3d(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4){
	  var d1343 = (x1 - x3)*(x4 - x3) + (y1 - y3)*(y4 - y3) + (z1 - z3)*(z4 - z3);
	  var d4321 = (x4 - x3)*(x2 - x1) + (y4 - y3)*(y2 - y1) + (z4 - z3)*(z2 - z1);
	  var d1321 = (x1 - x3)*(x2 - x1) + (y1 - y3)*(y2 - y1) + (z1 - z3)*(z2 - z1);
	  var d4343 = (x4 - x3)*(x4 - x3) + (y4 - y3)*(y4 - y3) + (z4 - z3)*(z4 - z3);
	  var d2121 = (x2 - x1)*(x2 - x1) + (y2 - y1)*(y2 - y1) + (z2 - z1)*(z2 - z1);
	  var ta = ( d1343*d4321 - d1321*d4343 ) / ( d2121*d4343 - d4321*d4321 );
	  var tb = ( d1343 + ta * d4321 ) / (d4343);

	  var pax = x1 + ta * (x2 - x1);
	  var pay = y1 + ta * (y2 - y1);
	  var paz = z1 + ta * (z2 - z1);
	  var pbx = x3 + tb * (x4 - x3);
	  var pby = y3 + tb * (y4 - y3);
	  var pbz = z3 + tb * (z4 - z3);
	  if (pax === pbx && pay === pby && paz === pbz){
	    return [pax, pay, paz];
	  }
	  else{
	    return null;
	  }
	}

	function _intersectLinePlane(x1, y1, z1, x2, y2, z2, x, y, z, c){
	  var t = (c - x1*x - y1*y - z1*z)/(x2*x + y2*y + z2*z - x1 - y1 - z1);
	  var px = x1 + t * (x2 - x1);
	  var py = y1 + t * (y2 - y1);
	  var pz = z1 + t * (z2 - z1);
	  return [px, py, pz];
	  // TODO: Add cases when line is parallel to the plane:
	  //       (a) no intersection,
	  //       (b) line contained in plane
	}

	exports.name = 'intersect';
	exports.factory = factory;


/***/ },
/* 155 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = [
	  __webpack_require__(156),
	  __webpack_require__(157),
	  __webpack_require__(158),
	  __webpack_require__(159)
	];


/***/ },
/* 156 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	function factory (type, config, load, typed) {
	  var latex = __webpack_require__(26);

	  var matrix = load(__webpack_require__(23));
	  var zeros = load(__webpack_require__(60));
	  var not = load(__webpack_require__(157));

	  var algorithm02 = load(__webpack_require__(96));
	  var algorithm06 = load(__webpack_require__(107));
	  var algorithm11 = load(__webpack_require__(42));
	  var algorithm13 = load(__webpack_require__(35));
	  var algorithm14 = load(__webpack_require__(39));

	  /**
	   * Logical `and`. Test whether two values are both defined with a nonzero/nonempty value.
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.and(x, y)
	   *
	   * Examples:
	   *
	   *    math.and(2, 4);   // returns true
	   *
	   *    a = [2, 0, 0];
	   *    b = [3, 7, 0];
	   *    c = 0;
	   *
	   *    math.and(a, b);   // returns [true, false, false]
	   *    math.and(a, c);   // returns [false, false, false]
	   *
	   * See also:
	   *
	   *    not, or, xor
	   *
	   * @param  {number | BigNumber | Complex | Unit | Array | Matrix} x First value to check
	   * @param  {number | BigNumber | Complex | Unit | Array | Matrix} y Second value to check
	   * @return {boolean | Array | Matrix}
	   *            Returns true when both inputs are defined with a nonzero/nonempty value.
	   */
	  var and = typed('and', {

	    'number, number': function (x, y) {
	      return !!(x && y);
	    },

	    'Complex, Complex': function (x, y) {
	      return (x.re !== 0 || x.im !== 0) && (y.re !== 0 || y.im !== 0);
	    },

	    'BigNumber, BigNumber': function (x, y) {
	      return !x.isZero() && !y.isZero() && !x.isNaN() && !y.isNaN();
	    },

	    'Unit, Unit': function (x, y) {
	      return (x.value !== 0 && x.value !== null) && (y.value !== 0 && y.value !== null);
	    },
	    
	    'Matrix, Matrix': function (x, y) {
	      // result
	      var c;

	      // process matrix storage
	      switch (x.storage()) {
	        case 'sparse':
	          switch (y.storage()) {
	            case 'sparse':
	              // sparse & sparse
	              c = algorithm06(x, y, and, false);
	              break;
	            default:
	              // sparse & dense
	              c = algorithm02(y, x, and, true);
	              break;
	          }
	          break;
	        default:
	          switch (y.storage()) {
	            case 'sparse':
	              // dense & sparse
	              c = algorithm02(x, y, and, false);
	              break;
	            default:
	              // dense & dense
	              c = algorithm13(x, y, and);
	              break;
	          }
	          break;
	      }
	      return c;
	    },

	    'Array, Array': function (x, y) {
	      // use matrix implementation
	      return and(matrix(x), matrix(y)).valueOf();
	    },

	    'Array, Matrix': function (x, y) {
	      // use matrix implementation
	      return and(matrix(x), y);
	    },

	    'Matrix, Array': function (x, y) {
	      // use matrix implementation
	      return and(x, matrix(y));
	    },

	    'Matrix, any': function (x, y) {
	      // check scalar
	      if (not(y)) {
	        // return zero matrix
	        return zeros(x.size(), x.storage());
	      }
	      // result
	      var c;
	      // check storage format
	      switch (x.storage()) {
	        case 'sparse':
	          c = algorithm11(x, y, and, false);
	          break;
	        default:
	          c = algorithm14(x, y, and, false);
	          break;
	      }
	      return c;
	    },

	    'any, Matrix': function (x, y) {
	      // check scalar
	      if (not(x)) {
	        // return zero matrix
	        return zeros(x.size(), x.storage());
	      }
	      // result
	      var c;
	      // check storage format
	      switch (y.storage()) {
	        case 'sparse':
	          c = algorithm11(y, x, and, true);
	          break;
	        default:
	          c = algorithm14(y, x, and, true);
	          break;
	      }
	      return c;
	    },

	    'Array, any': function (x, y) {
	      // use matrix implementation
	      return and(matrix(x), y).valueOf();
	    },

	    'any, Array': function (x, y) {
	      // use matrix implementation
	      return and(x, matrix(y)).valueOf();
	    }
	  });

	  and.toTex = '\\left(${args[0]}' + latex.operators['and'] + '${args[1]}\\right)';

	  return and;
	}

	exports.name = 'and';
	exports.factory = factory;


/***/ },
/* 157 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);

	function factory (type, config, load, typed) {
	  var latex = __webpack_require__(26);

	  /**
	   * Logical `not`. Flips boolean value of a given parameter.
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.not(x)
	   *
	   * Examples:
	   *
	   *    math.not(2);      // returns false
	   *    math.not(0);      // returns true
	   *    math.not(true);   // returns false
	   *
	   *    a = [2, -7, 0];
	   *    math.not(a);      // returns [false, false, true]
	   *
	   * See also:
	   *
	   *    and, or, xor
	   *
	   * @param  {number | BigNumber | Complex | Unit | Array | Matrix} x First value to check
	   * @return {boolean | Array | Matrix}
	   *            Returns true when input is a zero or empty value.
	   */
	  var not = typed('not', {
	    'number': function (x) {
	      return !x;
	    },

	    'Complex': function (x) {
	      return x.re === 0 && x.im === 0;
	    },

	    'BigNumber': function (x) {
	      return x.isZero() || x.isNaN();
	    },

	    'Unit': function (x) {
	      return x.value === null || x.value == 0;
	    },

	    'Array | Matrix': function (x) {
	      return deepMap(x, not);
	    }
	  });

	  not.toTex = latex.operators['not'] + '\\left(${args[0]}\\right)';

	  return not;
	}

	exports.name = 'not';
	exports.factory = factory;


/***/ },
/* 158 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	function factory (type, config, load, typed) {
	  var latex = __webpack_require__(26);

	  var matrix = load(__webpack_require__(23));

	  var algorithm03 = load(__webpack_require__(31));
	  var algorithm05 = load(__webpack_require__(32));
	  var algorithm12 = load(__webpack_require__(65));
	  var algorithm13 = load(__webpack_require__(35));
	  var algorithm14 = load(__webpack_require__(39));
	  
	  /**
	   * Logical `or`. Test if at least one value is defined with a nonzero/nonempty value.
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.or(x, y)
	   *
	   * Examples:
	   *
	   *    math.or(2, 4);   // returns true
	   *
	   *    a = [2, 5, 0];
	   *    b = [0, 22, 0];
	   *    c = 0;
	   *
	   *    math.or(a, b);   // returns [true, true, false]
	   *    math.or(b, c);   // returns [false, true, false]
	   *
	   * See also:
	   *
	   *    and, not, xor
	   *
	   * @param  {number | BigNumber | Complex | Unit | Array | Matrix} x First value to check
	   * @param  {number | BigNumber | Complex | Unit | Array | Matrix} y Second value to check
	   * @return {boolean | Array | Matrix}
	   *            Returns true when one of the inputs is defined with a nonzero/nonempty value.
	   */
	  var or = typed('or', {

	    'number, number': function (x, y) {
	      return !!(x || y);
	    },

	    'Complex, Complex': function (x, y) {
	      return (x.re !== 0 || x.im !== 0) || (y.re !== 0 || y.im !== 0);
	    },

	    'BigNumber, BigNumber': function (x, y) {
	      return (!x.isZero() && !x.isNaN()) || (!y.isZero() && !y.isNaN());
	    },

	    'Unit, Unit': function (x, y) {
	      return (x.value !== 0 && x.value !== null) || (y.value !== 0 && y.value !== null);
	    },

	    'Matrix, Matrix': function (x, y) {
	      // result
	      var c;

	      // process matrix storage
	      switch (x.storage()) {
	        case 'sparse':
	          switch (y.storage()) {
	            case 'sparse':
	              // sparse + sparse
	              c = algorithm05(x, y, or);
	              break;
	            default:
	              // sparse + dense
	              c = algorithm03(y, x, or, true);
	              break;
	          }
	          break;
	        default:
	          switch (y.storage()) {
	            case 'sparse':
	              // dense + sparse
	              c = algorithm03(x, y, or, false);
	              break;
	            default:
	              // dense + dense
	              c = algorithm13(x, y, or);
	              break;
	          }
	          break;
	      }
	      return c;
	    },

	    'Array, Array': function (x, y) {
	      // use matrix implementation
	      return or(matrix(x), matrix(y)).valueOf();
	    },

	    'Array, Matrix': function (x, y) {
	      // use matrix implementation
	      return or(matrix(x), y);
	    },

	    'Matrix, Array': function (x, y) {
	      // use matrix implementation
	      return or(x, matrix(y));
	    },

	    'Matrix, any': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (x.storage()) {
	        case 'sparse':
	          c = algorithm12(x, y, or, false);
	          break;
	        default:
	          c = algorithm14(x, y, or, false);
	          break;
	      }
	      return c;
	    },

	    'any, Matrix': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (y.storage()) {
	        case 'sparse':
	          c = algorithm12(y, x, or, true);
	          break;
	        default:
	          c = algorithm14(y, x, or, true);
	          break;
	      }
	      return c;
	    },

	    'Array, any': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(x), y, or, false).valueOf();
	    },

	    'any, Array': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(y), x, or, true).valueOf();
	    }
	  });

	  or.toTex = '\\left(${args[0]}' + latex.operators['or'] + '${args[1]}\\right)';

	  return or;
	}

	exports.name = 'or';
	exports.factory = factory;


/***/ },
/* 159 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	function factory (type, config, load, typed) {
	  var latex = __webpack_require__(26);

	  var matrix = load(__webpack_require__(23));

	  var algorithm03 = load(__webpack_require__(31));
	  var algorithm07 = load(__webpack_require__(66));
	  var algorithm12 = load(__webpack_require__(65));
	  var algorithm13 = load(__webpack_require__(35));
	  var algorithm14 = load(__webpack_require__(39));
	  
	  /**
	   * Logical `xor`. Test whether one and only one value is defined with a nonzero/nonempty value.
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.xor(x, y)
	   *
	   * Examples:
	   *
	   *    math.xor(2, 4);   // returns false
	   *
	   *    a = [2, 0, 0];
	   *    b = [2, 7, 0];
	   *    c = 0;
	   *
	   *    math.xor(a, b);   // returns [false, true, false]
	   *    math.xor(a, c);   // returns [true, false, false]
	   *
	   * See also:
	   *
	   *    and, not, or
	   *
	   * @param  {number | BigNumber | Complex | Unit | Array | Matrix} x First value to check
	   * @param  {number | BigNumber | Complex | Unit | Array | Matrix} y Second value to check
	   * @return {boolean | Array | Matrix}
	   *            Returns true when one and only one input is defined with a nonzero/nonempty value.
	   */
	  var xor = typed('xor', {
	 
	    'number, number': function (x, y) {
	      return !!(!!x ^ !!y);
	    },

	    'Complex, Complex': function (x, y) {
	      return !!((x.re !== 0 || x.im !== 0) ^ (y.re !== 0 || y.im !== 0));
	    },

	    'BigNumber, BigNumber': function (x, y) {
	      return !!((!x.isZero() && !x.isNaN()) ^ (!y.isZero() && !y.isNaN()));
	    },

	    'Unit, Unit': function (x, y) {
	      return !!((x.value !== 0 && x.value !== null) ^ (y.value !== 0 && y.value !== null));
	    },

	    'Matrix, Matrix': function (x, y) {
	      // result
	      var c;

	      // process matrix storage
	      switch (x.storage()) {
	        case 'sparse':
	          switch (y.storage()) {
	            case 'sparse':
	              // sparse + sparse
	              c = algorithm07(x, y, xor);
	              break;
	            default:
	              // sparse + dense
	              c = algorithm03(y, x, xor, true);
	              break;
	          }
	          break;
	        default:
	          switch (y.storage()) {
	            case 'sparse':
	              // dense + sparse
	              c = algorithm03(x, y, xor, false);
	              break;
	            default:
	              // dense + dense
	              c = algorithm13(x, y, xor);
	              break;
	          }
	          break;
	      }
	      return c;
	    },

	    'Array, Array': function (x, y) {
	      // use matrix implementation
	      return xor(matrix(x), matrix(y)).valueOf();
	    },

	    'Array, Matrix': function (x, y) {
	      // use matrix implementation
	      return xor(matrix(x), y);
	    },

	    'Matrix, Array': function (x, y) {
	      // use matrix implementation
	      return xor(x, matrix(y));
	    },

	    'Matrix, any': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (x.storage()) {
	        case 'sparse':
	          c = algorithm12(x, y, xor, false);
	          break;
	        default:
	          c = algorithm14(x, y, xor, false);
	          break;
	      }
	      return c;
	    },

	    'any, Matrix': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (y.storage()) {
	        case 'sparse':
	          c = algorithm12(y, x, xor, true);
	          break;
	        default:
	          c = algorithm14(y, x, xor, true);
	          break;
	      }
	      return c;
	    },

	    'Array, any': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(x), y, xor, false).valueOf();
	    },

	    'any, Array': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(y), x, xor, true).valueOf();
	    }
	  });

	  xor.toTex = '\\left(${args[0]}' + latex.operators['xor'] + '${args[1]}\\right)';

	  return xor;
	}

	exports.name = 'xor';
	exports.factory = factory;


/***/ },
/* 160 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = [
	  //require('./distribution'), // TODO: rethink math.distribution
	  __webpack_require__(143),
	  __webpack_require__(139),
	  __webpack_require__(142),
	  __webpack_require__(162),
	  __webpack_require__(161),
	  __webpack_require__(164),
	  __webpack_require__(167),
	  __webpack_require__(168)
	];


/***/ },
/* 161 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var isInteger = __webpack_require__(8).isInteger;

	function factory (type, config, load, typed) {
	  var factorial = load(__webpack_require__(139));

	  /**
	   * Compute the number of ways of obtaining an ordered subset of `k` elements
	   * from a set of `n` elements.
	   *
	   * Permutations only takes integer arguments.
	   * The following condition must be enforced: k <= n.
	   *
	   * Syntax:
	   *
	   *     math.permutations(n)
	   *     math.permutations(n, k)
	   *
	   * Examples:
	   *
	   *    math.permutations(5);     // 120
	   *    math.permutations(5, 3);  // 60
	   *
	   * See also:
	   *
	   *    combinations, factorial
	   *
	   * @param {number | BigNumber} n   The number of objects in total
	   * @param {number | BigNumber} [k] The number of objects in the subset
	   * @return {number | BigNumber}    The number of permutations
	   */
	  var permutations = typed('permutations', {
	    'number | BigNumber': factorial,

	    'number, number': function (n, k) {
	      var result, i;

	      if (!isInteger(n) || n < 0) {
	        throw new TypeError('Positive integer value expected in function permutations');
	      }
	      if (!isInteger(k) || k < 0) {
	        throw new TypeError('Positive integer value expected in function permutations');
	      }
	      if (k > n) {
	        throw new TypeError('second argument k must be less than or equal to first argument n');
	      }

	      // Permute n objects, k at a time
	      result = 1;
	      for (i = n - k + 1; i <= n; i++) {
	        result = result * i;
	      }

	      return result;
	    },

	    'BigNumber, BigNumber': function (n, k) {
	      var result, i;

	      if (!isPositiveInteger(n) || !isPositiveInteger(k)) {
	        throw new TypeError('Positive integer value expected in function permutations');
	      }
	      if (k.gt(n)) {
	        throw new TypeError('second argument k must be less than or equal to first argument n');
	      }

	      result = new type.BigNumber(1);
	      for (i = n.minus(k).plus(1); i.lte(n); i = i.plus(1)) {
	        result = result.times(i);
	      }

	      return result;
	    }

	    // TODO: implement support for collection in permutations
	  });

	  permutations.toTex = '\\mathrm{${name}}\\left(${args}\\right)';

	  return permutations;
	}

	/**
	 * Test whether BigNumber n is a positive integer
	 * @param {BigNumber} n
	 * @returns {boolean} isPositiveInteger
	 */
	function isPositiveInteger(n) {
	  return n.isInteger() && n.gte(0);
	}

	exports.name = 'permutations';
	exports.factory = factory;


/***/ },
/* 162 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepForEach = __webpack_require__(163);

	function factory (type, config, load, typed) {
	  var add = load(__webpack_require__(44));
	  var multiply = load(__webpack_require__(40));
	  var divide = load(__webpack_require__(94));
	  var factorial = load(__webpack_require__(139));
	  var isInteger = load(__webpack_require__(145));
	  var isPositive = load(__webpack_require__(147));

	  /**
	   * Multinomial Coefficients compute the number of ways of picking a1, a2, ..., ai unordered outcomes from `n` possibilities.
	   *
	   * multinomial takes one array of integers as an argument.
	   * The following condition must be enforced: every ai <= 0
	   *
	   * Syntax:
	   *
	   *     math.multinomial(a) // a is an array type
	   *
	   * Examples:
	   *
	   *    math.multinomial([1,2,1]); // returns 12
	   *
	   * See also:
	   *
	   *    combinations, factorial
	   *
	   * @param {number[] | BigNumber[]} a    Integer numbers of objects in the subset
	   * @return {Number | BigNumber}         Multinomial coefficient.
	   */
	  return typed('multinomial', {
	    'Array | Matrix': function (a) {
	      var sum = 0;
	      var denom = 1;

	      deepForEach(a, function(ai) {
	        if(!isInteger(ai) || !isPositive(ai)) {
	          throw new TypeError('Positive integer value expected in function multinomial');
	        }
	        sum = add(sum, ai);
	        denom = multiply(denom, factorial(ai));
	      });

	      return divide(factorial(sum), denom);
	    }
	  });
	}

	exports.name = 'multinomial';
	exports.factory = factory;


/***/ },
/* 163 */
/***/ function(module, exports) {

	'use strict';

	/**
	 * Recursively loop over all elements in a given multi dimensional array
	 * and invoke the callback on each of the elements.
	 * @param {Array | Matrix} array
	 * @param {Function} callback     The callback method is invoked with one
	 *                                parameter: the current element in the array
	 */
	module.exports = function deepForEach (array, callback) {
	  if (array && array.isMatrix === true) {
	    array = array.valueOf();
	  }

	  for (var i = 0, ii = array.length; i < ii; i++) {
	    var value = array[i];

	    if (Array.isArray(value)) {
	      deepForEach(value, callback);
	    }
	    else {
	      callback(value);
	    }
	  }
	};


/***/ },
/* 164 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	function factory (type, config, load, typed) {
	  var distribution = load(__webpack_require__(165));

	  /**
	   * Random pick a value from a one dimensional array.
	   * Array element is picked using a random function with uniform distribution.
	   *
	   * Syntax:
	   *
	   *     math.pickRandom(array)
	   *
	   * Examples:
	   *
	   *     math.pickRandom([3, 6, 12, 2]);       // returns one of the values in the array
	   *
	   * See also:
	   *
	   *     random, randomInt
	   *
	   * @param {Array} array     A one dimensional array
	   * @return {number} One of the elements of the provided input array
	   */
	  // TODO: rework pickRandom to a typed-function
	  var pickRandom =  distribution('uniform').pickRandom;

	  pickRandom.toTex = '\\mathrm{${name}}\\left(${args}\\right)';

	  return pickRandom;
	}

	exports.name = 'pickRandom';
	exports.factory = factory;


/***/ },
/* 165 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var ArgumentsError = __webpack_require__(11);
	var isCollection = __webpack_require__(166);

	// TODO: rethink math.distribution
	// TODO: rework to a typed function
	function factory (type, config, load, typed) {
	  var matrix = load(__webpack_require__(23));
	  var array = __webpack_require__(18);

	  /**
	   * Create a distribution object with a set of random functions for given
	   * random distribution.
	   *
	   * Syntax:
	   *
	   *     math.distribution(name)
	   *
	   * Examples:
	   *
	   *     var normalDist = math.distribution('normal'); // create a normal distribution
	   *     normalDist.random(0, 10);                     // get a random value between 0 and 10
	   *
	   * See also:
	   *
	   *     random, randomInt, pickRandom
	   *
	   * @param {string} name   Name of a distribution. Choose from 'uniform', 'normal'.
	   * @return {Object}       Returns a distribution object containing functions:
	   *                        `random([size] [, min] [, max])`,
	   *                        `randomInt([min] [, max])`,
	   *                        `pickRandom(array)`
	   */
	  function distribution(name) {
	    if (!distributions.hasOwnProperty(name))
	      throw new Error('Unknown distribution ' + name);

	    var args = Array.prototype.slice.call(arguments, 1),
	        distribution = distributions[name].apply(this, args);

	    return (function(distribution) {

	      // This is the public API for all distributions
	      var randFunctions = {

	        random: function(arg1, arg2, arg3) {
	          var size, min, max;
	          if (arguments.length > 3) {
	            throw new ArgumentsError('random', arguments.length, 0, 3);

	          // `random(max)` or `random(size)`
	          } else if (arguments.length === 1) {
	            if (isCollection(arg1)) {
	              size = arg1;
	            }
	            else {
	              max = arg1;
	            }
	          // `random(min, max)` or `random(size, max)`
	          } else if (arguments.length === 2) {
	            if (isCollection(arg1)) {
	              size = arg1;
	              max = arg2;
	            }
	            else {
	              min = arg1;
	              max = arg2;
	            }
	          // `random(size, min, max)`
	          } else {
	            size = arg1;
	            min = arg2;
	            max = arg3;
	          }

	          // TODO: validate type of min, max, and size

	          if (max === undefined) max = 1;
	          if (min === undefined) min = 0;
	          if (size !== undefined) {
	            var res = _randomDataForMatrix(size.valueOf(), min, max, _random);
	            return (size && size.isMatrix === true) ? matrix(res) : res;
	          }
	          else return _random(min, max);
	        },

	        randomInt: function(arg1, arg2, arg3) {
	          var size, min, max;
	          if (arguments.length > 3 || arguments.length < 1)
	            throw new ArgumentsError('randomInt', arguments.length, 1, 3);

	          // `random(max)` or `random(size)`
	          else if (arguments.length === 1)
	            if (isCollection(arg1)) {
	              size = arg1;
	            }
	            else {
	              max = arg1;
	            }
	          // `randomInt(min, max)` or `randomInt(size, max)`
	          else if (arguments.length === 2) {
	            if (isCollection(arg1)) {
	              size = arg1;
	              max = arg2;
	            }
	            else {
	              min = arg1;
	              max = arg2;
	            }
	          // `randomInt(size, min, max)`
	          } else {
	            size = arg1;
	            min = arg2;
	            max = arg3;
	          }

	          // TODO: validate type of min, max, and size

	          if (min === undefined) min = 0;
	          if (size !== undefined) {
	            var res = _randomDataForMatrix(size.valueOf(), min, max, _randomInt);
	            return (size && size.isMatrix === true) ? matrix(res) : res;
	          }
	          else return _randomInt(min, max);
	        },

	        pickRandom: function(possibles) {
	          if (arguments.length !== 1) {
	            throw new ArgumentsError('pickRandom', arguments.length, 1);
	          }
	          if (possibles && possibles.isMatrix === true) {
	            possibles = possibles.valueOf(); // get Array
	          }
	          else if (!Array.isArray(possibles)) {
	            throw new TypeError('Unsupported type of value in function pickRandom');
	          }

	          if (array.size(possibles).length > 1) {
	            throw new Error('Only one dimensional vectors supported');
	          }

	          // TODO: add support for multi dimensional matrices
	          return possibles[Math.floor(Math.random() * possibles.length)];
	        }

	      };

	      var _random = function(min, max) {
	        return min + distribution() * (max - min);
	      };

	      var _randomInt = function(min, max) {
	        return Math.floor(min + distribution() * (max - min));
	      };

	      // This is a function for generating a random matrix recursively.
	      var _randomDataForMatrix = function(size, min, max, randFunc) {
	        var data = [], length, i;
	        size = size.slice(0);

	        if (size.length > 1) {
	          for (i = 0, length = size.shift(); i < length; i++)
	            data.push(_randomDataForMatrix(size, min, max, randFunc));
	        } else {
	          for (i = 0, length = size.shift(); i < length; i++)
	            data.push(randFunc(min, max));
	        }

	        return data;
	      };

	      return randFunctions;

	    })(distribution);
	  }

	  // Each distribution is a function that takes no argument and when called returns
	  // a number between 0 and 1.
	  var distributions = {

	    uniform: function() {
	      return Math.random;
	    },

	    // Implementation of normal distribution using Box-Muller transform
	    // ref : http://en.wikipedia.org/wiki/Box%E2%80%93Muller_transform
	    // We take : mean = 0.5, standard deviation = 1/6
	    // so that 99.7% values are in [0, 1].
	    normal: function() {
	      return function() {
	        var u1, u2,
	            picked = -1;
	        // We reject values outside of the interval [0, 1]
	        // TODO: check if it is ok to do that?
	        while (picked < 0 || picked > 1) {
	          u1 = Math.random();
	          u2 = Math.random();
	          picked = 1/6 * Math.pow(-2 * Math.log(u1), 0.5) * Math.cos(2 * Math.PI * u2) + 0.5;
	        }
	        return picked;
	      }
	    }
	  };

	  distribution.toTex = '\\mathrm{${name}}\\left(${args}\\right)';

	  return distribution;
	}

	exports.name = 'distribution';
	exports.factory = factory;


/***/ },
/* 166 */
/***/ function(module, exports) {

	'use strict';

	/**
	 * Test whether a value is a collection: an Array or Matrix
	 * @param {*} x
	 * @returns {boolean} isCollection
	 */
	module.exports = function isCollection (x) {
	  return (Array.isArray(x) || (x && x.isMatrix === true));
	};


/***/ },
/* 167 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	function factory (type, config, load, typed) {
	  var distribution = load(__webpack_require__(165));

	  /**
	   * Return a random number larger or equal to `min` and smaller than `max`
	   * using a uniform distribution.
	   *
	   * Syntax:
	   *
	   *     math.random()                // generate a random number between 0 and 1
	   *     math.random(max)             // generate a random number between 0 and max
	   *     math.random(min, max)        // generate a random number between min and max
	   *     math.random(size)            // generate a matrix with random numbers between 0 and 1
	   *     math.random(size, max)       // generate a matrix with random numbers between 0 and max
	   *     math.random(size, min, max)  // generate a matrix with random numbers between min and max
	   *
	   * Examples:
	   *
	   *     math.random();       // returns a random number between 0 and 1
	   *     math.random(100);    // returns a random number between 0 and 100
	   *     math.random(30, 40); // returns a random number between 30 and 40
	   *     math.random([2, 3]); // returns a 2x3 matrix with random numbers between 0 and 1
	   *
	   * See also:
	   *
	   *     randomInt, pickRandom
	   *
	   * @param {Array | Matrix} [size] If provided, an array or matrix with given
	   *                                size and filled with random values is returned
	   * @param {number} [min]  Minimum boundary for the random value, included
	   * @param {number} [max]  Maximum boundary for the random value, excluded
	   * @return {number | Array | Matrix} A random number
	   */
	  // TODO: rework random to a typed-function
	  var random = distribution('uniform').random;

	  random.toTex = '\\mathrm{${name}}\\left(${args}\\right)';

	  return random;
	}

	exports.name = 'random';
	exports.factory = factory;


/***/ },
/* 168 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	function factory (type, config, load, typed) {
	  var distribution = load(__webpack_require__(165));

	  /**
	   * Return a random integer number larger or equal to `min` and smaller than `max`
	   * using a uniform distribution.
	   *
	   * Syntax:
	   *
	   *     math.randomInt(max)             // generate a random integer between 0 and max
	   *     math.randomInt(min, max)        // generate a random integer between min and max
	   *     math.randomInt(size)            // generate a matrix with random integer between 0 and 1
	   *     math.randomInt(size, max)       // generate a matrix with random integer between 0 and max
	   *     math.randomInt(size, min, max)  // generate a matrix with random integer between min and max
	   *
	   * Examples:
	   *
	   *     math.randomInt(100);    // returns a random integer between 0 and 100
	   *     math.randomInt(30, 40); // returns a random integer between 30 and 40
	   *     math.randomInt([2, 3]); // returns a 2x3 matrix with random integers between 0 and 1
	   *
	   * See also:
	   *
	   *     random, pickRandom
	   *
	   * @param {Array | Matrix} [size] If provided, an array or matrix with given
	   *                                size and filled with random values is returned
	   * @param {number} [min]  Minimum boundary for the random value, included
	   * @param {number} [max]  Maximum boundary for the random value, excluded
	   * @return {number | Array | Matrix} A random integer value
	   */
	  // TODO: rework randomInt to a typed-function
	  var randomInt = distribution('uniform').randomInt;

	  randomInt.toTex = '\\mathrm{${name}}\\left(${args}\\right)';

	  return randomInt;
	}

	exports.name = 'randomInt';
	exports.factory = factory;


/***/ },
/* 169 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = [
	  __webpack_require__(170),
	  __webpack_require__(171),
	  __webpack_require__(172),
	  __webpack_require__(64),
	  __webpack_require__(79),
	  __webpack_require__(113),
	  __webpack_require__(173),
	  __webpack_require__(174)
	];


/***/ },
/* 170 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var nearlyEqual = __webpack_require__(8).nearlyEqual;

	function factory (type, config, load, typed) {

	  var matrix = load(__webpack_require__(23));

	  var algorithm03 = load(__webpack_require__(31));
	  var algorithm05 = load(__webpack_require__(32));
	  var algorithm12 = load(__webpack_require__(65));
	  var algorithm13 = load(__webpack_require__(35));
	  var algorithm14 = load(__webpack_require__(39));
	  
	  /**
	   * Compare two values. Returns 1 when x > y, -1 when x < y, and 0 when x == y.
	   *
	   * x and y are considered equal when the relative difference between x and y
	   * is smaller than the configured epsilon. The function cannot be used to
	   * compare values smaller than approximately 2.22e-16.
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.compare(x, y)
	   *
	   * Examples:
	   *
	   *    math.compare(6, 1);           // returns 1
	   *    math.compare(2, 3);           // returns -1
	   *    math.compare(7, 7);           // returns 0
	   *
	   *    var a = math.unit('5 cm');
	   *    var b = math.unit('40 mm');
	   *    math.compare(a, b);           // returns 1
	   *
	   *    math.compare(2, [1, 2, 3]);   // returns [1, 0, -1]
	   *
	   * See also:
	   *
	   *    equal, unequal, smaller, smallerEq, larger, largerEq
	   *
	   * @param  {number | BigNumber | Fraction | Unit | string | Array | Matrix} x First value to compare
	   * @param  {number | BigNumber | Fraction | Unit | string | Array | Matrix} y Second value to compare
	   * @return {number | BigNumber | Fraction | Array | Matrix} Returns the result of the comparison: 1, 0 or -1.
	   */
	  var compare = typed('compare', {

	    'boolean, boolean': function (x, y) {
	      return x === y ? 0 : (x > y ? 1 : -1);
	    },

	    'number, number': function (x, y) {
	      return (x === y || nearlyEqual(x, y, config.epsilon)) ? 0 : (x > y ? 1 : -1);
	    },

	    'BigNumber, BigNumber': function (x, y) {
	      return new type.BigNumber(x.cmp(y));
	    },

	    'Fraction, Fraction': function (x, y) {
	      return new type.Fraction(x.compare(y));
	    },

	    'Complex, Complex': function () {
	      throw new TypeError('No ordering relation is defined for complex numbers');
	    },

	    'Unit, Unit': function (x, y) {
	      if (!x.equalBase(y)) {
	        throw new Error('Cannot compare units with different base');
	      }
	      return (x.value === y.value || nearlyEqual(x.value, y.value, config.epsilon)) ? 0 : (x.value > y.value ? 1 : -1);
	    },

	    'string, string': function (x, y) {
	      return x === y ? 0 : (x > y ? 1 : -1);
	    },

	    'Matrix, Matrix': function (x, y) {
	      // result
	      var c;

	      // process matrix storage
	      switch (x.storage()) {
	        case 'sparse':
	          switch (y.storage()) {
	            case 'sparse':
	              // sparse + sparse
	              c = algorithm05(x, y, compare);
	              break;
	            default:
	              // sparse + dense
	              c = algorithm03(y, x, compare, true);
	              break;
	          }
	          break;
	        default:
	          switch (y.storage()) {
	            case 'sparse':
	              // dense + sparse
	              c = algorithm03(x, y, compare, false);
	              break;
	            default:
	              // dense + dense
	              c = algorithm13(x, y, compare);
	              break;
	          }
	          break;
	      }
	      return c;
	    },

	    'Array, Array': function (x, y) {
	      // use matrix implementation
	      return compare(matrix(x), matrix(y)).valueOf();
	    },

	    'Array, Matrix': function (x, y) {
	      // use matrix implementation
	      return compare(matrix(x), y);
	    },

	    'Matrix, Array': function (x, y) {
	      // use matrix implementation
	      return compare(x, matrix(y));
	    },

	    'Matrix, any': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (x.storage()) {
	        case 'sparse':
	          c = algorithm12(x, y, compare, false);
	          break;
	        default:
	          c = algorithm14(x, y, compare, false);
	          break;
	      }
	      return c;
	    },

	    'any, Matrix': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (y.storage()) {
	        case 'sparse':
	          c = algorithm12(y, x, compare, true);
	          break;
	        default:
	          c = algorithm14(y, x, compare, true);
	          break;
	      }
	      return c;
	    },

	    'Array, any': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(x), y, compare, false).valueOf();
	    },

	    'any, Array': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(y), x, compare, true).valueOf();
	    }
	  });

	  compare.toTex = '\\mathrm{${name}}\\left(${args}\\right)';

	  return compare;
	}

	exports.name = 'compare';
	exports.factory = factory;


/***/ },
/* 171 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	function factory (type, config, load, typed) {
	  var equal = load(__webpack_require__(172));

	  /**
	   * Test element wise whether two matrices are equal.
	   * The function accepts both matrices and scalar values.
	   *
	   * Syntax:
	   *
	   *    math.deepEqual(x, y)
	   *
	   * Examples:
	   *
	   *    math.deepEqual(2, 4);   // returns false
	   *
	   *    a = [2, 5, 1];
	   *    b = [2, 7, 1];
	   *
	   *    math.deepEqual(a, b);   // returns false
	   *    math.equal(a, b);       // returns [true, false, true]
	   *
	   * See also:
	   *
	   *    equal, unequal
	   *
	   * @param  {number | BigNumber | Fraction | Complex | Unit | Array | Matrix} x First matrix to compare
	   * @param  {number | BigNumber | Fraction | Complex | Unit | Array | Matrix} y Second matrix to compare
	   * @return {number | BigNumber | Fraction | Complex | Unit | Array | Matrix}
	   *            Returns true when the input matrices have the same size and each of their elements is equal.
	   */
	  var deepEqual = typed('deepEqual', {
	    'any, any': function (x, y) {
	      return _deepEqual(x.valueOf(), y.valueOf());
	    }
	  });

	  deepEqual.toTex = '\\mathrm{${name}}\\left(${args}\\right)';

	  return deepEqual;

	  /**
	   * Test whether two arrays have the same size and all elements are equal
	   * @param {Array | *} x
	   * @param {Array | *} y
	   * @return {boolean} Returns true if both arrays are deep equal
	   */
	  function _deepEqual(x, y) {
	    if (Array.isArray(x)) {
	      if (Array.isArray(y)) {
	        var len = x.length;
	        if (len !== y.length) {
	          return false;
	        }

	        for (var i = 0; i < len; i++) {
	          if (!_deepEqual(x[i], y[i])) {
	            return false;
	          }
	        }

	        return true;
	      }
	      else {
	        return false;
	      }
	    }
	    else {
	      if (Array.isArray(y)) {
	        return false;
	      }
	      else {
	        return equal(x, y);
	      }
	    }
	  }
	}

	exports.name = 'deepEqual';
	exports.factory = factory;


/***/ },
/* 172 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	function factory (type, config, load, typed) {
	  
	  var matrix = load(__webpack_require__(23));
	  var equalScalar = load(__webpack_require__(33));

	  var algorithm03 = load(__webpack_require__(31));
	  var algorithm07 = load(__webpack_require__(66));
	  var algorithm12 = load(__webpack_require__(65));
	  var algorithm13 = load(__webpack_require__(35));
	  var algorithm14 = load(__webpack_require__(39));

	  var latex = __webpack_require__(26);

	  /**
	   * Test whether two values are equal.
	   *
	   * The function tests whether the relative difference between x and y is
	   * smaller than the configured epsilon. The function cannot be used to
	   * compare values smaller than approximately 2.22e-16.
	   *
	   * For matrices, the function is evaluated element wise.
	   * In case of complex numbers, x.re must equal y.re, and x.im must equal y.im.
	   *
	   * Values `null` and `undefined` are compared strictly, thus `null` is only
	   * equal to `null` and nothing else, and `undefined` is only equal to
	   * `undefined` and nothing else.
	   *
	   * Syntax:
	   *
	   *    math.equal(x, y)
	   *
	   * Examples:
	   *
	   *    math.equal(2 + 2, 3);         // returns false
	   *    math.equal(2 + 2, 4);         // returns true
	   *
	   *    var a = math.unit('50 cm');
	   *    var b = math.unit('5 m');
	   *    math.equal(a, b);             // returns true
	   *
	   *    var c = [2, 5, 1];
	   *    var d = [2, 7, 1];
	   *
	   *    math.equal(c, d);             // returns [true, false, true]
	   *    math.deepEqual(c, d);         // returns false
	   *
	   *    math.equal(0, null);          // returns false
	   *
	   * See also:
	   *
	   *    unequal, smaller, smallerEq, larger, largerEq, compare, deepEqual
	   *
	   * @param  {number | BigNumber | boolean | Complex | Unit | string | Array | Matrix} x First value to compare
	   * @param  {number | BigNumber | boolean | Complex | Unit | string | Array | Matrix} y Second value to compare
	   * @return {boolean | Array | Matrix} Returns true when the compared values are equal, else returns false
	   */
	  var equal = typed('equal', {
	    
	    'any, any': function (x, y) {
	      // strict equality for null and undefined?
	      if (x === null) { return y === null; }
	      if (y === null) { return x === null; }
	      if (x === undefined) { return y === undefined; }
	      if (y === undefined) { return x === undefined; }

	      return equalScalar(x, y);
	    },

	    'Matrix, Matrix': function (x, y) {
	      // result
	      var c;

	      // process matrix storage
	      switch (x.storage()) {
	        case 'sparse':
	          switch (y.storage()) {
	            case 'sparse':
	              // sparse + sparse
	              c = algorithm07(x, y, equalScalar);
	              break;
	            default:
	              // sparse + dense
	              c = algorithm03(y, x, equalScalar, true);
	              break;
	          }
	          break;
	        default:
	          switch (y.storage()) {
	            case 'sparse':
	              // dense + sparse
	              c = algorithm03(x, y, equalScalar, false);
	              break;
	            default:
	              // dense + dense
	              c = algorithm13(x, y, equalScalar);
	              break;
	          }
	          break;
	      }
	      return c;
	    },
	    
	    'Array, Array': function (x, y) {
	      // use matrix implementation
	      return equal(matrix(x), matrix(y)).valueOf();
	    },

	    'Array, Matrix': function (x, y) {
	      // use matrix implementation
	      return equal(matrix(x), y);
	    },

	    'Matrix, Array': function (x, y) {
	      // use matrix implementation
	      return equal(x, matrix(y));
	    },
	    
	    'Matrix, any': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (x.storage()) {
	        case 'sparse':
	          c = algorithm12(x, y, equalScalar, false);
	          break;
	        default:
	          c = algorithm14(x, y, equalScalar, false);
	          break;
	      }
	      return c;
	    },

	    'any, Matrix': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (y.storage()) {
	        case 'sparse':
	          c = algorithm12(y, x, equalScalar, true);
	          break;
	        default:
	          c = algorithm14(y, x, equalScalar, true);
	          break;
	      }
	      return c;
	    },

	    'Array, any': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(x), y, equalScalar, false).valueOf();
	    },

	    'any, Array': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(y), x, equalScalar, true).valueOf();
	    }
	  });

	  equal.toTex = '\\left(${args[0]}' + latex.operators['equal'] + '${args[1]}\\right)';

	  return equal;
	}

	exports.name = 'equal';
	exports.factory = factory;


/***/ },
/* 173 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var nearlyEqual = __webpack_require__(8).nearlyEqual;

	function factory (type, config, load, typed) {

	  var matrix = load(__webpack_require__(23));

	  var algorithm03 = load(__webpack_require__(31));
	  var algorithm07 = load(__webpack_require__(66));
	  var algorithm12 = load(__webpack_require__(65));
	  var algorithm13 = load(__webpack_require__(35));
	  var algorithm14 = load(__webpack_require__(39));

	  var latex = __webpack_require__(26);

	  /**
	   * Test whether value x is smaller or equal to y.
	   *
	   * The function returns true when x is smaller than y or the relative
	   * difference between x and y is smaller than the configured epsilon. The
	   * function cannot be used to compare values smaller than approximately 2.22e-16.
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.smallerEq(x, y)
	   *
	   * Examples:
	   *
	   *    math.smaller(1 + 2, 3);        // returns false
	   *    math.smallerEq(1 + 2, 3);      // returns true
	   *
	   * See also:
	   *
	   *    equal, unequal, smaller, larger, largerEq, compare
	   *
	   * @param  {number | BigNumber | Fraction | boolean | Unit | string | Array | Matrix} x First value to compare
	   * @param  {number | BigNumber | Fraction | boolean | Unit | string | Array | Matrix} y Second value to compare
	   * @return {boolean | Array | Matrix} Returns true when the x is smaller than y, else returns false
	   */
	  var smallerEq = typed('smallerEq', {

	    'boolean, boolean': function (x, y) {
	      return x <= y;
	    },

	    'number, number': function (x, y) {
	      return x <= y || nearlyEqual(x, y, config.epsilon);
	    },

	    'BigNumber, BigNumber': function (x, y) {
	      return x.lte(y);
	    },

	    'Fraction, Fraction': function (x, y) {
	      return x.compare(y) !== 1;
	    },

	    'Complex, Complex': function () {
	      throw new TypeError('No ordering relation is defined for complex numbers');
	    },

	    'Unit, Unit': function (x, y) {
	      if (!x.equalBase(y)) {
	        throw new Error('Cannot compare units with different base');
	      }
	      return x.value <= y.value || nearlyEqual(x.value, y.value, config.epsilon);
	    },

	    'string, string': function (x, y) {
	      return x <= y;
	    },

	    'Matrix, Matrix': function (x, y) {
	      // result
	      var c;

	      // process matrix storage
	      switch (x.storage()) {
	        case 'sparse':
	          switch (y.storage()) {
	            case 'sparse':
	              // sparse + sparse
	              c = algorithm07(x, y, smallerEq);
	              break;
	            default:
	              // sparse + dense
	              c = algorithm03(y, x, smallerEq, true);
	              break;
	          }
	          break;
	        default:
	          switch (y.storage()) {
	            case 'sparse':
	              // dense + sparse
	              c = algorithm03(x, y, smallerEq, false);
	              break;
	            default:
	              // dense + dense
	              c = algorithm13(x, y, smallerEq);
	              break;
	          }
	          break;
	      }
	      return c;
	    },

	    'Array, Array': function (x, y) {
	      // use matrix implementation
	      return smallerEq(matrix(x), matrix(y)).valueOf();
	    },

	    'Array, Matrix': function (x, y) {
	      // use matrix implementation
	      return smallerEq(matrix(x), y);
	    },

	    'Matrix, Array': function (x, y) {
	      // use matrix implementation
	      return smallerEq(x, matrix(y));
	    },

	    'Matrix, any': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (x.storage()) {
	        case 'sparse':
	          c = algorithm12(x, y, smallerEq, false);
	          break;
	        default:
	          c = algorithm14(x, y, smallerEq, false);
	          break;
	      }
	      return c;
	    },

	    'any, Matrix': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (y.storage()) {
	        case 'sparse':
	          c = algorithm12(y, x, smallerEq, true);
	          break;
	        default:
	          c = algorithm14(y, x, smallerEq, true);
	          break;
	      }
	      return c;
	    },

	    'Array, any': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(x), y, smallerEq, false).valueOf();
	    },

	    'any, Array': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(y), x, smallerEq, true).valueOf();
	    }
	  });

	  smallerEq.toTex = '\\left(${args[0]}' + latex.operators['smallerEq'] + '${args[1]}\\right)';

	  return smallerEq;
	}

	exports.name = 'smallerEq';
	exports.factory = factory;


/***/ },
/* 174 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var nearlyEqual = __webpack_require__(8).nearlyEqual;

	function factory (type, config, load, typed) {

	  var matrix = load(__webpack_require__(23));

	  var algorithm03 = load(__webpack_require__(31));
	  var algorithm07 = load(__webpack_require__(66));
	  var algorithm12 = load(__webpack_require__(65));
	  var algorithm13 = load(__webpack_require__(35));
	  var algorithm14 = load(__webpack_require__(39));

	  var latex = __webpack_require__(26);

	  /**
	   * Test whether two values are unequal.
	   *
	   * The function tests whether the relative difference between x and y is
	   * larger than the configured epsilon. The function cannot be used to compare
	   * values smaller than approximately 2.22e-16.
	   *
	   * For matrices, the function is evaluated element wise.
	   * In case of complex numbers, x.re must unequal y.re, or x.im must unequal y.im.
	   *
	   * Values `null` and `undefined` are compared strictly, thus `null` is unequal
	   * with everything except `null`, and `undefined` is unequal with everying
	   * except. `undefined`.
	   *
	   * Syntax:
	   *
	   *    math.unequal(x, y)
	   *
	   * Examples:
	   *
	   *    math.unequal(2 + 2, 3);       // returns true
	   *    math.unequal(2 + 2, 4);       // returns false
	   *
	   *    var a = math.unit('50 cm');
	   *    var b = math.unit('5 m');
	   *    math.unequal(a, b);           // returns false
	   *
	   *    var c = [2, 5, 1];
	   *    var d = [2, 7, 1];
	   *
	   *    math.unequal(c, d);           // returns [false, true, false]
	   *    math.deepEqual(c, d);         // returns false
	   *
	   *    math.unequal(0, null);        // returns true
	   * See also:
	   *
	   *    equal, deepEqual, smaller, smallerEq, larger, largerEq, compare
	   *
	   * @param  {number | BigNumber | Fraction | boolean | Complex | Unit | string | Array | Matrix | undefined} x First value to compare
	   * @param  {number | BigNumber | Fraction | boolean | Complex | Unit | string | Array | Matrix | undefined} y Second value to compare
	   * @return {boolean | Array | Matrix} Returns true when the compared values are unequal, else returns false
	   */
	  var unequal = typed('unequal', {
	    
	    'any, any': function (x, y) {
	      // strict equality for null and undefined?
	      if (x === null) { return y !== null; }
	      if (y === null) { return x !== null; }
	      if (x === undefined) { return y !== undefined; }
	      if (y === undefined) { return x !== undefined; }

	      return _unequal(x, y);
	    },

	    'Matrix, Matrix': function (x, y) {
	      // result
	      var c;

	      // process matrix storage
	      switch (x.storage()) {
	        case 'sparse':
	          switch (y.storage()) {
	            case 'sparse':
	              // sparse + sparse
	              c = algorithm07(x, y, _unequal);
	              break;
	            default:
	              // sparse + dense
	              c = algorithm03(y, x, _unequal, true);
	              break;
	          }
	          break;
	        default:
	          switch (y.storage()) {
	            case 'sparse':
	              // dense + sparse
	              c = algorithm03(x, y, _unequal, false);
	              break;
	            default:
	              // dense + dense
	              c = algorithm13(x, y, _unequal);
	              break;
	          }
	          break;
	      }
	      return c;
	    },

	    'Array, Array': function (x, y) {
	      // use matrix implementation
	      return unequal(matrix(x), matrix(y)).valueOf();
	    },

	    'Array, Matrix': function (x, y) {
	      // use matrix implementation
	      return unequal(matrix(x), y);
	    },

	    'Matrix, Array': function (x, y) {
	      // use matrix implementation
	      return unequal(x, matrix(y));
	    },

	    'Matrix, any': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (x.storage()) {
	        case 'sparse':
	          c = algorithm12(x, y, _unequal, false);
	          break;
	        default:
	          c = algorithm14(x, y, _unequal, false);
	          break;
	      }
	      return c;
	    },

	    'any, Matrix': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (y.storage()) {
	        case 'sparse':
	          c = algorithm12(y, x, _unequal, true);
	          break;
	        default:
	          c = algorithm14(y, x, _unequal, true);
	          break;
	      }
	      return c;
	    },

	    'Array, any': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(x), y, _unequal, false).valueOf();
	    },

	    'any, Array': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(y), x, _unequal, true).valueOf();
	    }
	  });

	  var _unequal = typed('_unequal', {

	    'boolean, boolean': function (x, y) {
	      return x !== y;
	    },

	    'number, number': function (x, y) {
	      return !nearlyEqual(x, y, config.epsilon);
	    },

	    'BigNumber, BigNumber': function (x, y) {
	      return !x.eq(y);
	    },

	    'Fraction, Fraction': function (x, y) {
	      return x.compare(y) !== 0;
	    },

	    'Complex, Complex': function (x, y) {
	      return !nearlyEqual(x.re, y.re, config.epsilon) ||
	          !nearlyEqual(x.im, y.im, config.epsilon);
	    },

	    'Unit, Unit': function (x, y) {
	      if (!x.equalBase(y)) {
	        throw new Error('Cannot compare units with different base');
	      }
	      return !nearlyEqual(x.value, y.value, config.epsilon);
	    },

	    'string, string': function (x, y) {
	      return x !== y;
	    }
	  });

	  unequal.toTex = '\\left(${args[0]}' + latex.operators['unequal'] + '${args[1]}\\right)';

	  return unequal;
	}

	exports.name = 'unequal';
	exports.factory = factory;


/***/ },
/* 175 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = [
	  __webpack_require__(176),
	  __webpack_require__(178),
	  __webpack_require__(179),
	  __webpack_require__(181),
	  __webpack_require__(182),
	  __webpack_require__(183),
	  __webpack_require__(184),
	  __webpack_require__(186),
	  __webpack_require__(185)
	];

/***/ },
/* 176 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepForEach = __webpack_require__(163);
	var reduce = __webpack_require__(177);

	function factory (type, config, load, typed) {
	  var larger = load(__webpack_require__(64));

	  /**
	   * Compute the maximum value of a matrix or a  list with values.
	   * In case of a multi dimensional array, the maximum of the flattened array
	   * will be calculated. When `dim` is provided, the maximum over the selected
	   * dimension will be calculated. Parameter `dim` is zero-based.
	   *
	   * Syntax:
	   *
	   *     math.max(a, b, c, ...)
	   *     math.max(A)
	   *     math.max(A, dim)
	   *
	   * Examples:
	   *
	   *     math.max(2, 1, 4, 3);                  // returns 4
	   *     math.max([2, 1, 4, 3]);                // returns 4
	   *
	   *     // maximum over a specified dimension (zero-based)
	   *     math.max([[2, 5], [4, 3], [1, 7]], 0); // returns [4, 7]
	   *     math.max([[2, 5], [4, 3]], [1, 7], 1); // returns [5, 4, 7]
	   *
	   *     math.max(2.7, 7.1, -4.5, 2.0, 4.1);    // returns 7.1
	   *     math.min(2.7, 7.1, -4.5, 2.0, 4.1);    // returns -4.5
	   *
	   * See also:
	   *
	   *    mean, median, min, prod, std, sum, var
	   *
	   * @param {... *} args  A single matrix or or multiple scalar values
	   * @return {*} The maximum value
	   */
	  var max = typed('max', {
	    // max([a, b, c, d, ...])
	    'Array | Matrix': _max,

	    // max([a, b, c, d, ...], dim)
	    'Array | Matrix, number | BigNumber': function (array, dim) {
	      return reduce(array, dim.valueOf(), _largest);
	    },

	    // max(a, b, c, d, ...)
	    '...': function () {
	      return _max(arguments);
	    }
	  });

	  max.toTex = '\\max\\left(${args}\\right)';

	  return max;

	  /**
	   * Return the largest of two values
	   * @param {*} x
	   * @param {*} y
	   * @returns {*} Returns x when x is largest, or y when y is largest
	   * @private
	   */
	  function _largest(x, y){
	    return larger(x, y) ? x : y;
	  }

	  /**
	   * Recursively calculate the maximum value in an n-dimensional array
	   * @param {Array} array
	   * @return {number} max
	   * @private
	   */
	  function _max(array) {
	    var max = undefined;

	    deepForEach(array, function (value) {
	      if (max === undefined || larger(value, max)) {
	        max = value;
	      }
	    });

	    if (max === undefined) {
	      throw new Error('Cannot calculate max of an empty array');
	    }

	    return max;
	  }
	}

	exports.name = 'max';
	exports.factory = factory;


/***/ },
/* 177 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var arraySize = __webpack_require__(18).size;
	var IndexError = __webpack_require__(17);

	/**
	 * Reduce a given matrix or array to a new matrix or
	 * array with one less dimension, applying the given
	 * callback in the selected dimension.
	 * @param {Array | Matrix} mat
	 * @param {number} dim
	 * @param {Function} callback
	 * @return {Array | Matrix} res
	 */
	module.exports = function(mat, dim, callback) {
	  var size = Array.isArray(mat) ? arraySize(mat) : mat.size();
	  if (dim < 0) {
	    // TODO: would be more clear when throwing a DimensionError here
	    throw new IndexError(dim);
	  }
	  if (dim >= size.length) {
	    // TODO: would be more clear when throwing a DimensionError here
	    throw new IndexError(dim, size.length);
	  }

	  if (mat && mat.isMatrix === true) {
	    return mat.create(_reduce(mat.valueOf(), dim, callback));
	  }else {
	    return _reduce(mat, dim, callback);
	  }
	};

	/**
	 * Recursively reduce a matrix
	 * @param {Array} mat
	 * @param {number} dim
	 * @param {Function} callback
	 * @returns {Array} ret
	 * @private
	 */
	function _reduce(mat, dim, callback){
	  var i, ret, val, tran;

	  if(dim<=0){
	    if( !Array.isArray(mat[0]) ){
	      val = mat[0];
	      for(i=1; i<mat.length; i++){
	        val = callback(val, mat[i]);
	      }
	      return val;
	    }else{
	      tran = _switch(mat);
	      ret = [];
	      for(i=0; i<tran.length; i++){
	        ret[i] = _reduce(tran[i], dim-1, callback);
	      }
	      return ret;
	    }
	  }else{
	    ret = [];
	    for(i=0; i<mat.length; i++){
	      ret[i] = _reduce(mat[i], dim-1, callback);
	    }
	    return ret;
	  }
	}

	/**
	 * Transpose a matrix
	 * @param {Array} mat
	 * @returns {Array} ret
	 * @private
	 */
	function _switch(mat){
	  var I = mat.length;
	  var J = mat[0].length;
	  var i, j;
	  var ret = [];
	  for( j=0; j<J; j++) {
	    var tmp = [];
	    for( i=0; i<I; i++) {
	      tmp.push(mat[i][j]);
	    }
	    ret.push(tmp);
	  }
	  return ret;
	}


/***/ },
/* 178 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var size = __webpack_require__(18).size;
	var deepForEach = __webpack_require__(163);
	var reduce = __webpack_require__(177);

	function factory (type, config, load, typed) {
	  var add = load(__webpack_require__(44));
	  var divide = load(__webpack_require__(94));

	  /**
	   * Compute the mean value of matrix or a list with values.
	   * In case of a multi dimensional array, the mean of the flattened array
	   * will be calculated. When `dim` is provided, the maximum over the selected
	   * dimension will be calculated. Parameter `dim` is zero-based.
	   *
	   * Syntax:
	   *
	   *     math.mean(a, b, c, ...)
	   *     math.mean(A)
	   *     math.mean(A, dim)
	   *
	   * Examples:
	   *
	   *     math.mean(2, 1, 4, 3);                     // returns 2.5
	   *     math.mean([1, 2.7, 3.2, 4]);               // returns 2.725
	   *
	   *     math.mean([[2, 5], [6, 3], [1, 7]], 0);    // returns [3, 5]
	   *     math.mean([[2, 5], [6, 3], [1, 7]], 1);    // returns [3.5, 4.5, 4]
	   *
	   * See also:
	   *
	   *     median, min, max, sum, prod, std, var
	   *
	   * @param {... *} args  A single matrix or or multiple scalar values
	   * @return {*} The mean of all values
	   */
	  var mean = typed('mean', {
	      // mean([a, b, c, d, ...])
	    'Array | Matrix': _mean,

	      // mean([a, b, c, d, ...], dim)
	    'Array | Matrix, number | BigNumber': _nmean,

	    // mean(a, b, c, d, ...)
	    '...': function () {
	      return _mean(arguments);
	    }
	  });

	  mean.toTex = '\\mathrm{${name}}\\left(${args}\\right)';

	  return mean;

	  /**
	   * Calculate the mean value in an n-dimensional array, returning a
	   * n-1 dimensional array
	   * @param {Array} array
	   * @param {number} dim
	   * @return {number} mean
	   * @private
	   */
	  function _nmean(array, dim){
		  var sum = reduce(array, dim, add);
	    var s = Array.isArray(array) ? size(array) : array.size();
	    return divide(sum, s[dim]);
	  }

	  /**
	   * Recursively calculate the mean value in an n-dimensional array
	   * @param {Array} array
	   * @return {number} mean
	   * @private
	   */
	  function _mean(array) {
	    var sum = 0;
	    var num = 0;

	    deepForEach(array, function (value) {
	      sum = add(sum, value);
	      num++;
	    });

	    if (num === 0) {
	      throw new Error('Cannot calculate mean of an empty array');
	    }

	    return divide(sum, num);
	  }
	}

	exports.name = 'mean';
	exports.factory = factory;


/***/ },
/* 179 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var flatten = __webpack_require__(18).flatten;

	function factory (type, config, load, typed) {
	  var add = load(__webpack_require__(27));
	  var divide = load(__webpack_require__(51));
	  var compare = load(__webpack_require__(170));
	  var partitionSelect = load(__webpack_require__(180));

	  /**
	   * Compute the median of a matrix or a list with values. The values are
	   * sorted and the middle value is returned. In case of an even number of
	   * values, the average of the two middle values is returned.
	   * Supported types of values are: Number, BigNumber, Unit
	   *
	   * In case of a (multi dimensional) array or matrix, the median of all
	   * elements will be calculated.
	   *
	   * Syntax:
	   *
	   *     math.median(a, b, c, ...)
	   *     math.median(A)
	   *
	   * Examples:
	   *
	   *     math.median(5, 2, 7);        // returns 5
	   *     math.median([3, -1, 5, 7]);  // returns 4
	   *
	   * See also:
	   *
	   *     mean, min, max, sum, prod, std, var
	   *
	   * @param {... *} args  A single matrix or or multiple scalar values
	   * @return {*} The median
	   */
	  var median = typed('median', {
	    // median([a, b, c, d, ...])
	    'Array | Matrix': _median,

	    // median([a, b, c, d, ...], dim)
	    'Array | Matrix, number | BigNumber': function (array, dim) {
	      // TODO: implement median(A, dim)
	      throw new Error('median(A, dim) is not yet supported');
	      //return reduce(arguments[0], arguments[1], ...);
	    },

	    // median(a, b, c, d, ...)
	    '...': function () {
	      return _median(Array.prototype.slice.call(arguments));
	    }
	  });


	  /**
	   * Recursively calculate the median of an n-dimensional array
	   * @param {Array} array
	   * @return {Number} median
	   * @private
	   */
	  function _median(array) {
	    array = flatten(array.valueOf());

	    var num = array.length;
	    if (num == 0) {
	      throw new Error('Cannot calculate median of an empty array');
	    }

	    if (num % 2 == 0) {
	      // even: return the average of the two middle values
	      var mid = num / 2 - 1;
	      var right = partitionSelect(array, mid + 1);

	      // array now partitioned at mid + 1, take max of left part
	      var left = array[mid];
	      for (var i = 0; i < mid; ++i) {
	        if (compare(array[i], left) > 0) {
	          left = array[i];
	        }
	      }

	      return middle2(left, right);
	    }
	    else {
	      // odd: return the middle value
	      var m = partitionSelect(array, (num - 1) / 2);

	      return middle(m);
	    }
	  }

	  // helper function to type check the middle value of the array
	  var middle = typed({
	    'number | BigNumber | Unit': function (value) {
	      return value;
	    }
	  });

	  // helper function to type check the two middle value of the array
	  var middle2 = typed({
	    'number | BigNumber | Unit, number | BigNumber | Unit': function (left, right) {
	      return divide(add(left, right), 2);
	    }
	  });

	  median.toTex = '\\mathrm{${name}}\\left(${args}\\right)';

	  return median;
	}

	exports.name = 'median';
	exports.factory = factory;


/***/ },
/* 180 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var isInteger = __webpack_require__(8).isInteger;

	function factory (type, config, load, typed) {
	  var asc = load(__webpack_require__(170));
	  function desc(a, b) {
	    return -asc(a, b);
	  }

	  /**
	   * Partition-based selection of an array or 1D matrix.
	   * Will find the kth smallest value, and mutates the input array.
	   * Uses Quickselect.
	   *
	   * Syntax:
	   *
	   *    math.partitionSelect(x, k)
	   *    math.partitionSelect(x, k, compare)
	   *
	   * Examples:
	   *
	   *    math.partitionSelect([5, 10, 1], 2);           // returns 10
	   *    math.partitionSelect(['C', 'B', 'A', 'D'], 1); // returns 'B'
	   *
	   *    function sortByLength (a, b) {
	   *      return a.length - b.length;
	   *    }
	   *    math.partitionSelect(['Langdon', 'Tom', 'Sara'], 2, sortByLength); // returns 'Langdon'
	   *
	   * See also:
	   *
	   *    sort
	   *
	   * @param {Matrix | Array} x    A one dimensional matrix or array to sort
	   * @param {Number} k            The kth smallest value to be retrieved; zero-based index
	   * @param {Function | 'asc' | 'desc'} [compare='asc']
	   *        An optional comparator function. The function is called as
	   *        `compare(a, b)`, and must return 1 when a > b, -1 when a < b,
	   *        and 0 when a == b.
	   * @return {*} Returns the kth lowest value.
	   */
	  return typed('partitionSelect', {
	    'Array | Matrix, number': function (x, k) {
	      return _partitionSelect(x, k, asc);
	    },

	    'Array | Matrix, number, string': function (x, k, compare) {
	      if (compare === 'asc') {
	        return _partitionSelect(x, k, asc);
	      }
	      else if (compare === 'desc') {
	        return _partitionSelect(x, k, desc);
	      }
	      else {
	        throw new Error('Compare string must be "asc" or "desc"');
	      }
	    },

	    'Array | Matrix, number, function': _partitionSelect
	  });

	  function _partitionSelect(x, k, compare) {
	    if (!isInteger(k) || k < 0) {
	      throw new Error('k must be a non-negative integer');
	    }

	    if (x && x.isMatrix) {
	      var size = x.size();
	      if (size.length > 1) {
	        throw new Error('Only one dimensional matrices supported');
	      }
	      return quickSelect(x.valueOf(), k, compare);
	    }

	    if (Array.isArray(x)) {
	      return quickSelect(x, k, compare);
	    }
	  }

	  /**
	   * Quickselect algorithm.
	   * Code adapted from:
	   * http://blog.teamleadnet.com/2012/07/quick-select-algorithm-find-kth-element.html
	   *
	   * @param {Array} arr
	   * @param {Number} k
	   * @param {Function} compare
	   * @private
	   */
	  function quickSelect(arr, k, compare) {
	    if (k >= arr.length) {
	      throw new Error('k out of bounds');
	    }

	    var from = 0;
	    var to = arr.length - 1;

	    // if from == to we reached the kth element
	    while (from < to) {
	      var r = from;
	      var w = to;
	      var pivot = arr[Math.floor(Math.random() * (to - from + 1)) + from];

	      // stop if the reader and writer meets
	      while (r < w) {
	        // arr[r] >= pivot
	        if (compare(arr[r], pivot) >= 0) { // put the large values at the end
	          var tmp = arr[w];
	          arr[w] = arr[r];
	          arr[r] = tmp;
	          --w;
	        } else { // the value is smaller than the pivot, skip
	          ++r;
	        }
	      }

	      // if we stepped up (r++) we need to step one down (arr[r] > pivot)
	      if (compare(arr[r], pivot) > 0) {
	        --r;
	      }

	      // the r pointer is on the end of the first k elements
	      if (k <= r) {
	        to = r;
	      } else {
	        from = r + 1;
	      }
	    }

	    return arr[k];
	  }
	}

	exports.name = 'partitionSelect';
	exports.factory = factory;


/***/ },
/* 181 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepForEach = __webpack_require__(163);
	var reduce = __webpack_require__(177);

	function factory (type, config, load, typed) {
	  var smaller = load(__webpack_require__(113));
	  
	  /**
	   * Compute the maximum value of a matrix or a  list of values.
	   * In case of a multi dimensional array, the maximum of the flattened array
	   * will be calculated. When `dim` is provided, the maximum over the selected
	   * dimension will be calculated. Parameter `dim` is zero-based.
	   *
	   * Syntax:
	   *
	   *     math.min(a, b, c, ...)
	   *     math.min(A)
	   *     math.min(A, dim)
	   *
	   * Examples:
	   *
	   *     math.min(2, 1, 4, 3);                  // returns 1
	   *     math.min([2, 1, 4, 3]);                // returns 1
	   *
	   *     // maximum over a specified dimension (zero-based)
	   *     math.min([[2, 5], [4, 3], [1, 7]], 0); // returns [1, 3]
	   *     math.min([[2, 5], [4, 3], [1, 7]], 1); // returns [2, 3, 1]
	   *
	   *     math.max(2.7, 7.1, -4.5, 2.0, 4.1);    // returns 7.1
	   *     math.min(2.7, 7.1, -4.5, 2.0, 4.1);    // returns -4.5
	   *
	   * See also:
	   *
	   *    mean, median, max, prod, std, sum, var
	   *
	   * @param {... *} args  A single matrix or or multiple scalar values
	   * @return {*} The minimum value
	   */
	  var min = typed('min', {
	    // min([a, b, c, d, ...])
	    'Array | Matrix': _min,

	    // min([a, b, c, d, ...], dim)
	    'Array | Matrix, number | BigNumber': function (array, dim) {
	      return reduce(array, dim.valueOf(), _smallest);
	    },

	    // min(a, b, c, d, ...)
	    '...': function () {
	      return _min(arguments);
	    }
	  });

	  min.toTex = '\\min\\left(${args}\\right)';

	  return min;

	  /**
	   * Return the smallest of two values
	   * @param {*} x
	   * @param {*} y
	   * @returns {*} Returns x when x is smallest, or y when y is smallest
	   * @private
	   */
	  function _smallest(x, y) {
	    return smaller(x, y) ? x : y;
	  }

	  /**
	   * Recursively calculate the minimum value in an n-dimensional array
	   * @param {Array} array
	   * @return {number} min
	   * @private
	   */
	  function _min(array) {
	    var min = undefined;

	    deepForEach(array, function (value) {
	      if (min === undefined || smaller(value, min)) {
	        min = value;
	      }
	    });

	    if (min === undefined) {
	      throw new Error('Cannot calculate min of an empty array');
	    }

	    return min;
	  }
	}

	exports.name = 'min';
	exports.factory = factory;


/***/ },
/* 182 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepForEach = __webpack_require__(163);

	function factory (type, config, load, typed) {
	  var multiply = load(__webpack_require__(41));

	  /**
	   * Compute the product of a matrix or a list with values.
	   * In case of a (multi dimensional) array or matrix, the sum of all
	   * elements will be calculated.
	   *
	   * Syntax:
	   *
	   *     math.prod(a, b, c, ...)
	   *     math.prod(A)
	   *
	   * Examples:
	   *
	   *     math.multiply(2, 3);           // returns 6
	   *     math.prod(2, 3);               // returns 6
	   *     math.prod(2, 3, 4);            // returns 24
	   *     math.prod([2, 3, 4]);          // returns 24
	   *     math.prod([[2, 5], [4, 3]]);   // returns 120
	   *
	   * See also:
	   *
	   *    mean, median, min, max, sum, std, var
	   *
	   * @param {... *} args  A single matrix or or multiple scalar values
	   * @return {*} The product of all values
	   */
	  var prod = typed('prod', {
	    // prod([a, b, c, d, ...])
	    'Array | Matrix': _prod,

	    // prod([a, b, c, d, ...], dim)
	    'Array | Matrix, number | BigNumber': function (array, dim) {
	      // TODO: implement prod(A, dim)
	      throw new Error('prod(A, dim) is not yet supported');
	      //return reduce(arguments[0], arguments[1], math.prod);
	    },

	    // prod(a, b, c, d, ...)
	    '...': function () {
	      return _prod(arguments);
	    }
	  });

	  prod.toTex = '\\mathrm{${name}}\\left(${args}\\right)';

	  return prod;

	  /**
	   * Recursively calculate the product of an n-dimensional array
	   * @param {Array} array
	   * @return {number} prod
	   * @private
	   */
	  function _prod(array) {
	    var prod = undefined;

	    deepForEach(array, function (value) {
	      prod = (prod === undefined) ? value : multiply(prod, value);
	    });

	    if (prod === undefined) {
	      throw new Error('Cannot calculate prod of an empty array');
	    }

	    return prod;
	  }
	}

	exports.name = 'prod';
	exports.factory = factory;


/***/ },
/* 183 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var isInteger = __webpack_require__(8).isInteger;
	var isNumber = __webpack_require__(8).isNumber;
	var flatten = __webpack_require__(18).flatten;
	var isCollection = __webpack_require__(166);

	function factory (type, config, load, typed) {
	  var add = load(__webpack_require__(44));
	  var multiply = load(__webpack_require__(40));
	  var partitionSelect = load(__webpack_require__(180));
	  var compare = load(__webpack_require__(170));

	  /**
	   * Compute the prob order quantile of a matrix or a list with values.
	   * The sequence is sorted and the middle value is returned.
	   * Supported types of sequence values are: Number, BigNumber, Unit
	   * Supported types of probability are: Number, BigNumber
	   *
	   * In case of a (multi dimensional) array or matrix, the prob order quantile
	   * of all elements will be calculated.
	   *
	   * Syntax:
	   *
	   *     math.quantileSeq(A, prob[, sorted])
	   *     math.quantileSeq(A, [prob1, prob2, ...][, sorted])
	   *     math.quantileSeq(A, N[, sorted])
	   *
	   * Examples:
	   *
	   *     math.quantileSeq([3, -1, 5, 7], 0.5);         // returns 4
	   *     math.quantileSeq([3, -1, 5, 7], [1/3, 2/3]);  // returns [3, 5]
	   *     math.quantileSeq([3, -1, 5, 7], 2);           // returns [3, 5]
	   *     math.quantileSeq([-1, 3, 5, 7], 0.5, true);   // returns 4
	   *
	   * See also:
	   *
	   *     median, mean, min, max, sum, prod, std, var
	   *
	   * @param {Array, Matrix} data                A single matrix or Array
	   * @param {Number, BigNumber, Array} probOrN  prob is the order of the quantile, while N is
	   *                                            the amount of evenly distributed steps of
	   *                                            probabilities; only one of these options can
	   *                                            be provided
	   * @param {Boolean} sorted=false              is data sorted in ascending order
	   * @return {Number, BigNumber, Unit, Array}   Quantile(s)
	   */
	  function quantileSeq(data, probOrN, sorted) {
	    var probArr, dataArr, one;

	    if (arguments.length < 2 || arguments.length > 3) {
	      throw new SyntaxError('Function quantileSeq requires two or three parameters');
	    }

	    if (isCollection(data)) {
	      sorted = sorted || false;
	      if (typeof sorted === 'boolean') {
	        dataArr = data.valueOf();
	        if (isNumber(probOrN)) {
	          if (probOrN < 0) {
	            throw new Error('N/prob must be non-negative');
	          }

	          if (probOrN <= 1) {
	            // quantileSeq([a, b, c, d, ...], prob[,sorted])
	            return _quantileSeq(dataArr, probOrN, sorted);
	          }

	          if (probOrN > 1) {
	            // quantileSeq([a, b, c, d, ...], N[,sorted])
	            if (!isInteger(probOrN)) {
	              throw new Error('N must be a positive integer');
	            }

	            var nPlusOne = probOrN + 1;
	            probArr = new Array(probOrN);
	            for (var i = 0; i < probOrN;) {
	              probArr[i] = _quantileSeq(dataArr, (++i) / nPlusOne, sorted);
	            }
	            return probArr;
	          }
	        }

	        if (probOrN && probOrN.isBigNumber) {
	          if (probOrN.isNegative()) {
	            throw new Error('N/prob must be non-negative');
	          }

	          one = probOrN.constructor.ONE;

	          if (probOrN.lte(one)) {
	            // quantileSeq([a, b, c, d, ...], prob[,sorted])
	            return _quantileSeq(dataArr, probOrN, sorted);
	          }

	          if (probOrN.gt(one)) {
	            // quantileSeq([a, b, c, d, ...], N[,sorted])
	            if (!probOrN.isInteger()) {
	              throw new Error('N must be a positive integer');
	            }

	            // largest possible Array length is 2^32-1;
	            // 2^32 < 10^15, thus safe conversion guaranteed
	            var intN = probOrN.toNumber();
	            if (intN > 4294967295) {
	              throw new Error('N must be less than or equal to 2^32-1, as that is the maximum length of an Array');
	            }

	            var nPlusOne = new type.BigNumber(intN + 1);
	            probArr = new Array(intN);
	            for (var i = 0; i < intN;) {
	              probArr[i] = _quantileSeq(dataArr, new type.BigNumber(++i).div(nPlusOne), sorted);
	            }
	            return probArr;
	          }
	        }

	        if (Array.isArray(probOrN)) {
	          // quantileSeq([a, b, c, d, ...], [prob1, prob2, ...][,sorted])
	          probArr = new Array(probOrN.length);
	          for (var i = 0; i < probArr.length; ++i) {
	            var currProb = probOrN[i];
	            if (isNumber(currProb)) {
	              if (currProb < 0 || currProb > 1) {
	                throw new Error('Probability must be between 0 and 1, inclusive');
	              }
	            } else if (currProb && currProb.isBigNumber) {
	              one = currProb.constructor.ONE;
	              if (currProb.isNegative() || currProb.gt(one)) {
	                throw new Error('Probability must be between 0 and 1, inclusive');
	              }
	            } else {
	              throw new TypeError('Unexpected type of argument in function quantileSeq'); // FIXME: becomes redundant when converted to typed-function
	            }

	            probArr[i] = _quantileSeq(dataArr, currProb, sorted);
	          }
	          return probArr;
	        }

	        throw new TypeError('Unexpected type of argument in function quantileSeq'); // FIXME: becomes redundant when converted to typed-function
	      }

	      throw new TypeError('Unexpected type of argument in function quantileSeq'); // FIXME: becomes redundant when converted to typed-function
	    }

	    throw new TypeError('Unexpected type of argument in function quantileSeq'); // FIXME: becomes redundant when converted to typed-function
	  }

	  /**
	   * Calculate the prob order quantile of an n-dimensional array.
	   * 
	   * @param {Array} array
	   * @param {Number, BigNumber} prob
	   * @param {Boolean} sorted
	   * @return {Number, BigNumber, Unit} prob order quantile
	   * @private
	   */
	  function _quantileSeq(array, prob, sorted) {
	    var flat = flatten(array);
	    var len = flat.length;
	    if (len === 0) {
	      throw new Error('Cannot calculate quantile of an empty sequence');
	    }

	    if (isNumber(prob)) {
	      var index = prob * (len-1);
	      var fracPart = index % 1;
	      if (fracPart === 0) {
	        var value = sorted ? flat[index] : partitionSelect(flat, index);

	        validate(value);

	        return value;
	      }

	      var integerPart = Math.floor(index);

	      var left, right;
	      if (sorted) {
	        left = flat[integerPart];
	        right = flat[integerPart+1];
	      } else {
	        right = partitionSelect(flat, integerPart+1);

	        // max of partition is kth largest
	        left = flat[integerPart];
	        for (var i = 0; i < integerPart; ++i) {
	          if (compare(flat[i], left) > 0) {
	            left = flat[i];
	          }
	        }
	      }

	      validate(left);
	      validate(right);

	      // Q(prob) = (1-f)*A[floor(index)] + f*A[floor(index)+1]
	      return add(multiply(left, 1 - fracPart), multiply(right, fracPart));
	    }

	    // If prob is a BigNumber
	    var index = prob.times(len-1);
	    if (index.isInteger()) {
	      index = index.toNumber();
	      var value = sorted ? flat[index] : partitionSelect(flat, index);

	      validate(value);

	      return value;
	    }

	    var integerPart = index.floor();
	    var fracPart = index.minus(integerPart);
	    var integerPartNumber = integerPart.toNumber();

	    var left, right;
	    if (sorted) {
	      left = flat[integerPartNumber];
	      right = flat[integerPartNumber+1];
	    } else {
	      right = partitionSelect(flat, integerPartNumber+1);

	      // max of partition is kth largest
	      left = flat[integerPartNumber];
	      for (var i = 0; i < integerPartNumber; ++i) {
	        if (compare(flat[i], left) > 0) {
	          left = flat[i];
	        }
	      }
	    }

	    validate(left);
	    validate(right);

	    // Q(prob) = (1-f)*A[floor(index)] + f*A[floor(index)+1]
	    var one = fracPart.constructor.ONE;
	    return add(multiply(left, one.minus(fracPart)), multiply(right, fracPart));
	  }

	  /**
	   * Check if array value types are valid, throw error otherwise.
	   * @param {number | BigNumber | Unit} x
	   * @param {number | BigNumber | Unit} x
	   * @private
	   */
	  var validate = typed({
	    'number | BigNumber | Unit': function (x) {
	      return x;
	    }
	  });

	  return quantileSeq;
	}

	exports.name = 'quantileSeq';
	exports.factory = factory;


/***/ },
/* 184 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	function factory (type, config, load, typed) {
	  var sqrt       = load(__webpack_require__(112));
	  var variance   = load(__webpack_require__(185));

	  /**
	   * Compute the standard deviation of a matrix or a  list with values.
	   * The standard deviations is defined as the square root of the variance:
	   * `std(A) = sqrt(var(A))`.
	   * In case of a (multi dimensional) array or matrix, the standard deviation
	   * over all elements will be calculated.
	   *
	   * Optionally, the type of normalization can be specified as second
	   * parameter. The parameter `normalization` can be one of the following values:
	   *
	   * - 'unbiased' (default) The sum of squared errors is divided by (n - 1)
	   * - 'uncorrected'        The sum of squared errors is divided by n
	   * - 'biased'             The sum of squared errors is divided by (n + 1)
	   *
	   * Syntax:
	   *
	   *     math.std(a, b, c, ...)
	   *     math.std(A)
	   *     math.std(A, normalization)
	   *
	   * Examples:
	   *
	   *     math.std(2, 4, 6);                     // returns 2
	   *     math.std([2, 4, 6, 8]);                // returns 2.581988897471611
	   *     math.std([2, 4, 6, 8], 'uncorrected'); // returns 2.23606797749979
	   *     math.std([2, 4, 6, 8], 'biased');      // returns 2
	   *
	   *     math.std([[1, 2, 3], [4, 5, 6]]);      // returns 1.8708286933869707
	   *
	   * See also:
	   *
	   *    mean, median, max, min, prod, sum, var
	   *
	   * @param {Array | Matrix} array
	   *                        A single matrix or or multiple scalar values
	   * @param {string} [normalization='unbiased']
	   *                        Determines how to normalize the variance.
	   *                        Choose 'unbiased' (default), 'uncorrected', or 'biased'.
	   * @return {*} The standard deviation
	   */
	  var std = typed('std', {
	    // std([a, b, c, d, ...])
	    'Array | Matrix': _std,

	    // std([a, b, c, d, ...], normalization)
	    'Array | Matrix, string': _std,

	    // std(a, b, c, d, ...)
	    '...': function () {
	      return _std(Array.prototype.slice.call(arguments));
	    }
	  });
	  
	  std.toTex = '\\mathrm{${name}}\\left(${args}\\right)';

	  return std;

	  function _std(array, normalization) {
	    if (array.length == 0) {
	      throw new SyntaxError('Function std requires one or more parameters (0 provided)');
	    }

	    return sqrt(variance.apply(null, arguments));
	  }
	}

	exports.name = 'std';
	exports.factory = factory;


/***/ },
/* 185 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var DEFAULT_NORMALIZATION = 'unbiased';

	var deepForEach = __webpack_require__(163);

	function factory (type, config, load, typed) {
	  var add = load(__webpack_require__(27));
	  var subtract = load(__webpack_require__(25));
	  var multiply = load(__webpack_require__(41));
	  var divide = load(__webpack_require__(51));

	  /**
	   * Compute the variance of a matrix or a  list with values.
	   * In case of a (multi dimensional) array or matrix, the variance over all
	   * elements will be calculated.
	   *
	   * Optionally, the type of normalization can be specified as second
	   * parameter. The parameter `normalization` can be one of the following values:
	   *
	   * - 'unbiased' (default) The sum of squared errors is divided by (n - 1)
	   * - 'uncorrected'        The sum of squared errors is divided by n
	   * - 'biased'             The sum of squared errors is divided by (n + 1)
	   *
	   * Note that older browser may not like the variable name `var`. In that
	   * case, the function can be called as `math['var'](...)` instead of
	   * `math.var(...)`.
	   *
	   * Syntax:
	   *
	   *     math.var(a, b, c, ...)
	   *     math.var(A)
	   *     math.var(A, normalization)
	   *
	   * Examples:
	   *
	   *     math.var(2, 4, 6);                     // returns 4
	   *     math.var([2, 4, 6, 8]);                // returns 6.666666666666667
	   *     math.var([2, 4, 6, 8], 'uncorrected'); // returns 5
	   *     math.var([2, 4, 6, 8], 'biased');      // returns 4
	   *
	   *     math.var([[1, 2, 3], [4, 5, 6]]);      // returns 3.5
	   *
	   * See also:
	   *
	   *    mean, median, max, min, prod, std, sum
	   *
	   * @param {Array | Matrix} array
	   *                        A single matrix or or multiple scalar values
	   * @param {string} [normalization='unbiased']
	   *                        Determines how to normalize the variance.
	   *                        Choose 'unbiased' (default), 'uncorrected', or 'biased'.
	   * @return {*} The variance
	   */
	  var variance = typed('variance', {
	    // var([a, b, c, d, ...])
	    'Array | Matrix': function (array) {
	      return _var(array, DEFAULT_NORMALIZATION);
	    },

	    // var([a, b, c, d, ...], normalization)
	    'Array | Matrix, string': _var,

	    // var(a, b, c, d, ...)
	    '...': function () {
	      return _var(arguments, DEFAULT_NORMALIZATION);
	    }
	  });

	  variance.toTex = '\\mathrm{Var}\\left(${args}\\right)';

	  return variance;

	  /**
	   * Recursively calculate the variance of an n-dimensional array
	   * @param {Array} array
	   * @param {string} normalization
	   *                        Determines how to normalize the variance:
	   *                        - 'unbiased'    The sum of squared errors is divided by (n - 1)
	   *                        - 'uncorrected' The sum of squared errors is divided by n
	   *                        - 'biased'      The sum of squared errors is divided by (n + 1)
	   * @return {number | BigNumber} variance
	   * @private
	   */
	  function _var(array, normalization) {
	    var sum = 0;
	    var num = 0;

	    if (array.length == 0) {
	      throw new SyntaxError('Function var requires one or more parameters (0 provided)');
	    }

	    // calculate the mean and number of elements
	    deepForEach(array, function (value) {
	      sum = add(sum, value);
	      num++;
	    });
	    if (num === 0) throw new Error('Cannot calculate var of an empty array');

	    var mean = divide(sum, num);

	    // calculate the variance
	    sum = 0;
	    deepForEach(array, function (value) {
	      var diff = subtract(value, mean);
	      sum = add(sum, multiply(diff, diff));
	    });

	    switch (normalization) {
	      case 'uncorrected':
	        return divide(sum, num);

	      case 'biased':
	        return divide(sum, num + 1);

	      case 'unbiased':
	        var zero = (sum && sum.isBigNumber === true) ? new type.BigNumber(0) : 0;
	        return (num == 1) ? zero : divide(sum, num - 1);

	      default:
	        throw new Error('Unknown normalization "' + normalization + '". ' +
	        'Choose "unbiased" (default), "uncorrected", or "biased".');
	    }
	  }
	}

	exports.name = 'var';
	exports.factory = factory;


/***/ },
/* 186 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepForEach = __webpack_require__(163);

	function factory (type, config, load, typed) {
	  var add = load(__webpack_require__(27));

	  /**
	   * Compute the sum of a matrix or a list with values.
	   * In case of a (multi dimensional) array or matrix, the sum of all
	   * elements will be calculated.
	   *
	   * Syntax:
	   *
	   *     math.sum(a, b, c, ...)
	   *     math.sum(A)
	   *
	   * Examples:
	   *
	   *     math.sum(2, 1, 4, 3);               // returns 10
	   *     math.sum([2, 1, 4, 3]);             // returns 10
	   *     math.sum([[2, 5], [4, 3], [1, 7]]); // returns 22
	   *
	   * See also:
	   *
	   *    mean, median, min, max, prod, std, var
	   *
	   * @param {... *} args  A single matrix or or multiple scalar values
	   * @return {*} The sum of all values
	   */
	  var sum = typed('sum', {
	    'Array | Matrix': function (args) {
	      // sum([a, b, c, d, ...])
	      return _sum(args);
	    },

	    'Array | Matrix, number | BigNumber': function () {
	      // sum([a, b, c, d, ...], dim)
	      // TODO: implement sum(A, dim)
	      throw new Error('sum(A, dim) is not yet supported');
	    },

	    '...': function () {
	      // sum(a, b, c, d, ...)
	      return _sum(arguments);
	    }
	  });

	  sum.toTex = '\\mathrm{${name}}\\left(${args}\\right)';

	  return sum;

	  /**
	   * Recursively calculate the sum of an n-dimensional array
	   * @param {Array} array
	   * @return {number} sum
	   * @private
	   */
	  function _sum(array) {
	    var sum = undefined;

	    deepForEach(array, function (value) {
	      sum = (sum === undefined) ? value : add(sum, value);
	    });

	    if (sum === undefined) {
	      switch (config.number) {
	        case 'number':
	          return 0;
	        case 'bignumber':
	          return new type.BigNumber(0);
	        case 'fraction':
	          return new type.Fraction(0);
	        default:
	          return 0;
	      }
	    }

	    return sum;
	  }
	}

	exports.name = 'sum';
	exports.factory = factory;


/***/ },
/* 187 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = [
	  __webpack_require__(188),
	  __webpack_require__(198),
	  __webpack_require__(200),
	  __webpack_require__(202),
	  __webpack_require__(205),
	  __webpack_require__(207),
	  __webpack_require__(209),
	  __webpack_require__(210),
	  __webpack_require__(206),
	  __webpack_require__(208),
	  __webpack_require__(201),
	  __webpack_require__(211),
	  __webpack_require__(204),
	  __webpack_require__(213),
	  __webpack_require__(214),
	  __webpack_require__(217),
	  __webpack_require__(219),
	  __webpack_require__(221),
	  __webpack_require__(222),
	  __webpack_require__(223),
	  __webpack_require__(224),
	  __webpack_require__(225),
	  __webpack_require__(216),
	  __webpack_require__(226),
	  __webpack_require__(227)
	];


/***/ },
/* 188 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);
	var acosAsec = __webpack_require__(189);

	function factory (type, config, load, typed) {
	  var complexSqrt = typed.find(load(__webpack_require__(112)), ['Complex']);
	  var complexLog = typed.find(load(__webpack_require__(102)), ['Complex']);

	  /**
	   * Calculate the inverse cosine of a value.
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.acos(x)
	   *
	   * Examples:
	   *
	   *    math.acos(0.5);           // returns number 1.0471975511965979
	   *    math.acos(math.cos(1.5)); // returns number 1.5
	   *
	   *    math.acos(2);             // returns Complex 0 + 1.3169578969248166 i
	   *
	   * See also:
	   *
	   *    cos, atan, asin
	   *
	   * @param {number | BigNumber | Complex | Array | Matrix} x  Function input
	   * @return {number | BigNumber | Complex | Array | Matrix} The arc cosine of x
	   */
	  var acos = typed('acos', {
	    'number': function (x) {
	      if ((x >= -1 && x <= 1) || config.predictable) {
	        return Math.acos(x);
	      }
	      else {
	        return _complexAcos(new type.Complex(x, 0));
	      }
	    },

	    'Complex': _complexAcos,

	    'BigNumber': function (x) {
	      return acosAsec(x, type.BigNumber, false);
	    },

	    'Array | Matrix': function (x) {
	      return deepMap(x, acos);
	    }
	  });

	  /**
	   * Calculate acos for a complex value
	   * @param {Complex} x
	   * @returns {Complex}
	   * @private
	   */
	  function _complexAcos(x) {
	    // acos(z) = 0.5*pi + i*log(iz + sqrt(1-z^2))
	    var temp1 = new type.Complex(
	        x.im * x.im - x.re * x.re + 1.0,
	        -2.0 * x.re * x.im
	    );
	    var temp2 = complexSqrt(temp1);
	    var temp3 = new type.Complex(
	        temp2.re - x.im,
	        temp2.im + x.re
	    );
	    var temp4 = complexLog(temp3);

	    // 0.5*pi = 1.5707963267948966192313216916398
	    return new type.Complex(
	        1.57079632679489661923 - temp4.im,
	        temp4.re
	    );
	  }

	  acos.toTex = '\\cos^{-1}\\left(${args[0]}\\right)';

	  return acos;
	}

	exports.name = 'acos';
	exports.factory = factory;


/***/ },
/* 189 */
/***/ function(module, exports, __webpack_require__) {

	var pi = __webpack_require__(140).pi;
	var atanAcot = __webpack_require__(190);

	/**
	 * Calculate the arccosine or arcsecant of x
	 *
	 * acos(x) = 2*atan(sqrt(1-x^2)/(1+x))
	 *
	 * asec(x) = acos(1/x)
	 *
	 * @param {BigNumber} x
	 * @param {function} BigNumber   BigNumber constructor
	 * @param {boolean} reciprocal   is sec
	 * @returns {BigNumber} arccosine or arcsecant of x
	 */
	module.exports = function acosAsec(x, BigNumber, reciprocal) {
	  if (reciprocal) {
	    if (x.abs().lt(BigNumber.ONE)) {
	      throw new Error('asec() only has non-complex values for |x| >= 1.');
	    }
	  } else if (x.abs().gt(BigNumber.ONE)) {
	    throw new Error('acos() only has non-complex values for |x| <= 1.');
	  }
	  if (x.eq(-1)) {
	    return pi(BigNumber);
	  }

	  var precision = BigNumber.precision;
	  BigNumber.config({precision: precision + 4});

	  if (reciprocal) {
	    x = BigNumber.ONE.div(x);
	  }

	  var acos = atanAcot(BigNumber.ONE.minus(x.times(x)).sqrt()
	      .div(x.plus(BigNumber.ONE)), BigNumber).times(2);

	  BigNumber.config({precision: precision});
	  return acos.toDP(precision - 1);
	};


/***/ },
/* 190 */
/***/ function(module, exports, __webpack_require__) {

	var constants = __webpack_require__(140);
	var asinAcsc = __webpack_require__(191);
	var atan = __webpack_require__(141);

	/**
	 * Calculate the arctangent or arccotangent of x
	 *
	 * @param {BigNumber} x
	 * @param {function} BigNumber   BigNumber constructor
	 * @param {boolean} reciprocal   is cot
	 * @returns {BigNumber} arctangent or arccotangent of x
	 */
	module.exports = function atanAcot (x, BigNumber, reciprocal) {
	  if (x.isNaN()) {
	    return new BigNumber(NaN);
	  }
	  if ((!reciprocal && x.isZero()) || (reciprocal && !x.isFinite())) {
	    return new BigNumber(0);
	  }

	  var precision = BigNumber.precision;
	  if ((!reciprocal && !x.isFinite()) || (reciprocal && x.isZero())) {
	    var halfPi = constants.pi(BigNumber.constructor({precision: precision + 2})).div(2).toDP(precision - 1);
	    halfPi.constructor = BigNumber;
	    halfPi.s = x.s;

	    return halfPi;
	  }

	  BigNumber.config({precision: precision + 4});

	  if (reciprocal) {
	    x = BigNumber.ONE.div(x);
	  }

	  var absX = x.abs();
	  if (absX.lte(0.875)) {
	    var ret = atan(x);

	    ret.constructor = BigNumber;
	    BigNumber.config({precision: precision});
	    return ret.toDP(BigNumber.precision - 1);
	  }
	  if (absX.gte(1.143)) {
	    // arctan(x) = sign(x)*((PI / 2) - arctan(1 / |x|))
	    var halfPi = constants.pi(BigNumber.constructor({precision: precision + 4})).div(2);
	    var ret = halfPi.minus(atan(BigNumber.ONE.div(absX)));
	    ret.s = x.s;

	    ret.constructor = BigNumber;
	    BigNumber.config({precision: precision});
	    return ret.toDP(BigNumber.precision - 1);
	  }

	  // arctan(x) = arcsin(x / [sqrt(1 + x^2)])
	  x = x.div(x.times(x).plus(1).sqrt());

	  BigNumber.config({precision: precision});
	  return asinAcsc(x, BigNumber);
	};


/***/ },
/* 191 */
/***/ function(module, exports, __webpack_require__) {

	var pi = __webpack_require__(140).pi;
	var asin = __webpack_require__(192);
	var asinNewton = __webpack_require__(193);

	/**
	 * Calculate the arcsine or arccosecant of x
	 *
	 * @param {BigNumber} x
	 * @param {function} BigNumber   BigNumber constructor
	 * @param {boolean} reciprocal   is csc
	 * @returns {BigNumber} arcsine or arccosecant of x
	 */
	module.exports = function asinAcsc(x, BigNumber, reciprocal) {
	  if (x.isNaN()) {
	    return new BigNumber(NaN);
	  }

	  var precision = BigNumber.precision;
	  var absX = x.abs();
	  if (reciprocal) {
	    if (absX.lt(BigNumber.ONE)) {
	      throw new Error('acsc() only has non-complex values for |x| >= 1.');
	    }

	    BigNumber.config({precision: precision + 2});
	    x = BigNumber.ONE.div(x);
	    BigNumber.config({precision: precision});

	    absX = x.abs();
	  } else if (absX.gt(BigNumber.ONE)) {
	    throw new Error('asin() only has non-complex values for |x| <= 1.');
	  }

	  // Get x below 0.58
	  if (absX.gt(0.8)) {
	    BigNumber.config({precision: precision + 4});

	    // arcsin(x) = sign(x)*(Pi/2 - arcsin(sqrt(1 - x^2)))
	    var sign = x.s;
	    var halfPi = pi(BigNumber.constructor({precision: precision + 4})).div(2);
	    x = halfPi.minus(asinAcsc(BigNumber.ONE.minus(x.times(x)).sqrt(), BigNumber));
	    x.s = sign;

	    x.constructor = BigNumber;
	    BigNumber.config({precision: precision});
	    return x.toDP(precision - 1);
	  }
	  var wasReduced = absX.gt(0.58);
	  if (wasReduced) {
	    BigNumber.config({precision: precision + 8});

	    // arcsin(x) = 2*arcsin(x / (sqrt(2)*sqrt(sqrt(1 - x^2) + 1)))
	    x = x.div(new BigNumber(2).sqrt().times(BigNumber.ONE.minus(x.times(x)).sqrt()
	        .plus(BigNumber.ONE).sqrt()));

	    BigNumber.config({precision: precision});
	  }

	  // Avoid overhead of Newton's Method if feasible
	  var ret = (precision <= 60 || ((x.dp() <= Math.log(precision)) && x.lt(0.05)))
	      ? asin(x, precision)
	      : asinNewton(x, BigNumber);

	  if (wasReduced) {
	    return ret.times(2);
	  }
	  return ret;
	};


/***/ },
/* 192 */
/***/ function(module, exports) {

	/**
	 * Calculate the arc sine of x
	 *
	 * arcsin(x) = x + (1/2)*x^3/3 + (3/8)*x^5/5 + (15/48)*x^7/7 ...
	 *           = x + (1/2)*x^2*x^1/3 + [(1*3)/(2*4)]*x^2*x^3/5 + [(1*3*5)/(2*4*6)]*x^2*x^5/7 ...
	 *
	 * @param {BigNumber} x
	 * @param {number} precision
	 * @returns {BigNumber} arc sine of x
	 */
	module.exports = function asinTaylor(x, precision) {
	  var BigNumber = x.constructor;
	  BigNumber.config({precision: precision + Math.log(precision) | 0 + 4});

	  var one = new BigNumber(1);
	  var y = x;
	  var yPrev = NaN;
	  var x2 = x.times(x);
	  var polyNum = x;
	  var constNum = new BigNumber(one);
	  var constDen = new BigNumber(one);

	  var bigK = new BigNumber(one);
	  for (var k = 3; !y.equals(yPrev); k += 2) {
	    polyNum = polyNum.times(x2);

	    constNum = constNum.times(bigK);
	    constDen = constDen.times(bigK.plus(one));

	    yPrev = y;
	    bigK = new BigNumber(k);
	    y = y.plus(polyNum.times(constNum).div(bigK.times(constDen)));
	  }

	  BigNumber.config({precision: precision});
	  return y.toDP(precision - 1);
	}


/***/ },
/* 193 */
/***/ function(module, exports, __webpack_require__) {

	var cosSinSecCsc = __webpack_require__(194);
	var sinToCos = __webpack_require__(197);

	/**
	 * Calculate the arc sine of x using Newton's method
	 *
	 * f(x) = sin(x) = N  =>  f(x)  = sin(x) - N
	 *                        f'(x) = cos(x)
	 *
	 * Thus we solve each step as follows:
	 *     x_(i+1) = x_i - (sin(x_i) - N)/cos(x_i)
	 *
	 * @param {BigNumber} x
	 * @param {function} BigNumber   BigNumber constructor
	 * @returns {BigNumber} arc sine of x
	 */
	module.exports = function asinNewton(x, BigNumber) {
	  var oldPrecision = BigNumber.precision;

	  // Calibration variables, adjusted from MAPM
	  var tolerance = -(oldPrecision + 4);
	  var maxp = oldPrecision + 8 - x.e;
	  var localPrecision = 25 - x.e;
	  var maxIter = Math.max(Math.log(oldPrecision + 2) * 1.442695 | 0 + 5, 5);
	  BigNumber.config({precision: localPrecision});

	  var i = 0;
	  var curr = new BigNumber(Math.asin(x.toNumber()) + '');
	  do {
	    var tmp0 = cosSinSecCsc(curr, BigNumber, 1, false);
	    var tmp1 = sinToCos(tmp0);
	    if (!tmp0.isZero()) {
	      tmp0.s = curr.s;
	    }

	    var tmp2 = tmp0.minus(x).div(tmp1);
	    curr = curr.minus(tmp2);

	    localPrecision = Math.min(2*localPrecision, maxp);
	    BigNumber.config({precision: localPrecision});
	  } while ((2*tmp2.e >= tolerance) && !tmp2.isZero() && (++i <= maxIter))

	  if (i == maxIter) {
	    throw new Error('asin() failed to converge to the requested accuracy.' +
	        'Try with a higher precision.');
	  }

	  BigNumber.config({precision: oldPrecision});
	  return curr.toDP(oldPrecision - 1);
	};


/***/ },
/* 194 */
/***/ function(module, exports, __webpack_require__) {

	var reduceToPeriod = __webpack_require__(195);
	var cosSin = __webpack_require__(196);

	/**
	 * Calculate the cosine/sine of x using the multiple angle identity:
	 *
	 * cos(4x) = 8[cos(x)^4 - cos(x)^2] + 1
	 *
	 * sin(5x) = 16sin(x)^5 - 20sin(x)^3 + 5sin(x)
	 * http://www.tc.umn.edu/~ringx004/sidebar.html
	 *
	 * @param {BigNumber} x
	 * @param {function} BigNumber   BigNumber constructor
	 * @param {number} mode          cosine function if 0, sine function if 1
	 * @param {boolean} reciprocal   is sec or csc
	 * @returns {BigNumber} cosine, sine, secant, or cosecant of x
	 */
	module.exports = function cosSinSecCsc(x, BigNumber, mode, reciprocal) {
	  if (x.isNaN() || !x.isFinite()) {
	    return new BigNumber(NaN);
	  }
	  var precision = BigNumber.precision;

	  // Avoid changing the original value
	  var y = new BigNumber(x);

	  // sin(-x) == -sin(x), cos(-x) == cos(x)
	  var isNeg = y.isNegative();
	  if (isNeg) {
	    y.s = -y.s;
	  }

	  // Apply ~log(precision) guard bits
	  var precPlusGuardDigits = precision + (Math.log(precision) | 0) + 3;
	  BigNumber.config({precision: precPlusGuardDigits});

	  y = reduceToPeriod(y, BigNumber.constructor({precision: precPlusGuardDigits}), mode);  // Make this destructive
	  y[0].constructor = BigNumber;
	  if (y[1]) {
	    y = y[0];
	    if (reciprocal && y.isZero()) {
	      y = new BigNumber(Infinity);
	    }

	    BigNumber.config({precision: precision});
	    return y;
	  }

	  var ret;
	  y = y[0];
	  if (mode) {
	    ret = cosSin(y.div(3125), mode);
	    BigNumber.config({precision: Math.min(precPlusGuardDigits, precision + 15)});

	    var five = new BigNumber(5);
	    var sixteen = new BigNumber(16);
	    var twenty = new BigNumber(20);
	    for (var i = 0; i < 5; ++i) {
	      var ret2 = ret.times(ret);
	      var ret3 = ret2.times(ret);
	      var ret5 = ret3.times(ret2);
	      ret = sixteen.times(ret5).minus(
	          twenty.times(ret3)).plus(
	          five.times(ret));
	    }

	    if (isNeg) {
	      ret.s = -ret.s;
	    }
	  } else {
	    var div_factor, loops;
	    if (y.abs().lt(BigNumber.ONE)) {
	      div_factor = 64;
	      loops = 3;
	    } else {
	      div_factor = 256;
	      loops = 4;
	    }

	    ret = cosSin(y.div(div_factor), mode);
	    BigNumber.config({precision: Math.min(precPlusGuardDigits, precision + 8)});

	    var eight = new BigNumber(8);
	    for (; loops > 0; --loops) {
	      var ret2 = ret.times(ret);
	      var ret4 = ret2.times(ret2);
	      ret = eight.times(ret4.minus(ret2)).plus(BigNumber.ONE);
	    }
	  }

	  if (reciprocal) {
	    ret = (ret.e <= -precision)
	        ? new BigNumber(Infinity)
	        : BigNumber.ONE.div(ret);
	  }

	  BigNumber.config({precision: precision});
	  return ret.toDP(precision - 1);
	};


/***/ },
/* 195 */
/***/ function(module, exports, __webpack_require__) {

	var constants = __webpack_require__(140);

	/**
	 * Reduce x within a period of pi (0, pi] with guard digits.
	 *
	 * @param {BigNumber} x
	 * @param {function} BigNumber   BigNumber constructor
	 * @param {number} mode
	 * @returns {Array} [Reduced x, is tau multiple?]
	 */
	module.exports = function reduceToPeriod(x, BigNumber, mode) {
	  var pi = constants.pi(BigNumber.constructor({precision: BigNumber.precision + 2}));
	  var tau = constants.tau(BigNumber);

	  if (x.abs().lte(pi.toDP(x.dp()))) {
	    return [x, false];
	  }

	  // Catch if input is tau multiple using pi's precision
	  if (x.div(pi.toDP(x.dp())).toNumber() % 2 == 0) {
	    return [new BigNumber(mode ^ 1), true];
	  }

	  var y = x.mod(tau);

	  // Catch if tau multiple with tau's precision
	  if (y.toDP(x.dp(), 1).isZero()) {
	    return [new BigNumber(mode ^ 1), true];
	  }

	  if (y.gt(pi)) {
	    if (mode) {
	      // sin(x + pi) = -sin(x)
	      y = y.minus(pi);
	      y.s = -y.s;
	    } else {
	      // cos(x) = cos(tau - x)
	      y = tau.minus(y);
	    }
	  }

	  y.constructor = x.constructor;
	  return [y, false];
	};


/***/ },
/* 196 */
/***/ function(module, exports) {

	/**
	 * Calculate the cosine or sine of x using Taylor Series.
	 *
	 * cos(x) = 1 - x^2/2! + x^4/4! - x^6/6! + x^8/8! - ...
	 *        = 1 - 1*x^2/2! + x^2*x^2/4! - x^2*x^4/6! + x^2*x^6/8! - ...
	 *
	 * sin(x) = x - x^3/3! + x^5/5! - x^7/7! + x^9/9! - ...
	 *        = x - x^2*x^1/3! + x^2*x^3/5! - x^2*x^5/7! + x^2*x^7/9! - ...
	 *
	 * @param {BigNumber} x     reduced argument
	 * @param {number} mode     sine function if 1, cosine function if 0
	 * @returns {BigNumber} sine or cosine of x
	 */
	module.exports = function cosSin(x, mode) {
	  var one = x.constructor.ONE;

	  var y = x;
	  var yPrev = NaN;
	  var x2 = x.times(x);
	  var num = (mode) ? y : y = one;
	  var den = one;
	  var add = true;

	  for (var k = mode; !y.equals(yPrev); k += 2) {
	    num = num.times(x2);
	    den = den.times(k+1).times(k+2);

	    yPrev = y;
	    add = !add;
	    y = (add) ? y.plus(num.div(den)) : y.minus(num.div(den));
	  }

	  return y;
	};


/***/ },
/* 197 */
/***/ function(module, exports) {

	/**
	 * Convert from sine to cosine
	 *
	 * |cos(x)| = sqrt(1 - sin(x)^2)
	 *
	 * @param {BigNumber} value    Sine value of x
	 * @returns {BigNumber} sine as cosine
	 */
	module.exports = function sinToCos(value) {
	  var BigNumber = value.constructor;
	  var precision = BigNumber.precision;
	  BigNumber.config({precision: precision + 2});

	  var ret = BigNumber.ONE.minus(value.times(value)).sqrt();

	  BigNumber.config({precision: precision});
	  return ret.toDP(precision - 1);
	};


/***/ },
/* 198 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);
	var acoshAsinhAsechAcsch = __webpack_require__(199);

	function factory (type, config, load, typed) {
	  var complexAcos = typed.find(load(__webpack_require__(188)), ['Complex']);

	  /**
	   * Calculate the hyperbolic arccos of a value,
	   * defined as `acosh(x) = ln(sqrt(x^2 - 1) + x)`.
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.acosh(x)
	   *
	   * Examples:
	   *
	   *    math.acosh(1.5);       // returns 0.9624236501192069
	   *
	   * See also:
	   *
	   *    cosh, asinh, atanh
	   *
	   * @param {number | Complex | Unit | Array | Matrix} x  Function input
	   * @return {number | Complex | Array | Matrix} Hyperbolic arccosine of x
	   */
	  var acosh = typed('acosh', {
	    'number': function (x) {
	      if (x >= 1 || config.predictable) {
	        return Math.log(Math.sqrt(x*x - 1) + x);
	      }
	      if (x <= -1) {
	        return new type.Complex(Math.log(Math.sqrt(x*x - 1) - x), Math.PI);
	      }
	      return _complexAcosh(new type.Complex(x, 0));
	    },

	    'Complex': _complexAcosh,

	    'BigNumber': function (x) {
	      return acoshAsinhAsechAcsch(x, type.BigNumber, false, false);
	    },

	    'Array | Matrix': function (x) {
	      return deepMap(x, acosh);
	    }
	  });

	  /**
	   * Calculate acosh for a complex value
	   * @param {Complex} x
	   * @returns {Complex}
	   * @private
	   */
	  function _complexAcosh(x) {
	    // acosh(z) = (-acos(z).im,  acos(z).re)   for acos(z).im <= 0
	    //            ( acos(z).im, -acos(z).re)   otherwise
	    var temp;
	    var res = complexAcos(x);
	    if (res.im <= 0) {
	      temp = res.re;
	      res.re = -res.im;
	      res.im = temp;
	    } else {
	      temp = res.im;
	      res.im = -res.re;
	      res.re = temp;
	    }

	    return res;
	  }

	  acosh.toTex = '\\cosh^{-1}\\left(${args[0]}\\right)';

	  return acosh;
	}

	exports.name = 'acosh';
	exports.factory = factory;


/***/ },
/* 199 */
/***/ function(module, exports) {

	/**
	 * Calculate the hyperbolic arccosine, arcsine, arcsecant, or arccosecant of x
	 *
	 * acosh(x) = ln(x + sqrt(x^2 - 1))
	 *
	 * asinh(x) = ln(x + sqrt(x^2 + 1))
	 *
	 * asech(x) = acosh(1 / x)
	 *
	 * acsch(x) = asinh(1 / x)
	 *
	 * @param {BigNumber} x
	 * @param {function} BigNumber   BigNumber constructor
	 * @param {boolean} mode         sine function if true, cosine function if false
	 * @param {boolean} reciprocal   is sec or csc
	 * @returns {BigNumber} hyperbolic arccosine, arcsine, arcsecant, or arccosecant of x
	 */
	module.exports = function acoshAsinhAsechAcsch(x, BigNumber, mode, reciprocal) {
	  if (x.isNaN()) {
	    return new BigNumber(NaN);
	  }
	  if (reciprocal && x.isZero()) {
	    return new BigNumber(Infinity);
	  }
	  if (!mode) {
	    if (reciprocal) {
	      if (x.isNegative() || x.gt(BigNumber.ONE)) {
	        throw new Error('asech() only has non-complex values for 0 <= x <= 1.');
	      }
	    } else if (x.lt(BigNumber.ONE)) {
	      throw new Error('acosh() only has non-complex values for x >= 1.');
	    }
	  }

	  var precision = BigNumber.precision;
	  BigNumber.config({precision: precision + 4});

	  var y = new BigNumber(x);
	  y.constructor = BigNumber;

	  if (reciprocal) {
	    y = BigNumber.ONE.div(y);
	  }

	  var x2PlusOrMinus = (mode) ? y.times(y).plus(BigNumber.ONE) : y.times(y).minus(BigNumber.ONE);
	  var ret = y.plus(x2PlusOrMinus.sqrt()).ln();

	  BigNumber.config({precision: precision});
	  return new BigNumber(ret.toPrecision(precision));
	};


/***/ },
/* 200 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);
	var atanAcot = __webpack_require__(190);

	var HALF_PI = 1.5707963267948966;

	function factory (type, config, load, typed) {
	  var complexAtan = typed.find(load(__webpack_require__(201)), ['Complex']);

	  /**
	   * Calculate the inverse cotangent of a value.
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.acot(x)
	   *
	   * Examples:
	   *
	   *    math.acot(0.5);           // returns number 0.4636476090008061
	   *    math.acot(math.cot(1.5)); // returns number 1.5
	   *
	   *    math.acot(2);             // returns Complex 1.5707963267948966 -1.3169578969248166 i
	   *
	   * See also:
	   *
	   *    cot, atan
	   *
	   * @param {number | Complex | Array | Matrix} x   Function input
	   * @return {number | Complex | Array | Matrix} The arc cotangent of x
	   */
	  var acot = typed('acot', {
	    'number': function (x) {
	      return (x) ? Math.atan(1 / x) : HALF_PI;
	    },

	    'Complex': function (x) {
	      if (x.im == 0) {
	        return new type.Complex(x.re ? Math.atan(1 / x.re) : HALF_PI, 0);
	      }

	      var den = x.re*x.re + x.im*x.im;
	      x = (den != 0)
	          ? new type.Complex(
	          x.re =  x.re / den,
	          x.im = -x.im / den)
	          : new type.Complex(
	          (x.re != 0) ?  (x.re / 0) : 0,
	          (x.im != 0) ? -(x.im / 0) : 0);

	      return complexAtan(x);
	    },

	    'BigNumber': function (x) {
	      return atanAcot(x, type.BigNumber, true);
	    },

	    'Array | Matrix': function (x) {
	      return deepMap(x, acot);
	    }
	  });

	  acot.toTex = '\\cot^{-1}\\left(${args[0]}\\right)';

	  return acot;
	}

	exports.name = 'acot';
	exports.factory = factory;


/***/ },
/* 201 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);
	var atanAcot = __webpack_require__(190);

	function factory (type, config, load, typed) {
	  var complexLog = typed.find(load(__webpack_require__(102)), ['Complex']);

	  /**
	   * Calculate the inverse tangent of a value.
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.atan(x)
	   *
	   * Examples:
	   *
	   *    math.atan(0.5);           // returns number 0.4636476090008061
	   *    math.atan(math.tan(1.5)); // returns number 1.5
	   *
	   *    math.atan(2);             // returns Complex 1.5707963267948966 -1.3169578969248166 i
	   *
	   * See also:
	   *
	   *    tan, asin, acos
	   *
	   * @param {number | BigNumber | Complex | Array | Matrix} x   Function input
	   * @return {number | BigNumber | Complex | Array | Matrix} The arc tangent of x
	   */
	  var atan = typed('atan', {
	    'number': function (x) {
	      return Math.atan(x);
	    },

	    'Complex': function (x) {
	      if (x.re == 0) {
	        if (x.im == 1) {
	          return new type.Complex(0, Infinity);
	        }
	        if (x.im == -1) {
	          return new type.Complex(0, -Infinity);
	        }
	      }

	      // atan(z) = 1/2 * i * (ln(1-iz) - ln(1+iz))
	      var re = x.re;
	      var im = x.im;
	      var den = re * re + (1.0 - im) * (1.0 - im);

	      var temp1 = new type.Complex(
	          (1.0 - im * im - re * re) / den,
	          (-2.0 * re) / den
	      );
	      var temp2 = complexLog(temp1);

	      return new type.Complex(
	          -0.5 * temp2.im,
	          0.5 * temp2.re
	      );
	    },

	    'BigNumber': function (x) {
	      return atanAcot(x, type.BigNumber, false);
	    },

	    'Array | Matrix': function (x) {
	      // deep map collection, skip zeros since atan(0) = 0
	      return deepMap(x, atan, true);
	    }
	  });

	  atan.toTex = '\\tan^{-1}\\left(${args[0]}\\right)';

	  return atan;
	}

	exports.name = 'atan';
	exports.factory = factory;


/***/ },
/* 202 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);
	var atanhAcoth = __webpack_require__(203);

	var HALF_PI = 1.5707963267948966;

	function factory (type, config, load, typed) {
	  var atanh = typed.find(load(__webpack_require__(204)), ['Complex']);

	  /**
	   * Calculate the hyperbolic arccotangent of a value,
	   * defined as `acoth(x) = (ln((x+1)/x) + ln(x/(x-1))) / 2`.
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.acoth(x)
	   *
	   * Examples:
	   *
	   *    math.acoth(0.5);       // returns 0.8047189562170503
	   *
	   * See also:
	   *
	   *    acsch, asech
	   *
	   * @param {number | Complex | Array | Matrix} x  Function input
	   * @return {number | Complex | Array | Matrix} Hyperbolic arccotangent of x
	   */
	  var acoth = typed('acoth', {
	    'number': function (x) {
	      if (x >= 1 || x <= -1 || config.predictable) {
	        return isFinite(x) ? (Math.log((x+1)/x) + Math.log(x/(x-1))) / 2 : 0;
	      }
	      return x !== 0 ? _complexAcoth(new type.Complex(x, 0)) : new type.Complex(0, HALF_PI);
	    },

	    'Complex': _complexAcoth,

	    'BigNumber': function (x) {
	      return atanhAcoth(x, type.BigNumber, true);
	    },

	    'Array | Matrix': function (x) {
	      return deepMap(x, acoth);
	    }
	  });

	  /**
	   * Calculate the hyperbolic arccotangent of a complex value
	   * @param {Complex} x
	   * @returns {Complex}
	   * @private
	   */
	  function _complexAcoth (x) {
	    if (x.re == 0 && x.im == 0) {
	      return new type.Complex(0, HALF_PI);
	    }

	    // acoth(z) = -i*atanh(1/z)
	    var den = x.re*x.re + x.im*x.im;
	    x = (den != 0)
	        ? new type.Complex(
	            x.re / den,
	           -x.im / den
	          )
	        : new type.Complex(
	            (x.re != 0) ?  (x.re / 0) : 0,
	            (x.im != 0) ? -(x.im / 0) : 0
	          );

	    return atanh(x);
	  }

	  acoth.toTex = '\\coth^{-1}\\left(${args[0]}\\right)';

	  return acoth;
	}

	exports.name = 'acoth';
	exports.factory = factory;


/***/ },
/* 203 */
/***/ function(module, exports) {

	
	/**
	 * Calculate the hyperbolic arctangent or arccotangent of x
	 *
	 * atanh(x) = ln((1 + x)/(1 - x)) / 2
	 *
	 * acoth(x) = atanh(1 / x)
	 *
	 * @param {BigNumber} x
	 * @param {function} BigNumber   BigNumber constructor
	 * @param {boolean} reciprocal   is sec or csc
	 * @returns {BigNumber} hyperbolic arctangent or arccotangent of x
	 */
	module.exports = function atanhAcoth(x, BigNumber, reciprocal) {
	  if (x.isNaN()) {
	    return new BigNumber(NaN);
	  }

	  var absX = x.abs();
	  if (absX.eq(BigNumber.ONE)) {
	    return new BigNumber(x.isNegative() ? -Infinity : Infinity);
	  }
	  if (absX.gt(BigNumber.ONE)) {
	    if (!reciprocal) {
	      throw new Error('atanh() only has non-complex values for |x| <= 1.');
	    }
	  } else if (reciprocal) {
	    throw new Error('acoth() has complex values for |x| < 1.');
	  }

	  if (x.isZero()) {
	    return new BigNumber(0);
	  }

	  var precision = BigNumber.precision;
	  BigNumber.config({precision: precision + 4});

	  var y = new BigNumber(x);
	  y.constructor = BigNumber;

	  if (reciprocal) {
	    y = BigNumber.ONE.div(y);
	  }
	  var ret = BigNumber.ONE.plus(y).div(BigNumber.ONE.minus(y)).ln().div(2);

	  BigNumber.config({precision: precision});
	  return new BigNumber(ret.toPrecision(precision));
	};


/***/ },
/* 204 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);
	var atanhAcoth = __webpack_require__(203);

	function factory (type, config, load, typed) {
	  /**
	   * Calculate the hyperbolic arctangent of a value,
	   * defined as `atanh(x) = ln((1 + x)/(1 - x)) / 2`.
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.atanh(x)
	   *
	   * Examples:
	   *
	   *    math.atanh(0.5);       // returns 0.5493061443340549
	   *
	   * See also:
	   *
	   *    acosh, asinh
	   *
	   * @param {number | Complex | Array | Matrix} x  Function input
	   * @return {number | Complex | Array | Matrix} Hyperbolic arctangent of x
	   */
	  var atanh = typed('atanh', {
	    'number': function (x) {
	      if ((x <= 1 && x >= -1) || config.predictable) {
	        return Math.log((1 + x)/(1 - x)) / 2;
	      }
	      return _complexAtanh(new type.Complex(x, 0));
	    },

	    'Complex': _complexAtanh,

	    'BigNumber': function (x) {
	      return atanhAcoth(x, type.BigNumber, false);
	    },

	    'Array | Matrix': function (x) {
	      // deep map collection, skip zeros since atanh(0) = 0
	      return deepMap(x, atanh, true);
	    }
	  });

	  /**
	   * Calculate the hyperbolic arctangent of a complex number
	   * @param {Complex} x
	   * @returns {Complex}
	   * @private
	   */
	  function _complexAtanh (x) {
	    // x.im should equal -pi / 2 in this case
	    var noIM = x.re > 1 && x.im == 0;

	    var oneMinus = 1 - x.re;
	    var onePlus = 1 + x.re;
	    var den = oneMinus*oneMinus + x.im*x.im;
	    x = (den != 0)
	        ? new type.Complex(
	        (onePlus*oneMinus - x.im*x.im) / den,
	        (x.im*oneMinus + onePlus*x.im) / den
	    )
	        : new type.Complex(
	        (x.re != -1) ? (x.re / 0) : 0,
	        (x.im != 0) ? (x.im / 0) : 0
	    );

	    var temp = x.re;
	    x.re = Math.log(Math.sqrt(x.re*x.re + x.im*x.im)) / 2;
	    x.im = Math.atan2(x.im, temp) / 2;

	    if (noIM) {
	      x.im = -x.im;
	    }
	    return x;
	  }

	  atanh.toTex = '\\tanh^{-1}\\left(${args[0]}\\right)';

	  return atanh;
	}

	exports.name = 'atanh';
	exports.factory = factory;


/***/ },
/* 205 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);
	var asinAcsc = __webpack_require__(191);

	var HALF_PI = 1.5707963267948966;

	function factory (type, config, load, typed) {
	  var complexAsin = typed.find(load(__webpack_require__(206)), ['Complex']);

	  /**
	   * Calculate the inverse cosecant of a value.
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.acsc(x)
	   *
	   * Examples:
	   *
	   *    math.acsc(0.5);           // returns number 0.5235987755982989
	   *    math.acsc(math.csc(1.5)); // returns number ~1.5
	   *
	   *    math.acsc(2);             // returns Complex 1.5707963267948966 -1.3169578969248166 i
	   *
	   * See also:
	   *
	   *    csc, asin, asec
	   *
	   * @param {number | Complex | Array | Matrix} x   Function input
	   * @return {number | Complex | Array | Matrix} The arc cosecant of x
	   */
	  var acsc = typed('acsc', {
	    'number': function (x) {
	      if (x <= -1 || x >= 1 || config.predictable) {
	        return Math.asin(1 / x);
	      }
	      return _complexAcsc(new type.Complex(x, 0));
	    },

	    'Complex': _complexAcsc,

	    'BigNumber': function (x) {
	      return asinAcsc(x, type.BigNumber, true);
	    },

	    'Array | Matrix': function (x) {
	      return deepMap(x, acsc);
	    }
	  });

	  /**
	   * Calculate acsc for a complex value
	   * @param {Complex} x
	   * @returns {Complex}
	   * @private
	   */
	  function _complexAcsc (x) {
	    if (x.re == 0 && x.im == 0) {
	      return new type.Complex(HALF_PI, Infinity);
	    }

	    var den = x.re*x.re + x.im*x.im;
	    x = (den != 0)
	        ? new type.Complex(
	        x.re =  x.re / den,
	        x.im = -x.im / den)
	        : new type.Complex(
	        (x.re != 0) ?  (x.re / 0) : 0,
	        (x.im != 0) ? -(x.im / 0) : 0);

	    return complexAsin(x);
	  }

	  acsc.toTex = '\\csc^{-1}\\left(${args[0]}\\right)';

	  return acsc;
	}

	exports.name = 'acsc';
	exports.factory = factory;


/***/ },
/* 206 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);
	var asinAcsc = __webpack_require__(191);

	function factory (type, config, load, typed) {
	  var complexSqrt = typed.find(load(__webpack_require__(112)), ['Complex']);
	  var complexLog = typed.find(load(__webpack_require__(102)), ['Complex']);

	  /**
	   * Calculate the inverse sine of a value.
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.asin(x)
	   *
	   * Examples:
	   *
	   *    math.asin(0.5);           // returns number 0.5235987755982989
	   *    math.asin(math.sin(1.5)); // returns number ~1.5
	   *
	   *    math.asin(2);             // returns Complex 1.5707963267948966 -1.3169578969248166 i
	   *
	   * See also:
	   *
	   *    sin, atan, acos
	   *
	   * @param {number | BigNumber | Complex | Array | Matrix} x   Function input
	   * @return {number | BigNumber | Complex | Array | Matrix} The arc sine of x
	   */
	  var asin = typed('asin', {
	    'number': function (x) {
	      if ((x >= -1 && x <= 1) || config.predictable) {
	        return Math.asin(x);
	      }
	      else {
	        return _complexAsin(new type.Complex(x, 0));
	      }
	    },

	    'Complex': _complexAsin,

	    'BigNumber': function (x) {
	      return asinAcsc(x, type.BigNumber, false);
	    },

	    'Array | Matrix': function (x) {
	      // deep map collection, skip zeros since asin(0) = 0
	      return deepMap(x, asin, true);
	    }
	  });

	  /**
	   * Calculate asin for a complex value
	   * @param {Complex} x
	   * @returns {Complex}
	   * @private
	   */
	  function _complexAsin(x) {
	    // asin(z) = -i*log(iz + sqrt(1-z^2))
	    var re = x.re;
	    var im = x.im;
	    var temp1 = new type.Complex(
	        im * im - re * re + 1.0,
	        -2.0 * re * im
	    );
	    var temp2 = complexSqrt(temp1);
	    var temp3 = new type.Complex(
	        temp2.re - im,
	        temp2.im + re
	    );
	    var temp4 = complexLog(temp3);

	    return new type.Complex(temp4.im, -temp4.re);
	  }

	  asin.toTex = '\\sin^{-1}\\left(${args[0]}\\right)';

	  return asin;
	}

	exports.name = 'asin';
	exports.factory = factory;


/***/ },
/* 207 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);
	var acoshAsinhAsechAcsch = __webpack_require__(199);

	function factory (type, config, load, typed) {
	  var asinh = typed.find(load(__webpack_require__(208)), ['Complex']);

	  /**
	   * Calculate the hyperbolic arccosecant of a value,
	   * defined as `acsch(x) = ln(1/x + sqrt(1/x^2 + 1))`.
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.acsch(x)
	   *
	   * Examples:
	   *
	   *    math.acsch(0.5);       // returns 1.4436354751788103
	   *
	   * See also:
	   *
	   *    asech, acoth
	   *
	   * @param {number | Complex | Array | Matrix} x  Function input
	   * @return {number | Complex | Array | Matrix} Hyperbolic arccosecant of x
	   */
	  var acsch = typed('acsch', {
	    'number': function (x) {
	      x = 1 / x;
	      return Math.log(x + Math.sqrt(x*x + 1));
	    },

	    'Complex': function (x) {
	      if (x.im == 0) {
	        x = (x.re != 0)
	            ? Math.log(x.re + Math.sqrt(x.re*x.re + 1))
	            : Infinity;
	        return new type.Complex(x, 0);
	      }

	      // acsch(z) = -i*asinh(1/z)
	      var den = x.re*x.re + x.im*x.im;
	      x = (den != 0)
	          ? new type.Complex(
	          x.re / den,
	          -x.im / den
	      )
	          : new type.Complex(
	          (x.re != 0) ?  (x.re / 0) : 0,
	          (x.im != 0) ? -(x.im / 0) : 0
	      );

	      return asinh(x);
	    },

	    'BigNumber': function (x) {
	      return acoshAsinhAsechAcsch(x, type.BigNumber, true, true);
	    },

	    'Array | Matrix': function (x) {
	      return deepMap(x, acsch);
	    }
	  });

	  acsch.toTex = '\\mathrm{csch}^{-1}\\left(${args[0]}\\right)';

	  return acsch;
	}

	exports.name = 'acsch';
	exports.factory = factory;


/***/ },
/* 208 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);
	var acoshAsinhAsechAcsch = __webpack_require__(199);

	function factory (type, config, load, typed) {
	  var complexAsin = typed.find(load(__webpack_require__(206)), ['Complex']);

	  /**
	   * Calculate the hyperbolic arcsine of a value,
	   * defined as `asinh(x) = ln(x + sqrt(x^2 + 1))`.
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.asinh(x)
	   *
	   * Examples:
	   *
	   *    math.asinh(0.5);       // returns 0.48121182505960347
	   *
	   * See also:
	   *
	   *    acosh, atanh
	   *
	   * @param {number | Complex | Array | Matrix} x  Function input
	   * @return {number | Complex | Array | Matrix} Hyperbolic arcsine of x
	   */
	  var asinh = typed('asinh', {
	    'number': function (x) {
	      return Math.log(Math.sqrt(x*x + 1) + x);
	    },

	    'Complex': function (x) {
	      // asinh(z) = (-asin((z.im, -z.re)).im, asin((z.im, -z.re)).re)
	      var temp = x.im;
	      x.im = -x.re;
	      x.re = temp;

	      var res = complexAsin(x);

	      // restore original values
	      x.re = -x.im;
	      x.im = temp;

	      temp = res.re;
	      res.re = -res.im;
	      res.im = temp;

	      return res;
	    },

	    'BigNumber': function (x) {
	      return acoshAsinhAsechAcsch(x, type.BigNumber, true, false);
	    },

	    'Array | Matrix': function (x) {
	      // deep map collection, skip zeros since asinh(0) = 0
	      return deepMap(x, asinh, true);
	    }
	  });

	  asinh.toTex = '\\sinh^{-1}\\left(${args[0]}\\right)';

	  return asinh;
	}

	exports.name = 'asinh';
	exports.factory = factory;


/***/ },
/* 209 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);
	var acosAsec = __webpack_require__(189);

	function factory (type, config, load, typed) {
	  var complexAcos = typed.find(load(__webpack_require__(188)), ['Complex']);

	  /**
	   * Calculate the inverse secant of a value.
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.asec(x)
	   *
	   * Examples:
	   *
	   *    math.asec(0.5);           // returns 1.0471975511965979
	   *    math.asec(math.sec(1.5)); // returns 1.5
	   *
	   *    math.asec(2);             // returns 0 + 1.3169578969248166 i
	   *
	   * See also:
	   *
	   *    acos, acot, acsc
	   *
	   * @param {number | Complex | Array | Matrix} x  Function input
	   * @return {number | Complex | Array | Matrix} The arc secant of x
	   */
	  var asec = typed('asec', {
	    'number': function (x) {
	      if (x <= -1 || x >= 1 || config.predictable) {
	        return Math.acos(1 / x);
	      }
	      return _complexAsec(new type.Complex(x, 0));
	    },

	    'Complex': _complexAsec,

	    'BigNumber': function (x) {
	      return acosAsec(x, type.BigNumber, true);
	    },

	    'Array | Matrix': function (x) {
	      return deepMap(x, asec);
	    }
	  });

	  /**
	   * Calculate asec for a complex value
	   * @param {Complex} x
	   * @returns {Complex}
	   * @private
	   */
	  function _complexAsec (x) {
	    if (x.re == 0 && x.im == 0) {
	      return new type.Complex(0, Infinity);
	    }

	    var den = x.re*x.re + x.im*x.im;
	    x = (den != 0)
	        ? new type.Complex(
	        x.re =  x.re / den,
	        x.im = -x.im / den)
	        : new type.Complex(
	        (x.re != 0) ?  (x.re / 0) : 0,
	        (x.im != 0) ? -(x.im / 0) : 0);

	    return complexAcos(x);
	  }

	  asec.toTex = '\\sec^{-1}\\left(${args[0]}\\right)';

	  return asec;
	}

	exports.name = 'asec';
	exports.factory = factory;


/***/ },
/* 210 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);
	var acoshAsinhAsechAcsch = __webpack_require__(199);

	function factory (type, config, load, typed) {
	  var acosh = typed.find(load(__webpack_require__(198)), ['Complex']);

	  /**
	   * Calculate the hyperbolic arcsecant of a value,
	   * defined as `asech(x) = ln(sqrt(1/x^2 - 1) + 1/x)`.
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.asech(x)
	   *
	   * Examples:
	   *
	   *    math.asech(0.5);       // returns 1.3169578969248166
	   *
	   * See also:
	   *
	   *    acsch, acoth
	   *
	   * @param {number | Complex | Array | Matrix} x  Function input
	   * @return {number | Complex | Array | Matrix} Hyperbolic arcsecant of x
	   */
	  var asech = typed('asech', {
	    'number': function (x) {
	      if ((x <= 1 && x >= -1) || config.predictable) {
	        x = 1 / x;

	        var ret = Math.sqrt(x*x - 1);
	        if (x > 0 || config.predictable) {
	          return Math.log(ret + x);
	        }

	        return new type.Complex(Math.log(ret - x), Math.PI);
	      }

	      return _complexAsech(new type.Complex(x, 0));
	    },

	    'Complex': _complexAsech,

	    'BigNumber': function (x) {
	      return acoshAsinhAsechAcsch(x, type.BigNumber, false, true);
	    },

	    'Array | Matrix': function (x) {
	      return deepMap(x, asech);
	    }
	  });

	  /**
	   * Calculate the hyperbolic arcsecant of a number
	   * @param {Complex} x
	   * @returns {Complex}
	   * @private
	   */
	  function _complexAsech (x) {
	    if (x.re == 0 && x.im == 0) {
	      return new type.Complex(Infinity, 0);
	    }

	    // acsch(z) = -i*asinh(1/z)
	    var den = x.re*x.re + x.im*x.im;
	    x = (den != 0)
	        ? new type.Complex(
	        x.re / den,
	        -x.im / den
	    )
	        : new type.Complex(
	        (x.re != 0) ?  (x.re / 0) : 0,
	        (x.im != 0) ? -(x.im / 0) : 0
	    );

	    return acosh(x);
	  }

	  asech.toTex = '\\mathrm{sech}^{-1}\\left(${args[0]}\\right)';

	  return asech;
	}

	exports.name = 'asech';
	exports.factory = factory;


/***/ },
/* 211 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var bigAtan2 = __webpack_require__(212);

	function factory (type, config, load, typed) {

	  var matrix = load(__webpack_require__(23));

	  var algorithm02 = load(__webpack_require__(96));
	  var algorithm03 = load(__webpack_require__(31));
	  var algorithm09 = load(__webpack_require__(98));
	  var algorithm11 = load(__webpack_require__(42));
	  var algorithm12 = load(__webpack_require__(65));
	  var algorithm13 = load(__webpack_require__(35));
	  var algorithm14 = load(__webpack_require__(39));

	  /**
	   * Calculate the inverse tangent function with two arguments, y/x.
	   * By providing two arguments, the right quadrant of the computed angle can be
	   * determined.
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.atan2(y, x)
	   *
	   * Examples:
	   *
	   *    math.atan2(2, 2) / math.pi;       // returns number 0.25
	   *
	   *    var angle = math.unit(60, 'deg'); // returns Unit 60 deg
	   *    var x = math.cos(angle);
	   *    var y = math.sin(angle);
	   *
	   *    math.atan(2);             // returns Complex 1.5707963267948966 -1.3169578969248166 i
	   *
	   * See also:
	   *
	   *    tan, atan, sin, cos
	   *
	   * @param {number | Array | Matrix} y  Second dimension
	   * @param {number | Array | Matrix} x  First dimension
	   * @return {number | Array | Matrix} Four-quadrant inverse tangent
	   */
	  var atan2 = typed('atan2', {

	    'number, number': Math.atan2,

	    // TODO: implement atan2 for complex numbers

	    'BigNumber, BigNumber': function (y, x) {
	      return bigAtan2(y, x, type.BigNumber);
	    },

	    'Matrix, Matrix': function (x, y) {
	      // result
	      var c;

	      // process matrix storage
	      switch (x.storage()) {
	        case 'sparse':
	          switch (y.storage()) {
	            case 'sparse':
	              // sparse .* sparse
	              c = algorithm09(x, y, atan2, false);
	              break;
	            default:
	              // sparse .* dense
	              c = algorithm02(y, x, atan2, true);
	              break;
	          }
	          break;
	        default:
	          switch (y.storage()) {
	            case 'sparse':
	              // dense .* sparse
	              c = algorithm03(x, y, atan2, false);
	              break;
	            default:
	              // dense .* dense
	              c = algorithm13(x, y, atan2);
	              break;
	          }
	          break;
	      }
	      return c;
	    },

	    'Array, Array': function (x, y) {
	      // use matrix implementation
	      return atan2(matrix(x), matrix(y)).valueOf();
	    },

	    'Array, Matrix': function (x, y) {
	      // use matrix implementation
	      return atan2(matrix(x), y);
	    },

	    'Matrix, Array': function (x, y) {
	      // use matrix implementation
	      return atan2(x, matrix(y));
	    },

	    'Matrix, number | BigNumber': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (x.storage()) {
	        case 'sparse':
	          c = algorithm11(x, y, atan2, false);
	          break;
	        default:
	          c = algorithm14(x, y, atan2, false);
	          break;
	      }
	      return c;
	    },

	    'number | BigNumber, Matrix': function (x, y) {
	      // result
	      var c;
	      // check storage format
	      switch (y.storage()) {
	        case 'sparse':
	          c = algorithm12(y, x, atan2, true);
	          break;
	        default:
	          c = algorithm14(y, x, atan2, true);
	          break;
	      }
	      return c;
	    },

	    'Array, number | BigNumber': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(x), y, atan2, false).valueOf();
	    },

	    'number | BigNumber, Array': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(y), x, atan2, true).valueOf();
	    }
	  });

	  atan2.toTex = '\\mathrm{atan2}\\left(${args}\\right)';

	  return atan2;
	}

	exports.name = 'atan2';
	exports.factory = factory;


/***/ },
/* 212 */
/***/ function(module, exports, __webpack_require__) {

	var constants = __webpack_require__(140);
	var atanAcot = __webpack_require__(190);

	/**
	 * Calculate the arctangent of y, x
	 *
	 * @param {BigNumber} y
	 * @param {BigNumber} x
	 * @param {function} BigNumber   BigNumber constructor
	 * @returns {BigNumber} arctangent of y, x
	 */
	module.exports = function arctan2(y, x, BigNumber) {
	  var precision = BigNumber.precision;

	  if (x.isZero()) {
	    if (y.isZero()) {
	      return new BigNumber(NaN);
	    }

	    var halfPi = constants.pi(BigNumber.constructor({precision: precision + 2})).div(2).toDP(precision - 1);
	    halfPi.constructor = BigNumber;
	    halfPi.s = y.s;

	    return halfPi;
	  }

	  BigNumber.config({precision: precision + 2});

	  var ret = atanAcot(y.div(x), BigNumber, false);
	  if (x.isNegative()) {
	    var pi = constants.pi(BigNumber);
	    ret = y.isNegative() ? ret.minus(pi) : ret.plus(pi);
	  }

	  ret.constructor = BigNumber;
	  BigNumber.config({precision: precision});
	  return ret.toDP(precision - 1);
	};


/***/ },
/* 213 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);
	var cosSinSecCsc = __webpack_require__(194);

	function factory (type, config, load, typed) {
	  var cosh = typed.find(load(__webpack_require__(214)), ['number']);
	  var sinh = typed.find(load(__webpack_require__(216)), ['number']);

	  /**
	   * Calculate the cosine of a value.
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.cos(x)
	   *
	   * Examples:
	   *
	   *    math.cos(2);                      // returns number -0.4161468365471422
	   *    math.cos(math.pi / 4);            // returns number  0.7071067811865475
	   *    math.cos(math.unit(180, 'deg'));  // returns number -1
	   *    math.cos(math.unit(60, 'deg'));   // returns number  0.5
	   *
	   *    var angle = 0.2;
	   *    math.pow(math.sin(angle), 2) + math.pow(math.cos(angle), 2); // returns number ~1
	   *
	   * See also:
	   *
	   *    cos, tan
	   *
	   * @param {number | BigNumber | Complex | Unit | Array | Matrix} x  Function input
	   * @return {number | BigNumber | Complex | Array | Matrix} Cosine of x
	   */
	  var cos = typed('cos', {
	    'number': Math.cos,

	    'Complex': function (x) {
	      // cos(z) = (exp(iz) + exp(-iz)) / 2
	      return new type.Complex(
	          Math.cos(x.re) * cosh(-x.im),
	          Math.sin(x.re) * sinh(-x.im)
	      );
	    },

	    'BigNumber': function (x) {
	      return cosSinSecCsc(x, type.BigNumber, 0, false);
	    },

	    'Unit': function (x) {
	      if (!x.hasBase(type.Unit.BASE_UNITS.ANGLE)) {
	        throw new TypeError ('Unit in function cos is no angle');
	      }
	      return Math.cos(x.value);
	    },

	    'Array | Matrix': function (x) {
	      return deepMap(x, cos);
	    }
	  });

	  cos.toTex = '\\cos\\left(${args[0]}\\right)';

	  return cos;
	}

	exports.name = 'cos';
	exports.factory = factory;


/***/ },
/* 214 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);
	var coshSinhCschSech = __webpack_require__(215);

	function factory (type, config, load, typed) {
	  /**
	   * Calculate the hyperbolic cosine of a value,
	   * defined as `cosh(x) = 1/2 * (exp(x) + exp(-x))`.
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.cosh(x)
	   *
	   * Examples:
	   *
	   *    math.cosh(0.5);       // returns number 1.1276259652063807
	   *
	   * See also:
	   *
	   *    sinh, tanh
	   *
	   * @param {number | BigNumber | Complex | Unit | Array | Matrix} x  Function input
	   * @return {number | BigNumber | Complex | Array | Matrix} Hyperbolic cosine of x
	   */
	  var cosh = typed('cosh', {
	    'number': _cosh,

	    'Complex': function (x) {
	      var ep = Math.exp(x.re);
	      var en = Math.exp(-x.re);
	      return new type.Complex(Math.cos(x.im) * (ep + en) / 2, Math.sin(x.im) * (ep - en) / 2);
	    },

	    'BigNumber': function (x) {
	      return coshSinhCschSech(x, type.BigNumber, false, false);
	    },

	    'Unit': function (x) {
	      if (!x.hasBase(type.Unit.BASE_UNITS.ANGLE)) {
	        throw new TypeError ('Unit in function cosh is no angle');
	      }
	      return _cosh(x.value);
	    },

	    'Array | Matrix': function (x) {
	      return deepMap(x, cosh);
	    }
	  });

	  cosh.toTex = '\\cosh\\left(${args[0]}\\right)';

	  return cosh;
	}

	/**
	 * Calculate the hyperbolic cosine of a number
	 * @param {number} x
	 * @returns {number}
	 * @private
	 */
	function _cosh(x) {
	  return (Math.exp(x) + Math.exp(-x)) / 2;
	}

	exports.name = 'cosh';
	exports.factory = factory;


/***/ },
/* 215 */
/***/ function(module, exports) {

	/**
	 * Calculate the hyperbolic sine, cosine, secant, or cosecant of x
	 *
	 * cosh(x) = (exp(x) + exp(-x)) / 2
	 *         = (e^x + 1/e^x) / 2
	 *
	 * sinh(x) = (exp(x) - exp(-x)) / 2
	 *         = (e^x - 1/e^x) / 2
	 *
	 * sech(x) = 2 / (exp(x) + exp(-x))
	 *         = 2 / (e^x + 1/e^x)
	 *
	 * csch(x) = 2 / (exp(x) - exp(-x))
	 *         = 2 / (e^x - 1/e^x)
	 *
	 * @param {BigNumber} x
	 * @param {function} BigNumber   BigNumber constructor
	 * @param {boolean} mode         sinh function if true, cosh function if false
	 * @param {boolean} reciprocal   is sech or csch
	 * @returns {BigNumber} hyperbolic cosine, sine, secant. or cosecant of x
	 */
	module.exports = function coshSinhSschSech(x, BigNumber, mode, reciprocal) {
	  if (x.isNaN()) {
	    return new BigNumber(NaN);
	  }
	  if (!x.isFinite()) {
	    if (reciprocal) {
	      return new BigNumber(0);
	    }
	    return new BigNumber((mode) ? x : Infinity);
	  }

	  var precision = BigNumber.precision;
	  BigNumber.config({precision: precision + 4});

	  var y = new BigNumber(x);
	  y.constructor = BigNumber;

	  y = y.exp();
	  y = (mode) ? y.minus(BigNumber.ONE.div(y)) : y.plus(BigNumber.ONE.div(y));
	  y = (reciprocal) ? new BigNumber(2).div(y) : y.div(2);

	  BigNumber.config({precision: precision});
	  return new BigNumber(y.toPrecision(precision));
	};


/***/ },
/* 216 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);
	var coshSinhCschSech = __webpack_require__(215);

	function factory (type, config, load, typed) {
	  /**
	   * Calculate the hyperbolic sine of a value,
	   * defined as `sinh(x) = 1/2 * (exp(x) - exp(-x))`.
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.sinh(x)
	   *
	   * Examples:
	   *
	   *    math.sinh(0.5);       // returns number 0.5210953054937474
	   *
	   * See also:
	   *
	   *    cosh, tanh
	   *
	   * @param {number | BigNumber | Complex | Unit | Array | Matrix} x  Function input
	   * @return {number | BigNumber | Complex | Array | Matrix} Hyperbolic sine of x
	   */
	  var sinh = typed('sinh', {
	    'number': _sinh,

	    'Complex': function (x) {
	      var cim = Math.cos(x.im);
	      var sim = Math.sin(x.im);
	      var ep = Math.exp(x.re);
	      var en = Math.exp(-x.re);
	      return new type.Complex(cim * (ep - en) / 2, sim * (ep + en) / 2);
	    },

	    'BigNumber': function (x) {
	      return coshSinhCschSech(x, type.BigNumber, true, false);
	    },

	    'Unit': function (x) {
	      if (!x.hasBase(type.Unit.BASE_UNITS.ANGLE)) {
	        throw new TypeError ('Unit in function sinh is no angle');
	      }
	      return _sinh(x.value);
	    },

	    'Array | Matrix': function (x) {
	      // deep map collection, skip zeros since sinh(0) = 0
	      return deepMap(x, sinh, true);
	    }
	  });

	  sinh.toTex = '\\sinh\\left(${args[0]}\\right)';

	  return sinh;
	}

	/**
	 * Calculate the hyperbolic sine of a number
	 * @param {number} x
	 * @returns {number}
	 * @private
	 */
	function _sinh (x) {
	  if (Math.abs(x) < 1) {
	    return x + (x * x * x) / 6 + (x * x * x * x * x) / 120;
	  } else {
	    return (Math.exp(x) - Math.exp(-x)) / 2;
	  }
	}

	exports.name = 'sinh';
	exports.factory = factory;


/***/ },
/* 217 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);
	var tanCot = __webpack_require__(218);

	function factory (type, config, load, typed) {
	  /**
	   * Calculate the cotangent of a value. `cot(x)` is defined as `1 / tan(x)`.
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.cot(x)
	   *
	   * Examples:
	   *
	   *    math.cot(2);      // returns number -0.45765755436028577
	   *    1 / math.tan(2);  // returns number -0.45765755436028577
	   *
	   * See also:
	   *
	   *    tan, sec, csc
	   *
	   * @param {number | Complex | Unit | Array | Matrix} x  Function input
	   * @return {number | Complex | Array | Matrix} Cotangent of x
	   */
	  var cot = typed('cot', {
	    'number': function (x) {
	      return 1 / Math.tan(x);
	    },

	    'Complex': function (x) {
	      var den =
	          Math.exp(-4 * x.im) -
	          2 * Math.exp(-2 * x.im) * Math.cos(2 * x.re) + 1;

	      return new type.Complex(
	          2 * Math.exp(-2 * x.im) * Math.sin(2 * x.re) / den,
	          (Math.exp(-4 * x.im) - 1) / den
	      );
	    },

	    'BigNumber': function (x) {
	      return tanCot(x, type.BigNumber, true);
	    },

	    'Unit': function (x) {
	      if (!x.hasBase(type.Unit.BASE_UNITS.ANGLE)) {
	        throw new TypeError ('Unit in function cot is no angle');
	      }
	      return 1 / Math.tan(x.value);
	    },

	    'Array | Matrix': function (x) {
	      return deepMap(x, cot);
	    }
	  });

	  cot.toTex = '\\cot\\left(${args[0]}\\right)';

	  return cot;
	}

	exports.name = 'cot';
	exports.factory = factory;


/***/ },
/* 218 */
/***/ function(module, exports, __webpack_require__) {

	var constants = __webpack_require__(140);
	var cosSinSecCsc = __webpack_require__(194);
	var sinToCos = __webpack_require__(197);
	var reduceToPeriod = __webpack_require__(195);

	/**
	 * Calculate the tangent of x
	 *
	 * tan(x) = sin(x) / cos(x)
	 *
	 * cot(x) = cos(x) / sin(x)
	 *
	 * @param {BigNumber} x
	 * @param {function} BigNumber   BigNumber constructor
	 * @param {boolean} reciprocal   is cot
	 * @returns {BigNumber} tangent or cotangent of x
	 */
	module.exports = function tanCot(x, BigNumber, reciprocal) {
	  if (x.isNaN()) {
	    return new BigNumber(NaN);
	  }

	  var precision = BigNumber.precision;
	  var pi = constants.pi(BigNumber.constructor({precision: precision + 2}));
	  var halfPi = pi.div(2).toDP(precision - 1);
	  pi = pi.toDP(precision - 1);

	  var y = reduceToPeriod(x, BigNumber, 1)[0];
	  if (y.abs().eq(pi)) {
	    return new BigNumber(Infinity);
	  }

	  BigNumber.config({precision: precision + 4});
	  var sin = cosSinSecCsc(y, BigNumber, 1, false);
	  var cos = sinToCos(sin);

	  sin = sin.toDP(precision);
	  cos = cos.toDP(precision);

	  // Make sure sign for cosine is correct
	  if (y.eq(x)) {
	    if (y.gt(halfPi)) {
	      cos.s = -cos.s;
	    }
	  } else if (pi.minus(y.abs()).gt(halfPi)) {
	    cos.s = -cos.s;
	  }

	  var tan = (reciprocal) ? cos.div(sin) : sin.div(cos);

	  BigNumber.config({precision: precision});
	  return new BigNumber(tan.toPrecision(precision));
	};


/***/ },
/* 219 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);
	var tanhCoth = __webpack_require__(220);

	function factory (type, config, load, typed) {
	  /**
	   * Calculate the hyperbolic cotangent of a value,
	   * defined as `coth(x) = 1 / tanh(x)`.
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.coth(x)
	   *
	   * Examples:
	   *
	   *    // coth(x) = 1 / tanh(x)
	   *    math.coth(2);         // returns 1.0373147207275482
	   *    1 / math.tanh(2);     // returns 1.0373147207275482
	   *
	   * See also:
	   *
	   *    sinh, tanh, cosh
	   *
	   * @param {number | Complex | Unit | Array | Matrix} x  Function input
	   * @return {number | Complex | Array | Matrix} Hyperbolic cotangent of x
	   */
	  var coth = typed('coth', {
	    'number': _coth,

	    'Complex': function (x) {
	      var r = Math.exp(2 * x.re);
	      var re = r * Math.cos(2 * x.im);
	      var im = r * Math.sin(2 * x.im);
	      var den = (re - 1) * (re - 1) + im * im;
	      return new type.Complex(
	          ((re + 1) * (re - 1) + im * im) / den,
	          -2 * im / den
	      );
	    },

	    'BigNumber': function (x) {
	      return tanhCoth(x, type.BigNumber, true);
	    },

	    'Unit': function (x) {
	      if (!x.hasBase(type.Unit.BASE_UNITS.ANGLE)) {
	        throw new TypeError ('Unit in function coth is no angle');
	      }
	      return _coth(x.value);
	    },

	    'Array | Matrix': function (x) {
	      return deepMap(x, coth);
	    }
	  });

	  coth.toTex = '\\coth\\left(${args[0]}\\right)';

	  return coth;
	}

	/**
	 * Calculate the hyperbolic cosine of a number
	 * @param {number} x
	 * @returns {number}
	 * @private
	 */
	function _coth(x) {
	  var e = Math.exp(2 * x);
	  return (e + 1) / (e - 1);
	}

	exports.name = 'coth';
	exports.factory = factory;


/***/ },
/* 220 */
/***/ function(module, exports) {

	/**
	 * Calculate the hyperbolic tangent of x
	 *
	 * tanh(x) = (exp(x) + exp(-x)) / (exp(x) - exp(-x))
	 *         = (exp(2x) - 1) / (exp(2x) + 1)
	 *         = (e^x - 1/e^x) / (e^x + 1/e^x)
	 *
	 * coth(x) = (exp(x) - exp(-x)) / (exp(x) + exp(-x))
	 *         = (exp(2x) + 1) / (exp(2x) - 1)
	 *         = (e^x + 1/e^x) / (e^x - 1/e^x)
	 *
	 * @param {BigNumber} x
	 * @param {function} BigNumber   BigNumber constructor
	 * @param {boolean} reciprocal   is coth
	 * @returns {BigNumber} hyperbolic tangent or cotangent of x
	 */
	module.exports = function tanhCoth(x, BigNumber, reciprocal) {
	  if (x.isNaN()) {
	    return new BigNumber(NaN);
	  }
	  if (!x.isFinite()) {
	    return new BigNumber(x.s);
	  }

	  var precision = BigNumber.precision;
	  BigNumber.config({precision: precision + 4});

	  var y = new BigNumber(x);
	  y.constructor = BigNumber;

	  var posExp = y.exp();
	  var negExp = BigNumber.ONE.div(posExp);
	  var ret = posExp.minus(negExp);
	  ret = (reciprocal) ? posExp.plus(negExp).div(ret) : ret.div(posExp.plus(negExp));

	  BigNumber.config({precision: precision});
	  return ret.toDP(precision - 1);
	};


/***/ },
/* 221 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);
	var cosSinSecCsc = __webpack_require__(194);

	function factory (type, config, load, typed) {
	  /**
	   * Calculate the cosecant of a value, defined as `csc(x) = 1/sin(x)`.
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.csc(x)
	   *
	   * Examples:
	   *
	   *    math.csc(2);      // returns number 1.099750170294617
	   *    1 / math.sin(2);  // returns number 1.099750170294617
	   *
	   * See also:
	   *
	   *    sin, sec, cot
	   *
	   * @param {number | Complex | Unit | Array | Matrix} x  Function input
	   * @return {number | Complex | Array | Matrix} Cosecant of x
	   */
	  var csc = typed('csc', {
	    'number': function (x) {
	      return 1 / Math.sin(x);
	    },

	    'Complex': function (x) {
	      // csc(z) = 1/sin(z) = (2i) / (exp(iz) - exp(-iz))
	      var den =
	          0.25 * (Math.exp(-2 * x.im) + Math.exp(2 * x.im)) -
	          0.5 * Math.cos(2 * x.re);

	      return new type.Complex (
	          0.5 * Math.sin(x.re) * (Math.exp(-x.im) + Math.exp(x.im)) / den,
	          0.5 * Math.cos(x.re) * (Math.exp(-x.im) - Math.exp(x.im)) / den
	      );
	    },

	    'BigNumber': function (x) {
	      return cosSinSecCsc(x, type.BigNumber, 1, true);
	    },

	    'Unit': function (x) {
	      if (!x.hasBase(type.Unit.BASE_UNITS.ANGLE)) {
	        throw new TypeError ('Unit in function csc is no angle');
	      }
	      return 1 / Math.sin(x.value);
	    },

	    'Array | Matrix': function (x) {
	      return deepMap(x, csc);
	    }
	  });

	  csc.toTex = '\\csc\\left(${args[0]}\\right)';

	  return csc;
	}

	exports.name = 'csc';
	exports.factory = factory;


/***/ },
/* 222 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);
	var coshSinhCschSech = __webpack_require__(215);
	var sign = __webpack_require__(8).sign;

	function factory (type, config, load, typed) {
	  /**
	   * Calculate the hyperbolic cosecant of a value,
	   * defined as `csch(x) = 1 / sinh(x)`.
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.csch(x)
	   *
	   * Examples:
	   *
	   *    // csch(x) = 1/ sinh(x)
	   *    math.csch(0.5);       // returns 1.9190347513349437
	   *    1 / math.sinh(0.5);   // returns 1.9190347513349437
	   *
	   * See also:
	   *
	   *    sinh, sech, coth
	   *
	   * @param {number | Complex | Unit | Array | Matrix} x  Function input
	   * @return {number | Complex | Array | Matrix} Hyperbolic cosecant of x
	   */
	  var csch = typed('csch', {
	    'number': _csch,

	    'Complex': function (x) {
	      var ep = Math.exp(x.re);
	      var en = Math.exp(-x.re);
	      var re = Math.cos(x.im) * (ep - en);
	      var im = Math.sin(x.im) * (ep + en);
	      var den = re * re + im * im;
	      return new type.Complex(2 * re / den, -2 * im /den);
	    },

	    'BigNumber': function (x) {
	      return coshSinhCschSech(x, type.BigNumber, true, true);
	    },

	    'Unit': function (x) {
	      if (!x.hasBase(type.Unit.BASE_UNITS.ANGLE)) {
	        throw new TypeError ('Unit in function csch is no angle');
	      }
	      return _csch(x.value);
	    },

	    'Array | Matrix': function (x) {
	      return deepMap(x, csch);
	    }
	  });

	  csch.toTex = '\\mathrm{csch}\\left(${args[0]}\\right)';

	  return csch;
	}

	/**
	 * Calculate the hyperbolic cosecant of a number
	 * @param {number} x
	 * @returns {number}
	 * @private
	 */
	function _csch(x) {
	  // consider values close to zero (+/-)
	  if (x == 0) {
	    return Number.POSITIVE_INFINITY;
	  }
	  else {
	    return Math.abs(2 / (Math.exp(x) - Math.exp(-x))) * sign(x);
	  }
	}

	exports.name = 'csch';
	exports.factory = factory;


/***/ },
/* 223 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);
	var cosSinSecCsc = __webpack_require__(194);

	function factory (type, config, load, typed) {
	  /**
	   * Calculate the secant of a value, defined as `sec(x) = 1/cos(x)`.
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.sec(x)
	   *
	   * Examples:
	   *
	   *    math.sec(2);      // returns number -2.4029979617223822
	   *    1 / math.cos(2);  // returns number -2.4029979617223822
	   *
	   * See also:
	   *
	   *    cos, csc, cot
	   *
	   * @param {number | Complex | Unit | Array | Matrix} x  Function input
	   * @return {number | Complex | Array | Matrix} Secant of x
	   */
	  var sec = typed('sec', {
	    'number': function (x) {
	      return 1 / Math.cos(x);
	    },

	    'Complex': function (x) {
	      // sec(z) = 1/cos(z) = 2 / (exp(iz) + exp(-iz))
	      var den =
	          0.25 * (Math.exp(-2 * x.im) + Math.exp(2 * x.im)) +
	          0.5 * Math.cos(2 * x.re);

	      return new type.Complex(
	          0.5 * Math.cos(x.re) * (Math.exp(-x.im) + Math.exp( x.im)) / den,
	          0.5 * Math.sin(x.re) * (Math.exp( x.im) - Math.exp(-x.im)) / den
	      );
	    },

	    'BigNumber': function (x) {
	      return cosSinSecCsc(x, type.BigNumber, 0, true);
	    },

	    'Unit': function (x) {
	      if (!x.hasBase(type.Unit.BASE_UNITS.ANGLE)) {
	        throw new TypeError ('Unit in function sec is no angle');
	      }
	      return 1 / Math.cos(x.value);
	    },

	    'Array | Matrix': function (x) {
	      return deepMap(x, sec);
	    }
	  });

	  sec.toTex = '\\sec\\left(${args[0]}\\right)';

	  return sec;
	}

	exports.name = 'sec';
	exports.factory = factory;


/***/ },
/* 224 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);
	var coshSinhCschSech = __webpack_require__(215);

	function factory (type, config, load, typed) {
	  /**
	   * Calculate the hyperbolic secant of a value,
	   * defined as `sech(x) = 1 / cosh(x)`.
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.sech(x)
	   *
	   * Examples:
	   *
	   *    // sech(x) = 1/ cosh(x)
	   *    math.sech(0.5);       // returns 0.886818883970074
	   *    1 / math.cosh(0.5);   // returns 0.886818883970074
	   *
	   * See also:
	   *
	   *    cosh, csch, coth
	   *
	   * @param {number | Complex | Unit | Array | Matrix} x  Function input
	   * @return {number | Complex | Array | Matrix} Hyperbolic secant of x
	   */
	  var sech = typed('sech', {
	    'number': _sech,

	    'Complex': function (x) {
	      var ep = Math.exp(x.re);
	      var en = Math.exp(-x.re);
	      var re = Math.cos(x.im) * (ep + en);
	      var im = Math.sin(x.im) * (ep - en);
	      var den = re * re + im * im;
	      return new type.Complex(2 * re / den, -2 * im / den);
	    },

	    'BigNumber': function (x) {
	      return coshSinhCschSech(x, type.BigNumber, false, true);
	    },

	    'Unit': function (x) {
	      if (!x.hasBase(type.Unit.BASE_UNITS.ANGLE)) {
	        throw new TypeError ('Unit in function sech is no angle');
	      }
	      return _sech(x.value);
	    },

	    'Array | Matrix': function (x) {
	      return deepMap(x, sech);
	    }
	  });

	  sech.toTex = '\\mathrm{sech}\\left(${args[0]}\\right)';

	  return sech;
	}

	/**
	 * Calculate the hyperbolic secant of a number
	 * @param {number} x
	 * @returns {number}
	 * @private
	 */
	function _sech(x) {
	  return 2 / (Math.exp(x) + Math.exp(-x));
	}

	exports.name = 'sech';
	exports.factory = factory;


/***/ },
/* 225 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);
	var cosSinSecCsc = __webpack_require__(194);

	function factory (type, config, load, typed) {
	  var cosh = typed.find(load(__webpack_require__(214)), ['number']);
	  var sinh = typed.find(load(__webpack_require__(216)), ['number']);

	  /**
	   * Calculate the sine of a value.
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.sin(x)
	   *
	   * Examples:
	   *
	   *    math.sin(2);                      // returns number 0.9092974268256813
	   *    math.sin(math.pi / 4);            // returns number 0.7071067811865475
	   *    math.sin(math.unit(90, 'deg'));   // returns number 1
	   *    math.sin(math.unit(30, 'deg'));   // returns number 0.5
	   *
	   *    var angle = 0.2;
	   *    math.pow(math.sin(angle), 2) + math.pow(math.cos(angle), 2); // returns number ~1
	   *
	   * See also:
	   *
	   *    cos, tan
	   *
	   * @param {number | BigNumber | Complex | Unit | Array | Matrix} x  Function input
	   * @return {number | BigNumber | Complex | Array | Matrix} Sine of x
	   */
	  var sin = typed('sin', {
	    'number': Math.sin,

	    'Complex': function (x) {
	      return new type.Complex(
	          Math.sin(x.re) * cosh(-x.im),
	          Math.cos(x.re) * sinh(x.im)
	      );
	    },

	    'BigNumber': function (x) {
	      return cosSinSecCsc(x, type.BigNumber, 1, false);
	    },

	    'Unit': function (x) {
	      if (!x.hasBase(type.Unit.BASE_UNITS.ANGLE)) {
	        throw new TypeError ('Unit in function sin is no angle');
	      }
	      return Math.sin(x.value);
	    },

	    'Array | Matrix': function (x) {
	      // deep map collection, skip zeros since sin(0) = 0
	      return deepMap(x, sin, true);
	    }
	  });

	  sin.toTex = '\\sin\\left(${args[0]}\\right)';

	  return sin;
	}

	exports.name = 'sin';
	exports.factory = factory;


/***/ },
/* 226 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);
	var tanCot = __webpack_require__(218);

	function factory (type, config, load, typed) {
	  /**
	   * Calculate the tangent of a value. `tan(x)` is equal to `sin(x) / cos(x)`.
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.tan(x)
	   *
	   * Examples:
	   *
	   *    math.tan(0.5);                    // returns number 0.5463024898437905
	   *    math.sin(0.5) / math.cos(0.5);    // returns number 0.5463024898437905
	   *    math.tan(math.pi / 4);            // returns number 1
	   *    math.tan(math.unit(45, 'deg'));   // returns number 1
	   *
	   * See also:
	   *
	   *    atan, sin, cos
	   *
	   * @param {number | BigNumber | Complex | Unit | Array | Matrix} x  Function input
	   * @return {number | BigNumber | Complex | Array | Matrix} Tangent of x
	   */
	  var tan = typed('tan', {
	    'number': Math.tan,

	    'Complex': function (x) {
	      var den =
	          Math.exp(-4 * x.im) +
	          2 * Math.exp(-2 * x.im) * Math.cos(2 * x.re) +
	          1;

	      return new type.Complex(
	          2 * Math.exp(-2 * x.im) * Math.sin(2 * x.re) / den,
	          (1 - Math.exp(-4 * x.im)) / den
	      );
	    },

	    'BigNumber': function (x) {
	      return tanCot(x, type.BigNumber, false);
	    },

	    'Unit': function (x) {
	      if (!x.hasBase(type.Unit.BASE_UNITS.ANGLE)) {
	        throw new TypeError ('Unit in function tan is no angle');
	      }
	      return Math.tan(x.value);
	    },

	    'Array | Matrix': function (x) {
	      // deep map collection, skip zeros since tan(0) = 0
	      return deepMap(x, tan, true);
	    }
	  });

	  tan.toTex = '\\tan\\left(${args[0]}\\right)';

	  return tan;
	}

	exports.name = 'tan';
	exports.factory = factory;


/***/ },
/* 227 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);
	var tanhCoth = __webpack_require__(220);

	function factory (type, config, load, typed) {
	  /**
	   * Calculate the hyperbolic tangent of a value,
	   * defined as `tanh(x) = (exp(2 * x) - 1) / (exp(2 * x) + 1)`.
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.tanh(x)
	   *
	   * Examples:
	   *
	   *    // tanh(x) = sinh(x) / cosh(x) = 1 / coth(x)
	   *    math.tanh(0.5);                   // returns 0.46211715726000974
	   *    math.sinh(0.5) / math.cosh(0.5);  // returns 0.46211715726000974
	   *    1 / math.coth(0.5);               // returns 0.46211715726000974
	   *
	   * See also:
	   *
	   *    sinh, cosh, coth
	   *
	   * @param {number | BigNumber | Complex | Unit | Array | Matrix} x  Function input
	   * @return {number | BigNumber | Complex | Array | Matrix} Hyperbolic tangent of x
	   */
	  var tanh = typed('tanh', {
	    'number': _tanh,

	    'Complex': function (x) {
	      var r = Math.exp(2 * x.re);
	      var re = r * Math.cos(2 * x.im);
	      var im = r * Math.sin(2 * x.im);
	      var den = (re + 1) * (re + 1) + im * im;
	      return new type.Complex(
	          ((re - 1) * (re + 1) + im * im) / den,
	          im * 2 / den
	      );
	    },

	    'BigNumber': function (x) {
	      return tanhCoth(x, type.BigNumber, false);
	    },

	    'Unit': function (x) {
	      if (!x.hasBase(type.Unit.BASE_UNITS.ANGLE)) {
	        throw new TypeError ('Unit in function tanh is no angle');
	      }
	      return _tanh(x.value);
	    },

	    'Array | Matrix': function (x) {
	      // deep map collection, skip zeros since tanh(0) = 0
	      return deepMap(x, tanh, true);
	    }
	  });

	  tanh.toTex = '\\tanh\\left(${args[0]}\\right)';

	  return tanh;
	}

	/**
	 * Calculate the hyperbolic tangent of a number
	 * @param {number} x
	 * @returns {number}
	 * @private
	 */
	function _tanh (x) {
	  var e = Math.exp(2 * x);
	  return (e - 1) / (e + 1);
	}

	exports.name = 'tanh';
	exports.factory = factory;


/***/ },
/* 228 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = [
	  __webpack_require__(229)
	];

/***/ },
/* 229 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	function factory (type, config, load, typed) {
	  var latex = __webpack_require__(26);

	  var matrix = load(__webpack_require__(23));

	  var algorithm13 = load(__webpack_require__(35));
	  var algorithm14 = load(__webpack_require__(39));

	  /**
	   * Change the unit of a value.
	   *
	   * For matrices, the function is evaluated element wise.
	   *
	   * Syntax:
	   *
	   *    math.to(x, unit)
	   *
	   * Examples:
	   *
	   *    math.to(math.unit('2 inch'), 'cm');                   // returns Unit 5.08 cm
	   *    math.to(math.unit('2 inch'), math.unit(null, 'cm'));  // returns Unit 5.08 cm
	   *    math.to(math.unit(16, 'bytes'), 'bits');              // returns Unit 128 bits
	   *
	   * See also:
	   *
	   *    unit
	   *
	   * @param {Unit | Array | Matrix} x     The unit to be converted.
	   * @param {Unit | Array | Matrix} unit  New unit. Can be a string like "cm"
	   *                                      or a unit without value.
	   * @return {Unit | Array | Matrix} value with changed, fixed unit.
	   */
	  var to = typed('to', {

	    'Unit, Unit | string': function (x, unit) {
	      return x.to(unit);
	    },

	    'Matrix, Matrix': function (x, y) {
	      // SparseMatrix does not support Units
	      return algorithm13(x, y, to);
	    },

	    'Array, Array': function (x, y) {
	      // use matrix implementation
	      return to(matrix(x), matrix(y)).valueOf();
	    },

	    'Array, Matrix': function (x, y) {
	      // use matrix implementation
	      return to(matrix(x), y);
	    },

	    'Matrix, Array': function (x, y) {
	      // use matrix implementation
	      return to(x, matrix(y));
	    },

	    'Matrix, any': function (x, y) {
	      // SparseMatrix does not support Units
	      return algorithm14(x, y, to, false);
	    },

	    'any, Matrix': function (x, y) {
	      // SparseMatrix does not support Units
	      return algorithm14(y, x, to, true);
	    },

	    'Array, any': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(x), y, to, false).valueOf();
	    },

	    'any, Array': function (x, y) {
	      // use matrix implementation
	      return algorithm14(matrix(y), x, to, true).valueOf();
	    }
	  });

	  to.toTex = '\\left(${args[0]}' + latex.operators['to'] + '${args[1]}\\right)';

	  return to;
	}

	exports.name = 'to';
	exports.factory = factory;


/***/ },
/* 230 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = [
	  __webpack_require__(232),
	  __webpack_require__(233),
	  __webpack_require__(234),
	  __webpack_require__(145),
	  __webpack_require__(144),
	  __webpack_require__(235),
	  __webpack_require__(147),
	  __webpack_require__(231),
	  __webpack_require__(236),
	  __webpack_require__(180),
	  __webpack_require__(237),
	  __webpack_require__(238),
	  __webpack_require__(239),
	  __webpack_require__(240)
	];


/***/ },
/* 231 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);
	var number = __webpack_require__(8);

	function factory (type, config, load, typed) {
	  /**
	   * Test whether a value is zero.
	   * The function can check for zero for types `number`, `BigNumber`, `Fraction`,
	   * `Complex`, and `Unit`.
	   *
	   * The function is evaluated element-wise in case of Array or Matrix input.
	   *
	   * Syntax:
	   *
	   *     math.isZero(x)
	   *
	   * Examples:
	   *
	   *    math.isZero(0);                     // returns true
	   *    math.isZero(2);                     // returns false
	   *    math.isZero(0.5);                   // returns false
	   *    math.isZero(math.bignumber(0));     // returns true
	   *    math.isZero(math.fraction(0));      // returns true
	   *    math.isZero(math.fraction(1,3));    // returns false
	   *    math.isZero(math.complex('2 - 4i'); // returns false
	   *    math.isZero(math.complex('0i');     // returns true
	   *    math.isZero('0');                   // returns true
	   *    math.isZero('2');                   // returns false
	   *    math.isZero([2, 0, -3]');           // returns [false, true, false]
	   *
	   * See also:
	   *
	   *    isNumeric, isPositive, isNegative, isInteger
	   *
	   * @param {number | BigNumber | Complex | Fraction | Unit | Array | Matrix} x       Value to be tested
	   * @return {boolean}  Returns true when `x` is zero.
	   *                    Throws an error in case of an unknown data type.
	   */
	  var isZero = typed('isZero', {
	    'number': function (x) {
	      return x === 0;
	    },

	    'BigNumber': function (x) {
	      return x.isZero();
	    },

	    'Complex': function (x) {
	      return x.re === 0 && x.im === 0;
	    },

	    'Fraction': function (x) {
	      return x.d === 1 && x.n === 0;
	    },

	    'Unit': function (x) {
	      return x.value === 0;
	    },

	    'Array | Matrix': function (x) {
	      return deepMap(x, isZero);
	    }
	  });

	  return isZero;
	}

	exports.name = 'isZero';
	exports.factory = factory;


/***/ },
/* 232 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var object= __webpack_require__(5);

	function factory (type, config, load, typed) {
	  /**
	   * Clone an object.
	   *
	   * Syntax:
	   *
	   *     math.clone(x)
	   *
	   * Examples:
	   *
	   *    math.clone(3.5);                   // returns number 3.5
	   *    math.clone(math.complex('2 - 4i'); // returns Complex 2 - 4i
	   *    math.clone(math.unit(45, 'deg'));  // returns Unit 45 deg
	   *    math.clone([[1, 2], [3, 4]]);      // returns Array [[1, 2], [3, 4]]
	   *    math.clone("hello world");         // returns string "hello world"
	   *
	   * @param {*} x   Object to be cloned
	   * @return {*} A clone of object x
	   */
	  var clone = typed('clone', {
	    'any': object.clone
	  });

	  clone.toTex = '\\mathrm{${name}}\\left(${args}\\right)';

	  return clone;
	}

	exports.name = 'clone';
	exports.factory = factory;


/***/ },
/* 233 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var size = __webpack_require__(18).size;

	function factory (type, config, load, typed) {
	  var matrix = load(__webpack_require__(23));
	  
	  /**
	   * Filter the items in an array or one dimensional matrix.
	   *
	   * Syntax:
	   *
	   *    math.filter(x, test)
	   *
	   * Examples:
	   *
	   *    function isPositive (x) {
	   *      return x > 0;
	   *    }
	   *    math.filter([6, -2, -1, 4, 3], isPositive); // returns [6, 4, 3]
	   *
	   *    math.filter(["23", "foo", "100", "55", "bar"], /[0-9]+/); // returns ["23", "100", "55"]
	   *
	   * See also:
	   *
	   *    forEach, map, sort
	   *
	   * @param {Matrix | Array} x    A one dimensional matrix or array to filter
	   * @param {Function | RegExp} test
	   *        A function or regular expression to test items.
	   *        When `test` is a function, it must return a boolean.
	   *        All entries for which `test` returns true are returned.
	   * @return {Matrix | Array} Returns the filtered matrix.
	   */
	  var filter = typed('filter', {
	    'Array, function': _filterCallback,

	    'Array, RegExp': _filterRegExp,

	    'Matrix, function': function (x, test) {
	      return matrix(_filterCallback(x.toArray(), test));
	    },

	    'Matrix, RegExp': function (x, test) {
	      return matrix(_filterRegExp(x.toArray(), test));
	    }
	  });

	  filter.toTex = '\\mathrm{${name}}\\left(${args}\\right)';

	  return filter;
	}

	/**
	 * Filter values in a callback given a callback function
	 * @param {Array} x
	 * @param {Function} callback
	 * @return {Array} Returns the filtered array
	 * @private
	 */
	function _filterCallback (x, callback) {
	  if (size(x).length !== 1) {
	    throw new Error('Only one dimensional matrices supported');
	  }

	  return x.filter(function (entry) {
	    return callback(entry);
	  });
	}

	/**
	 * Filter values in a callback given a regular expression
	 * @param {Array} x
	 * @param {Function} regexp
	 * @return {Array} Returns the filtered array
	 * @private
	 */
	function _filterRegExp (x, regexp) {
	  if (size(x).length !== 1) {
	    throw new Error('Only one dimensional matrices supported');
	  }

	  return x.filter(function (entry) {
	    return regexp.test(entry);
	  });
	}

	exports.name = 'filter';
	exports.factory = factory;


/***/ },
/* 234 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var string = __webpack_require__(20);

	function factory (type, config, load, typed) {
	  /**
	   * Format a value of any type into a string.
	   *
	   * Syntax:
	   *
	   *    math.format(value)
	   *    math.format(value, options)
	   *    math.format(value, precision)
	   *    math.format(value, fn)
	   *
	   * Where:
	   *
	   *  - `value: *`
	   *    The value to be formatted
	   *  - `options: Object`
	   *    An object with formatting options. Available options:
	   *    - `notation: string`
	   *      Number notation. Choose from:
	   *      - 'fixed'
	   *        Always use regular number notation.
	   *        For example '123.40' and '14000000'
	   *      - 'exponential'
	   *        Always use exponential notation.
	   *        For example '1.234e+2' and '1.4e+7'
	   *      - 'auto' (default)
	   *        Regular number notation for numbers having an absolute value between
	   *        `lower` and `upper` bounds, and uses exponential notation elsewhere.
	   *        Lower bound is included, upper bound is excluded.
	   *        For example '123.4' and '1.4e7'.
	   *    - `precision: number`
	   *      A number between 0 and 16 to round the digits of the number. In case
	   *      of notations 'exponential' and 'auto', `precision` defines the total
	   *      number of significant digits returned and is undefined by default.
	   *      In case of notation 'fixed', `precision` defines the number of
	   *      significant digits after the decimal point, and is 0 by default.
	   *    - `exponential: Object`
	   *      An object containing two parameters, {number} lower and {number} upper,
	   *      used by notation 'auto' to determine when to return exponential
	   *      notation. Default values are `lower=1e-3` and `upper=1e5`. Only
	   *      applicable for notation `auto`.
	   *    - `fraction: string`. Available values: 'ratio' (default) or 'decimal'.
	   *      For example `format(fraction(1, 3))` will output '1/3' when 'ratio' is
	   *      configured, and will output `0.(3)` when 'decimal' is configured.
	   * - `fn: Function`
	   *   A custom formatting function. Can be used to override the built-in notations.
	   *   Function `fn` is called with `value` as parameter and must return a string.
	   *   Is useful for example to format all values inside a matrix in a particular way.
	   *
	   * Examples:
	   *
	   *    math.format(6.4);                                        // returns '6.4'
	   *    math.format(1240000);                                    // returns '1.24e6'
	   *    math.format(1/3);                                        // returns '0.3333333333333333'
	   *    math.format(1/3, 3);                                     // returns '0.333'
	   *    math.format(21385, 2);                                   // returns '21000'
	   *    math.format(12.071, {notation: 'fixed'});                // returns '12'
	   *    math.format(2.3,    {notation: 'fixed', precision: 2});  // returns '2.30'
	   *    math.format(52.8,   {notation: 'exponential'});          // returns '5.28e+1'
	   *
	   * See also:
	   *
	   *    print
	   *
	   * @param {*} value                               Value to be stringified
	   * @param {Object | Function | number} [options]  Formatting options
	   * @return {string} The formatted value
	   */
	  var format = typed('format', {
	    'any': string.format,
	    'any, Object | function | number': string.format
	  });

	  format.toTex = '\\mathrm{${name}}\\left(${args}\\right)';

	  return format;
	}

	exports.name = 'format';
	exports.factory = factory;


/***/ },
/* 235 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);
	var number = __webpack_require__(8);

	function factory (type, config, load, typed) {
	  /**
	   * Test whether a value is an numeric value.
	   *
	   * The function is evaluated element-wise in case of Array or Matrix input.
	   *
	   * Syntax:
	   *
	   *     math.isNumeric(x)
	   *
	   * Examples:
	   *
	   *    math.isNumeric(2);                     // returns true
	   *    math.isNumeric(0);                     // returns true
	   *    math.isNumeric(math.bignumber(500));   // returns true
	   *    math.isNumeric(math.fraction(4));      // returns true
	   *    math.isNumeric(math.complex('2 - 4i'); // returns false
	   *    math.isNumeric('3');                   // returns false
	   *    math.isNumeric([2.3, 'foo', false]);   // returns [true, false, true]
	   *
	   * See also:
	   *
	   *    isZero, isPositive, isNegative, isInteger
	   *
	   * @param {*} x       Value to be tested
	   * @return {boolean}  Returns true when `x` is a `number`, `BigNumber`,
	   *                    `Fraction`, or `boolean`. Returns false for other types.
	   *                    Throws an error in case of unknown types.
	   */
	  var isNumeric = typed('isNumeric', {
	    'number | BigNumber | Fraction | boolean': function () {
	      return true;
	    },

	    'Complex | Unit | string': function () {
	      return false;
	    },

	    'Array | Matrix': function (x) {
	      return deepMap(x, isNumeric);
	    }
	  });

	  return isNumeric;
	}

	exports.name = 'isNumeric';
	exports.factory = factory;


/***/ },
/* 236 */
/***/ function(module, exports) {

	'use strict';

	function factory (type, config, load, typed) {
	  /**
	   * Create a new matrix or array with the results of the callback function executed on
	   * each entry of the matrix/array.
	   *
	   * Syntax:
	   *
	   *    math.map(x, callback)
	   *
	   * Examples:
	   *
	   *    math.map([1, 2, 3], function(value) {
	   *      return value * value;
	   *    });  // returns [1, 4, 9]
	   *
	   * See also:
	   *
	   *    filter, forEach, sort
	   *
	   * @param {Matrix | Array} x    The matrix to iterate on.
	   * @param {Function} callback   The callback method is invoked with three
	   *                              parameters: the value of the element, the index
	   *                              of the element, and the matrix being traversed.
	   * @return {Matrix | array}     Transformed map of x
	   */
	  var map = typed('map', {
	    'Array, function': _map,

	    'Matrix, function': function (x, callback) {
	      return x.map(callback);
	    }
	  });

	  map.toTex = '\\mathrm{${name}}\\left(${args}\\right)';

	  return map;
	}

	/**
	 * Map for a multi dimensional array
	 * @param {Array} array
	 * @param {Function} callback
	 * @return {Array}
	 * @private
	 */
	function _map (array, callback) {
	  var recurse = function (value, index) {
	    if (Array.isArray(value)) {
	      return value.map(function (child, i) {
	        // we create a copy of the index array and append the new index value
	        return recurse(child, index.concat(i));
	      });
	    }
	    else {
	      return callback(value, index, array);
	    }
	  };

	  return recurse(array, []);
	}

	exports.name = 'map';
	exports.factory = factory;


/***/ },
/* 237 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var isString = __webpack_require__(20).isString;
	var format = __webpack_require__(20).format;

	function factory (type, config, load, typed) {
	  /**
	   * Interpolate values into a string template.
	   *
	   * Syntax:
	   *
	   *     math.print(template, values)
	   *     math.print(template, values, precision)
	   *
	   * Example usage:
	   *
	   *     // the following outputs: 'Lucy is 5 years old'
	   *     math.print('Lucy is $age years old', {age: 5});
	   *
	   *     // the following outputs: 'The value of pi is 3.141592654'
	   *     math.print('The value of pi is $pi', {pi: math.pi}, 10);
	   *
	   *     // the following outputs: 'hello Mary! The date is 2013-03-23'
	   *     math.print('Hello $user.name! The date is $date', {
	   *       user: {
	   *         name: 'Mary',
	   *       },
	   *       date: new Date(2013, 2, 23).toISOString().substring(0, 10)
	   *     });
	   *
	   * See also:
	   *
	   *     format
	   *
	   * @param {string} template     A string containing variable placeholders.
	   * @param {Object} values       An object containing variables which will
	   *                              be filled in in the template.
	   * @param {number} [precision]  Number of digits to format numbers.
	   *                              If not provided, the value will not be rounded.
	   * @return {string} Interpolated string
	   */
	  var print = typed ('print', {
	    'string, Object': _print,
	    'string, Object, number': _print
	  });

	  print.toTex = '\\mathrm{${name}}\\left(${args}\\right)';

	  return print;
	}

	/**
	 * Interpolate values into a string template.
	 * @param {string} template
	 * @param {Object} values
	 * @param {number} [precision]
	 * @returns {string} Interpolated string
	 * @private
	 */
	function _print(template, values, precision) {
	  return template.replace(/\$([\w\.]+)/g, function (original, key) {
	        var keys = key.split('.');
	        var value = values[keys.shift()];
	        while (keys.length && value !== undefined) {
	          var k = keys.shift();
	          value = k ? value[k] : value + '.';
	        }

	        if (value !== undefined) {
	          if (!isString(value)) {
	            return format(value, precision);
	          }
	          else {
	            return value;
	          }
	        }

	        return original;
	      }
	  );
	}

	exports.name = 'print';
	exports.factory = factory;


/***/ },
/* 238 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var size = __webpack_require__(18).size;

	function factory (type, config, load, typed) {
	  var matrix = load(__webpack_require__(23));
	  var asc = load(__webpack_require__(170));
	  var desc = function (a, b) {
	    return -asc(a, b);
	  };

	  /**
	   * Sort the items in a matrix.
	   *
	   * Syntax:
	   *
	   *    math.sort(x)
	   *    math.sort(x, compare)
	   *
	   * Examples:
	   *
	   *    math.sort([5, 10, 1]); // returns [1, 5, 10]
	   *    math.sort(['C', 'B', 'A', 'D']); // returns ['A', 'B', 'C', 'D']
	   *
	   *    function sortByLength (a, b) {
	   *      return a.length - b.length;
	   *    }
	   *    math.sort(['Langdon', 'Tom', 'Sara'], sortByLength); // returns ['Tom', 'Sara', 'Langdon']
	   *
	   * See also:
	   *
	   *    filter, forEach, map
	   *
	   * @param {Matrix | Array} x    A one dimensional matrix or array to sort
	   * @param {Function | 'asc' | 'desc'} [compare='asc']
	   *        An optional _comparator function. The function is called as
	   *        `compare(a, b)`, and must return 1 when a > b, -1 when a < b,
	   *        and 0 when a == b.
	   * @return {Matrix | Array} Returns the sorted matrix.
	   */
	  var sort = typed('sort', {
	    'Array': function (x) {
	      _arrayIsVector(x);
	      return x.sort(asc);
	    },

	    'Matrix': function (x) {
	      _matrixIsVector(x);
	      return matrix(x.toArray().sort(asc), x.storage());
	    },

	    'Array, function': function (x, _comparator) {
	      _arrayIsVector(x);
	      return x.sort(_comparator);
	    },

	    'Matrix, function': function (x, _comparator) {
	      _matrixIsVector(x);
	      return matrix(x.toArray().sort(_comparator), x.storage());
	    },

	    'Array, string': function (x, order) {
	      _arrayIsVector(x);
	      return x.sort(_comparator(order));
	    },

	    'Matrix, string': function (x, order) {
	      _matrixIsVector(x);
	      return matrix(x.toArray().sort(_comparator(order)), x.storage());
	    }
	  });

	  sort.toTex = '\\mathrm{${name}}\\left(${args}\\right)';

	  /**
	   * Get the comparator for given order ('asc' or 'desc')
	   * @param {'asc' | 'desc'} order
	   * @return {Function} Returns a _comparator function
	   */
	  function _comparator (order) {
	    if (order === 'asc') {
	      return asc;
	    }
	    else if (order === 'desc') {
	      return desc;
	    }
	    else {
	      throw new Error('String "asc" or "desc" expected');
	    }
	  }

	  /**
	   * Validate whether an array is one dimensional
	   * Throws an error when this is not the case
	   * @param {Array} array
	   * @private
	   */
	  function _arrayIsVector (array) {
	    if (size(array).length !== 1) {
	      throw new Error('One dimensional array expected');
	    }
	  }

	  /**
	   * Validate whether a matrix is one dimensional
	   * Throws an error when this is not the case
	   * @param {Matrix} matrix
	   * @private
	   */
	  function _matrixIsVector (matrix) {
	    if (matrix.size().length !== 1) {
	      throw new Error('One dimensional matrix expected');
	    }
	  }

	  return sort;
	}

	exports.name = 'sort';
	exports.factory = factory;


/***/ },
/* 239 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var types = __webpack_require__(19);

	function factory (type, config, load, typed) {
	  /**
	   * Determine the type of a variable.
	   *
	   * Function `typeof` recognizes the following types of objects:
	   *
	   * Object                 | Returns       | Example
	   * ---------------------- | ------------- | ------------------------------------------
	   * null                   | `'null'`      | `math.typeof(null)`
	   * number                 | `'number'`    | `math.typeof(3.5)`
	   * boolean                | `'boolean'`   | `math.typeof (true)`
	   * string                 | `'string'`    | `math.typeof ('hello world')`
	   * Array                  | `'Array'`     | `math.typeof ([1, 2, 3])`
	   * Date                   | `'Date'`      | `math.typeof (new Date())`
	   * Function               | `'Function'`  | `math.typeof (function () {})`
	   * Object                 | `'Object'`    | `math.typeof ({a: 2, b: 3})`
	   * RegExp                 | `'RegExp'`    | `math.typeof (/a regexp/)`
	   * undefined              | `'undefined'` | `math.typeof(undefined)`
	   * math.type.BigNumber    | `'BigNumber'` | `math.typeof (math.bignumber('2.3e500'))`
	   * math.type.Chain        | `'Chain'`     | `math.typeof (math.chain(2))`
	   * math.type.Complex      | `'Complex'`   | `math.typeof (math.complex(2, 3))`
	   * math.type.Fraction     | `'Fraction'`  | `math.typeof (math.fraction(1, 3))`
	   * math.type.Help         | `'Help'`      | `math.typeof (math.help('sqrt'))`
	   * math.type.Index        | `'Index'`     | `math.typeof (math.index(1, 3))`
	   * math.type.Matrix       | `'Matrix'`    | `math.typeof (math.matrix([[1,2], [3, 4]]))`
	   * math.type.Range        | `'Range'`     | `math.typeof (math.range(0, 10))`
	   * math.type.Unit         | `'Unit'`      | `math.typeof (math.unit('45 deg'))`
	   *
	   * Syntax:
	   *
	   *    math.typeof(x)
	   *
	   * Examples:
	   *
	   *    math.typeof(3.5);                     // returns 'number'
	   *    math.typeof(math.complex('2 - 4i'));  // returns 'Complex'
	   *    math.typeof(math.unit('45 deg'));     // returns 'Unit'
	   *    math.typeof('hello world');           // returns 'string'
	   *
	   * @param {*} x     The variable for which to test the type.
	   * @return {string} Returns the name of the type. Primitive types are lower case,
	   *                  non-primitive types are upper-camel-case.
	   *                  For example 'number', 'string', 'Array', 'Date'.
	   */
	  var _typeof = typed('_typeof', {
	    'any': function (x) {
	      // JavaScript types
	      var t = types.type(x);

	      // math.js types
	      if (t === 'Object') {
	        if (x.isBigNumber === true) return 'BigNumber';
	        if (x.isComplex === true)   return 'Complex';
	        if (x.isFraction === true)  return 'Fraction';
	        if (x.isMatrix === true)    return 'Matrix';
	        if (x.isUnit === true)      return 'Unit';
	        if (x.isIndex === true)     return 'Index';
	        if (x.isRange === true)     return 'Range';
	        if (x.isChain === true)     return 'Chain';
	        if (x.isHelp === true)      return 'Help';
	      }

	      return t;
	    }
	  });

	  _typeof.toTex = '\\mathrm{${name}}\\left(${args}\\right)';

	  return _typeof;
	}

	exports.name = 'typeof';
	exports.factory = factory;


/***/ },
/* 240 */
/***/ function(module, exports) {

	'use strict';

	function factory (type, config, load, typed) {
	  /**
	   * Iterate over all elements of a matrix/array, and executes the given callback function.
	   *
	   * Syntax:
	   *
	   *    math.forEach(x, callback)
	   *
	   * Examples:
	   *
	   *    math.forEach([1, 2, 3], function(value) {
	   *      console.log(value);
	   *    });
	   *    // outputs 1, 2, 3
	   *
	   * See also:
	   *
	   *    filter, map, sort
	   *
	   * @param {Matrix | Array} x    The matrix to iterate on.
	   * @param {Function} callback   The callback function is invoked with three
	   *                              parameters: the value of the element, the index
	   *                              of the element, and the Matrix/array being traversed.
	   */
	  var forEach = typed('forEach', {
	    'Array, function': _forEach,

	    'Matrix, function': function (x, callback) {
	      return x.forEach(callback);
	    }
	  });

	  forEach.toTex = '\\mathrm{${name}}\\left(${args}\\right)';

	  return forEach;
	}

	/**
	 * forEach for a multi dimensional array
	 * @param {Array} array
	 * @param {Function} callback
	 * @private
	 */
	function _forEach (array, callback) {
	  var recurse = function (value, index) {
	    if (Array.isArray(value)) {
	      value.forEach(function (child, i) {
	        // we create a copy of the index array and append the new index value
	        recurse(child, index.concat(i));
	      });
	    }
	    else {
	      callback(value, index, array);
	    }
	  };
	  recurse(array, []);
	}

	exports.name = 'forEach';
	exports.factory = factory;


/***/ },
/* 241 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = [
	  __webpack_require__(253),
	  __webpack_require__(257),
	  __webpack_require__(258),
	  __webpack_require__(261),
	  __webpack_require__(265),
	  __webpack_require__(242),
	  __webpack_require__(271),
	  __webpack_require__(272),
	  __webpack_require__(274),
	  __webpack_require__(275)
	];


/***/ },
/* 242 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = [
	  // types
	  __webpack_require__(243),
	  __webpack_require__(244),
	  __webpack_require__(245),
	  __webpack_require__(246),
	  __webpack_require__(247),
	  __webpack_require__(248),
	  __webpack_require__(249),
	  __webpack_require__(250),

	  // construction functions
	  __webpack_require__(251),
	  __webpack_require__(23),
	  __webpack_require__(252)
	];


/***/ },
/* 243 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var util = __webpack_require__(36);

	var string = util.string;

	var isString = string.isString;

	function factory (type, config, load, typed) {
	  /**
	   * @constructor Matrix
	   *
	   * A Matrix is a wrapper around an Array. A matrix can hold a multi dimensional
	   * array. A matrix can be constructed as:
	   *     var matrix = math.matrix(data)
	   *
	   * Matrix contains the functions to resize, get and set values, get the size,
	   * clone the matrix and to convert the matrix to a vector, array, or scalar.
	   * Furthermore, one can iterate over the matrix using map and forEach.
	   * The internal Array of the Matrix can be accessed using the function valueOf.
	   *
	   * Example usage:
	   *     var matrix = math.matrix([[1, 2], [3, 4]]);
	   *     matix.size();              // [2, 2]
	   *     matrix.resize([3, 2], 5);
	   *     matrix.valueOf();          // [[1, 2], [3, 4], [5, 5]]
	   *     matrix.subset([1,2])       // 3 (indexes are zero-based)
	   *
	   */
	  function Matrix() {
	    if (!(this instanceof Matrix)) {
	      throw new SyntaxError('Constructor must be called with the new operator');
	    }
	  }

	  /**
	   * Attach type information
	   */
	  Matrix.prototype.type = 'Matrix';
	  Matrix.prototype.isMatrix = true;

	  /**
	   * Get the Matrix storage constructor for the given format.
	   *
	   * @param {string} format       The Matrix storage format.
	   *
	   * @return {Function}           The Matrix storage constructor.
	   */
	  Matrix.storage = function (format) {
	    // check storage format is a string
	    if (!isString(format)) {
	      throw new TypeError('format must be a string value');
	    }

	    // get storage format constructor
	    var constructor = Matrix._storage[format];
	    if (!constructor) {
	      throw new SyntaxError('Unsupported matrix storage format: ' + format);
	    }

	    // return storage constructor
	    return constructor;
	  };

	  // a map with all constructors for all storage types
	  Matrix._storage = {};

	  /**
	   * Get the storage format used by the matrix.
	   *
	   * Usage:
	   *     var format = matrix.storage()                   // retrieve storage format
	   *
	   * @return {string}           The storage format.
	   */
	  Matrix.prototype.storage = function () {
	    // must be implemented by each of the Matrix implementations
	    throw new Error('Cannot invoke storage on a Matrix interface');
	  };
	  
	  /**
	   * Get the datatype of the data stored in the matrix.
	   *
	   * Usage:
	   *     var format = matrix.datatype()                   // retrieve matrix datatype
	   *
	   * @return {string}           The datatype.
	   */
	  Matrix.prototype.datatype = function () {
	    // must be implemented by each of the Matrix implementations
	    throw new Error('Cannot invoke datatype on a Matrix interface');
	  };

	  /**
	   * Create a new Matrix With the type of the current matrix instance
	   * @param {Array | Object} data
	   * @param {string} [datatype]
	   */
	  Matrix.prototype.create = function (data, datatype) {
	    throw new Error('Cannot invoke create on a Matrix interface');
	  };

	  /**
	   * Get a subset of the matrix, or replace a subset of the matrix.
	   *
	   * Usage:
	   *     var subset = matrix.subset(index)               // retrieve subset
	   *     var value = matrix.subset(index, replacement)   // replace subset
	   *
	   * @param {Index} index
	   * @param {Array | Matrix | *} [replacement]
	   * @param {*} [defaultValue=0]      Default value, filled in on new entries when
	   *                                  the matrix is resized. If not provided,
	   *                                  new matrix elements will be filled with zeros.
	   */
	  Matrix.prototype.subset = function (index, replacement, defaultValue) {
	    // must be implemented by each of the Matrix implementations
	    throw new Error('Cannot invoke subset on a Matrix interface');
	  };

	  /**
	   * Get a single element from the matrix.
	   * @param {number[]} index   Zero-based index
	   * @return {*} value
	   */
	  Matrix.prototype.get = function (index) {
	    // must be implemented by each of the Matrix implementations
	    throw new Error('Cannot invoke get on a Matrix interface');
	  };

	  /**
	   * Replace a single element in the matrix.
	   * @param {number[]} index   Zero-based index
	   * @param {*} value
	   * @param {*} [defaultValue]        Default value, filled in on new entries when
	   *                                  the matrix is resized. If not provided,
	   *                                  new matrix elements will be left undefined.
	   * @return {Matrix} self
	   */
	  Matrix.prototype.set = function (index, value, defaultValue) {
	    // must be implemented by each of the Matrix implementations
	    throw new Error('Cannot invoke set on a Matrix interface');
	  };

	  /**
	   * Resize the matrix to the given size. Returns a copy of the matrix when 
	   * `copy=true`, otherwise return the matrix itself (resize in place).
	   *
	   * @param {number[]} size           The new size the matrix should have.
	   * @param {*} [defaultValue=0]      Default value, filled in on new entries.
	   *                                  If not provided, the matrix elements will
	   *                                  be filled with zeros.
	   * @param {boolean} [copy]          Return a resized copy of the matrix
	   *
	   * @return {Matrix}                 The resized matrix
	   */
	  Matrix.prototype.resize = function (size, defaultValue) {
	    // must be implemented by each of the Matrix implementations
	    throw new Error('Cannot invoke resize on a Matrix interface');
	  };

	  /**
	   * Create a clone of the matrix
	   * @return {Matrix} clone
	   */
	  Matrix.prototype.clone = function () {
	    // must be implemented by each of the Matrix implementations
	    throw new Error('Cannot invoke clone on a Matrix interface');
	  };

	  /**
	   * Retrieve the size of the matrix.
	   * @returns {number[]} size
	   */
	  Matrix.prototype.size = function() {
	    // must be implemented by each of the Matrix implementations
	    throw new Error('Cannot invoke size on a Matrix interface');
	  };

	  /**
	   * Create a new matrix with the results of the callback function executed on
	   * each entry of the matrix.
	   * @param {Function} callback   The callback function is invoked with three
	   *                              parameters: the value of the element, the index
	   *                              of the element, and the Matrix being traversed.
	   * @param {boolean} [skipZeros] Invoke callback function for non-zero values only.
	   *
	   * @return {Matrix} matrix
	   */
	  Matrix.prototype.map = function (callback, skipZeros) {
	    // must be implemented by each of the Matrix implementations
	    throw new Error('Cannot invoke map on a Matrix interface');
	  };

	  /**
	   * Execute a callback function on each entry of the matrix.
	   * @param {Function} callback   The callback function is invoked with three
	   *                              parameters: the value of the element, the index
	   *                              of the element, and the Matrix being traversed.
	   */
	  Matrix.prototype.forEach = function (callback) {
	    // must be implemented by each of the Matrix implementations
	    throw new Error('Cannot invoke forEach on a Matrix interface');
	  };

	  /**
	   * Create an Array with a copy of the data of the Matrix
	   * @returns {Array} array
	   */
	  Matrix.prototype.toArray = function () {
	    // must be implemented by each of the Matrix implementations
	    throw new Error('Cannot invoke toArray on a Matrix interface');
	  };

	  /**
	   * Get the primitive value of the Matrix: a multidimensional array
	   * @returns {Array} array
	   */
	  Matrix.prototype.valueOf = function () {
	    // must be implemented by each of the Matrix implementations
	    throw new Error('Cannot invoke valueOf on a Matrix interface');
	  };

	  /**
	   * Get a string representation of the matrix, with optional formatting options.
	   * @param {Object | number | Function} [options]  Formatting options. See
	   *                                                lib/utils/number:format for a
	   *                                                description of the available
	   *                                                options.
	   * @returns {string} str
	   */
	  Matrix.prototype.format = function (options) {
	    // must be implemented by each of the Matrix implementations
	    throw new Error('Cannot invoke format on a Matrix interface');
	  };

	  /**
	   * Get a string representation of the matrix
	   * @returns {string} str
	   */
	  Matrix.prototype.toString = function () {
	    // must be implemented by each of the Matrix implementations
	    throw new Error('Cannot invoke toString on a Matrix interface');
	  };
	   
	  // exports
	  return Matrix;
	}

	exports.name = 'Matrix';
	exports.path = 'type';
	exports.factory = factory;


/***/ },
/* 244 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var util = __webpack_require__(36);
	var DimensionError = __webpack_require__(22);

	var string = util.string;
	var array = util.array;
	var object = util.object;
	var number = util.number;

	var isArray = Array.isArray;
	var isNumber = number.isNumber;
	var isInteger = number.isInteger;
	var isString = string.isString;

	var validateIndex = array.validateIndex;

	function factory (type, config, load, typed) {
	  var Matrix = load(__webpack_require__(243)); // force loading Matrix (do not use via type.Matrix)

	  function DenseMatrix(data, datatype) {
	    if (!(this instanceof DenseMatrix))
	      throw new SyntaxError('Constructor must be called with the new operator');
	    if (datatype && !isString(datatype))
	      throw new Error('Invalid datatype: ' + datatype);

	    if (data && data.isMatrix === true) {
	      // check data is a DenseMatrix
	      if (data.type === 'DenseMatrix') {
	        // clone data & size
	        this._data = object.clone(data._data);
	        this._size = object.clone(data._size);
	        this._datatype = datatype || data._datatype;
	      }
	      else {
	        // build data from existing matrix
	        this._data = data.toArray();
	        this._size = data.size();
	        this._datatype = datatype || data._datatype;
	      }
	    }
	    else if (data && isArray(data.data) && isArray(data.size)) {
	      // initialize fields from JSON representation
	      this._data = data.data;
	      this._size = data.size;
	      this._datatype = datatype || data.datatype;
	    }
	    else if (isArray(data)) {
	      // replace nested Matrices with Arrays
	      this._data = preprocess(data);
	      // get the dimensions of the array
	      this._size = array.size(this._data);
	      // verify the dimensions of the array, TODO: compute size while processing array
	      array.validate(this._data, this._size);
	      // data type unknown
	      this._datatype = datatype;
	    }
	    else if (data) {
	      // unsupported type
	      throw new TypeError('Unsupported type of data (' + util.types.type(data) + ')');
	    }
	    else {
	      // nothing provided
	      this._data = [];
	      this._size = [0];
	      this._datatype = datatype;
	    }
	  }
	  
	  DenseMatrix.prototype = new Matrix();

	  /**
	   * Attach type information
	   */
	  DenseMatrix.prototype.type = 'DenseMatrix';
	  DenseMatrix.prototype.isDenseMatrix = true;

	  /**
	   * Get the storage format used by the matrix.
	   *
	   * Usage:
	   *     var format = matrix.storage()                   // retrieve storage format
	   *
	   * @return {string}           The storage format.
	   */
	  DenseMatrix.prototype.storage = function () {
	    return 'dense';
	  };

	  /**
	   * Get the datatype of the data stored in the matrix.
	   *
	   * Usage:
	   *     var format = matrix.datatype()                   // retrieve matrix datatype
	   *
	   * @return {string}           The datatype.
	   */
	  DenseMatrix.prototype.datatype = function () {
	    return this._datatype;
	  };

	  /**
	   * Create a new DenseMatrix
	   * @param {Array} data
	   * @param {string} [datatype]
	   */
	  DenseMatrix.prototype.create = function (data, datatype) {
	    return new DenseMatrix(data, datatype);
	  };

	  /**
	   * Get a subset of the matrix, or replace a subset of the matrix.
	   *
	   * Usage:
	   *     var subset = matrix.subset(index)               // retrieve subset
	   *     var value = matrix.subset(index, replacement)   // replace subset
	   *
	   * @param {Index} index
	   * @param {Array | DenseMatrix | *} [replacement]
	   * @param {*} [defaultValue=0]      Default value, filled in on new entries when
	   *                                  the matrix is resized. If not provided,
	   *                                  new matrix elements will be filled with zeros.
	   */
	  DenseMatrix.prototype.subset = function (index, replacement, defaultValue) {
	    switch (arguments.length) {
	      case 1:
	        return _get(this, index);

	        // intentional fall through
	      case 2:
	      case 3:
	        return _set(this, index, replacement, defaultValue);

	      default:
	        throw new SyntaxError('Wrong number of arguments');
	    }
	  };
	  
	  /**
	   * Get a single element from the matrix.
	   * @param {number[]} index   Zero-based index
	   * @return {*} value
	   */
	  DenseMatrix.prototype.get = function (index) {
	    if (!isArray(index))
	      throw new TypeError('Array expected');
	    if (index.length != this._size.length)
	      throw new DimensionError(index.length, this._size.length);

	    // check index
	    for (var x = 0; x < index.length; x++)
	      validateIndex(index[x], this._size[x]);

	    var data = this._data;
	    for (var i = 0, ii = index.length; i < ii; i++) {
	      var index_i = index[i];
	      validateIndex(index_i, data.length);
	      data = data[index_i];
	    }

	    return object.clone(data);
	  };
	  
	  /**
	   * Replace a single element in the matrix.
	   * @param {number[]} index   Zero-based index
	   * @param {*} value
	   * @param {*} [defaultValue]        Default value, filled in on new entries when
	   *                                  the matrix is resized. If not provided,
	   *                                  new matrix elements will be left undefined.
	   * @return {DenseMatrix} self
	   */
	  DenseMatrix.prototype.set = function (index, value, defaultValue) {
	    if (!isArray(index))
	      throw new TypeError('Array expected');
	    if (index.length < this._size.length)
	      throw new DimensionError(index.length, this._size.length, '<');

	    var i, ii, index_i;

	    // enlarge matrix when needed
	    var size = index.map(function (i) {
	      return i + 1;
	    });
	    _fit(this, size, defaultValue);

	    // traverse over the dimensions
	    var data = this._data;
	    for (i = 0, ii = index.length - 1; i < ii; i++) {
	      index_i = index[i];
	      validateIndex(index_i, data.length);
	      data = data[index_i];
	    }

	    // set new value
	    index_i = index[index.length - 1];
	    validateIndex(index_i, data.length);
	    data[index_i] = value;

	    return this;
	  };
	  
	  /**
	   * Get a submatrix of this matrix
	   * @param {DenseMatrix} matrix
	   * @param {Index} index   Zero-based index
	   * @private
	   */
	  function _get (matrix, index) {
	    if (!index || index.isIndex !== true) {
	      throw new TypeError('Invalid index');
	    }

	    var isScalar = index.isScalar();
	    if (isScalar) {
	      // return a scalar
	      return matrix.get(index.min());
	    }
	    else {
	      // validate dimensions
	      var size = index.size();
	      if (size.length != matrix._size.length) {
	        throw new DimensionError(size.length, matrix._size.length);
	      }

	      // validate if any of the ranges in the index is out of range
	      var min = index.min();
	      var max = index.max();
	      for (var i = 0, ii = matrix._size.length; i < ii; i++) {
	        validateIndex(min[i], matrix._size[i]);
	        validateIndex(max[i], matrix._size[i]);
	      }

	      // retrieve submatrix
	      // TODO: more efficient when creating an empty matrix and setting _data and _size manually
	      return new DenseMatrix(_getSubmatrix(matrix._data, index, size.length, 0), matrix._datatype);
	    }
	  }
	  
	  /**
	   * Recursively get a submatrix of a multi dimensional matrix.
	   * Index is not checked for correct number or length of dimensions.
	   * @param {Array} data
	   * @param {Index} index
	   * @param {number} dims   Total number of dimensions
	   * @param {number} dim    Current dimension
	   * @return {Array} submatrix
	   * @private
	   */
	  function _getSubmatrix (data, index, dims, dim) {
	    var last = (dim == dims - 1);
	    var range = index.dimension(dim);

	    if (last) {
	      return range.map(function (i) {
	        return data[i];
	      }).valueOf();
	    }
	    else {
	      return range.map(function (i) {
	        var child = data[i];
	        return _getSubmatrix(child, index, dims, dim + 1);
	      }).valueOf();
	    }
	  }
	  
	  /**
	   * Replace a submatrix in this matrix
	   * Indexes are zero-based.
	   * @param {DenseMatrix} matrix
	   * @param {Index} index
	   * @param {DenseMatrix | Array | *} submatrix
	   * @param {*} defaultValue          Default value, filled in on new entries when
	   *                                  the matrix is resized.
	   * @return {DenseMatrix} matrix
	   * @private
	   */
	  function _set (matrix, index, submatrix, defaultValue) {
	    if (!index || index.isIndex !== true) {
	      throw new TypeError('Invalid index');
	    }

	    // get index size and check whether the index contains a single value
	    var iSize = index.size(),
	        isScalar = index.isScalar();

	    // calculate the size of the submatrix, and convert it into an Array if needed
	    var sSize;
	    if (submatrix && submatrix.isMatrix === true) {
	      sSize = submatrix.size();
	      submatrix = submatrix.valueOf();
	    }
	    else {
	      sSize = array.size(submatrix);
	    }

	    if (isScalar) {
	      // set a scalar

	      // check whether submatrix is a scalar
	      if (sSize.length !== 0) {
	        throw new TypeError('Scalar expected');
	      }

	      matrix.set(index.min(), submatrix, defaultValue);
	    }
	    else {
	      // set a submatrix

	      // validate dimensions
	      if (iSize.length < matrix._size.length) {
	        throw new DimensionError(iSize.length, matrix._size.length, '<');
	      }

	      if (sSize.length < iSize.length) {
	        // calculate number of missing outer dimensions
	        var i = 0;
	        var outer = 0;
	        while (iSize[i] === 1 && sSize[i] === 1) {
	          i++;
	        }
	        while (iSize[i] === 1) {
	          outer++;
	          i++;
	        }

	        // unsqueeze both outer and inner dimensions
	        submatrix = array.unsqueeze(submatrix, iSize.length, outer, sSize);
	      }

	      // check whether the size of the submatrix matches the index size
	      if (!object.deepEqual(iSize, sSize)) {
	        throw new DimensionError(iSize, sSize, '>');
	      }

	      // enlarge matrix when needed
	      var size = index.max().map(function (i) {
	        return i + 1;
	      });
	      _fit(matrix, size, defaultValue);

	      // insert the sub matrix
	      var dims = iSize.length,
	          dim = 0;
	      _setSubmatrix (matrix._data, index, submatrix, dims, dim);
	    }

	    return matrix;
	  }
	  
	  /**
	   * Replace a submatrix of a multi dimensional matrix.
	   * @param {Array} data
	   * @param {Index} index
	   * @param {Array} submatrix
	   * @param {number} dims   Total number of dimensions
	   * @param {number} dim
	   * @private
	   */
	  function _setSubmatrix (data, index, submatrix, dims, dim) {
	    var last = (dim == dims - 1),
	        range = index.dimension(dim);

	    if (last) {
	      range.forEach(function (dataIndex, subIndex) {
	        validateIndex(dataIndex);
	        data[dataIndex] = submatrix[subIndex[0]];
	      });
	    }
	    else {
	      range.forEach(function (dataIndex, subIndex) {
	        validateIndex(dataIndex);
	        _setSubmatrix(data[dataIndex], index, submatrix[subIndex[0]], dims, dim + 1);
	      });
	    }
	  }
	  
	  /**
	   * Resize the matrix to the given size. Returns a copy of the matrix when
	   * `copy=true`, otherwise return the matrix itself (resize in place).
	   *
	   * @param {number[]} size           The new size the matrix should have.
	   * @param {*} [defaultValue=0]      Default value, filled in on new entries.
	   *                                  If not provided, the matrix elements will
	   *                                  be filled with zeros.
	   * @param {boolean} [copy]          Return a resized copy of the matrix
	   *
	   * @return {Matrix}                 The resized matrix
	   */
	  DenseMatrix.prototype.resize = function (size, defaultValue, copy) {
	    // validate arguments
	    if (!isArray(size))
	      throw new TypeError('Array expected');

	    // matrix to resize
	    var m = copy ? this.clone() : this;
	    // resize matrix
	    return _resize(m, size, defaultValue);
	  };
	  
	  var _resize = function (matrix, size, defaultValue) {
	    // check size
	    if (size.length === 0) {
	      // first value in matrix
	      var v = matrix._data;
	      // go deep
	      while (isArray(v)) {
	        v = v[0];
	      }
	      return object.clone(v);
	    }
	    // resize matrix
	    matrix._size = object.clone(size);
	    matrix._data = array.resize(matrix._data, matrix._size, defaultValue);
	    // return matrix
	    return matrix;
	  };
	  
	  /**
	   * Enlarge the matrix when it is smaller than given size.
	   * If the matrix is larger or equal sized, nothing is done.
	   * @param {DenseMatrix} matrix           The matrix to be resized
	   * @param {number[]} size
	   * @param {*} defaultValue          Default value, filled in on new entries.
	   * @private
	   */
	  function _fit(matrix, size, defaultValue) {
	    var newSize = object.clone(matrix._size),
	        changed = false;

	    // add dimensions when needed
	    while (newSize.length < size.length) {
	      newSize.push(0);
	      changed = true;
	    }

	    // enlarge size when needed
	    for (var i = 0, ii = size.length; i < ii; i++) {
	      if (size[i] > newSize[i]) {
	        newSize[i] = size[i];
	        changed = true;
	      }
	    }

	    if (changed) {
	      // resize only when size is changed
	      _resize(matrix, newSize, defaultValue);
	    }
	  }
	  
	  /**
	   * Create a clone of the matrix
	   * @return {DenseMatrix} clone
	   */
	  DenseMatrix.prototype.clone = function () {
	    var m = new DenseMatrix({
	      data: object.clone(this._data),
	      size: object.clone(this._size),
	      datatype: this._datatype
	    });
	    return m;
	  };
	  
	  /**
	   * Retrieve the size of the matrix.
	   * @returns {number[]} size
	   */
	  DenseMatrix.prototype.size = function() {
	    return this._size;
	  };
	  
	  /**
	   * Create a new matrix with the results of the callback function executed on
	   * each entry of the matrix.
	   * @param {Function} callback   The callback function is invoked with three
	   *                              parameters: the value of the element, the index
	   *                              of the element, and the Matrix being traversed.
	   *
	   * @return {DenseMatrix} matrix
	   */
	  DenseMatrix.prototype.map = function (callback) {
	    // matrix instance
	    var me = this;
	    var recurse = function (value, index) {
	      if (isArray(value)) {
	        return value.map(function (child, i) {
	          return recurse(child, index.concat(i));
	        });
	      }
	      else {
	        return callback(value, index, me);
	      }
	    };
	    // return dense format
	    return new DenseMatrix({
	      data: recurse(this._data, []),
	      size: object.clone(this._size),
	      datatype: this._datatype
	    });
	  };
	  
	  /**
	   * Execute a callback function on each entry of the matrix.
	   * @param {Function} callback   The callback function is invoked with three
	   *                              parameters: the value of the element, the index
	   *                              of the element, and the Matrix being traversed.
	   */
	  DenseMatrix.prototype.forEach = function (callback) {
	    // matrix instance
	    var me = this;
	    var recurse = function (value, index) {
	      if (isArray(value)) {
	        value.forEach(function (child, i) {
	          recurse(child, index.concat(i));
	        });
	      }
	      else {
	        callback(value, index, me);
	      }
	    };
	    recurse(this._data, []);
	  };
	  
	  /**
	   * Create an Array with a copy of the data of the DenseMatrix
	   * @returns {Array} array
	   */
	  DenseMatrix.prototype.toArray = function () {
	    return object.clone(this._data);
	  };
	  
	  /**
	   * Get the primitive value of the DenseMatrix: a multidimensional array
	   * @returns {Array} array
	   */
	  DenseMatrix.prototype.valueOf = function () {
	    return this._data;
	  };
	  
	  /**
	   * Get a string representation of the matrix, with optional formatting options.
	   * @param {Object | number | Function} [options]  Formatting options. See
	   *                                                lib/utils/number:format for a
	   *                                                description of the available
	   *                                                options.
	   * @returns {string} str
	   */
	  DenseMatrix.prototype.format = function (options) {
	    return string.format(this._data, options);
	  };
	  
	  /**
	   * Get a string representation of the matrix
	   * @returns {string} str
	   */
	  DenseMatrix.prototype.toString = function () {
	    return string.format(this._data);
	  };
	  
	  /**
	   * Get a JSON representation of the matrix
	   * @returns {Object}
	   */
	  DenseMatrix.prototype.toJSON = function () {
	    return {
	      mathjs: 'DenseMatrix',
	      data: this._data,
	      size: this._size,
	      datatype: this._datatype
	    };
	  };
	  
	  /**
	   * Get the kth Matrix diagonal.
	   *
	   * @param {number | BigNumber} [k=0]     The kth diagonal where the vector will retrieved.
	   *
	   * @returns {Array}                      The array vector with the diagonal values.
	   */
	  DenseMatrix.prototype.diagonal = function(k) {
	    // validate k if any
	    if (k) {
	      // convert BigNumber to a number
	      if (k.isBigNumber === true)
	        k = k.toNumber();
	      // is must be an integer
	      if (!isNumber(k) || !isInteger(k)) {
	        throw new TypeError ('The parameter k must be an integer number');
	      }
	    }
	    else {
	      // default value
	      k = 0;
	    }

	    var kSuper = k > 0 ? k : 0;
	    var kSub = k < 0 ? -k : 0;

	    // rows & columns
	    var rows = this._size[0];
	    var columns = this._size[1];

	    // number diagonal values
	    var n = Math.min(rows - kSub, columns -  kSuper);
	    
	    // x is a matrix get diagonal from matrix
	    var data = [];
	    
	    // loop rows
	    for (var i = 0; i < n; i++) {
	      data[i] = object.clone(this._data[i + kSub][i + kSuper]);
	    }

	    // create DenseMatrix
	    return new DenseMatrix({
	      data: data,
	      size: [n],
	      datatype: this._datatype
	    });
	  };
	  
	  /**
	   * Create a diagonal matrix.
	   *
	   * @param {Array} size                   The matrix size.
	   * @param {number, Array} value          The values for the diagonal.
	   * @param {number | BigNumber} [k=0]     The kth diagonal where the vector will be filled in.
	   * @param {number} [defaultValue]        The default value for non-diagonal
	   *
	   * @returns {DenseMatrix}
	   */
	  DenseMatrix.diagonal = function (size, value, k, defaultValue, datatype) {
	    if (!isArray(size))
	      throw new TypeError('Array expected, size parameter');
	    if (size.length !== 2)
	      throw new Error('Only two dimensions matrix are supported');

	    // map size & validate
	    size = size.map(function (s) {
	      // check it is a big number
	      if (s && s.isBigNumber === true) {
	        // convert it
	        s = s.toNumber();
	      }
	      // validate arguments
	      if (!isNumber(s) || !isInteger(s) || s < 1) {
	        throw new Error('Size values must be positive integers');
	      } 
	      return s;
	    });

	    // validate k if any
	    if (k) {
	      // convert BigNumber to a number
	      if (k && k.isBigNumber === true)
	        k = k.toNumber();
	      // is must be an integer
	      if (!isNumber(k) || !isInteger(k)) {
	        throw new TypeError ('The parameter k must be an integer number');
	      }
	    }
	    else {
	      // default value
	      k = 0;
	    }
	    
	    if (defaultValue && isString(datatype)) {
	      // convert defaultValue to the same datatype
	      defaultValue = typed.convert(defaultValue, datatype);
	    }

	    var kSuper = k > 0 ? k : 0;
	    var kSub = k < 0 ? -k : 0;
	    
	    // rows and columns
	    var rows = size[0];
	    var columns = size[1];

	    // number of non-zero items
	    var n = Math.min(rows - kSub, columns -  kSuper);

	    // value extraction function
	    var _value;

	    // check value
	    if (isArray(value)) {
	      // validate array
	      if (value.length !== n) {
	        // number of values in array must be n
	        throw new Error('Invalid value array length');
	      }
	      // define function
	      _value = function (i) {
	        // return value @ i
	        return value[i];
	      };      
	    }
	    else if (value && value.isMatrix === true) {
	      // matrix size
	      var ms = value.size();
	      // validate matrix
	      if (ms.length !== 1 || ms[0] !== n) {
	        // number of values in array must be n
	        throw new Error('Invalid matrix length');
	      }
	      // define function
	      _value = function (i) {
	        // return value @ i
	        return value.get([i]);
	      };
	    }
	    else {
	      // define function
	      _value = function () {
	        // return value
	        return value;
	      };
	    }
	    
	    // discover default value if needed
	    if (!defaultValue) {
	      // check first value in array
	      defaultValue = (_value(0) && _value(0).isBigNumber === true) ? new type.BigNumber(0) : 0;
	    }

	    // empty array
	    var data = [];

	    // check we need to resize array
	    if (size.length > 0) {
	      // resize array
	      data = array.resize(data, size, defaultValue);
	      // fill diagonal
	      for (var d = 0; d < n; d++) {
	        data[d + kSub][d + kSuper] = _value(d);
	      }
	    }
	    
	    // create DenseMatrix
	    return new DenseMatrix({
	      data: data,
	      size: [rows, columns]
	    });
	  };

	  /**
	   * Generate a matrix from a JSON object
	   * @param {Object} json  An object structured like
	   *                       `{"mathjs": "DenseMatrix", data: [], size: []}`,
	   *                       where mathjs is optional
	   * @returns {DenseMatrix}
	   */
	  DenseMatrix.fromJSON = function (json) {
	    return new DenseMatrix(json);
	  };
	  
	  /**
	   * Swap rows i and j in Matrix.
	   *
	   * @param {number} i       Matrix row index 1
	   * @param {number} j       Matrix row index 2
	   *
	   * @return {Matrix}        The matrix reference
	   */
	  DenseMatrix.prototype.swapRows = function (i, j) {
	    // check index
	    if (!isNumber(i) || !isInteger(i) || !isNumber(j) || !isInteger(j)) {
	      throw new Error('Row index must be positive integers');
	    }
	    // check dimensions
	    if (this._size.length !== 2) {
	      throw new Error('Only two dimensional matrix is supported');
	    }
	    // validate index
	    validateIndex(i, this._size[0]);
	    validateIndex(j, this._size[0]);

	    // swap rows
	    DenseMatrix._swapRows(i, j, this._data);
	    // return current instance
	    return this;
	  };

	  /**
	   * Swap rows i and j in Dense Matrix data structure.
	   *
	   * @param {number} i       Matrix row index 1
	   * @param {number} j       Matrix row index 2
	   */
	  DenseMatrix._swapRows = function (i, j, data) {
	    // swap values i <-> j
	    var vi = data[i];
	    data[i] = data[j];
	    data[j] = vi;
	  };
	   
	  /**
	   * Preprocess data, which can be an Array or DenseMatrix with nested Arrays and
	   * Matrices. Replaces all nested Matrices with Arrays
	   * @param {Array} data
	   * @return {Array} data
	   */
	  function preprocess(data) {
	    for (var i = 0, ii = data.length; i < ii; i++) {
	      var elem = data[i];
	      if (isArray(elem)) {
	        data[i] = preprocess(elem);
	      }
	      else if (elem && elem.isMatrix === true) {
	        data[i] = preprocess(elem.valueOf());
	      }
	    }

	    return data;
	  }

	  // register this type in the base class Matrix
	  type.Matrix._storage.dense = DenseMatrix;
	  type.Matrix._storage['default'] = DenseMatrix;

	  // exports
	  return DenseMatrix;
	}

	exports.name = 'DenseMatrix';
	exports.path = 'type';
	exports.factory = factory;
	exports.lazy = false;  // no lazy loading, as we alter type.Matrix._storage

/***/ },
/* 245 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var util = __webpack_require__(36);
	var DimensionError = __webpack_require__(22);

	var array = util.array;
	var object = util.object;
	var string = util.string;
	var number = util.number;

	var isArray = Array.isArray;
	var isNumber = number.isNumber;
	var isInteger = number.isInteger;
	var isString = string.isString;

	var validateIndex = array.validateIndex;

	function factory (type, config, load, typed) {
	  var Matrix = load(__webpack_require__(243)); // force loading Matrix (do not use via type.Matrix)
	  var equalScalar = load(__webpack_require__(33));

	  /**
	   * Sparse Matrix implementation. This type implements a Compressed Column Storage format
	   * for sparse matrices.
	   */
	  function SparseMatrix(data, datatype) {
	    if (!(this instanceof SparseMatrix))
	      throw new SyntaxError('Constructor must be called with the new operator');
	    if (datatype && !isString(datatype))
	      throw new Error('Invalid datatype: ' + datatype);
	    
	    if (data && data.isMatrix === true) {
	      // create from matrix
	      _createFromMatrix(this, data, datatype);
	    }
	    else if (data && isArray(data.index) && isArray(data.ptr) && isArray(data.size)) {
	      // initialize fields
	      this._values = data.values;
	      this._index = data.index;
	      this._ptr = data.ptr;
	      this._size = data.size;
	      this._datatype = datatype || data.datatype;
	    }
	    else if (isArray(data)) {
	      // create from array
	      _createFromArray(this, data, datatype);
	    }
	    else if (data) {
	      // unsupported type
	      throw new TypeError('Unsupported type of data (' + util.types.type(data) + ')');
	    }
	    else {
	      // nothing provided
	      this._values = [];
	      this._index = [];
	      this._ptr = [0];
	      this._size = [0];
	      this._datatype = datatype;
	    }
	  }
	  
	  var _createFromMatrix = function (matrix, source, datatype) {
	    // check matrix type
	    if (source.type === 'SparseMatrix') {
	      // clone arrays
	      matrix._values = source._values ? object.clone(source._values) : undefined;
	      matrix._index = object.clone(source._index);
	      matrix._ptr = object.clone(source._ptr);
	      matrix._size = object.clone(source._size);
	      matrix._datatype = datatype || source._datatype;
	    }
	    else {
	      // build from matrix data
	      _createFromArray(matrix, source.valueOf(), datatype || source._datatype);
	    }
	  };
	  
	  var _createFromArray = function (matrix, data, datatype) {
	    // initialize fields
	    matrix._values = [];
	    matrix._index = [];
	    matrix._ptr = [];
	    matrix._datatype = datatype;
	    // discover rows & columns, do not use math.size() to avoid looping array twice
	    var rows = data.length;
	    var columns = 0;
	    
	    // equal signature to use
	    var eq = equalScalar;
	    // zero value
	    var zero = 0;
	    
	    if (isString(datatype)) {
	      // find signature that matches (datatype, datatype)
	      eq = typed.find(equalScalar, [datatype, datatype]) || equalScalar;
	      // convert 0 to the same datatype
	      zero = typed.convert(0, datatype);
	    }

	    // check we have rows (empty array)
	    if (rows > 0) {
	      // column index
	      var j = 0;
	      do {
	        // store pointer to values index
	        matrix._ptr.push(matrix._index.length);
	        // loop rows
	        for (var i = 0; i < rows; i++) {
	          // current row
	          var row = data[i];
	          // check row is an array
	          if (isArray(row)) {
	            // update columns if needed (only on first column)
	            if (j === 0 && columns < row.length)
	              columns = row.length;
	            // check row has column
	            if (j < row.length) {
	              // value
	              var v = row[j];
	              // check value != 0
	              if (!eq(v, zero)) {
	                // store value
	                matrix._values.push(v);
	                // index
	                matrix._index.push(i);
	              }
	            }
	          }
	          else {
	            // update columns if needed (only on first column)
	            if (j === 0 && columns < 1)
	              columns = 1;
	            // check value != 0 (row is a scalar)
	            if (!eq(row, zero)) {
	              // store value
	              matrix._values.push(row);
	              // index
	              matrix._index.push(i);
	            }
	          }
	        }
	        // increment index
	        j++;      
	      }
	      while (j < columns);
	    }
	    // store number of values in ptr
	    matrix._ptr.push(matrix._index.length);
	    // size
	    matrix._size = [rows, columns];
	  };
	  
	  SparseMatrix.prototype = new Matrix();

	  /**
	   * Attach type information
	   */
	  SparseMatrix.prototype.type = 'SparseMatrix';
	  SparseMatrix.prototype.isSparseMatrix = true;

	  /**
	   * Get the storage format used by the matrix.
	   *
	   * Usage:
	   *     var format = matrix.storage()                   // retrieve storage format
	   *
	   * @return {string}           The storage format.
	   */
	  SparseMatrix.prototype.storage = function () {
	    return 'sparse';
	  };

	  /**
	   * Get the datatype of the data stored in the matrix.
	   *
	   * Usage:
	   *     var format = matrix.datatype()                   // retrieve matrix datatype
	   *
	   * @return {string}           The datatype.
	   */
	  SparseMatrix.prototype.datatype = function () {
	    return this._datatype;
	  };

	  /**
	   * Create a new SparseMatrix
	   * @param {Array} data
	   * @param {string} [datatype]
	   */
	  SparseMatrix.prototype.create = function (data, datatype) {
	    return new SparseMatrix(data, datatype);
	  };

	  /**
	   * Get the matrix density.
	   *
	   * Usage:
	   *     var density = matrix.density()                   // retrieve matrix density
	   *
	   * @return {number}           The matrix density.
	   */
	  SparseMatrix.prototype.density = function () {
	    // rows & columns
	    var rows = this._size[0];
	    var columns = this._size[1];
	    // calculate density
	    return rows !== 0 && columns !== 0 ? (this._index.length / (rows * columns)) : 0;
	  };
	  
	  /**
	   * Get a subset of the matrix, or replace a subset of the matrix.
	   *
	   * Usage:
	   *     var subset = matrix.subset(index)               // retrieve subset
	   *     var value = matrix.subset(index, replacement)   // replace subset
	   *
	   * @param {Index} index
	   * @param {Array | Maytrix | *} [replacement]
	   * @param {*} [defaultValue=0]      Default value, filled in on new entries when
	   *                                  the matrix is resized. If not provided,
	   *                                  new matrix elements will be filled with zeros.
	   */
	  SparseMatrix.prototype.subset = function (index, replacement, defaultValue) {	
		// check it is a pattern matrix
	    if (!this._values)
	      throw new Error('Cannot invoke subset on a Pattern only matrix');

	    // check arguments
	    switch (arguments.length) {
	      case 1:
	        return _getsubset(this, index);

	        // intentional fall through
	      case 2:
	      case 3:
	        return _setsubset(this, index, replacement, defaultValue);

	      default:
	        throw new SyntaxError('Wrong number of arguments');
	    }
	  };
	  
	  var _getsubset = function (matrix, idx) {
	    // check idx
	    if (!idx || idx.isIndex !== true) {
	      throw new TypeError('Invalid index');
	    }

	    var isScalar = idx.isScalar();
	    if (isScalar) {
	      // return a scalar
	      return matrix.get(idx.min());
	    }
	    // validate dimensions
	    var size = idx.size();
	    if (size.length != matrix._size.length) {
	      throw new DimensionError(size.length, matrix._size.length);
	    }

	    // vars
	    var i, ii, k, kk;
	    
	    // validate if any of the ranges in the index is out of range
	    var min = idx.min();
	    var max = idx.max();
	    for (i = 0, ii = matrix._size.length; i < ii; i++) {
	      validateIndex(min[i], matrix._size[i]);
	      validateIndex(max[i], matrix._size[i]);
	    }
	    
	    // matrix arrays
	    var mvalues = matrix._values;
	    var mindex = matrix._index;
	    var mptr = matrix._ptr;
	        
	    // rows & columns dimensions for result matrix
	    var rows = idx.dimension(0);
	    var columns = idx.dimension(1);
	    
	    // workspace & permutation vector
	    var w = [];
	    var pv = [];
	    
	    // loop rows in resulting matrix
	    rows.forEach(function (i, r) {
	      // update permutation vector
	      pv[i] = r[0];  
	      // mark i in workspace
	      w[i] = true;
	    });

	    // result matrix arrays
	    var values = mvalues ? [] : undefined;
	    var index = [];
	    var ptr = [];
	        
	    // loop columns in result matrix
	    columns.forEach(function (j) {
	      // update ptr
	      ptr.push(index.length);
	      // loop values in column j
	      for (k = mptr[j], kk = mptr[j + 1]; k < kk; k++) {
	        // row
	        i = mindex[k];
	        // check row is in result matrix
	        if (w[i] === true) {
	          // push index
	          index.push(pv[i]);
	          // check we need to process values
	          if (values)
	            values.push(mvalues[k]);
	        }
	      }
	    });
	    // update ptr
	    ptr.push(index.length);
	    
	    // return matrix
	    return new SparseMatrix({
	      values: values,
	      index: index,
	      ptr: ptr,
	      size: size,
	      datatype: matrix._datatype
	    });
	  };
	  
	  var _setsubset = function (matrix, index, submatrix, defaultValue) {
	    // check index
	    if (!index || index.isIndex !== true) {
	      throw new TypeError('Invalid index');
	    }
	    
	    // get index size and check whether the index contains a single value
	    var iSize = index.size(),
	        isScalar = index.isScalar();
	    
	    // calculate the size of the submatrix, and convert it into an Array if needed
	    var sSize;
	    if (submatrix && submatrix.isMatrix === true) {
	      // submatrix size
	      sSize = submatrix.size();
	      // use array representation
	      submatrix = submatrix.toArray();
	    }
	    else {
	      // get submatrix size (array, scalar)
	      sSize = array.size(submatrix);
	    }
	    
	    // check index is a scalar
	    if (isScalar) {
	      // verify submatrix is a scalar
	      if (sSize.length !== 0) {
	        throw new TypeError('Scalar expected');
	      }
	      // set value
	      matrix.set(index.min(), submatrix, defaultValue);
	    }
	    else {
	      // validate dimensions, index size must be one or two dimensions
	      if (iSize.length !== 1 && iSize.length !== 2) {
	        throw new DimensionError(iSize.length, matrix._size.length, '<');
	      }
	      
	      // check submatrix and index have the same dimensions
	      if (sSize.length < iSize.length) {
	        // calculate number of missing outer dimensions
	        var i = 0;
	        var outer = 0;
	        while (iSize[i] === 1 && sSize[i] === 1) {
	          i++;
	        }
	        while (iSize[i] === 1) {
	          outer++;
	          i++;
	        }
	        // unsqueeze both outer and inner dimensions
	        submatrix = array.unsqueeze(submatrix, iSize.length, outer, sSize);
	      }
	      
	      // check whether the size of the submatrix matches the index size
	      if (!object.deepEqual(iSize, sSize)) {
	        throw new DimensionError(iSize, sSize, '>');
	      }
	      
	      // offsets
	      var x0 = index.min()[0];
	      var y0 = index.min()[1];      
	      
	      // submatrix rows and columns
	      var m = sSize[0];
	      var n = sSize[1];

	      // loop submatrix
	      for (var x = 0; x < m; x++) {
	        // loop columns
	        for (var y = 0; y < n; y++) {
	          // value at i, j
	          var v = submatrix[x][y];
	          // invoke set (zero value will remove entry from matrix)
	          matrix.set([x + x0, y + y0], v, defaultValue);
	        }
	      }
	    }
	    return matrix;
	  };

	  /**
	   * Get a single element from the matrix.
	   * @param {number[]} index   Zero-based index
	   * @return {*} value
	   */
	  SparseMatrix.prototype.get = function (index) {
	    if (!isArray(index))
	      throw new TypeError('Array expected');
	    if (index.length != this._size.length)
	      throw new DimensionError(index.length, this._size.length);

	    // check it is a pattern matrix
	    if (!this._values)
	      throw new Error('Cannot invoke get on a Pattern only matrix');

	    // row and column
	    var i = index[0];
	    var j = index[1];

	    // check i, j are valid
	    validateIndex(i, this._size[0]);
	    validateIndex(j, this._size[1]);

	    // find value index
	    var k = _getValueIndex(i, this._ptr[j], this._ptr[j + 1], this._index);
	    // check k is prior to next column k and it is in the correct row
	    if (k < this._ptr[j + 1] && this._index[k] === i)
	      return object.clone(this._values[k]);

	    return 0;
	  };
	  
	  /**
	   * Replace a single element in the matrix.
	   * @param {number[]} index   Zero-based index
	   * @param {*} value
	   * @param {*} [defaultValue]        Default value, filled in on new entries when
	   *                                  the matrix is resized. If not provided,
	   *                                  new matrix elements will be set to zero.
	   * @return {SparseMatrix} self
	   */
	  SparseMatrix.prototype.set = function (index, v, defaultValue) {
	    if (!isArray(index))
	      throw new TypeError('Array expected');
	    if (index.length != this._size.length)
	      throw new DimensionError(index.length, this._size.length);

	    // check it is a pattern matrix
	    if (!this._values)
	      throw new Error('Cannot invoke set on a Pattern only matrix');
	      
	    // row and column
	    var i = index[0];
	    var j = index[1];

	    // rows & columns
	    var rows = this._size[0];
	    var columns = this._size[1];
	    
	    // equal signature to use
	    var eq = equalScalar;
	    // zero value
	    var zero = 0;

	    if (isString(this._datatype)) {
	      // find signature that matches (datatype, datatype)
	      eq = typed.find(equalScalar, [this._datatype, this._datatype]) || equalScalar;
	      // convert 0 to the same datatype
	      zero = typed.convert(0, this._datatype);
	    }

	    // check we need to resize matrix
	    if (i > rows - 1 || j > columns - 1) {
	      // resize matrix
	      _resize(this, Math.max(i + 1, rows), Math.max(j + 1, columns), defaultValue);
	      // update rows & columns
	      rows = this._size[0];
	      columns = this._size[1];
	    }

	    // check i, j are valid
	    validateIndex(i, rows);
	    validateIndex(j, columns);

	    // find value index
	    var k = _getValueIndex(i, this._ptr[j], this._ptr[j + 1], this._index);
	    // check k is prior to next column k and it is in the correct row
	    if (k < this._ptr[j + 1] && this._index[k] === i) {
	      // check value != 0
	      if (!eq(v, zero)) {
	        // update value
	        this._values[k] = v;
	      }
	      else {
	        // remove value from matrix
	        _remove(k, j, this._values, this._index, this._ptr);
	      }
	    }
	    else {
	      // insert value @ (i, j)
	      _insert(k, i, j, v, this._values, this._index, this._ptr);
	    }

	    return this;
	  };
	  
	  var _getValueIndex = function(i, top, bottom, index) {
	    // check row is on the bottom side
	    if (bottom - top === 0 || i > index[bottom - 1])
	      return bottom;
	    // loop until we find row index
	    while (top < bottom) {
	      // point in the middle (fast integer division)
	      var p = ~~((top + bottom) / 2);
	      // row @ p
	      var r = index[p];
	      // check we have to look on the top side, bottom side or we found the row
	      if (i < r)
	        bottom = p;
	      else if (i > r)
	        top = p + 1;
	      else
	        return p;
	    }
	    return top;
	  };

	  var _remove = function (k, j, values, index, ptr) {
	    // remove value @ k
	    values.splice(k, 1);
	    index.splice(k, 1);
	    // update pointers
	    for (var x = j + 1; x < ptr.length; x++)
	      ptr[x]--;
	  };

	  var _insert = function (k, i, j, v, values, index, ptr) {
	    // insert value
	    values.splice(k, 0, v);
	    // update row for k
	    index.splice(k, 0, i);
	    // update column pointers
	    for (var x = j + 1; x < ptr.length; x++)
	      ptr[x]++;
	  };
	  
	  /**
	   * Resize the matrix to the given size. Returns a copy of the matrix when 
	   * `copy=true`, otherwise return the matrix itself (resize in place).
	   *
	   * @param {number[]} size           The new size the matrix should have.
	   * @param {*} [defaultValue=0]      Default value, filled in on new entries.
	   *                                  If not provided, the matrix elements will
	   *                                  be filled with zeros.
	   * @param {boolean} [copy]          Return a resized copy of the matrix
	   *
	   * @return {Matrix}                 The resized matrix
	   */
	  SparseMatrix.prototype.resize = function (size, defaultValue, copy) {    
	    // validate arguments
	    if (!isArray(size))
	      throw new TypeError('Array expected');
	    if (size.length !== 2)
	      throw new Error('Only two dimensions matrix are supported');

	    // check sizes
	    size.forEach(function (value) {
	      if (!number.isNumber(value) || !number.isInteger(value) || value < 0) {
	        throw new TypeError('Invalid size, must contain positive integers ' +
	                            '(size: ' + string.format(size) + ')');
	      }
	    });
	    
	    // matrix to resize
	    var m = copy ? this.clone() : this;
	    // resize matrix
	    return _resize(m, size[0], size[1], defaultValue);
	  };
	  
	  var _resize = function (matrix, rows, columns, defaultValue) {
	    // value to insert at the time of growing matrix
	    var value = defaultValue || 0;
	    
	    // equal signature to use
	    var eq = equalScalar;
	    // zero value
	    var zero = 0;

	    if (isString(matrix._datatype)) {
	      // find signature that matches (datatype, datatype)
	      eq = typed.find(equalScalar, [matrix._datatype, matrix._datatype]) || equalScalar;
	      // convert 0 to the same datatype
	      zero = typed.convert(0, matrix._datatype);
	      // convert value to the same datatype
	      value = typed.convert(value, matrix._datatype);
	    }
	    
	    // should we insert the value?
	    var ins = !eq(value, zero);

	    // old columns and rows
	    var r = matrix._size[0];
	    var c = matrix._size[1];

	    var i, j, k;

	    // check we need to increase columns
	    if (columns > c) {
	      // loop new columns
	      for (j = c; j < columns; j++) {
	        // update matrix._ptr for current column
	        matrix._ptr[j] = matrix._values.length;
	        // check we need to insert matrix._values
	        if (ins) {
	          // loop rows
	          for (i = 0; i < r; i++) {
	            // add new matrix._values
	            matrix._values.push(value);
	            // update matrix._index
	            matrix._index.push(i);
	          }
	        }        
	      }
	      // store number of matrix._values in matrix._ptr
	      matrix._ptr[columns] = matrix._values.length;
	    }
	    else if (columns < c) {
	      // truncate matrix._ptr
	      matrix._ptr.splice(columns + 1, c - columns);
	      // truncate matrix._values and matrix._index
	      matrix._values.splice(matrix._ptr[columns], matrix._values.length);
	      matrix._index.splice(matrix._ptr[columns], matrix._index.length);
	    }
	    // update columns
	    c = columns;

	    // check we need to increase rows
	    if (rows > r) {
	      // check we have to insert values
	      if (ins) {
	        // inserts
	        var n = 0;
	        // loop columns
	        for (j = 0; j < c; j++) {
	          // update matrix._ptr for current column
	          matrix._ptr[j] = matrix._ptr[j] + n;
	          // where to insert matrix._values
	          k = matrix._ptr[j + 1] + n;
	          // pointer
	          var p = 0;
	          // loop new rows, initialize pointer
	          for (i = r; i < rows; i++, p++) {
	            // add value
	            matrix._values.splice(k + p, 0, value);
	            // update matrix._index
	            matrix._index.splice(k + p, 0, i);
	            // increment inserts
	            n++;
	          }
	        }
	        // store number of matrix._values in matrix._ptr
	        matrix._ptr[c] = matrix._values.length;
	      }
	    }
	    else if (rows < r) {
	      // deletes
	      var d = 0;
	      // loop columns
	      for (j = 0; j < c; j++) {
	        // update matrix._ptr for current column
	        matrix._ptr[j] = matrix._ptr[j] - d;
	        // where matrix._values start for next column
	        var k0 = matrix._ptr[j];
	        var k1 = matrix._ptr[j + 1] - d;
	        // loop matrix._index
	        for (k = k0; k < k1; k++) {
	          // row
	          i = matrix._index[k];
	          // check we need to delete value and matrix._index
	          if (i > rows - 1) {
	            // remove value
	            matrix._values.splice(k, 1);
	            // remove item from matrix._index
	            matrix._index.splice(k, 1);
	            // increase deletes
	            d++;
	          }
	        }
	      }
	      // update matrix._ptr for current column
	      matrix._ptr[j] = matrix._values.length;
	    }
	    // update matrix._size
	    matrix._size[0] = rows;
	    matrix._size[1] = columns;
	    // return matrix
	    return matrix;
	  };
	  
	  /**
	   * Create a clone of the matrix
	   * @return {SparseMatrix} clone
	   */
	  SparseMatrix.prototype.clone = function () {
	    var m = new SparseMatrix({
	      values: this._values ? object.clone(this._values) : undefined,
	      index: object.clone(this._index),
	      ptr: object.clone(this._ptr),
	      size: object.clone(this._size),
	      datatype: this._datatype
	    });
	    return m;
	  };
	  
	  /**
	   * Retrieve the size of the matrix.
	   * @returns {number[]} size
	   */
	  SparseMatrix.prototype.size = function() {
	    return object.clone(this._size);
	  };
	  
	  /**
	   * Create a new matrix with the results of the callback function executed on
	   * each entry of the matrix.
	   * @param {Function} callback   The callback function is invoked with three
	   *                              parameters: the value of the element, the index
	   *                              of the element, and the Matrix being traversed.
	   * @param {boolean} [skipZeros] Invoke callback function for non-zero values only.
	   *
	   * @return {SparseMatrix} matrix
	   */
	  SparseMatrix.prototype.map = function (callback, skipZeros) {
	    // check it is a pattern matrix
	    if (!this._values)
	      throw new Error('Cannot invoke map on a Pattern only matrix');
	    // matrix instance
	    var me = this;
	    // rows and columns
	    var rows = this._size[0];
	    var columns = this._size[1];
	    // invoke callback
	    var invoke = function (v, i, j) {
	      // invoke callback
	      return callback(v, [i, j], me);
	    };
	    // invoke _map
	    return _map(this, 0, rows - 1, 0, columns - 1, invoke, skipZeros);
	  };

	  /**
	   * Create a new matrix with the results of the callback function executed on the interval
	   * [minRow..maxRow, minColumn..maxColumn].
	   */
	  var _map = function (matrix, minRow, maxRow, minColumn, maxColumn, callback, skipZeros) {
	    // result arrays
	    var values = [];
	    var index = [];
	    var ptr = [];
	    
	    // equal signature to use
	    var eq = equalScalar;
	    // zero value
	    var zero = 0;

	    if (isString(matrix._datatype)) {
	      // find signature that matches (datatype, datatype)
	      eq = typed.find(equalScalar, [matrix._datatype, matrix._datatype]) || equalScalar;
	      // convert 0 to the same datatype
	      zero = typed.convert(0, matrix._datatype);
	    }
	    
	    // invoke callback
	    var invoke = function (v, x, y) {
	      // invoke callback
	      v = callback(v, x, y);
	      // check value != 0
	      if (!eq(v, zero)) {
	        // store value
	        values.push(v);
	        // index
	        index.push(x);
	      }
	    };
	    // loop columns
	    for (var j = minColumn; j <= maxColumn; j++) {
	      // store pointer to values index
	      ptr.push(values.length);
	      // k0 <= k < k1 where k0 = _ptr[j] && k1 = _ptr[j+1]
	      var k0 = matrix._ptr[j];
	      var k1 = matrix._ptr[j + 1];
	      // row pointer
	      var p = minRow;
	      // loop k within [k0, k1[
	      for (var k = k0; k < k1; k++) {
	        // row index
	        var i = matrix._index[k];
	        // check i is in range
	        if (i >= minRow && i <= maxRow) {
	          // zero values
	          if (!skipZeros) {
	           for (var x = p; x < i; x++)
	             invoke(0, x - minRow, j - minColumn);
	          }
	          // value @ k
	          invoke(matrix._values[k], i - minRow, j - minColumn);
	        }
	        // update pointer
	        p = i + 1;
	      }
	      // zero values
	      if (!skipZeros) {
	        for (var y = p; y <= maxRow; y++)
	          invoke(0, y - minRow, j - minColumn);
	      }
	    }
	    // store number of values in ptr
	    ptr.push(values.length);
	    // return sparse matrix
	    return new SparseMatrix({
	      values: values,
	      index: index,
	      ptr: ptr,
	      size: [maxRow - minRow + 1, maxColumn - minColumn + 1]
	    });
	  };
	  
	  /**
	   * Execute a callback function on each entry of the matrix.
	   * @param {Function} callback   The callback function is invoked with three
	   *                              parameters: the value of the element, the index
	   *                              of the element, and the Matrix being traversed.
	   * @param {boolean} [skipZeros] Invoke callback function for non-zero values only.
	   */
	  SparseMatrix.prototype.forEach = function (callback, skipZeros) {
	    // check it is a pattern matrix
	    if (!this._values)
	      throw new Error('Cannot invoke forEach on a Pattern only matrix');
	    // matrix instance
	    var me = this;
	    // rows and columns
	    var rows = this._size[0];
	    var columns = this._size[1];
	    // loop columns
	    for (var j = 0; j < columns; j++) {
	      // k0 <= k < k1 where k0 = _ptr[j] && k1 = _ptr[j+1]
	      var k0 = this._ptr[j];
	      var k1 = this._ptr[j + 1];
	      // column pointer
	      var p = 0;
	      // loop k within [k0, k1[
	      for (var k = k0; k < k1; k++) {
	        // row index
	        var i = this._index[k];
	        // check we need to process zeros
	        if (!skipZeros) {
	          // zero values
	          for (var x = p; x < i; x++)
	            callback(0, [x, j], me);
	        }
	        // value @ k
	        callback(this._values[k], [i, j], me);
	        // update pointer
	        p = i + 1;
	      }
	      // check we need to process zeros
	      if (!skipZeros) {
	        // zero values
	        for (var y = p; y < rows; y++)
	          callback(0, [y, j], me);
	      }
	    }
	  };
	  
	  /**
	   * Create an Array with a copy of the data of the SparseMatrix
	   * @returns {Array} array
	   */
	  SparseMatrix.prototype.toArray = function () {
	    return _toArray(this._values, this._index, this._ptr, this._size, true);
	  };

	  /**
	   * Get the primitive value of the SparseMatrix: a two dimensions array
	   * @returns {Array} array
	   */
	  SparseMatrix.prototype.valueOf = function () {
	    return _toArray(this._values, this._index, this._ptr, this._size, false);
	  };
	  
	  var _toArray = function (values, index, ptr, size, copy) {    
	    // rows and columns
	    var rows = size[0];
	    var columns = size[1];
	    // result
	    var a = [];
	    // vars
	    var i, j;
	    // initialize array
	    for (i = 0; i < rows; i++) {
	      a[i] = [];
	      for (j = 0; j < columns; j++)
	        a[i][j] = 0;
	    }

	    // loop columns
	    for (j = 0; j < columns; j++) {
	      // k0 <= k < k1 where k0 = _ptr[j] && k1 = _ptr[j+1]
	      var k0 = ptr[j];
	      var k1 = ptr[j + 1];
	      // loop k within [k0, k1[
	      for (var k = k0; k < k1; k++) {
	        // row index
	        i = index[k];
	        // set value (use one for pattern matrix)
	        a[i][j] = values ? (copy ? object.clone(values[k]) : values[k]) : 1;
	      }
	    }
	    return a;
	  };
	  
	  /**
	   * Get a string representation of the matrix, with optional formatting options.
	   * @param {Object | number | Function} [options]  Formatting options. See
	   *                                                lib/utils/number:format for a
	   *                                                description of the available
	   *                                                options.
	   * @returns {string} str
	   */
	  SparseMatrix.prototype.format = function (options) {
	    // rows and columns
	    var rows = this._size[0];
	    var columns = this._size[1];
	    // density
	    var density = this.density();
	    // rows & columns
	    var str = 'Sparse Matrix [' + string.format(rows, options) + ' x ' + string.format(columns, options) + '] density: ' + string.format(density, options) + '\n';
	    // loop columns
	    for (var j = 0; j < columns; j++) {
	      // k0 <= k < k1 where k0 = _ptr[j] && k1 = _ptr[j+1]
	      var k0 = this._ptr[j];
	      var k1 = this._ptr[j + 1];
	      // loop k within [k0, k1[
	      for (var k = k0; k < k1; k++) {
	        // row index
	        var i = this._index[k];
	        // append value
	        str += '\n    (' + string.format(i, options) + ', ' + string.format(j, options) + ') ==> ' + (this._values ? string.format(this._values[k], options) : 'X');
	      }
	    }
	    return str;
	  };
	  
	  /**
	   * Get a string representation of the matrix
	   * @returns {string} str
	   */
	  SparseMatrix.prototype.toString = function () {
	    return string.format(this.toArray());
	  };
	  
	  /**
	   * Get a JSON representation of the matrix
	   * @returns {Object}
	   */
	  SparseMatrix.prototype.toJSON = function () {
	    return {
	      mathjs: 'SparseMatrix',
	      values: this._values,
	      index: this._index,
	      ptr: this._ptr,
	      size: this._size,
	      datatype: this._datatype
	    };
	  };

	  /**
	   * Get the kth Matrix diagonal.
	   *
	   * @param {number | BigNumber} [k=0]     The kth diagonal where the vector will retrieved.
	   *
	   * @returns {Matrix}                     The matrix vector with the diagonal values.
	   */
	  SparseMatrix.prototype.diagonal = function(k) {
	    // validate k if any
	    if (k) {
	      // convert BigNumber to a number
	      if (k.isBigNumber === true)
	        k = k.toNumber();
	      // is must be an integer
	      if (!isNumber(k) || !isInteger(k)) {
	        throw new TypeError ('The parameter k must be an integer number');
	      }
	    }
	    else {
	      // default value
	      k = 0;
	    }

	    var kSuper = k > 0 ? k : 0;
	    var kSub = k < 0 ? -k : 0;
	    
	    // rows & columns
	    var rows = this._size[0];
	    var columns = this._size[1];
	    
	    // number diagonal values
	    var n = Math.min(rows - kSub, columns -  kSuper);
	    
	    // diagonal arrays
	    var values = [];
	    var index = [];
	    var ptr = [];
	    // initial ptr value
	    ptr[0] = 0;
	    // loop columns
	    for (var j = kSuper; j < columns && values.length < n; j++) {
	      // k0 <= k < k1 where k0 = _ptr[j] && k1 = _ptr[j+1]
	      var k0 = this._ptr[j];
	      var k1 = this._ptr[j + 1];
	      // loop x within [k0, k1[
	      for (var x = k0; x < k1; x++) {
	        // row index
	        var i = this._index[x];
	        // check row
	        if (i === j - kSuper + kSub) {
	          // value on this column
	          values.push(object.clone(this._values[x]));
	          // store row
	          index[values.length - 1] = i - kSub;
	          // exit loop
	          break;
	        }
	      }
	    }
	    // close ptr
	    ptr.push(values.length);
	    // return matrix
	    return new SparseMatrix({
	      values: values,
	      index: index,
	      ptr: ptr,
	      size: [n, 1]
	    });
	  };
	  
	  /**
	   * Generate a matrix from a JSON object
	   * @param {Object} json  An object structured like
	   *                       `{"mathjs": "SparseMatrix", "values": [], "index": [], "ptr": [], "size": []}`,
	   *                       where mathjs is optional
	   * @returns {SparseMatrix}
	   */
	  SparseMatrix.fromJSON = function (json) {
	    return new SparseMatrix(json);
	  };

	  /**
	   * Create a diagonal matrix.
	   *
	   * @param {Array} size                       The matrix size.
	   * @param {number | Array | Matrix } value   The values for the diagonal.
	   * @param {number | BigNumber} [k=0]         The kth diagonal where the vector will be filled in.
	   * @param {string} [datatype]                The Matrix datatype, values must be of this datatype.
	   *
	   * @returns {SparseMatrix}
	   */
	  SparseMatrix.diagonal = function (size, value, k, defaultValue, datatype) {
	    if (!isArray(size))
	      throw new TypeError('Array expected, size parameter');
	    if (size.length !== 2)
	      throw new Error('Only two dimensions matrix are supported');
	    
	    // map size & validate
	    size = size.map(function (s) {
	      // check it is a big number
	      if (s && s.isBigNumber === true) {
	        // convert it
	        s = s.toNumber();
	      }
	      // validate arguments
	      if (!isNumber(s) || !isInteger(s) || s < 1) {
	        throw new Error('Size values must be positive integers');
	      } 
	      return s;
	    });
	    
	    // validate k if any
	    if (k) {
	      // convert BigNumber to a number
	      if (k.isBigNumber === true)
	        k = k.toNumber();
	      // is must be an integer
	      if (!isNumber(k) || !isInteger(k)) {
	        throw new TypeError ('The parameter k must be an integer number');
	      }
	    }
	    else {
	      // default value
	      k = 0;
	    }

	    // equal signature to use
	    var eq = equalScalar;
	    // zero value
	    var zero = 0;

	    if (isString(datatype)) {
	      // find signature that matches (datatype, datatype)
	      eq = typed.find(equalScalar, [datatype, datatype]) || equalScalar;
	      // convert 0 to the same datatype
	      zero = typed.convert(0, datatype);
	    }
	    
	    var kSuper = k > 0 ? k : 0;
	    var kSub = k < 0 ? -k : 0;
	    
	    // rows and columns
	    var rows = size[0];
	    var columns = size[1];
	    
	    // number of non-zero items
	    var n = Math.min(rows - kSub, columns -  kSuper);
	    
	    // value extraction function
	    var _value;
	      
	    // check value
	    if (isArray(value)) {
	      // validate array
	      if (value.length !== n) {
	        // number of values in array must be n
	        throw new Error('Invalid value array length');
	      }
	      // define function
	      _value = function (i) {
	        // return value @ i
	        return value[i];
	      };
	    }
	    else if (value && value.isMatrix === true) {
	      // matrix size
	      var ms = value.size();
	      // validate matrix
	      if (ms.length !== 1 || ms[0] !== n) {
	        // number of values in array must be n
	        throw new Error('Invalid matrix length');
	      }
	      // define function
	      _value = function (i) {
	        // return value @ i
	        return value.get([i]);
	      };
	    }
	    else {
	      // define function
	      _value = function () {
	        // return value
	        return value;
	      };
	    }
	    
	    // create arrays
	    var values = [];
	    var index = [];
	    var ptr = [];
	    
	    // loop items
	    for (var j = 0; j < columns; j++) {
	      // number of rows with value
	      ptr.push(values.length);
	      // diagonal index
	      var i = j - kSuper;      
	      // check we need to set diagonal value
	      if (i >= 0 && i < n) {
	        // get value @ i
	        var v = _value(i);
	        // check for zero
	        if (!eq(v, zero)) {
	          // column
	          index.push(i + kSub);
	          // add value
	          values.push(v);
	        }
	      }
	    }
	    // last value should be number of values
	    ptr.push(values.length);
	    // create SparseMatrix
	    return new SparseMatrix({
	      values: values,
	      index: index,
	      ptr: ptr,
	      size: [rows, columns]
	    });
	  };
	  
	  /**
	   * Swap rows i and j in Matrix.
	   *
	   * @param {number} i       Matrix row index 1
	   * @param {number} j       Matrix row index 2
	   *
	   * @return {Matrix}        The matrix reference
	   */
	  SparseMatrix.prototype.swapRows = function (i, j) {
	    // check index
	    if (!isNumber(i) || !isInteger(i) || !isNumber(j) || !isInteger(j)) {
	      throw new Error('Row index must be positive integers');
	    }
	    // check dimensions
	    if (this._size.length !== 2) {
	      throw new Error('Only two dimensional matrix is supported');
	    }
	    // validate index
	    validateIndex(i, this._size[0]);
	    validateIndex(j, this._size[0]);
	    
	    // swap rows
	    SparseMatrix._swapRows(i, j, this._size[1], this._values, this._index, this._ptr);
	    // return current instance
	    return this;
	  };
	  
	  /**
	   * Loop rows with data in column j.
	   *
	   * @param {number} j            Column
	   * @param {Array} values        Matrix values
	   * @param {Array} index         Matrix row indeces
	   * @param {Array} ptr           Matrix column pointers
	   * @param {Function} callback   Callback function invoked for every row in column j
	   */
	  SparseMatrix._forEachRow = function (j, values, index, ptr, callback) {
	    // indeces for column j
	    var k0 = ptr[j];
	    var k1 = ptr[j + 1];
	    // loop
	    for (var k = k0; k < k1; k++) {
	      // invoke callback
	      callback(index[k], values[k]);
	    }
	  };
	  
	  /**
	   * Swap rows x and y in Sparse Matrix data structures.
	   *
	   * @param {number} x         Matrix row index 1
	   * @param {number} y         Matrix row index 2
	   * @param {number} columns   Number of columns in matrix
	   * @param {Array} values     Matrix values
	   * @param {Array} index      Matrix row indeces
	   * @param {Array} ptr        Matrix column pointers
	   */
	  SparseMatrix._swapRows = function (x, y, columns, values, index, ptr) {
	    // loop columns
	    for (var j = 0; j < columns; j++) {
	      // k0 <= k < k1 where k0 = _ptr[j] && k1 = _ptr[j+1]
	      var k0 = ptr[j];
	      var k1 = ptr[j + 1];
	      // find value index @ x
	      var kx = _getValueIndex(x, k0, k1, index);
	      // find value index @ x
	      var ky = _getValueIndex(y, k0, k1, index);
	      // check both rows exist in matrix
	      if (kx < k1 && ky < k1 && index[kx] === x && index[ky] === y) {
	        // swap values (check for pattern matrix)
	        if (values) {
	          var v = values[kx];
	          values[kx] = values[ky];
	          values[ky] = v;
	        }
	        // next column
	        continue;
	      }
	      // check x row exist & no y row
	      if (kx < k1 && index[kx] === x && (ky >= k1 || index[ky] !== y)) {
	        // value @ x (check for pattern matrix)
	        var vx = values ? values[kx] : undefined;
	        // insert value @ y
	        index.splice(ky, 0, y);
	        if (values)
	          values.splice(ky, 0, vx);        
	        // remove value @ x (adjust array index if needed)
	        index.splice(ky <= kx ? kx + 1 : kx, 1);
	        if (values)
	          values.splice(ky <= kx ? kx + 1 : kx, 1);
	        // next column
	        continue;
	      }
	      // check y row exist & no x row
	      if (ky < k1 && index[ky] === y && (kx >= k1 || index[kx] !== x)) {
	        // value @ y (check for pattern matrix)
	        var vy = values ? values[ky] : undefined;
	        // insert value @ x
	        index.splice(kx, 0, x);
	        if (values)
	          values.splice(kx, 0, vy);
	        // remove value @ y (adjust array index if needed)
	        index.splice(kx <= ky ? ky + 1 : ky, 1);
	        if (values)
	          values.splice(kx <= ky ? ky + 1 : ky, 1);
	      }
	    }
	  };

	  // register this type in the base class Matrix
	  type.Matrix._storage.sparse = SparseMatrix;

	  return SparseMatrix;
	}

	exports.name = 'SparseMatrix';
	exports.path = 'type';
	exports.factory = factory;
	exports.lazy = false;  // no lazy loading, as we alter type.Matrix._storage


/***/ },
/* 246 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	function factory (type, config, load) {
	  
	  var add = load(__webpack_require__(44));
	  var equalScalar = load(__webpack_require__(33));
	  
	  /**
	   * An ordered Sparse Accumulator is a representation for a sparse vector that includes a dense array 
	   * of the vector elements and an ordered list of non-zero elements.
	   */
	  function Spa() {
	    if (!(this instanceof Spa))
	      throw new SyntaxError('Constructor must be called with the new operator');
	    
	    // allocate vector, TODO use typed arrays
	    this._values = [];
	    this._heap = new type.FibonacciHeap();
	  }

	  /**
	   * Attach type information
	   */
	  Spa.prototype.type = 'Spa';
	  Spa.prototype.isSpa = true;

	  /**
	   * Set the value for index i.
	   *
	   * @param {number} i                       The index
	   * @param {number | BigNumber | Complex}   The value at index i
	   */
	  Spa.prototype.set = function (i, v) {
	    // check we have a value @ i
	    if (!this._values[i]) {
	      // insert in heap
	      var node = this._heap.insert(i, v);
	      // set the value @ i
	      this._values[i] = node;
	    }
	    else {
	      // update the value @ i
	      this._values[i].value = v;
	    }
	  };
	  
	  Spa.prototype.get = function (i) {
	    var node = this._values[i];
	    if (node)
	      return node.value;
	    return 0;
	  };
	  
	  Spa.prototype.accumulate = function (i, v) {
	    // node @ i
	    var node = this._values[i];
	    if (!node) {
	      // insert in heap
	      node = this._heap.insert(i, v);
	      // initialize value
	      this._values[i] = node;
	    }
	    else {
	      // accumulate value
	      node.value = add(node.value, v);
	    }
	  };
	  
	  Spa.prototype.forEach = function (from, to, callback) {
	    // references
	    var heap = this._heap;
	    var values = this._values;
	    // nodes
	    var nodes = [];
	    // node with minimum key, save it
	    var node = heap.extractMinimum();
	    if (node)
	      nodes.push(node);
	    // extract nodes from heap (ordered)
	    while (node && node.key <= to) {
	      // check it is in range
	      if (node.key >= from) {
	        // check value is not zero
	        if (!equalScalar(node.value, 0)) {
	          // invoke callback
	          callback(node.key, node.value, this);
	        }
	      }
	      // extract next node, save it
	      node = heap.extractMinimum();
	      if (node)
	        nodes.push(node);
	    }
	    // reinsert all nodes in heap
	    for (var i = 0; i < nodes.length; i++) {
	      // current node
	      var n = nodes[i];
	      // insert node in heap
	      node = heap.insert(n.key, n.value);
	      // update values
	      values[node.key] = node;
	    }
	  };
	  
	  Spa.prototype.swap = function (i, j) {
	    // node @ i and j
	    var nodei = this._values[i];
	    var nodej = this._values[j];
	    // check we need to insert indeces
	    if (!nodei && nodej) {
	      // insert in heap
	      nodei = this._heap.insert(i, nodej.value);
	      // remove from heap
	      this._heap.remove(nodej);
	      // set values
	      this._values[i] = nodei;
	      this._values[j] = undefined;
	    }
	    else if (nodei && !nodej) {
	      // insert in heap
	      nodej = this._heap.insert(j, nodei.value);
	      // remove from heap
	      this._heap.remove(nodei);
	      // set values
	      this._values[j] = nodej;
	      this._values[i] = undefined;
	    }
	    else if (nodei && nodej) {
	      // swap values
	      var v = nodei.value;
	      nodei.value = nodej.value;
	      nodej.value = v;
	    }
	  };
	  
	  return Spa;
	}

	exports.name = 'Spa';
	exports.path = 'type';
	exports.factory = factory;


/***/ },
/* 247 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	function factory (type, config, load, typed) {
	  
	  var smaller = load(__webpack_require__(113));
	  var larger = load(__webpack_require__(64));
	  
	  var oneOverLogPhi = 1.0 / Math.log((1.0 + Math.sqrt(5.0)) / 2.0);
	  
	  function FibonacciHeap() {
	    if (!(this instanceof FibonacciHeap))
	      throw new SyntaxError('Constructor must be called with the new operator');

	    // initialize fields
	    this._minimum = null;
	    this._size = 0;
	  }

	  /**
	   * Attach type information
	   */
	  FibonacciHeap.prototype.type = 'FibonacciHeap';
	  FibonacciHeap.prototype.isFibonacciHeap = true;

	  /**
	   * Inserts a new data element into the heap. No heap consolidation is
	   * performed at this time, the new node is simply inserted into the root
	   * list of this heap. Running time: O(1) actual.
	   */
	  FibonacciHeap.prototype.insert = function (key, value) {
	    // create node
	    var node = {
	      key: key,
	      value: value,
	      degree: 0
	    };
	    // check we have a node in the minimum
	    if (this._minimum) {
	      // minimum node
	      var minimum = this._minimum;
	      // update left & right of node
	      node.left = minimum;
	      node.right = minimum.right;
	      minimum.right = node;
	      node.right.left = node;
	      // update minimum node in heap if needed
	      if (smaller(key, minimum.key)) {
	        // node has a smaller key, use it as minimum
	        this._minimum = node;
	      }
	    }
	    else {
	      // set left & right
	      node.left = node;
	      node.right = node;
	      // this is the first node
	      this._minimum = node;
	    }
	    // increment number of nodes in heap
	    this._size++;
	    // return node
	    return node;
	  };

	  /**
	   * Returns the number of nodes in heap. Running time: O(1) actual.
	   */
	  FibonacciHeap.prototype.size = function () {
	    return this._size;
	  };

	  /**
	   * Removes all elements from this heap.
	   */
	  FibonacciHeap.prototype.clear = function () {
	    this._minimum = null;
	    this._size = 0;
	  };

	  /**
	   * Returns true if the heap is empty, otherwise false.
	   */
	  FibonacciHeap.prototype.isEmpty = function () {
	    return !!this._minimum;
	  };
	  
	  /**
	   * Extracts the node with minimum key from heap. Amortized running 
	   * time: O(log n).
	   */
	  FibonacciHeap.prototype.extractMinimum = function () {
	    // node to remove
	    var node = this._minimum;
	    // check we have a minimum
	    if (node === null)
	      return node;
	    // current minimum
	    var minimum = this._minimum;
	    // get number of children
	    var numberOfChildren = node.degree;
	    // pointer to the first child
	    var x = node.child;
	    // for each child of node do...
	    while (numberOfChildren > 0) {
	      // store node in right side
	      var tempRight = x.right;
	      // remove x from child list
	      x.left.right = x.right;
	      x.right.left = x.left;
	      // add x to root list of heap
	      x.left = minimum;
	      x.right = minimum.right;
	      minimum.right = x;
	      x.right.left = x;
	      // set Parent[x] to null
	      x.parent = null;
	      x = tempRight;
	      numberOfChildren--;
	    }
	    // remove node from root list of heap
	    node.left.right = node.right;
	    node.right.left = node.left;
	    // update minimum
	    if (node == node.right) {
	      // empty
	      minimum = null;
	    }
	    else {
	      // update minimum
	      minimum = node.right;
	      // we need to update the pointer to the root with minimum key
	      minimum = _findMinimumNode(minimum, this._size);
	    }
	    // decrement size of heap
	    this._size--;
	    // update minimum
	    this._minimum = minimum;
	    // return node
	    return node;
	  };
	  
	  /**
	   * Removes a node from the heap given the reference to the node. The trees
	   * in the heap will be consolidated, if necessary. This operation may fail
	   * to remove the correct element if there are nodes with key value -Infinity.
	   * Running time: O(log n) amortized.
	   */
	  FibonacciHeap.prototype.remove = function (node) {
	    // decrease key value
	    this._minimum = _decreaseKey(this._minimum, node, null);
	    // remove the smallest
	    this.extractMinimum();
	  };
	  
	  /**
	   * Decreases the key value for a heap node, given the new value to take on.
	   * The structure of the heap may be changed and will not be consolidated. 
	   * Running time: O(1) amortized.
	   */
	  var _decreaseKey = function (minimum, node, key) {
	    // set node key
	    node.key = key;
	    // get parent node
	    var parent = node.parent;
	    if (parent && smaller(node.key, parent.key)) {
	      // remove node from parent
	      _cut(minimum, node, parent);
	      // remove all nodes from parent to the root parent
	      _cascadingCut(minimum, parent);
	    }
	    // update minimum node if needed
	    if (smaller(node.key, minimum.key))
	      minimum = node;
	    // return minimum
	    return minimum;
	  };
	  
	  /**
	   * The reverse of the link operation: removes node from the child list of parent.
	   * This method assumes that min is non-null. Running time: O(1).
	   */
	  var _cut = function (minimum, node, parent) {
	    // remove node from parent children and decrement Degree[parent]
	    node.left.right = node.right;
	    node.right.left = node.left;
	    parent.degree--;
	    // reset y.child if necessary
	    if (parent.child == node)
	      parent.child = node.right;
	    // remove child if degree is 0
	    if (parent.degree === 0)
	      parent.child = null;
	    // add node to root list of heap
	    node.left = minimum;
	    node.right = minimum.right;
	    minimum.right = node;
	    node.right.left = node;
	    // set parent[node] to null
	    node.parent = null;
	    // set mark[node] to false
	    node.mark = false;
	  };
	  
	  /**
	   * Performs a cascading cut operation. This cuts node from its parent and then
	   * does the same for its parent, and so on up the tree.
	   * Running time: O(log n); O(1) excluding the recursion.
	   */
	  var _cascadingCut= function (minimum, node) {
	    // store parent node
	    var parent = node.parent;
	    // if there's a parent...
	    if (!parent)
	      return;
	    // if node is unmarked, set it marked
	    if (!node.mark) {
	      node.mark = true;
	    }
	    else {
	      // it's marked, cut it from parent
	      _cut(minimum, node, parent);
	      // cut its parent as well
	      _cascadingCut(parent);
	    }
	  };
	  
	  /**
	   * Make the first node a child of the second one. Running time: O(1) actual.
	   */
	  var _linkNodes = function (node, parent) {
	    // remove node from root list of heap
	    node.left.right = node.right;
	    node.right.left = node.left;
	    // make node a Child of parent
	    node.parent = parent;
	    if (!parent.child) {
	      parent.child = node;
	      node.right = node;
	      node.left = node;
	    }
	    else {
	      node.left = parent.child;
	      node.right = parent.child.right;
	      parent.child.right = node;
	      node.right.left = node;
	    }
	    // increase degree[parent]
	    parent.degree++;
	    // set mark[node] false
	    node.mark = false;
	  };
	  
	  var _findMinimumNode = function (minimum, size) {
	    // to find trees of the same degree efficiently we use an array of length O(log n) in which we keep a pointer to one root of each degree
	    var arraySize = Math.floor(Math.log(size) * oneOverLogPhi) + 1;
	    // create list with initial capacity
	    var array = new Array(arraySize);
	    // find the number of root nodes.
	    var numRoots = 0;
	    var x = minimum;
	    if (x) {
	      numRoots++;
	      x = x.right;
	      while (x !== minimum) {
	        numRoots++;
	        x = x.right;
	      }
	    }
	    // vars
	    var y;
	    // For each node in root list do...
	    while (numRoots > 0) {
	      // access this node's degree..
	      var d = x.degree;
	      // get next node
	      var next = x.right;
	      // check if there is a node already in array with the same degree
	      while (true) {
	        // get node with the same degree is any
	        y = array[d];
	        if (!y)
	          break;
	        // make one node with the same degree a child of the other, do this based on the key value.
	        if (larger(x.key, y.key)) {
	          var temp = y;
	          y = x;
	          x = temp;
	        }
	        // make y a child of x
	        _linkNodes(y, x);
	        // we have handled this degree, go to next one.
	        array[d] = null;
	        d++;
	      }
	      // save this node for later when we might encounter another of the same degree.
	      array[d] = x;
	      // move forward through list.
	      x = next;
	      numRoots--;
	    }
	    // Set min to null (effectively losing the root list) and reconstruct the root list from the array entries in array[].
	    minimum = null;
	    // loop nodes in array
	    for (var i = 0; i < arraySize; i++) {
	      // get current node
	      y = array[i];
	      if (!y)
	        continue;
	      // check if we have a linked list
	      if (minimum) {
	        // First remove node from root list.
	        y.left.right = y.right;
	        y.right.left = y.left;
	        // now add to root list, again.
	        y.left = minimum;
	        y.right = minimum.right;
	        minimum.right = y;
	        y.right.left = y;
	        // check if this is a new min.
	        if (smaller(y.key, minimum.key))
	          minimum = y;
	      }
	      else
	        minimum = y;
	    }
	    return minimum;
	  };
	  
	  return FibonacciHeap;
	}

	exports.name = 'FibonacciHeap';
	exports.path = 'type';
	exports.factory = factory;


/***/ },
/* 248 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var util = __webpack_require__(36);

	var string = util.string;
	var object = util.object;

	var isArray = Array.isArray;
	var isString = string.isString;

	function factory (type, config, load) {

	  var DenseMatrix = load(__webpack_require__(244));

	  var smaller = load(__webpack_require__(113));

	  function ImmutableDenseMatrix(data, datatype) {
	    if (!(this instanceof ImmutableDenseMatrix))
	      throw new SyntaxError('Constructor must be called with the new operator');
	    if (datatype && !isString(datatype))
	      throw new Error('Invalid datatype: ' + datatype);

	    if ((data && data.isMatrix === true) || isArray(data)) {
	      // use DenseMatrix implementation
	      var matrix = new DenseMatrix(data, datatype);
	      // internal structures
	      this._data = matrix._data;
	      this._size = matrix._size;
	      this._datatype = matrix._datatype;
	      this._min = null;
	      this._max = null;
	    }
	    else if (data && isArray(data.data) && isArray(data.size)) {
	      // initialize fields from JSON representation
	      this._data = data.data;
	      this._size = data.size;
	      this._datatype = data.datatype;
	      this._min = typeof data.min !== 'undefined' ? data.min : null;
	      this._max = typeof data.max !== 'undefined' ? data.max : null;
	    }
	    else if (data) {
	      // unsupported type
	      throw new TypeError('Unsupported type of data (' + util.types.type(data) + ')');
	    }
	    else {
	      // nothing provided
	      this._data = [];
	      this._size = [0];
	      this._datatype = datatype;
	      this._min = null;
	      this._max = null;
	    }
	  }

	  ImmutableDenseMatrix.prototype = new DenseMatrix();

	  /**
	   * Attach type information
	   */
	  ImmutableDenseMatrix.prototype.type = 'ImmutableDenseMatrix';
	  ImmutableDenseMatrix.prototype.isImmutableDenseMatrix = true;

	  /**
	   * Get a subset of the matrix, or replace a subset of the matrix.
	   *
	   * Usage:
	   *     var subset = matrix.subset(index)               // retrieve subset
	   *     var value = matrix.subset(index, replacement)   // replace subset
	   *
	   * @param {Index} index
	   * @param {Array | ImmutableDenseMatrix | *} [replacement]
	   * @param {*} [defaultValue=0]      Default value, filled in on new entries when
	   *                                  the matrix is resized. If not provided,
	   *                                  new matrix elements will be filled with zeros.
	   */
	  ImmutableDenseMatrix.prototype.subset = function (index) {
	    switch (arguments.length) {
	      case 1:
	        // use base implementation
	        var m = DenseMatrix.prototype.subset.call(this, index);
	        // check result is a matrix
	        if (m.isMatrix) {
	          // return immutable matrix
	          return new ImmutableDenseMatrix({
	            data: m._data,
	            size: m._size,
	            datatype: m._datatype
	          });
	        }
	        return m;
	        
	        // intentional fall through
	      case 2:
	      case 3:
	        throw new Error('Cannot invoke set subset on an Immutable Matrix instance');

	      default:
	        throw new SyntaxError('Wrong number of arguments');
	    }
	  };

	  /**
	   * Replace a single element in the matrix.
	   * @param {Number[]} index   Zero-based index
	   * @param {*} value
	   * @param {*} [defaultValue]        Default value, filled in on new entries when
	   *                                  the matrix is resized. If not provided,
	   *                                  new matrix elements will be left undefined.
	   * @return {ImmutableDenseMatrix} self
	   */
	  ImmutableDenseMatrix.prototype.set = function () {
	    throw new Error('Cannot invoke set on an Immutable Matrix instance');
	  };

	  /**
	   * Resize the matrix to the given size. Returns a copy of the matrix when
	   * `copy=true`, otherwise return the matrix itself (resize in place).
	   *
	   * @param {Number[]} size           The new size the matrix should have.
	   * @param {*} [defaultValue=0]      Default value, filled in on new entries.
	   *                                  If not provided, the matrix elements will
	   *                                  be filled with zeros.
	   * @param {boolean} [copy]          Return a resized copy of the matrix
	   *
	   * @return {Matrix}                 The resized matrix
	   */
	  ImmutableDenseMatrix.prototype.resize = function () {
	    throw new Error('Cannot invoke resize on an Immutable Matrix instance');
	  };

	  /**
	   * Create a clone of the matrix
	   * @return {ImmutableDenseMatrix} clone
	   */
	  ImmutableDenseMatrix.prototype.clone = function () {
	    var m = new ImmutableDenseMatrix({
	      data: object.clone(this._data),
	      size: object.clone(this._size),
	      datatype: this._datatype
	    });
	    return m;
	  };

	  /**
	   * Get a JSON representation of the matrix
	   * @returns {Object}
	   */
	  ImmutableDenseMatrix.prototype.toJSON = function () {
	    return {
	      mathjs: 'ImmutableDenseMatrix',
	      data: this._data,
	      size: this._size,
	      datatype: this._datatype
	    };
	  };

	  /**
	   * Generate a matrix from a JSON object
	   * @param {Object} json  An object structured like
	   *                       `{"mathjs": "ImmutableDenseMatrix", data: [], size: []}`,
	   *                       where mathjs is optional
	   * @returns {ImmutableDenseMatrix}
	   */
	  ImmutableDenseMatrix.fromJSON = function (json) {
	    return new ImmutableDenseMatrix(json);
	  };

	  /**
	   * Swap rows i and j in Matrix.
	   *
	   * @param {Number} i       Matrix row index 1
	   * @param {Number} j       Matrix row index 2
	   *
	   * @return {Matrix}        The matrix reference
	   */
	  ImmutableDenseMatrix.prototype.swapRows = function () {
	    throw new Error('Cannot invoke swapRows on an Immutable Matrix instance');
	  };

	  /**
	   * Calculate the minimum value in the set
	   * @return {Number | undefined} min
	   */
	  ImmutableDenseMatrix.prototype.min = function () {
	    // check min has been calculated before
	    if (this._min === null) {
	      // minimum
	      var m = null;
	      // compute min
	      this.forEach(function (v) {
	        if (m === null || smaller(v, m))
	          m = v;
	      });
	      this._min = m !== null ? m : undefined;
	    }
	    return this._min;
	  };

	  /**
	   * Calculate the maximum value in the set
	   * @return {Number | undefined} max
	   */
	  ImmutableDenseMatrix.prototype.max = function () {
	    // check max has been calculated before
	    if (this._max === null) {
	      // maximum
	      var m = null;
	      // compute max
	      this.forEach(function (v) {
	        if (m === null || smaller(m, v))
	          m = v;
	      });
	      this._max = m !== null ? m : undefined;
	    }
	    return this._max;
	  };

	  // exports
	  return ImmutableDenseMatrix;
	}

	exports.name = 'ImmutableDenseMatrix';
	exports.path = 'type';
	exports.factory = factory;


/***/ },
/* 249 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var clone = __webpack_require__(5).clone;
	var isInteger = __webpack_require__(8).isInteger;

	function factory (type) {
	  
	  /**
	   * @Constructor Index
	   * Create an index. An Index can store ranges and sets for multiple dimensions.
	   * Matrix.get, Matrix.set, and math.subset accept an Index as input.
	   *
	   * Usage:
	   *     var index = new Index(range1, range2, matrix1, array1, ...);
	   *
	   * Where each parameter can be any of:
	   *     A number
	   *     An instance of Range
	   *     An Array with the Set values
	   *     A Matrix with the Set values
	   *
	   * The parameters start, end, and step must be integer numbers.
	   *
	   * @param {...*} ranges
	   */
	  function Index(ranges) {
	    if (!(this instanceof Index)) {
	      throw new SyntaxError('Constructor must be called with the new operator');
	    }

	    this._dimensions = [];
	    this._isScalar = true;

	    for (var i = 0, ii = arguments.length; i < ii; i++) {
	      var arg = arguments[i];

	      if (arg && (arg.isRange === true)) {
	        this._dimensions.push(arg);
	        this._isScalar = false;
	      }
	      else if (arg && (Array.isArray(arg) || arg.isMatrix === true)) {
	        // create matrix
	        var m = _createImmutableMatrix(arg.valueOf());
	        this._dimensions.push(m);
	        // size
	        var size = m.size();
	        // scalar
	        this._isScalar = size.length === 1 && size[0] === 1;        
	      }
	      else if (typeof arg === 'number') {
	        this._dimensions.push(_createImmutableMatrix([arg]));
	      }
	      // TODO: implement support for wildcard '*'
	      else {
	        throw new TypeError('Dimension must be an Array, Matrix, Number or Range');
	      }
	    }
	  }

	  /**
	   * Attach type information
	   */
	  Index.prototype.type = 'Index';
	  Index.prototype.isIndex = true;

	  function _createImmutableMatrix(arg) {
	    // loop array elements
	    for (var i = 0, l = arg.length; i < l; i++) {
	      if (typeof arg[i] !== 'number' || !isInteger(arg[i])) {
	        throw new TypeError('Index parameters must be positive integer numbers');
	      }
	    }
	    // create matrix
	    return new type.ImmutableDenseMatrix(arg);
	  }

	  /**
	   * Create a clone of the index
	   * @return {Index} clone
	   */
	  Index.prototype.clone = function () {
	    var index = new Index();
	    index._dimensions = clone(this._dimensions);
	    index._isScalar = this._isScalar;
	    return index;
	  };

	  /**
	   * Create an index from an array with ranges/numbers
	   * @param {Array.<Array | number>} ranges
	   * @return {Index} index
	   * @private
	   */
	  Index.create = function (ranges) {
	    var index = new Index();
	    Index.apply(index, ranges);
	    return index;
	  };

	  /**
	   * Retrieve the size of the index, the number of elements for each dimension.
	   * @returns {number[]} size
	   */
	  Index.prototype.size = function () {
	    var size = [];

	    for (var i = 0, ii = this._dimensions.length; i < ii; i++) {
	      var d = this._dimensions[i];
	      size[i] = d.size()[0];
	    }

	    return size;
	  };

	  /**
	   * Get the maximum value for each of the indexes ranges.
	   * @returns {number[]} max
	   */
	  Index.prototype.max = function () {
	    var values = [];

	    for (var i = 0, ii = this._dimensions.length; i < ii; i++) {
	      var range = this._dimensions[i];
	      values[i] = range.max();
	    }

	    return values;
	  };

	  /**
	   * Get the minimum value for each of the indexes ranges.
	   * @returns {number[]} min
	   */
	  Index.prototype.min = function () {
	    var values = [];

	    for (var i = 0, ii = this._dimensions.length; i < ii; i++) {
	      var range = this._dimensions[i];
	      values[i] = range.min();
	    }

	    return values;
	  };

	  /**
	   * Loop over each of the ranges of the index
	   * @param {Function} callback   Called for each range with a Range as first
	   *                              argument, the dimension as second, and the
	   *                              index object as third.
	   */
	  Index.prototype.forEach = function (callback) {
	    for (var i = 0, ii = this._dimensions.length; i < ii; i++) {
	      callback(this._dimensions[i], i, this);
	    }
	  };

	  /**
	   * Retrieve the dimension for the given index
	   * @param {Number} dim                  Number of the dimension
	   * @returns {Range | null} range
	   */
	  Index.prototype.dimension = function (dim) {
	    return this._dimensions[dim] || null;
	  };

	  /**
	   * Test whether this index contains only a single value.
	   *
	   * This is the case when the index is created with only scalar values as ranges,
	   * not for ranges resolving into a single value.
	   * @return {boolean} isScalar
	   */
	  Index.prototype.isScalar = function () {
	    return this._isScalar;
	  };

	  /**
	   * Expand the Index into an array.
	   * For example new Index([0,3], [2,7]) returns [[0,1,2], [2,3,4,5,6]]
	   * @returns {Array} array
	   */
	  Index.prototype.toArray = function () {
	    var array = [];
	    for (var i = 0, ii = this._dimensions.length; i < ii; i++) {
	      array.push(this._dimensions[i].toArray());
	    }
	    return array;
	  };

	  /**
	   * Get the primitive value of the Index, a two dimensional array.
	   * Equivalent to Index.toArray().
	   * @returns {Array} array
	   */
	  Index.prototype.valueOf = Index.prototype.toArray;

	  /**
	   * Get the string representation of the index, for example '[2:6]' or '[0:2:10, 4:7, [1,2,3]]'
	   * @returns {String} str
	   */
	  Index.prototype.toString = function () {
	    var strings = [];

	    for (var i = 0, ii = this._dimensions.length; i < ii; i++) {
	      strings.push(this._dimensions[i].toString());
	    }

	    return '[' + strings.join(', ') + ']';
	  };

	  /**
	   * Get a JSON representation of the Index
	   * @returns {Object} Returns a JSON object structured as:
	   *                   `{"mathjs": "Index", "ranges": [{"mathjs": "Range", start: 0, end: 10, step:1}, ...]}`
	   */
	  Index.prototype.toJSON = function () {
	    return {
	      mathjs: 'Index',
	      dimensions: this._dimensions
	    };
	  };

	  /**
	   * Instantiate an Index from a JSON object
	   * @param {Object} json A JSON object structured as:
	   *                     `{"mathjs": "Index", "dimensions": [{"mathjs": "Range", start: 0, end: 10, step:1}, ...]}`
	   * @return {Index}
	   */
	  Index.fromJSON = function (json) {
	    return Index.create(json.dimensions);
	  };

	  return Index;
	}

	exports.name = 'Index';
	exports.path = 'type';
	exports.factory = factory;


/***/ },
/* 250 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var number = __webpack_require__(8);

	function factory (type, config, load, typed) {
	  /**
	   * @constructor Range
	   * Create a range. A range has a start, step, and end, and contains functions
	   * to iterate over the range.
	   *
	   * A range can be constructed as:
	   *     var range = new Range(start, end);
	   *     var range = new Range(start, end, step);
	   *
	   * To get the result of the range:
	   *     range.forEach(function (x) {
	   *         console.log(x);
	   *     });
	   *     range.map(function (x) {
	   *         return math.sin(x);
	   *     });
	   *     range.toArray();
	   *
	   * Example usage:
	   *     var c = new Range(2, 6);         // 2:1:5
	   *     c.toArray();                     // [2, 3, 4, 5]
	   *     var d = new Range(2, -3, -1);    // 2:-1:-2
	   *     d.toArray();                     // [2, 1, 0, -1, -2]
	   *
	   * @param {number} start  included lower bound
	   * @param {number} end    excluded upper bound
	   * @param {number} [step] step size, default value is 1
	   */
	  function Range(start, end, step) {
	    if (!(this instanceof Range)) {
	      throw new SyntaxError('Constructor must be called with the new operator');
	    }

	    if (start != null) {
	      if (start.isBigNumber === true)
	        start = start.toNumber();
	      else if (typeof start !== 'number')
	        throw new TypeError('Parameter start must be a number');
	    }
	    if (end != null) {
	      if (end.isBigNumber === true)
	        end = end.toNumber();
	      else if (typeof end !== 'number')
	        throw new TypeError('Parameter end must be a number');
	    }
	    if (step != null) {
	      if (step.isBigNumber === true)
	        step = step.toNumber();
	      else if (typeof step !== 'number')
	        throw new TypeError('Parameter step must be a number');
	    }

	    this.start = (start != null) ? parseFloat(start) : 0;
	    this.end   = (end != null)   ? parseFloat(end)   : 0;
	    this.step  = (step != null)  ? parseFloat(step)  : 1;
	  }

	  /**
	   * Attach type information
	   */
	  Range.prototype.type = 'Range';
	  Range.prototype.isRange = true;

	  /**
	   * Parse a string into a range,
	   * The string contains the start, optional step, and end, separated by a colon.
	   * If the string does not contain a valid range, null is returned.
	   * For example str='0:2:11'.
	   * @param {string} str
	   * @return {Range | null} range
	   */
	  Range.parse = function (str) {
	    if (typeof str !== 'string') {
	      return null;
	    }

	    var args = str.split(':');
	    var nums = args.map(function (arg) {
	      return parseFloat(arg);
	    });

	    var invalid = nums.some(function (num) {
	      return isNaN(num);
	    });
	    if (invalid) {
	      return null;
	    }

	    switch (nums.length) {
	      case 2:
	        return new Range(nums[0], nums[1]);
	      case 3:
	        return new Range(nums[0], nums[2], nums[1]);
	      default:
	        return null;
	    }
	  };

	  /**
	   * Create a clone of the range
	   * @return {Range} clone
	   */
	  Range.prototype.clone = function () {
	    return new Range(this.start, this.end, this.step);
	  };

	  /**
	   * Retrieve the size of the range.
	   * Returns an array containing one number, the number of elements in the range.
	   * @returns {number[]} size
	   */
	  Range.prototype.size = function () {
	    var len = 0,
	        start = this.start,
	        step = this.step,
	        end = this.end,
	        diff = end - start;

	    if (number.sign(step) == number.sign(diff)) {
	      len = Math.ceil((diff) / step);
	    }
	    else if (diff == 0) {
	      len = 0;
	    }

	    if (isNaN(len)) {
	      len = 0;
	    }
	    return [len];
	  };

	  /**
	   * Calculate the minimum value in the range
	   * @return {number | undefined} min
	   */
	  Range.prototype.min = function () {
	    var size = this.size()[0];

	    if (size > 0) {
	      if (this.step > 0) {
	        // positive step
	        return this.start;
	      }
	      else {
	        // negative step
	        return this.start + (size - 1) * this.step;
	      }
	    }
	    else {
	      return undefined;
	    }
	  };

	  /**
	   * Calculate the maximum value in the range
	   * @return {number | undefined} max
	   */
	  Range.prototype.max = function () {
	    var size = this.size()[0];

	    if (size > 0) {
	      if (this.step > 0) {
	        // positive step
	        return this.start + (size - 1) * this.step;
	      }
	      else {
	        // negative step
	        return this.start;
	      }
	    }
	    else {
	      return undefined;
	    }
	  };


	  /**
	   * Execute a callback function for each value in the range.
	   * @param {function} callback   The callback method is invoked with three
	   *                              parameters: the value of the element, the index
	   *                              of the element, and the Range being traversed.
	   */
	  Range.prototype.forEach = function (callback) {
	    var x = this.start;
	    var step = this.step;
	    var end = this.end;
	    var i = 0;

	    if (step > 0) {
	      while (x < end) {
	        callback(x, [i], this);
	        x += step;
	        i++;
	      }
	    }
	    else if (step < 0) {
	      while (x > end) {
	        callback(x, [i], this);
	        x += step;
	        i++;
	      }
	    }
	  };

	  /**
	   * Execute a callback function for each value in the Range, and return the
	   * results as an array
	   * @param {function} callback   The callback method is invoked with three
	   *                              parameters: the value of the element, the index
	   *                              of the element, and the Matrix being traversed.
	   * @returns {Array} array
	   */
	  Range.prototype.map = function (callback) {
	    var array = [];
	    this.forEach(function (value, index, obj) {
	      array[index[0]] = callback(value, index, obj);
	    });
	    return array;
	  };

	  /**
	   * Create an Array with a copy of the Ranges data
	   * @returns {Array} array
	   */
	  Range.prototype.toArray = function () {
	    var array = [];
	    this.forEach(function (value, index) {
	      array[index[0]] = value;
	    });
	    return array;
	  };

	  /**
	   * Get the primitive value of the Range, a one dimensional array
	   * @returns {Array} array
	   */
	  Range.prototype.valueOf = function () {
	    // TODO: implement a caching mechanism for range.valueOf()
	    return this.toArray();
	  };

	  /**
	   * Get a string representation of the range, with optional formatting options.
	   * Output is formatted as 'start:step:end', for example '2:6' or '0:0.2:11'
	   * @param {Object | number | function} [options]  Formatting options. See
	   *                                                lib/utils/number:format for a
	   *                                                description of the available
	   *                                                options.
	   * @returns {string} str
	   */
	  Range.prototype.format = function (options) {
	    var str = number.format(this.start, options);

	    if (this.step != 1) {
	      str += ':' + number.format(this.step, options);
	    }
	    str += ':' + number.format(this.end, options);
	    return str;
	  };

	  /**
	   * Get a string representation of the range.
	   * @returns {string}
	   */
	  Range.prototype.toString = function () {
	    return this.format();
	  };

	  /**
	   * Get a JSON representation of the range
	   * @returns {Object} Returns a JSON object structured as:
	   *                   `{"mathjs": "Range", "start": 2, "end": 4, "step": 1}`
	   */
	  Range.prototype.toJSON = function () {
	    return {
	      mathjs: 'Range',
	      start: this.start,
	      end: this.end,
	      step: this.step
	    };
	  };

	  /**
	   * Instantiate a Range from a JSON object
	   * @param {Object} json A JSON object structured as:
	   *                      `{"mathjs": "Range", "start": 2, "end": 4, "step": 1}`
	   * @return {Range}
	   */
	  Range.fromJSON = function (json) {
	    return new Range(json.start, json.end, json.step);
	  };

	  return Range;
	}

	exports.name = 'Range';
	exports.path = 'type';
	exports.factory = factory;


/***/ },
/* 251 */
/***/ function(module, exports) {

	'use strict';

	function factory (type, config, load, typed) {
	  /**
	   * Create an index. An Index can store ranges having start, step, and end
	   * for multiple dimensions.
	   * Matrix.get, Matrix.set, and math.subset accept an Index as input.
	   *
	   * Syntax:
	   *
	   *     math.index(range1, range2, ...)
	   *
	   * Where each range can be any of:
	   *
	   * - A number
	   * - An instance of `Range`
	   * - A one-dimensional Array or a Matrix with numbers
	   *
	   * Indexes must be zero-based, integer numbers.
	   *
	   * Examples:
	   *
	   *    var math = math.js
	   *
	   *    var b = [1, 2, 3, 4, 5];
	   *    math.subset(b, math.index([1, 2, 3]));     // returns [2, 3, 4]
	   *
	   *    var a = math.matrix([[1, 2], [3, 4]]);
	   *    a.subset(math.index(0, 1));             // returns 2
	   *
	   * See also:
	   *
	   *    bignumber, boolean, complex, matrix, number, string, unit
	   *
	   * @param {...*} ranges   Zero or more ranges or numbers.
	   * @return {Index}        Returns the created index
	   */
	  return typed('index', {
	    '...number | BigNumber | Range | Array | Matrix': function (args) {
	      var ranges = args.map(function (arg) {
	        if (arg && arg.isBigNumber === true) {
	          return arg.toNumber(); // convert BigNumber to Number
	        }
	        else if (arg && (Array.isArray(arg) || arg.isMatrix === true)) {
	          return arg.map(function (elem) {
	            // convert BigNumber to Number
	            return (elem && elem.isBigNumber === true) ? elem.toNumber() : elem;
	          });
	        }
	        else {
	          return arg;
	        }
	      });

	      var res = new type.Index();
	      type.Index.apply(res, ranges);
	      return res;
	    }
	  });
	}

	exports.name = 'index';
	exports.factory = factory;


/***/ },
/* 252 */
/***/ function(module, exports) {

	'use strict';

	function factory (type, config, load, typed) {

	  var SparseMatrix = type.SparseMatrix;

	  /**
	   * Create a Sparse Matrix. The function creates a new `math.type.Matrix` object from
	   * an `Array`. A Matrix has utility functions to manipulate the data in the
	   * matrix, like getting the size and getting or setting values in the matrix.
	   *
	   * Syntax:
	   *
	   *    math.sparse()               // creates an empty sparse matrix.
	   *    math.sparse(data)           // creates a sparse matrix with initial data.
	   *    math.sparse(data, 'number') // creates a sparse matrix with initial data, number datatype.
	   *
	   * Examples:
	   *
	   *    var m = math.sparse([[1, 2], [3, 4]]);
	   *    m.size();                        // Array [2, 2]
	   *    m.resize([3, 2], 5);
	   *    m.valueOf();                     // Array [[1, 2], [3, 4], [5, 5]]
	   *    m.get([1, 0])                    // number 3
	   *
	   * See also:
	   *
	   *    bignumber, boolean, complex, index, number, string, unit, matrix
	   *
	   * @param {Array | Matrix} [data]    A two dimensional array
	   *
	   * @return {Matrix} The created matrix
	   */
	  var sparse = typed('sparse', {
	    '': function () {
	      return new SparseMatrix([]);
	    },
	    
	    'string': function (datatype) {
	      return new SparseMatrix([], datatype);
	    },

	    'Array | Matrix': function (data) {
	      return new SparseMatrix(data);
	    },
	    
	    'Array | Matrix, string': function (data, datatype) {
	      return new SparseMatrix(data, datatype);
	    }
	  });

	  sparse.toTex = {
	    0: '\\begin{bsparse}\\end{bsparse}',
	    1: '\\left(${args[0]}\\right)'
	  };

	  return sparse;
	}

	exports.name = 'sparse';
	exports.factory = factory;


/***/ },
/* 253 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = [
	  // type
	  __webpack_require__(254),

	  // construction function
	  __webpack_require__(256)
	];


/***/ },
/* 254 */
/***/ function(module, exports, __webpack_require__) {

	var Decimal = __webpack_require__(255);
	var digits = __webpack_require__(8).digits;

	function factory (type, config, load, typed, math) {
	  var BigNumber = Decimal.constructor(config);

	  /**
	   * Attach type information
	   */
	  BigNumber.prototype.type = 'BigNumber';
	  BigNumber.prototype.isBigNumber = true;

	  /**
	   * Get a JSON representation of a BigNumber containing
	   * type information
	   * @returns {Object} Returns a JSON object structured as:
	   *                   `{"mathjs": "BigNumber", "value": "0.2"}`
	   */
	  BigNumber.prototype.toJSON = function () {
	    return {
	      mathjs: 'BigNumber',
	      value: this.toString()
	    };
	  };

	  /**
	   * Instantiate a BigNumber from a JSON object
	   * @param {Object} json  a JSON object structured as:
	   *                       `{"mathjs": "BigNumber", "value": "0.2"}`
	   * @return {BigNumber}
	   */
	  BigNumber.fromJSON = function (json) {
	    return new BigNumber(json.value);
	  };

	  // listen for changed in the configuration, automatically apply changed precision
	  math.on('config', function (curr, prev) {
	    if (curr.precision !== prev.precision) {
	      BigNumber.config({ precision: curr.precision });
	    }
	  });

	  return BigNumber;
	}

	exports.name = 'BigNumber';
	exports.path = 'type';
	exports.factory = factory;
	exports.math = true; // request access to the math namespace

/***/ },
/* 255 */
/***/ function(module, exports, __webpack_require__) {

	var __WEBPACK_AMD_DEFINE_RESULT__;/*! decimal.js v4.0.2 https://github.com/MikeMcl/decimal.js/LICENCE */
	;(function (global) {
	    'use strict';


	    /*
	     *  decimal.js v4.0.2
	     *  An arbitrary-precision Decimal type for JavaScript.
	     *  https://github.com/MikeMcl/decimal.js
	     *  Copyright (c) 2014 Michael Mclaughlin <M8ch88l@gmail.com>
	     *  MIT Expat Licence
	     */


	    var convertBase, decimal, noConflict,
	        crypto = global['crypto'],
	        external = true,
	        id = 0,
	        mathfloor = Math.floor,
	        mathpow = Math.pow,
	        outOfRange,
	        toString = Object.prototype.toString,
	        BASE = 1e7,
	        LOGBASE = 7,
	        NUMERALS = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ$_',
	        P = {},

	        /*
	         The maximum exponent magnitude.
	         The limit on the value of toExpNeg, toExpPos, minE and maxE.
	         */
	        EXP_LIMIT = 9e15,                      // 0 to 9e15

	        /*
	         The limit on the value of precision, and on the argument to toDecimalPlaces,
	         toExponential, toFixed, toFormat, toPrecision and toSignificantDigits.
	         */
	        MAX_DIGITS = 1E9,                      // 0 to 1e+9

	        /*
	         To decide whether or not to calculate x.pow(integer y) using the 'exponentiation by
	         squaring' algorithm or by exp(y*ln(x)), the number of significant digits of x is multiplied
	         by y. If this number is less than INT_POW_LIMIT then the former algorithm is used.
	         */
	        INT_POW_LIMIT = 3000,                  // 0 to 5000

	        // The natural logarithm of 10 (1025 digits).
	        LN10 = '2.3025850929940456840179914546843642076011014886287729760333279009675726096773524802359972050895982983419677840422862486334095254650828067566662873690987816894829072083255546808437998948262331985283935053089653777326288461633662222876982198867465436674744042432743651550489343149393914796194044002221051017141748003688084012647080685567743216228355220114804663715659121373450747856947683463616792101806445070648000277502684916746550586856935673420670581136429224554405758925724208241314695689016758940256776311356919292033376587141660230105703089634572075440370847469940168269282808481184289314848524948644871927809676271275775397027668605952496716674183485704422507197965004714951050492214776567636938662976979522110718264549734772662425709429322582798502585509785265383207606726317164309505995087807523710333101197857547331541421808427543863591778117054309827482385045648019095610299291824318237525357709750539565187697510374970888692180205189339507238539205144634197265287286965110862571492198849978748873771345686209167058';


	    // Decimal prototype methods


	    /*
	     * Return a new Decimal whose value is the absolute value of this Decimal.
	     *
	     */
	    P['absoluteValue'] = P['abs'] = function () {
	        var x = new this['constructor'](this);

	        if ( x['s'] < 0 ) {
	            x['s'] = 1;
	        }

	        return rnd(x);
	    };


	    /*
	     * Return a new Decimal whose value is the value of this Decimal rounded to a whole number in
	     * the direction of positive Infinity.
	     *
	     */
	    P['ceil'] = function () {

	        return rnd( new this['constructor'](this), this['e'] + 1, 2 );
	    };


	    /*
	     * Return
	     *   1    if the value of this Decimal is greater than the value of Decimal(y, b),
	     *  -1    if the value of this Decimal is less than the value of Decimal(y, b),
	     *   0    if they have the same value,
	     *  null  if the value of either Decimal is NaN.
	     *
	     */
	    P['comparedTo'] = P['cmp'] = function ( y, b ) {
	        var a,
	            x = this,
	            xc = x['c'],
	            yc = ( id = -id, y = new x['constructor']( y, b ), y['c'] ),
	            i = x['s'],
	            j = y['s'],
	            k = x['e'],
	            l = y['e'];

	        // Either NaN?
	        if ( !i || !j ) {
	            return null;
	        }

	        a = xc && !xc[0];
	        b = yc && !yc[0];

	        // Either zero?
	        if ( a || b ) {
	            return a ? b ? 0 : -j : i;
	        }

	        // Signs differ?
	        if ( i != j ) {
	            return i;
	        }

	        a = i < 0;

	        // Either Infinity?
	        if ( !xc || !yc ) {
	            return k == l ? 0 : !xc ^ a ? 1 : -1;
	        }

	        // Compare exponents.
	        if ( k != l ) {
	            return k > l ^ a ? 1 : -1;
	        }

	        // Compare digit by digit.
	        for ( i = -1,
	              j = ( k = xc.length ) < ( l = yc.length ) ? k : l;
	              ++i < j; ) {

	            if ( xc[i] != yc[i] ) {
	                return xc[i] > yc[i] ^ a ? 1 : -1;
	            }
	        }

	        // Compare lengths.
	        return k == l ? 0 : k > l ^ a ? 1 : -1;
	    };


	    /*
	     * Return the number of decimal places of the value of this Decimal.
	     *
	     */
	     P['decimalPlaces'] = P['dp'] = function () {
	        var c, v,
	            n = null;

	        if ( c = this['c'] ) {
	            n = ( ( v = c.length - 1 ) - mathfloor( this['e'] / LOGBASE ) ) * LOGBASE;

	            if ( v = c[v] ) {

	                // Subtract the number of trailing zeros of the last number.
	                for ( ; v % 10 == 0; v /= 10, n-- );
	            }

	            if ( n < 0 ) {
	                n = 0;
	            }
	        }

	        return n;
	    };


	    /*
	     *  n / 0 = I
	     *  n / N = N
	     *  n / I = 0
	     *  0 / n = 0
	     *  0 / 0 = N
	     *  0 / N = N
	     *  0 / I = 0
	     *  N / n = N
	     *  N / 0 = N
	     *  N / N = N
	     *  N / I = N
	     *  I / n = I
	     *  I / 0 = I
	     *  I / N = N
	     *  I / I = N
	     *
	     * Return a new Decimal whose value is the value of this Decimal divided by Decimal(y, b),
	     * rounded to precision significant digits using rounding mode rounding.
	     *
	     */
	    P['dividedBy'] = P['div'] = function ( y, b ) {
	        id = 2;

	        return div( this, new this['constructor']( y, b ) );
	    };


	    /*
	     * Return a new Decimal whose value is the integer part of dividing the value of this Decimal by
	     * the value of Decimal(y, b), rounded to precision significant digits using rounding mode
	     * rounding.
	     *
	     */
	    P['dividedToIntegerBy'] = P['divToInt'] = function ( y, b ) {
	        var x = this,
	            Decimal = x['constructor'];
	        id = 18;

	        return rnd(
	          div( x, new Decimal( y, b ), 0, 1, 1 ), Decimal['precision'], Decimal['rounding']
	        );
	    };


	    /*
	     * Return true if the value of this Decimal is equal to the value of Decimal(n, b), otherwise
	     * return false.
	     *
	     */
	    P['equals'] = P['eq'] = function ( n, b ) {
	        id = 3;

	        return this['cmp']( n, b ) === 0;
	    };


	    /*
	     * Return a new Decimal whose value is the exponential of the value of this Decimal, i.e. the
	     * base e raised to the power the value of this Decimal, rounded to precision significant digits
	     * using rounding mode rounding.
	     *
	     */
	    P['exponential'] = P['exp'] = function () {

	        return exp(this);
	    };


	    /*
	     * Return a new Decimal whose value is the value of this Decimal rounded to a whole number in
	     * the direction of negative Infinity.
	     *
	     */
	    P['floor'] = function () {

	        return rnd( new this['constructor'](this), this['e'] + 1, 3 );
	    };


	    /*
	     * Return true if the value of this Decimal is greater than the value of Decimal(n, b), otherwise
	     * return false.
	     *
	     */
	    P['greaterThan'] = P['gt'] = function ( n, b ) {
	        id = 4;

	        return this['cmp']( n, b ) > 0;
	    };


	    /*
	     * Return true if the value of this Decimal is greater than or equal to the value of
	     * Decimal(n, b), otherwise return false.
	     *
	     */
	    P['greaterThanOrEqualTo'] = P['gte'] = function ( n, b ) {
	        id = 5;
	        b = this['cmp']( n, b );

	        return b == 1 || b === 0;
	    };


	    /*
	     * Return true if the value of this Decimal is a finite number, otherwise return false.
	     *
	     */
	    P['isFinite'] = function () {

	        return !!this['c'];
	    };


	    /*
	     * Return true if the value of this Decimal is an integer, otherwise return false.
	     *
	     */
	    P['isInteger'] = P['isInt'] = function () {

	        return !!this['c'] && mathfloor( this['e'] / LOGBASE ) > this['c'].length - 2;
	    };


	    /*
	     * Return true if the value of this Decimal is NaN, otherwise return false.
	     *
	     */
	    P['isNaN'] = function () {

	        return !this['s'];
	    };


	    /*
	     * Return true if the value of this Decimal is negative, otherwise return false.
	     *
	     */
	    P['isNegative'] = P['isNeg'] = function () {

	        return this['s'] < 0;
	    };


	    /*
	     * Return true if the value of this Decimal is 0 or -0, otherwise return false.
	     *
	     */
	    P['isZero'] = function () {

	        return !!this['c'] && this['c'][0] == 0;
	    };


	    /*
	     * Return true if the value of this Decimal is less than Decimal(n, b), otherwise return false.
	     *
	     */
	    P['lessThan'] = P['lt'] = function ( n, b ) {
	        id = 6;

	        return this['cmp']( n, b ) < 0;
	    };


	    /*
	     * Return true if the value of this Decimal is less than or equal to Decimal(n, b), otherwise
	     * return false.
	     *
	     */
	    P['lessThanOrEqualTo'] = P['lte'] = function ( n, b ) {
	        id = 7;
	        b = this['cmp']( n, b );

	        return b == -1 || b === 0;
	    };


	    /*
	     * Return the logarithm of the value of this Decimal to the specified base, rounded
	     * to precision significant digits using rounding mode rounding.
	     *
	     * If no base is specified, return log[10](arg).
	     *
	     * log[base](arg) = ln(arg) / ln(base)
	     *
	     * The result will always be correctly rounded if the base of the log is 2 or 10, and
	     * 'almost always' if not:
	     *
	     * Depending on the rounding mode, the result may be incorrectly rounded if the first fifteen
	     * rounding digits are [49]99999999999999 or [50]00000000000000. In that case, the maximum error
	     * between the result and the correctly rounded result will be one ulp (unit in the last place).
	     *
	     * log[-b](a)       = NaN
	     * log[0](a)        = NaN
	     * log[1](a)        = NaN
	     * log[NaN](a)      = NaN
	     * log[Infinity](a) = NaN
	     * log[b](0)        = -Infinity
	     * log[b](-0)       = -Infinity
	     * log[b](-a)       = NaN
	     * log[b](1)        = 0
	     * log[b](Infinity) = Infinity
	     * log[b](NaN)      = NaN
	     *
	     * [base] {number|string|Decimal} The base of the logarithm.
	     * [b] {number} The base of base.
	     *
	     */
	    P['logarithm'] = P['log'] = function ( base, b ) {
	        var base10, c, denom, i, inf, num, sd, sd10, r,
	            arg = this,
	            Decimal = arg['constructor'],
	            pr = Decimal['precision'],
	            rm = Decimal['rounding'],
	            guard = 5;

	        // Default base is 10.
	        if ( base == null ) {
	            base = new Decimal(10);
	            base10 = true;
	        } else {
	            id = 15;
	            base = new Decimal( base, b );
	            c = base['c'];

	            // If base < 0 or +-Infinity/NaN or 0 or 1.
	            if ( base['s'] < 0 || !c || !c[0] || !base['e'] && c[0] == 1 && c.length == 1 ) {

	                return new Decimal(NaN);
	            }
	            base10 = base['eq'](10);
	        }
	        c = arg['c'];

	        // If arg < 0 or +-Infinity/NaN or 0 or 1.
	        if ( arg['s'] < 0 || !c || !c[0] || !arg['e'] && c[0] == 1 && c.length == 1 ) {

	            return new Decimal( c && !c[0] ? -1 / 0 : arg['s'] != 1 ? NaN : c ? 0 : 1 / 0 );
	        }

	        /*
	          The result will have an infinite decimal expansion if base is 10 and arg is not an
	          integer power of 10...
	         */
	        inf = base10 && ( i = c[0], c.length > 1 || i != 1 && i != 10 &&
	          i != 1e2 && i != 1e3 && i != 1e4 && i != 1e5 && i != 1e6 );
	            /*
	            // or if base last digit's evenness is not the same as arg last digit's evenness...
	            // (FAILS when e.g. base.c[0] = 10 and c[0] = 1)
	            || ( base['c'][ base['c'].length - 1 ] & 1 ) != ( c[ c.length - 1 ] & 1 )
	              // or if base is 2 and there is more than one 1 in arg in base 2.
	              // (SLOWS the method down significantly)
	              || base['eq'](2) && arg.toString(2).replace( /[^1]+/g, '' ) != '1';
	             */

	        external = false;
	        sd = pr + guard;
	        sd10 = sd + 10;

	        num = ln( arg, sd );

	        if (base10) {

	            if ( sd10 > LN10.length ) {
	                ifExceptionsThrow( Decimal, 1, sd10, 'log' );
	            }
	            denom = new Decimal( LN10.slice( 0, sd10 ) );
	        } else {
	            denom = ln( base, sd );
	        }

	        // The result will have 5 rounding digits.
	        r = div( num, denom, sd, 1 );

	        /*
	         If at a rounding boundary, i.e. the result's rounding digits are [49]9999 or [50]0000,
	         calculate 10 further digits.

	         If the result is known to have an infinite decimal expansion, repeat this until it is
	         clear that the result is above or below the boundary. Otherwise, if after calculating
	         the 10 further digits, the last 14 are nines, round up and assume the result is exact.
	         Also assume the result is exact if the last 14 are zero.

	         Example of a result that will be incorrectly rounded:
	         log[1048576](4503599627370502) = 2.60000000000000009610279511444746...
	         The above result correctly rounded using ROUND_CEIL to 1 decimal place should be 2.7,
	         but it will be given as 2.6 as there are 15 zeros immediately after the requested
	         decimal place, so the exact result would be assumed to be 2.6, which rounded using
	         ROUND_CEIL to 1 decimal place is still 2.6.
	         */
	        if ( checkRoundingDigits( r['c'], i = pr, rm ) ) {

	            do {
	                sd += 10;
	                num = ln( arg, sd );

	                if (base10) {
	                    sd10 = sd + 10;

	                    if ( sd10 > LN10.length ) {
	                        ifExceptionsThrow( Decimal, 1, sd10, 'log' );
	                    }
	                    denom = new Decimal( LN10.slice( 0, sd10 ) );
	                } else {
	                    denom = ln( base, sd );
	                }

	                r = div( num, denom, sd, 1 );

	                if ( !inf ) {

	                    // Check for 14 nines from the 2nd rounding digit, as the first may be 4.
	                    if ( +coefficientToString( r['c'] ).slice( i + 1, i + 15 ) + 1 == 1e14 ) {
	                        r = rnd( r, pr + 1, 0 );
	                    }

	                    break;
	                }
	            } while ( checkRoundingDigits( r['c'], i += 10, rm ) );
	        }
	        external = true;

	        return rnd( r, pr, rm );
	    };


	    /*
	     *  n - 0 = n
	     *  n - N = N
	     *  n - I = -I
	     *  0 - n = -n
	     *  0 - 0 = 0
	     *  0 - N = N
	     *  0 - I = -I
	     *  N - n = N
	     *  N - 0 = N
	     *  N - N = N
	     *  N - I = N
	     *  I - n = I
	     *  I - 0 = I
	     *  I - N = N
	     *  I - I = N
	     *
	     * Return a new Decimal whose value is the value of this Decimal minus Decimal(y, b), rounded
	     * to precision significant digits using rounding mode rounding.
	     *
	     */
	    P['minus'] = function ( y, b ) {
	        var t, i, j, xLTy,
	            x = this,
	            Decimal = x['constructor'],
	            a = x['s'];

	        id = 8;
	        y = new Decimal( y, b );
	        b = y['s'];

	        // Either NaN?
	        if ( !a || !b ) {

	            return new Decimal(NaN);
	        }

	        // Signs differ?
	        if ( a != b ) {
	            y['s'] = -b;

	            return x['plus'](y);
	        }

	        var xc = x['c'],
	            yc = y['c'],
	            e = mathfloor( y['e'] / LOGBASE ),
	            k = mathfloor( x['e'] / LOGBASE ),
	            pr = Decimal['precision'],
	            rm = Decimal['rounding'];

	        if ( !k || !e ) {

	            // Either Infinity?
	            if ( !xc || !yc ) {

	                return xc ? ( y['s'] = -b, y ) : new Decimal( yc ? x : NaN );
	            }

	            // Either zero?
	            if ( !xc[0] || !yc[0] ) {

	                // Return y if y is non-zero, x if x is non-zero, or zero if both are zero.
	                x = yc[0] ? ( y['s'] = -b, y ) : new Decimal( xc[0] ? x :

	                  // IEEE 754 (2008) 6.3: n - n = -0 when rounding to -Infinity
	                  rm == 3 ? -0 : 0 );

	                return external ? rnd( x, pr, rm ) : x;
	            }
	        }

	        xc = xc.slice();
	        i = xc.length;

	        // Determine which is the bigger number. Prepend zeros to equalise exponents.
	        if ( a = k - e ) {

	            if ( xLTy = a < 0 ) {
	                a = -a;
	                t = xc;
	                i = yc.length;
	            } else {
	                e = k;
	                t = yc;
	            }

	            if ( ( k = Math.ceil( pr / LOGBASE ) ) > i ) {
	                i = k;
	            }

	            /*
	             Numbers with massively different exponents would result in a massive number of
	             zeros needing to be prepended, but this can be avoided while still ensuring correct
	             rounding by limiting the number of zeros to max( pr, i ) + 2, where pr is precision and
	             i is the length of the coefficient of whichever is greater, x or y.
	             */
	            if ( a > ( i += 2 ) ) {
	                a = i;
	                t.length = 1;
	            }

	            t.reverse();
	            for ( b = a; b--; t.push(0) );
	            t.reverse();
	        } else {
	            // Exponents equal. Check digits.

	            if ( xLTy = i < ( j = yc.length ) ) {
	                j = i;
	            }

	            for ( a = b = 0; b < j; b++ ) {

	                if ( xc[b] != yc[b] ) {
	                    xLTy = xc[b] < yc[b];

	                    break;
	                }
	            }
	        }

	        // x < y? Point xc to the array of the bigger number.
	        if ( xLTy ) {
	            t = xc, xc = yc, yc = t;
	            y['s'] = -y['s'];
	        }

	        /*
	         Append zeros to xc if shorter. No need to add zeros to yc if shorter as subtraction only
	         needs to start at yc length.
	         */
	        if ( ( b = -( ( j = xc.length ) - yc.length ) ) > 0 ) {

	            for ( ; b--; xc[j++] = 0 );
	        }

	        // Subtract yc from xc.
	        for ( k = BASE - 1, b = yc.length; b > a; ) {

	            if ( xc[--b] < yc[b] ) {

	                for ( i = b; i && !xc[--i]; xc[i] = k );
	                --xc[i];
	                xc[b] += BASE;
	            }
	            xc[b] -= yc[b];
	        }

	        // Remove trailing zeros.
	        for ( ; xc[--j] == 0; xc.pop() );

	        // Remove leading zeros and adjust exponent accordingly.
	        for ( ; xc[0] == 0; xc.shift(), --e );

	        if ( !xc[0] ) {

	            // Zero.
	            xc = [ e = 0 ];

	            // Following IEEE 754 (2008) 6.3, n - n = -0 when rounding towards -Infinity.
	            y['s'] = rm == 3 ? -1 : 1;
	        }

	        y['c'] = xc;

	        // Get the number of digits of xc[0].
	        for ( a = 1, b = xc[0]; b >= 10; b /= 10, a++ );
	        y['e'] = a + e * LOGBASE - 1;

	        return external ? rnd( y, pr, rm ) : y;
	    };


	    /*
	     *   n % 0 =  N
	     *   n % N =  N
	     *   n % I =  n
	     *   0 % n =  0
	     *  -0 % n = -0
	     *   0 % 0 =  N
	     *   0 % N =  N
	     *   0 % I =  0
	     *   N % n =  N
	     *   N % 0 =  N
	     *   N % N =  N
	     *   N % I =  N
	     *   I % n =  N
	     *   I % 0 =  N
	     *   I % N =  N
	     *   I % I =  N
	     *
	     * Return a new Decimal whose value is the value of this Decimal modulo Decimal(y, b), rounded
	     * to precision significant digits using rounding mode rounding.
	     *
	     * The result depends on the modulo mode.
	     *
	     */
	    P['modulo'] = P['mod'] = function ( y, b ) {
	        var n, q,
	            x = this,
	            Decimal = x['constructor'],
	            m = Decimal['modulo'];

	        id = 9;
	        y = new Decimal( y, b );
	        b = y['s'];
	        n = !x['c'] || !b || y['c'] && !y['c'][0];

	        /*
	         Return NaN if x is Infinity or NaN, or y is NaN or zero, else return x if y is Infinity
	         or x is zero.
	         */
	        if ( n || !y['c'] || x['c'] && !x['c'][0] ) {

	            return n
	              ? new Decimal(NaN)
	              : rnd( new Decimal(x), Decimal['precision'], Decimal['rounding'] );
	        }

	        external = false;

	        if ( m == 9 ) {

	            // Euclidian division: q = sign(y) * floor(x / abs(y))
	            // r = x - qy    where  0 <= r < abs(y)
	            y['s'] = 1;
	            q = div( x, y, 0, 3, 1 );
	            y['s'] = b;
	            q['s'] *= b;
	        } else {
	            q = div( x, y, 0, m, 1 );
	        }

	        q = q['times'](y);
	        external = true;

	        return x['minus'](q);
	    };


	    /*
	     * Return a new Decimal whose value is the natural logarithm of the value of this Decimal,
	     * rounded to precision significant digits using rounding mode rounding.
	     *
	     */
	    P['naturalLogarithm'] = P['ln'] = function () {

	        return ln(this);
	    };


	    /*
	     * Return a new Decimal whose value is the value of this Decimal negated, i.e. as if
	     * multiplied by -1.
	     *
	     */
	    P['negated'] = P['neg'] = function () {
	        var x = new this['constructor'](this);
	        x['s'] = -x['s'] || null;

	        return rnd(x);
	    };


	    /*
	     *  n + 0 = n
	     *  n + N = N
	     *  n + I = I
	     *  0 + n = n
	     *  0 + 0 = 0
	     *  0 + N = N
	     *  0 + I = I
	     *  N + n = N
	     *  N + 0 = N
	     *  N + N = N
	     *  N + I = N
	     *  I + n = I
	     *  I + 0 = I
	     *  I + N = N
	     *  I + I = I
	     *
	     * Return a new Decimal whose value is the value of this Decimal plus Decimal(y, b), rounded
	     * to precision significant digits using rounding mode rounding.
	     *
	     */
	    P['plus'] = function ( y, b ) {
	        var t,
	            x = this,
	            Decimal = x['constructor'],
	            a = x['s'];

	        id = 10;
	        y = new Decimal( y, b );
	        b = y['s'];

	        // Either NaN?
	        if ( !a || !b ) {

	            return new Decimal(NaN);
	        }

	        // Signs differ?
	        if ( a != b ) {
	            y['s'] = -b;

	            return x['minus'](y);
	        }

	        var xc = x['c'],
	            yc = y['c'],
	            e = mathfloor( y['e'] / LOGBASE ),
	            k = mathfloor( x['e'] / LOGBASE ),
	            pr = Decimal['precision'],
	            rm = Decimal['rounding'];

	        if ( !k || !e ) {

	            // Either Infinity?
	            if ( !xc || !yc ) {

	                // Return +-Infinity.
	                return new Decimal( a / 0 );
	            }

	            // Either zero?
	            if ( !xc[0] || !yc[0] ) {

	                // Return y if y is non-zero, x if x is non-zero, or zero if both are zero.
	                x = yc[0] ? y : new Decimal( xc[0] ? x : a * 0 );

	                return external ? rnd( x, pr, rm ) : x;
	            }
	        }

	        xc = xc.slice();

	        // Prepend zeros to equalise exponents. Note: Faster to use reverse then do unshifts.
	        if ( a = k - e ) {

	            if ( a < 0 ) {
	                a = -a;
	                t = xc;
	                b = yc.length;
	            } else {
	                e = k;
	                t = yc;
	                b = xc.length;
	            }

	            if ( ( k = Math.ceil( pr / LOGBASE ) ) > b ) {
	                b = k;
	            }

	            // Limit number of zeros prepended to max( pr, b ) + 1.
	            if ( a > ++b ) {
	                a = b;
	                t.length = 1;
	            }

	            for ( t.reverse(); a--; t.push(0) );
	            t.reverse();
	        }

	        // Point xc to the longer array.
	        if ( xc.length - yc.length < 0 ) {
	            t = yc, yc = xc, xc = t;
	        }

	        // Only start adding at yc.length - 1 as the further digits of xc can be left as they are.
	        for ( a = yc.length, b = 0, k = BASE; a; xc[a] %= k ) {
	            b = ( xc[--a] = xc[a] + yc[a] + b ) / k | 0;
	        }

	        if (b) {
	            xc.unshift(b);
	            ++e;
	        }

	        // Remove trailing zeros.
	        for ( a = xc.length; xc[--a] == 0; xc.pop() );

	        // No need to check for zero, as +x + +y != 0 && -x + -y != 0

	        y['c'] = xc;

	        // Get the number of digits of xc[0].
	        for ( a = 1, b = xc[0]; b >= 10; b /= 10, a++ );
	        y['e'] = a + e * LOGBASE - 1;

	        return external ? rnd( y, pr, rm ) : y;
	    };


	    /*
	     * Return the number of significant digits of this Decimal.
	     *
	     * [z] {boolean|number} Whether to count integer-part trailing zeros: true, false, 1 or 0.
	     *
	     */
	    P['precision'] = P['sd'] = function (z) {
	        var n = null,
	            x = this;

	        if ( z != n && z !== !!z && z !== 1 && z !== 0 ) {

	            // 'precision() argument not a boolean or binary digit: {z}'
	            ifExceptionsThrow( x['constructor'], 'argument', z, 'precision', 1 );
	        }

	        if ( x['c'] ) {
	            n = getCoeffLength( x['c'] );

	            if ( z && x['e'] + 1 > n ) {
	                n = x['e'] + 1;
	            }
	        }

	        return n;
	    };


	    /*
	     * Return a new Decimal whose value is the value of this Decimal rounded to a whole number using
	     * rounding mode rounding.
	     *
	     */
	    P['round'] = function () {
	        var x = this,
	            Decimal = x['constructor'];

	        return rnd( new Decimal(x), x['e'] + 1, Decimal['rounding'] );
	    };


	    /*
	     *  sqrt(-n) =  N
	     *  sqrt( N) =  N
	     *  sqrt(-I) =  N
	     *  sqrt( I) =  I
	     *  sqrt( 0) =  0
	     *  sqrt(-0) = -0
	     *
	     * Return a new Decimal whose value is the square root of this Decimal, rounded to precision
	     * significant digits using rounding mode rounding.
	     *
	     */
	    P['squareRoot'] = P['sqrt'] = function () {
	        var m, n, sd, r, rep, t,
	            x = this,
	            c = x['c'],
	            s = x['s'],
	            e = x['e'],
	            Decimal = x['constructor'],
	            half = new Decimal(0.5);

	        // Negative/NaN/Infinity/zero?
	        if ( s !== 1 || !c || !c[0] ) {

	            return new Decimal( !s || s < 0 && ( !c || c[0] ) ? NaN : c ? x : 1 / 0 );
	        }

	        external = false;

	        // Initial estimate.
	        s = Math.sqrt( +x );

	        /*
	         Math.sqrt underflow/overflow?
	         Pass x to Math.sqrt as integer, then adjust the exponent of the result.
	         */
	        if ( s == 0 || s == 1 / 0 ) {
	            n = coefficientToString(c);

	            if ( ( n.length + e ) % 2 == 0 ) {
	                n += '0';
	            }

	            s = Math.sqrt(n);
	            e = mathfloor( ( e + 1 ) / 2 ) - ( e < 0 || e % 2 );

	            if ( s == 1 / 0 ) {
	                n = '1e' + e;
	            } else {
	                n = s.toExponential();
	                n = n.slice( 0, n.indexOf('e') + 1 ) + e;
	            }

	            r = new Decimal(n);
	        } else {
	            r = new Decimal( s.toString() );
	        }

	        sd = ( e = Decimal['precision'] ) + 3;

	        // Newton-Raphson iteration.
	        for ( ; ; ) {
	            t = r;
	            r = half['times']( t['plus']( div( x, t, sd + 2, 1 ) ) );

	            if ( coefficientToString( t['c'] ).slice( 0, sd ) ===
	                ( n = coefficientToString( r['c'] ) ).slice( 0, sd ) ) {
	                n = n.slice( sd - 3, sd + 1 );

	                /*
	                 The 4th rounding digit may be in error by -1 so if the 4 rounding digits are
	                 9999 or 4999 (i.e. approaching a rounding boundary) continue the iteration.
	                 */
	                if ( n == '9999' || !rep && n == '4999' ) {

	                    /*
	                     On the first iteration only, check to see if rounding up gives the exact result
	                     as the nines may infinitely repeat.
	                     */
	                    if ( !rep ) {
	                        rnd( t, e + 1, 0 );

	                        if ( t['times'](t)['eq'](x) ) {
	                            r = t;

	                            break;
	                        }
	                    }
	                    sd += 4;
	                    rep = 1;
	                } else {

	                    /*
	                     If the rounding digits are null, 0{0,4} or 50{0,3}, check for an exact result.
	                     If not, then there are further digits and m will be truthy.
	                     */
	                    if ( !+n || !+n.slice(1) && n.charAt(0) == '5' ) {

	                        // Truncate to the first rounding digit.
	                        rnd( r, e + 1, 1 );
	                        m = !r['times'](r)['eq'](x);
	                    }

	                    break;
	                }
	            }
	        }
	        external = true;

	        return rnd( r, e, Decimal['rounding'], m );
	    };


	    /*
	     *  n * 0 = 0
	     *  n * N = N
	     *  n * I = I
	     *  0 * n = 0
	     *  0 * 0 = 0
	     *  0 * N = N
	     *  0 * I = N
	     *  N * n = N
	     *  N * 0 = N
	     *  N * N = N
	     *  N * I = N
	     *  I * n = I
	     *  I * 0 = N
	     *  I * N = N
	     *  I * I = I
	     *
	     * Return a new Decimal whose value is this Decimal times Decimal(y), rounded to precision
	     * significant digits using rounding mode rounding.
	     *
	     */
	    P['times'] = function ( y, b ) {
	        var c, e,
	            x = this,
	            Decimal = x['constructor'],
	            xc = x['c'],
	            yc = ( id = 11, y = new Decimal( y, b ), y['c'] ),
	            i = mathfloor( x['e'] / LOGBASE ),
	            j = mathfloor( y['e'] / LOGBASE ),
	            a = x['s'];

	        b = y['s'];

	        y['s'] = a == b ? 1 : -1;

	        // Either NaN/Infinity/0?
	        if ( !i && ( !xc || !xc[0] ) || !j && ( !yc || !yc[0] ) ) {

	            // Either NaN?
	            return new Decimal( !a || !b ||

	              // x is 0 and y is Infinity  or y is 0 and x is Infinity?
	              xc && !xc[0] && !yc || yc && !yc[0] && !xc

	                // Return NaN.
	                ? NaN

	                // Either Infinity?
	                : !xc || !yc

	                  // Return +-Infinity.
	                  ? y['s'] / 0

	                  // x or y is 0. Return +-0.
	                  : y['s'] * 0 );
	        }

	        e = i + j;
	        a = xc.length;
	        b = yc.length;

	        if ( a < b ) {

	            // Swap.
	            c = xc, xc = yc, yc = c;
	            j = a, a = b, b = j;
	        }

	        for ( j = a + b, c = []; j--; c.push(0) );

	        // Multiply!
	        for ( i = b - 1; i > -1; i-- ) {
	            b = 0;

	            for ( j = a + i; j > i; ) {
	                  b = c[j] + yc[i] * xc[j - i - 1] + b;
	                  c[j--] = b % BASE | 0;
	                  b = b / BASE | 0;
	            }
	            c[j] = ( c[j] + b ) % BASE | 0;
	        }

	        if (b) {
	            ++e;
	        } else if ( !c[0] ) {

	            // Remove leading zero.
	            c.shift();
	        }

	        // Remove trailing zeros.
	        for ( j = c.length; !c[--j]; c.pop() );
	        y['c'] = c;

	        // Get the number of digits of c[0].
	        for ( a = 1, b = c[0]; b >= 10; b /= 10, a++ );
	        y['e'] = a + e * LOGBASE - 1;

	        return external ? rnd( y, Decimal['precision'], Decimal['rounding'] ) : y;
	    };


	    /*
	     * Return a new Decimal whose value is the value of this Decimal rounded to a maximum of dp
	     * decimal places using rounding mode rm or rounding if rm is omitted.
	     *
	     * If dp is omitted, return a new Decimal whose value is the value of this Decimal.
	     *
	     * [dp] {number} Decimal places. Integer, 0 to MAX_DIGITS inclusive.
	     * [rm] {number} Rounding mode. Integer, 0 to 8 inclusive.
	     *
	     * 'toDP() dp out of range: {dp}'
	     * 'toDP() dp not an integer: {dp}'
	     * 'toDP() rounding mode not an integer: {rm}'
	     * 'toDP() rounding mode out of range: {rm}'
	     *
	     */
	    P['toDecimalPlaces'] = P['toDP'] = function ( dp, rm ) {
	        var x = this;
	        x = new x['constructor'](x);

	        return dp == null || !checkArg( x, dp, 'toDP' )
	          ? x
	          : rnd( x, ( dp | 0 ) + x['e'] + 1, checkRM( x, rm, 'toDP' ) );
	    };


	    /*
	     * Return a string representing the value of this Decimal in exponential notation rounded to dp
	     * fixed decimal places using rounding mode rounding.
	     *
	     * [dp] {number} Decimal places. Integer, 0 to MAX_DIGITS inclusive.
	     * [rm] {number} Rounding mode. Integer, 0 to 8 inclusive.
	     *
	     * errors true: Throw if dp and rm are not undefined, null or integers in range.
	     * errors false: Ignore dp and rm if not numbers or not in range, and truncate non-integers.
	     *
	     * 'toExponential() dp not an integer: {dp}'
	     * 'toExponential() dp out of range: {dp}'
	     * 'toExponential() rounding mode not an integer: {rm}'
	     * 'toExponential() rounding mode out of range: {rm}'
	     *
	     */
	    P['toExponential'] = function ( dp, rm ) {
	        var x = this;

	        return x['c']
	          ? format( x, dp != null && checkArg( x, dp, 'toExponential' ) ? dp | 0 : null,
	            dp != null && checkRM( x, rm, 'toExponential' ), 1 )
	          : x.toString();
	    };


	    /*
	     * Return a string representing the value of this Decimal in normal (fixed-point) notation to
	     * dp fixed decimal places and rounded using rounding mode rm or rounding if rm is omitted.
	     *
	     * Note: as with JS numbers, (-0).toFixed(0) is '0', but e.g. (-0.00001).toFixed(0) is '-0'.
	     *
	     * [dp] {number} Decimal places. Integer, 0 to MAX_DIGITS inclusive.
	     * [rm] {number} Rounding mode. Integer, 0 to 8 inclusive.
	     *
	     * errors true: Throw if dp and rm are not undefined, null or integers in range.
	     * errors false: Ignore dp and rm if not numbers or not in range, and truncate non-integers.
	     *
	     * 'toFixed() dp not an integer: {dp}'
	     * 'toFixed() dp out of range: {dp}'
	     * 'toFixed() rounding mode not an integer: {rm}'
	     * 'toFixed() rounding mode out of range: {rm}'
	     *
	     */
	    P['toFixed'] = function ( dp, rm ) {
	        var str,
	            x = this,
	            Decimal = x['constructor'],
	            neg = Decimal['toExpNeg'],
	            pos = Decimal['toExpPos'];

	        if ( dp != null ) {
	            dp = checkArg( x, dp, str = 'toFixed' ) ? x['e'] + ( dp | 0 ) : null;
	            rm = checkRM( x, rm, str );
	        }

	        // Prevent toString returning exponential notation;
	        Decimal['toExpNeg'] = -( Decimal['toExpPos'] = 1 / 0 );

	        if ( dp == null || !x['c'] ) {
	            str = x.toString();
	        } else {
	            str = format( x, dp, rm );

	            // (-0).toFixed() is '0', but (-0.1).toFixed() is '-0'.
	            // (-0).toFixed(1) is '0.0', but (-0.01).toFixed(1) is '-0.0'.
	            if ( x['s'] < 0 && x['c'] ) {

	                // As e.g. (-0).toFixed(3), will wrongly be returned as -0.000 from toString.
	                if ( !x['c'][0] ) {
	                    str = str.replace( '-', '' );

	                // As e.g. -0.5 if rounded to -0 will cause toString to omit the minus sign.
	                } else if ( str.indexOf('-') < 0 ) {
	                    str = '-' + str;
	                }
	            }
	        }
	        Decimal['toExpNeg'] = neg;
	        Decimal['toExpPos'] = pos;

	        return str;
	    };


	    /*
	     * Return a string representing the value of this Decimal in fixed-point notation to dp decimal
	     * places, rounded using rounding mode rm or Decimal.rounding if rm is omitted, and formatted
	     * according to the following properties of the Decimal.format object.
	     *
	     *  Decimal.format = {
	     *      decimalSeparator : '.',
	     *      groupSeparator : ',',
	     *      groupSize : 3,
	     *      secondaryGroupSize : 0,
	     *      fractionGroupSeparator : '\xA0',    // non-breaking space
	     *      fractionGroupSize : 0
	     *  };
	     *
	     * [dp] {number} Decimal places. Integer, 0 to MAX_DIGITS inclusive.
	     * [rm] {number} Rounding mode. Integer, 0 to 8 inclusive
	     *
	     * (If dp or rm are invalid the error message will give the offending method call as toFixed.)
	     *
	     */
	    P['toFormat'] = function( dp, rm ) {
	        var x = this;

	        if ( !x['c'] ) {
	            return x.toString();
	        }

	        var i,
	            isNeg = x['s'] < 0,
	            f = x['constructor']['format'],
	            groupSeparator = f['groupSeparator'],
	            g1 = +f['groupSize'],
	            g2 = +f['secondaryGroupSize'],
	            arr = x.toFixed( dp, rm ).split('.'),
	            intPart = arr[0],
	            fractionPart = arr[1],
	            intDigits = isNeg ? intPart.slice(1) : intPart,
	            len = intDigits.length;

	        if (g2) {
	            len -= ( i = g1, g1 = g2, g2 = i );
	        }

	        if ( g1 > 0 && len > 0 ) {
	            i = len % g1 || g1;
	            intPart = intDigits.substr( 0, i );

	            for ( ; i < len; i += g1 ) {
	                intPart += groupSeparator + intDigits.substr( i, g1 );
	            }

	            if ( g2 > 0 ) {
	                intPart += groupSeparator + intDigits.slice(i);
	            }

	            if (isNeg) {
	                intPart = '-' + intPart;
	            }
	        }

	        return fractionPart
	          ? intPart + f['decimalSeparator'] + ( ( g2 = +f['fractionGroupSize'] )
	            ? fractionPart.replace( new RegExp( '\\d{' + g2 + '}\\B', 'g' ),
	              '$&' + f['fractionGroupSeparator'] )
	            : fractionPart )
	          : intPart;
	    };


	    /*
	     * Return a string array representing the value of this Decimal as a simple fraction with an
	     * integer numerator and an integer denominator.
	     *
	     * The denominator will be a positive non-zero value less than or equal to the specified
	     * maximum denominator. If a maximum denominator is not specified, the denominator will be
	     * the lowest value necessary to represent the number exactly.
	     *
	     * [maxD] {number|string|Decimal} Maximum denominator. Integer >= 1 and < Infinity.
	     *
	     */
	    P['toFraction'] = function (maxD) {
	        var d0, d2, e, frac, n, n0, p, q,
	            x = this,
	            Decimal = x['constructor'],
	            n1 = d0 = new Decimal( Decimal['ONE'] ),
	            d1 = n0 = new Decimal(0),
	            xc = x['c'],
	            d = new Decimal(d1);

	        // NaN, Infinity.
	        if ( !xc ) {

	            return x.toString();
	        }

	        e = d['e'] = getCoeffLength(xc) - x['e'] - 1;
	        d['c'][0] = mathpow( 10, ( p = e % LOGBASE ) < 0 ? LOGBASE + p : p );

	        // If maxD is undefined or null...
	        if ( maxD == null ||

	             // or NaN...
	             ( !( id = 12, n = new Decimal(maxD) )['s'] ||

	               // or less than 1, or Infinity...
	               ( outOfRange = n['cmp'](n1) < 0 || !n['c'] ) ||

	                 // or not an integer...
	                 ( Decimal['errors'] && mathfloor( n['e'] / LOGBASE ) < n['c'].length - 1 ) ) &&

	                   // 'toFraction() max denominator not an integer: {maxD}'
	                   // 'toFraction() max denominator out of range: {maxD}'
	                   !ifExceptionsThrow( Decimal, 'max denominator', maxD, 'toFraction', 0 ) ||

	                     // or greater than the maximum denominator needed to specify the value exactly.
	                     ( maxD = n )['cmp'](d) > 0 ) {

	            // d is 10**e, n1 is 1.
	            maxD = e > 0 ? d : n1;
	        }

	        external = false;
	        n = new Decimal( coefficientToString(xc) );
	        p = Decimal['precision'];
	        Decimal['precision'] = e = xc.length * LOGBASE * 2;

	        for ( ; ; )  {
	            q = div( n, d, 0, 1, 1 );
	            d2 = d0['plus']( q['times'](d1) );

	            if ( d2['cmp'](maxD) == 1 ) {

	                break;
	            }
	            d0 = d1;
	            d1 = d2;

	            n1 = n0['plus']( q['times']( d2 = n1 ) );
	            n0 = d2;

	            d = n['minus']( q['times']( d2 = d ) );
	            n = d2;
	        }

	        d2 = div( maxD['minus'](d0), d1, 0, 1, 1 );
	        n0 = n0['plus']( d2['times'](n1) );
	        d0 = d0['plus']( d2['times'](d1) );
	        n0['s'] = n1['s'] = x['s'];

	        // Determine which fraction is closer to x, n0/d0 or n1/d1?
	        frac = div( n1, d1, e, 1 )['minus'](x)['abs']()['cmp'](
	               div( n0, d0, e, 1 )['minus'](x)['abs']() ) < 1
	          ? [ n1 + '', d1 + '' ]
	          : [ n0 + '', d0 + '' ];

	        external = true;
	        Decimal['precision'] = p;

	        return frac;
	    };


	    /*
	     * Returns a new Decimal whose value is the nearest multiple of the magnitude of n to the value
	     * of this Decimal.
	     *
	     * If the value of this Decimal is equidistant from two multiples of n, the rounding mode rm,
	     * or rounding if rm is omitted or is null or undefined, determines the direction of the
	     * nearest multiple.
	     *
	     * In the context of this method, rounding mode 4 (ROUND_HALF_UP) is the same as rounding mode 0
	     * (ROUND_UP), and so on.
	     *
	     * The return value will always have the same sign as this Decimal, unless either this Decimal
	     * or n is NaN, in which case the return value will be also be NaN.
	     *
	     * The return value is not rounded to precision significant digits.
	     *
	     * n {number|string|Decimal} The magnitude to round to a multiple of.
	     * [rm] {number} Rounding mode. Integer, 0 to 8 inclusive.
	     *
	     * 'toNearest() rounding mode not an integer: {rm}'
	     * 'toNearest() rounding mode out of range: {rm}'
	     *
	     */
	    P['toNearest'] = function ( n, rm ) {
	        var x = this,
	            Decimal = x['constructor'];

	        x = new Decimal(x);

	        if ( n == null ) {
	            n = new Decimal( Decimal['ONE'] );
	            rm = Decimal['rounding'];
	        } else {
	            id = 17;
	            n = new Decimal(n);
	            rm = checkRM( x, rm, 'toNearest' );
	        }

	        // If n is finite...
	        if ( n['c'] ) {

	           // If x is finite...
	            if ( x['c'] ) {

	                if ( n['c'][0] ) {
	                    external = false;
	                    x = div( x, n, 0, rm < 4 ? [4, 5, 7, 8][rm] : rm, 1 )['times'](n);
	                    external = true;
	                    rnd(x);
	                } else {
	                    x['c'] = [ x['e'] = 0 ];
	                }
	            }

	        // n is NaN or +-Infinity. If x is not NaN...
	        } else if ( x['s'] ) {

	            // If n is +-Infinity...
	            if ( n['s'] ) {
	                n['s'] = x['s'];
	            }
	            x = n;
	        }

	        return x;
	    };


	    /*
	     * Return the value of this Decimal converted to a number primitive.
	     *
	     */
	    P['toNumber'] = function () {
	        var x = this;

	        // Ensure zero has correct sign.
	        return +x || ( x['s'] ? 0 * x['s'] : NaN );
	    };


	    /*
	     * Return a new Decimal whose value is the value of this Decimal raised to the power
	     * Decimal(y, b), rounded to precision significant digits using rounding mode rounding.
	     *
	     * ECMAScript compliant.
	     *
	     *   x is any value, including NaN.
	     *   n is any number, including �Infinity unless stated.
	     *
	     *   pow( x, NaN )                           = NaN
	     *   pow( x, �0 )                            = 1

	     *   pow( NaN, nonzero )                     = NaN
	     *   pow( abs(n) > 1, +Infinity )            = +Infinity
	     *   pow( abs(n) > 1, -Infinity )            = +0
	     *   pow( abs(n) == 1, �Infinity )           = NaN
	     *   pow( abs(n) < 1, +Infinity )            = +0
	     *   pow( abs(n) < 1, -Infinity )            = +Infinity
	     *   pow( +Infinity, n > 0 )                 = +Infinity
	     *   pow( +Infinity, n < 0 )                 = +0
	     *   pow( -Infinity, odd integer > 0 )       = -Infinity
	     *   pow( -Infinity, even integer > 0 )      = +Infinity
	     *   pow( -Infinity, odd integer < 0 )       = -0
	     *   pow( -Infinity, even integer < 0 )      = +0
	     *   pow( +0, n > 0 )                        = +0
	     *   pow( +0, n < 0 )                        = +Infinity
	     *   pow( -0, odd integer > 0 )              = -0
	     *   pow( -0, even integer > 0 )             = +0
	     *   pow( -0, odd integer < 0 )              = -Infinity
	     *   pow( -0, even integer < 0 )             = +Infinity
	     *   pow( finite n < 0, finite non-integer ) = NaN
	     *
	     * For non-integer and larger exponents pow(x, y) is calculated using
	     *
	     *   x^y = exp(y*ln(x))
	     *
	     * Assuming the first 15 rounding digits are each equally likely to be any digit 0-9, the
	     * probability of an incorrectly rounded result
	     * P( [49]9{14} | [50]0{14} ) = 2 * 0.2 * 10^-14 = 4e-15 = 1/2.5e+14
	     * i.e. 1 in 250,000,000,000,000
	     *
	     * If a result is incorrectly rounded the maximum error will be 1 ulp (unit in last place).
	     *
	     * y {number|string|Decimal} The power to which to raise this Decimal.
	     * [b] {number} The base of y.
	     *
	     */
	    P['toPower'] = P['pow'] = function ( y, b ) {
	        var a, e, n, r,
	            x = this,
	            Decimal = x['constructor'],
	            s = x['s'],
	            yN = +( id = 13, y = new Decimal( y, b ) ),
	            i = yN < 0 ? -yN : yN,
	            pr = Decimal['precision'],
	            rm = Decimal['rounding'];

	        // Handle +-Infinity, NaN and +-0.
	        if ( !x['c'] || !y['c'] || ( n = !x['c'][0] ) || !y['c'][0] ) {

	            // valueOf -0 is 0, so check for 0 then multiply it by the sign.
	            return new Decimal( mathpow( n ? s * 0 : +x, yN ) );
	        }

	        x = new Decimal(x);
	        a = x['c'].length;

	        // if x == 1
	        if ( !x['e'] && x['c'][0] == x['s'] && a == 1 ) {

	            return x;
	        }

	        b = y['c'].length - 1;

	        // if y == 1
	        if ( !y['e'] && y['c'][0] == y['s'] && !b ) {
	            r = rnd( x, pr, rm );
	        } else {
	            e = mathfloor( y['e'] / LOGBASE );
	            n = e >= b;

	            // If y is not an integer and x is negative, return NaN.
	            if ( !n && s < 0 ) {
	                r = new Decimal(NaN);
	            } else {

	                /*
	                 If the approximate number of significant digits of x multiplied by abs(y) is less
	                 than INT_POW_LIMIT use the 'exponentiation by squaring' algorithm.
	                 */
	                if ( n && a * LOGBASE * i < INT_POW_LIMIT ) {
	                    r = intPow( Decimal, x, i );

	                    if ( y['s'] < 0 ) {

	                        return Decimal['ONE']['div'](r);
	                    }
	                } else {

	                    // Result is negative if x is negative and the last digit of integer y is odd.
	                    s = s < 0 && y['c'][ Math.max( e, b ) ] & 1 ? -1 : 1;

	                    b = mathpow( +x, yN );

	                    /*
	                     Estimate result exponent.
	                     x^y = 10^e,  where e = y * log10(x)
	                     log10(x) = log10(x_significand) + x_exponent
	                     log10(x_significand) = ln(x_significand) / ln(10)
	                     */
	                    e = b == 0 || !isFinite(b)
	                      ? mathfloor( yN * ( Math.log( '0.' + coefficientToString( x['c'] ) ) /
	                        Math.LN10 + x['e'] + 1 ) )
	                      : new Decimal( b + '' )['e'];

	                    // Estimate may be incorrect e.g. x: 0.999999999999999999, y: 2.29, e: 0, r.e:-1

	                    // Overflow/underflow?
	                    if ( e > Decimal['maxE'] + 1 || e < Decimal['minE'] - 1 ) {

	                        return new Decimal( e > 0 ? s / 0 : 0 );
	                    }

	                    external = false;
	                    Decimal['rounding'] = x['s'] = 1;

	                    /*
	                     Estimate extra digits needed from ln(x) to ensure five correct rounding digits
	                     in result (i was unnecessary before max exponent was extended?).
	                     Example of failure before i was introduced: (precision: 10),
	                     new Decimal(2.32456).pow('2087987436534566.46411')
	                     should be 1.162377823e+764914905173815, but is 1.162355823e+764914905173815
	                     */
	                    i = Math.min( 12, ( e + '' ).length );

	                    // r = x^y = exp(y*ln(x))
	                    r = exp( y['times']( ln( x, pr + i ) ), pr );

	                    // Truncate to the required precision plus five rounding digits.
	                    r = rnd( r, pr + 5, 1 );

	                    /*
	                     If the rounding digits are [49]9999 or [50]0000 increase the precision by 10
	                     and recalculate the result.
	                     */
	                    if ( checkRoundingDigits( r['c'], pr, rm ) ) {
	                        e = pr + 10;

	                        // Truncate to the increased precision plus five rounding digits.
	                        r = rnd( exp( y['times']( ln( x, e + i ) ), e ), e + 5, 1 );

	                        /*
	                          Check for 14 nines from the 2nd rounding digit (the first rounding digit
	                          may be 4 or 9).
	                         */
	                        if ( +coefficientToString( r['c'] ).slice( pr + 1, pr + 15 ) + 1 == 1e14 ) {
	                            r = rnd( r, pr + 1, 0 );
	                        }
	                    }

	                    r['s'] = s;
	                    external = true;
	                    Decimal['rounding'] = rm;
	                }

	                r = rnd( r, pr, rm );
	            }
	        }

	        return r;
	    };


	    /*
	     * Return a string representing the value of this Decimal rounded to sd significant digits
	     * using rounding mode rounding.
	     *
	     * Return exponential notation if sd is less than the number of digits necessary to represent
	     * the integer part of the value in normal notation.
	     *
	     * sd {number} Significant digits. Integer, 1 to MAX_DIGITS inclusive.
	     * [rm] {number} Rounding mode. Integer, 0 to 8 inclusive.
	     *
	     * errors true: Throw if sd and rm are not undefined, null or integers in range.
	     * errors false: Ignore sd and rm if not numbers or not in range, and truncate non-integers.
	     *
	     * 'toPrecision() sd not an integer: {sd}'
	     * 'toPrecision() sd out of range: {sd}'
	     * 'toPrecision() rounding mode not an integer: {rm}'
	     * 'toPrecision() rounding mode out of range: {rm}'
	     *
	     */
	    P['toPrecision'] = function ( sd, rm ) {
	        var x = this;

	        return sd != null && checkArg( x, sd, 'toPrecision', 1 ) && x['c']
	          ? format( x, --sd | 0, checkRM( x, rm, 'toPrecision' ), 2 )
	          : x.toString();
	    };


	    /*
	     * Return a new Decimal whose value is this Decimal rounded to a maximum of d significant
	     * digits using rounding mode rm, or to precision and rounding respectively if omitted.
	     *
	     * [d] {number} Significant digits. Integer, 1 to MAX_DIGITS inclusive.
	     * [rm] {number} Rounding mode. Integer, 0 to 8 inclusive.
	     *
	     * 'toSD() digits out of range: {d}'
	     * 'toSD() digits not an integer: {d}'
	     * 'toSD() rounding mode not an integer: {rm}'
	     * 'toSD() rounding mode out of range: {rm}'
	     *
	     */
	    P['toSignificantDigits'] = P['toSD'] = function ( d, rm ) {
	        var x = this,
	            Decimal = x['constructor'];

	        x = new Decimal(x);

	        return d == null || !checkArg( x, d, 'toSD', 1 )
	          ? rnd( x, Decimal['precision'], Decimal['rounding'] )
	          : rnd( x, d | 0, checkRM( x, rm, 'toSD' ) );
	    };


	    /*
	     * Return a string representing the value of this Decimal in base b, or base 10 if b is
	     * omitted. If a base is specified, including base 10, round to precision significant digits
	     * using rounding mode rounding.
	     *
	     * Return exponential notation if a base is not specified, and this Decimal has a positive
	     * exponent equal to or greater than toExpPos, or a negative exponent equal to or less than
	     * toExpNeg.
	     *
	     * [b] {number} Base. Integer, 2 to 64 inclusive.
	     *
	     */
	     P['toString'] = function (b) {
	        var u, str, strL,
	            x = this,
	            Decimal = x['constructor'],
	            xe = x['e'];

	        // Infinity or NaN?
	        if ( xe === null ) {
	            str = x['s'] ? 'Infinity' : 'NaN';

	        // Exponential format?
	        } else if ( b === u && ( xe <= Decimal['toExpNeg'] || xe >= Decimal['toExpPos'] ) ) {

	            return format( x, null, Decimal['rounding'], 1 );
	        } else {
	            str = coefficientToString( x['c'] );

	            // Negative exponent?
	            if ( xe < 0 ) {

	                // Prepend zeros.
	                for ( ; ++xe; str = '0' + str );
	                str = '0.' + str;

	            // Positive exponent?
	            } else if ( strL = str.length, xe > 0 ) {

	                if ( ++xe > strL ) {

	                    // Append zeros.
	                    for ( xe -= strL; xe-- ; str += '0' );

	                } else if ( xe < strL ) {
	                    str = str.slice( 0, xe ) + '.' + str.slice(xe);
	                }

	            // Exponent zero.
	            } else {
	                u = str.charAt(0);

	                if ( strL > 1 ) {
	                    str = u + '.' + str.slice(1);

	                // Avoid '-0'
	                } else if ( u == '0' ) {

	                    return u;
	                }
	            }

	            if ( b != null ) {

	                if ( !( outOfRange = !( b >= 2 && b < 65 ) ) &&
	                  ( b == (b | 0) || !Decimal['errors'] ) ) {
	                    str = convertBase( Decimal, str, b | 0, 10, x['s'] );

	                    // Avoid '-0'
	                    if ( str == '0' ) {

	                        return str;
	                    }
	                } else {

	                    // 'toString() base not an integer: {b}'
	                    // 'toString() base out of range: {b}'
	                    ifExceptionsThrow( Decimal, 'base', b, 'toString', 0 );
	                }
	            }
	        }

	        return x['s'] < 0 ? '-' + str : str;
	    };


	    /*
	     * Return a new Decimal whose value is the value of this Decimal truncated to a whole number.
	     *
	     */
	    P['truncated'] = P['trunc'] = function () {

	        return rnd( new this['constructor'](this), this['e'] + 1, 1 );
	    };


	    /*
	     * Return as toString, but do not accept a base argument.
	     *
	     * Ensures that JSON.stringify() uses toString for serialization.
	     *
	     */
	    P['valueOf'] = P['toJSON'] = function () {

	        return this.toString();
	    };


	    /*
	    // Add aliases to match BigDecimal method names.
	    P['add'] = P['plus'];
	    P['subtract'] = P['minus'];
	    P['multiply'] = P['times'];
	    P['divide'] = P['div'];
	    P['remainder'] = P['mod'];
	    P['compareTo'] = P['cmp'];
	    P['negate'] = P['neg'];
	     */


	    // Private functions for Decimal.prototype methods.


	    /*
	     *  coefficientToString
	     *  checkRoundingDigits
	     *  checkRM
	     *  checkArg
	     *  convertBase
	     *  div
	     *  exp
	     *  format
	     *  getCoeffLength
	     *  ifExceptionsThrow
	     *  intPow
	     *  ln
	     *  rnd
	     */


	    function coefficientToString(a) {
	        var s, z,
	            i = 1,
	            j = a.length,
	            r = a[0] + '';

	        for ( ; i < j; i++ ) {
	            s = a[i] + '';

	            for ( z = LOGBASE - s.length; z--; ) {
	                s = '0' + s;
	            }

	            r += s;
	        }

	        // '0'
	        for ( j = r.length; r.charCodeAt(--j) === 48; );

	        return r.slice( 0, j + 1 || 1 );
	    }


	    /*
	     * Check 5 rounding digits if repeating is null, 4 otherwise.
	     * repeating == null if caller is log or pow,
	     * repeating != null if caller is ln or exp.
	     *
	     *
	     // Previous, much simpler implementation when coefficient was base 10.
	     function checkRoundingDigits( c, i, rm, repeating ) {
	         return ( !repeating && rm > 3 && c[i] == 4 ||
	           ( repeating || rm < 4 ) && c[i] == 9 ) && c[i + 1] == 9 && c[i + 2] == 9 &&
	             c[i + 3] == 9 && ( repeating != null || c[i + 4] == 9 ) ||
	               repeating == null && ( c[i] == 5 || !c[i] ) && !c[i + 1] && !c[i + 2] &&
	                 !c[i + 3] && !c[i + 4];
	     }
	     */
	    function checkRoundingDigits( c, i, rm, repeating ) {
	        var ci, k, n, r, rd;

	        // Get the length of the first element of the array c.
	        for ( k = 1, n = c[0]; n >= 10; n /= 10, k++ );

	        n = i - k;

	        // Is the rounding digit in the first element of c?
	        if ( n < 0 ) {
	            n += LOGBASE;
	            ci = 0;
	        } else {
	            ci = Math.ceil( ( n + 1 ) / LOGBASE );
	            n %= LOGBASE;
	        }

	        k = mathpow( 10, LOGBASE - n );
	        rd = c[ci] % k | 0;

	        if ( repeating == null ) {

	            if ( n < 3 ) {

	                if ( n == 0 ) {
	                    rd = rd / 100 | 0;
	                } else if ( n == 1 ) {
	                    rd = rd / 10 | 0;
	                }

	                r = rm < 4 && rd == 99999 || rm > 3 && rd == 49999 || rd == 50000 || rd == 0;
	            } else {
	                r = ( rm < 4 && rd + 1 == k || rm > 3 && rd + 1 == k / 2 ) &&
	                    ( c[ci + 1] / k / 100 | 0 ) == mathpow( 10, n - 2 ) - 1 ||
	                        ( rd == k / 2 || rd == 0 ) && ( c[ci + 1] / k / 100 | 0 ) == 0;
	            }
	        } else {

	            if ( n < 4 ) {

	                if ( n == 0 ) {
	                    rd = rd / 1000 | 0;
	                } else if ( n == 1 ) {
	                    rd = rd / 100 | 0;
	                } else if ( n == 2 ) {
	                    rd = rd / 10 | 0;
	                }

	                r = ( repeating || rm < 4 ) && rd == 9999 || !repeating && rm > 3 && rd == 4999;
	            } else {
	                r = ( ( repeating || rm < 4 ) && rd + 1 == k ||
	                ( !repeating && rm > 3 ) && rd + 1 == k / 2 ) &&
	                    ( c[ci + 1] / k / 1000 | 0 ) == mathpow( 10, n - 3 ) - 1;
	            }
	        }

	        return r;
	    }


	    /*
	     * Check and return rounding mode. If rm is invalid, return rounding mode rounding.
	     */
	    function checkRM( x, rm, method ) {
	        var Decimal = x['constructor'];

	        return rm == null || ( ( outOfRange = rm < 0 || rm > 8 ) ||
	          rm !== 0 && ( Decimal['errors'] ? parseInt : parseFloat )(rm) != rm ) &&
	            !ifExceptionsThrow( Decimal, 'rounding mode', rm, method, 0 )
	              ? Decimal['rounding'] : rm | 0;
	    }


	    /*
	     * Check that argument n is in range, return true or false.
	     */
	    function checkArg( x, n, method, min ) {
	        var Decimal = x['constructor'];

	        return !( outOfRange = n < ( min || 0 ) || n >= MAX_DIGITS + 1 ) &&

	          /*
	           * Include 'n === 0' because Opera has 'parseFloat(-0) == -0' as false
	           * despite having 'parseFloat(-0) === -0 && parseFloat('-0') === -0 && 0 == -0' as true.
	           */
	          ( n === 0 || ( Decimal['errors'] ? parseInt : parseFloat )(n) == n ) ||
	            ifExceptionsThrow( Decimal, 'argument', n, method, 0 );
	    }


	    /*
	     * Convert a numeric string of baseIn to a numeric string of baseOut.
	     */
	    convertBase = (function () {

	        /*
	         * Convert string of baseIn to an array of numbers of baseOut.
	         * Eg. convertBase('255', 10, 16) returns [15, 15].
	         * Eg. convertBase('ff', 16, 10) returns [2, 5, 5].
	         */
	        function toBaseOut( str, baseIn, baseOut ) {
	            var j,
	                arr = [0],
	                arrL,
	                i = 0,
	                strL = str.length;

	            for ( ; i < strL; ) {
	                for ( arrL = arr.length; arrL--; arr[arrL] *= baseIn );
	                arr[ j = 0 ] += NUMERALS.indexOf( str.charAt( i++ ) );

	                for ( ; j < arr.length; j++ ) {

	                    if ( arr[j] > baseOut - 1 ) {

	                        if ( arr[j + 1] == null ) {
	                            arr[j + 1] = 0;
	                        }
	                        arr[j + 1] += arr[j] / baseOut | 0;
	                        arr[j] %= baseOut;
	                    }
	                }
	            }

	            return arr.reverse();
	        }

	        return function ( Decimal, str, baseOut, baseIn, sign ) {
	            var e, j, r, x, xc, y,
	                i = str.indexOf( '.' ),
	                pr = Decimal['precision'],
	                rm = Decimal['rounding'];

	            if ( baseIn < 37 ) {
	                str = str.toLowerCase();
	            }

	            // Non-integer.
	            if ( i >= 0 ) {
	                str = str.replace( '.', '' );
	                y = new Decimal(baseIn);
	                x = intPow( Decimal, y, str.length - i );

	                /*
	                 Convert str as if an integer, then divide the result by its base raised to a power
	                 such that the fraction part will be restored.
	                 Use toFixed to avoid possible exponential notation.
	                 */
	                y['c'] = toBaseOut( x.toFixed(), 10, baseOut );
	                y['e'] = y['c'].length;
	            }

	            // Convert the number as integer.
	            xc = toBaseOut( str, baseIn, baseOut );
	            e = j = xc.length;

	            // Remove trailing zeros.
	            for ( ; xc[--j] == 0; xc.pop() );

	            if ( !xc[0] ) {

	                return '0';
	            }

	            if ( i < 0 ) {
	                e--;
	            } else {
	                x['c'] = xc;
	                x['e'] = e;

	                // sign is needed for correct rounding.
	                x['s'] = sign;
	                x = div( x, y, pr, rm, 0, baseOut );
	                xc = x['c'];
	                r = x['r'];
	                e = x['e'];
	            }

	            // The rounding digit, i.e. the digit after the digit that may be rounded up.
	            i = xc[pr];
	            j = baseOut / 2;
	            r = r || xc[pr + 1] != null;

	            if ( rm < 4
	              ? ( i != null || r ) && ( rm == 0 || rm == ( x['s'] < 0 ? 3 : 2 ) )
	              : i > j || i == j && ( rm == 4 || r || rm == 6 && xc[pr - 1] & 1 ||
	                rm == ( x['s'] < 0 ? 8 : 7 ) ) ) {

	                xc.length = pr;

	                // Rounding up may mean the previous digit has to be rounded up and so on.
	                for ( --baseOut; ++xc[--pr] > baseOut; ) {
	                    xc[pr] = 0;

	                    if ( !pr ) {
	                        ++e;
	                        xc.unshift(1);
	                    }
	                }
	            } else {
	                xc.length = pr;
	            }

	            // Determine trailing zeros.
	            for ( j = xc.length; !xc[--j]; );

	            // E.g. [4, 11, 15] becomes 4bf.
	            for ( i = 0, str = ''; i <= j; str += NUMERALS.charAt( xc[i++] ) );

	            // Negative exponent?
	            if ( e < 0 ) {

	                // Prepend zeros.
	                for ( ; ++e; str = '0' + str );

	                str = '0.' + str;

	            // Positive exponent?
	            } else {
	                i = str.length;

	                if ( ++e > i ) {

	                    // Append zeros.
	                    for ( e -= i; e-- ; str += '0' );

	                } else if ( e < i ) {
	                    str = str.slice( 0, e ) + '.' + str.slice(e);
	                }
	            }

	            // No negative numbers: the caller will add the sign.
	            return str;
	        };
	    })();


	    /*
	     * Perform division in the specified base. Called by div and convertBase.
	     */
	    var div = ( function () {

	        // Assumes non-zero x and k, and hence non-zero result.
	        function multiplyInteger( x, k, base ) {
	            var temp,
	                carry = 0,
	                i = x.length;

	            for ( x = x.slice(); i--; ) {
	                temp = x[i] * k + carry;
	                x[i] = temp % base | 0;
	                carry = temp / base | 0;
	            }

	            if (carry) {
	                x.unshift(carry);
	            }

	            return x;
	        }

	        function compare( a, b, aL, bL ) {
	            var i, cmp;

	            if ( aL != bL ) {
	                cmp = aL > bL ? 1 : -1;
	            } else {

	                for ( i = cmp = 0; i < aL; i++ ) {

	                    if ( a[i] != b[i] ) {
	                        cmp = a[i] > b[i] ? 1 : -1;

	                        break;
	                    }
	                }
	            }

	            return cmp;
	        }

	        function subtract( a, b, aL, base ) {
	            var i = 0;

	            // Subtract b from a.
	            for ( ; aL--; ) {
	                a[aL] -= i;
	                i = a[aL] < b[aL] ? 1 : 0;
	                a[aL] = i * base + a[aL] - b[aL];
	            }

	            // Remove leading zeros.
	            for ( ; !a[0] && a.length > 1; a.shift() );
	        }

	        // x: dividend, y: divisor.
	        return function ( x, y, pr, rm, dp, base ) {
	            var cmp, e, i, logbase, more, n, prod, prodL, q, qc, rem, remL, rem0, t, xi, xL, yc0,
	                yL, yz,
	                Decimal = x['constructor'],
	                s = x['s'] == y['s'] ? 1 : -1,
	                xc = x['c'],
	                yc = y['c'];

	            // Either NaN, Infinity or 0?
	            if ( !xc || !xc[0] || !yc || !yc[0] ) {

	                return new Decimal(

	                  // Return NaN if either NaN, or both Infinity or 0.
	                  !x['s'] || !y['s'] || ( xc ? yc && xc[0] == yc[0] : !yc ) ? NaN :

	                    // Return +-0 if x is 0 or y is +-Infinity, or return +-Infinity as y is 0.
	                    xc && xc[0] == 0 || !yc ? s * 0 : s / 0
	                );
	            }

	            if (base) {
	                logbase = 1;
	                e = x['e'] - y['e'];
	            } else {
	                base = BASE;
	                logbase = LOGBASE;
	                e = mathfloor( x['e'] / logbase ) - mathfloor( y['e'] / logbase );
	            }

	            yL = yc.length;
	            xL = xc.length;
	            q = new Decimal(s);
	            qc = q['c'] = [];

	            // Result exponent may be one less then the current value of e.
	            // The coefficients of the Decimals from convertBase may have trailing zeros.
	            for ( i = 0; yc[i] == ( xc[i] || 0 ); i++ );

	            if ( yc[i] > ( xc[i] || 0 ) ) {
	                e--;
	            }

	            if ( pr == null ) {
	                s = pr = Decimal['precision'];
	                rm = Decimal['rounding'];
	            } else if (dp) {
	                s = pr + ( x['e'] - y['e'] ) + 1;
	            } else {
	                s = pr;
	            }

	            if ( s < 0 ) {
	                qc.push(1);
	                more = true;
	            } else {

	                // Convert base 10 decimal places to base 1e7 decimal places.
	                s = s / logbase + 2 | 0;
	                i = 0;

	                // divisor < 1e7
	                if ( yL == 1 ) {
	                    n = 0;
	                    yc = yc[0];
	                    s++;

	                    // 'n' is the carry.
	                    for ( ; ( i < xL || n ) && s--; i++ ) {
	                        t = n * base + ( xc[i] || 0 );
	                        qc[i] = t / yc | 0;
	                        n = t % yc | 0;
	                    }

	                    more = n || i < xL;

	                // divisor >= 1e7
	                } else {

	                    // Normalise xc and yc so highest order digit of yc is >= base/2
	                    n = base / ( yc[0] + 1 ) | 0;

	                    if ( n > 1 ) {
	                        yc = multiplyInteger( yc, n, base );
	                        xc = multiplyInteger( xc, n, base );
	                        yL = yc.length;
	                        xL = xc.length;
	                    }

	                    xi = yL;
	                    rem = xc.slice( 0, yL );
	                    remL = rem.length;

	                    // Add zeros to make remainder as long as divisor.
	                    for ( ; remL < yL; rem[remL++] = 0 );

	                    yz = yc.slice();
	                    yz.unshift(0);
	                    yc0 = yc[0];

	                    if ( yc[1] >= base / 2 ) {
	                        yc0++;
	                    }

	                    do {
	                        n = 0;

	                        // Compare divisor and remainder.
	                        cmp = compare( yc, rem, yL, remL );

	                        // If divisor < remainder.
	                        if ( cmp < 0 ) {

	                            // Calculate trial digit, n.
	                            rem0 = rem[0];

	                            if ( yL != remL ) {
	                                rem0 = rem0 * base + ( rem[1] || 0 );
	                            }

	                            // n will be how many times the divisor goes into the current remainder.
	                            n = rem0 / yc0 | 0;

	                            /*
	                              Algorithm:
	                              1. product = divisor * trial digit (n)
	                              2. if product > remainder: product -= divisor, n--
	                              3. remainder -= product
	                              4. if product was < remainder at 2:
	                                5. compare new remainder and divisor
	                                6. If remainder > divisor: remainder -= divisor, n++
	                            */

	                            if ( n > 1 ) {

	                                if ( n >= base ) {
	                                    n = base - 1;
	                                }

	                                // product = divisor * trial digit.
	                                prod = multiplyInteger( yc, n, base );
	                                prodL = prod.length;
	                                remL = rem.length;

	                                // Compare product and remainder.
	                                cmp = compare( prod, rem, prodL, remL );

	                                // product > remainder.
	                                if ( cmp == 1 ) {
	                                    n--;

	                                    // Subtract divisor from product.
	                                    subtract( prod, yL < prodL ? yz : yc, prodL, base );
	                                }
	                            } else {

	                                // cmp is -1.
	                                // If n is 0, there is no need to compare yc and rem again below, so change cmp to 1 to avoid it.
	                                // If n is 1 there IS a need to compare yc and rem again below.
	                                if ( n == 0 ) {
	                                    cmp = n = 1;
	                                }
	                                prod = yc.slice();
	                            }
	                            prodL = prod.length;

	                            if ( prodL < remL ) {
	                                prod.unshift(0);
	                            }

	                            // Subtract product from remainder.
	                            subtract( rem, prod, remL, base );

	                            // If product was < previous remainder.
	                            if ( cmp == -1 ) {
	                                remL = rem.length;

	                                // Compare divisor and new remainder.
	                                cmp = compare( yc, rem, yL, remL );

	                                // If divisor < new remainder, subtract divisor from remainder.
	                                if ( cmp < 1 ) {
	                                    n++;

	                                    // Subtract divisor from remainder.
	                                    subtract( rem, yL < remL ? yz : yc, remL, base );
	                                }
	                            }

	                            remL = rem.length;

	                        } else if ( cmp === 0 ) {
	                            n++;
	                            rem = [0];
	                        }    // if cmp === 1, n will be 0

	                        // Add the next digit, n, to the result array.
	                        qc[i++] = n;

	                        // Update the remainder.
	                        if ( cmp && rem[0] ) {
	                            rem[remL++] = xc[xi] || 0;
	                        } else {
	                            rem = [ xc[xi] ];
	                            remL = 1;
	                        }

	                    } while ( ( xi++ < xL || rem[0] != null ) && s-- );

	                    more = rem[0] != null;
	                }

	                // Leading zero?
	                if ( !qc[0] ) {
	                    qc.shift();
	                }
	            }

	            // If div is being used for base conversion.
	            if ( logbase == 1 ) {
	                q['e'] = e;
	                q['r'] = +more;
	            } else {

	                // To calculate q.e, first get the number of digits of qc[0].
	                for ( i = 1, s = qc[0]; s >= 10; s /= 10, i++ );
	                q['e'] = i + e * logbase - 1;

	                rnd( q, dp ? pr + q['e'] + 1 : pr, rm, more );
	            }

	            return q;
	        };
	    })();


	    /*
	     * Taylor/Maclaurin series.
	     *
	     * exp(x) = x^0/0! + x^1/1! + x^2/2! + x^3/3! + ...
	     *
	     * Argument reduction:
	     *   Repeat x = x / 32, k += 5, until |x| < 0.1
	     *   exp(x) = exp(x / 2^k)^(2^k)
	     *
	     * Previously, the argument was initially reduced by
	     * exp(x) = exp(r) * 10^k  where r = x - k * ln10, k = floor(x / ln10)
	     * to first put r in the range [0, ln10], before dividing by 32 until |x| < 0.1, but this was
	     * found to be slower than just dividing repeatedly by 32 as above.
	     *
	     * Max integer argument: exp('20723265836946413') = 6.3e+9000000000000000
	     * Min integer argument: exp('-20723265836946411') = 1.2e-9000000000000000
	     * ( Math object integer min/max: Math.exp(709) = 8.2e+307, Math.exp(-745) = 5e-324 )
	     *
	     *  exp(Infinity)  = Infinity
	     *  exp(-Infinity) = 0
	     *  exp(NaN)       = NaN
	     *  exp(+-0)       = 1
	     *
	     *  exp(x) is non-terminating for any finite, non-zero x.
	     *
	     *  The result will always be correctly rounded.
	     *
	     */
	    function exp( x, pr ) {
	        var denom, guard, j, pow, sd, sum, t,
	            rep = 0,
	            i = 0,
	            k = 0,
	            Decimal = x['constructor'],
	            one = Decimal['ONE'],
	            rm = Decimal['rounding'],
	            precision = Decimal['precision'];

	        // 0/NaN/Infinity?
	        if ( !x['c'] || !x['c'][0] || x['e'] > 17 ) {

	            return new Decimal( x['c']
	              ? !x['c'][0] ? one : x['s'] < 0 ? 0 : 1 / 0
	              : x['s'] ? x['s'] < 0 ? 0 : x : NaN );
	        }

	        if ( pr == null ) {

	            /*
	             Estimate result exponent.
	             e^x = 10^j, where j = x * log10(e) and
	             log10(e) = ln(e) / ln(10) = 1 / ln(10),
	             so j = x / ln(10)
	            j = mathfloor( x / Math.LN10 );

	            // Overflow/underflow? Estimate may be +-1 of true value.
	            if ( j > Decimal['maxE'] + 1 || j < Decimal['minE'] - 1 ) {

	                return new Decimal( j > 0 ? 1 / 0 : 0 );
	            }
	             */

	            external = false;
	            sd = precision;
	        } else {
	            sd = pr;
	        }

	        t = new Decimal(0.03125);

	        // while abs(x) >= 0.1
	        while ( x['e'] > -2 ) {

	            // x = x / 2^5
	            x = x['times'](t);
	            k += 5;
	        }

	        /*
	         Use 2 * log10(2^k) + 5 to estimate the increase in precision necessary to ensure the first
	         4 rounding digits are correct.
	         */
	        guard = Math.log( mathpow( 2, k ) ) / Math.LN10 * 2 + 5 | 0;
	        sd += guard;

	        denom = pow = sum = new Decimal(one);
	        Decimal['precision'] = sd;

	        for ( ; ; ) {
	            pow = rnd( pow['times'](x), sd, 1 );
	            denom = denom['times'](++i);
	            t = sum['plus']( div( pow, denom, sd, 1 ) );

	            if ( coefficientToString( t['c'] ).slice( 0, sd ) ===
	                 coefficientToString( sum['c'] ).slice( 0, sd ) ) {
	                j = k;

	                while ( j-- ) {
	                    sum = rnd( sum['times'](sum), sd, 1 );
	                }

	                /*
	                 Check to see if the first 4 rounding digits are [49]999.
	                 If so, repeat the summation with a higher precision, otherwise
	                 E.g. with precision: 18, rounding: 1
	                 exp(18.404272462595034083567793919843761) = 98372560.1229999999
	                                           when it should be 98372560.123

	                 sd - guard is the index of first rounding digit.
	                 */
	                if ( pr == null ) {

	                    if ( rep < 3 && checkRoundingDigits( sum['c'], sd - guard, rm, rep ) ) {
	                        Decimal['precision'] = sd += 10;
	                        denom = pow = t = new Decimal(one);
	                        i = 0;
	                        rep++;
	                    } else {

	                        return rnd( sum, Decimal['precision'] = precision, rm, external = true );
	                    }
	                } else {
	                    Decimal['precision'] = precision;

	                    return sum;
	                }
	            }
	            sum = t;
	        }
	    }


	    /*
	     * Return a string representing the value of Decimal n in normal or exponential notation
	     * rounded to the specified decimal places or significant digits.
	     * Called by toString, toExponential (k is 1), toFixed, and toPrecision (k is 2).
	     * i is the index (with the value in normal notation) of the digit that may be rounded up.
	     * j is the rounding mode, then the number of digits required including fraction-part trailing
	     * zeros.
	     */
	    function format( n, i, j, k ) {
	        var s, z,
	            Decimal = n['constructor'],
	            e = ( n = new Decimal(n) )['e'];

	        // i == null when toExponential(no arg), or toString() when x >= toExpPos etc.
	        if ( i == null ) {
	            j = 0;
	        } else {
	            rnd( n, ++i, j );

	            // If toFixed, n['e'] may have changed if the value was rounded up.
	            j = k ? i : i + n['e'] - e;
	        }

	        e = n['e'];
	        s = coefficientToString( n['c'] );

	        /*
	         toPrecision returns exponential notation if the number of significant digits specified
	         is less than the number of digits necessary to represent the integer part of the value
	         in normal notation.
	         */

	        // Exponential notation.
	        if ( k == 1 || k == 2 && ( i <= e || e <= Decimal['toExpNeg'] ) ) {

	            // Append zeros?
	            for ( ; s.length < j; s += '0' );

	            if ( s.length > 1 ) {
	                s = s.charAt(0) + '.' + s.slice(1);
	            }

	            s += ( e < 0 ? 'e' : 'e+' ) + e;

	        // Normal notation.
	        } else {
	            k = s.length;

	            // Negative exponent?
	            if ( e < 0 ) {
	                z = j - k;

	                // Prepend zeros.
	                for ( ; ++e; s = '0' + s );
	                s = '0.' + s;

	            // Positive exponent?
	            } else {

	                if ( ++e > k ) {
	                    z = j - e;

	                    // Append zeros.
	                    for ( e -= k; e-- ; s += '0' );

	                    if ( z > 0 ) {
	                        s += '.';
	                    }

	                } else {
	                    z = j - k;

	                    if ( e < k ) {
	                        s = s.slice( 0, e ) + '.' + s.slice(e);
	                    } else if ( z > 0 ) {
	                        s += '.';
	                    }
	                }
	            }

	            // Append more zeros?
	            if ( z > 0 ) {

	                for ( ; z--; s += '0' );
	            }
	        }

	        return n['s'] < 0 && n['c'][0] ? '-' + s : s;
	    }


	    function getCoeffLength(c) {
	        var v = c.length - 1,
	            n = v * LOGBASE + 1;

	        if ( v = c[v] ) {

	            // Subtract the number of trailing zeros of the last number.
	            for ( ; v % 10 == 0; v /= 10, n-- );

	            // Add the number of digits of the first number.
	            for ( v = c[0]; v >= 10; v /= 10, n++ );
	        }

	        return n;
	    }


	    /*
	     * Assemble error messages. Throw Decimal Errors.
	     */
	    function ifExceptionsThrow( Decimal, message, arg, method, more ) {

	        if ( Decimal['errors'] ) {
	            var error = new Error( ( method || [
	              'new Decimal', 'cmp', 'div', 'eq', 'gt', 'gte', 'lt', 'lte', 'minus', 'mod',
	              'plus', 'times', 'toFraction', 'pow', 'random', 'log', 'sqrt', 'toNearest', 'divToInt'
	              ][ id ? id < 0 ? -id : id : 1 / id < 0 ? 1 : 0 ] ) + '() ' + ( [
	              'number type has more than 15 significant digits', 'LN10 out of digits' ][message]
	              || message + ( [ outOfRange ? ' out of range' : ' not an integer',
	              ' not a boolean or binary digit' ][more] || '' ) ) + ': ' + arg
	            );
	            error['name'] = 'Decimal Error';
	            outOfRange = id = 0;

	            throw error;
	        }
	    }


	    /*
	     * Use 'exponentiation by squaring' for small integers. Called by convertBase and pow.
	     */
	    function intPow( Decimal, x, i ) {
	        var r = new Decimal( Decimal['ONE'] );

	        for ( external = false; ; ) {

	            if ( i & 1 ) {
	                r = r['times'](x);
	            }
	            i >>= 1;

	            if ( !i ) {

	                break;
	            }
	            x = x['times'](x);
	        }
	        external = true;

	        return r;
	    }


	    /*
	     *  ln(-n)        = NaN
	     *  ln(0)         = -Infinity
	     *  ln(-0)        = -Infinity
	     *  ln(1)         = 0
	     *  ln(Infinity)  = Infinity
	     *  ln(-Infinity) = NaN
	     *  ln(NaN)       = NaN
	     *
	     *  ln(n) (n != 1) is non-terminating.
	     *
	     */
	    function ln( y, pr ) {
	        var c, c0, denom, e, num, rep, sd, sum, t, x1, x2,
	            n = 1,
	            guard = 10,
	            x = y,
	            xc = x['c'],
	            Decimal = x['constructor'],
	            one = Decimal['ONE'],
	            rm = Decimal['rounding'],
	            precision = Decimal['precision'];

	        // x < 0 or +-Infinity/NaN or 0 or 1.
	        if ( x['s'] < 0 || !xc || !xc[0] || !x['e'] && xc[0] == 1 && xc.length == 1 ) {

	            return new Decimal( xc && !xc[0] ? -1 / 0 : x['s'] != 1 ? NaN : xc ? 0 : x );
	        }

	        if ( pr == null ) {
	            external = false;
	            sd = precision;
	        } else {
	            sd = pr;
	        }

	        Decimal['precision'] = sd += guard;

	        c = coefficientToString(xc);
	        c0 = c.charAt(0);

	        if ( Math.abs( e = x['e'] ) < 1.5e15 ) {

	            /*
	             Argument reduction.
	             The series converges faster the closer the argument is to 1, so using
	             ln(a^b) = b * ln(a),   ln(a) = ln(a^b) / b
	             multiply the argument by itself until the leading digits of the significand are 7, 8,
	             9, 10, 11, 12 or 13, recording the number of multiplications so the sum of the series
	             can later be divided by this number, then separate out the power of 10 using
	             ln(a*10^b) = ln(a) + b*ln(10).
	             */

	            // max n is 21 ( gives 0.9, 1.0 or 1.1 ) ( 9e15 / 21 = 4.2e14 ).
	            //while ( c0 < 9 && c0 != 1 || c0 == 1 && c.charAt(1) > 1 ) {
	            // max n is 6 ( gives 0.7 - 1.3 )
	            while ( c0 < 7 && c0 != 1 || c0 == 1 && c.charAt(1) > 3 ) {
	                x = x['times'](y);
	                c = coefficientToString( x['c'] );
	                c0 = c.charAt(0);
	                n++;
	            }

	            e = x['e'];

	            if ( c0 > 1 ) {
	                x = new Decimal( '0.' + c );
	                e++;
	            } else {
	                x = new Decimal( c0 + '.' + c.slice(1) );
	            }
	        } else {

	            /*
	             The argument reduction method above may result in overflow if the argument y is a
	             massive number with exponent >= 1500000000000000 ( 9e15 / 6 = 1.5e15 ), so instead
	             recall this function using ln(x*10^e) = ln(x) + e*ln(10).
	             */
	            x = new Decimal( c0 + '.' + c.slice(1) );

	            if ( sd + 2 > LN10.length ) {
	                ifExceptionsThrow( Decimal, 1, sd + 2, 'ln' );
	            }

	            x = ln( x, sd - guard )['plus'](
	                new Decimal( LN10.slice( 0, sd + 2 ) )['times']( e + '' )
	            );

	            Decimal['precision'] = precision;

	            return pr == null ? rnd( x, precision, rm, external = true ) : x;
	        }

	        // x1 is x reduced to a value near 1.
	        x1 = x;

	        /*
	         Taylor series.
	         ln(y) = ln( (1 + x)/(1 - x) ) = 2( x + x^3/3 + x^5/5 + x^7/7 + ... )
	         where
	         x = (y - 1)/(y + 1)              ( |x| < 1 )
	         */
	        sum = num = x = div( x['minus'](one), x['plus'](one), sd, 1 );
	        x2 = rnd( x['times'](x), sd, 1 );
	        denom = 3;

	        for ( ; ; ) {
	            num = rnd( num['times'](x2), sd, 1 );
	            t = sum['plus']( div( num, new Decimal(denom), sd, 1 ) );

	            if ( coefficientToString( t['c'] ).slice( 0, sd ) ===
	                 coefficientToString( sum['c'] ).slice( 0, sd ) ) {
	                sum = sum['times'](2);

	                /*
	                 Reverse the argument reduction. Check that e is not 0 because, as well as
	                 preventing an unnecessary calculation, -0 + 0 = +0 and to ensure correct
	                 rounding later -0 needs to stay -0.
	                 */
	                if ( e !== 0 ) {

	                    if ( sd + 2 > LN10.length ) {
	                        ifExceptionsThrow( Decimal, 1, sd + 2, 'ln' );
	                    }

	                    sum = sum['plus'](
	                        new Decimal( LN10.slice( 0, sd + 2 ) )['times']( e + '' )
	                    );
	                }

	                sum = div( sum, new Decimal(n), sd, 1 );

	                /*
	                 Is rm > 3 and the first 4 rounding digits 4999, or rm < 4 (or the summation has
	                 been repeated previously) and the first 4 rounding digits 9999?

	                 If so, restart the summation with a higher precision, otherwise
	                 e.g. with precision: 12, rounding: 1
	                 ln(135520028.6126091714265381533) = 18.7246299999 when it should be 18.72463.

	                 sd - guard is the index of first rounding digit.
	                 */
	                if ( pr == null ) {

	                    if ( checkRoundingDigits( sum['c'], sd - guard, rm, rep ) ) {
	                        Decimal['precision'] = sd += guard;
	                        t = num = x = div( x1['minus'](one), x1['plus'](one), sd, 1 );
	                        x2 = rnd( x['times'](x), sd, 1 );
	                        denom = rep = 1;
	                    } else {

	                        return rnd( sum, Decimal['precision'] = precision, rm, external = true );
	                    }
	                } else {
	                    Decimal['precision'] = precision;

	                    return sum;
	                }
	            }

	            sum = t;
	            denom += 2;
	        }
	    }


	    /*
	     * Round x to sd significant digits using rounding mode rm. Check for over/under-flow.
	     */
	     function rnd( x, sd, rm, r ) {
	        var digits, i, j, k, n, rd, xc, xci,
	            Decimal = x['constructor'];

	        // Don't round if sd is null or undefined.
	        out: if ( sd != null ) {

	            // Infinity/NaN.
	            if ( !( xc = x['c'] ) ) {

	                return x;
	            }

	            /*
	             rd, the rounding digit, i.e. the digit after the digit that may be rounded up,
	             n, a base 1e7 number, the element of xc containing rd,
	             xci, the index of n within xc,
	             digits, the number of digits of n,
	             i, what would be the index of rd within n if all the numbers were 7 digits long (i.e. they had leading zeros)
	             j, if > 0, the actual index of rd within n (if < 0, rd is a leading zero),
	             nLeadingZeros, the number of leading zeros n would have if it were 7 digits long.
	             */

	            // Get the length of the first element of the coefficient array xc.
	            for ( digits = 1, k = xc[0]; k >= 10; k /= 10, digits++ );

	            i = sd - digits;

	            // Is the rounding digit in the first element of xc?
	            if ( i < 0 ) {
	                i += LOGBASE;
	                j = sd;
	                n = xc[ xci = 0 ];

	                // Get the rounding digit at index j of n.
	                rd = n / mathpow( 10, digits - j - 1 ) % 10 | 0;
	            } else {
	                xci = Math.ceil( ( i + 1 ) / LOGBASE );

	                if ( xci >= xc.length ) {

	                    if (r) {

	                        // Needed by exp, ln and sqrt.
	                        for ( ; xc.length <= xci; xc.push(0) );

	                        n = rd = 0;
	                        digits = 1;
	                        i %= LOGBASE;
	                        j = i - LOGBASE + 1;
	                    } else {

	                      break out;
	                    }
	                } else {
	                    n = k = xc[xci];

	                    // Get the number of digits of n.
	                    for ( digits = 1; k >= 10; k /= 10, digits++ );

	                    // Get the index of rd within n.
	                    i %= LOGBASE;

	                    // Get the index of rd within n, adjusted for leading zeros.
	                    // The number of leading zeros of n is given by LOGBASE - digits.
	                    j = i - LOGBASE + digits;

	                    // Get the rounding digit at index j of n.
	                    // Floor using Math.floor instead of | 0 as rd may be outside int range.
	                    rd = j < 0 ? 0 : mathfloor( n / mathpow( 10, digits - j - 1 ) % 10 );
	                }
	            }

	            r = r || sd < 0 ||
	              // Are there any non-zero digits after the rounding digit?
	              xc[xci + 1] != null || ( j < 0 ? n : n % mathpow( 10, digits - j - 1 ) );

	            /*
	             The expression  n % mathpow( 10, digits - j - 1 )  returns all the digits of n to the
	             right of the digit at (left-to-right) index j,
	             e.g. if n is 908714 and j is 2, the expression will give 714.
	             */

	            r = rm < 4
	              ? ( rd || r ) && ( rm == 0 || rm == ( x['s'] < 0 ? 3 : 2 ) )
	              : rd > 5 || rd == 5 && ( rm == 4 || r ||
	                // Check whether the digit to the left of the rounding digit is odd.
	                rm == 6 && ( ( i > 0 ? j > 0 ? n / mathpow( 10, digits - j ) : 0 : xc[xci - 1] ) % 10 ) & 1 ||
	                  rm == ( x['s'] < 0 ? 8 : 7 ) );

	            if ( sd < 1 || !xc[0] ) {
	                xc.length = 0;

	                if (r) {

	                    // Convert sd to decimal places.
	                    sd -= x['e'] + 1;

	                    // 1, 0.1, 0.01, 0.001, 0.0001 etc.
	                    xc[0] = mathpow( 10, sd % LOGBASE );
	                    x['e'] = -sd || 0;
	                } else {

	                    // Zero.
	                    xc[0] = x['e'] = 0;
	                }

	                return x;
	            }

	            // Remove excess digits.

	            if ( i == 0 ) {
	                xc.length = xci;
	                k = 1;
	                xci--;
	            } else {
	                xc.length = xci + 1;
	                k = mathpow( 10, LOGBASE - i );

	                // E.g. 56700 becomes 56000 if 7 is the rounding digit.
	                // j > 0 means i > number of leading zeros of n.
	                xc[xci] = j > 0 ? ( n / mathpow( 10, digits - j ) % mathpow( 10, j ) | 0 ) * k : 0;
	            }

	            // Round up?
	            if (r) {

	                for ( ; ; ) {

	                    // Is the digit to be rounded up in the first element of xc?
	                    if ( xci == 0 ) {

	                        // i will be the length of xc[0] before k is added.
	                        for ( i = 1, j = xc[0]; j >= 10; j /= 10, i++ );

	                        j = xc[0] += k;

	                        for ( k = 1; j >= 10; j /= 10, k++ );

	                        // if i != k the length has increased.
	                        if ( i != k ) {
	                            x['e']++;

	                            if ( xc[0] == BASE ) {
	                                xc[0] = 1;
	                            }
	                        }

	                        break;
	                    } else {
	                        xc[xci] += k;

	                        if ( xc[xci] != BASE ) {

	                            break;
	                        }

	                        xc[xci--] = 0;
	                        k = 1;
	                    }
	                }
	            }

	            // Remove trailing zeros.
	            for ( i = xc.length; xc[--i] === 0; xc.pop() );
	        }

	        if (external) {

	            // Overflow?
	            if ( x['e'] > Decimal['maxE'] ) {

	                // Infinity.
	                x['c'] = x['e'] = null;

	            // Underflow?
	            } else if ( x['e'] < Decimal['minE'] ) {

	                // Zero.
	                x['c'] = [ x['e'] = 0 ];
	            }
	        }

	        return x;
	    }


	    decimal = (function () {


	        // Private functions used by static Decimal methods.


	        /*
	         *  The following emulations or wrappers of Math object functions are currently
	         *  commented-out and not in the public API.
	         *
	         *  abs
	         *  acos
	         *  asin
	         *  atan
	         *  atan2
	         *  ceil
	         *  cos
	         *  floor
	         *  round
	         *  sin
	         *  tan
	         *  trunc
	         */


	        /*
	         * Return a new Decimal whose value is the absolute value of n.
	         *
	         * n {number|string|Decimal}
	         *
	        function abs(n) { return new this(n)['abs']() }
	         */


	        /*
	         * Return a new Decimal whose value is the arccosine in radians of n.
	         *
	         * n {number|string|Decimal}
	         *
	        function acos(n) { return new this( Math.acos(n) + '' ) }
	         */


	        /*
	         * Return a new Decimal whose value is the arcsine in radians of n.
	         *
	         * n {number|string|Decimal}
	         *
	        function asin(n) { return new this( Math.asin(n) + '' ) }
	         */


	        /*
	         * Return a new Decimal whose value is the arctangent in radians of n.
	         *
	         * n {number|string|Decimal}
	         *
	        function atan(n) { return new this( Math.atan(n) + '' ) }
	         */


	        /*
	         * Return a new Decimal whose value is the arctangent in radians of y/x in the range
	         * -PI to PI (inclusive).
	         *
	         * y {number|string|Decimal} The y-coordinate.
	         * x {number|string|Decimal} The x-coordinate.
	         *
	        function atan2( y, x ) { return new this( Math.atan2( y, x ) + '' ) }
	         */


	        /*
	         * Return a new Decimal whose value is n round to an integer using ROUND_CEIL.
	         *
	         * n {number|string|Decimal}
	         *
	        function ceil(n) { return new this(n)['ceil']() }
	         */


	        /*
	         * Configure global settings for a Decimal constructor.
	         *
	         * obj is an object with any of the following properties,
	         *
	         *   precision  {number}
	         *   rounding   {number}
	         *   toExpNeg   {number}
	         *   toExpPos   {number}
	         *   minE       {number}
	         *   maxE       {number}
	         *   errors     {boolean|number}
	         *   crypto     {boolean|number}
	         *   modulo     {number}
	         *
	         *   format     {object}     See Decimal.prototype.toFormat
	         *      decimalSeparator       {string}
	         *      groupSeparator         {string}
	         *      groupSize              {number}
	         *      secondaryGroupSize     {number}
	         *      fractionGroupSeparator {string}
	         *      fractionGroupSize      {number}
	         *
	         *   A format object will replace the existing Decimal.format object without any property
	         *   checking.
	         *
	         * E.g.
	         *   Decimal.config({ precision: 20, rounding: 4 })
	         *
	         */
	        function config(obj) {
	            var p, u, v,
	                Decimal = this,
	                c = 'config',
	                parse = Decimal['errors'] ? parseInt : parseFloat;

	            if ( obj == u || typeof obj != 'object' &&
	              // 'config() object expected: {obj}'
	              !ifExceptionsThrow( Decimal, 'object expected', obj, c ) ) {

	                return Decimal;
	            }

	            // precision {number} Integer, 1 to MAX_DIGITS inclusive.
	            if ( ( v = obj[ p = 'precision' ] ) != u ) {

	                if ( !( outOfRange = v < 1 || v > MAX_DIGITS ) && parse(v) == v ) {
	                    Decimal[p] = v | 0;
	                } else {

	                    // 'config() precision not an integer: {v}'
	                    // 'config() precision out of range: {v}'
	                    ifExceptionsThrow( Decimal, p, v, c, 0 );
	                }
	            }

	            // rounding {number} Integer, 0 to 8 inclusive.
	            if ( ( v = obj[ p = 'rounding' ] ) != u ) {

	                if ( !( outOfRange = v < 0 || v > 8 ) && parse(v) == v ) {
	                    Decimal[p] = v | 0;
	                } else {

	                    // 'config() rounding not an integer: {v}'
	                    // 'config() rounding out of range: {v}'
	                    ifExceptionsThrow( Decimal, p, v, c, 0 );
	                }
	            }

	            // toExpNeg {number} Integer, -EXP_LIMIT to 0 inclusive.
	            if ( ( v = obj[ p = 'toExpNeg' ] ) != u ) {

	                if ( !( outOfRange = v < -EXP_LIMIT || v > 0 ) && parse(v) == v ) {
	                    Decimal[p] = mathfloor(v);
	                } else {

	                    // 'config() toExpNeg not an integer: {v}'
	                    // 'config() toExpNeg out of range: {v}'
	                    ifExceptionsThrow( Decimal, p, v, c, 0 );
	                }
	            }

	            // toExpPos {number} Integer, 0 to EXP_LIMIT inclusive.
	            if ( ( v = obj[ p = 'toExpPos' ] ) != u ) {

	                if ( !( outOfRange = v < 0 || v > EXP_LIMIT ) && parse(v) == v ) {
	                    Decimal[p] = mathfloor(v);
	                } else {

	                    // 'config() toExpPos not an integer: {v}'
	                    // 'config() toExpPos out of range: {v}'
	                    ifExceptionsThrow( Decimal, p, v, c, 0 );
	                }
	            }

	             // minE {number} Integer, -EXP_LIMIT to 0 inclusive.
	            if ( ( v = obj[ p = 'minE' ] ) != u ) {

	                if ( !( outOfRange = v < -EXP_LIMIT || v > 0 ) && parse(v) == v ) {
	                    Decimal[p] = mathfloor(v);
	                } else {

	                    // 'config() minE not an integer: {v}'
	                    // 'config() minE out of range: {v}'
	                    ifExceptionsThrow( Decimal, p, v, c, 0 );
	                }
	            }

	            // maxE {number} Integer, 0 to EXP_LIMIT inclusive.
	            if ( ( v = obj[ p = 'maxE' ] ) != u ) {

	                if ( !( outOfRange = v < 0 || v > EXP_LIMIT ) && parse(v) == v ) {
	                    Decimal[p] = mathfloor(v);
	                } else {

	                    // 'config() maxE not an integer: {v}'
	                    // 'config() maxE out of range: {v}'
	                    ifExceptionsThrow( Decimal, p, v, c, 0 );
	                }
	            }

	            // errors {boolean|number} true, false, 1 or 0.
	            if ( ( v = obj[ p = 'errors' ] ) != u ) {

	                if ( v === !!v || v === 1 || v === 0 ) {
	                    outOfRange = id = 0;
	                    Decimal[p] = !!v;
	                } else {

	                    // 'config() errors not a boolean or binary digit: {v}'
	                    ifExceptionsThrow( Decimal, p, v, c, 1 );
	                }
	            }

	            // crypto {boolean|number} true, false, 1 or 0.
	            if ( ( v = obj[ p = 'crypto' ] ) != u ) {

	                if ( v === !!v || v === 1 || v === 0 ) {
	                    Decimal[p] = !!( v && crypto && typeof crypto == 'object' );
	                } else {

	                    // 'config() crypto not a boolean or binary digit: {v}'
	                    ifExceptionsThrow( Decimal, p, v, c, 1 );
	                }
	            }

	            // modulo {number} Integer, 0 to 9 inclusive.
	            if ( ( v = obj[ p = 'modulo' ] ) != u ) {

	                if ( !( outOfRange = v < 0 || v > 9 ) && parse(v) == v ) {
	                    Decimal[p] = v | 0;
	                } else {

	                    // 'config() modulo not an integer: {v}'
	                    // 'config() modulo out of range: {v}'
	                    ifExceptionsThrow( Decimal, p, v, c, 0 );
	                }
	            }

	            // format {object}
	            if ( ( obj = obj[ p = 'format' ] ) != u ) {

	                if ( typeof obj == 'object' ) {
	                    Decimal[p] = obj;
	                } else {

	                    // 'config() format object expected: {obj}'
	                    ifExceptionsThrow( Decimal, 'format object expected', obj, c );
	                }
	            }

	            return Decimal;
	        }


	        /*
	         * Return a new Decimal whose value is the cosine of n.
	         *
	         * n {number|string|Decimal} A number given in radians.
	         *
	        function cos(n) { return new this( Math.cos(n) + '' ) }
	         */


	        /*
	         * Return a new Decimal whose value is the exponential of n,
	         *
	         * n {number|string|Decimal} The power to which to raise the base of the natural log.
	         *
	         */
	        function exp(n) { return new this(n)['exp'](); }


	        /*
	         * Return a new Decimal whose value is n round to an integer using ROUND_FLOOR.
	         *
	         * n {number|string|Decimal}
	         *
	        function floor(n) { return new this(n)['floor']() }
	         */


	        /*
	         * Return a new Decimal whose value is the natural logarithm of n.
	         *
	         * n {number|string|Decimal}
	         *
	         */
	        function ln(n) { return new this(n)['ln'](); }


	        /*
	         * Return a new Decimal whose value is the log of x to the base y, or to base 10 if no
	         * base is specified.
	         *
	         * log[y](x)
	         *
	         * x {number|string|Decimal} The argument of the logarithm.
	         * y {number|string|Decimal} The base of the logarithm.
	         *
	         */
	        function log( x, y ) { return new this(x)['log'](y); }


	        /*
	         * Handle max and min. ltgt is 'lt' or 'gt'.
	         */
	        function maxOrMin( Decimal, args, ltgt ) {
	            var m, n,
	                i = 0;

	            if ( toString.call( args[0] ) == '[object Array]' ) {
	                args = args[0];
	            }

	            m = new Decimal( args[0] );

	            for ( ; ++i < args.length; ) {
	                n = new Decimal( args[i] );

	                if ( !n['s'] ) {
	                    m = n;

	                    break;
	                } else if ( m[ltgt](n) ) {
	                    m = n;
	                }
	            }

	            return m;
	        }


	        /*
	         * Return a new Decimal whose value is the maximum of the arguments.
	         *
	         * arguments {number|string|Decimal}
	         *
	         */
	        function max() { return maxOrMin( this, arguments, 'lt' ); }


	        /*
	         * Return a new Decimal whose value is the minimum of the arguments.
	         *
	         * arguments {number|string|Decimal}
	         *
	         */
	        function min() { return maxOrMin( this, arguments, 'gt' ); }


	        /*
	         * Parse the value of a new Decimal from a number or string.
	         */
	        var parseDecimal = (function () {
	            var isValid = /^-?(\d+(\.\d*)?|\.\d+)(e[+-]?\d+)?$/i,
	                trim = String.prototype.trim ||
	                  function () { return this.replace(/^\s+|\s+$/g, ''); };

	            return function ( Decimal, x, n, b ) {
	                var d, e, i, isNum, orig, valid;

	                if ( typeof n != 'string' ) {

	                    // If n is a number, check if minus zero.
	                    n = ( isNum = typeof n == 'number' || toString.call(n) == '[object Number]' ) &&
	                        n === 0 && 1 / n < 0 ? '-0' : n + '';
	                }
	                orig = n;

	                if ( b == null && isValid.test(n) ) {

	                    // Determine sign.
	                    x['s'] = n.charCodeAt(0) === 45 ? ( n = n.slice(1), -1 ) : 1;

	                // Either n is not a valid Decimal or a base has been specified.
	                } else {

	                    /*
	                     Enable exponential notation to be used with base 10 argument.
	                     Ensure return value is rounded to precision as with other bases.
	                     */
	                    if ( b == 10 ) {

	                        return rnd( new Decimal(n), Decimal['precision'], Decimal['rounding'] );
	                    }

	                    n = trim.call(n).replace( /^\+(?!-)/, '' );

	                    x['s'] = n.charCodeAt(0) === 45 ? ( n = n.replace( /^-(?!-)/, '' ), -1 ) : 1;

	                    if ( b != null ) {

	                        if ( ( b == (b | 0) || !Decimal['errors'] ) &&
	                          !( outOfRange = !( b >= 2 && b < 65 ) ) ) {
	                            d = '[' + NUMERALS.slice( 0, b = b | 0 ) + ']+';

	                           // Remove the `.` from e.g. '1.', and replace e.g. '.1' with '0.1'.
	                            n = n.replace( /\.$/, '' ).replace( /^\./, '0.' );

	                            // Any number in exponential form will fail due to the e+/-.
	                            if ( valid = new RegExp(
	                              '^' + d + '(?:\\.' + d + ')?$', b < 37 ? 'i' : '' ).test(n) ) {

	                                if (isNum) {

	                                    if ( n.replace( /^0\.0*|\./, '' ).length > 15 ) {

	                                        // '{method} number type has more than 15 significant digits: {n}'
	                                        ifExceptionsThrow( Decimal, 0, orig );
	                                    }

	                                    // Prevent later check for length on converted number.
	                                    isNum = !isNum;
	                                }
	                                n = convertBase( Decimal, n, 10, b, x['s'] );

	                            } else if ( n != 'Infinity' && n != 'NaN' ) {

	                                // '{method} not a base {b} number: {n}'
	                                ifExceptionsThrow( Decimal, 'not a base ' + b + ' number', orig );
	                                n = 'NaN';
	                            }
	                        } else {

	                            // '{method} base not an integer: {b}'
	                            // '{method} base out of range: {b}'
	                            ifExceptionsThrow( Decimal, 'base', b, 0, 0 );

	                            // Ignore base.
	                            valid = isValid.test(n);
	                        }
	                    } else {
	                        valid = isValid.test(n);
	                    }

	                    if ( !valid ) {

	                        // Infinity/NaN
	                        x['c'] = x['e'] = null;

	                        // NaN
	                        if ( n != 'Infinity' ) {

	                            // No exception on NaN.
	                            if ( n != 'NaN' ) {

	                                // '{method} not a number: {n}'
	                                ifExceptionsThrow( Decimal, 'not a number', orig );
	                            }
	                            x['s'] = null;
	                        }
	                        id = 0;

	                        return x;
	                    }
	                }

	                // Decimal point?
	                if ( ( e = n.indexOf('.') ) > -1 ) {
	                    n = n.replace( '.', '' );
	                }

	                // Exponential form?
	                if ( ( i = n.search(/e/i) ) > 0 ) {

	                    // Determine exponent.
	                    if ( e < 0 ) {
	                        e = i;
	                    }
	                    e += +n.slice( i + 1 );
	                    n = n.substring( 0, i );

	                } else if ( e < 0 ) {

	                    // Integer.
	                    e = n.length;
	                }

	                // Determine leading zeros.
	                for ( i = 0; n.charCodeAt(i) === 48; i++ );

	                // Determine trailing zeros.
	                for ( b = n.length; n.charCodeAt(--b) === 48; );

	                n = n.slice( i, b + 1 );

	                if (n) {
	                    b = n.length;

	                    // Disallow numbers with over 15 significant digits if number type.
	                    if ( isNum && b > 15 ) {

	                        // '{method} number type has more than 15 significant digits: {n}'
	                        ifExceptionsThrow( Decimal, 0, orig );
	                    }

	                    x['e'] = e = e - i - 1;
	                    x['c'] = [];

	                    // Transform base

	                    // e is the base 10 exponent.
	                    // i is where to slice n to get the first element of the coefficient array.
	                    i = ( e + 1 ) % LOGBASE;

	                    if ( e < 0 ) {
	                        i += LOGBASE;
	                    }

	                    // b is n.length.
	                    if ( i < b ) {

	                        if (i) {
	                            x['c'].push( +n.slice( 0, i ) );
	                        }

	                        for ( b -= LOGBASE; i < b; ) {
	                            x['c'].push( +n.slice( i, i += LOGBASE ) );
	                        }

	                        n = n.slice(i);
	                        i = LOGBASE - n.length;
	                    } else {
	                        i -= b;
	                    }

	                    for ( ; i--; n += '0' );

	                    x['c'].push( +n );

	                    if (external) {

	                        // Overflow?
	                        if ( x['e'] > Decimal['maxE'] ) {

	                            // Infinity.
	                            x['c'] = x['e'] = null;

	                        // Underflow?
	                        } else if ( x['e'] < Decimal['minE'] ) {

	                            // Zero.
	                            x['c'] = [ x['e'] = 0 ];
	                        }
	                    }
	                } else {

	                    // Zero.
	                    x['c'] = [ x['e'] = 0 ];
	                }
	                id = 0;

	                return x;
	            };
	        })();


	        /*
	         * Return a new Decimal whose value is x raised to the power y.
	         *
	         * x {number|string|Decimal} The base.
	         * y {number|string|Decimal} The exponent.
	         *
	         */
	        function pow( x, y ) { return new this(x)['pow'](y); }


	        /*
	         * Returns a new Decimal with a random value equal to or greater than 0 and less than 1, and
	         * with dp, or Decimal.precision if dp is omitted, decimal places (or less if trailing
	         * zeros are produced).
	         *
	         * [dp] {number} Decimal places. Integer, 0 to MAX_DIGITS inclusive.
	         *
	         */
	        function random(dp) {
	            var a, n, v,
	                i = 0,
	                r = [],
	                Decimal = this,
	                rand = new Decimal( Decimal['ONE'] );

	            if ( dp == null || !checkArg( rand, dp, 'random' ) ) {
	                dp = Decimal['precision'];
	            } else {
	                dp |= 0;
	            }

	            n = Math.ceil( dp / LOGBASE );

	            if ( Decimal['crypto'] ) {

	                // Browsers supporting crypto.getRandomValues.
	                if ( crypto && crypto['getRandomValues'] ) {

	                    a = crypto['getRandomValues']( new Uint32Array(n) );

	                    for ( ; i < n; ) {
	                        v = a[i];

	                        // 0 <= v < 4294967296
	                        // Probability that v >= 4.29e9, is 4967296 / 4294967296 = 0.00116 (1 in 865).
	                        if ( v >= 4.29e9 ) {

	                            a[i] = crypto['getRandomValues']( new Uint32Array(1) )[0];
	                        } else {

	                            // 0 <= v <= 4289999999
	                            // 0 <= ( v % 1e7 ) <= 9999999
	                            r[i++] = v % 1e7;
	                        }
	                    }

	                // Node.js supporting crypto.randomBytes.
	                } else if ( crypto && crypto['randomBytes'] ) {

	                    // buffer
	                    a = crypto['randomBytes']( n *= 4 );

	                    for ( ; i < n; ) {

	                        // 0 <= v < 2147483648
	                        v = a[i] + ( a[i + 1] << 8 ) + ( a[i + 2] << 16 ) +
	                            ( ( a[i + 3] & 0x7f ) << 24 );

	                        // Probability that v >= 2.14e9, is 7483648 / 2147483648 = 0.0035 (1 in 286).
	                        if ( v >= 2.14e9 ) {
	                            crypto['randomBytes'](4).copy( a, i );
	                        } else {

	                            // 0 <= v <= 2139999999
	                            // 0 <= ( v % 1e7 ) <= 9999999
	                            r.push( v % 1e7 );
	                            i += 4;
	                        }
	                    }
	                    i = n / 4;

	                } else {
	                    ifExceptionsThrow( Decimal, 'crypto unavailable', crypto, 'random' );
	                }
	            }

	            // Use Math.random: either Decimal.crypto is false or crypto is unavailable and errors is false.
	            if (!i) {

	                for ( ; i < n; ) {
	                    r[i++] = Math.random() * 1e7 | 0;
	                }
	            }

	            n = r[--i];
	            dp %= LOGBASE;

	            // Convert trailing digits to zeros according to dp.
	            if ( n && dp ) {
	                v = mathpow( 10, LOGBASE - dp );
	                r[i] = ( n / v | 0 ) * v;
	            }

	            // Remove trailing elements which are zero.
	            for ( ; r[i] === 0; i-- ) {
	                r.pop();
	            }

	            // Zero?
	            if ( i < 0 ) {
	                r = [ n = 0 ];
	            } else {
	                n = -1;

	                // Remove leading elements which are zero and adjust exponent accordingly.
	                for ( ; r[0] === 0; ) {
	                    r.shift();
	                    n -= LOGBASE;
	                }

	                // Count the digits of the first element of r to determine leading zeros.
	                for ( i = 1, v = r[0]; v >= 10; ) {
	                    v /= 10;
	                    i++;
	                }

	                // Adjust the exponent for leading zeros of the first element of r.
	                if ( i < LOGBASE ) {
	                    n -= LOGBASE - i;
	                }
	            }

	            rand['e'] = n;
	            rand['c'] = r;

	            return rand;
	        }


	        /*
	         * Return a new Decimal whose value is n round to an integer using rounding mode rounding.
	         *
	         * To emulate Math.round, set rounding to 7 (ROUND_HALF_CEIL).
	         *
	         * n {number|string|Decimal}
	         *
	        function round(n) {
	            var x = new this(n);

	            return rnd( x, x['e'] + 1, this['rounding'] );
	        }
	         */


	        /*
	         * Return a new Decimal whose value is the sine of n.
	         *
	         * n {number|string|Decimal} A number given in radians.
	         *
	        function sin(n) { return new this( Math.sin(n) + '' ) }
	         */


	        /*
	         * Return a new Decimal whose value is the square root of n.
	         *
	         * n {number|string|Decimal}
	         *
	         */
	        function sqrt(n) { return new this(n)['sqrt'](); }


	        /*
	         * Return a new Decimal whose value is the tangent of n.
	         *
	         * n {number|string|Decimal} A number given in radians.
	         *
	        function tan(n) { return new this( Math.tan(n) + '' ) }
	         */


	        /*
	         * Return a new Decimal whose value is n truncated to an integer.
	         *
	         * n {number|string|Decimal}
	         *
	        function trunc(n) { return new this(n)['trunc']() }
	         */


	        /*
	         * Create and return a Decimal constructor.
	         *
	         */
	        function decimalFactory(obj) {

	            /*
	             * The Decimal constructor and exported function.
	             * Create and return a new instance of a Decimal object.
	             *
	             * n {number|string|Decimal} A numeric value.
	             * [b] {number} The base of n. Integer, 2 to 64 inclusive.
	             *
	             */
	            function Decimal( n, b ) {
	                var x = this;

	                // Constructor called without new.
	                if ( !( x instanceof Decimal ) ) {
	                    ifExceptionsThrow( Decimal, 'Decimal called without new', n );

	                    return new Decimal( n, b );
	                }

	                // Retain a reference to this Decimal constructor, and shadow
	                // Decimal.prototype.constructor which points to Object.
	                x['constructor'] = Decimal;

	                // Duplicate.
	                if ( n instanceof Decimal ) {

	                    if ( b == null ) {
	                        id = 0;
	                        x['s'] = n['s'];
	                        x['e'] = n['e'];
	                        x['c'] = ( n = n['c'] ) ? n.slice() : n;

	                        return x;
	                    } else if ( b == 10 ) {

	                        return rnd( new Decimal(n), Decimal['precision'], Decimal['rounding'] );
	                    } else {
	                        n += '';
	                    }
	                }

	                return parseDecimal( Decimal, x, n, b );
	            }


	            /* ************************ CONSTRUCTOR DEFAULT PROPERTIES ************************** */

	            /*
	             These default values must be integers within the stated ranges (inclusive).
	             Most of these values can be changed during run-time using Decimal.config.
	             */

	            /*
	             The maximum number of significant digits of the result of a calculation or base
	             conversion.
	             E.g.  Decimal.config({ precision: 20 })
	             */
	            Decimal['precision'] = 20;                        // 1 to MAX_DIGITS

	            /*
	             The rounding mode used when rounding to precision.

	             ROUND_UP         0 Away from zero.
	             ROUND_DOWN       1 Towards zero.
	             ROUND_CEIL       2 Towards +Infinity.
	             ROUND_FLOOR      3 Towards -Infinity.
	             ROUND_HALF_UP    4 Towards nearest neighbour. If equidistant, up.
	             ROUND_HALF_DOWN  5 Towards nearest neighbour. If equidistant, down.
	             ROUND_HALF_EVEN  6 Towards nearest neighbour. If equidistant, towards even neighbour.
	             ROUND_HALF_CEIL  7 Towards nearest neighbour. If equidistant, towards +Infinity.
	             ROUND_HALF_FLOOR 8 Towards nearest neighbour. If equidistant, towards -Infinity.

	             E.g.
	             Decimal.rounding = 4;
	             Decimal.rounding = Decimal.ROUND_HALF_UP;
	             */
	            Decimal['rounding'] = 4;                          // 0 to 8

	            /*
	             The modulo mode used when calculating the modulus: a mod n.
	             The quotient (q = a / n) is calculated according to the corresponding rounding mode.
	             The remainder (r) is calculated as: r = a - n * q.

	             UP         0 The remainder is positive if the dividend is negative, else is negative.
	             DOWN       1 The remainder has the same sign as the dividend.
	                          This modulo mode is commonly known as "truncated division" and matches
	                          as closely as possible, the behaviour of JS remainder operator (a % n).
	             FLOOR      3 The remainder has the same sign as the divisor (Python %).
	             HALF_EVEN  6 This modulo mode implements the IEEE 754 remainder function.
	             EUCLID     9 Euclidian division. q = sign(n) * floor(a / abs(n)).
	                          The remainder is always positive.

	             The above modes - truncated division, floored division, Euclidian division and IEEE 754
	             remainder - are commonly used for the modulus operation. Although any other of the
	             rounding modes can be used, they may not give useful results.
	             */
	            Decimal['modulo'] = 1;                            // 0 to 9

	            // The exponent value at and beneath which toString returns exponential notation.
	            // Number type: -7
	            Decimal['toExpNeg'] = -7;                         // 0 to -EXP_LIMIT

	            // The exponent value at and above which toString returns exponential notation.
	            // Number type: 21
	            Decimal['toExpPos'] = 21;                         // 0 to EXP_LIMIT

	            // The minimum exponent value, beneath which underflow to zero occurs.
	            // Number type: -324  (5e-324)
	            Decimal['minE'] = -EXP_LIMIT;                     // -1 to -EXP_LIMIT

	            // The maximum exponent value, above which overflow to Infinity occurs.
	            // Number type:  308  (1.7976931348623157e+308)
	            Decimal['maxE'] = EXP_LIMIT;                      // 1 to EXP_LIMIT

	            // Whether Decimal Errors are ever thrown.
	            Decimal['errors'] = true;                         // true/false

	            // Whether to use cryptographically-secure random number generation, if available.
	            Decimal['crypto'] = false;                        // true/false

	            // Format specification for the Decimal.prototype.toFormat method
	            Decimal.format = {
	                decimalSeparator: '.',
	                groupSeparator: ',',
	                groupSize: 3,
	                secondaryGroupSize: 0,
	                fractionGroupSeparator: '\xA0',              // non-breaking space
	                fractionGroupSize: 0
	            };


	            /* ********************** END OF CONSTRUCTOR DEFAULT PROPERTIES ********************* */


	            Decimal.prototype = P;

	            Decimal['ONE'] = new Decimal(1);

	            /*
	            // Pi to 80 s.d.
	            Decimal['PI'] = new Decimal(
	                '3.1415926535897932384626433832795028841971693993751058209749445923078164062862089'
	            );
	             */

	            Decimal['ROUND_UP'] = 0;
	            Decimal['ROUND_DOWN'] = 1;
	            Decimal['ROUND_CEIL'] = 2;
	            Decimal['ROUND_FLOOR'] = 3;
	            Decimal['ROUND_HALF_UP'] = 4;
	            Decimal['ROUND_HALF_DOWN'] = 5;
	            Decimal['ROUND_HALF_EVEN'] = 6;
	            Decimal['ROUND_HALF_CEIL'] = 7;
	            Decimal['ROUND_HALF_FLOOR'] = 8;

	            // modulo mode
	            Decimal['EUCLID'] = 9;

	            //Decimal['abs'] = abs;
	            //Decimal['acos'] = acos;
	            //Decimal['asin'] = asin;
	            //Decimal['atan'] = atan;
	            //Decimal['atan2'] = atan2;
	            //Decimal['ceil'] = ceil;
	            //Decimal['cos'] = cos;
	            //Decimal['floor'] = floor;
	            //Decimal['round'] = round;
	            //Decimal['sin'] = sin;
	            //Decimal['tan'] = tan;
	            //Decimal['trunc'] = trunc;

	            Decimal['config'] = config;
	            Decimal['constructor'] = decimalFactory;
	            Decimal['exp'] = exp;
	            Decimal['ln'] = ln;
	            Decimal['log'] = log;
	            Decimal['max'] = max;
	            Decimal['min'] = min;
	            Decimal['pow'] = pow;
	            Decimal['sqrt'] = sqrt;
	            Decimal['random'] = random;

	            if ( obj != null ) {
	                Decimal['config'](obj);
	            }

	            return Decimal;
	        }

	        return decimalFactory();
	    })();


	    // Export.


	    // AMD.
	    if ( true ) {

	        !(__WEBPACK_AMD_DEFINE_RESULT__ = function () {
	            return decimal;
	        }.call(exports, __webpack_require__, exports, module), __WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

	    // Node and other environments that support module.exports.
	    } else if ( typeof module != 'undefined' && module.exports ) {
	        module.exports = decimal;

	        if ( !crypto ) {

	            try {
	                crypto = require('crypto');
	            } catch (e) {}
	        }

	    // Browser.
	    } else {
	        noConflict = global['Decimal'];

	        decimal['noConflict'] = function () {
	            global['Decimal'] = noConflict;

	            return decimal;
	        };

	        global['Decimal'] = decimal;
	    }
	})(this);


/***/ },
/* 256 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);

	function factory (type, config, load, typed) {
	  /**
	   * Create a BigNumber, which can store numbers with arbitrary precision.
	   * When a matrix is provided, all elements will be converted to BigNumber.
	   *
	   * Syntax:
	   *
	   *    math.bignumber(x)
	   *
	   * Examples:
	   *
	   *    0.1 + 0.2;                                  // returns number 0.30000000000000004
	   *    math.bignumber(0.1) + math.bignumber(0.2);  // returns BigNumber 0.3
	   *
	   *
	   *    7.2e500;                                    // returns number Infinity
	   *    math.bignumber('7.2e500');                  // returns BigNumber 7.2e500
	   *
	   * See also:
	   *
	   *    boolean, complex, index, matrix, string, unit
	   *
	   * @param {number | string | Array | Matrix | boolean | null} [value]  Value for the big number,
	   *                                                    0 by default.
	   * @returns {BigNumber} The created bignumber
	   */
	  var bignumber = typed('bignumber', {
	    '': function () {
	      return new type.BigNumber(0);
	    },

	    'number': function (x) {
	      // convert to string to prevent errors in case of >15 digits
	      return new type.BigNumber(x + '');
	    },

	    'string': function (x) {
	      return new type.BigNumber(x);
	    },

	    'BigNumber': function (x) {
	      // we assume a BigNumber is immutable
	      return x;
	    },

	    'Array | Matrix': function (x) {
	      return deepMap(x, bignumber);
	    }
	  });

	  bignumber.toTex = {
	    0: '0',
	    1: '\\left(${args[0]}\\right)'
	  };

	  return bignumber;
	}

	exports.name = 'bignumber';
	exports.factory = factory;


/***/ },
/* 257 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var deepMap = __webpack_require__(29);

	function factory (type, config, load, typed) {
	  /**
	   * Create a boolean or convert a string or number to a boolean.
	   * In case of a number, `true` is returned for non-zero numbers, and `false` in
	   * case of zero.
	   * Strings can be `'true'` or `'false'`, or can contain a number.
	   * When value is a matrix, all elements will be converted to boolean.
	   *
	   * Syntax:
	   *
	   *    math.boolean(x)
	   *
	   * Examples:
	   *
	   *    math.boolean(0);     // returns false
	   *    math.boolean(1);     // returns true
	   *    math.boolean(-3);     // returns true
	   *    math.boolean('true');     // returns true
	   *    math.boolean('false');     // returns false
	   *    math.boolean([1, 0, 1, 1]);     // returns [true, false, true, true]
	   *
	   * See also:
	   *
	   *    bignumber, complex, index, matrix, string, unit
	   *
	   * @param {string | number | boolean | Array | Matrix | null} value  A value of any type
	   * @return {boolean | Array | Matrix} The boolean value
	   */
	  var bool = typed('bool', {
	    '': function () {
	      return false;
	    },

	    'boolean': function (x) {
	      return x;
	    },

	    'number': function (x) {
	      return !!x;
	    },

	    'BigNumber': function (x) {
	      return !x.isZero();
	    },

	    'string': function (x) {
	      // try case insensitive
	      var lcase = x.toLowerCase();
	      if (lcase === 'true') {
	        return true;
	      }
	      else if (lcase === 'false') {
	        return false;
	      }

	      // test whether value is a valid number
	      var num = Number(x);
	      if (x != '' && !isNaN(num)) {
	        return !!num;
	      }

	      throw new Error('Cannot convert "' + x + '" to a boolean');
	    },

	    'Array | Matrix': function (x) {
	      return deepMap(x, bool);
	    }
	  });

	  return bool;
	}

	exports.name = 'boolean';
	exports.factory = factory;


/***/ },
/* 258 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = [
	  // type
	  __webpack_require__(259),

	  // construction function
	  __webpack_require__(260)
	];


/***/ },
/* 259 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var format = __webpack_require__(20).format;
	var lazy = __webpack_require__(5).lazy;

	function factory (type, config, load, typed, math) {
	  /**
	   * @constructor Chain
	   * Wrap any value in a chain, allowing to perform chained operations on
	   * the value.
	   *
	   * All methods available in the math.js library can be called upon the chain,
	   * and then will be evaluated with the value itself as first argument.
	   * The chain can be closed by executing chain.done(), which will return
	   * the final value.
	   *
	   * The Chain has a number of special functions:
	   * - done()             Finalize the chained operation and return the
	   *                      chain's value.
	   * - valueOf()          The same as done()
	   * - toString()         Returns a string representation of the chain's value.
	   *
	   * @param {*} [value]
	   */
	  function Chain (value) {
	    if (!(this instanceof Chain)) {
	      throw new SyntaxError('Constructor must be called with the new operator');
	    }

	    if (value && value.isChain) {
	      this.value = value.value;
	    }
	    else {
	      this.value = value;
	    }
	  }

	  /**
	   * Attach type information
	   */
	  Chain.prototype.type = 'Chain';
	  Chain.prototype.isChain = true;

	  /**
	   * Close the chain. Returns the final value.
	   * Does the same as method valueOf()
	   * @returns {*} value
	   */
	  Chain.prototype.done = function () {
	    return this.value;
	  };

	  /**
	   * Close the chain. Returns the final value.
	   * Does the same as method done()
	   * @returns {*} value
	   */
	  Chain.prototype.valueOf = function () {
	    return this.value;
	  };

	  /**
	   * Get a string representation of the value in the chain
	   * @returns {string}
	   */
	  Chain.prototype.toString = function () {
	    return format(this.value);
	  };

	  /**
	   * Create a proxy method for the chain
	   * @param {string} name
	   * @param {Function} fn      The function to be proxied
	   *                           If fn is no function, it is silently ignored.
	   * @private
	   */
	  function createProxy(name, fn) {
	    if (typeof fn === 'function') {
	      Chain.prototype[name] = chainify(fn);
	    }
	  }

	  /**
	   * Create a proxy method for the chain
	   * @param {string} name
	   * @param {function} resolver   The function resolving with the
	   *                              function to be proxied
	   * @private
	   */
	  function createLazyProxy(name, resolver) {
	    lazy(Chain.prototype, name, function outerResolver() {
	      var fn = resolver();
	      if (typeof fn === 'function') {
	        return chainify(fn);
	      }

	      return undefined; // if not a function, ignore
	    });
	  }

	  /**
	   * Make a function chainable
	   * @param {function} fn
	   * @return {Function} chain function
	   * @private
	   */
	  function chainify (fn) {
	    return function () {
	      var args = [this.value];  // `this` will be the context of a Chain instance
	      for (var i = 0; i < arguments.length; i++) {
	        args[i + 1] = arguments[i];
	      }

	      return new Chain(fn.apply(fn, args));
	    }
	  }

	  /**
	   * Create a proxy for a single method, or an object with multiple methods.
	   * Example usage:
	   *
	   *   Chain.createProxy('add', function add (x, y) {...});
	   *   Chain.createProxy({
	   *     add:      function add (x, y) {...},
	   *     subtract: function subtract (x, y) {...}
	   *   }
	   *
	   * @param {string | Object} arg0   A name (string), or an object with
	   *                                 functions
	   * @param {*} [arg1]               A function, when arg0 is a name
	   */
	  Chain.createProxy = function (arg0, arg1) {
	    if (typeof arg0 === 'string') {
	      // createProxy(name, value)
	      createProxy(arg0, arg1);
	    }
	    else {
	      // createProxy(values)
	      for (var prop in arg0) {
	        if (arg0.hasOwnProperty(prop)) {
	          createProxy(prop, arg0[prop]);
	        }
	      }
	    }
	  };

	  // create proxy for everything that is in math.js
	  Chain.createProxy(math);

	  // register on the import event, automatically add a proxy for every imported function.
	  math.on('import', function (name, resolver, path) {
	    if (path === undefined) {
	      // an imported function (not a data type or something special)
	      createLazyProxy(name, resolver);
	    }
	  });

	  return Chain;
	}

	exports.name = 'Chain';
	exports.path = 'type';
	exports.factory = factory;
	exports.math = true;  // require providing the math namespace as 5th argument
	exports.lazy = false; // we need to register a listener on the import events, so no lazy loading


/***/ },
/* 260 */
/***/ function(module, exports) {

	'use strict';

	function factory (type, config, load, typed) {
	  /**
	   * Wrap any value in a chain, allowing to perform chained operations on
	   * the value.
	   *
	   * All methods available in the math.js library can be called upon the chain,
	   * and then will be evaluated with the value itself as first argument.
	   * The chain can be closed by executing `chain.done()`, which returns
	   * the final value.
	   *
	   * The chain has a number of special functions:
	   *
	   * - `done()`     Finalize the chain and return the chain's value.
	   * - `valueOf()`  The same as `done()`
	   * - `toString()` Executes `math.format()` onto the chain's value, returning
	   *                a string representation of the value.
	   *
	   * Syntax:
	   *
	   *    math.chain(value)
	   *
	   * Examples:
	   *
	   *     math.chain(3)
	   *         .add(4)
	   *         .subtract(2)
	   *         .done();     // 5
	   *
	   *     math.chain( [[1, 2], [3, 4]] )
	   *         .subset(math.index(0, 0), 8)
	   *         .multiply(3)
	   *         .done();     // [[24, 6], [9, 12]]
	   *
	   * @param {*} [value]   A value of any type on which to start a chained operation.
	   * @return {math.type.Chain} The created chain
	   */
	  return typed('chain', {
	    '': function() {
	      return new type.Chain();
	    },

	    'any': function(value) {
	      return new type.Chain(value);
	    }
	  });
	}

	exports.name = 'chain';
	exports.factory = factory;


/***/ },
/* 261 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = [
	  // type
	  __webpack_require__(262),

	  // construction function
	  __webpack_require__(264)
	];


/***/ },
/* 262 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var isNumber = __webpack_require__(8).isNumber;
	var format = __webpack_require__(8).format;

	function facto